
#if (NUCODEGEN_EADC)
void EADC_Init()
{
    
/* --------------------------------------------------------------------
 * General configuration
 * ---------------------------------------------------------------------*/

    EADC_Open(NUCODEGEN_EADC_MODULE_SEL, 0);


/* --------------------------------------------------------------------
 * Advanced configuration
 * ---------------------------------------------------------------------*/

    
#if (NUCODEGEN_EADCATOFFEN)
    /* Auto power off & setup time */   
    EADC_ENABLE_AUTOFF(NUCODEGEN_EADC_MODULE_SEL, NUCODEGEN_EADCATOFFTH, NUCODEDEF_EADCATOFFPOT);
#endif /* NUCODEGEN_EADCATOFFEN */


    /* Interrupt setting */
    EADC_ENABLE_INT(NUCODEGEN_EADC_MODULE_SEL, NUCODEGEN_EADCINT);

#if (((NUCODEGEN_EADCINT)&0x1) == 0x1)
    /* Enable EADC INT0 NVIC interrupt */
    NVIC_EnableIRQ(NUCODEGEN_EADC_IRQ0_MODULE_SEL);
#endif /* (((NUCODEGEN_EADCINT)&0x1) == 0x1) */ 
#if (((NUCODEGEN_EADCINT)&0x2) == 0x2)
    /* Enable EADC INT1 NVIC interrupt */
    NVIC_EnableIRQ(NUCODEGEN_EADC_IRQ1_MODULE_SEL);
#endif /* ((NUCODEGEN_EADCINT)&0x2 == 0x2) */
#if (((NUCODEGEN_EADCINT)&0x4) == 0x4)  
    /* Enable EADC INT2 NVIC interrupt */
    NVIC_EnableIRQ(NUCODEGEN_EADC_IRQ2_MODULE_SEL);
#endif /* (((NUCODEGEN_EADCINT)&0x4) == 0x4) */
#if (((NUCODEGEN_EADCINT)&0x8) == 0x8)  
    /* Enable EADC INT3 NVIC interrupt */
    NVIC_EnableIRQ(NUCODEGEN_EADC_IRQ3_MODULE_SEL);
#endif /* (((NUCODEGEN_EADCINT)&0x8) == 0x8) */

#if (NUCODEGEN_EADCSM0EN || NUCODEGEN_EADCSM1EN || NUCODEGEN_EADCSM2EN || NUCODEGEN_EADCSM3EN || NUCODEGEN_EADCSM4EN || NUCODEGEN_EADCSM5EN || NUCODEGEN_EADCSM6EN || NUCODEGEN_EADCSM7EN || NUCODEGEN_EADCSM8EN || NUCODEGEN_EADCSM9EN || NUCODEGEN_EADCSM10EN || NUCODEGEN_EADCSM11EN || NUCODEGEN_EADCSM12EN || NUCODEGEN_EADCSM13EN || NUCODEGEN_EADCSM14EN || NUCODEGEN_EADCSM15EN || NUCODEGEN_EADCSM16EN || NUCODEGEN_EADCSM17EN || NUCODEGEN_EADCSM18EN )
/* --------------------------------------------------------------------
 * Sample module configuration 0~15 , Vbat, Temp, Vbg
 * ---------------------------------------------------------------------*/
#endif
    
#if (NUCODEGEN_EADCSM0EN)
    /* Sample module 0 */
    EADC_ConfigSampleModule(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(0), NUCODEGEN_EADCSM0TS, NUCODEDEF_EADCSM0CH);

    /* Enable interrupt and position */

#if (((NUCODEGEN_EADCSM0INTEN)&0x1) == 0x1)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(0), BIT0 );
#endif /* (((NUCODEGEN_EADCSM0INTEN)&0x1) == 0x1) */
#if (((NUCODEGEN_EADCSM0INTEN)&0x2) == 0x2) 
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(1), BIT0 );
#endif /* (((NUCODEGEN_EADCSM0INTEN)&0x2) == 0x2) */
#if (((NUCODEGEN_EADCSM0INTEN)&0x4) == 0x4)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(2), BIT0 );
#endif /* (((NUCODEGEN_EADCSM0INTEN)&0x4) == 0x4) */
#if (((NUCODEGEN_EADCSM0INTEN)&0x8) == 0x8)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(3), BIT0 );
#endif /* (((NUCODEGEN_EADCSM0INTEN)&0x8) == 0x8) */

#if (NUCODEGEN_EADCSM0IP)
    /* Interrupt start of conversion */
    EADC_ENABLE_INT_POSITION(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(0));
#endif /* NUCODEGEN_EADCSM0IP */
    
#if (NUCODEGEN_EADCSM0ADV)
    /* Advanced configuration */

    /* Trigger delay */
    EADC_SetTriggerDelayTime(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(0), NUCODEDEF_EADCSM0TD, NUCODEGEN_EADCSM0TDDIV);
    
    /* Extern sample time */
    EADC_SetExtendSampleTime(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(0), NUCODEDEF_EADCSM0ES);
    
#if (NUCODEGEN_EADCSM0DMA)
    /* Enable DMA support */    
    EADC_ENABLE_PDMA(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(0));
#endif /* NUCODEGEN_EADCSM0DMA */
    
#if (NUCODEGEN_EADCSM0ALIGN)
    /* Enable data left alignment */
    EADC_ENABLE_LEFT_ALIGN(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(0));
#endif /* NUCODEGEN_EADCSM0ALIGN */
 
#if (NUCODEGEN_EADCSM0MODE == 1)
    /* Enable accumulate */
    EADC_ENABLE_ACU(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(0), NUCODEGEN_EADCSM0ACCU);
#elif (NUCODEGEN_EADCSM0MODE == 2)
    /* Enable average */
    EADC_ENABLE_ACU(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(0), NUCODEGEN_EADCSM0AVG);
    EADC_ENABLE_AVG(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(0));
#endif /* NUCODEGEN_EADCSM0MODE */

#endif /* NUCODEGEN_EADCSM0ADV */

#endif /* NUCODEGEN_EADCSM0EN */



    
#if (NUCODEGEN_EADCSM1EN)
    /* Sample module 1 */
    EADC_ConfigSampleModule(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(1), NUCODEGEN_EADCSM1TS, NUCODEDEF_EADCSM1CH);

    /* Enable interrupt and position */

#if (((NUCODEGEN_EADCSM1INTEN)&0x1) == 0x1)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(0), BIT1 );
#endif /* (((NUCODEGEN_EADCSM1INTEN)&0x1) == 0x1) */
#if (((NUCODEGEN_EADCSM1INTEN)&0x2) == 0x2) 
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(1), BIT1 );
#endif /* (((NUCODEGEN_EADCSM1INTEN)&0x2) == 0x2) */
#if (((NUCODEGEN_EADCSM1INTEN)&0x4) == 0x4)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(2), BIT1 );
#endif /* (((NUCODEGEN_EADCSM1INTEN)&0x4) == 0x4) */
#if (((NUCODEGEN_EADCSM1INTEN)&0x8) == 0x8)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(3), BIT1 );
#endif /* (((NUCODEGEN_EADCSM1INTEN)&0x8) == 0x8) */

#if (NUCODEGEN_EADCSM1IP)
    /* Interrupt start of conversion */
    EADC_ENABLE_INT_POSITION(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(1));
#endif /* NUCODEGEN_EADCSM1IP */
     
#if (NUCODEGEN_EADCSM1ADV)
    /* Advanced configuration */

    /* Trigger delay */ 
    EADC_SetTriggerDelayTime(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(1), NUCODEDEF_EADCSM1TD, NUCODEGEN_EADCSM1TDDIV);
    
    /* Extern sample time */
    EADC_SetExtendSampleTime(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(1), NUCODEDEF_EADCSM1ES);

#if (NUCODEGEN_EADCSM1DMA)
    /* Enable DMA support */    
    EADC_ENABLE_PDMA(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(1));
#endif /* NUCODEGEN_EADCSM1DMA */
    
#if (NUCODEGEN_EADCSM1ALIGN)
    /* Enable data left alignment */
    EADC_ENABLE_LEFT_ALIGN(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(1));
#endif /* NUCODEGEN_EADCSM1ALIGN */

#if (NUCODEGEN_EADCSM1MODE == 1)
    /* Enable accumulate */
    EADC_ENABLE_ACU(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(1), NUCODEGEN_EADCSM1ACCU);
#elif (NUCODEGEN_EADCSM1MODE == 2)
    /* Enable average */
    EADC_ENABLE_ACU(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(1), NUCODEGEN_EADCSM1AVG);
    EADC_ENABLE_AVG(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(1));
#endif /* NUCODEGEN_EADCSM1MODE */

#endif /* NUCODEGEN_EADCSM1ADV */

#endif /* NUCODEGEN_EADCSM1EN */



    
#if (NUCODEGEN_EADCSM2EN)
    /* Sample module 2 */
    EADC_ConfigSampleModule(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(2), NUCODEGEN_EADCSM2TS, NUCODEDEF_EADCSM2CH);

    /* Enable interrupt and position */

#if (((NUCODEGEN_EADCSM2INTEN)&0x1) == 0x1)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(0), BIT2 );
#endif /* (((NUCODEGEN_EADCSM2INTEN)&0x1) == 0x1) */
#if (((NUCODEGEN_EADCSM2INTEN)&0x2) == 0x2) 
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(1), BIT2 );
#endif /* (((NUCODEGEN_EADCSM2INTEN)&0x2) == 0x2) */
#if (((NUCODEGEN_EADCSM2INTEN)&0x4) == 0x4)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(2), BIT2 );
#endif /* (((NUCODEGEN_EADCSM2INTEN)&0x4) == 0x4) */
#if (((NUCODEGEN_EADCSM2INTEN)&0x8) == 0x8)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(3), BIT2 );
#endif /* (((NUCODEGEN_EADCSM2INTEN)&0x8) == 0x8) */

#if (NUCODEGEN_EADCSM2IP)
    /* Interrupt start of conversion */
    EADC_ENABLE_INT_POSITION(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(2));
#endif /* NUCODEGEN_EADCSM2IP */
   
#if (NUCODEGEN_EADCSM2ADV)
    /* Advanced configuration */

    /* Trigger delay */ 
    EADC_SetTriggerDelayTime(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(2), NUCODEDEF_EADCSM2TD, NUCODEGEN_EADCSM2TDDIV);
    
    /* Extern sample time */
    EADC_SetExtendSampleTime(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(2), NUCODEDEF_EADCSM2ES);

    
#if (NUCODEGEN_EADCSM2DMA)
    /* Enable DMA support */    
    EADC_ENABLE_PDMA(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(2));
#endif /* NUCODEGEN_EADCSM2DMA */

#if (NUCODEGEN_EADCSM2ALIGN)
    /* Enable data left alignment */
    EADC_ENABLE_LEFT_ALIGN(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(2));
#endif /* NUCODEGEN_EADCSM2ALIGN */
 
#if (NUCODEGEN_EADCSM2MODE == 1)
    /* Enable accumulate */
    EADC_ENABLE_ACU(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(2), NUCODEGEN_EADCSM2ACCU);
#elif (NUCODEGEN_EADCSM2MODE == 2)
    /* Enable average */
    EADC_ENABLE_ACU(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(2), NUCODEGEN_EADCSM2AVG);
    EADC_ENABLE_AVG(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(2));
#endif /* NUCODEGEN_EADCSM2MODE */

#endif /* NUCODEGEN_EADCSM2ADV */

#endif /* NUCODEGEN_EADCSM2EN */



    
#if (NUCODEGEN_EADCSM3EN)
    /* Sample module 3 */
    EADC_ConfigSampleModule(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(3), NUCODEGEN_EADCSM3TS, NUCODEDEF_EADCSM3CH);

    /* Enable interrupt and position */

#if (((NUCODEGEN_EADCSM3INTEN)&0x1) == 0x1)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(0), BIT3 );
#endif /* (((NUCODEGEN_EADCSM3INTEN)&0x1) == 0x1) */
#if (((NUCODEGEN_EADCSM3INTEN)&0x2) == 0x2) 
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(1), BIT3 );
#endif /* (((NUCODEGEN_EADCSM3INTEN)&0x2) == 0x2) */
#if (((NUCODEGEN_EADCSM3INTEN)&0x4) == 0x4)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(2), BIT3 );
#endif /* (((NUCODEGEN_EADCSM3INTEN)&0x4) == 0x4) */
#if (((NUCODEGEN_EADCSM3INTEN)&0x8) == 0x8)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(3), BIT3 );
#endif /* (((NUCODEGEN_EADCSM3INTEN)&0x8) == 0x8) */

#if (NUCODEGEN_EADCSM3IP)
    /* Interrupt start of conversion */
    EADC_ENABLE_INT_POSITION(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(3));
#endif /* NUCODEGEN_EADCSM3IP */

#if (NUCODEGEN_EADCSM3ADV)
    /* Advanced configuration */

    /* Trigger delay */
    EADC_SetTriggerDelayTime(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(3), NUCODEDEF_EADCSM3TD, NUCODEGEN_EADCSM3TDDIV);
    
    /* Extern sample time */
    EADC_SetExtendSampleTime(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(3), NUCODEDEF_EADCSM3ES);

#if (NUCODEGEN_EADCSM3DMA)
    /* Enable DMA support */    
    EADC_ENABLE_PDMA(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(3));
#endif /* NUCODEGEN_EADCSM3DMA */

#if (NUCODEGEN_EADCSM3ALIGN)
    /* Enable data left alignment */
    EADC_ENABLE_LEFT_ALIGN(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(3));
#endif /* NUCODEGEN_EADCSM3ALIGN */
 
#if (NUCODEGEN_EADCSM3MODE == 1)
    /* Enable accumulate */
    EADC_ENABLE_ACU(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(3), NUCODEGEN_EADCSM3ACCU);
#elif (NUCODEGEN_EADCSM3MODE == 2)
    /* Enable average */
    EADC_ENABLE_ACU(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(3), NUCODEGEN_EADCSM3AVG);
    EADC_ENABLE_AVG(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(3));
#endif /* NUCODEGEN_EADCSM3MODE */

#endif /* NUCODEGEN_EADCSM3ADV */

#endif /* NUCODEGEN_EADCSM3EN */



    
#if (NUCODEGEN_EADCSM4EN)
    /* Sample module 4 */
    EADC_ConfigSampleModule(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(4), NUCODEGEN_EADCSM4TS, NUCODEDEF_EADCSM4CH);

    /* Enable interrupt and position */

#if (((NUCODEGEN_EADCSM4INTEN)&0x1) == 0x1)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(0), BIT4 );
#endif /* (((NUCODEGEN_EADCSM4INTEN)&0x1) == 0x1) */
#if (((NUCODEGEN_EADCSM4INTEN)&0x2) == 0x2) 
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(1), BIT4 );
#endif /* (((NUCODEGEN_EADCSM4INTEN)&0x2) == 0x2) */
#if (((NUCODEGEN_EADCSM4INTEN)&0x4) == 0x4)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(2), BIT4 );
#endif /* (((NUCODEGEN_EADCSM4INTEN)&0x4) == 0x4) */
#if (((NUCODEGEN_EADCSM4INTEN)&0x8) == 0x8)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(3), BIT4 );
#endif /* (((NUCODEGEN_EADCSM4INTEN)&0x8) == 0x8) */

#if (NUCODEGEN_EADCSM4IP)
    /* Interrupt start of conversion */
    EADC_ENABLE_INT_POSITION(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(4));
#endif /* NUCODEGEN_EADCSM4IP */
 
#if (NUCODEGEN_EADCSM4ADV)
    /* Advanced configuration */

    /* Trigger delay */
    EADC_SetTriggerDelayTime(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(4), NUCODEDEF_EADCSM4TD, NUCODEGEN_EADCSM4TDDIV);
    
    /* Extern sample time */
    EADC_SetExtendSampleTime(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(4), NUCODEDEF_EADCSM4ES);

#if (NUCODEGEN_EADCSM4DMA)
    /* Enable DMA support */    
    EADC_ENABLE_PDMA(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(4));
#endif /* NUCODEGEN_EADCSM4DMA */
    
#if (NUCODEGEN_EADCSM4ALIGN)
    /* Enable data left alignment */
    EADC_ENABLE_LEFT_ALIGN(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(4));
#endif /* NUCODEGEN_EADCSM4ALIGN */

#if (NUCODEGEN_EADCSM4MODE == 1)
    /* Enable accumulate */
    EADC_ENABLE_ACU(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(4), NUCODEGEN_EADCSM4ACCU);
#elif (NUCODEGEN_EADCSM4MODE == 2)
    /* Enable average */
    EADC_ENABLE_ACU(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(4), NUCODEGEN_EADCSM4AVG);
    EADC_ENABLE_AVG(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(4));
#endif /* NUCODEGEN_EADCSM4MODE */

#endif /* NUCODEGEN_EADCSM4ADV */

#endif /* NUCODEGEN_EADCSM4EN */



    
#if (NUCODEGEN_EADCSM5EN)
    /* Sample module 5 */
    EADC_ConfigSampleModule(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(5), NUCODEGEN_EADCSM5TS, NUCODEDEF_EADCSM5CH);

    /* Enable interrupt and position */

#if (((NUCODEGEN_EADCSM5INTEN)&0x1) == 0x1)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(0), BIT5 );
#endif /* (((NUCODEGEN_EADCSM5INTEN)&0x1) == 0x1) */
#if (((NUCODEGEN_EADCSM5INTEN)&0x2) == 0x2) 
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(1), BIT5 );
#endif /* (((NUCODEGEN_EADCSM5INTEN)&0x2) == 0x2) */
#if (((NUCODEGEN_EADCSM5INTEN)&0x4) == 0x4)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(2), BIT5 );
#endif /* (((NUCODEGEN_EADCSM5INTEN)&0x4) == 0x4) */
#if (((NUCODEGEN_EADCSM5INTEN)&0x8) == 0x8)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(3), BIT5 );
#endif /* (((NUCODEGEN_EADCSM5INTEN)&0x8) == 0x8) */

#if (NUCODEGEN_EADCSM5IP)
    /* Interrupt start of conversion */
    EADC_ENABLE_INT_POSITION(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(5));
#endif /* NUCODEGEN_EADCSM5IP */
 
#if (NUCODEGEN_EADCSM5ADV)
    /* Advanced configuration */

    /* Trigger delay */
    EADC_SetTriggerDelayTime(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(5), NUCODEDEF_EADCSM5TD, NUCODEGEN_EADCSM5TDDIV);
    
    /* Extern sample time */
    EADC_SetExtendSampleTime(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(5), NUCODEDEF_EADCSM5ES);

    
#if (NUCODEGEN_EADCSM5DMA)
    /* Enable DMA support */    
    EADC_ENABLE_PDMA(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(5));
#endif /* NUCODEGEN_EADCSM5DMA */

#if (NUCODEGEN_EADCSM5ALIGN)
    /* Enable data left alignment */
    EADC_ENABLE_LEFT_ALIGN(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(5));
#endif /* NUCODEGEN_EADCSM5ALIGN */

#if (NUCODEGEN_EADCSM5MODE == 1)
    /* Enable accumulate */
    EADC_ENABLE_ACU(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(5), NUCODEGEN_EADCSM5ACCU);
#elif (NUCODEGEN_EADCSM5MODE == 2)
    /* Enable average */
    EADC_ENABLE_ACU(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(5), NUCODEGEN_EADCSM5AVG);
    EADC_ENABLE_AVG(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(5));
#endif /* NUCODEGEN_EADCSM5MODE */

#endif /* NUCODEGEN_EADCSM5ADV */

#endif /* NUCODEGEN_EADCSM5EN */



    
#if (NUCODEGEN_EADCSM6EN)
    /* Sample module 6 */
    EADC_ConfigSampleModule(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(6), NUCODEGEN_EADCSM6TS, NUCODEDEF_EADCSM6CH);

    /* Enable interrupt and position */

#if (((NUCODEGEN_EADCSM6INTEN)&0x1) == 0x1)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(0), BIT6 );
#endif /* (((NUCODEGEN_EADCSM6INTEN)&0x1) == 0x1) */
#if (((NUCODEGEN_EADCSM6INTEN)&0x2) == 0x2) 
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(1), BIT6 );
#endif /* (((NUCODEGEN_EADCSM6INTEN)&0x2) == 0x2) */
#if (((NUCODEGEN_EADCSM6INTEN)&0x4) == 0x4)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(2), BIT6 );
#endif /* (((NUCODEGEN_EADCSM6INTEN)&0x4) == 0x4) */
#if (((NUCODEGEN_EADCSM6INTEN)&0x8) == 0x8)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(3), BIT6 );
#endif /* (((NUCODEGEN_EADCSM6INTEN)&0x8) == 0x8) */

#if (NUCODEGEN_EADCSM6IP)
    /* Interrupt start of conversion */
    EADC_ENABLE_INT_POSITION(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(6));
#endif /* NUCODEGEN_EADCSM6IP */
 
#if (NUCODEGEN_EADCSM6ADV)
    /* Advanced configuration */

    /* Trigger delay */
    EADC_SetTriggerDelayTime(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(6), NUCODEDEF_EADCSM6TD, NUCODEGEN_EADCSM6TDDIV);
    
    /* Extern sample time */
    EADC_SetExtendSampleTime(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(6), NUCODEDEF_EADCSM6ES);


#if (NUCODEGEN_EADCSM6DMA)
    /* Enable DMA support */    
    EADC_ENABLE_PDMA(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(6));
#endif /* NUCODEGEN_EADCSM6DMA */
    
#if (NUCODEGEN_EADCSM6ALIGN)
    /* Enable data left alignment */
    EADC_ENABLE_LEFT_ALIGN(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(6));
#endif /* NUCODEGEN_EADCSM6ALIGN */

#if (NUCODEGEN_EADCSM6MODE == 1)
    /* Enable accumulate */
    EADC_ENABLE_ACU(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(6), NUCODEGEN_EADCSM6ACCU);
#elif (NUCODEGEN_EADCSM6MODE == 2)
    /* Enable average */
    EADC_ENABLE_ACU(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(6), NUCODEGEN_EADCSM6AVG);
    EADC_ENABLE_AVG(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(6));
#endif /* NUCODEGEN_EADCSM6MODE */

#endif /* NUCODEGEN_EADCSM6ADV */

#endif /* NUCODEGEN_EADCSM6EN */



    
#if (NUCODEGEN_EADCSM7EN)
    /* Sample module 7 */
    EADC_ConfigSampleModule(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(7), NUCODEGEN_EADCSM7TS, NUCODEDEF_EADCSM7CH);

    /* Enable interrupt and position */

#if (((NUCODEGEN_EADCSM7INTEN)&0x1) == 0x1)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(0), BIT7 );
#endif /* (((NUCODEGEN_EADCSM7INTEN)&0x1) == 0x1) */
#if (((NUCODEGEN_EADCSM7INTEN)&0x2) == 0x2) 
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(1), BIT7 );
#endif /* (((NUCODEGEN_EADCSM7INTEN)&0x2) == 0x2) */
#if (((NUCODEGEN_EADCSM7INTEN)&0x4) == 0x4)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(2), BIT7 );
#endif /* (((NUCODEGEN_EADCSM7INTEN)&0x4) == 0x4) */
#if (((NUCODEGEN_EADCSM7INTEN)&0x8) == 0x8)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(3), BIT7 );
#endif /* (((NUCODEGEN_EADCSM7INTEN)&0x8) == 0x8) */

#if (NUCODEGEN_EADCSM7IP)
    /* Interrupt start of conversion */
    EADC_ENABLE_INT_POSITION(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(7));
#endif /* NUCODEGEN_EADCSM7IP */
 
#if (NUCODEGEN_EADCSM7ADV)
    /* Advanced configuration */

    /* Trigger delay */
    EADC_SetTriggerDelayTime(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(7), NUCODEDEF_EADCSM7TD, NUCODEGEN_EADCSM7TDDIV);
    
    /* Extern sample time */
    EADC_SetExtendSampleTime(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(7), NUCODEDEF_EADCSM7ES);

#if (NUCODEGEN_EADCSM7DMA)
    /* Enable DMA support */    
    EADC_ENABLE_PDMA(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(7));
#endif /* NUCODEGEN_EADCSM7DMA */

#if (NUCODEGEN_EADCSM7ALIGN)
    /* Enable data left alignment */
    EADC_ENABLE_LEFT_ALIGN(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(7));
#endif /* NUCODEGEN_EADCSM7ALIGN */

#if (NUCODEGEN_EADCSM7MODE == 1)
    /* Enable accumulate */
    EADC_ENABLE_ACU(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(7), NUCODEGEN_EADCSM7ACCU);
#elif (NUCODEGEN_EADCSM7MODE == 2)
    /* Enable average */
    EADC_ENABLE_ACU(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(7), NUCODEGEN_EADCSM7AVG);
    EADC_ENABLE_AVG(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(7));
#endif /* NUCODEGEN_EADCSM7MODE */

#endif /* NUCODEGEN_EADCSM7ADV */

#endif /* NUCODEGEN_EADCSM7EN */



    
#if (NUCODEGEN_EADCSM8EN)
    /* Sample module 8 */
    EADC_ConfigSampleModule(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(8), NUCODEGEN_EADCSM8TS, NUCODEDEF_EADCSM8CH);

    /* Enable interrupt and position */

#if (((NUCODEGEN_EADCSM8INTEN)&0x1) == 0x1)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(0), BIT8 );
#endif /* (((NUCODEGEN_EADCSM8INTEN)&0x1) == 0x1) */
#if (((NUCODEGEN_EADCSM8INTEN)&0x2) == 0x2) 
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(1), BIT8 );
#endif /* (((NUCODEGEN_EADCSM8INTEN)&0x2) == 0x2) */
#if (((NUCODEGEN_EADCSM8INTEN)&0x4) == 0x4)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(2), BIT8 );
#endif /* (((NUCODEGEN_EADCSM8INTEN)&0x4) == 0x4) */
#if (((NUCODEGEN_EADCSM8INTEN)&0x8) == 0x8)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(3), BIT8 );
#endif /* (((NUCODEGEN_EADCSM8INTEN)&0x8) == 0x8) */

#if (NUCODEGEN_EADCSM8IP)
    /* Interrupt start of conversion */
    EADC_ENABLE_INT_POSITION(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(8));
#endif /* NUCODEGEN_EADCSM8IP */
 
#if (NUCODEGEN_EADCSM8ADV)
    /* Advanced configuration */

    /* Trigger delay */ 
    EADC_SetTriggerDelayTime(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(8), NUCODEDEF_EADCSM8TD, NUCODEGEN_EADCSM8TDDIV);
    
    /* Extern sample time */
    EADC_SetExtendSampleTime(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(8), NUCODEDEF_EADCSM8ES);

    
#if (NUCODEGEN_EADCSM8DMA)
    /* Enable DMA support */    
    EADC_ENABLE_PDMA(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(8));
#endif /* NUCODEGEN_EADCSM8DMA */

#if (NUCODEGEN_EADCSM8ALIGN)
    /* Enable data left alignment */
    EADC_ENABLE_LEFT_ALIGN(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(8));
#endif /* NUCODEGEN_EADCSM8ALIGN */

#if (NUCODEGEN_EADCSM8MODE == 1)
    /* Enable accumulate */
    EADC_ENABLE_ACU(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(8), NUCODEGEN_EADCSM8ACCU);
#elif (NUCODEGEN_EADCSM8MODE == 2)
    /* Enable average */
    EADC_ENABLE_ACU(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(8), NUCODEGEN_EADCSM8AVG);
    EADC_ENABLE_AVG(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(8));
#endif /* NUCODEGEN_EADCSM8MODE */

#endif /* NUCODEGEN_EADCSM8ADV */

#endif /* NUCODEGEN_EADCSM8EN */



    
#if (NUCODEGEN_EADCSM9EN)
    /* Sample module 9 */
    EADC_ConfigSampleModule(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(9), NUCODEGEN_EADCSM9TS, NUCODEDEF_EADCSM9CH);

    /* Enable interrupt and position */

#if (((NUCODEGEN_EADCSM9INTEN)&0x1) == 0x1)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(0), BIT9 );
#endif /* (((NUCODEGEN_EADCSM9INTEN)&0x1) == 0x1) */
#if (((NUCODEGEN_EADCSM9INTEN)&0x2) == 0x2) 
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(1), BIT9 );
#endif /* (((NUCODEGEN_EADCSM9INTEN)&0x2) == 0x2) */
#if (((NUCODEGEN_EADCSM9INTEN)&0x4) == 0x4)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(2), BIT9 );
#endif /* (((NUCODEGEN_EADCSM9INTEN)&0x4) == 0x4) */
#if (((NUCODEGEN_EADCSM9INTEN)&0x8) == 0x8)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(3), BIT9 );
#endif /* (((NUCODEGEN_EADCSM9INTEN)&0x8) == 0x8) */

#if (NUCODEGEN_EADCSM9IP)
    /* Interrupt start of conversion */
    EADC_ENABLE_INT_POSITION(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(9));
#endif /* NUCODEGEN_EADCSM9IP */
 
#if (NUCODEGEN_EADCSM9ADV)
    /* Advanced configuration */    
    
    /* Trigger delay */
    EADC_SetTriggerDelayTime(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(9), NUCODEDEF_EADCSM9TD, NUCODEGEN_EADCSM9TDDIV);
    
    /* Extern sample time */
    EADC_SetExtendSampleTime(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(9), NUCODEDEF_EADCSM9ES);

#if (NUCODEGEN_EADCSM9DMA) 
    /* Enable DMA support */
    EADC_ENABLE_PDMA(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(9));
#endif /* NUCODEGEN_EADCSM9DMA */

#if (NUCODEGEN_EADCSM9ALIGN)
    /* Enable data left alignment */
    EADC_ENABLE_LEFT_ALIGN(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(9));
#endif /* NUCODEGEN_EADCSM9ALIGN */

#if (NUCODEGEN_EADCSM9MODE == 1)
    /* Enable accumulate */
    EADC_ENABLE_ACU(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(9), NUCODEGEN_EADCSM9ACCU);
#elif (NUCODEGEN_EADCSM9MODE == 2)
    /* Enable average */
    EADC_ENABLE_ACU(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(9), NUCODEGEN_EADCSM9AVG);
    EADC_ENABLE_AVG(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(9));
#endif /* NUCODEGEN_EADCSM9MODE */

#endif /* NUCODEGEN_EADCSM9ADV */

#endif /* NUCODEGEN_EADCSM9EN */




#if (NUCODEGEN_EADCSM10EN)
    /* Sample module 10 */
    EADC_ConfigSampleModule(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(10), NUCODEGEN_EADCSM10TS, NUCODEDEF_EADCSM10CH);

    /* Enable interrupt and position */

#if (((NUCODEGEN_EADCSM10INTEN)&0x1) == 0x1)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(0), BIT10 );
#endif /* (((NUCODEGEN_EADCSM10INTEN)&0x1) == 0x1) */
#if (((NUCODEGEN_EADCSM10INTEN)&0x2) == 0x2) 
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(1), BIT10 );
#endif /* (((NUCODEGEN_EADCSM10INTEN)&0x2) == 0x2) */
#if (((NUCODEGEN_EADCSM10INTEN)&0x4) == 0x4)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(2), BIT10 );
#endif /* (((NUCODEGEN_EADCSM10INTEN)&0x4) == 0x4) */
#if (((NUCODEGEN_EADCSM10INTEN)&0x8) == 0x8)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(3), BIT10 );
#endif /* (((NUCODEGEN_EADCSM10INTEN)&0x8) == 0x8) */

#if (NUCODEGEN_EADCSM10IP)
    /* Interrupt start of conversion */
    EADC_ENABLE_INT_POSITION(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(10));
#endif /* NUCODEGEN_EADCSM10IP */
 
#if (NUCODEGEN_EADCSM10ADV)
    /* Advanced configuration */

    /* Trigger delay */
    EADC_SetTriggerDelayTime(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(10), NUCODEDEF_EADCSM10TD, NUCODEGEN_EADCSM10TDDIV);
    
    /* Extern sample time */
    EADC_SetExtendSampleTime(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(10), NUCODEDEF_EADCSM10ES);

#if (NUCODEGEN_EADCSM10DMA) 
    /* Enable DMA support */
    EADC_ENABLE_PDMA(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(10));
#endif /* NUCODEGEN_EADCSM10DMA */

#if (NUCODEGEN_EADCSM10ALIGN)
    /* Enable data left alignment */
    EADC_ENABLE_LEFT_ALIGN(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(10));
#endif /* NUCODEGEN_EADCSM10ALIGN */

#if (NUCODEGEN_EADCSM10MODE == 1)
    /* Enable accumulate */
    EADC_ENABLE_ACU(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(10), NUCODEGEN_EADCSM10ACCU);
#elif (NUCODEGEN_EADCSM10MODE == 2)
    /* Enable average */
    EADC_ENABLE_ACU(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(10), NUCODEGEN_EADCSM10AVG);
    EADC_ENABLE_AVG(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(10));
#endif /* NUCODEGEN_EADCSM10MODE */

#endif /* NUCODEGEN_EADCSM10ADV */

#endif /* NUCODEGEN_EADCSM10EN */



    
#if (NUCODEGEN_EADCSM11EN)
    /* Sample module 11 */
    EADC_ConfigSampleModule(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(11), NUCODEGEN_EADCSM11TS, NUCODEDEF_EADCSM11CH);

    /* Enable interrupt and position */

#if (((NUCODEGEN_EADCSM11INTEN)&0x1) == 0x1)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(0), BIT11 );
#endif /* (((NUCODEGEN_EADCSM11INTEN)&0x1) == 0x1) */
#if (((NUCODEGEN_EADCSM11INTEN)&0x2) == 0x2) 
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(1), BIT11 );
#endif /* (((NUCODEGEN_EADCSM11INTEN)&0x2) == 0x2) */
#if (((NUCODEGEN_EADCSM11INTEN)&0x4) == 0x4)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(2), BIT11 );
#endif /* (((NUCODEGEN_EADCSM11INTEN)&0x4) == 0x4) */
#if (((NUCODEGEN_EADCSM11INTEN)&0x8) == 0x8)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(3), BIT11 );
#endif /* (((NUCODEGEN_EADCSM11INTEN)&0x8) == 0x8) */

#if (NUCODEGEN_EADCSM11IP)
    /* Interrupt start of conversion */
    EADC_ENABLE_INT_POSITION(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(11));
#endif /* NUCODEGEN_EADCSM11IP */
 
#if (NUCODEGEN_EADCSM11ADV)
    /* Advanced configuration*/

    /* Trigger delay */
    EADC_SetTriggerDelayTime(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(11), NUCODEDEF_EADCSM11TD, NUCODEGEN_EADCSM11TDDIV);
    
    /* Extern sample time */
    EADC_SetExtendSampleTime(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(11), NUCODEDEF_EADCSM11ES);

#if (NUCODEGEN_EADCSM11DMA)
    /* Enable DMA support */    
    EADC_ENABLE_PDMA(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(11));
#endif /* NUCODEGEN_EADCSM11DMA */

#if (NUCODEGEN_EADCSM11ALIGN)
    /* Enable data left alignment */
    EADC_ENABLE_LEFT_ALIGN(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(11));
#endif /* NUCODEGEN_EADCSM11ALIGN */

#if (NUCODEGEN_EADCSM11MODE == 1)
    /* Enable accumulate */
    EADC_ENABLE_ACU(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(11), NUCODEGEN_EADCSM11ACCU);
#elif (NUCODEGEN_EADCSM11MODE == 2)
    /* Enable average */
    EADC_ENABLE_ACU(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(11), NUCODEGEN_EADCSM11AVG);
    EADC_ENABLE_AVG(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(11));
#endif /* NUCODEGEN_EADCSM11MODE */

#endif /* NUCODEGEN_EADCSM11ADV */

#endif /* NUCODEGEN_EADCSM11EN */




#if (NUCODEGEN_EADCSM12EN)
    /* Sample module 12 */
    EADC_ConfigSampleModule(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(12), NUCODEGEN_EADCSM12TS, NUCODEDEF_EADCSM12CH);

    /* Enable interrupt and position */

#if (((NUCODEGEN_EADCSM12INTEN)&0x1) == 0x1)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(0), BIT12 );
#endif /* (((NUCODEGEN_EADCSM12INTEN)&0x1) == 0x1) */
#if (((NUCODEGEN_EADCSM12INTEN)&0x2) == 0x2) 
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(1), BIT12 );
#endif /* (((NUCODEGEN_EADCSM12INTEN)&0x2) == 0x2) */
#if (((NUCODEGEN_EADCSM12INTEN)&0x4) == 0x4)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(2), BIT12 );
#endif /* (((NUCODEGEN_EADCSM12INTEN)&0x4) == 0x4) */
#if (((NUCODEGEN_EADCSM12INTEN)&0x8) == 0x8)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(3), BIT12 );
#endif /* (((NUCODEGEN_EADCSM12INTEN)&0x8) == 0x8) */

#if (NUCODEGEN_EADCSM12IP)
    /* Interrupt start of conversion */
    EADC_ENABLE_INT_POSITION(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(12));
#endif /* NUCODEGEN_EADCSM12IP */

#if (NUCODEGEN_EADCSM12ADV)
    /* Advanced configuration */

    /* Trigger delay */
    EADC_SetTriggerDelayTime(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(12), NUCODEDEF_EADCSM12TD, NUCODEGEN_EADCSM12TDDIV);
    
    /* Extern sample time */
    EADC_SetExtendSampleTime(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(12), NUCODEDEF_EADCSM12ES);

#if (NUCODEGEN_EADCSM12DMA)
    /* Enable DMA support */    
    EADC_ENABLE_PDMA(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(12));
#endif /* NUCODEGEN_EADCSM12DMA */

#if (NUCODEGEN_EADCSM12ALIGN)
    /* Enable data left alignment */
    EADC_ENABLE_LEFT_ALIGN(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(12));
#endif /* NUCODEGEN_EADCSM12ALIGN */

#if (NUCODEGEN_EADCSM12MODE == 1)
    /* Enable accumulate */
    EADC_ENABLE_ACU(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(12), NUCODEGEN_EADCSM12ACCU);
#elif (NUCODEGEN_EADCSM12MODE == 2)
    /* Enable average */
    EADC_ENABLE_ACU(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(12), NUCODEGEN_EADCSM12AVG);
    EADC_ENABLE_AVG(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(12));
#endif /* NUCODEGEN_EADCSM12MODE */

#endif /* NUCODEGEN_EADCSM12ADV */

#endif /* NUCODEGEN_EADCSM12EN */



#if (NUCODEGEN_EADCSM13EN)
    /* Sample module 13 */
    EADC_ConfigSampleModule(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(13), NUCODEGEN_EADCSM13TS, NUCODEDEF_EADCSM13CH);

    /* Enable interrupt and position */

#if (((NUCODEGEN_EADCSM13INTEN)&0x1) == 0x1)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(0), BIT13 );
#endif /* (((NUCODEGEN_EADCSM13INTEN)&0x1) == 0x1) */
#if (((NUCODEGEN_EADCSM13INTEN)&0x2) == 0x2) 
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(1), BIT13 );
#endif /* (((NUCODEGEN_EADCSM13INTEN)&0x2) == 0x2) */
#if (((NUCODEGEN_EADCSM13INTEN)&0x4) == 0x4)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(2), BIT13 );
#endif /* (((NUCODEGEN_EADCSM13INTEN)&0x4) == 0x4) */
#if (((NUCODEGEN_EADCSM13INTEN)&0x8) == 0x8)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(3), BIT13 );
#endif /* (((NUCODEGEN_EADCSM13INTEN)&0x8) == 0x8) */

#if (NUCODEGEN_EADCSM13IP)
    /* Interrupt start of conversion */
    EADC_ENABLE_INT_POSITION(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(13));
#endif /* NUCODEGEN_EADCSM13IP */
 
#if (NUCODEGEN_EADCSM13ADV)
    /* Advanced configuration */

    /* Trigger delay */
    EADC_SetTriggerDelayTime(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(13), NUCODEDEF_EADCSM13TD, NUCODEGEN_EADCSM13TDDIV);

    /* Extern sample time */
    EADC_SetExtendSampleTime(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(13), NUCODEDEF_EADCSM13ES);

#if (NUCODEGEN_EADCSM13DMA)
    /* Enable DMA support */    
    EADC_ENABLE_PDMA(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(13));
#endif /* NUCODEGEN_EADCSM13DMA */

#if (NUCODEGEN_EADCSM13ALIGN)
    /* Enable data left alignment */
    EADC_ENABLE_LEFT_ALIGN(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(13));
#endif /* NUCODEGEN_EADCSM13ALIGN */

#if (NUCODEGEN_EADCSM13MODE == 1)
    /* Enable accumulate */
    EADC_ENABLE_ACU(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(13), NUCODEGEN_EADCSM13ACCU);
#elif (NUCODEGEN_EADCSM13MODE == 2)
    /* Enable average */
    EADC_ENABLE_ACU(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(13), NUCODEGEN_EADCSM13AVG);
    EADC_ENABLE_AVG(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(13));
#endif /* NUCODEGEN_EADCSM13MODE */

#endif /* NUCODEGEN_EADCSM13ADV */

#endif /* NUCODEGEN_EADCSM13EN */



#if (NUCODEGEN_EADCSM14EN)
    /* Sample module 14 */
    EADC_ConfigSampleModule(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(14), NUCODEGEN_EADCSM14TS, NUCODEDEF_EADCSM14CH);

    /* Enable interrupt and position */

#if (((NUCODEGEN_EADCSM14INTEN)&0x1) == 0x1)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(0), BIT14 );
#endif /* (((NUCODEGEN_EADCSM14INTEN)&0x1) == 0x1) */
#if (((NUCODEGEN_EADCSM14INTEN)&0x2) == 0x2) 
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(1), BIT14 );
#endif /* (((NUCODEGEN_EADCSM14INTEN)&0x2) == 0x2) */
#if (((NUCODEGEN_EADCSM14INTEN)&0x4) == 0x4)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(2), BIT14 );
#endif /* (((NUCODEGEN_EADCSM14INTEN)&0x4) == 0x4) */
#if (((NUCODEGEN_EADCSM14INTEN)&0x8) == 0x8)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(3), BIT14 );
#endif /* (((NUCODEGEN_EADCSM14INTEN)&0x8) == 0x8) */

#if (NUCODEGEN_EADCSM14IP)
    /* Interrupt start of conversion */
    EADC_ENABLE_INT_POSITION(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(14));
#endif /* NUCODEGEN_EADCSM14IP */
 
#if (NUCODEGEN_EADCSM14ADV)
    /* Advanced configuration */

    /* Trigger delay */
    EADC_SetTriggerDelayTime(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(14), NUCODEDEF_EADCSM14TD, NUCODEGEN_EADCSM14TDDIV);
    
    /* Extern sample time */
    EADC_SetExtendSampleTime(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(14), NUCODEDEF_EADCSM14ES);

    /* Enable DMA support */
#if (NUCODEGEN_EADCSM14DMA) 
    EADC_ENABLE_PDMA(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(14));
#endif /* NUCODEGEN_EADCSM14DMA */

    /* Enable data left alignment */
#if (NUCODEGEN_EADCSM14ALIGN)
    EADC_ENABLE_LEFT_ALIGN(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(14));
#endif /* NUCODEGEN_EADCSM14ALIGN */

#if (NUCODEGEN_EADCSM14MODE == 1)
    /* Enable accumulate */
    EADC_ENABLE_ACU(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(14), NUCODEGEN_EADCSM14ACCU);
#elif (NUCODEGEN_EADCSM14MODE == 2)
    /* Enable average */
    EADC_ENABLE_ACU(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(14), NUCODEGEN_EADCSM14AVG);
    EADC_ENABLE_AVG(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(14));
#endif /* NUCODEGEN_EADCSM14MODE */

#endif /* NUCODEGEN_EADCSM14ADV */

#endif /* NUCODEGEN_EADCSM14EN */



    
#if (NUCODEGEN_EADCSM15EN)
    /* Sample module 15 */
    EADC_ConfigSampleModule(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(15), NUCODEGEN_EADCSM15TS, NUCODEDEF_EADCSM15CH);

    /* Enable interrupt and position */

#if (((NUCODEGEN_EADCSM15INTEN)&0x1) == 0x1)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(0), BIT15 );
#endif /* (((NUCODEGEN_EADCSM15INTEN)&0x1) == 0x1) */
#if (((NUCODEGEN_EADCSM15INTEN)&0x2) == 0x2) 
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(1), BIT15 );
#endif /* (((NUCODEGEN_EADCSM15INTEN)&0x2) == 0x2) */
#if (((NUCODEGEN_EADCSM15INTEN)&0x4) == 0x4)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(2), BIT15 );
#endif /* (((NUCODEGEN_EADCSM15INTEN)&0x4) == 0x4) */
#if (((NUCODEGEN_EADCSM15INTEN)&0x8) == 0x8)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(3), BIT15 );
#endif /* (((NUCODEGEN_EADCSM15INTEN)&0x8) == 0x8) */

#if (NUCODEGEN_EADCSM15IP)
    /* Interrupt start of conversion */
    EADC_ENABLE_INT_POSITION(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(15));
#endif /* NUCODEGEN_EADCSM15IP */
 
#if (NUCODEGEN_EADCSM15ADV)
    /* Advanced configuration */

    /* Trigger delay */
    EADC_SetTriggerDelayTime(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(15), NUCODEDEF_EADCSM15TD, NUCODEGEN_EADCSM15TDDIV);
    
    /* Extern sample time */
    EADC_SetExtendSampleTime(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(15), NUCODEDEF_EADCSM15ES);

#if (NUCODEGEN_EADCSM15DMA)
    /* Enable DMA support */    
    EADC_ENABLE_PDMA(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(15));
#endif /* NUCODEGEN_EADCSM15DMA */

#if (NUCODEGEN_EADCSM15ALIGN)
    /* Enable data left alignment */
    EADC_ENABLE_LEFT_ALIGN(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(15));
#endif /* NUCODEGEN_EADCSM15ALIGN */

#if (NUCODEGEN_EADCSM15MODE == 1)
    /* Enable accumulate */
    EADC_ENABLE_ACU(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(15), NUCODEGEN_EADCSM15ACCU);
#elif (NUCODEGEN_EADCSM15MODE == 2)
    /* Enable average */
    EADC_ENABLE_ACU(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(15), NUCODEGEN_EADCSM15AVG);
    EADC_ENABLE_AVG(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(15));
#endif /* NUCODEGEN_EADCSM15MODE */

#endif /* NUCODEGEN_EADCSM15ADV */

#endif /* NUCODEGEN_EADCSM15EN */



#if (NUCODEGEN_EADCSM16EN)
    /* Sample module 16 (VBG) */


    /* Enable interrupt */
#if (((NUCODEGEN_EADCSM16INTEN)&0x1) == 0x1)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(0), BIT16 );
#endif /* (((NUCODEGEN_EADCSM16INTEN)&0x1) == 0x1) */
#if (((NUCODEGEN_EADCSM16INTEN)&0x2) == 0x2) 
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(1), BIT16 );
#endif /* (((NUCODEGEN_EADCSM16INTEN)&0x2) == 0x2) */
#if (((NUCODEGEN_EADCSM16INTEN)&0x4) == 0x4)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(2), BIT16 );
#endif /* (((NUCODEGEN_EADCSM16INTEN)&0x4) == 0x4) */
#if (((NUCODEGEN_EADCSM16INTEN)&0x8) == 0x8)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(3), BIT16 );
#endif /* (((NUCODEGEN_EADCSM16INTEN)&0x8) == 0x8) */

#if (NUCODEGEN_EADCSM16ADV)
    /* Advanced configuration */

    /* Extern sample time */
    EADC_SetExtendSampleTime(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(16), NUCODEDEF_EADCSM16ES);

#if (NUCODEGEN_EADCSM16DMA)
    /* Enable DMA support */    
    EADC_ENABLE_PDMA(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(16));
#endif /* NUCODEGEN_EADCSM16DMA */

#endif /* NUCODEGEN_EADCSM16ADV */

#endif /* NUCODEGEN_EADCSM16EN */



#if (NUCODEGEN_EADCSM17EN)
    /* Sample module 17 (Temp)*/


    /* Enable interrupt */
#if (((NUCODEGEN_EADCSM17INTEN)&0x1) == 0x1)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(0), BIT17 );
#endif /* (((NUCODEGEN_EADCSM17INTEN)&0x1) == 0x1) */
#if (((NUCODEGEN_EADCSM17INTEN)&0x2) == 0x2) 
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(1), BIT17 );
#endif /* (((NUCODEGEN_EADCSM17INTEN)&0x2) == 0x2) */
#if (((NUCODEGEN_EADCSM17INTEN)&0x4) == 0x4)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(2), BIT17 );
#endif /* (((NUCODEGEN_EADCSM17INTEN)&0x4) == 0x4) */
#if (((NUCODEGEN_EADCSM17INTEN)&0x8) == 0x8)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(3), BIT17 );
#endif /* (((NUCODEGEN_EADCSM17INTEN)&0x8) == 0x8) */

#if (NUCODEGEN_EADCSM17ADV)
    /* Advanced configuration */

    /* Extern sample time */
    EADC_SetExtendSampleTime(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(17), NUCODEDEF_EADCSM17ES);

#if (NUCODEGEN_EADCSM17DMA)
    /* Enable DMA support */    
    EADC_ENABLE_PDMA(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(17));
#endif /* NUCODEGEN_EADCSM17DMA */

#endif /* NUCODEGEN_EADCSM17ADV */

#endif /* NUCODEGEN_EADCSM17EN */



#if (NUCODEGEN_EADCSM18EN)
    /* Sample module 18 (VBAT)*/


    /* Enable interrupt */
#if (((NUCODEGEN_EADCSM18INTEN)&0x1) == 0x1)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(0), BIT18 );
#endif /* (((NUCODEGEN_EADCSM18INTEN)&0x1) == 0x1) */
#if (((NUCODEGEN_EADCSM18INTEN)&0x2) == 0x2) 
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(1), BIT18 );
#endif /* (((NUCODEGEN_EADCSM18INTEN)&0x2) == 0x2) */
#if (((NUCODEGEN_EADCSM18INTEN)&0x4) == 0x4)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(2), BIT18 );
#endif /* (((NUCODEGEN_EADCSM18INTEN)&0x4) == 0x4) */
#if (((NUCODEGEN_EADCSM18INTEN)&0x8) == 0x8)
    EADC_ENABLE_SAMPLE_MODULE_INT(NUCODEGEN_EADC_MODULE_SEL, AINT_SEL(3), BIT18 );
#endif /* (((NUCODEGEN_EADCSM18INTEN)&0x8) == 0x8) */

#if (NUCODEGEN_EADCSM18ADV)
    /* Advanced configuration */

    /* Extern sample time */
    EADC_SetExtendSampleTime(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(18), NUCODEDEF_EADCSM18ES);

#if (NUCODEGEN_EADCSM18DMA)
    /* Enable DMA support */    
    EADC_ENABLE_PDMA(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(18));
#endif /* NUCODEGEN_EADCSM18DMA */

#endif /* NUCODEGEN_EADCSM18ADV */

#endif /* NUCODEGEN_EADCSM18EN */

#if (NUCODEGEN_EADCCMP0CMPEN || NUCODEGEN_EADCCMP1CMPEN || NUCODEGEN_EADCCMP2CMPEN || NUCODEGEN_EADCCMP3CMPEN)
/* --------------------------------------------------------------------
 * Compare configuration 0~3
 * ---------------------------------------------------------------------*/
#endif
#if (NUCODEGEN_EADCCMP0CMPEN)
    /* Compare 0 */
    EADC_ENABLE_CMP0(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(NUCODEGEN_EADCCMP0CMPSM), NUCODEGEN_EADCCMP0CMPCD, NUCODEDEF_EADCCMP0CMPDT, NUCODEDEF_EADCCMP0CMPMC);

#if (NUCODEGEN_EADCCMP0CMPINT)
    /* Comprae 0 interrupt enable */
    EADC_ENABLE_CMP_INT(NUCODEGEN_EADC_MODULE_SEL, COMPARE_SEL(0));
#endif /* NUCODEGEN_EADCCMP0CMPINT */

#if (NUCODEGEN_EADCCMP0CMPW)
    /* Comprae window 0 & 1 enable */
    EADC_ENABLE_CMP_WINDOW_MODE(NUCODEGEN_EADC_MODULE_SEL, COMPARE_SEL(0));
#endif /* NUCODEGEN_EADCCMP0CMPW */
#endif /* NUCODEGEN_EADCCMP0CMPEN */


#if (NUCODEGEN_EADCCMP1CMPEN)
    /* Compare 1 */
    EADC_ENABLE_CMP1(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(NUCODEGEN_EADCCMP1CMPSM), NUCODEGEN_EADCCMP1CMPCD, NUCODEDEF_EADCCMP1CMPDT, NUCODEDEF_EADCCMP1CMPMC);

#if (NUCODEGEN_EADCCMP1CMPINT)
    /* Comprae 1 interrupt enable */
    EADC_ENABLE_CMP_INT(NUCODEGEN_EADC_MODULE_SEL, COMPARE_SEL(1));
#endif /* NUCODEGEN_EADCCMP1CMPINT */
#endif /* NUCODEGEN_EADCCMP1CMPEN */


#if (NUCODEGEN_EADCCMP2CMPEN)
    /* Compare 2 */
    EADC_ENABLE_CMP2(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(NUCODEGEN_EADCCMP2CMPSM), NUCODEGEN_EADCCMP2CMPCD, NUCODEDEF_EADCCMP2CMPDT, NUCODEDEF_EADCCMP2CMPMC);

#if (NUCODEGEN_EADCCMP2CMPINT)
    /* Comprae 2 interrupt enable */
    EADC_ENABLE_CMP_INT(NUCODEGEN_EADC_MODULE_SEL, COMPARE_SEL(2));
#endif /* NUCODEGEN_EADCCMP2CMPINT */

#if (NUCODEGEN_EADCCMP2CMPW)
    /* Comprae window 2 & 3 enable */
    EADC_ENABLE_CMP_WINDOW_MODE(NUCODEGEN_EADC_MODULE_SEL, COMPARE_SEL(2));
#endif /* NUCODEGEN_EADCCMP2CMPW */
#endif /* NUCODEGEN_EADCCMP2CMPEN */


#if (NUCODEGEN_EADCCMP3CMPEN)
    /* Compare 3 */
    EADC_ENABLE_CMP3(NUCODEGEN_EADC_MODULE_SEL, SAMPLE_MODULE_SEL(NUCODEGEN_EADCCMP3CMPSM), NUCODEGEN_EADCCMP3CMPCD, NUCODEDEF_EADCCMP3CMPDT, NUCODEDEF_EADCCMP3CMPMC);

#if (NUCODEGEN_EADCCMP3CMPINT)
    /* Comprae 3 interrupt enable */
    EADC_ENABLE_CMP_INT(NUCODEGEN_EADC_MODULE_SEL, COMPARE_SEL(3));
#endif /* NUCODEGEN_EADCCMP3CMPINT */
#endif /* NUCODEGEN_EADCCMP3CMPEN */



}
#endif /* NUCODEGEN_EADC */
