/*********************************************************************
*                 SEGGER Software GmbH                               *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2018  SEGGER Microcontroller GmbH                *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.46 - Graphical user interface for embedded applications **
All  Intellectual Property rights in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product. This file may
only be used in accordance with the following terms:

The  software has  been licensed by SEGGER Software GmbH to Nuvoton Technology Corporation
at the address: No. 4, Creation Rd. III, Hsinchu Science Park, Taiwan
for the purposes  of  creating  libraries  for its 
Arm Cortex-M and  Arm9 32-bit microcontrollers, commercialized and distributed by Nuvoton Technology Corporation
under  the terms and conditions  of  an  End  User  
License  Agreement  supplied  with  the libraries.
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
Licensing information
Licensor:                 SEGGER Software GmbH
Licensed to:              Nuvoton Technology Corporation, No. 4, Creation Rd. III, Hsinchu Science Park, 30077 Hsinchu City, Taiwan
Licensed SEGGER software: emWin
License number:           GUI-00735
License model:            emWin License Agreement, signed February 27, 2018
Licensed platform:        Cortex-M and ARM9 32-bit series microcontroller designed and manufactured by or for Nuvoton Technology Corporation
----------------------------------------------------------------------
Support and Update Agreement (SUA)
SUA period:               2018-03-26 - 2019-03-27
Contact to extend SUA:    sales@segger.com
----------------------------------------------------------------------
File        : GUIDEMO_Bitmap.c
Purpose     : Draws bitmaps with and without compression
----------------------------------------------------------------------
*/

#include "GUIDEMO.h"

#if (SHOW_GUIDEMO_BITMAP)

/*********************************************************************
*
*       Defines
*
**********************************************************************
*/
//
// Config
//
#define SHOW_ALPHA       1
#define SHOW_PALETTE     1
#define SHOW_BMP_GIF_JPG 1
#define SHOW_HIGH_COLOR  1
#define SHOW_GRAYSCALE   1

//
// General
//
#if SHOW_ALPHA
  #define MAX_TIME_ALPHA    5000
  #if GUI_SUPPORT_MEMDEV
    #define NUM_STEPS_ALPHA 10
  #endif
#endif

#if SHOW_PALETTE
  #define MAX_TIME_PAL      5000
  #define NUM_STEPS_PAL     20
#endif

#if SHOW_BMP_GIF_JPG
  #define NUM_IMAGES_BGJ    3
#endif

#if SHOW_GRAYSCALE
  #define BITMAP_SIZE_X_4   45
#endif

#if (SHOW_PALETTE || SHOW_HIGH_COLOR || SHOW_BMP_GIF_JPG)
  #define BITMAP_SIZE_X_3   70
#endif

#if (SHOW_PALETTE || SHOW_HIGH_COLOR || SHOW_BMP_GIF_JPG || SHOW_GRAYSCALE)
  #define BITMAP_SIZE_Y     70
  #define X_BORDER          20
#endif

/*********************************************************************
*
*       Structures
*
**********************************************************************
*/
#if (SHOW_GRAYSCALE || SHOW_PALETTE || SHOW_HIGH_COLOR)
  typedef struct {
    const GUI_BITMAP *  pBitmap;
    #if SHOW_PALETTE
      GUI_COLOR        *  pColorsDst;
      const GUI_COLOR  ** ppColorsSrc;
      unsigned            NumColors;
    #endif
  } PAL_BITMAP_CONTEXT;
#endif

/*********************************************************************
*
*       Static data
*
**********************************************************************
*/
/*********************************************************************
*
*       Alpha specific
*/
#if SHOW_ALPHA
  static const GUI_COLOR _aAlphaColors[] = {
    GUI_WHITE,
    GUI_LIGHTCYAN,
    GUI_GREEN,
    GUI_YELLOW,
    GUI_ORANGE,
    GUI_RED,
  };
#endif

/*********************************************************************
*
*       Palette specific
*/
#if SHOW_PALETTE
  static GUI_COLOR _ColorsMouse[] = {
#if (GUI_USE_ARGB)
    0xFFFFFFFF, 0xFF800080, 0xFF000000, 0xFF8000FF,
    0xFF8080FF, 0xFFFF00FF
#else
    0xFFFFFF, 0x800080, 0x000000, 0xFF0080,
    0xFF8080, 0xFF00FF
#endif
  };

  static GUI_LOGPALETTE _PalMouse = {
    6,  // Number of entries
    1,  // Has transparency
    &_ColorsMouse[0]
  };

  static const unsigned char _acMouse[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x44, 0x44, 0x44, 0x44, 0x22, 0x33, 0x33, 0x33, 0x33, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x22, 0x44, 0x44, 0x44, 0x44, 0x44, 0x22, 0x33, 0x33, 0x33, 0x33, 0x33, 0x22, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x24, 0x44, 0x44, 0x44, 0x44, 0x42, 0x22, 0x23, 0x33, 0x33, 0x33, 0x33, 0x32, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x22, 0x44, 0x44, 0x44, 0x44, 0x44, 0x22, 0x22, 0x22, 0x33, 0x33, 0x33, 0x33, 0x33, 0x22, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x24, 0x44, 0x44, 0x44, 0x44, 0x44, 0x22, 0x55, 0x22, 0x33, 0x33, 0x33, 0x33, 0x33, 0x32, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x24, 0x44, 0x44, 0x44, 0x44, 0x44, 0x25, 0x55, 0x52, 0x33, 0x33, 0x33, 0x33, 0x33, 0x32, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x44, 0x44, 0x44, 0x44, 0x44, 0x42, 0x25, 0x55, 0x52, 0x23, 0x33, 0x33, 0x33, 0x33, 0x33, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x44, 0x44, 0x44, 0x44, 0x44, 0x42, 0x25, 0x55, 0x52, 0x23, 0x33, 0x33, 0x33, 0x33, 0x33, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x22, 0x44, 0x44, 0x44, 0x44, 0x44, 0x42, 0x25, 0x55, 0x52, 0x23, 0x33, 0x33, 0x33, 0x33, 0x33, 0x22, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x24, 0x44, 0x44, 0x44, 0x44, 0x44, 0x42, 0x25, 0x55, 0x52, 0x23, 0x33, 0x33, 0x33, 0x33, 0x33, 0x32, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x24, 0x44, 0x44, 0x44, 0x44, 0x44, 0x42, 0x25, 0x55, 0x52, 0x23, 0x33, 0x33, 0x33, 0x33, 0x33, 0x32, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x24, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x22, 0x55, 0x22, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x32, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x24, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x22, 0x22, 0x22, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x32, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x24, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x42, 0x22, 0x23, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x32, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x22, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x22, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x44, 0x44, 0x44, 0x44, 0x44, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x33, 0x33, 0x33, 0x33, 0x33, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x44, 0x44, 0x42, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0x33, 0x33, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x44, 0x22, 0x22, 0x22, 0x22, 0x21, 0x11, 0x11, 0x11, 0x11, 0x11, 0x12, 0x22, 0x22, 0x22, 0x22, 0x33, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x21, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x12, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x21, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x12, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x21, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x12, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x22, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x22, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x21, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x12, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x22, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x22, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x21, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x12, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x22, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x22, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x22, 0x22, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x22, 0x22, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x22, 0x22, 0x22, 0x21, 0x11, 0x12, 0x22, 0x22, 0x22, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x22, 0x22, 0x22, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
  };

  static const GUI_BITMAP _bmMouse = {
    70, // xSize
    70, // ySize
    35, // BytesPerLine
    4, // BitsPerPixel
    _acMouse,  // Pointer to picture data (indices)
    &_PalMouse   // Pointer to palette
  };

  static GUI_COLOR _ColorsPrinter[] = {
#if (GUI_USE_ARGB)
    0xFFFFFFFF, 0xFFC7C7C7, 0xFFFFFFC8, 0xFF4F7391,
    0xFF000000, 0xFFA0A0A0, 0xFF98A1A8, 0xFF282828,
    0xFF808040, 0xFF008080, 0xFF80FFFF, 0xFF008000
#else
    0xFFFFFF, 0xC7C7C7, 0xC8FFFF, 0x91734F,
    0x000000, 0xA0A0A0, 0xA8A198, 0x282828,
    0x408080, 0x808000, 0xFFFF80, 0x008000
#endif
  };

  static GUI_LOGPALETTE _PalPrinter = {
    12,  // Number of entries
    1,   // Has transparency
    &_ColorsPrinter[0]
  };

  static const unsigned char _acPrinter[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x42, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x24, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x88, 0x42, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x24, 0x88, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x88, 0x42, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x24, 0x88, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x88, 0x42, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x24, 0x88, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x44, 0x44, 0x44, 0x44, 0x48, 0x88, 0x42, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x24, 0x88, 0x84, 0x44, 0x44, 0x44, 0x44, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x04, 0x44, 0x11, 0x11, 0x11, 0x11, 0x48, 0x88, 0x42, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x24, 0x88, 0x84, 0x11, 0x11, 0x11, 0x11, 0x44, 0x40, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x04, 0x44, 0x11, 0x11, 0x11, 0x11, 0x11, 0x48, 0x88, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x88, 0x84, 0x11, 0x11, 0x11, 0x11, 0x11, 0x44, 0x40, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x44, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x48, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x84, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x44, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x04, 0x41, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x48, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x84, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x14, 0x40, 0x00, 0x00,
    0x00, 0x00, 0x04, 0x11, 0x11, 0x11, 0x11, 0x11, 0x17, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x71, 0x11, 0x11, 0x11, 0x11, 0x11, 0x40, 0x00, 0x00,
    0x00, 0x00, 0x44, 0x11, 0x11, 0x11, 0x11, 0x11, 0x77, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x77, 0x11, 0x11, 0xAA, 0xA1, 0x11, 0x44, 0x00, 0x00,
    0x00, 0x00, 0x41, 0x11, 0x11, 0x11, 0x11, 0x17, 0x73, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x37, 0x71, 0x11, 0xAB, 0xA1, 0x11, 0x14, 0x00, 0x00,
    0x00, 0x00, 0x41, 0x11, 0x11, 0x11, 0x11, 0x77, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x77, 0x11, 0xAA, 0xA1, 0x11, 0x14, 0x00, 0x00,
    0x00, 0x00, 0x41, 0x11, 0x11, 0x11, 0x11, 0x73, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x37, 0x11, 0x11, 0x11, 0x11, 0x14, 0x00, 0x00,
    0x00, 0x00, 0x41, 0x11, 0x11, 0x11, 0x11, 0x73, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x37, 0x11, 0x11, 0x11, 0x11, 0x14, 0x00, 0x00,
    0x00, 0x00, 0x41, 0x11, 0x11, 0x11, 0x11, 0x77, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x77, 0x11, 0x11, 0x11, 0x11, 0x14, 0x00, 0x00,
    0x00, 0x00, 0x41, 0x11, 0x11, 0x11, 0x11, 0x17, 0x73, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x37, 0x71, 0x11, 0x11, 0x11, 0x11, 0x14, 0x00, 0x00,
    0x00, 0x00, 0x41, 0x11, 0x11, 0x11, 0x11, 0x11, 0x77, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x77, 0x11, 0x11, 0x11, 0x11, 0x11, 0x14, 0x00, 0x00,
    0x00, 0x00, 0x41, 0x11, 0x11, 0x11, 0x11, 0x11, 0x17, 0x77, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x77, 0x71, 0x11, 0x11, 0x11, 0x11, 0x11, 0x14, 0x00, 0x00,
    0x00, 0x00, 0x41, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x17, 0x77, 0x77, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x77, 0x77, 0x71, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x14, 0x00, 0x00,
    0x00, 0x00, 0x41, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x17, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x71, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x14, 0x00, 0x00,
    0x00, 0x00, 0x41, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x14, 0x00, 0x00,
    0x00, 0x00, 0x41, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x14, 0x00, 0x00,
    0x00, 0x00, 0x41, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x14, 0x00, 0x00,
    0x00, 0x00, 0x41, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x14, 0x00, 0x00,
    0x00, 0x00, 0x41, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x14, 0x00, 0x00,
    0x00, 0x00, 0x41, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x14, 0x00, 0x00,
    0x00, 0x00, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x00, 0x00,
    0x00, 0x00, 0x04, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x45, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x54, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x40, 0x00, 0x00,
    0x00, 0x00, 0x04, 0x46, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x45, 0x55, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x55, 0x54, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x64, 0x40, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x44, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x45, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x54, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x44, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x04, 0x44, 0x66, 0x66, 0x66, 0x66, 0x66, 0x45, 0x55, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x55, 0x54, 0x66, 0x66, 0x66, 0x66, 0x66, 0x44, 0x40, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x04, 0x44, 0x66, 0x66, 0x66, 0x66, 0x45, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x54, 0x66, 0x66, 0x66, 0x66, 0x44, 0x40, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x44, 0x44, 0x44, 0x44, 0x45, 0x55, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x55, 0x54, 0x44, 0x44, 0x44, 0x44, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x55, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x55, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
  };

  static GUI_BITMAP _bmPrinter = {
    70, // xSize
    70, // ySize
    35, // BytesPerLine
    4, // BitsPerPixel
    _acPrinter,  // Pointer to picture data (indices)
    &_PalPrinter   // Pointer to palette
  };

  static GUI_COLOR _ColorsUSB_Stick[] = {
#if (GUI_USE_ARGB)
    0xFFFFFFFF, 0xFF0000FF, 0xFF000000, 0xFFACA8A8,
    0xFF0080FF, 0xFF000080
#else
    0xFFFFFF, 0xFF0000, 0x000000, 0xA8A8AC,
    0xFF8000, 0x800000
#endif
  };

  static GUI_LOGPALETTE _PalUSB_Stick = {
    6,  // Number of entries
    1,  // Has transparency
    &_ColorsUSB_Stick[0]
  };

  static const unsigned char _acUSB_Stick[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x12, 0x22, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x12, 0x20, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x22, 0x00, 0x00,
    0x00, 0x02, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x12, 0x00, 0x00,
    0x00, 0x02, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x21, 0x15, 0x15, 0x15, 0x15, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x12, 0x20, 0x00,
    0x00, 0x02, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x21, 0x15, 0x15, 0x15, 0x15, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x14, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x20, 0x00,
    0x00, 0x02, 0x33, 0x33, 0x33, 0x22, 0x33, 0x33, 0x21, 0x15, 0x15, 0x15, 0x15, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x14, 0x44, 0x44, 0x41, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x20, 0x00,
    0x00, 0x02, 0x33, 0x33, 0x33, 0x22, 0x33, 0x33, 0x21, 0x15, 0x15, 0x15, 0x15, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x44, 0x11, 0x14, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x20, 0x00,
    0x00, 0x02, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x21, 0x15, 0x15, 0x15, 0x15, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x41, 0x11, 0x41, 0x11, 0x11, 0x11, 0x11, 0x11, 0x41, 0x11, 0x11, 0x11, 0x11, 0x11, 0x20, 0x00,
    0x00, 0x02, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x21, 0x15, 0x15, 0x15, 0x15, 0x11, 0x11, 0x11, 0x11, 0x11, 0x14, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x11, 0x11, 0x11, 0x11, 0x11, 0x20, 0x00,
    0x00, 0x02, 0x33, 0x33, 0x33, 0x22, 0x33, 0x33, 0x21, 0x15, 0x15, 0x15, 0x15, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x41, 0x11, 0x11, 0x14, 0x11, 0x11, 0x11, 0x11, 0x41, 0x11, 0x11, 0x11, 0x11, 0x11, 0x20, 0x00,
    0x00, 0x02, 0x33, 0x33, 0x33, 0x22, 0x33, 0x33, 0x21, 0x15, 0x15, 0x15, 0x15, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x14, 0x41, 0x14, 0x41, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x20, 0x00,
    0x00, 0x02, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x21, 0x15, 0x15, 0x15, 0x15, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x44, 0x44, 0x41, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x20, 0x00,
    0x00, 0x02, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x21, 0x15, 0x15, 0x15, 0x15, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x14, 0x41, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x12, 0x20, 0x00,
    0x00, 0x02, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x12, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x22, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x12, 0x20, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x12, 0x22, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
  };

  static GUI_BITMAP _bmUSB_Stick = {
    70, // xSize
    70, // ySize
    35, // BytesPerLine
    4, // BitsPerPixel
    _acUSB_Stick,  // Pointer to picture data (indices)
    &_PalUSB_Stick   // Pointer to palette
  };

#if (GUI_USE_ARGB)
  static const GUI_COLOR _ColorsPrinter_Original[] = {
    0xFFFFFFFF, 0xFFC7C7C7, 0xFFFFFFFF, 0xFF4F7391,
    0xFF000000, 0xFF98A1A8, 0xFF98A1A8, 0xFF000000,
    0xFFC7C7C7, 0xFF4F7391, 0xFFFFFFFF, 0xFF008000
  };

  static const GUI_COLOR _ColorsMouse_Original[] = {
    0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF
  };

  static const GUI_COLOR _ColorsUSB_Stick_Original[] = {
    0xFFFFFFFF, 0xFFA80000, 0xFF000000, 0xFFACA8A8,
    0xFFACA8A8, 0xFF000000
  };

  static const GUI_COLOR _ColorsPrinter_Blue[] = {
    0xFFFFFFFF, 0xFFA0A0E0, 0xFFD3D3FF, 0xFF515191,
    0xFF000000, 0xFF9090C0, 0xFF8080C0, 0xFF181848,
    0xFF606080, 0xFF404080, 0xFFBFBFFF, 0xFF000080
  };

  static const GUI_COLOR _ColorsMouse_Blue[] = {
    0xFFFFFFFF, 0xFF0050A0, 0xFF000000, 0xFF0060E0,
    0xFF0060E0, 0xFF0040B0
  };

  static const GUI_COLOR _ColorsUSB_Stick_Blue[] = {
    0xFFFFFFFF, 0xFF4000A0, 0xFF000000, 0xFF8000E0,
    0xFF6000F0, 0xFF200060
  };

  static const GUI_COLOR _ColorsPrinter_Red[] = {
    0xFFFFFFFF, 0xFFD7C0C0, 0xFFFFE3E3, 0xFF916161,
    0xFF000000, 0xFFC09090, 0xFFB88C8C, 0xFF481818,
    0xFF806060, 0xFF804040, 0xFFFFBFBF, 0xFF800000
  };

  static const GUI_COLOR _ColorsMouse_Red[] = {
    0xFFFFFFFF, 0xFF802000, 0xFF000000, 0xFFC02000,
    0xFFC02000, 0xFFB08000
  };

  static const GUI_COLOR _ColorsUSB_Stick_Red[] = {
    0xFFFFFFFF, 0xFF800080, 0xFF000000, 0xFFD000D0,
    0xFFB000B0, 0xFF400040
  };

  static const GUI_COLOR _ColorsPrinter_Gray[] = {
    0xFFFFFFFF, 0xFFC7C7C7, 0xFFFFFFFF, 0xFF808080,
    0xFF000000, 0xFFA0A0A0, 0xFF909090, 0xFF101010,
    0xFF707070, 0xFF606060, 0xFFF0F0F0, 0xFF202020
  };

  static const GUI_COLOR _ColorsMouse_Gray[] = {
    0xFFFFFFFF, 0xFF808080, 0xFF000000, 0xFF404040,
    0xFF404040, 0xFFD3D3D3
  };

  static const GUI_COLOR _ColorsUSB_Stick_Gray[] = {
    0xFFFFFFFF, 0xFF808080, 0xFF000000, 0xFFA8A8A8,
    0xFFC0C0C0, 0xFF404040
  };

  static const GUI_COLOR _ColorsPrinter_Green[] = {
    0xFFFFFFFF, 0xFF00D0B0, 0xFF00FFC0, 0xFF009060,
    0xFF000000, 0xFF00A080, 0xFF00B070, 0xFF003010,
    0xFF008060, 0xFF008040, 0xFF00FFA0, 0xFF008000
  };

  static const GUI_COLOR _ColorsMouse_Green[] = {
    0xFFFFFFFF, 0xFF00A000, 0xFF000000, 0xFF00D000,
    0xFF00D000, 0xFF006000
  };

  static const GUI_COLOR _ColorsUSB_Stick_Green[] = {
    0xFFFFFFFF, 0xFF80C000, 0xFF000000, 0xFF60A000,
    0xFFA0F000, 0xFF408000
  };
#else
  static const GUI_COLOR _ColorsPrinter_Original[] = {
    0xFFFFFF, 0xC7C7C7, 0xFFFFFF, 0x91734F,
    0x000000, 0xA8A198, 0xA8A198, 0x000000,
    0xC7C7C7, 0x91734F, 0xFFFFFF, 0x008000
  };

  static const GUI_COLOR _ColorsMouse_Original[] = {
    0xFFFFFF, 0xFFFFFF, 0x000000, 0xFFFFFF,
    0xFFFFFF, 0xFFFFFF
  };

  static const GUI_COLOR _ColorsUSB_Stick_Original[] = {
    0xFFFFFF, 0x0000A8, 0x000000, 0xA8A8AC,
    0xA8A8AC, 0x000000
  };

  static const GUI_COLOR _ColorsPrinter_Blue[] = {
    0xFFFFFF, 0xE0A0A0, 0xFFD3D3, 0x915151,
    0x000000, 0xC09090, 0xC08080, 0x481818,
    0x806060, 0x804040, 0xFFBFBF, 0x800000
  };

  static const GUI_COLOR _ColorsMouse_Blue[] = {
    0xFFFFFF, 0xA05000, 0x000000, 0xE06000,
    0xE06000, 0xB04000
  };

  static const GUI_COLOR _ColorsUSB_Stick_Blue[] = {
    0xFFFFFF, 0xA00040, 0x000000, 0xE00080,
    0xF00060, 0x600020
  };

  static const GUI_COLOR _ColorsPrinter_Red[] = {
    0xFFFFFF, 0xC0C0D7, 0xE3E3FF, 0x616191,
    0x000000, 0x9090C0, 0x8C8CB8, 0x181848,
    0x606080, 0x404080, 0xBFBFFF, 0x000080
  };

  static const GUI_COLOR _ColorsMouse_Red[] = {
    0xFFFFFF, 0x002080, 0x000000, 0x0020C0,
    0x0020C0, 0x0080B0
  };

  static const GUI_COLOR _ColorsUSB_Stick_Red[] = {
    0xFFFFFF, 0x800080, 0x000000, 0xD000D0,
    0xB000B0, 0x400040
  };

  static const GUI_COLOR _ColorsPrinter_Gray[] = {
    0xFFFFFF, 0xC7C7C7, 0xFFFFFF, 0x808080,
    0x000000, 0xA0A0A0, 0x909090, 0x101010,
    0x707070, 0x606060, 0xF0F0F0, 0x202020
  };

  static const GUI_COLOR _ColorsMouse_Gray[] = {
    0xFFFFFF, 0x808080, 0x000000, 0x404040,
    0x404040, 0xD3D3D3
  };

  static const GUI_COLOR _ColorsUSB_Stick_Gray[] = {
    0xFFFFFF, 0x808080, 0x000000, 0xA8A8A8,
    0xC0C0C0, 0x404040
  };

  static const GUI_COLOR _ColorsPrinter_Green[] = {
    0xFFFFFF, 0xB0D000, 0xC0FF00, 0x609000,
    0x000000, 0x80A000, 0x70B000, 0x103000,
    0x608000, 0x408000, 0xA0FF00, 0x008000
  };

  static const GUI_COLOR _ColorsMouse_Green[] = {
    0xFFFFFF, 0x00A000, 0x000000, 0x00D000,
    0x00D000, 0x006000
  };

  static const GUI_COLOR _ColorsUSB_Stick_Green[] = {
    0xFFFFFF, 0x00C080, 0x000000, 0x00A060,
    0x00F0A0, 0x008040
  };
#endif

  static const GUI_COLOR * _aPalettesMouse[] = {
    _ColorsMouse_Original,
    _ColorsMouse_Red,
    _ColorsMouse_Gray,
    _ColorsMouse_Blue,
    _ColorsMouse_Green,
    _ColorsMouse_Original,
  };

  static const GUI_COLOR * _aPalettesPrinter[] = {
    _ColorsPrinter_Original,
    _ColorsPrinter_Blue,
    _ColorsPrinter_Green,
    _ColorsPrinter_Gray,
    _ColorsPrinter_Red,
    _ColorsPrinter_Original,
  };

  static const GUI_COLOR * _aPalettesUSB_Stick[] = {
    _ColorsUSB_Stick_Original,
    _ColorsUSB_Stick_Green,
    _ColorsUSB_Stick_Red,
    _ColorsUSB_Stick_Blue,
    _ColorsUSB_Stick_Gray,
    _ColorsUSB_Stick_Original,
  };

  static const PAL_BITMAP_CONTEXT _apPaletteBitmaps[] = {
    { &_bmMouse,     _ColorsMouse,     _aPalettesMouse,     GUI_COUNTOF(_ColorsMouse)     },
    { &_bmPrinter,   _ColorsPrinter,   _aPalettesPrinter,   GUI_COUNTOF(_ColorsPrinter)   },
    { &_bmUSB_Stick, _ColorsUSB_Stick, _aPalettesUSB_Stick, GUI_COUNTOF(_ColorsUSB_Stick) },
  };
#endif

/*********************************************************************
*
*       BMP, GIF and JPEG specific
*/
#if SHOW_BMP_GIF_JPG
  static const unsigned char _ac70x70_JPG[] = {
    0xFF, 0xD8, 0xFF, 0xE0, 0x00, 0x10, 0x4A, 0x46, 0x49, 0x46, 0x00, 0x01, 0x01, 0x01, 0x00, 0x60, 0x00, 0x60, 0x00, 0x00, 0xFF, 0xED, 0x0B, 0xE4, 0x50, 0x68, 0x6F, 0x74, 0x6F, 0x73, 0x68, 0x6F, 0x70, 0x20, 0x33, 0x2E, 0x30, 0x00, 0x38, 0x42,
    0x49, 0x4D, 0x03, 0xED, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x48, 0x00, 0x00, 0x00, 0x01, 0x00, 0x02, 0x00, 0x48, 0x00, 0x00, 0x00, 0x01, 0x00, 0x02, 0x38, 0x42, 0x49, 0x4D, 0x04, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00,
    0x00, 0x78, 0x38, 0x42, 0x49, 0x4D, 0x03, 0xF3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x42, 0x49, 0x4D, 0x04, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x38, 0x42, 0x49, 0x4D,
    0x27, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x38, 0x42, 0x49, 0x4D, 0x03, 0xF5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x00, 0x2F, 0x66, 0x66, 0x00, 0x01, 0x00, 0x6C, 0x66, 0x66,
    0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x2F, 0x66, 0x66, 0x00, 0x01, 0x00, 0xA1, 0x99, 0x9A, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x32, 0x00, 0x00, 0x00, 0x01, 0x00, 0x5A, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x01, 0x00, 0x35, 0x00, 0x00, 0x00, 0x01, 0x00, 0x2D, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x38, 0x42, 0x49, 0x4D, 0x03, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0xE8, 0x00, 0x00, 0x38, 0x42, 0x49, 0x4D, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00,
    0x00, 0x01, 0x00, 0x00, 0x02, 0x40, 0x00, 0x00, 0x02, 0x40, 0x00, 0x00, 0x00, 0x00, 0x38, 0x42, 0x49, 0x4D, 0x04, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x01, 0x38, 0x42, 0x49, 0x4D, 0x04, 0x0C, 0x00, 0x00, 0x00, 0x00,
    0x0A, 0x53, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x01, 0x50, 0x00, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x0A, 0x37, 0x00, 0x18, 0x00, 0x01, 0xFF, 0xD8, 0xFF, 0xE0, 0x00, 0x10, 0x4A, 0x46, 0x49, 0x46,
    0x00, 0x01, 0x02, 0x01, 0x00, 0x48, 0x00, 0x48, 0x00, 0x00, 0xFF, 0xEE, 0x00, 0x0E, 0x41, 0x64, 0x6F, 0x62, 0x65, 0x00, 0x64, 0x80, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xDB, 0x00, 0x84, 0x00, 0x0C, 0x08, 0x08, 0x08, 0x09, 0x08, 0x0C, 0x09, 0x09,
    0x0C, 0x11, 0x0B, 0x0A, 0x0B, 0x11, 0x15, 0x0F, 0x0C, 0x0C, 0x0F, 0x15, 0x18, 0x13, 0x13, 0x15, 0x13, 0x13, 0x18, 0x11, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x11, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C,
    0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x01, 0x0D, 0x0B, 0x0B, 0x0D, 0x0E, 0x0D, 0x10, 0x0E, 0x0E, 0x10, 0x14, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x11, 0x0C, 0x0C,
    0x0C, 0x0C, 0x0C, 0x11, 0x11, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x11, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C,
    0xFF, 0xC0, 0x00, 0x11, 0x08, 0x00, 0x30, 0x00, 0x70, 0x03, 0x01, 0x22, 0x00, 0x02, 0x11, 0x01, 0x03, 0x11, 0x01, 0xFF, 0xDD, 0x00, 0x04, 0x00, 0x07, 0xFF, 0xC4, 0x01, 0x3F, 0x00, 0x00, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x01, 0x02, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x01, 0x00, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x02, 0x03, 0x04,
    0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x10, 0x00, 0x01, 0x04, 0x01, 0x03, 0x02, 0x04, 0x02, 0x05, 0x07, 0x06, 0x08, 0x05, 0x03, 0x0C, 0x33, 0x01, 0x00, 0x02, 0x11, 0x03, 0x04, 0x21, 0x12, 0x31, 0x05, 0x41, 0x51, 0x61, 0x13, 0x22, 0x71,
    0x81, 0x32, 0x06, 0x14, 0x91, 0xA1, 0xB1, 0x42, 0x23, 0x24, 0x15, 0x52, 0xC1, 0x62, 0x33, 0x34, 0x72, 0x82, 0xD1, 0x43, 0x07, 0x25, 0x92, 0x53, 0xF0, 0xE1, 0xF1, 0x63, 0x73, 0x35, 0x16, 0xA2, 0xB2, 0x83, 0x26, 0x44, 0x93, 0x54, 0x64, 0x45,
    0xC2, 0xA3, 0x74, 0x36, 0x17, 0xD2, 0x55, 0xE2, 0x65, 0xF2, 0xB3, 0x84, 0xC3, 0xD3, 0x75, 0xE3, 0xF3, 0x46, 0x27, 0x94, 0xA4, 0x85, 0xB4, 0x95, 0xC4, 0xD4, 0xE4, 0xF4, 0xA5, 0xB5, 0xC5, 0xD5, 0xE5, 0xF5, 0x56, 0x66, 0x76, 0x86, 0x96, 0xA6,
    0xB6, 0xC6, 0xD6, 0xE6, 0xF6, 0x37, 0x47, 0x57, 0x67, 0x77, 0x87, 0x97, 0xA7, 0xB7, 0xC7, 0xD7, 0xE7, 0xF7, 0x11, 0x00, 0x02, 0x02, 0x01, 0x02, 0x04, 0x04, 0x03, 0x04, 0x05, 0x06, 0x07, 0x07, 0x06, 0x05, 0x35, 0x01, 0x00, 0x02, 0x11, 0x03,
    0x21, 0x31, 0x12, 0x04, 0x41, 0x51, 0x61, 0x71, 0x22, 0x13, 0x05, 0x32, 0x81, 0x91, 0x14, 0xA1, 0xB1, 0x42, 0x23, 0xC1, 0x52, 0xD1, 0xF0, 0x33, 0x24, 0x62, 0xE1, 0x72, 0x82, 0x92, 0x43, 0x53, 0x15, 0x63, 0x73, 0x34, 0xF1, 0x25, 0x06, 0x16,
    0xA2, 0xB2, 0x83, 0x07, 0x26, 0x35, 0xC2, 0xD2, 0x44, 0x93, 0x54, 0xA3, 0x17, 0x64, 0x45, 0x55, 0x36, 0x74, 0x65, 0xE2, 0xF2, 0xB3, 0x84, 0xC3, 0xD3, 0x75, 0xE3, 0xF3, 0x46, 0x94, 0xA4, 0x85, 0xB4, 0x95, 0xC4, 0xD4, 0xE4, 0xF4, 0xA5, 0xB5,
    0xC5, 0xD5, 0xE5, 0xF5, 0x56, 0x66, 0x76, 0x86, 0x96, 0xA6, 0xB6, 0xC6, 0xD6, 0xE6, 0xF6, 0x27, 0x37, 0x47, 0x57, 0x67, 0x77, 0x87, 0x97, 0xA7, 0xB7, 0xC7, 0xFF, 0xDA, 0x00, 0x0C, 0x03, 0x01, 0x00, 0x02, 0x11, 0x03, 0x11, 0x00, 0x3F, 0x00,
    0x3A, 0x86, 0x46, 0x45, 0x18, 0xB4, 0x1B, 0xF2, 0x5E, 0x29, 0xA5, 0xBA, 0x6F, 0x77, 0x8F, 0xEE, 0xB0, 0x0F, 0x73, 0xDF, 0xFC, 0x86, 0x2C, 0x4E, 0xB9, 0xF5, 0xAA, 0x8E, 0x9D, 0x65, 0xB8, 0x78, 0xD5, 0x9B, 0xB3, 0x18, 0x21, 0xCF, 0x3A, 0x57,
    0x5B, 0x88, 0xFE, 0xD3, 0xAE, 0x7D, 0x7F, 0xB9, 0xEC, 0x62, 0xE2, 0xF2, 0xB3, 0xB3, 0x72, 0xDF, 0xBF, 0x2A, 0xFB, 0x2E, 0x77, 0xF2, 0x9C, 0x4F, 0xE0, 0x8D, 0xA2, 0x9E, 0xCE, 0xEF, 0xAE, 0xFD, 0x32, 0xB7, 0x96, 0xB2, 0x8B, 0xAD, 0x03, 0xF3,
    0x89, 0x63, 0x27, 0xFB, 0x1B, 0xAC, 0x72, 0x1F, 0xFC, 0xFC, 0xE9, 0xDF, 0xF7, 0x12, 0xFF, 0x00, 0xF3, 0x99, 0xFD, 0xCB, 0x8A, 0x0D, 0x11, 0x27, 0x46, 0x8E, 0xFF, 0x00, 0xC0, 0x2B, 0x4C, 0xC2, 0x31, 0x5B, 0xED, 0x73, 0x2A, 0xAA, 0xE1, 0x2C,
    0x79, 0x70, 0x79, 0x9F, 0xDD, 0x75, 0x74, 0x9D, 0xEC, 0xFE, 0xD3, 0x50, 0x94, 0xC0, 0xDC, 0xAF, 0x8E, 0x33, 0x2F, 0x94, 0x5F, 0xE5, 0xF5, 0x2F, 0x4B, 0x67, 0xD7, 0xEA, 0x81, 0xFD, 0x16, 0x03, 0x9C, 0x3C, 0x5F, 0x68, 0x1F, 0x83, 0x6A, 0x41,
    0x77, 0xD7, 0xDC, 0x92, 0x25, 0x98, 0x35, 0x01, 0xFC, 0xA7, 0xBC, 0xFE, 0x4D, 0xAB, 0x01, 0xB8, 0x82, 0xCF, 0x4D, 0xB5, 0xBE, 0xB7, 0xDB, 0x69, 0x23, 0xD2, 0xD6, 0xB2, 0x00, 0x9F, 0x73, 0xAC, 0xB7, 0x65, 0x3E, 0xED, 0xBE, 0xD5, 0x3A, 0xFD,
    0x0A, 0x6A, 0xBF, 0x16, 0xDA, 0x5A, 0xFB, 0x7D, 0x5A, 0xCB, 0xAD, 0x2E, 0xD6, 0xA6, 0x56, 0x5E, 0xDB, 0xD8, 0x3D, 0x1D, 0xDE, 0xA5, 0x77, 0x7A, 0x8C, 0xFD, 0x25, 0x5F, 0xE8, 0xD3, 0x4E, 0x4E, 0xDA, 0x9F, 0xDD, 0xDA, 0x55, 0x7C, 0x3C, 0x5E,
    0xA4, 0xFB, 0x44, 0x6B, 0x2D, 0x07, 0xEF, 0x6E, 0x38, 0xB8, 0x78, 0x84, 0x74, 0x76, 0x9D, 0xF5, 0xCB, 0xAD, 0x5F, 0x45, 0xCE, 0xC7, 0xC2, 0xAD, 0xAD, 0xA9, 0xA3, 0xD4, 0xBD, 0x8D, 0xB1, 0xFE, 0x96, 0xE3, 0xB5, 0xB6, 0x3C, 0xB9, 0xCE, 0xAD,
    0x9E, 0xEF, 0xA3, 0xEA, 0xA0, 0x53, 0xF5, 0xB3, 0xEB, 0x06, 0x1C, 0x9C, 0xB6, 0x7A, 0xED, 0xB8, 0x07, 0x57, 0xF6, 0x86, 0x16, 0xC0, 0x1F, 0x9D, 0x51, 0xAF, 0xD1, 0xDD, 0xCF, 0xF2, 0xD4, 0xD9, 0x56, 0x15, 0xB4, 0xF5, 0x53, 0x8A, 0xCA, 0xF6,
    0x66, 0x3F, 0xD3, 0xC2, 0x65, 0x43, 0x37, 0x69, 0x73, 0x1B, 0xEB, 0xFA, 0x78, 0xCD, 0x65, 0x5E, 0x95, 0xFB, 0xB7, 0x7F, 0x35, 0x9D, 0xFC, 0xCF, 0xD3, 0xFE, 0x6D, 0x54, 0xBE, 0xCA, 0x29, 0x66, 0x3D, 0xF7, 0x62, 0x8C, 0xCA, 0x2A, 0x69, 0xC6,
    0x78, 0x2E, 0xC9, 0x0C, 0xF5, 0x40, 0x69, 0x7B, 0xBD, 0x4B, 0xF6, 0x36, 0xBB, 0xB6, 0xFF, 0x00, 0x81, 0xA7, 0xFC, 0xC5, 0x14, 0x73, 0xCC, 0xEB, 0xED, 0xCB, 0x86, 0xF8, 0x75, 0x8F, 0x0E, 0xBC, 0x1C, 0x7C, 0x3C, 0x52, 0x97, 0x0F, 0x17, 0x1F,
    0xA1, 0x8E, 0x46, 0x22, 0x71, 0x88, 0x20, 0xDD, 0xF1, 0x75, 0xE1, 0xEC, 0xDE, 0x1F, 0x5E, 0xF3, 0x87, 0xD3, 0xC3, 0xA0, 0xFC, 0x0D, 0x83, 0xFE, 0xFE, 0x51, 0x1B, 0xF5, 0xF5, 0xFF, 0x00, 0x9F, 0x80, 0xD3, 0xFD, 0x5B, 0x48, 0xFF, 0x00, 0xAA,
    0x63, 0xD7, 0x3D, 0x7D, 0xB4, 0x3B, 0x13, 0x16, 0xBF, 0x41, 0xB4, 0xDB, 0x53, 0x5F, 0xEA, 0x5A, 0xD2, 0x77, 0xDC, 0x1C, 0xED, 0xF5, 0xBE, 0xD6, 0xBB, 0xD9, 0x5F, 0xA6, 0xDF, 0xD1, 0xB3, 0xFD, 0x22, 0x1B, 0xAB, 0x2D, 0xAE, 0xB7, 0xB0, 0x35,
    0xFE, 0xA3, 0x4B, 0x8B, 0x40, 0x2E, 0x2D, 0x82, 0x5B, 0xEF, 0x9F, 0x86, 0xF5, 0x30, 0x97, 0x71, 0x5A, 0x91, 0xF6, 0x7F, 0xDF, 0x2E, 0xE1, 0xBB, 0xAD, 0x68, 0x5B, 0xD6, 0x0F, 0xAF, 0x78, 0x44, 0x6B, 0x87, 0x68, 0x3D, 0xC0, 0xB1, 0xA7, 0xF1,
    0xD8, 0x11, 0x28, 0xFA, 0xEB, 0xD2, 0xAD, 0x7E, 0xDB, 0xAB, 0xB7, 0x1C, 0x1F, 0xCF, 0x31, 0x60, 0xFE, 0xD6, 0xC8, 0x7F, 0xFD, 0x05, 0xC7, 0x58, 0xC6, 0xB0, 0xB4, 0x17, 0x35, 0xDB, 0x9A, 0x1C, 0x76, 0x4F, 0xB6, 0x7F, 0x31, 0xCD, 0x7F, 0xE7,
    0xB7, 0xF3, 0x90, 0xDC, 0xD8, 0x83, 0xCB, 0x4F, 0x04, 0x22, 0x0D, 0xA0, 0xC6, 0xB4, 0x2F, 0xA7, 0x62, 0xE5, 0x63, 0xE6, 0xD2, 0x2F, 0xC4, 0xB0, 0x5D, 0x59, 0xEE, 0xDE, 0x44, 0x7E, 0xF3, 0x0F, 0xBD, 0x9F, 0xDB, 0x6A, 0x99, 0x2B, 0xCB, 0xEB,
    0x7D, 0xB5, 0x3C, 0x59, 0x53, 0xDD, 0x5B, 0xC7, 0x0E, 0x69, 0x21, 0xC3, 0xFB, 0x4D, 0x5D, 0x5F, 0x44, 0xFA, 0xCF, 0xF6, 0x83, 0x4E, 0x0E, 0x6B, 0x5D, 0xEB, 0xBA, 0x18, 0xCC, 0x99, 0x90, 0xF7, 0x13, 0xEC, 0xF5, 0x5B, 0xF4, 0x9A, 0xEF, 0xCC,
    0xF5, 0x11, 0xB4, 0x53, 0xFF, 0xD0, 0xF3, 0xCE, 0xB0, 0xE2, 0x7A, 0xC7, 0x50, 0x24, 0xEB, 0xF6, 0x9B, 0x47, 0xC8, 0x3D, 0xCA, 0x8B, 0x41, 0x7B, 0x83, 0x47, 0x2E, 0x20, 0x0F, 0x89, 0x5A, 0x3F, 0x58, 0xEB, 0xF4, 0xBA, 0xE6, 0x73, 0x47, 0xE7,
    0x5A, 0x5F, 0xFE, 0x78, 0xF5, 0x7F, 0xEF, 0xEA, 0x8E, 0x38, 0x9B, 0xD8, 0x3B, 0x93, 0x03, 0xE3, 0x1A, 0x24, 0xAE, 0x81, 0xBB, 0x86, 0xD1, 0x59, 0x6D, 0xF5, 0xBE, 0xCA, 0x6E, 0x97, 0x37, 0x1D, 0xEE, 0x60, 0xF4, 0x8D, 0x71, 0xE9, 0xDA, 0xFF,
    0x00, 0x52, 0xCD, 0xFE, 0xFF, 0x00, 0x7B, 0xBF, 0xC1, 0xBF, 0xD3, 0x53, 0x6F, 0x51, 0x15, 0x56, 0xE6, 0x62, 0x33, 0xEC, 0xEE, 0x70, 0x83, 0x73, 0x23, 0x7B, 0xC9, 0x32, 0xF7, 0x3D, 0xEF, 0xDC, 0xEA, 0xAB, 0xFF, 0x00, 0x47, 0x55, 0x2A, 0x55,
    0x31, 0xCF, 0xC1, 0xA9, 0xB4, 0x3E, 0xEB, 0x26, 0x97, 0xB5, 0xC1, 0xCF, 0x69, 0xAD, 0x8E, 0x32, 0xE7, 0xD7, 0x5B, 0x41, 0x77, 0xA4, 0xC7, 0x33, 0xE9, 0xFA, 0xBE, 0x9E, 0xF5, 0x5B, 0xEC, 0xF5, 0x86, 0xB8, 0xDB, 0x73, 0x5A, 0xE0, 0x3D, 0xB5,
    0xD7, 0xFA, 0x47, 0x13, 0xDB, 0x73, 0x99, 0xFA, 0x16, 0x37, 0xFE, 0xB8, 0xAB, 0xD4, 0x64, 0x49, 0x96, 0xBA, 0xED, 0xFD, 0xD3, 0xA7, 0xA7, 0xF7, 0x5B, 0xF1, 0xE3, 0x84, 0x23, 0xED, 0xE9, 0x62, 0xCC, 0xBE, 0x5F, 0x9A, 0x3F, 0xA3, 0x23, 0xF2,
    0xC9, 0x33, 0x3A, 0xA6, 0x61, 0xF6, 0xE4, 0x3B, 0xED, 0x75, 0x93, 0x2E, 0xAF, 0x23, 0xDE, 0x0C, 0x8D, 0xBF, 0xCE, 0x7F, 0x3D, 0x5F, 0xB7, 0xFD, 0x1D, 0x8A, 0xD5, 0xCC, 0x2F, 0xA2, 0x96, 0xD7, 0x65, 0xF6, 0x63, 0x10, 0xE7, 0x60, 0x53, 0x5D,
    0x6D, 0xB0, 0x87, 0x8F, 0x65, 0xB4, 0x5F, 0xF4, 0x5F, 0xB5, 0xAF, 0x77, 0xA7, 0xF9, 0xFB, 0xFF, 0x00, 0x9C, 0xF4, 0xFF, 0x00, 0x4A, 0xB2, 0xAB, 0x6B, 0xE3, 0x51, 0xAA, 0xD6, 0xC2, 0x13, 0x80, 0x19, 0xFA, 0x77, 0x3B, 0xD7, 0x73, 0x83, 0x71,
    0x27, 0xD6, 0x00, 0x32, 0xB9, 0x77, 0xFC, 0x5B, 0x9D, 0xFF, 0x00, 0x50, 0x86, 0x48, 0xC6, 0x26, 0x26, 0x20, 0x0D, 0x7A, 0x0F, 0xF9, 0xDF, 0xDE, 0xFE, 0xB2, 0xEC, 0x66, 0x53, 0x84, 0x84, 0xC9, 0x3E, 0x9F, 0xD2, 0xBB, 0xFE, 0xEF, 0xF7, 0x7F,
    0xA8, 0xC7, 0xA4, 0x39, 0x95, 0x65, 0x36, 0x9B, 0x0B, 0x3D, 0x2F, 0x5A, 0x8B, 0x29, 0x65, 0xD7, 0xD9, 0x4B, 0x58, 0x5F, 0x6D, 0x75, 0xE4, 0x7F, 0x37, 0xF9, 0xDE, 0x96, 0xFC, 0x5C, 0xAB, 0x3D, 0x3F, 0xD1, 0xD3, 0xFA, 0x45, 0x57, 0x22, 0xB2,
    0xCD, 0x5F, 0x92, 0xDB, 0xF1, 0xE6, 0xCC, 0x87, 0x63, 0xD6, 0xF7, 0x3D, 0xAD, 0x78, 0xB1, 0xD8, 0xCC, 0x6D, 0x93, 0xFA, 0x3D, 0xF7, 0xFA, 0x75, 0xBF, 0x7F, 0xD3, 0xFB, 0x2A, 0x2E, 0x36, 0x55, 0x98, 0xF9, 0x95, 0x8A, 0x32, 0x5D, 0x8B, 0x5B,
    0xDD, 0xBB, 0xD5, 0xB9, 0xAD, 0x73, 0x80, 0xAF, 0x21, 0xD6, 0xD0, 0xEB, 0x9A, 0xED, 0xCD, 0xDF, 0x5D, 0x8C, 0xF5, 0x6C, 0x55, 0x5E, 0x1B, 0x61, 0xBC, 0xBA, 0xDD, 0xE2, 0xCB, 0x2B, 0x7D, 0xD6, 0x81, 0x3A, 0x38, 0xD9, 0xEA, 0x3F, 0x6B, 0x7F,
    0x96, 0xE4, 0xE8, 0x89, 0x7B, 0x92, 0x24, 0xFA, 0x74, 0x9F, 0x0F, 0xAA, 0x5F, 0xA3, 0xC3, 0xF2, 0xFC, 0x90, 0xFF, 0x00, 0x01, 0xA8, 0x71, 0x0F, 0x6C, 0x48, 0x08, 0xEF, 0xC3, 0x7E, 0x9B, 0xBF, 0xFA, 0x4C, 0xF1, 0xDA, 0xE3, 0x55, 0x8E, 0xCA,
    0x6C, 0x81, 0x64, 0x96, 0xB8, 0x43, 0x8D, 0x80, 0x6D, 0x87, 0x7E, 0xEB, 0x5B, 0xEE, 0xF6, 0x2B, 0xF5, 0xD9, 0x95, 0x53, 0x4B, 0x29, 0xCA, 0x6D, 0x4D, 0x90, 0x76, 0xD7, 0x66, 0xC1, 0x27, 0xBF, 0xB7, 0x6A, 0x26, 0x37, 0xA9, 0x85, 0x7B, 0x65,
    0xCC, 0x7F, 0xA3, 0x65, 0x95, 0xDC, 0x72, 0x00, 0x1B, 0x83, 0x88, 0xF5, 0x77, 0x54, 0xF3, 0xEA, 0xEE, 0x7B, 0x5D, 0xFD, 0x75, 0x53, 0xA9, 0x53, 0x47, 0xA8, 0x47, 0x4F, 0xB1, 0xCE, 0x66, 0xF3, 0xB0, 0x11, 0xB0, 0x06, 0x7E, 0x64, 0xB9, 0xE7,
    0x7D, 0x8F, 0xFE, 0xCA, 0x88, 0xCB, 0x8E, 0x74, 0x47, 0xA4, 0xEB, 0xC5, 0x5C, 0x50, 0xFF, 0x00, 0xD0, 0x5D, 0x5C, 0x70, 0xF6, 0x70, 0x83, 0x18, 0x99, 0x4A, 0x87, 0x10, 0x8F, 0xF3, 0x92, 0xBF, 0xFA, 0x7C, 0x2D, 0x97, 0xB2, 0xBC, 0xE3, 0xE8,
    0x65, 0xBA, 0xB7, 0x5E, 0xFD, 0x29, 0xC9, 0x04, 0x48, 0x7C, 0x43, 0x1B, 0x91, 0x65, 0x63, 0xF4, 0x95, 0x3F, 0xE8, 0xFA, 0x8E, 0xFD, 0x25, 0x3F, 0xF1, 0x5B, 0xEB, 0x59, 0x16, 0xB3, 0x21, 0xF7, 0xDC, 0x6F, 0x61, 0x06, 0xEB, 0x1C, 0x1C, 0xED,
    0xBB, 0x5B, 0xEA, 0xFD, 0x3D, 0xA3, 0xF3, 0x5A, 0xE6, 0xEE, 0xF7, 0x33, 0xF9, 0x6B, 0x41, 0xAE, 0xFD, 0x5C, 0xD5, 0x26, 0x4B, 0x83, 0xB9, 0x1B, 0x78, 0x8F, 0xEB, 0x6E, 0x50, 0xEB, 0x2E, 0x75, 0x9D, 0x4D, 0xCF, 0xA5, 0xFE, 0xA6, 0x35, 0x97,
    0x0D, 0x8E, 0x6B, 0xA5, 0x8E, 0xB0, 0x06, 0x3A, 0xC7, 0xB6, 0x0F, 0xEE, 0xD9, 0x5A, 0x76, 0x1B, 0x8C, 0xF8, 0x7F, 0x44, 0x83, 0x5D, 0xA3, 0xC3, 0x5F, 0x2F, 0xF7, 0xFF, 0x00, 0x77, 0xFA, 0x8C, 0x3F, 0x10, 0xC7, 0x1F, 0x6C, 0x64, 0xDA, 0x56,
    0x01, 0xEF, 0x2B, 0xFD, 0xEF, 0xEE, 0x7E, 0xF7, 0xF5, 0xDC, 0x80, 0x75, 0x05, 0x5E, 0xE9, 0x6D, 0x2F, 0xEA, 0xB8, 0x40, 0x7F, 0xA7, 0x61, 0xFB, 0x9C, 0x1C, 0xA9, 0x18, 0x24, 0x91, 0xC1, 0x26, 0x3E, 0xF5, 0xA9, 0xF5, 0x75, 0x9B, 0xFA, 0xB5,
    0x4E, 0xED, 0x53, 0x1E, 0xFF, 0x00, 0xFA, 0x3B, 0x1B, 0xFF, 0x00, 0x49, 0xEA, 0xD3, 0x97, 0x7A, 0x17, 0xFF, 0xD1, 0xF3, 0xEE, 0xBF, 0x99, 0x46, 0x77, 0x54, 0xB7, 0x2A, 0x86, 0xBD, 0xAC, 0xB1, 0xAC, 0x90, 0xF0, 0x01, 0x96, 0xB5, 0xB5, 0x9F,
    0xA2, 0xE7, 0x7E, 0xE2, 0x86, 0x37, 0x4B, 0xCA, 0xB7, 0x26, 0x8A, 0xAB, 0xB2, 0x96, 0x59, 0x73, 0x45, 0xB5, 0xB9, 0xD6, 0x34, 0x34, 0x0F, 0xA6, 0x3D, 0x47, 0xFD, 0x16, 0x3B, 0xF7, 0xBF, 0x73, 0xF3, 0xD4, 0x69, 0xC6, 0xAB, 0x23, 0x25, 0x95,
    0xD9, 0x68, 0xA0, 0x3F, 0x4F, 0x55, 0xFA, 0x31, 0xA4, 0x02, 0x5A, 0x6C, 0x3F, 0xBB, 0xB9, 0x10, 0x74, 0xCC, 0x60, 0xE0, 0x2C, 0xEA, 0x38, 0xC1, 0xA4, 0xFB, 0x8B, 0x37, 0x3E, 0x07, 0xEF, 0x7D, 0x16, 0x6E, 0x42, 0x42, 0x47, 0xE5, 0x20, 0x6F,
    0xD3, 0x89, 0x5D, 0x47, 0x6E, 0xA1, 0x03, 0xCB, 0x77, 0x30, 0xB9, 0xCE, 0xFB, 0x25, 0xAE, 0xDF, 0xB4, 0x1D, 0x01, 0xFA, 0x36, 0xB4, 0x34, 0xFB, 0x3D, 0x5A, 0xFF, 0x00, 0xEA, 0x3D, 0x35, 0x70, 0x1E, 0x80, 0xD6, 0x37, 0x78, 0xC8, 0x71, 0x70,
    0x2E, 0x1B, 0x5F, 0x50, 0x81, 0xB9, 0xCD, 0x6B, 0x5E, 0xDD, 0x8E, 0xD8, 0xFD, 0x81, 0x46, 0xAC, 0x3C, 0x76, 0x0D, 0x7A, 0x9D, 0x0C, 0xDD, 0xF4, 0x9A, 0x1A, 0xE7, 0x0D, 0x38, 0x3F, 0x47, 0x6A, 0x9F, 0xD9, 0xF1, 0xA1, 0xBF, 0xE5, 0x5A, 0xC1,
    0x20, 0xEF, 0x06, 0xB3, 0xA6, 0xBE, 0xDF, 0xA3, 0x3B, 0xB7, 0x21, 0x2C, 0x7C, 0x55, 0xA9, 0x8F, 0xF7, 0x4F, 0x0B, 0x2E, 0x3C, 0xDC, 0x17, 0xE9, 0x8C, 0xAF, 0xF7, 0xC5, 0xB1, 0xB9, 0x9D, 0x20, 0x5F, 0xE9, 0xD2, 0xF7, 0x06, 0x10, 0x21, 0xCF,
    0x2C, 0x78, 0x9D, 0x77, 0x6E, 0xB1, 0x82, 0xBF, 0xFA, 0x84, 0x16, 0xFF, 0x00, 0x48, 0x2C, 0xC4, 0xB3, 0x61, 0x04, 0x8F, 0x59, 0x87, 0x6E, 0xD6, 0x03, 0xEE, 0xB1, 0xCE, 0x64, 0x7B, 0x76, 0xFB, 0x95, 0x81, 0x8F, 0x89, 0x3A, 0xF5, 0x76, 0x44,
    0x1D, 0x45, 0x4E, 0xE7, 0xF3, 0x42, 0x76, 0xE2, 0xE0, 0xD8, 0xDD, 0x8F, 0xEA, 0xCD, 0x25, 0xD1, 0x2D, 0x0C, 0x20, 0x12, 0x35, 0xDA, 0xE7, 0x3B, 0x6B, 0x10, 0x8E, 0x3A, 0xDE, 0x46, 0x5A, 0x75, 0x5D, 0x3E, 0x67, 0x88, 0x10, 0x21, 0x18, 0x6B,
    0xBC, 0x77, 0x76, 0xBE, 0xAC, 0x1E, 0x8A, 0xF1, 0x7E, 0x5E, 0x75, 0xB8, 0xA0, 0x98, 0xAE, 0x8A, 0x32, 0xB5, 0x70, 0xAE, 0xB1, 0xB6, 0xBF, 0x6B, 0x7E, 0x8D, 0xB6, 0x3B, 0xDF, 0x62, 0x87, 0xD6, 0xAB, 0x3A, 0x1E, 0xEA, 0xEC, 0xC2, 0xB7, 0x1C,
    0x87, 0xEF, 0xAA, 0xEA, 0xF1, 0x5A, 0x5A, 0x05, 0x6F, 0xE1, 0xC0, 0x1F, 0x7B, 0xBD, 0x0B, 0x6A, 0xF5, 0xBF, 0xE1, 0x3D, 0x5F, 0x4D, 0x63, 0xBB, 0xA4, 0x61, 0x16, 0x83, 0x47, 0x53, 0xA0, 0xB8, 0x81, 0xA5, 0x91, 0x58, 0xDD, 0xF9, 0xFE, 0xE0,
    0xFB, 0x3D, 0xBF, 0xBA, 0xA6, 0xCE, 0x8B, 0xD3, 0xFD, 0x29, 0xB3, 0xAB, 0xE3, 0xB6, 0xDE, 0x0B, 0x1B, 0x05, 0xB3, 0x3F, 0xE9, 0x37, 0x7B, 0x9B, 0xB7, 0xF9, 0x0A, 0xBF, 0xDC, 0xBF, 0xA4, 0x7B, 0xFE, 0xEC, 0xFF, 0x00, 0xB9, 0xFA, 0x15, 0x5C,
    0x3C, 0x28, 0xF7, 0xFF, 0x00, 0x57, 0xC1, 0xC3, 0xF5, 0xFF, 0x00, 0x9D, 0x6D, 0x6A, 0x1D, 0x8B, 0x5D, 0x8F, 0x66, 0x70, 0xDC, 0xF6, 0x8D, 0x1C, 0xD2, 0xDF, 0x74, 0xC1, 0x6D, 0x9E, 0xA5, 0x81, 0xDB, 0xD8, 0xE6, 0x2B, 0x06, 0xEE, 0x8B, 0xED,
    0xDA, 0xD7, 0x0F, 0xDE, 0x24, 0xD6, 0x74, 0x8F, 0xCD, 0xF6, 0xFE, 0xF2, 0x81, 0xA7, 0xA7, 0x56, 0xDF, 0x4D, 0x9D, 0x55, 0xE3, 0x6E, 0x80, 0x0A, 0xC9, 0x6F, 0xF6, 0x76, 0xBD, 0x27, 0x0E, 0x9F, 0xBD, 0xDB, 0x7A, 0xB5, 0xBB, 0x27, 0xD9, 0x35,
    0x12, 0x63, 0xF9, 0x51, 0x67, 0xD2, 0x53, 0xCB, 0x08, 0x26, 0xF8, 0x88, 0xF2, 0x3A, 0x33, 0x62, 0xE7, 0xA5, 0x08, 0x88, 0xF0, 0x42, 0x55, 0xD4, 0x8F, 0x53, 0x27, 0xDD, 0xD2, 0x7D, 0x3F, 0x68, 0xF7, 0x81, 0xCF, 0xB0, 0x89, 0xFE, 0xAC, 0x6E,
    0x54, 0x4B, 0xE2, 0x6F, 0x03, 0x6B, 0x75, 0x6D, 0x20, 0x78, 0x91, 0x0E, 0x7F, 0xF6, 0x3F, 0xF3, 0xE7, 0xA6, 0xAE, 0x47, 0x4C, 0xDB, 0xAF, 0x53, 0xB8, 0xBB, 0x77, 0x22, 0xB2, 0x06, 0xD8, 0xFE, 0xB1, 0xF7, 0xEE, 0x43, 0x34, 0xF4, 0x87, 0x58,
    0xD7, 0x5B, 0xD4, 0x6D, 0x7B, 0x66, 0x1D, 0xFA, 0x13, 0xBB, 0x6F, 0xF2, 0x77, 0x3D, 0x3A, 0x18, 0xC4, 0x7A, 0x93, 0xE6, 0x58, 0xF9, 0x8E, 0x6A, 0x59, 0x80, 0x06, 0x31, 0x80, 0x1F, 0xB8, 0x37, 0x73, 0xD6, 0x8F, 0x43, 0xCE, 0xC7, 0xC2, 0xC9,
    0xB6, 0xCB, 0xC3, 0xA1, 0xEC, 0xD8, 0x0B, 0x44, 0xC4, 0xB8, 0x38, 0xEE, 0x12, 0x3F, 0x75, 0x0D, 0xB8, 0xDD, 0x28, 0xB8, 0x6E, 0xCF, 0x70, 0x13, 0xAC, 0x50, 0x78, 0xFF, 0x00, 0x3D, 0x56, 0x2D, 0x68, 0x71, 0xD9, 0x3B, 0x49, 0xD2, 0x79, 0x8E,
    0xC9, 0xED, 0x77, 0xFF, 0xD9, 0x00, 0x38, 0x42, 0x49, 0x4D, 0x04, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x08, 0x01, 0x01, 0x00, 0x01, 0x01, 0x00, 0xFF, 0xE1, 0x0A, 0xAB, 0x45, 0x78, 0x69, 0x66, 0x00, 0x00, 0x49, 0x49, 0x2A, 0x00,
    0x08, 0x00, 0x00, 0x00, 0x03, 0x00, 0x1A, 0x01, 0x05, 0x00, 0x01, 0x00, 0x00, 0x00, 0x32, 0x00, 0x00, 0x00, 0x1B, 0x01, 0x05, 0x00, 0x01, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x28, 0x01, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x3A, 0x00, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x48, 0x00, 0x00, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03, 0x01, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x01, 0x02, 0x04, 0x00,
    0x01, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00, 0x02, 0x02, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 0x37, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xD8, 0xFF, 0xE0, 0x00, 0x10, 0x4A, 0x46, 0x49, 0x46, 0x00, 0x01, 0x02, 0x01, 0x00, 0x48,
    0x00, 0x48, 0x00, 0x00, 0xFF, 0xEE, 0x00, 0x0E, 0x41, 0x64, 0x6F, 0x62, 0x65, 0x00, 0x64, 0x80, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xDB, 0x00, 0x84, 0x00, 0x0C, 0x08, 0x08, 0x08, 0x09, 0x08, 0x0C, 0x09, 0x09, 0x0C, 0x11, 0x0B, 0x0A, 0x0B, 0x11,
    0x15, 0x0F, 0x0C, 0x0C, 0x0F, 0x15, 0x18, 0x13, 0x13, 0x15, 0x13, 0x13, 0x18, 0x11, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x11, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C,
    0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x01, 0x0D, 0x0B, 0x0B, 0x0D, 0x0E, 0x0D, 0x10, 0x0E, 0x0E, 0x10, 0x14, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x11, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x11, 0x11, 0x0C,
    0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x11, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xFF, 0xC0, 0x00, 0x11, 0x08, 0x00,
    0x30, 0x00, 0x70, 0x03, 0x01, 0x22, 0x00, 0x02, 0x11, 0x01, 0x03, 0x11, 0x01, 0xFF, 0xDD, 0x00, 0x04, 0x00, 0x07, 0xFF, 0xC4, 0x01, 0x3F, 0x00, 0x00, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x03, 0x00, 0x01, 0x02, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x01, 0x00, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A,
    0x0B, 0x10, 0x00, 0x01, 0x04, 0x01, 0x03, 0x02, 0x04, 0x02, 0x05, 0x07, 0x06, 0x08, 0x05, 0x03, 0x0C, 0x33, 0x01, 0x00, 0x02, 0x11, 0x03, 0x04, 0x21, 0x12, 0x31, 0x05, 0x41, 0x51, 0x61, 0x13, 0x22, 0x71, 0x81, 0x32, 0x06, 0x14, 0x91, 0xA1,
    0xB1, 0x42, 0x23, 0x24, 0x15, 0x52, 0xC1, 0x62, 0x33, 0x34, 0x72, 0x82, 0xD1, 0x43, 0x07, 0x25, 0x92, 0x53, 0xF0, 0xE1, 0xF1, 0x63, 0x73, 0x35, 0x16, 0xA2, 0xB2, 0x83, 0x26, 0x44, 0x93, 0x54, 0x64, 0x45, 0xC2, 0xA3, 0x74, 0x36, 0x17, 0xD2,
    0x55, 0xE2, 0x65, 0xF2, 0xB3, 0x84, 0xC3, 0xD3, 0x75, 0xE3, 0xF3, 0x46, 0x27, 0x94, 0xA4, 0x85, 0xB4, 0x95, 0xC4, 0xD4, 0xE4, 0xF4, 0xA5, 0xB5, 0xC5, 0xD5, 0xE5, 0xF5, 0x56, 0x66, 0x76, 0x86, 0x96, 0xA6, 0xB6, 0xC6, 0xD6, 0xE6, 0xF6, 0x37,
    0x47, 0x57, 0x67, 0x77, 0x87, 0x97, 0xA7, 0xB7, 0xC7, 0xD7, 0xE7, 0xF7, 0x11, 0x00, 0x02, 0x02, 0x01, 0x02, 0x04, 0x04, 0x03, 0x04, 0x05, 0x06, 0x07, 0x07, 0x06, 0x05, 0x35, 0x01, 0x00, 0x02, 0x11, 0x03, 0x21, 0x31, 0x12, 0x04, 0x41, 0x51,
    0x61, 0x71, 0x22, 0x13, 0x05, 0x32, 0x81, 0x91, 0x14, 0xA1, 0xB1, 0x42, 0x23, 0xC1, 0x52, 0xD1, 0xF0, 0x33, 0x24, 0x62, 0xE1, 0x72, 0x82, 0x92, 0x43, 0x53, 0x15, 0x63, 0x73, 0x34, 0xF1, 0x25, 0x06, 0x16, 0xA2, 0xB2, 0x83, 0x07, 0x26, 0x35,
    0xC2, 0xD2, 0x44, 0x93, 0x54, 0xA3, 0x17, 0x64, 0x45, 0x55, 0x36, 0x74, 0x65, 0xE2, 0xF2, 0xB3, 0x84, 0xC3, 0xD3, 0x75, 0xE3, 0xF3, 0x46, 0x94, 0xA4, 0x85, 0xB4, 0x95, 0xC4, 0xD4, 0xE4, 0xF4, 0xA5, 0xB5, 0xC5, 0xD5, 0xE5, 0xF5, 0x56, 0x66,
    0x76, 0x86, 0x96, 0xA6, 0xB6, 0xC6, 0xD6, 0xE6, 0xF6, 0x27, 0x37, 0x47, 0x57, 0x67, 0x77, 0x87, 0x97, 0xA7, 0xB7, 0xC7, 0xFF, 0xDA, 0x00, 0x0C, 0x03, 0x01, 0x00, 0x02, 0x11, 0x03, 0x11, 0x00, 0x3F, 0x00, 0x3A, 0x86, 0x46, 0x45, 0x18, 0xB4,
    0x1B, 0xF2, 0x5E, 0x29, 0xA5, 0xBA, 0x6F, 0x77, 0x8F, 0xEE, 0xB0, 0x0F, 0x73, 0xDF, 0xFC, 0x86, 0x2C, 0x4E, 0xB9, 0xF5, 0xAA, 0x8E, 0x9D, 0x65, 0xB8, 0x78, 0xD5, 0x9B, 0xB3, 0x18, 0x21, 0xCF, 0x3A, 0x57, 0x5B, 0x88, 0xFE, 0xD3, 0xAE, 0x7D,
    0x7F, 0xB9, 0xEC, 0x62, 0xE2, 0xF2, 0xB3, 0xB3, 0x72, 0xDF, 0xBF, 0x2A, 0xFB, 0x2E, 0x77, 0xF2, 0x9C, 0x4F, 0xE0, 0x8D, 0xA2, 0x9E, 0xCE, 0xEF, 0xAE, 0xFD, 0x32, 0xB7, 0x96, 0xB2, 0x8B, 0xAD, 0x03, 0xF3, 0x89, 0x63, 0x27, 0xFB, 0x1B, 0xAC,
    0x72, 0x1F, 0xFC, 0xFC, 0xE9, 0xDF, 0xF7, 0x12, 0xFF, 0x00, 0xF3, 0x99, 0xFD, 0xCB, 0x8A, 0x0D, 0x11, 0x27, 0x46, 0x8E, 0xFF, 0x00, 0xC0, 0x2B, 0x4C, 0xC2, 0x31, 0x5B, 0xED, 0x73, 0x2A, 0xAA, 0xE1, 0x2C, 0x79, 0x70, 0x79, 0x9F, 0xDD, 0x75,
    0x74, 0x9D, 0xEC, 0xFE, 0xD3, 0x50, 0x94, 0xC0, 0xDC, 0xAF, 0x8E, 0x33, 0x2F, 0x94, 0x5F, 0xE5, 0xF5, 0x2F, 0x4B, 0x67, 0xD7, 0xEA, 0x81, 0xFD, 0x16, 0x03, 0x9C, 0x3C, 0x5F, 0x68, 0x1F, 0x83, 0x6A, 0x41, 0x77, 0xD7, 0xDC, 0x92, 0x25, 0x98,
    0x35, 0x01, 0xFC, 0xA7, 0xBC, 0xFE, 0x4D, 0xAB, 0x01, 0xB8, 0x82, 0xCF, 0x4D, 0xB5, 0xBE, 0xB7, 0xDB, 0x69, 0x23, 0xD2, 0xD6, 0xB2, 0x00, 0x9F, 0x73, 0xAC, 0xB7, 0x65, 0x3E, 0xED, 0xBE, 0xD5, 0x3A, 0xFD, 0x0A, 0x6A, 0xBF, 0x16, 0xDA, 0x5A,
    0xFB, 0x7D, 0x5A, 0xCB, 0xAD, 0x2E, 0xD6, 0xA6, 0x56, 0x5E, 0xDB, 0xD8, 0x3D, 0x1D, 0xDE, 0xA5, 0x77, 0x7A, 0x8C, 0xFD, 0x25, 0x5F, 0xE8, 0xD3, 0x4E, 0x4E, 0xDA, 0x9F, 0xDD, 0xDA, 0x55, 0x7C, 0x3C, 0x5E, 0xA4, 0xFB, 0x44, 0x6B, 0x2D, 0x07,
    0xEF, 0x6E, 0x38, 0xB8, 0x78, 0x84, 0x74, 0x76, 0x9D, 0xF5, 0xCB, 0xAD, 0x5F, 0x45, 0xCE, 0xC7, 0xC2, 0xAD, 0xAD, 0xA9, 0xA3, 0xD4, 0xBD, 0x8D, 0xB1, 0xFE, 0x96, 0xE3, 0xB5, 0xB6, 0x3C, 0xB9, 0xCE, 0xAD, 0x9E, 0xEF, 0xA3, 0xEA, 0xA0, 0x53,
    0xF5, 0xB3, 0xEB, 0x06, 0x1C, 0x9C, 0xB6, 0x7A, 0xED, 0xB8, 0x07, 0x57, 0xF6, 0x86, 0x16, 0xC0, 0x1F, 0x9D, 0x51, 0xAF, 0xD1, 0xDD, 0xCF, 0xF2, 0xD4, 0xD9, 0x56, 0x15, 0xB4, 0xF5, 0x53, 0x8A, 0xCA, 0xF6, 0x66, 0x3F, 0xD3, 0xC2, 0x65, 0x43,
    0x37, 0x69, 0x73, 0x1B, 0xEB, 0xFA, 0x78, 0xCD, 0x65, 0x5E, 0x95, 0xFB, 0xB7, 0x7F, 0x35, 0x9D, 0xFC, 0xCF, 0xD3, 0xFE, 0x6D, 0x54, 0xBE, 0xCA, 0x29, 0x66, 0x3D, 0xF7, 0x62, 0x8C, 0xCA, 0x2A, 0x69, 0xC6, 0x78, 0x2E, 0xC9, 0x0C, 0xF5, 0x40,
    0x69, 0x7B, 0xBD, 0x4B, 0xF6, 0x36, 0xBB, 0xB6, 0xFF, 0x00, 0x81, 0xA7, 0xFC, 0xC5, 0x14, 0x73, 0xCC, 0xEB, 0xED, 0xCB, 0x86, 0xF8, 0x75, 0x8F, 0x0E, 0xBC, 0x1C, 0x7C, 0x3C, 0x52, 0x97, 0x0F, 0x17, 0x1F, 0xA1, 0x8E, 0x46, 0x22, 0x71, 0x88,
    0x20, 0xDD, 0xF1, 0x75, 0xE1, 0xEC, 0xDE, 0x1F, 0x5E, 0xF3, 0x87, 0xD3, 0xC3, 0xA0, 0xFC, 0x0D, 0x83, 0xFE, 0xFE, 0x51, 0x1B, 0xF5, 0xF5, 0xFF, 0x00, 0x9F, 0x80, 0xD3, 0xFD, 0x5B, 0x48, 0xFF, 0x00, 0xAA, 0x63, 0xD7, 0x3D, 0x7D, 0xB4, 0x3B,
    0x13, 0x16, 0xBF, 0x41, 0xB4, 0xDB, 0x53, 0x5F, 0xEA, 0x5A, 0xD2, 0x77, 0xDC, 0x1C, 0xED, 0xF5, 0xBE, 0xD6, 0xBB, 0xD9, 0x5F, 0xA6, 0xDF, 0xD1, 0xB3, 0xFD, 0x22, 0x1B, 0xAB, 0x2D, 0xAE, 0xB7, 0xB0, 0x35, 0xFE, 0xA3, 0x4B, 0x8B, 0x40, 0x2E,
    0x2D, 0x82, 0x5B, 0xEF, 0x9F, 0x86, 0xF5, 0x30, 0x97, 0x71, 0x5A, 0x91, 0xF6, 0x7F, 0xDF, 0x2E, 0xE1, 0xBB, 0xAD, 0x68, 0x5B, 0xD6, 0x0F, 0xAF, 0x78, 0x44, 0x6B, 0x87, 0x68, 0x3D, 0xC0, 0xB1, 0xA7, 0xF1, 0xD8, 0x11, 0x28, 0xFA, 0xEB, 0xD2,
    0xAD, 0x7E, 0xDB, 0xAB, 0xB7, 0x1C, 0x1F, 0xCF, 0x31, 0x60, 0xFE, 0xD6, 0xC8, 0x7F, 0xFD, 0x05, 0xC7, 0x58, 0xC6, 0xB0, 0xB4, 0x17, 0x35, 0xDB, 0x9A, 0x1C, 0x76, 0x4F, 0xB6, 0x7F, 0x31, 0xCD, 0x7F, 0xE7, 0xB7, 0xF3, 0x90, 0xDC, 0xD8, 0x83,
    0xCB, 0x4F, 0x04, 0x22, 0x0D, 0xA0, 0xC6, 0xB4, 0x2F, 0xA7, 0x62, 0xE5, 0x63, 0xE6, 0xD2, 0x2F, 0xC4, 0xB0, 0x5D, 0x59, 0xEE, 0xDE, 0x44, 0x7E, 0xF3, 0x0F, 0xBD, 0x9F, 0xDB, 0x6A, 0x99, 0x2B, 0xCB, 0xEB, 0x7D, 0xB5, 0x3C, 0x59, 0x53, 0xDD,
    0x5B, 0xC7, 0x0E, 0x69, 0x21, 0xC3, 0xFB, 0x4D, 0x5D, 0x5F, 0x44, 0xFA, 0xCF, 0xF6, 0x83, 0x4E, 0x0E, 0x6B, 0x5D, 0xEB, 0xBA, 0x18, 0xCC, 0x99, 0x90, 0xF7, 0x13, 0xEC, 0xF5, 0x5B, 0xF4, 0x9A, 0xEF, 0xCC, 0xF5, 0x11, 0xB4, 0x53, 0xFF, 0xD0,
    0xF3, 0xCE, 0xB0, 0xE2, 0x7A, 0xC7, 0x50, 0x24, 0xEB, 0xF6, 0x9B, 0x47, 0xC8, 0x3D, 0xCA, 0x8B, 0x41, 0x7B, 0x83, 0x47, 0x2E, 0x20, 0x0F, 0x89, 0x5A, 0x3F, 0x58, 0xEB, 0xF4, 0xBA, 0xE6, 0x73, 0x47, 0xE7, 0x5A, 0x5F, 0xFE, 0x78, 0xF5, 0x7F,
    0xEF, 0xEA, 0x8E, 0x38, 0x9B, 0xD8, 0x3B, 0x93, 0x03, 0xE3, 0x1A, 0x24, 0xAE, 0x81, 0xBB, 0x86, 0xD1, 0x59, 0x6D, 0xF5, 0xBE, 0xCA, 0x6E, 0x97, 0x37, 0x1D, 0xEE, 0x60, 0xF4, 0x8D, 0x71, 0xE9, 0xDA, 0xFF, 0x00, 0x52, 0xCD, 0xFE, 0xFF, 0x00,
    0x7B, 0xBF, 0xC1, 0xBF, 0xD3, 0x53, 0x6F, 0x51, 0x15, 0x56, 0xE6, 0x62, 0x33, 0xEC, 0xEE, 0x70, 0x83, 0x73, 0x23, 0x7B, 0xC9, 0x32, 0xF7, 0x3D, 0xEF, 0xDC, 0xEA, 0xAB, 0xFF, 0x00, 0x47, 0x55, 0x2A, 0x55, 0x31, 0xCF, 0xC1, 0xA9, 0xB4, 0x3E,
    0xEB, 0x26, 0x97, 0xB5, 0xC1, 0xCF, 0x69, 0xAD, 0x8E, 0x32, 0xE7, 0xD7, 0x5B, 0x41, 0x77, 0xA4, 0xC7, 0x33, 0xE9, 0xFA, 0xBE, 0x9E, 0xF5, 0x5B, 0xEC, 0xF5, 0x86, 0xB8, 0xDB, 0x73, 0x5A, 0xE0, 0x3D, 0xB5, 0xD7, 0xFA, 0x47, 0x13, 0xDB, 0x73,
    0x99, 0xFA, 0x16, 0x37, 0xFE, 0xB8, 0xAB, 0xD4, 0x64, 0x49, 0x96, 0xBA, 0xED, 0xFD, 0xD3, 0xA7, 0xA7, 0xF7, 0x5B, 0xF1, 0xE3, 0x84, 0x23, 0xED, 0xE9, 0x62, 0xCC, 0xBE, 0x5F, 0x9A, 0x3F, 0xA3, 0x23, 0xF2, 0xC9, 0x33, 0x3A, 0xA6, 0x61, 0xF6,
    0xE4, 0x3B, 0xED, 0x75, 0x93, 0x2E, 0xAF, 0x23, 0xDE, 0x0C, 0x8D, 0xBF, 0xCE, 0x7F, 0x3D, 0x5F, 0xB7, 0xFD, 0x1D, 0x8A, 0xD5, 0xCC, 0x2F, 0xA2, 0x96, 0xD7, 0x65, 0xF6, 0x63, 0x10, 0xE7, 0x60, 0x53, 0x5D, 0x6D, 0xB0, 0x87, 0x8F, 0x65, 0xB4,
    0x5F, 0xF4, 0x5F, 0xB5, 0xAF, 0x77, 0xA7, 0xF9, 0xFB, 0xFF, 0x00, 0x9C, 0xF4, 0xFF, 0x00, 0x4A, 0xB2, 0xAB, 0x6B, 0xE3, 0x51, 0xAA, 0xD6, 0xC2, 0x13, 0x80, 0x19, 0xFA, 0x77, 0x3B, 0xD7, 0x73, 0x83, 0x71, 0x27, 0xD6, 0x00, 0x32, 0xB9, 0x77,
    0xFC, 0x5B, 0x9D, 0xFF, 0x00, 0x50, 0x86, 0x48, 0xC6, 0x26, 0x26, 0x20, 0x0D, 0x7A, 0x0F, 0xF9, 0xDF, 0xDE, 0xFE, 0xB2, 0xEC, 0x66, 0x53, 0x84, 0x84, 0xC9, 0x3E, 0x9F, 0xD2, 0xBB, 0xFE, 0xEF, 0xF7, 0x7F, 0xA8, 0xC7, 0xA4, 0x39, 0x95, 0x65,
    0x36, 0x9B, 0x0B, 0x3D, 0x2F, 0x5A, 0x8B, 0x29, 0x65, 0xD7, 0xD9, 0x4B, 0x58, 0x5F, 0x6D, 0x75, 0xE4, 0x7F, 0x37, 0xF9, 0xDE, 0x96, 0xFC, 0x5C, 0xAB, 0x3D, 0x3F, 0xD1, 0xD3, 0xFA, 0x45, 0x57, 0x22, 0xB2, 0xCD, 0x5F, 0x92, 0xDB, 0xF1, 0xE6,
    0xCC, 0x87, 0x63, 0xD6, 0xF7, 0x3D, 0xAD, 0x78, 0xB1, 0xD8, 0xCC, 0x6D, 0x93, 0xFA, 0x3D, 0xF7, 0xFA, 0x75, 0xBF, 0x7F, 0xD3, 0xFB, 0x2A, 0x2E, 0x36, 0x55, 0x98, 0xF9, 0x95, 0x8A, 0x32, 0x5D, 0x8B, 0x5B, 0xDD, 0xBB, 0xD5, 0xB9, 0xAD, 0x73,
    0x80, 0xAF, 0x21, 0xD6, 0xD0, 0xEB, 0x9A, 0xED, 0xCD, 0xDF, 0x5D, 0x8C, 0xF5, 0x6C, 0x55, 0x5E, 0x1B, 0x61, 0xBC, 0xBA, 0xDD, 0xE2, 0xCB, 0x2B, 0x7D, 0xD6, 0x81, 0x3A, 0x38, 0xD9, 0xEA, 0x3F, 0x6B, 0x7F, 0x96, 0xE4, 0xE8, 0x89, 0x7B, 0x92,
    0x24, 0xFA, 0x74, 0x9F, 0x0F, 0xAA, 0x5F, 0xA3, 0xC3, 0xF2, 0xFC, 0x90, 0xFF, 0x00, 0x01, 0xA8, 0x71, 0x0F, 0x6C, 0x48, 0x08, 0xEF, 0xC3, 0x7E, 0x9B, 0xBF, 0xFA, 0x4C, 0xF1, 0xDA, 0xE3, 0x55, 0x8E, 0xCA, 0x6C, 0x81, 0x64, 0x96, 0xB8, 0x43,
    0x8D, 0x80, 0x6D, 0x87, 0x7E, 0xEB, 0x5B, 0xEE, 0xF6, 0x2B, 0xF5, 0xD9, 0x95, 0x53, 0x4B, 0x29, 0xCA, 0x6D, 0x4D, 0x90, 0x76, 0xD7, 0x66, 0xC1, 0x27, 0xBF, 0xB7, 0x6A, 0x26, 0x37, 0xA9, 0x85, 0x7B, 0x65, 0xCC, 0x7F, 0xA3, 0x65, 0x95, 0xDC,
    0x72, 0x00, 0x1B, 0x83, 0x88, 0xF5, 0x77, 0x54, 0xF3, 0xEA, 0xEE, 0x7B, 0x5D, 0xFD, 0x75, 0x53, 0xA9, 0x53, 0x47, 0xA8, 0x47, 0x4F, 0xB1, 0xCE, 0x66, 0xF3, 0xB0, 0x11, 0xB0, 0x06, 0x7E, 0x64, 0xB9, 0xE7, 0x7D, 0x8F, 0xFE, 0xCA, 0x88, 0xCB,
    0x8E, 0x74, 0x47, 0xA4, 0xEB, 0xC5, 0x5C, 0x50, 0xFF, 0x00, 0xD0, 0x5D, 0x5C, 0x70, 0xF6, 0x70, 0x83, 0x18, 0x99, 0x4A, 0x87, 0x10, 0x8F, 0xF3, 0x92, 0xBF, 0xFA, 0x7C, 0x2D, 0x97, 0xB2, 0xBC, 0xE3, 0xE8, 0x65, 0xBA, 0xB7, 0x5E, 0xFD, 0x29,
    0xC9, 0x04, 0x48, 0x7C, 0x43, 0x1B, 0x91, 0x65, 0x63, 0xF4, 0x95, 0x3F, 0xE8, 0xFA, 0x8E, 0xFD, 0x25, 0x3F, 0xF1, 0x5B, 0xEB, 0x59, 0x16, 0xB3, 0x21, 0xF7, 0xDC, 0x6F, 0x61, 0x06, 0xEB, 0x1C, 0x1C, 0xED, 0xBB, 0x5B, 0xEA, 0xFD, 0x3D, 0xA3,
    0xF3, 0x5A, 0xE6, 0xEE, 0xF7, 0x33, 0xF9, 0x6B, 0x41, 0xAE, 0xFD, 0x5C, 0xD5, 0x26, 0x4B, 0x83, 0xB9, 0x1B, 0x78, 0x8F, 0xEB, 0x6E, 0x50, 0xEB, 0x2E, 0x75, 0x9D, 0x4D, 0xCF, 0xA5, 0xFE, 0xA6, 0x35, 0x97, 0x0D, 0x8E, 0x6B, 0xA5, 0x8E, 0xB0,
    0x06, 0x3A, 0xC7, 0xB6, 0x0F, 0xEE, 0xD9, 0x5A, 0x76, 0x1B, 0x8C, 0xF8, 0x7F, 0x44, 0x83, 0x5D, 0xA3, 0xC3, 0x5F, 0x2F, 0xF7, 0xFF, 0x00, 0x77, 0xFA, 0x8C, 0x3F, 0x10, 0xC7, 0x1F, 0x6C, 0x64, 0xDA, 0x56, 0x01, 0xEF, 0x2B, 0xFD, 0xEF, 0xEE,
    0x7E, 0xF7, 0xF5, 0xDC, 0x80, 0x75, 0x05, 0x5E, 0xE9, 0x6D, 0x2F, 0xEA, 0xB8, 0x40, 0x7F, 0xA7, 0x61, 0xFB, 0x9C, 0x1C, 0xA9, 0x18, 0x24, 0x91, 0xC1, 0x26, 0x3E, 0xF5, 0xA9, 0xF5, 0x75, 0x9B, 0xFA, 0xB5, 0x4E, 0xED, 0x53, 0x1E, 0xFF, 0x00,
    0xFA, 0x3B, 0x1B, 0xFF, 0x00, 0x49, 0xEA, 0xD3, 0x97, 0x7A, 0x17, 0xFF, 0xD1, 0xF3, 0xEE, 0xBF, 0x99, 0x46, 0x77, 0x54, 0xB7, 0x2A, 0x86, 0xBD, 0xAC, 0xB1, 0xAC, 0x90, 0xF0, 0x01, 0x96, 0xB5, 0xB5, 0x9F, 0xA2, 0xE7, 0x7E, 0xE2, 0x86, 0x37,
    0x4B, 0xCA, 0xB7, 0x26, 0x8A, 0xAB, 0xB2, 0x96, 0x59, 0x73, 0x45, 0xB5, 0xB9, 0xD6, 0x34, 0x34, 0x0F, 0xA6, 0x3D, 0x47, 0xFD, 0x16, 0x3B, 0xF7, 0xBF, 0x73, 0xF3, 0xD4, 0x69, 0xC6, 0xAB, 0x23, 0x25, 0x95, 0xD9, 0x68, 0xA0, 0x3F, 0x4F, 0x55,
    0xFA, 0x31, 0xA4, 0x02, 0x5A, 0x6C, 0x3F, 0xBB, 0xB9, 0x10, 0x74, 0xCC, 0x60, 0xE0, 0x2C, 0xEA, 0x38, 0xC1, 0xA4, 0xFB, 0x8B, 0x37, 0x3E, 0x07, 0xEF, 0x7D, 0x16, 0x6E, 0x42, 0x42, 0x47, 0xE5, 0x20, 0x6F, 0xD3, 0x89, 0x5D, 0x47, 0x6E, 0xA1,
    0x03, 0xCB, 0x77, 0x30, 0xB9, 0xCE, 0xFB, 0x25, 0xAE, 0xDF, 0xB4, 0x1D, 0x01, 0xFA, 0x36, 0xB4, 0x34, 0xFB, 0x3D, 0x5A, 0xFF, 0x00, 0xEA, 0x3D, 0x35, 0x70, 0x1E, 0x80, 0xD6, 0x37, 0x78, 0xC8, 0x71, 0x70, 0x2E, 0x1B, 0x5F, 0x50, 0x81, 0xB9,
    0xCD, 0x6B, 0x5E, 0xDD, 0x8E, 0xD8, 0xFD, 0x81, 0x46, 0xAC, 0x3C, 0x76, 0x0D, 0x7A, 0x9D, 0x0C, 0xDD, 0xF4, 0x9A, 0x1A, 0xE7, 0x0D, 0x38, 0x3F, 0x47, 0x6A, 0x9F, 0xD9, 0xF1, 0xA1, 0xBF, 0xE5, 0x5A, 0xC1, 0x20, 0xEF, 0x06, 0xB3, 0xA6, 0xBE,
    0xDF, 0xA3, 0x3B, 0xB7, 0x21, 0x2C, 0x7C, 0x55, 0xA9, 0x8F, 0xF7, 0x4F, 0x0B, 0x2E, 0x3C, 0xDC, 0x17, 0xE9, 0x8C, 0xAF, 0xF7, 0xC5, 0xB1, 0xB9, 0x9D, 0x20, 0x5F, 0xE9, 0xD2, 0xF7, 0x06, 0x10, 0x21, 0xCF, 0x2C, 0x78, 0x9D, 0x77, 0x6E, 0xB1,
    0x82, 0xBF, 0xFA, 0x84, 0x16, 0xFF, 0x00, 0x48, 0x2C, 0xC4, 0xB3, 0x61, 0x04, 0x8F, 0x59, 0x87, 0x6E, 0xD6, 0x03, 0xEE, 0xB1, 0xCE, 0x64, 0x7B, 0x76, 0xFB, 0x95, 0x81, 0x8F, 0x89, 0x3A, 0xF5, 0x76, 0x44, 0x1D, 0x45, 0x4E, 0xE7, 0xF3, 0x42,
    0x76, 0xE2, 0xE0, 0xD8, 0xDD, 0x8F, 0xEA, 0xCD, 0x25, 0xD1, 0x2D, 0x0C, 0x20, 0x12, 0x35, 0xDA, 0xE7, 0x3B, 0x6B, 0x10, 0x8E, 0x3A, 0xDE, 0x46, 0x5A, 0x75, 0x5D, 0x3E, 0x67, 0x88, 0x10, 0x21, 0x18, 0x6B, 0xBC, 0x77, 0x76, 0xBE, 0xAC, 0x1E,
    0x8A, 0xF1, 0x7E, 0x5E, 0x75, 0xB8, 0xA0, 0x98, 0xAE, 0x8A, 0x32, 0xB5, 0x70, 0xAE, 0xB1, 0xB6, 0xBF, 0x6B, 0x7E, 0x8D, 0xB6, 0x3B, 0xDF, 0x62, 0x87, 0xD6, 0xAB, 0x3A, 0x1E, 0xEA, 0xEC, 0xC2, 0xB7, 0x1C, 0x87, 0xEF, 0xAA, 0xEA, 0xF1, 0x5A,
    0x5A, 0x05, 0x6F, 0xE1, 0xC0, 0x1F, 0x7B, 0xBD, 0x0B, 0x6A, 0xF5, 0xBF, 0xE1, 0x3D, 0x5F, 0x4D, 0x63, 0xBB, 0xA4, 0x61, 0x16, 0x83, 0x47, 0x53, 0xA0, 0xB8, 0x81, 0xA5, 0x91, 0x58, 0xDD, 0xF9, 0xFE, 0xE0, 0xFB, 0x3D, 0xBF, 0xBA, 0xA6, 0xCE,
    0x8B, 0xD3, 0xFD, 0x29, 0xB3, 0xAB, 0xE3, 0xB6, 0xDE, 0x0B, 0x1B, 0x05, 0xB3, 0x3F, 0xE9, 0x37, 0x7B, 0x9B, 0xB7, 0xF9, 0x0A, 0xBF, 0xDC, 0xBF, 0xA4, 0x7B, 0xFE, 0xEC, 0xFF, 0x00, 0xB9, 0xFA, 0x15, 0x5C, 0x3C, 0x28, 0xF7, 0xFF, 0x00, 0x57,
    0xC1, 0xC3, 0xF5, 0xFF, 0x00, 0x9D, 0x6D, 0x6A, 0x1D, 0x8B, 0x5D, 0x8F, 0x66, 0x70, 0xDC, 0xF6, 0x8D, 0x1C, 0xD2, 0xDF, 0x74, 0xC1, 0x6D, 0x9E, 0xA5, 0x81, 0xDB, 0xD8, 0xE6, 0x2B, 0x06, 0xEE, 0x8B, 0xED, 0xDA, 0xD7, 0x0F, 0xDE, 0x24, 0xD6,
    0x74, 0x8F, 0xCD, 0xF6, 0xFE, 0xF2, 0x81, 0xA7, 0xA7, 0x56, 0xDF, 0x4D, 0x9D, 0x55, 0xE3, 0x6E, 0x80, 0x0A, 0xC9, 0x6F, 0xF6, 0x76, 0xBD, 0x27, 0x0E, 0x9F, 0xBD, 0xDB, 0x7A, 0xB5, 0xBB, 0x27, 0xD9, 0x35, 0x12, 0x63, 0xF9, 0x51, 0x67, 0xD2,
    0x53, 0xCB, 0x08, 0x26, 0xF8, 0x88, 0xF2, 0x3A, 0x33, 0x62, 0xE7, 0xA5, 0x08, 0x88, 0xF0, 0x42, 0x55, 0xD4, 0x8F, 0x53, 0x27, 0xDD, 0xD2, 0x7D, 0x3F, 0x68, 0xF7, 0x81, 0xCF, 0xB0, 0x89, 0xFE, 0xAC, 0x6E, 0x54, 0x4B, 0xE2, 0x6F, 0x03, 0x6B,
    0x75, 0x6D, 0x20, 0x78, 0x91, 0x0E, 0x7F, 0xF6, 0x3F, 0xF3, 0xE7, 0xA6, 0xAE, 0x47, 0x4C, 0xDB, 0xAF, 0x53, 0xB8, 0xBB, 0x77, 0x22, 0xB2, 0x06, 0xD8, 0xFE, 0xB1, 0xF7, 0xEE, 0x43, 0x34, 0xF4, 0x87, 0x58, 0xD7, 0x5B, 0xD4, 0x6D, 0x7B, 0x66,
    0x1D, 0xFA, 0x13, 0xBB, 0x6F, 0xF2, 0x77, 0x3D, 0x3A, 0x18, 0xC4, 0x7A, 0x93, 0xE6, 0x58, 0xF9, 0x8E, 0x6A, 0x59, 0x80, 0x06, 0x31, 0x80, 0x1F, 0xB8, 0x37, 0x73, 0xD6, 0x8F, 0x43, 0xCE, 0xC7, 0xC2, 0xC9, 0xB6, 0xCB, 0xC3, 0xA1, 0xEC, 0xD8,
    0x0B, 0x44, 0xC4, 0xB8, 0x38, 0xEE, 0x12, 0x3F, 0x75, 0x0D, 0xB8, 0xDD, 0x28, 0xB8, 0x6E, 0xCF, 0x70, 0x13, 0xAC, 0x50, 0x78, 0xFF, 0x00, 0x3D, 0x56, 0x2D, 0x68, 0x71, 0xD9, 0x3B, 0x49, 0xD2, 0x79, 0x8E, 0xC9, 0xED, 0x77, 0xFF, 0xD9, 0xFF,
    0xE2, 0x0C, 0x58, 0x49, 0x43, 0x43, 0x5F, 0x50, 0x52, 0x4F, 0x46, 0x49, 0x4C, 0x45, 0x00, 0x01, 0x01, 0x00, 0x00, 0x0C, 0x48, 0x4C, 0x69, 0x6E, 0x6F, 0x02, 0x10, 0x00, 0x00, 0x6D, 0x6E, 0x74, 0x72, 0x52, 0x47, 0x42, 0x20, 0x58, 0x59, 0x5A,
    0x20, 0x07, 0xCE, 0x00, 0x02, 0x00, 0x09, 0x00, 0x06, 0x00, 0x31, 0x00, 0x00, 0x61, 0x63, 0x73, 0x70, 0x4D, 0x53, 0x46, 0x54, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x43, 0x20, 0x73, 0x52, 0x47, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF6, 0xD6, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0xD3, 0x2D, 0x48, 0x50, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x63, 0x70, 0x72, 0x74, 0x00, 0x00, 0x01, 0x50, 0x00, 0x00, 0x00,
    0x33, 0x64, 0x65, 0x73, 0x63, 0x00, 0x00, 0x01, 0x84, 0x00, 0x00, 0x00, 0x6C, 0x77, 0x74, 0x70, 0x74, 0x00, 0x00, 0x01, 0xF0, 0x00, 0x00, 0x00, 0x14, 0x62, 0x6B, 0x70, 0x74, 0x00, 0x00, 0x02, 0x04, 0x00, 0x00, 0x00, 0x14, 0x72, 0x58, 0x59,
    0x5A, 0x00, 0x00, 0x02, 0x18, 0x00, 0x00, 0x00, 0x14, 0x67, 0x58, 0x59, 0x5A, 0x00, 0x00, 0x02, 0x2C, 0x00, 0x00, 0x00, 0x14, 0x62, 0x58, 0x59, 0x5A, 0x00, 0x00, 0x02, 0x40, 0x00, 0x00, 0x00, 0x14, 0x64, 0x6D, 0x6E, 0x64, 0x00, 0x00, 0x02,
    0x54, 0x00, 0x00, 0x00, 0x70, 0x64, 0x6D, 0x64, 0x64, 0x00, 0x00, 0x02, 0xC4, 0x00, 0x00, 0x00, 0x88, 0x76, 0x75, 0x65, 0x64, 0x00, 0x00, 0x03, 0x4C, 0x00, 0x00, 0x00, 0x86, 0x76, 0x69, 0x65, 0x77, 0x00, 0x00, 0x03, 0xD4, 0x00, 0x00, 0x00,
    0x24, 0x6C, 0x75, 0x6D, 0x69, 0x00, 0x00, 0x03, 0xF8, 0x00, 0x00, 0x00, 0x14, 0x6D, 0x65, 0x61, 0x73, 0x00, 0x00, 0x04, 0x0C, 0x00, 0x00, 0x00, 0x24, 0x74, 0x65, 0x63, 0x68, 0x00, 0x00, 0x04, 0x30, 0x00, 0x00, 0x00, 0x0C, 0x72, 0x54, 0x52,
    0x43, 0x00, 0x00, 0x04, 0x3C, 0x00, 0x00, 0x08, 0x0C, 0x67, 0x54, 0x52, 0x43, 0x00, 0x00, 0x04, 0x3C, 0x00, 0x00, 0x08, 0x0C, 0x62, 0x54, 0x52, 0x43, 0x00, 0x00, 0x04, 0x3C, 0x00, 0x00, 0x08, 0x0C, 0x74, 0x65, 0x78, 0x74, 0x00, 0x00, 0x00,
    0x00, 0x43, 0x6F, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 0x74, 0x20, 0x28, 0x63, 0x29, 0x20, 0x31, 0x39, 0x39, 0x38, 0x20, 0x48, 0x65, 0x77, 0x6C, 0x65, 0x74, 0x74, 0x2D, 0x50, 0x61, 0x63, 0x6B, 0x61, 0x72, 0x64, 0x20, 0x43, 0x6F, 0x6D, 0x70,
    0x61, 0x6E, 0x79, 0x00, 0x00, 0x64, 0x65, 0x73, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x73, 0x52, 0x47, 0x42, 0x20, 0x49, 0x45, 0x43, 0x36, 0x31, 0x39, 0x36, 0x36, 0x2D, 0x32, 0x2E, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x73, 0x52, 0x47, 0x42, 0x20, 0x49, 0x45, 0x43, 0x36, 0x31, 0x39, 0x36, 0x36, 0x2D, 0x32, 0x2E, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0x59, 0x5A, 0x20, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xF3, 0x51, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x16, 0xCC, 0x58, 0x59, 0x5A, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0x59, 0x5A, 0x20, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x6F, 0xA2, 0x00, 0x00, 0x38, 0xF5, 0x00, 0x00, 0x03, 0x90, 0x58, 0x59, 0x5A, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0x99, 0x00, 0x00, 0xB7, 0x85, 0x00, 0x00, 0x18, 0xDA, 0x58, 0x59, 0x5A, 0x20, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x24, 0xA0, 0x00, 0x00, 0x0F, 0x84, 0x00, 0x00, 0xB6, 0xCF, 0x64, 0x65, 0x73, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x49, 0x45, 0x43, 0x20, 0x68, 0x74, 0x74, 0x70, 0x3A, 0x2F, 0x2F, 0x77, 0x77, 0x77, 0x2E,
    0x69, 0x65, 0x63, 0x2E, 0x63, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x49, 0x45, 0x43, 0x20, 0x68, 0x74, 0x74, 0x70, 0x3A, 0x2F, 0x2F, 0x77, 0x77, 0x77, 0x2E, 0x69, 0x65, 0x63, 0x2E, 0x63, 0x68, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x65, 0x73, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2E, 0x49, 0x45, 0x43, 0x20, 0x36, 0x31, 0x39, 0x36, 0x36, 0x2D, 0x32, 0x2E, 0x31, 0x20, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6C, 0x74, 0x20, 0x52,
    0x47, 0x42, 0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x75, 0x72, 0x20, 0x73, 0x70, 0x61, 0x63, 0x65, 0x20, 0x2D, 0x20, 0x73, 0x52, 0x47, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2E, 0x49, 0x45, 0x43, 0x20, 0x36, 0x31,
    0x39, 0x36, 0x36, 0x2D, 0x32, 0x2E, 0x31, 0x20, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6C, 0x74, 0x20, 0x52, 0x47, 0x42, 0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x75, 0x72, 0x20, 0x73, 0x70, 0x61, 0x63, 0x65, 0x20, 0x2D, 0x20, 0x73, 0x52, 0x47, 0x42, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x65, 0x73, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2C, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6E,
    0x63, 0x65, 0x20, 0x56, 0x69, 0x65, 0x77, 0x69, 0x6E, 0x67, 0x20, 0x43, 0x6F, 0x6E, 0x64, 0x69, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x69, 0x6E, 0x20, 0x49, 0x45, 0x43, 0x36, 0x31, 0x39, 0x36, 0x36, 0x2D, 0x32, 0x2E, 0x31, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2C, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6E, 0x63, 0x65, 0x20, 0x56, 0x69, 0x65, 0x77, 0x69, 0x6E, 0x67, 0x20, 0x43, 0x6F, 0x6E, 0x64, 0x69, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x69, 0x6E, 0x20, 0x49,
    0x45, 0x43, 0x36, 0x31, 0x39, 0x36, 0x36, 0x2D, 0x32, 0x2E, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0x69, 0x65,
    0x77, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0xA4, 0xFE, 0x00, 0x14, 0x5F, 0x2E, 0x00, 0x10, 0xCF, 0x14, 0x00, 0x03, 0xED, 0xCC, 0x00, 0x04, 0x13, 0x0B, 0x00, 0x03, 0x5C, 0x9E, 0x00, 0x00, 0x00, 0x01, 0x58, 0x59, 0x5A, 0x20, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x4C, 0x09, 0x56, 0x00, 0x50, 0x00, 0x00, 0x00, 0x57, 0x1F, 0xE7, 0x6D, 0x65, 0x61, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x02, 0x8F, 0x00, 0x00, 0x00, 0x02, 0x73, 0x69, 0x67, 0x20, 0x00, 0x00, 0x00, 0x00, 0x43, 0x52, 0x54, 0x20, 0x63, 0x75, 0x72, 0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x0A, 0x00,
    0x0F, 0x00, 0x14, 0x00, 0x19, 0x00, 0x1E, 0x00, 0x23, 0x00, 0x28, 0x00, 0x2D, 0x00, 0x32, 0x00, 0x37, 0x00, 0x3B, 0x00, 0x40, 0x00, 0x45, 0x00, 0x4A, 0x00, 0x4F, 0x00, 0x54, 0x00, 0x59, 0x00, 0x5E, 0x00, 0x63, 0x00, 0x68, 0x00, 0x6D, 0x00,
    0x72, 0x00, 0x77, 0x00, 0x7C, 0x00, 0x81, 0x00, 0x86, 0x00, 0x8B, 0x00, 0x90, 0x00, 0x95, 0x00, 0x9A, 0x00, 0x9F, 0x00, 0xA4, 0x00, 0xA9, 0x00, 0xAE, 0x00, 0xB2, 0x00, 0xB7, 0x00, 0xBC, 0x00, 0xC1, 0x00, 0xC6, 0x00, 0xCB, 0x00, 0xD0, 0x00,
    0xD5, 0x00, 0xDB, 0x00, 0xE0, 0x00, 0xE5, 0x00, 0xEB, 0x00, 0xF0, 0x00, 0xF6, 0x00, 0xFB, 0x01, 0x01, 0x01, 0x07, 0x01, 0x0D, 0x01, 0x13, 0x01, 0x19, 0x01, 0x1F, 0x01, 0x25, 0x01, 0x2B, 0x01, 0x32, 0x01, 0x38, 0x01, 0x3E, 0x01, 0x45, 0x01,
    0x4C, 0x01, 0x52, 0x01, 0x59, 0x01, 0x60, 0x01, 0x67, 0x01, 0x6E, 0x01, 0x75, 0x01, 0x7C, 0x01, 0x83, 0x01, 0x8B, 0x01, 0x92, 0x01, 0x9A, 0x01, 0xA1, 0x01, 0xA9, 0x01, 0xB1, 0x01, 0xB9, 0x01, 0xC1, 0x01, 0xC9, 0x01, 0xD1, 0x01, 0xD9, 0x01,
    0xE1, 0x01, 0xE9, 0x01, 0xF2, 0x01, 0xFA, 0x02, 0x03, 0x02, 0x0C, 0x02, 0x14, 0x02, 0x1D, 0x02, 0x26, 0x02, 0x2F, 0x02, 0x38, 0x02, 0x41, 0x02, 0x4B, 0x02, 0x54, 0x02, 0x5D, 0x02, 0x67, 0x02, 0x71, 0x02, 0x7A, 0x02, 0x84, 0x02, 0x8E, 0x02,
    0x98, 0x02, 0xA2, 0x02, 0xAC, 0x02, 0xB6, 0x02, 0xC1, 0x02, 0xCB, 0x02, 0xD5, 0x02, 0xE0, 0x02, 0xEB, 0x02, 0xF5, 0x03, 0x00, 0x03, 0x0B, 0x03, 0x16, 0x03, 0x21, 0x03, 0x2D, 0x03, 0x38, 0x03, 0x43, 0x03, 0x4F, 0x03, 0x5A, 0x03, 0x66, 0x03,
    0x72, 0x03, 0x7E, 0x03, 0x8A, 0x03, 0x96, 0x03, 0xA2, 0x03, 0xAE, 0x03, 0xBA, 0x03, 0xC7, 0x03, 0xD3, 0x03, 0xE0, 0x03, 0xEC, 0x03, 0xF9, 0x04, 0x06, 0x04, 0x13, 0x04, 0x20, 0x04, 0x2D, 0x04, 0x3B, 0x04, 0x48, 0x04, 0x55, 0x04, 0x63, 0x04,
    0x71, 0x04, 0x7E, 0x04, 0x8C, 0x04, 0x9A, 0x04, 0xA8, 0x04, 0xB6, 0x04, 0xC4, 0x04, 0xD3, 0x04, 0xE1, 0x04, 0xF0, 0x04, 0xFE, 0x05, 0x0D, 0x05, 0x1C, 0x05, 0x2B, 0x05, 0x3A, 0x05, 0x49, 0x05, 0x58, 0x05, 0x67, 0x05, 0x77, 0x05, 0x86, 0x05,
    0x96, 0x05, 0xA6, 0x05, 0xB5, 0x05, 0xC5, 0x05, 0xD5, 0x05, 0xE5, 0x05, 0xF6, 0x06, 0x06, 0x06, 0x16, 0x06, 0x27, 0x06, 0x37, 0x06, 0x48, 0x06, 0x59, 0x06, 0x6A, 0x06, 0x7B, 0x06, 0x8C, 0x06, 0x9D, 0x06, 0xAF, 0x06, 0xC0, 0x06, 0xD1, 0x06,
    0xE3, 0x06, 0xF5, 0x07, 0x07, 0x07, 0x19, 0x07, 0x2B, 0x07, 0x3D, 0x07, 0x4F, 0x07, 0x61, 0x07, 0x74, 0x07, 0x86, 0x07, 0x99, 0x07, 0xAC, 0x07, 0xBF, 0x07, 0xD2, 0x07, 0xE5, 0x07, 0xF8, 0x08, 0x0B, 0x08, 0x1F, 0x08, 0x32, 0x08, 0x46, 0x08,
    0x5A, 0x08, 0x6E, 0x08, 0x82, 0x08, 0x96, 0x08, 0xAA, 0x08, 0xBE, 0x08, 0xD2, 0x08, 0xE7, 0x08, 0xFB, 0x09, 0x10, 0x09, 0x25, 0x09, 0x3A, 0x09, 0x4F, 0x09, 0x64, 0x09, 0x79, 0x09, 0x8F, 0x09, 0xA4, 0x09, 0xBA, 0x09, 0xCF, 0x09, 0xE5, 0x09,
    0xFB, 0x0A, 0x11, 0x0A, 0x27, 0x0A, 0x3D, 0x0A, 0x54, 0x0A, 0x6A, 0x0A, 0x81, 0x0A, 0x98, 0x0A, 0xAE, 0x0A, 0xC5, 0x0A, 0xDC, 0x0A, 0xF3, 0x0B, 0x0B, 0x0B, 0x22, 0x0B, 0x39, 0x0B, 0x51, 0x0B, 0x69, 0x0B, 0x80, 0x0B, 0x98, 0x0B, 0xB0, 0x0B,
    0xC8, 0x0B, 0xE1, 0x0B, 0xF9, 0x0C, 0x12, 0x0C, 0x2A, 0x0C, 0x43, 0x0C, 0x5C, 0x0C, 0x75, 0x0C, 0x8E, 0x0C, 0xA7, 0x0C, 0xC0, 0x0C, 0xD9, 0x0C, 0xF3, 0x0D, 0x0D, 0x0D, 0x26, 0x0D, 0x40, 0x0D, 0x5A, 0x0D, 0x74, 0x0D, 0x8E, 0x0D, 0xA9, 0x0D,
    0xC3, 0x0D, 0xDE, 0x0D, 0xF8, 0x0E, 0x13, 0x0E, 0x2E, 0x0E, 0x49, 0x0E, 0x64, 0x0E, 0x7F, 0x0E, 0x9B, 0x0E, 0xB6, 0x0E, 0xD2, 0x0E, 0xEE, 0x0F, 0x09, 0x0F, 0x25, 0x0F, 0x41, 0x0F, 0x5E, 0x0F, 0x7A, 0x0F, 0x96, 0x0F, 0xB3, 0x0F, 0xCF, 0x0F,
    0xEC, 0x10, 0x09, 0x10, 0x26, 0x10, 0x43, 0x10, 0x61, 0x10, 0x7E, 0x10, 0x9B, 0x10, 0xB9, 0x10, 0xD7, 0x10, 0xF5, 0x11, 0x13, 0x11, 0x31, 0x11, 0x4F, 0x11, 0x6D, 0x11, 0x8C, 0x11, 0xAA, 0x11, 0xC9, 0x11, 0xE8, 0x12, 0x07, 0x12, 0x26, 0x12,
    0x45, 0x12, 0x64, 0x12, 0x84, 0x12, 0xA3, 0x12, 0xC3, 0x12, 0xE3, 0x13, 0x03, 0x13, 0x23, 0x13, 0x43, 0x13, 0x63, 0x13, 0x83, 0x13, 0xA4, 0x13, 0xC5, 0x13, 0xE5, 0x14, 0x06, 0x14, 0x27, 0x14, 0x49, 0x14, 0x6A, 0x14, 0x8B, 0x14, 0xAD, 0x14,
    0xCE, 0x14, 0xF0, 0x15, 0x12, 0x15, 0x34, 0x15, 0x56, 0x15, 0x78, 0x15, 0x9B, 0x15, 0xBD, 0x15, 0xE0, 0x16, 0x03, 0x16, 0x26, 0x16, 0x49, 0x16, 0x6C, 0x16, 0x8F, 0x16, 0xB2, 0x16, 0xD6, 0x16, 0xFA, 0x17, 0x1D, 0x17, 0x41, 0x17, 0x65, 0x17,
    0x89, 0x17, 0xAE, 0x17, 0xD2, 0x17, 0xF7, 0x18, 0x1B, 0x18, 0x40, 0x18, 0x65, 0x18, 0x8A, 0x18, 0xAF, 0x18, 0xD5, 0x18, 0xFA, 0x19, 0x20, 0x19, 0x45, 0x19, 0x6B, 0x19, 0x91, 0x19, 0xB7, 0x19, 0xDD, 0x1A, 0x04, 0x1A, 0x2A, 0x1A, 0x51, 0x1A,
    0x77, 0x1A, 0x9E, 0x1A, 0xC5, 0x1A, 0xEC, 0x1B, 0x14, 0x1B, 0x3B, 0x1B, 0x63, 0x1B, 0x8A, 0x1B, 0xB2, 0x1B, 0xDA, 0x1C, 0x02, 0x1C, 0x2A, 0x1C, 0x52, 0x1C, 0x7B, 0x1C, 0xA3, 0x1C, 0xCC, 0x1C, 0xF5, 0x1D, 0x1E, 0x1D, 0x47, 0x1D, 0x70, 0x1D,
    0x99, 0x1D, 0xC3, 0x1D, 0xEC, 0x1E, 0x16, 0x1E, 0x40, 0x1E, 0x6A, 0x1E, 0x94, 0x1E, 0xBE, 0x1E, 0xE9, 0x1F, 0x13, 0x1F, 0x3E, 0x1F, 0x69, 0x1F, 0x94, 0x1F, 0xBF, 0x1F, 0xEA, 0x20, 0x15, 0x20, 0x41, 0x20, 0x6C, 0x20, 0x98, 0x20, 0xC4, 0x20,
    0xF0, 0x21, 0x1C, 0x21, 0x48, 0x21, 0x75, 0x21, 0xA1, 0x21, 0xCE, 0x21, 0xFB, 0x22, 0x27, 0x22, 0x55, 0x22, 0x82, 0x22, 0xAF, 0x22, 0xDD, 0x23, 0x0A, 0x23, 0x38, 0x23, 0x66, 0x23, 0x94, 0x23, 0xC2, 0x23, 0xF0, 0x24, 0x1F, 0x24, 0x4D, 0x24,
    0x7C, 0x24, 0xAB, 0x24, 0xDA, 0x25, 0x09, 0x25, 0x38, 0x25, 0x68, 0x25, 0x97, 0x25, 0xC7, 0x25, 0xF7, 0x26, 0x27, 0x26, 0x57, 0x26, 0x87, 0x26, 0xB7, 0x26, 0xE8, 0x27, 0x18, 0x27, 0x49, 0x27, 0x7A, 0x27, 0xAB, 0x27, 0xDC, 0x28, 0x0D, 0x28,
    0x3F, 0x28, 0x71, 0x28, 0xA2, 0x28, 0xD4, 0x29, 0x06, 0x29, 0x38, 0x29, 0x6B, 0x29, 0x9D, 0x29, 0xD0, 0x2A, 0x02, 0x2A, 0x35, 0x2A, 0x68, 0x2A, 0x9B, 0x2A, 0xCF, 0x2B, 0x02, 0x2B, 0x36, 0x2B, 0x69, 0x2B, 0x9D, 0x2B, 0xD1, 0x2C, 0x05, 0x2C,
    0x39, 0x2C, 0x6E, 0x2C, 0xA2, 0x2C, 0xD7, 0x2D, 0x0C, 0x2D, 0x41, 0x2D, 0x76, 0x2D, 0xAB, 0x2D, 0xE1, 0x2E, 0x16, 0x2E, 0x4C, 0x2E, 0x82, 0x2E, 0xB7, 0x2E, 0xEE, 0x2F, 0x24, 0x2F, 0x5A, 0x2F, 0x91, 0x2F, 0xC7, 0x2F, 0xFE, 0x30, 0x35, 0x30,
    0x6C, 0x30, 0xA4, 0x30, 0xDB, 0x31, 0x12, 0x31, 0x4A, 0x31, 0x82, 0x31, 0xBA, 0x31, 0xF2, 0x32, 0x2A, 0x32, 0x63, 0x32, 0x9B, 0x32, 0xD4, 0x33, 0x0D, 0x33, 0x46, 0x33, 0x7F, 0x33, 0xB8, 0x33, 0xF1, 0x34, 0x2B, 0x34, 0x65, 0x34, 0x9E, 0x34,
    0xD8, 0x35, 0x13, 0x35, 0x4D, 0x35, 0x87, 0x35, 0xC2, 0x35, 0xFD, 0x36, 0x37, 0x36, 0x72, 0x36, 0xAE, 0x36, 0xE9, 0x37, 0x24, 0x37, 0x60, 0x37, 0x9C, 0x37, 0xD7, 0x38, 0x14, 0x38, 0x50, 0x38, 0x8C, 0x38, 0xC8, 0x39, 0x05, 0x39, 0x42, 0x39,
    0x7F, 0x39, 0xBC, 0x39, 0xF9, 0x3A, 0x36, 0x3A, 0x74, 0x3A, 0xB2, 0x3A, 0xEF, 0x3B, 0x2D, 0x3B, 0x6B, 0x3B, 0xAA, 0x3B, 0xE8, 0x3C, 0x27, 0x3C, 0x65, 0x3C, 0xA4, 0x3C, 0xE3, 0x3D, 0x22, 0x3D, 0x61, 0x3D, 0xA1, 0x3D, 0xE0, 0x3E, 0x20, 0x3E,
    0x60, 0x3E, 0xA0, 0x3E, 0xE0, 0x3F, 0x21, 0x3F, 0x61, 0x3F, 0xA2, 0x3F, 0xE2, 0x40, 0x23, 0x40, 0x64, 0x40, 0xA6, 0x40, 0xE7, 0x41, 0x29, 0x41, 0x6A, 0x41, 0xAC, 0x41, 0xEE, 0x42, 0x30, 0x42, 0x72, 0x42, 0xB5, 0x42, 0xF7, 0x43, 0x3A, 0x43,
    0x7D, 0x43, 0xC0, 0x44, 0x03, 0x44, 0x47, 0x44, 0x8A, 0x44, 0xCE, 0x45, 0x12, 0x45, 0x55, 0x45, 0x9A, 0x45, 0xDE, 0x46, 0x22, 0x46, 0x67, 0x46, 0xAB, 0x46, 0xF0, 0x47, 0x35, 0x47, 0x7B, 0x47, 0xC0, 0x48, 0x05, 0x48, 0x4B, 0x48, 0x91, 0x48,
    0xD7, 0x49, 0x1D, 0x49, 0x63, 0x49, 0xA9, 0x49, 0xF0, 0x4A, 0x37, 0x4A, 0x7D, 0x4A, 0xC4, 0x4B, 0x0C, 0x4B, 0x53, 0x4B, 0x9A, 0x4B, 0xE2, 0x4C, 0x2A, 0x4C, 0x72, 0x4C, 0xBA, 0x4D, 0x02, 0x4D, 0x4A, 0x4D, 0x93, 0x4D, 0xDC, 0x4E, 0x25, 0x4E,
    0x6E, 0x4E, 0xB7, 0x4F, 0x00, 0x4F, 0x49, 0x4F, 0x93, 0x4F, 0xDD, 0x50, 0x27, 0x50, 0x71, 0x50, 0xBB, 0x51, 0x06, 0x51, 0x50, 0x51, 0x9B, 0x51, 0xE6, 0x52, 0x31, 0x52, 0x7C, 0x52, 0xC7, 0x53, 0x13, 0x53, 0x5F, 0x53, 0xAA, 0x53, 0xF6, 0x54,
    0x42, 0x54, 0x8F, 0x54, 0xDB, 0x55, 0x28, 0x55, 0x75, 0x55, 0xC2, 0x56, 0x0F, 0x56, 0x5C, 0x56, 0xA9, 0x56, 0xF7, 0x57, 0x44, 0x57, 0x92, 0x57, 0xE0, 0x58, 0x2F, 0x58, 0x7D, 0x58, 0xCB, 0x59, 0x1A, 0x59, 0x69, 0x59, 0xB8, 0x5A, 0x07, 0x5A,
    0x56, 0x5A, 0xA6, 0x5A, 0xF5, 0x5B, 0x45, 0x5B, 0x95, 0x5B, 0xE5, 0x5C, 0x35, 0x5C, 0x86, 0x5C, 0xD6, 0x5D, 0x27, 0x5D, 0x78, 0x5D, 0xC9, 0x5E, 0x1A, 0x5E, 0x6C, 0x5E, 0xBD, 0x5F, 0x0F, 0x5F, 0x61, 0x5F, 0xB3, 0x60, 0x05, 0x60, 0x57, 0x60,
    0xAA, 0x60, 0xFC, 0x61, 0x4F, 0x61, 0xA2, 0x61, 0xF5, 0x62, 0x49, 0x62, 0x9C, 0x62, 0xF0, 0x63, 0x43, 0x63, 0x97, 0x63, 0xEB, 0x64, 0x40, 0x64, 0x94, 0x64, 0xE9, 0x65, 0x3D, 0x65, 0x92, 0x65, 0xE7, 0x66, 0x3D, 0x66, 0x92, 0x66, 0xE8, 0x67,
    0x3D, 0x67, 0x93, 0x67, 0xE9, 0x68, 0x3F, 0x68, 0x96, 0x68, 0xEC, 0x69, 0x43, 0x69, 0x9A, 0x69, 0xF1, 0x6A, 0x48, 0x6A, 0x9F, 0x6A, 0xF7, 0x6B, 0x4F, 0x6B, 0xA7, 0x6B, 0xFF, 0x6C, 0x57, 0x6C, 0xAF, 0x6D, 0x08, 0x6D, 0x60, 0x6D, 0xB9, 0x6E,
    0x12, 0x6E, 0x6B, 0x6E, 0xC4, 0x6F, 0x1E, 0x6F, 0x78, 0x6F, 0xD1, 0x70, 0x2B, 0x70, 0x86, 0x70, 0xE0, 0x71, 0x3A, 0x71, 0x95, 0x71, 0xF0, 0x72, 0x4B, 0x72, 0xA6, 0x73, 0x01, 0x73, 0x5D, 0x73, 0xB8, 0x74, 0x14, 0x74, 0x70, 0x74, 0xCC, 0x75,
    0x28, 0x75, 0x85, 0x75, 0xE1, 0x76, 0x3E, 0x76, 0x9B, 0x76, 0xF8, 0x77, 0x56, 0x77, 0xB3, 0x78, 0x11, 0x78, 0x6E, 0x78, 0xCC, 0x79, 0x2A, 0x79, 0x89, 0x79, 0xE7, 0x7A, 0x46, 0x7A, 0xA5, 0x7B, 0x04, 0x7B, 0x63, 0x7B, 0xC2, 0x7C, 0x21, 0x7C,
    0x81, 0x7C, 0xE1, 0x7D, 0x41, 0x7D, 0xA1, 0x7E, 0x01, 0x7E, 0x62, 0x7E, 0xC2, 0x7F, 0x23, 0x7F, 0x84, 0x7F, 0xE5, 0x80, 0x47, 0x80, 0xA8, 0x81, 0x0A, 0x81, 0x6B, 0x81, 0xCD, 0x82, 0x30, 0x82, 0x92, 0x82, 0xF4, 0x83, 0x57, 0x83, 0xBA, 0x84,
    0x1D, 0x84, 0x80, 0x84, 0xE3, 0x85, 0x47, 0x85, 0xAB, 0x86, 0x0E, 0x86, 0x72, 0x86, 0xD7, 0x87, 0x3B, 0x87, 0x9F, 0x88, 0x04, 0x88, 0x69, 0x88, 0xCE, 0x89, 0x33, 0x89, 0x99, 0x89, 0xFE, 0x8A, 0x64, 0x8A, 0xCA, 0x8B, 0x30, 0x8B, 0x96, 0x8B,
    0xFC, 0x8C, 0x63, 0x8C, 0xCA, 0x8D, 0x31, 0x8D, 0x98, 0x8D, 0xFF, 0x8E, 0x66, 0x8E, 0xCE, 0x8F, 0x36, 0x8F, 0x9E, 0x90, 0x06, 0x90, 0x6E, 0x90, 0xD6, 0x91, 0x3F, 0x91, 0xA8, 0x92, 0x11, 0x92, 0x7A, 0x92, 0xE3, 0x93, 0x4D, 0x93, 0xB6, 0x94,
    0x20, 0x94, 0x8A, 0x94, 0xF4, 0x95, 0x5F, 0x95, 0xC9, 0x96, 0x34, 0x96, 0x9F, 0x97, 0x0A, 0x97, 0x75, 0x97, 0xE0, 0x98, 0x4C, 0x98, 0xB8, 0x99, 0x24, 0x99, 0x90, 0x99, 0xFC, 0x9A, 0x68, 0x9A, 0xD5, 0x9B, 0x42, 0x9B, 0xAF, 0x9C, 0x1C, 0x9C,
    0x89, 0x9C, 0xF7, 0x9D, 0x64, 0x9D, 0xD2, 0x9E, 0x40, 0x9E, 0xAE, 0x9F, 0x1D, 0x9F, 0x8B, 0x9F, 0xFA, 0xA0, 0x69, 0xA0, 0xD8, 0xA1, 0x47, 0xA1, 0xB6, 0xA2, 0x26, 0xA2, 0x96, 0xA3, 0x06, 0xA3, 0x76, 0xA3, 0xE6, 0xA4, 0x56, 0xA4, 0xC7, 0xA5,
    0x38, 0xA5, 0xA9, 0xA6, 0x1A, 0xA6, 0x8B, 0xA6, 0xFD, 0xA7, 0x6E, 0xA7, 0xE0, 0xA8, 0x52, 0xA8, 0xC4, 0xA9, 0x37, 0xA9, 0xA9, 0xAA, 0x1C, 0xAA, 0x8F, 0xAB, 0x02, 0xAB, 0x75, 0xAB, 0xE9, 0xAC, 0x5C, 0xAC, 0xD0, 0xAD, 0x44, 0xAD, 0xB8, 0xAE,
    0x2D, 0xAE, 0xA1, 0xAF, 0x16, 0xAF, 0x8B, 0xB0, 0x00, 0xB0, 0x75, 0xB0, 0xEA, 0xB1, 0x60, 0xB1, 0xD6, 0xB2, 0x4B, 0xB2, 0xC2, 0xB3, 0x38, 0xB3, 0xAE, 0xB4, 0x25, 0xB4, 0x9C, 0xB5, 0x13, 0xB5, 0x8A, 0xB6, 0x01, 0xB6, 0x79, 0xB6, 0xF0, 0xB7,
    0x68, 0xB7, 0xE0, 0xB8, 0x59, 0xB8, 0xD1, 0xB9, 0x4A, 0xB9, 0xC2, 0xBA, 0x3B, 0xBA, 0xB5, 0xBB, 0x2E, 0xBB, 0xA7, 0xBC, 0x21, 0xBC, 0x9B, 0xBD, 0x15, 0xBD, 0x8F, 0xBE, 0x0A, 0xBE, 0x84, 0xBE, 0xFF, 0xBF, 0x7A, 0xBF, 0xF5, 0xC0, 0x70, 0xC0,
    0xEC, 0xC1, 0x67, 0xC1, 0xE3, 0xC2, 0x5F, 0xC2, 0xDB, 0xC3, 0x58, 0xC3, 0xD4, 0xC4, 0x51, 0xC4, 0xCE, 0xC5, 0x4B, 0xC5, 0xC8, 0xC6, 0x46, 0xC6, 0xC3, 0xC7, 0x41, 0xC7, 0xBF, 0xC8, 0x3D, 0xC8, 0xBC, 0xC9, 0x3A, 0xC9, 0xB9, 0xCA, 0x38, 0xCA,
    0xB7, 0xCB, 0x36, 0xCB, 0xB6, 0xCC, 0x35, 0xCC, 0xB5, 0xCD, 0x35, 0xCD, 0xB5, 0xCE, 0x36, 0xCE, 0xB6, 0xCF, 0x37, 0xCF, 0xB8, 0xD0, 0x39, 0xD0, 0xBA, 0xD1, 0x3C, 0xD1, 0xBE, 0xD2, 0x3F, 0xD2, 0xC1, 0xD3, 0x44, 0xD3, 0xC6, 0xD4, 0x49, 0xD4,
    0xCB, 0xD5, 0x4E, 0xD5, 0xD1, 0xD6, 0x55, 0xD6, 0xD8, 0xD7, 0x5C, 0xD7, 0xE0, 0xD8, 0x64, 0xD8, 0xE8, 0xD9, 0x6C, 0xD9, 0xF1, 0xDA, 0x76, 0xDA, 0xFB, 0xDB, 0x80, 0xDC, 0x05, 0xDC, 0x8A, 0xDD, 0x10, 0xDD, 0x96, 0xDE, 0x1C, 0xDE, 0xA2, 0xDF,
    0x29, 0xDF, 0xAF, 0xE0, 0x36, 0xE0, 0xBD, 0xE1, 0x44, 0xE1, 0xCC, 0xE2, 0x53, 0xE2, 0xDB, 0xE3, 0x63, 0xE3, 0xEB, 0xE4, 0x73, 0xE4, 0xFC, 0xE5, 0x84, 0xE6, 0x0D, 0xE6, 0x96, 0xE7, 0x1F, 0xE7, 0xA9, 0xE8, 0x32, 0xE8, 0xBC, 0xE9, 0x46, 0xE9,
    0xD0, 0xEA, 0x5B, 0xEA, 0xE5, 0xEB, 0x70, 0xEB, 0xFB, 0xEC, 0x86, 0xED, 0x11, 0xED, 0x9C, 0xEE, 0x28, 0xEE, 0xB4, 0xEF, 0x40, 0xEF, 0xCC, 0xF0, 0x58, 0xF0, 0xE5, 0xF1, 0x72, 0xF1, 0xFF, 0xF2, 0x8C, 0xF3, 0x19, 0xF3, 0xA7, 0xF4, 0x34, 0xF4,
    0xC2, 0xF5, 0x50, 0xF5, 0xDE, 0xF6, 0x6D, 0xF6, 0xFB, 0xF7, 0x8A, 0xF8, 0x19, 0xF8, 0xA8, 0xF9, 0x38, 0xF9, 0xC7, 0xFA, 0x57, 0xFA, 0xE7, 0xFB, 0x77, 0xFC, 0x07, 0xFC, 0x98, 0xFD, 0x29, 0xFD, 0xBA, 0xFE, 0x4B, 0xFE, 0xDC, 0xFF, 0x6D, 0xFF,
    0xFF, 0xFF, 0xDB, 0x00, 0x43, 0x00, 0x08, 0x06, 0x06, 0x07, 0x06, 0x05, 0x08, 0x07, 0x07, 0x07, 0x09, 0x09, 0x08, 0x0A, 0x0C, 0x14, 0x0D, 0x0C, 0x0B, 0x0B, 0x0C, 0x19, 0x12, 0x13, 0x0F, 0x14, 0x1D, 0x1A, 0x1F, 0x1E, 0x1D, 0x1A, 0x1C, 0x1C,
    0x20, 0x24, 0x2E, 0x27, 0x20, 0x22, 0x2C, 0x23, 0x1C, 0x1C, 0x28, 0x37, 0x29, 0x2C, 0x30, 0x31, 0x34, 0x34, 0x34, 0x1F, 0x27, 0x39, 0x3D, 0x38, 0x32, 0x3C, 0x2E, 0x33, 0x34, 0x32, 0xFF, 0xDB, 0x00, 0x43, 0x01, 0x09, 0x09, 0x09, 0x0C, 0x0B,
    0x0C, 0x18, 0x0D, 0x0D, 0x18, 0x32, 0x21, 0x1C, 0x21, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32,
    0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0xFF, 0xC0, 0x00, 0x11, 0x08, 0x00, 0x46, 0x00, 0x46, 0x03, 0x01, 0x22, 0x00, 0x02, 0x11, 0x01, 0x03, 0x11, 0x01, 0xFF, 0xC4,
    0x00, 0x1F, 0x00, 0x00, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0xFF, 0xC4, 0x00, 0xB5, 0x10, 0x00, 0x02, 0x01, 0x03,
    0x03, 0x02, 0x04, 0x03, 0x05, 0x05, 0x04, 0x04, 0x00, 0x00, 0x01, 0x7D, 0x01, 0x02, 0x03, 0x00, 0x04, 0x11, 0x05, 0x12, 0x21, 0x31, 0x41, 0x06, 0x13, 0x51, 0x61, 0x07, 0x22, 0x71, 0x14, 0x32, 0x81, 0x91, 0xA1, 0x08, 0x23, 0x42, 0xB1, 0xC1,
    0x15, 0x52, 0xD1, 0xF0, 0x24, 0x33, 0x62, 0x72, 0x82, 0x09, 0x0A, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3A, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x53, 0x54, 0x55,
    0x56, 0x57, 0x58, 0x59, 0x5A, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6A, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7A, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8A, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9A, 0xA2, 0xA3,
    0xA4, 0xA5, 0xA6, 0xA7, 0xA8, 0xA9, 0xAA, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8, 0xB9, 0xBA, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7, 0xC8, 0xC9, 0xCA, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7, 0xD8, 0xD9, 0xDA, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6,
    0xE7, 0xE8, 0xE9, 0xEA, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7, 0xF8, 0xF9, 0xFA, 0xFF, 0xC4, 0x00, 0x1F, 0x01, 0x00, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x03, 0x04,
    0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0xFF, 0xC4, 0x00, 0xB5, 0x11, 0x00, 0x02, 0x01, 0x02, 0x04, 0x04, 0x03, 0x04, 0x07, 0x05, 0x04, 0x04, 0x00, 0x01, 0x02, 0x77, 0x00, 0x01, 0x02, 0x03, 0x11, 0x04, 0x05, 0x21, 0x31, 0x06, 0x12, 0x41,
    0x51, 0x07, 0x61, 0x71, 0x13, 0x22, 0x32, 0x81, 0x08, 0x14, 0x42, 0x91, 0xA1, 0xB1, 0xC1, 0x09, 0x23, 0x33, 0x52, 0xF0, 0x15, 0x62, 0x72, 0xD1, 0x0A, 0x16, 0x24, 0x34, 0xE1, 0x25, 0xF1, 0x17, 0x18, 0x19, 0x1A, 0x26, 0x27, 0x28, 0x29, 0x2A,
    0x35, 0x36, 0x37, 0x38, 0x39, 0x3A, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5A, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6A, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7A, 0x82, 0x83,
    0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8A, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9A, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7, 0xA8, 0xA9, 0xAA, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8, 0xB9, 0xBA, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7,
    0xC8, 0xC9, 0xCA, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7, 0xD8, 0xD9, 0xDA, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7, 0xF8, 0xF9, 0xFA, 0xFF, 0xDA, 0x00, 0x0C, 0x03, 0x01, 0x00, 0x02, 0x11, 0x03,
    0x11, 0x00, 0x3F, 0x00, 0xF0, 0x40, 0x07, 0xBD, 0x48, 0xF1, 0x85, 0x55, 0x21, 0x5F, 0xE6, 0x1D, 0x4F, 0x7A, 0x7A, 0xC2, 0xB2, 0x1F, 0xDC, 0xB6, 0x4F, 0xF7, 0x1B, 0x86, 0xFC, 0x3D, 0x6B, 0x7B, 0xC4, 0x1A, 0xDD, 0x8E, 0xA3, 0xA0, 0x68, 0x76,
    0x16, 0xD6, 0xAF, 0x0C, 0xF6, 0x30, 0xBA, 0x4C, 0xCD, 0x8C, 0x16, 0x27, 0x3C, 0x7F, 0x3E, 0x7B, 0x93, 0x59, 0x4E, 0x72, 0x52, 0x8A, 0x4A, 0xE9, 0xEF, 0xE5, 0xA7, 0xF4, 0x8E, 0x8A, 0x74, 0xE2, 0xE1, 0x27, 0x27, 0xB6, 0xC7, 0x39, 0x85, 0xEC,
    0x1B, 0xF3, 0xFF, 0x00, 0xEB, 0x57, 0x41, 0xFD, 0x8D, 0xA1, 0xFF, 0x00, 0xC2, 0x2C, 0x75, 0x1F, 0xED, 0xC1, 0xFD, 0xA4, 0x17, 0x26, 0xC3, 0x69, 0xCE, 0x77, 0xE3, 0x1B, 0xB1, 0xFD, 0xDC, 0x37, 0x19, 0xE4, 0x91, 0xD8, 0x9A, 0xD5, 0xF1, 0x55,
    0xCB, 0x3F, 0x85, 0xF4, 0xBB, 0x67, 0xF0, 0xEB, 0xE9, 0xEB, 0x08, 0x8C, 0x25, 0xCB, 0xED, 0x1B, 0xFE, 0x43, 0xBC, 0x01, 0x8C, 0xF2, 0xC4, 0x9C, 0xFA, 0x01, 0x9C, 0x9E, 0x6B, 0x62, 0x48, 0x2F, 0x57, 0xC2, 0xC7, 0x4A, 0x7F, 0x05, 0x5C, 0x25,
    0xD0, 0xB0, 0xF2, 0x8C, 0xAD, 0x0A, 0x05, 0x0D, 0xBF, 0xFD, 0x7E, 0xFD, 0xBB, 0xB3, 0xC6, 0x31, 0x9E, 0xBD, 0xF1, 0xC5, 0x71, 0x54, 0xC5, 0x49, 0xC6, 0x12, 0xDB, 0x5E, 0xF1, 0xD9, 0x7F, 0x5D, 0x35, 0x1C, 0x69, 0xD9, 0xB5, 0xBE, 0x9D, 0x8E,
    0x1B, 0x4A, 0xD3, 0x74, 0xCB, 0xD8, 0x5D, 0xAF, 0x35, 0x75, 0xB2, 0x90, 0x31, 0x0A, 0x8D, 0x11, 0x6C, 0x81, 0x8E, 0x72, 0x3E, 0xA7, 0xF2, 0xAA, 0x37, 0xD0, 0x41, 0x6F, 0x7D, 0x34, 0x36, 0xF3, 0xFD, 0xA2, 0x14, 0x62, 0x12, 0x60, 0x31, 0xBC,
    0x7A, 0xE3, 0xB5, 0x6F, 0x78, 0x64, 0xCB, 0x6F, 0x6D, 0x70, 0xDF, 0xD8, 0x6D, 0x7C, 0xB3, 0x10, 0x63, 0x94, 0xC6, 0xAC, 0x14, 0x00, 0xEA, 0x40, 0xDC, 0x3B, 0x96, 0x07, 0x8E, 0xEA, 0x32, 0x08, 0xE2, 0xA3, 0x86, 0xFD, 0x74, 0x6F, 0x10, 0x5E,
    0x5E, 0x5D, 0x69, 0x06, 0x11, 0x74, 0xB2, 0x35, 0xB4, 0x4D, 0x1A, 0x1F, 0xB3, 0x06, 0x7E, 0x19, 0x55, 0xD4, 0xAB, 0x60, 0x06, 0x5C, 0x11, 0xDC, 0xE3, 0x04, 0x02, 0x36, 0x55, 0x26, 0xAA, 0x49, 0x2D, 0x7B, 0x2B, 0xAF, 0xF8, 0x73, 0x82, 0x9C,
    0x9B, 0xAC, 0xD3, 0x7A, 0x7C, 0xBF, 0xE1, 0xCE, 0x78, 0x01, 0xBB, 0x95, 0x62, 0x3D, 0x8D, 0x23, 0x01, 0x9E, 0x01, 0x03, 0xDC, 0xD7, 0x43, 0x65, 0xE2, 0x1B, 0x3B, 0x2F, 0x19, 0x41, 0xAD, 0x43, 0xA6, 0xA2, 0x5A, 0x46, 0x46, 0xEB, 0x42, 0xA8,
    0xC1, 0xC7, 0x97, 0xB5, 0xF8, 0xDA, 0x14, 0x6E, 0x39, 0x3C, 0x2E, 0x17, 0x3C, 0x0E, 0x2A, 0x9E, 0xB7, 0x75, 0x16, 0xAF, 0xAC, 0xDD, 0x6A, 0x70, 0xDB, 0x8B, 0x2B, 0x6B, 0x87, 0xDC, 0xB1, 0x16, 0xDD, 0xB3, 0x81, 0x95, 0x18, 0xFB, 0xDC, 0xF7,
    0xC7, 0xD6, 0xB6, 0x8C, 0xE6, 0xE6, 0x93, 0x8D, 0x95, 0xAF, 0x7B, 0xF5, 0xED, 0xFF, 0x00, 0x04, 0xE9, 0x69, 0x5B, 0x46, 0x64, 0xE2, 0x8A, 0x90, 0xB4, 0x4B, 0xC2, 0xC7, 0xBF, 0xDD, 0xC9, 0xFE, 0x43, 0xA7, 0xEB, 0x45, 0x6C, 0x49, 0xB9, 0x25,
    0x99, 0xF1, 0x0D, 0xCA, 0xAE, 0x97, 0x63, 0x1D, 0xB3, 0x40, 0xA1, 0x1E, 0x36, 0x65, 0x42, 0x4F, 0xCC, 0x7B, 0x01, 0x9F, 0xBA, 0x72, 0x4F, 0x73, 0xCF, 0x00, 0x55, 0x4B, 0xAB, 0x19, 0x92, 0x61, 0x6B, 0x76, 0x15, 0x6F, 0x0A, 0xE6, 0x36, 0x0C,
    0x08, 0x7E, 0x48, 0xDA, 0x4F, 0xA8, 0x20, 0x8C, 0xFA, 0x8C, 0x56, 0xED, 0xC5, 0xA3, 0x3D, 0x82, 0xEA, 0x9A, 0x34, 0xF2, 0x42, 0x8C, 0xFB, 0x18, 0x46, 0xED, 0xE6, 0x42, 0xE7, 0x18, 0x47, 0x39, 0xE5, 0x73, 0x90, 0x0F, 0x6C, 0x8F, 0x5C, 0x08,
    0x13, 0xC3, 0x37, 0x7A, 0x92, 0xDB, 0x4D, 0x71, 0xA8, 0x38, 0x9A, 0x44, 0x51, 0xB6, 0xE2, 0x33, 0xB9, 0x38, 0x24, 0x03, 0xCF, 0x4E, 0xFF, 0x00, 0x40, 0xC7, 0x82, 0xA4, 0x57, 0x0D, 0x3A, 0xF1, 0x8E, 0xEE, 0xD1, 0x5D, 0x35, 0xBD, 0xCF, 0x52,
    0xBE, 0x16, 0x4D, 0xD9, 0x2B, 0xC9, 0xEB, 0x75, 0x6B, 0x58, 0xC8, 0x8E, 0xF6, 0xF3, 0x53, 0xB9, 0x82, 0xCB, 0x52, 0xD5, 0xAE, 0x16, 0xD9, 0xA5, 0x45, 0x76, 0xB8, 0x91, 0xE4, 0x58, 0x80, 0xF9, 0x72, 0x54, 0x9F, 0xE1, 0x04, 0xFF, 0x00, 0x2E,
    0x2B, 0xAA, 0xBF, 0xB9, 0xBA, 0xB7, 0xF1, 0x6A, 0x69, 0x30, 0xF8, 0xD7, 0x50, 0xB9, 0xB0, 0x97, 0x22, 0x49, 0xFE, 0xDC, 0xCA, 0x13, 0xEF, 0x7C, 0x8C, 0xC5, 0x8A, 0x93, 0xC0, 0xE7, 0xA1, 0xCF, 0x4A, 0xE3, 0xEE, 0xB1, 0x71, 0x6F, 0x1D, 0xE8,
    0xFB, 0xC4, 0xF9, 0x73, 0x7F, 0xBD, 0x8E, 0x1B, 0xF1, 0x1F, 0xA8, 0x35, 0xAB, 0x6A, 0x2D, 0x4F, 0x86, 0x21, 0x27, 0x40, 0x99, 0xEE, 0x3E, 0xDC, 0xA9, 0xFD, 0xA6, 0x19, 0xCA, 0x11, 0xD7, 0xC9, 0xDB, 0xF7, 0x4B, 0x63, 0xF1, 0xC7, 0x6E, 0xF5,
    0xAC, 0xE3, 0x18, 0x54, 0x84, 0xDA, 0xBC, 0x56, 0x96, 0xD2, 0xDE, 0xBA, 0xEB, 0xD3, 0xA7, 0xDC, 0x79, 0x7E, 0xCE, 0x75, 0x24, 0xED, 0x3B, 0x68, 0xFF, 0x00, 0xE1, 0xC9, 0x35, 0x58, 0xFF, 0x00, 0xB2, 0x52, 0xCE, 0x1B, 0x0D, 0x62, 0xE9, 0x62,
    0x2C, 0x38, 0x5B, 0xA0, 0xCB, 0x82, 0xAA, 0xC6, 0x45, 0x09, 0x8D, 0xA3, 0x2C, 0xC3, 0x07, 0xD0, 0xF3, 0xD7, 0x10, 0x78, 0xAF, 0x4C, 0xB1, 0xD3, 0x6F, 0x6D, 0xFE, 0xC5, 0xAD, 0x8D, 0x54, 0xCD, 0x08, 0x79, 0x24, 0xEE, 0xA7, 0xB6, 0x7A, 0xF5,
    0x1D, 0x06, 0x72, 0x3B, 0xF6, 0x27, 0x43, 0xC5, 0xF0, 0x0D, 0x63, 0xC5, 0x61, 0x74, 0x6D, 0x1A, 0xE2, 0x0F, 0x36, 0x36, 0x11, 0xDA, 0x25, 0x99, 0x8D, 0xC9, 0x47, 0x70, 0xC7, 0x62, 0x8E, 0x7E, 0xE9, 0xC9, 0x03, 0x8C, 0x10, 0x79, 0x52, 0x6B,
    0x99, 0xB7, 0xB4, 0x69, 0x6F, 0x7E, 0xCF, 0x28, 0x68, 0xB6, 0x13, 0xE6, 0xE4, 0x60, 0xA0, 0x5F, 0xBD, 0x91, 0xEB, 0xC1, 0xFC, 0x69, 0xC6, 0x6A, 0xBC, 0xE3, 0x56, 0x3E, 0xEE, 0x9A, 0xC7, 0x4E, 0xBD, 0xFA, 0xE8, 0x67, 0xF5, 0x69, 0x52, 0x92,
    0x4E, 0x57, 0xB5, 0xFA, 0x6E, 0x11, 0x44, 0x91, 0x43, 0xF6, 0x99, 0xD7, 0x72, 0x93, 0x88, 0xE3, 0x3F, 0xC6, 0x7B, 0x9F, 0xA0, 0xFD, 0x7A, 0x53, 0x6E, 0xA3, 0xB9, 0x02, 0x29, 0xEE, 0x11, 0x82, 0xCC, 0xB9, 0x8D, 0xB1, 0xC1, 0x03, 0xD3, 0xD3,
    0x1E, 0x94, 0x97, 0x53, 0xFD, 0xA6, 0x72, 0xE1, 0x76, 0x20, 0xF9, 0x51, 0x07, 0x45, 0x51, 0xD0, 0x56, 0xB5, 0xB2, 0xFD, 0xB2, 0x18, 0x4C, 0xF1, 0x2C, 0x6B, 0x6F, 0x08, 0x54, 0x64, 0xC8, 0x0A, 0x37, 0x67, 0x73, 0x03, 0x9C, 0xB1, 0xCB, 0x74,
    0xC7, 0x50, 0x7D, 0x2B, 0x49, 0xCF, 0x96, 0xCC, 0xEB, 0xC3, 0xD0, 0x75, 0xA5, 0xC8, 0xB7, 0x32, 0x92, 0xCA, 0x57, 0x00, 0x91, 0xB3, 0x70, 0xDC, 0xA0, 0xA9, 0x24, 0x8F, 0x5C, 0x00, 0x4E, 0x3D, 0xE8, 0xAD, 0xCF, 0x3F, 0xCB, 0x1B, 0x60, 0x1E,
    0x52, 0x67, 0x3D, 0x79, 0x63, 0xEA, 0x4F, 0x73, 0x45, 0x65, 0xED, 0x66, 0xF6, 0x47, 0xAB, 0x1C, 0xB6, 0x92, 0x56, 0x72, 0xD7, 0xFA, 0xF3, 0x1D, 0xE1, 0xEB, 0xC8, 0xAD, 0x35, 0x38, 0xD2, 0xE8, 0x66, 0xCE, 0x7F, 0xDD, 0x4E, 0xBE, 0xC7, 0xA1,
    0xFC, 0x0E, 0x0F, 0xE7, 0x52, 0x4B, 0xE1, 0xD8, 0x65, 0xD4, 0x65, 0x49, 0xEE, 0x52, 0x10, 0xAE, 0xB1, 0xEE, 0xF3, 0x23, 0x25, 0xC8, 0x93, 0x61, 0x24, 0x16, 0x04, 0x7C, 0xB8, 0x7F, 0xFF, 0x00, 0x58, 0xCE, 0x42, 0xE7, 0xAF, 0x4A, 0xEA, 0xFC,
    0x45, 0x60, 0xBA, 0xAE, 0xB1, 0x77, 0xE7, 0x4F, 0x15, 0xAB, 0xA6, 0xC7, 0x6D, 0xC0, 0xFE, 0xEC, 0x98, 0xD0, 0x1D, 0xC4, 0xE3, 0x82, 0x71, 0xD3, 0x38, 0xC1, 0x24, 0x63, 0x9A, 0xC2, 0x6D, 0xC2, 0xB5, 0xD3, 0xB5, 0xD6, 0xBF, 0x2B, 0x74, 0xF9,
    0x8D, 0xC1, 0x4F, 0x0F, 0x69, 0x2B, 0xD9, 0xE9, 0xD3, 0x73, 0x9F, 0x9E, 0xC6, 0x1B, 0x43, 0x2D, 0xA4, 0x37, 0x4B, 0x72, 0xB3, 0xDA, 0x09, 0xB2, 0x00, 0x1B, 0x5D, 0x72, 0xD8, 0xE0, 0x9E, 0xCA, 0x7D, 0xF0, 0xD5, 0x6F, 0x4E, 0x37, 0xAB, 0xE1,
    0xAB, 0x69, 0x22, 0xD3, 0xB7, 0x40, 0xBA, 0x92, 0x05, 0xBB, 0x37, 0x4C, 0x14, 0xBF, 0x04, 0x46, 0x63, 0xDD, 0xB7, 0xDF, 0x76, 0xDC, 0xE2, 0x9B, 0x3E, 0x8F, 0x1E, 0x91, 0xAB, 0xDB, 0xC7, 0x15, 0xE4, 0x77, 0x4A, 0xE2, 0x5F, 0x99, 0x00, 0x1C,
    0x00, 0x46, 0x78, 0x63, 0x91, 0xD4, 0x7D, 0x43, 0x0E, 0xD9, 0x39, 0x76, 0x57, 0x3A, 0x8B, 0x5A, 0xAD, 0xBC, 0x37, 0xB3, 0x2D, 0xB2, 0x38, 0x71, 0x11, 0x94, 0xEC, 0x0D, 0xD4, 0x1D, 0xBD, 0x33, 0x91, 0xE9, 0x5B, 0x49, 0x7B, 0x4A, 0x69, 0xA7,
    0x7F, 0x5B, 0xAF, 0xCA, 0xC7, 0x9C, 0xA3, 0x28, 0xD5, 0x71, 0x51, 0xD7, 0xB2, 0xD4, 0xEB, 0xFC, 0x4D, 0xAF, 0x6A, 0xBA, 0x5F, 0x8B, 0x2D, 0x35, 0x0B, 0xAB, 0x7B, 0x27, 0xB8, 0x8E, 0xC6, 0x7B, 0x68, 0xDA, 0x23, 0xBE, 0x39, 0x37, 0x34, 0xF1,
    0xB3, 0x90, 0xEB, 0xC9, 0x0C, 0xCE, 0x08, 0x23, 0x0C, 0x57, 0xD1, 0xAB, 0x92, 0x37, 0x13, 0x4D, 0x67, 0xA8, 0x5F, 0xDC, 0x48, 0xD2, 0x5C, 0xDD, 0xCC, 0x11, 0xA4, 0x6E, 0xAC, 0x58, 0x97, 0x72, 0x7E, 0xA4, 0x2F, 0xE7, 0x56, 0x75, 0xC6, 0xD6,
    0x2F, 0xEF, 0x64, 0xB8, 0xD5, 0x66, 0x2F, 0x71, 0x1A, 0x95, 0x2A, 0xC8, 0x13, 0x60, 0xC9, 0x62, 0x02, 0x80, 0x00, 0xE4, 0x92, 0x78, 0xEA, 0x49, 0xEA, 0x6A, 0x91, 0x0C, 0xDA, 0x1C, 0x0A, 0xB8, 0xCB, 0x5D, 0xB8, 0xE4, 0xF7, 0xDA, 0x98, 0xFE,
    0x75, 0x38, 0x4A, 0x30, 0xA7, 0x4D, 0x3B, 0x2B, 0xDA, 0xDA, 0x7D, 0xFF, 0x00, 0xA9, 0x38, 0x95, 0x51, 0x4E, 0xD2, 0x4D, 0x7A, 0x84, 0x5A, 0x72, 0xCB, 0x16, 0x9E, 0xEB, 0x23, 0x31, 0xB9, 0x77, 0x57, 0x5D, 0xA0, 0x6C, 0x0A, 0x46, 0x70, 0x73,
    0xCF, 0x07, 0x3D, 0xAB, 0x64, 0x41, 0x3D, 0xC1, 0x86, 0xD2, 0x08, 0x9A, 0x49, 0x9C, 0x6F, 0x64, 0x41, 0x93, 0x9C, 0x67, 0x03, 0xD8, 0x0E, 0x3E, 0x82, 0xB2, 0xED, 0xB4, 0xDB, 0x8B, 0x69, 0x84, 0x93, 0xAA, 0x22, 0x14, 0x91, 0x73, 0xE6, 0x2B,
    0x73, 0xB1, 0xBB, 0x02, 0x4F, 0x63, 0x5B, 0x9F, 0x6D, 0x9F, 0x4D, 0xD6, 0x9E, 0xEA, 0xDF, 0x68, 0x95, 0x09, 0x0B, 0xB8, 0x64, 0x72, 0xB8, 0xE9, 0xF4, 0x35, 0x35, 0xE5, 0x26, 0xED, 0x17, 0x77, 0xAD, 0x8F, 0x5F, 0x2D, 0xA4, 0xA3, 0x09, 0x4A,
    0x4A, 0xDB, 0x2F, 0xC0, 0x85, 0x2E, 0x2E, 0x74, 0xB6, 0x9A, 0xD9, 0xE1, 0x55, 0x72, 0xCA, 0x5D, 0x65, 0x5E, 0x41, 0x00, 0xE3, 0xBF, 0xBD, 0x15, 0xD0, 0xEA, 0xF0, 0x26, 0xA5, 0xA4, 0xDB, 0x6B, 0x56, 0xF6, 0x6E, 0x2E, 0x67, 0x6D, 0x92, 0xA4,
    0x43, 0x76, 0x71, 0xB8, 0x67, 0xA1, 0xEE, 0xBF, 0xA8, 0xA2, 0xB9, 0x29, 0xD4, 0x85, 0x45, 0xCD, 0x25, 0xAF, 0x5F, 0x54, 0x7A, 0x8E, 0x33, 0x86, 0x91, 0x96, 0x87, 0x0B, 0x15, 0xC4, 0x29, 0x22, 0xB3, 0x12, 0xCA, 0x08, 0x24, 0x60, 0xF2, 0x2B,
    0x7A, 0x7F, 0xB2, 0xF8, 0xA2, 0xEE, 0x6B, 0x99, 0x6F, 0x8D, 0xB1, 0x69, 0x59, 0xC0, 0x9D, 0x55, 0x40, 0x25, 0x4E, 0x17, 0x39, 0xE8, 0x02, 0x2F, 0xCD, 0x80, 0x3E, 0x63, 0xC5, 0x64, 0xDC, 0xC0, 0x6D, 0x9D, 0x54, 0x92, 0x77, 0x2E, 0xEE, 0x71,
    0x91, 0xC9, 0x1D, 0x89, 0xF4, 0xAA, 0x33, 0x30, 0x23, 0x04, 0x02, 0x7D, 0x71, 0x5E, 0x82, 0x82, 0x9B, 0x52, 0x8E, 0xFD, 0xCF, 0x02, 0xAC, 0xE5, 0x4E, 0x0E, 0x33, 0xD5, 0x76, 0xDB, 0xF5, 0x35, 0x24, 0xB0, 0x8B, 0x4B, 0xD4, 0xAE, 0xFC, 0x9B,
    0x95, 0xB8, 0x8E, 0xDE, 0xD8, 0xB8, 0x91, 0x40, 0x00, 0x96, 0x50, 0xA3, 0xA1, 0x23, 0xAB, 0x71, 0xCD, 0x50, 0xB0, 0x4B, 0xC0, 0x87, 0xEC, 0xF6, 0x73, 0x4C, 0x87, 0x92, 0x52, 0x36, 0x61, 0xFA, 0x54, 0xB2, 0xA3, 0x5B, 0xE9, 0x50, 0xDA, 0xA2,
    0x96, 0xB9, 0xBD, 0x75, 0x94, 0xA0, 0x1C, 0xEC, 0x1C, 0x20, 0xFA, 0x92, 0x49, 0xFA, 0x62, 0xBD, 0x77, 0xC3, 0x3A, 0x74, 0x1A, 0x75, 0x82, 0x5A, 0xCB, 0x69, 0xF6, 0x95, 0x8A, 0xD8, 0xC4, 0x4A, 0xAE, 0xEC, 0x48, 0xC7, 0x25, 0x87, 0xFC, 0x08,
    0x9C, 0x7B, 0x71, 0x5C, 0xD8, 0xFC, 0x62, 0xC2, 0xD3, 0x57, 0x5C, 0xCD, 0x9C, 0xD8, 0x78, 0xB9, 0x54, 0x73, 0x87, 0xBB, 0x63, 0xCB, 0x6F, 0xE4, 0xD6, 0xAF, 0xA5, 0x92, 0x69, 0xB4, 0xEB, 0x9D, 0xF2, 0x00, 0xAC, 0xDF, 0x67, 0x61, 0x9E, 0x00,
    0xF4, 0xF4, 0xAA, 0x76, 0xD1, 0x3C, 0xBA, 0x64, 0xF0, 0x72, 0x92, 0xDB, 0xDC, 0x07, 0x21, 0x86, 0x31, 0x91, 0xB4, 0xE7, 0xF1, 0x02, 0xBD, 0xD2, 0xF1, 0x20, 0xB9, 0xB3, 0x8D, 0x6C, 0xF4, 0xD7, 0x59, 0x7C, 0xC5, 0x2B, 0x22, 0xC5, 0xD7, 0x0B,
    0x82, 0x06, 0x33, 0xD5, 0xBD, 0xCF, 0x23, 0xDE, 0xBC, 0xA7, 0xC4, 0xF6, 0x89, 0xA6, 0xF8, 0xB2, 0x49, 0x9C, 0x6C, 0xB2, 0xD5, 0x10, 0x96, 0x23, 0xF8, 0x19, 0xB8, 0x7F, 0xC4, 0x3F, 0xCD, 0xF4, 0x22, 0xB9, 0xF2, 0xEC, 0xC6, 0x35, 0xE5, 0xEC,
    0xB9, 0x79, 0x74, 0xD3, 0xE4, 0x6B, 0x89, 0x8C, 0xB4, 0xA9, 0x37, 0x72, 0x94, 0xBA, 0x8A, 0x3F, 0x87, 0xAD, 0x1E, 0xE3, 0x50, 0x9A, 0x69, 0x7C, 0xE2, 0x24, 0xB6, 0x12, 0x2F, 0x0A, 0x7C, 0xC0, 0xD8, 0x5C, 0x65, 0x70, 0x36, 0x90, 0xC7, 0x83,
    0xBC, 0x8F, 0xE1, 0xA7, 0x3E, 0xB1, 0x68, 0x5F, 0x7C, 0x76, 0x4C, 0x5C, 0x80, 0x37, 0x4E, 0x0B, 0x13, 0xF8, 0x0C, 0x0A, 0xC2, 0xDA, 0xF6, 0x37, 0xAF, 0x0C, 0xE0, 0x07, 0x43, 0xB5, 0xBF, 0xC4, 0x7B, 0x56, 0xEE, 0x9F, 0x6A, 0xB7, 0x7E, 0x6E,
    0xEB, 0x84, 0x87, 0x62, 0x6E, 0x05, 0xCF, 0x07, 0xF1, 0xCF, 0x4F, 0xCF, 0xA8, 0xAE, 0xDA, 0xB4, 0xE1, 0x05, 0x77, 0xFD, 0x5C, 0xEB, 0xCB, 0xEA, 0xD5, 0xA9, 0xA4, 0x65, 0xAE, 0x9E, 0x7B, 0x7C, 0xC4, 0x7D, 0x7A, 0xEA, 0x40, 0x17, 0xED, 0x13,
    0xAA, 0x8E, 0x82, 0x34, 0x28, 0x07, 0xE4, 0x28, 0xAD, 0x68, 0x34, 0x5B, 0x79, 0x25, 0x65, 0x3A, 0x8A, 0x85, 0x05, 0xC6, 0x76, 0xE7, 0x3B, 0x5B, 0x00, 0xE0, 0x13, 0xC1, 0x18, 0x39, 0xE9, 0xD4, 0x76, 0xA2, 0xB9, 0x1D, 0x7C, 0x3C, 0x74, 0xB7,
    0xE1, 0xFF, 0x00, 0x00, 0xF5, 0x96, 0x1F, 0x10, 0xF5, 0xE6, 0x5F, 0xD7, 0xCC, 0xE4, 0x6E, 0xB5, 0x37, 0xBA, 0x90, 0x48, 0xE8, 0xAA, 0x42, 0xE3, 0xE5, 0x1E, 0xE7, 0xFC, 0x69, 0xD6, 0x51, 0x47, 0x22, 0x4F, 0x77, 0x38, 0x2F, 0x05, 0xB0, 0x0C,
    0xD1, 0x83, 0xCC, 0x84, 0x9C, 0x01, 0x9E, 0xC3, 0x3D, 0x7B, 0xE3, 0xF4, 0x28, 0xAF, 0x5E, 0x31, 0x51, 0xD1, 0x1F, 0x21, 0x52, 0xA4, 0xEA, 0x3B, 0xCD, 0xDC, 0x5B, 0x4D, 0x4E, 0x48, 0xF5, 0x84, 0xD4, 0xA6, 0x45, 0x9A, 0x50, 0xDB, 0xF0, 0x78,
    0x00, 0xF6, 0xC7, 0xA6, 0x3B, 0x7D, 0x2B, 0xBD, 0xB1, 0xF8, 0x95, 0xA8, 0xDB, 0x40, 0x8B, 0x15, 0x95, 0xA0, 0xD8, 0x3E, 0x56, 0xC1, 0xDC, 0x3E, 0x60, 0xDD, 0x46, 0x09, 0xE4, 0x0E, 0xBD, 0xA8, 0xA2, 0xB8, 0xB1, 0x78, 0x5A, 0x35, 0xAC, 0xEA,
    0x46, 0xE6, 0xF8, 0x69, 0xC9, 0x68, 0x03, 0xE2, 0x3E, 0xA9, 0x1A, 0x44, 0xA9, 0x6B, 0x6A, 0xA9, 0x1A, 0xBA, 0xED, 0xF9, 0x88, 0x60, 0xC3, 0x04, 0x1E, 0x7A, 0x72, 0x7A, 0x63, 0x19, 0x24, 0x60, 0x9A, 0xE3, 0x7C, 0x41, 0xAF, 0x4F, 0xAC, 0x08,
    0xE3, 0x9A, 0x28, 0xD1, 0x63, 0x62, 0xC3, 0x66, 0x7A, 0x9F, 0xAD, 0x14, 0x54, 0x61, 0x70, 0x74, 0x29, 0xCB, 0x9A, 0x11, 0xB3, 0x2F, 0x11, 0x39, 0x72, 0xDA, 0xFB, 0x95, 0x57, 0xFE, 0x26, 0x36, 0x2E, 0x5B, 0x8B, 0x9B, 0x48, 0xB7, 0x6F, 0x3D,
    0x1E, 0x31, 0xD8, 0xFB, 0x8E, 0xC7, 0xD3, 0x8F, 0x4A, 0xAB, 0x15, 0xE3, 0xC4, 0xBB, 0x71, 0x95, 0x1D, 0x32, 0x7A, 0x51, 0x45, 0x7A, 0x0D, 0x27, 0xA3, 0x38, 0xE1, 0x52, 0x50, 0x7C, 0xD1, 0x76, 0x64, 0x83, 0x50, 0x7F, 0xEE, 0x0F, 0xCE, 0x8A,
    0x28, 0xA5, 0xEC, 0xE3, 0xD8, 0xDF, 0xEB, 0x95, 0xFF, 0x00, 0x98, 0xFF, 0xD9, 0x00
  };

  static const unsigned char _ac70x70_BMP[] = {
    0x42, 0x4D, 0x2E, 0x3A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x00, 0x46, 0x00, 0x00, 0x00, 0x46, 0x00, 0x00, 0x00, 0x01, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x39, 0x00, 0x00, 0x12, 0x0B,
    0x00, 0x00, 0x12, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xA0, 0xA9, 0x8F, 0x9D, 0xA6, 0x8C, 0x9C, 0xA5, 0x8B, 0x96, 0xA0, 0x89, 0x98, 0xA2, 0x8B, 0x99, 0xA3, 0x8C, 0x90, 0x9E, 0x86, 0x93, 0xA1, 0x89, 0x9B, 0xA9,
    0x91, 0x8A, 0x98, 0x80, 0x9C, 0xAA, 0x92, 0xA4, 0xB2, 0x9A, 0xA3, 0xB1, 0x99, 0x9C, 0xAB, 0x90, 0x98, 0xA7, 0x8C, 0x9A, 0xA9, 0x8E, 0x9C, 0xAA, 0x92, 0xA1, 0xAF, 0x97, 0x98, 0xA6, 0x8E, 0x93, 0xA6, 0x8D, 0x92, 0xA5, 0x8C, 0x94, 0xA7, 0x8E,
    0x9F, 0xAE, 0x93, 0x9B, 0xAA, 0x8F, 0xA8, 0xB7, 0x9C, 0xA2, 0xB1, 0x96, 0xA6, 0xB4, 0x9C, 0xA5, 0xB3, 0x9B, 0xA6, 0xB4, 0x9C, 0xAD, 0xBB, 0xA3, 0xAA, 0xB8, 0xA0, 0xAA, 0xB8, 0xA0, 0xB0, 0xBA, 0xA3, 0xB6, 0xC0, 0xA9, 0xB2, 0xBC, 0xA5, 0xB1,
    0xBB, 0xA4, 0xB8, 0xC2, 0xAB, 0xB6, 0xC0, 0xA9, 0xB8, 0xBE, 0xA5, 0xB5, 0xBB, 0xA2, 0xB2, 0xB8, 0x9F, 0xBA, 0xC0, 0xA7, 0xB1, 0xB7, 0x9E, 0xB4, 0xBA, 0xA1, 0xB4, 0xBA, 0xA1, 0xBF, 0xC5, 0xAC, 0xB6, 0xBC, 0xA3, 0xC0, 0xC6, 0xAD, 0xBC, 0xC2,
    0xA9, 0xC2, 0xC8, 0xAF, 0xC2, 0xC8, 0xAF, 0xC6, 0xCA, 0xAD, 0xC1, 0xC5, 0xA8, 0xC0, 0xC4, 0xA7, 0xC3, 0xC8, 0xA8, 0xBC, 0xC1, 0xA1, 0xC4, 0xC9, 0xA9, 0xBB, 0xC0, 0xA0, 0xBB, 0xC1, 0x9E, 0xBD, 0xC3, 0xA0, 0xB7, 0xBD, 0x9A, 0xBB, 0xBE, 0x97,
    0xB6, 0xB9, 0x92, 0xBF, 0xC2, 0x9B, 0xBE, 0xC1, 0x9A, 0xBE, 0xC1, 0x9A, 0xBB, 0xBE, 0x97, 0xBE, 0xC1, 0x9A, 0xCB, 0xCE, 0xA7, 0xC2, 0xC5, 0x9E, 0x00, 0x00, 0x9C, 0xA2, 0x8F, 0x9F, 0xA5, 0x92, 0x9D, 0xA3, 0x90, 0x98, 0xA3, 0x8F, 0x98, 0xA3,
    0x8F, 0xA1, 0xAC, 0x98, 0xA2, 0xAE, 0x9A, 0xA3, 0xAF, 0x9B, 0xA0, 0xAC, 0x98, 0x9E, 0xAA, 0x96, 0xA4, 0xB0, 0x9C, 0x8F, 0x9B, 0x87, 0x9B, 0xA7, 0x93, 0x9B, 0xA9, 0x91, 0x9B, 0xA9, 0x91, 0xA0, 0xAE, 0x96, 0x98, 0xA4, 0x90, 0xA3, 0xAF, 0x9B,
    0x9B, 0xA7, 0x93, 0x92, 0xA3, 0x8E, 0x9B, 0xAC, 0x97, 0x9B, 0xAC, 0x97, 0x90, 0x9E, 0x86, 0x9B, 0xA9, 0x91, 0xA1, 0xAF, 0x97, 0xA0, 0xAE, 0x96, 0x9E, 0xAA, 0x96, 0xA7, 0xB3, 0x9F, 0xAC, 0xB8, 0xA4, 0xAD, 0xB9, 0xA5, 0xB1, 0xBD, 0xA9, 0xB0,
    0xBC, 0xA8, 0xAE, 0xB9, 0xA5, 0xB3, 0xBE, 0xAA, 0xB6, 0xC1, 0xAD, 0xB3, 0xBE, 0xAA, 0xB1, 0xBC, 0xA8, 0xB6, 0xC1, 0xAD, 0xB6, 0xBE, 0xA7, 0xB5, 0xBD, 0xA6, 0xBA, 0xC2, 0xAB, 0xB9, 0xC1, 0xAA, 0xB5, 0xBD, 0xA6, 0xB6, 0xBE, 0xA7, 0xB6, 0xBE,
    0xA7, 0xBB, 0xC3, 0xAC, 0xBD, 0xC5, 0xAE, 0xBB, 0xC3, 0xAC, 0xBD, 0xC5, 0xAE, 0xBA, 0xC2, 0xAB, 0xC0, 0xC8, 0xB1, 0xC0, 0xC7, 0xAC, 0xBE, 0xC5, 0xAA, 0xBC, 0xC3, 0xA8, 0xBD, 0xC1, 0xA4, 0xBC, 0xC0, 0xA3, 0xBD, 0xC1, 0xA4, 0xBE, 0xC2, 0xA5,
    0xBD, 0xC2, 0xA2, 0xBB, 0xC0, 0xA0, 0xBC, 0xC1, 0xA1, 0xC0, 0xC2, 0x9E, 0xBE, 0xC0, 0x9C, 0xBE, 0xC0, 0x9C, 0xBF, 0xC1, 0x9D, 0xC2, 0xC4, 0xA0, 0xC6, 0xC8, 0xA4, 0xC3, 0xC6, 0x9F, 0xC4, 0xC7, 0xA0, 0xC2, 0xC5, 0x9E, 0x00, 0x00, 0x9C, 0xAD,
    0x9F, 0x99, 0xAA, 0x9C, 0x9A, 0xAB, 0x9D, 0x9C, 0xAA, 0x98, 0x9C, 0xAA, 0x98, 0x93, 0xA1, 0x8F, 0x99, 0xA5, 0x93, 0x95, 0xA1, 0x8F, 0x97, 0xA3, 0x91, 0x9C, 0xA8, 0x96, 0xA4, 0xB0, 0x9E, 0x9B, 0xA7, 0x95, 0xA9, 0xB5, 0xA3, 0xA9, 0xB5, 0xA1,
    0xA8, 0xB4, 0xA0, 0x9E, 0xAA, 0x96, 0xA7, 0xB3, 0xA1, 0xAC, 0xB8, 0xA6, 0xA2, 0xAE, 0x9C, 0x94, 0xA4, 0x92, 0x96, 0xA6, 0x94, 0xA0, 0xB0, 0x9E, 0xA7, 0xB3, 0x9F, 0xA2, 0xAE, 0x9A, 0x9F, 0xAB, 0x97, 0x9E, 0xAA, 0x96, 0x98, 0xA4, 0x92, 0xA6,
    0xB2, 0xA0, 0xA5, 0xB1, 0x9F, 0xA7, 0xB3, 0xA1, 0xB4, 0xC0, 0xAE, 0xB7, 0xC3, 0xB1, 0xB2, 0xC0, 0xAE, 0xB1, 0xBF, 0xAD, 0xB5, 0xC3, 0xB1, 0xB2, 0xC0, 0xAE, 0xB0, 0xBE, 0xAC, 0xB2, 0xC0, 0xAE, 0xB5, 0xC0, 0xAC, 0xB3, 0xBE, 0xAA, 0xB4, 0xBF,
    0xAB, 0xB5, 0xC0, 0xAC, 0xB8, 0xC3, 0xAF, 0xB7, 0xC2, 0xAE, 0xB7, 0xC2, 0xAE, 0xBB, 0xC6, 0xB2, 0xBB, 0xC6, 0xB2, 0xB9, 0xC4, 0xB0, 0xBB, 0xC6, 0xB2, 0xB9, 0xC4, 0xB0, 0xBE, 0xC9, 0xB5, 0xBC, 0xC4, 0xAD, 0xBA, 0xC2, 0xAB, 0xBE, 0xC6, 0xAF,
    0xC4, 0xC7, 0xAD, 0xC2, 0xC5, 0xAB, 0xBE, 0xC1, 0xA7, 0xC1, 0xC4, 0xAA, 0xBF, 0xC3, 0xA6, 0xBD, 0xC1, 0xA4, 0xBE, 0xC2, 0xA5, 0xC3, 0xC4, 0xA4, 0xBF, 0xC0, 0xA0, 0xC5, 0xC6, 0xA6, 0xC0, 0xC1, 0xA1, 0xC4, 0xC5, 0xA5, 0xC3, 0xC4, 0xA4, 0xC3,
    0xC6, 0x9F, 0xC2, 0xC5, 0x9E, 0xC4, 0xC7, 0xA0, 0x00, 0x00, 0x97, 0xA7, 0xA0, 0x95, 0xA5, 0x9E, 0x92, 0xA2, 0x9B, 0x9C, 0xAE, 0xA7, 0x9F, 0xB1, 0xAA, 0xA7, 0xB9, 0xB2, 0xA9, 0xB7, 0xB3, 0xA6, 0xB4, 0xB0, 0xA9, 0xB7, 0xB3, 0xA4, 0xB2, 0xAE,
    0xA5, 0xB3, 0xAD, 0xA5, 0xB3, 0xAD, 0xA6, 0xB4, 0xAE, 0xA5, 0xB3, 0xAD, 0xA9, 0xB7, 0xB1, 0xA0, 0xAE, 0xA8, 0x99, 0xAE, 0x9F, 0x98, 0xAD, 0x9E, 0x9E, 0xB3, 0xA4, 0xA6, 0xB7, 0xA9, 0xA3, 0xB4, 0xA6, 0xA7, 0xB8, 0xAA, 0xA8, 0xB9, 0xAB, 0x9F,
    0xB0, 0xA2, 0xA7, 0xB8, 0xAA, 0x9E, 0xAF, 0xA1, 0xA2, 0xB0, 0xA4, 0xA4, 0xB2, 0xA6, 0xAD, 0xBB, 0xAF, 0xA7, 0xB5, 0xA9, 0xAB, 0xB9, 0xAD, 0xAC, 0xBA, 0xAE, 0xB3, 0xBD, 0xB0, 0xB8, 0xC2, 0xB5, 0xB6, 0xC0, 0xB3, 0xB6, 0xC0, 0xB3, 0xB7, 0xC1,
    0xB4, 0xB7, 0xC1, 0xB4, 0xBA, 0xC3, 0xB6, 0xB9, 0xC2, 0xB5, 0xB7, 0xC0, 0xB3, 0xB7, 0xC0, 0xB3, 0xB8, 0xC2, 0xB1, 0xB8, 0xC2, 0xB1, 0xB8, 0xC2, 0xB1, 0xBC, 0xC6, 0xB5, 0xBF, 0xC9, 0xB8, 0xBB, 0xC5, 0xB4, 0xBC, 0xC8, 0xB2, 0xBF, 0xCB, 0xB5,
    0xBB, 0xC7, 0xB1, 0xBB, 0xC7, 0xB1, 0xBB, 0xC7, 0xB1, 0xBA, 0xC6, 0xB0, 0xBC, 0xC4, 0xAD, 0xBC, 0xC4, 0xAD, 0xBD, 0xC5, 0xAE, 0xBA, 0xC2, 0xAB, 0xC0, 0xC4, 0xAB, 0xBD, 0xC1, 0xA8, 0xC0, 0xC4, 0xAB, 0xC1, 0xC6, 0xA9, 0xBE, 0xC3, 0xA6, 0xC1,
    0xC6, 0xA9, 0xC4, 0xC9, 0xAA, 0xC4, 0xC9, 0xAA, 0xC0, 0xC5, 0xA6, 0xC2, 0xC9, 0xA4, 0xC0, 0xC7, 0xA2, 0xC4, 0xCB, 0xA6, 0x00, 0x00, 0x9D, 0xA4, 0xA7, 0x9F, 0xA6, 0xA9, 0x9A, 0xA1, 0xA4, 0x8F, 0x9E, 0xA0, 0x8F, 0x9E, 0xA0, 0x9C, 0xAB, 0xAD,
    0x9A, 0xAC, 0xAB, 0x9B, 0xAD, 0xAC, 0x9C, 0xAE, 0xAD, 0x9B, 0xAD, 0xAC, 0x99, 0xAB, 0xAC, 0x93, 0xA5, 0xA6, 0x95, 0xA7, 0xA8, 0x87, 0x97, 0x9E, 0x8F, 0x9F, 0xA6, 0x7F, 0x8F, 0x96, 0x78, 0x8B, 0x8E, 0x70, 0x83, 0x86, 0x77, 0x8A, 0x8D, 0x7E,
    0x8F, 0x92, 0x88, 0x99, 0x9C, 0x88, 0x99, 0x9C, 0x93, 0xA4, 0xA7, 0x93, 0xA4, 0xA7, 0x96, 0xA7, 0xAA, 0xA0, 0xB1, 0xB4, 0xA0, 0xB2, 0xB1, 0xA7, 0xB9, 0xB8, 0xA9, 0xBB, 0xBA, 0xAF, 0xC1, 0xC0, 0xAF, 0xC1, 0xC0, 0xAB, 0xBD, 0xBC, 0xAB, 0xB9,
    0xB7, 0xAF, 0xBD, 0xBB, 0xB3, 0xC1, 0xBF, 0xB1, 0xBF, 0xBD, 0xB3, 0xC1, 0xBF, 0xB5, 0xC3, 0xC1, 0xB6, 0xC3, 0xC1, 0xB8, 0xC5, 0xC3, 0xB2, 0xBF, 0xBD, 0xB3, 0xC0, 0xBE, 0xB9, 0xC7, 0xC1, 0xB5, 0xC3, 0xBD, 0xB2, 0xC0, 0xBA, 0xB3, 0xC1, 0xBB,
    0xB7, 0xC5, 0xBF, 0xB2, 0xC0, 0xBA, 0xB1, 0xC1, 0xB6, 0xAE, 0xBE, 0xB3, 0xBA, 0xCA, 0xBF, 0xB4, 0xC4, 0xB9, 0xB4, 0xC4, 0xB9, 0xB4, 0xC4, 0xB9, 0xB3, 0xBF, 0xB3, 0xB7, 0xC3, 0xB7, 0xB4, 0xC0, 0xB4, 0xB7, 0xC3, 0xB7, 0xB7, 0xC2, 0xAE, 0xB6,
    0xC1, 0xAD, 0xB9, 0xC4, 0xB0, 0xBB, 0xC7, 0xB0, 0xBB, 0xC7, 0xB0, 0xBB, 0xC7, 0xB0, 0xC0, 0xCB, 0xB1, 0xBF, 0xCA, 0xB0, 0xC0, 0xCB, 0xB1, 0xBF, 0xCA, 0xB0, 0xC1, 0xCC, 0xB2, 0xC2, 0xCD, 0xB3, 0x00, 0x00, 0xB8, 0xC3, 0xCB, 0xBA, 0xC5, 0xCD,
    0xB7, 0xC2, 0xCA, 0xB8, 0xC5, 0xCD, 0xB7, 0xC4, 0xCC, 0xBB, 0xC8, 0xD0, 0xB1, 0xC4, 0xC9, 0xAD, 0xC0, 0xC5, 0xA7, 0xBA, 0xBF, 0xA9, 0xBC, 0xC1, 0xA0, 0xB2, 0xB9, 0xA6, 0xB8, 0xBF, 0x9F, 0xB1, 0xB8, 0x9C, 0xAF, 0xB4, 0x9F, 0xB2, 0xB7, 0xA0,
    0xB3, 0xB8, 0x99, 0xAD, 0xB2, 0x9A, 0xAE, 0xB3, 0x93, 0xA7, 0xAC, 0x8C, 0x9F, 0xA4, 0x87, 0x9A, 0x9F, 0x87, 0x9A, 0x9F, 0x8B, 0x9E, 0xA3, 0x8D, 0xA0, 0xA5, 0x92, 0xA5, 0xAA, 0x88, 0x9B, 0xA0, 0x8B, 0x9E, 0xA5, 0x86, 0x99, 0xA0, 0x8D, 0xA0,
    0xA7, 0x88, 0x9B, 0xA2, 0x90, 0xA3, 0xAA, 0x93, 0xA6, 0xAD, 0x93, 0xA6, 0xA9, 0xA4, 0xB7, 0xBA, 0x96, 0xA9, 0xAC, 0x97, 0xAA, 0xAD, 0x95, 0xA8, 0xAB, 0x98, 0xAB, 0xAE, 0x98, 0xA7, 0xAA, 0x92, 0xA1, 0xA4, 0x8E, 0x9D, 0xA0, 0x90, 0x9F, 0xA2,
    0x9C, 0xAB, 0xAD, 0xA9, 0xB8, 0xBA, 0xAB, 0xBA, 0xBC, 0xAE, 0xBD, 0xBF, 0xB0, 0xBF, 0xC1, 0xB7, 0xC6, 0xC8, 0xBB, 0xCC, 0xC9, 0xBD, 0xCE, 0xCB, 0xB7, 0xC8, 0xC5, 0xB9, 0xCA, 0xC7, 0xB9, 0xCA, 0xC7, 0xB5, 0xC6, 0xC3, 0xB6, 0xC4, 0xBE, 0xB4,
    0xC2, 0xBC, 0xB6, 0xC4, 0xBE, 0xB5, 0xC3, 0xBD, 0xB8, 0xC4, 0xBE, 0xB3, 0xBF, 0xB9, 0xB2, 0xBE, 0xB8, 0xB4, 0xC2, 0xB7, 0xB3, 0xC1, 0xB6, 0xB3, 0xC1, 0xB6, 0xB9, 0xC3, 0xB6, 0xB9, 0xC3, 0xB6, 0xBF, 0xC9, 0xBC, 0xBF, 0xCB, 0xB9, 0xBB, 0xC7,
    0xB5, 0xBF, 0xCB, 0xB9, 0x00, 0x00, 0xC1, 0xC5, 0xCA, 0xC1, 0xC5, 0xCA, 0xC1, 0xC5, 0xCA, 0xBB, 0xC7, 0xCD, 0xBB, 0xC7, 0xCD, 0xBE, 0xCA, 0xD0, 0xBC, 0xC8, 0xCE, 0xBC, 0xC8, 0xCE, 0xBE, 0xCA, 0xD0, 0xBD, 0xC9, 0xCF, 0xBE, 0xCA, 0xD0, 0xBE,
    0xCA, 0xD0, 0xBE, 0xCA, 0xD0, 0xBE, 0xCA, 0xD0, 0xC0, 0xCC, 0xD2, 0xC0, 0xCC, 0xD2, 0xC0, 0xCC, 0xD0, 0xC0, 0xCC, 0xD0, 0xC2, 0xCE, 0xD2, 0xBF, 0xCE, 0xD0, 0xBF, 0xCE, 0xD0, 0xC1, 0xD0, 0xD2, 0xD6, 0xDB, 0xDE, 0xC3, 0xCA, 0xCD, 0x75, 0x81,
    0x83, 0x51, 0x5E, 0x60, 0x4B, 0x61, 0x66, 0x4A, 0x60, 0x6C, 0xC2, 0xD1, 0xDA, 0xC7, 0xD3, 0xD7, 0xC5, 0xD1, 0xD5, 0xC5, 0xD1, 0xD5, 0xC3, 0xD3, 0xD9, 0xC3, 0xD3, 0xD9, 0xC3, 0xD3, 0xD9, 0xC2, 0xD3, 0xD6, 0xC2, 0xD3, 0xD6, 0xC2, 0xD3, 0xD6,
    0xC7, 0xD3, 0xD7, 0xC7, 0xD3, 0xD7, 0xC7, 0xD3, 0xD7, 0xC7, 0xD3, 0xD7, 0xC5, 0xD2, 0xD4, 0xC9, 0xD6, 0xD8, 0xC9, 0xD6, 0xD8, 0xC2, 0xD3, 0xD6, 0xC5, 0xD6, 0xD9, 0xC5, 0xD6, 0xD9, 0xC8, 0xD4, 0xDA, 0xC4, 0xD4, 0xDA, 0xBF, 0xD5, 0xDA, 0xC3,
    0xD5, 0xDC, 0xC0, 0xD3, 0xDA, 0xC3, 0xD9, 0xDF, 0xC3, 0xD5, 0xDC, 0xC1, 0xD3, 0xDA, 0xC3, 0xD5, 0xDC, 0xC3, 0xD5, 0xDC, 0xC1, 0xD7, 0xDC, 0xC2, 0xD5, 0xD8, 0xB9, 0xCD, 0xCE, 0xBE, 0xD2, 0xD3, 0xB3, 0xC3, 0xC9, 0xAD, 0xC3, 0xC8, 0x9D, 0xB5,
    0xB5, 0xA0, 0xB4, 0xB5, 0xA4, 0xB1, 0xB3, 0xA0, 0xB5, 0xB3, 0xA7, 0xBC, 0xBA, 0xA9, 0xBE, 0xBC, 0x00, 0x00, 0xC7, 0xD0, 0xD4, 0xC7, 0xD0, 0xD4, 0xC7, 0xD0, 0xD4, 0xCC, 0xD4, 0xD4, 0xCC, 0xD4, 0xD4, 0xCC, 0xD4, 0xD4, 0xD0, 0xD5, 0xD6, 0xD0,
    0xD5, 0xD6, 0xD1, 0xD6, 0xD7, 0xD4, 0xD9, 0xDA, 0xCF, 0xD7, 0xD7, 0xCE, 0xD6, 0xD6, 0xCE, 0xD6, 0xD6, 0xCF, 0xD7, 0xD7, 0xCF, 0xD7, 0xD7, 0xCF, 0xD7, 0xD7, 0xCF, 0xD6, 0xD9, 0xCF, 0xD6, 0xD9, 0xD1, 0xD8, 0xDB, 0xD1, 0xD4, 0xD8, 0xD1, 0xD4,
    0xD8, 0xD6, 0xD9, 0xDD, 0xDA, 0xE7, 0xDF, 0x42, 0x51, 0x49, 0x42, 0x55, 0x4C, 0x1D, 0x32, 0x29, 0x29, 0x3B, 0x3C, 0x63, 0x73, 0x80, 0xC9, 0xD0, 0xE1, 0xD4, 0xDA, 0xDF, 0xD2, 0xD8, 0xDD, 0xD2, 0xD8, 0xDD, 0xCC, 0xD8, 0xD8, 0xCC, 0xD8, 0xD8,
    0xCD, 0xD9, 0xD9, 0xCE, 0xDA, 0xDA, 0xCE, 0xDA, 0xDA, 0xCE, 0xDA, 0xDA, 0xCC, 0xD7, 0xDB, 0xCC, 0xD7, 0xDB, 0xCB, 0xD6, 0xDA, 0xCB, 0xD6, 0xDA, 0xC9, 0xD5, 0xD7, 0xCC, 0xD8, 0xDA, 0xCC, 0xD8, 0xDA, 0xCE, 0xD7, 0xDB, 0xCC, 0xD5, 0xD9, 0xCC,
    0xD5, 0xD9, 0xCA, 0xD8, 0xD7, 0xCA, 0xD8, 0xD7, 0xC8, 0xD8, 0xD7, 0xC6, 0xD6, 0xDC, 0xC9, 0xD9, 0xDF, 0xC8, 0xD8, 0xDE, 0xC6, 0xDA, 0xDF, 0xC4, 0xD8, 0xDD, 0xC8, 0xDC, 0xE1, 0xC2, 0xD6, 0xDB, 0xA3, 0xB7, 0xB8, 0x8B, 0xA5, 0xAB, 0x88, 0x9F,
    0xA9, 0x96, 0xB3, 0xBA, 0xC5, 0xD1, 0xD5, 0xC3, 0xD8, 0xD6, 0xCB, 0xD7, 0xDD, 0xC9, 0xD7, 0xDD, 0xC5, 0xD8, 0xDD, 0xC8, 0xD6, 0xDC, 0xC0, 0xCE, 0xD4, 0xAE, 0xBC, 0xC2, 0x00, 0x00, 0xDE, 0xE2, 0xE7, 0xD4, 0xD8, 0xDD, 0xD4, 0xD8, 0xDD, 0xDB,
    0xE7, 0xED, 0xD3, 0xDF, 0xE5, 0xD4, 0xE0, 0xE6, 0xE6, 0xEC, 0xF3, 0xE2, 0xE8, 0xEF, 0xDC, 0xE2, 0xE9, 0xDB, 0xE1, 0xE8, 0xD1, 0xDD, 0xE3, 0xD7, 0xE3, 0xE9, 0xD4, 0xE0, 0xE6, 0xD6, 0xE2, 0xE8, 0xE4, 0xF0, 0xF6, 0xD4, 0xE0, 0xE6, 0xCF, 0xDD,
    0xDB, 0xD6, 0xE4, 0xE2, 0xDB, 0xE9, 0xE7, 0xD4, 0xE3, 0xE5, 0xDA, 0xE9, 0xEB, 0xD7, 0xE6, 0xE8, 0xE2, 0xE4, 0xEE, 0xE1, 0xE6, 0xEF, 0x71, 0x7A, 0x83, 0x1F, 0x2A, 0x32, 0x63, 0x77, 0x82, 0xC9, 0xE0, 0xEA, 0xDF, 0xF1, 0xF0, 0xD6, 0xE2, 0xE6,
    0xDB, 0xE7, 0xEB, 0xDA, 0xE6, 0xEA, 0xD4, 0xE4, 0xEA, 0xDE, 0xEE, 0xF4, 0xD4, 0xE4, 0xEA, 0xA8, 0xB7, 0xC0, 0xBE, 0xCD, 0xD6, 0xC2, 0xD1, 0xDA, 0xD5, 0xEA, 0xEC, 0xD9, 0xEE, 0xF0, 0xDB, 0xF0, 0xF2, 0xDB, 0xF0, 0xF2, 0xD8, 0xED, 0xEE, 0xDD,
    0xF2, 0xF3, 0xDD, 0xF2, 0xF3, 0xD4, 0xE9, 0xEB, 0xD6, 0xEB, 0xED, 0xD9, 0xEE, 0xF0, 0xD7, 0xEB, 0xF0, 0xDF, 0xEF, 0xF5, 0xE1, 0xEB, 0xF2, 0xEA, 0xF3, 0xF6, 0xDE, 0xF0, 0xF1, 0xD9, 0xF3, 0xF3, 0xD7, 0xEF, 0xEF, 0xD9, 0xF1, 0xF1, 0xC5, 0xDD,
    0xDD, 0xDB, 0xF3, 0xF3, 0xCE, 0xF0, 0xEF, 0xCE, 0xED, 0xEA, 0xE8, 0xE8, 0xE8, 0xDB, 0xE7, 0xE9, 0xC5, 0xDE, 0xE2, 0xD7, 0xE7, 0xED, 0xD7, 0xEB, 0xE6, 0xDC, 0xEB, 0xE7, 0xD2, 0xDB, 0xD8, 0xC1, 0xCF, 0xCE, 0xCF, 0xDD, 0xDC, 0xD8, 0xE6, 0xE5,
    0x00, 0x00, 0x36, 0x47, 0x44, 0x3A, 0x54, 0x5A, 0x30, 0x47, 0x3F, 0x34, 0x44, 0x51, 0x32, 0x48, 0x43, 0x34, 0x51, 0x48, 0x3F, 0x51, 0x50, 0x3A, 0x50, 0x55, 0x43, 0x5B, 0x61, 0x3C, 0x51, 0x53, 0x40, 0x60, 0x65, 0x43, 0x60, 0x64, 0x43, 0x52,
    0x54, 0x43, 0x58, 0x5A, 0x37, 0x53, 0x5A, 0x45, 0x5A, 0x5C, 0x48, 0x61, 0x63, 0x45, 0x65, 0x64, 0x35, 0x4C, 0x48, 0x39, 0x51, 0x49, 0x26, 0x57, 0x3B, 0x19, 0x38, 0x23, 0x18, 0x37, 0x22, 0x5B, 0x64, 0x68, 0x19, 0x1C, 0x1A, 0x18, 0x20, 0x1F,
    0x04, 0x15, 0x11, 0x28, 0x51, 0x49, 0x18, 0x26, 0x22, 0x59, 0x69, 0x62, 0x6C, 0x75, 0x6B, 0x40, 0x4E, 0x4D, 0x45, 0x4A, 0x48, 0x41, 0x57, 0x3F, 0x65, 0x6C, 0x69, 0x1C, 0x23, 0x1E, 0x31, 0x33, 0x3E, 0x3C, 0x4F, 0x52, 0x41, 0x44, 0x48, 0x35,
    0x3E, 0x29, 0x2C, 0x2E, 0x22, 0x49, 0x49, 0x3D, 0x3D, 0x3C, 0x2E, 0x31, 0x2F, 0x25, 0x27, 0x2C, 0x35, 0x3A, 0x53, 0x45, 0x26, 0x39, 0x24, 0x47, 0x5B, 0x48, 0x34, 0x3A, 0x39, 0xB6, 0xBC, 0xC7, 0x52, 0x60, 0x54, 0x47, 0x51, 0x40, 0x40, 0x56,
    0x43, 0x31, 0x44, 0x31, 0x5C, 0x5A, 0x5A, 0x3E, 0x4C, 0x41, 0x4D, 0x63, 0x50, 0x64, 0x73, 0x65, 0x40, 0x6A, 0x58, 0x25, 0x54, 0x3E, 0x5D, 0x6E, 0x63, 0x39, 0x51, 0x4F, 0x81, 0x8B, 0x8B, 0x72, 0x76, 0x77, 0x2B, 0x45, 0x38, 0x3B, 0x4F, 0x42,
    0x79, 0x84, 0x8C, 0x5A, 0x6A, 0x71, 0x37, 0x58, 0x53, 0x3A, 0x54, 0x4E, 0x00, 0x00, 0x3A, 0x4B, 0x3D, 0x2E, 0x48, 0x48, 0x41, 0x59, 0x59, 0x44, 0x57, 0x5C, 0x49, 0x6E, 0x6C, 0x69, 0x90, 0x8E, 0x35, 0x41, 0x43, 0x67, 0x77, 0x7D, 0x36, 0x4C,
    0x47, 0x36, 0x4A, 0x3D, 0x2A, 0x3B, 0x32, 0x2E, 0x42, 0x35, 0x23, 0x2D, 0x20, 0x28, 0x31, 0x27, 0x3D, 0x46, 0x43, 0x35, 0x3E, 0x34, 0x07, 0x23, 0x16, 0x2C, 0x46, 0x38, 0x1D, 0x40, 0x2C, 0x2A, 0x4A, 0x2B, 0x10, 0x27, 0x19, 0x2C, 0x45, 0x3B,
    0x12, 0x30, 0x17, 0x32, 0x42, 0x41, 0x10, 0x1A, 0x14, 0x26, 0x2D, 0x2A, 0x25, 0x22, 0x1D, 0x16, 0x12, 0x0D, 0x0C, 0x0E, 0x08, 0x35, 0x4A, 0x41, 0x35, 0x47, 0x40, 0x42, 0x53, 0x50, 0x4E, 0x5C, 0x56, 0x43, 0x58, 0x49, 0x1C, 0x33, 0x2B, 0x0F,
    0x2D, 0x20, 0x34, 0x4B, 0x46, 0x2D, 0x49, 0x32, 0x31, 0x43, 0x42, 0x2A, 0x50, 0x34, 0x20, 0x3F, 0x2A, 0x0A, 0x1A, 0x08, 0x17, 0x30, 0x14, 0x18, 0x2B, 0x18, 0x10, 0x23, 0x1A, 0x27, 0x3E, 0x2F, 0x27, 0x4A, 0x36, 0x3A, 0x4A, 0x3F, 0x19, 0x2F,
    0x1C, 0x21, 0x37, 0x24, 0x2D, 0x42, 0x3F, 0x7B, 0x7D, 0x87, 0x78, 0x7D, 0x86, 0x60, 0x65, 0x6E, 0x50, 0x54, 0x4F, 0x4E, 0x53, 0x4A, 0x3B, 0x39, 0x39, 0x86, 0x7D, 0x87, 0x4B, 0x50, 0x51, 0x29, 0x38, 0x2A, 0x23, 0x43, 0x30, 0x19, 0x3C, 0x28,
    0x3F, 0x57, 0x45, 0x22, 0x3A, 0x28, 0x26, 0x40, 0x2E, 0x1B, 0x36, 0x26, 0x2D, 0x53, 0x47, 0x27, 0x5C, 0x4E, 0x27, 0x43, 0x2C, 0x18, 0x31, 0x1B, 0x00, 0x00, 0x53, 0x5D, 0x50, 0x01, 0x1C, 0x19, 0x1A, 0x38, 0x32, 0x14, 0x31, 0x22, 0x37, 0x55,
    0x50, 0x18, 0x39, 0x35, 0x18, 0x2F, 0x20, 0x08, 0x1F, 0x17, 0x34, 0x3C, 0x3B, 0x07, 0x07, 0x01, 0x22, 0x25, 0x23, 0x24, 0x2E, 0x27, 0x1D, 0x22, 0x19, 0x12, 0x23, 0x15, 0x0B, 0x13, 0x0C, 0x05, 0x16, 0x08, 0x25, 0x43, 0x38, 0x1A, 0x56, 0x44,
    0x1B, 0x49, 0x36, 0x22, 0x3E, 0x38, 0x05, 0x30, 0x15, 0x09, 0x30, 0x17, 0x23, 0x40, 0x26, 0x12, 0x27, 0x24, 0x05, 0x15, 0x0A, 0x21, 0x28, 0x21, 0x14, 0x37, 0x29, 0x3A, 0x71, 0x60, 0x08, 0x37, 0x27, 0x33, 0x6F, 0x5D, 0x36, 0x5B, 0x57, 0x61,
    0x72, 0x6E, 0x49, 0x5E, 0x55, 0x08, 0x10, 0x09, 0x10, 0x12, 0x0C, 0x31, 0x36, 0x35, 0x2B, 0x39, 0x3F, 0x38, 0x4C, 0x45, 0x50, 0x67, 0x62, 0x3F, 0x5B, 0x3D, 0x15, 0x2A, 0x14, 0x0B, 0x20, 0x0A, 0x2A, 0x4B, 0x30, 0x14, 0x25, 0x17, 0x32, 0x3C,
    0x2F, 0x22, 0x3E, 0x2B, 0x37, 0x58, 0x49, 0x36, 0x47, 0x43, 0x2E, 0x4E, 0x3D, 0x2B, 0x3C, 0x2E, 0x14, 0x39, 0x31, 0x32, 0x47, 0x45, 0x79, 0x85, 0x85, 0x3A, 0x48, 0x47, 0x29, 0x33, 0x2D, 0x3B, 0x44, 0x3A, 0x12, 0x21, 0x19, 0x52, 0x67, 0x65,
    0x24, 0x3D, 0x33, 0x22, 0x45, 0x30, 0x26, 0x47, 0x32, 0x19, 0x32, 0x18, 0x2C, 0x3F, 0x26, 0x2B, 0x40, 0x27, 0x1F, 0x3E, 0x23, 0x35, 0x50, 0x3C, 0x36, 0x5B, 0x41, 0x1E, 0x49, 0x34, 0x43, 0x59, 0x3D, 0x22, 0x3C, 0x1E, 0x00, 0x00, 0x32, 0x43,
    0x3A, 0x24, 0x5D, 0x4E, 0x09, 0x0B, 0x05, 0x1D, 0x1E, 0x14, 0x17, 0x30, 0x22, 0x0B, 0x2A, 0x1B, 0x0A, 0x21, 0x13, 0x1A, 0x31, 0x23, 0x04, 0x1D, 0x0F, 0x06, 0x20, 0x12, 0x08, 0x2C, 0x1E, 0x1C, 0x3B, 0x38, 0x16, 0x2A, 0x1E, 0x00, 0x1A, 0x02,
    0x07, 0x10, 0x03, 0x0A, 0x20, 0x14, 0x0F, 0x37, 0x1B, 0x22, 0x4B, 0x2B, 0x0E, 0x3C, 0x12, 0x0D, 0x39, 0x1A, 0x15, 0x28, 0x19, 0x03, 0x08, 0x06, 0x00, 0x15, 0x07, 0x04, 0x2C, 0x1A, 0x18, 0x31, 0x1D, 0x00, 0x21, 0x09, 0x17, 0x3A, 0x2C, 0x21,
    0x55, 0x43, 0x16, 0x40, 0x2E, 0x0F, 0x2A, 0x16, 0x31, 0x52, 0x44, 0x0C, 0x1A, 0x14, 0x4E, 0x57, 0x5A, 0x1B, 0x1F, 0x1A, 0x27, 0x3A, 0x29, 0x13, 0x3A, 0x2A, 0x22, 0x4B, 0x43, 0x1B, 0x59, 0x43, 0x54, 0x6E, 0x60, 0x24, 0x3A, 0x27, 0x12, 0x35,
    0x13, 0x12, 0x41, 0x1A, 0x2E, 0x47, 0x39, 0x1D, 0x4C, 0x3C, 0x1E, 0x4C, 0x40, 0x0F, 0x45, 0x34, 0x2B, 0x54, 0x45, 0x1D, 0x3E, 0x30, 0x0F, 0x2A, 0x1A, 0x23, 0x58, 0x44, 0x27, 0x5A, 0x46, 0x3E, 0x5A, 0x46, 0x24, 0x38, 0x25, 0x26, 0x42, 0x2E,
    0x09, 0x28, 0x13, 0x2A, 0x49, 0x34, 0x2A, 0x49, 0x34, 0x1F, 0x3E, 0x29, 0x36, 0x50, 0x3E, 0x2A, 0x42, 0x2A, 0x31, 0x49, 0x2B, 0x39, 0x55, 0x42, 0x1B, 0x37, 0x1A, 0x20, 0x3B, 0x19, 0x41, 0x57, 0x3B, 0x2C, 0x45, 0x29, 0x30, 0x4F, 0x32, 0x29,
    0x41, 0x29, 0x26, 0x3E, 0x26, 0x36, 0x4E, 0x36, 0x00, 0x00, 0x05, 0x47, 0x34, 0x05, 0x3F, 0x2D, 0x0B, 0x1B, 0x10, 0x0D, 0x19, 0x0D, 0x09, 0x1D, 0x10, 0x1A, 0x2C, 0x1F, 0x17, 0x3B, 0x2B, 0x06, 0x25, 0x16, 0x15, 0x27, 0x1A, 0x0B, 0x17, 0x0B,
    0x25, 0x43, 0x30, 0x09, 0x2A, 0x1C, 0x34, 0x4F, 0x3F, 0x00, 0x16, 0x03, 0x11, 0x13, 0x07, 0x18, 0x21, 0x17, 0x17, 0x4D, 0x2F, 0x14, 0x4A, 0x2D, 0x02, 0x15, 0x02, 0x11, 0x30, 0x15, 0x16, 0x1F, 0x12, 0x09, 0x08, 0x04, 0x05, 0x09, 0x04, 0x01,
    0x10, 0x08, 0x14, 0x25, 0x18, 0x16, 0x31, 0x21, 0x1D, 0x30, 0x1F, 0x00, 0x18, 0x06, 0x08, 0x13, 0x03, 0x18, 0x2F, 0x20, 0x2B, 0x4E, 0x40, 0x1F, 0x41, 0x36, 0x2E, 0x59, 0x50, 0x2B, 0x4E, 0x40, 0x2B, 0x4E, 0x39, 0x1D, 0x3A, 0x2A, 0x19, 0x38,
    0x2F, 0x10, 0x3D, 0x28, 0x2D, 0x4F, 0x44, 0x0E, 0x2B, 0x1C, 0x2A, 0x46, 0x2F, 0x1B, 0x3C, 0x21, 0x0D, 0x23, 0x0B, 0x1C, 0x3F, 0x25, 0x18, 0x3B, 0x21, 0x1F, 0x3F, 0x2E, 0x2E, 0x56, 0x44, 0x45, 0x73, 0x60, 0x26, 0x49, 0x34, 0x2C, 0x5A, 0x43,
    0x10, 0x36, 0x20, 0x19, 0x32, 0x1C, 0x12, 0x23, 0x0E, 0x19, 0x35, 0x1E, 0x15, 0x2C, 0x16, 0x34, 0x4B, 0x35, 0x20, 0x37, 0x21, 0x28, 0x3F, 0x29, 0x1A, 0x38, 0x1F, 0x2C, 0x49, 0x2F, 0x18, 0x32, 0x14, 0x1F, 0x37, 0x1F, 0x18, 0x35, 0x1B, 0x19,
    0x38, 0x1D, 0x31, 0x45, 0x20, 0x30, 0x41, 0x1C, 0x37, 0x3E, 0x1B, 0x2D, 0x3A, 0x1A, 0x3E, 0x4B, 0x2B, 0x38, 0x45, 0x25, 0x00, 0x00, 0x0F, 0x42, 0x2E, 0x07, 0x14, 0x06, 0x0C, 0x2C, 0x1B, 0x12, 0x33, 0x1E, 0x0E, 0x22, 0x0F, 0x1F, 0x32, 0x1F,
    0x1A, 0x30, 0x1D, 0x1B, 0x34, 0x20, 0x09, 0x25, 0x11, 0x15, 0x31, 0x1D, 0x04, 0x18, 0x0B, 0x0D, 0x28, 0x14, 0x0C, 0x1E, 0x11, 0x00, 0x07, 0x01, 0x02, 0x0D, 0x03, 0x0A, 0x18, 0x0C, 0x14, 0x1B, 0x0E, 0x13, 0x1B, 0x10, 0x08, 0x16, 0x0B, 0x12,
    0x22, 0x11, 0x1C, 0x20, 0x15, 0x04, 0x04, 0x00, 0x05, 0x0B, 0x06, 0x16, 0x18, 0x12, 0x12, 0x24, 0x17, 0x1D, 0x2C, 0x1E, 0x37, 0x4D, 0x35, 0x18, 0x28, 0x17, 0x07, 0x0E, 0x05, 0x06, 0x19, 0x10, 0x0B, 0x1D, 0x10, 0x0F, 0x3D, 0x2A, 0x06, 0x2D,
    0x14, 0x1E, 0x45, 0x2C, 0x20, 0x3C, 0x25, 0x11, 0x38, 0x22, 0x36, 0x63, 0x53, 0x25, 0x4F, 0x36, 0x2D, 0x4E, 0x3F, 0x1F, 0x44, 0x34, 0x1B, 0x3C, 0x2D, 0x24, 0x3E, 0x30, 0x12, 0x36, 0x28, 0x21, 0x3B, 0x29, 0x12, 0x2F, 0x16, 0x26, 0x3A, 0x23,
    0x1D, 0x3B, 0x22, 0x21, 0x44, 0x2A, 0x12, 0x30, 0x13, 0x14, 0x2D, 0x11, 0x2D, 0x3E, 0x23, 0x31, 0x44, 0x2B, 0x21, 0x2B, 0x14, 0x2B, 0x3E, 0x25, 0x15, 0x2D, 0x0D, 0x2F, 0x47, 0x27, 0x37, 0x4F, 0x2F, 0x2E, 0x46, 0x26, 0x27, 0x35, 0x13, 0x2F,
    0x37, 0x18, 0x2C, 0x31, 0x16, 0x31, 0x3D, 0x19, 0x3D, 0x43, 0x20, 0x33, 0x37, 0x14, 0x67, 0x62, 0x41, 0x47, 0x46, 0x24, 0x39, 0x40, 0x1D, 0x3C, 0x41, 0x21, 0x3E, 0x43, 0x23, 0x40, 0x45, 0x25, 0x00, 0x00, 0x1B, 0x4E, 0x38, 0x01, 0x13, 0x02,
    0x14, 0x30, 0x1D, 0x16, 0x3D, 0x27, 0x1F, 0x38, 0x24, 0x12, 0x2E, 0x1A, 0x16, 0x3C, 0x26, 0x19, 0x38, 0x23, 0x17, 0x2B, 0x18, 0x1D, 0x2D, 0x1B, 0x07, 0x1B, 0x16, 0x28, 0x3B, 0x2A, 0x05, 0x09, 0x04, 0x0A, 0x0C, 0x0C, 0x0B, 0x21, 0x15, 0x20,
    0x3D, 0x2D, 0x09, 0x1D, 0x11, 0x18, 0x18, 0x0C, 0x15, 0x39, 0x21, 0x14, 0x25, 0x18, 0x14, 0x1A, 0x0F, 0x1C, 0x24, 0x19, 0x0A, 0x29, 0x1A, 0x11, 0x22, 0x14, 0x1B, 0x3A, 0x25, 0x19, 0x2A, 0x15, 0x1F, 0x24, 0x15, 0x0C, 0x0C, 0x06, 0x0D, 0x0F,
    0x10, 0x21, 0x35, 0x2E, 0x10, 0x14, 0x08, 0x00, 0x25, 0x0F, 0x0A, 0x29, 0x0C, 0x03, 0x2C, 0x10, 0x00, 0x21, 0x09, 0x1E, 0x3A, 0x23, 0x39, 0x5D, 0x4D, 0x23, 0x3B, 0x23, 0x2B, 0x44, 0x30, 0x2E, 0x51, 0x3C, 0x38, 0x62, 0x50, 0x03, 0x27, 0x17,
    0x1E, 0x3D, 0x26, 0x25, 0x33, 0x17, 0x34, 0x43, 0x1D, 0x1E, 0x40, 0x22, 0x27, 0x3D, 0x21, 0x2D, 0x3A, 0x20, 0x24, 0x36, 0x17, 0x1E, 0x2E, 0x0F, 0x1C, 0x2E, 0x0F, 0x25, 0x34, 0x19, 0x35, 0x3B, 0x22, 0x25, 0x36, 0x1B, 0x38, 0x3A, 0x1C, 0x39,
    0x3B, 0x1D, 0x6B, 0x6D, 0x4F, 0x85, 0x87, 0x69, 0xA3, 0x9D, 0x78, 0xA6, 0x9B, 0x7D, 0xA2, 0x92, 0x7B, 0xAB, 0x8F, 0x70, 0xA5, 0x7A, 0x53, 0xAA, 0x78, 0x4A, 0x9D, 0x74, 0x43, 0x9C, 0x6E, 0x3E, 0xA5, 0x71, 0x42, 0xA2, 0x79, 0x4C, 0xA5, 0x7C,
    0x4F, 0xA2, 0x79, 0x4C, 0x00, 0x00, 0x19, 0x36, 0x26, 0x1F, 0x3A, 0x2A, 0x29, 0x40, 0x31, 0x00, 0x12, 0x05, 0x10, 0x1E, 0x12, 0x1F, 0x36, 0x28, 0x0D, 0x2E, 0x20, 0x13, 0x24, 0x19, 0x25, 0x3F, 0x32, 0x0F, 0x1D, 0x12, 0x05, 0x15, 0x0A, 0x13,
    0x24, 0x19, 0x10, 0x24, 0x18, 0x07, 0x15, 0x0A, 0x20, 0x35, 0x26, 0x00, 0x13, 0x02, 0x18, 0x32, 0x20, 0x1D, 0x42, 0x28, 0x1A, 0x2C, 0x1F, 0x00, 0x10, 0x03, 0x02, 0x0C, 0x05, 0x11, 0x23, 0x12, 0x0A, 0x0C, 0x06, 0x0E, 0x15, 0x0E, 0x18, 0x2D,
    0x24, 0x17, 0x1E, 0x17, 0x08, 0x12, 0x06, 0x0F, 0x1C, 0x0E, 0x0C, 0x1C, 0x0B, 0x08, 0x19, 0x0B, 0x1D, 0x2C, 0x1E, 0x03, 0x1A, 0x0B, 0x26, 0x42, 0x2F, 0x0A, 0x1D, 0x0A, 0x14, 0x32, 0x19, 0x0E, 0x2D, 0x16, 0x2E, 0x4D, 0x38, 0x10, 0x25, 0x16,
    0x1B, 0x19, 0x0F, 0x2B, 0x3E, 0x2D, 0x2C, 0x46, 0x28, 0x20, 0x39, 0x17, 0x20, 0x3C, 0x25, 0x29, 0x40, 0x24, 0x2A, 0x3D, 0x1C, 0x2E, 0x3D, 0x22, 0x2C, 0x39, 0x1F, 0x37, 0x44, 0x2A, 0x71, 0x69, 0x4B, 0xAC, 0x9A, 0x7D, 0xAD, 0x8E, 0x74, 0xA9,
    0x87, 0x6A, 0xAD, 0x87, 0x67, 0xAE, 0x88, 0x66, 0xB1, 0x89, 0x66, 0xA9, 0x81, 0x5E, 0xA7, 0x7F, 0x5C, 0xA4, 0x7C, 0x59, 0xA7, 0x82, 0x5C, 0xA6, 0x81, 0x5B, 0x9D, 0x78, 0x52, 0x9E, 0x76, 0x46, 0x9D, 0x75, 0x45, 0x9D, 0x75, 0x45, 0x9F, 0x76,
    0x45, 0x9F, 0x76, 0x45, 0xA3, 0x7A, 0x49, 0xA3, 0x7C, 0x4F, 0xA5, 0x7E, 0x51, 0xA5, 0x7E, 0x51, 0x00, 0x00, 0x0F, 0x31, 0x20, 0x11, 0x31, 0x20, 0x14, 0x2F, 0x1F, 0x04, 0x12, 0x06, 0x02, 0x10, 0x04, 0x07, 0x20, 0x12, 0x11, 0x33, 0x28, 0x0B,
    0x18, 0x10, 0x13, 0x26, 0x1D, 0x08, 0x17, 0x0F, 0x0C, 0x1E, 0x11, 0x1E, 0x37, 0x29, 0x1F, 0x3C, 0x2D, 0x0D, 0x20, 0x0F, 0x17, 0x2F, 0x1D, 0x26, 0x3D, 0x2E, 0x0A, 0x25, 0x11, 0x19, 0x3D, 0x25, 0x01, 0x02, 0x00, 0x15, 0x1C, 0x17, 0x08, 0x0D,
    0x0B, 0x1C, 0x2B, 0x1D, 0x1C, 0x35, 0x21, 0x1D, 0x3E, 0x29, 0x1D, 0x36, 0x22, 0x25, 0x38, 0x25, 0x11, 0x24, 0x11, 0x1B, 0x2B, 0x1A, 0x0F, 0x1C, 0x0E, 0x1D, 0x2E, 0x21, 0x00, 0x0E, 0x02, 0x09, 0x20, 0x12, 0x24, 0x37, 0x24, 0x12, 0x27, 0x0E,
    0x1F, 0x3B, 0x17, 0x2B, 0x3A, 0x1B, 0x12, 0x28, 0x0B, 0x0D, 0x36, 0x1A, 0x24, 0x26, 0x13, 0x29, 0x36, 0x1C, 0x6F, 0x57, 0x33, 0x92, 0x7C, 0x52, 0x3A, 0x38, 0x10, 0x61, 0x5D, 0x34, 0x6E, 0x68, 0x3D, 0x7A, 0x6A, 0x3F, 0x9D, 0x7A, 0x52, 0xA8,
    0x7B, 0x55, 0xA3, 0x7F, 0x5B, 0xA6, 0x82, 0x5E, 0xA8, 0x88, 0x64, 0xAB, 0x88, 0x66, 0xA8, 0x83, 0x5D, 0xAB, 0x84, 0x5D, 0xAB, 0x85, 0x5B, 0xA9, 0x83, 0x59, 0xA8, 0x82, 0x58, 0xA7, 0x81, 0x57, 0xAC, 0x7E, 0x4E, 0xA5, 0x77, 0x47, 0xA0, 0x72,
    0x42, 0x9D, 0x72, 0x41, 0x9C, 0x71, 0x40, 0x9C, 0x71, 0x40, 0x9C, 0x73, 0x42, 0x9C, 0x73, 0x42, 0x9F, 0x76, 0x45, 0xA3, 0x7A, 0x4D, 0x9F, 0x76, 0x49, 0xA0, 0x77, 0x4A, 0x00, 0x00, 0x10, 0x23, 0x14, 0x00, 0x11, 0x03, 0x0E, 0x1B, 0x0D, 0x09,
    0x26, 0x17, 0x1E, 0x2F, 0x22, 0x1E, 0x30, 0x23, 0x1B, 0x41, 0x2D, 0x0F, 0x19, 0x09, 0x04, 0x16, 0x05, 0x0B, 0x1E, 0x0D, 0x12, 0x28, 0x16, 0x08, 0x1A, 0x09, 0x16, 0x21, 0x11, 0x16, 0x2F, 0x15, 0x13, 0x2F, 0x1B, 0x11, 0x2B, 0x1B, 0x1A, 0x38,
    0x25, 0x15, 0x31, 0x14, 0x07, 0x23, 0x06, 0x11, 0x26, 0x17, 0x0D, 0x10, 0x0E, 0x0C, 0x0D, 0x0B, 0x00, 0x13, 0x03, 0x18, 0x2B, 0x1C, 0x11, 0x1B, 0x0E, 0x0B, 0x38, 0x25, 0x15, 0x1F, 0x13, 0x1E, 0x36, 0x1E, 0x15, 0x3B, 0x17, 0x11, 0x13, 0x0D,
    0x0E, 0x0E, 0x08, 0x06, 0x0E, 0x07, 0x12, 0x33, 0x10, 0x49, 0x46, 0x20, 0x93, 0x67, 0x38, 0x9A, 0x6B, 0x37, 0xA0, 0x68, 0x37, 0x84, 0x64, 0x33, 0x9A, 0x74, 0x44, 0xAA, 0x74, 0x45, 0x9C, 0x7B, 0x49, 0xAB, 0x80, 0x4D, 0xA0, 0x7C, 0x52, 0xA2,
    0x7F, 0x57, 0xA0, 0x7F, 0x58, 0x9E, 0x7D, 0x50, 0xA0, 0x7B, 0x4F, 0x9F, 0x77, 0x4C, 0xAC, 0x78, 0x4F, 0xA3, 0x75, 0x4B, 0x9D, 0x78, 0x4C, 0xA2, 0x77, 0x50, 0xA6, 0x78, 0x4E, 0xA7, 0x78, 0x4C, 0xAA, 0x76, 0x48, 0xA7, 0x73, 0x45, 0xA3, 0x6F,
    0x41, 0xA2, 0x6E, 0x40, 0x9F, 0x71, 0x41, 0x9E, 0x70, 0x40, 0x9F, 0x71, 0x41, 0xA1, 0x75, 0x40, 0xA1, 0x75, 0x40, 0xA1, 0x75, 0x40, 0x9C, 0x73, 0x42, 0x9C, 0x73, 0x42, 0x9A, 0x71, 0x40, 0x9E, 0x71, 0x45, 0xA2, 0x75, 0x49, 0xA3, 0x76, 0x4A,
    0x00, 0x00, 0x61, 0x5F, 0x47, 0x18, 0x1F, 0x16, 0x13, 0x25, 0x18, 0x15, 0x36, 0x28, 0x01, 0x1C, 0x08, 0x1A, 0x35, 0x2B, 0x65, 0x5D, 0x35, 0x4E, 0x43, 0x25, 0x38, 0x37, 0x22, 0x14, 0x1F, 0x05, 0x58, 0x5E, 0x3F, 0x13, 0x25, 0x18, 0x23, 0x39,
    0x26, 0x28, 0x3D, 0x2E, 0x07, 0x11, 0x04, 0x00, 0x08, 0x00, 0x14, 0x34, 0x23, 0x15, 0x2B, 0x18, 0x0D, 0x30, 0x16, 0x06, 0x13, 0x05, 0x21, 0x2E, 0x20, 0x15, 0x22, 0x14, 0x05, 0x1E, 0x08, 0x0B, 0x19, 0x0D, 0x16, 0x1E, 0x17, 0x00, 0x0C, 0x00,
    0x11, 0x19, 0x12, 0x0C, 0x16, 0x09, 0x02, 0x11, 0x00, 0x04, 0x05, 0x01, 0x16, 0x1D, 0x14, 0x17, 0x21, 0x15, 0x18, 0x2B, 0x12, 0xA3, 0x7B, 0x51, 0x9F, 0x7E, 0x4D, 0xA5, 0x7B, 0x4C, 0xA6, 0x7C, 0x4F, 0xA9, 0x7E, 0x55, 0xA8, 0x83, 0x57, 0xAB,
    0x85, 0x5B, 0xB0, 0x8F, 0x68, 0xB1, 0x8F, 0x6B, 0xB4, 0x95, 0x74, 0xB3, 0x94, 0x73, 0xAF, 0x90, 0x6F, 0xAE, 0x8E, 0x6A, 0xAE, 0x8E, 0x6A, 0xB1, 0x91, 0x6D, 0xB3, 0x8E, 0x68, 0xAF, 0x8A, 0x64, 0xB0, 0x8B, 0x65, 0xAC, 0x87, 0x61, 0xAA, 0x83,
    0x5C, 0xAD, 0x83, 0x58, 0xA6, 0x80, 0x56, 0xA8, 0x80, 0x55, 0xA8, 0x7E, 0x4F, 0xA9, 0x7E, 0x4D, 0xA7, 0x7D, 0x50, 0xA7, 0x7D, 0x50, 0xA8, 0x7E, 0x51, 0xA6, 0x7E, 0x54, 0xA8, 0x80, 0x56, 0xA9, 0x81, 0x57, 0xA3, 0x7F, 0x51, 0xA1, 0x7A, 0x4D,
    0xA4, 0x7A, 0x4D, 0x9F, 0x77, 0x47, 0xA0, 0x78, 0x48, 0xA1, 0x79, 0x49, 0x00, 0x00, 0x86, 0x5E, 0x2D, 0x2D, 0x27, 0x02, 0x22, 0x31, 0x23, 0x4F, 0x4F, 0x2B, 0x61, 0x55, 0x2B, 0x68, 0x61, 0x40, 0x8E, 0x63, 0x3A, 0x8E, 0x67, 0x33, 0x45, 0x3C,
    0x17, 0x3E, 0x48, 0x3B, 0x2E, 0x34, 0x1B, 0x1A, 0x39, 0x36, 0x11, 0x11, 0x11, 0x16, 0x22, 0x16, 0x16, 0x20, 0x14, 0x20, 0x26, 0x1B, 0x06, 0x18, 0x0B, 0x1C, 0x25, 0x18, 0x0A, 0x1E, 0x0B, 0x13, 0x2C, 0x16, 0x25, 0x3E, 0x28, 0x0F, 0x28, 0x12,
    0x15, 0x26, 0x18, 0x0B, 0x1C, 0x0E, 0x1E, 0x29, 0x1F, 0x10, 0x16, 0x11, 0x0A, 0x0E, 0x08, 0x0A, 0x17, 0x09, 0x1A, 0x31, 0x1B, 0x16, 0x23, 0x15, 0x0F, 0x22, 0x0F, 0x1B, 0x30, 0x1A, 0x1D, 0x39, 0x1C, 0xA3, 0x8A, 0x6F, 0xA6, 0x8E, 0x70, 0xB2,
    0x92, 0x7F, 0xB3, 0x9D, 0x8B, 0xB2, 0xA2, 0x92, 0xB7, 0xA8, 0x98, 0xC5, 0xB5, 0xA8, 0xC4, 0xBA, 0xB0, 0xC4, 0xB9, 0xB1, 0xC4, 0xB6, 0xAA, 0xC1, 0xB3, 0xA7, 0xBF, 0xB1, 0xA5, 0xC0, 0xB0, 0xA9, 0xC5, 0xB5, 0xAE, 0xC0, 0xB0, 0xA9, 0xBE, 0xAB,
    0x9C, 0xBB, 0xA8, 0x99, 0xBC, 0xA9, 0x9A, 0xBE, 0xA8, 0x96, 0xBB, 0xA3, 0x8F, 0xB9, 0x9F, 0x87, 0xB5, 0x99, 0x81, 0xB4, 0x96, 0x7D, 0xAD, 0x8D, 0x70, 0xAB, 0x89, 0x6B, 0xA9, 0x86, 0x64, 0xAD, 0x8A, 0x68, 0xAF, 0x8C, 0x6A, 0xAC, 0x90, 0x6D,
    0xB1, 0x95, 0x72, 0xAF, 0x93, 0x70, 0xAB, 0x8C, 0x65, 0xA7, 0x86, 0x5F, 0xA6, 0x81, 0x5B, 0xA9, 0x82, 0x55, 0xA3, 0x7C, 0x4F, 0xA4, 0x7D, 0x50, 0x00, 0x00, 0x9D, 0x65, 0x3B, 0x89, 0x66, 0x3A, 0x67, 0x5B, 0x37, 0x86, 0x5E, 0x34, 0x91, 0x63,
    0x33, 0x93, 0x67, 0x3E, 0x96, 0x68, 0x3F, 0x9D, 0x69, 0x3B, 0x90, 0x77, 0x4F, 0x21, 0x23, 0x05, 0x37, 0x39, 0x15, 0x12, 0x2B, 0x21, 0x26, 0x32, 0x2C, 0x1B, 0x2A, 0x22, 0x27, 0x3A, 0x31, 0x08, 0x10, 0x09, 0x07, 0x14, 0x0C, 0x13, 0x17, 0x0C,
    0x17, 0x26, 0x18, 0x15, 0x28, 0x19, 0x02, 0x15, 0x06, 0x15, 0x28, 0x19, 0x14, 0x1F, 0x15, 0x14, 0x27, 0x16, 0x12, 0x20, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x08, 0x1B, 0x2A, 0x1C, 0x18, 0x34, 0x1D, 0x0D, 0x21, 0x0E, 0x1D, 0x35, 0x1D, 0x25,
    0x42, 0x28, 0x34, 0x3D, 0x22, 0xC3, 0xA5, 0x94, 0xBC, 0xAC, 0x9B, 0xC8, 0xB8, 0xAB, 0xCB, 0xBC, 0xB3, 0xC8, 0xB8, 0xB1, 0xCC, 0xBD, 0xAD, 0xCE, 0xC1, 0xB3, 0xC5, 0xBB, 0xB1, 0xC5, 0xBB, 0xB3, 0xCA, 0xBC, 0xB0, 0xD0, 0xC2, 0xB6, 0xCD, 0xBF,
    0xB3, 0xCC, 0xC2, 0xBA, 0xD1, 0xC7, 0xBF, 0xC6, 0xBC, 0xB4, 0xCA, 0xBB, 0xB2, 0xC7, 0xB8, 0xAF, 0xC7, 0xB8, 0xAF, 0xC7, 0xB4, 0xA5, 0xC1, 0xAA, 0x9A, 0xB8, 0xA0, 0x8C, 0xBD, 0xA7, 0x9B, 0xBD, 0xA6, 0x97, 0xC2, 0xA8, 0x97, 0xBD, 0xA2, 0x8E,
    0xBA, 0x9B, 0x81, 0xB5, 0x96, 0x7C, 0xB1, 0x92, 0x78, 0xAE, 0x91, 0x72, 0xAC, 0x8F, 0x70, 0xB0, 0x93, 0x74, 0xAF, 0x95, 0x71, 0xAC, 0x8E, 0x6B, 0xB1, 0x8E, 0x6C, 0xAE, 0x8E, 0x6B, 0xAE, 0x8E, 0x6B, 0xAE, 0x8E, 0x6B, 0x00, 0x00, 0x92, 0x66,
    0x3D, 0x94, 0x68, 0x3F, 0x92, 0x66, 0x3D, 0x96, 0x67, 0x3B, 0x99, 0x6A, 0x3E, 0x9C, 0x6D, 0x41, 0x9A, 0x70, 0x43, 0x9C, 0x72, 0x45, 0x9E, 0x74, 0x47, 0x9E, 0x74, 0x47, 0x9A, 0x72, 0x42, 0x5A, 0x40, 0x1B, 0x0E, 0x16, 0x0F, 0x28, 0x2F, 0x1A,
    0x0E, 0x24, 0x18, 0x08, 0x1C, 0x0F, 0x11, 0x22, 0x0D, 0x0C, 0x14, 0x09, 0x18, 0x25, 0x17, 0x17, 0x30, 0x1C, 0x0D, 0x23, 0x10, 0x17, 0x29, 0x18, 0x0F, 0x13, 0x07, 0x1B, 0x29, 0x1D, 0x17, 0x1C, 0x13, 0x16, 0x27, 0x1C, 0x15, 0x23, 0x18, 0x20,
    0x35, 0x26, 0x0C, 0x36, 0x1D, 0x1A, 0x37, 0x1E, 0x4C, 0x60, 0x49, 0x9D, 0x9C, 0x88, 0xC3, 0xB5, 0xA2, 0xC3, 0xB5, 0xA3, 0xCB, 0xBA, 0xAD, 0xBA, 0xB0, 0xA6, 0xCC, 0xC2, 0xB8, 0xCD, 0xC3, 0xB9, 0xC3, 0xB9, 0xAF, 0xCE, 0xC4, 0xBA, 0xD5, 0xCB,
    0xC1, 0xD9, 0xCF, 0xC5, 0xD8, 0xCD, 0xC5, 0xD8, 0xCD, 0xC5, 0xDA, 0xCF, 0xC7, 0xD8, 0xD6, 0xCC, 0xE2, 0xDB, 0xD2, 0xD8, 0xCD, 0xC5, 0xCF, 0xC2, 0xB9, 0xC9, 0xBC, 0xB3, 0xC0, 0xB3, 0xAA, 0xC2, 0xB1, 0xA4, 0xBF, 0xAA, 0x9B, 0xBB, 0xA5, 0x93,
    0xBF, 0xA4, 0x90, 0xBD, 0xA2, 0x8E, 0xBD, 0xA2, 0x8E, 0xC5, 0xAA, 0x96, 0xBC, 0xA1, 0x8C, 0xB8, 0x9D, 0x88, 0xB4, 0x99, 0x84, 0xB8, 0x9C, 0x83, 0xBF, 0xA3, 0x8A, 0xB7, 0x9B, 0x82, 0xB5, 0x98, 0x7D, 0xB2, 0x95, 0x7A, 0xB3, 0x96, 0x7B, 0xB2,
    0x94, 0x83, 0xBA, 0x9E, 0x8D, 0xB9, 0xA1, 0x8F, 0x00, 0x00, 0x93, 0x67, 0x3E, 0x90, 0x64, 0x3B, 0x96, 0x6A, 0x41, 0x9D, 0x6F, 0x45, 0x9F, 0x71, 0x47, 0xA2, 0x74, 0x4A, 0xA0, 0x76, 0x4B, 0xA2, 0x78, 0x4D, 0xA3, 0x79, 0x4E, 0x9E, 0x74, 0x49,
    0xA0, 0x76, 0x49, 0xA3, 0x7C, 0x4F, 0x5D, 0x44, 0x22, 0x68, 0x55, 0x28, 0x19, 0x23, 0x13, 0x58, 0x60, 0x49, 0x3F, 0x4B, 0x2F, 0x08, 0x27, 0x12, 0x28, 0x3F, 0x29, 0x19, 0x1C, 0x0C, 0x1C, 0x2F, 0x1E, 0x15, 0x2F, 0x17, 0x25, 0x38, 0x23, 0x1A,
    0x2E, 0x1B, 0x0C, 0x19, 0x0B, 0x22, 0x30, 0x24, 0x1F, 0x2B, 0x1F, 0x1E, 0x24, 0x19, 0x10, 0x14, 0x08, 0x3C, 0x4B, 0x35, 0x9F, 0xA1, 0x8D, 0xBF, 0xAD, 0x9C, 0xC0, 0xAC, 0x9B, 0xC2, 0xAF, 0xA0, 0xCC, 0xBA, 0xAF, 0xD2, 0xCB, 0xC2, 0xDC, 0xD5,
    0xCC, 0xDA, 0xD3, 0xCA, 0xE2, 0xDB, 0xD2, 0xD9, 0xD2, 0xC9, 0xDB, 0xD4, 0xCB, 0xDA, 0xD3, 0xCA, 0xD5, 0xCE, 0xC5, 0xD7, 0xD0, 0xC7, 0xDE, 0xD7, 0xCE, 0xDA, 0xD8, 0xCE, 0xDA, 0xD3, 0xCA, 0xD5, 0xCA, 0xC2, 0xCB, 0xBE, 0xB5, 0xC9, 0xBC, 0xB3,
    0xBF, 0xB2, 0xA9, 0xCD, 0xBC, 0xB1, 0xC7, 0xB6, 0xA9, 0xC5, 0xB1, 0xA0, 0xC7, 0xA8, 0x91, 0xC5, 0xA6, 0x8F, 0xC2, 0xA3, 0x8C, 0xC5, 0xA6, 0x8F, 0xC1, 0xA1, 0x8E, 0xBF, 0x9F, 0x8C, 0xC0, 0xA0, 0x8D, 0xBD, 0xA2, 0x8D, 0xC2, 0xA7, 0x92, 0xBF,
    0xA4, 0x8F, 0xB9, 0x9F, 0x87, 0xB7, 0x9D, 0x85, 0xB9, 0x9F, 0x87, 0xB9, 0x9F, 0x8F, 0xC5, 0xAE, 0x9E, 0xCC, 0xB8, 0xA7, 0x00, 0x00, 0xA3, 0x77, 0x4E, 0xA0, 0x74, 0x4B, 0xA2, 0x76, 0x4D, 0xA4, 0x79, 0x52, 0xA7, 0x7C, 0x55, 0xA8, 0x7D, 0x56,
    0xA8, 0x81, 0x5A, 0xA8, 0x81, 0x5A, 0xA6, 0x7F, 0x58, 0xA5, 0x7E, 0x57, 0xA6, 0x7B, 0x50, 0xA4, 0x76, 0x4C, 0xAA, 0x79, 0x4D, 0xA7, 0x78, 0x52, 0x76, 0x5C, 0x3E, 0x9F, 0x7D, 0x5F, 0x82, 0x69, 0x47, 0x5D, 0x59, 0x3C, 0x67, 0x5D, 0x3F, 0x24,
    0x2A, 0x0B, 0x12, 0x13, 0x09, 0x2E, 0x37, 0x2A, 0x58, 0x62, 0x4B, 0x2F, 0x28, 0x14, 0xB4, 0xB0, 0x98, 0xBC, 0xA7, 0x92, 0x44, 0x46, 0x29, 0x1B, 0x2E, 0x13, 0x03, 0x1C, 0x06, 0xC6, 0xC0, 0xAD, 0xC7, 0xAE, 0x9E, 0xC6, 0xB2, 0xA1, 0xBB, 0xAA,
    0x9D, 0xCF, 0xC3, 0xB7, 0xD1, 0xCF, 0xC5, 0xDC, 0xD8, 0xD3, 0xDC, 0xD8, 0xD3, 0xDF, 0xDB, 0xD6, 0xDD, 0xD9, 0xD4, 0xDE, 0xDA, 0xD5, 0xE0, 0xDC, 0xD7, 0xE0, 0xDC, 0xD7, 0xDD, 0xDB, 0xD1, 0xDB, 0xD9, 0xCF, 0xD1, 0xCF, 0xC5, 0xD6, 0xD4, 0xCA,
    0xDB, 0xD4, 0xCB, 0xD2, 0xC7, 0xBF, 0xD5, 0xC8, 0xBF, 0xD3, 0xC6, 0xBD, 0xD6, 0xC9, 0xC0, 0xD2, 0xC5, 0xBD, 0xD5, 0xC6, 0xBD, 0xD0, 0xBF, 0xB2, 0xC6, 0xAF, 0xA0, 0xC1, 0xAA, 0x9B, 0xC3, 0xAC, 0x9D, 0xCD, 0xB6, 0xA7, 0xC9, 0xB2, 0xA2, 0xC1,
    0xAA, 0x9A, 0xC4, 0xAD, 0x9D, 0xC6, 0xAE, 0x9C, 0xC5, 0xAD, 0x9B, 0xC8, 0xB0, 0x9E, 0xC0, 0xAC, 0x9B, 0xC6, 0xB2, 0xA1, 0xC8, 0xB4, 0xA3, 0xC8, 0xB5, 0xA8, 0xC2, 0xB2, 0xA5, 0xBE, 0xB1, 0xA3, 0x00, 0x00, 0xA9, 0x85, 0x61, 0xA7, 0x83, 0x5F,
    0xA8, 0x84, 0x60, 0xA9, 0x7E, 0x57, 0xA5, 0x7E, 0x58, 0xA3, 0x7D, 0x5B, 0xA9, 0x88, 0x67, 0xAC, 0x89, 0x67, 0xAA, 0x85, 0x5F, 0xA7, 0x80, 0x59, 0xA7, 0x7D, 0x52, 0xA8, 0x7E, 0x53, 0xA7, 0x7D, 0x52, 0xAA, 0x7C, 0x52, 0xAD, 0x85, 0x62, 0xAC,
    0x88, 0x6A, 0xAC, 0x8F, 0x74, 0xAE, 0x92, 0x79, 0xAF, 0x97, 0x81, 0xB6, 0x9E, 0x8C, 0x96, 0x82, 0x71, 0xBC, 0xA9, 0x9C, 0xC3, 0xAA, 0x9A, 0xBC, 0xA3, 0x93, 0xBA, 0xA1, 0x91, 0xBA, 0xA1, 0x91, 0xBE, 0xA5, 0x95, 0xBC, 0xA3, 0x93, 0xC5, 0xAC,
    0x9C, 0xC5, 0xAE, 0xA6, 0xD0, 0xC1, 0xB8, 0xCE, 0xC4, 0xBA, 0xD1, 0xC4, 0xBC, 0xDA, 0xCF, 0xC7, 0xD8, 0xD1, 0xC8, 0xD7, 0xD4, 0xCF, 0xDE, 0xDB, 0xD6, 0xE0, 0xDD, 0xD8, 0xE4, 0xDB, 0xD7, 0xE4, 0xDB, 0xD7, 0xE3, 0xDA, 0xD6, 0xE6, 0xDD, 0xD9,
    0xDF, 0xD8, 0xCF, 0xDD, 0xD6, 0xCD, 0xDB, 0xD4, 0xCB, 0xD9, 0xD2, 0xC9, 0xDA, 0xD3, 0xCA, 0xDC, 0xD5, 0xCC, 0xD7, 0xD0, 0xC7, 0xD5, 0xCB, 0xC3, 0xD4, 0xC7, 0xBF, 0xD4, 0xC7, 0xBE, 0xD5, 0xC8, 0xBF, 0xCD, 0xC0, 0xB7, 0xCF, 0xBD, 0xAC, 0xC4,
    0xB2, 0xA1, 0xC6, 0xB4, 0xA3, 0xD9, 0xC7, 0xB6, 0xCB, 0xBE, 0xB5, 0xC7, 0xBA, 0xB1, 0xC2, 0xB5, 0xAC, 0xC7, 0xB5, 0xA4, 0xC2, 0xB0, 0x9F, 0xC0, 0xAE, 0x9D, 0xC2, 0xAF, 0x9A, 0xC5, 0xB3, 0xA2, 0xC5, 0xB5, 0xA8, 0xCE, 0xC1, 0xB8, 0xCD, 0xC0,
    0xB7, 0xC4, 0xB7, 0xAE, 0x00, 0x00, 0xA9, 0x82, 0x5C, 0xA7, 0x80, 0x5A, 0xA4, 0x7D, 0x57, 0xA6, 0x7B, 0x54, 0xA8, 0x81, 0x5B, 0xA5, 0x7F, 0x5D, 0xA9, 0x88, 0x67, 0xAD, 0x8A, 0x68, 0xAD, 0x88, 0x62, 0xAF, 0x88, 0x61, 0xAA, 0x83, 0x5C, 0xAC,
    0x85, 0x5E, 0xAB, 0x84, 0x5D, 0xB0, 0x85, 0x5E, 0xB5, 0x8F, 0x6F, 0xAF, 0x8D, 0x70, 0xAE, 0x91, 0x76, 0xB0, 0x94, 0x7B, 0xB7, 0x9F, 0x89, 0xBA, 0xA0, 0x88, 0xBA, 0xA2, 0x8C, 0xB5, 0x9F, 0x8D, 0xB3, 0x9A, 0x86, 0xB8, 0x9F, 0x8B, 0xBC, 0xA3,
    0x8F, 0xC5, 0xAC, 0x98, 0xB6, 0xA3, 0x96, 0xC3, 0xB0, 0xA3, 0xD2, 0xBF, 0xB2, 0xCB, 0xBA, 0xB1, 0xCD, 0xBC, 0xB3, 0xD4, 0xC5, 0xBC, 0xD4, 0xC7, 0xBF, 0xD7, 0xCC, 0xC4, 0xDA, 0xD3, 0xCA, 0xDD, 0xDA, 0xD5, 0xE4, 0xE1, 0xDC, 0xE4, 0xE1, 0xDC,
    0xE2, 0xD6, 0xD0, 0xD1, 0xC5, 0xBF, 0xDA, 0xCE, 0xC8, 0xD8, 0xCC, 0xC6, 0xD9, 0xD2, 0xC9, 0xDF, 0xD8, 0xCF, 0xDD, 0xD6, 0xCD, 0xDE, 0xD7, 0xCE, 0xDD, 0xD6, 0xCD, 0xE5, 0xDE, 0xD5, 0xE1, 0xDC, 0xD3, 0xDF, 0xD8, 0xCF, 0xD6, 0xCB, 0xC3, 0xD7,
    0xCA, 0xC1, 0xD2, 0xC5, 0xBC, 0xCB, 0xBE, 0xB5, 0xCF, 0xBF, 0xB2, 0xCA, 0xBA, 0xAD, 0xC7, 0xB7, 0xAA, 0xCF, 0xBF, 0xB2, 0xD5, 0xC8, 0xBF, 0xD4, 0xC7, 0xBE, 0xCF, 0xC2, 0xB9, 0xD0, 0xC0, 0xB3, 0xCD, 0xBD, 0xB0, 0xCB, 0xBB, 0xAE, 0xC9, 0xB7,
    0xA6, 0xC7, 0xB7, 0xA7, 0xCB, 0xBD, 0xB1, 0xCB, 0xBE, 0xB5, 0xD2, 0xC5, 0xBC, 0xD5, 0xC8, 0xBF, 0x00, 0x00, 0xA3, 0x7B, 0x51, 0xA3, 0x7B, 0x51, 0xA5, 0x7D, 0x53, 0xA9, 0x7E, 0x57, 0xA7, 0x80, 0x5A, 0xAA, 0x84, 0x62, 0xA9, 0x88, 0x67, 0xB0,
    0x8D, 0x6B, 0xAF, 0x8A, 0x64, 0xAD, 0x86, 0x5F, 0xB3, 0x8E, 0x68, 0xB5, 0x90, 0x6A, 0xA9, 0x84, 0x5E, 0xB3, 0x89, 0x64, 0xB6, 0x92, 0x74, 0xB5, 0x96, 0x7D, 0xB4, 0x97, 0x7C, 0xB7, 0x9B, 0x82, 0xBA, 0xA2, 0x8C, 0xC0, 0xA8, 0x96, 0xC8, 0xB4,
    0xA3, 0xCF, 0xBC, 0xAF, 0xCE, 0xBC, 0xAB, 0xD9, 0xC7, 0xB6, 0xD5, 0xC3, 0xB2, 0xD6, 0xC4, 0xB3, 0xD4, 0xC6, 0xBA, 0xC6, 0xB8, 0xAC, 0xC3, 0xB5, 0xA9, 0xC2, 0xB5, 0xAC, 0xD1, 0xC0, 0xB7, 0xCC, 0xB9, 0xB1, 0xD2, 0xC5, 0xBD, 0xDC, 0xD1, 0xC9,
    0xE0, 0xD9, 0xD0, 0xDC, 0xD9, 0xD4, 0xE2, 0xDF, 0xDA, 0xE5, 0xE2, 0xDD, 0xCD, 0xBA, 0xB2, 0xC9, 0xB6, 0xAE, 0xCE, 0xBB, 0xB3, 0xD9, 0xC6, 0xBE, 0xD9, 0xD2, 0xC9, 0xDF, 0xD8, 0xCF, 0xDD, 0xD6, 0xCD, 0xE1, 0xDA, 0xD1, 0xE3, 0xDC, 0xD3, 0xE1,
    0xDA, 0xD1, 0xD8, 0xD7, 0xCD, 0xDD, 0xDB, 0xD1, 0xDC, 0xD5, 0xCC, 0xDD, 0xD0, 0xC7, 0xD6, 0xC9, 0xC0, 0xD5, 0xC8, 0xBF, 0xD4, 0xC6, 0xBA, 0xD0, 0xC2, 0xB6, 0xCB, 0xBD, 0xB1, 0xD0, 0xC2, 0xB6, 0xDB, 0xCE, 0xC5, 0xD4, 0xC7, 0xBE, 0xD2, 0xC5,
    0xBC, 0xD3, 0xC5, 0xB9, 0xD1, 0xC3, 0xB7, 0xCD, 0xBF, 0xB3, 0xD2, 0xC3, 0xB3, 0xCF, 0xC1, 0xB5, 0xCA, 0xBF, 0xB7, 0xD2, 0xC5, 0xBC, 0xD5, 0xC8, 0xBF, 0xCE, 0xC1, 0xB8, 0x00, 0x00, 0xA8, 0x7D, 0x56, 0xA3, 0x78, 0x51, 0xA8, 0x7D, 0x56, 0xA8,
    0x80, 0x5D, 0xA9, 0x83, 0x61, 0xA9, 0x85, 0x67, 0xB1, 0x8B, 0x69, 0xAF, 0x89, 0x67, 0xA9, 0x83, 0x61, 0xB2, 0x8C, 0x6A, 0xB8, 0x94, 0x70, 0xB3, 0x8E, 0x68, 0xAD, 0x86, 0x5F, 0xB0, 0x8D, 0x6C, 0xB8, 0x96, 0x7E, 0xB7, 0x96, 0x82, 0xBC, 0x9A,
    0x7D, 0xBB, 0x99, 0x7B, 0xBC, 0xA3, 0x93, 0xCB, 0xB6, 0xAE, 0xCB, 0xB9, 0xB2, 0xD1, 0xC1, 0xBB, 0xD0, 0xC4, 0xC0, 0xDA, 0xCF, 0xCB, 0xDD, 0xD7, 0xD2, 0xCE, 0xCA, 0xC5, 0xDE, 0xD1, 0xC9, 0xD9, 0xCF, 0xC7, 0xDA, 0xD8, 0xCE, 0xDE, 0xD3, 0xCB,
    0xCD, 0xBD, 0xB6, 0xC7, 0xB5, 0xAE, 0xD3, 0xC7, 0xC3, 0xE1, 0xD6, 0xD2, 0xE3, 0xDD, 0xD8, 0xEB, 0xE8, 0xE4, 0xDD, 0xDE, 0xDA, 0xE2, 0xE6, 0xE1, 0xE5, 0xEC, 0xE5, 0xE7, 0xEB, 0xE5, 0xDC, 0xDC, 0xD6, 0xDE, 0xDB, 0xD6, 0xE3, 0xDD, 0xD8, 0xE2,
    0xDC, 0xD7, 0xDD, 0xD7, 0xD2, 0xE0, 0xD9, 0xD0, 0xE3, 0xDC, 0xD3, 0xE1, 0xDA, 0xD1, 0xE4, 0xD9, 0xD1, 0xD8, 0xCD, 0xC5, 0xE1, 0xD6, 0xCE, 0xE3, 0xD8, 0xD0, 0xDA, 0xCF, 0xC7, 0xD8, 0xCD, 0xC5, 0xD4, 0xC9, 0xC1, 0xD2, 0xC7, 0xBF, 0xDB, 0xCB,
    0xC4, 0xD5, 0xC3, 0xBC, 0xD9, 0xCF, 0xC5, 0xD8, 0xCE, 0xC4, 0xCD, 0xC3, 0xB9, 0xCB, 0xC2, 0xB8, 0xD4, 0xCB, 0xC1, 0xDD, 0xD4, 0xCA, 0xD2, 0xC5, 0xBC, 0xD9, 0xCC, 0xC3, 0xDE, 0xD1, 0xC8, 0xDF, 0xD1, 0xC5, 0xD4, 0xCA, 0xBE, 0xD6, 0xCE, 0xC1,
    0x00, 0x00, 0xAC, 0x81, 0x5A, 0xA8, 0x7D, 0x56, 0xAC, 0x81, 0x5A, 0xAB, 0x83, 0x60, 0xAB, 0x85, 0x63, 0xAB, 0x87, 0x69, 0xB3, 0x8D, 0x6D, 0xAB, 0x85, 0x65, 0xAC, 0x86, 0x66, 0xBC, 0x96, 0x76, 0xA6, 0x82, 0x5E, 0xAE, 0x8A, 0x66, 0xAE, 0x8A,
    0x66, 0xB4, 0x91, 0x70, 0xB6, 0x94, 0x7C, 0xB5, 0x94, 0x80, 0xB7, 0x95, 0x78, 0xBA, 0x98, 0x7A, 0xBE, 0xA5, 0x95, 0xC9, 0xB8, 0xAD, 0xCE, 0xC1, 0xB8, 0xD3, 0xC7, 0xC1, 0xD9, 0xD1, 0xCA, 0xDA, 0xD2, 0xCB, 0xDB, 0xD9, 0xD1, 0xDC, 0xDA, 0xD2,
    0xCE, 0xC1, 0xB9, 0xDA, 0xD0, 0xC8, 0xDE, 0xD7, 0xCE, 0xD9, 0xCF, 0xC7, 0xE2, 0xD5, 0xCD, 0xE2, 0xD2, 0xCB, 0xE4, 0xD9, 0xD5, 0xE7, 0xDE, 0xDA, 0xF3, 0xEF, 0xEA, 0xE0, 0xDD, 0xD9, 0xE0, 0xE1, 0xDD, 0xEC, 0xF0, 0xEB, 0xE3, 0xEA, 0xE3, 0xEB,
    0xEF, 0xE9, 0xDB, 0xDB, 0xD5, 0xD9, 0xD6, 0xD1, 0xE1, 0xDD, 0xD8, 0xE2, 0xDE, 0xD9, 0xDD, 0xD9, 0xD4, 0xE0, 0xD9, 0xD0, 0xE1, 0xDA, 0xD1, 0xDE, 0xD7, 0xCE, 0xDA, 0xD0, 0xC8, 0xDD, 0xD3, 0xCB, 0xE2, 0xD8, 0xD0, 0xE1, 0xD7, 0xCF, 0xE3, 0xD9,
    0xD1, 0xE0, 0xD6, 0xCE, 0xDE, 0xD4, 0xCC, 0xDD, 0xD2, 0xCA, 0xDA, 0xCA, 0xC3, 0xDB, 0xCB, 0xC4, 0xD8, 0xCE, 0xC4, 0xD7, 0xCD, 0xC3, 0xD3, 0xC9, 0xBF, 0xCD, 0xC3, 0xB9, 0xCF, 0xC5, 0xBB, 0xD8, 0xCE, 0xC4, 0xE2, 0xD5, 0xCC, 0xDA, 0xCD, 0xC4,
    0xD9, 0xCC, 0xC3, 0xDC, 0xCF, 0xC6, 0xD9, 0xD0, 0xC6, 0xDC, 0xD5, 0xCB, 0x00, 0x00, 0xAE, 0x83, 0x5C, 0xAA, 0x7F, 0x58, 0xAF, 0x84, 0x5D, 0xAE, 0x86, 0x63, 0xAF, 0x89, 0x67, 0xAF, 0x8B, 0x6D, 0xB2, 0x90, 0x73, 0xAF, 0x8D, 0x70, 0xAB, 0x89,
    0x6C, 0xAA, 0x88, 0x6B, 0xB0, 0x8C, 0x68, 0xAA, 0x8B, 0x6C, 0xBB, 0x9F, 0x86, 0xB3, 0x90, 0x6F, 0xB1, 0x8F, 0x77, 0xBC, 0x9B, 0x87, 0xB7, 0x95, 0x78, 0xB9, 0x97, 0x79, 0xBD, 0xA4, 0x94, 0xC2, 0xAF, 0xA0, 0xC3, 0xB3, 0xA6, 0xD1, 0xC2, 0xB9,
    0xE1, 0xD0, 0xC7, 0xDE, 0xCF, 0xC6, 0xD6, 0xCC, 0xC2, 0xE7, 0xDE, 0xD4, 0xE0, 0xD9, 0xD0, 0xE3, 0xD8, 0xD0, 0xDA, 0xCD, 0xC5, 0xE1, 0xDC, 0xD3, 0xE6, 0xDC, 0xD4, 0xDA, 0xCF, 0xC7, 0xE6, 0xE0, 0xDB, 0xDB, 0xD7, 0xD2, 0xE7, 0xE7, 0xE1, 0xE8,
    0xE5, 0xE1, 0xF7, 0xF8, 0xF4, 0xF0, 0xF4, 0xEF, 0xEC, 0xF3, 0xEC, 0xE9, 0xED, 0xE7, 0xE3, 0xE3, 0xDD, 0xE5, 0xE2, 0xDD, 0xE4, 0xE4, 0xDE, 0xE4, 0xE4, 0xDE, 0xDA, 0xDA, 0xD4, 0xE0, 0xD9, 0xD0, 0xE1, 0xDA, 0xD1, 0xDE, 0xD7, 0xCE, 0xDC, 0xD7,
    0xCE, 0xDE, 0xD9, 0xD0, 0xE0, 0xDB, 0xD2, 0xE3, 0xDE, 0xD5, 0xE2, 0xDD, 0xD4, 0xDE, 0xD9, 0xD0, 0xD7, 0xD2, 0xC9, 0xDC, 0xD7, 0xCE, 0xD5, 0xCA, 0xC2, 0xD7, 0xCC, 0xC4, 0xD7, 0xCD, 0xC3, 0xDA, 0xD0, 0xC6, 0xD5, 0xCB, 0xC1, 0xCF, 0xC0, 0xB7,
    0xCF, 0xC0, 0xB7, 0xD5, 0xC6, 0xBD, 0xDB, 0xCE, 0xC5, 0xDF, 0xD2, 0xC9, 0xDE, 0xD1, 0xC8, 0xDC, 0xD2, 0xCB, 0xDD, 0xD7, 0xD0, 0xE1, 0xDE, 0xD6, 0x00, 0x00, 0xA6, 0x7B, 0x54, 0xA8, 0x7D, 0x56, 0xB1, 0x86, 0x5F, 0xB3, 0x8B, 0x68, 0xB3, 0x8D,
    0x6B, 0xB2, 0x8E, 0x70, 0xAF, 0x8E, 0x74, 0xB2, 0x91, 0x77, 0xB3, 0x92, 0x78, 0xB4, 0x93, 0x79, 0xB4, 0x90, 0x6C, 0xAC, 0x8E, 0x71, 0xAE, 0x95, 0x81, 0xB4, 0x91, 0x70, 0xBA, 0x98, 0x80, 0xBA, 0x99, 0x85, 0xB2, 0x90, 0x73, 0xB2, 0x90, 0x72,
    0xB0, 0x97, 0x87, 0xC1, 0xA7, 0x97, 0xAF, 0x98, 0x89, 0xC5, 0xAE, 0xA4, 0xCF, 0xB6, 0xAC, 0xCA, 0xB3, 0xA9, 0xC9, 0xB7, 0xAC, 0xD2, 0xC0, 0xB5, 0xDB, 0xD4, 0xCB, 0xE4, 0xD9, 0xD1, 0xDD, 0xCB, 0xC4, 0xD8, 0xD6, 0xCC, 0xDD, 0xD6, 0xCD, 0xE3,
    0xD9, 0xD1, 0xE3, 0xDF, 0xDA, 0xE8, 0xE5, 0xE0, 0xDE, 0xE0, 0xDA, 0xE9, 0xE6, 0xE2, 0xF2, 0xF3, 0xEF, 0xF8, 0xFC, 0xF7, 0xF2, 0xF9, 0xF2, 0xE5, 0xE9, 0xE3, 0xE8, 0xE8, 0xE2, 0xEA, 0xE7, 0xE2, 0xE4, 0xE6, 0xE0, 0xE8, 0xEA, 0xE4, 0xDF, 0xE1,
    0xDB, 0xE4, 0xDD, 0xD4, 0xE3, 0xDC, 0xD3, 0xE1, 0xDA, 0xD1, 0xDE, 0xDC, 0xD2, 0xE0, 0xDE, 0xD4, 0xE2, 0xE0, 0xD6, 0xE3, 0xE1, 0xD7, 0xDE, 0xDC, 0xD2, 0xE0, 0xDE, 0xD4, 0xDF, 0xDD, 0xD3, 0xF0, 0xEB, 0xE2, 0xE3, 0xD9, 0xD1, 0xE0, 0xD5, 0xCD,
    0xDC, 0xD2, 0xC8, 0xDD, 0xD3, 0xC9, 0xD8, 0xCE, 0xC4, 0xDB, 0xCA, 0xC1, 0xD6, 0xC5, 0xBC, 0xD7, 0xC6, 0xBD, 0xD6, 0xC9, 0xC0, 0xDB, 0xCE, 0xC5, 0xE1, 0xD4, 0xCB, 0xE0, 0xD7, 0xD3, 0xE1, 0xDD, 0xD8, 0xE6, 0xE3, 0xDE, 0x00, 0x00, 0xA8, 0x87,
    0x6D, 0xA9, 0x85, 0x67, 0xAF, 0x87, 0x64, 0xB2, 0x8C, 0x6C, 0xB5, 0x91, 0x73, 0xB8, 0x97, 0x7D, 0xB3, 0x90, 0x76, 0xB0, 0x8D, 0x73, 0xB0, 0x8D, 0x73, 0xB1, 0x8E, 0x74, 0xAF, 0x91, 0x78, 0xB3, 0x95, 0x7C, 0xAE, 0x90, 0x77, 0xAF, 0x8E, 0x74,
    0xB1, 0x8D, 0x6F, 0xB3, 0x8D, 0x6D, 0xB1, 0x8D, 0x69, 0xB4, 0x8A, 0x65, 0xB4, 0x8C, 0x62, 0xBC, 0x8B, 0x5B, 0xB9, 0x88, 0x58, 0xB9, 0x88, 0x58, 0xAA, 0x7C, 0x5A, 0xC8, 0xAD, 0xA2, 0xCA, 0xB2, 0xA0, 0xD1, 0xBF, 0xB4, 0xDE, 0xD1, 0xC9, 0xE8,
    0xDE, 0xD6, 0xE8, 0xE1, 0xD8, 0xE0, 0xD9, 0xCF, 0xDB, 0xCE, 0xC5, 0xE0, 0xD9, 0xCF, 0xE3, 0xDB, 0xD4, 0xE3, 0xDD, 0xD6, 0xE3, 0xE1, 0xD9, 0xE4, 0xE4, 0xDE, 0xEE, 0xEE, 0xE8, 0xF0, 0xF0, 0xEA, 0xE6, 0xEF, 0xE5, 0xEA, 0xEA, 0xE2, 0xF0, 0xE7,
    0xE4, 0xEC, 0xE3, 0xE0, 0xEE, 0xF0, 0xEA, 0xE2, 0xE9, 0xE2, 0xE3, 0xDF, 0xDA, 0xDE, 0xDA, 0xD5, 0xE2, 0xDE, 0xD9, 0xE0, 0xDC, 0xD7, 0xE3, 0xE0, 0xDB, 0xE5, 0xE2, 0xDD, 0xE3, 0xE0, 0xDB, 0xE5, 0xE7, 0xE1, 0xE3, 0xE3, 0xDD, 0xE4, 0xE0, 0xDB,
    0xDC, 0xD3, 0xCF, 0xF6, 0xF3, 0xEE, 0xE8, 0xE5, 0xE0, 0xE3, 0xDA, 0xD6, 0xE2, 0xDB, 0xD2, 0xE1, 0xDA, 0xD1, 0xE0, 0xD9, 0xD0, 0xE2, 0xD9, 0xCF, 0xDD, 0xD4, 0xCA, 0xDD, 0xD4, 0xCA, 0xDD, 0xD6, 0xCD, 0xE1, 0xDA, 0xD1, 0xE5, 0xDE, 0xD5, 0xE5,
    0xDE, 0xD5, 0xE2, 0xDD, 0xD4, 0xE7, 0xE6, 0xDC, 0x00, 0x00, 0xA4, 0x87, 0x72, 0xA9, 0x88, 0x6E, 0xAD, 0x83, 0x5E, 0xB2, 0x8C, 0x6A, 0xB7, 0x93, 0x75, 0xB7, 0x95, 0x78, 0xB2, 0x95, 0x76, 0xA8, 0x8B, 0x6C, 0xA9, 0x8C, 0x6D, 0xA7, 0x8A, 0x6B,
    0xAF, 0x89, 0x69, 0xB1, 0x8B, 0x6B, 0xB3, 0x8D, 0x6D, 0xAD, 0x87, 0x64, 0xB0, 0x87, 0x60, 0xB0, 0x84, 0x5B, 0xAD, 0x81, 0x58, 0xB1, 0x86, 0x5B, 0xB3, 0x82, 0x54, 0xB4, 0x81, 0x4F, 0xB4, 0x81, 0x4F, 0xB1, 0x7E, 0x4C, 0xB6, 0x7D, 0x49, 0xD0,
    0xB1, 0x9C, 0xD0, 0xBC, 0xAB, 0xCF, 0xBE, 0xB3, 0xDD, 0xD0, 0xC8, 0xE2, 0xD8, 0xD0, 0xE8, 0xE1, 0xD8, 0xE0, 0xD7, 0xCD, 0xD6, 0xC7, 0xBE, 0xD7, 0xCE, 0xC4, 0xDF, 0xD4, 0xCC, 0xD7, 0xCD, 0xC5, 0xDE, 0xD9, 0xD0, 0xE4, 0xE1, 0xDC, 0xEB, 0xE8,
    0xE3, 0xE8, 0xE5, 0xE0, 0xE9, 0xEC, 0xE3, 0xE7, 0xEE, 0xE7, 0xDD, 0xE4, 0xDD, 0xE0, 0xE7, 0xE0, 0xE7, 0xE7, 0xE1, 0xDC, 0xDE, 0xD8, 0xE3, 0xDD, 0xD8, 0xE0, 0xDC, 0xD7, 0xE7, 0xE3, 0xDE, 0xE1, 0xDD, 0xD8, 0xE4, 0xE1, 0xDC, 0xE5, 0xE2, 0xDD,
    0xE6, 0xE3, 0xDE, 0xED, 0xEF, 0xE9, 0xEB, 0xEB, 0xE5, 0xE6, 0xE2, 0xDD, 0xE2, 0xD3, 0xD0, 0xD9, 0xD0, 0xCC, 0xD4, 0xCB, 0xC7, 0xE1, 0xD2, 0xCF, 0xE1, 0xDA, 0xD1, 0xDF, 0xD8, 0xCF, 0xDF, 0xD8, 0xCF, 0xDC, 0xD7, 0xCE, 0xDB, 0xD6, 0xCD, 0xE0,
    0xDB, 0xD2, 0xDE, 0xDD, 0xD3, 0xE1, 0xE0, 0xD6, 0xE2, 0xE1, 0xD7, 0xE7, 0xE0, 0xD7, 0xE3, 0xDE, 0xD5, 0xDD, 0xDC, 0xD2, 0x00, 0x00, 0xAB, 0x80, 0x59, 0xA9, 0x7F, 0x5A, 0xA6, 0x80, 0x5D, 0xB1, 0x83, 0x59, 0xAA, 0x7E, 0x55, 0xA9, 0x7F, 0x5A,
    0xAF, 0x7F, 0x55, 0xAF, 0x7F, 0x55, 0xAD, 0x7D, 0x53, 0xAB, 0x7B, 0x51, 0xAD, 0x79, 0x4B, 0xA8, 0x74, 0x46, 0xAA, 0x76, 0x48, 0xAB, 0x75, 0x40, 0xAE, 0x75, 0x3D, 0xB3, 0x79, 0x3E, 0xB1, 0x7A, 0x4D, 0xBA, 0x8C, 0x5C, 0xB9, 0x7E, 0x4C, 0xB7,
    0x7F, 0x44, 0xB7, 0x7F, 0x44, 0xB6, 0x7E, 0x43, 0xB0, 0x79, 0x52, 0xBA, 0x79, 0x42, 0xBE, 0xAC, 0xAB, 0xD9, 0xC0, 0xB6, 0xDC, 0xCF, 0xC7, 0xDF, 0xD5, 0xCD, 0xDF, 0xD8, 0xCF, 0xD6, 0xC9, 0xC0, 0xD7, 0xC4, 0xBC, 0xD5, 0xC8, 0xBF, 0xE0, 0xD4,
    0xC8, 0xDC, 0xD2, 0xC6, 0xDD, 0xD7, 0xCA, 0xE2, 0xDC, 0xD7, 0xE9, 0xE3, 0xDE, 0xC1, 0xBB, 0xB6, 0xEA, 0xEF, 0xEE, 0xE3, 0xE8, 0xDF, 0xEA, 0xD6, 0xBD, 0xBF, 0x98, 0x7C, 0xE8, 0xE4, 0xDF, 0xDF, 0xDF, 0xD9, 0xE2, 0xD7, 0xD3, 0xE0, 0xDC, 0xD7,
    0xE1, 0xDD, 0xD8, 0xEB, 0xE7, 0xE2, 0xF1, 0xEE, 0xE9, 0xD8, 0xD5, 0xD0, 0xDE, 0xDB, 0xD6, 0xDC, 0xDE, 0xD8, 0xE0, 0xE0, 0xDA, 0xE6, 0xE2, 0xDD, 0xE2, 0xD9, 0xD5, 0xE5, 0xE2, 0xDD, 0xE8, 0xE5, 0xE0, 0xD9, 0xD0, 0xCC, 0xDC, 0xD5, 0xCC, 0xDB,
    0xD4, 0xCB, 0xDB, 0xD4, 0xCB, 0xD7, 0xD3, 0xCE, 0xDB, 0xD7, 0xD2, 0xDA, 0xD6, 0xD1, 0xDF, 0xD8, 0xCF, 0xE1, 0xDA, 0xD1, 0xE2, 0xDB, 0xD2, 0xE5, 0xDE, 0xD5, 0xDF, 0xDA, 0xD1, 0xDD, 0xDC, 0xD2, 0x00, 0x00, 0xA4, 0x6E, 0x3F, 0xA4, 0x6E, 0x3F,
    0xA2, 0x6C, 0x3D, 0xA5, 0x6C, 0x39, 0xA5, 0x6C, 0x39, 0xA7, 0x6E, 0x3B, 0xA6, 0x6D, 0x36, 0xA4, 0x6B, 0x34, 0xA1, 0x68, 0x31, 0x9E, 0x65, 0x2E, 0xA9, 0x69, 0x2F, 0xAB, 0x6B, 0x31, 0xAB, 0x6B, 0x31, 0xAC, 0x6A, 0x35, 0xB3, 0x75, 0x3F, 0xAE,
    0x72, 0x3C, 0xB8, 0x7F, 0x52, 0xB3, 0x7B, 0x4A, 0xB0, 0x7A, 0x43, 0xB5, 0x7C, 0x48, 0xB5, 0x7C, 0x48, 0xB5, 0x7C, 0x48, 0xB1, 0x7B, 0x4C, 0xB6, 0x7A, 0x44, 0xB1, 0x7E, 0x53, 0x93, 0x6C, 0x50, 0xCF, 0xB6, 0xB2, 0xE1, 0xCF, 0xD0, 0xCA, 0xA6,
    0x94, 0xA8, 0x7D, 0x5C, 0xD9, 0xCE, 0xCA, 0xD9, 0xC2, 0xBA, 0xD6, 0xCD, 0xC3, 0xD6, 0xD5, 0xC7, 0xE0, 0xDE, 0xD3, 0xEA, 0xE0, 0xE0, 0xE6, 0xE3, 0xE5, 0xD5, 0xC3, 0x9E, 0x8D, 0x7B, 0x70, 0xDC, 0xC0, 0xA8, 0xAF, 0x7B, 0x3F, 0xB8, 0x7A, 0x33,
    0xB0, 0x98, 0x7A, 0xD8, 0xCC, 0xC6, 0xE0, 0xDE, 0xD3, 0xE8, 0xE4, 0xDF, 0xE1, 0xE1, 0xDB, 0xF2, 0xF4, 0xEE, 0xF4, 0xFA, 0xF5, 0xE1, 0xE1, 0xDB, 0xDC, 0xD2, 0xCA, 0xDD, 0xD9, 0xD4, 0xDF, 0xDB, 0xD6, 0xE9, 0xE5, 0xE0, 0xE4, 0xE3, 0xDF, 0xEA,
    0xEA, 0xE4, 0xE5, 0xE0, 0xD7, 0xD9, 0xD5, 0xCA, 0xE1, 0xD3, 0xCD, 0xDE, 0xD1, 0xC9, 0xD6, 0xCE, 0xC1, 0xD9, 0xD0, 0xC6, 0xDB, 0xD3, 0xC6, 0xDE, 0xD2, 0xC6, 0xDE, 0xD7, 0xCD, 0xD6, 0xCF, 0xC5, 0xDD, 0xD6, 0xCC, 0xE2, 0xD9, 0xD5, 0xE0, 0xDA,
    0xD5, 0xE4, 0xE1, 0xDC, 0x00, 0x00, 0xA3, 0x60, 0x21, 0xA0, 0x5D, 0x1E, 0xA4, 0x61, 0x22, 0xA8, 0x61, 0x22, 0xA8, 0x61, 0x22, 0xA9, 0x62, 0x23, 0xA8, 0x63, 0x24, 0xAA, 0x65, 0x26, 0xAB, 0x66, 0x27, 0xAD, 0x68, 0x29, 0xA8, 0x68, 0x2E, 0xA9,
    0x69, 0x2F, 0xA9, 0x69, 0x2F, 0xAF, 0x6D, 0x38, 0xA8, 0x6A, 0x34, 0xB4, 0x78, 0x42, 0xAC, 0x73, 0x3C, 0xB1, 0x77, 0x43, 0xB3, 0x79, 0x45, 0xB4, 0x7B, 0x47, 0xB4, 0x7B, 0x47, 0xB5, 0x7C, 0x48, 0xB1, 0x78, 0x44, 0xB4, 0x79, 0x41, 0xB3, 0x78,
    0x40, 0xB0, 0x77, 0x43, 0xB7, 0x7A, 0x3A, 0xB8, 0x7A, 0x3A, 0xB5, 0x7A, 0x3C, 0xBC, 0x7A, 0x39, 0xA7, 0x6F, 0x40, 0xB1, 0x8B, 0x69, 0xE0, 0xD0, 0xCA, 0xED, 0xDA, 0xDD, 0xE8, 0xDE, 0xD7, 0xD3, 0xDC, 0xD9, 0xEF, 0xDC, 0xCF, 0xA8, 0x70, 0x35,
    0xBC, 0x77, 0x2D, 0xBB, 0x77, 0x2E, 0xBB, 0x75, 0x32, 0xB9, 0x75, 0x34, 0xBD, 0x78, 0x28, 0xA9, 0x85, 0x67, 0xE7, 0xDE, 0xD4, 0xEA, 0xE6, 0xE1, 0xE8, 0xE8, 0xE2, 0xF5, 0xF7, 0xF1, 0xF6, 0xFA, 0xF5, 0xF6, 0xFA, 0xF4, 0xF9, 0xFA, 0xF0, 0xD6,
    0xD6, 0xD0, 0xDE, 0xDE, 0xD8, 0xEE, 0xEE, 0xE8, 0xF5, 0xF1, 0xF0, 0xE3, 0xE0, 0xDC, 0xE0, 0xD8, 0xD1, 0xD2, 0xCB, 0xC2, 0xD2, 0xCE, 0xC3, 0xE2, 0xDF, 0xD1, 0xD1, 0xBE, 0xAF, 0xC8, 0xB7, 0xA4, 0xDF, 0xC9, 0xBD, 0xE1, 0xD7, 0xCD, 0xE6, 0xE4,
    0xDA, 0xEE, 0xEC, 0xE2, 0xE5, 0xE3, 0xD9, 0xE0, 0xDC, 0xD7, 0xDC, 0xD9, 0xD4, 0xE0, 0xE2, 0xDC, 0x00, 0x00, 0x9F, 0x5B, 0x1A, 0xA1, 0x5D, 0x1C, 0xA1, 0x5D, 0x1C, 0xA6, 0x5E, 0x22, 0xA6, 0x5E, 0x22, 0xA7, 0x5F, 0x23, 0xA8, 0x61, 0x27, 0xAA,
    0x63, 0x29, 0xAB, 0x64, 0x2A, 0xAD, 0x66, 0x2C, 0xA8, 0x68, 0x2E, 0xA9, 0x69, 0x2F, 0xA9, 0x69, 0x2F, 0xAA, 0x68, 0x33, 0xA8, 0x6A, 0x34, 0xAB, 0x6F, 0x39, 0xAE, 0x74, 0x38, 0xB3, 0x78, 0x40, 0xB5, 0x78, 0x46, 0xB2, 0x79, 0x45, 0xB2, 0x79,
    0x45, 0xB2, 0x79, 0x45, 0xB6, 0x77, 0x3D, 0xB2, 0x77, 0x3F, 0xB1, 0x78, 0x41, 0xB3, 0x77, 0x41, 0xB3, 0x76, 0x3E, 0xB5, 0x75, 0x3E, 0xAF, 0x75, 0x41, 0xBA, 0x77, 0x38, 0xB1, 0x74, 0x34, 0xB9, 0x79, 0x3E, 0xEE, 0xDA, 0xC9, 0xDE, 0xDB, 0xD3,
    0xE7, 0xD9, 0xC7, 0xA4, 0x8E, 0x72, 0xAA, 0x73, 0x46, 0xC1, 0x76, 0x2A, 0xB7, 0x73, 0x30, 0xB7, 0x73, 0x30, 0xB9, 0x73, 0x30, 0xB9, 0x73, 0x30, 0xBD, 0x76, 0x26, 0xAB, 0x77, 0x48, 0xE2, 0xDE, 0xDD, 0xD9, 0xD5, 0xD0, 0xE9, 0xE9, 0xE3, 0xE7,
    0xE9, 0xE3, 0xED, 0xF1, 0xEC, 0xEE, 0xF2, 0xEC, 0xE8, 0xF0, 0xE5, 0xFC, 0xFE, 0xF8, 0xEA, 0xEC, 0xE6, 0xE3, 0xE5, 0xDF, 0xEE, 0xE3, 0xDB, 0xCC, 0xBF, 0xB6, 0xB7, 0xA7, 0x9A, 0xC6, 0xB6, 0xA6, 0xE5, 0xDD, 0xD0, 0xC4, 0xBB, 0xAD, 0xC4, 0xA1,
    0x93, 0xC1, 0xAB, 0x92, 0xC8, 0xAA, 0x9D, 0xD1, 0xC7, 0xBD, 0xEA, 0xE7, 0xE2, 0xF3, 0xF0, 0xEB, 0xE4, 0xE1, 0xDC, 0xE5, 0xE2, 0xDD, 0xEA, 0xEC, 0xE6, 0xEE, 0xF2, 0xEC, 0x00, 0x00, 0xA1, 0x5B, 0x18, 0xA1, 0x5B, 0x18, 0xA2, 0x5C, 0x19, 0xA5,
    0x5E, 0x1F, 0xA5, 0x5E, 0x1F, 0xA7, 0x60, 0x21, 0xA8, 0x60, 0x24, 0xA8, 0x62, 0x26, 0xA6, 0x65, 0x28, 0xA6, 0x67, 0x2A, 0xA8, 0x68, 0x2E, 0xA8, 0x68, 0x2E, 0xAA, 0x6A, 0x30, 0xAC, 0x6A, 0x35, 0xAE, 0x6C, 0x37, 0xB0, 0x6E, 0x39, 0xAC, 0x73,
    0x3F, 0xAE, 0x75, 0x41, 0xB0, 0x77, 0x43, 0xAE, 0x79, 0x47, 0xB2, 0x79, 0x45, 0xB4, 0x7B, 0x44, 0xB3, 0x77, 0x41, 0xB3, 0x77, 0x41, 0xB2, 0x76, 0x40, 0xB0, 0x74, 0x3E, 0xB4, 0x75, 0x3B, 0xB3, 0x74, 0x3A, 0xB3, 0x74, 0x3A, 0xB4, 0x75, 0x38,
    0xB3, 0x74, 0x37, 0xB3, 0x74, 0x37, 0xB3, 0x71, 0x36, 0xA4, 0x6B, 0x3E, 0xB6, 0x72, 0x31, 0xB7, 0x71, 0x2E, 0xB7, 0x71, 0x2E, 0xB9, 0x73, 0x30, 0xB9, 0x73, 0x2D, 0xB9, 0x73, 0x2D, 0xB9, 0x73, 0x2D, 0xB5, 0x6F, 0x29, 0xBD, 0x71, 0x28, 0xB4,
    0x72, 0x37, 0xC5, 0xA6, 0x8F, 0xE4, 0xD8, 0xD2, 0xE4, 0xDE, 0xD7, 0xDF, 0xE3, 0xD7, 0xE4, 0xE8, 0xDD, 0xE3, 0xE4, 0xDA, 0xE6, 0xE4, 0xDA, 0xE5, 0xE6, 0xDC, 0xE7, 0xE5, 0xDB, 0xED, 0xE8, 0xDF, 0xD0, 0xC3, 0xB5, 0xCC, 0xBC, 0xAF, 0xD0, 0xBD,
    0xB0, 0xC0, 0xAA, 0x9E, 0xC2, 0xAB, 0x9B, 0xC6, 0xAE, 0x9A, 0xC6, 0xAB, 0x96, 0xC8, 0xAE, 0x9D, 0xC2, 0xA8, 0x97, 0xC1, 0xA7, 0x96, 0xDA, 0xCF, 0xC1, 0xE4, 0xE0, 0xDB, 0xE7, 0xE1, 0xDA, 0xF1, 0xEC, 0xE9, 0xF4, 0xF3, 0xEF, 0xEC, 0xED, 0xE9,
    0x00, 0x00, 0xA1, 0x5B, 0x18, 0xA1, 0x5B, 0x18, 0xA2, 0x5C, 0x19, 0xA5, 0x5E, 0x1F, 0xA5, 0x5E, 0x1F, 0xA5, 0x5E, 0x1F, 0xA8, 0x60, 0x24, 0xA8, 0x62, 0x26, 0xA6, 0x65, 0x28, 0xA6, 0x67, 0x2A, 0xA8, 0x68, 0x2E, 0xA8, 0x68, 0x2E, 0xAA, 0x6A,
    0x30, 0xAB, 0x6B, 0x35, 0xAD, 0x6D, 0x37, 0xAF, 0x6F, 0x39, 0xAC, 0x73, 0x3F, 0xAE, 0x75, 0x41, 0xB0, 0x77, 0x43, 0xAE, 0x79, 0x47, 0xB2, 0x79, 0x45, 0xB1, 0x78, 0x41, 0xB3, 0x77, 0x41, 0xB3, 0x77, 0x41, 0xB2, 0x76, 0x40, 0xB0, 0x74, 0x3E,
    0xB4, 0x75, 0x3B, 0xB1, 0x72, 0x38, 0xB1, 0x72, 0x38, 0xB2, 0x73, 0x36, 0xB1, 0x72, 0x35, 0xB1, 0x72, 0x35, 0xB7, 0x6C, 0x2E, 0xB5, 0x74, 0x30, 0xB7, 0x6E, 0x2A, 0xB6, 0x70, 0x2D, 0xB6, 0x70, 0x2D, 0xB7, 0x71, 0x2E, 0xB7, 0x71, 0x2B, 0xB7,
    0x71, 0x2B, 0xB5, 0x6F, 0x29, 0xB6, 0x70, 0x2A, 0xB9, 0x70, 0x26, 0xB8, 0x6F, 0x1D, 0xBD, 0x6B, 0x23, 0xFF, 0xE7, 0xD7, 0xEC, 0xE1, 0xE3, 0xE4, 0xE6, 0xDA, 0xE5, 0xED, 0xE2, 0xE7, 0xE8, 0xDE, 0xEC, 0xE5, 0xDC, 0xE6, 0xE7, 0xDD, 0xEA, 0xE8,
    0xDE, 0xE3, 0xDE, 0xD5, 0xD7, 0xCB, 0xBF, 0xD9, 0xCB, 0xBF, 0xD9, 0xC7, 0xBC, 0xCE, 0xBA, 0xAF, 0xC6, 0xAF, 0x9F, 0xC6, 0xAE, 0x9A, 0xC2, 0xA7, 0x92, 0xC7, 0xAD, 0x9C, 0xBD, 0xA3, 0x92, 0xBF, 0xA5, 0x94, 0xC5, 0xAB, 0x9D, 0xF4, 0xE6, 0xDA,
    0xEB, 0xE9, 0xDE, 0xED, 0xEA, 0xE5, 0xE5, 0xE5, 0xDF, 0xE9, 0xED, 0xE7, 0x00, 0x00, 0x9F, 0x59, 0x16, 0x9F, 0x59, 0x16, 0xA1, 0x5B, 0x18, 0xA2, 0x5B, 0x1C, 0xA4, 0x5D, 0x1E, 0xA5, 0x5E, 0x1F, 0xA7, 0x5F, 0x23, 0xA7, 0x61, 0x25, 0xA6, 0x65,
    0x28, 0xA6, 0x67, 0x2A, 0xA6, 0x66, 0x2C, 0xAA, 0x6A, 0x30, 0xAC, 0x6C, 0x32, 0xA9, 0x6D, 0x37, 0xA9, 0x6D, 0x37, 0xAB, 0x6F, 0x39, 0xAB, 0x72, 0x3E, 0xB0, 0x77, 0x43, 0xB3, 0x7A, 0x46, 0xAE, 0x79, 0x47, 0xB2, 0x79, 0x45, 0xB1, 0x78, 0x41,
    0xB2, 0x76, 0x40, 0xB2, 0x76, 0x40, 0xB1, 0x75, 0x3F, 0xAF, 0x73, 0x3D, 0xB1, 0x72, 0x38, 0xB0, 0x71, 0x37, 0xB0, 0x71, 0x37, 0xB1, 0x72, 0x35, 0xAF, 0x70, 0x33, 0xAF, 0x70, 0x33, 0xB1, 0x6D, 0x32, 0xB3, 0x6A, 0x30, 0xB0, 0x70, 0x2F, 0xB4,
    0x6E, 0x2B, 0xB4, 0x6E, 0x2B, 0xB5, 0x6F, 0x2C, 0xB5, 0x6F, 0x29, 0xB5, 0x6F, 0x29, 0xB3, 0x6D, 0x27, 0xB3, 0x6D, 0x27, 0xB3, 0x6B, 0x25, 0xB6, 0x6B, 0x26, 0xB6, 0x6D, 0x21, 0xB1, 0x6E, 0x23, 0xA6, 0x74, 0x50, 0xEE, 0xDA, 0xC8, 0xEC, 0xE5,
    0xDC, 0xE9, 0xE8, 0xDE, 0xE3, 0xEB, 0xE0, 0xF2, 0xF3, 0xE9, 0xEE, 0xEC, 0xE2, 0xDF, 0xDA, 0xD1, 0xE0, 0xD6, 0xCE, 0xDF, 0xD4, 0xCC, 0xDC, 0xCC, 0xC5, 0xCF, 0xBD, 0xB6, 0xC8, 0xB1, 0xA1, 0xC7, 0xAF, 0x9B, 0xC0, 0xA5, 0x90, 0xC3, 0xA9, 0x98,
    0xC1, 0xA7, 0x96, 0xC7, 0xAD, 0x9C, 0xC7, 0xAE, 0x9A, 0xBE, 0xA2, 0x8A, 0xBF, 0xAF, 0x9F, 0xEB, 0xDB, 0xD4, 0xD9, 0xCC, 0xC4, 0xE5, 0xDB, 0xD3, 0x00, 0x00, 0x9D, 0x57, 0x14, 0x9D, 0x57, 0x14, 0xA0, 0x5A, 0x17, 0x9D, 0x5C, 0x18, 0x9F, 0x5D,
    0x1C, 0xA0, 0x5D, 0x20, 0x9F, 0x5F, 0x25, 0xA1, 0x61, 0x27, 0xA2, 0x62, 0x28, 0xA4, 0x64, 0x2A, 0xA6, 0x66, 0x30, 0xA8, 0x68, 0x32, 0xAB, 0x6B, 0x35, 0xA8, 0x6C, 0x36, 0xA9, 0x6D, 0x37, 0xAB, 0x6F, 0x39, 0xAC, 0x72, 0x3E, 0xB1, 0x77, 0x43,
    0xB3, 0x79, 0x45, 0xB2, 0x78, 0x44, 0xB2, 0x78, 0x44, 0xB1, 0x77, 0x43, 0xB4, 0x77, 0x3F, 0xB4, 0x77, 0x3F, 0xB3, 0x76, 0x3E, 0xB1, 0x74, 0x3C, 0xAF, 0x71, 0x3B, 0xB0, 0x6F, 0x38, 0xB2, 0x70, 0x35, 0xAE, 0x71, 0x33, 0xAE, 0x71, 0x33, 0xB2,
    0x75, 0x37, 0xB8, 0x73, 0x3A, 0xAD, 0x6A, 0x2D, 0xB2, 0x6E, 0x2D, 0xAF, 0x6E, 0x29, 0xAF, 0x6E, 0x29, 0xB1, 0x70, 0x2B, 0xB9, 0x6B, 0x2E, 0xB5, 0x6B, 0x2B, 0xB2, 0x6D, 0x28, 0xB2, 0x6D, 0x27, 0xB8, 0x6B, 0x22, 0xB6, 0x69, 0x20, 0xB6, 0x69,
    0x20, 0xB8, 0x6F, 0x25, 0xB9, 0x73, 0x2D, 0xBA, 0x74, 0x31, 0x9A, 0x7F, 0x5A, 0x9C, 0x86, 0x81, 0xE4, 0xEA, 0xEF, 0xDA, 0xD5, 0xCC, 0xE1, 0xDC, 0xD3, 0xDF, 0xDA, 0xD1, 0xE8, 0xDB, 0xD3, 0xDE, 0xD7, 0xCD, 0xDC, 0xD2, 0xC8, 0xCA, 0xB3, 0xA9,
    0xCC, 0xB4, 0xA2, 0xC9, 0xAA, 0x93, 0xCC, 0xA6, 0x8D, 0xC6, 0xAC, 0x9B, 0xC0, 0xAA, 0x98, 0xC4, 0xB0, 0x9E, 0xC8, 0xAF, 0x9F, 0xC8, 0xAF, 0x9F, 0xC3, 0xAA, 0x9A, 0xCF, 0xAB, 0x99, 0xE2, 0xD5, 0xC5, 0xE3, 0xDF, 0xD4, 0x00, 0x00, 0x9B, 0x55,
    0x12, 0x9B, 0x55, 0x12, 0x9E, 0x58, 0x15, 0x9D, 0x5C, 0x18, 0x9F, 0x5D, 0x1C, 0xA0, 0x5D, 0x20, 0x9F, 0x5F, 0x25, 0xA1, 0x61, 0x27, 0xA2, 0x62, 0x28, 0xA4, 0x64, 0x2A, 0xA6, 0x66, 0x30, 0xA8, 0x68, 0x32, 0xAB, 0x6B, 0x35, 0xA8, 0x6C, 0x36,
    0xAB, 0x6F, 0x39, 0xAD, 0x71, 0x3B, 0xA9, 0x72, 0x3F, 0xAE, 0x77, 0x44, 0xB0, 0x79, 0x46, 0xB1, 0x7A, 0x47, 0xB1, 0x7A, 0x47, 0xB0, 0x79, 0x46, 0xAF, 0x76, 0x43, 0xAF, 0x76, 0x43, 0xAE, 0x75, 0x42, 0xAC, 0x73, 0x40, 0xAB, 0x71, 0x3D, 0xAF,
    0x72, 0x3A, 0xB1, 0x72, 0x38, 0xB1, 0x6F, 0x34, 0xAF, 0x6D, 0x32, 0xB1, 0x6F, 0x34, 0xB7, 0x80, 0x45, 0xAA, 0x6C, 0x30, 0xBA, 0x6C, 0x2F, 0xB3, 0x6B, 0x2F, 0xB3, 0x6B, 0x2F, 0xB5, 0x6D, 0x31, 0xB5, 0x6E, 0x2A, 0xB5, 0x6C, 0x28, 0xB5, 0x6C,
    0x22, 0xB7, 0x6B, 0x22, 0xB5, 0x6A, 0x25, 0xB3, 0x68, 0x23, 0xB3, 0x68, 0x23, 0xB3, 0x6D, 0x27, 0xBB, 0x75, 0x32, 0xBA, 0x78, 0x37, 0xB7, 0x77, 0x36, 0xC7, 0x80, 0x46, 0xA3, 0x7F, 0x61, 0xD7, 0xCD, 0xC3, 0xDB, 0xD1, 0xC7, 0xDE, 0xD4, 0xCA,
    0xDC, 0xD5, 0xD2, 0xDC, 0xD1, 0xC9, 0xCE, 0xB3, 0x9E, 0xC6, 0xA5, 0x8B, 0xC8, 0xA7, 0x93, 0xBF, 0xA4, 0x8F, 0xC0, 0xAE, 0x95, 0xC7, 0xAD, 0x9C, 0xC3, 0xAD, 0x9B, 0xC7, 0xB3, 0xA1, 0xC6, 0xB2, 0xA1, 0xC6, 0xB2, 0xA1, 0xC5, 0xB1, 0xA0, 0xC5,
    0xA4, 0x90, 0xD2, 0xC2, 0xB1, 0xE9, 0xDF, 0xD3, 0x00, 0x00, 0x9A, 0x54, 0x11, 0x9C, 0x56, 0x13, 0x9E, 0x58, 0x15, 0x9B, 0x5A, 0x16, 0x9E, 0x5C, 0x1B, 0x9F, 0x5C, 0x1F, 0x9F, 0x5F, 0x25, 0xA1, 0x61, 0x27, 0xA3, 0x63, 0x29, 0xA3, 0x63, 0x29,
    0xA5, 0x65, 0x2F, 0xA8, 0x68, 0x32, 0xAB, 0x6B, 0x35, 0xA8, 0x6C, 0x36, 0xAB, 0x6F, 0x39, 0xAE, 0x72, 0x3C, 0xA9, 0x73, 0x44, 0xAC, 0x76, 0x47, 0xB0, 0x7A, 0x4B, 0xB1, 0x7B, 0x4C, 0xB2, 0x7C, 0x4D, 0xB1, 0x7B, 0x4C, 0xB3, 0x7F, 0x51, 0xB8,
    0x84, 0x56, 0xB9, 0x85, 0x57, 0xC6, 0x92, 0x64, 0xC1, 0x92, 0x66, 0xBC, 0x8A, 0x5C, 0xBC, 0x89, 0x57, 0xBA, 0x8C, 0x5D, 0xC0, 0x92, 0x63, 0xB8, 0x8A, 0x5B, 0xBC, 0x8F, 0x5C, 0xB3, 0x7E, 0x4B, 0xAD, 0x6F, 0x39, 0xA9, 0x72, 0x35, 0xAE, 0x77,
    0x3A, 0xB5, 0x7E, 0x41, 0xBE, 0x84, 0x43, 0xA5, 0x68, 0x26, 0xB2, 0x6D, 0x28, 0xB0, 0x68, 0x22, 0xB2, 0x69, 0x25, 0xB5, 0x6C, 0x28, 0xBE, 0x75, 0x31, 0xBA, 0x75, 0x30, 0xB7, 0x75, 0x34, 0xB2, 0x71, 0x34, 0xB4, 0x78, 0x36, 0xBA, 0x7E, 0x3C,
    0xAC, 0x85, 0x5E, 0xDB, 0xCB, 0xBE, 0xE4, 0xD4, 0xC7, 0xDD, 0xCD, 0xC0, 0xD4, 0xCA, 0xBE, 0xDE, 0xC9, 0xBA, 0xC2, 0xA0, 0x88, 0xC4, 0xA4, 0x87, 0xC3, 0xA1, 0x8A, 0xC8, 0xAD, 0x98, 0xC0, 0xAC, 0x9A, 0xC2, 0xA8, 0x97, 0xBB, 0xA5, 0x93, 0xC3,
    0xAF, 0x9D, 0xC1, 0xAF, 0x9E, 0xC3, 0xB1, 0xA0, 0xCC, 0xBA, 0xA9, 0xC9, 0xA5, 0x8D, 0xD1, 0xB9, 0xA5, 0xDC, 0xC7, 0xB8, 0x00, 0x00, 0x94, 0x51, 0x12, 0x96, 0x53, 0x14, 0x99, 0x56, 0x17, 0x97, 0x56, 0x19, 0x9C, 0x5B, 0x1E, 0x9E, 0x5D, 0x20,
    0x9C, 0x5D, 0x23, 0x9C, 0x5D, 0x23, 0xA2, 0x63, 0x29, 0xA1, 0x62, 0x28, 0xA5, 0x67, 0x31, 0xA6, 0x69, 0x37, 0xA5, 0x6B, 0x3A, 0xAB, 0x6E, 0x36, 0xA9, 0x6F, 0x3B, 0xAA, 0x73, 0x40, 0xAF, 0x7B, 0x4C, 0xB8, 0x84, 0x55, 0xAB, 0x77, 0x48, 0xB8,
    0x81, 0x4E, 0xAF, 0x7A, 0x48, 0xB1, 0x7D, 0x4F, 0xA7, 0x78, 0x4C, 0xB0, 0x81, 0x55, 0xA6, 0x77, 0x4B, 0xA9, 0x7A, 0x4E, 0xB1, 0x81, 0x57, 0xB7, 0x88, 0x62, 0xA4, 0x75, 0x55, 0xB2, 0x7B, 0x54, 0xAF, 0x7B, 0x4C, 0xAA, 0x78, 0x44, 0xB5, 0x82,
    0x5A, 0xBB, 0x88, 0x60, 0xAC, 0x79, 0x51, 0xAF, 0x7B, 0x4D, 0xB5, 0x84, 0x56, 0xB7, 0x8D, 0x5E, 0xC1, 0x88, 0x51, 0xAD, 0x70, 0x38, 0xB9, 0x77, 0x36, 0xAF, 0x69, 0x26, 0xB4, 0x6D, 0x29, 0xB2, 0x6B, 0x28, 0xAD, 0x70, 0x30, 0xAE, 0x6B, 0x2E,
    0xB3, 0x70, 0x37, 0xB1, 0x71, 0x3A, 0xB5, 0x78, 0x40, 0xBA, 0x81, 0x4A, 0xAC, 0x89, 0x67, 0xCD, 0xBF, 0xB3, 0xD3, 0xBC, 0xAC, 0xD2, 0xB2, 0x9F, 0xC5, 0xA6, 0x91, 0xBA, 0x9B, 0x86, 0xBC, 0x9D, 0x88, 0xC1, 0xA2, 0x8D, 0xBA, 0xA4, 0x92, 0xBD,
    0xAC, 0x9F, 0xB7, 0xA1, 0x8F, 0xC3, 0xA6, 0x91, 0xCD, 0xB0, 0x9B, 0xC2, 0xA5, 0x90, 0xC4, 0xAA, 0x99, 0xC8, 0xAF, 0x9F, 0xD0, 0xBA, 0xAE, 0xCB, 0xB0, 0xA5, 0xCA, 0xB4, 0xA8, 0xDB, 0xC8, 0xBB, 0x00, 0x00, 0x94, 0x51, 0x12, 0x96, 0x53, 0x14,
    0x99, 0x56, 0x17, 0x9D, 0x60, 0x28, 0x99, 0x5C, 0x24, 0x9D, 0x60, 0x28, 0x9D, 0x5E, 0x24, 0x9E, 0x5F, 0x25, 0xA1, 0x62, 0x28, 0xA5, 0x66, 0x2C, 0xA5, 0x67, 0x31, 0xA6, 0x69, 0x37, 0xA5, 0x6B, 0x3A, 0xAA, 0x70, 0x3C, 0xAE, 0x76, 0x45, 0xB0,
    0x7A, 0x4B, 0xAB, 0x77, 0x48, 0xB0, 0x7C, 0x4D, 0xB4, 0x80, 0x51, 0xAD, 0x7B, 0x51, 0xB3, 0x80, 0x55, 0xB4, 0x80, 0x52, 0xB0, 0x7C, 0x53, 0xB0, 0x7C, 0x53, 0xB1, 0x7D, 0x54, 0xAF, 0x7B, 0x52, 0xAA, 0x77, 0x45, 0xAD, 0x79, 0x4B, 0xB8, 0x83,
    0x58, 0xB3, 0x7C, 0x4F, 0xC1, 0x8C, 0x5A, 0xB4, 0x7F, 0x4C, 0xB4, 0x7E, 0x55, 0xB2, 0x7C, 0x53, 0xBB, 0x85, 0x5C, 0xAF, 0x7A, 0x48, 0xB7, 0x7F, 0x4E, 0xB7, 0x7D, 0x4C, 0xA7, 0x6A, 0x30, 0xA5, 0x66, 0x29, 0xAE, 0x69, 0x24, 0xB2, 0x6A, 0x22,
    0xAF, 0x68, 0x24, 0xB0, 0x68, 0x28, 0xAB, 0x6E, 0x2E, 0xB5, 0x74, 0x30, 0xB2, 0x74, 0x34, 0xB8, 0x7A, 0x3E, 0xB3, 0x7F, 0x4A, 0xBB, 0x86, 0x53, 0xBB, 0x91, 0x6E, 0xD6, 0xBC, 0xA4, 0xB6, 0x99, 0x84, 0xC2, 0xA4, 0x91, 0xD0, 0xB0, 0x9D, 0xBE,
    0x9E, 0x8B, 0xC4, 0xA4, 0x91, 0xCB, 0xAB, 0x98, 0xC6, 0xAA, 0x91, 0xC5, 0xAC, 0x98, 0xBE, 0xA2, 0x89, 0xC2, 0xA6, 0x8E, 0xBE, 0xA2, 0x8A, 0xC6, 0xAA, 0x92, 0xC4, 0xA9, 0x95, 0xC7, 0xAD, 0x9C, 0xC9, 0xB2, 0xA3, 0xCF, 0xB5, 0xA7, 0xD4, 0xBD,
    0xAE, 0xD2, 0xBF, 0xB0, 0x00, 0x00, 0x94, 0x51, 0x12, 0x96, 0x53, 0x14, 0x9A, 0x57, 0x18, 0xA3, 0x66, 0x2E, 0xA0, 0x63, 0x2B, 0x9F, 0x62, 0x2A, 0x9B, 0x5C, 0x22, 0x9D, 0x5E, 0x24, 0xA1, 0x62, 0x28, 0xA3, 0x64, 0x2A, 0xA4, 0x66, 0x30, 0xA9,
    0x6C, 0x3A, 0xAA, 0x70, 0x3F, 0xAB, 0x77, 0x49, 0xA6, 0x74, 0x4A, 0xAE, 0x80, 0x57, 0xA8, 0x74, 0x45, 0xAA, 0x76, 0x47, 0xAC, 0x78, 0x49, 0xB4, 0x84, 0x5A, 0xB7, 0x8A, 0x64, 0xB8, 0x8E, 0x6B, 0xB7, 0x86, 0x60, 0xB5, 0x84, 0x5E, 0xBA, 0x89,
    0x63, 0xBB, 0x8A, 0x64, 0xBA, 0x87, 0x55, 0xAF, 0x76, 0x43, 0xB1, 0x72, 0x3F, 0xA9, 0x71, 0x3A, 0xB4, 0x7B, 0x48, 0xB8, 0x7E, 0x4D, 0xB5, 0x7A, 0x48, 0xB3, 0x78, 0x46, 0xB2, 0x77, 0x45, 0xB2, 0x71, 0x3A, 0xAC, 0x69, 0x32, 0xAC, 0x66, 0x30,
    0xAD, 0x74, 0x3D, 0xAF, 0x72, 0x3A, 0xB3, 0x71, 0x30, 0xAF, 0x69, 0x26, 0xAF, 0x66, 0x28, 0xB2, 0x68, 0x2D, 0xB9, 0x7A, 0x40, 0xBE, 0x8D, 0x61, 0xBA, 0x8C, 0x63, 0xBA, 0x8D, 0x67, 0xBC, 0x8E, 0x5F, 0xC2, 0x97, 0x6E, 0xB6, 0x88, 0x5F, 0xC2,
    0x95, 0x73, 0xC9, 0xA3, 0x81, 0xDA, 0xB7, 0x96, 0xBD, 0x96, 0x76, 0xBD, 0x96, 0x76, 0xBA, 0x93, 0x73, 0xB9, 0x92, 0x72, 0xBA, 0x9B, 0x86, 0xBF, 0xA3, 0x92, 0xC2, 0xA3, 0x8E, 0xBF, 0x9E, 0x84, 0xBF, 0x9E, 0x84, 0xC4, 0xA3, 0x89, 0xC3, 0xA4,
    0x8D, 0xC3, 0xA6, 0x91, 0xC4, 0xAA, 0x99, 0xD0, 0xB2, 0xA1, 0xC1, 0xA7, 0x96, 0xCC, 0xB4, 0xA2, 0x00, 0x00, 0x94, 0x51, 0x12, 0x96, 0x53, 0x14, 0x97, 0x54, 0x15, 0x96, 0x55, 0x18, 0x98, 0x57, 0x1A, 0x9B, 0x5A, 0x1D, 0x9B, 0x5C, 0x22, 0x9D,
    0x5E, 0x24, 0xA1, 0x62, 0x28, 0xA3, 0x64, 0x2A, 0xA4, 0x66, 0x30, 0xAC, 0x6F, 0x3D, 0xA9, 0x6F, 0x3E, 0xB2, 0x80, 0x56, 0xAE, 0x7F, 0x59, 0xAD, 0x80, 0x5B, 0xB0, 0x7C, 0x4D, 0xA7, 0x73, 0x44, 0xA7, 0x73, 0x44, 0xAD, 0x78, 0x46, 0xB0, 0x83,
    0x5E, 0xB8, 0x95, 0x7B, 0xBE, 0x94, 0x6F, 0xB6, 0x8C, 0x67, 0xB7, 0x8D, 0x68, 0xB5, 0x8B, 0x66, 0xB0, 0x81, 0x55, 0xAC, 0x76, 0x47, 0xAB, 0x6F, 0x3B, 0xB1, 0x79, 0x3E, 0xAB, 0x70, 0x3E, 0xB4, 0x78, 0x4A, 0xB1, 0x72, 0x3F, 0xA6, 0x67, 0x34,
    0xB3, 0x74, 0x41, 0xB3, 0x6A, 0x30, 0xAD, 0x6B, 0x30, 0xB1, 0x73, 0x37, 0xBF, 0x8B, 0x5C, 0x99, 0x62, 0x2F, 0xA1, 0x64, 0x2A, 0xA5, 0x66, 0x29, 0xAF, 0x66, 0x28, 0xB4, 0x6A, 0x30, 0xB1, 0x72, 0x38, 0xAB, 0x70, 0x3F, 0xAA, 0x71, 0x44, 0xB2,
    0x7A, 0x50, 0xAE, 0x7B, 0x50, 0xBF, 0x95, 0x72, 0xBC, 0x94, 0x69, 0xBC, 0x90, 0x71, 0xB5, 0x8B, 0x68, 0xB2, 0x8A, 0x60, 0xC7, 0x96, 0x6E, 0xBD, 0x8C, 0x64, 0xBE, 0x8D, 0x65, 0xBB, 0x8A, 0x62, 0xC0, 0x91, 0x6B, 0xAD, 0x82, 0x61, 0xB5, 0x86,
    0x60, 0xBA, 0x9A, 0x7D, 0xBB, 0x9B, 0x7E, 0xCA, 0xAA, 0x8D, 0xC6, 0xA7, 0x8E, 0xC7, 0xA8, 0x91, 0xC9, 0xAE, 0x9A, 0xCD, 0xAF, 0x9C, 0xC6, 0xAB, 0x97, 0xD1, 0xB9, 0xA5, 0x00, 0x00, 0x91, 0x50, 0x13, 0x90, 0x51, 0x17, 0x94, 0x5B, 0x24, 0x9B,
    0x5E, 0x24, 0x99, 0x5C, 0x22, 0x97, 0x5A, 0x20, 0x9D, 0x60, 0x26, 0xA1, 0x64, 0x2C, 0x96, 0x5D, 0x29, 0x9D, 0x64, 0x31, 0xA1, 0x6B, 0x3C, 0xAA, 0x74, 0x45, 0xAD, 0x77, 0x48, 0xB2, 0x80, 0x52, 0xA7, 0x75, 0x47, 0xAC, 0x7A, 0x4C, 0xAA, 0x72,
    0x41, 0xAC, 0x74, 0x43, 0xAB, 0x73, 0x42, 0xB0, 0x74, 0x40, 0xAA, 0x6F, 0x3E, 0xAB, 0x6F, 0x41, 0xAA, 0x74, 0x45, 0xB0, 0x7A, 0x4B, 0xB4, 0x7E, 0x4F, 0xAA, 0x74, 0x45, 0xAA, 0x71, 0x3D, 0xAA, 0x6E, 0x38, 0xAC, 0x6F, 0x35, 0xAB, 0x6D, 0x37,
    0xAC, 0x6E, 0x38, 0xAC, 0x6E, 0x38, 0xAD, 0x6B, 0x36, 0xAB, 0x69, 0x34, 0xA9, 0x67, 0x32, 0xA8, 0x6A, 0x3A, 0xCC, 0x99, 0x67, 0x9E, 0x69, 0x37, 0xAD, 0x6B, 0x30, 0xA9, 0x67, 0x2C, 0xB0, 0x67, 0x2D, 0xB0, 0x67, 0x2D, 0xB1, 0x68, 0x2A, 0xB0,
    0x67, 0x29, 0xAF, 0x66, 0x28, 0xA8, 0x63, 0x24, 0xB0, 0x70, 0x39, 0xBA, 0x80, 0x4C, 0xB3, 0x81, 0x53, 0xBB, 0x8E, 0x68, 0xC0, 0x92, 0x69, 0xBA, 0x89, 0x61, 0xBA, 0x89, 0x5D, 0xC6, 0x92, 0x64, 0xB6, 0x80, 0x57, 0xBE, 0x8D, 0x67, 0xBE, 0x98,
    0x76, 0xBC, 0x99, 0x78, 0xB6, 0x88, 0x59, 0xB4, 0x85, 0x59, 0xC3, 0x9A, 0x7A, 0xC8, 0xA1, 0x85, 0xC6, 0xA7, 0x8E, 0xC7, 0xAD, 0x95, 0xCE, 0xB4, 0xA3, 0xC7, 0xAD, 0x9C, 0xCB, 0xB1, 0xA0, 0xCA, 0xB1, 0x9D, 0xC7, 0xB0, 0xA0, 0xD6, 0xC1, 0xB2,
    0x00, 0x00, 0x97, 0x56, 0x23, 0x91, 0x58, 0x25, 0xA3, 0x73, 0x43, 0xAC, 0x70, 0x3A, 0x95, 0x59, 0x23, 0x99, 0x5D, 0x27, 0x9C, 0x60, 0x2A, 0x9A, 0x61, 0x2A, 0xA2, 0x6A, 0x39, 0xA5, 0x70, 0x3E, 0xA7, 0x73, 0x45, 0xA5, 0x71, 0x43, 0xAA, 0x76,
    0x48, 0xAB, 0x77, 0x48, 0xA7, 0x73, 0x44, 0xA7, 0x73, 0x44, 0xAB, 0x73, 0x42, 0xAB, 0x73, 0x42, 0xA8, 0x70, 0x3F, 0xA7, 0x78, 0x42, 0xAA, 0x74, 0x3D, 0xAA, 0x6E, 0x38, 0xAE, 0x6E, 0x38, 0xAE, 0x6E, 0x38, 0xAF, 0x6F, 0x39, 0xB3, 0x73, 0x3D,
    0xAB, 0x72, 0x3B, 0xAD, 0x70, 0x38, 0xAF, 0x71, 0x35, 0xAB, 0x6F, 0x39, 0xAA, 0x6E, 0x38, 0xAC, 0x70, 0x3A, 0xAE, 0x70, 0x3A, 0xA7, 0x69, 0x33, 0xAA, 0x6C, 0x36, 0xA8, 0x6E, 0x33, 0xA5, 0x6D, 0x32, 0xAB, 0x6B, 0x31, 0xA9, 0x6C, 0x32, 0xAB,
    0x6E, 0x34, 0xB0, 0x6D, 0x34, 0xAF, 0x6C, 0x33, 0xB0, 0x69, 0x2F, 0xB0, 0x69, 0x2F, 0xAF, 0x68, 0x2E, 0xAF, 0x6F, 0x2F, 0xB7, 0x7C, 0x44, 0xB0, 0x77, 0x43, 0xBD, 0x85, 0x54, 0xC0, 0x8E, 0x64, 0xBA, 0x87, 0x5C, 0xB6, 0x81, 0x4F, 0xB1, 0x78,
    0x45, 0xA7, 0x6D, 0x39, 0xA9, 0x69, 0x2F, 0xB8, 0x83, 0x58, 0xBD, 0x99, 0x7B, 0xB4, 0x90, 0x72, 0xB7, 0x87, 0x57, 0xBB, 0x8B, 0x61, 0xB6, 0x8F, 0x73, 0xC2, 0x9F, 0x85, 0xC5, 0xA9, 0x91, 0xD1, 0xB9, 0xA3, 0xD1, 0xBA, 0xAB, 0xC9, 0xB2, 0xA3,
    0xC7, 0xB0, 0xA1, 0xCD, 0xB5, 0xA1, 0xC2, 0xAE, 0x9D, 0xDF, 0xCC, 0xBD, 0x00, 0x00, 0xA5, 0x77, 0x48, 0xA7, 0x78, 0x4C, 0xAC, 0x78, 0x50, 0x9B, 0x62, 0x2E, 0xAE, 0x75, 0x41, 0xA4, 0x6B, 0x37, 0xA5, 0x6C, 0x38, 0x9E, 0x65, 0x32, 0xAA, 0x76,
    0x47, 0x9A, 0x66, 0x38, 0xA7, 0x6D, 0x39, 0xAA, 0x70, 0x3C, 0xAF, 0x75, 0x41, 0xA9, 0x72, 0x3F, 0xAB, 0x74, 0x41, 0xAB, 0x74, 0x41, 0xAB, 0x73, 0x42, 0xAB, 0x73, 0x42, 0xAD, 0x75, 0x44, 0xAE, 0x70, 0x47, 0xAB, 0x6F, 0x41, 0xA8, 0x6E, 0x3A,
    0xA3, 0x6F, 0x3A, 0xA3, 0x6F, 0x3A, 0xA8, 0x74, 0x3F, 0xAD, 0x79, 0x44, 0xA9, 0x75, 0x46, 0xAD, 0x75, 0x44, 0xAF, 0x76, 0x42, 0xAF, 0x77, 0x40, 0xAE, 0x76, 0x3F, 0xB0, 0x78, 0x41, 0xB3, 0x77, 0x41, 0xAC, 0x70, 0x3A, 0xAC, 0x70, 0x3A, 0xB1,
    0x75, 0x3F, 0xAD, 0x7C, 0x44, 0xAD, 0x77, 0x40, 0xAE, 0x76, 0x3F, 0xB6, 0x7E, 0x47, 0xB9, 0x7B, 0x45, 0xB2, 0x74, 0x3E, 0xB5, 0x7D, 0x42, 0xAF, 0x77, 0x3C, 0xA8, 0x70, 0x35, 0xB3, 0x68, 0x2A, 0xA6, 0x60, 0x2A, 0xB6, 0x75, 0x42, 0xB8, 0x7B,
    0x49, 0xB4, 0x7C, 0x52, 0xB9, 0x80, 0x53, 0xB2, 0x75, 0x3D, 0xB3, 0x75, 0x39, 0xB2, 0x71, 0x34, 0xAA, 0x6A, 0x30, 0xC0, 0x8E, 0x64, 0xB7, 0x8E, 0x6D, 0xBB, 0x8E, 0x62, 0xB8, 0x8E, 0x63, 0xC1, 0x90, 0x62, 0xBF, 0x91, 0x68, 0xC5, 0xA3, 0x8C,
    0xC8, 0xAD, 0x99, 0xCF, 0xB9, 0xA7, 0xD8, 0xC2, 0xB6, 0xD5, 0xBF, 0xB3, 0xC7, 0xB1, 0xA5, 0xCA, 0xB7, 0xA2, 0xC5, 0xB5, 0xA4, 0xC3, 0xB4, 0xA4, 0x00, 0x00, 0x9E, 0x6F, 0x43, 0x8A, 0x58, 0x2A, 0x98, 0x5E, 0x2D, 0x98, 0x67, 0x39, 0xA2, 0x71,
    0x45, 0xB5, 0x82, 0x5A, 0xAE, 0x83, 0x5C, 0xA1, 0x71, 0x47, 0x9B, 0x64, 0x31, 0xA4, 0x6B, 0x34, 0xA5, 0x6D, 0x3C, 0xA9, 0x71, 0x40, 0xA9, 0x71, 0x40, 0xA6, 0x72, 0x43, 0xA6, 0x72, 0x43, 0xA8, 0x74, 0x45, 0xAD, 0x75, 0x46, 0xAB, 0x73, 0x44,
    0xAB, 0x73, 0x44, 0xAB, 0x75, 0x40, 0xAB, 0x75, 0x40, 0xA7, 0x71, 0x3C, 0xAB, 0x6F, 0x3B, 0xAB, 0x70, 0x3E, 0xAE, 0x76, 0x47, 0xB2, 0x7B, 0x4E, 0xB3, 0x7B, 0x4A, 0xAE, 0x76, 0x45, 0xB2, 0x7A, 0x49, 0xB4, 0x7C, 0x4B, 0xB6, 0x7E, 0x4D, 0xBA,
    0x82, 0x51, 0xB9, 0x81, 0x50, 0xB6, 0x7E, 0x4D, 0xB2, 0x7A, 0x49, 0xB8, 0x81, 0x4E, 0xB9, 0x85, 0x56, 0xBD, 0x8B, 0x5D, 0xC1, 0x8D, 0x68, 0xC6, 0x95, 0x6F, 0xC4, 0x97, 0x71, 0xBA, 0x8F, 0x68, 0xC0, 0x8B, 0x59, 0xBF, 0x86, 0x53, 0xB1, 0x79,
    0x38, 0xAE, 0x6B, 0x2C, 0xAB, 0x5F, 0x24, 0xA6, 0x5F, 0x25, 0xB3, 0x7A, 0x46, 0xAA, 0x7F, 0x4E, 0xAF, 0x76, 0x42, 0xB2, 0x75, 0x3B, 0xB2, 0x73, 0x39, 0xA4, 0x65, 0x2B, 0xAB, 0x6B, 0x31, 0xA9, 0x69, 0x2F, 0xA3, 0x6B, 0x3C, 0xB6, 0x86, 0x62,
    0xB7, 0x8E, 0x6D, 0xCA, 0xA8, 0x90, 0xC8, 0xA5, 0x8B, 0xCC, 0xAA, 0x92, 0xCA, 0xB8, 0xA1, 0xCD, 0xB9, 0xA7, 0xD1, 0xC0, 0xB3, 0xD1, 0xC2, 0xB2, 0xC8, 0xAC, 0x9B, 0xBA, 0xA5, 0x96, 0xBC, 0xA3, 0x93, 0xC4, 0xAB, 0x97, 0x00, 0x00, 0xAA, 0x79,
    0x49, 0x91, 0x5C, 0x2A, 0x90, 0x54, 0x20, 0x97, 0x5E, 0x26, 0x93, 0x5A, 0x23, 0x91, 0x56, 0x24, 0x97, 0x5C, 0x2E, 0x9C, 0x61, 0x30, 0xA3, 0x66, 0x34, 0xA7, 0x6B, 0x37, 0xA5, 0x6D, 0x3C, 0xA8, 0x70, 0x3F, 0xAB, 0x73, 0x42, 0xA7, 0x73, 0x44,
    0xA7, 0x73, 0x44, 0xA9, 0x75, 0x46, 0xAF, 0x77, 0x48, 0xB1, 0x79, 0x4A, 0xAE, 0x76, 0x47, 0xAE, 0x76, 0x45, 0xAE, 0x76, 0x45, 0xAC, 0x74, 0x43, 0xAF, 0x75, 0x44, 0xAF, 0x77, 0x48, 0xB1, 0x7C, 0x51, 0xB4, 0x80, 0x57, 0xB6, 0x82, 0x54, 0xBB,
    0x87, 0x59, 0xB5, 0x81, 0x53, 0xB4, 0x80, 0x52, 0xB9, 0x85, 0x57, 0xBE, 0x8A, 0x5C, 0xBF, 0x90, 0x6A, 0xC3, 0x94, 0x6E, 0xBB, 0x8C, 0x66, 0xBB, 0x8D, 0x64, 0xBB, 0x8F, 0x6A, 0xBD, 0x93, 0x70, 0xBC, 0x96, 0x7D, 0xC2, 0x9F, 0x85, 0xC6, 0xA7,
    0x8D, 0xC1, 0xA4, 0x89, 0xC3, 0xA0, 0x86, 0xC3, 0x98, 0x77, 0xB6, 0x87, 0x54, 0xA9, 0x71, 0x3A, 0xA8, 0x61, 0x28, 0xA3, 0x60, 0x23, 0xB0, 0x6D, 0x2E, 0xAD, 0x6D, 0x33, 0xAB, 0x68, 0x29, 0xA8, 0x6B, 0x33, 0xAF, 0x6C, 0x2D, 0xA3, 0x5B, 0x15,
    0xA5, 0x5A, 0x15, 0xAA, 0x5F, 0x1A, 0xBC, 0x7A, 0x3F, 0xAA, 0x70, 0x3F, 0xBC, 0x8B, 0x63, 0xBE, 0x9B, 0x81, 0xCB, 0xAA, 0x96, 0xCB, 0xB3, 0x9D, 0xD3, 0xC2, 0xAF, 0xCF, 0xB8, 0xA9, 0xD1, 0xC0, 0xB3, 0xDA, 0xCB, 0xBB, 0xC0, 0xA4, 0x93, 0xC0,
    0xA1, 0x87, 0xBE, 0x9C, 0x7F, 0xB8, 0x95, 0x74, 0x00, 0x00, 0x9E, 0x6B, 0x39, 0x86, 0x4D, 0x19, 0x93, 0x53, 0x1D, 0x93, 0x57, 0x1B, 0x95, 0x58, 0x20, 0x97, 0x59, 0x23, 0x99, 0x61, 0x2A, 0x9D, 0x64, 0x30, 0xA0, 0x69, 0x36, 0xA4, 0x6D, 0x3A,
    0xA8, 0x70, 0x3F, 0xA8, 0x70, 0x3F, 0xAB, 0x73, 0x42, 0xA7, 0x73, 0x44, 0xA7, 0x73, 0x44, 0xA9, 0x75, 0x46, 0xAF, 0x77, 0x48, 0xB1, 0x79, 0x4A, 0xAE, 0x76, 0x47, 0xAE, 0x76, 0x47, 0xAE, 0x76, 0x47, 0xAE, 0x76, 0x47, 0xB1, 0x79, 0x4A, 0xB1,
    0x7A, 0x4D, 0xB4, 0x80, 0x57, 0xB7, 0x84, 0x5C, 0xB8, 0x87, 0x5B, 0xB9, 0x88, 0x5C, 0xB9, 0x88, 0x5C, 0xB9, 0x88, 0x5C, 0xB2, 0x81, 0x55, 0xBC, 0x8B, 0x5F, 0xBB, 0x92, 0x71, 0xC0, 0x97, 0x76, 0xC4, 0x9B, 0x7A, 0xC6, 0x9D, 0x7C, 0xC7, 0x9F,
    0x82, 0xC2, 0x9D, 0x81, 0xC5, 0xA0, 0x8A, 0xC5, 0xA3, 0x8C, 0xCA, 0xAB, 0x94, 0xCE, 0xB2, 0x9A, 0xCB, 0xAC, 0x97, 0xC1, 0x99, 0x7C, 0xB2, 0x83, 0x50, 0xB3, 0x84, 0x51, 0xB3, 0x72, 0x3B, 0xA4, 0x61, 0x22, 0xA6, 0x60, 0x1D, 0xA9, 0x5F, 0x24,
    0xA5, 0x5F, 0x1C, 0xA0, 0x5B, 0x16, 0xA1, 0x5B, 0x15, 0x9F, 0x59, 0x13, 0xA2, 0x59, 0x15, 0xA5, 0x5A, 0x15, 0x9F, 0x5F, 0x25, 0xC0, 0x86, 0x55, 0xAC, 0x83, 0x62, 0xAB, 0x89, 0x71, 0xC0, 0x9D, 0x83, 0xCE, 0xBA, 0xA8, 0xDE, 0xCE, 0xBE, 0xCB,
    0xB0, 0xA5, 0xD7, 0xC6, 0xB9, 0xD0, 0xC1, 0xB1, 0xCA, 0xAE, 0x9D, 0xC4, 0xA5, 0x8C, 0xBA, 0x9A, 0x7D, 0xBE, 0x9A, 0x7C, 0x00, 0x00, 0x88, 0x4C, 0x16, 0x8A, 0x4E, 0x18, 0x8E, 0x52, 0x1C, 0x95, 0x56, 0x1C, 0x93, 0x58, 0x20, 0x96, 0x5C, 0x28,
    0x98, 0x60, 0x2F, 0x9D, 0x65, 0x34, 0xA2, 0x6A, 0x39, 0xA4, 0x6C, 0x3B, 0xA5, 0x71, 0x42, 0xA8, 0x74, 0x45, 0xA8, 0x74, 0x45, 0xA8, 0x74, 0x45, 0xA9, 0x75, 0x46, 0xAC, 0x78, 0x49, 0xAD, 0x79, 0x4A, 0xAD, 0x79, 0x4A, 0xAC, 0x78, 0x49, 0xAF,
    0x77, 0x48, 0xAF, 0x77, 0x48, 0xAE, 0x76, 0x47, 0xAE, 0x7A, 0x4B, 0xB5, 0x81, 0x53, 0xB5, 0x85, 0x5B, 0xB9, 0x88, 0x60, 0xB9, 0x88, 0x60, 0xB9, 0x88, 0x60, 0xB9, 0x88, 0x60, 0xBB, 0x8F, 0x66, 0xBB, 0x8F, 0x66, 0xB2, 0x86, 0x5D, 0xBC, 0x8F,
    0x69, 0xC3, 0x98, 0x77, 0xC5, 0x9F, 0x86, 0xC6, 0xA1, 0x85, 0xC6, 0xA4, 0x8C, 0xC5, 0xA5, 0x8E, 0xC7, 0xA6, 0x92, 0xCC, 0xAC, 0x99, 0xCE, 0xB1, 0xA2, 0xD0, 0xB5, 0xA7, 0xD0, 0xB7, 0xA7, 0xBD, 0x9A, 0x80, 0xB7, 0x80, 0x53, 0xB9, 0x8C, 0x6A,
    0xBF, 0x8D, 0x59, 0xBA, 0x80, 0x4C, 0xA3, 0x63, 0x28, 0xAB, 0x6A, 0x2D, 0xA4, 0x5D, 0x1D, 0xA1, 0x56, 0x11, 0xA4, 0x59, 0x14, 0xA3, 0x58, 0x13, 0xA3, 0x58, 0x13, 0xA4, 0x59, 0x14, 0xA5, 0x67, 0x31, 0xB6, 0x81, 0x56, 0xB8, 0x8F, 0x6E, 0xBA,
    0x93, 0x77, 0xBF, 0x96, 0x75, 0xCD, 0xB4, 0xA4, 0xD1, 0xBB, 0xAF, 0xCF, 0xBC, 0xB4, 0xDA, 0xC7, 0xB8, 0xD9, 0xC3, 0xB7, 0xC9, 0xB0, 0xA6, 0xCB, 0xB3, 0x9D, 0xB6, 0x93, 0x72, 0xB9, 0x92, 0x72, 0x00, 0x00, 0x88, 0x4C, 0x16, 0x8A, 0x4E, 0x18,
    0x8E, 0x52, 0x1C, 0x95, 0x56, 0x1C, 0x93, 0x58, 0x20, 0x95, 0x5B, 0x27, 0x9B, 0x63, 0x32, 0x9F, 0x67, 0x36, 0xA4, 0x6C, 0x3B, 0xA6, 0x6E, 0x3D, 0xA7, 0x73, 0x44, 0xAA, 0x76, 0x47, 0xAA, 0x76, 0x47, 0xAA, 0x76, 0x47, 0xAB, 0x77, 0x48, 0xAE,
    0x7A, 0x4B, 0xAD, 0x79, 0x4A, 0xAD, 0x79, 0x4A, 0xAC, 0x78, 0x49, 0xAF, 0x79, 0x4A, 0xAF, 0x79, 0x4A, 0xAF, 0x79, 0x4A, 0xAE, 0x7C, 0x4E, 0xB4, 0x83, 0x57, 0xB5, 0x87, 0x5E, 0xB7, 0x8A, 0x64, 0xBE, 0x8F, 0x69, 0xBE, 0x8F, 0x69, 0xBE, 0x8F,
    0x69, 0xB5, 0x89, 0x60, 0xB7, 0x8B, 0x62, 0xB8, 0x8C, 0x63, 0xBF, 0x92, 0x70, 0xC0, 0x97, 0x77, 0xC6, 0xA2, 0x8A, 0xC7, 0xA5, 0x8D, 0xC9, 0xAA, 0x93, 0xCC, 0xAE, 0x9B, 0xCF, 0xB4, 0xA0, 0xD3, 0xB9, 0xA8, 0xD3, 0xBC, 0xAD, 0xD7, 0xBF, 0xB3,
    0xCC, 0xBA, 0xA9, 0xC5, 0xAB, 0x93, 0xB0, 0x85, 0x5C, 0x9C, 0x66, 0x37, 0xA7, 0x6A, 0x2A, 0xA5, 0x60, 0x21, 0xA4, 0x63, 0x2C, 0xAA, 0x67, 0x2E, 0xA8, 0x60, 0x24, 0xA4, 0x59, 0x14, 0xA1, 0x56, 0x11, 0xA1, 0x56, 0x11, 0x9F, 0x56, 0x12, 0x9F,
    0x56, 0x12, 0xAC, 0x70, 0x3C, 0xB3, 0x7F, 0x56, 0xBE, 0x96, 0x79, 0xBC, 0x99, 0x7F, 0xC4, 0x9C, 0x7F, 0xD5, 0xB9, 0xA8, 0xD6, 0xBC, 0xAE, 0xD2, 0xBA, 0xAE, 0xE0, 0xCD, 0xC0, 0xBF, 0xA8, 0x99, 0xC8, 0xAB, 0x9C, 0xCE, 0xB4, 0xAD, 0xB7, 0x94,
    0x7A, 0xB8, 0x95, 0x73, 0x00, 0x00, 0x88, 0x4C, 0x16, 0x8A, 0x4E, 0x18, 0x8F, 0x53, 0x1D, 0x95, 0x56, 0x1C, 0x96, 0x5B, 0x23, 0x9A, 0x60, 0x2C, 0x9E, 0x66, 0x35, 0xA2, 0x6A, 0x39, 0xA5, 0x6D, 0x3C, 0xAA, 0x72, 0x41, 0xA7, 0x73, 0x44, 0xAB,
    0x77, 0x48, 0xAD, 0x79, 0x4A, 0xAD, 0x79, 0x4A, 0xAD, 0x79, 0x4A, 0xAD, 0x79, 0x4A, 0xB0, 0x7C, 0x4D, 0xB0, 0x7C, 0x4D, 0xAD, 0x79, 0x4A, 0xAA, 0x7A, 0x4A, 0xAA, 0x7A, 0x4A, 0xAD, 0x7D, 0x4D, 0xAF, 0x7F, 0x55, 0xB3, 0x85, 0x5C, 0xB6, 0x8A,
    0x65, 0xBC, 0x92, 0x6F, 0xC0, 0x93, 0x71, 0xC2, 0x95, 0x73, 0xBF, 0x92, 0x70, 0xB9, 0x8D, 0x64, 0xB0, 0x84, 0x5B, 0xBC, 0x90, 0x67, 0xBF, 0x96, 0x75, 0xC0, 0x99, 0x7D, 0xC1, 0xA0, 0x8C, 0xC7, 0xAC, 0x97, 0xCE, 0xB6, 0xA2, 0xD1, 0xBA, 0xAA,
    0xD8, 0xC4, 0xB3, 0xD8, 0xC5, 0xB6, 0xD5, 0xC4, 0xB9, 0xCF, 0xC0, 0xB7, 0xD0, 0xB8, 0xA6, 0xCB, 0xAD, 0x9C, 0xCE, 0xA4, 0x87, 0xA6, 0x6C, 0x38, 0x9C, 0x5B, 0x16, 0x9F, 0x56, 0x12, 0x99, 0x5C, 0x1A, 0x9A, 0x5C, 0x16, 0x98, 0x53, 0x0D, 0x9F,
    0x54, 0x0F, 0x9F, 0x54, 0x0F, 0x9F, 0x54, 0x0F, 0x9B, 0x54, 0x14, 0x9E, 0x57, 0x17, 0xAB, 0x71, 0x40, 0xBD, 0x8C, 0x66, 0xC0, 0x9A, 0x81, 0xBF, 0x9F, 0x88, 0xBE, 0x98, 0x7F, 0xB9, 0x96, 0x82, 0xD1, 0xB0, 0xA0, 0xD0, 0xB1, 0xA2, 0xD6, 0xC4,
    0xB9, 0xD6, 0xBD, 0xAD, 0xB8, 0x94, 0x7C, 0xBA, 0x9D, 0x82, 0xBD, 0x93, 0x6E, 0xBA, 0x8F, 0x68, 0x00, 0x00, 0x89, 0x4E, 0x16, 0x8B, 0x50, 0x18, 0x91, 0x56, 0x1E, 0x94, 0x55, 0x22, 0x98, 0x5E, 0x2A, 0x9E, 0x65, 0x31, 0x9F, 0x6D, 0x38, 0xA3,
    0x71, 0x3C, 0xA4, 0x70, 0x41, 0xA6, 0x72, 0x43, 0xA9, 0x76, 0x4B, 0xAA, 0x77, 0x4C, 0xAD, 0x7A, 0x4F, 0xAD, 0x79, 0x51, 0xAD, 0x79, 0x51, 0xAF, 0x7B, 0x53, 0xB1, 0x80, 0x50, 0xB1, 0x80, 0x50, 0xAE, 0x7D, 0x4D, 0xB2, 0x7C, 0x4D, 0xAD, 0x7B,
    0x4D, 0xB1, 0x7F, 0x55, 0xB3, 0x85, 0x5B, 0xB6, 0x8A, 0x61, 0xBC, 0x92, 0x6D, 0xBC, 0x94, 0x71, 0xBF, 0x97, 0x7A, 0xC2, 0x9A, 0x7D, 0xBE, 0x96, 0x79, 0xBE, 0x8F, 0x69, 0xB3, 0x86, 0x64, 0xBB, 0x90, 0x6F, 0xC0, 0x9C, 0x7E, 0xC3, 0xA1, 0x84,
    0xC4, 0xA5, 0x8C, 0xC9, 0xB0, 0xA0, 0xD1, 0xBC, 0xAD, 0xD5, 0xC1, 0xB6, 0xDA, 0xC6, 0xBB, 0xD9, 0xC7, 0xC0, 0xDD, 0xC7, 0xBB, 0xD6, 0xBB, 0xA7, 0xC8, 0x9F, 0x7F, 0xB9, 0x9B, 0x8A, 0xCB, 0x9E, 0x7C, 0xA2, 0x65, 0x33, 0x97, 0x59, 0x12, 0x97,
    0x56, 0x0B, 0x9A, 0x53, 0x10, 0x9A, 0x53, 0x10, 0x99, 0x52, 0x0F, 0x9A, 0x53, 0x10, 0x9A, 0x53, 0x10, 0x9A, 0x53, 0x10, 0x9A, 0x53, 0x10, 0x9F, 0x56, 0x12, 0xA8, 0x70, 0x41, 0xBB, 0x92, 0x77, 0xBA, 0x99, 0x7F, 0xBD, 0x9C, 0x82, 0xB6, 0x95,
    0x7B, 0xB8, 0x97, 0x83, 0xB7, 0x93, 0x7B, 0xB6, 0x90, 0x77, 0xBA, 0x98, 0x88, 0xBB, 0x9D, 0x92, 0xB7, 0x95, 0x85, 0xBC, 0x90, 0x67, 0xB4, 0x88, 0x5F, 0xB7, 0x8B, 0x62, 0x00, 0x00, 0x89, 0x4F, 0x1B, 0x8B, 0x51, 0x1D, 0x93, 0x59, 0x25, 0x97,
    0x5C, 0x2A, 0x9E, 0x65, 0x32, 0x9F, 0x6A, 0x37, 0x9F, 0x6F, 0x3B, 0xA3, 0x72, 0x40, 0xA7, 0x75, 0x47, 0xA9, 0x76, 0x4B, 0xAB, 0x78, 0x4D, 0xAC, 0x79, 0x4E, 0xAF, 0x7C, 0x51, 0xAC, 0x7B, 0x53, 0xAC, 0x7B, 0x53, 0xAE, 0x7D, 0x55, 0xB1, 0x82,
    0x56, 0xB1, 0x82, 0x56, 0xAE, 0x7F, 0x53, 0xAF, 0x7D, 0x4F, 0xB4, 0x82, 0x58, 0xB4, 0x86, 0x5D, 0xB7, 0x8B, 0x66, 0xBA, 0x90, 0x6D, 0xBD, 0x96, 0x76, 0xC4, 0x9E, 0x80, 0xBE, 0x99, 0x7D, 0xC1, 0x9C, 0x80, 0xBD, 0x98, 0x7C, 0xC1, 0x96, 0x75,
    0xC1, 0x99, 0x7C, 0xC4, 0x9D, 0x81, 0xC5, 0xA5, 0x88, 0xC2, 0xA3, 0x8A, 0xC9, 0xAC, 0x97, 0xCC, 0xB3, 0xA3, 0xD4, 0xBF, 0xB0, 0xD7, 0xC3, 0xB8, 0xDF, 0xC9, 0xBD, 0xDA, 0xC6, 0xBB, 0xD5, 0xBA, 0xA5, 0xA6, 0x82, 0x64, 0xAA, 0x70, 0x3C, 0xA8,
    0x78, 0x4E, 0xA9, 0x75, 0x46, 0xA0, 0x63, 0x2B, 0x99, 0x58, 0x13, 0x9A, 0x53, 0x0F, 0x9A, 0x53, 0x10, 0x9A, 0x53, 0x10, 0x97, 0x50, 0x0D, 0x97, 0x50, 0x0D, 0x97, 0x50, 0x0D, 0x97, 0x50, 0x0D, 0x98, 0x51, 0x11, 0x99, 0x50, 0x0C, 0xA6, 0x6A,
    0x36, 0xBB, 0x8D, 0x6B, 0xC0, 0x9A, 0x7A, 0xBD, 0x97, 0x77, 0xB6, 0x90, 0x70, 0xC0, 0x93, 0x6E, 0xBA, 0x89, 0x61, 0xB1, 0x7F, 0x55, 0xBA, 0x8E, 0x65, 0xC0, 0x98, 0x75, 0xB6, 0x8A, 0x61, 0xAD, 0x7C, 0x50, 0xB8, 0x87, 0x5B, 0xB6, 0x85, 0x59,
    0x00, 0x00, 0x8B, 0x54, 0x21, 0x8F, 0x58, 0x25, 0x97, 0x60, 0x2D, 0x9D, 0x62, 0x34, 0x9D, 0x67, 0x38, 0xA1, 0x6D, 0x3E, 0xA3, 0x75, 0x45, 0xA5, 0x77, 0x47, 0xA7, 0x77, 0x4D, 0xA9, 0x79, 0x4F, 0xAD, 0x7A, 0x4F, 0xAD, 0x7A, 0x4F, 0xB1, 0x7E,
    0x53, 0xAE, 0x80, 0x57, 0xB0, 0x82, 0x59, 0xB0, 0x82, 0x59, 0xB1, 0x83, 0x59, 0xB1, 0x83, 0x59, 0xB1, 0x83, 0x59, 0xB6, 0x84, 0x5A, 0xB4, 0x86, 0x5D, 0xBA, 0x8D, 0x68, 0xBE, 0x92, 0x73, 0xC2, 0x98, 0x7B, 0xC3, 0x9B, 0x82, 0xC3, 0x9D, 0x85,
    0xC3, 0x9F, 0x87, 0xC5, 0xA1, 0x89, 0xC0, 0x9C, 0x84, 0xBF, 0x98, 0x7C, 0xC6, 0xA2, 0x8A, 0xC8, 0xA6, 0x8F, 0xC8, 0xA9, 0x90, 0xC6, 0xA7, 0x90, 0xCC, 0xB1, 0x9D, 0xD0, 0xB7, 0xA7, 0xD5, 0xC0, 0xB1, 0xD8, 0xC4, 0xB9, 0xDE, 0xC8, 0xBC, 0xD2,
    0xBC, 0xB0, 0xC6, 0xA4, 0x87, 0xAE, 0x83, 0x5C, 0xBA, 0x88, 0x5E, 0xA6, 0x75, 0x49, 0xA3, 0x6E, 0x3C, 0x9C, 0x5C, 0x21, 0x99, 0x54, 0x0F, 0x9A, 0x50, 0x10, 0x97, 0x50, 0x0D, 0x97, 0x50, 0x0D, 0x97, 0x50, 0x0D, 0x97, 0x50, 0x0D, 0x97, 0x50,
    0x0D, 0x97, 0x50, 0x0D, 0x96, 0x51, 0x12, 0x9D, 0x54, 0x10, 0x92, 0x52, 0x18, 0xBD, 0x89, 0x60, 0xB2, 0x88, 0x63, 0xB1, 0x87, 0x62, 0xAF, 0x85, 0x60, 0xB0, 0x7E, 0x54, 0xAF, 0x7B, 0x4D, 0xAF, 0x79, 0x4A, 0xB7, 0x7B, 0x4F, 0xB6, 0x7F, 0x58,
    0xC1, 0x85, 0x59, 0xB0, 0x79, 0x4C, 0xB3, 0x7C, 0x4F, 0xB4, 0x7D, 0x50, 0x00, 0x00, 0x93, 0x5B, 0x2A, 0x97, 0x5F, 0x2E, 0x9A, 0x62, 0x31, 0x9A, 0x69, 0x39, 0xA2, 0x74, 0x44, 0xA2, 0x77, 0x46, 0xAB, 0x7C, 0x50, 0xA9, 0x7A, 0x4E, 0xAB, 0x7C,
    0x50, 0xAB, 0x7C, 0x50, 0xAF, 0x7E, 0x50, 0xB1, 0x82, 0x56, 0xB0, 0x84, 0x5B, 0xB2, 0x83, 0x5D, 0xB0, 0x85, 0x5E, 0xAE, 0x87, 0x60, 0xB3, 0x87, 0x62, 0xB6, 0x8A, 0x65, 0xB3, 0x87, 0x62, 0xB5, 0x8A, 0x69, 0xB8, 0x91, 0x71, 0xBD, 0x96, 0x7A,
    0xBC, 0x9A, 0x82, 0xC2, 0xA0, 0x88, 0xC5, 0xA3, 0x8B, 0xC5, 0xA3, 0x8B, 0xC6, 0xA5, 0x91, 0xC7, 0xA6, 0x92, 0xC5, 0xA4, 0x90, 0xC2, 0xA3, 0x8A, 0xC9, 0xAA, 0x91, 0xCB, 0xAC, 0x93, 0xC9, 0xAC, 0x97, 0xCA, 0xAF, 0x9B, 0xCF, 0xB6, 0xA6, 0xCB,
    0xBA, 0xAD, 0xD6, 0xC5, 0xB8, 0xD8, 0xC7, 0xBA, 0xDC, 0xC7, 0xBF, 0xD2, 0xB9, 0xA9, 0xBC, 0xA1, 0x8D, 0x95, 0x68, 0x42, 0xAD, 0x6C, 0x39, 0x92, 0x52, 0x17, 0x95, 0x54, 0x10, 0x94, 0x4E, 0x0B, 0x97, 0x51, 0x0E, 0x96, 0x50, 0x0D, 0x96, 0x50,
    0x0D, 0x96, 0x50, 0x0D, 0x95, 0x4F, 0x0C, 0x96, 0x4F, 0x10, 0x96, 0x4F, 0x10, 0x96, 0x4F, 0x10, 0x97, 0x54, 0x09, 0x98, 0x55, 0x0A, 0x96, 0x5A, 0x1E, 0xBA, 0x85, 0x53, 0xBC, 0x90, 0x6B, 0xB1, 0x84, 0x5E, 0xB7, 0x89, 0x60, 0xAA, 0x82, 0x5F,
    0xAC, 0x7B, 0x4D, 0xB2, 0x7D, 0x4A, 0xAB, 0x7A, 0x4E, 0xB1, 0x80, 0x54, 0xAB, 0x7A, 0x4E, 0xAB, 0x71, 0x3D, 0xA6, 0x72, 0x44, 0xAE, 0x81, 0x5B, 0x00, 0x00, 0x93, 0x5E, 0x2C, 0x98, 0x63, 0x31, 0xA1, 0x6C, 0x3A, 0xA3, 0x71, 0x43, 0xA5, 0x77,
    0x48, 0xA5, 0x79, 0x4A, 0xAD, 0x7E, 0x52, 0xAB, 0x7C, 0x50, 0xAB, 0x7C, 0x50, 0xAB, 0x7C, 0x50, 0xAF, 0x81, 0x52, 0xAF, 0x81, 0x57, 0xAF, 0x84, 0x5B, 0xB4, 0x87, 0x62, 0xB8, 0x8E, 0x69, 0xB6, 0x91, 0x6B, 0xBB, 0x90, 0x6F, 0xBA, 0x8F, 0x6E,
    0xC1, 0x96, 0x75, 0xBE, 0x97, 0x77, 0xC3, 0x9D, 0x7F, 0xC2, 0x9F, 0x85, 0xC3, 0xA1, 0x8A, 0xC9, 0xA7, 0x90, 0xC9, 0xA7, 0x90, 0xC9, 0xA7, 0x90, 0xCA, 0xAB, 0x96, 0xCD, 0xAE, 0x99, 0xCA, 0xAB, 0x96, 0xC8, 0xA9, 0x92, 0xCA, 0xAB, 0x94, 0xCC,
    0xAD, 0x96, 0xCC, 0xB1, 0x9D, 0xCC, 0xB2, 0xA1, 0xD4, 0xBD, 0xAE, 0xD2, 0xC1, 0xB4, 0xD7, 0xC6, 0xB9, 0xD8, 0xC7, 0xBA, 0xD4, 0xC2, 0xBB, 0xC7, 0xAC, 0x98, 0xAE, 0x88, 0x68, 0x90, 0x5A, 0x25, 0x92, 0x51, 0x14, 0x97, 0x52, 0x13, 0x92, 0x4B,
    0x0C, 0x95, 0x4E, 0x0E, 0x98, 0x51, 0x11, 0x98, 0x51, 0x11, 0x94, 0x4D, 0x0D, 0x9A, 0x53, 0x13, 0x95, 0x4E, 0x0E, 0x96, 0x4F, 0x10, 0x96, 0x4F, 0x10, 0x98, 0x51, 0x12, 0x9B, 0x5E, 0x1C, 0x9D, 0x5E, 0x1A, 0x9F, 0x63, 0x2D, 0xA7, 0x73, 0x45,
    0xB1, 0x82, 0x5C, 0xB6, 0x87, 0x61, 0xB4, 0x85, 0x5F, 0xB6, 0x88, 0x5E, 0xB5, 0x82, 0x50, 0xA4, 0x6E, 0x39, 0xA8, 0x74, 0x45, 0xB3, 0x7F, 0x50, 0xAB, 0x77, 0x48, 0xB1, 0x7A, 0x47, 0xAC, 0x7A, 0x4C, 0xBF, 0x91, 0x68, 0x00, 0x00, 0x97, 0x66,
    0x34, 0x9D, 0x6C, 0x3A, 0xA1, 0x70, 0x3E, 0xA5, 0x71, 0x48, 0xAB, 0x7B, 0x51, 0xAF, 0x81, 0x57, 0xAA, 0x7B, 0x4F, 0xA6, 0x77, 0x4B, 0xAC, 0x7D, 0x51, 0xB0, 0x81, 0x55, 0xAD, 0x81, 0x58, 0xAF, 0x84, 0x5D, 0xB0, 0x88, 0x65, 0xB8, 0x8D, 0x6C,
    0xBA, 0x94, 0x72, 0xB7, 0x94, 0x72, 0xBA, 0x97, 0x7D, 0xBE, 0x9B, 0x81, 0xBE, 0x9B, 0x81, 0xC0, 0xA0, 0x83, 0xC0, 0xA3, 0x88, 0xC1, 0xA5, 0x8D, 0xC4, 0xA6, 0x93, 0xC6, 0xA8, 0x95, 0xC6, 0xA8, 0x95, 0xC8, 0xAA, 0x97, 0xC9, 0xAE, 0x99, 0xCA,
    0xAF, 0x9A, 0xCA, 0xAF, 0x9A, 0xC9, 0xAE, 0x9A, 0xC7, 0xAC, 0x98, 0xCC, 0xB1, 0x9D, 0xCC, 0xB3, 0xA3, 0xCE, 0xB7, 0xA8, 0xD2, 0xBE, 0xB3, 0xD6, 0xC5, 0xB8, 0xD8, 0xC7, 0xBA, 0xD8, 0xC7, 0xBA, 0xCB, 0xBF, 0xB3, 0xC3, 0xA3, 0x8C, 0xC2, 0x98,
    0x75, 0xB6, 0x87, 0x4A, 0x9A, 0x5D, 0x1F, 0x94, 0x56, 0x16, 0x8F, 0x4C, 0x0D, 0x96, 0x4E, 0x12, 0x94, 0x4C, 0x10, 0x90, 0x48, 0x0C, 0x93, 0x4B, 0x0F, 0x95, 0x4D, 0x11, 0x95, 0x4D, 0x11, 0x93, 0x4C, 0x0D, 0x96, 0x4F, 0x10, 0x9B, 0x54, 0x15,
    0x97, 0x5B, 0x1F, 0x9B, 0x5B, 0x1B, 0x99, 0x57, 0x1C, 0xA5, 0x66, 0x33, 0xB0, 0x7C, 0x4D, 0xAE, 0x7E, 0x54, 0xAC, 0x80, 0x5B, 0xB2, 0x83, 0x57, 0xAB, 0x7C, 0x50, 0xAE, 0x7F, 0x53, 0xB5, 0x84, 0x58, 0xB7, 0x86, 0x5A, 0xB8, 0x87, 0x5B, 0xB3,
    0x82, 0x56, 0xAC, 0x7B, 0x4F, 0xB8, 0x85, 0x5A, 0x00, 0x00, 0x9A, 0x6B, 0x38, 0xA0, 0x71, 0x3E, 0xA4, 0x75, 0x42, 0xAC, 0x78, 0x50, 0xAC, 0x7B, 0x53, 0xAE, 0x80, 0x57, 0xAF, 0x80, 0x54, 0xAB, 0x7C, 0x50, 0xAE, 0x7F, 0x53, 0xB2, 0x83, 0x57,
    0xB1, 0x86, 0x5D, 0xB4, 0x8A, 0x65, 0xB5, 0x8F, 0x6C, 0xBF, 0x96, 0x76, 0xBC, 0x96, 0x76, 0xBE, 0x9D, 0x7C, 0xBD, 0x9B, 0x84, 0xC1, 0x9F, 0x88, 0xC3, 0xA1, 0x8A, 0xC2, 0xA5, 0x8A, 0xC2, 0xA6, 0x8D, 0xC1, 0xA9, 0x93, 0xC8, 0xAA, 0x99, 0xCB,
    0xAD, 0x9C, 0xCA, 0xAC, 0x9B, 0xCD, 0xAF, 0x9E, 0xC9, 0xB1, 0x9B, 0xCC, 0xB4, 0x9E, 0xCC, 0xB4, 0x9E, 0xCD, 0xB3, 0xA2, 0xCC, 0xB2, 0xA1, 0xD0, 0xB6, 0xA5, 0xD0, 0xB9, 0xAA, 0xD2, 0xBC, 0xB0, 0xD4, 0xC1, 0xB9, 0xDB, 0xCA, 0xBD, 0xD8, 0xC7,
    0xBA, 0xD5, 0xC4, 0xB7, 0xC6, 0xB9, 0xA9, 0xC8, 0xA6, 0x8F, 0xB7, 0x91, 0x78, 0xA4, 0x80, 0x50, 0xA9, 0x70, 0x3C, 0x8E, 0x54, 0x18, 0x8C, 0x53, 0x0E, 0xA0, 0x57, 0x1D, 0x94, 0x4B, 0x11, 0x90, 0x47, 0x0D, 0x91, 0x48, 0x0E, 0x93, 0x4A, 0x10,
    0x93, 0x4A, 0x10, 0x93, 0x4C, 0x0D, 0x96, 0x4F, 0x10, 0x93, 0x4C, 0x0D, 0x90, 0x4F, 0x12, 0x99, 0x53, 0x10, 0xA1, 0x57, 0x17, 0xAA, 0x61, 0x27, 0xB1, 0x79, 0x48, 0xB7, 0x85, 0x5B, 0xB4, 0x87, 0x65, 0xB3, 0x88, 0x61, 0xBA, 0x90, 0x6B, 0xB7,
    0x8F, 0x6C, 0xB5, 0x89, 0x64, 0xB1, 0x85, 0x60, 0xB8, 0x8C, 0x67, 0xB8, 0x88, 0x5E, 0xB4, 0x83, 0x57, 0xAF, 0x7D, 0x4F, 0x00, 0x00, 0xA1, 0x72, 0x46, 0xA2, 0x73, 0x47, 0xA7, 0x78, 0x4C, 0xA8, 0x77, 0x4F, 0xA8, 0x77, 0x4F, 0xAA, 0x79, 0x51,
    0xAF, 0x7E, 0x52, 0xB0, 0x80, 0x56, 0xAD, 0x80, 0x5A, 0xB1, 0x85, 0x60, 0xB3, 0x87, 0x62, 0xB8, 0x8D, 0x6C, 0xBA, 0x93, 0x73, 0xC0, 0x99, 0x7D, 0xBE, 0x9A, 0x82, 0xC0, 0x9E, 0x87, 0xC1, 0x9E, 0x8A, 0xC3, 0xA0, 0x8C, 0xC5, 0xA2, 0x8E, 0xC7,
    0xA4, 0x90, 0xC9, 0xAA, 0x95, 0xCA, 0xAD, 0x98, 0xC8, 0xAE, 0x9D, 0xCA, 0xB0, 0x9F, 0xCD, 0xB3, 0xA2, 0xCD, 0xB3, 0xA2, 0xCE, 0xB4, 0xA4, 0xD0, 0xB6, 0xA6, 0xD2, 0xB8, 0xA8, 0xD1, 0xBA, 0xAB, 0xD3, 0xBC, 0xAD, 0xD5, 0xBE, 0xAF, 0xD5, 0xBF,
    0xB3, 0xD5, 0xBF, 0xB3, 0xD9, 0xC3, 0xB7, 0xD7, 0xC6, 0xBB, 0xD8, 0xC5, 0xB8, 0xD2, 0xBE, 0xAD, 0xC5, 0xA6, 0x8F, 0xAE, 0x81, 0x5F, 0xA0, 0x68, 0x37, 0x93, 0x5E, 0x2C, 0x93, 0x56, 0x1C, 0x90, 0x4D, 0x14, 0x91, 0x47, 0x0F, 0x8D, 0x48, 0x0F,
    0x8D, 0x48, 0x0F, 0x8B, 0x46, 0x0D, 0x8F, 0x4A, 0x11, 0x8F, 0x4A, 0x11, 0x8E, 0x49, 0x10, 0x93, 0x4B, 0x0F, 0x93, 0x4B, 0x0F, 0x93, 0x4B, 0x0F, 0x90, 0x49, 0x0F, 0x98, 0x51, 0x12, 0x97, 0x57, 0x1C, 0x9C, 0x63, 0x2F, 0xB9, 0x8B, 0x61, 0xB5,
    0x89, 0x60, 0xBB, 0x91, 0x6C, 0xB9, 0x8F, 0x6A, 0xB9, 0x8F, 0x6A, 0xBA, 0x90, 0x6B, 0xB8, 0x8D, 0x66, 0xB4, 0x89, 0x62, 0xB3, 0x88, 0x61, 0xB8, 0x8B, 0x69, 0xB4, 0x87, 0x61, 0xB3, 0x82, 0x5A, 0x00, 0x00, 0xA7, 0x78, 0x4C, 0xAA, 0x7B, 0x4F,
    0xA6, 0x77, 0x4B, 0xA9, 0x78, 0x50, 0xA9, 0x78, 0x50, 0xAD, 0x7C, 0x54, 0xAC, 0x7B, 0x53, 0xB1, 0x82, 0x5C, 0xB3, 0x86, 0x64, 0xB8, 0x8D, 0x6C, 0xBA, 0x8F, 0x6E, 0xB7, 0x90, 0x70, 0xBB, 0x94, 0x78, 0xBD, 0x9A, 0x80, 0xBD, 0x9D, 0x86, 0xBE,
    0x9F, 0x8A, 0xC1, 0xA2, 0x8D, 0xC3, 0xA4, 0x8F, 0xC4, 0xA5, 0x90, 0xC7, 0xA8, 0x93, 0xCA, 0xAD, 0x98, 0xC9, 0xB1, 0x9B, 0xC8, 0xB2, 0xA0, 0xCA, 0xB4, 0xA2, 0xCA, 0xB4, 0xA2, 0xCC, 0xB6, 0xA4, 0xCF, 0xB8, 0xA8, 0xD0, 0xB9, 0xA9, 0xD2, 0xBB,
    0xAB, 0xD2, 0xBC, 0xB0, 0xD3, 0xBD, 0xB1, 0xD6, 0xC0, 0xB4, 0xD7, 0xC1, 0xB5, 0xD5, 0xBF, 0xB3, 0xD5, 0xBF, 0xB3, 0xD1, 0xC0, 0xB3, 0xD2, 0xBE, 0xAD, 0xCD, 0xB7, 0xA5, 0xC3, 0xA5, 0x88, 0x9F, 0x6C, 0x44, 0x99, 0x56, 0x19, 0x92, 0x55, 0x15,
    0x90, 0x50, 0x16, 0x8C, 0x49, 0x10, 0x8F, 0x4A, 0x11, 0x8C, 0x47, 0x0E, 0x8B, 0x46, 0x0D, 0x8B, 0x46, 0x0D, 0x8B, 0x46, 0x0D, 0x8D, 0x48, 0x0F, 0x8E, 0x49, 0x10, 0x92, 0x4A, 0x0E, 0x92, 0x4A, 0x0E, 0x93, 0x4B, 0x0F, 0x8F, 0x4A, 0x11, 0x91,
    0x4B, 0x0F, 0x8D, 0x4E, 0x14, 0xB1, 0x7A, 0x47, 0xB0, 0x82, 0x58, 0xB9, 0x8D, 0x64, 0xB8, 0x8E, 0x69, 0xB8, 0x89, 0x63, 0xAF, 0x80, 0x5A, 0xAC, 0x7D, 0x57, 0xB0, 0x82, 0x58, 0xAD, 0x7F, 0x55, 0xB0, 0x82, 0x58, 0xB2, 0x85, 0x5F, 0xB6, 0x85,
    0x5D, 0xB1, 0x80, 0x54, 0x00, 0x00, 0xA7, 0x78, 0x4C, 0xA4, 0x75, 0x49, 0xA4, 0x75, 0x49, 0xAB, 0x7A, 0x52, 0xAB, 0x7A, 0x52, 0xAF, 0x7E, 0x56, 0xAD, 0x80, 0x5A, 0xB2, 0x86, 0x61, 0xB4, 0x8B, 0x6A, 0xB9, 0x92, 0x72, 0xBB, 0x94, 0x74, 0xBB,
    0x94, 0x78, 0xBC, 0x99, 0x7F, 0xC0, 0x9E, 0x87, 0xC1, 0xA1, 0x8E, 0xC1, 0xA3, 0x92, 0xC1, 0xA4, 0x8F, 0xC4, 0xA7, 0x92, 0xC7, 0xAA, 0x95, 0xCA, 0xAD, 0x98, 0xCB, 0xB3, 0x9D, 0xCA, 0xB3, 0x9D, 0xC8, 0xB4, 0xA2, 0xCA, 0xB6, 0xA4, 0xCA, 0xB6,
    0xA4, 0xCD, 0xB9, 0xA7, 0xCD, 0xB9, 0xA8, 0xD0, 0xBC, 0xAB, 0xD2, 0xBE, 0xAD, 0xD0, 0xBD, 0xB5, 0xD2, 0xBF, 0xB7, 0xD4, 0xC1, 0xB9, 0xD9, 0xC3, 0xB7, 0xD7, 0xC1, 0xB5, 0xD2, 0xBC, 0xB0, 0xCB, 0xB7, 0xA6, 0xCD, 0xB5, 0xA3, 0xC5, 0xAD, 0x97,
    0xCC, 0xAA, 0x9D, 0xCA, 0xA6, 0x88, 0x96, 0x5E, 0x27, 0x8F, 0x4B, 0x10, 0x99, 0x56, 0x1D, 0x9A, 0x5A, 0x20, 0x8C, 0x4D, 0x13, 0x8C, 0x47, 0x0E, 0x8B, 0x46, 0x0D, 0x8B, 0x46, 0x0D, 0x8B, 0x46, 0x0D, 0x8D, 0x48, 0x0F, 0x8E, 0x49, 0x10, 0x92,
    0x4A, 0x0E, 0x92, 0x4A, 0x0E, 0x90, 0x48, 0x0C, 0x88, 0x46, 0x11, 0x8A, 0x47, 0x0E, 0x87, 0x4B, 0x15, 0xB2, 0x7E, 0x4F, 0xAC, 0x7E, 0x54, 0xB2, 0x86, 0x5D, 0xB1, 0x87, 0x62, 0xB4, 0x80, 0x57, 0xAD, 0x79, 0x50, 0xAB, 0x77, 0x4E, 0xA5, 0x76,
    0x4A, 0xA7, 0x78, 0x4C, 0xAA, 0x7B, 0x4F, 0xAA, 0x79, 0x51, 0xAC, 0x7B, 0x4F, 0xAB, 0x77, 0x49, 0x00, 0x00, 0xAB, 0x7C, 0x50, 0xA6, 0x77, 0x4B, 0xA6, 0x77, 0x4B, 0xA9, 0x78, 0x50, 0xAE, 0x7D, 0x55, 0xB1, 0x80, 0x58, 0xAF, 0x84, 0x5D, 0xB3,
    0x87, 0x62, 0xB9, 0x8C, 0x6B, 0xBE, 0x90, 0x71, 0xBA, 0x93, 0x77, 0xBB, 0x98, 0x7E, 0xBD, 0x9B, 0x84, 0xBF, 0x9E, 0x8A, 0xC3, 0xA2, 0x8E, 0xC5, 0xA4, 0x90, 0xC4, 0xA7, 0x92, 0xC7, 0xAA, 0x95, 0xC9, 0xAC, 0x97, 0xC7, 0xAF, 0x9D, 0xC9, 0xB1,
    0x9F, 0xCC, 0xB4, 0xA2, 0xD0, 0xB7, 0xA7, 0xD0, 0xB7, 0xA7, 0xD0, 0xB7, 0xA7, 0xD0, 0xB7, 0xA7, 0xCF, 0xB9, 0xAD, 0xD1, 0xBB, 0xAF, 0xD1, 0xBB, 0xAF, 0xD0, 0xBF, 0xB2, 0xD2, 0xC1, 0xB4, 0xD4, 0xC3, 0xB6, 0xD7, 0xC1, 0xB5, 0xD7, 0xC1, 0xB5,
    0xD1, 0xBB, 0xAF, 0xCE, 0xB7, 0xA8, 0xCB, 0xB1, 0xA0, 0xC2, 0xA7, 0x93, 0xB8, 0x9E, 0x8D, 0xBD, 0x99, 0x7B, 0x97, 0x62, 0x2F, 0x8F, 0x57, 0x20, 0x93, 0x53, 0x18, 0x86, 0x4C, 0x11, 0x8D, 0x47, 0x11, 0x8A, 0x48, 0x13, 0x87, 0x45, 0x10, 0x87,
    0x45, 0x10, 0x8C, 0x47, 0x0E, 0x8C, 0x47, 0x0E, 0x8C, 0x47, 0x0E, 0x92, 0x4B, 0x11, 0x8C, 0x45, 0x0B, 0x8E, 0x47, 0x0D, 0x87, 0x45, 0x14, 0x8E, 0x48, 0x0C, 0x8A, 0x4D, 0x15, 0xA6, 0x77, 0x4B, 0xAE, 0x82, 0x59, 0xA9, 0x7E, 0x53, 0xB0, 0x7A,
    0x51, 0xAC, 0x79, 0x4E, 0xAA, 0x77, 0x4C, 0xA8, 0x75, 0x4A, 0xAA, 0x76, 0x47, 0xAA, 0x76, 0x47, 0xA9, 0x75, 0x46, 0xA8, 0x75, 0x43, 0xA6, 0x73, 0x41, 0xA6, 0x73, 0x41, 0x00, 0x00, 0xAE, 0x82, 0x59, 0xA5, 0x79, 0x50, 0xAD, 0x81, 0x58, 0xAB,
    0x81, 0x5C, 0xB0, 0x86, 0x61, 0xB1, 0x87, 0x62, 0xB6, 0x8E, 0x6B, 0xB8, 0x8F, 0x6E, 0xB8, 0x8E, 0x71, 0xBA, 0x8F, 0x74, 0xBD, 0x96, 0x7A, 0xC1, 0x9E, 0x84, 0xC1, 0x9F, 0x88, 0xC1, 0xA0, 0x8C, 0xC3, 0xA2, 0x8E, 0xC5, 0xA4, 0x90, 0xC6, 0xA9,
    0x94, 0xC9, 0xAC, 0x97, 0xCE, 0xB1, 0x9C, 0xC8, 0xB0, 0x9E, 0xCB, 0xB3, 0xA1, 0xCD, 0xB5, 0xA3, 0xCE, 0xB5, 0xA5, 0xD0, 0xB7, 0xA7, 0xD0, 0xB7, 0xA7, 0xD0, 0xB7, 0xA7, 0xCF, 0xB9, 0xAD, 0xD2, 0xBC, 0xB0, 0xD4, 0xBE, 0xB2, 0xD1, 0xC0, 0xB3,
    0xCF, 0xBE, 0xB1, 0xD1, 0xC0, 0xB3, 0xD9, 0xC3, 0xB7, 0xD9, 0xC3, 0xB7, 0xD2, 0xBC, 0xB0, 0xCD, 0xB6, 0xA7, 0xC9, 0xAF, 0x9E, 0xC0, 0xA5, 0x91, 0xC4, 0x9E, 0x7E, 0xA7, 0x79, 0x4F, 0x93, 0x5A, 0x22, 0x85, 0x4C, 0x14, 0x9E, 0x62, 0x2E, 0x87,
    0x47, 0x10, 0x88, 0x48, 0x0D, 0x88, 0x46, 0x11, 0x85, 0x43, 0x0E, 0x87, 0x45, 0x10, 0x8C, 0x47, 0x0E, 0x8C, 0x47, 0x0E, 0x8C, 0x47, 0x0E, 0x8F, 0x4C, 0x0F, 0x92, 0x4F, 0x12, 0x8C, 0x49, 0x0C, 0x89, 0x49, 0x0E, 0x8C, 0x49, 0x0C, 0x87, 0x44,
    0x0B, 0x9C, 0x5D, 0x2A, 0xA6, 0x75, 0x45, 0xA9, 0x7C, 0x50, 0xAA, 0x77, 0x4F, 0xA9, 0x76, 0x4B, 0xA7, 0x74, 0x49, 0xAB, 0x78, 0x4D, 0xA9, 0x75, 0x46, 0xAD, 0x79, 0x4A, 0xA8, 0x74, 0x45, 0xA6, 0x73, 0x41, 0xA7, 0x74, 0x42, 0xA6, 0x73, 0x41,
    0x00, 0x00, 0xAF, 0x84, 0x5D, 0xB1, 0x86, 0x5F, 0xB2, 0x87, 0x60, 0xB3, 0x8F, 0x6B, 0xB8, 0x94, 0x70, 0xB8, 0x94, 0x70, 0xB9, 0x94, 0x72, 0xBC, 0x96, 0x76, 0xBC, 0x95, 0x79, 0xBE, 0x96, 0x7D, 0xC1, 0x9A, 0x7E, 0xC1, 0x9E, 0x84, 0xC1, 0x9F,
    0x88, 0xC1, 0xA0, 0x8C, 0xC5, 0xA4, 0x90, 0xC7, 0xA6, 0x92, 0xC8, 0xAB, 0x96, 0xCB, 0xAE, 0x99, 0xCE, 0xB1, 0x9C, 0xCB, 0xB3, 0xA1, 0xCD, 0xB5, 0xA3, 0xCD, 0xB5, 0xA3, 0xCC, 0xB3, 0xA3, 0xCE, 0xB5, 0xA5, 0xD0, 0xB7, 0xA7, 0xD0, 0xB7, 0xA7,
    0xCF, 0xB9, 0xAD, 0xD2, 0xBC, 0xB0, 0xD4, 0xBE, 0xB2, 0xD1, 0xC0, 0xB3, 0xCF, 0xBE, 0xB1, 0xD1, 0xC0, 0xB3, 0xD7, 0xC1, 0xB5, 0xD7, 0xC1, 0xB5, 0xD2, 0xBC, 0xB0, 0xCF, 0xB8, 0xA9, 0xCB, 0xB1, 0xA0, 0xC4, 0xA9, 0x95, 0xC4, 0x9E, 0x7C, 0xA1,
    0x73, 0x49, 0x97, 0x62, 0x2F, 0xAE, 0x7B, 0x49, 0xAF, 0x74, 0x46, 0x88, 0x44, 0x0F, 0x85, 0x48, 0x0A, 0x86, 0x44, 0x0F, 0x85, 0x43, 0x0E, 0x87, 0x45, 0x10, 0x8C, 0x47, 0x0E, 0x8C, 0x47, 0x0E, 0x8C, 0x47, 0x0E, 0x93, 0x5A, 0x23, 0xAD, 0x74,
    0x3D, 0xA8, 0x6F, 0x38, 0x8A, 0x4A, 0x09, 0x8E, 0x4E, 0x0E, 0x8B, 0x46, 0x0D, 0x8F, 0x48, 0x0F, 0xA8, 0x71, 0x3E, 0xA9, 0x7B, 0x4C, 0xAB, 0x7A, 0x54, 0xAB, 0x78, 0x4D, 0xA4, 0x71, 0x46, 0xA9, 0x76, 0x4B, 0xA6, 0x72, 0x43, 0xAA, 0x76, 0x47,
    0xA8, 0x74, 0x45, 0xA9, 0x76, 0x44, 0xA4, 0x71, 0x3F, 0x9D, 0x6A, 0x38, 0x00, 0x00, 0x00
  };

  static unsigned char _acGIF_AnimatedDialog[] = {
    0x47, 0x49, 0x46, 0x38, 0x39, 0x61, 0x46, 0x00, 0x46, 0x00, 0xF7, 0x83, 0x00, 0x95, 0x95, 0x95, 0x80, 0x80, 0x80, 0xC0, 0xC0, 0xC0, 0x70, 0x70, 0x70, 0xFC, 0xFC, 0xFC, 0xB9, 0xD1, 0xEA, 0xA0, 0xBC, 0xD7, 0xA7, 0xC2, 0xDC, 0x9D, 0xB9, 0xD4,
    0xAB, 0xC5, 0xDF, 0xB2, 0xCB, 0xE4, 0xA4, 0xBF, 0xDA, 0xAE, 0xC8, 0xE2, 0xDF, 0xDF, 0xDF, 0xF2, 0xF2, 0xF2, 0xEC, 0xEC, 0xEC, 0xD8, 0xD8, 0xD8, 0xF0, 0xF0, 0xF0, 0xD4, 0xD4, 0xD4, 0xD0, 0xD0, 0xD0, 0xEE, 0xEE, 0xEE, 0xDC, 0xDC, 0xDC, 0x80,
    0x80, 0xFF, 0x40, 0x40, 0x40, 0xBC, 0xBC, 0xBC, 0xE0, 0xE0, 0xE0, 0xCA, 0xCA, 0xCA, 0xEF, 0xEF, 0xEF, 0x7F, 0x7F, 0xFE, 0xE8, 0xE8, 0xE8, 0x7D, 0x7D, 0xFC, 0x7B, 0x7B, 0xFA, 0x79, 0x79, 0xF8, 0x68, 0x68, 0xE8, 0x5D, 0x5D, 0xDD, 0x6C, 0x6C,
    0xEB, 0x65, 0x65, 0xE4, 0x70, 0x70, 0xEF, 0x3C, 0x3C, 0xBB, 0x63, 0x63, 0xE2, 0x41, 0x41, 0xC1, 0x67, 0x67, 0xE6, 0x3E, 0x3E, 0xBD, 0x5F, 0x5F, 0xDE, 0x43, 0x43, 0xC3, 0x6A, 0x6A, 0xE9, 0x45, 0x45, 0xC5, 0x75, 0x75, 0xF4, 0x20, 0x20, 0xA0,
    0x5A, 0x5A, 0xD9, 0x24, 0x24, 0xA3, 0x6E, 0x6E, 0xED, 0x5B, 0x5B, 0xDB, 0x22, 0x22, 0xA2, 0x1C, 0x1C, 0x9C, 0x1E, 0x1E, 0x9E, 0x77, 0x77, 0xF6, 0x26, 0x26, 0xA5, 0x61, 0x61, 0xE0, 0x19, 0x19, 0x98, 0x27, 0x27, 0xA7, 0x1A, 0x1A, 0x9A, 0x40,
    0x40, 0xBF, 0x72, 0x72, 0xF1, 0x74, 0x74, 0xF3, 0x17, 0x17, 0x97, 0x15, 0x15, 0x95, 0x13, 0x13, 0x93, 0x11, 0x11, 0x91, 0x00, 0x00, 0x80, 0x02, 0x02, 0x82, 0x0F, 0x0F, 0x8F, 0x0D, 0x0D, 0x8D, 0x06, 0x06, 0x86, 0x04, 0x04, 0x84, 0x0C, 0x0C,
    0x8C, 0x52, 0x52, 0xD1, 0x3A, 0x3A, 0xBA, 0x38, 0x38, 0xB8, 0x36, 0x36, 0xB6, 0x0A, 0x0A, 0x8A, 0x08, 0x08, 0x88, 0x4B, 0x4B, 0xCA, 0x49, 0x49, 0xC8, 0x56, 0x56, 0xD5, 0x4D, 0x4D, 0xCC, 0x54, 0x54, 0xD3, 0x47, 0x47, 0xC6, 0x4E, 0x4E, 0xCE,
    0x50, 0x50, 0xD0, 0x58, 0x58, 0xD7, 0x3C, 0x7F, 0xB1, 0x31, 0x31, 0xB0, 0x2D, 0x2D, 0xAD, 0x2B, 0x2B, 0xAB, 0x29, 0x29, 0xA9, 0x33, 0x33, 0xB2, 0x46, 0xD8, 0xFB, 0x2F, 0x2F, 0xAF, 0x34, 0x34, 0xB4, 0xE6, 0xE6, 0xE6, 0xE4, 0xE4, 0xE4, 0xE3,
    0xE3, 0xE3, 0xE9, 0xE9, 0xE9, 0xEB, 0xEB, 0xEB, 0xE1, 0xE1, 0xE1, 0x2C, 0x62, 0x8B, 0x9E, 0xB0, 0xBA, 0x98, 0xD1, 0xEF, 0xE5, 0xF4, 0xFC, 0xD5, 0xED, 0xF9, 0x74, 0xBB, 0xE0, 0xFD, 0xFE, 0xFF, 0x68, 0xB3, 0xDB, 0xDD, 0xF1, 0xFB, 0xCD, 0xE9,
    0xF8, 0x8C, 0xCA, 0xEA, 0xC4, 0xE5, 0xF6, 0x80, 0xC2, 0xE5, 0xE3, 0xF4, 0xFC, 0xDF, 0xF2, 0xFC, 0x9C, 0xCA, 0xE3, 0xDB, 0xF0, 0xFC, 0xA3, 0xD3, 0xED, 0xA9, 0xDB, 0xF6, 0xD6, 0xEE, 0xFB, 0xF3, 0xF3, 0xF3, 0xB5, 0xCE, 0xE7, 0x9A, 0xB6, 0xD2,
    0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0xFF, 0x0B, 0x4E, 0x45, 0x54, 0x53, 0x43, 0x41, 0x50, 0x45, 0x32, 0x2E, 0x30, 0x03, 0x01, 0x00, 0x00, 0x00,
    0x21, 0xF9, 0x04, 0x05, 0x14, 0x00, 0x83, 0x00, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x46, 0x00, 0x46, 0x00, 0x00, 0x08, 0xFF, 0x00, 0x2D, 0x08, 0x1C, 0x48, 0xB0, 0xA0, 0xC1, 0x83, 0x08, 0x13, 0x2A, 0x5C, 0x48, 0x90, 0x83, 0xC3, 0x87, 0x10, 0x23,
    0x4A, 0x9C, 0x48, 0xB1, 0xA2, 0xC5, 0x8B, 0x10, 0x3D, 0x68, 0xDC, 0xC8, 0xB1, 0xA3, 0xC7, 0x8F, 0x20, 0x43, 0x8A, 0x1C, 0xC9, 0xF1, 0x83, 0xC9, 0x93, 0x28, 0x53, 0xAA, 0x5C, 0xC9, 0xB2, 0xA5, 0xCB, 0x97, 0x28, 0x41, 0xC8, 0x9C, 0x49, 0xB3,
    0xA6, 0xCD, 0x9B, 0x38, 0x73, 0xEA, 0xDC, 0x49, 0x13, 0x87, 0xCF, 0x9F, 0x40, 0x83, 0x0A, 0x1D, 0x4A, 0xB4, 0xA8, 0xD1, 0xA3, 0x40, 0x5F, 0x28, 0x5D, 0xCA, 0xB4, 0xA9, 0xD3, 0xA7, 0x50, 0xA3, 0x4A, 0x9D, 0xCA, 0x14, 0x88, 0xD5, 0xAB, 0x58,
    0xB3, 0x6A, 0xDD, 0xCA, 0xB5, 0xAB, 0xD7, 0xAF, 0x58, 0x7F, 0x88, 0x1D, 0x4B, 0xB6, 0xAC, 0xD9, 0xB3, 0x68, 0xD3, 0xAA, 0x5D, 0x4B, 0xB6, 0x84, 0xDB, 0xB7, 0x70, 0xE3, 0xCA, 0x9D, 0x4B, 0xB7, 0xAE, 0xDD, 0xBB, 0x70, 0x67, 0xE8, 0xDD, 0xCB,
    0xB7, 0xAF, 0xDF, 0xBF, 0x80, 0x03, 0x0B, 0x1E, 0xCC, 0x77, 0x84, 0xE1, 0xC3, 0x88, 0x13, 0x2B, 0x5E, 0xCC, 0xB8, 0xB1, 0xE3, 0xC7, 0x88, 0x5B, 0x48, 0x9E, 0x4C, 0xB9, 0xB2, 0xE5, 0xCB, 0x98, 0x33, 0x6B, 0xDE, 0x4C, 0x39, 0x84, 0xE7, 0xCF,
    0xA0, 0x43, 0x8B, 0x1E, 0x4D, 0xBA, 0xB4, 0xE9, 0xD3, 0xA0, 0x53, 0xA8, 0x5E, 0xCD, 0xBA, 0xB5, 0xEB, 0xD7, 0xB0, 0x63, 0xCB, 0x9E, 0xCD, 0x9A, 0x84, 0xED, 0xDB, 0xB8, 0x73, 0xEB, 0xDE, 0xCD, 0xBB, 0xB7, 0xEF, 0xDF, 0xB8, 0x4F, 0x08, 0x1F,
    0x4E, 0xBC, 0xB8, 0xF1, 0xE3, 0xC8, 0x93, 0x2B, 0x5F, 0x4E, 0x5C, 0x87, 0xF3, 0xE7, 0xD0, 0xA3, 0x4B, 0x9F, 0x4E, 0xBD, 0xBA, 0xF5, 0xEB, 0xD0, 0x57, 0x68, 0xDF, 0xCE, 0xBD, 0xBB, 0xF7, 0xEF, 0xE0, 0xC3, 0x8B, 0xFF, 0x1F, 0xCF, 0x5D, 0x84,
    0xF9, 0xF3, 0xE8, 0xD3, 0xAB, 0x5F, 0xCF, 0xBE, 0xBD, 0xFB, 0xF7, 0xE8, 0x69, 0xC8, 0x9F, 0x4F, 0xBF, 0xBE, 0xFD, 0xFB, 0xF8, 0xF3, 0xEB, 0xDF, 0x4F, 0x3F, 0x86, 0xFF, 0xFF, 0x00, 0x06, 0x28, 0xE0, 0x80, 0x04, 0x16, 0x68, 0xE0, 0x81, 0x00,
    0x6A, 0xA1, 0xE0, 0x82, 0x0C, 0x36, 0xE8, 0xA0, 0x83, 0x82, 0x44, 0x28, 0x08, 0x83, 0x13, 0x6A, 0x21, 0xA1, 0x84, 0x0F, 0x66, 0xA8, 0xA1, 0x82, 0x54, 0x74, 0xE8, 0xE1, 0x87, 0x20, 0x86, 0x08, 0xA2, 0x20, 0x1F, 0x92, 0xD8, 0xA1, 0x89, 0x26,
    0x8A, 0xA8, 0xE2, 0x8A, 0x20, 0x5A, 0xE1, 0xE2, 0x8B, 0x30, 0xC6, 0x28, 0x23, 0x8C, 0x82, 0xC8, 0x58, 0xA3, 0x15, 0x37, 0xDE, 0x38, 0xE3, 0x8E, 0x3C, 0xC6, 0xC8, 0xC4, 0x8F, 0x40, 0x06, 0x29, 0xE4, 0x90, 0x41, 0x0A, 0x42, 0xE4, 0x8F, 0x46,
    0x32, 0x91, 0xE4, 0x91, 0x4C, 0x36, 0xF9, 0x63, 0x16, 0x50, 0x46, 0x29, 0xE5, 0x94, 0x54, 0x4A, 0x29, 0x48, 0x95, 0x50, 0x5E, 0x99, 0xC5, 0x85, 0x5A, 0x62, 0xE9, 0x25, 0x96, 0x58, 0x84, 0x29, 0xE6, 0x98, 0x64, 0x96, 0x39, 0xA6, 0x20, 0x62,
    0x5E, 0x18, 0x26, 0x9A, 0x58, 0xB0, 0x69, 0xE6, 0x9B, 0x70, 0x92, 0x59, 0xC5, 0x9C, 0x74, 0xD6, 0x69, 0xE7, 0x9D, 0x75, 0x0A, 0x72, 0xA7, 0x9E, 0x55, 0xF0, 0xC9, 0x27, 0x9E, 0x80, 0x06, 0x6A, 0xA7, 0x14, 0x84, 0x16, 0x6A, 0xE8, 0xA1, 0x88,
    0x1A, 0x2A, 0x08, 0xA2, 0x8B, 0x4A, 0xD1, 0x68, 0xA3, 0x89, 0x46, 0x2A, 0xE9, 0xA1, 0x53, 0x54, 0x6A, 0xE9, 0xA5, 0x98, 0x66, 0x8A, 0xA9, 0x20, 0x97, 0x72, 0x5A, 0xA9, 0xA7, 0x9E, 0x6A, 0x2A, 0xEA, 0xA8, 0x98, 0x5E, 0x61, 0xEA, 0xA9, 0xA8,
    0xA6, 0xAA, 0xAA, 0xAA, 0x17, 0xA2, 0x2A, 0x88, 0xA9, 0xAF, 0xAE, 0xFF, 0x2A, 0xEB, 0xAC, 0xAA, 0xBA, 0x60, 0xEB, 0xAD, 0xB8, 0xE6, 0xAA, 0xEB, 0xAE, 0xBC, 0xF6, 0xEA, 0xEB, 0xAF, 0xB8, 0xB2, 0x20, 0xEC, 0xB0, 0xC4, 0x16, 0x6B, 0xEC, 0xB1,
    0xC8, 0x26, 0xAB, 0xEC, 0xB2, 0xC4, 0xA2, 0xE0, 0xEC, 0xB3, 0xD0, 0x46, 0x2B, 0xED, 0xB4, 0xD4, 0x56, 0x6B, 0xED, 0xB5, 0xD0, 0xFA, 0xA0, 0xED, 0xB6, 0xDC, 0x76, 0xEB, 0xED, 0xB7, 0xE0, 0x86, 0x2B, 0xEE, 0xB8, 0xDC, 0xAA, 0x60, 0xEE, 0xB9,
    0xE8, 0xA6, 0xAB, 0xEE, 0xBA, 0xEC, 0xB6, 0xEB, 0xEE, 0xBB, 0xE8, 0x9A, 0x20, 0xEF, 0xBC, 0xF4, 0xD6, 0x6B, 0xEF, 0xBD, 0xF8, 0xE6, 0xAB, 0xEF, 0xBE, 0xF4, 0x36, 0xE1, 0xEF, 0xBF, 0xFF, 0x0A, 0x02, 0xF0, 0xC0, 0x01, 0x13, 0x6C, 0xF0, 0xC1,
    0x05, 0x23, 0xAC, 0xB0, 0xBF, 0x4E, 0x34, 0xEC, 0x70, 0xC3, 0x82, 0x38, 0x11, 0xF1, 0xC3, 0x14, 0x57, 0x6C, 0xF1, 0xC5, 0x12, 0x63, 0xAC, 0xB1, 0xC5, 0x4F, 0x74, 0xEC, 0x71, 0xC7, 0x82, 0x3C, 0x11, 0xF2, 0xC7, 0x24, 0x97, 0x6C, 0xF2, 0xC9,
    0x22, 0xA3, 0xAC, 0xB2, 0xC9, 0x63, 0xB4, 0xEC, 0x72, 0xCB, 0x82, 0x8C, 0x11, 0xB3, 0xCB, 0x31, 0x47, 0x48, 0x33, 0xCC, 0x32, 0xCF, 0x6C, 0x33, 0xCD, 0x3B, 0x4B, 0x88, 0x33, 0xCC, 0x3B, 0xCB, 0x9C, 0xF3, 0xCB, 0x44, 0x83, 0x61, 0xF4, 0xD1,
    0x60, 0x08, 0x72, 0xB4, 0xD2, 0x46, 0x47, 0xD8, 0xF4, 0xD3, 0x49, 0x33, 0xED, 0x74, 0xD2, 0x50, 0x53, 0x6D, 0xB5, 0xD5, 0x4C, 0x63, 0x2D, 0x35, 0xD2, 0x48, 0x73, 0xE1, 0xF5, 0xD7, 0x5C, 0x08, 0xF2, 0xB5, 0xD8, 0x5E, 0x93, 0x1D, 0x76, 0xD9,
    0x68, 0xA7, 0x7D, 0x36, 0xD8, 0x6B, 0x9B, 0x4D, 0xB6, 0xDB, 0x6A, 0x9B, 0xCD, 0xB6, 0x18, 0x74, 0xD7, 0xCD, 0x65, 0x84, 0x74, 0x0B, 0x62, 0x77, 0xDE, 0x7C, 0xF7, 0xFF, 0x2D, 0x86, 0xDE, 0x79, 0x4B, 0xE8, 0x37, 0xE0, 0x80, 0xFF, 0x3D, 0x78,
    0xDD, 0x88, 0x8B, 0xD1, 0xC5, 0xE2, 0x8C, 0x0B, 0xC2, 0xF8, 0xE2, 0x8E, 0x77, 0x11, 0xB9, 0xE4, 0x90, 0x57, 0x6E, 0x39, 0xE5, 0x98, 0x63, 0x3E, 0x79, 0xE4, 0x9B, 0x5F, 0x3E, 0xF9, 0xE3, 0x5D, 0x78, 0x21, 0xBA, 0xE8, 0x82, 0x8C, 0x6E, 0x7A,
    0xE9, 0xA5, 0x93, 0xAE, 0xBA, 0x17, 0xA9, 0xB3, 0x3E, 0x7A, 0xEA, 0xB0, 0xC3, 0xFE, 0xFA, 0xEA, 0xAE, 0xD7, 0x6E, 0xBB, 0xE9, 0x5E, 0x7C, 0xA1, 0xBB, 0xEE, 0x82, 0xEC, 0xEE, 0x7B, 0xEF, 0xBD, 0xF3, 0x2E, 0xFC, 0x17, 0xC1, 0x13, 0xBF, 0x7B,
    0xF1, 0x11, 0x1A, 0x4F, 0x7C, 0xF0, 0xC8, 0x27, 0x3F, 0xBC, 0xF2, 0xBE, 0xEB, 0xCE, 0xC3, 0xF4, 0xD4, 0x57, 0x6F, 0xFD, 0xF5, 0xD8, 0x67, 0xAF, 0xFD, 0xF6, 0xDC, 0x57, 0x9F, 0xC3, 0xF7, 0xE0, 0x87, 0x2F, 0xFE, 0xF8, 0xE4, 0x97, 0x6F, 0xFE,
    0xF9, 0xE8, 0x87, 0x2F, 0xC3, 0xFA, 0xEC, 0xB7, 0xEF, 0xFE, 0xFB, 0xF0, 0xC7, 0x2F, 0xFF, 0xFC, 0xF4, 0xB7, 0x5F, 0xC3, 0xFD, 0xF8, 0xE7, 0xAF, 0xFF, 0xFE, 0xFC, 0xF7, 0xEF, 0xFF, 0xFF, 0x00, 0xCC, 0x1F, 0x0C, 0x06, 0x48, 0xC0, 0x02, 0x1A,
    0xF0, 0x80, 0x08, 0x4C, 0xA0, 0x02, 0x17, 0xC8, 0xC0, 0x02, 0xDE, 0xE0, 0x81, 0x10, 0x8C, 0xA0, 0x04, 0x27, 0x48, 0xC1, 0x0A, 0x5A, 0xF0, 0x82, 0x18, 0x8C, 0xA0, 0x0D, 0x36, 0xC8, 0xC1, 0x0E, 0x7A, 0xF0, 0x83, 0x20, 0x0C, 0xA1, 0x08, 0x47,
    0x48, 0xC2, 0x0E, 0xF6, 0xE0, 0x84, 0x28, 0x4C, 0xA1, 0x0A, 0x57, 0xC8, 0xC2, 0x16, 0xBA, 0xF0, 0x85, 0x30, 0x4C, 0xE1, 0x0E, 0x66, 0x48, 0xC3, 0x1A, 0xDA, 0xF0, 0x86, 0x38, 0xCC, 0xA1, 0x0E, 0x77, 0xC8, 0xC3, 0x1A, 0x06, 0xE1, 0x87, 0x40,
    0x0C, 0xA2, 0x10, 0xD2, 0x87, 0x48, 0xC4, 0x22, 0x1A, 0xF1, 0x88, 0x48, 0x0C, 0xA2, 0x10, 0x96, 0xC8, 0xC4, 0x26, 0x3A, 0xF1, 0x89, 0x50, 0x8C, 0xA2, 0x14, 0xA7, 0x48, 0xC5, 0x26, 0x0E, 0xE1, 0x8A, 0x58, 0xCC, 0xA2, 0x16, 0xB7, 0xC8, 0xC5,
    0x2E, 0x7A, 0xF1, 0x8B, 0x60, 0xCC, 0x22, 0x11, 0xC6, 0x48, 0xC6, 0x32, 0x9A, 0xF1, 0x8C, 0x68, 0x4C, 0xA3, 0x1A, 0xD7, 0xC8, 0xC6, 0x32, 0x1E, 0xE1, 0x8D, 0x70, 0x8C, 0xA3, 0x1C, 0xE7, 0x48, 0xC7, 0x3A, 0xDA, 0xF1, 0x8E, 0x78, 0x8C, 0x23,
    0x12, 0xF6, 0xC8, 0xC7, 0x3E, 0xFA, 0xF1, 0x8F, 0x80, 0x0C, 0xA4, 0x20, 0x07, 0x49, 0xC8, 0x3E, 0x2E, 0xE1, 0x90, 0x88, 0x4C, 0xA4, 0x22, 0x17, 0xC9, 0xC8, 0x46, 0x3A, 0xF2, 0x91, 0x90, 0x4C, 0x24, 0x14, 0x26, 0x49, 0xC9, 0x4A, 0x5A, 0xF2,
    0x92, 0x98, 0xCC, 0xA4, 0x26, 0x37, 0xC9, 0xC9, 0x4A, 0x46, 0xE1, 0x93, 0xA0, 0x0C, 0xA5, 0x28, 0x47, 0x49, 0xCA, 0x52, 0x9A, 0xF2, 0x94, 0xA8, 0x0C, 0x65, 0x12, 0x56, 0xC9, 0xCA, 0x56, 0xBA, 0xF2, 0x95, 0xB0, 0x8C, 0xA5, 0x2C, 0x67, 0x49,
    0xCB, 0x56, 0x2A, 0xE1, 0x96, 0xB8, 0xCC, 0xA5, 0x2E, 0x77, 0xC9, 0xCB, 0x5E, 0xFA, 0xF2, 0x97, 0xC0, 0xCC, 0xA5, 0x11, 0x86, 0x49, 0xCC, 0x62, 0x1A, 0xF3, 0x98, 0xC8, 0x4C, 0xA6, 0x32, 0x97, 0xC9, 0xCC, 0x62, 0x16, 0xE1, 0x99, 0xD0, 0x8C,
    0xA6, 0x34, 0xA7, 0x49, 0xCD, 0x6A, 0x5A, 0xF3, 0x9A, 0xD8, 0x8C, 0x66, 0x40, 0x00, 0x00, 0x21, 0xF9, 0x04, 0x05, 0x14, 0x00, 0x83, 0x00, 0x2C, 0x00, 0x00, 0x01, 0x00, 0x03, 0x00, 0x45, 0x00, 0x00, 0x08, 0x34, 0x00, 0x03, 0x0D, 0x1A, 0x14,
    0x48, 0xA0, 0x20, 0x83, 0x02, 0x01, 0x1D, 0x54, 0x18, 0x88, 0xA1, 0xC3, 0x85, 0x10, 0x1B, 0x46, 0x7C, 0x28, 0xB1, 0x22, 0xC5, 0x8B, 0x13, 0x33, 0x5A, 0xD4, 0x88, 0x71, 0xA3, 0xC7, 0x8E, 0x20, 0x39, 0x8A, 0xFC, 0x38, 0x32, 0x24, 0xC9, 0x93,
    0x0C, 0x05, 0x1D, 0x2C, 0x18, 0x28, 0x20, 0x00, 0x21, 0xF9, 0x04, 0x05, 0x14, 0x00, 0x83, 0x00, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x46, 0x00, 0x00, 0x08, 0xFF, 0x00, 0x03, 0x09, 0x1C, 0x48, 0xB0, 0xA0, 0x85, 0x83, 0x07, 0x05, 0x29,
    0x5C, 0xC8, 0xB0, 0xE1, 0x40, 0x0E, 0x1C, 0x00, 0x49, 0x9C, 0x48, 0xB1, 0xA2, 0x42, 0x81, 0x1E, 0x10, 0x68, 0xDC, 0xC8, 0xB1, 0xA3, 0x44, 0x41, 0x81, 0x3E, 0x18, 0x18, 0x49, 0xB2, 0xA4, 0xC9, 0x8F, 0x81, 0x40, 0x2C, 0x58, 0xC9, 0xB2, 0xA5,
    0xCB, 0x89, 0x20, 0x0F, 0xC8, 0x9C, 0x49, 0xB3, 0x26, 0xCC, 0x40, 0x09, 0x72, 0xEA, 0xDC, 0xC9, 0xF3, 0x26, 0x83, 0x9F, 0x40, 0x83, 0x0A, 0xBD, 0xA9, 0xA0, 0xA8, 0xD1, 0xA3, 0x48, 0x6F, 0xFE, 0x59, 0xCA, 0xB4, 0xA9, 0xD3, 0x9B, 0x05, 0xA2,
    0x4A, 0x9D, 0x4A, 0xF5, 0x66, 0xC5, 0xAB, 0x58, 0x41, 0x06, 0xD8, 0xCA, 0xB5, 0xAB, 0xD7, 0x9B, 0x05, 0xC3, 0x0E, 0x14, 0x74, 0x53, 0x61, 0x06, 0x00, 0x68, 0xD3, 0xA6, 0xCD, 0x20, 0x80, 0x2C, 0x4A, 0x85, 0x00, 0xFC, 0xC8, 0x9D, 0x3B, 0x17,
    0x40, 0xDB, 0xB2, 0x82, 0xE2, 0x3A, 0xD8, 0xF0, 0xA0, 0x03, 0x04, 0x0D, 0x18, 0xFC, 0xD8, 0x75, 0x0B, 0x08, 0x24, 0x5C, 0x3F, 0x7B, 0xFB, 0xFE, 0x0D, 0x3C, 0x18, 0xAF, 0x5E, 0xBE, 0x17, 0x16, 0x0B, 0xBE, 0xFB, 0x36, 0x2F, 0xE2, 0x0D, 0x17,
    0x32, 0x03, 0x9E, 0x4C, 0xD8, 0xB0, 0x65, 0x07, 0x99, 0x43, 0x33, 0xA6, 0x5C, 0x38, 0xD0, 0xE1, 0xC4, 0x7E, 0x37, 0x37, 0xAE, 0xFC, 0x58, 0xB1, 0x6A, 0xD2, 0x9E, 0xE3, 0xD2, 0xA5, 0xBB, 0xBA, 0xB4, 0x59, 0xB5, 0xB8, 0xD9, 0x76, 0x36, 0x2D,
    0xE8, 0x2C, 0xEE, 0xB5, 0xB0, 0x79, 0xCB, 0x9E, 0x2D, 0xB7, 0x76, 0xEC, 0xCB, 0xAE, 0x47, 0xEF, 0x3E, 0xCD, 0x37, 0xB5, 0x72, 0xC7, 0xC4, 0xEB, 0x06, 0xBF, 0xFD, 0x1B, 0xAD, 0x6E, 0xBC, 0x19, 0xD2, 0x98, 0x29, 0x43, 0xA6, 0xC3, 0x19, 0x34,
    0x0F, 0x28, 0x44, 0xC1, 0x98, 0xDE, 0x5B, 0x3B, 0x77, 0xEF, 0xE0, 0xC5, 0x93, 0xCF, 0xBE, 0xBD, 0xFB, 0xF7, 0xF0, 0xE3, 0x97, 0xF7, 0xAE, 0x6E, 0x9D, 0xFC, 0x70, 0xE2, 0xC6, 0x85, 0x23, 0x77, 0xCE, 0x19, 0x3A, 0x6A, 0xC9, 0xF9, 0x9D, 0x16,
    0x5A, 0x66, 0xCF, 0xB1, 0x76, 0x59, 0x68, 0xAF, 0xC9, 0xD7, 0x5A, 0x64, 0x09, 0xFA, 0xD7, 0x1C, 0x80, 0xF6, 0xED, 0x07, 0xA1, 0x82, 0xD1, 0x15, 0xB7, 0x1E, 0x7D, 0x00, 0x5C, 0x87, 0x92, 0x00, 0x1C, 0x76, 0xE8, 0xA1, 0x87, 0xF2, 0x35, 0x24,
    0xA2, 0x42, 0x4A, 0x39, 0x65, 0x22, 0x53, 0x25, 0x9E, 0x68, 0xE2, 0x4D, 0x03, 0xA8, 0xB8, 0x22, 0x4A, 0x04, 0x0C, 0xD0, 0xA2, 0x8B, 0x4B, 0xDD, 0xE4, 0x07, 0x01, 0x31, 0xD2, 0xF8, 0xC7, 0x4D, 0x0E, 0x34, 0x90, 0x23, 0x8D, 0x37, 0x45, 0xD0,
    0x80, 0x8F, 0x33, 0xAA, 0x78, 0x13, 0x05, 0x43, 0xFE, 0x68, 0x24, 0x4A, 0x0F, 0x24, 0x59, 0xE4, 0x89, 0x37, 0x0D, 0x49, 0x24, 0x90, 0x28, 0x55, 0xE0, 0x24, 0x95, 0xA5, 0x41, 0x70, 0xA5, 0x8B, 0x37, 0x49, 0x30, 0x25, 0x96, 0x20, 0x4D, 0x80,
    0xE3, 0x93, 0x50, 0xC2, 0x28, 0xA3, 0x8E, 0x3B, 0xA2, 0x44, 0x26, 0x97, 0x28, 0xA1, 0x89, 0x62, 0x9B, 0x6E, 0xA6, 0x59, 0x1A, 0x56, 0x74, 0x5A, 0x55, 0x27, 0x9D, 0x9E, 0x8D, 0xA8, 0xE7, 0x45, 0x62, 0xF5, 0x59, 0x50, 0x40, 0x00, 0x21, 0xF9,
    0x04, 0x05, 0x14, 0x00, 0x83, 0x00, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x35, 0x00, 0x46, 0x00, 0x00, 0x08, 0xFF, 0x00, 0x03, 0x09, 0x1C, 0x48, 0xB0, 0xA0, 0xC1, 0x83, 0x08, 0x13, 0x0E, 0xB4, 0xC0, 0x90, 0xA1, 0xA0, 0x87, 0x10, 0x23, 0x4A, 0x9C,
    0x48, 0xB1, 0xA2, 0x45, 0x88, 0x03, 0x39, 0x70, 0x00, 0xC4, 0xB1, 0xA3, 0xC7, 0x8F, 0x20, 0x43, 0x8A, 0x1C, 0xD9, 0xF1, 0xA1, 0x40, 0x0F, 0x08, 0x52, 0xAA, 0x5C, 0xC9, 0xB2, 0xA5, 0xCB, 0x97, 0x30, 0x55, 0x72, 0x14, 0x14, 0xE8, 0x83, 0x81,
    0x9B, 0x38, 0x73, 0xEA, 0xDC, 0xC9, 0xB3, 0xA7, 0x4F, 0x9C, 0x33, 0x03, 0x81, 0x10, 0xB4, 0x60, 0x01, 0xD1, 0xA2, 0x48, 0x93, 0x2A, 0x5D, 0xCA, 0xB4, 0x69, 0xD3, 0x92, 0x81, 0x04, 0x1D, 0x38, 0x20, 0x75, 0xAA, 0xD5, 0xAB, 0x58, 0xB3, 0x6A,
    0xDD, 0xBA, 0x15, 0xAA, 0xA0, 0x04, 0x09, 0xBE, 0x82, 0x1D, 0x4B, 0xB6, 0xAC, 0xD9, 0xB3, 0x68, 0xD1, 0x42, 0x65, 0x00, 0x91, 0x81, 0xDB, 0xB7, 0x70, 0xE3, 0xCA, 0x9D, 0x4B, 0x97, 0x2E, 0x54, 0x05, 0x78, 0x05, 0xE1, 0xDD, 0xCB, 0xB7, 0xAF,
    0xDF, 0xBF, 0x80, 0x03, 0x43, 0xFD, 0xF3, 0xF0, 0x8F, 0xE1, 0xC3, 0x88, 0x13, 0x2B, 0x5E, 0xCC, 0xB8, 0x31, 0xD4, 0x02, 0x90, 0x23, 0x4B, 0x9E, 0x4C, 0xB9, 0xB2, 0xE5, 0xCB, 0x91, 0xA1, 0x92, 0xDC, 0xCC, 0xB9, 0xF3, 0x47, 0x9A, 0x01, 0x42,
    0x8B, 0x1E, 0x4D, 0xBA, 0xB4, 0xE9, 0xD3, 0xA8, 0x45, 0x43, 0x55, 0xC8, 0xBA, 0xB5, 0xEB, 0xA8, 0x5E, 0x2F, 0xCA, 0x9E, 0x2D, 0x28, 0x03, 0x80, 0xDB, 0xB8, 0x71, 0x67, 0x10, 0x20, 0x28, 0xF6, 0xC4, 0xA8, 0x51, 0x69, 0x5F, 0x04, 0xE0, 0xA7,
    0xB8, 0x71, 0xE3, 0x00, 0x78, 0xFB, 0x96, 0x18, 0x5C, 0xF8, 0x70, 0x3F, 0x0E, 0x36, 0x3C, 0xE8, 0x00, 0x41, 0x03, 0x06, 0x3F, 0xC9, 0x7B, 0x07, 0x15, 0x68, 0x92, 0xA6, 0x77, 0xE0, 0x03, 0x9D, 0x47, 0xFF, 0x24, 0x1E, 0x7D, 0x7A, 0xF5, 0xEB,
    0xD9, 0x63, 0x83, 0xEF, 0x0E, 0x1C, 0xA3, 0xF8, 0x87, 0xE4, 0xA5, 0x5F, 0x38, 0x8F, 0x5D, 0xF9, 0x76, 0xEE, 0xCD, 0xDB, 0xE7, 0x7F, 0x2F, 0x28, 0xFE, 0x85, 0xFF, 0xD6, 0xD5, 0xA7, 0x1D, 0x20, 0xDE, 0xB9, 0xC7, 0x5E, 0x81, 0x08, 0x3A, 0x47,
    0xDE, 0x7F, 0x0C, 0xA2, 0x67, 0x1F, 0x81, 0xC1, 0xB5, 0x77, 0xE0, 0x7E, 0xEF, 0xC5, 0x67, 0x5E, 0x80, 0xE9, 0xDD, 0xD7, 0xDD, 0x84, 0x06, 0x8A, 0x67, 0x21, 0x75, 0x18, 0x3E, 0x98, 0x20, 0x7F, 0xB4, 0x11, 0x77, 0xDC, 0x71, 0x19, 0x42, 0x48,
    0xA2, 0x78, 0xB6, 0xE5, 0x96, 0xDB, 0x6E, 0x03, 0x8E, 0xB8, 0xE1, 0x8A, 0x12, 0xB5, 0xE8, 0xE2, 0x6D, 0x30, 0x2E, 0x47, 0xE3, 0x73, 0x27, 0x22, 0x27, 0x22, 0x77, 0xDF, 0x15, 0x18, 0x1E, 0x8D, 0x1F, 0xD2, 0x97, 0x62, 0x90, 0x40, 0x4A, 0x28,
    0xA3, 0x82, 0xD0, 0x49, 0x07, 0xA2, 0x83, 0x31, 0x86, 0x47, 0x21, 0x90, 0x44, 0xF6, 0xE8, 0x63, 0x94, 0x41, 0xCE, 0xB8, 0xA4, 0x73, 0x36, 0xDE, 0x98, 0xA3, 0x86, 0xFB, 0x51, 0x48, 0x62, 0x06, 0x69, 0x98, 0x51, 0x06, 0x19, 0x1D, 0x9C, 0x81,
    0xC6, 0x03, 0x14, 0x44, 0xF0, 0x63, 0x96, 0x42, 0x52, 0x39, 0x66, 0x99, 0x67, 0xA6, 0xB9, 0x66, 0x9B, 0x6F, 0xEE, 0x38, 0x1B, 0x99, 0x66, 0xA2, 0xA9, 0x26, 0x9B, 0x6E, 0x62, 0xA9, 0xA7, 0x6C, 0x5D, 0xBA, 0xF8, 0xA5, 0x8A, 0x5A, 0x0E, 0x0A,
    0x91, 0x89, 0x56, 0x1E, 0x29, 0xA6, 0xA2, 0x8B, 0x36, 0x79, 0x21, 0x94, 0xAB, 0x6D, 0xA8, 0x64, 0x84, 0x72, 0x96, 0x28, 0xE9, 0x93, 0x02, 0x7A, 0xA5, 0xDF, 0x8C, 0x97, 0x7A, 0x08, 0x1D, 0x83, 0xFF, 0x51, 0x1A, 0xD4, 0x77, 0xCD, 0x65, 0xF9,
    0xE8, 0x6C, 0xFE, 0x01, 0x68, 0xAA, 0x8A, 0x9F, 0x1E, 0xFF, 0x88, 0x60, 0xAA, 0xAC, 0x4A, 0x3A, 0x5F, 0x88, 0x58, 0xC6, 0x0A, 0x6A, 0x87, 0x9A, 0x96, 0xC7, 0xA9, 0xA3, 0x11, 0xEE, 0x8A, 0x51, 0xA6, 0xB5, 0xFA, 0x6A, 0x64, 0x9E, 0x15, 0xD1,
    0x4A, 0x22, 0xA3, 0x3D, 0x3A, 0x0A, 0xA9, 0x45, 0x85, 0xBE, 0xF8, 0xA3, 0x00, 0xD4, 0x56, 0x6B, 0xED, 0xB5, 0xD8, 0x66, 0xAB, 0xED, 0xB6, 0xD4, 0x0A, 0xFA, 0x2C, 0x89, 0x83, 0x35, 0x26, 0xEE, 0xB8, 0xE4, 0x26, 0x16, 0x6E, 0xB9, 0xE8, 0xA6,
    0x8B, 0x58, 0xB8, 0x03, 0xB4, 0xEB, 0xEE, 0xBB, 0xF0, 0xC6, 0x2B, 0xEF, 0xBB, 0xE8, 0x42, 0xD5, 0x2E, 0x01, 0xF8, 0xE6, 0xAB, 0xEF, 0xBE, 0xFC, 0xF6, 0xAB, 0x6F, 0xBB, 0xE4, 0x42, 0x85, 0xAF, 0x95, 0x04, 0x17, 0x4C, 0x30, 0xBE, 0x03, 0x8C,
    0x2B, 0x70, 0x03, 0x0E, 0x34, 0xDC, 0x30, 0x41, 0x0E, 0x47, 0x2C, 0x71, 0x20, 0x12, 0x4B, 0xDC, 0x00, 0x01, 0x09, 0x8B, 0x0B, 0x55, 0x03, 0x0D, 0x44, 0xE0, 0xB1, 0xC7, 0x81, 0x7C, 0x1C, 0xF2, 0xC7, 0x24, 0x8B, 0x5C, 0x72, 0xC9, 0x1C, 0x63,
    0xAC, 0x71, 0x50, 0x1C, 0x53, 0xE0, 0xB2, 0xCB, 0x81, 0xBC, 0x1C, 0x33, 0x05, 0x02, 0xC9, 0x3C, 0xF3, 0xCD, 0x2F, 0xE7, 0x9C, 0x72, 0xC6, 0x8C, 0x6D, 0xDC, 0xC0, 0x03, 0x40, 0x03, 0x4D, 0x90, 0xD0, 0x44, 0x07, 0x52, 0xF4, 0x03, 0x46, 0x07,
    0xAD, 0xF4, 0xCE, 0x2B, 0x43, 0xC8, 0xF1, 0xD3, 0x1C, 0x07, 0xF2, 0xB4, 0xD4, 0x52, 0x37, 0x40, 0x75, 0xD4, 0x56, 0x57, 0x0D, 0xF5, 0xD6, 0x2A, 0x3B, 0xC6, 0x72, 0x03, 0x15, 0x84, 0x1D, 0x76, 0x20, 0x62, 0x93, 0x4D, 0x76, 0x05, 0x66, 0x8F,
    0x8D, 0xF6, 0xDA, 0x62, 0xB7, 0xCD, 0xB4, 0xD7, 0x4E, 0x37, 0x00, 0xC1, 0xDC, 0x73, 0x13, 0x44, 0xB7, 0x40, 0x77, 0x07, 0x52, 0xF7, 0xDE, 0x74, 0xD3, 0x56, 0xFD, 0x76, 0xCF, 0x41, 0x11, 0xD0, 0x80, 0x04, 0x84, 0x17, 0x6E, 0xF8, 0xE1, 0x88,
    0x27, 0x6E, 0xF8, 0xC5, 0x3C, 0x03, 0x0E, 0x21, 0xBE, 0x13, 0x44, 0x2E, 0xF9, 0xE4, 0x94, 0x57, 0x6E, 0xF9, 0xE4, 0x08, 0x2B, 0x1C, 0xD4, 0xBD, 0xFE, 0x76, 0xEE, 0xF9, 0xBF, 0x8D, 0x3B, 0x4E, 0x93, 0x61, 0xF3, 0x96, 0x6E, 0x3A, 0xBC, 0xF5,
    0x06, 0xA5, 0xEE, 0xEA, 0xE9, 0x9E, 0xCB, 0xFA, 0xEB, 0xA2, 0x07, 0xE2, 0xD9, 0xEC, 0xB4, 0x83, 0x44, 0x53, 0xED, 0xB8, 0xD3, 0xBE, 0xE5, 0xB7, 0xE2, 0xBD, 0xE6, 0xFB, 0xEF, 0x09, 0x05, 0x04, 0x00, 0x21, 0xF9, 0x04, 0x05, 0x14, 0x00, 0x83,
    0x00, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00, 0x46, 0x00, 0x00, 0x08, 0xFF, 0x00, 0x2D, 0x08, 0x0C, 0x44, 0xB0, 0xA0, 0xC1, 0x83, 0x08, 0x13, 0x2A, 0x5C, 0xC8, 0xF0, 0xA0, 0xC0, 0x87, 0x05, 0x05, 0x49, 0x9C, 0x48, 0xB1, 0xA2, 0xC5, 0x8B,
    0x18, 0x33, 0x6A, 0xAC, 0x58, 0x90, 0x03, 0x87, 0x40, 0x12, 0x01, 0x89, 0x1C, 0x49, 0xB2, 0xA4, 0xC9, 0x93, 0x28, 0x53, 0xAA, 0x2C, 0x29, 0x91, 0xA0, 0x07, 0x41, 0x22, 0x11, 0x4C, 0x44, 0x20, 0x93, 0xA6, 0x20, 0x9A, 0x38, 0x73, 0xEA, 0xDC,
    0xC9, 0xB3, 0xA7, 0xCF, 0x9D, 0x22, 0x05, 0x05, 0xFA, 0x00, 0x13, 0x90, 0x20, 0x03, 0x48, 0x8F, 0x22, 0x35, 0xA0, 0x74, 0xA9, 0xD3, 0xA7, 0x50, 0xA3, 0x4A, 0x9D, 0x0A, 0x35, 0x68, 0x20, 0x10, 0x23, 0x05, 0x2D, 0xD8, 0xBA, 0x55, 0xEB, 0xC4,
    0x05, 0x5A, 0xC1, 0x72, 0x1D, 0x4B, 0xB6, 0xAC, 0xD9, 0xB3, 0x68, 0xB7, 0x66, 0x0D, 0x94, 0xF5, 0x80, 0x5B, 0xB7, 0x82, 0xE0, 0xCA, 0x3D, 0x10, 0xF7, 0xAD, 0xDD, 0xBB, 0x78, 0xF3, 0xEA, 0xDD, 0x7B, 0x60, 0x6D, 0xD6, 0x04, 0x80, 0x01, 0x0B,
    0x12, 0x4C, 0x38, 0xC1, 0xE0, 0xC0, 0x88, 0x13, 0x2B, 0x5E, 0xCC, 0xB8, 0x71, 0x02, 0xBF, 0x41, 0x19, 0x48, 0x16, 0xC4, 0x80, 0x72, 0x65, 0xC9, 0x95, 0x25, 0x62, 0xDE, 0xCC, 0xB9, 0xB3, 0xE7, 0xCF, 0xA0, 0x25, 0x43, 0x06, 0xA4, 0x60, 0xA2,
    0x82, 0xD2, 0xA7, 0x05, 0x9D, 0x5E, 0xAD, 0x7A, 0xB5, 0xEB, 0xD7, 0xB0, 0x63, 0xCB, 0x9E, 0xAD, 0x60, 0xF4, 0x9F, 0xDB, 0xB8, 0x73, 0xE3, 0x96, 0xA8, 0xBB, 0xB7, 0xEF, 0xDF, 0xC0, 0x83, 0x8F, 0x2E, 0x40, 0xBC, 0xB8, 0xF1, 0xE3, 0xC8, 0x93,
    0x2B, 0x5F, 0xCE, 0xFC, 0xF8, 0xE8, 0x95, 0xD0, 0xA3, 0x4B, 0x8F, 0x2E, 0x74, 0x64, 0x80, 0xEB, 0xD8, 0xB3, 0x6B, 0xDF, 0xCE, 0xBD, 0xBB, 0xF7, 0xEF, 0xDA, 0x47, 0x07, 0xFF, 0x68, 0x48, 0xBE, 0xBC, 0x79, 0x85, 0x45, 0x8D, 0xB2, 0x15, 0x39,
    0x7E, 0xA3, 0xFB, 0xF7, 0x19, 0x33, 0x00, 0x98, 0x4F, 0x9F, 0x7E, 0x06, 0x01, 0xE9, 0xAB, 0xB3, 0x07, 0x79, 0xD0, 0x3D, 0x7F, 0xF8, 0x1A, 0x01, 0xE0, 0xC7, 0x80, 0x04, 0x12, 0x08, 0x00, 0x7E, 0xE2, 0xFD, 0x37, 0x11, 0x48, 0x1A, 0x31, 0x08,
    0x60, 0x46, 0x02, 0x3A, 0xB0, 0xC1, 0x03, 0x1D, 0x40, 0xA0, 0x01, 0x06, 0x7E, 0x1C, 0x98, 0xDF, 0x7A, 0x80, 0xB4, 0xE7, 0xA0, 0x50, 0x2D, 0x11, 0xD4, 0x12, 0x88, 0xFF, 0x19, 0xF4, 0xE0, 0x44, 0x11, 0x4E, 0x58, 0xE1, 0x85, 0x19, 0x22, 0x68,
    0x95, 0x75, 0xFC, 0xF5, 0xE7, 0x60, 0x8C, 0x23, 0x2A, 0x08, 0xE2, 0x89, 0x29, 0x3E, 0x70, 0x81, 0x85, 0x18, 0x6A, 0x98, 0xE0, 0x8D, 0x35, 0x9A, 0x38, 0x23, 0x89, 0x0B, 0x9E, 0x28, 0x48, 0x8A, 0x17, 0x24, 0xC9, 0xA2, 0x8F, 0x2F, 0xEE, 0x07,
    0x24, 0x91, 0x14, 0x0D, 0x69, 0xE3, 0x87, 0xF0, 0x45, 0x98, 0xE4, 0x95, 0x3D, 0xBA, 0xA8, 0x1E, 0x8C, 0x4F, 0x4E, 0x09, 0x64, 0x89, 0x45, 0xE2, 0xE8, 0x87, 0x84, 0x14, 0xF2, 0xD8, 0xE2, 0x86, 0x5C, 0xF6, 0x17, 0x22, 0x83, 0x52, 0x7E, 0x69,
    0x64, 0x8E, 0x2B, 0x66, 0x89, 0xA6, 0x93, 0x46, 0xD6, 0x79, 0x91, 0x80, 0x05, 0x16, 0xC8, 0xE4, 0x96, 0x74, 0xDA, 0xE9, 0xA7, 0x44, 0xF2, 0xD5, 0x57, 0xDF, 0x7D, 0x73, 0x76, 0x18, 0xA3, 0x88, 0x1B, 0x51, 0xF9, 0x67, 0xA0, 0x82, 0xCE, 0x47,
    0xE8, 0x8F, 0x43, 0xFE, 0xF9, 0x20, 0x9E, 0x79, 0x0E, 0xB8, 0xA7, 0x7E, 0x86, 0xBA, 0x29, 0x14, 0xA2, 0x60, 0x6E, 0xAA, 0xE8, 0xA4, 0x63, 0xAA, 0x68, 0xE6, 0xA5, 0x1C, 0x7A, 0x58, 0xA4, 0x94, 0x6C, 0x6A, 0x5A, 0x27, 0x9C, 0xA3, 0x6A, 0x89,
    0xA9, 0x87, 0x11, 0xAD, 0xFF, 0xE9, 0xE5, 0xA6, 0x92, 0x52, 0x5A, 0x29, 0xA9, 0x69, 0x72, 0x74, 0x6A, 0x98, 0x23, 0xFA, 0xC9, 0x68, 0xA3, 0x8F, 0x36, 0x99, 0x29, 0x95, 0x6C, 0x7A, 0x19, 0x69, 0x9D, 0x19, 0xA4, 0x61, 0x46, 0x19, 0x64, 0x74,
    0x70, 0x06, 0x1A, 0x0F, 0x50, 0x10, 0x81, 0xAB, 0xA5, 0xDA, 0xB8, 0x60, 0xA7, 0x37, 0xC6, 0x6A, 0x67, 0xB2, 0xCB, 0x36, 0xFB, 0x6C, 0xB4, 0xD3, 0x16, 0xDA, 0x9E, 0xA4, 0xBE, 0x2A, 0xCB, 0xAC, 0xB3, 0xD0, 0x4A, 0x4B, 0x2D, 0x97, 0xE4, 0x6E,
    0xDB, 0xA8, 0x7D, 0xEB, 0x3A, 0xA9, 0xA6, 0xAE, 0xED, 0x56, 0x64, 0x6B, 0x9E, 0xB8, 0xF6, 0xF9, 0x69, 0xAF, 0xF5, 0xA2, 0x18, 0x6A, 0x99, 0x4B, 0xC6, 0x9B, 0x29, 0xBF, 0x9E, 0xF6, 0x3A, 0xAB, 0xB6, 0x55, 0xFE, 0x1B, 0xE7, 0x99, 0x3F, 0xF2,
    0xDB, 0x66, 0xAA, 0x35, 0xF2, 0xFA, 0x9E, 0x95, 0x57, 0x5E, 0x20, 0x67, 0xC3, 0xAA, 0xD2, 0xB8, 0xAB, 0xAA, 0x13, 0x87, 0x7A, 0x65, 0xC0, 0xE2, 0x1E, 0xFB, 0xF0, 0xC6, 0xC7, 0x76, 0x4C, 0xE6, 0x8E, 0x20, 0x63, 0x2C, 0x32, 0x94, 0x0E, 0x4B,
    0xEC, 0x1E, 0xAB, 0x29, 0x0B, 0x3B, 0x6E, 0x97, 0x9C, 0xB6, 0x7C, 0xED, 0xBE, 0x10, 0x2A, 0xDC, 0x6A, 0xC8, 0x76, 0xE2, 0x0C, 0xE0, 0xBD, 0x7A, 0x0A, 0x3C, 0x73, 0xBF, 0x00, 0xFE, 0x2A, 0x68, 0xB0, 0x7C, 0x1A, 0x2A, 0xC0, 0xD2, 0x4C, 0x37,
    0xED, 0xF4, 0xD3, 0x50, 0x47, 0x2D, 0xF5, 0xD4, 0x4B, 0x8B, 0x4B, 0xF4, 0xD5, 0x21, 0x09, 0x1B, 0xDC, 0xD6, 0x5C, 0x77, 0xED, 0xB5, 0x6D, 0x5E, 0x87, 0x2D, 0xF6, 0xD7, 0x5A, 0x77, 0x3D, 0xC0, 0xD9, 0x68, 0xA7, 0xAD, 0xF6, 0xDA, 0x6C, 0xA7,
    0x4D, 0x76, 0xD2, 0x5C, 0x9F, 0x4D, 0xC0, 0xDC, 0x74, 0xD7, 0x6D, 0xF7, 0xDD, 0x78, 0xD7, 0x7D, 0x36, 0xD7, 0x60, 0x03, 0xFF, 0x37, 0xC0, 0xDC, 0x95, 0x06, 0x2E, 0xF8, 0xE0, 0x03, 0xCE, 0x3D, 0xC0, 0xD6, 0x7D, 0xFF, 0xF6, 0x77, 0x03, 0x0E,
    0x34, 0xDE, 0xB8, 0x41, 0x8E, 0x47, 0x2E, 0x79, 0x20, 0x92, 0x4B, 0xDE, 0x00, 0x01, 0x87, 0x0B, 0x57, 0xB6, 0xE2, 0x04, 0x34, 0xD0, 0x40, 0x04, 0xA0, 0x83, 0x1E, 0x48, 0xE8, 0xA3, 0x87, 0x6E, 0x3A, 0xE9, 0xA7, 0x9F, 0xEE, 0x39, 0xE6, 0x9A,
    0xC3, 0xED, 0x77, 0xE7, 0x0D, 0x50, 0x20, 0xBB, 0xEC, 0x81, 0xCC, 0x5E, 0x3B, 0x05, 0x04, 0xD9, 0x7E, 0xFB, 0xEE, 0xB3, 0xF7, 0xBE, 0x7A, 0xE6, 0xBF, 0x25, 0xDE, 0xDB, 0xE2, 0x0D, 0x3C, 0x60, 0xBC, 0xF1, 0x06, 0x21, 0xAF, 0x7C, 0x20, 0xCB,
    0x3F, 0xC0, 0xFC, 0xF1, 0xD0, 0xFF, 0xDE, 0x3A, 0xA6, 0xC1, 0x11, 0xEF, 0xF9, 0xF5, 0x81, 0x60, 0xDF, 0x40, 0xF6, 0xDB, 0x77, 0xDF, 0x3D, 0x41, 0xD7, 0x87, 0x1F, 0x3E, 0xEB, 0xC0, 0x09, 0xAF, 0x1B, 0xF1, 0x15, 0xA4, 0x9F, 0x7E, 0x20, 0xEA,
    0xB3, 0xCF, 0x7E, 0x05, 0xEE, 0xAF, 0x0F, 0xFF, 0xFC, 0xEA, 0xD7, 0x2F, 0x7D, 0xF9, 0x9B, 0xFB, 0x46, 0x3C, 0x04, 0xFC, 0xF3, 0x6F, 0x50, 0xFF, 0x04, 0x01, 0x60, 0x20, 0xFC, 0x47, 0xC0, 0xFE, 0xF5, 0xEF, 0x7E, 0xC1, 0xCB, 0x9F, 0xFE, 0x3A,
    0x27, 0x81, 0x06, 0x3A, 0xF0, 0x81, 0x10, 0x8C, 0xA0, 0x04, 0x1F, 0x78, 0x39, 0xE0, 0x25, 0xD0, 0x75, 0xAF, 0x23, 0xC0, 0x04, 0x36, 0xC8, 0xC1, 0x0E, 0x7A, 0xF0, 0x83, 0x20, 0xEC, 0xA0, 0xE1, 0x10, 0xA7, 0x40, 0xFD, 0xFD, 0x2D, 0x6F, 0x28,
    0x4C, 0xA1, 0xDE, 0x2C, 0x78, 0x41, 0xEA, 0x99, 0xAD, 0x6D, 0x30, 0x8C, 0xA1, 0xDB, 0xBA, 0x66, 0xBE, 0xB1, 0xD9, 0xF0, 0x86, 0x35, 0xBC, 0xA1, 0x0E, 0xDF, 0x86, 0xA9, 0xE9, 0xF8, 0xF0, 0x87, 0xD3, 0xE9, 0x21, 0x10, 0x11, 0x87, 0x48, 0x44,
    0x96, 0xF8, 0x0C, 0x6B, 0xFD, 0x3A, 0x8F, 0x12, 0x97, 0xC8, 0xC4, 0x82, 0x04, 0x04, 0x00, 0x21, 0xF9, 0x04, 0x05, 0x14, 0x00, 0x83, 0x00, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x46, 0x00, 0x46, 0x00, 0x00, 0x08, 0xFF, 0x00, 0x07, 0x09, 0xB4, 0x60,
    0x41, 0xA0, 0xC1, 0x83, 0x08, 0x13, 0x2A, 0x5C, 0xC8, 0xB0, 0xE1, 0xC1, 0x40, 0x81, 0x10, 0x72, 0xE0, 0x30, 0x08, 0xA2, 0xC3, 0x8B, 0x18, 0x33, 0x2E, 0x14, 0x24, 0xA8, 0x62, 0xC4, 0x41, 0x1E, 0x20, 0x72, 0xD4, 0x48, 0xB2, 0x64, 0x43, 0x40,
    0x80, 0x38, 0x5A, 0xFC, 0x10, 0x48, 0x10, 0x4A, 0x04, 0x83, 0x38, 0xC2, 0x14, 0x34, 0xD3, 0xA4, 0x4D, 0x87, 0x08, 0x10, 0xA0, 0x14, 0x14, 0x11, 0x44, 0xCB, 0x9D, 0x83, 0x0C, 0xC4, 0x14, 0x28, 0xB4, 0xE3, 0xCD, 0xA3, 0x09, 0x0D, 0x18, 0xD8,
    0x19, 0xB1, 0xE5, 0x20, 0xA0, 0x02, 0x17, 0x44, 0x1D, 0x1A, 0x53, 0xAA, 0x51, 0xA4, 0x26, 0x17, 0x48, 0x65, 0xEA, 0x14, 0xEA, 0xA0, 0x03, 0x31, 0xC1, 0x0A, 0x12, 0x2B, 0x16, 0xAB, 0xCD, 0x03, 0x60, 0xB9, 0x76, 0xF4, 0x9A, 0x20, 0x66, 0x5B,
    0x41, 0x6F, 0xDF, 0x9A, 0x35, 0x99, 0xA0, 0xAD, 0xDA, 0xA7, 0x29, 0x07, 0x31, 0x30, 0x28, 0x68, 0x6F, 0x47, 0x06, 0x7E, 0xAF, 0xCE, 0xCD, 0x08, 0x18, 0x2F, 0xCF, 0xAE, 0x80, 0x14, 0xC4, 0x14, 0xA4, 0x98, 0x31, 0xD5, 0x41, 0x8D, 0x07, 0x93,
    0x54, 0xA0, 0xF8, 0x2E, 0x4A, 0x87, 0x7F, 0xFE, 0x8C, 0x94, 0xAC, 0x31, 0xB3, 0x61, 0x91, 0x78, 0x39, 0x8B, 0x1E, 0x54, 0xA0, 0xC0, 0x67, 0xA7, 0xA3, 0x53, 0x0B, 0xB4, 0x0C, 0x48, 0xF5, 0xE0, 0x00, 0x01, 0x4E, 0xAF, 0x05, 0x14, 0xDB, 0x35,
    0x52, 0xD0, 0xAC, 0x03, 0x7C, 0xB4, 0xAD, 0x90, 0x63, 0x06, 0x85, 0x00, 0x00, 0x64, 0x10, 0x30, 0xFB, 0xF0, 0xEC, 0xD8, 0x57, 0x2D, 0x32, 0x4C, 0x8E, 0x94, 0x23, 0x00, 0x85, 0x7E, 0xFC, 0x00, 0x20, 0x2E, 0x1B, 0x6F, 0xED, 0x8F, 0x1D, 0x77,
    0x27, 0xCC, 0x6E, 0xD6, 0xB9, 0x1F, 0x07, 0x1B, 0x1E, 0x74, 0xFF, 0x80, 0xA0, 0x01, 0x83, 0x74, 0xEA, 0xB9, 0x05, 0x62, 0xAF, 0x38, 0x12, 0x74, 0x6F, 0xF5, 0xDA, 0x31, 0x7A, 0x07, 0x2F, 0x9E, 0xBC, 0xF9, 0xE9, 0xC5, 0x71, 0xD3, 0x7E, 0x5C,
    0x51, 0x3D, 0x55, 0xE3, 0x08, 0x45, 0xC4, 0x9D, 0x46, 0xF3, 0x85, 0x77, 0x81, 0x7D, 0xE7, 0xE5, 0x87, 0xD8, 0x75, 0x02, 0x19, 0xC5, 0x5C, 0x7F, 0x82, 0x41, 0xD8, 0x1F, 0x81, 0x82, 0x00, 0xF0, 0xDD, 0x06, 0x83, 0x5C, 0x70, 0x41, 0x79, 0x09,
    0x56, 0x87, 0x12, 0x83, 0x8F, 0xED, 0xC6, 0x5D, 0x84, 0x02, 0x4E, 0x98, 0xD1, 0x7C, 0x06, 0x69, 0x78, 0x1F, 0x7A, 0x29, 0xE9, 0x07, 0x22, 0x73, 0x30, 0x06, 0x38, 0x54, 0x7C, 0x0E, 0x15, 0x58, 0x1F, 0x87, 0xF8, 0x79, 0xB8, 0x5F, 0x72, 0x02,
    0x66, 0xE7, 0x54, 0x89, 0x0F, 0xCD, 0x48, 0x92, 0x8D, 0xE3, 0xE1, 0xC8, 0x22, 0x80, 0x1F, 0xD2, 0xC8, 0x5B, 0x83, 0x15, 0x42, 0xD7, 0x61, 0x6E, 0x4A, 0x2E, 0xE9, 0x1B, 0x70, 0xC2, 0x1D, 0xE9, 0x22, 0x55, 0xCA, 0x6D, 0x64, 0x62, 0x73, 0x82,
    0xFC, 0x96, 0x50, 0x70, 0xC3, 0x29, 0x78, 0x9C, 0x7F, 0x03, 0xF2, 0xE6, 0x9C, 0x93, 0x39, 0xA6, 0x27, 0x61, 0x4B, 0x3E, 0x92, 0xD8, 0x5E, 0x94, 0x17, 0x11, 0x89, 0x60, 0x9A, 0x2D, 0x2E, 0x48, 0xA6, 0x41, 0x40, 0x02, 0x78, 0x27, 0x9C, 0x0D,
    0xC9, 0x69, 0xA4, 0x98, 0xD6, 0x61, 0xD9, 0xA3, 0x7F, 0x6B, 0xAA, 0xC4, 0x67, 0x8D, 0x4D, 0x26, 0x14, 0x1D, 0x9D, 0x48, 0xEE, 0x67, 0xE2, 0x88, 0x78, 0x0A, 0x29, 0xA9, 0x49, 0x53, 0x7E, 0x59, 0x25, 0xA0, 0x1F, 0x12, 0x3A, 0xA3, 0x4A, 0x77,
    0xEE, 0x69, 0x93, 0x6F, 0x69, 0x98, 0x51, 0x06, 0x19, 0x1D, 0x9C, 0x81, 0xC6, 0x03, 0x14, 0x44, 0x60, 0xA5, 0x9D, 0x5B, 0x72, 0x1A, 0x69, 0x76, 0x6F, 0xDE, 0xFF, 0x04, 0xAA, 0xA8, 0xA4, 0x9A, 0x8A, 0xAA, 0xAA, 0x98, 0xD2, 0x76, 0xA8, 0x6A,
    0xB3, 0x8E, 0x5A, 0xEA, 0xA9, 0xA9, 0xAE, 0x7A, 0xDC, 0xAE, 0xA9, 0x55, 0x8A, 0x10, 0x98, 0xC2, 0x06, 0xCA, 0x23, 0x42, 0x65, 0x0E, 0x76, 0xA6, 0xA2, 0x4F, 0xD6, 0x39, 0xEC, 0xA4, 0x07, 0x35, 0x3B, 0x97, 0x9F, 0x2B, 0xE6, 0xAA, 0x9B, 0xA4,
    0x6F, 0xC2, 0xFA, 0x2A, 0x7B, 0x3E, 0x52, 0x68, 0x21, 0x7D, 0x45, 0x66, 0xAB, 0xE3, 0xB6, 0x90, 0x02, 0x89, 0x27, 0xA4, 0x9E, 0xCA, 0x57, 0xE1, 0x77, 0x29, 0x5E, 0x60, 0x2E, 0x94, 0x42, 0xB2, 0x7B, 0x58, 0x83, 0xEB, 0xAE, 0x79, 0xE2, 0xBB,
    0xE0, 0x65, 0xB8, 0xE1, 0xBC, 0xD2, 0x5A, 0x57, 0xE2, 0xC0, 0xFC, 0x49, 0xA8, 0x5E, 0xBA, 0xFB, 0x8E, 0x6B, 0xE0, 0x9C, 0xC9, 0x26, 0x59, 0xAF, 0xC1, 0x91, 0x3E, 0x4C, 0xB0, 0xBB, 0x0A, 0xDF, 0x08, 0x70, 0xA3, 0xE8, 0x4E, 0xD8, 0x2D, 0x7B,
    0xFA, 0x2E, 0xE6, 0x91, 0xB8, 0x17, 0x5A, 0x1C, 0x2D, 0xC6, 0xC4, 0x32, 0xBB, 0x25, 0xA5, 0x89, 0x22, 0xB4, 0x68, 0xC3, 0xBA, 0x2E, 0xD9, 0x5B, 0x97, 0x54, 0x86, 0x79, 0x6E, 0xC9, 0x2E, 0x1F, 0x24, 0x00, 0xCB, 0xB5, 0xD5, 0x5C, 0xD2, 0x48,
    0xAC, 0xE9, 0x6C, 0x93, 0x67, 0x3D, 0xFB, 0x5C, 0x12, 0xD0, 0x01, 0x5F, 0x86, 0xD9, 0x1F, 0xA3, 0x0D, 0x30, 0xC0, 0x45, 0x44, 0x37, 0xDA, 0x50, 0x66, 0x4A, 0x8F, 0x46, 0x00, 0x01, 0x51, 0x33, 0xD4, 0xB4, 0x7E, 0x56, 0xFF, 0x31, 0xC0, 0xD4,
    0xA3, 0x45, 0x37, 0xF5, 0xD2, 0x0B, 0x5D, 0x8D, 0x58, 0xD6, 0x5B, 0x37, 0x60, 0x90, 0x03, 0x0E, 0xC0, 0xD7, 0x50, 0xDA, 0x51, 0xA2, 0xDD, 0x00, 0xD5, 0x59, 0xEB, 0x18, 0xB6, 0xD6, 0x04, 0x34, 0x60, 0xB6, 0x40, 0x11, 0xF4, 0x97, 0x37, 0x9C,
    0x7B, 0x2F, 0xBF, 0x14, 0x41, 0x04, 0x76, 0xC3, 0xAD, 0x90, 0xD8, 0xB3, 0xCD, 0x5D, 0xF6, 0xDD, 0x83, 0x50, 0xD0, 0x9F, 0xE2, 0x81, 0x50, 0x40, 0x81, 0x45, 0x8E, 0x43, 0xC4, 0x38, 0xE3, 0x08, 0x39, 0x1E, 0x38, 0xD8, 0x09, 0x11, 0x1E, 0xDA,
    0xE0, 0x74, 0xDB, 0x6D, 0xD0, 0x03, 0x0F, 0xC0, 0x17, 0x7A, 0x20, 0xA1, 0xAB, 0x57, 0x7A, 0xC4, 0x07, 0x81, 0x7E, 0xF9, 0xDC, 0x72, 0x73, 0xBE, 0x35, 0x42, 0x66, 0x47, 0x84, 0x78, 0x20, 0xB3, 0xDF, 0xDD, 0x40, 0x96, 0x09, 0xAD, 0xCE, 0x79,
    0xEB, 0x99, 0x77, 0x8E, 0x78, 0x05, 0xFD, 0x01, 0xAF, 0x9E, 0xF0, 0x15, 0x11, 0xAF, 0xA9, 0x41, 0x15, 0x54, 0xA0, 0x7B, 0xEF, 0xBC, 0x23, 0x04, 0x75, 0xDD, 0x88, 0x43, 0x00, 0x81, 0xDA, 0xD2, 0x5B, 0x54, 0x7D, 0x20, 0xD3, 0x63, 0x7F, 0xB2,
    0xF4, 0xCB, 0x3B, 0x8F, 0x74, 0xD0, 0xAE, 0xD7, 0x3D, 0x9A, 0x04, 0x12, 0xBC, 0x8D, 0x39, 0xF3, 0xE0, 0xF7, 0xBE, 0x35, 0x01, 0xA3, 0x4D, 0x30, 0xC1, 0xD7, 0x71, 0xA7, 0xAF, 0xFE, 0xF9, 0x83, 0x7D, 0x4D, 0xBF, 0xF7, 0xCD, 0xB3, 0x2E, 0x5A,
    0xD5, 0x4F, 0x7F, 0x5F, 0x74, 0x6B, 0x42, 0x23, 0x89, 0xE6, 0x8C, 0x16, 0xC0, 0x8C, 0x68, 0xAE, 0x80, 0x37, 0xB9, 0x0B, 0x02, 0x6D, 0xC2, 0x95, 0x05, 0x1E, 0xC5, 0x55, 0x0E, 0xBC, 0x09, 0x44, 0x02, 0x02, 0x00, 0x21, 0xF9, 0x04, 0x05, 0x14,
    0x00, 0x83, 0x00, 0x2C, 0x44, 0x00, 0x3A, 0x00, 0x02, 0x00, 0x0B, 0x00, 0x00, 0x08, 0x0F, 0x00, 0x03, 0x0D, 0x12, 0x18, 0x48, 0x50, 0xC1, 0x83, 0x06, 0x13, 0x22, 0x14, 0x18, 0x10, 0x00, 0x21, 0xF9, 0x04, 0x05, 0x14, 0x00, 0x83, 0x00, 0x2C,
    0x43, 0x00, 0x38, 0x00, 0x03, 0x00, 0x0D, 0x00, 0x00, 0x08, 0x15, 0x00, 0x03, 0x09, 0x0A, 0x44, 0x90, 0xE0, 0x40, 0x81, 0x03, 0x05, 0x25, 0x5C, 0x88, 0xB0, 0xE1, 0xC1, 0x82, 0x0C, 0x03, 0x02, 0x00, 0x21, 0xF9, 0x04, 0x05, 0x14, 0x00, 0x83,
    0x00, 0x2C, 0x42, 0x00, 0x36, 0x00, 0x04, 0x00, 0x0E, 0x00, 0x00, 0x08, 0x20, 0x00, 0x03, 0x01, 0x12, 0x14, 0xA8, 0x20, 0xC1, 0x40, 0x07, 0x11, 0x1E, 0x14, 0xC4, 0x50, 0x21, 0x41, 0x86, 0x0F, 0x1B, 0x42, 0x44, 0x48, 0xB1, 0xE2, 0x40, 0x81,
    0x17, 0x01, 0x5D, 0x0C, 0x08, 0x00, 0x21, 0xF9, 0x04, 0x05, 0x14, 0x00, 0x83, 0x00, 0x2C, 0x41, 0x00, 0x34, 0x00, 0x05, 0x00, 0x0E, 0x00, 0x00, 0x08, 0x28, 0x00, 0x03, 0x01, 0x02, 0x24, 0x28, 0x90, 0x41, 0x82, 0x06, 0x0B, 0x16, 0x0C, 0x24,
    0x68, 0x21, 0xC3, 0x86, 0x09, 0x1B, 0x2A, 0x94, 0xF8, 0x10, 0xA2, 0x44, 0x85, 0x0F, 0x0F, 0x32, 0x14, 0x08, 0x88, 0xE1, 0x40, 0x84, 0x1F, 0x0B, 0x06, 0x04, 0x00, 0x21, 0xF9, 0x04, 0x05, 0x14, 0x00, 0x83, 0x00, 0x2C, 0x3F, 0x00, 0x32, 0x00,
    0x07, 0x00, 0x0F, 0x00, 0x00, 0x08, 0x34, 0x00, 0x03, 0x0D, 0x1A, 0x48, 0x30, 0x90, 0x40, 0x82, 0x83, 0x02, 0x09, 0x42, 0x98, 0x50, 0xD0, 0xC2, 0x82, 0x0E, 0x11, 0x2A, 0x7C, 0x38, 0x70, 0xA2, 0xC4, 0x88, 0x10, 0x1F, 0x1A, 0x54, 0x58, 0x70,
    0x23, 0xA0, 0x83, 0x06, 0x07, 0x7D, 0x5C, 0x78, 0x10, 0xD0, 0x48, 0x82, 0x80, 0x1A, 0x32, 0x4C, 0x38, 0x28, 0x20, 0x00, 0x21, 0xF9, 0x04, 0x05, 0x14, 0x00, 0x83, 0x00, 0x2C, 0x3D, 0x00, 0x2E, 0x00, 0x09, 0x00, 0x13, 0x00, 0x00, 0x08, 0x4F,
    0x00, 0x03, 0x0D, 0x1A, 0x48, 0x70, 0x60, 0x20, 0x81, 0x05, 0x0D, 0x0A, 0x42, 0x58, 0x30, 0x90, 0xA0, 0x85, 0x09, 0x1D, 0x3E, 0x64, 0x38, 0x48, 0xE2, 0x44, 0x82, 0x12, 0x07, 0x5D, 0xAC, 0xF8, 0x70, 0xE0, 0xC5, 0x8C, 0x15, 0x43, 0x3A, 0xC4,
    0x08, 0x48, 0x50, 0xC5, 0x40, 0x7F, 0x10, 0xAA, 0x1C, 0x94, 0xD2, 0x60, 0x48, 0x96, 0x2D, 0x13, 0xFE, 0xF9, 0x93, 0x70, 0xE0, 0x4C, 0x97, 0x04, 0x69, 0x0E, 0x02, 0x04, 0xA8, 0xE6, 0xC0, 0x9E, 0x14, 0x7F, 0xBE, 0x4C, 0x68, 0x32, 0x20, 0x00,
    0x21, 0xF9, 0x04, 0x05, 0x14, 0x00, 0x83, 0x00, 0x2C, 0x3C, 0x00, 0x2C, 0x00, 0x09, 0x00, 0x11, 0x00, 0x00, 0x08, 0x44, 0x00, 0x03, 0x0D, 0x1A, 0x48, 0x70, 0x60, 0x20, 0x81, 0x05, 0x0D, 0x0A, 0x42, 0x58, 0x30, 0x90, 0xA0, 0x85, 0x09, 0x1D,
    0x0E, 0x82, 0x48, 0x50, 0xE2, 0x44, 0x86, 0x16, 0x2F, 0x2A, 0x2C, 0x08, 0x31, 0xE3, 0xC1, 0x41, 0x07, 0x29, 0x06, 0x02, 0x04, 0x08, 0xE2, 0x1F, 0x86, 0x25, 0x03, 0xFD, 0xF9, 0x93, 0x70, 0xE0, 0xCA, 0x96, 0x83, 0x58, 0xC2, 0x8C, 0x58, 0x32,
    0x21, 0xC9, 0x9A, 0x36, 0x01, 0x0D, 0x0A, 0x08, 0x00, 0x21, 0xF9, 0x04, 0x05, 0x14, 0x00, 0x83, 0x00, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x08, 0x04, 0x00, 0x07, 0x05, 0x04, 0x00, 0x21, 0xF9, 0x04, 0x05, 0x14, 0x00,
    0x83, 0x00, 0x2C, 0x39, 0x00, 0x28, 0x00, 0x0C, 0x00, 0x13, 0x00, 0x00, 0x08, 0x5C, 0x00, 0x03, 0x0D, 0x1A, 0x48, 0xB0, 0xE0, 0xA0, 0x40, 0x02, 0x0D, 0x16, 0x0C, 0x24, 0x28, 0xA1, 0xC2, 0x83, 0x82, 0x1A, 0x3E, 0x84, 0x18, 0xD1, 0xE1, 0xC2,
    0x88, 0x15, 0x15, 0x32, 0x8C, 0x38, 0x48, 0xE2, 0xC2, 0x81, 0x82, 0x40, 0x5A, 0xDC, 0x18, 0x12, 0xE1, 0x41, 0x82, 0x0C, 0x19, 0x1E, 0xFC, 0xF3, 0x07, 0x10, 0xCA, 0x91, 0x2D, 0x5D, 0x9E, 0x5C, 0x18, 0x53, 0xE6, 0xC0, 0x3F, 0x09, 0x03, 0x01,
    0xDA, 0x19, 0xF2, 0xA6, 0x4A, 0x9D, 0x0A, 0x59, 0x0A, 0x8C, 0x69, 0xF0, 0xCF, 0x4D, 0xA2, 0x13, 0x6B, 0x26, 0xDD, 0x69, 0x53, 0xE1, 0xCE, 0x81, 0x01, 0x01, 0x00, 0x21, 0xF9, 0x04, 0x05, 0x14, 0x00, 0x83, 0x00, 0x2C, 0x08, 0x00, 0x10, 0x00,
    0x37, 0x00, 0x1E, 0x00, 0x00, 0x08, 0xFF, 0x00, 0x07, 0x09, 0x1C, 0x24, 0x68, 0xA0, 0x41, 0x83, 0x81, 0x0A, 0x16, 0x3C, 0xC8, 0xB0, 0xA1, 0xC3, 0x87, 0x03, 0x13, 0x42, 0x24, 0x38, 0xB1, 0xA2, 0xC5, 0x83, 0x12, 0x03, 0x09, 0x2C, 0x98, 0xB0,
    0xE3, 0x42, 0x8D, 0x82, 0x42, 0x5E, 0x1C, 0xB9, 0x51, 0xA4, 0x20, 0x89, 0x83, 0x3A, 0x52, 0xF4, 0x48, 0x50, 0x23, 0x45, 0x92, 0x16, 0x03, 0xC9, 0x7C, 0x39, 0xF0, 0xE4, 0xC7, 0x9B, 0x35, 0x61, 0xC2, 0xB4, 0x29, 0x50, 0x23, 0x4A, 0x89, 0x0B,
    0x73, 0xEA, 0x1C, 0xC9, 0x53, 0x26, 0xCF, 0x94, 0x3C, 0x4F, 0x6E, 0x1C, 0x3A, 0x31, 0xA4, 0xC8, 0x94, 0x2F, 0x7F, 0x7E, 0x34, 0x18, 0x94, 0xA9, 0xD5, 0xAB, 0x58, 0xB3, 0x6A, 0xC5, 0xD8, 0xD0, 0x25, 0x4D, 0xAD, 0x69, 0xCC, 0x94, 0x21, 0xD3,
    0xE1, 0x0C, 0x9A, 0x07, 0x14, 0x22, 0x70, 0xFC, 0x1A, 0x71, 0xEB, 0xC1, 0x0C, 0x61, 0xC7, 0x96, 0x3D, 0x9B, 0x76, 0x6D, 0xD5, 0x83, 0x36, 0x41, 0x06, 0x95, 0xE9, 0xF5, 0x62, 0x06, 0x00, 0x80, 0x03, 0x07, 0xCE, 0x60, 0xD7, 0xA1, 0xD2, 0xA3,
    0x2A, 0x7B, 0xEA, 0xF4, 0xC3, 0xB8, 0xB1, 0x9F, 0x92, 0x51, 0x9D, 0xB6, 0x5D, 0xB9, 0x77, 0x32, 0x49, 0x07, 0x1B, 0x1E, 0x74, 0x80, 0xA0, 0x01, 0xC3, 0xD2, 0xBE, 0x5D, 0x57, 0x22, 0x85, 0xAA, 0x78, 0x24, 0x00, 0x3F, 0x98, 0x35, 0x73, 0xC6,
    0xE0, 0x07, 0xC0, 0x5A, 0xBC, 0x08, 0x29, 0x2A, 0x6D, 0x69, 0xD9, 0xE2, 0x69, 0xC7, 0x8E, 0x5D, 0x93, 0x46, 0x58, 0x15, 0x25, 0xC1, 0x8F, 0x33, 0x61, 0x0A, 0x1E, 0x9E, 0x61, 0x28, 0x68, 0xB7, 0xC8, 0x99, 0x6E, 0x59, 0xCE, 0x9C, 0x79, 0xC9,
    0xA7, 0xB0, 0x1D, 0x1E, 0x1F, 0xB9, 0x05, 0x8E, 0xF5, 0xEB, 0xD7, 0xB7, 0x80, 0x7C, 0x78, 0x37, 0xB6, 0x72, 0x38, 0x77, 0xF0, 0xE8, 0x70, 0xE9, 0xC3, 0x67, 0x4F, 0x1E, 0x38, 0xDA, 0xD9, 0x62, 0x74, 0xC9, 0x51, 0xE5, 0xD4, 0x94, 0x7C, 0x21,
    0x56, 0x0F, 0x3F, 0xBE, 0xFC, 0xF9, 0xF4, 0xDD, 0x61, 0x27, 0x46, 0xCA, 0xDE, 0x67, 0xED, 0x83, 0xF3, 0xF1, 0x25, 0xD3, 0x7D, 0xDB, 0x71, 0x57, 0x1A, 0x65, 0xFD, 0xED, 0x36, 0x9D, 0x40, 0xF3, 0xE1, 0xE1, 0x93, 0x79, 0xE8, 0x15, 0x68, 0xA0,
    0x57, 0x1C, 0xCD, 0xA6, 0x94, 0x57, 0x0B, 0x0E, 0xD2, 0xA0, 0x1E, 0x02, 0x41, 0x88, 0x5F, 0x53, 0x50, 0x65, 0x94, 0xD8, 0x85, 0xFF, 0x19, 0xB4, 0xE1, 0x40, 0x04, 0xFA, 0x94, 0x21, 0x6D, 0x8A, 0x15, 0xE8, 0x12, 0x86, 0x0F, 0x9D, 0x38, 0x10,
    0x7A, 0x43, 0xE5, 0x07, 0x53, 0x75, 0xD7, 0x01, 0x98, 0x1C, 0x49, 0xCD, 0x31, 0x14, 0x10, 0x00, 0x21, 0xF9, 0x04, 0x05, 0x14, 0x00, 0x83, 0x00, 0x2C, 0x34, 0x00, 0x23, 0x00, 0x0B, 0x00, 0x0B, 0x00, 0x00, 0x08, 0x45, 0x00, 0x07, 0x01, 0x18,
    0x48, 0x90, 0xA0, 0x40, 0x3F, 0x08, 0x13, 0x26, 0x1C, 0xE8, 0xC7, 0xC1, 0x86, 0x07, 0x1D, 0x20, 0x68, 0xC0, 0xE0, 0x87, 0xA1, 0x43, 0x88, 0x12, 0x29, 0x5A, 0xBC, 0xC0, 0x91, 0xA3, 0x46, 0x00, 0x0D, 0x37, 0x5C, 0x18, 0x74, 0x61, 0x62, 0x45,
    0x90, 0x17, 0x07, 0x0D, 0x32, 0x69, 0xF1, 0xA1, 0xCA, 0x41, 0x1F, 0x43, 0x3E, 0x78, 0x39, 0xE8, 0xA4, 0x42, 0x9A, 0x02, 0x05, 0x1A, 0xC4, 0x19, 0x10, 0x00, 0x21, 0xF9, 0x04, 0x05, 0x14, 0x00, 0x83, 0x00, 0x2C, 0x38, 0x00, 0x28, 0x00, 0x0A,
    0x00, 0x0F, 0x00, 0x00, 0x08, 0x45, 0x00, 0x03, 0x5D, 0x18, 0x44, 0xB0, 0x20, 0xC1, 0x40, 0x83, 0x20, 0x18, 0x2C, 0x18, 0x48, 0x50, 0x20, 0x0D, 0x0B, 0x07, 0x35, 0x94, 0x88, 0x61, 0xE1, 0x44, 0x89, 0x7E, 0x0C, 0x5E, 0x94, 0x98, 0x81, 0xA1,
    0x20, 0x8D, 0x02, 0x0E, 0x7E, 0xD4, 0xF8, 0x71, 0x23, 0x42, 0x82, 0x80, 0x1A, 0x4E, 0x0C, 0xF4, 0x87, 0xE1, 0xA0, 0x3F, 0x2B, 0x5B, 0x4A, 0x6C, 0x19, 0x33, 0x62, 0x4D, 0x92, 0x33, 0x6D, 0xBE, 0x24, 0x18, 0x10, 0x00, 0x21, 0xF9, 0x04, 0x05,
    0x14, 0x00, 0x83, 0x00, 0x2C, 0x36, 0x00, 0x27, 0x00, 0x0B, 0x00, 0x10, 0x00, 0x00, 0x08, 0x56, 0x00, 0x03, 0x0D, 0x1A, 0x48, 0xB0, 0x60, 0xA0, 0x40, 0x17, 0x0A, 0x1A, 0x14, 0x34, 0x28, 0xA1, 0xC2, 0x41, 0x81, 0x04, 0x09, 0x0A, 0x04, 0xE1,
    0x61, 0x44, 0x86, 0x81, 0x34, 0x28, 0xBC, 0x38, 0x30, 0x90, 0x9F, 0x85, 0x0C, 0x3B, 0x02, 0x20, 0xC8, 0x91, 0xA4, 0x80, 0x8E, 0x83, 0x42, 0x1E, 0x3C, 0x88, 0x31, 0x24, 0xC4, 0x3F, 0x30, 0x61, 0x1E, 0xFC, 0x13, 0xF1, 0x25, 0xC9, 0x41, 0x7F,
    0x52, 0x4E, 0x84, 0x59, 0x30, 0x67, 0xCD, 0x40, 0x39, 0x37, 0x4A, 0x04, 0x1A, 0xD4, 0x20, 0x4E, 0x9E, 0x0F, 0x8F, 0x0E, 0x0C, 0x08, 0x00, 0x21, 0xF9, 0x04, 0x05, 0x14, 0x00, 0x83, 0x00, 0x2C, 0x34, 0x00, 0x26, 0x00, 0x0B, 0x00, 0x10, 0x00,
    0x00, 0x08, 0x55, 0x00, 0x03, 0x0D, 0x1A, 0x48, 0xB0, 0x60, 0xA0, 0x40, 0x0E, 0x0A, 0x1A, 0x14, 0x34, 0x68, 0x83, 0xC2, 0x81, 0x81, 0x04, 0x09, 0x0A, 0xF4, 0xE0, 0x61, 0x44, 0x86, 0x81, 0x3A, 0x28, 0xBC, 0x08, 0x11, 0xC2, 0x42, 0x86, 0x10,
    0xFD, 0x10, 0xE4, 0x38, 0x12, 0x00, 0x44, 0x89, 0x10, 0x0F, 0x06, 0x12, 0x30, 0x48, 0xE0, 0xC8, 0x41, 0x12, 0x25, 0x1E, 0xFC, 0x13, 0xB1, 0xE5, 0x9F, 0x97, 0x37, 0x65, 0xFE, 0xB9, 0x49, 0xF0, 0x66, 0xCD, 0x40, 0x3C, 0x3F, 0x02, 0x0D, 0x8A,
    0x73, 0xE7, 0xC3, 0x81, 0x46, 0x07, 0x05, 0x04, 0x00, 0x21, 0xF9, 0x04, 0x05, 0x14, 0x00, 0x83, 0x00, 0x2C, 0x33, 0x00, 0x25, 0x00, 0x0A, 0x00, 0x10, 0x00, 0x00, 0x08, 0x3E, 0x00, 0x03, 0x0D, 0x1A, 0x48, 0x90, 0xA0, 0xC0, 0x82, 0x05, 0x03,
    0x09, 0x42, 0x68, 0x70, 0x21, 0xC3, 0x41, 0x0A, 0x1F, 0x42, 0x74, 0xC8, 0x30, 0xE2, 0x43, 0x8B, 0x15, 0x29, 0x06, 0xDA, 0x38, 0x50, 0xE1, 0xC1, 0x40, 0x02, 0x42, 0x0A, 0x38, 0x78, 0xF1, 0xCF, 0x9F, 0x88, 0x81, 0xFE, 0x10, 0x54, 0x29, 0xB1,
    0x21, 0x44, 0x96, 0x08, 0x53, 0xC2, 0x2C, 0x68, 0x72, 0x60, 0x40, 0x00, 0x21, 0xF9, 0x04, 0x05, 0x14, 0x00, 0x83, 0x00, 0x2C, 0x31, 0x00, 0x24, 0x00, 0x0B, 0x00, 0x10, 0x00, 0x00, 0x08, 0x55, 0x00, 0x03, 0x0D, 0x1A, 0x48, 0xB0, 0x60, 0xA0,
    0x40, 0x82, 0x0A, 0x1A, 0x1C, 0x08, 0x40, 0xE1, 0x40, 0x81, 0x82, 0x02, 0xF9, 0x71, 0x08, 0x71, 0x50, 0x20, 0x07, 0x0A, 0x2B, 0x5A, 0xDC, 0xB0, 0x30, 0xE1, 0xC3, 0x07, 0x04, 0x35, 0x3E, 0xEC, 0xF0, 0x70, 0x90, 0xC7, 0x83, 0x07, 0x27, 0x0A,
    0x0C, 0x09, 0xA0, 0x65, 0xCB, 0x83, 0x02, 0x10, 0x5A, 0x14, 0x10, 0xD2, 0xE4, 0xC0, 0x88, 0x36, 0x09, 0xFE, 0xB1, 0x98, 0x30, 0xD0, 0xCE, 0x8C, 0x82, 0x22, 0xFE, 0xF9, 0xB9, 0x70, 0x28, 0x51, 0x85, 0x43, 0x07, 0x06, 0x04, 0x00, 0x21, 0xF9,
    0x04, 0x05, 0x14, 0x00, 0x83, 0x00, 0x2C, 0x2F, 0x00, 0x23, 0x00, 0x0B, 0x00, 0x10, 0x00, 0x00, 0x08, 0x53, 0x00, 0x03, 0x0D, 0x1A, 0x48, 0xB0, 0x60, 0xA0, 0x40, 0x82, 0x0A, 0x1A, 0x1C, 0x98, 0x50, 0xE1, 0x20, 0x81, 0x82, 0x10, 0x3A, 0x84,
    0xF8, 0x10, 0x80, 0x42, 0x8A, 0x0F, 0xFD, 0x2C, 0x6C, 0xF8, 0xD0, 0x01, 0x41, 0x8C, 0x03, 0x03, 0x6D, 0x08, 0x39, 0xA8, 0xE1, 0xC1, 0x83, 0x0F, 0x1E, 0x1A, 0xF4, 0xC3, 0x92, 0xE5, 0xC1, 0x88, 0x09, 0x03, 0x59, 0x24, 0x29, 0xA0, 0x64, 0x44,
    0x01, 0x35, 0x09, 0xC6, 0xDC, 0x39, 0x51, 0x50, 0xC4, 0x3F, 0x7F, 0x26, 0x0E, 0x02, 0x1A, 0xD4, 0xE1, 0xD0, 0xA2, 0x01, 0x01, 0x00, 0x21, 0xF9, 0x04, 0x05, 0x14, 0x00, 0x83, 0x00, 0x2C, 0x2E, 0x00, 0x22, 0x00, 0x0A, 0x00, 0x10, 0x00, 0x00,
    0x08, 0x3E, 0x00, 0x03, 0x0D, 0x1A, 0x48, 0x90, 0xA0, 0xC0, 0x82, 0x05, 0x03, 0x09, 0x42, 0x68, 0x70, 0x21, 0xC3, 0x41, 0x0A, 0x1F, 0x42, 0x74, 0xC8, 0x30, 0xE2, 0x43, 0x8B, 0x15, 0x29, 0x06, 0xDA, 0x38, 0x50, 0xE1, 0xC1, 0x40, 0x00, 0xFC,
    0x38, 0xD8, 0x70, 0xF0, 0xA2, 0x20, 0x41, 0x11, 0x41, 0x12, 0x14, 0x20, 0x31, 0xE1, 0x42, 0x8C, 0x09, 0xFF, 0xFC, 0x79, 0x28, 0x73, 0x60, 0x40, 0x00, 0x21, 0xF9, 0x04, 0x05, 0x14, 0x00, 0x83, 0x00, 0x2C, 0x2C, 0x00, 0x21, 0x00, 0x0B, 0x00,
    0x10, 0x00, 0x00, 0x08, 0x4E, 0x00, 0x03, 0x0D, 0x1A, 0x48, 0xB0, 0x60, 0xA0, 0x40, 0x82, 0x0A, 0x1A, 0x1C, 0x98, 0x50, 0xE1, 0x20, 0x81, 0x82, 0x10, 0x3A, 0x84, 0xF8, 0xB0, 0x21, 0x41, 0x8A, 0x15, 0x17, 0x5A, 0x94, 0x38, 0x10, 0x63, 0x47,
    0x00, 0x1D, 0x07, 0x35, 0x3C, 0x78, 0xD0, 0xCF, 0x43, 0x8D, 0x00, 0xFC, 0x38, 0x38, 0x18, 0x31, 0x21, 0xC7, 0x93, 0x0D, 0x23, 0x0E, 0x02, 0x49, 0xD0, 0xA5, 0xCB, 0x0C, 0x13, 0x05, 0x45, 0x14, 0x20, 0x60, 0x62, 0x4D, 0x87, 0x03, 0xFF, 0xFC,
    0x19, 0x18, 0x10, 0x00, 0x21, 0xF9, 0x04, 0x05, 0x14, 0x00, 0x83, 0x00, 0x2C, 0x2A, 0x00, 0x20, 0x00, 0x0B, 0x00, 0x10, 0x00, 0x00, 0x08, 0x46, 0x00, 0x03, 0x0D, 0x1A, 0x48, 0xB0, 0x60, 0xA0, 0x40, 0x82, 0x0A, 0x1A, 0x1C, 0x98, 0x50, 0xE1,
    0x20, 0x81, 0x82, 0x10, 0x3A, 0x84, 0xF8, 0xB0, 0x21, 0x41, 0x8A, 0x15, 0x17, 0x5A, 0x94, 0x58, 0xD0, 0x62, 0x46, 0x82, 0x0D, 0x0F, 0x1E, 0xF4, 0x38, 0x10, 0xA2, 0x20, 0x41, 0x00, 0x2A, 0x4A, 0xE4, 0x08, 0x92, 0x21, 0x46, 0x86, 0x19, 0x59,
    0x5E, 0x1C, 0x14, 0x91, 0xE6, 0xC4, 0x41, 0x02, 0x72, 0x3A, 0x64, 0xD8, 0x30, 0x20, 0x00, 0x21, 0xF9, 0x04, 0x05, 0x14, 0x00, 0x83, 0x00, 0x2C, 0x28, 0x00, 0x1F, 0x00, 0x0B, 0x00, 0x10, 0x00, 0x00, 0x08, 0x39, 0x00, 0x03, 0x09, 0x1A, 0x48,
    0xB0, 0x60, 0x20, 0x81, 0x05, 0x0D, 0x0A, 0x42, 0x98, 0x70, 0xE1, 0x40, 0x86, 0x0A, 0x1F, 0x36, 0x84, 0x08, 0xD1, 0x61, 0x44, 0x89, 0x09, 0x19, 0x52, 0x3C, 0x88, 0x50, 0x60, 0xC7, 0x8C, 0x1C, 0x31, 0x4A, 0x3C, 0x28, 0x92, 0xA0, 0xC7, 0x92,
    0x26, 0x51, 0x9A, 0x84, 0x28, 0xA0, 0xA5, 0xCB, 0x97, 0x02, 0x02, 0x02, 0x00, 0x21, 0xF9, 0x04, 0x05, 0x14, 0x00, 0x83, 0x00, 0x2C, 0x07, 0x00, 0x19, 0x00, 0x2D, 0x00, 0x0A, 0x00, 0x00, 0x08, 0x5F, 0x00, 0x01, 0x09, 0x1C, 0x48, 0xB0, 0xA0,
    0xC1, 0x83, 0x08, 0x13, 0x02, 0x12, 0xC4, 0x90, 0xE1, 0x41, 0x41, 0x0A, 0x23, 0x4A, 0x5C, 0x98, 0x10, 0xE2, 0xC4, 0x8B, 0x06, 0x2D, 0x0A, 0x6C, 0xB8, 0xB1, 0xA3, 0x46, 0x8B, 0x1C, 0x31, 0x12, 0xFC, 0x38, 0x10, 0xA2, 0xC9, 0x8E, 0x1E, 0x4B,
    0x8A, 0x54, 0x89, 0x92, 0xA2, 0x43, 0x95, 0x20, 0x59, 0xAE, 0x24, 0x99, 0x92, 0x64, 0xCC, 0x96, 0x80, 0x06, 0x5D, 0xA4, 0xE9, 0x92, 0xA2, 0x4C, 0x9E, 0x39, 0x75, 0x4A, 0xD4, 0xB8, 0xF0, 0xE5, 0x4D, 0x9F, 0x1B, 0x5F, 0x0E, 0x1C, 0xC4, 0x74,
    0xE5, 0x50, 0x89, 0x4C, 0x9B, 0x1E, 0x0C, 0x08, 0x00, 0x21, 0xF9, 0x04, 0x05, 0x14, 0x00, 0x83, 0x00, 0x2C, 0x28, 0x00, 0x1F, 0x00, 0x09, 0x00, 0x11, 0x00, 0x00, 0x08, 0x3B, 0x00, 0x01, 0x09, 0x1C, 0x48, 0xB0, 0xE0, 0xC0, 0x40, 0x06, 0x05,
    0x06, 0x42, 0x68, 0x30, 0x90, 0x20, 0x87, 0x82, 0x22, 0x46, 0x84, 0x08, 0x51, 0x62, 0xC5, 0x8A, 0x0F, 0x25, 0x66, 0x9C, 0xA8, 0x71, 0x23, 0x46, 0x8E, 0x18, 0x17, 0x8A, 0xF4, 0x68, 0x71, 0x24, 0xC9, 0x93, 0x1A, 0x29, 0x0A, 0x12, 0xC0, 0x52,
    0x00, 0x45, 0x01, 0x1D, 0x17, 0x46, 0x0C, 0x08, 0x00, 0x21, 0xF9, 0x04, 0x05, 0x14, 0x00, 0x83, 0x00, 0x2C, 0x27, 0x00, 0x21, 0x00, 0x0A, 0x00, 0x12, 0x00, 0x00, 0x08, 0x45, 0x00, 0x01, 0x09, 0x1C, 0x48, 0xB0, 0x60, 0x41, 0x41, 0x08, 0x13,
    0x2A, 0x0C, 0xA4, 0xB0, 0x61, 0x20, 0x86, 0x0D, 0x11, 0x32, 0x84, 0xE8, 0x50, 0x62, 0x44, 0x8A, 0x14, 0x2D, 0x26, 0xCC, 0x98, 0x51, 0x10, 0xC6, 0x8B, 0x1A, 0x25, 0x3E, 0x9C, 0xE8, 0x31, 0xA4, 0xC7, 0x40, 0x02, 0x20, 0xA2, 0x14, 0x90, 0x52,
    0x23, 0xC5, 0x3F, 0x30, 0xFF, 0xA8, 0x8C, 0x19, 0x73, 0xE6, 0x9F, 0x01, 0x38, 0x71, 0x3E, 0xCC, 0x19, 0x10, 0x00, 0x21, 0xF9, 0x04, 0x05, 0x14, 0x00, 0x83, 0x00, 0x2C, 0x27, 0x00, 0x24, 0x00, 0x09, 0x00, 0x11, 0x00, 0x00, 0x08, 0x41, 0x00,
    0x05, 0x0D, 0x1A, 0x48, 0x70, 0xA0, 0x20, 0x81, 0x05, 0x09, 0x06, 0x4A, 0xA8, 0x90, 0xA1, 0xC2, 0x40, 0x08, 0x13, 0x2E, 0x8C, 0x58, 0x70, 0xA2, 0x43, 0x8B, 0x09, 0x05, 0x1E, 0x34, 0xC8, 0x71, 0xE1, 0xA0, 0x83, 0x02, 0x17, 0x06, 0xF2, 0x08,
    0x71, 0x50, 0x49, 0x93, 0x22, 0x43, 0xFE, 0x31, 0x39, 0xB0, 0x64, 0xA0, 0x95, 0x15, 0x0F, 0x7A, 0x54, 0x28, 0x93, 0xE1, 0xC8, 0x81, 0x01, 0x01, 0x00, 0x21, 0xF9, 0x04, 0x05, 0x14, 0x00, 0x83, 0x00, 0x2C, 0x26, 0x00, 0x27, 0x00, 0x0A, 0x00,
    0x11, 0x00, 0x00, 0x08, 0x4E, 0x00, 0x07, 0x09, 0x12, 0x34, 0xA8, 0xA0, 0xC1, 0x82, 0x04, 0x09, 0x1E, 0x44, 0xB8, 0xB0, 0xE1, 0xA0, 0x40, 0x0A, 0x0D, 0x0A, 0x0A, 0xF4, 0x50, 0xA0, 0x41, 0x88, 0x15, 0x19, 0x3E, 0x54, 0x48, 0x91, 0x21, 0xC6,
    0x82, 0x81, 0x04, 0x88, 0x14, 0x80, 0x31, 0xE2, 0xC5, 0x81, 0x03, 0x17, 0x42, 0x44, 0x19, 0x88, 0xA2, 0xCB, 0x89, 0x29, 0x07, 0xC8, 0x7C, 0xF8, 0x72, 0x22, 0x01, 0x02, 0x19, 0x57, 0x0E, 0xF2, 0xD3, 0x70, 0x65, 0xC7, 0x83, 0x3E, 0x1D, 0x66,
    0x1C, 0x14, 0x10, 0x00, 0x21, 0xF9, 0x04, 0x05, 0x14, 0x00, 0x83, 0x00, 0x2C, 0x25, 0x00, 0x2A, 0x00, 0x0A, 0x00, 0x11, 0x00, 0x00, 0x08, 0x53, 0x00, 0x07, 0x0D, 0x12, 0x24, 0xB0, 0xA0, 0xC1, 0x81, 0x07, 0x07, 0x05, 0x22, 0x88, 0xD0, 0x60,
    0x20, 0x83, 0x0C, 0x05, 0x2E, 0x0C, 0x24, 0xA0, 0xA2, 0x80, 0x82, 0x0B, 0x15, 0x16, 0x64, 0x98, 0x51, 0xE1, 0x9F, 0x8F, 0x7F, 0x14, 0x46, 0x0C, 0x04, 0xF2, 0x4F, 0xC6, 0x88, 0x18, 0x05, 0xA9, 0x44, 0x29, 0x72, 0x65, 0xA0, 0x87, 0x30, 0x05,
    0x2D, 0x24, 0xE8, 0xA0, 0xA6, 0xC2, 0x87, 0x03, 0x65, 0x46, 0x88, 0x70, 0x50, 0xE5, 0x20, 0x0A, 0x09, 0x67, 0xE2, 0xEC, 0x29, 0x33, 0xA1, 0xC4, 0x82, 0x01, 0x01, 0x00, 0x21, 0xF9, 0x04, 0x05, 0x14, 0x00, 0x83, 0x00, 0x2C, 0x25, 0x00, 0x2C,
    0x00, 0x09, 0x00, 0x11, 0x00, 0x00, 0x08, 0x4A, 0x00, 0x05, 0x0D, 0x1A, 0x48, 0x70, 0xA0, 0x20, 0x81, 0x05, 0x09, 0x0A, 0x10, 0x90, 0x70, 0x60, 0xA0, 0x41, 0x08, 0x13, 0x06, 0xFA, 0xF3, 0xA7, 0xE1, 0xA0, 0x89, 0x15, 0x1B, 0x06, 0x1A, 0x30,
    0xC0, 0x62, 0x20, 0x02, 0x04, 0x1A, 0x0A, 0xF4, 0xE3, 0xC7, 0xA0, 0x41, 0x41, 0x0F, 0x21, 0x1E, 0xBC, 0x78, 0xF1, 0x21, 0x4A, 0x81, 0x29, 0x59, 0x9A, 0x0C, 0xF4, 0x40, 0x26, 0xC4, 0x8B, 0x0D, 0x24, 0x1E, 0x8C, 0xE9, 0x70, 0xA7, 0xC6, 0x94,
    0x01, 0x01, 0x00, 0x21, 0xF9, 0x04, 0x05, 0x14, 0x00, 0x83, 0x00, 0x2C, 0x24, 0x00, 0x2E, 0x00, 0x0A, 0x00, 0x12, 0x00, 0x00, 0x08, 0x5D, 0x00, 0x07, 0x09, 0x18, 0x44, 0xB0, 0x60, 0x41, 0x41, 0x82, 0x0C, 0x1A, 0xFC, 0xC3, 0x50, 0xE1, 0xA0,
    0x40, 0x0C, 0x1B, 0x1A, 0x0C, 0x34, 0x68, 0x80, 0xC5, 0x01, 0x13, 0x05, 0x05, 0x22, 0xC0, 0x91, 0x40, 0xC1, 0x40, 0x09, 0x03, 0xF9, 0x19, 0xE9, 0x87, 0x20, 0x48, 0x93, 0x0E, 0x52, 0x3A, 0x78, 0x98, 0xD0, 0x64, 0x84, 0x97, 0x11, 0x06, 0x25,
    0x6C, 0x99, 0x11, 0x21, 0x4D, 0x93, 0x36, 0x35, 0x52, 0xDC, 0x39, 0x33, 0x64, 0x85, 0x0A, 0x35, 0x03, 0x05, 0x82, 0xF0, 0x10, 0x67, 0x42, 0x09, 0x0E, 0x41, 0x6A, 0x4C, 0x8A, 0x90, 0x62, 0x52, 0xA7, 0x83, 0x02, 0x02, 0x00, 0x21, 0xF9, 0x04,
    0x05, 0x14, 0x00, 0x83, 0x00, 0x2C, 0x24, 0x00, 0x31, 0x00, 0x09, 0x00, 0x11, 0x00, 0x00, 0x08, 0x4F, 0x00, 0xFF, 0x0C, 0x1A, 0x48, 0x70, 0xE0, 0x80, 0x01, 0x05, 0x0B, 0x12, 0x20, 0x90, 0x70, 0x60, 0x20, 0x3F, 0x7E, 0x1A, 0x0E, 0x0A, 0xE4,
    0x40, 0xE2, 0xC4, 0x40, 0x11, 0x24, 0x06, 0xA2, 0x40, 0x41, 0x63, 0xA0, 0x07, 0x0D, 0x05, 0x0D, 0x6A, 0xD0, 0x60, 0xA0, 0xC8, 0x41, 0x82, 0x04, 0x05, 0x32, 0x99, 0x72, 0xA2, 0x43, 0x94, 0x81, 0x44, 0x06, 0x92, 0xE0, 0x70, 0x65, 0xCC, 0x89,
    0x13, 0x5C, 0x4E, 0x94, 0xC9, 0xB0, 0x60, 0x4C, 0x95, 0x09, 0x7F, 0xAE, 0x0C, 0x3A, 0x34, 0x20, 0x00, 0x21, 0xF9, 0x04, 0x05, 0x14, 0x00, 0x83, 0x00, 0x2C, 0x23, 0x00, 0x33, 0x00, 0x0A, 0x00, 0x12, 0x00, 0x00, 0x08, 0x5F, 0x00, 0x07, 0x11,
    0x18, 0x44, 0xB0, 0x60, 0x41, 0x3F, 0x7E, 0x0C, 0x1A, 0x74, 0xC0, 0x50, 0xE1, 0xA0, 0x40, 0x11, 0x22, 0x46, 0x50, 0x18, 0xE8, 0x21, 0x05, 0x0A, 0x0E, 0x05, 0x05, 0x0A, 0xF4, 0x80, 0xA3, 0x41, 0x41, 0x0F, 0x1B, 0x6C, 0x6C, 0x50, 0x10, 0xE4,
    0xC3, 0x40, 0x15, 0x50, 0x3E, 0x34, 0xF9, 0x10, 0x02, 0x84, 0x41, 0x10, 0x02, 0x81, 0x64, 0x59, 0x50, 0xA6, 0xA0, 0x9B, 0x14, 0x6F, 0xDE, 0xDC, 0xF8, 0x70, 0xA5, 0xCD, 0x41, 0x03, 0x82, 0x9E, 0x5C, 0xA9, 0xF1, 0xCF, 0x9F, 0x9E, 0x44, 0x07,
    0x1D, 0xCD, 0xA9, 0xD1, 0xA1, 0xCD, 0x8A, 0x4E, 0xA1, 0x0E, 0x0A, 0x08, 0x00, 0x21, 0xF9, 0x04, 0x05, 0x14, 0x00, 0x83, 0x00, 0x2C, 0x22, 0x00, 0x36, 0x00, 0x0A, 0x00, 0x10, 0x00, 0x00, 0x08, 0x57, 0x00, 0x07, 0x45, 0x18, 0x44, 0xB0, 0x60,
    0x41, 0x0A, 0x06, 0x13, 0x0E, 0x7A, 0xF0, 0x40, 0x61, 0xA0, 0x41, 0x0D, 0x1A, 0x38, 0x1C, 0x54, 0xA1, 0x42, 0xA0, 0x0A, 0x06, 0x03, 0x09, 0x0A, 0x14, 0x08, 0x02, 0x84, 0x8C, 0x82, 0x06, 0x05, 0x92, 0x40, 0x52, 0x02, 0x41, 0x8D, 0x27, 0x27,
    0xA8, 0x9C, 0x20, 0x32, 0xE4, 0x49, 0x02, 0x30, 0x09, 0xA0, 0x74, 0x09, 0x52, 0x90, 0xCD, 0x84, 0x1A, 0x6D, 0x6E, 0x7C, 0xC8, 0x73, 0xE3, 0x4D, 0x40, 0x40, 0x45, 0xF6, 0xDC, 0x18, 0xF4, 0xA1, 0xC8, 0x82, 0x34, 0x0D, 0xDE, 0x24, 0x18, 0x10,
    0x00, 0x21, 0xF9, 0x04, 0x05, 0x14, 0x00, 0x83, 0x00, 0x2C, 0x07, 0x00, 0x19, 0x00, 0x30, 0x00, 0x27, 0x00, 0x00, 0x08, 0xFF, 0x00, 0xFF, 0x08, 0x1C, 0x48, 0xB0, 0xA0, 0xC1, 0x83, 0x08, 0x13, 0x0E, 0x5A, 0xF8, 0x67, 0xA1, 0xC3, 0x83, 0x83,
    0x12, 0x4A, 0x9C, 0xD8, 0x90, 0xA1, 0xC0, 0x88, 0x08, 0x31, 0x52, 0xDC, 0x48, 0xF0, 0xE1, 0xC5, 0x8E, 0x16, 0x31, 0x46, 0xD4, 0x28, 0xD2, 0x22, 0xC7, 0x8A, 0x24, 0x07, 0xA6, 0x1C, 0xF9, 0xF1, 0x63, 0xCA, 0x93, 0x1E, 0x1B, 0xAA, 0x9C, 0x69,
    0x52, 0xA6, 0xC8, 0x99, 0x30, 0x4D, 0xBE, 0xB4, 0x29, 0xD3, 0x65, 0xCB, 0x9E, 0x1C, 0x63, 0xEE, 0x64, 0xA9, 0x11, 0xE8, 0xCE, 0x8D, 0x42, 0x41, 0xDE, 0x34, 0xAA, 0xF4, 0xE4, 0xC5, 0x9A, 0x4E, 0x8B, 0x3A, 0x55, 0xEA, 0xB0, 0xAA, 0xD5, 0xAB,
    0x58, 0xB3, 0x6A, 0xDD, 0xCA, 0xB5, 0xAB, 0xD7, 0xAF, 0x60, 0xC3, 0x8A, 0x1D, 0x4B, 0xB6, 0xAC, 0xD9, 0xB3, 0x68, 0xD3, 0xAA, 0x5D, 0xCB, 0xB6, 0xAD, 0xDB, 0xB7, 0x70, 0xE3, 0xCA, 0x9D, 0x4B, 0xB7, 0xAE, 0xDD, 0xB8, 0x6A, 0xF2, 0xEA, 0xDD,
    0xCB, 0xB7, 0xAF, 0xDF, 0xBD, 0x5F, 0xF3, 0xAE, 0x19, 0x4C, 0xB8, 0xB0, 0xE1, 0xC3, 0x88, 0x0B, 0xE7, 0xE5, 0xAA, 0x66, 0x70, 0x9B, 0xC7, 0x90, 0x23, 0x4B, 0x9E, 0x4C, 0x39, 0xF2, 0x60, 0x35, 0x5B, 0x1B, 0xB3, 0x91, 0xC3, 0x99, 0x73, 0xD5,
    0xCE, 0xA0, 0x43, 0x0F, 0x0A, 0x1D, 0x9A, 0xCD, 0x1A, 0xCC, 0x59, 0x35, 0xB3, 0x71, 0xC3, 0x9A, 0xF5, 0xA0, 0xD6, 0xAF, 0x5B, 0xCB, 0x86, 0x3D, 0x7B, 0x36, 0x1B, 0xD3, 0xA8, 0xAF, 0xAA, 0x9E, 0xC3, 0x9B, 0xF7, 0xA0, 0xDE, 0xBF, 0xE7, 0x2C,
    0x04, 0x1E, 0xBC, 0x78, 0xEF, 0xE3, 0xB7, 0x4F, 0xA7, 0x5E, 0x73, 0xBB, 0x8E, 0x73, 0xE7, 0x55, 0xA1, 0x4B, 0x1F, 0x34, 0xBD, 0x0E, 0xF5, 0xE7, 0xD8, 0x93, 0xE7, 0xB6, 0xAA, 0xFA, 0xB6, 0xF7, 0x41, 0xDF, 0xD9, 0x80, 0x60, 0x17, 0xBF, 0xF0,
    0x36, 0xF8, 0xF2, 0xDE, 0xD3, 0x7B, 0x57, 0x8E, 0x55, 0x35, 0x9D, 0xF7, 0xEF, 0x07, 0xC1, 0x97, 0x2F, 0x9F, 0x8E, 0xC3, 0xF8, 0xF6, 0xF3, 0xC3, 0xDF, 0xAF, 0x7D, 0xF9, 0x6D, 0x3B, 0x00, 0x02, 0x58, 0x55, 0x80, 0x0B, 0xD9, 0x31, 0xA0, 0x81,
    0x02, 0x06, 0xA8, 0x60, 0x7F, 0xFE, 0xBD, 0xE1, 0xE0, 0x83, 0x10, 0x46, 0x58, 0x55, 0x84, 0x14, 0x3A, 0x88, 0x5B, 0x66, 0x83, 0xC5, 0xA1, 0xE1, 0x86, 0x1C, 0x76, 0x68, 0x55, 0x87, 0x20, 0xC6, 0x71, 0x19, 0x63, 0x8D, 0x25, 0x76, 0xD8, 0x55,
    0x26, 0x5E, 0xB6, 0x5D, 0x66, 0x7F, 0xF5, 0xD5, 0x5E, 0x8B, 0x55, 0x05, 0x04, 0x00, 0x21, 0xF9, 0x04, 0x05, 0x14, 0x00, 0x83, 0x00, 0x2C, 0x0F, 0x00, 0x32, 0x00, 0x28, 0x00, 0x0E, 0x00, 0x00, 0x08, 0xD6, 0x00, 0x07, 0x09, 0x1C, 0xB4, 0xA5,
    0xA0, 0xC1, 0x83, 0x08, 0x13, 0x2A, 0x3C, 0x38, 0x70, 0x60, 0xC1, 0x30, 0x10, 0x23, 0x4A, 0x9C, 0x48, 0xB1, 0xA2, 0xC4, 0x82, 0x0E, 0x21, 0xFA, 0xD9, 0xC8, 0xB1, 0xA3, 0xC7, 0x8F, 0x20, 0x3B, 0x42, 0xDC, 0x22, 0x70, 0x4B, 0x98, 0x06, 0x0E,
    0x52, 0xA6, 0x6C, 0xA8, 0xB2, 0xA5, 0xCB, 0x41, 0x2E, 0x5D, 0x36, 0x08, 0x43, 0xD2, 0x64, 0x83, 0x06, 0x11, 0x72, 0xE6, 0x1C, 0xA4, 0x93, 0xA7, 0xCE, 0x9F, 0x3D, 0x81, 0x02, 0xBD, 0x49, 0xD3, 0x66, 0x03, 0x0A, 0x48, 0x91, 0x0E, 0x4A, 0xBA,
    0x94, 0x82, 0x40, 0xA6, 0x4D, 0xA3, 0x26, 0x9D, 0x4A, 0xF4, 0xE1, 0xCD, 0x07, 0x58, 0xB1, 0x36, 0xD4, 0xCA, 0x75, 0x50, 0xD7, 0x07, 0x5E, 0xB3, 0x8A, 0xAD, 0x6A, 0xF4, 0xA6, 0xD9, 0x41, 0x67, 0x1B, 0xA0, 0x55, 0x2B, 0xF0, 0x26, 0xDA, 0xB6,
    0x66, 0xE3, 0x9A, 0x2D, 0x7A, 0xB2, 0x41, 0x85, 0xBB, 0x77, 0x07, 0xE1, 0xD5, 0xAB, 0xB7, 0xC2, 0xC0, 0xBC, 0x7E, 0x03, 0xE3, 0x1D, 0x4C, 0xB6, 0x2E, 0x84, 0xC3, 0x87, 0x1B, 0x22, 0x16, 0x08, 0x41, 0x71, 0xE3, 0xC4, 0x88, 0x23, 0x57, 0x25,
    0x78, 0x52, 0x82, 0xE5, 0xCB, 0x98, 0x33, 0x37, 0xCC, 0xCC, 0xD9, 0xF2, 0x4C, 0x92, 0x94, 0xC3, 0x4C, 0x18, 0x4D, 0xBA, 0xB4, 0xE9, 0x86, 0x83, 0x4C, 0xAB, 0x9E, 0x30, 0xD2, 0xA1, 0x49, 0x8B, 0x14, 0x51, 0x0F, 0x82, 0x3D, 0x12, 0x74, 0xC3,
    0x85, 0x0A, 0x65, 0x13, 0xC4, 0xDD, 0x30, 0x20, 0x00, 0x21, 0xF9, 0x04, 0x05, 0x14, 0x00, 0x83, 0x00, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x46, 0x00, 0x46, 0x00, 0x00, 0x08, 0xFF, 0x00, 0x07, 0x09, 0x14, 0x68, 0xC1, 0xC2, 0xC0, 0x83, 0x08, 0x13,
    0x2A, 0x5C, 0xC8, 0xB0, 0x61, 0xC2, 0x40, 0x81, 0x10, 0x72, 0xE0, 0x30, 0x08, 0xA2, 0xC3, 0x8B, 0x18, 0x33, 0x2E, 0x14, 0x24, 0xA8, 0x62, 0x44, 0x0F, 0x1E, 0x20, 0x72, 0xD4, 0x48, 0xB2, 0x64, 0x43, 0x40, 0x80, 0x38, 0x46, 0xFC, 0xF0, 0x21,
    0x90, 0x20, 0x94, 0x08, 0x06, 0x71, 0x8C, 0x29, 0x88, 0xA6, 0xC9, 0x9B, 0x0E, 0x11, 0x20, 0x40, 0xD9, 0x11, 0x04, 0x08, 0x97, 0x3C, 0x07, 0x19, 0x90, 0x29, 0x70, 0x68, 0x47, 0x9C, 0x48, 0x13, 0x1A, 0x30, 0xC0, 0x13, 0x07, 0x0E, 0x97, 0x83,
    0x82, 0x0A, 0x5C, 0x30, 0x95, 0xA8, 0x4C, 0xAA, 0x47, 0x93, 0x9A, 0x5C, 0x40, 0x15, 0xE5, 0x8B, 0x17, 0x50, 0xA5, 0x0E, 0x3A, 0x20, 0x93, 0xAC, 0x20, 0xB3, 0x66, 0xB5, 0xDE, 0x3C, 0x40, 0x16, 0x25, 0x10, 0x20, 0x61, 0x53, 0x0E, 0x4C, 0x20,
    0x93, 0xAE, 0x20, 0xBB, 0x76, 0xD5, 0x9A, 0x4C, 0x40, 0x17, 0xE5, 0x8F, 0x1F, 0x71, 0x3B, 0x32, 0x18, 0x28, 0x68, 0xB0, 0x60, 0xC3, 0x59, 0xF5, 0x66, 0x64, 0x30, 0x18, 0x65, 0x89, 0x12, 0x71, 0x15, 0xC8, 0x14, 0x24, 0x99, 0xB2, 0xD5, 0x41,
    0x95, 0x15, 0x93, 0x54, 0x20, 0x19, 0xE5, 0x8C, 0x19, 0x71, 0x1D, 0xFE, 0xF9, 0x33, 0x52, 0xB3, 0xC6, 0xD1, 0x51, 0x01, 0x8D, 0x18, 0x11, 0xDA, 0xB4, 0xEB, 0x02, 0x05, 0x52, 0xB7, 0x68, 0x01, 0xD5, 0xB5, 0xED, 0x83, 0x28, 0x43, 0x84, 0x68,
    0x7D, 0x5B, 0x6F, 0x80, 0x00, 0xA9, 0x53, 0xA4, 0x88, 0x0B, 0xBC, 0xB7, 0x56, 0x91, 0xA9, 0x49, 0x90, 0x20, 0x1E, 0xD1, 0x38, 0x43, 0x8E, 0x19, 0x14, 0x02, 0x00, 0x90, 0x41, 0x40, 0x47, 0x94, 0x27, 0x4E, 0x10, 0xB7, 0x6A, 0xF1, 0x79, 0x45,
    0xBD, 0x1C, 0x01, 0x28, 0xFF, 0xF4, 0xE3, 0x07, 0x80, 0xF5, 0xD4, 0x3A, 0x74, 0x6C, 0xFF, 0xDE, 0xB1, 0xB9, 0xF3, 0xC9, 0x00, 0xFC, 0x38, 0xD8, 0xF0, 0xA0, 0x03, 0x04, 0x0D, 0x18, 0xCA, 0x9F, 0x47, 0xB9, 0x62, 0xC5, 0xFA, 0x88, 0xED, 0x8D,
    0x84, 0xDC, 0x41, 0x2E, 0xB5, 0xE7, 0x5E, 0x49, 0xE1, 0xC9, 0x47, 0x9F, 0x7D, 0xF8, 0xE9, 0x77, 0x1D, 0x20, 0x22, 0x88, 0xF0, 0xDF, 0x65, 0x00, 0x0A, 0x24, 0xC8, 0x80, 0xEC, 0x7D, 0x67, 0x52, 0x82, 0xF3, 0x3D, 0x70, 0xC1, 0x7D, 0xF9, 0x99,
    0xF7, 0x20, 0x0D, 0x34, 0x6C, 0x77, 0x94, 0x45, 0xA5, 0x35, 0x57, 0x61, 0x81, 0xDD, 0xDD, 0xC4, 0xE1, 0x06, 0x83, 0x5C, 0x70, 0x41, 0x83, 0x22, 0xA6, 0x16, 0x43, 0x0C, 0x13, 0x5A, 0x98, 0xA1, 0x40, 0x2B, 0xEA, 0x78, 0x20, 0x49, 0x1C, 0x0E,
    0x24, 0x63, 0x88, 0xFB, 0x01, 0xA2, 0x85, 0x16, 0x39, 0x12, 0xC5, 0x22, 0x8F, 0x14, 0x2A, 0xE9, 0xA2, 0x20, 0xF1, 0x75, 0xC8, 0x20, 0x91, 0x0F, 0x52, 0x41, 0x45, 0x92, 0x93, 0x1D, 0xB8, 0xA2, 0x80, 0x3F, 0x6A, 0xF4, 0x62, 0x7D, 0x20, 0x3A,
    0x98, 0x9A, 0x15, 0x56, 0x30, 0xF7, 0xDE, 0x46, 0x50, 0x8E, 0x27, 0x26, 0x4A, 0x4C, 0x30, 0x61, 0xE6, 0x99, 0x09, 0x8D, 0x16, 0x5D, 0x42, 0xD3, 0x55, 0xF7, 0x60, 0x16, 0x59, 0x30, 0xF7, 0x07, 0x61, 0x89, 0x0D, 0xB2, 0x67, 0x9F, 0x6A, 0xC9,
    0x99, 0x86, 0x19, 0x65, 0x90, 0xD1, 0xC1, 0x19, 0x68, 0x3C, 0x40, 0x41, 0x04, 0x45, 0x62, 0x81, 0x85, 0x99, 0x7F, 0x2A, 0x14, 0xA9, 0x69, 0x82, 0x12, 0x6A, 0x28, 0xA2, 0x8A, 0x32, 0xFA, 0x60, 0x15, 0x55, 0x40, 0x6A, 0x15, 0x6A, 0x1C, 0xFD,
    0xB9, 0xA7, 0x8E, 0xA2, 0xFE, 0x09, 0x28, 0x43, 0x72, 0x4A, 0x47, 0x5D, 0x91, 0x52, 0x48, 0xE1, 0x69, 0x47, 0x91, 0x8E, 0xFF, 0x4A, 0x58, 0xAC, 0x84, 0xF9, 0x79, 0x99, 0x68, 0x7F, 0x88, 0x97, 0x10, 0x79, 0x35, 0xA2, 0x34, 0xC5, 0x14, 0xAF,
    0xDA, 0x0A, 0xAB, 0x40, 0xA4, 0x1D, 0x25, 0xAB, 0x20, 0xB4, 0x9E, 0x2A, 0x69, 0xAE, 0x0A, 0x82, 0x49, 0x63, 0x91, 0x57, 0x5C, 0x11, 0x2C, 0xAD, 0x07, 0x0D, 0x6B, 0x61, 0xB2, 0x19, 0x8D, 0x16, 0xE5, 0x82, 0x61, 0xF6, 0x0A, 0x88, 0x0B, 0x2E,
    0x4C, 0x4B, 0x94, 0xAC, 0x3A, 0x0A, 0x6B, 0xEE, 0xA4, 0x17, 0x69, 0xAB, 0xA6, 0xB7, 0x2C, 0xB0, 0x10, 0xAC, 0x9F, 0xA6, 0x8A, 0x3A, 0xEE, 0xA7, 0xA6, 0x9E, 0xF6, 0xC7, 0x9C, 0x08, 0xD5, 0x59, 0x24, 0x0A, 0x28, 0xBC, 0x49, 0x12, 0xBA, 0x37,
    0x55, 0x5A, 0xE8, 0xA1, 0x89, 0x2E, 0x5A, 0xA4, 0x0F, 0x3E, 0xF8, 0x0B, 0x27, 0x9F, 0xF8, 0x1E, 0xA4, 0xEF, 0x83, 0x2A, 0xA8, 0x80, 0xA5, 0x97, 0x1A, 0x22, 0x98, 0xE6, 0xAE, 0x6B, 0x02, 0x62, 0x82, 0x09, 0x13, 0x67, 0xD4, 0xDE, 0x93, 0xDB,
    0x3A, 0x4B, 0x65, 0x6A, 0x4D, 0x34, 0x81, 0x25, 0x97, 0x29, 0x02, 0x78, 0x21, 0x8F, 0x28, 0x9F, 0xD8, 0xA5, 0x85, 0x50, 0x36, 0x3B, 0x65, 0xC6, 0x4E, 0x38, 0x91, 0xE4, 0xC7, 0x59, 0x55, 0xC8, 0xF2, 0xCA, 0x3B, 0x66, 0xF8, 0x72, 0x90, 0x02,
    0x0D, 0x99, 0xF1, 0x13, 0x4F, 0xDC, 0xDC, 0xB3, 0xCE, 0x47, 0x37, 0xF9, 0x71, 0x42, 0x2F, 0xC6, 0x38, 0xE3, 0xC8, 0x28, 0x8D, 0x31, 0x86, 0xD1, 0x48, 0x57, 0xAD, 0xF4, 0x40, 0x3D, 0x32, 0x1D, 0x73, 0x87, 0x1F, 0x3E, 0xFB, 0x20, 0x18, 0x60,
    0x50, 0x7D, 0xF5, 0xCE, 0x2A, 0x5E, 0xFD, 0xF3, 0xD6, 0xDC, 0x7A, 0x9D, 0x1A, 0x17, 0x5C, 0x98, 0x88, 0x75, 0x81, 0x1E, 0xE1, 0x5C, 0x91, 0x4A, 0x3B, 0xC7, 0xED, 0xB3, 0x42, 0x5F, 0xCE, 0xEC, 0xAD, 0x18, 0x62, 0x28, 0xFF, 0xBC, 0x30, 0x7C,
    0xEB, 0x16, 0xD9, 0x45, 0x17, 0x7E, 0x2F, 0x0C, 0x9D, 0xAA, 0x76, 0xA6, 0xE6, 0x85, 0x17, 0x85, 0xFF, 0xDD, 0x90, 0x00, 0x45, 0x7E, 0xF1, 0xC5, 0x7A, 0x8E, 0x7B, 0xF9, 0x20, 0x0F, 0x3C, 0xF0, 0x56, 0x79, 0xB6, 0x7B, 0xA2, 0x94, 0x43, 0x0E,
    0x9A, 0x6F, 0x9E, 0x6E, 0xE7, 0x80, 0xC8, 0x20, 0x43, 0xE8, 0xCB, 0xDA, 0xB6, 0xC5, 0x16, 0xA3, 0xA7, 0x56, 0x43, 0x0D, 0xA8, 0x1F, 0x34, 0xDA, 0xEA, 0xB6, 0x85, 0x11, 0x06, 0xED, 0xA8, 0x92, 0x0E, 0x03, 0x0C, 0xB1, 0x13, 0xFB, 0xC7, 0x16,
    0xB6, 0xDB, 0x46, 0x9E, 0xED, 0xAC, 0x2F, 0x84, 0x1A, 0x4A, 0x37, 0xDC, 0xD0, 0x3B, 0xBC, 0xC0, 0x37, 0x30, 0x90, 0x03, 0x0E, 0xF0, 0xF8, 0xF2, 0xF3, 0x15, 0x23, 0x04, 0x7D, 0x03, 0xB7, 0xE7, 0x9E, 0x9A, 0x0D, 0x36, 0xF4, 0x3E, 0x7B, 0x18,
    0x0D, 0x38, 0x2F, 0x50, 0x04, 0xDF, 0x91, 0x3F, 0xFD, 0x20, 0xE6, 0x2F, 0x14, 0x41, 0x04, 0xE1, 0x67, 0x9F, 0x3A, 0x4A, 0x3D, 0xF4, 0xE0, 0xFD, 0xEF, 0xE0, 0x8B, 0x3F, 0x08, 0x05, 0xDF, 0xE1, 0x1F, 0x08, 0x05, 0x14, 0x58, 0xC4, 0x3F, 0x44,
    0xFA, 0xD3, 0x1F, 0x42, 0xF8, 0xD7, 0xBE, 0xE2, 0xC5, 0x89, 0x74, 0x3B, 0xD8, 0xC1, 0xFC, 0x9A, 0x67, 0xBF, 0x07, 0x3C, 0x40, 0x7A, 0x0F, 0x0C, 0xC4, 0x03, 0x79, 0x34, 0x41, 0xAC, 0x25, 0xC4, 0x81, 0x05, 0x34, 0x1E, 0xE9, 0x82, 0x10, 0x84,
    0x05, 0x86, 0x01, 0x21, 0xCE, 0x8B, 0x88, 0xFD, 0x02, 0x31, 0x42, 0xF1, 0x35, 0xA0, 0x45, 0x09, 0xC9, 0xE0, 0xFB, 0x00, 0x21, 0x04, 0x21, 0x78, 0x30, 0x7C, 0x03, 0xA9, 0xC0, 0x77, 0x64, 0xC8, 0x23, 0x1A, 0x56, 0xC4, 0x86, 0x4C, 0x42, 0x48,
    0x05, 0x2A, 0xA0, 0xC2, 0x03, 0xA6, 0x66, 0x08, 0x43, 0x78, 0xA1, 0xFD, 0x80, 0x20, 0x00, 0x01, 0xE9, 0x0D, 0x82, 0x88, 0xEE, 0x81, 0x00, 0x44, 0x8A, 0x18, 0x08, 0x26, 0x22, 0x84, 0x88, 0x3D, 0x44, 0xC8, 0xF1, 0x00, 0x41, 0x04, 0x22, 0x2C,
    0xEF, 0x7B, 0xF6, 0xD3, 0x8C, 0x04, 0x24, 0x80, 0x3D, 0x03, 0xFA, 0x10, 0x25, 0x47, 0x38, 0xC2, 0x15, 0xE9, 0xF7, 0x41, 0xD7, 0x4C, 0x60, 0x02, 0xC4, 0xD3, 0x1E, 0x4A, 0x90, 0x80, 0x84, 0xE5, 0x31, 0xCF, 0x8B, 0x8A, 0x21, 0x1E, 0x1C, 0xA5,
    0x48, 0xBA, 0x25, 0x2C, 0xC1, 0x8D, 0xBE, 0x53, 0xDD, 0x1C, 0xBF, 0x08, 0x08, 0x28, 0x40, 0x01, 0x8F, 0xA2, 0x93, 0x1D, 0xE9, 0xA2, 0x10, 0x05, 0x40, 0x06, 0x32, 0x8F, 0x28, 0x49, 0x42, 0x12, 0x6A, 0x73, 0xC8, 0x92, 0xA0, 0x44, 0x09, 0x4A,
    0x60, 0x64, 0x23, 0x35, 0x82, 0x12, 0x23, 0x18, 0xE1, 0x7C, 0x93, 0x6C, 0x88, 0x20, 0x8A, 0x50, 0x84, 0x4C, 0xE2, 0x24, 0x20, 0x00, 0x21, 0xF9, 0x04, 0x05, 0x14, 0x00, 0x83, 0x00, 0x2C, 0x02, 0x00, 0x00, 0x00, 0x44, 0x00, 0x46, 0x00, 0x00,
    0x08, 0xFF, 0x00, 0x2D, 0x08, 0x1C, 0x48, 0xB0, 0xA0, 0x41, 0x0B, 0x81, 0x12, 0x2A, 0x5C, 0xC8, 0xB0, 0xA1, 0xC3, 0x87, 0x10, 0x03, 0x71, 0x98, 0x48, 0xB1, 0xA2, 0xC5, 0x8A, 0x0A, 0x05, 0x69, 0xDC, 0xC8, 0xB1, 0xA3, 0xC7, 0x8F, 0x20, 0x43,
    0x0A, 0xF2, 0x40, 0xB2, 0xA4, 0xC9, 0x93, 0x25, 0x13, 0x6A, 0x04, 0xC4, 0xB2, 0xA5, 0xCB, 0x97, 0x30, 0x63, 0xCA, 0x9C, 0x09, 0xE8, 0x83, 0xCD, 0x9B, 0x38, 0x73, 0xDE, 0x0C, 0x24, 0x88, 0x25, 0x82, 0x8D, 0x08, 0x7E, 0x06, 0x15, 0x14, 0xB4,
    0xA8, 0xD1, 0xA3, 0x48, 0x93, 0x2A, 0x45, 0x00, 0xA2, 0xA9, 0xD3, 0xA7, 0x50, 0x9D, 0xF2, 0x64, 0x29, 0xC8, 0x80, 0xD5, 0xAA, 0x56, 0x0D, 0x60, 0xCD, 0xCA, 0xB5, 0xAB, 0xD7, 0xAF, 0x60, 0x0D, 0xE0, 0x18, 0x4B, 0xB6, 0xAC, 0xD9, 0xB1, 0x53,
    0xA9, 0x2E, 0x58, 0xBB, 0x56, 0xD0, 0x82, 0x8D, 0x6F, 0xDB, 0xB2, 0x9D, 0x4B, 0xB7, 0xAE, 0x5D, 0xBA, 0x2F, 0xF2, 0xEA, 0xDD, 0xCB, 0x37, 0x6F, 0x5A, 0x40, 0x82, 0x0E, 0x08, 0x16, 0x1C, 0xF8, 0x40, 0xE1, 0xC3, 0x83, 0x13, 0x2B, 0x5E, 0xCC,
    0x58, 0x31, 0x90, 0xC7, 0x90, 0x23, 0x4B, 0x7E, 0xFC, 0x57, 0x50, 0x82, 0xCB, 0x97, 0x2D, 0x27, 0xD0, 0xCC, 0x19, 0xB3, 0xE7, 0xCF, 0xA0, 0x43, 0x7F, 0xFE, 0x41, 0xBA, 0xB4, 0xE9, 0xD3, 0xA4, 0x2B, 0x33, 0x58, 0x2D, 0x88, 0x41, 0x6B, 0xD7,
    0xAB, 0x5D, 0x6B, 0x8C, 0x4D, 0xBB, 0xB6, 0xED, 0xDB, 0xB5, 0x4B, 0xE8, 0xDE, 0xCD, 0xBB, 0xB7, 0xEE, 0xBF, 0x0A, 0x36, 0x2A, 0x08, 0x3E, 0x5C, 0xD0, 0xF0, 0xE3, 0xC6, 0x8F, 0x2B, 0x5F, 0xCE, 0xBC, 0xB9, 0xF2, 0x19, 0xD0, 0xA3, 0x4B, 0x9F,
    0x0E, 0xFD, 0xEF, 0x9F, 0xEB, 0xD8, 0xB3, 0x63, 0xD7, 0xA8, 0xBD, 0xBB, 0xF7, 0xEF, 0xDA, 0x47, 0x88, 0xFF, 0x1F, 0x4F, 0xBE, 0xBC, 0xF8, 0xBF, 0x05, 0xD2, 0xAB, 0x5F, 0xCF, 0xBE, 0xBD, 0xFB, 0xF7, 0xF0, 0x0B, 0xB4, 0x98, 0x4F, 0xBF, 0xBE,
    0xFD, 0xF9, 0x7F, 0x69, 0xEA, 0xDF, 0xCF, 0x3F, 0x84, 0xFF, 0xFF, 0x00, 0x06, 0xE8, 0xDF, 0x5F, 0x01, 0x14, 0x68, 0xE0, 0x81, 0x08, 0x26, 0xA8, 0xE0, 0x82, 0x0C, 0x06, 0x90, 0xC2, 0x83, 0x10, 0x46, 0x28, 0xE1, 0x83, 0x04, 0x46, 0x64, 0xE1,
    0x85, 0x17, 0x92, 0xA0, 0xE1, 0x86, 0x1C, 0x76, 0xA8, 0x61, 0x85, 0x22, 0x85, 0x28, 0x62, 0x88, 0x27, 0x94, 0x68, 0xE2, 0x89, 0x28, 0x96, 0x08, 0xE2, 0x42, 0x22, 0xF2, 0x34, 0xA2, 0x88, 0x3A, 0xC4, 0x28, 0xE3, 0x8C, 0x34, 0xC6, 0xB8, 0xE2,
    0x46, 0x2E, 0xBE, 0xA8, 0xE3, 0x47, 0x2B, 0xF4, 0xE8, 0xE3, 0x8F, 0x40, 0xF6, 0x78, 0xA3, 0x46, 0x2E, 0x66, 0x24, 0x08, 0x4F, 0x48, 0x12, 0xA9, 0xD2, 0x8E, 0x1C, 0x89, 0xE0, 0xE4, 0x93, 0x50, 0x46, 0xE9, 0xE4, 0x90, 0x47, 0x56, 0x49, 0xE4,
    0x91, 0x45, 0x5A, 0xA9, 0x25, 0x93, 0x34, 0x74, 0xE9, 0xE5, 0x97, 0x60, 0x76, 0xB9, 0xA2, 0x91, 0x58, 0xAA, 0x94, 0x63, 0x91, 0x39, 0x32, 0xA9, 0x51, 0x0C, 0x6C, 0xB6, 0xE9, 0xE6, 0x9B, 0x6C, 0x52, 0x79, 0xE5, 0x95, 0x67, 0x72, 0x94, 0x26,
    0x93, 0x5A, 0xE4, 0xA9, 0xE7, 0x9E, 0x7C, 0xE6, 0x29, 0xA7, 0x95, 0x66, 0xE2, 0xA8, 0xE5, 0x9D, 0x3A, 0x52, 0x61, 0xE8, 0xA1, 0x88, 0x26, 0x6A, 0xE8, 0x9F, 0x58, 0x56, 0x59, 0x67, 0x99, 0x6A, 0x6E, 0x64, 0xC5, 0xA4, 0x94, 0x56, 0x6A, 0xE9,
    0xA4, 0x20, 0x46, 0xAA, 0x29, 0x47, 0x4C, 0x74, 0xEA, 0xE9, 0xA7, 0xA0, 0x76, 0x5A, 0x21, 0x78, 0xA4, 0x96, 0x6A, 0xEA, 0x75, 0x59, 0xA4, 0xAA, 0xEA, 0xAA, 0xAC, 0xA6, 0x3A, 0x6A, 0x47, 0xDE, 0x09, 0xFF, 0x72, 0xEA, 0xAC, 0xD8, 0x61, 0x61,
    0xEB, 0xAD, 0xB8, 0xE6, 0x6A, 0xEB, 0xA8, 0xD7, 0xC9, 0xFA, 0x9D, 0xAF, 0xB4, 0x9E, 0x5A, 0xC5, 0xB0, 0xC4, 0x16, 0x6B, 0xEC, 0xB0, 0xBC, 0xFE, 0x01, 0xAC, 0xB2, 0xDC, 0x29, 0xDB, 0xAB, 0xB3, 0xCF, 0x32, 0xBB, 0xAC, 0xA9, 0x52, 0x54, 0x6B,
    0xED, 0xB5, 0xD8, 0x56, 0x9B, 0x2C, 0xB0, 0xDC, 0x3A, 0xEB, 0x6B, 0xB7, 0xDD, 0xCE, 0x3A, 0xC5, 0xB8, 0xE4, 0x96, 0x6B, 0xEE, 0xB8, 0xDB, 0x6E, 0xA7, 0x6E, 0xB3, 0xCF, 0x7E, 0xAB, 0xEE, 0xAC, 0x57, 0xC4, 0x2B, 0xEF, 0xBC, 0xF4, 0xC6, 0x9B,
    0x6E, 0xB4, 0xDE, 0x42, 0x9B, 0xAF, 0xBE, 0xD3, 0x92, 0xEA, 0xC2, 0xBF, 0x00, 0x07, 0x2C, 0xF0, 0xBF, 0xF7, 0xF2, 0xBB, 0x2F, 0xBE, 0xE1, 0x9E, 0xCA, 0xC2, 0xC2, 0x0C, 0x37, 0xEC, 0xF0, 0xC2, 0x05, 0x4B, 0x1B, 0x6D, 0xC2, 0x12, 0xD3, 0x8A,
    0xC2, 0xC5, 0x18, 0x67, 0xAC, 0xF1, 0xC5, 0xC9, 0x06, 0xAB, 0xAF, 0xC7, 0xD8, 0xF9, 0x20, 0xF2, 0xC8, 0x24, 0x97, 0x2C, 0x72, 0xA6, 0x9B, 0x6E, 0xAA, 0xC2, 0xCA, 0x2C, 0xB7, 0xEC, 0xF2, 0xCA, 0x8C, 0xEA, 0x48, 0xE8, 0x8B, 0x26, 0xD4, 0x6C,
    0xF3, 0xCD, 0x38, 0xD7, 0x1C, 0xF3, 0x8B, 0x33, 0x8F, 0xD8, 0xC4, 0xCF, 0x40, 0x37, 0x21, 0x48, 0xD0, 0x44, 0x33, 0x6A, 0x24, 0x8B, 0x4A, 0x02, 0xBA, 0x24, 0xD2, 0x1F, 0x39, 0xE1, 0xF4, 0xD3, 0x82, 0x38, 0x11, 0xF5, 0xD3, 0x54, 0xFF, 0x59,
    0xE7, 0xD5, 0x49, 0x63, 0x3D, 0xA7, 0x47, 0x4F, 0x74, 0xED, 0xB5, 0x20, 0x4F, 0x80, 0xED, 0xF5, 0xD8, 0x56, 0x0B, 0xAA, 0xB5, 0xA3, 0x66, 0x0B, 0xFA, 0xD1, 0x18, 0x6C, 0xB7, 0x2D, 0xC8, 0x18, 0x6F, 0xBB, 0x0D, 0x77, 0x95, 0x2D, 0x05, 0x90,
    0xA4, 0x9D, 0x69, 0xD3, 0x99, 0x37, 0xDA, 0x5B, 0x77, 0xFF, 0x04, 0xC6, 0xDF, 0x7F, 0x0B, 0x02, 0xB8, 0xE0, 0x81, 0x13, 0x5E, 0xB6, 0xDE, 0x88, 0x07, 0x8A, 0xF8, 0x96, 0x1C, 0x71, 0xE1, 0xB8, 0xE3, 0x82, 0x3C, 0x1E, 0x39, 0xE4, 0x8F, 0x8F,
    0x79, 0xF4, 0xD2, 0x6A, 0x2B, 0x7E, 0xB4, 0xDA, 0x1E, 0x89, 0xE1, 0xB9, 0x18, 0x1F, 0x79, 0x2E, 0xC8, 0xE7, 0x28, 0xA7, 0x1C, 0x69, 0x17, 0xA8, 0x77, 0x21, 0x48, 0xEA, 0xA8, 0xAF, 0xAE, 0x7A, 0xEA, 0xA5, 0x9B, 0xCE, 0xA4, 0x17, 0xB4, 0x0B,
    0x42, 0xFB, 0xED, 0xB5, 0x7B, 0x61, 0x3B, 0xED, 0x15, 0x0A, 0xE0, 0xFB, 0xEF, 0xC0, 0x07, 0x2F, 0xFC, 0xF0, 0xC4, 0x13, 0xFF, 0xC5, 0xF1, 0x82, 0x1C, 0xAF, 0x3C, 0xF2, 0x5F, 0x24, 0x7F, 0x3C, 0x81, 0xB2, 0x6F, 0xCA, 0xC3, 0xF4, 0xD4, 0x57,
    0x6F, 0xFD, 0xF4, 0xD6, 0x81, 0xAC, 0xFD, 0x77, 0x39, 0x74, 0xEF, 0xFD, 0xF7, 0xE0, 0x77, 0x9F, 0xFD, 0xF6, 0xE4, 0x63, 0x27, 0xC3, 0xF9, 0xE8, 0xA7, 0xAF, 0xFE, 0xF9, 0xE3, 0x97, 0xBA, 0xC5, 0xFB, 0xF0, 0xC7, 0x2F, 0xFF, 0xFC, 0xF4, 0xC7,
    0x5F, 0xC3, 0xFD, 0xF8, 0xE7, 0xAF, 0xFF, 0xFD, 0xED, 0x7F, 0xF7, 0x7E, 0x18, 0x00, 0x0C, 0xA0, 0x00, 0x07, 0x48, 0xC0, 0x02, 0x0A, 0x10, 0x06, 0x08, 0x4C, 0xA0, 0x02, 0x17, 0x88, 0xC0, 0xFE, 0x75, 0x67, 0x0B, 0x00, 0xF4, 0x83, 0x04, 0x27,
    0x48, 0xC1, 0x0A, 0x5A, 0xF0, 0x82, 0x14, 0xBC, 0x81, 0x06, 0x37, 0xC8, 0xC1, 0x0E, 0x6A, 0xD0, 0x81, 0xDA, 0x81, 0x60, 0x03, 0x1C, 0x40, 0x42, 0x12, 0x2E, 0xA4, 0x84, 0x28, 0x4C, 0x61, 0x20, 0x52, 0x98, 0x42, 0x1B, 0xB8, 0xF0, 0x85, 0x30,
    0x8C, 0xA1, 0x0B, 0x41, 0x88, 0x1D, 0x11, 0x36, 0x20, 0x02, 0x38, 0xC4, 0x61, 0x20, 0x72, 0xB8, 0xC3, 0x1C, 0xFA, 0x90, 0x87, 0x3F, 0xFC, 0x61, 0x0F, 0xFF, 0x86, 0x48, 0xC4, 0x22, 0x1A, 0x71, 0x88, 0x34, 0xBC, 0x8E, 0x0D, 0x29, 0xC0, 0x44,
    0x26, 0x06, 0xA2, 0x89, 0x4F, 0xA4, 0x40, 0x42, 0xA0, 0x18, 0xC5, 0x2A, 0x36, 0xF1, 0x8A, 0x3B, 0xC8, 0xA2, 0x16, 0xB7, 0xC8, 0xC5, 0x2C, 0x26, 0xF1, 0x0F, 0x36, 0x7C, 0x80, 0x18, 0xC5, 0xB8, 0x10, 0x32, 0x9A, 0x31, 0x10, 0x67, 0x7C, 0x00,
    0x1A, 0xC7, 0xC8, 0xC6, 0x20, 0xB8, 0xF1, 0x8D, 0x70, 0x8C, 0xA3, 0x1B, 0xBF, 0x18, 0x88, 0x30, 0x34, 0xE0, 0x8E, 0x78, 0x6C, 0x40, 0x20, 0xF0, 0xB8, 0xC7, 0x3D, 0xEA, 0xF1, 0x8F, 0x7F, 0x4C, 0x48, 0x1E, 0x07, 0x29, 0x84, 0x42, 0x1A, 0xF2,
    0x90, 0x88, 0x2C, 0x24, 0x1D, 0xFD, 0x58, 0x81, 0x46, 0x36, 0x32, 0x10, 0x8E, 0x84, 0x24, 0x24, 0x2B, 0x20, 0xC9, 0x47, 0x52, 0xF2, 0x92, 0x8E, 0xCC, 0xE4, 0x10, 0x36, 0xC9, 0xC9, 0x4E, 0x7A, 0x72, 0x93, 0x74, 0x3C, 0x52, 0x03, 0x20, 0x40,
    0x4A, 0x52, 0x2E, 0xA4, 0x94, 0x09, 0x41, 0x65, 0x20, 0x4C, 0xC9, 0xCA, 0x52, 0x96, 0x92, 0x08, 0xB0, 0x8C, 0xA5, 0x2C, 0x67, 0x09, 0xCB, 0x50, 0x1E, 0x49, 0x02, 0xB8, 0xCC, 0xA5, 0x2E, 0x77, 0xC9, 0xCB, 0x5E, 0xEA, 0xF2, 0x08, 0xC0, 0x0C,
    0xA6, 0x30, 0x87, 0x09, 0x4C, 0x5B, 0x1E, 0x69, 0x02, 0xC8, 0x4C, 0xA6, 0x32, 0x97, 0xC9, 0xCC, 0x66, 0x26, 0x13, 0x09, 0xD0, 0x8C, 0xA6, 0x34, 0xA7, 0x09, 0x4D, 0x63, 0x1E, 0xC9, 0x80, 0xD8, 0xCC, 0x66, 0x00, 0x97, 0xC0, 0xCD, 0x6E, 0x7A,
    0xF3, 0x9B, 0xDC, 0xB4, 0xE6, 0x91, 0xEA, 0x47, 0xCE, 0x72, 0xBE, 0x0F, 0x0A, 0xE8, 0x4C, 0xA7, 0x3A, 0xD7, 0x89, 0x4E, 0x71, 0x1E, 0xA9, 0x7C, 0xDD, 0x89, 0x82, 0x3C, 0xE7, 0x49, 0xCF, 0x7A, 0xCA, 0xD3, 0x9A, 0x0B, 0x81, 0x67, 0x76, 0x92,
    0xC0, 0x42, 0xCF, 0x7E, 0xFA, 0xF3, 0x9F, 0xFC, 0xCC, 0xCF, 0x4C, 0xEE, 0x16, 0x08, 0xFE, 0x18, 0xB4, 0x25, 0x4A, 0x48, 0xA8, 0x42, 0x17, 0xCA, 0xD0, 0x84, 0x0A, 0x54, 0x26, 0x09, 0x01, 0x44, 0x91, 0x0E, 0x6A, 0x50, 0x23, 0x58, 0xF4, 0xA2,
    0x18, 0xCD, 0xA8, 0x45, 0x7B, 0xE6, 0x91, 0x2C, 0x31, 0x4E, 0x76, 0x45, 0x08, 0xA9, 0x48, 0x47, 0x4A, 0xD2, 0x90, 0x62, 0xC8, 0x21, 0x4A, 0x3A, 0x29, 0x86, 0x02, 0x02, 0x00, 0x21, 0xF9, 0x04, 0x05, 0x14, 0x00, 0x83, 0x00, 0x2C, 0x13, 0x00,
    0x00, 0x00, 0x33, 0x00, 0x46, 0x00, 0x00, 0x08, 0xFF, 0x00, 0x07, 0x09, 0x14, 0x68, 0xA1, 0xA0, 0xC1, 0x83, 0x08, 0x13, 0x2A, 0x4C, 0x38, 0xB0, 0xA1, 0x43, 0x81, 0x1C, 0x22, 0x4A, 0x9C, 0x48, 0xB1, 0xA2, 0xC5, 0x8A, 0x81, 0x32, 0x3E, 0xDC,
    0xE8, 0xA1, 0xA3, 0xC7, 0x8F, 0x20, 0x43, 0x8A, 0x0C, 0x99, 0x51, 0x90, 0xA0, 0x8D, 0x0F, 0x3F, 0xA8, 0x5C, 0xC9, 0xB2, 0xA5, 0xCB, 0x97, 0x2E, 0x03, 0x09, 0x02, 0x04, 0x68, 0x90, 0xC9, 0x93, 0x36, 0x05, 0xE2, 0x1C, 0x04, 0xA2, 0xA7, 0xCF,
    0x9F, 0x40, 0x83, 0x0A, 0x0D, 0x2A, 0x93, 0xE6, 0xCE, 0x9D, 0x39, 0x07, 0xE1, 0x58, 0xCA, 0xB4, 0xA9, 0xD3, 0xA7, 0x50, 0x9F, 0x16, 0x35, 0xEA, 0xF0, 0xE4, 0xCD, 0x41, 0x2F, 0xB2, 0x6A, 0xDD, 0xCA, 0xB5, 0xAB, 0xD7, 0xAE, 0x53, 0x01, 0x21,
    0x4D, 0x8A, 0x13, 0x88, 0xD9, 0xB3, 0x68, 0xD3, 0xAA, 0x5D, 0xAB, 0x36, 0xEC, 0x58, 0x9C, 0x38, 0x7F, 0xC8, 0x9D, 0x4B, 0xB7, 0xAE, 0xDD, 0xBB, 0x76, 0xDD, 0x0E, 0xB4, 0xAA, 0x53, 0x60, 0x89, 0xBF, 0x80, 0x03, 0x0B, 0x1E, 0x4C, 0x78, 0x70,
    0x58, 0x9B, 0x26, 0xFB, 0x26, 0x9D, 0xC1, 0xB8, 0xB1, 0xE3, 0xC7, 0x90, 0x23, 0x43, 0x3E, 0x8C, 0x72, 0xE0, 0x88, 0xCB, 0x98, 0x33, 0x6B, 0xDE, 0xCC, 0x79, 0x33, 0xE5, 0xCA, 0x83, 0x5A, 0x88, 0x1E, 0x4D, 0xBA, 0xB4, 0xE9, 0xD3, 0xA6, 0x65,
    0x82, 0x76, 0x18, 0xA2, 0xB5, 0xEB, 0xD7, 0xB0, 0x63, 0xCB, 0x8E, 0xFD, 0xB9, 0x72, 0x8A, 0xDB, 0xB8, 0x73, 0xEB, 0xDE, 0xCD, 0x7B, 0xB7, 0x4D, 0x9A, 0x80, 0x02, 0xAC, 0x26, 0x41, 0xBC, 0xB8, 0xF1, 0xE3, 0xC8, 0x93, 0x23, 0x0F, 0x34, 0x08,
    0x78, 0x00, 0xE6, 0x95, 0x4F, 0x48, 0x9F, 0x4E, 0xBD, 0xBA, 0xF5, 0xEB, 0xD6, 0x99, 0x3B, 0x67, 0x9E, 0x51, 0x63, 0x43, 0x1D, 0xE0, 0xC3, 0x8B, 0xFF, 0x1F, 0x4F, 0xBE, 0x3C, 0x79, 0xED, 0x34, 0x9F, 0x0F, 0x82, 0xBE, 0xBE, 0xE1, 0x8A, 0xF7,
    0xF0, 0xE3, 0xCB, 0x9F, 0x4F, 0x7F, 0x3E, 0xFA, 0xE0, 0xDC, 0x07, 0x42, 0xCF, 0x28, 0xA2, 0xBF, 0xFF, 0xFF, 0x00, 0x06, 0x28, 0x60, 0x80, 0xF7, 0xA9, 0xC7, 0x5E, 0x7E, 0x83, 0xD0, 0xA0, 0xE0, 0x82, 0x0C, 0x36, 0xE8, 0xE0, 0x83, 0x0E, 0x16,
    0xC8, 0x5D, 0x77, 0xFA, 0x05, 0x12, 0xC3, 0x85, 0x18, 0x66, 0xA8, 0xE1, 0x86, 0x1C, 0x6E, 0x28, 0x61, 0x7B, 0x0D, 0x41, 0xA7, 0xC5, 0x88, 0x24, 0x8E, 0xB8, 0x53, 0x89, 0x83, 0x8C, 0x98, 0x94, 0x4D, 0x25, 0xB6, 0xF8, 0x21, 0x7B, 0x02, 0x41,
    0x47, 0xC5, 0x8C, 0x34, 0x52, 0x31, 0x48, 0x8D, 0x37, 0xCE, 0x28, 0xC8, 0x8C, 0x39, 0xD6, 0xE8, 0x23, 0x8D, 0x2F, 0x3E, 0x94, 0x91, 0x15, 0x44, 0x16, 0x29, 0x48, 0x91, 0x45, 0x0E, 0x42, 0xA4, 0x92, 0x56, 0x30, 0x89, 0xE4, 0x93, 0x45, 0x7E,
    0x58, 0x19, 0x13, 0x54, 0x56, 0x29, 0x48, 0x95, 0x58, 0x52, 0x79, 0x25, 0x13, 0x5B, 0x66, 0xE9, 0x25, 0x13, 0x61, 0xA9, 0x57, 0x59, 0x16, 0x64, 0x96, 0x29, 0x48, 0x99, 0x68, 0x92, 0x79, 0x66, 0x16, 0x56, 0x99, 0x94, 0x66, 0x9A, 0x61, 0x32,
    0x77, 0x53, 0x62, 0x03, 0x61, 0x61, 0xE7, 0x9D, 0x82, 0xDC, 0x89, 0x58, 0x9E, 0x58, 0xF0, 0xC9, 0xE7, 0x9D, 0x80, 0x06, 0x1A, 0xE7, 0x5E, 0x0F, 0x55, 0x61, 0xE8, 0xA1, 0x82, 0x1C, 0x8A, 0xA8, 0xA1, 0x83, 0x18, 0x9A, 0xA8, 0xA2, 0x90, 0x2A,
    0x3A, 0xA8, 0x62, 0x3A, 0x09, 0x22, 0xC5, 0xA5, 0x98, 0x5A, 0x8A, 0xE9, 0xA5, 0x9A, 0x76, 0xBA, 0xE9, 0xA7, 0x9F, 0x4A, 0xB9, 0x22, 0x4E, 0x53, 0x94, 0x6A, 0xEA, 0x14, 0x82, 0x9C, 0x9A, 0x6A, 0xA9, 0xAB, 0xAE, 0x7A, 0xEA, 0xAB, 0xA6, 0x8A,
    0xFF, 0x7A, 0x94, 0x40, 0x57, 0xD4, 0x6A, 0x6B, 0xAD, 0x89, 0x09, 0x72, 0xAB, 0xAE, 0x57, 0xF0, 0x7A, 0xEB, 0xAF, 0xB6, 0xCA, 0x4A, 0xE8, 0x20, 0x2E, 0x14, 0x6B, 0xEC, 0xB1, 0xC8, 0x26, 0xAB, 0x6C, 0xB2, 0xC2, 0x2A, 0xC6, 0xC2, 0xB3, 0xD0,
    0x46, 0x2B, 0xED, 0xB4, 0xD4, 0x4E, 0x3B, 0xE9, 0x8A, 0x88, 0xA1, 0xA0, 0xED, 0xB6, 0xDC, 0x76, 0xEB, 0xED, 0xB7, 0xDE, 0x5E, 0xBB, 0x91, 0x0F, 0xE4, 0x96, 0x6B, 0xEE, 0xB9, 0xE8, 0xA6, 0x8B, 0xAE, 0xA8, 0x1B, 0xA9, 0xE0, 0xEE, 0xBB, 0xF0,
    0xC6, 0x2B, 0xEF, 0xBC, 0xF2, 0x06, 0xB9, 0x91, 0x09, 0xF8, 0xE6, 0xAB, 0xEF, 0xBE, 0xFC, 0xF6, 0xCB, 0xAF, 0xBD, 0x0F, 0x35, 0x21, 0xB0, 0x20, 0x02, 0x17, 0x6C, 0xF0, 0xC1, 0x08, 0x1B, 0x4C, 0xB0, 0xC1, 0xBF, 0xA5, 0x67, 0x13, 0x8C, 0x31,
    0x06, 0xE2, 0xC4, 0xC4, 0x14, 0x57, 0x6C, 0xF1, 0xC5, 0x14, 0x0B, 0x82, 0xF1, 0xC4, 0xEC, 0xEA, 0x27, 0xD0, 0x13, 0x20, 0x87, 0x2C, 0xF2, 0xC8, 0x24, 0x87, 0x2C, 0x48, 0xC9, 0x20, 0x77, 0x1C, 0xA3, 0x40, 0x63, 0xB4, 0x2C, 0x88, 0xCB, 0x63,
    0x9C, 0xD4, 0x32, 0xCB, 0x2D, 0xC7, 0x6C, 0xD3, 0xCC, 0x32, 0x8F, 0x31, 0x48, 0xCD, 0x27, 0xA9, 0x0C, 0xA2, 0x20, 0x60, 0x80, 0x01, 0xB4, 0xD0, 0x83, 0x04, 0x2D, 0x50, 0xD0, 0x43, 0x17, 0x6D, 0x34, 0xD2, 0x41, 0x83, 0xA1, 0xB4, 0xD2, 0x3E,
    0x43, 0x27, 0x08, 0x17, 0x5C, 0x4C, 0x5D, 0x35, 0xD5, 0x57, 0x53, 0x3D, 0x08, 0xD6, 0x58, 0x6F, 0x9D, 0x75, 0xD6, 0x5E, 0x37, 0x8C, 0x5F, 0xC4, 0xDE, 0x95, 0x24, 0x86, 0x18, 0x82, 0x9C, 0x9D, 0xF6, 0xD9, 0x83, 0x9C, 0x2D, 0x46, 0xDB, 0x6C,
    0x0F, 0xC4, 0xB6, 0xDB, 0x70, 0xC3, 0xED, 0xF3, 0x5E, 0x5D, 0x74, 0x21, 0x48, 0xDE, 0x7B, 0xE7, 0xFF, 0x3D, 0x48, 0xDE, 0x5D, 0xFC, 0x1D, 0x38, 0xE0, 0x82, 0x0B, 0x3E, 0xF8, 0xE1, 0x77, 0xEB, 0xE4, 0x85, 0x17, 0x82, 0x2C, 0xDE, 0xB8, 0xE3,
    0x8B, 0x33, 0x0E, 0x39, 0xE3, 0x8F, 0x3F, 0x2E, 0xF9, 0xE5, 0xE2, 0x3E, 0x24, 0xC8, 0x17, 0x5F, 0x6C, 0xFE, 0xC5, 0x20, 0x9C, 0x7F, 0x1E, 0x3A, 0xE8, 0x9C, 0x0B, 0x24, 0xFA, 0xE7, 0xA4, 0x93, 0x8E, 0x7A, 0x81, 0xAB, 0xF1, 0xE0, 0xFA, 0xEB,
    0xB0, 0xC7, 0x2E, 0xFB, 0xEC, 0xB2, 0xD7, 0x86, 0x52, 0x0E, 0xB8, 0xE7, 0xAE, 0xFB, 0xEE, 0xBC, 0xF7, 0xCE, 0xBB, 0xED, 0x1B, 0xC9, 0x20, 0xFC, 0xF0, 0xC4, 0x17, 0x6F, 0xFC, 0xF1, 0xC6, 0x87, 0xF5, 0xC7, 0xF2, 0xCC, 0x37, 0xBF, 0x7C, 0x0D,
    0xD0, 0x47, 0x2F, 0xFD, 0xF4, 0xD4, 0x57, 0x4F, 0xBD, 0xF2, 0xCE, 0x67, 0x0F, 0xC3, 0xF6, 0xDC, 0x77, 0xEF, 0xFD, 0xF7, 0xE0, 0x7F, 0x8F, 0x7D, 0xF6, 0xCC, 0x6F, 0x71, 0xC3, 0xF9, 0xE8, 0xA7, 0xAF, 0xFE, 0xFA, 0xEC, 0xAF, 0x3F, 0x3E, 0xF9,
    0x7F, 0x6C, 0x61, 0xC3, 0xFC, 0xF4, 0xD7, 0x6F, 0xFF, 0xFD, 0xF8, 0xDF, 0xFF, 0x7E, 0xF6, 0x5B, 0x84, 0xD1, 0xC3, 0xFF, 0x00, 0x0C, 0xA0, 0x00, 0x07, 0x48, 0xC0, 0x01, 0xEE, 0xCF, 0x79, 0xFD, 0xDB, 0x81, 0x02, 0x17, 0xC8, 0xC0, 0x06, 0x3A,
    0xF0, 0x81, 0x0E, 0x3C, 0x60, 0xF3, 0xFA, 0x17, 0x84, 0x0A, 0x5A, 0xF0, 0x82, 0x18, 0x1C, 0x04, 0x06, 0x37, 0xC8, 0x41, 0x09, 0x96, 0x2F, 0x0C, 0x42, 0x08, 0xA1, 0x08, 0x47, 0x48, 0x42, 0x81, 0x90, 0xF0, 0x84, 0x27, 0xF4, 0xE0, 0xF2, 0xFA,
    0x37, 0x84, 0x16, 0xBA, 0xF0, 0x85, 0x30, 0x1C, 0x08, 0x0C, 0x67, 0x08, 0x43, 0x15, 0xC6, 0x2F, 0x0C, 0x44, 0xC8, 0xA1, 0x0E, 0x77, 0xC8, 0xC3, 0x86, 0xF0, 0xF0, 0x87, 0x3B, 0xB4, 0x61, 0xFC, 0x8E, 0x8E, 0x40, 0xC4, 0x22, 0x1A, 0xF1, 0x88,
    0x0E, 0x39, 0xA2, 0x12, 0x8B, 0x28, 0xC4, 0x2D, 0x20, 0xE1, 0x89, 0x50, 0x8C, 0xA2, 0x14, 0x1F, 0x22, 0xC5, 0x2A, 0x3E, 0x51, 0x88, 0x7F, 0x58, 0x82, 0x16, 0xB7, 0xC8, 0xC5, 0x2E, 0x6E, 0xA4, 0x8B, 0x60, 0x5C, 0x02, 0x16, 0xA1, 0x40, 0xC6,
    0x32, 0x9A, 0xF1, 0x8C, 0x28, 0x39, 0xA3, 0x1A, 0x81, 0xF7, 0x90, 0x28, 0xB8, 0xF1, 0x8D, 0x70, 0x8C, 0x63, 0x65, 0xE2, 0x18, 0x47, 0x36, 0x3A, 0x24, 0x09, 0x78, 0xCC, 0xA3, 0x1E, 0xF7, 0xF8, 0x90, 0x3D, 0xFA, 0x11, 0x8F, 0xAA, 0x59, 0xCD,
    0x40, 0x94, 0x40, 0xC8, 0x42, 0x1A, 0xF2, 0x90, 0x02, 0x51, 0x42, 0x43, 0x0E, 0xC9, 0x48, 0x25, 0x04, 0x52, 0x90, 0x83, 0x30, 0x82, 0x24, 0x27, 0x49, 0xC9, 0x4A, 0x46, 0xD2, 0x08, 0x0D, 0xA9, 0xA4, 0x26, 0x8D, 0x00, 0xB1, 0xD5, 0x14, 0xE1,
    0x93, 0xA0, 0x0C, 0xA5, 0x28, 0x43, 0xD9, 0x90, 0x51, 0x8A, 0x12, 0x92, 0x0D, 0x09, 0x08, 0x00, 0x21, 0xF9, 0x04, 0x05, 0x14, 0x00, 0x83, 0x00, 0x2C, 0x35, 0x00, 0x00, 0x00, 0x11, 0x00, 0x46, 0x00, 0x00, 0x08, 0xFF, 0x00, 0x2D, 0x08, 0x1C,
    0x48, 0xB0, 0xA0, 0x40, 0x0E, 0x08, 0x13, 0x2A, 0x5C, 0xC8, 0x21, 0x90, 0x87, 0x87, 0x10, 0x23, 0x4A, 0x0C, 0x14, 0xE8, 0x83, 0xC5, 0x8B, 0x18, 0x33, 0x06, 0x12, 0x04, 0xA2, 0xA3, 0xC7, 0x8F, 0x20, 0x37, 0xE2, 0x18, 0x49, 0xB2, 0x64, 0xC9,
    0x8D, 0x80, 0x5E, 0xA8, 0x5C, 0xC9, 0x92, 0x25, 0x4A, 0x20, 0x30, 0x63, 0xCA, 0x94, 0x89, 0xF2, 0x87, 0xCD, 0x9B, 0x38, 0x71, 0xA2, 0x2C, 0xC1, 0xB3, 0xA7, 0x4F, 0x9F, 0x28, 0x67, 0x08, 0x1D, 0x4A, 0x94, 0x28, 0xCA, 0x11, 0x48, 0x93, 0x2A,
    0x55, 0x8A, 0xB2, 0x85, 0xD3, 0xA7, 0x50, 0xA1, 0xA2, 0x0C, 0x41, 0xB5, 0xAA, 0x55, 0xAB, 0x28, 0x53, 0x68, 0xDD, 0xCA, 0x95, 0x2B, 0x4A, 0x12, 0x60, 0xC3, 0x8A, 0x15, 0x8B, 0xF2, 0x84, 0xD9, 0xB3, 0x68, 0xD1, 0xA2, 0xD4, 0xC1, 0xB6, 0xAD,
    0x5B, 0xB7, 0x28, 0x57, 0xC8, 0x9D, 0x4B, 0x97, 0x2E, 0x4A, 0x11, 0x78, 0xF3, 0xEA, 0xD5, 0x8B, 0x92, 0x86, 0xDF, 0xBF, 0x80, 0x01, 0xA3, 0x8C, 0x41, 0xB8, 0xB0, 0x61, 0xC3, 0x28, 0xB5, 0x28, 0x5E, 0xCC, 0x98, 0x31, 0x4A, 0x2A, 0x90, 0x23,
    0x4B, 0x96, 0x8C, 0xD2, 0x8A, 0xE5, 0xCB, 0x98, 0x31, 0xA3, 0x64, 0xC2, 0xB9, 0xB3, 0x67, 0xCF, 0x28, 0xB3, 0x88, 0x1E, 0x4D, 0x9A, 0x34, 0x4A, 0x2C, 0xA8, 0x53, 0xAB, 0x56, 0x8D, 0xB2, 0x8A, 0xEB, 0xD7, 0xB0, 0x61, 0xA3, 0x94, 0x42, 0xBB,
    0xB6, 0x6D, 0xDB, 0x28, 0xA7, 0xE8, 0xDE, 0xCD, 0x9B, 0x37, 0xCA, 0x2B, 0xC0, 0x83, 0x0B, 0x17, 0x8E, 0xD2, 0x85, 0xF1, 0xE3, 0xC8, 0x91, 0xA3, 0x64, 0xC1, 0xBC, 0xB9, 0x73, 0xE7, 0x28, 0x51, 0x48, 0x9F, 0x4E, 0x9D, 0x3A, 0x4A, 0x1F, 0xD8,
    0xB3, 0x6B, 0xD7, 0x8E, 0x52, 0x85, 0xF7, 0xEF, 0xE0, 0xC1, 0xA3, 0xFF, 0x34, 0x41, 0xBE, 0xBC, 0x79, 0xF3, 0x28, 0x9B, 0xA8, 0x5F, 0xCF, 0x9E, 0x3D, 0x4A, 0x27, 0xF0, 0xE3, 0xCB, 0x97, 0x8F, 0xF2, 0x89, 0xFD, 0xFB, 0xF8, 0xF1, 0xA3, 0x14,
    0x34, 0xA6, 0x3F, 0x7F, 0x41, 0xFC, 0xF5, 0x27, 0x20, 0x4A, 0x60, 0x08, 0x02, 0x46, 0x81, 0x06, 0x16, 0x78, 0xE0, 0x82, 0x28, 0x71, 0x21, 0x08, 0x17, 0x0E, 0x42, 0x18, 0xA1, 0x84, 0x5C, 0xA0, 0x24, 0x86, 0x20, 0x62, 0x5C, 0x98, 0xA1, 0x86,
    0x1B, 0x8A, 0x81, 0x52, 0x17, 0x82, 0x74, 0x01, 0xA2, 0x88, 0x23, 0x92, 0xD8, 0x05, 0x4A, 0x5E, 0x08, 0xE2, 0x45, 0x8A, 0x2B, 0xB2, 0xD8, 0xA2, 0x17, 0xFB, 0x7D, 0x21, 0xA3, 0x20, 0x32, 0x7E, 0x41, 0x63, 0x8D, 0x5F, 0xA0, 0xC4, 0xC3, 0x8E,
    0x3C, 0xF6, 0xD8, 0x23, 0x4A, 0x39, 0x04, 0x29, 0xE4, 0x90, 0x43, 0xA2, 0x24, 0xC3, 0x91, 0x48, 0x26, 0x99, 0x24, 0x4A, 0x35, 0x34, 0xE9, 0xE4, 0x93, 0x4F, 0xA2, 0x04, 0xC3, 0x94, 0x54, 0x56, 0x59, 0x25, 0x4A, 0x37, 0x64, 0xA9, 0xE5, 0x96,
    0x5B, 0xA2, 0x64, 0xC3, 0x97, 0x60, 0x86, 0x19, 0x26, 0x4A, 0x3D, 0x94, 0x69, 0xE6, 0x99, 0x67, 0xA2, 0xB4, 0xC3, 0x9A, 0x6C, 0xB6, 0xD9, 0x26, 0x4A, 0x41, 0xC4, 0x29, 0xE7, 0x9C, 0x73, 0xA2, 0x24, 0xC4, 0x9D, 0x78, 0xE6, 0x99, 0x27, 0x4A,
    0x43, 0xF4, 0xE9, 0xE7, 0x9F, 0x7F, 0xA2, 0x44, 0xC4, 0xA0, 0x84, 0x16, 0x5A, 0x28, 0x4A, 0x47, 0x24, 0xAA, 0xE8, 0xA2, 0x8B, 0xA2, 0x84, 0xC4, 0xA3, 0x90, 0x46, 0x1A, 0x29, 0x4A, 0x4B, 0x54, 0x6A, 0xE9, 0xA5, 0x97, 0xA2, 0x04, 0xC5, 0xA6,
    0x9C, 0x76, 0xDA, 0x29, 0x4A, 0x51, 0x84, 0x2A, 0xEA, 0xA8, 0xA3, 0xA2, 0x94, 0xC4, 0xA9, 0xA8, 0xA6, 0x9A, 0x2A, 0x4A, 0x4A, 0xB4, 0xEA, 0xEA, 0xAB, 0xAF, 0xA2, 0x14, 0x64, 0xC4, 0xAC, 0xB4, 0xD6, 0x5A, 0xEB, 0x46, 0x82, 0x14, 0xA1, 0xEB,
    0xAE, 0xBC, 0xF2, 0x4A, 0x51, 0x20, 0x01, 0x01, 0x00, 0x3B, 0x00
  };
#endif

/*********************************************************************
*
*       Grayscale specific
*/
#if SHOW_GRAYSCALE
  static const GUI_COLOR _ColorsJoerg_8bpp[] = {
    0x000000, 0x010101, 0x020202, 0x030303,
    0x040404, 0x050505, 0x060606, 0x070707,
    0x080808, 0x090909, 0x0A0A0A, 0x0B0B0B,
    0x0C0C0C, 0x0D0D0D, 0x0E0E0E, 0x0F0F0F,
    0x101010, 0x111111, 0x121212, 0x131313,
    0x141414, 0x151515, 0x161616, 0x171717,
    0x181818, 0x191919, 0x1A1A1A, 0x1B1B1B,
    0x1C1C1C, 0x1D1D1D, 0x1E1E1E, 0x1F1F1F,
    0x202020, 0x212121, 0x222222, 0x232323,
    0x242424, 0x252525, 0x262626, 0x272727,
    0x282828, 0x292929, 0x2A2A2A, 0x2B2B2B,
    0x2C2C2C, 0x2D2D2D, 0x2E2E2E, 0x2F2F2F,
    0x303030, 0x313131, 0x323232, 0x333333,
    0x343434, 0x353535, 0x363636, 0x373737,
    0x383838, 0x393939, 0x3A3A3A, 0x3B3B3B,
    0x3C3C3C, 0x3D3D3D, 0x3E3E3E, 0x3F3F3F,
    0x404040, 0x414141, 0x424242, 0x434343,
    0x444444, 0x454545, 0x464646, 0x474747,
    0x484848, 0x494949, 0x4A4A4A, 0x4B4B4B,
    0x4C4C4C, 0x4D4D4D, 0x4E4E4E, 0x4F4F4F,
    0x505050, 0x515151, 0x525252, 0x535353,
    0x545454, 0x555555, 0x565656, 0x575757,
    0x585858, 0x595959, 0x5A5A5A, 0x5B5B5B,
    0x5C5C5C, 0x5D5D5D, 0x5E5E5E, 0x5F5F5F,
    0x606060, 0x616161, 0x626262, 0x636363,
    0x646464, 0x656565, 0x666666, 0x676767,
    0x686868, 0x696969, 0x6A6A6A, 0x6B6B6B,
    0x6C6C6C, 0x6D6D6D, 0x6E6E6E, 0x6F6F6F,
    0x707070, 0x717171, 0x727272, 0x737373,
    0x747474, 0x757575, 0x767676, 0x777777,
    0x787878, 0x797979, 0x7A7A7A, 0x7B7B7B,
    0x7C7C7C, 0x7D7D7D, 0x7E7E7E, 0x7F7F7F,
    0x808080, 0x818181, 0x828282, 0x838383,
    0x848484, 0x858585, 0x868686, 0x878787,
    0x888888, 0x898989, 0x8A8A8A, 0x8B8B8B,
    0x8C8C8C, 0x8D8D8D, 0x8E8E8E, 0x8F8F8F,
    0x909090, 0x919191, 0x929292, 0x939393,
    0x949494, 0x959595, 0x969696, 0x979797,
    0x989898, 0x999999, 0x9A9A9A, 0x9B9B9B,
    0x9C9C9C, 0x9D9D9D, 0x9E9E9E, 0x9F9F9F,
    0xA0A0A0, 0xA1A1A1, 0xA2A2A2, 0xA3A3A3,
    0xA4A4A4, 0xA5A5A5, 0xA6A6A6, 0xA7A7A7,
    0xA8A8A8, 0xA9A9A9, 0xAAAAAA, 0xABABAB,
    0xACACAC, 0xADADAD, 0xAEAEAE, 0xAFAFAF,
    0xB0B0B0, 0xB1B1B1, 0xB2B2B2, 0xB3B3B3,
    0xB4B4B4, 0xB5B5B5, 0xB6B6B6, 0xB7B7B7,
    0xB8B8B8, 0xB9B9B9, 0xBABABA, 0xBBBBBB,
    0xBCBCBC, 0xBDBDBD, 0xBEBEBE, 0xBFBFBF,
    0xC0C0C0, 0xC1C1C1, 0xC2C2C2, 0xC3C3C3,
    0xC4C4C4, 0xC5C5C5, 0xC6C6C6, 0xC7C7C7,
    0xC8C8C8, 0xC9C9C9, 0xCACACA, 0xCBCBCB,
    0xCCCCCC, 0xCDCDCD, 0xCECECE, 0xCFCFCF,
    0xD0D0D0, 0xD1D1D1, 0xD2D2D2, 0xD3D3D3,
    0xD4D4D4, 0xD5D5D5, 0xD6D6D6, 0xD7D7D7,
    0xD8D8D8, 0xD9D9D9, 0xDADADA, 0xDBDBDB,
    0xDCDCDC, 0xDDDDDD, 0xDEDEDE, 0xDFDFDF,
    0xE0E0E0, 0xE1E1E1, 0xE2E2E2, 0xE3E3E3,
    0xE4E4E4, 0xE5E5E5, 0xE6E6E6, 0xE7E7E7,
    0xE8E8E8, 0xE9E9E9, 0xEAEAEA, 0xEBEBEB,
    0xECECEC, 0xEDEDED, 0xEEEEEE, 0xEFEFEF,
    0xF0F0F0, 0xF1F1F1, 0xF2F2F2, 0xF3F3F3,
    0xF4F4F4, 0xF5F5F5, 0xF6F6F6, 0xF7F7F7,
    0xF8F8F8, 0xF9F9F9, 0xFAFAFA, 0xFBFBFB,
    0xFCFCFC, 0xFDFDFD, 0xFEFEFE, 0xFFFFFF
  };

  static const GUI_LOGPALETTE _PalJoerg_8bpp = {
    256,  // Number of entries
    0,    // No transparency
    &_ColorsJoerg_8bpp[0]
  };

  static const unsigned char _acJoerg_8bpp[] = {
    0x8E, 0x8E, 0x8D, 0x8F, 0x8F, 0x8F, 0x90, 0x90, 0x8F, 0x90, 0x91, 0x91, 0x90, 0x91, 0x91, 0x8F, 0x90, 0x91, 0x8F, 0x8F, 0x8E, 0x8F, 0x8D, 0x8A, 0x8F, 0x8D, 0x8D, 0x92, 0x91, 0x90, 0x8F, 0x90, 0x90, 0x8F, 0x8F, 0x90, 0x8F, 0x8D, 0x8E, 0x8E, 0x8D, 0x8E,
          0x8E, 0x8E, 0x8C,
    0x8D, 0x8E, 0x8D, 0x8F, 0x8E, 0x90, 0x8E, 0x8F, 0x8F, 0x90, 0x90, 0x90, 0x91, 0x91, 0x8E, 0x8D, 0x8F, 0x8B, 0x87, 0x87, 0x76, 0x82, 0x70, 0x74, 0x72, 0x73, 0x79, 0x8B, 0x8D, 0x8E, 0x90, 0x91, 0x91, 0x90, 0x90, 0x90, 0x8E, 0x8E, 0x8E, 0x8E, 0x8D, 0x8D,
          0x8D, 0x8C, 0x8C,
    0x8E, 0x8D, 0x8E, 0x8F, 0x8F, 0x8F, 0x90, 0x8F, 0x8F, 0x8F, 0x8F, 0x8E, 0x8B, 0x8B, 0x71, 0x55, 0x62, 0x62, 0x4D, 0x54, 0x3E, 0x57, 0x3F, 0x43, 0x42, 0x42, 0x4A, 0x63, 0x74, 0x7B, 0x89, 0x8E, 0x8F, 0x8E, 0x8F, 0x8E, 0x8F, 0x8E, 0x8E, 0x8D, 0x8C, 0x8D,
          0x8D, 0x8D, 0x8C,
    0x8E, 0x8E, 0x8F, 0x8F, 0x8C, 0x8E, 0x8F, 0x8F, 0x8F, 0x8D, 0x8C, 0x7A, 0x6A, 0x67, 0x4C, 0x37, 0x37, 0x37, 0x31, 0x2E, 0x2D, 0x32, 0x33, 0x32, 0x35, 0x34, 0x38, 0x41, 0x48, 0x55, 0x74, 0x77, 0x7D, 0x8B, 0x8D, 0x8E, 0x8E, 0x8E, 0x8D, 0x8D, 0x8D, 0x8D,
          0x8D, 0x8E, 0x8C,
    0x8D, 0x8E, 0x90, 0x8D, 0x8D, 0x8E, 0x8D, 0x8B, 0x89, 0x7C, 0x6A, 0x70, 0x4C, 0x3B, 0x37, 0x31, 0x2E, 0x2C, 0x29, 0x2A, 0x2A, 0x24, 0x27, 0x29, 0x2C, 0x2C, 0x2D, 0x30, 0x34, 0x3E, 0x46, 0x3C, 0x4D, 0x6A, 0x83, 0x88, 0x8B, 0x8D, 0x8D, 0x8C, 0x8B, 0x8C,
          0x8A, 0x8C, 0x8A,
    0x8D, 0x8E, 0x8E, 0x8D, 0x8C, 0x8C, 0x8B, 0x86, 0x64, 0x51, 0x40, 0x40, 0x40, 0x39, 0x2F, 0x2D, 0x2A, 0x26, 0x23, 0x24, 0x25, 0x1F, 0x1F, 0x24, 0x25, 0x24, 0x25, 0x28, 0x2D, 0x2B, 0x2D, 0x2A, 0x33, 0x36, 0x4D, 0x6B, 0x7C, 0x88, 0x8A, 0x8B, 0x89, 0x8A,
          0x89, 0x8A, 0x89,
    0x8F, 0x8E, 0x8D, 0x8C, 0x8C, 0x8D, 0x87, 0x6F, 0x51, 0x3B, 0x33, 0x31, 0x31, 0x34, 0x2D, 0x24, 0x26, 0x24, 0x21, 0x1E, 0x21, 0x1B, 0x1F, 0x21, 0x23, 0x1D, 0x25, 0x25, 0x28, 0x26, 0x28, 0x26, 0x28, 0x2F, 0x3A, 0x48, 0x61, 0x6D, 0x84, 0x89, 0x87, 0x87,
          0x87, 0x88, 0x87,
    0x94, 0x93, 0x90, 0x92, 0x91, 0x8C, 0x6F, 0x51, 0x3C, 0x33, 0x35, 0x2D, 0x29, 0x2C, 0x2A, 0x22, 0x25, 0x25, 0x1F, 0x1B, 0x1C, 0x1B, 0x1D, 0x20, 0x1E, 0x1C, 0x23, 0x1F, 0x24, 0x25, 0x24, 0x23, 0x29, 0x2D, 0x2F, 0x37, 0x3F, 0x6C, 0x7E, 0x89, 0x87, 0x88,
          0x86, 0x87, 0x87,
    0x9C, 0x9E, 0xA0, 0x9E, 0x9C, 0x84, 0x4F, 0x39, 0x2E, 0x28, 0x2C, 0x2A, 0x25, 0x24, 0x27, 0x27, 0x22, 0x24, 0x1F, 0x1C, 0x21, 0x1A, 0x1B, 0x1F, 0x1B, 0x22, 0x1F, 0x1E, 0x21, 0x21, 0x24, 0x2B, 0x2A, 0x26, 0x26, 0x2A, 0x46, 0x47, 0x68, 0x88, 0x8C, 0x8E,
          0x8D, 0x8C, 0x8B,
    0x99, 0x97, 0x97, 0x96, 0x89, 0x58, 0x3D, 0x2E, 0x23, 0x1E, 0x1F, 0x25, 0x20, 0x21, 0x2A, 0x28, 0x1E, 0x20, 0x1F, 0x1D, 0x20, 0x1A, 0x1B, 0x1D, 0x1E, 0x20, 0x20, 0x21, 0x21, 0x22, 0x26, 0x28, 0x22, 0x20, 0x21, 0x25, 0x2E, 0x37, 0x5F, 0x84, 0x90, 0x92,
          0x92, 0x92, 0x91,
    0xAA, 0xA9, 0xA9, 0xA7, 0x95, 0x6B, 0x45, 0x28, 0x1E, 0x1A, 0x18, 0x22, 0x21, 0x21, 0x27, 0x22, 0x22, 0x1D, 0x1F, 0x1C, 0x1F, 0x1C, 0x1F, 0x1F, 0x1F, 0x21, 0x20, 0x23, 0x22, 0x20, 0x21, 0x20, 0x1F, 0x1E, 0x22, 0x21, 0x20, 0x2B, 0x4C, 0x7A, 0x90, 0x96,
          0x96, 0x95, 0x95,
    0xAE, 0xAE, 0xAB, 0xA0, 0x72, 0x39, 0x28, 0x1F, 0x1B, 0x1A, 0x1A, 0x21, 0x25, 0x24, 0x25, 0x24, 0x20, 0x21, 0x20, 0x20, 0x24, 0x24, 0x23, 0x23, 0x22, 0x1F, 0x20, 0x22, 0x21, 0x1D, 0x1C, 0x1F, 0x1E, 0x1E, 0x22, 0x21, 0x1D, 0x23, 0x37, 0x5B, 0x7B, 0x94,
          0x97, 0x97, 0x96,
    0xB5, 0xB5, 0xAE, 0x7E, 0x32, 0x29, 0x22, 0x1D, 0x18, 0x1A, 0x20, 0x29, 0x2D, 0x2B, 0x2A, 0x27, 0x27, 0x29, 0x29, 0x2B, 0x2F, 0x2E, 0x2D, 0x2A, 0x25, 0x23, 0x25, 0x25, 0x24, 0x1E, 0x21, 0x22, 0x23, 0x21, 0x21, 0x1F, 0x1C, 0x1D, 0x2B, 0x3F, 0x5B, 0x8A,
          0x97, 0x97, 0x96,
    0xBB, 0xBA, 0xB0, 0x61, 0x2F, 0x22, 0x1B, 0x18, 0x1A, 0x21, 0x2F, 0x35, 0x33, 0x35, 0x38, 0x35, 0x39, 0x36, 0x3A, 0x3A, 0x3A, 0x38, 0x37, 0x34, 0x33, 0x2E, 0x2F, 0x36, 0x35, 0x2C, 0x29, 0x2B, 0x2D, 0x27, 0x26, 0x20, 0x19, 0x19, 0x22, 0x26, 0x31, 0x67,
          0x95, 0x98, 0x97,
    0xBF, 0xBF, 0xA3, 0x3B, 0x24, 0x1F, 0x1A, 0x19, 0x21, 0x35, 0x40, 0x41, 0x43, 0x4A, 0x51, 0x4F, 0x50, 0x4A, 0x4C, 0x50, 0x4D, 0x47, 0x44, 0x47, 0x48, 0x45, 0x46, 0x4C, 0x42, 0x32, 0x32, 0x33, 0x31, 0x31, 0x35, 0x25, 0x17, 0x17, 0x1F, 0x23, 0x2E, 0x4D,
          0x8C, 0x97, 0x97,
    0xC0, 0xBC, 0x79, 0x31, 0x26, 0x20, 0x1D, 0x20, 0x38, 0x46, 0x4B, 0x4F, 0x55, 0x57, 0x5D, 0x61, 0x64, 0x64, 0x62, 0x69, 0x69, 0x60, 0x59, 0x59, 0x5E, 0x59, 0x58, 0x50, 0x47, 0x43, 0x42, 0x43, 0x45, 0x45, 0x48, 0x3D, 0x22, 0x19, 0x1D, 0x23, 0x2B, 0x39,
          0x68, 0x96, 0x98,
    0xBF, 0xA8, 0x36, 0x2E, 0x25, 0x23, 0x1F, 0x30, 0x45, 0x4E, 0x54, 0x5A, 0x5D, 0x64, 0x65, 0x64, 0x68, 0x6A, 0x6C, 0x70, 0x74, 0x73, 0x6D, 0x6C, 0x71, 0x71, 0x6D, 0x67, 0x64, 0x67, 0x65, 0x5F, 0x5E, 0x5A, 0x56, 0x4C, 0x37, 0x1D, 0x1A, 0x20, 0x24, 0x31,
          0x50, 0x95, 0x98,
    0xC0, 0x94, 0x37, 0x2A, 0x22, 0x21, 0x25, 0x3F, 0x4D, 0x54, 0x59, 0x5D, 0x62, 0x68, 0x68, 0x6B, 0x70, 0x6F, 0x73, 0x75, 0x75, 0x78, 0x75, 0x73, 0x74, 0x78, 0x77, 0x74, 0x74, 0x74, 0x70, 0x6E, 0x6E, 0x67, 0x60, 0x53, 0x4C, 0x29, 0x1A, 0x1C, 0x1F, 0x2A,
          0x3B, 0x69, 0x99,
    0xBE, 0x6B, 0x32, 0x25, 0x24, 0x24, 0x31, 0x46, 0x54, 0x56, 0x5D, 0x61, 0x65, 0x67, 0x6C, 0x6F, 0x74, 0x73, 0x73, 0x74, 0x76, 0x77, 0x79, 0x75, 0x74, 0x77, 0x79, 0x76, 0x74, 0x73, 0x74, 0x75, 0x72, 0x6C, 0x66, 0x58, 0x51, 0x3C, 0x1C, 0x1B, 0x1D, 0x29,
          0x44, 0x89, 0x9A,
    0xBD, 0x6D, 0x32, 0x2C, 0x2A, 0x2B, 0x36, 0x4E, 0x53, 0x57, 0x5E, 0x61, 0x66, 0x6B, 0x70, 0x74, 0x76, 0x77, 0x76, 0x78, 0x7A, 0x7B, 0x7D, 0x78, 0x78, 0x79, 0x7A, 0x7B, 0x77, 0x75, 0x74, 0x78, 0x73, 0x72, 0x6C, 0x5F, 0x56, 0x47, 0x28, 0x1E, 0x1E, 0x2B,
          0x35, 0x66, 0x98,
    0xBC, 0x5C, 0x36, 0x30, 0x2F, 0x31, 0x3D, 0x50, 0x53, 0x59, 0x5F, 0x60, 0x67, 0x6E, 0x71, 0x75, 0x78, 0x78, 0x78, 0x7F, 0x81, 0x80, 0x80, 0x80, 0x7E, 0x81, 0x81, 0x80, 0x7E, 0x7A, 0x77, 0x78, 0x75, 0x71, 0x6E, 0x63, 0x5C, 0x52, 0x32, 0x25, 0x24, 0x2A,
          0x31, 0x56, 0x95,
    0xB4, 0x46, 0x32, 0x2E, 0x35, 0x38, 0x44, 0x4F, 0x55, 0x58, 0x5D, 0x60, 0x68, 0x70, 0x74, 0x77, 0x7A, 0x7A, 0x7F, 0x88, 0x8B, 0x88, 0x88, 0x8B, 0x8C, 0x8D, 0x8B, 0x88, 0x87, 0x81, 0x7B, 0x77, 0x74, 0x6D, 0x6D, 0x65, 0x60, 0x59, 0x3B, 0x28, 0x2B, 0x2A,
          0x35, 0x51, 0x93,
    0xB2, 0x45, 0x2E, 0x2F, 0x32, 0x3C, 0x46, 0x51, 0x55, 0x58, 0x5B, 0x5F, 0x68, 0x6C, 0x72, 0x77, 0x80, 0x85, 0x89, 0x8B, 0x8B, 0x8E, 0x8C, 0x8C, 0x93, 0x95, 0x94, 0x8F, 0x8B, 0x88, 0x7F, 0x79, 0x74, 0x6C, 0x6D, 0x68, 0x61, 0x5B, 0x43, 0x2E, 0x2D, 0x31,
          0x33, 0x54, 0x9A,
    0xB4, 0x3B, 0x2B, 0x2E, 0x31, 0x3D, 0x49, 0x4E, 0x54, 0x56, 0x5A, 0x60, 0x63, 0x6C, 0x75, 0x7A, 0x83, 0x88, 0x89, 0x8A, 0x8C, 0x93, 0x8D, 0x8F, 0x91, 0x8F, 0x8F, 0x8C, 0x88, 0x86, 0x82, 0x79, 0x74, 0x6E, 0x6D, 0x66, 0x5F, 0x5A, 0x48, 0x35, 0x32, 0x31,
          0x3D, 0x66, 0x9A,
    0xB5, 0x35, 0x2B, 0x30, 0x2D, 0x3E, 0x47, 0x50, 0x53, 0x56, 0x5A, 0x5F, 0x64, 0x6C, 0x72, 0x7A, 0x7F, 0x81, 0x87, 0x88, 0x8B, 0x8D, 0x8F, 0x93, 0x91, 0x8E, 0x8B, 0x8A, 0x85, 0x82, 0x80, 0x7C, 0x74, 0x6D, 0x69, 0x67, 0x5E, 0x59, 0x4D, 0x3C, 0x33, 0x2F,
          0x37, 0x95, 0x9C,
    0xAD, 0x32, 0x29, 0x2D, 0x2E, 0x3C, 0x44, 0x50, 0x58, 0x5A, 0x5B, 0x61, 0x66, 0x6A, 0x70, 0x77, 0x7B, 0x7E, 0x83, 0x87, 0x8A, 0x8C, 0x8E, 0x91, 0x91, 0x8E, 0x8B, 0x8B, 0x85, 0x80, 0x80, 0x7B, 0x77, 0x6D, 0x68, 0x6B, 0x63, 0x5B, 0x4D, 0x3C, 0x34, 0x32,
          0x56, 0x9E, 0x9D,
    0xAD, 0x3B, 0x28, 0x2A, 0x30, 0x3A, 0x47, 0x53, 0x58, 0x5C, 0x5F, 0x64, 0x69, 0x6D, 0x74, 0x79, 0x7C, 0x7C, 0x84, 0x85, 0x8C, 0x8B, 0x8F, 0x91, 0x8E, 0x8C, 0x8D, 0x89, 0x82, 0x82, 0x7F, 0x7D, 0x76, 0x74, 0x6A, 0x69, 0x65, 0x5A, 0x49, 0x37, 0x32, 0x2F,
          0x70, 0x9D, 0x9D,
    0xB3, 0x41, 0x2A, 0x2C, 0x31, 0x3C, 0x4A, 0x54, 0x5C, 0x60, 0x61, 0x66, 0x69, 0x70, 0x74, 0x79, 0x7B, 0x7E, 0x83, 0x88, 0x8C, 0x8D, 0x90, 0x8F, 0x8D, 0x8E, 0x8F, 0x8B, 0x87, 0x84, 0x7F, 0x7C, 0x79, 0x74, 0x6D, 0x69, 0x66, 0x5A, 0x49, 0x34, 0x2B, 0x2C,
          0x7E, 0x9D, 0x9F,
    0xAE, 0x50, 0x2B, 0x2C, 0x32, 0x3D, 0x4F, 0x5A, 0x5F, 0x63, 0x65, 0x65, 0x69, 0x70, 0x74, 0x79, 0x7D, 0x7F, 0x84, 0x89, 0x8C, 0x8C, 0x8C, 0x8B, 0x8C, 0x8F, 0x8F, 0x8B, 0x88, 0x82, 0x7F, 0x7A, 0x77, 0x73, 0x73, 0x6F, 0x68, 0x5D, 0x4D, 0x34, 0x29, 0x2A,
          0x7F, 0x9E, 0x9F,
    0xB2, 0x69, 0x2E, 0x2D, 0x32, 0x42, 0x56, 0x5B, 0x61, 0x63, 0x66, 0x68, 0x6C, 0x71, 0x74, 0x78, 0x7E, 0x81, 0x84, 0x8A, 0x8C, 0x8C, 0x88, 0x87, 0x89, 0x8F, 0x8F, 0x8D, 0x8C, 0x87, 0x83, 0x7E, 0x7B, 0x73, 0x74, 0x71, 0x6A, 0x62, 0x52, 0x34, 0x28, 0x26,
          0x8F, 0x9F, 0xA0,
    0xAD, 0x7A, 0x32, 0x30, 0x33, 0x48, 0x5A, 0x5E, 0x61, 0x60, 0x61, 0x5F, 0x65, 0x6B, 0x6D, 0x76, 0x79, 0x80, 0x83, 0x86, 0x89, 0x8B, 0x8C, 0x87, 0x8A, 0x8D, 0x8A, 0x8C, 0x8A, 0x86, 0x83, 0x80, 0x7D, 0x77, 0x77, 0x72, 0x6B, 0x62, 0x57, 0x36, 0x2A, 0x25,
          0x99, 0xA1, 0xA0,
    0xAA, 0x95, 0x31, 0x2F, 0x36, 0x53, 0x5F, 0x5F, 0x5C, 0x59, 0x5B, 0x5D, 0x59, 0x57, 0x57, 0x5A, 0x60, 0x67, 0x71, 0x7B, 0x86, 0x86, 0x85, 0x84, 0x88, 0x89, 0x89, 0x8B, 0x83, 0x7B, 0x75, 0x70, 0x6E, 0x65, 0x71, 0x75, 0x6C, 0x63, 0x5C, 0x3A, 0x2C, 0x35,
          0xA3, 0xA2, 0xA2,
    0xAB, 0x94, 0x3F, 0x32, 0x36, 0x57, 0x61, 0x5F, 0x58, 0x4F, 0x4B, 0x46, 0x4E, 0x4A, 0x40, 0x39, 0x3B, 0x47, 0x58, 0x65, 0x78, 0x7F, 0x77, 0x7A, 0x7B, 0x7F, 0x70, 0x5B, 0x54, 0x4A, 0x4D, 0x4D, 0x56, 0x55, 0x5C, 0x65, 0x68, 0x63, 0x60, 0x40, 0x31, 0x43,
          0xA5, 0xA3, 0xA2,
    0xA3, 0x51, 0x39, 0x35, 0x39, 0x5E, 0x62, 0x5E, 0x4F, 0x4C, 0x51, 0x5D, 0x64, 0x66, 0x64, 0x5A, 0x50, 0x4B, 0x54, 0x65, 0x6F, 0x7F, 0x70, 0x7E, 0x7B, 0x79, 0x65, 0x52, 0x48, 0x49, 0x4F, 0x58, 0x5A, 0x58, 0x56, 0x5A, 0x5D, 0x62, 0x60, 0x41, 0x35, 0x67,
          0xA7, 0xA3, 0xA3,
    0x98, 0x46, 0x49, 0x39, 0x3B, 0x62, 0x63, 0x5F, 0x57, 0x54, 0x5B, 0x5E, 0x5A, 0x60, 0x4E, 0x4F, 0x4E, 0x53, 0x4D, 0x58, 0x6B, 0x81, 0x83, 0x87, 0x85, 0x78, 0x69, 0x63, 0x66, 0x70, 0x7C, 0x7E, 0x78, 0x74, 0x61, 0x5B, 0x5B, 0x60, 0x63, 0x41, 0x38, 0x49,
          0x6E, 0xA4, 0xA4,
    0x95, 0x49, 0x56, 0x41, 0x40, 0x63, 0x65, 0x64, 0x5B, 0x58, 0x4B, 0x37, 0x37, 0x21, 0x4C, 0x2D, 0x56, 0x49, 0x49, 0x47, 0x5D, 0x7E, 0x86, 0x8A, 0x83, 0x72, 0x64, 0x57, 0x4A, 0x31, 0x35, 0x37, 0x53, 0x6D, 0x68, 0x64, 0x6B, 0x69, 0x68, 0x41, 0x3E, 0x68,
          0x62, 0xA0, 0xA4,
    0x9A, 0x4C, 0x59, 0x47, 0x45, 0x63, 0x68, 0x68, 0x60, 0x53, 0x3E, 0x49, 0x68, 0x2E, 0x2C, 0x5B, 0x80, 0x5F, 0x5D, 0x4E, 0x55, 0x78, 0x84, 0x85, 0x79, 0x63, 0x65, 0x57, 0x66, 0x2C, 0x3F, 0x34, 0x6E, 0x37, 0x59, 0x68, 0x72, 0x73, 0x6B, 0x42, 0x5C, 0x6E,
          0x6A, 0xA1, 0xA5,
    0xA6, 0x53, 0x5F, 0x50, 0x4A, 0x64, 0x68, 0x6A, 0x5D, 0x56, 0x5E, 0x64, 0x64, 0x67, 0x6C, 0x76, 0x67, 0x61, 0x66, 0x55, 0x58, 0x75, 0x81, 0x84, 0x79, 0x72, 0x70, 0x68, 0x77, 0x58, 0x44, 0x6A, 0x73, 0x5B, 0x52, 0x67, 0x78, 0x74, 0x6C, 0x46, 0x71, 0x76,
          0x6C, 0xA3, 0xA5,
    0xAE, 0x62, 0x60, 0x49, 0x4C, 0x66, 0x68, 0x68, 0x62, 0x63, 0x5E, 0x65, 0x68, 0x70, 0x73, 0x76, 0x6F, 0x66, 0x5C, 0x53, 0x5E, 0x72, 0x7C, 0x7F, 0x7A, 0x6C, 0x74, 0x6D, 0x6D, 0x7A, 0x7B, 0x78, 0x78, 0x72, 0x6D, 0x68, 0x76, 0x73, 0x67, 0x52, 0x82, 0x78,
          0x6F, 0xA7, 0xA5,
    0xAE, 0x75, 0x64, 0x42, 0x4B, 0x68, 0x68, 0x69, 0x67, 0x6A, 0x65, 0x66, 0x69, 0x68, 0x6C, 0x6F, 0x73, 0x62, 0x5D, 0x5A, 0x63, 0x70, 0x7D, 0x81, 0x7B, 0x6D, 0x6C, 0x76, 0x76, 0x79, 0x7C, 0x81, 0x7D, 0x76, 0x74, 0x77, 0x74, 0x72, 0x68, 0x5D, 0x81, 0x7C,
          0x8B, 0xA6, 0xA6,
    0xAE, 0x80, 0x60, 0x40, 0x58, 0x6B, 0x67, 0x6B, 0x6B, 0x6E, 0x6D, 0x6F, 0x6F, 0x6F, 0x71, 0x6E, 0x6D, 0x6B, 0x61, 0x5D, 0x64, 0x6C, 0x7B, 0x85, 0x80, 0x6E, 0x6D, 0x77, 0x81, 0x81, 0x7E, 0x7C, 0x7C, 0x7D, 0x7B, 0x7B, 0x79, 0x71, 0x69, 0x69, 0x7C, 0x83,
          0xA0, 0xA5, 0xA5,
    0xAE, 0x8A, 0x62, 0x44, 0x58, 0x6C, 0x6B, 0x6A, 0x6B, 0x6F, 0x70, 0x72, 0x73, 0x71, 0x71, 0x75, 0x73, 0x6E, 0x63, 0x61, 0x61, 0x6E, 0x7D, 0x86, 0x7C, 0x6B, 0x70, 0x77, 0x78, 0x7D, 0x82, 0x82, 0x83, 0x7F, 0x7F, 0x7C, 0x78, 0x71, 0x6B, 0x76, 0x7D, 0x80,
          0xA9, 0xA6, 0xA7,
    0xAC, 0x96, 0x59, 0x5C, 0x43, 0x6D, 0x6B, 0x68, 0x6B, 0x6E, 0x72, 0x71, 0x73, 0x7A, 0x7D, 0x7A, 0x78, 0x71, 0x68, 0x5F, 0x63, 0x6D, 0x7B, 0x82, 0x7B, 0x6C, 0x75, 0x7A, 0x7F, 0x7D, 0x7B, 0x7D, 0x7D, 0x7E, 0x82, 0x7F, 0x79, 0x70, 0x75, 0x6E, 0x7C, 0x81,
          0xA9, 0xA6, 0xA8,
    0xAC, 0xA6, 0x5C, 0x6B, 0x59, 0x6A, 0x69, 0x67, 0x6A, 0x6A, 0x6E, 0x74, 0x79, 0x7F, 0x7F, 0x7D, 0x7E, 0x77, 0x66, 0x58, 0x63, 0x6D, 0x7A, 0x80, 0x78, 0x6F, 0x75, 0x81, 0x84, 0x85, 0x84, 0x7E, 0x7B, 0x7F, 0x81, 0x7D, 0x7A, 0x70, 0x6D, 0x66, 0x79, 0x8B,
          0xA8, 0xA6, 0xA7,
    0xAA, 0xAA, 0x70, 0x6A, 0x5B, 0x68, 0x68, 0x67, 0x69, 0x6D, 0x71, 0x78, 0x7B, 0x7F, 0x81, 0x83, 0x81, 0x6D, 0x58, 0x5A, 0x61, 0x6D, 0x7A, 0x82, 0x7B, 0x6D, 0x6C, 0x83, 0x8B, 0x8A, 0x8A, 0x87, 0x86, 0x81, 0x83, 0x7B, 0x7F, 0x72, 0x74, 0x89, 0x76, 0xA1,
          0xA8, 0xA6, 0xA6,
    0xA8, 0xA8, 0x88, 0x63, 0x59, 0x66, 0x6A, 0x69, 0x6A, 0x6E, 0x75, 0x7A, 0x7D, 0x83, 0x85, 0x7F, 0x70, 0x55, 0x64, 0x67, 0x65, 0x6D, 0x80, 0x94, 0x80, 0x6E, 0x6A, 0x7B, 0x8B, 0x91, 0x8E, 0x8C, 0x88, 0x88, 0x85, 0x7E, 0x7E, 0x71, 0x81, 0x90, 0x7B, 0xAB,
          0xA8, 0xA8, 0xA8,
    0xA6, 0xA7, 0x9C, 0x60, 0x5D, 0x68, 0x6A, 0x6B, 0x69, 0x71, 0x78, 0x7C, 0x7F, 0x83, 0x82, 0x73, 0x6A, 0x52, 0x68, 0x6F, 0x6D, 0x77, 0x8B, 0x9D, 0x87, 0x76, 0x76, 0x74, 0x7C, 0x8D, 0x93, 0x90, 0x8C, 0x89, 0x87, 0x83, 0x7C, 0x6F, 0x79, 0x81, 0x8B, 0xAB,
          0xA9, 0xA9, 0xA8,
    0xA5, 0xA5, 0xA8, 0x8F, 0x6A, 0x71, 0x68, 0x6A, 0x6A, 0x72, 0x79, 0x78, 0x7D, 0x7E, 0x78, 0x73, 0x6F, 0x57, 0x4B, 0x48, 0x5E, 0x78, 0x83, 0x87, 0x86, 0x70, 0x75, 0x78, 0x7B, 0x7F, 0x8F, 0x91, 0x8D, 0x8A, 0x87, 0x82, 0x78, 0x6D, 0x78, 0x80, 0x9C, 0xAA,
          0xAA, 0xAA, 0xAA,
    0xA5, 0xA5, 0xA5, 0xA5, 0xA6, 0x89, 0x6A, 0x6B, 0x6B, 0x70, 0x76, 0x79, 0x7C, 0x77, 0x77, 0x72, 0x6F, 0x64, 0x59, 0x49, 0x44, 0x5F, 0x74, 0x7C, 0x70, 0x55, 0x64, 0x7A, 0x80, 0x7F, 0x88, 0x8C, 0x8C, 0x86, 0x85, 0x80, 0x75, 0x6C, 0x74, 0x83, 0xAB, 0xAB,
          0xAA, 0xAA, 0xAA,
    0xA3, 0xA4, 0xA4, 0xA4, 0xA2, 0x8F, 0x6A, 0x6C, 0x6B, 0x6E, 0x75, 0x7B, 0x78, 0x73, 0x75, 0x6F, 0x69, 0x68, 0x66, 0x5E, 0x55, 0x49, 0x4E, 0x5A, 0x64, 0x67, 0x71, 0x7A, 0x80, 0x80, 0x81, 0x87, 0x89, 0x84, 0x83, 0x7F, 0x75, 0x68, 0x91, 0xAC, 0xAB, 0xAB,
          0xAA, 0xAA, 0xAA,
    0xA2, 0xA2, 0xA3, 0xA3, 0xA3, 0x99, 0x6B, 0x6E, 0x6A, 0x70, 0x75, 0x7C, 0x76, 0x75, 0x72, 0x6A, 0x6A, 0x67, 0x6D, 0x6A, 0x70, 0x74, 0x70, 0x74, 0x76, 0x74, 0x77, 0x78, 0x7A, 0x7E, 0x7F, 0x7D, 0x86, 0x85, 0x83, 0x82, 0x76, 0x65, 0x9E, 0xAB, 0xAC, 0xAC,
          0xAA, 0xAB, 0xAB,
    0xA3, 0xA2, 0xA3, 0xA3, 0xA3, 0xA3, 0x69, 0x6E, 0x69, 0x6F, 0x75, 0x7E, 0x7C, 0x79, 0x67, 0x4F, 0x52, 0x51, 0x52, 0x5B, 0x66, 0x79, 0x79, 0x7C, 0x7D, 0x7F, 0x78, 0x77, 0x79, 0x80, 0x82, 0x7C, 0x83, 0x87, 0x84, 0x7F, 0x75, 0x68, 0xA8, 0xAB, 0xAB, 0xAB,
          0xAB, 0xAB, 0xAA,
    0xA2, 0xA2, 0xA3, 0xA5, 0xA4, 0xA6, 0x76, 0x6D, 0x69, 0x6F, 0x74, 0x81, 0x83, 0x7E, 0x70, 0x51, 0x3B, 0x3B, 0x35, 0x3A, 0x3A, 0x4F, 0x5C, 0x5E, 0x62, 0x68, 0x6F, 0x78, 0x77, 0x75, 0x7F, 0x82, 0x8A, 0x88, 0x83, 0x7C, 0x73, 0x75, 0xAD, 0xAB, 0xAB, 0xAC,
          0xAB, 0xAC, 0xAA,
    0xA2, 0xA2, 0xA4, 0xA4, 0xA3, 0xA4, 0x7A, 0x6E, 0x6D, 0x68, 0x70, 0x7D, 0x88, 0x80, 0x79, 0x6A, 0x5F, 0x55, 0x53, 0x52, 0x56, 0x4F, 0x48, 0x43, 0x42, 0x47, 0x4C, 0x4E, 0x5C, 0x62, 0x7A, 0x83, 0x8C, 0x87, 0x84, 0x7B, 0x73, 0x8C, 0xAD, 0xAD, 0xAD, 0xAC,
          0xAC, 0xAC, 0xAB,
    0xA2, 0xA2, 0xA4, 0xA4, 0xA4, 0xA5, 0x6E, 0x6D, 0x6E, 0x6E, 0x6F, 0x75, 0x83, 0x80, 0x78, 0x6E, 0x68, 0x68, 0x63, 0x5E, 0x61, 0x67, 0x6D, 0x6B, 0x67, 0x62, 0x69, 0x78, 0x81, 0x80, 0x84, 0x8C, 0x8A, 0x83, 0x80, 0x7B, 0x70, 0xA9, 0xAE, 0xAE, 0xAD, 0xAD,
          0xAE, 0xAD, 0xAC,
    0xA2, 0xA1, 0xA3, 0xA3, 0xA4, 0xA4, 0x6C, 0x64, 0x6C, 0x6E, 0x72, 0x71, 0x7A, 0x7C, 0x76, 0x6E, 0x6E, 0x6C, 0x6D, 0x6C, 0x6C, 0x68, 0x6A, 0x6E, 0x73, 0x7A, 0x7F, 0x84, 0x89, 0x87, 0x86, 0x8C, 0x87, 0x83, 0x7E, 0x77, 0x89, 0xAE, 0xAF, 0xAE, 0xAE, 0xAE,
          0xAD, 0xAE, 0xAC,
    0xA2, 0xA1, 0xA3, 0xA3, 0xA5, 0xAA, 0x6B, 0x5B, 0x67, 0x6B, 0x71, 0x70, 0x72, 0x79, 0x72, 0x70, 0x6D, 0x70, 0x70, 0x71, 0x72, 0x70, 0x74, 0x7B, 0x7F, 0x83, 0x84, 0x87, 0x89, 0x8A, 0x88, 0x88, 0x84, 0x83, 0x7B, 0x73, 0xAF, 0xAE, 0xAE, 0xAE, 0xAF, 0xAF,
          0xB0, 0xAE, 0xAD,
    0xA1, 0xA1, 0xA3, 0xA6, 0x98, 0x58, 0x60, 0x5A, 0x5C, 0x69, 0x6D, 0x6D, 0x71, 0x71, 0x71, 0x73, 0x71, 0x71, 0x6F, 0x73, 0x75, 0x78, 0x78, 0x7E, 0x81, 0x84, 0x86, 0x89, 0x88, 0x87, 0x87, 0x87, 0x86, 0x81, 0x74, 0xA2, 0xAE, 0xAF, 0xAF, 0xAF, 0xAF, 0xAE,
          0xAF, 0xAF, 0xAD,
    0xA0, 0xA1, 0xA3, 0x9F, 0x67, 0x48, 0x61, 0x5D, 0x59, 0x61, 0x67, 0x66, 0x69, 0x6E, 0x70, 0x74, 0x73, 0x74, 0x6D, 0x6D, 0x77, 0x79, 0x7A, 0x80, 0x84, 0x86, 0x89, 0x89, 0x88, 0x85, 0x83, 0x84, 0x83, 0x74, 0x96, 0xB0, 0xB0, 0xB0, 0xB0, 0xAF, 0xB0, 0xB1,
          0xB0, 0xB0, 0xAF,
    0x9B, 0x9E, 0xA0, 0x90, 0x57, 0x4B, 0x60, 0x61, 0x5B, 0x5B, 0x5F, 0x60, 0x64, 0x69, 0x6B, 0x72, 0x76, 0x71, 0x69, 0x6B, 0x77, 0x7C, 0x7D, 0x7B, 0x84, 0x8B, 0x8B, 0x89, 0x87, 0x81, 0x84, 0x80, 0x7A, 0x79, 0xB4, 0xB0, 0xB0, 0xB0, 0xB1, 0xB1, 0xB1, 0xB1,
          0xB0, 0xB0, 0xAF,
    0x99, 0x99, 0x99, 0x8A, 0x61, 0x3A, 0x63, 0x60, 0x5E, 0x59, 0x5A, 0x5B, 0x60, 0x61, 0x65, 0x6C, 0x75, 0x6F, 0x6C, 0x72, 0x7B, 0x81, 0x85, 0x81, 0x84, 0x8B, 0x87, 0x85, 0x7E, 0x7B, 0x7E, 0x7A, 0x6E, 0x7B, 0xAE, 0xAF, 0xB1, 0xB0, 0xB1, 0xB0, 0xB0, 0xB0,
          0xB0, 0xB0, 0xB0,
    0x98, 0x97, 0x99, 0x86, 0x60, 0x2F, 0x60, 0x60, 0x5F, 0x59, 0x59, 0x56, 0x57, 0x5C, 0x60, 0x66, 0x6D, 0x6E, 0x68, 0x6F, 0x7B, 0x7C, 0x81, 0x83, 0x83, 0x86, 0x83, 0x7C, 0x7B, 0x77, 0x77, 0x70, 0x6E, 0x77, 0xAA, 0xB1, 0xB0, 0xB0, 0xB0, 0xB1, 0xB0, 0xB1,
          0xB0, 0xB0, 0xAF,
    0x98, 0x97, 0x9E, 0x86, 0x41, 0x36, 0x5C, 0x5C, 0x5E, 0x5E, 0x5A, 0x55, 0x53, 0x55, 0x59, 0x61, 0x66, 0x67, 0x69, 0x6E, 0x79, 0x78, 0x79, 0x80, 0x7F, 0x80, 0x7C, 0x7B, 0x74, 0x6D, 0x6E, 0x6E, 0x6F, 0x59, 0xA1, 0xAD, 0xB1, 0xB1, 0xB1, 0xB1, 0xB1, 0xB2,
          0xB1, 0xB1, 0xB1,
    0x98, 0x96, 0xA4, 0x83, 0x2B, 0x37, 0x5A, 0x61, 0x64, 0x61, 0x5C, 0x59, 0x53, 0x51, 0x51, 0x59, 0x61, 0x62, 0x6A, 0x6F, 0x75, 0x79, 0x79, 0x75, 0x79, 0x7C, 0x78, 0x71, 0x66, 0x6C, 0x6F, 0x72, 0x6F, 0x49, 0x9F, 0xAA, 0xB3, 0xB1, 0xB1, 0xB1, 0xB2, 0xB2,
          0xB1, 0xB1, 0xB2,
    0x99, 0x97, 0xA5, 0x93, 0x2A, 0x39, 0x54, 0x60, 0x67, 0x63, 0x5E, 0x59, 0x53, 0x51, 0x4F, 0x4F, 0x56, 0x5C, 0x62, 0x6A, 0x71, 0x73, 0x70, 0x6E, 0x6E, 0x6B, 0x66, 0x64, 0x68, 0x73, 0x75, 0x73, 0x5B, 0x40, 0x9A, 0xA9, 0xB2, 0xB2, 0xB2, 0xB2, 0xB1, 0xB2,
          0xB2, 0xB1, 0xB2,
    0x98, 0x98, 0xA5, 0x9E, 0x32, 0x3C, 0x50, 0x5F, 0x66, 0x64, 0x61, 0x5C, 0x5A, 0x58, 0x53, 0x4E, 0x4E, 0x51, 0x55, 0x59, 0x5F, 0x5D, 0x5F, 0x5B, 0x59, 0x5B, 0x62, 0x6F, 0x73, 0x75, 0x76, 0x75, 0x49, 0x32, 0x92, 0xAB, 0xB1, 0xB3, 0xB3, 0xB2, 0xB2, 0xB3,
          0xB1, 0xB2, 0xB2,
    0x9A, 0x98, 0xA7, 0xA4, 0x46, 0x3C, 0x4C, 0x5D, 0x66, 0x66, 0x61, 0x62, 0x5E, 0x5E, 0x59, 0x56, 0x54, 0x53, 0x54, 0x56, 0x55, 0x58, 0x58, 0x5E, 0x62, 0x69, 0x73, 0x74, 0x7A, 0x79, 0x79, 0x75, 0x42, 0x26, 0x8F, 0xAB, 0xA7, 0xA9, 0xAD, 0xB1, 0xB4, 0xB3,
          0xB2, 0xB2, 0xB1,
    0x9A, 0x9C, 0xA6, 0xAB, 0x69, 0x3D, 0x48, 0x5B, 0x66, 0x6A, 0x68, 0x67, 0x65, 0x64, 0x60, 0x62, 0x64, 0x63, 0x64, 0x66, 0x60, 0x69, 0x70, 0x72, 0x76, 0x79, 0x7E, 0x7F, 0x7B, 0x78, 0x79, 0x6F, 0x3D, 0x27, 0xA0, 0xB5, 0xAF, 0xB0, 0xAC, 0xA7, 0xA0, 0xA9,
          0xB2, 0xB3, 0xB3,
    0x9C, 0xA1, 0xA5, 0xAA, 0x99, 0x42, 0x46, 0x54, 0x63, 0x69, 0x6E, 0x6E, 0x71, 0x6F, 0x6B, 0x71, 0x75, 0x75, 0x78, 0x79, 0x79, 0x7C, 0x7E, 0x81, 0x80, 0x7F, 0x7E, 0x7F, 0x7F, 0x7A, 0x78, 0x61, 0x36, 0x40, 0xA3, 0xB0, 0xAE, 0xB2, 0xB1, 0xB2, 0xB3, 0xAE,
          0xA7, 0xA7, 0xAB,
    0xA1, 0xA0, 0xA5, 0xA8, 0xB0, 0x6D, 0x44, 0x50, 0x60, 0x67, 0x6E, 0x75, 0x76, 0x71, 0x72, 0x75, 0x7A, 0x7B, 0x7C, 0x80, 0x85, 0x8C, 0x89, 0x87, 0x84, 0x85, 0x7E, 0x7E, 0x7E, 0x7C, 0x74, 0x57, 0x2E, 0x61, 0xAA, 0xB8, 0xAF, 0xB3, 0xBC, 0xBB, 0xB5, 0xAF,
          0xAE, 0xAF, 0xAE
  };

  static const GUI_BITMAP _bmJoerg_8bpp = {
    45, // xSize
    70, // ySize
    45, // BytesPerLine
    8, // BitsPerPixel
    _acJoerg_8bpp,  // Pointer to picture data (indices)
    &_PalJoerg_8bpp   // Pointer to palette
  };

  static const GUI_COLOR _ColorsJoerg_4bpp[] = {
    0x000000, 0x111111, 0x222222, 0x333333,
    0x444444, 0x555555, 0x666666, 0x777777,
    0x888888, 0x999999, 0xAAAAAA, 0xBBBBBB,
    0xCCCCCC, 0xDDDDDD, 0xEEEEEE, 0xFFFFFF
  };

  static const GUI_LOGPALETTE _PalJoerg_4bpp = {
    16,  // Number of entries
    0,   // No transparency
    &_ColorsJoerg_4bpp[0]
  };

  static const unsigned char _acJoerg_4bpp[] = {
    0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x98, 0x98, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x89, 0x80,
    0x99, 0x89, 0x99, 0x99, 0x99, 0x99, 0x99, 0x98, 0x98, 0x88, 0x78, 0x77, 0x77, 0x78, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x90,
    0x99, 0x89, 0x99, 0x99, 0x99, 0x99, 0x88, 0x75, 0x66, 0x45, 0x35, 0x44, 0x44, 0x46, 0x77, 0x89, 0x99, 0x99, 0x99, 0x99, 0x99, 0x89, 0x90,
    0x99, 0x89, 0x99, 0x99, 0x99, 0x87, 0x66, 0x43, 0x33, 0x32, 0x23, 0x33, 0x33, 0x34, 0x45, 0x77, 0x88, 0x99, 0x99, 0x99, 0x99, 0x89, 0x90,
    0x98, 0x98, 0x99, 0x88, 0x87, 0x67, 0x43, 0x32, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x33, 0x43, 0x46, 0x88, 0x89, 0x99, 0x88, 0x88, 0x80,
    0x98, 0x98, 0x99, 0x88, 0x65, 0x44, 0x43, 0x22, 0x22, 0x22, 0x21, 0x22, 0x22, 0x22, 0x22, 0x22, 0x33, 0x46, 0x78, 0x88, 0x88, 0x88, 0x80,
    0x99, 0x99, 0x99, 0x87, 0x53, 0x33, 0x33, 0x22, 0x22, 0x11, 0x11, 0x12, 0x21, 0x22, 0x22, 0x22, 0x22, 0x34, 0x67, 0x88, 0x88, 0x88, 0x80,
    0x99, 0x99, 0x98, 0x65, 0x33, 0x32, 0x22, 0x22, 0x22, 0x11, 0x11, 0x11, 0x11, 0x21, 0x22, 0x22, 0x22, 0x23, 0x36, 0x78, 0x88, 0x88, 0x80,
    0x9A, 0xA9, 0x98, 0x43, 0x22, 0x22, 0x22, 0x22, 0x12, 0x11, 0x11, 0x11, 0x12, 0x12, 0x22, 0x22, 0x22, 0x22, 0x44, 0x68, 0x99, 0x88, 0x80,
    0x99, 0x99, 0x85, 0x32, 0x21, 0x12, 0x12, 0x22, 0x11, 0x11, 0x11, 0x11, 0x11, 0x22, 0x22, 0x22, 0x21, 0x22, 0x23, 0x58, 0x99, 0x99, 0x90,
    0xAA, 0xAA, 0x96, 0x42, 0x21, 0x12, 0x21, 0x22, 0x21, 0x11, 0x11, 0x21, 0x12, 0x21, 0x22, 0x21, 0x11, 0x21, 0x22, 0x47, 0x99, 0x99, 0x90,
    0xAA, 0xAA, 0x73, 0x21, 0x11, 0x12, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21, 0x11, 0x12, 0x11, 0x11, 0x11, 0x11, 0x12, 0x35, 0x79, 0x99, 0x90,
    0xBB, 0xA7, 0x32, 0x21, 0x11, 0x12, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21, 0x11, 0x21, 0x11, 0x11, 0x23, 0x58, 0x99, 0x90,
    0xBB, 0xB5, 0x22, 0x11, 0x12, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x32, 0x33, 0x32, 0x22, 0x22, 0x21, 0x11, 0x22, 0x36, 0x99, 0x90,
    0xCB, 0xA3, 0x21, 0x11, 0x23, 0x33, 0x44, 0x44, 0x44, 0x45, 0x54, 0x44, 0x44, 0x45, 0x43, 0x33, 0x33, 0x32, 0x11, 0x22, 0x34, 0x89, 0x90,
    0xCB, 0x72, 0x21, 0x12, 0x34, 0x44, 0x55, 0x66, 0x66, 0x66, 0x66, 0x55, 0x55, 0x54, 0x44, 0x44, 0x44, 0x43, 0x21, 0x12, 0x23, 0x69, 0x90,
    0xCA, 0x32, 0x21, 0x13, 0x44, 0x55, 0x56, 0x66, 0x66, 0x67, 0x77, 0x66, 0x76, 0x66, 0x66, 0x65, 0x55, 0x54, 0x31, 0x11, 0x22, 0x49, 0x90,
    0xC9, 0x32, 0x21, 0x24, 0x45, 0x55, 0x66, 0x66, 0x66, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x76, 0x76, 0x65, 0x42, 0x11, 0x22, 0x36, 0x90,
    0xB6, 0x22, 0x22, 0x34, 0x55, 0x56, 0x66, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x76, 0x65, 0x43, 0x11, 0x22, 0x48, 0x90,
    0xB6, 0x22, 0x22, 0x34, 0x55, 0x66, 0x66, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x66, 0x54, 0x21, 0x12, 0x36, 0x90,
    0xB5, 0x32, 0x23, 0x45, 0x55, 0x66, 0x66, 0x77, 0x77, 0x78, 0x87, 0x88, 0x88, 0x88, 0x77, 0x77, 0x77, 0x76, 0x55, 0x32, 0x22, 0x35, 0x90,
    0xB4, 0x22, 0x33, 0x44, 0x55, 0x56, 0x67, 0x77, 0x77, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x77, 0x77, 0x76, 0x65, 0x32, 0x22, 0x35, 0x90,
    0xB4, 0x22, 0x33, 0x44, 0x55, 0x56, 0x66, 0x77, 0x88, 0x88, 0x88, 0x88, 0x99, 0x98, 0x88, 0x77, 0x77, 0x76, 0x65, 0x42, 0x22, 0x35, 0x90,
    0xB3, 0x22, 0x23, 0x44, 0x55, 0x56, 0x66, 0x77, 0x88, 0x88, 0x89, 0x88, 0x98, 0x88, 0x88, 0x87, 0x77, 0x76, 0x65, 0x43, 0x32, 0x36, 0x90,
    0xB3, 0x22, 0x23, 0x44, 0x55, 0x56, 0x66, 0x77, 0x88, 0x88, 0x88, 0x89, 0x98, 0x88, 0x88, 0x77, 0x77, 0x66, 0x55, 0x43, 0x32, 0x39, 0xA0,
    0xA3, 0x22, 0x23, 0x44, 0x55, 0x56, 0x66, 0x77, 0x77, 0x88, 0x88, 0x89, 0x98, 0x88, 0x88, 0x87, 0x77, 0x66, 0x65, 0x43, 0x33, 0x5A, 0xA0,
    0xA3, 0x22, 0x33, 0x45, 0x55, 0x66, 0x66, 0x77, 0x77, 0x88, 0x88, 0x99, 0x88, 0x88, 0x88, 0x87, 0x77, 0x66, 0x65, 0x43, 0x32, 0x7A, 0xA0,
    0xB3, 0x22, 0x33, 0x45, 0x56, 0x66, 0x67, 0x77, 0x78, 0x88, 0x88, 0x99, 0x88, 0x88, 0x88, 0x87, 0x77, 0x66, 0x65, 0x43, 0x22, 0x7A, 0xA0,
    0xA4, 0x22, 0x33, 0x45, 0x66, 0x66, 0x67, 0x77, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x87, 0x77, 0x77, 0x65, 0x43, 0x22, 0x8A, 0xA0,
    0xB6, 0x22, 0x34, 0x55, 0x66, 0x66, 0x67, 0x77, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x87, 0x77, 0x77, 0x66, 0x43, 0x22, 0x9A, 0xA0,
    0xA7, 0x23, 0x34, 0x55, 0x66, 0x65, 0x66, 0x67, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x77, 0x77, 0x66, 0x53, 0x22, 0x9A, 0xA0,
    0xA9, 0x32, 0x35, 0x55, 0x55, 0x55, 0x55, 0x55, 0x56, 0x77, 0x88, 0x88, 0x88, 0x88, 0x87, 0x77, 0x66, 0x77, 0x66, 0x53, 0x23, 0xAA, 0xA0,
    0xA9, 0x33, 0x35, 0x65, 0x54, 0x44, 0x44, 0x43, 0x34, 0x56, 0x77, 0x77, 0x77, 0x65, 0x54, 0x44, 0x55, 0x56, 0x66, 0x54, 0x34, 0xAA, 0xA0,
    0xA5, 0x33, 0x35, 0x65, 0x44, 0x45, 0x66, 0x65, 0x44, 0x56, 0x67, 0x67, 0x77, 0x65, 0x44, 0x45, 0x55, 0x55, 0x55, 0x54, 0x36, 0xAA, 0xA0,
    0x94, 0x43, 0x36, 0x65, 0x55, 0x55, 0x56, 0x55, 0x45, 0x45, 0x68, 0x88, 0x87, 0x66, 0x67, 0x78, 0x77, 0x55, 0x55, 0x53, 0x34, 0x7A, 0xA0,
    0x94, 0x53, 0x36, 0x66, 0x55, 0x43, 0x31, 0x42, 0x54, 0x44, 0x57, 0x88, 0x87, 0x65, 0x43, 0x33, 0x57, 0x66, 0x66, 0x64, 0x36, 0x69, 0xA0,
    0x94, 0x54, 0x46, 0x66, 0x55, 0x34, 0x62, 0x25, 0x76, 0x54, 0x57, 0x88, 0x76, 0x65, 0x62, 0x43, 0x63, 0x56, 0x77, 0x64, 0x56, 0x69, 0xA0,
    0xA5, 0x54, 0x46, 0x66, 0x55, 0x56, 0x66, 0x77, 0x66, 0x65, 0x57, 0x88, 0x77, 0x76, 0x75, 0x46, 0x75, 0x56, 0x77, 0x64, 0x67, 0x6A, 0xA0,
    0xA6, 0x64, 0x46, 0x66, 0x66, 0x56, 0x67, 0x77, 0x76, 0x55, 0x57, 0x78, 0x76, 0x76, 0x67, 0x87, 0x77, 0x66, 0x76, 0x65, 0x87, 0x6A, 0xA0,
    0xB7, 0x64, 0x46, 0x66, 0x66, 0x66, 0x66, 0x66, 0x76, 0x55, 0x67, 0x78, 0x76, 0x67, 0x77, 0x78, 0x77, 0x77, 0x77, 0x65, 0x77, 0x8A, 0xA0,
    0xB7, 0x64, 0x56, 0x66, 0x66, 0x67, 0x77, 0x77, 0x66, 0x65, 0x66, 0x78, 0x87, 0x67, 0x88, 0x77, 0x77, 0x77, 0x77, 0x66, 0x78, 0xAA, 0xA0,
    0xB8, 0x64, 0x56, 0x66, 0x67, 0x77, 0x77, 0x67, 0x77, 0x66, 0x67, 0x78, 0x76, 0x77, 0x77, 0x88, 0x87, 0x77, 0x77, 0x67, 0x77, 0xAA, 0xA0,
    0xA9, 0x55, 0x46, 0x66, 0x67, 0x77, 0x77, 0x77, 0x77, 0x66, 0x66, 0x78, 0x76, 0x77, 0x87, 0x77, 0x78, 0x87, 0x77, 0x76, 0x78, 0xAA, 0xA0,
    0xAA, 0x56, 0x56, 0x66, 0x66, 0x77, 0x77, 0x77, 0x77, 0x65, 0x66, 0x78, 0x77, 0x78, 0x88, 0x87, 0x78, 0x87, 0x76, 0x66, 0x78, 0xAA, 0xA0,
    0xAA, 0x76, 0x56, 0x66, 0x66, 0x77, 0x78, 0x88, 0x86, 0x55, 0x66, 0x78, 0x76, 0x68, 0x88, 0x88, 0x88, 0x87, 0x77, 0x78, 0x7A, 0xAA, 0xA0,
    0xAA, 0x86, 0x56, 0x66, 0x66, 0x77, 0x78, 0x87, 0x65, 0x66, 0x67, 0x79, 0x86, 0x67, 0x89, 0x88, 0x88, 0x87, 0x77, 0x89, 0x7A, 0xAA, 0xA0,
    0xAA, 0x95, 0x66, 0x66, 0x67, 0x77, 0x88, 0x87, 0x65, 0x66, 0x67, 0x8A, 0x87, 0x77, 0x78, 0x99, 0x88, 0x88, 0x76, 0x78, 0x8A, 0xAA, 0xA0,
    0xAA, 0xA8, 0x67, 0x66, 0x67, 0x77, 0x78, 0x77, 0x65, 0x44, 0x57, 0x88, 0x87, 0x77, 0x77, 0x89, 0x88, 0x88, 0x76, 0x78, 0x9A, 0xAA, 0xA0,
    0xAA, 0xAA, 0xA8, 0x66, 0x66, 0x77, 0x77, 0x77, 0x76, 0x54, 0x45, 0x77, 0x75, 0x67, 0x87, 0x88, 0x88, 0x87, 0x76, 0x78, 0xAA, 0xAA, 0xA0,
    0xAA, 0xAA, 0xA8, 0x66, 0x66, 0x77, 0x77, 0x76, 0x66, 0x65, 0x54, 0x45, 0x66, 0x77, 0x88, 0x88, 0x88, 0x87, 0x76, 0x9A, 0xAA, 0xAA, 0xA0,
    0xAA, 0xAA, 0xA9, 0x66, 0x66, 0x77, 0x77, 0x76, 0x66, 0x66, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x88, 0x88, 0x76, 0x9A, 0xAA, 0xAA, 0xA0,
    0xAA, 0xAA, 0xAA, 0x66, 0x66, 0x77, 0x77, 0x65, 0x54, 0x45, 0x67, 0x77, 0x77, 0x77, 0x78, 0x87, 0x88, 0x87, 0x76, 0xAA, 0xAA, 0xAA, 0xA0,
    0xAA, 0xAA, 0xAA, 0x76, 0x66, 0x77, 0x87, 0x75, 0x33, 0x33, 0x34, 0x55, 0x66, 0x67, 0x77, 0x88, 0x88, 0x87, 0x77, 0xAA, 0xAA, 0xAA, 0xA0,
    0xAA, 0xAA, 0xAA, 0x76, 0x66, 0x67, 0x87, 0x76, 0x65, 0x55, 0x54, 0x44, 0x44, 0x44, 0x56, 0x78, 0x88, 0x87, 0x78, 0xAA, 0xAA, 0xAA, 0xA0,
    0xAA, 0xAA, 0xAA, 0x66, 0x66, 0x67, 0x77, 0x76, 0x66, 0x65, 0x66, 0x66, 0x66, 0x67, 0x87, 0x88, 0x87, 0x77, 0x7A, 0xAA, 0xAA, 0xAA, 0xA0,
    0xAA, 0xAA, 0xAA, 0x66, 0x66, 0x76, 0x77, 0x77, 0x76, 0x66, 0x66, 0x67, 0x77, 0x88, 0x88, 0x88, 0x88, 0x77, 0x8A, 0xAB, 0xAA, 0xAA, 0xA0,
    0xAA, 0xAA, 0xAA, 0x65, 0x66, 0x66, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x88, 0x88, 0x88, 0x88, 0x88, 0x77, 0xAA, 0xAB, 0xBA, 0xBB, 0xA0,
    0xAA, 0xAA, 0x95, 0x65, 0x56, 0x66, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x88, 0x88, 0x88, 0x88, 0x88, 0x7A, 0xBA, 0xBB, 0xBA, 0xAB, 0xB0,
    0xAA, 0xAA, 0x64, 0x65, 0x56, 0x66, 0x66, 0x67, 0x77, 0x66, 0x77, 0x78, 0x88, 0x88, 0x88, 0x88, 0x87, 0x9B, 0xAB, 0xBB, 0xBB, 0xBB, 0xB0,
    0x9A, 0xA9, 0x54, 0x65, 0x55, 0x56, 0x66, 0x67, 0x77, 0x66, 0x77, 0x77, 0x88, 0x88, 0x88, 0x88, 0x77, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xB0,
    0x99, 0x98, 0x53, 0x65, 0x55, 0x55, 0x55, 0x66, 0x76, 0x67, 0x78, 0x88, 0x88, 0x88, 0x87, 0x87, 0x67, 0xAB, 0xBB, 0xBB, 0xBB, 0xBB, 0xB0,
    0x99, 0x98, 0x52, 0x65, 0x55, 0x55, 0x55, 0x66, 0x66, 0x66, 0x77, 0x88, 0x88, 0x87, 0x77, 0x77, 0x67, 0xAB, 0xAB, 0xBB, 0xAB, 0xBB, 0xA0,
    0x99, 0x98, 0x33, 0x55, 0x55, 0x55, 0x55, 0x56, 0x66, 0x66, 0x77, 0x78, 0x88, 0x77, 0x76, 0x66, 0x65, 0xAA, 0xAB, 0xBB, 0xBB, 0xBB, 0xB0,
    0x99, 0xA8, 0x23, 0x55, 0x65, 0x55, 0x44, 0x45, 0x66, 0x67, 0x77, 0x77, 0x78, 0x77, 0x66, 0x77, 0x64, 0x9A, 0xBB, 0xBB, 0xBB, 0xBB, 0xB0,
    0x99, 0xA9, 0x23, 0x55, 0x66, 0x55, 0x44, 0x44, 0x55, 0x66, 0x77, 0x77, 0x76, 0x66, 0x67, 0x77, 0x54, 0x9A, 0xBB, 0xBB, 0xBB, 0xBB, 0xB0,
    0x99, 0xA9, 0x33, 0x45, 0x66, 0x55, 0x55, 0x54, 0x45, 0x55, 0x66, 0x65, 0x55, 0x67, 0x77, 0x77, 0x43, 0x9A, 0xBB, 0xBB, 0xBB, 0xBB, 0xB0,
    0x99, 0xAA, 0x43, 0x45, 0x66, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x66, 0x77, 0x77, 0x77, 0x42, 0x8A, 0xAA, 0xAB, 0xBB, 0xBB, 0xB0,
    0x99, 0xAA, 0x63, 0x45, 0x66, 0x66, 0x66, 0x56, 0x66, 0x66, 0x56, 0x77, 0x77, 0x88, 0x77, 0x76, 0x32, 0x9B, 0xAB, 0xAA, 0xAA, 0xBB, 0xB0,
    0x9A, 0xAA, 0x94, 0x45, 0x66, 0x66, 0x76, 0x67, 0x77, 0x77, 0x77, 0x88, 0x88, 0x88, 0x87, 0x75, 0x34, 0xAA, 0xAB, 0xBB, 0xBA, 0xAA, 0xA0,
    0xAA, 0xAA, 0xB6, 0x44, 0x56, 0x67, 0x76, 0x77, 0x77, 0x78, 0x88, 0x88, 0x88, 0x87, 0x87, 0x75, 0x26, 0xAB, 0xAB, 0xBB, 0xBB, 0xAB, 0xA0
  };

  static const GUI_BITMAP _bmJoerg_4bpp = {
    45, // xSize
    70, // ySize
    23, // BytesPerLine
    4, // BitsPerPixel
    _acJoerg_4bpp,  // Pointer to picture data (indices)
    &_PalJoerg_4bpp   // Pointer to palette
  };

  static const GUI_COLOR _ColorsJoerg_2bpp[] = {
    0x000000, 0x555555, 0xAAAAAA, 0xFFFFFF
  };

  static const GUI_LOGPALETTE _PalJoerg_2bpp = {
    4,  // Number of entries
    0,  // No transparency
    &_ColorsJoerg_2bpp[0]
  };

  static const unsigned char _acJoerg_2bpp[] = {
    0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0x80,
    0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0x65, 0x56, 0xAA, 0xAA, 0xAA, 0xAA, 0x80,
    0xAA, 0xAA, 0xAA, 0xA5, 0x55, 0x55, 0x55, 0x5A, 0xAA, 0xAA, 0xAA, 0x80,
    0xAA, 0xAA, 0xA9, 0x55, 0x55, 0x55, 0x55, 0x55, 0x6A, 0xAA, 0xAA, 0x80,
    0xAA, 0xAA, 0x95, 0x55, 0x50, 0x00, 0x55, 0x55, 0x5A, 0xAA, 0xAA, 0x80,
    0xAA, 0xAA, 0x55, 0x55, 0x00, 0x00, 0x00, 0x55, 0x55, 0x6A, 0xAA, 0x80,
    0xAA, 0xA9, 0x55, 0x54, 0x00, 0x00, 0x00, 0x00, 0x15, 0x5A, 0xAA, 0x80,
    0xAA, 0xA5, 0x55, 0x14, 0x00, 0x00, 0x00, 0x00, 0x15, 0x56, 0xAA, 0x80,
    0xAA, 0xA5, 0x44, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x56, 0xAA, 0x80,
    0xAA, 0x95, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xAA, 0x80,
    0xAA, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0xAA, 0x80,
    0xAA, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x6A, 0x80,
    0xA9, 0x40, 0x00, 0x50, 0x01, 0x55, 0x00, 0x00, 0x00, 0x05, 0x6A, 0x80,
    0xA9, 0x40, 0x05, 0x55, 0x55, 0x55, 0x55, 0x51, 0x40, 0x00, 0x5A, 0x80,
    0xA9, 0x00, 0x15, 0x55, 0x55, 0x55, 0x55, 0x55, 0x54, 0x00, 0x5A, 0x80,
    0xA5, 0x00, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x56, 0x80,
    0xA5, 0x01, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x40, 0x16, 0x80,
    0xA4, 0x01, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x40, 0x05, 0x80,
    0x94, 0x05, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x50, 0x06, 0x80,
    0x95, 0x15, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x50, 0x15, 0x80,
    0x95, 0x55, 0x55, 0x55, 0x55, 0xAA, 0x6A, 0x55, 0x55, 0x54, 0x05, 0x80,
    0x95, 0x55, 0x55, 0x55, 0x5A, 0xAA, 0xAA, 0xA5, 0x55, 0x54, 0x55, 0x80,
    0x95, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA, 0xA9, 0x55, 0x55, 0x55, 0x80,
    0x95, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA, 0xA9, 0x55, 0x55, 0x55, 0x80,
    0x95, 0x55, 0x55, 0x55, 0x6A, 0xAA, 0xAA, 0xA9, 0x55, 0x55, 0x56, 0x80,
    0x91, 0x55, 0x55, 0x55, 0x5A, 0xAA, 0xAA, 0xA9, 0x55, 0x55, 0x56, 0x80,
    0x91, 0x55, 0x55, 0x55, 0x5A, 0xAA, 0xAA, 0xA5, 0x55, 0x55, 0x56, 0x80,
    0x91, 0x55, 0x55, 0x55, 0x5A, 0xAA, 0xAA, 0xA5, 0x55, 0x55, 0x56, 0x80,
    0x95, 0x55, 0x55, 0x55, 0x5A, 0xAA, 0xAA, 0xA5, 0x55, 0x55, 0x06, 0x80,
    0x95, 0x55, 0x55, 0x55, 0x6A, 0xAA, 0xAA, 0xA9, 0x55, 0x55, 0x0A, 0x80,
    0x95, 0x55, 0x55, 0x55, 0x6A, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x0A, 0x80,
    0xA5, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0x95, 0x55, 0x55, 0x5A, 0x80,
    0xA5, 0x55, 0x55, 0x55, 0x55, 0x65, 0x55, 0x55, 0x55, 0x55, 0x5A, 0x80,
    0x95, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x5A, 0x80,
    0x95, 0x55, 0x55, 0x55, 0x55, 0x6A, 0x95, 0x55, 0x55, 0x55, 0x56, 0x80,
    0x95, 0x55, 0x55, 0x45, 0x55, 0x5A, 0x95, 0x55, 0x55, 0x55, 0x56, 0x80,
    0x95, 0x55, 0x55, 0x55, 0x95, 0x5A, 0x55, 0x55, 0x55, 0x55, 0x56, 0x80,
    0x95, 0x55, 0x55, 0x55, 0x55, 0x5A, 0x55, 0x55, 0x55, 0x55, 0x56, 0x80,
    0x95, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x96, 0x80,
    0x95, 0x55, 0x55, 0x55, 0x55, 0x56, 0x55, 0x56, 0x55, 0x55, 0x9A, 0x80,
    0xA5, 0x55, 0x55, 0x55, 0x55, 0x56, 0x95, 0xA5, 0x55, 0x55, 0x6A, 0x80,
    0xA5, 0x55, 0x55, 0x55, 0x55, 0x56, 0x55, 0x5A, 0xA5, 0x55, 0x6A, 0x80,
    0xA5, 0x55, 0x55, 0x55, 0x55, 0x56, 0x55, 0x95, 0x59, 0x55, 0x6A, 0x80,
    0xA5, 0x55, 0x55, 0x55, 0x55, 0x56, 0x56, 0xA9, 0x59, 0x55, 0x6A, 0x80,
    0xA5, 0x55, 0x55, 0x5A, 0x95, 0x56, 0x56, 0xAA, 0xA9, 0x56, 0x6A, 0x80,
    0xA9, 0x55, 0x55, 0x69, 0x55, 0x5A, 0x95, 0xAA, 0xA9, 0x5A, 0x6A, 0x80,
    0xA9, 0x55, 0x55, 0x69, 0x55, 0x5A, 0x95, 0x6A, 0xAA, 0x56, 0xAA, 0x80,
    0xAA, 0x55, 0x55, 0x55, 0x55, 0x5A, 0x95, 0x5A, 0xAA, 0x56, 0xAA, 0x80,
    0xAA, 0xA5, 0x55, 0x55, 0x55, 0x55, 0x55, 0x9A, 0xAA, 0x56, 0xAA, 0x80,
    0xAA, 0xA5, 0x55, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0x5A, 0xAA, 0x80,
    0xAA, 0xA5, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xAA, 0x5A, 0xAA, 0x80,
    0xAA, 0xA5, 0x55, 0x55, 0x55, 0x55, 0x55, 0x69, 0xA9, 0x5A, 0xAA, 0x80,
    0xAA, 0xA5, 0x56, 0x95, 0x55, 0x55, 0x55, 0x56, 0xA9, 0x5A, 0xAA, 0x80,
    0xAA, 0xA5, 0x55, 0xA5, 0x55, 0x55, 0x55, 0x56, 0xA9, 0x6A, 0xAA, 0x80,
    0xAA, 0xA5, 0x55, 0xA5, 0x55, 0x55, 0x55, 0xAA, 0xA9, 0x6A, 0xAA, 0x80,
    0xAA, 0xA5, 0x55, 0x55, 0x55, 0x55, 0x5A, 0xAA, 0xA5, 0xAA, 0xAA, 0x80,
    0xAA, 0xA5, 0x55, 0x55, 0x55, 0x55, 0x6A, 0xAA, 0xA5, 0xAA, 0xAA, 0x80,
    0xAA, 0x95, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xA6, 0xAA, 0xAA, 0x80,
    0xAA, 0x55, 0x55, 0x55, 0x55, 0x56, 0xAA, 0xAA, 0x9A, 0xAA, 0xAA, 0x80,
    0xAA, 0x55, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0x5A, 0xAA, 0xAA, 0x80,
    0xAA, 0x55, 0x55, 0x55, 0x55, 0x6A, 0xAA, 0x55, 0x5A, 0xAA, 0xAA, 0x80,
    0xAA, 0x55, 0x55, 0x55, 0x55, 0x5A, 0xA9, 0x55, 0x5A, 0xAA, 0xAA, 0x80,
    0xAA, 0x55, 0x55, 0x55, 0x55, 0x56, 0x65, 0x55, 0x5A, 0xAA, 0xAA, 0x80,
    0xAA, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x5A, 0xAA, 0xAA, 0x80,
    0xAA, 0x15, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x5A, 0xAA, 0xAA, 0x80,
    0xAA, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x5A, 0xAA, 0xAA, 0x80,
    0xAA, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x4A, 0xAA, 0xAA, 0x80,
    0xAA, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x4A, 0xAA, 0xAA, 0x80,
    0xAA, 0x95, 0x55, 0x55, 0x55, 0x56, 0x95, 0x55, 0x5A, 0xAA, 0xAA, 0x80,
    0xAA, 0x95, 0x55, 0x55, 0x56, 0xAA, 0xA5, 0x55, 0x5A, 0xAA, 0xAA, 0x80
  };

  static const GUI_BITMAP _bmJoerg_2bpp = {
    45, // xSize
    70, // ySize
    12, // BytesPerLine
    2, // BitsPerPixel
    _acJoerg_2bpp,  // Pointer to picture data (indices)
    &_PalJoerg_2bpp   // Pointer to palette
  };

  static const GUI_COLOR _ColorsJoerg_1bpp[] = {
    0x000000, 0xFFFFFF
  };

  static const GUI_LOGPALETTE _PalJoerg_1bpp = {
    2,  // Number of entries
    0,  // No transparency
    &_ColorsJoerg_1bpp[0]
  };

  static const unsigned char _acJoerg_1bpp[] = {
    XXXXXXXX, XXXXXXXX, XXXXXXXX, XXXXXXXX, XXXXXXXX, XXXXX___,
    XXXXXXXX, XXXXXXXX, XXXX_X__, ___XXXXX, XXXXXXXX, XXXXX___,
    XXXXXXXX, XXXXXX__, ________, ______XX, XXXXXXXX, XXXXX___,
    XXXXXXXX, XXX_____, ________, ________, _XXXXXXX, XXXXX___,
    XXXXXXXX, X_______, ________, ________, __XXXXXX, XXXXX___,
    XXXXXXXX, ________, ________, ________, _____XXX, XXXXX___,
    XXXXXXX_, ________, ________, ________, ______XX, XXXXX___,
    XXXXXX__, ________, ________, ________, _______X, XXXXX___,
    XXXXXX__, ________, ________, ________, _______X, XXXXX___,
    XXXXX___, ________, ________, ________, _______X, XXXXX___,
    XXXXX___, ________, ________, ________, ________, XXXXX___,
    XXXX____, ________, ________, ________, ________, _XXXX___,
    XXX_____, ________, ________, ________, ________, _XXXX___,
    XXX_____, ________, ________, ________, ________, __XXX___,
    XXX_____, ________, ________, ________, ________, __XXX___,
    XX______, ________, ________, ________, ________, ___XX___,
    XX______, ________, ________, ________, ________, ___XX___,
    XX______, ________, ________, ________, ________, ____X___,
    X_______, ________, ________, ________, ________, ___XX___,
    X_______, ________, ________, ________, ________, ____X___,
    X_______, ________, ___XXXXX, _XXX____, ________, ____X___,
    X_______, ________, __XXXXXX, XXXXXX__, ________, ____X___,
    X_______, ________, XXXXXXXX, XXXXXXX_, ________, ____X___,
    X_______, ________, XXXXXXXX, XXXXXXX_, ________, ____X___,
    X_______, ________, _XXXXXXX, XXXXXXX_, ________, ___XX___,
    X_______, ________, __XXXXXX, XXXXXXX_, ________, ___XX___,
    X_______, ________, __XXXXXX, XXXXXX__, ________, ___XX___,
    X_______, ________, __XXXXXX, XXXXXX__, ________, ___XX___,
    X_______, ________, _XXXXXXX, XXXXXXX_, ________, __XXX___,
    X_______, ________, _XXXXXXX, XXXXXXX_, ________, __XXX___,
    X_______, ________, _XXXXXXX, XXXXXXXX, ________, __XXX___,
    XX______, ________, ____XXXX, XXXXX___, ________, __XXX___,
    XX______, ________, _____X__, ________, ________, __XXX___,
    X_______, ________, ________, ________, ________, __XXX___,
    X_______, ________, _____XXX, X_______, ________, ___XX___,
    X_______, ________, ______XX, X_______, ________, ___XX___,
    X_______, ________, X_____XX, ________, ________, ___XX___,
    X_______, ________, ______XX, ________, ________, ___XX___,
    X_______, ________, _______X, ________, ________, X__XX___,
    X_______, ________, _______X, _______X, ________, X_XXX___,
    XX______, ________, _______X, X___XX__, ________, _XXXX___,
    XX______, ________, _______X, ______XX, XXX_____, _XXXX___,
    XX______, ________, _______X, ____X___, __X_____, _XXXX___,
    XX______, _____X__, _______X, ___XXXX_, __X_____, _XXXX___,
    XX______, ______XX, X______X, ___XXXXX, XXX____X, _XXXX___,
    XXX_____, _____XX_, ______XX, X___XXXX, XXX___XX, _XXXX___,
    XXX_____, _____XX_, ______XX, X____XXX, XXXX___X, XXXXX___,
    XXXX____, ________, ______XX, X____XXX, XXXX___X, XXXXX___,
    XXXXXX__, ________, ________, ____XXXX, XXXX___X, XXXXX___,
    XXXXXX__, ________, ________, ____XXXX, XXXX__XX, XXXXX___,
    XXXXXX__, ________, ________, ________, XXXX__XX, XXXXX___,
    XXXXXX__, ________, ________, _X___XX_, XXXX__XX, XXXXX___,
    XXXXXX__, ___XX___, ________, ______XX, XXX___XX, XXXXX___,
    XXXXXX__, ____XX__, ________, _______X, XXX__XXX, XXXXX___,
    XXXXXX__, ____XX__, ________, ____XXXX, XXX__XXX, XXXXX___,
    XXXXXX__, ________, ________, __XXXXXX, XX__XXXX, XXXXX___,
    XXXXXX__, ________, ________, XXXXXXXX, XX__XXXX, XXXXX___,
    XXXXX___, ________, ________, XXXXXXXX, XX_XXXXX, XXXXX___,
    XXXX____, ________, _______X, XXXXXXXX, X_XXXXXX, XXXXX___,
    XXXX____, ________, ________, XXXXXXXX, __XXXXXX, XXXXX___,
    XXXX____, ________, _____XXX, XXXX____, __XXXXXX, XXXXX___,
    XXXX____, ________, ______XX, XXX_____, __XXXXXX, XXXXX___,
    XXXX____, ________, _______X, _X______, __XXXXXX, XXXXX___,
    XXXX____, ________, ________, ________, __XXXXXX, XXXXX___,
    XXXX____, ________, ________, ________, __XXXXXX, XXXXX___,
    XXXX____, ________, ________, ________, __XXXXXX, XXXXX___,
    XXXX____, ________, ________, ________, __XXXXXX, XXXXX___,
    XXXX____, ________, ________, ___X____, __XXXXXX, XXXXX___,
    XXXXX___, ________, _______X, XX_X____, __XXXXXX, XXXXX___,
    XXXXX___, ________, ___XXXXX, XX______, __XXXXXX, XXXXX___
  };

  static const GUI_BITMAP _bmJoerg_1bpp = {
    45, // xSize
    70, // ySize
    6, // BytesPerLine
    1, // BitsPerPixel
    _acJoerg_1bpp,  // Pointer to picture data (indices)
    &_PalJoerg_1bpp   // Pointer to palette
  };

  static const PAL_BITMAP_CONTEXT _aGrayscaleBitmaps[] = {
    { &_bmJoerg_8bpp },
    { &_bmJoerg_4bpp },
    { &_bmJoerg_2bpp },
    { &_bmJoerg_1bpp },
  };

  static const char * _aacGrayscaleText[] = {
    "8bpp",
    "4bpp",
    "2bpp",
    "1bpp"
  };
#endif

/*********************************************************************
*
*       Color specific
*/
#if SHOW_HIGH_COLOR
  static GUI_CONST_STORAGE unsigned char _acSky_888[] = {
    0x27, 0x56, 0x82, 0x27, 0x56, 0x82, 0x27, 0x56, 0x82, 0x27, 0x56, 0x82, 0x27, 0x56, 0x82, 0x27, 0x56, 0x82, 0x27, 0x56, 0x82, 0x27, 0x56, 0x82, 0x27, 0x56, 0x82, 0x27, 0x56, 0x82, 0x27, 0x56, 0x82, 0x27, 0x56, 0x81, 0x26, 0x56, 0x81, 0x26, 0x56, 0x81,
          0x26, 0x55, 0x81, 0x26, 0x55, 0x81, 0x26, 0x55, 0x81, 0x26, 0x55, 0x80, 0x26, 0x55, 0x80, 0x26, 0x54, 0x80, 0x25, 0x54, 0x7F, 0x25, 0x54, 0x7F, 0x25, 0x54, 0x7F, 0x24, 0x53, 0x7F, 0x24, 0x53, 0x7E, 0x24, 0x53, 0x7E, 0x24, 0x52, 0x7E,
          0x24, 0x52, 0x7D, 0x23, 0x52, 0x7D, 0x23, 0x51, 0x7D, 0x23, 0x51, 0x7C, 0x23, 0x51, 0x7C, 0x22, 0x50, 0x7B, 0x22, 0x50, 0x7B, 0x22, 0x50, 0x7B, 0x21, 0x4F, 0x7A, 0x21, 0x4F, 0x7A, 0x21, 0x4E, 0x79, 0x20, 0x4E, 0x79, 0x20, 0x4E, 0x78,
          0x20, 0x4D, 0x78, 0x20, 0x4D, 0x77, 0x1F, 0x4C, 0x77, 0x1F, 0x4C, 0x77, 0x1E, 0x4C, 0x76, 0x1E, 0x4B, 0x76, 0x1E, 0x4B, 0x75, 0x1E, 0x4A, 0x75, 0x1D, 0x4A, 0x75, 0x1D, 0x4A, 0x74, 0x1D, 0x49, 0x74, 0x1C, 0x49, 0x73, 0x1C, 0x49, 0x73,
          0x1C, 0x48, 0x72, 0x1B, 0x48, 0x72, 0x1B, 0x48, 0x72, 0x1B, 0x47, 0x71, 0x1B, 0x47, 0x71, 0x1B, 0x47, 0x71, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70,
          0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70,
    0x28, 0x57, 0x83, 0x28, 0x57, 0x83, 0x28, 0x57, 0x83, 0x28, 0x57, 0x83, 0x28, 0x57, 0x83, 0x28, 0x57, 0x83, 0x28, 0x57, 0x83, 0x28, 0x57, 0x83, 0x27, 0x57, 0x83, 0x27, 0x57, 0x83, 0x27, 0x57, 0x82, 0x27, 0x57, 0x82, 0x27, 0x56, 0x82, 0x27, 0x56, 0x82,
          0x27, 0x56, 0x82, 0x27, 0x56, 0x82, 0x27, 0x56, 0x81, 0x26, 0x56, 0x81, 0x26, 0x55, 0x81, 0x26, 0x55, 0x81, 0x26, 0x55, 0x80, 0x26, 0x55, 0x80, 0x25, 0x54, 0x80, 0x25, 0x54, 0x80, 0x25, 0x54, 0x7F, 0x25, 0x53, 0x7F, 0x25, 0x53, 0x7E,
          0x24, 0x53, 0x7E, 0x24, 0x52, 0x7E, 0x24, 0x52, 0x7D, 0x23, 0x52, 0x7D, 0x23, 0x51, 0x7C, 0x23, 0x51, 0x7C, 0x22, 0x51, 0x7C, 0x22, 0x50, 0x7B, 0x22, 0x50, 0x7B, 0x21, 0x4F, 0x7A, 0x21, 0x4F, 0x7A, 0x21, 0x4F, 0x7A, 0x20, 0x4E, 0x79,
          0x20, 0x4E, 0x79, 0x20, 0x4D, 0x78, 0x1F, 0x4D, 0x78, 0x1F, 0x4D, 0x77, 0x1F, 0x4C, 0x77, 0x1F, 0x4C, 0x76, 0x1E, 0x4B, 0x76, 0x1E, 0x4B, 0x75, 0x1E, 0x4B, 0x75, 0x1D, 0x4A, 0x75, 0x1D, 0x4A, 0x74, 0x1D, 0x49, 0x74, 0x1C, 0x49, 0x73,
          0x1C, 0x49, 0x73, 0x1C, 0x48, 0x73, 0x1C, 0x48, 0x72, 0x1B, 0x47, 0x72, 0x1B, 0x47, 0x71, 0x1B, 0x47, 0x71, 0x1A, 0x47, 0x71, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70,
          0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70,
    0x28, 0x58, 0x84, 0x28, 0x58, 0x84, 0x28, 0x58, 0x84, 0x28, 0x58, 0x84, 0x28, 0x58, 0x84, 0x28, 0x58, 0x84, 0x28, 0x58, 0x84, 0x28, 0x58, 0x84, 0x28, 0x58, 0x84, 0x28, 0x58, 0x84, 0x28, 0x58, 0x84, 0x28, 0x58, 0x83, 0x28, 0x57, 0x83, 0x28, 0x57, 0x83,
          0x28, 0x57, 0x83, 0x27, 0x57, 0x83, 0x27, 0x57, 0x82, 0x27, 0x56, 0x82, 0x27, 0x56, 0x82, 0x27, 0x56, 0x82, 0x27, 0x56, 0x81, 0x26, 0x55, 0x81, 0x26, 0x55, 0x81, 0x26, 0x55, 0x80, 0x26, 0x55, 0x80, 0x25, 0x54, 0x80, 0x25, 0x54, 0x7F,
          0x25, 0x54, 0x7F, 0x25, 0x53, 0x7F, 0x24, 0x53, 0x7E, 0x24, 0x52, 0x7E, 0x24, 0x52, 0x7D, 0x23, 0x52, 0x7D, 0x23, 0x51, 0x7C, 0x23, 0x51, 0x7C, 0x22, 0x51, 0x7C, 0x22, 0x50, 0x7B, 0x22, 0x50, 0x7B, 0x21, 0x4F, 0x7A, 0x21, 0x4F, 0x7A,
          0x21, 0x4E, 0x79, 0x20, 0x4E, 0x79, 0x20, 0x4E, 0x78, 0x20, 0x4D, 0x78, 0x1F, 0x4D, 0x77, 0x1F, 0x4C, 0x77, 0x1F, 0x4C, 0x76, 0x1E, 0x4B, 0x76, 0x1E, 0x4B, 0x76, 0x1E, 0x4B, 0x75, 0x1D, 0x4A, 0x75, 0x1D, 0x4A, 0x74, 0x1D, 0x49, 0x74,
          0x1C, 0x49, 0x73, 0x1C, 0x49, 0x73, 0x1C, 0x48, 0x73, 0x1C, 0x48, 0x72, 0x1B, 0x48, 0x72, 0x1B, 0x47, 0x71, 0x1B, 0x47, 0x71, 0x1A, 0x47, 0x71, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70,
          0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70,
    0x29, 0x59, 0x85, 0x29, 0x59, 0x85, 0x29, 0x59, 0x85, 0x29, 0x59, 0x85, 0x29, 0x59, 0x85, 0x29, 0x59, 0x85, 0x29, 0x59, 0x85, 0x29, 0x59, 0x85, 0x29, 0x59, 0x85, 0x29, 0x59, 0x85, 0x29, 0x59, 0x84, 0x29, 0x58, 0x84, 0x29, 0x58, 0x84, 0x28, 0x58, 0x84,
          0x28, 0x58, 0x84, 0x28, 0x58, 0x84, 0x28, 0x57, 0x83, 0x28, 0x57, 0x83, 0x28, 0x57, 0x83, 0x28, 0x57, 0x82, 0x27, 0x57, 0x82, 0x27, 0x56, 0x82, 0x27, 0x56, 0x82, 0x26, 0x56, 0x81, 0x26, 0x55, 0x81, 0x26, 0x55, 0x81, 0x26, 0x55, 0x80,
          0x25, 0x54, 0x80, 0x25, 0x54, 0x7F, 0x25, 0x53, 0x7F, 0x25, 0x53, 0x7E, 0x24, 0x53, 0x7E, 0x24, 0x52, 0x7E, 0x24, 0x52, 0x7D, 0x23, 0x52, 0x7D, 0x23, 0x51, 0x7C, 0x23, 0x51, 0x7C, 0x22, 0x50, 0x7B, 0x22, 0x50, 0x7B, 0x21, 0x4F, 0x7A,
          0x21, 0x4F, 0x7A, 0x21, 0x4F, 0x79, 0x20, 0x4E, 0x79, 0x20, 0x4E, 0x78, 0x20, 0x4D, 0x78, 0x1F, 0x4D, 0x78, 0x1F, 0x4C, 0x77, 0x1F, 0x4C, 0x76, 0x1E, 0x4C, 0x76, 0x1E, 0x4B, 0x76, 0x1E, 0x4B, 0x75, 0x1D, 0x4A, 0x75, 0x1D, 0x4A, 0x74,
          0x1D, 0x49, 0x74, 0x1C, 0x49, 0x73, 0x1C, 0x49, 0x73, 0x1C, 0x48, 0x72, 0x1B, 0x48, 0x72, 0x1B, 0x47, 0x72, 0x1B, 0x47, 0x71, 0x1B, 0x47, 0x71, 0x1A, 0x46, 0x71, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70,
          0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70,
    0x2A, 0x5A, 0x86, 0x2A, 0x5A, 0x86, 0x2A, 0x5A, 0x86, 0x2A, 0x5A, 0x86, 0x2A, 0x5A, 0x86, 0x2A, 0x5A, 0x86, 0x2A, 0x5A, 0x86, 0x2A, 0x5A, 0x86, 0x2A, 0x5A, 0x86, 0x2A, 0x5A, 0x85, 0x29, 0x59, 0x85, 0x29, 0x59, 0x85, 0x29, 0x59, 0x85, 0x29, 0x59, 0x85,
          0x29, 0x59, 0x85, 0x29, 0x59, 0x84, 0x29, 0x58, 0x84, 0x28, 0x58, 0x84, 0x28, 0x58, 0x84, 0x28, 0x58, 0x83, 0x28, 0x57, 0x83, 0x28, 0x57, 0x83, 0x27, 0x57, 0x83, 0x27, 0x56, 0x82, 0x27, 0x56, 0x82, 0x27, 0x56, 0x81, 0x26, 0x56, 0x81,
          0x26, 0x55, 0x81, 0x26, 0x55, 0x80, 0x25, 0x54, 0x80, 0x25, 0x54, 0x7F, 0x25, 0x53, 0x7F, 0x24, 0x53, 0x7E, 0x24, 0x53, 0x7E, 0x24, 0x52, 0x7D, 0x23, 0x52, 0x7D, 0x23, 0x51, 0x7D, 0x23, 0x51, 0x7C, 0x22, 0x50, 0x7C, 0x22, 0x50, 0x7B,
          0x22, 0x50, 0x7B, 0x21, 0x4F, 0x7A, 0x21, 0x4F, 0x7A, 0x20, 0x4E, 0x79, 0x20, 0x4E, 0x79, 0x20, 0x4D, 0x78, 0x1F, 0x4D, 0x77, 0x1F, 0x4C, 0x77, 0x1F, 0x4C, 0x77, 0x1E, 0x4C, 0x76, 0x1E, 0x4B, 0x75, 0x1E, 0x4B, 0x75, 0x1D, 0x4A, 0x75,
          0x1D, 0x4A, 0x74, 0x1D, 0x49, 0x74, 0x1C, 0x49, 0x73, 0x1C, 0x49, 0x73, 0x1C, 0x48, 0x72, 0x1B, 0x48, 0x72, 0x1B, 0x47, 0x72, 0x1B, 0x47, 0x71, 0x1B, 0x47, 0x71, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70,
          0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70,
    0x2A, 0x5B, 0x87, 0x2B, 0x5B, 0x87, 0x2A, 0x5B, 0x87, 0x2B, 0x5B, 0x87, 0x2B, 0x5B, 0x87, 0x2A, 0x5B, 0x87, 0x2A, 0x5B, 0x87, 0x2A, 0x5B, 0x87, 0x2A, 0x5B, 0x87, 0x2A, 0x5A, 0x86, 0x2A, 0x5A, 0x86, 0x2A, 0x5A, 0x86, 0x2A, 0x5A, 0x86, 0x2A, 0x5A, 0x86,
          0x2A, 0x5A, 0x86, 0x2A, 0x5A, 0x86, 0x29, 0x59, 0x85, 0x29, 0x59, 0x85, 0x29, 0x59, 0x85, 0x29, 0x58, 0x84, 0x28, 0x58, 0x84, 0x28, 0x58, 0x84, 0x28, 0x58, 0x83, 0x28, 0x57, 0x83, 0x28, 0x57, 0x83, 0x27, 0x57, 0x82, 0x27, 0x56, 0x82,
          0x27, 0x56, 0x81, 0x26, 0x55, 0x81, 0x26, 0x55, 0x80, 0x26, 0x55, 0x80, 0x25, 0x54, 0x80, 0x25, 0x54, 0x7F, 0x25, 0x53, 0x7F, 0x24, 0x53, 0x7E, 0x24, 0x53, 0x7E, 0x24, 0x52, 0x7D, 0x23, 0x51, 0x7D, 0x23, 0x51, 0x7C, 0x23, 0x51, 0x7C,
          0x22, 0x50, 0x7B, 0x22, 0x50, 0x7B, 0x21, 0x4F, 0x7A, 0x21, 0x4F, 0x7A, 0x21, 0x4E, 0x79, 0x20, 0x4E, 0x79, 0x20, 0x4D, 0x78, 0x1F, 0x4D, 0x78, 0x1F, 0x4C, 0x77, 0x1F, 0x4C, 0x76, 0x1E, 0x4C, 0x76, 0x1E, 0x4B, 0x76, 0x1E, 0x4B, 0x75,
          0x1D, 0x4A, 0x75, 0x1D, 0x4A, 0x74, 0x1D, 0x49, 0x74, 0x1C, 0x49, 0x73, 0x1C, 0x48, 0x73, 0x1C, 0x48, 0x72, 0x1C, 0x48, 0x72, 0x1B, 0x47, 0x72, 0x1B, 0x47, 0x71, 0x1B, 0x47, 0x71, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70,
          0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70,
    0x2B, 0x5B, 0x88, 0x2B, 0x5C, 0x88, 0x2B, 0x5C, 0x88, 0x2B, 0x5C, 0x88, 0x2B, 0x5C, 0x88, 0x2B, 0x5C, 0x88, 0x2B, 0x5C, 0x88, 0x2B, 0x5C, 0x88, 0x2B, 0x5B, 0x88, 0x2B, 0x5B, 0x87, 0x2B, 0x5B, 0x87, 0x2B, 0x5B, 0x87, 0x2B, 0x5B, 0x87, 0x2A, 0x5B, 0x87,
          0x2A, 0x5A, 0x87, 0x2A, 0x5A, 0x87, 0x2A, 0x5A, 0x86, 0x2A, 0x5A, 0x86, 0x2A, 0x5A, 0x86, 0x29, 0x59, 0x85, 0x29, 0x59, 0x85, 0x29, 0x59, 0x85, 0x29, 0x58, 0x84, 0x28, 0x58, 0x84, 0x28, 0x58, 0x84, 0x28, 0x57, 0x83, 0x28, 0x57, 0x83,
          0x27, 0x57, 0x82, 0x27, 0x56, 0x82, 0x27, 0x56, 0x81, 0x26, 0x55, 0x81, 0x26, 0x55, 0x81, 0x26, 0x55, 0x80, 0x25, 0x54, 0x80, 0x25, 0x54, 0x7F, 0x24, 0x53, 0x7F, 0x24, 0x53, 0x7E, 0x24, 0x52, 0x7D, 0x23, 0x52, 0x7D, 0x23, 0x51, 0x7C,
          0x23, 0x51, 0x7C, 0x22, 0x50, 0x7B, 0x22, 0x50, 0x7B, 0x21, 0x4F, 0x7A, 0x21, 0x4F, 0x7A, 0x21, 0x4E, 0x79, 0x20, 0x4E, 0x79, 0x20, 0x4D, 0x78, 0x20, 0x4D, 0x78, 0x1F, 0x4C, 0x77, 0x1F, 0x4C, 0x77, 0x1E, 0x4C, 0x76, 0x1E, 0x4B, 0x76,
          0x1E, 0x4B, 0x75, 0x1D, 0x4A, 0x75, 0x1D, 0x4A, 0x74, 0x1D, 0x49, 0x74, 0x1C, 0x49, 0x73, 0x1C, 0x49, 0x73, 0x1C, 0x48, 0x72, 0x1B, 0x48, 0x72, 0x1B, 0x47, 0x71, 0x1B, 0x47, 0x71, 0x1B, 0x47, 0x71, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70,
          0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70,
    0x2C, 0x5C, 0x89, 0x2C, 0x5D, 0x89, 0x2C, 0x5D, 0x89, 0x2C, 0x5D, 0x89, 0x2C, 0x5D, 0x89, 0x2C, 0x5D, 0x89, 0x2C, 0x5D, 0x89, 0x2C, 0x5C, 0x89, 0x2C, 0x5C, 0x89, 0x2C, 0x5C, 0x88, 0x2C, 0x5C, 0x88, 0x2C, 0x5C, 0x88, 0x2B, 0x5C, 0x88, 0x2B, 0x5C, 0x88,
          0x2B, 0x5B, 0x88, 0x2B, 0x5B, 0x87, 0x2B, 0x5B, 0x87, 0x2B, 0x5B, 0x87, 0x2A, 0x5B, 0x87, 0x2A, 0x5A, 0x86, 0x2A, 0x5A, 0x86, 0x2A, 0x5A, 0x86, 0x29, 0x59, 0x85, 0x29, 0x59, 0x85, 0x29, 0x59, 0x85, 0x29, 0x58, 0x84, 0x28, 0x58, 0x84,
          0x28, 0x57, 0x83, 0x28, 0x57, 0x83, 0x27, 0x57, 0x82, 0x27, 0x56, 0x82, 0x27, 0x56, 0x81, 0x26, 0x55, 0x81, 0x26, 0x55, 0x80, 0x26, 0x54, 0x80, 0x25, 0x54, 0x7F, 0x25, 0x53, 0x7F, 0x24, 0x53, 0x7E, 0x24, 0x52, 0x7E, 0x24, 0x52, 0x7D,
          0x23, 0x51, 0x7D, 0x23, 0x51, 0x7C, 0x22, 0x50, 0x7C, 0x22, 0x50, 0x7B, 0x22, 0x4F, 0x7A, 0x21, 0x4F, 0x7A, 0x21, 0x4E, 0x79, 0x20, 0x4E, 0x79, 0x20, 0x4E, 0x78, 0x20, 0x4D, 0x78, 0x1F, 0x4C, 0x77, 0x1F, 0x4C, 0x77, 0x1E, 0x4C, 0x76,
          0x1E, 0x4B, 0x76, 0x1E, 0x4B, 0x75, 0x1D, 0x4A, 0x75, 0x1D, 0x4A, 0x74, 0x1D, 0x49, 0x74, 0x1C, 0x49, 0x73, 0x1C, 0x49, 0x73, 0x1C, 0x48, 0x72, 0x1B, 0x48, 0x72, 0x1B, 0x47, 0x71, 0x1B, 0x47, 0x71, 0x1B, 0x47, 0x71, 0x1A, 0x46, 0x70,
          0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70,
    0x2D, 0x5D, 0x8A, 0x2D, 0x5D, 0x8A, 0x2D, 0x5D, 0x8A, 0x2D, 0x5E, 0x8A, 0x2D, 0x5D, 0x8A, 0x2D, 0x5D, 0x8A, 0x2D, 0x5D, 0x8A, 0x2D, 0x5D, 0x8A, 0x2C, 0x5D, 0x8A, 0x2C, 0x5D, 0x8A, 0x2C, 0x5D, 0x89, 0x2C, 0x5D, 0x89, 0x2C, 0x5D, 0x89, 0x2C, 0x5D, 0x89,
          0x2C, 0x5C, 0x89, 0x2C, 0x5C, 0x88, 0x2B, 0x5C, 0x88, 0x2B, 0x5C, 0x88, 0x2B, 0x5B, 0x88, 0x2B, 0x5B, 0x87, 0x2B, 0x5B, 0x87, 0x2A, 0x5A, 0x87, 0x2A, 0x5A, 0x86, 0x2A, 0x5A, 0x86, 0x29, 0x5A, 0x85, 0x29, 0x59, 0x85, 0x29, 0x59, 0x85,
          0x28, 0x58, 0x84, 0x28, 0x58, 0x84, 0x28, 0x57, 0x83, 0x27, 0x57, 0x83, 0x27, 0x56, 0x82, 0x27, 0x56, 0x82, 0x26, 0x55, 0x81, 0x26, 0x55, 0x81, 0x26, 0x55, 0x80, 0x25, 0x54, 0x7F, 0x25, 0x53, 0x7F, 0x24, 0x53, 0x7F, 0x24, 0x53, 0x7E,
          0x24, 0x52, 0x7D, 0x23, 0x51, 0x7D, 0x23, 0x51, 0x7C, 0x22, 0x51, 0x7C, 0x22, 0x50, 0x7B, 0x22, 0x50, 0x7A, 0x21, 0x4F, 0x7A, 0x21, 0x4E, 0x79, 0x20, 0x4E, 0x79, 0x20, 0x4E, 0x78, 0x20, 0x4D, 0x78, 0x1F, 0x4C, 0x77, 0x1F, 0x4C, 0x77,
          0x1E, 0x4C, 0x76, 0x1E, 0x4B, 0x76, 0x1E, 0x4A, 0x75, 0x1D, 0x4A, 0x75, 0x1D, 0x4A, 0x74, 0x1C, 0x49, 0x74, 0x1C, 0x49, 0x73, 0x1C, 0x48, 0x73, 0x1C, 0x48, 0x72, 0x1B, 0x48, 0x72, 0x1B, 0x47, 0x71, 0x1B, 0x47, 0x71, 0x1A, 0x46, 0x71,
          0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70,
    0x2D, 0x5E, 0x8B, 0x2D, 0x5E, 0x8B, 0x2D, 0x5E, 0x8B, 0x2D, 0x5F, 0x8B, 0x2D, 0x5F, 0x8B, 0x2D, 0x5E, 0x8B, 0x2D, 0x5E, 0x8B, 0x2D, 0x5E, 0x8B, 0x2D, 0x5E, 0x8B, 0x2D, 0x5E, 0x8B, 0x2D, 0x5E, 0x8A, 0x2D, 0x5E, 0x8A, 0x2D, 0x5E, 0x8A, 0x2D, 0x5E, 0x8A,
          0x2D, 0x5D, 0x8A, 0x2C, 0x5D, 0x8A, 0x2C, 0x5D, 0x89, 0x2C, 0x5D, 0x89, 0x2C, 0x5C, 0x88, 0x2C, 0x5C, 0x88, 0x2B, 0x5C, 0x88, 0x2B, 0x5B, 0x87, 0x2B, 0x5B, 0x87, 0x2A, 0x5B, 0x87, 0x2A, 0x5A, 0x86, 0x2A, 0x5A, 0x86, 0x2A, 0x59, 0x85,
          0x29, 0x59, 0x85, 0x29, 0x59, 0x84, 0x28, 0x58, 0x84, 0x28, 0x58, 0x84, 0x28, 0x57, 0x83, 0x27, 0x57, 0x83, 0x27, 0x56, 0x82, 0x27, 0x56, 0x81, 0x26, 0x55, 0x81, 0x26, 0x55, 0x80, 0x25, 0x54, 0x80, 0x25, 0x54, 0x7F, 0x25, 0x53, 0x7F,
          0x24, 0x53, 0x7E, 0x24, 0x52, 0x7D, 0x23, 0x52, 0x7D, 0x23, 0x51, 0x7C, 0x22, 0x51, 0x7C, 0x22, 0x50, 0x7B, 0x22, 0x50, 0x7A, 0x21, 0x4F, 0x7A, 0x21, 0x4E, 0x79, 0x20, 0x4E, 0x79, 0x20, 0x4D, 0x78, 0x1F, 0x4D, 0x78, 0x1F, 0x4C, 0x77,
          0x1F, 0x4C, 0x77, 0x1E, 0x4C, 0x76, 0x1E, 0x4B, 0x75, 0x1E, 0x4A, 0x75, 0x1D, 0x4A, 0x74, 0x1D, 0x4A, 0x74, 0x1D, 0x49, 0x74, 0x1C, 0x49, 0x73, 0x1C, 0x48, 0x72, 0x1B, 0x48, 0x72, 0x1B, 0x47, 0x72, 0x1B, 0x47, 0x71, 0x1B, 0x47, 0x71,
          0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70,
    0x2E, 0x5F, 0x8C, 0x2E, 0x5F, 0x8C, 0x2E, 0x5F, 0x8C, 0x2E, 0x5F, 0x8C, 0x2E, 0x5F, 0x8C, 0x2E, 0x5F, 0x8C, 0x2E, 0x5F, 0x8C, 0x2E, 0x5F, 0x8C, 0x2E, 0x5F, 0x8C, 0x2E, 0x5F, 0x8C, 0x2E, 0x5F, 0x8C, 0x2E, 0x5F, 0x8B, 0x2E, 0x5F, 0x8B, 0x2D, 0x5E, 0x8B,
          0x2D, 0x5E, 0x8B, 0x2D, 0x5E, 0x8A, 0x2D, 0x5E, 0x8A, 0x2D, 0x5E, 0x8A, 0x2C, 0x5D, 0x8A, 0x2C, 0x5D, 0x89, 0x2C, 0x5C, 0x89, 0x2C, 0x5C, 0x88, 0x2B, 0x5C, 0x88, 0x2B, 0x5B, 0x88, 0x2B, 0x5B, 0x87, 0x2A, 0x5B, 0x87, 0x2A, 0x5A, 0x86,
          0x2A, 0x5A, 0x86, 0x29, 0x59, 0x85, 0x29, 0x59, 0x85, 0x29, 0x58, 0x84, 0x28, 0x58, 0x84, 0x28, 0x57, 0x83, 0x28, 0x57, 0x83, 0x27, 0x57, 0x82, 0x27, 0x56, 0x82, 0x26, 0x55, 0x81, 0x26, 0x55, 0x80, 0x25, 0x54, 0x80, 0x25, 0x54, 0x7F,
          0x25, 0x53, 0x7F, 0x24, 0x53, 0x7E, 0x24, 0x52, 0x7E, 0x23, 0x52, 0x7D, 0x23, 0x51, 0x7C, 0x23, 0x51, 0x7C, 0x22, 0x50, 0x7B, 0x22, 0x50, 0x7A, 0x21, 0x4F, 0x7A, 0x21, 0x4E, 0x79, 0x20, 0x4E, 0x79, 0x20, 0x4D, 0x78, 0x20, 0x4D, 0x78,
          0x1F, 0x4C, 0x77, 0x1F, 0x4C, 0x76, 0x1E, 0x4B, 0x76, 0x1E, 0x4B, 0x75, 0x1E, 0x4A, 0x75, 0x1D, 0x4A, 0x74, 0x1D, 0x4A, 0x74, 0x1C, 0x49, 0x73, 0x1C, 0x49, 0x73, 0x1C, 0x48, 0x72, 0x1B, 0x48, 0x72, 0x1B, 0x47, 0x72, 0x1B, 0x47, 0x71,
          0x1B, 0x47, 0x71, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70,
    0x2F, 0x60, 0x8D, 0x2F, 0x60, 0x8D, 0x2F, 0x60, 0x8D, 0x2F, 0x60, 0x8D, 0x2F, 0x60, 0x8D, 0x2F, 0x60, 0x8D, 0x2F, 0x60, 0x8D, 0x2F, 0x60, 0x8D, 0x2F, 0x60, 0x8D, 0x2F, 0x60, 0x8D, 0x2F, 0x60, 0x8C, 0x2E, 0x60, 0x8C, 0x2E, 0x60, 0x8C, 0x2E, 0x5F, 0x8C,
          0x2E, 0x5F, 0x8C, 0x2E, 0x5F, 0x8B, 0x2D, 0x5F, 0x8B, 0x2D, 0x5E, 0x8B, 0x2D, 0x5E, 0x8A, 0x2D, 0x5E, 0x8A, 0x2D, 0x5D, 0x8A, 0x2C, 0x5D, 0x89, 0x2C, 0x5D, 0x89, 0x2C, 0x5C, 0x88, 0x2B, 0x5C, 0x88, 0x2B, 0x5B, 0x88, 0x2B, 0x5B, 0x87,
          0x2A, 0x5B, 0x87, 0x2A, 0x5A, 0x86, 0x2A, 0x5A, 0x86, 0x29, 0x59, 0x85, 0x29, 0x59, 0x85, 0x29, 0x58, 0x84, 0x28, 0x58, 0x83, 0x28, 0x57, 0x83, 0x27, 0x57, 0x82, 0x27, 0x56, 0x82, 0x26, 0x56, 0x81, 0x26, 0x55, 0x81, 0x25, 0x54, 0x80,
          0x25, 0x54, 0x7F, 0x25, 0x53, 0x7F, 0x24, 0x53, 0x7E, 0x24, 0x52, 0x7E, 0x23, 0x52, 0x7D, 0x23, 0x51, 0x7C, 0x22, 0x51, 0x7C, 0x22, 0x50, 0x7B, 0x22, 0x50, 0x7A, 0x21, 0x4F, 0x7A, 0x21, 0x4E, 0x79, 0x20, 0x4E, 0x79, 0x20, 0x4D, 0x78,
          0x1F, 0x4D, 0x78, 0x1F, 0x4C, 0x77, 0x1F, 0x4C, 0x76, 0x1E, 0x4B, 0x76, 0x1E, 0x4B, 0x75, 0x1D, 0x4A, 0x75, 0x1D, 0x4A, 0x74, 0x1D, 0x49, 0x74, 0x1C, 0x49, 0x73, 0x1C, 0x48, 0x73, 0x1C, 0x48, 0x72, 0x1B, 0x48, 0x72, 0x1B, 0x47, 0x71,
          0x1B, 0x47, 0x71, 0x1A, 0x47, 0x71, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70,
    0x30, 0x61, 0x8E, 0x30, 0x61, 0x8E, 0x30, 0x61, 0x8E, 0x30, 0x61, 0x8E, 0x30, 0x61, 0x8E, 0x30, 0x61, 0x8E, 0x30, 0x61, 0x8E, 0x30, 0x61, 0x8E, 0x30, 0x61, 0x8E, 0x2F, 0x61, 0x8E, 0x2F, 0x61, 0x8E, 0x2F, 0x61, 0x8D, 0x2F, 0x60, 0x8D, 0x2F, 0x60, 0x8D,
          0x2F, 0x60, 0x8D, 0x2E, 0x60, 0x8C, 0x2E, 0x5F, 0x8C, 0x2E, 0x5F, 0x8C, 0x2E, 0x5F, 0x8B, 0x2D, 0x5F, 0x8B, 0x2D, 0x5E, 0x8B, 0x2D, 0x5E, 0x8A, 0x2D, 0x5D, 0x8A, 0x2C, 0x5D, 0x89, 0x2C, 0x5D, 0x89, 0x2C, 0x5C, 0x88, 0x2B, 0x5C, 0x88,
          0x2B, 0x5B, 0x88, 0x2B, 0x5B, 0x87, 0x2A, 0x5A, 0x87, 0x2A, 0x5A, 0x86, 0x2A, 0x5A, 0x85, 0x29, 0x59, 0x85, 0x29, 0x58, 0x84, 0x28, 0x58, 0x84, 0x28, 0x57, 0x83, 0x27, 0x57, 0x82, 0x27, 0x56, 0x82, 0x27, 0x56, 0x81, 0x26, 0x55, 0x81,
          0x26, 0x55, 0x80, 0x25, 0x54, 0x7F, 0x25, 0x53, 0x7F, 0x24, 0x53, 0x7E, 0x24, 0x52, 0x7E, 0x23, 0x52, 0x7D, 0x23, 0x51, 0x7C, 0x22, 0x51, 0x7C, 0x22, 0x50, 0x7B, 0x22, 0x4F, 0x7A, 0x21, 0x4F, 0x7A, 0x21, 0x4E, 0x79, 0x20, 0x4E, 0x79,
          0x20, 0x4D, 0x78, 0x1F, 0x4D, 0x77, 0x1F, 0x4C, 0x77, 0x1F, 0x4C, 0x76, 0x1E, 0x4B, 0x76, 0x1E, 0x4B, 0x75, 0x1D, 0x4A, 0x75, 0x1D, 0x4A, 0x74, 0x1C, 0x49, 0x74, 0x1C, 0x49, 0x73, 0x1C, 0x48, 0x73, 0x1C, 0x48, 0x72, 0x1B, 0x48, 0x72,
          0x1B, 0x47, 0x71, 0x1B, 0x47, 0x71, 0x1A, 0x46, 0x70, 0x1A, 0x46, 0x70,
    0x30, 0x62, 0x8F, 0x30, 0x62, 0x8F, 0x31, 0x62, 0x8F, 0x31, 0x62, 0x8F, 0x30, 0x62, 0x8F, 0x30, 0x62, 0x8F, 0x30, 0x62, 0x8F, 0x30, 0x62, 0x8F, 0x30, 0x62, 0x8F, 0x30, 0x62, 0x8F, 0x30, 0x62, 0x8F, 0x30, 0x62, 0x8E, 0x30, 0x61, 0x8E, 0x30, 0x61, 0x8E,
          0x2F, 0x61, 0x8E, 0x2F, 0x61, 0x8D, 0x2F, 0x60, 0x8D, 0x2F, 0x60, 0x8D, 0x2F, 0x60, 0x8C, 0x2E, 0x5F, 0x8C, 0x2E, 0x5F, 0x8C, 0x2E, 0x5F, 0x8B, 0x2D, 0x5E, 0x8B, 0x2D, 0x5E, 0x8A, 0x2D, 0x5E, 0x8A, 0x2C, 0x5D, 0x89, 0x2C, 0x5D, 0x89,
          0x2C, 0x5C, 0x88, 0x2B, 0x5C, 0x88, 0x2B, 0x5B, 0x87, 0x2B, 0x5B, 0x87, 0x2A, 0x5A, 0x86, 0x2A, 0x5A, 0x86, 0x29, 0x59, 0x85, 0x29, 0x59, 0x85, 0x28, 0x58, 0x84, 0x28, 0x58, 0x83, 0x27, 0x57, 0x83, 0x27, 0x56, 0x82, 0x27, 0x56, 0x81,
          0x26, 0x55, 0x81, 0x26, 0x55, 0x80, 0x25, 0x54, 0x80, 0x25, 0x54, 0x7F, 0x24, 0x53, 0x7E, 0x24, 0x52, 0x7E, 0x23, 0x52, 0x7D, 0x23, 0x51, 0x7C, 0x22, 0x51, 0x7C, 0x22, 0x50, 0x7B, 0x22, 0x4F, 0x7A, 0x21, 0x4F, 0x7A, 0x21, 0x4E, 0x79,
          0x20, 0x4E, 0x78, 0x20, 0x4D, 0x78, 0x1F, 0x4D, 0x77, 0x1F, 0x4C, 0x77, 0x1E, 0x4C, 0x76, 0x1E, 0x4B, 0x75, 0x1E, 0x4B, 0x75, 0x1D, 0x4A, 0x74, 0x1D, 0x49, 0x74, 0x1D, 0x49, 0x73, 0x1C, 0x49, 0x73, 0x1C, 0x48, 0x72, 0x1B, 0x48, 0x72,
          0x1B, 0x47, 0x72, 0x1B, 0x47, 0x71, 0x1B, 0x47, 0x71, 0x1A, 0x46, 0x70,
    0x31, 0x63, 0x90, 0x31, 0x63, 0x90, 0x31, 0x63, 0x90, 0x31, 0x63, 0x90, 0x31, 0x63, 0x90, 0x31, 0x63, 0x90, 0x31, 0x63, 0x90, 0x31, 0x63, 0x90, 0x31, 0x63, 0x90, 0x31, 0x63, 0x90, 0x31, 0x63, 0x90, 0x31, 0x63, 0x8F, 0x30, 0x62, 0x8F, 0x31, 0x62, 0x8F,
          0x30, 0x62, 0x8F, 0x30, 0x62, 0x8E, 0x30, 0x61, 0x8E, 0x30, 0x61, 0x8E, 0x2F, 0x61, 0x8D, 0x2F, 0x60, 0x8D, 0x2F, 0x60, 0x8D, 0x2E, 0x60, 0x8C, 0x2E, 0x5F, 0x8C, 0x2E, 0x5F, 0x8B, 0x2D, 0x5E, 0x8B, 0x2D, 0x5E, 0x8A, 0x2D, 0x5D, 0x8A,
          0x2C, 0x5D, 0x89, 0x2C, 0x5C, 0x89, 0x2C, 0x5C, 0x88, 0x2B, 0x5C, 0x88, 0x2B, 0x5B, 0x87, 0x2A, 0x5B, 0x87, 0x2A, 0x5A, 0x86, 0x29, 0x59, 0x85, 0x29, 0x59, 0x85, 0x28, 0x58, 0x84, 0x28, 0x58, 0x83, 0x28, 0x57, 0x83, 0x27, 0x56, 0x82,
          0x27, 0x56, 0x82, 0x26, 0x55, 0x81, 0x26, 0x55, 0x80, 0x25, 0x54, 0x7F, 0x25, 0x54, 0x7F, 0x24, 0x53, 0x7E, 0x24, 0x52, 0x7E, 0x23, 0x52, 0x7D, 0x23, 0x51, 0x7C, 0x22, 0x50, 0x7C, 0x22, 0x50, 0x7B, 0x21, 0x4F, 0x7A, 0x21, 0x4F, 0x7A,
          0x21, 0x4E, 0x79, 0x20, 0x4E, 0x78, 0x20, 0x4D, 0x78, 0x1F, 0x4C, 0x77, 0x1F, 0x4C, 0x76, 0x1E, 0x4B, 0x76, 0x1E, 0x4B, 0x75, 0x1D, 0x4A, 0x75, 0x1D, 0x4A, 0x74, 0x1D, 0x49, 0x74, 0x1C, 0x49, 0x73, 0x1C, 0x49, 0x73, 0x1C, 0x48, 0x72,
          0x1B, 0x48, 0x72, 0x1B, 0x47, 0x71, 0x1B, 0x47, 0x71, 0x1A, 0x46, 0x71,
    0x32, 0x64, 0x91, 0x32, 0x64, 0x91, 0x32, 0x64, 0x91, 0x32, 0x64, 0x91, 0x32, 0x64, 0x91, 0x32, 0x64, 0x91, 0x32, 0x64, 0x91, 0x32, 0x64, 0x91, 0x32, 0x64, 0x91, 0x32, 0x64, 0x91, 0x32, 0x63, 0x91, 0x31, 0x63, 0x90, 0x31, 0x63, 0x90, 0x31, 0x63, 0x90,
          0x31, 0x63, 0x90, 0x31, 0x62, 0x90, 0x31, 0x62, 0x8F, 0x30, 0x62, 0x8F, 0x30, 0x62, 0x8F, 0x30, 0x61, 0x8E, 0x2F, 0x61, 0x8E, 0x2F, 0x60, 0x8D, 0x2F, 0x60, 0x8D, 0x2E, 0x60, 0x8C, 0x2E, 0x5F, 0x8C, 0x2E, 0x5F, 0x8B, 0x2D, 0x5E, 0x8B,
          0x2D, 0x5E, 0x8A, 0x2D, 0x5D, 0x8A, 0x2C, 0x5D, 0x89, 0x2C, 0x5C, 0x88, 0x2B, 0x5C, 0x88, 0x2B, 0x5B, 0x87, 0x2A, 0x5B, 0x87, 0x2A, 0x5A, 0x86, 0x2A, 0x5A, 0x85, 0x29, 0x59, 0x85, 0x29, 0x58, 0x84, 0x28, 0x58, 0x84, 0x28, 0x57, 0x83,
          0x27, 0x57, 0x82, 0x27, 0x56, 0x81, 0x26, 0x55, 0x81, 0x26, 0x55, 0x80, 0x25, 0x54, 0x80, 0x25, 0x53, 0x7F, 0x24, 0x53, 0x7E, 0x24, 0x52, 0x7D, 0x23, 0x52, 0x7D, 0x23, 0x51, 0x7C, 0x22, 0x50, 0x7B, 0x22, 0x50, 0x7B, 0x21, 0x4F, 0x7A,
          0x21, 0x4F, 0x7A, 0x20, 0x4E, 0x79, 0x20, 0x4E, 0x78, 0x1F, 0x4D, 0x78, 0x1F, 0x4C, 0x77, 0x1F, 0x4C, 0x76, 0x1E, 0x4B, 0x76, 0x1E, 0x4B, 0x75, 0x1D, 0x4A, 0x75, 0x1D, 0x4A, 0x74, 0x1D, 0x49, 0x74, 0x1C, 0x49, 0x73, 0x1C, 0x48, 0x73,
          0x1C, 0x48, 0x72, 0x1B, 0x47, 0x72, 0x1B, 0x47, 0x71, 0x1B, 0x47, 0x71,
    0x33, 0x65, 0x92, 0x33, 0x65, 0x92, 0x33, 0x65, 0x92, 0x33, 0x65, 0x92, 0x33, 0x65, 0x92, 0x33, 0x65, 0x92, 0x33, 0x65, 0x92, 0x33, 0x65, 0x92, 0x33, 0x65, 0x92, 0x32, 0x65, 0x92, 0x32, 0x64, 0x92, 0x32, 0x64, 0x91, 0x32, 0x64, 0x91, 0x32, 0x64, 0x91,
          0x32, 0x64, 0x91, 0x31, 0x63, 0x90, 0x31, 0x63, 0x90, 0x31, 0x63, 0x90, 0x31, 0x62, 0x8F, 0x30, 0x62, 0x8F, 0x30, 0x62, 0x8F, 0x30, 0x61, 0x8E, 0x2F, 0x61, 0x8E, 0x2F, 0x61, 0x8D, 0x2F, 0x60, 0x8D, 0x2E, 0x60, 0x8C, 0x2E, 0x5F, 0x8C,
          0x2E, 0x5F, 0x8B, 0x2D, 0x5E, 0x8A, 0x2D, 0x5E, 0x8A, 0x2C, 0x5D, 0x89, 0x2C, 0x5D, 0x89, 0x2C, 0x5C, 0x88, 0x2B, 0x5B, 0x88, 0x2B, 0x5B, 0x87, 0x2A, 0x5A, 0x86, 0x29, 0x5A, 0x86, 0x29, 0x59, 0x85, 0x29, 0x58, 0x84, 0x28, 0x58, 0x84,
          0x28, 0x57, 0x83, 0x27, 0x57, 0x82, 0x27, 0x56, 0x82, 0x26, 0x55, 0x81, 0x26, 0x55, 0x80, 0x25, 0x54, 0x7F, 0x25, 0x53, 0x7F, 0x24, 0x53, 0x7E, 0x24, 0x52, 0x7D, 0x23, 0x52, 0x7D, 0x23, 0x51, 0x7C, 0x22, 0x50, 0x7B, 0x22, 0x50, 0x7B,
          0x21, 0x4F, 0x7A, 0x21, 0x4F, 0x79, 0x20, 0x4E, 0x79, 0x20, 0x4D, 0x78, 0x1F, 0x4D, 0x77, 0x1F, 0x4C, 0x77, 0x1F, 0x4C, 0x76, 0x1E, 0x4B, 0x76, 0x1E, 0x4B, 0x75, 0x1D, 0x4A, 0x75, 0x1D, 0x4A, 0x74, 0x1D, 0x49, 0x73, 0x1C, 0x49, 0x73,
          0x1C, 0x48, 0x72, 0x1B, 0x48, 0x72, 0x1B, 0x47, 0x71, 0x1B, 0x47, 0x71,
    0x33, 0x66, 0x93, 0x33, 0x66, 0x93, 0x34, 0x66, 0x93, 0x33, 0x66, 0x93, 0x34, 0x66, 0x93, 0x34, 0x66, 0x93, 0x33, 0x66, 0x93, 0x33, 0x66, 0x93, 0x33, 0x66, 0x93, 0x33, 0x66, 0x93, 0x33, 0x66, 0x93, 0x33, 0x65, 0x92, 0x33, 0x65, 0x92, 0x33, 0x65, 0x92,
          0x32, 0x65, 0x92, 0x32, 0x64, 0x91, 0x32, 0x64, 0x91, 0x32, 0x64, 0x91, 0x32, 0x63, 0x90, 0x31, 0x63, 0x90, 0x31, 0x63, 0x8F, 0x30, 0x62, 0x8F, 0x30, 0x62, 0x8E, 0x30, 0x61, 0x8E, 0x2F, 0x61, 0x8E, 0x2F, 0x60, 0x8D, 0x2F, 0x60, 0x8C,
          0x2E, 0x5F, 0x8C, 0x2E, 0x5F, 0x8B, 0x2D, 0x5E, 0x8B, 0x2D, 0x5E, 0x8A, 0x2D, 0x5D, 0x89, 0x2C, 0x5D, 0x89, 0x2C, 0x5C, 0x88, 0x2B, 0x5B, 0x88, 0x2B, 0x5B, 0x87, 0x2A, 0x5A, 0x86, 0x2A, 0x5A, 0x86, 0x29, 0x59, 0x85, 0x29, 0x58, 0x84,
          0x28, 0x58, 0x84, 0x28, 0x57, 0x83, 0x27, 0x56, 0x82, 0x27, 0x56, 0x82, 0x26, 0x55, 0x81, 0x26, 0x55, 0x80, 0x25, 0x54, 0x7F, 0x25, 0x53, 0x7F, 0x24, 0x53, 0x7E, 0x24, 0x52, 0x7D, 0x23, 0x51, 0x7C, 0x23, 0x51, 0x7C, 0x22, 0x50, 0x7B,
          0x22, 0x4F, 0x7B, 0x21, 0x4F, 0x7A, 0x21, 0x4E, 0x79, 0x20, 0x4E, 0x79, 0x20, 0x4D, 0x78, 0x1F, 0x4D, 0x77, 0x1F, 0x4C, 0x77, 0x1E, 0x4B, 0x76, 0x1E, 0x4B, 0x75, 0x1E, 0x4A, 0x75, 0x1D, 0x4A, 0x74, 0x1D, 0x49, 0x74, 0x1C, 0x49, 0x73,
          0x1C, 0x48, 0x73, 0x1C, 0x48, 0x72, 0x1B, 0x48, 0x72, 0x1B, 0x47, 0x71,
    0x34, 0x67, 0x94, 0x34, 0x67, 0x94, 0x34, 0x67, 0x94, 0x34, 0x67, 0x94, 0x34, 0x67, 0x94, 0x34, 0x67, 0x94, 0x34, 0x67, 0x94, 0x34, 0x67, 0x94, 0x34, 0x67, 0x94, 0x34, 0x67, 0x94, 0x34, 0x66, 0x94, 0x34, 0x66, 0x93, 0x33, 0x66, 0x93, 0x33, 0x66, 0x93,
          0x33, 0x65, 0x93, 0x33, 0x65, 0x92, 0x33, 0x65, 0x92, 0x32, 0x65, 0x92, 0x32, 0x64, 0x91, 0x32, 0x64, 0x91, 0x32, 0x63, 0x90, 0x31, 0x63, 0x90, 0x31, 0x62, 0x8F, 0x30, 0x62, 0x8F, 0x30, 0x62, 0x8F, 0x30, 0x61, 0x8E, 0x2F, 0x61, 0x8D,
          0x2F, 0x60, 0x8D, 0x2E, 0x60, 0x8C, 0x2E, 0x5F, 0x8C, 0x2D, 0x5F, 0x8B, 0x2D, 0x5E, 0x8A, 0x2D, 0x5D, 0x8A, 0x2C, 0x5D, 0x89, 0x2C, 0x5C, 0x88, 0x2B, 0x5C, 0x88, 0x2B, 0x5B, 0x87, 0x2A, 0x5A, 0x86, 0x2A, 0x5A, 0x86, 0x29, 0x59, 0x85,
          0x29, 0x58, 0x84, 0x28, 0x58, 0x84, 0x28, 0x57, 0x83, 0x27, 0x56, 0x82, 0x27, 0x56, 0x81, 0x26, 0x55, 0x81, 0x25, 0x54, 0x80, 0x25, 0x54, 0x7F, 0x25, 0x53, 0x7E, 0x24, 0x53, 0x7E, 0x23, 0x52, 0x7D, 0x23, 0x51, 0x7C, 0x22, 0x51, 0x7C,
          0x22, 0x50, 0x7B, 0x21, 0x4F, 0x7A, 0x21, 0x4F, 0x7A, 0x20, 0x4E, 0x79, 0x20, 0x4D, 0x78, 0x20, 0x4D, 0x78, 0x1F, 0x4C, 0x77, 0x1F, 0x4C, 0x76, 0x1E, 0x4B, 0x76, 0x1E, 0x4B, 0x75, 0x1D, 0x4A, 0x75, 0x1D, 0x4A, 0x74, 0x1C, 0x49, 0x73,
          0x1C, 0x49, 0x73, 0x1C, 0x48, 0x72, 0x1B, 0x48, 0x72, 0x1B, 0x47, 0x71,
    0x35, 0x68, 0x95, 0x35, 0x68, 0x95, 0x35, 0x68, 0x95, 0x35, 0x68, 0x95, 0x35, 0x68, 0x95, 0x35, 0x68, 0x95, 0x35, 0x68, 0x95, 0x35, 0x68, 0x95, 0x35, 0x68, 0x95, 0x35, 0x67, 0x95, 0x34, 0x67, 0x95, 0x34, 0x67, 0x95, 0x34, 0x67, 0x94, 0x34, 0x67, 0x94,
          0x34, 0x66, 0x93, 0x34, 0x66, 0x93, 0x33, 0x66, 0x93, 0x33, 0x65, 0x93, 0x33, 0x65, 0x92, 0x33, 0x65, 0x92, 0x32, 0x64, 0x91, 0x32, 0x64, 0x91, 0x31, 0x63, 0x91, 0x31, 0x63, 0x90, 0x31, 0x62, 0x8F, 0x30, 0x62, 0x8F, 0x30, 0x61, 0x8E,
          0x2F, 0x61, 0x8E, 0x2F, 0x60, 0x8D, 0x2F, 0x60, 0x8C, 0x2E, 0x5F, 0x8C, 0x2E, 0x5F, 0x8B, 0x2D, 0x5E, 0x8A, 0x2D, 0x5E, 0x8A, 0x2C, 0x5D, 0x89, 0x2C, 0x5C, 0x88, 0x2B, 0x5C, 0x88, 0x2B, 0x5B, 0x87, 0x2A, 0x5A, 0x86, 0x2A, 0x5A, 0x86,
          0x29, 0x59, 0x85, 0x29, 0x58, 0x84, 0x28, 0x58, 0x83, 0x27, 0x57, 0x83, 0x27, 0x56, 0x82, 0x26, 0x56, 0x81, 0x26, 0x55, 0x81, 0x25, 0x54, 0x80, 0x25, 0x54, 0x7F, 0x24, 0x53, 0x7E, 0x24, 0x52, 0x7D, 0x23, 0x52, 0x7D, 0x23, 0x51, 0x7C,
          0x22, 0x50, 0x7B, 0x22, 0x50, 0x7B, 0x21, 0x4F, 0x7A, 0x21, 0x4E, 0x79, 0x20, 0x4E, 0x79, 0x20, 0x4D, 0x78, 0x1F, 0x4D, 0x77, 0x1F, 0x4C, 0x77, 0x1E, 0x4C, 0x76, 0x1E, 0x4B, 0x76, 0x1E, 0x4A, 0x75, 0x1D, 0x4A, 0x74, 0x1D, 0x49, 0x74,
          0x1C, 0x49, 0x73, 0x1C, 0x48, 0x73, 0x1C, 0x48, 0x72, 0x1B, 0x48, 0x72,
    0x36, 0x69, 0x96, 0x36, 0x69, 0x96, 0x36, 0x69, 0x96, 0x36, 0x69, 0x97, 0x36, 0x69, 0x96, 0x36, 0x69, 0x96, 0x36, 0x69, 0x96, 0x36, 0x69, 0x96, 0x35, 0x69, 0x96, 0x35, 0x68, 0x96, 0x35, 0x68, 0x96, 0x35, 0x68, 0x96, 0x35, 0x68, 0x95, 0x35, 0x68, 0x95,
          0x35, 0x67, 0x95, 0x34, 0x67, 0x94, 0x34, 0x67, 0x94, 0x34, 0x66, 0x94, 0x33, 0x66, 0x93, 0x33, 0x65, 0x93, 0x33, 0x65, 0x92, 0x32, 0x65, 0x92, 0x32, 0x64, 0x91, 0x32, 0x64, 0x91, 0x31, 0x63, 0x90, 0x31, 0x63, 0x90, 0x31, 0x62, 0x8F,
          0x30, 0x62, 0x8F, 0x30, 0x61, 0x8E, 0x2F, 0x61, 0x8D, 0x2F, 0x60, 0x8D, 0x2E, 0x5F, 0x8C, 0x2E, 0x5F, 0x8B, 0x2D, 0x5E, 0x8B, 0x2D, 0x5E, 0x8A, 0x2C, 0x5D, 0x89, 0x2C, 0x5C, 0x89, 0x2B, 0x5C, 0x88, 0x2B, 0x5B, 0x87, 0x2A, 0x5A, 0x86,
          0x2A, 0x5A, 0x86, 0x29, 0x59, 0x85, 0x29, 0x58, 0x84, 0x28, 0x58, 0x83, 0x27, 0x57, 0x83, 0x27, 0x56, 0x82, 0x26, 0x56, 0x81, 0x26, 0x55, 0x80, 0x25, 0x54, 0x80, 0x25, 0x54, 0x7F, 0x24, 0x53, 0x7E, 0x24, 0x52, 0x7D, 0x23, 0x51, 0x7D,
          0x23, 0x51, 0x7C, 0x22, 0x50, 0x7B, 0x22, 0x50, 0x7B, 0x21, 0x4F, 0x7A, 0x21, 0x4E, 0x79, 0x20, 0x4E, 0x78, 0x20, 0x4D, 0x78, 0x1F, 0x4C, 0x77, 0x1F, 0x4C, 0x76, 0x1E, 0x4B, 0x76, 0x1E, 0x4B, 0x75, 0x1D, 0x4A, 0x75, 0x1D, 0x4A, 0x74,
          0x1D, 0x49, 0x74, 0x1C, 0x49, 0x73, 0x1C, 0x48, 0x73, 0x1B, 0x48, 0x72,
    0x36, 0x6A, 0x97, 0x36, 0x6A, 0x97, 0x36, 0x6A, 0x97, 0x36, 0x6A, 0x97, 0x37, 0x6A, 0x97, 0x37, 0x6A, 0x98, 0x36, 0x6A, 0x97, 0x36, 0x6A, 0x97, 0x36, 0x69, 0x97, 0x36, 0x69, 0x97, 0x36, 0x69, 0x97, 0x36, 0x69, 0x97, 0x36, 0x69, 0x96, 0x35, 0x69, 0x96,
          0x35, 0x68, 0x96, 0x35, 0x68, 0x95, 0x35, 0x68, 0x95, 0x35, 0x67, 0x95, 0x34, 0x67, 0x94, 0x34, 0x66, 0x94, 0x34, 0x66, 0x93, 0x33, 0x66, 0x93, 0x33, 0x65, 0x92, 0x32, 0x65, 0x92, 0x32, 0x64, 0x91, 0x32, 0x64, 0x91, 0x31, 0x63, 0x90,
          0x31, 0x63, 0x8F, 0x30, 0x62, 0x8F, 0x30, 0x61, 0x8E, 0x2F, 0x61, 0x8D, 0x2F, 0x60, 0x8D, 0x2E, 0x60, 0x8C, 0x2E, 0x5F, 0x8B, 0x2D, 0x5E, 0x8B, 0x2D, 0x5E, 0x8A, 0x2C, 0x5D, 0x89, 0x2C, 0x5C, 0x89, 0x2B, 0x5C, 0x88, 0x2B, 0x5B, 0x87,
          0x2A, 0x5A, 0x86, 0x2A, 0x5A, 0x86, 0x29, 0x59, 0x85, 0x28, 0x58, 0x84, 0x28, 0x57, 0x83, 0x27, 0x57, 0x82, 0x27, 0x56, 0x82, 0x26, 0x55, 0x81, 0x26, 0x55, 0x80, 0x25, 0x54, 0x7F, 0x25, 0x53, 0x7F, 0x24, 0x53, 0x7E, 0x24, 0x52, 0x7D,
          0x23, 0x51, 0x7D, 0x22, 0x51, 0x7C, 0x22, 0x50, 0x7B, 0x21, 0x4F, 0x7A, 0x21, 0x4F, 0x79, 0x20, 0x4E, 0x79, 0x20, 0x4D, 0x78, 0x1F, 0x4D, 0x78, 0x1F, 0x4C, 0x77, 0x1F, 0x4C, 0x76, 0x1E, 0x4B, 0x76, 0x1E, 0x4B, 0x75, 0x1D, 0x4A, 0x74,
          0x1D, 0x4A, 0x74, 0x1C, 0x49, 0x73, 0x1C, 0x48, 0x73, 0x1C, 0x48, 0x72,
    0x37, 0x6B, 0x98, 0x37, 0x6B, 0x98, 0x37, 0x6B, 0x98, 0x37, 0x6B, 0x99, 0x37, 0x6B, 0x99, 0x37, 0x6B, 0x98, 0x37, 0x6B, 0x98, 0x37, 0x6A, 0x98, 0x37, 0x6A, 0x98, 0x37, 0x6A, 0x98, 0x37, 0x6A, 0x98, 0x37, 0x6A, 0x98, 0x36, 0x6A, 0x97, 0x36, 0x69, 0x97,
          0x36, 0x69, 0x97, 0x36, 0x69, 0x96, 0x35, 0x68, 0x96, 0x35, 0x68, 0x96, 0x35, 0x68, 0x95, 0x35, 0x67, 0x95, 0x34, 0x67, 0x94, 0x34, 0x66, 0x94, 0x33, 0x66, 0x93, 0x33, 0x65, 0x93, 0x33, 0x65, 0x92, 0x32, 0x64, 0x91, 0x32, 0x64, 0x91,
          0x31, 0x63, 0x90, 0x31, 0x63, 0x90, 0x30, 0x62, 0x8F, 0x30, 0x61, 0x8E, 0x2F, 0x61, 0x8E, 0x2F, 0x60, 0x8D, 0x2E, 0x60, 0x8C, 0x2E, 0x5F, 0x8C, 0x2D, 0x5E, 0x8B, 0x2D, 0x5E, 0x8A, 0x2C, 0x5D, 0x89, 0x2C, 0x5C, 0x88, 0x2B, 0x5C, 0x88,
          0x2B, 0x5B, 0x87, 0x2A, 0x5A, 0x86, 0x29, 0x59, 0x85, 0x29, 0x59, 0x85, 0x28, 0x58, 0x84, 0x28, 0x57, 0x83, 0x27, 0x57, 0x82, 0x27, 0x56, 0x81, 0x26, 0x55, 0x81, 0x26, 0x55, 0x80, 0x25, 0x54, 0x7F, 0x25, 0x53, 0x7E, 0x24, 0x52, 0x7E,
          0x23, 0x52, 0x7D, 0x23, 0x51, 0x7C, 0x22, 0x50, 0x7C, 0x22, 0x50, 0x7B, 0x21, 0x4F, 0x7A, 0x21, 0x4E, 0x79, 0x20, 0x4E, 0x79, 0x20, 0x4D, 0x78, 0x1F, 0x4C, 0x77, 0x1F, 0x4C, 0x77, 0x1E, 0x4B, 0x76, 0x1E, 0x4B, 0x75, 0x1D, 0x4A, 0x75,
          0x1D, 0x4A, 0x74, 0x1D, 0x49, 0x74, 0x1C, 0x49, 0x73, 0x1C, 0x48, 0x72,
    0x38, 0x6C, 0x99, 0x38, 0x6C, 0x99, 0x38, 0x6C, 0x9A, 0x38, 0x6C, 0x9A, 0x38, 0x6C, 0x9A, 0x38, 0x6C, 0x99, 0x38, 0x6C, 0x99, 0x38, 0x6B, 0x99, 0x38, 0x6B, 0x99, 0x38, 0x6B, 0x99, 0x38, 0x6B, 0x99, 0x37, 0x6B, 0x99, 0x37, 0x6B, 0x98, 0x37, 0x6A, 0x98,
          0x37, 0x6A, 0x98, 0x36, 0x6A, 0x97, 0x36, 0x69, 0x97, 0x36, 0x69, 0x96, 0x36, 0x69, 0x96, 0x35, 0x68, 0x96, 0x35, 0x68, 0x95, 0x34, 0x67, 0x95, 0x34, 0x67, 0x94, 0x34, 0x66, 0x93, 0x33, 0x66, 0x93, 0x33, 0x65, 0x92, 0x32, 0x65, 0x92,
          0x32, 0x64, 0x91, 0x31, 0x63, 0x90, 0x31, 0x63, 0x90, 0x30, 0x62, 0x8F, 0x30, 0x62, 0x8E, 0x2F, 0x61, 0x8E, 0x2F, 0x60, 0x8D, 0x2E, 0x60, 0x8C, 0x2E, 0x5F, 0x8B, 0x2D, 0x5E, 0x8B, 0x2D, 0x5E, 0x8A, 0x2C, 0x5D, 0x89, 0x2C, 0x5C, 0x88,
          0x2B, 0x5B, 0x88, 0x2A, 0x5B, 0x87, 0x2A, 0x5A, 0x86, 0x29, 0x59, 0x85, 0x29, 0x59, 0x84, 0x28, 0x58, 0x84, 0x28, 0x57, 0x83, 0x27, 0x56, 0x82, 0x26, 0x56, 0x81, 0x26, 0x55, 0x80, 0x25, 0x54, 0x80, 0x25, 0x54, 0x7F, 0x24, 0x53, 0x7E,
          0x24, 0x52, 0x7D, 0x23, 0x52, 0x7C, 0x23, 0x51, 0x7C, 0x22, 0x50, 0x7B, 0x21, 0x4F, 0x7A, 0x21, 0x4F, 0x7A, 0x21, 0x4E, 0x79, 0x20, 0x4D, 0x78, 0x20, 0x4D, 0x78, 0x1F, 0x4C, 0x77, 0x1F, 0x4C, 0x76, 0x1E, 0x4B, 0x76, 0x1E, 0x4B, 0x75,
          0x1D, 0x4A, 0x74, 0x1D, 0x4A, 0x74, 0x1C, 0x49, 0x73, 0x1C, 0x48, 0x73,
    0x39, 0x6C, 0x9A, 0x39, 0x6C, 0x9A, 0x39, 0x6D, 0x9A, 0x39, 0x6D, 0x9B, 0x39, 0x6D, 0x9B, 0x39, 0x6D, 0x9A, 0x39, 0x6C, 0x9A, 0x39, 0x6C, 0x9A, 0x38, 0x6C, 0x9A, 0x38, 0x6C, 0x9A, 0x38, 0x6C, 0x9A, 0x38, 0x6C, 0x9A, 0x38, 0x6B, 0x99, 0x38, 0x6B, 0x99,
          0x37, 0x6B, 0x99, 0x37, 0x6B, 0x98, 0x37, 0x6A, 0x98, 0x36, 0x6A, 0x97, 0x36, 0x69, 0x97, 0x36, 0x69, 0x96, 0x35, 0x69, 0x96, 0x35, 0x68, 0x96, 0x35, 0x68, 0x95, 0x34, 0x67, 0x94, 0x34, 0x67, 0x94, 0x33, 0x66, 0x93, 0x33, 0x65, 0x93,
          0x33, 0x65, 0x92, 0x32, 0x64, 0x91, 0x32, 0x64, 0x91, 0x31, 0x63, 0x90, 0x31, 0x62, 0x8F, 0x30, 0x62, 0x8E, 0x2F, 0x61, 0x8E, 0x2F, 0x60, 0x8D, 0x2E, 0x60, 0x8C, 0x2E, 0x5F, 0x8B, 0x2D, 0x5E, 0x8B, 0x2D, 0x5E, 0x8A, 0x2C, 0x5D, 0x89,
          0x2C, 0x5C, 0x88, 0x2B, 0x5B, 0x87, 0x2A, 0x5B, 0x87, 0x2A, 0x5A, 0x86, 0x29, 0x59, 0x85, 0x29, 0x58, 0x84, 0x28, 0x58, 0x83, 0x28, 0x57, 0x83, 0x27, 0x56, 0x82, 0x26, 0x55, 0x81, 0x26, 0x55, 0x80, 0x25, 0x54, 0x7F, 0x25, 0x53, 0x7F,
          0x24, 0x53, 0x7E, 0x23, 0x52, 0x7D, 0x23, 0x51, 0x7C, 0x22, 0x50, 0x7B, 0x22, 0x50, 0x7B, 0x21, 0x4F, 0x7A, 0x21, 0x4F, 0x79, 0x20, 0x4E, 0x79, 0x20, 0x4D, 0x78, 0x1F, 0x4D, 0x77, 0x1F, 0x4C, 0x77, 0x1E, 0x4B, 0x76, 0x1E, 0x4B, 0x75,
          0x1D, 0x4A, 0x75, 0x1D, 0x4A, 0x74, 0x1D, 0x49, 0x73, 0x1C, 0x49, 0x73,
    0x39, 0x6D, 0x9B, 0x39, 0x6D, 0x9B, 0x39, 0x6D, 0x9C, 0x39, 0x6E, 0x9C, 0x39, 0x6D, 0x9B, 0x39, 0x6D, 0x9B, 0x39, 0x6D, 0x9B, 0x39, 0x6D, 0x9B, 0x39, 0x6D, 0x9B, 0x39, 0x6D, 0x9B, 0x39, 0x6D, 0x9B, 0x39, 0x6D, 0x9B, 0x39, 0x6C, 0x9A, 0x38, 0x6C, 0x9A,
          0x38, 0x6C, 0x99, 0x38, 0x6B, 0x99, 0x37, 0x6B, 0x99, 0x37, 0x6B, 0x98, 0x37, 0x6A, 0x98, 0x36, 0x6A, 0x97, 0x36, 0x69, 0x97, 0x36, 0x69, 0x96, 0x35, 0x68, 0x96, 0x35, 0x68, 0x95, 0x34, 0x67, 0x95, 0x34, 0x67, 0x94, 0x34, 0x66, 0x93,
          0x33, 0x65, 0x93, 0x33, 0x65, 0x92, 0x32, 0x64, 0x91, 0x32, 0x64, 0x91, 0x31, 0x63, 0x90, 0x30, 0x62, 0x8F, 0x30, 0x62, 0x8E, 0x2F, 0x61, 0x8E, 0x2F, 0x60, 0x8D, 0x2E, 0x5F, 0x8C, 0x2E, 0x5F, 0x8B, 0x2D, 0x5E, 0x8A, 0x2D, 0x5D, 0x8A,
          0x2C, 0x5D, 0x89, 0x2B, 0x5C, 0x88, 0x2B, 0x5B, 0x87, 0x2A, 0x5A, 0x86, 0x2A, 0x5A, 0x86, 0x29, 0x59, 0x85, 0x28, 0x58, 0x84, 0x28, 0x57, 0x83, 0x27, 0x57, 0x82, 0x27, 0x56, 0x81, 0x26, 0x55, 0x81, 0x25, 0x54, 0x80, 0x25, 0x54, 0x7F,
          0x24, 0x53, 0x7E, 0x24, 0x52, 0x7D, 0x23, 0x52, 0x7D, 0x23, 0x51, 0x7C, 0x22, 0x50, 0x7B, 0x21, 0x4F, 0x7A, 0x21, 0x4F, 0x7A, 0x21, 0x4E, 0x79, 0x20, 0x4D, 0x78, 0x20, 0x4D, 0x78, 0x1F, 0x4C, 0x77, 0x1E, 0x4C, 0x76, 0x1E, 0x4B, 0x75,
          0x1D, 0x4B, 0x75, 0x1D, 0x4A, 0x74, 0x1D, 0x49, 0x74, 0x1C, 0x49, 0x73,
    0x3A, 0x6E, 0x9C, 0x3A, 0x6E, 0x9C, 0x3A, 0x6E, 0x9D, 0x3A, 0x6E, 0x9D, 0x3A, 0x6E, 0x9C, 0x3A, 0x6E, 0x9C, 0x3A, 0x6E, 0x9C, 0x3A, 0x6E, 0x9C, 0x3A, 0x6E, 0x9C, 0x3A, 0x6E, 0x9C, 0x3A, 0x6E, 0x9C, 0x39, 0x6D, 0x9B, 0x39, 0x6D, 0x9B, 0x39, 0x6D, 0x9B,
          0x39, 0x6D, 0x9B, 0x38, 0x6C, 0x9A, 0x38, 0x6C, 0x9A, 0x38, 0x6B, 0x99, 0x38, 0x6B, 0x99, 0x37, 0x6B, 0x98, 0x37, 0x6A, 0x98, 0x36, 0x69, 0x97, 0x36, 0x69, 0x97, 0x35, 0x68, 0x96, 0x35, 0x68, 0x95, 0x35, 0x67, 0x95, 0x34, 0x67, 0x94,
          0x34, 0x66, 0x94, 0x33, 0x66, 0x93, 0x33, 0x65, 0x92, 0x32, 0x64, 0x91, 0x32, 0x64, 0x91, 0x31, 0x63, 0x90, 0x31, 0x62, 0x8F, 0x30, 0x61, 0x8E, 0x2F, 0x61, 0x8D, 0x2F, 0x60, 0x8D, 0x2E, 0x5F, 0x8C, 0x2E, 0x5F, 0x8B, 0x2D, 0x5E, 0x8A,
          0x2C, 0x5D, 0x89, 0x2C, 0x5C, 0x89, 0x2B, 0x5C, 0x88, 0x2B, 0x5B, 0x87, 0x2A, 0x5A, 0x86, 0x29, 0x59, 0x85, 0x29, 0x59, 0x85, 0x28, 0x58, 0x84, 0x28, 0x57, 0x83, 0x27, 0x56, 0x82, 0x26, 0x56, 0x81, 0x26, 0x55, 0x80, 0x25, 0x54, 0x80,
          0x25, 0x53, 0x7F, 0x24, 0x53, 0x7E, 0x23, 0x52, 0x7D, 0x23, 0x51, 0x7C, 0x22, 0x50, 0x7C, 0x22, 0x50, 0x7B, 0x21, 0x4F, 0x7A, 0x21, 0x4E, 0x79, 0x20, 0x4E, 0x79, 0x20, 0x4D, 0x78, 0x1F, 0x4D, 0x77, 0x1F, 0x4C, 0x77, 0x1E, 0x4B, 0x76,
          0x1E, 0x4B, 0x75, 0x1D, 0x4A, 0x75, 0x1D, 0x4A, 0x74, 0x1C, 0x49, 0x73,
    0x3B, 0x6F, 0x9D, 0x3B, 0x6F, 0x9D, 0x3B, 0x6F, 0x9D, 0x3B, 0x6F, 0x9D, 0x3B, 0x6F, 0x9D, 0x3B, 0x6F, 0x9D, 0x3B, 0x6F, 0x9D, 0x3B, 0x6F, 0x9D, 0x3B, 0x6F, 0x9D, 0x3A, 0x6F, 0x9D, 0x3A, 0x6E, 0x9D, 0x3A, 0x6E, 0x9D, 0x3A, 0x6E, 0x9C, 0x3A, 0x6E, 0x9C,
          0x39, 0x6D, 0x9B, 0x39, 0x6D, 0x9B, 0x39, 0x6D, 0x9B, 0x38, 0x6C, 0x9A, 0x38, 0x6C, 0x9A, 0x38, 0x6B, 0x99, 0x37, 0x6B, 0x99, 0x37, 0x6A, 0x98, 0x37, 0x6A, 0x97, 0x36, 0x69, 0x97, 0x36, 0x69, 0x96, 0x35, 0x68, 0x96, 0x35, 0x67, 0x95,
          0x34, 0x67, 0x94, 0x34, 0x66, 0x94, 0x33, 0x65, 0x93, 0x33, 0x65, 0x92, 0x32, 0x64, 0x91, 0x32, 0x64, 0x91, 0x31, 0x63, 0x90, 0x30, 0x62, 0x8F, 0x30, 0x61, 0x8E, 0x2F, 0x61, 0x8D, 0x2F, 0x60, 0x8D, 0x2E, 0x5F, 0x8C, 0x2D, 0x5F, 0x8B,
          0x2D, 0x5E, 0x8A, 0x2C, 0x5D, 0x89, 0x2C, 0x5C, 0x88, 0x2B, 0x5B, 0x88, 0x2A, 0x5B, 0x87, 0x2A, 0x5A, 0x86, 0x29, 0x59, 0x85, 0x29, 0x58, 0x84, 0x28, 0x58, 0x83, 0x27, 0x57, 0x82, 0x27, 0x56, 0x82, 0x26, 0x55, 0x81, 0x26, 0x55, 0x80,
          0x25, 0x54, 0x7F, 0x24, 0x53, 0x7E, 0x24, 0x52, 0x7E, 0x23, 0x52, 0x7D, 0x23, 0x51, 0x7C, 0x22, 0x50, 0x7B, 0x22, 0x4F, 0x7A, 0x21, 0x4F, 0x7A, 0x20, 0x4E, 0x79, 0x20, 0x4D, 0x78, 0x1F, 0x4D, 0x78, 0x1F, 0x4C, 0x77, 0x1E, 0x4C, 0x76,
          0x1E, 0x4B, 0x76, 0x1E, 0x4A, 0x75, 0x1D, 0x4A, 0x74, 0x1D, 0x49, 0x74,
    0x3B, 0x70, 0x9E, 0x3C, 0x70, 0x9E, 0x3C, 0x70, 0x9E, 0x3C, 0x70, 0x9F, 0x3C, 0x70, 0x9E, 0x3C, 0x70, 0x9E, 0x3C, 0x70, 0x9E, 0x3B, 0x70, 0x9E, 0x3B, 0x70, 0x9E, 0x3B, 0x70, 0x9E, 0x3B, 0x70, 0x9E, 0x3B, 0x6F, 0x9D, 0x3B, 0x6F, 0x9D, 0x3A, 0x6F, 0x9D,
          0x3A, 0x6E, 0x9C, 0x3A, 0x6E, 0x9C, 0x39, 0x6D, 0x9B, 0x39, 0x6D, 0x9B, 0x39, 0x6D, 0x9B, 0x38, 0x6C, 0x9A, 0x38, 0x6C, 0x9A, 0x38, 0x6B, 0x99, 0x37, 0x6B, 0x98, 0x37, 0x6A, 0x98, 0x36, 0x69, 0x97, 0x36, 0x69, 0x96, 0x35, 0x68, 0x96,
          0x35, 0x68, 0x95, 0x34, 0x67, 0x94, 0x34, 0x66, 0x94, 0x33, 0x65, 0x93, 0x33, 0x65, 0x92, 0x32, 0x64, 0x91, 0x31, 0x64, 0x91, 0x31, 0x63, 0x90, 0x30, 0x62, 0x8F, 0x30, 0x61, 0x8E, 0x2F, 0x60, 0x8D, 0x2E, 0x60, 0x8C, 0x2E, 0x5F, 0x8C,
          0x2D, 0x5E, 0x8B, 0x2D, 0x5D, 0x8A, 0x2C, 0x5D, 0x89, 0x2B, 0x5C, 0x88, 0x2B, 0x5B, 0x87, 0x2A, 0x5A, 0x86, 0x2A, 0x5A, 0x85, 0x29, 0x59, 0x85, 0x28, 0x58, 0x84, 0x28, 0x57, 0x83, 0x27, 0x56, 0x82, 0x26, 0x56, 0x81, 0x26, 0x55, 0x80,
          0x25, 0x54, 0x80, 0x25, 0x53, 0x7F, 0x24, 0x53, 0x7E, 0x24, 0x52, 0x7D, 0x23, 0x51, 0x7C, 0x22, 0x50, 0x7B, 0x22, 0x50, 0x7B, 0x21, 0x4F, 0x7A, 0x21, 0x4E, 0x79, 0x20, 0x4E, 0x79, 0x20, 0x4D, 0x78, 0x1F, 0x4C, 0x77, 0x1F, 0x4C, 0x76,
          0x1E, 0x4B, 0x76, 0x1E, 0x4B, 0x75, 0x1D, 0x4A, 0x75, 0x1D, 0x4A, 0x74,
    0x3C, 0x71, 0x9F, 0x3C, 0x71, 0x9F, 0x3C, 0x71, 0x9F, 0x3C, 0x71, 0x9F, 0x3C, 0x71, 0x9F, 0x3C, 0x71, 0x9F, 0x3C, 0x71, 0x9F, 0x3C, 0x71, 0x9F, 0x3C, 0x71, 0x9F, 0x3C, 0x70, 0x9F, 0x3C, 0x70, 0x9F, 0x3C, 0x70, 0x9E, 0x3B, 0x70, 0x9E, 0x3B, 0x6F, 0x9E,
          0x3B, 0x6F, 0x9D, 0x3A, 0x6F, 0x9D, 0x3A, 0x6E, 0x9C, 0x3A, 0x6E, 0x9C, 0x39, 0x6E, 0x9B, 0x39, 0x6D, 0x9B, 0x39, 0x6C, 0x9A, 0x38, 0x6C, 0x9A, 0x38, 0x6B, 0x99, 0x37, 0x6B, 0x98, 0x37, 0x6A, 0x98, 0x36, 0x6A, 0x97, 0x36, 0x69, 0x97,
          0x35, 0x68, 0x96, 0x35, 0x68, 0x95, 0x34, 0x67, 0x94, 0x34, 0x66, 0x94, 0x33, 0x66, 0x93, 0x33, 0x65, 0x92, 0x32, 0x64, 0x91, 0x32, 0x63, 0x90, 0x31, 0x63, 0x90, 0x30, 0x62, 0x8F, 0x30, 0x61, 0x8E, 0x2F, 0x60, 0x8D, 0x2E, 0x60, 0x8C,
          0x2E, 0x5F, 0x8B, 0x2D, 0x5E, 0x8A, 0x2D, 0x5D, 0x8A, 0x2C, 0x5C, 0x89, 0x2B, 0x5C, 0x88, 0x2B, 0x5B, 0x87, 0x2A, 0x5A, 0x86, 0x29, 0x59, 0x85, 0x29, 0x58, 0x84, 0x28, 0x58, 0x83, 0x27, 0x57, 0x83, 0x27, 0x56, 0x82, 0x26, 0x55, 0x81,
          0x26, 0x55, 0x80, 0x25, 0x54, 0x7F, 0x24, 0x53, 0x7E, 0x24, 0x52, 0x7E, 0x23, 0x52, 0x7D, 0x23, 0x51, 0x7C, 0x22, 0x50, 0x7B, 0x21, 0x4F, 0x7A, 0x21, 0x4F, 0x7A, 0x20, 0x4E, 0x79, 0x20, 0x4D, 0x78, 0x1F, 0x4D, 0x77, 0x1F, 0x4C, 0x77,
          0x1E, 0x4C, 0x76, 0x1E, 0x4B, 0x75, 0x1D, 0x4A, 0x75, 0x1D, 0x4A, 0x74,
    0x3D, 0x72, 0xA0, 0x3D, 0x72, 0xA0, 0x3D, 0x72, 0xA0, 0x3D, 0x72, 0xA0, 0x3D, 0x72, 0xA0, 0x3D, 0x72, 0xA0, 0x3D, 0x72, 0xA0, 0x3D, 0x72, 0xA0, 0x3D, 0x72, 0xA0, 0x3D, 0x71, 0xA0, 0x3C, 0x71, 0xA0, 0x3C, 0x71, 0x9F, 0x3C, 0x71, 0x9F, 0x3C, 0x70, 0x9F,
          0x3B, 0x70, 0x9E, 0x3B, 0x6F, 0x9E, 0x3B, 0x6F, 0x9D, 0x3A, 0x6F, 0x9D, 0x3A, 0x6E, 0x9C, 0x3A, 0x6E, 0x9C, 0x39, 0x6D, 0x9B, 0x39, 0x6D, 0x9B, 0x38, 0x6C, 0x9A, 0x38, 0x6B, 0x99, 0x37, 0x6B, 0x99, 0x37, 0x6A, 0x98, 0x36, 0x6A, 0x97,
          0x36, 0x69, 0x97, 0x35, 0x68, 0x96, 0x35, 0x68, 0x95, 0x34, 0x67, 0x94, 0x34, 0x66, 0x93, 0x33, 0x65, 0x93, 0x32, 0x65, 0x92, 0x32, 0x64, 0x91, 0x31, 0x63, 0x90, 0x31, 0x62, 0x8F, 0x30, 0x62, 0x8E, 0x2F, 0x61, 0x8E, 0x2F, 0x60, 0x8D,
          0x2E, 0x5F, 0x8C, 0x2D, 0x5E, 0x8B, 0x2D, 0x5E, 0x8A, 0x2C, 0x5D, 0x89, 0x2C, 0x5C, 0x88, 0x2B, 0x5B, 0x87, 0x2A, 0x5B, 0x87, 0x2A, 0x5A, 0x86, 0x29, 0x59, 0x85, 0x28, 0x58, 0x84, 0x28, 0x57, 0x83, 0x27, 0x57, 0x82, 0x27, 0x56, 0x81,
          0x26, 0x55, 0x80, 0x25, 0x54, 0x80, 0x25, 0x53, 0x7F, 0x24, 0x53, 0x7E, 0x23, 0x52, 0x7D, 0x23, 0x51, 0x7C, 0x22, 0x50, 0x7B, 0x22, 0x50, 0x7B, 0x21, 0x4F, 0x7A, 0x21, 0x4E, 0x79, 0x20, 0x4E, 0x78, 0x20, 0x4D, 0x78, 0x1F, 0x4C, 0x77,
          0x1E, 0x4C, 0x76, 0x1E, 0x4B, 0x76, 0x1E, 0x4B, 0x75, 0x1D, 0x4A, 0x74,
    0x3D, 0x72, 0xA1, 0x3E, 0x73, 0xA1, 0x3E, 0x73, 0xA1, 0x3E, 0x73, 0xA1, 0x3E, 0x73, 0xA1, 0x3E, 0x73, 0xA1, 0x3E, 0x73, 0xA1, 0x3E, 0x72, 0xA1, 0x3D, 0x72, 0xA1, 0x3D, 0x72, 0xA1, 0x3D, 0x72, 0xA1, 0x3D, 0x72, 0xA0, 0x3D, 0x71, 0xA0, 0x3C, 0x71, 0x9F,
          0x3C, 0x71, 0x9F, 0x3C, 0x70, 0x9F, 0x3B, 0x70, 0x9E, 0x3B, 0x70, 0x9E, 0x3B, 0x6F, 0x9D, 0x3A, 0x6F, 0x9D, 0x3A, 0x6E, 0x9C, 0x39, 0x6D, 0x9B, 0x39, 0x6D, 0x9B, 0x38, 0x6C, 0x9A, 0x38, 0x6C, 0x99, 0x37, 0x6B, 0x99, 0x37, 0x6A, 0x98,
          0x36, 0x6A, 0x97, 0x36, 0x69, 0x97, 0x35, 0x68, 0x96, 0x35, 0x67, 0x95, 0x34, 0x67, 0x94, 0x34, 0x66, 0x93, 0x33, 0x65, 0x92, 0x32, 0x65, 0x92, 0x32, 0x64, 0x91, 0x31, 0x63, 0x90, 0x31, 0x62, 0x8F, 0x30, 0x61, 0x8E, 0x2F, 0x61, 0x8D,
          0x2E, 0x60, 0x8C, 0x2E, 0x5F, 0x8B, 0x2D, 0x5E, 0x8B, 0x2D, 0x5D, 0x8A, 0x2C, 0x5C, 0x89, 0x2B, 0x5C, 0x88, 0x2B, 0x5B, 0x87, 0x2A, 0x5A, 0x86, 0x29, 0x59, 0x85, 0x29, 0x58, 0x84, 0x28, 0x58, 0x83, 0x27, 0x57, 0x83, 0x27, 0x56, 0x82,
          0x26, 0x55, 0x81, 0x25, 0x54, 0x80, 0x25, 0x54, 0x7F, 0x24, 0x53, 0x7E, 0x24, 0x52, 0x7D, 0x23, 0x51, 0x7D, 0x23, 0x51, 0x7C, 0x22, 0x50, 0x7B, 0x21, 0x4F, 0x7A, 0x21, 0x4F, 0x79, 0x20, 0x4E, 0x79, 0x20, 0x4D, 0x78, 0x1F, 0x4D, 0x77,
          0x1F, 0x4C, 0x77, 0x1E, 0x4B, 0x76, 0x1E, 0x4B, 0x75, 0x1D, 0x4A, 0x75,
    0x3E, 0x73, 0xA2, 0x3E, 0x74, 0xA2, 0x3E, 0x73, 0xA2, 0x3E, 0x73, 0xA2, 0x3E, 0x74, 0xA2, 0x3E, 0x73, 0xA2, 0x3E, 0x73, 0xA2, 0x3E, 0x73, 0xA2, 0x3E, 0x73, 0xA2, 0x3E, 0x73, 0xA1, 0x3E, 0x73, 0xA1, 0x3D, 0x72, 0xA1, 0x3D, 0x72, 0xA1, 0x3D, 0x72, 0xA0,
          0x3D, 0x71, 0xA0, 0x3C, 0x71, 0x9F, 0x3C, 0x71, 0x9F, 0x3C, 0x70, 0x9E, 0x3B, 0x70, 0x9E, 0x3B, 0x6F, 0x9D, 0x3A, 0x6F, 0x9D, 0x3A, 0x6E, 0x9C, 0x39, 0x6D, 0x9B, 0x39, 0x6D, 0x9B, 0x38, 0x6C, 0x9A, 0x38, 0x6C, 0x99, 0x37, 0x6B, 0x99,
          0x37, 0x6A, 0x98, 0x36, 0x6A, 0x97, 0x36, 0x69, 0x96, 0x35, 0x68, 0x95, 0x35, 0x67, 0x95, 0x34, 0x67, 0x94, 0x33, 0x66, 0x93, 0x33, 0x65, 0x92, 0x32, 0x64, 0x91, 0x31, 0x64, 0x90, 0x31, 0x63, 0x90, 0x30, 0x62, 0x8F, 0x30, 0x61, 0x8E,
          0x2F, 0x60, 0x8D, 0x2E, 0x5F, 0x8C, 0x2E, 0x5F, 0x8B, 0x2D, 0x5E, 0x8A, 0x2C, 0x5D, 0x89, 0x2C, 0x5C, 0x88, 0x2B, 0x5B, 0x87, 0x2A, 0x5A, 0x87, 0x2A, 0x5A, 0x86, 0x29, 0x59, 0x85, 0x28, 0x58, 0x84, 0x28, 0x57, 0x83, 0x27, 0x56, 0x82,
          0x26, 0x56, 0x81, 0x26, 0x55, 0x80, 0x25, 0x54, 0x7F, 0x24, 0x53, 0x7F, 0x24, 0x52, 0x7E, 0x23, 0x52, 0x7D, 0x23, 0x51, 0x7C, 0x22, 0x50, 0x7B, 0x22, 0x4F, 0x7A, 0x21, 0x4F, 0x7A, 0x20, 0x4E, 0x79, 0x20, 0x4D, 0x78, 0x21, 0x4F, 0x79,
          0x20, 0x4D, 0x78, 0x1E, 0x4C, 0x76, 0x1E, 0x4B, 0x76, 0x1D, 0x4A, 0x75,
    0x3F, 0x74, 0xA3, 0x3F, 0x74, 0xA3, 0x3F, 0x74, 0xA3, 0x3F, 0x74, 0xA3, 0x3F, 0x74, 0xA3, 0x3F, 0x74, 0xA3, 0x3F, 0x74, 0xA3, 0x3F, 0x74, 0xA3, 0x3F, 0x74, 0xA3, 0x3E, 0x74, 0xA2, 0x3E, 0x74, 0xA2, 0x3E, 0x73, 0xA2, 0x3E, 0x73, 0xA1, 0x3D, 0x73, 0xA1,
          0x3D, 0x72, 0xA1, 0x3D, 0x72, 0xA0, 0x3D, 0x71, 0xA0, 0x3C, 0x71, 0x9F, 0x3C, 0x70, 0x9F, 0x3B, 0x70, 0x9E, 0x3B, 0x6F, 0x9E, 0x3A, 0x6F, 0x9D, 0x3A, 0x6E, 0x9C, 0x39, 0x6E, 0x9C, 0x39, 0x6D, 0x9B, 0x38, 0x6C, 0x9A, 0x38, 0x6C, 0x99,
          0x37, 0x6B, 0x98, 0x37, 0x6A, 0x98, 0x36, 0x69, 0x97, 0x36, 0x68, 0x96, 0x35, 0x68, 0x95, 0x34, 0x67, 0x94, 0x34, 0x66, 0x94, 0x33, 0x65, 0x93, 0x32, 0x65, 0x92, 0x32, 0x64, 0x91, 0x31, 0x63, 0x90, 0x31, 0x62, 0x8F, 0x30, 0x61, 0x8E,
          0x2F, 0x61, 0x8D, 0x2F, 0x60, 0x8C, 0x2E, 0x5F, 0x8C, 0x2D, 0x5E, 0x8B, 0x2D, 0x5D, 0x8A, 0x2C, 0x5C, 0x89, 0x2B, 0x5C, 0x88, 0x2B, 0x5B, 0x87, 0x2A, 0x5A, 0x86, 0x29, 0x59, 0x85, 0x29, 0x58, 0x84, 0x28, 0x58, 0x83, 0x27, 0x57, 0x82,
          0x2C, 0x5A, 0x85, 0x2D, 0x5B, 0x85, 0x25, 0x54, 0x80, 0x25, 0x54, 0x7F, 0x24, 0x53, 0x7E, 0x23, 0x52, 0x7D, 0x23, 0x51, 0x7C, 0x22, 0x51, 0x7C, 0x22, 0x50, 0x7B, 0x21, 0x4F, 0x7A, 0x21, 0x4E, 0x79, 0x20, 0x4E, 0x78, 0x20, 0x4D, 0x78,
          0x1F, 0x4C, 0x77, 0x1F, 0x4C, 0x76, 0x1E, 0x4B, 0x76, 0x1E, 0x4A, 0x75,
    0x3F, 0x75, 0xA4, 0x3F, 0x75, 0xA4, 0x40, 0x75, 0xA4, 0x40, 0x75, 0xA4, 0x40, 0x75, 0xA4, 0x40, 0x75, 0xA4, 0x3F, 0x75, 0xA4, 0x3F, 0x75, 0xA4, 0x3F, 0x75, 0xA4, 0x3F, 0x75, 0xA3, 0x3F, 0x74, 0xA3, 0x3F, 0x74, 0xA3, 0x3E, 0x74, 0xA2, 0x3E, 0x73, 0xA2,
          0x3E, 0x73, 0xA2, 0x3D, 0x73, 0xA1, 0x3D, 0x72, 0xA1, 0x3D, 0x72, 0xA0, 0x3C, 0x71, 0xA0, 0x3C, 0x70, 0x9F, 0x3B, 0x70, 0x9E, 0x3B, 0x6F, 0x9E, 0x3A, 0x6F, 0x9D, 0x3A, 0x6E, 0x9C, 0x39, 0x6E, 0x9C, 0x39, 0x6D, 0x9B, 0x38, 0x6C, 0x9A,
          0x38, 0x6C, 0x99, 0x37, 0x6B, 0x98, 0x37, 0x6A, 0x98, 0x36, 0x69, 0x97, 0x35, 0x69, 0x96, 0x35, 0x68, 0x95, 0x34, 0x67, 0x94, 0x34, 0x66, 0x93, 0x33, 0x65, 0x92, 0x32, 0x65, 0x92, 0x32, 0x64, 0x91, 0x31, 0x63, 0x90, 0x30, 0x62, 0x8F,
          0x30, 0x61, 0x8E, 0x2F, 0x60, 0x8D, 0x2E, 0x5F, 0x8C, 0x2E, 0x5F, 0x8B, 0x2D, 0x5E, 0x8A, 0x2C, 0x5D, 0x89, 0x2C, 0x5C, 0x88, 0x2B, 0x5B, 0x87, 0x2A, 0x5A, 0x86, 0x29, 0x5A, 0x85, 0x29, 0x59, 0x85, 0x2A, 0x5A, 0x85, 0x5A, 0x7F, 0xA0,
          0x92, 0xAA, 0xC1, 0x95, 0xAD, 0xC2, 0x56, 0x7B, 0x9D, 0x25, 0x54, 0x7F, 0x24, 0x53, 0x7E, 0x24, 0x52, 0x7D, 0x23, 0x52, 0x7D, 0x23, 0x51, 0x7C, 0x22, 0x50, 0x7B, 0x21, 0x4F, 0x7A, 0x21, 0x4F, 0x79, 0x20, 0x4E, 0x79, 0x20, 0x4D, 0x78,
          0x1F, 0x4D, 0x77, 0x1F, 0x4C, 0x77, 0x1E, 0x4B, 0x76, 0x1E, 0x4B, 0x75,
    0x40, 0x76, 0xA5, 0x40, 0x76, 0xA5, 0x40, 0x76, 0xA5, 0x40, 0x76, 0xA5, 0x40, 0x76, 0xA5, 0x40, 0x76, 0xA5, 0x40, 0x76, 0xA5, 0x40, 0x76, 0xA5, 0x40, 0x76, 0xA4, 0x40, 0x75, 0xA4, 0x3F, 0x75, 0xA4, 0x3F, 0x75, 0xA4, 0x3F, 0x75, 0xA3, 0x3F, 0x74, 0xA3,
          0x3E, 0x74, 0xA2, 0x3E, 0x73, 0xA2, 0x3E, 0x73, 0xA1, 0x3D, 0x72, 0xA1, 0x3D, 0x72, 0xA0, 0x3C, 0x71, 0xA0, 0x3C, 0x71, 0x9F, 0x3B, 0x70, 0x9E, 0x3B, 0x6F, 0x9E, 0x3A, 0x6F, 0x9D, 0x3A, 0x6E, 0x9C, 0x39, 0x6D, 0x9B, 0x39, 0x6D, 0x9B,
          0x38, 0x6C, 0x9A, 0x38, 0x6B, 0x99, 0x37, 0x6B, 0x98, 0x36, 0x6A, 0x97, 0x36, 0x69, 0x96, 0x35, 0x68, 0x96, 0x35, 0x67, 0x95, 0x34, 0x67, 0x94, 0x33, 0x66, 0x93, 0x33, 0x65, 0x92, 0x32, 0x64, 0x91, 0x31, 0x63, 0x90, 0x30, 0x62, 0x8F,
          0x30, 0x62, 0x8E, 0x2F, 0x61, 0x8D, 0x2F, 0x60, 0x8D, 0x2E, 0x5F, 0x8B, 0x2D, 0x5E, 0x8B, 0x2D, 0x5D, 0x8A, 0x2C, 0x5D, 0x89, 0x2B, 0x5C, 0x88, 0x2A, 0x5B, 0x87, 0x2A, 0x5A, 0x86, 0x29, 0x59, 0x85, 0x61, 0x84, 0xA5, 0xBD, 0xCC, 0xD9,
          0xD3, 0xDD, 0xE6, 0xCE, 0xD9, 0xE3, 0xAE, 0xC0, 0xD1, 0x5A, 0x7E, 0x9F, 0x25, 0x53, 0x7F, 0x27, 0x55, 0x80, 0x47, 0x6E, 0x93, 0x62, 0x84, 0xA3, 0x51, 0x76, 0x98, 0x23, 0x51, 0x7B, 0x21, 0x4F, 0x7A, 0x20, 0x4E, 0x79, 0x20, 0x4D, 0x78,
          0x1F, 0x4D, 0x77, 0x1F, 0x4C, 0x77, 0x1E, 0x4C, 0x76, 0x1E, 0x4B, 0x75,
    0x41, 0x77, 0xA6, 0x41, 0x77, 0xA6, 0x41, 0x77, 0xA6, 0x41, 0x77, 0xA6, 0x41, 0x77, 0xA6, 0x41, 0x77, 0xA6, 0x41, 0x77, 0xA6, 0x41, 0x76, 0xA5, 0x41, 0x76, 0xA5, 0x40, 0x76, 0xA5, 0x40, 0x76, 0xA5, 0x40, 0x75, 0xA4, 0x40, 0x75, 0xA4, 0x3F, 0x75, 0xA4,
          0x3F, 0x74, 0xA3, 0x3F, 0x74, 0xA3, 0x3E, 0x73, 0xA2, 0x3E, 0x73, 0xA2, 0x3D, 0x72, 0xA1, 0x3D, 0x72, 0xA0, 0x3D, 0x71, 0xA0, 0x3C, 0x71, 0x9F, 0x3C, 0x70, 0x9E, 0x3B, 0x6F, 0x9E, 0x3B, 0x6F, 0x9D, 0x3A, 0x6E, 0x9C, 0x39, 0x6D, 0x9B,
          0x39, 0x6D, 0x9B, 0x38, 0x6C, 0x9A, 0x38, 0x6B, 0x99, 0x37, 0x6A, 0x98, 0x36, 0x69, 0x97, 0x36, 0x69, 0x96, 0x35, 0x68, 0x95, 0x34, 0x67, 0x94, 0x34, 0x66, 0x93, 0x33, 0x65, 0x93, 0x32, 0x65, 0x92, 0x32, 0x64, 0x91, 0x31, 0x63, 0x90,
          0x30, 0x62, 0x8F, 0x30, 0x61, 0x8E, 0x2F, 0x60, 0x8D, 0x2E, 0x5F, 0x8C, 0x2E, 0x5F, 0x8B, 0x2D, 0x5E, 0x8A, 0x2C, 0x5D, 0x89, 0x2B, 0x5C, 0x88, 0x2B, 0x5B, 0x87, 0x35, 0x63, 0x8D, 0x73, 0x93, 0xB0, 0xB6, 0xC7, 0xD6, 0xD2, 0xDD, 0xE6,
          0xDE, 0xE6, 0xED, 0xDC, 0xE4, 0xEB, 0xC7, 0xD3, 0xDF, 0x89, 0xA4, 0xBC, 0x2C, 0x5A, 0x84, 0x70, 0x8F, 0xAC, 0xB5, 0xC6, 0xD5, 0xAE, 0xC0, 0xD0, 0x91, 0xA9, 0xBF, 0x62, 0x84, 0xA4, 0x39, 0x63, 0x8A, 0x26, 0x53, 0x7D, 0x20, 0x4E, 0x78,
          0x1F, 0x4D, 0x78, 0x1F, 0x4C, 0x77, 0x1F, 0x4C, 0x76, 0x1E, 0x4B, 0x76,
    0x41, 0x77, 0xA6, 0x41, 0x77, 0xA6, 0x41, 0x77, 0xA7, 0x41, 0x78, 0xA7, 0x42, 0x78, 0xA7, 0x41, 0x78, 0xA7, 0x41, 0x77, 0xA6, 0x41, 0x77, 0xA6, 0x41, 0x77, 0xA6, 0x41, 0x77, 0xA6, 0x41, 0x77, 0xA6, 0x41, 0x76, 0xA5, 0x40, 0x76, 0xA5, 0x40, 0x76, 0xA4,
          0x3F, 0x75, 0xA4, 0x3F, 0x75, 0xA3, 0x3F, 0x74, 0xA3, 0x3E, 0x74, 0xA2, 0x3E, 0x73, 0xA2, 0x3D, 0x73, 0xA1, 0x3D, 0x72, 0xA0, 0x3D, 0x71, 0xA0, 0x3C, 0x71, 0x9F, 0x3B, 0x70, 0x9E, 0x3B, 0x6F, 0x9E, 0x3A, 0x6F, 0x9D, 0x3A, 0x6E, 0x9C,
          0x39, 0x6D, 0x9B, 0x39, 0x6C, 0x9A, 0x38, 0x6C, 0x99, 0x37, 0x6B, 0x98, 0x37, 0x6A, 0x98, 0x36, 0x69, 0x97, 0x35, 0x68, 0x96, 0x35, 0x68, 0x95, 0x34, 0x67, 0x94, 0x33, 0x66, 0x93, 0x33, 0x65, 0x92, 0x32, 0x64, 0x91, 0x31, 0x63, 0x90,
          0x31, 0x62, 0x8F, 0x30, 0x62, 0x8E, 0x2F, 0x61, 0x8D, 0x2E, 0x60, 0x8C, 0x33, 0x63, 0x8E, 0x3A, 0x68, 0x92, 0x32, 0x61, 0x8D, 0x2C, 0x5C, 0x89, 0x2E, 0x5E, 0x89, 0x59, 0x7F, 0xA2, 0xA9, 0xBD, 0xCF, 0xCC, 0xD8, 0xE3, 0xE2, 0xE9, 0xEF,
          0xEB, 0xEF, 0xF3, 0xDE, 0xE5, 0xEC, 0xC4, 0xD2, 0xDE, 0xAA, 0xBD, 0xCF, 0xAC, 0xBF, 0xD0, 0xC6, 0xD3, 0xDF, 0xD0, 0xDA, 0xE4, 0xD1, 0xDC, 0xE5, 0xC9, 0xD5, 0xE0, 0xB2, 0xC3, 0xD2, 0xA4, 0xB8, 0xCB, 0x83, 0x9E, 0xB7, 0x2E, 0x5A, 0x82,
          0x20, 0x4D, 0x78, 0x1F, 0x4C, 0x77, 0x1F, 0x4C, 0x76, 0x1E, 0x4B, 0x76,
    0x42, 0x78, 0xA7, 0x42, 0x78, 0xA7, 0x42, 0x78, 0xA7, 0x42, 0x78, 0xA7, 0x42, 0x78, 0xA8, 0x42, 0x78, 0xA7, 0x42, 0x78, 0xA7, 0x42, 0x78, 0xA7, 0x42, 0x78, 0xA7, 0x41, 0x78, 0xA7, 0x41, 0x77, 0xA6, 0x41, 0x77, 0xA6, 0x41, 0x77, 0xA6, 0x40, 0x76, 0xA5,
          0x40, 0x76, 0xA5, 0x40, 0x75, 0xA4, 0x3F, 0x75, 0xA4, 0x3F, 0x74, 0xA3, 0x3F, 0x74, 0xA2, 0x3E, 0x73, 0xA2, 0x3D, 0x73, 0xA1, 0x3D, 0x72, 0xA0, 0x3C, 0x71, 0xA0, 0x3C, 0x71, 0x9F, 0x3B, 0x70, 0x9E, 0x3B, 0x6F, 0x9D, 0x3A, 0x6E, 0x9C,
          0x3A, 0x6E, 0x9C, 0x39, 0x6D, 0x9B, 0x38, 0x6C, 0x9A, 0x38, 0x6B, 0x99, 0x37, 0x6A, 0x98, 0x36, 0x6A, 0x97, 0x36, 0x69, 0x96, 0x35, 0x68, 0x95, 0x34, 0x67, 0x94, 0x34, 0x66, 0x93, 0x33, 0x65, 0x93, 0x32, 0x65, 0x92, 0x32, 0x64, 0x91,
          0x31, 0x63, 0x90, 0x36, 0x67, 0x92, 0x3A, 0x6A, 0x94, 0x75, 0x97, 0xB4, 0x9F, 0xB6, 0xCB, 0xB5, 0xC6, 0xD6, 0x9C, 0xB3, 0xC9, 0x46, 0x71, 0x98, 0x2D, 0x5D, 0x89, 0x2D, 0x5D, 0x88, 0x90, 0xAA, 0xC2, 0xDD, 0xE5, 0xEC, 0xEF, 0xF3, 0xF6,
          0xF0, 0xF3, 0xF7, 0xE4, 0xEA, 0xF0, 0xD4, 0xDE, 0xE7, 0xDA, 0xE2, 0xEA, 0xE3, 0xE9, 0xEF, 0xE5, 0xEB, 0xF1, 0xE9, 0xEE, 0xF2, 0xEC, 0xF0, 0xF4, 0xE4, 0xEA, 0xF0, 0xDA, 0xE2, 0xEA, 0xD1, 0xDB, 0xE4, 0xB5, 0xC5, 0xD4, 0x62, 0x84, 0xA4,
          0x2B, 0x58, 0x81, 0x1F, 0x4D, 0x77, 0x1F, 0x4C, 0x77, 0x1E, 0x4B, 0x76,
    0x42, 0x79, 0xA8, 0x43, 0x79, 0xA8, 0x43, 0x79, 0xA8, 0x43, 0x79, 0xA8, 0x43, 0x79, 0xA8, 0x43, 0x79, 0xA8, 0x43, 0x79, 0xA8, 0x42, 0x79, 0xA8, 0x42, 0x78, 0xA7, 0x42, 0x78, 0xA7, 0x42, 0x78, 0xA7, 0x42, 0x78, 0xA7, 0x41, 0x77, 0xA6, 0x41, 0x77, 0xA6,
          0x41, 0x76, 0xA5, 0x40, 0x76, 0xA5, 0x40, 0x75, 0xA4, 0x3F, 0x75, 0xA4, 0x3F, 0x74, 0xA3, 0x3E, 0x74, 0xA2, 0x3E, 0x73, 0xA2, 0x3D, 0x72, 0xA1, 0x3D, 0x72, 0xA0, 0x3C, 0x71, 0x9F, 0x3C, 0x70, 0x9F, 0x3B, 0x70, 0x9E, 0x3A, 0x6F, 0x9D,
          0x3A, 0x6E, 0x9C, 0x39, 0x6D, 0x9B, 0x39, 0x6C, 0x9A, 0x38, 0x6C, 0x99, 0x37, 0x6B, 0x99, 0x37, 0x6A, 0x98, 0x36, 0x69, 0x97, 0x35, 0x68, 0x96, 0x35, 0x67, 0x95, 0x34, 0x67, 0x94, 0x33, 0x66, 0x93, 0x33, 0x65, 0x92, 0x39, 0x6A, 0x95,
          0x73, 0x96, 0xB5, 0xA5, 0xBB, 0xCF, 0xB3, 0xC6, 0xD6, 0xCE, 0xDA, 0xE5, 0xE2, 0xE9, 0xEF, 0xDE, 0xE6, 0xED, 0xC7, 0xD5, 0xE1, 0x78, 0x98, 0xB5, 0x60, 0x85, 0xA7, 0x5F, 0x84, 0xA6, 0xC0, 0xCF, 0xDC, 0xEE, 0xF3, 0xF6, 0xF3, 0xF6, 0xF8,
          0xF1, 0xF4, 0xF7, 0xEB, 0xEF, 0xF4, 0xE8, 0xED, 0xF2, 0xEE, 0xF2, 0xF6, 0xF1, 0xF4, 0xF7, 0xF1, 0xF4, 0xF7, 0xE9, 0xEE, 0xF3, 0xE6, 0xEC, 0xF1, 0xE3, 0xE9, 0xEF, 0xDF, 0xE6, 0xED, 0xD0, 0xDB, 0xE4, 0xB4, 0xC4, 0xD4, 0x9B, 0xB2, 0xC6,
          0x86, 0xA1, 0xBA, 0x68, 0x89, 0xA8, 0x61, 0x83, 0xA3, 0x57, 0x7B, 0x9C,
    0x43, 0x79, 0xA9, 0x43, 0x7A, 0xA9, 0x43, 0x7A, 0xA9, 0x43, 0x7A, 0xA9, 0x43, 0x7A, 0xA9, 0x43, 0x7A, 0xA9, 0x44, 0x7B, 0xAA, 0x49, 0x7E, 0xAD, 0x43, 0x79, 0xA8, 0x42, 0x79, 0xA8, 0x42, 0x79, 0xA8, 0x42, 0x78, 0xA7, 0x42, 0x78, 0xA7, 0x41, 0x77, 0xA7,
          0x41, 0x77, 0xA6, 0x41, 0x76, 0xA5, 0x40, 0x76, 0xA5, 0x40, 0x76, 0xA4, 0x3F, 0x75, 0xA4, 0x3F, 0x74, 0xA3, 0x3E, 0x74, 0xA2, 0x3E, 0x73, 0xA1, 0x3D, 0x72, 0xA1, 0x3D, 0x72, 0xA0, 0x3C, 0x71, 0x9F, 0x3B, 0x70, 0x9E, 0x3B, 0x6F, 0x9D,
          0x3A, 0x6E, 0x9D, 0x3A, 0x6E, 0x9C, 0x39, 0x6D, 0x9B, 0x38, 0x6C, 0x9A, 0x38, 0x6B, 0x99, 0x37, 0x6A, 0x98, 0x36, 0x6A, 0x97, 0x36, 0x69, 0x96, 0x35, 0x68, 0x95, 0x46, 0x75, 0x9E, 0x47, 0x75, 0x9E, 0x3B, 0x6B, 0x97, 0x7E, 0x9E, 0xBB,
          0xC2, 0xD1, 0xDF, 0xE2, 0xEA, 0xF0, 0xEF, 0xF3, 0xF6, 0xF6, 0xF9, 0xFB, 0xF6, 0xF8, 0xFA, 0xF0, 0xF4, 0xF7, 0xE4, 0xEA, 0xF0, 0xCC, 0xD9, 0xE4, 0xDE, 0xE6, 0xED, 0xE1, 0xE8, 0xEF, 0xE6, 0xEC, 0xF1, 0xF5, 0xF8, 0xFA, 0xEF, 0xF3, 0xF6,
          0xE8, 0xED, 0xF2, 0xE6, 0xEC, 0xF1, 0xEF, 0xF3, 0xF6, 0xF7, 0xF9, 0xFA, 0xF5, 0xF8, 0xF9, 0xF0, 0xF3, 0xF7, 0xE4, 0xEA, 0xF0, 0xDD, 0xE5, 0xEC, 0xD9, 0xE2, 0xEA, 0xD2, 0xDC, 0xE5, 0xC3, 0xD1, 0xDD, 0xBA, 0xCA, 0xD8, 0xC6, 0xD3, 0xDF,
          0xD5, 0xDF, 0xE7, 0xD2, 0xDC, 0xE5, 0xD2, 0xDC, 0xE6, 0xB2, 0xC4, 0xD4,
    0x43, 0x7A, 0xA9, 0x44, 0x7A, 0xAA, 0x44, 0x7A, 0xAA, 0x44, 0x7A, 0xAA, 0x44, 0x7A, 0xAA, 0x44, 0x7A, 0xAA, 0x44, 0x7B, 0xAA, 0x4B, 0x81, 0xAF, 0x43, 0x7A, 0xA9, 0x43, 0x7A, 0xA9, 0x43, 0x79, 0xA9, 0x43, 0x79, 0xA8, 0x42, 0x78, 0xA8, 0x42, 0x78, 0xA7,
          0x41, 0x78, 0xA7, 0x41, 0x77, 0xA6, 0x41, 0x76, 0xA6, 0x40, 0x76, 0xA5, 0x40, 0x75, 0xA4, 0x3F, 0x75, 0xA4, 0x3F, 0x75, 0xA3, 0x3E, 0x73, 0xA2, 0x3E, 0x73, 0xA1, 0x3D, 0x72, 0xA1, 0x3C, 0x71, 0xA0, 0x3C, 0x71, 0x9F, 0x3B, 0x70, 0x9E,
          0x3B, 0x6F, 0x9D, 0x3A, 0x6E, 0x9C, 0x39, 0x6D, 0x9B, 0x39, 0x6C, 0x9A, 0x38, 0x6C, 0x99, 0x37, 0x6B, 0x99, 0x37, 0x6A, 0x97, 0x36, 0x69, 0x97, 0x44, 0x74, 0x9E, 0x8F, 0xAC, 0xC5, 0x9D, 0xB6, 0xCD, 0xAE, 0xC3, 0xD5, 0xD4, 0xDF, 0xE9,
          0xE9, 0xEE, 0xF3, 0xF4, 0xF6, 0xF9, 0xFB, 0xFC, 0xFD, 0xFC, 0xFD, 0xFD, 0xF8, 0xFA, 0xFC, 0xF2, 0xF5, 0xF8, 0xF5, 0xF7, 0xFA, 0xEF, 0xF3, 0xF6, 0xF6, 0xF8, 0xFA, 0xFC, 0xFC, 0xFD, 0xFA, 0xFB, 0xFD, 0xF2, 0xF6, 0xF8, 0xEB, 0xF0, 0xF4,
          0xE3, 0xE9, 0xEF, 0xE2, 0xE9, 0xEF, 0xEC, 0xF1, 0xF5, 0xF5, 0xF7, 0xF9, 0xF3, 0xF6, 0xF8, 0xE8, 0xEE, 0xF2, 0xDC, 0xE4, 0xEB, 0xD3, 0xDE, 0xE7, 0xCF, 0xDA, 0xE5, 0xC5, 0xD3, 0xDF, 0xBD, 0xCC, 0xDA, 0xB8, 0xC9, 0xD7, 0xC3, 0xD1, 0xDD,
          0xDA, 0xE3, 0xEA, 0xE9, 0xEE, 0xF2, 0xDD, 0xE5, 0xEC, 0xBE, 0xCD, 0xDA,
    0x44, 0x7B, 0xAA, 0x44, 0x7B, 0xAA, 0x44, 0x7B, 0xAA, 0x44, 0x7B, 0xAB, 0x44, 0x7B, 0xAA, 0x44, 0x7B, 0xAA, 0x44, 0x7B, 0xAA, 0x45, 0x7C, 0xAB, 0x44, 0x7B, 0xAA, 0x44, 0x7A, 0xA9, 0x43, 0x7A, 0xA9, 0x43, 0x7A, 0xA9, 0x43, 0x79, 0xA8, 0x42, 0x79, 0xA8,
          0x42, 0x78, 0xA7, 0x42, 0x78, 0xA7, 0x41, 0x77, 0xA6, 0x41, 0x77, 0xA5, 0x40, 0x76, 0xA5, 0x40, 0x75, 0xA4, 0x3F, 0x75, 0xA3, 0x3F, 0x74, 0xA3, 0x40, 0x75, 0xA3, 0x45, 0x78, 0xA6, 0x3D, 0x72, 0xA0, 0x3C, 0x71, 0x9F, 0x3B, 0x70, 0x9E,
          0x3B, 0x6F, 0x9E, 0x3A, 0x6F, 0x9D, 0x3A, 0x6E, 0x9C, 0x39, 0x6D, 0x9B, 0x38, 0x6C, 0x9A, 0x38, 0x6B, 0x99, 0x37, 0x6A, 0x98, 0x36, 0x69, 0x97, 0x4A, 0x78, 0xA1, 0xA1, 0xB9, 0xCF, 0xC7, 0xD6, 0xE3, 0xDB, 0xE4, 0xED, 0xEE, 0xF3, 0xF7,
          0xF8, 0xF9, 0xFB, 0xFC, 0xFC, 0xFD, 0xFD, 0xFE, 0xFE, 0xFC, 0xFD, 0xFD, 0xF9, 0xFB, 0xFC, 0xF5, 0xF8, 0xFA, 0xF3, 0xF6, 0xF9, 0xF4, 0xF7, 0xF9, 0xF8, 0xF9, 0xFB, 0xFD, 0xFE, 0xFE, 0xFD, 0xFD, 0xFE, 0xFA, 0xFB, 0xFC, 0xEE, 0xF2, 0xF6,
          0xDE, 0xE6, 0xED, 0xDC, 0xE4, 0xEC, 0xE9, 0xEE, 0xF3, 0xF0, 0xF3, 0xF6, 0xEA, 0xEF, 0xF3, 0xE3, 0xE9, 0xEF, 0xD8, 0xE1, 0xEA, 0xCE, 0xDA, 0xE4, 0xC8, 0xD5, 0xE0, 0xBF, 0xCD, 0xDB, 0xB7, 0xC7, 0xD7, 0xB2, 0xC4, 0xD4, 0xBC, 0xCC, 0xDA,
          0xCB, 0xD7, 0xE2, 0xE1, 0xE8, 0xEE, 0xD7, 0xE0, 0xE9, 0xC0, 0xCF, 0xDC,
    0x5C, 0x8D, 0xB8, 0x55, 0x88, 0xB4, 0x45, 0x7C, 0xAB, 0x45, 0x7C, 0xAB, 0x45, 0x7C, 0xAB, 0x45, 0x7C, 0xAB, 0x45, 0x7C, 0xAB, 0x45, 0x7B, 0xAB, 0x44, 0x7B, 0xAB, 0x44, 0x7B, 0xAA, 0x44, 0x7A, 0xAA, 0x43, 0x7A, 0xA9, 0x45, 0x7B, 0xAA, 0x43, 0x79, 0xA8,
          0x42, 0x79, 0xA8, 0x42, 0x78, 0xA7, 0x41, 0x78, 0xA7, 0x41, 0x77, 0xA6, 0x41, 0x76, 0xA5, 0x40, 0x76, 0xA5, 0x67, 0x93, 0xB9, 0x4B, 0x7E, 0xAA, 0x62, 0x8F, 0xB6, 0x61, 0x8E, 0xB5, 0x51, 0x82, 0xAC, 0x3D, 0x72, 0xA0, 0x3C, 0x70, 0x9F,
          0x3B, 0x70, 0x9E, 0x3B, 0x6F, 0x9D, 0x3A, 0x6E, 0x9C, 0x39, 0x6D, 0x9B, 0x38, 0x6C, 0x9A, 0x38, 0x6C, 0x99, 0x37, 0x6B, 0x98, 0x36, 0x6A, 0x97, 0x3C, 0x6E, 0x9A, 0x89, 0xA8, 0xC3, 0xC8, 0xD7, 0xE3, 0xE0, 0xE8, 0xEF, 0xE7, 0xED, 0xF3,
          0xF7, 0xF9, 0xFB, 0xF8, 0xFA, 0xFC, 0xFD, 0xFE, 0xFE, 0xFC, 0xFD, 0xFE, 0xF7, 0xF9, 0xFB, 0xEF, 0xF3, 0xF7, 0xF2, 0xF5, 0xF8, 0xF2, 0xF5, 0xF8, 0xF6, 0xF8, 0xFA, 0xFC, 0xFD, 0xFD, 0xFD, 0xFD, 0xFE, 0xFD, 0xFE, 0xFE, 0xF3, 0xF6, 0xF9,
          0xE0, 0xE8, 0xEE, 0xDB, 0xE4, 0xEC, 0xE2, 0xE9, 0xEF, 0xE2, 0xE9, 0xEF, 0xE2, 0xE9, 0xEF, 0xE5, 0xEB, 0xF1, 0xDC, 0xE4, 0xEC, 0xD3, 0xDE, 0xE7, 0xC9, 0xD5, 0xE1, 0xBA, 0xCA, 0xD9, 0xB0, 0xC3, 0xD3, 0xAF, 0xC2, 0xD3, 0xBC, 0xCC, 0xDA,
          0xC6, 0xD4, 0xE0, 0xCA, 0xD6, 0xE2, 0xCB, 0xD7, 0xE2, 0xCC, 0xD7, 0xE2,
    0xB9, 0xD1, 0xE4, 0xC0, 0xD5, 0xE8, 0x98, 0xB9, 0xD6, 0x7A, 0xA5, 0xC8, 0x81, 0xAA, 0xCC, 0x47, 0x7E, 0xAE, 0x45, 0x7C, 0xAC, 0x45, 0x7C, 0xAB, 0x45, 0x7C, 0xAB, 0x45, 0x7B, 0xAB, 0x44, 0x7B, 0xAA, 0x44, 0x7B, 0xAA, 0x49, 0x7F, 0xAD, 0x43, 0x7A, 0xA9,
          0x43, 0x79, 0xA8, 0x42, 0x79, 0xA8, 0x42, 0x78, 0xA7, 0x41, 0x77, 0xA6, 0x41, 0x77, 0xA6, 0x45, 0x7A, 0xA8, 0x74, 0x9D, 0xC0, 0x76, 0x9E, 0xC1, 0x66, 0x93, 0xB9, 0x61, 0x8E, 0xB6, 0x80, 0xA4, 0xC4, 0x65, 0x90, 0xB6, 0x3C, 0x71, 0x9F,
          0x3B, 0x70, 0x9E, 0x3B, 0x6F, 0x9D, 0x3A, 0x6E, 0x9C, 0x39, 0x6D, 0x9C, 0x39, 0x6D, 0x9B, 0x38, 0x6C, 0x9A, 0x37, 0x6B, 0x99, 0x37, 0x6A, 0x98, 0x36, 0x69, 0x97, 0x52, 0x7F, 0xA6, 0xB0, 0xC5, 0xD7, 0xC9, 0xD7, 0xE4, 0xC0, 0xD0, 0xDF,
          0xE7, 0xED, 0xF3, 0xEE, 0xF2, 0xF6, 0xF4, 0xF7, 0xF9, 0xFA, 0xFB, 0xFC, 0xFA, 0xFB, 0xFC, 0xF1, 0xF4, 0xF8, 0xEE, 0xF2, 0xF7, 0xED, 0xF1, 0xF5, 0xEE, 0xF2, 0xF6, 0xEF, 0xF3, 0xF7, 0xF0, 0xF4, 0xF7, 0xF2, 0xF5, 0xF8, 0xEB, 0xF0, 0xF4,
          0xDD, 0xE5, 0xED, 0xD5, 0xE0, 0xE9, 0xE0, 0xE7, 0xEE, 0xE4, 0xEB, 0xF0, 0xDD, 0xE5, 0xED, 0xDB, 0xE3, 0xEB, 0xD2, 0xDD, 0xE7, 0xCC, 0xD8, 0xE3, 0xC2, 0xD1, 0xDD, 0xB6, 0xC7, 0xD7, 0xAD, 0xC1, 0xD2, 0xAC, 0xC0, 0xD1, 0xB2, 0xC4, 0xD5,
          0xBA, 0xCA, 0xD9, 0xC5, 0xD2, 0xDF, 0xD2, 0xDC, 0xE6, 0xDD, 0xE5, 0xEC,
    0xCC, 0xDE, 0xED, 0xC8, 0xDB, 0xEB, 0xBE, 0xD4, 0xE7, 0xB4, 0xCD, 0xE3, 0x9C, 0xBD, 0xD9, 0x67, 0x97, 0xC0, 0x5E, 0x91, 0xBC, 0x4B, 0x82, 0xB0, 0x45, 0x7C, 0xAC, 0x45, 0x7C, 0xAB, 0x45, 0x7C, 0xAB, 0x52, 0x86, 0xB3, 0x61, 0x92, 0xBC, 0x45, 0x7C, 0xAB,
          0x43, 0x7A, 0xA9, 0x43, 0x79, 0xA8, 0x42, 0x79, 0xA8, 0x42, 0x78, 0xA7, 0x41, 0x77, 0xA6, 0x41, 0x76, 0xA5, 0x58, 0x89, 0xB3, 0x78, 0xA0, 0xC2, 0x84, 0xA8, 0xC7, 0x75, 0x9D, 0xC0, 0x7D, 0xA3, 0xC3, 0x6E, 0x98, 0xBC, 0x43, 0x77, 0xA4,
          0x3C, 0x70, 0x9F, 0x3C, 0x70, 0x9F, 0x3A, 0x6F, 0x9D, 0x3A, 0x6E, 0x9C, 0x39, 0x6D, 0x9B, 0x38, 0x6C, 0x9A, 0x38, 0x6B, 0x99, 0x37, 0x6A, 0x98, 0x36, 0x69, 0x97, 0x36, 0x69, 0x96, 0x5D, 0x87, 0xAC, 0x8D, 0xAB, 0xC6, 0xA8, 0xBE, 0xD3,
          0xD2, 0xDE, 0xE8, 0xE3, 0xEA, 0xF1, 0xEC, 0xF1, 0xF5, 0xF2, 0xF5, 0xF8, 0xF5, 0xF7, 0xFA, 0xE9, 0xEE, 0xF4, 0xE1, 0xE9, 0xF0, 0xDE, 0xE7, 0xEE, 0xE0, 0xE8, 0xEF, 0xE0, 0xE8, 0xEF, 0xDF, 0xE7, 0xEE, 0xDE, 0xE6, 0xED, 0xDB, 0xE4, 0xEC,
          0xD4, 0xDF, 0xE8, 0xCD, 0xD9, 0xE4, 0xD3, 0xDE, 0xE7, 0xDB, 0xE4, 0xEC, 0xD9, 0xE2, 0xEA, 0xD2, 0xDD, 0xE7, 0xC2, 0xD1, 0xDE, 0xBB, 0xCB, 0xDA, 0xB5, 0xC7, 0xD6, 0xAE, 0xC2, 0xD3, 0xAF, 0xC2, 0xD3, 0xAC, 0xBF, 0xD2, 0xAC, 0xC0, 0xD2,
          0xB2, 0xC4, 0xD5, 0xBC, 0xCC, 0xDB, 0xC1, 0xCF, 0xDD, 0xCC, 0xD8, 0xE3,
    0xCB, 0xDD, 0xEC, 0xC4, 0xD8, 0xE9, 0xBF, 0xD5, 0xE7, 0xBB, 0xD2, 0xE5, 0x9F, 0xC0, 0xDA, 0x89, 0xB0, 0xD1, 0x8F, 0xB4, 0xD3, 0x94, 0xB7, 0xD5, 0x6C, 0x9A, 0xC1, 0x47, 0x7E, 0xAD, 0x4C, 0x81, 0xAF, 0x64, 0x94, 0xBD, 0x54, 0x88, 0xB5, 0x44, 0x7B, 0xAA,
          0x43, 0x7A, 0xA9, 0x43, 0x79, 0xA9, 0x42, 0x79, 0xA8, 0x42, 0x78, 0xA7, 0x42, 0x78, 0xA7, 0x53, 0x84, 0xAF, 0x75, 0x9D, 0xC0, 0x8A, 0xAD, 0xCA, 0x8E, 0xAF, 0xCC, 0x85, 0xA9, 0xC7, 0x76, 0x9E, 0xC0, 0x80, 0xA5, 0xC4, 0x7A, 0xA0, 0xC1,
          0x5C, 0x8A, 0xB2, 0x70, 0x98, 0xBB, 0x4E, 0x7E, 0xA8, 0x3A, 0x6E, 0x9C, 0x39, 0x6D, 0x9B, 0x39, 0x6C, 0x9A, 0x38, 0x6B, 0x99, 0x37, 0x6A, 0x98, 0x36, 0x6A, 0x97, 0x36, 0x69, 0x96, 0x54, 0x81, 0xA8, 0x8E, 0xAC, 0xC7, 0xB2, 0xC6, 0xD8,
          0xCA, 0xD8, 0xE4, 0xD3, 0xDE, 0xE8, 0xD9, 0xE3, 0xEC, 0xE1, 0xE9, 0xEF, 0xE3, 0xEB, 0xF1, 0xDE, 0xE7, 0xEE, 0xD5, 0xE0, 0xEA, 0xD4, 0xDF, 0xE8, 0xD4, 0xDF, 0xE8, 0xD4, 0xDF, 0xE8, 0xD1, 0xDD, 0xE7, 0xD1, 0xDD, 0xE7, 0xCD, 0xD9, 0xE5,
          0xC9, 0xD6, 0xE2, 0xC6, 0xD4, 0xE1, 0xCA, 0xD7, 0xE2, 0xCE, 0xDA, 0xE5, 0xCA, 0xD7, 0xE2, 0xC3, 0xD2, 0xDF, 0xBB, 0xCC, 0xDA, 0xB2, 0xC5, 0xD6, 0xAD, 0xC1, 0xD3, 0xA9, 0xBE, 0xD0, 0xAB, 0xBF, 0xD1, 0xAA, 0xBF, 0xD1, 0xAB, 0xC0, 0xD2,
          0xA9, 0xBE, 0xD0, 0xB1, 0xC4, 0xD5, 0xB1, 0xC4, 0xD5, 0xBC, 0xCC, 0xDA,
    0xCC, 0xDE, 0xED, 0xCA, 0xDC, 0xEC, 0xC6, 0xDA, 0xEA, 0xC4, 0xD8, 0xE9, 0xB7, 0xD0, 0xE4, 0xB2, 0xCC, 0xE1, 0xB8, 0xCF, 0xE3, 0xBC, 0xD2, 0xE5, 0xB1, 0xCB, 0xE0, 0x64, 0x94, 0xBD, 0x51, 0x86, 0xB3, 0x80, 0xA9, 0xCB, 0x7D, 0xA6, 0xC9, 0x4F, 0x83, 0xB1,
          0x44, 0x7A, 0xAA, 0x43, 0x7A, 0xA9, 0x43, 0x79, 0xA8, 0x43, 0x79, 0xA8, 0x75, 0x9E, 0xC1, 0x9D, 0xBB, 0xD4, 0xA9, 0xC3, 0xD9, 0xAD, 0xC6, 0xDA, 0xA6, 0xC1, 0xD7, 0xAA, 0xC3, 0xD9, 0xB3, 0xCA, 0xDD, 0xBB, 0xCF, 0xE0, 0xB1, 0xC7, 0xDB,
          0x9E, 0xBA, 0xD2, 0xA4, 0xBE, 0xD4, 0x73, 0x9A, 0xBC, 0x46, 0x77, 0xA3, 0x55, 0x83, 0xAB, 0x48, 0x79, 0xA3, 0x3F, 0x71, 0x9E, 0x37, 0x6B, 0x98, 0x36, 0x6A, 0x97, 0x36, 0x69, 0x96, 0x5E, 0x88, 0xAE, 0x9A, 0xB5, 0xCD, 0xB0, 0xC5, 0xD8,
          0xC4, 0xD4, 0xE2, 0xD1, 0xDD, 0xE8, 0xE0, 0xE8, 0xEF, 0xDF, 0xE7, 0xEF, 0xDE, 0xE7, 0xEE, 0xD9, 0xE2, 0xEB, 0xD1, 0xDD, 0xE7, 0xCC, 0xD9, 0xE5, 0xC8, 0xD6, 0xE3, 0xC8, 0xD6, 0xE2, 0xC5, 0xD3, 0xE0, 0xC4, 0xD3, 0xE0, 0xC1, 0xD0, 0xDE,
          0xC0, 0xD0, 0xDE, 0xC5, 0xD3, 0xE0, 0xC6, 0xD4, 0xE1, 0xC3, 0xD2, 0xDF, 0xBD, 0xCD, 0xDC, 0xB7, 0xC9, 0xD9, 0xB2, 0xC5, 0xD6, 0xAD, 0xC1, 0xD3, 0xA7, 0xBD, 0xD0, 0xA2, 0xB9, 0xCD, 0xA2, 0xB8, 0xCD, 0xA2, 0xB8, 0xCD, 0xA1, 0xB8, 0xCC,
          0xA1, 0xB8, 0xCC, 0xA4, 0xBA, 0xCE, 0xA7, 0xBC, 0xCF, 0xAF, 0xC2, 0xD3,
    0xD1, 0xE1, 0xEF, 0xCF, 0xE0, 0xEE, 0xCC, 0xDD, 0xEC, 0xCB, 0xDD, 0xEC, 0xC7, 0xDA, 0xEA, 0xBF, 0xD5, 0xE7, 0xBB, 0xD2, 0xE5, 0xB9, 0xD0, 0xE4, 0xB2, 0xCC, 0xE1, 0x94, 0xB7, 0xD4, 0x86, 0xAD, 0xCD, 0x8E, 0xB3, 0xD2, 0x70, 0x9E, 0xC4, 0x55, 0x88, 0xB4,
          0x4A, 0x80, 0xAE, 0x44, 0x7B, 0xAA, 0x43, 0x79, 0xA9, 0x4B, 0x7F, 0xAD, 0x9E, 0xBC, 0xD5, 0xAE, 0xC7, 0xDC, 0xBF, 0xD3, 0xE3, 0xC6, 0xD7, 0xE6, 0xD3, 0xE0, 0xEB, 0xD6, 0xE2, 0xEC, 0xE2, 0xEB, 0xF2, 0xE9, 0xF0, 0xF5, 0xE8, 0xEF, 0xF5,
          0xE9, 0xEF, 0xF5, 0xDE, 0xE7, 0xF0, 0xC8, 0xD8, 0xE5, 0xA5, 0xBF, 0xD5, 0xA2, 0xBC, 0xD3, 0xAB, 0xC3, 0xD7, 0x9B, 0xB6, 0xCE, 0x4D, 0x7C, 0xA6, 0x37, 0x6A, 0x98, 0x36, 0x69, 0x97, 0x45, 0x75, 0xA0, 0x85, 0xA6, 0xC3, 0xB3, 0xC8, 0xD9,
          0xC6, 0xD5, 0xE3, 0xDD, 0xE6, 0xEE, 0xF0, 0xF4, 0xF7, 0xEB, 0xF0, 0xF5, 0xDE, 0xE7, 0xEE, 0xD4, 0xDF, 0xE9, 0xCC, 0xD9, 0xE5, 0xC6, 0xD5, 0xE2, 0xC3, 0xD2, 0xE0, 0xBE, 0xCF, 0xDE, 0xBA, 0xCC, 0xDC, 0xB8, 0xCA, 0xDA, 0xB9, 0xCB, 0xDA,
          0xB8, 0xCA, 0xDA, 0xBF, 0xCF, 0xDD, 0xC0, 0xD0, 0xDE, 0xBC, 0xCD, 0xDB, 0xB6, 0xC8, 0xD8, 0xB1, 0xC5, 0xD6, 0xAE, 0xC2, 0xD4, 0xA9, 0xBE, 0xD1, 0xA4, 0xBA, 0xCE, 0x9F, 0xB7, 0xCC, 0x9C, 0xB5, 0xCA, 0x9D, 0xB5, 0xCA, 0x9C, 0xB4, 0xCA,
          0x9C, 0xB5, 0xCA, 0x9C, 0xB4, 0xCA, 0x9E, 0xB6, 0xCB, 0xA5, 0xBB, 0xCE,
    0xD5, 0xE4, 0xF0, 0xD2, 0xE2, 0xEF, 0xCF, 0xE0, 0xED, 0xCB, 0xDD, 0xEC, 0xC6, 0xDA, 0xEA, 0xC0, 0xD6, 0xE8, 0xBC, 0xD3, 0xE6, 0xBA, 0xD1, 0xE5, 0xB5, 0xCD, 0xE2, 0xAB, 0xC7, 0xDE, 0xA7, 0xC4, 0xDC, 0x9A, 0xBB, 0xD7, 0x73, 0xA0, 0xC6, 0x71, 0x9E, 0xC5,
          0x72, 0x9E, 0xC4, 0x4A, 0x7F, 0xAE, 0x49, 0x7F, 0xAD, 0x7A, 0xA2, 0xC5, 0xB2, 0xCA, 0xDE, 0xBE, 0xD2, 0xE3, 0xD1, 0xDF, 0xEB, 0xE2, 0xEB, 0xF2, 0xEC, 0xF1, 0xF6, 0xEF, 0xF3, 0xF8, 0xF4, 0xF8, 0xFA, 0xF7, 0xF9, 0xFB, 0xF8, 0xFA, 0xFC,
          0xFB, 0xFC, 0xFD, 0xFA, 0xFB, 0xFD, 0xF6, 0xF9, 0xFB, 0xED, 0xF2, 0xF7, 0xE3, 0xEB, 0xF2, 0xEB, 0xF1, 0xF6, 0xE1, 0xE9, 0xF1, 0xB5, 0xCA, 0xDB, 0x70, 0x97, 0xB9, 0x36, 0x69, 0x97, 0x35, 0x68, 0x96, 0x70, 0x97, 0xB9, 0xB9, 0xCC, 0xDC,
          0xD2, 0xDE, 0xE9, 0xEA, 0xF0, 0xF5, 0xF5, 0xF7, 0xF9, 0xEA, 0xEF, 0xF4, 0xDE, 0xE7, 0xEE, 0xD6, 0xE1, 0xEA, 0xCB, 0xD9, 0xE5, 0xC5, 0xD4, 0xE2, 0xBF, 0xCF, 0xDE, 0xBA, 0xCC, 0xDB, 0xB4, 0xC8, 0xD9, 0xB3, 0xC6, 0xD7, 0xB3, 0xC6, 0xD7,
          0xB5, 0xC8, 0xD9, 0xBB, 0xCC, 0xDC, 0xBC, 0xCD, 0xDC, 0xB7, 0xC9, 0xD9, 0xB1, 0xC5, 0xD6, 0xAD, 0xC2, 0xD4, 0xAA, 0xBF, 0xD2, 0xA6, 0xBC, 0xD0, 0xA1, 0xB8, 0xCD, 0x9C, 0xB5, 0xCB, 0x99, 0xB3, 0xC9, 0x98, 0xB2, 0xC8, 0x98, 0xB1, 0xC8,
          0x97, 0xB1, 0xC8, 0x97, 0xB1, 0xC8, 0x98, 0xB1, 0xC8, 0x9B, 0xB4, 0xCA,
    0xD6, 0xE4, 0xF1, 0xD3, 0xE3, 0xF0, 0xCF, 0xE0, 0xEE, 0xCA, 0xDC, 0xEC, 0xC6, 0xDA, 0xEA, 0xC2, 0xD7, 0xE8, 0xBE, 0xD4, 0xE6, 0xBB, 0xD2, 0xE5, 0xB4, 0xCE, 0xE3, 0xB0, 0xCB, 0xE0, 0xAD, 0xC8, 0xDF, 0xA3, 0xC1, 0xDA, 0x9C, 0xBC, 0xD7, 0x91, 0xB4, 0xD2,
          0x8A, 0xAF, 0xCF, 0x4C, 0x81, 0xAF, 0x72, 0x9D, 0xC2, 0xB3, 0xCB, 0xDF, 0xBA, 0xD0, 0xE2, 0xCC, 0xDC, 0xE9, 0xE2, 0xEB, 0xF3, 0xEB, 0xF1, 0xF7, 0xF3, 0xF6, 0xF9, 0xF7, 0xFA, 0xFB, 0xFB, 0xFC, 0xFD, 0xFD, 0xFE, 0xFE, 0xFD, 0xFE, 0xFE,
          0xFD, 0xFE, 0xFE, 0xFD, 0xFE, 0xFE, 0xFA, 0xFC, 0xFD, 0xFA, 0xFB, 0xFC, 0xF8, 0xFA, 0xFC, 0xF7, 0xF9, 0xFB, 0xF1, 0xF5, 0xF8, 0xE3, 0xEB, 0xF2, 0xC9, 0xD8, 0xE5, 0x90, 0xAE, 0xC8, 0x65, 0x8D, 0xB1, 0x84, 0xA5, 0xC1, 0xD6, 0xE2, 0xEB,
          0xE9, 0xEF, 0xF4, 0xF4, 0xF7, 0xF9, 0xF7, 0xF9, 0xFB, 0xF7, 0xF9, 0xFB, 0xF2, 0xF5, 0xF8, 0xF1, 0xF5, 0xF8, 0xE2, 0xEA, 0xF0, 0xD1, 0xDD, 0xE8, 0xBD, 0xCE, 0xDD, 0xB5, 0xC8, 0xD9, 0xB0, 0xC5, 0xD7, 0xAF, 0xC4, 0xD6, 0xB0, 0xC4, 0xD6,
          0xB4, 0xC7, 0xD9, 0xBB, 0xCD, 0xDC, 0xBC, 0xCD, 0xDC, 0xB5, 0xC7, 0xD8, 0xAE, 0xC2, 0xD5, 0xA9, 0xBE, 0xD2, 0xA4, 0xBB, 0xD0, 0xA1, 0xB9, 0xCE, 0x9E, 0xB6, 0xCC, 0x99, 0xB3, 0xCA, 0x97, 0xB1, 0xC8, 0x95, 0xB0, 0xC7, 0x93, 0xAE, 0xC6,
          0x93, 0xAE, 0xC6, 0x92, 0xAD, 0xC5, 0x92, 0xAD, 0xC5, 0x92, 0xAD, 0xC6,
    0xD4, 0xE4, 0xF0, 0xD4, 0xE3, 0xF0, 0xD2, 0xE2, 0xEF, 0xCB, 0xDD, 0xED, 0xC6, 0xDA, 0xEA, 0xC2, 0xD7, 0xE9, 0xBE, 0xD4, 0xE7, 0xB8, 0xD1, 0xE5, 0xAF, 0xCA, 0xE1, 0xAD, 0xC8, 0xDF, 0xAA, 0xC6, 0xDE, 0xA3, 0xC1, 0xDB, 0xA1, 0xC0, 0xD9, 0x9F, 0xBE, 0xD9,
          0x96, 0xB8, 0xD4, 0x7C, 0xA5, 0xC9, 0x8B, 0xB0, 0xCF, 0xB5, 0xCC, 0xE0, 0xC3, 0xD6, 0xE6, 0xD3, 0xE1, 0xEC, 0xEC, 0xF2, 0xF7, 0xF3, 0xF7, 0xFA, 0xF9, 0xFB, 0xFC, 0xFD, 0xFD, 0xFE, 0xFD, 0xFE, 0xFE, 0xFE, 0xFE, 0xFF, 0xFE, 0xFE, 0xFF,
          0xFE, 0xFE, 0xFF, 0xFC, 0xFD, 0xFE, 0xFA, 0xFB, 0xFD, 0xFB, 0xFC, 0xFD, 0xFC, 0xFD, 0xFE, 0xF9, 0xFB, 0xFD, 0xF3, 0xF7, 0xFA, 0xEC, 0xF1, 0xF6, 0xE3, 0xEB, 0xF2, 0xD8, 0xE3, 0xEC, 0xC9, 0xD8, 0xE5, 0xD7, 0xE2, 0xEB, 0xE8, 0xEE, 0xF4,
          0xF6, 0xF9, 0xFB, 0xFB, 0xFC, 0xFD, 0xFD, 0xFD, 0xFE, 0xFD, 0xFE, 0xFE, 0xF8, 0xFA, 0xFC, 0xF5, 0xF7, 0xFA, 0xE3, 0xEA, 0xF1, 0xD0, 0xDC, 0xE7, 0xC0, 0xD1, 0xDF, 0xB8, 0xCB, 0xDC, 0xB4, 0xC8, 0xD9, 0xB1, 0xC5, 0xD7, 0xB2, 0xC6, 0xD8,
          0xB7, 0xC9, 0xDA, 0xBB, 0xCC, 0xDC, 0xB8, 0xCB, 0xDB, 0xB3, 0xC7, 0xD8, 0xAA, 0xC0, 0xD4, 0xA5, 0xBC, 0xD0, 0xA0, 0xB9, 0xCE, 0x9D, 0xB6, 0xCC, 0x99, 0xB3, 0xCA, 0x96, 0xB1, 0xC8, 0x93, 0xAE, 0xC6, 0x90, 0xAC, 0xC5, 0x90, 0xAC, 0xC5,
          0x8F, 0xAB, 0xC4, 0x8E, 0xAA, 0xC3, 0x8E, 0xAB, 0xC4, 0x8E, 0xAA, 0xC4,
    0xD2, 0xE2, 0xF0, 0xD1, 0xE2, 0xEF, 0xD2, 0xE2, 0xEF, 0xCE, 0xE0, 0xEE, 0xC8, 0xDB, 0xEB, 0xC4, 0xD9, 0xEA, 0xBE, 0xD5, 0xE7, 0xB2, 0xCC, 0xE2, 0xA7, 0xC5, 0xDE, 0xA8, 0xC5, 0xDE, 0xA7, 0xC4, 0xDD, 0xA1, 0xC0, 0xDA, 0x94, 0xB7, 0xD5, 0xA1, 0xC0, 0xDA,
          0x98, 0xBA, 0xD6, 0x8D, 0xB2, 0xD1, 0x98, 0xB9, 0xD5, 0xAE, 0xC8, 0xDE, 0xC8, 0xD9, 0xE8, 0xE1, 0xEB, 0xF2, 0xF2, 0xF6, 0xF9, 0xF9, 0xFB, 0xFC, 0xFD, 0xFE, 0xFE, 0xFE, 0xFE, 0xFF, 0xFD, 0xFE, 0xFE, 0xFD, 0xFE, 0xFE, 0xFD, 0xFD, 0xFE,
          0xFB, 0xFC, 0xFD, 0xFB, 0xFC, 0xFD, 0xFA, 0xFB, 0xFD, 0xFC, 0xFD, 0xFE, 0xFD, 0xFE, 0xFE, 0xFD, 0xFD, 0xFE, 0xFB, 0xFC, 0xFD, 0xF7, 0xF9, 0xFB, 0xEF, 0xF3, 0xF7, 0xDB, 0xE5, 0xEE, 0xE0, 0xE9, 0xF0, 0xEE, 0xF2, 0xF7, 0xF4, 0xF7, 0xFA,
          0xF9, 0xFB, 0xFC, 0xF9, 0xFA, 0xFC, 0xFA, 0xFB, 0xFD, 0xF9, 0xFA, 0xFC, 0xF3, 0xF6, 0xF9, 0xE9, 0xEF, 0xF4, 0xDB, 0xE5, 0xED, 0xD9, 0xE3, 0xEC, 0xD9, 0xE3, 0xEC, 0xD6, 0xE1, 0xEA, 0xCE, 0xDB, 0xE7, 0xC0, 0xD1, 0xDF, 0xC2, 0xD2, 0xE0,
          0xC9, 0xD7, 0xE4, 0xC3, 0xD3, 0xE0, 0xBB, 0xCD, 0xDC, 0xB4, 0xC8, 0xD9, 0xAA, 0xC0, 0xD3, 0xA1, 0xB9, 0xCF, 0x9C, 0xB6, 0xCC, 0x99, 0xB3, 0xCA, 0x95, 0xB0, 0xC8, 0x91, 0xAD, 0xC6, 0x8C, 0xA9, 0xC3, 0x89, 0xA7, 0xC2, 0x88, 0xA7, 0xC1,
          0x88, 0xA7, 0xC1, 0x8A, 0xA8, 0xC2, 0x8D, 0xAA, 0xC4, 0x8B, 0xA8, 0xC2,
    0xCD, 0xE0, 0xEE, 0xCC, 0xDE, 0xED, 0xCE, 0xE0, 0xEE, 0xCC, 0xDE, 0xED, 0xC8, 0xDB, 0xEB, 0xC3, 0xD8, 0xE9, 0xB8, 0xD1, 0xE5, 0xAF, 0xCB, 0xE1, 0xAA, 0xC7, 0xDF, 0xA6, 0xC4, 0xDE, 0xA3, 0xC2, 0xDC, 0xA1, 0xC1, 0xDB, 0x9B, 0xBC, 0xD8, 0x9A, 0xBB, 0xD7,
          0x89, 0xAF, 0xD0, 0x7E, 0xA8, 0xCB, 0xA6, 0xC3, 0xDB, 0xD4, 0xE2, 0xEE, 0xD8, 0xE5, 0xEF, 0xEC, 0xF2, 0xF7, 0xF9, 0xFB, 0xFC, 0xFD, 0xFE, 0xFE, 0xFE, 0xFF, 0xFF, 0xFE, 0xFE, 0xFE, 0xFC, 0xFD, 0xFE, 0xFB, 0xFC, 0xFD, 0xF9, 0xFB, 0xFC,
          0xF6, 0xF8, 0xFB, 0xF5, 0xF8, 0xFB, 0xF4, 0xF7, 0xFA, 0xF7, 0xF9, 0xFB, 0xF9, 0xFB, 0xFC, 0xFC, 0xFD, 0xFE, 0xFC, 0xFD, 0xFE, 0xF8, 0xFA, 0xFC, 0xEF, 0xF3, 0xF8, 0xE8, 0xEF, 0xF4, 0xEC, 0xF1, 0xF6, 0xF4, 0xF8, 0xFA, 0xF8, 0xFA, 0xFC,
          0xF9, 0xFB, 0xFC, 0xF7, 0xF9, 0xFB, 0xED, 0xF2, 0xF7, 0xEE, 0xF2, 0xF7, 0xEB, 0xF1, 0xF6, 0xE5, 0xEC, 0xF2, 0xE2, 0xEA, 0xF1, 0xE7, 0xEE, 0xF3, 0xEF, 0xF4, 0xF7, 0xF1, 0xF5, 0xF8, 0xEB, 0xF0, 0xF5, 0xE4, 0xEB, 0xF2, 0xE5, 0xEC, 0xF2,
          0xE1, 0xE9, 0xF0, 0xDB, 0xE4, 0xED, 0xD2, 0xDE, 0xE8, 0xC5, 0xD4, 0xE1, 0xAB, 0xC1, 0xD4, 0x9E, 0xB8, 0xCE, 0x9A, 0xB4, 0xCC, 0x96, 0xB1, 0xC9, 0x90, 0xAD, 0xC6, 0x8A, 0xA8, 0xC3, 0x86, 0xA5, 0xC1, 0x85, 0xA5, 0xC0, 0x85, 0xA4, 0xC0,
          0x85, 0xA5, 0xC0, 0x89, 0xA7, 0xC2, 0x8C, 0xAA, 0xC3, 0x8A, 0xA8, 0xC3,
    0xCA, 0xDD, 0xED, 0xC9, 0xDD, 0xED, 0xC8, 0xDB, 0xEC, 0xC4, 0xD9, 0xEB, 0xC1, 0xD7, 0xE9, 0xBA, 0xD2, 0xE6, 0xB0, 0xCC, 0xE3, 0xAB, 0xC8, 0xE0, 0xA6, 0xC5, 0xDE, 0xA3, 0xC2, 0xDC, 0xA0, 0xC0, 0xDB, 0xA0, 0xC0, 0xDB, 0xA0, 0xC0, 0xDA, 0xA2, 0xC0, 0xDA,
          0x98, 0xBA, 0xD6, 0xB8, 0xCF, 0xE3, 0xD2, 0xE1, 0xED, 0xE4, 0xED, 0xF4, 0xE6, 0xEE, 0xF5, 0xF2, 0xF6, 0xF9, 0xFB, 0xFC, 0xFD, 0xFE, 0xFF, 0xFF, 0xFE, 0xFE, 0xFF, 0xFD, 0xFE, 0xFE, 0xFB, 0xFC, 0xFD, 0xF8, 0xFA, 0xFC, 0xF4, 0xF8, 0xFA,
          0xF1, 0xF5, 0xF9, 0xEF, 0xF4, 0xF8, 0xED, 0xF2, 0xF7, 0xEE, 0xF3, 0xF7, 0xF0, 0xF5, 0xF8, 0xF3, 0xF7, 0xFA, 0xF7, 0xF9, 0xFB, 0xF6, 0xF8, 0xFB, 0xF0, 0xF4, 0xF8, 0xEF, 0xF4, 0xF8, 0xF2, 0xF6, 0xF9, 0xF6, 0xF8, 0xFB, 0xF8, 0xFA, 0xFC,
          0xFA, 0xFB, 0xFC, 0xFB, 0xFC, 0xFD, 0xF7, 0xF9, 0xFB, 0xF4, 0xF7, 0xFA, 0xED, 0xF2, 0xF6, 0xE6, 0xED, 0xF3, 0xEB, 0xF0, 0xF5, 0xEC, 0xF1, 0xF6, 0xF5, 0xF8, 0xFA, 0xF7, 0xF9, 0xFB, 0xF2, 0xF5, 0xF8, 0xF1, 0xF5, 0xF8, 0xF1, 0xF5, 0xF8,
          0xE8, 0xEE, 0xF4, 0xE1, 0xE9, 0xF0, 0xDD, 0xE6, 0xEE, 0xD5, 0xE0, 0xEA, 0xC2, 0xD2, 0xE0, 0xA9, 0xC0, 0xD3, 0x9C, 0xB6, 0xCD, 0x95, 0xB1, 0xC9, 0x8C, 0xAA, 0xC4, 0x87, 0xA6, 0xC2, 0x84, 0xA4, 0xC0, 0x83, 0xA3, 0xC0, 0x86, 0xA5, 0xC1,
          0x8A, 0xA8, 0xC3, 0x8C, 0xAA, 0xC4, 0x8E, 0xAB, 0xC5, 0x8C, 0xA9, 0xC4,
    0xC8, 0xDC, 0xED, 0xC6, 0xDB, 0xEC, 0xC2, 0xD8, 0xEA, 0xBE, 0xD5, 0xE9, 0xB9, 0xD2, 0xE7, 0xB3, 0xCE, 0xE4, 0xAC, 0xC9, 0xE1, 0xA7, 0xC6, 0xDF, 0xA3, 0xC3, 0xDD, 0x9F, 0xC0, 0xDC, 0x9C, 0xBE, 0xDA, 0x9D, 0xBE, 0xDA, 0xA6, 0xC4, 0xDD, 0xB0, 0xCA, 0xE0,
          0xC0, 0xD5, 0xE6, 0xD2, 0xE1, 0xED, 0xE0, 0xEA, 0xF3, 0xE8, 0xEF, 0xF6, 0xF0, 0xF5, 0xF9, 0xF6, 0xF9, 0xFC, 0xFD, 0xFE, 0xFE, 0xFE, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFE, 0xFE, 0xFF, 0xFB, 0xFC, 0xFD, 0xF7, 0xFA, 0xFB, 0xF2, 0xF6, 0xF9,
          0xED, 0xF3, 0xF7, 0xEB, 0xF1, 0xF6, 0xE8, 0xEF, 0xF5, 0xE6, 0xEE, 0xF4, 0xE7, 0xEE, 0xF4, 0xEA, 0xF0, 0xF5, 0xEE, 0xF3, 0xF7, 0xF3, 0xF7, 0xFA, 0xF4, 0xF7, 0xFA, 0xF3, 0xF7, 0xFA, 0xF5, 0xF8, 0xFA, 0xF5, 0xF8, 0xFA, 0xF8, 0xFA, 0xFC,
          0xFC, 0xFC, 0xFD, 0xFD, 0xFD, 0xFE, 0xFD, 0xFD, 0xFE, 0xFC, 0xFC, 0xFD, 0xF9, 0xFA, 0xFC, 0xF0, 0xF4, 0xF8, 0xED, 0xF2, 0xF7, 0xF0, 0xF4, 0xF8, 0xF3, 0xF6, 0xF9, 0xF4, 0xF7, 0xFA, 0xF4, 0xF7, 0xFA, 0xF3, 0xF6, 0xF9, 0xF0, 0xF4, 0xF7,
          0xEA, 0xF0, 0xF5, 0xE5, 0xEC, 0xF2, 0xDE, 0xE7, 0xEF, 0xD8, 0xE3, 0xEC, 0xCB, 0xD9, 0xE5, 0xBC, 0xCE, 0xDD, 0xAD, 0xC3, 0xD6, 0x97, 0xB2, 0xCA, 0x8A, 0xA9, 0xC4, 0x85, 0xA5, 0xC1, 0x84, 0xA5, 0xC1, 0x82, 0xA3, 0xC0, 0x81, 0xA2, 0xBF,
          0x85, 0xA5, 0xC1, 0x8D, 0xAB, 0xC5, 0x8E, 0xAC, 0xC6, 0x8E, 0xAB, 0xC5,
    0xC5, 0xDB, 0xEC, 0xC2, 0xD8, 0xEB, 0xBD, 0xD5, 0xE9, 0xC0, 0xD7, 0xEA, 0xC4, 0xD9, 0xEB, 0xB1, 0xCD, 0xE4, 0xA9, 0xC7, 0xE0, 0xA4, 0xC4, 0xDE, 0xA3, 0xC3, 0xDE, 0x9F, 0xC0, 0xDC, 0x9D, 0xBF, 0xDB, 0xB2, 0xCC, 0xE2, 0xC7, 0xDA, 0xEA, 0xD8, 0xE5, 0xF0,
          0xDF, 0xEA, 0xF3, 0xE1, 0xEB, 0xF3, 0xE2, 0xEC, 0xF4, 0xE7, 0xEE, 0xF5, 0xEE, 0xF4, 0xF8, 0xF4, 0xF8, 0xFB, 0xFD, 0xFE, 0xFE, 0xFE, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFC, 0xFD, 0xFE, 0xF7, 0xF9, 0xFC, 0xF0, 0xF4, 0xF8,
          0xE9, 0xF0, 0xF6, 0xE6, 0xEE, 0xF4, 0xE5, 0xED, 0xF4, 0xE1, 0xEA, 0xF2, 0xE0, 0xE9, 0xF1, 0xE3, 0xEB, 0xF2, 0xEA, 0xF0, 0xF6, 0xEF, 0xF3, 0xF8, 0xF0, 0xF5, 0xF8, 0xF2, 0xF6, 0xF9, 0xF0, 0xF4, 0xF8, 0xF1, 0xF5, 0xF8, 0xF2, 0xF5, 0xF9,
          0xF3, 0xF7, 0xFA, 0xF9, 0xFB, 0xFC, 0xFA, 0xFB, 0xFD, 0xFB, 0xFC, 0xFD, 0xFC, 0xFC, 0xFE, 0xF7, 0xF9, 0xFB, 0xF1, 0xF5, 0xF8, 0xF0, 0xF4, 0xF8, 0xEB, 0xF1, 0xF6, 0xEC, 0xF1, 0xF6, 0xEE, 0xF2, 0xF7, 0xEE, 0xF2, 0xF7, 0xEB, 0xF0, 0xF5,
          0xE8, 0xEE, 0xF3, 0xE2, 0xEA, 0xF1, 0xDA, 0xE4, 0xED, 0xD4, 0xE0, 0xEA, 0xCB, 0xD9, 0xE5, 0xC1, 0xD2, 0xE0, 0xAE, 0xC4, 0xD7, 0x91, 0xAF, 0xC8, 0x88, 0xA8, 0xC4, 0x86, 0xA6, 0xC2, 0x85, 0xA5, 0xC2, 0x81, 0xA3, 0xC0, 0x83, 0xA3, 0xC0,
          0x84, 0xA5, 0xC1, 0x8D, 0xAB, 0xC6, 0x8F, 0xAD, 0xC7, 0x8E, 0xAC, 0xC6,
    0xBC, 0xD5, 0xE9, 0xBB, 0xD4, 0xE9, 0xC4, 0xDA, 0xEB, 0xD2, 0xE3, 0xF0, 0xD4, 0xE3, 0xF0, 0xC4, 0xD9, 0xEA, 0xBC, 0xD4, 0xE7, 0xB8, 0xD1, 0xE6, 0xAF, 0xCB, 0xE2, 0xAB, 0xC8, 0xE0, 0xB8, 0xD1, 0xE5, 0xD1, 0xE1, 0xEE, 0xDF, 0xEA, 0xF3, 0xE8, 0xF0, 0xF6,
          0xEB, 0xF2, 0xF7, 0xEB, 0xF2, 0xF7, 0xE8, 0xF0, 0xF6, 0xE9, 0xF0, 0xF6, 0xE9, 0xF0, 0xF6, 0xEC, 0xF2, 0xF7, 0xF5, 0xF8, 0xFB, 0xFE, 0xFE, 0xFF, 0xFE, 0xFF, 0xFF, 0xFE, 0xFE, 0xFF, 0xFC, 0xFD, 0xFE, 0xF7, 0xFA, 0xFC, 0xED, 0xF3, 0xF8,
          0xE6, 0xEE, 0xF4, 0xE1, 0xEA, 0xF2, 0xDF, 0xE9, 0xF1, 0xDC, 0xE6, 0xEF, 0xDA, 0xE5, 0xEF, 0xDE, 0xE8, 0xF0, 0xE4, 0xEC, 0xF3, 0xE7, 0xEF, 0xF5, 0xEB, 0xF1, 0xF6, 0xED, 0xF2, 0xF7, 0xEA, 0xF0, 0xF5, 0xEB, 0xF1, 0xF6, 0xEC, 0xF1, 0xF6,
          0xEB, 0xF1, 0xF6, 0xF1, 0xF5, 0xF8, 0xF6, 0xF8, 0xFB, 0xF9, 0xFB, 0xFC, 0xFA, 0xFB, 0xFD, 0xF6, 0xF8, 0xFB, 0xF0, 0xF4, 0xF8, 0xEF, 0xF3, 0xF7, 0xEB, 0xF1, 0xF5, 0xE8, 0xEE, 0xF3, 0xE8, 0xEE, 0xF4, 0xE8, 0xEE, 0xF4, 0xE2, 0xEA, 0xF1,
          0xDF, 0xE8, 0xEF, 0xDA, 0xE4, 0xED, 0xD4, 0xE0, 0xEA, 0xCE, 0xDC, 0xE7, 0xCC, 0xDA, 0xE6, 0xC8, 0xD7, 0xE4, 0xB9, 0xCC, 0xDC, 0x97, 0xB3, 0xCC, 0x85, 0xA6, 0xC3, 0x86, 0xA7, 0xC3, 0x87, 0xA7, 0xC3, 0x82, 0xA4, 0xC1, 0x83, 0xA4, 0xC1,
          0x85, 0xA5, 0xC2, 0x88, 0xA8, 0xC4, 0x8A, 0xAA, 0xC5, 0x8B, 0xAA, 0xC5,
    0xB5, 0xD1, 0xE8, 0xC9, 0xDD, 0xEE, 0xD3, 0xE3, 0xF1, 0xD6, 0xE5, 0xF1, 0xD6, 0xE4, 0xF1, 0xCC, 0xDF, 0xEE, 0xCF, 0xE0, 0xEE, 0xCA, 0xDD, 0xED, 0xC2, 0xD8, 0xE9, 0xD0, 0xE0, 0xEE, 0xDA, 0xE7, 0xF2, 0xE5, 0xEE, 0xF5, 0xEC, 0xF2, 0xF8, 0xEE, 0xF4, 0xF8,
          0xEE, 0xF4, 0xF9, 0xEE, 0xF4, 0xF9, 0xEC, 0xF3, 0xF8, 0xE9, 0xF0, 0xF6, 0xE8, 0xF0, 0xF6, 0xE9, 0xF0, 0xF6, 0xF2, 0xF6, 0xFA, 0xF9, 0xFB, 0xFD, 0xFE, 0xFE, 0xFF, 0xFD, 0xFE, 0xFE, 0xF9, 0xFB, 0xFC, 0xF2, 0xF6, 0xFA, 0xEC, 0xF2, 0xF7,
          0xE5, 0xED, 0xF4, 0xDF, 0xE9, 0xF1, 0xD9, 0xE5, 0xEF, 0xD5, 0xE2, 0xED, 0xD3, 0xE1, 0xEC, 0xD5, 0xE2, 0xED, 0xD8, 0xE4, 0xEE, 0xDB, 0xE6, 0xEF, 0xDC, 0xE7, 0xF0, 0xE0, 0xE9, 0xF1, 0xE0, 0xE9, 0xF1, 0xDF, 0xE8, 0xF1, 0xE0, 0xE9, 0xF1,
          0xE0, 0xE9, 0xF1, 0xE4, 0xEC, 0xF3, 0xEB, 0xF1, 0xF6, 0xEF, 0xF4, 0xF8, 0xF2, 0xF6, 0xF9, 0xF3, 0xF6, 0xF9, 0xF1, 0xF5, 0xF9, 0xEF, 0xF3, 0xF7, 0xEA, 0xF0, 0xF5, 0xE5, 0xED, 0xF3, 0xE3, 0xEB, 0xF2, 0xDD, 0xE7, 0xEF, 0xD8, 0xE3, 0xEC,
          0xD4, 0xE0, 0xEA, 0xD1, 0xDD, 0xE9, 0xCC, 0xDA, 0xE6, 0xC7, 0xD6, 0xE4, 0xC5, 0xD5, 0xE3, 0xC1, 0xD2, 0xE1, 0xB9, 0xCC, 0xDD, 0x9E, 0xB8, 0xCF, 0x89, 0xA9, 0xC5, 0x7F, 0xA2, 0xC0, 0x7E, 0xA1, 0xC0, 0x7E, 0xA1, 0xC0, 0x7F, 0xA1, 0xC0,
          0x80, 0xA2, 0xC0, 0x80, 0xA2, 0xC0, 0x84, 0xA5, 0xC2, 0x87, 0xA7, 0xC3,
    0xB4, 0xD0, 0xE7, 0xCC, 0xDF, 0xEF, 0xD5, 0xE5, 0xF2, 0xD7, 0xE5, 0xF2, 0xD4, 0xE4, 0xF1, 0xD0, 0xE1, 0xEF, 0xDA, 0xE7, 0xF2, 0xD8, 0xE6, 0xF1, 0xD6, 0xE4, 0xF1, 0xDB, 0xE8, 0xF2, 0xE8, 0xF0, 0xF7, 0xF0, 0xF5, 0xFA, 0xF0, 0xF5, 0xF9, 0xEF, 0xF5, 0xF9,
          0xEE, 0xF4, 0xF9, 0xEE, 0xF4, 0xF9, 0xEC, 0xF2, 0xF8, 0xE9, 0xF1, 0xF7, 0xE9, 0xF0, 0xF6, 0xE8, 0xEF, 0xF6, 0xEE, 0xF4, 0xF8, 0xF4, 0xF8, 0xFB, 0xF7, 0xFA, 0xFC, 0xFB, 0xFC, 0xFD, 0xF7, 0xFA, 0xFC, 0xF0, 0xF4, 0xF9, 0xEF, 0xF4, 0xF8,
          0xEE, 0xF3, 0xF8, 0xE3, 0xEC, 0xF3, 0xD8, 0xE4, 0xEE, 0xCE, 0xDD, 0xEA, 0xCC, 0xDB, 0xE9, 0xC9, 0xD9, 0xE8, 0xCC, 0xDC, 0xE9, 0xCD, 0xDC, 0xE9, 0xCB, 0xDA, 0xE8, 0xCD, 0xDC, 0xE9, 0xD2, 0xE0, 0xEB, 0xD1, 0xDF, 0xEA, 0xCF, 0xDD, 0xE9,
          0xD2, 0xE0, 0xEB, 0xD7, 0xE3, 0xED, 0xDC, 0xE7, 0xEF, 0xE2, 0xEB, 0xF2, 0xE6, 0xED, 0xF3, 0xEA, 0xF0, 0xF5, 0xEC, 0xF2, 0xF6, 0xEC, 0xF2, 0xF6, 0xE7, 0xED, 0xF4, 0xE0, 0xE9, 0xF0, 0xDB, 0xE6, 0xEE, 0xD4, 0xE0, 0xEA, 0xCB, 0xD9, 0xE6,
          0xC7, 0xD7, 0xE4, 0xC4, 0xD4, 0xE3, 0xC1, 0xD2, 0xE1, 0xBD, 0xCF, 0xDF, 0xBB, 0xCE, 0xDE, 0xB9, 0xCC, 0xDD, 0xAF, 0xC5, 0xD8, 0x9E, 0xB8, 0xCF, 0x8A, 0xAA, 0xC6, 0x7D, 0xA1, 0xC0, 0x78, 0x9D, 0xBD, 0x76, 0x9C, 0xBC, 0x76, 0x9B, 0xBC,
          0x7A, 0x9E, 0xBE, 0x7E, 0xA1, 0xBF, 0x88, 0xA8, 0xC5, 0x8D, 0xAC, 0xC7,
    0xB1, 0xCE, 0xE7, 0xCC, 0xDF, 0xEF, 0xD3, 0xE3, 0xF1, 0xD8, 0xE6, 0xF2, 0xD8, 0xE6, 0xF2, 0xDB, 0xE8, 0xF3, 0xE0, 0xEB, 0xF5, 0xE1, 0xEC, 0xF5, 0xE3, 0xED, 0xF5, 0xE7, 0xEF, 0xF7, 0xED, 0xF4, 0xF9, 0xF0, 0xF5, 0xF9, 0xED, 0xF3, 0xF9, 0xEC, 0xF2, 0xF8,
          0xEB, 0xF2, 0xF8, 0xEB, 0xF2, 0xF7, 0xE9, 0xF1, 0xF7, 0xE7, 0xEF, 0xF6, 0xE5, 0xEE, 0xF5, 0xE6, 0xEE, 0xF5, 0xE7, 0xEF, 0xF6, 0xEE, 0xF4, 0xF8, 0xF4, 0xF8, 0xFB, 0xF9, 0xFB, 0xFD, 0xF6, 0xF9, 0xFB, 0xF0, 0xF5, 0xF9, 0xED, 0xF3, 0xF7,
          0xEB, 0xF1, 0xF7, 0xE6, 0xEE, 0xF5, 0xDD, 0xE7, 0xF0, 0xD4, 0xE1, 0xED, 0xD1, 0xE0, 0xEB, 0xCE, 0xDD, 0xEA, 0xCC, 0xDC, 0xE9, 0xC7, 0xD9, 0xE7, 0xC5, 0xD7, 0xE6, 0xC5, 0xD7, 0xE6, 0xC6, 0xD7, 0xE6, 0xC5, 0xD6, 0xE5, 0xC3, 0xD5, 0xE4,
          0xC6, 0xD7, 0xE5, 0xC9, 0xD9, 0xE6, 0xCE, 0xDC, 0xE9, 0xD4, 0xE0, 0xEB, 0xD7, 0xE3, 0xED, 0xDB, 0xE6, 0xEF, 0xDE, 0xE8, 0xF0, 0xE1, 0xE9, 0xF1, 0xDF, 0xE8, 0xF0, 0xD8, 0xE3, 0xEC, 0xD1, 0xDE, 0xEA, 0xC9, 0xD8, 0xE5, 0xC0, 0xD2, 0xE1,
          0xB8, 0xCD, 0xDE, 0xB4, 0xC9, 0xDB, 0xB2, 0xC8, 0xDA, 0xB0, 0xC6, 0xD9, 0xAF, 0xC6, 0xD9, 0xAD, 0xC4, 0xD8, 0xA7, 0xBF, 0xD5, 0x9D, 0xB9, 0xD0, 0x8F, 0xAE, 0xC9, 0x7E, 0xA2, 0xC1, 0x75, 0x9B, 0xBC, 0x72, 0x99, 0xBB, 0x71, 0x98, 0xBA,
          0x79, 0x9E, 0xBE, 0x84, 0xA6, 0xC3, 0x8E, 0xAE, 0xC8, 0x90, 0xAE, 0xC9,
    0xC2, 0xD9, 0xED, 0xCE, 0xE1, 0xF0, 0xD4, 0xE4, 0xF1, 0xD9, 0xE7, 0xF3, 0xDC, 0xE9, 0xF3, 0xE0, 0xEB, 0xF5, 0xE4, 0xEE, 0xF6, 0xE4, 0xEE, 0xF6, 0xE6, 0xEF, 0xF7, 0xEB, 0xF2, 0xF8, 0xEE, 0xF4, 0xF9, 0xEF, 0xF5, 0xF9, 0xEB, 0xF2, 0xF8, 0xE9, 0xF1, 0xF7,
          0xE8, 0xF0, 0xF7, 0xE8, 0xF0, 0xF6, 0xE6, 0xEE, 0xF5, 0xE5, 0xEE, 0xF5, 0xE4, 0xED, 0xF5, 0xE4, 0xEC, 0xF4, 0xE4, 0xED, 0xF5, 0xEA, 0xF1, 0xF7, 0xF3, 0xF7, 0xFA, 0xF4, 0xF7, 0xFA, 0xF0, 0xF5, 0xF9, 0xEE, 0xF4, 0xF8, 0xEA, 0xF1, 0xF7,
          0xE7, 0xEF, 0xF5, 0xE5, 0xED, 0xF4, 0xDF, 0xE9, 0xF2, 0xD9, 0xE5, 0xEF, 0xD2, 0xE0, 0xEC, 0xCF, 0xDE, 0xEA, 0xD3, 0xE1, 0xEC, 0xCC, 0xDC, 0xE9, 0xC1, 0xD4, 0xE4, 0xBC, 0xD0, 0xE2, 0xBA, 0xCF, 0xE1, 0xB8, 0xCD, 0xE0, 0xB8, 0xCD, 0xDF,
          0xB8, 0xCD, 0xDF, 0xBB, 0xCF, 0xE0, 0xBF, 0xD2, 0xE2, 0xC5, 0xD6, 0xE5, 0xC8, 0xD8, 0xE6, 0xCB, 0xDA, 0xE7, 0xCD, 0xDB, 0xE8, 0xD0, 0xDE, 0xE9, 0xD2, 0xDF, 0xEA, 0xCC, 0xDB, 0xE7, 0xC6, 0xD6, 0xE5, 0xBF, 0xD1, 0xE1, 0xB5, 0xCB, 0xDD,
          0xAD, 0xC4, 0xD9, 0xA6, 0xBF, 0xD5, 0xA2, 0xBD, 0xD3, 0xA1, 0xBC, 0xD3, 0xA0, 0xBB, 0xD2, 0x9E, 0xB9, 0xD1, 0x9A, 0xB6, 0xCF, 0x95, 0xB3, 0xCC, 0x8D, 0xAD, 0xC9, 0x7F, 0xA2, 0xC2, 0x74, 0x9B, 0xBD, 0x70, 0x98, 0xBA, 0x6E, 0x96, 0xB9,
          0x76, 0x9C, 0xBD, 0x87, 0xA8, 0xC5, 0x8F, 0xAE, 0xC9, 0x90, 0xAF, 0xC9,
    0xCD, 0xE0, 0xF0, 0xD3, 0xE4, 0xF2, 0xDB, 0xE9, 0xF4, 0xE0, 0xEC, 0xF5, 0xE0, 0xEC, 0xF5, 0xE4, 0xEE, 0xF6, 0xE7, 0xF0, 0xF7, 0xE6, 0xEF, 0xF7, 0xE5, 0xEF, 0xF6, 0xE8, 0xF0, 0xF7, 0xEB, 0xF2, 0xF8, 0xEB, 0xF2, 0xF8, 0xEA, 0xF1, 0xF7, 0xE7, 0xF0, 0xF7,
          0xE5, 0xEE, 0xF6, 0xE5, 0xEE, 0xF5, 0xE4, 0xEE, 0xF5, 0xE6, 0xEE, 0xF6, 0xEA, 0xF1, 0xF7, 0xEB, 0xF2, 0xF8, 0xED, 0xF3, 0xF8, 0xEE, 0xF4, 0xF8, 0xEF, 0xF4, 0xF9, 0xEC, 0xF2, 0xF7, 0xEA, 0xF1, 0xF7, 0xE7, 0xEF, 0xF6, 0xE4, 0xEC, 0xF4,
          0xDF, 0xE9, 0xF2, 0xDD, 0xE8, 0xF1, 0xDA, 0xE6, 0xF0, 0xD9, 0xE5, 0xEF, 0xD1, 0xE0, 0xEC, 0xD3, 0xE1, 0xEC, 0xD5, 0xE2, 0xED, 0xCF, 0xDE, 0xEB, 0xC8, 0xD9, 0xE7, 0xB4, 0xCB, 0xDE, 0xAE, 0xC7, 0xDC, 0xB3, 0xCA, 0xDE, 0xAF, 0xC7, 0xDC,
          0xAB, 0xC5, 0xDA, 0xAD, 0xC6, 0xDB, 0xB0, 0xC8, 0xDC, 0xB5, 0xCB, 0xDE, 0xB8, 0xCD, 0xDF, 0xB9, 0xCD, 0xDF, 0xBB, 0xCF, 0xE0, 0xC0, 0xD2, 0xE2, 0xC3, 0xD4, 0xE4, 0xC1, 0xD3, 0xE2, 0xBB, 0xCF, 0xE0, 0xB4, 0xCA, 0xDC, 0xAC, 0xC4, 0xD8,
          0xA3, 0xBD, 0xD4, 0x9C, 0xB9, 0xD1, 0x99, 0xB6, 0xCF, 0x95, 0xB3, 0xCD, 0x92, 0xB1, 0xCC, 0x90, 0xAF, 0xCB, 0x8D, 0xAE, 0xC9, 0x8A, 0xAB, 0xC8, 0x83, 0xA6, 0xC4, 0x7A, 0xA0, 0xC0, 0x73, 0x9B, 0xBD, 0x6F, 0x98, 0xBA, 0x6D, 0x96, 0xB9,
          0x70, 0x98, 0xBB, 0x7B, 0xA0, 0xC0, 0x84, 0xA6, 0xC4, 0x86, 0xA7, 0xC5,
    0xD3, 0xE4, 0xF2, 0xDC, 0xE9, 0xF4, 0xE0, 0xEC, 0xF6, 0xE1, 0xED, 0xF6, 0xE2, 0xED, 0xF6, 0xE4, 0xEE, 0xF6, 0xE4, 0xEE, 0xF6, 0xE3, 0xED, 0xF6, 0xE1, 0xEC, 0xF5, 0xE2, 0xEC, 0xF5, 0xE5, 0xEE, 0xF6, 0xE5, 0xEE, 0xF6, 0xE4, 0xEE, 0xF6, 0xE2, 0xED, 0xF5,
          0xE0, 0xEB, 0xF4, 0xE0, 0xEB, 0xF4, 0xE0, 0xEA, 0xF3, 0xE1, 0xEC, 0xF4, 0xE4, 0xED, 0xF5, 0xE7, 0xEF, 0xF6, 0xE9, 0xF1, 0xF7, 0xEA, 0xF1, 0xF7, 0xE6, 0xEE, 0xF5, 0xE3, 0xEC, 0xF4, 0xE0, 0xEA, 0xF3, 0xDC, 0xE7, 0xF1, 0xD7, 0xE4, 0xEF,
          0xD2, 0xE0, 0xED, 0xD0, 0xDF, 0xEC, 0xCF, 0xDF, 0xEC, 0xCF, 0xDE, 0xEB, 0xCD, 0xDD, 0xEA, 0xCA, 0xDB, 0xE9, 0xCE, 0xDD, 0xEA, 0xC9, 0xDA, 0xE8, 0xBF, 0xD3, 0xE4, 0xAF, 0xC8, 0xDD, 0xA7, 0xC2, 0xD9, 0xAA, 0xC4, 0xDA, 0xA6, 0xC1, 0xD8,
          0xA4, 0xBF, 0xD7, 0xA1, 0xBD, 0xD6, 0xA3, 0xBF, 0xD7, 0xA6, 0xC1, 0xD7, 0xA8, 0xC2, 0xD8, 0xAA, 0xC3, 0xD9, 0xAE, 0xC6, 0xDB, 0xB2, 0xC9, 0xDC, 0xB5, 0xCB, 0xDD, 0xB5, 0xCB, 0xDD, 0xB1, 0xC8, 0xDB, 0xAB, 0xC4, 0xD9, 0xA4, 0xBE, 0xD5,
          0x9D, 0xB9, 0xD2, 0x98, 0xB6, 0xD0, 0x97, 0xB5, 0xCF, 0x96, 0xB4, 0xCE, 0x8F, 0xAF, 0xCB, 0x8B, 0xAC, 0xC9, 0x89, 0xAB, 0xC8, 0x86, 0xA9, 0xC6, 0x83, 0xA6, 0xC5, 0x7D, 0xA2, 0xC2, 0x76, 0x9D, 0xBE, 0x70, 0x99, 0xBC, 0x6D, 0x96, 0xBA,
          0x6C, 0x96, 0xBA, 0x71, 0x99, 0xBC, 0x74, 0x9B, 0xBD, 0x75, 0x9D, 0xBE,
    0xDE, 0xEB, 0xF5, 0xDE, 0xEB, 0xF5, 0xDE, 0xEB, 0xF5, 0xDD, 0xEA, 0xF5, 0xDE, 0xEB, 0xF5, 0xDE, 0xEA, 0xF4, 0xDF, 0xEB, 0xF5, 0xDD, 0xEA, 0xF4, 0xDC, 0xE9, 0xF3, 0xDB, 0xE8, 0xF3, 0xDB, 0xE8, 0xF3, 0xDC, 0xE9, 0xF3, 0xDD, 0xE9, 0xF3, 0xDC, 0xE9, 0xF3,
          0xDC, 0xE8, 0xF3, 0xD9, 0xE6, 0xF2, 0xD7, 0xE5, 0xF1, 0xD9, 0xE6, 0xF1, 0xDA, 0xE7, 0xF1, 0xDC, 0xE8, 0xF2, 0xDD, 0xE9, 0xF2, 0xDE, 0xE9, 0xF2, 0xDA, 0xE6, 0xF1, 0xD5, 0xE3, 0xEF, 0xD1, 0xE0, 0xED, 0xCC, 0xDC, 0xEB, 0xC6, 0xD9, 0xE9,
          0xC1, 0xD5, 0xE6, 0xBF, 0xD3, 0xE5, 0xBF, 0xD4, 0xE5, 0xC0, 0xD5, 0xE6, 0xC1, 0xD4, 0xE6, 0xBC, 0xD1, 0xE3, 0xBA, 0xD0, 0xE2, 0xB7, 0xCD, 0xE1, 0xAA, 0xC4, 0xDB, 0xA7, 0xC3, 0xDA, 0xA6, 0xC2, 0xD9, 0xA2, 0xBF, 0xD7, 0xA0, 0xBD, 0xD6,
          0x9C, 0xBA, 0xD4, 0x95, 0xB6, 0xD1, 0x97, 0xB6, 0xD2, 0x9A, 0xB8, 0xD2, 0x9C, 0xBA, 0xD3, 0x9F, 0xBB, 0xD4, 0xA3, 0xBE, 0xD6, 0xA6, 0xC1, 0xD7, 0xAA, 0xC3, 0xD9, 0xAB, 0xC4, 0xD9, 0xA8, 0xC1, 0xD8, 0xA2, 0xBD, 0xD5, 0x9F, 0xBB, 0xD4,
          0x9C, 0xB9, 0xD2, 0x98, 0xB7, 0xD0, 0x9B, 0xB8, 0xD1, 0x9B, 0xB8, 0xD1, 0x93, 0xB2, 0xCD, 0x8C, 0xAD, 0xCA, 0x8A, 0xAC, 0xC8, 0x89, 0xAB, 0xC8, 0x8B, 0xAD, 0xC9, 0x85, 0xA8, 0xC6, 0x7A, 0xA0, 0xC1, 0x73, 0x9B, 0xBD, 0x6E, 0x98, 0xBB,
          0x6C, 0x96, 0xBA, 0x6C, 0x96, 0xBA, 0x6C, 0x96, 0xBA, 0x6B, 0x95, 0xBA,
    0xE0, 0xEC, 0xF6, 0xDC, 0xEA, 0xF5, 0xDA, 0xE8, 0xF4, 0xD8, 0xE7, 0xF3, 0xD7, 0xE6, 0xF3, 0xD6, 0xE6, 0xF2, 0xD6, 0xE5, 0xF2, 0xD5, 0xE5, 0xF2, 0xD4, 0xE4, 0xF1, 0xD4, 0xE4, 0xF1, 0xD5, 0xE4, 0xF1, 0xD5, 0xE5, 0xF1, 0xD6, 0xE4, 0xF1, 0xD6, 0xE5, 0xF1,
          0xD5, 0xE4, 0xF0, 0xD1, 0xE2, 0xEF, 0xCF, 0xE0, 0xEE, 0xD1, 0xE1, 0xEE, 0xD1, 0xE1, 0xEF, 0xD1, 0xE1, 0xEE, 0xD2, 0xE1, 0xEE, 0xD1, 0xE0, 0xEE, 0xCE, 0xDE, 0xEC, 0xC9, 0xDB, 0xEA, 0xC3, 0xD7, 0xE8, 0xBE, 0xD4, 0xE6, 0xB9, 0xD0, 0xE4,
          0xB7, 0xCE, 0xE2, 0xB5, 0xCD, 0xE2, 0xB5, 0xCD, 0xE2, 0xB5, 0xCD, 0xE1, 0xB4, 0xCC, 0xE1, 0xB4, 0xCC, 0xE0, 0xB5, 0xCC, 0xE0, 0xAF, 0xC8, 0xDE, 0x9C, 0xBB, 0xD6, 0x95, 0xB6, 0xD3, 0x96, 0xB7, 0xD3, 0x9C, 0xBB, 0xD5, 0x93, 0xB4, 0xD1,
          0x8E, 0xB1, 0xCF, 0x8D, 0xB0, 0xCE, 0x8D, 0xB0, 0xCE, 0x90, 0xB2, 0xCF, 0x92, 0xB3, 0xCF, 0x95, 0xB5, 0xD0, 0x98, 0xB7, 0xD2, 0x9D, 0xBA, 0xD4, 0xA1, 0xBD, 0xD5, 0xA3, 0xBF, 0xD6, 0xA2, 0xBD, 0xD5, 0x9E, 0xBB, 0xD3, 0x9E, 0xBB, 0xD3,
          0x9D, 0xBA, 0xD3, 0x9B, 0xB8, 0xD2, 0x9A, 0xB7, 0xD1, 0x99, 0xB7, 0xD0, 0x96, 0xB5, 0xCF, 0x94, 0xB3, 0xCE, 0x91, 0xB1, 0xCD, 0x90, 0xB0, 0xCC, 0x96, 0xB4, 0xCF, 0x8F, 0xAF, 0xCB, 0x80, 0xA5, 0xC5, 0x76, 0x9E, 0xC0, 0x72, 0x9B, 0xBD,
          0x6D, 0x97, 0xBB, 0x6A, 0x95, 0xBA, 0x69, 0x94, 0xB9, 0x67, 0x93, 0xB9,
    0xDC, 0xE9, 0xF5, 0xDB, 0xE9, 0xF5, 0xD5, 0xE5, 0xF3, 0xD1, 0xE3, 0xF1, 0xCF, 0xE2, 0xF1, 0xCE, 0xE1, 0xF0, 0xCD, 0xE0, 0xF0, 0xCC, 0xDF, 0xEF, 0xCD, 0xDF, 0xEF, 0xCD, 0xE0, 0xEF, 0xCF, 0xE1, 0xEF, 0xCF, 0xE1, 0xEF, 0xD1, 0xE2, 0xEF, 0xD1, 0xE1, 0xEF,
          0xCF, 0xE0, 0xEE, 0xCE, 0xDF, 0xEE, 0xCA, 0xDD, 0xEC, 0xCA, 0xDD, 0xEC, 0xC9, 0xDC, 0xEC, 0xC8, 0xDB, 0xEB, 0xC8, 0xDB, 0xEB, 0xC6, 0xDA, 0xEA, 0xC4, 0xD8, 0xE9, 0xC0, 0xD5, 0xE7, 0xBA, 0xD1, 0xE5, 0xB7, 0xCF, 0xE3, 0xB3, 0xCD, 0xE2,
          0xB2, 0xCB, 0xE1, 0xB1, 0xCB, 0xE0, 0xB1, 0xCB, 0xE0, 0xB0, 0xCA, 0xE0, 0xB0, 0xC9, 0xDF, 0xB1, 0xCA, 0xDF, 0xB1, 0xCA, 0xDF, 0xA8, 0xC4, 0xDB, 0x91, 0xB4, 0xD2, 0x8C, 0xB0, 0xCF, 0x8F, 0xB2, 0xD0, 0x8E, 0xB1, 0xD0, 0x88, 0xAD, 0xCD,
          0x89, 0xAE, 0xCD, 0x89, 0xAE, 0xCD, 0x8A, 0xAE, 0xCD, 0x8B, 0xAF, 0xCD, 0x8D, 0xB0, 0xCE, 0x8F, 0xB1, 0xCF, 0x92, 0xB3, 0xD0, 0x96, 0xB6, 0xD1, 0x9B, 0xB9, 0xD3, 0x9D, 0xBB, 0xD4, 0x9D, 0xBB, 0xD4, 0x9A, 0xB8, 0xD2, 0x9A, 0xB8, 0xD2,
          0x9B, 0xB9, 0xD3, 0x9D, 0xBA, 0xD3, 0x9B, 0xB9, 0xD2, 0x9B, 0xB8, 0xD2, 0x99, 0xB8, 0xD1, 0x97, 0xB6, 0xD0, 0x97, 0xB6, 0xD0, 0x9B, 0xB9, 0xD2, 0x99, 0xB7, 0xD1, 0x98, 0xB6, 0xD0, 0x8B, 0xAD, 0xCA, 0x7D, 0xA3, 0xC3, 0x75, 0x9D, 0xC0,
          0x72, 0x9B, 0xBE, 0x6F, 0x99, 0xBD, 0x69, 0x95, 0xBA, 0x67, 0x94, 0xB9,
    0xD3, 0xE5, 0xF3, 0xD3, 0xE4, 0xF2, 0xCB, 0xE0, 0xF0, 0xC7, 0xDD, 0xEF, 0xC5, 0xDC, 0xEE, 0xC6, 0xDC, 0xEE, 0xC7, 0xDC, 0xEE, 0xC7, 0xDC, 0xED, 0xC8, 0xDD, 0xEE, 0xC9, 0xDD, 0xEE, 0xCA, 0xDE, 0xEE, 0xCB, 0xDF, 0xEE, 0xCD, 0xDF, 0xEE, 0xCC, 0xDF, 0xEE,
          0xCB, 0xDE, 0xED, 0xC9, 0xDC, 0xEC, 0xC8, 0xDB, 0xEC, 0xC7, 0xDB, 0xEB, 0xC6, 0xDA, 0xEB, 0xC6, 0xDA, 0xEB, 0xC5, 0xD9, 0xEA, 0xC2, 0xD7, 0xE9, 0xBF, 0xD5, 0xE7, 0xBA, 0xD1, 0xE5, 0xB6, 0xCF, 0xE4, 0xB5, 0xCE, 0xE3, 0xB5, 0xCE, 0xE3,
          0xB6, 0xCE, 0xE3, 0xB2, 0xCC, 0xE1, 0xB2, 0xCB, 0xE1, 0xB2, 0xCB, 0xE1, 0xAF, 0xCA, 0xDF, 0xAE, 0xC9, 0xDF, 0xA8, 0xC4, 0xDC, 0x96, 0xB8, 0xD5, 0x89, 0xAF, 0xCF, 0x89, 0xAE, 0xCE, 0x88, 0xAE, 0xCE, 0x87, 0xAD, 0xCD, 0x87, 0xAD, 0xCD,
          0x88, 0xAE, 0xCD, 0x8C, 0xB0, 0xCE, 0x90, 0xB3, 0xD0, 0x91, 0xB3, 0xD0, 0x90, 0xB2, 0xD0, 0x92, 0xB3, 0xD0, 0x95, 0xB5, 0xD1, 0x95, 0xB5, 0xD1, 0x98, 0xB7, 0xD2, 0x99, 0xB8, 0xD2, 0x97, 0xB7, 0xD2, 0x97, 0xB6, 0xD1, 0x97, 0xB7, 0xD2,
          0x98, 0xB7, 0xD2, 0x9B, 0xB9, 0xD3, 0x9E, 0xBB, 0xD4, 0xA0, 0xBC, 0xD5, 0x9C, 0xBA, 0xD3, 0x99, 0xB8, 0xD1, 0x9A, 0xB8, 0xD2, 0xA0, 0xBC, 0xD4, 0x9E, 0xBB, 0xD3, 0x9C, 0xB9, 0xD3, 0x98, 0xB6, 0xD0, 0x86, 0xA9, 0xC8, 0x79, 0xA1, 0xC2,
          0x78, 0x9F, 0xC1, 0x74, 0x9D, 0xC0, 0x6C, 0x97, 0xBC, 0x69, 0x95, 0xBB,
    0xCC, 0xE1, 0xF1, 0xCA, 0xDF, 0xF0, 0xC6, 0xDC, 0xEF, 0xBF, 0xD8, 0xED, 0xBE, 0xD7, 0xEC, 0xBF, 0xD8, 0xEC, 0xBE, 0xD7, 0xEC, 0xBF, 0xD7, 0xEC, 0xC0, 0xD8, 0xEB, 0xC3, 0xDA, 0xEC, 0xC6, 0xDB, 0xED, 0xC7, 0xDC, 0xED, 0xC8, 0xDD, 0xED, 0xC8, 0xDC, 0xED,
          0xC6, 0xDB, 0xEC, 0xC6, 0xDA, 0xEB, 0xC5, 0xDA, 0xEB, 0xC5, 0xD9, 0xEB, 0xC5, 0xDA, 0xEB, 0xC7, 0xDB, 0xEB, 0xC8, 0xDB, 0xEB, 0xC5, 0xD9, 0xEA, 0xC0, 0xD6, 0xE8, 0xBA, 0xD2, 0xE6, 0xBA, 0xD2, 0xE6, 0xBD, 0xD3, 0xE6, 0xC0, 0xD5, 0xE7,
          0xC0, 0xD5, 0xE7, 0xBB, 0xD2, 0xE5, 0xB9, 0xD0, 0xE4, 0xB5, 0xCE, 0xE2, 0xAD, 0xC8, 0xDF, 0xA2, 0xC1, 0xDA, 0x99, 0xBA, 0xD6, 0x8D, 0xB2, 0xD1, 0x87, 0xAE, 0xCF, 0x85, 0xAD, 0xCE, 0x84, 0xAC, 0xCD, 0x85, 0xAD, 0xCD, 0x88, 0xAD, 0xCE,
          0x8B, 0xB0, 0xCF, 0x92, 0xB4, 0xD2, 0x99, 0xB9, 0xD4, 0x97, 0xB8, 0xD3, 0x94, 0xB6, 0xD2, 0x95, 0xB6, 0xD2, 0x98, 0xB8, 0xD3, 0x97, 0xB7, 0xD3, 0x96, 0xB6, 0xD2, 0x96, 0xB6, 0xD2, 0x94, 0xB5, 0xD1, 0x93, 0xB4, 0xD0, 0x93, 0xB4, 0xD0,
          0x94, 0xB5, 0xD0, 0x98, 0xB7, 0xD2, 0x9C, 0xBA, 0xD3, 0x9D, 0xBA, 0xD4, 0x9A, 0xB8, 0xD2, 0x98, 0xB7, 0xD1, 0x99, 0xB8, 0xD2, 0x9B, 0xB9, 0xD2, 0x9A, 0xB8, 0xD2, 0x9B, 0xB9, 0xD2, 0x96, 0xB5, 0xD0, 0x88, 0xAB, 0xCA, 0x7C, 0xA3, 0xC4,
          0x79, 0xA1, 0xC3, 0x77, 0x9F, 0xC2, 0x70, 0x9B, 0xBF, 0x6B, 0x97, 0xBC,
    0xC9, 0xDF, 0xF1, 0xC8, 0xDE, 0xF0, 0xC4, 0xDB, 0xEE, 0xBD, 0xD7, 0xEC, 0xBB, 0xD6, 0xEB, 0xBB, 0xD5, 0xEB, 0xB8, 0xD4, 0xEA, 0xB8, 0xD3, 0xEA, 0xB9, 0xD4, 0xEA, 0xBB, 0xD5, 0xEA, 0xBF, 0xD7, 0xEB, 0xC4, 0xDA, 0xEC, 0xC6, 0xDB, 0xED, 0xC6, 0xDB, 0xEC,
          0xC5, 0xDA, 0xEC, 0xC3, 0xD9, 0xEB, 0xC4, 0xD9, 0xEB, 0xC5, 0xDA, 0xEB, 0xC6, 0xDB, 0xEC, 0xCC, 0xDE, 0xED, 0xCC, 0xDE, 0xED, 0xC9, 0xDC, 0xEC, 0xC5, 0xDA, 0xEA, 0xC4, 0xD8, 0xE9, 0xC5, 0xD9, 0xEA, 0xC6, 0xDA, 0xEA, 0xC6, 0xD9, 0xEA,
          0xC7, 0xDA, 0xEA, 0xBE, 0xD4, 0xE7, 0xBB, 0xD2, 0xE5, 0xB6, 0xCE, 0xE3, 0xAC, 0xC8, 0xDF, 0x9B, 0xBC, 0xD8, 0x8D, 0xB3, 0xD2, 0x88, 0xAF, 0xD0, 0x85, 0xAD, 0xCF, 0x83, 0xAB, 0xCD, 0x82, 0xAB, 0xCD, 0x83, 0xAB, 0xCD, 0x88, 0xAE, 0xCF,
          0x8B, 0xB0, 0xD0, 0x97, 0xB8, 0xD4, 0x9E, 0xBD, 0xD7, 0x99, 0xB9, 0xD4, 0x96, 0xB7, 0xD3, 0x96, 0xB7, 0xD3, 0x98, 0xB8, 0xD4, 0x96, 0xB7, 0xD3, 0x93, 0xB4, 0xD1, 0x90, 0xB2, 0xCF, 0x8D, 0xB0, 0xCE, 0x89, 0xAE, 0xCC, 0x8A, 0xAE, 0xCC,
          0x90, 0xB2, 0xCF, 0x93, 0xB4, 0xD0, 0x95, 0xB5, 0xD1, 0x96, 0xB6, 0xD1, 0x95, 0xB5, 0xD1, 0x96, 0xB6, 0xD1, 0x95, 0xB5, 0xD0, 0x94, 0xB4, 0xD0, 0x95, 0xB5, 0xD0, 0x95, 0xB5, 0xD0, 0x8F, 0xB1, 0xCD, 0x84, 0xA9, 0xC8, 0x7B, 0xA3, 0xC5,
          0x79, 0xA1, 0xC4, 0x76, 0x9F, 0xC2, 0x72, 0x9D, 0xC1, 0x6E, 0x99, 0xBE
  };

  GUI_CONST_STORAGE GUI_BITMAP bmSky_888 = {
    70, // xSize
    70, // ySize
    210, // BytesPerLine
    24, // BitsPerPixel
    (unsigned char *)_acSky_888,  // Pointer to picture data
    NULL,  // Pointer to palette
    GUI_DRAW_BMP24
  };

  static GUI_CONST_STORAGE unsigned short _acSky_565[] = {
    0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x7AA5, 0x7AA5, 0x7AA5, 0x7AA4, 0x7AA4, 0x7AA4, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84,
          0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A64, 0x7A64, 0x7A64, 0x7A64, 0x7264, 0x7264, 0x7264, 0x7264, 0x7264, 0x7264, 0x7244, 0x7244, 0x7244, 0x7244, 0x7243, 0x7243, 0x7243, 0x7243, 0x7243, 0x7243, 0x7243, 0x7243, 0x7223, 0x7223,
          0x7223, 0x7223, 0x7223, 0x7223, 0x7223, 0x7223, 0x7223, 0x7223, 0x7223,
    0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x7AA5, 0x7AA5, 0x7AA5, 0x7AA4, 0x7A84, 0x7A84, 0x7A84,
          0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A64, 0x7A64, 0x7A64, 0x7A64, 0x7264, 0x7264, 0x7264, 0x7264, 0x7264, 0x7264, 0x7244, 0x7244, 0x7244, 0x7243, 0x7243, 0x7243, 0x7243, 0x7243, 0x7243, 0x7243, 0x7243, 0x7223,
          0x7223, 0x7223, 0x7223, 0x7223, 0x7223, 0x7223, 0x7223, 0x7223, 0x7223,
    0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x7AA5, 0x7AA5, 0x7AA5, 0x7AA4, 0x7A84,
          0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A64, 0x7A64, 0x7A64, 0x7A64, 0x7264, 0x7264, 0x7264, 0x7264, 0x7264, 0x7264, 0x7244, 0x7244, 0x7244, 0x7243, 0x7243, 0x7243, 0x7243, 0x7243, 0x7243, 0x7243, 0x7243,
          0x7223, 0x7223, 0x7223, 0x7223, 0x7223, 0x7223, 0x7223, 0x7223, 0x7223,
    0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x7AA5, 0x7AA5, 0x7AA5,
          0x7AA4, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A64, 0x7A64, 0x7A64, 0x7A64, 0x7264, 0x7264, 0x7264, 0x7264, 0x7264, 0x7244, 0x7244, 0x7244, 0x7243, 0x7243, 0x7243, 0x7243, 0x7243, 0x7243, 0x7243,
          0x7223, 0x7223, 0x7223, 0x7223, 0x7223, 0x7223, 0x7223, 0x7223, 0x7223,
    0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x7AA5,
          0x7AA5, 0x7AA4, 0x7AA4, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A64, 0x7A64, 0x7A64, 0x7264, 0x7264, 0x7264, 0x7264, 0x7264, 0x7264, 0x7244, 0x7244, 0x7244, 0x7243, 0x7243, 0x7243, 0x7243, 0x7243, 0x7243,
          0x7243, 0x7223, 0x7223, 0x7223, 0x7223, 0x7223, 0x7223, 0x7223, 0x7223,
    0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5,
          0x82A5, 0x7AA5, 0x7AA5, 0x7AA4, 0x7AA4, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A64, 0x7A64, 0x7A64, 0x7A64, 0x7264, 0x7264, 0x7264, 0x7264, 0x7264, 0x7244, 0x7244, 0x7244, 0x7243, 0x7243, 0x7243, 0x7243, 0x7243,
          0x7243, 0x7243, 0x7223, 0x7223, 0x7223, 0x7223, 0x7223, 0x7223, 0x7223,
    0x8AC5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AC5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5,
          0x82A5, 0x82A5, 0x82A5, 0x7AA5, 0x7AA4, 0x7AA4, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A64, 0x7A64, 0x7A64, 0x7A64, 0x7264, 0x7264, 0x7264, 0x7264, 0x7264, 0x7244, 0x7244, 0x7244, 0x7243, 0x7243, 0x7243, 0x7243,
          0x7243, 0x7243, 0x7243, 0x7223, 0x7223, 0x7223, 0x7223, 0x7223, 0x7223,
    0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AC5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82A5, 0x82A5, 0x82A5, 0x82A5,
          0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x7AA5, 0x7AA5, 0x7AA4, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A64, 0x7A64, 0x7A64, 0x7A64, 0x7264, 0x7264, 0x7264, 0x7264, 0x7264, 0x7244, 0x7244, 0x7244, 0x7243, 0x7243, 0x7243,
          0x7243, 0x7243, 0x7243, 0x7243, 0x7223, 0x7223, 0x7223, 0x7223, 0x7223,
    0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AC5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82A5, 0x82A5,
          0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x7AA5, 0x7AA5, 0x7AA4, 0x7AA4, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A64, 0x7A64, 0x7A64, 0x7A64, 0x7264, 0x7264, 0x7264, 0x7264, 0x7244, 0x7244, 0x7244, 0x7243, 0x7243, 0x7243,
          0x7243, 0x7243, 0x7243, 0x7243, 0x7223, 0x7223, 0x7223, 0x7223, 0x7223,
    0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5,
          0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x7AA5, 0x7AA5, 0x7AA4, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A64, 0x7A64, 0x7A64, 0x7A64, 0x7264, 0x7264, 0x7264, 0x7264, 0x7244, 0x7244, 0x7244, 0x7244, 0x7243,
          0x7243, 0x7243, 0x7243, 0x7243, 0x7243, 0x7223, 0x7223, 0x7223, 0x7223,
    0x8AE6, 0x8AE6, 0x8AE6, 0x8AE6, 0x8AE6, 0x8AE6, 0x8AE6, 0x8AE6, 0x8AE6, 0x8AE6, 0x8AE6, 0x8AE6, 0x8AE6, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AC5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5,
          0x82C5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x7AA5, 0x7AA5, 0x7AA4, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A64, 0x7A64, 0x7A64, 0x7A64, 0x7264, 0x7264, 0x7264, 0x7264, 0x7244, 0x7244, 0x7244, 0x7243,
          0x7243, 0x7243, 0x7243, 0x7243, 0x7243, 0x7243, 0x7223, 0x7223, 0x7223,
    0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8AE6, 0x8AE6, 0x8AE6, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AC5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5,
          0x82C5, 0x82C5, 0x82C5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x7AA5, 0x7AA5, 0x7AA4, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A64, 0x7A64, 0x7A64, 0x7A64, 0x7264, 0x7264, 0x7264, 0x7264, 0x7244, 0x7244, 0x7244,
          0x7243, 0x7243, 0x7243, 0x7243, 0x7243, 0x7243, 0x7243, 0x7223, 0x7223,
    0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8AE6, 0x8AE6, 0x8AE6, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AC5, 0x82C5, 0x82C5, 0x82C5,
          0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x7AA5, 0x7AA5, 0x7AA4, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A64, 0x7A64, 0x7A64, 0x7264, 0x7264, 0x7264, 0x7264, 0x7264, 0x7244, 0x7244,
          0x7243, 0x7243, 0x7243, 0x7243, 0x7243, 0x7243, 0x7243, 0x7223, 0x7223,
    0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8AE6, 0x8AE6, 0x8AE6, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x82C5, 0x82C5,
          0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x7AA5, 0x7AA4, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A64, 0x7A64, 0x7A64, 0x7264, 0x7264, 0x7264, 0x7264, 0x7264, 0x7244,
          0x7244, 0x7244, 0x7243, 0x7243, 0x7243, 0x7243, 0x7243, 0x7243, 0x7223,
    0x9306, 0x9306, 0x9306, 0x9306, 0x9306, 0x9306, 0x9306, 0x9306, 0x9306, 0x9306, 0x9306, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8AE6, 0x8AE6, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5,
          0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x7AA5, 0x7AA5, 0x7AA4, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A64, 0x7A64, 0x7A64, 0x7264, 0x7264, 0x7264, 0x7264, 0x7244,
          0x7244, 0x7244, 0x7243, 0x7243, 0x7243, 0x7243, 0x7243, 0x7243, 0x7223,
    0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9306, 0x9306, 0x9306, 0x9306, 0x9306, 0x9306, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8AE6, 0x8AE6, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5,
          0x8AE5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x7AA5, 0x7AA4, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A64, 0x7A64, 0x7A64, 0x7264, 0x7264, 0x7264, 0x7264,
          0x7244, 0x7244, 0x7244, 0x7243, 0x7243, 0x7243, 0x7243, 0x7243, 0x7243,
    0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9306, 0x9306, 0x9306, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8AE6, 0x8AE6, 0x8AE5, 0x8AE5, 0x8AE5,
          0x8AE5, 0x8AE5, 0x8AC5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x7AA5, 0x7AA5, 0x7AA4, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A64, 0x7A64, 0x7264, 0x7264, 0x7264, 0x7264,
          0x7264, 0x7244, 0x7244, 0x7244, 0x7243, 0x7243, 0x7243, 0x7243, 0x7243,
    0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9306, 0x9306, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8AE6, 0x8AE6, 0x8AE5, 0x8AE5,
          0x8AE5, 0x8AE5, 0x8AE5, 0x8AC5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x7AA5, 0x7AA5, 0x7AA4, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A64, 0x7A64, 0x7A64, 0x7264, 0x7264, 0x7264,
          0x7264, 0x7244, 0x7244, 0x7244, 0x7243, 0x7243, 0x7243, 0x7243, 0x7243,
    0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9306, 0x9306, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8AE6, 0x8AE5,
          0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x7AA5, 0x7AA5, 0x7AA4, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A64, 0x7A64, 0x7A64, 0x7264, 0x7264,
          0x7264, 0x7264, 0x7244, 0x7244, 0x7243, 0x7243, 0x7243, 0x7243, 0x7243,
    0x9346, 0x9346, 0x9346, 0x9346, 0x9346, 0x9346, 0x9346, 0x9346, 0x9346, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9306, 0x9306, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8AE6,
          0x8AE6, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x7AA5, 0x7AA4, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A64, 0x7A64, 0x7A64, 0x7264, 0x7264,
          0x7264, 0x7264, 0x7244, 0x7244, 0x7244, 0x7243, 0x7243, 0x7243, 0x7243,
    0x9347, 0x9347, 0x9347, 0x9347, 0x9347, 0x9347, 0x9347, 0x9347, 0x9346, 0x9346, 0x9346, 0x9346, 0x9346, 0x9346, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9306, 0x9306, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06,
          0x8AE6, 0x8AE6, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x7AA5, 0x7AA4, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A64, 0x7A64, 0x7A64, 0x7264,
          0x7264, 0x7264, 0x7264, 0x7244, 0x7244, 0x7244, 0x7243, 0x7243, 0x7243,
    0x9347, 0x9347, 0x9347, 0x9347, 0x9347, 0x9347, 0x9347, 0x9347, 0x9347, 0x9347, 0x9347, 0x9347, 0x9347, 0x9346, 0x9346, 0x9346, 0x9346, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9306, 0x8B06, 0x8B06, 0x8B06, 0x8B06,
          0x8B06, 0x8B06, 0x8AE6, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x7AA5, 0x7AA5, 0x7AA4, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A64, 0x7A64, 0x7A64,
          0x7264, 0x7264, 0x7264, 0x7264, 0x7244, 0x7244, 0x7243, 0x7243, 0x7243,
    0x9347, 0x9347, 0x9347, 0x9B47, 0x9B47, 0x9347, 0x9347, 0x9347, 0x9347, 0x9347, 0x9347, 0x9347, 0x9347, 0x9347, 0x9347, 0x9347, 0x9346, 0x9346, 0x9346, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9306, 0x9306, 0x8B06, 0x8B06,
          0x8B06, 0x8B06, 0x8B06, 0x8AE6, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x7AA5, 0x7AA5, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A64, 0x7A64, 0x7A64,
          0x7264, 0x7264, 0x7264, 0x7264, 0x7244, 0x7244, 0x7244, 0x7243, 0x7243,
    0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B47, 0x9B47, 0x9B47, 0x9B47, 0x9B47, 0x9347, 0x9347, 0x9347, 0x9347, 0x9347, 0x9347, 0x9347, 0x9346, 0x9346, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9306, 0x9306, 0x8B06,
          0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8AE6, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AC5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x7AA5, 0x7AA4, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A64, 0x7A64,
          0x7A64, 0x7264, 0x7264, 0x7264, 0x7264, 0x7244, 0x7244, 0x7243, 0x7243,
    0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B47, 0x9B47, 0x9B47, 0x9347, 0x9347, 0x9347, 0x9347, 0x9347, 0x9346, 0x9346, 0x9346, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9306,
          0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8AE6, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x7AA5, 0x7AA5, 0x7AA4, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A64,
          0x7A64, 0x7264, 0x7264, 0x7264, 0x7264, 0x7244, 0x7244, 0x7244, 0x7243,
    0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B47, 0x9B47, 0x9347, 0x9347, 0x9347, 0x9347, 0x9347, 0x9346, 0x9346, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326,
          0x9306, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8AE6, 0x8AE6, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x7AA5, 0x7AA4, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A64,
          0x7A64, 0x7A64, 0x7264, 0x7264, 0x7264, 0x7264, 0x7244, 0x7244, 0x7243,
    0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B47, 0x9B47, 0x9347, 0x9347, 0x9347, 0x9347, 0x9346, 0x9346, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326,
          0x9326, 0x9306, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8AE6, 0x8AE6, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x7AA5, 0x7AA4, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A64,
          0x7A64, 0x7A64, 0x7264, 0x7264, 0x7264, 0x7264, 0x7244, 0x7244, 0x7243,
    0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B47, 0x9B47, 0x9347, 0x9347, 0x9347, 0x9347, 0x9346, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326,
          0x9326, 0x9326, 0x9306, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8AE6, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AC5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x7AA5, 0x7AA4, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84,
          0x7A64, 0x7A64, 0x7A64, 0x7264, 0x7264, 0x7264, 0x7244, 0x7244, 0x7244,
    0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B47, 0x9347, 0x9347, 0x9347, 0x9347, 0x9346, 0x9346, 0x9326, 0x9326, 0x9326,
          0x9326, 0x9326, 0x9326, 0x9306, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8AE6, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x7AA5, 0x7AA4, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84,
          0x7A64, 0x7A64, 0x7A64, 0x7264, 0x7264, 0x7264, 0x7264, 0x7244, 0x7244,
    0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B47, 0x9347, 0x9347, 0x9347, 0x9347, 0x9346, 0x9346, 0x9326, 0x9326,
          0x9326, 0x9326, 0x9326, 0x9306, 0x9306, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8AE6, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x7AA5, 0x7AA4, 0x7A84, 0x7A84, 0x7A84, 0x7A84, 0x7A84,
          0x7A84, 0x7A64, 0x7A64, 0x7264, 0x7264, 0x7264, 0x7264, 0x7244, 0x7244,
    0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B47, 0x9B47, 0x9347, 0x9347, 0x9347, 0x9346, 0x9346, 0x9326,
          0x9326, 0x9326, 0x9326, 0x9326, 0x9306, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8AE6, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x7AA5, 0x7AA4, 0x7A84, 0x7A84, 0x7A84, 0x7A84,
          0x7A84, 0x7A64, 0x7A64, 0x7A64, 0x7264, 0x7264, 0x7264, 0x7264, 0x7244,
    0xA387, 0xA388, 0xA388, 0xA388, 0xA388, 0xA388, 0xA388, 0xA388, 0xA387, 0xA387, 0xA387, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B47, 0x9347, 0x9347, 0x9347, 0x9346, 0x9326,
          0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9306, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8AE6, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x7AA5, 0x7AA4, 0x7A84, 0x7A84, 0x7A84, 0x7A84,
          0x7A84, 0x7A84, 0x7A64, 0x7A64, 0x7264, 0x7264, 0x7264, 0x7264, 0x7244,
    0xA388, 0xA3A8, 0xA388, 0xA388, 0xA3A8, 0xA388, 0xA388, 0xA388, 0xA388, 0xA388, 0xA388, 0xA387, 0xA387, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B47, 0x9347, 0x9347, 0x9347, 0x9346,
          0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9306, 0x8B06, 0x8B06, 0x8B06, 0x8AE6, 0x8AE6, 0x8AE5, 0x8AE5, 0x8AE5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82A5, 0x82A5, 0x82A5, 0x82A5, 0x7AA5, 0x7AA4, 0x7A84, 0x7A84, 0x7A84, 0x7A84,
          0x7A84, 0x7A84, 0x7A64, 0x7A64, 0x7A84, 0x7A64, 0x7264, 0x7264, 0x7244,
    0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA388, 0xA388, 0xA387, 0xA387, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9347, 0x9347, 0x9347, 0x9347,
          0x9346, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9306, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8AE6, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82A5, 0x82C5, 0x82C5, 0x82A5, 0x7AA5, 0x7AA4, 0x7A84, 0x7A84, 0x7A84,
          0x7A84, 0x7A84, 0x7A64, 0x7A64, 0x7A64, 0x7264, 0x7264, 0x7264, 0x7244,
    0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA388, 0xA388, 0xA387, 0xA387, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9347, 0x9347, 0x9347,
          0x9346, 0x9346, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9306, 0x8B06, 0x8B06, 0x8B06, 0x8AE6, 0x8AE6, 0x8AE5, 0x8AE5, 0x8AE5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x82C5, 0x9BEB, 0xBD52, 0xC572, 0x9BCA, 0x7AA5, 0x7AA4, 0x7A84, 0x7A84, 0x7A84,
          0x7A84, 0x7A84, 0x7A84, 0x7A64, 0x7A64, 0x7264, 0x7264, 0x7264, 0x7264,
    0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA388, 0xA388, 0xA387, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B47, 0x9347, 0x9347,
          0x9347, 0x9346, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9306, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8AE6, 0x8AE5, 0x8AE5, 0x8AE5, 0x8AE5, 0x82C5, 0x82C5, 0x82C5, 0xA42C, 0xD657, 0xE6FA, 0xE6D9, 0xCDF5, 0x9BEB, 0x7AA5, 0x82A5, 0x9369, 0xA42C,
          0x93AA, 0x7A84, 0x7A84, 0x7A64, 0x7A64, 0x7264, 0x7264, 0x7264, 0x7264,
    0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA388, 0xA388, 0xA387, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B47, 0x9347,
          0x9347, 0x9347, 0x9346, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9306, 0x8B06, 0x8B06, 0x8B06, 0x8AE6, 0x8AE6, 0x8AE5, 0x8AE5, 0x8AE5, 0x82C5, 0x8B06, 0xAC8E, 0xD636, 0xE6FA, 0xEF3B, 0xEF1B, 0xDE98, 0xBD31, 0x82C5, 0xAC6E, 0xD636, 0xCDF5,
          0xBD52, 0xA42C, 0x8B07, 0x7AA5, 0x7A64, 0x7A64, 0x7264, 0x7264, 0x7264,
    0xA3A8, 0xA3A8, 0xA3A8, 0xA3C8, 0xA3C8, 0xA3C8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA388, 0xA387, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9347,
          0x9347, 0x9347, 0x9346, 0x9346, 0x9326, 0x9326, 0x9326, 0x9326, 0x9306, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x8B06, 0x9347, 0x8B06, 0x8AE5, 0x8AE6, 0xA3EB, 0xCDF5, 0xE6B9, 0xEF5B, 0xF77D, 0xEF3B, 0xDE98, 0xCDF5, 0xCDF5, 0xDE98, 0xE6D9, 0xE6D9,
          0xDEB8, 0xD616, 0xCDB4, 0xB4F0, 0x82C6, 0x7A64, 0x7264, 0x7264, 0x7264,
    0xA3C8, 0xA3C8, 0xA3C8, 0xA3C8, 0xA3C8, 0xA3C8, 0xA3C8, 0xA3C8, 0xA3C8, 0xA3C8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA388, 0xA387, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B47,
          0x9347, 0x9347, 0x9347, 0x9346, 0x9326, 0x9326, 0x9326, 0x9326, 0x9326, 0x9306, 0x9327, 0x9347, 0xB4AE, 0xCDB3, 0xD636, 0xC593, 0x9389, 0x8AE5, 0x8AE5, 0xC552, 0xEF3B, 0xF79D, 0xF79D, 0xEF5C, 0xE6FA, 0xE71B, 0xEF5C, 0xEF5C, 0xEF7C, 0xF77D,
          0xEF5C, 0xE71B, 0xE6D9, 0xD636, 0xA42C, 0x82C5, 0x7264, 0x7264, 0x7264,
    0xA3C8, 0xA3C8, 0xA3C8, 0xA3C8, 0xA3C8, 0xA3C8, 0xA3C8, 0xA3C8, 0xA3C8, 0xA3C8, 0xA3C8, 0xA3C8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA388, 0xA387, 0x9B87, 0x9B87, 0x9B87, 0x9B87, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67,
          0x9B47, 0x9347, 0x9347, 0x9346, 0x9326, 0x9326, 0x9326, 0x9326, 0x9347, 0xB4AE, 0xCDD4, 0xD636, 0xE6D9, 0xEF5B, 0xEF3B, 0xDEB8, 0xB4CF, 0xA42C, 0xA42C, 0xDE77, 0xF79D, 0xF7BE, 0xF79D, 0xF77D, 0xEF7C, 0xF79D, 0xF79D, 0xF79D, 0xF77C, 0xEF5C,
          0xEF5C, 0xEF3B, 0xE6D9, 0xD616, 0xC593, 0xBD10, 0xA44D, 0xA40C, 0x9BCB,
    0xABC8, 0xABC8, 0xABC8, 0xABC8, 0xABC8, 0xABC8, 0xABC8, 0xABE9, 0xA3C8, 0xA3C8, 0xA3C8, 0xA3C8, 0xA3C8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA388, 0xA387, 0x9B87, 0x9B87, 0x9B87, 0x9B67, 0x9B67, 0x9B67, 0x9B67, 0x9B67,
          0x9B47, 0x9347, 0x9347, 0x9347, 0x9346, 0x9BA9, 0x9BA9, 0x9347, 0xBCEF, 0xDE98, 0xEF5B, 0xF79D, 0xFFDE, 0xF7BE, 0xF79D, 0xEF5C, 0xE6D9, 0xEF3B, 0xEF3B, 0xEF5C, 0xF7BE, 0xF79D, 0xEF7C, 0xEF5C, 0xF79D, 0xF7DE, 0xF7BE, 0xF79D, 0xEF5C, 0xEF3B,
          0xE71A, 0xE6DA, 0xDE98, 0xD657, 0xDE98, 0xE6FA, 0xE6DA, 0xE6DA, 0xD616,
    0xABC8, 0xABC8, 0xABC8, 0xABC8, 0xABC8, 0xABC8, 0xABC8, 0xAC09, 0xABC8, 0xABC8, 0xABC8, 0xA3C8, 0xA3C8, 0xA3C8, 0xA3C8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA388, 0xA388, 0xA387, 0x9B87, 0x9B87, 0x9B87, 0x9B67, 0x9B67, 0x9B67, 0x9B67,
          0x9B67, 0x9B47, 0x9347, 0x9347, 0x9BA8, 0xC551, 0xCDB3, 0xD615, 0xE6FA, 0xF77C, 0xF7BE, 0xFFDF, 0xFFFF, 0xFFDE, 0xF7BD, 0xF7BE, 0xF79D, 0xF7BE, 0xFFDF, 0xFFDE, 0xF7BD, 0xF77D, 0xEF5C, 0xEF5B, 0xF79D, 0xF7BE, 0xF7BE, 0xEF7C, 0xEF1B, 0xE6FA,
          0xE6D9, 0xDE98, 0xDE57, 0xD656, 0xDE98, 0xE71B, 0xEF7C, 0xEF3B, 0xDE77,
    0xABC8, 0xABC8, 0xABC8, 0xABC8, 0xABC8, 0xABC8, 0xABC8, 0xABE8, 0xABC8, 0xABC8, 0xABC8, 0xABC8, 0xA3C8, 0xA3C8, 0xA3C8, 0xA3C8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3A8, 0xA3C8, 0x9B87, 0x9B87, 0x9B87, 0x9B67, 0x9B67, 0x9B67, 0x9B67,
          0x9B67, 0x9B47, 0x9347, 0x9347, 0xA3C9, 0xCDD4, 0xE6B8, 0xEF1B, 0xF79D, 0xFFDE, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFDE, 0xF7BE, 0xF7BE, 0xF7BE, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFDE, 0xF79D, 0xEF3B, 0xEF1B, 0xF77C, 0xF79D, 0xF77C, 0xEF5C, 0xE71A, 0xE6D9,
          0xDEB8, 0xDE77, 0xD636, 0xD616, 0xDE57, 0xDEB9, 0xEF3B, 0xE6FA, 0xDE77,
    0xB46B, 0xB44A, 0xABE8, 0xABE8, 0xABE8, 0xABE8, 0xABE8, 0xABC8, 0xABC8, 0xABC8, 0xABC8, 0xABC8, 0xABC8, 0xA3C8, 0xA3C8, 0xA3C8, 0xA3C8, 0xA3A8, 0xA3A8, 0xA3A8, 0xB48D, 0xABE9, 0xB46C, 0xB46C, 0xAC0A, 0x9B87, 0x9B87, 0x9B87, 0x9B67, 0x9B67, 0x9B67,
          0x9B67, 0x9B67, 0x9347, 0x9347, 0x9B67, 0xC551, 0xE6B8, 0xEF3B, 0xF77C, 0xFFDE, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFDE, 0xF79D, 0xF7BD, 0xF7BD, 0xF7BE, 0xFFFF, 0xFFFF, 0xFFFF, 0xF7BE, 0xEF3B, 0xEF1B, 0xEF5B, 0xEF5B, 0xEF5B, 0xEF5C, 0xEF1B, 0xE6FA,
          0xDEB8, 0xD657, 0xD615, 0xD615, 0xDE57, 0xDE98, 0xDEB9, 0xDEB9, 0xDEB9,
    0xE696, 0xE6B7, 0xD5D2, 0xC52F, 0xCD50, 0xABE9, 0xABE8, 0xABE8, 0xABE8, 0xABC8, 0xABC8, 0xABC8, 0xABE9, 0xABC8, 0xA3C8, 0xA3C8, 0xA3C8, 0xA3A8, 0xA3A8, 0xA3C8, 0xBCEE, 0xBCEE, 0xB48C, 0xB46C, 0xC530, 0xB48C, 0x9B87, 0x9B87, 0x9B67, 0x9B67, 0x9B67,
          0x9B67, 0x9B67, 0x9B47, 0x9347, 0x9347, 0xA3EA, 0xD635, 0xE6B8, 0xDE77, 0xF77C, 0xF79D, 0xF7BE, 0xFFDE, 0xFFDE, 0xF79D, 0xF79D, 0xF79D, 0xF79D, 0xF79D, 0xF79D, 0xF7BD, 0xF77D, 0xEF3B, 0xE6FA, 0xEF3B, 0xEF5C, 0xEF3B, 0xEF1B, 0xE6FA, 0xE6B9,
          0xDE98, 0xD636, 0xD615, 0xCDF5, 0xD616, 0xD657, 0xDE98, 0xE6DA, 0xEF3B,
    0xEEF9, 0xEED8, 0xE697, 0xE676, 0xD5F3, 0xBCAD, 0xBC8B, 0xAC09, 0xABE8, 0xABE8, 0xABE8, 0xB42A, 0xBC8C, 0xABE8, 0xABC8, 0xA3C8, 0xA3C8, 0xA3C8, 0xA3A8, 0xA3A8, 0xB44B, 0xC50F, 0xC550, 0xBCEE, 0xC50F, 0xBCCD, 0xA3A8, 0x9B87, 0x9B87, 0x9B67, 0x9B67,
          0x9B67, 0x9B67, 0x9B47, 0x9347, 0x9347, 0x9347, 0xAC2B, 0xC551, 0xD5F4, 0xE6FA, 0xEF5C, 0xF79D, 0xF7BD, 0xF7BE, 0xF77C, 0xEF5B, 0xEF3B, 0xEF3B, 0xEF3B, 0xEF3B, 0xEF3B, 0xEF1B, 0xE6FA, 0xE6D9, 0xE6FA, 0xEF1B, 0xE71A, 0xE6FA, 0xDE98, 0xDE57,
          0xD636, 0xD615, 0xD615, 0xD5F5, 0xD5F5, 0xD616, 0xDE57, 0xDE77, 0xE6B9,
    0xEEF9, 0xE6B8, 0xE6B7, 0xE697, 0xDDF3, 0xCD71, 0xD591, 0xD5B2, 0xBCCD, 0xABE9, 0xAC09, 0xBCAC, 0xB44A, 0xABC8, 0xABC8, 0xABC8, 0xA3C8, 0xA3C8, 0xA3C8, 0xAC2A, 0xBCEE, 0xCD71, 0xCD71, 0xC550, 0xBCEE, 0xC530, 0xBD0F, 0xB44B, 0xBCCE, 0xA3E9, 0x9B67,
          0x9B67, 0x9B67, 0x9B47, 0x9347, 0x9347, 0x9347, 0xA40A, 0xC551, 0xD636, 0xE6B9, 0xE6FA, 0xEF1A, 0xEF5B, 0xEF5C, 0xEF3B, 0xE6FA, 0xE6FA, 0xE6FA, 0xE6FA, 0xE6F9, 0xE6F9, 0xE6D9, 0xDEB8, 0xDE98, 0xDEB9, 0xE6D9, 0xDEB9, 0xDE98, 0xDE57, 0xD636,
          0xD615, 0xCDF5, 0xCDF5, 0xCDF5, 0xD5F5, 0xCDF5, 0xD616, 0xD616, 0xDE57,
    0xEEF9, 0xEED9, 0xE6D8, 0xE6B8, 0xE676, 0xDE56, 0xE676, 0xE697, 0xDE56, 0xBCAC, 0xB42A, 0xCD50, 0xC52F, 0xB40A, 0xABC8, 0xABC8, 0xA3C8, 0xA3C8, 0xBCEE, 0xD5D3, 0xD615, 0xDE35, 0xD614, 0xD615, 0xDE56, 0xDE77, 0xDE36, 0xD5D3, 0xD5F4, 0xBCCE, 0xA3A9,
          0xAC0A, 0xA3C9, 0x9B88, 0x9347, 0x9347, 0x9347, 0xAC4B, 0xCDB3, 0xD635, 0xDE98, 0xE6F9, 0xEF3B, 0xEF3B, 0xEF3B, 0xEF1A, 0xE6F9, 0xE6D9, 0xE6B8, 0xDEB8, 0xDE98, 0xDE98, 0xDE77, 0xDE77, 0xDE98, 0xDE98, 0xDE98, 0xDE77, 0xD656, 0xD636, 0xD615,
          0xCDF4, 0xCDD4, 0xCDB4, 0xCDB4, 0xCDB4, 0xCDB4, 0xCDD4, 0xCDD4, 0xD615,
    0xEF19, 0xEEF9, 0xEEF9, 0xEEF9, 0xE6D8, 0xE6B7, 0xE697, 0xE676, 0xDE56, 0xD5B2, 0xCD70, 0xD591, 0xC4EE, 0xB44A, 0xAC09, 0xABC8, 0xABC8, 0xABE9, 0xD5D3, 0xDE35, 0xE697, 0xE6B8, 0xEEFA, 0xEF1A, 0xEF5B, 0xF77C, 0xF77C, 0xF77C, 0xEF3B, 0xE6B8, 0xD5F4,
          0xD5D4, 0xD615, 0xCDB3, 0xA3E9, 0x9347, 0x9347, 0x9BA8, 0xC530, 0xD636, 0xE6B8, 0xEF3B, 0xF79D, 0xF77D, 0xEF3B, 0xE6FA, 0xE6D9, 0xDEB8, 0xDE98, 0xDE77, 0xDE57, 0xDE56, 0xDE56, 0xDE56, 0xDE77, 0xDE77, 0xDE77, 0xD636, 0xD636, 0xD615, 0xCDF5,
          0xCDD4, 0xCDB3, 0xCDB3, 0xCDB3, 0xCD93, 0xCDB3, 0xCD93, 0xCDB3, 0xCDD4,
    0xEF1A, 0xEF1A, 0xEEF9, 0xEEF9, 0xE6D8, 0xE6B7, 0xE697, 0xE697, 0xDE76, 0xDE35, 0xDE14, 0xD5D3, 0xC50E, 0xC4EE, 0xC4EE, 0xABE9, 0xABE9, 0xC50F, 0xDE56, 0xE697, 0xEEF9, 0xEF5B, 0xF79D, 0xF79D, 0xF7BE, 0xFFDE, 0xFFDE, 0xFFDF, 0xFFDE, 0xFFDE, 0xF79D,
          0xEF5C, 0xF79D, 0xEF5B, 0xDE56, 0xB4AE, 0x9347, 0x9346, 0xB4AE, 0xDE56, 0xE6FA, 0xF77C, 0xF7BE, 0xF77C, 0xEF3B, 0xE71A, 0xE6D9, 0xDE98, 0xDE77, 0xDE57, 0xD636, 0xD636, 0xD636, 0xD636, 0xDE57, 0xDE77, 0xD656, 0xD636, 0xD615, 0xD5F5, 0xCDD4,
          0xCDB4, 0xCDB3, 0xC593, 0xC592, 0xC592, 0xC592, 0xC592, 0xC592, 0xCD93,
    0xEF1A, 0xEF1A, 0xEEF9, 0xEED9, 0xE6D8, 0xE6B8, 0xE697, 0xE697, 0xE676, 0xDE55, 0xDE35, 0xDE14, 0xD5D3, 0xD592, 0xCD71, 0xAC09, 0xC4EE, 0xDE56, 0xDE77, 0xE6D9, 0xF75B, 0xF79D, 0xF7BE, 0xFFDE, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xFFDE,
          0xFFDE, 0xFFDE, 0xF7BD, 0xEF5C, 0xE6B8, 0xC572, 0xB46C, 0xBD30, 0xEF1A, 0xF77C, 0xF7BE, 0xFFDE, 0xFFDE, 0xF7BD, 0xF7BD, 0xEF5B, 0xE6F9, 0xDE77, 0xD636, 0xD635, 0xD615, 0xD615, 0xD636, 0xDE77, 0xDE77, 0xD636, 0xD615, 0xD5F5, 0xCDD4, 0xCDD4,
          0xCDB3, 0xCD93, 0xC592, 0xC572, 0xC572, 0xC572, 0xC572, 0xC572, 0xC572,
    0xEF1A, 0xEF1A, 0xEF1A, 0xEEF9, 0xE6D8, 0xE6B8, 0xE697, 0xE696, 0xDE55, 0xDE35, 0xDE35, 0xDE14, 0xD5F4, 0xD5F3, 0xD5B2, 0xC52F, 0xCD71, 0xDE56, 0xE6B8, 0xEF1A, 0xF79D, 0xF7BE, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xFFDF,
          0xFFFF, 0xFFDE, 0xF7BE, 0xF79D, 0xEF5C, 0xEF1A, 0xE6B8, 0xEF1A, 0xF77C, 0xFFDE, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFDE, 0xF7BE, 0xEF5C, 0xE6D9, 0xDE97, 0xDE56, 0xD636, 0xD636, 0xD636, 0xDE56, 0xDE57, 0xDE56, 0xD636, 0xD5F5, 0xCDD4, 0xCDD3, 0xCDB3,
          0xCD93, 0xC592, 0xC572, 0xC552, 0xC552, 0xC551, 0xC551, 0xC551, 0xC551,
    0xEF1A, 0xEF19, 0xEF1A, 0xEEF9, 0xEED8, 0xE6D8, 0xE6B7, 0xDE56, 0xDE34, 0xDE34, 0xDE14, 0xDDF4, 0xD5B2, 0xDDF4, 0xD5D2, 0xCD91, 0xD5D2, 0xDE35, 0xE6D8, 0xEF5B, 0xF7BD, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFDE, 0xFFFF,
          0xFFFF, 0xFFFF, 0xFFDF, 0xFFDE, 0xF79D, 0xEF3B, 0xEF5B, 0xF79D, 0xF7BE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xF7BE, 0xF77C, 0xEF3B, 0xEF1A, 0xEF1A, 0xE71A, 0xE6D9, 0xDE97, 0xDE98, 0xE6B8, 0xDE98, 0xDE77, 0xD636, 0xD5F5, 0xCDD4, 0xCDB3, 0xCD93,
          0xC572, 0xC572, 0xC551, 0xC531, 0xBD31, 0xBD31, 0xC551, 0xC551, 0xC551,
    0xEEF9, 0xEEF9, 0xEEF9, 0xEEF9, 0xEED8, 0xE6B8, 0xE696, 0xDE55, 0xDE35, 0xDE14, 0xDE14, 0xDE14, 0xD5D3, 0xD5D3, 0xCD71, 0xCD4F, 0xDE14, 0xEF1A, 0xEF3A, 0xF79D, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDE, 0xFFBE, 0xFFBE, 0xF7BE, 0xFFDE,
          0xFFDE, 0xFFFF, 0xFFFF, 0xFFDE, 0xF79D, 0xF77C, 0xF79D, 0xF7BE, 0xFFDE, 0xFFDE, 0xFFDE, 0xF79D, 0xF79D, 0xF79D, 0xEF5C, 0xEF5B, 0xF77C, 0xF79D, 0xF7BD, 0xF77D, 0xEF5C, 0xEF5C, 0xEF5B, 0xEF1B, 0xE6FA, 0xDE98, 0xD615, 0xCDB3, 0xCD93, 0xC592,
          0xC572, 0xC551, 0xBD30, 0xBD30, 0xBD30, 0xBD30, 0xC531, 0xC551, 0xC551,
    0xEEF9, 0xEEF8, 0xEED8, 0xEED8, 0xE6B7, 0xE697, 0xE655, 0xDE35, 0xDE34, 0xDE14, 0xDDF3, 0xDDF3, 0xDDF3, 0xDDF4, 0xD5D2, 0xE676, 0xEF1A, 0xF77C, 0xF77C, 0xF7BD, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDE, 0xF7BE, 0xF7BD, 0xF79D, 0xF79D, 0xF79D,
          0xF7BD, 0xF7BE, 0xFFDE, 0xFFBE, 0xF79D, 0xF79D, 0xF7BD, 0xFFBE, 0xFFDE, 0xFFDE, 0xFFDF, 0xFFDE, 0xF7BE, 0xF79D, 0xF77C, 0xF77D, 0xF79D, 0xF7BE, 0xFFDE, 0xF7BD, 0xF7BD, 0xF7BD, 0xF77C, 0xEF5B, 0xEF3B, 0xE6FA, 0xDE98, 0xD5F5, 0xCDB3, 0xC592,
          0xC551, 0xC530, 0xBD30, 0xBD10, 0xBD30, 0xC551, 0xC551, 0xC551, 0xC551,
    0xEED8, 0xEED8, 0xE6B8, 0xE6B7, 0xE696, 0xE676, 0xDE55, 0xDE34, 0xDE14, 0xDDF3, 0xDDF3, 0xDDF3, 0xDE14, 0xDE55, 0xE6B7, 0xEF1A, 0xF75B, 0xF77C, 0xF7BD, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDE, 0xF7BD, 0xF79D, 0xF79D, 0xF77C, 0xF77C,
          0xF77C, 0xF77C, 0xF79D, 0xF7BE, 0xF7BE, 0xF7BE, 0xF7BE, 0xF7BE, 0xFFDE, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDE, 0xF79D, 0xF79D, 0xF79D, 0xF7BE, 0xF7BE, 0xF7BE, 0xF7BE, 0xF79D, 0xF77C, 0xEF5C, 0xEF3B, 0xEF1A, 0xE6D9, 0xDE77, 0xD615, 0xCD92,
          0xC551, 0xBD30, 0xBD30, 0xBD10, 0xBD10, 0xBD30, 0xC551, 0xC551, 0xC551,
    0xEED8, 0xEEB8, 0xE6B7, 0xE6B7, 0xEED8, 0xE676, 0xDE35, 0xDE14, 0xDE14, 0xDDF3, 0xDDF3, 0xDE56, 0xE6D8, 0xEF3A, 0xF75B, 0xF75B, 0xF75B, 0xF77C, 0xF79D, 0xFFBE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xF79D, 0xF77C, 0xF77C, 0xF77C, 0xEF5B,
          0xEF5B, 0xEF5C, 0xF77C, 0xF79D, 0xF7BD, 0xF7BD, 0xF79D, 0xF7BD, 0xF7BD, 0xF7BE, 0xFFDE, 0xFFDE, 0xFFDF, 0xFFDF, 0xFFDE, 0xF7BD, 0xF79D, 0xF79D, 0xF79D, 0xF79D, 0xF79D, 0xF77D, 0xF77C, 0xEF5B, 0xEF1B, 0xE6FA, 0xE6D9, 0xDE97, 0xD615, 0xC572,
          0xC551, 0xC530, 0xC530, 0xBD10, 0xBD10, 0xBD30, 0xC551, 0xC571, 0xC551,
    0xE6B7, 0xE697, 0xEED8, 0xEF1A, 0xEF1A, 0xE6D8, 0xE697, 0xE696, 0xDE55, 0xDE35, 0xE696, 0xEF19, 0xF75B, 0xF77C, 0xF79D, 0xF79D, 0xF77C, 0xF77C, 0xF77C, 0xF79D, 0xFFBE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xF79D, 0xF77C, 0xEF5B, 0xEF5B, 0xEF3B,
          0xEF3B, 0xEF3B, 0xF75C, 0xF77C, 0xF79D, 0xF79D, 0xF77C, 0xF79D, 0xF79D, 0xF79D, 0xF7BD, 0xFFBE, 0xFFDE, 0xFFDE, 0xFFBE, 0xF79D, 0xF79D, 0xF79D, 0xF77C, 0xF77C, 0xF77C, 0xEF5B, 0xEF3B, 0xEF1B, 0xE6FA, 0xE6D9, 0xE6D9, 0xE6B8, 0xDE56, 0xCD92,
          0xC530, 0xC530, 0xC530, 0xBD30, 0xBD30, 0xC530, 0xC551, 0xC551, 0xC551,
    0xE696, 0xEEF8, 0xEF1A, 0xEF3A, 0xEF1A, 0xEEF9, 0xEEF9, 0xEEF9, 0xE6B8, 0xEEF9, 0xEF3B, 0xF77C, 0xF79D, 0xF79D, 0xF79D, 0xF79D, 0xF79D, 0xF77C, 0xF77C, 0xF77C, 0xF7BD, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFDE, 0xF7BD, 0xF79D, 0xF77C, 0xEF5B, 0xEF3A, 0xEF1A,
          0xEF1A, 0xEF1A, 0xEF1A, 0xEF3B, 0xEF3B, 0xEF5B, 0xEF5B, 0xEF3B, 0xEF5B, 0xEF5B, 0xF75C, 0xF79D, 0xF79D, 0xF7BD, 0xF7BE, 0xF7BD, 0xF79D, 0xF77C, 0xF77C, 0xEF5C, 0xEF3B, 0xEF1A, 0xE6FA, 0xE6F9, 0xE6D9, 0xE6B8, 0xE6B8, 0xDE97, 0xDE56, 0xCDB3,
          0xC551, 0xBD0F, 0xBD0F, 0xBD0F, 0xBD0F, 0xBD10, 0xBD10, 0xC530, 0xC530,
    0xE676, 0xEEF9, 0xEF3A, 0xEF3A, 0xEF1A, 0xEF19, 0xEF3B, 0xEF3A, 0xEF1A, 0xEF3B, 0xF77C, 0xF7BD, 0xF7BD, 0xF7BD, 0xF79D, 0xF79D, 0xF79D, 0xF79C, 0xF77C, 0xF77C, 0xF79D, 0xFFBE, 0xFFDE, 0xFFDF, 0xFFDE, 0xF79D, 0xF79D, 0xF79D, 0xF75C, 0xEF1A, 0xE6F9,
          0xE6D9, 0xE6D8, 0xE6D9, 0xE6D9, 0xE6D9, 0xE6D9, 0xEEFA, 0xE6F9, 0xE6F9, 0xEEFA, 0xEF1A, 0xEF3B, 0xEF5B, 0xF77C, 0xF77C, 0xF79D, 0xF79D, 0xF77C, 0xEF5B, 0xEF3B, 0xE6FA, 0xE6D9, 0xE6B8, 0xE698, 0xDE97, 0xDE77, 0xDE77, 0xDE56, 0xD635, 0xCDB3,
          0xC551, 0xBD0F, 0xBCEF, 0xBCEE, 0xBCCE, 0xBCEF, 0xBD0F, 0xC551, 0xC551,
    0xE676, 0xEEF9, 0xEF1A, 0xEF3A, 0xEF3A, 0xF73B, 0xF75B, 0xF75B, 0xF77C, 0xF77C, 0xF79D, 0xF7BD, 0xF79D, 0xF79D, 0xF79D, 0xF79D, 0xF79C, 0xF77C, 0xF77C, 0xF77C, 0xF77C, 0xF79D, 0xFFBE, 0xFFDE, 0xFFDE, 0xF7BD, 0xF79D, 0xF79D, 0xF77C, 0xEF3B, 0xEF1A,
          0xEEF9, 0xE6F9, 0xE6D9, 0xE6D8, 0xE6B8, 0xE6B8, 0xE6B8, 0xE6B8, 0xE6B8, 0xE6B8, 0xE6D8, 0xE6D9, 0xEEFA, 0xEF1A, 0xEF3B, 0xEF3B, 0xEF5B, 0xEF3B, 0xEF1A, 0xE6F9, 0xE6B8, 0xDE97, 0xDE76, 0xDE56, 0xDE36, 0xD635, 0xD635, 0xD615, 0xD5F4, 0xCDD3,
          0xC571, 0xBD0F, 0xBCCE, 0xBCCE, 0xBCCE, 0xBCEF, 0xC530, 0xC571, 0xC572,
    0xEED8, 0xEF19, 0xEF1A, 0xF73A, 0xF75B, 0xF75B, 0xF77C, 0xF77C, 0xF77C, 0xF79D, 0xF79D, 0xF7BD, 0xF79D, 0xF79C, 0xF77C, 0xF77C, 0xF77C, 0xF77C, 0xF77C, 0xF75C, 0xF77C, 0xF79C, 0xF7BE, 0xF7BE, 0xF7BD, 0xF79D, 0xF79C, 0xF77C, 0xF77C, 0xEF5B, 0xEF3A,
          0xEEFA, 0xE6F9, 0xEF1A, 0xE6D9, 0xE697, 0xDE77, 0xDE77, 0xDE76, 0xDE76, 0xDE76, 0xDE77, 0xDE97, 0xE6B8, 0xE6B8, 0xE6D9, 0xE6D9, 0xE6F9, 0xE6FA, 0xE6D9, 0xE6B8, 0xDE97, 0xDE56, 0xD615, 0xD5F4, 0xD5F4, 0xD5D4, 0xD5D3, 0xCDD3, 0xCDB3, 0xCD92,
          0xC571, 0xC50F, 0xBCCE, 0xBCCE, 0xB4AD, 0xBCEE, 0xC550, 0xC571, 0xC572,
    0xEEF9, 0xEF1A, 0xF75B, 0xF75B, 0xF75B, 0xF77C, 0xF77C, 0xF77C, 0xF77C, 0xF77C, 0xF79D, 0xF79D, 0xF79C, 0xF77C, 0xF77C, 0xF77C, 0xF77C, 0xF77C, 0xF79C, 0xF79D, 0xF79D, 0xF79D, 0xF79D, 0xF79D, 0xF79C, 0xF77C, 0xF75C, 0xEF5B, 0xEF3B, 0xEF3B, 0xEF3A,
          0xEEF9, 0xEF1A, 0xEF1A, 0xEEF9, 0xE6D8, 0xDE56, 0xDE35, 0xDE56, 0xDE35, 0xDE35, 0xDE35, 0xDE35, 0xDE56, 0xDE76, 0xDE76, 0xDE77, 0xDE97, 0xE698, 0xDE97, 0xDE77, 0xDE56, 0xD615, 0xD5F4, 0xCDD3, 0xCDB3, 0xCD92, 0xCD92, 0xCD72, 0xC571, 0xC551,
          0xC530, 0xBD0F, 0xBCCE, 0xBCCD, 0xB4AD, 0xBCCE, 0xBD0F, 0xC530, 0xC530,
    0xEF1A, 0xF75B, 0xF75B, 0xF77B, 0xF77B, 0xF77C, 0xF77C, 0xF77C, 0xF75B, 0xF75B, 0xF77C, 0xF77C, 0xF77C, 0xF77B, 0xF75B, 0xF75B, 0xF75B, 0xF75B, 0xF77C, 0xF77C, 0xF79C, 0xF79C, 0xF77C, 0xF75C, 0xF75B, 0xEF3B, 0xEF1A, 0xEEFA, 0xEEF9, 0xEEF9, 0xEEF9,
          0xE6F9, 0xE6D9, 0xE6F9, 0xE6D8, 0xE697, 0xDE35, 0xD614, 0xDE15, 0xD614, 0xD5F4, 0xD5F4, 0xD5F4, 0xD614, 0xD614, 0xD615, 0xDE35, 0xDE56, 0xDE56, 0xDE56, 0xDE36, 0xD615, 0xD5F4, 0xD5D3, 0xCDB2, 0xCDB2, 0xCD92, 0xCD71, 0xC551, 0xC551, 0xC550,
          0xC530, 0xC50F, 0xBCEE, 0xBCCE, 0xBCAD, 0xBCAD, 0xBCCE, 0xBCCE, 0xBCEE,
    0xF75B, 0xF75B, 0xF75B, 0xF75B, 0xF75B, 0xF75B, 0xF75B, 0xF75B, 0xF75B, 0xF73B, 0xF73B, 0xF75B, 0xF75B, 0xF75B, 0xF73B, 0xEF3A, 0xEF3A, 0xEF3A, 0xEF3B, 0xEF3B, 0xEF5B, 0xEF5B, 0xEF3B, 0xEF1A, 0xEEF9, 0xEED9, 0xE6D8, 0xE6B7, 0xE697, 0xE697, 0xE6B7,
          0xE697, 0xE697, 0xDE77, 0xDE76, 0xDE15, 0xDE14, 0xD614, 0xD5F4, 0xD5F3, 0xD5D3, 0xCDB2, 0xD5B2, 0xD5B3, 0xD5D3, 0xD5D3, 0xD5F4, 0xD614, 0xD615, 0xD615, 0xD614, 0xD5F4, 0xD5D3, 0xD5D3, 0xCDB2, 0xCDB3, 0xCDB3, 0xCD92, 0xCD71, 0xC551, 0xC551,
          0xC571, 0xC550, 0xBD0F, 0xBCCE, 0xBCCD, 0xBCAD, 0xBCAD, 0xBCAD, 0xBCAD,
    0xF75B, 0xF75B, 0xF73B, 0xF73A, 0xF73A, 0xEF3A, 0xEF3A, 0xEF3A, 0xEF1A, 0xEF1A, 0xEF1A, 0xEF3A, 0xEF1A, 0xEF3A, 0xEF1A, 0xEF19, 0xEEF9, 0xEF19, 0xEF19, 0xEF19, 0xEF1A, 0xEEF9, 0xEEF9, 0xE6D8, 0xE6B8, 0xE697, 0xE676, 0xDE76, 0xDE76, 0xDE76, 0xDE76,
          0xDE56, 0xDE56, 0xDE56, 0xDE35, 0xD5D3, 0xD5B2, 0xD5B2, 0xD5D3, 0xCD92, 0xCD91, 0xCD71, 0xCD71, 0xCD92, 0xCD92, 0xCDB2, 0xD5B2, 0xD5D3, 0xD5F4, 0xD5F4, 0xD5F4, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5B3, 0xCDB3, 0xCDB3, 0xCDB2, 0xCD92, 0xCD92, 0xCD72,
          0xCD92, 0xCD71, 0xC530, 0xBCEE, 0xBCCE, 0xBCAD, 0xBCAD, 0xB4AD, 0xB48D,
    0xF75B, 0xF75B, 0xF73A, 0xEF19, 0xEF19, 0xEF19, 0xEEF9, 0xEEF9, 0xEEF9, 0xEEF9, 0xEF19, 0xEF19, 0xEF19, 0xEF19, 0xEEF9, 0xEEF9, 0xEEF9, 0xEEF9, 0xEED8, 0xEED8, 0xEED8, 0xE6D8, 0xE6B8, 0xE6B7, 0xE697, 0xE676, 0xDE76, 0xDE56, 0xDE56, 0xDE56, 0xDE55,
          0xDE55, 0xDE56, 0xDE56, 0xDE14, 0xD592, 0xCD71, 0xCD91, 0xCD91, 0xCD71, 0xCD71, 0xCD71, 0xCD71, 0xCD71, 0xCD71, 0xCD91, 0xCD92, 0xCDB2, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5B3, 0xD5B3, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5B3, 0xCDB3, 0xCDB2, 0xCDB2, 0xD5D3,
          0xCDB3, 0xCDB2, 0xCD71, 0xC50F, 0xBCEE, 0xBCCE, 0xBCCD, 0xBCAD, 0xB4AD,
    0xF73A, 0xEF1A, 0xEEF9, 0xEEF8, 0xEED8, 0xEED8, 0xEED8, 0xEED8, 0xEEF8, 0xEEF8, 0xEEF9, 0xEEF9, 0xEEF9, 0xEEF9, 0xEEF9, 0xEED8, 0xEED8, 0xEED8, 0xEED8, 0xEED8, 0xE6D8, 0xE6B8, 0xE6B7, 0xE697, 0xE676, 0xE676, 0xE676, 0xE676, 0xDE56, 0xDE56, 0xDE56,
          0xDE55, 0xDE55, 0xDE14, 0xD5B2, 0xCD71, 0xCD71, 0xCD71, 0xCD70, 0xCD70, 0xCD71, 0xCD71, 0xCD92, 0xCD92, 0xCD92, 0xCD92, 0xCDB2, 0xCDB2, 0xD5B2, 0xD5B3, 0xD5B2, 0xCDB2, 0xD5B2, 0xD5B2, 0xD5D3, 0xD5D3, 0xD5D3, 0xD5D3, 0xCDB3, 0xD5B3, 0xD5D3,
          0xD5D3, 0xD5D3, 0xCDB2, 0xC550, 0xC50F, 0xBCEF, 0xBCEE, 0xBCAD, 0xBCAD,
    0xEF19, 0xEEF9, 0xEED8, 0xEEB7, 0xEEB7, 0xEEB7, 0xEEB7, 0xEEB7, 0xEEB7, 0xEED8, 0xEED8, 0xEED8, 0xEEF8, 0xEED8, 0xEED8, 0xEED8, 0xEED8, 0xEED8, 0xEED8, 0xEED8, 0xEED8, 0xE6D8, 0xE6B7, 0xE697, 0xE697, 0xE697, 0xE6B7, 0xE6B7, 0xE697, 0xE676, 0xDE76,
          0xDE35, 0xDE14, 0xD5D3, 0xCD91, 0xCD70, 0xCD70, 0xCD50, 0xCD70, 0xCD71, 0xCD71, 0xD592, 0xD5D3, 0xD5B2, 0xD5B2, 0xD5B2, 0xD5B2, 0xD5B2, 0xD5B2, 0xD5B2, 0xCDB2, 0xCD92, 0xCD92, 0xCDB2, 0xD5B2, 0xD5D3, 0xD5D3, 0xD5B3, 0xCDB2, 0xD5B3, 0xD5D3,
          0xD5B3, 0xD5D3, 0xCDB2, 0xCD51, 0xC50F, 0xC50F, 0xC4EE, 0xBCCE, 0xBCAD,
    0xEEF8, 0xEEF8, 0xEED8, 0xEEB7, 0xEEB7, 0xEEB7, 0xE696, 0xE696, 0xE696, 0xE6B7, 0xEEB7, 0xEED8, 0xEED8, 0xEED8, 0xEED8, 0xEED8, 0xEED8, 0xEED8, 0xEED8, 0xEEF9, 0xEEF9, 0xEED8, 0xE6D8, 0xE6B8, 0xE6D8, 0xE6D8, 0xE6D8, 0xE6D8, 0xE697, 0xE697, 0xE676,
          0xDE35, 0xD5D3, 0xD591, 0xCD71, 0xCD70, 0xCD50, 0xCD50, 0xCD50, 0xCD71, 0xCD71, 0xD5B2, 0xD5F3, 0xD5D3, 0xD5B2, 0xD5B2, 0xD5B2, 0xD5B2, 0xCD92, 0xCD92, 0xCD71, 0xCD71, 0xCD71, 0xCD92, 0xCD92, 0xCDB2, 0xCDB2, 0xCDB2, 0xCDB2, 0xCDB2, 0xCD92,
          0xCDB2, 0xCDB2, 0xCD91, 0xC550, 0xC50F, 0xC50F, 0xC4EE, 0xBCEE, 0xBCCD
  };

  GUI_CONST_STORAGE GUI_BITMAP bmSky_565 = {
    70, // xSize
    70, // ySize
    140, // BytesPerLine
    16, // BitsPerPixel
    (unsigned char *)_acSky_565,  // Pointer to picture data
    NULL,  // Pointer to palette
    GUI_DRAW_BMP565
  };

  static GUI_CONST_STORAGE unsigned short _acSky_444[] = {
    0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752,
          0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
          0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
    0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752,
          0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
          0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
    0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752,
          0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
          0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
    0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0752, 0x0752, 0x0752,
          0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
          0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
    0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0752,
          0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
          0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
    0x0852, 0x0853, 0x0852, 0x0853, 0x0853, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852,
          0x0852, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
          0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
    0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852,
          0x0852, 0x0852, 0x0852, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
          0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
    0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852,
          0x0852, 0x0852, 0x0852, 0x0852, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
          0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
    0x0853, 0x0853, 0x0853, 0x0863, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852,
          0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
          0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
    0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852,
          0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
          0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
    0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852,
          0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
          0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
    0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0852, 0x0852, 0x0852, 0x0852,
          0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
          0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
    0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0852, 0x0852,
          0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
          0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
    0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853,
          0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
          0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
    0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853,
          0x0853, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
          0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
    0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0853, 0x0853, 0x0853,
          0x0853, 0x0853, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0742, 0x0742, 0x0742, 0x0742,
          0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
    0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0853,
          0x0853, 0x0853, 0x0853, 0x0853, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0742, 0x0742, 0x0742,
          0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
    0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863,
          0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0742, 0x0742,
          0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
    0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863,
          0x0863, 0x0853, 0x0853, 0x0853, 0x0853, 0x0853, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0742, 0x0742,
          0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
    0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863,
          0x0863, 0x0863, 0x0863, 0x0853, 0x0853, 0x0853, 0x0853, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0742,
          0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
    0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863,
          0x0863, 0x0863, 0x0863, 0x0863, 0x0853, 0x0853, 0x0853, 0x0853, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0742,
          0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
    0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863,
          0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0853, 0x0853, 0x0853, 0x0853, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752,
          0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
    0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0863, 0x0863, 0x0863, 0x0863,
          0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0853, 0x0853, 0x0853, 0x0853, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752,
          0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
    0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0863, 0x0863, 0x0863,
          0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0853, 0x0853, 0x0853, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752,
          0x0752, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
    0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0863,
          0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0853, 0x0853, 0x0853, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752,
          0x0752, 0x0752, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
    0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963,
          0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0853, 0x0853, 0x0853, 0x0853, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752,
          0x0752, 0x0752, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
    0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963,
          0x0963, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0853, 0x0853, 0x0853, 0x0853, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752,
          0x0752, 0x0752, 0x0752, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
    0x0973, 0x0973, 0x0973, 0x0973, 0x0973, 0x0973, 0x0973, 0x0973, 0x0973, 0x0973, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963,
          0x0963, 0x0963, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0853, 0x0853, 0x0853, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752,
          0x0752, 0x0752, 0x0752, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
    0x0973, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0973, 0x0973, 0x0973, 0x0973, 0x0973, 0x0973, 0x0973, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963,
          0x0963, 0x0963, 0x0963, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0853, 0x0853, 0x0853, 0x0853, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752,
          0x0752, 0x0752, 0x0752, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
    0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0973, 0x0973, 0x0973, 0x0973, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963,
          0x0963, 0x0963, 0x0963, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0853, 0x0853, 0x0853, 0x0853, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752,
          0x0752, 0x0752, 0x0752, 0x0752, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
    0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0973, 0x0973, 0x0973, 0x0973, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963,
          0x0963, 0x0963, 0x0963, 0x0963, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0853, 0x0853, 0x0853, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752,
          0x0752, 0x0752, 0x0752, 0x0752, 0x0742, 0x0742, 0x0742, 0x0742, 0x0742,
    0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0973, 0x0973, 0x0973, 0x0973, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963,
          0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0853, 0x0853, 0x0853, 0x0853, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752,
          0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0742, 0x0742, 0x0742, 0x0742,
    0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0973, 0x0973, 0x0973, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963,
          0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0853, 0x0853, 0x0853, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752,
          0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0742, 0x0742, 0x0742,
    0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0973, 0x0973, 0x0973, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963,
          0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0853, 0x0853, 0x0853, 0x0853, 0x0852, 0x0852, 0x0852, 0x0852, 0x0852, 0x0853, 0x0853, 0x0852, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752,
          0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0742, 0x0742, 0x0742, 0x0742,
    0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0973, 0x0973, 0x0973, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963,
          0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0853, 0x0853, 0x0853, 0x0852, 0x0852, 0x0852, 0x0852, 0x0975, 0x0BA9, 0x0BA9, 0x0975, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752,
          0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0742, 0x0742, 0x0742,
    0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0973, 0x0973, 0x0973, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963,
          0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0853, 0x0853, 0x0853, 0x0852, 0x0852, 0x0852, 0x0A86, 0x0DCB, 0x0EDC, 0x0DDC, 0x0CBA, 0x0975, 0x0752, 0x0852, 0x0964, 0x0A86,
          0x0975, 0x0752, 0x0752, 0x0752, 0x0752, 0x0752, 0x0742, 0x0742, 0x0742,
    0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0973, 0x0973, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963,
          0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0853, 0x0853, 0x0853, 0x0863, 0x0A97, 0x0DCB, 0x0EDC, 0x0EED, 0x0EDD, 0x0DCC, 0x0BA8, 0x0853, 0x0A87, 0x0DCB, 0x0CBA,
          0x0BA9, 0x0A86, 0x0863, 0x0752, 0x0752, 0x0752, 0x0742, 0x0742, 0x0742,
    0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0974, 0x0974, 0x0974, 0x0974, 0x0973, 0x0973, 0x0973, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963,
          0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0963, 0x0863, 0x0853, 0x0863, 0x0A75, 0x0CBA, 0x0DDC, 0x0EED, 0x0EEE, 0x0EDD, 0x0DCC, 0x0CBA, 0x0CBA, 0x0DCC, 0x0DDC, 0x0DDC,
          0x0DDC, 0x0CBA, 0x0CBA, 0x0B98, 0x0853, 0x0752, 0x0742, 0x0742, 0x0742,
    0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0974, 0x0974, 0x0974, 0x0974, 0x0973, 0x0973, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963,
          0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0863, 0x0963, 0x0963, 0x0B97, 0x0CB9, 0x0DCB, 0x0CB9, 0x0974, 0x0853, 0x0853, 0x0BA8, 0x0EDD, 0x0EEE, 0x0FEE, 0x0EED, 0x0EDC, 0x0EDD, 0x0EED, 0x0EED, 0x0EEE, 0x0EEE,
          0x0EED, 0x0EDD, 0x0DDC, 0x0CCB, 0x0A86, 0x0853, 0x0752, 0x0742, 0x0742,
    0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0974, 0x0974, 0x0974, 0x0974, 0x0973, 0x0973, 0x0963, 0x0963, 0x0963, 0x0963,
          0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0B97, 0x0CBA, 0x0DCB, 0x0DDC, 0x0EED, 0x0EED, 0x0DDC, 0x0B97, 0x0A86, 0x0A86, 0x0DCB, 0x0EEE, 0x0FEE, 0x0FEE, 0x0EEE, 0x0EEE, 0x0EEE, 0x0FEE, 0x0FEE, 0x0EEE, 0x0EEE,
          0x0EED, 0x0EED, 0x0DDC, 0x0CCB, 0x0CA9, 0x0B98, 0x0A86, 0x0A86, 0x0975,
    0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0974, 0x0974, 0x0974, 0x0974, 0x0973, 0x0973, 0x0963, 0x0963, 0x0963, 0x0963,
          0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0974, 0x0974, 0x0963, 0x0B97, 0x0DCB, 0x0EED, 0x0EEE, 0x0FFE, 0x0FFE, 0x0FEE, 0x0EED, 0x0DDC, 0x0EED, 0x0EED, 0x0EEE, 0x0FFE, 0x0EEE, 0x0EEE, 0x0EEE, 0x0EEE, 0x0FFF, 0x0FFE, 0x0FEE, 0x0EED, 0x0EDD,
          0x0EDD, 0x0DDC, 0x0DCB, 0x0DCB, 0x0DCC, 0x0EDD, 0x0DDC, 0x0EDC, 0x0CCA,
    0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A84, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0974, 0x0974, 0x0974, 0x0974, 0x0973, 0x0973, 0x0963, 0x0963, 0x0963,
          0x0963, 0x0963, 0x0963, 0x0963, 0x0974, 0x0CA8, 0x0CB9, 0x0DBA, 0x0EDC, 0x0EEE, 0x0FEE, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FEE, 0x0FFE, 0x0EEE, 0x0FFE, 0x0FFF, 0x0FFF, 0x0FEE, 0x0EEE, 0x0EED, 0x0EED, 0x0EEE, 0x0FFE, 0x0FEE, 0x0EEE, 0x0EDD, 0x0EDC,
          0x0DDC, 0x0DCC, 0x0DCB, 0x0DCB, 0x0DCB, 0x0EDD, 0x0EEE, 0x0EDD, 0x0DCB,
    0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0974, 0x0974, 0x0973, 0x0973, 0x0973, 0x0963, 0x0963,
          0x0963, 0x0963, 0x0963, 0x0963, 0x0974, 0x0CB9, 0x0DDC, 0x0EDD, 0x0FEE, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFE, 0x0FEE, 0x0FFE, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0EEE, 0x0EED, 0x0EDD, 0x0EEE, 0x0EEE, 0x0EEE, 0x0EED, 0x0EDD, 0x0DDC,
          0x0DDC, 0x0DCB, 0x0DCB, 0x0CCA, 0x0DCB, 0x0DDC, 0x0EED, 0x0EDD, 0x0DCB,
    0x0B85, 0x0B85, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0B96, 0x0A74, 0x0B86, 0x0B86, 0x0A85, 0x0974, 0x0974, 0x0973, 0x0973, 0x0963, 0x0963,
          0x0963, 0x0963, 0x0963, 0x0963, 0x0964, 0x0BA8, 0x0DDC, 0x0EED, 0x0EEE, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FEE, 0x0FEE, 0x0FEE, 0x0FFE, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FEE, 0x0EED, 0x0EDD, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EDD, 0x0EDC,
          0x0DDC, 0x0DCB, 0x0CBA, 0x0CBA, 0x0DCB, 0x0DCC, 0x0DDC, 0x0DDC, 0x0DDC,
    0x0DCB, 0x0EDB, 0x0DB9, 0x0CA7, 0x0CA8, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0B97, 0x0B97, 0x0B96, 0x0B86, 0x0CA8, 0x0B86, 0x0974, 0x0973, 0x0973, 0x0963, 0x0963,
          0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0A75, 0x0DCA, 0x0DDC, 0x0DCB, 0x0EEE, 0x0EEE, 0x0FFE, 0x0FFF, 0x0FFF, 0x0FEE, 0x0FEE, 0x0EEE, 0x0EEE, 0x0FEE, 0x0FEE, 0x0FEE, 0x0EEE, 0x0EDD, 0x0EDD, 0x0EED, 0x0EED, 0x0EDD, 0x0EDD, 0x0EDC, 0x0DDC,
          0x0DCB, 0x0DCB, 0x0CBA, 0x0CBA, 0x0DCA, 0x0DCB, 0x0DCC, 0x0EDC, 0x0EDD,
    0x0EDC, 0x0EDC, 0x0ECB, 0x0DCB, 0x0DB9, 0x0B96, 0x0B96, 0x0A84, 0x0A74, 0x0A74, 0x0A74, 0x0B85, 0x0B96, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0B85, 0x0B97, 0x0CA8, 0x0B97, 0x0BA7, 0x0B96, 0x0A74, 0x0974, 0x0974, 0x0973, 0x0963,
          0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0A85, 0x0CA8, 0x0CBA, 0x0EDC, 0x0EED, 0x0EEE, 0x0FEE, 0x0FFE, 0x0EEE, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EDD, 0x0EDC, 0x0DDC, 0x0EDC, 0x0EDD, 0x0EDD, 0x0EDC, 0x0DCB, 0x0DCB,
          0x0DCB, 0x0CBA, 0x0CBA, 0x0CBA, 0x0CBA, 0x0DCA, 0x0DCB, 0x0DCB, 0x0DDC,
    0x0EDC, 0x0EDC, 0x0EDB, 0x0DCB, 0x0DB9, 0x0CA8, 0x0CB8, 0x0DB9, 0x0B96, 0x0A74, 0x0A84, 0x0B96, 0x0B85, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0A85, 0x0B97, 0x0CA8, 0x0CA8, 0x0CA8, 0x0B97, 0x0CA8, 0x0B97, 0x0A85, 0x0B97, 0x0A75, 0x0963,
          0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0963, 0x0A85, 0x0CA8, 0x0DCA, 0x0DDC, 0x0EDC, 0x0EDD, 0x0EED, 0x0EED, 0x0EED, 0x0EDD, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0DDC, 0x0DDC, 0x0DCC, 0x0DDC, 0x0DDC, 0x0DDC, 0x0DCB, 0x0DCB, 0x0DCA,
          0x0CBA, 0x0CBA, 0x0CBA, 0x0CBA, 0x0CBA, 0x0CBA, 0x0DCA, 0x0DCA, 0x0DCB,
    0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0DCB, 0x0DCA, 0x0DCB, 0x0DCB, 0x0DCA, 0x0B96, 0x0B85, 0x0CA8, 0x0CA7, 0x0A85, 0x0A74, 0x0A74, 0x0A74, 0x0A74, 0x0B97, 0x0CB9, 0x0DBA, 0x0DCA, 0x0DBA, 0x0DBA, 0x0DCB, 0x0DCB, 0x0DCA, 0x0CB9, 0x0CBA, 0x0B97, 0x0A74,
          0x0A85, 0x0A74, 0x0974, 0x0963, 0x0963, 0x0963, 0x0A86, 0x0CB9, 0x0DCA, 0x0DCC, 0x0EDC, 0x0EED, 0x0EED, 0x0EED, 0x0EDD, 0x0EDC, 0x0DDC, 0x0DDC, 0x0DDC, 0x0DCC, 0x0DCC, 0x0DCB, 0x0DCB, 0x0DCC, 0x0DCC, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DCA, 0x0CBA,
          0x0CBA, 0x0CBA, 0x0CBA, 0x0CBA, 0x0CB9, 0x0CB9, 0x0CBA, 0x0CBA, 0x0CBA,
    0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDB, 0x0DCB, 0x0DCB, 0x0DCA, 0x0CB9, 0x0CA8, 0x0CB8, 0x0C97, 0x0B85, 0x0A84, 0x0A74, 0x0A74, 0x0A74, 0x0DB9, 0x0DCA, 0x0DCB, 0x0EDC, 0x0EDC, 0x0EDD, 0x0EED, 0x0EEE, 0x0EEE, 0x0EEE, 0x0EED, 0x0DDC, 0x0DBA,
          0x0CBA, 0x0DBA, 0x0CB9, 0x0A75, 0x0963, 0x0963, 0x0974, 0x0BA8, 0x0DCB, 0x0DDC, 0x0EED, 0x0FEE, 0x0EEE, 0x0EED, 0x0EDC, 0x0DDC, 0x0DDC, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DCA, 0x0CBA, 0x0CBA,
          0x0CBA, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CBA,
    0x0EDD, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDB, 0x0ECB, 0x0DCB, 0x0DCB, 0x0DCA, 0x0DCA, 0x0DB9, 0x0C97, 0x0C97, 0x0C97, 0x0A74, 0x0A74, 0x0CA7, 0x0DCA, 0x0DCB, 0x0EDC, 0x0EED, 0x0EEE, 0x0FEE, 0x0FFE, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFE, 0x0FEE,
          0x0EED, 0x0EEE, 0x0EED, 0x0DCB, 0x0B97, 0x0963, 0x0963, 0x0B97, 0x0DCB, 0x0EDC, 0x0EEE, 0x0FFE, 0x0EEE, 0x0EED, 0x0EDD, 0x0DDC, 0x0DCC, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DCA, 0x0CBA, 0x0CBA, 0x0CBA,
          0x0CB9, 0x0CB9, 0x0CB9, 0x0CA9, 0x0CA9, 0x0CA9, 0x0CA9, 0x0CA9, 0x0CB9,
    0x0EDD, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDB, 0x0ECB, 0x0DCB, 0x0DCB, 0x0DCA, 0x0DCA, 0x0DBA, 0x0DB9, 0x0CB9, 0x0CA8, 0x0A84, 0x0B97, 0x0DCB, 0x0DCB, 0x0EDC, 0x0EED, 0x0FEE, 0x0FEE, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF,
          0x0FFF, 0x0FFF, 0x0FEE, 0x0EED, 0x0DDC, 0x0CA8, 0x0A86, 0x0BA8, 0x0EDD, 0x0EEE, 0x0FFE, 0x0FFF, 0x0FFF, 0x0FEE, 0x0FEE, 0x0EED, 0x0EDC, 0x0DCB, 0x0DCB, 0x0DCA, 0x0DCA, 0x0DCA, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DBA, 0x0CBA, 0x0CBA, 0x0CB9,
          0x0CB9, 0x0CB9, 0x0CA9, 0x0CA9, 0x0CA9, 0x0CA9, 0x0CA9, 0x0CA9, 0x0CA9,
    0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDB, 0x0ECB, 0x0DCB, 0x0DCA, 0x0DCA, 0x0DCA, 0x0DBA, 0x0DB9, 0x0DB9, 0x0CB9, 0x0CA7, 0x0CA8, 0x0DCB, 0x0EDB, 0x0EDC, 0x0FEE, 0x0FFE, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF,
          0x0FFF, 0x0FFF, 0x0FFE, 0x0EEE, 0x0EED, 0x0EDD, 0x0DDC, 0x0EDD, 0x0EEE, 0x0FFE, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFE, 0x0EED, 0x0EDC, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DCA, 0x0DCA, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DCB, 0x0CBA, 0x0CBA, 0x0CB9, 0x0CB9,
          0x0CB9, 0x0CA9, 0x0CA9, 0x0CA8, 0x0CA8, 0x0CA8, 0x0BA8, 0x0CA8, 0x0CA8,
    0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDB, 0x0DCA, 0x0DCA, 0x0DCA, 0x0DCA, 0x0DB9, 0x0DB9, 0x0DB9, 0x0DB9, 0x0CA8, 0x0DB9, 0x0DCA, 0x0EDC, 0x0EED, 0x0FEE, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF,
          0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FEE, 0x0EDD, 0x0EED, 0x0FEE, 0x0FFE, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FEE, 0x0EEE, 0x0EDD, 0x0EDD, 0x0EDD, 0x0EDD, 0x0EDC, 0x0DCB, 0x0DCB, 0x0DDC, 0x0DCB, 0x0DCB, 0x0DCB, 0x0CBA, 0x0CB9, 0x0CB9, 0x0CB9,
          0x0CA9, 0x0CA9, 0x0BA8, 0x0BA8, 0x0BA8, 0x0BA8, 0x0BA8, 0x0CA8, 0x0BA8,
    0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDB, 0x0DCB, 0x0DCA, 0x0DCA, 0x0DCA, 0x0DBA, 0x0DB9, 0x0DB9, 0x0DB9, 0x0CA8, 0x0CA7, 0x0DBA, 0x0EDC, 0x0EDD, 0x0FEE, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFE, 0x0FFE, 0x0FFE, 0x0FFF,
          0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FEE, 0x0EEE, 0x0EEE, 0x0FFE, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FEE, 0x0FEE, 0x0EEE, 0x0EED, 0x0EED, 0x0EEE, 0x0FEE, 0x0FEE, 0x0EEE, 0x0EED, 0x0EED, 0x0EED, 0x0EDD, 0x0EDC, 0x0DCC, 0x0CBA, 0x0CB9, 0x0CB9, 0x0CA9,
          0x0CA8, 0x0BA8, 0x0BA8, 0x0BA8, 0x0BA8, 0x0BA8, 0x0BA8, 0x0BA8, 0x0BA8,
    0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDB, 0x0ECB, 0x0DCA, 0x0DCA, 0x0DCA, 0x0DBA, 0x0DB9, 0x0DB9, 0x0DB9, 0x0DBA, 0x0DB9, 0x0DCB, 0x0EDC, 0x0EED, 0x0EEE, 0x0FEE, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFE, 0x0FEE, 0x0FEE, 0x0FEE, 0x0FEE,
          0x0FEE, 0x0FFE, 0x0FFF, 0x0FFE, 0x0FEE, 0x0FEE, 0x0FEE, 0x0FFE, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFE, 0x0EEE, 0x0EEE, 0x0EEE, 0x0EEE, 0x0FFE, 0x0FFF, 0x0FEE, 0x0FEE, 0x0FEE, 0x0EEE, 0x0EED, 0x0EED, 0x0EDD, 0x0DCB, 0x0CBA, 0x0CB9, 0x0CA9,
          0x0CA8, 0x0BA8, 0x0BA8, 0x0BA8, 0x0BA8, 0x0BA8, 0x0CA8, 0x0CA8, 0x0CA8,
    0x0EDC, 0x0EDC, 0x0EDB, 0x0EDB, 0x0ECB, 0x0DCB, 0x0DCA, 0x0DCA, 0x0DBA, 0x0DB9, 0x0DB9, 0x0DB9, 0x0DCA, 0x0DCA, 0x0EDB, 0x0EDC, 0x0EED, 0x0EEE, 0x0FEE, 0x0FFE, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FEE, 0x0FEE, 0x0EEE, 0x0EEE, 0x0EEE,
          0x0EEE, 0x0EEE, 0x0FEE, 0x0FFE, 0x0FFE, 0x0FFE, 0x0FFE, 0x0FFE, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FEE, 0x0FEE, 0x0FEE, 0x0FEE, 0x0FFE, 0x0FFE, 0x0FEE, 0x0FEE, 0x0EEE, 0x0EED, 0x0EED, 0x0EDD, 0x0DDC, 0x0DCB, 0x0DBA, 0x0CA9,
          0x0CA8, 0x0BA8, 0x0BA8, 0x0BA8, 0x0BA8, 0x0BA8, 0x0CA8, 0x0CA8, 0x0CA8,
    0x0EDC, 0x0EDB, 0x0EDB, 0x0EDB, 0x0EDC, 0x0DCA, 0x0DCA, 0x0DCA, 0x0DBA, 0x0DB9, 0x0DB9, 0x0DCA, 0x0EDC, 0x0EDD, 0x0EED, 0x0EED, 0x0EED, 0x0EEE, 0x0FEE, 0x0FFE, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FEE, 0x0EEE, 0x0EEE, 0x0EED, 0x0EED,
          0x0EED, 0x0EED, 0x0EEE, 0x0FEE, 0x0FEE, 0x0FEE, 0x0FEE, 0x0FEE, 0x0FEE, 0x0FFE, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FEE, 0x0FEE, 0x0EEE, 0x0EEE, 0x0FEE, 0x0FEE, 0x0EEE, 0x0EEE, 0x0EED, 0x0EDD, 0x0EDC, 0x0DDC, 0x0DCB, 0x0DCA, 0x0CA9,
          0x0CA8, 0x0BA8, 0x0BA8, 0x0BA8, 0x0BA8, 0x0BA8, 0x0CA8, 0x0CA8, 0x0CA8,
    0x0EDB, 0x0ECB, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0ECB, 0x0ECB, 0x0DCA, 0x0DCA, 0x0DCB, 0x0EDC, 0x0EED, 0x0EEE, 0x0FEE, 0x0FEE, 0x0EEE, 0x0EEE, 0x0EEE, 0x0FEE, 0x0FFE, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FEE, 0x0EEE, 0x0EED, 0x0EED, 0x0EED,
          0x0EDD, 0x0EED, 0x0EED, 0x0EEE, 0x0EEE, 0x0FEE, 0x0EEE, 0x0EEE, 0x0EEE, 0x0EEE, 0x0FEE, 0x0FFE, 0x0FFF, 0x0FFF, 0x0FFE, 0x0FEE, 0x0FEE, 0x0EEE, 0x0EEE, 0x0EEE, 0x0EEE, 0x0EED, 0x0EED, 0x0EDD, 0x0EDC, 0x0EDC, 0x0EDC, 0x0DDC, 0x0DCB, 0x0CB9,
          0x0BA8, 0x0BA8, 0x0BA8, 0x0BA8, 0x0BA8, 0x0BA8, 0x0CA8, 0x0CA8, 0x0CA8,
    0x0ECB, 0x0EDC, 0x0EDC, 0x0EDD, 0x0EDD, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDB, 0x0EDC, 0x0EED, 0x0EED, 0x0FEE, 0x0FEE, 0x0FEE, 0x0FEE, 0x0FEE, 0x0EEE, 0x0EEE, 0x0EEE, 0x0FEE, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FEE, 0x0FEE, 0x0EED, 0x0EED, 0x0EDD, 0x0EDD,
          0x0EDC, 0x0EDD, 0x0EDD, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EEE, 0x0FEE, 0x0FEE, 0x0FEE, 0x0FEE, 0x0FEE, 0x0EEE, 0x0EED, 0x0EED, 0x0EED, 0x0EDD, 0x0EDC, 0x0EDC, 0x0EDC, 0x0DDC, 0x0DDC, 0x0DCB, 0x0DCB, 0x0CB9,
          0x0CA8, 0x0BA7, 0x0B97, 0x0B97, 0x0B97, 0x0BA8, 0x0BA8, 0x0BA8, 0x0BA8,
    0x0ECB, 0x0EDC, 0x0EDD, 0x0EDD, 0x0EDC, 0x0EDC, 0x0EED, 0x0EED, 0x0EDD, 0x0EED, 0x0FEE, 0x0FEE, 0x0FEE, 0x0FEE, 0x0FEE, 0x0FEE, 0x0FEE, 0x0FEE, 0x0EEE, 0x0EEE, 0x0FEE, 0x0FFE, 0x0FFF, 0x0FFF, 0x0FFF, 0x0FEE, 0x0FEE, 0x0FEE, 0x0EED, 0x0EDD, 0x0EDC,
          0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDD, 0x0EED, 0x0EED, 0x0EEE, 0x0EEE, 0x0EEE, 0x0EEE, 0x0EEE, 0x0EED, 0x0EED, 0x0EDC, 0x0EDC, 0x0DDC, 0x0DCC, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DCA, 0x0CB9,
          0x0CA8, 0x0B97, 0x0B97, 0x0B97, 0x0B97, 0x0B97, 0x0B97, 0x0CA8, 0x0CA8,
    0x0ECA, 0x0EDC, 0x0EDC, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0FEE, 0x0FEE, 0x0FEE, 0x0FEE, 0x0FEE, 0x0FEE, 0x0FEE, 0x0FEE, 0x0EEE, 0x0EED, 0x0EEE, 0x0EEE, 0x0FEE, 0x0FFE, 0x0FFF, 0x0FFE, 0x0FEE, 0x0FEE, 0x0FEE, 0x0EEE, 0x0EED, 0x0EDC,
          0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0DDC, 0x0DDB, 0x0DDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDD, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EDD, 0x0EDC, 0x0DDC, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DCA, 0x0DCA, 0x0DCA, 0x0DCA, 0x0DBA, 0x0CB9,
          0x0CA8, 0x0BA7, 0x0B97, 0x0B97, 0x0B97, 0x0B97, 0x0BA8, 0x0CA8, 0x0CA8,
    0x0EDB, 0x0EDC, 0x0EDC, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0FEE, 0x0FEE, 0x0FEE, 0x0FEE, 0x0FEE, 0x0FEE, 0x0FEE, 0x0EEE, 0x0EEE, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0FEE, 0x0FFE, 0x0FFE, 0x0FEE, 0x0FEE, 0x0FEE, 0x0EEE, 0x0EED, 0x0EED, 0x0EDD,
          0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0DDC, 0x0DCB, 0x0DCB, 0x0DCA, 0x0DBA, 0x0CBA, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9,
          0x0CA8, 0x0BA7, 0x0B97, 0x0B97, 0x0B96, 0x0B97, 0x0CA8, 0x0CA8, 0x0CA8,
    0x0EDC, 0x0EDC, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0FEE, 0x0FEE, 0x0EED, 0x0FEE, 0x0FEE, 0x0FEE, 0x0FEE, 0x0FEE, 0x0EED, 0x0EED, 0x0EED, 0x0EEE, 0x0FEE, 0x0FEE, 0x0FEE, 0x0FEE, 0x0FEE, 0x0FEE, 0x0FEE, 0x0EEE, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EDD,
          0x0EDC, 0x0EDC, 0x0EDD, 0x0EDC, 0x0EDC, 0x0DCB, 0x0DCA, 0x0DCB, 0x0DCA, 0x0DCA, 0x0DCA, 0x0DCA, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DCA, 0x0CBA, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CA9, 0x0CA8, 0x0CA8, 0x0CA8,
          0x0CA8, 0x0B97, 0x0B97, 0x0B97, 0x0B96, 0x0B97, 0x0B97, 0x0CA8, 0x0CA8,
    0x0EDC, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EEE, 0x0FEE, 0x0FEE, 0x0EEE, 0x0EED, 0x0EED, 0x0EED, 0x0EDD, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC,
          0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0DCB, 0x0DCA, 0x0DBA, 0x0DCA, 0x0DBA, 0x0DBA, 0x0DB9, 0x0DBA, 0x0DBA, 0x0DBA, 0x0DBA, 0x0DCA, 0x0DCA, 0x0DCB, 0x0DCB, 0x0DCA, 0x0DCA, 0x0DBA, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CA8, 0x0CA8, 0x0CA8, 0x0CA8,
          0x0CA8, 0x0BA7, 0x0B97, 0x0B97, 0x0B96, 0x0B96, 0x0B97, 0x0B97, 0x0B97,
    0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EDD, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EDD, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDB, 0x0DCB, 0x0DCB, 0x0EDB,
          0x0ECB, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DCA, 0x0DBA, 0x0DBA, 0x0DBA, 0x0DB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0DBA, 0x0DBA, 0x0DBA, 0x0DCA, 0x0DBA, 0x0DBA, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CA9, 0x0CA8, 0x0CA8, 0x0CA8,
          0x0CA8, 0x0CA8, 0x0B97, 0x0B97, 0x0B96, 0x0B96, 0x0B96, 0x0B96, 0x0B96,
    0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EED, 0x0EDD, 0x0EDD, 0x0EDC, 0x0EDC, 0x0EDD, 0x0EDD, 0x0EDD, 0x0EDD, 0x0EDD, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDB, 0x0ECB, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DCB,
          0x0DCB, 0x0DCB, 0x0DCB, 0x0DCA, 0x0DB9, 0x0CB9, 0x0CB9, 0x0DB9, 0x0CB9, 0x0CA8, 0x0CA8, 0x0CA8, 0x0CA8, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0DB9, 0x0DBA, 0x0DBA, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CA9, 0x0CA8,
          0x0CB9, 0x0CA8, 0x0CA8, 0x0B97, 0x0B97, 0x0B96, 0x0B96, 0x0B96, 0x0B96,
    0x0EED, 0x0EED, 0x0EDD, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDB, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DCA, 0x0DCA, 0x0DCA, 0x0DCA,
          0x0DCA, 0x0DCA, 0x0DCA, 0x0DCA, 0x0CB9, 0x0CA8, 0x0CA8, 0x0CA8, 0x0CA8, 0x0CA8, 0x0CA8, 0x0CA8, 0x0CA8, 0x0CA8, 0x0CA8, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9,
          0x0CB9, 0x0CB9, 0x0CA8, 0x0BA7, 0x0B97, 0x0B97, 0x0B97, 0x0B96, 0x0B96,
    0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDB, 0x0EDB, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DCB, 0x0DCA, 0x0DCA, 0x0DCA,
          0x0DCA, 0x0DCA, 0x0DCA, 0x0DB9, 0x0CA8, 0x0CA8, 0x0CA8, 0x0CA8, 0x0CA8, 0x0CA8, 0x0CA8, 0x0CB8, 0x0CB9, 0x0CA8, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0DB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9,
          0x0CB9, 0x0CB9, 0x0CB9, 0x0CA8, 0x0B97, 0x0B97, 0x0B97, 0x0B96, 0x0B96,
    0x0EDC, 0x0EDC, 0x0EDC, 0x0EDB, 0x0EDB, 0x0EDB, 0x0EDB, 0x0EDB, 0x0EDB, 0x0EDB, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDB, 0x0ECB, 0x0ECB, 0x0ECB, 0x0EDB, 0x0EDB, 0x0DCB, 0x0DCB, 0x0DCB,
          0x0DCA, 0x0DBA, 0x0DB9, 0x0CA8, 0x0CA8, 0x0CA8, 0x0CA8, 0x0CA8, 0x0CA8, 0x0CA8, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9,
          0x0CB9, 0x0CB9, 0x0CB9, 0x0CA8, 0x0CA7, 0x0B97, 0x0B97, 0x0B97, 0x0B96,
    0x0EDC, 0x0EDC, 0x0EDC, 0x0EDB, 0x0EDB, 0x0EDB, 0x0ECB, 0x0ECB, 0x0ECB, 0x0EDB, 0x0EDB, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDB, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0EDC, 0x0ECB, 0x0DCB, 0x0DCB,
          0x0DCA, 0x0DB9, 0x0CB8, 0x0CA8, 0x0CA8, 0x0CA8, 0x0CA8, 0x0CA8, 0x0CA8, 0x0CA8, 0x0CB9, 0x0DB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CA8, 0x0CA8, 0x0CA8, 0x0CA8, 0x0CA8, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9, 0x0CB9,
          0x0CB9, 0x0CB9, 0x0CA8, 0x0CA8, 0x0CA7, 0x0C97, 0x0B97, 0x0B97, 0x0B96
  };

  GUI_CONST_STORAGE GUI_BITMAP bmSky_444 = {
    70, // xSize
    70, // ySize
    140, // BytesPerLine
    16, // BitsPerPixel
    (unsigned char *)_acSky_444,  // Pointer to picture data
    NULL,  // Pointer to palette
    GUI_DRAW_BMP444_12
  };

  static const PAL_BITMAP_CONTEXT _aColorBitmaps[] = {
    { &bmSky_888 },
    { &bmSky_565 },
    { &bmSky_444 }
  };

  static const char * _aacColorText[] = {
    "888",
    "565",
    "444"
  };

#endif

/*********************************************************************
*
*       Car
*/
static const unsigned char _acCar[] = {
  /* RLE: 4341 Pixels @ 000,000 */ 254, 0xFF, 254, 0xFF, 254, 0xFF, 254, 0xFF, 254, 0xFF, 254, 0xFF, 254, 0xFF, 254, 0xFF, 254, 0xFF, 254, 0xFF, 254, 0xFF, 254, 0xFF, 254, 0xFF, 254, 0xFF, 254, 0xFF, 254, 0xFF, 254, 0xFF, 23, 0xFF,
  /* ABS: 040 Pixels @ 141,014 */ 0, 40, 0xFE, 0xFE, 0xFD, 0xFB, 0xF7, 0xF1, 0xF0, 0xED, 0xE7, 0xE3, 0xE3, 0xE0, 0xD9, 0xD7, 0xD7, 0xD5, 0xD5, 0xD6, 0xD7, 0xD1, 0xCB, 0xCB, 0xCE, 0xCC, 0xCE, 0xCF, 0xD0, 0xD5, 0xDA, 0xDF, 0xDF, 0xE4, 0xE4, 0xEA, 0xEF,
        0xF4, 0xF9, 0xFC, 0xFD, 0xFE,
  /* RLE: 252 Pixels @ 181,014 */ 252, 0xFF,
  /* ABS: 055 Pixels @ 133,015 */ 0, 55, 0xFD, 0xF4, 0xD8, 0xC7, 0xAE, 0xA1, 0x9A, 0x8E, 0x7D, 0x79, 0x6B, 0x60, 0x5C, 0x4E, 0x4F, 0x4D, 0x3C, 0x32, 0x32, 0x2D, 0x20, 0x1C, 0x1C, 0x18, 0x18, 0x1B, 0x1C, 0x11, 0x06, 0x09, 0x0C, 0x19, 0x28, 0x2A, 0x1D,
        0x1D, 0x25, 0x2F, 0x2E, 0x3B, 0x39, 0x43, 0x4E, 0x59, 0x60, 0x67, 0x6E, 0x78, 0x8E, 0x9E, 0xAF, 0xCA, 0xE9, 0xF6, 0xFB,
  /* RLE: 240 Pixels @ 188,015 */ 240, 0xFF,
  /* ABS: 069 Pixels @ 128,016 */ 0, 69, 0xF6, 0xC5, 0xA0, 0x63, 0x40, 0x3B, 0x3C, 0x44, 0x4A, 0x4C, 0x4D, 0x43, 0x54, 0x55, 0x5B, 0x62, 0x53, 0x55, 0x3D, 0x28, 0x21, 0x27, 0x14, 0x13, 0x19, 0x18, 0x1A, 0x24, 0x28, 0x2B, 0x2E, 0x2F, 0x2F, 0x2F, 0x2C,
        0x2B, 0x2B, 0x31, 0x41, 0x2D, 0x2F, 0x2F, 0x35, 0x2E, 0x38, 0x43, 0x45, 0x5C, 0x61, 0x64, 0x6F, 0x76, 0x80, 0x68, 0x63, 0x52, 0x4A, 0x4D, 0x45, 0x40, 0x44, 0x46, 0x60, 0x76, 0xA9, 0xBB, 0xD0, 0xE6, 0xF9,
  /* RLE: 228 Pixels @ 197,016 */ 228, 0xFF,
  /* ABS: 078 Pixels @ 125,017 */ 0, 78, 0xF8, 0xDA, 0x8D, 0x52, 0x33, 0x50, 0x73, 0x8A, 0x9F, 0x90, 0x78, 0x64, 0x53, 0x44, 0x3F, 0x3B, 0x3C, 0x56, 0x66, 0x76, 0x83, 0x8F, 0xA1, 0xA3, 0xB6, 0xBB, 0xC9, 0xCF, 0xCE, 0xCB, 0xCE, 0xD1, 0xD3, 0xD4, 0xCF,
        0xCD, 0xCF, 0xCC, 0xCC, 0xCE, 0xCE, 0xCC, 0xC6, 0xC4, 0xC3, 0xBB, 0xB5, 0xB2, 0xA3, 0x9A, 0x8A, 0x7F, 0x75, 0x67, 0x4F, 0x42, 0x42, 0x46, 0x4C, 0x61, 0x6F, 0x81, 0x8A, 0x9B, 0x93, 0x88, 0x78, 0x5D, 0x45, 0x3C, 0x42, 0x53, 0x7B, 0xA8, 0xD5, 0xE9,
        0xF4, 0xFE,
  /* RLE: 221 Pixels @ 203,017 */ 221, 0xFF,
  /* ABS: 081 Pixels @ 124,018 */ 0, 81, 0xC3, 0x69, 0x19, 0x05, 0x2F, 0x4B, 0x3D, 0x30, 0x3B, 0x47, 0x65, 0x79, 0x92, 0xB2, 0xC9, 0xDC, 0xE9, 0xF2, 0xE6, 0xD6, 0xBF, 0xB7, 0xA9, 0xA6, 0x96, 0x90, 0x8B, 0x78, 0x75, 0x7A, 0x63, 0x58, 0x58, 0x58, 0x55,
        0x41, 0x3B, 0x40, 0x3C, 0x40, 0x46, 0x43, 0x43, 0x4C, 0x4C, 0x52, 0x45, 0x4B, 0x57, 0x5E, 0x60, 0x5F, 0x6D, 0x7C, 0x7C, 0x7B, 0x84, 0x7E, 0x8B, 0x88, 0x74, 0x64, 0x69, 0x58, 0x4C, 0x37, 0x39, 0x4D, 0x6E, 0x84, 0x91, 0x90, 0x85, 0x6D, 0x51, 0x2A,
        0x2E, 0x57, 0x91, 0xD2, 0xFA,
  /* RLE: 216 Pixels @ 205,018 */ 216, 0xFF,
  /* ABS: 086 Pixels @ 121,019 */ 0, 86, 0xFC, 0xCE, 0x63, 0x1E, 0x22, 0x35, 0x54, 0x82, 0xAD, 0xC5, 0xD6, 0xCD, 0xC3, 0xBB, 0xAC, 0x8E, 0x6A, 0x54, 0x54, 0x49, 0x40, 0x44, 0x44, 0x49, 0x4D, 0x4F, 0x5F, 0x73, 0x74, 0x8E, 0x91, 0x75, 0x1B, 0x87, 0xAE,
        0xAA, 0x53, 0x36, 0xAF, 0xBE, 0xC5, 0xC5, 0xC1, 0xC2, 0xC6, 0xC6, 0xC4, 0xB8, 0xC0, 0xC5, 0xC5, 0xC4, 0xB8, 0xAE, 0xAD, 0xA8, 0xA3, 0x97, 0x91, 0x80, 0x6A, 0x56, 0x50, 0x4A, 0x48, 0x47, 0x43, 0x50, 0x3F, 0x37, 0x37, 0x48, 0x3D, 0x36, 0x42, 0x3B,
        0x44, 0x88, 0xD0, 0xC0, 0x86, 0x43, 0x2A, 0x45, 0xA7, 0xEB,
  /* RLE: 213 Pixels @ 207,019 */ 213, 0xFF,
  /* ABS: 040 Pixels @ 120,020 */ 0, 40, 0xF8, 0x9F, 0x2B, 0x2E, 0xB0, 0xD0, 0xE6, 0xF3, 0xE2, 0xA6, 0x78, 0x4E, 0x39, 0x35, 0x53, 0x69, 0x7C, 0x98, 0xA6, 0xC2, 0xCC, 0xD6, 0xE0, 0xE5, 0xF0, 0xF6, 0xFA, 0xFC, 0xFF, 0xFF, 0xFF, 0xFC, 0x8E, 0x50, 0xF1,
        0xFF, 0xC9, 0x28, 0xC0, 0xFE,
  /* RLE: 021 Pixels @ 160,020 */ 21, 0xFF,
  /* ABS: 027 Pixels @ 181,020 */ 0, 27, 0xFE, 0xFB, 0xF9, 0xF1, 0xEA, 0xDE, 0xD3, 0xC5, 0xAC, 0x95, 0x77, 0x56, 0x39, 0x34, 0x79, 0xBD, 0x9B, 0x41, 0x44, 0xE9, 0xFD, 0xEE, 0xC4, 0x7E, 0x26, 0x5A, 0xE6,
  /* RLE: 211 Pixels @ 208,020 */ 211, 0xFF,
  /* ABS: 015 Pixels @ 119,021 */ 0, 15, 0xD0, 0x57, 0x24, 0x15, 0x42, 0xF2, 0xF8, 0xAE, 0x59, 0x3A, 0x4D, 0x18, 0x8A, 0xDE, 0xF5,
  /* RLE: 017 Pixels @ 134,021 */ 17, 0xFF,
  /* ABS: 008 Pixels @ 151,021 */ 0, 8, 0xEC, 0x3D, 0xA6, 0xFF, 0xE5, 0x41, 0x80, 0xFD,
  /* RLE: 034 Pixels @ 159,021 */ 34, 0xFF,
  /* ABS: 016 Pixels @ 193,021 */ 0, 16, 0xF5, 0xC6, 0x51, 0x38, 0xD2, 0xED, 0x5C, 0x61, 0xF4, 0xFF, 0xFF, 0xFF, 0xD8, 0x34, 0x6F, 0xFD,
  /* RLE: 005 Pixels @ 209,021 */ 5, 0xFF,
  /* ABS: 009 Pixels @ 214,021 */ 0, 9, 0xFD, 0xEA, 0xC8, 0xB6, 0xAA, 0xA9, 0xB3, 0xD0, 0xF7,
  /* RLE: 194 Pixels @ 223,021 */ 194, 0xFF,
  /* ABS: 015 Pixels @ 117,022 */ 0, 15, 0xF9, 0xA9, 0x39, 0x49, 0x32, 0x5F, 0xDA, 0xC4, 0x5D, 0x31, 0x7B, 0xAC, 0x5B, 0x52, 0xEB,
  /* RLE: 019 Pixels @ 132,022 */ 19, 0xFF,
  /* ABS: 007 Pixels @ 151,022 */ 0, 7, 0xD2, 0x1C, 0xDC, 0xF9, 0x6B, 0x4E, 0xEA,
  /* RLE: 037 Pixels @ 158,022 */ 37, 0xFF,
  /* ABS: 030 Pixels @ 195,022 */ 0, 30, 0xEC, 0x6D, 0x4F, 0xEF, 0xCB, 0x25, 0xD9, 0xFF, 0xFF, 0xFF, 0xF7, 0x59, 0x61, 0xFC, 0xFF, 0xFF, 0xFC, 0xE2, 0x9C, 0x58, 0x3E, 0x3D, 0x3E, 0x40, 0x3E, 0x3A, 0x34, 0x4C, 0xA8, 0xF4,
  /* RLE: 191 Pixels @ 225,022 */ 191, 0xFF,
  /* ABS: 015 Pixels @ 116,023 */ 0, 15, 0xF4, 0x8C, 0x2C, 0x66, 0x2C, 0x85, 0xE6, 0x90, 0x18, 0x0F, 0x24, 0x2E, 0x3E, 0x85, 0xE1,
  /* RLE: 020 Pixels @ 131,023 */ 20, 0xFF,
  /* ABS: 006 Pixels @ 151,023 */ 0, 6, 0x93, 0x4A, 0xF5, 0xCC, 0x26, 0xC9,
  /* RLE: 010 Pixels @ 157,023 */ 10, 0xFF,
  /* RLE: 003 Pixels @ 167,023 */ 3, 0xFD,
  /* RLE: 026 Pixels @ 170,023 */ 26, 0xFF,
  /* ABS: 030 Pixels @ 196,023 */ 0, 30, 0xDA, 0x18, 0xCE, 0xF7, 0x10, 0xC3, 0xFF, 0xFF, 0xFF, 0xB7, 0x26, 0xB2, 0xFF, 0xFF, 0xFF, 0xAA, 0x34, 0x3D, 0x8B, 0xC5, 0xE1, 0xF2, 0xF9, 0xF8, 0xEC, 0xC9, 0x7F, 0x24, 0x75, 0xEF,
  /* RLE: 189 Pixels @ 226,023 */ 189, 0xFF,
  /* ABS: 015 Pixels @ 115,024 */ 0, 15, 0xE8, 0x52, 0x3D, 0x76, 0x2D, 0x9A, 0xCE, 0x4D, 0x26, 0x15, 0x4D, 0xC6, 0xEF, 0xFA, 0xFE,
  /* RLE: 015 Pixels @ 130,024 */ 15, 0xFF,
  /* ABS: 032 Pixels @ 145,024 */ 0, 32, 0xFB, 0xDB, 0xB1, 0x7E, 0x69, 0x4F, 0x20, 0x85, 0xFC, 0x7D, 0x1C, 0x56, 0x73, 0x7F, 0x99, 0xB1, 0xC5, 0xDC, 0xD6, 0xAA, 0x63, 0x3C, 0x3A, 0x3F, 0x35, 0x50, 0x73, 0x70, 0x80, 0xA6, 0xC9, 0xF5,
  /* RLE: 019 Pixels @ 177,024 */ 19, 0xFF,
  /* ABS: 019 Pixels @ 196,024 */ 0, 19, 0xED, 0x21, 0xBD, 0xEC, 0x1E, 0xD2, 0xFF, 0xFF, 0xF7, 0x4B, 0x14, 0xBC, 0xFF, 0xF9, 0x8E, 0x30, 0xA5, 0xF9, 0xFE,
  /* RLE: 007 Pixels @ 215,024 */ 7, 0xFF,
  /* ABS: 007 Pixels @ 222,024 */ 0, 7, 0xFE, 0xD4, 0x33, 0x5E, 0x77, 0xA1, 0xE6,
  /* RLE: 184 Pixels @ 229,024 */ 184, 0xFF,
  /* ABS: 013 Pixels @ 113,025 */ 0, 13, 0xFD, 0xCE, 0x51, 0x54, 0x75, 0x3B, 0xAE, 0xB4, 0x36, 0x47, 0x2A, 0x86, 0xE7,
  /* RLE: 017 Pixels @ 126,025 */ 17, 0xFF,
  /* ABS: 036 Pixels @ 143,025 */ 0, 36, 0xFE, 0xE8, 0x7A, 0x3E, 0x3F, 0x73, 0x93, 0xAA, 0xB7, 0xE7, 0xFF, 0xDD, 0xA5, 0x95, 0x86, 0x76, 0x68, 0x47, 0x32, 0x38, 0x28, 0x22, 0x7F, 0xBB, 0xCF, 0xD6, 0xBF, 0x96, 0x40, 0x0F, 0x17, 0x42, 0x37, 0x4D, 0x9D,
        0xE8,
  /* RLE: 017 Pixels @ 179,025 */ 17, 0xFF,
  /* ABS: 017 Pixels @ 196,025 */ 0, 17, 0xE1, 0x1E, 0xD5, 0xBA, 0x35, 0xE4, 0xFF, 0xFF, 0xB9, 0x08, 0x02, 0x80, 0xFD, 0xB8, 0x23, 0xB5, 0xFC,
  /* RLE: 011 Pixels @ 213,025 */ 11, 0xFF,
  /* ABS: 007 Pixels @ 224,025 */ 0, 7, 0xA2, 0x17, 0x68, 0x33, 0x3E, 0xA3, 0xEC,
  /* RLE: 181 Pixels @ 231,025 */ 181, 0xFF,
  /* ABS: 013 Pixels @ 112,026 */ 0, 13, 0xFE, 0xBE, 0x36, 0x71, 0x68, 0x3D, 0xD0, 0x92, 0x30, 0x7B, 0x35, 0x91, 0xFB,
  /* RLE: 018 Pixels @ 125,026 */ 18, 0xFF,
  /* ABS: 005 Pixels @ 143,026 */ 0, 5, 0xE3, 0x45, 0x5D, 0xC9, 0xF9,
  /* RLE: 012 Pixels @ 148,026 */ 12, 0xFF,
  /* ABS: 007 Pixels @ 160,026 */ 0, 7, 0xFD, 0xDF, 0xC0, 0x81, 0x34, 0x3D, 0xD5,
  /* RLE: 004 Pixels @ 167,026 */ 4, 0xFF,
  /* ABS: 010 Pixels @ 171,026 */ 0, 10, 0xF5, 0xB1, 0x32, 0x65, 0xCE, 0x9C, 0x40, 0x3B, 0xC3, 0xFC,
  /* RLE: 015 Pixels @ 181,026 */ 15, 0xFF,
  /* ABS: 016 Pixels @ 196,026 */ 0, 16, 0x94, 0x46, 0xEE, 0x81, 0x59, 0xF5, 0xFF, 0xED, 0x49, 0x0C, 0x01, 0x46, 0xDF, 0x3F, 0x8E, 0xFC,
  /* RLE: 012 Pixels @ 212,026 */ 12, 0xFF,
  /* ABS: 009 Pixels @ 224,026 */ 0, 9, 0xBE, 0x26, 0xD4, 0xE9, 0x9B, 0x2E, 0x46, 0xC4, 0xFD,
  /* RLE: 178 Pixels @ 233,026 */ 178, 0xFF,
  /* ABS: 013 Pixels @ 111,027 */ 0, 13, 0xFA, 0xB8, 0x29, 0x7A, 0x63, 0x49, 0xC1, 0x70, 0x46, 0x8C, 0x2E, 0x93, 0xFA,
  /* RLE: 019 Pixels @ 124,027 */ 19, 0xFF,
  /* ABS: 003 Pixels @ 143,027 */ 0, 3, 0x9A, 0x34, 0xEC,
  /* RLE: 017 Pixels @ 146,027 */ 17, 0xFF,
  /* ABS: 005 Pixels @ 163,027 */ 0, 5, 0xFC, 0xE5, 0x66, 0x44, 0xE6,
  /* RLE: 004 Pixels @ 168,027 */ 4, 0xFF,
  /* ABS: 010 Pixels @ 172,027 */ 0, 10, 0xFE, 0xDA, 0x40, 0x5A, 0xF5, 0xEB, 0x99, 0x31, 0x90, 0xF7,
  /* RLE: 013 Pixels @ 182,027 */ 13, 0xFF,
  /* ABS: 016 Pixels @ 195,027 */ 0, 16, 0xE3, 0x3E, 0x9D, 0xE3, 0x38, 0xA7, 0xFF, 0xFF, 0xA3, 0x2A, 0x7F, 0x07, 0x15, 0x79, 0x3E, 0xED,
  /* RLE: 013 Pixels @ 211,027 */ 13, 0xFF,
  /* ABS: 010 Pixels @ 224,027 */ 0, 10, 0xF4, 0x68, 0x49, 0xE4, 0xFD, 0xDF, 0x7B, 0x2C, 0x90, 0xF2,
  /* RLE: 176 Pixels @ 234,027 */ 176, 0xFF,
  /* ABS: 013 Pixels @ 110,028 */ 0, 13, 0xFC, 0xA4, 0x27, 0x8B, 0x56, 0x41, 0xC7, 0x6E, 0x42, 0x8B, 0x27, 0x74, 0xF6,
  /* RLE: 020 Pixels @ 123,028 */ 20, 0xFF,
  /* ABS: 003 Pixels @ 143,028 */ 0, 3, 0x8B, 0x3D, 0xF2,
  /* RLE: 019 Pixels @ 146,028 */ 19, 0xFF,
  /* ABS: 003 Pixels @ 165,028 */ 0, 3, 0xD8, 0x22, 0xCB,
  /* RLE: 006 Pixels @ 168,028 */ 6, 0xFF,
  /* ABS: 009 Pixels @ 174,028 */ 0, 9, 0xC7, 0x2C, 0xAE, 0xFE, 0xFF, 0xAE, 0x2D, 0x96, 0xFA,
  /* RLE: 012 Pixels @ 183,028 */ 12, 0xFF,
  /* ABS: 015 Pixels @ 195,028 */ 0, 15, 0x92, 0x35, 0xEE, 0xB0, 0x1D, 0xEF, 0xFF, 0xF0, 0x3A, 0x87, 0xC0, 0x14, 0x02, 0x0E, 0x97,
  /* RLE: 015 Pixels @ 210,028 */ 15, 0xFF,
  /* ABS: 010 Pixels @ 225,028 */ 0, 10, 0xDE, 0x39, 0x6C, 0xF1, 0xFF, 0xFA, 0xB2, 0x29, 0x74, 0xF5,
  /* RLE: 174 Pixels @ 235,028 */ 174, 0xFF,
  /* ABS: 013 Pixels @ 109,029 */ 0, 13, 0xF9, 0x8E, 0x27, 0x9D, 0x4B, 0x52, 0xD0, 0x48, 0x46, 0x6E, 0x0E, 0x0D, 0xDC,
  /* RLE: 021 Pixels @ 122,029 */ 21, 0xFF,
  /* ABS: 005 Pixels @ 143,029 */ 0, 5, 0xD6, 0x31, 0x5D, 0xC5, 0xF8,
  /* RLE: 015 Pixels @ 148,029 */ 15, 0xFF,
  /* ABS: 005 Pixels @ 163,029 */ 0, 5, 0xF9, 0xD0, 0x6C, 0x3F, 0xE2,
  /* RLE: 006 Pixels @ 168,029 */ 6, 0xFF,
  /* ABS: 009 Pixels @ 174,029 */ 0, 9, 0xFE, 0x83, 0x32, 0xCE, 0xFF, 0xFF, 0xBB, 0x22, 0xB0,
  /* RLE: 011 Pixels @ 183,029 */ 11, 0xFF,
  /* ABS: 016 Pixels @ 194,029 */ 0, 16, 0xED, 0x31, 0xA2, 0xF7, 0x49, 0x74, 0xFF, 0xFD, 0x95, 0x36, 0xDF, 0xF2, 0x30, 0x00, 0x33, 0xE2,
  /* RLE: 016 Pixels @ 210,029 */ 16, 0xFF,
  /* ABS: 010 Pixels @ 226,029 */ 0, 10, 0xD7, 0x39, 0x6B, 0xFB, 0xFF, 0xFF, 0xCA, 0x37, 0x77, 0xF5,
  /* RLE: 172 Pixels @ 236,029 */ 172, 0xFF,
  /* ABS: 014 Pixels @ 108,030 */ 0, 14, 0xF4, 0x8F, 0x2F, 0x9A, 0x57, 0x5E, 0xC1, 0x53, 0x3E, 0x52, 0x43, 0x35, 0x5C, 0xFE,
  /* RLE: 021 Pixels @ 122,030 */ 21, 0xFF,
  /* ABS: 025 Pixels @ 143,030 */ 0, 25, 0xFD, 0xD4, 0x60, 0x38, 0x46, 0x68, 0x90, 0xAB, 0xC1, 0xC6, 0xC8, 0xEB, 0xD7, 0xAB, 0xB0, 0xBE, 0xB0, 0x98, 0x7D, 0x6A, 0x4A, 0x3F, 0x6A, 0xD4, 0xFD,
  /* RLE: 007 Pixels @ 168,030 */ 7, 0xFF,
  /* ABS: 009 Pixels @ 175,030 */ 0, 9, 0xDF, 0x18, 0x2F, 0xC0, 0xFF, 0xFB, 0x8F, 0x3D, 0xDA,
  /* RLE: 009 Pixels @ 184,030 */ 9, 0xFF,
  /* ABS: 017 Pixels @ 193,030 */ 0, 17, 0xFC, 0x95, 0x48, 0xEA, 0xB9, 0x32, 0xCE, 0xFF, 0xE6, 0x36, 0x99, 0xFD, 0xFE, 0x59, 0x00, 0x40, 0xEB,
  /* RLE: 016 Pixels @ 210,030 */ 16, 0xFF,
  /* ABS: 010 Pixels @ 226,030 */ 0, 10, 0xFE, 0xB4, 0x11, 0x94, 0xFA, 0xFF, 0xFD, 0xC5, 0x1D, 0xA1,
  /* RLE: 171 Pixels @ 236,030 */ 171, 0xFF,
  /* ABS: 014 Pixels @ 107,031 */ 0, 14, 0xFB, 0x7D, 0x2C, 0xAF, 0x4E, 0x4C, 0xD8, 0x54, 0x1E, 0x2D, 0x56, 0xBB, 0x2F, 0xBC,
  /* RLE: 024 Pixels @ 121,031 */ 24, 0xFF,
  /* ABS: 021 Pixels @ 145,031 */ 0, 21, 0xF9, 0xD9, 0x9F, 0x74, 0x61, 0x48, 0x39, 0x2C, 0x14, 0x5E, 0x4C, 0x21, 0x3D, 0x09, 0x46, 0x60, 0x6E, 0x89, 0xAF, 0xDA, 0xFC,
  /* RLE: 009 Pixels @ 166,031 */ 9, 0xFF,
  /* ABS: 009 Pixels @ 175,031 */ 0, 9, 0xF7, 0x4E, 0x08, 0x27, 0xE7, 0xFF, 0xF4, 0x49, 0x77,
  /* RLE: 009 Pixels @ 184,031 */ 9, 0xFF,
  /* ABS: 017 Pixels @ 193,031 */ 0, 17, 0xE5, 0x30, 0xA4, 0xF7, 0x5D, 0x64, 0xFA, 0xFF, 0x99, 0x2E, 0xEA, 0xFF, 0xFF, 0x83, 0x00, 0x31, 0xE0,
  /* RLE: 015 Pixels @ 210,031 */ 15, 0xFF,
  /* ABS: 012 Pixels @ 225,031 */ 0, 12, 0xFD, 0xE9, 0xD6, 0x2F, 0x1C, 0xB1, 0xFF, 0xFF, 0xFD, 0x87, 0x40, 0xE9,
  /* RLE: 169 Pixels @ 237,031 */ 169, 0xFF,
  /* ABS: 015 Pixels @ 106,032 */ 0, 15, 0xF3, 0x7A, 0x33, 0xB1, 0x4D, 0x56, 0xD3, 0x4A, 0x09, 0x0B, 0x72, 0xEB, 0x70, 0x5D, 0xF7,
  /* RLE: 027 Pixels @ 121,032 */ 27, 0xFF,
  /* ABS: 015 Pixels @ 148,032 */ 0, 15, 0xFD, 0xFC, 0xFB, 0xFA, 0xF9, 0xA5, 0x49, 0x46, 0xAA, 0xA7, 0x33, 0xDD, 0xFC, 0xFD, 0xFE,
  /* RLE: 012 Pixels @ 163,032 */ 12, 0xFF,
  /* ABS: 010 Pixels @ 175,032 */ 0, 10, 0xFE, 0x9D, 0x23, 0x1F, 0xBE, 0xFF, 0xFF, 0xBC, 0x28, 0xE1,
  /* RLE: 008 Pixels @ 185,032 */ 8, 0xFF,
  /* ABS: 017 Pixels @ 193,032 */ 0, 17, 0x92, 0x3C, 0xF1, 0xC4, 0x18, 0xCC, 0xFF, 0xE3, 0x39, 0x98, 0xFD, 0xFF, 0xFF, 0xC5, 0x0A, 0x0F, 0xC0,
  /* RLE: 015 Pixels @ 210,032 */ 15, 0xFF,
  /* ABS: 013 Pixels @ 225,032 */ 0, 13, 0xF5, 0x5E, 0xBF, 0x66, 0x74, 0x32, 0xDD, 0xFF, 0xFF, 0xEC, 0x38, 0x98, 0xFE,
  /* RLE: 167 Pixels @ 238,032 */ 167, 0xFF,
  /* ABS: 015 Pixels @ 105,033 */ 0, 15, 0xF2, 0x78, 0x2F, 0xB5, 0x61, 0x48, 0xC9, 0x65, 0x01, 0x02, 0x14, 0xDE, 0xE2, 0x25, 0xBA,
  /* RLE: 033 Pixels @ 120,033 */ 33, 0xFF,
  /* ABS: 007 Pixels @ 153,033 */ 0, 7, 0xFB, 0xF0, 0xEF, 0xE7, 0x4B, 0x7C, 0xFA,
  /* RLE: 016 Pixels @ 160,033 */ 16, 0xFF,
  /* ABS: 010 Pixels @ 176,033 */ 0, 10, 0xCA, 0x2B, 0x36, 0x72, 0xF8, 0xFF, 0xF2, 0x58, 0x84, 0xFC,
  /* RLE: 006 Pixels @ 186,033 */ 6, 0xFF,
  /* ABS: 018 Pixels @ 192,033 */ 0, 18, 0xE9, 0x40, 0x9A, 0xF7, 0x68, 0x54, 0xF2, 0xFF, 0x91, 0x36, 0xE2, 0xFF, 0xFF, 0xFF, 0xDB, 0x23, 0x01, 0x98,
  /* RLE: 015 Pixels @ 210,033 */ 15, 0xFF,
  /* ABS: 013 Pixels @ 225,033 */ 0, 13, 0xF6, 0x4A, 0x70, 0x97, 0x95, 0x3F, 0x7B, 0xFB, 0xFF, 0xFF, 0x7A, 0x54, 0xFA,
  /* RLE: 166 Pixels @ 238,033 */ 166, 0xFF,
  /* ABS: 016 Pixels @ 104,034 */ 0, 16, 0xF5, 0x68, 0x39, 0xC4, 0x5C, 0x41, 0xDA, 0x6C, 0x04, 0x1B, 0x18, 0x5E, 0xFA, 0x8F, 0x41, 0xEF,
  /* RLE: 036 Pixels @ 120,034 */ 36, 0xFF,
  /* ABS: 003 Pixels @ 156,034 */ 0, 3, 0xA9, 0x21, 0xE8,
  /* RLE: 017 Pixels @ 159,034 */ 17, 0xFF,
  /* ABS: 026 Pixels @ 176,034 */ 0, 26, 0xF2, 0x3C, 0x7D, 0x23, 0x9C, 0xF2, 0xF9, 0xA0, 0x40, 0xE5, 0xF7, 0xF4, 0xE0, 0xDB, 0xD4, 0xC0, 0x83, 0x3D, 0xEB, 0xCD, 0x29, 0xBE, 0xFF, 0xF7, 0x28, 0x91,
  /* RLE: 004 Pixels @ 202,034 */ 4, 0xFF,
  /* ABS: 004 Pixels @ 206,034 */ 0, 4, 0xED, 0x46, 0x00, 0x6C,
  /* RLE: 015 Pixels @ 210,034 */ 15, 0xFF,
  /* ABS: 013 Pixels @ 225,034 */ 0, 13, 0xF9, 0x70, 0x49, 0xB9, 0x5E, 0x95, 0x24, 0xE9, 0xFF, 0xFF, 0xB8, 0x26, 0xF7,
  /* RLE: 165 Pixels @ 238,034 */ 165, 0xFF,
  /* ABS: 017 Pixels @ 103,035 */ 0, 17, 0xEF, 0x76, 0x32, 0xBC, 0x74, 0x3A, 0xC8, 0x83, 0x0C, 0x28, 0xA4, 0x31, 0xB6, 0xDE, 0x38, 0x9D, 0xFE,
  /* RLE: 035 Pixels @ 120,035 */ 35, 0xFF,
  /* ABS: 004 Pixels @ 155,035 */ 0, 4, 0xE7, 0x3F, 0x87, 0xFE,
  /* RLE: 018 Pixels @ 159,035 */ 18, 0xFF,
  /* ABS: 025 Pixels @ 177,035 */ 0, 25, 0x61, 0x74, 0x9F, 0x2F, 0x21, 0x36, 0x32, 0x19, 0x2F, 0x34, 0x39, 0x38, 0x36, 0x3D, 0x37, 0x0C, 0x8E, 0xFE, 0x7F, 0x3D, 0xF6, 0xFE, 0xAB, 0x29, 0xD9,
  /* RLE: 004 Pixels @ 202,035 */ 4, 0xFF,
  /* ABS: 005 Pixels @ 206,035 */ 0, 5, 0xFC, 0x74, 0x01, 0x42, 0xFC,
  /* RLE: 014 Pixels @ 211,035 */ 14, 0xFF,
  /* ABS: 013 Pixels @ 225,035 */ 0, 13, 0xF5, 0x86, 0x8C, 0x83, 0x8C, 0x7D, 0x20, 0xC3, 0xFF, 0xFF, 0xD4, 0x21, 0xEB,
  /* RLE: 164 Pixels @ 238,035 */ 164, 0xFF,
  /* ABS: 017 Pixels @ 102,036 */ 0, 17, 0xF7, 0x71, 0x2D, 0xC4, 0x89, 0x28, 0xD0, 0xA5, 0x10, 0x41, 0xC5, 0x87, 0x46, 0xF5, 0x9E, 0x2F, 0xEC,
  /* RLE: 035 Pixels @ 119,036 */ 35, 0xFF,
  /* ABS: 004 Pixels @ 154,036 */ 0, 4, 0xFC, 0x87, 0x3B, 0xE7,
  /* RLE: 019 Pixels @ 158,036 */ 19, 0xFF,
  /* ABS: 025 Pixels @ 177,036 */ 0, 25, 0x98, 0x3C, 0xF9, 0xC2, 0x26, 0x59, 0x97, 0x94, 0x97, 0xB2, 0xC2, 0xC8, 0xCA, 0xD5, 0xA1, 0x27, 0xDA, 0xEF, 0x2C, 0x94, 0xFF, 0xEC, 0x4B, 0x7F, 0xFB,
  /* RLE: 005 Pixels @ 202,036 */ 5, 0xFF,
  /* ABS: 004 Pixels @ 207,036 */ 0, 4, 0xA4, 0x03, 0x1E, 0xE7,
  /* RLE: 013 Pixels @ 211,036 */ 13, 0xFF,
  /* ABS: 014 Pixels @ 224,036 */ 0, 14, 0xE4, 0x93, 0x9D, 0x93, 0x5B, 0xD2, 0x56, 0x25, 0xAD, 0xFF, 0xFF, 0xDA, 0x1E, 0xDD,
  /* RLE: 163 Pixels @ 238,036 */ 163, 0xFF,
  /* ABS: 017 Pixels @ 101,037 */ 0, 17, 0xEC, 0x61, 0x40, 0xCE, 0x87, 0x32, 0xC9, 0xA8, 0x17, 0x56, 0xE9, 0xF0, 0x2D, 0xA3, 0xF6, 0x39, 0x87,
  /* RLE: 013 Pixels @ 118,037 */ 13, 0xFF,
  /* ABS: 002 Pixels @ 131,037 */ 0, 2, 0xFB, 0xFA,
  /* RLE: 021 Pixels @ 133,037 */ 21, 0xFF,
  /* ABS: 003 Pixels @ 154,037 */ 0, 3, 0xCB, 0x21, 0xB9,
  /* RLE: 020 Pixels @ 157,037 */ 20, 0xFF,
  /* ABS: 024 Pixels @ 177,037 */ 0, 24, 0xD6, 0x20, 0xD8, 0xFF, 0xBD, 0x10, 0x18, 0x0D, 0x30, 0x34, 0x2A, 0x27, 0x38, 0x32, 0x14, 0x78, 0xFA, 0x9F, 0x39, 0xE3, 0xFF, 0xAE, 0x1D, 0xE8,
  /* RLE: 006 Pixels @ 201,037 */ 6, 0xFF,
  /* ABS: 004 Pixels @ 207,037 */ 0, 4, 0xD3, 0x06, 0x12, 0xC7,
  /* RLE: 012 Pixels @ 211,037 */ 12, 0xFF,
  /* ABS: 015 Pixels @ 223,037 */ 0, 15, 0xD3, 0x6F, 0xD3, 0xE3, 0x71, 0xA9, 0x91, 0xA4, 0x00, 0x97, 0xFF, 0xFF, 0xDA, 0x1F, 0xD8,
  /* RLE: 162 Pixels @ 238,037 */ 162, 0xFF,
  /* ABS: 018 Pixels @ 100,038 */ 0, 18, 0xE9, 0x66, 0x44, 0xD5, 0x9F, 0x28, 0xB4, 0xCD, 0x28, 0x68, 0xEC, 0xFE, 0xAB, 0x35, 0xE2, 0xB2, 0x36, 0xDA,
  /* RLE: 004 Pixels @ 118,038 */ 4, 0xFF,
  /* ABS: 017 Pixels @ 122,038 */ 0, 17, 0xF7, 0xEB, 0xDA, 0xC1, 0xAD, 0xAD, 0xAE, 0x95, 0x64, 0x47, 0x46, 0x5E, 0x6E, 0x95, 0xC2, 0xE8, 0xFA,
  /* RLE: 014 Pixels @ 139,038 */ 14, 0xFF,
  /* ABS: 004 Pixels @ 153,038 */ 0, 4, 0xE4, 0x49, 0x78, 0xF8,
  /* RLE: 020 Pixels @ 157,038 */ 20, 0xFF,
  /* ABS: 023 Pixels @ 177,038 */ 0, 23, 0xEF, 0x4B, 0x9E, 0xFF, 0xF9, 0x3F, 0x46, 0x41, 0xD7, 0xE6, 0xE1, 0xDF, 0xDC, 0xA1, 0x1B, 0xDA, 0xEE, 0x49, 0x8B, 0xFD, 0xFA, 0x50, 0x70,
  /* RLE: 007 Pixels @ 200,038 */ 7, 0xFF,
  /* ABS: 005 Pixels @ 207,038 */ 0, 5, 0xF8, 0x1F, 0x06, 0x92, 0xFE,
  /* RLE: 010 Pixels @ 212,038 */ 10, 0xFF,
  /* ABS: 016 Pixels @ 222,038 */ 0, 16, 0xE1, 0x6F, 0xDC, 0xFF, 0xFD, 0x80, 0xB9, 0x63, 0xCB, 0x17, 0x97, 0xFF, 0xFF, 0xD1, 0x19, 0xEC,
  /* RLE: 161 Pixels @ 238,038 */ 161, 0xFF,
  /* ABS: 042 Pixels @ 099,039 */ 0, 42, 0xF2, 0x54, 0x43, 0xDC, 0xB3, 0x21, 0xA8, 0xD6, 0x3B, 0x6D, 0xF1, 0xFF, 0xEF, 0x4D, 0x8E, 0xEF, 0x52, 0x84, 0xFE, 0xFF, 0xFE, 0xE6, 0xA0, 0x60, 0x3F, 0x38, 0x3A, 0x48, 0x4E, 0x4B, 0x36, 0x16, 0x01, 0x3D, 0x8E,
        0x8B, 0x5C, 0x2E, 0x3A, 0x7A, 0xE0, 0xFE,
  /* RLE: 012 Pixels @ 141,039 */ 12, 0xFF,
  /* ABS: 003 Pixels @ 153,039 */ 0, 3, 0x79, 0x3D, 0xED,
  /* RLE: 021 Pixels @ 156,039 */ 21, 0xFF,
  /* ABS: 009 Pixels @ 177,039 */ 0, 9, 0xFE, 0x7D, 0x61, 0xFB, 0xFF, 0x54, 0x19, 0x55, 0xF4,
  /* RLE: 004 Pixels @ 186,039 */ 4, 0xFF,
  /* ABS: 010 Pixels @ 190,039 */ 0, 10, 0x70, 0x57, 0xFF, 0xC5, 0x1F, 0xE1, 0xFF, 0xC3, 0x2D, 0xC4,
  /* RLE: 008 Pixels @ 200,039 */ 8, 0xFF,
  /* ABS: 004 Pixels @ 208,039 */ 0, 4, 0x4A, 0x01, 0x70, 0xFB,
  /* RLE: 009 Pixels @ 212,039 */ 9, 0xFF,
  /* ABS: 017 Pixels @ 221,039 */ 0, 17, 0xFC, 0x80, 0xAF, 0xFE, 0xFF, 0xFF, 0xC2, 0x7F, 0x6F, 0xB1, 0x4F, 0x6E, 0xFE, 0xFF, 0xC8, 0x18, 0xF0,
  /* RLE: 160 Pixels @ 238,039 */ 160, 0xFF,
  /* ABS: 044 Pixels @ 098,040 */ 0, 44, 0xDD, 0x4D, 0x5B, 0xE2, 0xBC, 0x29, 0x96, 0xE5, 0x48, 0x56, 0xF8, 0xFF, 0xFF, 0xAE, 0x22, 0xEA, 0xB5, 0x1D, 0xE2, 0xEB, 0xAB, 0x58, 0x33, 0x5E, 0x93, 0xD6, 0xF4, 0xF9, 0xFA, 0xFA, 0xFA, 0xF9, 0xEC, 0xB2, 0x59,
        0x2A, 0x95, 0xEA, 0xF6, 0xBD, 0x68, 0x2A, 0x79, 0xDF,
  /* RLE: 009 Pixels @ 142,040 */ 9, 0xFF,
  /* ABS: 004 Pixels @ 151,040 */ 0, 4, 0xFC, 0xA6, 0x2E, 0xC7,
  /* RLE: 023 Pixels @ 155,040 */ 23, 0xFF,
  /* ABS: 022 Pixels @ 178,040 */ 0, 22, 0x9D, 0x42, 0xEB, 0xFE, 0x45, 0x0C, 0x6B, 0xF9, 0xFC, 0xFC, 0xFC, 0xD9, 0x2F, 0xBE, 0xFB, 0x65, 0x6D, 0xFB, 0xF9, 0x64, 0x67, 0xFA,
  /* RLE: 008 Pixels @ 200,040 */ 8, 0xFF,
  /* ABS: 004 Pixels @ 208,040 */ 0, 4, 0x8E, 0x02, 0x48, 0xF3,
  /* RLE: 009 Pixels @ 212,040 */ 9, 0xFF,
  /* ABS: 042 Pixels @ 221,040 */ 0, 42, 0xD1, 0x6F, 0xFC, 0xFF, 0xFF, 0xFF, 0xF2, 0x66, 0xBA, 0x62, 0x63, 0x4F, 0xF7, 0xFF, 0xE4, 0x42, 0x34, 0x58, 0x6A, 0x6D, 0x77, 0x7D, 0x87, 0x86, 0x80, 0x7D, 0x7E, 0x71, 0x72, 0x84, 0x87, 0x8D, 0x98, 0xA1, 0xB9,
        0xC1, 0xD2, 0xDD, 0xE4, 0xEF, 0xF8, 0xFE,
  /* RLE: 133 Pixels @ 263,040 */ 133, 0xFF,
  /* ABS: 026 Pixels @ 096,041 */ 0, 26, 0xFE, 0xDE, 0x4F, 0x4B, 0xEB, 0xCF, 0x30, 0x8B, 0xEB, 0x64, 0x0C, 0x34, 0x76, 0xC5, 0xF8, 0x57, 0x6A, 0xF6, 0x58, 0x6B, 0xA7, 0x4C, 0x3D, 0x93, 0xD4, 0xF7,
  /* RLE: 010 Pixels @ 122,041 */ 10, 0xFF,
  /* ABS: 012 Pixels @ 132,041 */ 0, 12, 0xF1, 0xB3, 0x39, 0x4E, 0x88, 0xBF, 0xE1, 0xC0, 0x4F, 0x3B, 0xCA, 0xFB,
  /* RLE: 007 Pixels @ 144,041 */ 7, 0xFF,
  /* ABS: 004 Pixels @ 151,041 */ 0, 4, 0xD4, 0x2F, 0x9F, 0xFB,
  /* RLE: 023 Pixels @ 155,041 */ 23, 0xFF,
  /* ABS: 021 Pixels @ 178,041 */ 0, 21, 0xC2, 0x31, 0xE0, 0xF1, 0x30, 0x26, 0x31, 0x5F, 0x57, 0x58, 0x5A, 0x3B, 0x4F, 0xEF, 0xD2, 0x38, 0xC1, 0xFF, 0xE0, 0x1E, 0xBB,
  /* RLE: 009 Pixels @ 199,041 */ 9, 0xFF,
  /* ABS: 015 Pixels @ 208,041 */ 0, 15, 0xB1, 0x0C, 0x25, 0xE6, 0xF0, 0xD3, 0xAD, 0x92, 0x75, 0x73, 0x95, 0xC2, 0xEA, 0xEB, 0xDE,
  /* RLE: 004 Pixels @ 223,041 */ 4, 0xFF,
  /* ABS: 043 Pixels @ 227,041 */ 0, 43, 0xFE, 0xB7, 0x81, 0xA6, 0x46, 0x2C, 0xD2, 0xFF, 0xEF, 0x62, 0x09, 0x09, 0x08, 0x05, 0x13, 0x54, 0x6B, 0x58, 0x0A, 0x0E, 0x21, 0x0D, 0x22, 0x73, 0x6B, 0x5D, 0x53, 0x52, 0x48, 0x41, 0x3C, 0x3F, 0x40, 0x46, 0x4D,
        0x69, 0x8E, 0xA5, 0xC1, 0xDE, 0xED, 0xF4, 0xFB,
  /* RLE: 126 Pixels @ 270,041 */ 126, 0xFF,
  /* ABS: 023 Pixels @ 096,042 */ 0, 23, 0xD9, 0x39, 0x5D, 0xE8, 0xDA, 0x43, 0x76, 0xF3, 0x89, 0x22, 0x87, 0xA5, 0x64, 0x24, 0x75, 0x29, 0xC8, 0xBD, 0x18, 0x2A, 0x36, 0x9E, 0xF3,
  /* RLE: 015 Pixels @ 119,042 */ 15, 0xFF,
  /* ABS: 010 Pixels @ 134,042 */ 0, 10, 0xDF, 0x46, 0x01, 0x24, 0x34, 0x89, 0xDB, 0x8A, 0x24, 0xA3,
  /* RLE: 006 Pixels @ 144,042 */ 6, 0xFF,
  /* ABS: 004 Pixels @ 150,042 */ 0, 4, 0xEC, 0x52, 0x6C, 0xF8,
  /* RLE: 024 Pixels @ 154,042 */ 24, 0xFF,
  /* ABS: 021 Pixels @ 178,042 */ 0, 21, 0xF1, 0x21, 0xCF, 0xCF, 0x35, 0x3C, 0x54, 0x9E, 0xA7, 0xAA, 0x99, 0x15, 0xB2, 0xFE, 0x87, 0x50, 0xF8, 0xFF, 0x86, 0x41, 0xEE,
  /* RLE: 009 Pixels @ 199,042 */ 9, 0xFF,
  /* ABS: 015 Pixels @ 208,042 */ 0, 15, 0xCE, 0x1E, 0x04, 0x5D, 0x3F, 0x2B, 0x4A, 0x6D, 0x78, 0x7C, 0x58, 0x28, 0x35, 0x9E, 0xEF,
  /* RLE: 005 Pixels @ 223,042 */ 5, 0xFF,
  /* ABS: 045 Pixels @ 228,042 */ 0, 45, 0xFD, 0x62, 0xAC, 0x20, 0x06, 0x80, 0xFF, 0xEC, 0x43, 0x5B, 0xA7, 0xA2, 0x64, 0x0A, 0x2A, 0x67, 0x3A, 0x60, 0xB9, 0xF0, 0xA4, 0x22, 0x61, 0x88, 0xAA, 0xC0, 0xCC, 0xE0, 0xF1, 0xF2, 0xDB, 0xC9, 0xBB, 0xA8, 0x94,
        0x75, 0x5E, 0x3F, 0x2B, 0x35, 0x50, 0x72, 0xA0, 0xD4, 0xF5,
  /* RLE: 122 Pixels @ 273,042 */ 122, 0xFF,
  /* ABS: 023 Pixels @ 095,043 */ 0, 23, 0xC8, 0x3B, 0x69, 0xEB, 0xED, 0x43, 0x5E, 0xEF, 0xA1, 0x28, 0xBA, 0xFC, 0xFF, 0xF7, 0x8D, 0x07, 0x5F, 0xEC, 0x55, 0x1C, 0x7A, 0xE9, 0xFD,
  /* RLE: 017 Pixels @ 118,043 */ 17, 0xFF,
  /* ABS: 018 Pixels @ 135,043 */ 0, 18, 0xDE, 0x46, 0x62, 0xB1, 0x4A, 0x3E, 0xBD, 0x9B, 0x30, 0xA1, 0xFD, 0xFF, 0xFF, 0xFF, 0xF9, 0x6B, 0x47, 0xE8,
  /* RLE: 025 Pixels @ 153,043 */ 25, 0xFF,
  /* ABS: 021 Pixels @ 178,043 */ 0, 21, 0xFD, 0x29, 0xB3, 0xBD, 0x2F, 0x34, 0xA7, 0xFF, 0xFF, 0xFF, 0xA4, 0x46, 0xEE, 0xF5, 0x30, 0xAB, 0xFF, 0xE8, 0x41, 0x94, 0xFD,
  /* RLE: 009 Pixels @ 199,043 */ 9, 0xFF,
  /* ABS: 017 Pixels @ 208,043 */ 0, 17, 0xEF, 0x3E, 0x00, 0x3D, 0xB2, 0xE8, 0xF2, 0xFB, 0xFD, 0xFD, 0xF6, 0xE3, 0x9C, 0x36, 0x4D, 0xD4, 0xFE,
  /* RLE: 004 Pixels @ 225,043 */ 4, 0xFF,
  /* ABS: 047 Pixels @ 229,043 */ 0, 47, 0x97, 0x9E, 0x7D, 0x0A, 0x26, 0xE6, 0xF3, 0x52, 0x81, 0xD2, 0x6F, 0x34, 0x26, 0x00, 0x30, 0xC5, 0xF6, 0xFF, 0xFF, 0xEE, 0x46, 0x0F, 0x23, 0x0D, 0x24, 0x1D, 0x18, 0x23, 0x3C, 0x5B, 0x79, 0x99, 0xBA, 0xD1, 0xE3,
        0xEB, 0xEE, 0xE7, 0xD8, 0xAD, 0x7E, 0x57, 0x3A, 0x3A, 0x75, 0xC7, 0xF1,
  /* RLE: 117 Pixels @ 276,043 */ 117, 0xFF,
  /* ABS: 012 Pixels @ 093,044 */ 0, 12, 0xFE, 0xD4, 0x34, 0x67, 0xEE, 0xF0, 0x69, 0x44, 0xDF, 0xD7, 0x2F, 0x88,
  /* RLE: 004 Pixels @ 105,044 */ 4, 0xFF,
  /* ABS: 009 Pixels @ 109,044 */ 0, 9, 0xC9, 0x0D, 0xAE, 0x7C, 0x2E, 0xB6, 0xF7, 0xFD, 0xFD,
  /* RLE: 005 Pixels @ 118,044 */ 5, 0xFC,
  /* RLE: 005 Pixels @ 123,044 */ 5, 0xFB,
  /* RLE: 003 Pixels @ 128,044 */ 3, 0xFA,
  /* ABS: 021 Pixels @ 131,044 */ 0, 21, 0xFB, 0xFA, 0xFA, 0xFB, 0xFA, 0xD5, 0x26, 0xB4, 0xE4, 0x6A, 0x30, 0xD8, 0x97, 0x23, 0xCA, 0xFD, 0xFE, 0xFD, 0xAA, 0x29, 0xC6,
  /* RLE: 027 Pixels @ 152,044 */ 27, 0xFF,
  /* ABS: 019 Pixels @ 179,044 */ 0, 19, 0x42, 0x99, 0xBB, 0x30, 0x35, 0xA3, 0xFD, 0xFD, 0xF3, 0x54, 0x95, 0xFD, 0xB3, 0x34, 0xE3, 0xFF, 0xB7, 0x22, 0xE0,
  /* RLE: 010 Pixels @ 198,044 */ 10, 0xFF,
  /* ABS: 004 Pixels @ 208,044 */ 0, 4, 0xFE, 0x67, 0x04, 0xAB,
  /* RLE: 009 Pixels @ 212,044 */ 9, 0xFF,
  /* ABS: 004 Pixels @ 221,044 */ 0, 4, 0xDA, 0x53, 0x3C, 0xE6,
  /* RLE: 004 Pixels @ 225,044 */ 4, 0xFF,
  /* ABS: 049 Pixels @ 229,044 */ 0, 49, 0xC6, 0x74, 0x9F, 0x34, 0x34, 0x8B, 0xF0, 0x55, 0x23, 0x30, 0x60, 0xC6, 0xD4, 0x53, 0xA0, 0xFF, 0xFF, 0xFF, 0xFC, 0xAB, 0x22, 0x1A, 0x55, 0x29, 0x88, 0xAB, 0x68, 0x3A, 0x11, 0x04, 0x02, 0x07, 0x24, 0x35, 0x3D,
        0x4F, 0x7D, 0xBA, 0xE0, 0xF8, 0xFD, 0xF9, 0xD8, 0xAF, 0x63, 0x2C, 0x5B, 0xDA, 0xFE,
  /* RLE: 115 Pixels @ 278,044 */ 115, 0xFF,
  /* ABS: 069 Pixels @ 093,045 */ 0, 69, 0xBB, 0x26, 0x82, 0xF4, 0xFA, 0x7E, 0x2D, 0xE2, 0xE5, 0x3A, 0x73, 0xF6, 0xFE, 0xF9, 0xEE, 0xDF, 0x61, 0x3D, 0x71, 0x0D, 0x77, 0x8E, 0x81, 0x76, 0x74, 0x66, 0x62, 0x5F, 0x58, 0x55, 0x4D, 0x48, 0x48, 0x48, 0x47,
        0x41, 0x40, 0x3D, 0x44, 0x3A, 0x3C, 0x48, 0x4B, 0x4D, 0x18, 0x1D, 0x52, 0x48, 0x10, 0x32, 0x61, 0x1D, 0x27, 0x75, 0x86, 0x71, 0x17, 0x5A, 0xAD, 0xB4, 0xC0, 0xC9, 0xD4, 0xDA, 0xDC, 0xEB, 0xF5, 0xFA, 0xFE,
  /* RLE: 017 Pixels @ 162,045 */ 17, 0xFF,
  /* ABS: 018 Pixels @ 179,045 */ 0, 18, 0x5C, 0x87, 0xC0, 0x34, 0x47, 0x50, 0x7B, 0x76, 0x5E, 0x2C, 0xE6, 0xF5, 0x5D, 0x81, 0xFD, 0xFF, 0x5D, 0x60,
  /* RLE: 012 Pixels @ 197,045 */ 12, 0xFF,
  /* ABS: 003 Pixels @ 209,045 */ 0, 3, 0x82, 0x45, 0xF2,
  /* RLE: 010 Pixels @ 212,045 */ 10, 0xFF,
  /* ABS: 017 Pixels @ 222,045 */ 0, 17, 0xE9, 0x40, 0x72, 0xFA, 0xFF, 0xFF, 0xFF, 0xE4, 0x65, 0xA1, 0x4A, 0x8F, 0x37, 0xD1, 0x3D, 0x20, 0xC3,
  /* RLE: 007 Pixels @ 239,045 */ 7, 0xFF,
  /* ABS: 033 Pixels @ 246,045 */ 0, 33, 0xDA, 0x5C, 0x3A, 0xA8, 0x98, 0x30, 0x38, 0x94, 0xFF, 0xFF, 0xFE, 0xE7, 0xB2, 0x7F, 0x4A, 0x30, 0x48, 0x61, 0x77, 0x71, 0x50, 0x2A, 0x34, 0x76, 0xBB, 0xF0, 0xFF, 0xFF, 0xE1, 0x74, 0x25, 0x9A, 0xFA,
  /* RLE: 112 Pixels @ 279,045 */ 112, 0xFF,
  /* ABS: 106 Pixels @ 091,046 */ 0, 106, 0xFE, 0xB4, 0x38, 0x89, 0xF4, 0xFC, 0x9A, 0x2B, 0xA9, 0xD7, 0x6C, 0x17, 0x7F, 0x7E, 0x5F, 0x42, 0x3C, 0x3C, 0x29, 0x33, 0x3C, 0x49, 0x50, 0x5A, 0x65, 0x73, 0x79, 0x7D, 0x89, 0x9D, 0x9F, 0xA0, 0xAF, 0xBA, 0xC0,
        0xC1, 0xBA, 0xC3, 0xBB, 0xC0, 0xC3, 0xC3, 0x9E, 0x87, 0x87, 0x7F, 0x8D, 0x7B, 0x81, 0x8B, 0x91, 0x7F, 0x75, 0x78, 0x71, 0x66, 0x67, 0x62, 0x56, 0x50, 0x4D, 0x43, 0x42, 0x3D, 0x3D, 0x3B, 0x38, 0x3B, 0x3E, 0x44, 0x58, 0x68, 0x78, 0x8B, 0x96, 0xAB,
        0xB8, 0xC7, 0xD7, 0xDC, 0xCD, 0xC1, 0xB3, 0xB0, 0xAF, 0xAE, 0xAD, 0x9B, 0x43, 0x42, 0x81, 0x14, 0x18, 0x01, 0x02, 0x0D, 0x07, 0x71, 0xFD, 0xD0, 0x2B, 0xD6, 0xFF, 0xF2, 0x2A, 0xA7,
  /* RLE: 011 Pixels @ 197,046 */ 11, 0xFF,
  /* ABS: 004 Pixels @ 208,046 */ 0, 4, 0xFE, 0x63, 0x6B, 0xFA,
  /* RLE: 010 Pixels @ 212,046 */ 10, 0xFF,
  /* ABS: 018 Pixels @ 222,046 */ 0, 18, 0xFE, 0xA7, 0x31, 0xD7, 0xFF, 0xFF, 0xFF, 0xF8, 0x6C, 0x90, 0x3C, 0xB3, 0x19, 0x6A, 0x25, 0x26, 0x96, 0xFE,
  /* RLE: 004 Pixels @ 240,046 */ 4, 0xFF,
  /* ABS: 010 Pixels @ 244,046 */ 0, 10, 0xF3, 0x96, 0x40, 0x6B, 0xDB, 0xFD, 0x88, 0x09, 0x2F, 0xE0,
  /* RLE: 005 Pixels @ 254,046 */ 5, 0xFF,
  /* ABS: 020 Pixels @ 259,046 */ 0, 20, 0xFD, 0xEE, 0xD7, 0xAE, 0x5A, 0x3D, 0x45, 0x85, 0xB0, 0xAB, 0x6B, 0x40, 0x46, 0x9D, 0xEA, 0xFE, 0xF6, 0xA5, 0x31, 0xB7,
  /* RLE: 112 Pixels @ 279,046 */ 112, 0xFF,
  /* ABS: 023 Pixels @ 091,047 */ 0, 23, 0xF2, 0x2D, 0x89, 0xFA, 0xFE, 0xBF, 0x17, 0x10, 0x34, 0x1E, 0x22, 0x39, 0x52, 0x7C, 0x94, 0xAB, 0xB9, 0xCA, 0xDC, 0xEF, 0xF9, 0xFC, 0xFD,
  /* RLE: 018 Pixels @ 114,047 */ 18, 0xFF,
  /* ABS: 065 Pixels @ 132,047 */ 0, 65, 0xFB, 0x78, 0x34, 0x33, 0x2E, 0x2D, 0x30, 0x3A, 0x35, 0x3A, 0x45, 0x4E, 0x5A, 0x66, 0x66, 0x88, 0x9E, 0xB1, 0xC8, 0xD4, 0xE4, 0xF0, 0xE3, 0xDA, 0xCD, 0xC3, 0xBA, 0xB6, 0xAE, 0x9F, 0x93, 0x83, 0x69, 0x5A, 0x44,
        0x33, 0x28, 0x28, 0x20, 0x0A, 0x04, 0x02, 0x02, 0x02, 0x01, 0x18, 0x39, 0x50, 0x5E, 0x64, 0x66, 0x65, 0x62, 0x5D, 0x47, 0x1A, 0xC2, 0xFF, 0x8D, 0x4D, 0xFF, 0xFF, 0xBB, 0x35, 0xDD,
  /* RLE: 011 Pixels @ 197,047 */ 11, 0xFF,
  /* ABS: 004 Pixels @ 208,047 */ 0, 4, 0xFD, 0x5D, 0x7A, 0xFD,
  /* RLE: 011 Pixels @ 212,047 */ 11, 0xFF,
  /* ABS: 003 Pixels @ 223,047 */ 0, 3, 0xDD, 0x20, 0xC0,
  /* RLE: 004 Pixels @ 226,047 */ 4, 0xFF,
  /* ABS: 024 Pixels @ 230,047 */ 0, 24, 0x75, 0x8A, 0x36, 0xBB, 0x01, 0x29, 0xBA, 0x9B, 0x2C, 0xD6, 0xFF, 0xFF, 0xFF, 0xD0, 0x5C, 0x3D, 0xAD, 0xFA, 0xFB, 0xCE, 0x29, 0x37, 0xC3, 0xFD,
  /* RLE: 009 Pixels @ 254,047 */ 9, 0xFF,
  /* ABS: 016 Pixels @ 263,047 */ 0, 16, 0xFD, 0xDA, 0xA4, 0x50, 0x21, 0x56, 0xAF, 0xDD, 0x9D, 0x3F, 0x41, 0xAC, 0xB3, 0x99, 0x29, 0x92,
  /* RLE: 110 Pixels @ 279,047 */ 110, 0xFF,
  /* ABS: 020 Pixels @ 089,048 */ 0, 20, 0xFA, 0xD0, 0x5B, 0x4D, 0xE9, 0xFF, 0xFB, 0xBE, 0xA6, 0xBE, 0xDB, 0xEB, 0xF3, 0xF8, 0xFA, 0xFD, 0xF7, 0xE0, 0xDF, 0xFE,
  /* RLE: 024 Pixels @ 109,048 */ 24, 0xFF,
  /* ABS: 064 Pixels @ 133,048 */ 0, 64, 0xF9, 0xF7, 0xF7, 0xF6, 0xF2, 0xF1, 0xE7, 0xE9, 0xE1, 0xC2, 0xB3, 0x9F, 0x92, 0x83, 0x6D, 0x59, 0x52, 0x45, 0x35, 0x2C, 0x26, 0x32, 0x46, 0x57, 0x6E, 0x86, 0x9B, 0xAF, 0xC3, 0xCF, 0xDD, 0xE8, 0xF0, 0xF7, 0xF7,
        0xF6, 0xF0, 0xDC, 0xCE, 0xBC, 0xA1, 0x8E, 0x74, 0x5C, 0x48, 0x3E, 0x31, 0x3C, 0x4F, 0x76, 0x9B, 0xB6, 0xD2, 0x81, 0x53, 0xF1, 0xEF, 0x3C, 0x9D, 0xFF, 0xFC, 0x7D, 0x54, 0xF7,
  /* RLE: 011 Pixels @ 197,048 */ 11, 0xFF,
  /* ABS: 004 Pixels @ 208,048 */ 0, 4, 0xFE, 0x68, 0x56, 0xF6,
  /* RLE: 011 Pixels @ 212,048 */ 11, 0xFF,
  /* ABS: 003 Pixels @ 223,048 */ 0, 3, 0xDB, 0x23, 0xC3,
  /* RLE: 004 Pixels @ 226,048 */ 4, 0xFF,
  /* ABS: 023 Pixels @ 230,048 */ 0, 23, 0x83, 0x72, 0x36, 0xD1, 0x3A, 0x64, 0xFE, 0xF2, 0x5D, 0x55, 0xE9, 0xDC, 0x70, 0x36, 0x82, 0xE8, 0xD5, 0x94, 0x49, 0x34, 0x91, 0xE9, 0xFE,
  /* RLE: 012 Pixels @ 253,048 */ 12, 0xFF,
  /* ABS: 014 Pixels @ 265,048 */ 0, 14, 0xFE, 0xF8, 0x66, 0x27, 0x3B, 0x37, 0x97, 0xD3, 0x90, 0x55, 0x51, 0x5E, 0x95, 0xED,
  /* RLE: 106 Pixels @ 279,048 */ 106, 0xFF,
  /* ABS: 009 Pixels @ 085,049 */ 0, 9, 0xFC, 0xF5, 0xE4, 0xB9, 0x6C, 0x3B, 0x5D, 0xDF, 0xFE,
  /* RLE: 006 Pixels @ 094,049 */ 6, 0xFF,
  /* ABS: 009 Pixels @ 100,049 */ 0, 9, 0xFC, 0xF4, 0xE9, 0xC4, 0x9E, 0x85, 0x83, 0xB9, 0xFE,
  /* RLE: 009 Pixels @ 109,049 */ 9, 0xFF,
  /* ABS: 009 Pixels @ 118,049 */ 0, 9, 0xFE, 0xFD, 0xFD, 0xFC, 0xFA, 0xFB, 0xFC, 0xFC, 0xFE,
  /* RLE: 010 Pixels @ 127,049 */ 10, 0xFF,
  /* ABS: 004 Pixels @ 137,049 */ 0, 4, 0xEC, 0xAD, 0x9D, 0xF8,
  /* RLE: 006 Pixels @ 141,049 */ 6, 0xFF,
  /* ABS: 049 Pixels @ 147,049 */ 0, 49, 0xFD, 0xFB, 0xF7, 0xEB, 0xDC, 0xD4, 0xCC, 0xC1, 0xB0, 0xA2, 0x7E, 0x64, 0x56, 0x46, 0x38, 0x36, 0x3C, 0x44, 0x48, 0x64, 0x82, 0x9B, 0xAE, 0xC3, 0xDD, 0xEA, 0xF0, 0xF5, 0xF7, 0xF8, 0xEF, 0xE4, 0xD7, 0xC7, 0xB2,
        0x7F, 0x53, 0x3A, 0x3B, 0x1F, 0xAC, 0xFE, 0xBA, 0x3D, 0xE1, 0xFF, 0xEF, 0x49, 0x9B,
  /* RLE: 013 Pixels @ 196,049 */ 13, 0xFF,
  /* ABS: 003 Pixels @ 209,049 */ 0, 3, 0xA7, 0x21, 0xE1,
  /* RLE: 011 Pixels @ 212,049 */ 11, 0xFF,
  /* ABS: 003 Pixels @ 223,049 */ 0, 3, 0xBD, 0x30, 0xD6,
  /* RLE: 004 Pixels @ 226,049 */ 4, 0xFF,
  /* ABS: 020 Pixels @ 230,049 */ 0, 20, 0x8F, 0x63, 0x36, 0xD8, 0x5D, 0x39, 0x82, 0x96, 0x7B, 0x10, 0x48, 0x2F, 0x49, 0x8F, 0x89, 0x4B, 0x3B, 0x52, 0xA0, 0xDB,
  /* RLE: 017 Pixels @ 250,049 */ 17, 0xFF,
  /* ABS: 010 Pixels @ 267,049 */ 0, 10, 0xC4, 0x30, 0x75, 0x9E, 0x40, 0x42, 0xA5, 0xEC, 0xF6, 0xFB,
  /* RLE: 105 Pixels @ 277,049 */ 105, 0xFF,
  /* ABS: 010 Pixels @ 082,050 */ 0, 10, 0xF0, 0xD7, 0xAF, 0x7C, 0x51, 0x25, 0x33, 0x78, 0xCD, 0xFC,
  /* RLE: 005 Pixels @ 092,050 */ 5, 0xFF,
  /* ABS: 010 Pixels @ 097,050 */ 0, 10, 0xF9, 0xDA, 0xB9, 0x98, 0x83, 0x8C, 0x9E, 0xC5, 0xF5, 0xFE,
  /* RLE: 004 Pixels @ 107,050 */ 4, 0xFF,
  /* ABS: 018 Pixels @ 111,050 */ 0, 18, 0xF8, 0xE0, 0xCA, 0xC4, 0xBC, 0xAD, 0xA7, 0x98, 0x8E, 0x93, 0x91, 0x85, 0x8F, 0x92, 0x94, 0xA5, 0xAC, 0xE5,
  /* RLE: 006 Pixels @ 129,050 */ 6, 0xFF,
  /* ABS: 005 Pixels @ 135,050 */ 0, 5, 0xFB, 0xCB, 0x77, 0xAD, 0xFA,
  /* RLE: 009 Pixels @ 140,050 */ 9, 0xFF,
  /* ABS: 005 Pixels @ 149,050 */ 0, 5, 0xFA, 0xF2, 0xEA, 0xE0, 0xFB,
  /* RLE: 006 Pixels @ 154,050 */ 6, 0xFF,
  /* ABS: 036 Pixels @ 160,050 */ 0, 36, 0xFE, 0xF7, 0xE7, 0xCA, 0xB8, 0xA7, 0x8D, 0x7D, 0x69, 0x4E, 0x38, 0x29, 0x2E, 0x3A, 0x50, 0x61, 0x74, 0x94, 0xB2, 0xC6, 0xDC, 0xEE, 0xFB, 0xFF, 0xFB, 0xDD, 0xB3, 0xF9, 0xF9, 0x6D, 0x71, 0xFC, 0xFF, 0xE1, 0x27,
        0xCE,
  /* RLE: 013 Pixels @ 196,050 */ 13, 0xFF,
  /* ABS: 004 Pixels @ 209,050 */ 0, 4, 0xEC, 0x38, 0x73, 0xF9,
  /* RLE: 009 Pixels @ 213,050 */ 9, 0xFF,
  /* ABS: 004 Pixels @ 222,050 */ 0, 4, 0xF3, 0x57, 0x69, 0xF8,
  /* RLE: 004 Pixels @ 226,050 */ 4, 0xFF,
  /* ABS: 018 Pixels @ 230,050 */ 0, 18, 0x88, 0x70, 0x43, 0xE8, 0xB0, 0x84, 0x75, 0x48, 0x12, 0x01, 0x00, 0x06, 0x30, 0x3F, 0x6D, 0xA7, 0xD9, 0xFE,
  /* RLE: 019 Pixels @ 248,050 */ 19, 0xFF,
  /* ABS: 009 Pixels @ 267,050 */ 0, 9, 0xFE, 0xC8, 0x3E, 0x51, 0xDE, 0xA5, 0x35, 0x5B, 0xD2,
  /* RLE: 097 Pixels @ 276,050 */ 97, 0xFF,
  /* ABS: 031 Pixels @ 073,051 */ 0, 31, 0xFE, 0xF8, 0xEF, 0xE0, 0xCE, 0xBC, 0x9A, 0x7E, 0x57, 0x38, 0x38, 0x45, 0x66, 0x91, 0xD2, 0xEB, 0xFB, 0xFF, 0xFF, 0xFB, 0xEB, 0xD7, 0xB6, 0x93, 0x85, 0x88, 0xA5, 0xE0, 0xED, 0xF8, 0xFE,
  /* RLE: 007 Pixels @ 104,051 */ 7, 0xFF,
  /* ABS: 018 Pixels @ 111,051 */ 0, 18, 0xD2, 0x8D, 0x97, 0xA3, 0xAB, 0xB0, 0xC3, 0xC9, 0xC3, 0xCC, 0xE0, 0xDF, 0xE0, 0xD2, 0xB2, 0x76, 0x64, 0xD8,
  /* RLE: 005 Pixels @ 129,051 */ 5, 0xFF,
  /* ABS: 020 Pixels @ 134,051 */ 0, 20, 0xF4, 0x9D, 0x8F, 0xEB, 0xFD, 0xFF, 0xFF, 0xFF, 0xFE, 0xEA, 0xD0, 0xB4, 0x98, 0x94, 0x91, 0x8A, 0x87, 0x88, 0x9D, 0xF5,
  /* RLE: 012 Pixels @ 154,051 */ 12, 0xFF,
  /* ABS: 030 Pixels @ 166,051 */ 0, 30, 0xFE, 0xFD, 0xFA, 0xF3, 0xED, 0xE7, 0xDD, 0xD4, 0xAC, 0x94, 0x7B, 0x6C, 0x54, 0x45, 0x3F, 0x37, 0x41, 0x58, 0x7B, 0x93, 0xA7, 0xC1, 0xC3, 0x2A, 0xC1, 0xFF, 0xFF, 0xD3, 0x1B, 0xE7,
  /* RLE: 013 Pixels @ 196,051 */ 13, 0xFF,
  /* ABS: 005 Pixels @ 209,051 */ 0, 5, 0xFE, 0xB7, 0x28, 0x9D, 0xFD,
  /* RLE: 007 Pixels @ 214,051 */ 7, 0xFF,
  /* ABS: 004 Pixels @ 221,051 */ 0, 4, 0xF3, 0x86, 0x2E, 0xD1,
  /* RLE: 004 Pixels @ 225,051 */ 4, 0xFF,
  /* ABS: 016 Pixels @ 229,051 */ 0, 16, 0xF9, 0x84, 0x4C, 0x3C, 0xB3, 0x9D, 0x75, 0x47, 0x32, 0x3B, 0x5D, 0x81, 0x57, 0x2D, 0xBA, 0xFA,
  /* RLE: 023 Pixels @ 245,051 */ 23, 0xFF,
  /* ABS: 010 Pixels @ 268,051 */ 0, 10, 0xFE, 0xDE, 0x68, 0x40, 0xC4, 0xE6, 0x72, 0x34, 0xB6, 0xFB,
  /* RLE: 089 Pixels @ 278,051 */ 89, 0xFF,
  /* ABS: 032 Pixels @ 067,052 */ 0, 32, 0xFE, 0xFD, 0xFA, 0xF1, 0xD3, 0xB6, 0x89, 0x58, 0x49, 0x34, 0x2A, 0x33, 0x48, 0x6A, 0x93, 0xB9, 0xD2, 0xF2, 0xFE, 0xFF, 0xFF, 0xFD, 0xFB, 0xE0, 0xB9, 0x87, 0x7C, 0x8E, 0xB5, 0xCA, 0xEF, 0xFE,
  /* RLE: 008 Pixels @ 099,052 */ 8, 0xFF,
  /* ABS: 021 Pixels @ 107,052 */ 0, 21, 0xEE, 0xB0, 0xA4, 0x91, 0x92, 0x7D, 0x86, 0x7E, 0x84, 0x61, 0x44, 0x52, 0x6C, 0xAB, 0xFA, 0xD4, 0x92, 0x7A, 0x9C, 0xC5, 0xF2,
  /* RLE: 006 Pixels @ 128,052 */ 6, 0xFF,
  /* ABS: 018 Pixels @ 134,052 */ 0, 18, 0xCA, 0x5A, 0xB2, 0xD2, 0xE9, 0xF6, 0xFB, 0xFA, 0xC7, 0x7D, 0xAA, 0xC1, 0xCD, 0xDD, 0xEE, 0xF7, 0xFC, 0xFD,
  /* RLE: 026 Pixels @ 152,052 */ 26, 0xFF,
  /* ABS: 019 Pixels @ 178,052 */ 0, 19, 0xFB, 0xEC, 0xDB, 0xC8, 0xB7, 0xA1, 0x82, 0x64, 0x48, 0x3C, 0x2E, 0x43, 0xEC, 0xFF, 0xFF, 0xCA, 0x24, 0xF0, 0xFE,
  /* RLE: 013 Pixels @ 197,052 */ 13, 0xFF,
  /* ABS: 004 Pixels @ 210,052 */ 0, 4, 0xFA, 0x57, 0x1C, 0xD2,
  /* RLE: 004 Pixels @ 214,052 */ 4, 0xFF,
  /* ABS: 027 Pixels @ 218,052 */ 0, 27, 0xFD, 0xDB, 0xB9, 0x5F, 0x20, 0x9B, 0xD7, 0xD1, 0xBC, 0xA7, 0x8A, 0x5C, 0x2D, 0x15, 0x1B, 0x38, 0x59, 0x8B, 0xAD, 0xCC, 0xEA, 0xFD, 0xFF, 0xF0, 0x65, 0x3E, 0xDE,
  /* RLE: 024 Pixels @ 245,052 */ 24, 0xFF,
  /* ABS: 009 Pixels @ 269,052 */ 0, 9, 0xDD, 0xC6, 0x50, 0x37, 0xE1, 0xF6, 0x92, 0x26, 0xB6,
  /* RLE: 085 Pixels @ 278,052 */ 85, 0xFF,
  /* ABS: 016 Pixels @ 063,053 */ 0, 16, 0xFE, 0xF3, 0xD9, 0xB6, 0x8A, 0x61, 0x39, 0x22, 0x2E, 0x45, 0x6F, 0x8F, 0xB4, 0xD9, 0xF3, 0xFE,
  /* RLE: 006 Pixels @ 079,053 */ 6, 0xFF,
  /* ABS: 009 Pixels @ 085,053 */ 0, 9, 0xF1, 0xD4, 0xB0, 0x8B, 0x7B, 0x86, 0xA8, 0xE9, 0xFD,
  /* RLE: 013 Pixels @ 094,053 */ 13, 0xFF,
  /* ABS: 018 Pixels @ 107,053 */ 0, 18, 0xED, 0xB6, 0xC6, 0xD6, 0xED, 0xF3, 0xED, 0xB6, 0x7A, 0x8A, 0xBD, 0xF4, 0xD7, 0xAB, 0x81, 0x96, 0xD0, 0xFD,
  /* RLE: 010 Pixels @ 125,053 */ 10, 0xFF,
  /* ABS: 009 Pixels @ 135,053 */ 0, 9, 0xEA, 0xAE, 0x96, 0x82, 0x84, 0x8A, 0x8E, 0x97, 0xEA,
  /* RLE: 043 Pixels @ 144,053 */ 43, 0xFF,
  /* ABS: 047 Pixels @ 187,053 */ 0, 47, 0xFE, 0xF6, 0xF1, 0xFF, 0xFF, 0xFF, 0xD1, 0x16, 0x5E, 0x7A, 0x91, 0xA4, 0xB1, 0xB1, 0xB3, 0xC1, 0xC5, 0xC3, 0xC3, 0xC7, 0xBB, 0xB2, 0xAC, 0x56, 0x1A, 0x0B, 0xC9, 0xFF, 0xFF, 0xFF, 0xF3, 0x71, 0x26, 0x3C, 0x2C,
        0x25, 0x25, 0x26, 0x31, 0x43, 0x56, 0x6B, 0x98, 0xAE, 0xD5, 0xF7, 0xFE,
  /* RLE: 008 Pixels @ 234,053 */ 8, 0xFF,
  /* ABS: 004 Pixels @ 242,053 */ 0, 4, 0xF4, 0x6A, 0x40, 0xE9,
  /* RLE: 023 Pixels @ 246,053 */ 23, 0xFF,
  /* ABS: 010 Pixels @ 269,053 */ 0, 10, 0x65, 0x03, 0x26, 0x4D, 0xE1, 0xFF, 0xFC, 0x93, 0x2F, 0xD0,
  /* RLE: 080 Pixels @ 279,053 */ 80, 0xFF,
  /* ABS: 017 Pixels @ 059,054 */ 0, 17, 0xFB, 0xE8, 0xCC, 0xA5, 0x65, 0x3F, 0x3C, 0x40, 0x59, 0x7E, 0xB5, 0xD1, 0xDC, 0xDF, 0xEB, 0xF1, 0xFB,
  /* RLE: 005 Pixels @ 076,054 */ 5, 0xFF,
  /* ABS: 010 Pixels @ 081,054 */ 0, 10, 0xF7, 0xDD, 0xBE, 0x97, 0x7D, 0x90, 0xBF, 0xD9, 0xEA, 0xFC,
  /* RLE: 021 Pixels @ 091,054 */ 21, 0xFF,
  /* ABS: 011 Pixels @ 112,054 */ 0, 11, 0xDF, 0x79, 0xA8, 0xE1, 0xFC, 0xEB, 0x91, 0x8F, 0xCC, 0xEA, 0xFD,
  /* RLE: 014 Pixels @ 123,054 */ 14, 0xFF,
  /* ABS: 006 Pixels @ 137,054 */ 0, 6, 0xFE, 0xFC, 0xF9, 0xF4, 0xF8, 0xFD,
  /* RLE: 024 Pixels @ 143,054 */ 24, 0xFF,
  /* ABS: 007 Pixels @ 167,054 */ 0, 7, 0xFE, 0xFC, 0xF6, 0xF2, 0xE8, 0xE6, 0xEF,
  /* RLE: 019 Pixels @ 174,054 */ 19, 0xFF,
  /* ABS: 036 Pixels @ 193,054 */ 0, 36, 0xE0, 0x25, 0x57, 0x63, 0x55, 0x4F, 0x44, 0x43, 0x3E, 0x40, 0x42, 0x41, 0x41, 0x43, 0x3F, 0x40, 0x40, 0x70, 0x63, 0x33, 0xF7, 0xFF, 0xFF, 0xFF, 0xA5, 0x30, 0xC8, 0xE9, 0xE1, 0xDD, 0xDC, 0xDD, 0xE3, 0xEC, 0xF6,
        0xFC,
  /* RLE: 014 Pixels @ 229,054 */ 14, 0xFF,
  /* ABS: 004 Pixels @ 243,054 */ 0, 4, 0xE2, 0x42, 0x6C, 0xF3,
  /* RLE: 022 Pixels @ 247,054 */ 22, 0xFF,
  /* ABS: 011 Pixels @ 269,054 */ 0, 11, 0xBF, 0x27, 0x78, 0xE1, 0xFF, 0xFF, 0xFF, 0xF5, 0x5D, 0x66, 0xFE,
  /* RLE: 076 Pixels @ 280,054 */ 76, 0xFF,
  /* ABS: 030 Pixels @ 056,055 */ 0, 30, 0xFD, 0xE8, 0xAA, 0x75, 0x36, 0x1D, 0x3F, 0x73, 0x9F, 0xD0, 0xEF, 0xD6, 0xAF, 0x9E, 0x88, 0x8F, 0x83, 0x8B, 0x86, 0x90, 0xF3, 0xFF, 0xFB, 0xD1, 0xA7, 0x91, 0x84, 0xA0, 0xD5, 0xF4,
  /* RLE: 025 Pixels @ 086,055 */ 25, 0xFF,
  /* ABS: 015 Pixels @ 111,055 */ 0, 15, 0xF4, 0x71, 0xCA, 0xFF, 0xFF, 0xFF, 0xA8, 0x54, 0xB1, 0xCA, 0xD6, 0xED, 0xF0, 0xF2, 0xF1,
  /* RLE: 004 Pixels @ 126,055 */ 4, 0xF3,
  /* ABS: 016 Pixels @ 130,055 */ 0, 16, 0xF0, 0xF1, 0xF0, 0xE8, 0xD4, 0xD2, 0xD1, 0xCD, 0xC5, 0xAE, 0xAF, 0xB1, 0xAC, 0xA0, 0xA4, 0xE9,
  /* RLE: 014 Pixels @ 146,055 */ 14, 0xFF,
  /* ABS: 015 Pixels @ 160,055 */ 0, 15, 0xFD, 0xF7, 0xE5, 0xC6, 0xB2, 0xA3, 0x91, 0x7E, 0x69, 0x5A, 0x50, 0x38, 0x33, 0x88, 0xFC,
  /* RLE: 018 Pixels @ 175,055 */ 18, 0xFF,
  /* ABS: 027 Pixels @ 193,055 */ 0, 27, 0xEC, 0x42, 0xA4, 0xFF, 0xFF, 0xFD, 0xFA, 0xFA, 0xF9, 0xF8, 0xF8, 0xF6, 0xF8, 0xF8, 0xF8, 0xF9, 0xF5, 0xAD, 0x24, 0x94, 0xFF, 0xFF, 0xFF, 0xF5, 0x4D, 0x7F, 0xFC,
  /* RLE: 024 Pixels @ 220,055 */ 24, 0xFF,
  /* ABS: 003 Pixels @ 244,055 */ 0, 3, 0xC7, 0x23, 0xA8,
  /* RLE: 022 Pixels @ 247,055 */ 22, 0xFF,
  /* ABS: 011 Pixels @ 269,055 */ 0, 11, 0xFD, 0xBA, 0x20, 0x87, 0xF9, 0xFF, 0xFF, 0xFF, 0xB7, 0x20, 0xF9,
  /* RLE: 073 Pixels @ 280,055 */ 73, 0xFF,
  /* ABS: 031 Pixels @ 053,056 */ 0, 31, 0xE9, 0xC5, 0x83, 0x47, 0x2F, 0x49, 0x74, 0xB8, 0xDE, 0xCD, 0xBA, 0x97, 0x82, 0x84, 0x9D, 0xB8, 0xD2, 0xE6, 0xF2, 0xF5, 0xF8, 0xE4, 0x53, 0xAB, 0x89, 0x7D, 0xA0, 0xCB, 0xF2, 0xFA, 0xFE,
  /* RLE: 027 Pixels @ 084,056 */ 27, 0xFF,
  /* ABS: 035 Pixels @ 111,056 */ 0, 35, 0xEE, 0x60, 0xD2, 0xF8, 0xFF, 0xFF, 0xF5, 0xC1, 0xA6, 0xA1, 0x90, 0x94, 0x93, 0x86, 0x91, 0x7A, 0x78, 0x7D, 0x79, 0x91, 0x8C, 0x92, 0x90, 0x8C, 0x8D, 0xA0, 0xA7, 0xA9, 0x9D, 0x9D, 0x9B, 0x98, 0x97, 0x9C, 0xF1,
  /* RLE: 004 Pixels @ 146,056 */ 4, 0xFF,
  /* ABS: 024 Pixels @ 150,056 */ 0, 24, 0xFE, 0xF8, 0xE6, 0xD3, 0xC6, 0xB1, 0x96, 0x75, 0x59, 0x46, 0x39, 0x35, 0x38, 0x40, 0x49, 0x52, 0x69, 0x86, 0x9F, 0xAA, 0xBB, 0xCE, 0xE0, 0xF3,
  /* RLE: 019 Pixels @ 174,056 */ 19, 0xFF,
  /* ABS: 004 Pixels @ 193,056 */ 0, 4, 0xFD, 0x7D, 0x52, 0xF5,
  /* RLE: 012 Pixels @ 197,056 */ 12, 0xFF,
  /* ABS: 010 Pixels @ 209,056 */ 0, 10, 0xEB, 0x30, 0x6C, 0xF2, 0xFF, 0xFF, 0xFF, 0xDE, 0x35, 0xA4,
  /* RLE: 025 Pixels @ 219,056 */ 25, 0xFF,
  /* ABS: 004 Pixels @ 244,056 */ 0, 4, 0xFE, 0x83, 0x2E, 0xEA,
  /* RLE: 022 Pixels @ 248,056 */ 22, 0xFF,
  /* ABS: 010 Pixels @ 270,056 */ 0, 10, 0xFE, 0xC0, 0x3C, 0x5B, 0xE3, 0xFF, 0xFF, 0xE0, 0x2E, 0xD3,
  /* RLE: 070 Pixels @ 280,056 */ 70, 0xFF,
  /* ABS: 017 Pixels @ 050,057 */ 0, 17, 0xF4, 0xD4, 0x86, 0x43, 0x2E, 0x5A, 0x9E, 0xCD, 0xE3, 0xDA, 0x9E, 0x8A, 0x8F, 0xB5, 0xD2, 0xE6, 0xF8,
  /* RLE: 005 Pixels @ 067,057 */ 5, 0xFF,
  /* ABS: 007 Pixels @ 072,057 */ 0, 7, 0xF8, 0xCB, 0x6D, 0x61, 0xAE, 0xD3, 0xEF,
  /* RLE: 032 Pixels @ 079,057 */ 32, 0xFF,
  /* ABS: 056 Pixels @ 111,057 */ 0, 56, 0xFE, 0xC9, 0x7E, 0x79, 0x93, 0xA9, 0xBB, 0xC9, 0xDD, 0xDE, 0xDE, 0xDA, 0xDF, 0xDE, 0xDF, 0xDA, 0xDD, 0xCF, 0xBC, 0xBD, 0xB0, 0x9F, 0xA3, 0x9A, 0x96, 0x90, 0x85, 0x82, 0x85, 0x8D, 0x8C, 0x86, 0x91, 0xA0, 0xE7,
        0xE2, 0xC9, 0xA6, 0x86, 0x6B, 0x52, 0x42, 0x35, 0x2E, 0x3D, 0x5B, 0x77, 0x8D, 0xA0, 0xBD, 0xCF, 0xDD, 0xE7, 0xF0, 0xF8, 0xFD,
  /* RLE: 027 Pixels @ 167,057 */ 27, 0xFF,
  /* ABS: 003 Pixels @ 194,057 */ 0, 3, 0xB3, 0x37, 0xDF,
  /* RLE: 012 Pixels @ 197,057 */ 12, 0xFF,
  /* ABS: 003 Pixels @ 209,057 */ 0, 3, 0xEB, 0x2D, 0xA4,
  /* RLE: 004 Pixels @ 212,057 */ 4, 0xFF,
  /* ABS: 003 Pixels @ 216,057 */ 0, 3, 0xE0, 0x37, 0xA8,
  /* RLE: 026 Pixels @ 219,057 */ 26, 0xFF,
  /* ABS: 007 Pixels @ 245,057 */ 0, 7, 0xDD, 0x38, 0x98, 0xFD, 0xFF, 0xFF, 0xFE,
  /* RLE: 019 Pixels @ 252,057 */ 19, 0xFF,
  /* ABS: 009 Pixels @ 271,057 */ 0, 9, 0xFE, 0xCF, 0x48, 0x4B, 0xC0, 0xFA, 0xE2, 0x32, 0xCF,
  /* RLE: 068 Pixels @ 280,057 */ 68, 0xFF,
  /* ABS: 014 Pixels @ 048,058 */ 0, 14, 0xEB, 0xAC, 0x49, 0x2E, 0x60, 0xAE, 0xE6, 0xFF, 0xEB, 0xAA, 0x76, 0x8F, 0xC9, 0xF7,
  /* RLE: 010 Pixels @ 062,058 */ 10, 0xFF,
  /* ABS: 004 Pixels @ 072,058 */ 0, 4, 0x9D, 0x3A, 0xB8, 0xFB,
  /* RLE: 037 Pixels @ 076,058 */ 37, 0xFF,
  /* ABS: 043 Pixels @ 113,058 */ 0, 43, 0xFD, 0xE7, 0xD0, 0xC1, 0xB0, 0xA4, 0xA0, 0x96, 0x96, 0x9F, 0x96, 0x97, 0x9A, 0xA1, 0xAE, 0xAD, 0xA7, 0xB4, 0xB8, 0xBC, 0xC7, 0xD1, 0xDA, 0xDE, 0xEA, 0xF4, 0xEE, 0xCE, 0xB3, 0x93, 0x71, 0x4F, 0x2B, 0x27, 0x3D,
        0x50, 0x65, 0x85, 0xAF, 0xC8, 0xDF, 0xEF, 0xFD,
  /* RLE: 038 Pixels @ 156,058 */ 38, 0xFF,
  /* ABS: 003 Pixels @ 194,058 */ 0, 3, 0xF3, 0x29, 0xAD,
  /* RLE: 012 Pixels @ 197,058 */ 12, 0xFF,
  /* ABS: 010 Pixels @ 209,058 */ 0, 10, 0xF6, 0x5E, 0x53, 0xE2, 0xFE, 0xFF, 0xFF, 0xEB, 0x3E, 0x90,
  /* RLE: 027 Pixels @ 219,058 */ 27, 0xFF,
  /* ABS: 008 Pixels @ 246,058 */ 0, 8, 0x97, 0x2F, 0xE5, 0xFF, 0xDD, 0x97, 0xA6, 0xDD,
  /* RLE: 019 Pixels @ 254,058 */ 19, 0xFF,
  /* ABS: 007 Pixels @ 273,058 */ 0, 7, 0xF3, 0x7B, 0x21, 0x7A, 0xC1, 0x2E, 0xC4,
  /* RLE: 065 Pixels @ 280,058 */ 65, 0xFF,
  /* ABS: 015 Pixels @ 045,059 */ 0, 15, 0xFE, 0xE4, 0x98, 0x41, 0x41, 0x97, 0xDE, 0xF7, 0xFF, 0xEC, 0xA6, 0x83, 0xB4, 0xEC, 0xFB,
  /* RLE: 012 Pixels @ 060,059 */ 12, 0xFF,
  /* ABS: 003 Pixels @ 072,059 */ 0, 3, 0xE4, 0xE5, 0xFE,
  /* RLE: 044 Pixels @ 075,059 */ 44, 0xFF,
  /* RLE: 008 Pixels @ 119,059 */ 8, 0xFE,
  /* RLE: 005 Pixels @ 127,059 */ 5, 0xFF,
  /* ABS: 019 Pixels @ 132,059 */ 0, 19, 0xFB, 0xEC, 0xD8, 0xC1, 0x9E, 0x6D, 0x4D, 0x3A, 0x3F, 0x41, 0x5B, 0x89, 0xA9, 0xC4, 0xE0, 0xEE, 0xF3, 0xF9, 0xFE,
  /* RLE: 044 Pixels @ 151,059 */ 44, 0xFF,
  /* ABS: 003 Pixels @ 195,059 */ 0, 3, 0x58, 0x5D, 0xFE,
  /* RLE: 012 Pixels @ 198,059 */ 12, 0xFF,
  /* ABS: 010 Pixels @ 210,059 */ 0, 10, 0xCF, 0x44, 0x32, 0x4D, 0x6D, 0x83, 0x61, 0x25, 0x9E, 0xFE,
  /* RLE: 018 Pixels @ 220,059 */ 18, 0xFF,
  /* ABS: 018 Pixels @ 238,059 */ 0, 18, 0xFE, 0xE9, 0xDD, 0xD9, 0xD5, 0xCA, 0xB4, 0xD6, 0xE7, 0x2B, 0xA4, 0xF0, 0x38, 0x46, 0x43, 0x36, 0x78, 0xEE,
  /* RLE: 018 Pixels @ 256,059 */ 18, 0xFF,
  /* ABS: 007 Pixels @ 274,059 */ 0, 7, 0xF7, 0xBD, 0x4C, 0x32, 0x17, 0x65, 0xF3,
  /* RLE: 063 Pixels @ 281,059 */ 63, 0xFF,
  /* ABS: 013 Pixels @ 044,060 */ 0, 13, 0xFD, 0xAD, 0x41, 0x3D, 0xA4, 0xE8, 0xFD, 0xFC, 0xF7, 0xCA, 0x74, 0xA7, 0xEE,
  /* RLE: 070 Pixels @ 057,060 */ 70, 0xFF,
  /* ABS: 016 Pixels @ 127,060 */ 0, 16, 0xFE, 0xFD, 0xF6, 0xCF, 0x9C, 0x69, 0x43, 0x29, 0x37, 0x5C, 0x7A, 0x9E, 0xC7, 0xE0, 0xEF, 0xFC,
  /* RLE: 052 Pixels @ 143,060 */ 52, 0xFF,
  /* ABS: 003 Pixels @ 195,060 */ 0, 3, 0xA1, 0x25, 0xEC,
  /* RLE: 013 Pixels @ 198,060 */ 13, 0xFF,
  /* ABS: 008 Pixels @ 211,060 */ 0, 8, 0xE7, 0xBE, 0x93, 0x77, 0x6A, 0x7B, 0xB1, 0xF6,
  /* RLE: 019 Pixels @ 219,060 */ 19, 0xFF,
  /* ABS: 019 Pixels @ 238,060 */ 0, 19, 0xC3, 0x41, 0x2F, 0x28, 0x26, 0x2F, 0x2B, 0x3E, 0xD7, 0x72, 0x5A, 0xC3, 0x2A, 0xD9, 0xF0, 0xB0, 0x33, 0x66, 0xEF,
  /* RLE: 019 Pixels @ 257,060 */ 19, 0xFF,
  /* ABS: 005 Pixels @ 276,060 */ 0, 5, 0xF1, 0xC9, 0xAF, 0x1E, 0xB6,
  /* RLE: 061 Pixels @ 281,060 */ 61, 0xFF,
  /* ABS: 013 Pixels @ 042,061 */ 0, 13, 0xF1, 0xC6, 0x5C, 0x35, 0x93, 0xD1, 0xB7, 0x9A, 0x82, 0x7E, 0x86, 0x9B, 0xDF,
  /* RLE: 069 Pixels @ 055,061 */ 69, 0xFF,
  /* ABS: 012 Pixels @ 124,061 */ 0, 12, 0xF1, 0xCE, 0xAB, 0x75, 0x44, 0x24, 0x37, 0x53, 0x88, 0xB7, 0xE6, 0xFD,
  /* RLE: 059 Pixels @ 136,061 */ 59, 0xFF,
  /* ABS: 003 Pixels @ 195,061 */ 0, 3, 0xDC, 0x36, 0xB2,
  /* RLE: 039 Pixels @ 198,061 */ 39, 0xFF,
  /* ABS: 020 Pixels @ 237,061 */ 0, 20, 0xE6, 0x3A, 0x87, 0xEB, 0xF1, 0xF7, 0xFB, 0xF5, 0x47, 0x61, 0xC0, 0x33, 0x9D, 0x2B, 0xDD, 0xFD, 0xF3, 0xE1, 0x2E, 0x7F,
  /* RLE: 016 Pixels @ 257,061 */ 16, 0xFF,
  /* ABS: 009 Pixels @ 273,061 */ 0, 9, 0xF9, 0xF2, 0xF5, 0xFF, 0xFF, 0xFF, 0x84, 0x3B, 0xEC,
  /* RLE: 056 Pixels @ 282,061 */ 56, 0xFF,
  /* ABS: 016 Pixels @ 038,062 */ 0, 16, 0xFB, 0xE5, 0xBE, 0x7A, 0x3E, 0x1B, 0x2A, 0x79, 0x88, 0x97, 0xAC, 0xC9, 0xE0, 0xEB, 0xF8, 0xFE,
  /* RLE: 065 Pixels @ 054,062 */ 65, 0xFF,
  /* ABS: 014 Pixels @ 119,062 */ 0, 14, 0xFC, 0xF0, 0xD9, 0xAA, 0x6D, 0x43, 0x3A, 0x48, 0x77, 0xA2, 0xCB, 0xE6, 0xF5, 0xFE,
  /* RLE: 042 Pixels @ 133,062 */ 42, 0xFF,
  /* RLE: 003 Pixels @ 175,062 */ 3, 0xFE,
  /* ABS: 021 Pixels @ 178,062 */ 0, 21, 0xFD, 0xFC, 0xFB, 0xFB, 0xFB, 0xF9, 0xF6, 0xF5, 0xF4, 0xF2, 0xF0, 0xF0, 0xEB, 0xE9, 0xE2, 0xE0, 0xD9, 0xBD, 0x31, 0x6A, 0xF8,
  /* RLE: 038 Pixels @ 199,062 */ 38, 0xFF,
  /* ABS: 021 Pixels @ 237,062 */ 0, 21, 0xE0, 0x38, 0xB1, 0xFF, 0xFE, 0xFC, 0xF5, 0xEF, 0xA1, 0x23, 0xC5, 0x34, 0x84, 0x15, 0xC9, 0xF6, 0x63, 0xD2, 0x9F, 0x35, 0xDC,
  /* RLE: 012 Pixels @ 258,062 */ 12, 0xFF,
  /* ABS: 013 Pixels @ 270,062 */ 0, 13, 0xFD, 0xD6, 0x80, 0x48, 0x42, 0x47, 0x6F, 0xCB, 0xF8, 0xE7, 0x47, 0x7C, 0xF9,
  /* RLE: 053 Pixels @ 283,062 */ 53, 0xFF,
  /* ABS: 011 Pixels @ 036,063 */ 0, 11, 0xFE, 0xCC, 0x7B, 0x2D, 0x35, 0x57, 0x08, 0x43, 0xA1, 0xD8, 0xF5,
  /* RLE: 069 Pixels @ 047,063 */ 69, 0xFF,
  /* ABS: 011 Pixels @ 116,063 */ 0, 11, 0xFE, 0xF0, 0xB2, 0x79, 0x49, 0x26, 0x49, 0x75, 0xB0, 0xDA, 0xF9,
  /* RLE: 042 Pixels @ 127,063 */ 42, 0xFF,
  /* ABS: 030 Pixels @ 169,063 */ 0, 30, 0xFA, 0xE3, 0xC2, 0xB3, 0xA4, 0x9B, 0x8C, 0x87, 0x7D, 0x6D, 0x6C, 0x67, 0x67, 0x69, 0x64, 0x5A, 0x59, 0x54, 0x50, 0x49, 0x49, 0x3C, 0x37, 0x2F, 0x37, 0x42, 0x56, 0x51, 0x33, 0xE8,
  /* RLE: 038 Pixels @ 199,063 */ 38, 0xFF,
  /* ABS: 021 Pixels @ 237,063 */ 0, 21, 0xF4, 0x49, 0x63, 0x9E, 0x88, 0x6B, 0x56, 0x47, 0x2B, 0x11, 0xA4, 0x60, 0x52, 0x24, 0x79, 0xB7, 0x21, 0x46, 0xE6, 0x31, 0xAA,
  /* RLE: 011 Pixels @ 258,063 */ 11, 0xFF,
  /* ABS: 014 Pixels @ 269,063 */ 0, 14, 0xF8, 0xA4, 0x26, 0x56, 0xA2, 0xBE, 0xB5, 0x6D, 0x29, 0x7D, 0xF7, 0xC4, 0x27, 0xC1,
  /* RLE: 051 Pixels @ 283,063 */ 51, 0xFF,
  /* ABS: 011 Pixels @ 034,064 */ 0, 11, 0xF0, 0xB5, 0x4F, 0x36, 0x6B, 0xC5, 0xE7, 0x6B, 0x54, 0xE7, 0xFE,
  /* RLE: 068 Pixels @ 045,064 */ 68, 0xFF,
  /* ABS: 011 Pixels @ 113,064 */ 0, 11, 0xEE, 0xCA, 0x92, 0x4C, 0x31, 0x45, 0x7B, 0xB8, 0xE2, 0xF7, 0xFC,
  /* RLE: 042 Pixels @ 124,064 */ 42, 0xFF,
  /* ABS: 033 Pixels @ 166,064 */ 0, 33, 0xFB, 0xC5, 0x61, 0x38, 0x35, 0x41, 0x49, 0x52, 0x5E, 0x74, 0x7A, 0x96, 0x9A, 0x9B, 0x77, 0x55, 0x5E, 0x70, 0x77, 0x79, 0x78, 0x70, 0x6E, 0x78, 0x73, 0x79, 0x6E, 0x6B, 0x65, 0x5E, 0x45, 0x04, 0xB7,
  /* RLE: 039 Pixels @ 199,064 */ 39, 0xFF,
  /* ABS: 021 Pixels @ 238,064 */ 0, 21, 0xB1, 0x44, 0x52, 0x6C, 0x82, 0x9D, 0xB5, 0xC7, 0xD6, 0xF6, 0x93, 0x2D, 0x65, 0x44, 0xAC, 0x58, 0x14, 0xDA, 0x53, 0x79, 0xFE,
  /* RLE: 009 Pixels @ 259,064 */ 9, 0xFF,
  /* ABS: 016 Pixels @ 268,064 */ 0, 16, 0xF4, 0x79, 0x34, 0xBB, 0xF7, 0xFF, 0xFF, 0xFF, 0xFB, 0xC7, 0x49, 0x5E, 0xC3, 0x6A, 0x39, 0xD9,
  /* RLE: 048 Pixels @ 284,064 */ 48, 0xFF,
  /* ABS: 011 Pixels @ 032,065 */ 0, 11, 0xF8, 0xCB, 0x54, 0x35, 0x83, 0xD9, 0xF9, 0xFF, 0xB6, 0x1C, 0xD1,
  /* RLE: 066 Pixels @ 043,065 */ 66, 0xFF,
  /* ABS: 011 Pixels @ 109,065 */ 0, 11, 0xFD, 0xF2, 0xCE, 0x8D, 0x4A, 0x31, 0x54, 0x96, 0xC6, 0xED, 0xFD,
  /* RLE: 046 Pixels @ 120,065 */ 46, 0xFF,
  /* ABS: 034 Pixels @ 166,065 */ 0, 34, 0xD6, 0x38, 0x6C, 0xB5, 0xD8, 0xE7, 0xF0, 0xF9, 0xFC, 0xFE, 0xFF, 0xFF, 0xFF, 0xB9, 0x3B, 0x5D, 0x5A, 0x4E, 0x4C, 0x50, 0x4F, 0x4C, 0x58, 0x66, 0x64, 0x6E, 0x7B, 0x83, 0x92, 0x96, 0x9F, 0x44, 0x7A, 0xFE,
  /* RLE: 038 Pixels @ 200,065 */ 38, 0xFF,
  /* ABS: 004 Pixels @ 238,065 */ 0, 4, 0xFB, 0xEF, 0xF9, 0xFE,
  /* RLE: 006 Pixels @ 242,065 */ 6, 0xFF,
  /* ABS: 011 Pixels @ 248,065 */ 0, 11, 0xBF, 0x18, 0x9E, 0x35, 0xE5, 0xCD, 0xA7, 0xF8, 0x71, 0x6B, 0xFD,
  /* RLE: 008 Pixels @ 259,065 */ 8, 0xFF,
  /* ABS: 004 Pixels @ 267,065 */ 0, 4, 0xF7, 0x87, 0x3C, 0xCA,
  /* RLE: 006 Pixels @ 271,065 */ 6, 0xFF,
  /* ABS: 008 Pixels @ 277,065 */ 0, 8, 0xFE, 0xE1, 0x42, 0x1D, 0x19, 0x0D, 0x5F, 0xFB,
  /* RLE: 046 Pixels @ 285,065 */ 46, 0xFF,
  /* ABS: 011 Pixels @ 031,066 */ 0, 11, 0xE7, 0x6D, 0x2A, 0x83, 0xE7, 0xFF, 0xFF, 0xFF, 0xF3, 0x43, 0x79,
  /* RLE: 065 Pixels @ 042,066 */ 65, 0xFF,
  /* ABS: 009 Pixels @ 107,066 */ 0, 9, 0xFB, 0xC6, 0x89, 0x3A, 0x35, 0x5C, 0xB1, 0xDF, 0xFD,
  /* RLE: 050 Pixels @ 116,066 */ 50, 0xFF,
  /* ABS: 004 Pixels @ 166,066 */ 0, 4, 0xE1, 0x41, 0x5E, 0xDD,
  /* RLE: 009 Pixels @ 170,066 */ 9, 0xFF,
  /* ABS: 006 Pixels @ 179,066 */ 0, 6, 0x87, 0x62, 0xFF, 0xFF, 0xFF, 0xFE,
  /* RLE: 011 Pixels @ 185,066 */ 11, 0xFF,
  /* ABS: 004 Pixels @ 196,066 */ 0, 4, 0xFB, 0x9A, 0x41, 0xEF,
  /* RLE: 048 Pixels @ 200,066 */ 48, 0xFF,
  /* ABS: 011 Pixels @ 248,066 */ 0, 11, 0xD9, 0x23, 0xB7, 0x35, 0x9E, 0xFF, 0xFF, 0xFF, 0x65, 0x6B, 0xFD,
  /* RLE: 007 Pixels @ 259,066 */ 7, 0xFF,
  /* ABS: 004 Pixels @ 266,066 */ 0, 4, 0xFD, 0xA6, 0x25, 0xC7,
  /* RLE: 009 Pixels @ 270,066 */ 9, 0xFF,
  /* ABS: 007 Pixels @ 279,066 */ 0, 7, 0xDB, 0x36, 0x06, 0x7E, 0x3E, 0xA6, 0xFD,
  /* RLE: 043 Pixels @ 286,066 */ 43, 0xFF,
  /* ABS: 013 Pixels @ 029,067 */ 0, 13, 0xF9, 0xBA, 0x41, 0x5D, 0xCF, 0xF9, 0xE6, 0xCB, 0xA7, 0x8A, 0x60, 0x2F, 0xD5,
  /* RLE: 062 Pixels @ 042,067 */ 62, 0xFF,
  /* ABS: 009 Pixels @ 104,067 */ 0, 9, 0xFB, 0xE0, 0x98, 0x4B, 0x3A, 0x62, 0xAD, 0xE5, 0xF6,
  /* RLE: 053 Pixels @ 113,067 */ 53, 0xFF,
  /* ABS: 006 Pixels @ 166,067 */ 0, 6, 0xFE, 0xD2, 0x55, 0x32, 0x8D, 0xF3,
  /* RLE: 007 Pixels @ 172,067 */ 7, 0xFF,
  /* ABS: 003 Pixels @ 179,067 */ 0, 3, 0xAC, 0x37, 0xEA,
  /* RLE: 013 Pixels @ 182,067 */ 13, 0xFF,
  /* ABS: 005 Pixels @ 195,067 */ 0, 5, 0xFD, 0x93, 0xB6, 0x34, 0xCB,
  /* RLE: 048 Pixels @ 200,067 */ 48, 0xFF,
  /* ABS: 011 Pixels @ 248,067 */ 0, 11, 0xE4, 0x35, 0xA8, 0x7F, 0x3E, 0xEB, 0xFF, 0xFF, 0x50, 0x81, 0xFE,
  /* RLE: 007 Pixels @ 259,067 */ 7, 0xFF,
  /* ABS: 004 Pixels @ 266,067 */ 0, 4, 0xC8, 0x36, 0xA6, 0xFC,
  /* RLE: 009 Pixels @ 270,067 */ 9, 0xFF,
  /* ABS: 007 Pixels @ 279,067 */ 0, 7, 0xFE, 0xC0, 0x1B, 0xB6, 0xAC, 0x37, 0xE5,
  /* RLE: 042 Pixels @ 286,067 */ 42, 0xFF,
  /* ABS: 014 Pixels @ 028,068 */ 0, 14, 0xFE, 0x95, 0x27, 0x8B, 0xF1, 0xD1, 0x90, 0x84, 0x96, 0xC5, 0xD2, 0x44, 0x6E, 0xFC,
  /* RLE: 060 Pixels @ 042,068 */ 60, 0xFF,
  /* ABS: 008 Pixels @ 102,068 */ 0, 8, 0xFE, 0xD0, 0x74, 0x33, 0x48, 0x90, 0xDA, 0xFB,
  /* RLE: 058 Pixels @ 110,068 */ 58, 0xFF,
  /* ABS: 005 Pixels @ 168,068 */ 0, 5, 0xF1, 0x9D, 0x25, 0x6C, 0xED,
  /* RLE: 006 Pixels @ 173,068 */ 6, 0xFF,
  /* ABS: 007 Pixels @ 179,068 */ 0, 7, 0xDB, 0x38, 0xC1, 0xE1, 0x9E, 0xB8, 0xF6,
  /* RLE: 009 Pixels @ 186,068 */ 9, 0xFF,
  /* ABS: 005 Pixels @ 195,068 */ 0, 5, 0xFE, 0x75, 0xC8, 0x37, 0x93,
  /* RLE: 048 Pixels @ 200,068 */ 48, 0xFF,
  /* ABS: 010 Pixels @ 248,068 */ 0, 10, 0xED, 0x44, 0x9E, 0xD9, 0x2A, 0x78, 0xEB, 0xC3, 0x29, 0xA7,
  /* RLE: 007 Pixels @ 258,068 */ 7, 0xFF,
  /* ABS: 004 Pixels @ 265,068 */ 0, 4, 0xFD, 0x52, 0x60, 0xF9,
  /* RLE: 011 Pixels @ 269,068 */ 11, 0xFF,
  /* ABS: 006 Pixels @ 280,068 */ 0, 6, 0xF8, 0x77, 0x4D, 0xDD, 0x20, 0xD0,
  /* RLE: 041 Pixels @ 286,068 */ 41, 0xFF,
  /* ABS: 014 Pixels @ 027,069 */ 0, 14, 0xF0, 0x78, 0x2C, 0xB2, 0xBE, 0x79, 0x8C, 0xDC, 0xFD, 0xFF, 0xFF, 0xD6, 0x19, 0xCE,
  /* RLE: 059 Pixels @ 041,069 */ 59, 0xFF,
  /* ABS: 007 Pixels @ 100,069 */ 0, 7, 0xE6, 0xA1, 0x45, 0x37, 0x76, 0xD6, 0xFC,
  /* RLE: 063 Pixels @ 107,069 */ 63, 0xFF,
  /* ABS: 004 Pixels @ 170,069 */ 0, 4, 0xE0, 0x37, 0x56, 0xE9,
  /* RLE: 005 Pixels @ 174,069 */ 5, 0xFF,
  /* ABS: 007 Pixels @ 179,069 */ 0, 7, 0xFD, 0x5C, 0x7C, 0xF0, 0xD5, 0x6E, 0xCB,
  /* RLE: 010 Pixels @ 186,069 */ 10, 0xFF,
  /* ABS: 004 Pixels @ 196,069 */ 0, 4, 0xC0, 0x76, 0x71, 0x51,
  /* RLE: 048 Pixels @ 200,069 */ 48, 0xFF,
  /* ABS: 010 Pixels @ 248,069 */ 0, 10, 0xF0, 0x49, 0x8F, 0xFE, 0xCA, 0x3F, 0x20, 0x2D, 0x8C, 0xF5,
  /* RLE: 006 Pixels @ 258,069 */ 6, 0xFF,
  /* ABS: 004 Pixels @ 264,069 */ 0, 4, 0xFD, 0xA4, 0x3B, 0xE1,
  /* RLE: 004 Pixels @ 268,069 */ 4, 0xFF,
  /* ABS: 005 Pixels @ 272,069 */ 0, 5, 0xFB, 0xEB, 0xE2, 0xEF, 0xFD,
  /* RLE: 004 Pixels @ 277,069 */ 4, 0xFF,
  /* ABS: 005 Pixels @ 281,069 */ 0, 5, 0xEC, 0x33, 0x8F, 0x3B, 0xB6,
  /* RLE: 040 Pixels @ 286,069 */ 40, 0xFF,
  /* ABS: 008 Pixels @ 026,070 */ 0, 8, 0xED, 0x6D, 0x38, 0xA4, 0x8F, 0xA4, 0xDF, 0xFB,
  /* RLE: 004 Pixels @ 034,070 */ 4, 0xFF,
  /* ABS: 003 Pixels @ 038,070 */ 0, 3, 0x8B, 0x40, 0xF0,
  /* RLE: 056 Pixels @ 041,070 */ 56, 0xFF,
  /* ABS: 008 Pixels @ 097,070 */ 0, 8, 0xFD, 0xE3, 0x9F, 0x41, 0x43, 0x9A, 0xE1, 0xFB,
  /* RLE: 066 Pixels @ 105,070 */ 66, 0xFF,
  /* ABS: 004 Pixels @ 171,070 */ 0, 4, 0xD0, 0x3F, 0x60, 0xF0,
  /* RLE: 005 Pixels @ 175,070 */ 5, 0xFF,
  /* ABS: 021 Pixels @ 180,070 */ 0, 21, 0x8B, 0x3E, 0xE9, 0xB8, 0xB4, 0xF6, 0xFB, 0xFB, 0xFA, 0xF4, 0xF3, 0xF1, 0xEF, 0xEE, 0xEA, 0xE9, 0xE5, 0xC4, 0xAB, 0x20, 0xF2,
  /* RLE: 047 Pixels @ 201,070 */ 47, 0xFF,
  /* ABS: 009 Pixels @ 248,070 */ 0, 9, 0xF3, 0x4E, 0x8D, 0xFF, 0xFF, 0xE7, 0xCC, 0xE0, 0xFB,
  /* RLE: 007 Pixels @ 257,070 */ 7, 0xFF,
  /* ABS: 022 Pixels @ 264,070 */ 0, 22, 0xE4, 0x3E, 0x9E, 0xFE, 0xFF, 0xFE, 0xEC, 0x9E, 0x5A, 0x43, 0x41, 0x43, 0x5C, 0xA0, 0xE4, 0xFF, 0xFF, 0xFF, 0x93, 0x32, 0x3D, 0xA0,
  /* RLE: 039 Pixels @ 286,070 */ 39, 0xFF,
  /* ABS: 006 Pixels @ 025,071 */ 0, 6, 0xF9, 0x71, 0x32, 0x89, 0x7F, 0xD3,
  /* RLE: 006 Pixels @ 031,071 */ 6, 0xFF,
  /* ABS: 004 Pixels @ 037,071 */ 0, 4, 0xFA, 0x57, 0x74, 0xFB,
  /* RLE: 055 Pixels @ 041,071 */ 55, 0xFF,
  /* ABS: 006 Pixels @ 096,071 */ 0, 6, 0xF1, 0x97, 0x38, 0x4B, 0xB0, 0xEF,
  /* RLE: 070 Pixels @ 102,071 */ 70, 0xFF,
  /* ABS: 004 Pixels @ 172,071 */ 0, 4, 0xCE, 0x24, 0x87, 0xFA,
  /* RLE: 004 Pixels @ 176,071 */ 4, 0xFF,
  /* ABS: 021 Pixels @ 180,071 */ 0, 21, 0xDD, 0x2A, 0x6C, 0xA2, 0x97, 0x97, 0x9E, 0xA4, 0xAD, 0xA1, 0xA5, 0x97, 0x92, 0x96, 0x85, 0x7F, 0x7E, 0x78, 0x94, 0x13, 0xCE,
  /* RLE: 047 Pixels @ 201,071 */ 47, 0xFF,
  /* ABS: 004 Pixels @ 248,071 */ 0, 4, 0xF3, 0x4D, 0x89, 0xFE,
  /* RLE: 012 Pixels @ 252,071 */ 12, 0xFF,
  /* ABS: 022 Pixels @ 264,071 */ 0, 22, 0x92, 0x37, 0xF5, 0xFF, 0xFF, 0xC5, 0x44, 0x3D, 0x96, 0xC8, 0xD0, 0xBD, 0x8D, 0x45, 0x32, 0xB9, 0xFA, 0xFF, 0xE4, 0x38, 0x05, 0x91,
  /* RLE: 038 Pixels @ 286,071 */ 38, 0xFF,
  /* ABS: 006 Pixels @ 024,072 */ 0, 6, 0xF8, 0x8E, 0x17, 0x4F, 0x93, 0xF7,
  /* RLE: 007 Pixels @ 030,072 */ 7, 0xFF,
  /* ABS: 003 Pixels @ 037,072 */ 0, 3, 0xDE, 0x37, 0xB0,
  /* RLE: 054 Pixels @ 040,072 */ 54, 0xFF,
  /* ABS: 006 Pixels @ 094,072 */ 0, 6, 0xEE, 0x9D, 0x3C, 0x53, 0xB8, 0xF5,
  /* RLE: 058 Pixels @ 100,072 */ 58, 0xFF,
  /* ABS: 009 Pixels @ 158,072 */ 0, 9, 0xFA, 0xE1, 0xCA, 0xBC, 0xBA, 0xC1, 0xCF, 0xE8, 0xFD,
  /* RLE: 005 Pixels @ 167,072 */ 5, 0xFF,
  /* ABS: 004 Pixels @ 172,072 */ 0, 4, 0xFE, 0xB7, 0x25, 0xA6,
  /* RLE: 004 Pixels @ 176,072 */ 4, 0xFF,
  /* ABS: 021 Pixels @ 180,072 */ 0, 21, 0xFE, 0xD3, 0x60, 0x33, 0x21, 0x30, 0x49, 0x57, 0x5F, 0x65, 0x5E, 0x4D, 0x4B, 0x4B, 0x44, 0x44, 0x3A, 0x44, 0x4B, 0x1A, 0x9A,
  /* RLE: 047 Pixels @ 201,072 */ 47, 0xFF,
  /* ABS: 003 Pixels @ 248,072 */ 0, 3, 0xF2, 0x4D, 0x8B,
  /* RLE: 012 Pixels @ 251,072 */ 12, 0xFF,
  /* ABS: 023 Pixels @ 263,072 */ 0, 23, 0xE1, 0x38, 0xAD, 0xFF, 0xFD, 0xB3, 0x32, 0x87, 0xEC, 0xE6, 0xEF, 0xFD, 0xFF, 0xFE, 0xF0, 0xA6, 0x31, 0x8E, 0xFD, 0xFE, 0x9B, 0x00, 0x7F,
  /* RLE: 038 Pixels @ 286,072 */ 38, 0xFF,
  /* ABS: 005 Pixels @ 024,073 */ 0, 5, 0xAF, 0x19, 0x17, 0xA2, 0xF6,
  /* RLE: 008 Pixels @ 029,073 */ 8, 0xFF,
  /* ABS: 003 Pixels @ 037,073 */ 0, 3, 0xCA, 0x2E, 0xD1,
  /* RLE: 011 Pixels @ 040,073 */ 11, 0xFF,
  /* ABS: 002 Pixels @ 051,073 */ 0, 2, 0xFE, 0xFE,
  /* RLE: 039 Pixels @ 053,073 */ 39, 0xFF,
  /* ABS: 006 Pixels @ 092,073 */ 0, 6, 0xFA, 0xC3, 0x52, 0x41, 0xA4, 0xEF,
  /* RLE: 058 Pixels @ 098,073 */ 58, 0xFF,
  /* ABS: 021 Pixels @ 156,073 */ 0, 21, 0xF0, 0xB5, 0x63, 0x31, 0x1E, 0x38, 0x3F, 0x34, 0x30, 0x41, 0x72, 0xC0, 0xF6, 0xFE, 0xFF, 0xFF, 0xFF, 0xFC, 0x72, 0x2E, 0xE7,
  /* RLE: 005 Pixels @ 177,073 */ 5, 0xFF,
  /* ABS: 020 Pixels @ 182,073 */ 0, 20, 0xF7, 0xDD, 0xBB, 0xA9, 0x9B, 0x93, 0x93, 0x92, 0x95, 0xA1, 0xA9, 0xB1, 0xB9, 0xC3, 0xC6, 0xBA, 0xAD, 0x3B, 0x6E, 0xFA,
  /* RLE: 046 Pixels @ 202,073 */ 46, 0xFF,
  /* ABS: 003 Pixels @ 248,073 */ 0, 3, 0xF0, 0x48, 0x91,
  /* RLE: 011 Pixels @ 251,073 */ 11, 0xFF,
  /* ABS: 024 Pixels @ 262,073 */ 0, 24, 0xFE, 0x8E, 0x46, 0xF1, 0xFF, 0xD6, 0x2B, 0x96, 0xAD, 0x54, 0x41, 0x48, 0x70, 0xBF, 0xF9, 0xFF, 0xFF, 0xAA, 0x31, 0xCE, 0xFF, 0xE5, 0x1C, 0x71,
  /* RLE: 037 Pixels @ 286,073 */ 37, 0xFF,
  /* ABS: 005 Pixels @ 023,074 */ 0, 5, 0xE2, 0x29, 0x2A, 0x9A, 0xFA,
  /* RLE: 009 Pixels @ 028,074 */ 9, 0xFF,
  /* ABS: 003 Pixels @ 037,074 */ 0, 3, 0xB7, 0x25, 0xE3,
  /* RLE: 007 Pixels @ 040,074 */ 7, 0xFF,
  /* ABS: 011 Pixels @ 047,074 */ 0, 11, 0xF5, 0xCB, 0xAB, 0x98, 0x8A, 0x8C, 0x9A, 0xA1, 0xB2, 0xD5, 0xFE,
  /* RLE: 011 Pixels @ 058,074 */ 11, 0xFF,
  /* ABS: 005 Pixels @ 069,074 */ 0, 5, 0xFE, 0xFA, 0xF9, 0xF9, 0xFE,
  /* RLE: 017 Pixels @ 074,074 */ 17, 0xFF,
  /* ABS: 005 Pixels @ 091,074 */ 0, 5, 0xED, 0x78, 0x2F, 0x85, 0xED,
  /* RLE: 058 Pixels @ 096,074 */ 58, 0xFF,
  /* ABS: 048 Pixels @ 154,074 */ 0, 48, 0xFD, 0xBD, 0x4D, 0x38, 0x69, 0x44, 0x18, 0x5D, 0xBA, 0xF7, 0xE2, 0xB4, 0x61, 0x26, 0x4B, 0xBC, 0xFB, 0xFF, 0xFF, 0xFF, 0xE9, 0x4B, 0x74, 0xF8, 0xFF, 0xFF, 0xFE, 0xF8, 0xE4, 0xD4, 0xBF, 0xB3, 0xA8, 0x9B, 0x8A,
        0x76, 0x62, 0x4B, 0x3A, 0x30, 0x2F, 0x2D, 0x35, 0x43, 0x4D, 0x36, 0x44, 0xED,
  /* RLE: 046 Pixels @ 202,074 */ 46, 0xFF,
  /* ABS: 003 Pixels @ 248,074 */ 0, 3, 0xEA, 0x3F, 0x9A,
  /* RLE: 011 Pixels @ 251,074 */ 11, 0xFF,
  /* ABS: 024 Pixels @ 262,074 */ 0, 24, 0xF3, 0x33, 0xAA, 0xFF, 0xF4, 0x5D, 0x73, 0xC3, 0x2E, 0x19, 0x6F, 0xBE, 0x7A, 0x32, 0x69, 0xE9, 0xFF, 0xF6, 0x4C, 0x9A, 0xFF, 0xFB, 0x68, 0x67,
  /* RLE: 036 Pixels @ 286,074 */ 36, 0xFF,
  /* ABS: 005 Pixels @ 022,075 */ 0, 5, 0xF8, 0x73, 0x35, 0xCF, 0xFA,
  /* RLE: 010 Pixels @ 027,075 */ 10, 0xFF,
  /* ABS: 003 Pixels @ 037,075 */ 0, 3, 0xB0, 0x28, 0xF4,
  /* RLE: 005 Pixels @ 040,075 */ 5, 0xFF,
  /* ABS: 033 Pixels @ 045,075 */ 0, 33, 0xE9, 0xA1, 0x44, 0x39, 0x3F, 0x52, 0x5A, 0x58, 0x5D, 0x4D, 0x3F, 0x33, 0x8E, 0xFA, 0xFF, 0xFF, 0xF3, 0xD2, 0xA3, 0x8C, 0x78, 0x69, 0x59, 0x57, 0x54, 0x46, 0x3F, 0x39, 0x50, 0x7A, 0xB0, 0xEA, 0xFE,
  /* RLE: 011 Pixels @ 078,075 */ 11, 0xFF,
  /* ABS: 006 Pixels @ 089,075 */ 0, 6, 0xFD, 0xCB, 0x4E, 0x4A, 0xC4, 0xFB,
  /* RLE: 058 Pixels @ 095,075 */ 58, 0xFF,
  /* ABS: 049 Pixels @ 153,075 */ 0, 49, 0xF1, 0x95, 0x31, 0x8A, 0xE5, 0xFA, 0xEE, 0xBE, 0x63, 0x2F, 0x5D, 0xC6, 0xF7, 0xF7, 0xD5, 0x6A, 0x31, 0x87, 0xEF, 0xE9, 0xDB, 0xCD, 0x74, 0x11, 0x78, 0x7A, 0x67, 0x52, 0x39, 0x35, 0x39, 0x3C, 0x43, 0x4A, 0x64,
        0x6F, 0x80, 0x92, 0xA1, 0xC5, 0xCF, 0xDB, 0xE3, 0xEA, 0xEE, 0xF1, 0xBA, 0x2D, 0xDF,
  /* RLE: 046 Pixels @ 202,075 */ 46, 0xFF,
  /* ABS: 003 Pixels @ 248,075 */ 0, 3, 0xE2, 0x33, 0xAB,
  /* RLE: 011 Pixels @ 251,075 */ 11, 0xFF,
  /* ABS: 025 Pixels @ 262,075 */ 0, 25, 0xB3, 0x3D, 0xE7, 0xFF, 0xBB, 0x35, 0xD2, 0x56, 0x76, 0xAC, 0x34, 0xAE, 0xF9, 0xD9, 0x47, 0x63, 0xEE, 0xFF, 0x8C, 0x56, 0xF6, 0xFE, 0x88, 0x5B, 0xFE,
  /* RLE: 035 Pixels @ 287,075 */ 35, 0xFF,
  /* ABS: 010 Pixels @ 022,076 */ 0, 10, 0xCC, 0x18, 0x45, 0x8A, 0x98, 0xB0, 0xC3, 0xD3, 0xF0, 0xFD,
  /* RLE: 005 Pixels @ 032,076 */ 5, 0xFF,
  /* ABS: 003 Pixels @ 037,076 */ 0, 3, 0xA3, 0x26, 0xF8,
  /* RLE: 004 Pixels @ 040,076 */ 4, 0xFF,
  /* ABS: 034 Pixels @ 044,076 */ 0, 34, 0xE0, 0x4B, 0x36, 0x9B, 0xD7, 0xF1, 0xFC, 0xFD, 0xFD, 0xFD, 0xFB, 0xED, 0x9D, 0x19, 0xC2, 0xFF, 0xEB, 0x6D, 0x31, 0x4B, 0x75, 0x8F, 0xA6, 0xAE, 0xAB, 0xB3, 0xBE, 0xBD, 0xB2, 0xA2, 0x5F, 0x24, 0x47, 0xD3,
  /* RLE: 010 Pixels @ 078,076 */ 10, 0xFF,
  /* ABS: 005 Pixels @ 088,076 */ 0, 5, 0xFB, 0xAE, 0x34, 0x6C, 0xEC,
  /* RLE: 059 Pixels @ 093,076 */ 59, 0xFF,
  /* ABS: 036 Pixels @ 152,076 */ 0, 36, 0xF9, 0x73, 0x33, 0xC4, 0xF3, 0xF1, 0xF5, 0xFD, 0xFF, 0xFA, 0xCA, 0x59, 0x26, 0x7A, 0xEF, 0xFF, 0xF8, 0xAA, 0x22, 0x47, 0x3E, 0x27, 0x28, 0x34, 0x46, 0x62, 0x81, 0x99, 0xAE, 0xBC, 0xC4, 0xD3, 0xE3, 0xF5, 0xFA,
        0xFE,
  /* RLE: 011 Pixels @ 188,076 */ 11, 0xFF,
  /* ABS: 003 Pixels @ 199,076 */ 0, 3, 0xEB, 0x17, 0xCD,
  /* RLE: 046 Pixels @ 202,076 */ 46, 0xFF,
  /* ABS: 003 Pixels @ 248,076 */ 0, 3, 0xDD, 0x2B, 0xCC,
  /* RLE: 010 Pixels @ 251,076 */ 10, 0xFF,
  /* ABS: 026 Pixels @ 261,076 */ 0, 26, 0xF5, 0x57, 0x87, 0xFD, 0xFF, 0x5E, 0x76, 0xA7, 0x3F, 0xE4, 0xFB, 0x96, 0x28, 0xDF, 0xFF, 0xDC, 0x3B, 0x84, 0xFE, 0xC2, 0x22, 0xE9, 0xFE, 0x8B, 0x51, 0xFD,
  /* RLE: 034 Pixels @ 287,076 */ 34, 0xFF,
  /* ABS: 026 Pixels @ 021,077 */ 0, 26, 0xFC, 0x60, 0x0B, 0x56, 0x60, 0x5B, 0x46, 0x35, 0x28, 0x23, 0x2C, 0x3A, 0x5B, 0x5F, 0x86, 0xE4, 0xA2, 0x27, 0xF6, 0xFF, 0xFF, 0xFF, 0xDC, 0x31, 0x7E, 0xF3,
  /* RLE: 009 Pixels @ 047,077 */ 9, 0xFF,
  /* ABS: 007 Pixels @ 056,077 */ 0, 7, 0xF8, 0x60, 0x5A, 0xE0, 0x44, 0x5E, 0xE7,
  /* RLE: 012 Pixels @ 063,077 */ 12, 0xFF,
  /* ABS: 004 Pixels @ 075,077 */ 0, 4, 0xED, 0x68, 0x33, 0xD8,
  /* RLE: 008 Pixels @ 079,077 */ 8, 0xFF,
  /* ABS: 005 Pixels @ 087,077 */ 0, 5, 0xF2, 0x7D, 0x24, 0xB4, 0xFE,
  /* RLE: 056 Pixels @ 092,077 */ 56, 0xFF,
  /* ABS: 027 Pixels @ 148,077 */ 0, 27, 0xFE, 0xF5, 0xE6, 0xCE, 0x66, 0x04, 0x21, 0x30, 0x1F, 0x1F, 0x1F, 0x31, 0x41, 0x68, 0x9C, 0xD3, 0xC0, 0x47, 0x32, 0xB6, 0xFC, 0xFF, 0xCC, 0x18, 0x61, 0xE4, 0xFA,
  /* RLE: 024 Pixels @ 175,077 */ 24, 0xFF,
  /* ABS: 003 Pixels @ 199,077 */ 0, 3, 0xFC, 0x1D, 0xB6,
  /* RLE: 046 Pixels @ 202,077 */ 46, 0xFF,
  /* ABS: 003 Pixels @ 248,077 */ 0, 3, 0xC6, 0x13, 0xF3,
  /* RLE: 010 Pixels @ 251,077 */ 10, 0xFF,
  /* ABS: 026 Pixels @ 261,077 */ 0, 26, 0xC2, 0x29, 0xE5, 0xFF, 0xDC, 0x26, 0xBE, 0x36, 0x22, 0xC2, 0xFF, 0xF6, 0x6C, 0x59, 0xF2, 0xFF, 0xC0, 0x24, 0xD2, 0xEC, 0x39, 0xB4, 0xFE, 0x90, 0x50, 0xFD,
  /* RLE: 034 Pixels @ 287,077 */ 34, 0xFF,
  /* ABS: 025 Pixels @ 021,078 */ 0, 25, 0xD2, 0x23, 0x59, 0xF0, 0xC4, 0xCF, 0xED, 0xE4, 0xDC, 0xD6, 0xC7, 0xAF, 0x96, 0x8D, 0x40, 0x4B, 0x96, 0x26, 0xF6, 0xFF, 0xFF, 0xFB, 0x6F, 0x4A, 0xEF,
  /* RLE: 011 Pixels @ 046,078 */ 11, 0xFF,
  /* ABS: 005 Pixels @ 057,078 */ 0, 5, 0x87, 0x43, 0x71, 0x45, 0xE5,
  /* RLE: 014 Pixels @ 062,078 */ 14, 0xFF,
  /* ABS: 004 Pixels @ 076,078 */ 0, 4, 0xEE, 0x3B, 0x89, 0xFE,
  /* RLE: 006 Pixels @ 080,078 */ 6, 0xFF,
  /* ABS: 089 Pixels @ 086,078 */ 0, 89, 0xF6, 0x74, 0x30, 0xBE, 0xFC, 0xFF, 0xF9, 0xE6, 0xC3, 0xA4, 0x9D, 0xA1, 0xB5, 0xB9, 0xBA, 0xC7, 0xD2, 0xDA, 0xE0, 0xE0, 0xE3, 0xE9, 0xEB, 0xEA, 0xEA, 0xEC, 0xEF, 0xF0, 0xF0, 0xF1, 0xF1, 0xF2, 0xF2, 0xF2, 0xF3,
        0xF4, 0xF5, 0xF4, 0xF6, 0xF6, 0xF5, 0xF3, 0xF3, 0xF2, 0xF2, 0xF1, 0xF1, 0xF1, 0xF0, 0xED, 0xEB, 0xEA, 0xE7, 0xE2, 0xE0, 0xD5, 0xCE, 0xBF, 0xB3, 0x9F, 0x97, 0x82, 0x65, 0x46, 0x3B, 0x21, 0x2D, 0x82, 0xB9, 0xCD, 0xCF, 0xCE, 0xCB, 0xC7, 0xAE, 0x76,
        0x48, 0x38, 0x5A, 0x9F, 0x5F, 0x2F, 0x9B, 0xF3, 0xFF, 0x9C, 0x2E, 0xBF, 0xFE,
  /* RLE: 004 Pixels @ 175,078 */ 4, 0xFF,
  /* ABS: 007 Pixels @ 179,078 */ 0, 7, 0xF4, 0xE1, 0xCC, 0xB8, 0xA6, 0xB6, 0xF4,
  /* RLE: 013 Pixels @ 186,078 */ 13, 0xFF,
  /* ABS: 003 Pixels @ 199,078 */ 0, 3, 0xFE, 0x2B, 0x9C,
  /* RLE: 046 Pixels @ 202,078 */ 46, 0xFF,
  /* ABS: 003 Pixels @ 248,078 */ 0, 3, 0xA7, 0x21, 0xFC,
  /* RLE: 010 Pixels @ 251,078 */ 10, 0xFF,
  /* ABS: 026 Pixels @ 261,078 */ 0, 26, 0x7E, 0x58, 0xFF, 0xFE, 0x9E, 0x50, 0xA0, 0x3B, 0x69, 0x37, 0xE0, 0xFF, 0xD9, 0x2F, 0xAC, 0xFF, 0xF5, 0x66, 0x69, 0xEF, 0x64, 0x71, 0xFE, 0xAB, 0x40, 0xF4,
  /* RLE: 033 Pixels @ 287,078 */ 33, 0xFF,
  /* ABS: 008 Pixels @ 020,079 */ 0, 8, 0xFE, 0x7F, 0x12, 0xAE, 0xE3, 0x37, 0x85, 0xFC,
  /* RLE: 007 Pixels @ 028,079 */ 7, 0xFF,
  /* ABS: 010 Pixels @ 035,079 */ 0, 10, 0xD7, 0x2F, 0x36, 0x24, 0xE9, 0xFF, 0xFF, 0xD3, 0x2C, 0xAC,
  /* RLE: 011 Pixels @ 045,079 */ 11, 0xFF,
  /* ABS: 005 Pixels @ 056,079 */ 0, 5, 0xFE, 0x84, 0x11, 0x1A, 0xB6,
  /* RLE: 016 Pixels @ 061,079 */ 16, 0xFF,
  /* ABS: 003 Pixels @ 077,079 */ 0, 3, 0x60, 0x65, 0xFE,
  /* RLE: 005 Pixels @ 080,079 */ 5, 0xFF,
  /* ABS: 101 Pixels @ 085,079 */ 0, 101, 0xF4, 0x7E, 0x31, 0xC4, 0xFF, 0xFC, 0xCD, 0x6F, 0x32, 0x26, 0x48, 0x28, 0x00, 0x13, 0x2B, 0x10, 0x05, 0x0D, 0x30, 0x2E, 0x2F, 0x32, 0x37, 0x39, 0x38, 0x39, 0x3D, 0x48, 0x4A, 0x4A, 0x4B, 0x4C, 0x4E, 0x4F, 0x4F,
        0x51, 0x54, 0x59, 0x55, 0x5C, 0x5A, 0x58, 0x52, 0x51, 0x4F, 0x4E, 0x4A, 0x4B, 0x4D, 0x48, 0x3F, 0x3A, 0x36, 0x31, 0x2E, 0x30, 0x2D, 0x2D, 0x3F, 0x47, 0x5A, 0x68, 0x84, 0x94, 0xAA, 0x8B, 0x21, 0xBE, 0xEA, 0xC1, 0x86, 0x66, 0x5F, 0x5F, 0x65, 0x88,
        0xC2, 0xED, 0xD0, 0x7B, 0x23, 0x56, 0x71, 0x1E, 0x7B, 0xF3, 0xF5, 0x66, 0x41, 0xF2, 0xFF, 0xFF, 0xFF, 0xFC, 0x61, 0x30, 0x2E, 0x3E, 0x50, 0x22, 0x9B,
  /* RLE: 014 Pixels @ 186,079 */ 14, 0xFF,
  /* ABS: 002 Pixels @ 200,079 */ 0, 2, 0x46, 0x7E,
  /* RLE: 046 Pixels @ 202,079 */ 46, 0xFF,
  /* ABS: 002 Pixels @ 248,079 */ 0, 2, 0x86, 0x44,
  /* RLE: 010 Pixels @ 250,079 */ 10, 0xFF,
  /* ABS: 027 Pixels @ 260,079 */ 0, 27, 0xF1, 0x35, 0xAE, 0xFF, 0xF4, 0x55, 0x86, 0x4F, 0x93, 0xEE, 0x63, 0x56, 0xEC, 0xFF, 0x8A, 0x3C, 0xF5, 0xFF, 0xD2, 0x23, 0xD5, 0x9E, 0x44, 0xF1, 0xB0, 0x39, 0xEE,
  /* RLE: 033 Pixels @ 287,079 */ 33, 0xFF,
  /* ABS: 007 Pixels @ 020,080 */ 0, 7, 0xFA, 0x2A, 0x33, 0xED, 0xCA, 0x26, 0xCB,
  /* RLE: 004 Pixels @ 027,080 */ 4, 0xFF,
  /* ABS: 014 Pixels @ 031,080 */ 0, 14, 0xAE, 0x5F, 0xA4, 0xF4, 0xFE, 0x98, 0x04, 0x16, 0xDB, 0xFF, 0xFF, 0xA3, 0x30, 0xE8,
  /* RLE: 011 Pixels @ 045,080 */ 11, 0xFF,
  /* ABS: 005 Pixels @ 056,080 */ 0, 5, 0xF9, 0x68, 0x01, 0x3D, 0xF4,
  /* RLE: 016 Pixels @ 061,080 */ 16, 0xFF,
  /* ABS: 003 Pixels @ 077,080 */ 0, 3, 0x57, 0x70, 0xFE,
  /* RLE: 004 Pixels @ 080,080 */ 4, 0xFF,
  /* ABS: 103 Pixels @ 084,080 */ 0, 103, 0xF9, 0x84, 0x2A, 0xD5, 0xFC, 0xD7, 0x69, 0x2F, 0x73, 0xC4, 0xE5, 0x81, 0x2E, 0x8E, 0xE1, 0xF1, 0xD9, 0x78, 0x18, 0x8C, 0xE7, 0xEB, 0xE8, 0xE3, 0xE1, 0xA5, 0x66, 0xD1, 0xD7, 0xC6, 0xBE, 0xBE, 0xBE, 0xBB, 0x77,
        0x2E, 0xA9, 0xAC, 0xA9, 0xA4, 0xA6, 0xA7, 0xA4, 0xAC, 0xB6, 0xB7, 0xB7, 0xB0, 0x8D, 0x1A, 0xB8, 0xD4, 0xD6, 0xE1, 0xE3, 0xE8, 0xEB, 0xF0, 0xF1, 0xF4, 0xF5, 0xF8, 0xFA, 0xFE, 0xFE, 0xF1, 0x2E, 0x49, 0x6F, 0x34, 0x49, 0x68, 0x86, 0x8C, 0x8F, 0x7D,
        0x5D, 0x40, 0x30, 0x7A, 0xCC, 0xE1, 0x6A, 0x23, 0x55, 0x25, 0x65, 0xF5, 0xDD, 0x2D, 0x99, 0xFD, 0xFF, 0xFF, 0xFB, 0x21, 0x9C, 0xF1, 0xF4, 0xF6, 0xA1, 0x2C, 0xCA,
  /* RLE: 013 Pixels @ 187,080 */ 13, 0xFF,
  /* ABS: 002 Pixels @ 200,080 */ 0, 2, 0x53, 0x6E,
  /* RLE: 046 Pixels @ 202,080 */ 46, 0xFF,
  /* ABS: 002 Pixels @ 248,080 */ 0, 2, 0x57, 0x73,
  /* RLE: 010 Pixels @ 250,080 */ 10, 0xFF,
  /* ABS: 027 Pixels @ 260,080 */ 0, 27, 0xB5, 0x40, 0xE5, 0xFF, 0xE1, 0x2C, 0x8B, 0x33, 0xE3, 0xFF, 0xEA, 0x36, 0x7D, 0xFC, 0xDE, 0x39, 0xAE, 0xFF, 0xFD, 0x4A, 0x8D, 0xD3, 0x30, 0xCF, 0xC5, 0x40, 0xED,
  /* RLE: 033 Pixels @ 287,080 */ 33, 0xFF,
  /* ABS: 025 Pixels @ 020,081 */ 0, 25, 0xCF, 0x04, 0x74, 0xFF, 0xB8, 0x20, 0xEE, 0xFE, 0xFA, 0xFF, 0xFF, 0xDD, 0x8B, 0x32, 0x87, 0xF8, 0xDA, 0x0B, 0x0E, 0xBF, 0xFF, 0xFD, 0x76, 0x54, 0xFE,
  /* RLE: 011 Pixels @ 045,081 */ 11, 0xFF,
  /* ABS: 004 Pixels @ 056,081 */ 0, 4, 0xEE, 0x48, 0x01, 0x85,
  /* RLE: 016 Pixels @ 060,081 */ 16, 0xFF,
  /* ABS: 003 Pixels @ 076,081 */ 0, 3, 0xF1, 0x36, 0x9B,
  /* RLE: 004 Pixels @ 079,081 */ 4, 0xFF,
  /* ABS: 029 Pixels @ 083,081 */ 0, 29, 0xFE, 0xB2, 0x32, 0xB6, 0xFA, 0xB1, 0x31, 0x63, 0xCA, 0xFB, 0xF6, 0x82, 0x33, 0xB3, 0xFE, 0xFF, 0xFF, 0xFF, 0xF7, 0x9A, 0x2A, 0xC2, 0xFF, 0xFF, 0xFF, 0xED, 0x4D, 0x77, 0xF9,
  /* RLE: 006 Pixels @ 112,081 */ 6, 0xFF,
  /* ABS: 003 Pixels @ 118,081 */ 0, 3, 0xDC, 0x34, 0x94,
  /* RLE: 011 Pixels @ 121,081 */ 11, 0xFF,
  /* ABS: 002 Pixels @ 132,081 */ 0, 2, 0x8C, 0x45,
  /* RLE: 014 Pixels @ 134,081 */ 14, 0xFF,
  /* ABS: 040 Pixels @ 148,081 */ 0, 40, 0xFC, 0x91, 0x03, 0x1D, 0x6F, 0xA9, 0xA3, 0x8D, 0x8A, 0x89, 0x89, 0x7E, 0x84, 0x9C, 0x9F, 0x49, 0x31, 0x91, 0xEB, 0xA3, 0x27, 0x3A, 0x1C, 0x83, 0xF2, 0x88, 0x3D, 0xE3, 0xFF, 0xFF, 0xFF, 0x5A, 0x60, 0xBE, 0xAC,
        0x94, 0x5A, 0x19, 0xA1, 0xFE,
  /* RLE: 012 Pixels @ 188,081 */ 12, 0xFF,
  /* ABS: 002 Pixels @ 200,081 */ 0, 2, 0x65, 0x59,
  /* RLE: 045 Pixels @ 202,081 */ 45, 0xFF,
  /* ABS: 003 Pixels @ 247,081 */ 0, 3, 0xF2, 0x34, 0xA8,
  /* RLE: 009 Pixels @ 250,081 */ 9, 0xFF,
  /* ABS: 028 Pixels @ 259,081 */ 0, 28, 0xF9, 0x6B, 0x6D, 0xFE, 0xFF, 0xC6, 0x2B, 0x71, 0x27, 0xF7, 0xFF, 0xFF, 0xB8, 0x34, 0xCB, 0xFC, 0x80, 0x5D, 0xF4, 0xFF, 0x89, 0x4B, 0xF2, 0x2E, 0xAC, 0xC7, 0x3B, 0xE2,
  /* RLE: 032 Pixels @ 287,081 */ 32, 0xFF,
  /* ABS: 025 Pixels @ 019,082 */ 0, 25, 0xFE, 0x83, 0x07, 0xB1, 0xFF, 0xAA, 0x26, 0xF9, 0xE1, 0x6C, 0xED, 0xFF, 0xFF, 0xFF, 0xCD, 0x1E, 0xC9, 0xFC, 0x23, 0x05, 0x8F, 0xFF, 0xFC, 0x4C, 0x83,
  /* RLE: 012 Pixels @ 044,082 */ 12, 0xFF,
  /* ABS: 004 Pixels @ 056,082 */ 0, 4, 0xDF, 0x2A, 0x0A, 0xBE,
  /* RLE: 016 Pixels @ 060,082 */ 16, 0xFF,
  /* ABS: 003 Pixels @ 076,082 */ 0, 3, 0xBF, 0x35, 0xD7,
  /* RLE: 004 Pixels @ 079,082 */ 4, 0xFF,
  /* ABS: 013 Pixels @ 083,082 */ 0, 13, 0xFE, 0xD3, 0xC3, 0xF8, 0x82, 0x2B, 0xA1, 0xF9, 0xFF, 0xFF, 0xA7, 0x29, 0xD4,
  /* RLE: 006 Pixels @ 096,082 */ 6, 0xFF,
  /* ABS: 009 Pixels @ 102,082 */ 0, 9, 0xFE, 0x67, 0x48, 0xFC, 0xFF, 0xFF, 0xC0, 0x2A, 0xD3,
  /* RLE: 008 Pixels @ 111,082 */ 8, 0xFF,
  /* ABS: 003 Pixels @ 119,082 */ 0, 3, 0x9E, 0x22, 0xF8,
  /* RLE: 009 Pixels @ 122,082 */ 9, 0xFF,
  /* ABS: 003 Pixels @ 131,082 */ 0, 3, 0xF5, 0x3B, 0xA1,
  /* RLE: 014 Pixels @ 134,082 */ 14, 0xFF,
  /* ABS: 039 Pixels @ 148,082 */ 0, 39, 0xD0, 0x23, 0x60, 0x9D, 0x8B, 0x92, 0xBA, 0xDF, 0xDC, 0xD2, 0xD6, 0xE4, 0xDF, 0xA1, 0x6F, 0x84, 0x82, 0x2A, 0x61, 0xDF, 0xC0, 0x2D, 0x26, 0x17, 0x96, 0xE5, 0x24, 0xA2, 0xFF, 0xFF, 0xFF, 0xCE, 0x51, 0x4C, 0x65,
        0x6F, 0x91, 0xC4, 0xF8,
  /* RLE: 013 Pixels @ 187,082 */ 13, 0xFF,
  /* ABS: 002 Pixels @ 200,082 */ 0, 2, 0x72, 0x50,
  /* RLE: 045 Pixels @ 202,082 */ 45, 0xFF,
  /* ABS: 003 Pixels @ 247,082 */ 0, 3, 0xC9, 0x2C, 0xC4,
  /* RLE: 009 Pixels @ 250,082 */ 9, 0xFF,
  /* ABS: 028 Pixels @ 259,082 */ 0, 28, 0xE3, 0x28, 0xBB, 0xFF, 0xFF, 0x9E, 0x44, 0x3B, 0x0C, 0xBB, 0xFF, 0xFF, 0xF0, 0x3D, 0x9A, 0xFE, 0xCF, 0x21, 0xDB, 0xFF, 0xC4, 0x31, 0xD3, 0x61, 0x7C, 0xCC, 0x3B, 0xDB,
  /* RLE: 032 Pixels @ 287,082 */ 32, 0xFF,
  /* ABS: 025 Pixels @ 019,083 */ 0, 25, 0xEB, 0x42, 0x25, 0xDB, 0xFF, 0xAB, 0x22, 0xF7, 0xB4, 0x21, 0xF4, 0xFF, 0xFF, 0xFF, 0xF9, 0x4F, 0x7F, 0xFE, 0x40, 0x00, 0x65, 0xF8, 0xFB, 0x33, 0x99,
  /* RLE: 012 Pixels @ 044,083 */ 12, 0xFF,
  /* ABS: 004 Pixels @ 056,083 */ 0, 4, 0xD4, 0x19, 0x2A, 0xDA,
  /* RLE: 015 Pixels @ 060,083 */ 15, 0xFF,
  /* ABS: 004 Pixels @ 075,083 */ 0, 4, 0xFD, 0x85, 0x4C, 0xF8,
  /* RLE: 006 Pixels @ 079,083 */ 6, 0xFF,
  /* ABS: 011 Pixels @ 085,083 */ 0, 11, 0xEF, 0x7A, 0x38, 0xB8, 0xFD, 0xFF, 0xFF, 0xEA, 0x3F, 0x95, 0xFE,
  /* RLE: 007 Pixels @ 096,083 */ 7, 0xFF,
  /* ABS: 019 Pixels @ 103,083 */ 0, 19, 0xB9, 0x1E, 0xDD, 0xFF, 0xFF, 0x90, 0x3C, 0xFB, 0xFD, 0xF4, 0xEC, 0xF1, 0xFD, 0xFF, 0xFF, 0xFF, 0xD9, 0x2B, 0xC8,
  /* RLE: 009 Pixels @ 122,083 */ 9, 0xFF,
  /* ABS: 003 Pixels @ 131,083 */ 0, 3, 0xBF, 0x34, 0xD5,
  /* RLE: 013 Pixels @ 134,083 */ 13, 0xFF,
  /* ABS: 037 Pixels @ 147,083 */ 0, 37, 0xFC, 0x67, 0x34, 0x86, 0x74, 0x9A, 0x90, 0x7F, 0x76, 0x7C, 0x7A, 0x68, 0x4D, 0x45, 0x6E, 0xA0, 0xA7, 0x6C, 0x8B, 0x44, 0x4B, 0xDE, 0xC0, 0x2B, 0x25, 0x28, 0xC1, 0x72, 0x47, 0xFB, 0xFF, 0xFF, 0xFE, 0xF0, 0xF1,
        0xF9, 0xFD,
  /* RLE: 016 Pixels @ 184,083 */ 16, 0xFF,
  /* ABS: 003 Pixels @ 200,083 */ 0, 3, 0x75, 0x32, 0xF9,
  /* RLE: 043 Pixels @ 203,083 */ 43, 0xFF,
  /* ABS: 004 Pixels @ 246,083 */ 0, 4, 0xFE, 0x98, 0x43, 0xF0,
  /* RLE: 009 Pixels @ 250,083 */ 9, 0xFF,
  /* ABS: 028 Pixels @ 259,083 */ 0, 28, 0xB4, 0x2E, 0xEA, 0xFF, 0xFF, 0x89, 0x43, 0x2B, 0x44, 0x74, 0xF9, 0xFF, 0x96, 0x40, 0xE1, 0xFF, 0xF3, 0x3C, 0xA9, 0xFF, 0xEA, 0x3D, 0xAE, 0x8C, 0x46, 0xD7, 0x38, 0xCB,
  /* RLE: 032 Pixels @ 287,083 */ 32, 0xFF,
  /* ABS: 025 Pixels @ 019,084 */ 0, 25, 0xD6, 0x21, 0x4C, 0xEF, 0xFF, 0xBB, 0x1D, 0xDA, 0x94, 0x46, 0xFD, 0xFF, 0xFF, 0xFF, 0xFE, 0x94, 0x3B, 0xF3, 0x5C, 0x00, 0x35, 0xED, 0xF8, 0x22, 0xB1,
  /* RLE: 012 Pixels @ 044,084 */ 12, 0xFF,
  /* ABS: 004 Pixels @ 056,084 */ 0, 4, 0xB0, 0x05, 0x3D, 0xE9,
  /* RLE: 015 Pixels @ 060,084 */ 15, 0xFF,
  /* ABS: 003 Pixels @ 075,084 */ 0, 3, 0xF4, 0x37, 0x93,
  /* RLE: 006 Pixels @ 078,084 */ 6, 0xFF,
  /* ABS: 004 Pixels @ 084,084 */ 0, 4, 0xFD, 0x7F, 0x2B, 0xCB,
  /* RLE: 004 Pixels @ 088,084 */ 4, 0xFF,
  /* ABS: 030 Pixels @ 092,084 */ 0, 30, 0xC2, 0x31, 0xD3, 0xFC, 0xE7, 0xFF, 0xFF, 0xFF, 0xED, 0xA3, 0xCF, 0xD3, 0x2D, 0xD0, 0xFF, 0xFF, 0x83, 0x3B, 0xAC, 0x76, 0x51, 0x43, 0x4D, 0x94, 0xFB, 0xFF, 0xFF, 0xEB, 0x42, 0xA7,
  /* RLE: 008 Pixels @ 122,084 */ 8, 0xFF,
  /* ABS: 004 Pixels @ 130,084 */ 0, 4, 0xF8, 0x6A, 0x64, 0xFA,
  /* RLE: 013 Pixels @ 134,084 */ 13, 0xFF,
  /* ABS: 030 Pixels @ 147,084 */ 0, 30, 0xD4, 0x1A, 0x3B, 0xC6, 0xA7, 0xAF, 0xCD, 0xEB, 0xFB, 0xFE, 0xFF, 0xFB, 0xE4, 0xBB, 0x6A, 0x1A, 0x38, 0x86, 0x7F, 0x6E, 0x4B, 0x4A, 0xE2, 0xB3, 0x15, 0x2B, 0x38, 0xB0, 0x22, 0xD7,
  /* RLE: 023 Pixels @ 177,084 */ 23, 0xFF,
  /* ABS: 003 Pixels @ 200,084 */ 0, 3, 0x74, 0x2F, 0xF8,
  /* RLE: 043 Pixels @ 203,084 */ 43, 0xFF,
  /* ABS: 003 Pixels @ 246,084 */ 0, 3, 0xF9, 0x5F, 0x6B,
  /* RLE: 009 Pixels @ 249,084 */ 9, 0xFF,
  /* ABS: 029 Pixels @ 258,084 */ 0, 29, 0xFD, 0x6E, 0x67, 0xF8, 0xFF, 0xFE, 0x5D, 0x3E, 0x4D, 0xB7, 0x22, 0xE1, 0xF0, 0x2E, 0xAE, 0xFF, 0xFF, 0xFB, 0x71, 0x64, 0xFE, 0xFB, 0x56, 0x8D, 0xAE, 0x29, 0xDA, 0x39, 0xC9,
  /* RLE: 032 Pixels @ 287,084 */ 32, 0xFF,
  /* ABS: 011 Pixels @ 019,085 */ 0, 11, 0xB7, 0x0B, 0x8D, 0xFE, 0xFF, 0xE3, 0x3C, 0x81, 0xA2, 0x2A, 0xF8,
  /* RLE: 004 Pixels @ 030,085 */ 4, 0xFF,
  /* ABS: 010 Pixels @ 034,085 */ 0, 10, 0xB3, 0x37, 0xEB, 0x94, 0x05, 0x07, 0xC3, 0xF5, 0x1A, 0xC0,
  /* RLE: 012 Pixels @ 044,085 */ 12, 0xFF,
  /* ABS: 004 Pixels @ 056,085 */ 0, 4, 0x82, 0x00, 0x56, 0xF6,
  /* RLE: 015 Pixels @ 060,085 */ 15, 0xFF,
  /* ABS: 003 Pixels @ 075,085 */ 0, 3, 0xC7, 0x22, 0xDD,
  /* RLE: 005 Pixels @ 078,085 */ 5, 0xFF,
  /* ABS: 004 Pixels @ 083,085 */ 0, 4, 0xFD, 0x8D, 0x38, 0xD0,
  /* RLE: 005 Pixels @ 087,085 */ 5, 0xFF,
  /* ABS: 030 Pixels @ 092,085 */ 0, 30, 0xB0, 0x36, 0xF1, 0xDB, 0x3F, 0x49, 0x71, 0x5D, 0x27, 0x4D, 0xC8, 0xC9, 0x26, 0xCF, 0xFF, 0xFF, 0x96, 0x0D, 0x53, 0x89, 0xB4, 0xCA, 0x9B, 0x09, 0xE8, 0xFF, 0xFF, 0xE6, 0x3A, 0xB1,
  /* RLE: 008 Pixels @ 122,085 */ 8, 0xFF,
  /* ABS: 003 Pixels @ 130,085 */ 0, 3, 0xD7, 0x25, 0xC5,
  /* RLE: 013 Pixels @ 133,085 */ 13, 0xFF,
  /* ABS: 004 Pixels @ 146,085 */ 0, 4, 0xF9, 0x6B, 0x42, 0xE7,
  /* RLE: 011 Pixels @ 150,085 */ 11, 0xFF,
  /* ABS: 017 Pixels @ 161,085 */ 0, 17, 0xFE, 0xE8, 0x68, 0x1C, 0x51, 0x73, 0x5F, 0x3D, 0x50, 0xE7, 0x80, 0x23, 0x24, 0x67, 0x44, 0x8B, 0xFD,
  /* RLE: 022 Pixels @ 178,085 */ 22, 0xFF,
  /* ABS: 003 Pixels @ 200,085 */ 0, 3, 0x76, 0x30, 0xF9,
  /* RLE: 043 Pixels @ 203,085 */ 43, 0xFF,
  /* ABS: 003 Pixels @ 246,085 */ 0, 3, 0xE9, 0x23, 0xB4,
  /* RLE: 009 Pixels @ 249,085 */ 9, 0xFF,
  /* ABS: 029 Pixels @ 258,085 */ 0, 29, 0xE5, 0x3A, 0xAC, 0xFF, 0xFF, 0xF8, 0x39, 0x0B, 0x6A, 0xF3, 0x5A, 0x4A, 0x55, 0x5C, 0xF1, 0xFF, 0xFF, 0xFF, 0xB8, 0x43, 0xF3, 0xFF, 0x8B, 0x60, 0xCD, 0x2D, 0xCA, 0x38, 0xBD,
  /* RLE: 032 Pixels @ 287,085 */ 32, 0xFF,
  /* ABS: 025 Pixels @ 019,086 */ 0, 25, 0x86, 0x03, 0xC3, 0xFF, 0xFF, 0xFD, 0x9F, 0x1E, 0x97, 0x25, 0xA5, 0xF6, 0xFF, 0xFF, 0xF8, 0x7E, 0x56, 0xFB, 0xBA, 0x17, 0x17, 0x86, 0xF6, 0x1D, 0xBA,
  /* RLE: 011 Pixels @ 044,086 */ 11, 0xFF,
  /* ABS: 005 Pixels @ 055,086 */ 0, 5, 0xFE, 0x56, 0x00, 0x71, 0xFC,
  /* RLE: 014 Pixels @ 060,086 */ 14, 0xFF,
  /* ABS: 004 Pixels @ 074,086 */ 0, 4, 0xF9, 0x6E, 0x61, 0xF5,
  /* RLE: 004 Pixels @ 078,086 */ 4, 0xFF,
  /* ABS: 004 Pixels @ 082,086 */ 0, 4, 0xFE, 0xBB, 0x29, 0xB3,
  /* RLE: 006 Pixels @ 086,086 */ 6, 0xFF,
  /* ABS: 030 Pixels @ 092,086 */ 0, 30, 0xBE, 0x2F, 0xD2, 0xFA, 0xD6, 0x97, 0x76, 0x92, 0xCA, 0xED, 0xFF, 0x92, 0x2F, 0xF7, 0xFF, 0xFF, 0xC3, 0x2B, 0xC6, 0xFA, 0xEC, 0xBB, 0x5C, 0x3E, 0xEF, 0xFF, 0xFF, 0xD8, 0x2A, 0xD0,
  /* RLE: 007 Pixels @ 122,086 */ 7, 0xFF,
  /* ABS: 004 Pixels @ 129,086 */ 0, 4, 0xFC, 0x77, 0x56, 0xF5,
  /* RLE: 013 Pixels @ 133,086 */ 13, 0xFF,
  /* ABS: 003 Pixels @ 146,086 */ 0, 3, 0xE1, 0x26, 0xB3,
  /* RLE: 004 Pixels @ 149,086 */ 4, 0xFF,
  /* ABS: 005 Pixels @ 153,086 */ 0, 5, 0xFC, 0xF8, 0xF7, 0xF9, 0xFE,
  /* RLE: 005 Pixels @ 158,086 */ 5, 0xFF,
  /* ABS: 015 Pixels @ 163,086 */ 0, 15, 0xF3, 0x97, 0x4B, 0x57, 0x62, 0x51, 0x2D, 0x70, 0xE2, 0x41, 0x36, 0x26, 0x48, 0x50, 0xF2,
  /* RLE: 022 Pixels @ 178,086 */ 22, 0xFF,
  /* ABS: 003 Pixels @ 200,086 */ 0, 3, 0x72, 0x4D, 0xFE,
  /* RLE: 043 Pixels @ 203,086 */ 43, 0xFF,
  /* ABS: 003 Pixels @ 246,086 */ 0, 3, 0xBF, 0x25, 0xE2,
  /* RLE: 009 Pixels @ 249,086 */ 9, 0xFF,
  /* ABS: 029 Pixels @ 258,086 */ 0, 29, 0xBF, 0x32, 0xE1, 0xFF, 0xFF, 0xEF, 0x30, 0x02, 0x98, 0xFE, 0xDD, 0x7D, 0x83, 0xE2, 0xFF, 0xED, 0xD6, 0xFF, 0xDA, 0x3A, 0xD0, 0xFF, 0xB1, 0x39, 0xD8, 0x3E, 0xA7, 0x3A, 0xB7,
  /* RLE: 031 Pixels @ 287,086 */ 31, 0xFF,
  /* ABS: 026 Pixels @ 018,087 */ 0, 26, 0xDC, 0x3C, 0x0E, 0xEF, 0xFF, 0xFF, 0xFF, 0xFA, 0xA7, 0xD3, 0xA4, 0x26, 0x5E, 0xA2, 0xB3, 0x77, 0x2C, 0xC1, 0xFF, 0xDE, 0x30, 0x25, 0x38, 0xE3, 0x25, 0xA3,
  /* RLE: 011 Pixels @ 044,087 */ 11, 0xFF,
  /* ABS: 005 Pixels @ 055,087 */ 0, 5, 0xE6, 0x29, 0x00, 0x7D, 0xFE,
  /* RLE: 014 Pixels @ 060,087 */ 14, 0xFF,
  /* ABS: 003 Pixels @ 074,087 */ 0, 3, 0xD0, 0x2A, 0xC0,
  /* RLE: 005 Pixels @ 077,087 */ 5, 0xFF,
  /* ABS: 004 Pixels @ 082,087 */ 0, 4, 0xDC, 0x38, 0x92, 0xFA,
  /* RLE: 006 Pixels @ 086,087 */ 6, 0xFF,
  /* ABS: 004 Pixels @ 092,087 */ 0, 4, 0xEB, 0x3B, 0x83, 0xFC,
  /* RLE: 006 Pixels @ 096,087 */ 6, 0xFF,
  /* ABS: 020 Pixels @ 102,087 */ 0, 20, 0xFA, 0x3E, 0x7B, 0xFF, 0xFF, 0xFF, 0xF0, 0x48, 0x5A, 0x76, 0x3E, 0x34, 0x7D, 0xE0, 0xFF, 0xFF, 0xFF, 0xA3, 0x2F, 0xF7,
  /* RLE: 007 Pixels @ 122,087 */ 7, 0xFF,
  /* ABS: 003 Pixels @ 129,087 */ 0, 3, 0xCD, 0x2E, 0xBD,
  /* RLE: 014 Pixels @ 132,087 */ 14, 0xFF,
  /* ABS: 013 Pixels @ 146,087 */ 0, 13, 0x90, 0x3F, 0xED, 0xFF, 0xFD, 0xDC, 0xA1, 0x72, 0x61, 0x5F, 0x65, 0x95, 0xE6,
  /* RLE: 005 Pixels @ 159,087 */ 5, 0xFF,
  /* ABS: 014 Pixels @ 164,087 */ 0, 14, 0xFB, 0xAD, 0x50, 0x4D, 0x69, 0x49, 0x18, 0xA7, 0xAC, 0x1E, 0x35, 0x13, 0x21, 0xDF,
  /* RLE: 022 Pixels @ 178,087 */ 22, 0xFF,
  /* ABS: 002 Pixels @ 200,087 */ 0, 2, 0x69, 0x53,
  /* RLE: 043 Pixels @ 202,087 */ 43, 0xFF,
  /* ABS: 004 Pixels @ 245,087 */ 0, 4, 0xFC, 0x72, 0x62, 0xF7,
  /* RLE: 009 Pixels @ 249,087 */ 9, 0xFF,
  /* ABS: 029 Pixels @ 258,087 */ 0, 29, 0x84, 0x52, 0xFF, 0xFF, 0xFF, 0xE5, 0x27, 0x01, 0xBB, 0xFD, 0xEB, 0xF6, 0xFF, 0xFF, 0xF5, 0x6C, 0x74, 0xFE, 0xF2, 0x36, 0xBA, 0xFF, 0xCF, 0x24, 0xE3, 0x4F, 0x91, 0x3D, 0xB0,
  /* RLE: 029 Pixels @ 287,087 */ 29, 0xFF,
  /* ABS: 029 Pixels @ 016,088 */ 0, 29, 0xF3, 0xA1, 0x32, 0x47, 0x1A, 0x3E, 0x64, 0x85, 0xA0, 0xC1, 0xD4, 0xE0, 0xE7, 0xCF, 0x8D, 0x65, 0x58, 0x76, 0xDA, 0xFD, 0xFF, 0xFB, 0x62, 0x2A, 0x1D, 0xA9, 0x55, 0x69, 0xFD,
  /* RLE: 010 Pixels @ 045,088 */ 10, 0xFF,
  /* ABS: 004 Pixels @ 055,088 */ 0, 4, 0xA8, 0x23, 0x20, 0x8A,
  /* RLE: 014 Pixels @ 059,088 */ 14, 0xFF,
  /* ABS: 004 Pixels @ 073,088 */ 0, 4, 0xFC, 0x65, 0x51, 0xFB,
  /* RLE: 004 Pixels @ 077,088 */ 4, 0xFF,
  /* ABS: 004 Pixels @ 081,088 */ 0, 4, 0xF8, 0x5C, 0x61, 0xFA,
  /* RLE: 007 Pixels @ 085,088 */ 7, 0xFF,
  /* ABS: 005 Pixels @ 092,088 */ 0, 5, 0xFE, 0xA7, 0x1D, 0xC7, 0xFE,
  /* RLE: 004 Pixels @ 097,088 */ 4, 0xFF,
  /* ABS: 004 Pixels @ 101,088 */ 0, 4, 0xFB, 0x9B, 0x37, 0xD7,
  /* RLE: 004 Pixels @ 105,088 */ 4, 0xFF,
  /* ABS: 012 Pixels @ 109,088 */ 0, 12, 0xAE, 0x09, 0x57, 0xB7, 0xF1, 0xFB, 0xFF, 0xFF, 0xFF, 0xED, 0x40, 0x93,
  /* RLE: 007 Pixels @ 121,088 */ 7, 0xFF,
  /* ABS: 004 Pixels @ 128,088 */ 0, 4, 0xF3, 0x48, 0x71, 0xFB,
  /* RLE: 013 Pixels @ 132,088 */ 13, 0xFF,
  /* ABS: 015 Pixels @ 145,088 */ 0, 15, 0xE3, 0x3C, 0x9D, 0xFE, 0xEE, 0x60, 0x35, 0x58, 0x7C, 0x95, 0x9A, 0x7F, 0x4A, 0x2D, 0xB5,
  /* RLE: 005 Pixels @ 160,088 */ 5, 0xFF,
  /* ABS: 013 Pixels @ 165,088 */ 0, 13, 0xFC, 0x94, 0x62, 0x59, 0x60, 0x4E, 0x2C, 0xC3, 0x53, 0x42, 0x1B, 0x05, 0xB8,
  /* RLE: 022 Pixels @ 178,088 */ 22, 0xFF,
  /* ABS: 002 Pixels @ 200,088 */ 0, 2, 0x51, 0x66,
  /* RLE: 043 Pixels @ 202,088 */ 43, 0xFF,
  /* ABS: 003 Pixels @ 245,088 */ 0, 3, 0xE3, 0x3A, 0xA9,
  /* RLE: 009 Pixels @ 248,088 */ 9, 0xFF,
  /* ABS: 030 Pixels @ 257,088 */ 0, 30, 0xFE, 0x44, 0x8B, 0xFF, 0xFF, 0xFF, 0xD8, 0x20, 0x07, 0xE4, 0xF0, 0x59, 0x49, 0xD0, 0xFF, 0xB1, 0x0C, 0x56, 0xF4, 0xFC, 0x4F, 0x9C, 0xFF, 0xDF, 0x27, 0xE2, 0x74, 0x6F, 0x3A, 0xA9,
  /* RLE: 027 Pixels @ 287,088 */ 27, 0xFF,
  /* ABS: 031 Pixels @ 014,089 */ 0, 31, 0xFE, 0xE2, 0x67, 0x33, 0xA2, 0xD6, 0x3F, 0x4B, 0x88, 0x6C, 0x42, 0x2B, 0x30, 0x3B, 0x43, 0x4E, 0x5B, 0x77, 0x92, 0xA0, 0xB0, 0xB6, 0xB8, 0xC4, 0x76, 0x1F, 0x33, 0x56, 0xA7, 0x2F, 0xD5,
  /* RLE: 009 Pixels @ 045,089 */ 9, 0xFF,
  /* ABS: 006 Pixels @ 054,089 */ 0, 6, 0xF6, 0x50, 0x6D, 0x5B, 0x63, 0xFB,
  /* RLE: 012 Pixels @ 060,089 */ 12, 0xFF,
  /* ABS: 004 Pixels @ 072,089 */ 0, 4, 0xFC, 0xAF, 0x2D, 0xC5,
  /* RLE: 004 Pixels @ 076,089 */ 4, 0xFF,
  /* ABS: 004 Pixels @ 080,089 */ 0, 4, 0xFD, 0xAF, 0x33, 0xD3,
  /* RLE: 009 Pixels @ 084,089 */ 9, 0xFF,
  /* ABS: 012 Pixels @ 093,089 */ 0, 12, 0xF0, 0x69, 0x36, 0x8B, 0x9D, 0x9E, 0x9D, 0x96, 0x81, 0x28, 0xA6, 0xFD,
  /* RLE: 004 Pixels @ 105,089 */ 4, 0xFF,
  /* ABS: 003 Pixels @ 109,089 */ 0, 3, 0xF0, 0x50, 0x90,
  /* RLE: 005 Pixels @ 112,089 */ 5, 0xFF,
  /* ABS: 004 Pixels @ 117,089 */ 0, 4, 0xFE, 0x9E, 0x44, 0xE3,
  /* RLE: 006 Pixels @ 121,089 */ 6, 0xFF,
  /* ABS: 004 Pixels @ 127,089 */ 0, 4, 0xEF, 0x7D, 0x3D, 0xDC,
  /* RLE: 014 Pixels @ 131,089 */ 14, 0xFF,
  /* ABS: 016 Pixels @ 145,089 */ 0, 16, 0xA8, 0x2C, 0xE8, 0xFC, 0x84, 0x39, 0xC4, 0xF8, 0xFF, 0xFF, 0xFF, 0xFE, 0xED, 0x6A, 0x38, 0xF3,
  /* RLE: 005 Pixels @ 161,089 */ 5, 0xFF,
  /* ABS: 012 Pixels @ 166,089 */ 0, 12, 0xF0, 0x68, 0x68, 0x66, 0x5C, 0x29, 0x68, 0xAC, 0x29, 0x3B, 0x00, 0x8C,
  /* RLE: 022 Pixels @ 178,089 */ 22, 0xFF,
  /* ABS: 002 Pixels @ 200,089 */ 0, 2, 0x45, 0x7B,
  /* RLE: 043 Pixels @ 202,089 */ 43, 0xFF,
  /* ABS: 003 Pixels @ 245,089 */ 0, 3, 0xAD, 0x2A, 0xE9,
  /* RLE: 009 Pixels @ 248,089 */ 9, 0xFF,
  /* ABS: 030 Pixels @ 257,089 */ 0, 30, 0xEA, 0x22, 0xC6, 0xFF, 0xFF, 0xFF, 0xCF, 0x1C, 0x0C, 0xEB, 0xF4, 0xC0, 0x64, 0x55, 0xFB, 0x5B, 0x50, 0x3D, 0xE5, 0xFF, 0x76, 0x79, 0xFE, 0xEC, 0x39, 0xD4, 0x8C, 0x58, 0x46, 0xA5,
  /* RLE: 027 Pixels @ 287,089 */ 27, 0xFF,
  /* ABS: 033 Pixels @ 014,090 */ 0, 33, 0xC0, 0x2C, 0x57, 0xDB, 0xDB, 0x4B, 0x54, 0xED, 0xDF, 0x74, 0x3D, 0x2E, 0x34, 0x8F, 0xBC, 0xAD, 0x9D, 0x83, 0x73, 0x60, 0x4F, 0x41, 0x40, 0x3B, 0x41, 0x17, 0x2B, 0x2D, 0xE4, 0x56, 0x3B, 0xC8, 0xF9,
  /* RLE: 006 Pixels @ 047,090 */ 6, 0xFF,
  /* ABS: 007 Pixels @ 053,090 */ 0, 7, 0xF8, 0x9A, 0x27, 0xD8, 0x9D, 0x28, 0xC9,
  /* RLE: 011 Pixels @ 060,090 */ 11, 0xFF,
  /* ABS: 005 Pixels @ 071,090 */ 0, 5, 0xF8, 0xA7, 0x2B, 0x9F, 0xFD,
  /* RLE: 004 Pixels @ 076,090 */ 4, 0xFF,
  /* ABS: 006 Pixels @ 080,090 */ 0, 6, 0xE1, 0x2D, 0x7A, 0xE6, 0xF3, 0xFE,
  /* RLE: 008 Pixels @ 086,090 */ 8, 0xFF,
  /* ABS: 010 Pixels @ 094,090 */ 0, 10, 0xF6, 0x9C, 0x77, 0x70, 0x6C, 0x70, 0x6E, 0x76, 0xBF, 0xFC,
  /* RLE: 006 Pixels @ 104,090 */ 6, 0xFF,
  /* ABS: 020 Pixels @ 110,090 */ 0, 20, 0xEE, 0xF9, 0xFF, 0xFA, 0xF8, 0xF8, 0xED, 0xE7, 0xCD, 0xC0, 0xD7, 0xD5, 0xD3, 0xD5, 0xD8, 0xD7, 0xB2, 0x4F, 0x3C, 0xE2,
  /* RLE: 014 Pixels @ 130,090 */ 14, 0xFF,
  /* ABS: 007 Pixels @ 144,090 */ 0, 7, 0xFC, 0x4A, 0x79, 0xFF, 0xF0, 0x49, 0x8F,
  /* RLE: 007 Pixels @ 151,090 */ 7, 0xFF,
  /* ABS: 021 Pixels @ 158,090 */ 0, 21, 0xBD, 0x2A, 0xDE, 0xFF, 0xFB, 0xFE, 0xFF, 0xFF, 0xFF, 0xD0, 0x5B, 0x63, 0x83, 0x22, 0x18, 0xB4, 0x36, 0x4D, 0x0A, 0x4B, 0xF8,
  /* RLE: 020 Pixels @ 179,090 */ 20, 0xFF,
  /* ABS: 003 Pixels @ 199,090 */ 0, 3, 0xFE, 0x29, 0x8E,
  /* RLE: 042 Pixels @ 202,090 */ 42, 0xFF,
  /* ABS: 004 Pixels @ 244,090 */ 0, 4, 0xFE, 0x5F, 0x69, 0xFE,
  /* RLE: 009 Pixels @ 248,090 */ 9, 0xFF,
  /* ABS: 030 Pixels @ 257,090 */ 0, 30, 0xB4, 0x43, 0xEA, 0xFF, 0xFF, 0xFF, 0xC9, 0x19, 0x1C, 0xE9, 0x6C, 0x0E, 0x78, 0x2A, 0xB8, 0x40, 0x9E, 0x37, 0xDA, 0xFF, 0x8D, 0x65, 0xFE, 0xF0, 0x45, 0xB4, 0xB3, 0x45, 0x4D, 0xA5,
  /* RLE: 026 Pixels @ 287,090 */ 26, 0xFF,
  /* ABS: 116 Pixels @ 013,091 */ 0, 116, 0xFB, 0x4A, 0x5C, 0xED, 0xD4, 0x2D, 0x27, 0xA2, 0xCE, 0x61, 0x3B, 0xBC, 0xC6, 0x30, 0x7A, 0xFF, 0xFF, 0xFF, 0xFE, 0xFD, 0xF8, 0xF2, 0xEC, 0xEC, 0xEA, 0xED, 0x9B, 0x23, 0xA0, 0xFD, 0xE0, 0x6C, 0x33, 0x4B, 0x7C,
        0x8E, 0x91, 0xA7, 0xAB, 0xA7, 0x69, 0x33, 0xB4, 0xFC, 0xF4, 0x58, 0x31, 0x9E, 0xD3, 0xE1, 0xE8, 0xE4, 0xE2, 0xD8, 0xD0, 0xBF, 0xB3, 0x9D, 0x58, 0x3C, 0xA9, 0xF9, 0xFF, 0xFF, 0xFE, 0xF2, 0xC9, 0x59, 0x20, 0x33, 0x37, 0x39, 0x51, 0x5B, 0x75, 0x78,
        0x7E, 0x84, 0x85, 0x8F, 0x8F, 0x8F, 0x90, 0x91, 0x91, 0x90, 0x91, 0x91, 0x8E, 0x8C, 0x82, 0x7A, 0x7A, 0x77, 0x77, 0x75, 0x65, 0x59, 0x5A, 0x5A, 0x41, 0x3B, 0x3B, 0x3A, 0x3B, 0x3E, 0x3D, 0x40, 0x42, 0x43, 0x40, 0x3E, 0x3E, 0x4A, 0x89, 0xE3,
  /* RLE: 015 Pixels @ 129,091 */ 15, 0xFF,
  /* ABS: 008 Pixels @ 144,091 */ 0, 8, 0xCF, 0x28, 0xC8, 0xFF, 0xF6, 0x57, 0x75, 0xFC,
  /* RLE: 006 Pixels @ 152,091 */ 6, 0xFF,
  /* ABS: 021 Pixels @ 158,091 */ 0, 21, 0x94, 0x31, 0xF1, 0xF7, 0x82, 0x76, 0xDE, 0xFF, 0xFF, 0xFA, 0x7D, 0x81, 0x73, 0x7E, 0x0E, 0x5A, 0x84, 0x32, 0x32, 0x2F, 0xE8,
  /* RLE: 020 Pixels @ 179,091 */ 20, 0xFF,
  /* ABS: 003 Pixels @ 199,091 */ 0, 3, 0xFC, 0x1B, 0xAD,
  /* RLE: 042 Pixels @ 202,091 */ 42, 0xFF,
  /* ABS: 003 Pixels @ 244,091 */ 0, 3, 0xDC, 0x23, 0xB8,
  /* RLE: 009 Pixels @ 247,091 */ 9, 0xFF,
  /* ABS: 031 Pixels @ 256,091 */ 0, 31, 0xFB, 0x70, 0x6F, 0xFC, 0xFF, 0xFF, 0xFF, 0xC9, 0x19, 0x21, 0xC5, 0x33, 0x91, 0x34, 0x40, 0x5C, 0x3A, 0xBE, 0x2F, 0xCE, 0xFF, 0x97, 0x4E, 0xFD, 0xF3, 0x4F, 0xA5, 0xBE, 0x36, 0x4D, 0x9A,
  /* RLE: 026 Pixels @ 287,091 */ 26, 0xFF,
  /* ABS: 114 Pixels @ 013,092 */ 0, 114, 0xEC, 0x2E, 0x8A, 0xFE, 0xDE, 0x6C, 0x4B, 0x39, 0x31, 0x17, 0x1B, 0x44, 0x4B, 0x0E, 0x3E, 0x86, 0xAA, 0xB4, 0xC7, 0xCD, 0xDD, 0xDF, 0xE1, 0xF1, 0xE7, 0xDC, 0xDB, 0x5F, 0x28, 0xB3, 0xDD, 0xE7, 0xC5, 0x93, 0x68,
        0x57, 0x50, 0x4C, 0x44, 0x44, 0x83, 0xCF, 0xFF, 0xFF, 0xFF, 0xEB, 0x9E, 0x41, 0x2A, 0x30, 0x3C, 0x35, 0x32, 0x2C, 0x33, 0x36, 0x3E, 0x56, 0x9C, 0xD9, 0xFF, 0xFA, 0xE6, 0xC7, 0x92, 0x51, 0x22, 0x5F, 0xD1, 0xD4, 0xC1, 0xB2, 0xA5, 0x90, 0x8C, 0x7F,
        0x75, 0x6E, 0x6D, 0x6A, 0x6D, 0x6D, 0x6B, 0x6B, 0x67, 0x6A, 0x35, 0x00, 0x00, 0x00, 0x0B, 0x61, 0x7A, 0x83, 0x8F, 0x90, 0x94, 0xA2, 0xA8, 0xA8, 0xAE, 0xB7, 0xBA, 0xC1, 0xC7, 0xCB, 0xCF, 0xDC, 0xE2, 0xE3, 0xDD, 0xD7, 0xD7, 0xF4,
  /* RLE: 016 Pixels @ 127,092 */ 16, 0xFF,
  /* ABS: 009 Pixels @ 143,092 */ 0, 9, 0xFC, 0x7A, 0x51, 0xF2, 0xFF, 0xFE, 0x97, 0x33, 0xE3,
  /* RLE: 005 Pixels @ 152,092 */ 5, 0xFF,
  /* ABS: 022 Pixels @ 157,092 */ 0, 22, 0xFE, 0x3F, 0x77, 0xFF, 0xD1, 0x21, 0x22, 0x47, 0xE2, 0xFF, 0xFF, 0xCE, 0x67, 0x68, 0xC3, 0x38, 0x10, 0xA0, 0x25, 0x5A, 0x23, 0xD0,
  /* RLE: 020 Pixels @ 179,092 */ 20, 0xFF,
  /* ABS: 003 Pixels @ 199,092 */ 0, 3, 0xE6, 0x0F, 0xC3,
  /* RLE: 041 Pixels @ 202,092 */ 41, 0xFF,
  /* ABS: 004 Pixels @ 243,092 */ 0, 4, 0xFE, 0x98, 0x40, 0xE8,
  /* RLE: 009 Pixels @ 247,092 */ 9, 0xFF,
  /* ABS: 003 Pixels @ 256,092 */ 0, 3, 0xEE, 0x48, 0xA1,
  /* RLE: 004 Pixels @ 259,092 */ 4, 0xFF,
  /* ABS: 024 Pixels @ 263,092 */ 0, 24, 0xC9, 0x19, 0x1F, 0xB3, 0x30, 0xF3, 0x4B, 0x3B, 0x23, 0x2A, 0xD1, 0x27, 0xBD, 0xFF, 0xA9, 0x42, 0xFC, 0xF5, 0x5A, 0x95, 0xCF, 0x2B, 0x45, 0x9B,
  /* RLE: 026 Pixels @ 287,092 */ 26, 0xFF,
  /* ABS: 068 Pixels @ 013,093 */ 0, 68, 0xEF, 0x31, 0x8E, 0xFE, 0xFF, 0xFE, 0xFD, 0xFC, 0xFB, 0xF3, 0xDD, 0xC2, 0xAB, 0x90, 0x87, 0x76, 0x64, 0x55, 0x47, 0x3F, 0x33, 0x2D, 0x28, 0x2E, 0x33, 0x36, 0x8C, 0xEB, 0x90, 0x36, 0x28, 0x25, 0x26, 0x1F, 0x25,
        0x3D, 0x3F, 0x3F, 0x3E, 0x46, 0x55, 0x52, 0x57, 0x55, 0x65, 0x68, 0x6C, 0x71, 0x69, 0x59, 0x4F, 0x54, 0x68, 0x72, 0x7A, 0x81, 0x7F, 0x7C, 0x66, 0x52, 0x45, 0x2A, 0x26, 0x3A, 0x63, 0x97, 0xE6, 0xFD,
  /* RLE: 007 Pixels @ 081,093 */ 7, 0xFF,
  /* RLE: 010 Pixels @ 088,093 */ 10, 0xFE,
  /* ABS: 009 Pixels @ 098,093 */ 0, 9, 0xAA, 0x2A, 0x77, 0x92, 0x90, 0x3E, 0x57, 0xFE, 0xFE,
  /* RLE: 018 Pixels @ 107,093 */ 18, 0xFF,
  /* ABS: 008 Pixels @ 125,093 */ 0, 8, 0xFB, 0xF8, 0xF1, 0xEB, 0xE4, 0xDB, 0xD1, 0xE2,
  /* RLE: 010 Pixels @ 133,093 */ 10, 0xFF,
  /* ABS: 036 Pixels @ 143,093 */ 0, 36, 0xE3, 0x31, 0xB2, 0xFF, 0xFF, 0xFF, 0xF4, 0x2C, 0x78, 0xFD, 0xFF, 0xFF, 0xFF, 0xFC, 0xA1, 0x2E, 0xDB, 0xFF, 0x87, 0x41, 0xE9, 0x49, 0x51, 0xF8, 0xFF, 0xFF, 0x75, 0x96, 0x82, 0xE9, 0x5D, 0x67, 0x49, 0x58, 0x25,
        0xBA,
  /* RLE: 020 Pixels @ 179,093 */ 20, 0xFF,
  /* ABS: 003 Pixels @ 199,093 */ 0, 3, 0xAF, 0x31, 0xE1,
  /* RLE: 041 Pixels @ 202,093 */ 41, 0xFF,
  /* ABS: 003 Pixels @ 243,093 */ 0, 3, 0xEA, 0x3D, 0x93,
  /* RLE: 010 Pixels @ 246,093 */ 10, 0xFF,
  /* ABS: 003 Pixels @ 256,093 */ 0, 3, 0xD3, 0x21, 0xE4,
  /* RLE: 004 Pixels @ 259,093 */ 4, 0xFF,
  /* ABS: 024 Pixels @ 263,093 */ 0, 24, 0xC9, 0x19, 0x20, 0xAB, 0x32, 0xFA, 0x84, 0x06, 0x1B, 0x26, 0xCD, 0x38, 0xB8, 0xFF, 0xAE, 0x2C, 0xFC, 0xF9, 0x65, 0x8C, 0xD7, 0x26, 0x42, 0xA3,
  /* RLE: 026 Pixels @ 287,093 */ 26, 0xFF,
  /* ABS: 004 Pixels @ 013,094 */ 0, 4, 0xF8, 0x37, 0x82, 0xFD,
  /* RLE: 011 Pixels @ 017,094 */ 11, 0xFF,
  /* ABS: 033 Pixels @ 028,094 */ 0, 33, 0xFE, 0xFC, 0xF8, 0xEE, 0xE8, 0xE0, 0xD7, 0xAC, 0x78, 0x7B, 0x8F, 0xA6, 0xBB, 0xC8, 0xBE, 0xBB, 0xBF, 0xC0, 0xBC, 0xBF, 0xC0, 0xC1, 0xC2, 0xBA, 0xB5, 0xB7, 0xB0, 0x96, 0x9A, 0x98, 0x8E, 0x8D, 0x76,
  /* RLE: 005 Pixels @ 061,094 */ 5, 0x70,
  /* ABS: 068 Pixels @ 066,094 */ 0, 68, 0x66, 0x6D, 0x6B, 0x70, 0x7A, 0x93, 0xA7, 0xB8, 0xC9, 0xD6, 0xC3, 0x6E, 0x60, 0x6D, 0x7F, 0x86, 0x8F, 0x91, 0x9C, 0xA1, 0x9D, 0xA7, 0xB1, 0xB6, 0xBC, 0xBC, 0xBC, 0xBE, 0xBE, 0xC3, 0xD2, 0xD3, 0x47, 0x52, 0xD4,
        0xD4, 0xD4, 0x52, 0x45, 0xD4, 0xD4, 0xD4, 0xD3, 0xD1, 0xD1, 0xC4, 0xBC, 0xBC, 0xBC, 0xBA, 0xAA, 0xA4, 0xA2, 0x9F, 0x90, 0x8C, 0x85, 0x6F, 0x66, 0x52, 0x45, 0x40, 0x40, 0x41, 0x3F, 0x3B, 0x8A, 0xFE,
  /* RLE: 009 Pixels @ 134,094 */ 9, 0xFF,
  /* ABS: 003 Pixels @ 143,094 */ 0, 3, 0xB0, 0x20, 0xEA,
  /* RLE: 004 Pixels @ 146,094 */ 4, 0xFF,
  /* ABS: 029 Pixels @ 150,094 */ 0, 29, 0xA6, 0x2A, 0xC1, 0xFE, 0xFF, 0xFF, 0xD4, 0x2F, 0x9D, 0xFB, 0xFE, 0x50, 0x7C, 0xFF, 0xC6, 0x1E, 0xB5, 0xFF, 0xFF, 0xB4, 0x88, 0x65, 0xE4, 0xAB, 0x3D, 0x64, 0x49, 0x2F, 0x9F,
  /* RLE: 020 Pixels @ 179,094 */ 20, 0xFF,
  /* ABS: 003 Pixels @ 199,094 */ 0, 3, 0x94, 0x42, 0xEC,
  /* RLE: 041 Pixels @ 202,094 */ 41, 0xFF,
  /* ABS: 003 Pixels @ 243,094 */ 0, 3, 0xB4, 0x22, 0xE4,
  /* RLE: 008 Pixels @ 246,094 */ 8, 0xFF,
  /* ABS: 005 Pixels @ 254,094 */ 0, 5, 0xFE, 0xFD, 0xA7, 0x2B, 0xFA,
  /* RLE: 004 Pixels @ 259,094 */ 4, 0xFF,
  /* ABS: 024 Pixels @ 263,094 */ 0, 24, 0xC9, 0x19, 0x1B, 0x84, 0x28, 0xED, 0x86, 0x08, 0x2D, 0x2B, 0xB3, 0x41, 0xA7, 0xFF, 0xAF, 0x31, 0xFD, 0xF9, 0x64, 0x7D, 0xE4, 0x26, 0x40, 0xA6,
  /* RLE: 026 Pixels @ 287,094 */ 26, 0xFF,
  /* ABS: 004 Pixels @ 013,095 */ 0, 4, 0xF9, 0x37, 0x72, 0xFC,
  /* RLE: 016 Pixels @ 017,095 */ 16, 0xFF,
  /* ABS: 100 Pixels @ 033,095 */ 0, 100, 0xFE, 0xAE, 0x26, 0x54, 0x57, 0x4B, 0x44, 0x33, 0x23, 0x1C, 0x1C, 0x28, 0x38, 0x3E, 0x4A, 0x5A, 0x64, 0x78, 0x7F, 0x8F, 0xA0, 0xA3, 0xB2, 0xB6, 0xBF, 0xC6, 0xD2, 0xE2, 0xF4, 0xF5, 0xF8, 0xFA, 0xF8, 0xF8, 0xFB,
        0xFD, 0xFD, 0xFB, 0xF8, 0xF7, 0xF1, 0xF8, 0xFE, 0xDF, 0x84, 0x7A, 0x69, 0x65, 0x66, 0x5D, 0x58, 0x53, 0x50, 0x48, 0x4A, 0x43, 0x3E, 0x41, 0x40, 0x36, 0x36, 0x35, 0x2A, 0x28, 0x22, 0x28, 0x24, 0x22, 0x25, 0x25, 0x22, 0x21, 0x25, 0x27, 0x28, 0x28,
        0x29, 0x30, 0x32, 0x3A, 0x39, 0x39, 0x45, 0x48, 0x4F, 0x53, 0x57, 0x60, 0x66, 0x6A, 0x78, 0x7D, 0x8B, 0x9A, 0xA9, 0xB8, 0xCC, 0xDB, 0xE5, 0xFA,
  /* RLE: 009 Pixels @ 133,095 */ 9, 0xFF,
  /* ABS: 038 Pixels @ 142,095 */ 0, 38, 0xFD, 0x62, 0x65, 0xFA, 0xFE, 0xFF, 0xFF, 0xFF, 0xF7, 0x64, 0x35, 0xDC, 0xFF, 0xF3, 0x5B, 0x48, 0xF7, 0xFF, 0xF7, 0x2C, 0xA2, 0xFF, 0xF6, 0x68, 0x56, 0xF5, 0xFF, 0xD8, 0x65, 0x89, 0xBE, 0xEF, 0x29, 0x67, 0x34,
        0x48, 0x77, 0xFE,
  /* RLE: 018 Pixels @ 180,095 */ 18, 0xFF,
  /* ABS: 004 Pixels @ 198,095 */ 0, 4, 0xFA, 0x64, 0x64, 0xFA,
  /* RLE: 040 Pixels @ 202,095 */ 40, 0xFF,
  /* ABS: 017 Pixels @ 242,095 */ 0, 17, 0xFB, 0x5B, 0x6D, 0xFB, 0xFF, 0xFF, 0xFE, 0xFC, 0xF2, 0xDB, 0xBD, 0xAA, 0x92, 0x75, 0x3B, 0x65, 0xFD,
  /* RLE: 004 Pixels @ 259,095 */ 4, 0xFF,
  /* ABS: 024 Pixels @ 263,095 */ 0, 24, 0xCE, 0x1B, 0x09, 0x0B, 0x0C, 0xAA, 0x47, 0x38, 0x4D, 0x4F, 0x8D, 0x49, 0xA1, 0xFF, 0xB3, 0x2B, 0xFB, 0xFB, 0x6D, 0x7E, 0xEA, 0x19, 0x28, 0xA8,
  /* RLE: 026 Pixels @ 287,095 */ 26, 0xFF,
  /* ABS: 004 Pixels @ 013,096 */ 0, 4, 0xFA, 0x3D, 0x73, 0xFC,
  /* RLE: 016 Pixels @ 017,096 */ 16, 0xFF,
  /* ABS: 093 Pixels @ 033,096 */ 0, 93, 0xF6, 0x35, 0x95, 0xF6, 0xF7, 0xF4, 0xF3, 0xF0, 0xEC, 0xE8, 0xDF, 0xD7, 0xCB, 0xC1, 0xB0, 0x9E, 0x97, 0x82, 0x74, 0x6B, 0x59, 0x51, 0x4B, 0x46, 0x44, 0x40, 0x41, 0x3E, 0x3A, 0x3B, 0x3C, 0x3A, 0x32, 0x2F, 0x3E,
        0x44, 0x44, 0x3E, 0x34, 0x39, 0x3A, 0x39, 0x5F, 0xDC, 0xFD, 0xFD, 0xFA, 0xF9, 0xF9, 0xF8, 0xF7, 0xF6, 0xF5, 0xF4, 0xF4, 0xF3, 0xF2, 0xF3, 0xF2, 0xF1, 0xF1, 0xF0, 0xEE, 0xEE, 0xEC, 0xEE, 0xED, 0xEC, 0xED, 0xED, 0xEC, 0xEC, 0xED, 0xED, 0xEE, 0xEE,
        0xEE, 0xEF, 0xF0, 0xF1, 0xF1, 0xF1, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7, 0xF8, 0xF9, 0xFA, 0xFD, 0xFD, 0xFE,
  /* RLE: 016 Pixels @ 126,096 */ 16, 0xFF,
  /* ABS: 038 Pixels @ 142,096 */ 0, 38, 0xDC, 0x32, 0x7A, 0x4F, 0x48, 0x8B, 0xD9, 0xFE, 0xFF, 0xE2, 0x4C, 0x3D, 0xA4, 0x5E, 0x46, 0xDA, 0xFF, 0xFF, 0xDE, 0x27, 0xBB, 0xFF, 0xFF, 0xCD, 0x26, 0xC7, 0xFF, 0xF6, 0x65, 0x9C, 0x92, 0xFF, 0x55, 0x5D, 0x24,
        0x3D, 0x69, 0xFE,
  /* RLE: 018 Pixels @ 180,096 */ 18, 0xFF,
  /* ABS: 003 Pixels @ 198,096 */ 0, 3, 0xE8, 0x3D, 0xA3,
  /* RLE: 037 Pixels @ 201,096 */ 37, 0xFF,
  /* ABS: 020 Pixels @ 238,096 */ 0, 20, 0xFE, 0xFB, 0xEF, 0xDC, 0xB0, 0x25, 0x7C, 0x99, 0x76, 0x61, 0x46, 0x3E, 0x38, 0x3C, 0x42, 0x45, 0x59, 0x70, 0x1A, 0x9E,
  /* RLE: 005 Pixels @ 258,096 */ 5, 0xFF,
  /* ABS: 024 Pixels @ 263,096 */ 0, 24, 0xD3, 0x1E, 0x10, 0x47, 0x0E, 0x2B, 0x61, 0x62, 0x74, 0xA3, 0x44, 0x3A, 0xA9, 0xFF, 0xAE, 0x31, 0xFC, 0xFB, 0x6D, 0x7F, 0xE8, 0x14, 0x14, 0xAC,
  /* RLE: 026 Pixels @ 287,096 */ 26, 0xFF,
  /* ABS: 004 Pixels @ 013,097 */ 0, 4, 0xFD, 0x50, 0x69, 0xFB,
  /* RLE: 016 Pixels @ 017,097 */ 16, 0xFF,
  /* ABS: 003 Pixels @ 033,097 */ 0, 3, 0xF2, 0x23, 0xCA,
  /* RLE: 016 Pixels @ 036,097 */ 16, 0xFF,
  /* ABS: 015 Pixels @ 052,097 */ 0, 15, 0xFE, 0xFB, 0xFA, 0xF5, 0xEF, 0xEA, 0xE4, 0xE2, 0xDC, 0xD4, 0xD3, 0xD3, 0xC5, 0xC3, 0xC1,
  /* RLE: 004 Pixels @ 067,097 */ 4, 0xC0,
  /* ABS: 007 Pixels @ 071,097 */ 0, 7, 0xC6, 0xD1, 0xD4, 0xBC, 0x42, 0x6C, 0xF8,
  /* RLE: 008 Pixels @ 078,097 */ 8, 0xFF,
  /* ABS: 004 Pixels @ 086,097 */ 0, 4, 0xFE, 0xFB, 0xFB, 0xFD,
  /* RLE: 034 Pixels @ 090,097 */ 34, 0xFF,
  /* ABS: 011 Pixels @ 124,097 */ 0, 11, 0xF5, 0xCC, 0xC4, 0xC3, 0xC1, 0xC1, 0xB9, 0xB6, 0xA4, 0xAE, 0xA6,
  /* RLE: 004 Pixels @ 135,097 */ 4, 0xA1,
  /* ABS: 041 Pixels @ 139,097 */ 0, 41, 0xB0, 0xF7, 0xFF, 0xA6, 0x1F, 0x27, 0x6B, 0x95, 0x3D, 0x3B, 0xCD, 0xFF, 0xFE, 0xE5, 0x70, 0x34, 0x6B, 0xD6, 0xFF, 0xFF, 0xFF, 0xD5, 0x27, 0xC0, 0xFF, 0xFF, 0xFB, 0x2F, 0x92, 0xFF, 0xFF, 0x95, 0x90, 0x71, 0xF9,
        0x95, 0x2A, 0x33, 0x2A, 0x57, 0xFD,
  /* RLE: 018 Pixels @ 180,097 */ 18, 0xFF,
  /* ABS: 003 Pixels @ 198,097 */ 0, 3, 0xD4, 0x1D, 0xCE,
  /* RLE: 027 Pixels @ 201,097 */ 27, 0xFF,
  /* ABS: 030 Pixels @ 228,097 */ 0, 30, 0xFE, 0xFB, 0xF9, 0xF6, 0xF4, 0xE9, 0xD7, 0xBC, 0x9F, 0x85, 0x71, 0x5B, 0x49, 0x36, 0x27, 0x29, 0x44, 0x5F, 0x75, 0x89, 0x9F, 0xBA, 0xCF, 0xDC, 0xE8, 0xF0, 0xFA, 0xDE, 0x34, 0xBE,
  /* RLE: 005 Pixels @ 258,097 */ 5, 0xFF,
  /* ABS: 024 Pixels @ 263,097 */ 0, 24, 0xE0, 0x25, 0x06, 0x84, 0x2A, 0xA7, 0xC0, 0x30, 0xBE, 0xE0, 0x33, 0x16, 0xB4, 0xFF, 0xAB, 0x47, 0xFD, 0xF6, 0x5C, 0x93, 0xEB, 0x18, 0x1B, 0xB9,
  /* RLE: 026 Pixels @ 287,097 */ 26, 0xFF,
  /* ABS: 004 Pixels @ 013,098 */ 0, 4, 0xFD, 0x55, 0x5D, 0xFA,
  /* RLE: 016 Pixels @ 017,098 */ 16, 0xFF,
  /* ABS: 003 Pixels @ 033,098 */ 0, 3, 0xEB, 0x19, 0xD3,
  /* RLE: 039 Pixels @ 036,098 */ 39, 0xFF,
  /* ABS: 003 Pixels @ 075,098 */ 0, 3, 0x73, 0x59, 0xF6,
  /* RLE: 008 Pixels @ 078,098 */ 8, 0xFF,
  /* ABS: 006 Pixels @ 086,098 */ 0, 6, 0xD1, 0x68, 0x66, 0x7F, 0xB4, 0xF2,
  /* RLE: 032 Pixels @ 092,098 */ 32, 0xFF,
  /* ABS: 031 Pixels @ 124,098 */ 0, 31, 0xC9, 0x1C, 0x35, 0x45, 0x45, 0x4A, 0x4B, 0x49, 0x51, 0x53, 0x58, 0x59, 0x58, 0x58, 0x42, 0x22, 0xE7, 0xFC, 0x5B, 0x12, 0x1F, 0xED, 0xFF, 0xF0, 0x61, 0x33, 0xF2, 0xFF, 0xFF, 0xFF, 0xFD,
  /* RLE: 005 Pixels @ 155,098 */ 5, 0xFF,
  /* ABS: 020 Pixels @ 160,098 */ 0, 20, 0xE9, 0x27, 0xB3, 0xFF, 0xFF, 0xFF, 0x6E, 0x4E, 0xFE, 0xFF, 0xD6, 0x6A, 0x6F, 0xD5, 0xC7, 0x22, 0x40, 0x11, 0x33, 0xFC,
  /* RLE: 018 Pixels @ 180,098 */ 18, 0xFF,
  /* ABS: 003 Pixels @ 198,098 */ 0, 3, 0xA5, 0x1A, 0xF6,
  /* RLE: 020 Pixels @ 201,098 */ 20, 0xFF,
  /* ABS: 023 Pixels @ 221,098 */ 0, 23, 0xFD, 0xF7, 0xE6, 0xCF, 0xBF, 0xB0, 0x9A, 0x85, 0x69, 0x51, 0x38, 0x32, 0x31, 0x3E, 0x4D, 0x59, 0x6E, 0x8D, 0xAA, 0xC3, 0xD4, 0xEE, 0xFB,
  /* RLE: 011 Pixels @ 244,098 */ 11, 0xFF,
  /* ABS: 003 Pixels @ 255,098 */ 0, 3, 0xB3, 0x31, 0xDB,
  /* RLE: 005 Pixels @ 258,098 */ 5, 0xFF,
  /* ABS: 024 Pixels @ 263,098 */ 0, 24, 0xEB, 0x2C, 0x00, 0xA0, 0x7D, 0x30, 0x39, 0x91, 0xFF, 0xFD, 0xAC, 0x61, 0xDD, 0xFF, 0x92, 0x4D, 0xFD, 0xF2, 0x4C, 0xAB, 0xD8, 0x09, 0x16, 0xBB,
  /* RLE: 027 Pixels @ 287,098 */ 27, 0xFF,
  /* ABS: 003 Pixels @ 014,099 */ 0, 3, 0x64, 0x51, 0xF9,
  /* RLE: 016 Pixels @ 017,099 */ 16, 0xFF,
  /* ABS: 003 Pixels @ 033,099 */ 0, 3, 0xEA, 0x12, 0xCF,
  /* RLE: 038 Pixels @ 036,099 */ 38, 0xFF,
  /* ABS: 004 Pixels @ 074,099 */ 0, 4, 0xFE, 0x70, 0x5D, 0xF7,
  /* RLE: 008 Pixels @ 078,099 */ 8, 0xFF,
  /* ABS: 006 Pixels @ 086,099 */ 0, 6, 0xE1, 0x9A, 0x95, 0x74, 0x2B, 0x8A,
  /* RLE: 032 Pixels @ 092,099 */ 32, 0xFF,
  /* ABS: 056 Pixels @ 124,099 */ 0, 56, 0xDE, 0x33, 0x8A, 0xE8, 0xEB, 0xEF, 0xEF, 0xEF, 0xF1, 0xF1, 0xF2, 0xF0, 0xE7, 0xEC, 0x93, 0x48, 0xF1, 0xEA, 0x1E, 0x2B, 0x46, 0xF7, 0xFF, 0xFF, 0xDA, 0x32, 0x95, 0xFD, 0xFF, 0xFF, 0xF8, 0xD5, 0xC3, 0xD0, 0xF0,
        0xFF, 0xFA, 0x31, 0x90, 0xFF, 0xFF, 0xFF, 0xAB, 0x24, 0xEF, 0xFF, 0xF6, 0x65, 0x82, 0xAD, 0xD7, 0x2F, 0x4C, 0x07, 0x0E, 0xF4,
  /* RLE: 017 Pixels @ 180,099 */ 17, 0xFF,
  /* ABS: 003 Pixels @ 197,099 */ 0, 3, 0xFE, 0x63, 0x5D,
  /* RLE: 011 Pixels @ 200,099 */ 11, 0xFF,
  /* ABS: 028 Pixels @ 211,099 */ 0, 28, 0xFD, 0xF7, 0xEA, 0xDF, 0xD9, 0xC9, 0xB6, 0x95, 0x76, 0x65, 0x4E, 0x42, 0x41, 0x3E, 0x3E, 0x49, 0x64, 0x86, 0x9A, 0xAD, 0xBD, 0xD1, 0xE1, 0xEB, 0xF1, 0xF6, 0xFC, 0xFE,
  /* RLE: 015 Pixels @ 239,099 */ 15, 0xFF,
  /* ABS: 004 Pixels @ 254,099 */ 0, 4, 0xFE, 0x8B, 0x4B, 0xFB,
  /* RLE: 005 Pixels @ 258,099 */ 5, 0xFF,
  /* ABS: 024 Pixels @ 263,099 */ 0, 24, 0xF5, 0x38, 0x07, 0x86, 0xF6, 0xDB, 0xDB, 0xD5, 0xD7, 0xF6, 0xFB, 0xF3, 0xFD, 0xFF, 0x8F, 0x66, 0xFE, 0xED, 0x3F, 0xC8, 0xD1, 0x0C, 0x20, 0xCB,
  /* RLE: 027 Pixels @ 287,099 */ 27, 0xFF,
  /* ABS: 003 Pixels @ 014,100 */ 0, 3, 0x6B, 0x40, 0xF8,
  /* RLE: 016 Pixels @ 017,100 */ 16, 0xFF,
  /* ABS: 003 Pixels @ 033,100 */ 0, 3, 0xEA, 0x16, 0xD3,
  /* RLE: 039 Pixels @ 036,100 */ 39, 0xFF,
  /* ABS: 003 Pixels @ 075,100 */ 0, 3, 0x83, 0x56, 0xF5,
  /* RLE: 012 Pixels @ 078,100 */ 12, 0xFF,
  /* ABS: 002 Pixels @ 090,100 */ 0, 2, 0xA2, 0x8E,
  /* RLE: 032 Pixels @ 092,100 */ 32, 0xFF,
  /* ABS: 056 Pixels @ 124,100 */ 0, 56, 0xF6, 0x5B, 0x1F, 0x5D, 0x6B, 0x7F, 0x7F, 0x7F, 0x78, 0x69, 0x62, 0x5C, 0x4C, 0x56, 0x27, 0xA1, 0xFD, 0xBB, 0x26, 0x3A, 0x73, 0xFC, 0xFF, 0xFF, 0xFD, 0x8B, 0x3B, 0xE7, 0xFF, 0xF4, 0x87, 0x2C, 0x41, 0x27, 0x5A,
        0xDC, 0xFF, 0x6A, 0x4A, 0xFE, 0xFF, 0xFF, 0xC8, 0x2A, 0xCD, 0xFF, 0xFD, 0x67, 0x9B, 0x89, 0xEC, 0x44, 0x4A, 0x0C, 0x08, 0xF0,
  /* RLE: 017 Pixels @ 180,100 */ 17, 0xFF,
  /* ABS: 003 Pixels @ 197,100 */ 0, 3, 0xEA, 0x32, 0x9E,
  /* RLE: 005 Pixels @ 200,100 */ 5, 0xFF,
  /* ABS: 022 Pixels @ 205,100 */ 0, 22, 0xFE, 0xF9, 0xEB, 0xCA, 0xAC, 0x8D, 0x6C, 0x58, 0x3F, 0x2A, 0x26, 0x33, 0x49, 0x5F, 0x75, 0x87, 0xA4, 0xBD, 0xD2, 0xDE, 0xEB, 0xFA,
  /* RLE: 027 Pixels @ 227,100 */ 27, 0xFF,
  /* ABS: 003 Pixels @ 254,100 */ 0, 3, 0xFA, 0x5F, 0x79,
  /* RLE: 006 Pixels @ 257,100 */ 6, 0xFF,
  /* ABS: 024 Pixels @ 263,100 */ 0, 24, 0xFC, 0x55, 0x17, 0x5D, 0xFA, 0xFF, 0xAA, 0x35, 0x30, 0x7F, 0xF8, 0xFF, 0xFF, 0xFF, 0x79, 0x74, 0xFE, 0xE0, 0x30, 0xE8, 0xB9, 0x06, 0x27, 0xDF,
  /* RLE: 027 Pixels @ 287,100 */ 27, 0xFF,
  /* ABS: 003 Pixels @ 014,101 */ 0, 3, 0x7A, 0x2C, 0xF6,
  /* RLE: 016 Pixels @ 017,101 */ 16, 0xFF,
  /* ABS: 003 Pixels @ 033,101 */ 0, 3, 0xEA, 0x10, 0xCE,
  /* RLE: 039 Pixels @ 036,101 */ 39, 0xFF,
  /* ABS: 003 Pixels @ 075,101 */ 0, 3, 0x8C, 0x4D, 0xF1,
  /* RLE: 007 Pixels @ 078,101 */ 7, 0xFF,
  /* ABS: 007 Pixels @ 085,101 */ 0, 7, 0xCD, 0x4B, 0xF6, 0xFF, 0xFF, 0xFE, 0xFD,
  /* RLE: 033 Pixels @ 092,101 */ 33, 0xFF,
  /* ABS: 055 Pixels @ 125,101 */ 0, 55, 0xF2, 0xBE, 0xA0, 0x88, 0x83, 0x82, 0x80, 0x84, 0x87, 0xA6, 0xAB, 0xB8, 0xAC, 0xD4, 0xFE, 0xFB, 0x6C, 0x54, 0x33, 0x95, 0xFE, 0xFF, 0xFF, 0xFF, 0xEF, 0x12, 0xBB, 0xFF, 0x80, 0x39, 0xD7, 0xD6, 0xDC, 0x57, 0x49,
        0xEF, 0xC8, 0x21, 0xBB, 0xFE, 0xFF, 0xDE, 0x38, 0xB6, 0xFF, 0xFE, 0x72, 0xA5, 0x7C, 0xF7, 0x5C, 0x4A, 0x11, 0x07, 0xEB,
  /* RLE: 017 Pixels @ 180,101 */ 17, 0xFF,
  /* ABS: 024 Pixels @ 197,101 */ 0, 24, 0xAC, 0x30, 0xBA, 0xC5, 0xB2, 0x95, 0x72, 0x56, 0x38, 0x2C, 0x34, 0x42, 0x4F, 0x67, 0x8E, 0xAC, 0xCA, 0xE1, 0xF2, 0xFA, 0xFC, 0xFD, 0xFE, 0xFE,
  /* RLE: 031 Pixels @ 221,101 */ 31, 0xFF,
  /* ABS: 006 Pixels @ 252,101 */ 0, 6, 0xF9, 0xD6, 0xAE, 0x21, 0x52, 0xDD,
  /* RLE: 006 Pixels @ 258,101 */ 6, 0xFF,
  /* ABS: 023 Pixels @ 264,101 */ 0, 23, 0x8B, 0x20, 0x36, 0xE1, 0xED, 0x3C, 0xB1, 0xDB, 0x4D, 0x72, 0xF9, 0xFF, 0xFB, 0x48, 0xA5, 0xFF, 0xBF, 0x3E, 0xF1, 0x99, 0x09, 0x3F, 0xF8,
  /* RLE: 027 Pixels @ 287,101 */ 27, 0xFF,
  /* ABS: 022 Pixels @ 014,102 */ 0, 22, 0x96, 0x22, 0xF0, 0xB8, 0x6B, 0x6F, 0x76, 0x82, 0x91, 0xAA, 0xCB, 0xDA, 0xE4, 0xE9, 0xED, 0xF2, 0xF7, 0xFD, 0xFE, 0xEE, 0x1D, 0xD3,
  /* RLE: 039 Pixels @ 036,102 */ 39, 0xFF,
  /* ABS: 003 Pixels @ 075,102 */ 0, 3, 0x9B, 0x48, 0xEF,
  /* RLE: 007 Pixels @ 078,102 */ 7, 0xFF,
  /* ABS: 006 Pixels @ 085,102 */ 0, 6, 0xC3, 0x14, 0xC6, 0xDF, 0xE0, 0xFC,
  /* RLE: 049 Pixels @ 091,102 */ 49, 0xFF,
  /* ABS: 005 Pixels @ 140,102 */ 0, 5, 0xEC, 0x44, 0x7E, 0x33, 0xAA,
  /* RLE: 004 Pixels @ 145,102 */ 4, 0xFF,
  /* ABS: 031 Pixels @ 149,102 */ 0, 31, 0xFE, 0x2A, 0x99, 0xF2, 0x2D, 0x7D, 0x56, 0x38, 0x58, 0xB2, 0x2D, 0xCC, 0xF7, 0x78, 0x36, 0xB0, 0xEA, 0xE3, 0x41, 0x91, 0xFE, 0xFF, 0x90, 0xA1, 0x6E, 0xF5, 0x6F, 0x4A, 0x64, 0x13, 0xD6,
  /* RLE: 009 Pixels @ 180,102 */ 9, 0xFF,
  /* ABS: 022 Pixels @ 189,102 */ 0, 22, 0xFE, 0xFA, 0xF2, 0xE9, 0xDE, 0xC1, 0x98, 0x74, 0x3B, 0x19, 0x36, 0x34, 0x42, 0x57, 0x7D, 0x9C, 0xB5, 0xCD, 0xDF, 0xEA, 0xF4, 0xFB,
  /* RLE: 037 Pixels @ 211,102 */ 37, 0xFF,
  /* ABS: 011 Pixels @ 248,102 */ 0, 11, 0xFB, 0xEF, 0xD1, 0x8F, 0x57, 0x3B, 0x40, 0x6E, 0x3F, 0x5B, 0xFC,
  /* RLE: 005 Pixels @ 259,102 */ 5, 0xFF,
  /* ABS: 023 Pixels @ 264,102 */ 0, 23, 0xAB, 0x23, 0x21, 0xC6, 0xBB, 0x40, 0xE5, 0xFF, 0xCC, 0x2A, 0xC7, 0xFF, 0xEB, 0x38, 0xC0, 0xFF, 0x8E, 0x6F, 0xF8, 0x6F, 0x16, 0x59, 0xFE,
  /* RLE: 027 Pixels @ 287,102 */ 27, 0xFF,
  /* ABS: 022 Pixels @ 014,103 */ 0, 22, 0xAF, 0x08, 0xC3, 0x2D, 0x60, 0x79, 0x73, 0x66, 0x62, 0x54, 0x42, 0x33, 0x2B, 0x2A, 0x37, 0x4D, 0x5E, 0x7B, 0x93, 0x97, 0x18, 0xD2,
  /* RLE: 039 Pixels @ 036,103 */ 39, 0xFF,
  /* ABS: 003 Pixels @ 075,103 */ 0, 3, 0xA4, 0x3A, 0xEA,
  /* RLE: 007 Pixels @ 078,103 */ 7, 0xFF,
  /* ABS: 006 Pixels @ 085,103 */ 0, 6, 0xF1, 0x7C, 0x2F, 0x33, 0x6D, 0xF4,
  /* RLE: 049 Pixels @ 091,103 */ 49, 0xFF,
  /* ABS: 005 Pixels @ 140,103 */ 0, 5, 0xD4, 0x27, 0xAF, 0x35, 0xBB,
  /* RLE: 004 Pixels @ 145,103 */ 4, 0xFF,
  /* ABS: 031 Pixels @ 149,103 */ 0, 31, 0xFE, 0x35, 0x8B, 0xB9, 0x18, 0x24, 0x6B, 0xC3, 0x45, 0x4E, 0x2F, 0x97, 0xFE, 0xF3, 0x7E, 0x25, 0x2D, 0x45, 0x1A, 0x78, 0xFD, 0xFF, 0xA6, 0x97, 0x64, 0xF3, 0x7F, 0x60, 0xD4, 0x26, 0xC5,
  /* RLE: 006 Pixels @ 180,103 */ 6, 0xFF,
  /* ABS: 016 Pixels @ 186,103 */ 0, 16, 0xFC, 0xDC, 0xBC, 0x92, 0x6A, 0x4A, 0x2B, 0x2B, 0x3E, 0x5F, 0x78, 0xA2, 0xC1, 0xD5, 0xEB, 0xFB,
  /* RLE: 044 Pixels @ 202,103 */ 44, 0xFF,
  /* ABS: 013 Pixels @ 246,103 */ 0, 13, 0xF4, 0xB8, 0x78, 0x3E, 0x30, 0x60, 0x9D, 0xD6, 0xF6, 0xF4, 0xB8, 0x20, 0xF7,
  /* RLE: 005 Pixels @ 259,103 */ 5, 0xFF,
  /* ABS: 022 Pixels @ 264,103 */ 0, 22, 0xD0, 0x23, 0x3C, 0x8E, 0x96, 0x5D, 0xFE, 0xFF, 0xDA, 0x2E, 0xD4, 0xFF, 0xCA, 0x40, 0xE4, 0xF5, 0x50, 0xA1, 0xEC, 0x42, 0x27, 0x6F,
  /* RLE: 028 Pixels @ 286,103 */ 28, 0xFF,
  /* ABS: 022 Pixels @ 014,104 */ 0, 22, 0xC6, 0x07, 0x9F, 0x28, 0xCE, 0xFD, 0xFC, 0xF9, 0xF8, 0xF6, 0xF2, 0xED, 0xE3, 0xC5, 0x38, 0x57, 0x9C, 0x85, 0x2B, 0x24, 0x12, 0xD0,
  /* RLE: 039 Pixels @ 036,104 */ 39, 0xFF,
  /* ABS: 003 Pixels @ 075,104 */ 0, 3, 0xA0, 0x3A, 0xEA,
  /* RLE: 008 Pixels @ 078,104 */ 8, 0xFF,
  /* ABS: 005 Pixels @ 086,104 */ 0, 5, 0xF9, 0xED, 0xEB, 0xF4, 0xFE,
  /* RLE: 015 Pixels @ 091,104 */ 15, 0xFF,
  /* RLE: 009 Pixels @ 106,104 */ 9, 0xFE,
  /* RLE: 025 Pixels @ 115,104 */ 25, 0xFF,
  /* ABS: 005 Pixels @ 140,104 */ 0, 5, 0xAF, 0x22, 0xCB, 0x33, 0xCA,
  /* RLE: 004 Pixels @ 145,104 */ 4, 0xFF,
  /* ABS: 048 Pixels @ 149,104 */ 0, 48, 0xFE, 0x26, 0xA2, 0xB4, 0x0A, 0x29, 0xED, 0xFE, 0xCB, 0x11, 0x09, 0x7A, 0xFC, 0xFF, 0xFA, 0xE3, 0xC0, 0xAD, 0xB0, 0xD9, 0xFF, 0xFF, 0xB7, 0x8A, 0x65, 0xEF, 0x85, 0x56, 0xD7, 0x31, 0xC9, 0xFC, 0xE9, 0xCD, 0xB7,
        0x85, 0x5B, 0x47, 0x3F, 0x4A, 0x60, 0x92, 0xAE, 0xCE, 0xE7, 0xF1, 0xF8, 0xFC,
  /* RLE: 046 Pixels @ 197,104 */ 46, 0xFF,
  /* ABS: 016 Pixels @ 243,104 */ 0, 16, 0xEC, 0xC7, 0x77, 0x3E, 0x42, 0x77, 0xAE, 0xBD, 0xB9, 0x99, 0x89, 0x83, 0x92, 0xA7, 0x1E, 0xF6,
  /* RLE: 005 Pixels @ 259,104 */ 5, 0xFF,
  /* ABS: 022 Pixels @ 264,104 */ 0, 22, 0xE8, 0x3B, 0x4D, 0x50, 0x7F, 0x71, 0xFE, 0xFA, 0x72, 0x6B, 0xFA, 0xFC, 0x7F, 0x64, 0xFE, 0xD3, 0x3A, 0xD5, 0xCE, 0x2B, 0x2A, 0xA9,
  /* RLE: 028 Pixels @ 286,104 */ 28, 0xFF,
  /* ABS: 005 Pixels @ 014,105 */ 0, 5, 0xD2, 0x11, 0xA0, 0x2E, 0xB8,
  /* RLE: 008 Pixels @ 019,105 */ 8, 0xFF,
  /* ABS: 028 Pixels @ 027,105 */ 0, 28, 0xFE, 0x91, 0x41, 0xE8, 0xFD, 0x42, 0x81, 0x25, 0x60, 0x98, 0xB9, 0xC6, 0xD8, 0xEA, 0xEA, 0xEE, 0xF2, 0xF3, 0xF7, 0xF7, 0xF8, 0xF9, 0xF9, 0xFB, 0xFC, 0xFC, 0xFE, 0xFE,
  /* RLE: 020 Pixels @ 055,105 */ 20, 0xFF,
  /* ABS: 022 Pixels @ 075,105 */ 0, 22, 0x9C, 0x3A, 0xEA, 0xF7, 0xDE, 0xD7, 0xC9, 0xC3, 0xC5, 0xC5, 0xAE, 0xAE, 0xAE, 0xA5, 0xA3, 0xA3, 0xA3, 0x9F, 0x98, 0x8E, 0x8C, 0x8C,
  /* RLE: 004 Pixels @ 097,105 */ 4, 0x8B,
  /* ABS: 008 Pixels @ 101,105 */ 0, 8, 0x8A, 0x8B, 0x85, 0x84, 0x83, 0x76, 0x6E, 0x70,
  /* RLE: 005 Pixels @ 109,105 */ 5, 0x71,
  /* ABS: 004 Pixels @ 114,105 */ 0, 4, 0x7A, 0x95, 0xE2, 0xFE,
  /* RLE: 022 Pixels @ 118,105 */ 22, 0xFF,
  /* ABS: 005 Pixels @ 140,105 */ 0, 5, 0x8C, 0x3F, 0xBC, 0x32, 0xDD,
  /* RLE: 004 Pixels @ 145,105 */ 4, 0xFF,
  /* ABS: 013 Pixels @ 149,105 */ 0, 13, 0xE8, 0x1A, 0xC9, 0xB7, 0x0A, 0x5F, 0xFF, 0xFF, 0xEE, 0x11, 0x11, 0x72, 0xFB,
  /* RLE: 009 Pixels @ 162,105 */ 9, 0xFF,
  /* ABS: 019 Pixels @ 171,105 */ 0, 19, 0xBA, 0x82, 0x60, 0xE5, 0x85, 0x59, 0xD9, 0x32, 0x81, 0x73, 0x42, 0x2D, 0x48, 0x72, 0x9F, 0xC3, 0xDD, 0xF2, 0xFC,
  /* RLE: 050 Pixels @ 190,105 */ 50, 0xFF,
  /* ABS: 019 Pixels @ 240,105 */ 0, 19, 0xFD, 0xF1, 0xA2, 0x4C, 0x2B, 0x6F, 0x99, 0x9B, 0x8A, 0x89, 0x94, 0xB0, 0xCD, 0xDF, 0xF0, 0xFC, 0xC1, 0x1F, 0xF7,
  /* RLE: 005 Pixels @ 259,105 */ 5, 0xFF,
  /* ABS: 022 Pixels @ 264,105 */ 0, 22, 0xF7, 0x64, 0x4A, 0x2C, 0x43, 0x87, 0xFF, 0xC3, 0x34, 0xCE, 0xFF, 0xF2, 0x38, 0xAF, 0xFF, 0x93, 0x4B, 0xFC, 0x97, 0x31, 0x2D, 0xD2,
  /* RLE: 028 Pixels @ 286,105 */ 28, 0xFF,
  /* ABS: 006 Pixels @ 014,106 */ 0, 6, 0xDD, 0x20, 0xAD, 0x42, 0x7F, 0xFC,
  /* RLE: 008 Pixels @ 020,106 */ 8, 0xFF,
  /* ABS: 090 Pixels @ 028,106 */ 0, 90, 0xF1, 0x20, 0xA6, 0xBF, 0x31, 0xD2, 0xD2, 0x7A, 0x58, 0x49, 0x43, 0x3B, 0x33, 0x25, 0x2E, 0x2F, 0x1F, 0x2E, 0x31, 0x38, 0x46, 0x48, 0x63, 0x69, 0x70, 0x88, 0x91, 0x98, 0xA4, 0xA6, 0xB2, 0xB6, 0xBC, 0xC8, 0xCE,
        0xD7, 0xDF, 0xE0, 0xE4, 0xEC, 0xF9, 0xF9, 0xF9, 0xFC, 0xFC, 0xFC, 0xF9, 0x8B, 0x48, 0xEF, 0xA3, 0x07, 0x2C, 0x43, 0x46, 0x46, 0x46, 0x4B, 0x4C, 0x53, 0x55, 0x2C, 0x18, 0x56, 0x5B, 0x60, 0x65, 0x62, 0x68, 0x66, 0x67, 0x64, 0x69, 0x63, 0x11, 0x51,
        0x82, 0x85, 0x90, 0x92, 0x8E, 0x8D, 0x89, 0x8F, 0x91, 0x91, 0x7A, 0x3D, 0x40, 0xE5,
  /* RLE: 022 Pixels @ 118,106 */ 22, 0xFF,
  /* ABS: 022 Pixels @ 140,106 */ 0, 22, 0x6F, 0x66, 0xAC, 0x34, 0xEA, 0xFF, 0xFF, 0xFF, 0xFC, 0x84, 0x47, 0xEC, 0xDE, 0x13, 0x3E, 0xF9, 0xFF, 0xA9, 0x27, 0x30, 0x7C, 0xFD,
  /* RLE: 009 Pixels @ 162,106 */ 9, 0xFF,
  /* ABS: 013 Pixels @ 171,106 */ 0, 13, 0xC3, 0x80, 0x6F, 0xEC, 0x7B, 0x60, 0xDB, 0x32, 0x34, 0x81, 0xC1, 0xF1, 0xFE,
  /* RLE: 054 Pixels @ 184,106 */ 54, 0xFF,
  /* ABS: 012 Pixels @ 238,106 */ 0, 12, 0xFE, 0xE0, 0x82, 0x30, 0x50, 0x8F, 0x97, 0x85, 0x8C, 0xBA, 0xE6, 0xFE,
  /* RLE: 006 Pixels @ 250,106 */ 6, 0xFF,
  /* ABS: 003 Pixels @ 256,106 */ 0, 3, 0xA9, 0x31, 0xFA,
  /* RLE: 006 Pixels @ 259,106 */ 6, 0xFF,
  /* ABS: 021 Pixels @ 265,106 */ 0, 21, 0xBB, 0x31, 0x33, 0x03, 0x92, 0xEB, 0x38, 0x95, 0xFF, 0xFF, 0xAC, 0x33, 0xE8, 0xFE, 0x42, 0xA1, 0xF8, 0x44, 0x68, 0x37, 0xE7,
  /* RLE: 028 Pixels @ 286,106 */ 28, 0xFF,
  /* ABS: 006 Pixels @ 014,107 */ 0, 6, 0xE4, 0x2F, 0x9E, 0x71, 0x47, 0xEF,
  /* RLE: 009 Pixels @ 020,107 */ 9, 0xFF,
  /* ABS: 077 Pixels @ 029,107 */ 0, 77, 0x72, 0x4F, 0x87, 0x55, 0xF8, 0xFF, 0xFC, 0xF5, 0xEF, 0xED, 0xE9, 0xE6, 0xDF, 0xDE, 0xD8, 0xC7, 0xC3, 0xB7, 0xAE, 0xAB, 0x9E, 0x95, 0x8A, 0x7F, 0x72, 0x64, 0x60, 0x53, 0x42, 0x3E, 0x39, 0x3B, 0x3E, 0x3C, 0x3F,
        0x41, 0x3F, 0x3D, 0x3D, 0x42, 0x41, 0x43, 0x4C, 0x4B, 0x4B, 0x47, 0x2D, 0x25, 0x51, 0x44, 0x16, 0xB5, 0xED, 0xEE, 0xEE, 0xEE, 0xF0, 0xF0, 0xF3, 0xF4, 0x95, 0x43, 0xED, 0xF7, 0xF9, 0xFB, 0xFA, 0xFC, 0xFC, 0xFC, 0xFB, 0xFC, 0xCA, 0x1B, 0xD7, 0xFE,
        0xFE,
  /* RLE: 004 Pixels @ 106,107 */ 4, 0xFF,
  /* ABS: 008 Pixels @ 110,107 */ 0, 8, 0xFE, 0xFF, 0xFF, 0xFF, 0xFC, 0xA9, 0x32, 0xDC,
  /* RLE: 022 Pixels @ 118,107 */ 22, 0xFF,
  /* ABS: 021 Pixels @ 140,107 */ 0, 21, 0x51, 0x7D, 0x99, 0x39, 0xFA, 0xFF, 0xFF, 0xFF, 0xC4, 0x2B, 0xB9, 0xFE, 0xFB, 0x3F, 0x07, 0x5B, 0x73, 0x37, 0x68, 0x2F, 0xA7,
  /* RLE: 010 Pixels @ 161,107 */ 10, 0xFF,
  /* ABS: 010 Pixels @ 171,107 */ 0, 10, 0xBB, 0x7B, 0x6B, 0xF1, 0x6B, 0x5E, 0xDB, 0x32, 0xA7, 0xFC,
  /* RLE: 056 Pixels @ 181,107 */ 56, 0xFF,
  /* ABS: 010 Pixels @ 237,107 */ 0, 10, 0xF2, 0xA3, 0x3D, 0x52, 0x9C, 0x8F, 0x8A, 0xBD, 0xE5, 0xF9,
  /* RLE: 008 Pixels @ 247,107 */ 8, 0xFF,
  /* ABS: 004 Pixels @ 255,107 */ 0, 4, 0xFE, 0x7C, 0x5D, 0xFD,
  /* RLE: 006 Pixels @ 259,107 */ 6, 0xFF,
  /* ABS: 021 Pixels @ 265,107 */ 0, 21, 0xF1, 0x2C, 0x5F, 0x03, 0x7A, 0x56, 0x6A, 0xEE, 0xFF, 0xDE, 0x44, 0x9F, 0xFD, 0xC7, 0x34, 0xDD, 0xBC, 0x40, 0x6B, 0x68, 0xFA,
  /* RLE: 028 Pixels @ 286,107 */ 28, 0xFF,
  /* ABS: 006 Pixels @ 014,108 */ 0, 6, 0xE8, 0x38, 0x87, 0xC7, 0x12, 0xBF,
  /* RLE: 009 Pixels @ 020,108 */ 9, 0xFF,
  /* ABS: 005 Pixels @ 029,108 */ 0, 5, 0xC5, 0x2E, 0x7B, 0x3F, 0xE7,
  /* RLE: 022 Pixels @ 034,108 */ 22, 0xFF,
  /* ABS: 025 Pixels @ 056,108 */ 0, 25, 0xFD, 0xFA, 0xF4, 0xEB, 0xE9, 0xE5, 0xDC, 0xD9, 0xD7, 0xD1, 0xC9, 0xC4, 0xBB, 0xB7, 0xB3, 0xB0, 0xB0, 0xB0, 0xC3, 0xC6, 0xB2, 0x98, 0x8F, 0xBE, 0xF6,
  /* RLE: 008 Pixels @ 081,108 */ 8, 0xFF,
  /* ABS: 003 Pixels @ 089,108 */ 0, 3, 0x9C, 0x46, 0xF7,
  /* RLE: 009 Pixels @ 092,108 */ 9, 0xFF,
  /* ABS: 003 Pixels @ 101,108 */ 0, 3, 0x99, 0x39, 0xF2,
  /* RLE: 010 Pixels @ 104,108 */ 10, 0xFF,
  /* ABS: 004 Pixels @ 114,108 */ 0, 4, 0xF8, 0x67, 0x5D, 0xF8,
  /* RLE: 022 Pixels @ 118,108 */ 22, 0xFF,
  /* ABS: 027 Pixels @ 140,108 */ 0, 27, 0x4A, 0x7B, 0x98, 0x3C, 0xF5, 0xFF, 0xFF, 0xE0, 0x3B, 0x6A, 0xFD, 0xFF, 0xFF, 0xB0, 0x14, 0x08, 0x3C, 0x79, 0x58, 0x45, 0xF0, 0xFF, 0xFF, 0xFB, 0xF7, 0xF7, 0xFD,
  /* RLE: 004 Pixels @ 167,108 */ 4, 0xFF,
  /* ABS: 009 Pixels @ 171,108 */ 0, 9, 0xB0, 0x8B, 0x73, 0xF3, 0x59, 0x73, 0xDF, 0x32, 0xB3,
  /* RLE: 056 Pixels @ 180,108 */ 56, 0xFF,
  /* ABS: 022 Pixels @ 236,108 */ 0, 22, 0xF3, 0x69, 0x36, 0xA6, 0xDD, 0x94, 0xC0, 0xF7, 0xFE, 0xFA, 0xF6, 0xEB, 0xE9, 0xD7, 0xCA, 0xCA, 0xBA, 0xB0, 0x9F, 0x86, 0x2D, 0x98,
  /* RLE: 008 Pixels @ 258,108 */ 8, 0xFF,
  /* ABS: 019 Pixels @ 266,108 */ 0, 19, 0x72, 0x49, 0x2B, 0x1F, 0x7B, 0xF1, 0xFF, 0xFA, 0x5F, 0x50, 0xF6, 0xF4, 0x5D, 0x86, 0xF1, 0x58, 0x82, 0x4E, 0xA3,
  /* RLE: 029 Pixels @ 285,108 */ 29, 0xFF,
  /* ABS: 007 Pixels @ 014,109 */ 0, 7, 0xF2, 0x53, 0x61, 0xF3, 0x5D, 0x41, 0xE6,
  /* RLE: 008 Pixels @ 021,109 */ 8, 0xFF,
  /* ABS: 005 Pixels @ 029,109 */ 0, 5, 0xF9, 0x59, 0x5A, 0x30, 0xAE,
  /* RLE: 054 Pixels @ 034,109 */ 54, 0xFF,
  /* ABS: 004 Pixels @ 088,109 */ 0, 4, 0xFB, 0x77, 0x58, 0xFC,
  /* RLE: 008 Pixels @ 092,109 */ 8, 0xFF,
  /* ABS: 004 Pixels @ 100,109 */ 0, 4, 0xFE, 0x63, 0x6C, 0xFB,
  /* RLE: 010 Pixels @ 104,109 */ 10, 0xFF,
  /* ABS: 003 Pixels @ 114,109 */ 0, 3, 0xD7, 0x27, 0xB5,
  /* RLE: 022 Pixels @ 117,109 */ 22, 0xFF,
  /* ABS: 041 Pixels @ 139,109 */ 0, 41, 0xF6, 0x30, 0xA0, 0xCB, 0x2C, 0x7D, 0xF3, 0xC8, 0x3B, 0x6E, 0xF0, 0xFF, 0xFF, 0xFF, 0xFE, 0xBF, 0x4A, 0x3C, 0x3C, 0x72, 0xE2, 0xFE, 0xBF, 0x5E, 0x34, 0x24, 0x27, 0x33, 0x68, 0xE6, 0xFF, 0xFF, 0x99, 0x8E, 0x79,
        0xE7, 0x43, 0x96, 0xE2, 0x32, 0xB2,
  /* RLE: 050 Pixels @ 180,109 */ 50, 0xFF,
  /* ABS: 028 Pixels @ 230,109 */ 0, 28, 0xFE, 0xFC, 0xFA, 0xFB, 0xFB, 0xF3, 0x6A, 0x37, 0xB0, 0xB1, 0x86, 0x6B, 0x4C, 0x3F, 0x31, 0x23, 0x29, 0x2F, 0x33, 0x35, 0x3B, 0x3B, 0x42, 0x47, 0x4B, 0x62, 0xA8, 0xF5,
  /* RLE: 008 Pixels @ 258,109 */ 8, 0xFF,
  /* ABS: 019 Pixels @ 266,109 */ 0, 19, 0xD5, 0x31, 0x4F, 0x4A, 0xEA, 0xF6, 0xC4, 0x52, 0x59, 0xE4, 0xFF, 0xA6, 0x2F, 0xF2, 0xA4, 0x36, 0xB1, 0x2E, 0xF1,
  /* RLE: 029 Pixels @ 285,109 */ 29, 0xFF,
  /* ABS: 009 Pixels @ 014,110 */ 0, 9, 0xFB, 0x6A, 0x4A, 0xF4, 0xD1, 0x2D, 0x55, 0xE0, 0xFA,
  /* RLE: 007 Pixels @ 023,110 */ 7, 0xFF,
  /* ABS: 005 Pixels @ 030,110 */ 0, 5, 0xAB, 0x2C, 0x5E, 0x54, 0xFC,
  /* RLE: 053 Pixels @ 035,110 */ 53, 0xFF,
  /* ABS: 003 Pixels @ 088,110 */ 0, 3, 0xF4, 0x51, 0x7A,
  /* RLE: 007 Pixels @ 091,110 */ 7, 0xFF,
  /* ABS: 006 Pixels @ 098,110 */ 0, 6, 0xFE, 0xF5, 0xF5, 0x43, 0x85, 0xFE,
  /* RLE: 009 Pixels @ 104,110 */ 9, 0xFF,
  /* ABS: 004 Pixels @ 113,110 */ 0, 4, 0xFE, 0x8E, 0x34, 0xF2,
  /* RLE: 022 Pixels @ 117,110 */ 22, 0xFF,
  /* ABS: 010 Pixels @ 139,110 */ 0, 10, 0xDA, 0x19, 0x75, 0xF9, 0xA7, 0x2A, 0x45, 0x37, 0x84, 0xEE,
  /* RLE: 005 Pixels @ 149,110 */ 5, 0xFF,
  /* ABS: 026 Pixels @ 154,110 */ 0, 26, 0xFE, 0xF0, 0xE6, 0xE5, 0xFA, 0xFE, 0xBA, 0x37, 0x7E, 0xCB, 0xCE, 0xCE, 0x80, 0x1C, 0xD9, 0xFF, 0xFE, 0x80, 0x8B, 0x8B, 0xD7, 0x32, 0xB7, 0xE3, 0x32, 0xA5,
  /* RLE: 007 Pixels @ 180,110 */ 7, 0xFF,
  /* ABS: 011 Pixels @ 187,110 */ 0, 11, 0xFE, 0xFD, 0xFA, 0xF6, 0xF3, 0xF0, 0xF0, 0xF0, 0xF2, 0xF7, 0xFD,
  /* RLE: 022 Pixels @ 198,110 */ 22, 0xFF,
  /* ABS: 036 Pixels @ 220,110 */ 0, 36, 0xFD, 0xF6, 0xF0, 0xE9, 0xE1, 0xD1, 0xAE, 0x90, 0x7D, 0x72, 0x66, 0x5A, 0x4F, 0x57, 0x55, 0x55, 0x12, 0x13, 0x1E, 0x16, 0x13, 0x19, 0x22, 0x25, 0x22, 0x0E, 0x96, 0xDA, 0xDD, 0xDF, 0xE4, 0xE4, 0xEA, 0xEE, 0xF2,
        0xF9,
  /* RLE: 010 Pixels @ 256,110 */ 10, 0xFF,
  /* ABS: 018 Pixels @ 266,110 */ 0, 18, 0xFC, 0x89, 0x3C, 0x2D, 0x4A, 0x53, 0x3C, 0x7A, 0xE5, 0xFE, 0xD5, 0x3F, 0xA1, 0xCC, 0x40, 0xAE, 0x7B, 0x69,
  /* RLE: 030 Pixels @ 284,110 */ 30, 0xFF,
  /* ABS: 011 Pixels @ 014,111 */ 0, 11, 0xFE, 0x7F, 0x3D, 0xE9, 0xFF, 0xBB, 0x29, 0x24, 0x81, 0xD0, 0xFD,
  /* RLE: 005 Pixels @ 025,111 */ 5, 0xFF,
  /* ABS: 005 Pixels @ 030,111 */ 0, 5, 0xEA, 0x33, 0x85, 0x2C, 0xD0,
  /* RLE: 053 Pixels @ 035,111 */ 53, 0xFF,
  /* ABS: 003 Pixels @ 088,111 */ 0, 3, 0xE1, 0x1F, 0xC2,
  /* RLE: 006 Pixels @ 091,111 */ 6, 0xFF,
  /* ABS: 007 Pixels @ 097,111 */ 0, 7, 0xF4, 0xAE, 0x59, 0xBD, 0x51, 0x7C, 0xFC,
  /* RLE: 009 Pixels @ 104,111 */ 9, 0xFF,
  /* ABS: 004 Pixels @ 113,111 */ 0, 4, 0xDF, 0x35, 0x94, 0xFE,
  /* RLE: 022 Pixels @ 117,111 */ 22, 0xFF,
  /* ABS: 008 Pixels @ 139,111 */ 0, 8, 0xA7, 0x09, 0x3F, 0xFE, 0xFC, 0xD2, 0xA9, 0xD2,
  /* RLE: 012 Pixels @ 147,111 */ 12, 0xFF,
  /* ABS: 042 Pixels @ 159,111 */ 0, 42, 0xEB, 0x35, 0x94, 0xFC, 0xFF, 0xFF, 0xFF, 0x9D, 0x2D, 0xF9, 0xFF, 0xFC, 0x63, 0x77, 0xB0, 0xC7, 0x25, 0xD9, 0xE3, 0x32, 0xAB, 0xFF, 0xFF, 0xFE, 0xF9, 0xE0, 0xBF, 0xA8, 0x91, 0x7E, 0x69, 0x5A, 0x4E, 0x3E, 0x3E,
        0x3E, 0x48, 0x5F, 0x7D, 0xA2, 0xD0, 0xFE,
  /* RLE: 014 Pixels @ 201,111 */ 14, 0xFF,
  /* ABS: 033 Pixels @ 215,111 */ 0, 33, 0xFE, 0xF4, 0xD9, 0xB7, 0x9A, 0x7C, 0x58, 0x40, 0x29, 0x34, 0x3F, 0x53, 0x65, 0x6E, 0x80, 0x9A, 0xA2, 0xB0, 0xB6, 0xAB, 0x95, 0x7D, 0x7B, 0x88, 0xAE, 0xCA, 0xE0, 0xF0, 0xF5, 0xF1, 0x58, 0x4C, 0xFB,
  /* RLE: 019 Pixels @ 248,111 */ 19, 0xFF,
  /* ABS: 017 Pixels @ 267,111 */ 0, 17, 0xEF, 0x43, 0x3E, 0x13, 0x7D, 0xE4, 0xFF, 0xFF, 0xD4, 0x36, 0x80, 0xD9, 0x37, 0x80, 0xE6, 0x34, 0xBE,
  /* RLE: 031 Pixels @ 284,111 */ 31, 0xFF,
  /* ABS: 021 Pixels @ 015,112 */ 0, 21, 0x9F, 0x34, 0xDF, 0xFF, 0xFD, 0xD7, 0x4C, 0x12, 0x14, 0x4C, 0x8F, 0xCC, 0xE7, 0xFC, 0xFF, 0xDC, 0x61, 0x4C, 0x65, 0x6A, 0xF6,
  /* RLE: 052 Pixels @ 036,112 */ 52, 0xFF,
  /* ABS: 016 Pixels @ 088,112 */ 0, 16, 0x9A, 0x3A, 0xED, 0xFF, 0xFF, 0xFF, 0xFD, 0xDD, 0x99, 0x42, 0x48, 0x99, 0xF1, 0x80, 0x3D, 0xEF,
  /* RLE: 008 Pixels @ 104,112 */ 8, 0xFF,
  /* ABS: 004 Pixels @ 112,112 */ 0, 4, 0xF0, 0x5F, 0x50, 0xF1,
  /* RLE: 022 Pixels @ 116,112 */ 22, 0xFF,
  /* ABS: 005 Pixels @ 138,112 */ 0, 5, 0xF8, 0x64, 0x01, 0x18, 0xF4,
  /* RLE: 007 Pixels @ 143,112 */ 7, 0xFF,
  /* ABS: 012 Pixels @ 150,112 */ 0, 12, 0xE0, 0xA2, 0x66, 0x6D, 0xAF, 0xF7, 0xFF, 0xFF, 0xFF, 0xB5, 0x31, 0xE7,
  /* RLE: 004 Pixels @ 162,112 */ 4, 0xFF,
  /* ABS: 037 Pixels @ 166,112 */ 0, 37, 0x57, 0x6F, 0xFF, 0xFF, 0xEF, 0x61, 0x6A, 0xCF, 0xA4, 0x22, 0xF6, 0xE2, 0x30, 0x84, 0x9E, 0x72, 0x4E, 0x3B, 0x3B, 0x40, 0x4A, 0x69, 0x84, 0x9A, 0xA9, 0xAC, 0xA8, 0x9F, 0x9F, 0x94, 0x87, 0x66, 0x46, 0x37, 0x53,
        0xB8, 0xF7,
  /* RLE: 005 Pixels @ 203,112 */ 5, 0xFF,
  /* ABS: 022 Pixels @ 208,112 */ 0, 22, 0xFE, 0xF9, 0xE2, 0xD1, 0xBC, 0x94, 0x66, 0x4D, 0x3A, 0x3E, 0x46, 0x58, 0x85, 0xA7, 0xBF, 0xD5, 0xEA, 0xF0, 0xF5, 0xF9, 0xFB, 0xFE,
  /* RLE: 005 Pixels @ 230,112 */ 5, 0xFF,
  /* ABS: 004 Pixels @ 235,112 */ 0, 4, 0xFE, 0xFD, 0xFC, 0xFE,
  /* RLE: 006 Pixels @ 239,112 */ 6, 0xFF,
  /* ABS: 004 Pixels @ 245,112 */ 0, 4, 0xC4, 0x28, 0xAF, 0xFE,
  /* RLE: 018 Pixels @ 249,112 */ 18, 0xFF,
  /* ABS: 017 Pixels @ 267,112 */ 0, 17, 0xFE, 0xCD, 0x38, 0x27, 0x28, 0x7A, 0xAF, 0x77, 0x3A, 0x91, 0xB6, 0x41, 0x7C, 0xEC, 0x7B, 0x62, 0xF6,
  /* RLE: 031 Pixels @ 284,112 */ 31, 0xFF,
  /* ABS: 021 Pixels @ 015,113 */ 0, 21, 0xB6, 0x26, 0xD1, 0xFF, 0xFF, 0xFF, 0xED, 0x9F, 0x2F, 0x06, 0x03, 0x19, 0x3C, 0x6D, 0x95, 0x40, 0x11, 0x2E, 0xB0, 0x29, 0xDF,
  /* RLE: 051 Pixels @ 036,113 */ 51, 0xFF,
  /* ABS: 028 Pixels @ 087,113 */ 0, 28, 0xF3, 0x4D, 0x85, 0xFC, 0xFF, 0xFA, 0xD7, 0x7D, 0x38, 0x54, 0xA7, 0xE8, 0xFA, 0xB7, 0x3B, 0x0D, 0x87, 0xF2, 0xFE, 0xFF, 0xFF, 0xFF, 0xFD, 0xF9, 0xD0, 0x63, 0x44, 0xD2,
  /* RLE: 023 Pixels @ 115,113 */ 23, 0xFF,
  /* ABS: 005 Pixels @ 138,113 */ 0, 5, 0xEE, 0x39, 0x00, 0x05, 0xC6,
  /* RLE: 005 Pixels @ 143,113 */ 5, 0xFF,
  /* ABS: 072 Pixels @ 148,113 */ 0, 72, 0xFB, 0xBE, 0x35, 0x47, 0x80, 0x72, 0x28, 0x92, 0xF9, 0xFF, 0xFF, 0x8B, 0x4A, 0xF3, 0xFF, 0xFF, 0xFF, 0xF6, 0x24, 0xA7, 0xFF, 0xFF, 0xBE, 0x6E, 0x64, 0xEF, 0x6E, 0x52, 0xFE, 0xDB, 0x26, 0x18, 0x50, 0x78, 0x9B,
        0xBD, 0xD4, 0xE0, 0xEC, 0xDF, 0xB5, 0x92, 0x86, 0x7D, 0x89, 0x88, 0x90, 0x86, 0x8C, 0x7E, 0x7D, 0x8C, 0x6C, 0x28, 0x94, 0xF7, 0xF8, 0xF5, 0xD8, 0xAB, 0x7D, 0x5A, 0x3B, 0x2B, 0x3C, 0x6B, 0x8E, 0xAD, 0xCA, 0xDD, 0xF0, 0xF9,
  /* RLE: 025 Pixels @ 220,113 */ 25, 0xFF,
  /* ABS: 004 Pixels @ 245,113 */ 0, 4, 0xF8, 0x6B, 0x48, 0xEE,
  /* RLE: 020 Pixels @ 249,113 */ 20, 0xFF,
  /* ABS: 014 Pixels @ 269,113 */ 0, 14, 0xBD, 0x2C, 0x28, 0x4B, 0x4E, 0x7B, 0xB9, 0x9C, 0x36, 0x87, 0xF6, 0xD7, 0x2D, 0xC3,
  /* RLE: 032 Pixels @ 283,113 */ 32, 0xFF,
  /* ABS: 003 Pixels @ 015,114 */ 0, 3, 0xD6, 0x11, 0xB3,
  /* RLE: 005 Pixels @ 018,114 */ 5, 0xFF,
  /* ABS: 013 Pixels @ 023,114 */ 0, 13, 0xF5, 0xB3, 0x61, 0x24, 0x05, 0x00, 0x00, 0x48, 0x7C, 0x5A, 0xCF, 0x21, 0xD0,
  /* RLE: 051 Pixels @ 036,114 */ 51, 0xFF,
  /* ABS: 027 Pixels @ 087,114 */ 0, 27, 0xB0, 0x31, 0xE2, 0xE6, 0xA8, 0x45, 0x2F, 0x70, 0xCF, 0xFB, 0xEE, 0xAD, 0x4E, 0x38, 0x9E, 0xB9, 0x36, 0x38, 0x8A, 0xB1, 0xB9, 0x9D, 0x74, 0x3A, 0x39, 0x7B, 0xEF,
  /* RLE: 024 Pixels @ 114,114 */ 24, 0xFF,
  /* ABS: 005 Pixels @ 138,114 */ 0, 5, 0xC8, 0x0A, 0x08, 0x02, 0x8F,
  /* RLE: 004 Pixels @ 143,114 */ 4, 0xFF,
  /* ABS: 046 Pixels @ 147,114 */ 0, 46, 0xF1, 0x74, 0x2E, 0xAE, 0xF8, 0xFF, 0xFF, 0xB6, 0x16, 0xC2, 0xFF, 0xFF, 0x7E, 0x59, 0xF6, 0xFF, 0xFF, 0xFF, 0xA1, 0x38, 0xE3, 0xFF, 0xFE, 0x81, 0x92, 0x7E, 0xFD, 0x33, 0x95, 0xFF, 0xCF, 0x15, 0x66, 0xFB, 0xF4,
        0xC9, 0xAE, 0x98, 0x81, 0x83, 0x9E, 0xB6, 0xCA, 0xEB, 0xF7, 0xFD,
  /* RLE: 004 Pixels @ 193,114 */ 4, 0xFF,
  /* ABS: 016 Pixels @ 197,114 */ 0, 16, 0xFB, 0xDE, 0xA4, 0x91, 0xA3, 0x19, 0x4B, 0x34, 0x2D, 0x37, 0x51, 0x77, 0xAE, 0xD1, 0xEE, 0xFD,
  /* RLE: 033 Pixels @ 213,114 */ 33, 0xFF,
  /* ABS: 003 Pixels @ 246,114 */ 0, 3, 0xDF, 0x21, 0x99,
  /* RLE: 021 Pixels @ 249,114 */ 21, 0xFF,
  /* ABS: 013 Pixels @ 270,114 */ 0, 13, 0xE3, 0x64, 0x33, 0x6F, 0x94, 0x46, 0x47, 0xC2, 0xFE, 0xF0, 0x5E, 0x7C, 0xFA,
  /* RLE: 031 Pixels @ 283,114 */ 31, 0xFF,
  /* ABS: 004 Pixels @ 014,115 */ 0, 4, 0xFE, 0xE1, 0x10, 0x99,
  /* RLE: 007 Pixels @ 018,115 */ 7, 0xFF,
  /* ABS: 024 Pixels @ 025,115 */ 0, 24, 0xF6, 0xDD, 0xAB, 0x73, 0x4A, 0x33, 0x33, 0x3C, 0x42, 0x1C, 0x86, 0xA6, 0xB0, 0xC1, 0xC6, 0xD4, 0xDC, 0xE6, 0xE9, 0xEE, 0xF3, 0xF5, 0xFB, 0xFD,
  /* RLE: 037 Pixels @ 049,115 */ 37, 0xFF,
  /* ABS: 027 Pixels @ 086,115 */ 0, 27, 0xFC, 0x52, 0x3F, 0x80, 0x3F, 0x44, 0x8C, 0xD8, 0xF1, 0xDA, 0x9B, 0x40, 0x2B, 0x60, 0xA8, 0x9F, 0x85, 0x44, 0x13, 0x1C, 0x31, 0x46, 0x5B, 0x78, 0xAA, 0xE4, 0xFA,
  /* RLE: 024 Pixels @ 113,115 */ 24, 0xFF,
  /* ABS: 051 Pixels @ 137,115 */ 0, 51, 0xFE, 0x85, 0x4E, 0x5E, 0x00, 0x54, 0xF2, 0xFF, 0xFF, 0xF5, 0x76, 0x39, 0xBE, 0xFE, 0xFF, 0xFF, 0xFF, 0xF7, 0x55, 0x6A, 0xFC, 0xFF, 0x82, 0x4E, 0xF4, 0xFF, 0xFF, 0xEF, 0x4E, 0x75, 0xFB, 0xFF, 0xE7, 0x5D, 0x98,
        0xA9, 0xD6, 0x23, 0xBE, 0xFF, 0xC3, 0x09, 0x8F, 0xFD, 0xBD, 0x86, 0xB1, 0xDD, 0xEA, 0xF6, 0xFE,
  /* RLE: 012 Pixels @ 188,115 */ 12, 0xFF,
  /* ABS: 009 Pixels @ 200,115 */ 0, 9, 0xF2, 0xE0, 0x2E, 0x20, 0x90, 0xD2, 0xE6, 0xF3, 0xFD,
  /* RLE: 037 Pixels @ 209,115 */ 37, 0xFF,
  /* ABS: 004 Pixels @ 246,115 */ 0, 4, 0xFC, 0x8F, 0x31, 0xCC,
  /* RLE: 021 Pixels @ 250,115 */ 21, 0xFF,
  /* ABS: 011 Pixels @ 271,115 */ 0, 11, 0xF3, 0xBE, 0x72, 0x5D, 0x91, 0xEC, 0xFE, 0xFC, 0x87, 0x44, 0xE7,
  /* RLE: 031 Pixels @ 282,115 */ 31, 0xFF,
  /* ABS: 005 Pixels @ 013,116 */ 0, 5, 0xFC, 0xB9, 0x42, 0x41, 0xCC,
  /* RLE: 011 Pixels @ 018,116 */ 11, 0xFF,
  /* ABS: 029 Pixels @ 029,116 */ 0, 29, 0xF9, 0xDE, 0xC8, 0xB2, 0x9A, 0x83, 0x64, 0x4E, 0x3D, 0x35, 0x2D, 0x2B, 0x26, 0x34, 0x3C, 0x47, 0x51, 0x56, 0x63, 0x70, 0x8D, 0xA3, 0xB5, 0xC4, 0xCD, 0xDD, 0xE5, 0xF5, 0xF6,
  /* RLE: 028 Pixels @ 058,116 */ 28, 0xFF,
  /* ABS: 023 Pixels @ 086,116 */ 0, 23, 0xC8, 0x15, 0x36, 0x6F, 0xB7, 0xDE, 0xD3, 0xA7, 0x61, 0x25, 0x03, 0x01, 0x21, 0x35, 0x39, 0x55, 0x7E, 0x9F, 0xB5, 0xC9, 0xE0, 0xF7, 0xFE,
  /* RLE: 028 Pixels @ 109,116 */ 28, 0xFF,
  /* ABS: 012 Pixels @ 137,116 */ 0, 12, 0xEE, 0x43, 0x96, 0xB5, 0x0A, 0x1B, 0xD6, 0xFF, 0xFF, 0xC2, 0x1D, 0xC7,
  /* RLE: 006 Pixels @ 149,116 */ 6, 0xFF,
  /* ABS: 027 Pixels @ 155,116 */ 0, 27, 0xA6, 0x33, 0xE5, 0xFF, 0x99, 0x38, 0xEF, 0xFF, 0xFF, 0xB8, 0x20, 0xDA, 0xFF, 0xFF, 0xCA, 0x80, 0x67, 0xCF, 0x96, 0x42, 0xEA, 0xFF, 0x98, 0x01, 0x96, 0xFF, 0xFE,
  /* RLE: 016 Pixels @ 182,116 */ 16, 0xFF,
  /* ABS: 007 Pixels @ 198,116 */ 0, 7, 0xFD, 0xE9, 0xB5, 0x5C, 0x26, 0xB5, 0xFD,
  /* RLE: 042 Pixels @ 205,116 */ 42, 0xFF,
  /* ABS: 004 Pixels @ 247,116 */ 0, 4, 0xF1, 0x4E, 0x4B, 0xFA,
  /* RLE: 026 Pixels @ 251,116 */ 26, 0xFF,
  /* ABS: 004 Pixels @ 277,116 */ 0, 4, 0xFC, 0xAC, 0x2F, 0xC2,
  /* RLE: 031 Pixels @ 281,116 */ 31, 0xFF,
  /* ABS: 006 Pixels @ 012,117 */ 0, 6, 0xF1, 0x79, 0x1C, 0x76, 0xEA, 0xFE,
  /* RLE: 016 Pixels @ 018,117 */ 16, 0xFF,
  /* ABS: 069 Pixels @ 034,117 */ 0, 69, 0xFE, 0xFC, 0xFA, 0xF9, 0xF8, 0xF8, 0xF3, 0xED, 0xE2, 0xD0, 0xBB, 0xAD, 0xA3, 0x8F, 0x7F, 0x70, 0x62, 0x4E, 0x47, 0x40, 0x36, 0x2F, 0x28, 0x23, 0x3E, 0x44, 0x51, 0x5B, 0x68, 0x71, 0x74, 0x81, 0x89, 0x8F, 0x94,
        0x9D, 0x9F, 0xAD, 0xAA, 0xA9, 0xAE, 0xB0, 0xB3, 0xAA, 0xA8, 0xA4, 0x9D, 0x94, 0x98, 0x8B, 0x7C, 0x75, 0x2C, 0x1C, 0x4A, 0x45, 0x2F, 0x2D, 0x38, 0x49, 0x5F, 0x7C, 0x94, 0xB3, 0xE5, 0xF4, 0xF9, 0xFB, 0xFE,
  /* RLE: 034 Pixels @ 103,117 */ 34, 0xFF,
  /* ABS: 012 Pixels @ 137,117 */ 0, 12, 0xB9, 0x2D, 0xD9, 0xED, 0x48, 0x01, 0x8F, 0xFF, 0xFF, 0xBD, 0x1A, 0xCD,
  /* RLE: 006 Pixels @ 149,117 */ 6, 0xFF,
  /* ABS: 025 Pixels @ 155,117 */ 0, 25, 0xD6, 0x32, 0xBF, 0xFF, 0xC0, 0x12, 0xDE, 0xFF, 0xE3, 0x40, 0x8A, 0xFD, 0xFF, 0xFF, 0x8D, 0xAE, 0x62, 0xE3, 0x48, 0x88, 0xFE, 0xFF, 0x69, 0x00, 0x8D,
  /* RLE: 005 Pixels @ 180,117 */ 5, 0xFF,
  /* ABS: 019 Pixels @ 185,117 */ 0, 19, 0xFC, 0xFA, 0xF9, 0xF0, 0xEC, 0xE2, 0xDA, 0xD2, 0xC4, 0xB0, 0x97, 0x7A, 0x5E, 0x3F, 0x2D, 0x4D, 0x94, 0xE7, 0xFE,
  /* RLE: 044 Pixels @ 204,117 */ 44, 0xFF,
  /* ABS: 004 Pixels @ 248,117 */ 0, 4, 0xD0, 0x2D, 0x7E, 0xF4,
  /* RLE: 024 Pixels @ 252,117 */ 24, 0xFF,
  /* ABS: 005 Pixels @ 276,117 */ 0, 5, 0xF2, 0x84, 0x2F, 0xCE, 0xFE,
  /* RLE: 030 Pixels @ 281,117 */ 30, 0xFF,
  /* ABS: 006 Pixels @ 011,118 */ 0, 6, 0xEF, 0x75, 0x08, 0x08, 0x38, 0xDD,
  /* RLE: 017 Pixels @ 017,118 */ 17, 0xFF,
  /* ABS: 003 Pixels @ 034,118 */ 0, 3, 0xF4, 0xF7, 0xFC,
  /* RLE: 012 Pixels @ 037,118 */ 12, 0xFF,
  /* ABS: 047 Pixels @ 049,118 */ 0, 47, 0xFE, 0xFC, 0xF3, 0xED, 0xE7, 0xDE, 0xD8, 0xD0, 0xCA, 0xC3, 0xBD, 0xB2, 0xA8, 0x9F, 0x8A, 0x7F, 0x72, 0x66, 0x65, 0x5D, 0x59, 0x52, 0x52, 0x4C, 0x48, 0x53, 0x4F, 0x4C, 0x50, 0x51, 0x56, 0x59, 0x5E, 0x65, 0x74,
        0x76, 0x8F, 0xA2, 0xB5, 0xBE, 0xC6, 0xD1, 0xD6, 0xE0, 0xEF, 0xFB, 0xFE,
  /* RLE: 038 Pixels @ 096,118 */ 38, 0xFF,
  /* ABS: 016 Pixels @ 134,118 */ 0, 16, 0xFE, 0xFC, 0xFA, 0x6B, 0x52, 0xFE, 0xFE, 0x9C, 0x00, 0x43, 0xF6, 0xFF, 0xF0, 0x50, 0x4B, 0xE2,
  /* RLE: 005 Pixels @ 150,118 */ 5, 0xFF,
  /* ABS: 047 Pixels @ 155,118 */ 0, 47, 0xF6, 0x39, 0x8E, 0xFE, 0xE4, 0x1F, 0xBF, 0xF4, 0x63, 0x52, 0xEC, 0xFF, 0xFF, 0xE4, 0x6B, 0x96, 0x9E, 0xC5, 0x18, 0xBC, 0xF9, 0xF9, 0x42, 0x01, 0x4F, 0x7E, 0x78, 0x70, 0x70, 0x6E, 0x5B, 0x4B, 0x4B, 0x45, 0x44,
        0x3D, 0x3B, 0x38, 0x3C, 0x45, 0x53, 0x71, 0x98, 0xBD, 0xD4, 0xEF, 0xFE,
  /* RLE: 046 Pixels @ 202,118 */ 46, 0xFF,
  /* ABS: 005 Pixels @ 248,118 */ 0, 5, 0xFC, 0xB3, 0x1C, 0x9A, 0xF9,
  /* RLE: 019 Pixels @ 253,118 */ 19, 0xFF,
  /* ABS: 007 Pixels @ 272,118 */ 0, 7, 0xFD, 0xFA, 0xF2, 0xCB, 0x5D, 0x44, 0xBF,
  /* RLE: 032 Pixels @ 279,118 */ 32, 0xFF,
  /* ABS: 006 Pixels @ 011,119 */ 0, 6, 0x8D, 0x07, 0x28, 0x2F, 0x4F, 0xFA,
  /* RLE: 016 Pixels @ 017,119 */ 16, 0xFF,
  /* ABS: 009 Pixels @ 033,119 */ 0, 9, 0xF5, 0x58, 0x5B, 0x74, 0xAB, 0xC7, 0xE2, 0xF8, 0xFE,
  /* RLE: 034 Pixels @ 042,119 */ 34, 0xFF,
  /* RLE: 001 Pixels @ 076,119 */ 1, 0xFE,
  /* RLE: 053 Pixels @ 077,119 */ 53, 0xFF,
  /* ABS: 021 Pixels @ 130,119 */ 0, 21, 0xFC, 0xE7, 0xCB, 0xAE, 0x86, 0x74, 0x68, 0x1A, 0xB6, 0xFF, 0xFF, 0xEB, 0x1D, 0x12, 0xBA, 0xFF, 0xFF, 0xD9, 0x2E, 0x51, 0xF6,
  /* RLE: 004 Pixels @ 151,119 */ 4, 0xFF,
  /* ABS: 040 Pixels @ 155,119 */ 0, 40, 0xFE, 0x52, 0x73, 0xFE, 0xF3, 0x4E, 0x68, 0x71, 0x3B, 0xD9, 0xFF, 0xFF, 0xFC, 0x8F, 0xA2, 0x63, 0xEC, 0x61, 0x17, 0x33, 0xD6, 0xC3, 0x26, 0x6C, 0x77, 0x72, 0x79, 0x7E, 0x7F, 0x92, 0x9A, 0x9D, 0xAB, 0xB0, 0xBB,
        0xC3, 0xD6, 0xE4, 0xF8, 0xFD,
  /* RLE: 055 Pixels @ 195,119 */ 55, 0xFF,
  /* ABS: 028 Pixels @ 250,119 */ 0, 28, 0x94, 0x1C, 0x69, 0x9F, 0xB2, 0xBF, 0xC1, 0xCF, 0xD2, 0xD1, 0xD2, 0xD2, 0xD2, 0xD1, 0xD1, 0xCE, 0xC0, 0xBE, 0xBE, 0xB2, 0xA4, 0x98, 0x7D, 0x69, 0x48, 0x31, 0x89, 0xE9,
  /* RLE: 032 Pixels @ 278,119 */ 32, 0xFF,
  /* ABS: 009 Pixels @ 010,120 */ 0, 9, 0xEB, 0x2C, 0x0B, 0xC2, 0x9F, 0x1C, 0x97, 0xE5, 0xFE,
  /* RLE: 013 Pixels @ 019,120 */ 13, 0xFF,
  /* ABS: 028 Pixels @ 032,120 */ 0, 28, 0xFB, 0x9A, 0x37, 0x8D, 0x76, 0x5B, 0x46, 0x38, 0x3A, 0x4A, 0x67, 0x81, 0x95, 0xA5, 0xB8, 0xCC, 0xD7, 0xDC, 0xE5, 0xE9, 0xF1, 0xF1, 0xF4, 0xFB, 0xFB, 0xFB, 0xFC, 0xFE,
  /* RLE: 009 Pixels @ 060,120 */ 9, 0xFF,
  /* ABS: 015 Pixels @ 069,120 */ 0, 15, 0xFD, 0xFB, 0xFD, 0xFC, 0xFC, 0xF9, 0xF5, 0xF3, 0xF1, 0xF1, 0xEE, 0xEE, 0xEE, 0xED, 0xF5,
  /* RLE: 041 Pixels @ 084,120 */ 41, 0xFF,
  /* ABS: 027 Pixels @ 125,120 */ 0, 27, 0xFE, 0xF4, 0xDA, 0xB0, 0x7B, 0x49, 0x34, 0x44, 0x56, 0x6C, 0x75, 0x67, 0x21, 0xD1, 0xFF, 0xFF, 0xFD, 0x76, 0x03, 0x53, 0xF8, 0xFF, 0xFF, 0xC6, 0x31, 0x67, 0xDF,
  /* RLE: 004 Pixels @ 152,120 */ 4, 0xFF,
  /* ABS: 028 Pixels @ 156,120 */ 0, 28, 0x63, 0x6B, 0xFD, 0xFE, 0x8D, 0x18, 0x54, 0xDE, 0xFE, 0xFF, 0xFF, 0xDF, 0x66, 0xA3, 0x8B, 0xC3, 0x1C, 0x05, 0x78, 0xEF, 0x55, 0x69, 0xF9, 0xFC, 0xFC, 0xFD, 0xFD, 0xFD,
  /* RLE: 066 Pixels @ 184,120 */ 66, 0xFF,
  /* ABS: 027 Pixels @ 250,120 */ 0, 27, 0xF9, 0xAF, 0x6A, 0x50, 0x46, 0x3F, 0x3B, 0x3F, 0x3A, 0x3E, 0x3E, 0x3E, 0x3C, 0x43, 0x43, 0x44, 0x41, 0x4B, 0x4E, 0x4D, 0x5A, 0x65, 0x76, 0x86, 0xB4, 0xE4, 0xFC,
  /* RLE: 033 Pixels @ 277,120 */ 33, 0xFF,
  /* ABS: 015 Pixels @ 010,121 */ 0, 15, 0xAC, 0x0A, 0x1F, 0xA9, 0xD1, 0x91, 0x23, 0x3C, 0x87, 0xC4, 0xE9, 0xFA, 0xFC, 0xFD, 0xFE,
  /* RLE: 006 Pixels @ 025,121 */ 6, 0xFF,
  /* ABS: 033 Pixels @ 031,121 */ 0, 33, 0xFC, 0xB2, 0x2C, 0xB2, 0xFE, 0xFF, 0xFC, 0xEB, 0xD0, 0xC0, 0xAF, 0x8B, 0x75, 0x58, 0x42, 0x35, 0x31, 0x2E, 0x33, 0x3D, 0x41, 0x4B, 0x4B, 0x4F, 0x57, 0x59, 0x59, 0x61, 0x7A, 0x81, 0x81, 0x81, 0x82,
  /* RLE: 005 Pixels @ 064,121 */ 5, 0x81,
  /* ABS: 016 Pixels @ 069,121 */ 0, 16, 0x6D, 0x5C, 0x6C, 0x65, 0x5D, 0x56, 0x50, 0x4E, 0x4B, 0x4B, 0x47, 0x48, 0x48, 0x47, 0x5B, 0xE0,
  /* RLE: 038 Pixels @ 085,121 */ 38, 0xFF,
  /* ABS: 055 Pixels @ 123,121 */ 0, 55, 0xFC, 0xE3, 0xA3, 0x50, 0x35, 0x3E, 0x7F, 0xAD, 0xC9, 0xE8, 0xFA, 0xF8, 0xB7, 0x51, 0x09, 0x86, 0xF0, 0xFE, 0xFF, 0xC8, 0x1C, 0x0C, 0xC5, 0xFF, 0xFF, 0xFD, 0xCE, 0x31, 0x40, 0xAE, 0xEA, 0xF4, 0xDB, 0x51, 0x61,
        0xFC, 0xFF, 0xD7, 0xAB, 0xED, 0xFF, 0xFF, 0xFF, 0xFA, 0x89, 0xB2, 0x79, 0xDB, 0x5B, 0x03, 0x1F, 0xDE, 0xBF, 0x24, 0xD1,
  /* RLE: 074 Pixels @ 178,121 */ 74, 0xFF,
  /* ABS: 020 Pixels @ 252,121 */ 0, 20, 0xFE, 0xFA, 0xF2, 0xE5, 0xDF, 0xE0, 0xD9, 0xDD, 0xDE, 0xDD, 0xDA, 0xE5, 0xE5, 0xE7, 0xE7, 0xF5, 0xFA, 0xFA, 0xFC, 0xFE,
  /* RLE: 038 Pixels @ 272,121 */ 38, 0xFF,
  /* ABS: 024 Pixels @ 010,122 */ 0, 24, 0x91, 0x04, 0x00, 0x00, 0x8B, 0xFF, 0xE8, 0x9B, 0x54, 0x2A, 0x21, 0x3A, 0x59, 0x76, 0x88, 0xA1, 0xB0, 0xB7, 0xC3, 0xC4, 0xB0, 0x68, 0x34, 0xAD,
  /* RLE: 012 Pixels @ 034,122 */ 12, 0xFF,
  /* ABS: 040 Pixels @ 046,122 */ 0, 40, 0xFE, 0xFA, 0xF2, 0xED, 0xCF, 0xBA, 0xB0, 0xAD, 0xA2, 0x9E, 0x97, 0x94, 0x8B, 0x8A, 0x88, 0x81, 0x80, 0x7F, 0x84, 0x84, 0x83, 0x82, 0x89, 0x8F, 0x90, 0x8E, 0x99, 0x9C, 0xA0, 0xAA, 0xAD, 0xB1, 0xB3, 0xBF, 0xC5,
        0xC6, 0xBC, 0x47, 0x7B, 0xFD,
  /* RLE: 035 Pixels @ 086,122 */ 35, 0xFF,
  /* ABS: 038 Pixels @ 121,122 */ 0, 38, 0xE5, 0xA5, 0x5C, 0x2B, 0x52, 0xA0, 0xDF, 0xFE, 0xFF, 0xFF, 0xFF, 0xE9, 0xAB, 0x49, 0x3A, 0x90, 0x57, 0x33, 0x28, 0x99, 0xF8, 0xFD, 0x72, 0x00, 0x47, 0xEB, 0xFF, 0xFF, 0xFF, 0xEE, 0x88, 0x3D, 0x23, 0x2A, 0x27,
        0x5C, 0xBA, 0xFE,
  /* RLE: 007 Pixels @ 159,122 */ 7, 0xFF,
  /* ABS: 012 Pixels @ 166,122 */ 0, 12, 0xA5, 0x8B, 0x95, 0xAE, 0xB1, 0x04, 0x0A, 0x9A, 0xE3, 0x40, 0x8A, 0xFA,
  /* RLE: 132 Pixels @ 178,122 */ 132, 0xFF,
  /* ABS: 024 Pixels @ 010,123 */ 0, 24, 0x8E, 0x04, 0x01, 0x0A, 0x59, 0xEA, 0xF4, 0xF5, 0xEC, 0xDE, 0xD3, 0xB0, 0x93, 0x6C, 0x5F, 0x53, 0x51, 0x49, 0x43, 0x43, 0x4C, 0x7C, 0xDB, 0xFC,
  /* RLE: 027 Pixels @ 034,123 */ 27, 0xFF,
  /* RLE: 003 Pixels @ 061,123 */ 3, 0xFE,
  /* ABS: 006 Pixels @ 064,123 */ 0, 6, 0xFC, 0xF3, 0xF4, 0xF7, 0xFB, 0xFC,
  /* RLE: 013 Pixels @ 070,123 */ 13, 0xFF,
  /* ABS: 003 Pixels @ 083,123 */ 0, 3, 0xA4, 0x3C, 0xE9,
  /* RLE: 032 Pixels @ 086,123 */ 32, 0xFF,
  /* ABS: 039 Pixels @ 118,123 */ 0, 39, 0xF9, 0xD8, 0x8F, 0x3B, 0x49, 0x90, 0xD7, 0xF2, 0xFF, 0xFF, 0xF9, 0xE6, 0xC1, 0x7D, 0x40, 0x46, 0x93, 0xDF, 0xFD, 0xF0, 0xE3, 0x8E, 0x2F, 0xD4, 0xFF, 0xCE, 0x1C, 0x07, 0x84, 0xFD, 0xFF, 0xFF, 0xFF, 0xFA, 0xE9,
        0xD8, 0xD3, 0xDF, 0xF4,
  /* RLE: 007 Pixels @ 157,123 */ 7, 0xFF,
  /* ABS: 013 Pixels @ 164,123 */ 0, 13, 0xFC, 0xCA, 0x76, 0xBC, 0x83, 0xCA, 0x34, 0x02, 0x5B, 0xF0, 0x7C, 0x44, 0xEF,
  /* RLE: 133 Pixels @ 177,123 */ 133, 0xFF,
  /* ABS: 021 Pixels @ 010,124 */ 0, 21, 0xAD, 0x10, 0x45, 0x8A, 0x20, 0x3C, 0x54, 0x57, 0x60, 0x72, 0x82, 0x94, 0x9D, 0xB7, 0xCE, 0xDF, 0xE9, 0xF2, 0xF5, 0xF9, 0xFB,
  /* RLE: 032 Pixels @ 031,124 */ 32, 0xFF,
  /* ABS: 023 Pixels @ 063,124 */ 0, 23, 0xFD, 0xAB, 0x8A, 0x86, 0x87, 0x8D, 0x8C, 0xA9, 0xAF, 0xB9, 0xBD, 0xC3, 0xCB, 0xD4, 0xE1, 0xE8, 0xFA, 0xFF, 0xFF, 0xFF, 0xE4, 0x22, 0xB1,
  /* RLE: 029 Pixels @ 086,124 */ 29, 0xFF,
  /* ABS: 019 Pixels @ 115,124 */ 0, 19, 0xFB, 0xE3, 0xBF, 0x72, 0x2E, 0x55, 0xBD, 0xF3, 0xFF, 0xFF, 0xFE, 0xE7, 0xB0, 0x6A, 0x38, 0x37, 0x75, 0xBD, 0xF0,
  /* RLE: 004 Pixels @ 134,124 */ 4, 0xFF,
  /* ABS: 010 Pixels @ 138,124 */ 0, 10, 0xFC, 0x94, 0x3E, 0xE7, 0xFF, 0xFA, 0x86, 0x03, 0x18, 0xC5,
  /* RLE: 016 Pixels @ 148,124 */ 16, 0xFF,
  /* ABS: 012 Pixels @ 164,124 */ 0, 12, 0xC6, 0x73, 0xC5, 0x7B, 0xD6, 0x59, 0x01, 0x2C, 0xD8, 0xC0, 0x2B, 0xBF,
  /* RLE: 134 Pixels @ 176,124 */ 134, 0xFF,
  /* ABS: 048 Pixels @ 010,125 */ 0, 48, 0xE7, 0x21, 0x8A, 0xFB, 0xDD, 0xA7, 0x9B, 0x8D, 0x84, 0x76, 0x72, 0x5A, 0x56, 0x49, 0x42, 0x36, 0x2D, 0x29, 0x3B, 0x54, 0x62, 0x71, 0x73, 0x83, 0x89, 0x8D, 0x9F, 0xA1, 0xA7, 0xBA, 0xBE, 0xBF, 0xCA, 0xD1, 0xD3,
        0xD7, 0xE0, 0xE0, 0xE0, 0xE7, 0xED, 0xED, 0xED, 0xF3, 0xFA, 0xFA, 0xFA, 0xFB,
  /* RLE: 005 Pixels @ 058,125 */ 5, 0xFF,
  /* ABS: 069 Pixels @ 063,125 */ 0, 69, 0xEE, 0x64, 0x9C, 0x9C, 0x9A, 0x91, 0x8F, 0x97, 0x86, 0x87, 0x7C, 0x7C, 0x75, 0x71, 0x71, 0x6C, 0x68, 0xF0, 0xFF, 0xFF, 0xFD, 0x8F, 0x2D, 0x8B, 0x99, 0x9F, 0x9E, 0x99, 0x9B, 0x9A, 0x97, 0x94, 0x99, 0x96, 0x99,
        0x99, 0x8F, 0x8F, 0x93, 0x92, 0x8D, 0x89, 0x89, 0x87, 0x83, 0x76, 0x71, 0x71, 0x6C, 0x5A, 0x53, 0x42, 0x33, 0x31, 0x48, 0x7B, 0xD6, 0xFA, 0xF7, 0xDE, 0xB7, 0x83, 0x51, 0x2F, 0x51, 0x8A, 0xD3, 0xF6, 0xFC,
  /* RLE: 006 Pixels @ 132,125 */ 6, 0xFF,
  /* ABS: 015 Pixels @ 138,125 */ 0, 15, 0xF3, 0x4D, 0x88, 0xFF, 0xFF, 0xFF, 0xF5, 0x45, 0x02, 0x26, 0xCA, 0xFF, 0xE5, 0xE9, 0xFE,
  /* RLE: 009 Pixels @ 153,125 */ 9, 0xFF,
  /* ABS: 014 Pixels @ 162,125 */ 0, 14, 0xEB, 0x9D, 0x8C, 0xC1, 0x7C, 0xCD, 0x64, 0x05, 0x18, 0xC5, 0xD5, 0x36, 0x98, 0xFB,
  /* RLE: 134 Pixels @ 176,125 */ 134, 0xFF,
  /* ABS: 119 Pixels @ 010,126 */ 0, 119, 0xFE, 0x67, 0x23, 0x6D, 0x9C, 0xB2, 0xC6, 0xD1, 0xDE, 0xE1, 0xE8, 0xE8, 0xE7, 0xDF, 0xD9, 0xCE, 0xC4, 0xBC, 0xAD, 0xA7, 0x9F, 0x8A, 0x7B, 0x76, 0x6A, 0x5F, 0x51, 0x4E, 0x4B, 0x48, 0x45, 0x3F, 0x3F, 0x3C, 0x3B,
        0x3C, 0x41, 0x41, 0x3F, 0x43, 0x46, 0x44, 0x44, 0x49, 0x4E, 0x4D, 0x4F, 0x54, 0x6F, 0x71, 0x72, 0x72, 0x87, 0x93, 0x7B, 0x6E, 0x6B, 0x73, 0x78, 0x7B, 0x7C, 0x7E, 0x7D, 0x8E, 0x8C, 0x89, 0x77, 0x74, 0x73, 0x6E, 0xCA, 0xDC, 0xDD, 0xDC, 0xD3, 0x8B,
        0x59, 0x55, 0x52, 0x55, 0x53, 0x51, 0x4F, 0x54, 0x54, 0x4F, 0x4F, 0x51, 0x5A, 0x64, 0x66, 0x5F, 0x64, 0x67, 0x68, 0x69, 0x69, 0x72, 0x81, 0x84, 0x8E, 0x95, 0xAB, 0xB0, 0xBE, 0xC5, 0xD5, 0xE3, 0xE4, 0xBB, 0x90, 0x51, 0x40, 0x44, 0x72, 0xAC, 0xD6,
        0xF2, 0xFE,
  /* RLE: 009 Pixels @ 129,126 */ 9, 0xFF,
  /* ABS: 003 Pixels @ 138,126 */ 0, 3, 0xF3, 0x4B, 0x91,
  /* RLE: 004 Pixels @ 141,126 */ 4, 0xFF,
  /* ABS: 030 Pixels @ 145,126 */ 0, 30, 0xD1, 0x37, 0x01, 0x36, 0xC0, 0xB7, 0x60, 0x85, 0xCA, 0xEB, 0xF4, 0xF8, 0xF9, 0xF7, 0xF3, 0xE8, 0xB8, 0x85, 0xAB, 0xA3, 0x89, 0xC1, 0x62, 0x05, 0x1B, 0xA8, 0xEA, 0x5B, 0x63, 0xF4,
  /* RLE: 136 Pixels @ 175,126 */ 136, 0xFF,
  /* ABS: 082 Pixels @ 011,127 */ 0, 82, 0xEC, 0xAB, 0x74, 0x55, 0x3E, 0x2E, 0x29, 0x25, 0x22, 0x2E, 0x2E, 0x2F, 0x35, 0x3C, 0x37, 0x32, 0x33, 0x2D, 0x3B, 0x54, 0x60, 0x6A, 0x79, 0x84, 0x8D, 0x9D, 0xA2, 0xAD, 0xBB, 0xC0, 0xC4, 0xD2, 0xD3, 0xCD, 0xCC,
        0xCA, 0xC6, 0xC3, 0xC6, 0xBF, 0xB6, 0xB6, 0xB0, 0xA7, 0xA5, 0xA0, 0x9A, 0x92, 0x90, 0x89, 0x86, 0x7E, 0x78, 0x76, 0x70, 0x69, 0x63, 0x60, 0x53, 0x4C, 0x44, 0x43, 0x3F, 0x44, 0x3D, 0x38, 0x31, 0x2E, 0x33, 0x2B, 0x30, 0x32, 0x2F, 0x2C, 0x30, 0x52,
        0x88, 0xAE, 0xCD, 0xE4, 0xED, 0xFD,
  /* RLE: 020 Pixels @ 093,127 */ 20, 0xFF,
  /* ABS: 011 Pixels @ 113,127 */ 0, 11, 0xF4, 0xD7, 0xB2, 0x76, 0x4F, 0x2E, 0x3D, 0x6F, 0xA6, 0xD7, 0xFC,
  /* RLE: 008 Pixels @ 124,127 */ 8, 0xFF,
  /* ABS: 009 Pixels @ 132,127 */ 0, 9, 0xFD, 0xF4, 0xE6, 0xD9, 0xCD, 0xC9, 0xB7, 0x31, 0x97,
  /* RLE: 005 Pixels @ 141,127 */ 5, 0xFF,
  /* ABS: 028 Pixels @ 146,127 */ 0, 28, 0xD5, 0x3B, 0x02, 0x12, 0x95, 0xD7, 0x97, 0x4A, 0x38, 0x4E, 0x62, 0x75, 0x81, 0x81, 0x83, 0x91, 0x96, 0x8D, 0xB2, 0xBD, 0x36, 0x03, 0x19, 0xA9, 0xF4, 0x5C, 0x5B, 0xEF,
  /* RLE: 139 Pixels @ 174,127 */ 139, 0xFF,
  /* ABS: 129 Pixels @ 013,128 */ 0, 129, 0xFC, 0xF5, 0xEF, 0xEA, 0xE9, 0xE7, 0xE2, 0xE1, 0xDD, 0xDD, 0xD6, 0xD5, 0xD5, 0xD5, 0xD9, 0xDA, 0xBF, 0xAD, 0x93, 0x8A, 0x80, 0x76, 0x72, 0x64, 0x5D, 0x50, 0x4C, 0x4B, 0x47, 0x46, 0x43, 0x3F, 0x3B, 0x3C, 0x39,
        0x37, 0x39, 0x38, 0x37, 0x3E, 0x51, 0x53, 0x4F, 0x50, 0x62, 0x6E, 0x6F, 0x6F, 0x74, 0x86, 0x87, 0x87, 0x86, 0x8C, 0x9B, 0x9C, 0x9B, 0x9C, 0xA4, 0xAE, 0xAE, 0xB0, 0xB3, 0xB5, 0xB7, 0xB8, 0xBD, 0xBE, 0xBD, 0xBD, 0xC6, 0xC8, 0xC0, 0xA1, 0x6E, 0x52,
        0x40, 0x3A, 0x35, 0x42, 0x51, 0x60, 0x78, 0x83, 0x8D, 0x93, 0x9D, 0xA7, 0xAA, 0xB5, 0xB9, 0xC2, 0xC9, 0xCF, 0xCF, 0xCF, 0xC8, 0xAC, 0x8C, 0x6A, 0x3E, 0x3E, 0x54, 0x79, 0xB0, 0xDE, 0xEE, 0xFB, 0xFF, 0xFF, 0xFC, 0xF1, 0xE6, 0xDA, 0xC7, 0xAE, 0x96,
        0x84, 0x67, 0x47, 0x35, 0x36, 0x3F, 0x41, 0x45, 0x40, 0x27, 0x46, 0xE0,
  /* RLE: 004 Pixels @ 142,128 */ 4, 0xFF,
  /* ABS: 027 Pixels @ 146,128 */ 0, 27, 0xFE, 0xE3, 0x6C, 0x16, 0x09, 0x3C, 0x9C, 0xCC, 0xD1, 0xA8, 0x7D, 0x75, 0x79, 0x81, 0x95, 0xAF, 0xC6, 0xA9, 0x62, 0x1F, 0x0F, 0x2E, 0xB7, 0xE3, 0x65, 0x58, 0xE2,
  /* RLE: 163 Pixels @ 173,128 */ 163, 0xFF,
  /* ABS: 107 Pixels @ 036,129 */ 0, 107, 0xFE, 0xFD, 0xFA, 0xFA, 0xF6, 0xEE, 0xE8, 0xE4, 0xDD, 0xD2, 0xD1, 0xCD, 0xC8, 0xC5, 0xC2, 0xC1, 0xB8, 0xB6, 0xB1, 0xA6, 0xA6, 0x9F, 0x96, 0x95, 0x91, 0x91, 0x7C, 0x76, 0x76, 0x73, 0x67, 0x5D, 0x54, 0x4B, 0x42,
        0x44, 0x44, 0x40, 0x3D, 0x42, 0x42, 0x45, 0x3E, 0x36, 0x38, 0x38, 0x35, 0x3C, 0x36, 0x35, 0x5F, 0xD1, 0xF1, 0xDF, 0xCF, 0xC4, 0xB6, 0xAB, 0x9C, 0x7F, 0x76, 0x6C, 0x53, 0x4C, 0x3C, 0x3C, 0x3C, 0x33, 0x2E, 0x33, 0x38, 0x39, 0x39, 0x39, 0x43, 0x6A,
        0x9B, 0xBF, 0xDA, 0xF6, 0xFC, 0xFA, 0xF1, 0xD8, 0xC0, 0xA5, 0x86, 0x62, 0x4B, 0x3E, 0x33, 0x35, 0x3C, 0x5F, 0x7C, 0x9B, 0xB3, 0xC1, 0xCB, 0xDC, 0xE3, 0xEA, 0xE8, 0xD1, 0x39, 0x52, 0xF4,
  /* RLE: 005 Pixels @ 143,129 */ 5, 0xFF,
  /* ABS: 024 Pixels @ 148,129 */ 0, 24, 0xF7, 0xBD, 0x39, 0x06, 0x03, 0x2A, 0x47, 0x6E, 0x9D, 0xAD, 0xBE, 0xB0, 0x96, 0x63, 0x40, 0x3E, 0x4A, 0x1F, 0x50, 0xCD, 0xE4, 0x5A, 0x4D, 0xE8,
  /* RLE: 206 Pixels @ 172,129 */ 206, 0xFF,
  /* RLE: 001 Pixels @ 078,130 */ 1, 0xFE,
  /* RLE: 004 Pixels @ 079,130 */ 4, 0xFB,
  /* ABS: 045 Pixels @ 083,130 */ 0, 45, 0xFA, 0xF7, 0xDB, 0x72, 0x2F, 0x2B, 0x52, 0x6C, 0x7F, 0x90, 0xA6, 0xB1, 0xBA, 0xC8, 0xCA, 0xCA, 0xCA, 0xCE, 0xCB, 0xCB, 0xCB, 0xCC, 0xCA, 0xC7, 0xB8, 0xB2, 0xB1, 0xA8, 0x9F, 0x91, 0x7C, 0x73, 0x58, 0x42, 0x34,
        0x26, 0x32, 0x44, 0x5F, 0x7E, 0x9A, 0xB8, 0xD8, 0xF7, 0xFD,
  /* RLE: 012 Pixels @ 128,130 */ 12, 0xFF,
  /* ABS: 004 Pixels @ 140,130 */ 0, 4, 0xD8, 0x43, 0x4F, 0xD6,
  /* RLE: 006 Pixels @ 144,130 */ 6, 0xFF,
  /* ABS: 021 Pixels @ 150,130 */ 0, 21, 0xF6, 0xAB, 0x4F, 0x10, 0x08, 0x2C, 0x42, 0x4D, 0x53, 0x54, 0x5D, 0x6A, 0x69, 0x42, 0x4A, 0xA9, 0xF6, 0xBF, 0x39, 0x7C, 0xF1,
  /* RLE: 215 Pixels @ 171,130 */ 215, 0xFF,
  /* ABS: 037 Pixels @ 086,131 */ 0, 37, 0xFA, 0xE2, 0xCD, 0xAC, 0x81, 0x68, 0x5B, 0x54, 0x49, 0x41, 0x43, 0x43, 0x41, 0x3E, 0x41, 0x3F, 0x42, 0x3D, 0x43, 0x48, 0x46, 0x4A, 0x45, 0x50, 0x57, 0x5B, 0x67, 0x70, 0x81, 0xA7, 0xBE, 0xCD, 0xDA, 0xE3, 0xED,
        0xF9, 0xFE,
  /* RLE: 017 Pixels @ 123,131 */ 17, 0xFF,
  /* ABS: 006 Pixels @ 140,131 */ 0, 6, 0xFE, 0xDC, 0x46, 0x36, 0xAD, 0xF2,
  /* RLE: 005 Pixels @ 146,131 */ 5, 0xFF,
  /* ABS: 019 Pixels @ 151,131 */ 0, 19, 0xFE, 0xEF, 0xC1, 0x7B, 0x4B, 0x3E, 0x3C, 0x3D, 0x3E, 0x41, 0x52, 0x6E, 0xBC, 0xE8, 0xE0, 0x7C, 0x42, 0xA5, 0xF4,
  /* RLE: 223 Pixels @ 170,131 */ 223, 0xFF,
  /* ABS: 017 Pixels @ 093,132 */ 0, 17, 0xFE, 0xFB, 0xF9, 0xF8, 0xF4, 0xF1, 0xE9, 0xEC, 0xEA, 0xF2, 0xE4, 0xF3, 0xF9, 0xF9, 0xFB, 0xFA, 0xFC,
  /* RLE: 032 Pixels @ 110,132 */ 32, 0xFF,
  /* ABS: 006 Pixels @ 142,132 */ 0, 6, 0xEA, 0x7C, 0x1E, 0x5C, 0xC1, 0xFC,
  /* RLE: 007 Pixels @ 148,132 */ 7, 0xFF,
  /* ABS: 013 Pixels @ 155,132 */ 0, 13, 0xFC, 0xE4, 0xCB, 0xC8, 0xC8, 0xDD, 0xF9, 0xFE, 0xDC, 0x88, 0x37, 0x6D, 0xDA,
  /* RLE: 275 Pixels @ 168,132 */ 254, 0xFF, 21, 0xFF,
  /* ABS: 010 Pixels @ 143,133 */ 0, 10, 0xFC, 0xD9, 0x67, 0x2F, 0x43, 0x90, 0xC3, 0xE4, 0xF3, 0xFE,
  /* RLE: 004 Pixels @ 153,133 */ 4, 0xFF,
  /* ABS: 010 Pixels @ 157,133 */ 0, 10, 0xFB, 0xF1, 0xDB, 0xBD, 0x90, 0x59, 0x39, 0x74, 0xCE, 0xFA,
  /* RLE: 278 Pixels @ 167,133 */ 254, 0xFF, 24, 0xFF,
  /* ABS: 020 Pixels @ 145,134 */ 0, 20, 0xF7, 0xD5, 0x91, 0x49, 0x33, 0x3E, 0x4A, 0x6C, 0x7C, 0x8B, 0x85, 0x71, 0x56, 0x4A, 0x40, 0x47, 0x6A, 0xA9, 0xDC, 0xFB,
  /* RLE: 283 Pixels @ 165,134 */ 254, 0xFF, 29, 0xFF,
  /* ABS: 013 Pixels @ 148,135 */ 0, 13, 0xFE, 0xEC, 0xBD, 0xA4, 0x95, 0x8C, 0x87, 0x8D, 0x9B, 0xAA, 0xC1, 0xEA, 0xFD,
  /* RLE: 5539 Pixels @ 161,135 */ 254, 0xFF, 254, 0xFF, 254, 0xFF, 254, 0xFF, 254, 0xFF, 254, 0xFF, 254, 0xFF, 254, 0xFF, 254, 0xFF, 254, 0xFF, 254, 0xFF, 254, 0xFF, 254, 0xFF, 254, 0xFF, 254, 0xFF, 254, 0xFF, 254, 0xFF, 254, 0xFF, 254, 0xFF,
        254, 0xFF, 254, 0xFF, 205, 0xFF,
  0
};  // 16147 bytes for 46200 pixels

static const GUI_BITMAP _bmCar = {
  300, // xSize
  154, // ySize
  300, // BytesPerLine
  GUI_COMPRESS_RLE8, // BitsPerPixel
  (unsigned char *)_acCar,  // Pointer to picture data
  NULL,  // Pointer to palette
  GUI_DRAW_RLEALPHA
};

/*********************************************************************
*
*       _SetPalette
*/
#if SHOW_PALETTE
static void _SetPalette(const PAL_BITMAP_CONTEXT * pPalBitmap, unsigned NumPalBitmaps, unsigned PalIndex, U8 Intens) {
  const GUI_COLOR * pColorsSrc0;
  const GUI_COLOR * pColorsSrc1;
  GUI_COLOR       * pColorsDst;
  unsigned          NumColors;
  unsigned          i;
  unsigned          j;

  for (i = 0; i < NumPalBitmaps; i++) {
    pColorsSrc0 = *((pPalBitmap + i)->ppColorsSrc + PalIndex);
    pColorsSrc1 = *((pPalBitmap + i)->ppColorsSrc + PalIndex + 1);
    pColorsDst = (pPalBitmap + i)->pColorsDst;
    NumColors  = (pPalBitmap + i)->NumColors;
    for (j = 0; j < NumColors; j++) {
      *(pColorsDst + j) = GUIDEMO_MixColors(*(pColorsSrc0 + j), *(pColorsSrc1 + j), Intens);
    }
  }
}
#endif

/*********************************************************************
*
*       _ShowGIF
*/
#if SHOW_BMP_GIF_JPG
static void _ShowGIF(void) {
  GUI_GIF_IMAGE_INFO GIF_ImageInfo;
  GUI_GIF_INFO       GIF_Info;
  int                ySizeAdd;
  int                xSize;
  int                ySize;
  int                yOff;
  int                i;

  GUI_GIF_GetInfo(_acGIF_AnimatedDialog, sizeof(_acGIF_AnimatedDialog), &GIF_Info);
  xSize    = LCD_GetXSize();
  ySize    = LCD_GetYSize();
  ySizeAdd = GUI_GetFontSizeY();
  yOff     = (ySize - CONTROL_SIZE_Y - INFO_SIZE_Y - BITMAP_SIZE_Y - ySizeAdd) / 2;
  for (i = 0; i < GIF_Info.NumImages + 1; i++) {
    if (i == GIF_Info.NumImages) {
      i = 0;
      GUI_GIF_DrawSub(_acGIF_AnimatedDialog, sizeof(_acGIF_AnimatedDialog), (xSize - GIF_Info.xSize) / 2, INFO_SIZE_Y + yOff, i);
      break;
    }
    GUI_GIF_DrawSub(_acGIF_AnimatedDialog, sizeof(_acGIF_AnimatedDialog), (xSize - GIF_Info.xSize) / 2, INFO_SIZE_Y + yOff, i);
    GUI_GIF_GetImageInfo(_acGIF_AnimatedDialog, sizeof(_acGIF_AnimatedDialog), &GIF_ImageInfo, i);
    if (GUIDEMO_CheckCancelDelay(GIF_ImageInfo.Delay ? (i < 6) || (i > 40) ? GIF_ImageInfo.Delay * 10 : GIF_ImageInfo.Delay * 3 : 100)) {
      break;
    }
  }
}
#endif

/*********************************************************************
*
*       _DrawBitmaps
*/
#if (SHOW_PALETTE || SHOW_GRAYSCALE || SHOW_HIGH_COLOR)
static void _DrawBitmaps(const PAL_BITMAP_CONTEXT * pPalBitmap, unsigned NumBitmaps, unsigned BitmapSize, const char ** aacText, unsigned ySizeAdd) {
  const GUI_BITMAP * pBitmap;
  unsigned           i;
  GUI_RECT           Rect;
  int                xOffDisplay;
  int                yOffDisplay;
  int                FontSizeY;
  int                xSize;
  int                ySize;
  int                xOff;
  int                yOff;

  xSize = LCD_GetXSize();
  if (xSize > XSIZE_MIN) {
    xOffDisplay = (xSize - XSIZE_MIN) / 2;
    xSize       = XSIZE_MIN;
  } else {
    xOffDisplay = 0;
  }
  ySize = LCD_GetYSize();
  if (ySize > YSIZE_MIN) {
    yOffDisplay = (ySize - YSIZE_MIN) / 2;
    ySize       = YSIZE_MIN;
  } else {
    yOffDisplay = 0;
  }
  xOff = (xSize - X_BORDER * 2 - BitmapSize * NumBitmaps) / (NumBitmaps + 1);
  yOff = (ySize - CONTROL_SIZE_Y - INFO_SIZE_Y - BITMAP_SIZE_Y - ySizeAdd) / 2;
  for (i = 0; i < NumBitmaps; i++) {
    pBitmap = (pPalBitmap + i)->pBitmap;
    Rect.x0 = xOffDisplay + X_BORDER + xOff + (xOff + BitmapSize) * i;
    Rect.y0 = yOffDisplay + INFO_SIZE_Y + yOff;
    GUI_DrawBitmap(pBitmap, Rect.x0, Rect.y0);
    GUI_SetColor(GUI_WHITE);
    if (aacText) {
      Rect.y0   += BITMAP_SIZE_Y;
      Rect.x1    = Rect.x0 + BitmapSize - 1;
      FontSizeY  = GUI_GetFontSizeY();
      Rect.y1    = Rect.y0 + FontSizeY * 2;
      GUI_DispStringInRect(*(aacText + i), &Rect, GUI_TA_HCENTER | GUI_TA_VCENTER);
    }
  }
}
#endif

/*********************************************************************
*
*       _DrawScreenAlphaBitmaps
*/
#if SHOW_ALPHA
static void _DrawScreenAlphaBitmaps(int xSize, int ySize) {
  #if GUI_SUPPORT_MEMDEV
    GUI_MEMDEV_Handle hMemBk;
    GUI_MEMDEV_Handle hMem;
    GUI_COLOR         Color;
  #endif
  #if GUI_SUPPORT_MEMDEV
    unsigned          j;
  #endif
  unsigned            i;
  int                 BreakStep;

  #if GUI_SUPPORT_MEMDEV
    hMemBk = GUI_MEMDEV_CreateEx((xSize - _bmCar.XSize) / 2, (ySize - _bmCar.YSize) / 2 + 10, _bmCar.XSize, _bmCar.YSize, GUI_MEMDEV_NOTRANS);
    hMem   = GUI_MEMDEV_CreateEx((xSize - _bmCar.XSize) / 2, (ySize - _bmCar.YSize) / 2 + 10, _bmCar.XSize, _bmCar.YSize, GUI_MEMDEV_NOTRANS);
    GUI_MEMDEV_CopyFromLCD(hMemBk);
  #endif
  BreakStep = 0;
  #if GUI_SUPPORT_MEMDEV
    #if GUI_WINSUPPORT
      GUIDEMO_SetInfoText("Alpha bitmaps");
    #else
      GUIDEMO_DispTitle("Alpha bitmaps");
    #endif
    GUI_MEMDEV_Select(hMem);
    GUI_MEMDEV_Write(hMemBk);
    GUI_SetColor(_aAlphaColors[0]);
    GUI_DrawBitmap(&_bmCar, (xSize - _bmCar.XSize) / 2, (ySize - _bmCar.YSize) / 2 + 10);
    GUI_MEMDEV_CopyToLCD(hMem);
    GUI_MEMDEV_Select(0);
    GUIDEMO_Wait(2000);
    #if GUI_WINSUPPORT
      GUIDEMO_SetInfoText("Alpha bitmaps\r\nChanging the current color...");
    #endif
    for (i = 0; i < GUI_COUNTOF(_aAlphaColors); i++) {
      if (i < GUI_COUNTOF(_aAlphaColors) - 1) {
        for (j = NUM_STEPS_ALPHA; j > 0; j--) {
          if (j) {
            Color = GUIDEMO_MixColors(_aAlphaColors[i], _aAlphaColors[i + 1], 255 * j / NUM_STEPS_ALPHA);
          } else {
            Color = _aAlphaColors[i];
          }
          GUI_MEMDEV_Select(hMem);
          GUI_MEMDEV_Write(hMemBk);
          #if (GUI_WINSUPPORT == 0)
            GUI_SetColor(GUI_WHITE);
            GUIDEMO_DispTitle("Alpha bitmaps");
          #endif
          GUI_SetColor(Color);
          GUI_DrawBitmap(&_bmCar, (xSize - _bmCar.XSize) / 2, (ySize - _bmCar.YSize) / 2 + 10);
          GUI_MEMDEV_CopyToLCD(hMem);
          GUI_MEMDEV_Select(0);
          if (GUIDEMO_CheckCancelDelay(MAX_TIME_ALPHA / (GUI_COUNTOF(_aAlphaColors) * NUM_STEPS_ALPHA))) {
            BreakStep = 1;
            break;
          }
        }
      }
      if (BreakStep) {
        break;
      }
    }
    if (BreakStep == 0) {
      GUIDEMO_Wait(2000);
    }
    #if GUI_WINSUPPORT
      GUI_MEMDEV_CopyToLCD(hMemBk);
    #else
      GUIDEMO_DrawBk();
    #endif
  #else
    #if GUI_WINSUPPORT
      GUIDEMO_SetInfoText("Alpha bitmaps");
    #endif
    for (i = 0; i < GUI_COUNTOF(_aAlphaColors); i++) {
      #if (GUI_WINSUPPORT == 0)
        GUI_SetColor(GUI_WHITE);
        GUIDEMO_DispTitle("Alpha bitmaps");
      #endif
      GUI_SetColor(_aAlphaColors[i]);
      GUI_DrawBitmap(&_bmCar, (xSize - _bmCar.XSize) / 2, (ySize - _bmCar.YSize) / 2 + 10);
      if (GUIDEMO_CheckCancelDelay(MAX_TIME_ALPHA / GUI_COUNTOF(_aAlphaColors))) {
        BreakStep = 1;
      }
      GUIDEMO_DrawBk();
      if (BreakStep) {
        break;
      }
    }
  #endif
  //
  // Clean up
  //
  #if GUI_SUPPORT_MEMDEV
    GUI_MEMDEV_Delete(hMemBk);
    GUI_MEMDEV_Delete(hMem);
  #endif
}
#endif

/*********************************************************************
*
*       _DrawScreenPaletteBasedBitmaps
*/
#if SHOW_PALETTE
static void _DrawScreenPaletteBasedBitmaps(int xSize, int ySize) {
  unsigned i, j;
  int      BreakStep;
  unsigned NumPalBitmaps;

  GUI_USE_PARA(xSize);
  GUI_USE_PARA(ySize);
  BreakStep = 0;
  #if GUI_WINSUPPORT
    GUIDEMO_SetInfoText("Palette based bitmaps");
  #else
    GUI_SetColor(GUI_WHITE);
    GUIDEMO_DispTitle("Palette based bitmaps");
  #endif
  NumPalBitmaps = GUI_COUNTOF(_apPaletteBitmaps);
  _SetPalette(_apPaletteBitmaps, NumPalBitmaps, 0, 255);
  _DrawBitmaps(_apPaletteBitmaps, NumPalBitmaps, BITMAP_SIZE_X_3, NULL, 0);
  GUIDEMO_Wait(2000);
  #if GUI_WINSUPPORT
    GUIDEMO_SetInfoText("Palette based bitmaps\r\nChanging the palette...");
  #endif
  for (i = 0; i < GUI_COUNTOF(_aPalettesMouse) - 1; i++) {
    for (j = NUM_STEPS_PAL; j > 0; j--) {
      _SetPalette(_apPaletteBitmaps, NumPalBitmaps, i, 255 * j / NUM_STEPS_PAL);
      _DrawBitmaps(_apPaletteBitmaps, NumPalBitmaps, BITMAP_SIZE_X_3, NULL, 0);
      if (GUIDEMO_CheckCancelDelay(MAX_TIME_PAL / (GUI_COUNTOF(_aPalettesMouse) * NUM_STEPS_PAL))) {
        BreakStep = 1;
        break;
      }
    }
    if (BreakStep) {
      break;
    }
  }
  if (BreakStep == 0) {
    GUIDEMO_Wait(2000);
  }
  GUIDEMO_DrawBk();
}
#endif

/*********************************************************************
*
*       _DrawScreen_BMP_GIF_JPG
*/
#if SHOW_BMP_GIF_JPG
static void _DrawScreen_BMP_GIF_JPG(int xSize, int ySize) {
  GUI_RECT          Rect;
  int               xOffDisplay;
  int               yOffDisplay;
  int               xOff;
  int               yOff;

  GUI_SetColor(GUI_WHITE);
  #if GUI_WINSUPPORT
    GUIDEMO_SetInfoText("BMP, GIF and JPEG images");
  #else
    GUIDEMO_DispTitle("BMP, GIF and JPEG");
  #endif
  if (xSize > XSIZE_MIN) {
    xOffDisplay = (xSize - XSIZE_MIN) / 2;
    xSize       = XSIZE_MIN;
  } else {
    xOffDisplay = 0;
  }
  if (ySize > YSIZE_MIN) {
    yOffDisplay = (ySize - YSIZE_MIN) / 2;
    ySize       = YSIZE_MIN;
  } else {
    yOffDisplay = 0;
  }
  GUI_SetFont(&GUI_FontRounded16);
  xOff    = (xSize - X_BORDER * 2 - BITMAP_SIZE_X_3 * NUM_IMAGES_BGJ) / (NUM_IMAGES_BGJ + 1);
  Rect.y1 = yOffDisplay + ySize - CONTROL_SIZE_Y - 1;
  yOff    = (ySize - CONTROL_SIZE_Y - INFO_SIZE_Y - BITMAP_SIZE_Y - GUI_GetFontSizeY()) / 2;
  //
  // BMP
  //
  Rect.x0  = xOffDisplay + X_BORDER    + xOff;
  Rect.y0  = yOffDisplay + INFO_SIZE_Y + yOff;
  GUI_BMP_Draw(_ac70x70_BMP, Rect.x0, Rect.y0);
  Rect.y0 += BITMAP_SIZE_Y;
  Rect.x1  = Rect.x0 + BITMAP_SIZE_X_3 - 1;
  GUI_DispStringInRect("BMP", &Rect, GUI_TA_HCENTER | GUI_TA_VCENTER);
  //
  // JPG
  //
  Rect.x0 = xOffDisplay + X_BORDER + xOff + (xOff + BITMAP_SIZE_X_3) * 2;
  Rect.y0 = yOffDisplay + INFO_SIZE_Y + yOff;
  GUI_JPEG_Draw(_ac70x70_JPG, sizeof(_ac70x70_JPG), Rect.x0, Rect.y0);
  Rect.y0 += BITMAP_SIZE_Y;
  Rect.x1 = Rect.x0 + BITMAP_SIZE_X_3 - 1;
  GUI_DispStringInRect("JPEG", &Rect, GUI_TA_HCENTER | GUI_TA_VCENTER);
  //
  // GIF
  //
  Rect.x0 = xOffDisplay + X_BORDER + xOff * 2 + BITMAP_SIZE_X_3;
  Rect.x1 = Rect.x0 + BITMAP_SIZE_X_3 - 1;
  GUI_DispStringInRect("GIF", &Rect, GUI_TA_HCENTER | GUI_TA_VCENTER);
  _ShowGIF();
  GUIDEMO_Wait(2000);
  GUIDEMO_DrawBk();
}
#endif

/*********************************************************************
*
*       _DrawScreenHighColor
*/
#if SHOW_HIGH_COLOR
static void _DrawScreenHighColor(int xSize, int ySize) {
  GUI_USE_PARA(xSize);
  GUI_USE_PARA(ySize);
  #if GUI_WINSUPPORT
    GUIDEMO_SetInfoText("12, 16 and 24bpp color bitmaps");
  #else
    GUIDEMO_DispTitle("Color bitmaps");
  #endif
  GUI_SetFont(&GUI_FontRounded16);
  _DrawBitmaps(_aColorBitmaps, GUI_COUNTOF(_aColorBitmaps), BITMAP_SIZE_X_3, _aacColorText,  GUI_GetFontSizeY());
  GUIDEMO_Wait(4000);
  GUIDEMO_DrawBk();
}
#endif

/*********************************************************************
*
*       _DrawScreenGrayScale
*/
#if SHOW_GRAYSCALE
static void _DrawScreenGrayScale(int xSize, int ySize) {
  GUI_USE_PARA(xSize);
  GUI_USE_PARA(ySize);
  #if GUI_WINSUPPORT
    GUIDEMO_SetInfoText("Grayscale bitmaps");
  #else
    GUIDEMO_DispTitle("Grayscale bitmaps");
  #endif
  GUI_SetFont(&GUI_FontRounded16);
  _DrawBitmaps(_aGrayscaleBitmaps, GUI_COUNTOF(_aGrayscaleBitmaps), BITMAP_SIZE_X_4, _aacGrayscaleText,  GUI_GetFontSizeY());
  GUIDEMO_Wait(4000);
  GUIDEMO_DrawBk();
}
#endif

/*********************************************************************
*
*       _apFunc
*/
static void (* _apFunc[])(int, int) = {
  #if SHOW_PALETTE
    _DrawScreenPaletteBasedBitmaps,
  #endif
  #if SHOW_BMP_GIF_JPG
    _DrawScreen_BMP_GIF_JPG,
  #endif
  #if SHOW_HIGH_COLOR
    _DrawScreenHighColor,
  #endif
  #if SHOW_ALPHA
    _DrawScreenAlphaBitmaps,
  #endif
  #if SHOW_GRAYSCALE
    _DrawScreenGrayScale,
  #endif
};

/*********************************************************************
*
*       Public code
*
**********************************************************************
*/
/*********************************************************************
*
*       GUIDEMO_Bitmap
*/
void GUIDEMO_Bitmap(void) {
  unsigned i;
  int      xSize;
  int      ySize;

  xSize = LCD_GetXSize();
  ySize = LCD_GetYSize();
  if (xSize < XSIZE_MIN || ySize < YSIZE_MIN) {
    GUIDEMO_ConfigureDemo("Bitmaps", "Showing bitmaps of different\nformats and color depths", GUIDEMO_SHOW_CURSOR | GUIDEMO_SHOW_INFO | GUIDEMO_SHOW_CONTROL);
    return;
  }
  GUIDEMO_ConfigureDemo("Bitmaps", "Showing bitmaps of different\nformats and color depths", GUIDEMO_SHOW_CURSOR | GUIDEMO_SHOW_INFO | GUIDEMO_SHOW_CONTROL);
  GUIDEMO_DrawBk();
  //
  // Iterate over subroutines
  //
  for (i = 0; i < GUI_COUNTOF(_apFunc); i++) {
    _apFunc[i](xSize, ySize);
  }
}

#else

void GUIDEMO_Bitmap_C(void);
void GUIDEMO_Bitmap_C(void) {}

#endif  // SHOW_GUIDEMO_BITMAP

/*************************** End of file ****************************/
