/*********************************************************************
*                 SEGGER Software GmbH                               *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2018  SEGGER Microcontroller GmbH                *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.46 - Graphical user interface for embedded applications **
All  Intellectual Property rights in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product. This file may
only be used in accordance with the following terms:

The  software has  been licensed by SEGGER Software GmbH to Nuvoton Technology Corporation
at the address: No. 4, Creation Rd. III, Hsinchu Science Park, Taiwan
for the purposes  of  creating  libraries  for its 
Arm Cortex-M and  Arm9 32-bit microcontrollers, commercialized and distributed by Nuvoton Technology Corporation
under  the terms and conditions  of  an  End  User  
License  Agreement  supplied  with  the libraries.
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
Licensing information
Licensor:                 SEGGER Software GmbH
Licensed to:              Nuvoton Technology Corporation, No. 4, Creation Rd. III, Hsinchu Science Park, 30077 Hsinchu City, Taiwan
Licensed SEGGER software: emWin
License number:           GUI-00735
License model:            emWin License Agreement, signed February 27, 2018
Licensed platform:        Cortex-M and ARM9 32-bit series microcontroller designed and manufactured by or for Nuvoton Technology Corporation
----------------------------------------------------------------------
Support and Update Agreement (SUA)
SUA period:               2018-03-26 - 2019-03-27
Contact to extend SUA:    sales@segger.com
----------------------------------------------------------------------
File        : GUIDEMO_Fading.c
Purpose     : Demo of fading animation function
---------------------------END-OF-HEADER------------------------------
*/

#include "GUIDEMO.h"

#if (SHOW_GUIDEMO_FADING && GUI_SUPPORT_MEMDEV)

/*********************************************************************
*
*       Defines
*
**********************************************************************
*/
#define NUM_FADINGS 3
#define NUM_SCREENS 2
#define TIME_FADING 1500

//
// Memory device format in dependence of color format
//
#if (GUI_USE_ARGB)
  #define GUI_COLOR_CONV GUICC_M8888I
#else
  #define GUI_COLOR_CONV GUICC_8888
#endif

/*********************************************************************
*
*       Static data
*
**********************************************************************
*/
/*********************************************************************
*
*       _bmSeggerLogo_160x80
*/
#if (GUI_USE_ARGB)
static GUI_CONST_STORAGE unsigned long acSeggerLogo_160x80[] = {
  0x00000000, 0x00000000, 0x00000000, 0x80292929, 0xDF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xDF292929, 0x80292929, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x10292929, 0xCF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xCF292929, 0x10292929, 0x00000000,
  0x00000000, 0xCF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xCF292929, 0x00000000,
  0x60292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF797979, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494,
        0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494,
        0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494,
        0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494,
        0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494,
        0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494,
        0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494,
        0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF797979, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0x60292929,
  0xCF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFFAFAFAF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFAFAFAF, 0xFF292929, 0xFF292929, 0xFF292929, 0xCF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF6C6C6C, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6C6C6C, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFDBDCEB, 0xFFF3F3F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE7E8F2, 0xFFE7E8F2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE7E8F2, 0xFF555BA3, 0xFF3D4396, 0xFF3D4396, 0xFFB6B9D8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFF868ABD, 0xFF3D4396, 0xFF3D4396, 0xFF868ABD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF7A7EB7, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFDBDCEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFB6B9D8, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF9EA1CB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6E72B0, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF555BA3, 0xFFF3F3F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFF9EA1CB, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFC2C4DE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF9EA1CB, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF7A7EB7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFCFD0E5, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF494F9D, 0xFFE7E8F2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6166AA, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFAAADD1, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFF9EA1CB, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF6166AA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE7E8F2, 0xFF494F9D, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFDBDCEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6E72B0, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF868ABD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFC2C4DE, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF555BA3, 0xFFF3F3F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF3F3F8, 0xFF555BA3, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFB6B9D8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF9295C4, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF7A7EB7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFDBDCEB, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF494F9D, 0xFFDBDCEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6166AA, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFAAADD1, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFB6B9D8, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF6166AA, 0xFFF3F3F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE7E8F2, 0xFF494F9D, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFDBDCEB, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF868ABD, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF7A7EB7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFC2C4DE, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF555BA3, 0xFFF3F3F8,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF3F3F8, 0xFF6166AA, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFAAADD1, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF9295C4, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF7A7EB7,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFDBDCEB, 0xFF494F9D, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFDBDCEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6166AA, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFFAAADD1, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFC2C4DE, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF494F9D, 0xFFF3F3F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE7E8F2, 0xFF494F9D, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFFDBDCEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF9295C4, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF6E72B0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFC2C4DE, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF555BA3, 0xFFF3F3F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6166AA, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF9EA1CB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFDBDCEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF9295C4, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF7A7EB7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF3F3F8, 0xFF494F9D, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFC2C4DE, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6E72B0, 0xFFDBDCEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6166AA, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFAAADD1, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFCFD0E5, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF494F9D, 0xFFE7E8F2, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6E72B0, 0xFF555BA3, 0xFFF3F3F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE7E8F2, 0xFF494F9D, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFDBDCEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF9EA1CB, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF6166AA, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6E72B0, 0xFF3D4396, 0xFF7A7EB7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFC2C4DE, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF555BA3, 0xFFF3F3F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF7A7EB7, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF868ABD,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6E72B0, 0xFF3D4396, 0xFF3D4396, 0xFFAAADD1, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF9295C4,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF7A7EB7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF3F3F8, 0xFF555BA3, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFFB6B9D8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6E72B0, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFDBDCEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFF6166AA, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFAAADD1, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFDBDCEB, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF494F9D, 0xFFDBDCEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6E72B0, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF555BA3, 0xFFF3F3F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFE7E8F2, 0xFF494F9D, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFDBDCEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFB6B9D8, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF6166AA, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB,
        0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB,
        0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB,
        0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB,
        0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB,
        0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFFCFD0E5, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6E72B0, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF7A7EB7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFC2C4DE, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF555BA3, 0xFFF3F3F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF868ABD, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFC2C4DE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6E72B0, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFAAADD1, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFF9295C4, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF7A7EB7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF3F3F8, 0xFF6166AA, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF6E72B0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6E72B0, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFDBDCEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6166AA, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFAAADD1, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFDBDCEB, 0xFF494F9D, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF6E72B0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6E72B0, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF555BA3, 0xFFF3F3F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE7E8F2, 0xFF494F9D, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFDBDCEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFC2C4DE, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFC2C4DE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6E72B0, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF7A7EB7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFC2C4DE, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF555BA3, 0xFFF3F3F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFCFD0E5,
        0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB,
        0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB,
        0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB,
        0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB,
        0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB,
        0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFFCFD0E5, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6E72B0, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFAAADD1, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF9295C4, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF7A7EB7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6E72B0, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFDBDCEB, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6166AA, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFE7E8F2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6E72B0, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFDBDCEB, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6166AA, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFE7E8F2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6E72B0, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFAAADD1, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF9295C4, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF7A7EB7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6E72B0, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF7A7EB7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFC2C4DE, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF555BA3, 0xFFF3F3F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFCFD0E5,
        0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB,
        0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB,
        0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB,
        0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB,
        0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB,
        0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFFCFD0E5, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6E72B0, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF555BA3, 0xFFF3F3F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE7E8F2, 0xFF494F9D, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFDBDCEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFC2C4DE, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFC2C4DE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6E72B0, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFDBDCEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6166AA, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFAAADD1, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFDBDCEB, 0xFF494F9D, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF6E72B0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6E72B0, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFAAADD1, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFF9295C4, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF7A7EB7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF3F3F8, 0xFF6166AA, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF6E72B0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6E72B0, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF7A7EB7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFC2C4DE, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF555BA3, 0xFFF3F3F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF868ABD, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFC2C4DE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6E72B0, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF555BA3, 0xFFF3F3F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFE7E8F2, 0xFF494F9D, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFDBDCEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFB6B9D8, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF6166AA, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB,
        0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB,
        0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB,
        0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB,
        0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB,
        0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFF9EA1CB, 0xFFCFD0E5, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6E72B0, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFDBDCEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFF6166AA, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFAAADD1, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFDBDCEB, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF494F9D, 0xFFDBDCEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6E72B0, 0xFF3D4396, 0xFF3D4396, 0xFFAAADD1, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF9295C4,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF7A7EB7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF3F3F8, 0xFF555BA3, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFFB6B9D8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6E72B0, 0xFF3D4396, 0xFF7A7EB7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFC2C4DE, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF555BA3, 0xFFF3F3F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF7A7EB7, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF868ABD,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6E72B0, 0xFF555BA3, 0xFFF3F3F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE7E8F2, 0xFF494F9D, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFDBDCEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF9EA1CB, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF6166AA, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6E72B0, 0xFFDBDCEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6166AA, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFAAADD1, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFCFD0E5, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF494F9D, 0xFFE7E8F2, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFDBDCEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF9295C4, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF3D4396, 0xFF7A7EB7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF3F3F8, 0xFF494F9D, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFC2C4DE, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF2F2F2, 0xFFAFAFAF, 0xFF878787, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF878787, 0xFFBCBCBC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFD7D7D7, 0xFFAFAFAF, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFFAFAFAF, 0xFFE4E4E4, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFD7D7D7, 0xFF949494, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF797979, 0xFFAFAFAF, 0xFFF2F2F2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFBCBCBC, 0xFF878787, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF878787, 0xFFAFAFAF, 0xFFF2F2F2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE4E4E4, 0xFFBCBCBC, 0xFF949494, 0xFF949494,
        0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFFA1A1A1, 0xFFD7D7D7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFD7D7D7, 0xFFAFAFAF, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494,
        0xFF949494, 0xFF949494, 0xFFCACACA, 0xFFCACACA, 0xFFF2F2F2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFC2C4DE, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFF555BA3, 0xFFF3F3F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6166AA, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF9EA1CB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFAFAFAF, 0xFF363636, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF444444, 0xFFBCBCBC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFCACACA,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFFE4E4E4, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFCACACA, 0xFF444444,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF797979, 0xFFF2F2F2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFBCBCBC, 0xFF444444,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF363636, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF363636, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFFA1A1A1, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFBCBCBC, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF797979, 0xFFF2F2F2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE7E8F2, 0xFF494F9D, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFF3D4396, 0xFFDBDCEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF9295C4, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF6E72B0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFAFAFAF, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFFBCBCBC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFFD7D7D7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFAFAFAF, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF515151, 0xFFF2F2F2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF797979, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF515151, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFCACACA, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6166AA, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396,
        0xFFAAADD1, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFC2C4DE, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF494F9D, 0xFFF3F3F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFF363636, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF6C6C6C, 0xFFD7D7D7, 0xFFFFFFFF, 0xFFF2F2F2, 0xFFAFAFAF, 0xFF444444, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF5F5F5F, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFFBCBCBC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFCACACA, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF363636, 0xFF878787, 0xFFCACACA, 0xFFCACACA, 0xFFAFAFAF, 0xFF5F5F5F, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF878787, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFA1A1A1, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF444444, 0xFFA1A1A1, 0xFFCACACA, 0xFFCACACA, 0xFFAFAFAF, 0xFF444444, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFFA1A1A1, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFCACACA, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF444444,
        0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFFA1A1A1, 0xFFF2F2F2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF5F5F5F, 0xFF949494, 0xFF949494, 0xFF949494,
        0xFF949494, 0xFF878787, 0xFF444444, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFFD7D7D7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF9295C4, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF7A7EB7,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFDBDCEB, 0xFF494F9D, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFDBDCEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFE4E4E4, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF515151, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF2F2F2, 0xFF515151, 0xFF292929, 0xFF292929, 0xFF6C6C6C, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF444444, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF515151, 0xFFE4E4E4, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF797979, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF797979, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF2F2F2, 0xFF363636, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF515151, 0xFFF2F2F2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF2F2F2, 0xFF797979, 0xFF292929, 0xFF292929, 0xFF292929, 0xFFA1A1A1, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFCACACA, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF5F5F5F,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFF2F2F2, 0xFF444444, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFC2C4DE, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF555BA3, 0xFFF3F3F8,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF3F3F8, 0xFF6166AA, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFAAADD1, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFE4E4E4, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF363636, 0xFFCACACA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF2F2F2, 0xFFA1A1A1, 0xFFA1A1A1, 0xFFF2F2F2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFD7D7D7, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFFCACACA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFA1A1A1, 0xFF5F5F5F, 0xFF6C6C6C, 0xFFE4E4E4, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFA1A1A1, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF363636,
        0xFFF2F2F2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF5F5F5F, 0xFF797979, 0xFFF2F2F2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFCACACA, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF5F5F5F,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE7E8F2, 0xFF494F9D, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFDBDCEB, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF868ABD, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF7A7EB7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFF363636, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF515151, 0xFF878787, 0xFFBCBCBC, 0xFFE4E4E4, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF797979, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFD7D7D7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF515151,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6C6C6C, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF797979,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFCACACA, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF515151,
        0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFF2F2F2, 0xFF444444, 0xFF292929, 0xFF292929, 0xFF292929, 0xFFBCBCBC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6166AA, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFAAADD1, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFB6B9D8, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF6166AA, 0xFFF3F3F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFA1A1A1, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF363636, 0xFF6C6C6C, 0xFFAFAFAF, 0xFFF2F2F2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFFBCBCBC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6C6C6C, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF878787,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFD7D7D7, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFE4E4E4, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929, 0xFF292929, 0xFF292929, 0xFFAFAFAF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFE4E4E4, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFCACACA, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF797979, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF5F5F5F, 0xFF949494, 0xFF949494, 0xFF949494,
        0xFF949494, 0xFF797979, 0xFF444444, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF515151, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF9295C4, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF7A7EB7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFDBDCEB, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF494F9D, 0xFFDBDCEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFBCBCBC, 0xFF444444, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF363636, 0xFFAFAFAF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFFA1A1A1, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFA1A1A1, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFFAFAFAF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929, 0xFF292929, 0xFF292929, 0xFFCACACA,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF878787, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFFD7D7D7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFCACACA, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF6C6C6C, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF6C6C6C, 0xFFF2F2F2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFC2C4DE, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF555BA3, 0xFFF3F3F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF3F3F8, 0xFF555BA3, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFB6B9D8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFD7D7D7, 0xFF949494, 0xFF5F5F5F, 0xFF363636, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFFCACACA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF5F5F5F, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFFAFAFAF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6C6C6C, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF878787,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929, 0xFF292929, 0xFF292929, 0xFFA1A1A1,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6C6C6C, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFCACACA, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF444444,
        0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFFF2F2F2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF363636, 0xFFD7D7D7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE7E8F2, 0xFF494F9D, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFDBDCEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6E72B0, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF868ABD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFD7D7D7, 0xFFA1A1A1, 0xFF444444, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF797979, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF515151,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF2F2F2, 0xFF797979, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF515151, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6C6C6C, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF797979,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFD7D7D7, 0xFF797979, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF444444, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFCACACA, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF5F5F5F,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF5F5F5F, 0xFF949494, 0xFF949494, 0xFF949494,
        0xFF949494, 0xFF878787, 0xFF363636, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF6C6C6C, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6166AA, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFAAADD1, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFF9EA1CB, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF6166AA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFF878787, 0xFF363636, 0xFF515151, 0xFFD7D7D7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFD7D7D7, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFFCACACA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFA1A1A1, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF363636,
        0xFFE4E4E4, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF797979, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFCACACA, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF5F5F5F,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFAFAFAF, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF9EA1CB, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF7A7EB7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFDBDCEB, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF494F9D, 0xFFE7E8F2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF363636, 0xFFF2F2F2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFBCBCBC, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF444444, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF363636, 0xFFD7D7D7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFD7D7D7, 0xFF363636, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF2F2F2, 0xFF363636, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF515151, 0xFFF2F2F2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFAFAFAF, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFCACACA, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF5F5F5F,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFD7D7D7, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6E72B0, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF555BA3, 0xFFF3F3F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFF9EA1CB, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFC2C4DE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFF363636, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF444444, 0xFFAFAFAF, 0xFFD7D7D7, 0xFFFFFFFF, 0xFFD7D7D7, 0xFFAFAFAF, 0xFF363636, 0xFF292929, 0xFF292929, 0xFF292929, 0xFFA1A1A1, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF444444, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF797979, 0xFFD7D7D7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFCACACA, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF797979, 0xFFBCBCBC, 0xFFCACACA, 0xFFBCBCBC, 0xFF797979, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFA1A1A1, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF363636, 0xFF878787, 0xFFCACACA, 0xFFCACACA, 0xFFAFAFAF, 0xFF5F5F5F, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFCACACA, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF363636,
        0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF6C6C6C, 0xFFBCBCBC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFFE4E4E4, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF7A7EB7, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFDBDCEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFB6B9D8, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF9EA1CB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFAFAFAF, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF515151, 0xFFF2F2F2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF6C6C6C, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFAFAFAF, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF363636, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF797979, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF363636, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFCACACA, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF363636, 0xFF292929, 0xFF292929, 0xFF292929, 0xFFAFAFAF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE7E8F2, 0xFF555BA3, 0xFF3D4396, 0xFF3D4396, 0xFFB6B9D8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFF868ABD, 0xFF3D4396, 0xFF3D4396, 0xFF868ABD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFBCBCBC, 0xFF444444, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF5F5F5F, 0xFFF2F2F2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFCACACA,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF797979, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFCACACA, 0xFF444444,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF878787, 0xFFA1A1A1, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFAFAFAF, 0xFF363636,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFFAFAFAF, 0xFF797979, 0xFF292929, 0xFF292929, 0xFFAFAFAF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF2F2F2, 0xFF363636, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF363636, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFA1A1A1, 0xFF292929, 0xFF292929, 0xFF292929, 0xFFAFAFAF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6C6C6C, 0xFF292929, 0xFF292929, 0xFF292929, 0xFFAFAFAF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFDBDCEB, 0xFFF3F3F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE7E8F2, 0xFFE7E8F2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFBCBCBC, 0xFF878787, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF949494, 0xFFD7D7D7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFD7D7D7, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFFBCBCBC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFBCBCBC, 0xFF797979, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF878787, 0xFFD7D7D7, 0xFFFFFFFF, 0xFFF2F2F2, 0xFF6C6C6C, 0xFF5F5F5F, 0xFFD7D7D7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF2F2F2,
        0xFFAFAFAF, 0xFF797979, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF949494, 0xFFE4E4E4, 0xFFFFFFFF, 0xFFD7D7D7, 0xFF5F5F5F, 0xFF5F5F5F, 0xFFE4E4E4, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE4E4E4, 0xFFA1A1A1, 0xFF949494, 0xFF949494,
        0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFFA1A1A1, 0xFFE4E4E4, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF2F2F2, 0xFFA1A1A1, 0xFF949494, 0xFFA1A1A1, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF2F2F2, 0xFF949494, 0xFF6C6C6C, 0xFFA1A1A1, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFF292929, 0xFF6C6C6C, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6C6C6C, 0xFF292929, 0xFF292929, 0xFF292929,
  0xCF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFFAFAFAF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFAFAFAF, 0xFF292929, 0xFF292929, 0xFF292929, 0xCF292929,
  0x60292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF797979, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494,
        0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494,
        0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494,
        0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494,
        0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494,
        0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494,
        0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494,
        0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF797979, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0x60292929,
  0x00000000, 0xCF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xCF292929, 0x00000000,
  0x00000000, 0x10292929, 0xCF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xCF292929, 0x10292929, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x80292929, 0xDF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929,
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xDF292929, 0x80292929, 0x00000000, 0x00000000, 0x00000000
};

static GUI_CONST_STORAGE GUI_BITMAP _bmSeggerLogo_160x80 = {
  160, /* XSize */
  80, /* YSize */
  640, /* BytesPerLine */
  32, /* BitsPerPixel */
  (unsigned char *)acSeggerLogo_160x80,  /* Pointer to picture data */
  NULL  /* Pointer to palette */
 ,GUI_DRAW_BMPM8888I
};
#else
static GUI_CONST_STORAGE unsigned long acSeggerLogo_160x80[] = {
  0xFF000000, 0xFF000000, 0xFF000000, 0x7F292929, 0x20292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x20292929, 0x7F292929, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xEF292929, 0x30292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x30292929, 0xEF292929, 0xFF000000,
  0xFF000000, 0x30292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x30292929, 0xFF000000,
  0x9F292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00797979, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494,
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494,
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494,
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494,
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494,
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494,
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494,
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00797979, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x9F292929,
  0x30292929, 0x00292929, 0x00292929, 0x00292929, 0x00AFAFAF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AFAFAF, 0x00292929, 0x00292929, 0x00292929, 0x30292929,
  0x00292929, 0x00292929, 0x00292929, 0x006C6C6C, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x006C6C6C, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x00F2E8E7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x00A35B55, 0x0096433D, 0x0096433D, 0x00D8B9B6, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00BD8A86, 0x0096433D, 0x0096433D, 0x00BD8A86, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B77E7A, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00D8B9B6, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00CBA19E, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00CBA19E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00DEC4C2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CBA19E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00E5D0CF, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x009D4F49, 0x00F2E8E7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00CBA19E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00AA6661, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00BD8A86, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x00A35B55, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D8B9B6, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x009D4F49, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D8B9B6, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00AA6661, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00BD8A86, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x009D4F49, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B0726E, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00CBA19E, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00DEC4C2, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E5D0CF, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x009D4F49, 0x00F2E8E7, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x009D4F49, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CBA19E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00AA6661, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B77E7A, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00BD8A86,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C49592,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x00A35B55, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x00D8B9B6, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x009D4F49, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00F2E8E7, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D8B9B6, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x00AA6661, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E,
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E,
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E,
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E,
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E,
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00E5D0CF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00BD8A86, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00DEC4C2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x00AA6661, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B0726E, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x009D4F49, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B0726E, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00DEC4C2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E5D0CF,
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E,
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E,
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E,
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E,
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E,
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00E5D0CF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00F2E8E7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00F2E8E7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E5D0CF,
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E,
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E,
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E,
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E,
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E,
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00E5D0CF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00DEC4C2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x009D4F49, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B0726E, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x00AA6661, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B0726E, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00BD8A86, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00DEC4C2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00F2E8E7, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D8B9B6, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x00AA6661, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E,
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E,
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E,
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E,
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E,
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00E5D0CF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x009D4F49, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C49592,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x00A35B55, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x00D8B9B6, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B77E7A, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00BD8A86,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x009D4F49, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CBA19E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00AA6661, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E5D0CF, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x009D4F49, 0x00F2E8E7, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00DEC4C2, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00AFAFAF, 0x00878787, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x00878787, 0x00BCBCBC, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00D7D7D7, 0x00AFAFAF, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00AFAFAF, 0x00E4E4E4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00D7D7D7, 0x00949494, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x00797979, 0x00AFAFAF, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00BCBCBC, 0x00878787, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x00878787, 0x00AFAFAF, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E4E4E4, 0x00BCBCBC, 0x00949494, 0x00949494,
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00A1A1A1, 0x00D7D7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D7D7D7, 0x00AFAFAF, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494,
        0x00949494, 0x00949494, 0x00CACACA, 0x00CACACA, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00CBA19E, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AFAFAF, 0x00363636, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00444444, 0x00BCBCBC, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00E4E4E4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00444444,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00797979, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00BCBCBC, 0x00444444,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00363636, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00363636, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00A1A1A1, 0x00FFFFFF, 0x00FFFFFF, 0x00BCBCBC, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00797979, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B0726E, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00AFAFAF, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00BCBCBC, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00D7D7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AFAFAF, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00515151, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00797979, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00515151, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x009D4F49, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00363636, 0x00292929, 0x00292929, 0x00292929, 0x006C6C6C, 0x00D7D7D7, 0x00FFFFFF, 0x00F2F2F2, 0x00AFAFAF, 0x00444444, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494,
        0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00BCBCBC, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00363636, 0x00878787, 0x00CACACA, 0x00CACACA, 0x00AFAFAF, 0x005F5F5F, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00878787, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00A1A1A1, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00444444, 0x00A1A1A1, 0x00CACACA, 0x00CACACA, 0x00AFAFAF, 0x00444444, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00A1A1A1, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 0x00444444,
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00A1A1A1, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 0x00949494, 0x00949494, 0x00949494,
        0x00949494, 0x00878787, 0x00444444, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00D7D7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00E4E4E4, 0x00292929, 0x00292929, 0x00292929, 0x00515151, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00515151, 0x00292929, 0x00292929, 0x006C6C6C, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494,
        0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00444444, 0x00292929, 0x00292929, 0x00292929,
        0x00515151, 0x00E4E4E4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00797979, 0x00292929, 0x00292929, 0x00292929, 0x00797979, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00363636, 0x00292929, 0x00292929, 0x00292929,
        0x00515151, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00797979, 0x00292929, 0x00292929, 0x00292929, 0x00A1A1A1, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00444444, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00E4E4E4, 0x00292929, 0x00292929, 0x00292929, 0x00363636, 0x00CACACA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00A1A1A1, 0x00A1A1A1, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494,
        0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D7D7D7, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00CACACA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00A1A1A1, 0x005F5F5F, 0x006C6C6C, 0x00E4E4E4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00A1A1A1, 0x00292929, 0x00292929, 0x00292929, 0x00363636,
        0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x005F5F5F, 0x00797979, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00BD8A86, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00363636, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00515151, 0x00878787, 0x00BCBCBC, 0x00E4E4E4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494,
        0x00292929, 0x00292929, 0x00292929, 0x00797979, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00D7D7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00515151,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x006C6C6C, 0x00292929, 0x00292929, 0x00292929, 0x00797979,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 0x00515151,
        0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00444444, 0x00292929, 0x00292929, 0x00292929, 0x00BCBCBC, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D8B9B6, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00AA6661, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00A1A1A1, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00363636, 0x006C6C6C, 0x00AFAFAF, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00BCBCBC, 0x00FFFFFF, 0x00FFFFFF, 0x006C6C6C, 0x00292929, 0x00292929, 0x00292929, 0x00878787,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D7D7D7, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00E4E4E4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929, 0x00292929, 0x00292929, 0x00AFAFAF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00E4E4E4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00797979, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 0x00949494, 0x00949494, 0x00949494,
        0x00949494, 0x00797979, 0x00444444, 0x00292929, 0x00292929, 0x00292929, 0x00515151, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x009D4F49, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00BCBCBC, 0x00444444, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00363636, 0x00AFAFAF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00A1A1A1, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929, 0x00292929, 0x00292929, 0x00949494,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00A1A1A1, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00AFAFAF, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929, 0x00292929, 0x00292929, 0x00CACACA,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00878787, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00D7D7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x006C6C6C, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x006C6C6C, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x00A35B55, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D8B9B6, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D7D7D7, 0x00949494, 0x005F5F5F, 0x00363636, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00CACACA, 0x00FFFFFF, 0x00FFFFFF, 0x00949494,
        0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00AFAFAF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x006C6C6C, 0x00292929, 0x00292929, 0x00292929, 0x00878787,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929, 0x00292929, 0x00292929, 0x00A1A1A1,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x006C6C6C, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 0x00444444,
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00363636, 0x00D7D7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00BD8A86, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D7D7D7, 0x00A1A1A1, 0x00444444, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00797979, 0x00FFFFFF, 0x00FFFFFF, 0x00949494,
        0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00515151,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00797979, 0x005F5F5F, 0x005F5F5F, 0x00515151, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x006C6C6C, 0x00292929, 0x00292929, 0x00292929, 0x00797979,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D7D7D7, 0x00797979, 0x005F5F5F, 0x005F5F5F, 0x00444444, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 0x00949494, 0x00949494, 0x00949494,
        0x00949494, 0x00878787, 0x00363636, 0x00292929, 0x00292929, 0x00292929, 0x006C6C6C, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00CBA19E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00AA6661, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00878787, 0x00363636, 0x00515151, 0x00D7D7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x00949494,
        0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D7D7D7, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00CACACA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00A1A1A1, 0x00292929, 0x00292929, 0x00292929, 0x00363636,
        0x00E4E4E4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00797979, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00AFAFAF, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CBA19E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00EBDCDB, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x009D4F49, 0x00F2E8E7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00292929, 0x00292929, 0x00292929, 0x00363636, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00BCBCBC, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x00949494,
        0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00444444, 0x00292929, 0x00292929, 0x00292929,
        0x00363636, 0x00D7D7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D7D7D7, 0x00363636, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00363636, 0x00292929, 0x00292929, 0x00292929,
        0x00515151, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AFAFAF, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00D7D7D7, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00CBA19E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00DEC4C2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00363636, 0x00292929, 0x00292929, 0x00292929, 0x00444444, 0x00AFAFAF, 0x00D7D7D7, 0x00FFFFFF, 0x00D7D7D7, 0x00AFAFAF, 0x00363636, 0x00292929, 0x00292929, 0x00292929, 0x00A1A1A1, 0x00FFFFFF, 0x00FFFFFF, 0x00949494,
        0x00292929, 0x00292929, 0x00292929, 0x00444444, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x00797979, 0x00D7D7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00797979, 0x00BCBCBC, 0x00CACACA, 0x00BCBCBC, 0x00797979, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00A1A1A1, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00363636, 0x00878787, 0x00CACACA, 0x00CACACA, 0x00AFAFAF, 0x005F5F5F, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 0x00363636,
        0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x006C6C6C, 0x00BCBCBC, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00E4E4E4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B77E7A, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00D8B9B6, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00CBA19E, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00AFAFAF, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00515151, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00949494,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x006C6C6C, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AFAFAF, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00363636, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00797979, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00363636, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00363636, 0x00292929, 0x00292929, 0x00292929, 0x00AFAFAF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x00A35B55, 0x0096433D, 0x0096433D, 0x00D8B9B6, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00BD8A86, 0x0096433D, 0x0096433D, 0x00BD8A86, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00BCBCBC, 0x00444444, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00797979, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00444444,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00878787, 0x00A1A1A1, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AFAFAF, 0x00363636,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00AFAFAF, 0x00797979, 0x00292929, 0x00292929, 0x00AFAFAF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00363636, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00363636, 0x00FFFFFF, 0x00FFFFFF, 0x00A1A1A1, 0x00292929, 0x00292929, 0x00292929, 0x00AFAFAF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x006C6C6C, 0x00292929, 0x00292929, 0x00292929, 0x00AFAFAF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x00F2E8E7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00BCBCBC, 0x00878787, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x00949494, 0x00D7D7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00D7D7D7, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00BCBCBC, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00BCBCBC, 0x00797979, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x00878787, 0x00D7D7D7, 0x00FFFFFF, 0x00F2F2F2, 0x006C6C6C, 0x005F5F5F, 0x00D7D7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2,
        0x00AFAFAF, 0x00797979, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x00949494, 0x00E4E4E4, 0x00FFFFFF, 0x00D7D7D7, 0x005F5F5F, 0x005F5F5F, 0x00E4E4E4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E4E4E4, 0x00A1A1A1, 0x00949494, 0x00949494,
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00A1A1A1, 0x00E4E4E4, 0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00A1A1A1, 0x00949494, 0x00A1A1A1, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00949494, 0x006C6C6C, 0x00A1A1A1, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x006C6C6C, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x006C6C6C, 0x00292929, 0x00292929, 0x00292929,
  0x30292929, 0x00292929, 0x00292929, 0x00292929, 0x00AFAFAF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AFAFAF, 0x00292929, 0x00292929, 0x00292929, 0x30292929,
  0x9F292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00797979, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494,
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494,
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494,
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494,
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494,
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494,
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494,
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00797979, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x9F292929,
  0xFF000000, 0x30292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x30292929, 0xFF000000,
  0xFF000000, 0xEF292929, 0x30292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x30292929, 0xEF292929, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0x7F292929, 0x20292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x20292929, 0x7F292929, 0xFF000000, 0xFF000000, 0xFF000000
};

static GUI_CONST_STORAGE GUI_BITMAP _bmSeggerLogo_160x80 = {
  160, /* XSize */
  80, /* YSize */
  640, /* BytesPerLine */
  32, /* BitsPerPixel */
  (unsigned char *)acSeggerLogo_160x80,  /* Pointer to picture data */
  NULL  /* Pointer to palette */
 ,GUI_DRAW_BMP8888
};
#endif

/*********************************************************************
*
*       Static code
*
**********************************************************************
*/
/*********************************************************************
*
*       _DrawFrame
*/
static void _DrawFrame(int x0, int y0, int x1, int y1, int b) {
  GUI_FillRect(x0, y0, x1, y0 + b - 1);
  GUI_FillRect(x0, y0 + b, x0 + b - 1, y1 - b);
  GUI_FillRect(x1 - b + 1, y0 + b, x1, y1 - b);
  GUI_FillRect(x0, y1 - b + 1, x1, y1);
}

/*********************************************************************
*
*       _DrawLogo
*/
static void _DrawLogo(int xSize, GUI_MEMDEV_Handle hLogo, GUI_MEMDEV_Handle hMemWork, GUI_RECT * pRect) {
  int xSizeLogo, ySizeLogo, Factor, xFactor, yFactor;

  xSizeLogo = GUI_MEMDEV_GetXSize(hLogo);
  ySizeLogo = GUI_MEMDEV_GetYSize(hLogo);
  if ((xSizeLogo < (pRect->x1 - pRect->x0 + 1)) && (ySizeLogo < (pRect->y1 - pRect->y0 + 1))) {
    GUI_MEMDEV_WriteAt(hLogo,
                       pRect->x0 + (pRect->x1 - pRect->x0 + 1 - xSizeLogo) / 2,
                       pRect->y0 + (pRect->y1 - pRect->y0 + 1 - ySizeLogo) / 2);
  } else {
    xFactor = ((pRect->x1 - pRect->x0 + 1) * 1000) / xSizeLogo;
    yFactor = ((pRect->y1 - pRect->y0 + 1) * 1000) / ySizeLogo;
    Factor = (xFactor > yFactor) ? yFactor : xFactor;
    GUI_MEMDEV_RotateHQ(hLogo, hMemWork,
                        (xSize - xSizeLogo) / 2,
                        pRect->y0 + ((pRect->y1 - pRect->y0 + 1) - ySizeLogo) / 2,
                        0, Factor);
  }
}

/*********************************************************************
*
*       _DrawText
*/
static void _DrawText(GUI_RECT * pRect) {
  GUI_SetFont(GUI_FONT_20_ASCII);
  GUI_SetColor(GUI_WHITE);
  GUI_SetTextMode(GUI_TM_TRANS);
  GUI_DispStringInRectWrap("Fading between two screens", pRect, GUI_TA_HCENTER | GUI_TA_VCENTER, GUI_WRAPMODE_WORD);
}

/*********************************************************************
*
*       _Paint0
*/
static void _Paint0(int xSize, int ySize, GUI_MEMDEV_Handle hLogo, GUI_MEMDEV_Handle hMemWork) {
  int ySizeText;
  GUI_RECT rLogo, rText;

  //
  // Background
  //
  GUI_SetBkColor(GUI_MAGENTA);
  GUI_Clear();
  GUI_SetColor(GUI_WHITE);
  _DrawFrame(10, 10, xSize - 11, ySize - 11, 5);
  GUI_SetColor(GUI_BLUE);
  GUI_FillRect(15, 15, xSize - 16, ySize - 16);
  //
  // Screen0
  //
  GUI_SetColor(GUI_WHITE);
  GUI_SetFont(GUI_FONT_24B_ASCII);
  GUI_SetTextMode(GUI_TM_TRANS);
  ySizeText = GUI_GetFontDistY();
  GUI_DispStringHCenterAt("Screen 0", xSize / 2, (ySize - ySizeText) / 2);
  //
  // Logo
  //
  rLogo.x0 = 25;
  rLogo.y0 = 25;
  rLogo.x1 = xSize - 25 - 1;
  rLogo.y1 = (ySize - ySizeText) / 2 - 10 - 1;
  _DrawLogo(xSize, hLogo, hMemWork, &rLogo);
  //
  // Message
  //
  rText.x0 = 25;
  rText.y0 = (ySize - ySizeText) / 2 + ySizeText + 10;
  rText.x1 = xSize - 25 - 1;
  rText.y1 = ySize - 25;
  _DrawText(&rText);
}

/*********************************************************************
*
*       _Paint1
*/
static void _Paint1(int xSize, int ySize, GUI_MEMDEV_Handle hLogo, GUI_MEMDEV_Handle hMemWork) {
  int ySizeText;
  GUI_RECT rLogo, rText;

  //
  // Background
  //
  GUI_SetBkColor(GUI_CYAN);
  GUI_Clear();
  GUI_SetColor(GUI_WHITE);
  _DrawFrame(10, 10, xSize - 11, ySize - 11, 5);
  GUI_SetColor(GUI_BLUE);
  GUI_FillRect(15, 15, xSize - 16, ySize - 16);
  //
  // Screen1
  //
  GUI_SetColor(GUI_WHITE);
  GUI_SetFont(GUI_FONT_24B_ASCII);
  GUI_SetTextMode(GUI_TM_TRANS);
  ySizeText = GUI_GetFontDistY();
  GUI_DispStringHCenterAt("Screen 1", xSize / 2, (ySize - ySizeText) / 2);
  //
  // Logo
  //
  rLogo.x0 = 25;
  rLogo.y0 = (ySize - ySizeText) / 2 + ySizeText + 10;
  rLogo.x1 = xSize - 25 - 1;
  rLogo.y1 = ySize - 25;
  _DrawLogo(xSize, hLogo, hMemWork, &rLogo);
  //
  // Message
  //
  rText.x0 = 25;
  rText.y0 = 25;
  rText.x1 = xSize - 25 - 1;
  rText.y1 = (ySize - ySizeText) / 2 - 10 - 1;
  _DrawText(&rText);
}

/*********************************************************************
*
*       _FadeScreens
*/
static int _FadeScreens(GUI_MEMDEV_Handle hScreen0, GUI_MEMDEV_Handle hScreen1) {
  GUI_MEMDEV_Write(hScreen1);
  //
  // Fade in Title and check if the user wants to cancel the demo
  //
  GUI_MEMDEV_FadeDevices(hScreen0, hScreen1, TIME_FADING);
  if (GUIDEMO_CheckCancel() == 1) {
    return 1;
  }
  return 0;
}

/*********************************************************************
*
*       _FadingDemo
*/
static void _FadingDemo(void) {
  #if GUI_WINSUPPORT
    GUI_MEMDEV_Handle    hMemControl;
  #endif
  GUI_MEMDEV_Handle    ahMem[NUM_SCREENS];
  GUI_MEMDEV_Handle    hLogo;
  void              (* apFunc[])(int, int, GUI_MEMDEV_Handle, GUI_MEMDEV_Handle) = { _Paint0, _Paint1 };
  int                  xSize, ySize, i, j;

  xSize = LCD_GetXSize();
  ySize = LCD_GetYSize();
  //
  // Store Control window in MEMDEV
  //
  GUI_Exec();
  #if GUI_WINSUPPORT
    hMemControl = GUI_MEMDEV_CreateEx(xSize - CONTROL_SIZE_X, ySize - CONTROL_SIZE_Y, CONTROL_SIZE_X, CONTROL_SIZE_Y, GUI_MEMDEV_NOTRANS);
    GUI_MEMDEV_CopyFromLCD(hMemControl);
  #endif
  //
  // Create logo device
  //
  hLogo = GUI_MEMDEV_CreateFixed(0, 0, _bmSeggerLogo_160x80.XSize, _bmSeggerLogo_160x80.YSize, GUI_MEMDEV_NOTRANS, GUI_MEMDEV_APILIST_32, GUI_COLOR_CONV);
  GUI_MEMDEV_Select(hLogo);
  GUI_SetBkColor(GUI_TRANSPARENT);
  GUI_Clear();
  GUI_DrawBitmap(&_bmSeggerLogo_160x80, 0, 0);
  //
  // Create screen devices
  //
  for (i = 0; i < NUM_SCREENS; i++) {
    ahMem[i] = GUI_MEMDEV_CreateFixed(0, 0, xSize, ySize, GUI_MEMDEV_HASTRANS, GUI_MEMDEV_APILIST_32, GUI_COLOR_CONV);
    GUI_MEMDEV_Select(ahMem[i]);
    apFunc[i](xSize, ySize, hLogo, ahMem[i]);
    #if GUI_WINSUPPORT
      GUI_MEMDEV_Write(hMemControl);
    #endif
  }
  GUI_MEMDEV_Select(0);
  //
  // Show fading
  //
  for (j = 0; j < NUM_FADINGS; j++) {
    for (i = 0; i < NUM_SCREENS; i++) {
      if (_FadeScreens(ahMem[i], ahMem[i ^ 1])) {
        j = NUM_FADINGS;
        break;
      }
    }
  }
  //
  // Delete devices
  //
  #if GUI_WINSUPPORT
    GUI_MEMDEV_Delete(hMemControl);
  #endif
  GUI_MEMDEV_Delete(hLogo);
  for (i = 0; i < NUM_SCREENS; i++) {
    if (ahMem[i]) {
      GUI_MEMDEV_Delete(ahMem[i]);
    }
  }
}

/*********************************************************************
*
*       Public code
*
**********************************************************************
*/
/*********************************************************************
*
*       GUIDEMO_Fading
*/
void GUIDEMO_Fading(void) {
  GUIDEMO_ConfigureDemo("Fading", "Fading between\ntwo screens", GUIDEMO_SHOW_CURSOR | GUIDEMO_SHOW_CONTROL);
  _FadingDemo();
}

#else

void GUIDEMO_Fading_C(void);
void GUIDEMO_Fading_C(void) {}

#endif  // SHOW_GUIDEMO_FADING && GUI_SUPPORT_MEMDEV

/*************************** End of file ****************************/
