


//BTL001 for learning board

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>

#include "LCDLIB.h"

#define sub_Zone0 4
#define Zone0_Digit_SegNum 14

#define sub_Zone1  2
#define Zone1_Digit_SegNum  8

#define sub_Zone2  1
#define Zone2_Digit_SegNum  31

#define sub_Zone3  1
#define Zone3_Digit_SegNum  14

const ZoneInfo_TypeDef LCD_ZoneInfo[]=
{
    {sub_Zone0, Zone0_Digit_SegNum},
    {sub_Zone1, Zone1_Digit_SegNum},
    {sub_Zone2, Zone2_Digit_SegNum},
    {sub_Zone3, Zone3_Digit_SegNum},
};


/**************************************************************************//**
 *
 * Defines each text's segment (alphabet+numeric) in terms of COM and BIT numbers,
 * Using this way that text segment can be consisted of each bit in the
 * following bit pattern:
 * @illustration
 *               A
 *         ----------
 *         |\   |J  /|
 *        F| H  |  K |B
 *         |  \ | /  |
 *         --G-- --M--
 *         |   /| \  |
 *       E |  Q |  N |C
 *         | /  |P  \|
 *         -----------
 *             D
 *
 *         -------0------
 *
 *        |   \7  |8  /9 |
 *        |5   \  |  /   |1
 *
 *         --6---  ---10--
 *
 *        |    /  |  \11 |
 *        |4  /13 |12 \  |2
 *
 *         -------3------
 *
 *
 *
 *****************************************************************************/




const char Zone0[sub_Zone0][Zone0_Digit_SegNum][2] =
{
    {
        // 0
        //{com, seg}
        // A      // B     // C     // D
        {3,  2}, {2,  2}, {1,  2}, {0,  2},
        // E      // F     // G     // H
        {1,  0}, {2,  0}, {2,  1}, {3,  1},
        // J      // K     // M     // N
        {3,  3}, {2,  3}, {1,  3}, {0,  3},
        // P      // Q
        {0,  1}, {1,  1},
    },
    {
        // 1
        //{com, seg}
        // A      // B     // C     // D
        {3,  6}, {2,  6}, {1,  6}, {0,  6},
        // E      // F     // G     // H
        {1,  4}, {2,  4}, {2,  5}, {3,  5},
        // J      // K     // M     // N
        {3,  7}, {2,  7}, {1,  7}, {0,  7},
        // P      // Q
        {0,  5}, {1,  5},
    },
    {
        // 2
        //{com, seg}
        // A      // B     // C     // D
        {3, 10}, {2, 10}, {1, 10}, {0, 10},
        // E      // F     // G     // H
        {1,  8}, {2,  8}, {2,  9}, {3,  9},
        // J      // K     // M     // N
        {3, 11}, {2, 11}, {1, 11}, {0, 11},
        // P      // Q
        {0,  9}, {1,  9},
    },
    {
        // 3
        //{com, seg}
        // A      // B     // C     // D
        {3, 14}, {2, 14}, {1, 14}, {0, 14},
        // E      // F     // G     // H
        {1, 12}, {2, 12}, {2, 13}, {3, 13},
        // J      // K     // M     // N
        {3, 15}, {2, 15}, {1, 15}, {0, 15},
        // P      // Q
        {0, 13}, {1, 13},
    },

};


const char Zone1[sub_Zone1][Zone1_Digit_SegNum][2] =
{
    {
        // 0
        //{com, seg}
        // A      // B     // C     // D
        {0, 23}, {0, 22}, {2, 22}, {3, 22},
        // E      // F     // G     // M
        {2, 23}, {1, 23}, {1, 22}, {1, 22},
    },
    {
        // 1
        //{com, seg}
        // A      // B     // C     // D
        {0, 21}, {0, 20}, {2, 20}, {3, 20},
        // E      // F     // G     // M
        {2, 21}, {1, 21}, {1, 20}, {1, 20},
    },

};

//Symbol Zone
const char Zone2[sub_Zone2][Zone2_Digit_SegNum][2] =
{
    {
        {0, 26}, // LOGO          /* 0 */
        {0,  0}, // 2DP           /* 1 */
        {0,  4}, // 3DP           /* 2 */
        {0,  8}, // 4DP           /* 3 */
        {0, 12}, // 5DP           /* 4 */
        {0, 16}, // 6DP           /* 5 */
        {3, 21}, // 11DP          /* 6 */
        {3,  0}, // 3COL          /* 7 */
        {3,  4}, // 4COL          /* 8 */
        {3,  8}, // 5COL          /* 9 */
        {3, 12}, // 6COL          /* 10 */
        {3, 23}, // 10COL         /* 11 */
        {0, 25}, // BRBL          /* 12 */
        {1, 25}, // B2            /* 13 */
        {2, 25}, // B1            /* 14 */
        {3, 25}, // B0            /* 15 */
        {3, 16}, // SB            /* 16 */
        {1, 26}, // P9            /* 17 */
        {2, 26}, // P8            /* 18 */
        {3, 26}, // P7            /* 19 */
        {3, 27}, // P6            /* 20 */
        {2, 27}, // P5            /* 21 */
        {1, 27}, // P4            /* 22 */
        {0, 27}, // P3            /* 23 */
        {0, 28}, // P2            /* 24 */
        {1, 28}, // P1            /* 25 */
        {2, 28}, // P0            /* 26 */
        {3, 24}, // AD            /* 27 */
        {2, 24}, // AR            /* 28 */
        {1, 24}, // AU            /* 29 */
        {0, 24}, // AL            /* 30 */
    }
};

const char Zone3[sub_Zone3][Zone3_Digit_SegNum][2] =
{
    {
        // 0
        //{com, seg}
        // A      // B     // C     // D
        {3, 18}, {2, 18}, {1, 18}, {0, 18},
        // E      // F     // G     // H
        {1, 16}, {2, 16}, {2, 17}, {3, 17},
        // J      // K     // M     // N
        {3, 19}, {2, 19}, {1, 19}, {0, 19},
        // P      // Q
        {0, 17}, {1, 17},
    },

};

char *Zone[] =
{
    (char*)(Zone0),
    (char*)(Zone1),
    (char*)(Zone2),
    (char*)(Zone3),
};


/**************************************************************************//**
 *
 * Defines segments for the alphabet
 * Bit pattern below defined for alphabet (text segments)
 *
 *****************************************************************************/
const uint16_t Zone0_TextDisplay[] =
{
    0x0000, /* space */
    0x1100, /* ! */
    0x0280, /* " */
    0x0000, /* # */
    0x0000, /* $ */
    0x0000, /* % */
    0x0000, /* & */
    0x0000, /* ? */
    0x0039, /* ( */
    0x000f, /* ) */
    0x3fc0, /* * */
    0x1540, /* + */
    0x0000, /* , */
    0x0440, /* - */
    0x8000, /* . */
    0x2200, /* / */

    0x003f, /* 0 */
    0x0006, /* 1 */
    0x045b, /* 2 */
    0x044f, /* 3 */
    0x0466, /* 4 */
    0x046d, /* 5 */
    0x047d, /* 6 */
    0x0007, /* 7 */
    0x047f, /* 8 */
    0x046f, /* 9 */

    0x0000, /* : */
    0x0000, /* ; */
    0x0a00, /* < */
    0x0000, /* = */
    0x2080, /* > */
    0x0000, /* ? */
    0xffff, /* @ */

    0x0477, /* A */
    0x0a79, /* B */
    0x0039, /* C */
    0x20b0, /* D */
    0x0079, /* E */
    0x0071, /* F */
    0x047d, /* G */
    0x0476, /* H */
    0x0006, /* I */
    0x000e, /* J */
    0x0a70, /* K */
    0x0038, /* L */
    0x02b6, /* M */
    0x08b6, /* N */
    0x003f, /* O */
    0x0473, /* P */
    0x203f, /* Q */
    0x0c73, /* R */
    0x046d, /* S */
    0x1101, /* T */
    0x003e, /* U */
    0x2230, /* V */
    0x2836, /* W */
    0x2a80, /* X */
    0x046e, /* Y */
    0x2209, /* Z */

    0x0039, /* [ */
    0x0880, /* backslash */
    0x000f, /* ] */
    0x0001, /* ^ */
    0x0008, /* _ */
    0x0000, /* ` */

    0x1058, /* a */
    0x047c, /* b */
    0x0058, /* c */
    0x045e, /* d */
    0x2058, /* e */
    0x0471, /* f */
    0x0c0c, /* g */
    0x0474, /* h */
    0x0004, /* i */
    0x000e, /* j */
    0x0c70, /* k */
    0x0038, /* l */
    0x1454, /* m */
    0x0454, /* n */
    0x045c, /* o */
    0x0473, /* p */
    0x0467, /* q */
    0x0450, /* r */
    0x0c08, /* s */
    0x0078, /* t */
    //0x001c, /* u */
    0x2502, /* u */
    0x2010, /* v */
    0x2814, /* w */
    0x2a80, /* x */
    0x080c, /* y */
    0x2048, /* z */

    0x0000,
};

/**************************************************************************//**
 * Defines segments for the numeric display
 *****************************************************************************/
const uint16_t Zone1_TextDisplay[] =
{
    0x0000, /* space */
    0x0000, /* ! */
    0x0000, /* " */
    0x0000, /* # */
    0x0000, /* $ */
    0x0000, /* % */
    0x0000, /* & */
    0x0000, /* ? */
    0x0000, /* ( */
    0x0000, /* ) */
    0x0000, /* * */
    0x0000, /* + */
    0x0000, /* , */
    0x00c0, /* - */
    0x0000, /* . */
    0x0000, /* / */

    0x3f, /* 0 */
    0x06, /* 1 */
    0xdb, /* 2 */
    0xcf, /* 3 */
    0xe6, /* 4 */
    0xed, /* 5 */
    0xfd, /* 6 */
    0x07, /* 7 */
    0xff, /* 8 */
    0xef, /* 9 */
};

const uint16_t *Zone_TextDisplay[] =
{
    (uint16_t*)(Zone0_TextDisplay),
    (uint16_t*)(Zone1_TextDisplay),
    (uint16_t*)(Zone0_TextDisplay),
    (uint16_t*)(Zone0_TextDisplay),
};


