package com.nuvoton.otaserverdemo

import android.Manifest
import android.annotation.SuppressLint
import android.content.Context
import android.content.pm.PackageInfo
import android.content.pm.PackageManager
import android.os.Bundle
import android.os.Handler
import android.os.Message
import android.util.Log
import android.view.View
import android.widget.*
import androidx.appcompat.app.AppCompatActivity
import com.afollestad.materialdialogs.MaterialDialog
import com.afollestad.materialdialogs.callbacks.onCancel
import com.afollestad.materialdialogs.customview.customView
import com.afollestad.materialdialogs.customview.getCustomView
import com.afollestad.materialdialogs.list.listItems
import com.nabinbhandari.android.permissions.PermissionHandler
import com.nabinbhandari.android.permissions.Permissions
import com.nuvoton.otaserver.ServerCallBack
import com.nuvoton.otaserver.setServerCallBackListener
import com.nuvoton.otaserver.utility.LocalSetting
import com.nuvoton.otaserver.utility.SoftAPIpaddress
import com.snatik.storage.Storage
import java.net.InetSocketAddress
import java.net.ServerSocket
import java.net.Socket
import java.text.DecimalFormat
import kotlin.concurrent.thread

class MainActivityWifi : AppCompatActivity(), ServerCallBack {
    /**
     * Kotlin will not create handler leak as Java does, so this is just suppressed
     * Ref: https://stackoverflow.com/a/48099735/6143603
     */

    val messageHandler = @SuppressLint("HandlerLeak")
    object : Handler() {
        override fun handleMessage(msg: Message?) {
            val list = msg?.data?.getStringArrayList("list")
            val stateString = list?.get(0)
            val responseStatus = list?.get(1)
            val progress = list?.get(2)
            val progressLimit = list?.get(3)
            val state = com.nuvoton.otaserver.OTAWifiState.valueOf(stateString ?: "Error")
            val stateChange = currentState != state
            currentState = state
            if (responseStatus != null && progress != null && progressLimit != null)
                updateProgress(stateChange, state, responseStatus, progress, progressLimit)
        }
    }

    fun updateProgress(stateChange: Boolean, state: com.nuvoton.otaserver.OTAWifiState, responseStatus: String, progress: String, progressLimit: String) {
        val stateString = when(state) {
            com.nuvoton.otaserver.OTAWifiState.Idle -> getString(R.string.ota_wifi_state_idle)
            com.nuvoton.otaserver.OTAWifiState.Connect -> getString(R.string.ota_wifi_state_connected)
            com.nuvoton.otaserver.OTAWifiState.Req_Ecdh_Pub0 -> getString(R.string.ota_wifi_state_ecdh_pub0)
            com.nuvoton.otaserver.OTAWifiState.Req_Ecdh_Pub1 -> getString(R.string.ota_wifi_state_ecdh_pub1)
            com.nuvoton.otaserver.OTAWifiState.Req_Ecdh_Get_Pub0 -> getString(R.string.ota_wifi_state_get_ecdh_pub0)
            com.nuvoton.otaserver.OTAWifiState.Req_Ecdh_Get_Pub1 -> getString(R.string.ota_wifi_state_get_ecdh_pub1)
            com.nuvoton.otaserver.OTAWifiState.Req_Ecdh_Rand_Pub0 -> getString(R.string.ota_wifi_state_rand_ecdh_pub0)
            com.nuvoton.otaserver.OTAWifiState.Req_Ecdh_Rand_Pub1 -> getString(R.string.ota_wifi_state_rand_ecdh_pub1)
            com.nuvoton.otaserver.OTAWifiState.Req_Ecdh_Get_Rand_Pub0 -> getString(R.string.ota_wifi_state_get_ecdh_pub0)
            com.nuvoton.otaserver.OTAWifiState.Req_Ecdh_Get_Rand_Pub1 -> getString(R.string.ota_wifi_state_get_ecdh_pub1)
            com.nuvoton.otaserver.OTAWifiState.Req_Auth_Key_Sys -> getString(R.string.ota_wifi_state_auth_sys)
            com.nuvoton.otaserver.OTAWifiState.Req_Set_Mass_Write_Sys -> getString(R.string.ota_wifi_state_set_write_sys)
            com.nuvoton.otaserver.OTAWifiState.Req_Mass_Write_Sys -> getString(R.string.ota_wifi_state_write_sys)
            com.nuvoton.otaserver.OTAWifiState.Req_Auth_Key_App -> getString(R.string.ota_wifi_state_auth_app)
            com.nuvoton.otaserver.OTAWifiState.Req_Set_Mass_Write_App -> getString(R.string.ota_wifi_state_set_write_app)
            com.nuvoton.otaserver.OTAWifiState.Req_Mass_Write_App -> getString(R.string.ota_wifi_state_write_app)
            com.nuvoton.otaserver.OTAWifiState.Disconnect -> getString(R.string.ota_wifi_state_disconnect)
            com.nuvoton.otaserver.OTAWifiState.Error -> getString(R.string.ota_wifi_state_error)
        }
//        val percent = "${progress.toFloat() / progressLimit.toFloat()}"
        when (state) {
            com.nuvoton.otaserver.OTAWifiState.Disconnect -> {
                updateDialog.title(R.string.title_ota_done)
                updateDialog.message(R.string.content_ota_complete)
                updateDialog.negativeButton(R.string.general_okay)
                buttonStartOTA.text = getString(R.string.title_open_server)
            }
            else -> when(responseStatus.toInt()) {
                com.nuvoton.otaserver.OTAConstants.STS_REBOOT -> {
                    updateDialog.title(R.string.title_client_reboot)
                    updateDialog.message(R.string.content_client_reboot)
                    updateDialog.negativeButton(R.string.general_okay)
                }
                com.nuvoton.otaserver.OTAConstants.ERR_CMD_CHECKSUM -> {
                    updateDialog.title(R.string.title_checksum_error)
                    updateDialog.message(R.string.content_checksum_error)
                    updateDialog.negativeButton(R.string.general_okay)
                }
                com.nuvoton.otaserver.OTAConstants.ERR_OLD_FW_VER -> {
                    updateDialog.title(R.string.title_firmware_older)
                    updateDialog.message(R.string.content_client_latest)
                    updateDialog.negativeButton(R.string.general_okay)
                }
                else -> {
                    if (stateChange) {
                        updateDialog.setTitle(stateString)
                        progressBar?.max = progressLimit.toInt()
//                        updateDialog.maxProgress = progressLimit.toInt()
                    }else {
                        progressBar?.progress = progress.toInt()
                        val percent = progress.toFloat()/progressLimit.toFloat()*100
                        val format = DecimalFormat(".##")
                        textviewPercent?.text = resources.getString(R.string.string_percent, format.format(percent))
                        textviewProgress?.text = resources.getString(R.string.string_progress, progress, progressLimit)
//                        updateDialog.setProgress(progress.toInt())
                    }
                }
            }
        }
    }

    private val BUFFER_SIZE = 256
    private val CRC_SIZE = 2
    lateinit var editInputPatter: EditText
    lateinit var editSys: EditText
    lateinit var editApp: EditText
    lateinit var editLicense: EditText
    lateinit var buttonStartOTA: Button
    lateinit var buttonSysFW: Button
    lateinit var buttonAppFW: Button
    lateinit var buttonLicense: Button
    lateinit var storage: Storage
    lateinit var textviewServerIp: TextView
    lateinit var versionName: String
    private var folderPath = ""
    lateinit var updateDialog: MaterialDialog
    private var currentState: com.nuvoton.otaserver.OTAWifiState? = null
    private var progressBar: ProgressBar? = null
    private var textviewPercent: TextView? = null
    private var textviewProgress: TextView? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main_wifi)

        //TODO("setServerCallBackListener")
        setServerCallBackListener(this)

        Permissions.check(this, arrayOf(Manifest.permission.WRITE_EXTERNAL_STORAGE, Manifest.permission.READ_EXTERNAL_STORAGE), null, null, object : PermissionHandler() {
            override fun onGranted() {
                showToast(getString(R.string.external_storage_permission_yes))

                thread {
                    var storage = Storage(applicationContext)
                    var folderPath = storage.externalStorageDirectory + "/Download"
                    var test = "${folderPath}/test"

                    Log.d(this.javaClass.name, "folderPath=${folderPath}")
                    Log.d(javaClass.name, "isWriteable=${storage.externalStorageDirectory}")

                    val restul = storage.createDirectory(test)
                    Log.d(javaClass.name, "$restul")
                    var list = storage.getNestedFiles(folderPath)
                    while (list.isEmpty()) {
                        Log.d(javaClass.name, "empty, sleep")
                        Thread.sleep(1000)
                    }
                    list.forEach {
                        Log.d(javaClass.name, "it=${it}")
                    }
                }
            }

            override fun onBlocked(context: Context?, blockedList: java.util.ArrayList<String>?): Boolean {
                showToast(getString(R.string.external_storage_permission_no))
                return true
            }

        })

        storage = Storage(applicationContext)
        folderPath = storage.externalStorageDirectory + "/Download"
        setViews()
        LocalSetting.shared.context = this.applicationContext
        val sysFw = LocalSetting.shared.getSetting("sysFw")
        val appFw = LocalSetting.shared.getSetting("appFw")
        val license = LocalSetting.shared.getSetting("license")
        editSys.setText(sysFw)
        editApp.setText(appFw)
        editLicense.setText(license)
//        EncryptHelper.shared.testAES256()
    }

    private fun showToast(message: String) {
        runOnUiThread { Toast.makeText(applicationContext, message, Toast.LENGTH_SHORT).show() }
    }

    private fun setViews() {

        try {
            val pInfo: PackageInfo = this.getPackageManager().getPackageInfo(this.getPackageName(), 0)
            val version: String = pInfo.versionName
            versionName= "version:"+version
        } catch (e: PackageManager.NameNotFoundException) {
            e.printStackTrace()
        }

        textviewServerIp = findViewById(R.id.textview_server_ip)
        textviewServerIp.text = SoftAPIpaddress.getServerIp() + " "+versionName



        editSys = findViewById(R.id.editSysFW)
        editApp = findViewById(R.id.editAppFW)
        editLicense = findViewById(R.id.editLicense)

        buttonStartOTA = findViewById(R.id.buttonStartOTA)
        buttonStartOTA.setOnClickListener { view -> //按鈕點擊
            val button = view as Button
            button.text = getString(R.string.button_ota_start)
            if (com.nuvoton.otaserver.OTAServer.shared.isUpdating) com.nuvoton.otaserver.OTAServer.shared.closeServer() else {

                val sysFw = editSys.text.toString()
                val appFw = editApp.text.toString()
                val license = editLicense.text.toString()
                val notFound = getString(R.string.string_not_found)
                if (sysFw != notFound) {
                    LocalSetting.shared.putSetting("sysFw", sysFw)
                    com.nuvoton.otaserver.OTAServer.shared.sysFw = storage.externalStorageDirectory + "/Download/" + sysFw
                }
                if (appFw != notFound) {
                    LocalSetting.shared.putSetting("appFw", appFw)
                    com.nuvoton.otaserver.OTAServer.shared.appFw = storage.externalStorageDirectory + "/Download/" + appFw
                }
                if (license != notFound) {
                    LocalSetting.shared.putSetting("license", license)
                    com.nuvoton.otaserver.OTAServer.shared.license = storage.externalStorageDirectory + "/Download/" + license
                }

                //這邊開啟服務
                com.nuvoton.otaserver.OTAServer.shared.messageHandler = messageHandler
//                com.nuvoton.otaserver.OTAServer.shared.openServer(storage)
                this.openServer(storage)

                updateDialog = MaterialDialog(this)
                        .title(R.string.title_open_server)
                        .message(R.string.content_ota_wait_client)
                        .show {
                            customView(R.layout.progressbar)
                            onCancel {
                                com.nuvoton.otaserver.OTAServer.shared.closeServer()
                                showToast(getString(R.string.toast_ota_stopped))
                            }
                        }
                progressBar = updateDialog.getCustomView().findViewById(R.id.progress_bar)
                textviewPercent = updateDialog.getCustomView().findViewById(R.id.textview_percentage)
                textviewProgress = updateDialog.getCustomView().findViewById(R.id.textview_progress)
            }
        }

        buttonSysFW = findViewById(R.id.buttonSysFW)
        buttonSysFW.setOnClickListener(onSelectFile)

        buttonAppFW = findViewById(R.id.buttonAppFW)
        buttonAppFW.setOnClickListener(onSelectFile)

        buttonLicense = findViewById(R.id.buttonLicense)
        buttonLicense.setOnClickListener(onSelectFile)
    }

    private val onSelectFile = View.OnClickListener { button ->
        val files = storage.getNestedFiles(folderPath)
        val list: ArrayList<String> = ArrayList()
        for (file in files) {
            list.add(file.name)
        }
        MaterialDialog(this)
                .onCancel {
                    val notFound = getString(R.string.string_not_found)
                    when {
                        button.id == R.id.buttonSysFW -> editSys.setText(notFound)
                        button.id == R.id.buttonAppFW -> editApp.setText(notFound)
                        else -> editLicense.setText(notFound)
                    }
                }
                .title(R.string.title_select_firmware).listItems(items = list) { dialog, position, text ->
                    val file = files[position]
                    when {
                        button.id == R.id.buttonSysFW -> editSys.setText(file.name)
                        button.id == R.id.buttonAppFW -> editApp.setText(file.name)
                        else -> editLicense.setText(file.name)
                    }
                }.show {
                    negativeButton(R.string.general_cancel) {
                        val notFound = getString(R.string.string_not_found)
                        when {
                            button.id == R.id.buttonSysFW -> editSys.setText(notFound)
                            button.id == R.id.buttonAppFW -> editApp.setText(notFound)
                            else -> editLicense.setText(notFound)
                        }
                    }
                    positiveButton(R.string.general_okay) {  }
                }
    }

    //建立連線
    private var serverSocket: ServerSocket? = null
    private var socketAccept : Socket? = null
    private val PORT_NUM = 1111
    private val PACKET_LENGTH = 64
    fun openServer(storage: Storage) {
        thread {
            try {
                if (serverSocket != null && !serverSocket!!.isClosed) {
                    serverSocket?.close()
                    serverSocket = null
                }
                serverSocket = ServerSocket()
                serverSocket?.reuseAddress = true
                serverSocket?.bind(InetSocketAddress(PORT_NUM))

                thread {
                    Log.i("serverSocket", "serverSocket is accept")
                    socketAccept = serverSocket!!.accept()
                    com.nuvoton.otaserver.OTAServer.shared.openServer(storage)

                }
            }catch (e: Exception) {
                e.printStackTrace()
            }
        }
    }

    override fun toWrite(byteArray: ByteArray) {
        //TODO("write this Data to MCU")

        if(socketAccept == null){
            return
        }
        socketAccept!!.getOutputStream().write(byteArray)
    }

    override fun getConnectBuffer(): ByteArray {
        //TODO("Read MCU Data And return")
        var buffer = ByteArray(11)
        if(socketAccept == null){
            return buffer
        }
        socketAccept!!.getInputStream().read(buffer, 0, 11)
        return buffer
    }

    override fun getBuffer(): ByteArray {
        //TODO("Read MCU Data And return")

        var buffer = ByteArray(PACKET_LENGTH)
        if(socketAccept == null){
            return buffer
        }
        socketAccept!!.getInputStream().read(buffer, 0, PACKET_LENGTH)
        return buffer
    }


}
