/**************************************************************************//**
 * @file     config.h
 * @version  V3.00
 * @brief    I2S Wave Player Sample Configuration Header File
 *
 * @copyright SPDX-License-Identifier: Apache-2.0
 * @copyright Copyright (C) 2020 Nuvoton Technology Corp. All rights reserved.
 ******************************************************************************/
#ifndef CONFIG_H
#define CONFIG_H

#include "ff.h"

/*---------------------------------------------------------------------------------------------------------*/
/* Global variables                                                                                        */
/*---------------------------------------------------------------------------------------------------------*/
#define BUFF_LEN    32
#define BUFF_HALF_LEN   (BUFF_LEN/2)

#define PCM_BUFFER_SIZE 4*1024

typedef struct dma_desc_t
{
    uint32_t ctl;
    uint32_t endsrc;
    uint32_t enddest;
    uint32_t offset;
} DMA_DESC_T;

extern FATFS FatFs[];      /* File system object for logical drive */
extern uint8_t u8AudioPlaying;
extern signed int aiPCMBuffer[2][PCM_BUFFER_SIZE];
extern volatile uint8_t g_u8PCMBufferFull[2];
extern volatile uint8_t g_u8PCMBufferPlaying;

void WAVPlayer(void);
void NAU88L25_ConfigSampleRate(uint32_t u32SampleRate);

#endif
