/*********************************************************************
*                 SEGGER Software GmbH                               *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2018  SEGGER Microcontroller GmbH                *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.46 - Graphical user interface for embedded applications **
All  Intellectual Property rights in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product. This file may
only be used in accordance with the following terms:

The  software has  been licensed by SEGGER Software GmbH to Nuvoton Technology Corporation
at the address: No. 4, Creation Rd. III, Hsinchu Science Park, Taiwan
for the purposes  of  creating  libraries  for its
Arm Cortex-M and  Arm9 32-bit microcontrollers, commercialized and distributed by Nuvoton Technology Corporation
under  the terms and conditions  of  an  End  User
License  Agreement  supplied  with  the libraries.
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
Licensing information
Licensor:                 SEGGER Software GmbH
Licensed to:              Nuvoton Technology Corporation, No. 4, Creation Rd. III, Hsinchu Science Park, 30077 Hsinchu City, Taiwan
Licensed SEGGER software: emWin
License number:           GUI-00735
License model:            emWin License Agreement, signed February 27, 2018
Licensed platform:        Cortex-M and ARM9 32-bit series microcontroller designed and manufactured by or for Nuvoton Technology Corporation
----------------------------------------------------------------------
Support and Update Agreement (SUA)
SUA period:               2018-03-26 - 2019-03-27
Contact to extend SUA:    sales@segger.com
----------------------------------------------------------------------
File        : GUIDEMO_Intro.c
Purpose     : Introduction for emWin generic demo
              (This is also a good file to demo and explain basic
              emWin features by setting breakpoints)
----------------------------------------------------------------------
*/

#include <string.h>

#include "GUIDEMO.h"

/*********************************************************************
*
*       Defines
*/
#define SCREEN_DIV          6  // 2^6 = 64

#define FACTOR_EMWIN        4
#define FACTOR_DESC        11
#define FACTOR_ANY_COMP    22
#define FACTOR_VERSION     31
#define FACTOR_LOGO        38
#define FACTOR_WWW         56

#define DIST_ANY_COMP      18

#ifdef __DEMO_160x128__
#else
volatile static char s_u8ShowNuvotonQRCodeFlag;
#endif
/*********************************************************************
*
*       GUIDEMO_Intro
*
**********************************************************************
*/
void GUIDEMO_Intro(void)
{
    unsigned xCenter;
    unsigned xSize;
    unsigned ySize;
    char     acVersion[30] = "Version of emWin: ";

    xSize   = LCD_GetXSize();
    ySize   = LCD_GetYSize();
    xCenter = xSize / 2;
    GUIDEMO_DrawBk();
    GUI_SetTextMode(GUI_TM_TRANS);
#ifdef __DEMO_160x128__
#else
    //
    // QR-Code for Nuvoton HMI www.nuvoton.com
    //
    if (s_u8ShowNuvotonQRCodeFlag)
    {
        GUI_SetBkColor(GUI_WHITE);
        GUI_Clear();
        GUI_DrawBitmap(&bmnuvoton_qrcode, (xSize - bmnuvoton_qrcode.XSize) >> 1, (ySize - bmnuvoton_qrcode.YSize) >> 1);
        GUI_SetColor(GUI_RED);
        GUI_SetFont(&GUI_FontRounded22);
        GUI_DispStringHCenterAt("www.nuvoton.com", xCenter, 6);
        GUIDEMO_Delay(10000);
        GUIDEMO_DrawBk();
    }
    s_u8ShowNuvotonQRCodeFlag = 1;
#endif
    //
    // emWin
    //
    GUI_SetColor(GUI_WHITE);
#ifdef __DEMO_160x128__
    GUI_SetFont(&GUI_Font10S_ASCII);
    GUI_DispStringAt("emWin",                                                 80, (FACTOR_EMWIN * ySize)     >> SCREEN_DIV);
#else
    GUI_SetFont(&GUI_FontRounded22);
    GUI_DispStringHCenterAt("emWin",                                                 xCenter, (FACTOR_EMWIN * ySize)     >> SCREEN_DIV);
#endif
    //
    // emWin description
    //
#ifdef __DEMO_160x128__
    GUI_SetFont(&GUI_Font10S_ASCII);
    GUI_DispStringAt("Universal graphic SW\nfor embedded applications", 80, ((FACTOR_DESC * ySize)      >> SCREEN_DIV) + 5);
#else
    GUI_SetFont(&GUI_FontSouvenir18);
    GUI_DispStringHCenterAt("Universal graphic software\nfor embedded applications", xCenter, (FACTOR_DESC * ySize)      >> SCREEN_DIV);
#endif
    //
    // Any text
    //
    GUI_SetColor(GUI_MAKE_COLOR(0x2288ff));
    GUI_DispStringHCenterAt("Any CPU - Any Display - Any Application",               xCenter, (FACTOR_ANY_COMP * ySize)  >> SCREEN_DIV);
    //
    // Compiled
    //
    GUI_SetFont(&GUI_Font10S_ASCII);
    GUI_DispStringHCenterAt("Compiled " __DATE__ " "__TIME__,                        xCenter, ((FACTOR_ANY_COMP * ySize) >> SCREEN_DIV) + DIST_ANY_COMP);
    //
    // Version
    //
    GUI_SetColor(GUI_WHITE);
#ifdef __DEMO_160x128__
    GUI_SetFont(&GUI_Font10S_ASCII);
#else
    GUI_SetFont(&GUI_FontSouvenir18);
#endif
    strcat(acVersion, GUI_GetVersionString());
#ifdef __DEMO_160x128__
    GUI_DispStringHCenterAt(acVersion,                                               xCenter, ((FACTOR_VERSION * ySize)  >> SCREEN_DIV) - 8);
#else
    GUI_DispStringHCenterAt(acVersion,                                               xCenter,  (FACTOR_VERSION * ySize)  >> SCREEN_DIV);
#endif
    //
    // Logo
    //
#ifdef __DEMO_160x128__
#else
    GUI_DrawBitmap(&bmnuvoton_logo_140x70, (xSize - bmnuvoton_logo_140x70.XSize) >> 1, (FACTOR_LOGO * ySize) >> SCREEN_DIV);
#endif
    //
    // www.segger.com
    //
    GUI_SetColor(GUI_WHITE);
#ifdef __DEMO_160x128__
    GUI_SetFont(&GUI_Font10S_ASCII);
    GUI_DispStringAt("www.nuvoton.com", 0, (FACTOR_WWW * ySize) >> SCREEN_DIV);
    GUIDEMO_Delay(1000);
#else
    GUI_SetFont(&GUI_FontRounded22);
    GUI_DispStringHCenterAt("www.nuvoton.com", xCenter - 4, (FACTOR_WWW * ySize) >> SCREEN_DIV);
    GUIDEMO_Delay(5000);
#endif
}

/*************************** End of file ****************************/
