#include <stdio.h>
#include <string.h>
#include "tee_client_api.h"
#include "strcat.h"

#define LOG_ERROR(func_name, result)     do {                                           \
    printf("ERROR: failed to call %s(), result = 0x%08x\r\n", (func_name), (result));   \
} while (0)

static const TEEC_UUID _uuid = STRCAT_TA_UUID;

static char test_input_tmpref_a[] = "test_tmpref";
static char test_input_tmpref_b[] = "##ok_tmpref";

static char test_input_memref_a[] = "test_memref";
static char test_input_memref_b[] = "##ok_memref";

static char test_output_tmpref[32] = {0};

int strcat_test(void) {
    TEEC_Context     context;
    TEEC_Session     session;
    TEEC_Operation   operation;
    TEEC_Result      result;

    TEEC_SharedMemory test_input_a_shm;
    TEEC_SharedMemory test_input_b_shm;

    int i;

    // 初始化 context
    result = TEEC_InitializeContext(NULL, &context);
    if (result != TEEC_SUCCESS) {
        LOG_ERROR("TEEC_InitializeContext", result);
        goto cleanup_1;
    }

    // 打开会话
    result = TEEC_OpenSession(&context, &session,
            &_uuid, TEEC_LOGIN_USER, NULL, NULL, NULL);
    if (result != TEEC_SUCCESS) {
        LOG_ERROR("TEEC_OpenSession", result);
        goto cleanup_2;
    }

    for (i = 0; i < 3; i++) {
        if (i == 0) {
            printf("Test 1: tmpref + tmpref -> tmpref\r\n");

            // 设置参数
            operation.paramTypes = TEEC_PARAM_TYPES(
                TEEC_MEMREF_TEMP_INPUT,
                TEEC_MEMREF_TEMP_INPUT,
                TEEC_MEMREF_TEMP_OUTPUT,
                TEEC_NONE
            );
            operation.params[0].tmpref.buffer = test_input_tmpref_a;
            operation.params[0].tmpref.size = sizeof(test_input_tmpref_a);
            operation.params[1].tmpref.buffer = test_input_tmpref_b;
            operation.params[1].tmpref.size = sizeof(test_input_tmpref_b);
            operation.params[2].tmpref.buffer = test_output_tmpref;
            operation.params[2].tmpref.size = sizeof(test_output_tmpref);

/*
            // for test
            operation.params[1].tmpref.buffer = (char *)0x20000011;
            operation.params[1].tmpref.size = 1;
*/

            printf("a = %s, b = %s\r\n", test_input_tmpref_a, test_input_tmpref_b);
        } else if ((i == 1) || (i == 2)) {
            if (i == 1) {
                printf("Test 2: whole + whole -> tmpref\r\n");
            } else {
                printf("Test 3: partial + partial -> tmpref\r\n");
            }

            memset(&test_input_a_shm, 0, sizeof(test_input_a_shm));
            memset(&test_input_b_shm, 0, sizeof(test_input_b_shm));

            test_input_a_shm.flags = TEEC_MEM_INPUT;
            test_input_a_shm.size = sizeof(test_input_memref_a);
            result = TEEC_AllocateSharedMemory(&context, &test_input_a_shm);
            if (result != TEEC_SUCCESS) {
                LOG_ERROR("TEEC_AllocateSharedMemory", result);
                goto cleanup_3;
            }

            test_input_b_shm.flags = TEEC_MEM_INPUT;
            test_input_b_shm.size = sizeof(test_input_memref_b);
            result = TEEC_AllocateSharedMemory(&context, &test_input_b_shm);
            if (result != TEEC_SUCCESS) {
                LOG_ERROR("TEEC_AllocateSharedMemory", result);
                goto cleanup_3;
            }

            memcpy(test_input_a_shm.buffer, test_input_memref_a, sizeof(test_input_memref_a));
            memcpy(test_input_b_shm.buffer, test_input_memref_b, sizeof(test_input_memref_b));

            // 设置参数
            if (i == 1) {
                operation.paramTypes = TEEC_PARAM_TYPES(
                    TEEC_MEMREF_WHOLE,
                    TEEC_MEMREF_WHOLE,
                    TEEC_MEMREF_TEMP_OUTPUT,
                    TEEC_NONE
                );
                operation.params[0].memref.parent = &test_input_a_shm;
                operation.params[0].memref.size = test_input_a_shm.size;
                operation.params[1].memref.parent = &test_input_b_shm;
                operation.params[1].memref.size = test_input_b_shm.size;
                operation.params[2].tmpref.buffer = test_output_tmpref;
                operation.params[2].tmpref.size = sizeof(test_output_tmpref);

                printf("a = %s, b = %s\r\n", test_input_memref_a, test_input_memref_b);
            } else {
                operation.paramTypes = TEEC_PARAM_TYPES(
                    TEEC_MEMREF_PARTIAL_INPUT,
                    TEEC_MEMREF_PARTIAL_INPUT,
                    TEEC_MEMREF_TEMP_OUTPUT,
                    TEEC_NONE
                );
                operation.params[0].memref.parent = &test_input_a_shm;
                operation.params[0].memref.offset = 3;
                operation.params[0].memref.size = 8;
                operation.params[1].memref.parent = &test_input_b_shm;
                operation.params[1].memref.offset = 0;
                operation.params[1].memref.size = 4;
                operation.params[2].tmpref.buffer = test_output_tmpref;
                operation.params[2].tmpref.size = sizeof(test_output_tmpref);

                printf("a = %8s, b = %.4s\r\n", test_input_memref_a + 3, test_input_memref_b + 0);
            }
        }

        // 调用命令
        result = TEEC_InvokeCommand(&session, STRCAT_TA_CMD_DEFAULT, &operation, NULL);
        if (result != TEEC_SUCCESS) {
            LOG_ERROR("TEEC_InvokeCommand", result);
            goto cleanup_3;
        }

        // 显示结果

        printf("out = %s (size = %u)\r\n", test_output_tmpref,
                (unsigned int)operation.params[2].tmpref.size);

        if ((i == 1) || (i == 2)) {
            TEEC_ReleaseSharedMemory(&test_input_a_shm);
            TEEC_ReleaseSharedMemory(&test_input_b_shm);

            printf("\r\n");
        }
    }

    printf("\r\n");

cleanup_3:
    TEEC_CloseSession(&session);

cleanup_2:
    TEEC_FinalizeContext(&context);

cleanup_1:
    TEEC_ReleaseSharedMemory(&test_input_a_shm);
    TEEC_ReleaseSharedMemory(&test_input_b_shm);

    return result;
}
