#include <stdio.h>
#include <string.h>
#include "tee_internal_api.h"
#include "tee_driver.h"
#include "strcat.h"

static TEE_UUID _strcat_ta_uuid = STRCAT_TA_UUID;

#define PARAM_STRING_MAX_LENGTH     100

static TEE_Result _TA_CreateEntryPoint(void) {
    return TEE_SUCCESS;
}

static void _TA_DestroyEntryPoint(void) {
    return;
}

static TEE_Result _TA_OpenSessionEntryPoint(uint32_t paramTypes, TEE_Param params[4], void **sessionContext) {
    *sessionContext = NULL;

    return TEE_SUCCESS;
}

static void _TA_CloseSessionEntryPoint(void *sessionContext) {
    return;
}

static TEE_Result _TA_InvokeCommandEntryPoint(void *sessionContext, uint32_t commandID, uint32_t paramTypes, TEE_Param params[4]) {
    size_t  aLen;
    size_t  bLen;
    size_t  outLen;
    char    *ptr;

    if (commandID != STRCAT_TA_CMD_DEFAULT) {
        return TEE_ERROR_BAD_PARAMETERS;
    }

    if (paramTypes != TEE_PARAM_TYPES(
            TEE_PARAM_TYPE_MEMREF_INPUT,
            TEE_PARAM_TYPE_MEMREF_INPUT,
            TEE_PARAM_TYPE_MEMREF_OUTPUT,
            TEE_PARAM_TYPE_NONE)) {
        return TEE_ERROR_BAD_PARAMETERS;
    }

    if ((params[0].memref.size > PARAM_STRING_MAX_LENGTH)
            || (params[1].memref.size > PARAM_STRING_MAX_LENGTH)) {
        return TEE_ERROR_BAD_PARAMETERS;
    }

    /*
    aLen = strnlen(params[0].memref.buffer, params[0].memref.size);
    bLen = strnlen(params[1].memref.buffer, params[1].memref.size);
    */

    aLen = strlen(params[0].memref.buffer);
    bLen = strlen(params[1].memref.buffer);
    if (aLen > params[0].memref.size) {
        aLen = params[0].memref.size;
    }
    if (bLen > params[1].memref.size) {
        bLen = params[1].memref.size;
    }

    if ((aLen >= PARAM_STRING_MAX_LENGTH)
            || (bLen >= PARAM_STRING_MAX_LENGTH)) {
        return TEE_ERROR_BAD_PARAMETERS;
    }

    outLen = aLen + bLen;
    if ((outLen + 1 /* terminating null byte */) >= params[2].memref.size) {
        return TEE_ERROR_OVERFLOW;
    }

    ptr = (char *)params[2].memref.buffer;

    memcpy((void *)ptr, params[0].memref.buffer, aLen);
    ptr += aLen;

    memcpy((void *)ptr, params[1].memref.buffer, bLen);
    ptr += bLen;

    *ptr = '\0';

    params[2].memref.size = outLen;

    return TEE_SUCCESS;
}

TA_Reference g_ta_reference_strcat = {
    .appId = &_strcat_ta_uuid,
    .entryPointTable = {
        .createEntryPoint = _TA_CreateEntryPoint,
        .destroyEntryPoint = _TA_DestroyEntryPoint,
        .openSessionEntryPoint = _TA_OpenSessionEntryPoint,
        .closeSessionEntryPoint = _TA_CloseSessionEntryPoint,
        .invokeCommandEntryPoint = _TA_InvokeCommandEntryPoint
    }
};
