#include <stdio.h>
#include <string.h>
#include <arm_cmse.h>
#include "NuMicro.h"

#include "apps/xor/xor.h"
#include "apps/strcat/strcat.h"

static uint32_t _ticks = 1;

static int _to_execute_test = 0;

void SysTick_Handler(void)
{
    _ticks++;

    if ((_ticks % 300) == 0) {
        _to_execute_test = 1;
    }
}

int main(void)
{
    int test_index = 0;

    printf("Entered Non-Secure main()\r\n");
    printf("\r\n");

    // 配置 Non-Secure 的 SysTick 为每 10ms 产生一次中断
    SystemCoreClockUpdate();
    SysTick_Config(SystemCoreClock / 100);

    while (1)
    {
        if (_to_execute_test)
        {
            if (test_index == 0)
            {
                printf("================ xor test ================\r\n");
                printf("\r\n");
                xor_test();
                printf("\r\n");

                test_index = 1;
            }
            else
            {
                printf("================ strcat test ================\r\n");
                printf("\r\n");
                strcat_test();
                printf("\r\n");

                test_index = 0;
            }

            _to_execute_test = 0;
        }
    }
}
