#include <stdio.h>
#include <string.h>
#include "tee_client_api.h"
#include "xor.h"

#define LOG_ERROR(func_name, result)     do {                                           \
    printf("ERROR: failed to call %s(), result = 0x%08x\r\n", (func_name), (result));   \
} while (0)

static const TEEC_UUID _uuid = XOR_TA_UUID;

int xor_test(void)
{
    TEEC_Context     context;
    TEEC_Session     session;
    TEEC_Operation   operation;
    TEEC_Result      result;
    unsigned int     a = 1, b = 1, c = 0;

    // 初始化 context
    result = TEEC_InitializeContext(NULL, &context);
    if (result != TEEC_SUCCESS) {
        LOG_ERROR("TEEC_InitializeContext", result);
        goto cleanup_1;
    }

    // 打开会话
    result = TEEC_OpenSession(&context, &session,
            &_uuid, TEEC_LOGIN_USER, NULL, NULL, NULL);
    if (result != TEEC_SUCCESS) {
        LOG_ERROR("TEEC_OpenSession", result);
        goto cleanup_2;
    }

    // 设置参数
    operation.paramTypes = TEEC_PARAM_TYPES(
            TEEC_VALUE_INPUT, TEEC_VALUE_INPUT,
            TEEC_VALUE_OUTPUT, TEEC_NONE);
    operation.params[0].value.a = a;
    operation.params[1].value.a = b;
    operation.params[2].value.a = c;

    // 调用命令
    result = TEEC_InvokeCommand(&session, XOR_TA_CMD_DEFAULT, &operation, NULL);
    if (result != TEEC_SUCCESS) {
        LOG_ERROR("TEEC_InvokeCommand", result);
        goto cleanup_3;
    }

    // 显示结果
    c = operation.params[2].value.a;
    printf("a = %d, b = %d, c = a ^ b = %d\r\n", a, b, c);

    // 改变输入参数的值
    a = 0;
    b = 1;

    // 设置参数
    operation.paramTypes = TEEC_PARAM_TYPES(
            TEEC_VALUE_INPUT, TEEC_VALUE_INPUT,
            TEEC_VALUE_OUTPUT, TEEC_NONE);
    operation.params[0].value.a = a;
    operation.params[1].value.a = b;
    operation.params[2].value.a = c;

    // 调用命令
    result = TEEC_InvokeCommand(&session, XOR_TA_CMD_DEFAULT, &operation, NULL);
    if (result != TEEC_SUCCESS) {
        LOG_ERROR("TEEC_InvokeCommand", result);
        goto cleanup_3;
    }

    // 显示结果
    c = operation.params[2].value.a;
    printf("a = %d, b = %d, c = a ^ b = %d\r\n", a, b, c);

cleanup_3:
    TEEC_CloseSession(&session);

cleanup_2:
    TEEC_FinalizeContext(&context);

cleanup_1:
    return result;
}
