#include <stdio.h>
#include "tee_internal_api.h"
#include "tee_driver.h"
#include "xor.h"

static TEE_UUID _xor_ta_uuid = XOR_TA_UUID;

static TEE_Result _TA_CreateEntryPoint(void) {
    return TEE_SUCCESS;
}

static void _TA_DestroyEntryPoint(void) {
    return;
}

static TEE_Result _TA_OpenSessionEntryPoint(uint32_t paramTypes, TEE_Param params[4], void **sessionContext) {
    *sessionContext = NULL;

    return TEE_SUCCESS;
}

static void _TA_CloseSessionEntryPoint(void *sessionContext) {
    return;
}

static TEE_Result _TA_InvokeCommandEntryPoint(void *sessionContext, uint32_t commandID, uint32_t paramTypes, TEE_Param params[4]) {
    switch (commandID) {
        case XOR_TA_CMD_DEFAULT:
        {
            if (paramTypes != TEE_PARAM_TYPES(
                        TEE_PARAM_TYPE_VALUE_INPUT,     // a
                        TEE_PARAM_TYPE_VALUE_INPUT,     // b
                        TEE_PARAM_TYPE_VALUE_OUTPUT,
                        TEE_PARAM_TYPE_NONE
                    )) {
                return TEE_ERROR_BAD_PARAMETERS;
            }

            params[2].value.a = params[0].value.a ^ params[1].value.a;
            break;
        }

        default:
            return TEE_ERROR_BAD_PARAMETERS;
    }

    return TEE_SUCCESS;
}

TA_Reference g_ta_reference_xor = {
    .appId = &_xor_ta_uuid,
    .entryPointTable = {
        .createEntryPoint = _TA_CreateEntryPoint,
        .destroyEntryPoint = _TA_DestroyEntryPoint,
        .openSessionEntryPoint = _TA_OpenSessionEntryPoint,
        .closeSessionEntryPoint = _TA_CloseSessionEntryPoint,
        .invokeCommandEntryPoint = _TA_InvokeCommandEntryPoint
    }
};
