#ifndef __IOT_INTERFACE_SECURE_H__
#define __IOT_INTERFACE_SECURE_H__

#ifdef __cplusplus
extern "C" {
#endif

#include "tee_driver.h"

extern TA_Reference g_ta_reference_iotsdk;

typedef unsigned char       iot_u8;
typedef signed char         iot_s8;
typedef unsigned short      iot_u16;
typedef signed short        iot_s16;
typedef unsigned int        iot_u32;
typedef signed int          iot_s32;
typedef unsigned long long  iot_u64;
typedef signed long long    iot_s64;
typedef float               iot_f32;
typedef double              iot_f64;

struct iot_context_secure {
    iot_u32 product_id;         // 平台生成，4 字节的无符号整型数字，全网唯一产品 ID (需与 iot_context 结构体中所配置的值一致)
    iot_u8  product_key[16];    // 云平台生成，16 字节的十六进制编码，全网唯一产品秘钥
};

/*****************************************************************************
函数名称 : iot_secure_config
功能描述 : 初始化配置，请在 NonSecure 区域代码调用 iot_start() 之前，在 Secure 区调用
传入参数 : ctx : 指向存储有配置信息的 iot_context_secure 结构体的指针
传出参数 : 无
返回参数 : -1 : 失败
           0  : 成功
*****************************************************************************/
extern iot_s32 iot_secure_config(struct iot_context_secure *ctx_secure);

/*****************************************************************************
函数名称 : iot_secure_crpt_aes_is_done
功能描述 : 通知 AES 加密已完成，在 CRPT_IRQHandler() 中断处理函数中判断 AES_GET_INT_FLAG(CRPT) 为 true 时调用
传入参数 : 无
传出参数 : 无
返回参数 : 无
*****************************************************************************/
extern void iot_secure_crpt_aes_is_done(void);

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __IOT_INTERFACE_SECURE_H__ */
