#ifndef __OTA_H__
#define __OTA_H__

#if defined (__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE == 3)

// Secure

#include "tee_driver.h"

extern TA_Reference g_ta_reference_iotota;

void otaCheckFirmwareAndBoot(void);

int otaWriteNewFirmwareBegin(void);

int otaWriteNewFirmwareData(uint32_t offset, const uint8_t *data, uint32_t dataLength);

int otaWriteNewFirmwareEnd(void);

int otaReboot(void);

#else

// Non-Secure

#include <stdbool.h>
#include <stdint.h>

bool iotota_ca_open_session(void);

void iotota_ca_close_session(void);

int iotota_ca_write_new_firmware_begin(void);

int iotota_ca_write_new_firmware_data(uint32_t offset, const uint8_t *data, uint32_t dataLength);

int iotota_ca_write_new_firmware_end(void);

int iotota_ca_reboot(void);

#endif  // #if defined (__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE == 3)

#endif  // __OTA_H__
