/*********************************************************************
*                 SEGGER Software GmbH                               *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2018  SEGGER Microcontroller GmbH                *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.46 - Graphical user interface for embedded applications **
All  Intellectual Property rights in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product. This file may
only be used in accordance with the following terms:

The  software has  been licensed by SEGGER Software GmbH to Nuvoton Technology Corporation
at the address: No. 4, Creation Rd. III, Hsinchu Science Park, Taiwan
for the purposes  of  creating  libraries  for its
Arm Cortex-M and  Arm9 32-bit microcontrollers, commercialized and distributed by Nuvoton Technology Corporation
under  the terms and conditions  of  an  End  User
License  Agreement  supplied  with  the libraries.
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
Licensing information
Licensor:                 SEGGER Software GmbH
Licensed to:              Nuvoton Technology Corporation, No. 4, Creation Rd. III, Hsinchu Science Park, 30077 Hsinchu City, Taiwan
Licensed SEGGER software: emWin
License number:           GUI-00735
License model:            emWin License Agreement, signed February 27, 2018
Licensed platform:        Cortex-M and ARM9 32-bit series microcontroller designed and manufactured by or for Nuvoton Technology Corporation
----------------------------------------------------------------------
Support and Update Agreement (SUA)
SUA period:               2018-03-26 - 2019-03-27
Contact to extend SUA:    sales@segger.com
----------------------------------------------------------------------
File        : GUIDEMO_ZoomAndRotate.c
Purpose     : Demo of zooming and rotating images
---------------------------END-OF-HEADER------------------------------
*/

#include "GUIDEMO.h"

#if (SHOW_GUIDEMO_ZOOMANDROTATE && GUI_WINSUPPORT && GUI_SUPPORT_MEMDEV)

/*********************************************************************
*
*       Defines
*
**********************************************************************
*/
#define MAG                        300
#define TITLE_SIZE                 40
#define MIN_TIME_PER_FRAME_SHIFT   20
#define MIN_TIME_PER_FRAME_ENLARGE 30
#define BORDER_SIZE                4
#define FINAL_STEP                 100

//
// Memory device format in dependence of color format
//
#if (GUI_USE_ARGB)
#define GUI_COLOR_CONV GUICC_M8888I
#else
#define GUI_COLOR_CONV GUICC_8888
#endif

/*********************************************************************
*
*       Static const data
*
**********************************************************************
*/
/*********************************************************************
*
*       _bmSeggerLogo50
*/
static GUI_CONST_STORAGE GUI_COLOR _ColorsSeggerLogo50[] =
{
#if (GUI_USE_ARGB)
    0xFFFFFFFF, 0xFFFFFFFF, 0xFF231F20, 0xFF989697,
    0xFF6767BE, 0xFF5858B8, 0xFF959494, 0xFF2020A0,
    0xFFD3D3EC, 0xFFC0BFC0, 0xFF929090, 0xFF1E1B1C,
    0xFF464344, 0xFF2323A1, 0xFF2A2AA4, 0xFF3333A8,
    0xFF949393, 0xFFABA9AA, 0xFFD6D6EE, 0xFFFAFAFD,
    0xFFFDFDFD, 0xFFFEFEFF, 0xFF7F7D7E, 0xFF5F5FBB,
    0xFF6464BD, 0xFF868485, 0xFF9F9E9E, 0xFFA3A2A2,
    0xFFC3C2C2, 0xFFFEFEFE, 0xFF1E1B1B, 0xFF242021,
    0xFF272425, 0xFF2F2B2C, 0xFF5C595A, 0xFF6F6C6D,
    0xFF2424A2, 0xFF2828A3, 0xFF2828A4, 0xFF2C2CA5,
    0xFF3939AB, 0xFF3F3FAD, 0xFF4141AE, 0xFF4242AE,
    0xFF4646B0, 0xFF4A4AB2, 0xFF5151B5, 0xFF6A6AC0,
    0xFF7171C3, 0xFF7979C6, 0xFF7E7EC8, 0xFF7F7FC8,
    0xFF939192, 0xFFA6A4A4, 0xFFABA9A9, 0xFFBAB9B9,
    0xFFBBBABA, 0xFFBEBDBD, 0xFF8383CA, 0xFF9090D0,
    0xFF9494D1, 0xFF9595D2, 0xFF9A9AD4, 0xFFA8A8DA,
    0xFFAFAFDD, 0xFFB0B0DD, 0xFFB3B3DF, 0xFFB5B5DF,
    0xFFB8B8E1, 0xFFC0BFBF, 0xFFC9C8C8, 0xFFCECDCD,
    0xFFD4D3D3, 0xFFC4C4E6, 0xFFCCCCE9, 0xFFD2D2EC,
    0xFFD8D8EE, 0xFFD9D9EF, 0xFFDFDFF1, 0xFFE8E8E8,
    0xFFECECEC, 0xFFE4E4F4, 0xFFE6E6F4, 0xFFE6E6F5,
    0xFFEAEAF6, 0xFFF0F0F0, 0xFFF5F5F5, 0xFFF0F0F9,
    0xFFF1F1F9, 0xFFF3F3FA, 0xFFF5F5FB, 0xFFF6F6FB,
    0xFFFBFBFB, 0xFFF8F8FC, 0xFFFCFCFE, 0xFFFDFDFE,
    0xFF080707, 0xFF141314, 0xFF262324, 0xFF272324,
    0xFF282425, 0xFF2A2627, 0xFF2E2A2B, 0xFF333031,
    0xFF343031, 0xFF373334, 0xFF393536, 0xFF3B3738,
    0xFF3C3839, 0xFF3E3B3B, 0xFF3F3C3D, 0xFF403D3E,
    0xFF454142, 0xFF4B4849, 0xFF4C494A, 0xFF4D494A,
    0xFF4E4B4C, 0xFF514E4F, 0xFF535051, 0xFF555253,
    0xFF585455, 0xFF595657, 0xFF5D5A5B, 0xFF5E5B5B,
    0xFF5E5B5C, 0xFF5F5D5D, 0xFF625F5F, 0xFF666364,
    0xFF676666, 0xFF686566, 0xFF6F6E6E, 0xFF737171,
    0xFF747172, 0xFF787576, 0xFF787676, 0xFF797677,
    0xFF797777, 0xFF3C3CAC, 0xFF3D3DAC, 0xFF6565BD,
    0xFF817F80, 0xFF828080, 0xFF848283, 0xFF888686,
    0xFF888687, 0xFF898787, 0xFF8E8B8C, 0xFF8F8D8D,
    0xFF908E8E, 0xFF929191, 0xFF949293, 0xFF959393,
    0xFF979596, 0xFF989696, 0xFF999797, 0xFF9E9C9D,
    0xFF9F9D9E, 0xFFA09E9E, 0xFFA4A2A3, 0xFFA5A4A4,
    0xFFA6A4A5, 0xFFA8A6A6, 0xFFA8A6A7, 0xFFA9A7A8,
    0xFFAAA9A9, 0xFFACAAAA, 0xFFACAAAB, 0xFFADABAC,
    0xFFAEADAD, 0xFFAFAEAE, 0xFFB0AFAF, 0xFFB1AFB0,
    0xFFB1B0B0, 0xFFB5B3B4, 0xFFB6B4B5, 0xFFB7B6B6,
    0xFFBDBCBC, 0xFFBDBCBD, 0xFFBFBEBE, 0xFFAAAADB,
    0xFFACACDC, 0xFFC1C0C0, 0xFFC8C7C8, 0xFFCAC9CA,
    0xFFCDCCCC, 0xFFCFCECE, 0xFFD0CFCF, 0xFFD2D1D1,
    0xFFD7D6D6, 0xFFD9D8D8, 0xFFDAD9D9, 0xFFDADADA,
    0xFFDBDBDB, 0xFFDCDCDC, 0xFFDEDDDE, 0xFFDEDEDE,
    0xFFDBDBF0, 0xFFDCDCF0, 0xFFE2E2E2, 0xFFE4E4E4,
    0xFFE5E4E5, 0xFFE9E9E9, 0xFFEBEAEA, 0xFFEBEBEB,
    0xFFEDECEC, 0xFFEEEEEE, 0xFFEDEDF7, 0xFFEDEDF8,
    0xFFF1F0F0, 0xFFF2F1F1, 0xFFF2F2F2, 0xFFF3F3F3,
    0xFFF4F3F3, 0xFFF4F4F4, 0xFFF7F7F7, 0xFFF8F8F8,
    0xFFF9F9F9, 0xFFFAFAFA, 0xFFFCFCFC
#else
    0xFFFFFF, 0xFFFFFF, 0x201F23, 0x979698,
    0xBE6767, 0xB85858, 0x949495, 0xA02020,
    0xECD3D3, 0xC0BFC0, 0x909092, 0x1C1B1E,
    0x444346, 0xA12323, 0xA42A2A, 0xA83333,
    0x939394, 0xAAA9AB, 0xEED6D6, 0xFDFAFA,
    0xFDFDFD, 0xFFFEFE, 0x7E7D7F, 0xBB5F5F,
    0xBD6464, 0x858486, 0x9E9E9F, 0xA2A2A3,
    0xC2C2C3, 0xFEFEFE, 0x1B1B1E, 0x212024,
    0x252427, 0x2C2B2F, 0x5A595C, 0x6D6C6F,
    0xA22424, 0xA32828, 0xA42828, 0xA52C2C,
    0xAB3939, 0xAD3F3F, 0xAE4141, 0xAE4242,
    0xB04646, 0xB24A4A, 0xB55151, 0xC06A6A,
    0xC37171, 0xC67979, 0xC87E7E, 0xC87F7F,
    0x929193, 0xA4A4A6, 0xA9A9AB, 0xB9B9BA,
    0xBABABB, 0xBDBDBE, 0xCA8383, 0xD09090,
    0xD19494, 0xD29595, 0xD49A9A, 0xDAA8A8,
    0xDDAFAF, 0xDDB0B0, 0xDFB3B3, 0xDFB5B5,
    0xE1B8B8, 0xBFBFC0, 0xC8C8C9, 0xCDCDCE,
    0xD3D3D4, 0xE6C4C4, 0xE9CCCC, 0xECD2D2,
    0xEED8D8, 0xEFD9D9, 0xF1DFDF, 0xE8E8E8,
    0xECECEC, 0xF4E4E4, 0xF4E6E6, 0xF5E6E6,
    0xF6EAEA, 0xF0F0F0, 0xF5F5F5, 0xF9F0F0,
    0xF9F1F1, 0xFAF3F3, 0xFBF5F5, 0xFBF6F6,
    0xFBFBFB, 0xFCF8F8, 0xFEFCFC, 0xFEFDFD,
    0x070708, 0x141314, 0x242326, 0x242327,
    0x252428, 0x27262A, 0x2B2A2E, 0x313033,
    0x313034, 0x343337, 0x363539, 0x38373B,
    0x39383C, 0x3B3B3E, 0x3D3C3F, 0x3E3D40,
    0x424145, 0x49484B, 0x4A494C, 0x4A494D,
    0x4C4B4E, 0x4F4E51, 0x515053, 0x535255,
    0x555458, 0x575659, 0x5B5A5D, 0x5B5B5E,
    0x5C5B5E, 0x5D5D5F, 0x5F5F62, 0x646366,
    0x666667, 0x666568, 0x6E6E6F, 0x717173,
    0x727174, 0x767578, 0x767678, 0x777679,
    0x777779, 0xAC3C3C, 0xAC3D3D, 0xBD6565,
    0x807F81, 0x808082, 0x838284, 0x868688,
    0x878688, 0x878789, 0x8C8B8E, 0x8D8D8F,
    0x8E8E90, 0x919192, 0x939294, 0x939395,
    0x969597, 0x969698, 0x979799, 0x9D9C9E,
    0x9E9D9F, 0x9E9EA0, 0xA3A2A4, 0xA4A4A5,
    0xA5A4A6, 0xA6A6A8, 0xA7A6A8, 0xA8A7A9,
    0xA9A9AA, 0xAAAAAC, 0xABAAAC, 0xACABAD,
    0xADADAE, 0xAEAEAF, 0xAFAFB0, 0xB0AFB1,
    0xB0B0B1, 0xB4B3B5, 0xB5B4B6, 0xB6B6B7,
    0xBCBCBD, 0xBDBCBD, 0xBEBEBF, 0xDBAAAA,
    0xDCACAC, 0xC0C0C1, 0xC8C7C8, 0xCAC9CA,
    0xCCCCCD, 0xCECECF, 0xCFCFD0, 0xD1D1D2,
    0xD6D6D7, 0xD8D8D9, 0xD9D9DA, 0xDADADA,
    0xDBDBDB, 0xDCDCDC, 0xDEDDDE, 0xDEDEDE,
    0xF0DBDB, 0xF0DCDC, 0xE2E2E2, 0xE4E4E4,
    0xE5E4E5, 0xE9E9E9, 0xEAEAEB, 0xEBEBEB,
    0xECECED, 0xEEEEEE, 0xF7EDED, 0xF8EDED,
    0xF0F0F1, 0xF1F1F2, 0xF2F2F2, 0xF3F3F3,
    0xF3F3F4, 0xF4F4F4, 0xF7F7F7, 0xF8F8F8,
    0xF9F9F9, 0xFAFAFA, 0xFCFCFC
#endif
};

static GUI_CONST_STORAGE GUI_LOGPALETTE _PalSeggerLogo50 =
{
    219,  // Number of entries
    1,    // Has transparency
    &_ColorsSeggerLogo50[0]
};

static GUI_CONST_STORAGE unsigned char _acSeggerLogo50[] =
{
    0x00, 0x0B, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0B, 0x00,
    0x1E, 0x0C, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0C, 0x1E,
    0x02, 0x10, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x10, 0x02,
    0x02, 0x06, 0x5E, 0x42, 0x13, 0x01, 0x01, 0x4B, 0x4C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x02,
    0x02, 0x06, 0x51, 0x0D, 0x33, 0x01, 0x01, 0x2F, 0x0F, 0x53, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x02,
    0x02, 0x06, 0x01, 0x3C, 0x07, 0x43, 0x01, 0x52, 0x0F, 0x2E, 0x13, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x02,
    0x02, 0x06, 0x01, 0x5F, 0x17, 0x27, 0x4E, 0x01, 0x49, 0x0D, 0x32, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x02,
    0x02, 0x06, 0x01, 0x01, 0xCE, 0x28, 0x2D, 0x5D, 0x01, 0x3D, 0x07, 0x41, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x02,
    0x02, 0x06, 0x54, 0x5A, 0x01, 0x4A, 0x24, 0x31, 0x01, 0x15, 0x18, 0x0E, 0x4D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x02,
    0x02, 0x06, 0x08, 0x30, 0x01, 0x01, 0x3E, 0x07, 0x40, 0x01, 0x58, 0x29, 0x2A, 0x59, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x02,
    0x02, 0x06, 0x08, 0x07, 0x3F, 0x01, 0x15, 0x18, 0x0E, 0xC5, 0x01, 0x12, 0x26, 0x2B, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
    0x05, 0x05, 0x05, 0x05, 0x3A, 0x01, 0x06, 0x02,
    0x02, 0x06, 0x08, 0x07, 0x25, 0x12, 0x01, 0x57, 0x89, 0x2C, 0x5B, 0x01, 0x44, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x04, 0x04, 0x04, 0x3B, 0x01, 0x06, 0x02,
    0x02, 0x06, 0x08, 0x07, 0x07, 0x17, 0x01, 0x01, 0xB4, 0x07, 0xB3, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x02,
    0x02, 0x06, 0x08, 0x07, 0x25, 0x12, 0x01, 0x57, 0x8A, 0x2C, 0x5B, 0x01, 0x44, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x04, 0x04, 0x04, 0x3B, 0x01, 0x06, 0x02,
    0x02, 0x06, 0x08, 0x07, 0x3F, 0x01, 0x15, 0x8B, 0x0E, 0xC4, 0x01, 0x12, 0x26, 0x2B, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
    0x05, 0x05, 0x05, 0x05, 0x3A, 0x01, 0x06, 0x02,
    0x02, 0x06, 0x08, 0x30, 0x01, 0x01, 0x3E, 0x07, 0x40, 0x01, 0x58, 0x29, 0x2A, 0x59, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x02,
    0x02, 0x06, 0x54, 0x5A, 0x01, 0x4A, 0x24, 0x31, 0x01, 0x15, 0x18, 0x0E, 0x4D, 0x01, 0xBB, 0xA2, 0x37, 0xD8, 0x01, 0xB8, 0x09, 0x09, 0x1C, 0x5C, 0x01, 0x47, 0xA1, 0xB1, 0xD9, 0x01, 0x01, 0xBD, 0xA3, 0xAF, 0xD5, 0x01, 0x4F, 0x09, 0x09, 0x09, 0xC6, 0xD1,
    0xB5, 0x09, 0x1C, 0xCB, 0x01, 0x01, 0x06, 0x02,
    0x02, 0x06, 0x01, 0x01, 0xCF, 0x28, 0x2D, 0x5D, 0x01, 0x3D, 0x07, 0x41, 0x01, 0x38, 0x6D, 0x9E, 0x81, 0x23, 0x14, 0x1F, 0x86, 0x19, 0x91, 0x55, 0x90, 0x70, 0x9A, 0x7C, 0x7A, 0x01, 0x35, 0x6A, 0x97, 0x23, 0x6E, 0x1D, 0x8C, 0x73, 0x19, 0x19, 0x39, 0x9F,
    0x6C, 0x8F, 0x84, 0x21, 0x55, 0x01, 0x06, 0x02,
    0x02, 0x06, 0x01, 0x5F, 0x17, 0x27, 0x4E, 0x01, 0x49, 0x0D, 0x32, 0x01, 0x01, 0xAD, 0x68, 0x94, 0x45, 0xCA, 0xDA, 0x02, 0x92, 0x1A, 0xA9, 0x56, 0x63, 0xBA, 0x1D, 0x4F, 0x47, 0x01, 0x6B, 0xAB, 0x01, 0xCC, 0x46, 0x1D, 0x16, 0x78, 0x1A, 0x9D, 0xC8, 0x1B,
    0x74, 0x48, 0xB2, 0x65, 0x50, 0x01, 0x06, 0x02,
    0x02, 0x06, 0x01, 0x3C, 0x07, 0x43, 0x01, 0x52, 0x0F, 0x2E, 0x13, 0x01, 0x01, 0x14, 0xB7, 0x96, 0x75, 0x6F, 0xD7, 0x02, 0x98, 0x36, 0x37, 0xD0, 0x02, 0xBE, 0xC2, 0x7D, 0x62, 0xC3, 0x67, 0x38, 0xD2, 0x7E, 0x21, 0x45, 0x16, 0x22, 0x36, 0x11, 0xC9, 0x1B,
    0x69, 0x83, 0x76, 0x77, 0x01, 0x01, 0x06, 0x02,
    0x02, 0x06, 0x51, 0x0D, 0x33, 0x01, 0x01, 0x2F, 0x0F, 0x53, 0x01, 0x01, 0x01, 0xAA, 0x72, 0x46, 0xA7, 0x66, 0x56, 0x02, 0x99, 0x11, 0xA5, 0x50, 0x7F, 0x7B, 0x1C, 0x34, 0x1F, 0xC0, 0x8E, 0x71, 0x39, 0x35, 0x64, 0xB0, 0x16, 0x22, 0x11, 0x11, 0xB6, 0x1B,
    0x79, 0x01, 0xBF, 0x02, 0xD4, 0x01, 0x06, 0x02,
    0x02, 0x06, 0x5E, 0x42, 0x13, 0x01, 0x01, 0x4B, 0x4C, 0x01, 0x01, 0x01, 0x01, 0x14, 0xA6, 0x88, 0x8D, 0x48, 0x01, 0x1A, 0x0A, 0x0A, 0x95, 0xC7, 0xD6, 0x9B, 0x85, 0x9C, 0xA0, 0xCD, 0x14, 0xA4, 0x87, 0x34, 0xAC, 0xC1, 0xB9, 0x0A, 0x0A, 0x0A, 0xAE, 0xBC,
    0xA8, 0x01, 0x5C, 0x93, 0xD3, 0x01, 0x06, 0x02,
    0x02, 0x10, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x10, 0x02,
    0x20, 0x0C, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0C, 0x20,
    0x00, 0x0B, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0B, 0x00
};

static GUI_CONST_STORAGE GUI_BITMAP _bmSeggerLogo50 =
{
    50,                // XSize
    25,                // YSize
    50,                // BytesPerLine
    8,                 // BitsPerPixel
    _acSeggerLogo50,   // Pointer to picture data (indices)
    &_PalSeggerLogo50  // Pointer to palette
};

/*********************************************************************
*
*       bmPlatine_250x200
*/
#if (GUI_USE_ARGB)
static GUI_CONST_STORAGE unsigned long _acPlatine_250x200[] =
{
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFEFE, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FDFDFD, 0x00FFFFFF, 0x00FEFEFE, 0x1BE8E8E8, 0x17EBEBE9, 0x3DD8D8D6, 0x45D4D4D2, 0x45D4D4D2, 0x45D4D4D2,
    0x39D9D9D7, 0x3DD7D7D5, 0x45D4D4D2, 0x3DD8DAD5, 0x41D8D9D4, 0x3DDADBD6, 0x3DD9DAD5, 0x45D6D5D1, 0x41D8D7D3, 0x35E0DCD9, 0x31E2DEDB, 0x45DCD9D2, 0x39E1DED7, 0x35E3E0D9, 0x3DE0DDD6, 0x45DCD9D2, 0x45DCD9D2, 0x3DE0DDD6, 0x35E3E0D9, 0x45DFDBD2,
    0x3DE3DFD6, 0x41DDDAD3, 0x41DDDAD3, 0x39DDDCD7, 0x41DAD9D4, 0x3DDBDCD6, 0x35DDDED9, 0x48DBD8CF, 0x39E4E1D8, 0x45DADAD2, 0x48D8D8D0, 0x45D7D8D2, 0x3DDADBD5, 0x1BECEDE7, 0x1BEAECE7, 0x00F8F8F8, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFEFE, 0x00FFFFFF,
    0x00FFFFFF, 0x00FEFEFE, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFEFE, 0x00FFFFFF, 0x00FEFEFE, 0x00FFFFFF, 0x00F7F7F7, 0x48CFCFCF, 0xFFBABAB8, 0xFF949492, 0xFF848482, 0xFF858583, 0xFF8A8A88,
    0xFF90908E, 0xFF8A8A88, 0xFF888886, 0xFF959691, 0xFF979893, 0xFF989994, 0xFF989793, 0xFF979692, 0xFF9A9693, 0xFF989491, 0xFF938F8C, 0xFF9A9790, 0xFFA19E97, 0xFFA4A19A, 0xFFA09D96, 0xFF9F9C95, 0xFFA29F98, 0xFF9F9C95, 0xFF99968F, 0xFFA19D94,
    0xFFA5A198, 0xFFA29E95, 0xFFA6A39C, 0xFFA6A39C, 0xFF9D9C97, 0xFF9D9C97, 0xFF94938E, 0xFF99968D, 0xFFA09D94, 0xFF97948B, 0xFF919189, 0xFF8E8E86, 0xFF999A94, 0xFFB3B4AE, 0x72BFC0BA, 0x04F4F4F4, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFEFE, 0x00FFFFFF,
    0x00FFFFFF, 0x00FDFDFD, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FCFCFC, 0x00FFFFFF, 0x00FEFEFE, 0x00FFFFFF, 0x04F4F4F4, 0x6EBCBCBC, 0xFFBDBEB9, 0xFFACADA8, 0xFFAEAFAA, 0xFFABACA7, 0xFFA5A6A1,
    0xFFA2A39E, 0xFF9FA09B, 0xFFADAEA9, 0xFFCACBC6, 0xFFD7D6D2, 0xFFDAD9D5, 0xFFDBDAD6, 0xFFE3DFDC, 0xFFDFDBD8, 0xFFCAC5C2, 0xFFB7B2AF, 0xFFCFCCC7, 0xFFDCD9D4, 0xFFE4E1DC, 0xFFE3E0DB, 0xFFE8E5E0, 0xFFECE9E4, 0xFFDDDAD5, 0xFFC6C3BE, 0xFFD7D0C8,
    0xFFD4CFC9, 0xFFD5D0CA, 0xFFE3DED8, 0xFFE0DDD8, 0xFFD9D6D1, 0xFFD6D5D1, 0xFFC1C0BC, 0xFFBCB8AF, 0xFFBEB9B3, 0xFFBAB7B0, 0xFFB5B2AB, 0xFFA8A7A2, 0xFFADACA7, 0xFFB7B6B2, 0xFFC4C5C0, 0x0BF0F0F0, 0x00FFFFFF, 0x00FFFFFF, 0x00FDFDFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FDFDFD, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FDFDFD, 0x00FFFFFF, 0x00FCFCFC, 0x00FFFFFF, 0x00F5F5F5, 0x7AB6B6B6, 0xFFB0B1AC, 0xFFB8B9B4, 0xFFCBCCC7, 0xFFC0C1BC, 0xFFB2B3AE,
    0xFFADAEA9, 0xFFABACA7, 0xFFC0C1BC, 0xFFD5D4CF, 0xFFF4F3EE, 0xFFFFFFFA, 0xFFFFFFFA, 0xFFFFFFFA, 0xFFFFFAF6, 0xFFDDD8D4, 0xFFC6C1BD, 0xFFE6E1DE, 0xFFFBF6F3, 0xFFFFFEFB, 0xFFFFFBF8, 0xFFFFFEFB, 0xFFFFFEFB, 0xFFFFFBF8, 0xFFE6E1DE, 0xFFF1E9E6,
    0xFFEBE3E0, 0xFFEDE8E4, 0xFFFFFEFB, 0xFFFFFEFB, 0xFFFFFEFD, 0xFFFFFEFD, 0xFFECE8E7, 0xFFC4BFBB, 0xFFBFBAB6, 0xFFC3BEBA, 0xFFC1BDBA, 0xFFB5B1AE, 0xFFB4B3B1, 0xFFA8A7A5, 0xFFB3B2B0, 0x0FEDEDED, 0x00FFFFFF, 0x00FFFFFF, 0x00FCFCFC, 0x00FFFFFF,
    0x00FFFFFF, 0x00FCFCFC, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FDFDFD, 0x00FFFFFF, 0x00FEFEFE, 0x00FFFFFF, 0x00FBFBFB, 0x00FFFFFF, 0x00F8F8F8, 0x76B8B8B8, 0xFFB0B1AC, 0xFFB6B7B2, 0xFFBDBEB9, 0xFFAAABA6, 0xFFA5A6A1,
    0xFFAAABA6, 0xFFA1A29D, 0xFFADAEA9, 0xFFBAB9B4, 0xFFEBEAE5, 0xFFFFFFFA, 0xFFFFFCF7, 0xFFFFFFFA, 0xFFF2EDE9, 0xFFD0CBC7, 0xFFBFBAB6, 0xFFCAC4C4, 0xFFEFE9E9, 0xFFFFFDFD, 0xFFFFFAFA, 0xFFFDF7F7, 0xFFFFFCFC, 0xFFF5EFEF, 0xFFDAD4D4, 0xFFBDB5B3,
    0xFFBEB6B4, 0xFFD7CFCD, 0xFFFFF9F9, 0xFFFFFDFD, 0xFFFFFBFC, 0xFFFAF6F7, 0xFFCDC9CA, 0xFFAFAAA7, 0xFFA29D9A, 0xFFA8A3A0, 0xFFACA8A7, 0xFFA9A5A4, 0xFFB1AFB0, 0xFFA19FA0, 0xFFB1AFB0, 0x13ECECEC, 0x00FFFFFF, 0x00FFFFFF, 0x00FCFCFC, 0x00FFFFFF,
    0x00FFFFFF, 0x00FCFCFC, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FBFFFF, 0x00FCFFFF, 0x00FEFFFF, 0x00FCFCFC, 0x00FBFBFB, 0x00FDFFFE, 0x00FBFFFE, 0x00FBFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FDFFFE, 0x00FDFFFE, 0x00FCFEFD,
    0x00FDFFFE, 0x00FDFFFE, 0x00FDFFFE, 0x00FCFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FDFFFE, 0x00FEFFFF,
    0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FBFFFD, 0x00FBFFFD, 0x00FBFFFD, 0x00FBFFFD, 0x00FBFFFD,
    0x00FBFFFD, 0x00FBFFFD, 0x00FBFFFD, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FBFFFE, 0x00FEFFFF, 0x00FEFFFF, 0x00FFFFFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFDFE, 0x00FFFBFD,
    0x00FFFDFF, 0x00FEFCFD, 0x00FDFDFD, 0x00FDFDFD, 0x00FEFCFD, 0x00FFFDFF, 0x00FFFBFD, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFCFF, 0x00FFFBFD, 0x00FFFAFC, 0x00FFFEFF, 0x00FFFEFF,
    0x00FEFCFD, 0x00FCFAFB, 0x00FCFCFC, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFBFC, 0x00FFFBFC, 0x00FFFCFD, 0x00FFFDFE, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFDFE,
    0x00FFFDFE, 0x00FFFDFE, 0x00FFFDFE, 0x00FFFDFE, 0x00FFFDFE, 0x00FFFDFE, 0x00FFFDFE, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFEFE, 0x00FEFEFE, 0x00FEFEFE, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FEFEFE, 0x00FEFEFE, 0x00FEFEFE, 0x00FEFEFE, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFBFF, 0x00FFFBFE, 0x00FFFDFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFFFF, 0x00F5F7F6, 0x7AB6B8B7, 0xFFBABBB6, 0xFFB3B4AF, 0xFFBBBCB7, 0xFFAAABA6, 0xFF93948F,
    0xFF9A9B96, 0xFFA9AAA5, 0xFFB4B5B0, 0xFFB6B7B1, 0xFFEEEFE9, 0xFFF9FAF4, 0xFFF8F9F3, 0xFFFDFEF8, 0xFFD2D3CD, 0xFFA0A19B, 0xFF94958F, 0xFFA7A3A0, 0xFFACA8A5, 0xFFF4F0ED, 0xFFFFFEFB, 0xFFFAF6F3, 0xFFFFFEFB, 0xFFD2CECB, 0xFF9C9895, 0xFF92938E,
    0xFF92938E, 0xFFA1A29D, 0xFFFFFFFD, 0xFFFBFBF9, 0xFFFDFDFD, 0xFFF9F9F9, 0xFFAFAFAF, 0xFFA7A8A3, 0xFFA0A19C, 0xFF9C9D98, 0xFF9A9B96, 0xFFA0A19C, 0xFFA5A6A1, 0xFFAAABA6, 0xFFB9BAB5, 0x17F0EAEC, 0x00FFFDFF, 0x00FFFDFF, 0x00FFFDFF, 0x00FFFAFC,
    0x00FFFBFD, 0x00FFFDFF, 0x00FFF9FB, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFDFE, 0x00FFFDFE, 0x00FEFCFD, 0x00FFFDFE, 0x00FFFDFE, 0x00FFFDFE, 0x00FEFEFE, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFBFD, 0x00FFFDFF, 0x00FFFDFF, 0x00F9F7F8, 0x00FFFEFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FCFFFF, 0x00FDFFFE, 0x00FEFEFE, 0x00FFFDFE, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFFFF, 0x00FAFAFA, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFDFE,
    0x00FFFDFE, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFEFE, 0x00FDFDFD, 0x00FDFDFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FCFCFC, 0x00FDFDFD, 0x00FEFEFE, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFEFE, 0x00FEFEFE, 0x00FEFFFD, 0x00FEFFFD, 0x00FEFFFD, 0x00FEFFFD, 0x00FEFFFD,
    0x00FEFFFD, 0x00FEFFFD, 0x00FEFFFD, 0x00FFFDFE, 0x00FFFDFE, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FAFEFD, 0x00FBFDFC, 0x00FCFEFD, 0x00FEFEFE, 0x00FFFFFF, 0x00FEFEFE, 0x00FFFEFF,
    0x00FFFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FFFFFF, 0x00FFFEFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFE, 0x00FEFCFD, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFFFF,
    0x00FEFFFF, 0x00FDFFFE, 0x00FCFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FBFFFE, 0x00FBFFFE, 0x00FAFEFD,
    0x00FAFEFD, 0x00F9FDFC, 0x00F8FCFB, 0x00FCFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFEFE, 0x00FDFDFD, 0x00FCFCFC, 0x00FBFBFB, 0x00FBFFFE,
    0x00FBFFFE, 0x00FBFFFE, 0x00FCFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FEFAFB, 0x00FFFEFF, 0x00FFFFFF, 0x00FEFEFE, 0x00FEFFFF, 0x00FCFFFF, 0x08F2F8F6, 0x89ADB3B1, 0xFFB5B6B1, 0xFFABACA7, 0xFFB7B8B3, 0xFFB0B1AC, 0xFF9B9C97,
    0xFF9A9B96, 0xFFA2A39E, 0xFFA9AAA5, 0xFF979892, 0xFFA8A9A3, 0xFFA3A49E, 0xFFA1A29C, 0xFFA5A6A0, 0xFF9A9B95, 0xFF959690, 0xFF9C9D97, 0xFF8D8C88, 0xFF989793, 0xFFA8A7A3, 0xFFA4A39F, 0xFFA5A4A0, 0xFFAEADA9, 0xFFA9A8A4, 0xFFA6A5A1, 0xFF90918C,
    0xFFA5A6A1, 0xFFA5A6A1, 0xFFBBBBB9, 0xFFB7B7B5, 0xFFB6B6B6, 0xFFAFAFAF, 0xFFA7A7A7, 0xFFA1A29D, 0xFFAAABA6, 0xFFB2B3AE, 0xFFACADA8, 0xFFA8A9A4, 0xFFA9AAA5, 0xFFAFB0AB, 0xFFC1C2BD, 0x0FEDEDED, 0x00FDFDFD, 0x00FEFEFE, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FEFEFE, 0x00FCFEFD, 0x00FCFEFD, 0x00FDFFFE, 0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FCFEFD, 0x00FCFCFC, 0x00FEFEFE, 0x00FFFFFF, 0x00FEFFFF, 0x00FAFEFD, 0x00FBFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFEFE, 0x00FFFFFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFBFC, 0x00FFFBFC, 0x00FFFDFF, 0x00FFFCFE, 0x00FFFDFF, 0x00FFFDFF, 0x00FFFDFF, 0x00FFFDFF, 0x00FFFDFF,
    0x00FFFDFF, 0x00FFFDFF, 0x00FFFDFF, 0x00FFFDFE, 0x00FFFDFE, 0x00FFFDFE, 0x00FFFDFE, 0x00FFFDFE, 0x00FFFDFE, 0x00FFFDFE, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FEFCFD,
    0x00FEFCFD, 0x00FEFCFD, 0x00FEFCFD, 0x00FEFCFD, 0x00FEFCFD, 0x00FEFCFD, 0x00FEFCFD, 0x00FFFDFE, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFDFE, 0x00FEFCFD, 0x00FFFDFC, 0x00FFFDFC, 0x00FFFDFC, 0x00FFFEFD, 0x00FFFEFD,
    0x00FFFEFD, 0x00FFFEFD, 0x00FFFEFD, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FDFFFE, 0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FCFFFF,
    0x00FEFFFF, 0x00FBFDFC, 0x00FDFFFE, 0x00FDFFFE, 0x00FBFDFC, 0x00FEFFFF, 0x00FCFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FBFFFE,
    0x00F9FDFC, 0x00FBFFFE, 0x00FCFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FBFDFC, 0x00FCFEFD, 0x00FCFEFD, 0x00FCFEFD, 0x00FDFFFE, 0x00FDFFFE, 0x00FDFFFE, 0x00FEFFFF, 0x00FCFEFD,
    0x00FCFEFD, 0x00FCFEFD, 0x00FCFEFD, 0x00FCFEFD, 0x00FCFEFD, 0x00FCFEFD, 0x00FCFEFD, 0x00FBFFFE, 0x00FBFFFE, 0x00FBFFFE, 0x00FBFFFE, 0x00FBFFFE, 0x00FBFFFE, 0x00FBFFFE, 0x00FBFFFE, 0x00FCFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FCFFFF,
    0x00FCFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FBFFFE, 0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FCFFFF,
    0x00FCFFFF, 0x00FBFFFE, 0x00FBFFFE, 0x00FAFEFD, 0x00F9FDFC, 0x00F8FCFB, 0x00F7FBFA, 0x00FCFEFD, 0x00FEFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FBFFFF, 0x00F8FEFC, 0x0BEFF8F5, 0x91A9B2AF, 0xFFB9BAB5, 0xFFBBBCB7, 0xFFBCBDB8, 0xFFA8A9A4, 0xFF9A9B96,
    0xFFA1A29D, 0xFF9A9B96, 0xFF898A85, 0xFF989994, 0xFF91928D, 0xFF92938E, 0xFF9B9C97, 0xFF959691, 0xFF8D8E89, 0xFF959691, 0xFF92938E, 0xFF9B9C97, 0xFFACADA8, 0xFF9C9D98, 0xFF989994, 0xFF9B9C97, 0xFF8B8C87, 0xFF8F908B, 0xFF9E9F9A, 0xFF949590,
    0xFFA8A9A4, 0xFFA7A8A3, 0xFF8E8E8C, 0xFF9C9C9A, 0xFF9D9D9D, 0xFF838383, 0xFF969696, 0xFFA1A29D, 0xFFABACA7, 0xFFAFB0AB, 0xFFA1A29D, 0xFF9E9F9A, 0xFFA5A6A1, 0xFFA8A9A4, 0xFFB7B8B3, 0x0FEDF1F0, 0x00FBFFFE, 0x00FAFEFD, 0x00FAFEFD, 0x00FCFFFF,
    0x00FAFEFD, 0x00F9FDFC, 0x00F8FCFB, 0x00FDFFFE, 0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FEFFFF, 0x00FDFFFE, 0x00FCFEFD, 0x00FEFEFE, 0x00FFFFFF, 0x00FAFCFB, 0x00FBFFFE, 0x00FAFFFE, 0x00F6FFFC, 0x08F2FBF8, 0x08F2FDF9, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FCFCFC, 0x00FCFAFB, 0x00FFFEFF, 0x00FFFDFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF,
    0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFDFF, 0x00FFFDFF, 0x00FFFDFF, 0x00FFFDFF, 0x00FFFDFF, 0x00FFFCFF, 0x00FFFCFF, 0x00FFFCFF, 0x00FFFEFF, 0x00FFFDFE, 0x00FFFDFE, 0x00FFFDFE, 0x00FFFDFE, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFEFE, 0x00FFFBFC, 0x00FFFBFC, 0x00FFFBFC, 0x00FFFCFD, 0x00FFFDFE,
    0x00FFFDFE, 0x00FFFDFE, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFDFE, 0x00FFFDFE, 0x00FFFDFE, 0x00FFFDFE, 0x00FFFBFF, 0x00FEF9FD, 0x00FEF9FD, 0x00FFFCFF, 0x00FFFDFF, 0x00FEFCFF, 0x00FDFBFE, 0x00FEFCFF, 0x00FEFFFF,
    0x00FDFEFF, 0x00FFFDFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFDFF, 0x00FDFEFF, 0x00FEFFFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FEFFFF, 0x00FEFEFE, 0x00FCFCFC, 0x00FCFCFC, 0x00FCFCFC,
    0x00FCFCFC, 0x00FDFBFC, 0x00FDFBFC, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF,
    0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFEFE, 0x00FEFEFE, 0x00FEFEFE, 0x00FEFEFE,
    0x00FEFEFE, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFEFE, 0x00FEFEFE, 0x00FEFEFE, 0x00FEFEFE, 0x00FEFEFE, 0x00FEFEFE, 0x00FEFEFE, 0x00FEFEFE, 0x00FFFDFF, 0x00FFFDFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF,
    0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FCFCFC, 0x00FFFFFF, 0x00FEFFFF, 0x00FAFCFB, 0x00F7F9F8, 0x89AEB0AF, 0xFFABACA7, 0xFFBDBEB9, 0xFFB7B8B3, 0xFF9FA09B, 0xFF9E9F9A,
    0xFFA7A8A3, 0xFFA0A19C, 0xFF949590, 0xFF9D9F9A, 0xFF898B86, 0xFF848681, 0xFF8C8E89, 0xFF82847F, 0xFF81837E, 0xFF8F918C, 0xFF888A85, 0xFF999A95, 0xFF9C9D98, 0xFF858681, 0xFF8C8D88, 0xFF93948F, 0xFF7D7E79, 0xFF7D7E79, 0xFF878883, 0xFF848681,
    0xFF8D8F8A, 0xFFA3A5A0, 0xFF868885, 0xFF8F918E, 0xFF8D8F8E, 0xFF777978, 0xFF828483, 0xFF9C9E99, 0xFFA5A7A2, 0xFFA9ABA6, 0xFF999B96, 0xFF9EA09B, 0xFFACAEA9, 0xFFABADA8, 0xFFB5B7B2, 0x0FEDEDED, 0x00FEFEFE, 0x00FFFFFF, 0x00FEFEFE, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFDFE, 0x00FFFDFE, 0x00FFFDFE, 0x00FEF8FA, 0x00FFFEFF, 0x00FDFDFD, 0x00FEFFFF, 0x00FBFFFE, 0x00FCFFFF, 0x00FCFFFF, 0x00FEFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFCFF, 0x00FEFAFB, 0x00FEFFFF, 0x00F9FFFF, 0x00F7FFFE, 0x00F9FFFF, 0x00FBFFFF, 0x00F9FDFC, 0x00F8FEFC, 0x00F8FEFC, 0x00F8FEFC, 0x00F8FEFC, 0x00F8FEFC,
    0x00F8FEFC, 0x00F8FEFC, 0x00F8FEFC, 0x00FBFFFF, 0x00FBFFFF, 0x00FAFFFF, 0x00FAFFFF, 0x00FAFFFF, 0x00F9FFFF, 0x00F9FFFF, 0x00F9FFFF, 0x00FBFFFF, 0x00FBFFFF, 0x00FBFFFF, 0x00FBFFFF, 0x00FBFFFF, 0x00FBFFFF, 0x00FBFFFF, 0x00FBFFFF, 0x00F9FFFF,
    0x00F9FFFF, 0x00F9FFFF, 0x00F9FFFF, 0x00F9FFFF, 0x00F9FFFF, 0x00F9FFFF, 0x00F9FFFF, 0x00F9FFFF, 0x00F7FFFD, 0x00F5FEFB, 0x00F6FFFC, 0x00F8FFFE, 0x00F9FFFF, 0x00F9FFFF, 0x00F9FFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FCFFFF,
    0x00FCFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FBFFFF, 0x00FBFFFF, 0x00FBFFFF, 0x00FBFFFF, 0x00FBFFFF, 0x00FBFFFF, 0x00FBFFFF, 0x00FBFFFF, 0x00FFFDFF, 0x00FFFDFF, 0x00FFFDFF, 0x00FFFDFF, 0x00FFFEFF, 0x00FDFDFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FAFEFF,
    0x00FCFDFF, 0x00FFFDFF, 0x00FFFDFF, 0x00FFFDFF, 0x00FFFDFF, 0x00FCFDFF, 0x00FAFEFF, 0x00FEFEFF, 0x00FEFEFF, 0x00FEFEFF, 0x00FEFEFF, 0x00FEFEFF, 0x00FEFEFF, 0x00FEFEFF, 0x00FEFEFF, 0x00FDFFFE, 0x00FDFFFE, 0x00FDFFFE, 0x00FFFFFF, 0x00FFFEFF,
    0x00FFFEFF, 0x00FFFEFF, 0x00FFFBFC, 0x00FFFCFD, 0x00FFFCFD, 0x00FFFCFD, 0x00FFFCFD, 0x00FFFCFD, 0x00FFFCFD, 0x00FFFCFD, 0x00FFFCFD, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFDFE, 0x00FFFCFD, 0x00FFFDFE, 0x00FFFDFE, 0x00FFFDFE, 0x00FFFEFF,
    0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFDFE, 0x00FFFDFE, 0x00FFFDFE, 0x00FFFDFE, 0x00FFFDFE, 0x00FFFDFE, 0x00FFFDFE, 0x00FFFDFE, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF,
    0x00FFFDFE, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFDFE, 0x00FFFDFE, 0x00FFFDFE, 0x00FFFDFE, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFDFF, 0x00FFFDFF, 0x00FFFDFF, 0x00FFFCFF, 0x00FFFBFF, 0x00FFFBFF, 0x00FFFCFF, 0x00FFFCFF, 0x00FFFDFF,
    0x00FFFDFF, 0x00FFFDFF, 0x00FFFDFF, 0x00FFFCFE, 0x00FFFBFD, 0x00FFFBFD, 0x00FFFAFC, 0x00FFFEFF, 0x00FDFBFC, 0x00FFFBFC, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FCF8F9, 0xA0A5A1A2, 0xFFA5A6A1, 0xFFB8B9B4, 0xFFB2B3AE, 0xFFAAABA6, 0xFFB0B1AC,
    0xFFA8A9A4, 0xFFA8A9A4, 0xFFBDBEB9, 0xFF91938E, 0xFF82847F, 0xFF777974, 0xFF777974, 0xFF72746F, 0xFF777974, 0xFF848681, 0xFF7E807B, 0xFF91938E, 0xFF868883, 0xFF6C6E69, 0xFF70726D, 0xFF858782, 0xFF7D7F7A, 0xFF797B76, 0xFF8B8D88, 0xFF9B9D98,
    0xFF8A8C87, 0xFF959792, 0xFF848683, 0xFF8A8C89, 0xFF858786, 0xFF808281, 0xFF7A7C7B, 0xFF7B7D78, 0xFF8D8F8A, 0xFF9FA19C, 0xFF989A95, 0xFFA1A39E, 0xFFACAEA9, 0xFFA3A5A0, 0x89B0B2AD, 0x13F0ECED, 0x00FFFCFD, 0x00FFFEFF, 0x00FEFAFB, 0x00FEFAFB,
    0x00FFFDFE, 0x00FFFBFC, 0x00FFFCFD, 0x00FFFDFF, 0x00FFFDFF, 0x00FFFDFF, 0x00FFFDFF, 0x00FFFDFF, 0x00FFFDFF, 0x00FFFDFF, 0x00FFFDFF, 0x00FFFAFE, 0x00FFFDFF, 0x00FBF9FA, 0x00FEFFFF, 0x00F7F9F8, 0x00FEFCFD, 0x00FFFAFC, 0x00FFFBFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFBFF, 0x00FFFBFC, 0x00F9FFFF, 0x00D1E4DE, 0x00B0CBC2, 0x00B7D2C9, 0x00B1CBC2, 0x00B3CAC2, 0x00B2C9C1, 0x00B1C8C0, 0x00B0C7BF, 0x00AFC6BE, 0x00AFC6BE,
    0x00AFC6BE, 0x00B0C7BF, 0x00B0C7BF, 0x00B0C6C3, 0x00B0C6C3, 0x00B0C6C3, 0x00B0C6C3, 0x00B0C6C3, 0x00B0C6C3, 0x00B1C7C4, 0x00B1C7C4, 0x00C1D2CC, 0x00C1D2CC, 0x00C2D3CD, 0x00C2D3CD, 0x00C2D3CD, 0x00C1D2CC, 0x00C0D1CB, 0x00BFD0CA, 0x00C1D6CF,
    0x00C1D6CF, 0x00C1D6CF, 0x00C1D6CF, 0x00C1D6CF, 0x00C1D6CF, 0x00C1D6CF, 0x00C1D6CF, 0x00C5DAD3, 0x00C3D8D1, 0x00C1D6CF, 0x00C3D8D1, 0x00C7DCD5, 0x00CBE0D9, 0x00CCE1DA, 0x00CCE1DA, 0x00CFE2DE, 0x00CFE2DE, 0x00CFE2DE, 0x00CFE2DE, 0x00CFE2DE,
    0x00CFE2DE, 0x00CFE2DE, 0x00CFE2DE, 0x00CFE2DC, 0x00CFE2DC, 0x00CFE2DC, 0x00CFE2DC, 0x00CFE2DC, 0x00CFE2DC, 0x00CFE2DC, 0x00CFE2DC, 0x00DBE0E3, 0x00D8E0E2, 0x00DBE5E6, 0x00E2EEEE, 0x00E2F0F0, 0x00DFEFEE, 0x00DDF0EE, 0x00E1F4F2, 0x00E0F4F2,
    0x00E2F0F0, 0x00E6EEF0, 0x00E5E6EA, 0x00E5E6EA, 0x00E6EEF0, 0x00E2F0F0, 0x00E0F4F2, 0x00E2F2F1, 0x00E2F2F1, 0x00E2F2F1, 0x00E2F2F1, 0x00E2F2F1, 0x00E2F2F1, 0x00E2F2F1, 0x00E2F2F1, 0x00EBFCF6, 0x00EBFCF6, 0x00EAF9F4, 0x00EAF6F2, 0x00EDF8F4,
    0x00F0F9F6, 0x00F2F8F6, 0x00EFF5F3, 0x00F1FAF7, 0x00F1FAF7, 0x00F1FAF7, 0x00F1FAF7, 0x00F1FAF7, 0x00F1FAF7, 0x00F1FAF7, 0x00F1FAF7, 0x00F0F9F6, 0x00F0F9F6, 0x00F0F9F6, 0x00F1FAF7, 0x00F3FCF9, 0x00F5FEFB, 0x00F7FFFD, 0x00F9FFFF, 0x00F8FFFE,
    0x00F8FFFE, 0x00F8FFFE, 0x00F8FFFE, 0x00F8FFFE, 0x00F8FFFE, 0x00F8FFFE, 0x00F8FFFE, 0x00FBFFFF, 0x00FBFFFF, 0x00FBFFFF, 0x00FBFFFF, 0x00FBFFFF, 0x00FBFFFF, 0x00FBFFFF, 0x00FBFFFF, 0x00F6FCFA, 0x00F6FCFA, 0x00F6FCFA, 0x00F7FDFB, 0x00F8FEFC,
    0x00FAFFFE, 0x00FBFFFF, 0x00FBFFFF, 0x00FBFFFF, 0x00FBFFFF, 0x00FBFFFF, 0x00FBFFFF, 0x00FBFFFF, 0x00FBFFFF, 0x00FBFFFF, 0x00FBFFFF, 0x00F9FFFF, 0x00F9FFFF, 0x00F9FFFF, 0x00F9FFFF, 0x00F9FFFF, 0x00F9FFFF, 0x00F9FFFF, 0x00F9FFFF, 0x00FCFFFF,
    0x00FCFFFF, 0x00FCFFFF, 0x00FBFFFE, 0x00FBFFFE, 0x00FBFFFE, 0x00FCFFFF, 0x00FCFFFF, 0x00FBFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FCFEFD, 0x00FDFFFE, 0x00FFFFFF, 0x00F5F5F5, 0x91ABA9AA, 0xFFA3A49F, 0xFFAFB0AB, 0xFFA1A29D, 0xFF9C9D98, 0xFFA7A8A3,
    0xFFA1A29D, 0xFF9C9D98, 0xFFA6A7A2, 0xFF838884, 0xFF808581, 0xFF767B77, 0xFF747975, 0xFF737874, 0xFF767B77, 0xFF7D827E, 0xFF747975, 0xFF7B807A, 0xFF797E78, 0xFF666B65, 0xFF616660, 0xFF7A7F79, 0xFF797E78, 0xFF70756F, 0xFF898E88, 0xFFA6ABA5,
    0xFF8D928C, 0xFF7D827C, 0xFF747975, 0xFF808581, 0xFF7A7E7D, 0xFF7B7F7E, 0xFF767A79, 0xFF757A74, 0xFF7F847E, 0xFF90958F, 0xFF90958F, 0xFFA2A7A1, 0xFFACB1AB, 0xFF9CA19B, 0x91AAAFA9, 0x00F6FAF9, 0x00FBFFFE, 0x00FCFFFF, 0x00FAFEFD, 0x00F9FDFC,
    0x00FCFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FCFFFF, 0x00FBFFFE, 0x00FAFEFD, 0x00FAFEFD, 0x00FAFEFD, 0x00FAFEFD, 0x00FAFEFD, 0x00FEFFFF, 0x00F8FEFC, 0x00F5FFFC, 0x00F7FFFF, 0x00F6FFFC, 0x00FFFFFF, 0x00FFF9FC, 0x00FFFAFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFAFF, 0x00FEFCFD, 0x0FEDFCF7, 0xD983A398, 0xFF335D4F, 0xFF316050, 0xFF235242, 0xFF234F40, 0xFF1F493B, 0xFF1E483A, 0xFF1C4638, 0xFF1A4436, 0xFF194335,
    0xFF194335, 0xFF1A4436, 0xFF1B4537, 0xFF1A4239, 0xFF1A4239, 0xFF1C443B, 0xFF1D453C, 0xFF1F473E, 0xFF20483F, 0xFF214940, 0xFF224A41, 0xFF325046, 0xFF345248, 0xFF38564C, 0xFF3B594F, 0xFF3D5B51, 0xFF3E5C52, 0xFF3E5C52, 0xFF3E5C52, 0xFF38594E,
    0xFF38594E, 0xFF38594E, 0xFF38594E, 0xFF38594E, 0xFF38594E, 0xFF38594E, 0xFF38594E, 0xFF38594E, 0xFF36574C, 0xFF35564B, 0xFF37584D, 0xFF3A5B50, 0xFF3C5D52, 0xFF3B5C51, 0xFF395A4F, 0xFF375B51, 0xFF365A50, 0xFF365A50, 0xFF35594F, 0xFF35594F,
    0xFF34584E, 0xFF34584E, 0xFF34584E, 0xFF39594E, 0xFF39594E, 0xFF3B5B50, 0xFF3C5C51, 0xFF3E5E53, 0xFF3F5F54, 0xFF406055, 0xFF416156, 0xFF40615A, 0xFF355851, 0xFF32574F, 0xFF386057, 0xFF3E695F, 0xFF3A685D, 0xFF356559, 0xFF336559, 0xFF346257,
    0xFF3E665D, 0xFF4C6B65, 0xFF49625E, 0xFF49625E, 0xFF4C6B65, 0xFF3E665D, 0xFF346257, 0xFF36665A, 0xFF36665A, 0xFF36665A, 0xFF36665A, 0xFF36665A, 0xFF36665A, 0xFF36665A, 0xFF36665A, 0xFF3D695A, 0xFF456F61, 0xFF497264, 0xFF486E61, 0xFF48695E,
    0xFF4B6B60, 0xFF506E64, 0xFF537167, 0xFF49695E, 0xFF49695E, 0xFF49695E, 0xFF49695E, 0xFF49695E, 0xFF49695E, 0xFF49695E, 0xFF49695E, 0xFF49695E, 0xFF49695E, 0xFF49695E, 0xFF4B6B60, 0xFF4D6D62, 0xFF517166, 0xFF547469, 0xFF56766B, 0xFF537368,
    0xFF537368, 0xFF537368, 0xFF537368, 0xFF537368, 0xFF537368, 0xFF537368, 0xFF537368, 0xFF547268, 0xFF547268, 0xFF547268, 0xFF547268, 0xFF547268, 0xFF547268, 0xFF547268, 0xFF547268, 0xFF537167, 0xFF537167, 0xFF547268, 0xFF557369, 0xFF57756B,
    0xFF5A786E, 0xFF5D7B71, 0xFF5F7D73, 0xFF607E74, 0xFF5F7D73, 0xFF5F7D73, 0xFF5E7C72, 0xFF5E7C72, 0xFF5D7B71, 0xFF5C7A70, 0xFF5C7A70, 0xFF597872, 0xFF5A7973, 0xFF5B7A74, 0xFF5B7A74, 0xFF5A7973, 0xFF587771, 0xFF56756F, 0xFF55746E, 0xFF567067,
    0xFF567067, 0xFF567067, 0xFF587269, 0xFF5A746B, 0xFF5E786F, 0xFF627C73, 0xFF647E75, 0xFF668077, 0xFF69837A, 0xFF6E857D, 0xFF667B74, 0xFF6B7E78, 0xFF6B7C76, 0xFB71827C, 0xFF6E7D78, 0xFF989994, 0xFF999A95, 0xFF868782, 0xFF7C7D78, 0xFF81827D,
    0xFF888984, 0xFF868782, 0xFF73746F, 0xFF727773, 0xFF6E736F, 0xFF616662, 0xFF5D625E, 0xFF5D625E, 0xFF656A66, 0xFF737874, 0xFF717672, 0xFF636A63, 0xFF6A716A, 0xFF616861, 0xFF5C635C, 0xFF666D66, 0xFF6B726B, 0xFF6F766F, 0xFF798079, 0xFF727771,
    0xFF70756F, 0xFF696E68, 0xFF666B67, 0xFF656A66, 0xFF5C605F, 0xFF626665, 0xFF6C706F, 0xFF70756F, 0xFF6A6F69, 0xFF717670, 0xFF747973, 0xFF8D928C, 0xFF9BA09A, 0xFF8E938D, 0x98A7ACA6, 0xCE89A098, 0xEC799088, 0xE87C938B, 0xE180978F, 0xDD829991,
    0xCA8CA39B, 0xC28FA69E, 0xBE91A8A0, 0xC68EA9A0, 0xC28FAAA1, 0xBE92ADA4, 0xBA93AEA5, 0xBA94AFA6, 0xBA94AFA6, 0xBA93AEA5, 0xBE92ADA4, 0xB398B3AA, 0xB796B6AB, 0xB796BAAE, 0xB397BBAF, 0x89AEC9C0, 0x00F5FFFF, 0x00FFFFFF, 0x00FFFAFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFF8FD, 0x00FFFEFF, 0x08F2FFFF, 0xEC799F92, 0xFF225745, 0xFF2F6A56, 0xFF1E5945, 0xFF17503D, 0xFF1B523F, 0xFF19503D, 0xFF154C39, 0xFF134A37, 0xFF114835,
    0xFF124936, 0xFF144B38, 0xFF154C39, 0xFF1A4C40, 0xFF1B4D41, 0xFF1D4F43, 0xFF1F5145, 0xFF225448, 0xFF25574B, 0xFF27594D, 0xFF285A4E, 0xFF3A6053, 0xFF3E6457, 0xFF456B5E, 0xFF4B7164, 0xFF51776A, 0xFF557B6E, 0xFF567C6F, 0xFF577D70, 0xFF537D6F,
    0xFF537D6F, 0xFF537D6F, 0xFF537D6F, 0xFF537D6F, 0xFF537D6F, 0xFF537D6F, 0xFF537D6F, 0xFF507A6C, 0xFF4E786A, 0xFF4D7769, 0xFF4E786A, 0xFF4F796B, 0xFF4D7769, 0xFF487264, 0xFF446E60, 0xFF3B695C, 0xFF3B695C, 0xFF3A685B, 0xFF39675A, 0xFF386659,
    0xFF376558, 0xFF376558, 0xFF366457, 0xFF416A5C, 0xFF426B5D, 0xFF446D5F, 0xFF466F61, 0xFF497264, 0xFF4C7567, 0xFF4E7769, 0xFF4F786A, 0xFF437C6D, 0xFF2A6455, 0xFF135040, 0xFF11503F, 0xFF145745, 0xFF145946, 0xFF0F5844, 0xFF0E5743, 0xFF105542,
    0xFF286555, 0xFF487C6F, 0xFF517C72, 0xFF517C72, 0xFF487C6F, 0xFF286555, 0xFF105542, 0xFF125A46, 0xFF125A46, 0xFF125A46, 0xFF125A46, 0xFF125A46, 0xFF125A46, 0xFF125A46, 0xFF125A46, 0xFF165741, 0xFF2B6A55, 0xFF407E69, 0xFF47826E, 0xFF467D6A,
    0xFF457A68, 0xFF4C7C6C, 0xFF4F7F6F, 0xFF467B69, 0xFF467B69, 0xFF467B69, 0xFF467B69, 0xFF467B69, 0xFF467B69, 0xFF467B69, 0xFF467B69, 0xFF477C6A, 0xFF467B69, 0xFF447967, 0xFF437866, 0xFF427765, 0xFF437866, 0xFF447967, 0xFF447967, 0xFF427765,
    0xFF427765, 0xFF427765, 0xFF427765, 0xFF427765, 0xFF427765, 0xFF427765, 0xFF427765, 0xFF407362, 0xFF407362, 0xFF407362, 0xFF407362, 0xFF407362, 0xFF407362, 0xFF407362, 0xFF407362, 0xFF417463, 0xFF407362, 0xFF3E7160, 0xFF3C6F5E, 0xFF3B6E5D,
    0xFF3C6F5E, 0xFF3D705F, 0xFF3D705F, 0xFF3B6E5D, 0xFF3B6E5D, 0xFF396C5B, 0xFF386B5A, 0xFF366958, 0xFF356857, 0xFF336655, 0xFF336655, 0xFF306457, 0xFF316558, 0xFF306457, 0xFF2D6154, 0xFF275B4E, 0xFF205447, 0xFF184C3F, 0xFF14483B, 0xFF124131,
    0xFF103F2F, 0xFF0C3B2B, 0xFF093828, 0xFF073626, 0xFF063525, 0xFF073626, 0xFF083727, 0xFF093325, 0xFF093325, 0xFF0E3729, 0xFF0D3326, 0xFF15392D, 0xFF0C2D22, 0xFF345449, 0xFF819F95, 0xFFA7A8A3, 0xFF979893, 0xFF898A85, 0xFF82837E, 0xFF70716C,
    0xFF6D6E69, 0xFF787974, 0xFF696A65, 0xFF686D69, 0xFF686D69, 0xFF686D69, 0xFF6D726E, 0xFF686D69, 0xFF646965, 0xFF686D69, 0xFF606561, 0xFF535A53, 0xFF575E57, 0xFF5C635C, 0xFF5E655E, 0xFF4E554E, 0xFF535A53, 0xFF646B64, 0xFF4E554E, 0xFF5B605A,
    0xFF5A5F59, 0xFF5D625C, 0xFF666B67, 0xFF666B67, 0xFF666A69, 0xFF606463, 0xFF616564, 0xFF646963, 0xFF5F645E, 0xFF6B706A, 0xFF6E736D, 0xFF848983, 0xFF919690, 0xFF90958F, 0xFFBABFB9, 0xFF2D5648, 0xFF083123, 0xFF042D1F, 0xFF0A3325, 0xFF093224,
    0xFF0E3729, 0xFF0F382A, 0xFF113A2C, 0xFF0D3D2D, 0xFF124232, 0xFF194939, 0xFF215141, 0xFF275747, 0xFF295949, 0xFF2A5A4A, 0xFF2A5A4A, 0xFF275747, 0xFF2E6351, 0xFF2A614E, 0xFF1A4F3D, 0xFF4B7768, 0x00D8F3EA, 0x00F8FFFF, 0x00FCFCFC, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FBFFFF, 0x00FFFCFF, 0x00FFFFFA, 0xE47E9C90, 0xFF295C53, 0xFF2A5C59, 0xFF1C4F48, 0xFF13503E, 0xFF1E4B37, 0xFF1C4935, 0xFF194431, 0xFF17402E, 0xFF173E2C,
    0xFF193B2B, 0xFF193B2B, 0xFF1A3A2B, 0xFF18422A, 0xFF1A4730, 0xFF194A37, 0xFF184B3C, 0xFF1A4E41, 0xFF1F5347, 0xFF22564A, 0xFF24564A, 0xFF29654C, 0xFF3C6756, 0xFF4C655F, 0xFF556B68, 0xFF567671, 0xFF4D766E, 0xFF4A7269, 0xFF55766D, 0xFF55796B,
    0xFF55796B, 0xFF55796B, 0xFF547A6B, 0xFF557B6C, 0xFF537C6C, 0xFF527B6B, 0xFF527B6B, 0xFF4A7965, 0xFF4C7766, 0xFF4F7365, 0xFF517164, 0xFF507065, 0xFF4A6E62, 0xFF416B5F, 0xFF3A685B, 0xFF2D6558, 0xFF2B6356, 0xFF286053, 0xFF286053, 0xFF296154,
    0xFF2A6255, 0xFF296154, 0xFF286053, 0xFF296657, 0xFF2E6758, 0xFF35675B, 0xFF3F6A60, 0xFF486E63, 0xFF4D7167, 0xFF527368, 0xFF537469, 0xFF5D7D70, 0xFF33594A, 0xFF204C3B, 0xFF1F523F, 0xFF265B47, 0xFF255643, 0xFF396453, 0xFF3E6757, 0xFF154C37,
    0xFF2E5F4C, 0xFF568170, 0xFF5E8274, 0xFF577B6D, 0xFF5A8071, 0xFF2D5948, 0xFF1E4D3B, 0xFF275C4A, 0xFF215644, 0xFF275C4A, 0xFF346957, 0xFF2A5F4D, 0xFF235846, 0xFF2F6452, 0xFF306553, 0xFF144F3B, 0xFF386D5B, 0xFF5A8677, 0xFF597F72, 0xFF587C70,
    0xFF5D8175, 0xFF537D6F, 0xFF578374, 0xFF5E8276, 0xFF597D71, 0xFF597F72, 0xFF517A6C, 0xFF568273, 0xFF4F7E6E, 0xFF528272, 0xFF4F7F6F, 0xFF558172, 0xFF568273, 0xFF558172, 0xFF527E6F, 0xFF537F70, 0xFF578374, 0xFF598576, 0xFF578374, 0xFF588274,
    0xFF578173, 0xFF557F71, 0xFF547E70, 0xFF547E70, 0xFF557F71, 0xFF568072, 0xFF578173, 0xFF4F7B6C, 0xFF518070, 0xFF538272, 0xFF518171, 0xFF4F8271, 0xFF508573, 0xFF4E8371, 0xFF4A7F6D, 0xFF567F6F, 0xFF578070, 0xFF598272, 0xFF5A8373, 0xFF588171,
    0xFF567F6F, 0xFF557E6E, 0xFF557E6E, 0xFF537C6E, 0xFF547D6F, 0xFF557E70, 0xFF547D6F, 0xFF50796B, 0xFF4E7769, 0xFF4D7668, 0xFF4D7668, 0xFF4A7466, 0xFF4A7466, 0xFF467062, 0xFF3F685A, 0xFF446D5F, 0xFF40695B, 0xFF2A5043, 0xFF22483B, 0xFF1B4136,
    0xFF1F4339, 0xFF1B392F, 0xFF284239, 0xFF253C32, 0xFF163025, 0xFF223E32, 0xFF224132, 0xFF1C4032, 0xFF1C3E30, 0xFF203E32, 0xFF284237, 0xFF2B4037, 0xFF3D4E46, 0xFF67766F, 0xFFACB9B2, 0xFFB8B5AE, 0xFF9E9B94, 0xFF87877F, 0xFF6E6E66, 0xFF5F6058,
    0xFF63645C, 0xFF60635A, 0xFF62655C, 0xFF5E655E, 0xFF596059, 0xFF5C635C, 0xFF60655F, 0xFF5E635D, 0xFF636560, 0xFF646661, 0xFF5E605B, 0xFF5C625E, 0xFF5C625E, 0xFF5D635F, 0xFF595F5B, 0xFF616763, 0xFF585E5A, 0xFF5A605C, 0xFF5E6460, 0xFF5D6661,
    0xFF5E6762, 0xFF616A67, 0xFF5A6463, 0xFF5F696A, 0xFF636E70, 0xFF5A6569, 0xFF5E6C6F, 0xFF5E6462, 0xFF626866, 0xFF676B6A, 0xFF707271, 0xFF7B797A, 0xFF898586, 0xFFABA5A7, 0xFFD4CBCE, 0xFF6E8478, 0xFF1C3427, 0xFF122C1F, 0xFF1C3B2C, 0xFF0C2E1E,
    0xFF0C3321, 0xFF18412F, 0xFF0F3A27, 0xFF1D3D2E, 0xFF224233, 0xFF375748, 0xFF4E6E5F, 0xFF587869, 0xFF567667, 0xFF547465, 0xFF587869, 0xFF54756A, 0xFF51776A, 0xFF517B6D, 0xFF447061, 0xFF496D61, 0x00E6F9F3, 0x00FEFFFF, 0x00FFFCFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F9FBFF, 0x00FFFAFF, 0x00FFFBF9, 0xD585968C, 0xFF2F544C, 0xFF315352, 0xFF22453E, 0xFF15402D, 0xFF1C3D1E, 0xFF1B3C1D, 0xFF1B3A1B, 0xFF1B381A, 0xFF1C3619,
    0xFF1C3619, 0xFF1D3619, 0xFF1E371A, 0xFF16311E, 0xFF1C3927, 0xFF1D3D2E, 0xFF1C4034, 0xFF1D453A, 0xFF204A40, 0xFF234E44, 0xFF285349, 0xFF2E644C, 0xFF3B6551, 0xFF4B6558, 0xFF536D62, 0xFF537567, 0xFF4E7563, 0xFF4E7362, 0xFF597566, 0xFF537769,
    0xFF537769, 0xFF527869, 0xFF527869, 0xFF527869, 0xFF507969, 0xFF4F7868, 0xFF4F7868, 0xFF497564, 0xFF4A7363, 0xFF4C7062, 0xFF4D6E63, 0xFF496D61, 0xFF416B5F, 0xFF376759, 0xFF306555, 0xFF266256, 0xFF235F53, 0xFF205C50, 0xFF1F5B4F, 0xFF205C50,
    0xFF205C50, 0xFF1F5B4F, 0xFF1E5A4E, 0xFF246152, 0xFF276153, 0xFF2E6255, 0xFF356559, 0xFF3F695D, 0xFF456D62, 0xFF4A7065, 0xFF4D7165, 0xFF4E7264, 0xFF2D5646, 0xFF1C4837, 0xFF306350, 0xFF376A57, 0xFF1F503D, 0xFF335F4E, 0xFF2F5848, 0xFF174C38,
    0xFF30614E, 0xFF547F6E, 0xFF587C6E, 0xFF537769, 0xFF587E6F, 0xFF2D5948, 0xFF1E4D3B, 0xFF346353, 0xFF396858, 0xFF3B6A5A, 0xFF396858, 0xFF316050, 0xFF366555, 0xFF3D6C5C, 0xFF2B5A4A, 0xFF144B38, 0xFF366958, 0xFF588475, 0xFF588173, 0xFF577D70,
    0xFF598274, 0xFF517D6E, 0xFF528272, 0xFF557E70, 0xFF547D6F, 0xFF598375, 0xFF568072, 0xFF5A8677, 0xFF548071, 0xFF568575, 0xFF568575, 0xFF537F70, 0xFF548071, 0xFF537F70, 0xFF507C6D, 0xFF517D6E, 0xFF548071, 0xFF548071, 0xFF517D6E, 0xFF527C6E,
    0xFF537D6F, 0xFF547E70, 0xFF557F71, 0xFF568072, 0xFF568072, 0xFF557F71, 0xFF547E70, 0xFF598274, 0xFF598375, 0xFF578173, 0xFF547E70, 0xFF547E70, 0xFF568072, 0xFF568072, 0xFF547E70, 0xFF547D6D, 0xFF557E6E, 0xFF557E6E, 0xFF547D6D, 0xFF527B6B,
    0xFF517A6A, 0xFF517A6A, 0xFF507969, 0xFF537C6E, 0xFF537C6E, 0xFF527B6D, 0xFF50796B, 0xFF4E7769, 0xFF4D7668, 0xFF4E7769, 0xFF4F786A, 0xFF497365, 0xFF497365, 0xFF487264, 0xFF426B5D, 0xFF3F685A, 0xFF315A4C, 0xFF23493C, 0xFF2C5245, 0xFF627D76,
    0xFF7B928C, 0xFF839692, 0xFF929E9A, 0xFF919C98, 0xFF84918A, 0xFF7F8E87, 0xFF6B7C74, 0xFF83978E, 0xFF8EA299, 0xFF7F8E87, 0xFF69746E, 0xFF777D79, 0xFF767B77, 0xFF80807E, 0xFFACACAA, 0xFFB9BAB5, 0xFFACADA8, 0xFFAAACA7, 0xFFA4A6A1, 0xFF9DA29C,
    0xFF9EA39D, 0xFF979C96, 0xFF959A94, 0xFF929C94, 0xFF8D948D, 0xFF8D948D, 0xFF8D948D, 0xFF898E88, 0xFF878C86, 0xFF888A85, 0xFF838580, 0xFF888983, 0xFF83847E, 0xFF878882, 0xFF858680, 0xFF8A8B85, 0xFF878882, 0xFF8F908A, 0xFF92938D, 0xFF8C8C80,
    0xFF8C8C80, 0xFF909086, 0xFF8D8D83, 0xFF8D8D85, 0xFF888880, 0xFF7E7D78, 0xFF868580, 0xFF858B89, 0xFF868C8A, 0xFF808483, 0xFF828685, 0xFF999B9A, 0xFFACAEAD, 0xFFB2B2B2, 0xFFB1B1B1, 0xFF96A098, 0xFF808B83, 0xFF6B786F, 0xFF55655B, 0xFF66776D,
    0xFF5C7065, 0xFF576B60, 0xFF647A6E, 0xFF6D7E74, 0xFF5F7066, 0xFF76877D, 0xFF8A9B91, 0xFF7F9086, 0xFF83948A, 0xFF8FA096, 0xFF84958B, 0xFF608176, 0xFF53796C, 0xFF4E786A, 0xFF487465, 0xFF52766A, 0x00EAFDF7, 0x00FEFFFF, 0x00FFF8FB, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x0FEEFFFF, 0x00FCFFFF, 0x08FDFFF2, 0xE17F9980, 0xFF244C34, 0xFF224531, 0xFF1E4028, 0xFF163F1D, 0xFF16391B, 0xFF16391B, 0xFF15381A, 0xFF16371A, 0xFF173519,
    0xFF173519, 0xFF183519, 0xFF183519, 0xFF133014, 0xFF18361A, 0xFF15371C, 0xFF11381D, 0xFF123E25, 0xFF13452C, 0xFF164C34, 0xFF1C563E, 0xFF25553D, 0xFF315843, 0xFF436451, 0xFF4F705B, 0xFF4D735C, 0xFF4B735B, 0xFF4F725A, 0xFF54715B, 0xFF4E7264,
    0xFF4D7364, 0xFF4E7465, 0xFF4E7465, 0xFF4C7565, 0xFF4B7464, 0xFF4A7564, 0xFF4A7564, 0xFF487161, 0xFF487161, 0xFF486E61, 0xFF446D5F, 0xFF3E6A5B, 0xFF336657, 0xFF286150, 0xFF215E4C, 0xFF1B5A4F, 0xFF1A594E, 0xFF18574C, 0xFF18574C, 0xFF19584D,
    0xFF1B5A4F, 0xFF1B5A4F, 0xFF1B5A4F, 0xFF1C5A4B, 0xFF1E5B4C, 0xFF235D4F, 0xFF295F51, 0xFF306256, 0xFF39675A, 0xFF416B5F, 0xFF456F63, 0xFF4C7263, 0xFF2C5746, 0xFF11402E, 0xFF336451, 0xFF3A6B58, 0xFF154432, 0xFF315C4B, 0xFF2C5545, 0xFF11402E,
    0xFF305C4B, 0xFF537C6C, 0xFF567C6D, 0xFF557B6C, 0xFF547D6D, 0xFF295443, 0xFF134230, 0xFF426C5E, 0xFF3A6456, 0xFF305A4C, 0xFF2D5749, 0xFF275143, 0xFF295345, 0xFF2F594B, 0xFF234D3F, 0xFF144736, 0xFF376656, 0xFF568273, 0xFF568072, 0xFF537D6F,
    0xFF548373, 0xFF4F8271, 0xFF4F8472, 0xFF518070, 0xFF507F6F, 0xFF558474, 0xFF568273, 0xFF578374, 0xFF507C6D, 0xFF537F70, 0xFF558172, 0xFF548071, 0xFF548071, 0xFF537F70, 0xFF517D6E, 0xFF527E6F, 0xFF548071, 0xFF537F70, 0xFF517D6E, 0xFF557F71,
    0xFF568072, 0xFF578173, 0xFF578173, 0xFF568072, 0xFF557F71, 0xFF547E70, 0xFF547E70, 0xFF567F71, 0xFF567F71, 0xFF567C6F, 0xFF557B6E, 0xFF577B6F, 0xFF5D7E73, 0xFF5D7E73, 0xFF5B7B70, 0xFF578070, 0xFF567F6F, 0xFF547D6D, 0xFF537C6C, 0xFF527B6B,
    0xFF517A6A, 0xFF517A6A, 0xFF517A6A, 0xFF527B6D, 0xFF517A6C, 0xFF4F786A, 0xFF4F786A, 0xFF4F786A, 0xFF4F786A, 0xFF4E7769, 0xFF4E7769, 0xFF497365, 0xFF477163, 0xFF477163, 0xFF466F61, 0xFF3F685A, 0xFF275042, 0xFF1A4033, 0xFF2F5548, 0xFF495855,
    0xFF596563, 0xFF5A6060, 0xFF676968, 0xFF757575, 0xFF757575, 0xFF696B68, 0xFF4A4F4B, 0xFF6B706C, 0xFF8F918E, 0xFFB5B5B3, 0xFFAAA6A5, 0xFFB0AAAA, 0xFFB3A9AA, 0xFFBBAFB1, 0xFFB9ADAF, 0xFF7C8280, 0xFF787E7C, 0xFF868C8A, 0xFF8F9895, 0xFF929B98,
    0xFF929D99, 0xFF8E9995, 0xFF8C9793, 0xFF7E8782, 0xFF79827D, 0xFF7A837E, 0xFF7F8581, 0xFF7D837F, 0xFF7C817D, 0xFF7D827E, 0xFF7D827E, 0xFF878880, 0xFF808179, 0xFF86877F, 0xFF86877F, 0xFF86877F, 0xFF85867E, 0xFF8F9088, 0xFF8F9088, 0xFF91948B,
    0xFF8E8F87, 0xFF8E8F87, 0xFF8D8E86, 0xFF8D8D85, 0xFF85857D, 0xFF7C7C74, 0xFF84817A, 0xFF9DA1A0, 0xFFABB1AF, 0xFFAFB5B3, 0xFFA6AFAC, 0xFFA3ACA9, 0xFF9CA7A3, 0xFF8A9591, 0xFF78837F, 0xFF908F8D, 0xFFB3B2B0, 0xFFBDBCBA, 0xFF8F8E8C, 0xFF9F9B9A,
    0xFF9A9695, 0xFFA29E9D, 0xFFABA7A6, 0xFF585A57, 0xFF4D4F4C, 0xFF696B68, 0xFF838582, 0xFF7A7C79, 0xFF858784, 0xFF999B98, 0xFF8B8D8A, 0xFF5F8075, 0xFF52786B, 0xFF4D7769, 0xFF4C7869, 0xFF55796D, 0x00E7FAF4, 0x00FDFFFE, 0x00FFF9FC, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x0FEEFEF4, 0x35F0EADA, 0x5FF1E4C4, 0xFF92986C, 0xFF4E5B30, 0xFF494D28, 0xFF4A4B21, 0xFF464E1B, 0xFF474D29, 0xFF484E2A, 0xFF474D29, 0xFF474D29, 0xFF464C28,
    0xFF444A26, 0xFF444825, 0xFF434724, 0xFF42431B, 0xFF43451D, 0xFF3C4118, 0xFF343F14, 0xFF314319, 0xFF29441B, 0xFF1B3E16, 0xFF163C15, 0xFF234E3B, 0xFF254F3B, 0xFF335A45, 0xFF3A644C, 0xFF356146, 0xFF356148, 0xFF3C6650, 0xFF3F6651, 0xFF466C5D,
    0xFF486E5F, 0xFF4A7061, 0xFF487161, 0xFF487161, 0xFF477261, 0xFF477261, 0xFF477261, 0xFF496F60, 0xFF466F61, 0xFF426C5E, 0xFF3C6B5B, 0xFF326757, 0xFF276250, 0xFF1C5C4B, 0xFF165947, 0xFF19584D, 0xFF18574C, 0xFF17564B, 0xFF16554A, 0xFF17564B,
    0xFF18574C, 0xFF19584D, 0xFF1A594E, 0xFF185649, 0xFF195748, 0xFF1B594A, 0xFF1F5C4D, 0xFF255F50, 0xFF2F6356, 0xFF39695B, 0xFF416D60, 0xFF4B7663, 0xFF285340, 0xFF0E3B27, 0xFF295642, 0xFF305D49, 0xFF17422F, 0xFF37604E, 0xFF396250, 0xFF174231,
    0xFF355E4E, 0xFF557E6E, 0xFF557E6E, 0xFF578070, 0xFF55806F, 0xFF2D5847, 0xFF154130, 0xFF335F4E, 0xFF2B5746, 0xFF2B5746, 0xFF396554, 0xFF3B6756, 0xFF386453, 0xFF3D6958, 0xFF396554, 0xFF184433, 0xFF396554, 0xFF54806F, 0xFF558170, 0xFF4F7E6C,
    0xFF528370, 0xFF528572, 0xFF508571, 0xFF548572, 0xFF528370, 0xFF538270, 0xFF52816F, 0xFF537F6E, 0xFF517C6B, 0xFF527D6C, 0xFF567F6F, 0xFF568273, 0xFF558172, 0xFF548071, 0xFF537F70, 0xFF558172, 0xFF578374, 0xFF578374, 0xFF568273, 0xFF547F6E,
    0xFF547F6E, 0xFF537E6D, 0xFF527D6C, 0xFF517C6B, 0xFF527D6C, 0xFF547F6E, 0xFF55806F, 0xFF507F6D, 0xFF527E6D, 0xFF537F6E, 0xFF567F6F, 0xFF5B8172, 0xFF5D8173, 0xFF5D7F71, 0xFF5A7C6E, 0xFF578070, 0xFF567F6F, 0xFF557E6E, 0xFF557E6E, 0xFF557E6E,
    0xFF557E6E, 0xFF547D6D, 0xFF537C6C, 0xFF527B6D, 0xFF517A6C, 0xFF517A6C, 0xFF517A6C, 0xFF527B6D, 0xFF517A6C, 0xFF4E7769, 0xFF4B7466, 0xFF4B7567, 0xFF456F61, 0xFF446E60, 0xFF487163, 0xFF466F61, 0xFF2A5345, 0xFF163C2F, 0xFF284E41, 0xFF364444,
    0xFF475353, 0xFF4C5252, 0xFF535456, 0xFF575757, 0xFF555756, 0xFF585C5B, 0xFF565B57, 0xFF444444, 0xFF595758, 0xFFCAC8C9, 0xFFF4EEF0, 0xFFF1E8EB, 0xFFFDF2F6, 0xFFFFF7FB, 0xFFAFA3A7, 0xFF374143, 0xFF2F3A3C, 0xFF333E40, 0xFF384345, 0xFF334142,
    0xFF2E3C3D, 0xFF2A3A3A, 0xFF293939, 0xFF4B5652, 0xFF47524E, 0xFF48534F, 0xFF4C5552, 0xFF49524F, 0xFF474D4B, 0xFF464C4A, 0xFF494F4D, 0xFF4A504E, 0xFF444A48, 0xFF494F4D, 0xFF4B514F, 0xFF464C4A, 0xFF434947, 0xFF484E4C, 0xFF464C4A, 0xFF425050,
    0xFF3F4B4B, 0xFF3E4A4A, 0xFF404C4C, 0xFF465051, 0xFF475152, 0xFF454F50, 0xFF495153, 0xFF4B4F50, 0xFF3D4343, 0xFF2D3635, 0xFF2B3534, 0xFF2D3C39, 0xFF2E3E3B, 0xFF273A36, 0xFF233833, 0xFF3B393A, 0xFF6C6A6B, 0xFFD0CCCD, 0xFFDBD5D7, 0xFFEAE1E4,
    0xFFEADFE3, 0xFFD8CCD0, 0xFF766A6E, 0xFF454545, 0xFF4A4A4A, 0xFF4F4F4F, 0xFF535353, 0xFF4D4D4D, 0xFF474747, 0xFF474747, 0xFF414141, 0xFF4D6E63, 0xFF4D7366, 0xFF4F796B, 0xFF4D796A, 0xFF4E7266, 0x00DFF2EC, 0x00FDFFFE, 0x00FFFCFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x7EE4C5B3, 0xFFD49C81, 0xFFE4A176, 0xFFD39C64, 0xFFCE9B64, 0xFFDB9E6F, 0xFFE2A06E, 0xFFDBA066, 0xFFD49C5F, 0xFFD49C5F, 0xFFD49E60, 0xFFD49E60, 0xFFD49E60,
    0xFFD29C5E, 0xFFD19B5D, 0xFFD09A5C, 0xFFD79A6D, 0xFFD6996A, 0xFFD49866, 0xFFCD9660, 0xFFC49561, 0xFFAF8958, 0xFF876B3C, 0xFF634E21, 0xFF204031, 0xFF193B2A, 0xFF1A4029, 0xFF1D432A, 0xFF194127, 0xFF1F4B34, 0xFF2C5D4A, 0xFF316757, 0xFF406657,
    0xFF43695A, 0xFF446D5D, 0xFF466F5F, 0xFF45705F, 0xFF45705F, 0xFF457160, 0xFF467261, 0xFF496D61, 0xFF446D5F, 0xFF3D6C5C, 0xFF346959, 0xFF296452, 0xFF1F5E4D, 0xFF175746, 0xFF125543, 0xFF19574A, 0xFF185649, 0xFF175548, 0xFF155346, 0xFF145245,
    0xFF145245, 0xFF155346, 0xFF165447, 0xFF195347, 0xFF195549, 0xFF19594B, 0xFF1B5B4B, 0xFF1F5D4E, 0xFF296253, 0xFF35675B, 0xFF3D6B60, 0xFF47725F, 0xFF234C3A, 0xFF153C2A, 0xFF193E2D, 0xFF1E4030, 0xFF143626, 0xFF234535, 0xFF264838, 0xFF183A2C,
    0xFF315547, 0xFF557B6C, 0xFF578070, 0xFF598473, 0xFF537E6D, 0xFF2D5847, 0xFF0E3928, 0xFF144331, 0xFF174634, 0xFF174634, 0xFF1C4B39, 0xFF194836, 0xFF174634, 0xFF1B4A38, 0xFF154432, 0xFF163F2F, 0xFF366150, 0xFF517D6C, 0xFF568271, 0xFF517D6C,
    0xFF537F6E, 0xFF568271, 0xFF527E6D, 0xFF588372, 0xFF568170, 0xFF547F6E, 0xFF55806F, 0xFF55806F, 0xFF588171, 0xFF567F6F, 0xFF557E6E, 0xFF558172, 0xFF537F70, 0xFF517D6E, 0xFF507C6D, 0xFF507C6D, 0xFF507C6D, 0xFF527E6F, 0xFF548071, 0xFF527D6C,
    0xFF547F6E, 0xFF568170, 0xFF568170, 0xFF568170, 0xFF55806F, 0xFF578271, 0xFF588372, 0xFF4D806D, 0xFF4B7E6B, 0xFF4D7E6B, 0xFF507F6D, 0xFF52816F, 0xFF54806F, 0xFF54806F, 0xFF547F6E, 0xFF537C6C, 0xFF547D6D, 0xFF557E6E, 0xFF578070, 0xFF578070,
    0xFF578070, 0xFF567F6F, 0xFF567F6F, 0xFF557E70, 0xFF537C6E, 0xFF527B6D, 0xFF527B6D, 0xFF527B6D, 0xFF517A6C, 0xFF4F786A, 0xFF4D7668, 0xFF4D7769, 0xFF497365, 0xFF456F61, 0xFF477062, 0xFF487163, 0xFF2E5749, 0xFF163C2F, 0xFF244A3D, 0xFF2E4743,
    0xFF465A58, 0xFF505E5E, 0xFF525C5B, 0xFF535C5B, 0xFF505B57, 0xFF535F5B, 0xFF54635E, 0xFF616765, 0xFF606664, 0xFFD2D8D6, 0xFFFCFFFF, 0xFFEEF0EF, 0xFFFAFCFB, 0xFFFFFFFF, 0xFFA6A6A6, 0xFF3D4B4C, 0xFF364445, 0xFF354344, 0xFF374747, 0xFF334343,
    0xFF2E4040, 0xFF314343, 0xFF2F4141, 0xFF525E5A, 0xFF535F5B, 0xFF55615D, 0xFF58635F, 0xFF58635F, 0xFF545D5A, 0xFF545D5A, 0xFF58615E, 0xFF556364, 0xFF536162, 0xFF515F60, 0xFF546263, 0xFF536162, 0xFF515F60, 0xFF505E5F, 0xFF526061, 0xFF525751,
    0xFF545B54, 0xFF575D59, 0xFF5A605E, 0xFF57605F, 0xFF586160, 0xFF5C6667, 0xFF5D6768, 0xFF5D6363, 0xFF3F4847, 0xFF293332, 0xFF283432, 0xFF2D3D3A, 0xFF2C3F3B, 0xFF293E39, 0xFF273E38, 0xFF444D4A, 0xFF767C7A, 0xFFF4FAF8, 0xFFFCFFFF, 0xFFF9FBFA,
    0xFFFFFFFF, 0xFFFFFEFF, 0xFF898788, 0xFF4C5552, 0xFF5C6562, 0xFF535C59, 0xFF4D5653, 0xFF4F5855, 0xFF49524F, 0xFF48514E, 0xFF49524F, 0xFF416257, 0xFF4E7467, 0xFF537D6F, 0xFF4D796A, 0xFF496D61, 0x00DAEDE7, 0x00FEFFFF, 0x00FFFCFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x89FBD0AE, 0xFFDC976D, 0xFFE99559, 0xFFEBA15A, 0xFFEEA862, 0xFFF3A165, 0xFFF6A063, 0xFFEA9D59, 0xFFE79758, 0xFFE89859, 0xFFE89A5A, 0xFFEA9C5C, 0xFFE99E5D,
    0xFFE99E5D, 0xFFE89E5D, 0xFFE89E5D, 0xFFE2975E, 0xFFE19559, 0xFFE79959, 0xFFEB9D5B, 0xFFE8A15F, 0xFFDEA063, 0xFFB38047, 0xFF7D4F1B, 0xFF27301B, 0xFF202C14, 0xFF1E2E11, 0xFF1F3010, 0xFF1E3115, 0xFF1D3A24, 0xFF1F4E3C, 0xFF1F5E4D, 0xFF3C6555,
    0xFF406959, 0xFF446D5D, 0xFF45705F, 0xFF446F5E, 0xFF436F5E, 0xFF44705F, 0xFF457160, 0xFF476D60, 0xFF426C60, 0xFF3A6A5C, 0xFF306656, 0xFF255F50, 0xFF1C5949, 0xFF175445, 0xFF175143, 0xFF184C3F, 0xFF184C3F, 0xFF184C3F, 0xFF174B3E, 0xFF174B3E,
    0xFF184C3F, 0xFF1A4E41, 0xFF1B4F42, 0xFF1C4F48, 0xFF1A5448, 0xFF19574A, 0xFF185A4C, 0xFF1C5C4C, 0xFF266052, 0xFF326458, 0xFF3C675D, 0xFF456E5C, 0xFF264B3A, 0xFF254536, 0xFF183426, 0xFF1B3326, 0xFF1D372A, 0xFF1D392B, 0xFF1C382A, 0xFF28463A,
    0xFF345447, 0xFF527869, 0xFF547F6E, 0xFF537F6E, 0xFF4F7B6A, 0xFF386352, 0xFF194232, 0xFF1B4432, 0xFF18412F, 0xFF153E2C, 0xFF1D4634, 0xFF1A4331, 0xFF113A28, 0xFF18412F, 0xFF1E4735, 0xFF234C3A, 0xFF426B59, 0xFF588370, 0xFF588571, 0xFF4F7A67,
    0xFF517665, 0xFF59796A, 0xFF547062, 0xFF567667, 0xFF5B7B6C, 0xFF587A6A, 0xFF567B6A, 0xFF547B69, 0xFF5A8371, 0xFF567F6D, 0xFF507B68, 0xFF507C6D, 0xFF4E7A6B, 0xFF4C7869, 0xFF487465, 0xFF416D5E, 0xFF3C6859, 0xFF3D695A, 0xFF406C5D, 0xFF426D5A,
    0xFF47725F, 0xFF4D7865, 0xFF4E7966, 0xFF4A7562, 0xFF436E5B, 0xFF3D6855, 0xFF3A6552, 0xFF396451, 0xFF37624F, 0xFF34614D, 0xFF36634F, 0xFF386753, 0xFF3C6B57, 0xFF44735F, 0xFF497A65, 0xFF4A7363, 0xFF4D7666, 0xFF517A6A, 0xFF527B6B, 0xFF527B6B,
    0xFF517A6A, 0xFF517A6A, 0xFF527B6B, 0xFF578072, 0xFF557E70, 0xFF527B6D, 0xFF50796B, 0xFF50796B, 0xFF517A6C, 0xFF527B6D, 0xFF527B6D, 0xFF4E786A, 0xFF4F796B, 0xFF497365, 0xFF456E60, 0xFF456E60, 0xFF2C5547, 0xFF183E31, 0xFF2A5043, 0xFF324F4B,
    0xFF455F5C, 0xFF445856, 0xFF3C4C4B, 0xFF455451, 0xFF4F5E5B, 0xFF4C5C59, 0xFF445751, 0xFF505F5C, 0xFF4F5E5B, 0xFF889492, 0xFF929E9C, 0xFF8A9694, 0xFF909A99, 0xFF9CA6A5, 0xFF798382, 0xFF566465, 0xFF546263, 0xFF516161, 0xFF536363, 0xFF4F5F5F,
    0xFF485A5A, 0xFF475959, 0xFF3D4F4F, 0xFF344340, 0xFF3D4C49, 0xFF45514F, 0xFF495553, 0xFF4D5957, 0xFF4F5958, 0xFF505A59, 0xFF555F5E, 0xFF4F595A, 0xFF545E5F, 0xFF495354, 0xFF4C5657, 0xFF566061, 0xFF566061, 0xFF4E5859, 0xFF596364, 0xFF87765C,
    0xFF8E7C64, 0xFF90816C, 0xFF897E6C, 0xFF71695C, 0xFF5C584D, 0xFF595951, 0xFF595853, 0xFF495354, 0xFF4B5556, 0xFF515D5D, 0xFF556161, 0xFF515F5F, 0xFF515F5F, 0xFF516160, 0xFF4E5E5D, 0xFF566562, 0xFF6A7976, 0xFFA2B1AE, 0xFFA1B0AD, 0xFFA3B2AF,
    0xFFA9B8B5, 0xFFA5B4B1, 0xFF4C5856, 0xFF445451, 0xFF566663, 0xFF536360, 0xFF4F5F5C, 0xFF4C5C59, 0xFF485855, 0xFF4C5C59, 0xFF41514E, 0xFF45665B, 0xFF53796C, 0xFF557F71, 0xFF4E7A6B, 0xFF4B6F63, 0x00DCEFE9, 0x00FEFFFF, 0x00FFFBFE, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x9CEAD2A4, 0xFFD5A06A, 0xFFE29C56, 0xFFE3A552, 0xFFE0A555, 0xFFE5A05B, 0xFFF0A969, 0xFFE4A560, 0xFFE19861, 0xFFE19A62, 0xFFE29B63, 0xFFE39E65, 0xFFE2A066,
    0xFFE2A167, 0xFFE1A368, 0xFFE1A368, 0xFFDCA765, 0xFFD89D59, 0xFFDF9F57, 0xFFE09E52, 0xFFDA9C51, 0xFFDAA360, 0xFFB4884B, 0xFF714C15, 0xFF634B27, 0xFF614E26, 0xFF5F4E22, 0xFF604F24, 0xFF5C4E2B, 0xFF4C4F32, 0xFF35573F, 0xFF2A644C, 0xFF3D6656,
    0xFF416A5A, 0xFF45705F, 0xFF467160, 0xFF436F5E, 0xFF426E5D, 0xFF426E5D, 0xFF44705F, 0xFF436B60, 0xFF3F6B5E, 0xFF356859, 0xFF2A6354, 0xFF225B4C, 0xFF1E5447, 0xFF1D4F44, 0xFF1E4D43, 0xFF1C4638, 0xFF1D4739, 0xFF1D4739, 0xFF1C4638, 0xFF1B4537,
    0xFF1B4537, 0xFF1D4739, 0xFF204A3C, 0xFF1D4C46, 0xFF1C4F48, 0xFF195549, 0xFF16584A, 0xFF185B4A, 0xFF225C4E, 0xFF305F55, 0xFF396359, 0xFF416654, 0xFF2D4E3D, 0xFF3C5446, 0xFF36483C, 0xFF3E4E43, 0xFF4C5C51, 0xFF495D51, 0xFF43594C, 0xFF52695F,
    0xFF446256, 0xFF54786A, 0xFF4E7A69, 0xFF4A7967, 0xFF4F7E6C, 0xFF517C6B, 0xFF3A6353, 0xFF41554A, 0xFF405449, 0xFF465A4F, 0xFF5C7065, 0xFF5C7065, 0xFF475B50, 0xFF43574C, 0xFF485C51, 0xFF406957, 0xFF537C6A, 0xFF55806D, 0xFF45705D, 0xFF2F5443,
    0xFF2C483A, 0xFF384C41, 0xFF344138, 0xFF2F4036, 0xFF3C5045, 0xFF3D5548, 0xFF3D594B, 0xFF3B5D4D, 0xFF4E7563, 0xFF527D6A, 0xFF527F6B, 0xFF4D796A, 0xFF4B7768, 0xFF487465, 0xFF3F6B5C, 0xFF315D4E, 0xFF234F40, 0xFF1F4B3C, 0xFF214D3E, 0xFF345F4C,
    0xFF3B6653, 0xFF436E5B, 0xFF436E5B, 0xFF3C6754, 0xFF315C49, 0xFF27523F, 0xFF214C39, 0xFF22382C, 0xFF1F372A, 0xFF1C3629, 0xFF1C3B2C, 0xFF1D3F2F, 0xFF204735, 0xFF285340, 0xFF335E4B, 0xFF4C7565, 0xFF507969, 0xFF547D6D, 0xFF547D6D, 0xFF527B6B,
    0xFF517A6A, 0xFF537C6C, 0xFF567F6F, 0xFF50796B, 0xFF517A6C, 0xFF527B6D, 0xFF527B6D, 0xFF527B6D, 0xFF527B6D, 0xFF527B6D, 0xFF537C6E, 0xFF4E786A, 0xFF4F796B, 0xFF4A7466, 0xFF477062, 0xFF466F61, 0xFF2A5345, 0xFF163C2F, 0xFF2C5245, 0xFF2E4744,
    0xFF455B59, 0xFF485858, 0xFF3A4646, 0xFF3A4445, 0xFF414B4A, 0xFF465250, 0xFF4D5C59, 0xFF4E5A58, 0xFF475351, 0xFF515D5B, 0xFF55615F, 0xFF5C6866, 0xFF606C6A, 0xFF586462, 0xFF4E5A58, 0xFF525E5E, 0xFF546060, 0xFF4E5C5C, 0xFF4F5D5D, 0xFF485857,
    0xFF435352, 0xFF40504F, 0xFF2D403E, 0xFF324241, 0xFF414F4F, 0xFF475555, 0xFF465454, 0xFF4B5757, 0xFF4C5858, 0xFF4C5657, 0xFF4D5758, 0xFF626054, 0xFF727064, 0xFF605E52, 0xFF636155, 0xFF78766A, 0xFF747266, 0xFF5E5C50, 0xFF706E62, 0xFFB3936D,
    0xFFAF916F, 0xFFAB9274, 0xFFA7957D, 0xFF887C6C, 0xFF605C51, 0xFF585752, 0xFF565855, 0xFF475555, 0xFF455353, 0xFF465252, 0xFF445050, 0xFF454F50, 0xFF4E5859, 0xFF545C5E, 0xFF50585A, 0xFF424E4E, 0xFF535F5F, 0xFF5E6C6C, 0xFF526261, 0xFF4F6260,
    0xFF495D5B, 0xFF4A605D, 0xFF2B413E, 0xFF364645, 0xFF4E5E5D, 0xFF516160, 0xFF536362, 0xFF4F5F5E, 0xFF4C5C5B, 0xFF516160, 0xFF3E4E4D, 0xFF4B6C61, 0xFF547A6D, 0xFF537D6F, 0xFF507C6D, 0xFF4E7266, 0x00DBEEE8, 0x00FEFFFF, 0x00FFFBFE, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xA0EACAA1, 0xFFDEA26E, 0xFFEB9E5A, 0xFFE8A153, 0xFFE4A057, 0xFFEA9E62, 0xFFF5A66E, 0xFFDC975C, 0xFFE89956, 0xFFE79A56, 0xFFE69B57, 0xFFE59C57, 0xFFE49E58,
    0xFFE39F58, 0xFFE3A059, 0xFFE3A059, 0xFFD8A065, 0xFFD59859, 0xFFE29D58, 0xFFE49A53, 0xFFDD9450, 0xFFE19F62, 0xFFBE8751, 0xFF744414, 0xFF714110, 0xFF734813, 0xFF724911, 0xFF774915, 0xFF774E22, 0xFF5F4F2D, 0xFF415637, 0xFF326546, 0xFF3F6858,
    0xFF436C5C, 0xFF477261, 0xFF477261, 0xFF436F5E, 0xFF416D5C, 0xFF416D5C, 0xFF406F5D, 0xFF41695E, 0xFF3B695C, 0xFF326757, 0xFF276051, 0xFF1F5849, 0xFF1D5145, 0xFF1F4D43, 0xFF234B43, 0xFF2A4F3E, 0xFF294E3D, 0xFF274C3B, 0xFF224736, 0xFF1D4231,
    0xFF1A3F2E, 0xFF1A3F2E, 0xFF1B402F, 0xFF1E4844, 0xFF1C4D47, 0xFF1A534A, 0xFF155749, 0xFF18584A, 0xFF1F594B, 0xFF2D5C52, 0xFF375F57, 0xFF3B5D4C, 0xFF355142, 0xFF4B5F53, 0xFF515E54, 0xFF5F6960, 0xFF677369, 0xFF647167, 0xFF536559, 0xFF52675E,
    0xFF405C50, 0xFF527668, 0xFF527E6D, 0xFF4C7B69, 0xFF4D7C6A, 0xFF527D6C, 0xFF376050, 0xFF565853, 0xFF636560, 0xFF6A6C67, 0xFF737570, 0xFF757772, 0xFF6C6E69, 0xFF62645F, 0xFF545651, 0xFF48715F, 0xFF57826F, 0xFF55806D, 0xFF48715F, 0xFF3C5C4D,
    0xFF495F53, 0xFF6A746C, 0xFF6F716C, 0xFF606A62, 0xFF6E7971, 0xFF63746A, 0xFF51695C, 0xFF3F5E4F, 0xFF4D7462, 0xFF517C69, 0xFF51806C, 0xFF4D796A, 0xFF4C7869, 0xFF487465, 0xFF3C6859, 0xFF275344, 0xFF133F30, 0xFF0A3627, 0xFF0B3728, 0xFF0F3A27,
    0xFF16412E, 0xFF1E4936, 0xFF204B38, 0xFF1A4532, 0xFF113C29, 0xFF093421, 0xFF05301D, 0xFF1E201B, 0xFF192019, 0xFF162119, 0xFF14251B, 0xFF10281B, 0xFF0E2A1C, 0xFF123424, 0xFF1A3F2E, 0xFF275040, 0xFF2B5444, 0xFF2E5747, 0xFF2D5646, 0xFF295242,
    0xFF285141, 0xFF2C5545, 0xFF305949, 0xFF466F61, 0xFF4C7567, 0xFF527B6D, 0xFF567F71, 0xFF567F71, 0xFF537C6E, 0xFF517A6C, 0xFF4F786A, 0xFF4D7769, 0xFF4B7567, 0xFF477163, 0xFF4A7365, 0xFF4C7567, 0xFF2C5547, 0xFF12382B, 0xFF294F42, 0xFF354747,
    0xFF465455, 0xFF4F595B, 0xFF515659, 0xFF575B5E, 0xFF525657, 0xFF4B5151, 0xFF545D5C, 0xFF4C5554, 0xFF404948, 0xFF47504F, 0xFF4B5453, 0xFF3F4847, 0xFF47504F, 0xFF495352, 0xFF4A5453, 0xFF535F5D, 0xFF566260, 0xFF4F5B59, 0xFF4B5A57, 0xFF475653,
    0xFF475653, 0xFF455552, 0xFF31413E, 0xFF384847, 0xFF495958, 0xFF4F5D5D, 0xFF495757, 0xFF495757, 0xFF4B5757, 0xFF475353, 0xFF465252, 0xFF71624D, 0xFF8A7B66, 0xFF756651, 0xFF786954, 0xFF93846F, 0xFF887964, 0xFF63543F, 0xFF776853, 0xFF957755,
    0xFF83684A, 0xFF7C684F, 0xFF887D6B, 0xFF757269, 0xFF4F5553, 0xFF495458, 0xFF48575E, 0xFF435352, 0xFF40504F, 0xFF465454, 0xFF4D5758, 0xFF4D5557, 0xFF515659, 0xFF54585B, 0xFF525357, 0xFF4F5457, 0xFF464E50, 0xFF3E4849, 0xFF3C4A4A, 0xFF3A4D4B,
    0xFF334946, 0xFF314A46, 0xFF1C3732, 0xFF344040, 0xFF525E5E, 0xFF4E5A5A, 0xFF4C5858, 0xFF4E5A5A, 0xFF4B5757, 0xFF4E5A5A, 0xFF424E4E, 0xFF4A6B60, 0xFF51776A, 0xFF507A6C, 0xFF517D6E, 0xFF4F7367, 0x00D7EAE4, 0x00FDFFFE, 0x00FFFCFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x91E9CBA9, 0xFFD69E65, 0xFFEEA159, 0xFFEBA25D, 0xFFE8A35E, 0xFFF1A55A, 0xFFF1A55A, 0xFFE09D57, 0xFFE39C5C, 0xFFE49D5D, 0xFFE7A060, 0xFFE7A060, 0xFFE69F5F,
    0xFFE59E5E, 0xFFE59E5E, 0xFFE59E5E, 0xFFE4A061, 0xFFDE9A59, 0xFFE09B58, 0xFFE29D5A, 0xFFDE9A59, 0xFFE0A364, 0xFFC28A4D, 0xFF794209, 0xFF64401C, 0xFF674522, 0xFF603E19, 0xFF643E11, 0xFF6D4917, 0xFF5A4B20, 0xFF405439, 0xFF39695D, 0xFF4C6D5A,
    0xFF416B57, 0xFF3F705D, 0xFF447265, 0xFF486C62, 0xFF4A6B62, 0xFF446F5E, 0xFF386C56, 0xFF386E57, 0xFF376A59, 0xFF2E5C51, 0xFF2F574F, 0xFF355552, 0xFF3B5552, 0xFF334946, 0xFF495E59, 0xFF54656C, 0xFF586970, 0xFF506266, 0xFF495B5D, 0xFF283A3A,
    0xFF314442, 0xFF3F524E, 0xFF2D403C, 0xFF1F443C, 0xFF1D483E, 0xFF175041, 0xFF165646, 0xFF195949, 0xFF1F5B4F, 0xFF2A5D54, 0xFF315E57, 0xFF356450, 0xFF405A4D, 0xFF8F918C, 0xFFA69E9B, 0xFFA19C98, 0xFFA4A59D, 0xFFA5A59D, 0xFFA5A29B, 0xFF89968F,
    0xFF456155, 0xFF4F7B6A, 0xFF467764, 0xFF4F7A69, 0xFF55796B, 0xFF4F7566, 0xFF426D5C, 0xFF79897F, 0xFFB1AEA9, 0xFFADA49D, 0xFFB0B0A4, 0xFFB1B3A6, 0xFFABA49C, 0xFFA5A6A0, 0xFF687C71, 0xFF4C6E5E, 0xFF597B6B, 0xFF5D7D6E, 0xFF476355, 0xFF566A5F,
    0xFF68726A, 0xFF80817C, 0xFF807B78, 0xFF756B6C, 0xFF908F8D, 0xFF606B65, 0xFF283F35, 0xFF3D5D50, 0xFF55796B, 0xFF4F7365, 0xFF55796B, 0xFF4E7A6D, 0xFF487669, 0xFF417161, 0xFF3F705D, 0xFF25503D, 0xFF0B2D1C, 0xFF132B1D, 0xFF182A1C, 0xFF192823,
    0xFF17221E, 0xFF191D1C, 0xFF1C1C1C, 0xFF1D1D1D, 0xFF1A1E1D, 0xFF15201C, 0xFF162520, 0xFF0C2417, 0xFF0D2317, 0xFF15261C, 0xFF16261C, 0xFF15251B, 0xFF14251B, 0xFF102419, 0xFF13291D, 0xFF1A2B23, 0xFF1D2A20, 0xFF343A2C, 0xFF524F3C, 0xFF847965,
    0xFF90816E, 0xFF877865, 0xFF837461, 0xFF657261, 0xFF2C4530, 0xFF1F452C, 0xFF294F38, 0xFF294934, 0xFF2E4936, 0xFF365744, 0xFF46725B, 0xFF4D7867, 0xFF4C7867, 0xFF477664, 0xFF477664, 0xFF4A7564, 0xFF2D5344, 0xFF163629, 0xFF2E4A3E, 0xFF2A3F3A,
    0xFF425551, 0xFF4E615D, 0xFF4D5D5A, 0xFF4F5E5B, 0xFF525E5C, 0xFF525C5B, 0xFF535D5C, 0xFF425454, 0xFF364848, 0xFF364848, 0xFF384A4A, 0xFF304242, 0xFF2F4141, 0xFF374949, 0xFF3B4D4D, 0xFF405955, 0xFF455957, 0xFF4E5A5A, 0xFF4D5557, 0xFF4A4F52,
    0xFF4A5254, 0xFF414F4F, 0xFF2F4240, 0xFF394747, 0xFF4E5A5A, 0xFF4B5757, 0xFF4D5959, 0xFF475152, 0xFF4A5455, 0xFF485052, 0xFF474F51, 0xFF4F5D46, 0xFF90825F, 0xFF635A49, 0xFF5C5250, 0xFFAB8C7A, 0xFF8D7C72, 0xFF4C5456, 0xFF6D6757, 0xFF8B8064,
    0xFF7E7355, 0xFF7F7454, 0xFF756C4D, 0xFF827D69, 0xFF5B5A55, 0xFF4F535E, 0xFF4D5467, 0xFF445252, 0xFF455151, 0xFF495354, 0xFF495354, 0xFF465051, 0xFF4B5757, 0xFF4C5C5B, 0xFF445755, 0xFF384C4B, 0xFF354747, 0xFF414F50, 0xFF475254, 0xFF3F4A4C,
    0xFF3C4A4B, 0xFF344646, 0xFF233736, 0xFF2F4342, 0xFF4B5B5B, 0xFF495555, 0xFF505558, 0xFF4F5356, 0xFF545859, 0xFF4F5555, 0xFF454E4D, 0xFF476D60, 0xFF547D6F, 0xFF578173, 0xFF577D70, 0xFF527267, 0x00DAEDE7, 0x00FCFFFF, 0x00FFFEFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x91E9CBA9, 0xFFD99E66, 0xFFEEA159, 0xFFEBA25D, 0xFFEAA45F, 0xFFF1A55A, 0xFFF1A559, 0xFFE19C57, 0xFFE39C5C, 0xFFE59E5E, 0xFFE7A060, 0xFFE7A060, 0xFFE69F5F,
    0xFFE59E5E, 0xFFE59E5E, 0xFFE59E5E, 0xFFE7A364, 0xFFE49F5E, 0xFFE29D5A, 0xFFE39E5B, 0xFFDE9A59, 0xFFDB9E5F, 0xFFC08549, 0xFF7F480F, 0xFF69390B, 0xFF64380B, 0xFF62370C, 0xFF6D4215, 0xFF6D4D1C, 0xFF4E451E, 0xFF334C36, 0xFF35685F, 0xFF456452,
    0xFF426956, 0xFF447361, 0xFF4A7669, 0xFF4B6C63, 0xFF46655D, 0xFF446D5D, 0xFF447560, 0xFF3B6C57, 0xFF396858, 0xFF355F55, 0xFF30534D, 0xFF4D6A68, 0xFF3A504E, 0xFF142725, 0xFF495956, 0xFF8899A0, 0xFF7B8C93, 0xFF85979B, 0xFF5A6C6E, 0xFF142626,
    0xFF394C4A, 0xFF586B67, 0xFF3A4D49, 0xFF23423C, 0xFF22473F, 0xFF1C4E42, 0xFF165344, 0xFF175546, 0xFF1E5B4C, 0xFF2A5F55, 0xFF306259, 0xFF32614D, 0xFF375144, 0xFF999B96, 0xFFCDC5C2, 0xFFCAC7C2, 0xFFB8B9B3, 0xFFB0B1A9, 0xFFBBB8B1, 0xFF9CA9A2,
    0xFF446054, 0xFF4D7968, 0xFF4F806D, 0xFF517C6B, 0xFF55796B, 0xFF507667, 0xFF2F5A49, 0xFF7A8A80, 0xFFD7D4CF, 0xFFE6DDD6, 0xFFE0E0D4, 0xFFDFE1D4, 0xFFE1DAD2, 0xFFC7C8C2, 0xFF62766B, 0xFF487360, 0xFF537E6B, 0xFF56816E, 0xFF486F5D, 0xFF507061,
    0xFF698174, 0xFF76867C, 0xFF657068, 0xFF59635B, 0xFF65756B, 0xFF425C4F, 0xFF1A3C2C, 0xFF2A5341, 0xFF4D7865, 0xFF537E6B, 0xFF4D7664, 0xFF4B7464, 0xFF4B7665, 0xFF45705F, 0xFF3C6756, 0xFF305647, 0xFF2A463A, 0xFF2E4239, 0xFF323F38, 0xFF2D3C37,
    0xFF17231F, 0xFF131917, 0xFF1B1D1C, 0xFF191B1A, 0xFF161C1A, 0xFF1F2B27, 0xFF2A3934, 0xFF30473F, 0xFF293E37, 0xFF2B3C36, 0xFF2A3934, 0xFF2B3A35, 0xFF2A3B35, 0xFF21362F, 0xFF213830, 0xFF34453F, 0xFF3B463E, 0xFF76796E, 0xFFA09D8E, 0xFFB5AC9B,
    0xFFB6A998, 0xFFB7A798, 0xFFB7A798, 0xFFA2A094, 0xFF747C6D, 0xFF5D725F, 0xFF586D5C, 0xFF525E50, 0xFF545F51, 0xFF536557, 0xFF4C6756, 0xFF507B6A, 0xFF4F7B6A, 0xFF4C7867, 0xFF4D7968, 0xFF4E7968, 0xFF315547, 0xFF18382B, 0xFF304C40, 0xFF2E413F,
    0xFF455856, 0xFF4F5F5E, 0xFF485656, 0xFF4B5757, 0xFF545E5F, 0xFF575F61, 0xFF555D5F, 0xFF404E4F, 0xFF3E4C4D, 0xFF414F50, 0xFF455354, 0xFF435152, 0xFF435152, 0xFF445253, 0xFF435152, 0xFF455957, 0xFF465655, 0xFF4A5455, 0xFF4A4F52, 0xFF4A4F52,
    0xFF4C5657, 0xFF455353, 0xFF344745, 0xFF303E3E, 0xFF445252, 0xFF435151, 0xFF4C5858, 0xFF4A5656, 0xFF4F595A, 0xFF4C5657, 0xFF4A5455, 0xFF5A6554, 0xFF91866A, 0xFF696657, 0xFF555450, 0xFF867062, 0xFF6E645B, 0xFF4C5658, 0xFF767266, 0xFFB18F6A,
    0xFFA3815B, 0xFFA4875D, 0xFFA38A62, 0xFF9D8D6C, 0xFF665E49, 0xFF4E4E46, 0xFF525355, 0xFF485454, 0xFF445050, 0xFF445050, 0xFF445050, 0xFF445050, 0xFF465454, 0xFF475756, 0xFF3F5250, 0xFF455958, 0xFF455757, 0xFF4D5B5C, 0xFF4E595B, 0xFF475254,
    0xFF465455, 0xFF3D4F4F, 0xFF273B3A, 0xFF334746, 0xFF4E5E5E, 0xFF4D5959, 0xFF4F5759, 0xFF4B5053, 0xFF515757, 0xFF4C5554, 0xFF454F4E, 0xFF466C5F, 0xFF527B6D, 0xFF557F71, 0xFF567C6F, 0xFF517166, 0x00DAEDE7, 0x00FCFFFF, 0x00FFFEFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x91EACCAA, 0xFFD99E66, 0xFFEFA159, 0xFFECA25B, 0xFFEAA45F, 0xFFF3A55B, 0xFFF2A459, 0xFFE19C57, 0xFFE39C5A, 0xFFE59E5C, 0xFFE7A05E, 0xFFE7A05E, 0xFFE69F5D,
    0xFFE59E5C, 0xFFE49D5B, 0xFFE59E5C, 0xFFE29E5F, 0xFFE19C5B, 0xFFE19A58, 0xFFE49E59, 0xFFDF9C58, 0xFFDB9B5B, 0xFFD1965A, 0xFFB47E42, 0xFFB9773A, 0xFFB5773C, 0xFFB37B42, 0xFFB5824D, 0xFF9F7B49, 0xFF6C6038, 0xFF41553C, 0xFF386256, 0xFF4D6857,
    0xFF4C6E5D, 0xFF45705F, 0xFF446A5F, 0xFF4C6A62, 0xFF536E67, 0xFF4B6F61, 0xFF406D59, 0xFF3D6656, 0xFF3E6457, 0xFF3E5F58, 0xFF355250, 0xFF435859, 0xFF7F9193, 0xFF1B2929, 0xFF4D5957, 0xFFA9B8BF, 0xFFA9B8BF, 0xFFB1C0C5, 0xFF48575A, 0xFF2B3B3B,
    0xFF819190, 0xFF546461, 0xFF162623, 0xFF273C37, 0xFF28463E, 0xFF244E44, 0xFF1B4F42, 0xFF155243, 0xFF1B5849, 0xFF255F51, 0xFF2C6459, 0xFF2C5B49, 0xFF2E4A3E, 0xFF949993, 0xFFC8C3C0, 0xFFBAB7B2, 0xFFA0A19B, 0xFF9FA09A, 0xFFBBB8B1, 0xFF95A29B,
    0xFF405C50, 0xFF477362, 0xFF4E7F6C, 0xFF4F7A69, 0xFF517567, 0xFF527869, 0xFF345F4E, 0xFF76857E, 0xFFD1D0CC, 0xFFD7CEC9, 0xFFC3C5BA, 0xFFC2C4B9, 0xFFCFCAC4, 0xFFC0C2BD, 0xFF576C63, 0xFF3A6B56, 0xFF457661, 0xFF4D816B, 0xFF457661, 0xFF305D49,
    0xFF3C6351, 0xFF3F5F50, 0xFF2C483A, 0xFF2A4637, 0xFF325342, 0xFF2C513F, 0xFF15402C, 0xFF113E29, 0xFF24513C, 0xFF2A5541, 0xFF1D4733, 0xFF254635, 0xFF254736, 0xFF1C3E2E, 0xFF18382B, 0xFF2D483F, 0xFF425752, 0xFF435151, 0xFF454F50, 0xFF394A44,
    0xFF192823, 0xFF0D1814, 0xFF141D1A, 0xFF131C19, 0xFF1B2622, 0xFF32413C, 0xFF41524C, 0xFF3C504E, 0xFF3B4E4C, 0xFF465454, 0xFF475353, 0xFF3F4D4D, 0xFF384847, 0xFF2D413F, 0xFF304945, 0xFF354441, 0xFF4B5650, 0xFF999C93, 0xFFBAB6AB, 0xFFBCB2A6,
    0xFFB6A89D, 0xFFB3A59A, 0xFFB7A9A0, 0xFFC7B4AE, 0xFFB8AFA6, 0xFFAFB1A4, 0xFFB1B1A7, 0xFFAFA8A0, 0xFFAFA69F, 0xFF9C9D95, 0xFF6F7B6F, 0xFF507B6A, 0xFF4F7A69, 0xFF497564, 0xFF497564, 0xFF4B7665, 0xFF315547, 0xFF1C3A2E, 0xFF365045, 0xFF334342,
    0xFF485857, 0xFF505E5E, 0xFF495555, 0xFF4B5556, 0xFF565E60, 0xFF596163, 0xFF555A5D, 0xFF566062, 0xFF5C6668, 0xFF5E686A, 0xFF5F696B, 0xFF616B6D, 0xFF606A6C, 0xFF5D6769, 0xFF5E686A, 0xFF515D5D, 0xFF4E5859, 0xFF4B5355, 0xFF4A5254, 0xFF4C5456,
    0xFF4D5959, 0xFF455554, 0xFF364A48, 0xFF364645, 0xFF4A5A59, 0xFF495757, 0xFF4D5B5B, 0xFF495555, 0xFF4A5656, 0xFF495354, 0xFF4A5455, 0xFF4C564B, 0xFF706D5A, 0xFF5B6157, 0xFF4D5651, 0xFF605C50, 0xFF50514B, 0xFF444F51, 0xFF5E5F59, 0xFFA17C5F,
    0xFFA68262, 0xFFA88764, 0xFF9B835F, 0xFF837455, 0xFF605B45, 0xFF4E5446, 0xFF4E5951, 0xFF495555, 0xFF455151, 0xFF445252, 0xFF455353, 0xFF435352, 0xFF455554, 0xFF485857, 0xFF445755, 0xFF435756, 0xFF455757, 0xFF4E5C5D, 0xFF4F5A5C, 0xFF4C5759,
    0xFF4F5D5E, 0xFF425454, 0xFF293D3C, 0xFF2C403F, 0xFF485858, 0xFF4C5858, 0xFF4F595A, 0xFF485253, 0xFF4C5856, 0xFF445350, 0xFF3B4B48, 0xFF476D60, 0xFF50796B, 0xFF537D6F, 0xFF557B6E, 0xFF517166, 0x00DAEDE7, 0x00FCFFFF, 0x00FFFEFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x94ECCBA8, 0xFFD99E64, 0xFFF0A258, 0xFFEDA35C, 0xFFEAA45E, 0xFFF3A55A, 0xFFF2A459, 0xFFE19D56, 0xFFE69C5B, 0xFFE79D5C, 0xFFE99F5E, 0xFFE99F5E, 0xFFE89E5D,
    0xFFE69C5B, 0xFFE69C5B, 0xFFE69C5B, 0xFFE8A362, 0xFFE6A15E, 0xFFE39D58, 0xFFE6A05B, 0xFFE09B58, 0xFFD79757, 0xFFDCA263, 0xFFD9A367, 0xFFDD9C5A, 0xFFE0A062, 0xFFD79C62, 0xFFBB8954, 0xFF8A6A3B, 0xFF564C28, 0xFF354427, 0xFF2D4A34, 0xFF384D3E,
    0xFF314D3E, 0xFF1E4234, 0xFF1F4037, 0xFF3F5852, 0xFF5D726D, 0xFF516F63, 0xFF355C4A, 0xFF466659, 0xFF537167, 0xFF263F3C, 0xFF495D5E, 0xFF46555A, 0xFF8F9A9E, 0xFF667072, 0xFF2D3635, 0xFFAAB7BF, 0xFFB8C5CD, 0xFFB2BFC5, 0xFF3B494C, 0xFF5E6C6D,
    0xFF9EACAC, 0xFF23322F, 0xFF142320, 0xFF1E2A28, 0xFF233632, 0xFF24433B, 0xFF1F4A40, 0xFF1A5042, 0xFF1F594B, 0xFF276455, 0xFF2E6B5C, 0xFF3B6C59, 0xFF3E5A4E, 0xFF999E9A, 0xFFB3AEAB, 0xFF9E9A97, 0xFF959891, 0xFF9E9F99, 0xFFB6B3AE, 0xFF909D96,
    0xFF526E62, 0xFF558170, 0xFF50816E, 0xFF537E6D, 0xFF507466, 0xFF557B6C, 0xFF497463, 0xFF7B8C84, 0xFFC4C3BF, 0xFFC0B9B3, 0xFFBABCB1, 0xFFB8BBB0, 0xFFBDB8B2, 0xFFB7B9B4, 0xFF5C7168, 0xFF4C7766, 0xFF4F7B6A, 0xFF538270, 0xFF4D7E6B, 0xFF21503E,
    0xFF244D3D, 0xFF25493B, 0xFF1B3B2E, 0xFF1A3D29, 0xFF1E442F, 0xFF1E442F, 0xFF143A25, 0xFF0D301C, 0xFF0D301C, 0xFF0F301D, 0xFF0A2917, 0xFF0F2A17, 0xFF0D2817, 0xFF0D2517, 0xFF10251C, 0xFF2F423E, 0xFF4C5A5A, 0xFF4F585D, 0xFF5C636B, 0xFF50605D,
    0xFF3B4B48, 0xFF243330, 0xFF1F2E2B, 0xFF21302D, 0xFF2B3A37, 0xFF3F4F4C, 0xFF495956, 0xFF425456, 0xFF3D4C4F, 0xFF475558, 0xFF485357, 0xFF3F4D50, 0xFF344648, 0xFF273C3D, 0xFF2C4645, 0xFF3D4949, 0xFF6A7370, 0xFFB1B2AC, 0xFFBBB7AE, 0xFFC5BBB2,
    0xFFC4B7AF, 0xFFBAADA7, 0xFFC2B4B1, 0xFFC1ACA7, 0xFFC3B6AE, 0xFFBBB4AA, 0xFFBFB6AF, 0xFFC1B2AD, 0xFFC4B5B0, 0xFFAFAAA4, 0xFF6D756A, 0xFF4E7767, 0xFF4D7867, 0xFF497564, 0xFF4A7665, 0xFF4B7464, 0xFF2D5143, 0xFF153327, 0xFF2B453A, 0xFF2E3E3D,
    0xFF3E4E4D, 0xFF475555, 0xFF445050, 0xFF465051, 0xFF4B5556, 0xFF4C5456, 0xFF484D50, 0xFF41494C, 0xFF474F52, 0xFF444C4F, 0xFF424A4D, 0xFF454D50, 0xFF41494C, 0xFF454D50, 0xFF575F62, 0xFF4F5759, 0xFF4D5557, 0xFF4C5657, 0xFF4E5859, 0xFF505C5C,
    0xFF4E5E5D, 0xFF495C5A, 0xFF415553, 0xFF465957, 0xFF5B6B6A, 0xFF586867, 0xFF5A6A69, 0xFF526060, 0xFF536161, 0xFF586464, 0xFF5E6A6A, 0xFF566159, 0xFF5B655A, 0xFF55645D, 0xFF596A64, 0xFF5F6C65, 0xFF5C6864, 0xFF5B6969, 0xFF5C6260, 0xFF625C50,
    0xFF6D675B, 0xFF6C695A, 0xFF666759, 0xFF5B6155, 0xFF57665F, 0xFF526768, 0xFF4F6B6E, 0xFF546060, 0xFF505E5E, 0xFF50605F, 0xFF4D605E, 0xFF485C5A, 0xFF445856, 0xFF475A58, 0xFF4C5C5B, 0xFF495D5C, 0xFF465858, 0xFF485657, 0xFF495456, 0xFF4A5557,
    0xFF4F5D5E, 0xFF465858, 0xFF344847, 0xFF3F5352, 0xFF536363, 0xFF546262, 0xFF566262, 0xFF505E5E, 0xFF586B67, 0xFF506761, 0xFF465F59, 0xFF4B7164, 0xFF527B6D, 0xFF537D6F, 0xFF567C6F, 0xFF537368, 0x00DBEEE8, 0x00FCFFFF, 0x00FFFEFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x94ECCBA8, 0xFFDA9D64, 0xFFF1A158, 0xFFEFA25A, 0xFFECA35E, 0xFFF3A55A, 0xFFF4A558, 0xFFE39D57, 0xFFE69D59, 0xFFE89F5B, 0xFFE9A05C, 0xFFE9A05C, 0xFFE89F5B,
    0xFFE69D59, 0xFFE69D59, 0xFFE69D59, 0xFFE5A05F, 0xFFE9A260, 0xFFE49B57, 0xFFE49B56, 0xFFE29D58, 0xFFDE9D5D, 0xFFD29658, 0xFFBA8247, 0xFFA27C4F, 0xFFA68155, 0xFF9E7D54, 0xFF7A6341, 0xFF463F25, 0xFF222B18, 0xFF19301E, 0xFF1B3A2A, 0xFF556356,
    0xFF395143, 0xFF224034, 0xFF254039, 0xFF384B47, 0xFF41504D, 0xFF364D43, 0xFF284A3A, 0xFF415B52, 0xFF3E554F, 0xFF445857, 0xFF718085, 0xFF6A777D, 0xFF636C71, 0xFF99A1A4, 0xFF515659, 0xFF849199, 0xFF8C99A1, 0xFF929FA5, 0xFF69777A, 0xFF808E8F,
    0xFF647272, 0xFF02110E, 0xFF23322F, 0xFF1B2421, 0xFF202F2A, 0xFF253C36, 0xFF22463C, 0xFF1E4C41, 0xFF1E5446, 0xFF245E50, 0xFF296657, 0xFF3A6A5A, 0xFF3B594F, 0xFF969C98, 0xFFABA7A6, 0xFF9D9C98, 0xFFA6A8A3, 0xFFA8ABA4, 0xFFB0AFAA, 0xFF88958E,
    0xFF4F6B5F, 0xFF578372, 0xFF4F806D, 0xFF537E6D, 0xFF55796B, 0xFF587E6F, 0xFF4A7564, 0xFF81928C, 0xFFC5C4C0, 0xFFBFB7B4, 0xFFBCBFB4, 0xFFBBBEB3, 0xFFBFBCB7, 0xFFBDC2BC, 0xFF647B73, 0xFF547668, 0xFF54786A, 0xFF4F7566, 0xFF406657, 0xFF15392B,
    0xFF1B3B2E, 0xFF1B372B, 0xFF0E251B, 0xFF22412F, 0xFF274432, 0xFF243C2C, 0xFF2A3F30, 0xFF384A3C, 0xFF354538, 0xFF2B3B2E, 0xFF313F32, 0xFF334A38, 0xFF2B4031, 0xFF2C3D33, 0xFF2C3932, 0xFF374140, 0xFF464E51, 0xFF585F65, 0xFF7C838B, 0xFF63726F,
    0xFF5D6C69, 0xFF41514E, 0xFF3F4F4C, 0xFF4A5A57, 0xFF455552, 0xFF4D5C59, 0xFF5A6966, 0xFF617073, 0xFF485659, 0xFF465155, 0xFF424D51, 0xFF414F52, 0xFF3A4E4F, 0xFF253D3D, 0xFF284543, 0xFF3D4746, 0xFF757B79, 0xFFB6B7B1, 0xFFBCB5AD, 0xFFC4B9B3,
    0xFFC4B7B1, 0xFFBAAFAB, 0xFFC1B6B4, 0xFFC4B7AF, 0xFFC4BDB3, 0xFFB6B4A8, 0xFFBAB3AB, 0xFFBEAFAA, 0xFFBFB4AE, 0xFFABACA4, 0xFF657568, 0xFF4C7565, 0xFF4F7868, 0xFF4F7A69, 0xFF527D6C, 0xFF4F7868, 0xFF2C4E40, 0xFF0C281C, 0xFF1E352B, 0xFF0B1F1E,
    0xFF102222, 0xFF152727, 0xFF1A2A2A, 0xFF1A2829, 0xFF1C2729, 0xFF1C2628, 0xFF1A2426, 0xFF172123, 0xFF1A2426, 0xFF162022, 0xFF162022, 0xFF172123, 0xFF0F191B, 0xFF1D2729, 0xFF414B4D, 0xFF212D2D, 0xFF1F2D2D, 0xFF1D2D2C, 0xFF1B2E2C, 0xFF192D2B,
    0xFF172B29, 0xFF172B29, 0xFF1A2E2C, 0xFF203432, 0xFF2D403E, 0xFF263937, 0xFF2C3F3D, 0xFF293938, 0xFF2A3A39, 0xFF2A3838, 0xFF2C3A3A, 0xFF303F3A, 0xFF213533, 0xFF213430, 0xFF293C36, 0xFF233C39, 0xFF2A3E3C, 0xFF394843, 0xFF2C3C3C, 0xFF2C4643,
    0xFF27403D, 0xFF233736, 0xFF2F4141, 0xFF344648, 0xFF2E4348, 0xFF1F383F, 0xFF1F3A45, 0xFF293334, 0xFF253333, 0xFF203432, 0xFF1D3632, 0xFF1F3834, 0xFF203633, 0xFF223533, 0xFF253534, 0xFF293D3C, 0xFF1C2E2E, 0xFF152324, 0xFF141F21, 0xFF162123,
    0xFF182627, 0xFF162828, 0xFF112524, 0xFF132525, 0xFF1C2C2C, 0xFF1C2C2B, 0xFF233332, 0xFF2F4240, 0xFF506963, 0xFF58776F, 0xFF587970, 0xFF51776A, 0xFF557E70, 0xFF547E70, 0xFF577D70, 0xFF55756A, 0x00DBEEE8, 0x00FBFFFE, 0x00FFFDFE, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x98EDCBA6, 0xFFDB9F63, 0xFFF1A257, 0xFFEFA25A, 0xFFEDA55D, 0xFFF4A558, 0xFFF4A558, 0xFFE39D55, 0xFFE79C59, 0xFFE99E5B, 0xFFEBA05D, 0xFFEA9F5C, 0xFFE99E5B,
    0xFFE79C59, 0xFFE69B58, 0xFFE69B58, 0xFFDE9755, 0xFFE6A05B, 0xFFE19853, 0xFFDF9651, 0xFFE7A15C, 0xFFE6A563, 0xFFC08445, 0xFF824A0D, 0xFF56472A, 0xFF4E3F22, 0xFF4A3E26, 0xFF3F4133, 0xFF293E39, 0xFF224445, 0xFF2A534F, 0xFF315951, 0xFF293126,
    0xFF213327, 0xFF375146, 0xFF5A6F6A, 0xFF5B6765, 0xFF404A49, 0xFF304139, 0xFF2C483A, 0xFF293E37, 0xFF192E29, 0xFF546668, 0xFF849398, 0xFF848E97, 0xFF6F787F, 0xFF98A0A3, 0xFF8A9294, 0xFF68727B, 0xFF6A747D, 0xFF778288, 0xFF929DA1, 0xFF8A9597,
    0xFF606C6C, 0xFF434F4D, 0xFF131F1D, 0xFF1D2623, 0xFF1C2824, 0xFF1E312B, 0xFF213F37, 0xFF22483D, 0xFF1F4D42, 0xFF23594B, 0xFF2B6455, 0xFF2A5A4A, 0xFF2C4A40, 0xFF959B99, 0xFFB4B0AF, 0xFFA6A5A3, 0xFFAAAFA9, 0xFFADAFAA, 0xFFBAB9B5, 0xFF84918A,
    0xFF365246, 0xFF4C7867, 0xFF4F806D, 0xFF517C6B, 0xFF5B7F71, 0xFF547A6B, 0xFF335E4D, 0xFF677A74, 0xFFC3C3C1, 0xFFC6C1BD, 0xFFC2C5BC, 0xFFBFC5BB, 0xFFC9C6C1, 0xFFBDC2BE, 0xFF485F57, 0xFF4D6E63, 0xFF5B7C71, 0xFF507468, 0xFF315247, 0xFF1A382E,
    0xFF3C534B, 0xFF5D6E68, 0xFF66726E, 0xFF53695D, 0xFF607167, 0xFF616E65, 0xFF666D66, 0xFF6F746E, 0xFF676C66, 0xFF5E635D, 0xFF646B64, 0xFF586C61, 0xFF56675D, 0xFF66736C, 0xFF6B7471, 0xFF5A6060, 0xFF4C5154, 0xFF535B5E, 0xFF687274, 0xFF697173,
    0xFF656F70, 0xFF4B5959, 0xFF566665, 0xFF677776, 0xFF526060, 0xFF545E5F, 0xFF6C7476, 0xFF5F6D6E, 0xFF465153, 0xFF465153, 0xFF434E50, 0xFF404E4F, 0xFF364A49, 0xFF1F3936, 0xFF25443F, 0xFF404944, 0xFF757A74, 0xFFB7B7AF, 0xFFC6BFB5, 0xFFC4BAB1,
    0xFFB9AEA8, 0xFFBBB0AE, 0xFFBDB3B2, 0xFFBAB3A9, 0xFFBBB9AD, 0xFFB4B4A8, 0xFFBFB8B0, 0xFFC3B6B0, 0xFFC2B9B2, 0xFFA8B0A5, 0xFF637A6A, 0xFF507667, 0xFF4F7868, 0xFF4D7867, 0xFF4E7968, 0xFF4F7566, 0xFF2E5042, 0xFF132F23, 0xFF273E34, 0xFF334C49,
    0xFF2D4643, 0xFF304644, 0xFF354948, 0xFF354747, 0xFF354747, 0xFF3A4A4A, 0xFF3B4B4B, 0xFF3A4C4C, 0xFF384A4A, 0xFF314343, 0xFF2D3F3F, 0xFF233535, 0xFF102222, 0xFF1C2E2E, 0xFF445656, 0xFF304643, 0xFF2D4642, 0xFF28433E, 0xFF24413C, 0xFF243F3A,
    0xFF223B37, 0xFF2B3F3D, 0xFF394948, 0xFF2D413F, 0xFF324644, 0xFF263A38, 0xFF314442, 0xFF354846, 0xFF374A48, 0xFF30403F, 0xFF293938, 0xFF283B35, 0xFF1D3B3D, 0xFF2D423D, 0xFF3C4C42, 0xFF254142, 0xFF243D39, 0xFF344439, 0xFF203D3B, 0xFF1D3C36,
    0xFF2A4540, 0xFF314543, 0xFF354544, 0xFF424E4E, 0xFF3D4949, 0xFF394747, 0xFF415150, 0xFF3F494A, 0xFF3A4848, 0xFF2E4441, 0xFF26433E, 0xFF2B4A44, 0xFF334E49, 0xFF344745, 0xFF334141, 0xFF3E5251, 0xFF354747, 0xFF324041, 0xFF374244, 0xFF394446,
    0xFF364445, 0xFF334545, 0xFF324645, 0xFF344646, 0xFF354545, 0xFF2E3E3D, 0xFF2C3F3D, 0xFF314744, 0xFF4F6E66, 0xFF53796E, 0xFF507A6E, 0xFF557B6E, 0xFF578072, 0xFF547E70, 0xFF587E71, 0xFF56766B, 0x00DCEFE9, 0x00FBFFFE, 0x00FFFCFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x94EECCA7, 0xFFDC9E63, 0xFFF1A257, 0xFFEFA25A, 0xFFEEA45D, 0xFFF5A659, 0xFFF4A556, 0xFFE59D55, 0xFFE89D59, 0xFFE99E5A, 0xFFEBA05C, 0xFFEA9F5B, 0xFFE99E5A,
    0xFFE79C58, 0xFFE69B57, 0xFFE69B57, 0xFFE59E5C, 0xFFEAA15D, 0xFFE59C57, 0xFFE49B56, 0xFFE49E59, 0xFFDF9E5C, 0xFFC18445, 0xFF8B5014, 0xFF765528, 0xFF67461B, 0xFF553B16, 0xFF3A341E, 0xFF1E2F29, 0xFF1E3E3D, 0xFF2B4E4A, 0xFF2C4C3F, 0xFF2E3128,
    0xFF334036, 0xFF3F544B, 0xFF3D4D4A, 0xFF2F3837, 0xFF313737, 0xFF2B3831, 0xFF11291C, 0xFF1A2F28, 0xFF1C2F2D, 0xFF1B2D2F, 0xFF627178, 0xFF828F97, 0xFF848F95, 0xFF919A9F, 0xFF7A8486, 0xFF757E87, 0xFF747D86, 0xFF757E85, 0xFF828B90, 0xFF828C8E,
    0xFF909A9B, 0xFF9EA8A7, 0xFF414B4A, 0xFF1C2824, 0xFF14201C, 0xFF13241E, 0xFF1E352D, 0xFF24433B, 0xFF254D42, 0xFF2D5D51, 0xFF3C6E62, 0xFF346756, 0xFF2E4C42, 0xFF999F9D, 0xFFBEBABB, 0xFFB1B1AF, 0xFFB3B8B4, 0xFFB5BAB4, 0xFFCACBC6, 0xFF8C9992,
    0xFF345044, 0xFF507C6B, 0xFF558673, 0xFF55806F, 0xFF577B6D, 0xFF446A5B, 0xFF2A5544, 0xFF7A8D89, 0xFFD3D3D1, 0xFFCFCAC7, 0xFFC3C9BF, 0xFFC1C7BD, 0xFFCFCBC8, 0xFFC8CDC9, 0xFF516862, 0xFF3E6A5B, 0xFF527E6F, 0xFF4B7567, 0xFF254E40, 0xFF27483D,
    0xFF4E685F, 0xFF8FA09A, 0xFFBAC5C1, 0xFFA0B5AE, 0xFFABBCB6, 0xFFB0BBB7, 0xFF9CA09F, 0xFF7E807F, 0xFF717574, 0xFF6D7673, 0xFF626E6A, 0xFF4F645F, 0xFF5B6B68, 0xFF778180, 0xFF787E7E, 0xFF4E5253, 0xFF414747, 0xFF5B6765, 0xFF677673, 0xFF6E6F73,
    0xFF686D70, 0xFF4E5A5A, 0xFF5A6868, 0xFF657373, 0xFF4D5959, 0xFF515659, 0xFF67686C, 0xFF5F6B6B, 0xFF4E5859, 0xFF5C6667, 0xFF5A6666, 0xFF4F5F5E, 0xFF3E5451, 0xFF24413C, 0xFF32534C, 0xFF4B524A, 0xFF888B82, 0xFFB7B7AB, 0xFFC1BBAF, 0xFFC4BCB1,
    0xFFBAB0A7, 0xFFC1B8B3, 0xFFC2BAB7, 0xFFC1B8AF, 0xFFBEBAAF, 0xFFB9B5AA, 0xFFBFB4AE, 0xFFC2B0AC, 0xFFC2B5AF, 0xFFA6ACA2, 0xFF667D6D, 0xFF517768, 0xFF4E7767, 0xFF4B7464, 0xFF4B7464, 0xFF4D7364, 0xFF315144, 0xFF193529, 0xFF31483E, 0xFF2B4947,
    0xFF254341, 0xFF264341, 0xFF2C4645, 0xFF2C4444, 0xFF324748, 0xFF354A4B, 0xFF344849, 0xFF2E4B47, 0xFF2C4945, 0xFF2A4743, 0xFF2A4743, 0xFF23403C, 0xFF16332F, 0xFF24413D, 0xFF46635F, 0xFF3D6059, 0xFF3B6058, 0xFF365E55, 0xFF386057, 0xFF3E615A,
    0xFF425D58, 0xFF4B5E5C, 0xFF5D6969, 0xFF3E5451, 0xFF415754, 0xFF354B48, 0xFF425654, 0xFF495D5B, 0xFF506361, 0xFF4B5E5C, 0xFF485B59, 0xFF324C41, 0xFF2D5258, 0xFF485B57, 0xFF5E665B, 0xFF486166, 0xFF3F5552, 0xFF445543, 0xFF29504B, 0xFF435853,
    0xFF61716E, 0xFF6C7876, 0xFF505A59, 0xFF505956, 0xFF3D4842, 0xFF405045, 0xFF4E6052, 0xFF61696B, 0xFF5E6E6D, 0xFF4B6460, 0xFF35564F, 0xFF33544D, 0xFF37544F, 0xFF3A4E4C, 0xFF3B4949, 0xFF394D4C, 0xFF3B4D4D, 0xFF414F50, 0xFF485355, 0xFF4A5557,
    0xFF465455, 0xFF405252, 0xFF3D5150, 0xFF415353, 0xFF425252, 0xFF3F5250, 0xFF3A4E4C, 0xFF37524D, 0xFF50746A, 0xFF4F7B6E, 0xFF4A7A6C, 0xFF567C6F, 0xFF567F71, 0xFF527C6E, 0xFF577D70, 0xFF56766B, 0x00DCEFE9, 0x00FBFFFE, 0x00FFFCFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x94EECCA7, 0xFFDC9E63, 0xFFF4A258, 0xFFF0A258, 0xFFEEA45D, 0xFFF5A659, 0xFFF6A556, 0xFFE59D55, 0xFFE89D59, 0xFFEA9F5B, 0xFFEBA05C, 0xFFEBA05C, 0xFFE99E5A,
    0xFFE79C58, 0xFFE69B57, 0xFFE69B57, 0xFFE69F5D, 0xFFE39A56, 0xFFE69B57, 0xFFEDA35C, 0xFFE29C56, 0xFFDB9756, 0xFFDB9E5F, 0xFFCE9357, 0xFFC9853C, 0xFFCE8B44, 0xFFBE8445, 0xFF7C5B30, 0xFF342F19, 0xFF1F2D1E, 0xFF253624, 0xFF1F2C12, 0xFF26271F,
    0xFF3E4A40, 0xFF3D4E46, 0xFF152421, 0xFF1A2020, 0xFF5C5D5F, 0xFF5F6A64, 0xFF192F23, 0xFF172C27, 0xFF122523, 0xFF1F3133, 0xFF37464D, 0xFF75828A, 0xFF7E8B91, 0xFF838E92, 0xFF808B8D, 0xFF747D86, 0xFF778089, 0xFF7B848B, 0xFF6B7479, 0xFF778183,
    0xFF929C9D, 0xFFA7B1B0, 0xFF9BA5A4, 0xFF2B3A33, 0xFF1A2924, 0xFF13241E, 0xFF1C312A, 0xFF223D36, 0xFF21453B, 0xFF2B554B, 0xFF3B695E, 0xFF3C6F60, 0xFF244439, 0xFF838C89, 0xFFADABAC, 0xFFB0B0AE, 0xFFB9BEBA, 0xFFB3B8B2, 0xFFBDBEB9, 0xFF7F8C85,
    0xFF304C40, 0xFF4F7B6A, 0xFF51826F, 0xFF55806F, 0xFF4D7163, 0xFF345A4B, 0xFF386352, 0xFF778A86, 0xFFC7C7C5, 0xFFC8C3C0, 0xFFCED4CA, 0xFFCAD0C6, 0xFFC3C2BE, 0xFFB5BBB7, 0xFF425B55, 0xFF417865, 0xFF508774, 0xFF4F8472, 0xFF346353, 0xFF345D4F,
    0xFF304E44, 0xFF4F625C, 0xFF72817C, 0xFF829B97, 0xFF90A3A1, 0xFFADB9B9, 0xFFA2AAAC, 0xFF7E8386, 0xFF818B8C, 0xFF839392, 0xFF5D716F, 0xFF526667, 0xFF7F8F8F, 0xFFB7C1C3, 0xFFB1B5B8, 0xFF626667, 0xFF424B48, 0xFF62716A, 0xFF64786F, 0xFF69686D,
    0xFF666A6D, 0xFF4F595A, 0xFF546262, 0xFF5A6868, 0xFF4E5859, 0xFF5A5E61, 0xFF656469, 0xFF606C6A, 0xFF4A5453, 0xFF555F5E, 0xFF535F5D, 0xFF495956, 0xFF384F49, 0xFF1B3931, 0xFF284940, 0xFF666E63, 0xFFB1B5A7, 0xFFC3C1B4, 0xFFB4AEA0, 0xFFC6BEB1,
    0xFFBEB6AB, 0xFFBEB7AF, 0xFFC1BAB4, 0xFFC7BAB2, 0xFFC3BAB1, 0xFFC3B9B0, 0xFFC5B3AF, 0xFFC6ACAB, 0xFFC6B3AF, 0xFFA6A69E, 0xFF67796B, 0xFF4F7566, 0xFF517768, 0xFF4F7868, 0xFF517A6A, 0xFF517768, 0xFF305043, 0xFF132D22, 0xFF263D33, 0xFF20433F,
    0xFF1E413D, 0xFF234340, 0xFF264442, 0xFF284543, 0xFF304A49, 0xFF334B4B, 0xFF2B4343, 0xFF254842, 0xFF234640, 0xFF22453F, 0xFF244741, 0xFF20433D, 0xFF1B3E38, 0xFF2B4E48, 0xFF466963, 0xFF416C62, 0xFF3B695E, 0xFF366459, 0xFF38665B, 0xFF3D655C,
    0xFF3A5752, 0xFF3C4F4D, 0xFF495354, 0xFF39524E, 0xFF405653, 0xFF324845, 0xFF374D4A, 0xFF374B49, 0xFF3C504E, 0xFF3F5250, 0xFF455856, 0xFF314D3F, 0xFF234C52, 0xFF32433D, 0xFF494B40, 0xFF3D545A, 0xFF3C524F, 0xFF41533D, 0xFF25524B, 0xFF3B4A4D,
    0xFF4C5A5D, 0xFF576266, 0xFF434E52, 0xFF4A5A59, 0xFF233831, 0xFF233F31, 0xFF395A47, 0xFF50585A, 0xFF566665, 0xFF46615C, 0xFF284B44, 0xFF1D4039, 0xFF25423D, 0xFF314543, 0xFF3B4949, 0xFF354948, 0xFF3B4D4D, 0xFF3E4C4D, 0xFF3D484A, 0xFF3D484A,
    0xFF3D4B4C, 0xFF3A4C4C, 0xFF384C4B, 0xFF3F4F4F, 0xFF405050, 0xFF405351, 0xFF384E4B, 0xFF304D48, 0xFF4B7166, 0xFF4D7B6E, 0xFF4C8171, 0xFF557B6E, 0xFF547D6F, 0xFF507A6C, 0xFF567C6F, 0xFF56766B, 0x00DCEFE9, 0x00FBFFFE, 0x00FFFDFE, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xB3EBC197, 0xFFE19F62, 0xFFF2A056, 0xFFEDA25E, 0xFFEDA664, 0xFFF3A55D, 0xFFF7A55B, 0xFFE69B57, 0xFFE69B58, 0xFFEA9F5C, 0xFFE89D59, 0xFFECA15D, 0xFFEBA05C,
    0xFFE79D56, 0xFFEBA15A, 0xFFE89E57, 0xFFE59F61, 0xFFEAA363, 0xFFE89E5D, 0xFFE19756, 0xFFE19A5A, 0xFFE39F62, 0xFFDB9D62, 0xFFD49760, 0xFFCF9C5D, 0xFFD59663, 0xFFC79359, 0xFFC2904B, 0xFFA6733C, 0xFF4E4A27, 0xFF234B31, 0xFF1B3824, 0xFF131F1B,
    0xFF192926, 0xFF1A2E2C, 0xFF344D4A, 0xFF152E2A, 0xFF344B45, 0xFF3B5047, 0xFF162A1E, 0xFF132926, 0xFF1C302E, 0xFF213432, 0xFF667675, 0xFF788484, 0xFF7B8586, 0xFF838B8D, 0xFF888D90, 0xFF828D93, 0xFF788188, 0xFF7E878C, 0xFF727B80, 0xFF727A7D,
    0xFF949C9F, 0xFFA2A7AA, 0xFF919699, 0xFF60686A, 0xFF132725, 0xFF152C26, 0xFF1C2826, 0xFF20332D, 0xFF204A3C, 0xFF225544, 0xFF396453, 0xFF466962, 0xFF244740, 0xFF2A4D46, 0xFF30514A, 0xFF466760, 0xFF587771, 0xFF4D6C66, 0xFF4B6A64, 0xFF5C716A,
    0xFF344F46, 0xFF638479, 0xFF597F72, 0xFF4C7567, 0xFF385C50, 0xFF4B6B60, 0xFF48635A, 0xFF5C6B68, 0xFF4B5B58, 0xFF60736F, 0xFF7F948F, 0xFF7B908B, 0xFF5A6D69, 0xFF566663, 0xFF465552, 0xFF4A7061, 0xFF587E6F, 0xFF557E6E, 0xFF4B7466, 0xFF315B4D,
    0xFF1A4639, 0xFF0F3D30, 0xFF1B493C, 0xFF326757, 0xFF2F6251, 0xFF2F5B4A, 0xFF2D5743, 0xFF31543E, 0xFF335139, 0xFF304A31, 0xFF2C442A, 0xFF2A4C31, 0xFF305038, 0xFF395640, 0xFF385042, 0xFF3A4E45, 0xFF465552, 0xFF566163, 0xFF6F787D, 0xFF6C7477,
    0xFF676F72, 0xFF4E585A, 0xFF5D686A, 0xFF576566, 0xFF4C5A5B, 0xFF526262, 0xFF5D6F6F, 0xFF5A6567, 0xFF475254, 0xFF596365, 0xFF616B6D, 0xFF4E595B, 0xFF364848, 0xFF243D3A, 0xFF294642, 0xFF697068, 0xFFB0B1A9, 0xFFBAB3AB, 0xFFBFB2AA, 0xFFC8BDB7,
    0xFFC5C5BD, 0xFFA7B4AB, 0xFF899E97, 0xFF6B9A88, 0xFF709486, 0xFF88A496, 0xFFAABAAF, 0xFFC8BDB9, 0xFFC7A9A9, 0xFFB1ADA2, 0xFF5B7E66, 0xFF4F7568, 0xFF527B6B, 0xFF517C69, 0xFF507A66, 0xFF4E7562, 0xFF2F4F42, 0xFF122D26, 0xFF253B38, 0xFF213E3C,
    0xFF22403E, 0xFF244441, 0xFF244743, 0xFF244743, 0xFF264442, 0xFF2A4443, 0xFF2C4444, 0xFF264540, 0xFF294644, 0xFF2A4445, 0xFF284145, 0xFF224042, 0xFF1C3F3B, 0xFF295349, 0xFF427063, 0xFF406C5D, 0xFF3C6B5B, 0xFF366958, 0xFF386B5A, 0xFF3E6A5B,
    0xFF39594E, 0xFF354A43, 0xFF3C4844, 0xFF43544A, 0xFF3C4B44, 0xFF39675A, 0xFF2D6355, 0xFF2F4542, 0xFF40504D, 0xFF2F493E, 0xFF465048, 0xFF34584C, 0xFF265D4A, 0xFF2F5347, 0xFF33443E, 0xFF3C564D, 0xFF344942, 0xFF435D54, 0xFF26614D, 0xFF305647,
    0xFF344B41, 0xFF444F49, 0xFF434C47, 0xFF4C6158, 0xFF3F5D51, 0xFF466659, 0xFF355145, 0xFF4C514B, 0xFF5C7369, 0xFF3D6C5C, 0xFF245947, 0xFF1A4639, 0xFF274640, 0xFF2F4845, 0xFF374D4B, 0xFF384E4B, 0xFF3A4E4C, 0xFF3B4F4D, 0xFF3B4E4C, 0xFF3A4D4B,
    0xFF3C4C4B, 0xFF3D4D4C, 0xFF404E4E, 0xFF384C4D, 0xFF3C5051, 0xFF3A4C4C, 0xFF374B49, 0xFF3A534D, 0xFF537368, 0xFF507669, 0xFF4C7766, 0xFF527C6E, 0xFF527E6F, 0xFF537F70, 0xFF568072, 0xFF527267, 0x00D9ECE6, 0x00FCFFFF, 0x00FFFDFE, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xB3EBC197, 0xFFE1A060, 0xFFF2A056, 0xFFEDA25E, 0xFFEDA664, 0xFFF3A55B, 0xFFF7A55B, 0xFFE69B57, 0xFFE69B58, 0xFFEA9F5C, 0xFFE89D59, 0xFFEBA05C, 0xFFE99E5A,
    0xFFE59B54, 0xFFE89E57, 0xFFE69C55, 0xFFDF995B, 0xFFE29B5B, 0xFFE59B5A, 0xFFE39958, 0xFFE59E5E, 0xFFE29E61, 0xFFC5874C, 0xFFA46730, 0xFF9C6930, 0xFFA16437, 0xFFB17E47, 0xFFCB9857, 0xFFBB8853, 0xFF605A3A, 0xFF31543C, 0xFF2B4431, 0xFF192521,
    0xFF293936, 0xFF243836, 0xFF465F5C, 0xFF253E3B, 0xFF203731, 0xFF243930, 0xFF14281C, 0xFF162C29, 0xFF102422, 0xFF2B3E3C, 0xFF738382, 0xFF808C8C, 0xFF869091, 0xFF7D8587, 0xFF767B7E, 0xFF859096, 0xFF798289, 0xFF7B8489, 0xFF727B80, 0xFF6F777A,
    0xFF878F92, 0xFF989DA0, 0xFF979C9F, 0xFF737B7D, 0xFF233735, 0xFF1A312B, 0xFF192523, 0xFF172A24, 0xFF1C4638, 0xFF255847, 0xFF426C5E, 0xFF426A61, 0xFF2E534B, 0xFF2E534B, 0xFF254A42, 0xFF21443D, 0xFF2F524B, 0xFF2A4B44, 0xFF33544D, 0xFF536D64,
    0xFF4F6D63, 0xFF54786C, 0xFF4D7668, 0xFF396355, 0xFF3F6558, 0xFF305146, 0xFF2A4A3F, 0xFF576E68, 0xFF39524C, 0xFF39544D, 0xFF435E57, 0xFF425D56, 0xFF39544D, 0xFF465F59, 0xFF435A54, 0xFF4B7665, 0xFF537E6D, 0xFF5B8675, 0xFF4F786A, 0xFF365C4F,
    0xFF1B3F35, 0xFF1A3E34, 0xFF25493F, 0xFF275145, 0xFF1E463B, 0xFF163C2F, 0xFF123426, 0xFF0C2B1C, 0xFF082314, 0xFF0A2212, 0xFF0E2515, 0xFF09220F, 0xFF0E2616, 0xFF091F12, 0xFF0F2318, 0xFF374842, 0xFF4B5A57, 0xFF424E4E, 0xFF485355, 0xFF556062,
    0xFF566163, 0xFF475254, 0xFF596466, 0xFF525D5F, 0xFF444F51, 0xFF4A5557, 0xFF586365, 0xFF5F6A6C, 0xFF4C5759, 0xFF5F696B, 0xFF667072, 0xFF535E60, 0xFF394B4B, 0xFF253E3B, 0xFF294642, 0xFF6B7069, 0xFFAEAEA6, 0xFFB3ACA4, 0xFFC4BAB1, 0xFFC6BFB7,
    0xFF9FA59B, 0xFF768A7F, 0xFF628076, 0xFF598473, 0xFF587C6E, 0xFF5E8070, 0xFF80988A, 0xFFB5B2AB, 0xFFCCB4B2, 0xFFAEAA9F, 0xFF5C7E66, 0xFF4F7568, 0xFF527B6B, 0xFF507B68, 0xFF4F7965, 0xFF4E7562, 0xFF2F4F42, 0xFF122D26, 0xFF253B38, 0xFF203D3B,
    0xFF213F3D, 0xFF22423F, 0xFF20433F, 0xFF224541, 0xFF274543, 0xFF2C4645, 0xFF2E4646, 0xFF274440, 0xFF284543, 0xFF294344, 0xFF284145, 0xFF224042, 0xFF1C3F3B, 0xFF285248, 0xFF406F5F, 0xFF3F6B5C, 0xFF3A6959, 0xFF336655, 0xFF376757, 0xFF3C6658,
    0xFF3B5B50, 0xFF3B5049, 0xFF46524E, 0xFF38483E, 0xFF3E4D46, 0xFF325E51, 0xFF2D6355, 0xFF304643, 0xFF3B4B48, 0xFF375146, 0xFF49534B, 0xFF3D5D52, 0xFF306352, 0xFF2D4E43, 0xFF36423E, 0xFF3E534C, 0xFF30413B, 0xFF445952, 0xFF2B624F, 0xFF325648,
    0xFF32493F, 0xFF4A534E, 0xFF434C47, 0xFF51655C, 0xFF4D6B5F, 0xFF4A685C, 0xFF365246, 0xFF4D524C, 0xFF5B7268, 0xFF3C6B5B, 0xFF245947, 0xFF1A4639, 0xFF274640, 0xFF2F4845, 0xFF374D4B, 0xFF354B48, 0xFF374B49, 0xFF394D4B, 0xFF394D4B, 0xFF394C4A,
    0xFF394C4A, 0xFF3C4C4B, 0xFF3D4D4C, 0xFF374B4C, 0xFF3B4F50, 0xFF3A4C4C, 0xFF384C4A, 0xFF3B544E, 0xFF55756A, 0xFF52786B, 0xFF4E7968, 0xFF517B6D, 0xFF517D6E, 0xFF527E6F, 0xFF557F71, 0xFF537368, 0x00DAEDE7, 0x00FCFFFF, 0x00FFFEFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xB7EBC296, 0xFFE09F5F, 0xFFF2A056, 0xFFEDA35C, 0xFFEDA762, 0xFFF3A55B, 0xFFF7A55B, 0xFFE59B54, 0xFFE69B58, 0xFFEA9F5C, 0xFFE79C58, 0xFFEA9F5B, 0xFFE89D59,
    0xFFE39952, 0xFFE69C55, 0xFFE39952, 0xFFE6A062, 0xFFE59E5E, 0xFFE79D5C, 0xFFE49B57, 0xFFE49D5B, 0xFFE29E5F, 0xFFBA7C41, 0xFF85480F, 0xFF693B09, 0xFF723812, 0xFF9E6C3B, 0xFFC69457, 0xFFBA8455, 0xFF635A3B, 0xFF32523B, 0xFF304534, 0xFF424E4A,
    0xFF5C6C69, 0xFF394D4C, 0xFF47605D, 0xFF2F4845, 0xFF223933, 0xFF293E35, 0xFF172B20, 0xFF152B29, 0xFF1D3130, 0xFF384A4A, 0xFF677777, 0xFF7F8A8C, 0xFF8F999B, 0xFF7C8487, 0xFF808589, 0xFF7F8A90, 0xFF767F86, 0xFF7A8388, 0xFF7B8489, 0xFF788083,
    0xFF7F878A, 0xFF92979A, 0xFFA3A8AB, 0xFF8A9294, 0xFF344846, 0xFF223835, 0xFF232F2D, 0xFF1A2D29, 0xFF1B4537, 0xFF215443, 0xFF416B5D, 0xFF49746A, 0xFF3A645A, 0xFF355F55, 0xFF335D53, 0xFF264E45, 0xFF3A6259, 0xFF2B5048, 0xFF375C54, 0xFF416156,
    0xFF4B6F63, 0xFF527B6D, 0xFF315B4D, 0xFF376354, 0xFF345E50, 0xFF456E60, 0xFF466C5F, 0xFF4E7268, 0xFF3A5E54, 0xFF3D6157, 0xFF40645A, 0xFF41655B, 0xFF43675D, 0xFF486C62, 0xFF41655B, 0xFF457865, 0xFF497A67, 0xFF558170, 0xFF466C5F, 0xFF3E5E53,
    0xFF2C453F, 0xFF324742, 0xFF2F423E, 0xFF314F47, 0xFF2F4A43, 0xFF324D46, 0xFF39524E, 0xFF394F4C, 0xFF314543, 0xFF2D413F, 0xFF324543, 0xFF374641, 0xFF31403B, 0xFF293833, 0xFF2A3936, 0xFF3F4E4B, 0xFF4B5A57, 0xFF404E4E, 0xFF404E4E, 0xFF354747,
    0xFF405050, 0xFF3F4F4F, 0xFF586667, 0xFF556062, 0xFF495355, 0xFF50585B, 0xFF64696D, 0xFF596466, 0xFF485355, 0xFF5B6567, 0xFF646E70, 0xFF515C5E, 0xFF374949, 0xFF223B38, 0xFF26433F, 0xFF6D6E68, 0xFFB4B1AA, 0xFFB7B0A8, 0xFFC6BDB4, 0xFFB3B3A9,
    0xFF778578, 0xFF587768, 0xFF547E70, 0xFF547A6B, 0xFF5B8172, 0xFF517A68, 0xFF557A68, 0xFF858F84, 0xFFC6B7B2, 0xFFACAA9E, 0xFF607D67, 0xFF4F7568, 0xFF517A6A, 0xFF4F7A67, 0xFF4F7965, 0xFF4E7562, 0xFF2E4E41, 0xFF122D26, 0xFF263C39, 0xFF1F3C3A,
    0xFF203E3C, 0xFF1F3F3C, 0xFF1C3F3B, 0xFF1F423E, 0xFF294745, 0xFF2F4948, 0xFF2F4747, 0xFF284540, 0xFF2A4441, 0xFF284243, 0xFF284145, 0xFF244041, 0xFF1D403C, 0xFF285246, 0xFF406C5D, 0xFF3F695B, 0xFF3A6959, 0xFF356555, 0xFF376757, 0xFF3D6759,
    0xFF3C5C51, 0xFF40534D, 0xFF4B5753, 0xFF3D4A41, 0xFF45524B, 0xFF366054, 0xFF2E6255, 0xFF344846, 0xFF42514E, 0xFF384F45, 0xFF4E534D, 0xFF3D584F, 0xFF336252, 0xFF2E4940, 0xFF3D4341, 0xFF475651, 0xFF424D49, 0xFF505F5A, 0xFF2C5C4C, 0xFF305446,
    0xFF33483F, 0xFF4C5550, 0xFF484E4A, 0xFF5A6B63, 0xFF597569, 0xFF4D6B5F, 0xFF375146, 0xFF4F544E, 0xFF5A7167, 0xFF3B6A5A, 0xFF235846, 0xFF194538, 0xFF26453F, 0xFF304946, 0xFF374D4B, 0xFF334746, 0xFF354948, 0xFF374B4A, 0xFF374B4A, 0xFF374B4A,
    0xFF364A49, 0xFF364A49, 0xFF374B4A, 0xFF34494A, 0xFF3A4E4F, 0xFF384C4B, 0xFF374B49, 0xFF3B544E, 0xFF56766B, 0xFF53796C, 0xFF507B6A, 0xFF527C6E, 0xFF517D6E, 0xFF517D6E, 0xFF557F71, 0xFF547469, 0x00DCEFE9, 0x00FCFFFF, 0x00FFFEFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xB7EBC296, 0xFFE09F5F, 0xFFF2A054, 0xFFECA25B, 0xFFEDA762, 0xFFF3A55B, 0xFFF7A559, 0xFFE59B54, 0xFFE59A57, 0xFFEA9F5C, 0xFFE79C58, 0xFFEA9F5B, 0xFFE89D59,
    0xFFE49A53, 0xFFE79D56, 0xFFE49A53, 0xFFE29D5C, 0xFFE29B59, 0xFFE69D59, 0xFFE49B57, 0xFFE39C5A, 0xFFE6A263, 0xFFC28447, 0xFF884B12, 0xFF704415, 0xFF78401D, 0xFFA8784A, 0xFFC9975C, 0xFFB47E50, 0xFF62593C, 0xFF36533D, 0xFF374939, 0xFF5A6664,
    0xFF788887, 0xFF455958, 0xFF445C5C, 0xFF354E4B, 0xFF283E3B, 0xFF364B44, 0xFF1F3328, 0xFF1A302E, 0xFF203433, 0xFF384A4A, 0xFF637373, 0xFF747F81, 0xFF7A8486, 0xFF70787B, 0xFF808589, 0xFF788389, 0xFF747D84, 0xFF7C858A, 0xFF879095, 0xFF848C8F,
    0xFF7D8588, 0xFF8D9295, 0xFFAAAFB2, 0xFF98A0A3, 0xFF3A4E4D, 0xFF213734, 0xFF303C3C, 0xFF243733, 0xFF1B4539, 0xFF1A4D3C, 0xFF3E685A, 0xFF457366, 0xFF477568, 0xFF4B796C, 0xFF537F72, 0xFF325E51, 0xFF446E62, 0xFF386256, 0xFF5A8478, 0xFF587E71,
    0xFF527B6D, 0xFF355F51, 0xFF3A6657, 0xFF2E5A4B, 0xFF487465, 0xFF517D6E, 0xFF527E6F, 0xFF528171, 0xFF4E7A6B, 0xFF588274, 0xFF598274, 0xFF598274, 0xFF5C8678, 0xFF5A8677, 0xFF518070, 0xFF4A846E, 0xFF497E6A, 0xFF477664, 0xFF284C40, 0xFF3A544B,
    0xFF485855, 0xFF707978, 0xFF7D8383, 0xFF5D706C, 0xFF5D706E, 0xFF617472, 0xFF657777, 0xFF637577, 0xFF5A6C70, 0xFF53646B, 0xFF516269, 0xFF64696D, 0xFF50585B, 0xFF61696C, 0xFF636D6E, 0xFF4A5656, 0xFF445350, 0xFF435350, 0xFF364643, 0xFF2E4442,
    0xFF394D4C, 0xFF3E5050, 0xFF5B696A, 0xFF5B6567, 0xFF51565A, 0xFF53565B, 0xFF66676C, 0xFF596466, 0xFF475254, 0xFF5C6668, 0xFF656F71, 0xFF535E60, 0xFF3B4D4D, 0xFF28413E, 0xFF2C4945, 0xFF6C6B66, 0xFFB9B4AE, 0xFFBBB4AC, 0xFFC1BAB0, 0xFF9CA296,
    0xFF627969, 0xFF547D6B, 0xFF508573, 0xFF5B7F71, 0xFF5E8475, 0xFF558470, 0xFF4B7B65, 0xFF627768, 0xFFB7AEA7, 0xFFACAA9E, 0xFF67806B, 0xFF507669, 0xFF507969, 0xFF4E7966, 0xFF4F7965, 0xFF4E7562, 0xFF2E4E41, 0xFF122D26, 0xFF273D3A, 0xFF1E3B39,
    0xFF203E3C, 0xFF1F3F3C, 0xFF1A3D39, 0xFF1D403C, 0xFF284644, 0xFF2E4847, 0xFF2D4545, 0xFF294641, 0xFF2B4542, 0xFF2A4242, 0xFF2B4345, 0xFF264243, 0xFF22423D, 0xFF2A5247, 0xFF3F6B5C, 0xFF406A5C, 0xFF3E6A5B, 0xFF396959, 0xFF3B6B5B, 0xFF3F695B,
    0xFF3D5D52, 0xFF3F524C, 0xFF4B5652, 0xFF465248, 0xFF4A544C, 0xFF396254, 0xFF2E5E50, 0xFF384845, 0xFF4D5955, 0xFF34483D, 0xFF52554E, 0xFF3A4F46, 0xFF234C3C, 0xFF32473E, 0xFF454744, 0xFF414C46, 0xFF444A46, 0xFF47524C, 0xFF2A5645, 0xFF315345,
    0xFF41554C, 0xFF505652, 0xFF484D49, 0xFF586961, 0xFF556F64, 0xFF577367, 0xFF3C5349, 0xFF535852, 0xFF5A7167, 0xFF396858, 0xFF235846, 0xFF184437, 0xFF26453F, 0xFF304946, 0xFF374D4B, 0xFF314544, 0xFF334746, 0xFF344A48, 0xFF354B49, 0xFF334947,
    0xFF324846, 0xFF314745, 0xFF2F4845, 0xFF304546, 0xFF354A4B, 0xFF364A49, 0xFF344A47, 0xFF39544D, 0xFF54756A, 0xFF517A6C, 0xFF507C6B, 0xFF547E70, 0xFF527E6F, 0xFF517D6E, 0xFF557F71, 0xFF537368, 0x00DBEEE8, 0x00FCFFFF, 0x00FFFEFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xBAEAC193, 0xFFE09F5D, 0xFFF19F53, 0xFFECA259, 0xFFECA661, 0xFFF3A55A, 0xFFF7A559, 0xFFE59B52, 0xFFE59A57, 0xFFEA9F5C, 0xFFE89D59, 0xFFEBA05C, 0xFFEA9F5B,
    0xFFE69C55, 0xFFEAA059, 0xFFE79D56, 0xFFE29D5C, 0xFFE39C5A, 0xFFE89F5B, 0xFFE69D58, 0xFFE49E59, 0xFFE4A061, 0xFFBD7F42, 0xFF83460D, 0xFF744615, 0xFF753B16, 0xFFA26F42, 0xFFC49257, 0xFFB37D4F, 0xFF635A3D, 0xFF365641, 0xFF394E3F, 0xFF54605E,
    0xFF6E7E7D, 0xFF4D6162, 0xFF536B6B, 0xFF425A5A, 0xFF273D3A, 0xFF394E47, 0xFF2D4138, 0xFF24393A, 0xFF15292A, 0xFF2E4042, 0xFF707F82, 0xFF7A8589, 0xFF70797E, 0xFF71787E, 0xFF767B81, 0xFF778288, 0xFF757E85, 0xFF778085, 0xFF818A8F, 0xFF80888B,
    0xFF777F82, 0xFF8A8F92, 0xFFA8ADB0, 0xFF8E9699, 0xFF334746, 0xFF1A302E, 0xFF384444, 0xFF283B39, 0xFF1D473B, 0xFF1C4F40, 0xFF467064, 0xFF49796B, 0xFF4A7A6C, 0xFF4C7A6D, 0xFF538174, 0xFF2C584B, 0xFF386457, 0xFF2F5B4E, 0xFF5F897D, 0xFF557F71,
    0xFF4B7567, 0xFF2A5446, 0xFF3F695B, 0xFF3B6557, 0xFF548071, 0xFF568575, 0xFF518171, 0xFF508070, 0xFF558172, 0xFF5B8476, 0xFF5F8377, 0xFF5A7E72, 0xFF5A8375, 0xFF5A8677, 0xFF598979, 0xFF4E8570, 0xFF4F8470, 0xFF4B7766, 0xFF284C40, 0xFF3A544B,
    0xFF495855, 0xFF828B8A, 0xFFACB0B1, 0xFFA2B5B1, 0xFFA7BAB6, 0xFFA4B7B5, 0xFF95A7A7, 0xFF809294, 0xFF6D7F81, 0xFF5D6F73, 0xFF53646B, 0xFF53585C, 0xFF4E5659, 0xFF747C7F, 0xFF798384, 0xFF525E5E, 0xFF4B5A57, 0xFF465653, 0xFF283835, 0xFF2D4341,
    0xFF344847, 0xFF3A4C4C, 0xFF586667, 0xFF5B6567, 0xFF54595D, 0xFF515459, 0xFF626368, 0xFF5A6567, 0xFF475254, 0xFF5A6466, 0xFF636D6F, 0xFF515C5E, 0xFF3A4C4C, 0xFF28413E, 0xFF2D4A46, 0xFF706D68, 0xFFB4AFA9, 0xFFB9B0A9, 0xFFBCB8AD, 0xFF91978B,
    0xFF5B7363, 0xFF537E6B, 0xFF487F6C, 0xFF608274, 0xFF4C7263, 0xFF4E7F6A, 0xFF4D816A, 0xFF597161, 0xFFAEA79F, 0xFFACAA9E, 0xFF69806C, 0xFF507669, 0xFF4F7868, 0xFF4D7865, 0xFF4F7965, 0xFF4E7562, 0xFF2D4D40, 0xFF122D26, 0xFF283E3B, 0xFF1F3C3A,
    0xFF203E3C, 0xFF1F3F3C, 0xFF1B3E3A, 0xFF1D403C, 0xFF254341, 0xFF2A4443, 0xFF2A4242, 0xFF2D4841, 0xFF2E4744, 0xFF2D4545, 0xFF2E4648, 0xFF2C4645, 0xFF24443F, 0xFF2B5446, 0xFF416C5B, 0xFF426B5D, 0xFF406C5D, 0xFF3C6B5B, 0xFF3D6C5C, 0xFF40695B,
    0xFF3E5C52, 0xFF43544E, 0xFF4F5A56, 0xFF576158, 0xFF676E67, 0xFF3A5E52, 0xFF346255, 0xFF3F4E4B, 0xFF4E5754, 0xFF4C5D53, 0xFF70716B, 0xFF4F635A, 0xFF204637, 0xFF40544B, 0xFF535250, 0xFF4F5551, 0xFF6E706D, 0xFF585E5A, 0xFF2D5646, 0xFF2F4F42,
    0xFF475850, 0xFF515652, 0xFF6B6D6A, 0xFF72817A, 0xFF465D53, 0xFF516B60, 0xFF3F544B, 0xFF595E58, 0xFF5B7268, 0xFF386757, 0xFF235846, 0xFF174336, 0xFF26453F, 0xFF314A47, 0xFF364C4A, 0xFF324647, 0xFF344849, 0xFF34494A, 0xFF324A4A, 0xFF2F4747,
    0xFF2B4544, 0xFF294342, 0xFF274442, 0xFF2B4343, 0xFF334849, 0xFF324846, 0xFF324845, 0xFF38534C, 0xFF54756A, 0xFF517A6C, 0xFF4F7B6A, 0xFF557F71, 0xFF548071, 0xFF527E6F, 0xFF557F71, 0xFF527267, 0x00D9ECE6, 0x00FCFFFF, 0x00FFFDFE, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xBAEAC193, 0xFFE09F5D, 0xFFF1A051, 0xFFECA259, 0xFFECA660, 0xFFF2A459, 0xFFF6A556, 0xFFE59B52, 0xFFE69B58, 0xFFEA9F5C, 0xFFE99E5A, 0xFFECA15D, 0xFFEBA05C,
    0xFFE79D56, 0xFFEBA15A, 0xFFE99F58, 0xFFEDA865, 0xFFE9A35E, 0xFFE89F5A, 0xFFE69D58, 0xFFE59F5A, 0xFFE39F5E, 0xFFC08344, 0xFF93571B, 0xFF86511B, 0xFF814217, 0xFF9E6937, 0xFFC28F50, 0xFFB68252, 0xFF605B3E, 0xFF2D5240, 0xFF2B4538, 0xFF556161,
    0xFF677777, 0xFF4F6364, 0xFF486062, 0xFF3E5656, 0xFF2E4442, 0xFF445954, 0xFF3F534A, 0xFF1D3233, 0xFF263A3B, 0xFF253739, 0xFF4A595C, 0xFF737E82, 0xFF7C858A, 0xFF798086, 0xFF7C8187, 0xFF747F85, 0xFF747D84, 0xFF6F787D, 0xFF737C81, 0xFF767E81,
    0xFF788083, 0xFF8E9396, 0xFFA0A5A8, 0xFF6D747A, 0xFF344847, 0xFF2C4240, 0xFF4B5658, 0xFF2D403E, 0xFF254F45, 0xFF245748, 0xFF4B7569, 0xFF4D7C6C, 0xFF4A7969, 0xFF487767, 0xFF507C6D, 0xFF325E4F, 0xFF3D6759, 0xFF2F594B, 0xFF578173, 0xFF517D6E,
    0xFF4D7769, 0xFF3F6558, 0xFF365C4F, 0xFF4C7265, 0xFF4E786A, 0xFF568575, 0xFF497969, 0xFF3D6857, 0xFF456B5C, 0xFF476559, 0xFF567065, 0xFF506A5F, 0xFF436155, 0xFF416758, 0xFF477261, 0xFF4F806D, 0xFF4E7D6B, 0xFF547F6E, 0xFF4B6F63, 0xFF506B62,
    0xFF3F5650, 0xFF5A6A67, 0xFF7B8A87, 0xFF67857B, 0xFF79948B, 0xFF809B92, 0xFF779188, 0xFF6B827A, 0xFF667B74, 0xFF637871, 0xFF61746E, 0xFF667570, 0xFF92A19C, 0xFFB2C1BC, 0xFF899895, 0xFF495855, 0xFF384744, 0xFF3E4C4C, 0xFF425050, 0xFF324444,
    0xFF364646, 0xFF3B4B4B, 0xFF566465, 0xFF5C6769, 0xFF566062, 0xFF51595C, 0xFF62676B, 0xFF5C6769, 0xFF485355, 0xFF5A6466, 0xFF616B6D, 0xFF4E595B, 0xFF354747, 0xFF233C39, 0xFF284541, 0xFF6F6E69, 0xFFB0ABA5, 0xFFBCB3AC, 0xFFC3BCB2, 0xFF93968B,
    0xFF556C5C, 0xFF4E7765, 0xFF538675, 0xFF5F8173, 0xFF55796B, 0xFF54836F, 0xFF43745E, 0xFF536859, 0xFFACA39C, 0xFFB2AEA3, 0xFF667D69, 0xFF507669, 0xFF4E7767, 0xFF4C7764, 0xFF4F7965, 0xFF4D7461, 0xFF2C4C3F, 0xFF122D26, 0xFF2A403D, 0xFF203D3B,
    0xFF1F3D3B, 0xFF1F3F3C, 0xFF1C3F3B, 0xFF1C3F3B, 0xFF203E3C, 0xFF26403F, 0xFF2A4242, 0xFF2E4942, 0xFF304945, 0xFF324748, 0xFF334849, 0xFF2D4746, 0xFF26453F, 0xFF2E5447, 0xFF426D5C, 0xFF446D5F, 0xFF416B5D, 0xFF3B6A5A, 0xFF3A6959, 0xFF3D6658,
    0xFF3F5D53, 0xFF4A5B55, 0xFF5B6461, 0xFFB7BDB3, 0xFFBEC3BD, 0xFF4B6D5F, 0xFF3C665A, 0xFF434F4D, 0xFF555B57, 0xFF96A69C, 0xFFD3D0C9, 0xFF5F7368, 0xFF294E3D, 0xFF43574C, 0xFF504F4B, 0xFF767D76, 0xFFD4D6D1, 0xFF8E958E, 0xFF1F4836, 0xFF3E5C50,
    0xFF44534C, 0xFF646663, 0xFFC4C6C3, 0xFFC6D3CC, 0xFF475C53, 0xFF435A50, 0xFF4F635A, 0xFF5F645E, 0xFF5C7369, 0xFF396858, 0xFF245947, 0xFF174336, 0xFF25443E, 0xFF314A47, 0xFF364C4A, 0xFF344849, 0xFF35494A, 0xFF34494A, 0xFF304848, 0xFF2C4645,
    0xFF274442, 0xFF244240, 0xFF234340, 0xFF2A4242, 0xFF314647, 0xFF314745, 0xFF304945, 0xFF35534B, 0xFF517569, 0xFF507A6C, 0xFF4D7C6A, 0xFF557F71, 0xFF548071, 0xFF548071, 0xFF557F71, 0xFF507065, 0x00D6E9E3, 0x00FBFFFE, 0x00FFFDFE, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xBAEAC193, 0xFFDF9E5A, 0xFFF1A051, 0xFFECA257, 0xFFECA660, 0xFFF2A557, 0xFFF6A556, 0xFFE49A4F, 0xFFE79C59, 0xFFEBA05D, 0xFFE99E5A, 0xFFECA15D, 0xFFEBA05C,
    0xFFE79D56, 0xFFEAA059, 0xFFE89E57, 0xFFE9A461, 0xFFE6A05B, 0xFFE49B56, 0xFFE49B56, 0xFFE7A15C, 0xFFE7A362, 0xFFD79A5B, 0xFFC4884C, 0xFFC28848, 0xFFC3804C, 0xFFC48C53, 0xFFC79250, 0xFFAE7C49, 0xFF5A593B, 0xFF2C5744, 0xFF214237, 0xFF263232,
    0xFF354545, 0xFF2B3F40, 0xFF1B3335, 0xFF223A3C, 0xFF253B39, 0xFF3F544F, 0xFF50645B, 0xFF516669, 0xFF697C80, 0xFF627478, 0xFF516065, 0xFF69747A, 0xFF808990, 0xFF7B828A, 0xFF80848D, 0xFF778288, 0xFF7E878E, 0xFF798287, 0xFF798287, 0xFF7D8588,
    0xFF858D90, 0xFF92979A, 0xFF8A8F92, 0xFF585F65, 0xFF536768, 0xFF5F7573, 0xFF677274, 0xFF2D3F3F, 0xFF2D574D, 0xFF2F6155, 0xFF4B756B, 0xFF477364, 0xFF517B6D, 0xFF588274, 0xFF517B6D, 0xFF345D4F, 0xFF3C6557, 0xFF375D50, 0xFF5E8477, 0xFF588274,
    0xFF4C7567, 0xFF305448, 0xFF416156, 0xFF416257, 0xFF62887B, 0xFF558172, 0xFF417161, 0xFF37594B, 0xFF415B50, 0xFF3F5048, 0xFF626D67, 0xFF5F6A64, 0xFF3F5048, 0xFF354F44, 0xFF385A4C, 0xFF597F70, 0xFF507667, 0xFF567C6D, 0xFF5A7E72, 0xFF4C6D62,
    0xFF38574F, 0xFF3A5951, 0xFF426159, 0xFF345F4E, 0xFF376050, 0xFF355C4A, 0xFF2C4E3D, 0xFF254432, 0xFF284330, 0xFF2E4732, 0xFF314834, 0xFF253E2B, 0xFF2E4636, 0xFF243A2D, 0xFF172B20, 0xFF354640, 0xFF4F5E5B, 0xFF475353, 0xFF414C4E, 0xFF434E50,
    0xFF434E50, 0xFF485355, 0xFF5D686A, 0xFF5C6769, 0xFF545F61, 0xFF4C5759, 0xFF5C6769, 0xFF616C6E, 0xFF4E595B, 0xFF616B6D, 0xFF687274, 0xFF545F61, 0xFF3B4D4D, 0xFF27403D, 0xFF2C4945, 0xFF6E6D68, 0xFFB1ACA6, 0xFFBEB5AE, 0xFFC7BEB5, 0xFFA4A49A,
    0xFF637366, 0xFF4A6A5B, 0xFF537F70, 0xFF557769, 0xFF587C6E, 0xFF4B7663, 0xFF345E4A, 0xFF69776A, 0xFFB8A9A4, 0xFFB0ACA1, 0xFF657E69, 0xFF507669, 0xFF4D7666, 0xFF4B7663, 0xFF4E7864, 0xFF4D7461, 0xFF2C4C3F, 0xFF112C25, 0xFF2A403D, 0xFF223F3D,
    0xFF1E3C3A, 0xFF1D3D3A, 0xFF1C3F3B, 0xFF1A3D39, 0xFF1B3937, 0xFF243E3D, 0xFF2E4646, 0xFF2D4640, 0xFF304945, 0xFF344A48, 0xFF34494A, 0xFF2E4744, 0xFF25443E, 0xFF2D5346, 0xFF426D5A, 0xFF426B5D, 0xFF416B5D, 0xFF3D695A, 0xFF3C6859, 0xFF3F6558,
    0xFF425D54, 0xFF4D5E58, 0xFF606966, 0xFFE7EAE1, 0xFFDCDFD8, 0xFF517164, 0xFF396254, 0xFF45504C, 0xFF626763, 0xFFABB8AE, 0xFFF8F3ED, 0xFF667A6F, 0xFF406755, 0xFF55695E, 0xFF5E5F5A, 0xFF8B958D, 0xFFF2F7F1, 0xFFA3ADA5, 0xFF2E5946, 0xFF526E62,
    0xFF4E5D56, 0xFF71716F, 0xFFD6D6D4, 0xFFD5E0DA, 0xFF4B6057, 0xFF465B52, 0xFF5F736A, 0xFF646963, 0xFF5E756B, 0xFF396858, 0xFF255A48, 0xFF174336, 0xFF25443E, 0xFF314A47, 0xFF354B49, 0xFF35484C, 0xFF35484C, 0xFF33484B, 0xFF2E4849, 0xFF294546,
    0xFF244443, 0xFF214342, 0xFF214342, 0xFF2B4343, 0xFF304848, 0xFF324846, 0xFF314A46, 0xFF36544C, 0xFF52766A, 0xFF517B6D, 0xFF4F7E6C, 0xFF537D6F, 0xFF537F70, 0xFF548071, 0xFF547E70, 0xFF4E6E63, 0x00D4E7E1, 0x00FAFEFD, 0x00FFFEFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xBAEAC193, 0xFFDF9E5A, 0xFFF1A051, 0xFFEBA156, 0xFFECA660, 0xFFF2A557, 0xFFF6A556, 0xFFE49A4F, 0xFFE89D5A, 0xFFECA15E, 0xFFE99E5A, 0xFFECA15D, 0xFFEA9F5B,
    0xFFE59B54, 0xFFE89E57, 0xFFE69C55, 0xFFE49F5C, 0xFFE7A15C, 0xFFE9A05B, 0xFFE8A058, 0xFFE59F59, 0xFFE09C5B, 0xFFDA9D5E, 0xFFDCA064, 0xFFD5964F, 0xFFE6A065, 0xFFD19758, 0xFFAE7933, 0xFF8C5A25, 0xFF484B2E, 0xFF2D5C4A, 0xFF1F453A, 0xFF475353,
    0xFF4F5F5F, 0xFF54676B, 0xFF455D5F, 0xFF3E5658, 0xFF203634, 0xFF2C413C, 0xFF5D706A, 0xFF576C6F, 0xFF506367, 0xFF809296, 0xFF7A898E, 0xFF586369, 0xFF707980, 0xFF868D95, 0xFF858992, 0xFF828D93, 0xFF9099A0, 0xFF90999E, 0xFF8E979C, 0xFF8E9699,
    0xFF929A9D, 0xFF8F9497, 0xFF6E7376, 0xFF5C6369, 0xFF7A8E8F, 0xFF8DA2A3, 0xFF778284, 0xFF243636, 0xFF2D574D, 0xFF386A5E, 0xFF4F796F, 0xFF527C6E, 0xFF547D6F, 0xFF4F786A, 0xFF3B6456, 0xFF294F42, 0xFF385E51, 0xFF315549, 0xFF4B6F63, 0xFF537D6F,
    0xFF33594C, 0xFF416156, 0xFF426056, 0xFF415F55, 0xFF4A6E62, 0xFF5B8577, 0xFF3C6B5B, 0xFF405A4F, 0xFF50645B, 0xFF58615C, 0xFF929491, 0xFF929491, 0xFF5D6661, 0xFF41554C, 0xFF3A5449, 0xFF59796C, 0xFF527466, 0xFF5C7E70, 0xFF567A6E, 0xFF2D5346,
    0xFF20483D, 0xFF204A3E, 0xFF164034, 0xFF174C38, 0xFF10442E, 0xFF0C3922, 0xFF0C361E, 0xFF12361C, 0xFF153317, 0xFF142E11, 0xFF10290B, 0xFF0E3015, 0xFF103018, 0xFF07240E, 0xFF0D2517, 0xFF354940, 0xFF495855, 0xFF3E494B, 0xFF434C51, 0xFF40484B,
    0xFF434B4E, 0xFF495355, 0xFF5C6769, 0xFF586667, 0xFF515F60, 0xFF495959, 0xFF5B6D6D, 0xFF5D686A, 0xFF4B5658, 0xFF5F696B, 0xFF687274, 0xFF556062, 0xFF3B4D4D, 0xFF28413E, 0xFF2B4844, 0xFF6E6F69, 0xFFB0ADA6, 0xFFB8AFA8, 0xFFC6BCB3, 0xFFBDBAB1,
    0xFF7D897D, 0xFF3D594B, 0xFF33594C, 0xFF44685A, 0xFF3C5E50, 0xFF244B39, 0xFF315342, 0xFF99A196, 0xFFC9B7B3, 0xFFA8A197, 0xFF6A836E, 0xFF507669, 0xFF4D7666, 0xFF4A7562, 0xFF4E7864, 0xFF4D7461, 0xFF2B4B3E, 0xFF112C25, 0xFF2B413E, 0xFF23403E,
    0xFF1D3B39, 0xFF1B3B38, 0xFF1C3F3B, 0xFF193C38, 0xFF183634, 0xFF243E3D, 0xFF324A4A, 0xFF2C453F, 0xFF324845, 0xFF344A48, 0xFF34494A, 0xFF2D4643, 0xFF23423C, 0xFF2C5245, 0xFF436C5A, 0xFF42685B, 0xFF416B5D, 0xFF3F6B5C, 0xFF406C5D, 0xFF42685B,
    0xFF435E55, 0xFF4D5C57, 0xFF5E6764, 0xFF8A8D84, 0xFF868781, 0xFF3A584C, 0xFF386153, 0xFF505956, 0xFF616360, 0xFF5D695F, 0xFF98938D, 0xFF4B6155, 0xFF355E4C, 0xFF546A5E, 0xFF5E605B, 0xFF58635B, 0xFF868D86, 0xFF5D675F, 0xFF3A6753, 0xFF496559,
    0xFF58655E, 0xFF5E5E5C, 0xFF7B7A78, 0xFF79847E, 0xFF374B42, 0xFF4B6057, 0xFF56675F, 0xFF676C66, 0xFF5F766C, 0xFF3A6959, 0xFF255A48, 0xFF174336, 0xFF25443E, 0xFF314A47, 0xFF344A48, 0xFF34474B, 0xFF34474B, 0xFF33484B, 0xFF2D4748, 0xFF274545,
    0xFF244443, 0xFF224443, 0xFF224644, 0xFF2C4444, 0xFF324A4A, 0xFF314A47, 0xFF324B47, 0xFF38564E, 0xFF54786C, 0xFF527C6E, 0xFF507F6D, 0xFF507A6C, 0xFF527E6F, 0xFF537F70, 0xFF547E70, 0xFF4D6D62, 0x00D3E6E0, 0x00FBFFFE, 0x00FFFEFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xBAEBC294, 0xFFE2A15D, 0xFFF3A253, 0xFFEDA35A, 0xFFECA661, 0xFFF2A45A, 0xFFF7A55B, 0xFFE79C58, 0xFFE99E5A, 0xFFEA9F5B, 0xFFECA15D, 0xFFEBA05C, 0xFFEA9F5B,
    0xFFE99E5A, 0xFFE99E5A, 0xFFE99E5A, 0xFFEBA162, 0xFFE99E5A, 0xFFE89E55, 0xFFE39B4F, 0xFFE8A25A, 0xFFE6A467, 0xFFC38755, 0xFFA46B40, 0xFF946B3D, 0xFF8F6F46, 0xFF726240, 0xFF4E4E34, 0xFF1D2C17, 0xFF142D1A, 0xFF486755, 0xFF30533F, 0xFF636361,
    0xFF85898A, 0xFF889294, 0xFF7B8A8D, 0xFF53666A, 0xFF293D3E, 0xFF283A3A, 0xFF617472, 0xFF7D8587, 0xFF707A7B, 0xFF647070, 0xFF303E3F, 0xFF263838, 0xFF4A5F60, 0xFF667E7E, 0xFF6A8282, 0xFF797D80, 0xFF969A9D, 0xFFBABBBF, 0xFFA5A9AC, 0xFF91999B,
    0xFF768685, 0xFF4E6461, 0xFF26413C, 0xFF5A5F62, 0xFF737D7E, 0xFFA3B1B1, 0xFF364B46, 0xFF2E4942, 0xFF4D6E65, 0xFF476D60, 0xFF517A6C, 0xFF517C6B, 0xFF517D6C, 0xFF557E6E, 0xFF203C30, 0xFF323F38, 0xFF535E58, 0xFF3D544A, 0xFF3E6254, 0xFF527668,
    0xFF374E44, 0xFF79847E, 0xFF65726B, 0xFF445E53, 0xFF446A5B, 0xFF547D6D, 0xFF517567, 0xFF6E6D51, 0xFF988A67, 0xFF947D5B, 0xFF958063, 0xFF927855, 0xFF947B52, 0xFF7C7D5E, 0xFF426358, 0xFF4C7867, 0xFF537E6D, 0xFF547A6B, 0xFF37594B, 0xFF4A685C,
    0xFF445E53, 0xFF3F564C, 0xFF253A31, 0xFF324B47, 0xFF38534E, 0xFF38534E, 0xFF385550, 0xFF375650, 0xFF2C4B45, 0xFF24453E, 0xFF24453E, 0xFF3F4B49, 0xFF4E5A58, 0xFF394543, 0xFF394545, 0xFF434D4E, 0xFF485254, 0xFF434D4F, 0xFF475153, 0xFF3E4A48,
    0xFF414D4B, 0xFF4B5554, 0xFF5B6564, 0xFF5F6968, 0xFF515A59, 0xFF4F5857, 0xFF616A69, 0xFF566465, 0xFF4B595A, 0xFF5B6B6B, 0xFF637575, 0xFF516564, 0xFF394F4D, 0xFF2E4442, 0xFF304946, 0xFF74736F, 0xFFB0ACA9, 0xFFBBB3B0, 0xFFC3B9B7, 0xFFC4BBB6,
    0xFFBDB6B0, 0xFF928F86, 0xFF57594E, 0xFF3F4537, 0xFF3D4536, 0xFF61695A, 0xFF9D9D91, 0xFFB9AFA6, 0xFFBBB1A8, 0xFFA3A799, 0xFF6D806D, 0xFF517A68, 0xFF537C6A, 0xFF517866, 0xFF557769, 0xFF567669, 0xFF2E4C42, 0xFF0F2A21, 0xFF284239, 0xFF1C443C,
    0xFF20403B, 0xFF203935, 0xFF2C3C39, 0xFF333C39, 0xFF727675, 0xFFBEC0BD, 0xFFC5C7C2, 0xFF4F6562, 0xFF293F3D, 0xFF2A4242, 0xFF2B4748, 0xFF2A4848, 0xFF21413C, 0xFF30544A, 0xFF476D5E, 0xFF4B695D, 0xFF527466, 0xFF426B5B, 0xFF416C5B, 0xFF406657,
    0xFF4C665B, 0xFF5C6761, 0xFF545653, 0xFF363B35, 0xFF384C41, 0xFF426756, 0xFF365F4D, 0xFF426253, 0xFF586E62, 0xFF374D41, 0xFF344C3F, 0xFF365D4B, 0xFF425C4F, 0xFF48534B, 0xFF707B73, 0xFF3F5549, 0xFF254536, 0xFF395B4B, 0xFF456455, 0xFF2A4F3E,
    0xFF64756B, 0xFF696B66, 0xFF3C4940, 0xFF2F5443, 0xFF3E6B57, 0xFF355445, 0xFF5B655D, 0xFF7F7E7A, 0xFF5C6D65, 0xFF446D5F, 0xFF255545, 0xFF22483D, 0xFF304945, 0xFF3D4F4F, 0xFF384848, 0xFF344C4E, 0xFF2E4648, 0xFF3C5154, 0xFF283C3D, 0xFF2D4243,
    0xFF284241, 0xFF1E3E39, 0xFF1D403A, 0xFF26453D, 0xFF314F47, 0xFF36514A, 0xFF3E584F, 0xFF3E584F, 0xFF557165, 0xFF5C7C6F, 0xFF54786A, 0xFF5A7E70, 0xFF597F70, 0xFF5A8373, 0xFF5C8273, 0xFF4E6C60, 0x00D5E6DE, 0x00FEFFFD, 0x00FFFDFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xBAEBC294, 0xFFE2A15D, 0xFFF4A354, 0xFFEDA35A, 0xFFECA661, 0xFFF2A45A, 0xFFF7A55B, 0xFFE79C58, 0xFFE99E5A, 0xFFEBA05C, 0xFFECA15D, 0xFFEBA05C, 0xFFEA9F5B,
    0xFFE99E5A, 0xFFE99E5A, 0xFFEA9F5B, 0xFFE89E5F, 0xFFE79C58, 0xFFEAA057, 0xFFE8A054, 0xFFE9A35B, 0xFFDF9D60, 0xFFB67A46, 0xFF955C2F, 0xFF847268, 0xFF71645B, 0xFF4E4B44, 0xFF373D39, 0xFF1F2E2B, 0xFF223531, 0xFF506761, 0xFF354C44, 0xFF3C423E,
    0xFF65706C, 0xFF839392, 0xFF6A7E7F, 0xFF385050, 0xFF536B6B, 0xFF6C827F, 0xFF576C67, 0xFF515D5D, 0xFF738181, 0xFF566464, 0xFF1D2D2D, 0xFF223232, 0xFF243636, 0xFF36484A, 0xFF4D6162, 0xFF526664, 0xFF728583, 0xFF859393, 0xFF697575, 0xFF5B6767,
    0xFF3F4D4D, 0xFF213432, 0xFF1A2E2C, 0xFF4A5254, 0xFF8C9898, 0xFF566665, 0xFF1F342F, 0xFF58736C, 0xFF4F7065, 0xFF547A6D, 0xFF588173, 0xFF588372, 0xFF54806F, 0xFF517A6A, 0xFF365246, 0xFF637069, 0xFF7C8781, 0xFF52695F, 0xFF3D6153, 0xFF55796B,
    0xFF42594F, 0xFF929D97, 0xFF8C9992, 0xFF4A6459, 0xFF446A5B, 0xFF5D8676, 0xFF486C5E, 0xFF777657, 0xFFAB9B77, 0xFFAA946F, 0xFFAB9474, 0xFFAC926D, 0xFFB59D71, 0xFF919270, 0xFF446658, 0xFF578372, 0xFF537E6D, 0xFF517567, 0xFF314F43, 0xFF475E54,
    0xFF42514A, 0xFF707B75, 0xFF7D8681, 0xFF5E7270, 0xFF627674, 0xFF5D716F, 0xFF596D6B, 0xFF586C6A, 0xFF516563, 0xFF465A58, 0xFF3F5552, 0xFF485855, 0xFF647370, 0xFF697875, 0xFF687676, 0xFF525E5E, 0xFF485355, 0xFF454F51, 0xFF434D4F, 0xFF445252,
    0xFF3E4C4C, 0xFF485454, 0xFF5E6A6A, 0xFF667071, 0xFF555F60, 0xFF545C5E, 0xFF6A7274, 0xFF616C6E, 0xFF495456, 0xFF435152, 0xFF465656, 0xFF3F5151, 0xFF324645, 0xFF293F3D, 0xFF314745, 0xFF6F6E6A, 0xFFB1ADAA, 0xFFBFB7B4, 0xFFBFB5B3, 0xFFBCB3AE,
    0xFFC1BAB4, 0xFFBFBCB3, 0xFFB5B5AB, 0xFFB4B6A9, 0xFFADB3A5, 0xFFB2B8AA, 0xFFC0BCB1, 0xFFC3B6AE, 0xFFC6B9B1, 0xFFA8AA9D, 0xFF657664, 0xFF517A68, 0xFF537C6A, 0xFF517866, 0xFF547668, 0xFF557568, 0xFF2E4C42, 0xFF0F2A21, 0xFF29433A, 0xFF194139,
    0xFF1F3F3A, 0xFF27403C, 0xFF2D3C39, 0xFF9FA8A5, 0xFFFCFFFF, 0xFFFCFFFD, 0xFFC6C8C3, 0xFF455B58, 0xFF2B413F, 0xFF2C4444, 0xFF2B4546, 0xFF284646, 0xFF20403B, 0xFF2E5248, 0xFF486E5F, 0xFF47695B, 0xFF4D7364, 0xFF45705F, 0xFF497463, 0xFF426658,
    0xFF485F55, 0xFF6D7671, 0xFF61615F, 0xFF2F362F, 0xFF34453B, 0xFF425E50, 0xFF3C584A, 0xFF63746A, 0xFF69736B, 0xFF323D35, 0xFF304137, 0xFF355A49, 0xFF485C51, 0xFF595E58, 0xFF797A75, 0xFF536057, 0xFF2A4235, 0xFF365244, 0xFF4A6457, 0xFF45564C,
    0xFF767873, 0xFF6D6966, 0xFF343E36, 0xFF284839, 0xFF4C7361, 0xFF546A5E, 0xFF73746F, 0xFF8A8985, 0xFF4C5D55, 0xFF3C6557, 0xFF295949, 0xFF20463B, 0xFF2A433F, 0xFF394B4B, 0xFF384848, 0xFF2D4746, 0xFF3A5252, 0xFF324645, 0xFF354747, 0xFF586A6A,
    0xFF263A38, 0xFF102925, 0xFF122D28, 0xFF253C36, 0xFF354A45, 0xFF364B46, 0xFF3A4F48, 0xFF3F564E, 0xFF5C786C, 0xFF618375, 0xFF567C6D, 0xFF5A7E70, 0xFF597F70, 0xFF5A8373, 0xFF5C8273, 0xFF4E6C60, 0x00D5E6DE, 0x00FDFFFC, 0x00FFFDFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xBAEBC294, 0xFFE1A05C, 0xFFF4A354, 0xFFEEA45B, 0xFFEDA762, 0xFFF3A55B, 0xFFF8A65C, 0xFFE79C58, 0xFFEA9F5B, 0xFFEBA05C, 0xFFECA15D, 0xFFECA15D, 0xFFEA9F5B,
    0xFFE99E5A, 0xFFE99E5A, 0xFFEA9F5B, 0xFFEAA05F, 0xFFE99E5A, 0xFFECA259, 0xFFE8A056, 0xFFE7A15B, 0xFFE09F5F, 0xFFC58A52, 0xFFB37B4A, 0xFFAC8252, 0xFF9D7B4D, 0xFF866F46, 0xFF6E6546, 0xFF49533B, 0xFF334B3B, 0xFF4A6F67, 0xFF2F5C55, 0xFF233329,
    0xFF354940, 0xFF3C5551, 0xFF2A4743, 0xFF395755, 0xFF93B2AD, 0xFFA4C1BC, 0xFF5A756C, 0xFF3D524D, 0xFF405550, 0xFF7B8E8C, 0xFF667675, 0xFF313F40, 0xFF243233, 0xFF293436, 0xFF293438, 0xFF284741, 0xFF223D38, 0xFF425855, 0xFF748483, 0xFF7E8A8A,
    0xFF455151, 0xFF2C3A3A, 0xFF50605F, 0xFF9DA9A9, 0xFF647272, 0xFF2B3E3A, 0xFF3A534D, 0xFF5A786E, 0xFF537469, 0xFF608679, 0xFF537C6C, 0xFF4D7867, 0xFF558170, 0xFF547D6D, 0xFF3A564A, 0xFF606D66, 0xFF69746E, 0xFF4B6258, 0xFF476B5D, 0xFF537769,
    0xFF40574D, 0xFF76817B, 0xFF75827B, 0xFF3A5449, 0xFF426859, 0xFF5B8474, 0xFF44685A, 0xFF75724F, 0xFFA99A71, 0xFFAF986F, 0xFFAF9974, 0xFFB3976F, 0xFFBA9F70, 0xFF8C8C66, 0xFF385946, 0xFF4D7867, 0xFF527B6B, 0xFF5B7D6F, 0xFF3B574B, 0xFF42564D,
    0xFF3F4A44, 0xFF838985, 0xFFA8AAA7, 0xFFA4B9B4, 0xFFA2B5B1, 0xFF91A4A0, 0xFF7A8A87, 0xFF6D7C79, 0xFF62716E, 0xFF576361, 0xFF515D5B, 0xFF425750, 0xFF637672, 0xFF7D908C, 0xFF7E8E8B, 0xFF526060, 0xFF455353, 0xFF465153, 0xFF3C4749, 0xFF3D4D4C,
    0xFF3C4C4B, 0xFF445453, 0xFF546262, 0xFF556363, 0xFF4B5757, 0xFF4E5A5A, 0xFF636F6F, 0xFF616B6D, 0xFF4C5658, 0xFF404B4D, 0xFF3F4D4E, 0xFF435353, 0xFF3A4C4C, 0xFF304242, 0xFF394D4C, 0xFF4F504B, 0xFF9D9C98, 0xFFBFBAB6, 0xFFC5BDBA, 0xFFC2B9B4,
    0xFFBBB4AE, 0xFFBAB7AE, 0xFFC4C4BA, 0xFFBFBBB0, 0xFFBDBDB1, 0xFFBBBBAF, 0xFFBBB2A9, 0xFFBCABA4, 0xFFC6B7B0, 0xFFACACA0, 0xFF687665, 0xFF527B69, 0xFF537C6A, 0xFF517866, 0xFF547668, 0xFF557568, 0xFF2E4C42, 0xFF102B22, 0xFF29433A, 0xFF224740,
    0xFF21403B, 0xFF3D5350, 0xFF273633, 0xFF828B88, 0xFFB9BFBD, 0xFFB8BDB9, 0xFF575C56, 0xFF344846, 0xFF2E4442, 0xFF2F4747, 0xFF2B4546, 0xFF284646, 0xFF1F3F3A, 0xFF2C5046, 0xFF4A6E60, 0xFF456E5E, 0xFF467160, 0xFF3F6B5A, 0xFF477060, 0xFF49695C,
    0xFF60746B, 0xFFB3B9B5, 0xFF969593, 0xFF607066, 0xFF42584C, 0xFF4C6457, 0xFF56665C, 0xFFA5A6A1, 0xFFAAA6A3, 0xFF636560, 0xFF4E5B52, 0xFF3E6352, 0xFF4A5E53, 0xFF83827E, 0xFFB1ACA9, 0xFF838882, 0xFF475B50, 0xFF435D50, 0xFF496557, 0xFF61605C,
    0xFFBBB1B0, 0xFFA8A09E, 0xFF4A554D, 0xFF335344, 0xFF537565, 0xFF66776D, 0xFFA29E9B, 0xFFBEBDB9, 0xFF495D54, 0xFF345D4F, 0xFF2C5C4C, 0xFF1B4338, 0xFF27403C, 0xFF354747, 0xFF364848, 0xFF37524D, 0xFF3D5350, 0xFF293C38, 0xFF51605D, 0xFF8A9692,
    0xFF2E3A36, 0xFF25342F, 0xFF293A32, 0xFF4C5655, 0xFF475150, 0xFF3A4443, 0xFF3F4E49, 0xFF485D56, 0xFF5B776B, 0xFF55796B, 0xFF527D6C, 0xFF597D6F, 0xFF587E6F, 0xFF5A8373, 0xFF5B8172, 0xFF4D6B5F, 0x00D4E5DD, 0x00FDFFFC, 0x00FFFCFC, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xBAEAC193, 0xFFE1A05C, 0xFFF4A354, 0xFFEEA45B, 0xFFEEA863, 0xFFF3A55B, 0xFFF8A65C, 0xFFE79C58, 0xFFEA9F5B, 0xFFEBA05C, 0xFFEDA25E, 0xFFECA15D, 0xFFEBA05C,
    0xFFEA9F5B, 0xFFEA9F5B, 0xFFEBA05C, 0xFFECA35F, 0xFFEA9F5B, 0xFFECA25B, 0xFFE69E56, 0xFFE49E59, 0xFFE4A363, 0xFFDA9F63, 0xFFD8A169, 0xFFE29E49, 0xFFDB9C4C, 0xFFCB974C, 0xFFA78545, 0xFF6F6331, 0xFF404B29, 0xFF496A55, 0xFF3E6A5B, 0xFF405B4C,
    0xFF233F33, 0xFF2C4D44, 0xFF294E46, 0xFF1C413A, 0xFF5F847C, 0xFF80A198, 0xFF3B5B50, 0xFF426058, 0xFF2A4840, 0xFF39524C, 0xFF768A88, 0xFF869695, 0xFF545F61, 0xFF485053, 0xFF34393D, 0xFF263C39, 0xFF1F3230, 0xFF445252, 0xFF768081, 0xFF81898B,
    0xFF778182, 0xFF8A9696, 0xFFAAB8B8, 0xFF50635F, 0xFF273C37, 0xFF344B45, 0xFF4D685F, 0xFF58786D, 0xFF64887C, 0xFF578070, 0xFF547F6E, 0xFF527D6C, 0xFF578372, 0xFF567F6F, 0xFF345044, 0xFF4F5C55, 0xFF4C5751, 0xFF364D43, 0xFF436759, 0xFF507466,
    0xFF384F45, 0xFF4D5852, 0xFF49564F, 0xFF304A3F, 0xFF4E7465, 0xFF588171, 0xFF4F7365, 0xFF86825C, 0xFFB2A175, 0xFFB59D71, 0xFFB69E78, 0xFFB79A6E, 0xFFBB9F6D, 0xFF94926B, 0xFF4F6F5A, 0xFF567F6D, 0xFF577E6C, 0xFF557A69, 0xFF3E5E4F, 0xFF3C584A,
    0xFF4D6558, 0xFF566A5F, 0xFF56675D, 0xFF658077, 0xFF708B82, 0xFF79938A, 0xFF758C84, 0xFF71867F, 0xFF6B7E78, 0xFF63746E, 0xFF65746F, 0xFF617C73, 0xFF86A097, 0xFFA3BAB2, 0xFF8FA49F, 0xFF4A5D59, 0xFF374746, 0xFF414F4F, 0xFF475353, 0xFF374B49,
    0xFF3A4E4C, 0xFF3D504E, 0xFF3D504E, 0xFF3F4F4E, 0xFF40504F, 0xFF445453, 0xFF4B5959, 0xFF4B5557, 0xFF454F51, 0xFF404B4D, 0xFF3F4D4E, 0xFF455555, 0xFF3B4B4B, 0xFF2E4040, 0xFF3D4F4F, 0xFF3F443E, 0xFF8C8D88, 0xFFB6B3AE, 0xFFC0B8B5, 0xFFC6BFB9,
    0xFFBFB8B2, 0xFFB5B1A8, 0xFFBCB9B0, 0xFFC3BAB1, 0xFFBDB9AE, 0xFFBBB7AC, 0xFFBFB5AC, 0xFFC0ADA7, 0xFFC1B0A9, 0xFFA4A498, 0xFF687665, 0xFF507967, 0xFF537C6A, 0xFF517866, 0xFF557769, 0xFF567669, 0xFF2E4C42, 0xFF0F2A21, 0xFF284239, 0xFF244741,
    0xFF1E3B37, 0xFF3E5451, 0xFF4A5956, 0xFF8E9794, 0xFFA4AAA8, 0xFFA7ADA9, 0xFF525952, 0xFF203432, 0xFF2F4342, 0xFF34494A, 0xFF2D4748, 0xFF2B4748, 0xFF22413C, 0xFF2C4D44, 0xFF4A6E60, 0xFF467563, 0xFF42715F, 0xFF3E6A59, 0xFF446A5B, 0xFF4D6B5F,
    0xFF899A92, 0xFFFCFFFD, 0xFFBEBDBB, 0xFF517164, 0xFF3E6052, 0xFF516D61, 0xFF76837C, 0xFFF4F3F1, 0xFFE2DEDD, 0xFF666F6A, 0xFF445950, 0xFF426E5D, 0xFF4D675C, 0xFFB5BAB6, 0xFFFFFFFD, 0xFF9FA8A3, 0xFF536D62, 0xFF3A5C4E, 0xFF2C5042, 0xFF776E6F,
    0xFFFFFAFB, 0xFFD5D5D3, 0xFF4D6259, 0xFF3B6152, 0xFF4A7061, 0xFF5F746B, 0xFFD3D5D2, 0xFFFEFFFA, 0xFF576B62, 0xFF305A4C, 0xFF2B5B4B, 0xFF1A4237, 0xFF29443F, 0xFF354948, 0xFF364848, 0xFF304B42, 0xFF1E352D, 0xFF2F3E39, 0xFF515A55, 0xFF5D635F,
    0xFF424741, 0xFF9A9F99, 0xFF777E77, 0xFF858587, 0xFF717274, 0xFF4D5152, 0xFF3F4845, 0xFF465953, 0xFF5C7A6E, 0xFF547A6B, 0xFF527E6D, 0xFF597D6F, 0xFF587E6F, 0xFF5A8373, 0xFF5B8172, 0xFF4D6B5F, 0x00D4E5DD, 0x00FDFFFC, 0x00FFFCFC, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xBEE9C092, 0xFFE1A05C, 0xFFF4A354, 0xFFEFA55C, 0xFFEFA964, 0xFFF4A65C, 0xFFF9A75D, 0xFFE89D59, 0xFFEBA05C, 0xFFECA15D, 0xFFEDA25E, 0xFFEDA25E, 0xFFEBA05C,
    0xFFEA9F5B, 0xFFEA9F5B, 0xFFEBA05C, 0xFFEAA15C, 0xFFE89D59, 0xFFEBA05C, 0xFFE89F5A, 0xFFE6A05B, 0xFFE1A05E, 0xFFCE9454, 0xFFC48E50, 0xFFC18C56, 0xFFC28E55, 0xFFC6935A, 0xFFBE905C, 0xFFA18256, 0xFF736848, 0xFF69715C, 0xFF5A6C60, 0xFF3B5C49,
    0xFF446958, 0xFF40695B, 0xFF376155, 0xFF396359, 0xFF345C51, 0xFF3A6053, 0xFF4E7264, 0xFF5D8376, 0xFF567A6E, 0xFF416058, 0xFF28433C, 0xFF748886, 0xFFADBDBC, 0xFF95A0A2, 0xFF818B8D, 0xFF7C8083, 0xFF6B6C70, 0xFF76777B, 0xFFA9AAAE, 0xFFCED3D6,
    0xFFC6D0D1, 0xFF829291, 0xFF344846, 0xFF253C36, 0xFF364F49, 0xFF3E5950, 0xFF57776C, 0xFF618277, 0xFF5D8374, 0xFF588171, 0xFF598473, 0xFF5A8574, 0xFF527E6D, 0xFF517A6A, 0xFF314D41, 0xFF48554E, 0xFF404B45, 0xFF334A40, 0xFF3F6355, 0xFF507466,
    0xFF344B41, 0xFF545F59, 0xFF48554E, 0xFF233D32, 0xFF466C5D, 0xFF557E6E, 0xFF527668, 0xFF87825C, 0xFFAD9A6F, 0xFFAF9469, 0xFFAD946C, 0xFFB09165, 0xFFB99D6B, 0xFF96936A, 0xFF57745E, 0xFF577E6C, 0xFF5A816F, 0xFF5A816F, 0xFF537A68, 0xFF3A6351,
    0xFF68917F, 0xFF466F5D, 0xFF3E6755, 0xFF5A8073, 0xFF5D8376, 0xFF62867A, 0xFF5E7F74, 0xFF5E7F74, 0xFF608075, 0xFF5D7B71, 0xFF68867C, 0xFF57796B, 0xFF58786D, 0xFF537167, 0xFF4D675E, 0xFF3C534D, 0xFF465955, 0xFF425251, 0xFF374545, 0xFF3C5552,
    0xFF37504D, 0xFF334947, 0xFF304644, 0xFF354948, 0xFF3B4F4E, 0xFF3D5150, 0xFF3B4D4D, 0xFF3F4A4C, 0xFF414C4E, 0xFF3F4D4E, 0xFF3C4C4C, 0xFF415151, 0xFF364848, 0xFF2B3F3E, 0xFF3D5150, 0xFF434D45, 0xFF848983, 0xFFB4B3AE, 0xFFB9B4B0, 0xFFC3BCB6,
    0xFFC4BDB7, 0xFFBDB9B0, 0xFFC1BEB5, 0xFFC5BBB2, 0xFFBEB7AD, 0xFFBAB6AB, 0xFFC0B6AD, 0xFFC2AFA9, 0xFFBEAFA8, 0xFFA3A598, 0xFF6E7F6D, 0xFF4F7866, 0xFF527B69, 0xFF527967, 0xFF57796B, 0xFF57776A, 0xFF2F4D43, 0xFF0E2920, 0xFF264037, 0xFF274641,
    0xFF26403D, 0xFF2D413F, 0xFF374643, 0xFF717C78, 0xFF8D9693, 0xFF565F5A, 0xFF121D15, 0xFF122523, 0xFF2F4342, 0xFF354A4B, 0xFF31494B, 0xFF2E4A4B, 0xFF25443F, 0xFF2C4D44, 0xFF4A6E60, 0xFF447361, 0xFF477362, 0xFF45705F, 0xFF416557, 0xFF476156,
    0xFF8D9E96, 0xFFF9FFFD, 0xFFA1A3A0, 0xFF32614F, 0xFF3D6C5A, 0xFF446A5B, 0xFF63786F, 0xFFF6FCF8, 0xFFD5DBD7, 0xFF4B6057, 0xFF3F6355, 0xFF3F725F, 0xFF486A5C, 0xFFA6B5AE, 0xFFF8FFFD, 0xFF6F847B, 0xFF375B4D, 0xFF295443, 0xFF335E4D, 0xFF6F716E,
    0xFFFBFFFD, 0xFFBFD0C8, 0xFF3E6052, 0xFF42715F, 0xFF497564, 0xFF526E62, 0xFFCDDAD3, 0xFFFFFFFB, 0xFF53685F, 0xFF2F594B, 0xFF2A5D4C, 0xFF1C463A, 0xFF2E4944, 0xFF374B4A, 0xFF364A49, 0xFF2A4139, 0xFF41544E, 0xFF707D76, 0xFF393F3B, 0xFF11130E,
    0xFF6A6C67, 0xFFFEFFFA, 0xFF8B8E87, 0xFF848285, 0xFFA8A6A9, 0xFF9FA0A2, 0xFF666F6C, 0xFF455650, 0xFF58766A, 0xFF567F6F, 0xFF548371, 0xFF597D6F, 0xFF587E6F, 0xFF5A8373, 0xFF5B8172, 0xFF4E6C60, 0x00D5E6DE, 0x00FDFFFC, 0x00FFFDFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xBEE9C092, 0xFFE09F5B, 0xFFF4A354, 0xFFF0A65D, 0xFFEFA964, 0xFFF5A75D, 0xFFF9A75D, 0xFFE89D59, 0xFFEBA05C, 0xFFEDA25E, 0xFFEEA35F, 0xFFEDA25E, 0xFFECA15D,
    0xFFEBA05C, 0xFFEBA05C, 0xFFECA15D, 0xFFEDA45F, 0xFFE89D59, 0xFFE89D5A, 0xFFE79E5A, 0xFFEAA361, 0xFFE1A05E, 0xFFBD843F, 0xFFA36E2A, 0xFFA17337, 0xFF9B6B2B, 0xFF9D6C2A, 0xFF986F31, 0xFF907947, 0xFF71714F, 0xFF627A6A, 0xFF59807D, 0xFF628871,
    0xFF5E8874, 0xFF638E7D, 0xFF628E81, 0xFF628E81, 0xFF5A8476, 0xFF5F8576, 0xFF648978, 0xFF527C6E, 0xFF648E80, 0xFF61877A, 0xFF55766D, 0xFF436159, 0xFF425B57, 0xFF889C9A, 0xFFA4B7B5, 0xFF94989B, 0xFF9CA0A3, 0xFFA0A4A7, 0xFFA7ACAF, 0xFF859191,
    0xFF4D605E, 0xFF27423D, 0xFF23423C, 0xFF415F57, 0xFF3C5A50, 0xFF345449, 0xFF426358, 0xFF3B6152, 0xFF335C4C, 0xFF3D6855, 0xFF35604D, 0xFF35604F, 0xFF2E5A49, 0xFF355E4E, 0xFF385448, 0xFF5C6962, 0xFF515C56, 0xFF50675D, 0xFF406456, 0xFF567A6C,
    0xFF4B6258, 0xFF939E98, 0xFF8F9C95, 0xFF496358, 0xFF4B7162, 0xFF5E8777, 0xFF4C7062, 0xFF847C58, 0xFFAE996E, 0xFFB3966E, 0xFFB19570, 0xFFB6956C, 0xFFC1A371, 0xFF8F8A64, 0xFF435E4B, 0xFF517A68, 0xFF5A8371, 0xFF628B79, 0xFF5D8674, 0xFF28513F,
    0xFF507967, 0xFF335C4A, 0xFF3E6956, 0xFF527668, 0xFF4F7566, 0xFF53796A, 0xFF4E7465, 0xFF567F6F, 0xFF5F8878, 0xFF537E6D, 0xFF568170, 0xFF547D6D, 0xFF587E6F, 0xFF54756A, 0xFF48665C, 0xFF365047, 0xFF3F544F, 0xFF3C4F4B, 0xFF435350, 0xFF33504C,
    0xFF2E4845, 0xFF2E4845, 0xFF314B48, 0xFF2C4542, 0xFF28413E, 0xFF344A48, 0xFF3F5553, 0xFF405050, 0xFF435353, 0xFF415353, 0xFF3D5150, 0xFF415755, 0xFF394F4D, 0xFF2A4340, 0xFF354F4C, 0xFF3F4A42, 0xFF7B827B, 0xFFBFC0BA, 0xFFC4C1BC, 0xFFBEB7B1,
    0xFFBDB6B0, 0xFFBCB5AD, 0xFFBCB8AF, 0xFFB9AFA6, 0xFFB9B5AA, 0xFFB8B4A9, 0xFFB9B0A7, 0xFFBAABA4, 0xFFBAB0A7, 0xFF9DA395, 0xFF647966, 0xFF4F7866, 0xFF527B69, 0xFF527967, 0xFF57796B, 0xFF57776A, 0xFF2F4D43, 0xFF0E2920, 0xFF264037, 0xFF284541,
    0xFF294340, 0xFF3A4E4C, 0xFF1E2D2A, 0xFF293430, 0xFF78817E, 0xFF444F49, 0xFF111E15, 0xFF122523, 0xFF334545, 0xFF35494A, 0xFF324A4C, 0xFF304A4B, 0xFF284541, 0xFF2E4F46, 0xFF4C6E60, 0xFF446F5E, 0xFF4A7363, 0xFF466A5C, 0xFF3A5A4D, 0xFF314B40,
    0xFF64786F, 0xFFB4C3BC, 0xFF69766F, 0xFF487767, 0xFF376757, 0xFF325C4E, 0xFF3E5950, 0xFF98A7A2, 0xFF98A7A2, 0xFF4F6D63, 0xFF436F60, 0xFF265545, 0xFF36564B, 0xFF738680, 0xFFBACDC7, 0xFF5A786E, 0xFF345D4F, 0xFF1E4739, 0xFF2D5145, 0xFF4F5E59,
    0xFFACBFB9, 0xFF7C978E, 0xFF2D5346, 0xFF3A6657, 0xFF416A5C, 0xFF415C53, 0xFF8DA09A, 0xFFBFC1BC, 0xFF3D5249, 0xFF315D4E, 0xFF2E6150, 0xFF204A3E, 0xFF2F4C47, 0xFF394D4C, 0xFF394D4C, 0xFF354844, 0xFF6E7D78, 0xFFA3AEAA, 0xFF909493, 0xFF898B88,
    0xFF868B87, 0xFFA5ACA5, 0xFF565D56, 0xFF626365, 0xFF98999B, 0xFFA9ADAE, 0xFF77827E, 0xFF485B55, 0xFF537165, 0xFF517A6A, 0xFF558170, 0xFF5A7E70, 0xFF597F70, 0xFF5A8373, 0xFF5C8273, 0xFF4E6C60, 0x00D5E6DE, 0x00FEFFFD, 0x00FFFDFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xBEE8BF91, 0xFFE09F5B, 0xFFF4A354, 0xFFF0A65D, 0xFFF0AA65, 0xFFF5A75D, 0xFFF9A75D, 0xFFE89D59, 0xFFECA15D, 0xFFEDA25E, 0xFFEEA35F, 0xFFEEA35F, 0xFFECA15D,
    0xFFEBA05C, 0xFFEBA05C, 0xFFECA15D, 0xFFEFA75F, 0xFFEA9F5B, 0xFFE99E5B, 0xFFE59B5A, 0xFFE9A262, 0xFFE2A15D, 0xFFBD843D, 0xFF9E6A21, 0xFFA8721C, 0xFFA87117, 0xFFAE771D, 0xFFA57722, 0xFF99803D, 0xFF6F7549, 0xFF527561, 0xFF487F79, 0xFF5D856D,
    0xFF658F79, 0xFF5E8B77, 0xFF518070, 0xFF638F80, 0xFF5D8678, 0xFF597E6D, 0xFF618372, 0xFF5B8A7A, 0xFF548071, 0xFF598375, 0xFF588173, 0xFF648A7F, 0xFF5B7C73, 0xFF506F69, 0xFF4D6C66, 0xFF21403A, 0xFF213E39, 0xFF17322D, 0xFF27403C, 0xFF2E4944,
    0xFF32514B, 0xFF33564F, 0xFF355D54, 0xFF36574C, 0xFF507166, 0xFF597D71, 0xFF426658, 0xFF4B7162, 0xFF4D7664, 0xFF446F5C, 0xFF45705D, 0xFF467160, 0xFF436F5E, 0xFF3E6757, 0xFF627E72, 0xFF8B9891, 0xFF707B75, 0xFF7E958B, 0xFF3F6355, 0xFF517567,
    0xFF52695F, 0xFF69746E, 0xFF5C6962, 0xFF405A4F, 0xFF2E5445, 0xFF436C5C, 0xFF3C6052, 0xFF7A7150, 0xFFA28A64, 0xFFAB8B65, 0xFFAA8C6A, 0xFFAC8A64, 0xFFB29164, 0xFF7C7652, 0xFF344F40, 0xFF45725D, 0xFF426D59, 0xFF446B58, 0xFF426352, 0xFF244031,
    0xFF445A4D, 0xFF3F5145, 0xFF3D4D42, 0xFF41594C, 0xFF3B5548, 0xFF385446, 0xFF29493A, 0xFF3B604F, 0xFF5A8371, 0xFF5B8673, 0xFF5E8B77, 0xFF578372, 0xFF517C6B, 0xFF507667, 0xFF4B6C61, 0xFF3A554C, 0xFF3F5650, 0xFF384B47, 0xFF394C48, 0xFF284644,
    0xFF264442, 0xFF2F4C4A, 0xFF324F4D, 0xFF274140, 0xFF1E3837, 0xFF2B4544, 0xFF3B5554, 0xFF394D4C, 0xFF394F4D, 0xFF3A504E, 0xFF354E4B, 0xFF36504D, 0xFF2E4B47, 0xFF22413C, 0xFF284742, 0xFF3F4C43, 0xFF69736B, 0xFFBBBEB7, 0xFFC5C2BD, 0xFFB2ABA5,
    0xFFAFA8A2, 0xFFB6AFA7, 0xFFB6B2A9, 0xFFB3AAA1, 0xFFBAB8AC, 0xFFBBBBAF, 0xFFC0B9AF, 0xFFC3B6AE, 0xFFC1BAB0, 0xFFA1AC9C, 0xFF66826C, 0xFF517A68, 0xFF537C6A, 0xFF517866, 0xFF557769, 0xFF557568, 0xFF2E4C42, 0xFF0F2A21, 0xFF284239, 0xFF2A4743,
    0xFF1D3633, 0xFF2F4240, 0xFF232F2D, 0xFF141F1B, 0xFF606B67, 0xFF4E5B54, 0xFF142118, 0xFF1F2F2E, 0xFF394B4B, 0xFF324647, 0xFF314649, 0xFF2B4546, 0xFF274440, 0xFF315048, 0xFF4E7062, 0xFF4C7062, 0xFF4E7062, 0xFF3C5C4F, 0xFF385448, 0xFF2F493E,
    0xFF3D544A, 0xFF637A70, 0xFF4E655B, 0xFF47655B, 0xFF2C5044, 0xFF365A4E, 0xFF3D574E, 0xFF4D5C57, 0xFF606F6A, 0xFF4E6960, 0xFF315B4D, 0xFF455F56, 0xFF4A5B55, 0xFF56625E, 0xFF6F807A, 0xFF4F6A61, 0xFF3E5E53, 0xFF365047, 0xFF3D4E48, 0xFF41544E,
    0xFF5E756D, 0xFF415C53, 0xFF28463C, 0xFF314C43, 0xFF3C534B, 0xFF3E4F49, 0xFF5D6965, 0xFF797B76, 0xFF30453C, 0xFF3A6657, 0xFF2E6351, 0xFF204C3F, 0xFF2F4C47, 0xFF394F4D, 0xFF3B4F4E, 0xFF465454, 0xFF4C5657, 0xFF5F6867, 0xFFADB3B3, 0xFFD8DEDC,
    0xFF606966, 0xFF424E4A, 0xFF778681, 0xFF4C5554, 0xFF4F5857, 0xFF525C5B, 0xFF45544F, 0xFF41564F, 0xFF5D7B6F, 0xFF577D6E, 0xFF54806F, 0xFF5B7F71, 0xFF5A8071, 0xFF5B8474, 0xFF5D8374, 0xFF4F6D61, 0x00D6E7DF, 0x00FEFFFD, 0x00FFFDFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xBEE8BF91, 0xFFE09F5B, 0xFFF4A354, 0xFFF0A65D, 0xFFF0AA65, 0xFFF6A85E, 0xFFFAA85E, 0xFFE89D59, 0xFFECA15D, 0xFFEDA25E, 0xFFEEA35F, 0xFFEEA35F, 0xFFEDA25E,
    0xFFEBA05C, 0xFFECA15D, 0xFFECA15D, 0xFFE9A159, 0xFFEBA05C, 0xFFEEA360, 0xFFE69C5D, 0xFFE59E5E, 0xFFE09F5B, 0xFFBF873D, 0xFFA47024, 0xFFA0763A, 0xFFA67533, 0xFFB37930, 0xFFAC7228, 0xFFA87838, 0xFF846C3C, 0xFF696C4F, 0xFF67796B, 0xFF628A70,
    0xFF557F69, 0xFF608D79, 0xFF5F8B7A, 0xFF578374, 0xFF567F6F, 0xFF638877, 0xFF597A69, 0xFF51806E, 0xFF558474, 0xFF568273, 0xFF568273, 0xFF5A8478, 0xFF577F74, 0xFF668E85, 0xFF567E75, 0xFF4A8374, 0xFF3F7567, 0xFF39695D, 0xFF4A756B, 0xFF3F695F,
    0xFF477167, 0xFF527D73, 0xFF4B766C, 0xFF496D61, 0xFF466A5E, 0xFF426658, 0xFF3E6455, 0xFF466F5F, 0xFF325D4A, 0xFF3C6754, 0xFF3C6754, 0xFF35604F, 0xFF416D5C, 0xFF2E5747, 0xFF526E62, 0xFF64716A, 0xFF414C46, 0xFF879E94, 0xFF517567, 0xFF527668,
    0xFF698076, 0xFF414C46, 0xFF38453E, 0xFF718B80, 0xFF4A7061, 0xFF3C6555, 0xFF3C6052, 0xFF7B7052, 0xFF947C58, 0xFF987754, 0xFF98795A, 0xFF987450, 0xFF9D7C51, 0xFF7A7150, 0xFF4A6255, 0xFF40705A, 0xFF416C58, 0xFF466857, 0xFF425A4C, 0xFF465349,
    0xFF676862, 0xFF88837F, 0xFF7B706E, 0xFF768078, 0xFF768179, 0xFF6B7C72, 0xFF4A6054, 0xFF4B6A5B, 0xFF688A7A, 0xFF5D8674, 0xFF57826F, 0xFF588773, 0xFF54806F, 0xFF5D8676, 0xFF587C6E, 0xFF3A584E, 0xFF39534A, 0xFF354A45, 0xFF394C48, 0xFF2C4C49,
    0xFF284845, 0xFF2C4A48, 0xFF2D4B49, 0xFF2A4745, 0xFF2A4745, 0xFF304A49, 0xFF2D4746, 0xFF344D4A, 0xFF334C49, 0xFF334D4A, 0xFF2A4743, 0xFF274641, 0xFF254540, 0xFF21413C, 0xFF294C46, 0xFF415147, 0xFF58635B, 0xFFA9AEA7, 0xFFBAB7B2, 0xFFA39C96,
    0xFF9D9690, 0xFFA29B93, 0xFF9D968E, 0xFFA19A90, 0xFFA4A296, 0xFFA5A79A, 0xFFAFABA0, 0xFFB4ABA2, 0xFFB2AEA3, 0xFF96A493, 0xFF64816B, 0xFF537C6A, 0xFF547D6B, 0xFF507765, 0xFF537567, 0xFF537366, 0xFF2D4B41, 0xFF102B22, 0xFF2A443B, 0xFF334D4A,
    0xFF314745, 0xFF2F4240, 0xFF5A6664, 0xFF6A7571, 0xFF6D7874, 0xFF5A6760, 0xFF18281E, 0xFF293938, 0xFF3D4F4F, 0xFF304445, 0xFF2E4346, 0xFF264041, 0xFF25423E, 0xFF33524A, 0xFF507264, 0xFF58786B, 0xFF516F63, 0xFF375347, 0xFF405A4F, 0xFF435A50,
    0xFF2F493E, 0xFF345044, 0xFF4A685C, 0xFF43524D, 0xFF50655E, 0xFF567067, 0xFF485B55, 0xFF3D4844, 0xFF4B5652, 0xFF4D625B, 0xFF507166, 0xFF606966, 0xFF5C605F, 0xFF595B5A, 0xFF46514D, 0xFF475C55, 0xFF435A52, 0xFF5E6965, 0xFF606060, 0xFF475A54,
    0xFF40554E, 0xFF344942, 0xFF465751, 0xFF515D59, 0xFF5B615F, 0xFF515755, 0xFF4F5352, 0xFF5C5E59, 0xFF334A40, 0xFF426E5F, 0xFF2C614F, 0xFF1E4A3D, 0xFF2F4C47, 0xFF3A504E, 0xFF3C5250, 0xFF424C4E, 0xFF495154, 0xFF494E51, 0xFF676C6F, 0xFF697173,
    0xFF212D2B, 0xFF2C3C39, 0xFF4E635E, 0xFF374643, 0xFF394845, 0xFF42514E, 0xFF3C4D47, 0xFF3B524A, 0xFF5F7D71, 0xFF5B8172, 0xFF568170, 0xFF5B7F71, 0xFF5A8071, 0xFF5C8575, 0xFF5D8374, 0xFF4F6D61, 0x00D6E7DF, 0x00FEFFFD, 0x00FFFDFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xCEF2BD89, 0xFFDA9F65, 0xFFEAA761, 0xFFF4AB5E, 0xFFF4A757, 0xFFF2A658, 0xFFF4AA63, 0xFFE29C57, 0xFFEA9F5C, 0xFFF0A562, 0xFFEDA25F, 0xFFEBA05D, 0xFFECA15E,
    0xFFE99E5B, 0xFFEA9F5C, 0xFFEEA360, 0xFFF1A05F, 0xFFEC9D5B, 0xFFEEA35F, 0xFFE9A35D, 0xFFE5A55E, 0xFFDDA25E, 0xFFBC8646, 0xFFA57233, 0xFFA57C2D, 0xFFAF7E32, 0xFFB47933, 0xFFB67C3D, 0xFFA6814C, 0xFF7D7A4D, 0xFF597B58, 0xFF589171, 0xFF5C8974,
    0xFF588872, 0xFF5E8D79, 0xFF5E8F7A, 0xFF568A74, 0xFF538874, 0xFF558A76, 0xFF518672, 0xFF5A8574, 0xFF598473, 0xFF588372, 0xFF578271, 0xFF578271, 0xFF598473, 0xFF5A8574, 0xFF5B8675, 0xFF5C8776, 0xFF598473, 0xFF5C8776, 0xFF5D8877, 0xFF588372,
    0xFF5A8574, 0xFF5F8A79, 0xFF5D8877, 0xFF668C7D, 0xFF5F8576, 0xFF63897A, 0xFF63897A, 0xFF5C8273, 0xFF5E8475, 0xFF608677, 0xFF5B8172, 0xFF63897A, 0xFF5D8374, 0xFF53796A, 0xFF4A7061, 0xFF466C5D, 0xFF466C5D, 0xFF4A7061, 0xFF4D7364, 0xFF547D6D,
    0xFF396252, 0xFF345D4D, 0xFF436C5C, 0xFF557E6E, 0xFF456E5E, 0xFF3D6656, 0xFF3A6353, 0xFF5C6D5D, 0xFF576858, 0xFF475848, 0xFF728373, 0xFF576858, 0xFF455646, 0xFF869787, 0xFF627363, 0xFF3E6B57, 0xFF3F6A57, 0xFF4A6F5E, 0xFF466556, 0xFF546A5E,
    0xFF7B8B81, 0xFF828C84, 0xFF6F766F, 0xFF7F8581, 0xFF8A938E, 0xFF56655E, 0xFF778C83, 0xFF658377, 0xFF5E8274, 0xFF5D8676, 0xFF568271, 0xFF5E8777, 0xFF5F8878, 0xFF5E8777, 0xFF5A8373, 0xFF547D6D, 0xFF4F7868, 0xFF4C7565, 0xFF4B7464, 0xFF4D7462,
    0xFF4C7361, 0xFF4B7260, 0xFF4A715F, 0xFF49705E, 0xFF49705E, 0xFF49705E, 0xFF49705E, 0xFF4D7261, 0xFF4D7261, 0xFF4D7261, 0xFF4C7160, 0xFF4C7160, 0xFF4B705F, 0xFF4B705F, 0xFF4B705F, 0xFF536F60, 0xFF597566, 0xFF688475, 0xFF718D7E, 0xFF6E8A7B,
    0xFF6C8879, 0xFF6D897A, 0xFF688475, 0xFF638877, 0xFF628776, 0xFF618675, 0xFF618675, 0xFF628776, 0xFF618675, 0xFF5E8372, 0xFF5C8170, 0xFF56816E, 0xFF57826F, 0xFF547B69, 0xFF587A6A, 0xFF5A796A, 0xFF344E41, 0xFF142C1F, 0xFF2D4337, 0xFF2B4B40,
    0xFF284239, 0xFF6B7A75, 0xFFA5AEAB, 0xFF868F8C, 0xFF54635E, 0xFF3D574E, 0xFF2A4A3F, 0xFF2F4845, 0xFF2A4340, 0xFF27413E, 0xFF2B4542, 0xFF274440, 0xFF24413D, 0xFF36534F, 0xFF51706B, 0xFF59806E, 0xFF517061, 0xFF364A3F, 0xFF5B665E, 0xFF49544C,
    0xFF2F4036, 0xFF2E483B, 0xFF517162, 0xFF4A5F56, 0xFF7A8F86, 0xFF50655C, 0xFF3F544B, 0xFF293E35, 0xFF4B6057, 0xFF5B7067, 0xFFA8BDB4, 0xFFBBBDB8, 0xFF677169, 0xFF30463A, 0xFF365246, 0xFF48665A, 0xFF7D948C, 0xFF8F9E99, 0xFF4B514F, 0xFF3F594E,
    0xFF203C30, 0xFF51685E, 0xFF77847D, 0xFFB3B3B1, 0xFF676C68, 0xFF4C6057, 0xFF1F4335, 0xFF425E50, 0xFF385A4C, 0xFF406A5C, 0xFF2E5E52, 0xFF204E44, 0xFF2E504F, 0xFF31494D, 0xFF38464F, 0xFF2D4A45, 0xFF33504B, 0xFF37544F, 0xFF324F4A, 0xFF284540,
    0xFF213E39, 0xFF223F3A, 0xFF26433E, 0xFF3E494F, 0xFF404D53, 0xFF3D4C4F, 0xFF334745, 0xFF445E55, 0xFF5D7B6F, 0xFF5F8171, 0xFF5C816F, 0xFF5C8072, 0xFF5C8273, 0xFF5B8474, 0xFF628879, 0xFF537165, 0x00D4E5DD, 0x00FEFFFD, 0x00FFFDFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xD9EEB484, 0xFFDE9F69, 0xFFE8A465, 0xFFECA25B, 0xFFF9AD62, 0xFFF7AA62, 0xFFF3AA66, 0xFFE59E5E, 0xFFEFA55E, 0xFFF2A861, 0xFFF2A861, 0xFFF2A861, 0xFFF3A962,
    0xFFEFA55E, 0xFFEDA35C, 0xFFEBA15A, 0xFFECA764, 0xFFEAA560, 0xFFEBA861, 0xFFE1A159, 0xFFDFA55C, 0xFFD9A45E, 0xFFBA8947, 0xFF9E7130, 0xFF827E4F, 0xFF8A8253, 0xFF8C8050, 0xFF8A7F51, 0xFF88865D, 0xFF748163, 0xFF627E68, 0xFF5C8072, 0xFF5B8571,
    0xFF57826E, 0xFF5A8572, 0xFF5D8875, 0xFF5B8673, 0xFF5E8978, 0xFF618C7B, 0xFF5D8877, 0xFF5A8574, 0xFF598473, 0xFF598473, 0xFF588372, 0xFF598473, 0xFF598473, 0xFF5B8675, 0xFF5B8675, 0xFF5B8675, 0xFF598473, 0xFF5D8877, 0xFF5E8978, 0xFF5A8574,
    0xFF5C8776, 0xFF608B7A, 0xFF5E8978, 0xFF5B8172, 0xFF5B8172, 0xFF5D8374, 0xFF5C8273, 0xFF587E6F, 0xFF587E6F, 0xFF5A8071, 0xFF5C8273, 0xFF5C8273, 0xFF5B8172, 0xFF5A8071, 0xFF597F70, 0xFF597F70, 0xFF597F70, 0xFF597F70, 0xFF597F70, 0xFF5E8475,
    0xFF5A8071, 0xFF5A8071, 0xFF53796A, 0xFF577D6E, 0xFF4F7566, 0xFF4C7263, 0xFF426859, 0xFF798E7F, 0xFF324738, 0xFF172C1D, 0xFF2F4435, 0xFF081D0E, 0xFF364B3C, 0xFF97AC9D, 0xFF526758, 0xFF45705D, 0xFF426B59, 0xFF466B5A, 0xFF385849, 0xFF385245,
    0xFF52685C, 0xFF596A60, 0xFF4B5B51, 0xFF4F5E57, 0xFF687971, 0xFF52675E, 0xFF5A7469, 0xFF4D6D60, 0xFF5A7E70, 0xFF5A8373, 0xFF588372, 0xFF567F6F, 0xFF588171, 0xFF5A8373, 0xFF5B8474, 0xFF5A8373, 0xFF598272, 0xFF598272, 0xFF5A8373, 0xFF5D8472,
    0xFF5C8371, 0xFF5B8270, 0xFF5A816F, 0xFF59806E, 0xFF59806E, 0xFF59806E, 0xFF59806E, 0xFF5D8271, 0xFF5D8271, 0xFF5D8271, 0xFF5D8271, 0xFF5D8271, 0xFF5D8271, 0xFF5D8271, 0xFF5D8271, 0xFF5C7D6C, 0xFF5D7E6D, 0xFF638473, 0xFF678877, 0xFF638473,
    0xFF638473, 0xFF668776, 0xFF638473, 0xFF5F8473, 0xFF5E8372, 0xFF5D8271, 0xFF5D8271, 0xFF5D8271, 0xFF5D8271, 0xFF5B806F, 0xFF597E6D, 0xFF527D6A, 0xFF56816E, 0xFF567D6B, 0xFF5A7C6C, 0xFF5D7C6D, 0xFF345042, 0xFF142C1F, 0xFF2E4639, 0xFF2B4947,
    0xFF263E3E, 0xFF455457, 0xFF636C71, 0xFF535C61, 0xFF3A494C, 0xFF304848, 0xFF294745, 0xFF314A47, 0xFF2D4744, 0xFF28423F, 0xFF294340, 0xFF284541, 0xFF25423E, 0xFF35544F, 0xFF54736E, 0xFF58816F, 0xFF5B7D6D, 0xFF4A6255, 0xFF7B8C82, 0xFF8A9A90,
    0xFF5D7367, 0xFF3E5D4E, 0xFF5D8271, 0xFF526C61, 0xFF627C71, 0xFF4E685D, 0xFF516B60, 0xFF405A4F, 0xFF607A6F, 0xFF6A8479, 0xFF88A297, 0xFFCAD1CA, 0xFF92A298, 0xFF4A6255, 0xFF537366, 0xFF59796C, 0xFF617C73, 0xFF92A59F, 0xFF7E8A86, 0xFF557367,
    0xFF355548, 0xFF607C70, 0xFF8C9D95, 0xFFE9EFEB, 0xFFA3ACA7, 0xFF5E756B, 0xFF305647, 0xFF4C6B5C, 0xFF3B5D4F, 0xFF416B5D, 0xFF315F52, 0xFF1D483F, 0xFF294C48, 0xFF344C4E, 0xFF384950, 0xFF394D4C, 0xFF3C504F, 0xFF3E5251, 0xFF3C504F, 0xFF374B4A,
    0xFF334746, 0xFF334746, 0xFF334746, 0xFF3D4C51, 0xFF3A4C4E, 0xFF354948, 0xFF304945, 0xFF426056, 0xFF597B6D, 0xFF577C6B, 0xFF547B68, 0xFF5D8173, 0xFF5C8273, 0xFF598272, 0xFF608677, 0xFF537165, 0x00D4E5DD, 0x00FEFFFD, 0x00FFFCFC, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x98EDC4A6, 0xAFE8BC99, 0xFFE0B185, 0xFFC19160, 0xFFD6A46F, 0xFFD3A470, 0xFFCD9F6E, 0xFFC89C6F, 0xFFCB9D62, 0xFFC99B60, 0xFFCD9F64, 0xFFCD9F64, 0xFFD2A469,
    0xFFD2A469, 0xFFD3A56A, 0xFFD2A469, 0xFFDBA173, 0xFFDA9D6E, 0xFFDCA06E, 0xFFD79B67, 0xFFD79D6B, 0xFFCC9868, 0xFFB68759, 0xFFA57A4D, 0xFF678778, 0xFF678A76, 0xFF698B72, 0xFF63856A, 0xFF6D8D75, 0xFF6F8C7A, 0xFF6F8882, 0xFF697F7D, 0xFF618B77,
    0xFF5D8773, 0xFF5D8472, 0xFF5D8472, 0xFF5B806F, 0xFF5E8072, 0xFF5F8173, 0xFF5E7E71, 0xFF5A8574, 0xFF5A8574, 0xFF5A8574, 0xFF5A8574, 0xFF5A8574, 0xFF5B8675, 0xFF5B8675, 0xFF5B8675, 0xFF5A8574, 0xFF5A8574, 0xFF5D8877, 0xFF5F8A79, 0xFF5C8776,
    0xFF5D8877, 0xFF5F8A79, 0xFF5D8877, 0xFF5C8273, 0xFF5F8576, 0xFF5C8273, 0xFF5A8071, 0xFF5C8273, 0xFF5A8071, 0xFF5B8172, 0xFF5E8475, 0xFF597F70, 0xFF5A8071, 0xFF5D8374, 0xFF5E8475, 0xFF5E8475, 0xFF5D8374, 0xFF5A8071, 0xFF587E6F, 0xFF54786A,
    0xFF5E8274, 0xFF64887A, 0xFF597D6F, 0xFF5A7E70, 0xFF5D8173, 0xFF5F8375, 0xFF577B6D, 0xFF4C6659, 0xFF4D675A, 0xFF3C5649, 0xFF3D574A, 0xFF3C5649, 0xFF496356, 0xFF637D70, 0xFF4F695C, 0xFF5F8876, 0xFF5F8674, 0xFF608775, 0xFF517665, 0xFF486A5A,
    0xFF547465, 0xFF5A796A, 0xFF537263, 0xFF4B695D, 0xFF607E72, 0xFF628275, 0xFF537567, 0xFF496D5F, 0xFF5B8172, 0xFF587E6F, 0xFF567F6F, 0xFF578070, 0xFF588171, 0xFF5A8373, 0xFF5B8474, 0xFF5B8474, 0xFF5C8575, 0xFF5C8575, 0xFF5D8676, 0xFF5A8371,
    0xFF5A8371, 0xFF598270, 0xFF58816F, 0xFF57806E, 0xFF57806E, 0xFF58816F, 0xFF58816F, 0xFF5B8270, 0xFF5B8270, 0xFF5C8371, 0xFF5C8371, 0xFF5D8472, 0xFF5D8472, 0xFF5E8573, 0xFF5E8573, 0xFF5F8473, 0xFF5C8170, 0xFF5D8271, 0xFF5D8271, 0xFF5A7F6E,
    0xFF5C8170, 0xFF5E8372, 0xFF5D8271, 0xFF5E8573, 0xFF5D8472, 0xFF5B8270, 0xFF5B8270, 0xFF5C8371, 0xFF5C8371, 0xFF5C8371, 0xFF5B8270, 0xFF527D6A, 0xFF57826F, 0xFF577E6C, 0xFF597E6D, 0xFF5E7E6F, 0xFF325142, 0xFF0F2B1D, 0xFF2C4639, 0xFF304E50,
    0xFF2F484C, 0xFF34454C, 0xFF39464E, 0xFF3A474F, 0xFF35464D, 0xFF2E474B, 0xFF2C4A4C, 0xFF2B4641, 0xFF334E49, 0xFF2F4C47, 0xFF2A4742, 0xFF274640, 0xFF22413B, 0xFF35544E, 0xFF5B7C75, 0xFF54816D, 0xFF608775, 0xFF607F70, 0xFF6C8679, 0xFF667E71,
    0xFF587466, 0xFF628474, 0xFF6C9381, 0xFF67877A, 0xFF57776A, 0xFF48685B, 0xFF567669, 0xFF567669, 0xFF668679, 0xFF57776A, 0xFF466659, 0xFF7B8C82, 0xFF71877B, 0xFF587768, 0xFF567A6C, 0xFF628678, 0xFF5A7A6F, 0xFF5C766D, 0xFF738881, 0xFF4E7062,
    0xFF325648, 0xFF4B6F61, 0xFF3B554A, 0xFF74837C, 0xFF6E7D76, 0xFF567468, 0xFF345F4E, 0xFF416154, 0xFF2F5345, 0xFF436D5F, 0xFF477366, 0xFF2C574D, 0xFF2A4D47, 0xFF314B4A, 0xFF374B4C, 0xFF3A494C, 0xFF39484B, 0xFF39484B, 0xFF3B4A4D, 0xFF3C4B4E,
    0xFF3C4B4E, 0xFF3A494C, 0xFF38474A, 0xFF384D4E, 0xFF344D4A, 0xFF324D48, 0xFF314F47, 0xFF46675C, 0xFF5C8273, 0xFF5B8472, 0xFF5C8573, 0xFF5D8173, 0xFF5C8273, 0xFF588171, 0xFF5F8576, 0xFF527064, 0x00D4E5DD, 0x00FEFFFD, 0x00FFFBFB, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFF8, 0x04FFFEF3, 0xFFD0CDBC, 0xFF76765E, 0xFF85856B, 0xFF83876C, 0xFF7D826B, 0xFF818670, 0xFF84876A, 0xFF818467, 0xFF888B6E, 0xFF828568, 0xFF878A6D,
    0xFF85886B, 0xFF85886B, 0xFF85886B, 0xFF7F8E6D, 0xFF7C8765, 0xFF838965, 0xFF858964, 0xFF898D6A, 0xFF787F5D, 0xFF6F7D5C, 0xFF728363, 0xFF5C847B, 0xFF5B8174, 0xFF648978, 0xFF5F8170, 0xFF698A79, 0xFF638376, 0xFF6A8983, 0xFF64837E, 0xFF5C8C76,
    0xFF5D8A75, 0xFF5C8975, 0xFF5D8674, 0xFF5C8371, 0xFF5E8274, 0xFF628476, 0xFF628476, 0xFF5A8574, 0xFF5A8574, 0xFF5B8675, 0xFF5B8675, 0xFF5B8675, 0xFF5C8776, 0xFF5B8675, 0xFF5B8675, 0xFF5A8574, 0xFF5B8675, 0xFF5D8877, 0xFF5F8A79, 0xFF5D8877,
    0xFF5A8574, 0xFF588372, 0xFF55806F, 0xFF5F8576, 0xFF5E8475, 0xFF587E6F, 0xFF597F70, 0xFF5B8172, 0xFF5A8071, 0xFF5B8172, 0xFF587E6F, 0xFF5A816F, 0xFF59806E, 0xFF587F6D, 0xFF577E6C, 0xFF567D6B, 0xFF567D6B, 0xFF557C6A, 0xFF557C6A, 0xFF587A6A,
    0xFF597B6B, 0xFF5C7E6E, 0xFF5C7E6E, 0xFF5E8070, 0xFF5F8171, 0xFF5F8171, 0xFF5C7E6E, 0xFF597B6D, 0xFF5F8173, 0xFF57796B, 0xFF537567, 0xFF5E8072, 0xFF597B6D, 0xFF517365, 0xFF5C7E70, 0xFF5B8270, 0xFF5E8573, 0xFF658C7A, 0xFF628977, 0xFF5A816F,
    0xFF5A8371, 0xFF5D8674, 0xFF598270, 0xFF5B8675, 0xFF5D8676, 0xFF648D7D, 0xFF598272, 0xFF5B8474, 0xFF618A7A, 0xFF5E8475, 0xFF5F8576, 0xFF5A8373, 0xFF5A8373, 0xFF5A8373, 0xFF5A8373, 0xFF5A8373, 0xFF598272, 0xFF598272, 0xFF598272, 0xFF598270,
    0xFF58816F, 0xFF58816F, 0xFF57806E, 0xFF567F6D, 0xFF567F6D, 0xFF57806E, 0xFF57806E, 0xFF5A816F, 0xFF5A816F, 0xFF5A816F, 0xFF5B8270, 0xFF5B8270, 0xFF5B8270, 0xFF5B8270, 0xFF5C8371, 0xFF58816F, 0xFF567F6D, 0xFF567F6D, 0xFF57806E, 0xFF58816F,
    0xFF598270, 0xFF598270, 0xFF57806E, 0xFF5E8573, 0xFF5C8371, 0xFF5A816F, 0xFF5A816F, 0xFF5B8270, 0xFF5C8371, 0xFF5C8371, 0xFF5C8371, 0xFF547F6C, 0xFF588370, 0xFF557E6C, 0xFF5B8270, 0xFF658777, 0xFF3D5D4E, 0xFF183728, 0xFF2F4E3F, 0xFF2B4A45,
    0xFF2E4B47, 0xFF2F4543, 0xFF2D4140, 0xFF334746, 0xFF344A48, 0xFF2A4743, 0xFF274641, 0xFF234139, 0xFF2D4B43, 0xFF27463E, 0xFF26453D, 0xFF2F5047, 0xFF2D4E45, 0xFF385950, 0xFF57786F, 0xFF51806C, 0xFF5B8673, 0xFF648B79, 0xFF648475, 0xFF5D7D6E,
    0xFF628474, 0xFF678E7C, 0xFF46715E, 0xFF54786A, 0xFF45695B, 0xFF34584A, 0xFF375B4D, 0xFF4F7365, 0xFF54786A, 0xFF496D5F, 0xFF406456, 0xFF577164, 0xFF446354, 0xFF5E8372, 0xFF6A9383, 0xFF618A7A, 0xFF52786B, 0xFF45665B, 0xFF5E7C72, 0xFF3C6052,
    0xFF335E4D, 0xFF4E7A69, 0xFF406456, 0xFF6B8278, 0xFF677E74, 0xFF537567, 0xFF2D5C4A, 0xFF486C5E, 0xFF3C6253, 0xFF4F7A69, 0xFF598576, 0xFF436D61, 0xFF30544A, 0xFF2B4843, 0xFF344D49, 0xFF354A4B, 0xFF34494A, 0xFF354A4B, 0xFF374C4D, 0xFF3A4F50,
    0xFF3B5051, 0xFF3A4F50, 0xFF384D4E, 0xFF314E49, 0xFF32514B, 0xFF2F5047, 0xFF284C42, 0xFF3C6255, 0xFF557E6E, 0xFF588372, 0xFF598471, 0xFF5F8375, 0xFF5D8374, 0xFF588171, 0xFF5F8576, 0xFF527064, 0x00D4E5DD, 0x00FEFFFD, 0x00FFFCFC, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x0FEDFFFF, 0x08F1FFFF, 0xFFB8D2C9, 0xFF466659, 0xFF638877, 0xFF6A917F, 0xFF567F6F, 0xFF4A7564, 0xFF496F64, 0xFF496F64, 0xFF53796E, 0xFF496F64, 0xFF52786D,
    0xFF4D7368, 0xFF4A7065, 0xFF4E7469, 0xFF628A72, 0xFF5A7A63, 0xFF576F57, 0xFF586750, 0xFF616D55, 0xFF495843, 0xFF3C543E, 0xFF3A5640, 0xFF35442D, 0xFF38412C, 0xFF515240, 0xFF504F3D, 0xFF596050, 0xFF465D4B, 0xFF527B69, 0xFF558A76, 0xFF538770,
    0xFF568A73, 0xFF588974, 0xFF578672, 0xFF54836F, 0xFF558170, 0xFF578372, 0xFF5C8776, 0xFF5A8574, 0xFF5A8574, 0xFF5A8574, 0xFF5B8675, 0xFF5B8675, 0xFF5B8675, 0xFF5B8675, 0xFF5B8675, 0xFF5A8574, 0xFF5B8675, 0xFF5C8776, 0xFF5D8877, 0xFF5C8776,
    0xFF568170, 0xFF4C7766, 0xFF467160, 0xFF456B5C, 0xFF446A5B, 0xFF406657, 0xFF446A5B, 0xFF426859, 0xFF406657, 0xFF476D5E, 0xFF406657, 0xFF406755, 0xFF3F6654, 0xFF3D6452, 0xFF3D6452, 0xFF3D6452, 0xFF3F6654, 0xFF416856, 0xFF436A58, 0xFF466858,
    0xFF426454, 0xFF406252, 0xFF456757, 0xFF476959, 0xFF466858, 0xFF426454, 0xFF426454, 0xFF466C5D, 0xFF3A6051, 0xFF416758, 0xFF466C5D, 0xFF486E5F, 0xFF476D5E, 0xFF3A6051, 0xFF416758, 0xFF476C5B, 0xFF4B7260, 0xFF557C6A, 0xFF5C8573, 0xFF598471,
    0xFF56816E, 0xFF55826E, 0xFF517E6A, 0xFF578674, 0xFF538270, 0xFF568271, 0xFF588473, 0xFF5F8A79, 0xFF5C8575, 0xFF5F8878, 0xFF5B8474, 0xFF5A8373, 0xFF598272, 0xFF598272, 0xFF5A8373, 0xFF5A8373, 0xFF5B8474, 0xFF5B8474, 0xFF5B8474, 0xFF598270,
    0xFF598270, 0xFF58816F, 0xFF58816F, 0xFF58816F, 0xFF58816F, 0xFF58816F, 0xFF598270, 0xFF598270, 0xFF598270, 0xFF598270, 0xFF598270, 0xFF58816F, 0xFF58816F, 0xFF58816F, 0xFF58816F, 0xFF55806D, 0xFF547F6C, 0xFF537E6B, 0xFF547F6C, 0xFF57826F,
    0xFF588370, 0xFF57826F, 0xFF56816E, 0xFF58816F, 0xFF567F6D, 0xFF547D6B, 0xFF547D6B, 0xFF557E6C, 0xFF567F6D, 0xFF567F6D, 0xFF567F6D, 0xFF57826F, 0xFF588370, 0xFF547D6B, 0xFF59806E, 0xFF5E8573, 0xFF385D4C, 0xFF0F3121, 0xFF193B2B, 0xFF1A3B2A,
    0xFF1A3929, 0xFF1B3728, 0xFF1A3526, 0xFF1A3526, 0xFF1B3728, 0xFF1A3929, 0xFF173827, 0xFF19392E, 0xFF19392E, 0xFF113227, 0xFF234439, 0xFF4C6D62, 0xFF587C70, 0xFF567A6E, 0xFF608478, 0xFF578672, 0xFF5D8A76, 0xFF5E8976, 0xFF6A917F, 0xFF789F8D,
    0xFF618876, 0xFF48715F, 0xFF3B6653, 0xFF497262, 0xFF517A6A, 0xFF4D7666, 0xFF436C5C, 0xFF507969, 0xFF466F5F, 0xFF456E5E, 0xFF507969, 0xFF517162, 0xFF557767, 0xFF648B79, 0xFF658E7E, 0xFF416C5B, 0xFF466F61, 0xFF5A8073, 0xFF2D5346, 0xFF1E4435,
    0xFF467261, 0xFF467764, 0xFF2C5746, 0xFF58786B, 0xFF536F63, 0xFF466C5D, 0xFF437461, 0xFF3B6454, 0xFF436C5C, 0xFF517C6B, 0xFF598473, 0xFF578072, 0xFF476B5F, 0xFF2E4E43, 0xFF234137, 0xFF20433D, 0xFF22453F, 0xFF244741, 0xFF254842, 0xFF254842,
    0xFF254842, 0xFF264943, 0xFF274A44, 0xFF24483C, 0xFF274B3F, 0xFF23473B, 0xFF1D4336, 0xFF365F51, 0xFF598272, 0xFF5D8877, 0xFF5A8574, 0xFF608476, 0xFF5E8475, 0xFF5A8373, 0xFF608677, 0xFF537165, 0x00D4E5DD, 0x00FEFFFD, 0x00FFFDFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F7FFF9, 0x00F5FFFB, 0xFFC0D8CB, 0xFF466756, 0xFF6A9480, 0xFF68937F, 0xFF3A6752, 0xFF14412C, 0xFF1E4739, 0xFF1B4436, 0xFF1F483A, 0xFF0D3628, 0xFF214A3C,
    0xFF1E4739, 0xFF1A4335, 0xFF254E40, 0xFF707869, 0xFF6A6B5B, 0xFF736656, 0xFF907667, 0xFFC5A598, 0xFFC4A89A, 0xFFC0AA9D, 0xFFB3A396, 0xFFB4A689, 0xFFAF9E84, 0xFFB39A86, 0xFF846D5D, 0xFF716859, 0xFF4A5946, 0xFF547E66, 0xFF599478, 0xFF608B77,
    0xFF628D79, 0xFF5E8B77, 0xFF5B8874, 0xFF598874, 0xFF578674, 0xFF578674, 0xFF598A77, 0xFF598473, 0xFF598473, 0xFF598473, 0xFF598473, 0xFF5A8574, 0xFF5A8574, 0xFF5A8574, 0xFF5B8675, 0xFF5A8574, 0xFF5B8675, 0xFF5A8574, 0xFF5B8675, 0xFF5C8776,
    0xFF527D6C, 0xFF416C5B, 0xFF366150, 0xFF395F50, 0xFF3F6556, 0xFF3A6051, 0xFF3F6556, 0xFF3E6455, 0xFF385E4F, 0xFF416758, 0xFF3D6354, 0xFF3A614F, 0xFF3A614F, 0xFF3B6250, 0xFF3C6351, 0xFF3C6351, 0xFF3D6452, 0xFF3E6553, 0xFF3E6553, 0xFF385F4D,
    0xFF3D6452, 0xFF3C6351, 0xFF3D6452, 0xFF3A614F, 0xFF406755, 0xFF3E6553, 0xFF3D6452, 0xFF365F4D, 0xFF3F6856, 0xFF406957, 0xFF355E4C, 0xFF3C6553, 0xFF3B6452, 0xFF305947, 0xFF436C5A, 0xFF3A614F, 0xFF436A58, 0xFF4E7563, 0xFF5B8472, 0xFF5F8876,
    0xFF5C8573, 0xFF5D8674, 0xFF598471, 0xFF54806F, 0xFF598574, 0xFF558170, 0xFF588473, 0xFF598473, 0xFF568170, 0xFF5F8A79, 0xFF55806F, 0xFF5D8676, 0xFF5C8575, 0xFF5B8474, 0xFF5B8474, 0xFF5C8575, 0xFF5D8676, 0xFF5D8676, 0xFF5D8676, 0xFF57826F,
    0xFF56816E, 0xFF56816E, 0xFF55806D, 0xFF55806D, 0xFF56816E, 0xFF56816E, 0xFF57826F, 0xFF58816F, 0xFF57806E, 0xFF57806E, 0xFF567F6D, 0xFF567F6D, 0xFF557E6C, 0xFF557E6C, 0xFF557E6C, 0xFF598473, 0xFF588372, 0xFF537E6D, 0xFF517C6B, 0xFF55806F,
    0xFF568170, 0xFF55806F, 0xFF578271, 0xFF598270, 0xFF58816F, 0xFF567F6D, 0xFF567F6D, 0xFF57806E, 0xFF57806E, 0xFF57806E, 0xFF567F6D, 0xFF57826F, 0xFF56816E, 0xFF557E6C, 0xFF57806E, 0xFF598270, 0xFF3C6351, 0xFF153C2A, 0xFF143B29, 0xFF173921,
    0xFF14361E, 0xFF15371F, 0xFF173921, 0xFF12341C, 0xFF12341C, 0xFF163820, 0xFF163820, 0xFF15362B, 0xFF15362B, 0xFF123328, 0xFF25493D, 0xFF4F7367, 0xFF5F8578, 0xFF5A8073, 0xFF5B8174, 0xFF5B8874, 0xFF5B8874, 0xFF5D8875, 0xFF648F7C, 0xFF57806E,
    0xFF436C5A, 0xFF3E6755, 0xFF4C7361, 0xFF3F6858, 0xFF477060, 0xFF4D7666, 0xFF456E5E, 0xFF456E5E, 0xFF3D6656, 0xFF416A5A, 0xFF456E5E, 0xFF5C8170, 0xFF739887, 0xFF678E7C, 0xFF496F60, 0xFF456E5E, 0xFF50796B, 0xFF3A6456, 0xFF123C2E, 0xFF55796B,
    0xFF416D5C, 0xFF1C4F3C, 0xFF1F4E3C, 0xFF55796B, 0xFF59796C, 0xFF496F60, 0xFF376654, 0xFF406C5B, 0xFF568170, 0xFF5A8574, 0xFF567F6F, 0xFF628879, 0xFF5B806F, 0xFF345646, 0xFF123424, 0xFF103A2E, 0xFF133D31, 0xFF153F33, 0xFF153F33, 0xFF123C30,
    0xFF123C30, 0xFF143E32, 0xFF174135, 0xFF1A3E30, 0xFF1A3E30, 0xFF163C2D, 0xFF173D2E, 0xFF365C4D, 0xFF5B8174, 0xFF5C8577, 0xFF567F71, 0xFF608476, 0xFF5F8576, 0xFF5B8474, 0xFF608677, 0xFF516F63, 0x00D2E3DB, 0x00FEFFFD, 0x00FFFDFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFEF8, 0x00FDFEF8, 0xFFC1CEC5, 0xFF435D50, 0xFF6D8F7F, 0xFF6A917F, 0xFF3F6955, 0xFF1A442E, 0xFF456A58, 0xFF3E6351, 0xFF375C4A, 0xFF1E4331, 0xFF395E4C,
    0xFF305543, 0xFF1E4331, 0xFF284D3B, 0xFF617E6A, 0xFF556855, 0xFF686957, 0xFFA69988, 0xFFF8E3D2, 0xFFF6E5D3, 0xFFF0E5D3, 0xFFE2DDCA, 0xFFFAE2D5, 0xFFFDE7DA, 0xFFE9D7CD, 0xFF8B8279, 0xFF6A6D62, 0xFF445648, 0xFF547562, 0xFF527C66, 0xFF546A5D,
    0xFF51695B, 0xFF466053, 0xFF426152, 0xFF486A5A, 0xFF476D5E, 0xFF416C5B, 0xFF416C5B, 0xFF598473, 0xFF588372, 0xFF588372, 0xFF578271, 0xFF578271, 0xFF588372, 0xFF598473, 0xFF5A8574, 0xFF598473, 0xFF5B8675, 0xFF588372, 0xFF5B8675, 0xFF5E8978,
    0xFF507B6A, 0xFF396453, 0xFF2B5645, 0xFF1A4031, 0xFF264C3D, 0xFF13392A, 0xFF163C2D, 0xFF254B3C, 0xFF1B4132, 0xFF173D2E, 0xFF153B2C, 0xFF183F2C, 0xFF19402D, 0xFF1B422F, 0xFF1B422F, 0xFF1B422F, 0xFF1A412E, 0xFF183F2C, 0xFF173E2B, 0xFF16412D,
    0xFF1C4733, 0xFF194430, 0xFF194430, 0xFF123D29, 0xFF1A4531, 0xFF16412D, 0xFF143F2B, 0xFF1C4630, 0xFF17412B, 0xFF19432D, 0xFF16402A, 0xFF123C26, 0xFF18422C, 0xFF18422C, 0xFF0F3923, 0xFF234C3A, 0xFF345D4B, 0xFF446D5B, 0xFF59806E, 0xFF5F8674,
    0xFF5C8170, 0xFF608574, 0xFF608272, 0xFF597F70, 0xFF5D8374, 0xFF588171, 0xFF5F8878, 0xFF578271, 0xFF5B8776, 0xFF608C7B, 0xFF5C8877, 0xFF5F8878, 0xFF5D8676, 0xFF5B8474, 0xFF5A8373, 0xFF5B8474, 0xFF5C8575, 0xFF5B8474, 0xFF5A8373, 0xFF598471,
    0xFF588370, 0xFF588370, 0xFF588370, 0xFF588370, 0xFF588370, 0xFF598471, 0xFF598471, 0xFF5A8371, 0xFF598270, 0xFF598270, 0xFF598270, 0xFF598270, 0xFF598270, 0xFF598270, 0xFF598270, 0xFF5A8373, 0xFF5B8474, 0xFF557E6E, 0xFF537C6C, 0xFF578070,
    0xFF578070, 0xFF578070, 0xFF5B8474, 0xFF5C8573, 0xFF5B8472, 0xFF5A8371, 0xFF5A8371, 0xFF5A8371, 0xFF5A8371, 0xFF58816F, 0xFF57806E, 0xFF55806D, 0xFF547F6C, 0xFF588370, 0xFF598471, 0xFF5C8774, 0xFF537E6B, 0xFF416C59, 0xFF416C59, 0xFF4C6D5A,
    0xFF4B6E5A, 0xFF4A705B, 0xFF4B715C, 0xFF4B715C, 0xFF496F5A, 0xFF496C58, 0xFF4B6C59, 0xFF466A5C, 0xFF4A6E60, 0xFF496D5F, 0xFF4C7263, 0xFF597F70, 0xFF5D8374, 0xFF578070, 0xFF598272, 0xFF5A8371, 0xFF598270, 0xFF588370, 0xFF5A8572, 0xFF3E6956,
    0xFF47705E, 0xFF476C5B, 0xFF3F6453, 0xFF4C7263, 0xFF4D7364, 0xFF496F60, 0xFF406657, 0xFF406657, 0xFF456B5C, 0xFF4A7061, 0xFF496F60, 0xFF577E6C, 0xFF4C7160, 0xFF436857, 0xFF3E6254, 0xFF517567, 0xFF3F6558, 0xFF1F493B, 0xFF477163, 0xFF56786A,
    0xFF1C4736, 0xFF1F523F, 0xFF467764, 0xFF4F7365, 0xFF406053, 0xFF3F6355, 0xFF426D5C, 0xFF51806E, 0xFF5D8978, 0xFF588372, 0xFF557C6A, 0xFF5F8473, 0xFF628775, 0xFF527765, 0xFF3F6452, 0xFF43695A, 0xFF446A5B, 0xFF446A5B, 0xFF446A5B, 0xFF43695A,
    0xFF43695A, 0xFF446A5B, 0xFF466C5D, 0xFF446958, 0xFF436857, 0xFF436857, 0xFF436759, 0xFF54786A, 0xFF64887C, 0xFF5F8377, 0xFF5E8276, 0xFF5E8274, 0xFF5E8475, 0xFF5B8474, 0xFF5F8576, 0xFF4E6C60, 0x00CFE0D8, 0x00FDFFFC, 0x00FFFDFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFBFF, 0x00FAF8FB, 0xFFC6D1D3, 0xFF4B6363, 0xFF6E918D, 0xFF628B83, 0xFF3D675D, 0xFF1E483C, 0xFF4F7664, 0xFF4B7260, 0xFF466D5B, 0xFF305745, 0xFF537A68,
    0xFF416856, 0xFF1D4432, 0xFF1E4533, 0xFF5C8179, 0xFF425C53, 0xFF585D56, 0xFFA99E98, 0xFFFCE9E3, 0xFFE3D2CB, 0xFFD1C8C1, 0xFFCCC9C2, 0xFFDAC6C8, 0xFFEEE2E4, 0xFFDADCDB, 0xFF697976, 0xFF49625C, 0xFF2F4940, 0xFF3F544B, 0xFF31453A, 0xFF5F625B,
    0xFF525951, 0xFF3F4A42, 0xFF37483E, 0xFF3D5548, 0xFF3C584C, 0xFF2F5143, 0xFF294D3F, 0xFF598473, 0xFF588372, 0xFF568170, 0xFF568170, 0xFF568170, 0xFF578271, 0xFF598473, 0xFF5A8574, 0xFF598473, 0xFF5A8574, 0xFF578271, 0xFF5A8574, 0xFF5F8A79,
    0xFF507B6A, 0xFF35604F, 0xFF25503F, 0xFF33594A, 0xFF3F6556, 0xFF1C4233, 0xFF1F4536, 0xFF406657, 0xFF33594A, 0xFF1E4435, 0xFF1A4031, 0xFF19402D, 0xFF1A412E, 0xFF1B422F, 0xFF1C4330, 0xFF1D4431, 0xFF1C4330, 0xFF1C4330, 0xFF1B422F, 0xFF184832,
    0xFF184832, 0xFF13432D, 0xFF1A4A34, 0xFF164630, 0xFF1B4B35, 0xFF15452F, 0xFF164630, 0xFF1B452D, 0xFF1E4830, 0xFF19432B, 0xFF1B452D, 0xFF1B452D, 0xFF164028, 0xFF19432B, 0xFF18422A, 0xFF194431, 0xFF315C49, 0xFF47705E, 0xFF5E8573, 0xFF658777,
    0xFF5F7F70, 0xFF638273, 0xFF628172, 0xFF658779, 0xFF5C7E70, 0xFF587C6E, 0xFF628879, 0xFF547F6E, 0xFF5A8675, 0xFF52816F, 0xFF568573, 0xFF598272, 0xFF578070, 0xFF567F6F, 0xFF567F6F, 0xFF598272, 0xFF5B8474, 0xFF5B8474, 0xFF5A8373, 0xFF56816E,
    0xFF56816E, 0xFF55806D, 0xFF55806D, 0xFF55806D, 0xFF56816E, 0xFF57826F, 0xFF57826F, 0xFF56816E, 0xFF56816E, 0xFF56816E, 0xFF57826F, 0xFF57826F, 0xFF57826F, 0xFF588370, 0xFF588370, 0xFF577D6E, 0xFF5B8172, 0xFF587E6F, 0xFF587E6F, 0xFF5D8374,
    0xFF5C8273, 0xFF5A8071, 0xFF5E8475, 0xFF588370, 0xFF588370, 0xFF57826F, 0xFF57826F, 0xFF57826F, 0xFF56816E, 0xFF547F6C, 0xFF527D6A, 0xFF5A8371, 0xFF55806D, 0xFF57826F, 0xFF527D6A, 0xFF527D6A, 0xFF57826F, 0xFF57826F, 0xFF5C8774, 0xFF628277,
    0xFF65867B, 0xFF5D8175, 0xFF597F72, 0xFF608679, 0xFF618579, 0xFF5E7F74, 0xFF628277, 0xFF608574, 0xFF628776, 0xFF608574, 0xFF5C8371, 0xFF5D8472, 0xFF5B8472, 0xFF598270, 0xFF598270, 0xFF5B8270, 0xFF67907E, 0xFF4B7462, 0xFF3F6A57, 0xFF365F4D,
    0xFF4A715F, 0xFF3E6050, 0xFF4B6B5C, 0xFF3A5E50, 0xFF507466, 0xFF527668, 0xFF4E7264, 0xFF4F7365, 0xFF507466, 0xFF4A6E60, 0xFF507466, 0xFF507765, 0xFF4C7160, 0xFF527464, 0xFF5C7E70, 0xFF345648, 0xFF1C4235, 0xFF456E60, 0xFF4F796B, 0xFF204033,
    0xFF244F3E, 0xFF407360, 0xFF3C6D5A, 0xFF3F6355, 0xFF5F7D71, 0xFF5E8072, 0xFF517A6A, 0xFF4F806D, 0xFF4F7B6A, 0xFF517A6A, 0xFF587F6D, 0xFF577C6A, 0xFF517664, 0xFF557B66, 0xFF5B826D, 0xFF5E7D6D, 0xFF5C7B6B, 0xFF5B7A6A, 0xFF5B7A6A, 0xFF5D7C6C,
    0xFF5E7D6D, 0xFF5E7D6D, 0xFF5D7C6C, 0xFF597E6C, 0xFF5C7E6D, 0xFF628474, 0xFF628474, 0xFF628476, 0xFF5E7F74, 0xFF57786D, 0xFF608176, 0xFF5C8072, 0xFF5D8374, 0xFF5B8474, 0xFF5E8475, 0xFF4C6A5E, 0x00CCDDD5, 0x00FBFDFA, 0x00FFFDFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFEFF, 0x00FBFBFB, 0xFFBACFC8, 0xFF3D6958, 0xFF679281, 0xFF708F80, 0xFF426756, 0xFF175139, 0xFF4D7462, 0xFF1F4634, 0xFF4F7664, 0xFF244B39, 0xFF3E6553,
    0xFF446B59, 0xFF1C4331, 0xFF234A38, 0xFF548065, 0xFF577961, 0xFF586957, 0xFFADAFA2, 0xFFE8E1D7, 0xFFE1D8CF, 0xFFD4D0C5, 0xFFBDBDB1, 0xFFDFCDC9, 0xFFE2D4D1, 0xFFDDD5D3, 0xFF9D9D9B, 0xFF717A75, 0xFF6E7F75, 0xFF4E6656, 0xFF5A7562, 0xFFA19D9C,
    0xFF7B7A78, 0xFF686866, 0xFF6D6F6C, 0xFF5B615D, 0xFF89928D, 0xFF79867F, 0xFF313E37, 0xFF5B8776, 0xFF558170, 0xFF54806F, 0xFF578372, 0xFF578372, 0xFF598574, 0xFF5A8675, 0xFF588473, 0xFF5C8776, 0xFF588372, 0xFF598473, 0xFF598272, 0xFF618A7A,
    0xFF4B7464, 0xFF395F50, 0xFF2A5041, 0xFF1F4634, 0xFF49705E, 0xFF406755, 0xFF113826, 0xFF355C4A, 0xFF547B69, 0xFF234A38, 0xFF183F2D, 0xFF19452E, 0xFF16422B, 0xFF15412A, 0xFF1A462F, 0xFF1E4A33, 0xFF1C4831, 0xFF18442D, 0xFF18442D, 0xFF17442F,
    0xFF16432E, 0xFF194631, 0xFF194631, 0xFF16432E, 0xFF1B4833, 0xFF1E4B36, 0xFF184530, 0xFF194631, 0xFF17442D, 0xFF17432C, 0xFF17432C, 0xFF18422A, 0xFF174129, 0xFF174227, 0xFF184026, 0xFF19432F, 0xFF39634F, 0xFF406957, 0xFF5F8876, 0xFF5B8472,
    0xFF5C8575, 0xFF5A8373, 0xFF5E8777, 0xFF5C8776, 0xFF5B8675, 0xFF5A8574, 0xFF5A8574, 0xFF5A8574, 0xFF5A8574, 0xFF5B8675, 0xFF5C8776, 0xFF5D8676, 0xFF5D8676, 0xFF5B8474, 0xFF5A8373, 0xFF5A8373, 0xFF598272, 0xFF598272, 0xFF598272, 0xFF578070,
    0xFF578070, 0xFF588171, 0xFF578070, 0xFF578070, 0xFF567F6F, 0xFF557E6E, 0xFF547D6D, 0xFF557E6C, 0xFF557E6C, 0xFF567F6D, 0xFF567F6D, 0xFF57806E, 0xFF58816F, 0xFF58816F, 0xFF598270, 0xFF578070, 0xFF578070, 0xFF578070, 0xFF578070, 0xFF588171,
    0xFF588171, 0xFF588171, 0xFF588171, 0xFF598272, 0xFF588171, 0xFF588171, 0xFF578070, 0xFF578070, 0xFF578070, 0xFF578070, 0xFF578070, 0xFF577D6E, 0xFF5A8373, 0xFF588171, 0xFF567F6D, 0xFF5A8572, 0xFF598471, 0xFF55826D, 0xFF588570, 0xFF538174,
    0xFF548373, 0xFF548071, 0xFF547F6E, 0xFF547D6B, 0xFF5D8471, 0xFF5A7F6D, 0xFF597E6C, 0xFF5A826A, 0xFF5C836E, 0xFF577E69, 0xFF5A816E, 0xFF5F8473, 0xFF618373, 0xFF628275, 0xFF5B796D, 0xFF618875, 0xFF577E6B, 0xFF567D6A, 0xFF416855, 0xFF3F6653,
    0xFF406754, 0xFF406754, 0xFF385F4C, 0xFF577E6B, 0xFF375E4B, 0xFF2B523F, 0xFF426956, 0xFF446B58, 0xFF2B523F, 0xFF426956, 0xFF416855, 0xFF294B3A, 0xFF4C6E5D, 0xFF3F6452, 0xFF2B503E, 0xFF436A57, 0xFF3F6955, 0xFF426C58, 0xFF26513D, 0xFF213F33,
    0xFF55796B, 0xFF305B4A, 0xFF476D60, 0xFF618176, 0xFF56776E, 0xFF528073, 0xFF3C7765, 0xFF506C60, 0xFF4B6B5E, 0xFF45695B, 0xFF406B5A, 0xFF3F6B5A, 0xFF3F6B5A, 0xFF3E6958, 0xFF3D6656, 0xFF44685A, 0xFF426658, 0xFF436759, 0xFF466A5C, 0xFF476B5D,
    0xFF45695B, 0xFF476B5D, 0xFF4B6F61, 0xFF4F7163, 0xFF486A5C, 0xFF597B6D, 0xFF547666, 0xFF557A69, 0xFF5E8371, 0xFF59806D, 0xFF507A66, 0xFF597E6D, 0xFF59806E, 0xFF57806E, 0xFF598272, 0xFF4E6E61, 0x00C3D8D1, 0x00F9FFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFEFF, 0x00FDFDFD, 0xFFBCD1CA, 0xFF3B6756, 0xFF618C7B, 0xFF698879, 0xFF3C6150, 0xFF104A32, 0xFF577E6C, 0xFF3E6553, 0xFF4D7462, 0xFF214836, 0xFF49705E,
    0xFF4B7260, 0xFF163D2B, 0xFF1E4533, 0xFF61846E, 0xFF49624F, 0xFF5F6A5C, 0xFFBBB7AE, 0xFFEDE0DA, 0xFFDACDC7, 0xFFDACFC9, 0xFFD9D2CA, 0xFFDCCFC9, 0xFFECE3DE, 0xFFD6D2CF, 0xFF919390, 0xFFA8B3AD, 0xFF6D8176, 0xFF354D3D, 0xFF66836F, 0xFFAAAFAB,
    0xFF8A908C, 0xFF59625D, 0xFF5F6A64, 0xFF798881, 0xFF9FB0A8, 0xFF798D84, 0xFF495E55, 0xFF416D5C, 0xFF5F8B7A, 0xFF5D8978, 0xFF517D6C, 0xFF5C8877, 0xFF5C8877, 0xFF537F6E, 0xFF5B8776, 0xFF5D8877, 0xFF598473, 0xFF5B8675, 0xFF5A8373, 0xFF628B7B,
    0xFF4D7666, 0xFF3A6051, 0xFF2C5243, 0xFF113826, 0xFF2E5543, 0xFF4A715F, 0xFF2C5341, 0xFF163D2B, 0xFF416856, 0xFF476E5C, 0xFF133A28, 0xFF1C4831, 0xFF1B4730, 0xFF1A462F, 0xFF1B4730, 0xFF1B4730, 0xFF19452E, 0xFF19452E, 0xFF1A462F, 0xFF194430,
    0xFF194430, 0xFF1A4531, 0xFF1A4531, 0xFF18432F, 0xFF1A4531, 0xFF1B4632, 0xFF194430, 0xFF1C4934, 0xFF1E4935, 0xFF19452E, 0xFF16422B, 0xFF1A442C, 0xFF18422A, 0xFF173F25, 0xFF194127, 0xFF19432F, 0xFF39634F, 0xFF406957, 0xFF5E8775, 0xFF5A8371,
    0xFF5C8575, 0xFF5A8373, 0xFF5D8676, 0xFF5B8675, 0xFF5A8574, 0xFF5A8574, 0xFF5A8574, 0xFF5A8574, 0xFF5A8574, 0xFF5A8574, 0xFF5B8675, 0xFF5B8474, 0xFF5A8373, 0xFF5A8373, 0xFF598272, 0xFF598272, 0xFF598272, 0xFF598272, 0xFF5A8373, 0xFF5A8373,
    0xFF5A8373, 0xFF5A8373, 0xFF5A8373, 0xFF598272, 0xFF588171, 0xFF588171, 0xFF578070, 0xFF567F6D, 0xFF567F6D, 0xFF57806E, 0xFF57806E, 0xFF58816F, 0xFF598270, 0xFF598270, 0xFF598270, 0xFF578070, 0xFF578070, 0xFF578070, 0xFF578070, 0xFF588171,
    0xFF588171, 0xFF588171, 0xFF588171, 0xFF598272, 0xFF588171, 0xFF588171, 0xFF578070, 0xFF578070, 0xFF578070, 0xFF578070, 0xFF578070, 0xFF557E6E, 0xFF547D6D, 0xFF567F6F, 0xFF5A8371, 0xFF5A816F, 0xFF517866, 0xFF4F7663, 0xFF597E6C, 0xFF5C8776,
    0xFF4A7363, 0xFF567C6D, 0xFF577C6B, 0xFF688F7D, 0xFF4D7664, 0xFF57826F, 0xFF63907C, 0xFF567F6D, 0xFF56816E, 0xFF57826F, 0xFF537C6A, 0xFF5B8270, 0xFF5A7C6E, 0xFF4D6B5F, 0xFF597569, 0xFF587A69, 0xFF4F7160, 0xFF507261, 0xFF375948, 0xFF3E604F,
    0xFF426453, 0xFF3C5E4D, 0xFF476958, 0xFF395B4A, 0xFF305241, 0xFF355746, 0xFF446655, 0xFF385A49, 0xFF264837, 0xFF476958, 0xFF476958, 0xFF365545, 0xFF466555, 0xFF385948, 0xFF345645, 0xFF456A58, 0xFF406553, 0xFF3F6653, 0xFF3D6451, 0xFF406053,
    0xFF3C6253, 0xFF436E5D, 0xFF587C70, 0xFF567168, 0xFF47625B, 0xFF31594E, 0xFF3D7262, 0xFF44655C, 0xFF3D6358, 0xFF355F53, 0xFF2F5D50, 0xFF2C5C4E, 0xFF2A5A4C, 0xFF285649, 0xFF275346, 0xFF285246, 0xFF265044, 0xFF275145, 0xFF2A5448, 0xFF2B5549,
    0xFF2A5448, 0xFF2C564A, 0xFF315B4F, 0xFF355F51, 0xFF3C6557, 0xFF426358, 0xFF4A685C, 0xFF4E6C60, 0xFF527263, 0xFF527766, 0xFF517A68, 0xFF577C6B, 0xFF577E6C, 0xFF557E6C, 0xFF597F70, 0xFF4C6C5F, 0x00C3D6D0, 0x00FAFFFE, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFE, 0x00FEFEFE, 0xFFBBD0C9, 0xFF3E6A59, 0xFF679281, 0xFF6F8E7F, 0xFF426756, 0xFF124C34, 0xFF4E7563, 0xFF4B7260, 0xFF426957, 0xFF264D3B, 0xFF49705E,
    0xFF4C7361, 0xFF214836, 0xFF264D3B, 0xFF657F72, 0xFF3E5247, 0xFF5E655E, 0xFFACA7A4, 0xFFF6EAEA, 0xFFEDE1E1, 0xFFDFD5D4, 0xFFDBD3D1, 0xFFDEDBD2, 0xFFDEDDD8, 0xFFD4D6D1, 0xFF656E6B, 0xFF768580, 0xFF5D7367, 0xFF4A6657, 0xFF3A5A45, 0xFF40544B,
    0xFF5A6E65, 0xFF4A5F56, 0xFF435A50, 0xFF405A4F, 0xFF486458, 0xFF426054, 0xFF5A7A6D, 0xFF34604F, 0xFF4D7968, 0xFF5F8B7A, 0xFF5C8877, 0xFF578372, 0xFF598574, 0xFF5B8776, 0xFF588473, 0xFF5D8877, 0xFF5A8574, 0xFF5C8776, 0xFF5B8474, 0xFF638C7C,
    0xFF4E7767, 0xFF3C6253, 0xFF2E5445, 0xFF3B6250, 0xFF103725, 0xFF365D4B, 0xFF557C6A, 0xFF19402E, 0xFF1D4432, 0xFF537A68, 0xFF385F4D, 0xFF16412D, 0xFF17422E, 0xFF18432F, 0xFF17422E, 0xFF15402C, 0xFF17422E, 0xFF1A4531, 0xFF1B4632, 0xFF1B4632,
    0xFF1C4733, 0xFF1B4632, 0xFF1B4632, 0xFF1B4632, 0xFF1A4531, 0xFF194430, 0xFF1B4632, 0xFF194430, 0xFF1C4733, 0xFF16422B, 0xFF143E28, 0xFF19432D, 0xFF1A422A, 0xFF173F27, 0xFF194129, 0xFF18422E, 0xFF39634F, 0xFF3F6856, 0xFF5E8775, 0xFF598270,
    0xFF5B8474, 0xFF598272, 0xFF5C8575, 0xFF598473, 0xFF598473, 0xFF598473, 0xFF5A8574, 0xFF5A8574, 0xFF598473, 0xFF598473, 0xFF598473, 0xFF598272, 0xFF588171, 0xFF588171, 0xFF588171, 0xFF588171, 0xFF598272, 0xFF5A8373, 0xFF5A8373, 0xFF5A8373,
    0xFF5A8373, 0xFF5A8373, 0xFF5A8373, 0xFF5A8373, 0xFF598272, 0xFF588171, 0xFF578070, 0xFF57806E, 0xFF57806E, 0xFF58816F, 0xFF58816F, 0xFF598270, 0xFF598270, 0xFF5A8371, 0xFF5A8371, 0xFF578070, 0xFF578070, 0xFF578070, 0xFF578070, 0xFF588171,
    0xFF588171, 0xFF588171, 0xFF588171, 0xFF598272, 0xFF588171, 0xFF588171, 0xFF578070, 0xFF578070, 0xFF578070, 0xFF578070, 0xFF578070, 0xFF568271, 0xFF55806F, 0xFF557E6E, 0xFF517665, 0xFF426454, 0xFF395849, 0xFF3B5748, 0xFF405C4D, 0xFF436652,
    0xFF3E5F4C, 0xFF3D594A, 0xFF3B5749, 0xFF507061, 0xFF4E7767, 0xFF518171, 0xFF4B826F, 0xFF578177, 0xFF568275, 0xFF5B877A, 0xFF517D6E, 0xFF598272, 0xFF507264, 0xFF365244, 0xFF526A5D, 0xFF334E3F, 0xFF385344, 0xFF425D4E, 0xFF233E2F, 0xFF395445,
    0xFF3B5647, 0xFF213C2D, 0xFF445F50, 0xFF466152, 0xFF264132, 0xFF647F70, 0xFF3E594A, 0xFF254031, 0xFF415C4D, 0xFF264132, 0xFF3B5647, 0xFF5B7164, 0xFF2B4335, 0xFF385344, 0xFF516D5E, 0xFF244333, 0xFF325342, 0xFF4C6E5D, 0xFF325745, 0xFF46685A,
    0xFF315A4A, 0xFF467160, 0xFF45665B, 0xFF485F57, 0xFF697E79, 0xFF4C6B63, 0xFF2F594D, 0xFF366158, 0xFF2E5C52, 0xFF24584C, 0xFF205649, 0xFF1C5447, 0xFF1A5245, 0xFF1A4E42, 0xFF194B40, 0xFF194C43, 0xFF194C43, 0xFF1A4D44, 0xFF1B4E45, 0xFF1C4F46,
    0xFF1C4F46, 0xFF1F5249, 0xFF23564D, 0xFF205648, 0xFF38665B, 0xFF32534C, 0xFF49605A, 0xFF495E59, 0xFF4B655C, 0xFF4F6F64, 0xFF577D70, 0xFF577969, 0xFF557C6A, 0xFF547D6B, 0xFF587E6F, 0xFF4B6B5E, 0x00C2D5CF, 0x00FAFFFE, 0x00FFFEFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFEFF, 0x00FEFEFE, 0xFFB8CDC6, 0xFF3B6756, 0xFF648F7E, 0xFF6A897A, 0xFF3D6251, 0xFF0B452D, 0xFF204735, 0xFF214836, 0xFF1C4331, 0xFF183F2D, 0xFF204735,
    0xFF264D3B, 0xFF19402E, 0xFF183F2D, 0xFF5C7A6E, 0xFF607A6F, 0xFF85968E, 0xFF97A09B, 0xFFDCDEDB, 0xFFDFE1DE, 0xFFD2D4D1, 0xFFDBE0DC, 0xFFD3DBD0, 0xFFECF6ED, 0xFFC5D2CB, 0xFF61726C, 0xFF9CB3AB, 0xFF779387, 0xFF537463, 0xFF6E8F7C, 0xFF5D7F71,
    0xFF5D7F71, 0xFF56786A, 0xFF5E8274, 0xFF5C8273, 0xFF5C8273, 0xFF446D5D, 0xFF396252, 0xFF376251, 0xFF376251, 0xFF4D7867, 0xFF608B7A, 0xFF5B8675, 0xFF598473, 0xFF5D8877, 0xFF598473, 0xFF5C8776, 0xFF5A8574, 0xFF5C8776, 0xFF5B8474, 0xFF628B7B,
    0xFF4D7666, 0xFF3C6253, 0xFF2E5445, 0xFF5C8371, 0xFF355C4A, 0xFF1C4331, 0xFF406755, 0xFF476E5C, 0xFF1B4230, 0xFF264D3B, 0xFF59806E, 0xFF244E3A, 0xFF224C38, 0xFF224C38, 0xFF204A36, 0xFF1D4733, 0xFF1F4935, 0xFF214B37, 0xFF1D4733, 0xFF1D4733,
    0xFF1E4834, 0xFF1C4632, 0xFF1D4733, 0xFF1F4935, 0xFF1D4733, 0xFF1B4531, 0xFF1F4935, 0xFF1C4733, 0xFF1B4632, 0xFF1B4531, 0xFF1A442E, 0xFF1B422D, 0xFF1D442F, 0xFF1B432B, 0xFF173D26, 0xFF18422E, 0xFF38624E, 0xFF3F6856, 0xFF5D8674, 0xFF598270,
    0xFF5A8373, 0xFF588171, 0xFF5B8474, 0xFF578271, 0xFF588372, 0xFF598473, 0xFF598473, 0xFF598473, 0xFF598473, 0xFF588372, 0xFF578271, 0xFF5A8373, 0xFF598272, 0xFF598272, 0xFF588171, 0xFF598272, 0xFF598272, 0xFF5A8373, 0xFF5A8373, 0xFF588171,
    0xFF598272, 0xFF598272, 0xFF598272, 0xFF588171, 0xFF578070, 0xFF567F6F, 0xFF567F6F, 0xFF57806E, 0xFF57806E, 0xFF58816F, 0xFF58816F, 0xFF58816F, 0xFF598270, 0xFF598270, 0xFF598270, 0xFF578070, 0xFF578070, 0xFF578070, 0xFF578070, 0xFF588171,
    0xFF588171, 0xFF588171, 0xFF588171, 0xFF598272, 0xFF588171, 0xFF588171, 0xFF578070, 0xFF578070, 0xFF578070, 0xFF578070, 0xFF578070, 0xFF537F6E, 0xFF598574, 0xFF5C8575, 0xFF4D7261, 0xFF3E5D4E, 0xFF455F52, 0xFF53695C, 0xFF52665A, 0xFF415E4A,
    0xFF4D6855, 0xFF425949, 0xFF586E61, 0xFF3B5749, 0xFF3B6152, 0xFF336655, 0xFF4E8776, 0xFF5A7E7A, 0xFF557E76, 0xFF568177, 0xFF528073, 0xFF598375, 0xFF4A6C5E, 0xFF344E41, 0xFF4E6257, 0xFF182C20, 0xFF34483C, 0xFF42564A, 0xFF162A1E, 0xFF3A4E42,
    0xFF3B4F43, 0xFF102418, 0xFF4A5E52, 0xFF3F5347, 0xFF1F3327, 0xFF586C60, 0xFF304438, 0xFF24382C, 0xFF576B5F, 0xFF2E4236, 0xFF2B3F33, 0xFF5E6E63, 0xFF283A2E, 0xFF35493D, 0xFF50685A, 0xFF1A3526, 0xFF335242, 0xFF476857, 0xFF385A49, 0xFF3C6052,
    0xFF3A6353, 0xFF396453, 0xFF3B5B50, 0xFF566963, 0xFF869592, 0xFF758C86, 0xFF2F5349, 0xFF30635C, 0xFF285D55, 0xFF1E574E, 0xFF18564B, 0xFF165449, 0xFF145046, 0xFF154D44, 0xFF174C44, 0xFF124B44, 0xFF134C45, 0xFF134C45, 0xFF144D46, 0xFF144D46,
    0xFF154E47, 0xFF175049, 0xFF1A534C, 0xFF1F5D4E, 0xFF215348, 0xFF2B4B46, 0xFF6A7D7B, 0xFF627070, 0xFF465955, 0xFF38564E, 0xFF5A8075, 0xFF577969, 0xFF567B6A, 0xFF567D6B, 0xFF587E6F, 0xFF4D6B5F, 0x00C3D6D0, 0x00FAFFFE, 0x00FFFEFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFE, 0x00FFFFFF, 0xFFB9CEC7, 0xFF3C6857, 0xFF618C7B, 0xFF688778, 0xFF4B705F, 0xFF266048, 0xFF345B49, 0xFF335A48, 0xFF305745, 0xFF3B6250, 0xFF325947,
    0xFF325947, 0xFF365D4B, 0xFF365D4B, 0xFF537C6E, 0xFF61877A, 0xFF7A9A8F, 0xFF5C776E, 0xFF748E85, 0xFF728981, 0xFF6E857D, 0xFF819B92, 0xFF799080, 0xFF6E8478, 0xFF6B8278, 0xFF536E67, 0xFF617F77, 0xFF557568, 0xFF537565, 0xFF5D836E, 0xFF5B8675,
    0xFF578271, 0xFF5E8978, 0xFF64907F, 0xFF537F6E, 0xFF588473, 0xFF578372, 0xFF487463, 0xFF3C6756, 0xFF376251, 0xFF345F4E, 0xFF497463, 0xFF638E7D, 0xFF5E8978, 0xFF537E6D, 0xFF5E8978, 0xFF5A8574, 0xFF588372, 0xFF5B8675, 0xFF5A8373, 0xFF618A7A,
    0xFF4B7464, 0xFF3A6051, 0xFF2E5445, 0xFF5A816F, 0xFF5D8472, 0xFF29503E, 0xFF1C4331, 0xFF486F5D, 0xFF385F4D, 0xFF183F2D, 0xFF325947, 0xFF4C7563, 0xFF466F5D, 0xFF47705E, 0xFF497260, 0xFF497260, 0xFF4C7563, 0xFF4D7664, 0xFF47705E, 0xFF4B725F,
    0xFF4C7360, 0xFF4C7360, 0xFF4D7461, 0xFF4E7562, 0xFF4E7562, 0xFF4E7562, 0xFF4F7663, 0xFF4B7462, 0xFF456E5C, 0xFF4A7460, 0xFF4D7461, 0xFF466D5A, 0xFF496F5A, 0xFF496F5A, 0xFF395F4A, 0xFF18422E, 0xFF38624E, 0xFF3F6856, 0xFF5D8674, 0xFF58816F,
    0xFF5A8373, 0xFF578070, 0xFF5A8373, 0xFF578271, 0xFF578271, 0xFF588372, 0xFF598473, 0xFF598473, 0xFF588372, 0xFF578271, 0xFF578271, 0xFF5D8676, 0xFF5C8575, 0xFF5B8474, 0xFF5A8373, 0xFF598272, 0xFF598272, 0xFF598272, 0xFF598272, 0xFF598272,
    0xFF598272, 0xFF598272, 0xFF598272, 0xFF598272, 0xFF588171, 0xFF578070, 0xFF567F6F, 0xFF567F6D, 0xFF57806E, 0xFF57806E, 0xFF57806E, 0xFF57806E, 0xFF57806E, 0xFF57806E, 0xFF57806E, 0xFF578070, 0xFF578070, 0xFF578070, 0xFF578070, 0xFF588171,
    0xFF588171, 0xFF588171, 0xFF588171, 0xFF598272, 0xFF588171, 0xFF588171, 0xFF578070, 0xFF578070, 0xFF578070, 0xFF578070, 0xFF578070, 0xFF537F6E, 0xFF598574, 0xFF5C8575, 0xFF4D7261, 0xFF3D5C4D, 0xFF445E51, 0xFF52685B, 0xFF52665A, 0xFF597461,
    0xFF587060, 0xFF3E5545, 0xFF5C7265, 0xFF4F6A5B, 0xFF557566, 0xFF365F4F, 0xFF285745, 0xFF36514C, 0xFF3C5B55, 0xFF41695E, 0xFF558172, 0xFF5D8779, 0xFF496B5D, 0xFF3B5248, 0xFF44554B, 0xFF1B281E, 0xFF445147, 0xFF4C594F, 0xFF17241A, 0xFF435046,
    0xFF465349, 0xFF1B281E, 0xFF5F6C62, 0xFF47544A, 0xFF233026, 0xFF57645A, 0xFF2B382E, 0xFF27342A, 0xFF657268, 0xFF2F3C32, 0xFF253228, 0xFF626E64, 0xFF253228, 0xFF35453A, 0xFF54685C, 0xFF173223, 0xFF335242, 0xFF466756, 0xFF385A49, 0xFF385C4E,
    0xFF3F6858, 0xFF3A6554, 0xFF3F5F54, 0xFF3C4F49, 0xFF2E3D3A, 0xFF324943, 0xFF2F5349, 0xFF2F675E, 0xFF276057, 0xFF1E5A50, 0xFF1A584D, 0xFF17554A, 0xFF165248, 0xFF1A5249, 0xFF20534C, 0xFF1A514B, 0xFF1B524C, 0xFF1B524C, 0xFF1B524C, 0xFF1B524C,
    0xFF1B524C, 0xFF1A514B, 0xFF19504A, 0xFF165344, 0xFF25574C, 0xFF34544F, 0xFF485B59, 0xFF3C4848, 0xFF50635F, 0xFF46645C, 0xFF4D7167, 0xFF5A7A6B, 0xFF587D6C, 0xFF587F6D, 0xFF5B7F71, 0xFF4E6C60, 0x00C6D7D1, 0x00FCFFFF, 0x00FFFEFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFCFD, 0x00FFFFFF, 0xFFBBD0C9, 0xFF3F6B5A, 0xFF608B7A, 0xFF6A897A, 0xFF648978, 0xFF528C74, 0xFF668D7B, 0xFF668D7B, 0xFF608775, 0xFF678E7C, 0xFF6A917F,
    0xFF628977, 0xFF628977, 0xFF6A917F, 0xFF679382, 0xFF558170, 0xFF618C7B, 0xFF568170, 0xFF5E8777, 0xFF5A8071, 0xFF5B8172, 0xFF658B7C, 0xFF5A7B6A, 0xFF5D7F6F, 0xFF5C7D72, 0xFF52766C, 0xFF4F7369, 0xFF5E8477, 0xFF638A78, 0xFF5E8572, 0xFF5B8A78,
    0xFF578674, 0xFF568573, 0xFF558472, 0xFF4F7B6A, 0xFF598574, 0xFF608C7B, 0xFF5C8877, 0xFF4C7565, 0xFF3B6454, 0xFF315A4A, 0xFF3C6555, 0xFF507969, 0xFF5C8575, 0xFF5B8474, 0xFF588171, 0xFF588372, 0xFF568170, 0xFF5A8574, 0xFF598272, 0xFF5F8878,
    0xFF4A7363, 0xFF3A6051, 0xFF2E5445, 0xFF587F6D, 0xFF638A78, 0xFF315846, 0xFF1A412F, 0xFF426957, 0xFF3C6351, 0xFF1A412F, 0xFF224937, 0xFF4A7361, 0xFF406957, 0xFF436C5A, 0xFF497260, 0xFF47705E, 0xFF497260, 0xFF4B7462, 0xFF466F5D, 0xFF446957,
    0xFF446957, 0xFF476C5A, 0xFF466B59, 0xFF446957, 0xFF486D5B, 0xFF4B705E, 0xFF466B59, 0xFF466F5D, 0xFF426B59, 0xFF4B7260, 0xFF4E7562, 0xFF496E5C, 0xFF4D7260, 0xFF4B715C, 0xFF3C5F4B, 0xFF19432F, 0xFF39634F, 0xFF3F6856, 0xFF5D8674, 0xFF58816F,
    0xFF598272, 0xFF578070, 0xFF5A8373, 0xFF578271, 0xFF588372, 0xFF588372, 0xFF588372, 0xFF588372, 0xFF588372, 0xFF588372, 0xFF578271, 0xFF5E8777, 0xFF5D8676, 0xFF5C8575, 0xFF5B8474, 0xFF5A8373, 0xFF598272, 0xFF598272, 0xFF598272, 0xFF5C8575,
    0xFF5C8575, 0xFF5C8575, 0xFF5C8575, 0xFF5B8474, 0xFF5A8373, 0xFF598272, 0xFF598272, 0xFF567F6D, 0xFF567F6D, 0xFF567F6D, 0xFF567F6D, 0xFF567F6D, 0xFF567F6D, 0xFF567F6D, 0xFF567F6D, 0xFF578070, 0xFF578070, 0xFF578070, 0xFF578070, 0xFF588171,
    0xFF588171, 0xFF588171, 0xFF588171, 0xFF598272, 0xFF588171, 0xFF588171, 0xFF578070, 0xFF578070, 0xFF578070, 0xFF578070, 0xFF578070, 0xFF578372, 0xFF55806F, 0xFF557E6E, 0xFF507564, 0xFF416353, 0xFF375647, 0xFF3A5647, 0xFF3E5A4B, 0xFF3A5648,
    0xFF3D594B, 0xFF3E5A4B, 0xFF3C5849, 0xFF496453, 0xFF466150, 0xFF415949, 0xFF132A18, 0xFF39433A, 0xFF3B4D41, 0xFF315041, 0xFF385F4D, 0xFF3A6353, 0xFF2C4E40, 0xFF2E453D, 0xFF384943, 0xFF131F15, 0xFF354137, 0xFF3C483E, 0xFF131F15, 0xFF38443A,
    0xFF39453B, 0xFF18241A, 0xFF4C584E, 0xFF3A463C, 0xFF18241A, 0xFF525E54, 0xFF232F25, 0xFF1B271D, 0xFF58645A, 0xFF1E2A20, 0xFF273329, 0xFF586259, 0xFF162218, 0xFF2A3A2F, 0xFF4D6356, 0xFF142F20, 0xFF2B4C3B, 0xFF426453, 0xFF2D5240, 0xFF3D5F51,
    0xFF325B4B, 0xFF3B6655, 0xFF4F7065, 0xFF6E857D, 0xFF5E736E, 0xFF36554D, 0xFF2D574B, 0xFF2F645A, 0xFF255D52, 0xFF1E584C, 0xFF1B574B, 0xFF1C564A, 0xFF22574D, 0xFF2D5F56, 0xFF3B6861, 0xFF3A685E, 0xFF3A685E, 0xFF3A685E, 0xFF3A685E, 0xFF3A685E,
    0xFF38665C, 0xFF326056, 0xFF2B594F, 0xFF25594C, 0xFF1C473D, 0xFF385751, 0xFF5F746F, 0xFF576A66, 0xFF5A6F68, 0xFF4A685E, 0xFF5B7F73, 0xFF5C7C6D, 0xFF5C7E6E, 0xFF5B806F, 0xFF5C8072, 0xFF516D61, 0x00C6D7D1, 0x00FCFFFF, 0x00FFFEFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFEFF, 0x00FFFFFF, 0xFFB5CAC3, 0xFF3C6857, 0xFF5C8776, 0xFF638273, 0xFF618675, 0xFF569078, 0xFF608775, 0xFF5F8674, 0xFF5F8674, 0xFF5A816F, 0xFF688F7D,
    0xFF618876, 0xFF5C8371, 0xFF668D7B, 0xFF668D7B, 0xFF5B8270, 0xFF5F8876, 0xFF67927F, 0xFF648F7C, 0xFF5C8573, 0xFF648B79, 0xFF678E7C, 0xFF628D79, 0xFF638E7B, 0xFF628C7E, 0xFF648E82, 0xFF628C80, 0xFF5C8678, 0xFF5A8572, 0xFF5B8672, 0xFF548371,
    0xFF578372, 0xFF568271, 0xFF5A8675, 0xFF5E8978, 0xFF5E8978, 0xFF5A8373, 0xFF5A8373, 0xFF5D8676, 0xFF436C5C, 0xFF3E6757, 0xFF3C6555, 0xFF365F4F, 0xFF4C7565, 0xFF608979, 0xFF547D6D, 0xFF578271, 0xFF568170, 0xFF5A8574, 0xFF5A8373, 0xFF5F8878,
    0xFF4A7363, 0xFF3A6051, 0xFF2E5445, 0xFF567D6B, 0xFF577E6C, 0xFF1E4533, 0xFF2B5240, 0xFF557C6A, 0xFF264D3B, 0xFF153C2A, 0xFF49705E, 0xFF4C7361, 0xFF406755, 0xFF446B59, 0xFF4B7260, 0xFF426957, 0xFF3D6452, 0xFF446B59, 0xFF456C5A, 0xFF486A59,
    0xFF466857, 0xFF4C6E5D, 0xFF4A6C5B, 0xFF426453, 0xFF4C6E5D, 0xFF527463, 0xFF446655, 0xFF3B6454, 0xFF426859, 0xFF426957, 0xFF416856, 0xFF456A58, 0xFF476C5A, 0xFF416352, 0xFF365945, 0xFF1A4430, 0xFF3A6450, 0xFF406957, 0xFF5E8775, 0xFF598270,
    0xFF5A8373, 0xFF578070, 0xFF5A8373, 0xFF588372, 0xFF588372, 0xFF588372, 0xFF578271, 0xFF578271, 0xFF588372, 0xFF588372, 0xFF588372, 0xFF5C8575, 0xFF5B8474, 0xFF5A8373, 0xFF598272, 0xFF598272, 0xFF598272, 0xFF598272, 0xFF5A8373, 0xFF5C8575,
    0xFF5C8575, 0xFF5C8575, 0xFF5C8575, 0xFF5C8575, 0xFF5B8474, 0xFF5A8373, 0xFF598272, 0xFF58816F, 0xFF58816F, 0xFF57806E, 0xFF57806E, 0xFF57806E, 0xFF57806E, 0xFF57806E, 0xFF57806E, 0xFF578070, 0xFF578070, 0xFF578070, 0xFF578070, 0xFF588171,
    0xFF588171, 0xFF588171, 0xFF588171, 0xFF598272, 0xFF588171, 0xFF588171, 0xFF578070, 0xFF578070, 0xFF578070, 0xFF578070, 0xFF578070, 0xFF567F6F, 0xFF557E6E, 0xFF567F6F, 0xFF598270, 0xFF587F6D, 0xFF4E7563, 0xFF4C7360, 0xFF567B69, 0xFF3D5C56,
    0xFF163A30, 0xFF13392A, 0xFF244937, 0xFF42624D, 0xFF3E4F3C, 0xFF535746, 0xFF353221, 0xFF3E3727, 0xFF4C503F, 0xFF4A5D49, 0xFF3F604B, 0xFF3E6552, 0xFF2F5143, 0xFF223933, 0xFF314140, 0xFF172319, 0xFF1C281E, 0xFF222E24, 0xFF111D13, 0xFF253127,
    0xFF212D23, 0xFF101C12, 0xFF232F25, 0xFF1C281E, 0xFF1E2A20, 0xFF263228, 0xFF1F2B21, 0xFF142016, 0xFF263228, 0xFF1C281E, 0xFF152117, 0xFF273329, 0xFF1A271D, 0xFF15271B, 0xFF253B2E, 0xFF254132, 0xFF325443, 0xFF305744, 0xFF37614D, 0xFF3B5B4E,
    0xFF3A6051, 0xFF4C7766, 0xFF45695D, 0xFF4E6960, 0xFF4D6861, 0xFF375F54, 0xFF2E6353, 0xFF316056, 0xFF26584D, 0xFF1C5044, 0xFF194F42, 0xFF1A4E42, 0xFF245248, 0xFF39625A, 0xFF4F746D, 0xFF527466, 0xFF537567, 0xFF527466, 0xFF517365, 0xFF527466,
    0xFF4E7062, 0xFF426456, 0xFF36584A, 0xFF21473A, 0xFF22463A, 0xFF2E4C42, 0xFF3E584D, 0xFF486257, 0xFF557163, 0xFF557566, 0xFF577C6B, 0xFF5E7E6F, 0xFF5D7F6F, 0xFF5B806F, 0xFF5E8072, 0xFF516D61, 0x00C6D5D0, 0x00FDFFFE, 0x00FFFEFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFEFF, 0x00FBFBFB, 0xFFAEC3BC, 0xFF3D6958, 0xFF648F7E, 0xFF698879, 0xFF638877, 0xFF538D75, 0xFF648B79, 0xFF5F8674, 0xFF6C9381, 0xFF5D8472, 0xFF678E7C,
    0xFF658C7A, 0xFF638A78, 0xFF668D7B, 0xFF668371, 0xFF71907E, 0xFF618470, 0xFF618772, 0xFF638974, 0xFF638974, 0xFF658874, 0xFF61826F, 0xFF55856F, 0xFF558472, 0xFF598878, 0xFF568177, 0xFF5E897F, 0xFF568273, 0xFF5F8A79, 0xFF57826E, 0xFF598574,
    0xFF588473, 0xFF598473, 0xFF5B8474, 0xFF588171, 0xFF547A6B, 0xFF567C6D, 0xFF5F8375, 0xFF618A7A, 0xFF598272, 0xFF466F5F, 0xFF365F4F, 0xFF345D4D, 0xFF3D6656, 0xFF4F7868, 0xFF608979, 0xFF578271, 0xFF578271, 0xFF5B8675, 0xFF5A8373, 0xFF608979,
    0xFF4A7363, 0xFF3B6152, 0xFF2F5546, 0xFF59806E, 0xFF244B39, 0xFF173E2C, 0xFF557C6A, 0xFF3F6654, 0xFF123927, 0xFF3F6654, 0xFF4A715F, 0xFF1B4132, 0xFF113728, 0xFF1B4132, 0xFF264C3D, 0xFF1E4435, 0xFF1C4233, 0xFF2B5142, 0xFF355B4C, 0xFF254736,
    0xFF224433, 0xFF2B4D3C, 0xFF274938, 0xFF1B3D2C, 0xFF274938, 0xFF305241, 0xFF1C3E2D, 0xFF294F40, 0xFF345A4B, 0xFF2A513F, 0xFF224736, 0xFF2B503E, 0xFF294B3A, 0xFF193B2A, 0xFF153824, 0xFF1A4430, 0xFF3A6450, 0xFF406957, 0xFF5E8775, 0xFF598270,
    0xFF5A8373, 0xFF578070, 0xFF5A8373, 0xFF598473, 0xFF588372, 0xFF588372, 0xFF578271, 0xFF578271, 0xFF588372, 0xFF588372, 0xFF598473, 0xFF598272, 0xFF598272, 0xFF588171, 0xFF588171, 0xFF588171, 0xFF598272, 0xFF5A8373, 0xFF5A8373, 0xFF5A8373,
    0xFF5A8373, 0xFF5A8373, 0xFF5A8373, 0xFF5A8373, 0xFF598272, 0xFF588171, 0xFF578070, 0xFF598270, 0xFF598270, 0xFF598270, 0xFF58816F, 0xFF58816F, 0xFF58816F, 0xFF58816F, 0xFF58816F, 0xFF578070, 0xFF578070, 0xFF578070, 0xFF578070, 0xFF588171,
    0xFF588171, 0xFF588171, 0xFF588171, 0xFF598272, 0xFF588171, 0xFF588171, 0xFF578070, 0xFF578070, 0xFF578070, 0xFF578070, 0xFF578070, 0xFF587E6F, 0xFF5B8474, 0xFF588171, 0xFF557E6C, 0xFF588370, 0xFF56816E, 0xFF517E69, 0xFF55826D, 0xFF244743,
    0xFF143C34, 0xFF0D392C, 0xFF1E4936, 0xFF22422D, 0xFF475440, 0xFF7E7765, 0xFF7F6C5B, 0xFF7D6C58, 0xFF87826C, 0xFF77856E, 0xFF4B6951, 0xFF3F6550, 0xFF325446, 0xFF1B342E, 0xFF3B4D4D, 0xFF354238, 0xFF1A271D, 0xFF1B281E, 0xFF19261C, 0xFF1E2B21,
    0xFF18251B, 0xFF18251B, 0xFF162319, 0xFF1A271D, 0xFF162319, 0xFF1D2A20, 0xFF1C291F, 0xFF18251B, 0xFF27342A, 0xFF17241A, 0xFF19261C, 0xFF18241A, 0xFF19261C, 0xFF17291D, 0xFF193123, 0xFF1E3D2D, 0xFF365B49, 0xFF3C6652, 0xFF2D5A45, 0xFF405E52,
    0xFF335749, 0xFF477261, 0xFF5D8376, 0xFF5B7B70, 0xFF45665D, 0xFF416F62, 0xFF326D5B, 0xFF356056, 0xFF27554A, 0xFF19493D, 0xFF114135, 0xFF0F3D32, 0xFF184238, 0xFF32554E, 0xFF4A6B64, 0xFF5B7665, 0xFF5B7665, 0xFF5A7564, 0xFF597463, 0xFF5A7564,
    0xFF55705F, 0xFF45604F, 0xFF365140, 0xFF224034, 0xFF2F4D41, 0xFF274539, 0xFF2B4A3B, 0xFF456455, 0xFF517261, 0xFF5F8170, 0xFF597B6A, 0xFF5F7E6F, 0xFF5D7F6F, 0xFF5B806F, 0xFF5E8072, 0xFF506C60, 0x00C5D4CF, 0x00FCFEFD, 0x00FFFCFE, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFEFF, 0x00FEFFFF, 0xFFACC1BA, 0xFF396858, 0xFF5B8778, 0xFF6E8E83, 0xFF4E7266, 0xFF38715E, 0xFF4A7363, 0xFF4B7464, 0xFF4A7363, 0xFF466F5F, 0xFF456E5E,
    0xFF4E7767, 0xFF477060, 0xFF497262, 0xFF658570, 0xFF47624F, 0xFF3B4D3D, 0xFF6A7869, 0xFF4A5849, 0xFF314635, 0xFF2B4633, 0xFF2F503B, 0xFF364236, 0xFF2E3A2E, 0xFF344235, 0xFF425448, 0xFF40584A, 0xFF345445, 0xFF517C69, 0xFF598874, 0xFF5E8976,
    0xFF5D8674, 0xFF5C8573, 0xFF598270, 0xFF608775, 0xFF587F6D, 0xFF5B806F, 0xFF628776, 0xFF5F8576, 0xFF618778, 0xFF5D8374, 0xFF476D5E, 0xFF3B6152, 0xFF385E4F, 0xFF3D6354, 0xFF5B8172, 0xFF5D8374, 0xFF587E6F, 0xFF5E8475, 0xFF577D6E, 0xFF648A7B,
    0xFF507667, 0xFF325849, 0xFF315748, 0xFF254D42, 0xFF194136, 0xFF4A7365, 0xFF477062, 0xFF133C2C, 0xFF2E5747, 0xFF4C7563, 0xFF264F3D, 0xFF16402C, 0xFF123C28, 0xFF315B47, 0xFF446B58, 0xFF3D6451, 0xFF2E5341, 0xFF4C715F, 0xFF355A48, 0xFF274C3A,
    0xFF395E4C, 0xFF3D6451, 0xFF39634F, 0xFF234D39, 0xFF436E5A, 0xFF43705B, 0xFF2D5A45, 0xFF3E6755, 0xFF3E6755, 0xFF2C5642, 0xFF315845, 0xFF446B56, 0xFF426853, 0xFF2B513A, 0xFF143A23, 0xFF16402C, 0xFF37614D, 0xFF3E6854, 0xFF5C8672, 0xFF547E6A,
    0xFF5A8470, 0xFF5C8672, 0xFF59836F, 0xFF5B8270, 0xFF5C8371, 0xFF5C8371, 0xFF5D8472, 0xFF5D8472, 0xFF5E8573, 0xFF5E8573, 0xFF5E8573, 0xFF588475, 0xFF578374, 0xFF588274, 0xFF578173, 0xFF588173, 0xFF598274, 0xFF598274, 0xFF5B8174, 0xFF598272,
    0xFF598272, 0xFF5A8373, 0xFF5B8474, 0xFF5B8474, 0xFF5A8373, 0xFF598272, 0xFF598272, 0xFF5A8574, 0xFF5A8574, 0xFF598473, 0xFF588372, 0xFF588372, 0xFF588372, 0xFF598473, 0xFF598473, 0xFF547D6B, 0xFF567F6D, 0xFF57806E, 0xFF598270, 0xFF5A8371,
    0xFF598270, 0xFF58816F, 0xFF58816F, 0xFF56816E, 0xFF56816E, 0xFF57826F, 0xFF588370, 0xFF588370, 0xFF57826F, 0xFF56816E, 0xFF55806D, 0xFF5B8270, 0xFF5C8371, 0xFF5B8270, 0xFF587F6D, 0xFF59806E, 0xFF5A816F, 0xFF587F6D, 0xFF537A68, 0xFF143E34,
    0xFF254337, 0xFF294131, 0xFF2D4C3C, 0xFF517362, 0xFF5E6F5C, 0xFF9A856A, 0xFFB88162, 0xFFAC8A6F, 0xFF96886D, 0xFF39472E, 0xFF345A43, 0xFF33604C, 0xFF284A3C, 0xFF222F26, 0xFF4F4F47, 0xFF415146, 0xFF3E4E43, 0xFF35453A, 0xFF425247, 0xFF2E3E33,
    0xFF304035, 0xFF3E4E43, 0xFF2D3D32, 0xFF2B3F36, 0xFF364A41, 0xFF2D4138, 0xFF31463F, 0xFF31463F, 0xFF2E453F, 0xFF1B322C, 0xFF122923, 0xFF162927, 0xFF192C28, 0xFF132A24, 0xFF19322C, 0xFF203E34, 0xFF496A5F, 0xFF355B4C, 0xFF3A6051, 0xFF3D5E49,
    0xFF395C46, 0xFF476E5B, 0xFF537E6D, 0xFF49776A, 0xFF467265, 0xFF466F5F, 0xFF406754, 0xFF386359, 0xFF375B4F, 0xFF405546, 0xFF545B49, 0xFF9D9A87, 0xFFB3AC9C, 0xFFBBB1A7, 0xFFB9B0A7, 0xFFBEBCAD, 0xFFBEBCAD, 0xFFBEBCAD, 0xFFBDBBAC, 0xFFBBB9AA,
    0xFFB8B6A7, 0xFFB5B3A4, 0xFFB3B1A2, 0xFFB8B2A4, 0xFFB5AFA1, 0xFFB8B2A4, 0xFFB7B1A3, 0xFFBCB6A8, 0xFFC3BDAF, 0xFFC0BAAC, 0xFFC2BCAE, 0xFFC6C3BC, 0xFF7C8C7F, 0xFF5A7F6D, 0xFF5F8876, 0xFF4F6D61, 0x00C7D3CF, 0x00FEFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FCFAFB, 0x00FCFEFD, 0xFFACC1BA, 0xFF3D6C5C, 0xFF5E8A7B, 0xFF67877C, 0xFF365A4E, 0xFF144D3A, 0xFF184131, 0xFF174030, 0xFF194232, 0xFF184131, 0xFF1A4333,
    0xFF143D2D, 0xFF143D2D, 0xFF1C4535, 0xFF607966, 0xFF4E6050, 0xFF646F61, 0xFF8A8D82, 0xFF8C8E83, 0xFF848A7E, 0xFF778375, 0xFF768777, 0xFF6F796E, 0xFF879186, 0xFF869087, 0xFF525F55, 0xFF32483B, 0xFF3A594A, 0xFF5E8573, 0xFF5A8773, 0xFF5C8371,
    0xFF638A78, 0xFF628977, 0xFF648B79, 0xFF658E7C, 0xFF668F7D, 0xFF5E8775, 0xFF5C8774, 0xFF5D8374, 0xFF557B6C, 0xFF63897A, 0xFF618778, 0xFF43695A, 0xFF365C4D, 0xFF395F50, 0xFF385E4F, 0xFF5C8273, 0xFF5A8071, 0xFF648A7B, 0xFF608677, 0xFF597F70,
    0xFF4D7364, 0xFF416758, 0xFF1E4435, 0xFF123B2B, 0xFF3B6454, 0xFF436C5C, 0xFF1C4533, 0xFF1F4836, 0xFF466F5D, 0xFF3C6652, 0xFF153F2B, 0xFF153F2B, 0xFF18422E, 0xFF325946, 0xFF3B624F, 0xFF345947, 0xFF284D3B, 0xFF456A58, 0xFF2A4C3B, 0xFF143B28,
    0xFF345B48, 0xFF254F3B, 0xFF234D39, 0xFF2A5440, 0xFF355F4B, 0xFF1C4632, 0xFF1D4733, 0xFF416A58, 0xFF2E5745, 0xFF183F2C, 0xFF2A513E, 0xFF4A705B, 0xFF446A55, 0xFF294F38, 0xFF183B25, 0xFF204A36, 0xFF3B6551, 0xFF3F6955, 0xFF5E8874, 0xFF5B8571,
    0xFF618B77, 0xFF5E8874, 0xFF57816D, 0xFF5C8371, 0xFF5D8472, 0xFF5D8472, 0xFF5D8472, 0xFF5D8472, 0xFF5D8472, 0xFF5C8371, 0xFF5C8371, 0xFF5A8675, 0xFF5A8574, 0xFF5A8574, 0xFF598473, 0xFF598272, 0xFF598272, 0xFF5B8172, 0xFF5C8273, 0xFF588372,
    0xFF588372, 0xFF598473, 0xFF598473, 0xFF598473, 0xFF598473, 0xFF588372, 0xFF588372, 0xFF588370, 0xFF57826F, 0xFF57826F, 0xFF57826F, 0xFF57826F, 0xFF588370, 0xFF598471, 0xFF598471, 0xFF598270, 0xFF5A8371, 0xFF5A8371, 0xFF5A8371, 0xFF5A8371,
    0xFF598270, 0xFF58816F, 0xFF57806E, 0xFF598270, 0xFF598270, 0xFF598270, 0xFF598270, 0xFF598270, 0xFF58816F, 0xFF58816F, 0xFF57806E, 0xFF5B8270, 0xFF5C8371, 0xFF5B8270, 0xFF59806E, 0xFF5A816F, 0xFF5B8270, 0xFF587F6D, 0xFF537A68, 0xFF354C46,
    0xFF657268, 0xFF747F71, 0xFF465D4D, 0xFF375845, 0xFF40563F, 0xFF8C8163, 0xFFC39973, 0xFFB39271, 0xFF9E8F70, 0xFF516043, 0xFF4D735A, 0xFF4C7965, 0xFF426658, 0xFF27382E, 0xFF454A43, 0xFF405045, 0xFF2E3E33, 0xFF2F3F34, 0xFF3B4B40, 0xFF2D3D32,
    0xFF36463B, 0xFF3C4C41, 0xFF38483D, 0xFF364A41, 0xFF354940, 0xFF32463D, 0xFF374C45, 0xFF2C413A, 0xFF253A35, 0xFF162D27, 0xFF182F29, 0xFF1F2F2C, 0xFF1A2D29, 0xFF1F3630, 0xFF122C23, 0xFF36544A, 0xFF3F6153, 0xFF35594B, 0xFF355B4C, 0xFF42634E,
    0xFF3A604B, 0xFF416A5A, 0xFF487467, 0xFF427065, 0xFF3F6D60, 0xFF436F60, 0xFF3D6857, 0xFF3A655C, 0xFF45695D, 0xFF63796C, 0xFF7D8675, 0xFFC8C6B7, 0xFFE8E2D4, 0xFFF0E9DF, 0xFFF1EDE4, 0xFFE8E6DA, 0xFFE9E7DB, 0xFFE9E7DB, 0xFFEBE9DD, 0xFFEBE9DD,
    0xFFEBE9DD, 0xFFEAE8DC, 0xFFE9E7DB, 0xFFECE8DD, 0xFFE8E4D9, 0xFFECE8DD, 0xFFECE8DD, 0xFFEEEADF, 0xFFF1EDE2, 0xFFE8E4D9, 0xFFE6E2D7, 0xFFE3E0D9, 0xFF8C9C8F, 0xFF5B806E, 0xFF5B8472, 0xFF4D6B5F, 0x00C8D4D0, 0x00FEFFFF, 0x00FDFDFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFEFF, 0x00FDFFFE, 0xFFABC0B9, 0xFF3C6B5B, 0xFF5F8B7C, 0xFF67877C, 0xFF32564A, 0xFF0C4532, 0xFF396252, 0xFF3C6555, 0xFF2E5747, 0xFF1B4434, 0xFF3D6656,
    0xFF2F5848, 0xFF1B4434, 0xFF254E3E, 0xFF829788, 0xFF4F5D50, 0xFF64675E, 0xFFA29B95, 0xFFE3D8D4, 0xFFEDE2DE, 0xFFDDD6D0, 0xFFDED9D3, 0xFFE5E8DF, 0xFFE6E9E2, 0xFFC9CEC7, 0xFF707A71, 0xFF4A5A50, 0xFF435B4E, 0xFF507264, 0xFF4D7364, 0xFF5F796C,
    0xFF4F6B5D, 0xFF385748, 0xFF446455, 0xFF416655, 0xFF436A58, 0xFF38614F, 0xFF436E5B, 0xFF5C8575, 0xFF5E8777, 0xFF5C8575, 0xFF5F8878, 0xFF588171, 0xFF456E5E, 0xFF3B6454, 0xFF386151, 0xFF416758, 0xFF618778, 0xFF5C8273, 0xFF5A8071, 0xFF678D7E,
    0xFF4E7465, 0xFF395F50, 0xFF284E3F, 0xFF224937, 0xFF4C7361, 0xFF315845, 0xFF0F3623, 0xFF3C634E, 0xFF49705B, 0xFF1E462E, 0xFF133B23, 0xFF19432F, 0xFF183F2C, 0xFF244B38, 0xFF375E4B, 0xFF3F6452, 0xFF345947, 0xFF466857, 0xFF204231, 0xFF15402C,
    0xFF2C5743, 0xFF36604C, 0xFF3D6451, 0xFF325946, 0xFF436856, 0xFF406251, 0xFF3A5C4B, 0xFF436C5A, 0xFF315846, 0xFF1A412E, 0xFF2A513E, 0xFF466C57, 0xFF3E644F, 0xFF2B4E38, 0xFF1B3E28, 0xFF163D2A, 0xFF365D4A, 0xFF436A57, 0xFF5F8673, 0xFF59806D,
    0xFF5D8471, 0xFF5F8673, 0xFF608774, 0xFF5C8371, 0xFF5C8371, 0xFF5D8472, 0xFF5D8472, 0xFF5C8371, 0xFF5B8270, 0xFF5A816F, 0xFF59806E, 0xFF5B8675, 0xFF5A8574, 0xFF598473, 0xFF598272, 0xFF598272, 0xFF5A8071, 0xFF5A8071, 0xFF5B8172, 0xFF55826E,
    0xFF55826E, 0xFF56836F, 0xFF56836F, 0xFF56836F, 0xFF56836F, 0xFF55826E, 0xFF55826E, 0xFF56816E, 0xFF56816E, 0xFF56816E, 0xFF56816E, 0xFF57826F, 0xFF588370, 0xFF598471, 0xFF598471, 0xFF5B8472, 0xFF5B8472, 0xFF5A8371, 0xFF5A8371, 0xFF598270,
    0xFF58816F, 0xFF58816F, 0xFF57806E, 0xFF5B8472, 0xFF5B8472, 0xFF5A8371, 0xFF598270, 0xFF598270, 0xFF598270, 0xFF598270, 0xFF598270, 0xFF5B8270, 0xFF5B8270, 0xFF5A816F, 0xFF59806E, 0xFF5B8270, 0xFF5D8472, 0xFF59806E, 0xFF537A68, 0xFF3B403C,
    0xFF9D9A93, 0xFFBEBAAE, 0xFF5F6C5B, 0xFF314E3C, 0xFF4A644B, 0xFF969672, 0xFFBA9F74, 0xFFBA9872, 0xFFAB9B77, 0xFF657352, 0xFF5A7E64, 0xFF4E7B66, 0xFF416758, 0xFF21382E, 0xFF404D44, 0xFF2F3F35, 0xFF213127, 0xFF27372D, 0xFF26362C, 0xFF223228,
    0xFF2D3D33, 0xFF25352B, 0xFF2F3F35, 0xFF2C3D35, 0xFF2A3B33, 0xFF2B3F36, 0xFF344741, 0xFF283D36, 0xFF273C37, 0xFF1C312C, 0xFF1A312B, 0xFF182825, 0xFF1C2F2B, 0xFF142922, 0xFF1B352C, 0xFF203E34, 0xFF3E6052, 0xFF2F5345, 0xFF3E6455, 0xFF3E5F4A,
    0xFF385F4D, 0xFF3C675D, 0xFF37665C, 0xFF305E53, 0xFF2F5B4E, 0xFF366255, 0xFF356056, 0xFF2B564C, 0xFF38594E, 0xFF60766A, 0xFF727C71, 0xFFBDBDB3, 0xFFE3E0D7, 0xFFE0E0D8, 0xFFDCDCD4, 0xFFE7E4DD, 0xFFE6E3DC, 0xFFE4E1DA, 0xFFE4E1DA, 0xFFE5E2DB,
    0xFFE4E1DA, 0xFFE2DFD8, 0xFFE0DDD6, 0xFFE1E1D9, 0xFFE1E1D9, 0xFFE7E7DF, 0xFFE4E4DC, 0xFFE1E1D9, 0xFFE2E2DA, 0xFFE0E0D8, 0xFFE6E6DE, 0xFFEEEBE4, 0xFF91A194, 0xFF5B806E, 0xFF598270, 0xFF4D6B5F, 0x00CBD7D3, 0x00FEFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFEFF, 0x00FEFFFF, 0xFFABC0B9, 0xFF3B6A5A, 0xFF5E8A7B, 0xFF69897E, 0xFF395D51, 0xFF17503D, 0xFF4F7868, 0xFF456E5E, 0xFF477060, 0xFF224B3B, 0xFF487161,
    0xFF4C7565, 0xFF2F5848, 0xFF275040, 0xFF718E7C, 0xFF4B6051, 0xFF545C51, 0xFFAAA59F, 0xFFECDEDB, 0xFFE1D2CF, 0xFFD2C4C1, 0xFFD7CCC8, 0xFFD0CFCA, 0xFFE0DFDA, 0xFFCECFC9, 0xFF646963, 0xFF444F47, 0xFF384C43, 0xFF345044, 0xFF2B4D3F, 0xFF6A736E,
    0xFF57605B, 0xFF303D36, 0xFF35463E, 0xFF2C4339, 0xFF375347, 0xFF29493C, 0xFF335547, 0xFF557E6E, 0xFF5F8878, 0xFF527B6B, 0xFF578070, 0xFF648D7D, 0xFF567F6F, 0xFF446D5D, 0xFF396252, 0xFF416758, 0xFF476D5E, 0xFF567C6D, 0xFF688E7F, 0xFF618778,
    0xFF476D5E, 0xFF385E4F, 0xFF254B3C, 0xFF325944, 0xFF365D48, 0xFF1B422D, 0xFF1C442C, 0xFF406850, 0xFF315941, 0xFF0D351B, 0xFF1A4228, 0xFF153C29, 0xFF173E2B, 0xFF264D3A, 0xFF3F6452, 0xFF406553, 0xFF2F5140, 0xFF476958, 0xFF3D5F4E, 0xFF214C38,
    0xFF28533F, 0xFF3F6955, 0xFF426956, 0xFF1F4432, 0xFF3D5E4D, 0xFF4E6F5E, 0xFF365545, 0xFF3C6351, 0xFF3F6654, 0xFF315845, 0xFF2C513F, 0xFF315742, 0xFF2F523E, 0xFF264933, 0xFF183B25, 0xFF19402D, 0xFF385F4C, 0xFF4A715E, 0xFF608774, 0xFF587F6C,
    0xFF577E6B, 0xFF5B826F, 0xFF5F8673, 0xFF5A816F, 0xFF5B8270, 0xFF5C8371, 0xFF5C8371, 0xFF5C8371, 0xFF5B8270, 0xFF5A816F, 0xFF59806E, 0xFF598471, 0xFF598471, 0xFF598270, 0xFF58816F, 0xFF5A816F, 0xFF5A816F, 0xFF5A816F, 0xFF5B806F, 0xFF55826D,
    0xFF56836E, 0xFF56836E, 0xFF56836E, 0xFF56836E, 0xFF56836E, 0xFF56836E, 0xFF55826D, 0xFF58816F, 0xFF58816F, 0xFF58816F, 0xFF58816F, 0xFF598270, 0xFF598270, 0xFF5A8371, 0xFF5B8472, 0xFF58816F, 0xFF58816F, 0xFF58816F, 0xFF58816F, 0xFF58816F,
    0xFF58816F, 0xFF598270, 0xFF598270, 0xFF5C8573, 0xFF5B8472, 0xFF5A8371, 0xFF598270, 0xFF598270, 0xFF598270, 0xFF598270, 0xFF5A8371, 0xFF5B8270, 0xFF5B8270, 0xFF5A816F, 0xFF5A816F, 0xFF5C8371, 0xFF5E8573, 0xFF5A816F, 0xFF537A68, 0xFF3C3E39,
    0xFF706C61, 0xFF7E7669, 0xFF4C5445, 0xFF435E4B, 0xFF546E55, 0xFF979876, 0xFFB69F75, 0xFFB6976B, 0xFFA99B74, 0xFF5D6846, 0xFF54765B, 0xFF4A7762, 0xFF365F4F, 0xFF1C3A2E, 0xFF42564D, 0xFF36463C, 0xFF37473D, 0xFF3C4C42, 0xFF2F3F35, 0xFF324238,
    0xFF3A4A40, 0xFF2B3B31, 0xFF37473D, 0xFF203129, 0xFF2D3E36, 0xFF283931, 0xFF2F423C, 0xFF2E413B, 0xFF324742, 0xFF293E39, 0xFF152A25, 0xFF21312E, 0xFF162721, 0xFF20352E, 0xFF152F26, 0xFF2C483C, 0xFF39594C, 0xFF446958, 0xFF406554, 0xFF3C5D4A,
    0xFF3B6456, 0xFF3A6963, 0xFF295850, 0xFF1F493D, 0xFF1C4130, 0xFF254B3C, 0xFF254F43, 0xFF285143, 0xFF2D4D42, 0xFF5C7067, 0xFF6F7971, 0xFFBABBB5, 0xFFDDDED8, 0xFFC0C3BC, 0xFFA6ABA4, 0xFFA1A09C, 0xFF9D9C98, 0xFF999894, 0xFF979692, 0xFF979692,
    0xFF969591, 0xFF93928E, 0xFF908F8B, 0xFF9EA09B, 0xFFA2A49F, 0xFFABADA8, 0xFFA4A6A1, 0xFF9A9C97, 0xFFA0A29D, 0xFFB0B2AD, 0xFFC8CAC5, 0xFFE6E3DC, 0xFF8C9C8F, 0xFF5A7F6D, 0xFF5C8573, 0xFF4F6D61, 0x00CAD6D2, 0x00FEFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FDFBFC, 0x00FDFFFE, 0xFFADC2BB, 0xFF3D6C5C, 0xFF5D897A, 0xFF66867B, 0xFF35594D, 0xFF144D3A, 0xFF406959, 0xFF204939, 0xFF477060, 0xFF295242, 0xFF325B4B,
    0xFF436C5C, 0xFF2E5747, 0xFF174030, 0xFF547B68, 0xFF587767, 0xFF55675B, 0xFFB3B6AF, 0xFFE3DEDA, 0xFFD1C9C6, 0xFFC7C2BE, 0xFFC1BCB8, 0xFFD2CFCA, 0xFFDAD7D2, 0xFFD3D2CE, 0xFF848681, 0xFF7D8681, 0xFF5D6E66, 0xFF4B655C, 0xFF527267, 0xFF969291,
    0xFF878684, 0xFF565654, 0xFF4D534F, 0xFF57625C, 0xFF798881, 0xFF52665D, 0xFF2B4037, 0xFF5B8474, 0xFF5A8373, 0xFF598272, 0xFF5D8676, 0xFF567F6F, 0xFF588171, 0xFF5C8575, 0xFF406959, 0xFF426859, 0xFF345A4B, 0xFF476D5E, 0xFF5F8576, 0xFF608677,
    0xFF53796A, 0xFF385E4F, 0xFF2B5142, 0xFF193F2A, 0xFF173D28, 0xFF0F3520, 0xFF143A23, 0xFF1F452E, 0xFF193F28, 0xFF11371E, 0xFF153B22, 0xFF163D2A, 0xFF153A28, 0xFF163B29, 0xFF1F4432, 0xFF1E402F, 0xFF0F3120, 0xFF244534, 0xFF264736, 0xFF173E2B,
    0xFF1E4532, 0xFF1F4432, 0xFF1B402E, 0xFF143625, 0xFF234433, 0xFF234433, 0xFF183727, 0xFF1B4230, 0xFF2D5241, 0xFF284D3B, 0xFF1D4230, 0xFF1C3F2B, 0xFF1E412D, 0xFF21422D, 0xFF183924, 0xFF274C3A, 0xFF385D4B, 0xFF466B59, 0xFF5B806E, 0xFF5C816F,
    0xFF5D8270, 0xFF5A7F6D, 0xFF5A7F6D, 0xFF5A816F, 0xFF5B8270, 0xFF5B8270, 0xFF5B8270, 0xFF5B8270, 0xFF5B8270, 0xFF5A816F, 0xFF59806E, 0xFF58826E, 0xFF58826E, 0xFF57816D, 0xFF59806D, 0xFF59806D, 0xFF5A7F6D, 0xFF5B806E, 0xFF5C816F, 0xFF57836C,
    0xFF57836C, 0xFF57836C, 0xFF57836C, 0xFF57836C, 0xFF57836C, 0xFF57836C, 0xFF57836C, 0xFF58826E, 0xFF58826E, 0xFF58826E, 0xFF57816D, 0xFF58826E, 0xFF58826E, 0xFF59836F, 0xFF59836F, 0xFF567F6D, 0xFF567F6D, 0xFF567F6D, 0xFF567F6D, 0xFF57806E,
    0xFF58816F, 0xFF598270, 0xFF598270, 0xFF5D8472, 0xFF5C8371, 0xFF5B8270, 0xFF5A816F, 0xFF5A816F, 0xFF5A816F, 0xFF5B8270, 0xFF5B8270, 0xFF5A816F, 0xFF5B8270, 0xFF5A816F, 0xFF5A816F, 0xFF5B8270, 0xFF5D8472, 0xFF5A816F, 0xFF557C6A, 0xFF3B4F43,
    0xFF757D6E, 0xFF848577, 0xFF5F6A5C, 0xFF41594B, 0xFF304631, 0xFF868265, 0xFFC2A681, 0xFFB09970, 0xFFA09873, 0xFF495638, 0xFF52745B, 0xFF55806D, 0xFF396254, 0xFF1F3D31, 0xFF3F544B, 0xFF37473D, 0xFF2B3B31, 0xFF304036, 0xFF2C3C32, 0xFF2B3B31,
    0xFF2F3F35, 0xFF2C3C32, 0xFF2C3C32, 0xFF202F28, 0xFF36453E, 0xFF273830, 0xFF2F403A, 0xFF2E413B, 0xFF30433F, 0xFF293E39, 0xFF132823, 0xFF1A2924, 0xFF13241E, 0xFF152822, 0xFF0F261C, 0xFF2A463A, 0xFF375748, 0xFF3A5C4C, 0xFF2D5241, 0xFF4C6B59,
    0xFF467066, 0xFF396A66, 0xFF214C45, 0xFF244331, 0xFF293D24, 0xFF304830, 0xFF2C4935, 0xFF214332, 0xFF1D372A, 0xFF506056, 0xFF6B706A, 0xFFB7B8B3, 0xFFDBDCD6, 0xFFB4B9B2, 0xFF91998E, 0xFF9D9C98, 0xFF9A9995, 0xFF979692, 0xFF979692, 0xFF9A9995,
    0xFF9A9995, 0xFF989793, 0xFF969591, 0xFF969893, 0xFF989A95, 0xFF9FA19C, 0xFF959792, 0xFF8C8E89, 0xFF969893, 0xFFB2B4AF, 0xFFD4D6D1, 0xFFE5E2DB, 0xFF8B9B8E, 0xFF5B806E, 0xFF5E8775, 0xFF527064, 0x00CAD6D2, 0x00FDFFFE, 0x00FEFEFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FCFAFB, 0x00FCFEFD, 0xFFADC2BB, 0xFF3D6C5C, 0xFF5D897A, 0xFF65857A, 0xFF365A4E, 0xFF154E3B, 0xFF466F5F, 0xFF305949, 0xFF456E5E, 0xFF325B4B, 0xFF466F5F,
    0xFF436C5C, 0xFF1C4535, 0xFF174030, 0xFF4C7763, 0xFF4C6E5D, 0xFF4A6053, 0xFFA2ACA3, 0xFFE1E2DC, 0xFFD3D2CD, 0xFFCDCEC8, 0xFFC1C4BD, 0xFFD3CFCC, 0xFFD4D0CD, 0xFFD8D7D3, 0xFFA9ABA8, 0xFFB5BEB9, 0xFF6B7E78, 0xFF415C53, 0xFF4E6E63, 0xFF929493,
    0xFF898D8C, 0xFF646A68, 0xFF5C6562, 0xFF6B7773, 0xFF8B9A95, 0xFF72837D, 0xFF50635D, 0xFF4F7A69, 0xFF5B8675, 0xFF5F8A79, 0xFF5A8574, 0xFF537E6D, 0xFF588372, 0xFF5F8A79, 0xFF588372, 0xFF426859, 0xFF3C6253, 0xFF395F50, 0xFF43695A, 0xFF5D8374,
    0xFF648A7B, 0xFF406657, 0xFF3D6354, 0xFF395E4D, 0xFF436857, 0xFF426755, 0xFF3F6452, 0xFF3D634E, 0xFF3E644F, 0xFF446A53, 0xFF436952, 0xFF486D5B, 0xFF426755, 0xFF3B604E, 0xFF365847, 0xFF3C5E4D, 0xFF3D5E4D, 0xFF355645, 0xFF264736, 0xFF2A4939,
    0xFF2A4939, 0xFF2B4A3A, 0xFF385948, 0xFF3D5F4E, 0xFF3A5C4B, 0xFF355746, 0xFF3A5F4D, 0xFF3D6251, 0xFF426756, 0xFF3D6250, 0xFF416352, 0xFF436652, 0xFF41624F, 0xFF43644F, 0xFF3E5F4A, 0xFF365B49, 0xFF416654, 0xFF4E7361, 0xFF5C816F, 0xFF5C816F,
    0xFF5B806E, 0xFF587D6B, 0xFF597E6C, 0xFF59806E, 0xFF587F6D, 0xFF567D6B, 0xFF557C6A, 0xFF537A68, 0xFF517866, 0xFF507765, 0xFF4F7664, 0xFF4D7761, 0xFF4D7761, 0xFF4E7560, 0xFF4E7560, 0xFF4F7560, 0xFF4F7560, 0xFF507661, 0xFF527561, 0xFF4F775F,
    0xFF4F775F, 0xFF4E765E, 0xFF4E765E, 0xFF4E765E, 0xFF4E765E, 0xFF4F775F, 0xFF4F775F, 0xFF4B7561, 0xFF4A7460, 0xFF4A7460, 0xFF4A7460, 0xFF4B7561, 0xFF4C7662, 0xFF4D7763, 0xFF4E7864, 0xFF4E7765, 0xFF4F7866, 0xFF507967, 0xFF527B69, 0xFF537C6A,
    0xFF547D6B, 0xFF557E6C, 0xFF557E6C, 0xFF59806E, 0xFF59806E, 0xFF59806E, 0xFF59806E, 0xFF59806E, 0xFF59806E, 0xFF59806E, 0xFF5A816F, 0xFF5A816F, 0xFF5B8270, 0xFF5B8270, 0xFF59806E, 0xFF59806E, 0xFF5B8270, 0xFF5A816F, 0xFF577E6C, 0xFF486F5D,
    0xFF91A999, 0xFFAAB7A6, 0xFF788A7E, 0xFF4A665A, 0xFF354D3D, 0xFF888870, 0xFFC2AB8B, 0xFFAE9F7E, 0xFF979678, 0xFF4C5B44, 0xFF567764, 0xFF4B7464, 0xFF2E5246, 0xFF183428, 0xFF394D42, 0xFF32413A, 0xFF0F1E17, 0xFF15241D, 0xFF1A2922, 0xFF15241D,
    0xFF17261F, 0xFF1A2922, 0xFF14231C, 0xFF0F1E17, 0xFF1A2922, 0xFF17261F, 0xFF1E2F29, 0xFF1B2C26, 0xFF1F322E, 0xFF1D302C, 0xFF182B27, 0xFF1A2924, 0xFF2B3A33, 0xFF14281F, 0xFF21382E, 0xFF213D2F, 0xFF426152, 0xFF375948, 0xFF496B5A, 0xFF5D7865,
    0xFF4B736A, 0xFF31625F, 0xFF1F453A, 0xFF455437, 0xFF5B5C34, 0xFF63653E, 0xFF56603E, 0xFF2C452F, 0xFF263828, 0xFF606A5F, 0xFF848580, 0xFFCCC8C5, 0xFFE4E3DE, 0xFFBCBFB4, 0xFF959D8E, 0xFF999A94, 0xFF979892, 0xFF979892, 0xFF989993, 0xFF9A9B95,
    0xFF9C9D97, 0xFF9A9B95, 0xFF999A94, 0xFF9B9E97, 0xFF979A93, 0xFF999C95, 0xFF91948D, 0xFF8C8F88, 0xFF989B94, 0xFFB1B4AD, 0xFFD1D4CD, 0xFFEBE8E1, 0xFF8B9B8E, 0xFF577C6A, 0xFF5D8674, 0xFF547266, 0x00CDD9D5, 0x00FEFFFF, 0x00FEFEFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFEFF, 0x00FEFFFF, 0xFFABC0B9, 0xFF3B6A5A, 0xFF5D897A, 0xFF68887D, 0xFF395D51, 0xFF17503D, 0xFF4D7666, 0xFF4F7868, 0xFF3C6555, 0xFF355E4E, 0xFF557E6E,
    0xFF466F5F, 0xFF1E4737, 0xFF244D3D, 0xFF577768, 0xFF4D675A, 0xFF828F86, 0xFFA7A9A4, 0xFFE6E5E1, 0xFFD0CCC9, 0xFFC5C6C1, 0xFFC3C5C0, 0xFFC3C2BE, 0xFFE1E0DC, 0xFFD2D2D0, 0xFF6F7470, 0xFF7D8884, 0xFF536861, 0xFF436157, 0xFF4B6C61, 0xFF415B52,
    0xFF4A645B, 0xFF486259, 0xFF445F56, 0xFF415C53, 0xFF456057, 0xFF4B695F, 0xFF59776D, 0xFF2F5A49, 0xFF4A7564, 0xFF578271, 0xFF578271, 0xFF5E8978, 0xFF588372, 0xFF4E7968, 0xFF5B8675, 0xFF5D8374, 0xFF446A5B, 0xFF3F6556, 0xFF456B5C, 0xFF3F6556,
    0xFF597F70, 0xFF5B8172, 0xFF43695A, 0xFF3D5F51, 0xFF436557, 0xFF3F6153, 0xFF3F6151, 0xFF3D5F4F, 0xFF395B4B, 0xFF3E604F, 0xFF3E604F, 0xFF325745, 0xFF395E4C, 0xFF446655, 0xFF385A49, 0xFF3B5C4B, 0xFF3B5C4B, 0xFF1E3F2E, 0xFF133222, 0xFF172B1F,
    0xFF0B2114, 0xFF193425, 0xFF365545, 0xFF3A5C4B, 0xFF355A48, 0xFF36604C, 0xFF396450, 0xFF3A5F4E, 0xFF395E4D, 0xFF395B4A, 0xFF426453, 0xFF446552, 0xFF3D5E4B, 0xFF3F604B, 0xFF40604B, 0xFF406251, 0xFF476958, 0xFF537564, 0xFF5B7D6C, 0xFF597B6A,
    0xFF557766, 0xFF537564, 0xFF587A69, 0xFF527967, 0xFF4F7664, 0xFF4B7260, 0xFF456C5A, 0xFF406755, 0xFF3B6250, 0xFF39604E, 0xFF385F4D, 0xFF345E46, 0xFF355D45, 0xFF345C44, 0xFF335B43, 0xFF335942, 0xFF325841, 0xFF345741, 0xFF345741, 0xFF34563E,
    0xFF34563E, 0xFF33553D, 0xFF32543C, 0xFF32543C, 0xFF33553D, 0xFF34563E, 0xFF34563E, 0xFF2F5641, 0xFF2F5641, 0xFF305742, 0xFF315843, 0xFF335A45, 0xFF355C47, 0xFF365D48, 0xFF375E49, 0xFF3B6452, 0xFF3D6654, 0xFF416A58, 0xFF456E5C, 0xFF497260,
    0xFF4D7664, 0xFF4F7866, 0xFF507967, 0xFF567B6A, 0xFF567B6A, 0xFF577C6B, 0xFF587D6C, 0xFF597E6D, 0xFF597E6D, 0xFF597E6D, 0xFF597E6D, 0xFF59806E, 0xFF5B8270, 0xFF5B8270, 0xFF587F6D, 0xFF577E6C, 0xFF59806E, 0xFF5A816F, 0xFF59806E, 0xFF265545,
    0xFF2C4B3B, 0xFF3C4E40, 0xFF374E44, 0xFF486D65, 0xFF45695B, 0xFF68765F, 0xFF8E8566, 0xFF959178, 0xFF777C66, 0xFF4D6251, 0xFF557568, 0xFF355B50, 0xFF2B4B40, 0xFF1F372A, 0xFF445447, 0xFF36453E, 0xFF26352E, 0xFF314039, 0xFF202F28, 0xFF2B3A33,
    0xFF303F38, 0xFF202F28, 0xFF2C3B34, 0xFF26352E, 0xFF1A2922, 0xFF32413A, 0xFF2F3E39, 0xFF21322C, 0xFF3C4C49, 0xFF2F423E, 0xFF2D403C, 0xFF303D36, 0xFF283730, 0xFF25362E, 0xFF263C30, 0xFF284235, 0xFF345343, 0xFF4C6D5C, 0xFF5C7E6D, 0xFF5F7865,
    0xFF487067, 0xFF305D5A, 0xFF294536, 0xFF6A6A44, 0xFF917E46, 0xFF98844F, 0xFF827847, 0xFF3C4F33, 0xFF37432D, 0xFF77796C, 0xFFA5A09C, 0xFFE4DCD9, 0xFFE9E4DE, 0xFFB8BAAC, 0xFF8B9280, 0xFF94958D, 0xFF94958D, 0xFF95968E, 0xFF96978F, 0xFF96978F,
    0xFF96978F, 0xFF95968E, 0xFF94958D, 0xFF9A9A92, 0xFF95958D, 0xFF95958D, 0xFF8F8F87, 0xFF8B8B83, 0xFF97978F, 0xFFB1B1A9, 0xFFD0D0C8, 0xFFE8E5DE, 0xFF8A9A8D, 0xFF577C6A, 0xFF5D8674, 0xFF527064, 0x00CBD7D3, 0x00FEFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFEFF, 0x00FEFFFF, 0xFFA9BEB7, 0xFF3A6959, 0xFF5E8A7B, 0xFF67877C, 0xFF315549, 0xFF0A4330, 0xFF1D4636, 0xFF234C3C, 0xFF103929, 0xFF1A4333, 0xFF1C4535,
    0xFF1D4636, 0xFF244D3D, 0xFF143D2D, 0xFF5F7569, 0xFF59695F, 0xFFBFC4BE, 0xFFA6A29F, 0xFFF2EAE8, 0xFFEDE5E3, 0xFFDFDBD8, 0xFFD7D8D3, 0xFFE0E1DC, 0xFFF4F5F0, 0xFFCFD1CE, 0xFF666C68, 0xFF84908C, 0xFF667D75, 0xFF5B7B70, 0xFF5C8076, 0xFF4E7D6D,
    0xFF507F6F, 0xFF537F70, 0xFF507C6D, 0xFF578173, 0xFF4C7668, 0xFF3F695B, 0xFF355E50, 0xFF396453, 0xFF376251, 0xFF517C6B, 0xFF5D8877, 0xFF588372, 0xFF588372, 0xFF568170, 0xFF598473, 0xFF5D8374, 0xFF5A8071, 0xFF3E6455, 0xFF3D6354, 0xFF3D6354,
    0xFF4D7364, 0xFF5F8576, 0xFF63897A, 0xFF618279, 0xFF62837A, 0xFF5D7E73, 0xFF618277, 0xFF628476, 0xFF608274, 0xFF648676, 0xFF5C7E6E, 0xFF5F8472, 0xFF5A7C6B, 0xFF5F8170, 0xFF547665, 0xFF587968, 0xFF4F705F, 0xFF1E3D2D, 0xFF113020, 0xFF17241A,
    0xFF0F2115, 0xFF182E21, 0xFF385445, 0xFF557766, 0xFF58826E, 0xFF53806B, 0xFF52826C, 0xFF577C6B, 0xFF5C7E6E, 0xFF577968, 0xFF507261, 0xFF3C5D4A, 0xFF264734, 0xFF254530, 0xFF24442F, 0xFF254736, 0xFF244635, 0xFF2E503F, 0xFF3D5F4E, 0xFF4B6D5C,
    0xFF517362, 0xFF507261, 0xFF517362, 0xFF4B7260, 0xFF466D5B, 0xFF3F6654, 0xFF365D4B, 0xFF2E5543, 0xFF284F3D, 0xFF244B39, 0xFF224937, 0xFF1E462E, 0xFF1C442C, 0xFF1B432B, 0xFF193F28, 0xFF173D26, 0xFF183B25, 0xFF173A24, 0xFF173A24, 0xFF173720,
    0xFF173720, 0xFF16361F, 0xFF15351E, 0xFF15351E, 0xFF16361F, 0xFF173720, 0xFF173720, 0xFF143B26, 0xFF153C27, 0xFF163D28, 0xFF183F2A, 0xFF1B422D, 0xFF1E4530, 0xFF214833, 0xFF224934, 0xFF27503E, 0xFF2A5341, 0xFF315A48, 0xFF396250, 0xFF406957,
    0xFF466F5D, 0xFF4A7361, 0xFF4C7563, 0xFF537867, 0xFF547968, 0xFF567B6A, 0xFF577C6B, 0xFF587D6C, 0xFF587D6C, 0xFF587D6C, 0xFF587D6C, 0xFF587F6D, 0xFF5B8270, 0xFF5B8270, 0xFF577E6C, 0xFF557C6A, 0xFF577E6C, 0xFF5A816F, 0xFF5B8270, 0xFF2D5B4E,
    0xFF39594C, 0xFF5B6F64, 0xFF3C574E, 0xFF3A655C, 0xFF2A584B, 0xFF1F3B24, 0xFF303716, 0xFF6E6F5D, 0xFF455040, 0xFF425A4D, 0xFF517269, 0xFF32554E, 0xFF446258, 0xFF3B4F43, 0xFF5A6859, 0xFF1B2A23, 0xFF3A4942, 0xFF495851, 0xFF192821, 0xFF3D4C45,
    0xFF495851, 0xFF1F2E27, 0xFF44534C, 0xFF3D4A43, 0xFF1D2C25, 0xFF485750, 0xFF31403B, 0xFF182923, 0xFF485855, 0xFF273A36, 0xFF182B27, 0xFF55625B, 0xFF32413A, 0xFF22332B, 0xFF4D6357, 0xFF284235, 0xFF4E6D5D, 0xFF5A7B6A, 0xFF5B7D6C, 0xFF5D7462,
    0xFF4A6F67, 0xFF355F5B, 0xFF334C39, 0xFF7F7749, 0xFFA78848, 0xFFAC8A4B, 0xFF907A41, 0xFF526142, 0xFF404830, 0xFF737164, 0xFF9F9691, 0xFFDCD1CD, 0xFFE0D9D1, 0xFFB9BAAA, 0xFF909881, 0xFF8E9085, 0xFF909287, 0xFF929489, 0xFF94968B, 0xFF94968B,
    0xFF94968B, 0xFF93958A, 0xFF93958A, 0xFF959289, 0xFF918E85, 0xFF949188, 0xFF8D8A81, 0xFF88857C, 0xFF959289, 0xFFB3B0A7, 0xFFD8D5CC, 0xFFE3E0D9, 0xFF8B9B8E, 0xFF5D8270, 0xFF608977, 0xFF4E6C60, 0x00C2CECA, 0x00F9FBFA, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFF5FC, 0x00F8FFFF, 0xFFA7C6BE, 0xFF3B6758, 0xFF648E80, 0xFF5A8071, 0xFF406959, 0xFF275342, 0xFF27503E, 0xFF28513F, 0xFF295240, 0xFF2B5442, 0xFF2A5341,
    0xFF28513F, 0xFF2B5442, 0xFF2A5341, 0xFF577166, 0xFF586F65, 0xFF6E857B, 0xFF869B92, 0xFF9AAFA6, 0xFF8A9F96, 0xFF8CA399, 0xFFA0B7AD, 0xFF93A8A1, 0xFF8EA59D, 0xFF85A097, 0xFF517166, 0xFF45695D, 0xFF4B7466, 0xFF568273, 0xFF5B8778, 0xFF588976,
    0xFF558472, 0xFF568573, 0xFF598473, 0xFF578070, 0xFF5C8273, 0xFF5A7E70, 0xFF4E7264, 0xFF305949, 0xFF396252, 0xFF355E4E, 0xFF527B6B, 0xFF5B8474, 0xFF5D8676, 0xFF5D8676, 0xFF598272, 0xFF578271, 0xFF588372, 0xFF5A8574, 0xFF406959, 0xFF406959,
    0xFF376050, 0xFF486E5F, 0xFF608677, 0xFF5C8371, 0xFF5A816F, 0xFF59806E, 0xFF59806E, 0xFF5B8270, 0xFF5C8371, 0xFF5D8472, 0xFF5C8371, 0xFF5B7F73, 0xFF597F70, 0xFF527B69, 0xFF517B67, 0xFF517865, 0xFF426456, 0xFF112F27, 0xFF0F2824, 0xFF0F201A,
    0xFF182D26, 0xFF1B362D, 0xFF244437, 0xFF527668, 0xFF557A69, 0xFF587A6A, 0xFF5B7D6D, 0xFF588077, 0xFF416259, 0xFF475F52, 0xFF505E4F, 0xFF4F5644, 0xFF494B35, 0xFF3D3D23, 0xFF424226, 0xFF4D3E17, 0xFF372E0F, 0xFF333621, 0xFF253729, 0xFF27453B,
    0xFF284C3E, 0xFF385F4C, 0xFF4F775F, 0xFF497157, 0xFF3F6953, 0xFF315D4C, 0xFF255549, 0xFF1C5043, 0xFF184D39, 0xFF154B31, 0xFF14492B, 0xFF203D27, 0xFF1B3721, 0xFF182F1B, 0xFF182B18, 0xFF1B2918, 0xFF1D2818, 0xFF1C2415, 0xFF1B2113, 0xFF191E1A,
    0xFF191E1A, 0xFF181D19, 0xFF181D19, 0xFF191E1A, 0xFF1A1F1B, 0xFF1B201C, 0xFF1C211D, 0xFF1A2B1B, 0xFF182A1A, 0xFF162D19, 0xFF17331D, 0xFF15371E, 0xFF133A1F, 0xFF164125, 0xFF1D4A2B, 0xFF124B38, 0xFF144D3A, 0xFF17503D, 0xFF225946, 0xFF316453,
    0xFF436D5F, 0xFF4B6F63, 0xFF4F6D63, 0xFF527766, 0xFF547968, 0xFF557A69, 0xFF567B6A, 0xFF567B6A, 0xFF577C6B, 0xFF597E6D, 0xFF5B806F, 0xFF59806E, 0xFF59806E, 0xFF59806E, 0xFF59806E, 0xFF59806E, 0xFF587F6D, 0xFF587F6D, 0xFF587F6D, 0xFF5A7F6E,
    0xFF5C7E6E, 0xFF709282, 0xFF6B8D7D, 0xFF587869, 0xFF29493A, 0xFF153425, 0xFF234233, 0xFF314B3E, 0xFF274738, 0xFF335A48, 0xFF46715E, 0xFF3B604F, 0xFF395346, 0xFF46534A, 0xFF898E88, 0xFF1A2D19, 0xFF516450, 0xFF697C68, 0xFF1C2F1B, 0xFF5D705C,
    0xFF637662, 0xFF182B17, 0xFF637662, 0xFF586D5E, 0xFF1F3123, 0xFF728476, 0xFF4C5E50, 0xFF19291C, 0xFF7E8E81, 0xFF445245, 0xFF223023, 0xFF7C8C81, 0xFF314337, 0xFF283E31, 0xFF6C8778, 0xFF3B5A4A, 0xFF5B7D6C, 0xFF547967, 0xFF577E6B, 0xFF608271,
    0xFF476B5D, 0xFF2B4C3B, 0xFF3B4B30, 0xFF847F55, 0xFF9F8A55, 0xFF9C834B, 0xFF9D8652, 0xFF746C3E, 0xFF333F27, 0xFF455950, 0xFF7A7D72, 0xFFAEA89A, 0xFFE5E5DD, 0xFFBDC0B9, 0xFF949084, 0xFF90938A, 0xFF8D9087, 0xFF8A8D84, 0xFF8C8F86, 0xFF90938A,
    0xFF93968D, 0xFF92958C, 0xFF90938A, 0xFF8F9887, 0xFF8E9786, 0xFF909787, 0xFF878D7F, 0xFF818577, 0xFF909287, 0xFFB3B5AA, 0xFFD3D5CA, 0xFFDFE4DE, 0xFF7E8E84, 0xFF567566, 0xFF5C8575, 0xFF4B7162, 0x00B6CDC5, 0x00FAFEFD, 0x00FFFAFE, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFAFF, 0x00F9FFFF, 0xFFA2C1B9, 0xFF366253, 0xFF618B7D, 0xFF618778, 0xFF5E8777, 0xFF5B8776, 0xFF608977, 0xFF628B79, 0xFF618A78, 0xFF5F8876, 0xFF5E8775,
    0xFF5F8876, 0xFF5E8775, 0xFF598270, 0xFF638779, 0xFF5F8173, 0xFF5D7F71, 0xFF59796C, 0xFF5F8173, 0xFF55796B, 0xFF587E6F, 0xFF618A7A, 0xFF5F7A71, 0xFF537167, 0xFF5B7B70, 0xFF507468, 0xFF51776A, 0xFF4E786A, 0xFF548071, 0xFF5E8A7B, 0xFF558673,
    0xFF558673, 0xFF598876, 0xFF5B8776, 0xFF588372, 0xFF5E8777, 0xFF608979, 0xFF5D8374, 0xFF487161, 0xFF355E4E, 0xFF416A5A, 0xFF2F5848, 0xFF557E6E, 0xFF5E8777, 0xFF567F6F, 0xFF5A8373, 0xFF5A8574, 0xFF598473, 0xFF5F8A79, 0xFF4F7868, 0xFF3D6656,
    0xFF376050, 0xFF486E5F, 0xFF5F8576, 0xFF5D8472, 0xFF5B8270, 0xFF5A816F, 0xFF5A816F, 0xFF5B8270, 0xFF5C8371, 0xFF5C8371, 0xFF5C8371, 0xFF5E8276, 0xFF5B8172, 0xFF547D6B, 0xFF547E6A, 0xFF517865, 0xFF446658, 0xFF224038, 0xFF304945, 0xFF32433D,
    0xFF233831, 0xFF0D281F, 0xFF37574A, 0xFF537769, 0xFF4E7362, 0xFF547666, 0xFF567868, 0xFF537C6A, 0xFF446655, 0xFF394E3B, 0xFF5B634E, 0xFF8D876F, 0xFFA7977D, 0xFFB19E7E, 0xFFB09977, 0xFFAC906B, 0xFF978263, 0xFF7D7560, 0xFF43493D, 0xFF203129,
    0xFF142E23, 0xFF294839, 0xFF456452, 0xFF3C5D48, 0xFF345645, 0xFF294B3D, 0xFF1E4238, 0xFF1A3E34, 0xFF193D2F, 0xFF1B3D2C, 0xFF1B3E28, 0xFF1A3320, 0xFF172E1C, 0xFF132817, 0xFF142515, 0xFF182416, 0xFF1B2316, 0xFF1A2014, 0xFF191C11, 0xFF1A1C19,
    0xFF1A1C19, 0xFF191B18, 0xFF191B18, 0xFF191B18, 0xFF1A1C19, 0xFF1B1D1A, 0xFF1C1E1B, 0xFF1B1E17, 0xFF181E14, 0xFF172116, 0xFF19271A, 0xFF152A19, 0xFF142D1A, 0xFF16331D, 0xFF1C3923, 0xFF1A4637, 0xFF184838, 0xFF1A4F3D, 0xFF215845, 0xFF2A5F4D,
    0xFF366555, 0xFF43695C, 0xFF4C6C61, 0xFF4F7463, 0xFF517665, 0xFF537867, 0xFF537867, 0xFF547968, 0xFF557A69, 0xFF577C6B, 0xFF597E6D, 0xFF59806E, 0xFF59806E, 0xFF59806E, 0xFF59806E, 0xFF59806E, 0xFF59806E, 0xFF587F6D, 0xFF587F6D, 0xFF5A816F,
    0xFF567D6B, 0xFF628776, 0xFF5C8170, 0xFF597B6B, 0xFF416353, 0xFF3A5C4C, 0xFF4A6A5B, 0xFF527162, 0xFF3D5F4F, 0xFF426B59, 0xFF4B7663, 0xFF39604E, 0xFF405C4E, 0xFF6A7B71, 0xFFAEB8B0, 0xFF21362D, 0xFF6B8077, 0xFF81968D, 0xFF0D2219, 0xFF546960,
    0xFF52675E, 0xFF162B22, 0xFF647970, 0xFF546A5D, 0xFF162C1F, 0xFF7E9487, 0xFF3F5347, 0xFF293D31, 0xFFA5B7AB, 0xFF4A5C50, 0xFF2B3D31, 0xFF788A7E, 0xFF23372B, 0xFF4B6154, 0xFFAAC5B6, 0xFF416050, 0xFF597B6A, 0xFF5C816F, 0xFF577E6B, 0xFF4C6E5D,
    0xFF365A4C, 0xFF294A39, 0xFF45553A, 0xFF8B865C, 0xFFA8935E, 0xFFA68D55, 0xFFA08955, 0xFF776F41, 0xFF333F27, 0xFF44584F, 0xFF797C71, 0xFFACA698, 0xFFE5E5DD, 0xFFBFC2BB, 0xFF959185, 0xFF919187, 0xFF929288, 0xFF929288, 0xFF939389, 0xFF94948A,
    0xFF95958B, 0xFF95958B, 0xFF96968C, 0xFF909485, 0xFF8C9081, 0xFF8B8F80, 0xFF888A7D, 0xFF838578, 0xFF909086, 0xFFB5B5AB, 0xFFD8D8CE, 0xFFE0E7E0, 0xFF88998F, 0xFF5E7E6F, 0xFF5C8575, 0xFF486C5E, 0x00B5CAC3, 0x00FCFFFF, 0x00FFFCFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFF9FF, 0x00F7FFFF, 0xFFA3C2BA, 0xFF3A6657, 0xFF5F897B, 0xFF5C8273, 0xFF598272, 0xFF5D8978, 0xFF557E6C, 0xFF598270, 0xFF5A8371, 0xFF58816F, 0xFF5B8472,
    0xFF608977, 0xFF5F8876, 0xFF5C8573, 0xFF5D8978, 0xFF5F8A79, 0xFF5D8676, 0xFF588171, 0xFF628D7C, 0xFF61907E, 0xFF609380, 0xFF5B927D, 0xFF6C9084, 0xFF62887B, 0xFF668C7F, 0xFF638C7E, 0xFF5E887A, 0xFF5F897B, 0xFF5D897A, 0xFF598576, 0xFF588976,
    0xFF578875, 0xFF588775, 0xFF558472, 0xFF537F6E, 0xFF55806F, 0xFF588372, 0xFF55806F, 0xFF5D8676, 0xFF456E5E, 0xFF325B4B, 0xFF406959, 0xFF2D5646, 0xFF557E6E, 0xFF658E7E, 0xFF567F6F, 0xFF5A8574, 0xFF588372, 0xFF608B7A, 0xFF5C8575, 0xFF386151,
    0xFF376050, 0xFF486E5F, 0xFF618778, 0xFF5E8573, 0xFF5C8371, 0xFF5B8270, 0xFF5B8270, 0xFF5C8371, 0xFF5C8371, 0xFF5C8371, 0xFF5B8270, 0xFF5C8074, 0xFF587E6F, 0xFF557E6C, 0xFF56806C, 0xFF517865, 0xFF426456, 0xFF27453D, 0xFF405955, 0xFF5A6B65,
    0xFF1A2F28, 0xFF233E35, 0xFF103023, 0xFF416557, 0xFF5C8170, 0xFF5B7D6D, 0xFF577969, 0xFF57836C, 0xFF4B6D55, 0xFF35472F, 0xFF5D5D43, 0xFF9B8C6F, 0xFFAD9070, 0xFFB08C68, 0xFFB28B64, 0xFFB38F6B, 0xFF9F8264, 0xFF877561, 0xFF5F594D, 0xFF535851,
    0xFF495851, 0xFF3B5145, 0xFF2A4235, 0xFF244532, 0xFF1D3C2D, 0xFF173327, 0xFF162D25, 0xFF1A2D27, 0xFF1D2E26, 0xFF1C2C22, 0xFF1C2A1D, 0xFF16271D, 0xFF13241A, 0xFF112117, 0xFF131E16, 0xFF141E16, 0xFF171C16, 0xFF181A15, 0xFF171813, 0xFF1A1A18,
    0xFF1A1A18, 0xFF191917, 0xFF191917, 0xFF191917, 0xFF1A1A18, 0xFF1B1B19, 0xFF1C1C1A, 0xFF1D1415, 0xFF1B1515, 0xFF1A1915, 0xFF1B1D18, 0xFF1A211A, 0xFF172319, 0xFF18251B, 0xFF19291E, 0xFF163027, 0xFF143429, 0xFF144031, 0xFF184D3B, 0xFF1E5542,
    0xFF265948, 0xFF386254, 0xFF486C60, 0xFF4E7362, 0xFF507564, 0xFF527766, 0xFF537867, 0xFF547968, 0xFF557A69, 0xFF577C6B, 0xFF587D6C, 0xFF59806E, 0xFF59806E, 0xFF59806E, 0xFF59806E, 0xFF59806E, 0xFF59806E, 0xFF59806E, 0xFF59806E, 0xFF598471,
    0xFF557E6C, 0xFF598270, 0xFF537C6A, 0xFF5F8674, 0xFF5A816F, 0xFF5E8372, 0xFF688D7C, 0xFF638575, 0xFF5A7F6E, 0xFF5B8673, 0xFF4C7965, 0xFF365F4D, 0xFF3B5B4C, 0xFF8BA396, 0xFFE3F4EA, 0xFF253F3E, 0xFFA4BEBD, 0xFFC3DDDC, 0xFF2A4443, 0xFF597372,
    0xFF496362, 0xFF1A3433, 0xFF4E6867, 0xFF395549, 0xFF324E42, 0xFF7E9A8E, 0xFF274136, 0xFF2C463B, 0xFF889F95, 0xFF3E554B, 0xFF374E44, 0xFF4B5F53, 0xFF1F3528, 0xFF425A4C, 0xFF809C8D, 0xFF2D4C3C, 0xFF5E806F, 0xFF5B806E, 0xFF547967, 0xFF416352,
    0xFF2F5345, 0xFF2A4B3A, 0xFF46563B, 0xFF868157, 0xFFA7925D, 0xFFAC935B, 0xFFA08955, 0xFF7A7244, 0xFF333F27, 0xFF43574E, 0xFF787B70, 0xFFAAA496, 0xFFE5E5DD, 0xFFC1C4BD, 0xFF969286, 0xFF8D897D, 0xFF8F8B7F, 0xFF928E82, 0xFF979387, 0xFF9B978B,
    0xFF999589, 0xFF949084, 0xFF908C80, 0xFF8D8E80, 0xFF8D8E80, 0xFF908E81, 0xFF8C8A7E, 0xFF848276, 0xFF8E8B82, 0xFFB6B3AA, 0xFFDCD9D0, 0xFFB6C1B9, 0xFF788C81, 0xFF5F7F70, 0xFF608677, 0xFF4B6D5F, 0x00B5CAC3, 0x00FCFFFF, 0x00FFFCFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFF9FF, 0x00F9FFFF, 0xFFA3C2BA, 0xFF3B6758, 0xFF5F897B, 0xFF5F8576, 0xFF5A8373, 0xFF5C8877, 0xFF618A78, 0xFF628B79, 0xFF648D7B, 0xFF5F8876, 0xFF618A78,
    0xFF648D7B, 0xFF618A78, 0xFF668F7D, 0xFF5E8B77, 0xFF608977, 0xFF618675, 0xFF668677, 0xFF658777, 0xFF57806E, 0xFF548570, 0xFF538972, 0xFF598272, 0xFF578070, 0xFF5A8373, 0xFF5E8777, 0xFF598473, 0xFF5B8675, 0xFF5F8A79, 0xFF578271, 0xFF568573,
    0xFF558472, 0xFF558472, 0xFF578372, 0xFF578372, 0xFF588473, 0xFF588473, 0xFF568271, 0xFF588171, 0xFF618A7A, 0xFF436C5C, 0xFF325B4B, 0xFF406959, 0xFF3B6454, 0xFF567F6F, 0xFF628B7B, 0xFF588372, 0xFF578271, 0xFF598473, 0xFF5E8777, 0xFF355E4E,
    0xFF396252, 0xFF456B5C, 0xFF658B7C, 0xFF5E8573, 0xFF5D8472, 0xFF5C8371, 0xFF5C8371, 0xFF5C8371, 0xFF5D8472, 0xFF5C8371, 0xFF5A816F, 0xFF5A7E72, 0xFF587E6F, 0xFF537C6A, 0xFF557F6B, 0xFF527966, 0xFF456759, 0xFF26443C, 0xFF3A534F, 0xFF20312B,
    0xFF273C35, 0xFF223D34, 0xFF29493C, 0xFF284C3E, 0xFF4D7261, 0xFF587A6A, 0xFF537565, 0xFF5A8371, 0xFF4A6B5A, 0xFF334633, 0xFF41442F, 0xFF887E63, 0xFFB09D7D, 0xFFAB916E, 0xFFBCA07B, 0xFFAA906B, 0xFF998465, 0xFF7C6D56, 0xFF4B4839, 0xFF3B4338,
    0xFF36473D, 0xFF365045, 0xFF2B493D, 0xFF17402E, 0xFF113527, 0xFF0E2C20, 0xFF162B24, 0xFF222E2A, 0xFF252E29, 0xFF202622, 0xFF181D17, 0xFF182420, 0xFF16221E, 0xFF141F1B, 0xFF131C19, 0xFF151B19, 0xFF181A19, 0xFF181A19, 0xFF191919, 0xFF1B1B19,
    0xFF1B1B19, 0xFF1A1A18, 0xFF1A1A18, 0xFF1A1A18, 0xFF1B1B19, 0xFF1B1B19, 0xFF1B1B19, 0xFF1E181C, 0xFF1D181C, 0xFF1D1B1E, 0xFF1F1F1F, 0xFF1E2221, 0xFF1B241F, 0xFF19241E, 0xFF19241E, 0xFF1B211F, 0xFF14251F, 0xFF113227, 0xFF144434, 0xFF184F3C,
    0xFF1E5341, 0xFF2F5E4E, 0xFF416A5C, 0xFF4F7463, 0xFF517665, 0xFF547968, 0xFF557A69, 0xFF567B6A, 0xFF577C6B, 0xFF597E6D, 0xFF5A7F6E, 0xFF587F6D, 0xFF587F6D, 0xFF587F6D, 0xFF59806E, 0xFF59806E, 0xFF59806E, 0xFF59806E, 0xFF59806E, 0xFF578470,
    0xFF56836F, 0xFF588370, 0xFF4F7A67, 0xFF598270, 0xFF567F6D, 0xFF567F6D, 0xFF577E6C, 0xFF5C8170, 0xFF638A78, 0xFF598471, 0xFF406B58, 0xFF3D6654, 0xFF305242, 0xFF668274, 0xFFB0C8BB, 0xFF203E3C, 0xFF678583, 0xFF668482, 0xFF213F3D, 0xFF678583,
    0xFF577573, 0xFF274543, 0xFF2F4D4B, 0xFF25463B, 0xFF3C5D52, 0xFFABCBC0, 0xFF3E5E53, 0xFF234137, 0xFF4E6C62, 0xFF19342B, 0xFF445F56, 0xFF829A8C, 0xFF284032, 0xFF2B4637, 0xFF547061, 0xFF2C4B3B, 0xFF5B7C6B, 0xFF577968, 0xFF3C614F, 0xFF385A49,
    0xFF35594B, 0xFF335443, 0xFF425237, 0xFF7E794F, 0xFFA38E59, 0xFFAA9159, 0xFF9F8854, 0xFF7B7345, 0xFF313D25, 0xFF43574E, 0xFF797C71, 0xFFA8A294, 0xFFE6E6DE, 0xFFC4C7C0, 0xFF969286, 0xFF878070, 0xFF878070, 0xFF8B8474, 0xFF968F7F, 0xFFA09989,
    0xFF9F9888, 0xFF928B7B, 0xFF857E6E, 0xFF898377, 0xFF938D81, 0xFF969286, 0xFF8F8B80, 0xFF848075, 0xFF918D84, 0xFFBCB9B0, 0xFFDBD8CF, 0xFF829389, 0xFF637B6E, 0xFF5D7D6E, 0xFF618778, 0xFF4D6D60, 0x00B6C9C3, 0x00FCFFFF, 0x00FFFAFC, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFAFF, 0x00F9FFFF, 0xFFA4C3BB, 0xFF3C6859, 0xFF618B7D, 0xFF63897A, 0xFF517A6A, 0xFF457160, 0xFF4A7361, 0xFF48715F, 0xFF497260, 0xFF456E5C, 0xFF48715F,
    0xFF48715F, 0xFF436C5A, 0xFF4F7866, 0xFF5E8372, 0xFF537263, 0xFF51675B, 0xFF66766C, 0xFF57675D, 0xFF2E4438, 0xFF203F30, 0xFF254A39, 0xFF1C3C2F, 0xFF1B3D2F, 0xFF26483A, 0xFF35594B, 0xFF3E6254, 0xFF3A6051, 0xFF547D6D, 0xFF5D8676, 0xFF588171,
    0xFF5A8373, 0xFF5C8575, 0xFF5C8776, 0xFF5D8877, 0xFF5B8675, 0xFF5A8574, 0xFF5B8675, 0xFF5C8575, 0xFF5B8474, 0xFF5F8878, 0xFF3F6858, 0xFF3F6858, 0xFF3A6353, 0xFF396252, 0xFF5B8474, 0xFF598473, 0xFF5C8776, 0xFF568170, 0xFF5B8474, 0xFF376050,
    0xFF3D6656, 0xFF43695A, 0xFF678D7E, 0xFF5F8674, 0xFF5D8472, 0xFF5C8371, 0xFF5D8472, 0xFF5D8472, 0xFF5D8472, 0xFF5C8371, 0xFF5B8270, 0xFF5E8276, 0xFF5B8172, 0xFF547D6B, 0xFF547E6A, 0xFF567D6A, 0xFF4D6F61, 0xFF25433B, 0xFF2A433F, 0xFF34453F,
    0xFF334841, 0xFF334E45, 0xFF224235, 0xFF35594B, 0xFF234837, 0xFF547666, 0xFF5D7F6F, 0xFF537871, 0xFF4B6A62, 0xFF51685E, 0xFF4D5B4E, 0xFF929B88, 0xFFBFC4AD, 0xFF83876C, 0xFF7C8163, 0xFF838361, 0xFF838465, 0xFF6E745A, 0xFF384531, 0xFF172C1D,
    0xFF0C2B1C, 0xFF264C3D, 0xFF366052, 0xFF19503D, 0xFF174737, 0xFF183E2F, 0xFF1D372C, 0xFF23342C, 0xFF242F29, 0xFF1E2925, 0xFF18231F, 0xFF1D2726, 0xFF1B2524, 0xFF1A2322, 0xFF191F1F, 0xFF171D1D, 0xFF181C1D, 0xFF1A1E1F, 0xFF1E1F21, 0xFF1B1D1A,
    0xFF1C1E1B, 0xFF1C1E1B, 0xFF1D1F1C, 0xFF1D1F1C, 0xFF1C1E1B, 0xFF1B1D1A, 0xFF1B1D1A, 0xFF1B1F22, 0xFF1B1F22, 0xFF1C2124, 0xFF1C2524, 0xFF1D2927, 0xFF1C2B26, 0xFF192A24, 0xFF162721, 0xFF272526, 0xFF1D2623, 0xFF193028, 0xFF1A4033, 0xFF1B4B3B,
    0xFF1E5140, 0xFF2B5B4B, 0xFF386757, 0xFF4E7362, 0xFF507564, 0xFF537867, 0xFF557A69, 0xFF567B6A, 0xFF577C6B, 0xFF587D6C, 0xFF5A7F6E, 0xFF587F6D, 0xFF587F6D, 0xFF587F6D, 0xFF59806E, 0xFF59806E, 0xFF59806E, 0xFF5A816F, 0xFF5A816F, 0xFF507D69,
    0xFF55826E, 0xFF57826F, 0xFF507B68, 0xFF5A8371, 0xFF567F6D, 0xFF598270, 0xFF587F6D, 0xFF5C8170, 0xFF557C6A, 0xFF416A58, 0xFF335C4A, 0xFF466D5B, 0xFF2E5342, 0xFF2F4F40, 0xFF416051, 0xFF416557, 0xFF365A4C, 0xFF14382A, 0xFF305446, 0xFF54786A,
    0xFF325648, 0xFF284C3E, 0xFF426658, 0xFF34584C, 0xFF395D51, 0xFF62867A, 0xFF4A6B60, 0xFF44655A, 0xFF3C5C51, 0xFF416156, 0xFF27473C, 0xFF264132, 0xFF3B5748, 0xFF587465, 0xFF456454, 0xFF4B6C5B, 0xFF557665, 0xFF3F6150, 0xFF3B5D4C, 0xFF325443,
    0xFF416557, 0xFF3E5F4E, 0xFF435338, 0xFF807B51, 0xFFA5905B, 0xFFA88F57, 0xFF9E8753, 0xFF797143, 0xFF2D3921, 0xFF43574E, 0xFF7B7E73, 0xFFA7A193, 0xFFE5E5DD, 0xFFC6C9C2, 0xFF959185, 0xFF898272, 0xFF888171, 0xFF8B8474, 0xFF968F7F, 0xFFA09989,
    0xFFA09989, 0xFF958E7E, 0xFF8A8373, 0xFF888075, 0xFF958D82, 0xFF999387, 0xFF8F8B80, 0xFF858176, 0xFF9C9990, 0xFFC5C5BB, 0xFFCECEC4, 0xFF6F877A, 0xFF617D6F, 0xFF5F8171, 0xFF5F8375, 0xFF4B695D, 0x00B6C7C1, 0x00FCFFFF, 0x00FFFEFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFF5FC, 0x00F9FFFF, 0xFFA3C2BA, 0xFF416D5E, 0xFF648E80, 0xFF5E8475, 0xFF355E4E, 0xFF164231, 0xFF1A4331, 0xFF163F2D, 0xFF17402E, 0xFF123B29, 0xFF194230,
    0xFF1C4533, 0xFF103927, 0xFF1A4331, 0xFF59796A, 0xFF3C5447, 0xFF414C44, 0xFF8F8E8A, 0xFFADA9A6, 0xFF959691, 0xFF879189, 0xFF89998F, 0xFF87978D, 0xFF87988E, 0xFF72867B, 0xFF486053, 0xFF405C4E, 0xFF325243, 0xFF5A7F6E, 0xFF5F8473, 0xFF628476,
    0xFF66887A, 0xFF67897B, 0xFF64887A, 0xFF628879, 0xFF5E8475, 0xFF5D8676, 0xFF638C7C, 0xFF618A7A, 0xFF547D6D, 0xFF5A8373, 0xFF668F7F, 0xFF365F4F, 0xFF3D6656, 0xFF3C6555, 0xFF3B6454, 0xFF578271, 0xFF5C8776, 0xFF598473, 0xFF5A8373, 0xFF3A6353,
    0xFF3F6858, 0xFF446A5B, 0xFF668C7D, 0xFF5E8573, 0xFF5D8472, 0xFF5D8472, 0xFF5D8472, 0xFF5E8573, 0xFF5E8573, 0xFF5D8472, 0xFF5B8270, 0xFF5C8074, 0xFF5D8374, 0xFF598270, 0xFF5A8470, 0xFF5B826F, 0xFF4B6D5F, 0xFF16342C, 0xFF112A26, 0xFF1C2D27,
    0xFF122720, 0xFF0C271E, 0xFF234336, 0xFF315547, 0xFF385D4C, 0xFF305242, 0xFF486A5A, 0xFF5F847D, 0xFF4D6D68, 0xFF537169, 0xFF49635A, 0xFF6A8477, 0xFF6F8B7C, 0xFF24442F, 0xFF21422D, 0xFF466045, 0xFF496348, 0xFF415A44, 0xFF28442E, 0xFF1F3E2C,
    0xFF1C4331, 0xFF335F4E, 0xFF3A6B58, 0xFF1B5848, 0xFF1E5343, 0xFF1E4737, 0xFF1D372A, 0xFF18291F, 0xFF16231C, 0xFF152421, 0xFF182827, 0xFF1E2827, 0xFF1E2827, 0xFF1D2726, 0xFF1A2423, 0xFF182120, 0xFF182120, 0xFF1B2423, 0xFF1E2726, 0xFF191F1B,
    0xFF1A201C, 0xFF1D231F, 0xFF1E2420, 0xFF1E2420, 0xFF1C221E, 0xFF191F1B, 0xFF181E1A, 0xFF162021, 0xFF162021, 0xFF162220, 0xFF172623, 0xFF1A2B25, 0xFF1D2E28, 0xFF182C23, 0xFF13271E, 0xFF232122, 0xFF1D2120, 0xFF182722, 0xFF19332A, 0xFF1A3E32,
    0xFF1D493A, 0xFF275747, 0xFF316453, 0xFF4A6F5E, 0xFF4D7261, 0xFF507564, 0xFF537867, 0xFF547968, 0xFF547968, 0xFF567B6A, 0xFF577C6B, 0xFF577E6C, 0xFF587F6D, 0xFF587F6D, 0xFF587F6D, 0xFF59806E, 0xFF5A816F, 0xFF5A816F, 0xFF5A816F, 0xFF537E6B,
    0xFF58816F, 0xFF598270, 0xFF557E6C, 0xFF608775, 0xFF587F6D, 0xFF608574, 0xFF618675, 0xFF608272, 0xFF517363, 0xFF4B6D5D, 0xFF436555, 0xFF446656, 0xFF406051, 0xFF416152, 0xFF436354, 0xFF4C725D, 0xFF527863, 0xFF3D634E, 0xFF507661, 0xFF2F5540,
    0xFF1B412C, 0xFF375D48, 0xFF4A705B, 0xFF24483A, 0xFF2D5143, 0xFF4B6F61, 0xFF3C5E50, 0xFF547668, 0xFF49695C, 0xFF47675A, 0xFF537366, 0xFF537262, 0xFF365545, 0xFF577666, 0xFF5E7F6E, 0xFF587968, 0xFF436453, 0xFF406150, 0xFF375847, 0xFF426453,
    0xFF4E7264, 0xFF416251, 0xFF3F4F34, 0xFF7D784E, 0xFFA28D58, 0xFFA68D55, 0xFFA08955, 0xFF776F41, 0xFF29351D, 0xFF43574E, 0xFF7C7F74, 0xFFA49E90, 0xFFE4E4DC, 0xFFC9CCC5, 0xFF979387, 0xFF938D7D, 0xFF948E7E, 0xFF969080, 0xFF999383, 0xFF9C9686,
    0xFF9E9888, 0xFF9E9888, 0xFF9E9888, 0xFF999186, 0xFF9C968A, 0xFF999589, 0xFF908E82, 0xFF838377, 0xFFA0A297, 0xFFC5C8BD, 0xFFB2B5AA, 0xFF607F70, 0xFF5F7F70, 0xFF608272, 0xFF608274, 0xFF4D695D, 0x00B6C7C1, 0x00FCFFFF, 0x00FFFEFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFF9FF, 0x00F8FFFF, 0xFF9CBBB3, 0xFF406C5D, 0xFF638D7F, 0xFF5E8475, 0xFF325B4B, 0xFF164231, 0xFF3C6553, 0xFF38614F, 0xFF325B49, 0xFF254E3C, 0xFF325B49,
    0xFF396250, 0xFF1F4836, 0xFF194230, 0xFF58826E, 0xFF355142, 0xFF3F4B41, 0xFFADA8A4, 0xFFEBE0DE, 0xFFE8DEDC, 0xFFDEDBD6, 0xFFDCDFD8, 0xFFE5E1DE, 0xFFEDEEE9, 0xFFC1C6C0, 0xFF5E6961, 0xFF485C51, 0xFF2F493C, 0xFF59796A, 0xFF496B5B, 0xFF4E685D,
    0xFF496358, 0xFF405C50, 0xFF3E5C50, 0xFF466659, 0xFF46685A, 0xFF456759, 0xFF486C5E, 0xFF578070, 0xFF628B7B, 0xFF5B8474, 0xFF557E6E, 0xFF628B7B, 0xFF3C6555, 0xFF436C5C, 0xFF315A4A, 0xFF477261, 0xFF4F7A69, 0xFF5C8776, 0xFF5B8474, 0xFF3A6353,
    0xFF3C6555, 0xFF496F60, 0xFF618778, 0xFF5D8472, 0xFF5D8472, 0xFF5D8472, 0xFF5E8573, 0xFF5F8674, 0xFF5F8674, 0xFF5E8573, 0xFF5C8371, 0xFF5A7E72, 0xFF5C8273, 0xFF5B8472, 0xFF5D8773, 0xFF59806D, 0xFF446658, 0xFF133129, 0xFF152E2A, 0xFF162721,
    0xFF172C25, 0xFF142F26, 0xFF2A4A3D, 0xFF4C7062, 0xFF2E5342, 0xFF3E6050, 0xFF365848, 0xFF507967, 0xFF547A6B, 0xFF587A6C, 0xFF618174, 0xFF668679, 0xFF4D6F61, 0xFF305647, 0xFF376050, 0xFF325D4C, 0xFF496F60, 0xFF5A7C6C, 0xFF587767, 0xFF587968,
    0xFF4A6F5D, 0xFF47725F, 0xFF356450, 0xFF1C5245, 0xFF1C4A3D, 0xFF1C3C2F, 0xFF192B1F, 0xFF142016, 0xFF131C17, 0xFF15211F, 0xFF172526, 0xFF19261F, 0xFF1B2821, 0xFF1D2A23, 0xFF1C2922, 0xFF19261F, 0xFF18251E, 0xFF1A2720, 0xFF1D2A23, 0xFF14211A,
    0xFF17241D, 0xFF1B2821, 0xFF1D2A23, 0xFF1D2A23, 0xFF19261F, 0xFF15221B, 0xFF121F18, 0xFF131C1B, 0xFF141D1A, 0xFF141D1A, 0xFF16211D, 0xFF1C2721, 0xFF202D26, 0xFF1D2A21, 0xFF16231A, 0xFF171B1A, 0xFF171B1A, 0xFF161F1C, 0xFF13221D, 0xFF132A22,
    0xFF173B2F, 0xFF225242, 0xFF2D6451, 0xFF496E5D, 0xFF4C7160, 0xFF507564, 0xFF527766, 0xFF547968, 0xFF547968, 0xFF567B6A, 0xFF577C6B, 0xFF577E6C, 0xFF577E6C, 0xFF587F6D, 0xFF587F6D, 0xFF59806E, 0xFF5A816F, 0xFF5A816F, 0xFF5A816F, 0xFF5D8472,
    0xFF5D8472, 0xFF5A7F6E, 0xFF587D6C, 0xFF5B7D6D, 0xFF426454, 0xFF3E6050, 0xFF3B5B4C, 0xFF365647, 0xFF395849, 0xFF456455, 0xFF3F5B4D, 0xFF2B4739, 0xFF304F40, 0xFF355445, 0xFF426253, 0xFF254736, 0xFF3A5C4B, 0xFF3D5F4E, 0xFF345645, 0xFF244635,
    0xFF335544, 0xFF436554, 0xFF254736, 0xFF214634, 0xFF456756, 0xFF365847, 0xFF244635, 0xFF496A59, 0xFF2B4C3B, 0xFF1F3E2E, 0xFF1E3D2D, 0xFF3C5D4C, 0xFF4D6E5D, 0xFF557665, 0xFF547564, 0xFF486958, 0xFF446554, 0xFF406150, 0xFF456655, 0xFF547665,
    0xFF4A6E60, 0xFF355645, 0xFF39492E, 0xFF777248, 0xFF9E8954, 0xFFA58C54, 0xFFA08955, 0xFF756D3F, 0xFF27331B, 0xFF42564D, 0xFF7B7E73, 0xFFA09A8C, 0xFFE2E2DA, 0xFFCCCFC8, 0xFF9B978B, 0xFF9A968A, 0xFF9B978B, 0xFF9C988C, 0xFF9B978B, 0xFF999589,
    0xFF9B978B, 0xFF9F9B8F, 0xFFA4A094, 0xFFA6A094, 0xFF9F9B8F, 0xFF9C9A8D, 0xFF949488, 0xFF7D8173, 0xFF979D91, 0xFFBEC6B9, 0xFF9FAA9C, 0xFF557767, 0xFF5B806F, 0xFF5D8271, 0xFF618375, 0xFF516B60, 0x00B8C7C2, 0x00FCFFFF, 0x00FEFCFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFAFF, 0x00F5FEFD, 0xFF97B6AE, 0xFF3F6B5C, 0xFF638D7F, 0xFF5D8374, 0xFF335C4C, 0xFF1D4938, 0xFF4B7462, 0xFF48715F, 0xFF406957, 0xFF305947, 0xFF436C5A,
    0xFF517A68, 0xFF2F5846, 0xFF1B4432, 0xFF4C7D67, 0xFF3A5F4D, 0xFF546459, 0xFFC1BEB9, 0xFFF0E2E1, 0xFFDED0CF, 0xFFC9C4C0, 0xFFC2C1BC, 0xFFDACACB, 0xFFE8DCDC, 0xFFC8C3C0, 0xFF676964, 0xFF57645B, 0xFF22382C, 0xFF405C4E, 0xFF284839, 0xFF556A61,
    0xFF42574E, 0xFF294036, 0xFF264035, 0xFF365246, 0xFF38564A, 0xFF2F4F42, 0xFF2B4B3E, 0xFF598272, 0xFF5A8373, 0xFF5F8878, 0xFF5F8878, 0xFF5A8373, 0xFF5F8878, 0xFF416A5A, 0xFF396252, 0xFF366150, 0xFF3E6958, 0xFF5C8776, 0xFF5C8575, 0xFF376050,
    0xFF386151, 0xFF4E7465, 0xFF5D8374, 0xFF5D8472, 0xFF5C8371, 0xFF5D8472, 0xFF5E8573, 0xFF608775, 0xFF608775, 0xFF5F8674, 0xFF5D8472, 0xFF5F8377, 0xFF5B8172, 0xFF57806E, 0xFF57816D, 0xFF527966, 0xFF426456, 0xFF25433B, 0xFF3B5450, 0xFF42534D,
    0xFF1C312A, 0xFF243F36, 0xFF39594C, 0xFF537769, 0xFF4D7261, 0xFF335545, 0xFF3E6050, 0xFF295639, 0xFF568166, 0xFF51745E, 0xFF587765, 0xFF4E6D5D, 0xFF365546, 0xFF436557, 0xFF2F5347, 0xFF1F4E46, 0xFF3E6960, 0xFF567A70, 0xFF59776B, 0xFF5D796A,
    0xFF517060, 0xFF4D6F5E, 0xFF345B49, 0xFF1E4B44, 0xFF1B3E37, 0xFF192E25, 0xFF1B251C, 0xFF20231C, 0xFF222421, 0xFF1F2427, 0xFF1A2529, 0xFF112019, 0xFF15241D, 0xFF1A2922, 0xFF1B2A23, 0xFF182720, 0xFF15261E, 0xFF172820, 0xFF192A22, 0xFF12211A,
    0xFF15241D, 0xFF192821, 0xFF1C2B24, 0xFF1C2B24, 0xFF182720, 0xFF13221B, 0xFF0F1E17, 0xFF161817, 0xFF171918, 0xFF171916, 0xFF191B18, 0xFF1F241E, 0xFF242923, 0xFF222721, 0xFF1B2019, 0xFF16211D, 0xFF1C2220, 0xFF1C201F, 0xFF161C1A, 0xFF0E1F19,
    0xFF113126, 0xFF1E4D3D, 0xFF28614E, 0xFF4B705F, 0xFF4E7362, 0xFF527766, 0xFF557A69, 0xFF567B6A, 0xFF577C6B, 0xFF587D6C, 0xFF597E6D, 0xFF577E6C, 0xFF577E6C, 0xFF587F6D, 0xFF587F6D, 0xFF59806E, 0xFF5A816F, 0xFF5A816F, 0xFF5B8270, 0xFF5A7F6E,
    0xFF5B7D6D, 0xFF5A7C6C, 0xFF5D7F6F, 0xFF5C7C6D, 0xFF355546, 0xFF264536, 0xFF1B3A2B, 0xFF2B4A3B, 0xFF3D594B, 0xFF4C6659, 0xFF4E6659, 0xFF3F574A, 0xFF385245, 0xFF0F2E1F, 0xFF0F2F20, 0xFF2B4C43, 0xFF2C4D44, 0xFF46675E, 0xFF37584F, 0xFF2D4E45,
    0xFF1F4037, 0xFF27483F, 0xFF22433A, 0xFF345743, 0xFF3A5D49, 0xFF4C6D5A, 0xFF264734, 0xFF2B4A38, 0xFF365543, 0xFF2B4A38, 0xFF23402E, 0xFF2D4F3E, 0xFF446655, 0xFF456655, 0xFF5A7B6A, 0xFF375847, 0xFF456655, 0xFF486958, 0xFF557665, 0xFF507261,
    0xFF365A4C, 0xFF254635, 0xFF39492E, 0xFF7A754B, 0xFF9F8A55, 0xFFA78E56, 0xFF9D8652, 0xFF756D3F, 0xFF253119, 0xFF42564D, 0xFF7A7D72, 0xFF9D9789, 0xFFE0E0D8, 0xFFCDD0C9, 0xFF9E9A8E, 0xFF9B998D, 0xFF9B998D, 0xFF9A988C, 0xFF99978B, 0xFF99978B,
    0xFF9A988C, 0xFF9A988C, 0xFF9B998D, 0xFFA29E92, 0xFF9A988B, 0xFF9C9D8F, 0xFF97998C, 0xFF777D6F, 0xFF8D988A, 0xFFBDC9BB, 0xFFA3AFA1, 0xFF5A7F6E, 0xFF618675, 0xFF608574, 0xFF638376, 0xFF536D62, 0x00B8C7C2, 0x00FCFFFF, 0x00FEFCFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFF, 0x04F3FEFA, 0xFF9EBCB2, 0xFF40695B, 0xFF62887B, 0xFF5D8175, 0xFF315B4D, 0xFF205040, 0xFF446D5B, 0xFF1C4533, 0xFF466F5D, 0xFF2D5644, 0xFF1E4735,
    0xFF517A68, 0xFF37604E, 0xFF194230, 0xFF59856E, 0xFF4B6E5A, 0xFF627466, 0xFFC6C9C0, 0xFFE3E0D9, 0xFFCEC9C3, 0xFFC3C4BC, 0xFFB8BEB4, 0xFFD5D0CC, 0xFFDEDBD6, 0xFFC8CBC4, 0xFF808A81, 0xFF637569, 0xFF597163, 0xFF3E5D4D, 0xFF628372, 0xFF9AA3A2,
    0xFF6F7877, 0xFF586160, 0xFF5B6463, 0xFF626B6A, 0xFF8F9897, 0xFF7E8786, 0xFF333C3B, 0xFF588372, 0xFF5C8776, 0xFF5A8574, 0xFF588372, 0xFF55806F, 0xFF608B7A, 0xFF618C7B, 0xFF3A6554, 0xFF39604E, 0xFF375E4C, 0xFF466D5B, 0xFF59806E, 0xFF3C6351,
    0xFF406755, 0xFF476E5C, 0xFF638A78, 0xFF5C8774, 0xFF5D8674, 0xFF5C8573, 0xFF5B8472, 0xFF5D8472, 0xFF5D8472, 0xFF5F8473, 0xFF608574, 0xFF648978, 0xFF587F6D, 0xFF5B8172, 0xFF5E8274, 0xFF617F75, 0xFF496058, 0xFF364540, 0xFF5D6766, 0xFF5A6966,
    0xFF2D403A, 0xFF243E35, 0xFF37554B, 0xFF547668, 0xFF5A7C6E, 0xFF517162, 0xFF335243, 0xFF3F604D, 0xFF2E5A43, 0xFF1D432E, 0xFF304033, 0xFF465246, 0xFF445C4C, 0xFF35503F, 0xFF39473A, 0xFF4E4D3B, 0xFF3A4934, 0xFF2B4F35, 0xFF517D64, 0xFF49735F,
    0xFF4C7263, 0xFF446E62, 0xFF2E6152, 0xFF2F4038, 0xFF12211A, 0xFF15201A, 0xFF222B26, 0xFF1B251C, 0xFF3C483A, 0xFF2F412B, 0xFF2C4027, 0xFF324238, 0xFF324238, 0xFF34453B, 0xFF2D3E36, 0xFF2A3E35, 0xFF31443E, 0xFF2D423B, 0xFF2C413A, 0xFF34483C,
    0xFF314539, 0xFF283C30, 0xFF2E4236, 0xFF304438, 0xFF263A2E, 0xFF25392D, 0xFF25392D, 0xFF1E3324, 0xFF253A2B, 0xFF253A2B, 0xFF203526, 0xFF263B2C, 0xFF304536, 0xFF2A3F30, 0xFF1B3021, 0xFF21381B, 0xFF203320, 0xFF2B3733, 0xFF1B2423, 0xFF172119,
    0xFF151F14, 0xFF25312D, 0xFF445255, 0xFF506E62, 0xFF4F7163, 0xFF496F60, 0xFF57806E, 0xFF517C69, 0xFF527B69, 0xFF547967, 0xFF5A7C6B, 0xFF557A68, 0xFF577C6A, 0xFF597E6C, 0xFF5A7F6D, 0xFF5A7F6D, 0xFF5A7F6D, 0xFF5B806E, 0xFF5C816F, 0xFF5B7F75,
    0xFF547967, 0xFF5C846A, 0xFF53836B, 0xFF518171, 0xFF2F5349, 0xFF434D44, 0xFF64584C, 0xFF6A6964, 0xFF4C5042, 0xFF30483A, 0xFF557C7B, 0xFF3C585B, 0xFF474A41, 0xFF474634, 0xFF2F3A2C, 0xFF505141, 0xFF395144, 0xFF39675D, 0xFF204A40, 0xFF334839,
    0xFF474838, 0xFF504E41, 0xFF444A3E, 0xFF4C483C, 0xFF3B5749, 0xFF3B655B, 0xFF3C514A, 0xFF4C4C40, 0xFF535540, 0xFF4A523D, 0xFF272F20, 0xFF35503D, 0xFF3F5F4A, 0xFF436652, 0xFF4E7560, 0xFF3A614E, 0xFF355A48, 0xFF5F8171, 0xFF5E7E6F, 0xFF3D594A,
    0xFF2D5646, 0xFF234E3A, 0xFF2F4629, 0xFF7D744B, 0xFF9E8250, 0xFFA68D55, 0xFF978A53, 0xFF7A6F42, 0xFF2E3820, 0xFF44554D, 0xFF7E8176, 0xFF9B9386, 0xFFE4E1DA, 0xFFCDCEC8, 0xFF999387, 0xFF95907D, 0xFF948F7C, 0xFF97927F, 0xFF9F9A87, 0xFFA8A390,
    0xFFA7A28F, 0xFF9D9885, 0xFF938E7B, 0xFF969082, 0xFF938D7F, 0xFF989586, 0xFF8F8B7F, 0xFF807E71, 0xFF939185, 0xFFA8A69A, 0xFF9D9D91, 0xFF5A7F6D, 0xFF5A7F6D, 0xFF577C6B, 0xFF648475, 0xFF577164, 0x00B6C5BE, 0x00F9FEFA, 0x00FFFEFC, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFF, 0x00F6FFFD, 0xFF9DBBB1, 0xFF3F685A, 0xFF648A7D, 0xFF618579, 0xFF325C4E, 0xFF1B4B3B, 0xFF4A7361, 0xFF3F6856, 0xFF426B59, 0xFF2B5442, 0xFF3B6452,
    0xFF527B69, 0xFF295240, 0xFF194230, 0xFF567867, 0xFF456051, 0xFF626E64, 0xFFC5C4BF, 0xFFE0D6D4, 0xFFD1C7C5, 0xFFD5D0CC, 0xFFCDCCC7, 0xFFD4CAC9, 0xFFE3DBD9, 0xFFD0CCC9, 0xFF737570, 0xFF6E7971, 0xFF4A5B51, 0xFF465C50, 0xFF556F62, 0xFF8B9B98,
    0xFF7C8C89, 0xFF5D6D6A, 0xFF566663, 0xFF677774, 0xFF879794, 0xFF768683, 0xFF52625F, 0xFF45705F, 0xFF5C8776, 0xFF5A8574, 0xFF527D6C, 0xFF5A8574, 0xFF5E8978, 0xFF5B8675, 0xFF578271, 0xFF476E5C, 0xFF3C6351, 0xFF3B6250, 0xFF466D5B, 0xFF2E5543,
    0xFF3D6452, 0xFF49705E, 0xFF648B79, 0xFF5C8774, 0xFF5D8674, 0xFF5C8573, 0xFF5C8573, 0xFF5E8573, 0xFF5E8573, 0xFF608574, 0xFF618675, 0xFF628776, 0xFF628776, 0xFF648A7B, 0xFF5B8172, 0xFF5B7C71, 0xFF4E6960, 0xFF354C44, 0xFF41544E, 0xFF34453F,
    0xFF2D423B, 0xFF304B42, 0xFF36564B, 0xFF517567, 0xFF628678, 0xFF648676, 0xFF4D6F5F, 0xFF365543, 0xFF3B654F, 0xFF315440, 0xFF4C5A4D, 0xFF5F695E, 0xFF435A4A, 0xFF172F1F, 0xFF344034, 0xFF5C5948, 0xFF3F4C38, 0xFF24462E, 0xFF537B63, 0xFF507563,
    0xFF527466, 0xFF4A7063, 0xFF2E5A4D, 0xFF182720, 0xFF16211B, 0xFF131C17, 0xFF1A1F19, 0xFF232821, 0xFF5E695B, 0xFF6F7C6A, 0xFF768872, 0xFF5B6856, 0xFF6B7A67, 0xFF788774, 0xFF6C7A69, 0xFF657664, 0xFF6D7E6E, 0xFF677969, 0xFF617363, 0xFF6C7C6F,
    0xFF627265, 0xFF5D6D60, 0xFF667669, 0xFF647467, 0xFF607063, 0xFF67776A, 0xFF647467, 0xFF607161, 0xFF637464, 0xFF627363, 0xFF617262, 0xFF5F7060, 0xFF586959, 0xFF455646, 0xFF324333, 0xFF65795D, 0xFF707E6F, 0xFF5A6360, 0xFF1F2523, 0xFF181D16,
    0xFF10180D, 0xFF0E1712, 0xFF293237, 0xFF3F5D51, 0xFF557568, 0xFF517567, 0xFF4F7866, 0xFF4A7361, 0xFF527967, 0xFF557A68, 0xFF5A7C6B, 0xFF567B69, 0xFF587D6B, 0xFF5A7F6D, 0xFF5B806E, 0xFF5A7F6D, 0xFF5A7F6D, 0xFF5B806E, 0xFF5C816F, 0xFF5B8176,
    0xFF577C6A, 0xFF598167, 0xFF558369, 0xFF4C7867, 0xFF2D4B3F, 0xFF585C4D, 0xFF746351, 0xFF786556, 0xFF695F46, 0xFF47533B, 0xFF567669, 0xFF3A4F46, 0xFF56503A, 0xFF6B5A40, 0xFF5E563F, 0xFF5E523A, 0xFF3D4935, 0xFF375847, 0xFF284735, 0xFF586049,
    0xFF71654D, 0xFF695942, 0xFF635B46, 0xFF554D36, 0xFF445A43, 0xFF294C38, 0xFF3D4838, 0xFF726552, 0xFF67593E, 0xFF5E573A, 0xFF5E563F, 0xFF314C39, 0xFF466651, 0xFF436652, 0xFF426954, 0xFF39604D, 0xFF3B604E, 0xFF537565, 0xFF426253, 0xFF345041,
    0xFF315A4A, 0xFF2C5743, 0xFF30472A, 0xFF7B7249, 0xFF9D814F, 0xFFA58C54, 0xFF968952, 0xFF796E41, 0xFF2E3820, 0xFF42534B, 0xFF7D8075, 0xFF9A9285, 0xFFE4E1DA, 0xFFD1D2CC, 0xFF9D978B, 0xFF8A8572, 0xFF898471, 0xFF8D8875, 0xFF97927F, 0xFFA29D8A,
    0xFFA29D8A, 0xFF96917E, 0xFF8A8572, 0xFF8C8678, 0xFF908A7C, 0xFF979485, 0xFF908C80, 0xFF848275, 0xFF929084, 0xFFA4A296, 0xFF9E9E92, 0xFF618372, 0xFF618674, 0xFF608574, 0xFF638575, 0xFF506A5D, 0x00B1C0B9, 0x00FBFFFC, 0x00FFFFFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFCFE, 0x08F2FDF9, 0xFF99B7AD, 0xFF3F685A, 0xFF688E81, 0xFF678B7F, 0xFF355F51, 0xFF174737, 0xFF416A58, 0xFF4D7664, 0xFF355E4C, 0xFF244D3B, 0xFF436C5A,
    0xFF426B59, 0xFF1F4836, 0xFF1B4432, 0xFF5D796D, 0xFF4C6057, 0xFF5E6762, 0xFFBDBCBA, 0xFFEDE4E5, 0xFFE0D7D8, 0xFFD5D1D0, 0xFFCAC9C7, 0xFFDED5D8, 0xFFE9E3E5, 0xFFC7C5C6, 0xFF5C5E5D, 0xFF8B9491, 0xFF51605B, 0xFF50615B, 0xFF495E57, 0xFF2D4841,
    0xFF4B665F, 0xFF4B665F, 0xFF3E5952, 0xFF3D5851, 0xFF4A655E, 0xFF516C65, 0xFF607B74, 0xFF3E6958, 0xFF487362, 0xFF5D8877, 0xFF5F8A79, 0xFF547F6E, 0xFF578271, 0xFF5D8877, 0xFF5D8877, 0xFF59806E, 0xFF486F5D, 0xFF365D4B, 0xFF385F4D, 0xFF224937,
    0xFF3D6452, 0xFF49705E, 0xFF618876, 0xFF5C8774, 0xFF5C8573, 0xFF5C8573, 0xFF5C8573, 0xFF5F8674, 0xFF608775, 0xFF618675, 0xFF628776, 0xFF638575, 0xFF618675, 0xFF648B79, 0xFF5A8373, 0xFF5D8676, 0xFF587C70, 0xFF38584D, 0xFF27453B, 0xFF324740,
    0xFF375148, 0xFF3D5D52, 0xFF44685A, 0xFF567F6F, 0xFF5A8371, 0xFF5E8573, 0xFF608574, 0xFF4E695A, 0xFF365B49, 0xFF3F5E4E, 0xFF788279, 0xFF636861, 0xFF3D4F43, 0xFF22362A, 0xFF585F57, 0xFF8A8478, 0xFF596453, 0xFF24412B, 0xFF567965, 0xFF567565,
    0xFF557165, 0xFF4B695F, 0xFF1E4238, 0xFF131E18, 0xFF242A26, 0xFF1A1F19, 0xFF181913, 0xFF12130B, 0xFF373D31, 0xFF444C3D, 0xFF495645, 0xFF2F3920, 0xFF3D472E, 0xFF49533B, 0xFF3B472F, 0xFF35412B, 0xFF3D4B34, 0xFF3C4A33, 0xFF394632, 0xFF3F4A3C,
    0xFF323D2F, 0xFF323D2F, 0xFF3C4739, 0xFF354032, 0xFF343F31, 0xFF3F4A3C, 0xFF364133, 0xFF374232, 0xFF354030, 0xFF343F2F, 0xFF374232, 0xFF3A4535, 0xFF3A4535, 0xFF384333, 0xFF384333, 0xFF2E3D26, 0xFF303A2F, 0xFF313534, 0xFF0D0F0C, 0xFF101207,
    0xFF1A1D12, 0xFF161B17, 0xFF151A20, 0xFF243E33, 0xFF4E6C60, 0xFF527466, 0xFF4E7563, 0xFF527B69, 0xFF577E6C, 0xFF567B69, 0xFF5A7C6B, 0xFF587D6B, 0xFF5A7F6D, 0xFF5B806E, 0xFF5B806E, 0xFF5B806E, 0xFF5A7F6D, 0xFF5B806E, 0xFF5C816F, 0xFF588077,
    0xFF59806E, 0xFF597F66, 0xFF5B856D, 0xFF537A67, 0xFF3C5341, 0xFF817C66, 0xFF9E8567, 0xFFA37B61, 0xFF9B815C, 0xFF626641, 0xFF567057, 0xFF3C4B34, 0xFF716140, 0xFFA17F59, 0xFFA18361, 0xFF9A805F, 0xFF58573B, 0xFF445A43, 0xFF3D4F37, 0xFF767154,
    0xFFA88D6F, 0xFFA58667, 0xFFAA8F71, 0xFF7A6F4F, 0xFF465939, 0xFF3D5A3E, 0xFF74765E, 0xFFAC9478, 0xFFA18560, 0xFFA68E6A, 0xFF8C7354, 0xFF334E3B, 0xFF456550, 0xFF456854, 0xFF476E59, 0xFF3B624F, 0xFF2C513F, 0xFF385A4A, 0xFF365647, 0xFF355142,
    0xFF3E6757, 0xFF38634F, 0xFF334A2D, 0xFF7B7249, 0xFF9D814F, 0xFFA48B53, 0xFF958851, 0xFF7C7144, 0xFF303A22, 0xFF41524A, 0xFF7C7F74, 0xFF999184, 0xFFE3E0D9, 0xFFD2D3CD, 0xFF9F998D, 0xFF898471, 0xFF898471, 0xFF8D8875, 0xFF97927F, 0xFFA29D8A,
    0xFFA29D8A, 0xFF97927F, 0xFF8D8875, 0xFF8F897B, 0xFF969082, 0xFF999687, 0xFF938F83, 0xFF8D8B7E, 0xFF9F9D91, 0xFFB9B7AB, 0xFFC3C3B7, 0xFF5F7E6E, 0xFF5D7E6D, 0xFF648676, 0xFF658777, 0xFF4D695B, 0x00ACBDB5, 0x00FAFFFB, 0x00FFFEFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFF, 0x00F8FFFF, 0xFF9DBBB1, 0xFF416A5C, 0xFF678D80, 0xFF62867A, 0xFF315B4D, 0xFF114131, 0xFF163F2D, 0xFF1F4836, 0xFF133C2A, 0xFF0D3624, 0xFF1C4533,
    0xFF1D4634, 0xFF153E2C, 0xFF194230, 0xFF597870, 0xFF556E68, 0xFF556864, 0xFFA5AFAE, 0xFFEDF3F3, 0xFFE3E9E9, 0xFFCFD8D7, 0xFFD3DDDC, 0xFFE0E6E6, 0xFFE3ECEB, 0xFFBEC8C7, 0xFF5D6C69, 0xFFA6B9B5, 0xFF758C86, 0xFF69827C, 0xFF647F78, 0xFF648D7F,
    0xFF5E8779, 0xFF567F71, 0xFF547D6F, 0xFF588173, 0xFF5B8476, 0xFF4A7365, 0xFF335C4E, 0xFF3A6554, 0xFF345F4E, 0xFF537E6D, 0xFF618C7B, 0xFF568170, 0xFF598473, 0xFF5B8675, 0xFF578271, 0xFF638A78, 0xFF557C6A, 0xFF3C6351, 0xFF39604E, 0xFF214836,
    0xFF406755, 0xFF486F5D, 0xFF5C8371, 0xFF5A8572, 0xFF5B8472, 0xFF5B8472, 0xFF5C8573, 0xFF5F8674, 0xFF5F8674, 0xFF618675, 0xFF628776, 0xFF648574, 0xFF5C816F, 0xFF5D8674, 0xFF5A8572, 0xFF5B8776, 0xFF5C8776, 0xFF477062, 0xFF3A6053, 0xFF435A52,
    0xFF425D54, 0xFF4A6C5E, 0xFF597F70, 0xFF618C79, 0xFF5A8572, 0xFF58826E, 0xFF5F8975, 0xFF6F8779, 0xFF5B7D6C, 0xFF355142, 0xFF555C54, 0xFF52554E, 0xFF314136, 0xFF16281C, 0xFF7A7F78, 0xFFC5BEB4, 0xFF808B7D, 0xFF294431, 0xFF496A59, 0xFF3D574A,
    0xFF40544B, 0xFF455A53, 0xFF18332A, 0xFF131917, 0xFF212622, 0xFF20211B, 0xFF2D2D23, 0xFF19190F, 0xFF202217, 0xFF272D23, 0xFF2F372C, 0xFF333A28, 0xFF303725, 0xFF343B29, 0xFF303928, 0xFF303928, 0xFF323D2C, 0xFF313C2C, 0xFF364131, 0xFF33392D,
    0xFF2C3226, 0xFF2D3327, 0xFF373D31, 0xFF32382C, 0xFF2E3428, 0xFF353B2F, 0xFF2C3226, 0xFF343A2E, 0xFF31372B, 0xFF2E3428, 0xFF2B3125, 0xFF2A3024, 0xFF2E3428, 0xFF383E32, 0xFF42483C, 0xFF2E3928, 0xFF1D241C, 0xFF212320, 0xFF181712, 0xFF2F2D20,
    0xFF323325, 0xFF191B16, 0xFF101318, 0xFF0E231A, 0xFF3F594E, 0xFF416154, 0xFF466B5A, 0xFF5B8270, 0xFF59806E, 0xFF547967, 0xFF5C7E6D, 0xFF597E6C, 0xFF5B806E, 0xFF5C816F, 0xFF5C816F, 0xFF5B806E, 0xFF5A7F6D, 0xFF5B806E, 0xFF5B806E, 0xFF598178,
    0xFF5A816F, 0xFF597F68, 0xFF588068, 0xFF557864, 0xFF445640, 0xFF887F60, 0xFFB3936C, 0xFFC08F6F, 0xFFB8986F, 0xFF6C6E46, 0xFF4F6D51, 0xFF3F5338, 0xFF82724E, 0xFFBA9368, 0xFFBA936C, 0xFFAF916F, 0xFF524E31, 0xFF40533D, 0xFF364832, 0xFF5D573D,
    0xFFAB8E6E, 0xFFB7936F, 0xFFBB9976, 0xFF898562, 0xFF4B6341, 0xFF2D4E2F, 0xFF51553C, 0xFFAB9274, 0xFFB3936D, 0xFFB2946E, 0xFFA58463, 0xFF35503D, 0xFF3A5A45, 0xFF426551, 0xFF4C735E, 0xFF3C6350, 0xFF294E3C, 0xFF365848, 0xFF3E5E4F, 0xFF486455,
    0xFF497262, 0xFF3B6652, 0xFF334A2D, 0xFF7D744B, 0xFFA08452, 0xFFA58C54, 0xFF968952, 0xFF82774A, 0xFF353F27, 0xFF41524A, 0xFF7B7E73, 0xFF978F82, 0xFFE0DDD6, 0xFFD2D3CD, 0xFF9E988C, 0xFF948F7C, 0xFF948F7C, 0xFF96917E, 0xFF9C9784, 0xFFA29D8A,
    0xFFA29D8A, 0xFF9E9986, 0xFF999481, 0xFF989284, 0xFF9D9789, 0xFF989586, 0xFF8D897D, 0xFF89877A, 0xFF9A988C, 0xFFBBB9AD, 0xFFD4D4C8, 0xFF7B9385, 0xFF617D6E, 0xFF628474, 0xFF638877, 0xFF4D6C5D, 0x00ACBDB5, 0x00F9FEFA, 0x00FFFDFC, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFF, 0x00F8FFFF, 0xFF9DBBB1, 0xFF416A5C, 0xFF648A7D, 0xFF618579, 0xFF406A5C, 0xFF2A5A4A, 0xFF345D4B, 0xFF2E5745, 0xFF345D4B, 0xFF2F5846, 0xFF27503E,
    0xFF2A5341, 0xFF2B5442, 0xFF2F5846, 0xFF537D71, 0xFF53796E, 0xFF45665D, 0xFF63827A, 0xFF88A69E, 0xFF76948C, 0xFF718F87, 0xFF86A59D, 0xFF77958D, 0xFF76948C, 0xFF6F8E86, 0xFF395A51, 0xFF61857B, 0xFF52786D, 0xFF50786D, 0xFF5E867B, 0xFF568273,
    0xFF537F70, 0xFF5C8879, 0xFF608C7D, 0xFF5A8677, 0xFF5A8677, 0xFF588475, 0xFF497566, 0xFF335E4D, 0xFF315C4B, 0xFF3A6554, 0xFF497463, 0xFF5F8A79, 0xFF638E7D, 0xFF55806F, 0xFF5D8877, 0xFF618876, 0xFF5A816F, 0xFF416856, 0xFF3C6351, 0xFF224937,
    0xFF426957, 0xFF486F5D, 0xFF5D8472, 0xFF598471, 0xFF5A8371, 0xFF5B8472, 0xFF5C8573, 0xFF5E8573, 0xFF5F8674, 0xFF608574, 0xFF608574, 0xFF608271, 0xFF5F8472, 0xFF608A76, 0xFF578470, 0xFF54816D, 0xFF5C8877, 0xFF608979, 0xFF618778, 0xFF6B8278,
    0xFF668276, 0xFF628476, 0xFF618876, 0xFF5B8673, 0xFF5F8A76, 0xFF5F8975, 0xFF5A8470, 0xFF647C6F, 0xFF678979, 0xFF395547, 0xFF4C534C, 0xFF545651, 0xFF39493F, 0xFF0E1F15, 0xFF60655F, 0xFF79766F, 0xFF505C50, 0xFF193425, 0xFF597868, 0xFF5A7064,
    0xFF66756E, 0xFF6A7972, 0xFF30453C, 0xFF161A19, 0xFF1E201B, 0xFF292921, 0xFF49473B, 0xFF262418, 0xFF15150B, 0xFF151811, 0xFF161B17, 0xFF141B14, 0xFF0E150E, 0xFF111A15, 0xFF131C17, 0xFF141F1B, 0xFF131E1A, 0xFF0C1713, 0xFF0E1A18, 0xFF141B13,
    0xFF151C14, 0xFF121911, 0xFF171E16, 0xFF181F17, 0xFF131A12, 0xFF151C14, 0xFF131A12, 0xFF11170D, 0xFF141A10, 0xFF161C12, 0xFF151B11, 0xFF141A10, 0xFF151B11, 0xFF151B11, 0xFF151B11, 0xFF111C0E, 0xFF181D17, 0xFF1B1B19, 0xFF24211A, 0xFF646351,
    0xFF525341, 0xFF12130D, 0xFF1A1B20, 0xFF0C1D15, 0xFF43584F, 0xFF3E5A4E, 0xFF395B4B, 0xFF557A69, 0xFF537A68, 0xFF547967, 0xFF5F8170, 0xFF5A7F6D, 0xFF5B806E, 0xFF5C816F, 0xFF5C816F, 0xFF5B806E, 0xFF5B806E, 0xFF5B806E, 0xFF5C816F, 0xFF598178,
    0xFF597E6D, 0xFF5D806C, 0xFF547A65, 0xFF5B7D6C, 0xFF4D5F47, 0xFF837956, 0xFFBF9E71, 0xFFC09376, 0xFFBBA27A, 0xFF6C7854, 0xFF557D65, 0xFF496650, 0xFF8A8160, 0xFFBC9B72, 0xFFB5936D, 0xFFB29B7C, 0xFF595D46, 0xFF476354, 0xFF395546, 0xFF5B5E49,
    0xFFB59D81, 0xFFBC9B7A, 0xFFB89A76, 0xFF909479, 0xFF436447, 0xFF386046, 0xFF48543E, 0xFFA38F76, 0xFFBAA07D, 0xFFB49C78, 0xFFA78C6E, 0xFF445F4C, 0xFF3E5E49, 0xFF466955, 0xFF476E59, 0xFF385F4C, 0xFF375C4A, 0xFF416353, 0xFF39594A, 0xFF587465,
    0xFF477060, 0xFF2F5A46, 0xFF2D4427, 0xFF7D744B, 0xFFA18553, 0xFFA68D55, 0xFF988B54, 0xFF83784B, 0xFF374129, 0xFF3F5048, 0xFF7A7D72, 0xFF968E81, 0xFFDEDBD4, 0xFFD4D5CF, 0xFFA09A8E, 0xFF9D9885, 0xFF9D9885, 0xFF9D9885, 0xFF9C9784, 0xFF9D9885,
    0xFF9D9885, 0xFF9F9A87, 0xFFA09B88, 0xFF969082, 0xFF9B9587, 0xFF959283, 0xFF8B877B, 0xFF868477, 0xFF939185, 0xFFB7B5A9, 0xFFD9D9CD, 0xFFB4C6BA, 0xFF738B7D, 0xFF618172, 0xFF618876, 0xFF4F6F60, 0x00AABEB5, 0x00FBFFFC, 0x00FFFDFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFF9FB, 0x00F6FFFD, 0xFF98B6AC, 0xFF3E6759, 0xFF63897C, 0xFF678B7F, 0xFF5A8476, 0xFF548474, 0xFF5F8876, 0xFF567F6D, 0xFF618A78, 0xFF5F8876, 0xFF5C8573,
    0xFF618A78, 0xFF5B8472, 0xFF618A78, 0xFF5C887B, 0xFF537F72, 0xFF4C786B, 0xFF527E71, 0xFF548073, 0xFF477366, 0xFF558174, 0xFF618D80, 0xFF588777, 0xFF497868, 0xFF588777, 0xFF4D7C6C, 0xFF467565, 0xFF4F7E6E, 0xFF598878, 0xFF619080, 0xFF5E8D7B,
    0xFF5A8977, 0xFF588775, 0xFF558472, 0xFF5D8C7A, 0xFF5C8B79, 0xFF5C8B79, 0xFF578674, 0xFF45705F, 0xFF335E4D, 0xFF2F5A49, 0xFF3B6655, 0xFF4F7A69, 0xFF5D8877, 0xFF5D8877, 0xFF5C8776, 0xFF5B8270, 0xFF587F6D, 0xFF3D6452, 0xFF39604E, 0xFF1E4533,
    0xFF426957, 0xFF49705E, 0xFF648B79, 0xFF598471, 0xFF5B8472, 0xFF5B8472, 0xFF5C8573, 0xFF5F8674, 0xFF5F8674, 0xFF608574, 0xFF5F8473, 0xFF5D836E, 0xFF608774, 0xFF5D8874, 0xFF58836F, 0xFF598471, 0xFF618A78, 0xFF608476, 0xFF567669, 0xFF5D7269,
    0xFF556F64, 0xFF537364, 0xFF5C8170, 0xFF57816D, 0xFF5B8571, 0xFF5B826F, 0xFF5A806B, 0xFF637D70, 0xFF577C6B, 0xFF355445, 0xFF4B554D, 0xFF3D423C, 0xFF1D2E24, 0xFF12261B, 0xFF5D645D, 0xFF74756F, 0xFF4A5A4F, 0xFF123122, 0xFF537364, 0xFF586E62,
    0xFF75827B, 0xFF727F78, 0xFF283931, 0xFF141A18, 0xFF1B201A, 0xFF2E3025, 0xFF505141, 0xFF292A1A, 0xFF181A0F, 0xFF161B17, 0xFF171D1D, 0xFF263435, 0xFF253334, 0xFF273538, 0xFF202F32, 0xFF1F2E33, 0xFF223438, 0xFF1C2E32, 0xFF1A2C30, 0xFF202F28,
    0xFF213029, 0xFF17261F, 0xFF15241D, 0xFF16251E, 0xFF112019, 0xFF14231C, 0xFF15241D, 0xFF17221C, 0xFF16211B, 0xFF141F19, 0xFF15201A, 0xFF19241E, 0xFF1D2822, 0xFF1D2822, 0xFF1A251F, 0xFF1D271E, 0xFF171D19, 0xFF171914, 0xFF18180C, 0xFF50523C,
    0xFF4A4C37, 0xFF12150C, 0xFF1B1E23, 0xFF15221B, 0xFF596A62, 0xFF52695F, 0xFF3D5D4E, 0xFF557A69, 0xFF557A69, 0xFF597E6C, 0xFF5A7F6D, 0xFF597E6C, 0xFF5A7F6D, 0xFF5C816F, 0xFF5C816F, 0xFF5B806E, 0xFF5B806E, 0xFF5B806E, 0xFF5C816F, 0xFF5A8073,
    0xFF5A7C6C, 0xFF5F8170, 0xFF557C6A, 0xFF5F8375, 0xFF4E644F, 0xFF7D7956, 0xFFC5AA7B, 0xFFB99477, 0xFFB6A47E, 0xFF697A5A, 0xFF558170, 0xFF476959, 0xFF888467, 0xFFBCA37B, 0xFFB59C74, 0xFFB2A185, 0xFF67705B, 0xFF3D6354, 0xFF284E41, 0xFF55604F,
    0xFFB4A48A, 0xFFB69977, 0xFFBCA07B, 0xFF888D76, 0xFF33553D, 0xFF4A7561, 0xFF5B6A57, 0xFFA2947A, 0xFFB6A281, 0xFFB3A17D, 0xFF9E896A, 0xFF4D6855, 0xFF41614C, 0xFF4F725E, 0xFF4D745F, 0xFF375E4B, 0xFF375C4A, 0xFF416353, 0xFF3F5F50, 0xFF567263,
    0xFF3A6353, 0xFF224D39, 0xFF294023, 0xFF7A7148, 0xFFA08452, 0xFFA88F57, 0xFF998C55, 0xFF7F7447, 0xFF343E26, 0xFF3B4C44, 0xFF787B70, 0xFF958D80, 0xFFDEDBD4, 0xFFD9DAD4, 0xFFA49E92, 0xFF9F9A87, 0xFF9F9A87, 0xFF9F9A87, 0xFF9F9A87, 0xFF9E9986,
    0xFF9F9A87, 0xFF9F9A87, 0xFFA09B88, 0xFF9A9486, 0xFF9A9486, 0xFF959283, 0xFF8C887C, 0xFF868477, 0xFF959387, 0xFFBEBCB0, 0xFFE6E6DA, 0xFFD1DDD3, 0xFF768A7E, 0xFF5E7E6F, 0xFF618876, 0xFF517363, 0x00ABC0B7, 0x00FCFFFD, 0x00FFFCFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFF, 0x00F8FFFF, 0xFF99B7AD, 0xFF416A5C, 0xFF648A7D, 0xFF65897D, 0xFF5E887A, 0xFF5F8F7F, 0xFF618A78, 0xFF5C8573, 0xFF5E8775, 0xFF5F8876, 0xFF608977,
    0xFF618A78, 0xFF5C8573, 0xFF5D8674, 0xFF63897A, 0xFF5A8373, 0xFF5F8A79, 0xFF638F7E, 0xFF639280, 0xFF5E8D7B, 0xFF6C9887, 0xFF64907F, 0xFF679883, 0xFF5C8B77, 0xFF5F8E7A, 0xFF669581, 0xFF598672, 0xFF5D8A76, 0xFF608B78, 0xFF5A8572, 0xFF5F8A79,
    0xFF5F8A79, 0xFF5E8978, 0xFF55806F, 0xFF5C8776, 0xFF588372, 0xFF5B8675, 0xFF5C8776, 0xFF5D8877, 0xFF426D5C, 0xFF396453, 0xFF3C6756, 0xFF386352, 0xFF4C7766, 0xFF638E7D, 0xFF588372, 0xFF5C8371, 0xFF587F6D, 0xFF3A614F, 0xFF385F4D, 0xFF1D4432,
    0xFF426957, 0xFF486F5D, 0xFF668D7B, 0xFF5B8673, 0xFF5D8674, 0xFF5E8775, 0xFF5E8775, 0xFF608775, 0xFF608775, 0xFF608574, 0xFF608574, 0xFF5C8670, 0xFF5B856F, 0xFF57826E, 0xFF598470, 0xFF5C8370, 0xFF517162, 0xFF3C584A, 0xFF2C4437, 0xFF213228,
    0xFF21372B, 0xFF233F31, 0xFF3D5E4D, 0xFF4F7462, 0xFF5C816F, 0xFF597C68, 0xFF5C7F6B, 0xFF567566, 0xFF5C8573, 0xFF3E6050, 0xFF606D64, 0xFF768078, 0xFF51675B, 0xFF526A5D, 0xFFA5B0A8, 0xFFB6BDB6, 0xFF7F9388, 0xFF2C4E3E, 0xFF446656, 0xFF344C3F,
    0xFF66736A, 0xFF78857C, 0xFF3C4C42, 0xFF0D1814, 0xFF131A13, 0xFF202618, 0xFF404330, 0xFF202312, 0xFF151B0F, 0xFF1E2422, 0xFF333D3F, 0xFF3A5350, 0xFF2E4744, 0xFF253E3B, 0xFF1B3333, 0xFF1D3736, 0xFF253F40, 0xFF203C3D, 0xFF203C3D, 0xFF2C423F,
    0xFF2A403D, 0xFF223835, 0xFF213734, 0xFF1D3330, 0xFF1C322F, 0xFF243A37, 0xFF213734, 0xFF1B2E2A, 0xFF142723, 0xFF10231F, 0xFF122521, 0xFF182B27, 0xFF20332F, 0xFF30433F, 0xFF3E514D, 0xFF28352C, 0xFF0B140F, 0xFF191E18, 0xFF212516, 0xFF44482F,
    0xFF42482E, 0xFF151B11, 0xFF0C1115, 0xFF1C2721, 0xFF5E6D66, 0xFF566B62, 0xFF426152, 0xFF5D7F6F, 0xFF587D6C, 0xFF5A7F6D, 0xFF577C6A, 0xFF577C6A, 0xFF597E6C, 0xFF5B806E, 0xFF5C816F, 0xFF5B806E, 0xFF5B806E, 0xFF5C816F, 0xFF5D8270, 0xFF608272,
    0xFF5D7E6D, 0xFF5C7E6D, 0xFF567F71, 0xFF547C73, 0xFF375241, 0xFF707354, 0xFFB5A478, 0xFFB3936D, 0xFFAF9D75, 0xFF5E6D4C, 0xFF496F60, 0xFF3A5648, 0xFF7E795B, 0xFFBCA37A, 0xFFB39C70, 0xFFB4A180, 0xFF6C765D, 0xFF375E4C, 0xFF224839, 0xFF4C5A43,
    0xFFAF9F7E, 0xFFB79770, 0xFFC4A376, 0xFF88846B, 0xFF536D54, 0xFF496C54, 0xFF3F4833, 0xFFA69579, 0xFFB39D76, 0xFFA9986D, 0xFFB39F7A, 0xFF435E4B, 0xFF43634E, 0xFF577A66, 0xFF507762, 0xFF3A614E, 0xFF385D4B, 0xFF3E6050, 0xFF446455, 0xFF4A6657,
    0xFF2F5848, 0xFF224D39, 0xFF2D4427, 0xFF786F46, 0xFF9D814F, 0xFFAA9159, 0xFF978A53, 0xFF7D7245, 0xFF343E26, 0xFF394A42, 0xFF777A6F, 0xFF958D80, 0xFFDEDBD4, 0xFFDADBD5, 0xFFA59F93, 0xFF999481, 0xFF999481, 0xFF9C9784, 0xFFA29D8A, 0xFFA7A28F,
    0xFFA6A18E, 0xFF9F9A87, 0xFF999481, 0xFF9C9688, 0xFF989284, 0xFF949182, 0xFF8D897D, 0xFF828073, 0xFF8E8C80, 0xFFBAB8AC, 0xFFE1E1D5, 0xFFD3DAD2, 0xFF728478, 0xFF5F7F70, 0xFF618A78, 0xFF4F7463, 0x00ABC0B7, 0x00FCFFFD, 0x00FFF9FA, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFF, 0x00F8FFFF, 0xFF98B6AC, 0xFF436C5E, 0xFF678D80, 0xFF64887C, 0xFF5C8678, 0xFF5D8D7D, 0xFF638C7A, 0xFF608977, 0xFF5C8573, 0xFF628B79, 0xFF5E8775,
    0xFF5F8876, 0xFF68917F, 0xFF628B79, 0xFF658475, 0xFF678778, 0xFF678C7B, 0xFF5E8775, 0xFF608977, 0xFF547D6B, 0xFF517A68, 0xFF486F5D, 0xFF416E59, 0xFF517C68, 0xFF497460, 0xFF57816D, 0xFF658C79, 0xFF5F8472, 0xFF608573, 0xFF618372, 0xFF5B8474,
    0xFF567F6F, 0xFF5E8777, 0xFF5C8575, 0xFF608979, 0xFF5E8777, 0xFF618A7A, 0xFF567F6F, 0xFF5F8A79, 0xFF5C8776, 0xFF426D5C, 0xFF35604F, 0xFF386352, 0xFF426D5C, 0xFF588372, 0xFF608B7A, 0xFF618876, 0xFF5B8270, 0xFF3A614F, 0xFF3A614F, 0xFF204735,
    0xFF446B59, 0xFF466D5B, 0xFF648B79, 0xFF5D8875, 0xFF5F8876, 0xFF608977, 0xFF608977, 0xFF628977, 0xFF618876, 0xFF618675, 0xFF608574, 0xFF5E8A73, 0xFF59856E, 0xFF55816A, 0xFF5A8470, 0xFF4E7361, 0xFF294537, 0xFF13291D, 0xFF17281E, 0xFF3A4A40,
    0xFF3B4F44, 0xFF1A3427, 0xFF113020, 0xFF2D4F3E, 0xFF597C68, 0xFF5E7F6C, 0xFF5E7D6B, 0xFF648477, 0xFF527D6C, 0xFF315547, 0xFF45544D, 0xFF505B55, 0xFF42594F, 0xFF476156, 0xFF4E5B54, 0xFF333E38, 0xFF334A40, 0xFF1F4335, 0xFF4D7163, 0xFF324C3F,
    0xFF5E6E64, 0xFF6F7C73, 0xFF38483E, 0xFF1C2826, 0xFF202A21, 0xFF2E3726, 0xFF4E533D, 0xFF2E331F, 0xFF151D10, 0xFF151E1B, 0xFF3B464A, 0xFF436358, 0xFF24433B, 0xFF123129, 0xFF103128, 0xFF1A3B34, 0xFF1D3E37, 0xFF143731, 0xFF173A34, 0xFF13302E,
    0xFF0F2C2A, 0xFF112E2C, 0xFF183533, 0xFF122F2D, 0xFF163331, 0xFF23403E, 0xFF1B3836, 0xFF1B3431, 0xFF17302D, 0xFF1A3330, 0xFF203936, 0xFF1D3633, 0xFF1C3532, 0xFF314A47, 0xFF4C6562, 0xFF37463F, 0xFF16211D, 0xFF192019, 0xFF232A18, 0xFF555B3F,
    0xFF4D563B, 0xFF1C2417, 0xFF20282B, 0xFF202924, 0xFF525F58, 0xFF41564D, 0xFF385446, 0xFF597B6B, 0xFF517665, 0xFF567B69, 0xFF587D6B, 0xFF567B69, 0xFF587D6B, 0xFF5A7F6D, 0xFF5B806E, 0xFF5B806E, 0xFF5B806E, 0xFF5C816F, 0xFF5D8270, 0xFF618271,
    0xFF5F7E6C, 0xFF5B7D6D, 0xFF5E867D, 0xFF527D76, 0xFF2D4C3D, 0xFF778063, 0xFFB9AD83, 0xFFB7966B, 0xFFB29D70, 0xFF5E6843, 0xFF486958, 0xFF3B5041, 0xFF847959, 0xFFC2A778, 0xFFB09A68, 0xFFB29C73, 0xFF6B7251, 0xFF456852, 0xFF3A604B, 0xFF566045,
    0xFFB3A078, 0xFFBE9A6A, 0xFFC19C68, 0xFF887A5F, 0xFF5A6A4D, 0xFF4F6C50, 0xFF46492E, 0xFFAC9573, 0xFFBAA274, 0xFFB7A371, 0xFFA48E5F, 0xFF46614E, 0xFF597964, 0xFF658874, 0xFF466D58, 0xFF365D4A, 0xFF416654, 0xFF355747, 0xFF254536, 0xFF405C4D,
    0xFF2C5545, 0xFF2A5541, 0xFF364D30, 0xFF786F46, 0xFF9B7F4D, 0xFFAA9159, 0xFF958851, 0xFF7F7447, 0xFF353F27, 0xFF394A42, 0xFF777A6F, 0xFF948C7F, 0xFFDCD9D2, 0xFFD8D9D3, 0xFFA39D91, 0xFF8D8875, 0xFF8D8875, 0xFF938E7B, 0xFFA09B88, 0xFFACA794,
    0xFFAAA592, 0xFF9B9683, 0xFF8D8875, 0xFF8E887A, 0xFF8D8779, 0xFF939081, 0xFF959185, 0xFF8B897C, 0xFF949286, 0xFFBCBAAE, 0xFFDFDFD3, 0xFFDBE0D9, 0xFF7A8A7F, 0xFF688778, 0xFF628B79, 0xFF49705E, 0x00A7BEB4, 0x00FCFFFD, 0x00FFFCFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFBFF, 0x00F9FFFF, 0xFF99B7AD, 0xFF446A5D, 0xFF648A7D, 0xFF678D80, 0xFF477364, 0xFF417463, 0xFF47705E, 0xFF517A68, 0xFF406957, 0xFF4E7966, 0xFF4D7865,
    0xFF477460, 0xFF406D59, 0xFF4A7763, 0xFF628171, 0xFF4E6658, 0xFF425448, 0xFF626E64, 0xFF4D5A50, 0xFF34463A, 0xFF264132, 0xFF2B4A3A, 0xFF2B3B31, 0xFF2E3F35, 0xFF273D31, 0xFF395549, 0xFF345648, 0xFF3C6557, 0xFF558172, 0xFF629181, 0xFF5B8476,
    0xFF508070, 0xFF528976, 0xFF558575, 0xFF698F82, 0xFF5D7D72, 0xFF5C8275, 0xFF5A8979, 0xFF5E8777, 0xFF618A7A, 0xFF608979, 0xFF3F6858, 0xFF355E4E, 0xFF3F6858, 0xFF416A5A, 0xFF5F8878, 0xFF618C79, 0xFF5C8573, 0xFF37604E, 0xFF345D4B, 0xFF234A38,
    0xFF3E6553, 0xFF4D7261, 0xFF678C7B, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF5F8674, 0xFF5E8573, 0xFF5E8573, 0xFF628473, 0xFF5C8370, 0xFF5D8471, 0xFF5C7869, 0xFF29392E, 0xFF232D24, 0xFF35473B, 0xFF2E4A3B, 0xFF4D6158,
    0xFF465A4F, 0xFF314238, 0xFF293A30, 0xFF1B3124, 0xFF2C4839, 0xFF5E816D, 0xFF5A816C, 0xFF5C8672, 0xFF547967, 0xFF3B5C4B, 0xFF3C5849, 0xFF365142, 0xFF203C2D, 0xFF123322, 0xFF1A3F2D, 0xFF31523F, 0xFF163724, 0xFF1C3E2D, 0xFF4A6A5B, 0xFF3A564A,
    0xFF5F746D, 0xFF75847F, 0xFF475150, 0xFF25403B, 0xFF20342B, 0xFF222A1F, 0xFF3C3A2D, 0xFF211B0F, 0xFF1C1912, 0xFF1C211D, 0xFF1F292A, 0xFF1B372B, 0xFF264C3D, 0xFF255442, 0xFF1C4736, 0xFF19372B, 0xFF1E382D, 0xFF2B4D3F, 0xFF3A6655, 0xFF3D5D4E,
    0xFF364E41, 0xFF16261C, 0xFF222824, 0xFF202622, 0xFF182722, 0xFF1D342C, 0xFF214136, 0xFF233634, 0xFF1E3230, 0xFF1C322F, 0xFF1F3630, 0xFF1F342F, 0xFF20302D, 0xFF25302C, 0xFF2A3330, 0xFF19231B, 0xFF191F1D, 0xFF1B1D1C, 0xFF1F2116, 0xFF494C37,
    0xFF3C412B, 0xFF182015, 0xFF21292C, 0xFF1F2C25, 0xFF4B5C54, 0xFF536A60, 0xFF3B5B4C, 0xFF597E6D, 0xFF537A68, 0xFF547B68, 0xFF547B68, 0xFF55806C, 0xFF5A8571, 0xFF58826E, 0xFF58826E, 0xFF5E8572, 0xFF5C8370, 0xFF5C8370, 0xFF608573, 0xFF638273,
    0xFF5B7D6D, 0xFF557F6B, 0xFF5E8A73, 0xFF618770, 0xFF4D6651, 0xFF6D7867, 0xFF959887, 0xFFA59876, 0xFF9A9778, 0xFF707D61, 0xFF61795F, 0xFF3C543A, 0xFF7D8A6C, 0xFFA19E7B, 0xFFB0A47C, 0xFFA19984, 0xFF6A6A52, 0xFF606F52, 0xFF4A6242, 0xFF4C6142,
    0xFF8C9278, 0xFFAFA28F, 0xFFB89E8F, 0xFF687F63, 0xFF5F7357, 0xFF58684D, 0xFF465037, 0xFF83876E, 0xFF9F9D86, 0xFFB0AA92, 0xFF827A63, 0xFF466A5C, 0xFF5A7F6E, 0xFF608574, 0xFF4A6F5E, 0xFF325745, 0xFF365B49, 0xFF3E644F, 0xFF2B513C, 0xFF355643,
    0xFF3A5E50, 0xFF426658, 0xFF364C35, 0xFF72724C, 0xFF9C8B57, 0xFFA68D55, 0xFFA08751, 0xFF7F733F, 0xFF333C21, 0xFF37473D, 0xFF76776F, 0xFF938D81, 0xFFD9D9D1, 0xFFD5D8CF, 0xFFA3A08F, 0xFF8C866E, 0xFF837D65, 0xFF8A846C, 0xFF98927A, 0xFFA8A28A,
    0xFFABA58D, 0xFF9B957D, 0xFF948E76, 0xFF9F8878, 0xFF978676, 0xFF9C9382, 0xFF969583, 0xFF888C7D, 0xFF939588, 0xFFB8B8AE, 0xFFE4E1D8, 0xFFD9DAD4, 0xFF7B887E, 0xFF6B8A7B, 0xFF618A78, 0xFF486F5D, 0x00A7BEB4, 0x00FBFFFD, 0x00FFFCFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFF7FB, 0x00F9FFFF, 0xFF98B6AC, 0xFF456B5E, 0xFF688E81, 0xFF668C7F, 0xFF325E4F, 0xFF174A39, 0xFF1A4331, 0xFF18412F, 0xFF1B4432, 0xFF1D4835, 0xFF143F2C,
    0xFF174430, 0xFF184531, 0xFF1D4A36, 0xFF5F806F, 0xFF466152, 0xFF485A4E, 0xFF757F76, 0xFFA1ABA2, 0xFFABB7AD, 0xFFAABCB0, 0xFFA6BCAF, 0xFFB1BBB3, 0xFFB3C0B7, 0xFF9CADA3, 0xFF50655C, 0xFF294539, 0xFF37584D, 0xFF62887B, 0xFF557E70, 0xFF64887C,
    0xFF5E8D7D, 0xFF5B907E, 0xFF578777, 0xFF608679, 0xFF638479, 0xFF638C7E, 0xFF5A8D7C, 0xFF5F8878, 0xFF537C6C, 0xFF658E7E, 0xFF5F8878, 0xFF426B5B, 0xFF3B6454, 0xFF3B6454, 0xFF3E6757, 0xFF588370, 0xFF5B8472, 0xFF3E6755, 0xFF396250, 0xFF234A38,
    0xFF406755, 0xFF4E7362, 0xFF668B7A, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF5F8674, 0xFF5E8573, 0xFF5E8573, 0xFF5F8170, 0xFF5F8673, 0xFF5B826F, 0xFF3B5748, 0xFF213126, 0xFF3D473E, 0xFF3B4D41, 0xFF2A4637, 0xFF43584F,
    0xFF3D5146, 0xFF34453B, 0xFF32463B, 0xFF203629, 0xFF1C3829, 0xFF436451, 0xFF577D68, 0xFF527C68, 0xFF648977, 0xFF587767, 0xFF556D5F, 0xFF5A7264, 0xFF5B7667, 0xFF537463, 0xFF2A4F3D, 0xFF456653, 0xFF355643, 0xFF446655, 0xFF587869, 0xFF3D594D,
    0xFF627770, 0xFF687772, 0xFF3F4948, 0xFF243D39, 0xFF23342C, 0xFF272F24, 0xFF413F32, 0xFF211D11, 0xFF181810, 0xFF161B17, 0xFF182022, 0xFF0C1B14, 0xFF22392F, 0xFF28483B, 0xFF1A362A, 0xFF0B1C14, 0xFF0E1B14, 0xFF263B32, 0xFF436155, 0xFF597B6B,
    0xFF3F594C, 0xFF102016, 0xFF151E19, 0xFF1C221E, 0xFF1B2622, 0xFF162923, 0xFF132A22, 0xFF122825, 0xFF172D2A, 0xFF1A332F, 0xFF1A312B, 0xFF142723, 0xFF121E1A, 0xFF161C1A, 0xFF1D1F1E, 0xFF18221A, 0xFF181E1C, 0xFF1B1D1C, 0xFF1F2116, 0xFF4A4D38,
    0xFF3D422C, 0xFF171F14, 0xFF1E2629, 0xFF27342D, 0xFF54655D, 0xFF546B61, 0xFF3A5A4B, 0xFF5A7F6E, 0xFF537A68, 0xFF577E6B, 0xFF577E6B, 0xFF547F6B, 0xFF55806C, 0xFF56806C, 0xFF59836F, 0xFF5C8370, 0xFF577E6B, 0xFF587D6B, 0xFF5B806E, 0xFF628476,
    0xFF5F8576, 0xFF5B8472, 0xFF5D8773, 0xFF628571, 0xFF46614E, 0xFF3B4C3A, 0xFF333E2E, 0xFF4E533C, 0xFF55634C, 0xFF506956, 0xFF638374, 0xFF456655, 0xFF617A65, 0xFF5C6A50, 0xFF5C6344, 0xFF72786A, 0xFF586655, 0xFF5E7762, 0xFF486851, 0xFF35523C,
    0xFF556A57, 0xFF727A6B, 0xFF7D7D71, 0xFF3E5B49, 0xFF506B58, 0xFF5A7360, 0xFF425746, 0xFF536452, 0xFF576453, 0xFF65705F, 0xFF4E5746, 0xFF3F6355, 0xFF5D8271, 0xFF5D8271, 0xFF486D5C, 0xFF436856, 0xFF385D4B, 0xFF2C523D, 0xFF3D634E, 0xFF3A5B48,
    0xFF496D5F, 0xFF406456, 0xFF384E37, 0xFF787852, 0xFF988753, 0xFFA58C54, 0xFF9D844E, 0xFF847844, 0xFF374025, 0xFF3B4B41, 0xFF787971, 0xFF938D81, 0xFFD9D9D1, 0xFFD6D9D0, 0xFFA5A291, 0xFF9D9683, 0xFF9C9582, 0xFFA49D8A, 0xFFA69F8C, 0xFFA8A18E,
    0xFFA8A18E, 0xFFA39C89, 0xFFA59E8B, 0xFFA79483, 0xFF9E9180, 0xFFA09987, 0xFF949381, 0xFF858779, 0xFF919386, 0xFFB7B4AB, 0xFFDFDAD4, 0xFFD3D8D1, 0xFF728277, 0xFF628172, 0xFF638C7A, 0xFF517866, 0x00AAC1B7, 0x00FAFFFC, 0x00FFFBFB, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFF9FD, 0x00F9FFFF, 0xFF97B5AB, 0xFF43695C, 0xFF688E81, 0xFF688E81, 0xFF2F5B4C, 0xFF0D402F, 0xFF3A6351, 0xFF3B6452, 0xFF305947, 0xFF083320, 0xFF1D4835,
    0xFF2E5B47, 0xFF174430, 0xFF1C4935, 0xFF5C7E6E, 0xFF3C584A, 0xFF4E5E54, 0xFF99A099, 0xFFEEEFEA, 0xFFEFF1EC, 0xFFECF1EB, 0xFFE6F0E8, 0xFFE9EAE5, 0xFFEFF1EC, 0xFFC9D0C9, 0xFF57645D, 0xFF51655C, 0xFF435D54, 0xFF547268, 0xFF5A7A6F, 0xFF566D65,
    0xFF46675C, 0xFF396355, 0xFF436C5E, 0xFF4A6B60, 0xFF4B6B60, 0xFF40695B, 0xFF3B6E5D, 0xFF5F8878, 0xFF588171, 0xFF598272, 0xFF5E8777, 0xFF578070, 0xFF426B5B, 0xFF365F4F, 0xFF3B6454, 0xFF446F5C, 0xFF4D7664, 0xFF3B6452, 0xFF38614F, 0xFF1F4634,
    0xFF3E6553, 0xFF4D7261, 0xFF638877, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF5F8674, 0xFF5F8674, 0xFF5E8573, 0xFF5F8170, 0xFF5F8673, 0xFF547B68, 0xFF1D392A, 0xFF26362B, 0xFF555F56, 0xFF36483C, 0xFF213D2E, 0xFF294036,
    0xFF22382C, 0xFF273B30, 0xFF374B40, 0xFF2C4235, 0xFF1C3728, 0xFF2E4F3C, 0xFF5E816D, 0xFF5D8773, 0xFF5B7D6C, 0xFF4F6A5B, 0xFF64786C, 0xFF62766A, 0xFF3D5547, 0xFF4C6B5B, 0xFF365B49, 0xFF446552, 0xFF375845, 0xFF527463, 0xFF4D6D5E, 0xFF254135,
    0xFF596E67, 0xFF5D6C67, 0xFF293332, 0xFF102321, 0xFF17261F, 0xFF272D23, 0xFF47483A, 0xFF29271A, 0xFF1C1C14, 0xFF141915, 0xFF10181A, 0xFF1E201D, 0xFF1E2722, 0xFF16251E, 0xFF121D17, 0xFF161B17, 0xFF1D1F1C, 0xFF232925, 0xFF2A3730, 0xFF507564,
    0xFF3A5648, 0xFF0E1F15, 0xFF131C17, 0xFF1D221E, 0xFF222826, 0xFF212C28, 0xFF1F2B27, 0xFF112A26, 0xFF203935, 0xFF2B443E, 0xFF273E38, 0xFF1B2C26, 0xFF121D19, 0xFF171918, 0xFF1C1B19, 0xFF162018, 0xFF171B1A, 0xFF191B1A, 0xFF212117, 0xFF4D4F3A,
    0xFF3E432D, 0xFF161C12, 0xFF192124, 0xFF1E2B24, 0xFF51625A, 0xFF4C6359, 0xFF355546, 0xFF5A7F6E, 0xFF537A68, 0xFF59806D, 0xFF59806D, 0xFF557F6B, 0xFF537D69, 0xFF56806C, 0xFF5A816E, 0xFF59806D, 0xFF587D6B, 0xFF597E6C, 0xFF5D8270, 0xFF557F71,
    0xFF578072, 0xFF5C8575, 0xFF64887A, 0xFF5C7E6E, 0xFF375646, 0xFF264132, 0xFF233B2D, 0xFF254434, 0xFF325247, 0xFF3B6059, 0xFF5E8582, 0xFF466D68, 0xFF43695E, 0xFF274738, 0xFF23432E, 0xFF465D55, 0xFF4C675E, 0xFF5E7F74, 0xFF4C7265, 0xFF264F41,
    0xFF22483B, 0xFF2A4B40, 0xFF2F4D43, 0xFF305148, 0xFF507168, 0xFF607F77, 0xFF47675C, 0xFF335147, 0xFF234135, 0xFF2A483C, 0xFF233F33, 0xFF3E6254, 0xFF5C8170, 0xFF5C8170, 0xFF537867, 0xFF395E4C, 0xFF325745, 0xFF486E59, 0xFF335944, 0xFF3A5B48,
    0xFF4D7163, 0xFF35594B, 0xFF314730, 0xFF75754F, 0xFF94834F, 0xFFA78E56, 0xFFA18852, 0xFF847844, 0xFF374025, 0xFF3C4C42, 0xFF797A72, 0xFF918B7F, 0xFFD7D7CF, 0xFFD8DBD2, 0xFFA7A493, 0xFFAAA391, 0xFFA9A290, 0xFFADA694, 0xFFABA492, 0xFFADA694,
    0xFFB4AD9B, 0xFFB2AB99, 0xFFB5AE9C, 0xFFB3A896, 0xFFAAA390, 0xFFA6A390, 0xFF909181, 0xFF818274, 0xFF949488, 0xFFC1BDB4, 0xFFE8E3DD, 0xFFDDE7DE, 0xFF7B8D81, 0xFF607F70, 0xFF648B79, 0xFF527766, 0x00A7BEB4, 0x00FAFFFC, 0x00FFFDFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFAFE, 0x00F9FFFF, 0xFF98B6AC, 0xFF43695C, 0xFF658B7E, 0xFF658B7E, 0xFF356152, 0xFF1E5140, 0xFF517A6A, 0xFF477060, 0xFF446D5D, 0xFF1A4534, 0xFF436E5D,
    0xFF507C6B, 0xFF214D3C, 0xFF214D3C, 0xFF537867, 0xFF405C4E, 0xFF4E5E54, 0xFFADAFAA, 0xFFEBE7E4, 0xFFD8D3D0, 0xFFCDC9C6, 0xFFBFBEBA, 0xFFDBD6D3, 0xFFE3DFDC, 0xFFDADBD6, 0xFF666C68, 0xFF414E47, 0xFF364741, 0xFF435851, 0xFF334A42, 0xFF545857,
    0xFF495853, 0xFF2A443B, 0xFF29433A, 0xFF293C36, 0xFF2F423C, 0xFF26443A, 0xFF325B4D, 0xFF5A8373, 0xFF5D8676, 0xFF537C6C, 0xFF5B8474, 0xFF668F7F, 0xFF557E6E, 0xFF436C5C, 0xFF3A6353, 0xFF36614E, 0xFF3A6351, 0xFF315A48, 0xFF37604E, 0xFF1F4634,
    0xFF3E6553, 0xFF4D7261, 0xFF658A79, 0xFF5F8674, 0xFF5F8674, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF5F8674, 0xFF5F8674, 0xFF638574, 0xFF5F8673, 0xFF486F5C, 0xFF173324, 0xFF3D4D42, 0xFF59635A, 0xFF26382C, 0xFF183425, 0xFF213B30,
    0xFF1B3326, 0xFF21352A, 0xFF32463B, 0xFF344A3D, 0xFF233E2F, 0xFF1C3B29, 0xFF537461, 0xFF5A8470, 0xFF587968, 0xFF384E41, 0xFF415146, 0xFF455248, 0xFF1D3125, 0xFF446051, 0xFF365B49, 0xFF50715E, 0xFF345542, 0xFF527463, 0xFF577768, 0xFF2E4A3E,
    0xFF5C716A, 0xFF65746F, 0xFF2C3635, 0xFF0A1818, 0xFF111C16, 0xFF1E241A, 0xFF3B3D2F, 0xFF1E1F11, 0xFF191A12, 0xFF191E1A, 0xFF1C2124, 0xFF20221F, 0xFF1E231F, 0xFF191F1B, 0xFF1A201C, 0xFF252724, 0xFF252724, 0xFF1D221E, 0xFF1A201C, 0xFF3A5C4C,
    0xFF2E4A3C, 0xFF0F2318, 0xFF16211B, 0xFF1B201C, 0xFF202221, 0xFF1E201F, 0xFF1C201F, 0xFF112A24, 0xFF233C36, 0xFF314A44, 0xFF2D423B, 0xFF1F2E29, 0xFF181E1C, 0xFF1A1917, 0xFF1E1818, 0xFF171E17, 0xFF151918, 0xFF191919, 0xFF222218, 0xFF4F513C,
    0xFF40432E, 0xFF141A10, 0xFF161B1F, 0xFF121F18, 0xFF4C5D55, 0xFF496056, 0xFF355546, 0xFF5C8170, 0xFF537A68, 0xFF587F6C, 0xFF567D6A, 0xFF56806C, 0xFF547E6A, 0xFF5B826F, 0xFF59806D, 0xFF587D6B, 0xFF5E8371, 0xFF608573, 0xFF628775, 0xFF5F8B7C,
    0xFF568072, 0xFF587E71, 0xFF5F8377, 0xFF5D7F71, 0xFF47695B, 0xFF406254, 0xFF426658, 0xFF477165, 0xFF487268, 0xFF436A65, 0xFF59807D, 0xFF49706D, 0xFF456D65, 0xFF315B4D, 0xFF396451, 0xFF35564B, 0xFF46675C, 0xFF57786D, 0xFF53776B, 0xFF41675A,
    0xFF355F51, 0xFF366555, 0xFF346454, 0xFF42615B, 0xFF587771, 0xFF5C7B73, 0xFF54756C, 0xFF42665A, 0xFF3E6256, 0xFF3F6556, 0xFF395F50, 0xFF466A5C, 0xFF618675, 0xFF5E8372, 0xFF416655, 0xFF375C4A, 0xFF3C614F, 0xFF3C624D, 0xFF395F4A, 0xFF2F503D,
    0xFF3B5F51, 0xFF294D3F, 0xFF2B412A, 0xFF6E6E48, 0xFF968551, 0xFFA88F57, 0xFFA28953, 0xFF7D713D, 0xFF30391E, 0xFF38483E, 0xFF777870, 0xFF8E887C, 0xFFD6D6CE, 0xFFD9DCD3, 0xFFA7A493, 0xFFA29A8D, 0xFFA1998C, 0xFFA69E91, 0xFFA59D90, 0xFFACA497,
    0xFFB8B0A3, 0xFFB5ADA0, 0xFFB3AB9E, 0xFFB2AD99, 0xFFAFAC99, 0xFFADAC9A, 0xFF989687, 0xFF88897B, 0xFFA29F96, 0xFFCBC8C1, 0xFFEDEAE3, 0xFFCCDCD1, 0xFF7C9285, 0xFF638374, 0xFF648978, 0xFF4F7161, 0x009FB4AB, 0x00FAFFFC, 0x00FFFEFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFF9FD, 0x00F7FFFD, 0xFF96B4AA, 0xFF466C5F, 0xFF668C7F, 0xFF5E8477, 0xFF305C4D, 0xFF205342, 0xFF406959, 0xFF1B4434, 0xFF416A5A, 0xFF3C6756, 0xFF4E7968,
    0xFF507C6B, 0xFF285443, 0xFF1B4736, 0xFF5E8372, 0xFF577365, 0xFF57675D, 0xFFBABBB6, 0xFFE3DBD9, 0xFFD8CECD, 0xFFD3CBC9, 0xFFC0BBB8, 0xFFCDC5C3, 0xFFDAD5D2, 0xFFD4D3CF, 0xFF8A8F8B, 0xFF747F79, 0xFF5C6B66, 0xFF4B5E58, 0xFF556A63, 0xFF92898C,
    0xFF838584, 0xFF4C5854, 0xFF4D5955, 0xFF7F8583, 0xFF9DA3A1, 0xFF657670, 0xFF39544B, 0xFF608979, 0xFF5C8575, 0xFF5D8676, 0xFF618A7A, 0xFF578070, 0xFF5B8474, 0xFF5F8878, 0xFF3B6454, 0xFF386350, 0xFF2F5846, 0xFF2B5442, 0xFF3B6452, 0xFF254C3A,
    0xFF426957, 0xFF4F7463, 0xFF6A8F7E, 0xFF5F8674, 0xFF5F8674, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF5F8674, 0xFF5F8674, 0xFF648675, 0xFF628976, 0xFF3E6552, 0xFF1A3627, 0xFF506055, 0xFF515B52, 0xFF1E3024, 0xFF153122, 0xFF213D31,
    0xFF203A2D, 0xFF21372B, 0xFF2A3E33, 0xFF34483C, 0xFF2D4537, 0xFF163321, 0xFF486755, 0xFF58826E, 0xFF5F806F, 0xFF405246, 0xFF5C665D, 0xFF7B827A, 0xFF4A5A4F, 0xFF4A6657, 0xFF325745, 0xFF4A6B58, 0xFF335441, 0xFF436554, 0xFF517162, 0xFF395549,
    0xFF526760, 0xFF576661, 0xFF273130, 0xFF10181A, 0xFF171D19, 0xFF22251C, 0xFF3A3C2E, 0xFF1A1C0E, 0xFF161910, 0xFF181D19, 0xFF1C2023, 0xFF121D17, 0xFF18211C, 0xFF1D231F, 0xFF202924, 0xFF25302A, 0xFF212C26, 0xFF1A231E, 0xFF1A201C, 0xFF233F31,
    0xFF21392C, 0xFF0F2016, 0xFF141F19, 0xFF171C18, 0xFF1B1B1B, 0xFF141213, 0xFF121011, 0xFF0F241F, 0xFF1E332E, 0xFF293E37, 0xFF263933, 0xFF1F2B27, 0xFF1A201C, 0xFF1B1A18, 0xFF1C1616, 0xFF161D16, 0xFF151918, 0xFF191919, 0xFF222218, 0xFF50523D,
    0xFF41442F, 0xFF13190F, 0xFF14191D, 0xFF15221B, 0xFF506159, 0xFF52695F, 0xFF3B5B4C, 0xFF5C8170, 0xFF537A68, 0xFF577E6B, 0xFF547B68, 0xFF567D6A, 0xFF59806D, 0xFF608774, 0xFF597E6C, 0xFF597E6C, 0xFF628775, 0xFF5E806F, 0xFF5A7C6B, 0xFF578271,
    0xFF5E8777, 0xFF658B7C, 0xFF64887A, 0xFF608478, 0xFF65897D, 0xFF618A7C, 0xFF5E887A, 0xFF679080, 0xFF678D80, 0xFF5E7F74, 0xFF68877F, 0xFF628277, 0xFF66887A, 0xFF5D8472, 0xFF67917B, 0xFF658675, 0xFF6B8A7A, 0xFF6B8778, 0xFF6A8677, 0xFF648574,
    0xFF608573, 0xFF618C78, 0xFF5C8C76, 0xFF698174, 0xFF6D877A, 0xFF658071, 0xFF678676, 0xFF668776, 0xFF6D907C, 0xFF6A907B, 0xFF638974, 0xFF5A7E70, 0xFF5E8372, 0xFF456A59, 0xFF416655, 0xFF385D4B, 0xFF2B503E, 0xFF3D634E, 0xFF395F4A, 0xFF294A37,
    0xFF294D3F, 0xFF2A4E40, 0xFF2F452E, 0xFF696943, 0xFF9B8A56, 0xFFA48B53, 0xFF9D844E, 0xFF7B6F3B, 0xFF2D361B, 0xFF37473D, 0xFF777870, 0xFF8E887C, 0xFFD6D6CE, 0xFFD9DCD3, 0xFFA6A392, 0xFF999184, 0xFF9E9689, 0xFFA8A093, 0xFFA9A194, 0xFFADA598,
    0xFFB3AB9E, 0xFFAEA699, 0xFFABA396, 0xFFAEAD99, 0xFFB0AF9B, 0xFFB8B5A4, 0xFFABA99C, 0xFFA09E92, 0xFFA7A79D, 0xFFAEB1A8, 0xFFB4B7B0, 0xFF92A89B, 0xFF698475, 0xFF658576, 0xFF678C7B, 0xFF506F60, 0x009CB0A7, 0x00F9FFFB, 0x00FFFFFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFBFF, 0x04F3FCF9, 0xFF8FADA3, 0xFF446A5D, 0xFF698F82, 0xFF61877A, 0xFF305C4D, 0xFF1F5241, 0xFF50796B, 0xFF396254, 0xFF487163, 0xFF376153, 0xFF456F61,
    0xFF537F70, 0xFF2E5A4B, 0xFF1E4A3B, 0xFF587A6C, 0xFF476357, 0xFF4F5C55, 0xFFAFB1AE, 0xFFE4DEDE, 0xFFDDD4D5, 0xFFDBD5D5, 0xFFDAD6D5, 0xFFD9D4D1, 0xFFE8E7E3, 0xFFC3C5C0, 0xFF8B918D, 0xFFA2AFA8, 0xFF6A7D77, 0xFF3C534B, 0xFF728C83, 0xFF9A9899,
    0xFF868F8C, 0xFF566761, 0xFF5F6E69, 0xFFA4AAA8, 0xFFBAC0BE, 0xFF7A8984, 0xFF455C54, 0xFF517A6A, 0xFF5E8777, 0xFF628B7B, 0xFF5C8575, 0xFF537C6C, 0xFF5D8676, 0xFF668F7F, 0xFF4C7565, 0xFF3C6754, 0xFF295240, 0xFF28513F, 0xFF3C6553, 0xFF244B39,
    0xFF406755, 0xFF4B705F, 0xFF658A79, 0xFF5E8573, 0xFF5F8674, 0xFF5F8674, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF608271, 0xFF668D7A, 0xFF3B624F, 0xFF163223, 0xFF536358, 0xFF49534A, 0xFF213327, 0xFF173324, 0xFF153327,
    0xFF1F3B2D, 0xFF1F372A, 0xFF25392E, 0xFF314539, 0xFF344A3D, 0xFF1C3726, 0xFF506D5B, 0xFF5B8571, 0xFF618070, 0xFF5B6B60, 0xFFB0B3AC, 0xFFD4D7D0, 0xFF7A867C, 0xFF445F50, 0xFF3F6452, 0xFF3C5D4A, 0xFF4A6B58, 0xFF456756, 0xFF345445, 0xFF375347,
    0xFF5F746D, 0xFF5B6A65, 0xFF283231, 0xFF131418, 0xFF1C1E1B, 0xFF282B22, 0xFF414536, 0xFF212516, 0xFF1B1E15, 0xFF191B18, 0xFF161A1D, 0xFF13241C, 0xFF15201A, 0xFF151A16, 0xFF1A201C, 0xFF1E2D26, 0xFF1A2B23, 0xFF132019, 0xFF131915, 0xFF14251B,
    0xFF1C2D23, 0xFF18251C, 0xFF19221D, 0xFF151A16, 0xFF1A1A1A, 0xFF191718, 0xFF231F20, 0xFF14201E, 0xFF1B2A25, 0xFF20312B, 0xFF20312B, 0xFF1E2B24, 0xFF1A231E, 0xFF1C1E19, 0xFF1C1B17, 0xFF181D17, 0xFF171918, 0xFF1A1819, 0xFF232017, 0xFF51503C,
    0xFF41432E, 0xFF14170E, 0xFF15181D, 0xFF14211A, 0xFF4B5C54, 0xFF586F65, 0xFF3B5B4C, 0xFF547968, 0xFF527967, 0xFF577E6B, 0xFF587F6C, 0xFF537A67, 0xFF59806D, 0xFF638876, 0xFF5A7F6D, 0xFF5D8270, 0xFF618372, 0xFF4C6E5D, 0xFF466857, 0xFF3F604F,
    0xFF476857, 0xFF577968, 0xFF5E8573, 0xFF587E6F, 0xFF5A8373, 0xFF598274, 0xFF5F887A, 0xFF5D7F6E, 0xFF5F8170, 0xFF5D7C6C, 0xFF62816F, 0xFF607F6D, 0xFF658472, 0xFF60836D, 0xFF648771, 0xFF658570, 0xFF678470, 0xFF63806C, 0xFF647F6C, 0xFF64816D,
    0xFF63836E, 0xFF62856F, 0xFF5E846D, 0xFF6A8272, 0xFF6A8574, 0xFF627D6A, 0xFF63806C, 0xFF64846D, 0xFF678770, 0xFF678971, 0xFF5E8067, 0xFF628678, 0xFF496E5D, 0xFF3F6453, 0xFF3C6150, 0xFF2A4F3D, 0xFF2E5341, 0xFF3E644F, 0xFF325843, 0xFF365744,
    0xFF2D5143, 0xFF2E5244, 0xFF324831, 0xFF63633D, 0xFF9B8A56, 0xFFA48B53, 0xFF9E854F, 0xFF807440, 0xFF2F381D, 0xFF38483E, 0xFF787971, 0xFF8D877B, 0xFFD6D6CE, 0xFFDADDD4, 0xFFA5A291, 0xFF928B79, 0xFF918A78, 0xFF9A9381, 0xFFA19A88, 0xFFABA492,
    0xFFB1AA98, 0xFFA49D8B, 0xFF9C9583, 0xFF9F9C89, 0xFFA39D8D, 0xFFB3AD9F, 0xFFB7B3A7, 0xFFB4B4A8, 0xFFAAB0A6, 0xFF8A968C, 0xFF6D7D72, 0xFF6C8778, 0xFF607F6F, 0xFF698B7B, 0xFF6D8F7F, 0xFF536F61, 0x009DAEA6, 0x00FBFFFD, 0x00FFFFFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFBFF, 0x00F5FEFB, 0xFF8EACA2, 0xFF42685B, 0xFF6A9083, 0xFF678D80, 0xFF335F50, 0xFF1D503F, 0xFF497264, 0xFF4F786A, 0xFF386153, 0xFF164032, 0xFF275143,
    0xFF3C6859, 0xFF1B4738, 0xFF1B4738, 0xFF567669, 0xFF506A5F, 0xFF79867F, 0xFFA7A9A6, 0xFFF1EDEC, 0xFFE2DEDD, 0xFFD6D6D4, 0xFFDEE0DD, 0xFFD7D8D3, 0xFFE5E7E2, 0xFFCED5CE, 0xFF65726B, 0xFF5F736A, 0xFF415B52, 0xFF456359, 0xFF4E6E63, 0xFF4A5D57,
    0xFF4A685E, 0xFF406458, 0xFF3B5B50, 0xFF51665F, 0xFF556660, 0xFF577168, 0xFF638479, 0xFF355E4E, 0xFF507969, 0xFF5B8474, 0xFF5E8777, 0xFF648D7D, 0xFF638C7C, 0xFF5A8373, 0xFF4F7868, 0xFF396451, 0xFF264F3D, 0xFF2A5341, 0xFF3C6553, 0xFF204735,
    0xFF3F6654, 0xFF496E5D, 0xFF618675, 0xFF5E8573, 0xFF5E8573, 0xFF5F8674, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF618372, 0xFF648B78, 0xFF3E6552, 0xFF132F20, 0xFF506055, 0xFF454F46, 0xFF1F3125, 0xFF173324, 0xFF133326,
    0xFF1F3B2D, 0xFF1C3427, 0xFF263A2F, 0xFF314539, 0xFF304639, 0xFF1A3222, 0xFF506B5A, 0xFF5F8975, 0xFF5E7A6B, 0xFF445046, 0xFF7A7974, 0xFF8E8D88, 0xFF586259, 0xFF3A5244, 0xFF5E8371, 0xFF385946, 0xFF436451, 0xFF426453, 0xFF274738, 0xFF3A564A,
    0xFF738881, 0xFF62716C, 0xFF273130, 0xFF19171C, 0xFF1F1E1C, 0xFF26271F, 0xFF3A3E2F, 0xFF1A2111, 0xFF181E14, 0xFF1D1F1C, 0xFF1D1E22, 0xFF15201A, 0xFF1D1F1C, 0xFF1E1A19, 0xFF1C1B19, 0xFF151E19, 0xFF0E1B14, 0xFF101612, 0xFF1D1918, 0xFF171E17,
    0xFF222C24, 0xFF212B23, 0xFF1C2520, 0xFF121814, 0xFF191B1A, 0xFF1B1B1B, 0xFF282627, 0xFF161A19, 0xFF181E1C, 0xFF1A2521, 0xFF1C2922, 0xFF19261F, 0xFF162119, 0xFF171E17, 0xFF181D17, 0xFF191E18, 0xFF181A19, 0xFF1B191A, 0xFF232017, 0xFF504F3B,
    0xFF40422D, 0xFF15180F, 0xFF171A1F, 0xFF111E17, 0xFF45564E, 0xFF61786E, 0xFF406051, 0xFF507564, 0xFF537A68, 0xFF577E6B, 0xFF5B826F, 0xFF577E6B, 0xFF5A7F6D, 0xFF5F8472, 0xFF597E6C, 0xFF638574, 0xFF5B7D6C, 0xFF3D5E4D, 0xFF3E5F4E, 0xFF546956,
    0xFF465F4A, 0xFF4B6C57, 0xFF5F8973, 0xFF608B77, 0xFF628B79, 0xFF587E6F, 0xFF608274, 0xFF638577, 0xFF638575, 0xFF628775, 0xFF638974, 0xFF5F8570, 0xFF628873, 0xFF648773, 0xFF638574, 0xFF5D8270, 0xFF5C816F, 0xFF618674, 0xFF628775, 0xFF628473,
    0xFF638473, 0xFF628171, 0xFF607F6F, 0xFF5F8473, 0xFF638877, 0xFF628776, 0xFF608573, 0xFF658A78, 0xFF648773, 0xFF698C78, 0xFF5F826E, 0xFF4F7365, 0xFF3E6352, 0xFF456A59, 0xFF1E4332, 0xFF335846, 0xFF486D5B, 0xFF193F2A, 0xFF426853, 0xFF3B5C49,
    0xFF395D4F, 0xFF2E5244, 0xFF354B34, 0xFF676741, 0xFF998854, 0xFFA68D55, 0xFFA28953, 0xFF827642, 0xFF2E371C, 0xFF35453B, 0xFF74756D, 0xFF8A8478, 0xFFD5D5CD, 0xFFDCDFD6, 0xFFA6A392, 0xFF8E8774, 0xFF857E6B, 0xFF8A8370, 0xFF97907D, 0xFFA8A18E,
    0xFFAFA895, 0xFFA09986, 0xFF97907D, 0xFF97907E, 0xFF968D7E, 0xFFA59B8F, 0xFFB1A99E, 0xFFB5B5AB, 0xFFAAB4A9, 0xFF82968A, 0xFF5E786B, 0xFF678877, 0xFF648574, 0xFF6A8C7C, 0xFF6C8C7D, 0xFF536D60, 0x009CADA5, 0x00FBFFFD, 0x00FFFFFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFF8FC, 0x00F6FFFC, 0xFF93B1A7, 0xFF446A5D, 0xFF698F82, 0xFF658B7E, 0xFF2C5849, 0xFF0F4231, 0xFF194234, 0xFF1E4739, 0xFF194234, 0xFF184234, 0xFF113B2D,
    0xFF184435, 0xFF0C3829, 0xFF1C4839, 0xFF547467, 0xFF768D83, 0xFFBCC9C2, 0xFF959A96, 0xFFE8E8E6, 0xFFE3E3E1, 0xFFCFD4D0, 0xFFC5CEC9, 0xFFD1D6D0, 0xFFD7E1D9, 0xFFCBD8CF, 0xFF5C6D65, 0xFF72897F, 0xFF506E64, 0xFF65867B, 0xFF5F8377, 0xFF5B8476,
    0xFF548474, 0xFF528976, 0xFF4D7D6D, 0xFF62867A, 0xFF5C7C71, 0xFF4E7266, 0xFF335F50, 0xFF3D6656, 0xFF386151, 0xFF507969, 0xFF628B7B, 0xFF5C8575, 0xFF5F8878, 0xFF5F8878, 0xFF497262, 0xFF37624F, 0xFF295240, 0xFF315A48, 0xFF406957, 0xFF224937,
    0xFF446B59, 0xFF4F7463, 0xFF658A79, 0xFF5E8573, 0xFF5E8573, 0xFF5F8674, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF658776, 0xFF5F8673, 0xFF416855, 0xFF143021, 0xFF4F5F54, 0xFF424C43, 0xFF182A1E, 0xFF153122, 0xFF143427,
    0xFF173627, 0xFF132B1E, 0xFF273D31, 0xFF35493D, 0xFF304639, 0xFF193121, 0xFF516C5B, 0xFF5D8773, 0xFF5C7869, 0xFF4D574E, 0xFF85827D, 0xFF898480, 0xFF535A52, 0xFF284032, 0xFF577C6A, 0xFF4B6C59, 0xFF244532, 0xFF3A5C4B, 0xFF446455, 0xFF567266,
    0xFF7E938C, 0xFF5D6C67, 0xFF283231, 0xFF191219, 0xFF1F1B1A, 0xFF25261E, 0xFF383F2F, 0xFF1A2111, 0xFF161C12, 0xFF181A17, 0xFF15161A, 0xFF191E1A, 0xFF1E1818, 0xFF201114, 0xFF1F1516, 0xFF1B1D1A, 0xFF151B17, 0xFF181715, 0xFF27181B, 0xFF181914,
    0xFF1E201B, 0xFF161B15, 0xFF151B17, 0xFF141A16, 0xFF1F2322, 0xFF1B1D1C, 0xFF202020, 0xFF1D1B1C, 0xFF1D1D1D, 0xFF1D231F, 0xFF1E2923, 0xFF1B2821, 0xFF152219, 0xFF152018, 0xFF1A241C, 0xFF1A1F19, 0xFF191B1A, 0xFF1B191A, 0xFF232017, 0xFF4E4D39,
    0xFF3F412C, 0xFF15180F, 0xFF181B20, 0xFF17241D, 0xFF495A52, 0xFF70877D, 0xFF4D6D5E, 0xFF557A69, 0xFF577E6C, 0xFF567D6A, 0xFF59806D, 0xFF5E8371, 0xFF597E6C, 0xFF597E6C, 0xFF577C6A, 0xFF658776, 0xFF587A69, 0xFF375847, 0xFF426352, 0xFF43503C,
    0xFF435944, 0xFF50725A, 0xFF59856C, 0xFF527F68, 0xFF5E8975, 0xFF5E8070, 0xFF648374, 0xFF61847D, 0xFF5D8378, 0xFF5C8776, 0xFF5A8773, 0xFF56836F, 0xFF588370, 0xFF618778, 0xFF608478, 0xFF5C8678, 0xFF558172, 0xFF5C8879, 0xFF5A8677, 0xFF578173,
    0xFF608478, 0xFF638378, 0xFF69847B, 0xFF56867A, 0xFF588679, 0xFF59877A, 0xFF537F72, 0xFF5E887A, 0xFF578072, 0xFF5B8474, 0xFF4C7565, 0xFF3B5F51, 0xFF496E5D, 0xFF183D2C, 0xFF375C4B, 0xFF466B59, 0xFF204533, 0xFF395F4A, 0xFF395F4A, 0xFF2C4D3A,
    0xFF3C6052, 0xFF2C5042, 0xFF3F553E, 0xFF767650, 0xFF9C8B57, 0xFFA78E56, 0xFF9F8650, 0xFF807440, 0xFF283116, 0xFF2E3E34, 0xFF6E6F67, 0xFF857F73, 0xFFD4D4CC, 0xFFDDE0D7, 0xFFA8A594, 0xFF9E9880, 0xFF98927A, 0xFFA09A82, 0xFFA9A38B, 0xFFB3AD95,
    0xFFB6B098, 0xFFAEA890, 0xFFAFA991, 0xFFB2A698, 0xFFA79B8D, 0xFFA89C90, 0xFFA69E93, 0xFFA3A399, 0xFF9AA89B, 0xFF7B9687, 0xFF608272, 0xFF658776, 0xFF618372, 0xFF638575, 0xFF688879, 0xFF526C5F, 0x009AABA3, 0x00FBFFFD, 0x00FBFBF9, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFF, 0x00F7FFFE, 0xFF8AA89E, 0xFF456E60, 0xFF668C7F, 0xFF608478, 0xFF497365, 0xFF2C5C4C, 0xFF325B4B, 0xFF345D4D, 0xFF325B4B, 0xFF325B4B, 0xFF335C4C,
    0xFF2E5747, 0xFF2B5444, 0xFF335C4C, 0xFF517D6C, 0xFF487362, 0xFF739789, 0xFF6D8B7F, 0xFF7A968A, 0xFF7B978B, 0xFF5F7D71, 0xFF749487, 0xFF58766A, 0xFF628074, 0xFF719186, 0xFF55766B, 0xFF42665C, 0xFF466C61, 0xFF628A7F, 0xFF5F877E, 0xFF638E7B,
    0xFF5D8875, 0xFF5C8774, 0xFF5E8777, 0xFF5F8576, 0xFF62887B, 0xFF5F8377, 0xFF517569, 0xFF325B4B, 0xFF446D5D, 0xFF365F4F, 0xFF557E6E, 0xFF638C7C, 0xFF628B7B, 0xFF618A7A, 0xFF4E7767, 0xFF3B6250, 0xFF2D5442, 0xFF325947, 0xFF3B6250, 0xFF264D3B,
    0xFF416856, 0xFF4C7361, 0xFF618876, 0xFF5C8573, 0xFF5C8573, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5C8573, 0xFF5C8573, 0xFF618674, 0xFF678877, 0xFF435F50, 0xFF192F22, 0xFF465A4E, 0xFF425448, 0xFF203428, 0xFF1B3124, 0xFF1E3229,
    0xFF1D372A, 0xFF143324, 0xFF243C2F, 0xFF3A473D, 0xFF323E34, 0xFF284030, 0xFF30533F, 0xFF3B5D4F, 0xFF3C564B, 0xFF4C5B54, 0xFFA0A9A4, 0xFFB9C2BD, 0xFF62716A, 0xFF314B40, 0xFF385A4C, 0xFF425A4C, 0xFF375243, 0xFF314D3F, 0xFF385748, 0xFF4F6B5D,
    0xFF60776D, 0xFF4C5D55, 0xFF202F28, 0xFF101721, 0xFF181E1A, 0xFF2F3322, 0xFF474838, 0xFF221F18, 0xFF1C1A1D, 0xFF191A1C, 0xFF181D19, 0xFF1B1D18, 0xFF161B15, 0xFF181F18, 0xFF18211C, 0xFF121B16, 0xFF141915, 0xFF1B1B1B, 0xFF1D1B1C, 0xFF1B1B1B,
    0xFF161817, 0xFF161C1A, 0xFF141D1A, 0xFF101916, 0xFF131C19, 0xFF1A201E, 0xFF191D1C, 0xFF211B1B, 0xFF1D1D1B, 0xFF242D28, 0xFF17261F, 0xFF16271F, 0xFF112019, 0xFF151E19, 0xFF1A1C19, 0xFF1B1A16, 0xFF171D1B, 0xFF15201C, 0xFF1D2317, 0xFF504F3B,
    0xFF454430, 0xFF141C11, 0xFF0C1E1E, 0xFF13221F, 0xFF4F625C, 0xFF5A746B, 0xFF426255, 0xFF5C8170, 0xFF557C69, 0xFF59806B, 0xFF527863, 0xFF5A7A6D, 0xFF5F8171, 0xFF608574, 0xFF5D8472, 0xFF567D6A, 0xFF406251, 0xFF375644, 0xFF567160, 0xFF486352,
    0xFF41604E, 0xFF517362, 0xFF5D8471, 0xFF5D8674, 0xFF5C8573, 0xFF5B8270, 0xFF628678, 0xFF5E8371, 0xFF5E8371, 0xFF5E8371, 0xFF5E8371, 0xFF5E8371, 0xFF5E8371, 0xFF5E8371, 0xFF5E8371, 0xFF638574, 0xFF638574, 0xFF638574, 0xFF638574, 0xFF628473,
    0xFF618372, 0xFF608271, 0xFF5F8170, 0xFF5B806F, 0xFF618675, 0xFF628776, 0xFF608574, 0xFF658A79, 0xFF608574, 0xFF527766, 0xFF355A49, 0xFF4A6F5E, 0xFF183D2C, 0xFF2E5341, 0xFF476C5A, 0xFF1F4530, 0xFF315742, 0xFF4E745D, 0xFF0E341D, 0xFF405E46,
    0xFF2E503F, 0xFF193F30, 0xFF2C452F, 0xFF6C704B, 0xFF9A8955, 0xFF9F854A, 0xFFAC8F55, 0xFF85713E, 0xFF36391E, 0xFF465349, 0xFF727469, 0xFFACA698, 0xFFDFDCD5, 0xFFDBD8CF, 0xFFB3A797, 0xFFA49C8F, 0xFFA9A194, 0xFFA49C8F, 0xFFACA497, 0xFFB1A99C,
    0xFFB1A99C, 0xFFB9B1A4, 0xFFB6AEA1, 0xFFB5AEA6, 0xFFA8AA9F, 0xFF979F92, 0xFF949A8C, 0xFF9C9C90, 0xFFA3A598, 0xFF7B8C79, 0xFF66846C, 0xFF638272, 0xFF678877, 0xFF5F8473, 0xFF648978, 0xFF4F6F60, 0x0098ADA4, 0x00F8FFFD, 0x00F8FAF7, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFF, 0x00F7FFFE, 0xFF89A79D, 0xFF456E60, 0xFF648A7D, 0xFF64887C, 0xFF5E887A, 0xFF568676, 0xFF658E7E, 0xFF628B7B, 0xFF5E8777, 0xFF5F8878, 0xFF638C7C,
    0xFF638C7C, 0xFF618A7A, 0xFF628B7B, 0xFF5F927F, 0xFF4E7D6B, 0xFF568170, 0xFF547A6B, 0xFF5E8475, 0xFF588171, 0xFF537E6D, 0xFF689483, 0xFF618577, 0xFF54786A, 0xFF54786A, 0xFF53796C, 0xFF557E70, 0xFF547C71, 0xFF5B8579, 0xFF5A8478, 0xFF578470,
    0xFF598672, 0xFF5F8A77, 0xFF5E8978, 0xFF5B8474, 0xFF5E8779, 0xFF638C7E, 0xFF63897C, 0xFF4D7666, 0xFF315A4A, 0xFF416A5A, 0xFF3B6454, 0xFF578070, 0xFF5F8878, 0xFF628B7B, 0xFF497262, 0xFF3B6250, 0xFF2C5341, 0xFF305745, 0xFF39604E, 0xFF254C3A,
    0xFF406755, 0xFF4B7260, 0xFF618876, 0xFF5C8573, 0xFF5C8573, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5C8573, 0xFF5C8573, 0xFF608573, 0xFF678877, 0xFF435F50, 0xFF182E21, 0xFF44584C, 0xFF3E5044, 0xFF1C3024, 0xFF182E21, 0xFF172B22,
    0xFF152F22, 0xFF143324, 0xFF243C2F, 0xFF3D4A40, 0xFF404C42, 0xFF3C5444, 0xFF4B6E5A, 0xFF436555, 0xFF456455, 0xFF3A5245, 0xFF596D62, 0xFF5F7368, 0xFF324A3D, 0xFF2F4E3F, 0xFF486A5A, 0xFF344F40, 0xFF3F5A4B, 0xFF425E50, 0xFF3D5C4D, 0xFF486456,
    0xFF4B6258, 0xFF42534B, 0xFF415049, 0xFF2B343D, 0xFF1E2722, 0xFF252C1A, 0xFF3D402F, 0xFF1B1C14, 0xFF18181A, 0xFF141819, 0xFF181E1A, 0xFF1E231D, 0xFF171E17, 0xFF19231B, 0xFF1F2A24, 0xFF1B241F, 0xFF181C1B, 0xFF1D1D1D, 0xFF221E1F, 0xFF1D1B1C,
    0xFF1B1B1B, 0xFF1D1F1E, 0xFF1A1E1D, 0xFF141A18, 0xFF171D1B, 0xFF1D2120, 0xFF1B1F1E, 0xFF1C1817, 0xFF171916, 0xFF202B25, 0xFF1A2922, 0xFF192A22, 0xFF14211A, 0xFF181E1A, 0xFF232321, 0xFF181713, 0xFF151B19, 0xFF151E1B, 0xFF1A2014, 0xFF494834,
    0xFF403F2B, 0xFF1C2419, 0xFF213333, 0xFF263532, 0xFF576A64, 0xFF536D64, 0xFF3A5A4D, 0xFF577C6B, 0xFF517865, 0xFF587E69, 0xFF567C67, 0xFF58786B, 0xFF5D7F6F, 0xFF547968, 0xFF5A816F, 0xFF4B725F, 0xFF395B4A, 0xFF436250, 0xFF3A5544, 0xFF466150,
    0xFF506F5D, 0xFF658776, 0xFF648B78, 0xFF5B8472, 0xFF5D8674, 0xFF5C8371, 0xFF5A7E70, 0xFF608573, 0xFF608573, 0xFF608573, 0xFF608573, 0xFF608573, 0xFF608573, 0xFF608573, 0xFF608573, 0xFF628473, 0xFF638574, 0xFF638574, 0xFF638574, 0xFF628473,
    0xFF628473, 0xFF618372, 0xFF608271, 0xFF5F8473, 0xFF618675, 0xFF5E8372, 0xFF5F8473, 0xFF5F8473, 0xFF587D6C, 0xFF305544, 0xFF496E5D, 0xFF173C2B, 0xFF365B4A, 0xFF4B705E, 0xFF1B402E, 0xFF365C47, 0xFF4C725D, 0xFF133922, 0xFF3A6049, 0xFF436149,
    0xFF183A29, 0xFF1E4435, 0xFF3A533D, 0xFF575B36, 0xFF968551, 0xFFB3995E, 0xFF9C7F45, 0xFF8A7643, 0xFF45492E, 0xFF5F6C62, 0xFF8D9085, 0xFFBEB8AA, 0xFFEAE7E0, 0xFFDEDBD2, 0xFFAFA393, 0xFFA19A8A, 0xFFA7A090, 0xFFAAA393, 0xFFB0A999, 0xFFB2AB9B,
    0xFFB0A999, 0xFFB3AC9C, 0xFFB1AA9A, 0xFFADA399, 0xFFA6A497, 0xFF9B9F91, 0xFF9CA092, 0xFFA3A397, 0xFFA5A89D, 0xFF798B7B, 0xFF5D7E69, 0xFF698576, 0xFF6B8C7B, 0xFF618675, 0xFF648978, 0xFF4E6E5F, 0x0093A89F, 0x00F8FFFD, 0x00FEFFFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFAFC, 0x04F4FFFB, 0xFF8CAAA0, 0xFF497264, 0xFF63897C, 0xFF618579, 0xFF5C8678, 0xFF619181, 0xFF5B8474, 0xFF5E8777, 0xFF628B7B, 0xFF608979, 0xFF5C8575,
    0xFF5C8575, 0xFF5F8878, 0xFF618A7A, 0xFF578A77, 0xFF5E8F7C, 0xFF5A8977, 0xFF5C8877, 0xFF659180, 0xFF608F7D, 0xFF639683, 0xFF5B927D, 0xFF669180, 0xFF669180, 0xFF648F7E, 0xFF628C7E, 0xFF5E887A, 0xFF5E887A, 0xFF5E887C, 0xFF5D877B, 0xFF598672,
    0xFF5B8874, 0xFF5E8B77, 0xFF5B8776, 0xFF568271, 0xFF598375, 0xFF5D8779, 0xFF5D8779, 0xFF5A8373, 0xFF4F7868, 0xFF2E5747, 0xFF3E6757, 0xFF396252, 0xFF567F6F, 0xFF618A7A, 0xFF4B7464, 0xFF3B6250, 0xFF2C5341, 0xFF2F5644, 0xFF375E4C, 0xFF234A38,
    0xFF3F6654, 0xFF4B7260, 0xFF618876, 0xFF5C8573, 0xFF5C8573, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5C8573, 0xFF5C8573, 0xFF5F8472, 0xFF668776, 0xFF415D4E, 0xFF162C1F, 0xFF43574B, 0xFF3B4D41, 0xFF192D21, 0xFF172D20, 0xFF1C3027,
    0xFF193326, 0xFF1C3B2C, 0xFF273F32, 0xFF3A473D, 0xFF333F35, 0xFF233B2B, 0xFF3A5D49, 0xFF426454, 0xFF436555, 0xFF274939, 0xFF284839, 0xFF2B4B3C, 0xFF204232, 0xFF345646, 0xFF466858, 0xFF244031, 0xFF375344, 0xFF3E5D4E, 0xFF375647, 0xFF536F61,
    0xFF72897F, 0xFF5B6C64, 0xFF3A4740, 0xFF35424A, 0xFF202B25, 0xFF212A17, 0xFF3E4231, 0xFF1F2219, 0xFF191D1E, 0xFF1B2121, 0xFF242D28, 0xFF28322A, 0xFF18231B, 0xFF15221B, 0xFF1B2821, 0xFF18211E, 0xFF141817, 0xFF191718, 0xFF201A1E, 0xFF191718,
    0xFF1B191A, 0xFF1D1B1C, 0xFF191919, 0xFF161616, 0xFF181A19, 0xFF1D1F1E, 0xFF1B1D1C, 0xFF1C1C1A, 0xFF171C18, 0xFF1E2B24, 0xFF1A2B23, 0xFF172820, 0xFF111C16, 0xFF151A16, 0xFF252422, 0xFF1F1E1A, 0xFF171B1A, 0xFF131C19, 0xFF1E2418, 0xFF55523F,
    0xFF4D4A37, 0xFF252D22, 0xFF283838, 0xFF293835, 0xFF546761, 0xFF4A645B, 0xFF355548, 0xFF567B6A, 0xFF517664, 0xFF537964, 0xFF567C67, 0xFF567669, 0xFF5F8171, 0xFF5E8372, 0xFF385F4D, 0xFF3A614E, 0xFF345645, 0xFF143321, 0xFF45604F, 0xFF4D6857,
    0xFF547361, 0xFF648675, 0xFF5E8572, 0xFF557E6C, 0xFF5B8472, 0xFF5F8674, 0xFF618577, 0xFF618674, 0xFF618674, 0xFF618674, 0xFF618674, 0xFF618674, 0xFF618674, 0xFF618674, 0xFF618674, 0xFF608573, 0xFF608573, 0xFF608573, 0xFF618674, 0xFF618674,
    0xFF608573, 0xFF608573, 0xFF5F8472, 0xFF648978, 0xFF5A7F6E, 0xFF5A7F6E, 0xFF658A79, 0xFF527766, 0xFF2B503F, 0xFF4D7261, 0xFF204534, 0xFF345948, 0xFF517665, 0xFF183D2B, 0xFF375C4A, 0xFF496F5A, 0xFF193F2A, 0xFF365C45, 0xFF3A6049, 0xFF1B3921,
    0xFF3A5C4B, 0xFF315748, 0xFF233C26, 0xFF595D38, 0xFF9D8C58, 0xFFA88E53, 0xFFA5884E, 0xFF8D7C48, 0xFF4C5035, 0xFF5E6E63, 0xFF8B8E83, 0xFFB1AB9D, 0xFFE4E1DA, 0xFFDEDBD2, 0xFFAEA594, 0xFF99927F, 0xFF9A9380, 0xFFA29B88, 0xFFA9A28F, 0xFFAFA895,
    0xFFB0A996, 0xFFA7A08D, 0xFFA39C89, 0xFFAE9E8F, 0xFFA29B89, 0xFF90917F, 0xFF939587, 0xFF9B9B8F, 0xFF9FA59B, 0xFF75897D, 0xFF587A6A, 0xFF648071, 0xFF668776, 0xFF608272, 0xFF638877, 0xFF527162, 0x0093A89F, 0x00F8FFFC, 0x00FEFFFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFF, 0x00F7FFFE, 0xFF8BA99F, 0xFF477062, 0xFF62887B, 0xFF668A7E, 0xFF5C8678, 0xFF619181, 0xFF608979, 0xFF608979, 0xFF638C7C, 0xFF648D7D, 0xFF638C7C,
    0xFF658E7E, 0xFF648D7D, 0xFF5D8676, 0xFF5B8673, 0xFF658E7C, 0xFF5F8473, 0xFF618675, 0xFF608775, 0xFF567F6D, 0xFF578672, 0xFF4C7D68, 0xFF507B68, 0xFF56816E, 0xFF598473, 0xFF5C8776, 0xFF578173, 0xFF608A7C, 0xFF5F897B, 0xFF598377, 0xFF5C8774,
    0xFF588370, 0xFF56836F, 0xFF578372, 0xFF5A8675, 0xFF5D897A, 0xFF598878, 0xFF558474, 0xFF5E8777, 0xFF648D7D, 0xFF436C5C, 0xFF325B4B, 0xFF3F6858, 0xFF376050, 0xFF5D8676, 0xFF4F7868, 0xFF3D6452, 0xFF2D5442, 0xFF305745, 0xFF375E4C, 0xFF234A38,
    0xFF3F6654, 0xFF4C7361, 0xFF638A78, 0xFF5C8573, 0xFF5C8573, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5C8573, 0xFF5C8573, 0xFF5D8270, 0xFF658675, 0xFF405C4D, 0xFF152B1E, 0xFF44584C, 0xFF3B4D41, 0xFF182C20, 0xFF192F22, 0xFF12261D,
    0xFF112B1E, 0xFF173627, 0xFF243C2F, 0xFF3F4C42, 0xFF303C32, 0xFF172F1F, 0xFF40634F, 0xFF618675, 0xFF5D8472, 0xFF3D6654, 0xFF37624F, 0xFF3A6552, 0xFF345D4B, 0xFF3D6452, 0xFF3D6251, 0xFF426151, 0xFF325342, 0xFF3C5C4D, 0xFF385849, 0xFF3A5648,
    0xFF52675E, 0xFF4D5E56, 0xFF3A4740, 0xFF2D3A42, 0xFF202D26, 0xFF293521, 0xFF444B39, 0xFF1E241A, 0xFF141A1A, 0xFF141D1C, 0xFF1F2A24, 0xFF25302A, 0xFF17241D, 0xFF12211A, 0xFF172621, 0xFF17221E, 0xFF161C1A, 0xFF19191B, 0xFF1B161A, 0xFF171717,
    0xFF181617, 0xFF1A1617, 0xFF191516, 0xFF191516, 0xFF1B191A, 0xFF1A1C1B, 0xFF161A19, 0xFF181E1A, 0xFF16231C, 0xFF1D2E26, 0xFF182D24, 0xFF172B22, 0xFF16231C, 0xFF191B18, 0xFF272322, 0xFF24201D, 0xFF181C1B, 0xFF141D1A, 0xFF23261B, 0xFF5A5744,
    0xFF4F4C39, 0xFF22281E, 0xFF203030, 0xFF2F3B39, 0xFF60716B, 0xFF546B63, 0xFF3B5B4E, 0xFF5C7E6E, 0xFF567B69, 0xFF567C67, 0xFF5B7E6A, 0xFF658578, 0xFF567868, 0xFF446958, 0xFF39604E, 0xFF3C6350, 0xFF335544, 0xFF2A4937, 0xFF425D4C, 0xFF466150,
    0xFF3F5E4C, 0xFF517362, 0xFF5F8673, 0xFF608977, 0xFF5E8775, 0xFF5B8270, 0xFF618577, 0xFF5F8472, 0xFF5F8472, 0xFF5F8472, 0xFF5F8472, 0xFF5F8472, 0xFF5F8472, 0xFF5F8472, 0xFF5F8472, 0xFF5F8472, 0xFF5F8472, 0xFF608573, 0xFF608573, 0xFF618674,
    0xFF608573, 0xFF608573, 0xFF608573, 0xFF5F8473, 0xFF5F8473, 0xFF628776, 0xFF507564, 0xFF3A5F4E, 0xFF496E5D, 0xFF193E2D, 0xFF335847, 0xFF466B5A, 0xFF1B402F, 0xFF375C4A, 0xFF416654, 0xFF1E442F, 0xFF305641, 0xFF40664F, 0xFF193F28, 0xFF426048,
    0xFF315342, 0xFF204637, 0xFF2B442E, 0xFF60643F, 0xFF978652, 0xFFA48A4F, 0xFFA78A50, 0xFF8C7B47, 0xFF44482D, 0xFF48584D, 0xFF72756A, 0xFF928F80, 0xFFD3D3CB, 0xFFDADAD0, 0xFFAFA695, 0xFF908A74, 0xFF89836D, 0xFF928C76, 0xFF9A947E, 0xFFA9A38D,
    0xFFAFA993, 0xFF9D9781, 0xFF948E78, 0xFF9E8C78, 0xFF9D927E, 0xFF93927E, 0xFF989989, 0xFF9C9A8E, 0xFF9B9E97, 0xFF768A7F, 0xFF5A7C6E, 0xFF648071, 0xFF678676, 0xFF608272, 0xFF638575, 0xFF537263, 0x0097ABA2, 0x00F5FEF9, 0x00FDFDFB, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFF, 0x00F8FFFF, 0xFF8AA89E, 0xFF456E60, 0xFF63897C, 0xFF688C80, 0xFF467062, 0xFF3B6B5B, 0xFF3E6757, 0xFF416A5A, 0xFF456E5E, 0xFF446D5D, 0xFF416A5A,
    0xFF406959, 0xFF436C5C, 0xFF456E5E, 0xFF658173, 0xFF486255, 0xFF3B5145, 0xFF4D6156, 0xFF475B50, 0xFF2A4235, 0xFF1E3A2C, 0xFF254435, 0xFF143626, 0xFF173929, 0xFF234837, 0xFF2F5345, 0xFF2B5142, 0xFF3A6355, 0xFF527C6E, 0xFF5F897B, 0xFF5F8674,
    0xFF5F8674, 0xFF5D8674, 0xFF5D8877, 0xFF5F8A79, 0xFF5D897A, 0xFF578676, 0xFF568575, 0xFF5D8676, 0xFF5E8777, 0xFF638C7C, 0xFF3E6757, 0xFF3F6858, 0xFF396252, 0xFF436C5C, 0xFF456E5E, 0xFF3E6553, 0xFF2E5543, 0xFF315846, 0xFF39604E, 0xFF254C3A,
    0xFF416856, 0xFF4E7563, 0xFF648B79, 0xFF5C8573, 0xFF5C8573, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5C8573, 0xFF5C8573, 0xFF5D8270, 0xFF658675, 0xFF3F5B4C, 0xFF162C1F, 0xFF475B4F, 0xFF3D4F43, 0xFF192D21, 0xFF1D3326, 0xFF1E3229,
    0xFF1B3528, 0xFF183728, 0xFF263E31, 0xFF465349, 0xFF303C32, 0xFF172F1F, 0xFF4F725E, 0xFF5F8472, 0xFF658C79, 0xFF57816D, 0xFF598470, 0xFF5E8975, 0xFF4F7965, 0xFF426956, 0xFF345947, 0xFF325443, 0xFF3D5F4E, 0xFF5A7C6C, 0xFF517363, 0xFF3C5B4C,
    0xFF4A5F56, 0xFF46554E, 0xFF29342E, 0xFF142129, 0xFF15221B, 0xFF28311E, 0xFF404735, 0xFF1B1E15, 0xFF121617, 0xFF111717, 0xFF141F19, 0xFF151E19, 0xFF121D17, 0xFF17231F, 0xFF1D2C27, 0xFF202F2A, 0xFF242E2D, 0xFF212727, 0xFF18191B, 0xFF171918,
    0xFF181818, 0xFF1B1718, 0xFF1E181A, 0xFF201A1C, 0xFF1C1A1B, 0xFF141817, 0xFF0F1815, 0xFF0D2118, 0xFF152A21, 0xFF193529, 0xFF173327, 0xFF1C3329, 0xFF1F2E27, 0xFF151A16, 0xFF161513, 0xFF1C1815, 0xFF181A19, 0xFF161C1A, 0xFF1E2116, 0xFF4F4A37,
    0xFF423D2A, 0xFF161C12, 0xFF1A2829, 0xFF25312F, 0xFF5C6D67, 0xFF50675F, 0xFF304E42, 0xFF446656, 0xFF426755, 0xFF466955, 0xFF496C58, 0xFF4C6C5F, 0xFF3F6151, 0xFF325746, 0xFF345B49, 0xFF466D5A, 0xFF466857, 0xFF395846, 0xFF4A6554, 0xFF415C4B,
    0xFF345341, 0xFF466857, 0xFF5C8370, 0xFF628B79, 0xFF5D8674, 0xFF59806E, 0xFF618577, 0xFF5E8371, 0xFF5E8371, 0xFF5E8371, 0xFF5E8371, 0xFF5E8371, 0xFF5E8371, 0xFF5E8371, 0xFF5E8371, 0xFF5D8471, 0xFF5E8572, 0xFF5E8572, 0xFF5F8673, 0xFF5F8673,
    0xFF5F8673, 0xFF5E8572, 0xFF5E8572, 0xFF5E8372, 0xFF658A79, 0xFF567B6A, 0xFF365B4A, 0xFF4A6F5E, 0xFF274C3B, 0xFF294E3D, 0xFF466B5A, 0xFF1C4130, 0xFF335847, 0xFF496E5C, 0xFF1E4331, 0xFF335944, 0xFF476D58, 0xFF163C25, 0xFF3A6049, 0xFF405E46,
    0xFF1A3C2B, 0xFF1F4536, 0xFF425B45, 0xFF686C47, 0xFF9A8955, 0xFFAE9459, 0xFFA3864C, 0xFF8A7945, 0xFF3C4226, 0xFF3A4C40, 0xFF6B7165, 0xFF8A8778, 0xFFD4D4CC, 0xFFDBDBD1, 0xFFABA492, 0xFF908A74, 0xFF88826C, 0xFF8F8973, 0xFF96907A, 0xFFA59F89,
    0xFFACA690, 0xFF9B957F, 0xFF938D77, 0xFF9A8874, 0xFF9C917D, 0xFF92917C, 0xFF969485, 0xFF908C81, 0xFF909189, 0xFF79897F, 0xFF638175, 0xFF688374, 0xFF6A8979, 0xFF678778, 0xFF638575, 0xFF516D5F, 0x0099ADA4, 0x00FAFFFC, 0x00FFFFFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFF, 0x00F8FFFF, 0xFF8AA89E, 0xFF477062, 0xFF658B7E, 0xFF64887C, 0xFF2C5648, 0xFF134333, 0xFF1C4535, 0xFF1B4434, 0xFF174030, 0xFF174030, 0xFF1C4535,
    0xFF194232, 0xFF174030, 0xFF1D4636, 0xFF687E72, 0xFF44554B, 0xFF46534A, 0xFF828982, 0xFFA0A59F, 0xFF99A099, 0xFF8E9890, 0xFF98A39B, 0xFF95A59A, 0xFF95A79B, 0xFF83978C, 0xFF4B6558, 0xFF2E4E41, 0xFF375B4D, 0xFF588171, 0xFF618B7D, 0xFF628273,
    0xFF678778, 0xFF688A7A, 0xFF64887A, 0xFF5E8475, 0xFF578072, 0xFF578173, 0xFF5E8A7B, 0xFF578070, 0xFF5D8676, 0xFF5D8676, 0xFF5E8777, 0xFF436C5C, 0xFF406959, 0xFF3D6656, 0xFF285141, 0xFF3E6553, 0xFF2F5644, 0xFF325947, 0xFF3A614F, 0xFF264D3B,
    0xFF426957, 0xFF4E7563, 0xFF648B79, 0xFF5C8573, 0xFF5C8573, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5C8573, 0xFF5C8573, 0xFF5E8371, 0xFF658675, 0xFF3D594A, 0xFF162C1F, 0xFF4B5F53, 0xFF405246, 0xFF1A2E22, 0xFF1F3528, 0xFF1F332A,
    0xFF1C3629, 0xFF173627, 0xFF273F32, 0xFF445147, 0xFF2E3A30, 0xFF172F1F, 0xFF476A56, 0xFF5F8170, 0xFF577968, 0xFF375948, 0xFF305140, 0xFF3B5C4B, 0xFF385A49, 0xFF365847, 0xFF365847, 0xFF3C614F, 0xFF577E6B, 0xFF5B806F, 0xFF416353, 0xFF456455,
    0xFF6B8077, 0xFF5F6E67, 0xFF27302B, 0xFF0B141D, 0xFF0E1712, 0xFF222917, 0xFF3C3F2E, 0xFF1B1C14, 0xFF1C1C1E, 0xFF181C1D, 0xFF161C18, 0xFF141613, 0xFF141817, 0xFF16211D, 0xFF1A2924, 0xFF1E2E2B, 0xFF233330, 0xFF202E2E, 0xFF122020, 0xFF111C18,
    0xFF141817, 0xFF181617, 0xFF1F191B, 0xFF1F1B1C, 0xFF151716, 0xFF101916, 0xFF13221D, 0xFF3F5F52, 0xFF47695B, 0xFF456B5C, 0xFF426859, 0xFF47675A, 0xFF455A51, 0xFF252E29, 0xFF161815, 0xFF181411, 0xFF151716, 0xFF151B19, 0xFF1E2015, 0xFF514C39,
    0xFF46412E, 0xFF161910, 0xFF0F1D1E, 0xFF1A2423, 0xFF576661, 0xFF516860, 0xFF335145, 0xFF3B5D4D, 0xFF3B5D4C, 0xFF3E614D, 0xFF3E5F4C, 0xFF3A5A4D, 0xFF3F6151, 0xFF3F6453, 0xFF2B5240, 0xFF4A715E, 0xFF597B6A, 0xFF375644, 0xFF5B7665, 0xFF3F5A49,
    0xFF3E5D4B, 0xFF507261, 0xFF59806D, 0xFF58816F, 0xFF598270, 0xFF5B8270, 0xFF618577, 0xFF608573, 0xFF608573, 0xFF608573, 0xFF608573, 0xFF608573, 0xFF608573, 0xFF608573, 0xFF608573, 0xFF5D8471, 0xFF5D8471, 0xFF5E8572, 0xFF5E8572, 0xFF5E8572,
    0xFF5E8572, 0xFF5D8471, 0xFF5D8471, 0xFF608574, 0xFF567B6A, 0xFF305544, 0xFF4E7362, 0xFF264B3A, 0xFF254A39, 0xFF4B705F, 0xFF254A39, 0xFF335847, 0xFF4C7160, 0xFF1D4230, 0xFF315644, 0xFF476D58, 0xFF224833, 0xFF325841, 0xFF3D634C, 0xFF1A3820,
    0xFF2F5140, 0xFF33594A, 0xFF3B543E, 0xFF6C704B, 0xFF9F8E5A, 0xFFA68C51, 0xFFA88B51, 0xFF8B7B47, 0xFF3C4226, 0xFF36483C, 0xFF71776B, 0xFF8B897A, 0xFFD6D7CF, 0xFFDCDED3, 0xFFA8A18F, 0xFF99927F, 0xFF97907D, 0xFF9C9582, 0xFF9F9885, 0xFFA49D8A,
    0xFFA7A08D, 0xFFA09986, 0xFF9E9784, 0xFFA79885, 0xFF97907D, 0xFF797B66, 0xFF7A7869, 0xFF7C7469, 0xFF858178, 0xFF757F74, 0xFF5E7565, 0xFF617C6D, 0xFF607C6D, 0xFF658576, 0xFF678778, 0xFF506C5E, 0x009AABA3, 0x00FAFFFC, 0x00FFFFFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFF, 0x00F8FFFF, 0xFF88A69C, 0xFF477062, 0xFF658B7E, 0xFF678B7F, 0xFF315B4D, 0xFF225242, 0xFF4A7363, 0xFF3B6454, 0xFF285141, 0xFF315A4A, 0xFF497262,
    0xFF426B5B, 0xFF295242, 0xFF214A3A, 0xFF5A7667, 0xFF3F5548, 0xFF4A5A4F, 0xFFA5ACA4, 0xFFDDE0D9, 0xFFE9EAE4, 0xFFE6E7E1, 0xFFE7E8E2, 0xFFEEE9E5, 0xFFF2EFEA, 0xFFBEC3BC, 0xFF525F56, 0xFF3F5549, 0xFF446256, 0xFF53796A, 0xFF416A5A, 0xFF466053,
    0xFF435D50, 0xFF3B5749, 0xFF38584B, 0xFF3D5F51, 0xFF3B6154, 0xFF3A6355, 0xFF416A5C, 0xFF5A8373, 0xFF5B8474, 0xFF5E8777, 0xFF598272, 0xFF648D7D, 0xFF355E4E, 0xFF4B7464, 0xFF153E2E, 0xFF3D6452, 0xFF2E5543, 0xFF325947, 0xFF3B6250, 0xFF264D3B,
    0xFF416856, 0xFF4D7462, 0xFF638A78, 0xFF5C8573, 0xFF5C8573, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5C8573, 0xFF5C8573, 0xFF608573, 0xFF668776, 0xFF3C5849, 0xFF152B1E, 0xFF4C6054, 0xFF415347, 0xFF192D21, 0xFF1E3427, 0xFF1D3128,
    0xFF1A3427, 0xFF183728, 0xFF2A4235, 0xFF3C493F, 0xFF2E3A30, 0xFF213929, 0xFF365945, 0xFF3D604C, 0xFF385745, 0xFF2B4333, 0xFF374C3D, 0xFF465B4C, 0xFF324A3A, 0xFF2C4B39, 0xFF436652, 0xFF5A816E, 0xFF58826E, 0xFF4D7462, 0xFF496E5D, 0xFF4C6B5C,
    0xFF586D64, 0xFF536059, 0xFF242D28, 0xFF181C27, 0xFF171C18, 0xFF262918, 0xFF3E3C2D, 0xFF1F1A14, 0xFF1F1A1E, 0xFF19191B, 0xFF151714, 0xFF201A1C, 0xFF181617, 0xFF161C1A, 0xFF152421, 0xFF162B26, 0xFF19322E, 0xFF19322E, 0xFF112A26, 0xFF13241E,
    0xFF141F1B, 0xFF171918, 0xFF1C1819, 0xFF191718, 0xFF131716, 0xFF1D2C27, 0xFF364B44, 0xFF5A8574, 0xFF588473, 0xFF4D7C6A, 0xFF4F7E6C, 0xFF597F70, 0xFF536F63, 0xFF26352E, 0xFF111713, 0xFF1B1613, 0xFF181A19, 0xFF171B1A, 0xFF1F2116, 0xFF57523F,
    0xFF514A38, 0xFF1A1D14, 0xFF091718, 0xFF111B1A, 0xFF4A5954, 0xFF4C615A, 0xFF385448, 0xFF365647, 0xFF325443, 0xFF375845, 0xFF365744, 0xFF39594C, 0xFF355747, 0xFF244938, 0xFF305745, 0xFF375E4B, 0xFF385A49, 0xFF3F5E4C, 0xFF294433, 0xFF344F3E,
    0xFF41604E, 0xFF5D7F6E, 0xFF618875, 0xFF5A8371, 0xFF598270, 0xFF587F6D, 0xFF597D6F, 0xFF5F8472, 0xFF5F8472, 0xFF5F8472, 0xFF5F8472, 0xFF5F8472, 0xFF5F8472, 0xFF5F8472, 0xFF5F8472, 0xFF5B8571, 0xFF5B8571, 0xFF5B8571, 0xFF5B8571, 0xFF5B8571,
    0xFF5A8470, 0xFF59836F, 0xFF59836F, 0xFF5A7F6E, 0xFF2B503F, 0xFF4D7261, 0xFF234837, 0xFF2D5241, 0xFF496E5D, 0xFF224736, 0xFF2D5241, 0xFF517665, 0xFF123726, 0xFF395E4C, 0xFF406553, 0xFF173D28, 0xFF375D48, 0xFF426851, 0xFF153B24, 0xFF436149,
    0xFF365847, 0xFF325849, 0xFF3D5640, 0xFF636742, 0xFF92814D, 0xFFA3894E, 0xFFA6894F, 0xFF8E7E4A, 0xFF394225, 0xFF314337, 0xFF727A6D, 0xFF868475, 0xFFD2D3CB, 0xFFDBDDD2, 0xFFAAA391, 0xFF9F9888, 0xFFA29B8B, 0xFFA29B8B, 0xFFA59E8E, 0xFFA59E8E,
    0xFFA49D8D, 0xFFA7A090, 0xFFA69F8F, 0xFFA2998A, 0xFF939280, 0xFF787B68, 0xFF7B796A, 0xFF7F7569, 0xFF90867A, 0xFF8D8F81, 0xFF7A8976, 0xFF7B9385, 0xFF607C6D, 0xFF5F7F70, 0xFF688879, 0xFF516D5F, 0x009AABA3, 0x00F9FFFB, 0x00FFFEFC, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFF, 0x00F5FFFC, 0xFF89A79D, 0xFF4C7567, 0xFF668C7F, 0xFF62867A, 0xFF2B5547, 0xFF255545, 0xFF456E5E, 0xFF487161, 0xFF426B5B, 0xFF466F5F, 0xFF4E7767,
    0xFF355E4E, 0xFF1C4535, 0xFF224B3B, 0xFF597E6C, 0xFF3B5A4A, 0xFF475D50, 0xFFB7C4BA, 0xFFEAEFE8, 0xFFD9DAD4, 0xFFCECDC8, 0xFFCCCBC6, 0xFFE3CFD0, 0xFFF8E8E8, 0xFFCFC7C4, 0xFF595E58, 0xFF48584E, 0xFF2F4B3F, 0xFF2F5345, 0xFF234C3C, 0xFF596F63,
    0xFF445A4E, 0xFF2A4437, 0xFF2A463A, 0xFF3B5B4E, 0xFF416257, 0xFF365A4E, 0xFF31574A, 0xFF628B7B, 0xFF5E8777, 0xFF5D8676, 0xFF588171, 0xFF608979, 0xFF4F7868, 0xFF396252, 0xFF234C3C, 0xFF3B6250, 0xFF2D5442, 0xFF315846, 0xFF3A614F, 0xFF264D3B,
    0xFF416856, 0xFF4C7361, 0xFF618876, 0xFF5C8573, 0xFF5C8573, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5C8573, 0xFF5C8573, 0xFF628775, 0xFF678877, 0xFF3B5748, 0xFF142A1D, 0xFF4D6155, 0xFF415347, 0xFF172B1F, 0xFF1C3225, 0xFF21352C,
    0xFF1B3528, 0xFF1C3B2C, 0xFF2E4639, 0xFF3A473D, 0xFF3C483E, 0xFF405848, 0xFF436652, 0xFF3B5E4A, 0xFF466150, 0xFF5A6A5D, 0xFF7F897E, 0xFF7D877C, 0xFF405043, 0xFF304B3A, 0xFF5E816D, 0xFF507A66, 0xFF4C7662, 0xFF4B7462, 0xFF557A69, 0xFF4B6A5B,
    0xFF576C63, 0xFF616E67, 0xFF252E29, 0xFF151723, 0xFF161614, 0xFF262415, 0xFF3D3A2B, 0xFF1F1812, 0xFF1D171B, 0xFF1C171B, 0xFF1B1A18, 0xFF25191D, 0xFF1A1416, 0xFF181C1D, 0xFF1D2C29, 0xFF1D342E, 0xFF1B3833, 0xFF1A3933, 0xFF173630, 0xFF1D322B,
    0xFF1E2A26, 0xFF1B1F1E, 0xFF1B191A, 0xFF181818, 0xFF191F1D, 0xFF374842, 0xFF617B72, 0xFF427360, 0xFF386B58, 0xFF2A5F4B, 0xFF376A57, 0xFF4B7766, 0xFF4C6C5F, 0xFF23342C, 0xFF111A15, 0xFF1C1714, 0xFF1E1E1E, 0xFF1A1E1D, 0xFF1A1C11, 0xFF4D4634,
    0xFF48412F, 0xFF1A1D14, 0xFF101E1F, 0xFF26302F, 0xFF53625D, 0xFF51665F, 0xFF3E5A4E, 0xFF365647, 0xFF325443, 0xFF3B5C49, 0xFF3D5E4B, 0xFF3A5A4D, 0xFF3E6050, 0xFF3D6251, 0xFF3E6553, 0xFF446B58, 0xFF365847, 0xFF22412F, 0xFF2F4A39, 0xFF344F3E,
    0xFF3F5E4C, 0xFF597B6A, 0xFF5E8572, 0xFF57806E, 0xFF58816F, 0xFF5A816F, 0xFF5F8375, 0xFF5D8270, 0xFF5D8270, 0xFF5D8270, 0xFF5D8270, 0xFF5D8270, 0xFF5D8270, 0xFF5D8270, 0xFF5D8270, 0xFF5B8571, 0xFF5B8571, 0xFF5B8571, 0xFF5B8571, 0xFF5A8470,
    0xFF59836F, 0xFF58826E, 0xFF57816D, 0xFF365B4A, 0xFF527766, 0xFF244938, 0xFF315645, 0xFF4B705F, 0xFF2B503F, 0xFF2D5241, 0xFF4E7362, 0xFF1B402F, 0xFF406554, 0xFF426755, 0xFF1A3F2D, 0xFF3A604B, 0xFF416752, 0xFF123821, 0xFF3E644D, 0xFF39573F,
    0xFF426453, 0xFF446A5B, 0xFF415A44, 0xFF5E623D, 0xFF978652, 0xFFAB9156, 0xFFA6894F, 0xFF8B7B47, 0xFF374023, 0xFF2E4236, 0xFF757D70, 0xFF858374, 0xFFD0D1C9, 0xFFDADCD1, 0xFFACA593, 0xFF9E9689, 0xFFA29A8D, 0xFF9C9487, 0xFFA29A8D, 0xFFA59D90,
    0xFFA49C8F, 0xFFAAA295, 0xFFA69E91, 0xFF9B978B, 0xFF9FA193, 0xFF929685, 0xFF918F80, 0xFF8A7E72, 0xFFA29487, 0xFFC2BFAE, 0xFFCCD5C0, 0xFFB2CABC, 0xFF779384, 0xFF607F70, 0xFF658576, 0xFF516B5E, 0x009AABA3, 0x00FBFFFC, 0x00FFFFFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFF, 0x00F8FFFF, 0xFF89A79D, 0xFF487163, 0xFF678D80, 0xFF668A7E, 0xFF2B5547, 0xFF265646, 0xFF446F5E, 0xFF244F3E, 0xFF406B5A, 0xFF3A6554, 0xFF3B6655,
    0xFF487362, 0xFF234E3D, 0xFF224D3C, 0xFF5B8472, 0xFF466556, 0xFF6A7A70, 0xFFBFC0BB, 0xFFE5E0DD, 0xFFEDE5E3, 0xFFD3D2CE, 0xFFC4C5C0, 0xFFDED8D8, 0xFFDAD6D5, 0xFFD2D2D0, 0xFF757A76, 0xFF66716B, 0xFF63746C, 0xFF475C53, 0xFF576E64, 0xFF8E908D,
    0xFF747673, 0xFF535552, 0xFF4F5450, 0xFF727773, 0xFFB3B9B5, 0xFFAFB5B1, 0xFF474D49, 0xFF456B5E, 0xFF62887B, 0xFF61877A, 0xFF5B8172, 0xFF5E8475, 0xFF4E7563, 0xFF3D6452, 0xFF204735, 0xFF3C6350, 0xFF325946, 0xFF2F5643, 0xFF3A614E, 0xFF264D3A,
    0xFF406754, 0xFF527966, 0xFF5F8673, 0xFF5B8472, 0xFF5C8573, 0xFF5E8775, 0xFF5F8876, 0xFF5E8775, 0xFF5D8674, 0xFF5D8674, 0xFF5F8876, 0xFF5E8274, 0xFF6A8F7E, 0xFF3B5B4C, 0xFF1C2D23, 0xFF585D56, 0xFF4F524B, 0xFF152719, 0xFF153623, 0xFF182E21,
    0xFF203C2D, 0xFF1D3C2C, 0xFF35493D, 0xFF414B42, 0xFF3C463D, 0xFF0D2819, 0xFF2D5844, 0xFF39634F, 0xFF3F5B4C, 0xFF535D54, 0xFFBBB8B3, 0xFFD4CFCB, 0xFF767D75, 0xFF3E5648, 0xFF5B7D6C, 0xFF567D6A, 0xFF507563, 0xFF587A6A, 0xFF4F6B5D, 0xFF354D40,
    0xFF74887F, 0xFF62716A, 0xFF26332C, 0xFF17141D, 0xFF1E1A17, 0xFF333124, 0xFF49473B, 0xFF1D1C18, 0xFF15191C, 0xFF151E1B, 0xFF18251B, 0xFF171C18, 0xFF171C18, 0xFF1A1F1B, 0xFF272D2B, 0xFF222E2A, 0xFF162B26, 0xFF1C3A32, 0xFF1B3C33, 0xFF1C3730,
    0xFF29403A, 0xFF1C2B28, 0xFF141F1B, 0xFF0F1B17, 0xFF0A2117, 0xFF3E6254, 0xFF507C6B, 0xFF415B52, 0xFF1A352C, 0xFF07271C, 0xFF0E2F24, 0xFF1C3A30, 0xFF243B33, 0xFF1B2723, 0xFF111A17, 0xFF121D15, 0xFF131917, 0xFF191B1A, 0xFF232319, 0xFF5B5A46,
    0xFF4F4E3A, 0xFF17170F, 0xFF1B1A20, 0xFF222826, 0xFF4C5751, 0xFF53645C, 0xFF41594C, 0xFF385445, 0xFF385745, 0xFF405D49, 0xFF405D49, 0xFF3A5647, 0xFF3D594A, 0xFF435E4F, 0xFF456051, 0xFF445C4E, 0xFF425A4C, 0xFF4A6254, 0xFF556B5E, 0xFF54695A,
    0xFF4C6353, 0xFF4E6A5B, 0xFF5D7F6E, 0xFF658C7A, 0xFF628977, 0xFF608574, 0xFF64887A, 0xFF5E8475, 0xFF5F8576, 0xFF618778, 0xFF628879, 0xFF618778, 0xFF608677, 0xFF608677, 0xFF608677, 0xFF628879, 0xFF648A7B, 0xFF63897A, 0xFF608677, 0xFF618778,
    0xFF5F8576, 0xFF517768, 0xFF3F6556, 0xFF4E7563, 0xFF234A38, 0xFF2C5341, 0xFF4B7260, 0xFF29503E, 0xFF2C5341, 0xFF4E7563, 0xFF1C4331, 0xFF37614D, 0xFF436D59, 0xFF153C29, 0xFF3D6451, 0xFF446957, 0xFF143927, 0xFF3B5D4C, 0xFF406251, 0xFF3F6453,
    0xFF597866, 0xFF527362, 0xFF365647, 0xFF596444, 0xFF9A854C, 0xFFAB8C4C, 0xFFA08B54, 0xFF8A794B, 0xFF38401B, 0xFF334633, 0xFF777C76, 0xFF84817A, 0xFFD3D6C5, 0xFFDDE0CF, 0xFFA9A097, 0xFF98917F, 0xFF958E7C, 0xFF9C9583, 0xFFA69F8D, 0xFFABA492,
    0xFFACA593, 0xFFA69F8D, 0xFF9A9381, 0xFF9B937E, 0xFF988F7D, 0xFF9C9583, 0xFF95907D, 0xFF8D8A79, 0xFF918F80, 0xFFC3C1B4, 0xFFDDDED0, 0xFF96B5A5, 0xFF6E8F7E, 0xFF668878, 0xFF6A8C7C, 0xFF4F6B5D, 0x0096A79F, 0x00F8FEFA, 0x00FFFFFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFCFE, 0x00F5FFFC, 0xFF84A298, 0xFF456E60, 0xFF658B7E, 0xFF63877B, 0xFF2A5446, 0xFF235343, 0xFF446E60, 0xFF345E50, 0xFF416B5D, 0xFF335D4F, 0xFF3B6557,
    0xFF497365, 0xFF254F41, 0xFF254F41, 0xFF587F6D, 0xFF3C5B4C, 0xFF6A7A70, 0xFFCACCC7, 0xFFE0DBD8, 0xFFDCD7D4, 0xFFDBDAD6, 0xFFD9DBD6, 0xFFD9D3D3, 0xFFECE8E7, 0xFFCACAC8, 0xFF707672, 0xFF7D8C85, 0xFF53685F, 0xFF3F594E, 0xFF627E72, 0xFFA3AEA8,
    0xFF89948E, 0xFF69746E, 0xFF6C7972, 0xFF839089, 0xFFA4B3AC, 0xFFAFBEB7, 0xFF82918A, 0xFF32584B, 0xFF4F7568, 0xFF597F72, 0xFF608677, 0xFF668C7D, 0xFF486F5D, 0xFF406755, 0xFF224937, 0xFF406754, 0xFF2B523F, 0xFF365D4A, 0xFF375E4B, 0xFF224936,
    0xFF466D5A, 0xFF4D7461, 0xFF648B78, 0xFF5D8674, 0xFF5E8775, 0xFF5F8876, 0xFF608977, 0xFF5F8876, 0xFF5E8775, 0xFF5D8674, 0xFF5D8674, 0xFF5D8173, 0xFF608775, 0xFF3B5B4C, 0xFF203429, 0xFF565B54, 0xFF53564F, 0xFF1E3022, 0xFF11301E, 0xFF172D20,
    0xFF112C1D, 0xFF1F3A2B, 0xFF34483C, 0xFF49534A, 0xFF323E34, 0xFF264233, 0xFF3E6955, 0xFF608A76, 0xFF4E6A5B, 0xFF525E54, 0xFF9F9E99, 0xFF9F9C97, 0xFF555F56, 0xFF40584A, 0xFF5A7C6B, 0xFF527966, 0xFF557A68, 0xFF537565, 0xFF496557, 0xFF455D50,
    0xFF6C8077, 0xFF4D5C55, 0xFF19261F, 0xFF14141C, 0xFF171813, 0xFF292A1C, 0xFF413F33, 0xFF1A1915, 0xFF16171B, 0xFF161C1A, 0xFF19231A, 0xFF202521, 0xFF1C211D, 0xFF191E1A, 0xFF1F2523, 0xFF17231F, 0xFF10231F, 0xFF19322C, 0xFF18372F, 0xFF122D26,
    0xFF1D322D, 0xFF192523, 0xFF151E1B, 0xFF18211E, 0xFF15261E, 0xFF3C584C, 0xFF47695B, 0xFF20332D, 0xFF11261F, 0xFF122C23, 0xFF173128, 0xFF162D25, 0xFF162721, 0xFF131C19, 0xFF171B1A, 0xFF171E17, 0xFF161A19, 0xFF191919, 0xFF1B1B11, 0xFF4F513C,
    0xFF464934, 0xFF13160D, 0xFF14191D, 0xFF151E1B, 0xFF58655E, 0xFF5C7168, 0xFF385446, 0xFF335242, 0xFF3A5B48, 0xFF385944, 0xFF31513C, 0xFF395848, 0xFF3B5A4A, 0xFF3F5E4E, 0xFF435F50, 0xFF415D4E, 0xFF415C4D, 0xFF476253, 0xFF4F6A5B, 0xFF4A6151,
    0xFF3D5847, 0xFF355645, 0xFF395E4C, 0xFF396250, 0xFF355E4C, 0xFF365D4B, 0xFF3B5F51, 0xFF406657, 0xFF416758, 0xFF426859, 0xFF426859, 0xFF406657, 0xFF406657, 0xFF416758, 0xFF43695A, 0xFF406657, 0xFF406657, 0xFF3B6152, 0xFF385E4F, 0xFF3D6354,
    0xFF446A5B, 0xFF426859, 0xFF3A6051, 0xFF264D3B, 0xFF305745, 0xFF4D7462, 0xFF204735, 0xFF2B5240, 0xFF4F7664, 0xFF234A38, 0xFF2D5442, 0xFF436D59, 0xFF1A4430, 0xFF406754, 0xFF385F4C, 0xFF1E4331, 0xFF416654, 0xFF416352, 0xFF1F4130, 0xFF3F6453,
    0xFF496856, 0xFF3B5C4B, 0xFF284839, 0xFF525D3D, 0xFF958047, 0xFFA98A4A, 0xFFA6915A, 0xFF89784A, 0xFF373F1A, 0xFF334633, 0xFF767B75, 0xFF84817A, 0xFFD3D6C5, 0xFFDCDFCE, 0xFFA9A097, 0xFF8D8674, 0xFF88816F, 0xFF8F8876, 0xFF9D9684, 0xFFA7A08E,
    0xFFA9A290, 0xFF9E9785, 0xFF8D8674, 0xFF948B79, 0xFF968D7B, 0xFF98917F, 0xFF8F8979, 0xFF898677, 0xFF939182, 0xFFC3C1B4, 0xFFD8D8CC, 0xFF739282, 0xFF5A7B6A, 0xFF5B7D6D, 0xFF658777, 0xFF516D5F, 0x009AABA3, 0x00FBFFFD, 0x00FFFFFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFF, 0x00F7FFFE, 0xFF84A298, 0xFF4A7365, 0xFF6A9083, 0xFF65897D, 0xFF2D5749, 0xFF215141, 0xFF5A847A, 0xFF487268, 0xFF396359, 0xFF2D574D, 0xFF446E64,
    0xFF497369, 0xFF224C42, 0xFF1E483E, 0xFF5C7E6E, 0xFF385245, 0xFF536359, 0xFFC1C6C0, 0xFFE9E8E4, 0xFFDFDEDA, 0xFFD7D9D4, 0xFFD5DAD4, 0xFFDCD8D7, 0xFFE6E5E3, 0xFFBFC4C0, 0xFF637069, 0xFF697D74, 0xFF395549, 0xFF496B5D, 0xFF3D6153, 0xFF50675D,
    0xFF475E54, 0xFF395046, 0xFF445E53, 0xFF4D675C, 0xFF466256, 0xFF4B675B, 0xFF466256, 0xFF406659, 0xFF31574A, 0xFF5C8275, 0xFF5C8273, 0xFF5D8374, 0xFF4C7361, 0xFF39604E, 0xFF204735, 0xFF3A614F, 0xFF2D5442, 0xFF345B49, 0xFF3D6452, 0xFF284F3D,
    0xFF416856, 0xFF537A68, 0xFF608775, 0xFF5C8573, 0xFF5D8674, 0xFF5E8775, 0xFF5E8775, 0xFF5E8775, 0xFF5E8775, 0xFF5D8674, 0xFF5B8472, 0xFF5D8173, 0xFF6A917F, 0xFF335545, 0xFF142A1E, 0xFF5C635B, 0xFF5D6059, 0xFF223225, 0xFF0F2C1A, 0xFF1E3427,
    0xFF183022, 0xFF1F3528, 0xFF3D4D42, 0xFF475349, 0xFF203025, 0xFF163223, 0xFF547E6A, 0xFF5B8571, 0xFF597868, 0xFF516156, 0xFF8C8F88, 0xFF949790, 0xFF4A564C, 0xFF324D3E, 0xFF5B806E, 0xFF587F6C, 0xFF527765, 0xFF4A6C5C, 0xFF496557, 0xFF61796C,
    0xFF788C83, 0xFF5F6E67, 0xFF2D3A33, 0xFF131C21, 0xFF121912, 0xFF202415, 0xFF38382C, 0xFF181713, 0xFF19171C, 0xFF191B1A, 0xFF1D221B, 0xFF181E1A, 0xFF171D19, 0xFF171C18, 0xFF191F1D, 0xFF131E1A, 0xFF11201D, 0xFF192E29, 0xFF17302A, 0xFF18312B,
    0xFF1D302C, 0xFF1E2827, 0xFF1A1E1D, 0xFF1C201F, 0xFF141D18, 0xFF23322B, 0xFF23372E, 0xFF18231F, 0xFF15201C, 0xFF1E2A26, 0xFF1C2824, 0xFF131E1A, 0xFF111715, 0xFF141615, 0xFF1D1B1C, 0xFF1C1D18, 0xFF1C1C1C, 0xFF1C1A1B, 0xFF1A170E, 0xFF474934,
    0xFF3E462F, 0xFF0D170C, 0xFF101B1D, 0xFF1D2925, 0xFF72837B, 0xFF7B9288, 0xFF4B6A5B, 0xFF3C5E4D, 0xFF3E644F, 0xFF42654F, 0xFF466953, 0xFF416352, 0xFF416352, 0xFF436554, 0xFF456655, 0xFF456655, 0xFF466555, 0xFF4A6959, 0xFF4F6E5E, 0xFF597463,
    0xFF4F6E5C, 0xFF446957, 0xFF3F6955, 0xFF3E6956, 0xFF3D6855, 0xFF3F6856, 0xFF456B5C, 0xFF45695B, 0xFF466A5C, 0xFF45695B, 0xFF44685A, 0xFF436759, 0xFF436759, 0xFF45695B, 0xFF476B5D, 0xFF426658, 0xFF476B5D, 0xFF496D5F, 0xFF486C5E, 0xFF496D5F,
    0xFF486C5E, 0xFF406456, 0xFF35594B, 0xFF2D5442, 0xFF4E7563, 0xFF244B39, 0xFF335A48, 0xFF446B59, 0xFF284F3D, 0xFF3E6553, 0xFF486F5D, 0xFF254F3B, 0xFF2F5945, 0xFF426956, 0xFF274E3B, 0xFF375C4A, 0xFF406553, 0xFF1A3C2B, 0xFF385A49, 0xFF456A59,
    0xFF436250, 0xFF365746, 0xFF315142, 0xFF616C4C, 0xFF9B864D, 0xFFA98A4A, 0xFFA6915A, 0xFF887749, 0xFF373F1A, 0xFF314431, 0xFF757A74, 0xFF84817A, 0xFFD4D7C6, 0xFFDCDFCE, 0xFFA9A097, 0xFF908977, 0xFF88816F, 0xFF8C8573, 0xFF9A9381, 0xFFA69F8D,
    0xFFAAA391, 0xFFA09987, 0xFF8F8876, 0xFF928977, 0xFF968F7C, 0xFF9D9684, 0xFF958F7F, 0xFF8E8B7C, 0xFFA09E91, 0xFFCBCCBE, 0xFFD4D4C8, 0xFF6A8979, 0xFF618271, 0xFF628474, 0xFF688A7A, 0xFF557163, 0x009BACA4, 0x00F7FDF9, 0x00FEFDFB, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFF, 0x00F8FFFF, 0xFF83A197, 0xFF4B7466, 0xFF678D80, 0xFF5C8074, 0xFF275143, 0xFF174737, 0xFF244C43, 0xFF1D453C, 0xFF153D34, 0xFF173F36, 0xFF264E45,
    0xFF1D453C, 0xFF10382F, 0xFF244C43, 0xFF658475, 0xFF506A5D, 0xFF526359, 0xFFAFBAB2, 0xFFEBF2EB, 0xFFE2E9E2, 0xFFD4DED6, 0xFFDAE5DD, 0xFFE2E4E1, 0xFFF3F8F4, 0xFFBFCAC4, 0xFF5F736A, 0xFF849E93, 0xFF527466, 0xFF638C7C, 0xFF537E6D, 0xFF5B7D6F,
    0xFF5F8173, 0xFF567A6C, 0xFF5C8072, 0xFF5D8374, 0xFF527869, 0xFF53796A, 0xFF537C6C, 0xFF3C6255, 0xFF476D60, 0xFF3A6053, 0xFF486E5F, 0xFF6E9485, 0xFF456C5A, 0xFF436A58, 0xFF224937, 0xFF3B6250, 0xFF2A513F, 0xFF375E4C, 0xFF3A614F, 0xFF274E3C,
    0xFF426957, 0xFF517866, 0xFF618876, 0xFF5B8472, 0xFF5C8573, 0xFF5C8573, 0xFF5B8472, 0xFF5C8573, 0xFF5E8775, 0xFF5E8775, 0xFF5C8573, 0xFF618577, 0xFF5E8573, 0xFF4E7362, 0xFF1A3225, 0xFF626C63, 0xFF878A83, 0xFF2B372B, 0xFF162D1D, 0xFF172D20,
    0xFF2A3E32, 0xFF0D1D12, 0xFF5D6A60, 0xFF505D53, 0xFF2A3E32, 0xFF1E3D2D, 0xFF466D5A, 0xFF537E6A, 0xFF5C7D6C, 0xFF5D7165, 0xFFA2ACA3, 0xFFB5BFB6, 0xFF5A6C60, 0xFF375344, 0xFF658A78, 0xFF446B58, 0xFF345947, 0xFF345646, 0xFF385446, 0xFF536B5E,
    0xFF64786F, 0xFF64736C, 0xFF38453E, 0xFF263437, 0xFF202B23, 0xFF262F1E, 0xFF3D3F32, 0xFF1F1E1A, 0xFF1E1C21, 0xFF1E1C1D, 0xFF23241E, 0xFF15201A, 0xFF18211C, 0xFF1F2521, 0xFF232726, 0xFF1F2523, 0xFF1C2625, 0xFF1B2B28, 0xFF142723, 0xFF162B26,
    0xFF172623, 0xFF1E2726, 0xFF1A1C1B, 0xFF1D1D1D, 0xFF161614, 0xFF181A17, 0xFF151A16, 0xFF1B1D1C, 0xFF151716, 0xFF181A19, 0xFF171918, 0xFF191919, 0xFF1E1C1D, 0xFF1C1819, 0xFF1F191B, 0xFF171612, 0xFF191516, 0xFF211D1E, 0xFF242118, 0xFF50533E,
    0xFF475139, 0xFF1F2D20, 0xFF2B3B3B, 0xFF25342F, 0xFF566A61, 0xFF516D61, 0xFF355747, 0xFF345947, 0xFF335A45, 0xFF315941, 0xFF365C45, 0xFF39604D, 0xFF385F4C, 0xFF3A5F4D, 0xFF3B604E, 0xFF3C614F, 0xFF3E604F, 0xFF406251, 0xFF426453, 0xFF405F4D,
    0xFF3E614D, 0xFF3B624F, 0xFF37624E, 0xFF36634F, 0xFF386350, 0xFF3A6351, 0xFF3C6253, 0xFF3E6352, 0xFF3E6352, 0xFF3F6453, 0xFF3D6251, 0xFF3C6150, 0xFF3C6150, 0xFF3D6251, 0xFF3F6453, 0xFF3E6352, 0xFF416655, 0xFF426756, 0xFF3F6453, 0xFF3E6352,
    0xFF3E6352, 0xFF3B604F, 0xFF365B4A, 0xFF446B59, 0xFF2A513F, 0xFF355C4A, 0xFF486F5D, 0xFF274E3C, 0xFF2B5240, 0xFF4A715F, 0xFF244B39, 0xFF36604C, 0xFF446E5A, 0xFF1D4431, 0xFF375E4B, 0xFF436856, 0xFF224735, 0xFF3E604F, 0xFF466857, 0xFF3B604F,
    0xFF385745, 0xFF315241, 0xFF345445, 0xFF657050, 0xFF9C874E, 0xFFA88949, 0xFFA28D56, 0xFF877648, 0xFF38401B, 0xFF304330, 0xFF747973, 0xFF85827B, 0xFFD4D7C6, 0xFFDBDECD, 0xFFAAA198, 0xFF9E9785, 0xFF968F7D, 0xFF968F7D, 0xFF9C9583, 0xFFA29B89,
    0xFFA8A18F, 0xFFA8A18F, 0xFFA09987, 0xFF9E9784, 0xFF9E9785, 0xFFA6A090, 0xFF9C9988, 0xFF868475, 0xFF9A9B8D, 0xFFC1C1B5, 0xFFB5B7AA, 0xFF607F6F, 0xFF638473, 0xFF628474, 0xFF638575, 0xFF516D5F, 0x0098A9A1, 0x00F7FDF9, 0x00FFFFFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFCFE, 0x00F6FFFD, 0xFF7C9A90, 0xFF497264, 0xFF688E81, 0xFF62867A, 0xFF3F695B, 0xFF346454, 0xFF325A51, 0xFF2F574E, 0xFF2C544B, 0xFF315950, 0xFF325A51,
    0xFF264E45, 0xFF274F46, 0xFF386057, 0xFF6B8A7B, 0xFF6F8B7D, 0xFF647C6F, 0xFF899D92, 0xFF99AAA0, 0xFF8C9D93, 0xFF8CA095, 0xFFA0B4A9, 0xFF8D9C95, 0xFF8A9B93, 0xFF758A81, 0xFF415B50, 0xFF69897C, 0xFF466C5D, 0xFF5E8978, 0xFF5A8675, 0xFF5C8776,
    0xFF5F8A79, 0xFF5D8877, 0xFF5C8877, 0xFF5A8675, 0xFF5A8675, 0xFF5D8C7A, 0xFF5B8A78, 0xFF547A6D, 0xFF3A6053, 0xFF42685B, 0xFF416758, 0xFF53796A, 0xFF4A715F, 0xFF436A58, 0xFF1E4533, 0xFF416856, 0xFF274E3C, 0xFF3E6553, 0xFF325947, 0xFF244B39,
    0xFF456C5A, 0xFF466D5B, 0xFF628977, 0xFF5E8775, 0xFF608977, 0xFF5F8876, 0xFF5C8573, 0xFF5C8573, 0xFF5F8876, 0xFF5F8876, 0xFF5C8573, 0xFF67897B, 0xFF598270, 0xFF38614F, 0xFF244032, 0xFF758177, 0xFFA9ACA5, 0xFF677166, 0xFF122416, 0xFF1A3023,
    0xFF112116, 0xFF3B453C, 0xFF8E988F, 0xFF68786D, 0xFF435B4D, 0xFF1D3E2D, 0xFF577C6A, 0xFF5E8975, 0xFF5A7F6D, 0xFF405B4C, 0xFF415347, 0xFF405045, 0xFF344A3D, 0xFF486958, 0xFF507764, 0xFF335A47, 0xFF305543, 0xFF395B4B, 0xFF3A5648, 0xFF51695C,
    0xFF596D64, 0xFF5E6D66, 0xFF3E4B44, 0xFF2D3C3F, 0xFF26332A, 0xFF293221, 0xFF3B3F31, 0xFF1D1C18, 0xFF19171C, 0xFF161616, 0xFF1E1F19, 0xFF15221B, 0xFF141F19, 0xFF1C221E, 0xFF1F2322, 0xFF1D2120, 0xFF202626, 0xFF1D2726, 0xFF182422, 0xFF14201E,
    0xFF131D1C, 0xFF1F2525, 0xFF191B1A, 0xFF1E1C1D, 0xFF181715, 0xFF191816, 0xFF191816, 0xFF1C1C1C, 0xFF161415, 0xFF161415, 0xFF181415, 0xFF1E1A1B, 0xFF201C1D, 0xFF181415, 0xFF161415, 0xFF1E1D19, 0xFF171516, 0xFF201C1D, 0xFF25251B, 0xFF4C513B,
    0xFF3B472F, 0xFF19291C, 0xFF2E4040, 0xFF2E3D38, 0xFF465A51, 0xFF3F5B4F, 0xFF345646, 0xFF365B49, 0xFF345B46, 0xFF345C44, 0xFF385E47, 0xFF355C49, 0xFF355C49, 0xFF345B48, 0xFF365B49, 0xFF375C4A, 0xFF395E4C, 0xFF3C5E4D, 0xFF3B5D4C, 0xFF3B5C49,
    0xFF3E614D, 0xFF3D6451, 0xFF3A6551, 0xFF396451, 0xFF3A6351, 0xFF3C6150, 0xFF3C5E50, 0xFF436555, 0xFF446656, 0xFF456757, 0xFF456757, 0xFF446656, 0xFF426454, 0xFF426454, 0xFF436555, 0xFF456757, 0xFF466858, 0xFF446656, 0xFF406252, 0xFF3F6151,
    0xFF426454, 0xFF456757, 0xFF476959, 0xFF3B6250, 0xFF244B39, 0xFF486F5D, 0xFF29503E, 0xFF2E5543, 0xFF4D7462, 0xFF1F4634, 0xFF2E5543, 0xFF3E6854, 0xFF224C38, 0xFF3E6552, 0xFF3A614E, 0xFF234836, 0xFF375C4A, 0xFF456756, 0xFF436554, 0xFF557A69,
    0xFF52715F, 0xFF456655, 0xFF3B5B4C, 0xFF616C4C, 0xFF9A854C, 0xFFA98A4A, 0xFFA08B54, 0xFF887749, 0xFF39411C, 0xFF304330, 0xFF737872, 0xFF87847D, 0xFFD5D8C7, 0xFFDADDCC, 0xFFA9A097, 0xFFA39C8A, 0xFF9F9886, 0xFFA09987, 0xFFA09987, 0xFF9D9684,
    0xFFA19A88, 0xFFA8A18F, 0xFFA9A290, 0xFFAAA391, 0xFF9F9A87, 0xFFA9A393, 0xFFA19E8F, 0xFF7E7C6F, 0xFF97978B, 0xFFBFC1B4, 0xFFA9ABA0, 0xFF5B7A6A, 0xFF648574, 0xFF618373, 0xFF618373, 0xFF516D5F, 0x0099AAA2, 0x00FAFFFC, 0x00FFFFFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFCFE, 0x00F6FFFD, 0xFF78968C, 0xFF4A7365, 0xFF6A9083, 0xFF6D9185, 0xFF5E887A, 0xFF5C8C7C, 0xFF679082, 0xFF628B7D, 0xFF5E8779, 0xFF5F887A, 0xFF628B7D,
    0xFF638C7E, 0xFF628B7D, 0xFF5C8577, 0xFF5F7F70, 0xFF648475, 0xFF5D7D6E, 0xFF688778, 0xFF5C7B6C, 0xFF5B7A6B, 0xFF658475, 0xFF6A897A, 0xFF668478, 0xFF567468, 0xFF68887B, 0xFF547668, 0xFF557B6C, 0xFF507969, 0xFF6B9685, 0xFF5A8574, 0xFF5C8776,
    0xFF5B8675, 0xFF5E8A79, 0xFF618D7C, 0xFF598876, 0xFF568573, 0xFF598876, 0xFF588976, 0xFF62887B, 0xFF577D70, 0xFF3E6457, 0xFF446A5B, 0xFF3A6051, 0xFF2C5341, 0xFF4D7462, 0xFF204735, 0xFF355B4C, 0xFF375D4E, 0xFF325849, 0xFF3B6152, 0xFF355B4C,
    0xFF365C4D, 0xFF496F60, 0xFF4D7364, 0xFF5D8674, 0xFF638C7A, 0xFF648D7B, 0xFF608977, 0xFF5E8775, 0xFF608977, 0xFF608977, 0xFF5C8573, 0xFF5E8072, 0xFF739C8A, 0xFF45705D, 0xFF204031, 0xFF68756B, 0xFFA8ABA4, 0xFFAEB4AA, 0xFF8A968A, 0xFF5D7366,
    0xFF6E7B71, 0xFFAAADA6, 0xFFA3A8A1, 0xFF8C9C91, 0xFF587465, 0xFF305241, 0xFF5F8170, 0xFF54816C, 0xFF5C8370, 0xFF395848, 0xFF21392B, 0xFF21372A, 0xFF223E2F, 0xFF385A49, 0xFF335A47, 0xFF335A47, 0xFF395E4C, 0xFF3B5D4D, 0xFF395547, 0xFF60786B,
    0xFF687C73, 0xFF4C5B54, 0xFF24312A, 0xFF202B2F, 0xFF1C271F, 0xFF232A1A, 0xFF383C2E, 0xFF1B1C17, 0xFF16171B, 0xFF151918, 0xFF232A22, 0xFF26352E, 0xFF1A2720, 0xFF191F1B, 0xFF171918, 0xFF161616, 0xFF1C1D1F, 0xFF1C2021, 0xFF1C2222, 0xFF1C2021,
    0xFF1B1F20, 0xFF222627, 0xFF1B1D1C, 0xFF1E1E1E, 0xFF171715, 0xFF1A1A18, 0xFF1C1B19, 0xFF1B1D1C, 0xFF1B1B1B, 0xFF1E1C1D, 0xFF1C1819, 0xFF1B1718, 0xFF1A1819, 0xFF1B1D1C, 0xFF292D2C, 0xFF212620, 0xFF121413, 0xFF161616, 0xFF1F2116, 0xFF464B35,
    0xFF364028, 0xFF162417, 0xFF2E3C3D, 0xFF27332F, 0xFF4C5D55, 0xFF51685E, 0xFF3F5E4F, 0xFF375948, 0xFF365C47, 0xFF3F624C, 0xFF41644E, 0xFF3D6451, 0xFF3F6452, 0xFF3E6351, 0xFF3E6351, 0xFF426453, 0xFF456756, 0xFF456655, 0xFF436453, 0xFF476654,
    0xFF486956, 0xFF456A58, 0xFF446B58, 0xFF446B59, 0xFF456A59, 0xFF476758, 0xFF4A665A, 0xFF456757, 0xFF476959, 0xFF486A5A, 0xFF486A5A, 0xFF466858, 0xFF456757, 0xFF446656, 0xFF446656, 0xFF456757, 0xFF486A5A, 0xFF4A6C5C, 0xFF496B5B, 0xFF476959,
    0xFF456757, 0xFF436555, 0xFF416353, 0xFF3E6553, 0xFF4F7664, 0xFF264D3B, 0xFF2F5644, 0xFF4A715F, 0xFF2E5543, 0xFF305745, 0xFF486F5D, 0xFF204A36, 0xFF335D49, 0xFF49705D, 0xFF254C39, 0xFF315644, 0xFF496E5C, 0xFF355746, 0xFF5B7D6C, 0xFF587D6C,
    0xFF597866, 0xFF4C6D5C, 0xFF385849, 0xFF596444, 0xFF99844B, 0xFFAD8E4E, 0xFFA18C55, 0xFF8A794B, 0xFF3C441F, 0xFF314431, 0xFF737872, 0xFF88857E, 0xFFD6D9C8, 0xFFD9DCCB, 0xFFA9A097, 0xFF9F9886, 0xFF9F9886, 0xFFA49D8B, 0xFFA69F8D, 0xFFA29B89,
    0xFFA29B89, 0xFFA69F8D, 0xFFA49D8B, 0xFFA6A18E, 0xFF9A9484, 0xFF9F9C8B, 0xFF9D9B8C, 0xFF7C7D6F, 0xFF99998D, 0xFFC0C2B7, 0xFFB0B2A7, 0xFF5E7D6D, 0xFF688978, 0xFF648676, 0xFF668878, 0xFF536F61, 0x0098A9A1, 0x00F9FFFB, 0x00FDFCFA, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFF, 0x00F8FFFF, 0xFF7A988E, 0xFF4A7365, 0xFF63897C, 0xFF63877B, 0xFF5C8678, 0xFF5D8D7D, 0xFF5E8573, 0xFF658C7A, 0xFF6A917F, 0xFF638A78, 0xFF5E8573,
    0xFF5F8674, 0xFF628977, 0xFF648B79, 0xFF6B8D7D, 0xFF658A79, 0xFF618876, 0xFF699280, 0xFF648F7C, 0xFF6C9784, 0xFF6A9381, 0xFF628B79, 0xFF5F8B7A, 0xFF6F9B8A, 0xFF6E9988, 0xFF5F8A79, 0xFF628B7B, 0xFF638C7C, 0xFF5C8273, 0xFF5E8475, 0xFF648D7D,
    0xFF608979, 0xFF5D8877, 0xFF5C8776, 0xFF598574, 0xFF558170, 0xFF568271, 0xFF5B8A78, 0xFF5B8174, 0xFF688E81, 0xFF52786B, 0xFF355B4C, 0xFF406657, 0xFF3F6654, 0xFF254C3A, 0xFF466D5B, 0xFF2E5445, 0xFF3E6455, 0xFF2F5546, 0xFF3F6556, 0xFF406657,
    0xFF315748, 0xFF426859, 0xFF3E6455, 0xFF4F7866, 0xFF5A8371, 0xFF618A78, 0xFF5F8876, 0xFF5E8775, 0xFF618A78, 0xFF608977, 0xFF5D8674, 0xFF618375, 0xFF58816F, 0xFF5B8874, 0xFF224434, 0xFF5A6A5F, 0xFFABAEA7, 0xFF8C8F86, 0xFF858D82, 0xFF8EA497,
    0xFF97A198, 0xFF8A8984, 0xFFA6A9A2, 0xFF96A89C, 0xFF254635, 0xFF446655, 0xFF6A8B7A, 0xFF598671, 0xFF537D69, 0xFF456756, 0xFF597566, 0xFF5F7B6C, 0xFF274636, 0xFF244937, 0xFF3C6350, 0xFF2E5542, 0xFF2F5442, 0xFF305242, 0xFF375345, 0xFF6D8578,
    0xFF8EA299, 0xFF606F68, 0xFF26332C, 0xFF181D23, 0xFF1A1F19, 0xFF262A1B, 0xFF3D3F32, 0xFF20221D, 0xFF1A1F22, 0xFF1B2622, 0xFF2E3B31, 0xFF3C4D45, 0xFF27342D, 0xFF1E2722, 0xFF1B1D1C, 0xFF191718, 0xFF1C1A1D, 0xFF19191B, 0xFF1A1B1D, 0xFF1C1A1D,
    0xFF1C1A1D, 0xFF1D1E20, 0xFF171B1A, 0xFF1C201F, 0xFF161B17, 0xFF1D221E, 0xFF1B201C, 0xFF111A17, 0xFF151918, 0xFF1D1D1D, 0xFF1A1819, 0xFF191718, 0xFF191D1C, 0xFF252E2B, 0xFF434F4B, 0xFF2F3A32, 0xFF18211E, 0xFF181C1B, 0xFF22251A, 0xFF4C513B,
    0xFF3D452E, 0xFF151D12, 0xFF202A2C, 0xFF29322F, 0xFF58655E, 0xFF556A61, 0xFF3B5749, 0xFF3C5B4B, 0xFF426350, 0xFF41624D, 0xFF3B5B46, 0xFF3F6150, 0xFF416352, 0xFF416352, 0xFF416251, 0xFF426352, 0xFF476656, 0xFF466555, 0xFF436252, 0xFF486553,
    0xFF446351, 0xFF436453, 0xFF446655, 0xFF456757, 0xFF476657, 0xFF4B6558, 0xFF50655C, 0xFF446655, 0xFF456756, 0xFF466857, 0xFF456756, 0xFF436554, 0xFF426453, 0xFF426453, 0xFF436554, 0xFF436554, 0xFF446655, 0xFF456756, 0xFF456756, 0xFF456756,
    0xFF456756, 0xFF466857, 0xFF476958, 0xFF4A715F, 0xFF466D5B, 0xFF365D4B, 0xFF446B59, 0xFF2B5240, 0xFF264D3B, 0xFF4C7361, 0xFF234A38, 0xFF36604C, 0xFF4B7561, 0xFF1F4633, 0xFF325946, 0xFF436856, 0xFF385D4B, 0xFF638574, 0xFF5A7C6B, 0xFF597E6D,
    0xFF5C7B69, 0xFF4F705F, 0xFF3A5A4B, 0xFF5A6545, 0xFF9C874E, 0xFFB09151, 0xFFA08B54, 0xFF8C7B4D, 0xFF3E4621, 0xFF324532, 0xFF737872, 0xFF89867F, 0xFFD6D9C8, 0xFFD8DBCA, 0xFFA89F96, 0xFF98917F, 0xFF958E7C, 0xFF9C9583, 0xFFA69F8D, 0xFFA9A290,
    0xFFA9A290, 0xFFA49D8B, 0xFF999280, 0xFF999383, 0xFF969080, 0xFF949182, 0xFF949285, 0xFF7B7B6F, 0xFF8B8D82, 0xFFA6A89D, 0xFFA1A49B, 0xFF5A7969, 0xFF608170, 0xFF5C7E6E, 0xFF628474, 0xFF506C5E, 0x0095A69E, 0x00FAFFFC, 0x00FBFAF8, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFF9FB, 0x00F8FFFF, 0xFF7C9A90, 0xFF4F786A, 0xFF678D80, 0xFF63877B, 0xFF5F897B, 0xFF5F8F7F, 0xFF648B78, 0xFF648B78, 0xFF658C79, 0xFF658C79, 0xFF688F7C,
    0xFF658C79, 0xFF618875, 0xFF6B927F, 0xFF628776, 0xFF638C7A, 0xFF598672, 0xFF578672, 0xFF53846F, 0xFF52836E, 0xFF467561, 0xFF4F7E6A, 0xFF467B67, 0xFF407561, 0xFF447562, 0xFF608F7D, 0xFF55806F, 0xFF628879, 0xFF618577, 0xFF66887A, 0xFF608677,
    0xFF628879, 0xFF5D8374, 0xFF588171, 0xFF608979, 0xFF5F8A79, 0xFF588372, 0xFF5D8877, 0xFF648A7D, 0xFF5B8174, 0xFF658B7E, 0xFF5D8374, 0xFF3D6354, 0xFF426957, 0xFF2F5644, 0xFF365D4B, 0xFF3F6556, 0xFF2B5142, 0xFF456B5C, 0xFF2C5243, 0xFF325849,
    0xFF466C5D, 0xFF264C3D, 0xFF496F60, 0xFF3D6654, 0xFF4C7563, 0xFF598270, 0xFF5C8573, 0xFF5D8674, 0xFF608977, 0xFF618A78, 0xFF5D8674, 0xFF628476, 0xFF628B79, 0xFF64917D, 0xFF486A5A, 0xFF2B3D31, 0xFF5F625B, 0xFFAEAFA7, 0xFF8A9086, 0xFF788E81,
    0xFF8C968D, 0xFFB3B0AB, 0xFF90918B, 0xFF36483C, 0xFF325342, 0xFF5E8371, 0xFF658675, 0xFF55826D, 0xFF5B8571, 0xFF608573, 0xFF608170, 0xFF4F6E5E, 0xFF395A49, 0xFF456A58, 0xFF2B5541, 0xFF3B624F, 0xFF325745, 0xFF385A4A, 0xFF3B5749, 0xFF5B7366,
    0xFF8B9F96, 0xFF617069, 0xFF1B2821, 0xFF14141C, 0xFF181A15, 0xFF242618, 0xFF3A3C2F, 0xFF181D17, 0xFF0D1517, 0xFF0D1C17, 0xFF213529, 0xFF24382F, 0xFF101F18, 0xFF101914, 0xFF161817, 0xFF1A1819, 0xFF201B1F, 0xFF181619, 0xFF19191B, 0xFF201A1E,
    0xFF1E191D, 0xFF1A1A1C, 0xFF141817, 0xFF18211E, 0xFF0F1813, 0xFF161F1A, 0xFF0F1813, 0xFF14201C, 0xFF141D1A, 0xFF1A1E1D, 0xFF1B1B1B, 0xFF191B1A, 0xFF131C19, 0xFF172621, 0xFF31443E, 0xFF213127, 0xFF0C1814, 0xFF0E1412, 0xFF1C1F14, 0xFF4E513C,
    0xFF434832, 0xFF12180E, 0xFF101519, 0xFF262C2A, 0xFF646F69, 0xFF61726A, 0xFF3D5548, 0xFF395546, 0xFF3B5A48, 0xFF3D5A46, 0xFF425F4B, 0xFF3C5D4C, 0xFF3E5F4E, 0xFF3F604F, 0xFF3F5E4E, 0xFF405F4F, 0xFF466253, 0xFF456152, 0xFF425E4F, 0xFF466150,
    0xFF425F4D, 0xFF405F4F, 0xFF436453, 0xFF466556, 0xFF476154, 0xFF495F53, 0xFF4C6057, 0xFF446554, 0xFF446554, 0xFF436453, 0xFF426352, 0xFF406150, 0xFF3F604F, 0xFF406150, 0xFF426352, 0xFF446554, 0xFF446554, 0xFF446554, 0xFF456655, 0xFF446554,
    0xFF436453, 0xFF436453, 0xFF446554, 0xFF3E6553, 0xFF3F6654, 0xFF446B59, 0xFF274E3C, 0xFF335A48, 0xFF456C5A, 0xFF274E3C, 0xFF325947, 0xFF4D7763, 0xFF143E2A, 0xFF3E6552, 0xFF446B58, 0xFF264B39, 0xFF416654, 0xFF507261, 0xFF486A59, 0xFF456A59,
    0xFF456452, 0xFF395A49, 0xFF284839, 0xFF4E5939, 0xFF968148, 0xFFAE8F4F, 0xFFA08B54, 0xFF8D7C4E, 0xFF404823, 0xFF324532, 0xFF737872, 0xFF8A8780, 0xFFD7DAC9, 0xFFD8DBCA, 0xFFA89F96, 0xFF908977, 0xFF898270, 0xFF8D8674, 0xFF9C9583, 0xFFA9A290,
    0xFFACA593, 0xFFA09987, 0xFF8D8674, 0xFF8C8676, 0xFF93907F, 0xFF908D7E, 0xFF959386, 0xFF86867A, 0xFF8C8E83, 0xFF979A8F, 0xFF9DA097, 0xFF658474, 0xFF658675, 0xFF5E8070, 0xFF658777, 0xFF516D5F, 0x0098A9A1, 0x00FBFFFD, 0x00FFFFFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFCFE, 0x00F7FFFF, 0xFF79998E, 0xFF477163, 0xFF628B7D, 0xFF688E81, 0xFF3F6B5C, 0xFF396C5B, 0xFF406A5E, 0xFF446E62, 0xFF456F63, 0xFF436D61, 0xFF3F695D,
    0xFF3F695D, 0xFF426C60, 0xFF446E62, 0xFF5D7F6F, 0xFF3A594A, 0xFF3D5548, 0xFF53675C, 0xFF3F5549, 0xFF274335, 0xFF1E4332, 0xFF1E4936, 0xFF20382B, 0xFF243E31, 0xFF2B4739, 0xFF27473A, 0xFF315547, 0xFF3A6053, 0xFF5D8678, 0xFF628C7E, 0xFF5C8C76,
    0xFF5C8974, 0xFF588570, 0xFF618E7A, 0xFF5F8A77, 0xFF547F6E, 0xFF5D8676, 0xFF5E8777, 0xFF5C8575, 0xFF5F8878, 0xFF578070, 0xFF618A7A, 0xFF527B6B, 0xFF3D6656, 0xFF416A5A, 0xFF2E5747, 0xFF3A6051, 0xFF3E6455, 0xFF294F40, 0xFF476D5E, 0xFF305647,
    0xFF355B4C, 0xFF466C5D, 0xFF254B3C, 0xFF4F7566, 0xFF33594A, 0xFF4D7364, 0xFF688E7F, 0xFF5C8273, 0xFF63897A, 0xFF5B8172, 0xFF618778, 0xFF608B7A, 0xFF5B8474, 0xFF628B7B, 0xFF638C7C, 0xFF43695A, 0xFF1D4334, 0xFF2C5042, 0xFF577B6D, 0xFF648477,
    0xFF618174, 0xFF3F6153, 0xFF214335, 0xFF305446, 0xFF587C6E, 0xFF668A7C, 0xFF5F8375, 0xFF578070, 0xFF5A8373, 0xFF608979, 0xFF477060, 0xFF305949, 0xFF456E5E, 0xFF315A4A, 0xFF3B6454, 0xFF2E5445, 0xFF335749, 0xFF355749, 0xFF3A584C, 0xFF4E685D,
    0xFF667B72, 0xFF64756D, 0xFF2B3C34, 0xFF141611, 0xFF1E1F1A, 0xFF2A2925, 0xFF35312E, 0xFF191814, 0xFF1D1F1A, 0xFF111811, 0xFF141F17, 0xFF171918, 0xFF181A19, 0xFF191B1A, 0xFF191B1A, 0xFF181A19, 0xFF181A19, 0xFF181A19, 0xFF181A19, 0xFF181818,
    0xFF191919, 0xFF191919, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF191919, 0xFF181818, 0xFF181818, 0xFF171B1A, 0xFF181C1B, 0xFF1B1D1C, 0xFF1A1C1B, 0xFF1A1A1A, 0xFF1A1819, 0xFF1A1819, 0xFF1A1819, 0xFF17181A, 0xFF141414, 0xFF1A1615, 0xFF1C1714, 0xFF3C3932,
    0xFF39392F, 0xFF1F2315, 0xFF121909, 0xFF1A251F, 0xFF606F68, 0xFF70857C, 0xFF4C685A, 0xFF416152, 0xFF456757, 0xFF406251, 0xFF416251, 0xFF456757, 0xFF436555, 0xFF426454, 0xFF496B5B, 0xFF4D6F5F, 0xFF4C6E5E, 0xFF4D6F5F, 0xFF4C6E5E, 0xFF476C5B,
    0xFF476C5B, 0xFF466B5A, 0xFF456A59, 0xFF456A59, 0xFF446958, 0xFF436857, 0xFF436857, 0xFF446957, 0xFF446957, 0xFF446957, 0xFF446957, 0xFF446957, 0xFF446957, 0xFF446957, 0xFF446957, 0xFF456A59, 0xFF456A59, 0xFF456A59, 0xFF446958, 0xFF446958,
    0xFF446958, 0xFF446958, 0xFF436857, 0xFF486D5B, 0xFF426755, 0xFF476C5A, 0xFF4C715F, 0xFF3E6351, 0xFF2B503E, 0xFF345947, 0xFF4D7260, 0xFF1E4331, 0xFF406553, 0xFF436856, 0xFF284D3B, 0xFF355A48, 0xFF496E5C, 0xFF416654, 0xFF426755, 0xFF436356,
    0xFF405D4B, 0xFF355445, 0xFF365448, 0xFF6B7457, 0xFF99824C, 0xFFAF8D50, 0xFFA28B55, 0xFF897749, 0xFF3A421D, 0xFF30412F, 0xFF727771, 0xFF8B8680, 0xFFDADBCB, 0xFFDBDCCC, 0xFFA79D94, 0xFF8D8674, 0xFF88816F, 0xFF867F6D, 0xFF938C7A, 0xFFA39C8A,
    0xFFA7A08E, 0xFF9F9886, 0xFF938C7A, 0xFF938C79, 0xFF8F8875, 0xFF989380, 0xFF969080, 0xFF8B8879, 0xFF979387, 0xFFB5B3A6, 0xFFD7D5C9, 0xFF788A7E, 0xFF627A6C, 0xFF688879, 0xFF638877, 0xFF4E6E5F, 0x0092A79E, 0x00FAFFFC, 0x00FFFEFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FDF7F9, 0x00F7FFFF, 0xFF79998E, 0xFF4B7567, 0xFF668F81, 0xFF5F8578, 0xFF265243, 0xFF1A4D3C, 0xFF1B4539, 0xFF1E483C, 0xFF0D372B, 0xFF133D31, 0xFF234D41,
    0xFF174135, 0xFF143E32, 0xFF234D41, 0xFF607C6E, 0xFF4A6054, 0xFF556259, 0xFF929992, 0xFFA7AEA7, 0xFFA4AFA7, 0xFF9BAFA4, 0xFF9FB7AA, 0xFFA0B1A7, 0xFFA7BBB0, 0xFF82988C, 0xFF375146, 0xFF3A584C, 0xFF3B5B50, 0xFF63877B, 0xFF5F8578, 0xFF5E8975,
    0xFF638E7A, 0xFF608B77, 0xFF608B78, 0xFF608D79, 0xFF5F8B7A, 0xFF608C7B, 0xFF5D8978, 0xFF5C8575, 0xFF5E8777, 0xFF5A8373, 0xFF628B7B, 0xFF608979, 0xFF466F5F, 0xFF3D6656, 0xFF477060, 0xFF2A5041, 0xFF385E4F, 0xFF4A7061, 0xFF23493A, 0xFF4C7263,
    0xFF2E5445, 0xFF385E4F, 0xFF4B7162, 0xFF204637, 0xFF517768, 0xFF3D6354, 0xFF4D7364, 0xFF6F9586, 0xFF567C6D, 0xFF678D7E, 0xFF608677, 0xFF5E8978, 0xFF598272, 0xFF598272, 0xFF618A7A, 0xFF608677, 0xFF4A7061, 0xFF305446, 0xFF204436, 0xFF163629,
    0xFF254538, 0xFF345648, 0xFF486A5C, 0xFF608476, 0xFF6D9183, 0xFF688C7E, 0xFF608677, 0xFF5F8878, 0xFF557E6E, 0xFF517A6A, 0xFF345D4D, 0xFF456E5E, 0xFF2C5545, 0xFF406959, 0xFF2D5646, 0xFF3C6253, 0xFF3C6253, 0xFF355749, 0xFF4C6C5F, 0xFF415D51,
    0xFF5E756B, 0xFF64786F, 0xFF162A21, 0xFF181A15, 0xFF12130E, 0xFF2E2D29, 0xFF433F3C, 0xFF15110E, 0xFF161712, 0xFF181D17, 0xFF141E16, 0xFF181A17, 0xFF191B18, 0xFF191B18, 0xFF191B18, 0xFF181A17, 0xFF181A17, 0xFF191B18, 0xFF191B18, 0xFF1A1A18,
    0xFF1A1A18, 0xFF1A1A18, 0xFF1A1A18, 0xFF191917, 0xFF191917, 0xFF191917, 0xFF191917, 0xFF171916, 0xFF181A17, 0xFF1A1A18, 0xFF1A1A18, 0xFF1A1917, 0xFF1A1917, 0xFF1D1918, 0xFF1E1A19, 0xFF191917, 0xFF1D1C18, 0xFF1C1815, 0xFF292421, 0xFF5A5551,
    0xFF404038, 0xFF11140B, 0xFF161E13, 0xFF1F2C25, 0xFF607169, 0xFF6B8278, 0xFF426152, 0xFF365848, 0xFF3D5F4F, 0xFF3B5D4C, 0xFF3C5D4C, 0xFF3C5E4E, 0xFF345646, 0xFF3C5E4E, 0xFF446656, 0xFF3B5D4D, 0xFF3B5D4D, 0xFF426454, 0xFF3B5D4D, 0xFF406554,
    0xFF406554, 0xFF3F6453, 0xFF3F6453, 0xFF3E6352, 0xFF3D6251, 0xFF3D6251, 0xFF3D6251, 0xFF3E6351, 0xFF3E6351, 0xFF3E6351, 0xFF3E6351, 0xFF3E6351, 0xFF3E6351, 0xFF3E6351, 0xFF3E6351, 0xFF416655, 0xFF416655, 0xFF416655, 0xFF406554, 0xFF406554,
    0xFF406554, 0xFF406554, 0xFF406554, 0xFF3D6250, 0xFF436856, 0xFF436856, 0xFF3F6452, 0xFF406553, 0xFF426755, 0xFF385D4B, 0xFF274C3A, 0xFF395E4C, 0xFF456A58, 0xFF294E3C, 0xFF355A48, 0xFF4B705E, 0xFF3A5F4D, 0xFF3B604E, 0xFF416654, 0xFF3F6153,
    0xFF3F5C4A, 0xFF375647, 0xFF345246, 0xFF656E51, 0xFF98814B, 0xFFB18F52, 0xFFA28B55, 0xFF8D7B4D, 0xFF3C441F, 0xFF30412F, 0xFF717670, 0xFF8B8680, 0xFFD9DACA, 0xFFDADBCB, 0xFFA89E95, 0xFF9E9785, 0xFF9C9583, 0xFF9B9482, 0xFFA09987, 0xFFA59E8C,
    0xFFA7A08E, 0xFFA49D8B, 0xFFA09987, 0xFF9A9380, 0xFF948D7A, 0xFF9A9582, 0xFF958F7F, 0xFF888576, 0xFF949084, 0xFFB6B4A7, 0xFFDCDACE, 0xFF93A599, 0xFF657D6F, 0xFF5F7F70, 0xFF608574, 0xFF4F6F60, 0x0093A89F, 0x00F7FDF9, 0x00FFFCFB, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFCFE, 0x00F7FFFF, 0xFF77978C, 0xFF4A7466, 0xFF6A9385, 0xFF5E8477, 0xFF214D3E, 0xFF1B4E3D, 0xFF4D776B, 0xFF416B5F, 0xFF254F43, 0xFF2D574B, 0xFF3C665A,
    0xFF244E42, 0xFF1C463A, 0xFF2E584C, 0xFF61776B, 0xFF57675D, 0xFF696E68, 0xFFC6C2BF, 0xFFF3EBE9, 0xFFF7F2EF, 0xFFEAE9E5, 0xFFEDEFEA, 0xFFE9F0E9, 0xFFF1F8F1, 0xFFABB6AE, 0xFF3D4C45, 0xFF495D54, 0xFF425951, 0xFF5C776E, 0xFF516F65, 0xFF476656,
    0xFF3D5C4C, 0xFF375748, 0xFF385D4C, 0xFF3F6556, 0xFF376251, 0xFF335F4E, 0xFF417060, 0xFF628B7B, 0xFF5E8777, 0xFF5B8474, 0xFF588171, 0xFF648D7D, 0xFF618A7A, 0xFF446D5D, 0xFF3B6454, 0xFF486E5F, 0xFF294F40, 0xFF33594A, 0xFF456B5C, 0xFF1E4435,
    0xFF517768, 0xFF2B5142, 0xFF345A4B, 0xFF496F60, 0xFF204637, 0xFF4B7162, 0xFF3E6455, 0xFF4A7061, 0xFF688E7F, 0xFF5F8576, 0xFF577D6E, 0xFF598473, 0xFF608979, 0xFF628B7B, 0xFF618A7A, 0xFF668C7D, 0xFF6B9182, 0xFF668A7C, 0xFF5C8072, 0xFF618375,
    0xFF648678, 0xFF688A7C, 0xFF6D9183, 0xFF6E9284, 0xFF64887A, 0xFF5A8071, 0xFF5C8273, 0xFF648D7D, 0xFF527B6B, 0xFF3E6757, 0xFF497262, 0xFF2F5848, 0xFF507969, 0xFF2A5343, 0xFF3E6757, 0xFF2F5848, 0xFF355B4C, 0xFF426658, 0xFF305043, 0xFF4C6A5E,
    0xFF546E63, 0xFF41584E, 0xFF172E24, 0xFF161B15, 0xFF191B16, 0xFF1F1E1A, 0xFF231F1C, 0xFF130F0C, 0xFF23221E, 0xFF1A1B16, 0xFF10150F, 0xFF1A1914, 0xFF1A1914, 0xFF1A1914, 0xFF1A1914, 0xFF1A1914, 0xFF1A1914, 0xFF1A1914, 0xFF1A1914, 0xFF181712,
    0xFF171611, 0xFF171611, 0xFF161510, 0xFF161510, 0xFF161510, 0xFF161510, 0xFF15140F, 0xFF171611, 0xFF181712, 0xFF191813, 0xFF181712, 0xFF171611, 0xFF171611, 0xFF1A1712, 0xFF1B1813, 0xFF12120A, 0xFF1C1912, 0xFF1D1814, 0xFF15100C, 0xFF241F1C,
    0xFF21201C, 0xFF141915, 0xFF171D19, 0xFF1B2C24, 0xFF54685F, 0xFF607A6F, 0xFF406051, 0xFF345948, 0xFF395E4D, 0xFF375948, 0xFF365847, 0xFF355A49, 0xFF406554, 0xFF3E6352, 0xFF365B4A, 0xFF406554, 0xFF3C6150, 0xFF335847, 0xFF4A6F5E, 0xFF436857,
    0xFF426756, 0xFF426756, 0xFF426756, 0xFF416655, 0xFF406554, 0xFF406554, 0xFF406554, 0xFF416654, 0xFF416654, 0xFF416654, 0xFF416654, 0xFF416654, 0xFF416654, 0xFF416654, 0xFF416654, 0xFF406554, 0xFF406554, 0xFF406554, 0xFF3F6453, 0xFF3F6453,
    0xFF3F6453, 0xFF3F6453, 0xFF3F6453, 0xFF3F6452, 0xFF3F6452, 0xFF3E6351, 0xFF3E6351, 0xFF416654, 0xFF406553, 0xFF375C4A, 0xFF2C513F, 0xFF426755, 0xFF244937, 0xFF395E4C, 0xFF406553, 0xFF3E6351, 0xFF567B69, 0xFF5C816F, 0xFF608573, 0xFF5C7E70,
    0xFF577462, 0xFF486859, 0xFF345447, 0xFF5B6447, 0xFF927B45, 0xFFAE8E51, 0xFFA08953, 0xFF907E50, 0xFF3E4621, 0xFF2F402E, 0xFF70756F, 0xFF8B8680, 0xFFD8D9C9, 0xFFD9DACA, 0xFFA99F96, 0xFFA49D8B, 0xFFA49D8B, 0xFFA39C8A, 0xFF9F9886, 0xFF9E9785,
    0xFFA19A88, 0xFFA59E8C, 0xFFA9A290, 0xFFA29B88, 0xFF99927F, 0xFF9D9885, 0xFF958F7F, 0xFF858273, 0xFF908C80, 0xFFB5B3A6, 0xFFDFDDD1, 0xFFD5E7DB, 0xFF829A8C, 0xFF668677, 0xFF628776, 0xFF4F6F60, 0x0094A9A0, 0x00FAFFFC, 0x00FFFEFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFF, 0x00F7FFFF, 0xFF75958A, 0xFF487264, 0xFF6C9587, 0xFF608679, 0xFF285445, 0xFF2C5F4E, 0xFF507A6E, 0xFF3E685C, 0xFF3E685C, 0xFF467064, 0xFF406A5E,
    0xFF265044, 0xFF184236, 0xFF2B5549, 0xFF5F7B6D, 0xFF5D7166, 0xFF777E77, 0xFFD5D1CE, 0xFFF3E9E8, 0xFFEFE3E3, 0xFFDDD5D3, 0xFFDAD5D2, 0xFFECE8E5, 0xFFF0EFEB, 0xFFB4B6B1, 0xFF595F5B, 0xFF58655E, 0xFF3D4E48, 0xFF334841, 0xFF344B43, 0xFF525D55,
    0xFF414E45, 0xFF35453B, 0xFF2E433A, 0xFF365045, 0xFF2E4C42, 0xFF214237, 0xFF32564A, 0xFF598473, 0xFF588372, 0xFF608B7A, 0xFF5A8574, 0xFF578271, 0xFF628D7C, 0xFF5C8776, 0xFF4B7665, 0xFF3C6253, 0xFF456B5C, 0xFF23493A, 0xFF3A6051, 0xFF456B5C,
    0xFF1F4536, 0xFF4F7566, 0xFF284E3F, 0xFF385E4F, 0xFF426859, 0xFF244A3B, 0xFF4B7162, 0xFF355B4C, 0xFF567C6D, 0xFF5F8576, 0xFF668C7D, 0xFF5D8877, 0xFF5F8878, 0xFF5D8676, 0xFF598272, 0xFF5B8172, 0xFF608677, 0xFF668A7C, 0xFF688C7E, 0xFF709284,
    0xFF719385, 0xFF6A8E80, 0xFF638779, 0xFF608476, 0xFF618778, 0xFF648A7B, 0xFF678D7E, 0xFF50796B, 0xFF416A5C, 0xFF40695B, 0xFF335C4E, 0xFF497264, 0xFF2D5648, 0xFF436C5E, 0xFF3A6355, 0xFF355E4E, 0xFF426859, 0xFF2A5041, 0xFF486A5C, 0xFF39594C,
    0xFF506E62, 0xFF607C70, 0xFF3C584C, 0xFF0E1911, 0xFF161D16, 0xFF141611, 0xFF161511, 0xFF1A1613, 0xFF302C29, 0xFF2B2A26, 0xFF31322D, 0xFF2F2F27, 0xFF2F2F27, 0xFF2F2F27, 0xFF303028, 0xFF313129, 0xFF303028, 0xFF2F2F27, 0xFF2E2E26, 0xFF32322A,
    0xFF33332B, 0xFF33332B, 0xFF33332B, 0xFF33332B, 0xFF313129, 0xFF303028, 0xFF303028, 0xFF35322B, 0xFF35322B, 0xFF33332B, 0xFF32322A, 0xFF303028, 0xFF303028, 0xFF313129, 0xFF31322A, 0xFF2F2F23, 0xFF343128, 0xFF2F2C25, 0xFF1E1915, 0xFF181715,
    0xFF202221, 0xFF1A2322, 0xFF0D1718, 0xFF2E433A, 0xFF536D62, 0xFF5E7C70, 0xFF4F7463, 0xFF4F7664, 0xFF557C6A, 0xFF547967, 0xFF577968, 0xFF517567, 0xFF5C8072, 0xFF4B6F61, 0xFF5B7F71, 0xFF45695B, 0xFF2D5143, 0xFF4D7163, 0xFF395D4F, 0xFF466B5A,
    0xFF466B5A, 0xFF466B5A, 0xFF456A59, 0xFF456A59, 0xFF456A59, 0xFF446958, 0xFF446958, 0xFF456A58, 0xFF456A58, 0xFF456A58, 0xFF456A58, 0xFF456A58, 0xFF456A58, 0xFF456A58, 0xFF456A58, 0xFF476C5B, 0xFF476C5B, 0xFF466B5A, 0xFF466B5A, 0xFF466B5A,
    0xFF466B5A, 0xFF456A59, 0xFF456A59, 0xFF496E5C, 0xFF436856, 0xFF436856, 0xFF496E5C, 0xFF476C5A, 0xFF406553, 0xFF416654, 0xFF4A6F5D, 0xFF193E2C, 0xFF385D4B, 0xFF3B604E, 0xFF446957, 0xFF5A7F6D, 0xFF5D8270, 0xFF5B806E, 0xFF587D6B, 0xFF5C7E70,
    0xFF5B7A68, 0xFF557566, 0xFF3E5E51, 0xFF5F6A4C, 0xFF98834C, 0xFFB19154, 0xFF9E8952, 0xFF8E7C4E, 0xFF3C441F, 0xFF2C3D2B, 0xFF6E736D, 0xFF8B8680, 0xFFD8D9C9, 0xFFD8D9C9, 0xFFAAA097, 0xFFA19A88, 0xFFA19A88, 0xFFA49D8B, 0xFFA19A88, 0xFFA29B89,
    0xFFA59E8C, 0xFFA19A88, 0xFFA09987, 0xFFA29B88, 0xFF99927F, 0xFF9D9885, 0xFF969080, 0xFF848172, 0xFF8C887C, 0xFFB1AFA2, 0xFFDFDDD1, 0xFFD6E8DC, 0xFF7A9284, 0xFF638374, 0xFF648978, 0xFF517162, 0x0098ADA4, 0x00FBFFFD, 0x00FFFEFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFBFD, 0x00F7FFFF, 0xFF77978C, 0xFF4B7567, 0xFF6C9587, 0xFF5C8275, 0xFF245041, 0xFF2B5E4D, 0xFF345E52, 0xFF2C564A, 0xFF467064, 0xFF4D776B, 0xFF4B7569,
    0xFF3A6458, 0xFF1A4438, 0xFF2F594D, 0xFF638877, 0xFF627E70, 0xFF86968C, 0xFFD4D6D1, 0xFFE2DEDB, 0xFFD9D4D1, 0xFFD1CDCA, 0xFFC9C8C4, 0xFFD8CECD, 0xFFE7DFDD, 0xFFC6C2BF, 0xFF919390, 0xFF7F8883, 0xFF5F6E69, 0xFF4A5F58, 0xFF677E76, 0xFF96928F,
    0xFF7B7A76, 0xFF595B58, 0xFF4D534F, 0xFF707C78, 0xFF859690, 0xFF5E736C, 0xFF3F5650, 0xFF638E7D, 0xFF5E8978, 0xFF5C8776, 0xFF608B7A, 0xFF598473, 0xFF598473, 0xFF65907F, 0xFF638E7D, 0xFF4F7566, 0xFF3B6152, 0xFF4D7364, 0xFF274D3E, 0xFF416758,
    0xFF43695A, 0xFF264C3D, 0xFF486E5F, 0xFF2A5041, 0xFF3F6556, 0xFF406657, 0xFF23493A, 0xFF527869, 0xFF3C6253, 0xFF5B8172, 0xFF587E6F, 0xFF5D8877, 0xFF5E8777, 0xFF5E8777, 0xFF5F8878, 0xFF628879, 0xFF608677, 0xFF618577, 0xFF618577, 0xFF608476,
    0xFF64887A, 0xFF65897B, 0xFF628678, 0xFF5F8576, 0xFF618778, 0xFF5C8575, 0xFF557E6E, 0xFF3D6658, 0xFF436C5E, 0xFF355E50, 0xFF446D5F, 0xFF3B6456, 0xFF3C6557, 0xFF3D6658, 0xFF3D6658, 0xFF446D5D, 0xFF2A5343, 0xFF476D5E, 0xFF3D6354, 0xFF517567,
    0xFF5E8072, 0xFF688A7C, 0xFF5F7F72, 0xFF41554A, 0xFF122218, 0xFF0B150D, 0xFF20221D, 0xFF191814, 0xFF21201C, 0xFF22211D, 0xFF1E1F1A, 0xFF1C1D15, 0xFF1D1E16, 0xFF1E1F17, 0xFF202119, 0xFF21221A, 0xFF202119, 0xFF1D1E16, 0xFF1A1B13, 0xFF202119,
    0xFF21221A, 0xFF23241C, 0xFF24251D, 0xFF24251D, 0xFF22231B, 0xFF202119, 0xFF1E1F17, 0xFF1E1E16, 0xFF1E1E16, 0xFF1E1E16, 0xFF1E1F17, 0xFF1D2017, 0xFF1E2118, 0xFF1C2218, 0xFF1C2218, 0xFF1B1D12, 0xFF25271C, 0xFF1B1B13, 0xFF1A1B16, 0xFF1F211E,
    0xFF0D1615, 0xFF0D1B1B, 0xFF2D403E, 0xFF617B70, 0xFF68867A, 0xFF66887A, 0xFF5E8573, 0xFF5E8775, 0xFF5F8674, 0xFF5F8472, 0xFF678978, 0xFF608677, 0xFF5E8475, 0xFF628879, 0xFF5A8071, 0xFF466C5D, 0xFF385E4F, 0xFF33594A, 0xFF345A4B, 0xFF3F6453,
    0xFF3F6453, 0xFF3F6453, 0xFF3F6453, 0xFF3F6453, 0xFF3E6352, 0xFF3E6352, 0xFF3E6352, 0xFF3F6452, 0xFF3F6452, 0xFF3F6452, 0xFF3F6452, 0xFF3F6452, 0xFF3F6452, 0xFF3F6452, 0xFF3F6452, 0xFF406554, 0xFF406554, 0xFF406554, 0xFF406554, 0xFF3F6453,
    0xFF3F6453, 0xFF3F6453, 0xFF3F6453, 0xFF375C4A, 0xFF3B604E, 0xFF3B604E, 0xFF385D4B, 0xFF3B604E, 0xFF406553, 0xFF3D6250, 0xFF335846, 0xFF3A5F4D, 0xFF486D5B, 0xFF456A58, 0xFF527765, 0xFF648977, 0xFF5F8472, 0xFF5B806E, 0xFF5C816F, 0xFF527668,
    0xFF547361, 0xFF4E7060, 0xFF335547, 0xFF596446, 0xFF98834C, 0xFFAF9153, 0xFF9F8A53, 0xFF897749, 0xFF39411C, 0xFF293A28, 0xFF6D726C, 0xFF8D8882, 0xFFD9DACA, 0xFFD6D7C7, 0xFFAAA097, 0xFF9B9482, 0xFF9A9381, 0xFFA49D8B, 0xFFA8A18F, 0xFFB0A997,
    0xFFB4AD9B, 0xFF9F9886, 0xFF928B79, 0xFF99927F, 0xFF918A77, 0xFF9A9582, 0xFF999383, 0xFF888576, 0xFF8D897D, 0xFFB1AFA2, 0xFFE0DED2, 0xFFBACCC0, 0xFF677F71, 0xFF5E7E6F, 0xFF618675, 0xFF4B6B5C, 0x0097ACA3, 0x00FBFFFD, 0x00FFFEFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFF9FB, 0x00F7FFFF, 0xFF77978C, 0xFF4D7769, 0xFF6B9486, 0xFF5D8376, 0xFF265243, 0xFF285B4A, 0xFF4C766A, 0xFF3F695D, 0xFF416B5F, 0xFF3E685C, 0xFF5C867A,
    0xFF568074, 0xFF214B3F, 0xFF2F594D, 0xFF557C6A, 0xFF577667, 0xFF91A298, 0xFFCCD3CC, 0xFFE1E2DD, 0xFFE3E2DE, 0xFFEBEDE8, 0xFFE5EAE4, 0xFFE4DAD9, 0xFFEDE5E3, 0xFFBFBEBA, 0xFF909591, 0xFF7D8A83, 0xFF50635D, 0xFF405A51, 0xFF577269, 0xFFA9ABA8,
    0xFF888D89, 0xFF606662, 0xFF5A6360, 0xFF828E8A, 0xFF99A8A3, 0xFF798986, 0xFF536662, 0xFF568271, 0xFF618D7C, 0xFF588473, 0xFF5A8675, 0xFF608C7B, 0xFF5A8675, 0xFF588473, 0xFF558170, 0xFF678D7E, 0xFF577D6E, 0xFF355B4C, 0xFF496F60, 0xFF274D3E,
    0xFF466C5D, 0xFF33594A, 0xFF345A4B, 0xFF43695A, 0xFF2A5041, 0xFF416758, 0xFF3B6152, 0xFF2D5344, 0xFF4F7566, 0xFF345A4B, 0xFF43695A, 0xFF3D6857, 0xFF446D5D, 0xFF446D5D, 0xFF3E6757, 0xFF3C6253, 0xFF3F6556, 0xFF44685A, 0xFF466A5C, 0xFF436759,
    0xFF3E6254, 0xFF3F6355, 0xFF43695A, 0xFF43695A, 0xFF406959, 0xFF406959, 0xFF3D6656, 0xFF41695E, 0xFF386055, 0xFF466E63, 0xFF3D655A, 0xFF3D655A, 0xFF497166, 0xFF375F54, 0xFF3D655A, 0xFF305949, 0xFF466F5F, 0xFF315A4A, 0xFF547D6D, 0xFF608979,
    0xFF63897A, 0xFF597F70, 0xFF587E6F, 0xFF638273, 0xFF2F493C, 0xFF102117, 0xFF101B13, 0xFF1B201A, 0xFF2B2D28, 0xFF23241F, 0xFF181A15, 0xFF1F241D, 0xFF1E231C, 0xFF1F241D, 0xFF21261F, 0xFF232821, 0xFF222720, 0xFF1F241D, 0xFF1B2019, 0xFF1A2119,
    0xFF1C231B, 0xFF1E251D, 0xFF1F261E, 0xFF1F261E, 0xFF1E251D, 0xFF1C231B, 0xFF1B221A, 0xFF1C1D17, 0xFF1B1E17, 0xFF1B1E17, 0xFF1D221B, 0xFF20271F, 0xFF202C22, 0xFF1F2B21, 0xFF1C291F, 0xFF192018, 0xFF1E231D, 0xFF191E18, 0xFF1E2420, 0xFF121D17,
    0xFF11221C, 0xFF374E46, 0xFF6B867D, 0xFF658578, 0xFF618375, 0xFF5B8172, 0xFF5B8673, 0xFF5E8976, 0xFF5B8472, 0xFF5C8370, 0xFF648675, 0xFF5E8477, 0xFF658B7E, 0xFF5A8073, 0xFF395F52, 0xFF456B5E, 0xFF3D6356, 0xFF1C4235, 0xFF466C5F, 0xFF3F6453,
    0xFF3F6453, 0xFF3F6453, 0xFF3F6453, 0xFF3F6453, 0xFF3F6453, 0xFF3F6453, 0xFF3F6453, 0xFF3F6452, 0xFF3F6452, 0xFF3F6452, 0xFF3F6452, 0xFF3F6452, 0xFF3F6452, 0xFF3F6452, 0xFF3F6452, 0xFF3E6352, 0xFF3E6352, 0xFF3D6251, 0xFF3D6251, 0xFF3D6251,
    0xFF3D6251, 0xFF3C6150, 0xFF3C6150, 0xFF3D6250, 0xFF446957, 0xFF446957, 0xFF3D6250, 0xFF3F6452, 0xFF466B59, 0xFF426755, 0xFF365B49, 0xFF426755, 0xFF315644, 0xFF5A7F6D, 0xFF648977, 0xFF547967, 0xFF5F8472, 0xFF5B806E, 0xFF527765, 0xFF5C8072,
    0xFF597A67, 0xFF496B5B, 0xFF26483A, 0xFF4E5B3D, 0xFF927F47, 0xFFA98B4D, 0xFFA08D55, 0xFF887648, 0xFF373F1A, 0xFF273826, 0xFF6C716B, 0xFF8F8A84, 0xFFD9DACA, 0xFFD5D6C6, 0xFFABA198, 0xFF938C7A, 0xFF8D8674, 0xFF958E7C, 0xFF999280, 0xFFA9A290,
    0xFFB6AF9D, 0xFFA29B89, 0xFF958E7C, 0xFF948D7A, 0xFF8C8572, 0xFF989380, 0xFF9C9686, 0xFF8D8A7B, 0xFF908C80, 0xFFB3B1A4, 0xFFE3E1D5, 0xFFB7C9BD, 0xFF698173, 0xFF648475, 0xFF628776, 0xFF49695A, 0x0094A9A0, 0x00FAFFFC, 0x00FFFEFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFF, 0x00F5FFFD, 0xFF75958A, 0xFF4B7567, 0xFF6A9385, 0xFF61877A, 0xFF2A5647, 0xFF235645, 0xFF4F796D, 0xFF436D61, 0xFF2C564A, 0xFF265044, 0xFF467064,
    0xFF426C60, 0xFF1E483C, 0xFF2A5448, 0xFF617D6F, 0xFF6F8579, 0xFFB7C2BA, 0xFFD2D3CE, 0xFFE7E3E0, 0xFFDFDBD8, 0xFFE3E4DF, 0xFFDEE0DB, 0xFFE7E2DF, 0xFFECE8E5, 0xFFACAEA9, 0xFF7D8882, 0xFF92A39B, 0xFF466057, 0xFF4D6D62, 0xFF4A6B60, 0xFF4D675C,
    0xFF496358, 0xFF415B50, 0xFF445F56, 0xFF4D685F, 0xFF506B64, 0xFF516F67, 0xFF506E66, 0xFF305C4B, 0xFF4C7867, 0xFF5E8A79, 0xFF598574, 0xFF598574, 0xFF5B8776, 0xFF54806F, 0xFF578372, 0xFF5B8172, 0xFF658B7C, 0xFF4D7364, 0xFF385E4F, 0xFF4E7465,
    0xFF1A4031, 0xFF4A7061, 0xFF305647, 0xFF305647, 0xFF466C5D, 0xFF274D3E, 0xFF426859, 0xFF3C6253, 0xFF284E3F, 0xFF426859, 0xFF456B5C, 0xFF3C6756, 0xFF3D6656, 0xFF3C6555, 0xFF3B6454, 0xFF426859, 0xFF486E5F, 0xFF496D5F, 0xFF44685A, 0xFF4B6F61,
    0xFF426658, 0xFF426859, 0xFF486E5F, 0xFF446D5D, 0xFF426B5B, 0xFF436E5D, 0xFF436E5D, 0xFF3C6459, 0xFF3D655A, 0xFF396156, 0xFF3A6257, 0xFF40685D, 0xFF365E53, 0xFF3E665B, 0xFF355D52, 0xFF45705F, 0xFF376251, 0xFF588372, 0xFF578271, 0xFF598473,
    0xFF5C8776, 0xFF608B7A, 0xFF568170, 0xFF5E8775, 0xFF5E8372, 0xFF405A4D, 0xFF112218, 0xFF09140C, 0xFF171E17, 0xFF121711, 0xFF121711, 0xFF121D17, 0xFF101B15, 0xFF0F1A14, 0xFF101B15, 0xFF121D17, 0xFF131E18, 0xFF111C16, 0xFF0E1913, 0xFF0E1B14,
    0xFF0F1C15, 0xFF0F1C15, 0xFF101D16, 0xFF111E17, 0xFF111E17, 0xFF111E17, 0xFF111E17, 0xFF141915, 0xFF111713, 0xFF0F1813, 0xFF131E18, 0xFF18251E, 0xFF182921, 0xFF12261D, 0xFF0D2118, 0xFF162220, 0xFF121C1B, 0xFF0C1713, 0xFF14201C, 0xFF10241B,
    0xFF354F42, 0xFF5C7E6E, 0xFF5F8674, 0xFF608476, 0xFF5D8374, 0xFF5C8776, 0xFF5E8B77, 0xFF5C8975, 0xFF598471, 0xFF5A816E, 0xFF5C816F, 0xFF638C7E, 0xFF5D8678, 0xFF3B6456, 0xFF3D6658, 0xFF2E5749, 0xFF234C3E, 0xFF446D5F, 0xFF396254, 0xFF507564,
    0xFF507564, 0xFF507564, 0xFF507564, 0xFF507564, 0xFF507564, 0xFF507564, 0xFF507564, 0xFF517664, 0xFF517664, 0xFF517664, 0xFF517664, 0xFF517664, 0xFF517664, 0xFF517664, 0xFF517664, 0xFF537867, 0xFF537867, 0xFF527766, 0xFF527766, 0xFF527766,
    0xFF527766, 0xFF517665, 0xFF517665, 0xFF507563, 0xFF4F7462, 0xFF4F7462, 0xFF4E7361, 0xFF4B705E, 0xFF496E5C, 0xFF4B705E, 0xFF507563, 0xFF4A6F5D, 0xFF668B79, 0xFF597E6C, 0xFF597E6C, 0xFF5B806E, 0xFF537866, 0xFF618674, 0xFF618674, 0xFF567C6D,
    0xFF587966, 0xFF4B6D5D, 0xFF2B4D3F, 0xFF5C694B, 0xFF9B8850, 0xFFA7894B, 0xFF9F8C54, 0xFF8C7A4C, 0xFF3A421D, 0xFF273826, 0xFF6B706A, 0xFF908B85, 0xFFD9DACA, 0xFFD5D6C6, 0xFFADA39A, 0xFF999280, 0xFF908977, 0xFF948D7B, 0xFF918A78, 0xFF9F9886,
    0xFFB3AC9A, 0xFFA9A290, 0xFFA49D8B, 0xFF9C9582, 0xFF928B78, 0xFF9C9784, 0xFFA19B8B, 0xFF918E7F, 0xFF918D81, 0xFFB2B0A3, 0xFFE2E0D4, 0xFFAEC0B4, 0xFF627A6C, 0xFF628273, 0xFF658A79, 0xFF507061, 0x0097ACA3, 0x00F5FBF7, 0x00FFFDFC, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFF, 0x04F3FFFB, 0xFF749489, 0xFF4C7668, 0xFF6A9385, 0xFF61877A, 0xFF234F40, 0xFF124534, 0xFF143E32, 0xFF1D473B, 0xFF153F33, 0xFF184236, 0xFF1B4539,
    0xFF113B2F, 0xFF1A4438, 0xFF2E584C, 0xFF64756B, 0xFF848F87, 0xFFD9DAD5, 0xFFDFD7D5, 0xFFF3E7E7, 0xFFDED4D3, 0xFFD9D5D2, 0xFFD6D5D1, 0xFFDCD8D5, 0xFFE9EAE5, 0xFFA9B0A9, 0xFF85928B, 0xFFB9D0C6, 0xFF4B695F, 0xFF6B8F83, 0xFF598274, 0xFF5B8776,
    0xFF608C7B, 0xFF5A8677, 0xFF5D8779, 0xFF5D877B, 0xFF578175, 0xFF4D756A, 0xFF325A51, 0xFF3E6A59, 0xFF34604F, 0xFF527E6D, 0xFF5A8675, 0xFF588473, 0xFF5F8B7A, 0xFF54806F, 0xFF5A8675, 0xFF608677, 0xFF5A8071, 0xFF6B9182, 0xFF4E7465, 0xFF375D4E,
    0xFF4D7364, 0xFF214738, 0xFF416758, 0xFF345A4B, 0xFF33594A, 0xFF3C6253, 0xFF2B5142, 0xFF3D6354, 0xFF496F60, 0xFF3F6556, 0xFF416758, 0xFF3F6A59, 0xFF3F6858, 0xFF416A5A, 0xFF436C5C, 0xFF426859, 0xFF3D6354, 0xFF416557, 0xFF476B5D, 0xFF45695B,
    0xFF416758, 0xFF43695A, 0xFF446A5B, 0xFF3D6656, 0xFF406959, 0xFF426D5C, 0xFF3F6A59, 0xFF436B60, 0xFF375F54, 0xFF446C61, 0xFF3D655A, 0xFF386055, 0xFF426A5F, 0xFF335B50, 0xFF456D62, 0xFF376251, 0xFF55806F, 0xFF5E8978, 0xFF5F8A79, 0xFF5B8675,
    0xFF588473, 0xFF568271, 0xFF5F8B7A, 0xFF558470, 0xFF5E8775, 0xFF648475, 0xFF445A4E, 0xFF2B382F, 0xFF3C463E, 0xFF4A514A, 0xFF404740, 0xFF424E4A, 0xFF3F4B47, 0xFF3B4743, 0xFF3C4844, 0xFF3E4A46, 0xFF404C48, 0xFF404C48, 0xFF3E4A46, 0xFF394A44,
    0xFF384943, 0xFF384943, 0xFF384943, 0xFF394A44, 0xFF3A4B45, 0xFF3C4D47, 0xFF3E4F49, 0xFF3F4543, 0xFF39423F, 0xFF37423E, 0xFF384742, 0xFF3E4F49, 0xFF3C514A, 0xFF344B43, 0xFF2B453C, 0xFF354344, 0xFF435152, 0xFF303E3E, 0xFF2F403A, 0xFF3C5349,
    0xFF587968, 0xFF618873, 0xFF5A866F, 0xFF5C8273, 0xFF5C8575, 0xFF5D8978, 0xFF598874, 0xFF578470, 0xFF5A8572, 0xFF628976, 0xFF648977, 0xFF5B8476, 0xFF325B4D, 0xFF446D5F, 0xFF30594B, 0xFF264F41, 0xFF416A5C, 0xFF386153, 0xFF487163, 0xFF608574,
    0xFF608574, 0xFF608574, 0xFF618675, 0xFF618675, 0xFF618675, 0xFF618675, 0xFF618675, 0xFF618674, 0xFF618674, 0xFF618674, 0xFF618674, 0xFF618674, 0xFF618674, 0xFF618674, 0xFF618674, 0xFF618675, 0xFF618675, 0xFF608574, 0xFF608574, 0xFF608574,
    0xFF608574, 0xFF5F8473, 0xFF5F8473, 0xFF608573, 0xFF5F8472, 0xFF5F8472, 0xFF608573, 0xFF628775, 0xFF628775, 0xFF618674, 0xFF618674, 0xFF5F8472, 0xFF5D8270, 0xFF5D8270, 0xFF577C6A, 0xFF5D8270, 0xFF5E8371, 0xFF547967, 0xFF5B806E, 0xFF597F70,
    0xFF5B7C69, 0xFF486D5C, 0xFF274B3D, 0xFF5E6B4D, 0xFF9C8951, 0xFFA38748, 0xFF9E8B53, 0xFF917F51, 0xFF3D4520, 0xFF283927, 0xFF6B706A, 0xFF908B85, 0xFFD9DACA, 0xFFD6D7C7, 0xFFAFA59C, 0xFFACA593, 0xFFA7A08E, 0xFFAEA795, 0xFFA49D8B, 0xFFAAA391,
    0xFFB9B2A0, 0xFFAFA896, 0xFFAEA795, 0xFFAAA390, 0xFF9B9481, 0xFFA29D8A, 0xFFA49E8E, 0xFF928F80, 0xFF908C80, 0xFFAFADA0, 0xFFE0DED2, 0xFFBBCDC1, 0xFF667E70, 0xFF5D7D6E, 0xFF5F8473, 0xFF4F6F60, 0x0098ADA4, 0x00F6FCF8, 0x00FFFEFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFAFC, 0x04F3FFFB, 0xFF749489, 0xFF507A6C, 0xFF679082, 0xFF658B7E, 0xFF477364, 0xFF3C6F5E, 0xFF3E6958, 0xFF3F6A59, 0xFF416C5B, 0xFF3A6554, 0xFF3B6655,
    0xFF3F6A59, 0xFF3C6756, 0xFF45705F, 0xFF588372, 0xFF426859, 0xFF739386, 0xFF9DB9AD, 0xFF7A9187, 0xFF5F796E, 0xFF728C81, 0xFF7B978B, 0xFF5D7E73, 0xFF5D8175, 0xFF597D73, 0xFF4F756A, 0xFF4F776C, 0xFF497369, 0xFF59847A, 0xFF5B897E, 0xFF628879,
    0xFF608979, 0xFF5C8575, 0xFF618A7A, 0xFF5F8A79, 0xFF5E8978, 0xFF5E8A79, 0xFF4B7766, 0xFF2D5948, 0xFF3F6B5A, 0xFF34604F, 0xFF517D6C, 0xFF5E8A79, 0xFF5A8675, 0xFF5D8978, 0xFF5A8675, 0xFF558472, 0xFF578674, 0xFF5C8B79, 0xFF5C8877, 0xFF467261,
    0xFF3D6857, 0xFF3B6655, 0xFF244F3E, 0xFF3D6656, 0xFF355E4E, 0xFF365F4F, 0xFF3A6353, 0xFF365F4F, 0xFF386151, 0xFF3C6555, 0xFF3A6353, 0xFF3B6152, 0xFF3C6253, 0xFF3C6253, 0xFF3C6253, 0xFF3C6253, 0xFF3D6354, 0xFF3D6354, 0xFF3D6354, 0xFF3D6354,
    0xFF3E6455, 0xFF3E6455, 0xFF3F6556, 0xFF3F6556, 0xFF3E6455, 0xFF3E6455, 0xFF3D6354, 0xFF396252, 0xFF3E6757, 0xFF416A5A, 0xFF396252, 0xFF3A6353, 0xFF3C6555, 0xFF416A5A, 0xFF3E6757, 0xFF598574, 0xFF588473, 0xFF588473, 0xFF588473, 0xFF588473,
    0xFF598574, 0xFF598574, 0xFF5A8675, 0xFF578372, 0xFF578372, 0xFF5A8574, 0xFF618778, 0xFF4E6C60, 0xFF778C83, 0xFF7F8A84, 0xFF808682, 0xFF99A1A3, 0xFF949C9E, 0xFF99A1A3, 0xFF959D9F, 0xFF9BA3A5, 0xFF939B9D, 0xFF929A9C, 0xFF90989A, 0xFF8B9499,
    0xFF97A0A5, 0xFF8E979C, 0xFF848D92, 0xFFA2ABB0, 0xFF929BA0, 0xFF8D969B, 0xFF9BA4A9, 0xFF949C9E, 0xFF899193, 0xFF979FA1, 0xFF8B9395, 0xFF90989A, 0xFFA5ADAF, 0xFF8D9597, 0xFF80888A, 0xFF9E98A2, 0xFF9EA3A9, 0xFF697D7C, 0xFF5E8278, 0xFF598576,
    0xFF608D79, 0xFF58826E, 0xFF5F8570, 0xFF5D8875, 0xFF588370, 0xFF5E8976, 0xFF5C8776, 0xFF5E8978, 0xFF618B7D, 0xFF5A8476, 0xFF5E887A, 0xFF375D4E, 0xFF3E6455, 0xFF345A4B, 0xFF214836, 0xFF3D6452, 0xFF3F6654, 0xFF446B58, 0xFF6B927F, 0xFF608574,
    0xFF5F8473, 0xFF5D8472, 0xFF5D8472, 0xFF5B8472, 0xFF5B8472, 0xFF5B8472, 0xFF5A8572, 0xFF608775, 0xFF5F8674, 0xFF5E8573, 0xFF5D8472, 0xFF5D8472, 0xFF5D8472, 0xFF5E8573, 0xFF5F8674, 0xFF5F8674, 0xFF5F8674, 0xFF5F8674, 0xFF5E8573, 0xFF5D8472,
    0xFF5C8371, 0xFF5B8270, 0xFF5A816F, 0xFF5F8673, 0xFF5F8673, 0xFF5E8572, 0xFF5E8572, 0xFF5D8471, 0xFF5C8370, 0xFF5C8370, 0xFF5B826F, 0xFF5C816F, 0xFF5C816F, 0xFF5C816F, 0xFF5C816F, 0xFF5B806E, 0xFF5B806E, 0xFF5B806E, 0xFF5B806E, 0xFF5E7E69,
    0xFF547A6B, 0xFF436D63, 0xFF345341, 0xFF596341, 0xFF958D5C, 0xFFA5945C, 0xFF9C8951, 0xFF897D4B, 0xFF4B4C2C, 0xFF2B382E, 0xFF687676, 0xFF888D89, 0xFFE4E0D4, 0xFFD5CEBB, 0xFFA9A490, 0xFFA9A091, 0xFFABA293, 0xFFA79E8F, 0xFFA49B8C, 0xFFA59C8D,
    0xFFA49B8C, 0xFFA39A8B, 0xFFA89F90, 0xFFA19C86, 0xFF9D9980, 0xFF9B977E, 0xFF938F76, 0xFF8D8874, 0xFF928C7C, 0xFFAEA79D, 0xFFDCD5CF, 0xFFCDD3C9, 0xFF819184, 0xFF5D796A, 0xFF608775, 0xFF4D7163, 0x0092ACA3, 0x00F4FFFB, 0x00FFFEFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFF, 0x00F7FFFF, 0xFF729287, 0xFF4E786A, 0xFF648D7F, 0xFF698F82, 0xFF5C8879, 0xFF5A8D7C, 0xFF65907F, 0xFF628D7C, 0xFF618C7B, 0xFF628D7C, 0xFF628D7C,
    0xFF608B7A, 0xFF5F8A79, 0xFF669180, 0xFF5D8C7A, 0xFF54806F, 0xFF5B8172, 0xFF65897B, 0xFF638577, 0xFF5F8375, 0xFF618778, 0xFF638C7C, 0xFF61877A, 0xFF608679, 0xFF5D8376, 0xFF547C71, 0xFF5A8277, 0xFF578177, 0xFF628C82, 0xFF588379, 0xFF5C8575,
    0xFF5E8777, 0xFF5B8675, 0xFF5D8877, 0xFF5A8675, 0xFF5A8675, 0xFF608C7B, 0xFF538270, 0xFF4A7665, 0xFF2D5948, 0xFF406C5B, 0xFF3B6756, 0xFF588473, 0xFF608C7B, 0xFF618D7C, 0xFF568271, 0xFF598876, 0xFF588775, 0xFF52816F, 0xFF5D8978, 0xFF5B8776,
    0xFF487362, 0xFF3F6A59, 0xFF3C6756, 0xFF2A5343, 0xFF345D4D, 0xFF2F5848, 0xFF325B4B, 0xFF436C5C, 0xFF406959, 0xFF396252, 0xFF466F5F, 0xFF426859, 0xFF426859, 0xFF426859, 0xFF43695A, 0xFF43695A, 0xFF43695A, 0xFF43695A, 0xFF43695A, 0xFF426859,
    0xFF426859, 0xFF43695A, 0xFF43695A, 0xFF43695A, 0xFF43695A, 0xFF426859, 0xFF426859, 0xFF3C6555, 0xFF3C6555, 0xFF365F4F, 0xFF406959, 0xFF386151, 0xFF426B5B, 0xFF456E5E, 0xFF547D6D, 0xFF5B8776, 0xFF5B8776, 0xFF5B8776, 0xFF5B8776, 0xFF5B8776,
    0xFF5B8776, 0xFF5B8776, 0xFF5B8776, 0xFF5C8877, 0xFF5E8A79, 0xFF598473, 0xFF688E7F, 0xFF416154, 0xFF657C72, 0xFF68756E, 0xFF77807B, 0xFF7E8A8A, 0xFF7D8989, 0xFF778383, 0xFF737F7F, 0xFF7F8B8B, 0xFF828E8E, 0xFF8F9B9B, 0xFF899595, 0xFF7A8889,
    0xFF778586, 0xFF6E7C7D, 0xFF798788, 0xFF6D7B7C, 0xFF7D8B8C, 0xFF6B797A, 0xFF7F8D8E, 0xFF818D8B, 0xFF75817F, 0xFF84908E, 0xFF7B8785, 0xFF7C8886, 0xFF8A9694, 0xFF7B8785, 0xFF788482, 0xFF8B8B93, 0xFF848E90, 0xFF4A635F, 0xFF557B70, 0xFF588775,
    0xFF558470, 0xFF598470, 0xFF618873, 0xFF5D8674, 0xFF5D8674, 0xFF598270, 0xFF648D7D, 0xFF598272, 0xFF598274, 0xFF60897B, 0xFF2F584A, 0xFF426859, 0xFF355B4C, 0xFF1F4536, 0xFF466D5B, 0xFF3A614F, 0xFF4A715F, 0xFF608774, 0xFF5E8572, 0xFF608574,
    0xFF5F8473, 0xFF5E8573, 0xFF5D8472, 0xFF5B8472, 0xFF5B8472, 0xFF5B8472, 0xFF5A8572, 0xFF5F8674, 0xFF5E8573, 0xFF5E8573, 0xFF5D8472, 0xFF5D8472, 0xFF5E8573, 0xFF5F8674, 0xFF5F8674, 0xFF608775, 0xFF608775, 0xFF5F8674, 0xFF5E8573, 0xFF5D8472,
    0xFF5C8371, 0xFF5B8270, 0xFF5B8270, 0xFF5F8673, 0xFF5F8673, 0xFF5E8572, 0xFF5E8572, 0xFF5D8471, 0xFF5C8370, 0xFF5C8370, 0xFF5C8370, 0xFF5D8270, 0xFF5C816F, 0xFF5C816F, 0xFF5C816F, 0xFF5C816F, 0xFF5C816F, 0xFF5B806E, 0xFF5B806E, 0xFF5B7C69,
    0xFF547A6D, 0xFF487268, 0xFF3D5C4A, 0xFF5F6644, 0xFF928654, 0xFFA58F56, 0xFFA38A51, 0xFF8F7F4B, 0xFF53502D, 0xFF2E392B, 0xFF5D6766, 0xFF868883, 0xFFE4DED2, 0xFFD4CFBC, 0xFF918E7B, 0xFF8B836C, 0xFF8E866F, 0xFF8B836C, 0xFF89816A, 0xFF8B836C,
    0xFF89816A, 0xFF877F68, 0xFF8B836C, 0xFF88836F, 0xFF827D67, 0xFF817D64, 0xFF7A765D, 0xFF7A7561, 0xFF8A8474, 0xFFADA69C, 0xFFD8D1CB, 0xFFE8EEE4, 0xFF9CAA9D, 0xFF658172, 0xFF628977, 0xFF4B6F61, 0x008EA89F, 0x00F8FFFE, 0x00FFFEFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFF, 0x00F7FFFF, 0xFF719186, 0xFF537D6F, 0xFF638C7E, 0xFF658B7E, 0xFF5D897A, 0xFF5A8D7C, 0xFF5E8978, 0xFF5F8A79, 0xFF5C8776, 0xFF5F8A79, 0xFF5D8877,
    0xFF5F8A79, 0xFF608B7A, 0xFF628D7C, 0xFF61927F, 0xFF659482, 0xFF5D8877, 0xFF5D8676, 0xFF648D7D, 0xFF699584, 0xFF629380, 0xFF5E917E, 0xFF6A9383, 0xFF689183, 0xFF6B9486, 0xFF699284, 0xFF658D82, 0xFF5A8277, 0xFF658D84, 0xFF5F877E, 0xFF5D8877,
    0xFF5D8877, 0xFF598574, 0xFF5A8675, 0xFF578674, 0xFF578674, 0xFF5C8D7A, 0xFF588976, 0xFF598574, 0xFF4A7665, 0xFF2B5746, 0xFF3D6958, 0xFF3A6655, 0xFF578372, 0xFF5C8877, 0xFF537F6E, 0xFF568573, 0xFF5B8A78, 0xFF558472, 0xFF598574, 0xFF5E8A79,
    0xFF55806F, 0xFF467160, 0xFF396453, 0xFF3B6454, 0xFF305949, 0xFF3C6555, 0xFF487161, 0xFF406959, 0xFF436C5C, 0xFF4A7363, 0xFF406959, 0xFF456E5E, 0xFF456E5E, 0xFF456E5E, 0xFF456E5E, 0xFF466F5F, 0xFF466F5F, 0xFF466F5F, 0xFF466F5F, 0xFF486E5F,
    0xFF476D5E, 0xFF476D5E, 0xFF476D5E, 0xFF476D5E, 0xFF476D5E, 0xFF476D5E, 0xFF486E5F, 0xFF4B7464, 0xFF3F6858, 0xFF446D5D, 0xFF386151, 0xFF466F5F, 0xFF3E6757, 0xFF537C6C, 0xFF5C8575, 0xFF598574, 0xFF598574, 0xFF5A8675, 0xFF5A8675, 0xFF5A8675,
    0xFF588473, 0xFF578372, 0xFF568271, 0xFF5A8574, 0xFF568170, 0xFF618C7B, 0xFF5A8373, 0xFF557769, 0xFF728C81, 0xFF9AAEA5, 0xFFB1BEB7, 0xFF7F948F, 0xFF869B96, 0xFF7F948F, 0xFF708580, 0xFF728782, 0xFF728782, 0xFF859A95, 0xFF7F948F, 0xFF798F8C,
    0xFF627875, 0xFF617774, 0xFF647A77, 0xFF5A706D, 0xFF5A706D, 0xFF627875, 0xFF5B716E, 0xFF596E67, 0xFF566B64, 0xFF71867F, 0xFF758A83, 0xFF788D86, 0xFF7A8F88, 0xFF6A7F78, 0xFF677C75, 0xFF7C8789, 0xFF788B89, 0xFF44635B, 0xFF588274, 0xFF5C8B79,
    0xFF51806C, 0xFF57846F, 0xFF5A8571, 0xFF57806E, 0xFF57806E, 0xFF5F8876, 0xFF567F6F, 0xFF5F8878, 0xFF5D8678, 0xFF3A6355, 0xFF40695B, 0xFF2D5344, 0xFF224839, 0xFF426859, 0xFF365D4B, 0xFF507765, 0xFF5D8472, 0xFF5F8673, 0xFF5D8471, 0xFF608574,
    0xFF5F8473, 0xFF5E8573, 0xFF5D8472, 0xFF5B8472, 0xFF5B8472, 0xFF5B8472, 0xFF5B8673, 0xFF5E8573, 0xFF5E8573, 0xFF5D8472, 0xFF5D8472, 0xFF5E8573, 0xFF5F8674, 0xFF608775, 0xFF608775, 0xFF618876, 0xFF608775, 0xFF5E8573, 0xFF5D8472, 0xFF5C8371,
    0xFF5C8371, 0xFF5C8371, 0xFF5D8472, 0xFF5F8673, 0xFF5F8673, 0xFF5E8572, 0xFF5E8572, 0xFF5D8471, 0xFF5D8471, 0xFF5C8370, 0xFF5C8370, 0xFF5D8270, 0xFF5D8270, 0xFF5D8270, 0xFF5D8270, 0xFF5D8270, 0xFF5C816F, 0xFF5C816F, 0xFF5C816F, 0xFF5D806C,
    0xFF5A8375, 0xFF517B71, 0xFF43604C, 0xFF646A46, 0xFF998955, 0xFFB2955B, 0xFFAB8D51, 0xFF927F47, 0xFF544C27, 0xFF343827, 0xFF5D645D, 0xFF95948F, 0xFFE4DED2, 0xFFD2CFBE, 0xFF7E7F6F, 0xFF726D50, 0xFF767154, 0xFF746F52, 0xFF736E51, 0xFF767154,
    0xFF757053, 0xFF716C4F, 0xFF726D50, 0xFF6F6C59, 0xFF6A6853, 0xFF6E6C55, 0xFF696750, 0xFF696752, 0xFF807D6C, 0xFFA6A297, 0xFFCDC8C2, 0xFFF0F3EA, 0xFFA8B6A9, 0xFF627E6F, 0xFF5F8473, 0xFF496D5F, 0x008AA199, 0x00F9FFFF, 0x00FFFEFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFF, 0x00F7FFFF, 0xFF6A8A7F, 0xFF527C6E, 0xFF638C7E, 0xFF668C7F, 0xFF5E8A7B, 0xFF5D907F, 0xFF648E80, 0xFF6D9789, 0xFF669082, 0xFF658F81, 0xFF5E887A,
    0xFF648E80, 0xFF669082, 0xFF648E80, 0xFF658C7A, 0xFF628776, 0xFF658777, 0xFF6E8E7F, 0xFF597B6B, 0xFF4E7563, 0xFF4C7764, 0xFF46735F, 0xFF4A7061, 0xFF43695A, 0xFF4D7366, 0xFF597F72, 0xFF61877A, 0xFF5A8075, 0xFF668C81, 0xFF60867B, 0xFF5F8B7A,
    0xFF5C8877, 0xFF588473, 0xFF588775, 0xFF588775, 0xFF568774, 0xFF578875, 0xFF568774, 0xFF5F8A79, 0xFF628D7C, 0xFF436E5D, 0xFF345F4E, 0xFF3F6A59, 0xFF3D6857, 0xFF5B8675, 0xFF5E8978, 0xFF568573, 0xFF558472, 0xFF558472, 0xFF5A8675, 0xFF588473,
    0xFF5D8877, 0xFF5D8877, 0xFF467160, 0xFF3B6454, 0xFF3D6656, 0xFF3A6353, 0xFF3C6555, 0xFF416A5A, 0xFF3C6555, 0xFF355E4E, 0xFF396252, 0xFF386151, 0xFF386151, 0xFF396252, 0xFF396252, 0xFF396252, 0xFF396252, 0xFF3A6353, 0xFF3A6353, 0xFF3E6455,
    0xFF3D6354, 0xFF3C6253, 0xFF3C6253, 0xFF3C6253, 0xFF3C6253, 0xFF3D6354, 0xFF3E6455, 0xFF376050, 0xFF3E6757, 0xFF315A4A, 0xFF3D6656, 0xFF365F4F, 0xFF547D6D, 0xFF557E6E, 0xFF5E8777, 0xFF5C8776, 0xFF5C8776, 0xFF5D8877, 0xFF5E8978, 0xFF5D8877,
    0xFF5B8675, 0xFF598473, 0xFF588372, 0xFF567F6F, 0xFF638C7C, 0xFF547F6E, 0xFF578070, 0xFF335749, 0xFF5C7A6E, 0xFF647B71, 0xFF6C8077, 0xFF4B695F, 0xFF537167, 0xFF59776D, 0xFF47655B, 0xFF436157, 0xFF3F5D53, 0xFF446258, 0xFF405E54, 0xFF3E5C54,
    0xFF4E6C64, 0xFF2E4C44, 0xFF2C4A42, 0xFF56746C, 0xFF45635B, 0xFF4B6961, 0xFF527068, 0xFF516F65, 0xFF426056, 0xFF46645A, 0xFF3E5C52, 0xFF436157, 0xFF47655B, 0xFF446258, 0xFF405E54, 0xFF586F69, 0xFF5F7A73, 0xFF476B5F, 0xFF588274, 0xFF5A8977,
    0xFF578672, 0xFF5B8874, 0xFF5D8875, 0xFF608977, 0xFF5C8573, 0xFF5C8573, 0xFF638C7C, 0xFF547D6D, 0xFF40695B, 0xFF3E6759, 0xFF345D4F, 0xFF1C4233, 0xFF416758, 0xFF3C6253, 0xFF476E5C, 0xFF59806E, 0xFF628977, 0xFF5A816E, 0xFF5E8572, 0xFF608574,
    0xFF608574, 0xFF5E8573, 0xFF5D8472, 0xFF5B8472, 0xFF5B8472, 0xFF5C8573, 0xFF5B8673, 0xFF5D8472, 0xFF5D8472, 0xFF5D8472, 0xFF5E8573, 0xFF5F8674, 0xFF608775, 0xFF608775, 0xFF618876, 0xFF618876, 0xFF608775, 0xFF5E8573, 0xFF5C8371, 0xFF5C8371,
    0xFF5C8371, 0xFF5D8472, 0xFF5E8573, 0xFF5F8673, 0xFF5F8673, 0xFF5E8572, 0xFF5E8572, 0xFF5E8572, 0xFF5D8471, 0xFF5D8471, 0xFF5D8471, 0xFF5E8371, 0xFF5E8371, 0xFF5E8371, 0xFF5E8371, 0xFF5E8371, 0xFF5D8270, 0xFF5D8270, 0xFF5D8270, 0xFF597C68,
    0xFF5A8476, 0xFF4C766C, 0xFF34513D, 0xFF5C603D, 0xFF9E8C5A, 0xFFBFA067, 0xFFAD8D52, 0xFF96834B, 0xFF564E27, 0xFF4A4B39, 0xFF80837A, 0xFFBEBBB2, 0xFFECE6DA, 0xFFD0CEC1, 0xFF737769, 0xFF67624C, 0xFF6D6852, 0xFF6C6751, 0xFF6C6751, 0xFF706B55,
    0xFF6F6A54, 0xFF6A654F, 0xFF69644E, 0xFF6A6756, 0xFF64614E, 0xFF66644F, 0xFF5D5B46, 0xFF5A5843, 0xFF767362, 0xFFA4A094, 0xFFCFCBC2, 0xFFE8EBE2, 0xFFABB9AC, 0xFF5E796A, 0xFF5E8372, 0xFF4E7062, 0x00889F97, 0x00F9FFFF, 0x00FEF9FD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFF, 0x00F6FFFE, 0xFF67877C, 0xFF537D6F, 0xFF658E80, 0xFF61877A, 0xFF447061, 0xFF3E7160, 0xFF3B6557, 0xFF426C5E, 0xFF3A6456, 0xFF406A5C, 0xFF3C6658,
    0xFF416B5D, 0xFF406A5C, 0xFF4B7567, 0xFF6C8477, 0xFF52685C, 0xFF4D5E54, 0xFF637369, 0xFF45554B, 0xFF31453A, 0xFF2C4437, 0xFF203A2D, 0xFF1B372B, 0xFF244236, 0xFF2F4D41, 0xFF2B4B40, 0xFF315247, 0xFF3C6054, 0xFF5C8277, 0xFF5E8479, 0xFF5F8A79,
    0xFF5C8776, 0xFF5D8877, 0xFF5D8978, 0xFF5C8877, 0xFF568573, 0xFF558472, 0xFF5B8A78, 0xFF5D8877, 0xFF5B8675, 0xFF628D7C, 0xFF3D6857, 0xFF386352, 0xFF3C6756, 0xFF3F6A59, 0xFF5A8574, 0xFF5D8C7A, 0xFF538270, 0xFF507F6D, 0xFF5B8776, 0xFF578372,
    0xFF547F6E, 0xFF5E8978, 0xFF5D8877, 0xFF3A6353, 0xFF3C6555, 0xFF386151, 0xFF3A6353, 0xFF426B5B, 0xFF406959, 0xFF3E6757, 0xFF446D5D, 0xFF406959, 0xFF406959, 0xFF406959, 0xFF416A5A, 0xFF416A5A, 0xFF416A5A, 0xFF416A5A, 0xFF426B5B, 0xFF466C5D,
    0xFF456B5C, 0xFF446A5B, 0xFF446A5B, 0xFF446A5B, 0xFF446A5B, 0xFF456B5C, 0xFF466C5D, 0xFF3F6858, 0xFF3A6353, 0xFF436C5C, 0xFF386151, 0xFF537C6C, 0xFF537C6C, 0xFF608979, 0xFF567F6F, 0xFF5B8675, 0xFF5C8776, 0xFF5D8877, 0xFF5D8877, 0xFF5D8877,
    0xFF5B8675, 0xFF598473, 0xFF588372, 0xFF638779, 0xFF5B8172, 0xFF598272, 0xFF3D6857, 0xFF3B6454, 0xFF365A4C, 0xFF426054, 0xFF304A3F, 0xFF3F6357, 0xFF42665A, 0xFF5E8276, 0xFF577B6F, 0xFF5F8377, 0xFF63877B, 0xFF5B7F73, 0xFF5D8175, 0xFF5F8173,
    0xFF628476, 0xFF3C5E50, 0xFF426456, 0xFF325446, 0xFF46685A, 0xFF395B4D, 0xFF3C5E50, 0xFF3C6052, 0xFF34584A, 0xFF3E6254, 0xFF426658, 0xFF567A6C, 0xFF597D6F, 0xFF4F7365, 0xFF365A4C, 0xFF3A5A4F, 0xFF395B4D, 0xFF3B6152, 0xFF45705F, 0xFF497564,
    0xFF4F7B6A, 0xFF487561, 0xFF517C69, 0xFF537A68, 0xFF59806E, 0xFF567D6B, 0xFF53796A, 0xFF466C5D, 0xFF3D6356, 0xFF385E51, 0xFF22483B, 0xFF426859, 0xFF416758, 0xFF446A5B, 0xFF618876, 0xFF5E8573, 0xFF5C8371, 0xFF5F8673, 0xFF5D8471, 0xFF608574,
    0xFF608574, 0xFF5E8573, 0xFF5E8573, 0xFF5B8472, 0xFF5B8472, 0xFF5C8573, 0xFF5B8673, 0xFF5D8472, 0xFF5D8472, 0xFF5E8573, 0xFF5F8674, 0xFF5F8674, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF618876, 0xFF608775, 0xFF5E8573, 0xFF5D8472, 0xFF5C8371,
    0xFF5D8472, 0xFF5E8573, 0xFF5F8674, 0xFF5F8673, 0xFF5F8673, 0xFF5E8572, 0xFF5E8572, 0xFF5E8572, 0xFF5E8572, 0xFF5E8572, 0xFF5E8572, 0xFF5F8472, 0xFF5F8472, 0xFF5F8472, 0xFF5F8472, 0xFF5F8472, 0xFF5E8371, 0xFF5E8371, 0xFF5E8371, 0xFF5C7F6B,
    0xFF5C8678, 0xFF4B766C, 0xFF32513F, 0xFF5F6444, 0xFFA19062, 0xFFCCB17C, 0xFFC1A36F, 0xFF968A58, 0xFF605C37, 0xFF676A59, 0xFF9A9D94, 0xFFD5D1C6, 0xFFF2ECDE, 0xFFCDCEC0, 0xFF6C7467, 0xFF5D594E, 0xFF666257, 0xFF686459, 0xFF676358, 0xFF6B675C,
    0xFF6B675C, 0xFF656156, 0xFF635F54, 0xFF656356, 0xFF615F50, 0xFF656450, 0xFF5E5D48, 0xFF585742, 0xFF6D6C5A, 0xFF9C9A8D, 0xFFCECCC0, 0xFFEBECE4, 0xFFB8C4B8, 0xFF647F70, 0xFF668878, 0xFF547668, 0x008A9F98, 0x00FBFFFF, 0x00FCF7FB, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFF, 0x00F6FFFE, 0xFF69897E, 0xFF547E70, 0xFF689183, 0xFF5A8073, 0xFF214D3E, 0xFF1A4D3C, 0xFF1B4539, 0xFF164034, 0xFF0C362A, 0xFF1A4438, 0xFF1D473B,
    0xFF1C463A, 0xFF0D372B, 0xFF295347, 0xFF63746A, 0xFF49564D, 0xFF49534B, 0xFF939892, 0xFFB1B3AE, 0xFFBBBDB8, 0xFFB8BDB7, 0xFFB1B8B1, 0xFFA1AEA5, 0xFFABBBB1, 0xFF8A9E95, 0xFF465D53, 0xFF2F4D43, 0xFF45665B, 0xFF678D80, 0xFF628A7F, 0xFF63897A,
    0xFF618778, 0xFF648A7B, 0xFF628B7B, 0xFF618A7A, 0xFF5C8575, 0xFF5A8574, 0xFF699483, 0xFF5F8878, 0xFF628B7B, 0xFF638C7C, 0xFF608979, 0xFF3A6353, 0xFF426B5B, 0xFF376050, 0xFF3F6858, 0xFF538270, 0xFF608F7D, 0xFF598876, 0xFF5C8877, 0xFF608C7B,
    0xFF578271, 0xFF568170, 0xFF5F8A79, 0xFF578070, 0xFF466F5F, 0xFF4B7464, 0xFF4F7868, 0xFF426B5B, 0xFF446D5D, 0xFF4C7565, 0xFF436C5C, 0xFF436E5D, 0xFF446F5E, 0xFF446F5E, 0xFF446F5E, 0xFF446F5E, 0xFF446F5E, 0xFF45705F, 0xFF45705F, 0xFF476D5E,
    0xFF476D5E, 0xFF476D5E, 0xFF466C5D, 0xFF466C5D, 0xFF476D5E, 0xFF476D5E, 0xFF476D5E, 0xFF497262, 0xFF487161, 0xFF406959, 0xFF588171, 0xFF557E6E, 0xFF628B7B, 0xFF588171, 0xFF5C8575, 0xFF5F8878, 0xFF5F8878, 0xFF608979, 0xFF608979, 0xFF5F8878,
    0xFF5E8777, 0xFF5D8676, 0xFF5C8575, 0xFF67897B, 0xFF54786A, 0xFF365F4F, 0xFF3C6756, 0xFF2E5948, 0xFF3A6353, 0xFF3D6153, 0xFF406254, 0xFF3C6253, 0xFF446A5B, 0xFF668C7D, 0xFF5E8475, 0xFF5F8576, 0xFF5E8475, 0xFF597F70, 0xFF618778, 0xFF5F8473,
    0xFF426756, 0xFF466B5A, 0xFF3C6150, 0xFF1D4231, 0xFF416655, 0xFF395E4D, 0xFF3E6352, 0xFF3C6351, 0xFF355C4A, 0xFF3E6553, 0xFF486F5D, 0xFF658C7A, 0xFF658C7A, 0xFF5A816F, 0xFF365D4B, 0xFF3D6452, 0xFF284F3D, 0xFF315846, 0xFF3A614F, 0xFF3C6253,
    0xFF3F6556, 0xFF315748, 0xFF3E6455, 0xFF39604E, 0xFF406755, 0xFF456C5A, 0xFF345A4B, 0xFF3C6253, 0xFF3A6053, 0xFF22483B, 0xFF3A6053, 0xFF486E5F, 0xFF3B6152, 0xFF658B7C, 0xFF5D8472, 0xFF658C7A, 0xFF5C8371, 0xFF5C8370, 0xFF5E8572, 0xFF618675,
    0xFF608574, 0xFF5F8674, 0xFF5E8573, 0xFF5C8573, 0xFF5C8573, 0xFF5C8573, 0xFF5B8673, 0xFF5D8472, 0xFF5E8573, 0xFF5F8674, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF5F8674, 0xFF5E8573, 0xFF5D8472, 0xFF5D8472,
    0xFF5E8573, 0xFF5E8573, 0xFF5F8674, 0xFF5E8572, 0xFF5E8572, 0xFF5E8572, 0xFF5E8572, 0xFF5E8572, 0xFF5E8572, 0xFF5E8572, 0xFF5E8572, 0xFF618674, 0xFF608573, 0xFF608573, 0xFF608573, 0xFF608573, 0xFF5F8472, 0xFF5F8472, 0xFF5F8472, 0xFF64866E,
    0xFF5F8878, 0xFF558076, 0xFF486859, 0xFF6E785D, 0xFF988F68, 0xFFC6B388, 0xFFCBB68B, 0xFF85835A, 0xFF5A6044, 0xFF657062, 0xFF838881, 0xFFB9B5AC, 0xFFEEE6D9, 0xFFCFD0C2, 0xFF70786D, 0xFF6F6C67, 0xFF7B7873, 0xFF7E7B76, 0xFF7D7A75, 0xFF807D78,
    0xFF807D78, 0xFF7C7974, 0xFF7A7772, 0xFF777569, 0xFF6F6D60, 0xFF6C6B59, 0xFF63624E, 0xFF5C5B47, 0xFF646351, 0xFF8F8D7E, 0xFFCCCABE, 0xFFECEDE5, 0xFFBECABE, 0xFF6A8274, 0xFF658777, 0xFF557568, 0x008BA099, 0x00FBFFFF, 0x00FFFBFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFF, 0x00F7FFFF, 0xFF68887D, 0xFF4E786A, 0xFF689183, 0xFF61877A, 0xFF224E3F, 0xFF2B5E4D, 0xFF4C766A, 0xFF436D61, 0xFF325C50, 0xFF376155, 0xFF416B5F,
    0xFF436D61, 0xFF1C463A, 0xFF366054, 0xFF556D5F, 0xFF3B4F43, 0xFF4D594F, 0xFFBBC0B9, 0xFFEDECE7, 0xFFF3F0EB, 0xFFECE9E4, 0xFFEAE7E2, 0xFFF5F1EE, 0xFFF3F2EE, 0xFFAFB4AE, 0xFF495851, 0xFF2F463C, 0xFF3F5F54, 0xFF52786B, 0xFF406A5C, 0xFF4C6C5F,
    0xFF3F5F52, 0xFF3A5C4E, 0xFF3A5C4E, 0xFF3E6254, 0xFF3D6153, 0xFF385C4E, 0xFF466C5D, 0xFF628B7B, 0xFF5C8575, 0xFF608979, 0xFF5B8474, 0xFF5D8676, 0xFF406959, 0xFF4C7565, 0xFF345D4D, 0xFF3D6C5A, 0xFF588775, 0xFF588775, 0xFF578372, 0xFF5F8B7A,
    0xFF5D8877, 0xFF5A8574, 0xFF5A8574, 0xFF588171, 0xFF608979, 0xFF588171, 0xFF588171, 0xFF668F7F, 0xFF618A7A, 0xFF598272, 0xFF668F7F, 0xFF5F8A79, 0xFF608B7A, 0xFF608B7A, 0xFF608B7A, 0xFF608B7A, 0xFF608B7A, 0xFF618C7B, 0xFF618C7B, 0xFF628879,
    0xFF63897A, 0xFF63897A, 0xFF63897A, 0xFF63897A, 0xFF63897A, 0xFF63897A, 0xFF628879, 0xFF638C7C, 0xFF5C8575, 0xFF628B7B, 0xFF5F8878, 0xFF689181, 0xFF5B8474, 0xFF5F8878, 0xFF5E8777, 0xFF608979, 0xFF608979, 0xFF608979, 0xFF608979, 0xFF608979,
    0xFF608979, 0xFF5F8878, 0xFF5F8878, 0xFF5D7D70, 0xFF44685A, 0xFF3B6454, 0xFF34604F, 0xFF406C5B, 0xFF305B4A, 0xFF426B5B, 0xFF406657, 0xFF416856, 0xFF537A68, 0xFF668D7B, 0xFF5F8674, 0xFF608775, 0xFF5B8270, 0xFF628977, 0xFF5F8674, 0xFF3F6452,
    0xFF416654, 0xFF325745, 0xFF1C412F, 0xFF3D6250, 0xFF3A5F4D, 0xFF234836, 0xFF446957, 0xFF3A614E, 0xFF335A47, 0xFF3B624F, 0xFF486F5C, 0xFF638A77, 0xFF5C8370, 0xFF5B826F, 0xFF3D6451, 0xFF3C6652, 0xFF2C5340, 0xFF365B49, 0xFF3F6151, 0xFF3F6151,
    0xFF416355, 0xFF3B5D4F, 0xFF426456, 0xFF3F6453, 0xFF3A5F4E, 0xFF345948, 0xFF466A5C, 0xFF375B4D, 0xFF274B3F, 0xFF406458, 0xFF3F6357, 0xFF375D4E, 0xFF668C7D, 0xFF577D6E, 0xFF668D7B, 0xFF5C8371, 0xFF5F8674, 0xFF5D8471, 0xFF5F8673, 0xFF618675,
    0xFF608574, 0xFF5F8674, 0xFF5E8573, 0xFF5C8573, 0xFF5C8573, 0xFF5C8573, 0xFF5C8774, 0xFF5E8573, 0xFF5F8674, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF5F8674, 0xFF5F8674, 0xFF5F8674, 0xFF5F8674, 0xFF5F8674, 0xFF5E8573, 0xFF5E8573,
    0xFF5E8573, 0xFF5E8573, 0xFF5E8573, 0xFF5E8572, 0xFF5E8572, 0xFF5E8572, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF618674, 0xFF618674, 0xFF618674, 0xFF618674, 0xFF608573, 0xFF608573, 0xFF608573, 0xFF608573, 0xFF628368,
    0xFF5F8674, 0xFF5B867C, 0xFF54786C, 0xFF73826D, 0xFF818062, 0xFFA29978, 0xFFA29779, 0xFF646F4F, 0xFF455643, 0xFF56675F, 0xFF67706D, 0xFF9A978E, 0xFFE8E0D3, 0xFFCCCABD, 0xFF6E7669, 0xFF818177, 0xFF8F8F85, 0xFF95958B, 0xFF929288, 0xFF94948A,
    0xFF95958B, 0xFF929288, 0xFF919187, 0xFF908D86, 0xFF7B796D, 0xFF686657, 0xFF5E5D49, 0xFF5A5945, 0xFF595846, 0xFF817F70, 0xFFCBC9BC, 0xFFE8E9E1, 0xFFBFC9BE, 0xFF6B8375, 0xFF618373, 0xFF537366, 0x008BA099, 0x00FCFFFF, 0x00FFFDFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFF, 0x00F5FFFD, 0xFF69897E, 0xFF4D7769, 0xFF699284, 0xFF62887B, 0xFF1C4839, 0xFF2F6251, 0xFF467064, 0xFF456F63, 0xFF335D51, 0xFF2D574B, 0xFF416B5F,
    0xFF537D71, 0xFF1F493D, 0xFF2C564A, 0xFF5B7C6B, 0xFF3A5647, 0xFF596B5F, 0xFFD1DBD2, 0xFFE5E6E0, 0xFFCECBC6, 0xFFC5C2BD, 0xFFCBC6C2, 0xFFDFCFD0, 0xFFF1E7E6, 0xFFC0BFBB, 0xFF5C6560, 0xFF2A3F36, 0xFF214134, 0xFF325B4D, 0xFF356152, 0xFF516D61,
    0xFF345246, 0xFF244236, 0xFF244236, 0xFF335346, 0xFF37574A, 0xFF2B4D3F, 0xFF345648, 0xFF4C7565, 0xFF426B5B, 0xFF456E5E, 0xFF487161, 0xFF507969, 0xFF5A8373, 0xFF3A6353, 0xFF436C5C, 0xFF386755, 0xFF3B6A58, 0xFF3D6C5A, 0xFF477362, 0xFF436F5E,
    0xFF3E6958, 0xFF467160, 0xFF497463, 0xFF487161, 0xFF426B5B, 0xFF487161, 0xFF4F7868, 0xFF4C7565, 0xFF4C7565, 0xFF4C7565, 0xFF487161, 0xFF4A7564, 0xFF4A7564, 0xFF4A7564, 0xFF4A7564, 0xFF4B7665, 0xFF4B7665, 0xFF4B7665, 0xFF4B7665, 0xFF4E7465,
    0xFF4F7566, 0xFF507667, 0xFF507667, 0xFF507667, 0xFF507667, 0xFF4F7566, 0xFF4E7465, 0xFF456E5E, 0xFF4D7666, 0xFF4E7767, 0xFF4B7464, 0xFF456E5E, 0xFF4C7565, 0xFF4E7767, 0xFF507969, 0xFF507969, 0xFF507969, 0xFF507969, 0xFF507969, 0xFF507969,
    0xFF517A6A, 0xFF517A6A, 0xFF517A6A, 0xFF446457, 0xFF406254, 0xFF386151, 0xFF3A6655, 0xFF396856, 0xFF34604F, 0xFF3E6958, 0xFF3A6353, 0xFF5A816F, 0xFF688F7D, 0xFF5C8371, 0xFF5A816F, 0xFF658C7A, 0xFF5E8573, 0xFF638A78, 0xFF416856, 0xFF3E644F,
    0xFF426853, 0xFF183E29, 0xFF426853, 0xFF426853, 0xFF446A55, 0xFF3A604B, 0xFF395F4A, 0xFF3F6653, 0xFF355C49, 0xFF3B624F, 0xFF486F5C, 0xFF618875, 0xFF59806D, 0xFF678E7B, 0xFF577E6B, 0xFF36604A, 0xFF3B624D, 0xFF466857, 0xFF49695A, 0xFF446354,
    0xFF48665A, 0xFF4C6C5F, 0xFF46665B, 0xFF426756, 0xFF456A59, 0xFF436857, 0xFF3D6153, 0xFF4B6F61, 0xFF4D7165, 0xFF3D6155, 0xFF43675B, 0xFF608677, 0xFF63897A, 0xFF658B7C, 0xFF547B69, 0xFF608775, 0xFF5F8674, 0xFF5B826F, 0xFF648B78, 0xFF618675,
    0xFF618675, 0xFF5F8674, 0xFF5E8573, 0xFF5C8573, 0xFF5C8573, 0xFF5C8573, 0xFF5C8774, 0xFF5F8674, 0xFF5F8674, 0xFF608775, 0xFF618876, 0xFF608775, 0xFF608775, 0xFF5F8674, 0xFF5E8573, 0xFF5E8573, 0xFF5F8674, 0xFF5F8674, 0xFF5F8674, 0xFF5F8674,
    0xFF5F8674, 0xFF5E8573, 0xFF5E8573, 0xFF5E8572, 0xFF5E8572, 0xFF5E8572, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF628775, 0xFF628775, 0xFF618674, 0xFF618674, 0xFF618674, 0xFF618674, 0xFF608573, 0xFF608573, 0xFF658367,
    0xFF648B78, 0xFF638E84, 0xFF5A8075, 0xFF748774, 0xFF787C63, 0xFF87836A, 0xFF716F58, 0xFF4D6148, 0xFF374F41, 0xFF556B68, 0xFF6B7775, 0xFF9A9A92, 0xFFECE4D7, 0xFFC1BFB0, 0xFF62685C, 0xFF6F705E, 0xFF7F806E, 0xFF858674, 0xFF828371, 0xFF838472,
    0xFF848573, 0xFF828371, 0xFF828371, 0xFF7F7F77, 0xFF6C6C62, 0xFF5F6052, 0xFF626351, 0xFF646651, 0xFF575846, 0xFF6D6E5E, 0xFFB3B4A6, 0xFFECECE4, 0xFFC4CEC3, 0xFF728A7C, 0xFF658576, 0xFF557568, 0x008DA09A, 0x00FCFFFF, 0x00FFFDFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFEFF, 0x08F1FFFB, 0xFF65897D, 0xFF4C7869, 0xFF658F81, 0xFF5C8577, 0xFF1B4A3A, 0xFF346957, 0xFF325C50, 0xFF2F594D, 0xFF457164, 0xFF154134, 0xFF487669,
    0xFF336154, 0xFF154336, 0xFF2C5C4E, 0xFF5F7B6C, 0xFF465E50, 0xFF6A7A6F, 0xFFCBD2CA, 0xFFDFE2DB, 0xFFD8D9D3, 0xFFC0C1BB, 0xFFC5C6C0, 0xFFD4D1CC, 0xFFE5E2DD, 0xFFCCCBC6, 0xFF787B74, 0xFF7F847D, 0xFF606A61, 0xFF566258, 0xFF79867C, 0xFFA4A4A2,
    0xFF6F716E, 0xFF5D625E, 0xFF5E6460, 0xFF59645E, 0xFF93A29B, 0xFF697A72, 0xFF4A5B53, 0xFF3D6656, 0xFF456E5E, 0xFF3A6353, 0xFF426B5B, 0xFF3B6454, 0xFF477060, 0xFF557E6E, 0xFF315A4A, 0xFF3C6557, 0xFF416A5C, 0xFF466F61, 0xFF456E60, 0xFF416A5C,
    0xFF3E6759, 0xFF3F685A, 0xFF426B5D, 0xFF44685A, 0xFF436759, 0xFF426658, 0xFF44685A, 0xFF466A5C, 0xFF476B5D, 0xFF45695B, 0xFF436759, 0xFF3F675C, 0xFF40685D, 0xFF426A5F, 0xFF436B60, 0xFF446C61, 0xFF436B60, 0xFF426A5F, 0xFF41695E, 0xFF456B5C,
    0xFF456B5C, 0xFF456B5C, 0xFF456B5C, 0xFF456B5C, 0xFF456B5C, 0xFF456B5C, 0xFF456B5C, 0xFF396254, 0xFF3C6557, 0xFF40695B, 0xFF43695C, 0xFF446A5D, 0xFF45695D, 0xFF466A5E, 0xFF486C60, 0xFF416B5F, 0xFF476F64, 0xFF446C61, 0xFF426A5F, 0xFF486E63,
    0xFF466C61, 0xFF45695F, 0xFF4A6E64, 0xFF567A70, 0xFF3A5E52, 0xFF45695D, 0xFF416559, 0xFF385C4E, 0xFF476B5D, 0xFF3B604F, 0xFF618675, 0xFF628976, 0xFF628976, 0xFF59806D, 0xFF5F8673, 0xFF5B826F, 0xFF608774, 0xFF476E5B, 0xFF39604D, 0xFF4A715F,
    0xFF193E2D, 0xFF466657, 0xFF4C6B5C, 0xFF436253, 0xFF648475, 0xFF3D6251, 0xFF3D6452, 0xFF3E6A59, 0xFF305B4A, 0xFF43695A, 0xFF46685A, 0xFF6A8C7E, 0xFF5C8072, 0xFF577D6E, 0xFF658E7E, 0xFF5B7F71, 0xFF3F6355, 0xFF3F6355, 0xFF3D6153, 0xFF3C6052,
    0xFF416557, 0xFF3A5E50, 0xFF406456, 0xFF3D6251, 0xFF446958, 0xFF3B604F, 0xFF3D6251, 0xFF496E5D, 0xFF406554, 0xFF436857, 0xFF658A79, 0xFF608775, 0xFF5F8674, 0xFF5F8674, 0xFF5F8674, 0xFF5F8674, 0xFF5E8573, 0xFF5E8573, 0xFF5E8573, 0xFF608774,
    0xFF608774, 0xFF608774, 0xFF608774, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5D8471, 0xFF5D8471, 0xFF5D8471, 0xFF5D8471, 0xFF5D8471, 0xFF5D8471, 0xFF5D8471, 0xFF5D8471, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673,
    0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5A8572, 0xFF5F8876, 0xFF5A8371, 0xFF5E8775, 0xFF5F8674, 0xFF5C8371, 0xFF648978, 0xFF618675, 0xFF628776, 0xFF628776, 0xFF5F8473, 0xFF5F8473, 0xFF638877, 0xFF5F8473, 0xFF5B806F, 0xFF648978, 0xFF608775,
    0xFF5F8674, 0xFF547968, 0xFF577C6B, 0xFF5C7E6E, 0xFF5C7E6E, 0xFF557767, 0xFF39594A, 0xFF3E5B56, 0xFF384F49, 0xFF5B6660, 0xFF6D6E68, 0xFF9D998E, 0xFFE7E1D3, 0xFFC2BFAC, 0xFFA9A894, 0xFFABA197, 0xFFAEA49A, 0xFFAEA69B, 0xFFAFA79C, 0xFFB7AFA4,
    0xFFBAB2A7, 0xFFB6AEA3, 0xFFB9B1A6, 0xFFB4AAA0, 0xFFC7BFB4, 0xFFB6B2A6, 0xFFB4B2A5, 0xFFBAB8AB, 0xFFB3B1A4, 0xFFC1BBAF, 0xFFCAC4B8, 0xFFEFE7E4, 0xFFCBD0C9, 0xFF71877B, 0xFF638877, 0xFF527766, 0x0088A297, 0x00F9FFFD, 0x00FDFCFA, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFEFF, 0x04F3FFFD, 0xFF68897E, 0xFF4C7869, 0xFF648E80, 0xFF5B8476, 0xFF1B4A3A, 0xFF2B604E, 0xFF456F63, 0xFF406A5E, 0xFF3E685C, 0xFF1C483B, 0xFF447063,
    0xFF265447, 0xFF174538, 0xFF305E51, 0xFF62786B, 0xFF4C5C51, 0xFF79837A, 0xFFDCDFD8, 0xFFE1DED9, 0xFFD6D1CD, 0xFFD3CECA, 0xFFDED9D5, 0xFFDEDAD7, 0xFFD9D8D4, 0xFFC1C3BE, 0xFF9AA19A, 0xFF939E96, 0xFF47574D, 0xFF4E6257, 0xFF8BA195, 0xFFA8B1AC,
    0xFF79847E, 0xFF525F58, 0xFF5B6A63, 0xFF798D84, 0xFF9FB4AB, 0xFF576E64, 0xFF384F45, 0xFF3D6656, 0xFF305949, 0xFF477060, 0xFF386151, 0xFF376050, 0xFF3D6656, 0xFF3D6656, 0xFF305949, 0xFF345D4F, 0xFF386153, 0xFF3C6557, 0xFF3D6658, 0xFF3B6456,
    0xFF396254, 0xFF3B6456, 0xFF3D6658, 0xFF406456, 0xFF3F6355, 0xFF3F6355, 0xFF406456, 0xFF426658, 0xFF426658, 0xFF416557, 0xFF406456, 0xFF396156, 0xFF3A6257, 0xFF3C6459, 0xFF3D655A, 0xFF3D655A, 0xFF3C6459, 0xFF3B6358, 0xFF3A6257, 0xFF3C6253,
    0xFF3C6253, 0xFF3C6253, 0xFF3B6152, 0xFF3B6152, 0xFF3A6051, 0xFF3A6051, 0xFF3A6051, 0xFF376052, 0xFF396254, 0xFF3D6658, 0xFF406659, 0xFF406659, 0xFF406659, 0xFF42665A, 0xFF43675B, 0xFF406A5E, 0xFF426A5F, 0xFF41695E, 0xFF41695E, 0xFF42685D,
    0xFF42685D, 0xFF43675D, 0xFF44685E, 0xFF31574A, 0xFF4D7366, 0xFF446A5D, 0xFF2F5548, 0xFF486E5F, 0xFF3B6152, 0xFF59806E, 0xFF648B79, 0xFF57806E, 0xFF5B8472, 0xFF668F7D, 0xFF58816F, 0xFF638C7A, 0xFF446D5B, 0xFF436C5A, 0xFF416A58, 0xFF1F4836,
    0xFF416856, 0xFF436555, 0xFF446455, 0xFF6C8C7D, 0xFF6F9181, 0xFF345B49, 0xFF3F6856, 0xFF36634F, 0xFF3E6956, 0xFF345D4B, 0xFF537C6A, 0xFF527967, 0xFF628977, 0xFF6F9684, 0xFF547B69, 0xFF608775, 0xFF638A78, 0xFF668D7B, 0xFF658C7A, 0xFF5F8674,
    0xFF608775, 0xFF638A78, 0xFF5E8573, 0xFF5F8473, 0xFF658A79, 0xFF678C7B, 0xFF608574, 0xFF5D8271, 0xFF638877, 0xFF668B7A, 0xFF638877, 0xFF5D8472, 0xFF5D8472, 0xFF5E8573, 0xFF5E8573, 0xFF5F8674, 0xFF608775, 0xFF618876, 0xFF618876, 0xFF608774,
    0xFF608774, 0xFF608774, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5E8572, 0xFF5E8572, 0xFF5E8572, 0xFF5E8572, 0xFF5E8572, 0xFF5E8572, 0xFF5E8572, 0xFF5E8572, 0xFF5E8572, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673,
    0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5A8572, 0xFF5E8775, 0xFF5A8371, 0xFF5E8775, 0xFF618876, 0xFF5E8573, 0xFF648978, 0xFF628776, 0xFF5F8473, 0xFF618675, 0xFF5F8473, 0xFF638877, 0xFF628776, 0xFF608574, 0xFF658A79, 0xFF628776, 0xFF4F7664,
    0xFF406755, 0xFF3F6453, 0xFF507564, 0xFF436555, 0xFF496B5B, 0xFF486A5A, 0xFF507061, 0xFF3C5D54, 0xFF3B564D, 0xFF5E6F67, 0xFF727C73, 0xFF999F95, 0xFFE2E6D8, 0xFFE3EADA, 0xFFE1EAD9, 0xFFE6E8DD, 0xFFE9EBE0, 0xFFE9EBE0, 0xFFE9EBE0, 0xFFEAECE1,
    0xFFE8EADF, 0xFFEAECE1, 0xFFF4F6EB, 0xFFF2EFE6, 0xFFE7E7DD, 0xFFEBEDE2, 0xFFEEF1E6, 0xFFE8EEE2, 0xFFE8EEE2, 0xFFE9ECE1, 0xFFE1E4D9, 0xFFE7E8E2, 0xFFC8D4CA, 0xFF779385, 0xFF678E7C, 0xFF4F7664, 0x00859F94, 0x00F9FFFD, 0x00FEFAF9, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFCFD, 0x00F5FFFD, 0xFF6A8B80, 0xFF517B6D, 0xFF6B9486, 0xFF60897B, 0xFF245041, 0xFF265B49, 0xFF598377, 0xFF4B7569, 0xFF2A5448, 0xFF214D40, 0xFF426E61,
    0xFF265245, 0xFF19473A, 0xFF275548, 0xFF617268, 0xFF4B584F, 0xFF6C736C, 0xFFD5D6D1, 0xFFEDE9E6, 0xFFDFDAD7, 0xFFD8D3D0, 0xFFDDD9D6, 0xFFDCDCDC, 0xFFEEF2F1, 0xFFB2BBB8, 0xFF62716C, 0xFF5D726B, 0xFF466158, 0xFF527267, 0xFF3E5F54, 0xFF50675D,
    0xFF576E64, 0xFF476156, 0xFF476357, 0xFF446256, 0xFF466659, 0xFF27493B, 0xFF3F6153, 0xFF5C8575, 0xFF5E8777, 0xFF557E6E, 0xFF618A7A, 0xFF3F6858, 0xFF3F6858, 0xFF416A5A, 0xFF3D6656, 0xFF3D6658, 0xFF40695B, 0xFF426B5D, 0xFF436C5E, 0xFF436C5E,
    0xFF426B5D, 0xFF436C5E, 0xFF446D5F, 0xFF466C5D, 0xFF466C5D, 0xFF466C5D, 0xFF476D5E, 0xFF486E5F, 0xFF486E5F, 0xFF476D5E, 0xFF466C5D, 0xFF466E63, 0xFF466E63, 0xFF476F64, 0xFF487065, 0xFF487065, 0xFF476F64, 0xFF456D62, 0xFF456D62, 0xFF456E5E,
    0xFF456E5E, 0xFF446D5D, 0xFF436C5C, 0xFF426B5B, 0xFF426B5B, 0xFF416A5A, 0xFF416A5A, 0xFF3F695B, 0xFF416B5D, 0xFF446D5F, 0xFF466F61, 0xFF486E61, 0xFF476D60, 0xFF486E61, 0xFF496D61, 0xFF477165, 0xFF466E63, 0xFF487065, 0xFF4A7267, 0xFF4B7166,
    0xFF4D7368, 0xFF50746A, 0xFF4E7268, 0xFF50796B, 0xFF40695B, 0xFF345D4F, 0xFF507969, 0xFF456E5E, 0xFF598270, 0xFF5E8775, 0xFF5E8775, 0xFF5F897B, 0xFF5B8577, 0xFF5D8779, 0xFF679183, 0xFF487264, 0xFF3E685A, 0xFF416B5D, 0xFF1D4739, 0xFF436E5B,
    0xFF3B6452, 0xFF4B705F, 0xFF6B8D7D, 0xFF6A8C7C, 0xFF5C8170, 0xFF426B59, 0xFF3D6855, 0xFF466F5D, 0xFF396451, 0xFF376450, 0xFF3C6955, 0xFF618E7A, 0xFF5B8472, 0xFF587F6D, 0xFF668B7A, 0xFF58816F, 0xFF618A78, 0xFF58816F, 0xFF5B8472, 0xFF598270,
    0xFF598270, 0xFF668F7D, 0xFF5A8371, 0xFF5E8372, 0xFF5B806F, 0xFF5F8473, 0xFF638877, 0xFF618675, 0xFF658A79, 0xFF678C7B, 0xFF608574, 0xFF5D8472, 0xFF5D8472, 0xFF5E8573, 0xFF5F8674, 0xFF608775, 0xFF608775, 0xFF618876, 0xFF618876, 0xFF608774,
    0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5E8572, 0xFF5E8572, 0xFF5E8572, 0xFF5E8572, 0xFF5E8572, 0xFF5E8572, 0xFF5E8572, 0xFF5E8572, 0xFF5E8572, 0xFF5E8572, 0xFF5E8572, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673,
    0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5A8572, 0xFF5E8775, 0xFF5B8472, 0xFF5E8775, 0xFF608775, 0xFF5E8573, 0xFF628776, 0xFF5F8473, 0xFF5E8372, 0xFF628776, 0xFF608574, 0xFF658A79, 0xFF608574, 0xFF5F8473, 0xFF648978, 0xFF547968, 0xFF466D5B,
    0xFF39604E, 0xFF476C5B, 0xFF436857, 0xFF3F6151, 0xFF486A5A, 0xFF416353, 0xFF3E5E4F, 0xFF476D5E, 0xFF46685A, 0xFF5D796D, 0xFF6E8478, 0xFF84988D, 0xFFA8B9AF, 0xFFA6BAAE, 0xFF99ADA1, 0xFF9EB2A6, 0xFF9DB1A5, 0xFF98ACA0, 0xFF99ADA1, 0xFF9DAFA3,
    0xFF96A89C, 0xFF91A397, 0xFF93A599, 0xFF97A399, 0xFF89958B, 0xFF909C92, 0xFF869389, 0xFF85958A, 0xFF9DAFA3, 0xFF9BADA1, 0xFF92A69A, 0xFF99A99E, 0xFF8CA496, 0xFF628776, 0xFF608B78, 0xFF507765, 0x0088A297, 0x00FAFFFC, 0x00FFFDFC, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFCFD, 0x00F6FFFE, 0xFF6A8B80, 0xFF4F796B, 0xFF668F81, 0xFF597F72, 0xFF1E4A3B, 0xFF164938, 0xFF1C4537, 0xFF214A3C, 0xFF0F392B, 0xFF174133, 0xFF224E3F,
    0xFF133F30, 0xFF174334, 0xFF2E5D4D, 0xFF5A7668, 0xFF4F675A, 0xFF55665C, 0xFFB2BDB5, 0xFFE9F0E9, 0xFFE0E7E0, 0xFFD1DBD3, 0xFFD8E2DA, 0xFFE4EDEC, 0xFFE1EBEA, 0xFFA6B6B3, 0xFF687F79, 0xFF5B7971, 0xFF42685D, 0xFF5E887C, 0xFF578578, 0xFF5B7F71,
    0xFF608476, 0xFF5A8071, 0xFF618778, 0xFF537C6C, 0xFF537E6D, 0xFF547F6E, 0xFF669180, 0xFF5E8777, 0xFF5E8777, 0xFF638C7C, 0xFF598272, 0xFF4F7868, 0xFF2C5545, 0xFF497262, 0xFF3C6555, 0xFF426C5E, 0xFF426C5E, 0xFF426C5E, 0xFF426C5E, 0xFF426C5E,
    0xFF416B5D, 0xFF406A5C, 0xFF3F695B, 0xFF426B5B, 0xFF426B5B, 0xFF426B5B, 0xFF436C5C, 0xFF436C5C, 0xFF436C5C, 0xFF426B5B, 0xFF426B5B, 0xFF3D6759, 0xFF3E685A, 0xFF3E685A, 0xFF3E685A, 0xFF3E685A, 0xFF3D6759, 0xFF3C6658, 0xFF3B6557, 0xFF3E6757,
    0xFF3E6757, 0xFF3E6757, 0xFF3D6656, 0xFF3D6656, 0xFF3C6555, 0xFF3C6555, 0xFF3C6555, 0xFF3C6756, 0xFF3D6857, 0xFF3E6958, 0xFF416A5A, 0xFF416A5A, 0xFF426859, 0xFF426859, 0xFF416758, 0xFF3F695B, 0xFF426B5D, 0xFF40695B, 0xFF3F685A, 0xFF43695C,
    0xFF42685B, 0xFF416559, 0xFF416559, 0xFF487163, 0xFF416A5C, 0xFF416A5A, 0xFF365F4F, 0xFF567F6D, 0xFF6B9482, 0xFF648E7A, 0xFF5E8874, 0xFF5F877C, 0xFF60887D, 0xFF60887D, 0xFF4F776C, 0xFF41695E, 0xFF4C7469, 0xFF1E463B, 0xFF345C51, 0xFF44715D,
    0xFF47725F, 0xFF608775, 0xFF648978, 0xFF5E8372, 0xFF678E7C, 0xFF46715E, 0xFF3E6B57, 0xFF406755, 0xFF285340, 0xFF44715D, 0xFF2F5E4A, 0xFF4E7B67, 0xFF5F8A77, 0xFF6C9381, 0xFF618373, 0xFF5D8674, 0xFF628B79, 0xFF5E8775, 0xFF658E7C, 0xFF628B79,
    0xFF598270, 0xFF648D7B, 0xFF638C7A, 0xFF688D7C, 0xFF648978, 0xFF5E8372, 0xFF628776, 0xFF678C7B, 0xFF608574, 0xFF5B806F, 0xFF638877, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF5F8674, 0xFF5F8674, 0xFF5F8674, 0xFF5F8674, 0xFF5F8674, 0xFF5F8673,
    0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5E8572, 0xFF5E8572, 0xFF5E8572, 0xFF5E8572, 0xFF5E8572, 0xFF5E8572, 0xFF5E8572, 0xFF5E8572, 0xFF5E8572, 0xFF5E8572, 0xFF5E8572, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673,
    0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5C8774, 0xFF5E8775, 0xFF5D8674, 0xFF5E8775, 0xFF5F8674, 0xFF5D8472, 0xFF5F8473, 0xFF5E8372, 0xFF628776, 0xFF638877, 0xFF648978, 0xFF608574, 0xFF5F8473, 0xFF5F8473, 0xFF527766, 0xFF416655, 0xFF406755,
    0xFF406755, 0xFF4A6F5E, 0xFF2C5140, 0xFF426454, 0xFF4D6F5F, 0xFF577969, 0xFF4A6A5B, 0xFF396250, 0xFF517866, 0xFF688D7C, 0xFF6C8C7F, 0xFF6F8D81, 0xFF6F8A81, 0xFF6E8980, 0xFF68837A, 0xFF5F8473, 0xFF668878, 0xFF5F8171, 0xFF5B7B6C, 0xFF567566,
    0xFF456455, 0xFF395547, 0xFF304C3E, 0xFF2E4237, 0xFF4B5F54, 0xFF54685D, 0xFF405449, 0xFF53695D, 0xFF6E887B, 0xFF618071, 0xFF5B7D6D, 0xFF648071, 0xFF658776, 0xFF5C8774, 0xFF63907C, 0xFF557C6A, 0x008EA59B, 0x00FAFFFC, 0x00FFFDFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFF, 0x00F8FFFF, 0xFF6A8A7F, 0xFF4F786A, 0xFF688E81, 0xFF5D8376, 0xFF345E50, 0xFF2A5D4C, 0xFF2D5648, 0xFF345D4F, 0xFF315A4C, 0xFF325C4E, 0xFF2D5749,
    0xFF2B5748, 0xFF285445, 0xFF3F6B5C, 0xFF537E6B, 0xFF527967, 0xFF446656, 0xFF718D7F, 0xFF8CA699, 0xFF809A8D, 0xFF7C988A, 0xFF86A596, 0xFF7A8A87, 0xFF899C98, 0xFF78918B, 0xFF45635B, 0xFF3B6156, 0xFF406C5F, 0xFF5D8D7F, 0xFF56897A, 0xFF64907F,
    0xFF5D8978, 0xFF558170, 0xFF618D7C, 0xFF5D8C7A, 0xFF608F7D, 0xFF608F7D, 0xFF558472, 0xFF608979, 0xFF5B8474, 0xFF618A7A, 0xFF5B8474, 0xFF376050, 0xFF487161, 0xFF386151, 0xFF487161, 0xFF3F695B, 0xFF3E685A, 0xFF3E685A, 0xFF3E685A, 0xFF3E685A,
    0xFF3D6759, 0xFF3C6658, 0xFF3B6557, 0xFF3A6554, 0xFF3B6655, 0xFF3C6756, 0xFF3C6756, 0xFF3B6655, 0xFF3B6655, 0xFF3A6554, 0xFF3A6554, 0xFF3D6759, 0xFF3D6759, 0xFF3D6759, 0xFF3D6759, 0xFF3D6759, 0xFF3C6658, 0xFF3B6557, 0xFF3B6557, 0xFF3D6656,
    0xFF3D6656, 0xFF3D6656, 0xFF3E6757, 0xFF3E6757, 0xFF3E6757, 0xFF3F6858, 0xFF3F6858, 0xFF3B6756, 0xFF3C6857, 0xFF3E6958, 0xFF3F6A59, 0xFF416A5A, 0xFF406959, 0xFF416758, 0xFF406657, 0xFF396355, 0xFF426B5D, 0xFF3E6759, 0xFF3D6658, 0xFF486E61,
    0xFF466C5F, 0xFF42665A, 0xFF496D61, 0xFF3C6253, 0xFF416758, 0xFF476D5E, 0xFF587F6D, 0xFF5F8674, 0xFF3F6653, 0xFF456C59, 0xFF4F7663, 0xFF456B5E, 0xFF4B7164, 0xFF4C7265, 0xFF395F52, 0xFF41675A, 0xFF254B3E, 0xFF375D50, 0xFF547A6D, 0xFF3D6A56,
    0xFF5C8573, 0xFF658C7A, 0xFF628474, 0xFF688A7A, 0xFF628977, 0xFF355E4C, 0xFF386551, 0xFF3D6451, 0xFF325C48, 0xFF224C38, 0xFF426C58, 0xFF3E6854, 0xFF3C6350, 0xFF486D5B, 0xFF486A59, 0xFF476E5B, 0xFF436A57, 0xFF476E5B, 0xFF577E6B, 0xFF658C79,
    0xFF658C79, 0xFF5C8370, 0xFF577E6B, 0xFF608574, 0xFF648978, 0xFF608574, 0xFF5C8170, 0xFF608574, 0xFF5F8473, 0xFF5C8170, 0xFF5E8372, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF5F8674, 0xFF5F8674, 0xFF5F8674, 0xFF608774,
    0xFF608774, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5E8572, 0xFF5E8572, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673,
    0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5C8774, 0xFF5E8775, 0xFF608977, 0xFF5F8876, 0xFF5F8674, 0xFF5F8674, 0xFF608574, 0xFF628776, 0xFF618675, 0xFF618675, 0xFF668B7A, 0xFF5B806F, 0xFF648978, 0xFF628776, 0xFF3F6453, 0xFF3B604F, 0xFF3E6553,
    0xFF577E6C, 0xFF4A6F5E, 0xFF3F6453, 0xFF416353, 0xFF456757, 0xFF426454, 0xFF416152, 0xFF4E7864, 0xFF668D7A, 0xFF6C9381, 0xFF567B6A, 0xFF5C7C6F, 0xFF526E62, 0xFF566D63, 0xFF5B7069, 0xFF416A5A, 0xFF4F7868, 0xFF476D5E, 0xFF395D4F, 0xFF305244,
    0xFF2F4F42, 0xFF3C5A4E, 0xFF435F53, 0xFF2D443A, 0xFF576C63, 0xFF52665D, 0xFF3F5048, 0xFF546960, 0xFF698579, 0xFF628678, 0xFF638C7C, 0xFF648675, 0xFF648B78, 0xFF648F7C, 0xFF648F7C, 0xFF527766, 0x008BA097, 0x00FAFFFC, 0x00FFFEFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFF, 0x00F8FFFF, 0xFF69897E, 0xFF517A6C, 0xFF6E9487, 0xFF6C9084, 0xFF5B8577, 0xFF588878, 0xFF688E7F, 0xFF618778, 0xFF5E8777, 0xFF5C8575, 0xFF5A8574,
    0xFF65907F, 0xFF5B8675, 0xFF608C7B, 0xFF548774, 0xFF558673, 0xFF547F6E, 0xFF648A7B, 0xFF5D8374, 0xFF577D6E, 0xFF608979, 0xFF648F7E, 0xFF647F76, 0xFF5D7B71, 0xFF638378, 0xFF53776B, 0xFF578072, 0xFF578374, 0xFF5F8E7E, 0xFF5C8C7C, 0xFF568573,
    0xFF608F7D, 0xFF5D8C7A, 0xFF5B8A78, 0xFF588775, 0xFF54806F, 0xFF5A8675, 0xFF5A8675, 0xFF689181, 0xFF557E6E, 0xFF578070, 0xFF376050, 0xFF396252, 0xFF3C6555, 0xFF4E7767, 0xFF507969, 0xFF578374, 0xFF578374, 0xFF578374, 0xFF578374, 0xFF588475,
    0xFF598576, 0xFF588475, 0xFF588475, 0xFF568271, 0xFF578372, 0xFF588473, 0xFF588473, 0xFF578372, 0xFF568271, 0xFF568271, 0xFF568271, 0xFF54806F, 0xFF54806F, 0xFF54806F, 0xFF537F6E, 0xFF537F6E, 0xFF537F6E, 0xFF537F6E, 0xFF537F6E, 0xFF517C6B,
    0xFF527D6C, 0xFF527D6C, 0xFF537E6D, 0xFF547F6E, 0xFF55806F, 0xFF55806F, 0xFF568170, 0xFF517E6A, 0xFF517E6A, 0xFF527F6B, 0xFF55806D, 0xFF56816E, 0xFF57806E, 0xFF557E6C, 0xFF547D6B, 0xFF4D7867, 0xFF567F6F, 0xFF547D6D, 0xFF527B6B, 0xFF597F70,
    0xFF567C6D, 0xFF537769, 0xFF597D6F, 0xFF587A6C, 0xFF5D7F71, 0xFF5E8070, 0xFF5A7C6C, 0xFF325443, 0xFF4D6F5E, 0xFF4D6F5E, 0xFF40634F, 0xFF517162, 0xFF476758, 0xFF49695A, 0xFF49695A, 0xFF325243, 0xFF2F4F40, 0xFF4B6B5C, 0xFF365647, 0xFF638C7A,
    0xFF69907E, 0xFF5F8171, 0xFF709081, 0xFF608071, 0xFF476959, 0xFF406755, 0xFF3F6856, 0xFF2D5743, 0xFF466D5A, 0xFF385948, 0xFF2A4637, 0xFF466253, 0xFF517060, 0xFF4D6F5E, 0xFF486D5B, 0xFF557766, 0xFF4A6C5B, 0xFF3F6150, 0xFF406251, 0xFF547665,
    0xFF668877, 0xFF688A79, 0xFF688A79, 0xFF658A79, 0xFF5C8170, 0xFF608574, 0xFF688D7C, 0xFF638877, 0xFF5E8372, 0xFF5D8271, 0xFF5B806F, 0xFF5E8573, 0xFF5E8573, 0xFF5F8674, 0xFF5F8674, 0xFF608775, 0xFF618876, 0xFF628977, 0xFF628977, 0xFF608774,
    0xFF608774, 0xFF608774, 0xFF608774, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF608774, 0xFF608774, 0xFF608774, 0xFF608774, 0xFF608774, 0xFF608774, 0xFF608774, 0xFF608774, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673,
    0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5C8774, 0xFF5D8674, 0xFF628B79, 0xFF5E8775, 0xFF5C8371, 0xFF5D8472, 0xFF5E8372, 0xFF648978, 0xFF5E8372, 0xFF5F8473, 0xFF648978, 0xFF5C8170, 0xFF658A79, 0xFF5B806F, 0xFF375C4B, 0xFF406554, 0xFF4C7361,
    0xFF6E9583, 0xFF3F6453, 0xFF4E7362, 0xFF3B5D4D, 0xFF678979, 0xFF628474, 0xFF739384, 0xFF678C7B, 0xFF688D7B, 0xFF6C8E7D, 0xFF4D6E5D, 0xFF637E6F, 0xFF637567, 0xFF616B60, 0xFF666C62, 0xFF3E6352, 0xFF4E7060, 0xFF416152, 0xFF395547, 0xFF365043,
    0xFF3B5145, 0xFF4C6055, 0xFF4F6358, 0xFF526359, 0xFF5D6D63, 0xFF5A655D, 0xFF566058, 0xFF606D64, 0xFF657D70, 0xFF648475, 0xFF5E8775, 0xFF648675, 0xFF648977, 0xFF658C7A, 0xFF638A78, 0xFF517162, 0x00899D94, 0x00F9FFFD, 0x00FFFFFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFCFF, 0x00F8FFFF, 0xFF68867C, 0xFF4F786A, 0xFF698F82, 0xFF64887C, 0xFF618A7C, 0xFF619181, 0xFF658B7C, 0xFF618778, 0xFF688E7F, 0xFF638C7C, 0xFF5A8373,
    0xFF5E8978, 0xFF628D7C, 0xFF669180, 0xFF5E8F7C, 0xFF618D7C, 0xFF689181, 0xFF709687, 0xFF6C9082, 0xFF698F80, 0xFF6B9484, 0xFF689382, 0xFF6A917F, 0xFF688F7D, 0xFF709785, 0xFF69907E, 0xFF68917F, 0xFF618A78, 0xFF668F7D, 0xFF628B79, 0xFF638F7E,
    0xFF5E8A79, 0xFF568271, 0xFF547F6E, 0xFF618C7B, 0xFF5F8878, 0xFF628B7B, 0xFF5D8676, 0xFF5E8777, 0xFF578070, 0xFF376050, 0xFF3E6757, 0xFF3C6555, 0xFF527B6B, 0xFF668F7F, 0xFF658E7E, 0xFF598576, 0xFF598576, 0xFF598576, 0xFF598576, 0xFF598576,
    0xFF598576, 0xFF5A8677, 0xFF5A8677, 0xFF588473, 0xFF598574, 0xFF5B8776, 0xFF5A8675, 0xFF588473, 0xFF578372, 0xFF578372, 0xFF588473, 0xFF598574, 0xFF598574, 0xFF598574, 0xFF598574, 0xFF598574, 0xFF5A8675, 0xFF5A8675, 0xFF5A8675, 0xFF588372,
    0xFF598473, 0xFF598473, 0xFF5A8574, 0xFF5A8574, 0xFF5B8675, 0xFF5B8675, 0xFF5B8675, 0xFF5C8975, 0xFF5B8874, 0xFF5C8975, 0xFF5E8B77, 0xFF618C79, 0xFF618C79, 0xFF608977, 0xFF5F8876, 0xFF5F8A79, 0xFF5D8676, 0xFF5F8878, 0xFF5A8373, 0xFF4F7566,
    0xFF486E5F, 0xFF486C5E, 0xFF44685A, 0xFF496859, 0xFF3E5D4E, 0xFF4E6D5E, 0xFF395848, 0xFF496858, 0xFF325141, 0xFF22412F, 0xFF2C4B39, 0xFF365341, 0xFF2A4735, 0xFF405D4B, 0xFF324F3D, 0xFF2C4937, 0xFF54715F, 0xFF1E3B29, 0xFF3B5846, 0xFF476C5B,
    0xFF547666, 0xFF3E5D4E, 0xFF415D4F, 0xFF3E5A4C, 0xFF385748, 0xFF3C5E4E, 0xFF496E5D, 0xFF5E8B74, 0xFF385B47, 0xFF4F6757, 0xFF404E41, 0xFF546255, 0xFF3B5041, 0xFF2D4C3A, 0xFF284F3A, 0xFF234230, 0xFF335240, 0xFF375644, 0xFF466553, 0xFF4C6B59,
    0xFF446351, 0xFF496856, 0xFF4B6A58, 0xFF4B705F, 0xFF406554, 0xFF456A59, 0xFF597E6D, 0xFF638877, 0xFF5F8473, 0xFF5D8271, 0xFF628776, 0xFF5E8573, 0xFF5E8573, 0xFF5F8674, 0xFF608775, 0xFF618876, 0xFF618876, 0xFF628977, 0xFF628977, 0xFF618875,
    0xFF618875, 0xFF618875, 0xFF608774, 0xFF608774, 0xFF608774, 0xFF608774, 0xFF608774, 0xFF608774, 0xFF608774, 0xFF608774, 0xFF608774, 0xFF608774, 0xFF608774, 0xFF608774, 0xFF608774, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673,
    0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5C8774, 0xFF5C8573, 0xFF618A78, 0xFF58816F, 0xFF517866, 0xFF517866, 0xFF517665, 0xFF5A7F6E, 0xFF5D8271, 0xFF628776, 0xFF5F8473, 0xFF628776, 0xFF5C8170, 0xFF406554, 0xFF315645, 0xFF3D6251, 0xFF3F6654,
    0xFF4C7361, 0xFF325746, 0xFF416655, 0xFF305242, 0xFF527464, 0xFF4D6F5F, 0xFF5C7C6D, 0xFF5A786C, 0xFF4C6B5C, 0xFF668575, 0xFF4F6855, 0xFF657664, 0xFF6B6F5E, 0xFF6B6454, 0xFF786A5D, 0xFF435B4D, 0xFF566E60, 0xFF607468, 0xFF7D8F83, 0xFF94A197,
    0xFF949E95, 0xFF999E97, 0xFF90958E, 0xFF808A81, 0xFF828780, 0xFF9D9C97, 0xFFABA8A3, 0xFFA7AAA3, 0xFF99A69C, 0xFF779283, 0xFF648675, 0xFF6A8677, 0xFF6B8A7A, 0xFF6A8A7B, 0xFF6A8A7B, 0xFF5A7668, 0x008B9F96, 0x00F9FFFD, 0x00F9FEFA, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFCFF, 0x00F7FFFD, 0xFF69877D, 0xFF547A6D, 0xFF6B8F83, 0xFF618579, 0xFF618A7C, 0xFF629282, 0xFF6B9182, 0xFF628879, 0xFF648A7B, 0xFF668F7F, 0xFF638C7C,
    0xFF5E8978, 0xFF65907F, 0xFF5D8877, 0xFF608B7A, 0xFF668C7D, 0xFF67897B, 0xFF648477, 0xFF68867A, 0xFF618174, 0xFF537769, 0xFF577D6E, 0xFF547F6B, 0xFF527D69, 0xFF55806C, 0xFF5F8975, 0xFF688F7C, 0xFF5D8471, 0xFF668B79, 0xFF5F8472, 0xFF618C7B,
    0xFF588372, 0xFF5F8A79, 0xFF5F8878, 0xFF618778, 0xFF5A8071, 0xFF688C7E, 0xFF668A7C, 0xFF557E6E, 0xFF3A6353, 0xFF406959, 0xFF3B6454, 0xFF4E7767, 0xFF638C7C, 0xFF5A8373, 0xFF5C8575, 0xFF5E8A7B, 0xFF5E8A7B, 0xFF5E8A7B, 0xFF5C8879, 0xFF5A8677,
    0xFF598576, 0xFF598576, 0xFF5A8677, 0xFF568573, 0xFF588775, 0xFF598876, 0xFF598876, 0xFF578674, 0xFF558472, 0xFF568573, 0xFF568573, 0xFF588473, 0xFF588473, 0xFF588473, 0xFF588473, 0xFF588473, 0xFF598574, 0xFF5A8675, 0xFF5A8675, 0xFF5A8574,
    0xFF5A8574, 0xFF5A8574, 0xFF5A8574, 0xFF5A8574, 0xFF5A8574, 0xFF5A8574, 0xFF5A8574, 0xFF568571, 0xFF578470, 0xFF588571, 0xFF5A8773, 0xFF5D8875, 0xFF5E8976, 0xFF5D8674, 0xFF5B8472, 0xFF5F8A79, 0xFF557E6E, 0xFF5F8878, 0xFF5E8777, 0xFF476D5E,
    0xFF446A5B, 0xFF4C7062, 0xFF3F6355, 0xFF2B4538, 0xFF385245, 0xFF2F493C, 0xFF4B6657, 0xFF355041, 0xFF2D4837, 0xFF587362, 0xFF5D7867, 0xFF344D3A, 0xFF314A37, 0xFF425B48, 0xFF4F6855, 0xFF4A6350, 0xFF253E2B, 0xFF3D5643, 0xFF607966, 0xFF4A6A5B,
    0xFF2B4A3B, 0xFF3C5649, 0xFF556D60, 0xFF4B6356, 0xFF476154, 0xFF446354, 0xFF69897A, 0xFF5D8A73, 0xFF5C7F6B, 0xFF495B4D, 0xFF696F65, 0xFF7E8178, 0xFF526053, 0xFF274634, 0xFF29533D, 0xFF587362, 0xFF4B6655, 0xFF264130, 0xFF385342, 0xFF425D4C,
    0xFF284332, 0xFF2B4635, 0xFF233E2D, 0xFF375C4B, 0xFF456A59, 0xFF3D6251, 0xFF3E6352, 0xFF5D8271, 0xFF678C7B, 0xFF5C8170, 0xFF5E8372, 0xFF618876, 0xFF618876, 0xFF618876, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF5F8674, 0xFF628976,
    0xFF618875, 0xFF618875, 0xFF618875, 0xFF618875, 0xFF608774, 0xFF608774, 0xFF608774, 0xFF608774, 0xFF608774, 0xFF608774, 0xFF608774, 0xFF608774, 0xFF608774, 0xFF608774, 0xFF608774, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673,
    0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF5C8774, 0xFF5B8472, 0xFF5F8876, 0xFF517A68, 0xFF456C5A, 0xFF426957, 0xFF416655, 0xFF4A6F5E, 0xFF608574, 0xFF678C7B, 0xFF5C8170, 0xFF678C7B, 0xFF507564, 0xFF244938, 0xFF2A4F3E, 0xFF335847, 0xFF2D5442,
    0xFF0F3624, 0xFF254A39, 0xFF284D3C, 0xFF2B4D3D, 0xFF1C3E2E, 0xFF375949, 0xFF5E7E6F, 0xFF769286, 0xFF476355, 0xFF658071, 0xFF536855, 0xFF757E6B, 0xFF86816E, 0xFF83705F, 0xFF8B705F, 0xFF4E5E51, 0xFF5E6E61, 0xFF6B776B, 0xFF91998E, 0xFFA8ABA2,
    0xFFA0A098, 0xFFA5A29B, 0xFFA49F99, 0xFF9B9E95, 0xFF99968F, 0xFFB7AEA9, 0xFFB1A6A2, 0xFFAAA59F, 0xFFA0A89D, 0xFF718677, 0xFF658472, 0xFF6C8476, 0xFF6C8778, 0xFF688476, 0xFF698577, 0xFF5A7467, 0x008B9C94, 0x00F8FFFD, 0x00F5FBF7, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFEFF, 0x00FEFEFF, 0xFF648678, 0xFF50846E, 0xFF688778, 0xFF6C9082, 0xFF3A7060, 0xFF457066, 0xFF446E62, 0xFF497367, 0xFF467064, 0xFF4D776B, 0xFF497367,
    0xFF487266, 0xFF436D61, 0xFF568074, 0xFF638877, 0xFF385849, 0xFF3C5649, 0xFF51675B, 0xFF344C3F, 0xFF234233, 0xFF1B4230, 0xFF204B38, 0xFF20382B, 0xFF233D30, 0xFF294537, 0xFF2E4E41, 0xFF385A4C, 0xFF466C5F, 0xFF668F81, 0xFF5A8476, 0xFF61927F,
    0xFF538471, 0xFF5E8D7B, 0xFF608B7A, 0xFF5B8474, 0xFF648A7B, 0xFF64887A, 0xFF628476, 0xFF487161, 0xFF386151, 0xFF396252, 0xFF517C6B, 0xFF638E7D, 0xFF5F8A79, 0xFF598574, 0xFF5B8776, 0xFF598876, 0xFF598876, 0xFF598876, 0xFF588775, 0xFF588775,
    0xFF578674, 0xFF578674, 0xFF578674, 0xFF5B8778, 0xFF5B8778, 0xFF5A8677, 0xFF5A8677, 0xFF5A8677, 0xFF5A8677, 0xFF598576, 0xFF598576, 0xFF588473, 0xFF578372, 0xFF578372, 0xFF578372, 0xFF588473, 0xFF598574, 0xFF588473, 0xFF578372, 0xFF5A8574,
    0xFF5B8675, 0xFF5B8675, 0xFF5C8776, 0xFF5C8776, 0xFF5B8675, 0xFF5B8675, 0xFF5A8574, 0xFF558472, 0xFF558472, 0xFF598574, 0xFF5A8675, 0xFF5C8776, 0xFF5D8877, 0xFF5D8877, 0xFF5E8777, 0xFF558973, 0xFF5A8B76, 0xFF57826F, 0xFF5D8270, 0xFF436252,
    0xFF4E6958, 0xFF2E4334, 0xFF637567, 0xFF3D6A53, 0xFF576E5E, 0xFF7A7B73, 0xFF797F73, 0xFF223D2A, 0xFF365941, 0xFF3E5541, 0xFF585C4E, 0xFF627A6D, 0xFF69796F, 0xFF727972, 0xFF6B776D, 0xFF445A4D, 0xFF1C3927, 0xFF4A6151, 0xFF344437, 0xFF587B67,
    0xFF55705F, 0xFF5A685B, 0xFF7E847A, 0xFF7A8277, 0xFF384D3E, 0xFF577A66, 0xFF5E8B74, 0xFF618C79, 0xFF5F8876, 0xFF385849, 0xFF4D5A51, 0xFF767571, 0xFF6F706B, 0xFF506459, 0xFF5E8372, 0xFF3F4F42, 0xFF435A4A, 0xFF395443, 0xFF213529, 0xFF5F6B61,
    0xFF606B63, 0xFF4C6457, 0xFF3F6151, 0xFF6D7067, 0xFF3A4237, 0xFF546459, 0xFF395445, 0xFF608071, 0xFF597B6B, 0xFF5F8473, 0xFF5F8375, 0xFF5F8472, 0xFF5F8472, 0xFF5F8472, 0xFF608573, 0xFF608573, 0xFF608573, 0xFF608573, 0xFF618674, 0xFF628977,
    0xFF618876, 0xFF608775, 0xFF608775, 0xFF5F8674, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF618876, 0xFF608775, 0xFF5F8674, 0xFF5E8573, 0xFF5E8573, 0xFF5F8674, 0xFF608775, 0xFF618876, 0xFF628977, 0xFF628977, 0xFF618876, 0xFF608775, 0xFF5E8573,
    0xFF5E8573, 0xFF5F8674, 0xFF618876, 0xFF628C76, 0xFF59836D, 0xFF658B76, 0xFF496C58, 0xFF4A6957, 0xFF385543, 0xFF536E5D, 0xFF445C4C, 0xFF698A7F, 0xFF68867C, 0xFF638175, 0xFF658779, 0xFF4C7563, 0xFF385948, 0xFF636F65, 0xFF675F5C, 0xFF3B604F,
    0xFF19291F, 0xFF474642, 0xFF646962, 0xFF4D6859, 0xFF284936, 0xFF39493C, 0xFF58534D, 0xFF7A6E72, 0xFF657978, 0xFF548278, 0xFF395546, 0xFF82725B, 0xFFBC896C, 0xFFBC8765, 0xFFB9926B, 0xFF666C5E, 0xFF496453, 0xFF5D7C6D, 0xFF888E8A, 0xFFB6ADB0,
    0xFF989795, 0xFFA5A6A1, 0xFFAAA59F, 0xFFBDB7AB, 0xFFB5B6A8, 0xFFA6AA9C, 0xFFABABA1, 0xFFADA8A2, 0xFF9FA29B, 0xFF72887B, 0xFF5E8573, 0xFF628B79, 0xFF658777, 0xFF698879, 0xFF658779, 0xFF527668, 0x0082A096, 0x00F8FFFF, 0x00FFFBFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFEFF, 0x00FEFEFF, 0xFF658779, 0xFF558973, 0xFF6B8A7B, 0xFF5D8173, 0xFF194F3F, 0xFF204B41, 0xFF1B4539, 0xFF184236, 0xFF1B4539, 0xFF1B4539, 0xFF0F392D,
    0xFF1A4438, 0xFF1E483C, 0xFF2E584C, 0xFF587768, 0xFF445C4F, 0xFF4D5D53, 0xFF869088, 0xFF9AA49C, 0xFF9FACA3, 0xFF98ACA1, 0xFF93ADA0, 0xFF92A399, 0xFF9EAFA5, 0xFF687E72, 0xFF354F44, 0xFF38564A, 0xFF426257, 0xFF64887C, 0xFF6C9084, 0xFF618D7C,
    0xFF5E8A79, 0xFF618D7C, 0xFF669180, 0xFF5F8878, 0xFF5C8575, 0xFF587E6F, 0xFF43695A, 0xFF3B6454, 0xFF3F6858, 0xFF4D7666, 0xFF5C8776, 0xFF618C7B, 0xFF5A8675, 0xFF598574, 0xFF5E8A79, 0xFF598876, 0xFF598876, 0xFF598876, 0xFF588775, 0xFF588775,
    0xFF578674, 0xFF578674, 0xFF578674, 0xFF5B8778, 0xFF5A8677, 0xFF5A8677, 0xFF5A8677, 0xFF5A8677, 0xFF598576, 0xFF598576, 0xFF598576, 0xFF598574, 0xFF588473, 0xFF588473, 0xFF588473, 0xFF598574, 0xFF5A8675, 0xFF598574, 0xFF588473, 0xFF5A8574,
    0xFF5A8574, 0xFF5B8675, 0xFF5B8675, 0xFF5B8675, 0xFF5B8675, 0xFF5A8574, 0xFF5A8574, 0xFF548371, 0xFF558472, 0xFF568573, 0xFF5A8675, 0xFF5B8776, 0xFF5C8776, 0xFF5C8776, 0xFF5C8776, 0xFF4F836D, 0xFF568772, 0xFF6A9582, 0xFF5D8471, 0xFF3A5B4A,
    0xFF577263, 0xFF5B7262, 0xFF485D4E, 0xFF27503E, 0xFF5D7165, 0xFF6F726B, 0xFF727971, 0xFF264130, 0xFF355B46, 0xFF55705D, 0xFF5D695B, 0xFF2F4E3F, 0xFF48594F, 0xFF535A53, 0xFF525C53, 0xFF465A4E, 0xFF274334, 0xFF4E6958, 0xFF536859, 0xFF436554,
    0xFF365142, 0xFF4F5F54, 0xFF686F67, 0xFF677168, 0xFF3C5044, 0xFF4C6E5D, 0xFF63907B, 0xFF598471, 0xFF648D7B, 0xFF466657, 0xFF55655B, 0xFF7A7B76, 0xFF6D6F6A, 0xFF3B4F44, 0xFF305544, 0xFF607767, 0xFF4B6856, 0xFF325141, 0xFF2D4336, 0xFF636F65,
    0xFF5C665E, 0xFF51655A, 0xFF2B4B3C, 0xFF526A5A, 0xFF546F5E, 0xFF547564, 0xFF385D4B, 0xFF5F8674, 0xFF668D7B, 0xFF608574, 0xFF5D7F71, 0xFF608573, 0xFF608573, 0xFF608573, 0xFF608573, 0xFF608573, 0xFF618674, 0xFF618674, 0xFF618674, 0xFF618876,
    0xFF618876, 0xFF608775, 0xFF608775, 0xFF5F8674, 0xFF5F8674, 0xFF608775, 0xFF608775, 0xFF618876, 0xFF608775, 0xFF5F8674, 0xFF5E8573, 0xFF5E8573, 0xFF5F8674, 0xFF608775, 0xFF618876, 0xFF608775, 0xFF618876, 0xFF618876, 0xFF608775, 0xFF5F8674,
    0xFF5F8674, 0xFF608775, 0xFF618876, 0xFF618B75, 0xFF5F8973, 0xFF628974, 0xFF476A56, 0xFF456653, 0xFF43604E, 0xFF5C7766, 0xFF496453, 0xFF466F5F, 0xFF628678, 0xFF66887A, 0xFF608977, 0xFF517E6A, 0xFF375E4C, 0xFF57695D, 0xFF656660, 0xFF395B4B,
    0xFF3A4A40, 0xFF8D8C88, 0xFFABB0A9, 0xFF728A7C, 0xFF224131, 0xFF586659, 0xFFAEA9A3, 0xFF9F968D, 0xFF40564A, 0xFF245341, 0xFF476951, 0xFF928D70, 0xFFBC9876, 0xFFCBA882, 0xFFB09872, 0xFF6C7564, 0xFF395640, 0xFF385747, 0xFF616B63, 0xFFA29C9C,
    0xFF959490, 0xFFA6A9A0, 0xFFB0ADA4, 0xFFC5BFB3, 0xFFB3B4A6, 0xFFA3A799, 0xFF9D9D93, 0xFF99948E, 0xFF979A93, 0xFF748A7E, 0xFF638A78, 0xFF618A78, 0xFF658777, 0xFF698879, 0xFF66887A, 0xFF517567, 0x00809E94, 0x00F8FFFF, 0x00FFFCFE, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FCFBFF, 0x00F9F9FB, 0xFF5C7E70, 0xFF528670, 0xFF719081, 0xFF5D8173, 0xFF154B3B, 0xFF275248, 0xFF497367, 0xFF396357, 0xFF244E42, 0xFF295347, 0xFF3F695D,
    0xFF366054, 0xFF123C30, 0xFF366054, 0xFF5F776A, 0xFF4D5E54, 0xFF636A63, 0xFFC9C8C4, 0xFFF2EDEA, 0xFFE5E1DE, 0xFFD9DAD5, 0xFFDEE3DD, 0xFFECF3EC, 0xFFEDF7EF, 0xFF8C978F, 0xFF3E4D46, 0xFF4C6057, 0xFF4C665D, 0xFF567168, 0xFF516F65, 0xFF47675A,
    0xFF49695C, 0xFF406254, 0xFF47695B, 0xFF3E6254, 0xFF3F6556, 0xFF4F7566, 0xFF4C7263, 0xFF3C6555, 0xFF4E7767, 0xFF5E8978, 0xFF628D7C, 0xFF5B8776, 0xFF588473, 0xFF5A8675, 0xFF5C8B79, 0xFF598876, 0xFF598876, 0xFF588775, 0xFF588775, 0xFF588775,
    0xFF588775, 0xFF578674, 0xFF578674, 0xFF5A8677, 0xFF5A8677, 0xFF5A8677, 0xFF5A8677, 0xFF5A8677, 0xFF598576, 0xFF598576, 0xFF598576, 0xFF5A8675, 0xFF598574, 0xFF588473, 0xFF598574, 0xFF5A8675, 0xFF5A8675, 0xFF598574, 0xFF588473, 0xFF5A8574,
    0xFF5A8574, 0xFF5B8675, 0xFF5B8675, 0xFF5B8675, 0xFF5B8675, 0xFF5A8574, 0xFF5A8574, 0xFF548371, 0xFF558472, 0xFF568573, 0xFF598574, 0xFF5A8675, 0xFF5A8675, 0xFF5B8675, 0xFF5B8675, 0xFF598A77, 0xFF578875, 0xFF517E6A, 0xFF5F8674, 0xFF6A8C7B,
    0xFF334F40, 0xFF233B2D, 0xFF4C6454, 0xFF3B5F53, 0xFF3A4B43, 0xFF484D49, 0xFF49544E, 0xFF2D4C3D, 0xFF58816F, 0xFF476958, 0xFF4F6558, 0xFF597F70, 0xFF354C42, 0xFF444B44, 0xFF515650, 0xFF415146, 0xFF3D594A, 0xFF618271, 0xFF436250, 0xFF4C6E60,
    0xFF526E62, 0xFF3C4D45, 0xFF49544E, 0xFF48554E, 0xFF2A3F36, 0xFF5E8072, 0xFF5A8574, 0xFF618A78, 0xFF699280, 0xFF466858, 0xFF3D5146, 0xFF4F544E, 0xFF474E47, 0xFF3D5347, 0xFF517866, 0xFF436250, 0xFF3B5D4C, 0xFF5D8270, 0xFF375243, 0xFF47544B,
    0xFF4A544C, 0xFF374840, 0xFF435F53, 0xFF3B654F, 0xFF1F4B34, 0xFF2D5A45, 0xFF53836D, 0xFF5A8773, 0xFF547D6B, 0xFF608574, 0xFF638577, 0xFF5F8673, 0xFF5F8673, 0xFF5F8673, 0xFF608774, 0xFF608774, 0xFF608774, 0xFF608774, 0xFF608774, 0xFF618876,
    0xFF618876, 0xFF608775, 0xFF5F8674, 0xFF5F8674, 0xFF5F8674, 0xFF608775, 0xFF608775, 0xFF618876, 0xFF608775, 0xFF5F8674, 0xFF5E8573, 0xFF5E8573, 0xFF5F8674, 0xFF608775, 0xFF618876, 0xFF5E8573, 0xFF608775, 0xFF618876, 0xFF618876, 0xFF608775,
    0xFF5F8674, 0xFF608775, 0xFF618876, 0xFF5C8672, 0xFF5D8773, 0xFF658C79, 0xFF5D8270, 0xFF4D6F5E, 0xFF406150, 0xFF537262, 0xFF587465, 0xFF366251, 0xFF53796A, 0xFF5F8473, 0xFF648D7B, 0xFF558470, 0xFF345D4B, 0xFF40584B, 0xFF495049, 0xFF2A483C,
    0xFF29362F, 0xFF63645F, 0xFF6F746E, 0xFF485C50, 0xFF11291B, 0xFF616D63, 0xFFB1ACA6, 0xFF9B9A85, 0xFF38513B, 0xFF4A7A60, 0xFF476C4D, 0xFF7F805E, 0xFFC3AC83, 0xFFC0A97F, 0xFFC6BA90, 0xFF7B8471, 0xFF3C5A42, 0xFF2A4B36, 0xFF5C665D, 0xFFAEA9A5,
    0xFFA7A6A1, 0xFFB2B5AA, 0xFFBDBBAF, 0xFFC7C1B5, 0xFFBABAAE, 0xFFC2C6B8, 0xFFBEBEB4, 0xFFABA6A0, 0xFFA5A8A1, 0xFF768C80, 0xFF577E6C, 0xFF608977, 0xFF658777, 0xFF698879, 0xFF67897B, 0xFF517567, 0x007D9B91, 0x00F8FFFF, 0x00FFFCFE, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFEFF, 0x00FCFCFE, 0xFF587A6C, 0xFF4E826C, 0xFF729182, 0xFF5C8072, 0xFF1A5040, 0xFF3B665C, 0xFF4E786C, 0xFF436D61, 0xFF325C50, 0xFF3F695D, 0xFF608A7E,
    0xFF497367, 0xFF0D372B, 0xFF366054, 0xFF628172, 0xFF4A6054, 0xFF707A72, 0xFFDEDDD9, 0xFFEDE5E3, 0xFFD1C7C6, 0xFFC3BEBB, 0xFFD3CFCC, 0xFFD9D5D2, 0xFFEBEAE6, 0xFFA8AAA5, 0xFF5B645F, 0xFF505D56, 0xFF344741, 0xFF374E46, 0xFF455F56, 0xFF637069,
    0xFF47564F, 0xFF2C3D35, 0xFF33473E, 0xFF3A5147, 0xFF445E53, 0xFF476357, 0xFF486458, 0xFF537E6D, 0xFF5B8675, 0xFF608B7A, 0xFF5D8978, 0xFF598574, 0xFF5A8675, 0xFF598876, 0xFF598876, 0xFF588775, 0xFF588775, 0xFF588775, 0xFF588775, 0xFF588775,
    0xFF588775, 0xFF588775, 0xFF588775, 0xFF588777, 0xFF588777, 0xFF588777, 0xFF588777, 0xFF578676, 0xFF578676, 0xFF578676, 0xFF578676, 0xFF578674, 0xFF568573, 0xFF558472, 0xFF568573, 0xFF578674, 0xFF588775, 0xFF578674, 0xFF568573, 0xFF588473,
    0xFF598574, 0xFF598574, 0xFF598574, 0xFF598574, 0xFF598574, 0xFF598574, 0xFF588473, 0xFF538471, 0xFF548572, 0xFF568573, 0xFF578674, 0xFF5A8675, 0xFF5A8675, 0xFF5A8675, 0xFF5B8675, 0xFF598A77, 0xFF4E7D6B, 0xFF659180, 0xFF668F7D, 0xFF446958,
    0xFF436453, 0xFF516D5E, 0xFF3C5748, 0xFF2A4941, 0xFF364945, 0xFF313A39, 0xFF3F4E49, 0xFF38584D, 0xFF598473, 0xFF5F8878, 0xFF5F8173, 0xFF4D7C6A, 0xFF345246, 0xFF414A45, 0xFF474C46, 0xFF435349, 0xFF426151, 0xFF5C816F, 0xFF5C8370, 0xFF5E8276,
    0xFF4D6B61, 0xFF3F544D, 0xFF3A4B45, 0xFF3A4B45, 0xFF324941, 0xFF517166, 0xFF5C8275, 0xFF5E8372, 0xFF587F6D, 0xFF385A4A, 0xFF385043, 0xFF47524A, 0xFF364139, 0xFF395144, 0xFF5D8472, 0xFF5E8371, 0xFF638D79, 0xFF507A66, 0xFF2C4B3C, 0xFF4A5A50,
    0xFF48514C, 0xFF3F4E47, 0xFF304A3F, 0xFF426350, 0xFF3A5D49, 0xFF3B624F, 0xFF48735F, 0xFF628D7A, 0xFF5C8573, 0xFF5C8371, 0xFF64887A, 0xFF5F8673, 0xFF608774, 0xFF608774, 0xFF608774, 0xFF608774, 0xFF618875, 0xFF618875, 0xFF618875, 0xFF618876,
    0xFF608775, 0xFF608775, 0xFF5F8674, 0xFF5F8674, 0xFF5F8674, 0xFF5F8674, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF5F8674, 0xFF5F8674, 0xFF5F8674, 0xFF5F8674, 0xFF608775, 0xFF608775, 0xFF5D8472, 0xFF5E8573, 0xFF608775, 0xFF618876, 0xFF608775,
    0xFF608775, 0xFF608775, 0xFF618876, 0xFF628C78, 0xFF5B8571, 0xFF5A816E, 0xFF698E7C, 0xFF638876, 0xFF597B6A, 0xFF517362, 0xFF476857, 0xFF59806E, 0xFF486859, 0xFF435F51, 0xFF4D6D5E, 0xFF426957, 0xFF345648, 0xFF42564D, 0xFF464C48, 0xFF314D41,
    0xFF25342D, 0xFF4F5450, 0xFF596059, 0xFF43544A, 0xFF152B1E, 0xFF5D695F, 0xFF7D7C77, 0xFF828A73, 0xFF5F7B64, 0xFF507A62, 0xFF284728, 0xFF787650, 0xFFC7AC81, 0xFFC6AA7B, 0xFFC6B484, 0xFF656E59, 0xFF335137, 0xFF2A4C34, 0xFF606A5F, 0xFFACA7A3,
    0xFFA2A39B, 0xFFB2B6A8, 0xFFCBC9BC, 0xFFC4BDB3, 0xFFB8B8AC, 0xFFCCCFC4, 0xFFC1C1B9, 0xFFA29D99, 0xFFA2A49F, 0xFF788E82, 0xFF5B8172, 0xFF5F8876, 0xFF668878, 0xFF698879, 0xFF688A7C, 0xFF507466, 0x0079978D, 0x00F8FFFF, 0x00FFFDFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFEFF, 0x00FCFCFE, 0xFF5A7C6E, 0xFF4F836D, 0xFF719081, 0xFF597D6F, 0xFF174D3D, 0xFF3C675D, 0xFF2E584C, 0xFF2F594D, 0xFF426C60, 0xFF4A7468, 0xFF477165,
    0xFF446E62, 0xFF234D41, 0xFF345E52, 0xFF678E7C, 0xFF517061, 0xFF819288, 0xFFDDE2DC, 0xFFD7D6D2, 0xFFD2CECB, 0xFFCBCAC6, 0xFFCFD0CB, 0xFFDBD3D1, 0xFFE5E0DD, 0xFFB1B2AD, 0xFF838884, 0xFF828F88, 0xFF596A64, 0xFF516860, 0xFF738D84, 0xFF90908E,
    0xFF70726F, 0xFF5C615D, 0xFF616763, 0xFF6E7772, 0xFF7D8A83, 0xFF57665F, 0xFF4C5B54, 0xFF648F7E, 0xFF5F8A79, 0xFF5A8675, 0xFF598574, 0xFF5B8776, 0xFF5A8977, 0xFF598876, 0xFF598876, 0xFF588775, 0xFF588775, 0xFF588775, 0xFF588775, 0xFF588775,
    0xFF588775, 0xFF588775, 0xFF588775, 0xFF588777, 0xFF588777, 0xFF588777, 0xFF578676, 0xFF578676, 0xFF578676, 0xFF578676, 0xFF568575, 0xFF568573, 0xFF558472, 0xFF548371, 0xFF548371, 0xFF568573, 0xFF568573, 0xFF558472, 0xFF548371, 0xFF588473,
    0xFF588473, 0xFF588473, 0xFF598574, 0xFF598574, 0xFF588473, 0xFF588473, 0xFF588473, 0xFF548572, 0xFF548572, 0xFF558673, 0xFF578674, 0xFF578674, 0xFF5A8675, 0xFF598574, 0xFF598574, 0xFF558575, 0xFF598878, 0xFF578372, 0xFF547F6E, 0xFF3D6452,
    0xFF446656, 0xFF375847, 0xFF4F705F, 0xFF33524C, 0xFF778D8A, 0xFF8E9E9B, 0xFF6D827D, 0xFF315247, 0xFF315B4D, 0xFF386455, 0xFF3E6757, 0xFF2D604F, 0xFF507065, 0xFF98A59E, 0xFFA0A9A4, 0xFF6D8176, 0xFF3B5D4D, 0xFF355F4B, 0xFF396450, 0xFF42685B,
    0xFF395A4F, 0xFF567067, 0xFF859A93, 0xFF80958E, 0xFF476158, 0xFF39594E, 0xFF416559, 0xFF456556, 0xFF3D6251, 0xFF375C4B, 0xFF5F7B6D, 0xFF86968C, 0xFF637369, 0xFF395547, 0xFF335C4A, 0xFF345B48, 0xFF386550, 0xFF2D5A46, 0xFF4A6A5B, 0xFF95A69E,
    0xFF929D97, 0xFF6A7D77, 0xFF28433A, 0xFF596559, 0xFF4D5D50, 0xFF536B5D, 0xFF375646, 0xFF5A7F6E, 0xFF618876, 0xFF658C7A, 0xFF5E8475, 0xFF5D8773, 0xFF5E8874, 0xFF5E8874, 0xFF5E8874, 0xFF5E8874, 0xFF5F8975, 0xFF5F8975, 0xFF5F8975, 0xFF618876,
    0xFF608775, 0xFF5F8674, 0xFF5F8674, 0xFF5F8674, 0xFF5F8674, 0xFF5F8674, 0xFF5F8674, 0xFF608775, 0xFF608775, 0xFF5F8674, 0xFF5F8674, 0xFF5F8674, 0xFF5F8674, 0xFF608775, 0xFF608775, 0xFF5C8371, 0xFF5E8573, 0xFF608775, 0xFF618876, 0xFF608775,
    0xFF5F8674, 0xFF608775, 0xFF608775, 0xFF5C8573, 0xFF638C7A, 0xFF5E8573, 0xFF628977, 0xFF638A78, 0xFF6A917F, 0xFF5D8271, 0xFF406554, 0xFF4D6C5A, 0xFF5B7164, 0xFF5D6D62, 0xFF4D5E54, 0xFF3C564B, 0xFF536D62, 0xFF7A8682, 0xFF878988, 0xFF4F6960,
    0xFF374A44, 0xFF66736C, 0xFF808D86, 0xFF5F7368, 0xFF2C4035, 0xFF7A877D, 0xFF9FA49D, 0xFF768372, 0xFF536D60, 0xFF3E6052, 0xFF213420, 0xFF807555, 0xFFCFAE83, 0xFFCBA679, 0xFFCDAD7E, 0xFF636F59, 0xFF315139, 0xFF254631, 0xFF59655B, 0xFFA4A19C,
    0xFFA2A39B, 0xFFB1B7AB, 0xFFCACABE, 0xFFC1BAB0, 0xFFB9B9AF, 0xFFCED1C6, 0xFFBEBEB6, 0xFF999490, 0xFF999B96, 0xFF758A81, 0xFF5D8374, 0xFF5F8876, 0xFF678979, 0xFF688778, 0xFF6A8C7E, 0xFF517567, 0x0077958B, 0x00F8FFFF, 0x00FFFDFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FCFBFF, 0x00FCFCFE, 0xFF5B7D6F, 0xFF4F836D, 0xFF708F80, 0xFF5B7F71, 0xFF194F3F, 0xFF3A655B, 0xFF467064, 0xFF3E685C, 0xFF3D675B, 0xFF426C60, 0xFF477165,
    0xFF436D61, 0xFF234D41, 0xFF345E52, 0xFF567F6D, 0xFF4A6A5B, 0xFF72867B, 0xFFD1DBD3, 0xFFD5D7D2, 0xFFD6D7D2, 0xFFCED0CB, 0xFFC8CFC8, 0xFFDAD5D2, 0xFFECE8E5, 0xFFB1B3AE, 0xFF929B96, 0xFF8C9B94, 0xFF415850, 0xFF405B52, 0xFF75958A, 0xFF979D99,
    0xFF717773, 0xFF595F5B, 0xFF616A65, 0xFF8E9993, 0xFFB7C2BC, 0xFF74817A, 0xFF4C5952, 0xFF638E7D, 0xFF5B8776, 0xFF588473, 0xFF5B8776, 0xFF5C8B79, 0xFF5A8977, 0xFF588976, 0xFF5A8B78, 0xFF578674, 0xFF578674, 0xFF588775, 0xFF588775, 0xFF588775,
    0xFF588775, 0xFF598876, 0xFF598876, 0xFF578777, 0xFF568676, 0xFF568676, 0xFF568676, 0xFF568676, 0xFF558575, 0xFF558575, 0xFF558575, 0xFF548572, 0xFF538471, 0xFF528370, 0xFF538471, 0xFF548572, 0xFF548572, 0xFF548572, 0xFF528370, 0xFF558472,
    0xFF558472, 0xFF568573, 0xFF568573, 0xFF568573, 0xFF568573, 0xFF558472, 0xFF558472, 0xFF538673, 0xFF538673, 0xFF568774, 0xFF568774, 0xFF588775, 0xFF588775, 0xFF578674, 0xFF598574, 0xFF558575, 0xFF5B8A7A, 0xFF5B8A7A, 0xFF5A8574, 0xFF3B6454,
    0xFF4B7260, 0xFF395E4D, 0xFF4A6F5E, 0xFF486C62, 0xFF67867E, 0xFF8BA69F, 0xFF6A857C, 0xFF46675C, 0xFF4E7767, 0xFF3C6756, 0xFF477261, 0xFF417463, 0xFF496A5F, 0xFF859892, 0xFF91A29A, 0xFF5D796D, 0xFF456C5A, 0xFF4D7865, 0xFF466F5D, 0xFF466C5D,
    0xFF517567, 0xFF608073, 0xFF9BB7AB, 0xFF93ADA2, 0xFF547064, 0xFF5A786C, 0xFF57776A, 0xFF517061, 0xFF507564, 0xFF4B7260, 0xFF618172, 0xFF849A8E, 0xFF6F8378, 0xFF527162, 0xFF466F5D, 0xFF507765, 0xFF406B58, 0xFF45725E, 0xFF47695B, 0xFF556A61,
    0xFF566761, 0xFF587269, 0xFF4D7165, 0xFF70736A, 0xFF414B40, 0xFF586A5E, 0xFF4C6859, 0xFF618373, 0xFF59806E, 0xFF638C7A, 0xFF598272, 0xFF5D8773, 0xFF5D8773, 0xFF5D8773, 0xFF5E8874, 0xFF5E8874, 0xFF5E8874, 0xFF5E8874, 0xFF5E8874, 0xFF608775,
    0xFF608775, 0xFF5F8674, 0xFF5F8674, 0xFF5E8573, 0xFF5E8573, 0xFF5F8674, 0xFF5F8674, 0xFF608775, 0xFF608775, 0xFF5F8674, 0xFF5F8674, 0xFF5F8674, 0xFF5F8674, 0xFF608775, 0xFF608775, 0xFF5D8472, 0xFF5F8674, 0xFF608775, 0xFF608775, 0xFF5F8674,
    0xFF5F8674, 0xFF5F8674, 0xFF608775, 0xFF5B8270, 0xFF638C7A, 0xFF5F8876, 0xFF5D8674, 0xFF5B8472, 0xFF5F8876, 0xFF628B79, 0xFF58816F, 0xFF42624D, 0xFF485D4E, 0xFF556157, 0xFF69766D, 0xFF61766D, 0xFF4F665E, 0xFF5E6D6A, 0xFF989C9D, 0xFF85A097,
    0xFF627C73, 0xFF859A93, 0xFFAEC3BA, 0xFF97ACA3, 0xFF5C7266, 0xFF6D7E74, 0xFF616E65, 0xFF5F7163, 0xFF324C43, 0xFF5A756E, 0xFF526053, 0xFF847D63, 0xFFC5AB88, 0xFFC8AA84, 0xFFCBB18C, 0xFF5B6655, 0xFF4A6A53, 0xFF507261, 0xFF6D7870, 0xFF878382,
    0xFF747671, 0xFF91978D, 0xFFBABAB0, 0xFFB2ABA3, 0xFFACACA2, 0xFFB4B7AE, 0xFFA3A29D, 0xFF87827F, 0xFF898B88, 0xFF6E837A, 0xFF5F8578, 0xFF608977, 0xFF688A7A, 0xFF678677, 0xFF6B8D7F, 0xFF527668, 0x0076948A, 0x00F8FFFF, 0x00FFFDFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFEFF, 0x00FFFFFF, 0xFF5D7F71, 0xFF4E826C, 0xFF6E8D7E, 0xFF5D8173, 0xFF174D3D, 0xFF2B564C, 0xFF568074, 0xFF477165, 0xFF265044, 0xFF305A4E, 0xFF4B7569,
    0xFF3B6559, 0xFF164034, 0xFF376155, 0xFF5A796A, 0xFF71897C, 0xFF7D8880, 0xFFDBDDD8, 0xFFEDE9E6, 0xFFDCDBD7, 0xFFD1D3CE, 0xFFD0D5CF, 0xFFE4E3DF, 0xFFE7E8E3, 0xFF939A93, 0xFF96A59E, 0xFF9CB1A8, 0xFF415F55, 0xFF43675B, 0xFF4F7568, 0xFF476357,
    0xFF4C685C, 0xFF496559, 0xFF496358, 0xFF4B655A, 0xFF637A70, 0xFF4A6157, 0xFF556A61, 0xFF5B8776, 0xFF598574, 0xFF5A8675, 0xFF5A8977, 0xFF5B8A78, 0xFF588976, 0xFF588976, 0xFF598A77, 0xFF578674, 0xFF578674, 0xFF578674, 0xFF588775, 0xFF588775,
    0xFF598876, 0xFF598876, 0xFF598876, 0xFF568676, 0xFF568676, 0xFF568676, 0xFF568676, 0xFF568676, 0xFF558575, 0xFF558575, 0xFF558575, 0xFF558673, 0xFF548572, 0xFF538471, 0xFF538471, 0xFF558673, 0xFF558673, 0xFF548572, 0xFF538471, 0xFF558472,
    0xFF558472, 0xFF568573, 0xFF568573, 0xFF568573, 0xFF568573, 0xFF558472, 0xFF558472, 0xFF538673, 0xFF548774, 0xFF558875, 0xFF578875, 0xFF578875, 0xFF588775, 0xFF588775, 0xFF578674, 0xFF598979, 0xFF548373, 0xFF568575, 0xFF5D897A, 0xFF4B7665,
    0xFF3D6656, 0xFF375E4C, 0xFF3C6351, 0xFF325C4E, 0xFF224B3B, 0xFF092F20, 0xFF1C3E30, 0xFF325444, 0xFF3E6352, 0xFF47715D, 0xFF3A6551, 0xFF3A6959, 0xFF2D5145, 0xFF223931, 0xFF1D372E, 0xFF2B4F41, 0xFF34604F, 0xFF386350, 0xFF456C5A, 0xFF456F5B,
    0xFF335A47, 0xFF2F5140, 0xFF224131, 0xFF1F3E2E, 0xFF345041, 0xFF4B6A5A, 0xFF658474, 0xFF496557, 0xFF496B5B, 0xFF2D5644, 0xFF183A2A, 0xFF203A2D, 0xFF20382B, 0xFF305041, 0xFF3E6956, 0xFF3C5E4E, 0xFF446D5B, 0xFF3C6756, 0xFF3C6052, 0xFF284239,
    0xFF0D241C, 0xFF3B5B50, 0xFF3D695A, 0xFF455A4B, 0xFF465E4E, 0xFF446353, 0xFF416654, 0xFF628B79, 0xFF5C8573, 0xFF567F6D, 0xFF5C8273, 0xFF5D8773, 0xFF5D8773, 0xFF5D8773, 0xFF5D8773, 0xFF5D8773, 0xFF5E8874, 0xFF5E8874, 0xFF5E8874, 0xFF608775,
    0xFF608775, 0xFF5F8674, 0xFF5E8573, 0xFF5E8573, 0xFF5E8573, 0xFF5F8674, 0xFF5F8674, 0xFF5F8674, 0xFF5F8674, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF5F8674, 0xFF5F8674, 0xFF5F8674, 0xFF608775, 0xFF608775, 0xFF5F8674, 0xFF5E8573,
    0xFF5D8472, 0xFF5E8573, 0xFF608775, 0xFF678E7C, 0xFF5A8371, 0xFF537C6A, 0xFF5A8371, 0xFF648F7C, 0xFF5C8774, 0xFF608D79, 0xFF5E8B77, 0xFF3F6951, 0xFF4F6F5A, 0xFF4B6051, 0xFF40564A, 0xFF466458, 0xFF517267, 0xFF39544D, 0xFF354846, 0xFF68887D,
    0xFF37574C, 0xFF224036, 0xFF314C43, 0xFF365045, 0xFF364D43, 0xFF3A5245, 0xFF1C3226, 0xFF50634D, 0xFF435B4D, 0xFF5A756E, 0xFF6C8077, 0xFF7D8170, 0xFF88836D, 0xFFA9A48E, 0xFF8A8977, 0xFF788476, 0xFF5F806D, 0xFF5F8173, 0xFF7E8A86, 0xFF9A989B,
    0xFF898B8A, 0xFF878D89, 0xFF8A8B85, 0xFF989189, 0xFFA0A096, 0xFFAAADA4, 0xFFADACA7, 0xFFA5A09D, 0xFF9FA19E, 0xFF778C85, 0xFF62887B, 0xFF628B79, 0xFF698B7B, 0xFF668576, 0xFF6C8E80, 0xFF54786A, 0x0076948A, 0x00F8FFFF, 0x00FFFCFE, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FBFAFF, 0x00F9F9FB, 0xFF5A7C6E, 0xFF4D816B, 0xFF6F8E7F, 0xFF618577, 0xFF154B3B, 0xFF1D483E, 0xFF1B4539, 0xFF1C463A, 0xFF113B2F, 0xFF194337, 0xFF204A3E,
    0xFF1C463A, 0xFF164034, 0xFF345E52, 0xFF63776C, 0xFFADB8B0, 0xFF999B96, 0xFFDBD6D3, 0xFFF3E9E8, 0xFFE4DCDA, 0xFFE2DEDB, 0xFFE1E2DD, 0xFFE7E8E3, 0xFFF3F8F2, 0xFFA6B1A9, 0xFFBDD1C8, 0xFFA7C3B7, 0xFF436459, 0xFF668F81, 0xFF558172, 0xFF598A77,
    0xFF608F7D, 0xFF598574, 0xFF65907F, 0xFF5E8777, 0xFF5F8375, 0xFF517365, 0xFF688A7C, 0xFF5B8776, 0xFF5B8776, 0xFF598876, 0xFF578674, 0xFF578674, 0xFF578875, 0xFF578875, 0xFF568774, 0xFF578674, 0xFF578674, 0xFF578674, 0xFF588775, 0xFF588775,
    0xFF598876, 0xFF598876, 0xFF598876, 0xFF568676, 0xFF568676, 0xFF568676, 0xFF568676, 0xFF558575, 0xFF558575, 0xFF558575, 0xFF558575, 0xFF568774, 0xFF558673, 0xFF548572, 0xFF548572, 0xFF568774, 0xFF568774, 0xFF558673, 0xFF548572, 0xFF548371,
    0xFF558472, 0xFF558472, 0xFF568573, 0xFF568573, 0xFF558472, 0xFF558472, 0xFF548371, 0xFF548774, 0xFF548774, 0xFF558875, 0xFF588976, 0xFF588976, 0xFF588775, 0xFF588775, 0xFF578674, 0xFF538375, 0xFF578676, 0xFF528171, 0xFF537F70, 0xFF679281,
    0xFF4C7766, 0xFF58816F, 0xFF58816F, 0xFF4E7F6C, 0xFF3A6955, 0xFF3F6A57, 0xFF406755, 0xFF507261, 0xFF668877, 0xFF618873, 0xFF618B75, 0xFF5C887B, 0xFF4C6D62, 0xFF4A655C, 0xFF4A6A5F, 0xFF446F5E, 0xFF51826F, 0xFF628D7A, 0xFF648676, 0xFF618B75,
    0xFF5C836E, 0xFF406651, 0xFF40634F, 0xFF42614F, 0xFF4B6A58, 0xFF698674, 0xFF63806E, 0xFF6C8679, 0xFF688A7A, 0xFF4E7765, 0xFF385D4C, 0xFF446052, 0xFF455D50, 0xFF537364, 0xFF5B8673, 0xFF698879, 0xFF5F8473, 0xFF5C8575, 0xFF486C5E, 0xFF4D685F,
    0xFF4B655C, 0xFF456B5E, 0xFF4B7E6F, 0xFF5B856F, 0xFF537F68, 0xFF45755F, 0xFF5D8E78, 0xFF598874, 0xFF588571, 0xFF608977, 0xFF5E8475, 0xFF5B8672, 0xFF5B8672, 0xFF5B8672, 0xFF5C8773, 0xFF5C8773, 0xFF5C8773, 0xFF5C8773, 0xFF5D8874, 0xFF608775,
    0xFF608775, 0xFF5F8674, 0xFF5E8573, 0xFF5E8573, 0xFF5E8573, 0xFF5E8573, 0xFF5F8674, 0xFF5F8674, 0xFF5F8674, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF5F8674, 0xFF5F8674, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF5F8674, 0xFF5D8472,
    0xFF5D8472, 0xFF5E8573, 0xFF608775, 0xFF5D8374, 0xFF5C8575, 0xFF608979, 0xFF5A8574, 0xFF648F7E, 0xFF578372, 0xFF608C7B, 0xFF598876, 0xFF538A6B, 0xFF4E7860, 0xFF5A7967, 0xFF628372, 0xFF4F7868, 0xFF437164, 0xFF335D53, 0xFF42635C, 0xFF44655C,
    0xFF3B5F53, 0xFF34584C, 0xFF3B5C51, 0xFF345246, 0xFF3B554A, 0xFF425C4F, 0xFF3B5749, 0xFF576A4A, 0xFF465F49, 0xFF557367, 0xFF4F6A61, 0xFF54685C, 0xFF485A4A, 0xFF4F6559, 0xFF4D6863, 0xFF5C685C, 0xFF547465, 0xFF65867B, 0xFF859191, 0xFF97959A,
    0xFF848587, 0xFF848A88, 0xFF838381, 0xFFA49D95, 0xFFA9A9A1, 0xFFA1A49B, 0xFFA2A19C, 0xFFA49F9C, 0xFF9C9E9B, 0xFF738881, 0xFF5F8578, 0xFF638C7A, 0xFF6A8C7C, 0xFF658475, 0xFF6C8E80, 0xFF55796B, 0x0076948A, 0x00F8FFFF, 0x00FFFCFE, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFF8FB, 0x04F4FFFC, 0xFF5A7E72, 0xFF548373, 0xFF638F80, 0xFF587E71, 0xFF386153, 0xFF305C4D, 0xFF345B49, 0xFF2F5644, 0xFF2E5543, 0xFF315846, 0xFF345B49,
    0xFF335A48, 0xFF345B49, 0xFF3E6553, 0xFF527A6F, 0xFF5E867B, 0xFF6C9489, 0xFF88B0A5, 0xFF82AA9F, 0xFF6A9287, 0xFF78A095, 0xFF83ABA0, 0xFF638B80, 0xFF7CA499, 0xFF9BC3B8, 0xFF9CC4B9, 0xFF86AEA3, 0xFF497166, 0xFF5A8277, 0xFF60887D, 0xFF5F8B7C,
    0xFF5F8B7C, 0xFF5F8B7C, 0xFF5E8A7B, 0xFF5E8A7B, 0xFF5E8A7B, 0xFF5E8A7B, 0xFF5D897A, 0xFF598878, 0xFF598878, 0xFF598878, 0xFF588878, 0xFF588878, 0xFF588878, 0xFF568978, 0xFF568978, 0xFF558575, 0xFF568676, 0xFF578777, 0xFF578777, 0xFF578777,
    0xFF578777, 0xFF568676, 0xFF558575, 0xFF588475, 0xFF598878, 0xFF558474, 0xFF528272, 0xFF558575, 0xFF538675, 0xFF528775, 0xFF528775, 0xFF518171, 0xFF598979, 0xFF568676, 0xFF508070, 0xFF558575, 0xFF578777, 0xFF528272, 0xFF538373, 0xFF528171,
    0xFF588777, 0xFF588777, 0xFF558474, 0xFF598878, 0xFF588777, 0xFF518070, 0xFF538272, 0xFF528272, 0xFF538373, 0xFF548474, 0xFF568575, 0xFF578676, 0xFF598576, 0xFF598576, 0xFF598576, 0xFF568676, 0xFF558575, 0xFF558575, 0xFF548474, 0xFF548474,
    0xFF558575, 0xFF558575, 0xFF568676, 0xFF5E8A79, 0xFF5E8A79, 0xFF5D8978, 0xFF5C8877, 0xFF5B8776, 0xFF5B8776, 0xFF5A8675, 0xFF5A8675, 0xFF598471, 0xFF5A8572, 0xFF608B78, 0xFF638C7C, 0xFF5F8878, 0xFF5D8678, 0xFF5F8578, 0xFF5C8275, 0xFF58816F,
    0xFF537C6A, 0xFF5C8573, 0xFF668F7D, 0xFF628B79, 0xFF5E8775, 0xFF5E8775, 0xFF598270, 0xFF5A8373, 0xFF598272, 0xFF5C8575, 0xFF608977, 0xFF5D8674, 0xFF5F8975, 0xFF618B77, 0xFF58826E, 0xFF56816E, 0xFF588370, 0xFF5A8572, 0xFF5C8774, 0xFF5D8875,
    0xFF5C8774, 0xFF5B8673, 0xFF5A8572, 0xFF5D8875, 0xFF5D8875, 0xFF5C8774, 0xFF5B8673, 0xFF5B8673, 0xFF5A8572, 0xFF598471, 0xFF598471, 0xFF5C8774, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5E8976,
    0xFF5E8976, 0xFF5C8774, 0xFF598471, 0xFF5B8673, 0xFF5B8673, 0xFF57826F, 0xFF5A8572, 0xFF588372, 0xFF5B8675, 0xFF5E8978, 0xFF598473, 0xFF547F6E, 0xFF5E8978, 0xFF5C8776, 0xFF608B7A, 0xFF5C8974, 0xFF5C8974, 0xFF5B8874, 0xFF5B8673, 0xFF5C8573,
    0xFF5B8474, 0xFF608677, 0xFF668C7D, 0xFF5C8573, 0xFF5D8674, 0xFF5E8775, 0xFF5F8876, 0xFF5E8775, 0xFF5D8674, 0xFF5B8472, 0xFF5A8371, 0xFF5F8876, 0xFF608977, 0xFF618A78, 0xFF628B79, 0xFF618A78, 0xFF5E8775, 0xFF5C8573, 0xFF5A8371, 0xFF628473,
    0xFF638574, 0xFF658776, 0xFF698A77, 0xFF6A8B78, 0xFF688873, 0xFF62826D, 0xFF5D7D68, 0xFF5D735E, 0xFF5D7460, 0xFF6D8472, 0xFF466150, 0xFF3A5648, 0xFF28463A, 0xFF35544C, 0xFF34534B, 0xFF456357, 0xFF607C70, 0xFF758F84, 0xFF72867D, 0xFF75847D,
    0xFF858E89, 0xFF8E938F, 0xFF80827F, 0xFF848D88, 0xFF7B8680, 0xFF84918A, 0xFF7C8D85, 0xFF6D8279, 0xFF7E988D, 0xFF6F8D81, 0xFF6B897D, 0xFF608D79, 0xFF628977, 0xFF678979, 0xFF65897B, 0xFF53796A, 0x00749288, 0x00F8FFFF, 0x00FFFDFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFCFF, 0x00F5FFFD, 0xFF577B6F, 0xFF518070, 0xFF679384, 0xFF6A9083, 0xFF5D8678, 0xFF608C7D, 0xFF638A78, 0xFF638A78, 0xFF658C7A, 0xFF668D7B, 0xFF648B79,
    0xFF5F8674, 0xFF5E8573, 0xFF628977, 0xFF598176, 0xFF577F74, 0xFF537B70, 0xFF60887D, 0xFF5C8479, 0xFF527A6F, 0xFF60887D, 0xFF60887D, 0xFF598176, 0xFF567E73, 0xFF557D72, 0xFF567E73, 0xFF5C8479, 0xFF4B7368, 0xFF648C81, 0xFF648C81, 0xFF5D897A,
    0xFF5D897A, 0xFF5D897A, 0xFF5C8879, 0xFF5C8879, 0xFF5C8879, 0xFF5C8879, 0xFF5B8778, 0xFF5A8979, 0xFF5A8979, 0xFF598878, 0xFF578777, 0xFF578777, 0xFF568676, 0xFF548776, 0xFF538675, 0xFF568676, 0xFF568676, 0xFF568676, 0xFF578777, 0xFF578777,
    0xFF568676, 0xFF568676, 0xFF568676, 0xFF528171, 0xFF578676, 0xFF588777, 0xFF578777, 0xFF568676, 0xFF518473, 0xFF4E8170, 0xFF4B7E6D, 0xFF578777, 0xFF548474, 0xFF558575, 0xFF538373, 0xFF538373, 0xFF568676, 0xFF538373, 0xFF548474, 0xFF5A8979,
    0xFF598878, 0xFF548373, 0xFF507F6F, 0xFF548373, 0xFF548373, 0xFF548373, 0xFF5B8A7A, 0xFF538373, 0xFF538373, 0xFF548474, 0xFF578676, 0xFF578676, 0xFF5A8677, 0xFF5A8677, 0xFF5A8677, 0xFF568676, 0xFF558575, 0xFF558575, 0xFF548474, 0xFF548474,
    0xFF558575, 0xFF558575, 0xFF568676, 0xFF5A8675, 0xFF598574, 0xFF598574, 0xFF588473, 0xFF588473, 0xFF578372, 0xFF578372, 0xFF578372, 0xFF5E8976, 0xFF5B8673, 0xFF5B8673, 0xFF5D8676, 0xFF5B8474, 0xFF5A8375, 0xFF5A8073, 0xFF587E71, 0xFF618A78,
    0xFF5E8775, 0xFF5B8472, 0xFF5A8371, 0xFF5B8472, 0xFF5C8573, 0xFF5C8573, 0xFF5A8371, 0xFF5C8575, 0xFF588171, 0xFF598272, 0xFF5C8573, 0xFF5A8371, 0xFF5B8571, 0xFF5E8874, 0xFF59836F, 0xFF598471, 0xFF598471, 0xFF5A8572, 0xFF5A8572, 0xFF5A8572,
    0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5C8774, 0xFF5C8774, 0xFF5B8673, 0xFF5B8673, 0xFF5A8572, 0xFF5A8572, 0xFF5A8572, 0xFF5A8572, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF608977,
    0xFF5D8674, 0xFF5B8472, 0xFF5B8472, 0xFF5D8674, 0xFF5B8472, 0xFF5B8472, 0xFF608977, 0xFF5D8676, 0xFF5B8474, 0xFF5D8676, 0xFF5D8676, 0xFF608979, 0xFF608979, 0xFF5B8474, 0xFF588171, 0xFF588570, 0xFF5D8874, 0xFF5D8875, 0xFF5D8875, 0xFF5F8876,
    0xFF5D8676, 0xFF5C8273, 0xFF5D8374, 0xFF5D8674, 0xFF5E8775, 0xFF5E8775, 0xFF5F8876, 0xFF5E8775, 0xFF5D8674, 0xFF5C8573, 0xFF5B8472, 0xFF5C8573, 0xFF5D8674, 0xFF5E8775, 0xFF5F8876, 0xFF5F8876, 0xFF5E8775, 0xFF5D8674, 0xFF5D8674, 0xFF5F8674,
    0xFF608573, 0xFF618674, 0xFF648977, 0xFF678A76, 0xFF668975, 0xFF648570, 0xFF61826D, 0xFF637C67, 0xFF637F69, 0xFF6E8976, 0xFF557260, 0xFF527162, 0xFF4D6D60, 0xFF517267, 0xFF4B6C63, 0xFF4C6E60, 0xFF668679, 0xFF6D897D, 0xFF5C7369, 0xFF52665D,
    0xFF59665F, 0xFF7B8680, 0xFF707974, 0xFF6D7A73, 0xFF4F5E57, 0xFF4F6058, 0xFF4E635A, 0xFF466055, 0xFF638175, 0xFF67877A, 0xFF688A7C, 0xFF608D79, 0xFF628977, 0xFF678979, 0xFF65897B, 0xFF53796A, 0x00749288, 0x00F8FFFF, 0x00FFFDFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFCFF, 0x04F4FFFC, 0xFF577B6F, 0xFF4F7E6E, 0xFF628E7F, 0xFF678D80, 0xFF5E8779, 0xFF638F80, 0xFF628B79, 0xFF628B79, 0xFF638C7A, 0xFF628B79, 0xFF5F8876,
    0xFF5F8876, 0xFF628B79, 0xFF618A78, 0xFF668E83, 0xFF699186, 0xFF5D857A, 0xFF61897E, 0xFF678F84, 0xFF658D82, 0xFF6B9388, 0xFF678F84, 0xFF678F84, 0xFF648C81, 0xFF5F877C, 0xFF61897E, 0xFF668E83, 0xFF61897E, 0xFF6A9287, 0xFF5E867B, 0xFF5D897A,
    0xFF5D897A, 0xFF5D897A, 0xFF5D897A, 0xFF5C8879, 0xFF5C8879, 0xFF5C8879, 0xFF5C8879, 0xFF5A8979, 0xFF5A8979, 0xFF598878, 0xFF578777, 0xFF568676, 0xFF558575, 0xFF528574, 0xFF528574, 0xFF578777, 0xFF568676, 0xFF568676, 0xFF568676, 0xFF568676,
    0xFF568676, 0xFF568676, 0xFF578777, 0xFF578676, 0xFF598878, 0xFF598878, 0xFF578676, 0xFF578777, 0xFF588878, 0xFF578777, 0xFF588878, 0xFF5B8A7A, 0xFF518070, 0xFF548373, 0xFF538272, 0xFF528171, 0xFF568575, 0xFF548373, 0xFF568575, 0xFF578676,
    0xFF558474, 0xFF548373, 0xFF568575, 0xFF5B8A7A, 0xFF568575, 0xFF548373, 0xFF538272, 0xFF538373, 0xFF548474, 0xFF558575, 0xFF578676, 0xFF588777, 0xFF5B8778, 0xFF5B8778, 0xFF5B8778, 0xFF568676, 0xFF568676, 0xFF558575, 0xFF558575, 0xFF558575,
    0xFF558575, 0xFF568676, 0xFF568676, 0xFF578372, 0xFF578372, 0xFF578372, 0xFF578372, 0xFF568271, 0xFF568271, 0xFF568271, 0xFF568271, 0xFF5C8774, 0xFF57826F, 0xFF537E6B, 0xFF598272, 0xFF588171, 0xFF5A8375, 0xFF5A8073, 0xFF5B8174, 0xFF57806E,
    0xFF5E8775, 0xFF5E8775, 0xFF598270, 0xFF598270, 0xFF598270, 0xFF5A8371, 0xFF5F8876, 0xFF5B8476, 0xFF598272, 0xFF5B8474, 0xFF5C8575, 0xFF5A8371, 0xFF5A8371, 0xFF5C8672, 0xFF5E8874, 0xFF5C8774, 0xFF5A8572, 0xFF598471, 0xFF588370, 0xFF588370,
    0xFF598471, 0xFF5B8673, 0xFF5C8774, 0xFF5B8673, 0xFF5B8673, 0xFF5A8572, 0xFF5A8572, 0xFF5A8572, 0xFF5A8572, 0xFF5A8572, 0xFF5A8572, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5E8775,
    0xFF5D8674, 0xFF5C8573, 0xFF5F8876, 0xFF608977, 0xFF5C8573, 0xFF5B8472, 0xFF5E8775, 0xFF5F8878, 0xFF5A8373, 0xFF598272, 0xFF598272, 0xFF608979, 0xFF5A8373, 0xFF5F8878, 0xFF5C8575, 0xFF5D8773, 0xFF608A76, 0xFF5B8472, 0xFF598270, 0xFF598270,
    0xFF5C8575, 0xFF5B8474, 0xFF5E8777, 0xFF5E8775, 0xFF5E8775, 0xFF5E8775, 0xFF5E8775, 0xFF5E8775, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5B8472, 0xFF5C8573, 0xFF5C8573, 0xFF5C8573, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5C8774,
    0xFF5C8774, 0xFF5D8773, 0xFF5E8874, 0xFF628974, 0xFF638A75, 0xFF638A75, 0xFF648A73, 0xFF698974, 0xFF698A75, 0xFF6E8F7C, 0xFF628473, 0xFF658777, 0xFF6B8F81, 0xFF688E81, 0xFF658B7E, 0xFF5F8576, 0xFF6F9385, 0xFF6B8D7F, 0xFF5F7D71, 0xFF5C766B,
    0xFF576C63, 0xFF7B8F86, 0xFF62736B, 0xFF6D8279, 0xFF4A5F56, 0xFF41584E, 0xFF456155, 0xFF3E5E51, 0xFF5B7D6F, 0xFF65897B, 0xFF678D7E, 0xFF608D79, 0xFF628977, 0xFF678979, 0xFF65897B, 0xFF53796A, 0x00749288, 0x00F8FFFF, 0x00FFFDFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFAFD, 0x04F4FFFC, 0xFF5B7F73, 0xFF548373, 0xFF649081, 0xFF678D80, 0xFF5D8678, 0xFF608C7D, 0xFF618A7A, 0xFF618A7A, 0xFF608979, 0xFF618A7A, 0xFF5F8878,
    0xFF648D7D, 0xFF668F7F, 0xFF578070, 0xFF568074, 0xFF648E82, 0xFF5D877B, 0xFF5D877B, 0xFF669084, 0xFF638D81, 0xFF628C80, 0xFF628C80, 0xFF628C80, 0xFF638D81, 0xFF628C80, 0xFF608A7E, 0xFF5C867A, 0xFF578175, 0xFF5D877B, 0xFF5E887C, 0xFF608C7D,
    0xFF608C7D, 0xFF5F8B7C, 0xFF5F8B7C, 0xFF5F8B7C, 0xFF5F8B7C, 0xFF5E8A7B, 0xFF5E8A7B, 0xFF5A8979, 0xFF5A8979, 0xFF598878, 0xFF588878, 0xFF578777, 0xFF568676, 0xFF538675, 0xFF538675, 0xFF578777, 0xFF578777, 0xFF568676, 0xFF558575, 0xFF558575,
    0xFF568676, 0xFF578777, 0xFF578777, 0xFF558575, 0xFF538373, 0xFF548373, 0xFF558474, 0xFF5A8979, 0xFF5A8979, 0xFF538272, 0xFF588475, 0xFF598576, 0xFF558172, 0xFF5A8677, 0xFF598576, 0xFF5B8778, 0xFF5E8A7B, 0xFF588475, 0xFF588475, 0xFF5D897A,
    0xFF5B8778, 0xFF5B8778, 0xFF5A8677, 0xFF5E8A7B, 0xFF5A8677, 0xFF618D7E, 0xFF5C8879, 0xFF548474, 0xFF558575, 0xFF568676, 0xFF588777, 0xFF598878, 0xFF5B8778, 0xFF5B8778, 0xFF5B8778, 0xFF578777, 0xFF568676, 0xFF568676, 0xFF558575, 0xFF558575,
    0xFF568676, 0xFF568676, 0xFF578777, 0xFF588473, 0xFF588473, 0xFF588473, 0xFF598574, 0xFF598574, 0xFF598574, 0xFF5A8675, 0xFF5A8675, 0xFF5E8976, 0xFF5D8875, 0xFF5D8875, 0xFF648D7D, 0xFF5C8575, 0xFF5F887A, 0xFF62887B, 0xFF668C7F, 0xFF608979,
    0xFF648D7D, 0xFF668F7F, 0xFF658E7E, 0xFF638C7C, 0xFF618A7A, 0xFF618A7A, 0xFF618A7A, 0xFF618A7C, 0xFF60897B, 0xFF618A7C, 0xFF5D8676, 0xFF5D8676, 0xFF5D8674, 0xFF598270, 0xFF5E8775, 0xFF5C8774, 0xFF5B8673, 0xFF5A8572, 0xFF588370, 0xFF588370,
    0xFF598471, 0xFF5A8572, 0xFF5B8673, 0xFF5A8572, 0xFF5A8572, 0xFF5A8572, 0xFF5A8572, 0xFF5A8572, 0xFF5A8572, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5C8774, 0xFF5C8774, 0xFF5C8774, 0xFF5C8774, 0xFF5C8774, 0xFF5D8674,
    0xFF628B79, 0xFF5D8674, 0xFF5E8775, 0xFF638C7A, 0xFF618A78, 0xFF608977, 0xFF5F8876, 0xFF628B79, 0xFF628B79, 0xFF618A78, 0xFF5B8472, 0xFF5E8775, 0xFF57806E, 0xFF628B79, 0xFF628B79, 0xFF5E8572, 0xFF628976, 0xFF5F8674, 0xFF618876, 0xFF598270,
    0xFF5D8676, 0xFF5C8575, 0xFF608979, 0xFF5F8876, 0xFF5F8876, 0xFF5E8775, 0xFF5E8775, 0xFF5E8775, 0xFF5E8775, 0xFF5E8775, 0xFF5E8775, 0xFF5F8876, 0xFF5E8775, 0xFF5D8674, 0xFF5C8573, 0xFF5B8472, 0xFF5B8472, 0xFF5B8472, 0xFF5B8472, 0xFF5B8874,
    0xFF5B8874, 0xFF5B8874, 0xFF5D8874, 0xFF5F8A76, 0xFF608C75, 0xFF628C76, 0xFF638D77, 0xFF69907B, 0xFF688F7A, 0xFF6A917E, 0xFF6A917F, 0xFF668D7B, 0xFF6A9383, 0xFF638C7E, 0xFF668F81, 0xFF6C9786, 0xFF689382, 0xFF658B7C, 0xFF5F8375, 0xFF648477,
    0xFF5C7A6E, 0xFF7B958A, 0xFF617B70, 0xFF688476, 0xFF5B7A6B, 0xFF577768, 0xFF5C7E6E, 0xFF527766, 0xFF5F8674, 0xFF5F8876, 0xFF5F8876, 0xFF608D79, 0xFF628977, 0xFF678979, 0xFF65897B, 0xFF53796A, 0x00749288, 0x00F8FFFF, 0x00FFFDFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFCFF, 0x04F4FFFC, 0xFF5A7E72, 0xFF538272, 0xFF618D7E, 0xFF668C7F, 0xFF618A7C, 0xFF659182, 0xFF5E8777, 0xFF5E8777, 0xFF5E8777, 0xFF638C7C, 0xFF618A7A,
    0xFF638C7C, 0xFF5A8373, 0xFF345D4D, 0xFF1D473B, 0xFF224C40, 0xFF224C40, 0xFF234D41, 0xFF214B3F, 0xFF214B3F, 0xFF265044, 0xFF224C40, 0xFF214B3F, 0xFF1F493D, 0xFF254F43, 0xFF265044, 0xFF2D574B, 0xFF224C40, 0xFF224C40, 0xFF2F594D, 0xFF5F8B7C,
    0xFF5F8B7C, 0xFF5F8B7C, 0xFF5F8B7C, 0xFF5F8B7C, 0xFF5E8A7B, 0xFF5E8A7B, 0xFF5E8A7B, 0xFF5A8979, 0xFF5A8979, 0xFF598878, 0xFF588878, 0xFF588878, 0xFF588878, 0xFF568978, 0xFF568978, 0xFF578777, 0xFF578777, 0xFF568676, 0xFF558575, 0xFF558575,
    0xFF568676, 0xFF578777, 0xFF578777, 0xFF5C8C7C, 0xFF598979, 0xFF588878, 0xFF598878, 0xFF5D897A, 0xFF467263, 0xFF244E40, 0xFF214B3D, 0xFF224E3F, 0xFF255142, 0xFF204C3D, 0xFF1D493A, 0xFF224E3F, 0xFF265243, 0xFF255142, 0xFF275344, 0xFF285445,
    0xFF275344, 0xFF285445, 0xFF214D3E, 0xFF214D3E, 0xFF275344, 0xFF507C6D, 0xFF5D897A, 0xFF548474, 0xFF558575, 0xFF568676, 0xFF588777, 0xFF598878, 0xFF5B8778, 0xFF5C8879, 0xFF5B8778, 0xFF578777, 0xFF578777, 0xFF568676, 0xFF568676, 0xFF568676,
    0xFF568676, 0xFF578777, 0xFF578777, 0xFF598574, 0xFF5A8675, 0xFF5A8675, 0xFF5A8675, 0xFF5B8776, 0xFF5B8776, 0xFF5C8877, 0xFF5C8877, 0xFF5B8673, 0xFF5B8673, 0xFF5A8572, 0xFF567F6F, 0xFF335C4C, 0xFF2F584A, 0xFF305649, 0xFF305649, 0xFF355E4E,
    0xFF2C5545, 0xFF2B5444, 0xFF305949, 0xFF325B4B, 0xFF335C4C, 0xFF325B4B, 0xFF2E5747, 0xFF30584D, 0xFF2F584A, 0xFF2E5749, 0xFF2D5648, 0xFF456E5E, 0xFF5D8676, 0xFF5B8472, 0xFF5E8775, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5A8572, 0xFF5A8572,
    0xFF5A8572, 0xFF5A8572, 0xFF5A8572, 0xFF5A8572, 0xFF5A8572, 0xFF5A8572, 0xFF5A8572, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5C8774, 0xFF5C8774, 0xFF5C8774, 0xFF5D8875, 0xFF5D8875, 0xFF5E8573,
    0xFF618876, 0xFF456C5A, 0xFF345B49, 0xFF385F4D, 0xFF385F4D, 0xFF385F4D, 0xFF365D4B, 0xFF355C4A, 0xFF3A614F, 0xFF3B6250, 0xFF385F4D, 0xFF355C4A, 0xFF345B49, 0xFF365D4B, 0xFF345B49, 0xFF315342, 0xFF355A48, 0xFF476C5B, 0xFF628977, 0xFF5E8573,
    0xFF5F8878, 0xFF5A8574, 0xFF5D8877, 0xFF5E8775, 0xFF5E8775, 0xFF5E8775, 0xFF5E8775, 0xFF5E8775, 0xFF5E8775, 0xFF5F8876, 0xFF5F8876, 0xFF608977, 0xFF5F8876, 0xFF5E8775, 0xFF5C8573, 0xFF5C8573, 0xFF5C8573, 0xFF5D8674, 0xFF5E8775, 0xFF5A8977,
    0xFF5A8977, 0xFF5D8A76, 0xFF5E8B77, 0xFF5F8A76, 0xFF608B77, 0xFF618C78, 0xFF618D76, 0xFF4B7663, 0xFF3D6855, 0xFF3E6956, 0xFF47705E, 0xFF426B5B, 0xFF436C5C, 0xFF3E6757, 0xFF446D5D, 0xFF477362, 0xFF426E5D, 0xFF497463, 0xFF477060, 0xFF476B5D,
    0xFF446658, 0xFF57776A, 0xFF527265, 0xFF4B6D5D, 0xFF6B8D7D, 0xFF6F9483, 0xFF719685, 0xFF69907E, 0xFF6A9381, 0xFF648D7B, 0xFF66917E, 0xFF608D79, 0xFF628977, 0xFF678979, 0xFF65897B, 0xFF53796A, 0x00749288, 0x00F8FFFF, 0x00FFFDFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFCFF, 0x08F1FDF9, 0xFF587C70, 0xFF518070, 0xFF5D897A, 0xFF61877A, 0xFF5C8577, 0xFF5E8A7B, 0xFF618B7D, 0xFF608A7C, 0xFF5C8678, 0xFF618B7D, 0xFF5F897B,
    0xFF648E80, 0xFF588274, 0xFF234D3F, 0xFF1A4639, 0xFF174336, 0xFF1F4B3E, 0xFF245043, 0xFF224E41, 0xFF2C584B, 0xFF325E51, 0xFF234F42, 0xFF265245, 0xFF1C483B, 0xFF1F4B3E, 0xFF133F32, 0xFF265245, 0xFF133F32, 0xFF144033, 0xFF315D50, 0xFF5C8879,
    0xFF5C8879, 0xFF5C8879, 0xFF5C8879, 0xFF5C8879, 0xFF5B8778, 0xFF5B8778, 0xFF5B8778, 0xFF598878, 0xFF598878, 0xFF598878, 0xFF588878, 0xFF588878, 0xFF588878, 0xFF568978, 0xFF568978, 0xFF578777, 0xFF568676, 0xFF568676, 0xFF568676, 0xFF568676,
    0xFF568676, 0xFF568676, 0xFF578777, 0xFF528574, 0xFF518473, 0xFF548474, 0xFF588777, 0xFF618D7E, 0xFF3F695B, 0xFF10392B, 0xFF1A4033, 0xFF113B2D, 0xFF1A4436, 0xFF174133, 0xFF1F493B, 0xFF1F493B, 0xFF174133, 0xFF1B4537, 0xFF133D2F, 0xFF143E30,
    0xFF153F31, 0xFF214B3D, 0xFF1E483A, 0xFF143E30, 0xFF0F392B, 0xFF477163, 0xFF5F897B, 0xFF548474, 0xFF558575, 0xFF568676, 0xFF588777, 0xFF598878, 0xFF5B8778, 0xFF5B8778, 0xFF5B8778, 0xFF588878, 0xFF578777, 0xFF578777, 0xFF568676, 0xFF568676,
    0xFF578777, 0xFF578777, 0xFF588878, 0xFF598574, 0xFF598574, 0xFF5A8675, 0xFF5A8675, 0xFF5A8675, 0xFF5B8776, 0xFF5B8776, 0xFF5B8776, 0xFF628D7A, 0xFF618C79, 0xFF618C79, 0xFF537C6C, 0xFF1A4333, 0xFF163F31, 0xFF1C4235, 0xFF153B2E, 0xFF1A4335,
    0xFF1E4739, 0xFF224B3D, 0xFF214A3C, 0xFF1C4537, 0xFF184133, 0xFF184133, 0xFF1A4335, 0xFF1A4237, 0xFF1A4237, 0xFF10392B, 0xFF083123, 0xFF315A4C, 0xFF5F8878, 0xFF5E8777, 0xFF5B8474, 0xFF5A8572, 0xFF5B8673, 0xFF5C8774, 0xFF5C8774, 0xFF5C8774,
    0xFF5C8774, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5C8774, 0xFF5C8774, 0xFF5D8875, 0xFF5D8875, 0xFF5E8976, 0xFF628977,
    0xFF5E8573, 0xFF284F3D, 0xFF0A311F, 0xFF143B29, 0xFF143B29, 0xFF143B29, 0xFF183F2D, 0xFF173E2C, 0xFF143B29, 0xFF103725, 0xFF153C2A, 0xFF0F3624, 0xFF1C4331, 0xFF113826, 0xFF163D2B, 0xFF153625, 0xFF0F301F, 0xFF2A4C3C, 0xFF5D8271, 0xFF5B8270,
    0xFF5D8676, 0xFF5B8675, 0xFF5C8877, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5E8775, 0xFF5E8775, 0xFF5E8775, 0xFF5E8775, 0xFF5E8775, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5E8775, 0xFF5F8876, 0xFF608977, 0xFF618A78, 0xFF5C8877,
    0xFF5E8A79, 0xFF5F8B7A, 0xFF608B78, 0xFF608B78, 0xFF608A76, 0xFF618B77, 0xFF628C78, 0xFF305C4B, 0xFF113C2B, 0xFF103B2A, 0xFF133C2C, 0xFF103929, 0xFF153B2C, 0xFF1C4032, 0xFF1E4234, 0xFF154130, 0xFF15402F, 0xFF164130, 0xFF184131, 0xFF123829,
    0xFF163A2C, 0xFF14382A, 0xFF153729, 0xFF234837, 0xFF5E8372, 0xFF678C7B, 0xFF638A78, 0xFF5F8674, 0xFF608775, 0xFF5E8573, 0xFF628B79, 0xFF608D79, 0xFF628977, 0xFF678979, 0xFF65897B, 0xFF53796A, 0x00749288, 0x00F8FFFF, 0x00FFFDFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFAFD, 0x0BEFFBF7, 0xFF5A7E72, 0xFF568575, 0xFF638F80, 0xFF688E81, 0xFF618A7C, 0xFF608C7D, 0xFF608A7C, 0xFF608A7C, 0xFF5B8577, 0xFF5E887A, 0xFF5B8577,
    0xFF648E80, 0xFF5D8779, 0xFF224C3E, 0xFF2A5649, 0xFF406C5F, 0xFF3B675A, 0xFF335F52, 0xFF477366, 0xFF507C6F, 0xFF406C5F, 0xFF3A6659, 0xFF315D50, 0xFF2D594C, 0xFF3C685B, 0xFF285447, 0xFF4A7669, 0xFF255144, 0xFF164235, 0xFF2E5A4D, 0xFF5C8879,
    0xFF5C8879, 0xFF5B8778, 0xFF5B8778, 0xFF5B8778, 0xFF5B8778, 0xFF5A8677, 0xFF5A8677, 0xFF588777, 0xFF588777, 0xFF588777, 0xFF578777, 0xFF568676, 0xFF568676, 0xFF538675, 0xFF538675, 0xFF568676, 0xFF568676, 0xFF568676, 0xFF578777, 0xFF578777,
    0xFF568676, 0xFF568676, 0xFF568676, 0xFF548977, 0xFF558877, 0xFF538373, 0xFF558474, 0xFF638D7F, 0xFF3E6759, 0xFF143A2D, 0xFF34584C, 0xFF315A4C, 0xFF345D4F, 0xFF386153, 0xFF557E70, 0xFF487163, 0xFF30594B, 0xFF3C6557, 0xFF285143, 0xFF396355,
    0xFF2D5749, 0xFF3C6658, 0xFF446E60, 0xFF345E50, 0xFF174133, 0xFF446E60, 0xFF5A8476, 0xFF548474, 0xFF558575, 0xFF568676, 0xFF588777, 0xFF598878, 0xFF5B8778, 0xFF5B8778, 0xFF5B8778, 0xFF588878, 0xFF588878, 0xFF578777, 0xFF578777, 0xFF578777,
    0xFF578777, 0xFF588878, 0xFF588878, 0xFF5A8675, 0xFF5A8675, 0xFF5A8675, 0xFF5B8776, 0xFF5B8776, 0xFF5B8776, 0xFF5B8776, 0xFF5B8776, 0xFF5B8673, 0xFF5A8572, 0xFF608B78, 0xFF567F6F, 0xFF1A4333, 0xFF285143, 0xFF3D6356, 0xFF345A4D, 0xFF2E5749,
    0xFF487163, 0xFF477062, 0xFF365F51, 0xFF345D4F, 0xFF2F584A, 0xFF285143, 0xFF30594B, 0xFF40685D, 0xFF497166, 0xFF396156, 0xFF194234, 0xFF365F51, 0xFF648D7D, 0xFF5E8777, 0xFF578070, 0xFF5B8673, 0xFF5B8673, 0xFF5C8774, 0xFF5D8875, 0xFF5D8875,
    0xFF5D8875, 0xFF5D8875, 0xFF5D8875, 0xFF5D8875, 0xFF5D8875, 0xFF5D8875, 0xFF5C8774, 0xFF5C8774, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5C8774, 0xFF5D8875, 0xFF5D8875, 0xFF5E8976, 0xFF5E8976, 0xFF678C7B,
    0xFF648978, 0xFF2A4F3E, 0xFF193E2D, 0xFF355A49, 0xFF315645, 0xFF2D5241, 0xFF385D4C, 0xFF4D7260, 0xFF3D6250, 0xFF2F5442, 0xFF375C4A, 0xFF1E4331, 0xFF2D5240, 0xFF113624, 0xFF254A38, 0xFF3B5A4A, 0xFF183727, 0xFF284839, 0xFF638877, 0xFF5B8270,
    0xFF5C8575, 0xFF5C8776, 0xFF5B8776, 0xFF5B8472, 0xFF5C8573, 0xFF5D8674, 0xFF5E8775, 0xFF5F8876, 0xFF5E8775, 0xFF5E8775, 0xFF5D8674, 0xFF5C8573, 0xFF5C8573, 0xFF5C8573, 0xFF5D8674, 0xFF5E8775, 0xFF5F8876, 0xFF608977, 0xFF618A78, 0xFF5E887A,
    0xFF5F8A79, 0xFF618A7A, 0xFF618A7A, 0xFF628977, 0xFF628977, 0xFF658A78, 0xFF678C7A, 0xFF366054, 0xFF184234, 0xFF2A5345, 0xFF2E5447, 0xFF315547, 0xFF395B4D, 0xFF4D6F5F, 0xFF466657, 0xFF295242, 0xFF345D4D, 0xFF1E4737, 0xFF315748, 0xFF355B4C,
    0xFF4C7062, 0xFF3F6355, 0xFF2E5244, 0xFF204533, 0xFF5E8371, 0xFF668B79, 0xFF658A78, 0xFF608573, 0xFF618674, 0xFF648977, 0xFF658A78, 0xFF608D79, 0xFF628977, 0xFF678979, 0xFF65897B, 0xFF53796A, 0x00749288, 0x00F8FFFF, 0x00FFFDFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFCFF, 0x08F2FEFA, 0xFF5A7E72, 0xFF548373, 0xFF608C7D, 0xFF668C7F, 0xFF60897B, 0xFF5F8B7C, 0xFF5C8678, 0xFF618B7D, 0xFF608A7C, 0xFF648E80, 0xFF5E887A,
    0xFF658F81, 0xFF5D8779, 0xFF1E483A, 0xFF285447, 0xFF5E8A7D, 0xFF3E6A5D, 0xFF1B473A, 0xFF467265, 0xFF426E61, 0xFF194538, 0xFF2B574A, 0xFF4F7B6E, 0xFF3E6A5D, 0xFF3F6B5E, 0xFF1E4A3D, 0xFF517D70, 0xFF2D594C, 0xFF184437, 0xFF2A5649, 0xFF5D897A,
    0xFF5D897A, 0xFF5D897A, 0xFF5D897A, 0xFF5D897A, 0xFF5C8879, 0xFF5C8879, 0xFF5C8879, 0xFF588777, 0xFF588777, 0xFF578676, 0xFF558575, 0xFF548474, 0xFF538373, 0xFF518473, 0xFF508372, 0xFF558575, 0xFF568676, 0xFF578777, 0xFF578777, 0xFF578777,
    0xFF578777, 0xFF568676, 0xFF558575, 0xFF548977, 0xFF588B7A, 0xFF548474, 0xFF568273, 0xFF648E80, 0xFF3F6558, 0xFF193D31, 0xFF486C60, 0xFF4C7567, 0xFF355E50, 0xFF275042, 0xFF436C5E, 0xFF295244, 0xFF174032, 0xFF446D5F, 0xFF386153, 0xFF497365,
    0xFF275143, 0xFF2D5749, 0xFF426C5E, 0xFF3C6658, 0xFF1A4436, 0xFF487264, 0xFF5F897B, 0xFF548474, 0xFF548474, 0xFF558575, 0xFF588777, 0xFF588777, 0xFF5B8778, 0xFF5B8778, 0xFF5B8778, 0xFF588878, 0xFF588878, 0xFF578777, 0xFF578777, 0xFF578777,
    0xFF578777, 0xFF588878, 0xFF588878, 0xFF5D8978, 0xFF5D8978, 0xFF5D8978, 0xFF5D8978, 0xFF5D8978, 0xFF5D8978, 0xFF5D8978, 0xFF5D8978, 0xFF5F8A77, 0xFF5A8572, 0xFF618C79, 0xFF578070, 0xFF1B4434, 0xFF355E50, 0xFF53796C, 0xFF476D60, 0xFF264F41,
    0xFF456E60, 0xFF325B4D, 0xFF1C4537, 0xFF355E50, 0xFF416A5C, 0xFF365F51, 0xFF3D6658, 0xFF295148, 0xFF456D62, 0xFF426A5F, 0xFF1A4237, 0xFF30594B, 0xFF60897B, 0xFF608979, 0xFF5E8777, 0xFF5B8673, 0xFF5C8774, 0xFF5C8774, 0xFF5D8875, 0xFF5D8875,
    0xFF5E8976, 0xFF5F8A77, 0xFF5F8A77, 0xFF5E8976, 0xFF5E8976, 0xFF5D8875, 0xFF5D8875, 0xFF5C8774, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5C8774, 0xFF5D8875, 0xFF5E8976, 0xFF5E8976, 0xFF5E8976, 0xFF5F8473,
    0xFF608574, 0xFF2C5140, 0xFF2C5140, 0xFF537867, 0xFF436857, 0xFF325746, 0xFF3F6453, 0xFF3A5F4D, 0xFF2C513F, 0xFF2C513F, 0xFF476C5A, 0xFF2D5240, 0xFF426755, 0xFF244937, 0xFF4A6F5D, 0xFF526E5F, 0xFF1A3929, 0xFF224233, 0xFF658777, 0xFF5B8270,
    0xFF5C8575, 0xFF5A8675, 0xFF598574, 0xFF5A8371, 0xFF5B8472, 0xFF5D8674, 0xFF5E8775, 0xFF5F8876, 0xFF5E8775, 0xFF5D8674, 0xFF5C8573, 0xFF5E8775, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5F887A,
    0xFF62887B, 0xFF628879, 0xFF628879, 0xFF628776, 0xFF648978, 0xFF698B7B, 0xFF6C8E7D, 0xFF315B4F, 0xFF234B40, 0xFF4B7466, 0xFF4A7063, 0xFF47695B, 0xFF3F5F52, 0xFF4E6D5E, 0xFF355445, 0xFF2B5142, 0xFF4D7364, 0xFF2E5445, 0xFF496F60, 0xFF4C7062,
    0xFF5D8173, 0xFF3F6355, 0xFF163A2C, 0xFF224735, 0xFF5A7F6D, 0xFF638876, 0xFF6B8D7C, 0xFF658776, 0xFF668877, 0xFF698B7A, 0xFF628473, 0xFF608D79, 0xFF628977, 0xFF678979, 0xFF65897B, 0xFF53796A, 0x00749288, 0x00F8FFFF, 0x00FFFDFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFF, 0x0FEDF9F7, 0xFF53776D, 0xFF548373, 0xFF5F8B7C, 0xFF618A7A, 0xFF658E7E, 0xFF628E7D, 0xFF678D78, 0xFF608A76, 0xFF5E8A79, 0xFF608F7F, 0xFF5E8E7E,
    0xFF5D8C7A, 0xFF5E8B76, 0xFF214D36, 0xFF2A584D, 0xFF57857A, 0xFF3A685D, 0xFF154338, 0xFF467469, 0xFF3F6D62, 0xFF17453A, 0xFF154338, 0xFF38665C, 0xFF4F7D73, 0xFF18463C, 0xFF113F35, 0xFF406E64, 0xFF29574D, 0xFF0E3C32, 0xFF29574D, 0xFF628B79,
    0xFF608775, 0xFF608677, 0xFF63897A, 0xFF5E887A, 0xFF588679, 0xFF578A7B, 0xFF5B9080, 0xFF578676, 0xFF578676, 0xFF578676, 0xFF578676, 0xFF578676, 0xFF568575, 0xFF558474, 0xFF558474, 0xFF568573, 0xFF568573, 0xFF578674, 0xFF588775, 0xFF588775,
    0xFF598876, 0xFF598876, 0xFF598876, 0xFF56836F, 0xFF588370, 0xFF5D8875, 0xFF5B8571, 0xFF658F7B, 0xFF456C59, 0xFF193F2A, 0xFF456B56, 0xFF517E67, 0xFF24513A, 0xFF24513A, 0xFF4E7B64, 0xFF24513A, 0xFF0D3A23, 0xFF214E37, 0xFF507D66, 0xFF305A44,
    0xFF173E29, 0xFF395F4A, 0xFF426551, 0xFF284E39, 0xFF183F2A, 0xFF48755E, 0xFF5D8D75, 0xFF568A73, 0xFF568670, 0xFF58816F, 0xFF5C8371, 0xFF5E8475, 0xFF5A8476, 0xFF558575, 0xFF548B78, 0xFF558673, 0xFF558673, 0xFF558673, 0xFF568573, 0xFF578674,
    0xFF588775, 0xFF5A8675, 0xFF5B8776, 0xFF5C8877, 0xFF5E8A79, 0xFF5F8B7A, 0xFF5E8A79, 0xFF5D8978, 0xFF5B8776, 0xFF5C8877, 0xFF5F8B7A, 0xFF60816E, 0xFF668C77, 0xFF678E79, 0xFF5B8770, 0xFF18452E, 0xFF325F48, 0xFF55826B, 0xFF315D46, 0xFF1D4A36,
    0xFF497662, 0xFF33604C, 0xFF103D29, 0xFF174430, 0xFF497662, 0xFF487561, 0xFF1F4C38, 0xFF1C4533, 0xFF3A6351, 0xFF507B68, 0xFF17422F, 0xFF355E4C, 0xFF6B907F, 0xFF5E7E6F, 0xFF678677, 0xFF5E8978, 0xFF608B7A, 0xFF5D8877, 0xFF5D8877, 0xFF618C7B,
    0xFF5F8A79, 0xFF5C8776, 0xFF5E8978, 0xFF608977, 0xFF5F8876, 0xFF5E8775, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5E8775, 0xFF5E8775, 0xFF5A8979, 0xFF588473, 0xFF598473, 0xFF5D8674, 0xFF5F8674, 0xFF628473, 0xFF648572, 0xFF658673, 0xFF5E8570,
    0xFF6B917C, 0xFF2B4E3A, 0xFF274835, 0xFF638672, 0xFF3B614C, 0xFF0E3822, 0xFF3D6A53, 0xFF466E56, 0xFF1A422A, 0xFF143C24, 0xFF466E56, 0xFF527A62, 0xFF1F472F, 0xFF426A52, 0xFF4D755D, 0xFF507262, 0xFF0F3423, 0xFF214836, 0xFF5F8876, 0xFF628B79,
    0xFF597E6D, 0xFF648475, 0xFF668274, 0xFF608775, 0xFF5F8674, 0xFF5E8573, 0xFF5D8472, 0xFF5E8573, 0xFF5E8573, 0xFF5E8573, 0xFF5E8573, 0xFF608775, 0xFF608775, 0xFF618876, 0xFF618876, 0xFF628977, 0xFF618876, 0xFF618876, 0xFF618876, 0xFF5F8878,
    0xFF608677, 0xFF628678, 0xFF668878, 0xFF688978, 0xFF658776, 0xFF658B76, 0xFF69907B, 0xFF34634F, 0xFF194834, 0xFF588773, 0xFF477662, 0xFF184733, 0xFF32614D, 0xFF558470, 0xFF1D4C38, 0xFF174135, 0xFF355F53, 0xFF5F897D, 0xFF2C564A, 0xFF2F594D,
    0xFF446E62, 0xFF4A7468, 0xFF214B3F, 0xFF17442D, 0xFF5A846E, 0xFF698C78, 0xFF698876, 0xFF708F7D, 0xFF668975, 0xFF628C76, 0xFF5C8972, 0xFF628D7A, 0xFF668B7A, 0xFF678778, 0xFF67897B, 0xFF53796A, 0x00719186, 0x00F7FFFF, 0x00FFFBFC, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFF, 0x13ECF8F6, 0xFF52766C, 0xFF538272, 0xFF5E8A7B, 0xFF618778, 0xFF628B7B, 0xFF5E8A79, 0xFF618674, 0xFF5C8573, 0xFF578676, 0xFF4F8273, 0xFF4A7A6C,
    0xFF467263, 0xFF49705E, 0xFF1B3C2B, 0xFF224332, 0xFF3C5D4C, 0xFF3A5B4A, 0xFF294A39, 0xFF406150, 0xFF3F604F, 0xFF2C4D3C, 0xFF1D3E2D, 0xFF264234, 0xFF3B5749, 0xFF1E3A2C, 0xFF264234, 0xFF486456, 0xFF324E40, 0xFF1B3729, 0xFF254133, 0xFF497564,
    0xFF4A7564, 0xFF4D7867, 0xFF517B6D, 0xFF558172, 0xFF558376, 0xFF538375, 0xFF4F8273, 0xFF568575, 0xFF568575, 0xFF578676, 0xFF578676, 0xFF578676, 0xFF578676, 0xFF568575, 0xFF568575, 0xFF568573, 0xFF568573, 0xFF568573, 0xFF568573, 0xFF568573,
    0xFF568573, 0xFF558472, 0xFF558472, 0xFF568976, 0xFF4F806D, 0xFF507D69, 0xFF48715F, 0xFF4F7463, 0xFF375847, 0xFF143021, 0xFF365243, 0xFF3C5849, 0xFF324E3F, 0xFF284435, 0xFF405C4D, 0xFF314D3E, 0xFF1D392A, 0xFF173324, 0xFF3D594A, 0xFF1B3A2A,
    0xFF264233, 0xFF486455, 0xFF385445, 0xFF1C3B2B, 0xFF103221, 0xFF38624E, 0xFF4B7863, 0xFF447B64, 0xFF487C66, 0xFF527F6B, 0xFF578070, 0xFF588171, 0xFF557F71, 0xFF518171, 0xFF508372, 0xFF548572, 0xFF548572, 0xFF548572, 0xFF568573, 0xFF568573,
    0xFF598574, 0xFF5A8675, 0xFF5A8675, 0xFF598574, 0xFF5A8675, 0xFF5B8776, 0xFF5B8776, 0xFF5B8776, 0xFF5A8675, 0xFF598574, 0xFF588473, 0xFF5C8773, 0xFF5A8470, 0xFF577E6B, 0xFF507563, 0xFF1C3E2D, 0xFF305241, 0xFF4C6E5D, 0xFF385A49, 0xFF294537,
    0xFF486456, 0xFF3D594B, 0xFF233F31, 0xFF173325, 0xFF324E40, 0xFF355143, 0xFF193527, 0xFF3E5E4F, 0xFF436354, 0xFF446455, 0xFF143425, 0xFF305242, 0xFF5E8372, 0xFF577E6C, 0xFF608977, 0xFF5C8575, 0xFF5F8878, 0xFF5D8676, 0xFF5D8676, 0xFF618A7A,
    0xFF5F8878, 0xFF5B8474, 0xFF5E8777, 0xFF5F8876, 0xFF5F8876, 0xFF5E8775, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5C8877, 0xFF5A8675, 0xFF5B8675, 0xFF5D8875, 0xFF5F8876, 0xFF5D8773, 0xFF5C8370, 0xFF5A816E, 0xFF5C8370,
    0xFF5D7F6E, 0xFF264535, 0xFF254132, 0xFF597465, 0xFF486455, 0xFF284938, 0xFF3F6150, 0xFF3E5B49, 0xFF23402E, 0xFF112E1C, 0xFF2F4C3A, 0xFF415E4C, 0xFF1D3A28, 0xFF3F5C4A, 0xFF4C6957, 0xFF546C5F, 0xFF1D392B, 0xFF244435, 0xFF547B69, 0xFF5F8876,
    0xFF5B8472, 0xFF618876, 0xFF5D8271, 0xFF5D8472, 0xFF5D8472, 0xFF5D8472, 0xFF5D8472, 0xFF5E8573, 0xFF5E8573, 0xFF5E8573, 0xFF5E8573, 0xFF5F8674, 0xFF608775, 0xFF608775, 0xFF618876, 0xFF618876, 0xFF618876, 0xFF608775, 0xFF608775, 0xFF618778,
    0xFF608677, 0xFF608476, 0xFF628776, 0xFF608775, 0xFF5C8672, 0xFF5D8874, 0xFF618C78, 0xFF335344, 0xFF1F3F30, 0xFF517162, 0xFF49695A, 0xFF315142, 0xFF3B5B4C, 0xFF4B6B5C, 0xFF254536, 0xFF1D3B2F, 0xFF2A483C, 0xFF4A685C, 0xFF234135, 0xFF2D4B3F,
    0xFF426054, 0xFF4D6B5F, 0xFF314F43, 0xFF1E4834, 0xFF57816D, 0xFF658A78, 0xFF648675, 0xFF688A79, 0xFF618674, 0xFF638D79, 0xFF638D79, 0xFF608B78, 0xFF648978, 0xFF668677, 0xFF67897B, 0xFF547A6B, 0x00729287, 0x00F7FFFF, 0x00FFFDFE, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFBFF, 0x13ECF8F6, 0xFF52766C, 0xFF538272, 0xFF5D8779, 0xFF5E8475, 0xFF5F8576, 0xFF5A8574, 0xFF587D6C, 0xFF547D6D, 0xFF49796B, 0xFF35695C, 0xFF2B5B4F,
    0xFF244C41, 0xFF2B473B, 0xFF0F2318, 0xFF142512, 0xFF192A17, 0xFF21321F, 0xFF1C2D1A, 0xFF1D2E1B, 0xFF1F301D, 0xFF1F301D, 0xFF122310, 0xFF1B2616, 0xFF222D1D, 0xFF141F0F, 0xFF1D2818, 0xFF2B3626, 0xFF1F2A1A, 0xFF1A2515, 0xFF1B2616, 0xFF215141,
    0xFF265646, 0xFF2C5C4C, 0xFF346454, 0xFF427161, 0xFF4D7C6C, 0xFF528073, 0xFF538174, 0xFF558474, 0xFF558474, 0xFF568575, 0xFF578676, 0xFF578676, 0xFF578676, 0xFF578676, 0xFF578676, 0xFF568573, 0xFF568573, 0xFF558472, 0xFF558472, 0xFF548371,
    0xFF52816F, 0xFF51806E, 0xFF507F6D, 0xFF417A67, 0xFF306754, 0xFF2E5E4E, 0xFF295242, 0xFF2D4D40, 0xFF223A2D, 0xFF0B1C12, 0xFF1D2A21, 0xFF192019, 0xFF282F28, 0xFF1C231C, 0xFF252C25, 0xFF282F28, 0xFF232A23, 0xFF0F160F, 0xFF222922, 0xFF0D1D13,
    0xFF16261C, 0xFF28382E, 0xFF1D2E24, 0xFF152B1F, 0xFF052113, 0xFF1C3E2E, 0xFF305745, 0xFF205B45, 0xFF2B654F, 0xFF3F725F, 0xFF4D7C6A, 0xFF537F6E, 0xFF558172, 0xFF578374, 0xFF568575, 0xFF538471, 0xFF538471, 0xFF548371, 0xFF558472, 0xFF578372,
    0xFF588473, 0xFF588473, 0xFF5A8574, 0xFF598574, 0xFF588473, 0xFF578372, 0xFF588473, 0xFF578372, 0xFF558170, 0xFF507C6B, 0xFF497564, 0xFF336A53, 0xFF2E5D49, 0xFF2E5342, 0xFF344E41, 0xFF13271C, 0xFF1B2C22, 0xFF203429, 0xFF1A3024, 0xFF2B322A,
    0xFF363D35, 0xFF373E36, 0xFF30372F, 0xFF1C231B, 0xFF222921, 0xFF282F27, 0xFF1C231B, 0xFF263A2E, 0xFF24362A, 0xFF223227, 0xFF0B1D11, 0xFF20382A, 0xFF395B4A, 0xFF32624C, 0xFF386E56, 0xFF507969, 0xFF567F6F, 0xFF578070, 0xFF588171, 0xFF5D8676,
    0xFF5D8676, 0xFF5A8373, 0xFF5D8676, 0xFF5E8775, 0xFF5E8775, 0xFF5E8775, 0xFF5E8775, 0xFF5D8674, 0xFF5C8573, 0xFF5B8472, 0xFF5B8472, 0xFF5C8575, 0xFF5A8574, 0xFF588372, 0xFF558170, 0xFF53806C, 0xFF487763, 0xFF3C6B57, 0xFF356450, 0xFF395B4B,
    0xFF335243, 0xFF162E21, 0xFF0F2318, 0xFF26362C, 0xFF25352B, 0xFF1E2E24, 0xFF23342A, 0xFF35453A, 0xFF314136, 0xFF19291E, 0xFF1A2A1F, 0xFF27372C, 0xFF07170C, 0xFF142419, 0xFF17271C, 0xFF2C362D, 0xFF132318, 0xFF1B3325, 0xFF385A49, 0xFF426C58,
    0xFF426F5A, 0xFF487862, 0xFF4F7F69, 0xFF59806E, 0xFF5A816F, 0xFF5C8371, 0xFF5D8472, 0xFF5D8472, 0xFF5D8472, 0xFF5D8472, 0xFF5D8472, 0xFF5F8674, 0xFF5F8674, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF5F8674, 0xFF5F8674, 0xFF5F8375,
    0xFF5B7F71, 0xFF557B6C, 0xFF4C7766, 0xFF416D5C, 0xFF376652, 0xFF33644F, 0xFF32634E, 0xFF2B3D31, 0xFF182A1E, 0xFF2C3E32, 0xFF27392D, 0xFF2D3F33, 0xFF334539, 0xFF405246, 0xFF3E5044, 0xFF1F3425, 0xFF1C3122, 0xFF314637, 0xFF1C3122, 0xFF283D2E,
    0xFF334839, 0xFF384D3E, 0xFF263B2C, 0xFF113625, 0xFF39604E, 0xFF456E5C, 0xFF487360, 0xFF517C69, 0xFF57806E, 0xFF618876, 0xFF618675, 0xFF5C8774, 0xFF618675, 0xFF658576, 0xFF688A7C, 0xFF557B6C, 0x00729287, 0x00F7FFFF, 0x00FFFEFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFBFF, 0x0FEDF7F6, 0xFF55766D, 0xFF558172, 0xFF5D8779, 0xFF5D8374, 0xFF5D8374, 0xFF568170, 0xFF608274, 0xFF567F71, 0xFF46766A, 0xFF2A5C51, 0xFF204E44,
    0xFF1C3D36, 0xFF22352F, 0xFF17201B, 0xFF162214, 0xFF172315, 0xFF162214, 0xFF131F11, 0xFF152113, 0xFF121E10, 0xFF121E10, 0xFF152113, 0xFF171A11, 0xFF181B12, 0xFF13160D, 0xFF1B1E15, 0xFF1D2017, 0xFF181B12, 0xFF1C1F16, 0xFF1C1F16, 0xFF0F3F31,
    0xFF154839, 0xFF1D5041, 0xFF295C4D, 0xFF3A6D5E, 0xFF497868, 0xFF527E6F, 0xFF598375, 0xFF568273, 0xFF568273, 0xFF578374, 0xFF598576, 0xFF5A8677, 0xFF5A8677, 0xFF5A8677, 0xFF5A8677, 0xFF598574, 0xFF598574, 0xFF588473, 0xFF578372, 0xFF558170,
    0xFF527E6D, 0xFF4F7B6A, 0xFF4E7A69, 0xFF3B7866, 0xFF255E4D, 0xFF1F4F41, 0xFF1A4033, 0xFF1A342B, 0xFF1A2922, 0xFF121814, 0xFF161815, 0xFF101211, 0xFF181A19, 0xFF131514, 0xFF181A19, 0xFF161817, 0xFF1F2120, 0xFF161817, 0xFF161817, 0xFF1A1F1B,
    0xFF121713, 0xFF141915, 0xFF0F1813, 0xFF18251E, 0xFF081D14, 0xFF0F2B1F, 0xFF1A3C2E, 0xFF0E4C37, 0xFF1D5643, 0xFF346B58, 0xFF467968, 0xFF4C7B6B, 0xFF507C6B, 0xFF547F6E, 0xFF537E6D, 0xFF538270, 0xFF538270, 0xFF548371, 0xFF578372, 0xFF578372,
    0xFF578372, 0xFF588372, 0xFF588372, 0xFF5D8877, 0xFF588372, 0xFF578271, 0xFF568170, 0xFF547F6E, 0xFF517C6B, 0xFF477261, 0xFF396453, 0xFF1C5A43, 0xFF174A37, 0xFF17392B, 0xFF203129, 0xFF141A16, 0xFF161B17, 0xFF0F1511, 0xFF101B15, 0xFF181B14,
    0xFF151811, 0xFF171A13, 0xFF1E211A, 0xFF181B14, 0xFF151811, 0xFF171A13, 0xFF161912, 0xFF0E180F, 0xFF111810, 0xFF161B14, 0xFF111810, 0xFF17291D, 0xFF1F402F, 0xFF1C4D37, 0xFF1E5D42, 0xFF406959, 0xFF4A7363, 0xFF4F7868, 0xFF527B6B, 0xFF588171,
    0xFF5B8474, 0xFF5B8474, 0xFF5E8777, 0xFF5D8674, 0xFF5E8775, 0xFF5E8775, 0xFF5E8775, 0xFF5D8674, 0xFF5C8573, 0xFF5A8371, 0xFF598270, 0xFF59806E, 0xFF58816F, 0xFF537E6D, 0xFF4E7A69, 0xFF467563, 0xFF336653, 0xFF1E533F, 0xFF134836, 0xFF203E32,
    0xFF1C362B, 0xFF13271E, 0xFF0E1913, 0xFF0D130F, 0xFF111612, 0xFF151A16, 0xFF151A16, 0xFF101612, 0xFF1C221E, 0xFF121814, 0xFF121814, 0xFF212723, 0xFF101612, 0xFF161C18, 0xFF121814, 0xFF1A1712, 0xFF141912, 0xFF17271C, 0xFF213D2E, 0xFF244E3A,
    0xFF265640, 0xFF356952, 0xFF4B8169, 0xFF557C6A, 0xFF577E6C, 0xFF5A816F, 0xFF5D8472, 0xFF5D8472, 0xFF5D8472, 0xFF5D8472, 0xFF5D8472, 0xFF5E8573, 0xFF5E8573, 0xFF5F8674, 0xFF5F8674, 0xFF5F8674, 0xFF5E8573, 0xFF5E8573, 0xFF5D8472, 0xFF5D7F71,
    0xFF55796B, 0xFF4B7665, 0xFF3D6C5A, 0xFF2A5D4C, 0xFF1E5140, 0xFF1A4D3C, 0xFF164938, 0xFF1C291F, 0xFF0F1C12, 0xFF121F15, 0xFF0C190F, 0xFF19261C, 0xFF132016, 0xFF121F15, 0xFF1C291F, 0xFF172919, 0xFF0E2010, 0xFF1B2D1D, 0xFF112313, 0xFF192B1B,
    0xFF1B2D1D, 0xFF1A2C1C, 0xFF102212, 0xFF0F2F22, 0xFF204436, 0xFF285342, 0xFF305F4D, 0xFF437260, 0xFF547F6E, 0xFF5D8173, 0xFF5B7B6E, 0xFF5C8774, 0xFF608574, 0xFF658576, 0xFF698B7D, 0xFF567C6D, 0x00719186, 0x00F7FFFF, 0x00FFFEFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFBFF, 0x0FEEF8F7, 0xFF56776E, 0xFF578374, 0xFF60897B, 0xFF5E8274, 0xFF5E8274, 0xFF578070, 0xFF5F8075, 0xFF4D726A, 0xFF3E675F, 0xFF224C48, 0xFF1A413E,
    0xFF18322F, 0xFF192928, 0xFF151E1B, 0xFF162623, 0xFF162623, 0xFF132320, 0xFF172724, 0xFF1A2A27, 0xFF152522, 0xFF10201D, 0xFF172724, 0xFF1B2526, 0xFF1C2627, 0xFF192324, 0xFF1A2425, 0xFF182223, 0xFF131D1E, 0xFF172122, 0xFF192324, 0xFF113A32,
    0xFF133E35, 0xFF144438, 0xFF225747, 0xFF3B6E5F, 0xFF487868, 0xFF4E786A, 0xFF587E6F, 0xFF558172, 0xFF568273, 0xFF578374, 0xFF598576, 0xFF5A8677, 0xFF5A8677, 0xFF5B8778, 0xFF5B8778, 0xFF5B8776, 0xFF5B8776, 0xFF5A8675, 0xFF588473, 0xFF558170,
    0xFF527E6D, 0xFF4F7B6A, 0xFF4D7968, 0xFF376D60, 0xFF225449, 0xFF174137, 0xFF11322B, 0xFF102520, 0xFF162220, 0xFF191D1E, 0xFF191919, 0xFF182022, 0xFF131B1D, 0xFF121A1C, 0xFF182022, 0xFF0E1618, 0xFF131B1D, 0xFF141C1E, 0xFF141C1E, 0xFF181C1D,
    0xFF181C1D, 0xFF1A1E1F, 0xFF111516, 0xFF121B1A, 0xFF0F1F1C, 0xFF142B25, 0xFF102B24, 0xFF124639, 0xFF194D40, 0xFF2E6353, 0xFF437667, 0xFF497969, 0xFF4F7B6A, 0xFF537E6D, 0xFF537C6A, 0xFF52816F, 0xFF538270, 0xFF568271, 0xFF578372, 0xFF588473,
    0xFF598473, 0xFF588372, 0xFF588372, 0xFF5D8877, 0xFF578271, 0xFF55806F, 0xFF55806F, 0xFF527D6C, 0xFF4F7A69, 0xFF436E5D, 0xFF305B4A, 0xFF144D3C, 0xFF124033, 0xFF0E2C24, 0xFF131F1D, 0xFF151618, 0xFF1B1B1D, 0xFF161719, 0xFF1B2121, 0xFF151E19,
    0xFF101914, 0xFF0F1813, 0xFF121B16, 0xFF19221D, 0xFF141D18, 0xFF0F1813, 0xFF151E19, 0xFF151B17, 0xFF1B201C, 0xFF1B1B19, 0xFF171916, 0xFF101D16, 0xFF0F2D21, 0xFF103F2D, 0xFF144E38, 0xFF3B6152, 0xFF496F60, 0xFF517768, 0xFF547A6B, 0xFF5A8071,
    0xFF5E8475, 0xFF5E8475, 0xFF608677, 0xFF5C8573, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5C8573, 0xFF5A8371, 0xFF598270, 0xFF567D6B, 0xFF59806E, 0xFF547D6B, 0xFF507B6A, 0xFF467565, 0xFF306050, 0xFF184B3C, 0xFF114636, 0xFF153029,
    0xFF112822, 0xFF12211E, 0xFF121B1A, 0xFF161719, 0xFF1A1A1C, 0xFF1A1A1C, 0xFF17181A, 0xFF111516, 0xFF161A1B, 0xFF131718, 0xFF111516, 0xFF181C1D, 0xFF121617, 0xFF1A1E1F, 0xFF141819, 0xFF1C1616, 0xFF161614, 0xFF0D1A13, 0xFF0D271C, 0xFF15392B,
    0xFF1C4837, 0xFF2E5F4C, 0xFF497C69, 0xFF527967, 0xFF567D6B, 0xFF5A816F, 0xFF5D8472, 0xFF5D8472, 0xFF5C8371, 0xFF5D8472, 0xFF5D8472, 0xFF5E8573, 0xFF5E8573, 0xFF5F8674, 0xFF5F8674, 0xFF5E8573, 0xFF5E8573, 0xFF5D8472, 0xFF5C8371, 0xFF608073,
    0xFF567C6D, 0xFF4C7867, 0xFF386B5A, 0xFF215646, 0xFF174A3B, 0xFF17473B, 0xFF144237, 0xFF162B22, 0xFF13281F, 0xFF162B22, 0xFF12271E, 0xFF1B3027, 0xFF12271E, 0xFF0C2118, 0xFF12271E, 0xFF122D1C, 0xFF0D2817, 0xFF132E1D, 0xFF0D2817, 0xFF0F2A19,
    0xFF122D1C, 0xFF15301F, 0xFF122D1C, 0xFF15332B, 0xFF17382F, 0xFF1B4338, 0xFF255144, 0xFF3A6659, 0xFF51796E, 0xFF5C7D74, 0xFF628078, 0xFF5D8875, 0xFF618675, 0xFF668677, 0xFF6A8C7E, 0xFF557B6C, 0x006F8F84, 0x00F7FFFF, 0x00FFFEFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFBFF, 0x0BEFF8F7, 0xFF57766E, 0xFF588274, 0xFF618A7C, 0xFF608476, 0xFF608476, 0xFF598272, 0xFF607F79, 0xFF4D6D68, 0xFF4D6D6C, 0xFF3F5D5F, 0xFF415D60,
    0xFF465B5E, 0xFF455757, 0xFF475555, 0xFF4C6164, 0xFF455A5D, 0xFF44595C, 0xFF4A5F62, 0xFF43585B, 0xFF44595C, 0xFF44595C, 0xFF44595C, 0xFF42555B, 0xFF475A60, 0xFF45585E, 0xFF44575D, 0xFF43565C, 0xFF3F5258, 0xFF3F5258, 0xFF44575D, 0xFF3A5453,
    0xFF2F4F4C, 0xFF1C453D, 0xFF1E4E42, 0xFF36695A, 0xFF487868, 0xFF4E7968, 0xFF557B6C, 0xFF568072, 0xFF578173, 0xFF588274, 0xFF5A8476, 0xFF5B8577, 0xFF5B8577, 0xFF5B8577, 0xFF5B8577, 0xFF5C8776, 0xFF5C8776, 0xFF5C8776, 0xFF5A8574, 0xFF578271,
    0xFF547F6E, 0xFF507B6A, 0xFF4E7968, 0xFF406762, 0xFF3D615D, 0xFF3B5957, 0xFF3E5855, 0xFF405453, 0xFF445252, 0xFF4C5657, 0xFF4A5254, 0xFF455759, 0xFF425456, 0xFF3F5153, 0xFF445658, 0xFF425456, 0xFF3E5052, 0xFF3C4E50, 0xFF46585A, 0xFF435151,
    0xFF424E4E, 0xFF475152, 0xFF464E50, 0xFF414B4C, 0xFF3B4949, 0xFF3B4F4D, 0xFF384E4B, 0xFF2A4E4A, 0xFF214A42, 0xFF305B51, 0xFF447466, 0xFF4B7B6B, 0xFF517D6C, 0xFF57826F, 0xFF58816F, 0xFF538270, 0xFF558170, 0xFF578372, 0xFF588473, 0xFF5A8574,
    0xFF5A8574, 0xFF5A8373, 0xFF598272, 0xFF5C8575, 0xFF557E6E, 0xFF557E6E, 0xFF557E6E, 0xFF537C6C, 0xFF527B6B, 0xFF477060, 0xFF305949, 0xFF1E483E, 0xFF264942, 0xFF2A433F, 0xFF324040, 0xFF393E41, 0xFF3C4144, 0xFF383D40, 0xFF31393B, 0xFF324541,
    0xFF314440, 0xFF30433F, 0xFF293C38, 0xFF324541, 0xFF2E413D, 0xFF2A3D39, 0xFF334642, 0xFF313B3A, 0xFF394241, 0xFF383E3E, 0xFF353E3D, 0xFF303F3C, 0xFF2E4741, 0xFF264A40, 0xFF234F42, 0xFF3D6354, 0xFF4D7364, 0xFF577D6E, 0xFF587E6F, 0xFF5C8273,
    0xFF5F8576, 0xFF5E8475, 0xFF608677, 0xFF5C8573, 0xFF5C8573, 0xFF5D8674, 0xFF5D8674, 0xFF5C8573, 0xFF5C8573, 0xFF5B8472, 0xFF5B8472, 0xFF5A816E, 0xFF5B826F, 0xFF567F6D, 0xFF537C6C, 0xFF497365, 0xFF305A4E, 0xFF1D483E, 0xFF224D44, 0xFF233C38,
    0xFF263A38, 0xFF2E3C3C, 0xFF30383A, 0xFF33383B, 0xFF33383B, 0xFF2E3336, 0xFF2F3739, 0xFF364042, 0xFF313B3D, 0xFF313B3D, 0xFF303A3C, 0xFF2E383A, 0xFF2C3638, 0xFF323C3E, 0xFF2B3537, 0xFF303032, 0xFF2D3132, 0xFF283734, 0xFF273E38, 0xFF26453D,
    0xFF274B41, 0xFF345A4F, 0xFF476D62, 0xFF527967, 0xFF567D6B, 0xFF5B8270, 0xFF5D8472, 0xFF5D8472, 0xFF5C8371, 0xFF5D8472, 0xFF5E8573, 0xFF5E8573, 0xFF5F8674, 0xFF5F8674, 0xFF5F8674, 0xFF5E8573, 0xFF5D8472, 0xFF5C8371, 0xFF5C8371, 0xFF5F8173,
    0xFF547D6D, 0xFF4A7969, 0xFF356859, 0xFF1D4F43, 0xFF1A483E, 0xFF274B47, 0xFF294946, 0xFF2B463F, 0xFF2A453E, 0xFF2A453E, 0xFF254039, 0xFF29443D, 0xFF28433C, 0xFF29443D, 0xFF29443D, 0xFF26443A, 0xFF28463C, 0xFF2B493F, 0xFF2B493F, 0xFF28463C,
    0xFF2B493F, 0xFF2C4A40, 0xFF2D4B41, 0xFF2F4A45, 0xFF294641, 0xFF2E4D47, 0xFF2F5049, 0xFF3C5D56, 0xFF4D6C66, 0xFF55726D, 0xFF68837E, 0xFF5F8A77, 0xFF628776, 0xFF668677, 0xFF6A8C7E, 0xFF547A6B, 0x006D8D82, 0x00F5FFFD, 0x00FFFEFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFAFF, 0x0FEEF7F6, 0xFF56756D, 0xFF588274, 0xFF60897B, 0xFF638577, 0xFF618577, 0xFF5B8474, 0xFF55746F, 0xFF46605F, 0xFF586D72, 0xFF55666E, 0xFF5A6B73,
    0xFF5E7177, 0xFF5A7272, 0xFF5B7572, 0xFF576A6E, 0xFF55686C, 0xFF53666A, 0xFF55686C, 0xFF475A5E, 0xFF4C5F63, 0xFF4C5F63, 0xFF4B5E62, 0xFF4C6166, 0xFF52676C, 0xFF5A6F74, 0xFF5D7277, 0xFF5E7378, 0xFF5B7075, 0xFF576C71, 0xFF576C71, 0xFF667079,
    0xFF5D7074, 0xFF3F5F5C, 0xFF2A554C, 0xFF36695A, 0xFF4B7B6B, 0xFF537E6D, 0xFF577E6C, 0xFF578173, 0xFF588274, 0xFF598375, 0xFF5A8476, 0xFF5B8577, 0xFF5B8577, 0xFF5B8577, 0xFF5B8577, 0xFF5B8675, 0xFF5B8675, 0xFF5B8675, 0xFF5A8574, 0xFF588372,
    0xFF547F6E, 0xFF517C6B, 0xFF4E7968, 0xFF4A5F62, 0xFF56696D, 0xFF55686C, 0xFF5A6E6F, 0xFF5C7071, 0xFF556968, 0xFF5C6E6E, 0xFF607272, 0xFF4A5D61, 0xFF4A5D61, 0xFF475A5E, 0xFF495C60, 0xFF4B5E62, 0xFF475A5E, 0xFF45585C, 0xFF4A5D61, 0xFF4A6461,
    0xFF4D6361, 0xFF536565, 0xFF5B696A, 0xFF5E6C6D, 0xFF5C6A6B, 0xFF5C6E6E, 0xFF617574, 0xFF52676A, 0xFF3B5554, 0xFF395C56, 0xFF4B756B, 0xFF4E7D6D, 0xFF4E7D6B, 0xFF537E6B, 0xFF547E6A, 0xFF558170, 0xFF568271, 0xFF588473, 0xFF5B8675, 0xFF5B8675,
    0xFF5C8575, 0xFF5B8474, 0xFF5A8373, 0xFF5C8575, 0xFF557E6E, 0xFF567F6F, 0xFF578070, 0xFF537C6C, 0xFF557E6E, 0xFF4A7363, 0xFF325B4B, 0xFF4C6260, 0xFF546A68, 0xFF556968, 0xFF5E7070, 0xFF5E6E6E, 0xFF5E6E6E, 0xFF647474, 0xFF586868, 0xFF516566,
    0xFF4C6061, 0xFF516566, 0xFF45595A, 0xFF495D5E, 0xFF4A5E5F, 0xFF4B5F60, 0xFF506465, 0xFF516365, 0xFF5A6C6E, 0xFF57696B, 0xFF5B6D6F, 0xFF5B6F70, 0xFF5E7374, 0xFF526A6A, 0xFF56706F, 0xFF3D6153, 0xFF507466, 0xFF5A7E70, 0xFF5B7F71, 0xFF5E8274,
    0xFF608476, 0xFF5F8375, 0xFF608476, 0xFF5C8573, 0xFF5C8573, 0xFF5C8573, 0xFF5C8573, 0xFF5C8573, 0xFF5D8674, 0xFF5D8674, 0xFF5E8775, 0xFF5B856F, 0xFF5B8571, 0xFF577E6C, 0xFF557B6C, 0xFF4C7066, 0xFF34554E, 0xFF2B4B46, 0xFF3C5C59, 0xFF4E6462,
    0xFF526665, 0xFF5A6A6A, 0xFF596466, 0xFF5C6769, 0xFF5C6A6B, 0xFF516161, 0xFF506262, 0xFF526466, 0xFF4C5E60, 0xFF506264, 0xFF506264, 0xFF4F6163, 0xFF526466, 0xFF536567, 0xFF506264, 0xFF5A6368, 0xFF576568, 0xFF586A6C, 0xFF536B6B, 0xFF4B6564,
    0xFF4A6463, 0xFF4B6363, 0xFF495E5F, 0xFF537A68, 0xFF577E6C, 0xFF5C8371, 0xFF5D8472, 0xFF5D8472, 0xFF5C8371, 0xFF5E8573, 0xFF608775, 0xFF5F8674, 0xFF5F8674, 0xFF5F8674, 0xFF5F8674, 0xFF5E8573, 0xFF5D8472, 0xFF5C8371, 0xFF5B8270, 0xFF597E6D,
    0xFF507B6A, 0xFF487868, 0xFF36695A, 0xFF235248, 0xFF2F534F, 0xFF4A6465, 0xFF55666D, 0xFF546E6D, 0xFF546E6D, 0xFF506A69, 0xFF4E6867, 0xFF4D6766, 0xFF486261, 0xFF405A59, 0xFF395352, 0xFF3F5759, 0xFF425A5C, 0xFF41595B, 0xFF486062, 0xFF445C5E,
    0xFF455D5F, 0xFF445C5E, 0xFF486062, 0xFF506A67, 0xFF4A6360, 0xFF4F6563, 0xFF4A5E5D, 0xFF4E6261, 0xFF516765, 0xFF4A6360, 0xFF5F7976, 0xFF5F8A77, 0xFF618675, 0xFF658576, 0xFF6A8C7E, 0xFF53796A, 0x006B8B80, 0x00F5FFFD, 0x00FFFEFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFF8FF, 0x0FEDF6F5, 0xFF55746C, 0xFF578173, 0xFF62887B, 0xFF638577, 0xFF628678, 0xFF5F8576, 0xFF5B7A75, 0xFF496163, 0xFF5E6D74, 0xFF535D69, 0xFF48525E,
    0xFF3B4C53, 0xFF284445, 0xFF22453F, 0xFF40504F, 0xFF50605F, 0xFF50605F, 0xFF516160, 0xFF485857, 0xFF485857, 0xFF3E4E4D, 0xFF415150, 0xFF4E6261, 0xFF495D5C, 0xFF475B5A, 0xFF405453, 0xFF384C4B, 0xFF394D4C, 0xFF3A4E4D, 0xFF3A4E4D, 0xFF565662,
    0xFF606A73, 0xFF4C6665, 0xFF305951, 0xFF38685A, 0xFF4E7E6E, 0xFF578372, 0xFF598270, 0xFF578173, 0xFF588274, 0xFF598375, 0xFF5A8476, 0xFF5A8476, 0xFF5B8577, 0xFF5A8476, 0xFF5A8476, 0xFF598473, 0xFF5A8574, 0xFF5A8574, 0xFF5A8574, 0xFF588372,
    0xFF547F6E, 0xFF517C6B, 0xFF4E7968, 0xFF535C65, 0xFF5F6972, 0xFF505D63, 0xFF49585D, 0xFF415556, 0xFF324748, 0xFF36504D, 0xFF425C59, 0xFF506168, 0xFF4A5B62, 0xFF4B5C63, 0xFF495A61, 0xFF43545B, 0xFF46575E, 0xFF47585F, 0xFF3D4E55, 0xFF3C5F5B,
    0xFF557371, 0xFF546E6D, 0xFF405455, 0xFF3C4B4E, 0xFF425154, 0xFF415355, 0xFF405254, 0xFF687379, 0xFF45575B, 0xFF3C5957, 0xFF4C746B, 0xFF537F70, 0xFF51806E, 0xFF57826F, 0xFF59836F, 0xFF568271, 0xFF578372, 0xFF5A8574, 0xFF5C8776, 0xFF5C8776,
    0xFF5D8676, 0xFF5B8474, 0xFF5B8474, 0xFF5F8878, 0xFF588171, 0xFF598272, 0xFF588171, 0xFF537C6C, 0xFF557E6E, 0xFF4A7363, 0xFF315A4A, 0xFF606B6F, 0xFF59676A, 0xFF46585A, 0xFF435859, 0xFF3D5253, 0xFF44595A, 0xFF637879, 0xFF607475, 0xFF586970,
    0xFF4A5B62, 0xFF52636A, 0xFF46575E, 0xFF46575E, 0xFF4A5B62, 0xFF4E5F66, 0xFF495A61, 0xFF4D6569, 0xFF4E666A, 0xFF415A5E, 0xFF3E575B, 0xFF41595D, 0xFF4F6268, 0xFF516067, 0xFF67747C, 0xFF385C4E, 0xFF4C7062, 0xFF587C6E, 0xFF597D6F, 0xFF5C8072,
    0xFF5E8274, 0xFF5E8274, 0xFF5F8375, 0xFF5C8573, 0xFF5C8573, 0xFF5B8472, 0xFF5B8472, 0xFF5C8573, 0xFF5D8674, 0xFF5F8876, 0xFF5F8876, 0xFF5A866F, 0xFF59836F, 0xFF567D6B, 0xFF567A6E, 0xFF527169, 0xFF3B5854, 0xFF3D5756, 0xFF5A7272, 0xFF526768,
    0xFF4D6162, 0xFF4C5E60, 0xFF4B5A5D, 0xFF5A696C, 0xFF647879, 0xFF506868, 0xFF3E5B59, 0xFF415B5C, 0xFF3E5859, 0xFF3D5758, 0xFF395354, 0xFF3D5758, 0xFF455F60, 0xFF435D5E, 0xFF455F60, 0xFF5F7077, 0xFF52656B, 0xFF4E6368, 0xFF4D6569, 0xFF53686D,
    0xFF607379, 0xFF5E6D74, 0xFF48525B, 0xFF547B69, 0xFF587F6D, 0xFF5C8371, 0xFF5E8573, 0xFF5C8371, 0xFF5C8371, 0xFF5E8573, 0xFF608775, 0xFF5F8674, 0xFF5F8674, 0xFF5F8674, 0xFF5F8674, 0xFF5E8573, 0xFF5D8472, 0xFF5C8371, 0xFF5B8270, 0xFF5D8472,
    0xFF547F6E, 0xFF4A7A6A, 0xFF35675B, 0xFF225046, 0xFF345453, 0xFF586970, 0xFF68707B, 0xFF43585D, 0xFF43585D, 0xFF41565B, 0xFF485D62, 0xFF52676C, 0xFF51666B, 0xFF4B6065, 0xFF455A5F, 0xFF4A5863, 0xFF485661, 0xFF3F4D58, 0xFF495762, 0xFF475560,
    0xFF4D5B66, 0xFF515F6A, 0xFF5D6B76, 0xFF486563, 0xFF465B5C, 0xFF516063, 0xFF535E62, 0xFF5E696D, 0xFF5C6B6E, 0xFF485D5E, 0xFF587573, 0xFF5F8A77, 0xFF618675, 0xFF648475, 0xFF698B7D, 0xFF53796A, 0x006B8B80, 0x00F6FFFE, 0x00FFFEFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFF, 0x17E9F5F1, 0xFF52766A, 0xFF578676, 0xFF5F897B, 0xFF64887C, 0xFF698D81, 0xFF5A8375, 0xFF5A6F70, 0xFF4A5F64, 0xFF516570, 0xFF445A67, 0xFF3D535E,
    0xFF475E64, 0xFF304A47, 0xFF18332C, 0xFF1B393B, 0xFF234044, 0xFF2F4A51, 0xFF334B55, 0xFF314850, 0xFF374B52, 0xFF374A4E, 0xFF2B3F3E, 0xFF234745, 0xFF153935, 0xFF11342E, 0xFF1A3A35, 0xFF133330, 0xFF2F4D4F, 0xFF3B565D, 0xFF2E4954, 0xFF3A4F52,
    0xFF4D696A, 0xFF3D605C, 0xFF37605A, 0xFF3E6960, 0xFF4D766E, 0xFF557A73, 0xFF63847D, 0xFF5F887A, 0xFF567F71, 0xFF5B8476, 0xFF5D8779, 0xFF588274, 0xFF5A8677, 0xFF5E8A7B, 0xFF5D897A, 0xFF5C8371, 0xFF5C8573, 0xFF588370, 0xFF5B8776, 0xFF507C6B,
    0xFF638E7D, 0xFF547A6D, 0xFF517267, 0xFF4F6361, 0xFF536768, 0xFF3D5257, 0xFF374E56, 0xFF3C525D, 0xFF344C56, 0xFF1D3841, 0xFF2C4750, 0xFF4A5B62, 0xFF405359, 0xFF334A50, 0xFF2D484F, 0xFF304D51, 0xFF345051, 0xFF324B47, 0xFF2E453F, 0xFF3D544E,
    0xFF3E5753, 0xFF324C4B, 0xFF1E3C3E, 0xFF2A474B, 0xFF39545B, 0xFF314D51, 0xFF385156, 0xFF5E6263, 0xFF445857, 0xFF355C5B, 0xFF467271, 0xFF557D7C, 0xFF5D807A, 0xFF64887A, 0xFF5B8571, 0xFF578372, 0xFF578372, 0xFF588473, 0xFF588473, 0xFF598574,
    0xFF598574, 0xFF5A8675, 0xFF5A8675, 0xFF638574, 0xFF628776, 0xFF5B8472, 0xFF527E6D, 0xFF5D897A, 0xFF507C6F, 0xFF446E64, 0xFF376157, 0xFF566465, 0xFF425456, 0xFF334B4F, 0xFF355155, 0xFF253E45, 0xFF1E3239, 0xFF4D5C63, 0xFF7C868F, 0xFF818689,
    0xFF727C7E, 0xFF5D6C71, 0xFF4C6166, 0xFF455D61, 0xFF445E5F, 0xFF425B58, 0xFF415754, 0xFF2D5354, 0xFF1E4143, 0xFF193A3F, 0xFF2F4C52, 0xFF304B52, 0xFF2F474B, 0xFF33484B, 0xFF536768, 0xFF425961, 0xFF55726D, 0xFF5C7F6B, 0xFF567D68, 0xFF5B8476,
    0xFF5F897F, 0xFF588173, 0xFF557F69, 0xFF5B8472, 0xFF5B8472, 0xFF5B8472, 0xFF5B8472, 0xFF5B8472, 0xFF5A8371, 0xFF5A8371, 0xFF5A8371, 0xFF597F74, 0xFF5A7B70, 0xFF5C7E70, 0xFF57826F, 0xFF427562, 0xFF315F52, 0xFF3C5957, 0xFF586369, 0xFF385052,
    0xFF304C4F, 0xFF304F52, 0xFF294B4D, 0xFF1E4041, 0xFF284445, 0xFF3D5150, 0xFF455554, 0xFF39534A, 0xFF3B5450, 0xFF3A5453, 0xFF375054, 0xFF334F53, 0xFF345155, 0xFF39585A, 0xFF3D5D5C, 0xFF2B5152, 0xFF25484A, 0xFF26474C, 0xFF304B52, 0xFF395056,
    0xFF405359, 0xFF576669, 0xFF435152, 0xFF4E7465, 0xFF5A8373, 0xFF578372, 0xFF5C8B77, 0xFF5D8A76, 0xFF58836F, 0xFF628976, 0xFF5F8472, 0xFF5F8A77, 0xFF5F8876, 0xFF598270, 0xFF5E8775, 0xFF5F8674, 0xFF567D6B, 0xFF5A7F6E, 0xFF5D8271, 0xFF588477,
    0xFF547F75, 0xFF4F7A70, 0xFF396159, 0xFF30504D, 0xFF455A5D, 0xFF4E5B63, 0xFF4F5861, 0xFF384B5A, 0xFF39515B, 0xFF395759, 0xFF284B45, 0xFF2D5049, 0xFF36534E, 0xFF445A57, 0xFF3F5151, 0xFF394D4E, 0xFF364B4E, 0xFF30494E, 0xFF2D4A52, 0xFF335058,
    0xFF39545B, 0xFF395257, 0xFF334B4F, 0xFF2F5047, 0xFF33524D, 0xFF3C5559, 0xFF394D56, 0xFF3D515A, 0xFF556A6F, 0xFF4B6562, 0xFF56746C, 0xFF6C8C7F, 0xFF5B8474, 0xFF598A77, 0xFF5B8E7B, 0xFF55806F, 0x006E887D, 0x00F9FEFA, 0x00FFFCFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFF8FB, 0x17EAF5F1, 0xFF56776C, 0xFF598375, 0xFF60897B, 0xFF67887D, 0xFF618277, 0xFF446A5D, 0xFF425758, 0xFF465B60, 0xFF546871, 0xFF4A606B, 0xFF3F5560,
    0xFF4B6469, 0xFF455F5E, 0xFF1F3A35, 0xFF2F4D45, 0xFF314E4A, 0xFF355152, 0xFF345053, 0xFF2D494D, 0xFF2D494C, 0xFF2F4C4A, 0xFF2B4844, 0xFF1B3F3F, 0xFF193B3A, 0xFF173A36, 0xFF21413C, 0xFF23423D, 0xFF395556, 0xFF415A5F, 0xFF3B535D, 0xFF516063,
    0xFF5F7173, 0xFF47605D, 0xFF2A4944, 0xFF1C3F38, 0xFF234840, 0xFF274D42, 0xFF3D6358, 0xFF527B6D, 0xFF648D7F, 0xFF5C8577, 0xFF578173, 0xFF5B8577, 0xFF598576, 0xFF5C8879, 0xFF588475, 0xFF598270, 0xFF638E7B, 0xFF547F6C, 0xFF588372, 0xFF668F7F,
    0xFF4B6F63, 0xFF38564C, 0xFF365047, 0xFF55696A, 0xFF5D7172, 0xFF475C61, 0xFF3F565C, 0xFF425B60, 0xFF3F585D, 0xFF2A464A, 0xFF355256, 0xFF415651, 0xFF38514E, 0xFF2E4B49, 0xFF254544, 0xFF1E3E3D, 0xFF1E3C3A, 0xFF2A4742, 0xFF39544D, 0xFF385249,
    0xFF3E5751, 0xFF3A5451, 0xFF294546, 0xFF334F52, 0xFF445D62, 0xFF41585E, 0xFF42595F, 0xFF5A6567, 0xFF47615E, 0xFF2C534E, 0xFF1E4942, 0xFF294E47, 0xFF375B51, 0xFF487161, 0xFF5B8C77, 0xFF578372, 0xFF588473, 0xFF588473, 0xFF598574, 0xFF598574,
    0xFF5A8675, 0xFF5A8675, 0xFF5A8675, 0xFF608774, 0xFF4F7664, 0xFF5E8775, 0xFF588171, 0xFF3E6759, 0xFF294F44, 0xFF2C4F48, 0xFF2E4F48, 0xFF5A686B, 0xFF47595B, 0xFF405558, 0xFF496266, 0xFF3F585C, 0xFF374C4F, 0xFF596B6F, 0xFF7E8C8F, 0xFF8C908F,
    0xFF747C7E, 0xFF566465, 0xFF415458, 0xFF384D50, 0xFF354B49, 0xFF394D4B, 0xFF3E534C, 0xFF335352, 0xFF284749, 0xFF264446, 0xFF395559, 0xFF3F585D, 0xFF40585C, 0xFF3E5356, 0xFF54696C, 0xFF4E626B, 0xFF37504C, 0xFF2E4D3B, 0xFF3B5E4A, 0xFF4E7266,
    0xFF5D827A, 0xFF62887B, 0xFF5F8671, 0xFF5C8573, 0xFF5C8573, 0xFF5C8573, 0xFF5B8472, 0xFF5B8472, 0xFF5B8472, 0xFF5B8472, 0xFF5A8371, 0xFF598176, 0xFF698A7F, 0xFF4E6C60, 0xFF375949, 0xFF295443, 0xFF285045, 0xFF476160, 0xFF5B686E, 0xFF4C6166,
    0xFF374F53, 0xFF3D5B5D, 0xFF3C5B5D, 0xFF224040, 0xFF2B4544, 0xFF425654, 0xFF384845, 0xFF3D544A, 0xFF374E46, 0xFF354B48, 0xFF394E4F, 0xFF3B5051, 0xFF344A48, 0xFF2B423C, 0xFF273E36, 0xFF2D504C, 0xFF284847, 0xFF2D4B4D, 0xFF385457, 0xFF41595D,
    0xFF44595C, 0xFF586C6D, 0xFF46585A, 0xFF355347, 0xFF3E5E51, 0xFF496D5F, 0xFF598471, 0xFF598471, 0xFF5B8672, 0xFF66907C, 0xFF527966, 0xFF5A8572, 0xFF5D8674, 0xFF598270, 0xFF5D8674, 0xFF5E8573, 0xFF59806E, 0xFF5F8473, 0xFF5E8372, 0xFF517A6C,
    0xFF3A6458, 0xFF355F53, 0xFF2F574E, 0xFF2B4E48, 0xFF3C5957, 0xFF556A6D, 0xFF5E7074, 0xFF4E606C, 0xFF44585F, 0xFF3A5657, 0xFF30504B, 0xFF33544D, 0xFF2C4944, 0xFF324846, 0xFF344849, 0xFF324B47, 0xFF354F4C, 0xFF355152, 0xFF304E50, 0xFF2C4A4A,
    0xFF2F4948, 0xFF334946, 0xFF334841, 0xFF395850, 0xFF425C59, 0xFF4A5F64, 0xFF465960, 0xFF4D5E66, 0xFF607379, 0xFF495F5D, 0xFF4E6761, 0xFF5B756A, 0xFF5F7F72, 0xFF648F7E, 0xFF5E8D7B, 0xFF4F7868, 0x006B857A, 0x00FBFFFC, 0x00FFFCFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFBFF, 0x0FEEF7F4, 0xFF547268, 0xFF567F71, 0xFF688C80, 0xFF66847A, 0xFF4C675E, 0xFF26463B, 0xFF314546, 0xFF4E6368, 0xFF4D6168, 0xFF496068, 0xFF5E777E,
    0xFF577377, 0xFF3F5B5C, 0xFF264341, 0xFF2F4B3F, 0xFF2D4B43, 0xFF33514F, 0xFF3B5A5C, 0xFF3B5C61, 0xFF3D6064, 0xFF426569, 0xFF416768, 0xFF2C4F55, 0xFF2B4D4F, 0xFF20403F, 0xFF1B3937, 0xFF203D39, 0xFF3D5756, 0xFF566E70, 0xFF687D82, 0xFF647070,
    0xFF667272, 0xFF465454, 0xFF2A3A37, 0xFF182D28, 0xFF183229, 0xFF113126, 0xFF1F4337, 0xFF365F51, 0xFF648D7F, 0xFF5A8375, 0xFF547E70, 0xFF5E887A, 0xFF588475, 0xFF5C8879, 0xFF598576, 0xFF5B8874, 0xFF5A8773, 0xFF598473, 0xFF608979, 0xFF55766B,
    0xFF375148, 0xFF798C86, 0xFF94A09E, 0xFF4F6165, 0xFF506367, 0xFF4B6063, 0xFF637B7D, 0xFF688281, 0xFF466361, 0xFF203E3C, 0xFF294946, 0xFF2C473E, 0xFF26443C, 0xFF284B47, 0xFF365A5A, 0xFF3B6162, 0xFF385B5D, 0xFF325455, 0xFF345252, 0xFF39574F,
    0xFF3C5752, 0xFF38534E, 0xFF2F4747, 0xFF3A5254, 0xFF576C71, 0xFF63777E, 0xFF667882, 0xFF627677, 0xFF3A5753, 0xFF15392F, 0xFF052719, 0xFF153123, 0xFF213D2F, 0xFF264F3F, 0xFF4B806C, 0xFF588473, 0xFF588473, 0xFF588473, 0xFF598574, 0xFF598574,
    0xFF5A8675, 0xFF5A8675, 0xFF5B8776, 0xFF57826F, 0xFF618A78, 0xFF63897A, 0xFF3A5B50, 0xFF28463E, 0xFF26413C, 0xFF314744, 0xFF425856, 0xFF56656A, 0xFF4C5E62, 0xFF4F6465, 0xFF556F6E, 0xFF3F5958, 0xFF28413E, 0xFF3B514F, 0xFF556968, 0xFF757F7E,
    0xFF637172, 0xFF526466, 0xFF4A6266, 0xFF445D61, 0xFF3C5454, 0xFF39524F, 0xFF3E554F, 0xFF3A5453, 0xFF2E4847, 0xFF2B4544, 0xFF405A59, 0xFF526C6D, 0xFF5E7678, 0xFF51696D, 0xFF5B7377, 0xFF404E59, 0xFF576A68, 0xFF718878, 0xFF607B6A, 0xFF3F5A51,
    0xFF486761, 0xFF64857A, 0xFF5F8570, 0xFF5D8674, 0xFF5C8573, 0xFF5C8573, 0xFF5C8573, 0xFF5C8573, 0xFF5B8472, 0xFF5B8472, 0xFF5B8472, 0xFF5E887C, 0xFF4D6B61, 0xFF2E4239, 0xFF283C31, 0xFF183428, 0xFF113028, 0xFF3E5656, 0xFF5D6C71, 0xFF596C73,
    0xFF5B6F76, 0xFF577074, 0xFF466263, 0xFF2F4C4A, 0xFF294340, 0xFF364C49, 0xFF425654, 0xFF445F58, 0xFF3E5954, 0xFF3F5855, 0xFF465B5C, 0xFF455957, 0xFF3C4F49, 0xFF394A40, 0xFF3C4E40, 0xFF294641, 0xFF2B4843, 0xFF405D59, 0xFF5B7572, 0xFF5F7978,
    0xFF506A6B, 0xFF556D6F, 0xFF3D5559, 0xFF6D7C77, 0xFF63776E, 0xFF3E5A4E, 0xFF486A5C, 0xFF648D7B, 0xFF5A8572, 0xFF55806C, 0xFF618B77, 0xFF588370, 0xFF5D8674, 0xFF5A8371, 0xFF5C8573, 0xFF5E8573, 0xFF5D8472, 0xFF5F8473, 0xFF557A69, 0xFF365244,
    0xFF264438, 0xFF1E4032, 0xFF113529, 0xFF10342A, 0xFF385751, 0xFF647E7B, 0xFF5C7572, 0xFF697780, 0xFF5A6D71, 0xFF465E5E, 0xFF324F4A, 0xFF2F4C47, 0xFF264341, 0xFF31494B, 0xFF43575E, 0xFF4A6866, 0xFF4A6A69, 0xFF456768, 0xFF426261, 0xFF3F5D5B,
    0xFF3F5852, 0xFF3D5146, 0xFF384A3C, 0xFF2E4944, 0xFF425758, 0xFF5D6F73, 0xFF5E6D74, 0xFF57646C, 0xFF6A797E, 0xFF4A5C5E, 0xFF3F5351, 0xFF45524B, 0xFF566B62, 0xFF648678, 0xFF628D7C, 0xFF527869, 0x006F897E, 0x00F9FFFD, 0x00FFFEFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFAFE, 0x0BEFF8F5, 0xFF557369, 0xFF5D8376, 0xFF709085, 0xFF587269, 0xFF3A5149, 0xFF375249, 0xFF3C4F53, 0xFF4B5E62, 0xFF495E63, 0xFF3B5258, 0xFF435C61,
    0xFF2A474B, 0xFF1A383A, 0xFF29484A, 0xFF284543, 0xFF2C4A4C, 0xFF34555E, 0xFF3F606F, 0xFF42677A, 0xFF3E677B, 0xFF376273, 0xFF2E5C6C, 0xFF446876, 0xFF42646E, 0xFF36575E, 0xFF264547, 0xFF1C3937, 0xFF2A4242, 0xFF3F5455, 0xFF4D6064, 0xFF304741,
    0xFF51615E, 0xFF4D5756, 0xFF4D5353, 0xFF373D3B, 0xFF25302C, 0xFF2E3F37, 0xFF445950, 0xFF30594B, 0xFF537C6E, 0xFF598274, 0xFF588274, 0xFF5B8577, 0xFF578374, 0xFF5B8778, 0xFF5C8879, 0xFF5C8B79, 0xFF558472, 0xFF598574, 0xFF63897C, 0xFF436157,
    0xFF4D605A, 0xFF97A09F, 0xFF8A8B8D, 0xFF52636B, 0xFF44555C, 0xFF2F4344, 0xFF47605D, 0xFF4B6863, 0xFF2D4C46, 0xFF133630, 0xFF254842, 0xFF2D4F4E, 0xFF325557, 0xFF396067, 0xFF3B6571, 0xFF376171, 0xFF30596B, 0xFF365B6D, 0xFF3D6073, 0xFF406261,
    0xFF375754, 0xFF324F4D, 0xFF334947, 0xFF374B4C, 0xFF425458, 0xFF3F5057, 0xFF31444B, 0xFF516367, 0xFF445A58, 0xFF455C52, 0xFF304033, 0xFF343C2F, 0xFF465349, 0xFF39574B, 0xFF39675A, 0xFF588473, 0xFF588473, 0xFF598574, 0xFF598574, 0xFF5A8675,
    0xFF5A8675, 0xFF5A8675, 0xFF5B8776, 0xFF568772, 0xFF588473, 0xFF476B5D, 0xFF38534A, 0xFF465B56, 0xFF354544, 0xFF324041, 0xFF414F50, 0xFF4D5E65, 0xFF43565A, 0xFF455A5B, 0xFF4A635F, 0xFF37524D, 0xFF233E39, 0xFF2F4946, 0xFF455F5E, 0xFF4E6972,
    0xFF44606B, 0xFF395966, 0xFF355967, 0xFF355B68, 0xFF375B67, 0xFF3D5F68, 0xFF43646B, 0xFF3D5557, 0xFF304848, 0xFF29423F, 0xFF334C49, 0xFF3E5754, 0xFF455F5E, 0xFF364F53, 0xFF465F64, 0xFF4F5965, 0xFF626E6E, 0xFFAEBCAF, 0xFFB1C1B4, 0xFF4D625B,
    0xFF38534E, 0xFF6A8A7F, 0xFF618772, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5C8573, 0xFF5C8573, 0xFF5C8573, 0xFF5C8573, 0xFF4F7B6E, 0xFF435E55, 0xFF5F6A64, 0xFF545B54, 0xFF293831, 0xFF2E453F, 0xFF44595A, 0xFF4A5C60, 0xFF44555F,
    0xFF54676E, 0xFF4E6366, 0xFF3A5252, 0xFF2F4946, 0xFF223F3B, 0xFF264341, 0xFF3E5B59, 0xFF466F75, 0xFF3B6269, 0xFF365B64, 0xFF41626B, 0xFF4F6C72, 0xFF526C6D, 0xFF49625E, 0xFF425951, 0xFF354E48, 0xFF2E4741, 0xFF39524C, 0xFF4A655E, 0xFF4C6762,
    0xFF3E5B59, 0xFF4C686B, 0xFF3B575B, 0xFF9EA2A1, 0xFFB7C2BE, 0xFF6D807A, 0xFF355347, 0xFF55796B, 0xFF658E7C, 0xFF5A8572, 0xFF588370, 0xFF5B8673, 0xFF608977, 0xFF5D8674, 0xFF5D8674, 0xFF608775, 0xFF608775, 0xFF587D6C, 0xFF406554, 0xFF555C54,
    0xFF556058, 0xFF4A5A50, 0xFF2D4239, 0xFF1E382F, 0xFF38514B, 0xFF617774, 0xFF445856, 0xFF415053, 0xFF3E5052, 0xFF324645, 0xFF27403D, 0xFF314B4A, 0xFF395558, 0xFF45626A, 0xFF54707C, 0xFF456975, 0xFF456B78, 0xFF466C79, 0xFF466A76, 0xFF4B6971,
    0xFF4C6569, 0xFF485B59, 0xFF41504B, 0xFF364B4C, 0xFF3B4F50, 0xFF59686D, 0xFF59646A, 0xFF475057, 0xFF6A757B, 0xFF556467, 0xFF455759, 0xFF4F514E, 0xFF59665F, 0xFF607A6F, 0xFF688C7E, 0xFF567A6C, 0x006E887D, 0x00F8FFFD, 0x00FFFFFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFF9FC, 0x0BF0FBF7, 0xFF58786D, 0xFF5E8477, 0xFF6D8D82, 0xFF526961, 0xFF586D66, 0xFF9CB6AD, 0xFF819397, 0xFF495C60, 0xFF4B6063, 0xFF334D4E, 0xFF1C383B,
    0xFF173639, 0xFF1C3D42, 0xFF25484E, 0xFF355669, 0xFF496C82, 0xFF60839F, 0xFF6D93B7, 0xFF759FC5, 0xFF7AA6CD, 0xFF73A3C9, 0xFF6B9DC2, 0xFF4E7690, 0xFF476D82, 0xFF446876, 0xFF395A61, 0xFF2C4A4C, 0xFF2D4748, 0xFF364B4C, 0xFF324748, 0xFF284942,
    0xFF4D6863, 0xFF51615E, 0xFF818A89, 0xFF939496, 0xFF868686, 0xFF8C8E8D, 0xFF838786, 0xFF4D7668, 0xFF456E60, 0xFF588173, 0xFF5E887A, 0xFF578173, 0xFF5B8778, 0xFF5B8778, 0xFF5D897A, 0xFF5A8B78, 0xFF588775, 0xFF537F70, 0xFF63897C, 0xFF38534A,
    0xFF52625F, 0xFF727878, 0xFF666668, 0xFF4E5C67, 0xFF4A5B62, 0xFF2A3E3D, 0xFF263F3B, 0xFF24423A, 0xFF1F3F3A, 0xFF1C403E, 0xFF29504F, 0xFF42677A, 0xFF466F85, 0xFF507C97, 0xFF5E8CAD, 0xFF6E9CC0, 0xFF729EC5, 0xFF658FB5, 0xFF557CA3, 0xFF436D79,
    0xFF325861, 0xFF2E4D52, 0xFF385052, 0xFF415353, 0xFF425456, 0xFF384B4F, 0xFF26393F, 0xFF4B545D, 0xFF4F5A5C, 0xFF88918E, 0xFF93948E, 0xFF87807A, 0xFF8A8782, 0xFF62716A, 0xFF3A5B52, 0xFF588473, 0xFF588473, 0xFF588473, 0xFF598574, 0xFF598574,
    0xFF5A8675, 0xFF5A8675, 0xFF5A8675, 0xFF568976, 0xFF568271, 0xFF47685D, 0xFF49605A, 0xFF5E6E6D, 0xFF657171, 0xFF6D787A, 0xFF4E595D, 0xFF4F6268, 0xFF35484C, 0xFF2B413F, 0xFF324943, 0xFF314C47, 0xFF314E4C, 0xFF3C5B5E, 0xFF4D6C71, 0xFF335F78,
    0xFF3F6E88, 0xFF4B7E9B, 0xFF5388A7, 0xFF558AA9, 0xFF5285A2, 0xFF457790, 0xFF3A6A81, 0xFF425D66, 0xFF355057, 0xFF2B4748, 0xFF27413E, 0xFF213C37, 0xFF223C3B, 0xFF1B3438, 0xFF3F585D, 0xFF4D5562, 0xFF788082, 0xFF7C867B, 0xFF717B70, 0xFF606F6A,
    0xFF475D5A, 0xFF4B6B60, 0xFF648B76, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5C8573, 0xFF5C8573, 0xFF5C8573, 0xFF4B776A, 0xFF4D675E, 0xFFB1B7B3, 0xFFB1B2AD, 0xFF757E79, 0xFF647773, 0xFF45595A, 0xFF4F6165, 0xFF2E3F49,
    0xFF293C42, 0xFF304347, 0xFF314949, 0xFF294644, 0xFF304F52, 0xFF3B5E64, 0xFF3A5F68, 0xFF285E76, 0xFF3E748C, 0xFF5486A1, 0xFF55839D, 0xFF4A748C, 0xFF426B7D, 0xFF466C79, 0xFF496F78, 0xFF3F5757, 0xFF2C4542, 0xFF223B35, 0xFF243F36, 0xFF26413A,
    0xFF26433F, 0xFF446063, 0xFF3D585F, 0xFF5C5C5E, 0xFF838987, 0xFF65746F, 0xFF425C53, 0xFF4D6F61, 0xFF567F6F, 0xFF5A8572, 0xFF598471, 0xFF5C8774, 0xFF608977, 0xFF5D8674, 0xFF5F8876, 0xFF638A78, 0xFF628977, 0xFF547968, 0xFF305544, 0xFF7E7371,
    0xFF8E8684, 0xFF8B8C87, 0xFF828884, 0xFF6B7672, 0xFF4C5856, 0xFF596565, 0xFF3D4949, 0xFF2F3F3F, 0xFF304242, 0xFF2E4241, 0xFF344C4C, 0xFF425E62, 0xFF476772, 0xFF426676, 0xFF41657B, 0xFF4B7494, 0xFF557E9E, 0xFF5C85A5, 0xFF5B82A1, 0xFF577A96,
    0xFF567288, 0xFF546B7D, 0xFF526574, 0xFF485D60, 0xFF3D4F53, 0xFF475558, 0xFF4C555A, 0xFF454E53, 0xFF667175, 0xFF546167, 0xFF637277, 0xFF7A7977, 0xFF68716C, 0xFF597066, 0xFF698D7F, 0xFF5B7F71, 0x006B857A, 0x00F3FEF8, 0x00FFFFFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFEFF, 0x13ECFBF6, 0xFF55766B, 0xFF5B8476, 0xFF6C8D82, 0xFF556F66, 0xFF627971, 0xFFB1CBC2, 0xFF8FA1A5, 0xFF4D5F63, 0xFF4B6061, 0xFF2E4847, 0xFF2C4A4A,
    0xFF335557, 0xFF2B4E54, 0xFF2A4F58, 0xFF4F779A, 0xFF6791B7, 0xFF7AA3CF, 0xFF7BA5D5, 0xFF79A4D7, 0xFF77A5D7, 0xFF74A4D4, 0xFF70A3D2, 0xFF77A3CA, 0xFF618CAE, 0xFF547C95, 0xFF406575, 0xFF32535A, 0xFF2E4B4F, 0xFF354F50, 0xFF2C4446, 0xFF264945,
    0xFF45645F, 0xFF405654, 0xFF7B898A, 0xFFADB5B7, 0xFFCED2D5, 0xFFF7F8FA, 0xFFF4F5F7, 0xFF769F91, 0xFF517A6C, 0xFF5E8779, 0xFF608A7C, 0xFF557F71, 0xFF5B8778, 0xFF558172, 0xFF517D6E, 0xFF568573, 0xFF5B8A7A, 0xFF5A8677, 0xFF608679, 0xFF3B5951,
    0xFF9AADA9, 0xFFBDC5C7, 0xFF929699, 0xFF485460, 0xFF526166, 0xFF394D4C, 0xFF334E47, 0xFF284741, 0xFF224445, 0xFF2B5058, 0xFF3E6471, 0xFF547EA4, 0xFF6894BB, 0xFF74A5D0, 0xFF71A4D3, 0xFF6A9ECE, 0xFF6D9FD0, 0xFF74A4D4, 0xFF79A5D4, 0xFF689BBA,
    0xFF528098, 0xFF3F6373, 0xFF425B62, 0xFF445859, 0xFF455957, 0xFF485E5C, 0xFF3E5656, 0xFF565F66, 0xFF4B565A, 0xFF879192, 0xFFBDBDBF, 0xFFE5DCDF, 0xFFFAF4F6, 0xFFA8B4B0, 0xFF425D56, 0xFF578372, 0xFF578372, 0xFF588473, 0xFF588473, 0xFF598574,
    0xFF598574, 0xFF5A8675, 0xFF5A8675, 0xFF588D79, 0xFF5E8A7B, 0xFF3F5F54, 0xFF506560, 0xFFB0BEBE, 0xFFDCE7E9, 0xFFABBABD, 0xFF415355, 0xFF4D6567, 0xFF34494A, 0xFF2C403E, 0xFF304741, 0xFF324A4A, 0xFF37545A, 0xFF406170, 0xFF4E7386, 0xFF558BB1,
    0xFF5F99BF, 0xFF6AA5CF, 0xFF6AA7D3, 0xFF6BA8D4, 0xFF6EA9D3, 0xFF69A0C7, 0xFF6094BB, 0xFF577A90, 0xFF416575, 0xFF2F5258, 0xFF244441, 0xFF22413B, 0xFF2D4744, 0xFF273F41, 0xFF4F676B, 0xFF49515E, 0xFF848C8E, 0xFFB2B8AE, 0xFFA0A89D, 0xFF606C68,
    0xFF475D5A, 0xFF5D8175, 0xFF5D8972, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5C8573, 0xFF5C8573, 0xFF5C8573, 0xFF4D776B, 0xFF49635A, 0xFFB5BBB7, 0xFFD4D6D1, 0xFFB5C0BA, 0xFF859894, 0xFF3C5051, 0xFF58676C, 0xFF3D5158,
    0xFF384D52, 0xFF354A4B, 0xFF304A49, 0xFF314E52, 0xFF385C68, 0xFF436E81, 0xFF4A7892, 0xFF67A3C7, 0xFF6CA6CC, 0xFF6FA6CF, 0xFF6EA3CD, 0xFF6FA3CB, 0xFF6D9FC2, 0xFF5B8CAC, 0xFF467893, 0xFF4E6875, 0xFF3F5A61, 0xFF34514F, 0xFF334E47, 0xFF37524B,
    0xFF3C5653, 0xFF566E72, 0xFF445B63, 0xFF8C8D8F, 0xFFC4CDCC, 0xFF8FA09A, 0xFF3D584F, 0xFF406458, 0xFF5D8676, 0xFF638E7D, 0xFF578271, 0xFF5A8572, 0xFF5D8674, 0xFF5C8573, 0xFF5F8876, 0xFF628977, 0xFF638A78, 0xFF567B6A, 0xFF315645, 0xFFA49696,
    0xFFC7BDBE, 0xFFB1ADAC, 0xFF959998, 0xFF828B8A, 0xFF525C5D, 0xFF5C6668, 0xFF4B5557, 0xFF384C4D, 0xFF3A4E4F, 0xFF3F5457, 0xFF4E656B, 0xFF4D6B76, 0xFF4E7386, 0xFF517D96, 0xFF5D8CAA, 0xFF719CC7, 0xFF75A1CE, 0xFF78A4D1, 0xFF74A0CD, 0xFF6F9AC5,
    0xFF6B91B8, 0xFF6586A9, 0xFF5F7C9C, 0xFF4D6267, 0xFF43565A, 0xFF425154, 0xFF4E5A5A, 0xFF515D5D, 0xFF606B6F, 0xFF48575C, 0xFF8899A0, 0xFFD3D5D2, 0xFF95A29B, 0xFF557165, 0xFF608677, 0xFF5A7E70, 0x00708A7F, 0x00F3FEF8, 0x00FCFCFA, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FCFEFD, 0x26E1F4EE, 0xFF4F786A, 0xFF598576, 0xFF6C9285, 0xFF5E7970, 0xFF486259, 0xFF5A756C, 0xFF536269, 0xFF495B5D, 0xFF4E6462, 0xFF2B4641, 0xFF33514F,
    0xFF284B4D, 0xFF264B54, 0xFF4A707D, 0xFF6798C0, 0xFF76A7D0, 0xFF7BABD9, 0xFF77A7D8, 0xFF74A4D5, 0xFF71A1D1, 0xFF70A0CE, 0xFF74A5CE, 0xFF7AACDD, 0xFF71A2CD, 0xFF6694B5, 0xFF4D778D, 0xFF3B616E, 0xFF2A4B52, 0xFF2B484C, 0xFF2A4649, 0xFF364B50,
    0xFF5D7277, 0xFF4B6365, 0xFF385052, 0xFF2B4041, 0xFF4C6061, 0xFF8D9C9F, 0xFFAEBCBD, 0xFF5F887A, 0xFF517A6C, 0xFF5A8375, 0xFF5B8577, 0xFF5A8476, 0xFF628E7F, 0xFF5F8B7C, 0xFF5E8A7B, 0xFF558474, 0xFF5E8D7D, 0xFF5E8A7B, 0xFF567E73, 0xFF597A71,
    0xFFD5EEEA, 0xFFECFCFB, 0xFF7E8889, 0xFF536069, 0xFF536267, 0xFF324644, 0xFF2F4A45, 0xFF254542, 0xFF25484E, 0xFF416679, 0xFF6388A3, 0xFF71A0CC, 0xFF72A2D0, 0xFF6FA3D3, 0xFF69A1D2, 0xFF6AA2D3, 0xFF6EA7D4, 0xFF6FA4D0, 0xFF6CA0C8, 0xFF6CA9D8,
    0xFF6A9EC6, 0xFF58809A, 0xFF496772, 0xFF395151, 0xFF334946, 0xFF36514A, 0xFF2F4C47, 0xFF5B6D71, 0xFF40585A, 0xFF395155, 0xFF48575E, 0xFF999DA6, 0xFFE7EFF2, 0xFFB4C9C4, 0xFF537469, 0xFF568271, 0xFF568271, 0xFF578372, 0xFF578372, 0xFF588473,
    0xFF588473, 0xFF598574, 0xFF598574, 0xFF528773, 0xFF5E8A7B, 0xFF4B6A62, 0xFF475C57, 0xFF839191, 0xFF819191, 0xFF506566, 0xFF375150, 0xFF4B6564, 0xFF3A504E, 0xFF3B504B, 0xFF3E5250, 0xFF3E565A, 0xFF446171, 0xFF4F728E, 0xFF6389AD, 0xFF689CC4,
    0xFF6BA2CB, 0xFF6BA4D1, 0xFF67A1CF, 0xFF68A0CF, 0xFF6DA3D1, 0xFF73A4CF, 0xFF73A2CC, 0xFF6D99BC, 0xFF56829D, 0xFF3B6571, 0xFF254B4C, 0xFF274742, 0xFF34514C, 0xFF2D4243, 0xFF4F6266, 0xFF505A66, 0xFF626A6C, 0xFF7E847A, 0xFF8D9389, 0xFF697571,
    0xFF4E6763, 0xFF5C8577, 0xFF578970, 0xFF5D8674, 0xFF5D8674, 0xFF5D8674, 0xFF5C8573, 0xFF5C8573, 0xFF5C8573, 0xFF5C8573, 0xFF5C8573, 0xFF547C71, 0xFF445E55, 0xFF65706A, 0xFF768078, 0xFF72817A, 0xFF5D726D, 0xFF405254, 0xFF556268, 0xFF324B4F,
    0xFF3B5554, 0xFF344E4D, 0xFF2F4B4C, 0xFF3D5E67, 0xFF477086, 0xFF5686AA, 0xFF6EA3CF, 0xFF689CC3, 0xFF6B9FC7, 0xFF6C9FCC, 0xFF6C9FCE, 0xFF6FA2D1, 0xFF71A4D1, 0xFF6CA0C8, 0xFF6498BF, 0xFF56748E, 0xFF496678, 0xFF38555B, 0xFF2B4844, 0xFF314A44,
    0xFF3F5552, 0xFF56696D, 0xFF3B4C54, 0xFF808A89, 0xFFA1B0AD, 0xFF69807A, 0xFF415F55, 0xFF5E8276, 0xFF5E8777, 0xFF527B6B, 0xFF5F8878, 0xFF598471, 0xFF5C8573, 0xFF5D8674, 0xFF5F8876, 0xFF5E8573, 0xFF608775, 0xFF5C8170, 0xFF3F6453, 0xFFC0C0C0,
    0xFFFBFFFF, 0xFFB8C2C1, 0xFF677776, 0xFF5E7070, 0xFF425657, 0xFF586A6E, 0xFF495B5F, 0xFF3B5355, 0xFF3F5759, 0xFF4A6167, 0xFF55707B, 0xFF4A6B7E, 0xFF557E9A, 0xFF6597BA, 0xFF71ABD1, 0xFF74A1CB, 0xFF71A0CC, 0xFF6C9FCC, 0xFF6CA0CF, 0xFF71A4D3,
    0xFF73A4CF, 0xFF6C99C2, 0xFF638DB5, 0xFF587176, 0xFF4E6368, 0xFF465858, 0xFF495956, 0xFF485754, 0xFF596969, 0xFF43545B, 0xFF889BA2, 0xFFE6F1EB, 0xFFA7BBB2, 0xFF5B7B6E, 0xFF5C8575, 0xFF517768, 0x006F897E, 0x00F8FFFD, 0x00FFFFFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FBFFFF, 0x2EDEF5ED, 0xFF4D7769, 0xFF4D7D6D, 0xFF668F81, 0xFF749288, 0xFF5C776E, 0xFF47655B, 0xFF505F66, 0xFF4F6163, 0xFF566C69, 0xFF344F4A, 0xFF2D4D48,
    0xFF1E4143, 0xFF3D636C, 0xFF7198A7, 0xFF74AED3, 0xFF74AED4, 0xFF70A7D0, 0xFF70A5D1, 0xFF75A8D3, 0xFF75A6CF, 0xFF73A3C9, 0xFF78A9CA, 0xFF699DD6, 0xFF77ABDB, 0xFF7AACD1, 0xFF618FA9, 0xFF4C7686, 0xFF2E535C, 0xFF2C4D52, 0xFF375659, 0xFF474D59,
    0xFF606D76, 0xFF50646B, 0xFF294749, 0xFF1A3C3D, 0xFF3C5E5D, 0xFF496767, 0xFF435F60, 0xFF477062, 0xFF5E8779, 0xFF628B7D, 0xFF5B8577, 0xFF5C8678, 0xFF598576, 0xFF588475, 0xFF598576, 0xFF5C8879, 0xFF568273, 0xFF537F72, 0xFF5E887C, 0xFF597D73,
    0xFF607D78, 0xFF7C908E, 0xFF718180, 0xFF4F5C64, 0xFF576669, 0xFF374B49, 0xFF2F4A45, 0xFF2D4D4C, 0xFF3A5E6A, 0xFF567B95, 0xFF678DB1, 0xFF73A4CF, 0xFF6EA3CF, 0xFF69A2CF, 0xFF68A3CF, 0xFF67A5CE, 0xFF68A4C9, 0xFF69A4C6, 0xFF6BA4C2, 0xFF5F9FDC,
    0xFF72AADB, 0xFF6B96B8, 0xFF557584, 0xFF3C5657, 0xFF314A44, 0xFF36544A, 0xFF32534A, 0xFF547270, 0xFF355959, 0xFF254B4E, 0xFF335159, 0xFF5F737C, 0xFF6E8185, 0xFF53726C, 0xFF4E7A69, 0xFF568271, 0xFF568271, 0xFF568271, 0xFF578372, 0xFF578372,
    0xFF588473, 0xFF588473, 0xFF598574, 0xFF508372, 0xFF598375, 0xFF68877F, 0xFF4B5F5D, 0xFF495959, 0xFF3E5251, 0xFF284241, 0xFF325251, 0xFF526C69, 0xFF39524E, 0xFF374C47, 0xFF3A4E4C, 0xFF415860, 0xFF516D83, 0xFF5F83A7, 0xFF729BC7, 0xFF74A1C8,
    0xFF72A2CA, 0xFF71A2CD, 0xFF6EA1CE, 0xFF6D9DCB, 0xFF6D9CC8, 0xFF729CC6, 0xFF779EC7, 0xFF6EA3CD, 0xFF6597B8, 0xFF507F91, 0xFF2E5759, 0xFF22453F, 0xFF2F4C47, 0xFF2B413F, 0xFF526466, 0xFF4F5B67, 0xFF7A8485, 0xFFA3A99F, 0xFFA1A79D, 0xFF687470,
    0xFF4C6762, 0xFF608A7C, 0xFF51876D, 0xFF5D8674, 0xFF5D8674, 0xFF5C8573, 0xFF5C8573, 0xFF5C8573, 0xFF5C8573, 0xFF5B8472, 0xFF5B8472, 0xFF62887D, 0xFF4B655C, 0xFF5D6A63, 0xFF95A299, 0xFF879C93, 0xFF4D6660, 0xFF485C5D, 0xFF576268, 0xFF335151,
    0xFF2B4846, 0xFF375450, 0xFF446264, 0xFF456975, 0xFF58849F, 0xFF6BA0CC, 0xFF68A4DA, 0xFF739EC1, 0xFF729CC2, 0xFF709BC6, 0xFF709CCB, 0xFF6F9DCE, 0xFF6F9FCD, 0xFF6FA0CB, 0xFF6EA1CC, 0xFF7091B2, 0xFF5F7F98, 0xFF41616C, 0xFF2A4745, 0xFF2F4842,
    0xFF465A58, 0xFF627174, 0xFF45525B, 0xFF657373, 0xFF718480, 0xFF556E68, 0xFF4B6C63, 0xFF5E8477, 0xFF608679, 0xFF5E8475, 0xFF5A8071, 0xFF5A8572, 0xFF5E8775, 0xFF608977, 0xFF608977, 0xFF59806E, 0xFF5B8270, 0xFF608574, 0xFF4C7160, 0xFF909F9C,
    0xFFE8FBF9, 0xFFA4BDB9, 0xFF4F6C68, 0xFF587674, 0xFF415F5F, 0xFF4D6B6D, 0xFF385457, 0xFF334F52, 0xFF3E575B, 0xFF4D666D, 0xFF5B7785, 0xFF577992, 0xFF6C99BA, 0xFF6FA6CD, 0xFF609FCB, 0xFF6E9EC2, 0xFF70A2C7, 0xFF6EA3CB, 0xFF6AA3CE, 0xFF6AA3CE,
    0xFF6DA4CD, 0xFF6DA2CA, 0xFF6A9EC5, 0xFF668188, 0xFF50686C, 0xFF4C605F, 0xFF4B5E5A, 0xFF435350, 0xFF617373, 0xFF3E5157, 0xFF52666F, 0xFF707F78, 0xFF698378, 0xFF54786A, 0xFF679382, 0xFF507969, 0x00688277, 0x00F5FEF9, 0x00FFFFFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FDFBFE, 0x2EDEEEEB, 0xFF4B7368, 0xFF538373, 0xFF618B7D, 0xFF64887A, 0xFF618577, 0xFF5F8576, 0xFF536C71, 0xFF575F6A, 0xFF585F69, 0xFF38514B, 0xFF2F4F42,
    0xFF2B4542, 0xFF58798C, 0xFF73A5C6, 0xFF72A5D2, 0xFF74A7D4, 0xFF75A8D5, 0xFF74A7D4, 0xFF73A6D3, 0xFF72A5D2, 0xFF73A6D3, 0xFF74A7D4, 0xFF6FA4C6, 0xFF71A7CD, 0xFF74A9D1, 0xFF6CA0C7, 0xFF4C7B99, 0xFF496F82, 0xFF314E52, 0xFF3C5551, 0xFF3B4E54,
    0xFF626C75, 0xFF4B5E62, 0xFF325D54, 0xFF336156, 0xFF45645C, 0xFF4C6A60, 0xFF517A6A, 0xFF568072, 0xFF5C8678, 0xFF598375, 0xFF558172, 0xFF598576, 0xFF598878, 0xFF578676, 0xFF578676, 0xFF5C8273, 0xFF618778, 0xFF5B8172, 0xFF598274, 0xFF588274,
    0xFF517B6F, 0xFF467265, 0xFF386457, 0xFF4D535F, 0xFF607276, 0xFF415C57, 0xFF304E46, 0xFF334D4E, 0xFF557280, 0xFF5D89A2, 0xFF6AA5C3, 0xFF6FA2CF, 0xFF6EA1CE, 0xFF6EA1CE, 0xFF6EA1CE, 0xFF6DA0CD, 0xFF6EA1CE, 0xFF6EA1CE, 0xFF6FA2CF, 0xFF6EA5C3,
    0xFF6EA2C9, 0xFF76A5D3, 0xFF638EB1, 0xFF3A5D70, 0xFF324E51, 0xFF3F5351, 0xFF3B4949, 0xFF5D666F, 0xFF485D60, 0xFF3C5D56, 0xFF3E6256, 0xFF3E6052, 0xFF45695B, 0xFF528073, 0xFF4B8674, 0xFF51826F, 0xFF528370, 0xFF538471, 0xFF548572, 0xFF558673,
    0xFF558673, 0xFF558673, 0xFF558673, 0xFF568275, 0xFF5A8677, 0xFF568170, 0xFF567F6D, 0xFF476D5E, 0xFF40645A, 0xFF355854, 0xFF375756, 0xFF576661, 0xFF42534D, 0xFF364B46, 0xFF314B4C, 0xFF496B75, 0xFF4E7A93, 0xFF6CA0C7, 0xFF659FCD, 0xFF6DA0CB,
    0xFF6DA0CB, 0xFF6EA1CC, 0xFF6EA1CC, 0xFF6EA1CC, 0xFF6EA1CC, 0xFF6DA0CB, 0xFF6DA0CB, 0xFF6EA3D7, 0xFF6DA0CB, 0xFF628EA9, 0xFF416571, 0xFF2B4B4A, 0xFF314C45, 0xFF29433A, 0xFF4A645B, 0xFF415B5C, 0xFF506F6A, 0xFF4F7568, 0xFF477460, 0xFF517E69,
    0xFF5D8674, 0xFF608274, 0xFF5F7D73, 0xFF5F8876, 0xFF5E8775, 0xFF5D8674, 0xFF5C8573, 0xFF5B8472, 0xFF598270, 0xFF58816F, 0xFF58816F, 0xFF59806E, 0xFF608476, 0xFF476B5F, 0xFF4A7669, 0xFF44766A, 0xFF27524B, 0xFF3C5456, 0xFF5E656D, 0xFF32524D,
    0xFF2E4E49, 0xFF2D4F50, 0xFF4B6C7F, 0xFF4F759A, 0xFF6E9AC7, 0xFF6EA4C8, 0xFF67A5BE, 0xFF6B9EC9, 0xFF6C9FCA, 0xFF6DA0CB, 0xFF6DA0CB, 0xFF6B9EC9, 0xFF6B9EC9, 0xFF6C9FCA, 0xFF6DA0CB, 0xFF6BA2C8, 0xFF5A8CA7, 0xFF466C77, 0xFF36504D, 0xFF364A41,
    0xFF42514C, 0xFF59676A, 0xFF44525D, 0xFF406055, 0xFF46665B, 0xFF496A5F, 0xFF5A7E70, 0xFF628879, 0xFF56816E, 0xFF57826F, 0xFF5C8975, 0xFF57806E, 0xFF5A8371, 0xFF5C8573, 0xFF5B8472, 0xFF5A8371, 0xFF598270, 0xFF58816F, 0xFF598270, 0xFF4F6F62,
    0xFF62887B, 0xFF437365, 0xFF2B5F52, 0xFF35645A, 0xFF395958, 0xFF58656D, 0xFF545662, 0xFF545F61, 0xFF485D5E, 0xFF4D7076, 0xFF46768C, 0xFF669BC3, 0xFF689ECC, 0xFF6CA0C7, 0xFF6EA0BB, 0xFF6DA0CB, 0xFF6EA1CC, 0xFF6EA1CC, 0xFF6DA0CB, 0xFF6C9FCA,
    0xFF6C9FCA, 0xFF6EA1CC, 0xFF6FA2CD, 0xFF6990B9, 0xFF5C7C91, 0xFF506462, 0xFF485247, 0xFF4E554E, 0xFF677274, 0xFF3D5559, 0xFF446366, 0xFF487360, 0xFF567D6B, 0xFF628776, 0xFF638C7C, 0xFF527D6C, 0x0066867B, 0x00F9FFFF, 0x00FFF9FD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFEFF, 0x31DCECE9, 0xFF4B7166, 0xFF568676, 0xFF648E80, 0xFF668A7C, 0xFF638779, 0xFF608677, 0xFF516D70, 0xFF515E67, 0xFF545E67, 0xFF34514D, 0xFF31554B,
    0xFF365255, 0xFF608399, 0xFF75A7CC, 0xFF73A6D3, 0xFF74A7D4, 0xFF74A7D4, 0xFF74A7D4, 0xFF73A6D3, 0xFF72A5D2, 0xFF73A6D3, 0xFF73A6D3, 0xFF70A4CB, 0xFF72A7CF, 0xFF76ABD5, 0xFF73A7CF, 0xFF5784A5, 0xFF507588, 0xFF35525A, 0xFF3E5656, 0xFF364B50,
    0xFF66737B, 0xFF475C5F, 0xFF2F5D53, 0xFF3B6D61, 0xFF577D72, 0xFF608478, 0xFF558472, 0xFF578173, 0xFF5D8779, 0xFF5C8678, 0xFF598576, 0xFF5B8778, 0xFF588777, 0xFF568575, 0xFF598878, 0xFF5F8878, 0xFF5F8878, 0xFF598473, 0xFF598375, 0xFF537F70,
    0xFF507C6F, 0xFF507C6F, 0xFF427063, 0xFF4E5861, 0xFF5E7273, 0xFF375650, 0xFF284741, 0xFF2E4A4D, 0xFF577688, 0xFF6491AE, 0xFF71ABD0, 0xFF70A3D0, 0xFF70A3D0, 0xFF6FA2CF, 0xFF6FA2CF, 0xFF6FA2CF, 0xFF6EA1CE, 0xFF6EA1CE, 0xFF6EA1CE, 0xFF6AA2C3,
    0xFF6FA4CE, 0xFF76A6D4, 0xFF6892B8, 0xFF466B7D, 0xFF345155, 0xFF354B49, 0xFF334547, 0xFF636D76, 0xFF3A5254, 0xFF355D54, 0xFF497566, 0xFF547D6D, 0xFF578070, 0xFF4F7F71, 0xFF47806F, 0xFF51826F, 0xFF528370, 0xFF538471, 0xFF548572, 0xFF558673,
    0xFF558673, 0xFF558673, 0xFF558673, 0xFF548275, 0xFF568575, 0xFF558170, 0xFF5A8572, 0xFF557E6E, 0xFF577D72, 0xFF466965, 0xFF365857, 0xFF586867, 0xFF465655, 0xFF3C504F, 0xFF375054, 0xFF4E707C, 0xFF55819A, 0xFF70A4CB, 0xFF69A1D0, 0xFF6EA1CC,
    0xFF6DA0CB, 0xFF6DA0CB, 0xFF6DA0CB, 0xFF6DA0CB, 0xFF6DA0CB, 0xFF6DA0CB, 0xFF6EA1CC, 0xFF6CA1D5, 0xFF6EA1CC, 0xFF6E9AB7, 0xFF4E7280, 0xFF2F4C50, 0xFF344E4B, 0xFF334C46, 0xFF546D67, 0xFF425E5F, 0xFF476762, 0xFF4E7769, 0xFF54816D, 0xFF54816C,
    0xFF517C69, 0xFF577D6E, 0xFF638479, 0xFF5E8775, 0xFF5E8775, 0xFF5D8674, 0xFF5C8573, 0xFF5B8472, 0xFF5A8371, 0xFF598270, 0xFF58816F, 0xFF598471, 0xFF587E6F, 0xFF4D7366, 0xFF4A7669, 0xFF3D7164, 0xFF29564F, 0xFF395354, 0xFF5E676E, 0xFF355554,
    0xFF2D4D4A, 0xFF304F52, 0xFF517186, 0xFF597FA6, 0xFF74A0CF, 0xFF6EA3CB, 0xFF629FBB, 0xFF6B9EC9, 0xFF6C9FCA, 0xFF6EA1CC, 0xFF6DA0CB, 0xFF6C9FCA, 0xFF6B9EC9, 0xFF6B9EC9, 0xFF6C9FCA, 0xFF71A6D2, 0xFF6593B4, 0xFF4E7282, 0xFF3C5657, 0xFF40534D,
    0xFF4A5954, 0xFF5B6A6D, 0xFF44525B, 0xFF4C7064, 0xFF567A6E, 0xFF5A8073, 0xFF5C8273, 0xFF5B8474, 0xFF5D8875, 0xFF608B78, 0xFF5D8875, 0xFF5F8876, 0xFF5C8573, 0xFF5A8371, 0xFF5A8371, 0xFF5B8472, 0xFF5A8371, 0xFF5A8371, 0xFF5A8371, 0xFF57796B,
    0xFF537C6E, 0xFF407062, 0xFF2B5F52, 0xFF27564C, 0xFF345655, 0xFF5E6F76, 0xFF545B65, 0xFF586367, 0xFF4C6164, 0xFF53757E, 0xFF507E96, 0xFF6C9FCA, 0xFF6B9FCF, 0xFF6CA0C8, 0xFF6EA1C0, 0xFF6EA1CC, 0xFF6EA1CC, 0xFF6FA2CD, 0xFF6EA1CC, 0xFF6C9FCA,
    0xFF6C9FCA, 0xFF6DA0CB, 0xFF6EA1CC, 0xFF7298C5, 0xFF63859E, 0xFF586D70, 0xFF4E5B52, 0xFF505954, 0xFF677578, 0xFF435B5F, 0xFF4C6B6D, 0xFF5F8876, 0xFF628776, 0xFF628776, 0xFF618A7A, 0xFF517C6B, 0x0065857A, 0x00F9FFFF, 0x00FFFBFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFEFF, 0x35D9E9E6, 0xFF4C7267, 0xFF5B8A7A, 0xFF638D7F, 0xFF628678, 0xFF638577, 0xFF5C8273, 0xFF506E6C, 0xFF4E5F66, 0xFF52636B, 0xFF2E504F, 0xFF285048,
    0xFF35535B, 0xFF6487A3, 0xFF7BACD5, 0xFF74A7D4, 0xFF73A6D3, 0xFF73A6D3, 0xFF73A6D3, 0xFF73A6D3, 0xFF73A6D3, 0xFF72A5D2, 0xFF72A5D2, 0xFF70A5D1, 0xFF70A5D1, 0xFF76A9D6, 0xFF7AA9D3, 0xFF608BAD, 0xFF54778D, 0xFF385460, 0xFF3E575B, 0xFF314A4E,
    0xFF5F6E75, 0xFF41595B, 0xFF346258, 0xFF3B6F62, 0xFF436D61, 0xFF4B7768, 0xFF4B856F, 0xFF557F71, 0xFF5A8476, 0xFF5B8577, 0xFF5A8677, 0xFF5C8879, 0xFF578676, 0xFF568575, 0xFF5B8A7A, 0xFF5C8877, 0xFF5A8675, 0xFF598574, 0xFF588777, 0xFF518070,
    0xFF4E7C6F, 0xFF507E71, 0xFF447265, 0xFF4B5A61, 0xFF566E6E, 0xFF2C4D46, 0xFF1E413B, 0xFF2B484E, 0xFF597990, 0xFF6997BB, 0xFF71ACD6, 0xFF71A4D1, 0xFF71A4D1, 0xFF71A4D1, 0xFF70A3D0, 0xFF6FA2CF, 0xFF6FA2CF, 0xFF6EA1CE, 0xFF6DA0CD, 0xFF67A3C7,
    0xFF6DA3CF, 0xFF72A2D2, 0xFF6A96BB, 0xFF54798C, 0xFF37585D, 0xFF2A4647, 0xFF2B4448, 0xFF59666E, 0xFF3B5758, 0xFF3E6C61, 0xFF437866, 0xFF467764, 0xFF537F6E, 0xFF4F7F71, 0xFF457E6D, 0xFF528370, 0xFF528370, 0xFF538471, 0xFF548572, 0xFF558673,
    0xFF558673, 0xFF558673, 0xFF548572, 0xFF568678, 0xFF558575, 0xFF538270, 0xFF54816D, 0xFF4F7A69, 0xFF537B70, 0xFF456C67, 0xFF325654, 0xFF58676A, 0xFF47595B, 0xFF3F5354, 0xFF3A5358, 0xFF527281, 0xFF6089A5, 0xFF76A7D0, 0xFF6CA1D3, 0xFF6EA1CC,
    0xFF6DA0CB, 0xFF6C9FCA, 0xFF6C9FCA, 0xFF6C9FCA, 0xFF6C9FCA, 0xFF6DA0CB, 0xFF6EA1CC, 0xFF6DA2D8, 0xFF70A0CE, 0xFF75A0C0, 0xFF55788B, 0xFF2A474D, 0xFF2F494A, 0xFF324A4A, 0xFF4F6465, 0xFF466464, 0xFF4A6A65, 0xFF4F7568, 0xFF527D6A, 0xFF53806B,
    0xFF5A8773, 0xFF5C8776, 0xFF578072, 0xFF5D8674, 0xFF5D8674, 0xFF5C8573, 0xFF5C8573, 0xFF5B8472, 0xFF5A8371, 0xFF5A8371, 0xFF5A8371, 0xFF568571, 0xFF527B6B, 0xFF557E70, 0xFF507C6F, 0xFF3E7265, 0xFF2F5E56, 0xFF355353, 0xFF59686D, 0xFF385559,
    0xFF314F51, 0xFF355459, 0xFF58788D, 0xFF6487AF, 0xFF76A2D3, 0xFF6DA2CC, 0xFF65A0C2, 0xFF6B9EC9, 0xFF6DA0CB, 0xFF6EA1CC, 0xFF6EA1CC, 0xFF6C9FCA, 0xFF6B9EC9, 0xFF6A9DC8, 0xFF6B9EC9, 0xFF72A4D9, 0xFF6E99C3, 0xFF54778D, 0xFF425A5E, 0xFF4C5C59,
    0xFF52615E, 0xFF5E6D70, 0xFF43545C, 0xFF467062, 0xFF507A6C, 0xFF568072, 0xFF55806F, 0xFF578271, 0xFF57806E, 0xFF557E6C, 0xFF5D8674, 0xFF618A78, 0xFF5A8371, 0xFF58816F, 0xFF5C8573, 0xFF5C8573, 0xFF5A8371, 0xFF58816F, 0xFF57806E, 0xFF5F8375,
    0xFF547E70, 0xFF487B6C, 0xFF326659, 0xFF245349, 0xFF325654, 0xFF5C7176, 0xFF58626B, 0xFF5A6770, 0xFF4D6168, 0xFF567681, 0xFF58849D, 0xFF71A2CD, 0xFF6B9FD1, 0xFF6B9ECB, 0xFF6FA1C4, 0xFF6EA1CC, 0xFF6FA2CD, 0xFF6FA2CD, 0xFF6EA1CC, 0xFF6C9FCA,
    0xFF6C9FCA, 0xFF6DA0CB, 0xFF6EA1CC, 0xFF729ACD, 0xFF6083A1, 0xFF536C73, 0xFF485855, 0xFF475653, 0xFF5F7173, 0xFF405A5B, 0xFF4D6D6A, 0xFF638A78, 0xFF618373, 0xFF608272, 0xFF628879, 0xFF537E6D, 0x0066867B, 0x00F8FFFF, 0x00FFFBFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFF, 0x31DBEAE7, 0xFF4D7368, 0xFF578676, 0xFF5E8779, 0xFF658779, 0xFF698B7D, 0xFF65897B, 0xFF51726B, 0xFF4E6165, 0xFF4E6269, 0xFF224948, 0xFF1E4846,
    0xFF32525D, 0xFF6487A5, 0xFF7DACD8, 0xFF75A8D5, 0xFF73A6D3, 0xFF72A5D2, 0xFF72A5D2, 0xFF73A6D3, 0xFF73A6D3, 0xFF72A5D2, 0xFF70A3D0, 0xFF6FA5D4, 0xFF6EA2D1, 0xFF75A5D3, 0xFF7BA6D1, 0xFF658BAF, 0xFF53738C, 0xFF385462, 0xFF3B565D, 0xFF264446,
    0xFF576A70, 0xFF445C5E, 0xFF2E5C52, 0xFF3A6E61, 0xFF547E72, 0xFF518070, 0xFF498770, 0xFF547E70, 0xFF578173, 0xFF568072, 0xFF578374, 0xFF5B8778, 0xFF578676, 0xFF568575, 0xFF5B8A7A, 0xFF568774, 0xFF578875, 0xFF538471, 0xFF568676, 0xFF568575,
    0xFF517F72, 0xFF507E71, 0xFF477568, 0xFF45585C, 0xFF4D6A68, 0xFF21463E, 0xFF1B3F3B, 0xFF2A4850, 0xFF597992, 0xFF6996BD, 0xFF6EA6D5, 0xFF6FA2CF, 0xFF6FA2CF, 0xFF70A3D0, 0xFF70A3D0, 0xFF6FA2CF, 0xFF6FA2CF, 0xFF6EA1CE, 0xFF6DA0CD, 0xFF67A5CC,
    0xFF68A0CF, 0xFF6F9FD0, 0xFF6D97BD, 0xFF577C8E, 0xFF375A5E, 0xFF29484A, 0xFF28474C, 0xFF5A6970, 0xFF335151, 0xFF2D5F53, 0xFF427B68, 0xFF4B7E6B, 0xFF4E7D6B, 0xFF508072, 0xFF4E8474, 0xFF538270, 0xFF548371, 0xFF558472, 0xFF558472, 0xFF568573,
    0xFF568573, 0xFF558472, 0xFF558472, 0xFF578779, 0xFF518171, 0xFF51806E, 0xFF53806C, 0xFF4E7968, 0xFF4E786C, 0xFF446B66, 0xFF315855, 0xFF55666D, 0xFF44565A, 0xFF3B4E54, 0xFF375057, 0xFF527183, 0xFF6990AF, 0xFF7AA7D1, 0xFF6C9ED1, 0xFF6DA0CB,
    0xFF6DA0CB, 0xFF6DA0CB, 0xFF6DA0CB, 0xFF6DA0CB, 0xFF6DA0CB, 0xFF6DA0CB, 0xFF6DA0CB, 0xFF6EA1D8, 0xFF6E9ECC, 0xFF79A2C2, 0xFF597A8D, 0xFF27444C, 0xFF2D4549, 0xFF33484B, 0xFF4A5F62, 0xFF385656, 0xFF4B6B66, 0xFF587C70, 0xFF547D6B, 0xFF4F7A66,
    0xFF53806C, 0xFF588473, 0xFF588475, 0xFF5C8573, 0xFF5C8573, 0xFF5C8573, 0xFF5B8472, 0xFF5B8472, 0xFF5B8472, 0xFF5B8472, 0xFF5B8472, 0xFF538771, 0xFF568170, 0xFF587E71, 0xFF4F796D, 0xFF3E7064, 0xFF2D5C54, 0xFF335352, 0xFF57696D, 0xFF38555D,
    0xFF345155, 0xFF3D5C61, 0xFF5E7D92, 0xFF678AB2, 0xFF739DCF, 0xFF6DA0CF, 0xFF6AA4CA, 0xFF6B9EC9, 0xFF6DA0CB, 0xFF6EA1CC, 0xFF6EA1CC, 0xFF6C9FCA, 0xFF6B9EC9, 0xFF6A9DC8, 0xFF6A9DC8, 0xFF6F9ED6, 0xFF739CC8, 0xFF597992, 0xFF465D63, 0xFF50605D,
    0xFF52615E, 0xFF5D6C6F, 0xFF42535A, 0xFF477666, 0xFF558474, 0xFF5B8778, 0xFF578271, 0xFF5B8675, 0xFF5A8371, 0xFF547D6B, 0xFF638A78, 0xFF5B8472, 0xFF567F6D, 0xFF598270, 0xFF5F8876, 0xFF5C8573, 0xFF58816F, 0xFF567F6D, 0xFF547D6B, 0xFF4E7465,
    0xFF4C7668, 0xFF467668, 0xFF2F6155, 0xFF28564C, 0xFF335755, 0xFF546D71, 0xFF5D6E75, 0xFF576371, 0xFF4A5E67, 0xFF56747F, 0xFF5E869F, 0xFF729FC9, 0xFF6B9DD2, 0xFF6A9CCD, 0xFF6EA2CA, 0xFF6FA2CD, 0xFF6FA2CD, 0xFF6FA2CD, 0xFF6EA1CC, 0xFF6C9FCA,
    0xFF6B9EC9, 0xFF6C9FCA, 0xFF6EA1CC, 0xFF7A9FD3, 0xFF5F82A2, 0xFF4B6772, 0xFF435756, 0xFF425454, 0xFF5D7074, 0xFF405D5B, 0xFF50716A, 0xFF5F8171, 0xFF608071, 0xFF628273, 0xFF63897A, 0xFF537E6D, 0x0065867B, 0x00F8FFFF, 0x00FFFCFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFF, 0x2EDEEDEA, 0xFF4C7066, 0xFF558172, 0xFF60897B, 0xFF6B8D7F, 0xFF6D8D80, 0xFF618577, 0xFF4B6C65, 0xFF495E61, 0xFF485F67, 0xFF1B4446, 0xFF1D4B49,
    0xFF35565F, 0xFF64839F, 0xFF7DA9D0, 0xFF76A9D6, 0xFF74A7D4, 0xFF73A6D3, 0xFF73A6D3, 0xFF73A6D3, 0xFF73A6D3, 0xFF72A5D2, 0xFF70A3D0, 0xFF6BA3D4, 0xFF6DA1D1, 0xFF76A5D1, 0xFF7EA5CE, 0xFF698CAC, 0xFF506E86, 0xFF365361, 0xFF36535B, 0xFF2E4D4F,
    0xFF51646A, 0xFF4C6164, 0xFF355D55, 0xFF366157, 0xFF496D63, 0xFF476D60, 0xFF538A75, 0xFF588274, 0xFF598375, 0xFF568072, 0xFF568273, 0xFF5C8879, 0xFF598878, 0xFF568575, 0xFF578676, 0xFF568976, 0xFF598C79, 0xFF51826F, 0xFF548373, 0xFF588777,
    0xFF527E71, 0xFF4C766A, 0xFF477165, 0xFF45585E, 0xFF486664, 0xFF1D423B, 0xFF1C3F39, 0xFF2B4850, 0xFF56748C, 0xFF6D97BD, 0xFF73A9D7, 0xFF6DA0CD, 0xFF6EA1CE, 0xFF6EA1CE, 0xFF6EA1CE, 0xFF6EA1CE, 0xFF6EA1CE, 0xFF6EA1CE, 0xFF6EA1CE, 0xFF65A3CC,
    0xFF6AA0CF, 0xFF78A4D3, 0xFF7399BD, 0xFF507180, 0xFF2F5153, 0xFF26484A, 0xFF25484E, 0xFF505F66, 0xFF405E5E, 0xFF366459, 0xFF457565, 0xFF4C7766, 0xFF507667, 0xFF578376, 0xFF4B7E6F, 0xFF548371, 0xFF558472, 0xFF558472, 0xFF568573, 0xFF568573,
    0xFF568573, 0xFF558472, 0xFF558472, 0xFF568477, 0xFF4E7D6D, 0xFF54806F, 0xFF598471, 0xFF568170, 0xFF4C7469, 0xFF436763, 0xFF365A58, 0xFF56676E, 0xFF41545A, 0xFF374A50, 0xFF354C54, 0xFF526F7F, 0xFF6E93AE, 0xFF7BA6D0, 0xFF6F9FCF, 0xFF6C9FCA,
    0xFF6DA0CB, 0xFF6DA0CB, 0xFF6EA1CC, 0xFF6EA1CC, 0xFF6DA0CB, 0xFF6DA0CB, 0xFF6C9FCA, 0xFF6DA1D3, 0xFF71A0CC, 0xFF7BA4C2, 0xFF597A8B, 0xFF2B464F, 0xFF334B4F, 0xFF3B5055, 0xFF556A6F, 0xFF435F60, 0xFF496662, 0xFF506E64, 0xFF597B6B, 0xFF5E8371,
    0xFF57806E, 0xFF527E6D, 0xFF578676, 0xFF5B8472, 0xFF5B8472, 0xFF5B8472, 0xFF5B8472, 0xFF5B8472, 0xFF5B8472, 0xFF5B8472, 0xFF5B8472, 0xFF4F836D, 0xFF5E8978, 0xFF577B6F, 0xFF51776C, 0xFF467167, 0xFF2F5A53, 0xFF375555, 0xFF54676B, 0xFF38535E,
    0xFF355057, 0xFF3F5C60, 0xFF5E7D8F, 0xFF6C8EB3, 0xFF749ECE, 0xFF6C9FCE, 0xFF6AA1CA, 0xFF6B9EC9, 0xFF6DA0CB, 0xFF6EA1CC, 0xFF6EA1CC, 0xFF6C9FCA, 0xFF6B9EC9, 0xFF6B9EC9, 0xFF6B9EC9, 0xFF739ED5, 0xFF789DC9, 0xFF5D7991, 0xFF4A5E65, 0xFF4F5F5C,
    0xFF4B5B58, 0xFF596B6D, 0xFF40535A, 0xFF487264, 0xFF517B6D, 0xFF5C8577, 0xFF5B8474, 0xFF588171, 0xFF5D8674, 0xFF5F8876, 0xFF5B8472, 0xFF5A8371, 0xFF567F6D, 0xFF5C8573, 0xFF608977, 0xFF5A8371, 0xFF57806E, 0xFF58816F, 0xFF58816F, 0xFF5C8072,
    0xFF527B6D, 0xFF4A7669, 0xFF336156, 0xFF2E574F, 0xFF375958, 0xFF546D71, 0xFF53686D, 0xFF4E5B6B, 0xFF445861, 0xFF55717C, 0xFF6589A1, 0xFF76A0CA, 0xFF70A0D1, 0xFF6B9DCE, 0xFF6BA0CA, 0xFF6EA1CC, 0xFF6FA2CD, 0xFF6FA2CD, 0xFF6EA1CC, 0xFF6C9FCA,
    0xFF6C9FCA, 0xFF6DA0CB, 0xFF6EA1CC, 0xFF81A3D1, 0xFF5C7E9A, 0xFF446169, 0xFF3D5253, 0xFF3E5253, 0xFF5A6F74, 0xFF405A59, 0xFF4E6B66, 0xFF628273, 0xFF698577, 0xFF6A897A, 0xFF65897B, 0xFF4F7A69, 0x00628378, 0x00F7FFFF, 0x00FFFDFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFF, 0x2ADFEBE9, 0xFF4B6F65, 0xFF588475, 0xFF699284, 0xFF68887B, 0xFF527265, 0xFF3A5E50, 0xFF375650, 0xFF475A60, 0xFF516772, 0xFF224B4D, 0xFF1E4C49,
    0xFF2F4E51, 0xFF5A7588, 0xFF82A7C4, 0xFF76A9D6, 0xFF75A8D5, 0xFF74A7D4, 0xFF74A7D4, 0xFF74A7D4, 0xFF73A6D3, 0xFF72A5D2, 0xFF71A4D1, 0xFF6AA4D2, 0xFF71A6D2, 0xFF7BA8D1, 0xFF7DA3C7, 0xFF6887A3, 0xFF4B687A, 0xFF34525D, 0xFF314F57, 0xFF335757,
    0xFF506369, 0xFF47595D, 0xFF2D4A46, 0xFF26433E, 0xFF3E514D, 0xFF3A5149, 0xFF365F4F, 0xFF557F71, 0xFF5C8678, 0xFF5C8678, 0xFF598576, 0xFF5C8879, 0xFF5A8979, 0xFF568575, 0xFF558474, 0xFF568774, 0xFF5A8B78, 0xFF568573, 0xFF598576, 0xFF557F71,
    0xFF426A5F, 0xFF365C51, 0xFF2D5147, 0xFF495C63, 0xFF4A6667, 0xFF1D403A, 0xFF20413A, 0xFF284145, 0xFF4D6879, 0xFF6C93B0, 0xFF7BADD2, 0xFF6FA2CF, 0xFF6FA2CF, 0xFF6EA1CE, 0xFF6DA0CD, 0xFF6DA0CD, 0xFF6EA1CE, 0xFF6EA1CE, 0xFF6FA2CF, 0xFF659EC9,
    0xFF70A3D2, 0xFF83A9D6, 0xFF7493B2, 0xFF45636D, 0xFF274744, 0xFF244645, 0xFF24494F, 0xFF4F6067, 0xFF415B5C, 0xFF2E514A, 0xFF315247, 0xFF395348, 0xFF405A4F, 0xFF52766C, 0xFF5A887B, 0xFF588473, 0xFF588473, 0xFF598574, 0xFF598574, 0xFF598574,
    0xFF598574, 0xFF588473, 0xFF588473, 0xFF598377, 0xFF578173, 0xFF5A8373, 0xFF517866, 0xFF416557, 0xFF294D43, 0xFF2A4A47, 0xFF335151, 0xFF576A70, 0xFF425559, 0xFF384B4F, 0xFF354C52, 0xFF4C6874, 0xFF698DA5, 0xFF77A2C5, 0xFF76A3CD, 0xFF6DA0CB,
    0xFF6DA0CB, 0xFF6EA1CC, 0xFF6EA1CC, 0xFF6EA1CC, 0xFF6EA1CC, 0xFF6DA0CB, 0xFF6DA0CB, 0xFF6DA2CE, 0xFF75A5CB, 0xFF779FB9, 0xFF50707F, 0xFF294549, 0xFF34494C, 0xFF3A4D51, 0xFF5B6E74, 0xFF3E5356, 0xFF3D5351, 0xFF3D544C, 0xFF455D50, 0xFF517060,
    0xFF5E8372, 0xFF5D8877, 0xFF548373, 0xFF5B8472, 0xFF5B8472, 0xFF5B8472, 0xFF5B8472, 0xFF5B8472, 0xFF5B8472, 0xFF5B8472, 0xFF5B8472, 0xFF52836E, 0xFF587E6F, 0xFF456359, 0xFF37564E, 0xFF2A4F47, 0xFF204440, 0xFF385455, 0xFF586A6E, 0xFF3A5560,
    0xFF345053, 0xFF395757, 0xFF577580, 0xFF6D90AE, 0xFF78A1CD, 0xFF6F9FCD, 0xFF649BC4, 0xFF6B9EC9, 0xFF6C9FCA, 0xFF6DA0CB, 0xFF6C9FCA, 0xFF6B9EC9, 0xFF6B9EC9, 0xFF6C9FCA, 0xFF6DA0CB, 0xFF79A2D0, 0xFF779BBD, 0xFF577283, 0xFF495D5E, 0xFF4B5C56,
    0xFF475754, 0xFF596B6F, 0xFF3E525B, 0xFF3C5A50, 0xFF35554A, 0xFF44655A, 0xFF5F8173, 0xFF5A8071, 0xFF577E6C, 0xFF5F8876, 0xFF55806D, 0xFF5F8876, 0xFF5B8472, 0xFF5F8876, 0xFF5F8876, 0xFF58816F, 0xFF598270, 0xFF5D8674, 0xFF598270, 0xFF547467,
    0xFF3C5D52, 0xFF31554B, 0xFF254A42, 0xFF21443E, 0xFF375555, 0xFF5B7478, 0xFF475C61, 0xFF455564, 0xFF40545B, 0xFF546F76, 0xFF6B8C9D, 0xFF79A1C5, 0xFF77A6D4, 0xFF6CA0CF, 0xFF689FC6, 0xFF6DA0CB, 0xFF6EA1CC, 0xFF6EA1CC, 0xFF6DA0CB, 0xFF6C9FCA,
    0xFF6C9FCA, 0xFF6EA1CC, 0xFF6FA2CD, 0xFF809EC2, 0xFF59758A, 0xFF405C5F, 0xFF3C5250, 0xFF3C4F53, 0xFF596A71, 0xFF405357, 0xFF4F6562, 0xFF5C786A, 0xFF637D70, 0xFF698577, 0xFF698B7D, 0xFF517A6A, 0x00608176, 0x00F4FFFC, 0x00FFFCFE, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFBFF, 0x2ADFEBE9, 0xFF4C6D64, 0xFF5D8779, 0xFF6E9487, 0xFF5A7A6D, 0xFF38584B, 0xFF2A4C3E, 0xFF35504B, 0xFF4D5C63, 0xFF566C77, 0xFF224B4D, 0xFF1C4942,
    0xFF213E3A, 0xFF435A62, 0xFF7493A5, 0xFF76A9D6, 0xFF77AAD7, 0xFF76A9D6, 0xFF75A8D5, 0xFF74A7D4, 0xFF72A5D2, 0xFF72A5D2, 0xFF72A5D2, 0xFF6FAAD6, 0xFF76ABD5, 0xFF7AA6CB, 0xFF7497B5, 0xFF5A798E, 0xFF3F5C6A, 0xFF325058, 0xFF335257, 0xFF2B4F4F,
    0xFF5D7076, 0xFF505B61, 0xFF3D4F4F, 0xFF576766, 0xFF9C9D9F, 0xFF9BA19F, 0xFF5A6F66, 0xFF446E60, 0xFF568072, 0xFF5F897B, 0xFF5A8677, 0xFF5A8677, 0xFF598878, 0xFF578676, 0xFF578676, 0xFF568573, 0xFF578372, 0xFF5D8877, 0xFF5E8779, 0xFF486C60,
    0xFF34554C, 0xFF304F47, 0xFF224139, 0xFF4E5C69, 0xFF4E666A, 0xFF22413C, 0xFF25433B, 0xFF233937, 0xFF3D535E, 0xFF5E8195, 0xFF73A1BB, 0xFF74A7D4, 0xFF73A6D3, 0xFF70A3D0, 0xFF6EA1CE, 0xFF6DA0CD, 0xFF6DA0CD, 0xFF6EA1CE, 0xFF6FA2CF, 0xFF6DA2CC,
    0xFF7BA7D4, 0xFF7C9DC8, 0xFF617B96, 0xFF3E575C, 0xFF2A4742, 0xFF2A4A47, 0xFF2B4E52, 0xFF5A6B72, 0xFF33484B, 0xFF3D5350, 0xFF707F7A, 0xFF959B97, 0xFF7B8680, 0xFF4E6962, 0xFF588276, 0xFF598574, 0xFF598574, 0xFF5A8675, 0xFF5A8675, 0xFF5A8675,
    0xFF598574, 0xFF598574, 0xFF588473, 0xFF5E8479, 0xFF608478, 0xFF577B6D, 0xFF3E6050, 0xFF2E4E41, 0xFF19372F, 0xFF223C3B, 0xFF344E4F, 0xFF56696D, 0xFF425657, 0xFF3A504E, 0xFF344C4E, 0xFF3F5C64, 0xFF5B7E92, 0xFF6F98B6, 0xFF7AA6CB, 0xFF70A3CE,
    0xFF6FA2CD, 0xFF6EA1CC, 0xFF6DA0CB, 0xFF6DA0CB, 0xFF6EA1CC, 0xFF6FA2CD, 0xFF70A3CE, 0xFF72A6CD, 0xFF77A5C6, 0xFF638CA0, 0xFF3A5B64, 0xFF294344, 0xFF374D4B, 0xFF324647, 0xFF536768, 0xFF485A5E, 0xFF6A7A7A, 0xFF889792, 0xFF75867C, 0xFF4E6457,
    0xFF506F60, 0xFF63897A, 0xFF5D897A, 0xFF5C8573, 0xFF5C8573, 0xFF5C8573, 0xFF5B8472, 0xFF5B8472, 0xFF5B8472, 0xFF5B8472, 0xFF5A8371, 0xFF578672, 0xFF46685A, 0xFF395048, 0xFF213832, 0xFF0C2924, 0xFF183634, 0xFF3C5456, 0xFF5F6C72, 0xFF405B64,
    0xFF355152, 0xFF33504C, 0xFF47666B, 0xFF62869E, 0xFF749EC4, 0xFF72A3CC, 0xFF689FC5, 0xFF6B9EC9, 0xFF6C9FCA, 0xFF6C9FCA, 0xFF6B9EC9, 0xFF6A9DC8, 0xFF6B9EC9, 0xFF6EA1CC, 0xFF70A3CE, 0xFF79A1C4, 0xFF6A8EA6, 0xFF45626A, 0xFF3F544F, 0xFF46574F,
    0xFF465653, 0xFF5B6E74, 0xFF3E515F, 0xFF5E6F69, 0xFF637670, 0xFF4C635B, 0xFF567266, 0xFF658779, 0xFF59806E, 0xFF5B8673, 0xFF5B8874, 0xFF5F8876, 0xFF5B8472, 0xFF5E8775, 0xFF5E8775, 0xFF58816F, 0xFF5C8573, 0xFF5B8472, 0xFF4D7664, 0xFF304C40,
    0xFF233E35, 0xFF133129, 0xFF0F2C27, 0xFF16332F, 0xFF334D4E, 0xFF60757A, 0xFF4A5D63, 0xFF42545E, 0xFF3D5257, 0xFF506A6B, 0xFF63838E, 0xFF7398B5, 0xFF78A5CF, 0xFF6EA3CD, 0xFF67A1C6, 0xFF6C9FCA, 0xFF6DA0CB, 0xFF6DA0CB, 0xFF6DA0CB, 0xFF6DA0CB,
    0xFF6DA0CB, 0xFF6FA2CD, 0xFF71A4CF, 0xFF7791A8, 0xFF536E77, 0xFF445D59, 0xFF445954, 0xFF455457, 0xFF5F6D76, 0xFF4A595E, 0xFF5C6C6B, 0xFF5C7669, 0xFF5B7366, 0xFF617B6E, 0xFF6A8C7E, 0xFF567F6F, 0x005D7E73, 0x00EFFBF7, 0x00FFFDFE, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFF, 0x26E1EDEB, 0xFF4B6C63, 0xFF5A8476, 0xFF698F82, 0xFF527265, 0xFF3D5B4F, 0xFF446658, 0xFF495F5D, 0xFF536069, 0xFF4E616F, 0xFF173F3F, 0xFF1D483E,
    0xFF1D3831, 0xFF2E4344, 0xFF57747C, 0xFF76A9D6, 0xFF77AAD7, 0xFF78ABD8, 0xFF76A9D6, 0xFF74A7D4, 0xFF72A5D2, 0xFF72A5D2, 0xFF73A6D3, 0xFF72B0D9, 0xFF79AED6, 0xFF75A2C3, 0xFF6488A2, 0xFF4A6779, 0xFF334F5A, 0xFF315055, 0xFF345658, 0xFF315857,
    0xFF5D6E75, 0xFF575E66, 0xFF6E797B, 0xFF7A7F82, 0xFF90878C, 0xFF9E989A, 0xFF717C76, 0xFF2F594B, 0xFF4C7668, 0xFF5D8779, 0xFF598576, 0xFF568273, 0xFF568575, 0xFF588777, 0xFF5A8979, 0xFF5E8A79, 0xFF547F6E, 0xFF5D8676, 0xFF5E8477, 0xFF3B5C51,
    0xFF325048, 0xFF456059, 0xFF3C5750, 0xFF4E5A6A, 0xFF50646B, 0xFF25423E, 0xFF2A453C, 0xFF1E332E, 0xFF2D4247, 0xFF4D6D7C, 0xFF638EA1, 0xFF79ACD9, 0xFF77AAD7, 0xFF73A6D3, 0xFF6FA2CF, 0xFF6DA0CD, 0xFF6DA0CD, 0xFF6EA1CE, 0xFF6FA2CF, 0xFF76AAD2,
    0xFF7FAAD5, 0xFF6D8AB2, 0xFF4B6179, 0xFF3B5053, 0xFF365047, 0xFF31504A, 0xFF315456, 0xFF59686F, 0xFF4B5D61, 0xFF647272, 0xFF717372, 0xFF969090, 0xFF999B98, 0xFF4F645F, 0xFF3A6257, 0xFF5A8675, 0xFF5A8675, 0xFF5A8675, 0xFF5B8776, 0xFF5A8675,
    0xFF5A8675, 0xFF598574, 0xFF598574, 0xFF62837A, 0xFF5D7E73, 0xFF4C6C5F, 0xFF365546, 0xFF405C50, 0xFF39524C, 0xFF385050, 0xFF415659, 0xFF516667, 0xFF405654, 0xFF3B514E, 0xFF324B48, 0xFF335056, 0xFF4E6F80, 0xFF658DA7, 0xFF7BA6C8, 0xFF73A6D1,
    0xFF71A4CF, 0xFF6DA0CB, 0xFF6B9EC9, 0xFF6B9EC9, 0xFF6DA0CB, 0xFF71A4CF, 0xFF73A6D1, 0xFF75A9CE, 0xFF72A1BD, 0xFF4F788A, 0xFF294A51, 0xFF2E4847, 0xFF435956, 0xFF344847, 0xFF506463, 0xFF445157, 0xFF737E80, 0xFFB6C1BD, 0xFFADB8B0, 0xFF5E7064,
    0xFF435D50, 0xFF5A7E70, 0xFF5C8678, 0xFF5D8674, 0xFF5C8573, 0xFF5C8573, 0xFF5C8573, 0xFF5B8472, 0xFF5B8472, 0xFF5A8371, 0xFF5A8371, 0xFF517E6A, 0xFF3D5D50, 0xFF556862, 0xFF495C58, 0xFF2D4642, 0xFF385553, 0xFF485B5F, 0xFF5A656B, 0xFF465F66,
    0xFF3B5554, 0xFF304E46, 0xFF39585A, 0xFF54778B, 0xFF6B96B8, 0xFF74A5CD, 0xFF75ABD1, 0xFF6B9EC9, 0xFF6B9EC9, 0xFF6B9EC9, 0xFF6A9DC8, 0xFF6A9DC8, 0xFF6B9EC9, 0xFF6FA2CD, 0xFF71A4CF, 0xFF729CB5, 0xFF5B7F8F, 0xFF345053, 0xFF344942, 0xFF435349,
    0xFF465653, 0xFF5F7279, 0xFF3F5261, 0xFF9CA5A2, 0xFFC9D4D0, 0xFF758680, 0xFF3D544A, 0xFF5D7D70, 0xFF628977, 0xFF588571, 0xFF588773, 0xFF5A8371, 0xFF57806E, 0xFF5C8573, 0xFF5D8674, 0xFF5A8371, 0xFF5E8775, 0xFF557E6C, 0xFF3C6553, 0xFF5B7268,
    0xFF5E786F, 0xFF405953, 0xFF2B4440, 0xFF304946, 0xFF394E51, 0xFF596C72, 0xFF4A5D63, 0xFF455761, 0xFF3C5152, 0xFF486261, 0xFF58767E, 0xFF678BA5, 0xFF74A0C7, 0xFF6FA4CC, 0xFF69A4C6, 0xFF6B9EC9, 0xFF6C9FCA, 0xFF6DA0CB, 0xFF6DA0CB, 0xFF6DA0CB,
    0xFF6EA1CC, 0xFF70A3CE, 0xFF71A4CF, 0xFF647B8B, 0xFF455D61, 0xFF3E554D, 0xFF435650, 0xFF425154, 0xFF5D6A73, 0xFF4D5760, 0xFF636E70, 0xFF728A7D, 0xFF62786C, 0xFF60786B, 0xFF6A8C7E, 0xFF578070, 0x005A7B70, 0x00ECFBF6, 0x00FFFEFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFBFF, 0x2ADFEEEB, 0xFF466E63, 0xFF538677, 0xFF608A7C, 0xFF516C63, 0xFF5C7067, 0xFFC4D3CC, 0xFFA09CAA, 0xFF585F69, 0xFF485D62, 0xFF2C4E4F, 0xFF1E4544,
    0xFF264547, 0xFF4A5F64, 0xFF4E5B63, 0xFF47717F, 0xFF6B95AB, 0xFF88B3D3, 0xFF88B5DE, 0xFF82B0E1, 0xFF83B6E5, 0xFF81B5E4, 0xFF79AEDA, 0xFF84A7C7, 0xFF7B9CBB, 0xFF61819A, 0xFF405F74, 0xFF324E5C, 0xFF35505B, 0xFF3D545A, 0xFF3C5458, 0xFF324E4F,
    0xFF597374, 0xFF495D5E, 0xFF7B8989, 0xFF979D9D, 0xFF818181, 0xFF979191, 0xFF7D7573, 0xFF3D6656, 0xFF4F7868, 0xFF5E8777, 0xFF5D8877, 0xFF5A8574, 0xFF5A8675, 0xFF5C8877, 0xFF5A8675, 0xFF5A8B78, 0xFF578674, 0xFF618C7B, 0xFF5D7E73, 0xFF364D45,
    0xFF7B8584, 0xFFC3C3C5, 0xFF999397, 0xFF4C5B62, 0xFF4E6167, 0xFF1D3B3D, 0xFF1F4645, 0xFF184240, 0xFF153F3D, 0xFF204746, 0xFF456969, 0xFF5F8EAA, 0xFF79A7C9, 0xFF82AFD9, 0xFF7CA7DA, 0xFF7EA9E0, 0xFF81ACE1, 0xFF7FABDC, 0xFF7EAAD9, 0xFF87A4C2,
    0xFF6D8BA5, 0xFF476379, 0xFF365361, 0xFF38555D, 0xFF304C4F, 0xFF28423F, 0xFF25403B, 0xFF52636A, 0xFF495C60, 0xFF819190, 0xFF858B89, 0xFF949391, 0xFF969694, 0xFF5B6B68, 0xFF406158, 0xFF5C8877, 0xFF5B8776, 0xFF5B8675, 0xFF5A8574, 0xFF5A8574,
    0xFF5B8474, 0xFF5C8575, 0xFF5D8676, 0xFF588571, 0xFF64887A, 0xFF4B6059, 0xFF727B78, 0xFF8E9293, 0xFF92979A, 0xFF96A1A3, 0xFF445454, 0xFF4B6863, 0xFF2E4B47, 0xFF324F4D, 0xFF365255, 0xFF38535A, 0xFF2F4A55, 0xFF4A6473, 0xFF758FA0, 0xFF75A6C7,
    0xFF7FAFD5, 0xFF79A8D4, 0xFF75A3D4, 0xFF73A1D2, 0xFF75A4D0, 0xFF7FAFD5, 0xFF7AABCC, 0xFF7C9CA7, 0xFF55767F, 0xFF39575F, 0xFF244346, 0xFF2A484A, 0xFF284543, 0xFF253F3C, 0xFF506B66, 0xFF49585D, 0xFF717C7E, 0xFF818785, 0xFF929791, 0xFF717B72,
    0xFF43594D, 0xFF55796B, 0xFF5C8879, 0xFF5C8774, 0xFF5C8774, 0xFF5C8774, 0xFF5C8774, 0xFF5C8774, 0xFF5C8774, 0xFF5C8774, 0xFF5C8774, 0xFF59796C, 0xFF42534D, 0xFF878988, 0xFF908E91, 0xFF909598, 0xFF889395, 0xFF464F54, 0xFF64696F, 0xFF3B5758,
    0xFF3B575A, 0xFF365158, 0xFF304C58, 0xFF3B5669, 0xFF58748C, 0xFF7691AE, 0xFF86A1BF, 0xFF77AED7, 0xFF75A9D8, 0xFF6FA1D2, 0xFF6B9BCC, 0xFF74A0CF, 0xFF7EAAD1, 0xFF7CA5C5, 0xFF749EB7, 0xFF6A797E, 0xFF405256, 0xFF395153, 0xFF334F50, 0xFF354F50,
    0xFF485D60, 0xFF5F6C72, 0xFF464F56, 0xFF6F6B6C, 0xFF777978, 0xFF77837F, 0xFF445B51, 0xFF507063, 0xFF5D8472, 0xFF5F8876, 0xFF5E8775, 0xFF5F8674, 0xFF5D8472, 0xFF5E8573, 0xFF5A816F, 0xFF587F6D, 0xFF618876, 0xFF567D6B, 0xFF355C4A, 0xFF8B8D8A,
    0xFF9C9E9D, 0xFF797A7C, 0xFF868A8D, 0xFF828C8E, 0xFF354449, 0xFF687B81, 0xFF51696D, 0xFF415965, 0xFF485E69, 0xFF465A63, 0xFF475963, 0xFF586F7F, 0xFF6F8DA5, 0xFF7DA1C1, 0xFF81ACCF, 0xFF71A7D6, 0xFF72A6D6, 0xFF72A1D5, 0xFF749FD2, 0xFF7DA6D4,
    0xFF83A9CE, 0xFF789DB8, 0xFF668B9E, 0xFF516063, 0xFF495D5E, 0xFF3A5453, 0xFF3F5D5B, 0xFF405E5C, 0xFF577170, 0xFF3C5051, 0xFF667578, 0xFF929992, 0xFF5F6C63, 0xFF556F62, 0xFF5E8978, 0xFF4F826F, 0x00597F72, 0x00F8FFFE, 0x00FFF5FB, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFF, 0x2ADFEEEB, 0xFF446C61, 0xFF548474, 0xFF648E80, 0xFF597569, 0xFF4C6057, 0xFF859990, 0xFF778288, 0xFF4C5E62, 0xFF435F60, 0xFF1C403E, 0xFF133A37,
    0xFF1C403E, 0xFF2F4D4D, 0xFF304A4B, 0xFF223E3F, 0xFF405D63, 0xFF617E8E, 0xFF7391A9, 0xFF7B9AB7, 0xFF7DA0BE, 0xFF7BA0BD, 0xFF769BB6, 0xFF6590A3, 0xFF4C7788, 0xFF335D6D, 0xFF2D5360, 0xFF2D525B, 0xFF2A4D53, 0xFF234449, 0xFF203F42, 0xFF2F4749,
    0xFF586D70, 0xFF445859, 0xFF647272, 0xFF7A8483, 0xFF707473, 0xFF888A87, 0xFF777873, 0xFF436C5C, 0xFF517A6A, 0xFF5D8676, 0xFF5B8675, 0xFF588372, 0xFF588473, 0xFF598574, 0xFF578372, 0xFF588473, 0xFF5D8978, 0xFF5F8A79, 0xFF567C6F, 0xFF39574D,
    0xFF6D807C, 0xFFA5AEAD, 0xFF8C8D8F, 0xFF546169, 0xFF51646A, 0xFF1B373A, 0xFF1C3E3F, 0xFF1D4443, 0xFF183F3E, 0xFF103434, 0xFF1F4142, 0xFF345E6C, 0xFF4D7688, 0xFF6C94AE, 0xFF769DBE, 0xFF7197BB, 0xFF7399BD, 0xFF759CBB, 0xFF6D94B1, 0xFF577C8E,
    0xFF3E6373, 0xFF2C505E, 0xFF1F414A, 0xFF15363B, 0xFF193938, 0xFF1B3B38, 0xFF1A3934, 0xFF5B6870, 0xFF435559, 0xFF687B79, 0xFF848F8B, 0xFFB2B4B1, 0xFFAFB5B1, 0xFF637A74, 0xFF365E53, 0xFF588473, 0xFF588473, 0xFF578372, 0xFF588372, 0xFF598473,
    0xFF5B8474, 0xFF5C8575, 0xFF5C8575, 0xFF588773, 0xFF5B8172, 0xFF536D64, 0xFFB3C2BD, 0xFFF1FAF9, 0xFFACB6B7, 0xFF6B7B7B, 0xFF435756, 0xFF4C6B65, 0xFF21403B, 0xFF1F3F3C, 0xFF1E3D3F, 0xFF1C3D42, 0xFF21434C, 0xFF325760, 0xFF365A66, 0xFF56829B,
    0xFF6B97B4, 0xFF76A1C4, 0xFF7DA7CD, 0xFF7DA7CD, 0xFF79A4C7, 0xFF729EBB, 0xFF608CA5, 0xFF40676E, 0xFF30575C, 0xFF1F4548, 0xFF113436, 0xFF183A3B, 0xFF1C3C39, 0xFF1F3F3A, 0xFF44635E, 0xFF4F6165, 0xFF697778, 0xFF6F7875, 0xFF838A83, 0xFF6C796F,
    0xFF455D50, 0xFF55796B, 0xFF5C8879, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF496B5D, 0xFF556A63, 0xFFD9DFDD, 0xFFF6FAFB, 0xFFADB9B9, 0xFF718383, 0xFF445255, 0xFF5E656B, 0xFF325455,
    0xFF294B4C, 0xFF28494E, 0xFF30525B, 0xFF345662, 0xFF3A5B6C, 0xFF507386, 0xFF6C8FA3, 0xFF6899BA, 0xFF6F9FC3, 0xFF79A6CD, 0xFF7BA5CD, 0xFF7BA3C7, 0xFF799DBD, 0xFF6B8FA7, 0xFF5A7F91, 0xFF364E50, 0xFF365253, 0xFF30504F, 0xFF294B4A, 0xFF224443,
    0xFF2D4B4B, 0xFF556D6F, 0xFF425559, 0xFF646464, 0xFF6C706F, 0xFF6F7E79, 0xFF455F54, 0xFF527466, 0xFF5E8573, 0xFF608977, 0xFF608977, 0xFF5F8674, 0xFF5C8371, 0xFF5E8573, 0xFF5C8371, 0xFF5A816F, 0xFF618876, 0xFF577E6C, 0xFF3C6351, 0xFF6F7470,
    0xFFB6BAB9, 0xFFD9DFDF, 0xFF929A9C, 0xFF687375, 0xFF4E5D62, 0xFF576C71, 0xFF3E565A, 0xFF2E5059, 0xFF335159, 0xFF344F56, 0xFF3E555D, 0xFF4D6370, 0xFF587283, 0xFF658199, 0xFF7291AE, 0xFF73A2C0, 0xFF77A4C5, 0xFF7BA6C8, 0xFF7DA4C5, 0xFF799CB8,
    0xFF6B8BA0, 0xFF557580, 0xFF446368, 0xFF49575A, 0xFF4A5C5E, 0xFF3D5555, 0xFF395352, 0xFF3B5554, 0xFF576F6F, 0xFF47595B, 0xFF849295, 0xFFC2CDC5, 0xFF79897F, 0xFF5B7568, 0xFF608B7A, 0xFF508370, 0x00547A6D, 0x00F7FFFD, 0x00FFFAFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFF, 0x2EDEEDEA, 0xFF476D60, 0xFF528272, 0xFF648D7F, 0xFF628074, 0xFF455C52, 0xFF52695F, 0xFF496163, 0xFF466061, 0xFF577374, 0xFF315150, 0xFF2E504F,
    0xFF345856, 0xFF274B49, 0xFF1D413F, 0xFF344B45, 0xFF304946, 0xFF324B50, 0xFF3C5762, 0xFF476371, 0xFF4A6777, 0xFF466675, 0xFF436372, 0xFF27585C, 0xFF1F4F53, 0xFF1B4B4F, 0xFF235053, 0xFF2A5357, 0xFF264E50, 0xFF20484A, 0xFF1F4548, 0xFF3D5054,
    0xFF607377, 0xFF4B5D5F, 0xFF526261, 0xFF657572, 0xFF697873, 0xFF7E8D86, 0xFF7B887F, 0xFF4D7666, 0xFF578070, 0xFF5D8676, 0xFF5A8574, 0xFF588372, 0xFF588473, 0xFF598574, 0xFF578372, 0xFF5D8877, 0xFF5C8776, 0xFF588372, 0xFF5C8678, 0xFF466A5E,
    0xFF405E56, 0xFF516862, 0xFF4D605C, 0xFF536068, 0xFF5C6D74, 0xFF34494E, 0xFF2E4A4D, 0xFF2C4B4D, 0xFF234244, 0xFF163537, 0xFF264446, 0xFF1C403C, 0xFF274B4B, 0xFF3A5D61, 0xFF4A6C76, 0xFF537581, 0xFF537581, 0xFF4A6C76, 0xFF3D5F68, 0xFF295256,
    0xFF20494D, 0xFF224A4C, 0xFF1B4142, 0xFF1F4343, 0xFF2A4C4B, 0xFF264945, 0xFF2A4A47, 0xFF656E77, 0xFF455459, 0xFF506361, 0xFF64736E, 0xFF838C87, 0xFF7C8B84, 0xFF527169, 0xFF427264, 0xFF558472, 0xFF578372, 0xFF578372, 0xFF588473, 0xFF598473,
    0xFF5B8675, 0xFF5D8676, 0xFF5D8676, 0xFF568772, 0xFF608B7A, 0xFF4B6B60, 0xFF728981, 0xFFA3B6B2, 0xFF768987, 0xFF435957, 0xFF415B58, 0xFF536D6A, 0xFF304D49, 0xFF2F4D4D, 0xFF264849, 0xFF1A4043, 0xFF163F43, 0xFF224D53, 0xFF214E54, 0xFF355665,
    0xFF436475, 0xFF4D6D82, 0xFF57778E, 0xFF5E7E95, 0xFF59798E, 0xFF48697A, 0xFF2F505F, 0xFF20494D, 0xFF1C4547, 0xFF123A3C, 0xFF123839, 0xFF1D413F, 0xFF1D403C, 0xFF284B47, 0xFF4A6A65, 0xFF475A5E, 0xFF556767, 0xFF596863, 0xFF758279, 0xFF708276,
    0xFF506C5E, 0xFF597F70, 0xFF5C8879, 0xFF5A8572, 0xFF5A8572, 0xFF5A8572, 0xFF5A8572, 0xFF5A8572, 0xFF5A8572, 0xFF5A8572, 0xFF5A8572, 0xFF598272, 0xFF506B62, 0xFFA3B2AD, 0xFFB2C1BE, 0xFF637775, 0xFF38524F, 0xFF405455, 0xFF606E71, 0xFF224446,
    0xFF1E4143, 0xFF204347, 0xFF2A4D51, 0xFF30555B, 0xFF31565C, 0xFF335A61, 0xFF375E65, 0xFF51778C, 0xFF587E95, 0xFF6488A0, 0xFF6789A2, 0xFF5D7D92, 0xFF517180, 0xFF415F6A, 0xFF2A474F, 0xFF264645, 0xFF3D5F5E, 0xFF244B48, 0xFF1A413E, 0xFF153C39,
    0xFF224443, 0xFF557373, 0xFF415D5E, 0xFF5B615F, 0xFF626D69, 0xFF687B75, 0xFF4A685C, 0xFF577B6D, 0xFF5F8674, 0xFF5E8775, 0xFF5F8876, 0xFF5E8775, 0xFF5A8371, 0xFF5C8573, 0xFF5D8674, 0xFF5A8371, 0xFF5E8775, 0xFF58816F, 0xFF466F5D, 0xFF85908A,
    0xFFF3FEFA, 0xFFD2DEDC, 0xFF576766, 0xFF405252, 0xFF3E5155, 0xFF51666B, 0xFF3E5358, 0xFF194248, 0xFF1C4147, 0xFF274649, 0xFF395257, 0xFF435A60, 0xFF405661, 0xFF445A68, 0xFF546B7B, 0xFF587A84, 0xFF577985, 0xFF5C7987, 0xFF607C88, 0xFF5D757F,
    0xFF4C6466, 0xFF394F4C, 0xFF2C413A, 0xFF3E4C4F, 0xFF455457, 0xFF3E5253, 0xFF314647, 0xFF354A4B, 0xFF546869, 0xFF425154, 0xFF829093, 0xFF94A49A, 0xFF607167, 0xFF557163, 0xFF648F7E, 0xFF5A8B78, 0x00587E71, 0x00EFFAF6, 0x00FFF5F9, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FEF9FD, 0x31DBEAE5, 0xFF496F62, 0xFF568273, 0xFF618778, 0xFF68867A, 0xFF536F61, 0xFF4E6D5E, 0xFF3B5758, 0xFF405A5B, 0xFF607578, 0xFF45585C, 0xFF465B5E,
    0xFF496364, 0xFF2B4B4A, 0xFF1F4341, 0xFF304E4E, 0xFF203F41, 0xFF133235, 0xFF12333A, 0xFF193B44, 0xFF1F414B, 0xFF214551, 0xFF234753, 0xFF1F4A43, 0xFF214A44, 0xFF1E4743, 0xFF1E4542, 0xFF2C5050, 0xFF3B5E60, 0xFF3A5C5E, 0xFF2E4F54, 0xFF4B5A5F,
    0xFF5B6D71, 0xFF425456, 0xFF3A4E4C, 0xFF4D645E, 0xFF567067, 0xFF617D71, 0xFF637F71, 0xFF567F6F, 0xFF5B8474, 0xFF5D8676, 0xFF5A8574, 0xFF598473, 0xFF5B8776, 0xFF5B8776, 0xFF598574, 0xFF5E8475, 0xFF598272, 0xFF578271, 0xFF649081, 0xFF588475,
    0xFF3B6358, 0xFF33574D, 0xFF34554C, 0xFF556469, 0xFF617075, 0xFF43565A, 0xFF485D60, 0xFF4B6566, 0xFF3A5455, 0xFF223C3D, 0xFF274344, 0xFF37524B, 0xFF3B5651, 0xFF304A47, 0xFF304A49, 0xFF415B5C, 0xFF3C5657, 0xFF304A4B, 0xFF385253, 0xFF315450,
    0xFF30534F, 0xFF284845, 0xFF193735, 0xFF355152, 0xFF4B6566, 0xFF3D5758, 0xFF4E6668, 0xFF666F78, 0xFF46555A, 0xFF465C59, 0xFF556C64, 0xFF5A6E65, 0xFF546B61, 0xFF50786D, 0xFF5A9080, 0xFF578674, 0xFF578674, 0xFF598574, 0xFF5A8675, 0xFF5A8675,
    0xFF5C8776, 0xFF5D8877, 0xFF5D8877, 0xFF538771, 0xFF679684, 0xFF5F8578, 0xFF46665B, 0xFF4A655E, 0xFF4E6964, 0xFF3E5D58, 0xFF395954, 0xFF5D6B6C, 0xFF435255, 0xFF3A4D51, 0xFF395256, 0xFF3A595C, 0xFF1E4447, 0xFF1A4347, 0xFF255154, 0xFF405C5F,
    0xFF3C585C, 0xFF365256, 0xFF355057, 0xFF355057, 0xFF345054, 0xFF334F53, 0xFF2F4B4E, 0xFF294B4D, 0xFF224446, 0xFF1A393C, 0xFF325052, 0xFF446061, 0xFF385251, 0xFF3B5554, 0xFF4F6767, 0xFF4A6264, 0xFF586E6C, 0xFF596E67, 0xFF6F8579, 0xFF718C7D,
    0xFF5E7E6F, 0xFF5F8576, 0xFF5A8677, 0xFF5A8572, 0xFF5A8572, 0xFF5A8572, 0xFF5A8572, 0xFF5A8572, 0xFF5A8572, 0xFF5A8572, 0xFF5A8572, 0xFF5A8675, 0xFF4D6E63, 0xFF5A7169, 0xFF5F7670, 0xFF45645E, 0xFF31544E, 0xFF3D5756, 0xFF556769, 0xFF2D484F,
    0xFF314C53, 0xFF334F53, 0xFF365256, 0xFF3A585A, 0xFF3E5C5C, 0xFF375756, 0xFF2F4F4C, 0xFF335058, 0xFF3B5860, 0xFF446169, 0xFF48636A, 0xFF3F585D, 0xFF3A5357, 0xFF3D5555, 0xFF324B48, 0xFF264444, 0xFF40605F, 0xFF315150, 0xFF30504F, 0xFF314F4F,
    0xFF3C5859, 0xFF5C7879, 0xFF405A5B, 0xFF6C7B76, 0xFF6E817B, 0xFF748E85, 0xFF5E8072, 0xFF618778, 0xFF5C8573, 0xFF57806E, 0xFF57806E, 0xFF5E8775, 0xFF598270, 0xFF5C8573, 0xFF5F8876, 0xFF5D8674, 0xFF5D8674, 0xFF5A8371, 0xFF527B69, 0xFF6A7B73,
    0xFFBED1CB, 0xFF788F89, 0xFF3F5854, 0xFF516A67, 0xFF3E5658, 0xFF54696E, 0xFF394E53, 0xFF395A61, 0xFF38575C, 0xFF365357, 0xFF385457, 0xFF3D5758, 0xFF385253, 0xFF385253, 0xFF425C5D, 0xFF465E60, 0xFF465B5E, 0xFF46595D, 0xFF47595B, 0xFF4B5B5B,
    0xFF4D5C59, 0xFF4F5C55, 0xFF4E5B52, 0xFF3B494C, 0xFF404F52, 0xFF49585B, 0xFF405254, 0xFF455759, 0xFF617073, 0xFF425154, 0xFF6F7D80, 0xFF849A8E, 0xFF6B8376, 0xFF658475, 0xFF608979, 0xFF4F7E6C, 0x00597D71, 0x00F8FFFF, 0x00FFFBFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FDFBFC, 0x35D9E8E3, 0xFF4A6E62, 0xFF598473, 0xFF5C8273, 0xFF69897A, 0xFF628273, 0xFF5C8170, 0xFF4B6564, 0xFF425657, 0xFF647275, 0xFF5E656B, 0xFF5C656A,
    0xFF586669, 0xFF34494A, 0xFF264341, 0xFF1B3836, 0xFF1C3937, 0xFF1C3937, 0xFF1A3836, 0xFF1B3937, 0xFF1D3B3B, 0xFF1F3D3F, 0xFF1F3C40, 0xFF37524B, 0xFF3E5952, 0xFF36514C, 0xFF253F3C, 0xFF274142, 0xFF3D5559, 0xFF4A6266, 0xFF475E64, 0xFF57696D,
    0xFF55686C, 0xFF3C5152, 0xFF344F4A, 0xFF48675F, 0xFF517267, 0xFF4E7465, 0xFF517866, 0xFF578070, 0xFF5A8373, 0xFF5A8373, 0xFF588372, 0xFF598473, 0xFF5A8675, 0xFF5B8776, 0xFF5A8675, 0xFF597D6F, 0xFF5D8676, 0xFF5A8675, 0xFF568575, 0xFF568676,
    0xFF558376, 0xFF517B6F, 0xFF41695E, 0xFF495C60, 0xFF596B6F, 0xFF55676B, 0xFF607377, 0xFF5D7074, 0xFF395153, 0xFF193334, 0xFF203A3B, 0xFF3A4F52, 0xFF405556, 0xFF3B5051, 0xFF3C5152, 0xFF44595A, 0xFF3B5053, 0xFF34494C, 0xFF42575C, 0xFF495F5C,
    0xFF455B58, 0xFF364A49, 0xFF223635, 0xFF3C4E50, 0xFF556469, 0xFF49565C, 0xFF58656B, 0xFF67717A, 0xFF3A4F52, 0xFF32514B, 0xFF4F6F64, 0xFF567266, 0xFF557568, 0xFF568275, 0xFF4D8876, 0xFF578674, 0xFF588775, 0xFF588775, 0xFF5A8675, 0xFF5A8675,
    0xFF5A8675, 0xFF5A8574, 0xFF5A8574, 0xFF578873, 0xFF507F6D, 0xFF5E887A, 0xFF5A8073, 0xFF4D7167, 0xFF4C6F68, 0xFF3E615B, 0xFF32554F, 0xFF65686F, 0xFF5A5F65, 0xFF596269, 0xFF57666D, 0xFF4C6166, 0xFF233C41, 0xFF1D3A3E, 0xFF2C4D52, 0xFF4A5F60,
    0xFF455B59, 0xFF445A58, 0xFF415754, 0xFF374D4A, 0xFF304644, 0xFF374D4B, 0xFF495E5F, 0xFF475C61, 0xFF374C51, 0xFF24373B, 0xFF3C4F53, 0xFF57696D, 0xFF536267, 0xFF536164, 0xFF566467, 0xFF355152, 0xFF46635F, 0xFF49675D, 0xFF537263, 0xFF5C7D6C,
    0xFF597E6D, 0xFF5B8474, 0xFF598576, 0xFF5A8572, 0xFF5A8572, 0xFF5A8572, 0xFF5A8572, 0xFF5A8572, 0xFF5A8572, 0xFF5A8572, 0xFF5A8572, 0xFF578674, 0xFF5E8276, 0xFF4D6B61, 0xFF46655D, 0xFF3F675E, 0xFF2C554D, 0xFF385654, 0xFF5D7172, 0xFF515F6A,
    0xFF515F6A, 0xFF515F68, 0xFF4C5D64, 0xFF44565A, 0xFF3F5354, 0xFF455958, 0xFF506462, 0xFF395153, 0xFF364E50, 0xFF314949, 0xFF394F4C, 0xFF394F4C, 0xFF39504A, 0xFF3A504D, 0xFF2A403D, 0xFF2B4345, 0xFF3B5053, 0xFF44575B, 0xFF4E6064, 0xFF4A5C60,
    0xFF516367, 0xFF596B6F, 0xFF3E5054, 0xFF4A6159, 0xFF4E6960, 0xFF59796E, 0xFF547A6B, 0xFF5C8776, 0xFF5D8875, 0xFF5F8876, 0xFF648B79, 0xFF5F8876, 0xFF5A8371, 0xFF5C8573, 0xFF608977, 0xFF5E8775, 0xFF5C8573, 0xFF5C8573, 0xFF5A8371, 0xFF587267,
    0xFF557067, 0xFF44655C, 0xFF345750, 0xFF32524D, 0xFF385455, 0xFF526A6E, 0xFF56696F, 0xFF4E5F67, 0xFF4E6168, 0xFF41585E, 0xFF345053, 0xFF365454, 0xFF3A5A57, 0xFF355851, 0xFF32564C, 0xFF3F5057, 0xFF3D4C51, 0xFF374649, 0xFF384647, 0xFF485355,
    0xFF586365, 0xFF5D6769, 0xFF586264, 0xFF3E5052, 0xFF405254, 0xFF59686B, 0xFF5B6A6D, 0xFF576669, 0xFF69787B, 0xFF445658, 0xFF5A6C6E, 0xFF5F7E6F, 0xFF627E70, 0xFF69897A, 0xFF608979, 0xFF4C7B69, 0x00597D71, 0x00F5FFFD, 0x00FFF9FC, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFEFF, 0x39D7E6DF, 0xFF486A5C, 0xFF5D8676, 0xFF5D8271, 0xFF678778, 0xFF628775, 0xFF5B8672, 0xFF516B6A, 0xFF384D4E, 0xFF536265, 0xFF5B6469, 0xFF596267,
    0xFF515F62, 0xFF334748, 0xFF284040, 0xFF3C4D47, 0xFF3E4F45, 0xFF405244, 0xFF455646, 0xFF50614F, 0xFF5A6B5B, 0xFF58685D, 0xFF516157, 0xFF324541, 0xFF3D504E, 0xFF425553, 0xFF384A4A, 0xFF2F4344, 0xFF374B4C, 0xFF4B5E62, 0xFF5A6D71, 0xFF4D6567,
    0xFF465E60, 0xFF395654, 0xFF405F59, 0xFF54786E, 0xFF598274, 0xFF55806F, 0xFF56836F, 0xFF557E6E, 0xFF557E6E, 0xFF567F6F, 0xFF568170, 0xFF578271, 0xFF588473, 0xFF598574, 0xFF598574, 0xFF608476, 0xFF5E8777, 0xFF5C8877, 0xFF528171, 0xFF548474,
    0xFF5A887B, 0xFF5C887B, 0xFF4C7469, 0xFF455F60, 0xFF546C6E, 0xFF607377, 0xFF6C7E82, 0xFF607377, 0xFF415659, 0xFF2E4849, 0xFF3C5859, 0xFF4B616C, 0xFF435A62, 0xFF556D71, 0xFF778F91, 0xFF88A0A0, 0xFF839B9D, 0xFF6B8288, 0xFF4F666E, 0xFF566A69,
    0xFF4B5F5E, 0xFF455757, 0xFF3A494C, 0xFF425053, 0xFF5E696D, 0xFF687377, 0xFF707980, 0xFF596C72, 0xFF3A5858, 0xFF396158, 0xFF578072, 0xFF5C8072, 0xFF618577, 0xFF5D8B7E, 0xFF508978, 0xFF558673, 0xFF558673, 0xFF578674, 0xFF578674, 0xFF598574,
    0xFF588473, 0xFF578372, 0xFF588372, 0xFF608D79, 0xFF568271, 0xFF5C8678, 0xFF5C8678, 0xFF598176, 0xFF5C8179, 0xFF4D726B, 0xFF3C5F59, 0xFF5D616A, 0xFF60676F, 0xFF727B82, 0xFF6A777D, 0xFF4D5E65, 0xFF2F4449, 0xFF3B5458, 0xFF40595D, 0xFF54696C,
    0xFF516765, 0xFF5F7572, 0xFF6C837B, 0xFF6B827A, 0xFF5E7471, 0xFF536967, 0xFF586D70, 0xFF4E6263, 0xFF465A5B, 0xFF334547, 0xFF404F52, 0xFF5C696F, 0xFF677278, 0xFF657076, 0xFF596269, 0xFF3B5B5A, 0xFF50736D, 0xFF577B6F, 0xFF557C6A, 0xFF59836F,
    0xFF5B8472, 0xFF598473, 0xFF588274, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8673, 0xFF5B8776, 0xFF648A7D, 0xFF5F8075, 0xFF5F857A, 0xFF568177, 0xFF38635A, 0xFF3A5856, 0xFF596B6D, 0xFF626C78,
    0xFF64717A, 0xFF616E77, 0xFF55626A, 0xFF4C5B60, 0xFF4E5D62, 0xFF506264, 0xFF516365, 0xFF4D6265, 0xFF596E6F, 0xFF576D6A, 0xFF586F69, 0xFF4F6960, 0xFF47605A, 0xFF516A67, 0xFF516969, 0xFF415659, 0xFF405256, 0xFF505D63, 0xFF646F75, 0xFF656E75,
    0xFF6B767C, 0xFF5D6A70, 0xFF47565B, 0xFF57776C, 0xFF5B7C71, 0xFF5F8578, 0xFF5B8675, 0xFF5C8877, 0xFF5A8572, 0xFF5B8472, 0xFF5D8472, 0xFF5E8976, 0xFF5B8673, 0xFF5C8774, 0xFF5F8A77, 0xFF5E8976, 0xFF5B8673, 0xFF5B8673, 0xFF5C8774, 0xFF69897C,
    0xFF567A6E, 0xFF598377, 0xFF467167, 0xFF2A534B, 0xFF375756, 0xFF4C6468, 0xFF67787F, 0xFF6F787F, 0xFF68757D, 0xFF4D6168, 0xFF345054, 0xFF355759, 0xFF436765, 0xFF486D65, 0xFF466C61, 0xFF5C6D77, 0xFF6D7E85, 0xFF75878B, 0xFF67797B, 0xFF5A696C,
    0xFF57666D, 0xFF5A6873, 0xFF5C6A77, 0xFF3E5656, 0xFF425758, 0xFF5C6E70, 0xFF647376, 0xFF576669, 0xFF607274, 0xFF4A5F60, 0xFF5B7373, 0xFF668B7A, 0xFF648676, 0xFF678979, 0xFF608979, 0xFF517D6C, 0x00587C70, 0x00F2FEFA, 0x00FFFDFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFD, 0x3DD5E4DD, 0xFF46685A, 0xFF608775, 0xFF5E8372, 0xFF648574, 0xFF5F8673, 0xFF54846E, 0xFF4F726C, 0xFF30504B, 0xFF314E4A, 0xFF304A47, 0xFF304946,
    0xFF334D4A, 0xFF274440, 0xFF264540, 0xFF233535, 0xFF1D2E28, 0xFF16281C, 0xFF192B1B, 0xFF283927, 0xFF314230, 0xFF2F3D30, 0xFF26332A, 0xFF172C2D, 0xFF172C2D, 0xFF1C3132, 0xFF233B3B, 0xFF2A4242, 0xFF2C4645, 0xFF2F4948, 0xFF324C49, 0xFF2C4A4A,
    0xFF2E4E4D, 0xFF335652, 0xFF42675F, 0xFF4F776C, 0xFF537D6F, 0xFF527E6D, 0xFF51806C, 0xFF547D6D, 0xFF557E6E, 0xFF578070, 0xFF588372, 0xFF598473, 0xFF588473, 0xFF598574, 0xFF5A8675, 0xFF628879, 0xFF5C8575, 0xFF5F8B7A, 0xFF5B8A7A, 0xFF608F7F,
    0xFF5D877B, 0xFF5F877C, 0xFF5F8379, 0xFF476764, 0xFF3D5A58, 0xFF3B5353, 0xFF465A5B, 0xFF4B5F60, 0xFF425A5A, 0xFF385553, 0xFF3A5A57, 0xFF2E4954, 0xFF1C373E, 0xFF2D494A, 0xFF53706C, 0xFF66837E, 0xFF668381, 0xFF4B676A, 0xFF203B42, 0xFF233F42,
    0xFF2B474A, 0xFF3F585C, 0xFF486062, 0xFF475F61, 0xFF4E6364, 0xFF4D6162, 0xFF455958, 0xFF324E51, 0xFF375E5B, 0xFF437569, 0xFF598979, 0xFF598272, 0xFF5D8374, 0xFF578376, 0xFF568B7B, 0xFF568774, 0xFF578875, 0xFF588976, 0xFF598876, 0xFF598876,
    0xFF5B8776, 0xFF5A8675, 0xFF5A8675, 0xFF537C6A, 0xFF5F8A79, 0xFF5D8779, 0xFF557F71, 0xFF557F73, 0xFF5D857C, 0xFF567B74, 0xFF385B55, 0xFF43585B, 0xFF43585B, 0xFF475F61, 0xFF466061, 0xFF466061, 0xFF405C5D, 0xFF496767, 0xFF3B5959, 0xFF294249,
    0xFF375054, 0xFF5E7875, 0xFF7C9792, 0xFF849F9A, 0xFF6D8784, 0xFF40595D, 0xFF294249, 0xFF36534F, 0xFF3F5C58, 0xFF405A59, 0xFF475F5F, 0xFF546C6C, 0xFF5B7073, 0xFF526569, 0xFF44575B, 0xFF3B5F5D, 0xFF507870, 0xFF5A8476, 0xFF578470, 0xFF5C8974,
    0xFF5D8A76, 0xFF588473, 0xFF5D8779, 0xFF5C8774, 0xFF5C8774, 0xFF5C8774, 0xFF5C8774, 0xFF5C8774, 0xFF5C8774, 0xFF5C8774, 0xFF5C8774, 0xFF5A8574, 0xFF597D71, 0xFF5D7E73, 0xFF5D857A, 0xFF59877C, 0xFF4A756C, 0xFF3C5A58, 0xFF465558, 0xFF50656A,
    0xFF586D72, 0xFF566A71, 0xFF4A6167, 0xFF4A6167, 0xFF50696E, 0xFF486166, 0xFF375055, 0xFF445B63, 0xFF799195, 0xFF92ACA9, 0xFF93AEA9, 0xFF708B86, 0xFF3F5C58, 0xFF395558, 0xFF3E5960, 0xFF506E6E, 0xFF526C6D, 0xFF586B6F, 0xFF67767B, 0xFF657278,
    0xFF606F74, 0xFF475C5F, 0xFF395153, 0xFF577D70, 0xFF5A8375, 0xFF5B8778, 0xFF598876, 0xFF588775, 0xFF598672, 0xFF5D8674, 0xFF5F8674, 0xFF5D8875, 0xFF5D8875, 0xFF5D8875, 0xFF5E8976, 0xFF5E8976, 0xFF5C8774, 0xFF5B8673, 0xFF5B8673, 0xFF5D8374,
    0xFF679183, 0xFF568678, 0xFF45796C, 0xFF326157, 0xFF315553, 0xFF3C5458, 0xFF4D5C63, 0xFF526261, 0xFF526667, 0xFF4A6368, 0xFF436169, 0xFF44626A, 0xFF3E5B5F, 0xFF314D4E, 0xFF2D4643, 0xFF597276, 0xFF799394, 0xFF8DA7A4, 0xFF76918C, 0xFF496360,
    0xFF314A4E, 0xFF3C545E, 0xFF506775, 0xFF4C6A68, 0xFF4C6967, 0xFF586D6E, 0xFF586A6C, 0xFF485A5C, 0xFF485D5E, 0xFF3E5B59, 0xFF587674, 0xFF618C79, 0xFF608574, 0xFF638877, 0xFF628B7B, 0xFF588473, 0x00597D71, 0x00ECFBF6, 0x00FFFBFC, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FBFBF9, 0x41D3E2DB, 0xFF47675A, 0xFF608775, 0xFF5F8171, 0xFF618372, 0xFF5D8773, 0xFF54856F, 0xFF5D8B81, 0xFF457067, 0xFF376259, 0xFF2D564E, 0xFF2B544C,
    0xFF315951, 0xFF2A524A, 0xFF2D524B, 0xFF2D4B56, 0xFF2E4C54, 0xFF314F4F, 0xFF33524A, 0xFF345248, 0xFF314C45, 0xFF2C4643, 0xFF294344, 0xFF274346, 0xFF294548, 0xFF2C4A4A, 0xFF304E4E, 0xFF30504D, 0xFF2E514B, 0xFF2E514B, 0xFF2F524B, 0xFF284A49,
    0xFF335755, 0xFF456965, 0xFF527A71, 0xFF537D71, 0xFF517D6E, 0xFF558170, 0xFF51806C, 0xFF578070, 0xFF598272, 0xFF5B8474, 0xFF5C8776, 0xFF5D8877, 0xFF5B8776, 0xFF5B8776, 0xFF5C8877, 0xFF5A8071, 0xFF608979, 0xFF659180, 0xFF588475, 0xFF5E8A7B,
    0xFF5F877C, 0xFF65897F, 0xFF67867E, 0xFF5B7F7B, 0xFF4C6C69, 0xFF476160, 0xFF485D5E, 0xFF495D5E, 0xFF486060, 0xFF456361, 0xFF416460, 0xFF46646C, 0xFF416063, 0xFF43635E, 0xFF44655A, 0xFF3E5F54, 0xFF3B5C53, 0xFF3E5E5B, 0xFF3F5E60, 0xFF355C61,
    0xFF3E6369, 0xFF3A6063, 0xFF385C5C, 0xFF3C5E5D, 0xFF3C5C59, 0xFF3D5C57, 0xFF405F5A, 0xFF466567, 0xFF537D79, 0xFF53897B, 0xFF578C7A, 0xFF5D8877, 0xFF658B7C, 0xFF588276, 0xFF5F8F81, 0xFF598A77, 0xFF5A8B78, 0xFF5B8C79, 0xFF5D8C7A, 0xFF5E8D7B,
    0xFF5E8D7B, 0xFF608C7B, 0xFF5F8B7A, 0xFF678E7C, 0xFF648A7B, 0xFF578173, 0xFF5F897B, 0xFF5E887C, 0xFF5D857C, 0xFF668983, 0xFF557570, 0xFF325654, 0xFF385C5A, 0xFF2D514F, 0xFF264A48, 0xFF335755, 0xFF2A4E4C, 0xFF2D514F, 0xFF284C48, 0xFF314D58,
    0xFF2F4C52, 0xFF345252, 0xFF2D4C47, 0xFF2B4A45, 0xFF314F4F, 0xFF2F4C52, 0xFF35515C, 0xFF265046, 0xFF2F574F, 0xFF335B53, 0xFF335753, 0xFF335652, 0xFF325251, 0xFF335151, 0xFF375557, 0xFF4C7370, 0xFF5B847C, 0xFF608C7D, 0xFF578672, 0xFF5A8B75,
    0xFF5B8A76, 0xFF5A8675, 0xFF679183, 0xFF5D8875, 0xFF5D8875, 0xFF5D8875, 0xFF5D8875, 0xFF5D8875, 0xFF5D8875, 0xFF5D8875, 0xFF5D8875, 0xFF5A8373, 0xFF608478, 0xFF67887D, 0xFF5A8277, 0xFF59897D, 0xFF5B867D, 0xFF476462, 0xFF475558, 0xFF2F4E50,
    0xFF2C4B4D, 0xFF2C4E4F, 0xFF335557, 0xFF325358, 0xFF284B51, 0xFF22454B, 0xFF22444D, 0xFF273F4B, 0xFF3A535A, 0xFF2C4849, 0xFF2F4C48, 0xFF31504B, 0xFF214042, 0xFF234149, 0xFF25434E, 0xFF224946, 0xFF355756, 0xFF324E4F, 0xFF3B5053, 0xFF364B4E,
    0xFF334B4D, 0xFF365454, 0xFF466867, 0xFF5D8678, 0xFF5F8B7C, 0xFF5D8C7C, 0xFF5B8C79, 0xFF578875, 0xFF5A8773, 0xFF608977, 0xFF608775, 0xFF5D8875, 0xFF5E8976, 0xFF5D8875, 0xFF5D8875, 0xFF5D8875, 0xFF5C8774, 0xFF5A8572, 0xFF5A8572, 0xFF5C8776,
    0xFF588777, 0xFF5A8F7F, 0xFF568C7E, 0xFF3E7065, 0xFF426966, 0xFF3E565A, 0xFF3B4A51, 0xFF37504A, 0xFF314E4A, 0xFF2D4C4F, 0xFF31525B, 0xFF36545E, 0xFF304852, 0xFF304149, 0xFF3D484E, 0xFF2D4B49, 0xFF2B4A45, 0xFF294840, 0xFF2A4A3F, 0xFF2A4B42,
    0xFF294946, 0xFF29484D, 0xFF294752, 0xFF2C4F4B, 0xFF304E4C, 0xFF324A4A, 0xFF384C4D, 0xFF384C4D, 0xFF3E5656, 0xFF446260, 0xFF688B87, 0xFF608D79, 0xFF648B79, 0xFF688D7C, 0xFF618A7A, 0xFF588372, 0x005E7F74, 0x00EFFEF9, 0x00FFFEFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFEFF, 0x41D3DFDB, 0xFF446459, 0xFF5E8777, 0xFF628678, 0xFF658777, 0xFF5C8371, 0xFF5A8773, 0xFF598471, 0xFF588370, 0xFF588370, 0xFF57826F, 0xFF55806D,
    0xFF537E6B, 0xFF527D6A, 0xFF517C69, 0xFF507C6B, 0xFF517D6C, 0xFF527E6D, 0xFF537F6E, 0xFF537F6E, 0xFF537F6E, 0xFF537F6E, 0xFF527E6D, 0xFF4E7A69, 0xFF4D7968, 0xFF4D7968, 0xFF4C7867, 0xFF4B7766, 0xFF4B7766, 0xFF4A7665, 0xFF4A7665, 0xFF4D7666,
    0xFF4D7666, 0xFF4D7666, 0xFF4E7767, 0xFF517A6A, 0xFF547D6D, 0xFF578070, 0xFF598272, 0xFF598272, 0xFF598272, 0xFF5A8373, 0xFF5A8373, 0xFF5B8474, 0xFF5B8474, 0xFF5C8575, 0xFF5C8575, 0xFF5E8777, 0xFF5F8878, 0xFF5F8878, 0xFF5F8878, 0xFF5F8878,
    0xFF608979, 0xFF608979, 0xFF608979, 0xFF628B7B, 0xFF638C7C, 0xFF638C7C, 0xFF648D7D, 0xFF658E7E, 0xFF658E7E, 0xFF668F7F, 0xFF668F7F, 0xFF669082, 0xFF649081, 0xFF628E7F, 0xFF608C7D, 0xFF5C8B7B, 0xFF5A8979, 0xFF578777, 0xFF568676, 0xFF6A9383,
    0xFF699282, 0xFF668F7F, 0xFF648D7D, 0xFF628B7B, 0xFF628B7B, 0xFF638C7C, 0xFF648D7D, 0xFF5D8676, 0xFF5D8676, 0xFF5D8676, 0xFF5D8676, 0xFF5D8676, 0xFF5D8676, 0xFF5D8676, 0xFF5D8676, 0xFF5D8676, 0xFF5E8777, 0xFF5E8777, 0xFF5E8777, 0xFF5F8878,
    0xFF5F8878, 0xFF5F8878, 0xFF608979, 0xFF5F8B7A, 0xFF5E8A79, 0xFF5C8877, 0xFF5B8776, 0xFF5B8776, 0xFF5C8877, 0xFF5E8A79, 0xFF5F8B7A, 0xFF638577, 0xFF648678, 0xFF648678, 0xFF658779, 0xFF66887A, 0xFF66887A, 0xFF67897B, 0xFF67897B, 0xFF658B7C,
    0xFF628879, 0xFF5E8475, 0xFF5B8172, 0xFF5A8071, 0xFF5B8172, 0xFF5E8475, 0xFF608677, 0xFF65897B, 0xFF65897B, 0xFF64887A, 0xFF64887A, 0xFF64887A, 0xFF64887A, 0xFF64887A, 0xFF64887A, 0xFF658B7C, 0xFF63897A, 0xFF618778, 0xFF608677, 0xFF608677,
    0xFF618778, 0xFF63897A, 0xFF658B7C, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF608775, 0xFF5F8F79, 0xFF5E8E78, 0xFF5C8C76, 0xFF5C8C76, 0xFF5D8D77, 0xFF5B8B75, 0xFF588872, 0xFF55856F, 0xFF5D7D70,
    0xFF5E7E71, 0xFF608073, 0xFF608073, 0xFF608073, 0xFF5E7E71, 0xFF5C7C6F, 0xFF5B7B6E, 0xFF478071, 0xFF457B6D, 0xFF43776A, 0xFF49796D, 0xFF507E73, 0xFF588278, 0xFF588077, 0xFF557D74, 0xFF5C7B73, 0xFF597870, 0xFF56756D, 0xFF55746C, 0xFF57766E,
    0xFF5C7B73, 0xFF628179, 0xFF66857D, 0xFF598A77, 0xFF598A77, 0xFF588976, 0xFF588976, 0xFF588976, 0xFF588976, 0xFF578875, 0xFF578875, 0xFF598A77, 0xFF598A77, 0xFF598A77, 0xFF598A77, 0xFF598A77, 0xFF598A77, 0xFF598A77, 0xFF598A77, 0xFF608677,
    0xFF618778, 0xFF63897A, 0xFF63897A, 0xFF618778, 0xFF5D8374, 0xFF587E6F, 0xFF547A6B, 0xFF54756C, 0xFF55766D, 0xFF57786F, 0xFF597A71, 0xFF597A71, 0xFF597A71, 0xFF57786F, 0xFF57786F, 0xFF416F65, 0xFF457067, 0xFF49726A, 0xFF4D756D, 0xFF52756F,
    0xFF557570, 0xFF577470, 0xFF577470, 0xFF5A786C, 0xFF577569, 0xFF547266, 0xFF557367, 0xFF5A786C, 0xFF617F73, 0xFF678579, 0xFF6A887C, 0xFF5E8978, 0xFF688C7E, 0xFF628476, 0xFF648A7B, 0xFF598574, 0x005C8273, 0x00E7FCF3, 0x00FCFFFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFAFB, 0x41D4E3DE, 0xFF45695D, 0xFF598876, 0xFF5A8574, 0xFF5B806F, 0xFF587F6D, 0xFF598471, 0xFF5D8472, 0xFF5D8472, 0xFF5D8472, 0xFF5D8472, 0xFF5D8472,
    0xFF5C8371, 0xFF5B8270, 0xFF5B8270, 0xFF598272, 0xFF588171, 0xFF588171, 0xFF578070, 0xFF567F6F, 0xFF557E6E, 0xFF557E6E, 0xFF547D6D, 0xFF557E6E, 0xFF547D6D, 0xFF547D6D, 0xFF537C6C, 0xFF527B6B, 0xFF527B6B, 0xFF517A6A, 0xFF517A6A, 0xFF527D6C,
    0xFF517C6B, 0xFF517C6B, 0xFF517C6B, 0xFF527D6C, 0xFF547F6E, 0xFF568170, 0xFF578271, 0xFF578271, 0xFF578271, 0xFF588372, 0xFF598473, 0xFF598473, 0xFF5A8574, 0xFF5B8675, 0xFF5B8675, 0xFF5E8978, 0xFF5E8978, 0xFF5E8978, 0xFF5F8A79, 0xFF5F8A79,
    0xFF5F8A79, 0xFF5F8A79, 0xFF5F8A79, 0xFF628D7C, 0xFF628D7C, 0xFF628D7C, 0xFF628D7C, 0xFF638E7D, 0xFF638E7D, 0xFF638E7D, 0xFF638E7D, 0xFF628E7F, 0xFF628E7F, 0xFF608F7F, 0xFF608F7F, 0xFF5F8F7F, 0xFF5F8F7F, 0xFF5F8F7F, 0xFF5C8F7E, 0xFF618C7B,
    0xFF618C7B, 0xFF638E7D, 0xFF648F7E, 0xFF65907F, 0xFF648F7E, 0xFF648F7E, 0xFF638E7D, 0xFF628D7C, 0xFF628D7C, 0xFF628D7C, 0xFF628D7C, 0xFF628D7C, 0xFF628D7C, 0xFF628D7C, 0xFF628D7C, 0xFF5D8877, 0xFF5E8978, 0xFF5E8978, 0xFF5E8978, 0xFF5E8978,
    0xFF5E8978, 0xFF5E8978, 0xFF5E8978, 0xFF658B7C, 0xFF648A7B, 0xFF63897A, 0xFF628879, 0xFF628879, 0xFF63897A, 0xFF648A7B, 0xFF658B7C, 0xFF658B7C, 0xFF658B7C, 0xFF668C7D, 0xFF668C7D, 0xFF678D7E, 0xFF688E7F, 0xFF688E7F, 0xFF688E7F, 0xFF6B9484,
    0xFF6A9383, 0xFF689181, 0xFF668F7F, 0xFF658E7E, 0xFF668F7F, 0xFF679080, 0xFF689181, 0xFF668F7F, 0xFF668F7F, 0xFF668F7F, 0xFF658E7E, 0xFF658E7E, 0xFF658E7E, 0xFF648D7D, 0xFF648D7D, 0xFF638C7C, 0xFF628B7B, 0xFF618A7A, 0xFF5F8878, 0xFF5F8878,
    0xFF5F8878, 0xFF5F8878, 0xFF608979, 0xFF618A78, 0xFF618A78, 0xFF618A78, 0xFF628B79, 0xFF628B79, 0xFF638C7A, 0xFF638C7A, 0xFF638C7A, 0xFF618B77, 0xFF608A76, 0xFF5F8975, 0xFF608A76, 0xFF628C78, 0xFF638D79, 0xFF638D79, 0xFF628C78, 0xFF6B9182,
    0xFF6B9182, 0xFF6C9283, 0xFF6C9283, 0xFF6B9182, 0xFF6A9081, 0xFF688E7F, 0xFF678D7E, 0xFF5F8F81, 0xFF5C8C7E, 0xFF5B897C, 0xFF608A7E, 0xFF668E83, 0xFF6C9086, 0xFF6D8E85, 0xFF6C8D84, 0xFF698F82, 0xFF698F82, 0xFF688E81, 0xFF678D80, 0xFF668C7F,
    0xFF648A7D, 0xFF63897C, 0xFF62887B, 0xFF5F8878, 0xFF5E8777, 0xFF5E8777, 0xFF5E8777, 0xFF5E8777, 0xFF5D8676, 0xFF5D8676, 0xFF5D8676, 0xFF5E8777, 0xFF5E8777, 0xFF5E8777, 0xFF5E8777, 0xFF5E8777, 0xFF5E8777, 0xFF5E8777, 0xFF5E8777, 0xFF5C8575,
    0xFF5E8777, 0xFF608979, 0xFF638C7C, 0xFF648D7D, 0xFF658E7E, 0xFF648D7D, 0xFF648D7D, 0xFF668C7F, 0xFF678D80, 0xFF698F82, 0xFF6A9083, 0xFF6A9083, 0xFF698F82, 0xFF688E81, 0xFF678D80, 0xFF5B8B7F, 0xFF5D8B80, 0xFF618C82, 0xFF658F85, 0xFF678F86,
    0xFF6B8E87, 0xFF6C8D86, 0xFF6C8D86, 0xFF6B8F81, 0xFF698D7F, 0xFF678B7D, 0xFF65897B, 0xFF65897B, 0xFF668A7C, 0xFF688C7E, 0xFF688C7E, 0xFF638C7C, 0xFF6D8F81, 0xFF678579, 0xFF6A8C7E, 0xFF5B8172, 0x005F7F72, 0x00EEFBF4, 0x00FFFBFA, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFCFD, 0x39D7E8E2, 0xFF456F61, 0xFF548975, 0xFF5B8C79, 0xFF5C8573, 0xFF5F8674, 0xFF5F8876, 0xFF5C8170, 0xFF5C8170, 0xFF5D8271, 0xFF5D8271, 0xFF5C8170,
    0xFF5C8170, 0xFF5B806F, 0xFF5B806F, 0xFF5A8071, 0xFF587E6F, 0xFF567C6D, 0xFF547A6B, 0xFF53796A, 0xFF53796A, 0xFF53796A, 0xFF53796A, 0xFF557B6C, 0xFF557B6C, 0xFF557B6C, 0xFF557B6C, 0xFF557B6C, 0xFF557B6C, 0xFF557B6C, 0xFF557B6C, 0xFF537F6E,
    0xFF527E6D, 0xFF517D6C, 0xFF517D6C, 0xFF517D6C, 0xFF527E6D, 0xFF537F6E, 0xFF54806F, 0xFF558170, 0xFF558170, 0xFF568271, 0xFF578372, 0xFF588473, 0xFF598574, 0xFF5A8675, 0xFF5A8675, 0xFF5A8675, 0xFF5A8675, 0xFF5B8776, 0xFF5B8776, 0xFF5B8776,
    0xFF5B8776, 0xFF5C8877, 0xFF5C8877, 0xFF5E8A79, 0xFF5E8A79, 0xFF5E8A79, 0xFF5E8A79, 0xFF5D8978, 0xFF5D8978, 0xFF5D8978, 0xFF5D8978, 0xFF5B8A7A, 0xFF5C8B7B, 0xFF5C8B7B, 0xFF5C8C7C, 0xFF5D8D7D, 0xFF5C8F7E, 0xFF5C8F7E, 0xFF5C8F7E, 0xFF5D8978,
    0xFF5E8A79, 0xFF5F8B7A, 0xFF608C7B, 0xFF5F8B7A, 0xFF5E8A79, 0xFF5C8877, 0xFF5B8776, 0xFF5C8877, 0xFF5C8877, 0xFF5C8877, 0xFF5C8877, 0xFF5C8877, 0xFF5C8877, 0xFF5C8877, 0xFF5C8877, 0xFF5E8A79, 0xFF5E8A79, 0xFF5E8A79, 0xFF5E8A79, 0xFF5E8A79,
    0xFF5D8978, 0xFF5D8978, 0xFF5D8978, 0xFF658779, 0xFF658779, 0xFF648678, 0xFF638577, 0xFF638577, 0xFF648678, 0xFF658779, 0xFF658779, 0xFF638C7C, 0xFF638C7C, 0xFF638C7C, 0xFF648D7D, 0xFF648D7D, 0xFF658E7E, 0xFF658E7E, 0xFF658E7E, 0xFF608C7B,
    0xFF608C7B, 0xFF608C7B, 0xFF608C7B, 0xFF608C7B, 0xFF608C7B, 0xFF5F8B7A, 0xFF5F8B7A, 0xFF638E7D, 0xFF638E7D, 0xFF648F7E, 0xFF648F7E, 0xFF648F7E, 0xFF638E7D, 0xFF628D7C, 0xFF618C7B, 0xFF5E8A79, 0xFF5E8A79, 0xFF5E8A79, 0xFF5D8978, 0xFF5D8978,
    0xFF5D8978, 0xFF5D8978, 0xFF5D8978, 0xFF5B8874, 0xFF5C8975, 0xFF5C8975, 0xFF5D8A76, 0xFF5E8B77, 0xFF5F8C78, 0xFF5F8C78, 0xFF608D79, 0xFF638575, 0xFF628474, 0xFF618373, 0xFF628474, 0xFF648676, 0xFF668878, 0xFF688A7A, 0xFF688A7A, 0xFF638F7E,
    0xFF638F7E, 0xFF628E7D, 0xFF628E7D, 0xFF618D7C, 0xFF618D7C, 0xFF608C7B, 0xFF608C7B, 0xFF608B7A, 0xFF5F8A79, 0xFF5F8878, 0xFF628879, 0xFF65897B, 0xFF698B7D, 0xFF6A8A7D, 0xFF6A887C, 0xFF5E8B77, 0xFF5F8C78, 0xFF628F7B, 0xFF63907C, 0xFF63907C,
    0xFF618E7A, 0xFF5E8B77, 0xFF5D8A76, 0xFF638779, 0xFF638779, 0xFF638779, 0xFF638779, 0xFF638779, 0xFF628678, 0xFF628678, 0xFF628678, 0xFF638779, 0xFF638779, 0xFF638779, 0xFF638779, 0xFF638779, 0xFF638779, 0xFF638779, 0xFF638779, 0xFF5E8A79,
    0xFF5E8A79, 0xFF5F8B7A, 0xFF608C7B, 0xFF628E7D, 0xFF64907F, 0xFF659180, 0xFF669281, 0xFF62917D, 0xFF63927E, 0xFF64937F, 0xFF64937F, 0xFF64937F, 0xFF63927E, 0xFF62917D, 0xFF61907C, 0xFF5A8D7C, 0xFF5D8D7D, 0xFF5F8E7E, 0xFF628E7F, 0xFF648E80,
    0xFF648D7F, 0xFF668C7F, 0xFF658B7E, 0xFF618C7B, 0xFF628D7C, 0xFF638E7D, 0xFF648F7E, 0xFF638E7D, 0xFF638E7D, 0xFF628D7C, 0xFF628D7C, 0xFF618C7B, 0xFF698D7F, 0xFF668679, 0xFF6C8C7F, 0xFF5A7C6E, 0x00698378, 0x00FBFFFD, 0x00FFFCFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFE, 0x45D1E4DE, 0xFF447061, 0xFF4D846F, 0xFF5E917E, 0xFF648D7B, 0xFF668878, 0xFF5D8271, 0xFF5D8877, 0xFF5D8877, 0xFF5D8877, 0xFF5C8776, 0xFF5B8675,
    0xFF5A8574, 0xFF588372, 0xFF578271, 0xFF568271, 0xFF558170, 0xFF54806F, 0xFF54806F, 0xFF537F6E, 0xFF537F6E, 0xFF537F6E, 0xFF54806F, 0xFF517D6C, 0xFF517D6C, 0xFF517D6C, 0xFF527E6D, 0xFF527E6D, 0xFF537F6E, 0xFF537F6E, 0xFF537F6E, 0xFF537E6D,
    0xFF537E6D, 0xFF537E6D, 0xFF537E6D, 0xFF547F6E, 0xFF55806F, 0xFF568170, 0xFF578271, 0xFF598473, 0xFF598473, 0xFF5A8574, 0xFF5B8675, 0xFF5C8776, 0xFF5D8877, 0xFF5E8978, 0xFF5E8978, 0xFF5F8A79, 0xFF5F8A79, 0xFF5F8A79, 0xFF608B7A, 0xFF608B7A,
    0xFF608B7A, 0xFF608B7A, 0xFF608B7A, 0xFF628D7C, 0xFF628D7C, 0xFF628D7C, 0xFF628D7C, 0xFF628D7C, 0xFF628D7C, 0xFF628D7C, 0xFF628D7C, 0xFF628C7E, 0xFF628C7E, 0xFF618D7E, 0xFF618D7E, 0xFF5F8E7E, 0xFF5F8E7E, 0xFF5E8D7D, 0xFF5D8D7D, 0xFF65907F,
    0xFF648F7E, 0xFF628D7C, 0xFF618C7B, 0xFF608B7A, 0xFF618C7B, 0xFF618C7B, 0xFF628D7C, 0xFF618C7B, 0xFF618C7B, 0xFF618C7B, 0xFF618C7B, 0xFF618C7B, 0xFF618C7B, 0xFF618C7B, 0xFF618C7B, 0xFF628D7C, 0xFF628D7C, 0xFF618C7B, 0xFF618C7B, 0xFF608B7A,
    0xFF608B7A, 0xFF608B7A, 0xFF608B7A, 0xFF64887A, 0xFF64887A, 0xFF638779, 0xFF628678, 0xFF628678, 0xFF638779, 0xFF64887A, 0xFF64887A, 0xFF638C7C, 0xFF638C7C, 0xFF638C7C, 0xFF648D7D, 0xFF648D7D, 0xFF648D7D, 0xFF658E7E, 0xFF658E7E, 0xFF618C7B,
    0xFF628D7C, 0xFF638E7D, 0xFF648F7E, 0xFF648F7E, 0xFF648F7E, 0xFF648F7E, 0xFF638E7D, 0xFF648D7D, 0xFF658E7E, 0xFF668F7F, 0xFF679080, 0xFF668F7F, 0xFF658E7E, 0xFF638C7C, 0xFF628B7B, 0xFF628D7C, 0xFF628D7C, 0xFF628D7C, 0xFF628D7C, 0xFF628D7C,
    0xFF638E7D, 0xFF638E7D, 0xFF648F7E, 0xFF608B7A, 0xFF608B7A, 0xFF608B7A, 0xFF608B7A, 0xFF618C7B, 0xFF618C7B, 0xFF628D7C, 0xFF628D7C, 0xFF668D7B, 0xFF658C7A, 0xFF658C7A, 0xFF658C7A, 0xFF658C7A, 0xFF668D7B, 0xFF668D7B, 0xFF678E7C, 0xFF61907E,
    0xFF61907E, 0xFF608F7D, 0xFF608F7D, 0xFF608F7D, 0xFF608F7D, 0xFF61907E, 0xFF61907E, 0xFF638E7B, 0xFF638E7B, 0xFF648D7B, 0xFF648D7B, 0xFF668D7B, 0xFF688D7C, 0xFF688D7C, 0xFF688D7C, 0xFF61917B, 0xFF61917B, 0xFF61917B, 0xFF60907A, 0xFF5F8F79,
    0xFF5E8E78, 0xFF5D8D77, 0xFF5D8D77, 0xFF628879, 0xFF628879, 0xFF618778, 0xFF618778, 0xFF618778, 0xFF618778, 0xFF608677, 0xFF608677, 0xFF618778, 0xFF618778, 0xFF618778, 0xFF618778, 0xFF618778, 0xFF618778, 0xFF618778, 0xFF618778, 0xFF608C7B,
    0xFF608C7B, 0xFF5F8B7A, 0xFF5F8B7A, 0xFF5F8B7A, 0xFF608C7B, 0xFF608C7B, 0xFF618D7C, 0xFF5F907A, 0xFF5F907A, 0xFF60917B, 0xFF60917B, 0xFF5F907A, 0xFF5E8F79, 0xFF5D8E78, 0xFF5D8E78, 0xFF62917D, 0xFF62917D, 0xFF63927E, 0xFF65927E, 0xFF65907D,
    0xFF648F7C, 0xFF648D7B, 0xFF648D7B, 0xFF62917F, 0xFF649381, 0xFF669583, 0xFF659482, 0xFF639280, 0xFF608F7D, 0xFF5F8E7C, 0xFF5E8D7B, 0xFF578A77, 0xFF648F7E, 0xFF678D7E, 0xFF6D9384, 0xFF547D6D, 0x0069877B, 0x00F6FFFB, 0x00FEF5F6, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFEFF, 0x48CFE0DA, 0xFF496F62, 0xFF406F5D, 0xFF4E7767, 0xFF59796A, 0xFF5E7A6C, 0xFF597869, 0xFF507C6B, 0xFF507C6B, 0xFF507C6B, 0xFF4F7B6A, 0xFF4E7A69,
    0xFF4D7968, 0xFF4C7867, 0xFF4B7766, 0xFF497866, 0xFF497866, 0xFF497866, 0xFF497866, 0xFF497866, 0xFF487765, 0xFF477664, 0xFF467563, 0xFF497866, 0xFF497866, 0xFF487765, 0xFF477664, 0xFF467563, 0xFF457462, 0xFF457462, 0xFF447361, 0xFF537567,
    0xFF537567, 0xFF537567, 0xFF537567, 0xFF537567, 0xFF547668, 0xFF557769, 0xFF557769, 0xFF587A6C, 0xFF587A6C, 0xFF597B6D, 0xFF5A7C6E, 0xFF5B7D6F, 0xFF5B7D6F, 0xFF5C7E70, 0xFF5C7E70, 0xFF608274, 0xFF608274, 0xFF608274, 0xFF608274, 0xFF618375,
    0xFF618375, 0xFF618375, 0xFF618375, 0xFF618375, 0xFF628476, 0xFF628476, 0xFF638577, 0xFF638577, 0xFF648678, 0xFF648678, 0xFF648678, 0xFF64857A, 0xFF638479, 0xFF638479, 0xFF608478, 0xFF608478, 0xFF5E8477, 0xFF5E8477, 0xFF5E8477, 0xFF618375,
    0xFF618375, 0xFF618375, 0xFF628476, 0xFF638577, 0xFF648678, 0xFF658779, 0xFF66887A, 0xFF67897B, 0xFF67897B, 0xFF67897B, 0xFF67897B, 0xFF67897B, 0xFF67897B, 0xFF67897B, 0xFF67897B, 0xFF648678, 0xFF648678, 0xFF638577, 0xFF638577, 0xFF628476,
    0xFF628476, 0xFF628476, 0xFF628476, 0xFF63897A, 0xFF63897A, 0xFF628879, 0xFF628879, 0xFF628879, 0xFF628879, 0xFF63897A, 0xFF63897A, 0xFF66887A, 0xFF66887A, 0xFF66887A, 0xFF66887A, 0xFF66887A, 0xFF66887A, 0xFF67897B, 0xFF67897B, 0xFF678B7D,
    0xFF678B7D, 0xFF678B7D, 0xFF688C7E, 0xFF688C7E, 0xFF698D7F, 0xFF698D7F, 0xFF6A8E80, 0xFF67897B, 0xFF688A7C, 0xFF698B7D, 0xFF6A8C7E, 0xFF6A8C7E, 0xFF698B7D, 0xFF67897B, 0xFF66887A, 0xFF668A7C, 0xFF65897B, 0xFF638779, 0xFF618577, 0xFF618577,
    0xFF628678, 0xFF638779, 0xFF64887A, 0xFF65897B, 0xFF64887A, 0xFF64887A, 0xFF64887A, 0xFF638779, 0xFF638779, 0xFF638779, 0xFF628678, 0xFF628B79, 0xFF638C7A, 0xFF638C7A, 0xFF638C7A, 0xFF628B79, 0xFF628B79, 0xFF618A78, 0xFF618A78, 0xFF628B7B,
    0xFF618A7A, 0xFF618A7A, 0xFF618A7A, 0xFF628B7B, 0xFF638C7C, 0xFF658E7E, 0xFF668F7F, 0xFF628D7A, 0xFF638E7B, 0xFF638E7B, 0xFF638E7B, 0xFF628D7A, 0xFF638C7A, 0xFF638C7A, 0xFF648D7B, 0xFF68927E, 0xFF68927E, 0xFF67917D, 0xFF67917D, 0xFF66907C,
    0xFF66907C, 0xFF66907C, 0xFF66907C, 0xFF638E7D, 0xFF638E7D, 0xFF638E7D, 0xFF638E7D, 0xFF638E7D, 0xFF628D7C, 0xFF628D7C, 0xFF628D7C, 0xFF638E7D, 0xFF638E7D, 0xFF638E7D, 0xFF638E7D, 0xFF638E7D, 0xFF638E7D, 0xFF638E7D, 0xFF638E7D, 0xFF678D7E,
    0xFF688E7F, 0xFF688E7F, 0xFF6A9081, 0xFF6B9182, 0xFF6C9283, 0xFF6C9283, 0xFF6D9384, 0xFF6B9682, 0xFF6B9682, 0xFF6B9682, 0xFF6B9682, 0xFF6A9581, 0xFF6A9581, 0xFF699480, 0xFF699480, 0xFF6B9280, 0xFF6B9280, 0xFF6B9280, 0xFF6A917F, 0xFF69907E,
    0xFF698E7D, 0xFF698E7D, 0xFF688D7C, 0xFF689181, 0xFF699282, 0xFF6B9484, 0xFF6A9383, 0xFF679080, 0xFF658E7E, 0xFF648D7D, 0xFF658E7E, 0xFF5C917D, 0xFF62917F, 0xFF618C7B, 0xFF5E8A79, 0xFF477664, 0x00678D7E, 0x00F1FFFA, 0x00FFFFFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFAFB, 0x39D7E2DE, 0xFF7E988F, 0xFF718F83, 0xFF72877E, 0xFF77877D, 0xFF74887D, 0xFF728A7D, 0xFF6E8F84, 0xFF6E8F84, 0xFF6F9085, 0xFB709186, 0xFB709186,
    0xFB709186, 0xFB709186, 0xFF6F9085, 0xFF6E9284, 0xFF6E9284, 0xFF6E9284, 0xFF6E9284, 0xFF6C9082, 0xFF6A8E80, 0xFF688C7E, 0xFF678B7D, 0xFF65897B, 0xFF64887A, 0xFF628678, 0xFF608476, 0xFF5D8173, 0xFF5A7E70, 0xFF587C6E, 0xFF577B6D, 0xFF60756C,
    0xFF5F746B, 0xFF5F746B, 0xFF5E736A, 0xFF5D7269, 0xFF5D7269, 0xFF5C7168, 0xFF5C7168, 0xFF5F746B, 0xFF5F746B, 0xFF60756C, 0xFF60756C, 0xFF61766D, 0xFF61766D, 0xFF61766D, 0xFF62776E, 0xFF61766D, 0xFF61766D, 0xFF61766D, 0xFF62776E, 0xFF62776E,
    0xFF62776E, 0xFF62776E, 0xFF62776E, 0xFF62776E, 0xFF62776E, 0xFF63786F, 0xFF63786F, 0xFF647970, 0xFF657A71, 0xFF667B72, 0xFF667B72, 0xFF657872, 0xFF657872, 0xFF647972, 0xFF647972, 0xFF647B73, 0xFF647B73, 0xFF647B73, 0xFF627C73, 0xFF60756C,
    0xFF62776E, 0xFF647970, 0xFF667B72, 0xFF667B72, 0xFF657A71, 0xFF62776E, 0xFF61766D, 0xFF60756C, 0xFF60756C, 0xFF60756C, 0xFF60756C, 0xFF60756C, 0xFF60756C, 0xFF60756C, 0xFF60756C, 0xFF61766D, 0xFF61766D, 0xFF61766D, 0xFF61766D, 0xFF61766D,
    0xFF60756C, 0xFF60756C, 0xFF60756C, 0xFF5D7B6F, 0xFF5D7B6F, 0xFF5D7B6F, 0xFF5D7B6F, 0xFF5D7B6F, 0xFF5D7B6F, 0xFF5D7B6F, 0xFF5D7B6F, 0xFF60776D, 0xFF60776D, 0xFF60776D, 0xFF60776D, 0xFF60776D, 0xFF60776D, 0xFF60776D, 0xFF60776D, 0xFF60776D,
    0xFF5F766C, 0xFF5F766C, 0xFF5F766C, 0xFF5F766C, 0xFF60776D, 0xFF61786E, 0xFF62796F, 0xFF63786F, 0xFF647970, 0xFF647970, 0xFF657A71, 0xFF647970, 0xFF647970, 0xFF62776E, 0xFF62776E, 0xFF62796F, 0xFF60776D, 0xFF5C7369, 0xFF597066, 0xFF576E64,
    0xFF576E64, 0xFF586F65, 0xFF597066, 0xFF5B726A, 0xFF5B726A, 0xFF5A7169, 0xFF597068, 0xFF597068, 0xFF586F67, 0xFF576E66, 0xFF576E66, 0xFF4F6F62, 0xFF517164, 0xFF537366, 0xFF537366, 0xFF537366, 0xFF527265, 0xFF517164, 0xFF517164, 0xFF526E62,
    0xFF526E62, 0xFF526E62, 0xFF526E62, 0xFF536F63, 0xFF557165, 0xFF567266, 0xFF577367, 0xFF507264, 0xFF507264, 0xFF517365, 0xFF517365, 0xFF507264, 0xFF507264, 0xFF4F7163, 0xFF4F7163, 0xFF536F61, 0xFF557163, 0xFF577365, 0xFF597567, 0xFF597567,
    0xFF587466, 0xFF567264, 0xFF557163, 0xFF537567, 0xFF537567, 0xFF537567, 0xFF527466, 0xFF527466, 0xFF527466, 0xFF527466, 0xFF517365, 0xFF527466, 0xFF527466, 0xFF527466, 0xFF527466, 0xFF527466, 0xFF527466, 0xFF527466, 0xFF527466, 0xFF547064,
    0xFF557165, 0xFF567266, 0xFF587468, 0xFF587468, 0xFF597569, 0xFF587468, 0xFF587468, 0xFF597567, 0xFF597567, 0xFF597567, 0xFF597567, 0xFF587466, 0xFF587466, 0xFF587466, 0xFF587466, 0xFF5C7669, 0xFF5C7669, 0xFF5C7669, 0xFF5B7568, 0xFF597567,
    0xFF597567, 0xFF587466, 0xFF587466, 0xFF597569, 0xFF597569, 0xFF587468, 0xFF587468, 0xFF577367, 0xFF567266, 0xFF577367, 0xFF587468, 0xFF507B6A, 0xFF55796B, 0xFF56786A, 0xFF53796A, 0xFF4D7867, 0x0074988A, 0x00E5F9F0, 0x00FEFFFD, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFDFF, 0x00FEFFFF, 0x0BEFFAF6, 0x00F9FFFD, 0x00FFFFFD, 0x00FFFFFB, 0x00F7FFF9, 0x0BEFFFF8, 0x00F6FFFD, 0x00F7FFFE, 0x00F7FFFE, 0x00F8FFFF, 0x00F8FFFF,
    0x00F8FFFF, 0x00F8FFFF, 0x00F8FFFF, 0x00F7FFFD, 0x00F7FFFD, 0x00F7FFFD, 0x00F7FFFD, 0x00F6FFFC, 0x00F5FFFB, 0x04F4FFFA, 0x04F4FFFA, 0x00F7FFFD, 0x00F7FFFD, 0x00F7FFFD, 0x00F5FFFB, 0x04F3FFF9, 0x08F1FEF7, 0x0BF0FDF6, 0x0BEFFCF5, 0x00F6FFFA,
    0x00F6FFFA, 0x00F6FFFA, 0x00F6FFFA, 0x00F5FEF9, 0x04F4FDF8, 0x04F4FDF8, 0x04F3FCF7, 0x00F5FEF9, 0x00F5FEF9, 0x00F5FEF9, 0x00F5FEF9, 0x00F5FEF9, 0x00F5FEF9, 0x00F5FEF9, 0x00F5FEF9, 0x08F1FAF5, 0x08F1FAF5, 0x08F1FAF5, 0x08F2FBF6, 0x08F2FBF6,
    0x08F2FBF6, 0x08F2FBF6, 0x08F2FBF6, 0x08F1FAF5, 0x08F2FBF6, 0x08F2FBF6, 0x08F2FBF6, 0x04F3FCF7, 0x04F3FCF7, 0x04F3FCF7, 0x04F3FCF7, 0x00F5FBF9, 0x00F5FBF9, 0x00F5FBF9, 0x04F3FCF9, 0x04F4FDFA, 0x04F3FEFA, 0x04F3FEFA, 0x04F4FFFB, 0x08F2FBF6,
    0x04F3FCF7, 0x00F5FEF9, 0x00F6FFFA, 0x04F4FDF8, 0x08F1FAF5, 0x0FEDF6F1, 0x13EBF4EF, 0x17EAF3EE, 0x17EAF3EE, 0x17EAF3EE, 0x17EAF3EE, 0x17EAF3EE, 0x17EAF3EE, 0x17EAF3EE, 0x17EAF3EE, 0x17E9F2ED, 0x17E9F2ED, 0x17E9F2ED, 0x17E9F2ED, 0x17E9F2ED,
    0x17E9F2ED, 0x17EAF3EE, 0x17EAF3EE, 0x1BE7F2EC, 0x1BE7F2EC, 0x1BE7F2EC, 0x1BE8F3ED, 0x1BE8F3ED, 0x1BE7F2EC, 0x1BE7F2EC, 0x1BE7F2EC, 0x1BE7F2EC, 0x1BE7F2EC, 0x1EE6F1EB, 0x1EE6F1EB, 0x1EE6F1EB, 0x1EE6F1EB, 0x1EE6F1EB, 0x1EE6F1EB, 0x1EE6F1EB,
    0x1EE6F1EB, 0x1EE6F1EB, 0x1EE6F1EB, 0x1EE6F1EB, 0x1BE7F2EC, 0x1BE7F2EC, 0x1BE7F2EC, 0x1BE8F1EC, 0x1BE8F1EC, 0x1BE8F1EC, 0x1BE8F1EC, 0x1BE8F1EC, 0x1BE8F1EC, 0x1BE7F0EB, 0x1BE7F0EB, 0x1EE6F1EB, 0x1EE5F0EA, 0x26E2EDE7, 0x2AE0EBE5, 0x2EDEE9E3,
    0x2EDDE8E2, 0x2EDEE9E3, 0x2EDEE9E3, 0x2EDEE9E5, 0x2EDEE9E5, 0x2EDEE9E5, 0x2EDDE8E4, 0x2EDDE8E4, 0x31DCE7E3, 0x31DCE7E3, 0x31DCE7E3, 0x39D8E5DE, 0x35DAE7E0, 0x31DBE8E1, 0x31DBE8E1, 0x35DAE7E0, 0x35D9E6DF, 0x35DAE7E0, 0x31DBE8E1, 0x2EDDE8E2,
    0x31DCE7E1, 0x31DCE7E1, 0x31DCE7E1, 0x2EDDE8E2, 0x2EDDE8E2, 0x2EDEE9E3, 0x2EDEE9E3, 0x31DBE7E5, 0x31DBE7E5, 0x31DBE7E5, 0x31DCE8E6, 0x35DAE9E6, 0x35DAE9E6, 0x39D8E8E5, 0x39D7E7E4, 0x35D9E4E0, 0x31DBE6E2, 0x31DCE7E3, 0x31DCE7E3, 0x35DAE5E1,
    0x3DD6E1DD, 0x45D2DDD9, 0x48CFDAD6, 0x50CCDBD4, 0x50CCDBD4, 0x50CCDBD4, 0x50CCDBD4, 0x50CCDBD4, 0x50CBDAD3, 0x50CBDAD3, 0x50CBDAD3, 0x50CBDAD3, 0x50CBDAD3, 0x50CBDAD3, 0x50CBDAD3, 0x50CBDAD3, 0x50CBDAD3, 0x50CBDAD3, 0x50CBDAD3, 0x54CAD9D2,
    0x54CAD9D2, 0x54CAD9D2, 0x54CAD9D2, 0x54C9D8D1, 0x58C8D7D0, 0x58C8D7D0, 0x58C7D6CF, 0x4CCDD9D5, 0x4CCDD9D5, 0x4CCDD9D5, 0x4CCDD9D5, 0x4CCDD9D5, 0x4CCEDAD6, 0x4CCEDAD6, 0x4CCEDAD6, 0x4CCDD9D5, 0x50CCD8D4, 0x50CCD8D4, 0x54CAD9D4, 0x54C9D8D3,
    0x58C8D9D3, 0x54C9DAD4, 0x54C9DAD4, 0x4CCDDAD3, 0x50CBD8D1, 0x58C8D5CE, 0x5BC5D2CB, 0x5FC3D0C9, 0x63C1CEC7, 0x67C0CDC6, 0x67BFCCC5, 0x6EBCCDC5, 0x63C2CFC8, 0x54C9D4CE, 0x63C1D5CC, 0x72BAD6CA, 0x00C5DCD2, 0x00F7FFFB, 0x00FFF9FA, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF
};

static GUI_CONST_STORAGE GUI_BITMAP _bmPlatine_250x200 =
{
    250,                                  // XSize
    200,                                  // YSize
    1000,                                 // BytesPerLine
    32,                                   // BitsPerPixel
    (unsigned char *)_acPlatine_250x200,  // Pointer to picture data
    NULL,                                 // Pointer to palette
    GUI_DRAW_BMPM8888I
};
#else
static GUI_CONST_STORAGE unsigned long _acPlatine_250x200[] =
{
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFEFEFE, 0xE4E8E8E8, 0xE8E9EBEB, 0xC2D6D8D8, 0xBAD2D4D4, 0xBAD2D4D4, 0xBAD2D4D4,
    0xC6D7D9D9, 0xC2D5D7D7, 0xBAD2D4D4, 0xC2D5DAD8, 0xBED4D9D8, 0xC2D6DBDA, 0xC2D5DAD9, 0xBAD1D5D6, 0xBED3D7D8, 0xCAD9DCE0, 0xCEDBDEE2, 0xBAD2D9DC, 0xC6D7DEE1, 0xCAD9E0E3, 0xC2D6DDE0, 0xBAD2D9DC, 0xBAD2D9DC, 0xC2D6DDE0, 0xCAD9E0E3, 0xBAD2DBDF,
    0xC2D6DFE3, 0xBED3DADD, 0xBED3DADD, 0xC6D7DCDD, 0xBED4D9DA, 0xC2D6DCDB, 0xCAD9DEDD, 0xB7CFD8DB, 0xC6D8E1E4, 0xBAD2DADA, 0xB7D0D8D8, 0xBAD2D8D7, 0xC2D5DBDA, 0xE4E7EDEC, 0xE4E7ECEA, 0xFFF8F8F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFF7F7F7, 0xB7CFCFCF, 0x00B8BABA, 0x00929494, 0x00828484, 0x00838585, 0x00888A8A,
    0x008E9090, 0x00888A8A, 0x00868888, 0x00919695, 0x00939897, 0x00949998, 0x00939798, 0x00929697, 0x0093969A, 0x00919498, 0x008C8F93, 0x0090979A, 0x00979EA1, 0x009AA1A4, 0x00969DA0, 0x00959C9F, 0x00989FA2, 0x00959C9F, 0x008F9699, 0x00949DA1,
    0x0098A1A5, 0x00959EA2, 0x009CA3A6, 0x009CA3A6, 0x00979C9D, 0x00979C9D, 0x008E9394, 0x008D9699, 0x00949DA0, 0x008B9497, 0x00899191, 0x00868E8E, 0x00949A99, 0x00AEB4B3, 0x8DBAC0BF, 0xFBF4F4F4, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFBF4F4F4, 0x91BCBCBC, 0x00B9BEBD, 0x00A8ADAC, 0x00AAAFAE, 0x00A7ACAB, 0x00A1A6A5,
    0x009EA3A2, 0x009BA09F, 0x00A9AEAD, 0x00C6CBCA, 0x00D2D6D7, 0x00D5D9DA, 0x00D6DADB, 0x00DCDFE3, 0x00D8DBDF, 0x00C2C5CA, 0x00AFB2B7, 0x00C7CCCF, 0x00D4D9DC, 0x00DCE1E4, 0x00DBE0E3, 0x00E0E5E8, 0x00E4E9EC, 0x00D5DADD, 0x00BEC3C6, 0x00C8D0D7,
    0x00C9CFD4, 0x00CAD0D5, 0x00D8DEE3, 0x00D8DDE0, 0x00D1D6D9, 0x00D1D5D6, 0x00BCC0C1, 0x00AFB8BC, 0x00B3B9BE, 0x00B0B7BA, 0x00ABB2B5, 0x00A2A7A8, 0x00A7ACAD, 0x00B2B6B7, 0x00C0C5C4, 0xF4F0F0F0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFF5F5F5, 0x85B6B6B6, 0x00ACB1B0, 0x00B4B9B8, 0x00C7CCCB, 0x00BCC1C0, 0x00AEB3B2,
    0x00A9AEAD, 0x00A7ACAB, 0x00BCC1C0, 0x00CFD4D5, 0x00EEF3F4, 0x00FAFFFF, 0x00FAFFFF, 0x00FAFFFF, 0x00F6FAFF, 0x00D4D8DD, 0x00BDC1C6, 0x00DEE1E6, 0x00F3F6FB, 0x00FBFEFF, 0x00F8FBFF, 0x00FBFEFF, 0x00FBFEFF, 0x00F8FBFF, 0x00DEE1E6, 0x00E6E9F1,
    0x00E0E3EB, 0x00E4E8ED, 0x00FBFEFF, 0x00FBFEFF, 0x00FDFEFF, 0x00FDFEFF, 0x00E7E8EC, 0x00BBBFC4, 0x00B6BABF, 0x00BABEC3, 0x00BABDC1, 0x00AEB1B5, 0x00B1B3B4, 0x00A5A7A8, 0x00B0B2B3, 0xF0EDEDED, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCFCFC, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFF8F8F8, 0x89B8B8B8, 0x00ACB1B0, 0x00B2B7B6, 0x00B9BEBD, 0x00A6ABAA, 0x00A1A6A5,
    0x00A6ABAA, 0x009DA2A1, 0x00A9AEAD, 0x00B4B9BA, 0x00E5EAEB, 0x00FAFFFF, 0x00F7FCFF, 0x00FAFFFF, 0x00E9EDF2, 0x00C7CBD0, 0x00B6BABF, 0x00C4C4CA, 0x00E9E9EF, 0x00FDFDFF, 0x00FAFAFF, 0x00F7F7FD, 0x00FCFCFF, 0x00EFEFF5, 0x00D4D4DA, 0x00B3B5BD,
    0x00B4B6BE, 0x00CDCFD7, 0x00F9F9FF, 0x00FDFDFF, 0x00FCFBFF, 0x00F7F6FA, 0x00CAC9CD, 0x00A7AAAF, 0x009A9DA2, 0x00A0A3A8, 0x00A7A8AC, 0x00A4A5A9, 0x00B0AFB1, 0x00A09FA1, 0x00B0AFB1, 0xECECECEC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCFCFC, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFB, 0xFFFFFFFC, 0xFFFFFFFE, 0xFFFCFCFC, 0xFFFBFBFB, 0xFFFEFFFD, 0xFFFEFFFB, 0xFFFFFFFB, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFEFFFD, 0xFFFEFFFD, 0xFFFDFEFC,
    0xFFFEFFFD, 0xFFFEFFFD, 0xFFFEFFFD, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFEFFFD, 0xFFFFFFFE,
    0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFDFFFB, 0xFFFDFFFB, 0xFFFDFFFB, 0xFFFDFFFB, 0xFFFDFFFB,
    0xFFFDFFFB, 0xFFFDFFFB, 0xFFFDFFFB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFFFB, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFEFDFF, 0xFFFDFBFF,
    0xFFFFFDFF, 0xFFFDFCFE, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFDFCFE, 0xFFFFFDFF, 0xFFFDFBFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFCFF, 0xFFFDFBFF, 0xFFFCFAFF, 0xFFFFFEFF, 0xFFFFFEFF,
    0xFFFDFCFE, 0xFFFBFAFC, 0xFFFCFCFC, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFCFBFF, 0xFFFCFBFF, 0xFFFDFCFF, 0xFFFEFDFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFEFDFF,
    0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFBFF, 0xFFFEFBFF, 0xFFFFFDFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFFFF, 0xFFF6F7F5, 0x85B7B8B6, 0x00B6BBBA, 0x00AFB4B3, 0x00B7BCBB, 0x00A6ABAA, 0x008F9493,
    0x00969B9A, 0x00A5AAA9, 0x00B0B5B4, 0x00B1B7B6, 0x00E9EFEE, 0x00F4FAF9, 0x00F3F9F8, 0x00F8FEFD, 0x00CDD3D2, 0x009BA1A0, 0x008F9594, 0x00A0A3A7, 0x00A5A8AC, 0x00EDF0F4, 0x00FBFEFF, 0x00F3F6FA, 0x00FBFEFF, 0x00CBCED2, 0x0095989C, 0x008E9392,
    0x008E9392, 0x009DA2A1, 0x00FDFFFF, 0x00F9FBFB, 0x00FDFDFD, 0x00F9F9F9, 0x00AFAFAF, 0x00A3A8A7, 0x009CA1A0, 0x00989D9C, 0x00969B9A, 0x009CA1A0, 0x00A1A6A5, 0x00A6ABAA, 0x00B5BAB9, 0xE8ECEAF0, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFCFAFF,
    0xFFFDFBFF, 0xFFFFFDFF, 0xFFFBF9FF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFDFCFE, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFEFE, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFDFBFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFF8F7F9, 0xFFFFFEFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFC, 0xFFFEFFFD, 0xFFFEFEFE, 0xFFFEFDFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFEFDFF,
    0xFFFEFDFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCFCFC, 0xFFFDFDFD, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFDFFFE, 0xFFFDFFFE, 0xFFFDFFFE, 0xFFFDFFFE, 0xFFFDFFFE,
    0xFFFDFFFE, 0xFFFDFFFE, 0xFFFDFFFE, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFDFEFA, 0xFFFCFDFB, 0xFFFDFEFC, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFEFF,
    0xFFFFFFFF, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFDFF, 0xFFFDFCFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFE,
    0xFFFFFFFE, 0xFFFEFFFD, 0xFFFFFFFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFEFFFB, 0xFFFEFFFB, 0xFFFDFEFA,
    0xFFFDFEFA, 0xFFFCFDF9, 0xFFFBFCF8, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFDFDFD, 0xFFFCFCFC, 0xFFFBFBFB, 0xFFFEFFFB,
    0xFFFEFFFB, 0xFFFEFFFB, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFBFAFE, 0xFFFFFEFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFE, 0xFFFFFFFC, 0xF7F6F8F2, 0x76B1B3AD, 0x00B1B6B5, 0x00A7ACAB, 0x00B3B8B7, 0x00ACB1B0, 0x00979C9B,
    0x00969B9A, 0x009EA3A2, 0x00A5AAA9, 0x00929897, 0x00A3A9A8, 0x009EA4A3, 0x009CA2A1, 0x00A0A6A5, 0x00959B9A, 0x00909695, 0x00979D9C, 0x00888C8D, 0x00939798, 0x00A3A7A8, 0x009FA3A4, 0x00A0A4A5, 0x00A9ADAE, 0x00A4A8A9, 0x00A1A5A6, 0x008C9190,
    0x00A1A6A5, 0x00A1A6A5, 0x00B9BBBB, 0x00B5B7B7, 0x00B6B6B6, 0x00AFAFAF, 0x00A7A7A7, 0x009DA2A1, 0x00A6ABAA, 0x00AEB3B2, 0x00A8ADAC, 0x00A4A9A8, 0x00A5AAA9, 0x00ABB0AF, 0x00BDC2C1, 0xF0EDEDED, 0xFFFDFDFD, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFDFEFC, 0xFFFDFEFC, 0xFFFEFFFD, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFDFEFC, 0xFFFCFCFC, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFE, 0xFFFDFEFA, 0xFFFFFFFB, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFCFBFF, 0xFFFCFBFF, 0xFFFFFDFF, 0xFFFEFCFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFF,
    0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFDFCFE,
    0xFFFDFCFE, 0xFFFDFCFE, 0xFFFDFCFE, 0xFFFDFCFE, 0xFFFDFCFE, 0xFFFDFCFE, 0xFFFDFCFE, 0xFFFEFDFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFEFDFF, 0xFFFDFCFE, 0xFFFCFDFF, 0xFFFCFDFF, 0xFFFCFDFF, 0xFFFDFEFF, 0xFFFDFEFF,
    0xFFFDFEFF, 0xFFFDFEFF, 0xFFFDFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFEFFFD, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFC,
    0xFFFFFFFE, 0xFFFCFDFB, 0xFFFEFFFD, 0xFFFEFFFD, 0xFFFCFDFB, 0xFFFFFFFE, 0xFFFFFFFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFEFFFB,
    0xFFFCFDF9, 0xFFFEFFFB, 0xFFFFFFFC, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFCFDFB, 0xFFFDFEFC, 0xFFFDFEFC, 0xFFFDFEFC, 0xFFFEFFFD, 0xFFFEFFFD, 0xFFFEFFFD, 0xFFFFFFFE, 0xFFFDFEFC,
    0xFFFDFEFC, 0xFFFDFEFC, 0xFFFDFEFC, 0xFFFDFEFC, 0xFFFDFEFC, 0xFFFDFEFC, 0xFFFDFEFC, 0xFFFEFFFB, 0xFFFEFFFB, 0xFFFEFFFB, 0xFFFEFFFB, 0xFFFEFFFB, 0xFFFEFFFB, 0xFFFEFFFB, 0xFFFEFFFB, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC,
    0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFEFFFB, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFC,
    0xFFFFFFFC, 0xFFFEFFFB, 0xFFFEFFFB, 0xFFFDFEFA, 0xFFFCFDF9, 0xFFFBFCF8, 0xFFFAFBF7, 0xFFFDFEFC, 0xFFFFFFFE, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFB, 0xFFFCFEF8, 0xF4F5F8EF, 0x6EAFB2A9, 0x00B5BAB9, 0x00B7BCBB, 0x00B8BDBC, 0x00A4A9A8, 0x00969B9A,
    0x009DA2A1, 0x00969B9A, 0x00858A89, 0x00949998, 0x008D9291, 0x008E9392, 0x00979C9B, 0x00919695, 0x00898E8D, 0x00919695, 0x008E9392, 0x00979C9B, 0x00A8ADAC, 0x00989D9C, 0x00949998, 0x00979C9B, 0x00878C8B, 0x008B908F, 0x009A9F9E, 0x00909594,
    0x00A4A9A8, 0x00A3A8A7, 0x008C8E8E, 0x009A9C9C, 0x009D9D9D, 0x00838383, 0x00969696, 0x009DA2A1, 0x00A7ACAB, 0x00ABB0AF, 0x009DA2A1, 0x009A9F9E, 0x00A1A6A5, 0x00A4A9A8, 0x00B3B8B7, 0xF0F0F1ED, 0xFFFEFFFB, 0xFFFDFEFA, 0xFFFDFEFA, 0xFFFFFFFC,
    0xFFFDFEFA, 0xFFFCFDF9, 0xFFFBFCF8, 0xFFFEFFFD, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFEFFFD, 0xFFFDFEFC, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFBFCFA, 0xFFFEFFFB, 0xFFFEFFFA, 0xFFFCFFF6, 0xF7F8FBF2, 0xF7F9FDF2, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCFCFC, 0xFFFBFAFC, 0xFFFFFEFF, 0xFFFFFDFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF,
    0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFCFF, 0xFFFFFCFF, 0xFFFFFCFF, 0xFFFFFEFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFCFBFF, 0xFFFCFBFF, 0xFFFCFBFF, 0xFFFDFCFF, 0xFFFEFDFF,
    0xFFFEFDFF, 0xFFFEFDFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFFFBFF, 0xFFFDF9FE, 0xFFFDF9FE, 0xFFFFFCFF, 0xFFFFFDFF, 0xFFFFFCFE, 0xFFFEFBFD, 0xFFFFFCFE, 0xFFFFFFFE,
    0xFFFFFEFD, 0xFFFFFDFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFDFF, 0xFFFFFEFD, 0xFFFFFFFE, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFFFE, 0xFFFEFEFE, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC,
    0xFFFCFCFC, 0xFFFCFBFD, 0xFFFCFBFD, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF,
    0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE,
    0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF,
    0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFFFFFE, 0xFFFBFCFA, 0xFFF8F9F7, 0x76AFB0AE, 0x00A7ACAB, 0x00B9BEBD, 0x00B3B8B7, 0x009BA09F, 0x009A9F9E,
    0x00A3A8A7, 0x009CA1A0, 0x00909594, 0x009A9F9D, 0x00868B89, 0x00818684, 0x00898E8C, 0x007F8482, 0x007E8381, 0x008C918F, 0x00858A88, 0x00959A99, 0x00989D9C, 0x00818685, 0x00888D8C, 0x008F9493, 0x00797E7D, 0x00797E7D, 0x00838887, 0x00818684,
    0x008A8F8D, 0x00A0A5A3, 0x00858886, 0x008E918F, 0x008E8F8D, 0x00787977, 0x00838482, 0x00999E9C, 0x00A2A7A5, 0x00A6ABA9, 0x00969B99, 0x009BA09E, 0x00A9AEAC, 0x00A8ADAB, 0x00B2B7B5, 0xF0EDEDED, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFAF8FE, 0xFFFFFEFF, 0xFFFDFDFD, 0xFFFFFFFE, 0xFFFEFFFB, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFE, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFCFF, 0xFFFBFAFE, 0xFFFFFFFE, 0xFFFFFFF9, 0xFFFEFFF7, 0xFFFFFFF9, 0xFFFFFFFB, 0xFFFCFDF9, 0xFFFCFEF8, 0xFFFCFEF8, 0xFFFCFEF8, 0xFFFCFEF8, 0xFFFCFEF8,
    0xFFFCFEF8, 0xFFFCFEF8, 0xFFFCFEF8, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFA, 0xFFFFFFFA, 0xFFFFFFFA, 0xFFFFFFF9, 0xFFFFFFF9, 0xFFFFFFF9, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFF9,
    0xFFFFFFF9, 0xFFFFFFF9, 0xFFFFFFF9, 0xFFFFFFF9, 0xFFFFFFF9, 0xFFFFFFF9, 0xFFFFFFF9, 0xFFFFFFF9, 0xFFFDFFF7, 0xFFFBFEF5, 0xFFFCFFF6, 0xFFFEFFF8, 0xFFFFFFF9, 0xFFFFFFF9, 0xFFFFFFF9, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC,
    0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFEFF, 0xFFFFFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFA,
    0xFFFFFDFC, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFC, 0xFFFFFEFA, 0xFFFFFEFE, 0xFFFFFEFE, 0xFFFFFEFE, 0xFFFFFEFE, 0xFFFFFEFE, 0xFFFFFEFE, 0xFFFFFEFE, 0xFFFFFEFE, 0xFFFEFFFD, 0xFFFEFFFD, 0xFFFEFFFD, 0xFFFFFFFF, 0xFFFFFEFF,
    0xFFFFFEFF, 0xFFFFFEFF, 0xFFFCFBFF, 0xFFFDFCFF, 0xFFFDFCFF, 0xFFFDFCFF, 0xFFFDFCFF, 0xFFFDFCFF, 0xFFFDFCFF, 0xFFFDFCFF, 0xFFFDFCFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFEFDFF, 0xFFFDFCFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFFFEFF,
    0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF,
    0xFFFEFDFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFCFF, 0xFFFFFBFF, 0xFFFFFBFF, 0xFFFFFCFF, 0xFFFFFCFF, 0xFFFFFDFF,
    0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFEFCFF, 0xFFFDFBFF, 0xFFFDFBFF, 0xFFFCFAFF, 0xFFFFFEFF, 0xFFFCFBFD, 0xFFFCFBFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFF9F8FC, 0x5FA2A1A5, 0x00A1A6A5, 0x00B4B9B8, 0x00AEB3B2, 0x00A6ABAA, 0x00ACB1B0,
    0x00A4A9A8, 0x00A4A9A8, 0x00B9BEBD, 0x008E9391, 0x007F8482, 0x00747977, 0x00747977, 0x006F7472, 0x00747977, 0x00818684, 0x007B807E, 0x008E9391, 0x00838886, 0x00696E6C, 0x006D7270, 0x00828785, 0x007A7F7D, 0x00767B79, 0x00888D8B, 0x00989D9B,
    0x00878C8A, 0x00929795, 0x00838684, 0x00898C8A, 0x00868785, 0x00818280, 0x007B7C7A, 0x00787D7B, 0x008A8F8D, 0x009CA19F, 0x00959A98, 0x009EA3A1, 0x00A9AEAC, 0x00A0A5A3, 0x76ADB2B0, 0xECEDECF0, 0xFFFDFCFF, 0xFFFFFEFF, 0xFFFBFAFE, 0xFFFBFAFE,
    0xFFFEFDFF, 0xFFFCFBFF, 0xFFFDFCFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFEFAFF, 0xFFFFFDFF, 0xFFFAF9FB, 0xFFFFFFFE, 0xFFF8F9F7, 0xFFFDFCFE, 0xFFFCFAFF, 0xFFFFFBFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFBFF, 0xFFFCFBFF, 0xFFFFFFF9, 0xFFDEE4D1, 0xFFC2CBB0, 0xFFC9D2B7, 0xFFC2CBB1, 0xFFC2CAB3, 0xFFC1C9B2, 0xFFC0C8B1, 0xFFBFC7B0, 0xFFBEC6AF, 0xFFBEC6AF,
    0xFFBEC6AF, 0xFFBFC7B0, 0xFFBFC7B0, 0xFFC3C6B0, 0xFFC3C6B0, 0xFFC3C6B0, 0xFFC3C6B0, 0xFFC3C6B0, 0xFFC3C6B0, 0xFFC4C7B1, 0xFFC4C7B1, 0xFFCCD2C1, 0xFFCCD2C1, 0xFFCDD3C2, 0xFFCDD3C2, 0xFFCDD3C2, 0xFFCCD2C1, 0xFFCBD1C0, 0xFFCAD0BF, 0xFFCFD6C1,
    0xFFCFD6C1, 0xFFCFD6C1, 0xFFCFD6C1, 0xFFCFD6C1, 0xFFCFD6C1, 0xFFCFD6C1, 0xFFCFD6C1, 0xFFD3DAC5, 0xFFD1D8C3, 0xFFCFD6C1, 0xFFD1D8C3, 0xFFD5DCC7, 0xFFD9E0CB, 0xFFDAE1CC, 0xFFDAE1CC, 0xFFDEE2CF, 0xFFDEE2CF, 0xFFDEE2CF, 0xFFDEE2CF, 0xFFDEE2CF,
    0xFFDEE2CF, 0xFFDEE2CF, 0xFFDEE2CF, 0xFFDCE2CF, 0xFFDCE2CF, 0xFFDCE2CF, 0xFFDCE2CF, 0xFFDCE2CF, 0xFFDCE2CF, 0xFFDCE2CF, 0xFFDCE2CF, 0xFFE3E0DB, 0xFFE2E0D8, 0xFFE6E5DB, 0xFFEEEEE2, 0xFFF0F0E2, 0xFFEEEFDF, 0xFFEEF0DD, 0xFFF2F4E1, 0xFFF2F4E0,
    0xFFF0F0E2, 0xFFF0EEE6, 0xFFEAE6E5, 0xFFEAE6E5, 0xFFF0EEE6, 0xFFF0F0E2, 0xFFF2F4E0, 0xFFF1F2E2, 0xFFF1F2E2, 0xFFF1F2E2, 0xFFF1F2E2, 0xFFF1F2E2, 0xFFF1F2E2, 0xFFF1F2E2, 0xFFF1F2E2, 0xFFF6FCEB, 0xFFF6FCEB, 0xFFF4F9EA, 0xFFF2F6EA, 0xFFF4F8ED,
    0xFFF6F9F0, 0xFFF6F8F2, 0xFFF3F5EF, 0xFFF7FAF1, 0xFFF7FAF1, 0xFFF7FAF1, 0xFFF7FAF1, 0xFFF7FAF1, 0xFFF7FAF1, 0xFFF7FAF1, 0xFFF7FAF1, 0xFFF6F9F0, 0xFFF6F9F0, 0xFFF6F9F0, 0xFFF7FAF1, 0xFFF9FCF3, 0xFFFBFEF5, 0xFFFDFFF7, 0xFFFFFFF9, 0xFFFEFFF8,
    0xFFFEFFF8, 0xFFFEFFF8, 0xFFFEFFF8, 0xFFFEFFF8, 0xFFFEFFF8, 0xFFFEFFF8, 0xFFFEFFF8, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFAFCF6, 0xFFFAFCF6, 0xFFFAFCF6, 0xFFFBFDF7, 0xFFFCFEF8,
    0xFFFEFFFA, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFF9, 0xFFFFFFF9, 0xFFFFFFF9, 0xFFFFFFF9, 0xFFFFFFF9, 0xFFFFFFF9, 0xFFFFFFF9, 0xFFFFFFF9, 0xFFFFFFFC,
    0xFFFFFFFC, 0xFFFFFFFC, 0xFFFEFFFB, 0xFFFEFFFB, 0xFFFEFFFB, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFB, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFDFEFC, 0xFFFEFFFD, 0xFFFFFFFF, 0xFFF5F5F5, 0x6EAAA9AB, 0x009FA4A3, 0x00ABB0AF, 0x009DA2A1, 0x00989D9C, 0x00A3A8A7,
    0x009DA2A1, 0x00989D9C, 0x00A2A7A6, 0x00848883, 0x00818580, 0x00777B76, 0x00757974, 0x00747873, 0x00777B76, 0x007E827D, 0x00757974, 0x007A807B, 0x00787E79, 0x00656B66, 0x00606661, 0x00797F7A, 0x00787E79, 0x006F7570, 0x00888E89, 0x00A5ABA6,
    0x008C928D, 0x007C827D, 0x00757974, 0x00818580, 0x007D7E7A, 0x007E7F7B, 0x00797A76, 0x00747A75, 0x007E847F, 0x008F9590, 0x008F9590, 0x00A1A7A2, 0x00ABB1AC, 0x009BA19C, 0x6EA9AFAA, 0xFFF9FAF6, 0xFFFEFFFB, 0xFFFFFFFC, 0xFFFDFEFA, 0xFFFCFDF9,
    0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFEFFFB, 0xFFFDFEFA, 0xFFFDFEFA, 0xFFFDFEFA, 0xFFFDFEFA, 0xFFFDFEFA, 0xFFFFFFFE, 0xFFFCFEF8, 0xFFFCFFF5, 0xFFFFFFF7, 0xFFFCFFF6, 0xFFFFFFFF, 0xFFFCF9FF, 0xFFFFFAFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFAFF, 0xFFFDFCFE, 0xF0F7FCED, 0x2698A383, 0x004F5D33, 0x00506031, 0x00425223, 0x00404F23, 0x003B491F, 0x003A481E, 0x0038461C, 0x0036441A, 0x00354319,
    0x00354319, 0x0036441A, 0x0037451B, 0x0039421A, 0x0039421A, 0x003B441C, 0x003C451D, 0x003E471F, 0x003F4820, 0x00404921, 0x00414A22, 0x00465032, 0x00485234, 0x004C5638, 0x004F593B, 0x00515B3D, 0x00525C3E, 0x00525C3E, 0x00525C3E, 0x004E5938,
    0x004E5938, 0x004E5938, 0x004E5938, 0x004E5938, 0x004E5938, 0x004E5938, 0x004E5938, 0x004E5938, 0x004C5736, 0x004B5635, 0x004D5837, 0x00505B3A, 0x00525D3C, 0x00515C3B, 0x004F5A39, 0x00515B37, 0x00505A36, 0x00505A36, 0x004F5935, 0x004F5935,
    0x004E5834, 0x004E5834, 0x004E5834, 0x004E5939, 0x004E5939, 0x00505B3B, 0x00515C3C, 0x00535E3E, 0x00545F3F, 0x00556040, 0x00566141, 0x005A6140, 0x00515835, 0x004F5732, 0x00576038, 0x005F693E, 0x005D683A, 0x00596535, 0x00596533, 0x00576234,
    0x005D663E, 0x00656B4C, 0x005E6249, 0x005E6249, 0x00656B4C, 0x005D663E, 0x00576234, 0x005A6636, 0x005A6636, 0x005A6636, 0x005A6636, 0x005A6636, 0x005A6636, 0x005A6636, 0x005A6636, 0x005A693D, 0x00616F45, 0x00647249, 0x00616E48, 0x005E6948,
    0x00606B4B, 0x00646E50, 0x00677153, 0x005E6949, 0x005E6949, 0x005E6949, 0x005E6949, 0x005E6949, 0x005E6949, 0x005E6949, 0x005E6949, 0x005E6949, 0x005E6949, 0x005E6949, 0x00606B4B, 0x00626D4D, 0x00667151, 0x00697454, 0x006B7656, 0x00687353,
    0x00687353, 0x00687353, 0x00687353, 0x00687353, 0x00687353, 0x00687353, 0x00687353, 0x00687254, 0x00687254, 0x00687254, 0x00687254, 0x00687254, 0x00687254, 0x00687254, 0x00687254, 0x00677153, 0x00677153, 0x00687254, 0x00697355, 0x006B7557,
    0x006E785A, 0x00717B5D, 0x00737D5F, 0x00747E60, 0x00737D5F, 0x00737D5F, 0x00727C5E, 0x00727C5E, 0x00717B5D, 0x00707A5C, 0x00707A5C, 0x00727859, 0x0073795A, 0x00747A5B, 0x00747A5B, 0x0073795A, 0x00717758, 0x006F7556, 0x006E7455, 0x00677056,
    0x00677056, 0x00677056, 0x00697258, 0x006B745A, 0x006F785E, 0x00737C62, 0x00757E64, 0x00778066, 0x007A8369, 0x007D856E, 0x00747B66, 0x00787E6B, 0x00767C6B, 0x047C8271, 0x00787D6E, 0x00949998, 0x00959A99, 0x00828786, 0x00787D7C, 0x007D8281,
    0x00848988, 0x00828786, 0x006F7473, 0x00737772, 0x006F736E, 0x00626661, 0x005E625D, 0x005E625D, 0x00666A65, 0x00747873, 0x00727671, 0x00636A63, 0x006A716A, 0x00616861, 0x005C635C, 0x00666D66, 0x006B726B, 0x006F766F, 0x00798079, 0x00717772,
    0x006F7570, 0x00686E69, 0x00676B66, 0x00666A65, 0x005F605C, 0x00656662, 0x006F706C, 0x006F7570, 0x00696F6A, 0x00707671, 0x00737974, 0x008C928D, 0x009AA09B, 0x008D938E, 0x67A6ACA7, 0x3198A089, 0x13889079, 0x178B937C, 0x1E8F9780, 0x22919982,
    0x359BA38C, 0x3D9EA68F, 0x41A0A891, 0x39A0A98E, 0x3DA1AA8F, 0x41A4AD92, 0x45A5AE93, 0x45A6AF94, 0x45A6AF94, 0x45A5AE93, 0x41A4AD92, 0x4CAAB398, 0x48ABB696, 0x48AEBA96, 0x4CAFBB97, 0x76C0C9AE, 0xFFFFFFF5, 0xFFFFFFFF, 0xFFFDFAFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDF8FF, 0xFFFFFEFF, 0xF7FFFFF2, 0x13929F79, 0x00455722, 0x00566A2F, 0x0045591E, 0x003D5017, 0x003F521B, 0x003D5019, 0x00394C15, 0x00374A13, 0x00354811,
    0x00364912, 0x00384B14, 0x00394C15, 0x00404C1A, 0x00414D1B, 0x00434F1D, 0x0045511F, 0x00485422, 0x004B5725, 0x004D5927, 0x004E5A28, 0x0053603A, 0x0057643E, 0x005E6B45, 0x0064714B, 0x006A7751, 0x006E7B55, 0x006F7C56, 0x00707D57, 0x006F7D53,
    0x006F7D53, 0x006F7D53, 0x006F7D53, 0x006F7D53, 0x006F7D53, 0x006F7D53, 0x006F7D53, 0x006C7A50, 0x006A784E, 0x0069774D, 0x006A784E, 0x006B794F, 0x0069774D, 0x00647248, 0x00606E44, 0x005C693B, 0x005C693B, 0x005B683A, 0x005A6739, 0x00596638,
    0x00586537, 0x00586537, 0x00576436, 0x005C6A41, 0x005D6B42, 0x005F6D44, 0x00616F46, 0x00647249, 0x0067754C, 0x0069774E, 0x006A784F, 0x006D7C43, 0x0055642A, 0x00405013, 0x003F5011, 0x00455714, 0x00465914, 0x0044580F, 0x0043570E, 0x00425510,
    0x00556528, 0x006F7C48, 0x00727C51, 0x00727C51, 0x006F7C48, 0x00556528, 0x00425510, 0x00465A12, 0x00465A12, 0x00465A12, 0x00465A12, 0x00465A12, 0x00465A12, 0x00465A12, 0x00465A12, 0x00415716, 0x00556A2B, 0x00697E40, 0x006E8247, 0x006A7D46,
    0x00687A45, 0x006C7C4C, 0x006F7F4F, 0x00697B46, 0x00697B46, 0x00697B46, 0x00697B46, 0x00697B46, 0x00697B46, 0x00697B46, 0x00697B46, 0x006A7C47, 0x00697B46, 0x00677944, 0x00667843, 0x00657742, 0x00667843, 0x00677944, 0x00677944, 0x00657742,
    0x00657742, 0x00657742, 0x00657742, 0x00657742, 0x00657742, 0x00657742, 0x00657742, 0x00627340, 0x00627340, 0x00627340, 0x00627340, 0x00627340, 0x00627340, 0x00627340, 0x00627340, 0x00637441, 0x00627340, 0x0060713E, 0x005E6F3C, 0x005D6E3B,
    0x005E6F3C, 0x005F703D, 0x005F703D, 0x005D6E3B, 0x005D6E3B, 0x005B6C39, 0x005A6B38, 0x00586936, 0x00576835, 0x00556633, 0x00556633, 0x00576430, 0x00586531, 0x00576430, 0x0054612D, 0x004E5B27, 0x00475420, 0x003F4C18, 0x003B4814, 0x00314112,
    0x002F3F10, 0x002B3B0C, 0x00283809, 0x00263607, 0x00253506, 0x00263607, 0x00273708, 0x00253309, 0x00253309, 0x0029370E, 0x0026330D, 0x002D3915, 0x00222D0C, 0x00495434, 0x00959F81, 0x00A3A8A7, 0x00939897, 0x00858A89, 0x007E8382, 0x006C7170,
    0x00696E6D, 0x00747978, 0x00656A69, 0x00696D68, 0x00696D68, 0x00696D68, 0x006E726D, 0x00696D68, 0x00656964, 0x00696D68, 0x00616560, 0x00535A53, 0x00575E57, 0x005C635C, 0x005E655E, 0x004E554E, 0x00535A53, 0x00646B64, 0x004E554E, 0x005A605B,
    0x00595F5A, 0x005C625D, 0x00676B66, 0x00676B66, 0x00696A66, 0x00636460, 0x00646561, 0x00636964, 0x005E645F, 0x006A706B, 0x006D736E, 0x00838984, 0x00909691, 0x008F9590, 0x00B9BFBA, 0x0048562D, 0x00233108, 0x001F2D04, 0x0025330A, 0x00243209,
    0x0029370E, 0x002A380F, 0x002C3A11, 0x002D3D0D, 0x00324212, 0x00394919, 0x00415121, 0x00475727, 0x00495929, 0x004A5A2A, 0x004A5A2A, 0x00475727, 0x0051632E, 0x004E612A, 0x003D4F1A, 0x0068774B, 0xFFEAF3D8, 0xFFFFFFF8, 0xFFFCFCFC, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFB, 0xFFFFFCFF, 0xFFFAFFFF, 0x1B909C7E, 0x00535C29, 0x00595C2A, 0x00484F1C, 0x003E5013, 0x00374B1E, 0x0035491C, 0x00314419, 0x002E4017, 0x002C3E17,
    0x002B3B19, 0x002B3B19, 0x002B3A1A, 0x002A4218, 0x0030471A, 0x00374A19, 0x003C4B18, 0x00414E1A, 0x0047531F, 0x004A5622, 0x004A5624, 0x004C6529, 0x0056673C, 0x005F654C, 0x00686B55, 0x00717656, 0x006E764D, 0x0069724A, 0x006D7655, 0x006B7955,
    0x006B7955, 0x006B7955, 0x006B7A54, 0x006C7B55, 0x006C7C53, 0x006B7B52, 0x006B7B52, 0x0065794A, 0x0066774C, 0x0065734F, 0x00647151, 0x00657050, 0x00626E4A, 0x005F6B41, 0x005B683A, 0x0058652D, 0x0056632B, 0x00536028, 0x00536028, 0x00546129,
    0x0055622A, 0x00546129, 0x00536028, 0x00576629, 0x0058672E, 0x005B6735, 0x00606A3F, 0x00636E48, 0x0067714D, 0x00687352, 0x00697453, 0x00707D5D, 0x004A5933, 0x003B4C20, 0x003F521F, 0x00475B26, 0x00435625, 0x00536439, 0x0057673E, 0x00374C15,
    0x004C5F2E, 0x00708156, 0x0074825E, 0x006D7B57, 0x0071805A, 0x0048592D, 0x003B4D1E, 0x004A5C27, 0x00445621, 0x004A5C27, 0x00576934, 0x004D5F2A, 0x00465823, 0x0052642F, 0x00536530, 0x003B4F14, 0x005B6D38, 0x0077865A, 0x00727F59, 0x00707C58,
    0x0075815D, 0x006F7D53, 0x00748357, 0x0076825E, 0x00717D59, 0x00727F59, 0x006C7A51, 0x00738256, 0x006E7E4F, 0x00728252, 0x006F7F4F, 0x00728155, 0x00738256, 0x00728155, 0x006F7E52, 0x00707F53, 0x00748357, 0x00768559, 0x00748357, 0x00748258,
    0x00738157, 0x00717F55, 0x00707E54, 0x00707E54, 0x00717F55, 0x00728056, 0x00738157, 0x006C7B4F, 0x00708051, 0x00728253, 0x00718151, 0x0071824F, 0x00738550, 0x0071834E, 0x006D7F4A, 0x006F7F56, 0x00708057, 0x00728259, 0x0073835A, 0x00718158,
    0x006F7F56, 0x006E7E55, 0x006E7E55, 0x006E7C53, 0x006F7D54, 0x00707E55, 0x006F7D54, 0x006B7950, 0x0069774E, 0x0068764D, 0x0068764D, 0x0066744A, 0x0066744A, 0x00627046, 0x005A683F, 0x005F6D44, 0x005B6940, 0x0043502A, 0x003B4822, 0x0036411B,
    0x0039431F, 0x002F391B, 0x00394228, 0x00323C25, 0x00253016, 0x00323E22, 0x00324122, 0x0032401C, 0x00303E1C, 0x00323E20, 0x00374228, 0x0037402B, 0x00464E3D, 0x006F7667, 0x00B2B9AC, 0x00AEB5B8, 0x00949B9E, 0x007F8787, 0x00666E6E, 0x0058605F,
    0x005C6463, 0x005A6360, 0x005C6562, 0x005E655E, 0x00596059, 0x005C635C, 0x005F6560, 0x005D635E, 0x00606563, 0x00616664, 0x005B605E, 0x005E625C, 0x005E625C, 0x005F635D, 0x005B5F59, 0x00636761, 0x005A5E58, 0x005C605A, 0x0060645E, 0x0061665D,
    0x0062675E, 0x00676A61, 0x0063645A, 0x006A695F, 0x00706E63, 0x0069655A, 0x006F6C5E, 0x0062645E, 0x00666862, 0x006A6B67, 0x00717270, 0x007A797B, 0x00868589, 0x00A7A5AB, 0x00CECBD4, 0x0078846E, 0x0027341C, 0x001F2C12, 0x002C3B1C, 0x001E2E0C,
    0x0021330C, 0x002F4118, 0x00273A0F, 0x002E3D1D, 0x00334222, 0x00485737, 0x005F6E4E, 0x00697858, 0x00677656, 0x00657454, 0x00697858, 0x006A7554, 0x006A7751, 0x006D7B51, 0x00617044, 0x00616D49, 0xFFF3F9E6, 0xFFFFFFFE, 0xFFFFFCFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFBF9, 0xFFFFFAFF, 0xFFF9FBFF, 0x2A8C9685, 0x004C542F, 0x00525331, 0x003E4522, 0x002D4015, 0x001E3D1C, 0x001D3C1B, 0x001B3A1B, 0x001A381B, 0x0019361C,
    0x0019361C, 0x0019361D, 0x001A371E, 0x001E3116, 0x0027391C, 0x002E3D1D, 0x0034401C, 0x003A451D, 0x00404A20, 0x00444E23, 0x00495328, 0x004C642E, 0x0051653B, 0x0058654B, 0x00626D53, 0x00677553, 0x0063754E, 0x0062734E, 0x00667559, 0x00697753,
    0x00697753, 0x00697852, 0x00697852, 0x00697852, 0x00697950, 0x0068784F, 0x0068784F, 0x00647549, 0x0063734A, 0x0062704C, 0x00636E4D, 0x00616D49, 0x005F6B41, 0x00596737, 0x00556530, 0x00566226, 0x00535F23, 0x00505C20, 0x004F5B1F, 0x00505C20,
    0x00505C20, 0x004F5B1F, 0x004E5A1E, 0x00526124, 0x00536127, 0x0055622E, 0x00596535, 0x005D693F, 0x00626D45, 0x0065704A, 0x0065714D, 0x0064724E, 0x0046562D, 0x0037481C, 0x00506330, 0x00576A37, 0x003D501F, 0x004E5F33, 0x0048582F, 0x00384C17,
    0x004E6130, 0x006E7F54, 0x006E7C58, 0x00697753, 0x006F7E58, 0x0048592D, 0x003B4D1E, 0x00536334, 0x00586839, 0x005A6A3B, 0x00586839, 0x00506031, 0x00556536, 0x005C6C3D, 0x004A5A2B, 0x00384B14, 0x00586936, 0x00758458, 0x00738158, 0x00707D57,
    0x00748259, 0x006E7D51, 0x00728252, 0x00707E55, 0x006F7D54, 0x00758359, 0x00728056, 0x0077865A, 0x00718054, 0x00758556, 0x00758556, 0x00707F53, 0x00718054, 0x00707F53, 0x006D7C50, 0x006E7D51, 0x00718054, 0x00718054, 0x006E7D51, 0x006E7C52,
    0x006F7D53, 0x00707E54, 0x00717F55, 0x00728056, 0x00728056, 0x00717F55, 0x00707E54, 0x00748259, 0x00758359, 0x00738157, 0x00707E54, 0x00707E54, 0x00728056, 0x00728056, 0x00707E54, 0x006D7D54, 0x006E7E55, 0x006E7E55, 0x006D7D54, 0x006B7B52,
    0x006A7A51, 0x006A7A51, 0x00697950, 0x006E7C53, 0x006E7C53, 0x006D7B52, 0x006B7950, 0x0069774E, 0x0068764D, 0x0069774E, 0x006A784F, 0x00657349, 0x00657349, 0x00647248, 0x005D6B42, 0x005A683F, 0x004C5A31, 0x003C4923, 0x0045522C, 0x00767D62,
    0x008C927B, 0x00929683, 0x009A9E92, 0x00989C91, 0x008A9184, 0x00878E7F, 0x00747C6B, 0x008E9783, 0x0099A28E, 0x00878E7F, 0x006E7469, 0x00797D77, 0x00777B76, 0x007E8080, 0x00AAACAC, 0x00B5BAB9, 0x00A8ADAC, 0x00A7ACAA, 0x00A1A6A4, 0x009CA29D,
    0x009DA39E, 0x00969C97, 0x00949A95, 0x00949C92, 0x008D948D, 0x008D948D, 0x008D948D, 0x00888E89, 0x00868C87, 0x00858A88, 0x00808583, 0x00838988, 0x007E8483, 0x00828887, 0x00808685, 0x00858B8A, 0x00828887, 0x008A908F, 0x008D9392, 0x00808C8C,
    0x00808C8C, 0x00869090, 0x00838D8D, 0x00858D8D, 0x00808888, 0x00787D7E, 0x00808586, 0x00898B85, 0x008A8C86, 0x00838480, 0x00858682, 0x009A9B99, 0x00ADAEAC, 0x00B2B2B2, 0x00B1B1B1, 0x0098A096, 0x00838B80, 0x006F786B, 0x005B6555, 0x006D7766,
    0x0065705C, 0x00606B57, 0x006E7A64, 0x00747E6D, 0x0066705F, 0x007D8776, 0x00919B8A, 0x0086907F, 0x008A9483, 0x0096A08F, 0x008B9584, 0x00768160, 0x006C7953, 0x006A784E, 0x00657448, 0x006A7652, 0xFFF7FDEA, 0xFFFFFFFE, 0xFFFBF8FF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xF0FFFFEE, 0xFFFFFFFC, 0xF7F2FFFD, 0x1E80997F, 0x00344C24, 0x00314522, 0x0028401E, 0x001D3F16, 0x001B3916, 0x001B3916, 0x001A3815, 0x001A3716, 0x00193517,
    0x00193517, 0x00193518, 0x00193518, 0x00143013, 0x001A3618, 0x001C3715, 0x001D3811, 0x00253E12, 0x002C4513, 0x00344C16, 0x003E561C, 0x003D5525, 0x00435831, 0x00516443, 0x005B704F, 0x005C734D, 0x005B734B, 0x005A724F, 0x005B7154, 0x0064724E,
    0x0064734D, 0x0065744E, 0x0065744E, 0x0065754C, 0x0064744B, 0x0064754A, 0x0064754A, 0x00617148, 0x00617148, 0x00616E48, 0x005F6D44, 0x005B6A3E, 0x00576633, 0x00506128, 0x004C5E21, 0x004F5A1B, 0x004E591A, 0x004C5718, 0x004C5718, 0x004D5819,
    0x004F5A1B, 0x004F5A1B, 0x004F5A1B, 0x004B5A1C, 0x004C5B1E, 0x004F5D23, 0x00515F29, 0x00566230, 0x005A6739, 0x005F6B41, 0x00636F45, 0x0063724C, 0x0046572C, 0x002E4011, 0x00516433, 0x00586B3A, 0x00324415, 0x004B5C31, 0x0045552C, 0x002E4011,
    0x004B5C30, 0x006C7C53, 0x006D7C56, 0x006C7B55, 0x006D7D54, 0x00435429, 0x00304213, 0x005E6C42, 0x0056643A, 0x004C5A30, 0x0049572D, 0x00435127, 0x00455329, 0x004B592F, 0x003F4D23, 0x00364714, 0x00566637, 0x00738256, 0x00728056, 0x006F7D53,
    0x00738354, 0x0071824F, 0x0072844F, 0x00708051, 0x006F7F50, 0x00748455, 0x00738256, 0x00748357, 0x006D7C50, 0x00707F53, 0x00728155, 0x00718054, 0x00718054, 0x00707F53, 0x006E7D51, 0x006F7E52, 0x00718054, 0x00707F53, 0x006E7D51, 0x00717F55,
    0x00728056, 0x00738157, 0x00738157, 0x00728056, 0x00717F55, 0x00707E54, 0x00707E54, 0x00717F56, 0x00717F56, 0x006F7C56, 0x006E7B55, 0x006F7B57, 0x00737E5D, 0x00737E5D, 0x00707B5B, 0x00708057, 0x006F7F56, 0x006D7D54, 0x006C7C53, 0x006B7B52,
    0x006A7A51, 0x006A7A51, 0x006A7A51, 0x006D7B52, 0x006C7A51, 0x006A784F, 0x006A784F, 0x006A784F, 0x006A784F, 0x0069774E, 0x0069774E, 0x00657349, 0x00637147, 0x00637147, 0x00616F46, 0x005A683F, 0x00425027, 0x0033401A, 0x0048552F, 0x00555849,
    0x00636559, 0x0060605A, 0x00686967, 0x00757575, 0x00757575, 0x00686B69, 0x004B4F4A, 0x006C706B, 0x008E918F, 0x00B3B5B5, 0x00A5A6AA, 0x00AAAAB0, 0x00AAA9B3, 0x00B1AFBB, 0x00AFADB9, 0x0080827C, 0x007C7E78, 0x008A8C86, 0x0095988F, 0x00989B92,
    0x00999D92, 0x0095998E, 0x0093978C, 0x0082877E, 0x007D8279, 0x007E837A, 0x0081857F, 0x007F837D, 0x007D817C, 0x007E827D, 0x007E827D, 0x00808887, 0x00798180, 0x007F8786, 0x007F8786, 0x007F8786, 0x007E8685, 0x0088908F, 0x0088908F, 0x008B9491,
    0x00878F8E, 0x00878F8E, 0x00868E8D, 0x00858D8D, 0x007D8585, 0x00747C7C, 0x007A8184, 0x00A0A19D, 0x00AFB1AB, 0x00B3B5AF, 0x00ACAFA6, 0x00A9ACA3, 0x00A3A79C, 0x0091958A, 0x007F8378, 0x008D8F90, 0x00B0B2B3, 0x00BABCBD, 0x008C8E8F, 0x009A9B9F,
    0x0095969A, 0x009D9EA2, 0x00A6A7AB, 0x00575A58, 0x004C4F4D, 0x00686B69, 0x00828583, 0x00797C7A, 0x00848785, 0x00989B99, 0x008A8D8B, 0x0075805F, 0x006B7852, 0x0069774D, 0x0069784C, 0x006D7955, 0xFFF4FAE7, 0xFFFEFFFD, 0xFFFCF9FF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xF0F4FEEE, 0xCADAEAF0, 0xA0C4E4F1, 0x006C9892, 0x00305B4E, 0x00284D49, 0x00214B4A, 0x001B4E46, 0x00294D47, 0x002A4E48, 0x00294D47, 0x00294D47, 0x00284C46,
    0x00264A44, 0x00254844, 0x00244743, 0x001B4342, 0x001D4543, 0x0018413C, 0x00143F34, 0x00194331, 0x001B4429, 0x00163E1B, 0x00153C16, 0x003B4E23, 0x003B4F25, 0x00455A33, 0x004C643A, 0x00466135, 0x00486135, 0x0050663C, 0x0051663F, 0x005D6C46,
    0x005F6E48, 0x0061704A, 0x00617148, 0x00617148, 0x00617247, 0x00617247, 0x00617247, 0x00606F49, 0x00616F46, 0x005E6C42, 0x005B6B3C, 0x00576732, 0x00506227, 0x004B5C1C, 0x00475916, 0x004D5819, 0x004C5718, 0x004B5617, 0x004A5516, 0x004B5617,
    0x004C5718, 0x004D5819, 0x004E591A, 0x00495618, 0x00485719, 0x004A591B, 0x004D5C1F, 0x00505F25, 0x0056632F, 0x005B6939, 0x00606D41, 0x0063764B, 0x00405328, 0x00273B0E, 0x00425629, 0x00495D30, 0x002F4217, 0x004E6037, 0x00506239, 0x00314217,
    0x004E5E35, 0x006E7E55, 0x006E7E55, 0x00708057, 0x006F8055, 0x0047582D, 0x00304115, 0x004E5F33, 0x0046572B, 0x0046572B, 0x00546539, 0x0056673B, 0x00536438, 0x0058693D, 0x00546539, 0x00334418, 0x00546539, 0x006F8054, 0x00708155, 0x006C7E4F,
    0x00708352, 0x00728552, 0x00718550, 0x00728554, 0x00708352, 0x00708253, 0x006F8152, 0x006E7F53, 0x006B7C51, 0x006C7D52, 0x006F7F56, 0x00738256, 0x00728155, 0x00718054, 0x00707F53, 0x00728155, 0x00748357, 0x00748357, 0x00738256, 0x006E7F54,
    0x006E7F54, 0x006D7E53, 0x006C7D52, 0x006B7C51, 0x006C7D52, 0x006E7F54, 0x006F8055, 0x006D7F50, 0x006D7E52, 0x006E7F53, 0x006F7F56, 0x0072815B, 0x0073815D, 0x00717F5D, 0x006E7C5A, 0x00708057, 0x006F7F56, 0x006E7E55, 0x006E7E55, 0x006E7E55,
    0x006E7E55, 0x006D7D54, 0x006C7C53, 0x006D7B52, 0x006C7A51, 0x006C7A51, 0x006C7A51, 0x006D7B52, 0x006C7A51, 0x0069774E, 0x0066744B, 0x0067754B, 0x00616F45, 0x00606E44, 0x00637148, 0x00616F46, 0x0045532A, 0x002F3C16, 0x00414E28, 0x00444436,
    0x00535347, 0x0052524C, 0x00565453, 0x00575757, 0x00565755, 0x005B5C58, 0x00575B56, 0x00444444, 0x00585759, 0x00C9C8CA, 0x00F0EEF4, 0x00EBE8F1, 0x00F6F2FD, 0x00FBF7FF, 0x00A7A3AF, 0x00434137, 0x003C3A2F, 0x00403E33, 0x00454338, 0x00424133,
    0x003D3C2E, 0x003A3A2A, 0x00393929, 0x0052564B, 0x004E5247, 0x004F5348, 0x0052554C, 0x004F5249, 0x004B4D47, 0x004A4C46, 0x004D4F49, 0x004E504A, 0x00484A44, 0x004D4F49, 0x004F514B, 0x004A4C46, 0x00474943, 0x004C4E48, 0x004A4C46, 0x00505042,
    0x004B4B3F, 0x004A4A3E, 0x004C4C40, 0x00515046, 0x00525147, 0x00504F45, 0x00535149, 0x00504F4B, 0x0043433D, 0x0035362D, 0x0034352B, 0x00393C2D, 0x003B3E2E, 0x00363A27, 0x00333823, 0x003A393B, 0x006B6A6C, 0x00CDCCD0, 0x00D7D5DB, 0x00E4E1EA,
    0x00E3DFEA, 0x00D0CCD8, 0x006E6A76, 0x00454545, 0x004A4A4A, 0x004F4F4F, 0x00535353, 0x004D4D4D, 0x00474747, 0x00474747, 0x00414141, 0x00636E4D, 0x0066734D, 0x006B794F, 0x006A794D, 0x0066724E, 0xFFECF2DF, 0xFFFEFFFD, 0xFFFFFCFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x81B3C5E4, 0x00819CD4, 0x0076A1E4, 0x00649CD3, 0x00649BCE, 0x006F9EDB, 0x006EA0E2, 0x0066A0DB, 0x005F9CD4, 0x005F9CD4, 0x00609ED4, 0x00609ED4, 0x00609ED4,
    0x005E9CD2, 0x005D9BD1, 0x005C9AD0, 0x006D9AD7, 0x006A99D6, 0x006698D4, 0x006096CD, 0x006195C4, 0x005889AF, 0x003C6B87, 0x00214E63, 0x00314020, 0x002A3B19, 0x0029401A, 0x002A431D, 0x00274119, 0x00344B1F, 0x004A5D2C, 0x00576731, 0x00576640,
    0x005A6943, 0x005D6D44, 0x005F6F46, 0x005F7045, 0x005F7045, 0x00607145, 0x00617246, 0x00616D49, 0x005F6D44, 0x005C6C3D, 0x00596934, 0x00526429, 0x004D5E1F, 0x00465717, 0x00435512, 0x004A5719, 0x00495618, 0x00485517, 0x00465315, 0x00455214,
    0x00455214, 0x00465315, 0x00475416, 0x00475319, 0x00495519, 0x004B5919, 0x004B5B1B, 0x004E5D1F, 0x00536229, 0x005B6735, 0x00606B3D, 0x005F7247, 0x003A4C23, 0x002A3C15, 0x002D3E19, 0x0030401E, 0x00263614, 0x00354523, 0x00384826, 0x002C3A18,
    0x00475531, 0x006C7B55, 0x00708057, 0x00738459, 0x006D7E53, 0x0047582D, 0x0028390E, 0x00314314, 0x00344617, 0x00344617, 0x00394B1C, 0x00364819, 0x00344617, 0x00384A1B, 0x00324415, 0x002F3F16, 0x00506136, 0x006C7D51, 0x00718256, 0x006C7D51,
    0x006E7F53, 0x00718256, 0x006D7E52, 0x00728358, 0x00708156, 0x006E7F54, 0x006F8055, 0x006F8055, 0x00718158, 0x006F7F56, 0x006E7E55, 0x00728155, 0x00707F53, 0x006E7D51, 0x006D7C50, 0x006D7C50, 0x006D7C50, 0x006F7E52, 0x00718054, 0x006C7D52,
    0x006E7F54, 0x00708156, 0x00708156, 0x00708156, 0x006F8055, 0x00718257, 0x00728358, 0x006D804D, 0x006B7E4B, 0x006B7E4D, 0x006D7F50, 0x006F8152, 0x006F8054, 0x006F8054, 0x006E7F54, 0x006C7C53, 0x006D7D54, 0x006E7E55, 0x00708057, 0x00708057,
    0x00708057, 0x006F7F56, 0x006F7F56, 0x00707E55, 0x006E7C53, 0x006D7B52, 0x006D7B52, 0x006D7B52, 0x006C7A51, 0x006A784F, 0x0068764D, 0x0069774D, 0x00657349, 0x00616F45, 0x00627047, 0x00637148, 0x0049572E, 0x002F3C16, 0x003D4A24, 0x0043472E,
    0x00585A46, 0x005E5E50, 0x005B5C52, 0x005B5C53, 0x00575B50, 0x005B5F53, 0x005E6354, 0x00656761, 0x00646660, 0x00D6D8D2, 0x00FFFFFC, 0x00EFF0EE, 0x00FBFCFA, 0x00FFFFFF, 0x00A6A6A6, 0x004C4B3D, 0x00454436, 0x00444335, 0x00474737, 0x00434333,
    0x0040402E, 0x00434331, 0x0041412F, 0x005A5E52, 0x005B5F53, 0x005D6155, 0x005F6358, 0x005F6358, 0x005A5D54, 0x005A5D54, 0x005E6158, 0x00646355, 0x00626153, 0x00605F51, 0x00636254, 0x00626153, 0x00605F51, 0x005F5E50, 0x00616052, 0x00515752,
    0x00545B54, 0x00595D57, 0x005E605A, 0x005F6057, 0x00606158, 0x0067665C, 0x0068675D, 0x0063635D, 0x0047483F, 0x00323329, 0x00323428, 0x003A3D2D, 0x003B3F2C, 0x00393E29, 0x00383E27, 0x004A4D44, 0x007A7C76, 0x00F8FAF4, 0x00FFFFFC, 0x00FAFBF9,
    0x00FFFFFF, 0x00FFFEFF, 0x00888789, 0x0052554C, 0x0062655C, 0x00595C53, 0x0053564D, 0x0055584F, 0x004F5249, 0x004E5148, 0x004F5249, 0x00576241, 0x0067744E, 0x006F7D53, 0x006A794D, 0x00616D49, 0xFFE7EDDA, 0xFFFFFFFE, 0xFFFFFCFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x76AED0FB, 0x006D97DC, 0x005995E9, 0x005AA1EB, 0x0062A8EE, 0x0065A1F3, 0x0063A0F6, 0x00599DEA, 0x005897E7, 0x005998E8, 0x005A9AE8, 0x005C9CEA, 0x005D9EE9,
    0x005D9EE9, 0x005D9EE8, 0x005D9EE8, 0x005E97E2, 0x005995E1, 0x005999E7, 0x005B9DEB, 0x005FA1E8, 0x0063A0DE, 0x004780B3, 0x001B4F7D, 0x001B3027, 0x00142C20, 0x00112E1E, 0x0010301F, 0x0015311E, 0x00243A1D, 0x003C4E1F, 0x004D5E1F, 0x0055653C,
    0x00596940, 0x005D6D44, 0x005F7045, 0x005E6F44, 0x005E6F43, 0x005F7044, 0x00607145, 0x00606D47, 0x00606C42, 0x005C6A3A, 0x00566630, 0x00505F25, 0x0049591C, 0x00455417, 0x00435117, 0x003F4C18, 0x003F4C18, 0x003F4C18, 0x003E4B17, 0x003E4B17,
    0x003F4C18, 0x00414E1A, 0x00424F1B, 0x00484F1C, 0x0048541A, 0x004A5719, 0x004C5A18, 0x004C5C1C, 0x00526026, 0x00586432, 0x005D673C, 0x005C6E45, 0x003A4B26, 0x00364525, 0x00263418, 0x0026331B, 0x002A371D, 0x002B391D, 0x002A381C, 0x003A4628,
    0x00475434, 0x00697852, 0x006E7F54, 0x006E7F53, 0x006A7B4F, 0x00526338, 0x00324219, 0x0032441B, 0x002F4118, 0x002C3E15, 0x0034461D, 0x0031431A, 0x00283A11, 0x002F4118, 0x0035471E, 0x003A4C23, 0x00596B42, 0x00708358, 0x00718558, 0x00677A4F,
    0x00657651, 0x006A7959, 0x00627054, 0x00677656, 0x006C7B5B, 0x006A7A58, 0x006A7B56, 0x00697B54, 0x0071835A, 0x006D7F56, 0x00687B50, 0x006D7C50, 0x006B7A4E, 0x0069784C, 0x00657448, 0x005E6D41, 0x0059683C, 0x005A693D, 0x005D6C40, 0x005A6D42,
    0x005F7247, 0x0065784D, 0x0066794E, 0x0062754A, 0x005B6E43, 0x0055683D, 0x0052653A, 0x00516439, 0x004F6237, 0x004D6134, 0x004F6336, 0x00536738, 0x00576B3C, 0x005F7344, 0x00657A49, 0x0063734A, 0x0066764D, 0x006A7A51, 0x006B7B52, 0x006B7B52,
    0x006A7A51, 0x006A7A51, 0x006B7B52, 0x00728057, 0x00707E55, 0x006D7B52, 0x006B7950, 0x006B7950, 0x006C7A51, 0x006D7B52, 0x006D7B52, 0x006A784E, 0x006B794F, 0x00657349, 0x00606E45, 0x00606E45, 0x0047552C, 0x00313E18, 0x0043502A, 0x004B4F32,
    0x005C5F45, 0x00565844, 0x004B4C3C, 0x00515445, 0x005B5E4F, 0x00595C4C, 0x00515744, 0x005C5F50, 0x005B5E4F, 0x00929488, 0x009C9E92, 0x0094968A, 0x00999A90, 0x00A5A69C, 0x00828379, 0x00656456, 0x00636254, 0x00616151, 0x00636353, 0x005F5F4F,
    0x005A5A48, 0x00595947, 0x004F4F3D, 0x00404334, 0x00494C3D, 0x004F5145, 0x00535549, 0x0057594D, 0x0058594F, 0x00595A50, 0x005E5F55, 0x005A594F, 0x005F5E54, 0x00545349, 0x0057564C, 0x00616056, 0x00616056, 0x0059584E, 0x00646359, 0x005C7687,
    0x00647C8E, 0x006C8190, 0x006C7E89, 0x005C6971, 0x004D585C, 0x00515959, 0x00535859, 0x00545349, 0x0056554B, 0x005D5D51, 0x00616155, 0x005F5F51, 0x005F5F51, 0x00606151, 0x005D5E4E, 0x00626556, 0x0076796A, 0x00AEB1A2, 0x00ADB0A1, 0x00AFB2A3,
    0x00B5B8A9, 0x00B1B4A5, 0x0056584C, 0x00515444, 0x00636656, 0x00606353, 0x005C5F4F, 0x00595C4C, 0x00555848, 0x00595C4C, 0x004E5141, 0x005B6645, 0x006C7953, 0x00717F55, 0x006B7A4E, 0x00636F4B, 0xFFE9EFDC, 0xFFFFFFFE, 0xFFFEFBFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x63A4D2EA, 0x006AA0D5, 0x00569CE2, 0x0052A5E3, 0x0055A5E0, 0x005BA0E5, 0x0069A9F0, 0x0060A5E4, 0x006198E1, 0x00629AE1, 0x00639BE2, 0x00659EE3, 0x0066A0E2,
    0x0067A1E2, 0x0068A3E1, 0x0068A3E1, 0x0065A7DC, 0x00599DD8, 0x00579FDF, 0x00529EE0, 0x00519CDA, 0x0060A3DA, 0x004B88B4, 0x00154C71, 0x00274B63, 0x00264E61, 0x00224E5F, 0x00244F60, 0x002B4E5C, 0x00324F4C, 0x003F5735, 0x004C642A, 0x0056663D,
    0x005A6A41, 0x005F7045, 0x00607146, 0x005E6F43, 0x005D6E42, 0x005D6E42, 0x005F7044, 0x00606B43, 0x005E6B3F, 0x00596835, 0x0054632A, 0x004C5B22, 0x0047541E, 0x00444F1D, 0x00434D1E, 0x0038461C, 0x0039471D, 0x0039471D, 0x0038461C, 0x0037451B,
    0x0037451B, 0x0039471D, 0x003C4A20, 0x00464C1D, 0x00484F1C, 0x00495519, 0x004A5816, 0x004A5B18, 0x004E5C22, 0x00555F30, 0x00596339, 0x00546641, 0x003D4E2D, 0x0046543C, 0x003C4836, 0x00434E3E, 0x00515C4C, 0x00515D49, 0x004C5943, 0x005F6952,
    0x00566244, 0x006A7854, 0x00697A4E, 0x0067794A, 0x006C7E4F, 0x006B7C51, 0x0053633A, 0x004A5541, 0x00495440, 0x004F5A46, 0x0065705C, 0x0065705C, 0x00505B47, 0x004C5743, 0x00515C48, 0x00576940, 0x006A7C53, 0x006D8055, 0x005D7045, 0x0043542F,
    0x003A482C, 0x00414C38, 0x00384134, 0x0036402F, 0x0045503C, 0x0048553D, 0x004B593D, 0x004D5D3B, 0x0063754E, 0x006A7D52, 0x006B7F52, 0x006A794D, 0x0068774B, 0x00657448, 0x005C6B3F, 0x004E5D31, 0x00404F23, 0x003C4B1F, 0x003E4D21, 0x004C5F34,
    0x0053663B, 0x005B6E43, 0x005B6E43, 0x0054673C, 0x00495C31, 0x003F5227, 0x00394C21, 0x002C3822, 0x002A371F, 0x0029361C, 0x002C3B1C, 0x002F3F1D, 0x00354720, 0x00405328, 0x004B5E33, 0x0065754C, 0x00697950, 0x006D7D54, 0x006D7D54, 0x006B7B52,
    0x006A7A51, 0x006C7C53, 0x006F7F56, 0x006B7950, 0x006C7A51, 0x006D7B52, 0x006D7B52, 0x006D7B52, 0x006D7B52, 0x006D7B52, 0x006E7C53, 0x006A784E, 0x006B794F, 0x0066744A, 0x00627047, 0x00616F46, 0x0045532A, 0x002F3C16, 0x0045522C, 0x0044472E,
    0x00595B45, 0x00585848, 0x0046463A, 0x0045443A, 0x004A4B41, 0x00505246, 0x00595C4D, 0x00585A4E, 0x00515347, 0x005B5D51, 0x005F6155, 0x0066685C, 0x006A6C60, 0x00626458, 0x00585A4E, 0x005E5E52, 0x00606054, 0x005C5C4E, 0x005D5D4F, 0x00575848,
    0x00525343, 0x004F5040, 0x003E402D, 0x00414232, 0x004F4F41, 0x00555547, 0x00545446, 0x0057574B, 0x0058584C, 0x0057564C, 0x0058574D, 0x00546062, 0x00647072, 0x00525E60, 0x00556163, 0x006A7678, 0x00667274, 0x00505C5E, 0x00626E70, 0x006D93B3,
    0x006F91AF, 0x007492AB, 0x007D95A7, 0x006C7C88, 0x00515C60, 0x00525758, 0x00555856, 0x00555547, 0x00535345, 0x00525246, 0x00505044, 0x00504F45, 0x0059584E, 0x005E5C54, 0x005A5850, 0x004E4E42, 0x005F5F53, 0x006C6C5E, 0x00616252, 0x0060624F,
    0x005B5D49, 0x005D604A, 0x003E412B, 0x00454636, 0x005D5E4E, 0x00606151, 0x00626353, 0x005E5F4F, 0x005B5C4C, 0x00606151, 0x004D4E3E, 0x00616C4B, 0x006D7A54, 0x006F7D53, 0x006D7C50, 0x0066724E, 0xFFE8EEDB, 0xFFFFFFFE, 0xFFFEFBFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x5FA1CAEA, 0x006EA2DE, 0x005A9EEB, 0x0053A1E8, 0x0057A0E4, 0x00629EEA, 0x006EA6F5, 0x005C97DC, 0x005699E8, 0x00569AE7, 0x00579BE6, 0x00579CE5, 0x00589EE4,
    0x00589FE3, 0x0059A0E3, 0x0059A0E3, 0x0065A0D8, 0x005998D5, 0x00589DE2, 0x00539AE4, 0x005094DD, 0x00629FE1, 0x005187BE, 0x00144474, 0x00104171, 0x00134873, 0x00114972, 0x00154977, 0x00224E77, 0x002D4F5F, 0x00375641, 0x00466532, 0x0058683F,
    0x005C6C43, 0x00617247, 0x00617247, 0x005E6F43, 0x005C6D41, 0x005C6D41, 0x005D6F40, 0x005E6941, 0x005C693B, 0x00576732, 0x00516027, 0x0049581F, 0x0045511D, 0x00434D1F, 0x00434B23, 0x003E4F2A, 0x003D4E29, 0x003B4C27, 0x00364722, 0x0031421D,
    0x002E3F1A, 0x002E3F1A, 0x002F401B, 0x0044481E, 0x00474D1C, 0x004A531A, 0x00495715, 0x004A5818, 0x004B591F, 0x00525C2D, 0x00575F37, 0x004C5D3B, 0x00425135, 0x00535F4B, 0x00545E51, 0x0060695F, 0x00697367, 0x00677164, 0x00596553, 0x005E6752,
    0x00505C40, 0x00687652, 0x006D7E52, 0x00697B4C, 0x006A7C4D, 0x006C7D52, 0x00506037, 0x00535856, 0x00606563, 0x00676C6A, 0x00707573, 0x00727775, 0x00696E6C, 0x005F6462, 0x00515654, 0x005F7148, 0x006F8257, 0x006D8055, 0x005F7148, 0x004D5C3C,
    0x00535F49, 0x006C746A, 0x006C716F, 0x00626A60, 0x0071796E, 0x006A7463, 0x005C6951, 0x004F5E3F, 0x0062744D, 0x00697C51, 0x006C8051, 0x006A794D, 0x0069784C, 0x00657448, 0x0059683C, 0x00445327, 0x00303F13, 0x0027360A, 0x0028370B, 0x00273A0F,
    0x002E4116, 0x0036491E, 0x00384B20, 0x0032451A, 0x00293C11, 0x00213409, 0x001D3005, 0x001B201E, 0x00192019, 0x00192116, 0x001B2514, 0x001B2810, 0x001C2A0E, 0x00243412, 0x002E3F1A, 0x00405027, 0x0044542B, 0x0047572E, 0x0046562D, 0x00425229,
    0x00415128, 0x0045552C, 0x00495930, 0x00616F46, 0x0067754C, 0x006D7B52, 0x00717F56, 0x00717F56, 0x006E7C53, 0x006C7A51, 0x006A784F, 0x0069774D, 0x0067754B, 0x00637147, 0x0065734A, 0x0067754C, 0x0047552C, 0x002B3812, 0x00424F29, 0x00474735,
    0x00555446, 0x005B594F, 0x00595651, 0x005E5B57, 0x00575652, 0x0051514B, 0x005C5D54, 0x0054554C, 0x00484940, 0x004F5047, 0x0053544B, 0x0047483F, 0x004F5047, 0x00525349, 0x0053544A, 0x005D5F53, 0x00606256, 0x00595B4F, 0x00575A4B, 0x00535647,
    0x00535647, 0x00525545, 0x003E4131, 0x00474838, 0x00585949, 0x005D5D4F, 0x00575749, 0x00575749, 0x0057574B, 0x00535347, 0x00525246, 0x004D6271, 0x00667B8A, 0x00516675, 0x00546978, 0x006F8493, 0x00647988, 0x003F5463, 0x00536877, 0x00557795,
    0x004A6883, 0x004F687C, 0x006B7D88, 0x00697275, 0x0053554F, 0x00585449, 0x005E5748, 0x00525343, 0x004F5040, 0x00545446, 0x0058574D, 0x0057554D, 0x00595651, 0x005B5854, 0x00575352, 0x0057544F, 0x00504E46, 0x0049483E, 0x004A4A3C, 0x004B4D3A,
    0x00464933, 0x00464A31, 0x0032371C, 0x00404034, 0x005E5E52, 0x005A5A4E, 0x0058584C, 0x005A5A4E, 0x0057574B, 0x005A5A4E, 0x004E4E42, 0x00606B4A, 0x006A7751, 0x006C7A50, 0x006E7D51, 0x0067734F, 0xFFE4EAD7, 0xFFFEFFFD, 0xFFFFFCFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x6EA9CBE9, 0x00659ED6, 0x0059A1EE, 0x005DA2EB, 0x005EA3E8, 0x005AA5F1, 0x005AA5F1, 0x00579DE0, 0x005C9CE3, 0x005D9DE4, 0x0060A0E7, 0x0060A0E7, 0x005F9FE6,
    0x005E9EE5, 0x005E9EE5, 0x005E9EE5, 0x0061A0E4, 0x00599ADE, 0x00589BE0, 0x005A9DE2, 0x00599ADE, 0x0064A3E0, 0x004D8AC2, 0x00094279, 0x001C4064, 0x00224567, 0x00193E60, 0x00113E64, 0x0017496D, 0x00204B5A, 0x00395440, 0x005D6939, 0x005A6D4C,
    0x00576B41, 0x005D703F, 0x00657244, 0x00626C48, 0x00626B4A, 0x005E6F44, 0x00566C38, 0x00576E38, 0x00596A37, 0x00515C2E, 0x004F572F, 0x00525535, 0x0052553B, 0x00464933, 0x00595E49, 0x006C6554, 0x00706958, 0x00666250, 0x005D5B49, 0x003A3A28,
    0x00424431, 0x004E523F, 0x003C402D, 0x003C441F, 0x003E481D, 0x00415017, 0x00465616, 0x00495919, 0x004F5B1F, 0x00545D2A, 0x00575E31, 0x00506435, 0x004D5A40, 0x008C918F, 0x009B9EA6, 0x00989CA1, 0x009DA5A4, 0x009DA5A5, 0x009BA2A5, 0x008F9689,
    0x00556145, 0x006A7B4F, 0x00647746, 0x00697A4F, 0x006B7955, 0x0066754F, 0x005C6D42, 0x007F8979, 0x00A9AEB1, 0x009DA4AD, 0x00A4B0B0, 0x00A6B3B1, 0x009CA4AB, 0x00A0A6A5, 0x00717C68, 0x005E6E4C, 0x006B7B59, 0x006E7D5D, 0x00556347, 0x005F6A56,
    0x006A7268, 0x007C8180, 0x00787B80, 0x006C6B75, 0x008D8F90, 0x00656B60, 0x00353F28, 0x00505D3D, 0x006B7955, 0x0065734F, 0x006B7955, 0x006D7A4E, 0x00697648, 0x00617141, 0x005D703F, 0x003D5025, 0x001C2D0B, 0x001D2B13, 0x001C2A18, 0x00232819,
    0x001E2217, 0x001C1D19, 0x001C1C1C, 0x001D1D1D, 0x001D1E1A, 0x001C2015, 0x00202516, 0x0017240C, 0x0017230D, 0x001C2615, 0x001C2616, 0x001B2515, 0x001B2514, 0x00192410, 0x001D2913, 0x00232B1A, 0x00202A1D, 0x002C3A34, 0x003C4F52, 0x00657984,
    0x006E8190, 0x00657887, 0x00617483, 0x00617265, 0x0030452C, 0x002C451F, 0x00384F29, 0x00344929, 0x0036492E, 0x00445736, 0x005B7246, 0x0067784D, 0x0067784C, 0x00647647, 0x00647647, 0x0064754A, 0x0044532D, 0x00293616, 0x003E4A2E, 0x003A3F2A,
    0x00515542, 0x005D614E, 0x005A5D4D, 0x005B5E4F, 0x005C5E52, 0x005B5C52, 0x005C5D53, 0x00545442, 0x00484836, 0x00484836, 0x004A4A38, 0x00424230, 0x0041412F, 0x00494937, 0x004D4D3B, 0x00555940, 0x00575945, 0x005A5A4E, 0x0057554D, 0x00524F4A,
    0x0054524A, 0x004F4F41, 0x0040422F, 0x00474739, 0x005A5A4E, 0x0057574B, 0x0059594D, 0x00525147, 0x0055544A, 0x00525048, 0x00514F47, 0x00465D4F, 0x005F8290, 0x00495A63, 0x0050525C, 0x007A8CAB, 0x00727C8D, 0x0056544C, 0x0057676D, 0x0064808B,
    0x0055737E, 0x0054747F, 0x004D6C75, 0x00697D82, 0x00555A5B, 0x005E534F, 0x0067544D, 0x00525244, 0x00515145, 0x00545349, 0x00545349, 0x00515046, 0x0057574B, 0x005B5C4C, 0x00555744, 0x004B4C38, 0x00474735, 0x00504F41, 0x00545247, 0x004C4A3F,
    0x004B4A3C, 0x00464634, 0x00363723, 0x0042432F, 0x005B5B4B, 0x00555549, 0x00585550, 0x0056534F, 0x00595854, 0x0055554F, 0x004D4E45, 0x00606D47, 0x006F7D54, 0x00738157, 0x00707D57, 0x00677252, 0xFFE7EDDA, 0xFFFFFFFC, 0xFFFFFEFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x6EA9CBE9, 0x00669ED9, 0x0059A1EE, 0x005DA2EB, 0x005FA4EA, 0x005AA5F1, 0x0059A5F1, 0x00579CE1, 0x005C9CE3, 0x005E9EE5, 0x0060A0E7, 0x0060A0E7, 0x005F9FE6,
    0x005E9EE5, 0x005E9EE5, 0x005E9EE5, 0x0064A3E7, 0x005E9FE4, 0x005A9DE2, 0x005B9EE3, 0x00599ADE, 0x005F9EDB, 0x004985C0, 0x000F487F, 0x000B3969, 0x000B3864, 0x000C3762, 0x0015426D, 0x001C4D6D, 0x001E454E, 0x00364C33, 0x005F6835, 0x00526445,
    0x00566942, 0x00617344, 0x0069764A, 0x00636C4B, 0x005D6546, 0x005D6D44, 0x00607544, 0x00576C3B, 0x00586839, 0x00555F35, 0x004D5330, 0x00686A4D, 0x004E503A, 0x00252714, 0x00565949, 0x00A09988, 0x00938C7B, 0x009B9785, 0x006E6C5A, 0x00262614,
    0x004A4C39, 0x00676B58, 0x00494D3A, 0x003C4223, 0x003F4722, 0x00424E1C, 0x00445316, 0x00465517, 0x004C5B1E, 0x00555F2A, 0x00596230, 0x004D6132, 0x00445137, 0x00969B99, 0x00C2C5CD, 0x00C2C7CA, 0x00B3B9B8, 0x00A9B1B0, 0x00B1B8BB, 0x00A2A99C,
    0x00546044, 0x0068794D, 0x006D804F, 0x006B7C51, 0x006B7955, 0x00677650, 0x00495A2F, 0x00808A7A, 0x00CFD4D7, 0x00D6DDE6, 0x00D4E0E0, 0x00D4E1DF, 0x00D2DAE1, 0x00C2C8C7, 0x006B7662, 0x00607348, 0x006B7E53, 0x006E8156, 0x005D6F48, 0x00617050,
    0x00748169, 0x007C8676, 0x00687065, 0x005B6359, 0x006B7565, 0x004F5C42, 0x002C3C1A, 0x0041532A, 0x0065784D, 0x006B7E53, 0x0064764D, 0x0064744B, 0x0065764B, 0x005F7045, 0x0056673C, 0x00475630, 0x003A462A, 0x0039422E, 0x00383F32, 0x00373C2D,
    0x001F2317, 0x00171913, 0x001C1D1B, 0x001A1B19, 0x001A1C16, 0x00272B1F, 0x0034392A, 0x003F4730, 0x00373E29, 0x00363C2B, 0x0034392A, 0x00353A2B, 0x00353B2A, 0x002F3621, 0x00303821, 0x003F4534, 0x003E463B, 0x006E7976, 0x008E9DA0, 0x009BACB5,
    0x0098A9B6, 0x0098A7B7, 0x0098A7B7, 0x0094A0A2, 0x006D7C74, 0x005F725D, 0x005C6D58, 0x00505E52, 0x00515F54, 0x00576553, 0x0056674C, 0x006A7B50, 0x006A7B4F, 0x0067784C, 0x0068794D, 0x0068794E, 0x00475531, 0x002B3818, 0x00404C30, 0x003F412E,
    0x00565845, 0x005E5F4F, 0x00565648, 0x0057574B, 0x005F5E54, 0x00615F57, 0x005F5D55, 0x004F4E40, 0x004D4C3E, 0x00504F41, 0x00545345, 0x00525143, 0x00525143, 0x00535244, 0x00525143, 0x00575945, 0x00555646, 0x0055544A, 0x00524F4A, 0x00524F4A,
    0x0057564C, 0x00535345, 0x00454734, 0x003E3E30, 0x00525244, 0x00515143, 0x0058584C, 0x0056564A, 0x005A594F, 0x0057564C, 0x0055544A, 0x0054655A, 0x006A8691, 0x00576669, 0x00505455, 0x00627086, 0x005B646E, 0x0058564C, 0x00667276, 0x006A8FB1,
    0x005B81A3, 0x005D87A4, 0x00628AA3, 0x006C8D9D, 0x00495E66, 0x00464E4E, 0x00555352, 0x00545448, 0x00505044, 0x00505044, 0x00505044, 0x00505044, 0x00545446, 0x00565747, 0x0050523F, 0x00585945, 0x00575745, 0x005C5B4D, 0x005B594E, 0x00545247,
    0x00555446, 0x004F4F3D, 0x003A3B27, 0x00464733, 0x005E5E4E, 0x0059594D, 0x0059574F, 0x0053504B, 0x00575751, 0x0054554C, 0x004E4F45, 0x005F6C46, 0x006D7B52, 0x00717F55, 0x006F7C56, 0x00667151, 0xFFE7EDDA, 0xFFFFFFFC, 0xFFFFFEFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x6EAACCEA, 0x00669ED9, 0x0059A1EF, 0x005BA2EC, 0x005FA4EA, 0x005BA5F3, 0x0059A4F2, 0x00579CE1, 0x005A9CE3, 0x005C9EE5, 0x005EA0E7, 0x005EA0E7, 0x005D9FE6,
    0x005C9EE5, 0x005B9DE4, 0x005C9EE5, 0x005F9EE2, 0x005B9CE1, 0x00589AE1, 0x00599EE4, 0x00589CDF, 0x005B9BDB, 0x005A96D1, 0x00427EB4, 0x003A77B9, 0x003C77B5, 0x00427BB3, 0x004D82B5, 0x00497B9F, 0x0038606C, 0x003C5541, 0x00566238, 0x0057684D,
    0x005D6E4C, 0x005F7045, 0x005F6A44, 0x00626A4C, 0x00676E53, 0x00616F4B, 0x00596D40, 0x0056663D, 0x0057643E, 0x00585F3E, 0x00505235, 0x00595843, 0x0093917F, 0x0029291B, 0x0057594D, 0x00BFB8A9, 0x00BFB8A9, 0x00C5C0B1, 0x005A5748, 0x003B3B2B,
    0x00909181, 0x00616454, 0x00232616, 0x00373C27, 0x003E4628, 0x00444E24, 0x00424F1B, 0x00435215, 0x0049581B, 0x00515F25, 0x0059642C, 0x00495B2C, 0x003E4A2E, 0x00939994, 0x00C0C3C8, 0x00B2B7BA, 0x009BA1A0, 0x009AA09F, 0x00B1B8BB, 0x009BA295,
    0x00505C40, 0x00627347, 0x006C7F4E, 0x00697A4F, 0x00677551, 0x00697852, 0x004E5F34, 0x007E8576, 0x00CCD0D1, 0x00C9CED7, 0x00BAC5C3, 0x00B9C4C2, 0x00C4CACF, 0x00BDC2C0, 0x00636C57, 0x00566B3A, 0x00617645, 0x006B814D, 0x00617645, 0x00495D30,
    0x0051633C, 0x00505F3F, 0x003A482C, 0x0037462A, 0x00425332, 0x003F512C, 0x002C4015, 0x00293E11, 0x003C5124, 0x0041552A, 0x0033471D, 0x00354625, 0x00364725, 0x002E3E1C, 0x002B3818, 0x003F482D, 0x00525742, 0x00515143, 0x00504F45, 0x00444A39,
    0x00232819, 0x0014180D, 0x001A1D14, 0x00191C13, 0x0022261B, 0x003C4132, 0x004C5241, 0x004E503C, 0x004C4E3B, 0x00545446, 0x00535347, 0x004D4D3F, 0x00474838, 0x003F412D, 0x00454930, 0x00414435, 0x0050564B, 0x00939C99, 0x00ABB6BA, 0x00A6B2BC,
    0x009DA8B6, 0x009AA5B3, 0x00A0A9B7, 0x00AEB4C7, 0x00A6AFB8, 0x00A4B1AF, 0x00A7B1B1, 0x00A0A8AF, 0x009FA6AF, 0x00959D9C, 0x006F7B6F, 0x006A7B50, 0x00697A4F, 0x00647549, 0x00647549, 0x0065764B, 0x00475531, 0x002E3A1C, 0x00455036, 0x00424333,
    0x00575848, 0x005E5E50, 0x00555549, 0x0056554B, 0x00605E56, 0x00636159, 0x005D5A55, 0x00626056, 0x0068665C, 0x006A685E, 0x006B695F, 0x006D6B61, 0x006C6A60, 0x0069675D, 0x006A685E, 0x005D5D51, 0x0059584E, 0x0055534B, 0x0054524A, 0x0056544C,
    0x0059594D, 0x00545545, 0x00484A36, 0x00454636, 0x00595A4A, 0x00575749, 0x005B5B4D, 0x00555549, 0x0056564A, 0x00545349, 0x0055544A, 0x004B564C, 0x005A6D70, 0x0057615B, 0x0051564D, 0x00505C60, 0x004B5150, 0x00514F44, 0x00595F5E, 0x005F7CA1,
    0x006282A6, 0x006487A8, 0x005F839B, 0x00557483, 0x00455B60, 0x0046544E, 0x0051594E, 0x00555549, 0x00515145, 0x00525244, 0x00535345, 0x00525343, 0x00545545, 0x00575848, 0x00555744, 0x00565743, 0x00575745, 0x005D5C4E, 0x005C5A4F, 0x0059574C,
    0x005E5D4F, 0x00545442, 0x003C3D29, 0x003F402C, 0x00585848, 0x0058584C, 0x005A594F, 0x00535248, 0x0056584C, 0x00505344, 0x00484B3B, 0x00606D47, 0x006B7950, 0x006F7D53, 0x006E7B55, 0x00667151, 0xFFE7EDDA, 0xFFFFFFFC, 0xFFFFFEFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x6BA8CBEC, 0x00649ED9, 0x0058A2F0, 0x005CA3ED, 0x005EA4EA, 0x005AA5F3, 0x0059A4F2, 0x00569DE1, 0x005B9CE6, 0x005C9DE7, 0x005E9FE9, 0x005E9FE9, 0x005D9EE8,
    0x005B9CE6, 0x005B9CE6, 0x005B9CE6, 0x0062A3E8, 0x005EA1E6, 0x00589DE3, 0x005BA0E6, 0x00589BE0, 0x005797D7, 0x0063A2DC, 0x0067A3D9, 0x005A9CDD, 0x0062A0E0, 0x00629CD7, 0x005489BB, 0x003B6A8A, 0x00284C56, 0x00274435, 0x00344A2D, 0x003E4D38,
    0x003E4D31, 0x0034421E, 0x0037401F, 0x0052583F, 0x006D725D, 0x00636F51, 0x004A5C35, 0x00596646, 0x00677153, 0x003C3F26, 0x005E5D49, 0x005A5546, 0x009E9A8F, 0x00727066, 0x0035362D, 0x00BFB7AA, 0x00CDC5B8, 0x00C5BFB2, 0x004C493B, 0x006D6C5E,
    0x00ACAC9E, 0x002F3223, 0x00202314, 0x00282A1E, 0x00323623, 0x003B4324, 0x00404A1F, 0x0042501A, 0x004B591F, 0x00556427, 0x005C6B2E, 0x00596C3B, 0x004E5A3E, 0x009A9E99, 0x00ABAEB3, 0x00979A9E, 0x00919895, 0x00999F9E, 0x00AEB3B6, 0x00969D90,
    0x00626E52, 0x00708155, 0x006E8150, 0x006D7E53, 0x00667450, 0x006C7B55, 0x00637449, 0x00848C7B, 0x00BFC3C4, 0x00B3B9C0, 0x00B1BCBA, 0x00B0BBB8, 0x00B2B8BD, 0x00B4B9B7, 0x0068715C, 0x0066774C, 0x006A7B4F, 0x00708253, 0x006B7E4D, 0x003E5021,
    0x003D4D24, 0x003B4925, 0x002E3B1B, 0x00293D1A, 0x002F441E, 0x002F441E, 0x00253A14, 0x001C300D, 0x001C300D, 0x001D300F, 0x0017290A, 0x00172A0F, 0x0017280D, 0x0017250D, 0x001C2510, 0x003E422F, 0x005A5A4C, 0x005D584F, 0x006B635C, 0x005D6050,
    0x00484B3B, 0x00303324, 0x002B2E1F, 0x002D3021, 0x00373A2B, 0x004C4F3F, 0x00565949, 0x00565442, 0x004F4C3D, 0x00585547, 0x00575348, 0x00504D3F, 0x00484634, 0x003D3C27, 0x0045462C, 0x0049493D, 0x0070736A, 0x00ACB2B1, 0x00AEB7BB, 0x00B2BBC5,
    0x00AFB7C4, 0x00A7ADBA, 0x00B1B4C2, 0x00A7ACC1, 0x00AEB6C3, 0x00AAB4BB, 0x00AFB6BF, 0x00ADB2C1, 0x00B0B5C4, 0x00A4AAAF, 0x006A756D, 0x0067774E, 0x0067784D, 0x00647549, 0x0065764A, 0x0064744B, 0x0043512D, 0x00273315, 0x003A452B, 0x003D3E2E,
    0x004D4E3E, 0x00555547, 0x00505044, 0x00515046, 0x0056554B, 0x0056544C, 0x00504D48, 0x004C4941, 0x00524F47, 0x004F4C44, 0x004D4A42, 0x00504D45, 0x004C4941, 0x00504D45, 0x00625F57, 0x0059574F, 0x0057554D, 0x0057564C, 0x0059584E, 0x005C5C50,
    0x005D5E4E, 0x005A5C49, 0x00535541, 0x00575946, 0x006A6B5B, 0x00676858, 0x00696A5A, 0x00606052, 0x00616153, 0x00646458, 0x006A6A5E, 0x00596156, 0x005A655B, 0x005D6455, 0x00646A59, 0x00656C5F, 0x0064685C, 0x0069695B, 0x0060625C, 0x00505C62,
    0x005B676D, 0x005A696C, 0x00596766, 0x0055615B, 0x005F6657, 0x00686752, 0x006E6B4F, 0x00606054, 0x005E5E50, 0x005F6050, 0x005E604D, 0x005A5C48, 0x00565844, 0x00585A47, 0x005B5C4C, 0x005C5D49, 0x00585846, 0x00575648, 0x00565449, 0x0057554A,
    0x005E5D4F, 0x00585846, 0x00474834, 0x0052533F, 0x00636353, 0x00626254, 0x00626256, 0x005E5E50, 0x00676B58, 0x00616750, 0x00595F46, 0x0064714B, 0x006D7B52, 0x006F7D53, 0x006F7C56, 0x00687353, 0xFFE8EEDB, 0xFFFFFFFC, 0xFFFFFEFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x6BA8CBEC, 0x00649DDA, 0x0058A1F1, 0x005AA2EF, 0x005EA3EC, 0x005AA5F3, 0x0058A5F4, 0x00579DE3, 0x00599DE6, 0x005B9FE8, 0x005CA0E9, 0x005CA0E9, 0x005B9FE8,
    0x00599DE6, 0x00599DE6, 0x00599DE6, 0x005FA0E5, 0x0060A2E9, 0x00579BE4, 0x00569BE4, 0x00589DE2, 0x005D9DDE, 0x005896D2, 0x004782BA, 0x004F7CA2, 0x005581A6, 0x00547D9E, 0x0041637A, 0x00253F46, 0x00182B22, 0x001E3019, 0x002A3A1B, 0x00566355,
    0x00435139, 0x00344022, 0x00394025, 0x00474B38, 0x004D5041, 0x00434D36, 0x003A4A28, 0x00525B41, 0x004F553E, 0x00575844, 0x00858071, 0x007D776A, 0x00716C63, 0x00A4A199, 0x00595651, 0x00999184, 0x00A1998C, 0x00A59F92, 0x007A7769, 0x008F8E80,
    0x00727264, 0x000E1102, 0x002F3223, 0x0021241B, 0x002A2F20, 0x00363C25, 0x003C4622, 0x00414C1E, 0x0046541E, 0x00505E24, 0x00576629, 0x005A6A3A, 0x004F593B, 0x00989C96, 0x00A6A7AB, 0x00989C9D, 0x00A3A8A6, 0x00A4ABA8, 0x00AAAFB0, 0x008E9588,
    0x005F6B4F, 0x00728357, 0x006D804F, 0x006D7E53, 0x006B7955, 0x006F7E58, 0x0064754A, 0x008C9281, 0x00C0C4C5, 0x00B4B7BF, 0x00B4BFBC, 0x00B3BEBB, 0x00B7BCBF, 0x00BCC2BD, 0x00737B64, 0x00687654, 0x006A7854, 0x0066754F, 0x00576640, 0x002B3915,
    0x002E3B1B, 0x002B371B, 0x001B250E, 0x002F4122, 0x00324427, 0x002C3C24, 0x00303F2A, 0x003C4A38, 0x00384535, 0x002E3B2B, 0x00323F31, 0x00384A33, 0x0031402B, 0x00333D2C, 0x0032392C, 0x00404137, 0x00514E46, 0x00655F58, 0x008B837C, 0x006F7263,
    0x00696C5D, 0x004E5141, 0x004C4F3F, 0x00575A4A, 0x00525545, 0x00595C4D, 0x0066695A, 0x00737061, 0x00595648, 0x00555146, 0x00514D42, 0x00524F41, 0x004F4E3A, 0x003D3D25, 0x00434528, 0x0046473D, 0x00797B75, 0x00B1B7B6, 0x00ADB5BC, 0x00B3B9C4,
    0x00B1B7C4, 0x00ABAFBA, 0x00B4B6C1, 0x00AFB7C4, 0x00B3BDC4, 0x00A8B4B6, 0x00ABB3BA, 0x00AAAFBE, 0x00AEB4BF, 0x00A4ACAB, 0x00687565, 0x0065754C, 0x0068784F, 0x00697A4F, 0x006C7D52, 0x0068784F, 0x00404E2C, 0x001C280C, 0x002B351E, 0x001E1F0B,
    0x00222210, 0x00272715, 0x002A2A1A, 0x0029281A, 0x0029271C, 0x0028261C, 0x0026241A, 0x00232117, 0x0026241A, 0x00222016, 0x00222016, 0x00232117, 0x001B190F, 0x0029271D, 0x004D4B41, 0x002D2D21, 0x002D2D1F, 0x002C2D1D, 0x002C2E1B, 0x002B2D19,
    0x00292B17, 0x00292B17, 0x002C2E1A, 0x00323420, 0x003E402D, 0x00373926, 0x003D3F2C, 0x00383929, 0x00393A2A, 0x0038382A, 0x003A3A2C, 0x003A3F30, 0x00333521, 0x00303421, 0x00363C29, 0x00393C23, 0x003C3E2A, 0x00434839, 0x003C3C2C, 0x0043462C,
    0x003D4027, 0x00363723, 0x0041412F, 0x00484634, 0x0048432E, 0x003F381F, 0x00453A1F, 0x00343329, 0x00333325, 0x00323420, 0x0032361D, 0x0034381F, 0x00333620, 0x00333522, 0x00343525, 0x003C3D29, 0x002E2E1C, 0x00242315, 0x00211F14, 0x00232116,
    0x00272618, 0x00282816, 0x00242511, 0x00252513, 0x002C2C1C, 0x002B2C1C, 0x00323323, 0x0040422F, 0x00636950, 0x006F7758, 0x00707958, 0x006A7751, 0x00707E55, 0x00707E54, 0x00707D57, 0x006A7555, 0xFFE8EEDB, 0xFFFEFFFB, 0xFFFEFDFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x67A6CBED, 0x00639FDB, 0x0057A2F1, 0x005AA2EF, 0x005DA5ED, 0x0058A5F4, 0x0058A5F4, 0x00559DE3, 0x00599CE7, 0x005B9EE9, 0x005DA0EB, 0x005C9FEA, 0x005B9EE9,
    0x00599CE7, 0x00589BE6, 0x00589BE6, 0x005597DE, 0x005BA0E6, 0x005398E1, 0x005196DF, 0x005CA1E7, 0x0063A5E6, 0x004584C0, 0x000D4A82, 0x002A4756, 0x00223F4E, 0x00263E4A, 0x0033413F, 0x00393E29, 0x00454422, 0x004F532A, 0x00515931, 0x00263129,
    0x00273321, 0x00465137, 0x006A6F5A, 0x0065675B, 0x00494A40, 0x00394130, 0x003A482C, 0x00373E29, 0x00292E19, 0x00686654, 0x00989384, 0x00978E84, 0x007F786F, 0x00A3A098, 0x0094928A, 0x007B7268, 0x007D746A, 0x00888277, 0x00A19D92, 0x0097958A,
    0x006C6C60, 0x004D4F43, 0x001D1F13, 0x0023261D, 0x0024281C, 0x002B311E, 0x00373F21, 0x003D4822, 0x00424D1F, 0x004B5923, 0x0055642B, 0x004A5A2A, 0x00404A2C, 0x00999B95, 0x00AFB0B4, 0x00A3A5A6, 0x00A9AFAA, 0x00AAAFAD, 0x00B5B9BA, 0x008A9184,
    0x00465236, 0x0067784C, 0x006D804F, 0x006B7C51, 0x00717F5B, 0x006B7A54, 0x004D5E33, 0x00747A67, 0x00C1C3C3, 0x00BDC1C6, 0x00BCC5C2, 0x00BBC5BF, 0x00C1C6C9, 0x00BEC2BD, 0x00575F48, 0x00636E4D, 0x00717C5B, 0x00687450, 0x00475231, 0x002E381A,
    0x004B533C, 0x00686E5D, 0x006E7266, 0x005D6953, 0x00677160, 0x00656E61, 0x00666D66, 0x006E746F, 0x00666C67, 0x005D635E, 0x00646B64, 0x00616C58, 0x005D6756, 0x006C7366, 0x0071746B, 0x0060605A, 0x0054514C, 0x005E5B53, 0x00747268, 0x00737169,
    0x00706F65, 0x0059594B, 0x00656656, 0x00767767, 0x00606052, 0x005F5E54, 0x0076746C, 0x006E6D5F, 0x00535146, 0x00535146, 0x00504E43, 0x004F4E40, 0x00494A36, 0x0036391F, 0x003F4425, 0x00444940, 0x00747A75, 0x00AFB7B7, 0x00B5BFC6, 0x00B1BAC4,
    0x00A8AEB9, 0x00AEB0BB, 0x00B2B3BD, 0x00A9B3BA, 0x00ADB9BB, 0x00A8B4B4, 0x00B0B8BF, 0x00B0B6C3, 0x00B2B9C2, 0x00A5B0A8, 0x006A7A63, 0x00677650, 0x0068784F, 0x0067784D, 0x0068794E, 0x0066754F, 0x0042502E, 0x00232F13, 0x00343E27, 0x00494C33,
    0x0043462D, 0x00444630, 0x00484935, 0x00474735, 0x00474735, 0x004A4A3A, 0x004B4B3B, 0x004C4C3A, 0x004A4A38, 0x00434331, 0x003F3F2D, 0x00353523, 0x00222210, 0x002E2E1C, 0x00565644, 0x00434630, 0x0042462D, 0x003E4328, 0x003C4124, 0x003A3F24,
    0x00373B22, 0x003D3F2B, 0x00484939, 0x003F412D, 0x00444632, 0x00383A26, 0x00424431, 0x00464835, 0x00484A37, 0x003F4030, 0x00383929, 0x00353B28, 0x003D3B1D, 0x003D422D, 0x00424C3C, 0x00424125, 0x00393D24, 0x00394434, 0x003B3D20, 0x00363C1D,
    0x0040452A, 0x00434531, 0x00444535, 0x004E4E42, 0x0049493D, 0x00474739, 0x00505141, 0x004A493F, 0x0048483A, 0x0041442E, 0x003E4326, 0x00444A2B, 0x00494E33, 0x00454734, 0x00414133, 0x0051523E, 0x00474735, 0x00414032, 0x00444237, 0x00464439,
    0x00454436, 0x00454533, 0x00454632, 0x00464634, 0x00454535, 0x003D3E2E, 0x003D3F2C, 0x00444731, 0x00666E4F, 0x006E7953, 0x006E7A50, 0x006E7B55, 0x00728057, 0x00707E54, 0x00717E58, 0x006B7656, 0xFFE9EFDC, 0xFFFEFFFB, 0xFFFDFCFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x6BA7CCEE, 0x00639EDC, 0x0057A2F1, 0x005AA2EF, 0x005DA4EE, 0x0059A6F5, 0x0056A5F4, 0x00559DE5, 0x00599DE8, 0x005A9EE9, 0x005CA0EB, 0x005B9FEA, 0x005A9EE9,
    0x00589CE7, 0x00579BE6, 0x00579BE6, 0x005C9EE5, 0x005DA1EA, 0x00579CE5, 0x00569BE4, 0x00599EE4, 0x005C9EDF, 0x004584C1, 0x0014508B, 0x00285576, 0x001B4667, 0x00163B55, 0x001E343A, 0x00292F1E, 0x003D3E1E, 0x004A4E2B, 0x003F4C2C, 0x0028312E,
    0x00364033, 0x004B543F, 0x004A4D3D, 0x0037382F, 0x00373731, 0x0031382B, 0x001C2911, 0x00282F1A, 0x002D2F1C, 0x002F2D1B, 0x00787162, 0x00978F82, 0x00958F84, 0x009F9A91, 0x0086847A, 0x00877E75, 0x00867D74, 0x00857E75, 0x00908B82, 0x008E8C82,
    0x009B9A90, 0x00A7A89E, 0x004A4B41, 0x0024281C, 0x001C2014, 0x001E2413, 0x002D351E, 0x003B4324, 0x00424D25, 0x00515D2D, 0x00626E3C, 0x00566734, 0x00424C2E, 0x009D9F99, 0x00BBBABE, 0x00AFB1B1, 0x00B4B8B3, 0x00B4BAB5, 0x00C6CBCA, 0x0092998C,
    0x00445034, 0x006B7C50, 0x00738655, 0x006F8055, 0x006D7B57, 0x005B6A44, 0x0044552A, 0x00898D7A, 0x00D1D3D3, 0x00C7CACF, 0x00BFC9C3, 0x00BDC7C1, 0x00C8CBCF, 0x00C9CDC8, 0x00626851, 0x005B6A3E, 0x006F7E52, 0x0067754B, 0x00404E25, 0x003D4827,
    0x005F684E, 0x009AA08F, 0x00C1C5BA, 0x00AEB5A0, 0x00B6BCAB, 0x00B7BBB0, 0x009FA09C, 0x007F807E, 0x00747571, 0x0073766D, 0x006A6E62, 0x005F644F, 0x00686B5B, 0x00808177, 0x007E7E78, 0x0053524E, 0x00474741, 0x0065675B, 0x00737667, 0x00736F6E,
    0x00706D68, 0x005A5A4E, 0x0068685A, 0x00737365, 0x0059594D, 0x00595651, 0x006C6867, 0x006B6B5F, 0x0059584E, 0x0067665C, 0x0066665A, 0x005E5F4F, 0x0051543E, 0x003C4124, 0x004C5332, 0x004A524B, 0x00828B88, 0x00ABB7B7, 0x00AFBBC1, 0x00B1BCC4,
    0x00A7B0BA, 0x00B3B8C1, 0x00B7BAC2, 0x00AFB8C1, 0x00AFBABE, 0x00AAB5B9, 0x00AEB4BF, 0x00ACB0C2, 0x00AFB5C2, 0x00A2ACA6, 0x006D7D66, 0x00687751, 0x0067774E, 0x0064744B, 0x0064744B, 0x0064734D, 0x00445131, 0x00293519, 0x003E4831, 0x0047492B,
    0x00414325, 0x00414326, 0x0045462C, 0x0044442C, 0x00484732, 0x004B4A35, 0x00494834, 0x00474B2E, 0x0045492C, 0x0043472A, 0x0043472A, 0x003C4023, 0x002F3316, 0x003D4124, 0x005F6346, 0x0059603D, 0x0058603B, 0x00555E36, 0x00576038, 0x005A613E,
    0x00585D42, 0x005C5E4B, 0x0069695D, 0x0051543E, 0x00545741, 0x00484B35, 0x00545642, 0x005B5D49, 0x00616350, 0x005C5E4B, 0x00595B48, 0x00414C32, 0x0058522D, 0x00575B48, 0x005B665E, 0x00666148, 0x0052553F, 0x00435544, 0x004B5029, 0x00535843,
    0x006E7161, 0x0076786C, 0x00595A50, 0x00565950, 0x0042483D, 0x00455040, 0x0052604E, 0x006B6961, 0x006D6E5E, 0x0060644B, 0x004F5635, 0x004D5433, 0x004F5437, 0x004C4E3A, 0x0049493B, 0x004C4D39, 0x004D4D3B, 0x00504F41, 0x00555348, 0x0057554A,
    0x00555446, 0x00525240, 0x0050513D, 0x00535341, 0x00525242, 0x0050523F, 0x004C4E3A, 0x004D5237, 0x006A7450, 0x006E7B4F, 0x006C7A4A, 0x006F7C56, 0x00717F56, 0x006E7C52, 0x00707D57, 0x006B7656, 0xFFE9EFDC, 0xFFFEFFFB, 0xFFFDFCFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x6BA7CCEE, 0x00639EDC, 0x0058A2F4, 0x0058A2F0, 0x005DA4EE, 0x0059A6F5, 0x0056A5F6, 0x00559DE5, 0x00599DE8, 0x005B9FEA, 0x005CA0EB, 0x005CA0EB, 0x005A9EE9,
    0x00589CE7, 0x00579BE6, 0x00579BE6, 0x005D9FE6, 0x00569AE3, 0x00579BE6, 0x005CA3ED, 0x00569CE2, 0x005697DB, 0x005F9EDB, 0x005793CE, 0x003C85C9, 0x00448BCE, 0x004584BE, 0x00305B7C, 0x00192F34, 0x001E2D1F, 0x00243625, 0x00122C1F, 0x001F2726,
    0x00404A3E, 0x00464E3D, 0x00212415, 0x0020201A, 0x005F5D5C, 0x00646A5F, 0x00232F19, 0x00272C17, 0x00232512, 0x0033311F, 0x004D4637, 0x008A8275, 0x00918B7E, 0x00928E83, 0x008D8B80, 0x00867D74, 0x00898077, 0x008B847B, 0x0079746B, 0x00838177,
    0x009D9C92, 0x00B0B1A7, 0x00A4A59B, 0x00333A2B, 0x0024291A, 0x001E2413, 0x002A311C, 0x00363D22, 0x003B4521, 0x004B552B, 0x005E693B, 0x00606F3C, 0x00394424, 0x00898C83, 0x00ACABAD, 0x00AEB0B0, 0x00BABEB9, 0x00B2B8B3, 0x00B9BEBD, 0x00858C7F,
    0x00404C30, 0x006A7B4F, 0x006F8251, 0x006F8055, 0x0063714D, 0x004B5A34, 0x00526338, 0x00868A77, 0x00C5C7C7, 0x00C0C3C8, 0x00CAD4CE, 0x00C6D0CA, 0x00BEC2C3, 0x00B7BBB5, 0x00555B42, 0x00657841, 0x00748750, 0x0072844F, 0x00536334, 0x004F5D34,
    0x00444E30, 0x005C624F, 0x007C8172, 0x00979B82, 0x00A1A390, 0x00B9B9AD, 0x00ACAAA2, 0x0086837E, 0x008C8B81, 0x00929383, 0x006F715D, 0x00676652, 0x008F8F7F, 0x00C3C1B7, 0x00B8B5B1, 0x00676662, 0x00484B42, 0x006A7162, 0x006F7864, 0x006D6869,
    0x006D6A66, 0x005A594F, 0x00626254, 0x0068685A, 0x0059584E, 0x00615E5A, 0x00696465, 0x006A6C60, 0x0053544A, 0x005E5F55, 0x005D5F53, 0x00565949, 0x00494F38, 0x0031391B, 0x00404928, 0x00636E66, 0x00A7B5B1, 0x00B4C1C3, 0x00A0AEB4, 0x00B1BEC6,
    0x00ABB6BE, 0x00AFB7BE, 0x00B4BAC1, 0x00B2BAC7, 0x00B1BAC3, 0x00B0B9C3, 0x00AFB3C5, 0x00ABACC6, 0x00AFB3C6, 0x009EA6A6, 0x006B7967, 0x0066754F, 0x00687751, 0x0068784F, 0x006A7A51, 0x00687751, 0x00435030, 0x00222D13, 0x00333D26, 0x003F4320,
    0x003D411E, 0x00404323, 0x00424426, 0x00434528, 0x00494A30, 0x004B4B33, 0x0043432B, 0x00424825, 0x00404623, 0x003F4522, 0x00414724, 0x003D4320, 0x00383E1B, 0x00484E2B, 0x00636946, 0x00626C41, 0x005E693B, 0x00596436, 0x005B6638, 0x005C653D,
    0x0052573A, 0x004D4F3C, 0x00545349, 0x004E5239, 0x00535640, 0x00454832, 0x004A4D37, 0x00494B37, 0x004E503C, 0x0050523F, 0x00565845, 0x003F4D31, 0x00524C23, 0x003D4332, 0x00404B49, 0x005A543D, 0x004F523C, 0x003D5341, 0x004B5225, 0x004D4A3B,
    0x005D5A4C, 0x00666257, 0x00524E43, 0x00595A4A, 0x00313823, 0x00313F23, 0x00475A39, 0x005A5850, 0x00656656, 0x005C6146, 0x00444B28, 0x0039401D, 0x003D4225, 0x00434531, 0x0049493B, 0x00484935, 0x004D4D3B, 0x004D4C3E, 0x004A483D, 0x004A483D,
    0x004C4B3D, 0x004C4C3A, 0x004B4C38, 0x004F4F3F, 0x00505040, 0x00515340, 0x004B4E38, 0x00484D30, 0x0066714B, 0x006E7B4D, 0x0071814C, 0x006E7B55, 0x006F7D54, 0x006C7A50, 0x006F7C56, 0x006B7656, 0xFFE9EFDC, 0xFFFEFFFB, 0xFFFEFDFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x4C97C1EB, 0x00629FE1, 0x0056A0F2, 0x005EA2ED, 0x0064A6ED, 0x005DA5F3, 0x005BA5F7, 0x00579BE6, 0x00589BE6, 0x005C9FEA, 0x00599DE8, 0x005DA1EC, 0x005CA0EB,
    0x00569DE7, 0x005AA1EB, 0x00579EE8, 0x00619FE5, 0x0063A3EA, 0x005D9EE8, 0x005697E1, 0x005A9AE1, 0x00629FE3, 0x00629DDB, 0x006097D4, 0x005D9CCF, 0x006396D5, 0x005993C7, 0x004B90C2, 0x003C73A6, 0x00274A4E, 0x00314B23, 0x0024381B, 0x001B1F13,
    0x00262919, 0x002C2E1A, 0x004A4D34, 0x002A2E15, 0x00454B34, 0x0047503B, 0x001E2A16, 0x00262913, 0x002E301C, 0x00323421, 0x00757666, 0x00848478, 0x0086857B, 0x008D8B83, 0x00908D88, 0x00938D82, 0x00888178, 0x008C877E, 0x00807B72, 0x007D7A72,
    0x009F9C94, 0x00AAA7A2, 0x00999691, 0x006A6860, 0x00252713, 0x00262C15, 0x0026281C, 0x002D3320, 0x003C4A20, 0x00445522, 0x00536439, 0x00626946, 0x00404724, 0x00464D2A, 0x004A5130, 0x00606746, 0x00717758, 0x00666C4D, 0x00646A4B, 0x006A715C,
    0x00464F34, 0x00798463, 0x00727F59, 0x0067754C, 0x00505C38, 0x00606B4B, 0x005A6348, 0x00686B5C, 0x00585B4B, 0x006F7360, 0x008F947F, 0x008B907B, 0x00696D5A, 0x00636656, 0x00525546, 0x0061704A, 0x006F7E58, 0x006E7E55, 0x0066744B, 0x004D5B31,
    0x0039461A, 0x00303D0F, 0x003C491B, 0x00576732, 0x0051622F, 0x004A5B2F, 0x0043572D, 0x003E5431, 0x00395133, 0x00314A30, 0x002A442C, 0x00314C2A, 0x00385030, 0x00405639, 0x00425038, 0x00454E3A, 0x00525546, 0x00636156, 0x007D786F, 0x0077746C,
    0x00726F67, 0x005A584E, 0x006A685D, 0x00666557, 0x005B5A4C, 0x00626252, 0x006F6F5D, 0x0067655A, 0x00545247, 0x00656359, 0x006D6B61, 0x005B594E, 0x00484836, 0x003A3D24, 0x00424629, 0x00687069, 0x00A9B1B0, 0x00ABB3BA, 0x00AAB2BF, 0x00B7BDC8,
    0x00BDC5C5, 0x00ABB4A7, 0x00979E89, 0x00889A6B, 0x00869470, 0x0096A488, 0x00AFBAAA, 0x00B9BDC8, 0x00A9A9C7, 0x00A2ADB1, 0x00667E5B, 0x0068754F, 0x006B7B52, 0x00697C51, 0x00667A50, 0x0062754E, 0x00424F2F, 0x00262D12, 0x00383B25, 0x003C3E21,
    0x003E4022, 0x00414424, 0x00434724, 0x00434724, 0x00424426, 0x0043442A, 0x0044442C, 0x00404526, 0x00444629, 0x0045442A, 0x00454128, 0x00424022, 0x003B3F1C, 0x00495329, 0x00637042, 0x005D6C40, 0x005B6B3C, 0x00586936, 0x005A6B38, 0x005B6A3E,
    0x004E5939, 0x00434A35, 0x0044483C, 0x004A5443, 0x00444B3C, 0x005A6739, 0x0055632D, 0x0042452F, 0x004D5040, 0x003E492F, 0x00485046, 0x004C5834, 0x004A5D26, 0x0047532F, 0x003E4433, 0x004D563C, 0x00424934, 0x00545D43, 0x004D6126, 0x00475630,
    0x00414B34, 0x00494F44, 0x00474C43, 0x0058614C, 0x00515D3F, 0x00596646, 0x00455135, 0x004B514C, 0x0069735C, 0x005C6C3D, 0x00475924, 0x0039461A, 0x00404627, 0x0045482F, 0x004B4D37, 0x004B4E38, 0x004C4E3A, 0x004D4F3B, 0x004C4E3B, 0x004B4D3A,
    0x004B4C3C, 0x004C4D3D, 0x004E4E40, 0x004D4C38, 0x0051503C, 0x004C4C3A, 0x00494B37, 0x004D533A, 0x00687353, 0x00697650, 0x0066774C, 0x006E7C52, 0x006F7E52, 0x00707F53, 0x00728056, 0x00677252, 0xFFE6ECD9, 0xFFFFFFFC, 0xFFFEFDFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x4C97C1EB, 0x0060A0E1, 0x0056A0F2, 0x005EA2ED, 0x0064A6ED, 0x005BA5F3, 0x005BA5F7, 0x00579BE6, 0x00589BE6, 0x005C9FEA, 0x00599DE8, 0x005CA0EB, 0x005A9EE9,
    0x00549BE5, 0x00579EE8, 0x00559CE6, 0x005B99DF, 0x005B9BE2, 0x005A9BE5, 0x005899E3, 0x005E9EE5, 0x00619EE2, 0x004C87C5, 0x003067A4, 0x0030699C, 0x003764A1, 0x00477EB1, 0x005798CB, 0x005388BB, 0x003A5A60, 0x003C5431, 0x0031442B, 0x00212519,
    0x00363929, 0x00363824, 0x005C5F46, 0x003B3E25, 0x00313720, 0x00303924, 0x001C2814, 0x00292C16, 0x00222410, 0x003C3E2B, 0x00828373, 0x008C8C80, 0x00919086, 0x0087857D, 0x007E7B76, 0x00969085, 0x00898279, 0x0089847B, 0x00807B72, 0x007A776F,
    0x00928F87, 0x00A09D98, 0x009F9C97, 0x007D7B73, 0x00353723, 0x002B311A, 0x00232519, 0x00242A17, 0x0038461C, 0x00475825, 0x005E6C42, 0x00616A42, 0x004B532E, 0x004B532E, 0x00424A25, 0x003D4421, 0x004B522F, 0x00444B2A, 0x004D5433, 0x00646D53,
    0x00636D4F, 0x006C7854, 0x0068764D, 0x00556339, 0x0058653F, 0x00465130, 0x003F4A2A, 0x00686E57, 0x004C5239, 0x004D5439, 0x00575E43, 0x00565D42, 0x004D5439, 0x00595F46, 0x00545A43, 0x0065764B, 0x006D7E53, 0x0075865B, 0x006A784F, 0x004F5C36,
    0x00353F1B, 0x00343E1A, 0x003F4925, 0x00455127, 0x003B461E, 0x002F3C16, 0x00263412, 0x001C2B0C, 0x00142308, 0x0012220A, 0x0015250E, 0x000F2209, 0x0016260E, 0x00121F09, 0x0018230F, 0x00424837, 0x00575A4B, 0x004E4E42, 0x00555348, 0x00626055,
    0x00636156, 0x00545247, 0x00666459, 0x005F5D52, 0x00514F44, 0x0057554A, 0x00656358, 0x006C6A5F, 0x0059574C, 0x006B695F, 0x00727066, 0x00605E53, 0x004B4B39, 0x003B3E25, 0x00424629, 0x0069706B, 0x00A6AEAE, 0x00A4ACB3, 0x00B1BAC4, 0x00B7BFC6,
    0x009BA59F, 0x007F8A76, 0x00768062, 0x00738459, 0x006E7C58, 0x0070805E, 0x008A9880, 0x00ABB2B5, 0x00B2B4CC, 0x009FAAAE, 0x00667E5C, 0x0068754F, 0x006B7B52, 0x00687B50, 0x0065794F, 0x0062754E, 0x00424F2F, 0x00262D12, 0x00383B25, 0x003B3D20,
    0x003D3F21, 0x003F4222, 0x003F4320, 0x00414522, 0x00434527, 0x0045462C, 0x0046462E, 0x00404427, 0x00434528, 0x00444329, 0x00454128, 0x00424022, 0x003B3F1C, 0x00485228, 0x005F6F40, 0x005C6B3F, 0x0059693A, 0x00556633, 0x00576737, 0x0058663C,
    0x00505B3B, 0x0049503B, 0x004E5246, 0x003E4838, 0x00464D3E, 0x00515E32, 0x0055632D, 0x00434630, 0x00484B3B, 0x00465137, 0x004B5349, 0x00525D3D, 0x00526330, 0x00434E2D, 0x003E4236, 0x004C533E, 0x003B4130, 0x00525944, 0x004F622B, 0x00485632,
    0x003F4932, 0x004E534A, 0x00474C43, 0x005C6551, 0x005F6B4D, 0x005C684A, 0x00465236, 0x004C524D, 0x0068725B, 0x005B6B3C, 0x00475924, 0x0039461A, 0x00404627, 0x0045482F, 0x004B4D37, 0x00484B35, 0x00494B37, 0x004B4D39, 0x004B4D39, 0x004A4C39,
    0x004A4C39, 0x004B4C3C, 0x004C4D3D, 0x004C4B37, 0x00504F3B, 0x004C4C3A, 0x004A4C38, 0x004E543B, 0x006A7555, 0x006B7852, 0x0068794E, 0x006D7B51, 0x006E7D51, 0x006F7E52, 0x00717F55, 0x00687353, 0xFFE7EDDA, 0xFFFFFFFC, 0xFFFFFEFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x4896C2EB, 0x005F9FE0, 0x0056A0F2, 0x005CA3ED, 0x0062A7ED, 0x005BA5F3, 0x005BA5F7, 0x00549BE5, 0x00589BE6, 0x005C9FEA, 0x00589CE7, 0x005B9FEA, 0x00599DE8,
    0x005299E3, 0x00559CE6, 0x005299E3, 0x0062A0E6, 0x005E9EE5, 0x005C9DE7, 0x00579BE4, 0x005B9DE4, 0x005F9EE2, 0x00417CBA, 0x000F4885, 0x00093B69, 0x00123872, 0x003B6C9E, 0x005794C6, 0x005584BA, 0x003B5A63, 0x003B5232, 0x00344530, 0x004A4E42,
    0x00696C5C, 0x004C4D39, 0x005D6047, 0x0045482F, 0x00333922, 0x00353E29, 0x00202B17, 0x00292B15, 0x0030311D, 0x004A4A38, 0x00777767, 0x008C8A7F, 0x009B998F, 0x0087847C, 0x00898580, 0x00908A7F, 0x00867F76, 0x0088837A, 0x0089847B, 0x00838078,
    0x008A877F, 0x009A9792, 0x00ABA8A3, 0x0094928A, 0x00464834, 0x00353822, 0x002D2F23, 0x00292D1A, 0x0037451B, 0x00435421, 0x005D6B41, 0x006A7449, 0x005A643A, 0x00555F35, 0x00535D33, 0x00454E26, 0x0059623A, 0x0048502B, 0x00545C37, 0x00566141,
    0x00636F4B, 0x006D7B52, 0x004D5B31, 0x00546337, 0x00505E34, 0x00606E45, 0x005F6C46, 0x0068724E, 0x00545E3A, 0x0057613D, 0x005A6440, 0x005B6541, 0x005D6743, 0x00626C48, 0x005B6541, 0x00657845, 0x00677A49, 0x00708155, 0x005F6C46, 0x00535E3E,
    0x003F452C, 0x00424732, 0x003E422F, 0x00474F31, 0x00434A2F, 0x00464D32, 0x004E5239, 0x004C4F39, 0x00434531, 0x003F412D, 0x00434532, 0x00414637, 0x003B4031, 0x00333829, 0x0036392A, 0x004B4E3F, 0x00575A4B, 0x004E4E40, 0x004E4E40, 0x00474735,
    0x00505040, 0x004F4F3F, 0x00676658, 0x00626055, 0x00555349, 0x005B5850, 0x006D6964, 0x00666459, 0x00555348, 0x0067655B, 0x00706E64, 0x005E5C51, 0x00494937, 0x00383B22, 0x003F4326, 0x00686E6D, 0x00AAB1B4, 0x00A8B0B7, 0x00B4BDC6, 0x00A9B3B3,
    0x00788577, 0x00687758, 0x00707E54, 0x006B7A54, 0x0072815B, 0x00687A51, 0x00687A55, 0x00848F85, 0x00B2B7C6, 0x009EAAAC, 0x00677D60, 0x0068754F, 0x006A7A51, 0x00677A4F, 0x0065794F, 0x0062754E, 0x00414E2E, 0x00262D12, 0x00393C26, 0x003A3C1F,
    0x003C3E20, 0x003C3F1F, 0x003B3F1C, 0x003E421F, 0x00454729, 0x0048492F, 0x0047472F, 0x00404528, 0x0041442A, 0x00434228, 0x00454128, 0x00414024, 0x003C401D, 0x00465228, 0x005D6C40, 0x005B693F, 0x0059693A, 0x00556535, 0x00576737, 0x0059673D,
    0x00515C3C, 0x004D5340, 0x0053574B, 0x00414A3D, 0x004B5245, 0x00546036, 0x0055622E, 0x00464834, 0x004E5142, 0x00454F38, 0x004D534E, 0x004F583D, 0x00526233, 0x0040492E, 0x0041433D, 0x00515647, 0x00494D42, 0x005A5F50, 0x004C5C2C, 0x00465430,
    0x003F4833, 0x0050554C, 0x004A4E48, 0x00636B5A, 0x00697559, 0x005F6B4D, 0x00465137, 0x004E544F, 0x0067715A, 0x005A6A3B, 0x00465823, 0x00384519, 0x003F4526, 0x00464930, 0x004B4D37, 0x00464733, 0x00484935, 0x004A4B37, 0x004A4B37, 0x004A4B37,
    0x00494A36, 0x00494A36, 0x004A4B37, 0x004A4934, 0x004F4E3A, 0x004B4C38, 0x00494B37, 0x004E543B, 0x006B7656, 0x006C7953, 0x006A7B50, 0x006E7C52, 0x006E7D51, 0x006E7D51, 0x00717F55, 0x00697454, 0xFFE9EFDC, 0xFFFFFFFC, 0xFFFFFEFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x4896C2EB, 0x005F9FE0, 0x0054A0F2, 0x005BA2EC, 0x0062A7ED, 0x005BA5F3, 0x0059A5F7, 0x00549BE5, 0x00579AE5, 0x005C9FEA, 0x00589CE7, 0x005B9FEA, 0x00599DE8,
    0x00539AE4, 0x00569DE7, 0x00539AE4, 0x005C9DE2, 0x00599BE2, 0x00599DE6, 0x00579BE4, 0x005A9CE3, 0x0063A2E6, 0x004784C2, 0x00124B88, 0x00154470, 0x001D4078, 0x004A78A8, 0x005C97C9, 0x00507EB4, 0x003C5962, 0x003D5336, 0x00394937, 0x0064665A,
    0x00878878, 0x00585945, 0x005C5C44, 0x004B4E35, 0x003B3E28, 0x00444B36, 0x0028331F, 0x002E301A, 0x00333420, 0x004A4A38, 0x00737363, 0x00817F74, 0x0086847A, 0x007B7870, 0x00898580, 0x00898378, 0x00847D74, 0x008A857C, 0x00959087, 0x008F8C84,
    0x0088857D, 0x0095928D, 0x00B2AFAA, 0x00A3A098, 0x004D4E3A, 0x00343721, 0x003C3C30, 0x00333724, 0x0039451B, 0x003C4D1A, 0x005A683E, 0x00667345, 0x00687547, 0x006C794B, 0x00727F53, 0x00515E32, 0x00626E44, 0x00566238, 0x0078845A, 0x00717E58,
    0x006D7B52, 0x00515F35, 0x0057663A, 0x004B5A2E, 0x00657448, 0x006E7D51, 0x006F7E52, 0x00718152, 0x006B7A4E, 0x00748258, 0x00748259, 0x00748259, 0x0078865C, 0x0077865A, 0x00708051, 0x006E844A, 0x006A7E49, 0x00647647, 0x00404C28, 0x004B543A,
    0x00555848, 0x00787970, 0x0083837D, 0x006C705D, 0x006E705D, 0x00727461, 0x00777765, 0x00777563, 0x00706C5A, 0x006B6453, 0x00696251, 0x006D6964, 0x005B5850, 0x006C6961, 0x006E6D63, 0x0056564A, 0x00505344, 0x00505343, 0x00434636, 0x0042442E,
    0x004C4D39, 0x0050503E, 0x006A695B, 0x0067655B, 0x005A5651, 0x005B5653, 0x006C6766, 0x00666459, 0x00545247, 0x0068665C, 0x00716F65, 0x00605E53, 0x004D4D3B, 0x003E4128, 0x0045492C, 0x00666B6C, 0x00AEB4B9, 0x00ACB4BB, 0x00B0BAC1, 0x0096A29C,
    0x00697962, 0x006B7D54, 0x00738550, 0x00717F5B, 0x0075845E, 0x00708455, 0x00657B4B, 0x00687762, 0x00A7AEB7, 0x009EAAAC, 0x006B8067, 0x00697650, 0x00697950, 0x0066794E, 0x0065794F, 0x0062754E, 0x00414E2E, 0x00262D12, 0x003A3D27, 0x00393B1E,
    0x003C3E20, 0x003C3F1F, 0x00393D1A, 0x003C401D, 0x00444628, 0x0047482E, 0x0045452D, 0x00414629, 0x0042452B, 0x0042422A, 0x0045432B, 0x00434226, 0x003D4222, 0x0047522A, 0x005C6B3F, 0x005C6A40, 0x005B6A3E, 0x00596939, 0x005B6B3B, 0x005B693F,
    0x00525D3D, 0x004C523F, 0x0052564B, 0x00485246, 0x004C544A, 0x00546239, 0x00505E2E, 0x00454838, 0x0055594D, 0x003D4834, 0x004E5552, 0x00464F3A, 0x003C4C23, 0x003E4732, 0x00444745, 0x00464C41, 0x00464A44, 0x004C5247, 0x0045562A, 0x00455331,
    0x004C5541, 0x00525650, 0x00494D48, 0x00616958, 0x00646F55, 0x00677357, 0x0049533C, 0x00525853, 0x0067715A, 0x00586839, 0x00465823, 0x00374418, 0x003F4526, 0x00464930, 0x004B4D37, 0x00444531, 0x00464733, 0x00484A34, 0x00494B35, 0x00474933,
    0x00464832, 0x00454731, 0x0045482F, 0x00464530, 0x004B4A35, 0x00494A36, 0x00474A34, 0x004D5439, 0x006A7554, 0x006C7A51, 0x006B7C50, 0x00707E54, 0x006F7E52, 0x006E7D51, 0x00717F55, 0x00687353, 0xFFE8EEDB, 0xFFFFFFFC, 0xFFFFFEFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x4593C1EA, 0x005D9FE0, 0x00539FF1, 0x0059A2EC, 0x0061A6EC, 0x005AA5F3, 0x0059A5F7, 0x00529BE5, 0x00579AE5, 0x005C9FEA, 0x00599DE8, 0x005CA0EB, 0x005B9FEA,
    0x00559CE6, 0x0059A0EA, 0x00569DE7, 0x005C9DE2, 0x005A9CE3, 0x005B9FE8, 0x00589DE6, 0x00599EE4, 0x0061A0E4, 0x00427FBD, 0x000D4683, 0x00154674, 0x00163B75, 0x00426FA2, 0x005792C4, 0x004F7DB3, 0x003D5A63, 0x00415636, 0x003F4E39, 0x005E6054,
    0x007D7E6E, 0x0062614D, 0x006B6B53, 0x005A5A42, 0x003A3D27, 0x00474E39, 0x0038412D, 0x003A3924, 0x002A2915, 0x0042402E, 0x00827F70, 0x0089857A, 0x007E7970, 0x007E7871, 0x00817B76, 0x00888277, 0x00857E75, 0x00858077, 0x008F8A81, 0x008B8880,
    0x00827F77, 0x00928F8A, 0x00B0ADA8, 0x0099968E, 0x00464733, 0x002E301A, 0x00444438, 0x00393B28, 0x003B471D, 0x00404F1C, 0x00647046, 0x006B7949, 0x006C7A4A, 0x006D7A4C, 0x00748153, 0x004B582C, 0x00576438, 0x004E5B2F, 0x007D895F, 0x00717F55,
    0x0067754B, 0x0046542A, 0x005B693F, 0x0057653B, 0x00718054, 0x00758556, 0x00718151, 0x00708050, 0x00728155, 0x0076845B, 0x0077835F, 0x00727E5A, 0x0075835A, 0x0077865A, 0x00798959, 0x0070854E, 0x0070844F, 0x0066774B, 0x00404C28, 0x004B543A,
    0x00555849, 0x008A8B82, 0x00B1B0AC, 0x00B1B5A2, 0x00B6BAA7, 0x00B5B7A4, 0x00A7A795, 0x00949280, 0x00817F6D, 0x00736F5D, 0x006B6453, 0x005C5853, 0x0059564E, 0x007F7C74, 0x00848379, 0x005E5E52, 0x00575A4B, 0x00535646, 0x00353828, 0x0041432D,
    0x00474834, 0x004C4C3A, 0x00676658, 0x0067655B, 0x005D5954, 0x00595451, 0x00686362, 0x0067655A, 0x00545247, 0x0066645A, 0x006F6D63, 0x005E5C51, 0x004C4C3A, 0x003E4128, 0x00464A2D, 0x00686D70, 0x00A9AFB4, 0x00A9B0B9, 0x00ADB8BC, 0x008B9791,
    0x0063735B, 0x006B7E53, 0x006C7F48, 0x00748260, 0x0063724C, 0x006A7F4E, 0x006A814D, 0x00617159, 0x009FA7AE, 0x009EAAAC, 0x006C8069, 0x00697650, 0x0068784F, 0x0065784D, 0x0065794F, 0x0062754E, 0x00404D2D, 0x00262D12, 0x003B3E28, 0x003A3C1F,
    0x003C3E20, 0x003C3F1F, 0x003A3E1B, 0x003C401D, 0x00414325, 0x0043442A, 0x0042422A, 0x0041482D, 0x0044472E, 0x0045452D, 0x0048462E, 0x0045462C, 0x003F4424, 0x0046542B, 0x005B6C41, 0x005D6B42, 0x005D6C40, 0x005B6B3C, 0x005C6C3D, 0x005B6940,
    0x00525C3E, 0x004E5443, 0x00565A4F, 0x00586157, 0x00676E67, 0x00525E3A, 0x00556234, 0x004B4E3F, 0x0054574E, 0x00535D4C, 0x006B7170, 0x005A634F, 0x00374620, 0x004B5440, 0x00505253, 0x0051554F, 0x006D706E, 0x005A5E58, 0x0046562D, 0x00424F2F,
    0x00505847, 0x00525651, 0x006A6D6B, 0x007A8172, 0x00535D46, 0x00606B51, 0x004B543F, 0x00585E59, 0x0068725B, 0x00576738, 0x00465823, 0x00364317, 0x003F4526, 0x00474A31, 0x004A4C36, 0x00474632, 0x00494834, 0x004A4934, 0x004A4A32, 0x0047472F,
    0x0044452B, 0x00424329, 0x00424427, 0x0043432B, 0x00494833, 0x00464832, 0x00454832, 0x004C5338, 0x006A7554, 0x006C7A51, 0x006A7B4F, 0x00717F55, 0x00718054, 0x006F7E52, 0x00717F55, 0x00677252, 0xFFE6ECD9, 0xFFFFFFFC, 0xFFFEFDFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x4593C1EA, 0x005D9FE0, 0x0051A0F1, 0x0059A2EC, 0x0060A6EC, 0x0059A4F2, 0x0056A5F6, 0x00529BE5, 0x00589BE6, 0x005C9FEA, 0x005A9EE9, 0x005DA1EC, 0x005CA0EB,
    0x00569DE7, 0x005AA1EB, 0x00589FE9, 0x0065A8ED, 0x005EA3E9, 0x005A9FE8, 0x00589DE6, 0x005A9FE5, 0x005E9FE3, 0x004483C0, 0x001B5793, 0x001B5186, 0x00174281, 0x0037699E, 0x00508FC2, 0x005282B6, 0x003E5B60, 0x0040522D, 0x0038452B, 0x00616155,
    0x00777767, 0x0064634F, 0x00626048, 0x0056563E, 0x0042442E, 0x00545944, 0x004A533F, 0x0033321D, 0x003B3A26, 0x00393725, 0x005C594A, 0x00827E73, 0x008A857C, 0x00868079, 0x0087817C, 0x00857F74, 0x00847D74, 0x007D786F, 0x00817C73, 0x00817E76,
    0x00838078, 0x0096938E, 0x00A8A5A0, 0x007A746D, 0x00474834, 0x0040422C, 0x0058564B, 0x003E402D, 0x00454F25, 0x00485724, 0x0069754B, 0x006C7C4D, 0x0069794A, 0x00677748, 0x006D7C50, 0x004F5E32, 0x0059673D, 0x004B592F, 0x00738157, 0x006E7D51,
    0x0069774D, 0x0058653F, 0x004F5C36, 0x0065724C, 0x006A784E, 0x00758556, 0x00697949, 0x0057683D, 0x005C6B45, 0x00596547, 0x00657056, 0x005F6A50, 0x00556143, 0x00586741, 0x00617247, 0x006D804F, 0x006B7D4E, 0x006E7F54, 0x00636F4B, 0x00626B50,
    0x0050563F, 0x00676A5A, 0x00878A7B, 0x007B8567, 0x008B9479, 0x00929B80, 0x00889177, 0x007A826B, 0x00747B66, 0x00717863, 0x006E7461, 0x00707566, 0x009CA192, 0x00BCC1B2, 0x00959889, 0x00555849, 0x00444738, 0x004C4C3E, 0x00505042, 0x00444432,
    0x00464636, 0x004B4B3B, 0x00656456, 0x0069675C, 0x00626056, 0x005C5951, 0x006B6762, 0x0069675C, 0x00555348, 0x0066645A, 0x006D6B61, 0x005B594E, 0x00474735, 0x00393C23, 0x00414528, 0x00696E6F, 0x00A5ABB0, 0x00ACB3BC, 0x00B2BCC3, 0x008B9693,
    0x005C6C55, 0x0065774E, 0x00758653, 0x0073815F, 0x006B7955, 0x006F8354, 0x005E7443, 0x00596853, 0x009CA3AC, 0x00A3AEB2, 0x00697D66, 0x00697650, 0x0067774E, 0x0064774C, 0x0065794F, 0x0061744D, 0x003F4C2C, 0x00262D12, 0x003D402A, 0x003B3D20,
    0x003B3D1F, 0x003C3F1F, 0x003B3F1C, 0x003B3F1C, 0x003C3E20, 0x003F4026, 0x0042422A, 0x0042492E, 0x00454930, 0x00484732, 0x00494833, 0x0046472D, 0x003F4526, 0x0047542E, 0x005C6D42, 0x005F6D44, 0x005D6B41, 0x005A6A3B, 0x0059693A, 0x0058663D,
    0x00535D3F, 0x00555B4A, 0x0061645B, 0x00B3BDB7, 0x00BDC3BE, 0x005F6D4B, 0x005A663C, 0x004D4F43, 0x00575B55, 0x009CA696, 0x00C9D0D3, 0x0068735F, 0x003D4E29, 0x004C5743, 0x004B4F50, 0x00767D76, 0x00D1D6D4, 0x008E958E, 0x0036481F, 0x00505C3E,
    0x004C5344, 0x00636664, 0x00C3C6C4, 0x00CCD3C6, 0x00535C47, 0x00505A43, 0x005A634F, 0x005E645F, 0x0069735C, 0x00586839, 0x00475924, 0x00364317, 0x003E4425, 0x00474A31, 0x004A4C36, 0x00494834, 0x004A4935, 0x004A4934, 0x00484830, 0x0045462C,
    0x00424427, 0x00404224, 0x00404323, 0x0042422A, 0x00474631, 0x00454731, 0x00454930, 0x004B5335, 0x00697551, 0x006C7A50, 0x006A7C4D, 0x00717F55, 0x00718054, 0x00718054, 0x00717F55, 0x00657050, 0xFFE3E9D6, 0xFFFEFFFB, 0xFFFEFDFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x4593C1EA, 0x005A9EDF, 0x0051A0F1, 0x0057A2EC, 0x0060A6EC, 0x0057A5F2, 0x0056A5F6, 0x004F9AE4, 0x00599CE7, 0x005DA0EB, 0x005A9EE9, 0x005DA1EC, 0x005CA0EB,
    0x00569DE7, 0x0059A0EA, 0x00579EE8, 0x0061A4E9, 0x005BA0E6, 0x00569BE4, 0x00569BE4, 0x005CA1E7, 0x0062A3E7, 0x005B9AD7, 0x004C88C4, 0x004888C2, 0x004C80C3, 0x00538CC4, 0x005092C7, 0x00497CAE, 0x003B595A, 0x0044572C, 0x00374221, 0x00323226,
    0x00454535, 0x00403F2B, 0x0035331B, 0x003C3A22, 0x00393B25, 0x004F543F, 0x005B6450, 0x00696651, 0x00807C69, 0x00787462, 0x00656051, 0x007A7469, 0x00908980, 0x008A827B, 0x008D8480, 0x00888277, 0x008E877E, 0x00878279, 0x00878279, 0x0088857D,
    0x00908D85, 0x009A9792, 0x00928F8A, 0x00655F58, 0x00686753, 0x0073755F, 0x00747267, 0x003F3F2D, 0x004D572D, 0x0055612F, 0x006B754B, 0x00647347, 0x006D7B51, 0x00748258, 0x006D7B51, 0x004F5D34, 0x0057653C, 0x00505D37, 0x0077845E, 0x00748258,
    0x0067754C, 0x00485430, 0x00566141, 0x00576241, 0x007B8862, 0x00728155, 0x00617141, 0x004B5937, 0x00505B41, 0x0048503F, 0x00676D62, 0x00646A5F, 0x0048503F, 0x00444F35, 0x004C5A38, 0x00707F59, 0x00677650, 0x006D7C56, 0x00727E5A, 0x00626D4C,
    0x004F5738, 0x0051593A, 0x00596142, 0x004E5F34, 0x00506037, 0x004A5C35, 0x003D4E2C, 0x00324425, 0x00304328, 0x0032472E, 0x00344831, 0x002B3E25, 0x0036462E, 0x002D3A24, 0x00202B17, 0x00404635, 0x005B5E4F, 0x00535347, 0x004E4C41, 0x00504E43,
    0x00504E43, 0x00555348, 0x006A685D, 0x0069675C, 0x00615F54, 0x0059574C, 0x0069675C, 0x006E6C61, 0x005B594E, 0x006D6B61, 0x00747268, 0x00615F54, 0x004D4D3B, 0x003D4027, 0x0045492C, 0x00686D6E, 0x00A6ACB1, 0x00AEB5BE, 0x00B5BEC7, 0x009AA4A4,
    0x00667363, 0x005B6A4A, 0x00707F53, 0x00697755, 0x006E7C58, 0x0063764B, 0x004A5E34, 0x006A7769, 0x00A4A9B8, 0x00A1ACB0, 0x00697E65, 0x00697650, 0x0066764D, 0x0063764B, 0x0064784E, 0x0061744D, 0x003F4C2C, 0x00252C11, 0x003D402A, 0x003D3F22,
    0x003A3C1E, 0x003A3D1D, 0x003B3F1C, 0x00393D1A, 0x0037391B, 0x003D3E24, 0x0046462E, 0x0040462D, 0x00454930, 0x00484A34, 0x004A4934, 0x0044472E, 0x003E4425, 0x0046532D, 0x005A6D42, 0x005D6B42, 0x005D6B41, 0x005A693D, 0x0059683C, 0x0058653F,
    0x00545D42, 0x00585E4D, 0x00666960, 0x00E1EAE7, 0x00D8DFDC, 0x00647151, 0x00546239, 0x004C5045, 0x00636762, 0x00AEB8AB, 0x00EDF3F8, 0x006F7A66, 0x00556740, 0x005E6955, 0x005A5F5E, 0x008D958B, 0x00F1F7F2, 0x00A5ADA3, 0x0046592E, 0x00626E52,
    0x00565D4E, 0x006F7171, 0x00D4D6D6, 0x00DAE0D5, 0x0057604B, 0x00525B46, 0x006A735F, 0x00636964, 0x006B755E, 0x00586839, 0x00485A25, 0x00364317, 0x003E4425, 0x00474A31, 0x00494B35, 0x004C4835, 0x004C4835, 0x004B4833, 0x0049482E, 0x00464529,
    0x00434424, 0x00424321, 0x00424321, 0x0043432B, 0x00484830, 0x00464832, 0x00464A31, 0x004C5436, 0x006A7652, 0x006D7B51, 0x006C7E4F, 0x006F7D53, 0x00707F53, 0x00718054, 0x00707E54, 0x00636E4E, 0xFFE1E7D4, 0xFFFDFEFA, 0xFFFFFEFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x4593C1EA, 0x005A9EDF, 0x0051A0F1, 0x0056A1EB, 0x0060A6EC, 0x0057A5F2, 0x0056A5F6, 0x004F9AE4, 0x005A9DE8, 0x005EA1EC, 0x005A9EE9, 0x005DA1EC, 0x005B9FEA,
    0x00549BE5, 0x00579EE8, 0x00559CE6, 0x005C9FE4, 0x005CA1E7, 0x005BA0E9, 0x0058A0E8, 0x00599FE5, 0x005B9CE0, 0x005E9DDA, 0x0064A0DC, 0x004F96D5, 0x0065A0E6, 0x005897D1, 0x003379AE, 0x00255A8C, 0x002E4B48, 0x004A5C2D, 0x003A451F, 0x00535347,
    0x005F5F4F, 0x006B6754, 0x005F5D45, 0x0058563E, 0x00343620, 0x003C412C, 0x006A705D, 0x006F6C57, 0x00676350, 0x00969280, 0x008E897A, 0x00696358, 0x00807970, 0x00958D86, 0x00928985, 0x00938D82, 0x00A09990, 0x009E9990, 0x009C978E, 0x0099968E,
    0x009D9A92, 0x0097948F, 0x0076736E, 0x0069635C, 0x008F8E7A, 0x00A3A28D, 0x00848277, 0x00363624, 0x004D572D, 0x005E6A38, 0x006F794F, 0x006E7C52, 0x006F7D54, 0x006A784F, 0x0056643B, 0x00424F29, 0x00515E38, 0x00495531, 0x00636F4B, 0x006F7D53,
    0x004C5933, 0x00566141, 0x00566042, 0x00555F41, 0x00626E4A, 0x0077855B, 0x005B6B3C, 0x004F5A40, 0x005B6450, 0x005C6158, 0x00919492, 0x00919492, 0x0061665D, 0x004C5541, 0x0049543A, 0x006C7959, 0x00667452, 0x00707E5C, 0x006E7A56, 0x0046532D,
    0x003D4820, 0x003E4A20, 0x00344016, 0x00384C17, 0x002E4410, 0x0022390C, 0x001E360C, 0x001C3612, 0x00173315, 0x00112E14, 0x000B2910, 0x0015300E, 0x00183010, 0x000E2407, 0x0017250D, 0x00404935, 0x00555849, 0x004B493E, 0x00514C43, 0x004B4840,
    0x004E4B43, 0x00555349, 0x0069675C, 0x00676658, 0x00605F51, 0x00595949, 0x006D6D5B, 0x006A685D, 0x0058564B, 0x006B695F, 0x00747268, 0x00626055, 0x004D4D3B, 0x003E4128, 0x0044482B, 0x00696F6E, 0x00A6ADB0, 0x00A8AFB8, 0x00B3BCC6, 0x00B1BABD,
    0x007D897D, 0x004B593D, 0x004C5933, 0x005A6844, 0x00505E3C, 0x00394B24, 0x00425331, 0x0096A199, 0x00B3B7C9, 0x0097A1A8, 0x006E836A, 0x00697650, 0x0066764D, 0x0062754A, 0x0064784E, 0x0061744D, 0x003E4B2B, 0x00252C11, 0x003E412B, 0x003E4023,
    0x00393B1D, 0x00383B1B, 0x003B3F1C, 0x00383C19, 0x00343618, 0x003D3E24, 0x004A4A32, 0x003F452C, 0x00454832, 0x00484A34, 0x004A4934, 0x0043462D, 0x003C4223, 0x0045522C, 0x005A6C43, 0x005B6842, 0x005D6B41, 0x005C6B3F, 0x005D6C40, 0x005B6842,
    0x00555E43, 0x00575C4D, 0x0064675E, 0x00848D8A, 0x00818786, 0x004C583A, 0x00536138, 0x00565950, 0x00606361, 0x005F695D, 0x008D9398, 0x0055614B, 0x004C5E35, 0x005E6A54, 0x005B605E, 0x005B6358, 0x00868D86, 0x005F675D, 0x0053673A, 0x00596549,
    0x005E6558, 0x005C5E5E, 0x00787A7B, 0x007E8479, 0x00424B37, 0x0057604B, 0x005F6756, 0x00666C67, 0x006C765F, 0x0059693A, 0x00485A25, 0x00364317, 0x003E4425, 0x00474A31, 0x00484A34, 0x004B4734, 0x004B4734, 0x004B4833, 0x0048472D, 0x00454527,
    0x00434424, 0x00434422, 0x00444622, 0x0044442C, 0x004A4A32, 0x00474A31, 0x00474B32, 0x004E5638, 0x006C7854, 0x006E7C52, 0x006D7F50, 0x006C7A50, 0x006F7E52, 0x00707F53, 0x00707E54, 0x00626D4D, 0xFFE0E6D3, 0xFFFEFFFB, 0xFFFFFEFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x4594C2EB, 0x005DA1E2, 0x0053A2F3, 0x005AA3ED, 0x0061A6EC, 0x005AA4F2, 0x005BA5F7, 0x00589CE7, 0x005A9EE9, 0x005B9FEA, 0x005DA1EC, 0x005CA0EB, 0x005B9FEA,
    0x005A9EE9, 0x005A9EE9, 0x005A9EE9, 0x0062A1EB, 0x005A9EE9, 0x00559EE8, 0x004F9BE3, 0x005AA2E8, 0x0067A4E6, 0x005587C3, 0x00406BA4, 0x003D6B94, 0x00466F8F, 0x00406272, 0x00344E4E, 0x00172C1D, 0x001A2D14, 0x00556748, 0x003F5330, 0x00616363,
    0x008A8985, 0x00949288, 0x008D8A7B, 0x006A6653, 0x003E3D29, 0x003A3A28, 0x00727461, 0x0087857D, 0x007B7A70, 0x00707064, 0x003F3E30, 0x00383826, 0x00605F4A, 0x007E7E66, 0x0082826A, 0x00807D79, 0x009D9A96, 0x00BFBBBA, 0x00ACA9A5, 0x009B9991,
    0x00858676, 0x0061644E, 0x003C4126, 0x00625F5A, 0x007E7D73, 0x00B1B1A3, 0x00464B36, 0x0042492E, 0x00656E4D, 0x00606D47, 0x006C7A51, 0x006B7C51, 0x006C7D51, 0x006E7E55, 0x00303C20, 0x00383F32, 0x00585E53, 0x004A543D, 0x0054623E, 0x00687652,
    0x00444E37, 0x007E8479, 0x006B7265, 0x00535E44, 0x005B6A44, 0x006D7D54, 0x00677551, 0x00516D6E, 0x00678A98, 0x005B7D94, 0x00638095, 0x00557892, 0x00527B94, 0x005E7D7C, 0x00586342, 0x0067784C, 0x006D7E53, 0x006B7A54, 0x004B5937, 0x005C684A,
    0x00535E44, 0x004C563F, 0x00313A25, 0x00474B32, 0x004E5338, 0x004E5338, 0x00505538, 0x00505637, 0x00454B2C, 0x003E4524, 0x003E4524, 0x00494B3F, 0x00585A4E, 0x00434539, 0x00454539, 0x004E4D43, 0x00545248, 0x004F4D43, 0x00535147, 0x00484A3E,
    0x004B4D41, 0x0054554B, 0x0064655B, 0x0068695F, 0x00595A51, 0x0057584F, 0x00696A61, 0x00656456, 0x005A594B, 0x006B6B5B, 0x00757563, 0x00646551, 0x004D4F39, 0x0042442E, 0x00464930, 0x006F7374, 0x00A9ACB0, 0x00B0B3BB, 0x00B7B9C3, 0x00B6BBC4,
    0x00B0B6BD, 0x00868F92, 0x004E5957, 0x0037453F, 0x0036453D, 0x005A6961, 0x00919D9D, 0x00A6AFB9, 0x00A8B1BB, 0x0099A7A3, 0x006D806D, 0x00687A51, 0x006A7C53, 0x00667851, 0x00697755, 0x00697656, 0x00424C2E, 0x00212A0F, 0x00394228, 0x003C441C,
    0x003B4020, 0x00353920, 0x00393C2C, 0x00393C33, 0x00757672, 0x00BDC0BE, 0x00C2C7C5, 0x0062654F, 0x003D3F29, 0x0042422A, 0x0048472B, 0x0048482A, 0x003C4121, 0x004A5430, 0x005E6D47, 0x005D694B, 0x00667452, 0x005B6B42, 0x005B6C41, 0x00576640,
    0x005B664C, 0x0061675C, 0x00535654, 0x00353B36, 0x00414C38, 0x00566742, 0x004D5F36, 0x00536242, 0x00626E58, 0x00414D37, 0x003F4C34, 0x004B5D36, 0x004F5C42, 0x004B5348, 0x00737B70, 0x0049553F, 0x00364525, 0x004B5B39, 0x00556445, 0x003E4F2A,
    0x006B7564, 0x00666B69, 0x0040493C, 0x0043542F, 0x00576B3E, 0x00455435, 0x005D655B, 0x007A7E7F, 0x00656D5C, 0x005F6D44, 0x00455525, 0x003D4822, 0x00454930, 0x004F4F3D, 0x00484838, 0x004E4C34, 0x0048462E, 0x0054513C, 0x003D3C28, 0x0043422D,
    0x00414228, 0x00393E1E, 0x003A401D, 0x003D4526, 0x00474F31, 0x004A5136, 0x004F583E, 0x004F583E, 0x00657155, 0x006F7C5C, 0x006A7854, 0x00707E5A, 0x00707F59, 0x0073835A, 0x0073825C, 0x00606C4E, 0xFFDEE6D5, 0xFFFDFFFE, 0xFFFDFDFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x4594C2EB, 0x005DA1E2, 0x0054A3F4, 0x005AA3ED, 0x0061A6EC, 0x005AA4F2, 0x005BA5F7, 0x00589CE7, 0x005A9EE9, 0x005CA0EB, 0x005DA1EC, 0x005CA0EB, 0x005B9FEA,
    0x005A9EE9, 0x005A9EE9, 0x005B9FEA, 0x005F9EE8, 0x00589CE7, 0x0057A0EA, 0x0054A0E8, 0x005BA3E9, 0x00609DDF, 0x00467AB6, 0x002F5C95, 0x00687284, 0x005B6471, 0x00444B4E, 0x00393D37, 0x002B2E1F, 0x00313522, 0x00616750, 0x00444C35, 0x003E423C,
    0x006C7065, 0x00929383, 0x007F7E6A, 0x00505038, 0x006B6B53, 0x007F826C, 0x00676C57, 0x005D5D51, 0x00818173, 0x00646456, 0x002D2D1D, 0x00323222, 0x00363624, 0x004A4836, 0x0062614D, 0x00646652, 0x00838572, 0x00939385, 0x00757569, 0x0067675B,
    0x004D4D3F, 0x00323421, 0x002C2E1A, 0x0054524A, 0x0098988C, 0x00656656, 0x002F341F, 0x006C7358, 0x0065704F, 0x006D7A54, 0x00738158, 0x00728358, 0x006F8054, 0x006A7A51, 0x00465236, 0x00697063, 0x0081877C, 0x005F6952, 0x0053613D, 0x006B7955,
    0x004F5942, 0x00979D92, 0x0092998C, 0x0059644A, 0x005B6A44, 0x0076865D, 0x005E6C48, 0x00577677, 0x00779BAB, 0x006F94AA, 0x007494AB, 0x006D92AC, 0x00719DB5, 0x00709291, 0x00586644, 0x00728357, 0x006D7E53, 0x00677551, 0x00434F31, 0x00545E47,
    0x004A5142, 0x00757B70, 0x0081867D, 0x0070725E, 0x00747662, 0x006F715D, 0x006B6D59, 0x006A6C58, 0x00636551, 0x00585A46, 0x0052553F, 0x00555848, 0x00707364, 0x00757869, 0x00767668, 0x005E5E52, 0x00555348, 0x00514F45, 0x004F4D43, 0x00525244,
    0x004C4C3E, 0x00545448, 0x006A6A5E, 0x00717066, 0x00605F55, 0x005E5C54, 0x0074726A, 0x006E6C61, 0x00565449, 0x00525143, 0x00565646, 0x0051513F, 0x00454632, 0x003D3F29, 0x00454731, 0x006A6E6F, 0x00AAADB1, 0x00B4B7BF, 0x00B3B5BF, 0x00AEB3BC,
    0x00B4BAC1, 0x00B3BCBF, 0x00ABB5B5, 0x00A9B6B4, 0x00A5B3AD, 0x00AAB8B2, 0x00B1BCC0, 0x00AEB6C3, 0x00B1B9C6, 0x009DAAA8, 0x00647665, 0x00687A51, 0x006A7C53, 0x00667851, 0x00687654, 0x00687555, 0x00424C2E, 0x00212A0F, 0x003A4329, 0x00394119,
    0x003A3F1F, 0x003C4027, 0x00393C2D, 0x00A5A89F, 0x00FFFFFC, 0x00FDFFFC, 0x00C3C8C6, 0x00585B45, 0x003F412B, 0x0044442C, 0x0046452B, 0x00464628, 0x003B4020, 0x0048522E, 0x005F6E48, 0x005B6947, 0x0064734D, 0x005F7045, 0x00637449, 0x00586642,
    0x00555F48, 0x0071766D, 0x005F6161, 0x002F362F, 0x003B4534, 0x00505E42, 0x004A583C, 0x006A7463, 0x006B7369, 0x00353D32, 0x00374130, 0x00495A35, 0x00515C48, 0x00585E59, 0x00757A79, 0x00576053, 0x0035422A, 0x00445236, 0x0057644A, 0x004C5645,
    0x00737876, 0x0066696D, 0x00363E34, 0x00394828, 0x0061734C, 0x005E6A54, 0x006F7473, 0x0085898A, 0x00555D4C, 0x0057653C, 0x00495929, 0x003B4620, 0x003F432A, 0x004B4B39, 0x00484838, 0x0046472D, 0x0052523A, 0x00454632, 0x00474735, 0x006A6A58,
    0x00383A26, 0x00252910, 0x00282D12, 0x00363C25, 0x00454A35, 0x00464B36, 0x00484F3A, 0x004E563F, 0x006C785C, 0x00758361, 0x006D7C56, 0x00707E5A, 0x00707F59, 0x0073835A, 0x0073825C, 0x00606C4E, 0xFFDEE6D5, 0xFFFCFFFD, 0xFFFDFDFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x4594C2EB, 0x005CA0E1, 0x0054A3F4, 0x005BA4EE, 0x0062A7ED, 0x005BA5F3, 0x005CA6F8, 0x00589CE7, 0x005B9FEA, 0x005CA0EB, 0x005DA1EC, 0x005DA1EC, 0x005B9FEA,
    0x005A9EE9, 0x005A9EE9, 0x005B9FEA, 0x005FA0EA, 0x005A9EE9, 0x0059A2EC, 0x0056A0E8, 0x005BA1E7, 0x005F9FE0, 0x00528AC5, 0x004A7BB3, 0x005282AC, 0x004D7B9D, 0x00466F86, 0x0046656E, 0x003B5349, 0x003B4B33, 0x00676F4A, 0x00555C2F, 0x00293323,
    0x00404935, 0x0051553C, 0x0043472A, 0x00555739, 0x00ADB293, 0x00BCC1A4, 0x006C755A, 0x004D523D, 0x00505540, 0x008C8E7B, 0x00757666, 0x00403F31, 0x00333224, 0x00363429, 0x00383429, 0x00414728, 0x00383D22, 0x00555842, 0x00838474, 0x008A8A7E,
    0x00515145, 0x003A3A2C, 0x005F6050, 0x00A9A99D, 0x00727264, 0x003A3E2B, 0x004D533A, 0x006E785A, 0x00697453, 0x00798660, 0x006C7C53, 0x0067784D, 0x00708155, 0x006D7D54, 0x004A563A, 0x00666D60, 0x006E7469, 0x0058624B, 0x005D6B47, 0x00697753,
    0x004D5740, 0x007B8176, 0x007B8275, 0x0049543A, 0x00596842, 0x0074845B, 0x005A6844, 0x004F7275, 0x00719AA9, 0x006F98AF, 0x007499AF, 0x006F97B3, 0x00709FBA, 0x00668C8C, 0x00465938, 0x0067784D, 0x006B7B52, 0x006F7D5B, 0x004B573B, 0x004D5642,
    0x00444A3F, 0x00858983, 0x00A7AAA8, 0x00B4B9A4, 0x00B1B5A2, 0x00A0A491, 0x00878A7A, 0x00797C6D, 0x006E7162, 0x00616357, 0x005B5D51, 0x00505742, 0x00727663, 0x008C907D, 0x008B8E7E, 0x00606052, 0x00535345, 0x00535146, 0x0049473C, 0x004C4D3D,
    0x004B4C3C, 0x00535444, 0x00626254, 0x00636355, 0x0057574B, 0x005A5A4E, 0x006F6F63, 0x006D6B61, 0x0058564C, 0x004D4B40, 0x004E4D3F, 0x00535343, 0x004C4C3A, 0x00424230, 0x004C4D39, 0x004B504F, 0x00989C9D, 0x00B6BABF, 0x00BABDC5, 0x00B4B9C2,
    0x00AEB4BB, 0x00AEB7BA, 0x00BAC4C4, 0x00B0BBBF, 0x00B1BDBD, 0x00AFBBBB, 0x00A9B2BB, 0x00A4ABBC, 0x00B0B7C6, 0x00A0ACAC, 0x00657668, 0x00697B52, 0x006A7C53, 0x00667851, 0x00687654, 0x00687555, 0x00424C2E, 0x00222B10, 0x003A4329, 0x00404722,
    0x003B4021, 0x0050533D, 0x00333627, 0x00888B82, 0x00BDBFB9, 0x00B9BDB8, 0x00565C57, 0x00464834, 0x0042442E, 0x0047472F, 0x0046452B, 0x00464628, 0x003A3F1F, 0x0046502C, 0x00606E4A, 0x005E6E45, 0x00607146, 0x005A6B3F, 0x00607047, 0x005C6949,
    0x006B7460, 0x00B5B9B3, 0x00939596, 0x00667060, 0x004C5842, 0x0057644C, 0x005C6656, 0x00A1A6A5, 0x00A3A6AA, 0x00606563, 0x00525B4E, 0x0052633E, 0x00535E4A, 0x007E8283, 0x00A9ACB1, 0x00828883, 0x00505B47, 0x00505D43, 0x00576549, 0x005C6061,
    0x00B0B1BB, 0x009EA0A8, 0x004D554A, 0x00445333, 0x00657553, 0x006D7766, 0x009B9EA2, 0x00B9BDBE, 0x00545D49, 0x004F5D34, 0x004C5C2C, 0x0038431B, 0x003C4027, 0x00474735, 0x00484836, 0x004D5237, 0x0050533D, 0x00383C29, 0x005D6051, 0x0092968A,
    0x00363A2E, 0x002F3425, 0x00323A29, 0x0055564C, 0x00505147, 0x0043443A, 0x00494E3F, 0x00565D48, 0x006B775B, 0x006B7955, 0x006C7D52, 0x006F7D59, 0x006F7E58, 0x0073835A, 0x0072815B, 0x005F6B4D, 0xFFDDE5D4, 0xFFFCFFFD, 0xFFFCFCFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x4593C1EA, 0x005CA0E1, 0x0054A3F4, 0x005BA4EE, 0x0063A8EE, 0x005BA5F3, 0x005CA6F8, 0x00589CE7, 0x005B9FEA, 0x005CA0EB, 0x005EA2ED, 0x005DA1EC, 0x005CA0EB,
    0x005B9FEA, 0x005B9FEA, 0x005CA0EB, 0x005FA3EC, 0x005B9FEA, 0x005BA2EC, 0x00569EE6, 0x00599EE4, 0x0063A3E4, 0x00639FDA, 0x0069A1D8, 0x00499EE2, 0x004C9CDB, 0x004C97CB, 0x004585A7, 0x0031636F, 0x00294B40, 0x00556A49, 0x005B6A3E, 0x004C5B40,
    0x00333F23, 0x00444D2C, 0x00464E29, 0x003A411C, 0x007C845F, 0x0098A180, 0x00505B3B, 0x00586042, 0x0040482A, 0x004C5239, 0x00888A76, 0x00959686, 0x00615F54, 0x00535048, 0x003D3934, 0x00393C26, 0x0030321F, 0x00525244, 0x00818076, 0x008B8981,
    0x00828177, 0x0096968A, 0x00B8B8AA, 0x005F6350, 0x00373C27, 0x00454B34, 0x005F684D, 0x006D7858, 0x007C8864, 0x00708057, 0x006E7F54, 0x006C7D52, 0x00728357, 0x006F7F56, 0x00445034, 0x00555C4F, 0x0051574C, 0x00434D36, 0x00596743, 0x00667450,
    0x00454F38, 0x0052584D, 0x004F5649, 0x003F4A30, 0x0065744E, 0x00718158, 0x0065734F, 0x005C8286, 0x0075A1B2, 0x00719DB5, 0x00789EB6, 0x006E9AB7, 0x006D9FBB, 0x006B9294, 0x005A6F4F, 0x006D7F56, 0x006C7E57, 0x00697A55, 0x004F5E3E, 0x004A583C,
    0x0058654D, 0x005F6A56, 0x005D6756, 0x00778065, 0x00828B70, 0x008A9379, 0x00848C75, 0x007F8671, 0x00787E6B, 0x006E7463, 0x006F7465, 0x00737C61, 0x0097A086, 0x00B2BAA3, 0x009FA48F, 0x00595D4A, 0x00464737, 0x004F4F41, 0x00535347, 0x00494B37,
    0x004C4E3A, 0x004E503D, 0x004E503D, 0x004E4F3F, 0x004F5040, 0x00535444, 0x0059594B, 0x0057554B, 0x00514F45, 0x004D4B40, 0x004E4D3F, 0x00555545, 0x004B4B3B, 0x0040402E, 0x004F4F3D, 0x003E443F, 0x00888D8C, 0x00AEB3B6, 0x00B5B8C0, 0x00B9BFC6,
    0x00B2B8BF, 0x00A8B1B5, 0x00B0B9BC, 0x00B1BAC3, 0x00AEB9BD, 0x00ACB7BB, 0x00ACB5BF, 0x00A7ADC0, 0x00A9B0C1, 0x0098A4A4, 0x00657668, 0x00677950, 0x006A7C53, 0x00667851, 0x00697755, 0x00697656, 0x00424C2E, 0x00212A0F, 0x00394228, 0x00414724,
    0x00373B1E, 0x0051543E, 0x0056594A, 0x0094978E, 0x00A8AAA4, 0x00A9ADA7, 0x00525952, 0x00323420, 0x0042432F, 0x004A4934, 0x0048472D, 0x0048472B, 0x003C4122, 0x00444D2C, 0x00606E4A, 0x00637546, 0x005F7142, 0x00596A3E, 0x005B6A44, 0x005F6B4D,
    0x00929A89, 0x00FDFFFC, 0x00BBBDBE, 0x00647151, 0x0052603E, 0x00616D51, 0x007C8376, 0x00F1F3F4, 0x00DDDEE2, 0x006A6F66, 0x00505944, 0x005D6E42, 0x005C674D, 0x00B6BAB5, 0x00FDFFFF, 0x00A3A89F, 0x00626D53, 0x004E5C3A, 0x0042502C, 0x006F6E77,
    0x00FBFAFF, 0x00D3D5D5, 0x0059624D, 0x0052613B, 0x0061704A, 0x006B745F, 0x00D2D5D3, 0x00FAFFFE, 0x00626B57, 0x004C5A30, 0x004B5B2B, 0x0037421A, 0x003F4429, 0x00484935, 0x00484836, 0x00424B30, 0x002D351E, 0x00393E2F, 0x00555A51, 0x005F635D,
    0x00414742, 0x00999F9A, 0x00777E77, 0x00878585, 0x00747271, 0x0052514D, 0x0045483F, 0x00535946, 0x006E7A5C, 0x006B7A54, 0x006D7E52, 0x006F7D59, 0x006F7E58, 0x0073835A, 0x0072815B, 0x005F6B4D, 0xFFDDE5D4, 0xFFFCFFFD, 0xFFFCFCFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x4192C0E9, 0x005CA0E1, 0x0054A3F4, 0x005CA5EF, 0x0064A9EF, 0x005CA6F4, 0x005DA7F9, 0x00599DE8, 0x005CA0EB, 0x005DA1EC, 0x005EA2ED, 0x005EA2ED, 0x005CA0EB,
    0x005B9FEA, 0x005B9FEA, 0x005CA0EB, 0x005CA1EA, 0x00599DE8, 0x005CA0EB, 0x005A9FE8, 0x005BA0E6, 0x005EA0E1, 0x005494CE, 0x00508EC4, 0x00568CC1, 0x00558EC2, 0x005A93C6, 0x005C90BE, 0x005682A1, 0x00486873, 0x005C7169, 0x00606C5A, 0x00495C3B,
    0x00586944, 0x005B6940, 0x00556137, 0x00596339, 0x00515C34, 0x0053603A, 0x0064724E, 0x0076835D, 0x006E7A56, 0x00586041, 0x003C4328, 0x00868874, 0x00BCBDAD, 0x00A2A095, 0x008D8B81, 0x0083807C, 0x00706C6B, 0x007B7776, 0x00AEAAA9, 0x00D6D3CE,
    0x00D1D0C6, 0x00919282, 0x00464834, 0x00363C25, 0x00494F36, 0x0050593E, 0x006C7757, 0x00778261, 0x0074835D, 0x00718158, 0x00738459, 0x0074855A, 0x006D7E52, 0x006A7A51, 0x00414D31, 0x004E5548, 0x00454B40, 0x00404A33, 0x0055633F, 0x00667450,
    0x00414B34, 0x00595F54, 0x004E5548, 0x00323D23, 0x005D6C46, 0x006E7E55, 0x00687652, 0x005C8287, 0x006F9AAD, 0x006994AF, 0x006C94AD, 0x006591B0, 0x006B9DB9, 0x006A9396, 0x005E7457, 0x006C7E57, 0x006F815A, 0x006F815A, 0x00687A53, 0x0051633A,
    0x007F9168, 0x005D6F46, 0x0055673E, 0x0073805A, 0x0076835D, 0x007A8662, 0x00747F5E, 0x00747F5E, 0x00758060, 0x00717B5D, 0x007C8668, 0x006B7957, 0x006D7858, 0x00677153, 0x005E674D, 0x004D533C, 0x00555946, 0x00515242, 0x00454537, 0x0052553C,
    0x004D5037, 0x00474933, 0x00444630, 0x00484935, 0x004E4F3B, 0x0050513D, 0x004D4D3B, 0x004C4A3F, 0x004E4C41, 0x004E4D3F, 0x004C4C3C, 0x00515141, 0x00484836, 0x003E3F2B, 0x0050513D, 0x00454D43, 0x00838984, 0x00AEB3B4, 0x00B0B4B9, 0x00B6BCC3,
    0x00B7BDC4, 0x00B0B9BD, 0x00B5BEC1, 0x00B2BBC5, 0x00ADB7BE, 0x00ABB6BA, 0x00ADB6C0, 0x00A9AFC2, 0x00A8AFBE, 0x0098A5A3, 0x006D7F6E, 0x0066784F, 0x00697B52, 0x00677952, 0x006B7957, 0x006A7757, 0x00434D2F, 0x0020290E, 0x00374026, 0x00414627,
    0x003D4026, 0x003F412D, 0x00434637, 0x00787C71, 0x0093968D, 0x005A5F56, 0x00151D12, 0x00232512, 0x0042432F, 0x004B4A35, 0x004B4931, 0x004B4A2E, 0x003F4425, 0x00444D2C, 0x00606E4A, 0x00617344, 0x00627347, 0x005F7045, 0x00576541, 0x00566147,
    0x00969E8D, 0x00FDFFF9, 0x00A0A3A1, 0x004F6132, 0x005A6C3D, 0x005B6A44, 0x006F7863, 0x00F8FCF6, 0x00D7DBD5, 0x0057604B, 0x0055633F, 0x005F723F, 0x005C6A48, 0x00AEB5A6, 0x00FDFFF8, 0x007B846F, 0x004D5B37, 0x00435429, 0x004D5E33, 0x006E716F,
    0x00FDFFFB, 0x00C8D0BF, 0x0052603E, 0x005F7142, 0x00647549, 0x00626E52, 0x00D3DACD, 0x00FBFFFF, 0x005F6853, 0x004B592F, 0x004C5D2A, 0x003A461C, 0x0044492E, 0x004A4B37, 0x00494A36, 0x0039412A, 0x004E5441, 0x00767D70, 0x003B3F39, 0x000E1311,
    0x00676C6A, 0x00FAFFFE, 0x00878E8B, 0x00858284, 0x00A9A6A8, 0x00A2A09F, 0x006C6F66, 0x00505645, 0x006A7658, 0x006F7F56, 0x00718354, 0x006F7D59, 0x006F7E58, 0x0073835A, 0x0072815B, 0x00606C4E, 0xFFDEE6D5, 0xFFFCFFFD, 0xFFFDFDFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x4192C0E9, 0x005B9FE0, 0x0054A3F4, 0x005DA6F0, 0x0064A9EF, 0x005DA7F5, 0x005DA7F9, 0x00599DE8, 0x005CA0EB, 0x005EA2ED, 0x005FA3EE, 0x005EA2ED, 0x005DA1EC,
    0x005CA0EB, 0x005CA0EB, 0x005DA1EC, 0x005FA4ED, 0x00599DE8, 0x005A9DE8, 0x005A9EE7, 0x0061A3EA, 0x005EA0E1, 0x003F84BD, 0x002A6EA3, 0x003773A1, 0x002B6B9B, 0x002A6C9D, 0x00316F98, 0x00477990, 0x004F7171, 0x006A7A62, 0x007D8059, 0x00718862,
    0x0074885E, 0x007D8E63, 0x00818E62, 0x00818E62, 0x0076845A, 0x0076855F, 0x00788964, 0x006E7C52, 0x00808E64, 0x007A8761, 0x006D7655, 0x00596143, 0x00575B42, 0x009A9C88, 0x00B5B7A4, 0x009B9894, 0x00A3A09C, 0x00A7A4A0, 0x00AFACA7, 0x00919185,
    0x005E604D, 0x003D4227, 0x003C4223, 0x00575F41, 0x00505A3C, 0x00495434, 0x00586342, 0x0052613B, 0x004C5C33, 0x0055683D, 0x004D6035, 0x004F6035, 0x00495A2E, 0x004E5E35, 0x00485438, 0x0062695C, 0x00565C51, 0x005D6750, 0x00566440, 0x006C7A56,
    0x0058624B, 0x00989E93, 0x00959C8F, 0x00586349, 0x0062714B, 0x0077875E, 0x0062704C, 0x00587C84, 0x006E99AE, 0x006E96B3, 0x007095B1, 0x006C95B6, 0x0071A3C1, 0x00648A8F, 0x004B5E43, 0x00687A51, 0x0071835A, 0x00798B62, 0x0074865D, 0x003F5128,
    0x00677950, 0x004A5C33, 0x0056693E, 0x00687652, 0x0066754F, 0x006A7953, 0x0065744E, 0x006F7F56, 0x0078885F, 0x006D7E53, 0x00708156, 0x006D7D54, 0x006F7E58, 0x006A7554, 0x005C6648, 0x00475036, 0x004F543F, 0x004B4F3C, 0x00505343, 0x004C5033,
    0x0045482E, 0x0045482E, 0x00484B31, 0x0042452C, 0x003E4128, 0x00484A34, 0x0053553F, 0x00505040, 0x00535343, 0x00535341, 0x0050513D, 0x00555741, 0x004D4F39, 0x0040432A, 0x004C4F35, 0x00424A3F, 0x007B827B, 0x00BAC0BF, 0x00BCC1C4, 0x00B1B7BE,
    0x00B0B6BD, 0x00ADB5BC, 0x00AFB8BC, 0x00A6AFB9, 0x00AAB5B9, 0x00A9B4B8, 0x00A7B0B9, 0x00A4ABBA, 0x00A7B0BA, 0x0095A39D, 0x00667964, 0x0066784F, 0x00697B52, 0x00677952, 0x006B7957, 0x006A7757, 0x00434D2F, 0x0020290E, 0x00374026, 0x00414528,
    0x00404329, 0x004C4E3A, 0x002A2D1E, 0x00303429, 0x007E8178, 0x00494F44, 0x00151E11, 0x00232512, 0x00454533, 0x004A4935, 0x004C4A32, 0x004B4A30, 0x00414528, 0x00464F2E, 0x00606E4C, 0x005E6F44, 0x0063734A, 0x005C6A46, 0x004D5A3A, 0x00404B31,
    0x006F7864, 0x00BCC3B4, 0x006F7669, 0x00677748, 0x00576737, 0x004E5C32, 0x0050593E, 0x00A2A798, 0x00A2A798, 0x00636D4F, 0x00606F43, 0x00455526, 0x004B5636, 0x00808673, 0x00C7CDBA, 0x006E785A, 0x004F5D34, 0x0039471E, 0x0045512D, 0x00595E4F,
    0x00B9BFAC, 0x008E977C, 0x0046532D, 0x0057663A, 0x005C6A41, 0x00535C41, 0x009AA08D, 0x00BCC1BF, 0x0049523D, 0x004E5D31, 0x0050612E, 0x003E4A20, 0x00474C2F, 0x004C4D39, 0x004C4D39, 0x00444835, 0x00787D6E, 0x00AAAEA3, 0x00939490, 0x00888B89,
    0x00878B86, 0x00A5ACA5, 0x00565D56, 0x00656362, 0x009B9998, 0x00AEADA9, 0x007E8277, 0x00555B48, 0x00657153, 0x006A7A51, 0x00708155, 0x00707E5A, 0x00707F59, 0x0073835A, 0x0073825C, 0x00606C4E, 0xFFDEE6D5, 0xFFFDFFFE, 0xFFFDFDFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x4191BFE8, 0x005B9FE0, 0x0054A3F4, 0x005DA6F0, 0x0065AAF0, 0x005DA7F5, 0x005DA7F9, 0x00599DE8, 0x005DA1EC, 0x005EA2ED, 0x005FA3EE, 0x005FA3EE, 0x005DA1EC,
    0x005CA0EB, 0x005CA0EB, 0x005DA1EC, 0x005FA7EF, 0x005B9FEA, 0x005B9EE9, 0x005A9BE5, 0x0062A2E9, 0x005DA1E2, 0x003D84BD, 0x00216A9E, 0x001C72A8, 0x001771A8, 0x001D77AE, 0x002277A5, 0x003D8099, 0x0049756F, 0x00617552, 0x00797F48, 0x006D855D,
    0x00798F65, 0x00778B5E, 0x00708051, 0x00808F63, 0x0078865D, 0x006D7E59, 0x00728361, 0x007A8A5B, 0x00718054, 0x00758359, 0x00738158, 0x007F8A64, 0x00737C5B, 0x00696F50, 0x00666C4D, 0x003A4021, 0x00393E21, 0x002D3217, 0x003C4027, 0x0044492E,
    0x004B5132, 0x004F5633, 0x00545D35, 0x004C5736, 0x00667150, 0x00717D59, 0x00586642, 0x0062714B, 0x0064764D, 0x005C6F44, 0x005D7045, 0x00607146, 0x005E6F43, 0x0057673E, 0x00727E62, 0x0091988B, 0x00757B70, 0x008B957E, 0x0055633F, 0x00677551,
    0x005F6952, 0x006E7469, 0x0062695C, 0x004F5A40, 0x0045542E, 0x005C6C43, 0x0052603C, 0x0050717A, 0x00648AA2, 0x00658BAB, 0x006A8CAA, 0x00648AAC, 0x006491B2, 0x0052767C, 0x00404F34, 0x005D7245, 0x00596D42, 0x00586B44, 0x00526342, 0x00314024,
    0x004D5A44, 0x0045513F, 0x00424D3D, 0x004C5941, 0x0048553B, 0x00465438, 0x003A4929, 0x004F603B, 0x0071835A, 0x0073865B, 0x00778B5E, 0x00728357, 0x006B7C51, 0x00677650, 0x00616C4B, 0x004C553A, 0x0050563F, 0x00474B38, 0x00484C39, 0x00444628,
    0x00424426, 0x004A4C2F, 0x004D4F32, 0x00404127, 0x0037381E, 0x0044452B, 0x0054553B, 0x004C4D39, 0x004D4F39, 0x004E503A, 0x004B4E35, 0x004D5036, 0x00474B2E, 0x003C4122, 0x00424728, 0x00434C3F, 0x006B7369, 0x00B7BEBB, 0x00BDC2C5, 0x00A5ABB2,
    0x00A2A8AF, 0x00A7AFB6, 0x00A9B2B6, 0x00A1AAB3, 0x00ACB8BA, 0x00AFBBBB, 0x00AFB9C0, 0x00AEB6C3, 0x00B0BAC1, 0x009CACA1, 0x006C8266, 0x00687A51, 0x006A7C53, 0x00667851, 0x00697755, 0x00687555, 0x00424C2E, 0x00212A0F, 0x00394228, 0x0043472A,
    0x0033361D, 0x0040422F, 0x002D2F23, 0x001B1F14, 0x00676B60, 0x00545B4E, 0x00182114, 0x002E2F1F, 0x004B4B39, 0x00474632, 0x00494631, 0x0046452B, 0x00404427, 0x00485031, 0x0062704E, 0x0062704C, 0x0062704E, 0x004F5C3C, 0x00485438, 0x003E492F,
    0x004A543D, 0x00707A63, 0x005B654E, 0x005B6547, 0x0044502C, 0x004E5A36, 0x004E573D, 0x00575C4D, 0x006A6F60, 0x0060694E, 0x004D5B31, 0x00565F45, 0x00555B4A, 0x005E6256, 0x007A806F, 0x00616A4F, 0x00535E3E, 0x00475036, 0x00484E3D, 0x004E5441,
    0x006D755E, 0x00535C41, 0x003C4628, 0x00434C31, 0x004B533C, 0x00494F3E, 0x0065695D, 0x00767B79, 0x003C4530, 0x0057663A, 0x0051632E, 0x003F4C20, 0x00474C2F, 0x004D4F39, 0x004E4F3B, 0x00545446, 0x0057564C, 0x0067685F, 0x00B3B3AD, 0x00DCDED8,
    0x00666960, 0x004A4E42, 0x00818677, 0x0054554C, 0x0057584F, 0x005B5C52, 0x004F5445, 0x004F5641, 0x006F7B5D, 0x006E7D57, 0x006F8054, 0x00717F5B, 0x0071805A, 0x0074845B, 0x0074835D, 0x00616D4F, 0xFFDFE7D6, 0xFFFDFFFE, 0xFFFDFDFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x4191BFE8, 0x005B9FE0, 0x0054A3F4, 0x005DA6F0, 0x0065AAF0, 0x005EA8F6, 0x005EA8FA, 0x00599DE8, 0x005DA1EC, 0x005EA2ED, 0x005FA3EE, 0x005FA3EE, 0x005EA2ED,
    0x005CA0EB, 0x005DA1EC, 0x005DA1EC, 0x0059A1E9, 0x005CA0EB, 0x0060A3EE, 0x005D9CE6, 0x005E9EE5, 0x005B9FE0, 0x003D87BF, 0x002470A4, 0x003A76A0, 0x003375A6, 0x003079B3, 0x002872AC, 0x003878A8, 0x003C6C84, 0x004F6C69, 0x006B7967, 0x00708A62,
    0x00697F55, 0x00798D60, 0x007A8B5F, 0x00748357, 0x006F7F56, 0x00778863, 0x00697A59, 0x006E8051, 0x00748455, 0x00738256, 0x00738256, 0x0078845A, 0x00747F57, 0x00858E66, 0x00757E56, 0x0074834A, 0x0067753F, 0x005D6939, 0x006B754A, 0x005F693F,
    0x00677147, 0x00737D52, 0x006C764B, 0x00616D49, 0x005E6A46, 0x00586642, 0x0055643E, 0x005F6F46, 0x004A5D32, 0x0054673C, 0x0054673C, 0x004F6035, 0x005C6D41, 0x0047572E, 0x00626E52, 0x006A7164, 0x00464C41, 0x00949E87, 0x00677551, 0x00687652,
    0x00768069, 0x00464C41, 0x003E4538, 0x00808B71, 0x0061704A, 0x0055653C, 0x0052603C, 0x0052707B, 0x00587C94, 0x00547798, 0x005A7998, 0x00507498, 0x00517C9D, 0x0050717A, 0x0055624A, 0x005A7040, 0x00586C41, 0x00576846, 0x004C5A42, 0x00495346,
    0x00626867, 0x007F8388, 0x006E707B, 0x00788076, 0x00798176, 0x00727C6B, 0x0054604A, 0x005B6A4B, 0x007A8A68, 0x0074865D, 0x006F8257, 0x00738758, 0x006F8054, 0x0076865D, 0x006E7C58, 0x004E583A, 0x004A5339, 0x00454A35, 0x00484C39, 0x00494C2C,
    0x00454828, 0x00484A2C, 0x00494B2D, 0x0045472A, 0x0045472A, 0x00494A30, 0x0046472D, 0x004A4D34, 0x00494C33, 0x004A4D33, 0x0043472A, 0x00414627, 0x00404525, 0x003C4121, 0x00464C29, 0x00475141, 0x005B6358, 0x00A7AEA9, 0x00B2B7BA, 0x00969CA3,
    0x0090969D, 0x00939BA2, 0x008E969D, 0x00909AA1, 0x0096A2A4, 0x009AA7A5, 0x00A0ABAF, 0x00A2ABB4, 0x00A3AEB2, 0x0093A496, 0x006B8164, 0x006A7C53, 0x006B7D54, 0x00657750, 0x00677553, 0x00667353, 0x00414B2D, 0x00222B10, 0x003B442A, 0x004A4D33,
    0x00454731, 0x0040422F, 0x0064665A, 0x0071756A, 0x0074786D, 0x0060675A, 0x001E2818, 0x00383929, 0x004F4F3D, 0x00454430, 0x0046432E, 0x00414026, 0x003E4225, 0x004A5233, 0x00647250, 0x006B7858, 0x00636F51, 0x00475337, 0x004F5A40, 0x00505A43,
    0x003E492F, 0x00445034, 0x005C684A, 0x004D5243, 0x005E6550, 0x00677056, 0x00555B48, 0x0044483D, 0x0052564B, 0x005B624D, 0x00667150, 0x00666960, 0x005F605C, 0x005A5B59, 0x004D5146, 0x00555C47, 0x00525A43, 0x0065695E, 0x00606060, 0x00545A47,
    0x004E5540, 0x00424934, 0x00515746, 0x00595D51, 0x005F615B, 0x00555751, 0x0052534F, 0x00595E5C, 0x00404A33, 0x005F6E42, 0x004F612C, 0x003D4A1E, 0x00474C2F, 0x004E503A, 0x0050523C, 0x004E4C42, 0x00545149, 0x00514E49, 0x006F6C67, 0x00737169,
    0x002B2D21, 0x00393C2C, 0x005E634E, 0x00434637, 0x00454839, 0x004E5142, 0x00474D3C, 0x004A523B, 0x00717D5F, 0x0072815B, 0x00708156, 0x00717F5B, 0x0071805A, 0x0075855C, 0x0074835D, 0x00616D4F, 0xFFDFE7D6, 0xFFFDFFFE, 0xFFFDFDFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x3189BDF2, 0x00659FDA, 0x0061A7EA, 0x005EABF4, 0x0057A7F4, 0x0058A6F2, 0x0063AAF4, 0x00579CE2, 0x005C9FEA, 0x0062A5F0, 0x005FA2ED, 0x005DA0EB, 0x005EA1EC,
    0x005B9EE9, 0x005C9FEA, 0x0060A3EE, 0x005FA0F1, 0x005B9DEC, 0x005FA3EE, 0x005DA3E9, 0x005EA5E5, 0x005EA2DD, 0x004686BC, 0x003372A5, 0x002D7CA5, 0x00327EAF, 0x003379B4, 0x003D7CB6, 0x004C81A6, 0x004D7A7D, 0x00587B59, 0x00719158, 0x0074895C,
    0x00728858, 0x00798D5E, 0x007A8F5E, 0x00748A56, 0x00748853, 0x00768A55, 0x00728651, 0x0074855A, 0x00738459, 0x00728358, 0x00718257, 0x00718257, 0x00738459, 0x0074855A, 0x0075865B, 0x0076875C, 0x00738459, 0x0076875C, 0x0077885D, 0x00728358,
    0x0074855A, 0x00798A5F, 0x0077885D, 0x007D8C66, 0x0076855F, 0x007A8963, 0x007A8963, 0x0073825C, 0x0075845E, 0x00778660, 0x0072815B, 0x007A8963, 0x0074835D, 0x006A7953, 0x0061704A, 0x005D6C46, 0x005D6C46, 0x0061704A, 0x0064734D, 0x006D7D54,
    0x00526239, 0x004D5D34, 0x005C6C43, 0x006E7E55, 0x005E6E45, 0x0056663D, 0x0053633A, 0x005D6D5C, 0x00586857, 0x00485847, 0x00738372, 0x00586857, 0x00465645, 0x00879786, 0x00637362, 0x00576B3E, 0x00576A3F, 0x005E6F4A, 0x00566546, 0x005E6A54,
    0x00818B7B, 0x00848C82, 0x006F766F, 0x0081857F, 0x008E938A, 0x005E6556, 0x00838C77, 0x00778365, 0x0074825E, 0x0076865D, 0x00718256, 0x0077875E, 0x0078885F, 0x0077875E, 0x0073835A, 0x006D7D54, 0x0068784F, 0x0065754C, 0x0064744B, 0x0062744D,
    0x0061734C, 0x0060724B, 0x005F714A, 0x005E7049, 0x005E7049, 0x005E7049, 0x005E7049, 0x0061724D, 0x0061724D, 0x0061724D, 0x0060714C, 0x0060714C, 0x005F704B, 0x005F704B, 0x005F704B, 0x00606F53, 0x00667559, 0x00758468, 0x007E8D71, 0x007B8A6E,
    0x0079886C, 0x007A896D, 0x00758468, 0x00778863, 0x00768762, 0x00758661, 0x00758661, 0x00768762, 0x00758661, 0x0072835E, 0x0070815C, 0x006E8156, 0x006F8257, 0x00697B54, 0x006A7A58, 0x006A795A, 0x00414E34, 0x001F2C14, 0x0037432D, 0x00404B2B,
    0x00394228, 0x00757A6B, 0x00ABAEA5, 0x008C8F86, 0x005E6354, 0x004E573D, 0x003F4A2A, 0x0045482F, 0x0040432A, 0x003E4127, 0x0042452B, 0x00404427, 0x003D4124, 0x004F5336, 0x006B7051, 0x006E8059, 0x00617051, 0x003F4A36, 0x005E665B, 0x004C5449,
    0x0036402F, 0x003B482E, 0x00627151, 0x00565F4A, 0x00868F7A, 0x005C6550, 0x004B543F, 0x00353E29, 0x0057604B, 0x0067705B, 0x00B4BDA8, 0x00B8BDBB, 0x00697167, 0x003A4630, 0x00465236, 0x005A6648, 0x008C947D, 0x00999E8F, 0x004F514B, 0x004E593F,
    0x00303C20, 0x005E6851, 0x007D8477, 0x00B1B3B3, 0x00686C67, 0x0057604C, 0x0035431F, 0x00505E42, 0x004C5A38, 0x005C6A40, 0x00525E2E, 0x00444E20, 0x004F502E, 0x004D4931, 0x004F4638, 0x00454A2D, 0x004B5033, 0x004F5437, 0x004A4F32, 0x00404528,
    0x00393E21, 0x003A3F22, 0x003E4326, 0x004F493E, 0x00534D40, 0x004F4C3D, 0x00454733, 0x00555E44, 0x006F7B5D, 0x0071815F, 0x006F815C, 0x0072805C, 0x0073825C, 0x0074845B, 0x00798862, 0x00657153, 0xFFDDE5D4, 0xFFFDFFFE, 0xFFFDFDFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x2684B4EE, 0x00699FDE, 0x0065A4E8, 0x005BA2EC, 0x0062ADF9, 0x0062AAF7, 0x0066AAF3, 0x005E9EE5, 0x005EA5EF, 0x0061A8F2, 0x0061A8F2, 0x0061A8F2, 0x0062A9F3,
    0x005EA5EF, 0x005CA3ED, 0x005AA1EB, 0x0064A7EC, 0x0060A5EA, 0x0061A8EB, 0x0059A1E1, 0x005CA5DF, 0x005EA4D9, 0x004789BA, 0x0030719E, 0x004F7E82, 0x0053828A, 0x0050808C, 0x00517F8A, 0x005D8688, 0x00638174, 0x00687E62, 0x0072805C, 0x0071855B,
    0x006E8257, 0x0072855A, 0x0075885D, 0x0073865B, 0x0078895E, 0x007B8C61, 0x0077885D, 0x0074855A, 0x00738459, 0x00738459, 0x00728358, 0x00738459, 0x00738459, 0x0075865B, 0x0075865B, 0x0075865B, 0x00738459, 0x0077885D, 0x0078895E, 0x0074855A,
    0x0076875C, 0x007A8B60, 0x0078895E, 0x0072815B, 0x0072815B, 0x0074835D, 0x0073825C, 0x006F7E58, 0x006F7E58, 0x0071805A, 0x0073825C, 0x0073825C, 0x0072815B, 0x0071805A, 0x00707F59, 0x00707F59, 0x00707F59, 0x00707F59, 0x00707F59, 0x0075845E,
    0x0071805A, 0x0071805A, 0x006A7953, 0x006E7D57, 0x0066754F, 0x0063724C, 0x00596842, 0x007F8E79, 0x00384732, 0x001D2C17, 0x0035442F, 0x000E1D08, 0x003C4B36, 0x009DAC97, 0x00586752, 0x005D7045, 0x00596B42, 0x005A6B46, 0x00495838, 0x00455238,
    0x005C6852, 0x00606A59, 0x00515B4B, 0x00575E4F, 0x00717968, 0x005E6752, 0x0069745A, 0x00606D4D, 0x00707E5A, 0x0073835A, 0x00728358, 0x006F7F56, 0x00718158, 0x0073835A, 0x0074845B, 0x0073835A, 0x00728259, 0x00728259, 0x0073835A, 0x0072845D,
    0x0071835C, 0x0070825B, 0x006F815A, 0x006E8059, 0x006E8059, 0x006E8059, 0x006E8059, 0x0071825D, 0x0071825D, 0x0071825D, 0x0071825D, 0x0071825D, 0x0071825D, 0x0071825D, 0x0071825D, 0x006C7D5C, 0x006D7E5D, 0x00738463, 0x00778867, 0x00738463,
    0x00738463, 0x00768766, 0x00738463, 0x0073845F, 0x0072835E, 0x0071825D, 0x0071825D, 0x0071825D, 0x0071825D, 0x006F805B, 0x006D7E59, 0x006A7D52, 0x006E8156, 0x006B7D56, 0x006C7C5A, 0x006D7C5D, 0x00425034, 0x001F2C14, 0x0039462E, 0x0047492B,
    0x003E3E26, 0x00575445, 0x00716C63, 0x00615C53, 0x004C493A, 0x00484830, 0x00454729, 0x00474A31, 0x0044472D, 0x003F4228, 0x00404329, 0x00414528, 0x003E4225, 0x004F5435, 0x006E7354, 0x006F8158, 0x006D7D5B, 0x0055624A, 0x00828C7B, 0x00909A8A,
    0x0067735D, 0x004E5D3E, 0x0071825D, 0x00616C52, 0x00717C62, 0x005D684E, 0x00606B51, 0x004F5A40, 0x006F7A60, 0x0079846A, 0x0097A288, 0x00CAD1CA, 0x0098A292, 0x0055624A, 0x00667353, 0x006C7959, 0x00737C61, 0x009FA592, 0x00868A7E, 0x00677355,
    0x00485535, 0x00707C60, 0x00959D8C, 0x00EBEFE9, 0x00A7ACA3, 0x006B755E, 0x00475630, 0x005C6B4C, 0x004F5D3B, 0x005D6B41, 0x00525F31, 0x003F481D, 0x00484C29, 0x004E4C34, 0x00504938, 0x004C4D39, 0x004F503C, 0x0051523E, 0x004F503C, 0x004A4B37,
    0x00464733, 0x00464733, 0x00464733, 0x00514C3D, 0x004E4C3A, 0x00484935, 0x00454930, 0x00566042, 0x006D7B59, 0x006B7C57, 0x00687B54, 0x0073815D, 0x0073825C, 0x00728259, 0x00778660, 0x00657153, 0xFFDDE5D4, 0xFFFDFFFE, 0xFFFCFCFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x67A6C4ED, 0x5099BCE8, 0x0085B1E0, 0x006091C1, 0x006FA4D6, 0x0070A4D3, 0x006E9FCD, 0x006F9CC8, 0x00629DCB, 0x00609BC9, 0x00649FCD, 0x00649FCD, 0x0069A4D2,
    0x0069A4D2, 0x006AA5D3, 0x0069A4D2, 0x0073A1DB, 0x006E9DDA, 0x006EA0DC, 0x00679BD7, 0x006B9DD7, 0x006898CC, 0x005987B6, 0x004D7AA5, 0x00788767, 0x00768A67, 0x00728B69, 0x006A8563, 0x00758D6D, 0x007A8C6F, 0x0082886F, 0x007D7F69, 0x00778B61,
    0x0073875D, 0x0072845D, 0x0072845D, 0x006F805B, 0x0072805E, 0x0073815F, 0x00717E5E, 0x0074855A, 0x0074855A, 0x0074855A, 0x0074855A, 0x0074855A, 0x0075865B, 0x0075865B, 0x0075865B, 0x0074855A, 0x0074855A, 0x0077885D, 0x00798A5F, 0x0076875C,
    0x0077885D, 0x00798A5F, 0x0077885D, 0x0073825C, 0x0076855F, 0x0073825C, 0x0071805A, 0x0073825C, 0x0071805A, 0x0072815B, 0x0075845E, 0x00707F59, 0x0071805A, 0x0074835D, 0x0075845E, 0x0075845E, 0x0074835D, 0x0071805A, 0x006F7E58, 0x006A7854,
    0x0074825E, 0x007A8864, 0x006F7D59, 0x00707E5A, 0x0073815D, 0x0075835F, 0x006D7B57, 0x0059664C, 0x005A674D, 0x0049563C, 0x004A573D, 0x0049563C, 0x00566349, 0x00707D63, 0x005C694F, 0x0076885F, 0x0074865F, 0x00758760, 0x00657651, 0x005A6A48,
    0x00657454, 0x006A795A, 0x00637253, 0x005D694B, 0x00727E60, 0x00758262, 0x00677553, 0x005F6D49, 0x0072815B, 0x006F7E58, 0x006F7F56, 0x00708057, 0x00718158, 0x0073835A, 0x0074845B, 0x0074845B, 0x0075855C, 0x0075855C, 0x0076865D, 0x0071835A,
    0x0071835A, 0x00708259, 0x006F8158, 0x006E8057, 0x006E8057, 0x006F8158, 0x006F8158, 0x0070825B, 0x0070825B, 0x0071835C, 0x0071835C, 0x0072845D, 0x0072845D, 0x0073855E, 0x0073855E, 0x0073845F, 0x0070815C, 0x0071825D, 0x0071825D, 0x006E7F5A,
    0x0070815C, 0x0072835E, 0x0071825D, 0x0073855E, 0x0072845D, 0x0070825B, 0x0070825B, 0x0071835C, 0x0071835C, 0x0071835C, 0x0070825B, 0x006A7D52, 0x006F8257, 0x006C7E57, 0x006D7E59, 0x006F7E5E, 0x00425132, 0x001D2B0F, 0x0039462C, 0x00504E30,
    0x004C482F, 0x004C4534, 0x004E4639, 0x004F473A, 0x004D4635, 0x004B472E, 0x004C4A2C, 0x0041462B, 0x00494E33, 0x00474C2F, 0x0042472A, 0x00404627, 0x003B4122, 0x004E5435, 0x00757C5B, 0x006D8154, 0x00758760, 0x00707F60, 0x0079866C, 0x00717E66,
    0x00667458, 0x00748462, 0x0081936C, 0x007A8767, 0x006A7757, 0x005B6848, 0x00697656, 0x00697656, 0x00798666, 0x006A7757, 0x00596646, 0x00828C7B, 0x007B8771, 0x00687758, 0x006C7A56, 0x00788662, 0x006F7A5A, 0x006D765C, 0x00818873, 0x0062704E,
    0x00485632, 0x00616F4B, 0x004A553B, 0x007C8374, 0x00767D6E, 0x00687456, 0x004E5F34, 0x00546141, 0x0045532F, 0x005F6D43, 0x00667347, 0x004D572C, 0x00474D2A, 0x004A4B31, 0x004C4B37, 0x004C493A, 0x004B4839, 0x004B4839, 0x004D4A3B, 0x004E4B3C,
    0x004E4B3C, 0x004C493A, 0x004A4738, 0x004E4D38, 0x004A4D34, 0x00484D32, 0x00474F31, 0x005C6746, 0x0073825C, 0x0072845B, 0x0073855C, 0x0073815D, 0x0073825C, 0x00718158, 0x0076855F, 0x00647052, 0xFFDDE5D4, 0xFFFDFFFE, 0xFFFBFBFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF8FFFF, 0xFBF3FEFF, 0x00BCCDD0, 0x005E7676, 0x006B8585, 0x006C8783, 0x006B827D, 0x00708681, 0x006A8784, 0x00678481, 0x006E8B88, 0x00688582, 0x006D8A87,
    0x006B8885, 0x006B8885, 0x006B8885, 0x006D8E7F, 0x0065877C, 0x00658983, 0x00648985, 0x006A8D89, 0x005D7F78, 0x005C7D6F, 0x00638372, 0x007B845C, 0x0074815B, 0x00788964, 0x0070815F, 0x00798A69, 0x00768363, 0x0083896A, 0x007E8364, 0x00768C5C,
    0x00758A5D, 0x0075895C, 0x0074865D, 0x0071835C, 0x0074825E, 0x00768462, 0x00768462, 0x0074855A, 0x0074855A, 0x0075865B, 0x0075865B, 0x0075865B, 0x0076875C, 0x0075865B, 0x0075865B, 0x0074855A, 0x0075865B, 0x0077885D, 0x00798A5F, 0x0077885D,
    0x0074855A, 0x00728358, 0x006F8055, 0x0076855F, 0x0075845E, 0x006F7E58, 0x00707F59, 0x0072815B, 0x0071805A, 0x0072815B, 0x006F7E58, 0x006F815A, 0x006E8059, 0x006D7F58, 0x006C7E57, 0x006B7D56, 0x006B7D56, 0x006A7C55, 0x006A7C55, 0x006A7A58,
    0x006B7B59, 0x006E7E5C, 0x006E7E5C, 0x0070805E, 0x0071815F, 0x0071815F, 0x006E7E5C, 0x006D7B59, 0x0073815F, 0x006B7957, 0x00677553, 0x0072805E, 0x006D7B59, 0x00657351, 0x00707E5C, 0x0070825B, 0x0073855E, 0x007A8C65, 0x00778962, 0x006F815A,
    0x0071835A, 0x0074865D, 0x00708259, 0x0075865B, 0x0076865D, 0x007D8D64, 0x00728259, 0x0074845B, 0x007A8A61, 0x0075845E, 0x0076855F, 0x0073835A, 0x0073835A, 0x0073835A, 0x0073835A, 0x0073835A, 0x00728259, 0x00728259, 0x00728259, 0x00708259,
    0x006F8158, 0x006F8158, 0x006E8057, 0x006D7F56, 0x006D7F56, 0x006E8057, 0x006E8057, 0x006F815A, 0x006F815A, 0x006F815A, 0x0070825B, 0x0070825B, 0x0070825B, 0x0070825B, 0x0071835C, 0x006F8158, 0x006D7F56, 0x006D7F56, 0x006E8057, 0x006F8158,
    0x00708259, 0x00708259, 0x006E8057, 0x0073855E, 0x0071835C, 0x006F815A, 0x006F815A, 0x0070825B, 0x0071835C, 0x0071835C, 0x0071835C, 0x006C7F54, 0x00708358, 0x006C7E55, 0x0070825B, 0x00778765, 0x004E5D3D, 0x00283718, 0x003F4E2F, 0x00454A2B,
    0x00474B2E, 0x0043452F, 0x0040412D, 0x00464733, 0x00484A34, 0x0043472A, 0x00414627, 0x00394123, 0x00434B2D, 0x003E4627, 0x003D4526, 0x0047502F, 0x00454E2D, 0x00505938, 0x006F7857, 0x006C8051, 0x0073865B, 0x00798B64, 0x00758464, 0x006E7D5D,
    0x00748462, 0x007C8E67, 0x005E7146, 0x006A7854, 0x005B6945, 0x004A5834, 0x004D5B37, 0x0065734F, 0x006A7854, 0x005F6D49, 0x00566440, 0x00647157, 0x00546344, 0x0072835E, 0x0083936A, 0x007A8A61, 0x006B7852, 0x005B6645, 0x00727C5E, 0x0052603C,
    0x004D5E33, 0x00697A4E, 0x00566440, 0x0078826B, 0x00747E67, 0x00677553, 0x004A5C2D, 0x005E6C48, 0x0053623C, 0x00697A4F, 0x00768559, 0x00616D43, 0x004A5430, 0x0043482B, 0x00494D34, 0x004B4A35, 0x004A4934, 0x004B4A35, 0x004D4C37, 0x00504F3A,
    0x0051503B, 0x00504F3A, 0x004E4D38, 0x00494E31, 0x004B5132, 0x0047502F, 0x00424C28, 0x0055623C, 0x006E7E55, 0x00728358, 0x00718459, 0x0075835F, 0x0074835D, 0x00718158, 0x0076855F, 0x00647052, 0xFFDDE5D4, 0xFFFDFFFE, 0xFFFCFCFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xF0FFFFED, 0xF7FFFFF1, 0x00C9D2B8, 0x00596646, 0x00778863, 0x007F916A, 0x006F7F56, 0x0064754A, 0x00646F49, 0x00646F49, 0x006E7953, 0x00646F49, 0x006D7852,
    0x0068734D, 0x0065704A, 0x0069744E, 0x00728A62, 0x00637A5A, 0x00576F57, 0x00506758, 0x00556D61, 0x00435849, 0x003E543C, 0x0040563A, 0x002D4435, 0x002C4138, 0x00405251, 0x003D4F50, 0x00506059, 0x004B5D46, 0x00697B52, 0x00768A55, 0x00708753,
    0x00738A56, 0x00748958, 0x00728657, 0x006F8354, 0x00708155, 0x00728357, 0x0076875C, 0x0074855A, 0x0074855A, 0x0074855A, 0x0075865B, 0x0075865B, 0x0075865B, 0x0075865B, 0x0075865B, 0x0074855A, 0x0075865B, 0x0076875C, 0x0077885D, 0x0076875C,
    0x00708156, 0x0066774C, 0x00607146, 0x005C6B45, 0x005B6A44, 0x00576640, 0x005B6A44, 0x00596842, 0x00576640, 0x005E6D47, 0x00576640, 0x00556740, 0x0054663F, 0x0052643D, 0x0052643D, 0x0052643D, 0x0054663F, 0x00566841, 0x00586A43, 0x00586846,
    0x00546442, 0x00526240, 0x00576745, 0x00596947, 0x00586846, 0x00546442, 0x00546442, 0x005D6C46, 0x0051603A, 0x00586741, 0x005D6C46, 0x005F6E48, 0x005E6D47, 0x0051603A, 0x00586741, 0x005B6C47, 0x0060724B, 0x006A7C55, 0x0073855C, 0x00718459,
    0x006E8156, 0x006E8255, 0x006A7E51, 0x00748657, 0x00708253, 0x00718256, 0x00738458, 0x00798A5F, 0x0075855C, 0x0078885F, 0x0074845B, 0x0073835A, 0x00728259, 0x00728259, 0x0073835A, 0x0073835A, 0x0074845B, 0x0074845B, 0x0074845B, 0x00708259,
    0x00708259, 0x006F8158, 0x006F8158, 0x006F8158, 0x006F8158, 0x006F8158, 0x00708259, 0x00708259, 0x00708259, 0x00708259, 0x00708259, 0x006F8158, 0x006F8158, 0x006F8158, 0x006F8158, 0x006D8055, 0x006C7F54, 0x006B7E53, 0x006C7F54, 0x006F8257,
    0x00708358, 0x006F8257, 0x006E8156, 0x006F8158, 0x006D7F56, 0x006B7D54, 0x006B7D54, 0x006C7E55, 0x006D7F56, 0x006D7F56, 0x006D7F56, 0x006F8257, 0x00708358, 0x006B7D54, 0x006E8059, 0x0073855E, 0x004C5D38, 0x0021310F, 0x002B3B19, 0x002A3B1A,
    0x0029391A, 0x0028371B, 0x0026351A, 0x0026351A, 0x0028371B, 0x0029391A, 0x00273817, 0x002E3919, 0x002E3919, 0x00273211, 0x00394423, 0x00626D4C, 0x00707C58, 0x006E7A56, 0x00788460, 0x00728657, 0x00768A5D, 0x0076895E, 0x007F916A, 0x008D9F78,
    0x00768861, 0x005F7148, 0x0053663B, 0x00627249, 0x006A7A51, 0x0066764D, 0x005C6C43, 0x00697950, 0x005F6F46, 0x005E6E45, 0x00697950, 0x00627151, 0x00677755, 0x00798B64, 0x007E8E65, 0x005B6C41, 0x00616F46, 0x0073805A, 0x0046532D, 0x0035441E,
    0x00617246, 0x00647746, 0x0046572C, 0x006B7858, 0x00636F53, 0x005D6C46, 0x00617443, 0x0054643B, 0x005C6C43, 0x006B7C51, 0x00738459, 0x00728057, 0x005F6B47, 0x00434E2E, 0x00374123, 0x003D4320, 0x003F4522, 0x00414724, 0x00424825, 0x00424825,
    0x00424825, 0x00434926, 0x00444A27, 0x003C4824, 0x003F4B27, 0x003B4723, 0x0036431D, 0x00515F36, 0x00728259, 0x0077885D, 0x0074855A, 0x00768460, 0x0075845E, 0x0073835A, 0x00778660, 0x00657153, 0xFFDDE5D4, 0xFFFDFFFE, 0xFFFDFDFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF9FFF7, 0xFFFBFFF5, 0x00CBD8C0, 0x00566746, 0x0080946A, 0x007F9368, 0x0052673A, 0x002C4114, 0x0039471E, 0x0036441B, 0x003A481F, 0x0028360D, 0x003C4A21,
    0x0039471E, 0x0035431A, 0x00404E25, 0x00697870, 0x005B6B6A, 0x00566673, 0x00677690, 0x0098A5C5, 0x009AA8C4, 0x009DAAC0, 0x0096A3B3, 0x0089A6B4, 0x00849EAF, 0x00869AB3, 0x005D6D84, 0x00596871, 0x0046594A, 0x00667E54, 0x00789459, 0x00778B60,
    0x00798D62, 0x00778B5E, 0x0074885B, 0x00748859, 0x00748657, 0x00748657, 0x00778A59, 0x00738459, 0x00738459, 0x00738459, 0x00738459, 0x0074855A, 0x0074855A, 0x0074855A, 0x0075865B, 0x0074855A, 0x0075865B, 0x0074855A, 0x0075865B, 0x0076875C,
    0x006C7D52, 0x005B6C41, 0x00506136, 0x00505F39, 0x0056653F, 0x0051603A, 0x0056653F, 0x0055643E, 0x004F5E38, 0x00586741, 0x0054633D, 0x004F613A, 0x004F613A, 0x0050623B, 0x0051633C, 0x0051633C, 0x0052643D, 0x0053653E, 0x0053653E, 0x004D5F38,
    0x0052643D, 0x0051633C, 0x0052643D, 0x004F613A, 0x00556740, 0x0053653E, 0x0052643D, 0x004D5F36, 0x0056683F, 0x00576940, 0x004C5E35, 0x0053653C, 0x0052643B, 0x00475930, 0x005A6C43, 0x004F613A, 0x00586A43, 0x0063754E, 0x0072845B, 0x0076885F,
    0x0073855C, 0x0074865D, 0x00718459, 0x006F8054, 0x00748559, 0x00708155, 0x00738458, 0x00738459, 0x00708156, 0x00798A5F, 0x006F8055, 0x0076865D, 0x0075855C, 0x0074845B, 0x0074845B, 0x0075855C, 0x0076865D, 0x0076865D, 0x0076865D, 0x006F8257,
    0x006E8156, 0x006E8156, 0x006D8055, 0x006D8055, 0x006E8156, 0x006E8156, 0x006F8257, 0x006F8158, 0x006E8057, 0x006E8057, 0x006D7F56, 0x006D7F56, 0x006C7E55, 0x006C7E55, 0x006C7E55, 0x00738459, 0x00728358, 0x006D7E53, 0x006B7C51, 0x006F8055,
    0x00708156, 0x006F8055, 0x00718257, 0x00708259, 0x006F8158, 0x006D7F56, 0x006D7F56, 0x006E8057, 0x006E8057, 0x006E8057, 0x006D7F56, 0x006F8257, 0x006E8156, 0x006C7E55, 0x006E8057, 0x00708259, 0x0051633C, 0x002A3C15, 0x00293B14, 0x00213917,
    0x001E3614, 0x001F3715, 0x00213917, 0x001C3412, 0x001C3412, 0x00203816, 0x00203816, 0x002B3615, 0x002B3615, 0x00283312, 0x003D4925, 0x0067734F, 0x0078855F, 0x0073805A, 0x0074815B, 0x0074885B, 0x0074885B, 0x0075885D, 0x007C8F64, 0x006E8057,
    0x005A6C43, 0x0055673E, 0x0061734C, 0x0058683F, 0x00607047, 0x0066764D, 0x005E6E45, 0x005E6E45, 0x0056663D, 0x005A6A41, 0x005E6E45, 0x0070815C, 0x00879873, 0x007C8E67, 0x00606F49, 0x005E6E45, 0x006B7950, 0x0056643A, 0x002E3C12, 0x006B7955,
    0x005C6D41, 0x003C4F1C, 0x003C4E1F, 0x006B7955, 0x006C7959, 0x00606F49, 0x00546637, 0x005B6C40, 0x00708156, 0x0074855A, 0x006F7F56, 0x00798862, 0x006F805B, 0x00465634, 0x00243412, 0x002E3A10, 0x00313D13, 0x00333F15, 0x00333F15, 0x00303C12,
    0x00303C12, 0x00323E14, 0x00354117, 0x00303E1A, 0x00303E1A, 0x002D3C16, 0x002E3D17, 0x004D5C36, 0x0074815B, 0x0077855C, 0x00717F56, 0x00768460, 0x0076855F, 0x0074845B, 0x00778660, 0x00636F51, 0xFFDBE3D2, 0xFFFDFFFE, 0xFFFDFDFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF8FEFF, 0xFFF8FEFD, 0x00C5CEC1, 0x00505D43, 0x007F8F6D, 0x007F916A, 0x0055693F, 0x002E441A, 0x00586A45, 0x0051633E, 0x004A5C37, 0x0031431E, 0x004C5E39,
    0x00435530, 0x0031431E, 0x003B4D28, 0x006A7E61, 0x00556855, 0x00576968, 0x008899A6, 0x00D2E3F8, 0x00D3E5F6, 0x00D3E5F0, 0x00CADDE2, 0x00D5E2FA, 0x00DAE7FD, 0x00CDD7E9, 0x0079828B, 0x00626D6A, 0x00485644, 0x00627554, 0x00667C52, 0x005D6A54,
    0x005B6951, 0x00536046, 0x00526142, 0x005A6A48, 0x005E6D47, 0x005B6C41, 0x005B6C41, 0x00738459, 0x00728358, 0x00728358, 0x00718257, 0x00718257, 0x00728358, 0x00738459, 0x0074855A, 0x00738459, 0x0075865B, 0x00728358, 0x0075865B, 0x0078895E,
    0x006A7B50, 0x00536439, 0x0045562B, 0x0031401A, 0x003D4C26, 0x002A3913, 0x002D3C16, 0x003C4B25, 0x0032411B, 0x002E3D17, 0x002C3B15, 0x002C3F18, 0x002D4019, 0x002F421B, 0x002F421B, 0x002F421B, 0x002E411A, 0x002C3F18, 0x002B3E17, 0x002D4116,
    0x0033471C, 0x00304419, 0x00304419, 0x00293D12, 0x0031451A, 0x002D4116, 0x002B3F14, 0x0030461C, 0x002B4117, 0x002D4319, 0x002A4016, 0x00263C12, 0x002C4218, 0x002C4218, 0x0023390F, 0x003A4C23, 0x004B5D34, 0x005B6D44, 0x006E8059, 0x0074865F,
    0x0070815C, 0x00748560, 0x00728260, 0x00707F59, 0x0074835D, 0x00718158, 0x0078885F, 0x00718257, 0x0076875B, 0x007B8C60, 0x0077885C, 0x0078885F, 0x0076865D, 0x0074845B, 0x0073835A, 0x0074845B, 0x0075855C, 0x0074845B, 0x0073835A, 0x00718459,
    0x00708358, 0x00708358, 0x00708358, 0x00708358, 0x00708358, 0x00718459, 0x00718459, 0x0071835A, 0x00708259, 0x00708259, 0x00708259, 0x00708259, 0x00708259, 0x00708259, 0x00708259, 0x0073835A, 0x0074845B, 0x006E7E55, 0x006C7C53, 0x00708057,
    0x00708057, 0x00708057, 0x0074845B, 0x0073855C, 0x0072845B, 0x0071835A, 0x0071835A, 0x0071835A, 0x0071835A, 0x006F8158, 0x006E8057, 0x006D8055, 0x006C7F54, 0x00708358, 0x00718459, 0x0074875C, 0x006B7E53, 0x00596C41, 0x00596C41, 0x005A6D4C,
    0x005A6E4B, 0x005B704A, 0x005C714B, 0x005C714B, 0x005A6F49, 0x00586C49, 0x00596C4B, 0x005C6A46, 0x00606E4A, 0x005F6D49, 0x0063724C, 0x00707F59, 0x0074835D, 0x00708057, 0x00728259, 0x0071835A, 0x00708259, 0x00708358, 0x0072855A, 0x0056693E,
    0x005E7047, 0x005B6C47, 0x0053643F, 0x0063724C, 0x0064734D, 0x00606F49, 0x00576640, 0x00576640, 0x005C6B45, 0x0061704A, 0x00606F49, 0x006C7E57, 0x0060714C, 0x00576843, 0x0054623E, 0x00677551, 0x0058653F, 0x003B491F, 0x00637147, 0x006A7856,
    0x0036471C, 0x003F521F, 0x00647746, 0x0065734F, 0x00536040, 0x0055633F, 0x005C6D42, 0x006E8051, 0x0078895D, 0x00728358, 0x006A7C55, 0x0073845F, 0x00758762, 0x00657752, 0x0052643F, 0x005A6943, 0x005B6A44, 0x005B6A44, 0x005B6A44, 0x005A6943,
    0x005A6943, 0x005B6A44, 0x005D6C46, 0x00586944, 0x00576843, 0x00576843, 0x00596743, 0x006A7854, 0x007C8864, 0x0077835F, 0x0076825E, 0x0074825E, 0x0075845E, 0x0074845B, 0x0076855F, 0x00606C4E, 0xFFD8E0CF, 0xFFFCFFFD, 0xFFFDFDFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFBFF, 0xFFFBF8FA, 0x00D3D1C6, 0x0063634B, 0x008D916E, 0x00838B62, 0x005D673D, 0x003C481E, 0x0064764F, 0x0060724B, 0x005B6D46, 0x00455730, 0x00687A53,
    0x00566841, 0x0032441D, 0x0033451E, 0x0079815C, 0x00535C42, 0x00565D58, 0x00989EA9, 0x00E3E9FC, 0x00CBD2E3, 0x00C1C8D1, 0x00C2C9CC, 0x00C8C6DA, 0x00E4E2EE, 0x00DBDCDA, 0x00767969, 0x005C6249, 0x0040492F, 0x004B543F, 0x003A4531, 0x005B625F,
    0x00515952, 0x00424A3F, 0x003E4837, 0x0048553D, 0x004C583C, 0x0043512F, 0x003F4D29, 0x00738459, 0x00728358, 0x00708156, 0x00708156, 0x00708156, 0x00718257, 0x00738459, 0x0074855A, 0x00738459, 0x0074855A, 0x00718257, 0x0074855A, 0x00798A5F,
    0x006A7B50, 0x004F6035, 0x003F5025, 0x004A5933, 0x0056653F, 0x0033421C, 0x0036451F, 0x00576640, 0x004A5933, 0x0035441E, 0x0031401A, 0x002D4019, 0x002E411A, 0x002F421B, 0x0030431C, 0x0031441D, 0x0030431C, 0x0030431C, 0x002F421B, 0x00324818,
    0x00324818, 0x002D4313, 0x00344A1A, 0x00304616, 0x00354B1B, 0x002F4515, 0x00304616, 0x002D451B, 0x0030481E, 0x002B4319, 0x002D451B, 0x002D451B, 0x00284016, 0x002B4319, 0x002A4218, 0x00314419, 0x00495C31, 0x005E7047, 0x0073855E, 0x00778765,
    0x00707F5F, 0x00738263, 0x00728162, 0x00798765, 0x00707E5C, 0x006E7C58, 0x00798862, 0x006E7F54, 0x0075865A, 0x006F8152, 0x00738556, 0x00728259, 0x00708057, 0x006F7F56, 0x006F7F56, 0x00728259, 0x0074845B, 0x0074845B, 0x0073835A, 0x006E8156,
    0x006E8156, 0x006D8055, 0x006D8055, 0x006D8055, 0x006E8156, 0x006F8257, 0x006F8257, 0x006E8156, 0x006E8156, 0x006E8156, 0x006F8257, 0x006F8257, 0x006F8257, 0x00708358, 0x00708358, 0x006E7D57, 0x0072815B, 0x006F7E58, 0x006F7E58, 0x0074835D,
    0x0073825C, 0x0071805A, 0x0075845E, 0x00708358, 0x00708358, 0x006F8257, 0x006F8257, 0x006F8257, 0x006E8156, 0x006C7F54, 0x006A7D52, 0x0071835A, 0x006D8055, 0x006F8257, 0x006A7D52, 0x006A7D52, 0x006F8257, 0x006F8257, 0x0074875C, 0x00778262,
    0x007B8665, 0x0075815D, 0x00727F59, 0x00798660, 0x00798561, 0x00747F5E, 0x00778262, 0x00748560, 0x00768762, 0x00748560, 0x0071835C, 0x0072845D, 0x0072845B, 0x00708259, 0x00708259, 0x0070825B, 0x007E9067, 0x0062744B, 0x00576A3F, 0x004D5F36,
    0x005F714A, 0x0050603E, 0x005C6B4B, 0x00505E3A, 0x00667450, 0x00687652, 0x0064724E, 0x0065734F, 0x00667450, 0x00606E4A, 0x00667450, 0x00657750, 0x0060714C, 0x00647452, 0x00707E5C, 0x00485634, 0x0035421C, 0x00606E45, 0x006B794F, 0x00334020,
    0x003E4F24, 0x00607340, 0x005A6D3C, 0x0055633F, 0x00717D5F, 0x0072805E, 0x006A7A51, 0x006D804F, 0x006A7B4F, 0x006A7A51, 0x006D7F58, 0x006A7C57, 0x00647651, 0x00667B55, 0x006D825B, 0x006D7D5E, 0x006B7B5C, 0x006A7A5B, 0x006A7A5B, 0x006C7C5D,
    0x006D7D5E, 0x006D7D5E, 0x006C7C5D, 0x006C7E59, 0x006D7E5C, 0x00748462, 0x00748462, 0x00768462, 0x00747F5E, 0x006D7857, 0x00768160, 0x0072805C, 0x0074835D, 0x0074845B, 0x0075845E, 0x005E6A4C, 0xFFD5DDCC, 0xFFFAFDFB, 0xFFFDFDFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFBFBFB, 0x00C8CFBA, 0x0058693D, 0x00819267, 0x00808F70, 0x00566742, 0x00395117, 0x0062744D, 0x0034461F, 0x0064764F, 0x00394B24, 0x0053653E,
    0x00596B44, 0x0031431C, 0x00384A23, 0x00658054, 0x00617957, 0x00576958, 0x00A2AFAD, 0x00D7E1E8, 0x00CFD8E1, 0x00C5D0D4, 0x00B1BDBD, 0x00C9CDDF, 0x00D1D4E2, 0x00D3D5DD, 0x009B9D9D, 0x00757A71, 0x00757F6E, 0x0056664E, 0x0062755A, 0x009C9DA1,
    0x00787A7B, 0x00666868, 0x006C6F6D, 0x005D615B, 0x008D9289, 0x007F8679, 0x00373E31, 0x0076875B, 0x00708155, 0x006F8054, 0x00728357, 0x00728357, 0x00748559, 0x0075865A, 0x00738458, 0x0076875C, 0x00728358, 0x00738459, 0x00728259, 0x007A8A61,
    0x0064744B, 0x00505F39, 0x0041502A, 0x0034461F, 0x005E7049, 0x00556740, 0x00263811, 0x004A5C35, 0x00697B54, 0x00384A23, 0x002D3F18, 0x002E4519, 0x002B4216, 0x002A4115, 0x002F461A, 0x00334A1E, 0x0031481C, 0x002D4418, 0x002D4418, 0x002F4417,
    0x002E4316, 0x00314619, 0x00314619, 0x002E4316, 0x0033481B, 0x00364B1E, 0x00304518, 0x00314619, 0x002D4417, 0x002C4317, 0x002C4317, 0x002A4218, 0x00294117, 0x00274217, 0x00264018, 0x002F4319, 0x004F6339, 0x00576940, 0x0076885F, 0x0072845B,
    0x0075855C, 0x0073835A, 0x0077875E, 0x0076875C, 0x0075865B, 0x0074855A, 0x0074855A, 0x0074855A, 0x0074855A, 0x0075865B, 0x0076875C, 0x0076865D, 0x0076865D, 0x0074845B, 0x0073835A, 0x0073835A, 0x00728259, 0x00728259, 0x00728259, 0x00708057,
    0x00708057, 0x00718158, 0x00708057, 0x00708057, 0x006F7F56, 0x006E7E55, 0x006D7D54, 0x006C7E55, 0x006C7E55, 0x006D7F56, 0x006D7F56, 0x006E8057, 0x006F8158, 0x006F8158, 0x00708259, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x00718158,
    0x00718158, 0x00718158, 0x00718158, 0x00728259, 0x00718158, 0x00718158, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x006E7D57, 0x0073835A, 0x00718158, 0x006D7F56, 0x0072855A, 0x00718459, 0x006D8255, 0x00708558, 0x00748153,
    0x00738354, 0x00718054, 0x006E7F54, 0x006B7D54, 0x0071845D, 0x006D7F5A, 0x006C7E59, 0x006A825A, 0x006E835C, 0x00697E57, 0x006E815A, 0x0073845F, 0x00738361, 0x00758262, 0x006D795B, 0x00758861, 0x006B7E57, 0x006A7D56, 0x00556841, 0x0053663F,
    0x00546740, 0x00546740, 0x004C5F38, 0x006B7E57, 0x004B5E37, 0x003F522B, 0x00566942, 0x00586B44, 0x003F522B, 0x00566942, 0x00556841, 0x003A4B29, 0x005D6E4C, 0x0052643F, 0x003E502B, 0x00576A43, 0x0055693F, 0x00586C42, 0x003D5126, 0x00333F21,
    0x006B7955, 0x004A5B30, 0x00606D47, 0x00768161, 0x006E7756, 0x00738052, 0x0065773C, 0x00606C50, 0x005E6B4B, 0x005B6945, 0x005A6B40, 0x005A6B3F, 0x005A6B3F, 0x0058693E, 0x0056663D, 0x005A6844, 0x00586642, 0x00596743, 0x005C6A46, 0x005D6B47,
    0x005B6945, 0x005D6B47, 0x00616F4B, 0x0063714F, 0x005C6A48, 0x006D7B59, 0x00667654, 0x00697A55, 0x0071835E, 0x006D8059, 0x00667A50, 0x006D7E59, 0x006E8059, 0x006E8057, 0x00728259, 0x00616E4E, 0xFFD1D8C3, 0xFFFFFFF9, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFDFDFD, 0x00CAD1BC, 0x0056673B, 0x007B8C61, 0x00798869, 0x0050613C, 0x00324A10, 0x006C7E57, 0x0053653E, 0x0062744D, 0x00364821, 0x005E7049,
    0x0060724B, 0x002B3D16, 0x0033451E, 0x006E8461, 0x004F6249, 0x005C6A5F, 0x00AEB7BB, 0x00DAE0ED, 0x00C7CDDA, 0x00C9CFDA, 0x00CAD2D9, 0x00C9CFDC, 0x00DEE3EC, 0x00CFD2D6, 0x00909391, 0x00ADB3A8, 0x0076816D, 0x003D4D35, 0x006F8366, 0x00ABAFAA,
    0x008C908A, 0x005D6259, 0x00646A5F, 0x00818879, 0x00A8B09F, 0x00848D79, 0x00555E49, 0x005C6D41, 0x007A8B5F, 0x0078895D, 0x006C7D51, 0x0077885C, 0x0077885C, 0x006E7F53, 0x0076875B, 0x0077885D, 0x00738459, 0x0075865B, 0x0073835A, 0x007B8B62,
    0x0066764D, 0x0051603A, 0x0043522C, 0x00263811, 0x0043552E, 0x005F714A, 0x0041532C, 0x002B3D16, 0x00566841, 0x005C6E47, 0x00283A13, 0x0031481C, 0x0030471B, 0x002F461A, 0x0030471B, 0x0030471B, 0x002E4519, 0x002E4519, 0x002F461A, 0x00304419,
    0x00304419, 0x0031451A, 0x0031451A, 0x002F4318, 0x0031451A, 0x0032461B, 0x00304419, 0x0034491C, 0x0035491E, 0x002E4519, 0x002B4216, 0x002C441A, 0x002A4218, 0x00253F17, 0x00274119, 0x002F4319, 0x004F6339, 0x00576940, 0x0075875E, 0x0071835A,
    0x0075855C, 0x0073835A, 0x0076865D, 0x0075865B, 0x0074855A, 0x0074855A, 0x0074855A, 0x0074855A, 0x0074855A, 0x0074855A, 0x0075865B, 0x0074845B, 0x0073835A, 0x0073835A, 0x00728259, 0x00728259, 0x00728259, 0x00728259, 0x0073835A, 0x0073835A,
    0x0073835A, 0x0073835A, 0x0073835A, 0x00728259, 0x00718158, 0x00718158, 0x00708057, 0x006D7F56, 0x006D7F56, 0x006E8057, 0x006E8057, 0x006F8158, 0x00708259, 0x00708259, 0x00708259, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x00718158,
    0x00718158, 0x00718158, 0x00718158, 0x00728259, 0x00718158, 0x00718158, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x006E7E55, 0x006D7D54, 0x006F7F56, 0x0071835A, 0x006F815A, 0x00667851, 0x0063764F, 0x006C7E59, 0x0076875C,
    0x0063734A, 0x006D7C56, 0x006B7C57, 0x007D8F68, 0x0064764D, 0x006F8257, 0x007C9063, 0x006D7F56, 0x006E8156, 0x006F8257, 0x006A7C53, 0x0070825B, 0x006E7C5A, 0x005F6B4D, 0x00697559, 0x00697A58, 0x0060714F, 0x00617250, 0x00485937, 0x004F603E,
    0x00536442, 0x004D5E3C, 0x00586947, 0x004A5B39, 0x00415230, 0x00465735, 0x00556644, 0x00495A38, 0x00374826, 0x00586947, 0x00586947, 0x00455536, 0x00556546, 0x00485938, 0x00455634, 0x00586A45, 0x00536540, 0x0053663F, 0x0051643D, 0x00536040,
    0x0053623C, 0x005D6E43, 0x00707C58, 0x00687156, 0x005B6247, 0x004E5931, 0x0062723D, 0x005C6544, 0x0058633D, 0x00535F35, 0x00505D2F, 0x004E5C2C, 0x004C5A2A, 0x00495628, 0x00465327, 0x00465228, 0x00445026, 0x00455127, 0x0048542A, 0x0049552B,
    0x0048542A, 0x004A562C, 0x004F5B31, 0x00515F35, 0x0057653C, 0x00586342, 0x005C684A, 0x00606C4E, 0x00637252, 0x00667752, 0x00687A51, 0x006B7C57, 0x006C7E57, 0x006C7E55, 0x00707F59, 0x005F6C4C, 0xFFD0D6C3, 0xFFFEFFFA, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFDFF, 0xFFFEFEFE, 0x00C9D0BB, 0x00596A3E, 0x00819267, 0x007F8E6F, 0x00566742, 0x00344C12, 0x0063754E, 0x0060724B, 0x00576942, 0x003B4D26, 0x005E7049,
    0x0061734C, 0x00364821, 0x003B4D26, 0x00727F65, 0x0047523E, 0x005E655E, 0x00A4A7AC, 0x00EAEAF6, 0x00E1E1ED, 0x00D4D5DF, 0x00D1D3DB, 0x00D2DBDE, 0x00D8DDDE, 0x00D1D6D4, 0x006B6E65, 0x00808576, 0x0067735D, 0x0057664A, 0x00455A3A, 0x004B5440,
    0x00656E5A, 0x00565F4A, 0x00505A43, 0x004F5A40, 0x00586448, 0x00546042, 0x006D7A5A, 0x004F6034, 0x0068794D, 0x007A8B5F, 0x0077885C, 0x00728357, 0x00748559, 0x0076875B, 0x00738458, 0x0077885D, 0x0074855A, 0x0076875C, 0x0074845B, 0x007C8C63,
    0x0067774E, 0x0053623C, 0x0045542E, 0x0050623B, 0x00253710, 0x004B5D36, 0x006A7C55, 0x002E4019, 0x0032441D, 0x00687A53, 0x004D5F38, 0x002D4116, 0x002E4217, 0x002F4318, 0x002E4217, 0x002C4015, 0x002E4217, 0x0031451A, 0x0032461B, 0x0032461B,
    0x0033471C, 0x0032461B, 0x0032461B, 0x0032461B, 0x0031451A, 0x00304419, 0x0032461B, 0x00304419, 0x0033471C, 0x002B4216, 0x00283E14, 0x002D4319, 0x002A421A, 0x00273F17, 0x00294119, 0x002E4218, 0x004F6339, 0x0056683F, 0x0075875E, 0x00708259,
    0x0074845B, 0x00728259, 0x0075855C, 0x00738459, 0x00738459, 0x00738459, 0x0074855A, 0x0074855A, 0x00738459, 0x00738459, 0x00738459, 0x00728259, 0x00718158, 0x00718158, 0x00718158, 0x00718158, 0x00728259, 0x0073835A, 0x0073835A, 0x0073835A,
    0x0073835A, 0x0073835A, 0x0073835A, 0x0073835A, 0x00728259, 0x00718158, 0x00708057, 0x006E8057, 0x006E8057, 0x006F8158, 0x006F8158, 0x00708259, 0x00708259, 0x0071835A, 0x0071835A, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x00718158,
    0x00718158, 0x00718158, 0x00718158, 0x00728259, 0x00718158, 0x00718158, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x00718256, 0x006F8055, 0x006E7E55, 0x00657651, 0x00546442, 0x00495839, 0x0048573B, 0x004D5C40, 0x00526643,
    0x004C5F3E, 0x004A593D, 0x0049573B, 0x00617050, 0x0067774E, 0x00718151, 0x006F824B, 0x00778157, 0x00758256, 0x007A875B, 0x006E7D51, 0x00728259, 0x00647250, 0x00445236, 0x005D6A52, 0x003F4E33, 0x00445338, 0x004E5D42, 0x002F3E23, 0x00455439,
    0x0047563B, 0x002D3C21, 0x00505F44, 0x00526146, 0x00324126, 0x00707F64, 0x004A593E, 0x00314025, 0x004D5C41, 0x00324126, 0x0047563B, 0x0064715B, 0x0035432B, 0x00445338, 0x005E6D51, 0x00334324, 0x00425332, 0x005D6E4C, 0x00455732, 0x005A6846,
    0x004A5A31, 0x00607146, 0x005B6645, 0x00575F48, 0x00797E69, 0x00636B4C, 0x004D592F, 0x00586136, 0x00525C2E, 0x004C5824, 0x00495620, 0x0047541C, 0x0045521A, 0x00424E1A, 0x00404B19, 0x00434C19, 0x00434C19, 0x00444D1A, 0x00454E1B, 0x00464F1C,
    0x00464F1C, 0x0049521F, 0x004D5623, 0x00485620, 0x005B6638, 0x004C5332, 0x005A6049, 0x00595E49, 0x005C654B, 0x00646F4F, 0x00707D57, 0x00697957, 0x006A7C55, 0x006B7D54, 0x006F7E58, 0x005E6B4B, 0xFFCFD5C2, 0xFFFEFFFA, 0xFFFFFEFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFEFEFE, 0x00C6CDB8, 0x0056673B, 0x007E8F64, 0x007A896A, 0x0051623D, 0x002D450B, 0x00354720, 0x00364821, 0x0031431C, 0x002D3F18, 0x00354720,
    0x003B4D26, 0x002E4019, 0x002D3F18, 0x006E7A5C, 0x006F7A60, 0x008E9685, 0x009BA097, 0x00DBDEDC, 0x00DEE1DF, 0x00D1D4D2, 0x00DCE0DB, 0x00D0DBD3, 0x00EDF6EC, 0x00CBD2C5, 0x006C7261, 0x00ABB39C, 0x00879377, 0x00637453, 0x007C8F6E, 0x00717F5D,
    0x00717F5D, 0x006A7856, 0x0074825E, 0x0073825C, 0x0073825C, 0x005D6D44, 0x00526239, 0x00516237, 0x00516237, 0x0067784D, 0x007A8B60, 0x0075865B, 0x00738459, 0x0077885D, 0x00738459, 0x0076875C, 0x0074855A, 0x0076875C, 0x0074845B, 0x007B8B62,
    0x0066764D, 0x0053623C, 0x0045542E, 0x0071835C, 0x004A5C35, 0x0031431C, 0x00556740, 0x005C6E47, 0x0030421B, 0x003B4D26, 0x006E8059, 0x003A4E24, 0x00384C22, 0x00384C22, 0x00364A20, 0x0033471D, 0x0035491F, 0x00374B21, 0x0033471D, 0x0033471D,
    0x0034481E, 0x0032461C, 0x0033471D, 0x0035491F, 0x0033471D, 0x0031451B, 0x0035491F, 0x0033471C, 0x0032461B, 0x0031451B, 0x002E441A, 0x002D421B, 0x002F441D, 0x002B431B, 0x00263D17, 0x002E4218, 0x004E6238, 0x0056683F, 0x0074865D, 0x00708259,
    0x0073835A, 0x00718158, 0x0074845B, 0x00718257, 0x00728358, 0x00738459, 0x00738459, 0x00738459, 0x00738459, 0x00728358, 0x00718257, 0x0073835A, 0x00728259, 0x00728259, 0x00718158, 0x00728259, 0x00728259, 0x0073835A, 0x0073835A, 0x00718158,
    0x00728259, 0x00728259, 0x00728259, 0x00718158, 0x00708057, 0x006F7F56, 0x006F7F56, 0x006E8057, 0x006E8057, 0x006F8158, 0x006F8158, 0x006F8158, 0x00708259, 0x00708259, 0x00708259, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x00718158,
    0x00718158, 0x00718158, 0x00718158, 0x00728259, 0x00718158, 0x00718158, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x006E7F53, 0x00748559, 0x0075855C, 0x0061724D, 0x004E5D3E, 0x00525F45, 0x005C6953, 0x005A6652, 0x004A5E41,
    0x0055684D, 0x00495942, 0x00616E58, 0x0049573B, 0x0052613B, 0x00556633, 0x0076874E, 0x007A7E5A, 0x00767E55, 0x00778156, 0x00738052, 0x00758359, 0x005E6C4A, 0x00414E34, 0x0057624E, 0x00202C18, 0x003C4834, 0x004A5642, 0x001E2A16, 0x00424E3A,
    0x00434F3B, 0x00182410, 0x00525E4A, 0x0047533F, 0x0027331F, 0x00606C58, 0x00384430, 0x002C3824, 0x005F6B57, 0x0036422E, 0x00333F2B, 0x00636E5E, 0x002E3A28, 0x003D4935, 0x005A6850, 0x0026351A, 0x00425233, 0x00576847, 0x00495A38, 0x0052603C,
    0x0053633A, 0x00536439, 0x00505B3B, 0x00636956, 0x00929586, 0x00868C75, 0x0049532F, 0x005C6330, 0x00555D28, 0x004E571E, 0x004B5618, 0x00495416, 0x00465014, 0x00444D15, 0x00444C17, 0x00444B12, 0x00454C13, 0x00454C13, 0x00464D14, 0x00464D14,
    0x00474E15, 0x00495017, 0x004C531A, 0x004E5D1F, 0x00485321, 0x00464B2B, 0x007B7D6A, 0x00707062, 0x00555946, 0x004E5638, 0x0075805A, 0x00697957, 0x006A7B56, 0x006B7D56, 0x006F7E58, 0x005F6B4D, 0xFFD0D6C3, 0xFFFEFFFA, 0xFFFFFEFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFDFF, 0xFFFFFFFF, 0x00C7CEB9, 0x0057683C, 0x007B8C61, 0x00788768, 0x005F704B, 0x00486026, 0x00495B34, 0x00485A33, 0x00455730, 0x0050623B, 0x00475932,
    0x00475932, 0x004B5D36, 0x004B5D36, 0x006E7C53, 0x007A8761, 0x008F9A7A, 0x006E775C, 0x00858E74, 0x00818972, 0x007D856E, 0x00929B81, 0x00809079, 0x0078846E, 0x0078826B, 0x00676E53, 0x00777F61, 0x00687555, 0x00657553, 0x006E835D, 0x0075865B,
    0x00718257, 0x0078895E, 0x007F9064, 0x006E7F53, 0x00738458, 0x00728357, 0x00637448, 0x0056673C, 0x00516237, 0x004E5F34, 0x00637449, 0x007D8E63, 0x0078895E, 0x006D7E53, 0x0078895E, 0x0074855A, 0x00728358, 0x0075865B, 0x0073835A, 0x007A8A61,
    0x0064744B, 0x0051603A, 0x0045542E, 0x006F815A, 0x0072845D, 0x003E5029, 0x0031431C, 0x005D6F48, 0x004D5F38, 0x002D3F18, 0x00475932, 0x0063754C, 0x005D6F46, 0x005E7047, 0x00607249, 0x00607249, 0x0063754C, 0x0064764D, 0x005E7047, 0x005F724B,
    0x0060734C, 0x0060734C, 0x0061744D, 0x0062754E, 0x0062754E, 0x0062754E, 0x0063764F, 0x0062744B, 0x005C6E45, 0x0060744A, 0x0061744D, 0x005A6D46, 0x005A6F49, 0x005A6F49, 0x004A5F39, 0x002E4218, 0x004E6238, 0x0056683F, 0x0074865D, 0x006F8158,
    0x0073835A, 0x00708057, 0x0073835A, 0x00718257, 0x00718257, 0x00728358, 0x00738459, 0x00738459, 0x00728358, 0x00718257, 0x00718257, 0x0076865D, 0x0075855C, 0x0074845B, 0x0073835A, 0x00728259, 0x00728259, 0x00728259, 0x00728259, 0x00728259,
    0x00728259, 0x00728259, 0x00728259, 0x00728259, 0x00718158, 0x00708057, 0x006F7F56, 0x006D7F56, 0x006E8057, 0x006E8057, 0x006E8057, 0x006E8057, 0x006E8057, 0x006E8057, 0x006E8057, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x00718158,
    0x00718158, 0x00718158, 0x00718158, 0x00728259, 0x00718158, 0x00718158, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x006E7F53, 0x00748559, 0x0075855C, 0x0061724D, 0x004D5C3D, 0x00515E44, 0x005B6852, 0x005A6652, 0x00617459,
    0x00607058, 0x0045553E, 0x0065725C, 0x005B6A4F, 0x00667555, 0x004F5F36, 0x00455728, 0x004C5136, 0x00555B3C, 0x005E6941, 0x00728155, 0x0079875D, 0x005D6B49, 0x0048523B, 0x004B5544, 0x001E281B, 0x00475144, 0x004F594C, 0x001A2417, 0x00465043,
    0x00495346, 0x001E281B, 0x00626C5F, 0x004A5447, 0x00263023, 0x005A6457, 0x002E382B, 0x002A3427, 0x00687265, 0x00323C2F, 0x00283225, 0x00646E62, 0x00283225, 0x003A4535, 0x005C6854, 0x00233217, 0x00425233, 0x00566746, 0x00495A38, 0x004E5C38,
    0x0058683F, 0x0054653A, 0x00545F3F, 0x00494F3C, 0x003A3D2E, 0x00434932, 0x0049532F, 0x005E672F, 0x00576027, 0x00505A1E, 0x004D581A, 0x004A5517, 0x00485216, 0x0049521A, 0x004C5320, 0x004B511A, 0x004C521B, 0x004C521B, 0x004C521B, 0x004C521B,
    0x004C521B, 0x004B511A, 0x004A5019, 0x00445316, 0x004C5725, 0x004F5434, 0x00595B48, 0x0048483C, 0x005F6350, 0x005C6446, 0x0067714D, 0x006B7A5A, 0x006C7D58, 0x006D7F58, 0x00717F5B, 0x00606C4E, 0xFFD1D7C6, 0xFFFFFFFC, 0xFFFFFEFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFCFF, 0xFFFFFFFF, 0x00C9D0BB, 0x005A6B3F, 0x007A8B60, 0x007A896A, 0x00788964, 0x00748C52, 0x007B8D66, 0x007B8D66, 0x00758760, 0x007C8E67, 0x007F916A,
    0x00778962, 0x00778962, 0x007F916A, 0x00829367, 0x00708155, 0x007B8C61, 0x00708156, 0x0077875E, 0x0071805A, 0x0072815B, 0x007C8B65, 0x006A7B5A, 0x006F7F5D, 0x00727D5C, 0x006C7652, 0x0069734F, 0x0077845E, 0x00788A63, 0x0072855E, 0x00788A5B,
    0x00748657, 0x00738556, 0x00728455, 0x006A7B4F, 0x00748559, 0x007B8C60, 0x0077885C, 0x0065754C, 0x0054643B, 0x004A5A31, 0x0055653C, 0x00697950, 0x0075855C, 0x0074845B, 0x00718158, 0x00728358, 0x00708156, 0x0074855A, 0x00728259, 0x0078885F,
    0x0063734A, 0x0051603A, 0x0045542E, 0x006D7F58, 0x00788A63, 0x00465831, 0x002F411A, 0x00576942, 0x0051633C, 0x002F411A, 0x00374922, 0x0061734A, 0x00576940, 0x005A6C43, 0x00607249, 0x005E7047, 0x00607249, 0x0062744B, 0x005D6F46, 0x00576944,
    0x00576944, 0x005A6C47, 0x00596B46, 0x00576944, 0x005B6D48, 0x005E704B, 0x00596B46, 0x005D6F46, 0x00596B42, 0x0060724B, 0x0062754E, 0x005C6E49, 0x0060724D, 0x005C714B, 0x004B5F3C, 0x002F4319, 0x004F6339, 0x0056683F, 0x0074865D, 0x006F8158,
    0x00728259, 0x00708057, 0x0073835A, 0x00718257, 0x00728358, 0x00728358, 0x00728358, 0x00728358, 0x00728358, 0x00728358, 0x00718257, 0x0077875E, 0x0076865D, 0x0075855C, 0x0074845B, 0x0073835A, 0x00728259, 0x00728259, 0x00728259, 0x0075855C,
    0x0075855C, 0x0075855C, 0x0075855C, 0x0074845B, 0x0073835A, 0x00728259, 0x00728259, 0x006D7F56, 0x006D7F56, 0x006D7F56, 0x006D7F56, 0x006D7F56, 0x006D7F56, 0x006D7F56, 0x006D7F56, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x00718158,
    0x00718158, 0x00718158, 0x00718158, 0x00728259, 0x00718158, 0x00718158, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x00728357, 0x006F8055, 0x006E7E55, 0x00647550, 0x00536341, 0x00475637, 0x0047563A, 0x004B5A3E, 0x0048563A,
    0x004B593D, 0x004B5A3E, 0x0049583C, 0x00536449, 0x00506146, 0x00495941, 0x00182A13, 0x003A4339, 0x00414D3B, 0x00415031, 0x004D5F38, 0x0053633A, 0x00404E2C, 0x003D452E, 0x00434938, 0x00151F13, 0x00374135, 0x003E483C, 0x00151F13, 0x003A4438,
    0x003B4539, 0x001A2418, 0x004E584C, 0x003C463A, 0x001A2418, 0x00545E52, 0x00252F23, 0x001D271B, 0x005A6458, 0x00202A1E, 0x00293327, 0x00596258, 0x00182216, 0x002F3A2A, 0x0056634D, 0x00202F14, 0x003B4C2B, 0x00536442, 0x0040522D, 0x00515F3D,
    0x004B5B32, 0x0055663B, 0x0065704F, 0x007D856E, 0x006E735E, 0x004D5536, 0x004B572D, 0x005A642F, 0x00525D25, 0x004C581E, 0x004B571B, 0x004A561C, 0x004D5722, 0x00565F2D, 0x0061683B, 0x005E683A, 0x005E683A, 0x005E683A, 0x005E683A, 0x005E683A,
    0x005C6638, 0x00566032, 0x004F592B, 0x004C5925, 0x003D471C, 0x00515738, 0x006F745F, 0x00666A57, 0x00686F5A, 0x005E684A, 0x00737F5B, 0x006D7C5C, 0x006E7E5C, 0x006F805B, 0x0072805C, 0x00616D51, 0xFFD1D7C6, 0xFFFFFFFC, 0xFFFFFEFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFFFFFF, 0x00C3CAB5, 0x0057683C, 0x0076875C, 0x00738263, 0x00758661, 0x00789056, 0x00758760, 0x0074865F, 0x0074865F, 0x006F815A, 0x007D8F68,
    0x00768861, 0x0071835C, 0x007B8D66, 0x007B8D66, 0x0070825B, 0x0076885F, 0x007F9267, 0x007C8F64, 0x0073855C, 0x00798B64, 0x007C8E67, 0x00798D62, 0x007B8E63, 0x007E8C62, 0x00828E64, 0x00808C62, 0x0078865C, 0x0072855A, 0x0072865B, 0x00718354,
    0x00728357, 0x00718256, 0x0075865A, 0x0078895E, 0x0078895E, 0x0073835A, 0x0073835A, 0x0076865D, 0x005C6C43, 0x0057673E, 0x0055653C, 0x004F5F36, 0x0065754C, 0x00798960, 0x006D7D54, 0x00718257, 0x00708156, 0x0074855A, 0x0073835A, 0x0078885F,
    0x0063734A, 0x0051603A, 0x0045542E, 0x006B7D56, 0x006C7E57, 0x0033451E, 0x0040522B, 0x006A7C55, 0x003B4D26, 0x002A3C15, 0x005E7049, 0x0061734C, 0x00556740, 0x00596B44, 0x0060724B, 0x00576942, 0x0052643D, 0x00596B44, 0x005A6C45, 0x00596A48,
    0x00576846, 0x005D6E4C, 0x005B6C4A, 0x00536442, 0x005D6E4C, 0x00637452, 0x00556644, 0x0054643B, 0x00596842, 0x00576942, 0x00566841, 0x00586A45, 0x005A6C47, 0x00526341, 0x00455936, 0x0030441A, 0x0050643A, 0x00576940, 0x0075875E, 0x00708259,
    0x0073835A, 0x00708057, 0x0073835A, 0x00728358, 0x00728358, 0x00728358, 0x00718257, 0x00718257, 0x00728358, 0x00728358, 0x00728358, 0x0075855C, 0x0074845B, 0x0073835A, 0x00728259, 0x00728259, 0x00728259, 0x00728259, 0x0073835A, 0x0075855C,
    0x0075855C, 0x0075855C, 0x0075855C, 0x0075855C, 0x0074845B, 0x0073835A, 0x00728259, 0x006F8158, 0x006F8158, 0x006E8057, 0x006E8057, 0x006E8057, 0x006E8057, 0x006E8057, 0x006E8057, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x00718158,
    0x00718158, 0x00718158, 0x00718158, 0x00728259, 0x00718158, 0x00718158, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x006F7F56, 0x006E7E55, 0x006F7F56, 0x00708259, 0x006D7F58, 0x0063754E, 0x0060734C, 0x00697B56, 0x00565C3D,
    0x00303A16, 0x002A3913, 0x00374924, 0x004D6242, 0x003C4F3E, 0x00465753, 0x00213235, 0x0027373E, 0x003F504C, 0x00495D4A, 0x004B603F, 0x0052653E, 0x0043512F, 0x00333922, 0x00404131, 0x00192317, 0x001E281C, 0x00242E22, 0x00131D11, 0x00273125,
    0x00232D21, 0x00121C10, 0x00252F23, 0x001E281C, 0x00202A1E, 0x00283226, 0x00212B1F, 0x00162014, 0x00283226, 0x001E281C, 0x00172115, 0x00293327, 0x001D271A, 0x001B2715, 0x002E3B25, 0x00324125, 0x00435432, 0x00445730, 0x004D6137, 0x004E5B3B,
    0x0051603A, 0x0066774C, 0x005D6945, 0x0060694E, 0x0061684D, 0x00545F37, 0x0053632E, 0x00566031, 0x004D5826, 0x0044501C, 0x00424F19, 0x00424E1A, 0x00485224, 0x005A6239, 0x006D744F, 0x00667452, 0x00677553, 0x00667452, 0x00657351, 0x00667452,
    0x0062704E, 0x00566442, 0x004A5836, 0x003A4721, 0x003A4622, 0x00424C2E, 0x004D583E, 0x00576248, 0x00637155, 0x00667555, 0x006B7C57, 0x006F7E5E, 0x006F7F5D, 0x006F805B, 0x0072805E, 0x00616D51, 0xFFD0D5C6, 0xFFFEFFFD, 0xFFFFFEFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFBFBFB, 0x00BCC3AE, 0x0058693D, 0x007E8F64, 0x00798869, 0x00778863, 0x00758D53, 0x00798B64, 0x0074865F, 0x0081936C, 0x0072845D, 0x007C8E67,
    0x007A8C65, 0x00788A63, 0x007B8D66, 0x00718366, 0x007E9071, 0x00708461, 0x00728761, 0x00748963, 0x00748963, 0x00748865, 0x006F8261, 0x006F8555, 0x00728455, 0x00788859, 0x00778156, 0x007F895E, 0x00738256, 0x00798A5F, 0x006E8257, 0x00748559,
    0x00738458, 0x00738459, 0x0074845B, 0x00718158, 0x006B7A54, 0x006D7C56, 0x0075835F, 0x007A8A61, 0x00728259, 0x005F6F46, 0x004F5F36, 0x004D5D34, 0x0056663D, 0x0068784F, 0x00798960, 0x00718257, 0x00718257, 0x0075865B, 0x0073835A, 0x00798960,
    0x0063734A, 0x0052613B, 0x0046552F, 0x006E8059, 0x00394B24, 0x002C3E17, 0x006A7C55, 0x0054663F, 0x00273912, 0x0054663F, 0x005F714A, 0x0032411B, 0x00283711, 0x0032411B, 0x003D4C26, 0x0035441E, 0x0033421C, 0x0042512B, 0x004C5B35, 0x00364725,
    0x00334422, 0x003C4D2B, 0x00384927, 0x002C3D1B, 0x00384927, 0x00415230, 0x002D3E1C, 0x00404F29, 0x004B5A34, 0x003F512A, 0x00364722, 0x003E502B, 0x003A4B29, 0x002A3B19, 0x00243815, 0x0030441A, 0x0050643A, 0x00576940, 0x0075875E, 0x00708259,
    0x0073835A, 0x00708057, 0x0073835A, 0x00738459, 0x00728358, 0x00728358, 0x00718257, 0x00718257, 0x00728358, 0x00728358, 0x00738459, 0x00728259, 0x00728259, 0x00718158, 0x00718158, 0x00718158, 0x00728259, 0x0073835A, 0x0073835A, 0x0073835A,
    0x0073835A, 0x0073835A, 0x0073835A, 0x0073835A, 0x00728259, 0x00718158, 0x00708057, 0x00708259, 0x00708259, 0x00708259, 0x006F8158, 0x006F8158, 0x006F8158, 0x006F8158, 0x006F8158, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x00718158,
    0x00718158, 0x00718158, 0x00718158, 0x00728259, 0x00718158, 0x00718158, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x006F7E58, 0x0074845B, 0x00718158, 0x006C7E55, 0x00708358, 0x006E8156, 0x00697E51, 0x006D8255, 0x00434724,
    0x00343C14, 0x002C390D, 0x0036491E, 0x002D4222, 0x00405447, 0x0065777E, 0x005B6C7F, 0x00586C7D, 0x006C8287, 0x006E8577, 0x0051694B, 0x0050653F, 0x00465432, 0x002E341B, 0x004D4D3B, 0x00384235, 0x001D271A, 0x001E281B, 0x001C2619, 0x00212B1E,
    0x001B2518, 0x001B2518, 0x00192316, 0x001D271A, 0x00192316, 0x00202A1D, 0x001F291C, 0x001B2518, 0x002A3427, 0x001A2417, 0x001C2619, 0x001A2418, 0x001C2619, 0x001D2917, 0x00233119, 0x002D3D1E, 0x00495B36, 0x0052663C, 0x00455A2D, 0x00525E40,
    0x00495733, 0x00617247, 0x0076835D, 0x00707B5B, 0x005D6645, 0x00626F41, 0x005B6D32, 0x00566035, 0x004A5527, 0x003D4919, 0x00354111, 0x00323D0F, 0x00384218, 0x004E5532, 0x00646B4A, 0x0065765B, 0x0065765B, 0x0064755A, 0x00637459, 0x0064755A,
    0x005F7055, 0x004F6045, 0x00405136, 0x00344022, 0x00414D2F, 0x00394527, 0x003B4A2B, 0x00556445, 0x00617251, 0x0070815F, 0x006A7B59, 0x006F7E5F, 0x006F7F5D, 0x006F805B, 0x0072805E, 0x00606C50, 0xFFCFD4C5, 0xFFFDFEFC, 0xFFFEFCFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFFFFFE, 0x00BAC1AC, 0x00586839, 0x0078875B, 0x00838E6E, 0x0066724E, 0x005E7138, 0x0063734A, 0x0064744B, 0x0063734A, 0x005F6F46, 0x005E6E45,
    0x0067774E, 0x00607047, 0x00627249, 0x00708565, 0x004F6247, 0x003D4D3B, 0x0069786A, 0x0049584A, 0x00354631, 0x0033462B, 0x003B502F, 0x00364236, 0x002E3A2E, 0x00354234, 0x00485442, 0x004A5840, 0x00455434, 0x00697C51, 0x00748859, 0x0076895E,
    0x0074865D, 0x0073855C, 0x00708259, 0x00758760, 0x006D7F58, 0x006F805B, 0x00768762, 0x0076855F, 0x00788761, 0x0074835D, 0x005E6D47, 0x0052613B, 0x004F5E38, 0x0054633D, 0x0072815B, 0x0074835D, 0x006F7E58, 0x0075845E, 0x006E7D57, 0x007B8A64,
    0x00677650, 0x00495832, 0x00485731, 0x00424D25, 0x00364119, 0x0065734A, 0x00627047, 0x002C3C13, 0x0047572E, 0x0063754C, 0x003D4F26, 0x002C4016, 0x00283C12, 0x00475B31, 0x00586B44, 0x0051643D, 0x0041532E, 0x005F714C, 0x00485A35, 0x003A4C27,
    0x004C5E39, 0x0051643D, 0x004F6339, 0x00394D23, 0x005A6E43, 0x005B7043, 0x00455A2D, 0x0055673E, 0x0055673E, 0x0042562C, 0x00455831, 0x00566B44, 0x00536842, 0x003A512B, 0x00233A14, 0x002C4016, 0x004D6137, 0x0054683E, 0x0072865C, 0x006A7E54,
    0x0070845A, 0x0072865C, 0x006F8359, 0x0070825B, 0x0071835C, 0x0071835C, 0x0072845D, 0x0072845D, 0x0073855E, 0x0073855E, 0x0073855E, 0x00758458, 0x00748357, 0x00748258, 0x00738157, 0x00738158, 0x00748259, 0x00748259, 0x0074815B, 0x00728259,
    0x00728259, 0x0073835A, 0x0074845B, 0x0074845B, 0x0073835A, 0x00728259, 0x00728259, 0x0074855A, 0x0074855A, 0x00738459, 0x00728358, 0x00728358, 0x00728358, 0x00738459, 0x00738459, 0x006B7D54, 0x006D7F56, 0x006E8057, 0x00708259, 0x0071835A,
    0x00708259, 0x006F8158, 0x006F8158, 0x006E8156, 0x006E8156, 0x006F8257, 0x00708358, 0x00708358, 0x006F8257, 0x006E8156, 0x006D8055, 0x0070825B, 0x0071835C, 0x0070825B, 0x006D7F58, 0x006E8059, 0x006F815A, 0x006D7F58, 0x00687A53, 0x00343E14,
    0x00374325, 0x00314129, 0x003C4C2D, 0x00627351, 0x005C6F5E, 0x006A859A, 0x006281B8, 0x006F8AAC, 0x006D8896, 0x002E4739, 0x00435A34, 0x004C6033, 0x003C4A28, 0x00262F22, 0x00474F4F, 0x00465141, 0x00434E3E, 0x003A4535, 0x00475242, 0x00333E2E,
    0x00354030, 0x00434E3E, 0x00323D2D, 0x00363F2B, 0x00414A36, 0x0038412D, 0x003F4631, 0x003F4631, 0x003F452E, 0x002C321B, 0x00232912, 0x00272916, 0x00282C19, 0x00242A13, 0x002C3219, 0x00343E20, 0x005F6A49, 0x004C5B35, 0x0051603A, 0x00495E3D,
    0x00465C39, 0x005B6E47, 0x006D7E53, 0x006A7749, 0x00657246, 0x005F6F46, 0x00546740, 0x00596338, 0x004F5B37, 0x00465540, 0x00495B54, 0x00879A9D, 0x009CACB3, 0x00A7B1BB, 0x00A7B0B9, 0x00ADBCBE, 0x00ADBCBE, 0x00ADBCBE, 0x00ACBBBD, 0x00AAB9BB,
    0x00A7B6B8, 0x00A4B3B5, 0x00A2B1B3, 0x00A4B2B8, 0x00A1AFB5, 0x00A4B2B8, 0x00A3B1B7, 0x00A8B6BC, 0x00AFBDC3, 0x00ACBAC0, 0x00AEBCC2, 0x00BCC3C6, 0x007F8C7C, 0x006D7F5A, 0x0076885F, 0x00616D4F, 0xFFCFD3C7, 0xFFFFFFFE, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFAFC, 0xFFFDFEFC, 0x00BAC1AC, 0x005C6C3D, 0x007B8A5E, 0x007C8767, 0x004E5A36, 0x003A4D14, 0x00314118, 0x00304017, 0x00324219, 0x00314118, 0x0033431A,
    0x002D3D14, 0x002D3D14, 0x0035451C, 0x00667960, 0x0050604E, 0x00616F64, 0x00828D8A, 0x00838E8C, 0x007E8A84, 0x00758377, 0x00778776, 0x006E796F, 0x00869187, 0x00879086, 0x00555F52, 0x003B4832, 0x004A593A, 0x0073855E, 0x0073875A, 0x0071835C,
    0x00788A63, 0x00778962, 0x00798B64, 0x007C8E65, 0x007D8F66, 0x0075875E, 0x0074875C, 0x0074835D, 0x006C7B55, 0x007A8963, 0x00788761, 0x005A6943, 0x004D5C36, 0x00505F39, 0x004F5E38, 0x0073825C, 0x0071805A, 0x007B8A64, 0x00778660, 0x00707F59,
    0x0064734D, 0x00586741, 0x0035441E, 0x002B3B12, 0x0054643B, 0x005C6C43, 0x0033451C, 0x0036481F, 0x005D6F46, 0x0052663C, 0x002B3F15, 0x002B3F15, 0x002E4218, 0x00465932, 0x004F623B, 0x00475934, 0x003B4D28, 0x00586A45, 0x003B4C2A, 0x00283B14,
    0x00485B34, 0x003B4F25, 0x00394D23, 0x0040542A, 0x004B5F35, 0x0032461C, 0x0033471D, 0x00586A41, 0x0045572E, 0x002C3F18, 0x003E512A, 0x005B704A, 0x00556A44, 0x00384F29, 0x00253B18, 0x00364A20, 0x0051653B, 0x0055693F, 0x0074885E, 0x0071855B,
    0x00778B61, 0x0074885E, 0x006D8157, 0x0071835C, 0x0072845D, 0x0072845D, 0x0072845D, 0x0072845D, 0x0072845D, 0x0071835C, 0x0071835C, 0x0075865A, 0x0074855A, 0x0074855A, 0x00738459, 0x00728259, 0x00728259, 0x0072815B, 0x0073825C, 0x00728358,
    0x00728358, 0x00738459, 0x00738459, 0x00738459, 0x00738459, 0x00728358, 0x00728358, 0x00708358, 0x006F8257, 0x006F8257, 0x006F8257, 0x006F8257, 0x00708358, 0x00718459, 0x00718459, 0x00708259, 0x0071835A, 0x0071835A, 0x0071835A, 0x0071835A,
    0x00708259, 0x006F8158, 0x006E8057, 0x00708259, 0x00708259, 0x00708259, 0x00708259, 0x00708259, 0x006F8158, 0x006F8158, 0x006E8057, 0x0070825B, 0x0071835C, 0x0070825B, 0x006E8059, 0x006F815A, 0x0070825B, 0x006D7F58, 0x00687A53, 0x00464C35,
    0x00687265, 0x00717F74, 0x004D5D46, 0x00455837, 0x003F5640, 0x0063818C, 0x007399C3, 0x007192B3, 0x00708F9E, 0x00436051, 0x005A734D, 0x0065794C, 0x00586642, 0x002E3827, 0x00434A45, 0x00455040, 0x00333E2E, 0x00343F2F, 0x00404B3B, 0x00323D2D,
    0x003B4636, 0x00414C3C, 0x003D4838, 0x00414A36, 0x00404935, 0x003D4632, 0x00454C37, 0x003A412C, 0x00353A25, 0x00272D16, 0x00292F18, 0x002C2F1F, 0x00292D1A, 0x0030361F, 0x00232C12, 0x004A5436, 0x0053613F, 0x004B5935, 0x004C5B35, 0x004E6342,
    0x004B603A, 0x005A6A41, 0x00677448, 0x00657042, 0x00606D3F, 0x00606F43, 0x0057683D, 0x005C653A, 0x005D6945, 0x006C7963, 0x0075867D, 0x00B7C6C8, 0x00D4E2E8, 0x00DFE9F0, 0x00E4EDF1, 0x00DAE6E8, 0x00DBE7E9, 0x00DBE7E9, 0x00DDE9EB, 0x00DDE9EB,
    0x00DDE9EB, 0x00DCE8EA, 0x00DBE7E9, 0x00DDE8EC, 0x00D9E4E8, 0x00DDE8EC, 0x00DDE8EC, 0x00DFEAEE, 0x00E2EDF1, 0x00D9E4E8, 0x00D7E2E6, 0x00D9E0E3, 0x008F9C8C, 0x006E805B, 0x0072845B, 0x005F6B4D, 0xFFD0D4C8, 0xFFFFFFFE, 0xFFFFFDFD, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFEFFFD, 0x00B9C0AB, 0x005B6B3C, 0x007C8B5F, 0x007C8767, 0x004A5632, 0x0032450C, 0x00526239, 0x0055653C, 0x0047572E, 0x0034441B, 0x0056663D,
    0x0048582F, 0x0034441B, 0x003E4E25, 0x00889782, 0x00505D4F, 0x005E6764, 0x00959BA2, 0x00D4D8E3, 0x00DEE2ED, 0x00D0D6DD, 0x00D3D9DE, 0x00DFE8E5, 0x00E2E9E6, 0x00C7CEC9, 0x00717A70, 0x00505A4A, 0x004E5B43, 0x00647250, 0x0064734D, 0x006C795F,
    0x005D6B4F, 0x00485738, 0x00556444, 0x00556641, 0x00586A43, 0x004F6138, 0x005B6E43, 0x0075855C, 0x0077875E, 0x0075855C, 0x0078885F, 0x00718158, 0x005E6E45, 0x0054643B, 0x00516138, 0x00586741, 0x00788761, 0x0073825C, 0x0071805A, 0x007E8D67,
    0x0065744E, 0x00505F39, 0x003F4E28, 0x00374922, 0x0061734C, 0x00455831, 0x0023360F, 0x004E633C, 0x005B7049, 0x002E461E, 0x00233B13, 0x002F4319, 0x002C3F18, 0x00384B24, 0x004B5E37, 0x0052643F, 0x00475934, 0x00576846, 0x00314220, 0x002C4015,
    0x0043572C, 0x004C6036, 0x0051643D, 0x00465932, 0x00566843, 0x00516240, 0x004B5C3A, 0x005A6C43, 0x00465831, 0x002E411A, 0x003E512A, 0x00576C46, 0x004F643E, 0x00384E2B, 0x00283E1B, 0x002A3D16, 0x004A5D36, 0x00576A43, 0x0073865F, 0x006D8059,
    0x0071845D, 0x0073865F, 0x00748760, 0x0071835C, 0x0071835C, 0x0072845D, 0x0072845D, 0x0071835C, 0x0070825B, 0x006F815A, 0x006E8059, 0x0075865B, 0x0074855A, 0x00738459, 0x00728259, 0x00728259, 0x0071805A, 0x0071805A, 0x0072815B, 0x006E8255,
    0x006E8255, 0x006F8356, 0x006F8356, 0x006F8356, 0x006F8356, 0x006E8255, 0x006E8255, 0x006E8156, 0x006E8156, 0x006E8156, 0x006E8156, 0x006F8257, 0x00708358, 0x00718459, 0x00718459, 0x0072845B, 0x0072845B, 0x0071835A, 0x0071835A, 0x00708259,
    0x006F8158, 0x006F8158, 0x006E8057, 0x0072845B, 0x0072845B, 0x0071835A, 0x00708259, 0x00708259, 0x00708259, 0x00708259, 0x00708259, 0x0070825B, 0x0070825B, 0x006F815A, 0x006E8059, 0x0070825B, 0x0072845D, 0x006E8059, 0x00687A53, 0x003C403B,
    0x00939A9D, 0x00AEBABE, 0x005B6C5F, 0x003C4E31, 0x004B644A, 0x00729696, 0x00749FBA, 0x007298BA, 0x00779BAB, 0x00527365, 0x00647E5A, 0x00667B4E, 0x00586741, 0x002E3821, 0x00444D40, 0x00353F2F, 0x00273121, 0x002D3727, 0x002C3626, 0x00283222,
    0x00333D2D, 0x002B3525, 0x00353F2F, 0x00353D2C, 0x00333B2A, 0x00363F2B, 0x00414734, 0x00363D28, 0x00373C27, 0x002C311C, 0x002B311A, 0x00252818, 0x002B2F1C, 0x00222914, 0x002C351B, 0x00343E20, 0x0052603E, 0x0045532F, 0x0055643E, 0x004A5F3E,
    0x004D5F38, 0x005D673C, 0x005C6637, 0x00535E30, 0x004E5B2F, 0x00556236, 0x00566035, 0x004C562B, 0x004E5938, 0x006A7660, 0x00717C72, 0x00B3BDBD, 0x00D7E0E3, 0x00D8E0E0, 0x00D4DCDC, 0x00DDE4E7, 0x00DCE3E6, 0x00DAE1E4, 0x00DAE1E4, 0x00DBE2E5,
    0x00DAE1E4, 0x00D8DFE2, 0x00D6DDE0, 0x00D9E1E1, 0x00D9E1E1, 0x00DFE7E7, 0x00DCE4E4, 0x00D9E1E1, 0x00DAE2E2, 0x00D8E0E0, 0x00DEE6E6, 0x00E4EBEE, 0x0094A191, 0x006E805B, 0x00708259, 0x005F6B4D, 0xFFD3D7CB, 0xFFFFFFFE, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFFFFFE, 0x00B9C0AB, 0x005A6A3B, 0x007B8A5E, 0x007E8969, 0x00515D39, 0x003D5017, 0x0068784F, 0x005E6E45, 0x00607047, 0x003B4B22, 0x00617148,
    0x0065754C, 0x0048582F, 0x00405027, 0x007C8E71, 0x0051604B, 0x00515C54, 0x009FA5AA, 0x00DBDEEC, 0x00CFD2E1, 0x00C1C4D2, 0x00C8CCD7, 0x00CACFD0, 0x00DADFE0, 0x00C9CFCE, 0x00636964, 0x00474F44, 0x00434C38, 0x00445034, 0x003F4D2B, 0x006E736A,
    0x005B6057, 0x00363D30, 0x003E4635, 0x0039432C, 0x00475337, 0x003C4929, 0x00475533, 0x006E7E55, 0x0078885F, 0x006B7B52, 0x00708057, 0x007D8D64, 0x006F7F56, 0x005D6D44, 0x00526239, 0x00586741, 0x005E6D47, 0x006D7C56, 0x007F8E68, 0x00788761,
    0x005E6D47, 0x004F5E38, 0x003C4B25, 0x00445932, 0x00485D36, 0x002D421B, 0x002C441C, 0x00506840, 0x00415931, 0x001B350D, 0x0028421A, 0x00293C15, 0x002B3E17, 0x003A4D26, 0x0052643F, 0x00536540, 0x0040512F, 0x00586947, 0x004E5F3D, 0x00384C21,
    0x003F5328, 0x0055693F, 0x00566942, 0x0032441F, 0x004D5E3D, 0x005E6F4E, 0x00455536, 0x0051633C, 0x0054663F, 0x00455831, 0x003F512C, 0x00425731, 0x003E522F, 0x00334926, 0x00253B18, 0x002D4019, 0x004C5F38, 0x005E714A, 0x00748760, 0x006C7F58,
    0x006B7E57, 0x006F825B, 0x0073865F, 0x006F815A, 0x0070825B, 0x0071835C, 0x0071835C, 0x0071835C, 0x0070825B, 0x006F815A, 0x006E8059, 0x00718459, 0x00718459, 0x00708259, 0x006F8158, 0x006F815A, 0x006F815A, 0x006F815A, 0x006F805B, 0x006D8255,
    0x006E8356, 0x006E8356, 0x006E8356, 0x006E8356, 0x006E8356, 0x006E8356, 0x006D8255, 0x006F8158, 0x006F8158, 0x006F8158, 0x006F8158, 0x00708259, 0x00708259, 0x0071835A, 0x0072845B, 0x006F8158, 0x006F8158, 0x006F8158, 0x006F8158, 0x006F8158,
    0x006F8158, 0x00708259, 0x00708259, 0x0073855C, 0x0072845B, 0x0071835A, 0x00708259, 0x00708259, 0x00708259, 0x00708259, 0x0071835A, 0x0070825B, 0x0070825B, 0x006F815A, 0x006F815A, 0x0071835C, 0x0073855E, 0x006F815A, 0x00687A53, 0x00393E3C,
    0x00616C70, 0x0069767E, 0x0045544C, 0x004B5E43, 0x00556E54, 0x00769897, 0x00759FB6, 0x006B97B6, 0x00749BA9, 0x0046685D, 0x005B7654, 0x0062774A, 0x004F5F36, 0x002E3A1C, 0x004D5642, 0x003C4636, 0x003D4737, 0x00424C3C, 0x00353F2F, 0x00384232,
    0x00404A3A, 0x00313B2B, 0x003D4737, 0x00293120, 0x00363E2D, 0x00313928, 0x003C422F, 0x003B412E, 0x00424732, 0x00393E29, 0x00252A15, 0x002E3121, 0x00212716, 0x002E3520, 0x00262F15, 0x003C482C, 0x004C5939, 0x00586944, 0x00546540, 0x004A5D3C,
    0x0056643B, 0x0063693A, 0x00505829, 0x003D491F, 0x0030411C, 0x003C4B25, 0x00434F25, 0x00435128, 0x00424D2D, 0x0067705C, 0x0071796F, 0x00B5BBBA, 0x00D8DEDD, 0x00BCC3C0, 0x00A4ABA6, 0x009CA0A1, 0x00989C9D, 0x00949899, 0x00929697, 0x00929697,
    0x00919596, 0x008E9293, 0x008B8F90, 0x009BA09E, 0x009FA4A2, 0x00A8ADAB, 0x00A1A6A4, 0x00979C9A, 0x009DA2A0, 0x00ADB2B0, 0x00C5CAC8, 0x00DCE3E6, 0x008F9C8C, 0x006D7F5A, 0x0073855C, 0x00616D4F, 0xFFD2D6CA, 0xFFFFFFFE, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCFBFD, 0xFFFEFFFD, 0x00BBC2AD, 0x005C6C3D, 0x007A895D, 0x007B8666, 0x004D5935, 0x003A4D14, 0x00596940, 0x00394920, 0x00607047, 0x00425229, 0x004B5B32,
    0x005C6C43, 0x0047572E, 0x00304017, 0x00687B54, 0x00677758, 0x005B6755, 0x00AFB6B3, 0x00DADEE3, 0x00C6C9D1, 0x00BEC2C7, 0x00B8BCC1, 0x00CACFD2, 0x00D2D7DA, 0x00CED2D3, 0x00818684, 0x0081867D, 0x00666E5D, 0x005C654B, 0x00677252, 0x00919296,
    0x00848687, 0x00545656, 0x004F534D, 0x005C6257, 0x00818879, 0x005D6652, 0x0037402B, 0x0074845B, 0x0073835A, 0x00728259, 0x0076865D, 0x006F7F56, 0x00718158, 0x0075855C, 0x00596940, 0x00596842, 0x004B5A34, 0x005E6D47, 0x0076855F, 0x00778660,
    0x006A7953, 0x004F5E38, 0x0042512B, 0x002A3F19, 0x00283D17, 0x0020350F, 0x00233A14, 0x002E451F, 0x00283F19, 0x001E3711, 0x00223B15, 0x002A3D16, 0x00283A15, 0x00293B16, 0x0032441F, 0x002F401E, 0x0020310F, 0x00344524, 0x00364726, 0x002B3E17,
    0x0032451E, 0x0032441F, 0x002E401B, 0x00253614, 0x00334423, 0x00334423, 0x00273718, 0x0030421B, 0x0041522D, 0x003B4D28, 0x0030421D, 0x002B3F1C, 0x002D411E, 0x002D4221, 0x00243918, 0x003A4C27, 0x004B5D38, 0x00596B46, 0x006E805B, 0x006F815C,
    0x0070825D, 0x006D7F5A, 0x006D7F5A, 0x006F815A, 0x0070825B, 0x0070825B, 0x0070825B, 0x0070825B, 0x0070825B, 0x006F815A, 0x006E8059, 0x006E8258, 0x006E8258, 0x006D8157, 0x006D8059, 0x006D8059, 0x006D7F5A, 0x006E805B, 0x006F815C, 0x006C8357,
    0x006C8357, 0x006C8357, 0x006C8357, 0x006C8357, 0x006C8357, 0x006C8357, 0x006C8357, 0x006E8258, 0x006E8258, 0x006E8258, 0x006D8157, 0x006E8258, 0x006E8258, 0x006F8359, 0x006F8359, 0x006D7F56, 0x006D7F56, 0x006D7F56, 0x006D7F56, 0x006E8057,
    0x006F8158, 0x00708259, 0x00708259, 0x0072845D, 0x0071835C, 0x0070825B, 0x006F815A, 0x006F815A, 0x006F815A, 0x0070825B, 0x0070825B, 0x006F815A, 0x0070825B, 0x006F815A, 0x006F815A, 0x0070825B, 0x0072845D, 0x006F815A, 0x006A7C55, 0x00434F3B,
    0x006E7D75, 0x00778584, 0x005C6A5F, 0x004B5941, 0x00314630, 0x00658286, 0x0081A6C2, 0x007099B0, 0x007398A0, 0x00385649, 0x005B7452, 0x006D8055, 0x00546239, 0x00313D1F, 0x004B543F, 0x003D4737, 0x00313B2B, 0x00364030, 0x00323C2C, 0x00313B2B,
    0x00353F2F, 0x00323C2C, 0x00323C2C, 0x00282F20, 0x003E4536, 0x00303827, 0x003A402F, 0x003B412E, 0x003F4330, 0x00393E29, 0x00232813, 0x0024291A, 0x001E2413, 0x00222815, 0x001C260F, 0x003A462A, 0x00485737, 0x004C5C3A, 0x0041522D, 0x00596B4C,
    0x00667046, 0x00666A39, 0x00454C21, 0x00314324, 0x00243D29, 0x00304830, 0x0035492C, 0x00324321, 0x002A371D, 0x00566050, 0x006A706B, 0x00B3B8B7, 0x00D6DCDB, 0x00B2B9B4, 0x008E9991, 0x00989C9D, 0x0095999A, 0x00929697, 0x00929697, 0x0095999A,
    0x0095999A, 0x00939798, 0x00919596, 0x00939896, 0x00959A98, 0x009CA19F, 0x00929795, 0x00898E8C, 0x00939896, 0x00AFB4B2, 0x00D1D6D4, 0x00DBE2E5, 0x008E9B8B, 0x006E805B, 0x0075875E, 0x00647052, 0xFFD2D6CA, 0xFFFEFFFD, 0xFFFFFEFE, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFAFC, 0xFFFDFEFC, 0x00BBC2AD, 0x005C6C3D, 0x007A895D, 0x007A8565, 0x004E5A36, 0x003B4E15, 0x005F6F46, 0x00495930, 0x005E6E45, 0x004B5B32, 0x005F6F46,
    0x005C6C43, 0x0035451C, 0x00304017, 0x0063774C, 0x005D6E4C, 0x0053604A, 0x00A3ACA2, 0x00DCE2E1, 0x00CDD2D3, 0x00C8CECD, 0x00BDC4C1, 0x00CCCFD3, 0x00CDD0D4, 0x00D3D7D8, 0x00A8ABA9, 0x00B9BEB5, 0x00787E6B, 0x00535C41, 0x00636E4E, 0x00939492,
    0x008C8D89, 0x00686A64, 0x0062655C, 0x0073776B, 0x00959A8B, 0x007D8372, 0x005D6350, 0x00697A4F, 0x0075865B, 0x00798A5F, 0x0074855A, 0x006D7E53, 0x00728358, 0x00798A5F, 0x00728358, 0x00596842, 0x0053623C, 0x00505F39, 0x005A6943, 0x0074835D,
    0x007B8A64, 0x00576640, 0x0054633D, 0x004D5E39, 0x00576843, 0x00556742, 0x0052643F, 0x004E633D, 0x004F643E, 0x00536A44, 0x00526943, 0x005B6D48, 0x00556742, 0x004E603B, 0x00475836, 0x004D5E3C, 0x004D5E3D, 0x00455635, 0x00364726, 0x0039492A,
    0x0039492A, 0x003A4A2B, 0x00485938, 0x004E5F3D, 0x004B5C3A, 0x00465735, 0x004D5F3A, 0x0051623D, 0x00566742, 0x0050623D, 0x00526341, 0x00526643, 0x004F6241, 0x004F6443, 0x004A5F3E, 0x00495B36, 0x00546641, 0x0061734E, 0x006F815C, 0x006F815C,
    0x006E805B, 0x006B7D58, 0x006C7E59, 0x006E8059, 0x006D7F58, 0x006B7D56, 0x006A7C55, 0x00687A53, 0x00667851, 0x00657750, 0x0064764F, 0x0061774D, 0x0061774D, 0x0060754E, 0x0060754E, 0x0060754F, 0x0060754F, 0x00617650, 0x00617552, 0x005F774F,
    0x005F774F, 0x005E764E, 0x005E764E, 0x005E764E, 0x005E764E, 0x005F774F, 0x005F774F, 0x0061754B, 0x0060744A, 0x0060744A, 0x0060744A, 0x0061754B, 0x0062764C, 0x0063774D, 0x0064784E, 0x0065774E, 0x0066784F, 0x00677950, 0x00697B52, 0x006A7C53,
    0x006B7D54, 0x006C7E55, 0x006C7E55, 0x006E8059, 0x006E8059, 0x006E8059, 0x006E8059, 0x006E8059, 0x006E8059, 0x006E8059, 0x006F815A, 0x006F815A, 0x0070825B, 0x0070825B, 0x006E8059, 0x006E8059, 0x0070825B, 0x006F815A, 0x006C7E57, 0x005D6F48,
    0x0099A991, 0x00A6B7AA, 0x007E8A78, 0x005A664A, 0x003D4D35, 0x00708888, 0x008BABC2, 0x007E9FAE, 0x00789697, 0x00445B4C, 0x00647756, 0x0064744B, 0x0046522E, 0x00283418, 0x00424D39, 0x003A4132, 0x00171E0F, 0x001D2415, 0x0022291A, 0x001D2415,
    0x001F2617, 0x0022291A, 0x001C2314, 0x00171E0F, 0x0022291A, 0x001F2617, 0x00292F1E, 0x00262C1B, 0x002E321F, 0x002C301D, 0x00272B18, 0x0024291A, 0x00333A2B, 0x001F2814, 0x002E3821, 0x002F3D21, 0x00526142, 0x00485937, 0x005A6B49, 0x0065785D,
    0x006A734B, 0x005F6231, 0x003A451F, 0x00375445, 0x00345C5B, 0x003E6563, 0x003E6056, 0x002F452C, 0x00283826, 0x005F6A60, 0x00808584, 0x00C5C8CC, 0x00DEE3E4, 0x00B4BFBC, 0x008E9D95, 0x00949A99, 0x00929897, 0x00929897, 0x00939998, 0x00959B9A,
    0x00979D9C, 0x00959B9A, 0x00949A99, 0x00979E9B, 0x00939A97, 0x00959C99, 0x008D9491, 0x00888F8C, 0x00949B98, 0x00ADB4B1, 0x00CDD4D1, 0x00E1E8EB, 0x008E9B8B, 0x006A7C57, 0x0074865D, 0x00667254, 0xFFD5D9CD, 0xFFFFFFFE, 0xFFFFFEFE, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFFFFFE, 0x00B9C0AB, 0x005A6A3B, 0x007A895D, 0x007D8868, 0x00515D39, 0x003D5017, 0x0066764D, 0x0068784F, 0x0055653C, 0x004E5E35, 0x006E7E55,
    0x005F6F46, 0x0037471E, 0x003D4D24, 0x00687757, 0x005A674D, 0x00868F82, 0x00A4A9A7, 0x00E1E5E6, 0x00C9CCD0, 0x00C1C6C5, 0x00C0C5C3, 0x00BEC2C3, 0x00DCE0E1, 0x00D0D2D2, 0x0070746F, 0x0084887D, 0x00616853, 0x00576143, 0x00616C4B, 0x00525B41,
    0x005B644A, 0x00596248, 0x00565F44, 0x00535C41, 0x00576045, 0x005F694B, 0x006D7759, 0x00495A2F, 0x0064754A, 0x00718257, 0x00718257, 0x0078895E, 0x00728358, 0x0068794E, 0x0075865B, 0x0074835D, 0x005B6A44, 0x0056653F, 0x005C6B45, 0x0056653F,
    0x00707F59, 0x0072815B, 0x005A6943, 0x00515F3D, 0x00576543, 0x0053613F, 0x0051613F, 0x004F5F3D, 0x004B5B39, 0x004F603E, 0x004F603E, 0x00455732, 0x004C5E39, 0x00556644, 0x00495A38, 0x004B5C3B, 0x004B5C3B, 0x002E3F1E, 0x00223213, 0x001F2B17,
    0x0014210B, 0x00253419, 0x00455536, 0x004B5C3A, 0x00485A35, 0x004C6036, 0x00506439, 0x004E5F3A, 0x004D5E39, 0x004A5B39, 0x00536442, 0x00526544, 0x004B5E3D, 0x004B603F, 0x004B6040, 0x00516240, 0x00586947, 0x00647553, 0x006C7D5B, 0x006A7B59,
    0x00667755, 0x00647553, 0x00697A58, 0x00677952, 0x0064764F, 0x0060724B, 0x005A6C45, 0x00556740, 0x0050623B, 0x004E6039, 0x004D5F38, 0x00465E34, 0x00455D35, 0x00445C34, 0x00435B33, 0x00425933, 0x00415832, 0x00415734, 0x00415734, 0x003E5634,
    0x003E5634, 0x003D5533, 0x003C5432, 0x003C5432, 0x003D5533, 0x003E5634, 0x003E5634, 0x0041562F, 0x0041562F, 0x00425730, 0x00435831, 0x00455A33, 0x00475C35, 0x00485D36, 0x00495E37, 0x0052643B, 0x0054663D, 0x00586A41, 0x005C6E45, 0x00607249,
    0x0064764D, 0x0066784F, 0x00677950, 0x006A7B56, 0x006A7B56, 0x006B7C57, 0x006C7D58, 0x006D7E59, 0x006D7E59, 0x006D7E59, 0x006D7E59, 0x006E8059, 0x0070825B, 0x0070825B, 0x006D7F58, 0x006C7E57, 0x006E8059, 0x006F815A, 0x006E8059, 0x00455526,
    0x003B4B2C, 0x00404E3C, 0x00444E37, 0x00656D48, 0x005B6945, 0x005F7668, 0x0066858E, 0x00789195, 0x00667C77, 0x0051624D, 0x00687555, 0x00505B35, 0x00404B2B, 0x002A371F, 0x00475444, 0x003E4536, 0x002E3526, 0x00394031, 0x00282F20, 0x00333A2B,
    0x00383F30, 0x00282F20, 0x00343B2C, 0x002E3526, 0x0022291A, 0x003A4132, 0x00393E2F, 0x002C3221, 0x00494C3C, 0x003E422F, 0x003C402D, 0x00363D30, 0x00303728, 0x002E3625, 0x00303C26, 0x00354228, 0x00435334, 0x005C6D4C, 0x006D7E5C, 0x0065785F,
    0x00677048, 0x005A5D30, 0x00364529, 0x00446A6A, 0x00467E91, 0x004F8498, 0x00477882, 0x00334F3C, 0x002D4337, 0x006C7977, 0x009CA0A5, 0x00D9DCE4, 0x00DEE4E9, 0x00ACBAB8, 0x0080928B, 0x008D9594, 0x008D9594, 0x008E9695, 0x008F9796, 0x008F9796,
    0x008F9796, 0x008E9695, 0x008D9594, 0x00929A9A, 0x008D9595, 0x008D9595, 0x00878F8F, 0x00838B8B, 0x008F9797, 0x00A9B1B1, 0x00C8D0D0, 0x00DEE5E8, 0x008D9A8A, 0x006A7C57, 0x0074865D, 0x00647052, 0xFFD3D7CB, 0xFFFFFFFE, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFFFFFE, 0x00B7BEA9, 0x0059693A, 0x007B8A5E, 0x007C8767, 0x00495531, 0x0030430A, 0x0036461D, 0x003C4C23, 0x00293910, 0x0033431A, 0x0035451C,
    0x0036461D, 0x003D4D24, 0x002D3D14, 0x0069755F, 0x005F6959, 0x00BEC4BF, 0x009FA2A6, 0x00E8EAF2, 0x00E3E5ED, 0x00D8DBDF, 0x00D3D8D7, 0x00DCE1E0, 0x00F0F5F4, 0x00CED1CF, 0x00686C66, 0x008C9084, 0x00757D66, 0x00707B5B, 0x0076805C, 0x006D7D4E,
    0x006F7F50, 0x00707F53, 0x006D7C50, 0x00738157, 0x0068764C, 0x005B693F, 0x00505E35, 0x00536439, 0x00516237, 0x006B7C51, 0x0077885D, 0x00728358, 0x00728358, 0x00708156, 0x00738459, 0x0074835D, 0x0071805A, 0x0055643E, 0x0054633D, 0x0054633D,
    0x0064734D, 0x0076855F, 0x007A8963, 0x00798261, 0x007A8362, 0x00737E5D, 0x00778261, 0x00768462, 0x00748260, 0x00768664, 0x006E7E5C, 0x0072845F, 0x006B7C5A, 0x0070815F, 0x00657654, 0x00687958, 0x005F704F, 0x002D3D1E, 0x00203011, 0x001A2417,
    0x0015210F, 0x00212E18, 0x00455438, 0x00667755, 0x006E8258, 0x006B8053, 0x006C8252, 0x006B7C57, 0x006E7E5C, 0x00687957, 0x00617250, 0x004A5D3C, 0x00344726, 0x00304525, 0x002F4424, 0x00364725, 0x00354624, 0x003F502E, 0x004E5F3D, 0x005C6D4B,
    0x00627351, 0x00617250, 0x00627351, 0x0060724B, 0x005B6D46, 0x0054663F, 0x004B5D36, 0x0043552E, 0x003D4F28, 0x00394B24, 0x00374922, 0x002E461E, 0x002C441C, 0x002B431B, 0x00283F19, 0x00263D17, 0x00253B18, 0x00243A17, 0x00243A17, 0x00203717,
    0x00203717, 0x001F3616, 0x001E3515, 0x001E3515, 0x001F3616, 0x00203717, 0x00203717, 0x00263B14, 0x00273C15, 0x00283D16, 0x002A3F18, 0x002D421B, 0x0030451E, 0x00334821, 0x00344922, 0x003E5027, 0x0041532A, 0x00485A31, 0x00506239, 0x00576940,
    0x005D6F46, 0x0061734A, 0x0063754C, 0x00677853, 0x00687954, 0x006A7B56, 0x006B7C57, 0x006C7D58, 0x006C7D58, 0x006C7D58, 0x006C7D58, 0x006D7F58, 0x0070825B, 0x0070825B, 0x006C7E57, 0x006A7C55, 0x006C7E57, 0x006F815A, 0x0070825B, 0x004E5B2D,
    0x004C5939, 0x00646F5B, 0x004E573C, 0x005C653A, 0x004B582A, 0x00243B1F, 0x00163730, 0x005D6F6E, 0x00405045, 0x004D5A42, 0x00697251, 0x004E5532, 0x00586244, 0x00434F3B, 0x0059685A, 0x00232A1B, 0x0042493A, 0x00515849, 0x00212819, 0x00454C3D,
    0x00515849, 0x00272E1F, 0x004C5344, 0x00434A3D, 0x00252C1D, 0x00505748, 0x003B4031, 0x00232918, 0x00555848, 0x00363A27, 0x00272B18, 0x005B6255, 0x003A4132, 0x002B3322, 0x0057634D, 0x00354228, 0x005D6D4E, 0x006A7B5A, 0x006C7D5B, 0x0062745D,
    0x00676F4A, 0x005B5F35, 0x00394C33, 0x0049777F, 0x004888A7, 0x004B8AAC, 0x00417A90, 0x00426152, 0x00304840, 0x00647173, 0x0091969F, 0x00CDD1DC, 0x00D1D9E0, 0x00AABAB9, 0x00819890, 0x0085908E, 0x00879290, 0x00899492, 0x008B9694, 0x008B9694,
    0x008B9694, 0x008A9593, 0x008A9593, 0x00899295, 0x00858E91, 0x00889194, 0x00818A8D, 0x007C8588, 0x00899295, 0x00A7B0B3, 0x00CCD5D8, 0x00D9E0E3, 0x008E9B8B, 0x0070825D, 0x00778960, 0x00606C4E, 0xFFCACEC2, 0xFFFAFBF9, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCF5FF, 0xFFFFFFF8, 0x00BEC6A7, 0x0058673B, 0x00808E64, 0x0071805A, 0x00596940, 0x00425327, 0x003E5027, 0x003F5128, 0x00405229, 0x0042542B, 0x0041532A,
    0x003F5128, 0x0042542B, 0x0041532A, 0x00667157, 0x00656F58, 0x007B856E, 0x00929B86, 0x00A6AF9A, 0x00969F8A, 0x0099A38C, 0x00ADB7A0, 0x00A1A893, 0x009DA58E, 0x0097A085, 0x00667151, 0x005D6945, 0x0066744B, 0x00738256, 0x0078875B, 0x00768958,
    0x00728455, 0x00738556, 0x00738459, 0x00708057, 0x0073825C, 0x00707E5A, 0x0064724E, 0x00495930, 0x00526239, 0x004E5E35, 0x006B7B52, 0x0074845B, 0x0076865D, 0x0076865D, 0x00728259, 0x00718257, 0x00728358, 0x0074855A, 0x00596940, 0x00596940,
    0x00506037, 0x005F6E48, 0x00778660, 0x0071835C, 0x006F815A, 0x006E8059, 0x006E8059, 0x0070825B, 0x0071835C, 0x0072845D, 0x0071835C, 0x00737F5B, 0x00707F59, 0x00697B52, 0x00677B51, 0x00657851, 0x00566442, 0x00272F11, 0x0024280F, 0x001A200F,
    0x00262D18, 0x002D361B, 0x00374424, 0x00687652, 0x00697A55, 0x006A7A58, 0x006D7D5B, 0x00778058, 0x00596241, 0x00525F47, 0x004F5E50, 0x0044564F, 0x00354B49, 0x00233D3D, 0x00264242, 0x00173E4D, 0x000F2E37, 0x00213633, 0x00293725, 0x003B4527,
    0x003E4C28, 0x004C5F38, 0x005F774F, 0x00577149, 0x0053693F, 0x004C5D31, 0x00495525, 0x0043501C, 0x00394D18, 0x00314B15, 0x002B4914, 0x00273D20, 0x0021371B, 0x001B2F18, 0x00182B18, 0x0018291B, 0x0018281D, 0x0015241C, 0x0013211B, 0x001A1E19,
    0x001A1E19, 0x00191D18, 0x00191D18, 0x001A1E19, 0x001B1F1A, 0x001C201B, 0x001D211C, 0x001B2B1A, 0x001A2A18, 0x00192D16, 0x001D3317, 0x001E3715, 0x001F3A13, 0x00254116, 0x002B4A1D, 0x00384B12, 0x003A4D14, 0x003D5017, 0x00465922, 0x00536431,
    0x005F6D43, 0x00636F4B, 0x00636D4F, 0x00667752, 0x00687954, 0x00697A55, 0x006A7B56, 0x006A7B56, 0x006B7C57, 0x006D7E59, 0x006F805B, 0x006E8059, 0x006E8059, 0x006E8059, 0x006E8059, 0x006E8059, 0x006D7F58, 0x006D7F58, 0x006D7F58, 0x006E7F5A,
    0x006E7E5C, 0x00829270, 0x007D8D6B, 0x00697858, 0x003A4929, 0x00253415, 0x00334223, 0x003E4B31, 0x00384727, 0x00485A33, 0x005E7146, 0x004F603B, 0x00465339, 0x004A5346, 0x00888E89, 0x00192D1A, 0x00506451, 0x00687C69, 0x001B2F1C, 0x005C705D,
    0x00627663, 0x00172B18, 0x00627663, 0x005E6D58, 0x0023311F, 0x00768472, 0x00505E4C, 0x001C2919, 0x00818E7E, 0x00455244, 0x00233022, 0x00818C7C, 0x00374331, 0x00313E28, 0x0078876C, 0x004A5A3B, 0x006C7D5B, 0x00677954, 0x006B7E57, 0x00718260,
    0x005D6B47, 0x003B4C2B, 0x00304B3B, 0x00557F84, 0x00558A9F, 0x004B839C, 0x0052869D, 0x003E6C74, 0x00273F33, 0x00505945, 0x00727D7A, 0x009AA8AE, 0x00DDE5E5, 0x00B9C0BD, 0x00849094, 0x008A9390, 0x0087908D, 0x00848D8A, 0x00868F8C, 0x008A9390,
    0x008D9693, 0x008C9592, 0x008A9390, 0x0087988F, 0x0086978E, 0x00879790, 0x007F8D87, 0x00778581, 0x00879290, 0x00AAB5B3, 0x00CAD5D3, 0x00DEE4DF, 0x00848E7E, 0x00667556, 0x0075855C, 0x0062714B, 0xFFC5CDB6, 0xFFFDFEFA, 0xFFFEFAFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFAFF, 0xFFFFFFF9, 0x00B9C1A2, 0x00536236, 0x007D8B61, 0x00788761, 0x0077875E, 0x0076875B, 0x00778960, 0x00798B62, 0x00788A61, 0x0076885F, 0x0075875E,
    0x0076885F, 0x0075875E, 0x00708259, 0x00798763, 0x0073815F, 0x00717F5D, 0x006C7959, 0x0073815F, 0x006B7955, 0x006F7E58, 0x007A8A61, 0x00717A5F, 0x00677153, 0x00707B5B, 0x00687450, 0x006A7751, 0x006A784E, 0x00718054, 0x007B8A5E, 0x00738655,
    0x00738655, 0x00768859, 0x0076875B, 0x00728358, 0x0077875E, 0x00798960, 0x0074835D, 0x00617148, 0x004E5E35, 0x005A6A41, 0x0048582F, 0x006E7E55, 0x0077875E, 0x006F7F56, 0x0073835A, 0x0074855A, 0x00738459, 0x00798A5F, 0x0068784F, 0x0056663D,
    0x00506037, 0x005F6E48, 0x0076855F, 0x0072845D, 0x0070825B, 0x006F815A, 0x006F815A, 0x0070825B, 0x0071835C, 0x0071835C, 0x0071835C, 0x0076825E, 0x0072815B, 0x006B7D54, 0x006A7E54, 0x00657851, 0x00586644, 0x00384022, 0x00454930, 0x003D4332,
    0x00313823, 0x001F280D, 0x004A5737, 0x00697753, 0x0062734E, 0x00667654, 0x00687856, 0x006A7C53, 0x00556644, 0x003B4E39, 0x004E635B, 0x006F878D, 0x007D97A7, 0x007E9EB1, 0x007799B0, 0x006B90AC, 0x00638297, 0x0060757D, 0x003D4943, 0x00293120,
    0x00232E14, 0x00394829, 0x00526445, 0x00485D3C, 0x00455634, 0x003D4B29, 0x0038421E, 0x00343E1A, 0x002F3D19, 0x002C3D1B, 0x00283E1B, 0x0020331A, 0x001C2E17, 0x00172813, 0x00152514, 0x00162418, 0x0016231B, 0x0014201A, 0x00111C19, 0x00191C1A,
    0x00191C1A, 0x00181B19, 0x00181B19, 0x00181B19, 0x00191C1A, 0x001A1D1B, 0x001B1E1C, 0x00171E1B, 0x00141E18, 0x00162117, 0x001A2719, 0x00192A15, 0x001A2D14, 0x001D3316, 0x0023391C, 0x0037461A, 0x00384818, 0x003D4F1A, 0x00455821, 0x004D5F2A,
    0x00556536, 0x005C6943, 0x00616C4C, 0x0063744F, 0x00657651, 0x00677853, 0x00677853, 0x00687954, 0x00697A55, 0x006B7C57, 0x006D7E59, 0x006E8059, 0x006E8059, 0x006E8059, 0x006E8059, 0x006E8059, 0x006E8059, 0x006D7F58, 0x006D7F58, 0x006F815A,
    0x006B7D56, 0x00768762, 0x0070815C, 0x006B7B59, 0x00536341, 0x004C5C3A, 0x005B6A4A, 0x00627152, 0x004F5F3D, 0x00596B42, 0x0063764B, 0x004E6039, 0x004E5C40, 0x00717B6A, 0x00B0B8AE, 0x002D3621, 0x0077806B, 0x008D9681, 0x0019220D, 0x00606954,
    0x005E6752, 0x00222B16, 0x00707964, 0x005D6A54, 0x001F2C16, 0x0087947E, 0x0047533F, 0x00313D29, 0x00ABB7A5, 0x00505C4A, 0x00313D2B, 0x007E8A78, 0x002B3723, 0x0054614B, 0x00B6C5AA, 0x00506041, 0x006A7B59, 0x006F815C, 0x006B7E57, 0x005D6E4C,
    0x004C5A36, 0x00394A29, 0x003A5545, 0x005C868B, 0x005E93A8, 0x00558DA6, 0x005589A0, 0x00416F77, 0x00273F33, 0x004F5844, 0x00717C79, 0x0098A6AC, 0x00DDE5E5, 0x00BBC2BF, 0x00859195, 0x00879191, 0x00889292, 0x00889292, 0x00899393, 0x008A9494,
    0x008B9595, 0x008B9595, 0x008C9696, 0x00859490, 0x0081908C, 0x00808F8B, 0x007D8A88, 0x00788583, 0x00869090, 0x00ABB5B5, 0x00CED8D8, 0x00E0E7E0, 0x008F9988, 0x006F7E5E, 0x0075855C, 0x005E6C48, 0xFFC3CAB5, 0xFFFFFFFC, 0xFFFFFCFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFF9FF, 0xFFFFFFF7, 0x00BAC2A3, 0x0057663A, 0x007B895F, 0x0073825C, 0x00728259, 0x0078895D, 0x006C7E55, 0x00708259, 0x0071835A, 0x006F8158, 0x0072845B,
    0x00778960, 0x0076885F, 0x0073855C, 0x0078895D, 0x00798A5F, 0x0076865D, 0x00718158, 0x007C8D62, 0x007E9061, 0x00809360, 0x007D925B, 0x0084906C, 0x007B8862, 0x007F8C66, 0x007E8C63, 0x007A885E, 0x007B895F, 0x007A895D, 0x00768559, 0x00768958,
    0x00758857, 0x00758758, 0x00728455, 0x006E7F53, 0x006F8055, 0x00728358, 0x006F8055, 0x0076865D, 0x005E6E45, 0x004B5B32, 0x00596940, 0x0046562D, 0x006E7E55, 0x007E8E65, 0x006F7F56, 0x0074855A, 0x00728358, 0x007A8B60, 0x0075855C, 0x00516138,
    0x00506037, 0x005F6E48, 0x00788761, 0x0073855E, 0x0071835C, 0x0070825B, 0x0070825B, 0x0071835C, 0x0071835C, 0x0071835C, 0x0070825B, 0x0074805C, 0x006F7E58, 0x006C7E55, 0x006C8056, 0x00657851, 0x00566442, 0x003D4527, 0x00555940, 0x00656B5A,
    0x00282F1A, 0x00353E23, 0x00233010, 0x00576541, 0x0070815C, 0x006D7D5B, 0x00697957, 0x006C8357, 0x00556D4B, 0x002F4735, 0x00435D5D, 0x006F8C9B, 0x007090AD, 0x00688CB0, 0x00648BB2, 0x006B8FB3, 0x0064829F, 0x00617587, 0x004D595F, 0x00515853,
    0x00515849, 0x0045513B, 0x0035422A, 0x00324524, 0x002D3C1D, 0x00273317, 0x00252D16, 0x00272D1A, 0x00262E1D, 0x00222C1C, 0x001D2A1C, 0x001D2716, 0x001A2413, 0x00172111, 0x00161E13, 0x00161E14, 0x00161C17, 0x00151A18, 0x00131817, 0x00181A1A,
    0x00181A1A, 0x00171919, 0x00171919, 0x00171919, 0x00181A1A, 0x00191B1B, 0x001A1C1C, 0x0015141D, 0x0015151B, 0x0015191A, 0x00181D1B, 0x001A211A, 0x00192317, 0x001B2518, 0x001E2919, 0x00273016, 0x00293414, 0x00314014, 0x003B4D18, 0x0042551E,
    0x00485926, 0x00546238, 0x00606C48, 0x0062734E, 0x00647550, 0x00667752, 0x00677853, 0x00687954, 0x00697A55, 0x006B7C57, 0x006C7D58, 0x006E8059, 0x006E8059, 0x006E8059, 0x006E8059, 0x006E8059, 0x006E8059, 0x006E8059, 0x006E8059, 0x00718459,
    0x006C7E55, 0x00708259, 0x006A7C53, 0x0074865F, 0x006F815A, 0x0072835E, 0x007C8D68, 0x00758563, 0x006E7F5A, 0x0073865B, 0x0065794C, 0x004D5F36, 0x004C5B3B, 0x0096A38B, 0x00EAF4E3, 0x003E3F25, 0x00BDBEA4, 0x00DCDDC3, 0x0043442A, 0x00727359,
    0x00626349, 0x0033341A, 0x0067684E, 0x00495539, 0x00424E32, 0x008E9A7E, 0x00364127, 0x003B462C, 0x00959F88, 0x004B553E, 0x00444E37, 0x00535F4B, 0x0028351F, 0x004C5A42, 0x008D9C80, 0x003C4C2D, 0x006F805E, 0x006E805B, 0x00677954, 0x00526341,
    0x0045532F, 0x003A4B2A, 0x003B5646, 0x00578186, 0x005D92A7, 0x005B93AC, 0x005589A0, 0x0044727A, 0x00273F33, 0x004E5743, 0x00707B78, 0x0096A4AA, 0x00DDE5E5, 0x00BDC4C1, 0x00869296, 0x007D898D, 0x007F8B8F, 0x00828E92, 0x00879397, 0x008B979B,
    0x00899599, 0x00849094, 0x00808C90, 0x00808E8D, 0x00808E8D, 0x00818E90, 0x007E8A8C, 0x00768284, 0x00828B8E, 0x00AAB3B6, 0x00D0D9DC, 0x00B9C1B6, 0x00818C78, 0x00707F5F, 0x00778660, 0x005F6D4B, 0xFFC3CAB5, 0xFFFFFFFC, 0xFFFFFCFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFF9FF, 0xFFFFFFF9, 0x00BAC2A3, 0x0058673B, 0x007B895F, 0x0076855F, 0x0073835A, 0x0077885C, 0x00788A61, 0x00798B62, 0x007B8D64, 0x0076885F, 0x00788A61,
    0x007B8D64, 0x00788A61, 0x007D8F66, 0x00778B5E, 0x00778960, 0x00758661, 0x00778666, 0x00778765, 0x006E8057, 0x00708554, 0x00728953, 0x00728259, 0x00708057, 0x0073835A, 0x0077875E, 0x00738459, 0x0075865B, 0x00798A5F, 0x00718257, 0x00738556,
    0x00728455, 0x00728455, 0x00728357, 0x00728357, 0x00738458, 0x00738458, 0x00718256, 0x00718158, 0x007A8A61, 0x005C6C43, 0x004B5B32, 0x00596940, 0x0054643B, 0x006F7F56, 0x007B8B62, 0x00728358, 0x00718257, 0x00738459, 0x0077875E, 0x004E5E35,
    0x00526239, 0x005C6B45, 0x007C8B65, 0x0073855E, 0x0072845D, 0x0071835C, 0x0071835C, 0x0071835C, 0x0072845D, 0x0071835C, 0x006F815A, 0x00727E5A, 0x006F7E58, 0x006A7C53, 0x006B7F55, 0x00667952, 0x00596745, 0x003C4426, 0x004F533A, 0x002B3120,
    0x00353C27, 0x00343D22, 0x003C4929, 0x003E4C28, 0x0061724D, 0x006A7A58, 0x00657553, 0x0071835A, 0x005A6B4A, 0x00334633, 0x002F4441, 0x00637E88, 0x007D9DB0, 0x006E91AB, 0x007BA0BC, 0x006B90AA, 0x00658499, 0x00566D7C, 0x0039484B, 0x0038433B,
    0x003D4736, 0x00455036, 0x003D492B, 0x002E4017, 0x00273511, 0x00202C0E, 0x00242B16, 0x002A2E22, 0x00292E25, 0x00222620, 0x00171D18, 0x00202418, 0x001E2216, 0x001B1F14, 0x00191C13, 0x00191B15, 0x00191A18, 0x00191A18, 0x00191919, 0x00191B1B,
    0x00191B1B, 0x00181A1A, 0x00181A1A, 0x00181A1A, 0x00191B1B, 0x00191B1B, 0x00191B1B, 0x001C181E, 0x001C181D, 0x001E1B1D, 0x001F1F1F, 0x0021221E, 0x001F241B, 0x001E2419, 0x001E2419, 0x001F211B, 0x001F2514, 0x00273211, 0x00344414, 0x003C4F18,
    0x0041531E, 0x004E5E2F, 0x005C6A41, 0x0063744F, 0x00657651, 0x00687954, 0x00697A55, 0x006A7B56, 0x006B7C57, 0x006D7E59, 0x006E7F5A, 0x006D7F58, 0x006D7F58, 0x006D7F58, 0x006E8059, 0x006E8059, 0x006E8059, 0x006E8059, 0x006E8059, 0x00708457,
    0x006F8356, 0x00708358, 0x00677A4F, 0x00708259, 0x006D7F56, 0x006D7F56, 0x006C7E57, 0x0070815C, 0x00788A63, 0x00718459, 0x00586B40, 0x0054663D, 0x00425230, 0x00748266, 0x00BBC8B0, 0x003C3E20, 0x00838567, 0x00828466, 0x003D3F21, 0x00838567,
    0x00737557, 0x00434527, 0x004B4D2F, 0x003B4625, 0x00525D3C, 0x00C0CBAB, 0x00535E3E, 0x00374123, 0x00626C4E, 0x002B3419, 0x00565F44, 0x008C9A82, 0x00324028, 0x0037462B, 0x00617054, 0x003B4B2C, 0x006B7C5B, 0x00687957, 0x004F613C, 0x00495A38,
    0x004B5935, 0x00435433, 0x00375242, 0x004F797E, 0x00598EA3, 0x005991AA, 0x0054889F, 0x0045737B, 0x00253D31, 0x004E5743, 0x00717C79, 0x0094A2A8, 0x00DEE6E6, 0x00C0C7C4, 0x00869296, 0x00708087, 0x00708087, 0x0074848B, 0x007F8F96, 0x008999A0,
    0x0088989F, 0x007B8B92, 0x006E7E85, 0x00778389, 0x00818D93, 0x00869296, 0x00808B8F, 0x00758084, 0x00848D91, 0x00B0B9BC, 0x00CFD8DB, 0x00899382, 0x006E7B63, 0x006E7D5D, 0x00788761, 0x00606D4D, 0xFFC3C9B6, 0xFFFFFFFC, 0xFFFCFAFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFAFF, 0xFFFFFFF9, 0x00BBC3A4, 0x0059683C, 0x007D8B61, 0x007A8963, 0x006A7A51, 0x00607145, 0x0061734A, 0x005F7148, 0x00607249, 0x005C6E45, 0x005F7148,
    0x005F7148, 0x005A6C43, 0x0066784F, 0x0072835E, 0x00637253, 0x005B6751, 0x006C7666, 0x005D6757, 0x0038442E, 0x00303F20, 0x00394A25, 0x002F3C1C, 0x002F3D1B, 0x003A4826, 0x004B5935, 0x0054623E, 0x0051603A, 0x006D7D54, 0x0076865D, 0x00718158,
    0x0073835A, 0x0075855C, 0x0076875C, 0x0077885D, 0x0075865B, 0x0074855A, 0x0075865B, 0x0075855C, 0x0074845B, 0x0078885F, 0x0058683F, 0x0058683F, 0x0053633A, 0x00526239, 0x0074845B, 0x00738459, 0x0076875C, 0x00708156, 0x0074845B, 0x00506037,
    0x0056663D, 0x005A6943, 0x007E8D67, 0x0074865F, 0x0072845D, 0x0071835C, 0x0072845D, 0x0072845D, 0x0072845D, 0x0071835C, 0x0070825B, 0x0076825E, 0x0072815B, 0x006B7D54, 0x006A7E54, 0x006A7D56, 0x00616F4D, 0x003B4325, 0x003F432A, 0x003F4534,
    0x00414833, 0x00454E33, 0x00354222, 0x004B5935, 0x00374823, 0x00667654, 0x006F7F5D, 0x00717853, 0x00626A4B, 0x005E6851, 0x004E5B4D, 0x00889B92, 0x00ADC4BF, 0x006C8783, 0x0063817C, 0x00618383, 0x00658483, 0x005A746E, 0x00314538, 0x001D2C17,
    0x001C2B0C, 0x003D4C26, 0x00526036, 0x003D5019, 0x00374717, 0x002F3E18, 0x002C371D, 0x002C3423, 0x00292F24, 0x0025291E, 0x001F2318, 0x0026271D, 0x0024251B, 0x0022231A, 0x001F1F19, 0x001D1D17, 0x001D1C18, 0x001F1E1A, 0x00211F1E, 0x001A1D1B,
    0x001B1E1C, 0x001B1E1C, 0x001C1F1D, 0x001C1F1D, 0x001B1E1C, 0x001A1D1B, 0x001A1D1B, 0x00221F1B, 0x00221F1B, 0x0024211C, 0x0024251C, 0x0027291D, 0x00262B1C, 0x00242A19, 0x00212716, 0x00262527, 0x0023261D, 0x00283019, 0x0033401A, 0x003B4B1B,
    0x0040511E, 0x004B5B2B, 0x00576738, 0x0062734E, 0x00647550, 0x00677853, 0x00697A55, 0x006A7B56, 0x006B7C57, 0x006C7D58, 0x006E7F5A, 0x006D7F58, 0x006D7F58, 0x006D7F58, 0x006E8059, 0x006E8059, 0x006E8059, 0x006F815A, 0x006F815A, 0x00697D50,
    0x006E8255, 0x006F8257, 0x00687B50, 0x0071835A, 0x006D7F56, 0x00708259, 0x006D7F58, 0x0070815C, 0x006A7C55, 0x00586A41, 0x004A5C33, 0x005B6D46, 0x0042532E, 0x00404F2F, 0x00516041, 0x00576541, 0x004C5A36, 0x002A3814, 0x00465430, 0x006A7854,
    0x00485632, 0x003E4C28, 0x00586642, 0x004C5834, 0x00515D39, 0x007A8662, 0x00606B4A, 0x005A6544, 0x00515C3C, 0x00566141, 0x003C4727, 0x00324126, 0x0048573B, 0x00657458, 0x00546445, 0x005B6C4B, 0x00657655, 0x0050613F, 0x004C5D3B, 0x00435432,
    0x00576541, 0x004E5F3E, 0x00385343, 0x00517B80, 0x005B90A5, 0x00578FA8, 0x0053879E, 0x00437179, 0x0021392D, 0x004E5743, 0x00737E7B, 0x0093A1A7, 0x00DDE5E5, 0x00C2C9C6, 0x00859195, 0x00728289, 0x00718188, 0x0074848B, 0x007F8F96, 0x008999A0,
    0x008999A0, 0x007E8E95, 0x0073838A, 0x00758088, 0x00828D95, 0x00879399, 0x00808B8F, 0x00768185, 0x0090999C, 0x00BBC5C5, 0x00C4CECE, 0x007A876F, 0x006F7D61, 0x0071815F, 0x0075835F, 0x005D694B, 0xFFC1C7B6, 0xFFFFFFFC, 0xFFFFFEFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCF5FF, 0xFFFFFFF9, 0x00BAC2A3, 0x005E6D41, 0x00808E64, 0x0075845E, 0x004E5E35, 0x00314216, 0x0031431A, 0x002D3F16, 0x002E4017, 0x00293B12, 0x00304219,
    0x0033451C, 0x00273910, 0x0031431A, 0x006A7959, 0x0047543C, 0x00444C41, 0x008A8E8F, 0x00A6A9AD, 0x00919695, 0x00899187, 0x008F9989, 0x008D9787, 0x008E9887, 0x007B8672, 0x00536048, 0x004E5C40, 0x00435232, 0x006E7F5A, 0x0073845F, 0x00768462,
    0x007A8866, 0x007B8967, 0x007A8864, 0x00798862, 0x0075845E, 0x0076865D, 0x007C8C63, 0x007A8A61, 0x006D7D54, 0x0073835A, 0x007F8F66, 0x004F5F36, 0x0056663D, 0x0055653C, 0x0054643B, 0x00718257, 0x0076875C, 0x00738459, 0x0073835A, 0x0053633A,
    0x0058683F, 0x005B6A44, 0x007D8C66, 0x0073855E, 0x0072845D, 0x0072845D, 0x0072845D, 0x0073855E, 0x0073855E, 0x0072845D, 0x0070825B, 0x0074805C, 0x0074835D, 0x00708259, 0x0070845A, 0x006F825B, 0x005F6D4B, 0x002C3416, 0x00262A11, 0x00272D1C,
    0x00202712, 0x001E270C, 0x00364323, 0x00475531, 0x004C5D38, 0x00425230, 0x005A6A48, 0x007D845F, 0x00686D4D, 0x00697153, 0x005A6349, 0x0077846A, 0x007C8B6F, 0x002F4424, 0x002D4221, 0x00456046, 0x00486349, 0x00445A41, 0x002E4428, 0x002C3E1F,
    0x0031431C, 0x004E5F33, 0x00586B3A, 0x0048581B, 0x0043531E, 0x0037471E, 0x002A371D, 0x001F2918, 0x001C2316, 0x00212415, 0x00272818, 0x0027281E, 0x0027281E, 0x0026271D, 0x0023241A, 0x00202118, 0x00202118, 0x0023241B, 0x0026271E, 0x001B1F19,
    0x001C201A, 0x001F231D, 0x0020241E, 0x0020241E, 0x001E221C, 0x001B1F19, 0x001A1E18, 0x00212016, 0x00212016, 0x00202216, 0x00232617, 0x00252B1A, 0x00282E1D, 0x00232C18, 0x001E2713, 0x00222123, 0x0020211D, 0x00222718, 0x002A3319, 0x00323E1A,
    0x003A491D, 0x00475727, 0x00536431, 0x005E6F4A, 0x0061724D, 0x00647550, 0x00677853, 0x00687954, 0x00687954, 0x006A7B56, 0x006B7C57, 0x006C7E57, 0x006D7F58, 0x006D7F58, 0x006D7F58, 0x006E8059, 0x006F815A, 0x006F815A, 0x006F815A, 0x006B7E53,
    0x006F8158, 0x00708259, 0x006C7E55, 0x00758760, 0x006D7F58, 0x00748560, 0x00758661, 0x00728260, 0x00637351, 0x005D6D4B, 0x00556543, 0x00566644, 0x00516040, 0x00526141, 0x00546343, 0x005D724C, 0x00637852, 0x004E633D, 0x00617650, 0x0040552F,
    0x002C411B, 0x00485D37, 0x005B704A, 0x003A4824, 0x0043512D, 0x00616F4B, 0x00505E3C, 0x00687654, 0x005C6949, 0x005A6747, 0x00667353, 0x00627253, 0x00455536, 0x00667657, 0x006E7F5E, 0x00687958, 0x00536443, 0x00506140, 0x00475837, 0x00536442,
    0x0064724E, 0x00516241, 0x00344F3F, 0x004E787D, 0x00588DA2, 0x00558DA6, 0x005589A0, 0x00416F77, 0x001D3529, 0x004E5743, 0x00747F7C, 0x00909EA4, 0x00DCE4E4, 0x00C5CCC9, 0x00879397, 0x007D8D93, 0x007E8E94, 0x00809096, 0x00839399, 0x0086969C,
    0x0088989E, 0x0088989E, 0x0088989E, 0x00869199, 0x008A969C, 0x00899599, 0x00828E90, 0x00778383, 0x0097A2A0, 0x00BDC8C5, 0x00AAB5B2, 0x00707F60, 0x00707F5F, 0x00728260, 0x00748260, 0x005D694D, 0xFFC1C7B6, 0xFFFFFFFC, 0xFFFFFEFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFF9FF, 0xFFFFFFF8, 0x00B3BB9C, 0x005D6C40, 0x007F8D63, 0x0075845E, 0x004B5B32, 0x00314216, 0x0053653C, 0x004F6138, 0x00495B32, 0x003C4E25, 0x00495B32,
    0x00506239, 0x0036481F, 0x00304219, 0x006E8258, 0x00425135, 0x00414B3F, 0x00A4A8AD, 0x00DEE0EB, 0x00DCDEE8, 0x00D6DBDE, 0x00D8DFDC, 0x00DEE1E5, 0x00E9EEED, 0x00C0C6C1, 0x0061695E, 0x00515C48, 0x003C492F, 0x006A7959, 0x005B6B49, 0x005D684E,
    0x00586349, 0x00505C40, 0x00505C3E, 0x00596646, 0x005A6846, 0x00596745, 0x005E6C48, 0x00708057, 0x007B8B62, 0x0074845B, 0x006E7E55, 0x007B8B62, 0x0055653C, 0x005C6C43, 0x004A5A31, 0x00617247, 0x00697A4F, 0x0076875C, 0x0074845B, 0x0053633A,
    0x0055653C, 0x00606F49, 0x00788761, 0x0072845D, 0x0072845D, 0x0072845D, 0x0073855E, 0x0074865F, 0x0074865F, 0x0073855E, 0x0071835C, 0x00727E5A, 0x0073825C, 0x0072845B, 0x0073875D, 0x006D8059, 0x00586644, 0x00293113, 0x002A2E15, 0x00212716,
    0x00252C17, 0x00262F14, 0x003D4A2A, 0x0062704C, 0x0042532E, 0x0050603E, 0x00485836, 0x00677950, 0x006B7A54, 0x006C7A58, 0x00748161, 0x00798666, 0x00616F4D, 0x00475630, 0x00506037, 0x004C5D32, 0x00606F49, 0x006C7C5A, 0x00677758, 0x00687958,
    0x005D6F4A, 0x005F7247, 0x00506435, 0x0045521C, 0x003D4A1C, 0x002F3C1C, 0x001F2B19, 0x00162014, 0x00171C13, 0x001F2115, 0x00262517, 0x001F2619, 0x0021281B, 0x00232A1D, 0x0022291C, 0x001F2619, 0x001E2518, 0x0020271A, 0x00232A1D, 0x001A2114,
    0x001D2417, 0x0021281B, 0x00232A1D, 0x00232A1D, 0x001F2619, 0x001B2215, 0x00181F12, 0x001B1C13, 0x001A1D14, 0x001A1D14, 0x001D2116, 0x0021271C, 0x00262D20, 0x00212A1D, 0x001A2316, 0x001A1B17, 0x001A1B17, 0x001C1F16, 0x001D2213, 0x00222A13,
    0x002F3B17, 0x00425222, 0x0051642D, 0x005D6E49, 0x0060714C, 0x00647550, 0x00667752, 0x00687954, 0x00687954, 0x006A7B56, 0x006B7C57, 0x006C7E57, 0x006C7E57, 0x006D7F58, 0x006D7F58, 0x006E8059, 0x006F815A, 0x006F815A, 0x006F815A, 0x0072845D,
    0x0072845D, 0x006E7F5A, 0x006C7D58, 0x006D7D5B, 0x00546442, 0x0050603E, 0x004C5B3B, 0x00475636, 0x00495839, 0x00556445, 0x004D5B3F, 0x0039472B, 0x00404F30, 0x00455435, 0x00536242, 0x00364725, 0x004B5C3A, 0x004E5F3D, 0x00455634, 0x00354624,
    0x00445533, 0x00546543, 0x00364725, 0x00344621, 0x00566745, 0x00475836, 0x00354624, 0x00596A49, 0x003B4C2B, 0x002E3E1F, 0x002D3D1E, 0x004C5D3C, 0x005D6E4D, 0x00657655, 0x00647554, 0x00586948, 0x00546544, 0x00506140, 0x00556645, 0x00657654,
    0x00606E4A, 0x00455635, 0x002E4939, 0x00487277, 0x0054899E, 0x00548CA5, 0x005589A0, 0x003F6D75, 0x001B3327, 0x004D5642, 0x00737E7B, 0x008C9AA0, 0x00DAE2E2, 0x00C8CFCC, 0x008B979B, 0x008A969A, 0x008B979B, 0x008C989C, 0x008B979B, 0x00899599,
    0x008B979B, 0x008F9B9F, 0x0094A0A4, 0x0094A0A6, 0x008F9B9F, 0x008D9A9C, 0x00889494, 0x0073817D, 0x00919D97, 0x00B9C6BE, 0x009CAA9F, 0x00677755, 0x006F805B, 0x0071825D, 0x00758361, 0x00606B51, 0xFFC2C7B8, 0xFFFFFFFC, 0xFFFDFCFE, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFAFF, 0xFFFDFEF5, 0x00AEB697, 0x005C6B3F, 0x007F8D63, 0x0074835D, 0x004C5C33, 0x0038491D, 0x0062744B, 0x005F7148, 0x00576940, 0x00475930, 0x005A6C43,
    0x00687A51, 0x0046582F, 0x0032441B, 0x00677D4C, 0x004D5F3A, 0x00596454, 0x00B9BEC1, 0x00E1E2F0, 0x00CFD0DE, 0x00C0C4C9, 0x00BCC1C2, 0x00CBCADA, 0x00DCDCE8, 0x00C0C3C8, 0x00646967, 0x005B6457, 0x002C3822, 0x004E5C40, 0x00394828, 0x00616A55,
    0x004E5742, 0x00364029, 0x00354026, 0x00465236, 0x004A5638, 0x00424F2F, 0x003E4B2B, 0x00728259, 0x0073835A, 0x0078885F, 0x0078885F, 0x0073835A, 0x0078885F, 0x005A6A41, 0x00526239, 0x00506136, 0x0058693E, 0x0076875C, 0x0075855C, 0x00506037,
    0x00516138, 0x0065744E, 0x0074835D, 0x0072845D, 0x0071835C, 0x0072845D, 0x0073855E, 0x00758760, 0x00758760, 0x0074865F, 0x0072845D, 0x0077835F, 0x0072815B, 0x006E8057, 0x006D8157, 0x00667952, 0x00566442, 0x003B4325, 0x0050543B, 0x004D5342,
    0x002A311C, 0x00363F24, 0x004C5939, 0x00697753, 0x0061724D, 0x00455533, 0x0050603E, 0x00395629, 0x00668156, 0x005E7451, 0x00657758, 0x005D6D4E, 0x00465536, 0x00576543, 0x0047532F, 0x00464E1F, 0x0060693E, 0x00707A56, 0x006B7759, 0x006A795D,
    0x00607051, 0x005E6F4D, 0x00495B34, 0x00444B1E, 0x00373E1B, 0x00252E19, 0x001C251B, 0x001C2320, 0x00212422, 0x0027241F, 0x0029251A, 0x00192011, 0x001D2415, 0x0022291A, 0x00232A1B, 0x00202718, 0x001E2615, 0x00202817, 0x00222A19, 0x001A2112,
    0x001D2415, 0x00212819, 0x00242B1C, 0x00242B1C, 0x00202718, 0x001B2213, 0x00171E0F, 0x00171816, 0x00181917, 0x00161917, 0x00181B19, 0x001E241F, 0x00232924, 0x00212722, 0x0019201B, 0x001D2116, 0x0020221C, 0x001F201C, 0x001A1C16, 0x00191F0E,
    0x00263111, 0x003D4D1E, 0x004E6128, 0x005F704B, 0x0062734E, 0x00667752, 0x00697A55, 0x006A7B56, 0x006B7C57, 0x006C7D58, 0x006D7E59, 0x006C7E57, 0x006C7E57, 0x006D7F58, 0x006D7F58, 0x006E8059, 0x006F815A, 0x006F815A, 0x0070825B, 0x006E7F5A,
    0x006D7D5B, 0x006C7C5A, 0x006F7F5D, 0x006D7C5C, 0x00465535, 0x00364526, 0x002B3A1B, 0x003B4A2B, 0x004B593D, 0x0059664C, 0x0059664E, 0x004A573F, 0x00455238, 0x001F2E0F, 0x00202F0F, 0x00434C2B, 0x00444D2C, 0x005E6746, 0x004F5837, 0x00454E2D,
    0x0037401F, 0x003F4827, 0x003A4322, 0x00435734, 0x00495D3A, 0x005A6D4C, 0x00344726, 0x00384A2B, 0x00435536, 0x00384A2B, 0x002E4023, 0x003E4F2D, 0x00556644, 0x00556645, 0x006A7B5A, 0x00475837, 0x00556645, 0x00586948, 0x00657655, 0x00617250,
    0x004C5A36, 0x00354625, 0x002E4939, 0x004B757A, 0x00558A9F, 0x00568EA7, 0x0052869D, 0x003F6D75, 0x00193125, 0x004D5642, 0x00727D7A, 0x0089979D, 0x00D8E0E0, 0x00C9D0CD, 0x008E9A9E, 0x008D999B, 0x008D999B, 0x008C989A, 0x008B9799, 0x008B9799,
    0x008C989A, 0x008C989A, 0x008D999B, 0x00929EA2, 0x008B989A, 0x008F9D9C, 0x008C9997, 0x006F7D77, 0x008A988D, 0x00BBC9BD, 0x00A1AFA3, 0x006E7F5A, 0x00758661, 0x00748560, 0x00768363, 0x00626D53, 0xFFC2C7B8, 0xFFFFFFFC, 0xFFFDFCFE, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFBFAFEF3, 0x00B2BC9E, 0x005B6940, 0x007B8862, 0x0075815D, 0x004D5B31, 0x00405020, 0x005B6D44, 0x0033451C, 0x005D6F46, 0x0044562D, 0x0035471E,
    0x00687A51, 0x004E6037, 0x00304219, 0x006E8559, 0x005A6E4B, 0x00667462, 0x00C0C9C6, 0x00D9E0E3, 0x00C3C9CE, 0x00BCC4C3, 0x00B4BEB8, 0x00CCD0D5, 0x00D6DBDE, 0x00C4CBC8, 0x00818A80, 0x00697563, 0x00637159, 0x004D5D3E, 0x00728362, 0x00A2A39A,
    0x0077786F, 0x00606158, 0x0063645B, 0x006A6B62, 0x0097988F, 0x0086877E, 0x003B3C33, 0x00728358, 0x0076875C, 0x0074855A, 0x00728358, 0x006F8055, 0x007A8B60, 0x007B8C61, 0x0054653A, 0x004E6039, 0x004C5E37, 0x005B6D46, 0x006E8059, 0x0051633C,
    0x00556740, 0x005C6E47, 0x00788A63, 0x0074875C, 0x0074865D, 0x0073855C, 0x0072845B, 0x0072845D, 0x0072845D, 0x0073845F, 0x00748560, 0x00788964, 0x006D7F58, 0x0072815B, 0x0074825E, 0x00757F61, 0x00586049, 0x00404536, 0x0066675D, 0x0066695A,
    0x003A402D, 0x00353E24, 0x004B5537, 0x00687654, 0x006E7C5A, 0x00627151, 0x00435233, 0x004D603F, 0x00435A2E, 0x002E431D, 0x00334030, 0x00465246, 0x004C5C44, 0x003F5035, 0x003A4739, 0x003B4D4E, 0x0034493A, 0x00354F2B, 0x00647D51, 0x005F7349,
    0x0063724C, 0x00626E44, 0x0052612E, 0x0038402F, 0x001A2112, 0x001A2015, 0x00262B22, 0x001C251B, 0x003A483C, 0x002B412F, 0x0027402C, 0x00384232, 0x00384232, 0x003B4534, 0x00363E2D, 0x00353E2A, 0x003E4431, 0x003B422D, 0x003A412C, 0x003C4834,
    0x00394531, 0x00303C28, 0x0036422E, 0x00384430, 0x002E3A26, 0x002D3925, 0x002D3925, 0x0024331E, 0x002B3A25, 0x002B3A25, 0x00263520, 0x002C3B26, 0x00364530, 0x00303F2A, 0x0021301B, 0x001B3821, 0x00203320, 0x0033372B, 0x0023241B, 0x00192117,
    0x00141F15, 0x002D3125, 0x00555244, 0x00626E50, 0x0063714F, 0x00606F49, 0x006E8057, 0x00697C51, 0x00697B52, 0x00677954, 0x006B7C5A, 0x00687A55, 0x006A7C57, 0x006C7E59, 0x006D7F5A, 0x006D7F5A, 0x006D7F5A, 0x006E805B, 0x006F815C, 0x00757F5B,
    0x00677954, 0x006A845C, 0x006B8353, 0x00718151, 0x0049532F, 0x00444D43, 0x004C5864, 0x0064696A, 0x0042504C, 0x003A4830, 0x007B7C55, 0x005B583C, 0x00414A47, 0x00344647, 0x002C3A2F, 0x00415150, 0x00445139, 0x005D6739, 0x00404A20, 0x00394833,
    0x00384847, 0x00414E50, 0x003E4A44, 0x003C484C, 0x0049573B, 0x005B653B, 0x004A513C, 0x00404C4C, 0x00405553, 0x003D524A, 0x00202F27, 0x003D5035, 0x004A5F3F, 0x00526643, 0x0060754E, 0x004E613A, 0x00485A35, 0x0071815F, 0x006F7E5E, 0x004A593D,
    0x0046562D, 0x003A4E23, 0x0029462F, 0x004B747D, 0x0050829E, 0x00558DA6, 0x00538A97, 0x00426F7A, 0x0020382E, 0x004D5544, 0x0076817E, 0x0086939B, 0x00DAE1E4, 0x00C8CECD, 0x00879399, 0x007D9095, 0x007C8F94, 0x007F9297, 0x00879A9F, 0x0090A3A8,
    0x008FA2A7, 0x0085989D, 0x007B8E93, 0x00829096, 0x007F8D93, 0x00869598, 0x007F8B8F, 0x00717E80, 0x00859193, 0x009AA6A8, 0x00919D9D, 0x006D7F5A, 0x006D7F5A, 0x006B7C57, 0x00758464, 0x00647157, 0xFFBEC5B6, 0xFFFAFEF9, 0xFFFCFEFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFDFFF6, 0x00B1BB9D, 0x005A683F, 0x007D8A64, 0x00798561, 0x004E5C32, 0x003B4B1B, 0x0061734A, 0x0056683F, 0x00596B42, 0x0042542B, 0x0052643B,
    0x00697B52, 0x00405229, 0x00304219, 0x00677856, 0x00516045, 0x00646E62, 0x00BFC4C5, 0x00D4D6E0, 0x00C5C7D1, 0x00CCD0D5, 0x00C7CCCD, 0x00C9CAD4, 0x00D9DBE3, 0x00C9CCD0, 0x00707573, 0x0071796E, 0x00515B4A, 0x00505C46, 0x00626F55, 0x00989B8B,
    0x00898C7C, 0x006A6D5D, 0x00636656, 0x00747767, 0x00949787, 0x00838676, 0x005F6252, 0x005F7045, 0x0076875C, 0x0074855A, 0x006C7D52, 0x0074855A, 0x0078895E, 0x0075865B, 0x00718257, 0x005C6E47, 0x0051633C, 0x0050623B, 0x005B6D46, 0x0043552E,
    0x0052643D, 0x005E7049, 0x00798B64, 0x0074875C, 0x0074865D, 0x0073855C, 0x0073855C, 0x0073855E, 0x0073855E, 0x00748560, 0x00758661, 0x00768762, 0x00768762, 0x007B8A64, 0x0072815B, 0x00717C5B, 0x0060694E, 0x00444C35, 0x004E5441, 0x003F4534,
    0x003B422D, 0x00424B30, 0x004B5636, 0x00677551, 0x00788662, 0x00768664, 0x005F6F4D, 0x00435536, 0x004F653B, 0x00405431, 0x004D5A4C, 0x005E695F, 0x004A5A43, 0x001F2F17, 0x00344034, 0x0048595C, 0x00384C3F, 0x002E4624, 0x00637B53, 0x00637550,
    0x00667452, 0x0063704A, 0x004D5A2E, 0x00202718, 0x001B2116, 0x00171C13, 0x00191F1A, 0x00212823, 0x005B695E, 0x006A7C6F, 0x00728876, 0x0056685B, 0x00677A6B, 0x00748778, 0x00697A6C, 0x00647665, 0x006E7E6D, 0x00697967, 0x00637361, 0x006F7C6C,
    0x00657262, 0x00606D5D, 0x00697666, 0x00677464, 0x00637060, 0x006A7767, 0x00677464, 0x00617160, 0x00647463, 0x00637362, 0x00627261, 0x0060705F, 0x00596958, 0x00465645, 0x00334332, 0x005D7965, 0x006F7E70, 0x0060635A, 0x0023251F, 0x00161D18,
    0x000D1810, 0x0012170E, 0x00373229, 0x00515D3F, 0x00687555, 0x00677551, 0x0066784F, 0x0061734A, 0x00677952, 0x00687A55, 0x006B7C5A, 0x00697B56, 0x006B7D58, 0x006D7F5A, 0x006E805B, 0x006D7F5A, 0x006D7F5A, 0x006E805B, 0x006F815C, 0x0076815B,
    0x006A7C57, 0x00678159, 0x00698355, 0x0067784C, 0x003F4B2D, 0x004D5C58, 0x00516374, 0x00566578, 0x00465F69, 0x003B5347, 0x00697656, 0x00464F3A, 0x003A5056, 0x00405A6B, 0x003F565E, 0x003A525E, 0x0035493D, 0x00475837, 0x00354728, 0x00496058,
    0x004D6571, 0x00425969, 0x00465B63, 0x00364D55, 0x00435A44, 0x00384C29, 0x0038483D, 0x00526572, 0x003E5967, 0x003A575E, 0x003F565E, 0x00394C31, 0x00516646, 0x00526643, 0x00546942, 0x004D6039, 0x004E603B, 0x00657553, 0x00536242, 0x00415034,
    0x004A5A31, 0x0043572C, 0x002A4730, 0x0049727B, 0x004F819D, 0x00548CA5, 0x00528996, 0x00416E79, 0x0020382E, 0x004B5342, 0x0075807D, 0x0085929A, 0x00DAE1E4, 0x00CCD2D1, 0x008B979D, 0x0072858A, 0x00718489, 0x0075888D, 0x007F9297, 0x008A9DA2,
    0x008A9DA2, 0x007E9196, 0x0072858A, 0x0078868C, 0x007C8A90, 0x00859497, 0x00808C90, 0x00758284, 0x00849092, 0x0096A2A4, 0x00929E9E, 0x00728361, 0x00748661, 0x00748560, 0x00758563, 0x005D6A50, 0xFFB9C0B1, 0xFFFCFFFB, 0xFFFDFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFCFF, 0xF7F9FDF2, 0x00ADB799, 0x005A683F, 0x00818E68, 0x007F8B67, 0x00515F35, 0x00374717, 0x00586A41, 0x0064764D, 0x004C5E35, 0x003B4D24, 0x005A6C43,
    0x00596B42, 0x0036481F, 0x0032441B, 0x006D795D, 0x0057604C, 0x0062675E, 0x00BABCBD, 0x00E5E4ED, 0x00D8D7E0, 0x00D0D1D5, 0x00C7C9CA, 0x00D8D5DE, 0x00E5E3E9, 0x00C6C5C7, 0x005D5E5C, 0x0091948B, 0x005B6051, 0x005B6150, 0x00575E49, 0x0041482D,
    0x005F664B, 0x005F664B, 0x0052593E, 0x0051583D, 0x005E654A, 0x00656C51, 0x00747B60, 0x0058693E, 0x00627348, 0x0077885D, 0x00798A5F, 0x006E7F54, 0x00718257, 0x0077885D, 0x0077885D, 0x006E8059, 0x005D6F48, 0x004B5D36, 0x004D5F38, 0x00374922,
    0x0052643D, 0x005E7049, 0x00768861, 0x0074875C, 0x0073855C, 0x0073855C, 0x0073855C, 0x0074865F, 0x00758760, 0x00758661, 0x00768762, 0x00758563, 0x00758661, 0x00798B64, 0x0073835A, 0x0076865D, 0x00707C58, 0x004D5838, 0x003B4527, 0x00404732,
    0x00485137, 0x00525D3D, 0x005A6844, 0x006F7F56, 0x0071835A, 0x0073855E, 0x00748560, 0x005A694E, 0x00495B36, 0x004E5E3F, 0x00798278, 0x00616863, 0x00434F3D, 0x002A3622, 0x00575F58, 0x0078848A, 0x00536459, 0x002B4124, 0x00657956, 0x00657556,
    0x00657155, 0x005F694B, 0x0038421E, 0x00181E13, 0x00262A24, 0x00191F1A, 0x00131918, 0x000B1312, 0x00313D37, 0x003D4C44, 0x00455649, 0x0020392F, 0x002E473D, 0x003B5349, 0x002F473B, 0x002B4135, 0x00344B3D, 0x00334A3C, 0x00324639, 0x003C4A3F,
    0x002F3D32, 0x002F3D32, 0x0039473C, 0x00324035, 0x00313F34, 0x003C4A3F, 0x00334136, 0x00324237, 0x00304035, 0x002F3F34, 0x00324237, 0x0035453A, 0x0035453A, 0x00334338, 0x00334338, 0x00263D2E, 0x002F3A30, 0x00343531, 0x000C0F0D, 0x00071210,
    0x00121D1A, 0x00171B16, 0x00201A15, 0x00333E24, 0x00606C4E, 0x00667452, 0x0063754E, 0x00697B52, 0x006C7E57, 0x00697B56, 0x006B7C5A, 0x006B7D58, 0x006D7F5A, 0x006E805B, 0x006E805B, 0x006E805B, 0x006D7F5A, 0x006E805B, 0x006F815C, 0x00778058,
    0x006E8059, 0x00667F59, 0x006D855B, 0x00677A53, 0x0041533C, 0x00667C81, 0x0067859E, 0x00617BA3, 0x005C819B, 0x00416662, 0x00577056, 0x00344B3C, 0x00406171, 0x00597FA1, 0x006183A1, 0x005F809A, 0x003B5758, 0x00435A44, 0x00374F3D, 0x00547176,
    0x006F8DA8, 0x006786A5, 0x00718FAA, 0x004F6F7A, 0x00395946, 0x003E5A3D, 0x005E7674, 0x007894AC, 0x006085A1, 0x006A8EA6, 0x0054738C, 0x003B4E33, 0x00506545, 0x00546845, 0x00596E47, 0x004F623B, 0x003F512C, 0x004A5A38, 0x00475636, 0x00425135,
    0x0057673E, 0x004F6338, 0x002D4A33, 0x0049727B, 0x004F819D, 0x00538BA4, 0x00518895, 0x0044717C, 0x00223A30, 0x004A5241, 0x00747F7C, 0x00849199, 0x00D9E0E3, 0x00CDD3D2, 0x008D999F, 0x00718489, 0x00718489, 0x0075888D, 0x007F9297, 0x008A9DA2,
    0x008A9DA2, 0x007F9297, 0x0075888D, 0x007B898F, 0x00829096, 0x00879699, 0x00838F93, 0x007E8B8D, 0x00919D9F, 0x00ABB7B9, 0x00B7C3C3, 0x006E7E5F, 0x006D7E5D, 0x00768664, 0x00778765, 0x005B694D, 0xFFB5BDAC, 0xFFFBFFFA, 0xFFFDFEFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFFFFF8, 0x00B1BB9D, 0x005C6A41, 0x00808D67, 0x007A8662, 0x004D5B31, 0x00314111, 0x002D3F16, 0x0036481F, 0x002A3C13, 0x0024360D, 0x0033451C,
    0x0034461D, 0x002C3E15, 0x00304219, 0x00707859, 0x00686E55, 0x00646855, 0x00AEAFA5, 0x00F3F3ED, 0x00E9E9E3, 0x00D7D8CF, 0x00DCDDD3, 0x00E6E6E0, 0x00EBECE3, 0x00C7C8BE, 0x00696C5D, 0x00B5B9A6, 0x00868C75, 0x007C8269, 0x00787F64, 0x007F8D64,
    0x0079875E, 0x00717F56, 0x006F7D54, 0x00738158, 0x0076845B, 0x0065734A, 0x004E5C33, 0x0054653A, 0x004E5F34, 0x006D7E53, 0x007B8C61, 0x00708156, 0x00738459, 0x0075865B, 0x00718257, 0x00788A63, 0x006A7C55, 0x0051633C, 0x004E6039, 0x00364821,
    0x00556740, 0x005D6F48, 0x0071835C, 0x0072855A, 0x0072845B, 0x0072845B, 0x0073855C, 0x0074865F, 0x0074865F, 0x00758661, 0x00768762, 0x00748564, 0x006F815C, 0x0074865D, 0x0072855A, 0x0076875B, 0x0076875C, 0x00627047, 0x0053603A, 0x00525A43,
    0x00545D42, 0x005E6C4A, 0x00707F59, 0x00798C61, 0x0072855A, 0x006E8258, 0x0075895F, 0x0079876F, 0x006C7D5B, 0x00425135, 0x00545C55, 0x004E5552, 0x00364131, 0x001C2816, 0x00787F7A, 0x00B4BEC5, 0x007D8B80, 0x00314429, 0x00596A49, 0x004A573D,
    0x004B5440, 0x00535A45, 0x002A3318, 0x00171913, 0x00222621, 0x001B2120, 0x00232D2D, 0x000F1919, 0x00172220, 0x00232D27, 0x002C372F, 0x00283A33, 0x00253730, 0x00293B34, 0x00283930, 0x00283930, 0x002C3D32, 0x002C3C31, 0x00314136, 0x002D3933,
    0x0026322C, 0x0027332D, 0x00313D37, 0x002C3832, 0x0028342E, 0x002F3B35, 0x0026322C, 0x002E3A34, 0x002B3731, 0x0028342E, 0x0025312B, 0x0024302A, 0x0028342E, 0x00323E38, 0x003C4842, 0x0028392E, 0x001C241D, 0x00202321, 0x00121718, 0x00202D2F,
    0x00253332, 0x00161B19, 0x00181310, 0x001A230E, 0x004E593F, 0x00546141, 0x005A6B46, 0x0070825B, 0x006E8059, 0x00677954, 0x006D7E5C, 0x006C7E59, 0x006E805B, 0x006F815C, 0x006F815C, 0x006E805B, 0x006D7F5A, 0x006E805B, 0x006E805B, 0x00788159,
    0x006F815A, 0x00687F59, 0x00688058, 0x00647855, 0x00405644, 0x00607F88, 0x006C93B3, 0x006F8FC0, 0x006F98B8, 0x00466E6C, 0x00516D4F, 0x0038533F, 0x004E7282, 0x006893BA, 0x006C93BA, 0x006F91AF, 0x00314E52, 0x003D5340, 0x00324836, 0x003D575D,
    0x006E8EAB, 0x006F93B7, 0x007699BB, 0x00628589, 0x0041634B, 0x002F4E2D, 0x003C5551, 0x007492AB, 0x006D93B3, 0x006E94B2, 0x006384A5, 0x003D5035, 0x00455A3A, 0x00516542, 0x005E734C, 0x0050633C, 0x003C4E29, 0x00485836, 0x004F5E3E, 0x00556448,
    0x00627249, 0x0052663B, 0x002D4A33, 0x004B747D, 0x005284A0, 0x00548CA5, 0x00528996, 0x004A7782, 0x00273F35, 0x004A5241, 0x00737E7B, 0x00828F97, 0x00D6DDE0, 0x00CDD3D2, 0x008C989E, 0x007C8F94, 0x007C8F94, 0x007E9196, 0x0084979C, 0x008A9DA2,
    0x008A9DA2, 0x0086999E, 0x00819499, 0x00849298, 0x0089979D, 0x00869598, 0x007D898D, 0x007A8789, 0x008C989A, 0x00ADB9BB, 0x00C8D4D4, 0x0085937B, 0x006E7D61, 0x00748462, 0x00778863, 0x005D6C4D, 0xFFB5BDAC, 0xFFFAFEF9, 0xFFFCFDFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFFFFF8, 0x00B1BB9D, 0x005C6A41, 0x007D8A64, 0x00798561, 0x005C6A40, 0x004A5A2A, 0x004B5D34, 0x0045572E, 0x004B5D34, 0x0046582F, 0x003E5027,
    0x0041532A, 0x0042542B, 0x0046582F, 0x00717D53, 0x006E7953, 0x005D6645, 0x007A8263, 0x009EA688, 0x008C9476, 0x00878F71, 0x009DA586, 0x008D9577, 0x008C9476, 0x00868E6F, 0x00515A39, 0x007B8561, 0x006D7852, 0x006D7850, 0x007B865E, 0x00738256,
    0x00707F53, 0x0079885C, 0x007D8C60, 0x0077865A, 0x0077865A, 0x00758458, 0x00667549, 0x004D5E33, 0x004B5C31, 0x0054653A, 0x00637449, 0x00798A5F, 0x007D8E63, 0x006F8055, 0x0077885D, 0x00768861, 0x006F815A, 0x00566841, 0x0051633C, 0x00374922,
    0x00576942, 0x005D6F48, 0x0072845D, 0x00718459, 0x0071835A, 0x0072845B, 0x0073855C, 0x0073855E, 0x0074865F, 0x00748560, 0x00748560, 0x00718260, 0x0072845F, 0x00768A60, 0x00708457, 0x006D8154, 0x0077885C, 0x00798960, 0x00788761, 0x0078826B,
    0x00768266, 0x00768462, 0x00768861, 0x0073865B, 0x00768A5F, 0x0075895F, 0x0070845A, 0x006F7C64, 0x00798967, 0x00475539, 0x004C534C, 0x00515654, 0x003F4939, 0x00151F0E, 0x005F6560, 0x006F7679, 0x00505C50, 0x00253419, 0x00687859, 0x0064705A,
    0x006E7566, 0x0072796A, 0x003C4530, 0x00191A16, 0x001B201E, 0x00212929, 0x003B4749, 0x00182426, 0x000B1515, 0x00111815, 0x00171B16, 0x00141B14, 0x000E150E, 0x00151A11, 0x00171C13, 0x001B1F14, 0x001A1E13, 0x0013170C, 0x00181A0E, 0x00131B14,
    0x00141C15, 0x00111912, 0x00161E17, 0x00171F18, 0x00121A13, 0x00141C15, 0x00121A13, 0x000D1711, 0x00101A14, 0x00121C16, 0x00111B15, 0x00101A14, 0x00111B15, 0x00111B15, 0x00111B15, 0x000E1C11, 0x00171D18, 0x00191B1B, 0x001A2124, 0x00516364,
    0x00415352, 0x000D1312, 0x00201B1A, 0x00151D0C, 0x004F5843, 0x004E5A3E, 0x004B5B39, 0x00697A55, 0x00687A53, 0x00677954, 0x0070815F, 0x006D7F5A, 0x006E805B, 0x006F815C, 0x006F815C, 0x006E805B, 0x006E805B, 0x006E805B, 0x006F815C, 0x00788159,
    0x006D7E59, 0x006C805D, 0x00657A54, 0x006C7D5B, 0x00475F4D, 0x00567983, 0x00719EBF, 0x007693C0, 0x007AA2BB, 0x0054786C, 0x00657D55, 0x00506649, 0x0060818A, 0x00729BBC, 0x006D93B5, 0x007C9BB2, 0x00465D59, 0x00546347, 0x00465539, 0x00495E5B,
    0x00819DB5, 0x007A9BBC, 0x00769AB8, 0x00799490, 0x00476443, 0x00466038, 0x003E5448, 0x00768FA3, 0x007DA0BA, 0x00789CB4, 0x006E8CA7, 0x004C5F44, 0x00495E3E, 0x00556946, 0x00596E47, 0x004C5F38, 0x004A5C37, 0x00536341, 0x004A5939, 0x00657458,
    0x00607047, 0x00465A2F, 0x0027442D, 0x004B747D, 0x005385A1, 0x00558DA6, 0x00548B98, 0x004B7883, 0x00294137, 0x0048503F, 0x00727D7A, 0x00818E96, 0x00D4DBDE, 0x00CFD5D4, 0x008E9AA0, 0x0085989D, 0x0085989D, 0x0085989D, 0x0084979C, 0x0085989D,
    0x0085989D, 0x00879A9F, 0x00889BA0, 0x00829096, 0x0087959B, 0x00839295, 0x007B878B, 0x00778486, 0x00859193, 0x00A9B5B7, 0x00CDD9D9, 0x00BAC6B4, 0x007D8B73, 0x00728161, 0x00768861, 0x00606F4F, 0xFFB5BEAA, 0xFFFCFFFB, 0xFFFDFDFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBF9FF, 0xFFFDFFF6, 0x00ACB698, 0x0059673E, 0x007C8963, 0x007F8B67, 0x0076845A, 0x00748454, 0x0076885F, 0x006D7F56, 0x00788A61, 0x0076885F, 0x0073855C,
    0x00788A61, 0x0072845B, 0x00788A61, 0x007B885C, 0x00727F53, 0x006B784C, 0x00717E52, 0x00738054, 0x00667347, 0x00748155, 0x00808D61, 0x00778758, 0x00687849, 0x00778758, 0x006C7C4D, 0x00657546, 0x006E7E4F, 0x00788859, 0x00809061, 0x007B8D5E,
    0x0077895A, 0x00758758, 0x00728455, 0x007A8C5D, 0x00798B5C, 0x00798B5C, 0x00748657, 0x005F7045, 0x004D5E33, 0x00495A2F, 0x0055663B, 0x00697A4F, 0x0077885D, 0x0077885D, 0x0076875C, 0x0070825B, 0x006D7F58, 0x0052643D, 0x004E6039, 0x0033451E,
    0x00576942, 0x005E7049, 0x00798B64, 0x00718459, 0x0072845B, 0x0072845B, 0x0073855C, 0x0074865F, 0x0074865F, 0x00748560, 0x0073845F, 0x006E835D, 0x00748760, 0x0074885D, 0x006F8358, 0x00718459, 0x00788A61, 0x00768460, 0x00697656, 0x0069725D,
    0x00646F55, 0x00647353, 0x0070815C, 0x006D8157, 0x0071855B, 0x006F825B, 0x006B805A, 0x00707D63, 0x006B7C57, 0x00455435, 0x004D554B, 0x003C423D, 0x00242E1D, 0x001B2612, 0x005D645D, 0x006F7574, 0x004F5A4A, 0x00223112, 0x00647353, 0x00626E58,
    0x007B8275, 0x00787F72, 0x00313928, 0x00181A14, 0x001A201B, 0x0025302E, 0x00415150, 0x001A2A29, 0x000F1A18, 0x00171B16, 0x001D1D17, 0x00353426, 0x00343325, 0x00383527, 0x00322F20, 0x00332E1F, 0x00383422, 0x00322E1C, 0x00302C1A, 0x00282F20,
    0x00293021, 0x001F2617, 0x001D2415, 0x001E2516, 0x00192011, 0x001C2314, 0x001D2415, 0x001C2217, 0x001B2116, 0x00191F14, 0x001A2015, 0x001E2419, 0x0022281D, 0x0022281D, 0x001F251A, 0x001E271D, 0x00191D17, 0x00141917, 0x000C1818, 0x003C5250,
    0x00374C4A, 0x000C1512, 0x00231E1B, 0x001B2215, 0x00626A59, 0x005F6952, 0x004E5D3D, 0x00697A55, 0x00697A55, 0x006C7E59, 0x006D7F5A, 0x006C7E59, 0x006D7F5A, 0x006F815C, 0x006F815C, 0x006E805B, 0x006E805B, 0x006E805B, 0x006F815C, 0x0073805A,
    0x006C7C5A, 0x0070815F, 0x006A7C55, 0x0075835F, 0x004F644E, 0x0056797D, 0x007BAAC5, 0x007794B9, 0x007EA4B6, 0x005A7A69, 0x00708155, 0x00596947, 0x00678488, 0x007BA3BC, 0x00749CB5, 0x0085A1B2, 0x005B7067, 0x0054633D, 0x00414E28, 0x004F6055,
    0x008AA4B4, 0x007799B6, 0x007BA0BC, 0x00768D88, 0x003D5533, 0x0061754A, 0x00576A5B, 0x007A94A2, 0x0081A2B6, 0x007DA1B3, 0x006A899E, 0x0055684D, 0x004C6141, 0x005E724F, 0x005F744D, 0x004B5E37, 0x004A5C37, 0x00536341, 0x00505F3F, 0x00637256,
    0x0053633A, 0x00394D22, 0x00234029, 0x0048717A, 0x005284A0, 0x00578FA8, 0x00558C99, 0x0047747F, 0x00263E34, 0x00444C3B, 0x00707B78, 0x00808D95, 0x00D4DBDE, 0x00D4DAD9, 0x00929EA4, 0x00879A9F, 0x00879A9F, 0x00879A9F, 0x00879A9F, 0x0086999E,
    0x00879A9F, 0x00879A9F, 0x00889BA0, 0x0086949A, 0x0086949A, 0x00839295, 0x007C888C, 0x00778486, 0x00879395, 0x00B0BCBE, 0x00DAE6E6, 0x00D3DDD1, 0x007E8A76, 0x006F7E5E, 0x00768861, 0x00637351, 0xFFB7C0AB, 0xFFFDFFFC, 0xFFFDFCFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFFFFF8, 0x00ADB799, 0x005C6A41, 0x007D8A64, 0x007D8965, 0x007A885E, 0x007F8F5F, 0x00788A61, 0x0073855C, 0x0075875E, 0x0076885F, 0x00778960,
    0x00788A61, 0x0073855C, 0x0074865D, 0x007A8963, 0x0073835A, 0x00798A5F, 0x007E8F63, 0x00809263, 0x007B8D5E, 0x0087986C, 0x007F9064, 0x00839867, 0x00778B5C, 0x007A8E5F, 0x00819566, 0x00728659, 0x00768A5D, 0x00788B60, 0x0072855A, 0x00798A5F,
    0x00798A5F, 0x0078895E, 0x006F8055, 0x0076875C, 0x00728358, 0x0075865B, 0x0076875C, 0x0077885D, 0x005C6D42, 0x00536439, 0x0056673C, 0x00526338, 0x0066774C, 0x007D8E63, 0x00728358, 0x0071835C, 0x006D7F58, 0x004F613A, 0x004D5F38, 0x0032441D,
    0x00576942, 0x005D6F48, 0x007B8D66, 0x0073865B, 0x0074865D, 0x0075875E, 0x0075875E, 0x00758760, 0x00758760, 0x00748560, 0x00748560, 0x0070865C, 0x006F855B, 0x006E8257, 0x00708459, 0x0070835C, 0x00627151, 0x004A583C, 0x0037442C, 0x00283221,
    0x002B3721, 0x00313F23, 0x004D5E3D, 0x0062744F, 0x006F815C, 0x00687C59, 0x006B7F5C, 0x00667556, 0x0073855C, 0x0050603E, 0x00646D60, 0x00788076, 0x005B6751, 0x005D6A52, 0x00A8B0A5, 0x00B6BDB6, 0x0088937F, 0x003E4E2C, 0x00566644, 0x003F4C34,
    0x006A7366, 0x007C8578, 0x00424C3C, 0x0014180D, 0x00131A13, 0x00182620, 0x00304340, 0x00122320, 0x000F1B15, 0x0022241E, 0x003F3D33, 0x0050533A, 0x0044472E, 0x003B3E25, 0x0033331B, 0x0036371D, 0x00403F25, 0x003D3C20, 0x003D3C20, 0x003F422C,
    0x003D402A, 0x00353822, 0x00343721, 0x0030331D, 0x002F321C, 0x00373A24, 0x00343721, 0x002A2E1B, 0x00232714, 0x001F2310, 0x00212512, 0x00272B18, 0x002F3320, 0x003F4330, 0x004D513E, 0x002C3528, 0x000F140B, 0x00181E19, 0x00162521, 0x002F4844,
    0x002E4842, 0x00111B15, 0x0015110C, 0x0021271C, 0x00666D5E, 0x00626B56, 0x00526142, 0x006F7F5D, 0x006C7D58, 0x006D7F5A, 0x006A7C57, 0x006A7C57, 0x006C7E59, 0x006E805B, 0x006F815C, 0x006E805B, 0x006E805B, 0x006F815C, 0x0070825D, 0x00728260,
    0x006D7E5D, 0x006D7E5C, 0x00717F56, 0x00737C54, 0x00415237, 0x00547370, 0x0078A4B5, 0x006D93B3, 0x00759DAF, 0x004C6D5E, 0x00606F49, 0x0048563A, 0x005B797E, 0x007AA3BC, 0x00709CB3, 0x0080A1B4, 0x005D766C, 0x004C5E37, 0x00394822, 0x00435A4C,
    0x007E9FAF, 0x007097B7, 0x0076A3C4, 0x006B8488, 0x00546D53, 0x00546C49, 0x0033483F, 0x007995A6, 0x00769DB3, 0x006D98A9, 0x007A9FB3, 0x004B5E43, 0x004E6343, 0x00667A57, 0x00627750, 0x004E613A, 0x004B5D38, 0x0050603E, 0x00556444, 0x0057664A,
    0x0048582F, 0x00394D22, 0x0027442D, 0x00466F78, 0x004F819D, 0x005991AA, 0x00538A97, 0x0045727D, 0x00263E34, 0x00424A39, 0x006F7A77, 0x00808D95, 0x00D4DBDE, 0x00D5DBDA, 0x00939FA5, 0x00819499, 0x00819499, 0x0084979C, 0x008A9DA2, 0x008FA2A7,
    0x008EA1A6, 0x00879A9F, 0x00819499, 0x0088969C, 0x00849298, 0x00829194, 0x007D898D, 0x00738082, 0x00808C8E, 0x00ACB8BA, 0x00D5E1E1, 0x00D2DAD3, 0x00788472, 0x00707F5F, 0x00788A61, 0x0063744F, 0xFFB7C0AB, 0xFFFDFFFC, 0xFFFAF9FF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFFFFF8, 0x00ACB698, 0x005E6C43, 0x00808D67, 0x007C8864, 0x0078865C, 0x007D8D5D, 0x007A8C63, 0x00778960, 0x0073855C, 0x00798B62, 0x0075875E,
    0x0076885F, 0x007F9168, 0x00798B62, 0x00758465, 0x00788767, 0x007B8C67, 0x0075875E, 0x00778960, 0x006B7D54, 0x00687A51, 0x005D6F48, 0x00596E41, 0x00687C51, 0x00607449, 0x006D8157, 0x00798C65, 0x0072845F, 0x00738560, 0x00728361, 0x0074845B,
    0x006F7F56, 0x0077875E, 0x0075855C, 0x00798960, 0x0077875E, 0x007A8A61, 0x006F7F56, 0x00798A5F, 0x0076875C, 0x005C6D42, 0x004F6035, 0x00526338, 0x005C6D42, 0x00728358, 0x007A8B60, 0x00768861, 0x0070825B, 0x004F613A, 0x004F613A, 0x00354720,
    0x00596B44, 0x005B6D46, 0x00798B64, 0x0075885D, 0x0076885F, 0x00778960, 0x00778960, 0x00778962, 0x00768861, 0x00758661, 0x00748560, 0x00738A5E, 0x006E8559, 0x006A8155, 0x0070845A, 0x0061734E, 0x00374529, 0x001D2913, 0x001E2817, 0x00404A3A,
    0x00444F3B, 0x0027341A, 0x00203011, 0x003E4F2D, 0x00687C59, 0x006C7F5E, 0x006B7D5E, 0x00778464, 0x006C7D52, 0x00475531, 0x004D5445, 0x00555B50, 0x004F5942, 0x00566147, 0x00545B4E, 0x00383E33, 0x00404A33, 0x0035431F, 0x0063714D, 0x003F4C32,
    0x00646E5E, 0x00737C6F, 0x003E4838, 0x0026281C, 0x00212A20, 0x0026372E, 0x003D534E, 0x001F332E, 0x00101D15, 0x001B1E15, 0x004A463B, 0x00586343, 0x003B4324, 0x00293112, 0x00283110, 0x00343B1A, 0x00373E1D, 0x00313714, 0x00343A17, 0x002E3013,
    0x002A2C0F, 0x002C2E11, 0x00333518, 0x002D2F12, 0x00313316, 0x003E4023, 0x0036381B, 0x0031341B, 0x002D3017, 0x0030331A, 0x00363920, 0x0033361D, 0x0032351C, 0x00474A31, 0x0062654C, 0x003F4637, 0x001D2116, 0x00192019, 0x00182A23, 0x003F5B55,
    0x003B564D, 0x0017241C, 0x002B2820, 0x00242920, 0x00585F52, 0x004D5641, 0x00465438, 0x006B7B59, 0x00657651, 0x00697B56, 0x006B7D58, 0x00697B56, 0x006B7D58, 0x006D7F5A, 0x006E805B, 0x006E805B, 0x006E805B, 0x006F815C, 0x0070825D, 0x00718261,
    0x006C7E5F, 0x006D7D5B, 0x007D865E, 0x00767D52, 0x003D4C2D, 0x00638077, 0x0083ADB9, 0x006B96B7, 0x00709DB2, 0x0043685E, 0x00586948, 0x0041503B, 0x00597984, 0x0078A7C2, 0x00689AB0, 0x00739CB2, 0x0051726B, 0x00526845, 0x004B603A, 0x00456056,
    0x0078A0B3, 0x006A9ABE, 0x00689CC1, 0x005F7A88, 0x004D6A5A, 0x00506C4F, 0x002E4946, 0x007395AC, 0x0074A2BA, 0x0071A3B7, 0x005F8EA4, 0x004E6146, 0x00647959, 0x00748865, 0x00586D46, 0x004A5D36, 0x00546641, 0x00475735, 0x00364525, 0x004D5C40,
    0x0045552C, 0x0041552A, 0x00304D36, 0x00466F78, 0x004D7F9B, 0x005991AA, 0x00518895, 0x0047747F, 0x00273F35, 0x00424A39, 0x006F7A77, 0x007F8C94, 0x00D2D9DC, 0x00D3D9D8, 0x00919DA3, 0x0075888D, 0x0075888D, 0x007B8E93, 0x00889BA0, 0x0094A7AC,
    0x0092A5AA, 0x0083969B, 0x0075888D, 0x007A888E, 0x0079878D, 0x00819093, 0x00859195, 0x007C898B, 0x00869294, 0x00AEBABC, 0x00D3DFDF, 0x00D9E0DB, 0x007F8A7A, 0x00788768, 0x00798B62, 0x005E7049, 0xFFB4BEA7, 0xFFFDFFFC, 0xFFFDFCFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFBFF, 0xFFFFFFF9, 0x00ADB799, 0x005D6A44, 0x007D8A64, 0x00808D67, 0x00647347, 0x00637441, 0x005E7047, 0x00687A51, 0x00576940, 0x0066794E, 0x0065784D,
    0x00607447, 0x00596D40, 0x0063774A, 0x00718162, 0x0058664E, 0x00485442, 0x00646E62, 0x00505A4D, 0x003A4634, 0x00324126, 0x003A4A2B, 0x00313B2B, 0x00353F2E, 0x00313D27, 0x00495539, 0x00485634, 0x0057653C, 0x00728155, 0x00819162, 0x0076845B,
    0x00708050, 0x00768952, 0x00758555, 0x00828F69, 0x00727D5D, 0x0075825C, 0x0079895A, 0x0077875E, 0x007A8A61, 0x00798960, 0x0058683F, 0x004E5E35, 0x0058683F, 0x005A6A41, 0x0078885F, 0x00798C61, 0x0073855C, 0x004E6037, 0x004B5D34, 0x00384A23,
    0x0053653E, 0x0061724D, 0x007B8C67, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x0074865F, 0x0073855E, 0x0073855E, 0x00738462, 0x0070835C, 0x0071845D, 0x0069785C, 0x002E3929, 0x00242D23, 0x003B4735, 0x003B4A2E, 0x0058614D,
    0x004F5A46, 0x00384231, 0x00303A29, 0x0024311B, 0x0039482C, 0x006D815E, 0x006C815A, 0x0072865C, 0x00677954, 0x004B5C3B, 0x0049583C, 0x00425136, 0x002D3C20, 0x00223312, 0x002D3F1A, 0x003F5231, 0x00243716, 0x002D3E1C, 0x005B6A4A, 0x004A563A,
    0x006D745F, 0x007F8475, 0x00505147, 0x003B4025, 0x002B3420, 0x001F2A22, 0x002D3A3C, 0x000F1B21, 0x0012191C, 0x001D211C, 0x002A291F, 0x002B371B, 0x003D4C26, 0x00425425, 0x0036471C, 0x002B3719, 0x002D381E, 0x003F4D2B, 0x0055663A, 0x004E5D3D,
    0x00414E36, 0x001C2616, 0x00242822, 0x00222620, 0x00222718, 0x002C341D, 0x00364121, 0x00343623, 0x0030321E, 0x002F321C, 0x0030361F, 0x002F341F, 0x002D3020, 0x002C3025, 0x0030332A, 0x001B2319, 0x001D1F19, 0x001C1D1B, 0x0016211F, 0x00374C49,
    0x002B413C, 0x00152018, 0x002C2921, 0x00252C1F, 0x00545C4B, 0x00606A53, 0x004C5B3B, 0x006D7E59, 0x00687A53, 0x00687B54, 0x00687B54, 0x006C8055, 0x0071855A, 0x006E8258, 0x006E8258, 0x0072855E, 0x0070835C, 0x0070835C, 0x00738560, 0x00738263,
    0x006D7D5B, 0x006B7F55, 0x00738A5E, 0x00708761, 0x0051664D, 0x0067786D, 0x00879895, 0x007698A5, 0x0078979A, 0x00617D70, 0x005F7961, 0x003A543C, 0x006C8A7D, 0x007B9EA1, 0x007CA4B0, 0x008499A1, 0x00526A6A, 0x00526F60, 0x0042624A, 0x0042614C,
    0x0078928C, 0x008FA2AF, 0x008F9EB8, 0x00637F68, 0x0057735F, 0x004D6858, 0x00375046, 0x006E8783, 0x00869D9F, 0x0092AAB0, 0x00637A82, 0x005C6A46, 0x006E7F5A, 0x00748560, 0x005E6F4A, 0x00455732, 0x00495B36, 0x004F643E, 0x003C512B, 0x00435635,
    0x00505E3A, 0x00586642, 0x00354C36, 0x004C7272, 0x00578B9C, 0x00558DA6, 0x005187A0, 0x003F737F, 0x00213C33, 0x003D4737, 0x006F7776, 0x00818D93, 0x00D1D9D9, 0x00CFD8D5, 0x008FA0A3, 0x006E868C, 0x00657D83, 0x006C848A, 0x007A9298, 0x008AA2A8,
    0x008DA5AB, 0x007D959B, 0x00768E94, 0x0078889F, 0x00768697, 0x0082939C, 0x00839596, 0x007D8C88, 0x00889593, 0x00AEB8B8, 0x00D8E1E4, 0x00D4DAD9, 0x007E887B, 0x007B8A6B, 0x00788A61, 0x005D6F48, 0xFFB4BEA7, 0xFFFDFFFB, 0xFFFDFCFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBF7FF, 0xFFFFFFF9, 0x00ACB698, 0x005E6B45, 0x00818E68, 0x007F8C66, 0x004F5E32, 0x00394A17, 0x0031431A, 0x002F4118, 0x0032441B, 0x0035481D, 0x002C3F14,
    0x00304417, 0x00314518, 0x00364A1D, 0x006F805F, 0x00526146, 0x004E5A48, 0x00767F75, 0x00A2ABA1, 0x00ADB7AB, 0x00B0BCAA, 0x00AFBCA6, 0x00B3BBB1, 0x00B7C0B3, 0x00A3AD9C, 0x005C6550, 0x00394529, 0x004D5837, 0x007B8862, 0x00707E55, 0x007C8864,
    0x007D8D5E, 0x007E905B, 0x00778757, 0x00798660, 0x00798463, 0x007E8C63, 0x007C8D5A, 0x0078885F, 0x006C7C53, 0x007E8E65, 0x0078885F, 0x005B6B42, 0x0054643B, 0x0054643B, 0x0057673E, 0x00708358, 0x0072845B, 0x0055673E, 0x00506239, 0x00384A23,
    0x00556740, 0x0062734E, 0x007A8B66, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x0074865F, 0x0073855E, 0x0073855E, 0x0070815F, 0x0073865F, 0x006F825B, 0x0048573B, 0x00263121, 0x003E473D, 0x00414D3B, 0x0037462A, 0x004F5843,
    0x0046513D, 0x003B4534, 0x003B4632, 0x00293620, 0x0029381C, 0x00516443, 0x00687D57, 0x00687C52, 0x00778964, 0x00677758, 0x005F6D55, 0x0064725A, 0x0067765B, 0x00637453, 0x003D4F2A, 0x00536645, 0x00435635, 0x00556644, 0x00697858, 0x004D593D,
    0x00707762, 0x00727768, 0x0048493F, 0x00393D24, 0x002C3423, 0x00242F27, 0x00323F41, 0x00111D21, 0x00101818, 0x00171B16, 0x00222018, 0x00141B0C, 0x002F3922, 0x003B4828, 0x002A361A, 0x00141C0B, 0x00141B0E, 0x00323B26, 0x00556143, 0x006B7B59,
    0x004C593F, 0x00162010, 0x00191E15, 0x001E221C, 0x0022261B, 0x00232916, 0x00222A13, 0x00252812, 0x002A2D17, 0x002F331A, 0x002B311A, 0x00232714, 0x001A1E12, 0x001A1C16, 0x001E1F1D, 0x001A2218, 0x001C1E18, 0x001C1D1B, 0x0016211F, 0x00384D4A,
    0x002C423D, 0x00141F17, 0x0029261E, 0x002D3427, 0x005D6554, 0x00616B54, 0x004B5A3A, 0x006E7F5A, 0x00687A53, 0x006B7E57, 0x006B7E57, 0x006B7F54, 0x006C8055, 0x006C8056, 0x006F8359, 0x0070835C, 0x006B7E57, 0x006B7D58, 0x006E805B, 0x00768462,
    0x0076855F, 0x0072845B, 0x0073875D, 0x00718562, 0x004E6146, 0x003A4C3B, 0x002E3E33, 0x003C534E, 0x004C6355, 0x00566950, 0x00748363, 0x00556645, 0x00657A61, 0x00506A5C, 0x0044635C, 0x006A7872, 0x00556658, 0x0062775E, 0x00516848, 0x003C5235,
    0x00576A55, 0x006B7A72, 0x00717D7D, 0x00495B3E, 0x00586B50, 0x0060735A, 0x00465742, 0x00526453, 0x00536457, 0x005F7065, 0x0046574E, 0x0055633F, 0x0071825D, 0x0071825D, 0x005C6D48, 0x00566843, 0x004B5D38, 0x003D522C, 0x004E633D, 0x00485B3A,
    0x005F6D49, 0x00566440, 0x00374E38, 0x00527878, 0x00538798, 0x00548CA5, 0x004E849D, 0x00447884, 0x00254037, 0x00414B3B, 0x00717978, 0x00818D93, 0x00D1D9D9, 0x00D0D9D6, 0x0091A2A5, 0x0083969D, 0x0082959C, 0x008A9DA4, 0x008C9FA6, 0x008EA1A8,
    0x008EA1A8, 0x00899CA3, 0x008B9EA5, 0x008394A7, 0x0080919E, 0x008799A0, 0x00819394, 0x00798785, 0x00869391, 0x00ABB4B7, 0x00D4DADF, 0x00D1D8D3, 0x00778272, 0x00728162, 0x007A8C63, 0x00667851, 0xFFB7C1AA, 0xFFFCFFFA, 0xFFFBFBFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDF9FF, 0xFFFFFFF9, 0x00ABB597, 0x005C6943, 0x00818E68, 0x00818E68, 0x004C5B2F, 0x002F400D, 0x0051633A, 0x0052643B, 0x00475930, 0x00203308, 0x0035481D,
    0x00475B2E, 0x00304417, 0x0035491C, 0x006E7E5C, 0x004A583C, 0x00545E4E, 0x0099A099, 0x00EAEFEE, 0x00ECF1EF, 0x00EBF1EC, 0x00E8F0E6, 0x00E5EAE9, 0x00ECF1EF, 0x00C9D0C9, 0x005D6457, 0x005C6551, 0x00545D43, 0x00687254, 0x006F7A5A, 0x00656D56,
    0x005C6746, 0x00556339, 0x005E6C43, 0x00606B4A, 0x00606B4B, 0x005B6940, 0x005D6E3B, 0x0078885F, 0x00718158, 0x00728259, 0x0077875E, 0x00708057, 0x005B6B42, 0x004F5F36, 0x0054643B, 0x005C6F44, 0x0064764D, 0x0052643B, 0x004F6138, 0x0034461F,
    0x0053653E, 0x0061724D, 0x00778863, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x0074865F, 0x0074865F, 0x0073855E, 0x0070815F, 0x0073865F, 0x00687B54, 0x002A391D, 0x002B3626, 0x00565F55, 0x003C4836, 0x002E3D21, 0x00364029,
    0x002C3822, 0x00303B27, 0x00404B37, 0x0035422C, 0x0028371C, 0x003C4F2E, 0x006D815E, 0x0073875D, 0x006C7D5B, 0x005B6A4F, 0x006C7864, 0x006A7662, 0x0047553D, 0x005B6B4C, 0x00495B36, 0x00526544, 0x00455837, 0x00637452, 0x005E6D4D, 0x00354125,
    0x00676E59, 0x00676C5D, 0x00323329, 0x00212310, 0x001F2617, 0x00232D27, 0x003A4847, 0x001A2729, 0x00141C1C, 0x00151914, 0x001A1810, 0x001D201E, 0x0022271E, 0x001E2516, 0x00171D12, 0x00171B16, 0x001C1F1D, 0x00252923, 0x0030372A, 0x00647550,
    0x0048563A, 0x00151F0E, 0x00171C13, 0x001E221D, 0x00262822, 0x00282C21, 0x00272B1F, 0x00262A11, 0x00353920, 0x003E442B, 0x00383E27, 0x00262C1B, 0x00191D12, 0x00181917, 0x00191B1C, 0x00182016, 0x001A1B17, 0x001A1B19, 0x00172121, 0x003A4F4D,
    0x002D433E, 0x00121C16, 0x00242119, 0x00242B1E, 0x005A6251, 0x0059634C, 0x00465535, 0x006E7F5A, 0x00687A53, 0x006D8059, 0x006D8059, 0x006B7F55, 0x00697D53, 0x006C8056, 0x006E815A, 0x006D8059, 0x006B7D58, 0x006C7E59, 0x0070825D, 0x00717F55,
    0x00728057, 0x0075855C, 0x007A8864, 0x006E7E5C, 0x00465637, 0x00324126, 0x002D3B23, 0x00344425, 0x00475232, 0x0059603B, 0x0082855E, 0x00686D46, 0x005E6943, 0x00384727, 0x002E4323, 0x00555D46, 0x005E674C, 0x00747F5E, 0x0065724C, 0x00414F26,
    0x003B4822, 0x00404B2A, 0x00434D2F, 0x00485130, 0x00687150, 0x00777F60, 0x005C6747, 0x00475133, 0x00354123, 0x003C482A, 0x00333F23, 0x0054623E, 0x0070815C, 0x0070815C, 0x00677853, 0x004C5E39, 0x00455732, 0x00596E48, 0x00445933, 0x00485B3A,
    0x0063714D, 0x004B5935, 0x00304731, 0x004F7575, 0x004F8394, 0x00568EA7, 0x005288A1, 0x00447884, 0x00254037, 0x00424C3C, 0x00727A79, 0x007F8B91, 0x00CFD7D7, 0x00D2DBD8, 0x0093A4A7, 0x0091A3AA, 0x0090A2A9, 0x0094A6AD, 0x0092A4AB, 0x0094A6AD,
    0x009BADB4, 0x0099ABB2, 0x009CAEB5, 0x0096A8B3, 0x0090A3AA, 0x0090A3A6, 0x00819190, 0x00748281, 0x00889494, 0x00B4BDC1, 0x00DDE3E8, 0x00DEE7DD, 0x00818D7B, 0x00707F60, 0x00798B64, 0x00667752, 0xFFB4BEA7, 0xFFFCFFFA, 0xFFFDFDFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFAFF, 0xFFFFFFF9, 0x00ACB698, 0x005C6943, 0x007E8B65, 0x007E8B65, 0x00526135, 0x0040511E, 0x006A7A51, 0x00607047, 0x005D6D44, 0x0034451A, 0x005D6E43,
    0x006B7C50, 0x003C4D21, 0x003C4D21, 0x00677853, 0x004E5C40, 0x00545E4E, 0x00AAAFAD, 0x00E4E7EB, 0x00D0D3D8, 0x00C6C9CD, 0x00BABEBF, 0x00D3D6DB, 0x00DCDFE3, 0x00D6DBDA, 0x00686C66, 0x00474E41, 0x00414736, 0x00515843, 0x00424A33, 0x00575854,
    0x00535849, 0x003B442A, 0x003A4329, 0x00363C29, 0x003C422F, 0x003A4426, 0x004D5B32, 0x0073835A, 0x0076865D, 0x006C7C53, 0x0074845B, 0x007F8F66, 0x006E7E55, 0x005C6C43, 0x0053633A, 0x004E6136, 0x0051633A, 0x00485A31, 0x004E6037, 0x0034461F,
    0x0053653E, 0x0061724D, 0x00798A65, 0x0074865F, 0x0074865F, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x0074865F, 0x0074865F, 0x00748563, 0x0073865F, 0x005C6F48, 0x00243317, 0x00424D3D, 0x005A6359, 0x002C3826, 0x00253418, 0x00303B21,
    0x0026331B, 0x002A3521, 0x003B4632, 0x003D4A34, 0x002F3E23, 0x00293B1C, 0x00617453, 0x0070845A, 0x00687958, 0x00414E38, 0x00465141, 0x00485245, 0x0025311D, 0x00516044, 0x00495B36, 0x005E7150, 0x00425534, 0x00637452, 0x00687757, 0x003E4A2E,
    0x006A715C, 0x006F7465, 0x0035362C, 0x0018180A, 0x00161C11, 0x001A241E, 0x002F3D3B, 0x00111F1E, 0x00121A19, 0x001A1E19, 0x0024211C, 0x001F2220, 0x001F231E, 0x001B1F19, 0x001C201A, 0x00242725, 0x00242725, 0x001E221D, 0x001C201A, 0x004C5C3A,
    0x003C4A2E, 0x0018230F, 0x001B2116, 0x001C201B, 0x00212220, 0x001F201E, 0x001F201C, 0x00242A11, 0x00363C23, 0x00444A31, 0x003B422D, 0x00292E1F, 0x001C1E18, 0x0017191A, 0x0018181E, 0x00171E17, 0x00181915, 0x00191919, 0x00182222, 0x003C514F,
    0x002E4340, 0x00101A14, 0x001F1B16, 0x00181F12, 0x00555D4C, 0x00566049, 0x00465535, 0x0070815C, 0x00687A53, 0x006C7F58, 0x006A7D56, 0x006C8056, 0x006A7E54, 0x006F825B, 0x006D8059, 0x006B7D58, 0x0071835E, 0x00738560, 0x00758762, 0x007C8B5F,
    0x00728056, 0x00717E58, 0x0077835F, 0x00717F5D, 0x005B6947, 0x00546240, 0x00586642, 0x00657147, 0x00687248, 0x00656A43, 0x007D8059, 0x006D7049, 0x00656D45, 0x004D5B31, 0x00516439, 0x004B5635, 0x005C6746, 0x006D7857, 0x006B7753, 0x005A6741,
    0x00515F35, 0x00556536, 0x00546434, 0x005B6142, 0x00717758, 0x00737B5C, 0x006C7554, 0x005A6642, 0x0056623E, 0x0056653F, 0x00505F39, 0x005C6A46, 0x00758661, 0x0072835E, 0x00556641, 0x004A5C37, 0x004F613C, 0x004D623C, 0x004A5F39, 0x003D502F,
    0x00515F3B, 0x003F4D29, 0x002A412B, 0x00486E6E, 0x00518596, 0x00578FA8, 0x005389A2, 0x003D717D, 0x001E3930, 0x003E4838, 0x00707877, 0x007C888E, 0x00CED6D6, 0x00D3DCD9, 0x0093A4A7, 0x008D9AA2, 0x008C99A1, 0x00919EA6, 0x00909DA5, 0x0097A4AC,
    0x00A3B0B8, 0x00A0ADB5, 0x009EABB3, 0x0099ADB2, 0x0099ACAF, 0x009AACAD, 0x00879698, 0x007B8988, 0x00969FA2, 0x00C1C8CB, 0x00E3EAED, 0x00D1DCCC, 0x0085927C, 0x00748363, 0x00788964, 0x0061714F, 0xFFABB49F, 0xFFFCFFFA, 0xFFFDFEFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDF9FF, 0xFFFDFFF7, 0x00AAB496, 0x005F6C46, 0x007F8C66, 0x0077845E, 0x004D5C30, 0x00425320, 0x00596940, 0x0034441B, 0x005A6A41, 0x0056673C, 0x0068794E,
    0x006B7C50, 0x00435428, 0x0036471B, 0x0072835E, 0x00657357, 0x005D6757, 0x00B6BBBA, 0x00D9DBE3, 0x00CDCED8, 0x00C9CBD3, 0x00B8BBC0, 0x00C3C5CD, 0x00D2D5DA, 0x00CFD3D4, 0x008B8F8A, 0x00797F74, 0x00666B5C, 0x00585E4B, 0x00636A55, 0x008C8992,
    0x00848583, 0x0054584C, 0x0055594D, 0x0083857F, 0x00A1A39D, 0x00707665, 0x004B5439, 0x00798960, 0x0075855C, 0x0076865D, 0x007A8A61, 0x00708057, 0x0074845B, 0x0078885F, 0x0054643B, 0x00506338, 0x0046582F, 0x0042542B, 0x0052643B, 0x003A4C25,
    0x00576942, 0x0063744F, 0x007E8F6A, 0x0074865F, 0x0074865F, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x0074865F, 0x0074865F, 0x00758664, 0x00768962, 0x0052653E, 0x0027361A, 0x00556050, 0x00525B51, 0x0024301E, 0x00223115, 0x00313D21,
    0x002D3A20, 0x002B3721, 0x00333E2A, 0x003C4834, 0x0037452D, 0x00213316, 0x00556748, 0x006E8258, 0x006F805F, 0x00465240, 0x005D665C, 0x007A827B, 0x004F5A4A, 0x0057664A, 0x00455732, 0x00586B4A, 0x00415433, 0x00546543, 0x00627151, 0x00495539,
    0x00606752, 0x00616657, 0x00303127, 0x001A1810, 0x00191D17, 0x001C2522, 0x002E3C3A, 0x000E1C1A, 0x00101916, 0x00191D18, 0x0023201C, 0x00171D12, 0x001C2118, 0x001F231D, 0x00242920, 0x002A3025, 0x00262C21, 0x001E231A, 0x001C201A, 0x00313F23,
    0x002C3921, 0x0016200F, 0x00191F14, 0x00181C17, 0x001B1B1B, 0x00131214, 0x00111012, 0x001F240F, 0x002E331E, 0x00373E29, 0x00333926, 0x00272B1F, 0x001C201A, 0x00181A1B, 0x0016161C, 0x00161D16, 0x00181915, 0x00191919, 0x00182222, 0x003D5250,
    0x002F4441, 0x000F1913, 0x001D1914, 0x001B2215, 0x00596150, 0x005F6952, 0x004C5B3B, 0x0070815C, 0x00687A53, 0x006B7E57, 0x00687B54, 0x006A7D56, 0x006D8059, 0x00748760, 0x006C7E59, 0x006C7E59, 0x00758762, 0x006F805E, 0x006B7C5A, 0x00718257,
    0x0077875E, 0x007C8B65, 0x007A8864, 0x00788460, 0x007D8965, 0x007C8A61, 0x007A885E, 0x00809067, 0x00808D67, 0x00747F5E, 0x007F8768, 0x00778262, 0x007A8866, 0x0072845D, 0x007B9167, 0x00758665, 0x007A8A6B, 0x0078876B, 0x0077866A, 0x00748564,
    0x00738560, 0x00788C61, 0x00768C5C, 0x00748169, 0x007A876D, 0x00718065, 0x00768667, 0x00768766, 0x007C906D, 0x007B906A, 0x00748963, 0x00707E5A, 0x0072835E, 0x00596A45, 0x00556641, 0x004B5D38, 0x003E502B, 0x004E633D, 0x004A5F39, 0x00374A29,
    0x003F4D29, 0x00404E2A, 0x002E452F, 0x00436969, 0x00568A9B, 0x00538BA4, 0x004E849D, 0x003B6F7B, 0x001B362D, 0x003D4737, 0x00707877, 0x007C888E, 0x00CED6D6, 0x00D3DCD9, 0x0092A3A6, 0x00849199, 0x0089969E, 0x0093A0A8, 0x0094A1A9, 0x0098A5AD,
    0x009EABB3, 0x0099A6AE, 0x0096A3AB, 0x0099ADAE, 0x009BAFB0, 0x00A4B5B8, 0x009CA9AB, 0x00929EA0, 0x009DA7A7, 0x00A8B1AE, 0x00B0B7B4, 0x009BA892, 0x00758469, 0x00768565, 0x007B8C67, 0x00606F50, 0xFFA7B09C, 0xFFFBFFF9, 0xFFFDFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFBFF, 0xFBF9FCF3, 0x00A3AD8F, 0x005D6A44, 0x00828F69, 0x007A8761, 0x004D5C30, 0x0041521F, 0x006B7950, 0x00546239, 0x00637148, 0x00536137, 0x00616F45,
    0x00707F53, 0x004B5A2E, 0x003B4A1E, 0x006C7A58, 0x00576347, 0x00555C4F, 0x00AEB1AF, 0x00DEDEE4, 0x00D5D4DD, 0x00D5D5DB, 0x00D5D6DA, 0x00D1D4D9, 0x00E3E7E8, 0x00C0C5C3, 0x008D918B, 0x00A8AFA2, 0x00777D6A, 0x004B533C, 0x00838C72, 0x0099989A,
    0x008C8F86, 0x00616756, 0x00696E5F, 0x00A8AAA4, 0x00BEC0BA, 0x0084897A, 0x00545C45, 0x006A7A51, 0x0077875E, 0x007B8B62, 0x0075855C, 0x006C7C53, 0x0076865D, 0x007F8F66, 0x0065754C, 0x0054673C, 0x00405229, 0x003F5128, 0x0053653C, 0x00394B24,
    0x00556740, 0x005F704B, 0x00798A65, 0x0073855E, 0x0074865F, 0x0074865F, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x00718260, 0x007A8D66, 0x004F623B, 0x00233216, 0x00586353, 0x004A5349, 0x00273321, 0x00243317, 0x00273315,
    0x002D3B1F, 0x002A371F, 0x002E3925, 0x00394531, 0x003D4A34, 0x0026371C, 0x005B6D50, 0x0071855B, 0x00708061, 0x00606B5B, 0x00ACB3B0, 0x00D0D7D4, 0x007C867A, 0x00505F44, 0x0052643F, 0x004A5D3C, 0x00586B4A, 0x00566745, 0x00455434, 0x00475337,
    0x006D745F, 0x00656A5B, 0x00313228, 0x00181413, 0x001B1E1C, 0x00222B28, 0x00364541, 0x00162521, 0x00151E1B, 0x00181B19, 0x001D1A16, 0x001C2413, 0x001A2015, 0x00161A15, 0x001C201A, 0x00262D1E, 0x00232B1A, 0x00192013, 0x00151913, 0x001B2514,
    0x00232D1C, 0x001C2518, 0x001D2219, 0x00161A15, 0x001A1A1A, 0x00181719, 0x00201F23, 0x001E2014, 0x00252A1B, 0x002B3120, 0x002B3120, 0x00242B1E, 0x001E231A, 0x00191E1C, 0x00171B1C, 0x00171D18, 0x00181917, 0x0019181A, 0x00172023, 0x003C5051,
    0x002E4341, 0x000E1714, 0x001D1815, 0x001A2114, 0x00545C4B, 0x00656F58, 0x004C5B3B, 0x00687954, 0x00677952, 0x006B7E57, 0x006C7F58, 0x00677A53, 0x006D8059, 0x00768863, 0x006D7F5A, 0x0070825D, 0x00728361, 0x005D6E4C, 0x00576846, 0x004F603F,
    0x00576847, 0x00687957, 0x0073855E, 0x006F7E58, 0x0073835A, 0x00748259, 0x007A885F, 0x006E7F5D, 0x0070815F, 0x006C7C5D, 0x006F8162, 0x006D7F60, 0x00728465, 0x006D8360, 0x00718764, 0x00708565, 0x00708467, 0x006C8063, 0x006C7F64, 0x006D8164,
    0x006E8363, 0x006F8562, 0x006D845E, 0x0072826A, 0x0074856A, 0x006A7D62, 0x006C8063, 0x006D8464, 0x00708767, 0x00718967, 0x0067805E, 0x00788662, 0x005D6E49, 0x0053643F, 0x0050613C, 0x003D4F2A, 0x0041532E, 0x004F643E, 0x00435832, 0x00445736,
    0x0043512D, 0x0044522E, 0x00314832, 0x003D6363, 0x00568A9B, 0x00538BA4, 0x004F859E, 0x00407480, 0x001D382F, 0x003E4838, 0x00717978, 0x007B878D, 0x00CED6D6, 0x00D4DDDA, 0x0091A2A5, 0x00798B92, 0x00788A91, 0x0081939A, 0x00889AA1, 0x0092A4AB,
    0x0098AAB1, 0x008B9DA4, 0x0083959C, 0x00899C9F, 0x008D9DA3, 0x009FADB3, 0x00A7B3B7, 0x00A8B4B4, 0x00A6B0AA, 0x008C968A, 0x00727D6D, 0x0078876C, 0x006F7F60, 0x007B8B69, 0x007F8F6D, 0x00616F53, 0xFFA6AE9D, 0xFFFDFFFB, 0xFFFDFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFBFF, 0xFFFBFEF5, 0x00A2AC8E, 0x005B6842, 0x0083906A, 0x00808D67, 0x00505F33, 0x003F501D, 0x00647249, 0x006A784F, 0x00536138, 0x00324016, 0x00435127,
    0x0059683C, 0x0038471B, 0x0038471B, 0x00697656, 0x005F6A50, 0x007F8679, 0x00A6A9A7, 0x00ECEDF1, 0x00DDDEE2, 0x00D4D6D6, 0x00DDE0DE, 0x00D3D8D7, 0x00E2E7E5, 0x00CED5CE, 0x006B7265, 0x006A735F, 0x00525B41, 0x00596345, 0x00636E4E, 0x00575D4A,
    0x005E684A, 0x00586440, 0x00505B3B, 0x005F6651, 0x00606655, 0x00687157, 0x00798463, 0x004E5E35, 0x00697950, 0x0074845B, 0x0077875E, 0x007D8D64, 0x007C8C63, 0x0073835A, 0x0068784F, 0x00516439, 0x003D4F26, 0x0041532A, 0x0053653C, 0x00354720,
    0x0054663F, 0x005D6E49, 0x00758661, 0x0073855E, 0x0073855E, 0x0074865F, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x00728361, 0x00788B64, 0x0052653E, 0x00202F13, 0x00556050, 0x00464F45, 0x0025311F, 0x00243317, 0x00263313,
    0x002D3B1F, 0x0027341C, 0x002F3A26, 0x00394531, 0x00394630, 0x0022321A, 0x005A6B50, 0x0075895F, 0x006B7A5E, 0x00465044, 0x0074797A, 0x00888D8E, 0x00596258, 0x0044523A, 0x0071835E, 0x00465938, 0x00516443, 0x00536442, 0x00384727, 0x004A563A,
    0x00818873, 0x006C7162, 0x00303127, 0x001C1719, 0x001C1E1F, 0x001F2726, 0x002F3E3A, 0x0011211A, 0x00141E18, 0x001C1F1D, 0x00221E1D, 0x001A2015, 0x001C1F1D, 0x00191A1E, 0x00191B1C, 0x00191E15, 0x00141B0E, 0x00121610, 0x0018191D, 0x00171E17,
    0x00242C22, 0x00232B21, 0x0020251C, 0x00141812, 0x001A1B19, 0x001B1B1B, 0x00272628, 0x00191A16, 0x001C1E18, 0x0021251A, 0x0022291C, 0x001F2619, 0x00192116, 0x00171E17, 0x00171D18, 0x00181E19, 0x00191A18, 0x001A191B, 0x00172023, 0x003B4F50,
    0x002D4240, 0x000F1815, 0x001F1A17, 0x00171E11, 0x004E5645, 0x006E7861, 0x00516040, 0x00647550, 0x00687A53, 0x006B7E57, 0x006F825B, 0x006B7E57, 0x006D7F5A, 0x0072845F, 0x006C7E59, 0x00748563, 0x006C7D5B, 0x004D5E3D, 0x004E5F3E, 0x00566954,
    0x004A5F46, 0x00576C4B, 0x0073895F, 0x00778B60, 0x00798B62, 0x006F7E58, 0x00748260, 0x00778563, 0x00758563, 0x00758762, 0x00748963, 0x0070855F, 0x00738862, 0x00738764, 0x00748563, 0x0070825D, 0x006F815C, 0x00748661, 0x00758762, 0x00738462,
    0x00738463, 0x00718162, 0x006F7F60, 0x0073845F, 0x00778863, 0x00768762, 0x00738560, 0x00788A65, 0x00738764, 0x00788C69, 0x006E825F, 0x0065734F, 0x0052633E, 0x00596A45, 0x0032431E, 0x00465833, 0x005B6D48, 0x002A3F19, 0x00536842, 0x00495C3B,
    0x004F5D39, 0x0044522E, 0x00344B35, 0x00416767, 0x00548899, 0x00558DA6, 0x005389A2, 0x00427682, 0x001C372E, 0x003B4535, 0x006D7574, 0x0078848A, 0x00CDD5D5, 0x00D6DFDC, 0x0092A3A6, 0x0074878E, 0x006B7E85, 0x0070838A, 0x007D9097, 0x008EA1A8,
    0x0095A8AF, 0x008699A0, 0x007D9097, 0x007E9097, 0x007E8D96, 0x008F9BA5, 0x009EA9B1, 0x00ABB5B5, 0x00A9B4AA, 0x008A9682, 0x006B785E, 0x00778867, 0x00748564, 0x007C8C6A, 0x007D8C6C, 0x00606D53, 0xFFA5AD9C, 0xFFFDFFFB, 0xFFFDFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCF8FF, 0xFFFCFFF6, 0x00A7B193, 0x005D6A44, 0x00828F69, 0x007E8B65, 0x0049582C, 0x0031420F, 0x00344219, 0x0039471E, 0x00344219, 0x00344218, 0x002D3B11,
    0x00354418, 0x0029380C, 0x0039481C, 0x00677454, 0x00838D76, 0x00C2C9BC, 0x00969A95, 0x00E6E8E8, 0x00E1E3E3, 0x00D0D4CF, 0x00C9CEC5, 0x00D0D6D1, 0x00D9E1D7, 0x00CFD8CB, 0x00656D5C, 0x007F8972, 0x00646E50, 0x007B8665, 0x0077835F, 0x0076845B,
    0x00748454, 0x00768952, 0x006D7D4D, 0x007A8662, 0x00717C5C, 0x0066724E, 0x00505F33, 0x0056663D, 0x00516138, 0x00697950, 0x007B8B62, 0x0075855C, 0x0078885F, 0x0078885F, 0x00627249, 0x004F6237, 0x00405229, 0x00485A31, 0x00576940, 0x00374922,
    0x00596B44, 0x0063744F, 0x00798A65, 0x0073855E, 0x0073855E, 0x0074865F, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x00768765, 0x0073865F, 0x00556841, 0x00213014, 0x00545F4F, 0x00434C42, 0x001E2A18, 0x00223115, 0x00273414,
    0x00273617, 0x001E2B13, 0x00313D27, 0x003D4935, 0x00394630, 0x00213119, 0x005B6C51, 0x0073875D, 0x0069785C, 0x004E574D, 0x007D8285, 0x00808489, 0x00525A53, 0x00324028, 0x006A7C57, 0x00596C4B, 0x00324524, 0x004B5C3A, 0x00556444, 0x00667256,
    0x008C937E, 0x00676C5D, 0x00313228, 0x00191219, 0x001A1B1F, 0x001E2625, 0x002F3F38, 0x0011211A, 0x00121C16, 0x00171A18, 0x001A1615, 0x001A1E19, 0x0018181E, 0x00141120, 0x0016151F, 0x001A1D1B, 0x00171B15, 0x00151718, 0x001B1827, 0x00141918,
    0x001B201E, 0x00151B16, 0x00171B15, 0x00161A14, 0x0022231F, 0x001C1D1B, 0x00202020, 0x001C1B1D, 0x001D1D1D, 0x001F231D, 0x0023291E, 0x0021281B, 0x00192215, 0x00182015, 0x001C241A, 0x00191F1A, 0x001A1B19, 0x001A191B, 0x00172023, 0x00394D4E,
    0x002C413F, 0x000F1815, 0x00201B18, 0x001D2417, 0x00525A49, 0x007D8770, 0x005E6D4D, 0x00697A55, 0x006C7E57, 0x006A7D56, 0x006D8059, 0x0071835E, 0x006C7E59, 0x006C7E59, 0x006A7C57, 0x00768765, 0x00697A58, 0x00475837, 0x00526342, 0x003C5043,
    0x00445943, 0x005A7250, 0x006C8559, 0x00687F52, 0x0075895E, 0x0070805E, 0x00748364, 0x007D8461, 0x0078835D, 0x0076875C, 0x0073875A, 0x006F8356, 0x00708358, 0x00788761, 0x00788460, 0x0078865C, 0x00728155, 0x0079885C, 0x0077865A, 0x00738157,
    0x00788460, 0x00788363, 0x007B8469, 0x007A8656, 0x00798658, 0x007A8759, 0x00727F53, 0x007A885E, 0x00728057, 0x0074845B, 0x0065754C, 0x00515F3B, 0x005D6E49, 0x002C3D18, 0x004B5C37, 0x00596B46, 0x00334520, 0x004A5F39, 0x004A5F39, 0x003A4D2C,
    0x0052603C, 0x0042502C, 0x003E553F, 0x00507676, 0x00578B9C, 0x00568EA7, 0x0050869F, 0x00407480, 0x00163128, 0x00343E2E, 0x00676F6E, 0x00737F85, 0x00CCD4D4, 0x00D7E0DD, 0x0094A5A8, 0x0080989E, 0x007A9298, 0x00829AA0, 0x008BA3A9, 0x0095ADB3,
    0x0098B0B6, 0x0090A8AE, 0x0091A9AF, 0x0098A6B2, 0x008D9BA7, 0x00909CA8, 0x00939EA6, 0x0099A3A3, 0x009BA89A, 0x0087967B, 0x00728260, 0x00768765, 0x00728361, 0x00758563, 0x00798868, 0x005F6C52, 0xFFA3AB9A, 0xFFFDFFFB, 0xFFF9FBFB, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFEFFF7, 0x009EA88A, 0x00606E45, 0x007F8C66, 0x00788460, 0x00657349, 0x004C5C2C, 0x004B5B32, 0x004D5D34, 0x004B5B32, 0x004B5B32, 0x004C5C33,
    0x0047572E, 0x0044542B, 0x004C5C33, 0x006C7D51, 0x00627348, 0x00899773, 0x007F8B6D, 0x008A967A, 0x008B977B, 0x00717D5F, 0x00879474, 0x006A7658, 0x00748062, 0x00869171, 0x006B7655, 0x005C6642, 0x00616C46, 0x007F8A62, 0x007E875F, 0x007B8E63,
    0x0075885D, 0x0074875C, 0x0077875E, 0x0076855F, 0x007B8862, 0x0077835F, 0x00697551, 0x004B5B32, 0x005D6D44, 0x004F5F36, 0x006E7E55, 0x007C8C63, 0x007B8B62, 0x007A8A61, 0x0067774E, 0x0050623B, 0x0042542D, 0x00475932, 0x0050623B, 0x003B4D26,
    0x00566841, 0x0061734C, 0x00768861, 0x0073855C, 0x0073855C, 0x0074865D, 0x0074865D, 0x0074865D, 0x0074865D, 0x0073855C, 0x0073855C, 0x00748661, 0x00778867, 0x00505F43, 0x00222F19, 0x004E5A46, 0x00485442, 0x00283420, 0x0024311B, 0x0029321E,
    0x002A371D, 0x00243314, 0x002F3C24, 0x003D473A, 0x00343E32, 0x00304028, 0x003F5330, 0x004F5D3B, 0x004B563C, 0x00545B4C, 0x00A4A9A0, 0x00BDC2B9, 0x006A7162, 0x00404B31, 0x004C5A38, 0x004C5A42, 0x00435237, 0x003F4D31, 0x00485738, 0x005D6B4F,
    0x006D7760, 0x00555D4C, 0x00282F20, 0x00211710, 0x001A1E18, 0x0022332F, 0x00384847, 0x00181F22, 0x001D1A1C, 0x001C1A19, 0x00191D18, 0x00181D1B, 0x00151B16, 0x00181F18, 0x001C2118, 0x00161B12, 0x00151914, 0x001B1B1B, 0x001C1B1D, 0x001B1B1B,
    0x00171816, 0x001A1C16, 0x001A1D14, 0x00161910, 0x00191C13, 0x001E201A, 0x001C1D19, 0x001B1B21, 0x001B1D1D, 0x00282D24, 0x001F2617, 0x001F2716, 0x00192011, 0x00191E15, 0x00191C1A, 0x00161A1B, 0x001B1D17, 0x001C2015, 0x0017231D, 0x003B4F50,
    0x00304445, 0x00111C14, 0x001E1E0C, 0x001F2213, 0x005C624F, 0x006B745A, 0x00556242, 0x0070815C, 0x00697C55, 0x006B8059, 0x00637852, 0x006D7A5A, 0x0071815F, 0x00748560, 0x0072845D, 0x006A7D56, 0x00516240, 0x00445637, 0x00607156, 0x00526348,
    0x004E6041, 0x00627351, 0x0071845D, 0x0074865D, 0x0073855C, 0x0070825B, 0x00788662, 0x0071835E, 0x0071835E, 0x0071835E, 0x0071835E, 0x0071835E, 0x0071835E, 0x0071835E, 0x0071835E, 0x00748563, 0x00748563, 0x00748563, 0x00748563, 0x00738462,
    0x00728361, 0x00718260, 0x0070815F, 0x006F805B, 0x00758661, 0x00768762, 0x00748560, 0x00798A65, 0x00748560, 0x00667752, 0x00495A35, 0x005E6F4A, 0x002C3D18, 0x0041532E, 0x005A6C47, 0x0030451F, 0x00425731, 0x005D744E, 0x001D340E, 0x00465E40,
    0x003F502E, 0x00303F19, 0x002F452C, 0x004B706C, 0x0055899A, 0x004A859F, 0x00558FAC, 0x003E7185, 0x001E3936, 0x00495346, 0x00697472, 0x0098A6AC, 0x00D5DCDF, 0x00CFD8DB, 0x0097A7B3, 0x008F9CA4, 0x0094A1A9, 0x008F9CA4, 0x0097A4AC, 0x009CA9B1,
    0x009CA9B1, 0x00A4B1B9, 0x00A1AEB6, 0x00A6AEB5, 0x009FAAA8, 0x00929F97, 0x008C9A94, 0x00909C9C, 0x0098A5A3, 0x00798C7B, 0x006C8466, 0x00728263, 0x00778867, 0x0073845F, 0x00788964, 0x00606F4F, 0xFFA4AD98, 0xFFFDFFF8, 0xFFF7FAF8, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFEFFF7, 0x009DA789, 0x00606E45, 0x007D8A64, 0x007C8864, 0x007A885E, 0x00768656, 0x007E8E65, 0x007B8B62, 0x0077875E, 0x0078885F, 0x007C8C63,
    0x007C8C63, 0x007A8A61, 0x007B8B62, 0x007F925F, 0x006B7D4E, 0x00708156, 0x006B7A54, 0x0075845E, 0x00718158, 0x006D7E53, 0x00839468, 0x00778561, 0x006A7854, 0x006A7854, 0x006C7953, 0x00707E55, 0x00717C54, 0x0079855B, 0x0078845A, 0x00708457,
    0x00728659, 0x00778A5F, 0x0078895E, 0x0074845B, 0x0079875E, 0x007E8C63, 0x007C8963, 0x0066764D, 0x004A5A31, 0x005A6A41, 0x0054643B, 0x00708057, 0x0078885F, 0x007B8B62, 0x00627249, 0x0050623B, 0x0041532C, 0x00455730, 0x004E6039, 0x003A4C25,
    0x00556740, 0x0060724B, 0x00768861, 0x0073855C, 0x0073855C, 0x0074865D, 0x0074865D, 0x0074865D, 0x0074865D, 0x0073855C, 0x0073855C, 0x00738560, 0x00778867, 0x00505F43, 0x00212E18, 0x004C5844, 0x0044503E, 0x0024301C, 0x00212E18, 0x00222B17,
    0x00222F15, 0x00243314, 0x002F3C24, 0x00404A3D, 0x00424C40, 0x0044543C, 0x005A6E4B, 0x00556543, 0x00556445, 0x0045523A, 0x00626D59, 0x0068735F, 0x003D4A32, 0x003F4E2F, 0x005A6A48, 0x00404F34, 0x004B5A3F, 0x00505E42, 0x004D5C3D, 0x00566448,
    0x0058624B, 0x004B5342, 0x00495041, 0x003D342B, 0x0022271E, 0x001A2C25, 0x002F403D, 0x00141C1B, 0x001A1818, 0x00191814, 0x001A1E18, 0x001D231E, 0x00171E17, 0x001B2319, 0x00242A1F, 0x001F241B, 0x001B1C18, 0x001D1D1D, 0x001F1E22, 0x001C1B1D,
    0x001B1B1B, 0x001E1F1D, 0x001D1E1A, 0x00181A14, 0x001B1D17, 0x0020211D, 0x001E1F1B, 0x0017181C, 0x00161917, 0x00252B20, 0x0022291A, 0x00222A19, 0x001A2114, 0x001A1E18, 0x00212323, 0x00131718, 0x00191B15, 0x001B1E15, 0x0014201A, 0x00344849,
    0x002B3F40, 0x0019241C, 0x00333321, 0x00323526, 0x00646A57, 0x00646D53, 0x004D5A3A, 0x006B7C57, 0x00657851, 0x00697E58, 0x00677C56, 0x006B7858, 0x006F7F5D, 0x00687954, 0x006F815A, 0x005F724B, 0x004A5B39, 0x00506243, 0x0044553A, 0x00506146,
    0x005D6F50, 0x00768765, 0x00788B64, 0x0072845B, 0x0074865D, 0x0071835C, 0x00707E5A, 0x00738560, 0x00738560, 0x00738560, 0x00738560, 0x00738560, 0x00738560, 0x00738560, 0x00738560, 0x00738462, 0x00748563, 0x00748563, 0x00748563, 0x00738462,
    0x00738462, 0x00728361, 0x00718260, 0x0073845F, 0x00758661, 0x0072835E, 0x0073845F, 0x0073845F, 0x006C7D58, 0x00445530, 0x005D6E49, 0x002B3C17, 0x004A5B36, 0x005E704B, 0x002E401B, 0x00475C36, 0x005D724C, 0x00223913, 0x0049603A, 0x00496143,
    0x00293A18, 0x0035441E, 0x003D533A, 0x00365B57, 0x00518596, 0x005E99B3, 0x00457F9C, 0x0043768A, 0x002E4945, 0x00626C5F, 0x0085908D, 0x00AAB8BE, 0x00E0E7EA, 0x00D2DBDE, 0x0093A3AF, 0x008A9AA1, 0x0090A0A7, 0x0093A3AA, 0x0099A9B0, 0x009BABB2,
    0x0099A9B0, 0x009CACB3, 0x009AAAB1, 0x0099A3AD, 0x0097A4A6, 0x00919F9B, 0x0092A09C, 0x0097A3A3, 0x009DA8A5, 0x007B8B79, 0x00697E5D, 0x00768569, 0x007B8C6B, 0x00758661, 0x00788964, 0x005F6E4E, 0xFF9FA893, 0xFFFDFFF8, 0xFFFDFFFE, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCFAFF, 0xFBFBFFF4, 0x00A0AA8C, 0x00647249, 0x007C8963, 0x00798561, 0x0078865C, 0x00819161, 0x0074845B, 0x0077875E, 0x007B8B62, 0x00798960, 0x0075855C,
    0x0075855C, 0x0078885F, 0x007A8A61, 0x00778A57, 0x007C8F5E, 0x0077895A, 0x0077885C, 0x00809165, 0x007D8F60, 0x00839663, 0x007D925B, 0x00809166, 0x00809166, 0x007E8F64, 0x007E8C62, 0x007A885E, 0x007A885E, 0x007C885E, 0x007B875D, 0x00728659,
    0x0074885B, 0x00778B5E, 0x0076875B, 0x00718256, 0x00758359, 0x0079875D, 0x0079875D, 0x0073835A, 0x0068784F, 0x0047572E, 0x0057673E, 0x00526239, 0x006F7F56, 0x007A8A61, 0x0064744B, 0x0050623B, 0x0041532C, 0x0044562F, 0x004C5E37, 0x00384A23,
    0x0054663F, 0x0060724B, 0x00768861, 0x0073855C, 0x0073855C, 0x0074865D, 0x0074865D, 0x0074865D, 0x0074865D, 0x0073855C, 0x0073855C, 0x0072845F, 0x00768766, 0x004E5D41, 0x001F2C16, 0x004B5743, 0x00414D3B, 0x00212D19, 0x00202D17, 0x0027301C,
    0x00263319, 0x002C3B1C, 0x00323F27, 0x003D473A, 0x00353F33, 0x002B3B23, 0x00495D3A, 0x00546442, 0x00556543, 0x00394927, 0x00394828, 0x003C4B2B, 0x00324220, 0x00465634, 0x00586846, 0x00314024, 0x00445337, 0x004E5D3E, 0x00475637, 0x00616F53,
    0x007F8972, 0x00646C5B, 0x0040473A, 0x004A4235, 0x00252B20, 0x00172A21, 0x0031423E, 0x0019221F, 0x001E1D19, 0x0021211B, 0x00282D24, 0x002A3228, 0x001B2318, 0x001B2215, 0x0021281B, 0x001E2118, 0x00171814, 0x00181719, 0x001E1A20, 0x00181719,
    0x001A191B, 0x001C1B1D, 0x00191919, 0x00161616, 0x00191A18, 0x001E1F1D, 0x001C1D1B, 0x001A1C1C, 0x00181C17, 0x00242B1E, 0x00232B1A, 0x00202817, 0x00161C11, 0x00161A15, 0x00222425, 0x001A1E1F, 0x001A1B17, 0x00191C13, 0x0018241E, 0x003F5255,
    0x00374A4D, 0x00222D25, 0x00383828, 0x00353829, 0x00616754, 0x005B644A, 0x00485535, 0x006A7B56, 0x00647651, 0x00647953, 0x00677C56, 0x00697656, 0x0071815F, 0x0072835E, 0x004D5F38, 0x004E613A, 0x00455634, 0x00213314, 0x004F6045, 0x0057684D,
    0x00617354, 0x00758664, 0x0072855E, 0x006C7E55, 0x0072845B, 0x0074865F, 0x00778561, 0x00748661, 0x00748661, 0x00748661, 0x00748661, 0x00748661, 0x00748661, 0x00748661, 0x00748661, 0x00738560, 0x00738560, 0x00738560, 0x00748661, 0x00748661,
    0x00738560, 0x00738560, 0x0072845F, 0x00788964, 0x006E7F5A, 0x006E7F5A, 0x00798A65, 0x00667752, 0x003F502B, 0x0061724D, 0x00344520, 0x00485934, 0x00657651, 0x002B3D18, 0x004A5C37, 0x005A6F49, 0x002A3F19, 0x00455C36, 0x0049603A, 0x0021391B,
    0x004B5C3A, 0x00485731, 0x00263C23, 0x00385D59, 0x00588C9D, 0x00538EA8, 0x004E88A5, 0x00487C8D, 0x0035504C, 0x00636E5E, 0x00838E8B, 0x009DABB1, 0x00DAE1E4, 0x00D2DBDE, 0x0094A5AE, 0x007F9299, 0x0080939A, 0x00889BA2, 0x008FA2A9, 0x0095A8AF,
    0x0096A9B0, 0x008DA0A7, 0x00899CA3, 0x008F9EAE, 0x00899BA2, 0x007F9190, 0x00879593, 0x008F9B9B, 0x009BA59F, 0x007D8975, 0x006A7A58, 0x00718064, 0x00768766, 0x00728260, 0x00778863, 0x00627152, 0xFF9FA893, 0xFFFCFFF8, 0xFFFDFFFE, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFEFFF7, 0x009FA98B, 0x00627047, 0x007B8862, 0x007E8A66, 0x0078865C, 0x00819161, 0x00798960, 0x00798960, 0x007C8C63, 0x007D8D64, 0x007C8C63,
    0x007E8E65, 0x007D8D64, 0x0076865D, 0x0073865B, 0x007C8E65, 0x0073845F, 0x00758661, 0x00758760, 0x006D7F56, 0x00728657, 0x00687D4C, 0x00687B50, 0x006E8156, 0x00738459, 0x0076875C, 0x00738157, 0x007C8A60, 0x007B895F, 0x00778359, 0x0074875C,
    0x00708358, 0x006F8356, 0x00728357, 0x0075865A, 0x007A895D, 0x00788859, 0x00748455, 0x0077875E, 0x007D8D64, 0x005C6C43, 0x004B5B32, 0x0058683F, 0x00506037, 0x0076865D, 0x0068784F, 0x0052643D, 0x0042542D, 0x00455730, 0x004C5E37, 0x00384A23,
    0x0054663F, 0x0061734C, 0x00788A63, 0x0073855C, 0x0073855C, 0x0074865D, 0x0074865D, 0x0074865D, 0x0074865D, 0x0073855C, 0x0073855C, 0x0070825D, 0x00758665, 0x004D5C40, 0x001E2B15, 0x004C5844, 0x00414D3B, 0x00202C18, 0x00222F19, 0x001D2612,
    0x001E2B11, 0x00273617, 0x002F3C24, 0x00424C3F, 0x00323C30, 0x001F2F17, 0x004F6340, 0x00758661, 0x0072845D, 0x0054663D, 0x004F6237, 0x0052653A, 0x004B5D34, 0x0052643D, 0x0051623D, 0x00516142, 0x00425332, 0x004D5C3C, 0x00495838, 0x0048563A,
    0x005E6752, 0x00565E4D, 0x0040473A, 0x00423A2D, 0x00262D20, 0x00213529, 0x00394B44, 0x001A241E, 0x001A1A14, 0x001C1D14, 0x00242A1F, 0x002A3025, 0x001D2417, 0x001A2112, 0x00212617, 0x001E2217, 0x001A1C16, 0x001B1919, 0x001A161B, 0x00171717,
    0x00171618, 0x0017161A, 0x00161519, 0x00161519, 0x001A191B, 0x001B1C1A, 0x00191A16, 0x001A1E18, 0x001C2316, 0x00262E1D, 0x00242D18, 0x00222B17, 0x001C2316, 0x00181B19, 0x00222327, 0x001D2024, 0x001B1C18, 0x001A1D14, 0x001B2623, 0x0044575A,
    0x00394C4F, 0x001E2822, 0x00303020, 0x00393B2F, 0x006B7160, 0x00636B54, 0x004E5B3B, 0x006E7E5C, 0x00697B56, 0x00677C56, 0x006A7E5B, 0x00788565, 0x00687856, 0x00586944, 0x004E6039, 0x0050633C, 0x00445533, 0x0037492A, 0x004C5D42, 0x00506146,
    0x004C5E3F, 0x00627351, 0x0073865F, 0x00778960, 0x0075875E, 0x0070825B, 0x00778561, 0x0072845F, 0x0072845F, 0x0072845F, 0x0072845F, 0x0072845F, 0x0072845F, 0x0072845F, 0x0072845F, 0x0072845F, 0x0072845F, 0x00738560, 0x00738560, 0x00748661,
    0x00738560, 0x00738560, 0x00738560, 0x0073845F, 0x0073845F, 0x00768762, 0x00647550, 0x004E5F3A, 0x005D6E49, 0x002D3E19, 0x00475833, 0x005A6B46, 0x002F401B, 0x004A5C37, 0x00546641, 0x002F441E, 0x00415630, 0x004F6640, 0x00283F19, 0x00486042,
    0x00425331, 0x00374620, 0x002E442B, 0x003F6460, 0x00528697, 0x004F8AA4, 0x00508AA7, 0x00477B8C, 0x002D4844, 0x004D5848, 0x006A7572, 0x00808F92, 0x00CBD3D3, 0x00D0DADA, 0x0095A6AF, 0x00748A90, 0x006D8389, 0x00768C92, 0x007E949A, 0x008DA3A9,
    0x0093A9AF, 0x0081979D, 0x00788E94, 0x00788C9E, 0x007E929D, 0x007E9293, 0x00899998, 0x008E9A9C, 0x00979E9B, 0x007F8A76, 0x006E7C5A, 0x00718064, 0x00768667, 0x00728260, 0x00758563, 0x00637253, 0xFFA2AB97, 0xFFF9FEF5, 0xFFFBFDFD, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFFFFF8, 0x009EA88A, 0x00606E45, 0x007C8963, 0x00808C68, 0x00627046, 0x005B6B3B, 0x0057673E, 0x005A6A41, 0x005E6E45, 0x005D6D44, 0x005A6A41,
    0x00596940, 0x005C6C43, 0x005E6E45, 0x00738165, 0x00556248, 0x0045513B, 0x0056614D, 0x00505B47, 0x0035422A, 0x002C3A1E, 0x00354425, 0x00263614, 0x00293917, 0x00374823, 0x0045532F, 0x0042512B, 0x0055633A, 0x006E7C52, 0x007B895F, 0x0074865F,
    0x0074865F, 0x0074865D, 0x0077885D, 0x00798A5F, 0x007A895D, 0x00768657, 0x00758556, 0x0076865D, 0x0077875E, 0x007C8C63, 0x0057673E, 0x0058683F, 0x00526239, 0x005C6C43, 0x005E6E45, 0x0053653E, 0x0043552E, 0x00465831, 0x004E6039, 0x003A4C25,
    0x00566841, 0x0063754E, 0x00798B64, 0x0073855C, 0x0073855C, 0x0074865D, 0x0074865D, 0x0074865D, 0x0074865D, 0x0073855C, 0x0073855C, 0x0070825D, 0x00758665, 0x004C5B3F, 0x001F2C16, 0x004F5B47, 0x00434F3D, 0x00212D19, 0x0026331D, 0x0029321E,
    0x0028351B, 0x00283718, 0x00313E26, 0x00495346, 0x00323C30, 0x001F2F17, 0x005E724F, 0x0072845F, 0x00798C65, 0x006D8157, 0x00708459, 0x0075895E, 0x0065794F, 0x00566942, 0x00475934, 0x00435432, 0x004E5F3D, 0x006C7C5A, 0x00637351, 0x004C5B3C,
    0x00565F4A, 0x004E5546, 0x002E3429, 0x00292114, 0x001B2215, 0x001E3128, 0x00354740, 0x00151E1B, 0x00171612, 0x00171711, 0x00191F14, 0x00191E15, 0x00171D12, 0x001F2317, 0x00272C1D, 0x002A2F20, 0x002D2E24, 0x00272721, 0x001B1918, 0x00181917,
    0x00181818, 0x0018171B, 0x001A181E, 0x001C1A20, 0x001B1A1C, 0x00171814, 0x0015180F, 0x0018210D, 0x00212A15, 0x00293519, 0x00273317, 0x0029331C, 0x00272E1F, 0x00161A15, 0x00131516, 0x0015181C, 0x00191A18, 0x001A1C16, 0x0016211E, 0x00374A4F,
    0x002A3D42, 0x00121C16, 0x0029281A, 0x002F3125, 0x00676D5C, 0x005F6750, 0x00424E30, 0x00566644, 0x00556742, 0x00556946, 0x00586C49, 0x005F6C4C, 0x0051613F, 0x00465732, 0x00495B34, 0x005A6D46, 0x00576846, 0x00465839, 0x0054654A, 0x004B5C41,
    0x00415334, 0x00576846, 0x0070835C, 0x00798B62, 0x0074865D, 0x006E8059, 0x00778561, 0x0071835E, 0x0071835E, 0x0071835E, 0x0071835E, 0x0071835E, 0x0071835E, 0x0071835E, 0x0071835E, 0x0071845D, 0x0072855E, 0x0072855E, 0x0073865F, 0x0073865F,
    0x0073865F, 0x0072855E, 0x0072855E, 0x0072835E, 0x00798A65, 0x006A7B56, 0x004A5B36, 0x005E6F4A, 0x003B4C27, 0x003D4E29, 0x005A6B46, 0x0030411C, 0x00475833, 0x005C6E49, 0x0031431E, 0x00445933, 0x00586D47, 0x00253C16, 0x0049603A, 0x00465E40,
    0x002B3C1A, 0x0036451F, 0x00455B42, 0x00476C68, 0x0055899A, 0x005994AE, 0x004C86A3, 0x0045798A, 0x0026423C, 0x00404C3A, 0x0065716B, 0x0078878A, 0x00CCD4D4, 0x00D1DBDB, 0x0092A4AB, 0x00748A90, 0x006C8288, 0x0073898F, 0x007A9096, 0x00899FA5,
    0x0090A6AC, 0x007F959B, 0x00778D93, 0x0074889A, 0x007D919C, 0x007C9192, 0x00859496, 0x00818C90, 0x00899190, 0x007F8979, 0x00758163, 0x00748368, 0x0079896A, 0x00788767, 0x00758563, 0x005F6D51, 0xFFA4AD99, 0xFFFCFFFA, 0xFFFDFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFFFFF8, 0x009EA88A, 0x00627047, 0x007E8B65, 0x007C8864, 0x0048562C, 0x00334313, 0x0035451C, 0x0034441B, 0x00304017, 0x00304017, 0x0035451C,
    0x00324219, 0x00304017, 0x0036461D, 0x00727E68, 0x004B5544, 0x004A5346, 0x00828982, 0x009FA5A0, 0x0099A099, 0x0090988E, 0x009BA398, 0x009AA595, 0x009BA795, 0x008C9783, 0x0058654B, 0x00414E2E, 0x004D5B37, 0x00718158, 0x007D8B61, 0x00738262,
    0x00788767, 0x007A8A68, 0x007A8864, 0x0075845E, 0x00728057, 0x00738157, 0x007B8A5E, 0x00708057, 0x0076865D, 0x0076865D, 0x0077875E, 0x005C6C43, 0x00596940, 0x0056663D, 0x00415128, 0x0053653E, 0x0044562F, 0x00475932, 0x004F613A, 0x003B4D26,
    0x00576942, 0x0063754E, 0x00798B64, 0x0073855C, 0x0073855C, 0x0074865D, 0x0074865D, 0x0074865D, 0x0074865D, 0x0073855C, 0x0073855C, 0x0071835E, 0x00758665, 0x004A593D, 0x001F2C16, 0x00535F4B, 0x00465240, 0x00222E1A, 0x0028351F, 0x002A331F,
    0x0029361C, 0x00273617, 0x00323F27, 0x00475144, 0x00303A2E, 0x001F2F17, 0x00566A47, 0x0070815F, 0x00687957, 0x00485937, 0x00405130, 0x004B5C3B, 0x00495A38, 0x00475836, 0x00475836, 0x004F613C, 0x006B7E57, 0x006F805B, 0x00536341, 0x00556445,
    0x0077806B, 0x00676E5F, 0x002B3027, 0x001D140B, 0x0012170E, 0x00172922, 0x002E3F3C, 0x00141C1B, 0x001E1C1C, 0x001D1C18, 0x00181C16, 0x00131614, 0x00171814, 0x001D2116, 0x0024291A, 0x002B2E1E, 0x00303323, 0x002E2E20, 0x00202012, 0x00181C11,
    0x00171814, 0x00171618, 0x001B191F, 0x001C1B1F, 0x00161715, 0x00161910, 0x001D2213, 0x00525F3F, 0x005B6947, 0x005C6B45, 0x00596842, 0x005A6747, 0x00515A45, 0x00292E25, 0x00151816, 0x00111418, 0x00161715, 0x00191B15, 0x0015201E, 0x00394C51,
    0x002E4146, 0x00101916, 0x001E1D0F, 0x0023241A, 0x00616657, 0x00606851, 0x00455133, 0x004D5D3B, 0x004C5D3B, 0x004D613E, 0x004C5F3E, 0x004D5A3A, 0x0051613F, 0x0053643F, 0x0040522B, 0x005E714A, 0x006A7B59, 0x00445637, 0x0065765B, 0x00495A3F,
    0x004B5D3E, 0x00617250, 0x006D8059, 0x006F8158, 0x00708259, 0x0070825B, 0x00778561, 0x00738560, 0x00738560, 0x00738560, 0x00738560, 0x00738560, 0x00738560, 0x00738560, 0x00738560, 0x0071845D, 0x0071845D, 0x0072855E, 0x0072855E, 0x0072855E,
    0x0072855E, 0x0071845D, 0x0071845D, 0x00748560, 0x006A7B56, 0x00445530, 0x0062734E, 0x003A4B26, 0x00394A25, 0x005F704B, 0x00394A25, 0x00475833, 0x0060714C, 0x0030421D, 0x00445631, 0x00586D47, 0x00334822, 0x00415832, 0x004C633D, 0x0020381A,
    0x0040512F, 0x004A5933, 0x003E543B, 0x004B706C, 0x005A8E9F, 0x00518CA6, 0x00518BA8, 0x00477B8B, 0x0026423C, 0x003C4836, 0x006B7771, 0x007A898B, 0x00CFD7D6, 0x00D3DEDC, 0x008FA1A8, 0x007F9299, 0x007D9097, 0x0082959C, 0x0085989F, 0x008A9DA4,
    0x008DA0A7, 0x008699A0, 0x0084979E, 0x008598A7, 0x007D9097, 0x00667B79, 0x0069787A, 0x0069747C, 0x00788185, 0x00747F75, 0x0065755E, 0x006D7C61, 0x006D7C60, 0x00768565, 0x00788767, 0x005E6C50, 0xFFA3AB9A, 0xFFFCFFFA, 0xFFFDFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFFFFF8, 0x009CA688, 0x00627047, 0x007E8B65, 0x007F8B67, 0x004D5B31, 0x00425222, 0x0063734A, 0x0054643B, 0x00415128, 0x004A5A31, 0x00627249,
    0x005B6B42, 0x00425229, 0x003A4A21, 0x0067765A, 0x0048553F, 0x004F5A4A, 0x00A4ACA5, 0x00D9E0DD, 0x00E4EAE9, 0x00E1E7E6, 0x00E2E8E7, 0x00E5E9EE, 0x00EAEFF2, 0x00BCC3BE, 0x00565F52, 0x0049553F, 0x00566244, 0x006A7953, 0x005A6A41, 0x00536046,
    0x00505D43, 0x0049573B, 0x004B5838, 0x00515F3D, 0x0054613B, 0x0055633A, 0x005C6A41, 0x0073835A, 0x0074845B, 0x0077875E, 0x00728259, 0x007D8D64, 0x004E5E35, 0x0064744B, 0x002E3E15, 0x0052643D, 0x0043552E, 0x00475932, 0x0050623B, 0x003B4D26,
    0x00566841, 0x0062744D, 0x00788A63, 0x0073855C, 0x0073855C, 0x0074865D, 0x0074865D, 0x0074865D, 0x0074865D, 0x0073855C, 0x0073855C, 0x00738560, 0x00768766, 0x0049583C, 0x001E2B15, 0x0054604C, 0x00475341, 0x00212D19, 0x0027341E, 0x0028311D,
    0x0027341A, 0x00283718, 0x0035422A, 0x003F493C, 0x00303A2E, 0x00293921, 0x00455936, 0x004C603D, 0x00455738, 0x0033432B, 0x003D4C37, 0x004C5B46, 0x003A4A32, 0x00394B2C, 0x00526643, 0x006E815A, 0x006E8258, 0x0062744D, 0x005D6E49, 0x005C6B4C,
    0x00646D58, 0x00596053, 0x00282D24, 0x00271C18, 0x00181C17, 0x00182926, 0x002D3C3E, 0x00141A1F, 0x001E1A1F, 0x001B1919, 0x00141715, 0x001C1A20, 0x00171618, 0x001A1C16, 0x00212415, 0x00262B16, 0x002E3219, 0x002E3219, 0x00262A11, 0x001E2413,
    0x001B1F14, 0x00181917, 0x0019181C, 0x00181719, 0x00161713, 0x00272C1D, 0x00444B36, 0x0074855A, 0x00738458, 0x006A7C4D, 0x006C7E4F, 0x00707F59, 0x00636F53, 0x002E3526, 0x00131711, 0x0013161B, 0x00191A18, 0x001A1B17, 0x0016211F, 0x003F5257,
    0x00384A51, 0x00141D1A, 0x00181709, 0x001A1B11, 0x0054594A, 0x005A614C, 0x00485438, 0x00475636, 0x00435432, 0x00455837, 0x00445736, 0x004C5939, 0x00475735, 0x00384924, 0x00455730, 0x004B5E37, 0x00495A38, 0x004C5E3F, 0x00334429, 0x003E4F34,
    0x004E6041, 0x006E7F5D, 0x00758861, 0x0071835A, 0x00708259, 0x006D7F58, 0x006F7D59, 0x0072845F, 0x0072845F, 0x0072845F, 0x0072845F, 0x0072845F, 0x0072845F, 0x0072845F, 0x0072845F, 0x0071855B, 0x0071855B, 0x0071855B, 0x0071855B, 0x0071855B,
    0x0070845A, 0x006F8359, 0x006F8359, 0x006E7F5A, 0x003F502B, 0x0061724D, 0x00374823, 0x0041522D, 0x005D6E49, 0x00364722, 0x0041522D, 0x00657651, 0x00263712, 0x004C5E39, 0x00536540, 0x00283D17, 0x00485D37, 0x00516842, 0x00243B15, 0x00496143,
    0x00475836, 0x00495832, 0x0040563D, 0x00426763, 0x004D8192, 0x004E89A3, 0x004F89A6, 0x004A7E8E, 0x00254239, 0x00374331, 0x006D7A72, 0x00758486, 0x00CBD3D2, 0x00D2DDDB, 0x0091A3AA, 0x0088989F, 0x008B9BA2, 0x008B9BA2, 0x008E9EA5, 0x008E9EA5,
    0x008D9DA4, 0x0090A0A7, 0x008F9FA6, 0x008A99A2, 0x00809293, 0x00687B78, 0x006A797B, 0x0069757F, 0x007A8690, 0x00818F8D, 0x0076897A, 0x0085937B, 0x006D7C60, 0x00707F5F, 0x00798868, 0x005F6D51, 0xFFA3AB9A, 0xFFFBFFF9, 0xFFFCFEFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFCFFF5, 0x009DA789, 0x0067754C, 0x007F8C66, 0x007A8662, 0x0047552B, 0x00455525, 0x005E6E45, 0x00617148, 0x005B6B42, 0x005F6F46, 0x0067774E,
    0x004E5E35, 0x0035451C, 0x003B4B22, 0x006C7E59, 0x004A5A3B, 0x00505D47, 0x00BAC4B7, 0x00E8EFEA, 0x00D4DAD9, 0x00C8CDCE, 0x00C6CBCC, 0x00D0CFE3, 0x00E8E8F8, 0x00C4C7CF, 0x00585E59, 0x004E5848, 0x003F4B2F, 0x0045532F, 0x003C4C23, 0x00636F59,
    0x004E5A44, 0x0037442A, 0x003A462A, 0x004E5B3B, 0x00576241, 0x004E5A36, 0x004A5731, 0x007B8B62, 0x0077875E, 0x0076865D, 0x00718158, 0x00798960, 0x0068784F, 0x00526239, 0x003C4C23, 0x0050623B, 0x0042542D, 0x00465831, 0x004F613A, 0x003B4D26,
    0x00566841, 0x0061734C, 0x00768861, 0x0073855C, 0x0073855C, 0x0074865D, 0x0074865D, 0x0074865D, 0x0074865D, 0x0073855C, 0x0073855C, 0x00758762, 0x00778867, 0x0048573B, 0x001D2A14, 0x0055614D, 0x00475341, 0x001F2B17, 0x0025321C, 0x002C3521,
    0x0028351B, 0x002C3B1C, 0x0039462E, 0x003D473A, 0x003E483C, 0x00485840, 0x00526643, 0x004A5E3B, 0x00506146, 0x005D6A5A, 0x007E897F, 0x007C877D, 0x00435040, 0x003A4B30, 0x006D815E, 0x00667A50, 0x0062764C, 0x0062744B, 0x00697A55, 0x005B6A4B,
    0x00636C57, 0x00676E61, 0x00292E25, 0x00231715, 0x00141616, 0x00152426, 0x002B3A3D, 0x0012181F, 0x001B171D, 0x001B171C, 0x00181A1B, 0x001D1925, 0x0016141A, 0x001D1C18, 0x00292C1D, 0x002E341D, 0x0033381B, 0x0033391A, 0x00303617, 0x002B321D,
    0x00262A1E, 0x001E1F1B, 0x001A191B, 0x00181818, 0x001D1F19, 0x00424837, 0x00727B61, 0x00607342, 0x00586B38, 0x004B5F2A, 0x00576A37, 0x0066774B, 0x005F6C4C, 0x002C3423, 0x00151A11, 0x0014171C, 0x001E1E1E, 0x001D1E1A, 0x00111C1A, 0x0034464D,
    0x002F4148, 0x00141D1A, 0x001F1E10, 0x002F3026, 0x005D6253, 0x005F6651, 0x004E5A3E, 0x00475636, 0x00435432, 0x00495C3B, 0x004B5E3D, 0x004D5A3A, 0x0050603E, 0x0051623D, 0x0053653E, 0x00586B44, 0x00475836, 0x002F4122, 0x00394A2F, 0x003E4F34,
    0x004C5E3F, 0x006A7B59, 0x0072855E, 0x006E8057, 0x006F8158, 0x006F815A, 0x0075835F, 0x0070825D, 0x0070825D, 0x0070825D, 0x0070825D, 0x0070825D, 0x0070825D, 0x0070825D, 0x0070825D, 0x0071855B, 0x0071855B, 0x0071855B, 0x0071855B, 0x0070845A,
    0x006F8359, 0x006E8258, 0x006D8157, 0x004A5B36, 0x00667752, 0x00384924, 0x00455631, 0x005F704B, 0x003F502B, 0x0041522D, 0x0062734E, 0x002F401B, 0x00546540, 0x00556742, 0x002D3F1A, 0x004B603A, 0x00526741, 0x00213812, 0x004D643E, 0x003F5739,
    0x00536442, 0x005B6A44, 0x00445A41, 0x003D625E, 0x00528697, 0x005691AB, 0x004F89A6, 0x00477B8B, 0x00234037, 0x0036422E, 0x00707D75, 0x00748385, 0x00C9D1D0, 0x00D1DCDA, 0x0093A5AC, 0x0089969E, 0x008D9AA2, 0x0087949C, 0x008D9AA2, 0x00909DA5,
    0x008F9CA4, 0x0095A2AA, 0x00919EA6, 0x008B979B, 0x0093A19F, 0x00859692, 0x00808F91, 0x00727E8A, 0x008794A2, 0x00AEBFC2, 0x00C0D5CC, 0x00BCCAB2, 0x00849377, 0x00707F60, 0x00768565, 0x005E6B51, 0xFFA3AB9A, 0xFFFCFFFB, 0xFFFDFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFFFFF8, 0x009DA789, 0x00637148, 0x00808D67, 0x007E8A66, 0x0047552B, 0x00465626, 0x005E6F44, 0x003E4F24, 0x005A6B40, 0x0054653A, 0x0055663B,
    0x00627348, 0x003D4E23, 0x003C4D22, 0x0072845B, 0x00566546, 0x00707A6A, 0x00BBC0BF, 0x00DDE0E5, 0x00E3E5ED, 0x00CED2D3, 0x00C0C5C4, 0x00D8D8DE, 0x00D5D6DA, 0x00D0D2D2, 0x00767A75, 0x006B7166, 0x006C7463, 0x00535C47, 0x00646E57, 0x008D908E,
    0x00737674, 0x00525553, 0x0050544F, 0x00737772, 0x00B5B9B3, 0x00B1B5AF, 0x00494D47, 0x005E6B45, 0x007B8862, 0x007A8761, 0x0072815B, 0x0075845E, 0x0063754E, 0x0052643D, 0x00354720, 0x0050633C, 0x00465932, 0x0043562F, 0x004E613A, 0x003A4D26,
    0x00546740, 0x00667952, 0x0073865F, 0x0072845B, 0x0073855C, 0x0075875E, 0x0076885F, 0x0075875E, 0x0074865D, 0x0074865D, 0x0076885F, 0x0074825E, 0x007E8F6A, 0x004C5B3B, 0x00232D1C, 0x00565D58, 0x004B524F, 0x00192715, 0x00233615, 0x00212E18,
    0x002D3C20, 0x002C3C1D, 0x003D4935, 0x00424B41, 0x003D463C, 0x0019280D, 0x0044582D, 0x004F6339, 0x004C5B3F, 0x00545D53, 0x00B3B8BB, 0x00CBCFD4, 0x00757D76, 0x0048563E, 0x006C7D5B, 0x006A7D56, 0x00637550, 0x006A7A58, 0x005D6B4F, 0x00404D35,
    0x007F8874, 0x006A7162, 0x002C3326, 0x001D1417, 0x00171A1E, 0x00243133, 0x003B4749, 0x00181C1D, 0x001C1915, 0x001B1E15, 0x001B2518, 0x00181C17, 0x00181C17, 0x001B1F1A, 0x002B2D27, 0x002A2E22, 0x00262B16, 0x00323A1C, 0x00333C1B, 0x0030371C,
    0x003A4029, 0x00282B1C, 0x001B1F14, 0x00171B0F, 0x0017210A, 0x0054623E, 0x006B7C50, 0x00525B41, 0x002C351A, 0x001C2707, 0x00242F0E, 0x00303A1C, 0x00333B24, 0x0023271B, 0x00171A11, 0x00151D12, 0x00171913, 0x001A1B19, 0x00192323, 0x00465A5B,
    0x003A4E4F, 0x000F1717, 0x00201A1B, 0x00262822, 0x0051574C, 0x005C6453, 0x004C5941, 0x00455438, 0x00455738, 0x00495D40, 0x00495D40, 0x0047563A, 0x004A593D, 0x004F5E43, 0x00516045, 0x004E5C44, 0x004C5A42, 0x0054624A, 0x005E6B55, 0x005A6954,
    0x0053634C, 0x005B6A4E, 0x006E7F5D, 0x007A8C65, 0x00778962, 0x00748560, 0x007A8864, 0x0075845E, 0x0076855F, 0x00788761, 0x00798862, 0x00788761, 0x00778660, 0x00778660, 0x00778660, 0x00798862, 0x007B8A64, 0x007A8963, 0x00778660, 0x00788761,
    0x0076855F, 0x00687751, 0x0056653F, 0x0063754E, 0x00384A23, 0x0041532C, 0x0060724B, 0x003E5029, 0x0041532C, 0x0063754E, 0x0031431C, 0x004D6137, 0x00596D43, 0x00293C15, 0x0051643D, 0x00576944, 0x00273914, 0x004C5D3B, 0x00516240, 0x0053643F,
    0x00667859, 0x00627352, 0x00475636, 0x00446459, 0x004C859A, 0x004C8CAB, 0x00548BA0, 0x004B798A, 0x001B4038, 0x00334633, 0x00767C77, 0x007A8184, 0x00C5D6D3, 0x00CFE0DD, 0x0097A0A9, 0x007F9198, 0x007C8E95, 0x0083959C, 0x008D9FA6, 0x0092A4AB,
    0x0093A5AC, 0x008D9FA6, 0x0081939A, 0x007E939B, 0x007D8F98, 0x0083959C, 0x007D9095, 0x00798A8D, 0x00808F91, 0x00B4C1C3, 0x00D0DEDD, 0x00A5B596, 0x007E8F6E, 0x00788866, 0x007C8C6A, 0x005D6B4F, 0xFF9FA796, 0xFFFAFEF8, 0xFFFDFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFCFF, 0xFFFCFFF5, 0x0098A284, 0x00606E45, 0x007E8B65, 0x007B8763, 0x0046542A, 0x00435323, 0x00606E44, 0x00505E34, 0x005D6B41, 0x004F5D33, 0x0057653B,
    0x00657349, 0x00414F25, 0x00414F25, 0x006D7F58, 0x004C5B3C, 0x00707A6A, 0x00C7CCCA, 0x00D8DBE0, 0x00D4D7DC, 0x00D6DADB, 0x00D6DBD9, 0x00D3D3D9, 0x00E7E8EC, 0x00C8CACA, 0x00727670, 0x00858C7D, 0x005F6853, 0x004E593F, 0x00727E62, 0x00A8AEA3,
    0x008E9489, 0x006E7469, 0x0072796C, 0x00899083, 0x00ACB3A4, 0x00B7BEAF, 0x008A9182, 0x004B5832, 0x0068754F, 0x00727F59, 0x00778660, 0x007D8C66, 0x005D6F48, 0x00556740, 0x00374922, 0x00546740, 0x003F522B, 0x004A5D36, 0x004B5E37, 0x00364922,
    0x005A6D46, 0x0061744D, 0x00788B64, 0x0074865D, 0x0075875E, 0x0076885F, 0x00778960, 0x0076885F, 0x0075875E, 0x0074865D, 0x0074865D, 0x0073815D, 0x00758760, 0x004C5B3B, 0x00293420, 0x00545B56, 0x004F5653, 0x0022301E, 0x001E3011, 0x00202D17,
    0x001D2C11, 0x002B3A1F, 0x003C4834, 0x004A5349, 0x00343E32, 0x00334226, 0x0055693E, 0x00768A60, 0x005B6A4E, 0x00545E52, 0x00999E9F, 0x00979C9F, 0x00565F55, 0x004A5840, 0x006B7C5A, 0x00667952, 0x00687A55, 0x00657553, 0x00576549, 0x00505D45,
    0x0077806C, 0x00555C4D, 0x001F2619, 0x001C1414, 0x00131817, 0x001C2A29, 0x00333F41, 0x0015191A, 0x001B1716, 0x001A1C16, 0x001A2319, 0x00212520, 0x001D211C, 0x001A1E19, 0x0023251F, 0x001F2317, 0x001F2310, 0x002C3219, 0x002F3718, 0x00262D12,
    0x002D321D, 0x00232519, 0x001B1E15, 0x001E2118, 0x001E2615, 0x004C583C, 0x005B6947, 0x002D3320, 0x001F2611, 0x00232C12, 0x00283117, 0x00252D16, 0x00212716, 0x00191C13, 0x001A1B17, 0x00171E17, 0x00191A16, 0x00191919, 0x00111B1B, 0x003C514F,
    0x00344946, 0x000D1613, 0x001D1914, 0x001B1E15, 0x005E6558, 0x0068715C, 0x00465438, 0x00425233, 0x00485B3A, 0x00445938, 0x003C5131, 0x00485839, 0x004A5A3B, 0x004E5E3F, 0x00505F43, 0x004E5D41, 0x004D5C41, 0x00536247, 0x005B6A4F, 0x0051614A,
    0x0047583D, 0x00455635, 0x004C5E39, 0x00506239, 0x004C5E35, 0x004B5D36, 0x00515F3B, 0x00576640, 0x00586741, 0x00596842, 0x00596842, 0x00576640, 0x00576640, 0x00586741, 0x005A6943, 0x00576640, 0x00576640, 0x0052613B, 0x004F5E38, 0x0054633D,
    0x005B6A44, 0x00596842, 0x0051603A, 0x003B4D26, 0x00455730, 0x0062744D, 0x00354720, 0x0040522B, 0x0064764F, 0x00384A23, 0x0042542D, 0x00596D43, 0x0030441A, 0x00546740, 0x004C5F38, 0x0031431E, 0x00546641, 0x00526341, 0x0030411F, 0x0053643F,
    0x00566849, 0x004B5C3B, 0x00394828, 0x003D5D52, 0x00478095, 0x004A8AA9, 0x005A91A6, 0x004A7889, 0x001A3F37, 0x00334633, 0x00757B76, 0x007A8184, 0x00C5D6D3, 0x00CEDFDC, 0x0097A0A9, 0x0074868D, 0x006F8188, 0x0076888F, 0x0084969D, 0x008EA0A7,
    0x0090A2A9, 0x0085979E, 0x0074868D, 0x00798B94, 0x007B8D96, 0x007F9198, 0x0079898F, 0x00778689, 0x00829193, 0x00B4C1C3, 0x00CCD8D8, 0x00829273, 0x006A7B5A, 0x006D7D5B, 0x00778765, 0x005F6D51, 0xFFA3AB9A, 0xFFFDFFFB, 0xFFFDFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFEFFF7, 0x0098A284, 0x0065734A, 0x0083906A, 0x007D8965, 0x0049572D, 0x00415121, 0x007A845A, 0x00687248, 0x00596339, 0x004D572D, 0x00646E44,
    0x00697349, 0x00424C22, 0x003E481E, 0x006E7E5C, 0x00455238, 0x00596353, 0x00C0C6C1, 0x00E4E8E9, 0x00DADEDF, 0x00D4D9D7, 0x00D4DAD5, 0x00D7D8DC, 0x00E3E5E6, 0x00C0C4BF, 0x00697063, 0x00747D69, 0x00495539, 0x005D6B49, 0x0053613D, 0x005D6750,
    0x00545E47, 0x00465039, 0x00535E44, 0x005C674D, 0x00566246, 0x005B674B, 0x00566246, 0x00596640, 0x004A5731, 0x0075825C, 0x0073825C, 0x0074835D, 0x0061734C, 0x004E6039, 0x00354720, 0x004F613A, 0x0042542D, 0x00495B34, 0x0052643D, 0x003D4F28,
    0x00566841, 0x00687A53, 0x00758760, 0x0073855C, 0x0074865D, 0x0075875E, 0x0075875E, 0x0075875E, 0x0075875E, 0x0074865D, 0x0072845B, 0x0073815D, 0x007F916A, 0x00455533, 0x001E2A14, 0x005B635C, 0x0059605D, 0x00253222, 0x001A2C0F, 0x0027341E,
    0x00223018, 0x0028351F, 0x00424D3D, 0x00495347, 0x00253020, 0x00233216, 0x006A7E54, 0x0071855B, 0x00687859, 0x00566151, 0x00888F8C, 0x00909794, 0x004C564A, 0x003E4D32, 0x006E805B, 0x006C7F58, 0x00657752, 0x005C6C4A, 0x00576549, 0x006C7961,
    0x00838C78, 0x00676E5F, 0x00333A2D, 0x00211C13, 0x00121912, 0x00152420, 0x002C3838, 0x00131718, 0x001C1719, 0x001A1B19, 0x001B221D, 0x001A1E18, 0x00191D17, 0x00181C17, 0x001D1F19, 0x001A1E13, 0x001D2011, 0x00292E19, 0x002A3017, 0x002B3118,
    0x002C301D, 0x0027281E, 0x001D1E1A, 0x001F201C, 0x00181D14, 0x002B3223, 0x002E3723, 0x001F2318, 0x001C2015, 0x00262A1E, 0x0024281C, 0x001A1E13, 0x00151711, 0x00151614, 0x001C1B1D, 0x00181D1C, 0x001C1C1C, 0x001B1A1C, 0x000E171A, 0x00344947,
    0x002F463E, 0x000C170D, 0x001D1B10, 0x0025291D, 0x007B8372, 0x0088927B, 0x005B6A4B, 0x004D5E3C, 0x004F643E, 0x004F6542, 0x00536946, 0x00526341, 0x00526341, 0x00546543, 0x00556645, 0x00556645, 0x00556546, 0x0059694A, 0x005E6E4F, 0x00637459,
    0x005C6E4F, 0x00576944, 0x0055693F, 0x0056693E, 0x0055683D, 0x0056683F, 0x005C6B45, 0x005B6945, 0x005C6A46, 0x005B6945, 0x005A6844, 0x00596743, 0x00596743, 0x005B6945, 0x005D6B47, 0x00586642, 0x005D6B47, 0x005F6D49, 0x005E6C48, 0x005F6D49,
    0x005E6C48, 0x00566440, 0x004B5935, 0x0042542D, 0x0063754E, 0x00394B24, 0x00485A33, 0x00596B44, 0x003D4F28, 0x0053653E, 0x005D6F48, 0x003B4F25, 0x0045592F, 0x00566942, 0x003B4E27, 0x004A5C37, 0x00536540, 0x002B3C1A, 0x00495A38, 0x00596A45,
    0x00506243, 0x00465736, 0x00425131, 0x004C6C61, 0x004D869B, 0x004A8AA9, 0x005A91A6, 0x00497788, 0x001A3F37, 0x00314431, 0x00747A75, 0x007A8184, 0x00C6D7D4, 0x00CEDFDC, 0x0097A0A9, 0x00778990, 0x006F8188, 0x0073858C, 0x0081939A, 0x008D9FA6,
    0x0091A3AA, 0x008799A0, 0x0076888F, 0x00778992, 0x007C8F96, 0x0084969D, 0x007F8F95, 0x007C8B8E, 0x00919EA0, 0x00BECCCB, 0x00C8D4D4, 0x0079896A, 0x00718261, 0x00748462, 0x007A8A68, 0x00637155, 0xFFA4AC9B, 0xFFF9FDF7, 0xFFFBFDFE, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFFFFF8, 0x0097A183, 0x0066744B, 0x00808D67, 0x0074805C, 0x00435127, 0x00374717, 0x00434C24, 0x003C451D, 0x00343D15, 0x00363F17, 0x00454E26,
    0x003C451D, 0x002F3810, 0x00434C24, 0x00758465, 0x005D6A50, 0x00596352, 0x00B2BAAF, 0x00EBF2EB, 0x00E2E9E2, 0x00D6DED4, 0x00DDE5DA, 0x00E1E4E2, 0x00F4F8F3, 0x00C4CABF, 0x006A735F, 0x00939E84, 0x00667452, 0x007C8C63, 0x006D7E53, 0x006F7D5B,
    0x0073815F, 0x006C7A56, 0x0072805C, 0x0074835D, 0x00697852, 0x006A7953, 0x006C7C53, 0x0055623C, 0x00606D47, 0x0053603A, 0x005F6E48, 0x0085946E, 0x005A6C45, 0x00586A43, 0x00374922, 0x0050623B, 0x003F512A, 0x004C5E37, 0x004F613A, 0x003C4E27,
    0x00576942, 0x00667851, 0x00768861, 0x0072845B, 0x0073855C, 0x0073855C, 0x0072845B, 0x0073855C, 0x0075875E, 0x0075875E, 0x0073855C, 0x00778561, 0x0073855E, 0x0062734E, 0x0025321A, 0x00636C62, 0x00838A87, 0x002B372B, 0x001D2D16, 0x00202D17,
    0x00323E2A, 0x00121D0D, 0x00606A5D, 0x00535D50, 0x00323E2A, 0x002D3D1E, 0x005A6D46, 0x006A7E53, 0x006C7D5C, 0x0065715D, 0x00A3ACA2, 0x00B6BFB5, 0x00606C5A, 0x00445337, 0x00788A65, 0x00586B44, 0x00475934, 0x00465634, 0x00465438, 0x005E6B53,
    0x006F7864, 0x006C7364, 0x003E4538, 0x00373426, 0x00232B20, 0x001E2F26, 0x00323F3D, 0x001A1E1F, 0x00211C1E, 0x001D1C1E, 0x001E2423, 0x001A2015, 0x001C2118, 0x0021251F, 0x00262723, 0x0023251F, 0x0025261C, 0x00282B1B, 0x00232714, 0x00262B16,
    0x00232617, 0x0026271E, 0x001B1C1A, 0x001D1D1D, 0x00141616, 0x00171A18, 0x00161A15, 0x001C1D1B, 0x00161715, 0x00191A18, 0x00181917, 0x00191919, 0x001D1C1E, 0x0019181C, 0x001B191F, 0x00121617, 0x00161519, 0x001E1D21, 0x00182124, 0x003E5350,
    0x00395147, 0x00202D1F, 0x003B3B2B, 0x002F3425, 0x00616A56, 0x00616D51, 0x00475735, 0x00475934, 0x00455A33, 0x00415931, 0x00455C36, 0x004D6039, 0x004C5F38, 0x004D5F3A, 0x004E603B, 0x004F613C, 0x004F603E, 0x00516240, 0x00536442, 0x004D5F40,
    0x004D613E, 0x004F623B, 0x004E6237, 0x004F6336, 0x00506338, 0x0051633A, 0x0053623C, 0x0052633E, 0x0052633E, 0x0053643F, 0x0051623D, 0x0050613C, 0x0050613C, 0x0051623D, 0x0053643F, 0x0052633E, 0x00556641, 0x00566742, 0x0053643F, 0x0052633E,
    0x0052633E, 0x004F603B, 0x004A5B36, 0x00596B44, 0x003F512A, 0x004A5C35, 0x005D6F48, 0x003C4E27, 0x0040522B, 0x005F714A, 0x00394B24, 0x004C6036, 0x005A6E44, 0x0031441D, 0x004B5E37, 0x00566843, 0x00354722, 0x004F603E, 0x00576846, 0x004F603B,
    0x00455738, 0x00415231, 0x00455434, 0x00507065, 0x004E879C, 0x004989A8, 0x00568DA2, 0x00487687, 0x001B4038, 0x00304330, 0x00737974, 0x007B8285, 0x00C6D7D4, 0x00CDDEDB, 0x0098A1AA, 0x0085979E, 0x007D8F96, 0x007D8F96, 0x0083959C, 0x00899BA2,
    0x008FA1A8, 0x008FA1A8, 0x008799A0, 0x0084979E, 0x0085979E, 0x0090A0A6, 0x0088999C, 0x00758486, 0x008D9B9A, 0x00B5C1C1, 0x00AAB7B5, 0x006F7F60, 0x00738463, 0x00748462, 0x00758563, 0x005F6D51, 0xFFA1A998, 0xFFF9FDF7, 0xFFFDFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFCFF, 0xFFFDFFF6, 0x00909A7C, 0x00647249, 0x00818E68, 0x007A8662, 0x005B693F, 0x00546434, 0x00515A32, 0x004E572F, 0x004B542C, 0x00505931, 0x00515A32,
    0x00454E26, 0x00464F27, 0x00576038, 0x007B8A6B, 0x007D8B6F, 0x006F7C64, 0x00929D89, 0x00A0AA99, 0x00939D8C, 0x0095A08C, 0x00A9B4A0, 0x00959C8D, 0x00939B8A, 0x00818A75, 0x00505B41, 0x007C8969, 0x005D6C46, 0x0078895E, 0x0075865A, 0x0076875C,
    0x00798A5F, 0x0077885D, 0x0077885C, 0x0075865A, 0x0075865A, 0x007A8C5D, 0x00788A5B, 0x006D7A54, 0x0053603A, 0x005B6842, 0x00586741, 0x006A7953, 0x005F714A, 0x00586A43, 0x0033451E, 0x00566841, 0x003C4E27, 0x0053653E, 0x00475932, 0x00394B24,
    0x005A6C45, 0x005B6D46, 0x00778962, 0x0075875E, 0x00778960, 0x0076885F, 0x0073855C, 0x0073855C, 0x0076885F, 0x0076885F, 0x0073855C, 0x007B8967, 0x00708259, 0x004F6138, 0x00324024, 0x00778175, 0x00A5ACA9, 0x00667167, 0x00162412, 0x0023301A,
    0x00162111, 0x003C453B, 0x008F988E, 0x006D7868, 0x004D5B43, 0x002D3E1D, 0x006A7C57, 0x0075895E, 0x006D7F5A, 0x004C5B40, 0x00475341, 0x00455040, 0x003D4A34, 0x00586948, 0x00647750, 0x00475A33, 0x00435530, 0x004B5B39, 0x0048563A, 0x005C6951,
    0x00646D59, 0x00666D5E, 0x00444B3E, 0x003F3C2D, 0x002A3326, 0x00213229, 0x00313F3B, 0x00181C1D, 0x001C1719, 0x00161616, 0x00191F1E, 0x001B2215, 0x00191F14, 0x001E221C, 0x0022231F, 0x0020211D, 0x00262620, 0x0026271D, 0x00222418, 0x001E2014,
    0x001C1D13, 0x0025251F, 0x001A1B19, 0x001D1C1E, 0x00151718, 0x00161819, 0x00161819, 0x001C1C1C, 0x00151416, 0x00151416, 0x00151418, 0x001B1A1E, 0x001D1C20, 0x00151418, 0x00151416, 0x00191D1E, 0x00161517, 0x001D1C20, 0x001B2525, 0x003B514C,
    0x002F473B, 0x001C2919, 0x0040402E, 0x00383D2E, 0x00515A46, 0x004F5B3F, 0x00465634, 0x00495B36, 0x00465B34, 0x00445C34, 0x00475E38, 0x00495C35, 0x00495C35, 0x00485B34, 0x00495B36, 0x004A5C37, 0x004C5E39, 0x004D5E3C, 0x004C5D3B, 0x00495C3B,
    0x004D613E, 0x0051643D, 0x0051653A, 0x00516439, 0x0051633A, 0x0050613C, 0x00505E3C, 0x00556543, 0x00566644, 0x00576745, 0x00576745, 0x00566644, 0x00546442, 0x00546442, 0x00556543, 0x00576745, 0x00586846, 0x00566644, 0x00526240, 0x0051613F,
    0x00546442, 0x00576745, 0x00596947, 0x0050623B, 0x00394B24, 0x005D6F48, 0x003E5029, 0x0043552E, 0x0062744D, 0x0034461F, 0x0043552E, 0x0054683E, 0x00384C22, 0x0052653E, 0x004E613A, 0x00364823, 0x004A5C37, 0x00566745, 0x00546543, 0x00697A55,
    0x005F7152, 0x00556645, 0x004C5B3B, 0x004C6C61, 0x004C859A, 0x004A8AA9, 0x00548BA0, 0x00497788, 0x001C4139, 0x00304330, 0x00727873, 0x007D8487, 0x00C7D8D5, 0x00CCDDDA, 0x0097A0A9, 0x008A9CA3, 0x0086989F, 0x008799A0, 0x008799A0, 0x0084969D,
    0x00889AA1, 0x008FA1A8, 0x0090A2A9, 0x0091A3AA, 0x00879A9F, 0x0093A3A9, 0x008F9EA1, 0x006F7C7E, 0x008B9797, 0x00B4C1BF, 0x00A0ABA9, 0x006A7A5B, 0x00748564, 0x00738361, 0x00738361, 0x005F6D51, 0xFFA2AA99, 0xFFFCFFFA, 0xFFFDFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFCFF, 0xFFFDFFF6, 0x008C9678, 0x0065734A, 0x0083906A, 0x0085916D, 0x007A885E, 0x007C8C5C, 0x00829067, 0x007D8B62, 0x0079875E, 0x007A885F, 0x007D8B62,
    0x007E8C63, 0x007D8B62, 0x0077855C, 0x00707F5F, 0x00758464, 0x006E7D5D, 0x00788768, 0x006C7B5C, 0x006B7A5B, 0x00758465, 0x007A896A, 0x00788466, 0x00687456, 0x007B8868, 0x00687654, 0x006C7B55, 0x00697950, 0x0085966B, 0x0074855A, 0x0076875C,
    0x0075865B, 0x00798A5E, 0x007C8D61, 0x00768859, 0x00738556, 0x00768859, 0x00768958, 0x007B8862, 0x00707D57, 0x0057643E, 0x005B6A44, 0x0051603A, 0x0041532C, 0x0062744D, 0x00354720, 0x004C5B35, 0x004E5D37, 0x00495832, 0x0052613B, 0x004C5B35,
    0x004D5C36, 0x00606F49, 0x0064734D, 0x0074865D, 0x007A8C63, 0x007B8D64, 0x00778960, 0x0075875E, 0x00778960, 0x00778960, 0x0073855C, 0x0072805E, 0x008A9C73, 0x005D7045, 0x00314020, 0x006B7568, 0x00A4ABA8, 0x00AAB4AE, 0x008A968A, 0x0066735D,
    0x00717B6E, 0x00A6ADAA, 0x00A1A8A3, 0x00919C8C, 0x00657458, 0x00415230, 0x0070815F, 0x006C8154, 0x0070835C, 0x00485839, 0x002B3921, 0x002A3721, 0x002F3E22, 0x00495A38, 0x00475A33, 0x00475A33, 0x004C5E39, 0x004D5D3B, 0x00475539, 0x006B7860,
    0x00737C68, 0x00545B4C, 0x002A3124, 0x002F2B20, 0x001F271C, 0x001A2A23, 0x002E3C38, 0x00171C1B, 0x001B1716, 0x00181915, 0x00222A23, 0x002E3526, 0x0020271A, 0x001B1F19, 0x00181917, 0x00161616, 0x001F1D1C, 0x0021201C, 0x0022221C, 0x0021201C,
    0x00201F1B, 0x00272622, 0x001C1D1B, 0x001E1E1E, 0x00151717, 0x00181A1A, 0x00191B1C, 0x001C1D1B, 0x001B1B1B, 0x001D1C1E, 0x0019181C, 0x0018171B, 0x0019181A, 0x001C1D1B, 0x002C2D29, 0x00202621, 0x00131412, 0x00161616, 0x0016211F, 0x00354B46,
    0x00284036, 0x00172416, 0x003D3C2E, 0x002F3327, 0x00555D4C, 0x005E6851, 0x004F5E3F, 0x00485937, 0x00475C36, 0x004C623F, 0x004E6441, 0x0051643D, 0x0052643F, 0x0051633E, 0x0051633E, 0x00536442, 0x00566745, 0x00556645, 0x00536443, 0x00546647,
    0x00566948, 0x00586A45, 0x00586B44, 0x00596B44, 0x00596A45, 0x00586747, 0x005A664A, 0x00576745, 0x00596947, 0x005A6A48, 0x005A6A48, 0x00586846, 0x00576745, 0x00566644, 0x00566644, 0x00576745, 0x005A6A48, 0x005C6C4A, 0x005B6B49, 0x00596947,
    0x00576745, 0x00556543, 0x00536341, 0x0053653E, 0x0064764F, 0x003B4D26, 0x0044562F, 0x005F714A, 0x0043552E, 0x00455730, 0x005D6F48, 0x00364A20, 0x00495D33, 0x005D7049, 0x00394C25, 0x00445631, 0x005C6E49, 0x00465735, 0x006C7D5B, 0x006C7D58,
    0x00667859, 0x005C6D4C, 0x00495838, 0x00446459, 0x004B8499, 0x004E8EAD, 0x00558CA1, 0x004B798A, 0x001F443C, 0x00314431, 0x00727873, 0x007E8588, 0x00C8D9D6, 0x00CBDCD9, 0x0097A0A9, 0x0086989F, 0x0086989F, 0x008B9DA4, 0x008D9FA6, 0x00899BA2,
    0x00899BA2, 0x008D9FA6, 0x008B9DA4, 0x008EA1A6, 0x0084949A, 0x008B9C9F, 0x008C9B9D, 0x006F7D7C, 0x008D9999, 0x00B7C2C0, 0x00A7B2B0, 0x006D7D5E, 0x00788968, 0x00768664, 0x00788866, 0x00616F53, 0xFFA1A998, 0xFFFBFFF9, 0xFFFAFCFD, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFFFFF8, 0x008E987A, 0x0065734A, 0x007C8963, 0x007B8763, 0x0078865C, 0x007D8D5D, 0x0073855E, 0x007A8C65, 0x007F916A, 0x00788A63, 0x0073855E,
    0x0074865F, 0x00778962, 0x00798B64, 0x007D8D6B, 0x00798A65, 0x00768861, 0x00809269, 0x007C8F64, 0x0084976C, 0x0081936A, 0x00798B62, 0x007A8B5F, 0x008A9B6F, 0x0088996E, 0x00798A5F, 0x007B8B62, 0x007C8C63, 0x0073825C, 0x0075845E, 0x007D8D64,
    0x00798960, 0x0077885D, 0x0076875C, 0x00748559, 0x00708155, 0x00718256, 0x00788A5B, 0x0074815B, 0x00818E68, 0x006B7852, 0x004C5B35, 0x00576640, 0x0054663F, 0x003A4C25, 0x005B6D46, 0x0045542E, 0x0055643E, 0x0046552F, 0x0056653F, 0x00576640,
    0x00485731, 0x00596842, 0x0055643E, 0x0066784F, 0x0071835A, 0x00788A61, 0x0076885F, 0x0075875E, 0x00788A61, 0x00778960, 0x0074865D, 0x00758361, 0x006F8158, 0x0074885B, 0x00344422, 0x005F6A5A, 0x00A7AEAB, 0x00868F8C, 0x00828D85, 0x0097A48E,
    0x0098A197, 0x0084898A, 0x00A2A9A6, 0x009CA896, 0x00354625, 0x00556644, 0x007A8B6A, 0x00718659, 0x00697D53, 0x00566745, 0x00667559, 0x006C7B5F, 0x00364627, 0x00374924, 0x0050633C, 0x0042552E, 0x0042542F, 0x00425230, 0x00455337, 0x0078856D,
    0x0099A28E, 0x00686F60, 0x002C3326, 0x00231D18, 0x00191F1A, 0x001B2A26, 0x00323F3D, 0x001D2220, 0x00221F1A, 0x0022261B, 0x00313B2E, 0x00454D3C, 0x002D3427, 0x0022271E, 0x001C1D1B, 0x00181719, 0x001D1A1C, 0x001B1919, 0x001D1B1A, 0x001D1A1C,
    0x001D1A1C, 0x00201E1D, 0x001A1B17, 0x001F201C, 0x00171B16, 0x001E221D, 0x001C201B, 0x00171A11, 0x00181915, 0x001D1D1D, 0x0019181A, 0x00181719, 0x001C1D19, 0x002B2E25, 0x004B4F43, 0x00323A2F, 0x001E2118, 0x001B1C18, 0x001A2522, 0x003B514C,
    0x002E453D, 0x00121D15, 0x002C2A20, 0x002F3229, 0x005E6558, 0x00616A55, 0x0049573B, 0x004B5B3C, 0x00506342, 0x004D6241, 0x00465B3B, 0x0050613F, 0x00526341, 0x00526341, 0x00516241, 0x00526342, 0x00566647, 0x00556546, 0x00526243, 0x00536548,
    0x00516344, 0x00536443, 0x00556644, 0x00576745, 0x00576647, 0x0058654B, 0x005C6550, 0x00556644, 0x00566745, 0x00576846, 0x00566745, 0x00546543, 0x00536442, 0x00536442, 0x00546543, 0x00546543, 0x00556644, 0x00566745, 0x00566745, 0x00566745,
    0x00566745, 0x00576846, 0x00586947, 0x005F714A, 0x005B6D46, 0x004B5D36, 0x00596B44, 0x0040522B, 0x003B4D26, 0x0061734C, 0x00384A23, 0x004C6036, 0x0061754B, 0x0033461F, 0x00465932, 0x00566843, 0x004B5D38, 0x00748563, 0x006B7C5A, 0x006D7E59,
    0x00697B5C, 0x005F704F, 0x004B5A3A, 0x0045655A, 0x004E879C, 0x005191B0, 0x00548BA0, 0x004D7B8C, 0x0021463E, 0x00324532, 0x00727873, 0x007F8689, 0x00C8D9D6, 0x00CADBD8, 0x00969FA8, 0x007F9198, 0x007C8E95, 0x0083959C, 0x008D9FA6, 0x0090A2A9,
    0x0090A2A9, 0x008B9DA4, 0x00809299, 0x00839399, 0x00809096, 0x00829194, 0x00859294, 0x006F7B7B, 0x00828D8B, 0x009DA8A6, 0x009BA4A1, 0x0069795A, 0x00708160, 0x006E7E5C, 0x00748462, 0x005E6C50, 0xFF9EA695, 0xFFFCFFFA, 0xFFF8FAFB, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBF9FF, 0xFFFFFFF8, 0x00909A7C, 0x006A784F, 0x00808D67, 0x007B8763, 0x007B895F, 0x007F8F5F, 0x00788B64, 0x00788B64, 0x00798C65, 0x00798C65, 0x007C8F68,
    0x00798C65, 0x00758861, 0x007F926B, 0x00768762, 0x007A8C63, 0x00728659, 0x00728657, 0x006F8453, 0x006E8352, 0x00617546, 0x006A7E4F, 0x00677B46, 0x00617540, 0x00627544, 0x007D8F60, 0x006F8055, 0x00798862, 0x00778561, 0x007A8866, 0x00778660,
    0x00798862, 0x0074835D, 0x00718158, 0x00798960, 0x00798A5F, 0x00728358, 0x0077885D, 0x007D8A64, 0x0074815B, 0x007E8B65, 0x0074835D, 0x0054633D, 0x00576942, 0x0044562F, 0x004B5D36, 0x0056653F, 0x0042512B, 0x005C6B45, 0x0043522C, 0x00495832,
    0x005D6C46, 0x003D4C26, 0x00606F49, 0x0054663D, 0x0063754C, 0x00708259, 0x0073855C, 0x0074865D, 0x00778960, 0x00788A61, 0x0074865D, 0x00768462, 0x00798B62, 0x007D9164, 0x005A6A48, 0x00313D2B, 0x005B625F, 0x00A7AFAE, 0x0086908A, 0x00818E78,
    0x008D968C, 0x00ABB0B3, 0x008B9190, 0x003C4836, 0x00425332, 0x0071835E, 0x00758665, 0x006D8255, 0x0071855B, 0x00738560, 0x00708160, 0x005E6E4F, 0x00495A39, 0x00586A45, 0x0041552B, 0x004F623B, 0x00455732, 0x004A5A38, 0x0049573B, 0x0066735B,
    0x00969F8B, 0x00697061, 0x0021281B, 0x001C1414, 0x00151A18, 0x00182624, 0x002F3C3A, 0x00171D18, 0x0017150D, 0x00171C0D, 0x00293521, 0x002F3824, 0x00181F10, 0x00141910, 0x00171816, 0x0019181A, 0x001F1B20, 0x00191618, 0x001B1919, 0x001E1A20,
    0x001D191E, 0x001C1A1A, 0x00171814, 0x001E2118, 0x0013180F, 0x001A1F16, 0x0013180F, 0x001C2014, 0x001A1D14, 0x001D1E1A, 0x001B1B1B, 0x001A1B19, 0x00191C13, 0x00212617, 0x003E4431, 0x00273121, 0x0014180C, 0x0012140E, 0x00141F1C, 0x003C514E,
    0x00324843, 0x000E1812, 0x00191510, 0x002A2C26, 0x00696F64, 0x006A7261, 0x0048553D, 0x00465539, 0x00485A3B, 0x00465A3D, 0x004B5F42, 0x004C5D3C, 0x004E5F3E, 0x004F603F, 0x004E5E3F, 0x004F5F40, 0x00536246, 0x00526145, 0x004F5E42, 0x00506146,
    0x004D5F42, 0x004F5F40, 0x00536443, 0x00566546, 0x00546147, 0x00535F49, 0x0057604C, 0x00546544, 0x00546544, 0x00536443, 0x00526342, 0x00506140, 0x004F603F, 0x00506140, 0x00526342, 0x00546544, 0x00546544, 0x00546544, 0x00556645, 0x00546544,
    0x00536443, 0x00536443, 0x00546544, 0x0053653E, 0x0054663F, 0x00596B44, 0x003C4E27, 0x00485A33, 0x005A6C45, 0x003C4E27, 0x00475932, 0x0063774D, 0x002A3E14, 0x0052653E, 0x00586B44, 0x00394B26, 0x00546641, 0x00617250, 0x00596A48, 0x00596A45,
    0x00526445, 0x00495A39, 0x00394828, 0x0039594E, 0x00488196, 0x004F8FAE, 0x00548BA0, 0x004E7C8D, 0x00234840, 0x00324532, 0x00727873, 0x0080878A, 0x00C9DAD7, 0x00CADBD8, 0x00969FA8, 0x00778990, 0x00708289, 0x0074868D, 0x0083959C, 0x0090A2A9,
    0x0093A5AC, 0x008799A0, 0x0074868D, 0x0076868C, 0x007F9093, 0x007E8D90, 0x00869395, 0x007A8686, 0x00838E8C, 0x008F9A97, 0x0097A09D, 0x00748465, 0x00758665, 0x0070805E, 0x00778765, 0x005F6D51, 0xFFA1A998, 0xFFFDFFFB, 0xFFFDFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFCFF, 0xFFFFFFF7, 0x008E9979, 0x00637147, 0x007D8B62, 0x00818E68, 0x005C6B3F, 0x005B6C39, 0x005E6A40, 0x00626E44, 0x00636F45, 0x00616D43, 0x005D693F,
    0x005D693F, 0x00606C42, 0x00626E44, 0x006F7F5D, 0x004A593A, 0x0048553D, 0x005C6753, 0x0049553F, 0x00354327, 0x0032431E, 0x0036491E, 0x002B3820, 0x00313E24, 0x0039472B, 0x003A4727, 0x00475531, 0x0053603A, 0x0078865D, 0x007E8C62, 0x00768C5C,
    0x0074895C, 0x00708558, 0x007A8E61, 0x00778A5F, 0x006E7F54, 0x0076865D, 0x0077875E, 0x0075855C, 0x0078885F, 0x00708057, 0x007A8A61, 0x006B7B52, 0x0056663D, 0x005A6A41, 0x0047572E, 0x0051603A, 0x0055643E, 0x00404F29, 0x005E6D47, 0x00475630,
    0x004C5B35, 0x005D6C46, 0x003C4B25, 0x0066754F, 0x004A5933, 0x0064734D, 0x007F8E68, 0x0073825C, 0x007A8963, 0x0072815B, 0x00788761, 0x007A8B60, 0x0074845B, 0x007B8B62, 0x007C8C63, 0x005A6943, 0x0034431D, 0x0042502C, 0x006D7B57, 0x00778464,
    0x00748161, 0x0053613F, 0x00354321, 0x00465430, 0x006E7C58, 0x007C8A66, 0x0075835F, 0x00708057, 0x0073835A, 0x00798960, 0x00607047, 0x00495930, 0x005E6E45, 0x004A5A31, 0x0054643B, 0x0045542E, 0x00495733, 0x00495735, 0x004C583A, 0x005D684E,
    0x00727B66, 0x006D7564, 0x00343C2B, 0x00111614, 0x001A1F1E, 0x0025292A, 0x002E3135, 0x00141819, 0x001A1F1D, 0x00111811, 0x00171F14, 0x00181917, 0x00191A18, 0x001A1B19, 0x001A1B19, 0x00191A18, 0x00191A18, 0x00191A18, 0x00191A18, 0x00181818,
    0x00191919, 0x00191919, 0x001A1A1A, 0x001A1A1A, 0x00191919, 0x00181818, 0x00181818, 0x001A1B17, 0x001B1C18, 0x001C1D1B, 0x001B1C1A, 0x001A1A1A, 0x0019181A, 0x0019181A, 0x0019181A, 0x001A1817, 0x00141414, 0x0015161A, 0x0014171C, 0x0032393C,
    0x002F3939, 0x0015231F, 0x00091912, 0x001F251A, 0x00686F60, 0x007C8570, 0x005A684C, 0x00526141, 0x00576745, 0x00516240, 0x00516241, 0x00576745, 0x00556543, 0x00546442, 0x005B6B49, 0x005F6F4D, 0x005E6E4C, 0x005F6F4D, 0x005E6E4C, 0x005B6C47,
    0x005B6C47, 0x005A6B46, 0x00596A45, 0x00596A45, 0x00586944, 0x00576843, 0x00576843, 0x00576944, 0x00576944, 0x00576944, 0x00576944, 0x00576944, 0x00576944, 0x00576944, 0x00576944, 0x00596A45, 0x00596A45, 0x00596A45, 0x00586944, 0x00586944,
    0x00586944, 0x00586944, 0x00576843, 0x005B6D48, 0x00556742, 0x005A6C47, 0x005F714C, 0x0051633E, 0x003E502B, 0x00475934, 0x0060724D, 0x0031431E, 0x00536540, 0x00566843, 0x003B4D28, 0x00485A35, 0x005C6E49, 0x00546641, 0x00556742, 0x00566343,
    0x004B5D40, 0x00455435, 0x00485436, 0x0057746B, 0x004C8299, 0x00508DAF, 0x00558BA2, 0x00497789, 0x001D423A, 0x002F4130, 0x00717772, 0x0080868B, 0x00CBDBDA, 0x00CCDCDB, 0x00949DA7, 0x0074868D, 0x006F8188, 0x006D7F86, 0x007A8C93, 0x008A9CA3,
    0x008EA0A7, 0x0086989F, 0x007A8C93, 0x00798C93, 0x0075888F, 0x00809398, 0x00809096, 0x0079888B, 0x00879397, 0x00A6B3B5, 0x00C9D5D7, 0x007E8A78, 0x006C7A62, 0x00798868, 0x00778863, 0x005F6E4E, 0xFF9EA792, 0xFFFCFFFA, 0xFFFDFEFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF9F7FD, 0xFFFFFFF7, 0x008E9979, 0x0067754B, 0x00818F66, 0x0078855F, 0x00435226, 0x003C4D1A, 0x0039451B, 0x003C481E, 0x002B370D, 0x00313D13, 0x00414D23,
    0x00354117, 0x00323E14, 0x00414D23, 0x006E7C60, 0x0054604A, 0x00596255, 0x00929992, 0x00A7AEA7, 0x00A7AFA4, 0x00A4AF9B, 0x00AAB79F, 0x00A7B1A0, 0x00B0BBA7, 0x008C9882, 0x00465137, 0x004C583A, 0x00505B3B, 0x007B8763, 0x0078855F, 0x0075895E,
    0x007A8E63, 0x00778B60, 0x00788B60, 0x00798D60, 0x007A8B5F, 0x007B8C60, 0x0078895D, 0x0075855C, 0x0077875E, 0x0073835A, 0x007B8B62, 0x00798960, 0x005F6F46, 0x0056663D, 0x00607047, 0x0041502A, 0x004F5E38, 0x0061704A, 0x003A4923, 0x0063724C,
    0x0045542E, 0x004F5E38, 0x0062714B, 0x00374620, 0x00687751, 0x0054633D, 0x0064734D, 0x0086956F, 0x006D7C56, 0x007E8D67, 0x00778660, 0x0078895E, 0x00728259, 0x00728259, 0x007A8A61, 0x00778660, 0x0061704A, 0x00465430, 0x00364420, 0x00293616,
    0x00384525, 0x00485634, 0x005C6A48, 0x00768460, 0x0083916D, 0x007E8C68, 0x00778660, 0x0078885F, 0x006E7E55, 0x006A7A51, 0x004D5D34, 0x005E6E45, 0x0045552C, 0x00596940, 0x0046562D, 0x0053623C, 0x0053623C, 0x00495735, 0x005F6C4C, 0x00515D41,
    0x006B755E, 0x006F7864, 0x00212A16, 0x00151A18, 0x000E1312, 0x00292D2E, 0x003C3F43, 0x000E1115, 0x00121716, 0x00171D18, 0x00161E14, 0x00171A18, 0x00181B19, 0x00181B19, 0x00181B19, 0x00171A18, 0x00171A18, 0x00181B19, 0x00181B19, 0x00181A1A,
    0x00181A1A, 0x00181A1A, 0x00181A1A, 0x00171919, 0x00171919, 0x00171919, 0x00171919, 0x00161917, 0x00171A18, 0x00181A1A, 0x00181A1A, 0x0017191A, 0x0017191A, 0x0018191D, 0x00191A1E, 0x00171919, 0x00181C1D, 0x0015181C, 0x00212429, 0x0051555A,
    0x00384040, 0x000B1411, 0x00131E16, 0x00252C1F, 0x00697160, 0x0078826B, 0x00526142, 0x00485836, 0x004F5F3D, 0x004C5D3B, 0x004C5D3C, 0x004E5E3C, 0x00465634, 0x004E5E3C, 0x00566644, 0x004D5D3B, 0x004D5D3B, 0x00546442, 0x004D5D3B, 0x00546540,
    0x00546540, 0x0053643F, 0x0053643F, 0x0052633E, 0x0051623D, 0x0051623D, 0x0051623D, 0x0051633E, 0x0051633E, 0x0051633E, 0x0051633E, 0x0051633E, 0x0051633E, 0x0051633E, 0x0051633E, 0x00556641, 0x00556641, 0x00556641, 0x00546540, 0x00546540,
    0x00546540, 0x00546540, 0x00546540, 0x0050623D, 0x00566843, 0x00566843, 0x0052643F, 0x00536540, 0x00556742, 0x004B5D38, 0x003A4C27, 0x004C5E39, 0x00586A45, 0x003C4E29, 0x00485A35, 0x005E704B, 0x004D5F3A, 0x004E603B, 0x00546641, 0x0053613F,
    0x004A5C3F, 0x00475637, 0x00465234, 0x00516E65, 0x004B8198, 0x00528FB1, 0x00558BA2, 0x004D7B8D, 0x001F443C, 0x002F4130, 0x00707671, 0x0080868B, 0x00CADAD9, 0x00CBDBDA, 0x00959EA8, 0x0085979E, 0x0083959C, 0x0082949B, 0x008799A0, 0x008C9EA5,
    0x008EA0A7, 0x008B9DA4, 0x008799A0, 0x0080939A, 0x007A8D94, 0x0082959A, 0x007F8F95, 0x00768588, 0x00849094, 0x00A7B4B6, 0x00CEDADC, 0x0099A593, 0x006F7D65, 0x00707F5F, 0x00748560, 0x00606F4F, 0xFF9FA893, 0xFFF9FDF7, 0xFFFBFCFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFCFF, 0xFFFFFFF7, 0x008C9777, 0x0066744A, 0x0085936A, 0x0077845E, 0x003E4D21, 0x003D4E1B, 0x006B774D, 0x005F6B41, 0x00434F25, 0x004B572D, 0x005A663C,
    0x00424E24, 0x003A461C, 0x004C582E, 0x006B7761, 0x005D6757, 0x00686E69, 0x00BFC2C6, 0x00E9EBF3, 0x00EFF2F7, 0x00E5E9EA, 0x00EAEFED, 0x00E9F0E9, 0x00F1F8F1, 0x00AEB6AB, 0x00454C3D, 0x00545D49, 0x00515942, 0x006E775C, 0x00656F51, 0x00566647,
    0x004C5C3D, 0x00485737, 0x004C5D38, 0x0056653F, 0x00516237, 0x004E5F33, 0x00607041, 0x007B8B62, 0x0077875E, 0x0074845B, 0x00718158, 0x007D8D64, 0x007A8A61, 0x005D6D44, 0x0054643B, 0x005F6E48, 0x00404F29, 0x004A5933, 0x005C6B45, 0x0035441E,
    0x00687751, 0x0042512B, 0x004B5A34, 0x00606F49, 0x00374620, 0x0062714B, 0x0055643E, 0x0061704A, 0x007F8E68, 0x0076855F, 0x006E7D57, 0x00738459, 0x00798960, 0x007B8B62, 0x007A8A61, 0x007D8C66, 0x0082916B, 0x007C8A66, 0x0072805C, 0x00758361,
    0x00788664, 0x007C8A68, 0x0083916D, 0x0084926E, 0x007A8864, 0x0071805A, 0x0073825C, 0x007D8D64, 0x006B7B52, 0x0057673E, 0x00627249, 0x0048582F, 0x00697950, 0x0043532A, 0x0057673E, 0x0048582F, 0x004C5B35, 0x00586642, 0x00435030, 0x005E6A4C,
    0x00636E54, 0x004E5841, 0x00242E17, 0x00151B16, 0x00161B19, 0x001A1E1F, 0x001C1F23, 0x000C0F13, 0x001E2223, 0x00161B1A, 0x000F1510, 0x0014191A, 0x0014191A, 0x0014191A, 0x0014191A, 0x0014191A, 0x0014191A, 0x0014191A, 0x0014191A, 0x00121718,
    0x00111617, 0x00111617, 0x00101516, 0x00101516, 0x00101516, 0x00101516, 0x000F1415, 0x00111617, 0x00121718, 0x00131819, 0x00121718, 0x00111617, 0x00111617, 0x0012171A, 0x0013181B, 0x000A1212, 0x0012191C, 0x0014181D, 0x000C1015, 0x001C1F24,
    0x001C2021, 0x00151914, 0x00191D17, 0x00242C1B, 0x005F6854, 0x006F7A60, 0x00516040, 0x00485934, 0x004D5E39, 0x00485937, 0x00475836, 0x00495A35, 0x00546540, 0x0052633E, 0x004A5B36, 0x00546540, 0x0050613C, 0x00475833, 0x005E6F4A, 0x00576843,
    0x00566742, 0x00566742, 0x00566742, 0x00556641, 0x00546540, 0x00546540, 0x00546540, 0x00546641, 0x00546641, 0x00546641, 0x00546641, 0x00546641, 0x00546641, 0x00546641, 0x00546641, 0x00546540, 0x00546540, 0x00546540, 0x0053643F, 0x0053643F,
    0x0053643F, 0x0053643F, 0x0053643F, 0x0052643F, 0x0052643F, 0x0051633E, 0x0051633E, 0x00546641, 0x00536540, 0x004A5C37, 0x003F512C, 0x00556742, 0x00374924, 0x004C5E39, 0x00536540, 0x0051633E, 0x00697B56, 0x006F815C, 0x00738560, 0x00707E5C,
    0x00627457, 0x00596848, 0x00475434, 0x0047645B, 0x00457B92, 0x00518EAE, 0x005389A0, 0x00507E90, 0x0021463E, 0x002E402F, 0x006F7570, 0x0080868B, 0x00C9D9D8, 0x00CADAD9, 0x00969FA9, 0x008B9DA4, 0x008B9DA4, 0x008A9CA3, 0x0086989F, 0x0085979E,
    0x00889AA1, 0x008C9EA5, 0x0090A2A9, 0x00889BA2, 0x007F9299, 0x0085989D, 0x007F8F95, 0x00738285, 0x00808C90, 0x00A6B3B5, 0x00D1DDDF, 0x00DBE7D5, 0x008C9A82, 0x00778666, 0x00768762, 0x00606F4F, 0xFFA0A994, 0xFFFCFFFA, 0xFFFDFEFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFFFFF7, 0x008A9575, 0x00647248, 0x0087956C, 0x00798660, 0x00455428, 0x004E5F2C, 0x006E7A50, 0x005C683E, 0x005C683E, 0x00647046, 0x005E6A40,
    0x00445026, 0x00364218, 0x0049552B, 0x006D7B5F, 0x0066715D, 0x00777E77, 0x00CED1D5, 0x00E8E9F3, 0x00E3E3EF, 0x00D3D5DD, 0x00D2D5DA, 0x00E5E8EC, 0x00EBEFF0, 0x00B1B6B4, 0x005B5F59, 0x005E6558, 0x00484E3D, 0x00414833, 0x00434B34, 0x00555D52,
    0x00454E41, 0x003B4535, 0x003A432E, 0x00455036, 0x00424C2E, 0x00374221, 0x004A5632, 0x00738459, 0x00728358, 0x007A8B60, 0x0074855A, 0x00718257, 0x007C8D62, 0x0076875C, 0x0065764B, 0x0053623C, 0x005C6B45, 0x003A4923, 0x0051603A, 0x005C6B45,
    0x0036451F, 0x0066754F, 0x003F4E28, 0x004F5E38, 0x00596842, 0x003B4A24, 0x0062714B, 0x004C5B35, 0x006D7C56, 0x0076855F, 0x007D8C66, 0x0077885D, 0x0078885F, 0x0076865D, 0x00728259, 0x0072815B, 0x00778660, 0x007C8A66, 0x007E8C68, 0x00849270,
    0x00859371, 0x00808E6A, 0x00798763, 0x00768460, 0x00788761, 0x007B8A64, 0x007E8D67, 0x006B7950, 0x005C6A41, 0x005B6940, 0x004E5C33, 0x00647249, 0x0048562D, 0x005E6C43, 0x0055633A, 0x004E5E35, 0x00596842, 0x0041502A, 0x005C6A48, 0x004C5939,
    0x00626E50, 0x00707C60, 0x004C583C, 0x0011190E, 0x00161D16, 0x00111614, 0x00111516, 0x0013161A, 0x00292C30, 0x00262A2B, 0x002D3231, 0x00272F2F, 0x00272F2F, 0x00272F2F, 0x00283030, 0x00293131, 0x00283030, 0x00272F2F, 0x00262E2E, 0x002A3232,
    0x002B3333, 0x002B3333, 0x002B3333, 0x002B3333, 0x00293131, 0x00283030, 0x00283030, 0x002B3235, 0x002B3235, 0x002B3333, 0x002A3232, 0x00283030, 0x00283030, 0x00293131, 0x002A3231, 0x00232F2F, 0x00283134, 0x00252C2F, 0x0015191E, 0x00151718,
    0x00212220, 0x0022231A, 0x0018170D, 0x003A432E, 0x00626D53, 0x00707C5E, 0x0063744F, 0x0064764F, 0x006A7C55, 0x00677954, 0x00687957, 0x00677551, 0x0072805C, 0x00616F4B, 0x00717F5B, 0x005B6945, 0x0043512D, 0x0063714D, 0x004F5D39, 0x005A6B46,
    0x005A6B46, 0x005A6B46, 0x00596A45, 0x00596A45, 0x00596A45, 0x00586944, 0x00586944, 0x00586A45, 0x00586A45, 0x00586A45, 0x00586A45, 0x00586A45, 0x00586A45, 0x00586A45, 0x00586A45, 0x005B6C47, 0x005B6C47, 0x005A6B46, 0x005A6B46, 0x005A6B46,
    0x005A6B46, 0x00596A45, 0x00596A45, 0x005C6E49, 0x00566843, 0x00566843, 0x005C6E49, 0x005A6C47, 0x00536540, 0x00546641, 0x005D6F4A, 0x002C3E19, 0x004B5D38, 0x004E603B, 0x00576944, 0x006D7F5A, 0x0070825D, 0x006E805B, 0x006B7D58, 0x00707E5C,
    0x00687A5B, 0x00667555, 0x00515E3E, 0x004C6A5F, 0x004C8398, 0x005491B1, 0x0052899E, 0x004E7C8E, 0x001F443C, 0x002B3D2C, 0x006D736E, 0x0080868B, 0x00C9D9D8, 0x00C9D9D8, 0x0097A0AA, 0x00889AA1, 0x00889AA1, 0x008B9DA4, 0x00889AA1, 0x00899BA2,
    0x008C9EA5, 0x00889AA1, 0x008799A0, 0x00889BA2, 0x007F9299, 0x0085989D, 0x00809096, 0x00728184, 0x007C888C, 0x00A2AFB1, 0x00D1DDDF, 0x00DCE8D6, 0x0084927A, 0x00748363, 0x00788964, 0x00627151, 0xFFA4AD98, 0xFFFDFFFB, 0xFFFDFEFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFBFF, 0xFFFFFFF7, 0x008C9777, 0x0067754B, 0x0087956C, 0x0075825C, 0x00415024, 0x004D5E2B, 0x00525E34, 0x004A562C, 0x00647046, 0x006B774D, 0x0069754B,
    0x0058643A, 0x0038441A, 0x004D592F, 0x00778863, 0x00707E62, 0x008C9686, 0x00D1D6D4, 0x00DBDEE2, 0x00D1D4D9, 0x00CACDD1, 0x00C4C8C9, 0x00CDCED8, 0x00DDDFE7, 0x00BFC2C6, 0x00909391, 0x0083887F, 0x00696E5F, 0x00585F4A, 0x00767E67, 0x008F9296,
    0x00767A7B, 0x00585B59, 0x004F534D, 0x00787C70, 0x00909685, 0x006C735E, 0x0050563F, 0x007D8E63, 0x0078895E, 0x0076875C, 0x007A8B60, 0x00738459, 0x00738459, 0x007F9065, 0x007D8E63, 0x0066754F, 0x0052613B, 0x0064734D, 0x003E4D27, 0x00586741,
    0x005A6943, 0x003D4C26, 0x005F6E48, 0x0041502A, 0x0056653F, 0x00576640, 0x003A4923, 0x00697852, 0x0053623C, 0x0072815B, 0x006F7E58, 0x0077885D, 0x0077875E, 0x0077875E, 0x0078885F, 0x00798862, 0x00778660, 0x00778561, 0x00778561, 0x00768460,
    0x007A8864, 0x007B8965, 0x00788662, 0x0076855F, 0x00788761, 0x0075855C, 0x006E7E55, 0x0058663D, 0x005E6C43, 0x00505E35, 0x005F6D44, 0x0056643B, 0x0057653C, 0x0058663D, 0x0058663D, 0x005D6D44, 0x0043532A, 0x005E6D47, 0x0054633D, 0x00677551,
    0x0072805E, 0x007C8A68, 0x00727F5F, 0x004A5541, 0x00182212, 0x000D150B, 0x001D2220, 0x00141819, 0x001C2021, 0x001D2122, 0x001A1F1E, 0x00151D1C, 0x00161E1D, 0x00171F1E, 0x00192120, 0x001A2221, 0x00192120, 0x00161E1D, 0x00131B1A, 0x00192120,
    0x001A2221, 0x001C2423, 0x001D2524, 0x001D2524, 0x001B2322, 0x00192120, 0x00171F1E, 0x00161E1E, 0x00161E1E, 0x00161E1E, 0x00171F1E, 0x0017201D, 0x0018211E, 0x0018221C, 0x0018221C, 0x00121D1B, 0x001C2725, 0x00131B1B, 0x00161B1A, 0x001E211F,
    0x0015160D, 0x001B1B0D, 0x003E402D, 0x00707B61, 0x007A8668, 0x007A8866, 0x0073855E, 0x0075875E, 0x0074865F, 0x0072845F, 0x00788967, 0x00778660, 0x0075845E, 0x00798862, 0x0071805A, 0x005D6C46, 0x004F5E38, 0x004A5933, 0x004B5A34, 0x0053643F,
    0x0053643F, 0x0053643F, 0x0053643F, 0x0053643F, 0x0052633E, 0x0052633E, 0x0052633E, 0x0052643F, 0x0052643F, 0x0052643F, 0x0052643F, 0x0052643F, 0x0052643F, 0x0052643F, 0x0052643F, 0x00546540, 0x00546540, 0x00546540, 0x00546540, 0x0053643F,
    0x0053643F, 0x0053643F, 0x0053643F, 0x004A5C37, 0x004E603B, 0x004E603B, 0x004B5D38, 0x004E603B, 0x00536540, 0x0050623D, 0x00465833, 0x004D5F3A, 0x005B6D48, 0x00586A45, 0x00657752, 0x00778964, 0x0072845F, 0x006E805B, 0x006F815C, 0x00687652,
    0x00617354, 0x0060704E, 0x00475533, 0x00466459, 0x004C8398, 0x005391AF, 0x00538A9F, 0x00497789, 0x001C4139, 0x00283A29, 0x006C726D, 0x0082888D, 0x00CADAD9, 0x00C7D7D6, 0x0097A0AA, 0x0082949B, 0x0081939A, 0x008B9DA4, 0x008FA1A8, 0x0097A9B0,
    0x009BADB4, 0x0086989F, 0x00798B92, 0x007F9299, 0x00778A91, 0x0082959A, 0x00839399, 0x00768588, 0x007D898D, 0x00A2AFB1, 0x00D2DEE0, 0x00C0CCBA, 0x00717F67, 0x006F7E5E, 0x00758661, 0x005C6B4B, 0xFFA3AC97, 0xFFFDFFFB, 0xFFFDFEFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBF9FF, 0xFFFFFFF7, 0x008C9777, 0x0069774D, 0x0086946B, 0x0076835D, 0x00435226, 0x004A5B28, 0x006A764C, 0x005D693F, 0x005F6B41, 0x005C683E, 0x007A865C,
    0x00748056, 0x003F4B21, 0x004D592F, 0x006A7C55, 0x00677657, 0x0098A291, 0x00CCD3CC, 0x00DDE2E1, 0x00DEE2E3, 0x00E8EDEB, 0x00E4EAE5, 0x00D9DAE4, 0x00E3E5ED, 0x00BABEBF, 0x00919590, 0x00838A7D, 0x005D6350, 0x00515A40, 0x00697257, 0x00A8ABA9,
    0x00898D88, 0x00626660, 0x0060635A, 0x008A8E82, 0x00A3A899, 0x00868979, 0x00626653, 0x00718256, 0x007C8D61, 0x00738458, 0x0075865A, 0x007B8C60, 0x0075865A, 0x00738458, 0x00708155, 0x007E8D67, 0x006E7D57, 0x004C5B35, 0x00606F49, 0x003E4D27,
    0x005D6C46, 0x004A5933, 0x004B5A34, 0x005A6943, 0x0041502A, 0x00586741, 0x0052613B, 0x0044532D, 0x0066754F, 0x004B5A34, 0x005A6943, 0x0057683D, 0x005D6D44, 0x005D6D44, 0x0057673E, 0x0053623C, 0x0056653F, 0x005A6844, 0x005C6A46, 0x00596743,
    0x0054623E, 0x0055633F, 0x005A6943, 0x005A6943, 0x00596940, 0x00596940, 0x0056663D, 0x005E6941, 0x00556038, 0x00636E46, 0x005A653D, 0x005A653D, 0x00667149, 0x00545F37, 0x005A653D, 0x00495930, 0x005F6F46, 0x004A5A31, 0x006D7D54, 0x00798960,
    0x007A8963, 0x00707F59, 0x006F7E58, 0x00738263, 0x003C492F, 0x00172110, 0x00131B10, 0x001A201B, 0x00282D2B, 0x001F2423, 0x00151A18, 0x001D241F, 0x001C231E, 0x001D241F, 0x001F2621, 0x00212823, 0x00202722, 0x001D241F, 0x0019201B, 0x0019211A,
    0x001B231C, 0x001D251E, 0x001E261F, 0x001E261F, 0x001D251E, 0x001B231C, 0x001A221B, 0x00171D1C, 0x00171E1B, 0x00171E1B, 0x001B221D, 0x001F2720, 0x00222C20, 0x00212B1F, 0x001F291C, 0x00182019, 0x001D231E, 0x00181E19, 0x0020241E, 0x00171D12,
    0x001C2211, 0x00464E37, 0x007D866B, 0x00788565, 0x00758361, 0x0072815B, 0x0073865B, 0x0076895E, 0x0072845B, 0x0070835C, 0x00758664, 0x0077845E, 0x007E8B65, 0x0073805A, 0x00525F39, 0x005E6B45, 0x0056633D, 0x0035421C, 0x005F6C46, 0x0053643F,
    0x0053643F, 0x0053643F, 0x0053643F, 0x0053643F, 0x0053643F, 0x0053643F, 0x0053643F, 0x0052643F, 0x0052643F, 0x0052643F, 0x0052643F, 0x0052643F, 0x0052643F, 0x0052643F, 0x0052643F, 0x0052633E, 0x0052633E, 0x0051623D, 0x0051623D, 0x0051623D,
    0x0051623D, 0x0050613C, 0x0050613C, 0x0050623D, 0x00576944, 0x00576944, 0x0050623D, 0x0052643F, 0x00596B46, 0x00556742, 0x00495B36, 0x00556742, 0x00445631, 0x006D7F5A, 0x00778964, 0x00677954, 0x0072845F, 0x006E805B, 0x00657752, 0x0072805C,
    0x00677A59, 0x005B6B49, 0x003A4826, 0x003D5B4E, 0x00477F92, 0x004D8BA9, 0x00558DA0, 0x00487688, 0x001A3F37, 0x00263827, 0x006B716C, 0x00848A8F, 0x00CADAD9, 0x00C6D6D5, 0x0098A1AB, 0x007A8C93, 0x0074868D, 0x007C8E95, 0x00809299, 0x0090A2A9,
    0x009DAFB6, 0x00899BA2, 0x007C8E95, 0x007A8D94, 0x0072858C, 0x00809398, 0x0086969C, 0x007B8A8D, 0x00808C90, 0x00A4B1B3, 0x00D5E1E3, 0x00BDC9B7, 0x00738169, 0x00758464, 0x00768762, 0x005A6949, 0xFFA0A994, 0xFFFCFFFA, 0xFFFDFEFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFDFFF5, 0x008A9575, 0x0067754B, 0x0085936A, 0x007A8761, 0x0047562A, 0x00455623, 0x006D794F, 0x00616D43, 0x004A562C, 0x00445026, 0x00647046,
    0x00606C42, 0x003C481E, 0x0048542A, 0x006F7D61, 0x0079856F, 0x00BAC2B7, 0x00CED3D2, 0x00E0E3E7, 0x00D8DBDF, 0x00DFE4E3, 0x00DBE0DE, 0x00DFE2E7, 0x00E5E8EC, 0x00A9AEAC, 0x0082887D, 0x009BA392, 0x00576046, 0x00626D4D, 0x00606B4A, 0x005C674D,
    0x00586349, 0x00505B41, 0x00565F44, 0x005F684D, 0x00646B50, 0x00676F51, 0x00666E50, 0x004B5C30, 0x0067784C, 0x00798A5E, 0x00748559, 0x00748559, 0x0076875B, 0x006F8054, 0x00728357, 0x0072815B, 0x007C8B65, 0x0064734D, 0x004F5E38, 0x0065744E,
    0x0031401A, 0x0061704A, 0x00475630, 0x00475630, 0x005D6C46, 0x003E4D27, 0x00596842, 0x0053623C, 0x003F4E28, 0x00596842, 0x005C6B45, 0x0056673C, 0x0056663D, 0x0055653C, 0x0054643B, 0x00596842, 0x005F6E48, 0x005F6D49, 0x005A6844, 0x00616F4B,
    0x00586642, 0x00596842, 0x005F6E48, 0x005D6D44, 0x005B6B42, 0x005D6E43, 0x005D6E43, 0x0059643C, 0x005A653D, 0x00566139, 0x0057623A, 0x005D6840, 0x00535E36, 0x005B663E, 0x00525D35, 0x005F7045, 0x00516237, 0x00728358, 0x00718257, 0x00738459,
    0x0076875C, 0x007A8B60, 0x00708156, 0x0075875E, 0x0072835E, 0x004D5A40, 0x00182211, 0x000C1409, 0x00171E17, 0x00111712, 0x00111712, 0x00171D12, 0x00151B10, 0x00141A0F, 0x00151B10, 0x00171D12, 0x00181E13, 0x00161C11, 0x0013190E, 0x00141B0E,
    0x00151C0F, 0x00151C0F, 0x00161D10, 0x00171E11, 0x00171E11, 0x00171E11, 0x00171E11, 0x00151914, 0x00131711, 0x0013180F, 0x00181E13, 0x001E2518, 0x00212918, 0x001D2612, 0x0018210D, 0x00202216, 0x001B1C12, 0x0013170C, 0x001C2014, 0x001B2410,
    0x00424F35, 0x006E7E5C, 0x0074865F, 0x00768460, 0x0074835D, 0x0076875C, 0x00778B5E, 0x0075895C, 0x00718459, 0x006E815A, 0x006F815C, 0x007E8C63, 0x0078865D, 0x0056643B, 0x0058663D, 0x0049572E, 0x003E4C23, 0x005F6D44, 0x00546239, 0x00647550,
    0x00647550, 0x00647550, 0x00647550, 0x00647550, 0x00647550, 0x00647550, 0x00647550, 0x00647651, 0x00647651, 0x00647651, 0x00647651, 0x00647651, 0x00647651, 0x00647651, 0x00647651, 0x00677853, 0x00677853, 0x00667752, 0x00667752, 0x00667752,
    0x00667752, 0x00657651, 0x00657651, 0x00637550, 0x0062744F, 0x0062744F, 0x0061734E, 0x005E704B, 0x005C6E49, 0x005E704B, 0x00637550, 0x005D6F4A, 0x00798B66, 0x006C7E59, 0x006C7E59, 0x006E805B, 0x00667853, 0x00748661, 0x00748661, 0x006D7C56,
    0x00667958, 0x005D6D4B, 0x003F4D2B, 0x004B695C, 0x0050889B, 0x004B89A7, 0x00548C9F, 0x004C7A8C, 0x001D423A, 0x00263827, 0x006A706B, 0x00858B90, 0x00CADAD9, 0x00C6D6D5, 0x009AA3AD, 0x00809299, 0x00778990, 0x007B8D94, 0x00788A91, 0x0086989F,
    0x009AACB3, 0x0090A2A9, 0x008B9DA4, 0x0082959C, 0x00788B92, 0x0084979C, 0x008B9BA1, 0x007F8E91, 0x00818D91, 0x00A3B0B2, 0x00D4E0E2, 0x00B4C0AE, 0x006C7A62, 0x00738262, 0x00798A65, 0x00617050, 0xFFA3AC97, 0xFFF7FBF5, 0xFFFCFDFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFBFBFFF3, 0x00899474, 0x0068764C, 0x0085936A, 0x007A8761, 0x00404F23, 0x00344512, 0x00323E14, 0x003B471D, 0x00333F15, 0x00364218, 0x0039451B,
    0x002F3B11, 0x0038441A, 0x004C582E, 0x006B7564, 0x00878F84, 0x00D5DAD9, 0x00D5D7DF, 0x00E7E7F3, 0x00D3D4DE, 0x00D2D5D9, 0x00D1D5D6, 0x00D5D8DC, 0x00E5EAE9, 0x00A9B0A9, 0x008B9285, 0x00C6D0B9, 0x005F694B, 0x00838F6B, 0x00748259, 0x0076875B,
    0x007B8C60, 0x0077865A, 0x0079875D, 0x007B875D, 0x00758157, 0x006A754D, 0x00515A32, 0x00596A3E, 0x004F6034, 0x006D7E52, 0x0075865A, 0x00738458, 0x007A8B5F, 0x006F8054, 0x0075865A, 0x00778660, 0x0071805A, 0x0082916B, 0x0065744E, 0x004E5D37,
    0x0064734D, 0x00384721, 0x00586741, 0x004B5A34, 0x004A5933, 0x0053623C, 0x0042512B, 0x0054633D, 0x00606F49, 0x0056653F, 0x00586741, 0x00596A3F, 0x0058683F, 0x005A6A41, 0x005C6C43, 0x00596842, 0x0054633D, 0x00576541, 0x005D6B47, 0x005B6945,
    0x00586741, 0x005A6943, 0x005B6A44, 0x0056663D, 0x00596940, 0x005C6D42, 0x00596A3F, 0x00606B43, 0x00545F37, 0x00616C44, 0x005A653D, 0x00556038, 0x005F6A42, 0x00505B33, 0x00626D45, 0x00516237, 0x006F8055, 0x0078895E, 0x00798A5F, 0x0075865B,
    0x00738458, 0x00718256, 0x007A8B5F, 0x00708455, 0x0075875E, 0x00758464, 0x004E5A44, 0x002F382B, 0x003E463C, 0x004A514A, 0x00404740, 0x004A4E42, 0x00474B3F, 0x0043473B, 0x0044483C, 0x00464A3E, 0x00484C40, 0x00484C40, 0x00464A3E, 0x00444A39,
    0x00434938, 0x00434938, 0x00434938, 0x00444A39, 0x00454B3A, 0x00474D3C, 0x00494F3E, 0x0043453F, 0x003F4239, 0x003E4237, 0x00424738, 0x00494F3E, 0x004A513C, 0x00434B34, 0x003C452B, 0x00444335, 0x00525143, 0x003E3E30, 0x003A402F, 0x0049533C,
    0x00687958, 0x00738861, 0x006F865A, 0x0073825C, 0x0075855C, 0x0078895D, 0x00748859, 0x00708457, 0x0072855A, 0x00768962, 0x00778964, 0x0076845B, 0x004D5B32, 0x005F6D44, 0x004B5930, 0x00414F26, 0x005C6A41, 0x00536138, 0x00637148, 0x00748560,
    0x00748560, 0x00748560, 0x00758661, 0x00758661, 0x00758661, 0x00758661, 0x00758661, 0x00748661, 0x00748661, 0x00748661, 0x00748661, 0x00748661, 0x00748661, 0x00748661, 0x00748661, 0x00758661, 0x00758661, 0x00748560, 0x00748560, 0x00748560,
    0x00748560, 0x0073845F, 0x0073845F, 0x00738560, 0x0072845F, 0x0072845F, 0x00738560, 0x00758762, 0x00758762, 0x00748661, 0x00748661, 0x0072845F, 0x0070825D, 0x0070825D, 0x006A7C57, 0x0070825D, 0x0071835E, 0x00677954, 0x006E805B, 0x00707F59,
    0x00697C5B, 0x005C6D48, 0x003D4B27, 0x004D6B5E, 0x0051899C, 0x004887A3, 0x00538B9E, 0x00517F91, 0x0020453D, 0x00273928, 0x006A706B, 0x00858B90, 0x00CADAD9, 0x00C7D7D6, 0x009CA5AF, 0x0093A5AC, 0x008EA0A7, 0x0095A7AE, 0x008B9DA4, 0x0091A3AA,
    0x00A0B2B9, 0x0096A8AF, 0x0095A7AE, 0x0090A3AA, 0x0081949B, 0x008A9DA2, 0x008E9EA4, 0x00808F92, 0x00808C90, 0x00A0ADAF, 0x00D2DEE0, 0x00C1CDBB, 0x00707E66, 0x006E7D5D, 0x0073845F, 0x00606F4F, 0xFFA4AD98, 0xFFF8FCF6, 0xFFFDFEFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCFAFF, 0xFBFBFFF3, 0x00899474, 0x006C7A50, 0x00829067, 0x007E8B65, 0x00647347, 0x005E6F3C, 0x0058693E, 0x00596A3F, 0x005B6C41, 0x0054653A, 0x0055663B,
    0x00596A3F, 0x0056673C, 0x005F7045, 0x00728358, 0x00596842, 0x00869373, 0x00ADB99D, 0x0087917A, 0x006E795F, 0x00818C72, 0x008B977B, 0x00737E5D, 0x0075815D, 0x00737D59, 0x006A754F, 0x006C774F, 0x00697349, 0x007A8459, 0x007E895B, 0x00798862,
    0x00798960, 0x0075855C, 0x007A8A61, 0x00798A5F, 0x0078895E, 0x00798A5E, 0x0066774B, 0x0048592D, 0x005A6B3F, 0x004F6034, 0x006C7D51, 0x00798A5E, 0x0075865A, 0x0078895D, 0x0075865A, 0x00728455, 0x00748657, 0x00798B5C, 0x0077885C, 0x00617246,
    0x0057683D, 0x0055663B, 0x003E4F24, 0x0056663D, 0x004E5E35, 0x004F5F36, 0x0053633A, 0x004F5F36, 0x00516138, 0x0055653C, 0x0053633A, 0x0052613B, 0x0053623C, 0x0053623C, 0x0053623C, 0x0053623C, 0x0054633D, 0x0054633D, 0x0054633D, 0x0054633D,
    0x0055643E, 0x0055643E, 0x0056653F, 0x0056653F, 0x0055643E, 0x0055643E, 0x0054633D, 0x00526239, 0x0057673E, 0x005A6A41, 0x00526239, 0x0053633A, 0x0055653C, 0x005A6A41, 0x0057673E, 0x00748559, 0x00738458, 0x00738458, 0x00738458, 0x00738458,
    0x00748559, 0x00748559, 0x0075865A, 0x00728357, 0x00728357, 0x0074855A, 0x00788761, 0x00606C4E, 0x00838C77, 0x00848A7F, 0x00828680, 0x00A3A199, 0x009E9C94, 0x00A3A199, 0x009F9D95, 0x00A5A39B, 0x009D9B93, 0x009C9A92, 0x009A9890, 0x0099948B,
    0x00A5A097, 0x009C978E, 0x00928D84, 0x00B0ABA2, 0x00A09B92, 0x009B968D, 0x00A9A49B, 0x009E9C94, 0x00939189, 0x00A19F97, 0x0095938B, 0x009A9890, 0x00AFADA5, 0x0097958D, 0x008A8880, 0x00A2989E, 0x00A9A39E, 0x007C7D69, 0x0078825E, 0x00768559,
    0x00798D60, 0x006E8258, 0x0070855F, 0x0075885D, 0x00708358, 0x0076895E, 0x0076875C, 0x0078895E, 0x007D8B61, 0x0076845A, 0x007A885E, 0x004E5D37, 0x0055643E, 0x004B5A34, 0x00364821, 0x0052643D, 0x0054663F, 0x00586B44, 0x007F926B, 0x00748560,
    0x0073845F, 0x0072845D, 0x0072845D, 0x0072845B, 0x0072845B, 0x0072845B, 0x0072855A, 0x00758760, 0x0074865F, 0x0073855E, 0x0072845D, 0x0072845D, 0x0072845D, 0x0073855E, 0x0074865F, 0x0074865F, 0x0074865F, 0x0074865F, 0x0073855E, 0x0072845D,
    0x0071835C, 0x0070825B, 0x006F815A, 0x0073865F, 0x0073865F, 0x0072855E, 0x0072855E, 0x0071845D, 0x0070835C, 0x0070835C, 0x006F825B, 0x006F815C, 0x006F815C, 0x006F815C, 0x006F815C, 0x006E805B, 0x006E805B, 0x006E805B, 0x006E805B, 0x00697E5E,
    0x006B7A54, 0x00636D43, 0x00415334, 0x00416359, 0x005C8D95, 0x005C94A5, 0x0051899C, 0x004B7D89, 0x002C4C4B, 0x002E382B, 0x00767668, 0x00898D88, 0x00D4E0E4, 0x00BBCED5, 0x0090A4A9, 0x0091A0A9, 0x0093A2AB, 0x008F9EA7, 0x008C9BA4, 0x008D9CA5,
    0x008C9BA4, 0x008B9AA3, 0x00909FA8, 0x00869CA1, 0x0080999D, 0x007E979B, 0x00768F93, 0x0074888D, 0x007C8C92, 0x009DA7AE, 0x00CFD5DC, 0x00C9D3CD, 0x00849181, 0x006A795D, 0x00758760, 0x0063714D, 0xFFA3AC92, 0xFFFBFFF4, 0xFFFFFEFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFFFFF7, 0x00879272, 0x006A784E, 0x007F8D64, 0x00828F69, 0x0079885C, 0x007C8D5A, 0x007F9065, 0x007C8D62, 0x007B8C61, 0x007C8D62, 0x007C8D62,
    0x007A8B60, 0x00798A5F, 0x00809166, 0x007A8C5D, 0x006F8054, 0x0072815B, 0x007B8965, 0x00778563, 0x0075835F, 0x00788761, 0x007C8C63, 0x007A8761, 0x00798660, 0x0076835D, 0x00717C54, 0x0077825A, 0x00778157, 0x00828C62, 0x00798358, 0x0075855C,
    0x0077875E, 0x0075865B, 0x0077885D, 0x0075865A, 0x0075865A, 0x007B8C60, 0x00708253, 0x0065764A, 0x0048592D, 0x005B6C40, 0x0056673B, 0x00738458, 0x007B8C60, 0x007C8D61, 0x00718256, 0x00768859, 0x00758758, 0x006F8152, 0x0078895D, 0x0076875B,
    0x00627348, 0x00596A3F, 0x0056673C, 0x0043532A, 0x004D5D34, 0x0048582F, 0x004B5B32, 0x005C6C43, 0x00596940, 0x00526239, 0x005F6F46, 0x00596842, 0x00596842, 0x00596842, 0x005A6943, 0x005A6943, 0x005A6943, 0x005A6943, 0x005A6943, 0x00596842,
    0x00596842, 0x005A6943, 0x005A6943, 0x005A6943, 0x005A6943, 0x00596842, 0x00596842, 0x0055653C, 0x0055653C, 0x004F5F36, 0x00596940, 0x00516138, 0x005B6B42, 0x005E6E45, 0x006D7D54, 0x0076875B, 0x0076875B, 0x0076875B, 0x0076875B, 0x0076875B,
    0x0076875B, 0x0076875B, 0x0076875B, 0x0077885C, 0x00798A5E, 0x00738459, 0x007F8E68, 0x00546141, 0x00727C65, 0x006E7568, 0x007B8077, 0x008A8A7E, 0x0089897D, 0x00838377, 0x007F7F73, 0x008B8B7F, 0x008E8E82, 0x009B9B8F, 0x00959589, 0x0089887A,
    0x00868577, 0x007D7C6E, 0x00888779, 0x007C7B6D, 0x008C8B7D, 0x007A796B, 0x008E8D7F, 0x008B8D81, 0x007F8175, 0x008E9084, 0x0085877B, 0x0086887C, 0x0094968A, 0x0085877B, 0x00828478, 0x00938B8B, 0x00908E84, 0x005F634A, 0x00707B55, 0x00758758,
    0x00708455, 0x00708459, 0x00738861, 0x0074865D, 0x0074865D, 0x00708259, 0x007D8D64, 0x00728259, 0x00748259, 0x007B8960, 0x004A582F, 0x00596842, 0x004C5B35, 0x0036451F, 0x005B6D46, 0x004F613A, 0x005F714A, 0x00748760, 0x0072855E, 0x00748560,
    0x0073845F, 0x0073855E, 0x0072845D, 0x0072845B, 0x0072845B, 0x0072845B, 0x0072855A, 0x0074865F, 0x0073855E, 0x0073855E, 0x0072845D, 0x0072845D, 0x0073855E, 0x0074865F, 0x0074865F, 0x00758760, 0x00758760, 0x0074865F, 0x0073855E, 0x0072845D,
    0x0071835C, 0x0070825B, 0x0070825B, 0x0073865F, 0x0073865F, 0x0072855E, 0x0072855E, 0x0071845D, 0x0070835C, 0x0070835C, 0x0070835C, 0x0070825D, 0x006F815C, 0x006F815C, 0x006F815C, 0x006F815C, 0x006F815C, 0x006E805B, 0x006E805B, 0x00697C5B,
    0x006D7A54, 0x00687248, 0x004A5C3D, 0x0044665F, 0x00548692, 0x00568FA5, 0x00518AA3, 0x004B