/*********************************************************************
*                 SEGGER Software GmbH                               *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2018  SEGGER Microcontroller GmbH                *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.46 - Graphical user interface for embedded applications **
All  Intellectual Property rights in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product. This file may
only be used in accordance with the following terms:

The  software has  been licensed by SEGGER Software GmbH to Nuvoton Technology Corporation
at the address: No. 4, Creation Rd. III, Hsinchu Science Park, Taiwan
for the purposes  of  creating  libraries  for its
Arm Cortex-M and  Arm9 32-bit microcontrollers, commercialized and distributed by Nuvoton Technology Corporation
under  the terms and conditions  of  an  End  User
License  Agreement  supplied  with  the libraries.
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
Licensing information
Licensor:                 SEGGER Software GmbH
Licensed to:              Nuvoton Technology Corporation, No. 4, Creation Rd. III, Hsinchu Science Park, 30077 Hsinchu City, Taiwan
Licensed SEGGER software: emWin
License number:           GUI-00735
License model:            emWin License Agreement, signed February 27, 2018
Licensed platform:        Cortex-M and ARM9 32-bit series microcontroller designed and manufactured by or for Nuvoton Technology Corporation
----------------------------------------------------------------------
Support and Update Agreement (SUA)
SUA period:               2018-03-26 - 2019-03-27
Contact to extend SUA:    sales@segger.com
----------------------------------------------------------------------
File        : GUIDEMO_Resource.c
Purpose     : Contains fonts and bitmaps used in the demo.
---------------------------END-OF-HEADER------------------------------
*/

#include "GUIDEMO.h"

#ifndef GUI_CONST_STORAGE
#define GUI_CONST_STORAGE const
#endif

/*********************************************************************
*                                                                    *
*       Fonts                                                        *
*                                                                    *
**********************************************************************
*/
/*********************************************************************
*                                                                    *
*       GUI_FontD6x8                                                 *
*                                                                    *
*  Used in GUIDEMO.c (PROGBAR)                                       *
*                                                                    *
**********************************************************************
*/
static GUI_CONST_STORAGE unsigned char acFontD6x8[16][8] =
{
    {
        _XXX____,
        X___X___,
        X___X___,
        X___X___,
        X___X___,
        X___X___,
        X___X___,
        _XXX____,
    }, {
        __X_____,
        _XX_____,
        __X_____,
        __X_____,
        __X_____,
        __X_____,
        __X_____,
        _XXX____,
    }, {
        _XXX____,
        X___X___,
        ____X___,
        ___X____,
        __X_____,
        _X______,
        X_______,
        XXXXX___,
    }, {
        _XXX____,
        X___X___,
        ____X___,
        ___X____,
        ___X____,
        ____X___,
        X___X___,
        _XXX____,
    }, {
        ___X____,
        __XX____,
        _X_X____,
        X__X____,
        XXXXX___,
        ___X____,
        ___X____,
        ___X____,
    }, {
        XXXXX___,
        X_______,
        X_______,
        XXXX____,
        ____X___,
        ____X___,
        X___X___,
        _XXX____,
    }, {
        __XX____,
        _X______,
        X_______,
        XXXX____,
        X___X___,
        X___X___,
        X___X___,
        _XXX____,
    }, {
        XXXXX___,
        ____X___,
        ____X___,
        ___X____,
        __X_____,
        _X______,
        _X______,
        _X______,
    }, {
        _XXX____,
        X___X___,
        X___X___,
        _XXX____,
        X___X___,
        X___X___,
        X___X___,
        _XXX____,
    }, {
        _XXX____,
        X___X___,
        X___X___,
        _XXXX___,
        ____X___,
        ____X___,
        ___X____,
        _XX_____,
    }, {
        ________,
        ________,
        __X_____,
        __X_____,
        XXXXX___,
        __X_____,
        __X_____,
        ________,
    }, {
        ________,
        ________,
        ________,
        ________,
        XXXXX___,
        ________,
        ________,
        ________,
    }, {
        ________,
        ________,
        ________,
        ________,
        ________,
        ________,
        ________,
        ________,
    }, {
        ________,
        ________,
        ________,
        ________,
        ________,
        ________,
        _XX_____,
        _XX_____,
    }, {
        ________,
        ________,
        _XX_____,
        _XX_____,
        ________,
        _XX_____,
        _XX_____,
        ________
    }, {
        ________,
        _XX___X_,
        _XX__X__,
        ____X___,
        ___X____,
        __X__XX_,
        _X___XX_,
        ________
    }

};

static GUI_CONST_STORAGE GUI_CHARINFO GUI_FontD6x8_CharInfo[16] =
{
    { 6, 6, 1, acFontD6x8[12] },  // Code 0020 ' '
    { 6, 6, 1, acFontD6x8[15] },  // Code 0025 '%'
    { 6, 6, 1, acFontD6x8[10] },  // Code 002B '+'
    { 6, 6, 1, acFontD6x8[11] },  // Code 002D '-'
    { 6, 6, 1, acFontD6x8[13] },  // Code 002E '.'
    { 6, 6, 1, acFontD6x8[0]  },  // Code 0030 '0'
    { 6, 6, 1, acFontD6x8[1]  },  // Code 0031 '1'
    { 6, 6, 1, acFontD6x8[2]  },  // Code 0032 '2'
    { 6, 6, 1, acFontD6x8[3]  },  // Code 0033 '3'
    { 6, 6, 1, acFontD6x8[4]  },  // Code 0034 '4'
    { 6, 6, 1, acFontD6x8[5]  },  // Code 0035 '5'
    { 6, 6, 1, acFontD6x8[6]  },  // Code 0036 '6'
    { 6, 6, 1, acFontD6x8[7]  },  // Code 0037 '7'
    { 6, 6, 1, acFontD6x8[8]  },  // Code 0038 '8'
    { 6, 6, 1, acFontD6x8[9]  },  // Code 0039 '9'
    { 6, 6, 1, acFontD6x8[14] }   // Code 003A ':'
};

static GUI_CONST_STORAGE GUI_FONT_PROP GUI_FontD6x8_Prop5 =
{
    0x0030,                              // First character
    0x003A,                              // Last character
    &GUI_FontD6x8_CharInfo[5],           // Address of first character
    (GUI_CONST_STORAGE GUI_FONT_PROP*)0  // Pointer to next GUI_FONT_PROP
};

static GUI_CONST_STORAGE GUI_FONT_PROP GUI_FontD6x8_Prop4 =
{
    0x002D,                     // First character
    0x002E,                     // Last character
    &GUI_FontD6x8_CharInfo[3],  // Address of first character
    &GUI_FontD6x8_Prop5         // Pointer to next GUI_FONT_PROP
};

static GUI_CONST_STORAGE GUI_FONT_PROP GUI_FontD6x8_Prop3 =
{
    0x002B,                     // First character
    0x002B,                     // Last character
    &GUI_FontD6x8_CharInfo[2],  // Address of first character
    &GUI_FontD6x8_Prop4         // Pointer to next GUI_FONT_PROP
};

static GUI_CONST_STORAGE GUI_FONT_PROP GUI_FontD6x8_Prop2 =
{
    0x0025,                     // First character
    0x0025,                     // Last character
    &GUI_FontD6x8_CharInfo[1],  // Address of first character
    &GUI_FontD6x8_Prop3         // Pointer to next GUI_FONT_PROP
};

static GUI_CONST_STORAGE GUI_FONT_PROP GUI_FontD6x8_Prop1 =
{
    0x0020,                     // First character
    0x0020,                     // Last character
    &GUI_FontD6x8_CharInfo[0],  // Address of first character
    &GUI_FontD6x8_Prop2         // Pointer to next GUI_FONT_PROP
};

GUI_CONST_STORAGE GUI_FONT GUI_FontD6x8 =
{
    GUI_FONTTYPE_PROP,        // Type of font
    8,                        // Height of font
    8,                        // Space of font y
    1,                        // Magnification x
    1,                        // Magnification y
    { &GUI_FontD6x8_Prop1 },
    8,                        // Baseline
    0,                        // LHeight
    8                         // CHeight
};

/*********************************************************************
*                                                                    *
*       GUI_FontRounded16                                            *
*                                                                    *
*  Used in                                                           *
*  - GUIDEMO.c              (GUIDEMO_DispHint())                     *
*  - GUIDEMO_Automotive.c                                            *
*  - GUIDEMO_Bitmap.c                                                *
*  - GUIDEMO_Cursor.c                                                *
*  - GUIDEMO_IconView.c                                              *
*  - GUIDEMO_Speedometer.c                                           *
*                                                                    *
**********************************************************************
*/
GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0020[  1] =   // Code 0020, SPACE
{
    0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0021[ 22] =   // Code 0021, EXCLAMATION MARK
{
    0x56, 0x00,
    0xFF, 0x10,
    0xFF, 0x20,
    0xEF, 0x10,
    0xCE, 0x00,
    0xAC, 0x00,
    0x89, 0x00,
    0x01, 0x00,
    0xCD, 0x10,
    0xCE, 0x10,
    0x01, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0022[ 15] =   // Code 0022, QUOTATION MARK
{
    0x36, 0x07, 0x30,
    0x9F, 0x3F, 0x90,
    0x9F, 0x4F, 0x90,
    0x9F, 0x3F, 0x90,
    0x24, 0x05, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0023[ 44] =   // Code 0023, NUMBER SIGN
{
    0x00, 0x03, 0x02, 0x10,
    0x00, 0x5E, 0x0D, 0x60,
    0x00, 0x8C, 0x0F, 0x40,
    0x07, 0xDE, 0xAF, 0xA1,
    0x09, 0xFD, 0xDF, 0xB2,
    0x00, 0xE6, 0x7D, 0x00,
    0x3B, 0xFC, 0xDE, 0x90,
    0x19, 0xF8, 0xDC, 0x50,
    0x05, 0xF0, 0xD7, 0x00,
    0x07, 0xC0, 0xF4, 0x00,
    0x00, 0x10, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0024[ 48] =   // Code 0024, DOLLAR SIGN
{
    0x00, 0x17, 0x71, 0x00,
    0x08, 0xFF, 0xFF, 0x91,
    0x4F, 0x87, 0x79, 0xF7,
    0x7F, 0x36, 0x60, 0x62,
    0x3F, 0xEC, 0x92, 0x00,
    0x05, 0xCF, 0xFF, 0xB1,
    0x00, 0x06, 0x9B, 0xF7,
    0x9E, 0x06, 0x60, 0xF9,
    0x7F, 0x97, 0x78, 0xF6,
    0x09, 0xFF, 0xFF, 0x80,
    0x00, 0x17, 0x70, 0x00,
    0x00, 0x02, 0x20, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0025[ 66] =   // Code 0025, PERCENT SIGN
{
    0x02, 0x30, 0x00, 0x04, 0x30, 0x00,
    0x6F, 0xDC, 0x00, 0x1E, 0x30, 0x00,
    0xD8, 0x2F, 0x50, 0x79, 0x00, 0x00,
    0xF7, 0x0F, 0x61, 0xE2, 0x00, 0x00,
    0xBB, 0x7F, 0x28, 0x90, 0x00, 0x00,
    0x19, 0xB5, 0x2E, 0x16, 0xBA, 0x20,
    0x00, 0x00, 0x98, 0x3F, 0x6B, 0xB0,
    0x00, 0x02, 0xE1, 0x6F, 0x07, 0xF0,
    0x00, 0x0A, 0x70, 0x4F, 0x28, 0xD0,
    0x00, 0x3E, 0x00, 0x0B, 0xEF, 0x60,
    0x00, 0x24, 0x00, 0x00, 0x21, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0026[ 55] =   // Code 0026, AMPERSAND
{
    0x00, 0x05, 0x74, 0x00, 0x00,
    0x00, 0xCF, 0xEF, 0x80, 0x00,
    0x03, 0xF8, 0x0B, 0xF0, 0x00,
    0x02, 0xFB, 0x2D, 0xD0, 0x00,
    0x00, 0xAF, 0xFE, 0x40, 0x00,
    0x08, 0xFF, 0xFB, 0x07, 0x50,
    0x3F, 0xD2, 0xBF, 0xBF, 0x90,
    0x6F, 0x70, 0x1D, 0xFE, 0x20,
    0x3F, 0xD6, 0x7E, 0xFF, 0x50,
    0x08, 0xFF, 0xFB, 0x4E, 0x90,
    0x00, 0x12, 0x10, 0x01, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0027[  5] =   // Code 0027, APOSTROPHE
{
    0x45,
    0xBD,
    0xBD,
    0xBD,
    0x33
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0028[ 26] =   // Code 0028, LEFT PARENTHESIS
{
    0x00, 0x37,
    0x00, 0xCB,
    0x04, 0xF7,
    0x09, 0xF2,
    0x0D, 0xD0,
    0x1F, 0xB0,
    0x2F, 0xB0,
    0x1F, 0xB0,
    0x0D, 0xD0,
    0x09, 0xF2,
    0x04, 0xF6,
    0x00, 0xCB,
    0x00, 0x37
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0029[ 26] =   // Code 0029, RIGHT PARENTHESIS
{
    0x36, 0x00,
    0x6F, 0x20,
    0x2F, 0x90,
    0x0C, 0xE0,
    0x08, 0xF3,
    0x06, 0xF6,
    0x06, 0xF7,
    0x06, 0xF6,
    0x08, 0xF3,
    0x0C, 0xE0,
    0x2F, 0x90,
    0x6F, 0x30,
    0x47, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_002A[ 18] =   // Code 002A, ASTERISK
{
    0x00, 0x33, 0x00,
    0x12, 0x79, 0x21,
    0x4F, 0xEE, 0xF5,
    0x02, 0xFE, 0x30,
    0x0A, 0x98, 0xA0,
    0x01, 0x00, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_002B[ 32] =   // Code 002B, PLUS SIGN
{
    0x00, 0x03, 0x20, 0x00,
    0x00, 0x0D, 0xA0, 0x00,
    0x00, 0x0D, 0xB0, 0x00,
    0x37, 0x7E, 0xD7, 0x72,
    0xAF, 0xFF, 0xFF, 0xF7,
    0x02, 0x2D, 0xC2, 0x20,
    0x00, 0x0D, 0xB0, 0x00,
    0x00, 0x0B, 0x80, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_002C[  8] =   // Code 002C, COMMA
{
    0x0D, 0xD0,
    0x0E, 0xF3,
    0x01, 0xD1,
    0x0B, 0x50
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_002D[  9] =   // Code 002D, HYPHEN-MINUS
{
    0x17, 0x77, 0x30,
    0x7F, 0xFF, 0xB0,
    0x04, 0x65, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_002E[  6] =   // Code 002E, FULL STOP
{
    0x0D, 0xD0,
    0x0D, 0xD0,
    0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_002F[ 33] =   // Code 002F, SOLIDUS
{
    0x00, 0x04, 0x50,
    0x00, 0x0D, 0x90,
    0x00, 0x4F, 0x30,
    0x00, 0xAD, 0x00,
    0x01, 0xF7, 0x00,
    0x06, 0xF2, 0x00,
    0x0C, 0xB0, 0x00,
    0x3F, 0x50, 0x00,
    0x8E, 0x00, 0x00,
    0xD9, 0x00, 0x00,
    0x20, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0030[ 44] =   // Code 0030, DIGIT ZERO
{
    0x00, 0x03, 0x30, 0x00,
    0x03, 0xDF, 0xFD, 0x30,
    0x0D, 0xF7, 0x7F, 0xD0,
    0x4F, 0xA0, 0x0B, 0xF4,
    0x7F, 0x70, 0x07, 0xF6,
    0x7F, 0x60, 0x07, 0xF7,
    0x6F, 0x70, 0x07, 0xF6,
    0x4F, 0xA0, 0x0B, 0xF3,
    0x0D, 0xF7, 0x8F, 0xC0,
    0x02, 0xDF, 0xFC, 0x20,
    0x00, 0x02, 0x20, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0031[ 33] =   // Code 0031, DIGIT ONE
{
    0x00, 0x00, 0x30,
    0x00, 0x07, 0xF3,
    0x04, 0x8F, 0xF4,
    0x1F, 0xFF, 0xF4,
    0x01, 0x2C, 0xF4,
    0x00, 0x0B, 0xF4,
    0x00, 0x0B, 0xF4,
    0x00, 0x0B, 0xF4,
    0x00, 0x0B, 0xF4,
    0x00, 0x0A, 0xF2,
    0x00, 0x00, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0032[ 40] =   // Code 0032, DIGIT TWO
{
    0x00, 0x13, 0x30, 0x00,
    0x06, 0xEF, 0xFE, 0x50,
    0x4F, 0xD6, 0x7F, 0xF1,
    0x7F, 0x50, 0x0B, 0xF4,
    0x25, 0x00, 0x1E, 0xF1,
    0x00, 0x05, 0xEF, 0x70,
    0x01, 0xBF, 0xC4, 0x00,
    0x1D, 0xF7, 0x00, 0x00,
    0x7F, 0xD9, 0x99, 0x92,
    0x6F, 0xFF, 0xFF, 0xF3
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0033[ 44] =   // Code 0033, DIGIT THREE
{
    0x00, 0x13, 0x30, 0x00,
    0x08, 0xFF, 0xFD, 0x20,
    0x4F, 0xC6, 0x8F, 0xB0,
    0x3B, 0x20, 0x0F, 0xC0,
    0x00, 0x07, 0xAF, 0x60,
    0x00, 0x1E, 0xFF, 0x70,
    0x00, 0x00, 0x3F, 0xF1,
    0x7E, 0x20, 0x0E, 0xF1,
    0x7F, 0xC6, 0xAF, 0xC0,
    0x09, 0xFF, 0xFB, 0x20,
    0x00, 0x12, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0034[ 44] =   // Code 0034, DIGIT FOUR
{
    0x00, 0x00, 0x13, 0x00,
    0x00, 0x01, 0xCF, 0x30,
    0x00, 0x0A, 0xFF, 0x40,
    0x00, 0x7E, 0xBF, 0x40,
    0x03, 0xF5, 0x9F, 0x40,
    0x1E, 0x90, 0x9F, 0x40,
    0xAF, 0xA9, 0xDF, 0xB4,
    0x9D, 0xDD, 0xEF, 0xE7,
    0x00, 0x00, 0x9F, 0x40,
    0x00, 0x00, 0x8F, 0x30,
    0x00, 0x00, 0x02, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0035[ 44] =   // Code 0035, DIGIT FIVE
{
    0x00, 0x22, 0x22, 0x00,
    0x0C, 0xFF, 0xFF, 0x90,
    0x1F, 0xC9, 0x99, 0x40,
    0x3F, 0x50, 0x00, 0x00,
    0x6F, 0xCF, 0xFB, 0x10,
    0x5F, 0xA6, 0xBF, 0xB0,
    0x00, 0x00, 0x0E, 0xF1,
    0x37, 0x00, 0x0E, 0xF0,
    0x8F, 0xB6, 0xAF, 0xB0,
    0x1B, 0xFF, 0xFA, 0x10,
    0x00, 0x12, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0036[ 44] =   // Code 0036, DIGIT SIX
{
    0x00, 0x03, 0x41, 0x00,
    0x02, 0xCF, 0xFF, 0x80,
    0x0C, 0xF5, 0x3D, 0xF0,
    0x3F, 0x90, 0x01, 0x30,
    0x6F, 0x9B, 0xDB, 0x40,
    0x7F, 0xF9, 0x8E, 0xE2,
    0x7F, 0x90, 0x08, 0xF6,
    0x5F, 0x90, 0x08, 0xF6,
    0x0D, 0xE7, 0x6E, 0xF2,
    0x03, 0xDF, 0xFE, 0x50,
    0x00, 0x02, 0x20, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0037[ 44] =   // Code 0037, DIGIT SEVEN
{
    0x02, 0x22, 0x22, 0x10,
    0xCF, 0xFF, 0xFF, 0xF1,
    0x59, 0x99, 0xAF, 0xD0,
    0x00, 0x00, 0xAE, 0x20,
    0x00, 0x05, 0xF6, 0x00,
    0x00, 0x0D, 0xD0, 0x00,
    0x00, 0x6F, 0x70, 0x00,
    0x00, 0xCF, 0x20, 0x00,
    0x02, 0xFD, 0x00, 0x00,
    0x03, 0xF9, 0x00, 0x00,
    0x00, 0x20, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0038[ 44] =   // Code 0038, DIGIT EIGHT
{
    0x00, 0x13, 0x31, 0x00,
    0x06, 0xFF, 0xFE, 0x60,
    0x2F, 0xD3, 0x4D, 0xF1,
    0x3F, 0xA0, 0x0A, 0xF2,
    0x0B, 0xE8, 0x8F, 0xB0,
    0x09, 0xFD, 0xDF, 0x90,
    0x6F, 0xA0, 0x0B, 0xF5,
    0x7F, 0x60, 0x08, 0xF7,
    0x3F, 0xE6, 0x6E, 0xF3,
    0x06, 0xEF, 0xFE, 0x60,
    0x00, 0x02, 0x20, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0039[ 44] =   // Code 0039, DIGIT NINE
{
    0x00, 0x13, 0x30, 0x00,
    0x06, 0xFF, 0xFD, 0x30,
    0x3F, 0xD5, 0x5E, 0xD0,
    0x7F, 0x70, 0x0A, 0xF4,
    0x7F, 0x80, 0x0B, 0xF7,
    0x2E, 0xF9, 0xAF, 0xF7,
    0x03, 0xBD, 0xAA, 0xF5,
    0x04, 0x10, 0x0A, 0xF2,
    0x0F, 0xD4, 0x7F, 0xB0,
    0x07, 0xFF, 0xFB, 0x10,
    0x00, 0x12, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_003A[ 16] =   // Code 003A, COLON
{
    0x09, 0x90,
    0x1F, 0xF0,
    0x03, 0x30,
    0x00, 0x00,
    0x00, 0x00,
    0x0D, 0xD0,
    0x0D, 0xD0,
    0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_003B[ 18] =   // Code 003B, SEMICOLON
{
    0x09, 0x90,
    0x1F, 0xF0,
    0x03, 0x30,
    0x00, 0x00,
    0x00, 0x00,
    0x0D, 0xD0,
    0x0E, 0xF3,
    0x01, 0xD1,
    0x0B, 0x50
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_003C[ 28] =   // Code 003C, LESS-THAN SIGN
{
    0x00, 0x00, 0x28, 0xF6,
    0x00, 0x3A, 0xFF, 0xA2,
    0x3B, 0xFE, 0x82, 0x00,
    0x9F, 0xF5, 0x00, 0x00,
    0x06, 0xDF, 0xD7, 0x10,
    0x00, 0x05, 0xCF, 0xE4,
    0x00, 0x00, 0x03, 0x94
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_003D[ 20] =   // Code 003D, EQUALS SIGN
{
    0xAF, 0xFF, 0xFF, 0xF7,
    0x49, 0x99, 0x99, 0x93,
    0x00, 0x00, 0x00, 0x00,
    0x8D, 0xDD, 0xDD, 0xD6,
    0x59, 0x99, 0x99, 0x93
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_003E[ 28] =   // Code 003E, GREATER-THAN SIGN
{
    0x9E, 0x71, 0x00, 0x00,
    0x3B, 0xFF, 0x82, 0x00,
    0x00, 0x39, 0xFF, 0xA2,
    0x00, 0x00, 0x8F, 0xF7,
    0x02, 0x8E, 0xFB, 0x50,
    0x7F, 0xFA, 0x30, 0x00,
    0x58, 0x20, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_003F[ 44] =   // Code 003F, QUESTION MARK
{
    0x00, 0x57, 0x72, 0x00,
    0x0B, 0xFF, 0xFF, 0x50,
    0x5F, 0x90, 0x4F, 0xC0,
    0x39, 0x10, 0x3F, 0xD0,
    0x00, 0x03, 0xEF, 0x50,
    0x00, 0x2E, 0xE4, 0x00,
    0x00, 0x4F, 0x50, 0x00,
    0x00, 0x01, 0x00, 0x00,
    0x00, 0x5F, 0x60, 0x00,
    0x00, 0x5F, 0x70, 0x00,
    0x00, 0x01, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0040[ 55] =   // Code 0040, COMMERCIAL AT
{
    0x00, 0x03, 0x79, 0x73, 0x00,
    0x01, 0xBF, 0xB9, 0xBF, 0x90,
    0x0B, 0xE3, 0x13, 0x03, 0xE7,
    0x3F, 0x46, 0xFF, 0xCE, 0x6E,
    0x8E, 0x1F, 0x94, 0xDC, 0x2F,
    0x9C, 0x5F, 0x20, 0xAA, 0x3D,
    0x7E, 0x4F, 0x75, 0xE9, 0xB7,
    0x2F, 0x7B, 0xFD, 0xFF, 0x80,
    0x06, 0xF7, 0x30, 0x27, 0x80,
    0x00, 0x5D, 0xFF, 0xFC, 0x30,
    0x00, 0x00, 0x24, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0041[ 55] =   // Code 0041, LATIN CAPITAL LETTER A
{
    0x00, 0x05, 0x73, 0x00, 0x00,
    0x00, 0x1F, 0xFD, 0x00, 0x00,
    0x00, 0x7F, 0xFF, 0x30, 0x00,
    0x00, 0xCF, 0x7F, 0x90, 0x00,
    0x03, 0xFB, 0x1F, 0xE0, 0x00,
    0x09, 0xF7, 0x0B, 0xF4, 0x00,
    0x0E, 0xF9, 0x7B, 0xFA, 0x00,
    0x5F, 0xFF, 0xFF, 0xFF, 0x10,
    0xBF, 0x70, 0x00, 0xCF, 0x60,
    0xCF, 0x10, 0x00, 0x6F, 0x70,
    0x11, 0x00, 0x00, 0x02, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0042[ 40] =   // Code 0042, LATIN CAPITAL LETTER B
{
    0x36, 0x66, 0x63, 0x00,
    0xFF, 0xFF, 0xFF, 0xC1,
    0xFF, 0x54, 0x5E, 0xF6,
    0xFF, 0x20, 0x0A, 0xF6,
    0xFF, 0x87, 0x9F, 0xC1,
    0xFF, 0xDD, 0xEF, 0xD3,
    0xFF, 0x20, 0x08, 0xFB,
    0xFF, 0x20, 0x06, 0xFB,
    0xFF, 0xA9, 0xAF, 0xF7,
    0xCF, 0xFF, 0xFD, 0x80
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0043[ 55] =   // Code 0043, LATIN CAPITAL LETTER C
{
    0x00, 0x04, 0x89, 0x61, 0x00,
    0x01, 0xBF, 0xFF, 0xFE, 0x50,
    0x09, 0xFD, 0x42, 0x8F, 0xE0,
    0x1F, 0xF3, 0x00, 0x09, 0xA0,
    0x3F, 0xE0, 0x00, 0x00, 0x00,
    0x4F, 0xD0, 0x00, 0x00, 0x00,
    0x3F, 0xE0, 0x00, 0x02, 0x20,
    0x0E, 0xF6, 0x00, 0x1E, 0xF0,
    0x07, 0xFF, 0xA8, 0xDF, 0xB0,
    0x00, 0x7E, 0xFF, 0xFA, 0x10,
    0x00, 0x00, 0x33, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0044[ 50] =   // Code 0044, LATIN CAPITAL LETTER D
{
    0x36, 0x66, 0x52, 0x00, 0x00,
    0xFF, 0xFF, 0xFF, 0xB1, 0x00,
    0xFF, 0x76, 0x7D, 0xFA, 0x00,
    0xFF, 0x20, 0x03, 0xFF, 0x10,
    0xFF, 0x20, 0x00, 0xEF, 0x40,
    0xFF, 0x20, 0x00, 0xDF, 0x40,
    0xFF, 0x20, 0x00, 0xFF, 0x30,
    0xFF, 0x20, 0x07, 0xFE, 0x00,
    0xFF, 0xCB, 0xCF, 0xF5, 0x00,
    0xCF, 0xFF, 0xFB, 0x40, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0045[ 40] =   // Code 0045, LATIN CAPITAL LETTER E
{
    0x26, 0x66, 0x66, 0x51,
    0xEF, 0xFF, 0xFF, 0xF5,
    0xFF, 0x76, 0x66, 0x50,
    0xFF, 0x20, 0x00, 0x00,
    0xFF, 0xA9, 0x99, 0x50,
    0xFF, 0xFF, 0xFF, 0xA0,
    0xFF, 0x20, 0x00, 0x00,
    0xFF, 0x20, 0x00, 0x00,
    0xFF, 0xCB, 0xBB, 0xB3,
    0xBF, 0xFF, 0xFF, 0xF5
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0046[ 44] =   // Code 0046, LATIN CAPITAL LETTER F
{
    0x26, 0x66, 0x66, 0x40,
    0xEF, 0xFF, 0xFF, 0xF0,
    0xFF, 0x76, 0x66, 0x40,
    0xFF, 0x20, 0x00, 0x00,
    0xFF, 0x87, 0x77, 0x10,
    0xFF, 0xFF, 0xFF, 0x50,
    0xFF, 0x32, 0x22, 0x00,
    0xFF, 0x20, 0x00, 0x00,
    0xFF, 0x20, 0x00, 0x00,
    0xDF, 0x10, 0x00, 0x00,
    0x11, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0047[ 55] =   // Code 0047, LATIN CAPITAL LETTER G
{
    0x00, 0x03, 0x79, 0x73, 0x00,
    0x01, 0xBF, 0xFF, 0xFF, 0x80,
    0x09, 0xFD, 0x52, 0x5E, 0xF2,
    0x1F, 0xF3, 0x00, 0x04, 0x80,
    0x4F, 0xE0, 0x00, 0x00, 0x00,
    0x4F, 0xD0, 0x08, 0xFF, 0xF8,
    0x3F, 0xE0, 0x04, 0x9B, 0xF9,
    0x0E, 0xF6, 0x00, 0x09, 0xF9,
    0x07, 0xFF, 0x96, 0xAF, 0xF9,
    0x00, 0x7E, 0xFF, 0xF7, 0xC9,
    0x00, 0x00, 0x33, 0x10, 0x11
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0048[ 55] =   // Code 0048, LATIN CAPITAL LETTER H
{
    0x56, 0x00, 0x00, 0x56, 0x00,
    0xFF, 0x20, 0x00, 0xFF, 0x20,
    0xFF, 0x20, 0x00, 0xFF, 0x20,
    0xFF, 0x20, 0x00, 0xFF, 0x20,
    0xFF, 0xDD, 0xDD, 0xFF, 0x20,
    0xFF, 0xFF, 0xFF, 0xFF, 0x20,
    0xFF, 0x20, 0x00, 0xFF, 0x20,
    0xFF, 0x20, 0x00, 0xFF, 0x20,
    0xFF, 0x20, 0x00, 0xFF, 0x20,
    0xDE, 0x10, 0x00, 0xDE, 0x10,
    0x11, 0x00, 0x00, 0x11, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0049[ 22] =   // Code 0049, LATIN CAPITAL LETTER I
{
    0x56, 0x00,
    0xFF, 0x20,
    0xFF, 0x20,
    0xFF, 0x20,
    0xFF, 0x20,
    0xFF, 0x20,
    0xFF, 0x20,
    0xFF, 0x20,
    0xFF, 0x20,
    0xDE, 0x10,
    0x11, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_004A[ 44] =   // Code 004A, LATIN CAPITAL LETTER J
{
    0x00, 0x00, 0x27, 0x10,
    0x00, 0x00, 0x9F, 0x70,
    0x00, 0x00, 0x9F, 0x70,
    0x00, 0x00, 0x9F, 0x70,
    0x00, 0x00, 0x9F, 0x70,
    0x00, 0x00, 0x9F, 0x70,
    0x4A, 0x00, 0x9F, 0x70,
    0xBF, 0x30, 0xAF, 0x70,
    0x9F, 0xB7, 0xFF, 0x30,
    0x1C, 0xFF, 0xF8, 0x00,
    0x00, 0x33, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_004B[ 44] =   // Code 004B, LATIN CAPITAL LETTER K
{
    0x56, 0x00, 0x02, 0x71,
    0xFF, 0x20, 0x2E, 0xF4,
    0xFF, 0x21, 0xDF, 0x80,
    0xFF, 0x3C, 0xF9, 0x00,
    0xFF, 0xDF, 0xE1, 0x00,
    0xFF, 0xFF, 0xF8, 0x00,
    0xFF, 0x84, 0xFF, 0x30,
    0xFF, 0x20, 0x9F, 0xD0,
    0xFF, 0x20, 0x1D, 0xF8,
    0xDE, 0x10, 0x05, 0xFA,
    0x11, 0x00, 0x00, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_004C[ 40] =   // Code 004C, LATIN CAPITAL LETTER L
{
    0x56, 0x00, 0x00, 0x00,
    0xFF, 0x20, 0x00, 0x00,
    0xFF, 0x20, 0x00, 0x00,
    0xFF, 0x20, 0x00, 0x00,
    0xFF, 0x20, 0x00, 0x00,
    0xFF, 0x20, 0x00, 0x00,
    0xFF, 0x20, 0x00, 0x00,
    0xFF, 0x20, 0x00, 0x00,
    0xFF, 0xCB, 0xBB, 0x70,
    0xCF, 0xFF, 0xFF, 0x90
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_004D[ 55] =   // Code 004D, LATIN CAPITAL LETTER M
{
    0x67, 0x40, 0x00, 0x07, 0x72,
    0xFF, 0xE0, 0x00, 0x5F, 0xF9,
    0xFF, 0xF4, 0x00, 0xAF, 0xF9,
    0xFE, 0xF8, 0x00, 0xED, 0xF9,
    0xFD, 0xBD, 0x04, 0xF8, 0xF9,
    0xFD, 0x7F, 0x39, 0xE4, 0xF9,
    0xFD, 0x2F, 0x7D, 0xA4, 0xF9,
    0xFD, 0x0C, 0xEF, 0x54, 0xF9,
    0xFD, 0x07, 0xFF, 0x14, 0xF9,
    0xEB, 0x02, 0xFA, 0x03, 0xF8,
    0x11, 0x00, 0x10, 0x00, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_004E[ 55] =   // Code 004E, LATIN CAPITAL LETTER N
{
    0x57, 0x10, 0x00, 0x57, 0x00,
    0xFF, 0xA0, 0x00, 0xDF, 0x20,
    0xFF, 0xF4, 0x00, 0xDF, 0x20,
    0xFF, 0xFD, 0x00, 0xDF, 0x20,
    0xFF, 0x7F, 0x70, 0xDF, 0x20,
    0xFF, 0x0D, 0xF2, 0xDF, 0x20,
    0xFF, 0x03, 0xFB, 0xDF, 0x20,
    0xFF, 0x00, 0x9F, 0xFF, 0x20,
    0xFF, 0x00, 0x1D, 0xFF, 0x20,
    0xEE, 0x00, 0x05, 0xFE, 0x10,
    0x11, 0x00, 0x00, 0x11, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_004F[ 55] =   // Code 004F, LATIN CAPITAL LETTER O
{
    0x00, 0x04, 0x89, 0x72, 0x00,
    0x01, 0xCF, 0xFF, 0xFF, 0x80,
    0x0B, 0xFC, 0x42, 0x6E, 0xF5,
    0x3F, 0xF1, 0x00, 0x07, 0xFB,
    0x6F, 0xB0, 0x00, 0x02, 0xFF,
    0x6F, 0xB0, 0x00, 0x02, 0xFF,
    0x5F, 0xD0, 0x00, 0x04, 0xFD,
    0x1F, 0xF4, 0x00, 0x0A, 0xF9,
    0x07, 0xFF, 0x97, 0xCF, 0xE2,
    0x00, 0x7E, 0xFF, 0xFB, 0x20,
    0x00, 0x00, 0x33, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0050[ 44] =   // Code 0050, LATIN CAPITAL LETTER P
{
    0x36, 0x66, 0x63, 0x00,
    0xFF, 0xFF, 0xFF, 0xC1,
    0xFF, 0x54, 0x5D, 0xF8,
    0xFF, 0x20, 0x06, 0xFB,
    0xFF, 0x32, 0x2B, 0xF9,
    0xFF, 0xFF, 0xFF, 0xE2,
    0xFF, 0xA9, 0x87, 0x10,
    0xFF, 0x20, 0x00, 0x00,
    0xFF, 0x20, 0x00, 0x00,
    0xDE, 0x10, 0x00, 0x00,
    0x11, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0051[ 55] =   // Code 0051, LATIN CAPITAL LETTER Q
{
    0x00, 0x04, 0x89, 0x72, 0x00,
    0x01, 0xCF, 0xFF, 0xFF, 0x80,
    0x0B, 0xFC, 0x42, 0x6E, 0xF5,
    0x3F, 0xF1, 0x00, 0x07, 0xFB,
    0x6F, 0xB0, 0x00, 0x02, 0xFF,
    0x6F, 0xB0, 0x00, 0x02, 0xFF,
    0x5F, 0xD0, 0x03, 0x34, 0xFE,
    0x1F, 0xF4, 0x09, 0xFC, 0xF9,
    0x07, 0xFF, 0x98, 0xFF, 0xE2,
    0x00, 0x7E, 0xFF, 0xFD, 0xF6,
    0x00, 0x00, 0x33, 0x10, 0x76
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0052[ 44] =   // Code 0052, LATIN CAPITAL LETTER R
{
    0x36, 0x66, 0x65, 0x10,
    0xFF, 0xFF, 0xFF, 0xF5,
    0xFF, 0x54, 0x4A, 0xFD,
    0xFF, 0x20, 0x02, 0xFF,
    0xFF, 0x54, 0x49, 0xFA,
    0xFF, 0xFF, 0xFF, 0xD1,
    0xFF, 0x76, 0x6D, 0xF8,
    0xFF, 0x20, 0x06, 0xFA,
    0xFF, 0x20, 0x05, 0xFC,
    0xDE, 0x10, 0x02, 0xFD,
    0x11, 0x00, 0x00, 0x11
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0053[ 55] =   // Code 0053, LATIN CAPITAL LETTER S
{
    0x00, 0x48, 0x97, 0x10, 0x00,
    0x0A, 0xFF, 0xFF, 0xF6, 0x00,
    0x4F, 0xD3, 0x26, 0xFE, 0x00,
    0x6F, 0xC0, 0x00, 0x44, 0x00,
    0x2F, 0xFE, 0xB8, 0x30, 0x00,
    0x03, 0xBF, 0xFF, 0xFA, 0x00,
    0x00, 0x00, 0x48, 0xFF, 0x30,
    0x4F, 0x50, 0x00, 0xCF, 0x50,
    0x3F, 0xF8, 0x69, 0xFE, 0x10,
    0x06, 0xEF, 0xFF, 0xD4, 0x00,
    0x00, 0x02, 0x42, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0054[ 55] =   // Code 0054, LATIN CAPITAL LETTER T
{
    0x26, 0x66, 0x66, 0x65, 0x10,
    0xCF, 0xFF, 0xFF, 0xFF, 0x70,
    0x37, 0x7D, 0xFA, 0x76, 0x10,
    0x00, 0x0B, 0xF6, 0x00, 0x00,
    0x00, 0x0B, 0xF6, 0x00, 0x00,
    0x00, 0x0B, 0xF6, 0x00, 0x00,
    0x00, 0x0B, 0xF6, 0x00, 0x00,
    0x00, 0x0B, 0xF6, 0x00, 0x00,
    0x00, 0x0B, 0xF6, 0x00, 0x00,
    0x00, 0x09, 0xF4, 0x00, 0x00,
    0x00, 0x00, 0x20, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0055[ 55] =   // Code 0055, LATIN CAPITAL LETTER U
{
    0x56, 0x00, 0x00, 0x56, 0x00,
    0xFF, 0x20, 0x00, 0xFF, 0x20,
    0xFF, 0x20, 0x00, 0xFF, 0x20,
    0xFF, 0x20, 0x00, 0xFF, 0x20,
    0xFF, 0x20, 0x00, 0xFF, 0x20,
    0xFF, 0x20, 0x00, 0xFF, 0x20,
    0xFF, 0x20, 0x00, 0xFF, 0x20,
    0xEF, 0x40, 0x02, 0xFF, 0x10,
    0x8F, 0xE8, 0x8D, 0xFA, 0x00,
    0x09, 0xFF, 0xFF, 0xA1, 0x00,
    0x00, 0x13, 0x31, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0056[ 55] =   // Code 0056, LATIN CAPITAL LETTER V
{
    0x57, 0x00, 0x00, 0x37, 0x10,
    0xDF, 0x50, 0x00, 0xCF, 0x40,
    0x9F, 0x90, 0x02, 0xFE, 0x10,
    0x3F, 0xE0, 0x07, 0xFA, 0x00,
    0x0D, 0xF3, 0x0B, 0xF4, 0x00,
    0x08, 0xF8, 0x1F, 0xD0, 0x00,
    0x02, 0xFC, 0x6F, 0x80, 0x00,
    0x00, 0xCF, 0xCF, 0x30, 0x00,
    0x00, 0x7F, 0xFC, 0x00, 0x00,
    0x00, 0x2E, 0xF6, 0x00, 0x00,
    0x00, 0x01, 0x20, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0057[ 66] =   // Code 0057, LATIN CAPITAL LETTER W
{
    0x46, 0x00, 0x06, 0x70, 0x00, 0x64,
    0xDF, 0x20, 0x2F, 0xF3, 0x01, 0xFD,
    0xAF, 0x60, 0x6F, 0xF7, 0x05, 0xFA,
    0x6F, 0x90, 0x9E, 0xEA, 0x08, 0xF7,
    0x2F, 0xC0, 0xDB, 0xAE, 0x0B, 0xF3,
    0x0E, 0xF2, 0xF7, 0x7F, 0x2E, 0xE0,
    0x09, 0xF7, 0xF4, 0x3F, 0x7F, 0xA0,
    0x06, 0xFE, 0xF0, 0x0E, 0xEF, 0x60,
    0x02, 0xFF, 0xB0, 0x0B, 0xFF, 0x20,
    0x00, 0xCF, 0x70, 0x06, 0xFD, 0x00,
    0x00, 0x12, 0x00, 0x00, 0x21, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0058[ 44] =   // Code 0058, LATIN CAPITAL LETTER X
{
    0x27, 0x10, 0x02, 0x71,
    0x8F, 0xA0, 0x0B, 0xF6,
    0x2F, 0xF3, 0x6F, 0xD1,
    0x07, 0xFC, 0xEF, 0x30,
    0x00, 0xCF, 0xF8, 0x00,
    0x00, 0x8F, 0xF5, 0x00,
    0x04, 0xFF, 0xFD, 0x10,
    0x1D, 0xF6, 0xBF, 0x90,
    0x9F, 0xC0, 0x2F, 0xF4,
    0xBF, 0x30, 0x08, 0xF7,
    0x11, 0x00, 0x00, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0059[ 44] =   // Code 0059, LATIN CAPITAL LETTER Y
{
    0x47, 0x00, 0x00, 0x74,
    0xDF, 0x60, 0x06, 0xFC,
    0x6F, 0xD0, 0x0D, 0xF5,
    0x0C, 0xF7, 0x7F, 0xB0,
    0x03, 0xFE, 0xEF, 0x30,
    0x00, 0x9F, 0xF8, 0x00,
    0x00, 0x2F, 0xF1, 0x00,
    0x00, 0x2F, 0xF0, 0x00,
    0x00, 0x2F, 0xF0, 0x00,
    0x00, 0x1E, 0xE0, 0x00,
    0x00, 0x01, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_005A[ 50] =   // Code 005A, LATIN CAPITAL LETTER Z
{
    0x04, 0x66, 0x66, 0x65, 0x10,
    0x3F, 0xFF, 0xFF, 0xFF, 0x60,
    0x05, 0x77, 0x7D, 0xFE, 0x20,
    0x00, 0x00, 0x5F, 0xF3, 0x00,
    0x00, 0x03, 0xFF, 0x60, 0x00,
    0x00, 0x2E, 0xF8, 0x00, 0x00,
    0x01, 0xDF, 0xA0, 0x00, 0x00,
    0x0B, 0xFC, 0x10, 0x00, 0x00,
    0x7F, 0xFC, 0xBB, 0xBB, 0x40,
    0x7F, 0xFF, 0xFF, 0xFF, 0x50
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_005B[ 26] =   // Code 005B, LEFT SQUARE BRACKET
{
    0x36, 0x62,
    0xDF, 0xF7,
    0xDD, 0x00,
    0xDD, 0x00,
    0xDD, 0x00,
    0xDD, 0x00,
    0xDD, 0x00,
    0xDD, 0x00,
    0xDD, 0x00,
    0xDD, 0x00,
    0xDD, 0x00,
    0xDF, 0xF7,
    0x36, 0x62
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_005C[ 33] =   // Code 005C, REVERSE SOLIDUS
{
    0x73, 0x00, 0x00,
    0xCB, 0x00, 0x00,
    0x6F, 0x20, 0x00,
    0x1F, 0x70, 0x00,
    0x0A, 0xD0, 0x00,
    0x04, 0xF3, 0x00,
    0x00, 0xD9, 0x00,
    0x00, 0x8E, 0x00,
    0x00, 0x2F, 0x60,
    0x00, 0x0B, 0xA0,
    0x00, 0x01, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_005D[ 26] =   // Code 005D, RIGHT SQUARE BRACKET
{
    0x46, 0x51,
    0xEF, 0xF6,
    0x04, 0xF7,
    0x04, 0xF7,
    0x04, 0xF7,
    0x04, 0xF7,
    0x04, 0xF7,
    0x04, 0xF7,
    0x04, 0xF7,
    0x04, 0xF7,
    0x04, 0xF7,
    0xEF, 0xF6,
    0x46, 0x51
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_005E[ 28] =   // Code 005E, CIRCUMFLEX ACCENT
{
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x1D, 0xB0, 0x00,
    0x00, 0x7F, 0xF5, 0x00,
    0x01, 0xF9, 0xCD, 0x00,
    0x09, 0xF1, 0x4F, 0x60,
    0x1F, 0x70, 0x0A, 0xD0,
    0x02, 0x00, 0x00, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_005F[  4] =   // Code 005F, LOW LINE
{
    0x39, 0x99, 0x99, 0x98
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0060[  6] =   // Code 0060, GRAVE ACCENT
{
    0xC7, 0x00,
    0x8F, 0xA0,
    0x03, 0x60
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0061[ 32] =   // Code 0061, LATIN SMALL LETTER A
{
    0x03, 0xBE, 0xEC, 0x40,
    0x0E, 0xE8, 0x8F, 0xE0,
    0x06, 0x20, 0x2E, 0xF2,
    0x07, 0xCF, 0xFF, 0xF2,
    0x5F, 0xB3, 0x1D, 0xF2,
    0x7F, 0xA2, 0x6F, 0xF2,
    0x1C, 0xFF, 0xAA, 0xF3,
    0x00, 0x21, 0x00, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0062[ 44] =   // Code 0062, LATIN SMALL LETTER B
{
    0x07, 0x30, 0x00, 0x00,
    0x4F, 0x90, 0x00, 0x00,
    0x4F, 0x90, 0x00, 0x00,
    0x4F, 0xBB, 0xFC, 0x30,
    0x4F, 0xFA, 0x9F, 0xE1,
    0x4F, 0xB0, 0x09, 0xF5,
    0x4F, 0x80, 0x06, 0xF7,
    0x4F, 0xA0, 0x08, 0xF6,
    0x4F, 0xF7, 0x7E, 0xF2,
    0x3F, 0xAE, 0xFE, 0x50,
    0x02, 0x00, 0x20, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0063[ 32] =   // Code 0063, LATIN SMALL LETTER C
{
    0x03, 0xBE, 0xE9, 0x10,
    0x1E, 0xF9, 0xAF, 0xA0,
    0x7F, 0x80, 0x07, 0x50,
    0x9F, 0x40, 0x00, 0x00,
    0x8F, 0x60, 0x05, 0x40,
    0x3F, 0xE6, 0x7F, 0xA0,
    0x06, 0xEF, 0xFC, 0x20,
    0x00, 0x02, 0x20, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0064[ 44] =   // Code 0064, LATIN SMALL LETTER D
{
    0x00, 0x00, 0x03, 0x70,
    0x00, 0x00, 0x0B, 0xF3,
    0x00, 0x00, 0x0B, 0xF4,
    0x04, 0xCF, 0xAC, 0xF4,
    0x1E, 0xF9, 0xAF, 0xF4,
    0x6F, 0x90, 0x0C, 0xF4,
    0x7F, 0x60, 0x09, 0xF4,
    0x7F, 0x70, 0x0B, 0xF4,
    0x2F, 0xE7, 0x7F, 0xF4,
    0x06, 0xFF, 0xEA, 0xF2,
    0x00, 0x12, 0x00, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0065[ 32] =   // Code 0065, LATIN SMALL LETTER E
{
    0x02, 0xAE, 0xEB, 0x20,
    0x0D, 0xE7, 0x7E, 0xE1,
    0x6F, 0x82, 0x28, 0xF6,
    0x7F, 0xFF, 0xFF, 0xF6,
    0x7F, 0x70, 0x00, 0x30,
    0x2E, 0xE7, 0x6C, 0xF1,
    0x04, 0xDF, 0xFE, 0x70,
    0x00, 0x02, 0x20, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0066[ 33] =   // Code 0066, LATIN SMALL LETTER F
{
    0x00, 0x69, 0x30,
    0x07, 0xFF, 0x90,
    0x09, 0xF4, 0x00,
    0x9E, 0xFC, 0x70,
    0x4C, 0xF9, 0x30,
    0x09, 0xF4, 0x00,
    0x09, 0xF4, 0x00,
    0x09, 0xF4, 0x00,
    0x09, 0xF4, 0x00,
    0x08, 0xF3, 0x00,
    0x00, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0067[ 40] =   // Code 0067, LATIN SMALL LETTER G
{
    0x03, 0xCF, 0xB7, 0xE1,
    0x1E, 0xF9, 0xAF, 0xF4,
    0x6F, 0x80, 0x0C, 0xF4,
    0x7F, 0x60, 0x09, 0xF4,
    0x7F, 0x80, 0x0C, 0xF4,
    0x1E, 0xFA, 0xBF, 0xF4,
    0x03, 0xAB, 0x8A, 0xF3,
    0x08, 0x30, 0x0C, 0xF1,
    0x0E, 0xFA, 0xCF, 0x90,
    0x02, 0x9B, 0xB7, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0068[ 44] =   // Code 0068, LATIN SMALL LETTER H
{
    0x07, 0x30, 0x00, 0x00,
    0x4F, 0x90, 0x00, 0x00,
    0x4F, 0x90, 0x00, 0x00,
    0x4F, 0xAA, 0xED, 0x50,
    0x4F, 0xFB, 0xAF, 0xF1,
    0x4F, 0xC0, 0x0C, 0xF3,
    0x4F, 0x90, 0x0B, 0xF4,
    0x4F, 0x90, 0x0B, 0xF4,
    0x4F, 0x90, 0x0B, 0xF4,
    0x3F, 0x90, 0x0A, 0xF2,
    0x02, 0x00, 0x00, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0069[ 22] =   // Code 0069, LATIN SMALL LETTER I
{
    0x07, 0x40,
    0x2F, 0xB0,
    0x04, 0x20,
    0x1E, 0x80,
    0x2F, 0xB0,
    0x2F, 0xB0,
    0x2F, 0xB0,
    0x2F, 0xB0,
    0x2F, 0xB0,
    0x1F, 0xA0,
    0x01, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_006A[ 26] =   // Code 006A, LATIN SMALL LETTER J
{
    0x00, 0x74,
    0x02, 0xFB,
    0x00, 0x42,
    0x01, 0xE8,
    0x02, 0xFB,
    0x02, 0xFB,
    0x02, 0xFB,
    0x02, 0xFB,
    0x02, 0xFB,
    0x02, 0xFB,
    0x02, 0xFB,
    0x2C, 0xFA,
    0x19, 0x92
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_006B[ 44] =   // Code 006B, LATIN SMALL LETTER K
{
    0x07, 0x30, 0x00, 0x00,
    0x4F, 0x90, 0x00, 0x00,
    0x4F, 0x90, 0x00, 0x00,
    0x4F, 0x90, 0x5E, 0x30,
    0x4F, 0x94, 0xFE, 0x20,
    0x4F, 0xCE, 0xE3, 0x00,
    0x4F, 0xFF, 0xE2, 0x00,
    0x4F, 0xD8, 0xFC, 0x00,
    0x4F, 0x90, 0xBF, 0x80,
    0x3F, 0x90, 0x2E, 0xB0,
    0x01, 0x00, 0x01, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_006C[ 22] =   // Code 006C, LATIN SMALL LETTER L
{
    0x07, 0x40,
    0x2F, 0xB0,
    0x2F, 0xB0,
    0x2F, 0xB0,
    0x2F, 0xB0,
    0x2F, 0xB0,
    0x2F, 0xB0,
    0x2F, 0xB0,
    0x2F, 0xB0,
    0x1F, 0xA0,
    0x01, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_006D[ 48] =   // Code 006D, LATIN SMALL LETTER M
{
    0x2E, 0x69, 0xED, 0x38, 0xEE, 0x70,
    0x4F, 0xEB, 0xBF, 0xED, 0xAF, 0xF3,
    0x4F, 0xC0, 0x0F, 0xF2, 0x0A, 0xF4,
    0x4F, 0x90, 0x0F, 0xF0, 0x09, 0xF4,
    0x4F, 0x90, 0x0F, 0xF0, 0x09, 0xF4,
    0x4F, 0x90, 0x0F, 0xF0, 0x09, 0xF4,
    0x3F, 0x90, 0x0D, 0xE0, 0x08, 0xF3,
    0x02, 0x00, 0x01, 0x10, 0x00, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_006E[ 32] =   // Code 006E, LATIN SMALL LETTER N
{
    0x2E, 0x6A, 0xED, 0x50,
    0x4F, 0xFB, 0xAF, 0xF1,
    0x4F, 0xC0, 0x0C, 0xF3,
    0x4F, 0x90, 0x0B, 0xF4,
    0x4F, 0x90, 0x0B, 0xF4,
    0x4F, 0x90, 0x0B, 0xF4,
    0x3F, 0x90, 0x0A, 0xF2,
    0x02, 0x00, 0x00, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_006F[ 32] =   // Code 006F, LATIN SMALL LETTER O
{
    0x02, 0xBE, 0xEA, 0x20,
    0x1D, 0xF8, 0x8F, 0xD0,
    0x6F, 0x80, 0x09, 0xF5,
    0x7F, 0x60, 0x06, 0xF7,
    0x7F, 0x70, 0x08, 0xF6,
    0x2F, 0xE5, 0x5E, 0xF2,
    0x05, 0xEF, 0xFE, 0x40,
    0x00, 0x02, 0x20, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0070[ 40] =   // Code 0070, LATIN SMALL LETTER P
{
    0x2E, 0x7B, 0xFC, 0x30,
    0x4F, 0xFA, 0x9F, 0xE1,
    0x4F, 0xB0, 0x0A, 0xF5,
    0x4F, 0x80, 0x06, 0xF7,
    0x4F, 0xA0, 0x08, 0xF6,
    0x4F, 0xF7, 0x7E, 0xF2,
    0x4F, 0xBD, 0xFF, 0x50,
    0x4F, 0x90, 0x21, 0x00,
    0x4F, 0x90, 0x00, 0x00,
    0x19, 0x40, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0071[ 40] =   // Code 0071, LATIN SMALL LETTER Q
{
    0x03, 0xCF, 0xB7, 0xE1,
    0x1E, 0xF9, 0xAF, 0xF4,
    0x6F, 0x90, 0x0C, 0xF4,
    0x7F, 0x60, 0x09, 0xF4,
    0x7F, 0x70, 0x0B, 0xF4,
    0x3F, 0xE6, 0x7F, 0xF4,
    0x06, 0xFF, 0xDD, 0xF4,
    0x00, 0x12, 0x0B, 0xF4,
    0x00, 0x00, 0x0B, 0xF3,
    0x00, 0x00, 0x05, 0x90
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0072[ 24] =   // Code 0072, LATIN SMALL LETTER R
{
    0x1E, 0x7B, 0xE1,
    0x2F, 0xEE, 0xC1,
    0x2F, 0xE1, 0x00,
    0x2F, 0xB0, 0x00,
    0x2F, 0xB0, 0x00,
    0x2F, 0xB0, 0x00,
    0x1F, 0xA0, 0x00,
    0x01, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0073[ 32] =   // Code 0073, LATIN SMALL LETTER S
{
    0x08, 0xDF, 0xC7, 0x00,
    0x6F, 0xB7, 0xCF, 0x20,
    0x7F, 0xB4, 0x13, 0x00,
    0x2C, 0xFF, 0xFA, 0x10,
    0x13, 0x36, 0xCF, 0x70,
    0x7F, 0x72, 0x9F, 0x60,
    0x1B, 0xFF, 0xFA, 0x00,
    0x00, 0x12, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0074[ 30] =   // Code 0074, LATIN SMALL LETTER T
{
    0x08, 0xC1, 0x00,
    0x0B, 0xF2, 0x00,
    0x9E, 0xFC, 0x60,
    0x4D, 0xF8, 0x30,
    0x0B, 0xF2, 0x00,
    0x0B, 0xF2, 0x00,
    0x0B, 0xF2, 0x00,
    0x0B, 0xF7, 0x20,
    0x07, 0xFF, 0x70,
    0x00, 0x12, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0075[ 32] =   // Code 0075, LATIN SMALL LETTER U
{
    0x2E, 0x70, 0x08, 0xE1,
    0x4F, 0x90, 0x0B, 0xF4,
    0x4F, 0x90, 0x0B, 0xF4,
    0x4F, 0x90, 0x0B, 0xF4,
    0x4F, 0xA0, 0x0C, 0xF4,
    0x2F, 0xF7, 0x9F, 0xF4,
    0x08, 0xFF, 0xC8, 0xF2,
    0x00, 0x12, 0x00, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0076[ 32] =   // Code 0076, LATIN SMALL LETTER V
{
    0xBB, 0x00, 0x4E, 0x30,
    0xCF, 0x20, 0xAF, 0x40,
    0x7F, 0x70, 0xEE, 0x00,
    0x1F, 0xB4, 0xF9, 0x00,
    0x0B, 0xF9, 0xF3, 0x00,
    0x05, 0xFF, 0xD0, 0x00,
    0x01, 0xEF, 0x70, 0x00,
    0x00, 0x12, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0077[ 40] =   // Code 0077, LATIN SMALL LETTER W
{
    0x9C, 0x00, 0xCD, 0x10, 0xBB,
    0xBF, 0x23, 0xFF, 0x51, 0xFC,
    0x7F, 0x66, 0xFE, 0x84, 0xF8,
    0x2F, 0xA9, 0xCA, 0xC7, 0xF3,
    0x0C, 0xDC, 0x87, 0xFB, 0xE0,
    0x08, 0xFF, 0x43, 0xFF, 0x90,
    0x03, 0xFE, 0x10, 0xDF, 0x40,
    0x00, 0x11, 0x00, 0x12, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0078[ 24] =   // Code 0078, LATIN SMALL LETTER X
{
    0x6E, 0x20, 0xAC,
    0x6F, 0xB5, 0xFB,
    0x0B, 0xFE, 0xE2,
    0x03, 0xFF, 0x80,
    0x0B, 0xFF, 0xE2,
    0x6F, 0xA7, 0xFB,
    0xBE, 0x20, 0xCE,
    0x01, 0x00, 0x11
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0079[ 40] =   // Code 0079, LATIN SMALL LETTER Y
{
    0xAC, 0x00, 0x5E, 0x30,
    0xBF, 0x40, 0xBF, 0x30,
    0x6F, 0x80, 0xED, 0x00,
    0x1F, 0xC4, 0xF7, 0x00,
    0x0A, 0xF9, 0xF2, 0x00,
    0x05, 0xFF, 0xC0, 0x00,
    0x00, 0xEF, 0x70, 0x00,
    0x00, 0xBF, 0x10, 0x00,
    0x4F, 0xFA, 0x00, 0x00,
    0x19, 0x81, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_007A[ 28] =   // Code 007A, LATIN SMALL LETTER Z
{
    0x2B, 0xBB, 0xBB, 0x70,
    0x2A, 0xBB, 0xFF, 0x90,
    0x00, 0x08, 0xFA, 0x00,
    0x00, 0x7F, 0xB1, 0x00,
    0x06, 0xFD, 0x10, 0x00,
    0x4F, 0xF9, 0x77, 0x50,
    0x7F, 0xFF, 0xFF, 0xB0
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_007B[ 39] =   // Code 007B, LEFT CURLY BRACKET
{
    0x00, 0x46, 0x20,
    0x08, 0xFE, 0x50,
    0x0B, 0xF0, 0x00,
    0x0B, 0xF0, 0x00,
    0x0B, 0xF0, 0x00,
    0x1C, 0xF0, 0x00,
    0xEF, 0x70, 0x00,
    0x1C, 0xF0, 0x00,
    0x0B, 0xF0, 0x00,
    0x0B, 0xF0, 0x00,
    0x0B, 0xF0, 0x00,
    0x08, 0xFC, 0x50,
    0x00, 0x56, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_007C[ 22] =   // Code 007C, VERTICAL LINE
{
    0x18, 0x00,
    0x6F, 0x40,
    0x6F, 0x40,
    0x6F, 0x40,
    0x6F, 0x40,
    0x6F, 0x40,
    0x6F, 0x40,
    0x6F, 0x40,
    0x6F, 0x40,
    0x5F, 0x30,
    0x03, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_007D[ 39] =   // Code 007D, RIGHT CURLY BRACKET
{
    0x46, 0x30, 0x00,
    0xBE, 0xF2, 0x00,
    0x08, 0xF4, 0x00,
    0x07, 0xF4, 0x00,
    0x07, 0xF4, 0x00,
    0x06, 0xF6, 0x00,
    0x00, 0xCF, 0x70,
    0x06, 0xF7, 0x00,
    0x07, 0xF4, 0x00,
    0x07, 0xF4, 0x00,
    0x07, 0xF4, 0x00,
    0xAE, 0xF2, 0x00,
    0x56, 0x30, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_007E[ 12] =   // Code 007E, TILDE
{
    0x0A, 0xDA, 0x41, 0xA2,
    0x6F, 0xAE, 0xFF, 0xE2,
    0x23, 0x00, 0x67, 0x30
};

GUI_CONST_STORAGE GUI_CHARINFO_EXT GUI_FontRounded16_CharInfo[95] =
{
    {   1,   1,   0,  13,   4, acGUI_FontRounded16_0020 } // Code 0020, SPACE
    , {   3,  11,   1,   3,   4, acGUI_FontRounded16_0021 } // Code 0021, EXCLAMATION MARK
    , {   5,   5,   1,   3,   7, acGUI_FontRounded16_0022 } // Code 0022, QUOTATION MARK
    , {   8,  11,   0,   3,   8, acGUI_FontRounded16_0023 } // Code 0023, NUMBER SIGN
    , {   8,  12,   0,   3,   8, acGUI_FontRounded16_0024 } // Code 0024, DOLLAR SIGN
    , {  11,  11,   1,   3,  13, acGUI_FontRounded16_0025 } // Code 0025, PERCENT SIGN
    , {   9,  11,   0,   3,   9, acGUI_FontRounded16_0026 } // Code 0026, AMPERSAND
    , {   2,   5,   1,   3,   4, acGUI_FontRounded16_0027 } // Code 0027, APOSTROPHE
    , {   4,  13,   0,   3,   4, acGUI_FontRounded16_0028 } // Code 0028, LEFT PARENTHESIS
    , {   4,  13,   0,   3,   4, acGUI_FontRounded16_0029 } // Code 0029, RIGHT PARENTHESIS
    , {   6,   6,   0,   3,   6, acGUI_FontRounded16_002A } // Code 002A, ASTERISK
    , {   8,   8,   0,   5,   8, acGUI_FontRounded16_002B } // Code 002B, PLUS SIGN
    , {   4,   4,   0,  11,   4, acGUI_FontRounded16_002C } // Code 002C, COMMA
    , {   5,   3,   0,   8,   5, acGUI_FontRounded16_002D } // Code 002D, HYPHEN-MINUS
    , {   4,   3,   0,  11,   4, acGUI_FontRounded16_002E } // Code 002E, FULL STOP
    , {   5,  11,   0,   3,   5, acGUI_FontRounded16_002F } // Code 002F, SOLIDUS
    , {   8,  11,   0,   3,   8, acGUI_FontRounded16_0030 } // Code 0030, DIGIT ZERO
    , {   6,  11,  -1,   3,   5, acGUI_FontRounded16_0031 } // Code 0031, DIGIT ONE
    , {   8,  10,   0,   3,   8, acGUI_FontRounded16_0032 } // Code 0032, DIGIT TWO
    , {   8,  11,   0,   3,   8, acGUI_FontRounded16_0033 } // Code 0033, DIGIT THREE
    , {   8,  11,   0,   3,   8, acGUI_FontRounded16_0034 } // Code 0034, DIGIT FOUR
    , {   8,  11,   0,   3,   8, acGUI_FontRounded16_0035 } // Code 0035, DIGIT FIVE
    , {   8,  11,   0,   3,   8, acGUI_FontRounded16_0036 } // Code 0036, DIGIT SIX
    , {   8,  11,   0,   3,   7, acGUI_FontRounded16_0037 } // Code 0037, DIGIT SEVEN
    , {   8,  11,   0,   3,   8, acGUI_FontRounded16_0038 } // Code 0038, DIGIT EIGHT
    , {   8,  11,   0,   3,   8, acGUI_FontRounded16_0039 } // Code 0039, DIGIT NINE
    , {   4,   8,   0,   6,   4, acGUI_FontRounded16_003A } // Code 003A, COLON
    , {   4,   9,   0,   6,   4, acGUI_FontRounded16_003B } // Code 003B, SEMICOLON
    , {   8,   7,   0,   6,   8, acGUI_FontRounded16_003C } // Code 003C, LESS-THAN SIGN
    , {   8,   5,   0,   7,   8, acGUI_FontRounded16_003D } // Code 003D, EQUALS SIGN
    , {   8,   7,   0,   6,   8, acGUI_FontRounded16_003E } // Code 003E, GREATER-THAN SIGN
    , {   7,  11,   0,   3,   7, acGUI_FontRounded16_003F } // Code 003F, QUESTION MARK
    , {  10,  11,   0,   3,  10, acGUI_FontRounded16_0040 } // Code 0040, COMMERCIAL AT
    , {   9,  11,   0,   3,   9, acGUI_FontRounded16_0041 } // Code 0041, LATIN CAPITAL LETTER A
    , {   8,  10,   1,   3,   9, acGUI_FontRounded16_0042 } // Code 0042, LATIN CAPITAL LETTER B
    , {   9,  11,   0,   3,   9, acGUI_FontRounded16_0043 } // Code 0043, LATIN CAPITAL LETTER C
    , {   9,  10,   1,   3,  10, acGUI_FontRounded16_0044 } // Code 0044, LATIN CAPITAL LETTER D
    , {   8,  10,   1,   3,   9, acGUI_FontRounded16_0045 } // Code 0045, LATIN CAPITAL LETTER E
    , {   8,  11,   1,   3,   8, acGUI_FontRounded16_0046 } // Code 0046, LATIN CAPITAL LETTER F
    , {  10,  11,   0,   3,  11, acGUI_FontRounded16_0047 } // Code 0047, LATIN CAPITAL LETTER G
    , {   9,  11,   1,   3,  10, acGUI_FontRounded16_0048 } // Code 0048, LATIN CAPITAL LETTER H
    , {   3,  11,   1,   3,   4, acGUI_FontRounded16_0049 } // Code 0049, LATIN CAPITAL LETTER I
    , {   7,  11,   0,   3,   7, acGUI_FontRounded16_004A } // Code 004A, LATIN CAPITAL LETTER J
    , {   8,  11,   1,   3,   9, acGUI_FontRounded16_004B } // Code 004B, LATIN CAPITAL LETTER K
    , {   7,  10,   1,   3,   8, acGUI_FontRounded16_004C } // Code 004C, LATIN CAPITAL LETTER L
    , {  10,  11,   1,   3,  12, acGUI_FontRounded16_004D } // Code 004D, LATIN CAPITAL LETTER M
    , {   9,  11,   1,   3,  10, acGUI_FontRounded16_004E } // Code 004E, LATIN CAPITAL LETTER N
    , {  10,  11,   0,   3,  11, acGUI_FontRounded16_004F } // Code 004F, LATIN CAPITAL LETTER O
    , {   8,  11,   1,   3,   9, acGUI_FontRounded16_0050 } // Code 0050, LATIN CAPITAL LETTER P
    , {  10,  11,   0,   3,  11, acGUI_FontRounded16_0051 } // Code 0051, LATIN CAPITAL LETTER Q
    , {   8,  11,   1,   3,  10, acGUI_FontRounded16_0052 } // Code 0052, LATIN CAPITAL LETTER R
    , {   9,  11,   0,   3,   9, acGUI_FontRounded16_0053 } // Code 0053, LATIN CAPITAL LETTER S
    , {   9,  11,   0,   3,   9, acGUI_FontRounded16_0054 } // Code 0054, LATIN CAPITAL LETTER T
    , {   9,  11,   1,   3,  10, acGUI_FontRounded16_0055 } // Code 0055, LATIN CAPITAL LETTER U
    , {   9,  11,   0,   3,   8, acGUI_FontRounded16_0056 } // Code 0056, LATIN CAPITAL LETTER V
    , {  12,  11,   0,   3,  12, acGUI_FontRounded16_0057 } // Code 0057, LATIN CAPITAL LETTER W
    , {   8,  11,   0,   3,   8, acGUI_FontRounded16_0058 } // Code 0058, LATIN CAPITAL LETTER X
    , {   8,  11,   0,   3,   8, acGUI_FontRounded16_0059 } // Code 0059, LATIN CAPITAL LETTER Y
    , {   9,  10,   0,   3,   9, acGUI_FontRounded16_005A } // Code 005A, LATIN CAPITAL LETTER Z
    , {   4,  13,   1,   3,   5, acGUI_FontRounded16_005B } // Code 005B, LEFT SQUARE BRACKET
    , {   5,  11,   0,   3,   5, acGUI_FontRounded16_005C } // Code 005C, REVERSE SOLIDUS
    , {   4,  13,   0,   3,   5, acGUI_FontRounded16_005D } // Code 005D, RIGHT SQUARE BRACKET
    , {   7,   7,   0,   3,   8, acGUI_FontRounded16_005E } // Code 005E, CIRCUMFLEX ACCENT
    , {   8,   1,  -1,  14,   7, acGUI_FontRounded16_005F } // Code 005F, LOW LINE
    , {   3,   3,   0,   3,   4, acGUI_FontRounded16_0060 } // Code 0060, GRAVE ACCENT
    , {   8,   8,   0,   6,   8, acGUI_FontRounded16_0061 } // Code 0061, LATIN SMALL LETTER A
    , {   8,  11,   0,   3,   8, acGUI_FontRounded16_0062 } // Code 0062, LATIN SMALL LETTER B
    , {   7,   8,   0,   6,   7, acGUI_FontRounded16_0063 } // Code 0063, LATIN SMALL LETTER C
    , {   8,  11,   0,   3,   8, acGUI_FontRounded16_0064 } // Code 0064, LATIN SMALL LETTER D
    , {   8,   8,   0,   6,   8, acGUI_FontRounded16_0065 } // Code 0065, LATIN SMALL LETTER E
    , {   5,  11,   0,   3,   5, acGUI_FontRounded16_0066 } // Code 0066, LATIN SMALL LETTER F
    , {   8,  10,   0,   6,   8, acGUI_FontRounded16_0067 } // Code 0067, LATIN SMALL LETTER G
    , {   8,  11,   0,   3,   8, acGUI_FontRounded16_0068 } // Code 0068, LATIN SMALL LETTER H
    , {   3,  11,   0,   3,   4, acGUI_FontRounded16_0069 } // Code 0069, LATIN SMALL LETTER I
    , {   4,  13,  -1,   3,   4, acGUI_FontRounded16_006A } // Code 006A, LATIN SMALL LETTER J
    , {   7,  11,   0,   3,   7, acGUI_FontRounded16_006B } // Code 006B, LATIN SMALL LETTER K
    , {   3,  11,   0,   3,   4, acGUI_FontRounded16_006C } // Code 006C, LATIN SMALL LETTER L
    , {  12,   8,   0,   6,  12, acGUI_FontRounded16_006D } // Code 006D, LATIN SMALL LETTER M
    , {   8,   8,   0,   6,   8, acGUI_FontRounded16_006E } // Code 006E, LATIN SMALL LETTER N
    , {   8,   8,   0,   6,   8, acGUI_FontRounded16_006F } // Code 006F, LATIN SMALL LETTER O
    , {   8,  10,   0,   6,   8, acGUI_FontRounded16_0070 } // Code 0070, LATIN SMALL LETTER P
    , {   8,  10,   0,   6,   8, acGUI_FontRounded16_0071 } // Code 0071, LATIN SMALL LETTER Q
    , {   6,   8,   0,   6,   5, acGUI_FontRounded16_0072 } // Code 0072, LATIN SMALL LETTER R
    , {   7,   8,   0,   6,   7, acGUI_FontRounded16_0073 } // Code 0073, LATIN SMALL LETTER S
    , {   5,  10,   0,   4,   5, acGUI_FontRounded16_0074 } // Code 0074, LATIN SMALL LETTER T
    , {   8,   8,   0,   6,   8, acGUI_FontRounded16_0075 } // Code 0075, LATIN SMALL LETTER U
    , {   7,   8,   0,   6,   7, acGUI_FontRounded16_0076 } // Code 0076, LATIN SMALL LETTER V
    , {  10,   8,   0,   6,  10, acGUI_FontRounded16_0077 } // Code 0077, LATIN SMALL LETTER W
    , {   6,   8,   0,   6,   6, acGUI_FontRounded16_0078 } // Code 0078, LATIN SMALL LETTER X
    , {   7,  10,   0,   6,   7, acGUI_FontRounded16_0079 } // Code 0079, LATIN SMALL LETTER Y
    , {   7,   7,   0,   6,   7, acGUI_FontRounded16_007A } // Code 007A, LATIN SMALL LETTER Z
    , {   5,  13,   0,   3,   5, acGUI_FontRounded16_007B } // Code 007B, LEFT CURLY BRACKET
    , {   3,  11,   0,   3,   3, acGUI_FontRounded16_007C } // Code 007C, VERTICAL LINE
    , {   5,  13,   0,   3,   5, acGUI_FontRounded16_007D } // Code 007D, RIGHT CURLY BRACKET
    , {   8,   3,   0,   8,   8, acGUI_FontRounded16_007E } // Code 007E, TILDE
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontRounded16_Prop1 =
{
    0x0020,                                   // First character
    0x007E,                                   // Last character
    &GUI_FontRounded16_CharInfo[0],           // Address of first character
    (GUI_CONST_STORAGE GUI_FONT_PROP_EXT *)0  // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT GUI_FontRounded16 =
{
    GUI_FONTTYPE_PROP_AA4_EXT,     // Type of font
    16,                            // Height of font
    16,                            // Space of font y
    1,                             // Magnification x
    1,                             // Magnification y
    { &GUI_FontRounded16_Prop1 },
    16,                            // Baseline
    8,                             // Height of lowercase characters
    11,                            // Height of capital characters
};

/*********************************************************************
*                                                                    *
*       GUI_FontRounded22                                            *
*                                                                    *
*  Used in                                                           *
*  - GUIDEMO.c                                                       *
*  - GUIDEMO_Automotive.c                                            *
*  - GUIDEMO_ColorBar.c                                              *
*  - GUIDEMO_Cursor.c                                                *
*  - GUIDEMO_ImageFlow.c                                             *
*  - GUIDEMO_Intro.c                                                 *
*  - GUIDEMO_ZoomAndRotate.c                                         *
*                                                                    *
**********************************************************************
*/
GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0020[  1] =   // Code 0020, SPACE
{
    0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0021[ 30] =   // Code 0021, EXCLAMATION MARK
{
    0x02, 0x10,
    0x6F, 0xE2,
    0x9F, 0xF4,
    0x9F, 0xF4,
    0x9F, 0xF4,
    0x7F, 0xF2,
    0x5F, 0xF0,
    0x3F, 0xD0,
    0x1F, 0xB0,
    0x0D, 0x80,
    0x00, 0x00,
    0x2B, 0xA0,
    0x9F, 0xF4,
    0x5F, 0xE1,
    0x01, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0022[ 28] =   // Code 0022, QUOTATION MARK
{
    0x01, 0x10, 0x02, 0x00,
    0x0E, 0xF2, 0x7F, 0x90,
    0x2F, 0xF4, 0x9F, 0xB0,
    0x2F, 0xF4, 0x9F, 0xB0,
    0x2F, 0xF4, 0x9F, 0xB0,
    0x1E, 0xF2, 0x8F, 0xA0,
    0x02, 0x20, 0x03, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0023[ 84] =   // Code 0023, NUMBER SIGN
{
    0x00, 0x02, 0xB4, 0x08, 0x90, 0x00,
    0x00, 0x06, 0xF7, 0x0F, 0xD0, 0x00,
    0x00, 0x08, 0xF5, 0x2F, 0xB0, 0x00,
    0x00, 0x2B, 0xF4, 0x5F, 0xA1, 0x00,
    0x07, 0xFF, 0xFF, 0xFF, 0xFE, 0x10,
    0x03, 0x9F, 0xE9, 0xDF, 0xB8, 0x00,
    0x00, 0x1F, 0xB0, 0xAF, 0x30, 0x00,
    0x02, 0x6F, 0xB4, 0xDF, 0x40, 0x00,
    0x0F, 0xFF, 0xFF, 0xFF, 0xF7, 0x00,
    0x06, 0xBF, 0x98, 0xFD, 0x72, 0x00,
    0x00, 0xAF, 0x33, 0xF9, 0x00, 0x00,
    0x00, 0xCF, 0x15, 0xF7, 0x00, 0x00,
    0x00, 0xDD, 0x07, 0xF4, 0x00, 0x00,
    0x00, 0x22, 0x00, 0x30, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0024[ 96] =   // Code 0024, DOLLAR SIGN
{
    0x00, 0x00, 0x0B, 0x10, 0x00, 0x00,
    0x00, 0x28, 0xBF, 0xC8, 0x30, 0x00,
    0x05, 0xFF, 0xFF, 0xFF, 0xF9, 0x00,
    0x1E, 0xF9, 0x2F, 0x39, 0xFF, 0x50,
    0x3F, 0xF0, 0x0F, 0x20, 0x9E, 0x30,
    0x3F, 0xF6, 0x0F, 0x20, 0x00, 0x00,
    0x0D, 0xFF, 0xDF, 0x73, 0x00, 0x00,
    0x02, 0xCF, 0xFF, 0xFF, 0xC3, 0x00,
    0x00, 0x04, 0x8F, 0xEF, 0xFE, 0x10,
    0x03, 0x00, 0x0F, 0x25, 0xFF, 0x70,
    0x7F, 0xA0, 0x0F, 0x20, 0xBF, 0x80,
    0x7F, 0xF3, 0x0F, 0x21, 0xEF, 0x60,
    0x1D, 0xFE, 0xAF, 0xBE, 0xFD, 0x10,
    0x01, 0xAF, 0xFF, 0xFF, 0xA2, 0x00,
    0x00, 0x01, 0x3F, 0x41, 0x00, 0x00,
    0x00, 0x00, 0x0D, 0x10, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0025[120] =   // Code 0025, PERCENT SIGN
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00,
    0x03, 0xAB, 0xA2, 0x00, 0x00, 0x7F, 0x00, 0x00,
    0x2E, 0xEA, 0xFE, 0x10, 0x01, 0xE8, 0x00, 0x00,
    0x7F, 0x70, 0x9F, 0x50, 0x08, 0xE1, 0x00, 0x00,
    0x9F, 0x60, 0x7F, 0x70, 0x2F, 0x70, 0x00, 0x00,
    0x7F, 0x60, 0x8F, 0x60, 0x9E, 0x10, 0x00, 0x00,
    0x3F, 0xD6, 0xEF, 0x22, 0xF7, 0x00, 0x00, 0x00,
    0x07, 0xEF, 0xE6, 0x0A, 0xE0, 0x17, 0x98, 0x20,
    0x00, 0x01, 0x00, 0x3F, 0x60, 0xCF, 0xCF, 0xE1,
    0x00, 0x00, 0x00, 0xBD, 0x04, 0xFA, 0x09, 0xF6,
    0x00, 0x00, 0x04, 0xF5, 0x07, 0xF7, 0x06, 0xF9,
    0x00, 0x00, 0x0C, 0xC0, 0x06, 0xF8, 0x06, 0xF8,
    0x00, 0x00, 0x5F, 0x40, 0x03, 0xFC, 0x3B, 0xF4,
    0x00, 0x00, 0xCB, 0x00, 0x00, 0x8F, 0xFF, 0x90,
    0x00, 0x00, 0x93, 0x00, 0x00, 0x01, 0x42, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0026[105] =   // Code 0026, AMPERSAND
{
    0x00, 0x00, 0x01, 0x10, 0x00, 0x00, 0x00,
    0x00, 0x04, 0xDF, 0xFD, 0x50, 0x00, 0x00,
    0x00, 0x3F, 0xFD, 0xCF, 0xF4, 0x00, 0x00,
    0x00, 0x9F, 0xD0, 0x0B, 0xFA, 0x00, 0x00,
    0x00, 0x9F, 0xD0, 0x0B, 0xFA, 0x00, 0x00,
    0x00, 0x4F, 0xF9, 0x8F, 0xF5, 0x00, 0x00,
    0x00, 0x0A, 0xFF, 0xFF, 0x80, 0x00, 0x00,
    0x00, 0x9F, 0xFF, 0xFB, 0x00, 0x54, 0x00,
    0x09, 0xFF, 0xBA, 0xFF, 0x74, 0xFF, 0x00,
    0x1F, 0xFB, 0x00, 0xBF, 0xFE, 0xFC, 0x00,
    0x3F, 0xF7, 0x00, 0x1D, 0xFF, 0xE3, 0x00,
    0x1F, 0xFB, 0x00, 0x2C, 0xFF, 0xE3, 0x00,
    0x0A, 0xFF, 0xED, 0xFF, 0xEE, 0xFD, 0x00,
    0x01, 0xAF, 0xFF, 0xFB, 0x24, 0xFD, 0x00,
    0x00, 0x01, 0x43, 0x10, 0x00, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0027[ 14] =   // Code 0027, APOSTROPHE
{
    0x01, 0x10,
    0x3F, 0xD0,
    0x6F, 0xF0,
    0x6F, 0xF0,
    0x6F, 0xF0,
    0x3F, 0xE0,
    0x03, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0028[ 54] =   // Code 0028, LEFT PARENTHESIS
{
    0x00, 0x03, 0x00,
    0x00, 0x9F, 0x40,
    0x02, 0xFF, 0x20,
    0x08, 0xFB, 0x00,
    0x0E, 0xF7, 0x00,
    0x4F, 0xF3, 0x00,
    0x7F, 0xE0, 0x00,
    0xAF, 0xC0, 0x00,
    0xBF, 0xB0, 0x00,
    0xBF, 0xB0, 0x00,
    0xBF, 0xB0, 0x00,
    0x8F, 0xE0, 0x00,
    0x5F, 0xF2, 0x00,
    0x1F, 0xF5, 0x00,
    0x0A, 0xFA, 0x00,
    0x04, 0xFE, 0x10,
    0x00, 0xCF, 0x50,
    0x00, 0x29, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0029[ 54] =   // Code 0029, RIGHT PARENTHESIS
{
    0x03, 0x00, 0x00,
    0x5F, 0x90, 0x00,
    0x2F, 0xF2, 0x00,
    0x0B, 0xF8, 0x00,
    0x07, 0xFE, 0x00,
    0x03, 0xFF, 0x30,
    0x00, 0xFF, 0x70,
    0x00, 0xCF, 0xA0,
    0x00, 0xBF, 0xB0,
    0x00, 0xBF, 0xB0,
    0x00, 0xCF, 0xB0,
    0x00, 0xEF, 0x80,
    0x02, 0xFF, 0x50,
    0x05, 0xFF, 0x10,
    0x0A, 0xFA, 0x00,
    0x1E, 0xF4, 0x00,
    0x5F, 0xC0, 0x00,
    0x19, 0x20, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_002A[ 32] =   // Code 002A, ASTERISK
{
    0x00, 0x00, 0x10, 0x00,
    0x00, 0x08, 0xE0, 0x00,
    0x05, 0x29, 0xF0, 0x51,
    0x2F, 0xFE, 0xFE, 0xF7,
    0x02, 0x7F, 0xFB, 0x40,
    0x00, 0xAF, 0xCE, 0x20,
    0x03, 0xF7, 0x2F, 0x90,
    0x00, 0x30, 0x03, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_002B[ 66] =   // Code 002B, PLUS SIGN
{
    0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x8F, 0x50, 0x00, 0x00,
    0x00, 0x00, 0xBF, 0x70, 0x00, 0x00,
    0x00, 0x00, 0xBF, 0x70, 0x00, 0x00,
    0x02, 0x22, 0xCF, 0x82, 0x22, 0x00,
    0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0x60,
    0x6F, 0xFF, 0xFF, 0xFF, 0xFE, 0x40,
    0x00, 0x00, 0xBF, 0x70, 0x00, 0x00,
    0x00, 0x00, 0xBF, 0x70, 0x00, 0x00,
    0x00, 0x00, 0xBF, 0x70, 0x00, 0x00,
    0x00, 0x00, 0x7F, 0x40, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_002C[ 12] =   // Code 002C, COMMA
{
    0x3C, 0x90,
    0xBF, 0xF5,
    0x6F, 0xF7,
    0x01, 0xE5,
    0x4C, 0xC0,
    0x67, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_002D[ 16] =   // Code 002D, HYPHEN-MINUS
{
    0x01, 0x44, 0x42, 0x00,
    0x2F, 0xFF, 0xFF, 0x70,
    0x3F, 0xFF, 0xFF, 0x80,
    0x02, 0x44, 0x43, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_002E[  8] =   // Code 002E, FULL STOP
{
    0x3C, 0x90,
    0xBF, 0xF3,
    0x6F, 0xD1,
    0x01, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_002F[ 60] =   // Code 002F, SOLIDUS
{
    0x00, 0x00, 0x03, 0x00,
    0x00, 0x00, 0x6F, 0x70,
    0x00, 0x00, 0xCF, 0x40,
    0x00, 0x03, 0xFD, 0x00,
    0x00, 0x08, 0xF8, 0x00,
    0x00, 0x0E, 0xF2, 0x00,
    0x00, 0x5F, 0xB0, 0x00,
    0x00, 0xBF, 0x60, 0x00,
    0x01, 0xFE, 0x10, 0x00,
    0x07, 0xF9, 0x00, 0x00,
    0x0D, 0xF3, 0x00, 0x00,
    0x3F, 0xD0, 0x00, 0x00,
    0x9F, 0x70, 0x00, 0x00,
    0xCF, 0x20, 0x00, 0x00,
    0x23, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0030[ 84] =   // Code 0030, DIGIT ZERO
{
    0x00, 0x05, 0xBB, 0xB6, 0x00, 0x00,
    0x00, 0xAF, 0xFF, 0xFF, 0xA0, 0x00,
    0x06, 0xFF, 0xA6, 0xAF, 0xF7, 0x00,
    0x0D, 0xFC, 0x00, 0x0C, 0xFD, 0x00,
    0x2F, 0xF8, 0x00, 0x08, 0xFF, 0x20,
    0x4F, 0xF6, 0x00, 0x06, 0xFF, 0x40,
    0x4F, 0xF6, 0x00, 0x06, 0xFF, 0x40,
    0x4F, 0xF6, 0x00, 0x06, 0xFF, 0x40,
    0x2F, 0xF7, 0x00, 0x06, 0xFF, 0x30,
    0x0E, 0xFA, 0x00, 0x0A, 0xFE, 0x00,
    0x09, 0xFF, 0x40, 0x4F, 0xF9, 0x00,
    0x02, 0xEF, 0xFE, 0xFF, 0xE2, 0x00,
    0x00, 0x3C, 0xFF, 0xFC, 0x30, 0x00,
    0x00, 0x00, 0x24, 0x20, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0031[ 56] =   // Code 0031, DIGIT ONE
{
    0x00, 0x00, 0x2B, 0x70,
    0x00, 0x00, 0xAF, 0xC0,
    0x01, 0x49, 0xFF, 0xD0,
    0x1E, 0xFF, 0xFF, 0xD0,
    0x1B, 0xDD, 0xFF, 0xD0,
    0x00, 0x00, 0xDF, 0xD0,
    0x00, 0x00, 0xDF, 0xD0,
    0x00, 0x00, 0xDF, 0xD0,
    0x00, 0x00, 0xDF, 0xD0,
    0x00, 0x00, 0xDF, 0xD0,
    0x00, 0x00, 0xDF, 0xD0,
    0x00, 0x00, 0xDF, 0xC0,
    0x00, 0x00, 0xBF, 0xA0,
    0x00, 0x00, 0x13, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0032[ 78] =   // Code 0032, DIGIT TWO
{
    0x00, 0x17, 0xBB, 0xB6, 0x00, 0x00,
    0x03, 0xEF, 0xFF, 0xFF, 0xD1, 0x00,
    0x0D, 0xFE, 0x86, 0xAF, 0xFB, 0x00,
    0x5F, 0xF6, 0x00, 0x0D, 0xFF, 0x00,
    0x4F, 0xE1, 0x00, 0x0B, 0xFF, 0x00,
    0x03, 0x20, 0x00, 0x3F, 0xFB, 0x00,
    0x00, 0x00, 0x07, 0xEF, 0xF3, 0x00,
    0x00, 0x03, 0xCF, 0xFD, 0x30, 0x00,
    0x00, 0x6F, 0xFE, 0x70, 0x00, 0x00,
    0x06, 0xFF, 0xA2, 0x00, 0x00, 0x00,
    0x2F, 0xFC, 0x44, 0x44, 0x42, 0x00,
    0x6F, 0xFF, 0xFF, 0xFF, 0xFF, 0x10,
    0x3E, 0xFF, 0xFF, 0xFF, 0xFD, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0033[ 70] =   // Code 0033, DIGIT THREE
{
    0x00, 0x28, 0xBB, 0xA5, 0x00,
    0x05, 0xFF, 0xFF, 0xFF, 0xA0,
    0x1F, 0xFE, 0x76, 0xCF, 0xF4,
    0x2F, 0xF4, 0x00, 0x2F, 0xF7,
    0x04, 0x40, 0x00, 0x2F, 0xF5,
    0x00, 0x00, 0x5A, 0xEF, 0xB0,
    0x00, 0x00, 0xFF, 0xFF, 0x90,
    0x00, 0x00, 0x38, 0xCF, 0xF8,
    0x01, 0x00, 0x00, 0x1E, 0xFC,
    0x3F, 0xC0, 0x00, 0x0E, 0xFD,
    0x5F, 0xF8, 0x00, 0x7F, 0xF9,
    0x1D, 0xFF, 0xFE, 0xFF, 0xE2,
    0x02, 0xBF, 0xFF, 0xFB, 0x30,
    0x00, 0x01, 0x33, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0034[ 84] =   // Code 0034, DIGIT FOUR
{
    0x00, 0x00, 0x00, 0x9B, 0x40, 0x00,
    0x00, 0x00, 0x07, 0xFF, 0x90, 0x00,
    0x00, 0x00, 0x4F, 0xFF, 0x90, 0x00,
    0x00, 0x02, 0xEE, 0xEF, 0x90, 0x00,
    0x00, 0x0C, 0xF4, 0xDF, 0x90, 0x00,
    0x00, 0x9F, 0x80, 0xDF, 0x90, 0x00,
    0x06, 0xFB, 0x00, 0xDF, 0x90, 0x00,
    0x3F, 0xE2, 0x00, 0xDF, 0x90, 0x00,
    0xBF, 0xFF, 0xFF, 0xFF, 0xFE, 0x50,
    0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0x60,
    0x02, 0x22, 0x22, 0xDF, 0xA2, 0x00,
    0x00, 0x00, 0x00, 0xDF, 0x90, 0x00,
    0x00, 0x00, 0x00, 0xBF, 0x80, 0x00,
    0x00, 0x00, 0x00, 0x13, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0035[ 70] =   // Code 0035, DIGIT FIVE
{
    0x01, 0x89, 0x99, 0x99, 0x70,
    0x07, 0xFF, 0xFF, 0xFF, 0xF3,
    0x0A, 0xFD, 0xBB, 0xBB, 0x90,
    0x0C, 0xF5, 0x00, 0x00, 0x00,
    0x0F, 0xF3, 0x46, 0x51, 0x00,
    0x3F, 0xFD, 0xFF, 0xFE, 0x60,
    0x3F, 0xFE, 0xAB, 0xFF, 0xF3,
    0x06, 0x60, 0x00, 0x4F, 0xFA,
    0x00, 0x00, 0x00, 0x0D, 0xFB,
    0x17, 0x40, 0x00, 0x0E, 0xFB,
    0x5F, 0xF4, 0x00, 0x8F, 0xF7,
    0x3F, 0xFF, 0xDE, 0xFF, 0xD1,
    0x04, 0xCF, 0xFF, 0xFA, 0x10,
    0x00, 0x02, 0x43, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0036[ 84] =   // Code 0036, DIGIT SIX
{
    0x00, 0x04, 0x9B, 0xB9, 0x30, 0x00,
    0x00, 0x8F, 0xFF, 0xFF, 0xF4, 0x00,
    0x04, 0xFF, 0x93, 0x4E, 0xFB, 0x00,
    0x0B, 0xFC, 0x00, 0x02, 0x93, 0x00,
    0x1F, 0xF7, 0x02, 0x31, 0x00, 0x00,
    0x3F, 0xF9, 0xDF, 0xFF, 0x91, 0x00,
    0x4F, 0xFF, 0xEB, 0xDF, 0xFA, 0x00,
    0x4F, 0xFD, 0x10, 0x0B, 0xFF, 0x20,
    0x3F, 0xF8, 0x00, 0x06, 0xFF, 0x40,
    0x1F, 0xF8, 0x00, 0x06, 0xFF, 0x40,
    0x0B, 0xFE, 0x20, 0x1C, 0xFF, 0x10,
    0x03, 0xEF, 0xFD, 0xEF, 0xF7, 0x00,
    0x00, 0x3C, 0xFF, 0xFE, 0x70, 0x00,
    0x00, 0x00, 0x24, 0x30, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0037[ 70] =   // Code 0037, DIGIT SEVEN
{
    0x49, 0x99, 0x99, 0x99, 0x94,
    0xBF, 0xFF, 0xFF, 0xFF, 0xFD,
    0x5B, 0xBB, 0xBB, 0xBF, 0xF9,
    0x00, 0x00, 0x00, 0x9F, 0xC0,
    0x00, 0x00, 0x05, 0xFE, 0x20,
    0x00, 0x00, 0x1E, 0xF6, 0x00,
    0x00, 0x00, 0x9F, 0xD0, 0x00,
    0x00, 0x02, 0xFF, 0x70, 0x00,
    0x00, 0x08, 0xFF, 0x10, 0x00,
    0x00, 0x0E, 0xFB, 0x00, 0x00,
    0x00, 0x4F, 0xF7, 0x00, 0x00,
    0x00, 0x7F, 0xF3, 0x00, 0x00,
    0x00, 0x6F, 0xD0, 0x00, 0x00,
    0x00, 0x03, 0x10, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0038[ 84] =   // Code 0038, DIGIT EIGHT
{
    0x00, 0x17, 0xBB, 0xB8, 0x10, 0x00,
    0x02, 0xEF, 0xFF, 0xFF, 0xE3, 0x00,
    0x0B, 0xFE, 0x62, 0x6E, 0xFB, 0x00,
    0x0D, 0xFA, 0x00, 0x0A, 0xFF, 0x00,
    0x0C, 0xFB, 0x00, 0x0B, 0xFC, 0x00,
    0x04, 0xFF, 0xB8, 0xBF, 0xF4, 0x00,
    0x02, 0xBF, 0xFF, 0xFF, 0xB2, 0x00,
    0x0C, 0xFE, 0x64, 0x6E, 0xFD, 0x00,
    0x3F, 0xF7, 0x00, 0x07, 0xFF, 0x30,
    0x4F, 0xF6, 0x00, 0x06, 0xFF, 0x40,
    0x2F, 0xFC, 0x10, 0x1B, 0xFF, 0x20,
    0x09, 0xFF, 0xED, 0xEF, 0xF9, 0x00,
    0x00, 0x7E, 0xFF, 0xFE, 0x80, 0x00,
    0x00, 0x00, 0x24, 0x30, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0039[ 84] =   // Code 0039, DIGIT NINE
{
    0x00, 0x17, 0xBB, 0xB6, 0x00, 0x00,
    0x03, 0xEF, 0xFF, 0xFF, 0xB0, 0x00,
    0x0C, 0xFE, 0x74, 0x8F, 0xF8, 0x00,
    0x3F, 0xF8, 0x00, 0x0A, 0xFE, 0x00,
    0x4F, 0xF6, 0x00, 0x07, 0xFF, 0x30,
    0x3F, 0xF7, 0x00, 0x0A, 0xFF, 0x40,
    0x0D, 0xFF, 0x74, 0x9F, 0xFF, 0x40,
    0x03, 0xEF, 0xFF, 0xFD, 0xFF, 0x40,
    0x00, 0x17, 0x99, 0x56, 0xFF, 0x20,
    0x00, 0x30, 0x00, 0x09, 0xFD, 0x00,
    0x09, 0xFA, 0x00, 0x3F, 0xF8, 0x00,
    0x08, 0xFF, 0xDB, 0xFF, 0xD1, 0x00,
    0x01, 0x9F, 0xFF, 0xFA, 0x20, 0x00,
    0x00, 0x01, 0x33, 0x10, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_003A[ 22] =   // Code 003A, COLON
{
    0x05, 0x30,
    0x9F, 0xF2,
    0x9F, 0xF2,
    0x17, 0x40,
    0x00, 0x00,
    0x00, 0x00,
    0x00, 0x00,
    0x3C, 0x90,
    0xBF, 0xF3,
    0x6F, 0xD1,
    0x01, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_003B[ 26] =   // Code 003B, SEMICOLON
{
    0x05, 0x30,
    0x9F, 0xF2,
    0x9F, 0xF2,
    0x17, 0x40,
    0x00, 0x00,
    0x00, 0x00,
    0x00, 0x00,
    0x3C, 0x90,
    0xBF, 0xF5,
    0x6F, 0xF7,
    0x01, 0xE5,
    0x4C, 0xC0,
    0x67, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_003C[ 60] =   // Code 003C, LESS-THAN SIGN
{
    0x00, 0x00, 0x00, 0x01, 0x8B, 0x20,
    0x00, 0x00, 0x02, 0x9F, 0xFF, 0x50,
    0x00, 0x03, 0xAF, 0xFF, 0xC6, 0x00,
    0x05, 0xCF, 0xFF, 0xB4, 0x00, 0x00,
    0x7F, 0xFF, 0x92, 0x00, 0x00, 0x00,
    0x5F, 0xFF, 0xB5, 0x00, 0x00, 0x00,
    0x02, 0x9F, 0xFF, 0xD7, 0x10, 0x00,
    0x00, 0x01, 0x7E, 0xFF, 0xF8, 0x10,
    0x00, 0x00, 0x00, 0x7D, 0xFF, 0x50,
    0x00, 0x00, 0x00, 0x00, 0x57, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_003D[ 48] =   // Code 003D, EQUALS SIGN
{
    0x04, 0x44, 0x44, 0x44, 0x43, 0x00,
    0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0x70,
    0x5D, 0xDD, 0xDD, 0xDD, 0xDC, 0x30,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0x50,
    0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0x50,
    0x02, 0x22, 0x22, 0x22, 0x21, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_003E[ 60] =   // Code 003E, GREATER-THAN SIGN
{
    0x4B, 0x70, 0x00, 0x00, 0x00, 0x00,
    0x8F, 0xFE, 0x81, 0x00, 0x00, 0x00,
    0x17, 0xEF, 0xFF, 0x92, 0x00, 0x00,
    0x00, 0x05, 0xCF, 0xFF, 0xA3, 0x00,
    0x00, 0x00, 0x03, 0xAF, 0xFF, 0x40,
    0x00, 0x00, 0x06, 0xDF, 0xFE, 0x30,
    0x00, 0x28, 0xEF, 0xFE, 0x71, 0x00,
    0x1A, 0xFF, 0xFD, 0x60, 0x00, 0x00,
    0x9F, 0xFC, 0x50, 0x00, 0x00, 0x00,
    0x27, 0x30, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_003F[ 75] =   // Code 003F, QUESTION MARK
{
    0x00, 0x00, 0x22, 0x00, 0x00,
    0x00, 0x7E, 0xFF, 0xFA, 0x20,
    0x09, 0xFF, 0xEE, 0xFF, 0xE1,
    0x2F, 0xFA, 0x00, 0x7F, 0xF7,
    0x2F, 0xE2, 0x00, 0x3F, 0xF7,
    0x02, 0x20, 0x00, 0xAF, 0xF5,
    0x00, 0x00, 0x1B, 0xFF, 0xA0,
    0x00, 0x00, 0xCF, 0xF7, 0x00,
    0x00, 0x05, 0xFF, 0x50, 0x00,
    0x00, 0x02, 0xEC, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x02, 0xBA, 0x10, 0x00,
    0x00, 0x08, 0xFF, 0x50, 0x00,
    0x00, 0x04, 0xFE, 0x20, 0x00,
    0x00, 0x00, 0x11, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0040[105] =   // Code 0040, COMMERCIAL AT
{
    0x00, 0x00, 0x00, 0x34, 0x31, 0x00, 0x00,
    0x00, 0x02, 0x9E, 0xFF, 0xFF, 0xA2, 0x00,
    0x00, 0x3E, 0xFB, 0x76, 0x7A, 0xFE, 0x50,
    0x02, 0xEF, 0x50, 0x00, 0x00, 0x3E, 0xE2,
    0x0B, 0xF6, 0x07, 0xEE, 0x96, 0xB5, 0xF8,
    0x2F, 0xD0, 0x7F, 0xFF, 0xFF, 0xF0, 0xEC,
    0x5F, 0x91, 0xEF, 0x40, 0x8F, 0xC0, 0xBD,
    0x7F, 0x74, 0xFA, 0x00, 0x4F, 0x90, 0xCB,
    0x6F, 0x85, 0xFB, 0x00, 0x6F, 0x71, 0xF7,
    0x3F, 0xC2, 0xFF, 0x98, 0xEF, 0xAC, 0xD1,
    0x0C, 0xF4, 0x9F, 0xFF, 0xEF, 0xFB, 0x20,
    0x03, 0xFE, 0x45, 0x73, 0x37, 0x57, 0x00,
    0x00, 0x5E, 0xFB, 0x66, 0x69, 0xEE, 0x10,
    0x00, 0x02, 0x9F, 0xFF, 0xFF, 0xA2, 0x00,
    0x00, 0x00, 0x01, 0x34, 0x31, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0041[ 90] =   // Code 0041, LATIN CAPITAL LETTER A
{
    0x00, 0x00, 0x02, 0x30, 0x00, 0x00,
    0x00, 0x00, 0x9F, 0xFB, 0x00, 0x00,
    0x00, 0x01, 0xFF, 0xFF, 0x30, 0x00,
    0x00, 0x06, 0xFF, 0xFF, 0x80, 0x00,
    0x00, 0x0C, 0xFD, 0xCF, 0xE0, 0x00,
    0x00, 0x3F, 0xF8, 0x7F, 0xF4, 0x00,
    0x00, 0x8F, 0xF3, 0x2F, 0xFA, 0x00,
    0x00, 0xEF, 0xD0, 0x0D, 0xFF, 0x10,
    0x04, 0xFF, 0x80, 0x08, 0xFF, 0x60,
    0x0A, 0xFF, 0xCB, 0xBC, 0xFF, 0xB0,
    0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2,
    0x7F, 0xF9, 0x44, 0x44, 0x9F, 0xF7,
    0xCF, 0xF3, 0x00, 0x00, 0x3F, 0xFC,
    0xAF, 0xC0, 0x00, 0x00, 0x0C, 0xFA,
    0x03, 0x10, 0x00, 0x00, 0x01, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0042[ 78] =   // Code 0042, LATIN CAPITAL LETTER B
{
    0x3D, 0xFF, 0xFF, 0xED, 0xA3, 0x00,
    0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0x30,
    0x9F, 0xF8, 0x44, 0x4C, 0xFF, 0xA0,
    0x9F, 0xF6, 0x00, 0x04, 0xFF, 0xB0,
    0x9F, 0xF6, 0x00, 0x06, 0xFF, 0x70,
    0x9F, 0xFB, 0x99, 0xBF, 0xFB, 0x10,
    0x9F, 0xFF, 0xFF, 0xFF, 0xFB, 0x20,
    0x9F, 0xF8, 0x44, 0x4A, 0xFF, 0xD0,
    0x9F, 0xF6, 0x00, 0x00, 0xCF, 0xF2,
    0x9F, 0xF6, 0x00, 0x00, 0xCF, 0xF3,
    0x9F, 0xF8, 0x44, 0x5A, 0xFF, 0xE0,
    0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0x60,
    0x4E, 0xFF, 0xFF, 0xFE, 0xB4, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0043[ 90] =   // Code 0043, LATIN CAPITAL LETTER C
{
    0x00, 0x00, 0x13, 0x43, 0x00, 0x00,
    0x00, 0x2A, 0xFF, 0xFF, 0xE7, 0x00,
    0x03, 0xEF, 0xFF, 0xFF, 0xFF, 0xB0,
    0x1E, 0xFF, 0xB3, 0x25, 0xEF, 0xF6,
    0x7F, 0xFB, 0x00, 0x00, 0x4F, 0xF7,
    0xCF, 0xF3, 0x00, 0x00, 0x03, 0x61,
    0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
    0xFF, 0xD0, 0x00, 0x00, 0x00, 0x00,
    0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
    0xDF, 0xF3, 0x00, 0x00, 0x05, 0x71,
    0x9F, 0xFA, 0x00, 0x00, 0x4F, 0xF7,
    0x3F, 0xFF, 0x93, 0x25, 0xEF, 0xF5,
    0x06, 0xFF, 0xFF, 0xFF, 0xFF, 0xA0,
    0x00, 0x4C, 0xFF, 0xFF, 0xE7, 0x00,
    0x00, 0x00, 0x24, 0x43, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0044[ 78] =   // Code 0044, LATIN CAPITAL LETTER D
{
    0x3D, 0xFF, 0xFF, 0xEC, 0x71, 0x00,
    0x9F, 0xFF, 0xFF, 0xFF, 0xFE, 0x30,
    0x9F, 0xF9, 0x66, 0x7D, 0xFF, 0xD0,
    0x9F, 0xF6, 0x00, 0x01, 0xCF, 0xF6,
    0x9F, 0xF6, 0x00, 0x00, 0x5F, 0xFA,
    0x9F, 0xF6, 0x00, 0x00, 0x2F, 0xFD,
    0x9F, 0xF6, 0x00, 0x00, 0x2F, 0xFD,
    0x9F, 0xF6, 0x00, 0x00, 0x2F, 0xFC,
    0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xFA,
    0x9F, 0xF6, 0x00, 0x01, 0xDF, 0xF5,
    0x9F, 0xF9, 0x66, 0x7D, 0xFF, 0xC0,
    0x9F, 0xFF, 0xFF, 0xFF, 0xFD, 0x20,
    0x4E, 0xFF, 0xFF, 0xFC, 0x71, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0045[ 78] =   // Code 0045, LATIN CAPITAL LETTER E
{
    0x3D, 0xFF, 0xFF, 0xFF, 0xFE, 0x50,
    0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
    0x9F, 0xF9, 0x66, 0x66, 0x65, 0x10,
    0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
    0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
    0x9F, 0xFD, 0xBB, 0xBB, 0xB6, 0x00,
    0x9F, 0xFF, 0xFF, 0xFF, 0xFB, 0x00,
    0x9F, 0xFA, 0x77, 0x77, 0x73, 0x00,
    0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
    0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
    0x9F, 0xF9, 0x66, 0x66, 0x65, 0x10,
    0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xA0,
    0x3D, 0xFF, 0xFF, 0xFF, 0xFF, 0x70
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0046[ 84] =   // Code 0046, LATIN CAPITAL LETTER F
{
    0x3D, 0xFF, 0xFF, 0xFF, 0xFB, 0x10,
    0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0x10,
    0x9F, 0xF9, 0x66, 0x66, 0x64, 0x00,
    0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
    0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
    0x9F, 0xFB, 0x99, 0x99, 0x70, 0x00,
    0x9F, 0xFF, 0xFF, 0xFF, 0xF3, 0x00,
    0x9F, 0xFD, 0xBB, 0xBB, 0x90, 0x00,
    0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
    0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
    0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
    0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
    0x5F, 0xF3, 0x00, 0x00, 0x00, 0x00,
    0x03, 0x20, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0047[105] =   // Code 0047, LATIN CAPITAL LETTER G
{
    0x00, 0x00, 0x03, 0x43, 0x10, 0x00, 0x00,
    0x00, 0x2A, 0xFF, 0xFF, 0xFA, 0x20, 0x00,
    0x03, 0xEF, 0xFF, 0xFF, 0xFF, 0xE2, 0x00,
    0x1E, 0xFF, 0xB4, 0x23, 0xAF, 0xFA, 0x00,
    0x8F, 0xFB, 0x00, 0x00, 0x0B, 0xF8, 0x00,
    0xCF, 0xF3, 0x00, 0x00, 0x00, 0x20, 0x00,
    0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xFF, 0xD0, 0x00, 0x5D, 0xDD, 0xDD, 0x30,
    0xFF, 0xE0, 0x00, 0x8F, 0xFF, 0xFF, 0x60,
    0xDF, 0xF2, 0x00, 0x15, 0x69, 0xFF, 0x60,
    0x9F, 0xF9, 0x00, 0x00, 0x0B, 0xFF, 0x60,
    0x2F, 0xFF, 0x82, 0x02, 0x9F, 0xFF, 0x60,
    0x06, 0xFF, 0xFF, 0xFF, 0xFE, 0xEF, 0x60,
    0x00, 0x4C, 0xFF, 0xFF, 0xD3, 0x9F, 0x50,
    0x00, 0x00, 0x24, 0x43, 0x00, 0x03, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0048[ 90] =   // Code 0048, LATIN CAPITAL LETTER H
{
    0x02, 0x10, 0x00, 0x00, 0x01, 0x20,
    0x6F, 0xE2, 0x00, 0x00, 0x2E, 0xF6,
    0x9F, 0xF5, 0x00, 0x00, 0x5F, 0xF9,
    0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
    0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
    0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
    0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9,
    0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9,
    0x9F, 0xFA, 0x77, 0x77, 0xAF, 0xF9,
    0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
    0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
    0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
    0x9F, 0xF5, 0x00, 0x00, 0x5F, 0xF9,
    0x6F, 0xE2, 0x00, 0x00, 0x2E, 0xF7,
    0x03, 0x20, 0x00, 0x00, 0x02, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0049[ 30] =   // Code 0049, LATIN CAPITAL LETTER I
{
    0x02, 0x10,
    0x6F, 0xE2,
    0x9F, 0xF5,
    0x9F, 0xF6,
    0x9F, 0xF6,
    0x9F, 0xF6,
    0x9F, 0xF6,
    0x9F, 0xF6,
    0x9F, 0xF6,
    0x9F, 0xF6,
    0x9F, 0xF6,
    0x9F, 0xF6,
    0x9F, 0xF5,
    0x6F, 0xE2,
    0x03, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_004A[ 75] =   // Code 004A, LATIN CAPITAL LETTER J
{
    0x00, 0x00, 0x00, 0x02, 0x00,
    0x00, 0x00, 0x00, 0xBF, 0xB0,
    0x00, 0x00, 0x00, 0xFF, 0xF0,
    0x00, 0x00, 0x00, 0xFF, 0xF0,
    0x00, 0x00, 0x00, 0xFF, 0xF0,
    0x00, 0x00, 0x00, 0xFF, 0xF0,
    0x00, 0x00, 0x00, 0xFF, 0xF0,
    0x00, 0x00, 0x00, 0xFF, 0xF0,
    0x01, 0x00, 0x00, 0xFF, 0xF0,
    0x5F, 0xC0, 0x00, 0xFF, 0xF0,
    0x9F, 0xF1, 0x00, 0xFF, 0xE0,
    0x9F, 0xF6, 0x07, 0xFF, 0xB0,
    0x3F, 0xFF, 0xFF, 0xFF, 0x50,
    0x05, 0xEF, 0xFF, 0xF7, 0x00,
    0x00, 0x03, 0x43, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_004B[ 90] =   // Code 004B, LATIN CAPITAL LETTER K
{
    0x02, 0x10, 0x00, 0x00, 0x11, 0x00,
    0x6F, 0xE2, 0x00, 0x02, 0xEF, 0x50,
    0x9F, 0xF5, 0x00, 0x1D, 0xFF, 0x60,
    0x9F, 0xF6, 0x01, 0xDF, 0xF8, 0x00,
    0x9F, 0xF6, 0x1B, 0xFF, 0x90, 0x00,
    0x9F, 0xF6, 0xAF, 0xFA, 0x00, 0x00,
    0x9F, 0xFE, 0xFF, 0xF4, 0x00, 0x00,
    0x9F, 0xFF, 0xFF, 0xFD, 0x00, 0x00,
    0x9F, 0xFF, 0xAD, 0xFF, 0x80, 0x00,
    0x9F, 0xFA, 0x03, 0xFF, 0xF3, 0x00,
    0x9F, 0xF6, 0x00, 0x9F, 0xFD, 0x00,
    0x9F, 0xF6, 0x00, 0x1D, 0xFF, 0x70,
    0x9F, 0xF5, 0x00, 0x04, 0xFF, 0xF1,
    0x6F, 0xE2, 0x00, 0x00, 0x9F, 0xE1,
    0x03, 0x20, 0x00, 0x00, 0x03, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_004C[ 70] =   // Code 004C, LATIN CAPITAL LETTER L
{
    0x02, 0x10, 0x00, 0x00, 0x00,
    0x6F, 0xE2, 0x00, 0x00, 0x00,
    0x9F, 0xF5, 0x00, 0x00, 0x00,
    0x9F, 0xF6, 0x00, 0x00, 0x00,
    0x9F, 0xF6, 0x00, 0x00, 0x00,
    0x9F, 0xF6, 0x00, 0x00, 0x00,
    0x9F, 0xF6, 0x00, 0x00, 0x00,
    0x9F, 0xF6, 0x00, 0x00, 0x00,
    0x9F, 0xF6, 0x00, 0x00, 0x00,
    0x9F, 0xF6, 0x00, 0x00, 0x00,
    0x9F, 0xF6, 0x00, 0x00, 0x00,
    0x9F, 0xFA, 0x77, 0x77, 0x72,
    0x9F, 0xFF, 0xFF, 0xFF, 0xFB,
    0x4E, 0xFF, 0xFF, 0xFF, 0xF7
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_004D[105] =   // Code 004D, LATIN CAPITAL LETTER M
{
    0x02, 0x31, 0x00, 0x00, 0x00, 0x13, 0x20,
    0x7F, 0xFE, 0x30, 0x00, 0x02, 0xEF, 0xF7,
    0xBF, 0xFF, 0x80, 0x00, 0x08, 0xFF, 0xF9,
    0xBF, 0xFF, 0xD0, 0x00, 0x0C, 0xFF, 0xF9,
    0xBF, 0xFF, 0xF2, 0x00, 0x2F, 0xFF, 0xF9,
    0xBF, 0xFB, 0xF7, 0x00, 0x7F, 0xBF, 0xF9,
    0xBF, 0xF7, 0xFC, 0x00, 0xBF, 0x7F, 0xF9,
    0xBF, 0xF2, 0xFF, 0x21, 0xFF, 0x2F, 0xF9,
    0xBF, 0xF0, 0xCF, 0x65, 0xFC, 0x0F, 0xF9,
    0xBF, 0xF0, 0x8F, 0xBA, 0xF7, 0x0F, 0xF9,
    0xBF, 0xF0, 0x3F, 0xFE, 0xF3, 0x0F, 0xF9,
    0xBF, 0xF0, 0x0D, 0xFF, 0xD0, 0x0F, 0xF9,
    0xBF, 0xF0, 0x08, 0xFF, 0x80, 0x0F, 0xF9,
    0x8F, 0xB0, 0x03, 0xFF, 0x30, 0x0B, 0xF7,
    0x03, 0x10, 0x00, 0x22, 0x00, 0x01, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_004E[ 90] =   // Code 004E, LATIN CAPITAL LETTER N
{
    0x01, 0x20, 0x00, 0x00, 0x01, 0x20,
    0x6F, 0xF8, 0x00, 0x00, 0x1E, 0xF8,
    0xAF, 0xFF, 0x30, 0x00, 0x2F, 0xFB,
    0xBF, 0xFF, 0xC0, 0x00, 0x2F, 0xFB,
    0xBF, 0xFF, 0xF7, 0x00, 0x2F, 0xFB,
    0xBF, 0xFC, 0xFE, 0x20, 0x2F, 0xFB,
    0xBF, 0xF4, 0xEF, 0xB0, 0x2F, 0xFB,
    0xBF, 0xF2, 0x7F, 0xF5, 0x2F, 0xFB,
    0xBF, 0xF2, 0x0C, 0xFD, 0x3F, 0xFB,
    0xBF, 0xF2, 0x03, 0xFF, 0xAF, 0xFB,
    0xBF, 0xF2, 0x00, 0x8F, 0xFF, 0xFB,
    0xBF, 0xF2, 0x00, 0x0D, 0xFF, 0xFB,
    0xBF, 0xF2, 0x00, 0x04, 0xFF, 0xFA,
    0x8F, 0xE1, 0x00, 0x00, 0x9F, 0xF6,
    0x03, 0x10, 0x00, 0x00, 0x03, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_004F[105] =   // Code 004F, LATIN CAPITAL LETTER O
{
    0x00, 0x00, 0x01, 0x34, 0x30, 0x00, 0x00,
    0x00, 0x03, 0xBF, 0xFF, 0xFE, 0x91, 0x00,
    0x00, 0x6F, 0xFF, 0xFF, 0xFF, 0xFE, 0x20,
    0x03, 0xFF, 0xF9, 0x32, 0x4B, 0xFF, 0xD0,
    0x0B, 0xFF, 0x80, 0x00, 0x00, 0xCF, 0xF6,
    0x0F, 0xFF, 0x10, 0x00, 0x00, 0x5F, 0xFA,
    0x2F, 0xFC, 0x00, 0x00, 0x00, 0x2F, 0xFD,
    0x4F, 0xFB, 0x00, 0x00, 0x00, 0x2F, 0xFD,
    0x2F, 0xFC, 0x00, 0x00, 0x00, 0x2F, 0xFC,
    0x0F, 0xFF, 0x10, 0x00, 0x00, 0x5F, 0xF9,
    0x0A, 0xFF, 0x70, 0x00, 0x00, 0xCF, 0xF4,
    0x03, 0xFF, 0xF8, 0x22, 0x3B, 0xFF, 0xC0,
    0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFD, 0x20,
    0x00, 0x05, 0xDF, 0xFF, 0xFF, 0x91, 0x00,
    0x00, 0x00, 0x02, 0x44, 0x31, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0050[ 84] =   // Code 0050, LATIN CAPITAL LETTER P
{
    0x3D, 0xFF, 0xFF, 0xFD, 0xA3, 0x00,
    0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0x40,
    0x9F, 0xF9, 0x66, 0x6B, 0xFF, 0xC0,
    0x9F, 0xF6, 0x00, 0x00, 0xEF, 0xF1,
    0x9F, 0xF6, 0x00, 0x00, 0xEF, 0xF1,
    0x9F, 0xF6, 0x00, 0x18, 0xFF, 0xD0,
    0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0x60,
    0x9F, 0xFF, 0xFF, 0xFF, 0xE6, 0x00,
    0x9F, 0xF8, 0x44, 0x43, 0x00, 0x00,
    0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
    0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
    0x9F, 0xF5, 0x00, 0x00, 0x00, 0x00,
    0x6F, 0xE2, 0x00, 0x00, 0x00, 0x00,
    0x03, 0x20, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0051[105] =   // Code 0051, LATIN CAPITAL LETTER Q
{
    0x00, 0x00, 0x01, 0x34, 0x30, 0x00, 0x00,
    0x00, 0x03, 0xBF, 0xFF, 0xFE, 0x91, 0x00,
    0x00, 0x6F, 0xFF, 0xFF, 0xFF, 0xFE, 0x20,
    0x03, 0xFF, 0xF9, 0x32, 0x4B, 0xFF, 0xD0,
    0x0B, 0xFF, 0x80, 0x00, 0x00, 0xCF, 0xF6,
    0x0F, 0xFF, 0x10, 0x00, 0x00, 0x5F, 0xFA,
    0x2F, 0xFC, 0x00, 0x00, 0x00, 0x2F, 0xFD,
    0x4F, 0xFB, 0x00, 0x00, 0x00, 0x2F, 0xFD,
    0x2F, 0xFC, 0x00, 0x00, 0x00, 0x2F, 0xFC,
    0x0F, 0xFF, 0x10, 0x04, 0xB2, 0x5F, 0xF9,
    0x0A, 0xFF, 0x70, 0x09, 0xFE, 0xCF, 0xF4,
    0x03, 0xFF, 0xF8, 0x23, 0xCF, 0xFF, 0xC0,
    0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0x60,
    0x00, 0x05, 0xDF, 0xFF, 0xFF, 0xBF, 0xF4,
    0x00, 0x00, 0x02, 0x44, 0x30, 0x08, 0xF4
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0052[ 84] =   // Code 0052, LATIN CAPITAL LETTER R
{
    0x3D, 0xFF, 0xFF, 0xFE, 0xC7, 0x10,
    0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xB0,
    0x9F, 0xF9, 0x66, 0x67, 0xEF, 0xF4,
    0x9F, 0xF6, 0x00, 0x00, 0x9F, 0xF7,
    0x9F, 0xF6, 0x00, 0x00, 0x8F, 0xF5,
    0x9F, 0xF8, 0x44, 0x46, 0xEF, 0xD0,
    0x9F, 0xFF, 0xFF, 0xFF, 0xFC, 0x20,
    0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0x70,
    0x9F, 0xF6, 0x00, 0x06, 0xFF, 0xE0,
    0x9F, 0xF6, 0x00, 0x00, 0xDF, 0xF0,
    0x9F, 0xF6, 0x00, 0x00, 0xBF, 0xF1,
    0x9F, 0xF5, 0x00, 0x00, 0xBF, 0xF5,
    0x6F, 0xE2, 0x00, 0x00, 0x5F, 0xF4,
    0x03, 0x20, 0x00, 0x00, 0x03, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0053[ 90] =   // Code 0053, LATIN CAPITAL LETTER S
{
    0x00, 0x00, 0x24, 0x41, 0x00, 0x00,
    0x00, 0x5D, 0xFF, 0xFF, 0xC4, 0x00,
    0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0x70,
    0x0E, 0xFE, 0x40, 0x16, 0xEF, 0xF0,
    0x2F, 0xFA, 0x00, 0x00, 0x4D, 0x90,
    0x1F, 0xFF, 0x72, 0x00, 0x00, 0x00,
    0x0B, 0xFF, 0xFF, 0xDA, 0x61, 0x00,
    0x01, 0xAF, 0xFF, 0xFF, 0xFE, 0x50,
    0x00, 0x01, 0x69, 0xDF, 0xFF, 0xF2,
    0x01, 0x10, 0x00, 0x02, 0xCF, 0xF7,
    0x2E, 0xF4, 0x00, 0x00, 0x6F, 0xF7,
    0x2F, 0xFE, 0x40, 0x02, 0xDF, 0xF5,
    0x09, 0xFF, 0xFE, 0xDF, 0xFF, 0xC0,
    0x00, 0x6D, 0xFF, 0xFF, 0xF9, 0x10,
    0x00, 0x00, 0x34, 0x43, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0054[ 84] =   // Code 0054, LATIN CAPITAL LETTER T
{
    0x6E, 0xFF, 0xFF, 0xFF, 0xFF, 0xE7,
    0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB,
    0x27, 0x77, 0xBF, 0xFB, 0x77, 0x72,
    0x00, 0x00, 0x7F, 0xF7, 0x00, 0x00,
    0x00, 0x00, 0x7F, 0xF7, 0x00, 0x00,
    0x00, 0x00, 0x7F, 0xF7, 0x00, 0x00,
    0x00, 0x00, 0x7F, 0xF7, 0x00, 0x00,
    0x00, 0x00, 0x7F, 0xF7, 0x00, 0x00,
    0x00, 0x00, 0x7F, 0xF7, 0x00, 0x00,
    0x00, 0x00, 0x7F, 0xF7, 0x00, 0x00,
    0x00, 0x00, 0x7F, 0xF7, 0x00, 0x00,
    0x00, 0x00, 0x7F, 0xF7, 0x00, 0x00,
    0x00, 0x00, 0x4F, 0xF4, 0x00, 0x00,
    0x00, 0x00, 0x02, 0x20, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0055[ 90] =   // Code 0055, LATIN CAPITAL LETTER U
{
    0x02, 0x10, 0x00, 0x00, 0x01, 0x20,
    0x6F, 0xE2, 0x00, 0x00, 0x2E, 0xF6,
    0x9F, 0xF5, 0x00, 0x00, 0x5F, 0xF9,
    0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
    0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
    0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
    0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
    0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
    0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
    0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
    0x7F, 0xF7, 0x00, 0x00, 0x7F, 0xF8,
    0x3F, 0xFE, 0x62, 0x26, 0xEF, 0xF3,
    0x0A, 0xFF, 0xFF, 0xFF, 0xFF, 0xA0,
    0x00, 0x7E, 0xFF, 0xFF, 0xE7, 0x00,
    0x00, 0x00, 0x34, 0x43, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0056[ 90] =   // Code 0056, LATIN CAPITAL LETTER V
{
    0x02, 0x00, 0x00, 0x00, 0x01, 0x10,
    0xAF, 0xC0, 0x00, 0x00, 0x2E, 0xF5,
    0xCF, 0xF4, 0x00, 0x00, 0x7F, 0xF7,
    0x7F, 0xF9, 0x00, 0x00, 0xCF, 0xF2,
    0x2F, 0xFD, 0x00, 0x02, 0xFF, 0xB0,
    0x0B, 0xFF, 0x30, 0x07, 0xFF, 0x60,
    0x06, 0xFF, 0x70, 0x0B, 0xFF, 0x10,
    0x01, 0xFF, 0xB0, 0x1F, 0xFA, 0x00,
    0x00, 0xAF, 0xF1, 0x6F, 0xF5, 0x00,
    0x00, 0x5F, 0xF6, 0xBF, 0xE0, 0x00,
    0x00, 0x0E, 0xFB, 0xFF, 0x80, 0x00,
    0x00, 0x09, 0xFF, 0xFF, 0x30, 0x00,
    0x00, 0x04, 0xFF, 0xFD, 0x00, 0x00,
    0x00, 0x00, 0xCF, 0xF6, 0x00, 0x00,
    0x00, 0x00, 0x03, 0x20, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0057[135] =   // Code 0057, LATIN CAPITAL LETTER W
{
    0x02, 0x00, 0x00, 0x01, 0x20, 0x00, 0x00, 0x11, 0x00,
    0xAF, 0xC0, 0x00, 0x2E, 0xFB, 0x00, 0x01, 0xEF, 0x50,
    0xCF, 0xF1, 0x00, 0x6F, 0xFF, 0x10, 0x05, 0xFF, 0x70,
    0x8F, 0xF4, 0x00, 0x9F, 0xFF, 0x40, 0x08, 0xFF, 0x30,
    0x4F, 0xF7, 0x00, 0xCF, 0xFF, 0x80, 0x0B, 0xFE, 0x00,
    0x1F, 0xFA, 0x01, 0xFF, 0xAF, 0xB0, 0x0E, 0xFB, 0x00,
    0x0C, 0xFD, 0x05, 0xFE, 0x4F, 0xF0, 0x3F, 0xF7, 0x00,
    0x08, 0xFF, 0x18, 0xFA, 0x0F, 0xF3, 0x6F, 0xF3, 0x00,
    0x04, 0xFF, 0x4B, 0xF7, 0x0B, 0xF7, 0x9F, 0xE0, 0x00,
    0x00, 0xFF, 0x8F, 0xF3, 0x08, 0xFA, 0xCF, 0xA0, 0x00,
    0x00, 0xBF, 0xDF, 0xE0, 0x04, 0xFE, 0xFF, 0x70, 0x00,
    0x00, 0x7F, 0xFF, 0xA0, 0x01, 0xFF, 0xFF, 0x20, 0x00,
    0x00, 0x4F, 0xFF, 0x70, 0x00, 0xCF, 0xFE, 0x00, 0x00,
    0x00, 0x0C, 0xFE, 0x20, 0x00, 0x6F, 0xF8, 0x00, 0x00,
    0x00, 0x01, 0x41, 0x00, 0x00, 0x03, 0x30, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0058[ 90] =   // Code 0058, LATIN CAPITAL LETTER X
{
    0x01, 0x10, 0x00, 0x00, 0x11, 0x00,
    0x3F, 0xF3, 0x00, 0x04, 0xFF, 0x20,
    0x5F, 0xFC, 0x00, 0x0D, 0xFF, 0x30,
    0x0D, 0xFF, 0x60, 0x8F, 0xFA, 0x00,
    0x03, 0xFF, 0xE3, 0xFF, 0xD1, 0x00,
    0x00, 0x8F, 0xFF, 0xFF, 0x40, 0x00,
    0x00, 0x0D, 0xFF, 0xF9, 0x00, 0x00,
    0x00, 0x07, 0xFF, 0xF3, 0x00, 0x00,
    0x00, 0x2F, 0xFF, 0xFC, 0x00, 0x00,
    0x00, 0xCF, 0xFD, 0xFF, 0x70, 0x00,
    0x07, 0xFF, 0xB2, 0xFF, 0xF3, 0x00,
    0x3F, 0xFF, 0x20, 0x8F, 0xFC, 0x00,
    0xAF, 0xF7, 0x00, 0x0D, 0xFF, 0x60,
    0xAF, 0xC0, 0x00, 0x05, 0xFF, 0x40,
    0x03, 0x10, 0x00, 0x00, 0x32, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0059[ 90] =   // Code 0059, LATIN CAPITAL LETTER Y
{
    0x02, 0x10, 0x00, 0x00, 0x02, 0x00,
    0x9F, 0xC0, 0x00, 0x00, 0xBF, 0x90,
    0xBF, 0xF7, 0x00, 0x05, 0xFF, 0xC0,
    0x4F, 0xFE, 0x10, 0x0D, 0xFF, 0x40,
    0x0A, 0xFF, 0x80, 0x6F, 0xFA, 0x00,
    0x01, 0xEF, 0xF2, 0xEF, 0xE2, 0x00,
    0x00, 0x7F, 0xFE, 0xFF, 0x70, 0x00,
    0x00, 0x0C, 0xFF, 0xFD, 0x00, 0x00,
    0x00, 0x03, 0xFF, 0xF4, 0x00, 0x00,
    0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00,
    0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00,
    0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00,
    0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00,
    0x00, 0x00, 0xCF, 0xC0, 0x00, 0x00,
    0x00, 0x00, 0x03, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_005A[ 78] =   // Code 005A, LATIN CAPITAL LETTER Z
{
    0x09, 0xFF, 0xFF, 0xFF, 0xFF, 0xE6,
    0x0E, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA,
    0x03, 0x77, 0x77, 0x7B, 0xFF, 0xF4,
    0x00, 0x00, 0x00, 0x3E, 0xFF, 0x60,
    0x00, 0x00, 0x01, 0xDF, 0xF8, 0x00,
    0x00, 0x00, 0x0C, 0xFF, 0xB0, 0x00,
    0x00, 0x00, 0xAF, 0xFC, 0x10, 0x00,
    0x00, 0x07, 0xFF, 0xE2, 0x00, 0x00,
    0x00, 0x5F, 0xFF, 0x30, 0x00, 0x00,
    0x03, 0xFF, 0xF5, 0x00, 0x00, 0x00,
    0x2E, 0xFF, 0xD7, 0x77, 0x77, 0x72,
    0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB,
    0x3D, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_005B[ 51] =   // Code 005B, LEFT SQUARE BRACKET
{
    0x3D, 0xFF, 0xE2,
    0x7F, 0xFF, 0xE2,
    0x7F, 0xF0, 0x00,
    0x7F, 0xF0, 0x00,
    0x7F, 0xF0, 0x00,
    0x7F, 0xF0, 0x00,
    0x7F, 0xF0, 0x00,
    0x7F, 0xF0, 0x00,
    0x7F, 0xF0, 0x00,
    0x7F, 0xF0, 0x00,
    0x7F, 0xF0, 0x00,
    0x7F, 0xF0, 0x00,
    0x7F, 0xF0, 0x00,
    0x7F, 0xF0, 0x00,
    0x7F, 0xF9, 0x91,
    0x4F, 0xFF, 0xF3,
    0x03, 0x66, 0x40
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_005C[ 60] =   // Code 005C, REVERSE SOLIDUS
{
    0x12, 0x00, 0x00, 0x00,
    0xCF, 0x10, 0x00, 0x00,
    0x9F, 0x70, 0x00, 0x00,
    0x4F, 0xC0, 0x00, 0x00,
    0x0D, 0xF3, 0x00, 0x00,
    0x07, 0xF9, 0x00, 0x00,
    0x02, 0xFE, 0x00, 0x00,
    0x00, 0xBF, 0x50, 0x00,
    0x00, 0x5F, 0xB0, 0x00,
    0x00, 0x0E, 0xF2, 0x00,
    0x00, 0x09, 0xF7, 0x00,
    0x00, 0x03, 0xFD, 0x00,
    0x00, 0x00, 0xCF, 0x40,
    0x00, 0x00, 0x6F, 0x70,
    0x00, 0x00, 0x04, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_005D[ 51] =   // Code 005D, RIGHT SQUARE BRACKET
{
    0xBF, 0xFE, 0x60,
    0xCF, 0xFF, 0xB0,
    0x00, 0x9F, 0xB0,
    0x00, 0x9F, 0xB0,
    0x00, 0x9F, 0xB0,
    0x00, 0x9F, 0xB0,
    0x00, 0x9F, 0xB0,
    0x00, 0x9F, 0xB0,
    0x00, 0x9F, 0xB0,
    0x00, 0x9F, 0xB0,
    0x00, 0x9F, 0xB0,
    0x00, 0x9F, 0xB0,
    0x00, 0x9F, 0xB0,
    0x00, 0x9F, 0xB0,
    0x79, 0xDF, 0xB0,
    0xEF, 0xFF, 0x90,
    0x25, 0x64, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_005E[ 40] =   // Code 005E, CIRCUMFLEX ACCENT
{
    0x00, 0x03, 0x72, 0x00, 0x00,
    0x00, 0x0E, 0xFB, 0x00, 0x00,
    0x00, 0x7F, 0xFF, 0x50, 0x00,
    0x01, 0xEF, 0xAF, 0xD0, 0x00,
    0x09, 0xFB, 0x0D, 0xF6, 0x00,
    0x2F, 0xF3, 0x06, 0xFE, 0x10,
    0xAF, 0x90, 0x00, 0xCF, 0x70,
    0x69, 0x10, 0x00, 0x39, 0x50
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_005F[ 12] =   // Code 005F, LOW LINE
{
    0x49, 0x99, 0x99, 0x99, 0x99, 0x40,
    0x14, 0x44, 0x44, 0x44, 0x44, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0060[  8] =   // Code 0060, GRAVE ACCENT
{
    0x78, 0x00,
    0xEF, 0xC2,
    0x3C, 0xFE,
    0x00, 0x78
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0061[ 55] =   // Code 0061, LATIN SMALL LETTER A
{
    0x00, 0x05, 0x99, 0x96, 0x10,
    0x02, 0xDF, 0xFF, 0xFF, 0xE3,
    0x09, 0xFE, 0x74, 0x8F, 0xFB,
    0x04, 0xB3, 0x00, 0x0E, 0xFB,
    0x00, 0x15, 0x79, 0xCF, 0xFB,
    0x06, 0xFF, 0xFF, 0xDE, 0xFB,
    0x2F, 0xFC, 0x41, 0x0D, 0xFB,
    0x4F, 0xF6, 0x00, 0x3F, 0xFB,
    0x2F, 0xFE, 0x89, 0xEE, 0xFD,
    0x05, 0xEF, 0xFE, 0x67, 0xFE,
    0x00, 0x13, 0x30, 0x00, 0x31
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0062[ 75] =   // Code 0062, LATIN SMALL LETTER B
{
    0x02, 0x00, 0x00, 0x00, 0x00,
    0xCF, 0x80, 0x00, 0x00, 0x00,
    0xFF, 0x90, 0x00, 0x00, 0x00,
    0xFF, 0x90, 0x00, 0x00, 0x00,
    0xFF, 0x92, 0x89, 0x71, 0x00,
    0xFF, 0xCE, 0xFF, 0xFE, 0x20,
    0xFF, 0xFB, 0x69, 0xFF, 0xB0,
    0xFF, 0xE0, 0x00, 0xAF, 0xF2,
    0xFF, 0x90, 0x00, 0x5F, 0xF4,
    0xFF, 0x80, 0x00, 0x4F, 0xF6,
    0xFF, 0xB0, 0x00, 0x7F, 0xF3,
    0xFF, 0xF3, 0x02, 0xDF, 0xE0,
    0xFF, 0xEF, 0xDF, 0xFF, 0x70,
    0xDF, 0x6C, 0xFF, 0xF7, 0x00,
    0x13, 0x00, 0x33, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0063[ 55] =   // Code 0063, LATIN SMALL LETTER C
{
    0x00, 0x05, 0x99, 0x83, 0x00,
    0x01, 0xCF, 0xFF, 0xFF, 0xA0,
    0x0B, 0xFF, 0xA6, 0xBF, 0xF3,
    0x3F, 0xF9, 0x00, 0x0B, 0xD2,
    0x6F, 0xF4, 0x00, 0x00, 0x00,
    0x7F, 0xF2, 0x00, 0x00, 0x00,
    0x5F, 0xF4, 0x00, 0x04, 0x70,
    0x2F, 0xFC, 0x10, 0x3F, 0xF4,
    0x09, 0xFF, 0xED, 0xFF, 0xE1,
    0x00, 0x8E, 0xFF, 0xFC, 0x30,
    0x00, 0x00, 0x34, 0x20, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0064[ 75] =   // Code 0064, LATIN SMALL LETTER D
{
    0x00, 0x00, 0x00, 0x00, 0x20,
    0x00, 0x00, 0x00, 0x08, 0xFC,
    0x00, 0x00, 0x00, 0x09, 0xFF,
    0x00, 0x00, 0x00, 0x09, 0xFF,
    0x00, 0x17, 0x98, 0x29, 0xFF,
    0x02, 0xEF, 0xFF, 0xEC, 0xFF,
    0x0B, 0xFF, 0x96, 0xBF, 0xFF,
    0x2F, 0xFA, 0x00, 0x0E, 0xFF,
    0x5F, 0xF5, 0x00, 0x09, 0xFF,
    0x6F, 0xF4, 0x00, 0x08, 0xFF,
    0x4F, 0xF7, 0x00, 0x0B, 0xFF,
    0x1E, 0xFD, 0x20, 0x3F, 0xFF,
    0x07, 0xFF, 0xFD, 0xFE, 0xFF,
    0x00, 0x7F, 0xFF, 0xC6, 0xFD,
    0x00, 0x01, 0x32, 0x00, 0x31
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0065[ 66] =   // Code 0065, LATIN SMALL LETTER E
{
    0x00, 0x03, 0x89, 0x95, 0x00, 0x00,
    0x00, 0xAF, 0xFF, 0xFF, 0xC1, 0x00,
    0x09, 0xFF, 0x74, 0x6E, 0xFB, 0x00,
    0x1F, 0xF8, 0x00, 0x05, 0xFF, 0x30,
    0x4F, 0xFC, 0xBB, 0xBC, 0xFF, 0x60,
    0x6F, 0xFC, 0xBB, 0xBB, 0xBB, 0x30,
    0x4F, 0xF6, 0x00, 0x00, 0x10, 0x00,
    0x0E, 0xFD, 0x20, 0x06, 0xFA, 0x00,
    0x05, 0xFF, 0xFD, 0xEF, 0xFA, 0x00,
    0x00, 0x5D, 0xFF, 0xFE, 0x91, 0x00,
    0x00, 0x00, 0x24, 0x30, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0066[ 60] =   // Code 0066, LATIN SMALL LETTER F
{
    0x00, 0x01, 0x42, 0x00,
    0x00, 0x6F, 0xFF, 0x50,
    0x01, 0xFF, 0xFD, 0x40,
    0x02, 0xFF, 0x80, 0x00,
    0x37, 0xFF, 0xA6, 0x10,
    0xBF, 0xFF, 0xFF, 0x70,
    0x26, 0xFF, 0xA4, 0x10,
    0x02, 0xFF, 0x70, 0x00,
    0x02, 0xFF, 0x70, 0x00,
    0x02, 0xFF, 0x70, 0x00,
    0x02, 0xFF, 0x70, 0x00,
    0x02, 0xFF, 0x70, 0x00,
    0x02, 0xFF, 0x70, 0x00,
    0x01, 0xEF, 0x60, 0x00,
    0x00, 0x13, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0067[ 70] =   // Code 0067, LATIN SMALL LETTER G
{
    0x00, 0x16, 0x98, 0x31, 0x96,
    0x02, 0xDF, 0xFF, 0xFA, 0xFE,
    0x0B, 0xFF, 0xA6, 0xBF, 0xFF,
    0x2F, 0xF9, 0x00, 0x0C, 0xFF,
    0x5F, 0xF5, 0x00, 0x09, 0xFF,
    0x6F, 0xF4, 0x00, 0x09, 0xFF,
    0x3F, 0xF8, 0x00, 0x0C, 0xFF,
    0x0E, 0xFF, 0x64, 0x8F, 0xFF,
    0x04, 0xFF, 0xFF, 0xFE, 0xFF,
    0x00, 0x38, 0xBA, 0x49, 0xFF,
    0x01, 0x61, 0x00, 0x0B, 0xFC,
    0x09, 0xFD, 0x32, 0x6F, 0xF7,
    0x05, 0xFF, 0xFF, 0xFF, 0xB1,
    0x00, 0x39, 0xCD, 0xB7, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0068[ 75] =   // Code 0068, LATIN SMALL LETTER H
{
    0x02, 0x00, 0x00, 0x00, 0x00,
    0xCF, 0x80, 0x00, 0x00, 0x00,
    0xFF, 0x90, 0x00, 0x00, 0x00,
    0xFF, 0x90, 0x00, 0x00, 0x00,
    0xFF, 0x91, 0x79, 0x83, 0x00,
    0xFF, 0xBE, 0xFF, 0xFF, 0x40,
    0xFF, 0xFD, 0x8B, 0xFF, 0xB0,
    0xFF, 0xE1, 0x00, 0xDF, 0xE0,
    0xFF, 0xA0, 0x00, 0x9F, 0xF0,
    0xFF, 0x90, 0x00, 0x9F, 0xF0,
    0xFF, 0x90, 0x00, 0x9F, 0xF0,
    0xFF, 0x90, 0x00, 0x9F, 0xF0,
    0xFF, 0x90, 0x00, 0x9F, 0xF0,
    0xCF, 0x80, 0x00, 0x8F, 0xC0,
    0x13, 0x00, 0x00, 0x03, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0069[ 30] =   // Code 0069, LATIN SMALL LETTER I
{
    0x04, 0x00,
    0xAF, 0xB0,
    0xCF, 0xC0,
    0x27, 0x20,
    0x49, 0x40,
    0xCF, 0xC0,
    0xDF, 0xD0,
    0xDF, 0xD0,
    0xDF, 0xD0,
    0xDF, 0xD0,
    0xDF, 0xD0,
    0xDF, 0xD0,
    0xDF, 0xD0,
    0xAF, 0xA0,
    0x04, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_006A[ 54] =   // Code 006A, LATIN SMALL LETTER J
{
    0x00, 0x04, 0x00,
    0x00, 0xAF, 0xB0,
    0x00, 0xCF, 0xC0,
    0x00, 0x27, 0x20,
    0x00, 0x49, 0x40,
    0x00, 0xCF, 0xC0,
    0x00, 0xDF, 0xD0,
    0x00, 0xDF, 0xD0,
    0x00, 0xDF, 0xD0,
    0x00, 0xDF, 0xD0,
    0x00, 0xDF, 0xD0,
    0x00, 0xDF, 0xD0,
    0x00, 0xDF, 0xD0,
    0x00, 0xDF, 0xD0,
    0x00, 0xDF, 0xD0,
    0x05, 0xEF, 0xB0,
    0x4F, 0xFF, 0x80,
    0x1A, 0xB7, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_006B[ 75] =   // Code 006B, LATIN SMALL LETTER K
{
    0x02, 0x00, 0x00, 0x00, 0x00,
    0xCF, 0x80, 0x00, 0x00, 0x00,
    0xFF, 0x90, 0x00, 0x00, 0x00,
    0xFF, 0x90, 0x00, 0x00, 0x00,
    0xFF, 0x90, 0x02, 0x93, 0x00,
    0xFF, 0x90, 0x1D, 0xFC, 0x00,
    0xFF, 0x91, 0xDF, 0xF5, 0x00,
    0xFF, 0xAB, 0xFF, 0x60, 0x00,
    0xFF, 0xFF, 0xFB, 0x00, 0x00,
    0xFF, 0xFF, 0xFF, 0x40, 0x00,
    0xFF, 0xE6, 0xFF, 0xE2, 0x00,
    0xFF, 0x90, 0x6F, 0xFB, 0x00,
    0xFF, 0x90, 0x0B, 0xFF, 0x60,
    0xCF, 0x80, 0x01, 0xEF, 0x50,
    0x13, 0x00, 0x00, 0x13, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_006C[ 30] =   // Code 006C, LATIN SMALL LETTER L
{
    0x02, 0x00,
    0xAF, 0xA0,
    0xDF, 0xD0,
    0xDF, 0xD0,
    0xDF, 0xD0,
    0xDF, 0xD0,
    0xDF, 0xD0,
    0xDF, 0xD0,
    0xDF, 0xD0,
    0xDF, 0xD0,
    0xDF, 0xD0,
    0xDF, 0xD0,
    0xDF, 0xD0,
    0xAF, 0xA0,
    0x03, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_006D[ 88] =   // Code 006D, LATIN SMALL LETTER M
{
    0x59, 0x11, 0x79, 0x82, 0x03, 0x89, 0x72, 0x00,
    0xEF, 0x9D, 0xFF, 0xFE, 0x6F, 0xFF, 0xFE, 0x20,
    0xFF, 0xFC, 0x8C, 0xFF, 0xFC, 0x8C, 0xFF, 0x70,
    0xFF, 0xE1, 0x02, 0xFF, 0xD1, 0x02, 0xFF, 0x90,
    0xFF, 0xA0, 0x00, 0xFF, 0xA0, 0x00, 0xFF, 0x90,
    0xFF, 0x90, 0x00, 0xFF, 0x90, 0x00, 0xFF, 0x90,
    0xFF, 0x90, 0x00, 0xFF, 0x90, 0x00, 0xFF, 0x90,
    0xFF, 0x90, 0x00, 0xFF, 0x90, 0x00, 0xFF, 0x90,
    0xFF, 0x90, 0x00, 0xFF, 0x90, 0x00, 0xFF, 0x90,
    0xCF, 0x80, 0x00, 0xDF, 0x80, 0x00, 0xDF, 0x70,
    0x13, 0x00, 0x00, 0x13, 0x00, 0x00, 0x13, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_006E[ 55] =   // Code 006E, LATIN SMALL LETTER N
{
    0x59, 0x11, 0x79, 0x83, 0x00,
    0xEF, 0x8E, 0xFF, 0xFF, 0x40,
    0xFF, 0xFD, 0x8B, 0xFF, 0xB0,
    0xFF, 0xE1, 0x00, 0xDF, 0xE0,
    0xFF, 0xA0, 0x00, 0x9F, 0xF0,
    0xFF, 0x90, 0x00, 0x9F, 0xF0,
    0xFF, 0x90, 0x00, 0x9F, 0xF0,
    0xFF, 0x90, 0x00, 0x9F, 0xF0,
    0xFF, 0x90, 0x00, 0x9F, 0xF0,
    0xCF, 0x80, 0x00, 0x8F, 0xC0,
    0x13, 0x00, 0x00, 0x03, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_006F[ 66] =   // Code 006F, LATIN SMALL LETTER O
{
    0x00, 0x04, 0x89, 0x84, 0x00, 0x00,
    0x01, 0xBF, 0xFF, 0xFF, 0xB1, 0x00,
    0x0A, 0xFF, 0x95, 0x8F, 0xFA, 0x00,
    0x1F, 0xFA, 0x00, 0x0A, 0xFF, 0x20,
    0x5F, 0xF5, 0x00, 0x05, 0xFF, 0x50,
    0x6F, 0xF4, 0x00, 0x04, 0xFF, 0x60,
    0x4F, 0xF7, 0x00, 0x06, 0xFF, 0x40,
    0x0E, 0xFD, 0x10, 0x1D, 0xFE, 0x10,
    0x07, 0xFF, 0xEB, 0xEF, 0xF7, 0x00,
    0x00, 0x6E, 0xFF, 0xFE, 0x60, 0x00,
    0x00, 0x00, 0x34, 0x30, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0070[ 70] =   // Code 0070, LATIN SMALL LETTER P
{
    0x69, 0x13, 0x99, 0x61, 0x00,
    0xEF, 0xAF, 0xFF, 0xFD, 0x20,
    0xFF, 0xFB, 0x6A, 0xFF, 0xB0,
    0xFF, 0xD0, 0x00, 0xAF, 0xF2,
    0xFF, 0x90, 0x00, 0x5F, 0xF4,
    0xFF, 0x80, 0x00, 0x4F, 0xF6,
    0xFF, 0xB0, 0x00, 0x7F, 0xF3,
    0xFF, 0xF3, 0x01, 0xDF, 0xE1,
    0xFF, 0xFF, 0xDE, 0xFF, 0x80,
    0xFF, 0xAB, 0xFF, 0xF9, 0x00,
    0xFF, 0x90, 0x24, 0x10, 0x00,
    0xFF, 0x90, 0x00, 0x00, 0x00,
    0xEF, 0x90, 0x00, 0x00, 0x00,
    0x6B, 0x30, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0071[ 70] =   // Code 0071, LATIN SMALL LETTER Q
{
    0x00, 0x16, 0x99, 0x31, 0x96,
    0x02, 0xDF, 0xFF, 0xFA, 0xFE,
    0x0B, 0xFF, 0xA6, 0xBF, 0xFF,
    0x2F, 0xFA, 0x00, 0x0D, 0xFF,
    0x5F, 0xF5, 0x00, 0x09, 0xFF,
    0x6F, 0xF4, 0x00, 0x08, 0xFF,
    0x4F, 0xF7, 0x00, 0x0B, 0xFF,
    0x1F, 0xFD, 0x10, 0x3F, 0xFF,
    0x08, 0xFF, 0xED, 0xFF, 0xFF,
    0x00, 0x9F, 0xFF, 0xBA, 0xFF,
    0x00, 0x01, 0x42, 0x09, 0xFF,
    0x00, 0x00, 0x00, 0x09, 0xFF,
    0x00, 0x00, 0x00, 0x09, 0xFE,
    0x00, 0x00, 0x00, 0x03, 0xB6
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0072[ 44] =   // Code 0072, LATIN SMALL LETTER R
{
    0x49, 0x22, 0x97, 0x00,
    0xCF, 0x9E, 0xFF, 0x30,
    0xDF, 0xFF, 0xFB, 0x10,
    0xDF, 0xF5, 0x00, 0x00,
    0xDF, 0xE0, 0x00, 0x00,
    0xDF, 0xD0, 0x00, 0x00,
    0xDF, 0xD0, 0x00, 0x00,
    0xDF, 0xD0, 0x00, 0x00,
    0xDF, 0xD0, 0x00, 0x00,
    0xAF, 0xA0, 0x00, 0x00,
    0x04, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0073[ 55] =   // Code 0073, LATIN SMALL LETTER S
{
    0x00, 0x48, 0x99, 0x61, 0x00,
    0x0A, 0xFF, 0xFF, 0xFE, 0x30,
    0x4F, 0xFA, 0x46, 0xEF, 0x80,
    0x6F, 0xF7, 0x00, 0x27, 0x10,
    0x2F, 0xFF, 0xFB, 0x82, 0x00,
    0x04, 0xCF, 0xFF, 0xFF, 0x50,
    0x03, 0x01, 0x59, 0xEF, 0xE0,
    0x4F, 0xC1, 0x00, 0xAF, 0xF0,
    0x3F, 0xFE, 0xAB, 0xFF, 0xA0,
    0x04, 0xCF, 0xFF, 0xF9, 0x10,
    0x00, 0x01, 0x33, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0074[ 56] =   // Code 0074, LATIN SMALL LETTER T
{
    0x00, 0x33, 0x00, 0x00,
    0x02, 0xFF, 0x40, 0x00,
    0x04, 0xFF, 0x60, 0x00,
    0x38, 0xFF, 0x95, 0x10,
    0xBF, 0xFF, 0xFF, 0x50,
    0x27, 0xFF, 0x94, 0x00,
    0x04, 0xFF, 0x60, 0x00,
    0x04, 0xFF, 0x60, 0x00,
    0x04, 0xFF, 0x60, 0x00,
    0x04, 0xFF, 0x60, 0x00,
    0x04, 0xFF, 0x60, 0x00,
    0x03, 0xFF, 0xEC, 0x30,
    0x00, 0xBF, 0xFF, 0x30,
    0x00, 0x02, 0x41, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0075[ 55] =   // Code 0075, LATIN SMALL LETTER U
{
    0x59, 0x30, 0x00, 0x39, 0x50,
    0xEF, 0x90, 0x00, 0x9F, 0xE0,
    0xFF, 0x90, 0x00, 0x9F, 0xF0,
    0xFF, 0x90, 0x00, 0x9F, 0xF0,
    0xFF, 0x90, 0x00, 0x9F, 0xF0,
    0xFF, 0x90, 0x00, 0x9F, 0xF0,
    0xFF, 0xA0, 0x00, 0xBF, 0xF0,
    0xEF, 0xE2, 0x06, 0xFF, 0xF0,
    0x9F, 0xFF, 0xEF, 0xEF, 0xF0,
    0x1C, 0xFF, 0xF9, 0x5F, 0xD0,
    0x00, 0x24, 0x10, 0x03, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0076[ 55] =   // Code 0076, LATIN SMALL LETTER V
{
    0x49, 0x20, 0x00, 0x29, 0x40,
    0xDF, 0xB0, 0x00, 0xBF, 0xD0,
    0xAF, 0xF1, 0x01, 0xFF, 0xA0,
    0x5F, 0xF5, 0x05, 0xFF, 0x50,
    0x0E, 0xF9, 0x09, 0xFE, 0x00,
    0x09, 0xFE, 0x0E, 0xF9, 0x00,
    0x03, 0xFF, 0x7F, 0xF3, 0x00,
    0x00, 0xDF, 0xEF, 0xD0, 0x00,
    0x00, 0x8F, 0xFF, 0x80, 0x00,
    0x00, 0x2F, 0xFF, 0x20, 0x00,
    0x00, 0x02, 0x42, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0077[ 77] =   // Code 0077, LATIN SMALL LETTER W
{
    0x39, 0x40, 0x01, 0x89, 0x10, 0x04, 0x93,
    0xBF, 0xB0, 0x07, 0xFF, 0x80, 0x0B, 0xFB,
    0x9F, 0xF1, 0x0B, 0xFF, 0xC0, 0x0F, 0xF9,
    0x4F, 0xF4, 0x0E, 0xFF, 0xF1, 0x3F, 0xF4,
    0x0E, 0xF7, 0x2F, 0xCC, 0xF3, 0x7F, 0xE0,
    0x0A, 0xFB, 0x5F, 0x88, 0xF7, 0xAF, 0xA0,
    0x06, 0xFE, 0x9F, 0x44, 0xFA, 0xDF, 0x60,
    0x01, 0xFF, 0xEF, 0x11, 0xFE, 0xFF, 0x10,
    0x00, 0xBF, 0xFC, 0x00, 0xCF, 0xFB, 0x00,
    0x00, 0x6F, 0xF7, 0x00, 0x7F, 0xF6, 0x00,
    0x00, 0x03, 0x30, 0x00, 0x03, 0x30, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0078[ 55] =   // Code 0078, LATIN SMALL LETTER X
{
    0x18, 0x70, 0x00, 0x78, 0x00,
    0x7F, 0xF4, 0x05, 0xFF, 0x30,
    0x2F, 0xFD, 0x1E, 0xFD, 0x00,
    0x07, 0xFF, 0xDF, 0xF3, 0x00,
    0x00, 0xCF, 0xFF, 0x80, 0x00,
    0x00, 0x8F, 0xFF, 0x50, 0x00,
    0x04, 0xFF, 0xFF, 0xD1, 0x00,
    0x1D, 0xFE, 0x6F, 0xF9, 0x00,
    0x8F, 0xF5, 0x0B, 0xFF, 0x30,
    0x8F, 0xB0, 0x02, 0xEF, 0x30,
    0x03, 0x00, 0x00, 0x22, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0079[ 70] =   // Code 0079, LATIN SMALL LETTER Y
{
    0x39, 0x40, 0x00, 0x39, 0x30,
    0xBF, 0xD0, 0x00, 0xCF, 0xB0,
    0x8F, 0xF2, 0x01, 0xFF, 0x80,
    0x3F, 0xF7, 0x05, 0xFF, 0x30,
    0x0D, 0xFB, 0x09, 0xFD, 0x00,
    0x08, 0xFE, 0x0D, 0xF7, 0x00,
    0x03, 0xFF, 0x6F, 0xF2, 0x00,
    0x00, 0xCF, 0xEF, 0xB0, 0x00,
    0x00, 0x7F, 0xFF, 0x70, 0x00,
    0x00, 0x2F, 0xFF, 0x10, 0x00,
    0x00, 0x0C, 0xFB, 0x00, 0x00,
    0x06, 0x8F, 0xF5, 0x00, 0x00,
    0x1F, 0xFF, 0xC0, 0x00, 0x00,
    0x07, 0xB8, 0x10, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_007A[ 50] =   // Code 007A, LATIN SMALL LETTER Z
{
    0x03, 0x66, 0x66, 0x66, 0x50,
    0x0F, 0xFF, 0xFF, 0xFF, 0xF5,
    0x07, 0x99, 0x9B, 0xFF, 0xE1,
    0x00, 0x00, 0x1D, 0xFE, 0x30,
    0x00, 0x01, 0xDF, 0xF4, 0x00,
    0x00, 0x1B, 0xFF, 0x50, 0x00,
    0x00, 0xBF, 0xF7, 0x00, 0x00,
    0x0A, 0xFF, 0x80, 0x00, 0x00,
    0x5F, 0xFF, 0xFF, 0xFF, 0xF5,
    0x4F, 0xFF, 0xFF, 0xFF, 0xF4
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_007B[ 68] =   // Code 007B, LEFT CURLY BRACKET
{
    0x00, 0x6D, 0xFE, 0x30,
    0x01, 0xFF, 0xC9, 0x20,
    0x03, 0xFF, 0x40, 0x00,
    0x04, 0xFF, 0x40, 0x00,
    0x04, 0xFF, 0x40, 0x00,
    0x04, 0xFF, 0x40, 0x00,
    0x04, 0xFF, 0x30, 0x00,
    0x8D, 0xFB, 0x00, 0x00,
    0xDF, 0xE7, 0x00, 0x00,
    0x06, 0xFF, 0x10, 0x00,
    0x04, 0xFF, 0x40, 0x00,
    0x04, 0xFF, 0x40, 0x00,
    0x04, 0xFF, 0x40, 0x00,
    0x03, 0xFF, 0x40, 0x00,
    0x02, 0xFF, 0x95, 0x00,
    0x00, 0xBF, 0xFF, 0x40,
    0x00, 0x03, 0x55, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_007C[ 30] =   // Code 007C, VERTICAL LINE
{
    0x02, 0x20,
    0x1E, 0xE1,
    0x2F, 0xF2,
    0x2F, 0xF2,
    0x2F, 0xF2,
    0x2F, 0xF2,
    0x2F, 0xF2,
    0x2F, 0xF2,
    0x2F, 0xF2,
    0x2F, 0xF2,
    0x2F, 0xF2,
    0x2F, 0xF2,
    0x2F, 0xF2,
    0x1F, 0xF1,
    0x02, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_007D[ 68] =   // Code 007D, RIGHT CURLY BRACKET
{
    0xCF, 0xEA, 0x00, 0x00,
    0x8B, 0xFF, 0x60, 0x00,
    0x00, 0xDF, 0x70, 0x00,
    0x00, 0xDF, 0x70, 0x00,
    0x00, 0xDF, 0x70, 0x00,
    0x00, 0xDF, 0x70, 0x00,
    0x00, 0xDF, 0x80, 0x00,
    0x00, 0x7F, 0xEA, 0x10,
    0x00, 0x3C, 0xFF, 0x30,
    0x00, 0xCF, 0xA0, 0x00,
    0x00, 0xDF, 0x70, 0x00,
    0x00, 0xDF, 0x70, 0x00,
    0x00, 0xDF, 0x70, 0x00,
    0x00, 0xDF, 0x70, 0x00,
    0x36, 0xFF, 0x70, 0x00,
    0xEF, 0xFE, 0x20, 0x00,
    0x36, 0x41, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_007E[ 24] =   // Code 007E, TILDE
{
    0x02, 0xAB, 0x83, 0x00, 0x38, 0x00,
    0x0D, 0xFF, 0xFF, 0xBA, 0xFF, 0x00,
    0x4F, 0xC6, 0xAF, 0xFF, 0xF9, 0x00,
    0x06, 0x10, 0x01, 0x79, 0x50, 0x00
};

GUI_CONST_STORAGE GUI_CHARINFO_EXT GUI_FontRounded22_CharInfo[95] =
{
    {   1,   1,   0,  18,   6, acGUI_FontRounded22_0020 } // Code 0020, SPACE
    , {   4,  15,   1,   4,   6, acGUI_FontRounded22_0021 } // Code 0021, EXCLAMATION MARK
    , {   7,   7,   1,   4,  10, acGUI_FontRounded22_0022 } // Code 0022, QUOTATION MARK
    , {  11,  14,   0,   5,  11, acGUI_FontRounded22_0023 } // Code 0023, NUMBER SIGN
    , {  11,  16,   0,   4,  11, acGUI_FontRounded22_0024 } // Code 0024, DOLLAR SIGN
    , {  16,  15,   1,   4,  18, acGUI_FontRounded22_0025 } // Code 0025, PERCENT SIGN
    , {  13,  15,   0,   4,  13, acGUI_FontRounded22_0026 } // Code 0026, AMPERSAND
    , {   3,   7,   1,   4,   6, acGUI_FontRounded22_0027 } // Code 0027, APOSTROPHE
    , {   5,  18,   1,   4,   6, acGUI_FontRounded22_0028 } // Code 0028, LEFT PARENTHESIS
    , {   5,  18,   0,   4,   6, acGUI_FontRounded22_0029 } // Code 0029, RIGHT PARENTHESIS
    , {   8,   8,   0,   4,   8, acGUI_FontRounded22_002A } // Code 002A, ASTERISK
    , {  11,  11,   0,   7,  11, acGUI_FontRounded22_002B } // Code 002B, PLUS SIGN
    , {   4,   6,   1,  15,   6, acGUI_FontRounded22_002C } // Code 002C, COMMA
    , {   7,   4,   0,  11,   7, acGUI_FontRounded22_002D } // Code 002D, HYPHEN-MINUS
    , {   4,   4,   1,  15,   6, acGUI_FontRounded22_002E } // Code 002E, FULL STOP
    , {   7,  15,   0,   4,   7, acGUI_FontRounded22_002F } // Code 002F, SOLIDUS
    , {  11,  14,   0,   5,  11, acGUI_FontRounded22_0030 } // Code 0030, DIGIT ZERO
    , {   7,  14,  -1,   5,   7, acGUI_FontRounded22_0031 } // Code 0031, DIGIT ONE
    , {  11,  13,   0,   5,  11, acGUI_FontRounded22_0032 } // Code 0032, DIGIT TWO
    , {  10,  14,   0,   5,  11, acGUI_FontRounded22_0033 } // Code 0033, DIGIT THREE
    , {  11,  14,   0,   5,  11, acGUI_FontRounded22_0034 } // Code 0034, DIGIT FOUR
    , {  10,  14,   0,   5,  11, acGUI_FontRounded22_0035 } // Code 0035, DIGIT FIVE
    , {  11,  14,   0,   5,  11, acGUI_FontRounded22_0036 } // Code 0036, DIGIT SIX
    , {  10,  14,   0,   5,  10, acGUI_FontRounded22_0037 } // Code 0037, DIGIT SEVEN
    , {  11,  14,   0,   5,  11, acGUI_FontRounded22_0038 } // Code 0038, DIGIT EIGHT
    , {  11,  14,   0,   5,  11, acGUI_FontRounded22_0039 } // Code 0039, DIGIT NINE
    , {   4,  11,   1,   8,   6, acGUI_FontRounded22_003A } // Code 003A, COLON
    , {   4,  13,   1,   8,   6, acGUI_FontRounded22_003B } // Code 003B, SEMICOLON
    , {  11,  10,   0,   8,  11, acGUI_FontRounded22_003C } // Code 003C, LESS-THAN SIGN
    , {  11,   8,   0,   9,  11, acGUI_FontRounded22_003D } // Code 003D, EQUALS SIGN
    , {  11,  10,   0,   8,  11, acGUI_FontRounded22_003E } // Code 003E, GREATER-THAN SIGN
    , {  10,  15,   0,   4,  10, acGUI_FontRounded22_003F } // Code 003F, QUESTION MARK
    , {  14,  15,   0,   4,  14, acGUI_FontRounded22_0040 } // Code 0040, COMMERCIAL AT
    , {  12,  15,   0,   4,  12, acGUI_FontRounded22_0041 } // Code 0041, LATIN CAPITAL LETTER A
    , {  12,  13,   1,   5,  13, acGUI_FontRounded22_0042 } // Code 0042, LATIN CAPITAL LETTER B
    , {  12,  15,   1,   4,  13, acGUI_FontRounded22_0043 } // Code 0043, LATIN CAPITAL LETTER C
    , {  12,  13,   1,   5,  14, acGUI_FontRounded22_0044 } // Code 0044, LATIN CAPITAL LETTER D
    , {  11,  13,   1,   5,  12, acGUI_FontRounded22_0045 } // Code 0045, LATIN CAPITAL LETTER E
    , {  11,  14,   1,   5,  11, acGUI_FontRounded22_0046 } // Code 0046, LATIN CAPITAL LETTER F
    , {  13,  15,   1,   4,  15, acGUI_FontRounded22_0047 } // Code 0047, LATIN CAPITAL LETTER G
    , {  12,  15,   1,   4,  14, acGUI_FontRounded22_0048 } // Code 0048, LATIN CAPITAL LETTER H
    , {   4,  15,   1,   4,   6, acGUI_FontRounded22_0049 } // Code 0049, LATIN CAPITAL LETTER I
    , {   9,  15,   0,   4,  10, acGUI_FontRounded22_004A } // Code 004A, LATIN CAPITAL LETTER J
    , {  12,  15,   1,   4,  12, acGUI_FontRounded22_004B } // Code 004B, LATIN CAPITAL LETTER K
    , {  10,  14,   1,   4,  11, acGUI_FontRounded22_004C } // Code 004C, LATIN CAPITAL LETTER L
    , {  14,  15,   1,   4,  16, acGUI_FontRounded22_004D } // Code 004D, LATIN CAPITAL LETTER M
    , {  12,  15,   1,   4,  14, acGUI_FontRounded22_004E } // Code 004E, LATIN CAPITAL LETTER N
    , {  14,  15,   0,   4,  15, acGUI_FontRounded22_004F } // Code 004F, LATIN CAPITAL LETTER O
    , {  12,  14,   1,   5,  13, acGUI_FontRounded22_0050 } // Code 0050, LATIN CAPITAL LETTER P
    , {  14,  15,   0,   4,  15, acGUI_FontRounded22_0051 } // Code 0051, LATIN CAPITAL LETTER Q
    , {  12,  14,   1,   5,  13, acGUI_FontRounded22_0052 } // Code 0052, LATIN CAPITAL LETTER R
    , {  12,  15,   0,   4,  12, acGUI_FontRounded22_0053 } // Code 0053, LATIN CAPITAL LETTER S
    , {  12,  14,   0,   5,  12, acGUI_FontRounded22_0054 } // Code 0054, LATIN CAPITAL LETTER T
    , {  12,  15,   1,   4,  14, acGUI_FontRounded22_0055 } // Code 0055, LATIN CAPITAL LETTER U
    , {  12,  15,   0,   4,  12, acGUI_FontRounded22_0056 } // Code 0056, LATIN CAPITAL LETTER V
    , {  17,  15,   0,   4,  17, acGUI_FontRounded22_0057 } // Code 0057, LATIN CAPITAL LETTER W
    , {  11,  15,   0,   4,  11, acGUI_FontRounded22_0058 } // Code 0058, LATIN CAPITAL LETTER X
    , {  11,  15,   0,   4,  11, acGUI_FontRounded22_0059 } // Code 0059, LATIN CAPITAL LETTER Y
    , {  12,  13,   0,   5,  12, acGUI_FontRounded22_005A } // Code 005A, LATIN CAPITAL LETTER Z
    , {   6,  17,   1,   5,   6, acGUI_FontRounded22_005B } // Code 005B, LEFT SQUARE BRACKET
    , {   7,  15,   0,   4,   7, acGUI_FontRounded22_005C } // Code 005C, REVERSE SOLIDUS
    , {   5,  17,   0,   5,   6, acGUI_FontRounded22_005D } // Code 005D, RIGHT SQUARE BRACKET
    , {   9,   8,   1,   5,  11, acGUI_FontRounded22_005E } // Code 005E, CIRCUMFLEX ACCENT
    , {  11,   2,  -1,  19,   9, acGUI_FontRounded22_005F } // Code 005F, LOW LINE
    , {   4,   4,   0,   4,   5, acGUI_FontRounded22_0060 } // Code 0060, GRAVE ACCENT
    , {  10,  11,   0,   8,  11, acGUI_FontRounded22_0061 } // Code 0061, LATIN SMALL LETTER A
    , {  10,  15,   1,   4,  11, acGUI_FontRounded22_0062 } // Code 0062, LATIN SMALL LETTER B
    , {  10,  11,   0,   8,  10, acGUI_FontRounded22_0063 } // Code 0063, LATIN SMALL LETTER C
    , {  10,  15,   0,   4,  11, acGUI_FontRounded22_0064 } // Code 0064, LATIN SMALL LETTER D
    , {  11,  11,   0,   8,  11, acGUI_FontRounded22_0065 } // Code 0065, LATIN SMALL LETTER E
    , {   7,  15,   0,   4,   7, acGUI_FontRounded22_0066 } // Code 0066, LATIN SMALL LETTER F
    , {  10,  14,   0,   8,  11, acGUI_FontRounded22_0067 } // Code 0067, LATIN SMALL LETTER G
    , {   9,  15,   1,   4,  11, acGUI_FontRounded22_0068 } // Code 0068, LATIN SMALL LETTER H
    , {   3,  15,   1,   4,   5, acGUI_FontRounded22_0069 } // Code 0069, LATIN SMALL LETTER I
    , {   5,  18,  -1,   4,   5, acGUI_FontRounded22_006A } // Code 006A, LATIN SMALL LETTER J
    , {   9,  15,   1,   4,  10, acGUI_FontRounded22_006B } // Code 006B, LATIN SMALL LETTER K
    , {   3,  15,   1,   4,   5, acGUI_FontRounded22_006C } // Code 006C, LATIN SMALL LETTER L
    , {  15,  11,   1,   8,  17, acGUI_FontRounded22_006D } // Code 006D, LATIN SMALL LETTER M
    , {   9,  11,   1,   8,  11, acGUI_FontRounded22_006E } // Code 006E, LATIN SMALL LETTER N
    , {  11,  11,   0,   8,  11, acGUI_FontRounded22_006F } // Code 006F, LATIN SMALL LETTER O
    , {  10,  14,   1,   8,  11, acGUI_FontRounded22_0070 } // Code 0070, LATIN SMALL LETTER P
    , {  10,  14,   0,   8,  11, acGUI_FontRounded22_0071 } // Code 0071, LATIN SMALL LETTER Q
    , {   7,  11,   1,   8,   7, acGUI_FontRounded22_0072 } // Code 0072, LATIN SMALL LETTER R
    , {   9,  11,   0,   8,  10, acGUI_FontRounded22_0073 } // Code 0073, LATIN SMALL LETTER S
    , {   7,  14,   0,   5,   7, acGUI_FontRounded22_0074 } // Code 0074, LATIN SMALL LETTER T
    , {   9,  11,   1,   8,  11, acGUI_FontRounded22_0075 } // Code 0075, LATIN SMALL LETTER U
    , {   9,  11,   0,   8,   9, acGUI_FontRounded22_0076 } // Code 0076, LATIN SMALL LETTER V
    , {  14,  11,   0,   8,  14, acGUI_FontRounded22_0077 } // Code 0077, LATIN SMALL LETTER W
    , {   9,  11,   0,   8,   9, acGUI_FontRounded22_0078 } // Code 0078, LATIN SMALL LETTER X
    , {   9,  14,   0,   8,   9, acGUI_FontRounded22_0079 } // Code 0079, LATIN SMALL LETTER Y
    , {  10,  10,   0,   8,  10, acGUI_FontRounded22_007A } // Code 007A, LATIN SMALL LETTER Z
    , {   7,  17,   0,   5,   6, acGUI_FontRounded22_007B } // Code 007B, LEFT CURLY BRACKET
    , {   4,  15,   0,   4,   4, acGUI_FontRounded22_007C } // Code 007C, VERTICAL LINE
    , {   7,  17,   0,   5,   6, acGUI_FontRounded22_007D } // Code 007D, RIGHT CURLY BRACKET
    , {  11,   4,   0,  11,  11, acGUI_FontRounded22_007E } // Code 007E, TILDE
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontRounded22_Prop1 =
{
    0x0020,                                   // First character
    0x007E,                                   // Last character
    &GUI_FontRounded22_CharInfo[0],           // Address of first character
    (GUI_CONST_STORAGE GUI_FONT_PROP_EXT *)0  // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT GUI_FontRounded22 =
{
    GUI_FONTTYPE_PROP_AA4_EXT,     // Type of font
    22,                            // Height of font
    22,                            // Space of font y
    1,                             // Magnification x
    1,                             // Magnification y
    { &GUI_FontRounded22_Prop1 },
    22,                            // Baseline
    11,                            // Height of lowercase characters
    15                             // Height of capital characters
};

/*********************************************************************
*                                                                    *
*       GUI_FontSouvenir18                                           *
*                                                                    *
*  Used in                                                           *
*  - GUIDEMO.c                                                       *
*  - GUIDEMO_ColorBar.c                                              *
*  - GUIDEMO_Intro.c                                                 *
*                                                                    *
**********************************************************************
*/
GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0020[  1] =   // Code 0020, SPACE
{
    0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0021[ 11] =   // Code 0021, EXCLAMATION MARK
{
    0xCB,
    0xED,
    0xDC,
    0xBB,
    0xA9,
    0x97,
    0x76,
    0x54,
    0x00,
    0xCC,
    0xCC
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0022[  8] =   // Code 0022, QUOTATION MARK
{
    0xE0, 0xE0,
    0xC0, 0xC0,
    0x80, 0x80,
    0x50, 0x50
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0023[ 55] =   // Code 0023, NUMBER SIGN
{
    0x00, 0x00, 0x3B, 0x02, 0xC0,
    0x00, 0x00, 0x87, 0x07, 0x80,
    0x00, 0x00, 0xC2, 0x0B, 0x30,
    0x00, 0x02, 0xC0, 0x1D, 0x00,
    0x0E, 0xFF, 0xFF, 0xFF, 0xFD,
    0x00, 0x0C, 0x30, 0xA4, 0x00,
    0x00, 0x2C, 0x01, 0xD0, 0x00,
    0xDF, 0xFF, 0xFF, 0xFF, 0xE0,
    0x00, 0xC2, 0x0C, 0x30, 0x00,
    0x03, 0xB0, 0x3C, 0x00, 0x00,
    0x0A, 0x50, 0x96, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0024[ 60] =   // Code 0024, DOLLAR SIGN
{
    0x00, 0x01, 0x00, 0x00,
    0x00, 0x0F, 0x00, 0x00,
    0x03, 0xDF, 0xE7, 0x00,
    0x0C, 0x5F, 0x1C, 0x30,
    0x0F, 0x0F, 0x05, 0x30,
    0x0E, 0x3F, 0x00, 0x00,
    0x07, 0xEF, 0x30, 0x00,
    0x00, 0x6F, 0xFA, 0x10,
    0x00, 0x0F, 0x4C, 0xA0,
    0x00, 0x0F, 0x02, 0xF0,
    0xD0, 0x0F, 0x01, 0xE0,
    0x99, 0x1F, 0x2A, 0x70,
    0x08, 0xEF, 0xC6, 0x00,
    0x00, 0x0F, 0x00, 0x00,
    0x00, 0x09, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0025[ 78] =   // Code 0025, PERCENT SIGN
{
    0x00, 0x00, 0x00, 0x00, 0x10, 0x00,
    0x2C, 0xFC, 0x61, 0x06, 0xC0, 0x00,
    0xC6, 0x06, 0xEE, 0xED, 0x40, 0x00,
    0xF0, 0x00, 0xF0, 0x19, 0x00, 0x00,
    0xC6, 0x06, 0xD0, 0x82, 0x00, 0x00,
    0x3C, 0xFC, 0x33, 0x70, 0x00, 0x00,
    0x00, 0x00, 0x0A, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x74, 0x2C, 0xFC, 0x20,
    0x00, 0x02, 0x90, 0xC6, 0x06, 0xC0,
    0x00, 0x0A, 0x20, 0xF0, 0x00, 0xF0,
    0x00, 0x57, 0x00, 0xC6, 0x06, 0xC0,
    0x00, 0xA0, 0x00, 0x2C, 0xFC, 0x20,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0026[ 66] =   // Code 0026, AMPERSAND
{
    0x01, 0xBF, 0xD3, 0x00, 0x00, 0x00,
    0x0B, 0x70, 0x6D, 0x00, 0x00, 0x00,
    0x0F, 0x00, 0x0F, 0x00, 0x00, 0x00,
    0x0D, 0x40, 0x79, 0x00, 0x00, 0x00,
    0x08, 0xCA, 0xA0, 0x00, 0x00, 0x00,
    0x05, 0xFA, 0x00, 0x8F, 0xFC, 0x20,
    0x5B, 0x7F, 0x40, 0x09, 0x90, 0x00,
    0xD2, 0x08, 0xE2, 0x2B, 0x00, 0x00,
    0xF1, 0x00, 0x9E, 0xC1, 0x00, 0x00,
    0xB9, 0x11, 0x7D, 0xF9, 0x32, 0x30,
    0x1B, 0xFE, 0x80, 0x4A, 0xDC, 0x80
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0027[  4] =   // Code 0027, APOSTROPHE
{
    0xE0,
    0xC0,
    0x80,
    0x50
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0028[ 26] =   // Code 0028, LEFT PARENTHESIS
{
    0x02, 0xC0,
    0x0A, 0x40,
    0x3C, 0x00,
    0x87, 0x00,
    0xC3, 0x00,
    0xE1, 0x00,
    0xF0, 0x00,
    0xE1, 0x00,
    0xC3, 0x00,
    0x87, 0x00,
    0x3C, 0x00,
    0x0A, 0x40,
    0x02, 0xB0
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0029[ 26] =   // Code 0029, RIGHT PARENTHESIS
{
    0xC2, 0x00,
    0x5A, 0x00,
    0x0C, 0x30,
    0x07, 0x80,
    0x03, 0xC0,
    0x01, 0xE0,
    0x00, 0xF0,
    0x01, 0xE0,
    0x03, 0xC0,
    0x07, 0x80,
    0x0C, 0x30,
    0x5A, 0x00,
    0xB2, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_002A[ 18] =   // Code 002A, ASTERISK
{
    0x00, 0xE0, 0x00,
    0xB3, 0x93, 0xB0,
    0x68, 0x77, 0x60,
    0x68, 0x78, 0x60,
    0xB3, 0x93, 0xB0,
    0x00, 0xE0, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_002B[ 45] =   // Code 002B, PLUS SIGN
{
    0x00, 0x00, 0xF0, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0x00, 0x00,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
    0x00, 0x00, 0xF0, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_002C[  4] =   // Code 002C, COMMA
{
    0xCB,
    0xDF,
    0x07,
    0x52
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_002D[  2] =   // Code 002D, HYPHEN-MINUS
{
    0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_002E[  2] =   // Code 002E, FULL STOP
{
    0xCC,
    0xCC
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_002F[ 24] =   // Code 002F, SOLIDUS
{
    0x00, 0x09,
    0x00, 0x09,
    0x00, 0x45,
    0x00, 0x81,
    0x00, 0x90,
    0x03, 0x70,
    0x07, 0x20,
    0x09, 0x00,
    0x18, 0x00,
    0x54, 0x00,
    0x90, 0x00,
    0x90, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0030[ 44] =   // Code 0030, DIGIT ZERO
{
    0x04, 0xCF, 0xC4, 0x00,
    0x2D, 0x30, 0x3D, 0x20,
    0x95, 0x00, 0x05, 0x90,
    0xC2, 0x00, 0x02, 0xC0,
    0xF0, 0x00, 0x00, 0xF0,
    0xF0, 0x00, 0x00, 0xF0,
    0xF0, 0x00, 0x00, 0xF0,
    0xC2, 0x00, 0x02, 0xC0,
    0x95, 0x00, 0x05, 0x90,
    0x2D, 0x30, 0x3D, 0x20,
    0x04, 0xCF, 0xC4, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0031[ 33] =   // Code 0031, DIGIT ONE
{
    0x14, 0xC0, 0x00,
    0xEE, 0xF0, 0x00,
    0x01, 0xF0, 0x00,
    0x00, 0xF0, 0x00,
    0x00, 0xF0, 0x00,
    0x00, 0xF0, 0x00,
    0x00, 0xF0, 0x00,
    0x00, 0xF0, 0x00,
    0x00, 0xF0, 0x00,
    0x03, 0xF4, 0x00,
    0xAF, 0xFF, 0xD0
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0032[ 44] =   // Code 0032, DIGIT TWO
{
    0x00, 0x6D, 0xFE, 0x91,
    0x09, 0xA2, 0x02, 0x9A,
    0x0F, 0x10, 0x00, 0x0F,
    0x0C, 0x60, 0x00, 0x2E,
    0x00, 0x00, 0x00, 0xB7,
    0x00, 0x00, 0x2C, 0x80,
    0x00, 0x04, 0xE6, 0x00,
    0x00, 0x5D, 0x30, 0x00,
    0x03, 0xD2, 0x00, 0x00,
    0x0D, 0x30, 0x00, 0x2D,
    0x5F, 0xFF, 0xFF, 0xFB
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0033[ 44] =   // Code 0033, DIGIT THREE
{
    0x02, 0xAF, 0xFA, 0x10,
    0x0C, 0x60, 0x19, 0xA0,
    0x0E, 0x10, 0x01, 0xF0,
    0x00, 0x00, 0x01, 0xE0,
    0x00, 0x00, 0x1A, 0x60,
    0x00, 0x6D, 0xF7, 0x00,
    0x00, 0x00, 0x2A, 0x80,
    0x00, 0x00, 0x01, 0xE0,
    0xD0, 0x00, 0x01, 0xE0,
    0xD7, 0x10, 0x3B, 0x80,
    0x2B, 0xFF, 0xC7, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0034[ 44] =   // Code 0034, DIGIT FOUR
{
    0x00, 0x00, 0x8E, 0x00,
    0x00, 0x08, 0xBF, 0x00,
    0x00, 0x6C, 0x1F, 0x00,
    0x02, 0xD2, 0x0F, 0x00,
    0x0B, 0x50, 0x0F, 0x00,
    0x4C, 0x00, 0x0F, 0x00,
    0xA5, 0x00, 0x0F, 0x00,
    0xEF, 0xFF, 0xFF, 0xFE,
    0x00, 0x00, 0x0F, 0x00,
    0x00, 0x00, 0x0F, 0x10,
    0x00, 0x00, 0xCF, 0xE0
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0035[ 44] =   // Code 0035, DIGIT FIVE
{
    0x0F, 0xFF, 0xD9, 0x00,
    0x0E, 0x00, 0x00, 0x00,
    0x0D, 0x00, 0x00, 0x00,
    0x0B, 0x00, 0x00, 0x00,
    0x0C, 0xBF, 0xE8, 0x00,
    0x0B, 0x50, 0x1A, 0x90,
    0x00, 0x00, 0x02, 0xE0,
    0x00, 0x00, 0x00, 0xF0,
    0xD0, 0x00, 0x04, 0xC0,
    0xC6, 0x00, 0x4E, 0x50,
    0x2B, 0xFF, 0xC5, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0036[ 44] =   // Code 0036, DIGIT SIX
{
    0x00, 0x06, 0xBF, 0x50,
    0x01, 0xCB, 0x41, 0x00,
    0x0C, 0x70, 0x00, 0x00,
    0x6A, 0x00, 0x00, 0x00,
    0xB6, 0xBF, 0xE9, 0x00,
    0xE9, 0x20, 0x2B, 0x80,
    0xF0, 0x00, 0x02, 0xE0,
    0xE1, 0x00, 0x00, 0xF0,
    0xB5, 0x00, 0x03, 0xD0,
    0x4E, 0x40, 0x2B, 0x60,
    0x05, 0xDF, 0xD6, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0037[ 44] =   // Code 0037, DIGIT SEVEN
{
    0xEF, 0xFF, 0xFF, 0xE0,
    0xE1, 0x00, 0x07, 0x80,
    0x30, 0x00, 0x0D, 0x20,
    0x00, 0x00, 0x5B, 0x00,
    0x00, 0x00, 0xC4, 0x00,
    0x00, 0x04, 0xD0, 0x00,
    0x00, 0x0B, 0x80, 0x00,
    0x00, 0x2F, 0x30, 0x00,
    0x00, 0x9C, 0x00, 0x00,
    0x00, 0xE8, 0x00, 0x00,
    0x03, 0xF3, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0038[ 44] =   // Code 0038, DIGIT EIGHT
{
    0x19, 0xDF, 0xEB, 0x20,
    0xB8, 0x20, 0x18, 0xD0,
    0xF1, 0x00, 0x01, 0xE0,
    0x9C, 0x51, 0x3A, 0x30,
    0x07, 0xFF, 0xF5, 0x00,
    0x1B, 0x43, 0xAF, 0x50,
    0xA6, 0x00, 0x07, 0xD0,
    0xF0, 0x00, 0x00, 0xF0,
    0xE2, 0x00, 0x02, 0xD0,
    0x9B, 0x20, 0x3C, 0x60,
    0x08, 0xEF, 0xC6, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0039[ 44] =   // Code 0039, DIGIT NINE
{
    0x06, 0xDF, 0xD5, 0x00,
    0x6B, 0x20, 0x4E, 0x40,
    0xD3, 0x00, 0x05, 0xB0,
    0xF0, 0x00, 0x01, 0xE0,
    0xE2, 0x00, 0x00, 0xF0,
    0x8B, 0x20, 0x29, 0xE0,
    0x09, 0xEF, 0xB6, 0xB0,
    0x00, 0x00, 0x09, 0x60,
    0x00, 0x00, 0x7B, 0x00,
    0x01, 0x4B, 0xB1, 0x00,
    0x5F, 0xB6, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_003A[  7] =   // Code 003A, COLON
{
    0xCC,
    0xCC,
    0x00,
    0x00,
    0x00,
    0xCC,
    0xCC
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_003B[  9] =   // Code 003B, SEMICOLON
{
    0xCC,
    0xCC,
    0x00,
    0x00,
    0x00,
    0xCB,
    0xDF,
    0x05,
    0x42
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_003C[ 40] =   // Code 003C, LESS-THAN SIGN
{
    0x00, 0x00, 0x00, 0x16, 0xC0,
    0x00, 0x00, 0x39, 0xD8, 0x20,
    0x01, 0x6C, 0xB5, 0x00, 0x00,
    0x9D, 0x82, 0x00, 0x00, 0x00,
    0x9D, 0x82, 0x00, 0x00, 0x00,
    0x01, 0x6C, 0xB5, 0x00, 0x00,
    0x00, 0x00, 0x39, 0xD9, 0x30,
    0x00, 0x00, 0x00, 0x16, 0xC0
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_003D[ 20] =   // Code 003D, EQUALS SIGN
{
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
    0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00,
    0xFF, 0xFF, 0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_003E[ 40] =   // Code 003E, GREATER-THAN SIGN
{
    0xC6, 0x10, 0x00, 0x00, 0x00,
    0x28, 0xD9, 0x30, 0x00, 0x00,
    0x00, 0x05, 0xBC, 0x61, 0x00,
    0x00, 0x00, 0x02, 0x8D, 0x90,
    0x00, 0x00, 0x02, 0x8D, 0x90,
    0x00, 0x05, 0xBC, 0x61, 0x00,
    0x39, 0xD9, 0x30, 0x00, 0x00,
    0xC6, 0x10, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_003F[ 33] =   // Code 003F, QUESTION MARK
{
    0x2A, 0xFF, 0xA1,
    0xCE, 0x21, 0x9B,
    0xDD, 0x00, 0x1F,
    0x00, 0x00, 0x1E,
    0x00, 0x00, 0x78,
    0x00, 0x4A, 0x90,
    0x00, 0xF2, 0x00,
    0x00, 0xE0, 0x00,
    0x00, 0x00, 0x00,
    0x00, 0xCC, 0x00,
    0x00, 0xCC, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0040[ 91] =   // Code 0040, COMMERCIAL AT
{
    0x00, 0x01, 0x8C, 0xFF, 0xEA, 0x40, 0x00,
    0x00, 0x5D, 0x83, 0x00, 0x27, 0xE8, 0x00,
    0x05, 0xC2, 0x00, 0x00, 0x00, 0x2D, 0x50,
    0x2D, 0x20, 0x2B, 0xF8, 0x55, 0x05, 0xB0,
    0x88, 0x01, 0xE7, 0x07, 0xC4, 0x01, 0xF0,
    0xD3, 0x09, 0xB0, 0x03, 0xE0, 0x00, 0xF0,
    0xF0, 0x0E, 0x40, 0x06, 0xB0, 0x03, 0xC0,
    0xF0, 0x0F, 0x00, 0x0D, 0x60, 0x0B, 0x70,
    0xC3, 0x0C, 0x41, 0x9B, 0x41, 0xAC, 0x00,
    0x7A, 0x03, 0xEE, 0x33, 0xDE, 0x91, 0x00,
    0x0C, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x01, 0xCB, 0x51, 0x00, 0x26, 0x50, 0x00,
    0x00, 0x06, 0xBE, 0xFE, 0xA4, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0041[ 55] =   // Code 0041, LATIN CAPITAL LETTER A
{
    0x00, 0x00, 0x87, 0x00, 0x00,
    0x00, 0x02, 0xEF, 0x10, 0x00,
    0x00, 0x09, 0x4C, 0x80, 0x00,
    0x00, 0x1B, 0x05, 0xF1, 0x00,
    0x00, 0x75, 0x00, 0xD7, 0x00,
    0x00, 0xC0, 0x00, 0x7D, 0x00,
    0x04, 0xFF, 0xFF, 0xFF, 0x30,
    0x0A, 0x40, 0x00, 0x0B, 0x80,
    0x1E, 0x00, 0x00, 0x07, 0xD0,
    0x5C, 0x00, 0x00, 0x03, 0xF3,
    0xDF, 0x50, 0x00, 0x0B, 0xFC
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0042[ 55] =   // Code 0042, LATIN CAPITAL LETTER B
{
    0xBF, 0xFF, 0xFF, 0xC3, 0x00,
    0x0F, 0x20, 0x02, 0x8D, 0x00,
    0x0F, 0x00, 0x00, 0x0F, 0x00,
    0x0F, 0x00, 0x00, 0x79, 0x00,
    0x0F, 0x14, 0x7D, 0x90, 0x00,
    0x0F, 0xDA, 0x66, 0xBB, 0x10,
    0x0F, 0x00, 0x00, 0x07, 0xA0,
    0x0F, 0x00, 0x00, 0x00, 0xF0,
    0x0F, 0x00, 0x00, 0x02, 0xE0,
    0x0F, 0x30, 0x01, 0x5D, 0x80,
    0xCF, 0xFF, 0xFF, 0xD8, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0043[ 55] =   // Code 0043, LATIN CAPITAL LETTER C
{
    0x00, 0x3A, 0xEF, 0xEB, 0x40,
    0x07, 0xC4, 0x00, 0x4C, 0xE0,
    0x3D, 0x10, 0x00, 0x01, 0xC0,
    0xA6, 0x00, 0x00, 0x00, 0x00,
    0xE1, 0x00, 0x00, 0x00, 0x00,
    0xF0, 0x00, 0x00, 0x00, 0x00,
    0xE1, 0x00, 0x00, 0x00, 0x00,
    0xB5, 0x00, 0x00, 0x00, 0x00,
    0x5C, 0x10, 0x00, 0x00, 0x85,
    0x09, 0xC4, 0x00, 0x3A, 0xC1,
    0x00, 0x6C, 0xFF, 0xC7, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0044[ 55] =   // Code 0044, LATIN CAPITAL LETTER D
{
    0xCF, 0xFF, 0xFD, 0x93, 0x00,
    0x1F, 0x30, 0x03, 0x7E, 0x60,
    0x0F, 0x00, 0x00, 0x02, 0xD3,
    0x0F, 0x00, 0x00, 0x00, 0x6A,
    0x0F, 0x00, 0x00, 0x00, 0x1E,
    0x0F, 0x00, 0x00, 0x00, 0x0F,
    0x0F, 0x00, 0x00, 0x00, 0x1E,
    0x0F, 0x00, 0x00, 0x00, 0x6A,
    0x0F, 0x00, 0x00, 0x02, 0xE3,
    0x1F, 0x40, 0x03, 0x8E, 0x60,
    0xCF, 0xFF, 0xFD, 0x93, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0045[ 55] =   // Code 0045, LATIN CAPITAL LETTER E
{
    0xBF, 0xFF, 0xFF, 0xFF, 0x40,
    0x0F, 0x20, 0x00, 0x39, 0x50,
    0x0F, 0x00, 0x00, 0x00, 0x00,
    0x0F, 0x00, 0x00, 0x00, 0x00,
    0x0F, 0x00, 0x01, 0xB0, 0x00,
    0x0F, 0xFF, 0xFF, 0xF0, 0x00,
    0x0F, 0x00, 0x01, 0xB0, 0x00,
    0x0F, 0x00, 0x00, 0x00, 0x00,
    0x0F, 0x00, 0x00, 0x00, 0x00,
    0x0F, 0x20, 0x00, 0x16, 0xD0,
    0xBF, 0xFF, 0xFF, 0xFF, 0xB0
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0046[ 44] =   // Code 0046, LATIN CAPITAL LETTER F
{
    0xBF, 0xFF, 0xFF, 0xFC,
    0x0F, 0x20, 0x02, 0x5D,
    0x0F, 0x00, 0x00, 0x00,
    0x0F, 0x00, 0x00, 0x00,
    0x0F, 0x00, 0x01, 0xA0,
    0x0F, 0xFF, 0xFF, 0xF0,
    0x0F, 0x00, 0x02, 0xA0,
    0x0F, 0x00, 0x00, 0x00,
    0x0F, 0x00, 0x00, 0x00,
    0x0F, 0x00, 0x00, 0x00,
    0xCF, 0xB0, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0047[ 66] =   // Code 0047, LATIN CAPITAL LETTER G
{
    0x00, 0x28, 0xDF, 0xFC, 0x81, 0x00,
    0x03, 0xE7, 0x20, 0x14, 0xC8, 0x00,
    0x2E, 0x30, 0x00, 0x00, 0x19, 0x00,
    0x98, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xD2, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xF0, 0x00, 0x00, 0x7F, 0xFE, 0x00,
    0xE1, 0x00, 0x00, 0x00, 0x3F, 0x00,
    0xB6, 0x00, 0x00, 0x00, 0x0F, 0x00,
    0x4E, 0x20, 0x00, 0x00, 0x1F, 0x10,
    0x07, 0xE7, 0x30, 0x03, 0xBC, 0x10,
    0x00, 0x4B, 0xEF, 0xEB, 0x60, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0048[ 66] =   // Code 0048, LATIN CAPITAL LETTER H
{
    0xCF, 0xC0, 0x00, 0x00, 0xCF, 0xC0,
    0x1F, 0x10, 0x00, 0x00, 0x0F, 0x10,
    0x0F, 0x00, 0x00, 0x00, 0x0F, 0x00,
    0x0F, 0x00, 0x00, 0x00, 0x0F, 0x00,
    0x0F, 0x00, 0x00, 0x00, 0x0F, 0x00,
    0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
    0x0F, 0x00, 0x00, 0x00, 0x0F, 0x00,
    0x0F, 0x00, 0x00, 0x00, 0x0F, 0x00,
    0x0F, 0x00, 0x00, 0x00, 0x0F, 0x00,
    0x1F, 0x00, 0x00, 0x00, 0x1F, 0x00,
    0xCF, 0xB0, 0x00, 0x00, 0xCF, 0xB0
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0049[ 22] =   // Code 0049, LATIN CAPITAL LETTER I
{
    0xBF, 0xC0,
    0x0F, 0x10,
    0x0F, 0x00,
    0x0F, 0x00,
    0x0F, 0x00,
    0x0F, 0x00,
    0x0F, 0x00,
    0x0F, 0x00,
    0x0F, 0x00,
    0x1F, 0x00,
    0xCF, 0xB0
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_004A[ 44] =   // Code 004A, LATIN CAPITAL LETTER J
{
    0x00, 0x00, 0xEF, 0xC0,
    0x00, 0x00, 0x2F, 0x00,
    0x00, 0x00, 0x0F, 0x00,
    0x00, 0x00, 0x0F, 0x00,
    0x00, 0x00, 0x0F, 0x00,
    0x00, 0x00, 0x0F, 0x00,
    0x00, 0x00, 0x0F, 0x00,
    0x6E, 0x90, 0x0F, 0x00,
    0xF3, 0x00, 0x0F, 0x00,
    0xD6, 0x01, 0x8B, 0x00,
    0x3B, 0xFF, 0xB1, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_004B[ 55] =   // Code 004B, LATIN CAPITAL LETTER K
{
    0xBF, 0xC0, 0x05, 0xFF, 0x40,
    0x0F, 0x10, 0x01, 0xE4, 0x00,
    0x0F, 0x00, 0x0B, 0x70, 0x00,
    0x0F, 0x00, 0xA9, 0x00, 0x00,
    0x0F, 0x09, 0xE1, 0x00, 0x00,
    0x0F, 0xAA, 0xDB, 0x00, 0x00,
    0x0F, 0x80, 0x2E, 0x60, 0x00,
    0x0F, 0x00, 0x06, 0xE1, 0x00,
    0x0F, 0x00, 0x00, 0xC9, 0x00,
    0x1F, 0x00, 0x00, 0x5F, 0x20,
    0xCF, 0xB0, 0x00, 0xAF, 0xC0
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_004C[ 44] =   // Code 004C, LATIN CAPITAL LETTER L
{
    0xBF, 0xC0, 0x00, 0x00,
    0x0F, 0x10, 0x00, 0x00,
    0x0F, 0x00, 0x00, 0x00,
    0x0F, 0x00, 0x00, 0x00,
    0x0F, 0x00, 0x00, 0x00,
    0x0F, 0x00, 0x00, 0x00,
    0x0F, 0x00, 0x00, 0x00,
    0x0F, 0x00, 0x00, 0x00,
    0x0F, 0x00, 0x00, 0x00,
    0x0F, 0x20, 0x01, 0x5D,
    0xBF, 0xFF, 0xFF, 0xFC
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_004D[ 66] =   // Code 004D, LATIN CAPITAL LETTER M
{
    0xAF, 0xE1, 0x00, 0x00, 0x09, 0xFC,
    0x0C, 0xF7, 0x00, 0x00, 0x1F, 0xE0,
    0x0C, 0xAD, 0x00, 0x00, 0x7C, 0xD0,
    0x0D, 0x4F, 0x50, 0x00, 0xD6, 0xF0,
    0x0D, 0x2A, 0xB0, 0x06, 0xC2, 0xF0,
    0x0D, 0x23, 0xF3, 0x0D, 0x50, 0xF0,
    0x0E, 0x00, 0xBA, 0x6C, 0x00, 0xF0,
    0x0F, 0x00, 0x4F, 0xE5, 0x00, 0xF0,
    0x0F, 0x00, 0x0B, 0xC0, 0x00, 0xF0,
    0x1F, 0x00, 0x02, 0x20, 0x00, 0xF1,
    0xCF, 0xC0, 0x00, 0x00, 0x0B, 0xFB
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_004E[ 60] =   // Code 004E, LATIN CAPITAL LETTER N
{
    0xEF, 0xB0, 0x00, 0x0B, 0xFB,
    0x1F, 0xF8, 0x00, 0x00, 0xF0,
    0x0F, 0x5F, 0x40, 0x00, 0xF0,
    0x0F, 0x08, 0xE2, 0x00, 0xF0,
    0x0F, 0x00, 0xCB, 0x00, 0xF0,
    0x0F, 0x00, 0x2E, 0x60, 0xF0,
    0x0F, 0x00, 0x06, 0xE2, 0xF0,
    0x0F, 0x00, 0x00, 0xBA, 0xF0,
    0x0F, 0x00, 0x00, 0x2F, 0xF0,
    0x1F, 0x10, 0x00, 0x07, 0xF0,
    0xCF, 0xD0, 0x00, 0x00, 0xC0,
    0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_004F[ 55] =   // Code 004F, LATIN CAPITAL LETTER O
{
    0x00, 0x5B, 0xFF, 0xB5, 0x00,
    0x08, 0xC3, 0x00, 0x3C, 0x80,
    0x4C, 0x10, 0x00, 0x01, 0xC4,
    0xB5, 0x00, 0x00, 0x00, 0x5B,
    0xE1, 0x00, 0x00, 0x00, 0x1E,
    0xF0, 0x00, 0x00, 0x00, 0x0F,
    0xE1, 0x00, 0x00, 0x00, 0x1E,
    0xB5, 0x00, 0x00, 0x00, 0x5B,
    0x4C, 0x10, 0x00, 0x01, 0xC4,
    0x08, 0xC3, 0x00, 0x3C, 0x80,
    0x00, 0x5B, 0xFF, 0xB5, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0050[ 55] =   // Code 0050, LATIN CAPITAL LETTER P
{
    0xCF, 0xFF, 0xFE, 0xB6, 0x00,
    0x1F, 0x50, 0x02, 0x5D, 0x80,
    0x0F, 0x00, 0x00, 0x02, 0xE0,
    0x0F, 0x00, 0x00, 0x01, 0xE0,
    0x0F, 0x00, 0x00, 0x09, 0x90,
    0x0F, 0x01, 0x37, 0xCB, 0x10,
    0x0F, 0xFE, 0xC9, 0x30, 0x00,
    0x0F, 0x00, 0x00, 0x00, 0x00,
    0x0F, 0x00, 0x00, 0x00, 0x00,
    0x0F, 0x10, 0x00, 0x00, 0x00,
    0xBF, 0xE0, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0051[ 65] =   // Code 0051, LATIN CAPITAL LETTER Q
{
    0x00, 0x5B, 0xFF, 0xB5, 0x00,
    0x08, 0xC3, 0x00, 0x3C, 0x80,
    0x4C, 0x10, 0x00, 0x01, 0xC4,
    0xB5, 0x00, 0x00, 0x00, 0x5B,
    0xE1, 0x00, 0x00, 0x00, 0x1E,
    0xF0, 0x00, 0x00, 0x00, 0x0F,
    0xE1, 0x00, 0x00, 0x00, 0x1E,
    0xB5, 0x00, 0x00, 0x00, 0x5B,
    0x4C, 0x10, 0x38, 0x01, 0xC4,
    0x08, 0xC3, 0x1C, 0x4C, 0x80,
    0x00, 0x5B, 0xFF, 0xE5, 0x00,
    0x00, 0x00, 0x01, 0xC6, 0x00,
    0x00, 0x00, 0x00, 0x19, 0xFC
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0052[ 55] =   // Code 0052, LATIN CAPITAL LETTER R
{
    0xBF, 0xFF, 0xFF, 0xDA, 0x20,
    0x0F, 0x20, 0x01, 0x3A, 0xD0,
    0x0F, 0x00, 0x00, 0x00, 0xF0,
    0x0F, 0x00, 0x00, 0x07, 0xB0,
    0x0F, 0x02, 0x47, 0xCB, 0x10,
    0x0F, 0xEC, 0xAE, 0xE1, 0x00,
    0x0F, 0x00, 0x03, 0xE9, 0x00,
    0x0F, 0x00, 0x00, 0x5F, 0x20,
    0x0F, 0x00, 0x00, 0x0B, 0x90,
    0x1F, 0x20, 0x00, 0x04, 0xE1,
    0xCF, 0xE0, 0x00, 0x2D, 0xFC
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0053[ 55] =   // Code 0053, LATIN CAPITAL LETTER S
{
    0x00, 0x5B, 0xFF, 0xDA, 0x30,
    0x07, 0xA2, 0x03, 0xAF, 0xE0,
    0x0E, 0x10, 0x00, 0x05, 0xE0,
    0x0F, 0x20, 0x00, 0x00, 0x00,
    0x0A, 0xD7, 0x30, 0x00, 0x00,
    0x01, 0x8D, 0xFF, 0xC7, 0x00,
    0x00, 0x00, 0x24, 0x8E, 0xA0,
    0x00, 0x00, 0x00, 0x02, 0xF0,
    0xE5, 0x00, 0x00, 0x02, 0xD0,
    0x6F, 0x82, 0x01, 0x4C, 0x60,
    0x04, 0xBE, 0xFE, 0xB4, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0054[ 55] =   // Code 0054, LATIN CAPITAL LETTER T
{
    0xCF, 0xFF, 0xFF, 0xFF, 0xC0,
    0xF7, 0x11, 0xF1, 0x17, 0xF0,
    0x20, 0x00, 0xF0, 0x00, 0x20,
    0x00, 0x00, 0xF0, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0x00, 0x00,
    0x00, 0x0D, 0xFB, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0055[ 66] =   // Code 0055, LATIN CAPITAL LETTER U
{
    0xCF, 0xD0, 0x00, 0x00, 0xCF, 0xA0,
    0x0D, 0x40, 0x00, 0x00, 0x3C, 0x00,
    0x0D, 0x20, 0x00, 0x00, 0x2D, 0x00,
    0x0E, 0x10, 0x00, 0x00, 0x0E, 0x00,
    0x0F, 0x00, 0x00, 0x00, 0x0F, 0x00,
    0x0F, 0x00, 0x00, 0x00, 0x0F, 0x00,
    0x0F, 0x00, 0x00, 0x00, 0x0F, 0x00,
    0x0E, 0x20, 0x00, 0x00, 0x2D, 0x00,
    0x0A, 0x70, 0x00, 0x00, 0x7A, 0x00,
    0x03, 0xF7, 0x10, 0x27, 0xE2, 0x00,
    0x00, 0x3B, 0xEF, 0xEA, 0x20, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0056[ 55] =   // Code 0056, LATIN CAPITAL LETTER V
{
    0xDF, 0xC0, 0x00, 0x07, 0xFD,
    0x6F, 0x30, 0x00, 0x00, 0xD5,
    0x2F, 0x30, 0x00, 0x01, 0xF1,
    0x0C, 0x70, 0x00, 0x05, 0xB0,
    0x08, 0xC0, 0x00, 0x0A, 0x60,
    0x02, 0xF2, 0x00, 0x1E, 0x10,
    0x00, 0xB8, 0x00, 0x6A, 0x00,
    0x00, 0x5F, 0x10, 0xD3, 0x00,
    0x00, 0x0D, 0x96, 0xB0, 0x00,
    0x00, 0x05, 0xFE, 0x30, 0x00,
    0x00, 0x00, 0xA8, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0057[ 77] =   // Code 0057, LATIN CAPITAL LETTER W
{
    0xCF, 0xB0, 0x02, 0xEF, 0x70, 0x07, 0xFC,
    0x5F, 0x10, 0x00, 0x7C, 0x00, 0x00, 0xB4,
    0x1F, 0x30, 0x00, 0xAC, 0x00, 0x00, 0xC1,
    0x0D, 0x60, 0x00, 0xDF, 0x10, 0x01, 0xC0,
    0x0A, 0x90, 0x03, 0xCE, 0x50, 0x04, 0x90,
    0x06, 0xE0, 0x07, 0x7A, 0xB0, 0x08, 0x50,
    0x02, 0xF3, 0x0D, 0x24, 0xF1, 0x0D, 0x10,
    0x00, 0xD8, 0x4C, 0x00, 0xD8, 0x3B, 0x00,
    0x00, 0x8D, 0xB6, 0x00, 0x7E, 0xA7, 0x00,
    0x00, 0x3F, 0xE1, 0x00, 0x1F, 0xF1, 0x00,
    0x00, 0x0B, 0x60, 0x00, 0x07, 0x90, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0058[ 55] =   // Code 0058, LATIN CAPITAL LETTER X
{
    0xBF, 0xD1, 0x00, 0x6F, 0xF3,
    0x1D, 0xA0, 0x00, 0x0E, 0x60,
    0x04, 0xF4, 0x00, 0x79, 0x00,
    0x00, 0x9E, 0x14, 0xC1, 0x00,
    0x00, 0x0C, 0xCC, 0x20, 0x00,
    0x00, 0x03, 0xFB, 0x00, 0x00,
    0x00, 0x0B, 0x6D, 0x90, 0x00,
    0x00, 0x79, 0x02, 0xE6, 0x00,
    0x02, 0xD1, 0x00, 0x3E, 0x20,
    0x0C, 0x70, 0x00, 0x0B, 0xC0,
    0xBF, 0xB0, 0x00, 0x1F, 0xFB
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0059[ 55] =   // Code 0059, LATIN CAPITAL LETTER Y
{
    0xDF, 0xE3, 0x00, 0x05, 0xFC,
    0x1D, 0xD0, 0x00, 0x00, 0xC2,
    0x04, 0xF6, 0x00, 0x02, 0x80,
    0x00, 0x8E, 0x20, 0x09, 0x10,
    0x00, 0x0B, 0xB0, 0x64, 0x00,
    0x00, 0x01, 0xD9, 0xA0, 0x00,
    0x00, 0x00, 0x3F, 0x10, 0x00,
    0x00, 0x00, 0x0F, 0x00, 0x00,
    0x00, 0x00, 0x0F, 0x00, 0x00,
    0x00, 0x00, 0x1F, 0x00, 0x00,
    0x00, 0x00, 0xCF, 0xB0, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_005A[ 44] =   // Code 005A, LATIN CAPITAL LETTER Z
{
    0x3F, 0xFF, 0xFF, 0xFB,
    0x6B, 0x30, 0x00, 0xD7,
    0x10, 0x00, 0x08, 0xD1,
    0x00, 0x00, 0x4F, 0x40,
    0x00, 0x02, 0xE8, 0x00,
    0x00, 0x0C, 0xB0, 0x00,
    0x00, 0x9D, 0x10, 0x00,
    0x06, 0xF3, 0x00, 0x00,
    0x2E, 0x70, 0x00, 0x02,
    0xAD, 0x00, 0x02, 0x7E,
    0xEF, 0xFF, 0xFF, 0xFC
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_005B[ 26] =   // Code 005B, LEFT SQUARE BRACKET
{
    0xFF, 0xF0,
    0xF0, 0x00,
    0xF0, 0x00,
    0xF0, 0x00,
    0xF0, 0x00,
    0xF0, 0x00,
    0xF0, 0x00,
    0xF0, 0x00,
    0xF0, 0x00,
    0xF0, 0x00,
    0xF0, 0x00,
    0xF0, 0x00,
    0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_005C[ 24] =   // Code 005C, REVERSE SOLIDUS
{
    0x90, 0x00,
    0x90, 0x00,
    0x63, 0x00,
    0x18, 0x00,
    0x09, 0x00,
    0x07, 0x20,
    0x03, 0x60,
    0x00, 0xA0,
    0x00, 0x91,
    0x00, 0x55,
    0x00, 0x19,
    0x00, 0x09
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_005D[ 26] =   // Code 005D, RIGHT SQUARE BRACKET
{
    0xFF, 0xF0,
    0x00, 0xF0,
    0x00, 0xF0,
    0x00, 0xF0,
    0x00, 0xF0,
    0x00, 0xF0,
    0x00, 0xF0,
    0x00, 0xF0,
    0x00, 0xF0,
    0x00, 0xF0,
    0x00, 0xF0,
    0x00, 0xF0,
    0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_005E[ 20] =   // Code 005E, CIRCUMFLEX ACCENT
{
    0x00, 0x0A, 0xFA, 0x00, 0x00,
    0x00, 0x8B, 0x1B, 0x80, 0x00,
    0x08, 0x80, 0x00, 0x88, 0x00,
    0x85, 0x00, 0x00, 0x05, 0x80
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_005F[  4] =   // Code 005F, LOW LINE
{
    0xFF, 0xFF, 0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0060[  6] =   // Code 0060, GRAVE ACCENT
{
    0xD2, 0x00,
    0x5C, 0x10,
    0x03, 0x70
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0061[ 28] =   // Code 0061, LATIN SMALL LETTER A
{
    0xBE, 0xFE, 0x80, 0x00,
    0x00, 0x03, 0xD7, 0x00,
    0x00, 0x00, 0x4C, 0x00,
    0x18, 0xCF, 0xFF, 0x00,
    0xC8, 0x31, 0x0F, 0x00,
    0xF3, 0x01, 0x7F, 0x00,
    0x6E, 0xFC, 0x4B, 0x90
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0062[ 44] =   // Code 0062, LATIN SMALL LETTER B
{
    0x8E, 0x00, 0x00, 0x00,
    0x0F, 0x00, 0x00, 0x00,
    0x0F, 0x00, 0x00, 0x00,
    0x0F, 0x00, 0x00, 0x00,
    0x0F, 0x4C, 0xFE, 0x80,
    0x0F, 0x92, 0x03, 0xB8,
    0x0F, 0x00, 0x00, 0x2E,
    0x0F, 0x00, 0x00, 0x0F,
    0x0F, 0x10, 0x00, 0x3C,
    0x0B, 0xA1, 0x03, 0xD5,
    0x02, 0xBF, 0xFC, 0x50
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0063[ 28] =   // Code 0063, LATIN SMALL LETTER C
{
    0x05, 0xCF, 0xD6, 0x00,
    0x5C, 0x20, 0x8D, 0x00,
    0xC3, 0x00, 0x00, 0x00,
    0xF0, 0x00, 0x00, 0x00,
    0xE2, 0x00, 0x00, 0x00,
    0x8B, 0x20, 0x3C, 0x20,
    0x08, 0xEF, 0xC4, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0064[ 44] =   // Code 0064, LATIN SMALL LETTER D
{
    0x00, 0x00, 0x09, 0xE0,
    0x00, 0x00, 0x01, 0xF0,
    0x00, 0x00, 0x00, 0xF0,
    0x00, 0x00, 0x00, 0xF0,
    0x05, 0xCF, 0xE8, 0xF0,
    0x5D, 0x40, 0x16, 0xF0,
    0xC3, 0x00, 0x00, 0xF0,
    0xF0, 0x00, 0x00, 0xF0,
    0xE2, 0x00, 0x00, 0xF0,
    0x7C, 0x30, 0x15, 0xF0,
    0x07, 0xDF, 0xD7, 0xBB
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0065[ 28] =   // Code 0065, LATIN SMALL LETTER E
{
    0x04, 0xCF, 0xD5, 0x00,
    0x4E, 0x30, 0x4E, 0x00,
    0xC4, 0x00, 0x2E, 0x00,
    0xF1, 0x37, 0xD6, 0x00,
    0xEE, 0xC8, 0x30, 0x00,
    0x88, 0x10, 0x4B, 0x00,
    0x08, 0xEF, 0xB3, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0066[ 33] =   // Code 0066, LATIN SMALL LETTER F
{
    0x00, 0x3E, 0xC0,
    0x00, 0xB6, 0xD0,
    0x00, 0xE1, 0x00,
    0x00, 0xF0, 0x00,
    0x2F, 0xFF, 0x00,
    0x00, 0xF0, 0x00,
    0x00, 0xF0, 0x00,
    0x00, 0xF0, 0x00,
    0x00, 0xF0, 0x00,
    0x00, 0xF0, 0x00,
    0x0D, 0xFB, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0067[ 40] =   // Code 0067, LATIN SMALL LETTER G
{
    0x09, 0xFF, 0xFF, 0x20,
    0x8A, 0x11, 0xA6, 0x00,
    0xE2, 0x00, 0x2D, 0x00,
    0xF0, 0x00, 0x0F, 0x00,
    0xD2, 0x00, 0x2D, 0x00,
    0x8A, 0x11, 0xA7, 0x00,
    0x09, 0xEE, 0xE6, 0x00,
    0x00, 0x00, 0x2E, 0x00,
    0xC2, 0x01, 0x6D, 0x00,
    0x8E, 0xFE, 0xB2, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0068[ 44] =   // Code 0068, LATIN SMALL LETTER H
{
    0x5E, 0x00, 0x00, 0x00,
    0x0F, 0x00, 0x00, 0x00,
    0x0F, 0x00, 0x00, 0x00,
    0x0F, 0x00, 0x00, 0x00,
    0x0F, 0x5D, 0xFC, 0x30,
    0x0F, 0x81, 0x08, 0xB0,
    0x0F, 0x00, 0x01, 0xF0,
    0x0F, 0x00, 0x00, 0xF0,
    0x0F, 0x00, 0x00, 0xF0,
    0x0F, 0x00, 0x00, 0xF0,
    0xAF, 0xC0, 0x0A, 0xFC
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0069[ 20] =   // Code 0069, LATIN SMALL LETTER I
{
    0x0C, 0x00,
    0x0C, 0x00,
    0x00, 0x00,
    0x8E, 0x00,
    0x1F, 0x00,
    0x0F, 0x00,
    0x0F, 0x00,
    0x0F, 0x00,
    0x0F, 0x00,
    0xBF, 0xC0
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_006A[ 26] =   // Code 006A, LATIN SMALL LETTER J
{
    0x00, 0xC0,
    0x00, 0xC0,
    0x00, 0x00,
    0x09, 0xE0,
    0x00, 0xF0,
    0x00, 0xF0,
    0x00, 0xF0,
    0x00, 0xF0,
    0x00, 0xF0,
    0x00, 0xF0,
    0x00, 0xE0,
    0x04, 0xB0,
    0xDE, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_006B[ 44] =   // Code 006B, LATIN SMALL LETTER K
{
    0x8E, 0x00, 0x00, 0x00,
    0x0F, 0x00, 0x00, 0x00,
    0x0F, 0x00, 0x00, 0x00,
    0x0F, 0x00, 0x00, 0x00,
    0x0F, 0x00, 0x5F, 0xB0,
    0x0F, 0x00, 0x7B, 0x00,
    0x0F, 0x09, 0xB0, 0x00,
    0x0F, 0xCA, 0xE2, 0x00,
    0x0F, 0x20, 0x6B, 0x00,
    0x0F, 0x00, 0x0B, 0x40,
    0x9F, 0xC0, 0x0C, 0xD0
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_006C[ 22] =   // Code 006C, LATIN SMALL LETTER L
{
    0x9E, 0x00,
    0x1F, 0x00,
    0x0F, 0x00,
    0x0F, 0x00,
    0x0F, 0x00,
    0x0F, 0x00,
    0x0F, 0x00,
    0x0F, 0x00,
    0x0F, 0x00,
    0x0F, 0x00,
    0xBF, 0xC0
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_006D[ 42] =   // Code 006D, LATIN SMALL LETTER M
{
    0x9B, 0x9E, 0xE6, 0x8E, 0xE5, 0x00,
    0x0F, 0x60, 0x4F, 0x60, 0x4E, 0x00,
    0x0F, 0x00, 0x0F, 0x00, 0x0F, 0x00,
    0x0F, 0x00, 0x0F, 0x00, 0x0F, 0x00,
    0x0F, 0x00, 0x0F, 0x00, 0x0F, 0x00,
    0x0F, 0x00, 0x0F, 0x00, 0x0F, 0x00,
    0xBF, 0xC0, 0xBF, 0xC0, 0xBF, 0xC0
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_006E[ 28] =   // Code 006E, LATIN SMALL LETTER N
{
    0xAA, 0x7D, 0xFC, 0x30,
    0x1F, 0x71, 0x07, 0xC0,
    0x0F, 0x00, 0x00, 0xF0,
    0x0F, 0x00, 0x00, 0xF0,
    0x0F, 0x00, 0x00, 0xF0,
    0x0F, 0x00, 0x00, 0xF0,
    0xBF, 0xC0, 0x0B, 0xFC
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_006F[ 28] =   // Code 006F, LATIN SMALL LETTER O
{
    0x06, 0xDF, 0xD7, 0x00,
    0x6D, 0x30, 0x3D, 0x70,
    0xD3, 0x00, 0x03, 0xD0,
    0xF0, 0x00, 0x00, 0xF0,
    0xD3, 0x00, 0x03, 0xD0,
    0x7C, 0x30, 0x3C, 0x70,
    0x07, 0xDF, 0xD7, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0070[ 40] =   // Code 0070, LATIN SMALL LETTER P
{
    0xBB, 0x6D, 0xFD, 0x70,
    0x1F, 0x71, 0x03, 0xC7,
    0x0F, 0x00, 0x00, 0x2D,
    0x0F, 0x00, 0x00, 0x0F,
    0x0F, 0x00, 0x00, 0x3D,
    0x0F, 0x22, 0x03, 0xD6,
    0x0F, 0x6E, 0xFC, 0x60,
    0x0F, 0x00, 0x00, 0x00,
    0x1F, 0x10, 0x00, 0x00,
    0xDF, 0xC0, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0071[ 40] =   // Code 0071, LATIN SMALL LETTER Q
{
    0x05, 0xCF, 0xE7, 0xB0,
    0x5D, 0x30, 0x2A, 0xF0,
    0xC3, 0x00, 0x01, 0xF0,
    0xF0, 0x00, 0x00, 0xF0,
    0xE2, 0x00, 0x00, 0xF0,
    0x8B, 0x30, 0x29, 0xF0,
    0x08, 0xEF, 0xC5, 0xF0,
    0x00, 0x00, 0x00, 0xF0,
    0x00, 0x00, 0x00, 0xF0,
    0x00, 0x00, 0x0D, 0xFC
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0072[ 21] =   // Code 0072, LATIN SMALL LETTER R
{
    0xB8, 0x5D, 0xD0,
    0x2E, 0xA0, 0x00,
    0x0F, 0x20, 0x00,
    0x0F, 0x00, 0x00,
    0x0F, 0x00, 0x00,
    0x0F, 0x00, 0x00,
    0xCF, 0xB0, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0073[ 21] =   // Code 0073, LATIN SMALL LETTER S
{
    0x3C, 0xFE, 0x80,
    0xE4, 0x04, 0xD0,
    0xE6, 0x10, 0x00,
    0x4C, 0xFD, 0x50,
    0x00, 0x16, 0xE0,
    0xD4, 0x04, 0xD0,
    0x4C, 0xFC, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0074[ 20] =   // Code 0074, LATIN SMALL LETTER T
{
    0x09, 0x00,
    0x0B, 0x00,
    0x0E, 0x00,
    0xDF, 0xFE,
    0x0F, 0x00,
    0x0F, 0x00,
    0x0F, 0x00,
    0x0F, 0x00,
    0x0F, 0x10,
    0x0E, 0xEB
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0075[ 28] =   // Code 0075, LATIN SMALL LETTER U
{
    0xBE, 0x00, 0x0B, 0xE0,
    0x1F, 0x00, 0x01, 0xF0,
    0x0F, 0x00, 0x00, 0xF0,
    0x0F, 0x00, 0x00, 0xF0,
    0x0F, 0x10, 0x00, 0xF0,
    0x0B, 0x80, 0x18, 0xF2,
    0x03, 0xCF, 0xD5, 0xBB
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0076[ 28] =   // Code 0076, LATIN SMALL LETTER V
{
    0xCF, 0x30, 0x0F, 0xD0,
    0x4C, 0x00, 0x08, 0x60,
    0x1E, 0x10, 0x0A, 0x20,
    0x0A, 0x60, 0x1B, 0x00,
    0x03, 0xC0, 0x75, 0x00,
    0x00, 0xB8, 0xC0, 0x00,
    0x00, 0x2E, 0x30, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0077[ 42] =   // Code 0077, LATIN SMALL LETTER W
{
    0xCF, 0x40, 0x4F, 0x80, 0x0B, 0xD0,
    0x6B, 0x00, 0x0D, 0x40, 0x04, 0x80,
    0x3D, 0x00, 0x1F, 0x70, 0x07, 0x40,
    0x0D, 0x30, 0x6C, 0xD0, 0x0C, 0x10,
    0x08, 0x90, 0xC2, 0xE5, 0x59, 0x00,
    0x02, 0xFA, 0x70, 0x7D, 0xC2, 0x00,
    0x00, 0x7B, 0x00, 0x0C, 0x70, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0078[ 28] =   // Code 0078, LATIN SMALL LETTER X
{
    0xBF, 0x40, 0x7F, 0x30,
    0x0C, 0x60, 0x86, 0x00,
    0x02, 0xE7, 0xA0, 0x00,
    0x00, 0x7F, 0x30, 0x00,
    0x02, 0xB6, 0xE2, 0x00,
    0x0B, 0x20, 0x8C, 0x10,
    0xBF, 0x30, 0x6F, 0xC0
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0079[ 40] =   // Code 0079, LATIN SMALL LETTER Y
{
    0xCF, 0x40, 0x0C, 0xD0,
    0x6C, 0x00, 0x06, 0x80,
    0x4B, 0x00, 0x06, 0x60,
    0x2E, 0x00, 0x09, 0x30,
    0x0D, 0x40, 0x0C, 0x00,
    0x07, 0xC1, 0x68, 0x00,
    0x00, 0xBF, 0xE1, 0x00,
    0x00, 0x05, 0x70, 0x00,
    0x00, 0x5A, 0x00, 0x00,
    0x9E, 0x80, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_007A[ 21] =   // Code 007A, LATIN SMALL LETTER Z
{
    0x7F, 0xFF, 0xD0,
    0x82, 0x08, 0x80,
    0x00, 0x4C, 0x00,
    0x01, 0xD3, 0x00,
    0x0B, 0x60, 0x00,
    0x79, 0x02, 0xB0,
    0xEF, 0xFF, 0xC0
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_007B[ 39] =   // Code 007B, LEFT CURLY BRACKET
{
    0x00, 0x4C, 0xF0,
    0x00, 0xD6, 0x00,
    0x00, 0xF0, 0x00,
    0x00, 0xF0, 0x00,
    0x00, 0xE0, 0x00,
    0x17, 0xA0, 0x00,
    0xFB, 0x10, 0x00,
    0x17, 0xA0, 0x00,
    0x00, 0xE0, 0x00,
    0x00, 0xF0, 0x00,
    0x00, 0xF0, 0x00,
    0x00, 0xD6, 0x00,
    0x00, 0x4C, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_007C[ 15] =   // Code 007C, VERTICAL LINE
{
    0xF0,
    0xF0,
    0xF0,
    0xF0,
    0xF0,
    0xF0,
    0xF0,
    0xF0,
    0xF0,
    0xF0,
    0xF0,
    0xF0,
    0xF0,
    0xF0,
    0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_007D[ 39] =   // Code 007D, RIGHT CURLY BRACKET
{
    0xFC, 0x40, 0x00,
    0x06, 0xD0, 0x00,
    0x00, 0xF0, 0x00,
    0x00, 0xF0, 0x00,
    0x00, 0xE0, 0x00,
    0x00, 0xA7, 0x10,
    0x00, 0x1B, 0xF0,
    0x00, 0xA7, 0x10,
    0x00, 0xE0, 0x00,
    0x00, 0xF0, 0x00,
    0x00, 0xF0, 0x00,
    0x06, 0xD0, 0x00,
    0xFC, 0x40, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_007E[ 15] =   // Code 007E, TILDE
{
    0x00, 0x00, 0x00, 0x00, 0x00,
    0x4C, 0xFD, 0x83, 0x03, 0xC0,
    0xA3, 0x02, 0x7D, 0xFC, 0x40
};

GUI_CONST_STORAGE GUI_CHARINFO_EXT GUI_FontSouvenir18_CharInfo[95] =
{
    {   1,   1,   0,  14,   4, acGUI_FontSouvenir18_0020 } // Code 0020, SPACE
    , {   2,  11,   1,   3,   4, acGUI_FontSouvenir18_0021 } // Code 0021, EXCLAMATION MARK
    , {   3,   4,   1,   3,   5, acGUI_FontSouvenir18_0022 } // Code 0022, QUOTATION MARK
    , {  10,  11,   1,   3,  11, acGUI_FontSouvenir18_0023 } // Code 0023, NUMBER SIGN
    , {   7,  15,   0,   1,   8, acGUI_FontSouvenir18_0024 } // Code 0024, DOLLAR SIGN
    , {  11,  13,   1,   2,  13, acGUI_FontSouvenir18_0025 } // Code 0025, PERCENT SIGN
    , {  11,  11,   1,   3,  11, acGUI_FontSouvenir18_0026 } // Code 0026, AMPERSAND
    , {   1,   4,   1,   3,   3, acGUI_FontSouvenir18_0027 } // Code 0027, APOSTROPHE
    , {   3,  13,   1,   3,   5, acGUI_FontSouvenir18_0028 } // Code 0028, LEFT PARENTHESIS
    , {   3,  13,   1,   3,   5, acGUI_FontSouvenir18_0029 } // Code 0029, RIGHT PARENTHESIS
    , {   5,   6,   1,   3,   7, acGUI_FontSouvenir18_002A } // Code 002A, ASTERISK
    , {   9,   9,   2,   5,  12, acGUI_FontSouvenir18_002B } // Code 002B, PLUS SIGN
    , {   2,   4,   1,  12,   4, acGUI_FontSouvenir18_002C } // Code 002C, COMMA
    , {   4,   1,   1,  10,   5, acGUI_FontSouvenir18_002D } // Code 002D, HYPHEN-MINUS
    , {   2,   2,   1,  12,   4, acGUI_FontSouvenir18_002E } // Code 002E, FULL STOP
    , {   4,  12,   0,   3,   4, acGUI_FontSouvenir18_002F } // Code 002F, SOLIDUS
    , {   7,  11,   0,   3,   8, acGUI_FontSouvenir18_0030 } // Code 0030, DIGIT ZERO
    , {   5,  11,   2,   3,   8, acGUI_FontSouvenir18_0031 } // Code 0031, DIGIT ONE
    , {   8,  11,  -1,   3,   8, acGUI_FontSouvenir18_0032 } // Code 0032, DIGIT TWO
    , {   7,  11,   0,   3,   8, acGUI_FontSouvenir18_0033 } // Code 0033, DIGIT THREE
    , {   8,  11,   0,   3,   8, acGUI_FontSouvenir18_0034 } // Code 0034, DIGIT FOUR
    , {   7,  11,   0,   3,   8, acGUI_FontSouvenir18_0035 } // Code 0035, DIGIT FIVE
    , {   7,  11,   0,   3,   8, acGUI_FontSouvenir18_0036 } // Code 0036, DIGIT SIX
    , {   7,  11,   1,   3,   8, acGUI_FontSouvenir18_0037 } // Code 0037, DIGIT SEVEN
    , {   7,  11,   0,   3,   8, acGUI_FontSouvenir18_0038 } // Code 0038, DIGIT EIGHT
    , {   7,  11,   0,   3,   8, acGUI_FontSouvenir18_0039 } // Code 0039, DIGIT NINE
    , {   2,   7,   1,   7,   4, acGUI_FontSouvenir18_003A } // Code 003A, COLON
    , {   2,   9,   1,   7,   4, acGUI_FontSouvenir18_003B } // Code 003B, SEMICOLON
    , {   9,   8,   2,   5,  12, acGUI_FontSouvenir18_003C } // Code 003C, LESS-THAN SIGN
    , {   9,   4,   2,   7,  12, acGUI_FontSouvenir18_003D } // Code 003D, EQUALS SIGN
    , {   9,   8,   2,   5,  12, acGUI_FontSouvenir18_003E } // Code 003E, GREATER-THAN SIGN
    , {   6,  11,   1,   3,   7, acGUI_FontSouvenir18_003F } // Code 003F, QUESTION MARK
    , {  13,  13,   1,   3,  15, acGUI_FontSouvenir18_0040 } // Code 0040, COMMERCIAL AT
    , {  10,  11,   0,   3,  10, acGUI_FontSouvenir18_0041 } // Code 0041, LATIN CAPITAL LETTER A
    , {   9,  11,   0,   3,  10, acGUI_FontSouvenir18_0042 } // Code 0042, LATIN CAPITAL LETTER B
    , {  10,  11,   1,   3,  10, acGUI_FontSouvenir18_0043 } // Code 0043, LATIN CAPITAL LETTER C
    , {  10,  11,   0,   3,  11, acGUI_FontSouvenir18_0044 } // Code 0044, LATIN CAPITAL LETTER D
    , {   9,  11,   0,   3,   9, acGUI_FontSouvenir18_0045 } // Code 0045, LATIN CAPITAL LETTER E
    , {   8,  11,   0,   3,   8, acGUI_FontSouvenir18_0046 } // Code 0046, LATIN CAPITAL LETTER F
    , {  11,  11,   1,   3,  12, acGUI_FontSouvenir18_0047 } // Code 0047, LATIN CAPITAL LETTER G
    , {  11,  11,   0,   3,  12, acGUI_FontSouvenir18_0048 } // Code 0048, LATIN CAPITAL LETTER H
    , {   3,  11,   0,   3,   4, acGUI_FontSouvenir18_0049 } // Code 0049, LATIN CAPITAL LETTER I
    , {   7,  11,   0,   3,   7, acGUI_FontSouvenir18_004A } // Code 004A, LATIN CAPITAL LETTER J
    , {   9,  11,   0,   3,   9, acGUI_FontSouvenir18_004B } // Code 004B, LATIN CAPITAL LETTER K
    , {   8,  11,   0,   3,   9, acGUI_FontSouvenir18_004C } // Code 004C, LATIN CAPITAL LETTER L
    , {  12,  11,   0,   3,  12, acGUI_FontSouvenir18_004D } // Code 004D, LATIN CAPITAL LETTER M
    , {  10,  12,   0,   3,  11, acGUI_FontSouvenir18_004E } // Code 004E, LATIN CAPITAL LETTER N
    , {  10,  11,   1,   3,  11, acGUI_FontSouvenir18_004F } // Code 004F, LATIN CAPITAL LETTER O
    , {   9,  11,   0,   3,   9, acGUI_FontSouvenir18_0050 } // Code 0050, LATIN CAPITAL LETTER P
    , {  10,  13,   1,   3,  11, acGUI_FontSouvenir18_0051 } // Code 0051, LATIN CAPITAL LETTER Q
    , {  10,  11,   0,   3,  10, acGUI_FontSouvenir18_0052 } // Code 0052, LATIN CAPITAL LETTER R
    , {   9,  11,   0,   3,   9, acGUI_FontSouvenir18_0053 } // Code 0053, LATIN CAPITAL LETTER S
    , {   9,  11,   0,   3,   9, acGUI_FontSouvenir18_0054 } // Code 0054, LATIN CAPITAL LETTER T
    , {  11,  11,   0,   3,  11, acGUI_FontSouvenir18_0055 } // Code 0055, LATIN CAPITAL LETTER U
    , {  10,  11,   0,   3,  10, acGUI_FontSouvenir18_0056 } // Code 0056, LATIN CAPITAL LETTER V
    , {  14,  11,   0,   3,  14, acGUI_FontSouvenir18_0057 } // Code 0057, LATIN CAPITAL LETTER W
    , {  10,  11,   0,   3,  10, acGUI_FontSouvenir18_0058 } // Code 0058, LATIN CAPITAL LETTER X
    , {  10,  11,   0,   3,  10, acGUI_FontSouvenir18_0059 } // Code 0059, LATIN CAPITAL LETTER Y
    , {   8,  11,   0,   3,   8, acGUI_FontSouvenir18_005A } // Code 005A, LATIN CAPITAL LETTER Z
    , {   3,  13,   1,   3,   5, acGUI_FontSouvenir18_005B } // Code 005B, LEFT SQUARE BRACKET
    , {   4,  12,   0,   3,   4, acGUI_FontSouvenir18_005C } // Code 005C, REVERSE SOLIDUS
    , {   3,  13,   0,   3,   5, acGUI_FontSouvenir18_005D } // Code 005D, RIGHT SQUARE BRACKET
    , {   9,   4,   3,   3,  15, acGUI_FontSouvenir18_005E } // Code 005E, CIRCUMFLEX ACCENT
    , {   8,   1,   0,  17,   7, acGUI_FontSouvenir18_005F } // Code 005F, LOW LINE
    , {   3,   3,   2,   3,   7, acGUI_FontSouvenir18_0060 } // Code 0060, GRAVE ACCENT
    , {   7,   7,   0,   7,   8, acGUI_FontSouvenir18_0061 } // Code 0061, LATIN SMALL LETTER A
    , {   8,  11,   0,   3,   8, acGUI_FontSouvenir18_0062 } // Code 0062, LATIN SMALL LETTER B
    , {   7,   7,   0,   7,   7, acGUI_FontSouvenir18_0063 } // Code 0063, LATIN SMALL LETTER C
    , {   8,  11,   0,   3,   8, acGUI_FontSouvenir18_0064 } // Code 0064, LATIN SMALL LETTER D
    , {   7,   7,   0,   7,   7, acGUI_FontSouvenir18_0065 } // Code 0065, LATIN SMALL LETTER E
    , {   5,  11,  -1,   3,   4, acGUI_FontSouvenir18_0066 } // Code 0066, LATIN SMALL LETTER F
    , {   7,  10,   0,   7,   7, acGUI_FontSouvenir18_0067 } // Code 0067, LATIN SMALL LETTER G
    , {   8,  11,   0,   3,   8, acGUI_FontSouvenir18_0068 } // Code 0068, LATIN SMALL LETTER H
    , {   3,  10,   0,   4,   4, acGUI_FontSouvenir18_0069 } // Code 0069, LATIN SMALL LETTER I
    , {   3,  13,  -1,   4,   4, acGUI_FontSouvenir18_006A } // Code 006A, LATIN SMALL LETTER J
    , {   7,  11,   0,   3,   7, acGUI_FontSouvenir18_006B } // Code 006B, LATIN SMALL LETTER K
    , {   3,  11,   0,   3,   3, acGUI_FontSouvenir18_006C } // Code 006C, LATIN SMALL LETTER L
    , {  11,   7,   0,   7,  12, acGUI_FontSouvenir18_006D } // Code 006D, LATIN SMALL LETTER M
    , {   8,   7,   0,   7,   8, acGUI_FontSouvenir18_006E } // Code 006E, LATIN SMALL LETTER N
    , {   7,   7,   0,   7,   8, acGUI_FontSouvenir18_006F } // Code 006F, LATIN SMALL LETTER O
    , {   8,  10,   0,   7,   8, acGUI_FontSouvenir18_0070 } // Code 0070, LATIN SMALL LETTER P
    , {   8,  10,   0,   7,   8, acGUI_FontSouvenir18_0071 } // Code 0071, LATIN SMALL LETTER Q
    , {   5,   7,   0,   7,   5, acGUI_FontSouvenir18_0072 } // Code 0072, LATIN SMALL LETTER R
    , {   5,   7,   0,   7,   6, acGUI_FontSouvenir18_0073 } // Code 0073, LATIN SMALL LETTER S
    , {   4,  10,   0,   4,   4, acGUI_FontSouvenir18_0074 } // Code 0074, LATIN SMALL LETTER T
    , {   8,   7,   0,   7,   8, acGUI_FontSouvenir18_0075 } // Code 0075, LATIN SMALL LETTER U
    , {   7,   7,   0,   7,   7, acGUI_FontSouvenir18_0076 } // Code 0076, LATIN SMALL LETTER V
    , {  11,   7,   0,   7,  11, acGUI_FontSouvenir18_0077 } // Code 0077, LATIN SMALL LETTER W
    , {   7,   7,   0,   7,   7, acGUI_FontSouvenir18_0078 } // Code 0078, LATIN SMALL LETTER X
    , {   7,  10,   0,   7,   7, acGUI_FontSouvenir18_0079 } // Code 0079, LATIN SMALL LETTER Y
    , {   5,   7,   0,   7,   6, acGUI_FontSouvenir18_007A } // Code 007A, LATIN SMALL LETTER Z
    , {   5,  13,   1,   3,   7, acGUI_FontSouvenir18_007B } // Code 007B, LEFT CURLY BRACKET
    , {   1,  15,   3,   3,   7, acGUI_FontSouvenir18_007C } // Code 007C, VERTICAL LINE
    , {   5,  13,   1,   3,   7, acGUI_FontSouvenir18_007D } // Code 007D, RIGHT CURLY BRACKET
    , {   9,   3,   1,   7,  12, acGUI_FontSouvenir18_007E } // Code 007E, TILDE
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontSouvenir18_Prop1 =
{
    0x0020,                                   // First character
    0x007E,                                   // Last character
    &GUI_FontSouvenir18_CharInfo[0],          // Address of first character
    (GUI_CONST_STORAGE GUI_FONT_PROP_EXT *)0  // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT GUI_FontSouvenir18 =
{
    GUI_FONTTYPE_PROP_AA4_EXT,      // Type of font
    18,                             // Height of font
    18,                             // Space of font y
    1,                              // Magnification x
    1,                              // Magnification y
    { &GUI_FontSouvenir18_Prop1 },
    18,                             // Baseline
    7,                              // Height of lowercase characters
    11                              // Height of capital characters
};

/*********************************************************************
*                                                                    *
*       GUI_FontAA4_32                                               *
*                                                                    *
*  Used in                                                           *
*  - GUIDEMO_AntiAliasedText.c                                       *
*                                                                    *
**********************************************************************
*/
static GUI_CONST_STORAGE unsigned char acGUI_FontAA4_32_0041[180] =   // Code 0041, LATIN CAPITAL LETTER A
{
    0x00, 0x00, 0x00, 0x3F, 0xFF, 0x20, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x8F, 0xFF, 0x70, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xEF, 0xFF, 0xD0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x04, 0xFF, 0xFF, 0xF3, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x09, 0xFF, 0xEF, 0xF8, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x0E, 0xFF, 0x6F, 0xFD, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x5F, 0xFD, 0x0D, 0xFF, 0x40, 0x00, 0x00,
    0x00, 0x00, 0xAF, 0xF7, 0x07, 0xFF, 0x90, 0x00, 0x00,
    0x00, 0x01, 0xEF, 0xF2, 0x02, 0xFF, 0xE0, 0x00, 0x00,
    0x00, 0x05, 0xFF, 0xC0, 0x00, 0xCF, 0xF5, 0x00, 0x00,
    0x00, 0x0A, 0xFF, 0x70, 0x00, 0x7F, 0xFA, 0x00, 0x00,
    0x00, 0x1F, 0xFF, 0x20, 0x00, 0x1F, 0xFF, 0x10, 0x00,
    0x00, 0x6F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x50, 0x00,
    0x00, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB0, 0x00,
    0x02, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF1, 0x00,
    0x07, 0xFF, 0xB0, 0x00, 0x00, 0x00, 0xAF, 0xF6, 0x00,
    0x0B, 0xFF, 0x50, 0x00, 0x00, 0x00, 0x5F, 0xFB, 0x00,
    0x2F, 0xFF, 0x10, 0x00, 0x00, 0x00, 0x0E, 0xFF, 0x20,
    0x7F, 0xFA, 0x00, 0x00, 0x00, 0x00, 0x0A, 0xFF, 0x70,
    0xCF, 0xF5, 0x00, 0x00, 0x00, 0x00, 0x04, 0xFF, 0xC0
};

static GUI_CONST_STORAGE unsigned char acGUI_FontAA4_32_0042[140] =   // Code 0042, LATIN CAPITAL LETTER B
{
    0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xB6, 0x00,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x90,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF5,
    0xFF, 0xF0, 0x00, 0x00, 0x13, 0xCF, 0xFC,
    0xFF, 0xF0, 0x00, 0x00, 0x00, 0x2F, 0xFF,
    0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
    0xFF, 0xF0, 0x00, 0x00, 0x00, 0x3F, 0xFC,
    0xFF, 0xF0, 0x00, 0x00, 0x14, 0xDF, 0xF7,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB0,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x50,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2,
    0xFF, 0xF0, 0x00, 0x00, 0x26, 0xEF, 0xF9,
    0xFF, 0xF0, 0x00, 0x00, 0x00, 0x5F, 0xFD,
    0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
    0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
    0xFF, 0xF0, 0x00, 0x00, 0x00, 0x4F, 0xFD,
    0xFF, 0xF0, 0x00, 0x00, 0x14, 0xEF, 0xFA,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF3,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x60,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xB4, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_FontAA4_32_0043[140] =   // Code 0043, LATIN CAPITAL LETTER C
{
    0x00, 0x00, 0x5B, 0xEF, 0xEB, 0x60, 0x00,
    0x00, 0x1B, 0xFF, 0xFF, 0xFF, 0xFC, 0x10,
    0x00, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0,
    0x07, 0xFF, 0xF7, 0x10, 0x3A, 0xFF, 0xF7,
    0x0E, 0xFF, 0x50, 0x00, 0x00, 0xAF, 0xFD,
    0x5F, 0xFB, 0x00, 0x00, 0x00, 0x2D, 0x83,
    0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xCF, 0xF3, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xEF, 0xF1, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xEF, 0xF1, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xDF, 0xF3, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xAF, 0xF6, 0x00, 0x00, 0x00, 0x2D, 0x83,
    0x6F, 0xFB, 0x00, 0x00, 0x00, 0x7F, 0xFD,
    0x1F, 0xFF, 0x40, 0x00, 0x01, 0xEF, 0xF8,
    0x08, 0xFF, 0xE7, 0x10, 0x4D, 0xFF, 0xF2,
    0x00, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
    0x00, 0x1C, 0xFF, 0xFF, 0xFF, 0xF9, 0x00,
    0x00, 0x00, 0x6B, 0xEF, 0xEA, 0x40, 0x00
};

static GUI_CONST_STORAGE GUI_CHARINFO_EXT GUI_FontAA4_32_CharInfo[3] =
{
    { 17, 20, 0, 6, 17, acGUI_FontAA4_32_0041 }, // Code 0041, LATIN CAPITAL LETTER A
    { 14, 20, 2, 6, 17, acGUI_FontAA4_32_0042 }, // Code 0042, LATIN CAPITAL LETTER B
    { 14, 20, 1, 6, 17, acGUI_FontAA4_32_0043 }  // Code 0043, LATIN CAPITAL LETTER C
};

static GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontAA4_32_Prop1 =
{
    0x0041,                                   // First character
    0x0043,                                   // Last character
    &GUI_FontAA4_32_CharInfo[0],              // Address of first character
    (GUI_CONST_STORAGE GUI_FONT_PROP_EXT *)0  // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT GUI_FontAA4_32 =
{
    GUI_FONTTYPE_PROP_AA4_EXT,  // Type of font
    33,                         // Height of font
    33,                         // Space of font y
    1,                          // Magnification x
    1,                          // Magnification y
    { &GUI_FontAA4_32_Prop1 },
    33,                         // Baseline
    15,                         // Height of lowercase characters
    20                          // Height of capital characters
};

/*********************************************************************
*                                                                    *
*       GUI_FontAA2_32                                               *
*                                                                    *
*  Used in                                                           *
*  - GUIDEMO_AntiAliasedText.c                                       *
*                                                                    *
**********************************************************************
*/
static GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0041[100] =   // Code 0041, LATIN CAPITAL LETTER A
{
    0x00, 0x03, 0xF0, 0x00, 0x00,
    0x00, 0x0B, 0xF4, 0x00, 0x00,
    0x00, 0x0F, 0xFC, 0x00, 0x00,
    0x00, 0x1F, 0xFC, 0x00, 0x00,
    0x00, 0x2F, 0xFE, 0x00, 0x00,
    0x00, 0x3F, 0x7F, 0x00, 0x00,
    0x00, 0x7F, 0x3F, 0x40, 0x00,
    0x00, 0xBD, 0x1F, 0x80, 0x00,
    0x00, 0xFC, 0x0F, 0xC0, 0x00,
    0x01, 0xFC, 0x0F, 0xD0, 0x00,
    0x02, 0xF4, 0x07, 0xE0, 0x00,
    0x03, 0xF0, 0x03, 0xF0, 0x00,
    0x07, 0xFF, 0xFF, 0xF4, 0x00,
    0x0B, 0xFF, 0xFF, 0xF8, 0x00,
    0x0F, 0xFF, 0xFF, 0xFC, 0x00,
    0x1F, 0x80, 0x00, 0xBD, 0x00,
    0x3F, 0x40, 0x00, 0x7F, 0x00,
    0x3F, 0x00, 0x00, 0x3F, 0x00,
    0x7E, 0x00, 0x00, 0x2F, 0x40,
    0xFD, 0x00, 0x00, 0x1F, 0xC0
};

static GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0042[ 80] =   // Code 0042, LATIN CAPITAL LETTER B
{
    0xFF, 0xFF, 0xF9, 0x00,
    0xFF, 0xFF, 0xFF, 0x80,
    0xFF, 0xFF, 0xFF, 0xD0,
    0xFC, 0x00, 0x0F, 0xF0,
    0xFC, 0x00, 0x03, 0xF0,
    0xFC, 0x00, 0x03, 0xF0,
    0xFC, 0x00, 0x03, 0xF0,
    0xFC, 0x00, 0x1F, 0xD0,
    0xFF, 0xFF, 0xFF, 0xC0,
    0xFF, 0xFF, 0xFF, 0x40,
    0xFF, 0xFF, 0xFF, 0xC0,
    0xFC, 0x00, 0x1F, 0xE0,
    0xFC, 0x00, 0x07, 0xF0,
    0xFC, 0x00, 0x03, 0xF0,
    0xFC, 0x00, 0x03, 0xF0,
    0xFC, 0x00, 0x07, 0xF0,
    0xFC, 0x00, 0x1F, 0xE0,
    0xFF, 0xFF, 0xFF, 0xC0,
    0xFF, 0xFF, 0xFF, 0x40,
    0xFF, 0xFF, 0xF9, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0043[ 80] =   // Code 0043, LATIN CAPITAL LETTER C
{
    0x00, 0x6F, 0xE4, 0x00,
    0x02, 0xFF, 0xFF, 0x00,
    0x0F, 0xFF, 0xFF, 0xC0,
    0x1F, 0xD0, 0x2F, 0xD0,
    0x3F, 0x40, 0x0B, 0xF0,
    0x7E, 0x00, 0x03, 0x80,
    0xBD, 0x00, 0x00, 0x00,
    0xFC, 0x00, 0x00, 0x00,
    0xFC, 0x00, 0x00, 0x00,
    0xFC, 0x00, 0x00, 0x00,
    0xFC, 0x00, 0x00, 0x00,
    0xFC, 0x00, 0x00, 0x00,
    0xFC, 0x00, 0x00, 0x00,
    0xBD, 0x00, 0x03, 0x80,
    0x7E, 0x00, 0x07, 0xF0,
    0x3F, 0x40, 0x0F, 0xE0,
    0x2F, 0xD0, 0x7F, 0xC0,
    0x0F, 0xFF, 0xFF, 0x80,
    0x03, 0xFF, 0xFE, 0x00,
    0x00, 0x7F, 0xE0, 0x00
};

static GUI_CONST_STORAGE GUI_CHARINFO_EXT GUI_FontAA2_32_CharInfo[3] =
{
    {  17,  20,   0,   6,  17, acGUI_FontAA2_32_0041 } // Code 0041, LATIN CAPITAL LETTER A
    , {  14,  20,   2,   6,  17, acGUI_FontAA2_32_0042 } // Code 0042, LATIN CAPITAL LETTER B
    , {  14,  20,   1,   6,  17, acGUI_FontAA2_32_0043 } // Code 0043, LATIN CAPITAL LETTER C
};

static GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontAA2_32_Prop1 =
{
    0x0041,                                   // First character
    0x0043,                                   // Last character
    &GUI_FontAA2_32_CharInfo[0],              // Address of first character
    (GUI_CONST_STORAGE GUI_FONT_PROP_EXT *)0  // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT GUI_FontAA2_32 =
{
    GUI_FONTTYPE_PROP_AA2_EXT,  // Type of font
    33,                         // Height of font
    33,                         // Space of font y
    1,                          // Magnification x
    1,                          // Magnification y
    { &GUI_FontAA2_32_Prop1 },
    33,                         // Baseline
    15,                         // Height of lowercase characters
    20                          // Height of capital characters
};

/*********************************************************************
*                                                                    *
*       Bitmaps                                                      *
*                                                                    *
**********************************************************************
*/
#if 0
/*********************************************************************
*                                                                    *
*       bmSeggerLogo                                                 *
*                                                                    *
*  Used in                                                           *
*  - GUIDEMO_Intro.c                                                 *
*                                                                    *
**********************************************************************
*/
static GUI_CONST_STORAGE GUI_COLOR ColorsSeggerLogo[] =
{
#if (GUI_USE_ARGB)
    0xFF00FF00, 0xFFFEFEFE, 0xFF231F20, 0xFF2020A0,
    0xFFE6E6E6, 0xFF6060BB, 0xFFBCBCE2, 0xFFDEDEDE,
    0xFF000000, 0xFFFAFAFA, 0xFF242021, 0xFFD4D3D3,
    0xFFD5D4D5, 0xFFDEDEF1, 0xFFE1E0E0, 0xFFFCFCFC,
    0xFFF1F1F1, 0xFFF8F8FC, 0xFFFCFCFE, 0xFF454142,
    0xFFC4C3C3, 0xFF2222A1, 0xFFC2C1C1, 0xFF828080,
    0xFF464344, 0xFF626060, 0xFF2626A2, 0xFFEDEDED,
    0xFF3030A7, 0xFF000000, 0xFF282525, 0xFF393536,
    0xFFB2B0B1, 0xFFE4E4E4, 0xFFEEEEF8, 0xFF4A4AB2,
    0xFF4C4CB3, 0xFF8A8888, 0xFF8E8ECF, 0xFFEAEAEA,
    0xFFF6F6F6, 0xFF1A1718, 0xFF1B1818, 0xFF2D292A,
    0xFF3C3839, 0xFF6E6C6C, 0xFF2424A2, 0xFF3636AA,
    0xFFCECDCD, 0xFFE0E0F2, 0xFFECECF7, 0xFFFAFAFD,
    0xFF2A2728, 0xFF312D2E, 0xFF484445, 0xFF2E2EA6,
    0xFF5B5BB9, 0xFF7676C4, 0xFF908E8E, 0xFF9090D0,
    0xFFC8C7C7, 0xFFCBCACA, 0xFFDAD9D9, 0xFFC2C2E5,
    0xFFC4C4E6, 0xFFE2E2F3, 0xFF0E0C0D, 0xFF211E1E,
    0xFF221E1F, 0xFF222222, 0xFF3E3B3C, 0xFF434040,
    0xFF4A4748, 0xFF4C4849, 0xFF2B2BA5, 0xFF3B3BAC,
    0xFF3D3DAC, 0xFF5E5EBB, 0xFF7A7AC6, 0xFF858384,
    0xFFA6A5A5, 0xFFA8A6A7, 0xFFBEBEE3, 0xFFC5C4C5,
    0xFFDCDCDC, 0xFFC0C0E4, 0xFFD1D1EB, 0xFFD3D3EC,
    0xFFDCDCF0, 0xFFE4E4F4, 0xFFE9E9F6, 0xFFF4F4F4,
    0xFFF6F6FB, 0xFF272324, 0xFF2E2B2C, 0xFF2F2C2D,
    0xFF353132, 0xFF363435, 0xFF585555, 0xFF686566,
    0xFF6C6A6A, 0xFF747172, 0xFF7E7B7C, 0xFF7F7C7D,
    0xFF3232A8, 0xFF3434A8, 0xFF4848B1, 0xFF4E4EB4,
    0xFF6161BC, 0xFF6767BE, 0xFF8C8A8A, 0xFF8F8C8D,
    0xFF929090, 0xFF969494, 0xFFAEACAD, 0xFFAEAEAE,
    0xFFB6B5B5, 0xFFB8B7B7, 0xFFBBBABA, 0xFF8A8ACD,
    0xFFB2B2DE, 0xFFBBBBE2, 0xFFD2D1D2, 0xFFD8D7D7,
    0xFFCECEEA, 0xFFE4E4F3, 0xFF020202, 0xFF191919,
    0xFF363334, 0xFF3A3738, 0xFF514E4F, 0xFF555252,
    0xFF5B5859, 0xFF5C5859, 0xFF605D5E, 0xFF625F60,
    0xFF676464, 0xFF7C7A7A, 0xFF2828A3, 0xFF2929A4,
    0xFF3939AB, 0xFF3A3AAB, 0xFF4444AF, 0xFF5050B4,
    0xFF5656B7, 0xFF5858B8, 0xFF5D5DBA, 0xFF6868BF,
    0xFF6E6EC1, 0xFF6F6FC2, 0xFF7070C2, 0xFF7373C4,
    0xFF7878C5, 0xFF7C7CC7, 0xFF7E7EC8, 0xFF807E7E,
    0xFF868484, 0xFF888687, 0xFF8D8B8C, 0xFF918F90,
    0xFF9C9A9A, 0xFF9E9C9D, 0xFFA09E9F, 0xFFA2A1A1,
    0xFFA5A3A4, 0xFFAAA9A9, 0xFFB5B3B4, 0xFFBBB9BA,
    0xFF8080C9, 0xFF8383CA, 0xFF8C8CCE, 0xFFA2A2D7,
    0xFFA5A5D9, 0xFFA6A6D9, 0xFFA9A9DA, 0xFFABABDB,
    0xFFACACDC, 0xFFAFAFDD, 0xFFB6B6E0, 0xFFB9B9E1,
    0xFFBFBFE4, 0xFFD0CFCF, 0xFFC6C6E7, 0xFFC8C8E8,
    0xFFD5D5ED, 0xFFD6D6EE, 0xFFD9D9EF, 0xFFDADAEF,
    0xFFE6E6F4, 0xFFE8E8F5, 0xFFEBEBF7, 0xFFF1F1F9,
    0xFFF3F3FA, 0xFFF5F5FB, 0xFFF7F7FC, 0xFF0D0B0B,
    0xFF0D0B0C, 0xFF171717, 0xFF272425, 0xFF332F30,
    0xFF333031, 0xFF4E4B4C, 0xFF4F4C4D, 0xFF565354,
    0xFF5A5758, 0xFF5F5C5C, 0xFF656263, 0xFF666364,
    0xFF6E6B6C, 0xFF716F70, 0xFF7A7878, 0xFF2D2DA5,
    0xFF2D2DA6, 0xFF4747B1, 0xFF5252B5, 0xFF5353B6,
    0xFF5454B6, 0xFF5C5CB9, 0xFF6565BE, 0xFF7575C4,
    0xFF848283, 0xFF898788, 0xFF949292, 0xFF959394,
    0xFF999798, 0xFF9A9898, 0xFF9D9C9C, 0xFF9F9D9E,
    0xFFA4A2A3, 0xFFACABAB, 0xFFB0AEAF, 0xFFB4B3B3,
    0xFFB9B7B8, 0xFFBAB8B9, 0xFFBCBBBB, 0xFFBCBBBC,
    0xFFBEBDBD, 0xFF8686CB, 0xFF8686CC, 0xFF8989CD,
    0xFF9595D2, 0xFF9696D2, 0xFF9B9BD4, 0xFF9C9CD5,
    0xFFB0B0DE, 0xFFC8C7C8, 0xFFC9C8C9, 0xFFCCCBCB,
    0xFFD4D3D4, 0xFFDCDBDB, 0xFFCDCDEA, 0xFFE4E3E3,
    0xFFECEBEB, 0xFFF0EFEF, 0xFFF4F3F3, 0xFFFCFBFB
#else
    0x00FF00, 0xFEFEFE, 0x201F23, 0xA02020,
    0xE6E6E6, 0xBB6060, 0xE2BCBC, 0xDEDEDE,
    0x000000, 0xFAFAFA, 0x212024, 0xD3D3D4,
    0xD5D4D5, 0xF1DEDE, 0xE0E0E1, 0xFCFCFC,
    0xF1F1F1, 0xFCF8F8, 0xFEFCFC, 0x424145,
    0xC3C3C4, 0xA12222, 0xC1C1C2, 0x808082,
    0x444346, 0x606062, 0xA22626, 0xEDEDED,
    0xA73030, 0x000000, 0x252528, 0x363539,
    0xB1B0B2, 0xE4E4E4, 0xF8EEEE, 0xB24A4A,
    0xB34C4C, 0x88888A, 0xCF8E8E, 0xEAEAEA,
    0xF6F6F6, 0x18171A, 0x18181B, 0x2A292D,
    0x39383C, 0x6C6C6E, 0xA22424, 0xAA3636,
    0xCDCDCE, 0xF2E0E0, 0xF7ECEC, 0xFDFAFA,
    0x28272A, 0x2E2D31, 0x454448, 0xA62E2E,
    0xB95B5B, 0xC47676, 0x8E8E90, 0xD09090,
    0xC7C7C8, 0xCACACB, 0xD9D9DA, 0xE5C2C2,
    0xE6C4C4, 0xF3E2E2, 0x0D0C0E, 0x1E1E21,
    0x1F1E22, 0x222222, 0x3C3B3E, 0x404043,
    0x48474A, 0x49484C, 0xA52B2B, 0xAC3B3B,
    0xAC3D3D, 0xBB5E5E, 0xC67A7A, 0x848385,
    0xA5A5A6, 0xA7A6A8, 0xE3BEBE, 0xC5C4C5,
    0xDCDCDC, 0xE4C0C0, 0xEBD1D1, 0xECD3D3,
    0xF0DCDC, 0xF4E4E4, 0xF6E9E9, 0xF4F4F4,
    0xFBF6F6, 0x242327, 0x2C2B2E, 0x2D2C2F,
    0x323135, 0x353436, 0x555558, 0x666568,
    0x6A6A6C, 0x727174, 0x7C7B7E, 0x7D7C7F,
    0xA83232, 0xA83434, 0xB14848, 0xB44E4E,
    0xBC6161, 0xBE6767, 0x8A8A8C, 0x8D8C8F,
    0x909092, 0x949496, 0xADACAE, 0xAEAEAE,
    0xB5B5B6, 0xB7B7B8, 0xBABABB, 0xCD8A8A,
    0xDEB2B2, 0xE2BBBB, 0xD2D1D2, 0xD7D7D8,
    0xEACECE, 0xF3E4E4, 0x020202, 0x191919,
    0x343336, 0x38373A, 0x4F4E51, 0x525255,
    0x59585B, 0x59585C, 0x5E5D60, 0x605F62,
    0x646467, 0x7A7A7C, 0xA32828, 0xA42929,
    0xAB3939, 0xAB3A3A, 0xAF4444, 0xB45050,
    0xB75656, 0xB85858, 0xBA5D5D, 0xBF6868,
    0xC16E6E, 0xC26F6F, 0xC27070, 0xC47373,
    0xC57878, 0xC77C7C, 0xC87E7E, 0x7E7E80,
    0x848486, 0x878688, 0x8C8B8D, 0x908F91,
    0x9A9A9C, 0x9D9C9E, 0x9F9EA0, 0xA1A1A2,
    0xA4A3A5, 0xA9A9AA, 0xB4B3B5, 0xBAB9BB,
    0xC98080, 0xCA8383, 0xCE8C8C, 0xD7A2A2,
    0xD9A5A5, 0xD9A6A6, 0xDAA9A9, 0xDBABAB,
    0xDCACAC, 0xDDAFAF, 0xE0B6B6, 0xE1B9B9,
    0xE4BFBF, 0xCFCFD0, 0xE7C6C6, 0xE8C8C8,
    0xEDD5D5, 0xEED6D6, 0xEFD9D9, 0xEFDADA,
    0xF4E6E6, 0xF5E8E8, 0xF7EBEB, 0xF9F1F1,
    0xFAF3F3, 0xFBF5F5, 0xFCF7F7, 0x0B0B0D,
    0x0C0B0D, 0x171717, 0x252427, 0x302F33,
    0x313033, 0x4C4B4E, 0x4D4C4F, 0x545356,
    0x58575A, 0x5C5C5F, 0x636265, 0x646366,
    0x6C6B6E, 0x706F71, 0x78787A, 0xA52D2D,
    0xA62D2D, 0xB14747, 0xB55252, 0xB65353,
    0xB65454, 0xB95C5C, 0xBE6565, 0xC47575,
    0x838284, 0x888789, 0x929294, 0x949395,
    0x989799, 0x98989A, 0x9C9C9D, 0x9E9D9F,
    0xA3A2A4, 0xABABAC, 0xAFAEB0, 0xB3B3B4,
    0xB8B7B9, 0xB9B8BA, 0xBBBBBC, 0xBCBBBC,
    0xBDBDBE, 0xCB8686, 0xCC8686, 0xCD8989,
    0xD29595, 0xD29696, 0xD49B9B, 0xD59C9C,
    0xDEB0B0, 0xC8C7C8, 0xC9C8C9, 0xCBCBCC,
    0xD4D3D4, 0xDBDBDC, 0xEACDCD, 0xE3E3E4,
    0xEBEBEC, 0xEFEFF0, 0xF3F3F4, 0xFBFBFC
#endif
};

static GUI_CONST_STORAGE GUI_LOGPALETTE PalSeggerLogo =
{
    256,  // Number of entries
    1,    // Has transparency
    &ColorsSeggerLogo[0]
};

static GUI_CONST_STORAGE unsigned char acSeggerLogo[] =
{
    0x00, 0x00, 0x08, 0x42, 0x2A, 0x44, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x44, 0x2A, 0x42, 0x42, 0x00, 0x00,
    0x00, 0x7E, 0x2A, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x34, 0x7F, 0x00,
    0x08, 0x29, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x29, 0x08,
    0xC3, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xC4,
    0x29, 0x02, 0x02, 0x02, 0x46, 0x3C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x46, 0x02, 0x02, 0x02, 0x29,
    0x43, 0x02, 0x02, 0x02, 0xA7, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x76, 0x02, 0x02, 0x02, 0x43,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0xB1, 0x4C, 0x23, 0x57, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5A, 0x38, 0x2F, 0x26, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0xBF, 0x1A, 0x03, 0x03, 0x2F, 0x32, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x98, 0x03, 0x03, 0x03, 0xAB, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x32, 0x15, 0x03, 0x03, 0x03, 0x92, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x94, 0x03, 0x03, 0x03, 0x1A, 0x7C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x9A, 0x03, 0x03, 0x03, 0x03, 0x3B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xB9, 0x8A, 0x03, 0x03, 0x03, 0x8C, 0x32, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x11, 0x24, 0x03, 0x03, 0x03, 0x15, 0x40, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xAF, 0x03, 0x03, 0x03, 0x03, 0x38, 0x12, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x31, 0x37, 0x03, 0x03, 0x03, 0x2F, 0x5A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x4E, 0x03, 0x03, 0x03, 0x03, 0x77, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0xB3, 0x03, 0x03, 0x03, 0x03, 0x91, 0x12, 0x01, 0x01, 0x01, 0x01, 0x01, 0x11, 0x6B, 0x03, 0x03, 0x03, 0x03, 0x79, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xA9, 0x03, 0x03, 0x03, 0x03, 0xAA, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x7D, 0x1C, 0x03, 0x03, 0x03, 0x37, 0x31, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x33, 0xD6, 0x03, 0x03, 0x03, 0x15, 0x55, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x55, 0x15, 0x03, 0x03, 0x03, 0x23, 0xC2, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x59, 0x1C, 0x03, 0x03, 0x03, 0x68, 0xBC, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3B, 0x03, 0x03, 0x03, 0x03, 0x97, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x52, 0x15, 0x03, 0x03, 0x03, 0xD8, 0x33, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x6C, 0x03, 0x03, 0x03, 0x03, 0xAC, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xEF, 0x03, 0x03, 0x03, 0x03, 0xEE, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x22, 0x4C, 0x03, 0x03, 0x03, 0x1A, 0x56, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x12, 0x90, 0x03, 0x03, 0x03, 0x03, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x57, 0x8A, 0x03, 0x03, 0x03, 0x4B, 0x22, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0xC0, 0x11, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xBD, 0x68, 0x03, 0x03, 0x03, 0x1C, 0x7D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xAE, 0x03, 0x03, 0x03, 0x03, 0x4D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x99, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3F, 0x15, 0x03, 0x03, 0x03, 0x8F, 0x33, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x98, 0x03, 0x03, 0x03, 0x03, 0x26, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x03, 0x78, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x26, 0x03, 0x03, 0x03, 0x03, 0xA8, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x11, 0x24, 0x03, 0x03, 0x03, 0x15, 0xB4, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x03, 0x4A, 0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x38, 0x03, 0x03, 0x03, 0x03, 0xB2, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x41, 0x1C, 0x03, 0x03, 0x03, 0x1C, 0x41, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x03, 0x03, 0x6A, 0xC2, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xBE, 0x2F, 0x03, 0x03, 0x03, 0xD4, 0x31, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x52, 0x15, 0x03, 0x03, 0x03, 0x24, 0x11, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x03, 0x03, 0x03, 0x39, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xB7, 0x15, 0x03, 0x03, 0x03, 0x24, 0x11, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x26, 0x03, 0x03, 0x03, 0x03, 0x95, 0x06, 0x06, 0x06, 0x06,
    0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
    0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
    0x06, 0x06, 0x06, 0x06, 0x06, 0x3F, 0x11, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x03, 0x03, 0x03, 0x03, 0xB0, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xF0, 0x03, 0x03, 0x03, 0x03, 0x99, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x4D, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x23, 0x11, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x03, 0x03, 0x03, 0x03, 0x8B, 0xBA, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x03, 0x03, 0x03, 0x03, 0x78, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x22, 0x4B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0xB6, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0xC1, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x22, 0x8D, 0x03, 0x03, 0x03, 0x4A, 0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x56, 0x1A, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x1A, 0x59, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x96, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xFA, 0x2E, 0x03, 0x03, 0x03, 0x6A, 0xC2, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x40, 0x93, 0x05, 0x05, 0x05, 0x05, 0x05,
    0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
    0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
    0x05, 0x05, 0x05, 0x05, 0x05, 0x6D, 0x3F, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0xAD, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xF2, 0x03, 0x03, 0x03, 0x03, 0x39, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8A, 0xB8, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xDA, 0x03, 0x03, 0x03, 0x03, 0xBB, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8A, 0xB8, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x6D, 0x03, 0x03, 0x03, 0x03, 0xBB, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0xAD, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xF3, 0x03, 0x03, 0x03, 0x03, 0xDB, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x96, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x7C, 0x1A, 0x03, 0x03, 0x03, 0xD5, 0x5C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x40, 0x93, 0x05, 0x05, 0x05, 0x05, 0x05,
    0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
    0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
    0x05, 0x05, 0x05, 0x05, 0x05, 0x6D, 0x3F, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0xC1, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x22, 0x8D, 0x03, 0x03, 0x03, 0x4A, 0x58, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x56, 0x1A, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x1A, 0x59, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x03, 0x03, 0x03, 0x03, 0x8B, 0xBA, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x6C, 0x03, 0x03, 0x03, 0x03, 0xF4, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x22, 0x4B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0xB6, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x03, 0x03, 0x03, 0x03, 0xB0, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xF1, 0x03, 0x03, 0x03, 0x03, 0x4E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x4D, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x23, 0x11, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x03, 0x03, 0x03, 0x39, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xB7, 0x15, 0x03, 0x03, 0x03, 0x23, 0x11, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x26, 0x03, 0x03, 0x03, 0x03, 0x95, 0x06, 0x06, 0x06, 0x06,
    0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
    0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
    0x06, 0x06, 0x06, 0x06, 0x06, 0x3F, 0x11, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x03, 0x03, 0x6A, 0xC2, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xBE, 0x2F, 0x03, 0x03, 0x03, 0xD3, 0x31, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x52, 0x15, 0x03, 0x03, 0x03, 0x24, 0x11, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x03, 0x4A, 0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xD9, 0x03, 0x03, 0x03, 0x03, 0xB2, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x41, 0x1C, 0x03, 0x03, 0x03, 0x1C, 0x41, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x03, 0x78, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3B, 0x03, 0x03, 0x03, 0x03, 0xA8, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x11, 0x24, 0x03, 0x03, 0x03, 0x15, 0xB4, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x99, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x40, 0x15, 0x03, 0x03, 0x03, 0x6B, 0x33, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x98, 0x03, 0x03, 0x03, 0x03, 0x26, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0xC0, 0x11, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xBD, 0x69, 0x03, 0x03, 0x03, 0x37, 0x41, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xAE, 0x03, 0x03, 0x03, 0x03, 0x4D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x28, 0xEC,
    0xE0, 0x25, 0x25, 0xA1, 0xF6, 0x0F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x3E, 0x0F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0xE6, 0x9F, 0x9D, 0x70, 0x72, 0x0E, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x10, 0x75, 0x71, 0x9D, 0x6F, 0x51, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3E, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x07, 0x01, 0x01, 0x01, 0x01, 0xFC, 0xF8, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B,
    0x0C, 0x21, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x12, 0x90, 0x03, 0x03, 0x03, 0x03, 0x79, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x57, 0x8A, 0x03, 0x03, 0x03, 0x4B, 0x22, 0x01, 0x01, 0x01, 0x01, 0x01, 0x71, 0x5E, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x2C, 0x20, 0x01, 0x01, 0x01, 0x01, 0xDD, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x84, 0x01, 0x01, 0x01, 0x01, 0xFB, 0x63, 0x0A, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x83, 0x3D, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x10, 0x66, 0x1E, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x47, 0x20, 0x01, 0x01, 0x01, 0x01, 0x01, 0x87, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x17, 0x01, 0x01, 0x16, 0x5D, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0xC8, 0x4F, 0x28, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x77, 0x03, 0x03, 0x03, 0x03, 0xED, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x22, 0x4C, 0x03, 0x03, 0x03, 0x1A, 0x56, 0x01, 0x01, 0x01, 0x01, 0x01, 0x70, 0x02, 0x02, 0x02,
    0x18, 0xCE, 0x85, 0x5E, 0x02, 0x02, 0x02, 0x72, 0x01, 0x01, 0x01, 0x48, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x19, 0x01, 0x01, 0x01, 0x30, 0x35, 0x02, 0x02, 0x02, 0x35, 0x36, 0x61, 0x02, 0x02, 0x02, 0x0A, 0xE7, 0x01, 0x01,
    0x01, 0x01, 0x04, 0x47, 0x02, 0x02, 0x02, 0x34, 0x18, 0x46, 0x02, 0x02, 0x02, 0x02, 0x6E, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x25, 0x01, 0x01, 0x9C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x88, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x52, 0x15, 0x03, 0x03, 0x03, 0xD7, 0x33, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x6C, 0x03, 0x03, 0x03, 0x03, 0xAC, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x5F, 0x02, 0x02, 0xA4,
    0x01, 0x01, 0x01, 0x5B, 0x63, 0x02, 0x02, 0x84, 0x01, 0x01, 0x01, 0x18, 0x02, 0x02, 0x71, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x04, 0x01, 0x01, 0x01, 0x1B, 0x80, 0x02, 0x02, 0x1F, 0xEB, 0x01, 0x01, 0x01, 0x3C, 0x2C, 0x02, 0x02, 0x36, 0x01, 0x01,
    0x01, 0x01, 0x82, 0x02, 0x02, 0x34, 0xA4, 0x09, 0x01, 0x01, 0xF9, 0x82, 0x02, 0x02, 0x5D, 0x28, 0x01, 0x01, 0x09, 0x02, 0x02, 0x02, 0x74, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0xFC, 0x01, 0x01, 0x01, 0x17, 0x02, 0x02, 0x85, 0x04, 0x04, 0x04, 0x21,
    0x7A, 0x63, 0x02, 0x02, 0x02, 0xFB, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x59, 0x1C, 0x03, 0x03, 0x03, 0x68, 0xBC, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3B, 0x03, 0x03, 0x03, 0x03, 0x97, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1B, 0x02, 0x02, 0x02, 0xF9,
    0x01, 0x01, 0x01, 0x01, 0x09, 0x3A, 0x19, 0x14, 0x01, 0x01, 0x01, 0x18, 0x02, 0x02, 0x51, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x6E, 0x02, 0x02, 0x1E, 0x3E, 0x01, 0x01, 0x01, 0x01, 0x01, 0xFB, 0xC9, 0x0A, 0x25, 0x01, 0x01,
    0x01, 0xA6, 0x02, 0x02, 0x02, 0xA6, 0x01, 0x01, 0x01, 0x01, 0x01, 0xFE, 0xCF, 0x0A, 0x19, 0x01, 0x01, 0x01, 0x09, 0x02, 0x02, 0x02, 0x30, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x17, 0x02, 0x02, 0x19, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x1B, 0x02, 0x02, 0x02, 0x3C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x33, 0xD6, 0x03, 0x03, 0x03, 0x15, 0x55, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x55, 0x15, 0x03, 0x03, 0x03, 0x23, 0xC2, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x5E, 0x02, 0x02, 0x2C,
    0xA0, 0x3E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x18, 0x02, 0x02, 0xA4, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0x01, 0x01, 0x01, 0x01, 0x47, 0x02, 0x02, 0x65, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xFF, 0x01, 0x01, 0x01,
    0x01, 0x64, 0x02, 0x02, 0x48, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xFF, 0x01, 0x01, 0x01, 0x01, 0x09, 0x02, 0x02, 0x02, 0x3D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x01, 0x01, 0x01, 0x01, 0x01, 0x17, 0x02, 0x02, 0x19, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x0E, 0x02, 0x02, 0x02, 0x54, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xA9, 0x03, 0x03, 0x03, 0x03, 0xAA, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x7D, 0x1C, 0x03, 0x03, 0x03, 0x37, 0x31, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x70, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x5E, 0xCC, 0x6E, 0x53, 0x0F, 0x01, 0x01, 0x01, 0x01, 0x18, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x36, 0xFD, 0x01, 0x09, 0x0A, 0x02, 0x02, 0xA5, 0x01, 0x01, 0x01, 0x01, 0x01, 0x10, 0x10, 0x10, 0x10, 0xFF, 0x01, 0x01,
    0x01, 0x18, 0x02, 0x02, 0x67, 0x01, 0x01, 0x01, 0x01, 0x01, 0xFE, 0x10, 0x10, 0x10, 0x09, 0x01, 0x01, 0x01, 0x09, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0A, 0x86, 0x01, 0x01, 0x01, 0x17, 0x02, 0x02, 0x49, 0x20, 0x20, 0x20, 0x20,
    0xE3, 0x18, 0x02, 0x02, 0xCD, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0xB3, 0x03, 0x03, 0x03, 0x03, 0x91, 0x12, 0x01, 0x01, 0x01, 0x01, 0x01, 0x11, 0x6B, 0x03, 0x03, 0x03, 0x03, 0x79, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x73, 0x49, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x2C, 0x76, 0x01, 0x01, 0x01, 0x18, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x1E, 0x21, 0x01, 0x1B, 0x02, 0x02, 0x02, 0x75, 0x01, 0x01, 0x01, 0x10, 0x2C, 0x02, 0x02, 0x02, 0x02, 0xC6, 0xE4, 0x01,
    0x01, 0x81, 0x02, 0x02, 0x9E, 0x01, 0x01, 0x01, 0x01, 0x62, 0x02, 0x02, 0x02, 0x02, 0x0A, 0x66, 0x01, 0x01, 0x09, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x1F, 0x01, 0x01, 0x01, 0x17, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x0A, 0x89, 0x5B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x31, 0x37, 0x03, 0x03, 0x03, 0x69, 0x5A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x4E, 0x03, 0x03, 0x03, 0x03, 0x77, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0E,
    0xE5, 0x9B, 0xCA, 0x0A, 0x02, 0x02, 0x02, 0x5D, 0x7A, 0x01, 0x01, 0x18, 0x02, 0x02, 0xDC, 0x16, 0x16, 0x16, 0x16, 0x16, 0x14, 0x04, 0x01, 0x01, 0x09, 0x0A, 0x02, 0x02, 0x50, 0x01, 0x01, 0x01, 0xFC, 0x2B, 0x02, 0x02, 0x02, 0x02, 0x02, 0x2D, 0x01,
    0x01, 0x18, 0x02, 0x02, 0x89, 0x01, 0x01, 0x01, 0x01, 0x13, 0x02, 0x02, 0x02, 0x02, 0x02, 0x18, 0x01, 0x01, 0x09, 0x02, 0x02, 0x02, 0xE3, 0x16, 0x16, 0x16, 0x16, 0x16, 0x53, 0xFD, 0x01, 0x01, 0x01, 0x17, 0x02, 0x02, 0x0A, 0x1E, 0x1E, 0x1E, 0x0A,
    0x02, 0x02, 0x02, 0x35, 0xB5, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x11, 0x24, 0x03, 0x03, 0x03, 0x15, 0x40, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xAF, 0x03, 0x03, 0x03, 0x03, 0x38, 0x12, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x28, 0x7B, 0x0F, 0x01,
    0x01, 0x01, 0x01, 0x27, 0x9F, 0x5D, 0x02, 0x02, 0x9C, 0x01, 0x01, 0x18, 0x02, 0x02, 0x51, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x13, 0x02, 0x02, 0xD0, 0x01, 0x01, 0x01, 0x01, 0x27, 0x3D, 0x3D, 0x17, 0x02, 0x02, 0x2D, 0x01,
    0x01, 0x2D, 0x02, 0x02, 0x13, 0x01, 0x01, 0x01, 0x01, 0xFE, 0xF7, 0x3D, 0xA3, 0x02, 0x02, 0x18, 0x01, 0x01, 0x09, 0x02, 0x02, 0x02, 0x30, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x17, 0x02, 0x02, 0x19, 0x01, 0x01, 0x01, 0x01,
    0x7B, 0x1F, 0x02, 0x02, 0x19, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x9A, 0x03, 0x03, 0x03, 0x03, 0x3B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xB9, 0x8A, 0x03, 0x03, 0x03, 0x8C, 0x32, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x36, 0x02, 0x83, 0x28,
    0x01, 0x01, 0x01, 0x01, 0x01, 0xD1, 0x02, 0x02, 0xD2, 0x01, 0x01, 0x18, 0x02, 0x02, 0x51, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3A, 0x02, 0x02, 0x5D, 0x30, 0x01, 0x01, 0x01, 0x01, 0x01, 0x09, 0x48, 0x02, 0x02, 0x2D, 0x01,
    0x01, 0xE8, 0x02, 0x02, 0x02, 0x50, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xD0, 0x02, 0x02, 0x18, 0x01, 0x01, 0x09, 0x02, 0x02, 0x02, 0x30, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x17, 0x02, 0x02, 0x19, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x67, 0x02, 0x02, 0x47, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x32, 0x15, 0x03, 0x03, 0x03, 0x92, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x94, 0x03, 0x03, 0x03, 0x1A, 0x7C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xFF, 0x2B, 0x02, 0x02, 0x87,
    0xFC, 0x01, 0x01, 0x01, 0x54, 0x81, 0x02, 0x02, 0xE4, 0x01, 0x01, 0x18, 0x02, 0x02, 0xDC, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x01, 0x01, 0x10, 0x81, 0x02, 0x02, 0x5F, 0x51, 0x28, 0x01, 0x01, 0x0C, 0xCC, 0x02, 0x02, 0x02, 0x2D, 0x01,
    0x01, 0x01, 0xCB, 0x02, 0x02, 0x5D, 0x3A, 0x1B, 0x01, 0x01, 0xFB, 0x65, 0x02, 0x02, 0x02, 0x18, 0x01, 0x01, 0x09, 0x02, 0x02, 0x02, 0xA2, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x53, 0xFC, 0x01, 0x01, 0x17, 0x02, 0x02, 0x19, 0x01, 0x01, 0x01, 0x01,
    0x01, 0xA0, 0x02, 0x02, 0x60, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0xBF, 0x1A, 0x03, 0x03, 0x2F, 0x32, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x98, 0x03, 0x03, 0x03, 0xAB, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xE1, 0x02, 0x02, 0x02,
    0x5D, 0x49, 0x62, 0x18, 0x0A, 0x02, 0x02, 0x36, 0x28, 0x01, 0x01, 0x48, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0A, 0xB5, 0x01, 0x01, 0x7A, 0xC7, 0x02, 0x02, 0x02, 0x5D, 0x81, 0x35, 0x02, 0x02, 0x5E, 0x2B, 0x02, 0x2D, 0x01,
    0x01, 0x01, 0x27, 0x18, 0x02, 0x02, 0x02, 0x0A, 0x1F, 0x80, 0x02, 0x02, 0x0A, 0x60, 0x02, 0x18, 0x01, 0x01, 0x01, 0x0A, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x5E, 0xFD, 0x01, 0x17, 0x02, 0x02, 0x19, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x74, 0x02, 0x02, 0x02, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0xB1, 0x4C, 0x23, 0x57, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5A, 0x38, 0x2F, 0x26, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xA6, 0x47, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x0A, 0xD0, 0x1B, 0x01, 0x01, 0x01, 0x25, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x34, 0x7B, 0x01, 0x01, 0x01, 0xFB, 0x88, 0x0A, 0x02, 0x02, 0x02, 0x02, 0x02, 0x18, 0x0B, 0x86, 0x02, 0x65, 0x01,
    0x01, 0x01, 0x01, 0x10, 0x66, 0x1E, 0x02, 0x02, 0x02, 0x02, 0x02, 0x80, 0xE9, 0x25, 0x02, 0x49, 0x01, 0x01, 0x01, 0x19, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x61, 0xFE, 0x01, 0xE2, 0x02, 0x02, 0x67, 0x01, 0x01, 0x01, 0x01,
    0x01, 0xFC, 0x34, 0x02, 0x5D, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x30,
    0xA2, 0x25, 0x4F, 0x3A, 0x72, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xFB, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xFD, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x21, 0xA5, 0x9E, 0x4F, 0xDF, 0x14, 0x0F, 0x01, 0x07, 0x9F, 0x54, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0xFD, 0xE7, 0x9F, 0x4F, 0x3A, 0x75, 0x28, 0x01, 0xFD, 0xDE, 0xF5, 0x01, 0x01, 0x01, 0x01, 0x54, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x7B, 0x28, 0x01, 0x01, 0x01, 0x16, 0xEA, 0x09, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x07, 0x20, 0x7B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
    0x43, 0x02, 0x02, 0x02, 0xA7, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x76, 0x02, 0x02, 0x02, 0x43,
    0x81, 0x02, 0x02, 0x02, 0x46, 0x3C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x46, 0x02, 0x02, 0x02, 0x81,
    0x5F, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x5F,
    0x45, 0x29, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x29, 0x45,
    0x00, 0x7E, 0x2A, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x34, 0x7F, 0x00,
    0x00, 0x00, 0x08, 0x42, 0x2A, 0x44, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x44, 0x2A, 0x42, 0x42, 0x00, 0x00
};

GUI_CONST_STORAGE GUI_BITMAP bmSeggerLogo =
{
    140,            // XSize
    70,            // YSize
    140,            // BytesPerLine
    8,            // BitsPerPixel
    acSeggerLogo,   // Pointer to picture data (indices)
    &PalSeggerLogo  // Pointer to palette
};
#endif
/*********************************************************************
*                                                                    *
*       bmSeggerLogo70x35                                            *
*                                                                    *
*  Used in                                                           *
*  - GUIDEMO.c                                                       *
*  - GUIDEMO_Automotive.c                                            *
*                                                                    *
**********************************************************************
*/
#ifdef __DEMO_160x128__
#else
static GUI_CONST_STORAGE GUI_COLOR ColorsSeggerLogo70x35[] =
{
#if (GUI_USE_ARGB)
    0xFF00FF00, 0xFFFFFFFF, 0xFF231F20, 0xFF2020A0,
    0xFFF3F3F3, 0xFF6E6EC1, 0xFFAFAFDD, 0xFFEFEFEF,
    0xFFE0E0E0, 0xFFEEEEF8, 0xFFFDFDFD, 0xFF7B797A,
    0xFFEAEAEA, 0xFF2424A2, 0xFFFAFAFA, 0xFF242021,
    0xFFFAFAFD, 0xFF282526, 0xFF524F50, 0xFF828080,
    0xFF8A8888, 0xFFA2A0A0, 0xFFEAEAF6, 0xFFF8F8F8,
    0xFFFEFEFE, 0xFFFEFEFF, 0xFF211D1E, 0xFF2D292A,
    0xFF2A2AA4, 0xFFB0AFAF, 0xFF9D9DD5, 0xFFB1B1DE,
    0xFFFBFBFD, 0xFFFCFCFC, 0xFFFCFCFE, 0xFF242122,
    0xFF2B2728, 0xFF6D6A6A, 0xFF4343AF, 0xFF7777C5,
    0xFF7D7DC8, 0xFF838182, 0xFF9B999A, 0xFFDADAEF,
    0xFFDBDBF0, 0xFFF6F6F6, 0xFF131011, 0xFF131111,
    0xFF201D1E, 0xFF2C2829, 0xFF2E2A2B, 0xFF2E2B2C,
    0xFF343031, 0xFF423E3F, 0xFF433F40, 0xFF424041,
    0xFF494647, 0xFF4A4748, 0xFF5A5657, 0xFF6B6869,
    0xFF767474, 0xFF7D7B7C, 0xFF2121A0, 0xFF2323A1,
    0xFF2525A2, 0xFF2B2BA5, 0xFF2C2CA5, 0xFF2E2EA6,
    0xFF3434A8, 0xFF3535A9, 0xFF3636AA, 0xFF3838AA,
    0xFF3B3BAB, 0xFF3E3EAD, 0xFF4141AE, 0xFF4444AF,
    0xFF4C4CB3, 0xFF4D4DB3, 0xFF5353B6, 0xFF5555B6,
    0xFF5959B8, 0xFF5D5DBA, 0xFF6262BC, 0xFF6363BD,
    0xFF6A6ABF, 0xFF6B6BC0, 0xFF7070C2, 0xFF7C7CC7,
    0xFF817F7F, 0xFF848282, 0xFF8C8A8A, 0xFF8F8D8D,
    0xFF979596, 0xFFA3A1A2, 0xFFBBBABA, 0xFF8282CA,
    0xFF8383CA, 0xFF8D8DCF, 0xFF9393D1, 0xFF9797D3,
    0xFF9B9BD5, 0xFFA3A3D8, 0xFFB2B2DE, 0xFFB3B3DF,
    0xFFB4B4DF, 0xFFC5C4C4, 0xFFC6C5C5, 0xFFC9C8C8,
    0xFFD6D5D5, 0xFFD8D7D7, 0xFFC7C7E7, 0xFFC9C9E8,
    0xFFCACAE8, 0xFFCACAE9, 0xFFCECEEA, 0xFFCFCFEA,
    0xFFD3D3EC, 0xFFDEDEF1, 0xFFE2E1E1, 0xFFE2E1E2,
    0xFFE8E8E8, 0xFFECEBEB, 0xFFEDECEC, 0xFFE8E8F5,
    0xFFEFEFF8, 0xFFF4F4F4, 0xFFF0F0F8, 0xFFF0F0F9,
    0xFFF1F1F9, 0xFFF3F3FA, 0xFFF4F4FA, 0xFFF7F7FC,
    0xFFF9F9FC, 0xFFFDFDFE, 0xFF010101, 0xFF121212,
    0xFF262223, 0xFF272324, 0xFF282425, 0xFF312D2E,
    0xFF312E2F, 0xFF332F30, 0xFF333031, 0xFF343132,
    0xFF393536, 0xFF393637, 0xFF3B3738, 0xFF3E3A3B,
    0xFF3F3B3C, 0xFF3F3C3D, 0xFF413E3F, 0xFF434041,
    0xFF464243, 0xFF484546, 0xFF4A4647, 0xFF4E4B4C,
    0xFF524E4F, 0xFF545051, 0xFF545152, 0xFF555152,
    0xFF565253, 0xFF565354, 0xFF575455, 0xFF585556,
    0xFF595657, 0xFF5A5758, 0xFF5C595A, 0xFF5F5C5D,
    0xFF605D5E, 0xFF625F60, 0xFF636161, 0xFF666364,
    0xFF6F6D6D, 0xFF716F6F, 0xFF747272, 0xFF757373,
    0xFF787576, 0xFF7B7879, 0xFF7C797A, 0xFF7D7A7B,
    0xFF7F7C7D, 0xFF2626A3, 0xFF2727A3, 0xFF4949B1,
    0xFF4949B2, 0xFF6767BE, 0xFF6868BE, 0xFF7878C5,
    0xFF807E7E, 0xFF898787, 0xFF8C8C8C, 0xFF929091,
    0xFF939192, 0xFF939393, 0xFF979696, 0xFF989697,
    0xFF999798, 0xFF9A9899, 0xFF9C9A9B, 0xFF9D9B9B,
    0xFF9D9C9C, 0xFF9E9C9C, 0xFF9F9D9E, 0xFFA09E9E,
    0xFFA09E9F, 0xFFA19F9F, 0xFFA3A2A2, 0xFFA4A2A3,
    0xFFA5A3A4, 0xFFA6A4A5, 0xFFAAA9A9, 0xFFADACAC,
    0xFFB1B0B0, 0xFFB3B2B2, 0xFFB4B3B3, 0xFFB5B4B4,
    0xFFBAB9B9, 0xFFBDBBBC, 0xFFBEBDBD, 0xFF8080C9,
    0xFF8181C9, 0xFFAEAEDC, 0xFFAEAEDD, 0xFFB8B8E1,
    0xFFB9B9E1, 0xFFC1C0C0, 0xFFC5C3C4, 0xFFC7C6C6,
    0xFFC7C6C7, 0xFFCAC9C9, 0xFFCAC9CA, 0xFFCBCACA,
    0xFFCCCBCB, 0xFFCDCCCC, 0xFFCECDCD, 0xFFD1D1D1,
    0xFFD2D1D1, 0xFFD4D3D4, 0xFFD5D4D5, 0xFFDBDADA,
    0xFFDBDBDB, 0xFFDDDCDD, 0xFFDFDEDE, 0xFFE0DFDF,
    0xFFE4E3E3, 0xFFE4E4E4, 0xFFE5E4E4, 0xFFE7E6E6,
    0xFFECECEC, 0xFFEDEDED, 0xFFE1E1F2, 0xFFE2E2F2,
    0xFFF0EFEF, 0xFFF1F1F1, 0xFFF3F2F3, 0xFFF8F7F8
#else
    0x00FF00, 0xFFFFFF, 0x201F23, 0xA02020,
    0xF3F3F3, 0xC16E6E, 0xDDAFAF, 0xEFEFEF,
    0xE0E0E0, 0xF8EEEE, 0xFDFDFD, 0x7A797B,
    0xEAEAEA, 0xA22424, 0xFAFAFA, 0x212024,
    0xFDFAFA, 0x262528, 0x504F52, 0x808082,
    0x88888A, 0xA0A0A2, 0xF6EAEA, 0xF8F8F8,
    0xFEFEFE, 0xFFFEFE, 0x1E1D21, 0x2A292D,
    0xA42A2A, 0xAFAFB0, 0xD59D9D, 0xDEB1B1,
    0xFDFBFB, 0xFCFCFC, 0xFEFCFC, 0x222124,
    0x28272B, 0x6A6A6D, 0xAF4343, 0xC57777,
    0xC87D7D, 0x828183, 0x9A999B, 0xEFDADA,
    0xF0DBDB, 0xF6F6F6, 0x111013, 0x111113,
    0x1E1D20, 0x29282C, 0x2B2A2E, 0x2C2B2E,
    0x313034, 0x3F3E42, 0x403F43, 0x414042,
    0x474649, 0x48474A, 0x57565A, 0x69686B,
    0x747476, 0x7C7B7D, 0xA02121, 0xA12323,
    0xA22525, 0xA52B2B, 0xA52C2C, 0xA62E2E,
    0xA83434, 0xA93535, 0xAA3636, 0xAA3838,
    0xAB3B3B, 0xAD3E3E, 0xAE4141, 0xAF4444,
    0xB34C4C, 0xB34D4D, 0xB65353, 0xB65555,
    0xB85959, 0xBA5D5D, 0xBC6262, 0xBD6363,
    0xBF6A6A, 0xC06B6B, 0xC27070, 0xC77C7C,
    0x7F7F81, 0x828284, 0x8A8A8C, 0x8D8D8F,
    0x969597, 0xA2A1A3, 0xBABABB, 0xCA8282,
    0xCA8383, 0xCF8D8D, 0xD19393, 0xD39797,
    0xD59B9B, 0xD8A3A3, 0xDEB2B2, 0xDFB3B3,
    0xDFB4B4, 0xC4C4C5, 0xC5C5C6, 0xC8C8C9,
    0xD5D5D6, 0xD7D7D8, 0xE7C7C7, 0xE8C9C9,
    0xE8CACA, 0xE9CACA, 0xEACECE, 0xEACFCF,
    0xECD3D3, 0xF1DEDE, 0xE1E1E2, 0xE2E1E2,
    0xE8E8E8, 0xEBEBEC, 0xECECED, 0xF5E8E8,
    0xF8EFEF, 0xF4F4F4, 0xF8F0F0, 0xF9F0F0,
    0xF9F1F1, 0xFAF3F3, 0xFAF4F4, 0xFCF7F7,
    0xFCF9F9, 0xFEFDFD, 0x010101, 0x121212,
    0x232226, 0x242327, 0x252428, 0x2E2D31,
    0x2F2E31, 0x302F33, 0x313033, 0x323134,
    0x363539, 0x373639, 0x38373B, 0x3B3A3E,
    0x3C3B3F, 0x3D3C3F, 0x3F3E41, 0x414043,
    0x434246, 0x464548, 0x47464A, 0x4C4B4E,
    0x4F4E52, 0x515054, 0x525154, 0x525155,
    0x535256, 0x545356, 0x555457, 0x565558,
    0x575659, 0x58575A, 0x5A595C, 0x5D5C5F,
    0x5E5D60, 0x605F62, 0x616163, 0x646366,
    0x6D6D6F, 0x6F6F71, 0x727274, 0x737375,
    0x767578, 0x79787B, 0x7A797C, 0x7B7A7D,
    0x7D7C7F, 0xA32626, 0xA32727, 0xB14949,
    0xB24949, 0xBE6767, 0xBE6868, 0xC57878,
    0x7E7E80, 0x878789, 0x8C8C8C, 0x919092,
    0x929193, 0x939393, 0x969697, 0x979698,
    0x989799, 0x99989A, 0x9B9A9C, 0x9B9B9D,
    0x9C9C9D, 0x9C9C9E, 0x9E9D9F, 0x9E9EA0,
    0x9F9EA0, 0x9F9FA1, 0xA2A2A3, 0xA3A2A4,
    0xA4A3A5, 0xA5A4A6, 0xA9A9AA, 0xACACAD,
    0xB0B0B1, 0xB2B2B3, 0xB3B3B4, 0xB4B4B5,
    0xB9B9BA, 0xBCBBBD, 0xBDBDBE, 0xC98080,
    0xC98181, 0xDCAEAE, 0xDDAEAE, 0xE1B8B8,
    0xE1B9B9, 0xC0C0C1, 0xC4C3C5, 0xC6C6C7,
    0xC7C6C7, 0xC9C9CA, 0xCAC9CA, 0xCACACB,
    0xCBCBCC, 0xCCCCCD, 0xCDCDCE, 0xD1D1D1,
    0xD1D1D2, 0xD4D3D4, 0xD5D4D5, 0xDADADB,
    0xDBDBDB, 0xDDDCDD, 0xDEDEDF, 0xDFDFE0,
    0xE3E3E4, 0xE4E4E4, 0xE4E4E5, 0xE6E6E7,
    0xECECEC, 0xEDEDED, 0xF2E1E1, 0xF2E2E2,
    0xEFEFF0, 0xF1F1F1, 0xF3F2F3, 0xF8F7F8
#endif
};

static GUI_CONST_STORAGE GUI_LOGPALETTE PalSeggerLogo70x35 =
{
    256,  // Number of entries
    1,    // Has transparency
    &ColorsSeggerLogo70x35[0]
};

static GUI_CONST_STORAGE unsigned char acSeggerLogo70x35[] =
{
    0x86, 0x2F, 0x1A, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x1A, 0x86, 0x86,
    0x2E, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x2E,
    0x30, 0x02, 0x1D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x1D, 0x02, 0x30,
    0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02,
    0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02,
    0x02, 0x02, 0x07, 0x20, 0x4C, 0x51, 0x10, 0x01, 0x01, 0x01, 0x27, 0x4A, 0x7B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02,
    0x02, 0x02, 0x07, 0x10, 0x47, 0x03, 0x60, 0x01, 0x01, 0x01, 0x53, 0x03, 0x4E, 0x10, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02,
    0x02, 0x02, 0x07, 0x01, 0x70, 0x0D, 0x3E, 0xE0, 0x01, 0x01, 0x16, 0x46, 0x03, 0xDC, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02,
    0x02, 0x02, 0x07, 0x01, 0x01, 0x63, 0x03, 0x43, 0xFB, 0x01, 0x01, 0x71, 0x0D, 0x03, 0x66, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02,
    0x02, 0x02, 0x07, 0x01, 0x01, 0x19, 0x52, 0x03, 0x4D, 0x84, 0x01, 0x01, 0x1E, 0x03, 0x1C, 0x2B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02,
    0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x7C, 0x48, 0x03, 0x28, 0x01, 0x01, 0x01, 0x55, 0x03, 0x26, 0x81, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02,
    0x02, 0x02, 0x07, 0x22, 0x85, 0x01, 0x01, 0x72, 0x40, 0x03, 0x67, 0x01, 0x01, 0x82, 0x4B, 0x03, 0x54, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02,
    0x02, 0x02, 0x07, 0x09, 0x62, 0x01, 0x01, 0x01, 0x1E, 0x03, 0x42, 0x75, 0x01, 0x01, 0x2C, 0x41, 0x03, 0x64, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02,
    0x02, 0x02, 0x07, 0x09, 0x3F, 0x6E, 0x01, 0x01, 0x19, 0xB9, 0x03, 0xB8, 0x83, 0x01, 0x01, 0x68, 0x03, 0x0D, 0x6F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02,
    0x02, 0x02, 0x07, 0x09, 0x03, 0x45, 0x16, 0x01, 0x01, 0x80, 0x49, 0x03, 0xBB, 0x01, 0x01, 0x01, 0x5F, 0x03, 0x44, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
    0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x56, 0x73, 0x01, 0x07, 0x02, 0x02,
    0x02, 0x02, 0x07, 0x09, 0x03, 0x03, 0x50, 0x22, 0x01, 0x01, 0x74, 0xB5, 0x03, 0xDE, 0x01, 0x01, 0x20, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x57, 0x01, 0x07, 0x02, 0x02,
    0x02, 0x02, 0x07, 0x09, 0x03, 0x03, 0x03, 0x61, 0x01, 0x01, 0x01, 0x65, 0x03, 0x1C, 0x2C, 0x01, 0x01, 0x7F, 0x1F, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
    0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x1F, 0x7E, 0x01, 0x07, 0x02, 0x02,
    0x02, 0x02, 0x07, 0x09, 0x03, 0x03, 0x03, 0x0D, 0x16, 0x01, 0x01, 0x01, 0x26, 0x03, 0x28, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02,
    0x02, 0x02, 0x07, 0x09, 0x03, 0x03, 0x03, 0x61, 0x01, 0x01, 0x01, 0x65, 0x03, 0x1C, 0x2B, 0x01, 0x01, 0x7F, 0x1F, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
    0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x1F, 0x7E, 0x01, 0x07, 0x02, 0x02,
    0x02, 0x02, 0x07, 0x09, 0x03, 0x03, 0x50, 0x22, 0x01, 0x01, 0x74, 0xB6, 0x03, 0xDD, 0x01, 0x01, 0x20, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x57, 0x01, 0x07, 0x02, 0x02,
    0x02, 0x02, 0x07, 0x09, 0x03, 0x45, 0x16, 0x01, 0x01, 0x80, 0x49, 0x03, 0x27, 0x01, 0x01, 0x01, 0x5F, 0x03, 0x44, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
    0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x56, 0x73, 0x01, 0x07, 0x02, 0x02,
    0x02, 0x02, 0x07, 0x09, 0x3F, 0x6E, 0x01, 0x01, 0x19, 0xBA, 0x03, 0xB7, 0x83, 0x01, 0x01, 0x68, 0x03, 0x0D, 0x6F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02,
    0x02, 0x02, 0x07, 0x09, 0x62, 0x01, 0x01, 0x01, 0x1E, 0x03, 0x42, 0x75, 0x01, 0x01, 0x2C, 0x41, 0x03, 0x64, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02,
    0x02, 0x02, 0x07, 0x22, 0x85, 0x01, 0x01, 0x72, 0x40, 0x03, 0x67, 0x01, 0x01, 0x82, 0x4B, 0x03, 0x54, 0x19, 0x01, 0xF6, 0x58, 0xA5, 0xA6, 0xBD, 0x79, 0x01, 0x76, 0xB4, 0x0B, 0x0B, 0x0B, 0xB3, 0xEE, 0x01, 0x17, 0xC7, 0xA9, 0xA3, 0xAF, 0xE4, 0x01, 0x01,
    0x01, 0xF0, 0x3D, 0xA4, 0xA7, 0x5B, 0xF8, 0x01, 0x01, 0x5C, 0x0B, 0x0B, 0x0B, 0x0B, 0xCD, 0x01, 0xD6, 0xB2, 0x0B, 0x0B, 0xBC, 0xD3, 0x0A, 0x01, 0x01, 0x07, 0x02, 0x02,
    0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x7C, 0x48, 0x03, 0x28, 0x01, 0x01, 0x01, 0x55, 0x03, 0x26, 0x81, 0x01, 0x18, 0x35, 0x97, 0xD2, 0xCB, 0x8F, 0x9E, 0x01, 0xCE, 0x02, 0xAC, 0x13, 0x13, 0x29, 0x6D, 0x0E, 0xA1, 0x11, 0x29, 0xCA, 0x12, 0x0F, 0xDA, 0x01,
    0xE9, 0x24, 0x98, 0xC5, 0x5B, 0x33, 0x93, 0x0A, 0x0A, 0x0F, 0x99, 0x13, 0x13, 0x13, 0xD1, 0x01, 0x9D, 0x8B, 0x59, 0x59, 0xA8, 0x02, 0x2A, 0x01, 0x01, 0x07, 0x02, 0x02,
    0x02, 0x02, 0x07, 0x01, 0x01, 0x19, 0x52, 0x03, 0x4D, 0x84, 0x01, 0x01, 0x1E, 0x03, 0x1C, 0x2B, 0x01, 0x01, 0x0E, 0x88, 0xA2, 0xF1, 0x18, 0x77, 0x6B, 0x01, 0x15, 0x02, 0xEB, 0x0A, 0x0A, 0x18, 0x01, 0xD5, 0x02, 0xC9, 0x01, 0x01, 0x17, 0x2A, 0x77, 0x01,
    0x3A, 0x1B, 0x7A, 0x01, 0x01, 0x6C, 0xCC, 0x01, 0x21, 0x02, 0xB0, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x12, 0x36, 0x01, 0x01, 0x04, 0x02, 0xB1, 0x01, 0x01, 0x07, 0x02, 0x02,
    0x02, 0x02, 0x07, 0x01, 0x01, 0x63, 0x03, 0x43, 0xFA, 0x01, 0x01, 0x71, 0x0D, 0x03, 0x66, 0x01, 0x01, 0x01, 0x01, 0xC4, 0x1B, 0x02, 0x8E, 0xAB, 0xD9, 0x01, 0x15, 0x02, 0x02, 0x02, 0x02, 0x32, 0x7D, 0x14, 0x02, 0x6D, 0x01, 0xE6, 0x14, 0x14, 0xD4, 0x01,
    0x8C, 0x9F, 0x01, 0x01, 0x2A, 0x14, 0x5A, 0xF2, 0x21, 0x02, 0x02, 0x02, 0x02, 0x02, 0xD0, 0x01, 0x12, 0x1B, 0x3B, 0x3B, 0x39, 0x91, 0xED, 0x01, 0x01, 0x07, 0x02, 0x02,
    0x02, 0x02, 0x07, 0x01, 0x70, 0x0D, 0x3E, 0xDF, 0x01, 0x01, 0x16, 0x46, 0x03, 0xDB, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0xFF, 0xE7, 0xC2, 0x95, 0x0F, 0x6C, 0x15, 0x02, 0x5E, 0x08, 0x08, 0x0C, 0x01, 0xC3, 0x02, 0xE2, 0x01, 0xE1, 0x3C, 0x92, 0x38, 0x01,
    0x94, 0x35, 0x01, 0x01, 0x14, 0x25, 0x02, 0x5D, 0x21, 0x02, 0x25, 0x08, 0x08, 0x76, 0x0E, 0x01, 0x12, 0x8D, 0xC0, 0xBF, 0xA0, 0x89, 0xE8, 0x01, 0x01, 0x07, 0x02, 0x02,
    0x02, 0x02, 0x07, 0x10, 0x47, 0x03, 0x60, 0x01, 0x01, 0x01, 0x53, 0x03, 0x4E, 0x10, 0x01, 0x01, 0x01, 0x01, 0x18, 0x33, 0xAE, 0x0E, 0x01, 0x15, 0x02, 0xE3, 0x15, 0x02, 0x5E, 0x76, 0x76, 0x76, 0xFF, 0xF3, 0x11, 0x9C, 0xF7, 0x01, 0x6B, 0x1B, 0x38, 0x01,
    0x5A, 0x02, 0x5C, 0x0E, 0x17, 0x58, 0x02, 0x5D, 0x21, 0x02, 0x25, 0x76, 0x76, 0x76, 0x79, 0x01, 0x12, 0x36, 0x01, 0x01, 0x6A, 0x02, 0xC8, 0x01, 0x01, 0x07, 0x02, 0x02,
    0x02, 0x02, 0x07, 0x20, 0x4C, 0x51, 0x10, 0x01, 0x01, 0x01, 0x27, 0x4A, 0x7B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xC6, 0x24, 0x32, 0x90, 0x0F, 0xAD, 0x0A, 0xD7, 0x02, 0x02, 0x02, 0x02, 0x02, 0x3D, 0x01, 0xD8, 0x34, 0x0F, 0x31, 0x31, 0xAA, 0x39, 0x01,
    0x0E, 0x3C, 0x0F, 0x11, 0x8A, 0x9B, 0x96, 0xCF, 0x18, 0x34, 0x02, 0x02, 0x02, 0x02, 0x24, 0x17, 0x3A, 0x9A, 0x01, 0x01, 0x78, 0x23, 0x29, 0x01, 0x01, 0x07, 0x02, 0x02,
    0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xFE, 0xE5, 0x69, 0xF5, 0x01, 0x01, 0x01, 0xF9, 0x0C, 0x0C, 0x0C, 0x0C, 0x0E, 0x01, 0x01, 0x17, 0xEA, 0x6A, 0xFC, 0xFF, 0xEF, 0x01,
    0x01, 0x01, 0x78, 0x69, 0xEC, 0x0A, 0x08, 0xFD, 0x01, 0x2D, 0x0C, 0x0C, 0x0C, 0x0C, 0x04, 0x01, 0x07, 0x7A, 0x01, 0x01, 0x01, 0xF4, 0x2D, 0x01, 0x01, 0x07, 0x02, 0x02,
    0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02,
    0x11, 0x02, 0x1D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x1D, 0x02, 0x11,
    0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23,
    0x87, 0x2F, 0x1A, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x1A, 0x86, 0x86
};

GUI_CONST_STORAGE GUI_BITMAP bmSeggerLogo70x35 =
{
    70,                  // XSize
    35,                  // YSize
    70,                  // BytesPerLine
    8,                  // BitsPerPixel
    acSeggerLogo70x35,   // Pointer to picture data (indices)
    &PalSeggerLogo70x35  // Pointer to palette
};
#endif
static GUI_CONST_STORAGE GUI_COLOR _Colorsgrad_32x16[] =
{
#if (GUI_USE_ARGB)
    0xFF51A8A8, 0xFF58ACAC, 0xFF62B0B0, 0xFF6DB6B6,
    0xFF7ABDBD, 0xFF89C4C4, 0xFF97CBCB, 0xFFA5D2D2,
    0xFFB4D9D9, 0xFFC1E0E0, 0xFFCCE6E6, 0xFFD6EAEA
#else
    0xA8A851, 0xACAC58, 0xB0B062, 0xB6B66D,
    0xBDBD7A, 0xC4C489, 0xCBCB97, 0xD2D2A5,
    0xD9D9B4, 0xE0E0C1, 0xE6E6CC, 0xEAEAD6
#endif
};

static GUI_CONST_STORAGE GUI_LOGPALETTE _Palgrad_32x16 =
{
    12,  // Number of entries
    0,   // No transparency
    &_Colorsgrad_32x16[0]
};

static GUI_CONST_STORAGE unsigned char _acgrad_32x16[] =
{
    0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0B, 0x0A, 0x09, 0x08, 0x07, 0x06, 0x05, 0x04, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02,
    0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0B, 0x0A, 0x09, 0x08, 0x07, 0x06, 0x05, 0x04, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x03,
    0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0B, 0x0A, 0x09, 0x08, 0x07, 0x06, 0x05, 0x04, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x03, 0x04,
    0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0B, 0x0A, 0x09, 0x08, 0x07, 0x06, 0x05, 0x04, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05,
    0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0B, 0x0A, 0x09, 0x08, 0x07, 0x06, 0x05, 0x04, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06,
    0x08, 0x09, 0x0A, 0x0B, 0x0B, 0x0A, 0x09, 0x08, 0x07, 0x06, 0x05, 0x04, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
    0x09, 0x0A, 0x0B, 0x0B, 0x0A, 0x09, 0x08, 0x07, 0x06, 0x05, 0x04, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
    0x0A, 0x0B, 0x0B, 0x0A, 0x09, 0x08, 0x07, 0x06, 0x05, 0x04, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09,
    0x0B, 0x0B, 0x0A, 0x09, 0x08, 0x07, 0x06, 0x05, 0x04, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A,
    0x0B, 0x0A, 0x09, 0x08, 0x07, 0x06, 0x05, 0x04, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B
};

GUI_CONST_STORAGE GUI_BITMAP bmgrad_32x16 =
{
    32, // xSize
    10, // ySize
    32, // BytesPerLine
    8, // BitsPerPixel
    _acgrad_32x16,  // Pointer to picture data (indices)
    &_Palgrad_32x16   // Pointer to palette
};

#if (GUI_USE_ARGB)
static GUI_CONST_STORAGE unsigned long _acbutton_0[] =
{
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00319898, 0x03289494, 0x34379B9B, 0x8441A0A0, 0xBA45A2A2, 0xC347A3A3, 0xF750A7A7, 0xFF51A8A8, 0xFF51A8A8, 0xFF51A8A8, 0xFF51A8A8, 0xFF51A8A8, 0xFF51A8A8, 0xFF51A8A8, 0xFF51A8A8, 0xFF51A8A8, 0xFF51A8A8,
    0xFF51A8A8, 0xFF51A8A8, 0xFF51A8A8, 0xFF51A8A8, 0xFF51A8A8, 0xD34BA5A5, 0xBB45A2A2, 0x9E44A1A1, 0x4D3B9D9D, 0x0C319898, 0x00319898, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x0044A1A1, 0x283A9C9C, 0x9145A2A2, 0xE55DAEAE, 0xFE7EBEBE, 0xFF98CBCB, 0xFF99CCCC, 0xFF9ECFCF, 0xFF9FCFCF, 0xFF9FCFCF, 0xFF9FCFCF, 0xFF9FCFCF, 0xFF9FCFCF, 0xFF9FCFCF, 0xFF9FCFCF, 0xFF9FCFCF, 0xFF9FCFCF, 0xFF9FCFCF,
    0xFF9FCFCF, 0xFF9FCFCF, 0xFF9FCFCF, 0xFF9FCFCF, 0xFF9FCFCF, 0xFF9ACDCD, 0xFF98CBCB, 0xFF80BFBF, 0xF360B0B0, 0xB24BA5A5, 0x483F9F9F, 0x03299494, 0x00319898, 0x00000000, 0x00000000,
    0x00000000, 0x002C9696, 0x031F8F8F, 0x49389C9C, 0xCF55AAAA, 0xFF8BC5C5, 0xFFCCE5E5, 0xFFE7F3F3, 0xFFEEF6F6, 0xFFEFF6F6, 0xFFEFF7F7, 0xFFEFF7F7, 0xFFEFF7F7, 0xFFEFF7F7, 0xFFEFF7F7, 0xFFEFF7F7, 0xFFEFF7F7, 0xFFEFF7F7, 0xFFEFF7F7, 0xFFEFF7F7, 0xFFEFF7F7,
    0xFFEFF7F7, 0xFFEFF7F7, 0xFFEFF7F7, 0xFFEFF7F7, 0xFFEFF7F7, 0xFFEFF7F7, 0xFFEEF6F6, 0xFFE7F3F3, 0xFFCDE6E6, 0xFF8FC7C7, 0xEE5BADAD, 0x7442A1A1, 0x0F2B9595, 0x00309898, 0x00000000,
    0x00000000, 0x00409F9F, 0x4A399C9C, 0xEE5CADAD, 0xFFB4D9D9, 0xFFE7F3F3, 0xFFE6F2F2, 0xFFDEEEEE, 0xFFDBEDED, 0xFFDCEDED, 0xFFDDEEEE, 0xFFDDEEEE, 0xFFDDEEEE, 0xFFDDEEEE, 0xFFDDEEEE, 0xFFDDEEEE, 0xFFDDEEEE, 0xFFDDEEEE, 0xFFDDEEEE, 0xFFDDEEEE, 0xFFDDEEEE,
    0xFFDDEEEE, 0xFFDDEEEE, 0xFFDDEEEE, 0xFFDDEEEE, 0xFFDDEEEE, 0xFFDCEDED, 0xFFDBEDED, 0xFFDFEEEE, 0xFFE7F2F2, 0xFFE7F3F3, 0xFFB7DBDB, 0xFE65B2B2, 0x8B40A0A0, 0x020D8686, 0x00329898,
    0x003E9E9E, 0x27399C9C, 0xCE55AAAA, 0xFFB4D9D9, 0xFFEBF5F5, 0xFFDAECEC, 0xFFD1E8E8, 0xFFCDE5E5, 0xFFCEE6E6, 0xFFCFE6E6, 0xFFD1E7E7, 0xFFD1E7E7, 0xFFD1E7E7, 0xFFD1E7E7, 0xFFD1E7E7, 0xFFD1E7E7, 0xFFD1E7E7, 0xFFD1E7E7, 0xFFD1E7E7, 0xFFD1E7E7, 0xFFD1E7E7,
    0xFFD1E7E7, 0xFFD1E7E7, 0xFFD1E7E7, 0xFFD1E7E7, 0xFFD1E7E7, 0xFFCFE7E7, 0xFFCEE6E6, 0xFFCEE6E6, 0xFFD2E8E8, 0xFFDBEDED, 0xFFEBF5F5, 0xFFB8DCDC, 0xEF5EAEAE, 0x5B43A1A1, 0x0062B0B0,
    0x02006C6C, 0x9145A2A2, 0xFF8BC5C5, 0xFFE1F0F0, 0xFFD2E8E8, 0xFFC6E2E2, 0xFFC2E0E0, 0xFFC1DFDF, 0xFFC3E1E1, 0xFFC5E1E1, 0xFFC7E2E2, 0xFFC7E3E3, 0xFFC7E3E3, 0xFFC7E3E3, 0xFFC7E3E3, 0xFFC7E3E3, 0xFFC7E3E3, 0xFFC7E3E3, 0xFFC7E3E3, 0xFFC7E3E3, 0xFFC7E3E3,
    0xFFC7E3E3, 0xFFC7E3E3, 0xFFC7E3E3, 0xFFC7E3E3, 0xFFC7E3E3, 0xFFC5E2E2, 0xFFC4E1E1, 0xFFC2E0E0, 0xFFC4E1E1, 0xFFC8E3E3, 0xFFD4E9E9, 0xFFE3F1F1, 0xFF92C8C8, 0xCE50A7A7, 0x1D329898,
    0x35369B9B, 0xE35EAEAE, 0xFFC7E3E3, 0xFFCFE7E7, 0xFFB7DADA, 0xFFB2D8D8, 0xFFB4D9D9, 0xFFB8DBDB, 0xFFBDDDDD, 0xFFBEDEDE, 0xFFC1E0E0, 0xFFC1E0E0, 0xFFC1E0E0, 0xFFC1E0E0, 0xFFC1E0E0, 0xFFC1E0E0, 0xFFC1E0E0, 0xFFC1E0E0, 0xFFC1E0E0, 0xFFC1E0E0, 0xFFC1E0E0,
    0xFFC1E0E0, 0xFFC1E0E0, 0xFFC1E0E0, 0xFFC1E0E0, 0xFFC1E0E0, 0xFFBFDFDF, 0xFFBDDEDE, 0xFFBADCDC, 0xFFB6DADA, 0xFFB5D9D9, 0xFFBADCDC, 0xFFD1E8E8, 0xFFCAE4E4, 0xFB68B3B3, 0x7C42A1A1,
    0x8341A0A0, 0xFF7EBEBE, 0xFFC5E1E1, 0xFFA4D1D1, 0xFFA5D1D1, 0xFFAFD7D7, 0xFFB9DCDC, 0xFFC0DFDF, 0xFFC5E2E2, 0xFFC7E3E3, 0xFFCAE4E4, 0xFFCAE4E4, 0xFFCAE4E4, 0xFFCAE4E4, 0xFFCAE4E4, 0xFFCAE4E4, 0xFFCAE4E4, 0xFFCAE4E4, 0xFFCAE4E4, 0xFFCAE4E4, 0xFFCAE4E4,
    0xFFCAE4E4, 0xFFCAE4E4, 0xFFCAE4E4, 0xFFCAE4E4, 0xFFCAE4E4, 0xFFC8E3E3, 0xFFC6E2E2, 0xFFC2E0E0, 0xFFBBDDDD, 0xFFB3D8D8, 0xFFA9D3D3, 0xFFA9D3D3, 0xFFC8E3E3, 0xFF87C3C3, 0xD34CA5A5,
    0xBB47A3A3, 0xFF86C2C2, 0xFF9CCDCD, 0xFF9BCCCC, 0xFFABD4D4, 0xFFB7DBDB, 0xFFC1E0E0, 0xFFC9E4E4, 0xFFCFE7E7, 0xFFD2E8E8, 0xFFD4E9E9, 0xFFD4EAEA, 0xFFD4EAEA, 0xFFD4EAEA, 0xFFD4EAEA, 0xFFD4EAEA, 0xFFD4EAEA, 0xFFD4EAEA, 0xFFD4EAEA, 0xFFD4EAEA, 0xFFD4EAEA,
    0xFFD4EAEA, 0xFFD4EAEA, 0xFFD4EAEA, 0xFFD4EAEA, 0xFFD4EAEA, 0xFFD2E9E9, 0xFFD0E7E7, 0xFFCBE5E5, 0xFFC4E1E1, 0xFFBBDDDD, 0xFFAFD7D7, 0xFFA0CFCF, 0xFFA2D0D0, 0xFF90C7C7, 0xFF54A9A9,
    0xC34BA5A5, 0xFF77BBBB, 0xFF8EC6C6, 0xFFA1D0D0, 0xFFB1D7D7, 0xFFBEDEDE, 0xFFC8E3E3, 0xFFD1E8E8, 0xFFD8EBEB, 0xFFDBEDED, 0xFFDDEEEE, 0xFFDDEEEE, 0xFFDDEEEE, 0xFFDDEEEE, 0xFFDDEEEE, 0xFFDDEEEE, 0xFFDDEEEE, 0xFFDDEEEE, 0xFFDDEEEE, 0xFFDDEEEE, 0xFFDDEEEE,
    0xFFDDEEEE, 0xFFDDEEEE, 0xFFDDEEEE, 0xFFDDEEEE, 0xFFDDEEEE, 0xFFDCEDED, 0xFFD9ECEC, 0xFFD4E9E9, 0xFFCBE5E5, 0xFFC2E0E0, 0xFFB5DADA, 0xFFA7D2D2, 0xFF95CACA, 0xFF82C0C0, 0xFF56AAAA,
    0xF755AAAA, 0xFF82C0C0, 0xFF91C8C8, 0xFFA3D0D0, 0xFFB4D9D9, 0xFFC2E0E0, 0xFFCEE6E6, 0xFFD8ECEC, 0xFFDFEFEF, 0xFFE4F1F1, 0xFFE6F3F3, 0xFFE6F3F3, 0xFFE6F3F3, 0xFFE6F3F3, 0xFFE6F3F3, 0xFFE6F3F3, 0xFFE6F3F3, 0xFFE6F3F3, 0xFFE6F3F3, 0xFFE6F3F3, 0xFFE6F3F3,
    0xFFE6F3F3, 0xFFE6F3F3, 0xFFE6F3F3, 0xFFE6F3F3, 0xFFE6F3F3, 0xFFE5F2F2, 0xFFE1F0F0, 0xFFDBEDED, 0xFFD2E8E8, 0xFFC6E3E3, 0xFFB9DCDC, 0xFFA8D3D3, 0xFF95CACA, 0xFF85C2C2, 0xFF56AAAA,
    0xFF56AAAA, 0xFF7CBDBD, 0xFF95CACA, 0xFFA7D3D3, 0xFFB7DBDB, 0xFFC4E1E1, 0xFFD1E8E8, 0xFFDDEEEE, 0xFFE6F2F2, 0xFFECF5F5, 0xFFEFF7F7, 0xFFEFF7F7, 0xFFEFF7F7, 0xFFEFF7F7, 0xFFEFF7F7, 0xFFEFF7F7, 0xFFEFF7F7, 0xFFEFF7F7, 0xFFEFF7F7, 0xFFEFF7F7, 0xFFEFF7F7,
    0xFFEFF7F7, 0xFFEFF7F7, 0xFFEFF7F7, 0xFFEFF7F7, 0xFFEFF7F7, 0xFFEDF6F6, 0xFFE8F4F4, 0xFFE0EFEF, 0xFFD5EAEA, 0xFFC7E3E3, 0xFFB9DCDC, 0xFFA8D3D3, 0xFF95CACA, 0xFF7CBDBD, 0xFF55AAAA,
    0xD34FA7A7, 0xFF77BBBB, 0xFF94C9C9, 0xFFA8D3D3, 0xFFB9DCDC, 0xFFC7E3E3, 0xFFD4EAEA, 0xFFE0EFEF, 0xFFEAF5F5, 0xFFF3F8F8, 0xFFF7FBFB, 0xFFF7FBFB, 0xFFF7FBFB, 0xFFF7FBFB, 0xFFF7FBFB, 0xFFF7FBFB, 0xFFF7FBFB, 0xFFF7FBFB, 0xFFF7FBFB, 0xFFF7FBFB, 0xFFF7FBFB,
    0xFFF7FBFB, 0xFFF7FBFB, 0xFFF7FBFB, 0xFFF7FBFB, 0xFFF7FBFB, 0xFFF4F9F9, 0xFFECF6F6, 0xFFE1F0F0, 0xFFD5EAEA, 0xFFC7E3E3, 0xFFB9DCDC, 0xFFA8D3D3, 0xFF95CACA, 0xFF7CBDBD, 0xFF55AAAA,
    0xBB49A4A4, 0xFF70B8B8, 0xFF8FC6C6, 0xFFA4D1D1, 0xFFB7DBDB, 0xFFC7E3E3, 0xFFD5EAEA, 0xFFE1F0F0, 0xFFEDF6F6, 0xFFF7FBFB, 0xFFFBFDFD, 0xFFFBFDFD, 0xFFFBFDFD, 0xFFFBFDFD, 0xFFFBFDFD, 0xFFFBFDFD, 0xFFFBFDFD, 0xFFFBFDFD, 0xFFFBFDFD, 0xFFFBFDFD, 0xFFFBFDFD,
    0xFFFBFDFD, 0xFFFBFDFD, 0xFFFBFDFD, 0xFFFBFDFD, 0xFFFBFDFD, 0xFFF7FBFB, 0xFFEDF6F6, 0xFFE1F0F0, 0xFFD5EAEA, 0xFFC7E3E3, 0xFFB9DCDC, 0xFFA8D3D3, 0xFF95CACA, 0xFF7CBDBD, 0xFF55AAAA,
    0x8344A1A1, 0xFF68B3B3, 0xFF8AC4C4, 0xFFA1CFCF, 0xFFB3D9D9, 0xFFC3E1E1, 0xFFD2E8E8, 0xFFE0EFEF, 0xFFECF5F5, 0xFFF7FBFB, 0xFFFBFDFD, 0xFFFBFDFD, 0xFFFBFDFD, 0xFFFBFDFD, 0xFFFBFDFD, 0xFFFBFDFD, 0xFFFBFDFD, 0xFFFBFDFD, 0xFFFBFDFD, 0xFFFBFDFD, 0xFFFBFDFD,
    0xFFFBFDFD, 0xFFFBFDFD, 0xFFFBFDFD, 0xFFFBFDFD, 0xFFFBFDFD, 0xFFF7FBFB, 0xFFEDF6F6, 0xFFE1F0F0, 0xFFD5EAEA, 0xFFC7E3E3, 0xFFB8DBDB, 0xFFA7D2D2, 0xFF92C8C8, 0xFF75BABA, 0xD34EA7A7,
    0x35389B9B, 0xE35AADAD, 0xFF80BFBF, 0xFF99CCCC, 0xFFADD5D5, 0xFFBEDEDE, 0xFFCCE6E6, 0xFFDAEDED, 0xFFE6F3F3, 0xFFF1F8F8, 0xFFF7FBFB, 0xFFF7FBFB, 0xFFF7FBFB, 0xFFF7FBFB, 0xFFF7FBFB, 0xFFF7FBFB, 0xFFF7FBFB, 0xFFF7FBFB, 0xFFF7FBFB, 0xFFF7FBFB, 0xFFF7FBFB,
    0xFFF7FBFB, 0xFFF7FBFB, 0xFFF7FBFB, 0xFFF7FBFB, 0xFFF7FBFB, 0xFFF3F9F9, 0xFFEAF4F4, 0xFFDEEFEF, 0xFFD1E8E8, 0xFFC3E1E1, 0xFFB3D9D9, 0xFFA0CFCF, 0xFF89C4C4, 0xFB68B3B3, 0x7C43A1A1,
    0x02006969, 0x9149A4A4, 0xFF6DB6B6, 0xFF8EC6C6, 0xFFA2D0D0, 0xFFB4D9D9, 0xFFC3E1E1, 0xFFD0E8E8, 0xFFDBEDED, 0xFFE2F1F1, 0xFFE7F3F3, 0xFFE8F3F3, 0xFFE8F3F3, 0xFFE8F3F3, 0xFFE8F3F3, 0xFFE8F3F3, 0xFFE8F3F3, 0xFFE8F3F3, 0xFFE8F3F3, 0xFFE8F3F3, 0xFFE8F3F3,
    0xFFE8F3F3, 0xFFE8F3F3, 0xFFE8F3F3, 0xFFE8F3F3, 0xFFE8F3F3, 0xFFE4F2F2, 0xFFDEEFEF, 0xFFD4EAEA, 0xFFC8E3E3, 0xFFB9DCDC, 0xFFA9D3D3, 0xFF95CACA, 0xFF7ABCBC, 0xCE54A9A9, 0x1D319898,
    0x003E9E9E, 0x27399C9C, 0xCE56AAAA, 0xFF7ABCBC, 0xFF93C9C9, 0xFFA6D2D2, 0xFFB5DADA, 0xFFC2E0E0, 0xFFCBE5E5, 0xFFD0E8E8, 0xFFD5EAEA, 0xFFD6EAEA, 0xFFD6EAEA, 0xFFD6EAEA, 0xFFD6EAEA, 0xFFD6EAEA, 0xFFD6EAEA, 0xFFD6EAEA, 0xFFD6EAEA, 0xFFD6EAEA, 0xFFD6EAEA,
    0xFFD6EAEA, 0xFFD6EAEA, 0xFFD6EAEA, 0xFFD6EAEA, 0xFFD6EAEA, 0xFFD2E8E8, 0xFFCDE6E6, 0xFFC5E2E2, 0xFFBADCDC, 0xFFABD5D5, 0xFF99CCCC, 0xFF84C1C1, 0xEF62B0B0, 0x5B43A1A1, 0x0061B0B0,
    0x00000000, 0x0040A0A0, 0x4A3B9D9D, 0xEE56ABAB, 0xFF7BBDBD, 0xFF92C8C8, 0xFFA2D0D0, 0xFFAED6D6, 0xFFB7DBDB, 0xFFBBDDDD, 0xFFC1E0E0, 0xFFC2E0E0, 0xFFC1E0E0, 0xFFC1E0E0, 0xFFC1E0E0, 0xFFC1E0E0, 0xFFC1E0E0, 0xFFC1E0E0, 0xFFC1E0E0, 0xFFC1E0E0, 0xFFC1E0E0,
    0xFFC1E0E0, 0xFFC1E0E0, 0xFFC1E0E0, 0xFFC1E0E0, 0xFFC1E0E0, 0xFFBDDEDE, 0xFFB9DCDC, 0xFFB2D8D8, 0xFFA7D2D2, 0xFF98CBCB, 0xFF84C1C1, 0xFE63B1B1, 0x8B42A0A0, 0x02078383, 0x00329898,
    0x00000000, 0x002C9696, 0x031B8D8D, 0x493B9D9D, 0xCF57ABAB, 0xFF71B8B8, 0xFF87C3C3, 0xFF95CACA, 0xFF9FCFCF, 0xFFA1D0D0, 0xFFA8D3D3, 0xFFAAD4D4, 0xFFA9D4D4, 0xFFA9D4D4, 0xFFA9D4D4, 0xFFA9D4D4, 0xFFA9D4D4, 0xFFA9D4D4, 0xFFA9D4D4, 0xFFA9D4D4, 0xFFA9D4D4,
    0xFFA9D4D4, 0xFFA9D4D4, 0xFFA9D4D4, 0xFFA9D4D4, 0xFFA9D4D4, 0xFFA4D1D1, 0xFFA0CFCF, 0xFF99CCCC, 0xFF8DC6C6, 0xFF79BCBC, 0xEE60AFAF, 0x7445A2A2, 0x0F2A9494, 0x00309797, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x0045A2A2, 0x283A9C9C, 0x914AA4A4, 0xE55DAEAE, 0xFE6EB6B6, 0xFF7ABDBD, 0xFF7DBEBE, 0xFF89C4C4, 0xFF8BC5C5, 0xFF8BC5C5, 0xFF8BC5C5, 0xFF8BC5C5, 0xFF8BC5C5, 0xFF8BC5C5, 0xFF8BC5C5, 0xFF8BC5C5, 0xFF8BC5C5, 0xFF8BC5C5,
    0xFF8BC5C5, 0xFF8BC5C5, 0xFF8BC5C5, 0xFF8BC5C5, 0xFF8BC5C5, 0xFF81C0C0, 0xFF7BBDBD, 0xFF73B9B9, 0xF363B1B1, 0xB250A7A7, 0x483F9F9F, 0x03279393, 0x00309797, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x002F9797, 0x03239191, 0x34389C9C, 0x8444A1A1, 0xBA4BA5A5, 0xC34EA6A6, 0xF759ACAC, 0xFF5AACAC, 0xFF5AACAC, 0xFF5AACAC, 0xFF5AACAC, 0xFF5AACAC, 0xFF5AACAC, 0xFF5AACAC, 0xFF5AACAC, 0xFF5AACAC, 0xFF5AACAC,
    0xFF5AACAC, 0xFF5AACAC, 0xFF5AACAC, 0xFF5AACAC, 0xFF5AACAC, 0xD352A8A8, 0xBB4BA5A5, 0x9E48A3A3, 0x4D3C9D9D, 0x0C2F9797, 0x002E9797, 0x00000000, 0x00000000, 0x00000000, 0x00000000
};

GUI_CONST_STORAGE GUI_BITMAP bmbutton_0 =
{
    36, // xSize
    22, // ySize
    144, // BytesPerLine
    32, // BitsPerPixel
    (unsigned char *)_acbutton_0,  // Pointer to picture data
    NULL,  // Pointer to palette
    GUI_DRAW_BMPM8888I
};
#else
static GUI_CONST_STORAGE unsigned long _acbutton_0[] =
{
    0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF989831, 0xFC949428, 0xCB9B9B37, 0x7BA0A041, 0x45A2A245, 0x3CA3A347, 0x08A7A750, 0x00A8A851, 0x00A8A851, 0x00A8A851, 0x00A8A851, 0x00A8A851, 0x00A8A851, 0x00A8A851, 0x00A8A851, 0x00A8A851, 0x00A8A851,
    0x00A8A851, 0x00A8A851, 0x00A8A851, 0x00A8A851, 0x00A8A851, 0x2CA5A54B, 0x44A2A245, 0x61A1A144, 0xB29D9D3B, 0xF3989831, 0xFF989831, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
    0xFF000000, 0xFF000000, 0xFF000000, 0xFFA1A144, 0xD79C9C3A, 0x6EA2A245, 0x1AAEAE5D, 0x01BEBE7E, 0x00CBCB98, 0x00CCCC99, 0x00CFCF9E, 0x00CFCF9F, 0x00CFCF9F, 0x00CFCF9F, 0x00CFCF9F, 0x00CFCF9F, 0x00CFCF9F, 0x00CFCF9F, 0x00CFCF9F, 0x00CFCF9F, 0x00CFCF9F,
    0x00CFCF9F, 0x00CFCF9F, 0x00CFCF9F, 0x00CFCF9F, 0x00CFCF9F, 0x00CDCD9A, 0x00CBCB98, 0x00BFBF80, 0x0CB0B060, 0x4DA5A54B, 0xB79F9F3F, 0xFC949429, 0xFF989831, 0xFF000000, 0xFF000000,
    0xFF000000, 0xFF96962C, 0xFC8F8F1F, 0xB69C9C38, 0x30AAAA55, 0x00C5C58B, 0x00E5E5CC, 0x00F3F3E7, 0x00F6F6EE, 0x00F6F6EF, 0x00F7F7EF, 0x00F7F7EF, 0x00F7F7EF, 0x00F7F7EF, 0x00F7F7EF, 0x00F7F7EF, 0x00F7F7EF, 0x00F7F7EF, 0x00F7F7EF, 0x00F7F7EF, 0x00F7F7EF,
    0x00F7F7EF, 0x00F7F7EF, 0x00F7F7EF, 0x00F7F7EF, 0x00F7F7EF, 0x00F7F7EF, 0x00F6F6EE, 0x00F3F3E7, 0x00E6E6CD, 0x00C7C78F, 0x11ADAD5B, 0x8BA1A142, 0xF095952B, 0xFF989830, 0xFF000000,
    0xFF000000, 0xFF9F9F40, 0xB59C9C39, 0x11ADAD5C, 0x00D9D9B4, 0x00F3F3E7, 0x00F2F2E6, 0x00EEEEDE, 0x00EDEDDB, 0x00EDEDDC, 0x00EEEEDD, 0x00EEEEDD, 0x00EEEEDD, 0x00EEEEDD, 0x00EEEEDD, 0x00EEEEDD, 0x00EEEEDD, 0x00EEEEDD, 0x00EEEEDD, 0x00EEEEDD, 0x00EEEEDD,
    0x00EEEEDD, 0x00EEEEDD, 0x00EEEEDD, 0x00EEEEDD, 0x00EEEEDD, 0x00EDEDDC, 0x00EDEDDB, 0x00EEEEDF, 0x00F2F2E7, 0x00F3F3E7, 0x00DBDBB7, 0x01B2B265, 0x74A0A040, 0xFD86860D, 0xFF989832,
    0xFF9E9E3E, 0xD89C9C39, 0x31AAAA55, 0x00D9D9B4, 0x00F5F5EB, 0x00ECECDA, 0x00E8E8D1, 0x00E5E5CD, 0x00E6E6CE, 0x00E6E6CF, 0x00E7E7D1, 0x00E7E7D1, 0x00E7E7D1, 0x00E7E7D1, 0x00E7E7D1, 0x00E7E7D1, 0x00E7E7D1, 0x00E7E7D1, 0x00E7E7D1, 0x00E7E7D1, 0x00E7E7D1,
    0x00E7E7D1, 0x00E7E7D1, 0x00E7E7D1, 0x00E7E7D1, 0x00E7E7D1, 0x00E7E7CF, 0x00E6E6CE, 0x00E6E6CE, 0x00E8E8D2, 0x00EDEDDB, 0x00F5F5EB, 0x00DCDCB8, 0x10AEAE5E, 0xA4A1A143, 0xFFB0B062,
    0xFD6C6C00, 0x6EA2A245, 0x00C5C58B, 0x00F0F0E1, 0x00E8E8D2, 0x00E2E2C6, 0x00E0E0C2, 0x00DFDFC1, 0x00E1E1C3, 0x00E1E1C5, 0x00E2E2C7, 0x00E3E3C7, 0x00E3E3C7, 0x00E3E3C7, 0x00E3E3C7, 0x00E3E3C7, 0x00E3E3C7, 0x00E3E3C7, 0x00E3E3C7, 0x00E3E3C7, 0x00E3E3C7,
    0x00E3E3C7, 0x00E3E3C7, 0x00E3E3C7, 0x00E3E3C7, 0x00E3E3C7, 0x00E2E2C5, 0x00E1E1C4, 0x00E0E0C2, 0x00E1E1C4, 0x00E3E3C8, 0x00E9E9D4, 0x00F1F1E3, 0x00C8C892, 0x31A7A750, 0xE2989832,
    0xCA9B9B36, 0x1CAEAE5E, 0x00E3E3C7, 0x00E7E7CF, 0x00DADAB7, 0x00D8D8B2, 0x00D9D9B4, 0x00DBDBB8, 0x00DDDDBD, 0x00DEDEBE, 0x00E0E0C1, 0x00E0E0C1, 0x00E0E0C1, 0x00E0E0C1, 0x00E0E0C1, 0x00E0E0C1, 0x00E0E0C1, 0x00E0E0C1, 0x00E0E0C1, 0x00E0E0C1, 0x00E0E0C1,
    0x00E0E0C1, 0x00E0E0C1, 0x00E0E0C1, 0x00E0E0C1, 0x00E0E0C1, 0x00DFDFBF, 0x00DEDEBD, 0x00DCDCBA, 0x00DADAB6, 0x00D9D9B5, 0x00DCDCBA, 0x00E8E8D1, 0x00E4E4CA, 0x04B3B368, 0x83A1A142,
    0x7CA0A041, 0x00BEBE7E, 0x00E1E1C5, 0x00D1D1A4, 0x00D1D1A5, 0x00D7D7AF, 0x00DCDCB9, 0x00DFDFC0, 0x00E2E2C5, 0x00E3E3C7, 0x00E4E4CA, 0x00E4E4CA, 0x00E4E4CA, 0x00E4E4CA, 0x00E4E4CA, 0x00E4E4CA, 0x00E4E4CA, 0x00E4E4CA, 0x00E4E4CA, 0x00E4E4CA, 0x00E4E4CA,
    0x00E4E4CA, 0x00E4E4CA, 0x00E4E4CA, 0x00E4E4CA, 0x00E4E4CA, 0x00E3E3C8, 0x00E2E2C6, 0x00E0E0C2, 0x00DDDDBB, 0x00D8D8B3, 0x00D3D3A9, 0x00D3D3A9, 0x00E3E3C8, 0x00C3C387, 0x2CA5A54C,
    0x44A3A347, 0x00C2C286, 0x00CDCD9C, 0x00CCCC9B, 0x00D4D4AB, 0x00DBDBB7, 0x00E0E0C1, 0x00E4E4C9, 0x00E7E7CF, 0x00E8E8D2, 0x00E9E9D4, 0x00EAEAD4, 0x00EAEAD4, 0x00EAEAD4, 0x00EAEAD4, 0x00EAEAD4, 0x00EAEAD4, 0x00EAEAD4, 0x00EAEAD4, 0x00EAEAD4, 0x00EAEAD4,
    0x00EAEAD4, 0x00EAEAD4, 0x00EAEAD4, 0x00EAEAD4, 0x00EAEAD4, 0x00E9E9D2, 0x00E7E7D0, 0x00E5E5CB, 0x00E1E1C4, 0x00DDDDBB, 0x00D7D7AF, 0x00CFCFA0, 0x00D0D0A2, 0x00C7C790, 0x00A9A954,
    0x3CA5A54B, 0x00BBBB77, 0x00C6C68E, 0x00D0D0A1, 0x00D7D7B1, 0x00DEDEBE, 0x00E3E3C8, 0x00E8E8D1, 0x00EBEBD8, 0x00EDEDDB, 0x00EEEEDD, 0x00EEEEDD, 0x00EEEEDD, 0x00EEEEDD, 0x00EEEEDD, 0x00EEEEDD, 0x00EEEEDD, 0x00EEEEDD, 0x00EEEEDD, 0x00EEEEDD, 0x00EEEEDD,
    0x00EEEEDD, 0x00EEEEDD, 0x00EEEEDD, 0x00EEEEDD, 0x00EEEEDD, 0x00EDEDDC, 0x00ECECD9, 0x00E9E9D4, 0x00E5E5CB, 0x00E0E0C2, 0x00DADAB5, 0x00D2D2A7, 0x00CACA95, 0x00C0C082, 0x00AAAA56,
    0x08AAAA55, 0x00C0C082, 0x00C8C891, 0x00D0D0A3, 0x00D9D9B4, 0x00E0E0C2, 0x00E6E6CE, 0x00ECECD8, 0x00EFEFDF, 0x00F1F1E4, 0x00F3F3E6, 0x00F3F3E6, 0x00F3F3E6, 0x00F3F3E6, 0x00F3F3E6, 0x00F3F3E6, 0x00F3F3E6, 0x00F3F3E6, 0x00F3F3E6, 0x00F3F3E6, 0x00F3F3E6,
    0x00F3F3E6, 0x00F3F3E6, 0x00F3F3E6, 0x00F3F3E6, 0x00F3F3E6, 0x00F2F2E5, 0x00F0F0E1, 0x00EDEDDB, 0x00E8E8D2, 0x00E3E3C6, 0x00DCDCB9, 0x00D3D3A8, 0x00CACA95, 0x00C2C285, 0x00AAAA56,
    0x00AAAA56, 0x00BDBD7C, 0x00CACA95, 0x00D3D3A7, 0x00DBDBB7, 0x00E1E1C4, 0x00E8E8D1, 0x00EEEEDD, 0x00F2F2E6, 0x00F5F5EC, 0x00F7F7EF, 0x00F7F7EF, 0x00F7F7EF, 0x00F7F7EF, 0x00F7F7EF, 0x00F7F7EF, 0x00F7F7EF, 0x00F7F7EF, 0x00F7F7EF, 0x00F7F7EF, 0x00F7F7EF,
    0x00F7F7EF, 0x00F7F7EF, 0x00F7F7EF, 0x00F7F7EF, 0x00F7F7EF, 0x00F6F6ED, 0x00F4F4E8, 0x00EFEFE0, 0x00EAEAD5, 0x00E3E3C7, 0x00DCDCB9, 0x00D3D3A8, 0x00CACA95, 0x00BDBD7C, 0x00AAAA55,
    0x2CA7A74F, 0x00BBBB77, 0x00C9C994, 0x00D3D3A8, 0x00DCDCB9, 0x00E3E3C7, 0x00EAEAD4, 0x00EFEFE0, 0x00F5F5EA, 0x00F8F8F3, 0x00FBFBF7, 0x00FBFBF7, 0x00FBFBF7, 0x00FBFBF7, 0x00FBFBF7, 0x00FBFBF7, 0x00FBFBF7, 0x00FBFBF7, 0x00FBFBF7, 0x00FBFBF7, 0x00FBFBF7,
    0x00FBFBF7, 0x00FBFBF7, 0x00FBFBF7, 0x00FBFBF7, 0x00FBFBF7, 0x00F9F9F4, 0x00F6F6EC, 0x00F0F0E1, 0x00EAEAD5, 0x00E3E3C7, 0x00DCDCB9, 0x00D3D3A8, 0x00CACA95, 0x00BDBD7C, 0x00AAAA55,
    0x44A4A449, 0x00B8B870, 0x00C6C68F, 0x00D1D1A4, 0x00DBDBB7, 0x00E3E3C7, 0x00EAEAD5, 0x00F0F0E1, 0x00F6F6ED, 0x00FBFBF7, 0x00FDFDFB, 0x00FDFDFB, 0x00FDFDFB, 0x00FDFDFB, 0x00FDFDFB, 0x00FDFDFB, 0x00FDFDFB, 0x00FDFDFB, 0x00FDFDFB, 0x00FDFDFB, 0x00FDFDFB,
    0x00FDFDFB, 0x00FDFDFB, 0x00FDFDFB, 0x00FDFDFB, 0x00FDFDFB, 0x00FBFBF7, 0x00F6F6ED, 0x00F0F0E1, 0x00EAEAD5, 0x00E3E3C7, 0x00DCDCB9, 0x00D3D3A8, 0x00CACA95, 0x00BDBD7C, 0x00AAAA55,
    0x7CA1A144, 0x00B3B368, 0x00C4C48A, 0x00CFCFA1, 0x00D9D9B3, 0x00E1E1C3, 0x00E8E8D2, 0x00EFEFE0, 0x00F5F5EC, 0x00FBFBF7, 0x00FDFDFB, 0x00FDFDFB, 0x00FDFDFB, 0x00FDFDFB, 0x00FDFDFB, 0x00FDFDFB, 0x00FDFDFB, 0x00FDFDFB, 0x00FDFDFB, 0x00FDFDFB, 0x00FDFDFB,
    0x00FDFDFB, 0x00FDFDFB, 0x00FDFDFB, 0x00FDFDFB, 0x00FDFDFB, 0x00FBFBF7, 0x00F6F6ED, 0x00F0F0E1, 0x00EAEAD5, 0x00E3E3C7, 0x00DBDBB8, 0x00D2D2A7, 0x00C8C892, 0x00BABA75, 0x2CA7A74E,
    0xCA9B9B38, 0x1CADAD5A, 0x00BFBF80, 0x00CCCC99, 0x00D5D5AD, 0x00DEDEBE, 0x00E6E6CC, 0x00EDEDDA, 0x00F3F3E6, 0x00F8F8F1, 0x00FBFBF7, 0x00FBFBF7, 0x00FBFBF7, 0x00FBFBF7, 0x00FBFBF7, 0x00FBFBF7, 0x00FBFBF7, 0x00FBFBF7, 0x00FBFBF7, 0x00FBFBF7, 0x00FBFBF7,
    0x00FBFBF7, 0x00FBFBF7, 0x00FBFBF7, 0x00FBFBF7, 0x00FBFBF7, 0x00F9F9F3, 0x00F4F4EA, 0x00EFEFDE, 0x00E8E8D1, 0x00E1E1C3, 0x00D9D9B3, 0x00CFCFA0, 0x00C4C489, 0x04B3B368, 0x83A1A143,
    0xFD696900, 0x6EA4A449, 0x00B6B66D, 0x00C6C68E, 0x00D0D0A2, 0x00D9D9B4, 0x00E1E1C3, 0x00E8E8D0, 0x00EDEDDB, 0x00F1F1E2, 0x00F3F3E7, 0x00F3F3E8, 0x00F3F3E8, 0x00F3F3E8, 0x00F3F3E8, 0x00F3F3E8, 0x00F3F3E8, 0x00F3F3E8, 0x00F3F3E8, 0x00F3F3E8, 0x00F3F3E8,
    0x00F3F3E8, 0x00F3F3E8, 0x00F3F3E8, 0x00F3F3E8, 0x00F3F3E8, 0x00F2F2E4, 0x00EFEFDE, 0x00EAEAD4, 0x00E3E3C8, 0x00DCDCB9, 0x00D3D3A9, 0x00CACA95, 0x00BCBC7A, 0x31A9A954, 0xE2989831,
    0xFF9E9E3E, 0xD89C9C39, 0x31AAAA56, 0x00BCBC7A, 0x00C9C993, 0x00D2D2A6, 0x00DADAB5, 0x00E0E0C2, 0x00E5E5CB, 0x00E8E8D0, 0x00EAEAD5, 0x00EAEAD6, 0x00EAEAD6, 0x00EAEAD6, 0x00EAEAD6, 0x00EAEAD6, 0x00EAEAD6, 0x00EAEAD6, 0x00EAEAD6, 0x00EAEAD6, 0x00EAEAD6,
    0x00EAEAD6, 0x00EAEAD6, 0x00EAEAD6, 0x00EAEAD6, 0x00EAEAD6, 0x00E8E8D2, 0x00E6E6CD, 0x00E2E2C5, 0x00DCDCBA, 0x00D5D5AB, 0x00CCCC99, 0x00C1C184, 0x10B0B062, 0xA4A1A143, 0xFFB0B061,
    0xFF000000, 0xFFA0A040, 0xB59D9D3B, 0x11ABAB56, 0x00BDBD7B, 0x00C8C892, 0x00D0D0A2, 0x00D6D6AE, 0x00DBDBB7, 0x00DDDDBB, 0x00E0E0C1, 0x00E0E0C2, 0x00E0E0C1, 0x00E0E0C1, 0x00E0E0C1, 0x00E0E0C1, 0x00E0E0C1, 0x00E0E0C1, 0x00E0E0C1, 0x00E0E0C1, 0x00E0E0C1,
    0x00E0E0C1, 0x00E0E0C1, 0x00E0E0C1, 0x00E0E0C1, 0x00E0E0C1, 0x00DEDEBD, 0x00DCDCB9, 0x00D8D8B2, 0x00D2D2A7, 0x00CBCB98, 0x00C1C184, 0x01B1B163, 0x74A0A042, 0xFD838307, 0xFF989832,
    0xFF000000, 0xFF96962C, 0xFC8D8D1B, 0xB69D9D3B, 0x30ABAB57, 0x00B8B871, 0x00C3C387, 0x00CACA95, 0x00CFCF9F, 0x00D0D0A1, 0x00D3D3A8, 0x00D4D4AA, 0x00D4D4A9, 0x00D4D4A9, 0x00D4D4A9, 0x00D4D4A9, 0x00D4D4A9, 0x00D4D4A9, 0x00D4D4A9, 0x00D4D4A9, 0x00D4D4A9,
    0x00D4D4A9, 0x00D4D4A9, 0x00D4D4A9, 0x00D4D4A9, 0x00D4D4A9, 0x00D1D1A4, 0x00CFCFA0, 0x00CCCC99, 0x00C6C68D, 0x00BCBC79, 0x11AFAF60, 0x8BA2A245, 0xF094942A, 0xFF979730, 0xFF000000,
    0xFF000000, 0xFF000000, 0xFF000000, 0xFFA2A245, 0xD79C9C3A, 0x6EA4A44A, 0x1AAEAE5D, 0x01B6B66E, 0x00BDBD7A, 0x00BEBE7D, 0x00C4C489, 0x00C5C58B, 0x00C5C58B, 0x00C5C58B, 0x00C5C58B, 0x00C5C58B, 0x00C5C58B, 0x00C5C58B, 0x00C5C58B, 0x00C5C58B, 0x00C5C58B,
    0x00C5C58B, 0x00C5C58B, 0x00C5C58B, 0x00C5C58B, 0x00C5C58B, 0x00C0C081, 0x00BDBD7B, 0x00B9B973, 0x0CB1B163, 0x4DA7A750, 0xB79F9F3F, 0xFC939327, 0xFF979730, 0xFF000000, 0xFF000000,
    0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF97972F, 0xFC919123, 0xCB9C9C38, 0x7BA1A144, 0x45A5A54B, 0x3CA6A64E, 0x08ACAC59, 0x00ACAC5A, 0x00ACAC5A, 0x00ACAC5A, 0x00ACAC5A, 0x00ACAC5A, 0x00ACAC5A, 0x00ACAC5A, 0x00ACAC5A, 0x00ACAC5A, 0x00ACAC5A,
    0x00ACAC5A, 0x00ACAC5A, 0x00ACAC5A, 0x00ACAC5A, 0x00ACAC5A, 0x2CA8A852, 0x44A5A54B, 0x61A3A348, 0xB29D9D3C, 0xF397972F, 0xFF97972E, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000
};

GUI_CONST_STORAGE GUI_BITMAP bmbutton_0 =
{
    36, // xSize
    22, // ySize
    144, // BytesPerLine
    32, // BitsPerPixel
    (unsigned char *)_acbutton_0,  // Pointer to picture data
    NULL,  // Pointer to palette
    GUI_DRAW_BMP8888
};
#endif

#if (GUI_USE_ARGB)
static GUI_CONST_STORAGE unsigned long _acbutton_1[] =
{
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00339999, 0x05349999, 0x3E329898, 0x912F9797, 0xC72E9797, 0xD52F9797, 0xF92F9797, 0xFF2F9797, 0xFF2F9797, 0xFF2F9797, 0xFF2F9797, 0xFF2F9797, 0xFF2F9797, 0xFF2F9797, 0xFF2F9797, 0xFF2F9797, 0xFF2F9797,
    0xFF2F9797, 0xFF2F9797, 0xFF2F9797, 0xFF2F9797, 0xFF2F9797, 0xDC2F9797, 0xCD2E9797, 0xA2309797, 0x55329999, 0x0C339999, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00000000, 0x00000000, 0x00339999, 0x01359A9A, 0x31339999, 0x992F9797, 0xE9369A9A, 0xFF52A8A8, 0xFF6BB5B5, 0xFF6BB5B5, 0xFF6BB5B5, 0xFF6CB5B5, 0xFF6CB5B5, 0xFF6CB5B5, 0xFF6CB5B5, 0xFF6CB5B5, 0xFF6CB5B5, 0xFF6CB5B5, 0xFF6CB5B5, 0xFF6CB5B5, 0xFF6CB5B5,
    0xFF6CB5B5, 0xFF6CB5B5, 0xFF6CB5B5, 0xFF6CB5B5, 0xFF6CB5B5, 0xFF6BB5B5, 0xFF6BB5B5, 0xFF52A8A8, 0xF3369A9A, 0xB2309797, 0x49339999, 0x05339999, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00000000, 0x00339999, 0x03349A9A, 0x65329898, 0xE3329999, 0xFF59ACAC, 0xFFA7D3D3, 0xFFD6EAEA, 0xFFDFEFEF, 0xFFDFEFEF, 0xFFDFEFEF, 0xFFDFEFEF, 0xFFDFEFEF, 0xFFDFEFEF, 0xFFDFEFEF, 0xFFDFEFEF, 0xFFDFEFEF, 0xFFDFEFEF, 0xFFDFEFEF, 0xFFDFEFEF, 0xFFDFEFEF,
    0xFFDFEFEF, 0xFFDFEFEF, 0xFFDFEFEF, 0xFFDFEFEF, 0xFFDFEFEF, 0xFFDFEFEF, 0xFFDFEFEF, 0xFFD6EAEA, 0xFFA7D3D3, 0xFF59ACAC, 0xF1329999, 0x8B329999, 0x0F339999, 0x00FFFFFF, 0x00FFFFFF,
    0x00339999, 0x002C9595, 0x65329898, 0xF1359A9A, 0xFF80BFBF, 0xFFD3E9E9, 0xFFD5EAEA, 0xFFC3E1E1, 0xFFB9DCDC, 0xFFB9DBDB, 0xFFB9DBDB, 0xFFB9DBDB, 0xFFB9DBDB, 0xFFB9DBDB, 0xFFB9DBDB, 0xFFB9DBDB, 0xFFB9DBDB, 0xFFB9DBDB, 0xFFB9DBDB, 0xFFB9DBDB, 0xFFB9DBDB,
    0xFFB9DBDB, 0xFFB9DBDB, 0xFFB9DBDB, 0xFFB9DBDB, 0xFFB9DBDB, 0xFFB9DBDB, 0xFFB9DCDC, 0xFFC3E1E1, 0xFFD5EAEA, 0xFFD3E9E9, 0xFF80BFBF, 0xFC359A9A, 0x92329999, 0x09339999, 0x00FFFFFF,
    0x00339999, 0x32339999, 0xE1329999, 0xFF7FBFBF, 0xFFD5EAEA, 0xFFBEDEDE, 0xFFA5D2D2, 0xFF95CACA, 0xFF8EC6C6, 0xFF8EC6C6, 0xFF8EC6C6, 0xFF8EC6C6, 0xFF8EC6C6, 0xFF8EC6C6, 0xFF8EC6C6, 0xFF8EC6C6, 0xFF8EC6C6, 0xFF8EC6C6, 0xFF8EC6C6, 0xFF8EC6C6, 0xFF8EC6C6,
    0xFF8EC6C6, 0xFF8EC6C6, 0xFF8EC6C6, 0xFF8EC6C6, 0xFF8EC6C6, 0xFF8EC6C6, 0xFF8EC6C6, 0xFF95CACA, 0xFFA5D2D2, 0xFFBEDEDE, 0xFFD5EAEA, 0xFF80BFBF, 0xF7329999, 0x5D339999, 0x00FFFFFF,
    0x04349999, 0x982F9797, 0xFF59ACAC, 0xFFCBE5E5, 0xFFAED6D6, 0xFF89C3C3, 0xFF70B7B7, 0xFF60AFAF, 0xFF5BADAD, 0xFF5BADAD, 0xFF5BADAD, 0xFF5BADAD, 0xFF5BADAD, 0xFF5BADAD, 0xFF5BADAD, 0xFF5BADAD, 0xFF5BADAD, 0xFF5BADAD, 0xFF5BADAD, 0xFF5BADAD, 0xFF5BADAD,
    0xFF5BADAD, 0xFF5BADAD, 0xFF5BADAD, 0xFF5BADAD, 0xFF5BADAD, 0xFF5BADAD, 0xFF5BADAD, 0xFF60AFAF, 0xFF70B7B7, 0xFF89C3C3, 0xFFAED6D6, 0xFFCBE5E5, 0xFF59ACAC, 0xC7309898, 0x18339999,
    0x3E329898, 0xE8369B9B, 0xFFA0CFCF, 0xFFA8D3D3, 0xFF65B2B2, 0xFF46A2A2, 0xFF399C9C, 0xFF349A9A, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999,
    0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF349A9A, 0xFF399C9C, 0xFF46A2A2, 0xFF65B2B2, 0xFFA8D3D3, 0xFFA0D0D0, 0xFA369A9A, 0x73329999,
    0x912F9797, 0xFF52A9A9, 0xFFA1D0D0, 0xFF4EA6A6, 0xFF339999, 0xFF329898, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999,
    0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF329898, 0xFF339999, 0xFF4EA6A6, 0xFFA2D0D0, 0xFF52A9A9, 0xCD309898,
    0xC7309898, 0xFF55AAAA, 0xFF56ABAB, 0xFF319898, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999,
    0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF319898, 0xFF56ABAB, 0xFF55AAAA, 0xF9319898,
    0xD4339999, 0xFF399C9C, 0xFF349A9A, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999,
    0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF349A9A, 0xFF3A9C9C, 0xFF339999,
    0xF9339999, 0xFF3A9D9D, 0xFF349A9A, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999,
    0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF349A9A, 0xFF3A9D9D, 0xFF339999,
    0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999,
    0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999,
    0xDC339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999,
    0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999,
    0xC7339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999,
    0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xF9339999,
    0x91339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999,
    0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xCD339999,
    0x3E339999, 0xE8339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999,
    0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFA339999, 0x73339999,
    0x04339999, 0x98339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999,
    0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xC7339999, 0x18339999,
    0x00FFFFFF, 0x32339999, 0xE1339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999,
    0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xF7339999, 0x5D339999, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x65339999, 0xF1339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999,
    0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFC339999, 0x92339999, 0x09339999, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x03339999, 0x65339999, 0xE3339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999,
    0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xF1339999, 0x8B339999, 0x0F339999, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x01339999, 0x31339999, 0x99339999, 0xE9339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999,
    0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xF3339999, 0xB2339999, 0x49339999, 0x05339999, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x05339999, 0x3E339999, 0x91339999, 0xC7339999, 0xD5339999, 0xF9339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999,
    0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xFF339999, 0xDC339999, 0xCD339999, 0xA2339999, 0x55339999, 0x0C339999, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF
};

GUI_CONST_STORAGE GUI_BITMAP bmbutton_1 =
{
    36, // xSize
    22, // ySize
    144, // BytesPerLine
    32, // BitsPerPixel
    (unsigned char *)_acbutton_1,  // Pointer to picture data
    NULL,  // Pointer to palette
    GUI_DRAW_BMPM8888I
};
#else
static GUI_CONST_STORAGE unsigned long _acbutton_1[] =
{
    0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF999933, 0xFA999934, 0xC1989832, 0x6E97972F, 0x3897972E, 0x2A97972F, 0x0697972F, 0x0097972F, 0x0097972F, 0x0097972F, 0x0097972F, 0x0097972F, 0x0097972F, 0x0097972F, 0x0097972F, 0x0097972F, 0x0097972F,
    0x0097972F, 0x0097972F, 0x0097972F, 0x0097972F, 0x0097972F, 0x2397972F, 0x3297972E, 0x5D979730, 0xAA999932, 0xF3999933, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFF000000, 0xFF000000, 0xFF999933, 0xFE9A9A35, 0xCE999933, 0x6697972F, 0x169A9A36, 0x00A8A852, 0x00B5B56B, 0x00B5B56B, 0x00B5B56B, 0x00B5B56C, 0x00B5B56C, 0x00B5B56C, 0x00B5B56C, 0x00B5B56C, 0x00B5B56C, 0x00B5B56C, 0x00B5B56C, 0x00B5B56C, 0x00B5B56C,
    0x00B5B56C, 0x00B5B56C, 0x00B5B56C, 0x00B5B56C, 0x00B5B56C, 0x00B5B56B, 0x00B5B56B, 0x00A8A852, 0x0C9A9A36, 0x4D979730, 0xB6999933, 0xFA999933, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFF000000, 0xFF999933, 0xFC9A9A34, 0x9A989832, 0x1C999932, 0x00ACAC59, 0x00D3D3A7, 0x00EAEAD6, 0x00EFEFDF, 0x00EFEFDF, 0x00EFEFDF, 0x00EFEFDF, 0x00EFEFDF, 0x00EFEFDF, 0x00EFEFDF, 0x00EFEFDF, 0x00EFEFDF, 0x00EFEFDF, 0x00EFEFDF, 0x00EFEFDF, 0x00EFEFDF,
    0x00EFEFDF, 0x00EFEFDF, 0x00EFEFDF, 0x00EFEFDF, 0x00EFEFDF, 0x00EFEFDF, 0x00EFEFDF, 0x00EAEAD6, 0x00D3D3A7, 0x00ACAC59, 0x0E999932, 0x74999932, 0xF0999933, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFF999933, 0xFF95952C, 0x9A989832, 0x0E9A9A35, 0x00BFBF80, 0x00E9E9D3, 0x00EAEAD5, 0x00E1E1C3, 0x00DCDCB9, 0x00DBDBB9, 0x00DBDBB9, 0x00DBDBB9, 0x00DBDBB9, 0x00DBDBB9, 0x00DBDBB9, 0x00DBDBB9, 0x00DBDBB9, 0x00DBDBB9, 0x00DBDBB9, 0x00DBDBB9, 0x00DBDBB9,
    0x00DBDBB9, 0x00DBDBB9, 0x00DBDBB9, 0x00DBDBB9, 0x00DBDBB9, 0x00DBDBB9, 0x00DCDCB9, 0x00E1E1C3, 0x00EAEAD5, 0x00E9E9D3, 0x00BFBF80, 0x039A9A35, 0x6D999932, 0xF6999933, 0xFFFFFFFF,
    0xFF999933, 0xCD999933, 0x1E999932, 0x00BFBF7F, 0x00EAEAD5, 0x00DEDEBE, 0x00D2D2A5, 0x00CACA95, 0x00C6C68E, 0x00C6C68E, 0x00C6C68E, 0x00C6C68E, 0x00C6C68E, 0x00C6C68E, 0x00C6C68E, 0x00C6C68E, 0x00C6C68E, 0x00C6C68E, 0x00C6C68E, 0x00C6C68E, 0x00C6C68E,
    0x00C6C68E, 0x00C6C68E, 0x00C6C68E, 0x00C6C68E, 0x00C6C68E, 0x00C6C68E, 0x00C6C68E, 0x00CACA95, 0x00D2D2A5, 0x00DEDEBE, 0x00EAEAD5, 0x00BFBF80, 0x08999932, 0xA2999933, 0xFFFFFFFF,
    0xFB999934, 0x6797972F, 0x00ACAC59, 0x00E5E5CB, 0x00D6D6AE, 0x00C3C389, 0x00B7B770, 0x00AFAF60, 0x00ADAD5B, 0x00ADAD5B, 0x00ADAD5B, 0x00ADAD5B, 0x00ADAD5B, 0x00ADAD5B, 0x00ADAD5B, 0x00ADAD5B, 0x00ADAD5B, 0x00ADAD5B, 0x00ADAD5B, 0x00ADAD5B, 0x00ADAD5B,
    0x00ADAD5B, 0x00ADAD5B, 0x00ADAD5B, 0x00ADAD5B, 0x00ADAD5B, 0x00ADAD5B, 0x00ADAD5B, 0x00AFAF60, 0x00B7B770, 0x00C3C389, 0x00D6D6AE, 0x00E5E5CB, 0x00ACAC59, 0x38989830, 0xE7999933,
    0xC1989832, 0x179B9B36, 0x00CFCFA0, 0x00D3D3A8, 0x00B2B265, 0x00A2A246, 0x009C9C39, 0x009A9A34, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933,
    0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x009A9A34, 0x009C9C39, 0x00A2A246, 0x00B2B265, 0x00D3D3A8, 0x00D0D0A0, 0x059A9A36, 0x8C999932,
    0x6E97972F, 0x00A9A952, 0x00D0D0A1, 0x00A6A64E, 0x00999933, 0x00989832, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933,
    0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00989832, 0x00999933, 0x00A6A64E, 0x00D0D0A2, 0x00A9A952, 0x32989830,
    0x38989830, 0x00AAAA55, 0x00ABAB56, 0x00989831, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933,
    0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00989831, 0x00ABAB56, 0x00AAAA55, 0x06989831,
    0x2B999933, 0x009C9C39, 0x009A9A34, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933,
    0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x009A9A34, 0x009C9C3A, 0x00999933,
    0x06999933, 0x009D9D3A, 0x009A9A34, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933,
    0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x009A9A34, 0x009D9D3A, 0x00999933,
    0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933,
    0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933,
    0x23999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933,
    0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933,
    0x38999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933,
    0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x06999933,
    0x6E999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933,
    0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x32999933,
    0xC1999933, 0x17999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933,
    0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x05999933, 0x8C999933,
    0xFB999933, 0x67999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933,
    0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x38999933, 0xE7999933,
    0xFFFFFFFF, 0xCD999933, 0x1E999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933,
    0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x08999933, 0xA2999933, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0x9A999933, 0x0E999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933,
    0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x03999933, 0x6D999933, 0xF6999933, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFC999933, 0x9A999933, 0x1C999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933,
    0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x0E999933, 0x74999933, 0xF0999933, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFE999933, 0xCE999933, 0x66999933, 0x16999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933,
    0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x0C999933, 0x4D999933, 0xB6999933, 0xFA999933, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFA999933, 0xC1999933, 0x6E999933, 0x38999933, 0x2A999933, 0x06999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933,
    0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x00999933, 0x23999933, 0x32999933, 0x5D999933, 0xAA999933, 0xF3999933, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF
};

GUI_CONST_STORAGE GUI_BITMAP bmbutton_1 =
{
    36, // xSize
    22, // ySize
    144, // BytesPerLine
    32, // BitsPerPixel
    (unsigned char *)_acbutton_1,  // Pointer to picture data
    NULL,  // Pointer to palette
    GUI_DRAW_BMP8888
};
#endif

static GUI_CONST_STORAGE unsigned char _acstop[] =
{
    /* ABS: 002 Pixels @ 000,000 */ 0, 2, 0xD3, 0x47,
    /* RLE: 008 Pixels @ 002,000 */ 8, 0x0F,
    /* ABS: 003 Pixels @ 010,000 */ 0, 3, 0x2F, 0xB3, 0x42,
    /* RLE: 010 Pixels @ 001,001 */ 10, 0x00,
    /* ABS: 002 Pixels @ 011,001 */ 0, 2, 0x22, 0x07,
    /* RLE: 010 Pixels @ 001,002 */ 10, 0x00,
    /* ABS: 002 Pixels @ 011,002 */ 0, 2, 0x0B, 0x0F,
    /* RLE: 010 Pixels @ 001,003 */ 10, 0x00,
    /* ABS: 002 Pixels @ 011,003 */ 0, 2, 0x0F, 0x0F,
    /* RLE: 010 Pixels @ 001,004 */ 10, 0x00,
    /* ABS: 002 Pixels @ 011,004 */ 0, 2, 0x0F, 0x0F,
    /* RLE: 010 Pixels @ 001,005 */ 10, 0x00,
    /* ABS: 002 Pixels @ 011,005 */ 0, 2, 0x0F, 0x0F,
    /* RLE: 010 Pixels @ 001,006 */ 10, 0x00,
    /* ABS: 002 Pixels @ 011,006 */ 0, 2, 0x0F, 0x0F,
    /* RLE: 010 Pixels @ 001,007 */ 10, 0x00,
    /* ABS: 002 Pixels @ 011,007 */ 0, 2, 0x0F, 0x0F,
    /* RLE: 010 Pixels @ 001,008 */ 10, 0x00,
    /* ABS: 002 Pixels @ 011,008 */ 0, 2, 0x0F, 0x0A,
    /* RLE: 010 Pixels @ 001,009 */ 10, 0x00,
    /* ABS: 002 Pixels @ 011,009 */ 0, 2, 0x0D, 0x27,
    /* RLE: 010 Pixels @ 001,010 */ 10, 0x00,
    /* ABS: 003 Pixels @ 011,010 */ 0, 3, 0x15, 0xB0, 0x2B,
    /* RLE: 008 Pixels @ 002,011 */ 8, 0x0F,
    /* ABS: 002 Pixels @ 010,011 */ 0, 2, 0x1F, 0x87,
    0
};  // 78 bytes for 144 pixels

GUI_CONST_STORAGE GUI_BITMAP bmstop =
{
    12, // xSize
    12, // ySize
    12, // BytesPerLine
    GUI_COMPRESS_RLE8, // BitsPerPixel
    (unsigned char *)_acstop,  // Pointer to picture data
    NULL,  // Pointer to palette
    GUI_DRAW_RLEALPHA
};

static GUI_CONST_STORAGE unsigned char _acforward[] =
{
    /* RLE: 003 Pixels @ 000,000 */ 3, 0xFF,
    /* ABS: 003 Pixels @ 003,000 */ 0, 3, 0x9F, 0x7F, 0xFE,
    /* RLE: 008 Pixels @ 006,000 */ 8, 0xFF,
    /* ABS: 005 Pixels @ 002,001 */ 0, 5, 0x97, 0x00, 0x00, 0x7D, 0xFD,
    /* RLE: 007 Pixels @ 007,001 */ 7, 0xFF,
    /* ABS: 006 Pixels @ 002,002 */ 0, 6, 0xAE, 0x0F, 0x00, 0x00, 0x58, 0xFC,
    /* RLE: 007 Pixels @ 008,002 */ 7, 0xFF,
    /* ABS: 006 Pixels @ 003,003 */ 0, 6, 0xB9, 0x12, 0x00, 0x00, 0x58, 0xFC,
    /* RLE: 007 Pixels @ 009,003 */ 7, 0xFF,
    /* ABS: 006 Pixels @ 004,004 */ 0, 6, 0xB9, 0x12, 0x00, 0x00, 0x58, 0xFC,
    /* RLE: 007 Pixels @ 010,004 */ 7, 0xFF,
    /* ABS: 005 Pixels @ 005,005 */ 0, 5, 0xC6, 0x28, 0x00, 0x00, 0x52,
    /* RLE: 007 Pixels @ 010,005 */ 7, 0xFF,
    /* ABS: 005 Pixels @ 005,006 */ 0, 5, 0xE6, 0x41, 0x00, 0x00, 0x3B,
    /* RLE: 006 Pixels @ 010,006 */ 6, 0xFF,
    /* ABS: 006 Pixels @ 004,007 */ 0, 6, 0xD6, 0x26, 0x00, 0x00, 0x40, 0xF5,
    /* RLE: 005 Pixels @ 010,007 */ 5, 0xFF,
    /* ABS: 006 Pixels @ 003,008 */ 0, 6, 0xD6, 0x26, 0x00, 0x00, 0x40, 0xF5,
    /* RLE: 005 Pixels @ 009,008 */ 5, 0xFF,
    /* ABS: 006 Pixels @ 002,009 */ 0, 6, 0xC6, 0x25, 0x00, 0x00, 0x40, 0xF5,
    /* RLE: 006 Pixels @ 008,009 */ 6, 0xFF,
    /* ABS: 005 Pixels @ 002,010 */ 0, 5, 0x6D, 0x00, 0x00, 0x58, 0xF7,
    /* RLE: 008 Pixels @ 007,010 */ 8, 0xFF,
    /* ABS: 003 Pixels @ 003,011 */ 0, 3, 0x7A, 0x54, 0xF9,
    /* RLE: 006 Pixels @ 006,011 */ 6, 0xFF,
    0
};  // 112 bytes for 144 pixels

GUI_CONST_STORAGE GUI_BITMAP bmforward =
{
    12, // xSize
    12, // ySize
    12, // BytesPerLine
    GUI_COMPRESS_RLE8, // BitsPerPixel
    (unsigned char *)_acforward,  // Pointer to picture data
    NULL,  // Pointer to palette
    GUI_DRAW_RLEALPHA
};

static GUI_CONST_STORAGE unsigned char _acplay[] =
{
    /* RLE: 003 Pixels @ 000,000 */ 3, 0xFF,
    /* ABS: 002 Pixels @ 003,000 */ 0, 2, 0x54, 0xD8,
    /* RLE: 010 Pixels @ 005,000 */ 10, 0xFF,
    /* ABS: 003 Pixels @ 003,001 */ 0, 3, 0x08, 0x22, 0xD3,
    /* RLE: 009 Pixels @ 006,001 */ 9, 0xFF,
    /* ABS: 004 Pixels @ 003,002 */ 0, 4, 0x0F, 0x00, 0x0A, 0xBF,
    /* RLE: 008 Pixels @ 007,002 */ 8, 0xFF,
    /* ABS: 006 Pixels @ 003,003 */ 0, 6, 0x0F, 0x00, 0x00, 0x09, 0x99, 0xFD,
    /* RLE: 006 Pixels @ 009,003 */ 6, 0xFF,
    /* RLE: 001 Pixels @ 003,004 */ 1, 0x0F,
    /* RLE: 004 Pixels @ 004,004 */ 4, 0x00,
    /* ABS: 002 Pixels @ 008,004 */ 0, 2, 0x7D, 0xFD,
    /* RLE: 005 Pixels @ 010,004 */ 5, 0xFF,
    /* RLE: 001 Pixels @ 003,005 */ 1, 0x0F,
    /* RLE: 005 Pixels @ 004,005 */ 5, 0x00,
    /* RLE: 001 Pixels @ 009,005 */ 1, 0x52,
    /* RLE: 005 Pixels @ 010,005 */ 5, 0xFF,
    /* RLE: 001 Pixels @ 003,006 */ 1, 0x0F,
    /* RLE: 005 Pixels @ 004,006 */ 5, 0x00,
    /* RLE: 001 Pixels @ 009,006 */ 1, 0x3B,
    /* RLE: 005 Pixels @ 010,006 */ 5, 0xFF,
    /* RLE: 001 Pixels @ 003,007 */ 1, 0x0F,
    /* RLE: 004 Pixels @ 004,007 */ 4, 0x00,
    /* ABS: 002 Pixels @ 008,007 */ 0, 2, 0x58, 0xF7,
    /* RLE: 005 Pixels @ 010,007 */ 5, 0xFF,
    /* ABS: 006 Pixels @ 003,008 */ 0, 6, 0x0F, 0x00, 0x00, 0x05, 0x67, 0xF9,
    /* RLE: 006 Pixels @ 009,008 */ 6, 0xFF,
    /* ABS: 004 Pixels @ 003,009 */ 0, 4, 0x0F, 0x00, 0x02, 0xA6,
    /* RLE: 008 Pixels @ 007,009 */ 8, 0xFF,
    /* ABS: 003 Pixels @ 003,010 */ 0, 3, 0x0B, 0x0E, 0xB6,
    /* RLE: 009 Pixels @ 006,010 */ 9, 0xFF,
    /* ABS: 002 Pixels @ 003,011 */ 0, 2, 0x34, 0xB8,
    /* RLE: 007 Pixels @ 005,011 */ 7, 0xFF,
    0
};  // 100 bytes for 144 pixels

GUI_CONST_STORAGE GUI_BITMAP bmplay =
{
    12, // xSize
    12, // ySize
    12, // BytesPerLine
    GUI_COMPRESS_RLE8, // BitsPerPixel
    (unsigned char *)_acplay,  // Pointer to picture data
    NULL,  // Pointer to palette
    GUI_DRAW_RLEALPHA
};

/*********************************************************************
*
*       Dolphin(s)
*
*   All dolphins use the same palette.
*/
static GUI_CONST_STORAGE GUI_COLOR _aColorsDolphin[] =
{
#if (GUI_USE_ARGB)
    0xFFFF0000, 0xFF000033, 0xFF333333, 0xFF000066, 0xFF333366, 0xFF666666,
    0xFF333399, 0xFF3333CC, 0xFF3434CC, 0xFF336699, 0xFF3366CC, 0xFF666699,
    0xFF66669A, 0xFF6666CC, 0xFF6666FF, 0xFF6699CC, 0xFF6699FF, 0xFF000000,
    0xFF999999, 0xFF9999CC, 0xFF9999FF, 0xFF9A9AFF, 0xFF99CCFF, 0xFFCCCCCC,
    0xFFCBCBFF, 0xFFCCCCFF, 0xFFFFFFFF
#else
    0x0000FF, 0x330000, 0x333333, 0x660000, 0x663333, 0x666666,
    0x993333, 0xCC3333, 0xCC3434, 0x996633, 0xCC6633, 0x996666,
    0x9A6666, 0xCC6666, 0xFF6666, 0xCC9966, 0xFF9966, 0x000000,
    0x999999, 0xCC9999, 0xFF9999, 0xFF9A9A, 0xFFCC99, 0xCCCCCC,
    0xFFCBCB, 0xFFCCCC, 0xFFFFFF
#endif
};

static GUI_CONST_STORAGE GUI_LOGPALETTE _PalDolphin =
{
    27,   // Number of entries
    1,    // Has transparency
    &_aColorsDolphin[0]
};

static GUI_CONST_STORAGE unsigned char acDolphin_00[] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x02,
    0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0B, 0x14,
    0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x14, 0x16, 0x14,
    0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x19, 0x19, 0x19, 0x14,
    0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x19, 0x16, 0x19, 0x19, 0x14,
    0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x0B, 0x04, 0x13, 0x05, 0x0B, 0x0B, 0x0B, 0x02, 0x02, 0x02, 0x02, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x19, 0x19, 0x14, 0x19, 0x19, 0x14,
    0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0x04, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x16, 0x16, 0x16, 0x16, 0x16, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x02, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x14, 0x16, 0x14, 0x14, 0x19, 0x16, 0x14,
    0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x16, 0x16, 0x16, 0x14, 0x14, 0x13, 0x05, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x14, 0x14,
    0x02, 0x00, 0x00, 0x00, 0x00, 0x02, 0x05, 0x0D, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x16, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x14, 0x14, 0x0B, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x14, 0x0B,
    0x00, 0x00, 0x00, 0x05, 0x04, 0x13, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x16, 0x14, 0x14, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x02,
    0x00, 0x05, 0x04, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x05, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x04,
    0x02, 0x13, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x05, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x05,
    0x0B, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x05, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x04, 0x13,
    0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x07, 0x06, 0x07, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x05, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x04, 0x0B, 0x14, 0x14,
    0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x06, 0x05, 0x06, 0x06, 0x07, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x02,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x0B, 0x14, 0x14, 0x14, 0x14,
    0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x04, 0x00, 0x00, 0x0B, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D,
    0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0B, 0x14, 0x14, 0x14, 0x0D, 0x0B, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19,
    0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0B, 0x00, 0x00, 0x00, 0x0B, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x19, 0x19, 0x14,
    0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x05, 0x02, 0x02, 0x02, 0x05, 0x0B, 0x0B, 0x0B, 0x04, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19,
    0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x04, 0x00, 0x00, 0x00, 0x00, 0x07, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x19, 0x16,
    0x13, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x05, 0x0B, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x19, 0x19, 0x19, 0x19, 0x19,
    0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x05, 0x05, 0x04, 0x06, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x19,
    0x14, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0B, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x16, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x07, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x19,
    0x19, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x04, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x16, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14,
    0x19, 0x0F, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0B, 0x14, 0x14, 0x16, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x16, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x07, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x07, 0x0E, 0x0E, 0x0E, 0x14, 0x14,
    0x19, 0x0F, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0D, 0x0E, 0x0E, 0x0E, 0x14,
    0x19, 0x13, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x13, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x04, 0x05, 0x05, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0D, 0x0E, 0x0E, 0x14,
    0x16, 0x14, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x02, 0x17, 0x19, 0x19, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0E, 0x0E, 0x0E,
    0x16, 0x14, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x14, 0x14, 0x14, 0x13, 0x05, 0x19, 0x19, 0x19, 0x19, 0x12, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x15, 0x16, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x0E, 0x0E,
    0x14, 0x14, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x04, 0x12, 0x17, 0x19, 0x19, 0x19, 0x12, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x15, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0E,
    0x14, 0x14, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x17, 0x19, 0x02, 0x17, 0x19, 0x19, 0x05, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06,
    0x14, 0x14, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x04, 0x0B, 0x02, 0x02, 0x12, 0x05, 0x12, 0x12, 0x05, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x05, 0x19, 0x05, 0x05, 0x02, 0x17, 0x19, 0x05, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
    0x0D, 0x0D, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x04, 0x0E, 0x14, 0x14, 0x14, 0x0B, 0x0B, 0x0B, 0x0B, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x05, 0x12, 0x12, 0x0B, 0x02, 0x12, 0x05, 0x19, 0x05, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x06, 0x10, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x02, 0x19, 0x04, 0x01, 0x17, 0x17, 0x05, 0x19, 0x02, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0B, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x14, 0x13, 0x05, 0x19, 0x02, 0x05, 0x12, 0x12, 0x05, 0x12, 0x05, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x12, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x14, 0x0B, 0x02, 0x02, 0x02, 0x0B, 0x04, 0x04, 0x04, 0x05, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x04, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x14, 0x14, 0x0B, 0x14, 0x14, 0x14, 0x16, 0x16, 0x16, 0x16, 0x16, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x06, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x05, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x0E, 0x0E, 0x0E, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x04, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x0E, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x06, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x16, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x04, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x06, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x14,
    0x14, 0x0B, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x02, 0x0B, 0x0E, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19,
    0x14, 0x14, 0x0B, 0x02, 0x02, 0x02, 0x0B, 0x0B, 0x14, 0x14, 0x14, 0x0E, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x04, 0x07, 0x0E, 0x0E, 0x0E, 0x0E, 0x07, 0x01, 0x04, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19,
    0x19, 0x19, 0x19, 0x19, 0x19, 0x16, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x07, 0x04, 0x02, 0x01, 0x01, 0x02, 0x06, 0x0B, 0x0D, 0x02, 0x06, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0D, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x07, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x06, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x07, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x07, 0x06, 0x06, 0x05, 0x04, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E,
    0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0D, 0x0B, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x01, 0x07, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x07, 0x07, 0x06, 0x02, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x07, 0x0E, 0x0E, 0x0E, 0x0E,
    0x0E, 0x0E, 0x0E, 0x0E, 0x07, 0x04, 0x05, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0x01, 0x06, 0x06,
    0x06, 0x01, 0x01, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static GUI_CONST_STORAGE unsigned char acDolphin_01[] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x12, 0x02, 0x05, 0x05, 0x02, 0x02, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x04, 0x04, 0x0B, 0x05, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x02, 0x0B, 0x0B, 0x04,
    0x0D, 0x0D, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x05, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x05, 0x0B, 0x14, 0x14, 0x14, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x14, 0x14, 0x14, 0x16, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x0B, 0x05, 0x12, 0x12, 0x04, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19,
    0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x05, 0x0D, 0x14, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x16, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x16,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12,
    0x0B, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x14, 0x13, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x16, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x13,
    0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x14, 0x13, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x16, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x0E, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0B, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x14, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x0E, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x04, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x0E, 0x0E, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x16, 0x0D, 0x02, 0x02, 0x12, 0x00, 0x12, 0x05, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x16, 0x14, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E,
    0x0E, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x14, 0x04, 0x02, 0x04, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x19, 0x14, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E,
    0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x0B, 0x0B, 0x14, 0x14, 0x19, 0x18, 0x19, 0x14, 0x0D, 0x04, 0x04, 0x0B, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x06, 0x02,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x02, 0x05, 0x19, 0x12, 0x0B, 0x14, 0x14, 0x19, 0x19, 0x19, 0x16, 0x14, 0x14, 0x0B, 0x04, 0x0B, 0x13,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0B, 0x04, 0x0B, 0x0B, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x06, 0x02, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x04, 0x14, 0x14, 0x0B, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x05, 0x05, 0x17, 0x19, 0x19, 0x19, 0x02, 0x14, 0x14, 0x16, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x13, 0x0B,
    0x04, 0x0B, 0x0D, 0x14, 0x14, 0x04, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x05, 0x05, 0x02, 0x0B, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x13, 0x0B, 0x02, 0x02, 0x05, 0x04, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x05, 0x12, 0x12, 0x19, 0x19, 0x19, 0x19, 0x05, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x13, 0x0B, 0x04, 0x04, 0x11, 0x02, 0x02, 0x02, 0x02, 0x05, 0x05, 0x05, 0x04, 0x0B, 0x0D, 0x0D, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x07, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x0B, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x05, 0x12, 0x12, 0x02, 0x17, 0x19, 0x19, 0x19, 0x04, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x13, 0x13, 0x13, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0D, 0x0B, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x05, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x04, 0x17, 0x13, 0x05, 0x12, 0x17, 0x05, 0x19, 0x19, 0x05, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19,
    0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x16, 0x14, 0x04, 0x12, 0x17, 0x02, 0x05, 0x1A, 0x1A, 0x05, 0x19, 0x19, 0x02, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19,
    0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x18, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x04, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x14, 0x04, 0x02, 0x02, 0x02, 0x05, 0x02, 0x12, 0x05, 0x19, 0x12, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19,
    0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x0B, 0x02, 0x05, 0x04, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x07, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x14, 0x14, 0x14, 0x0B, 0x05, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x14, 0x14, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x15, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x06, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x07, 0x04, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x16, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0x06, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x04, 0x04, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x06, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x06, 0x01, 0x02, 0x06, 0x06, 0x02, 0x04, 0x04, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x10, 0x0E, 0x0E, 0x07, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x13, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x06, 0x05, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x07, 0x04, 0x12, 0x17, 0x17, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x07, 0x06, 0x02, 0x05, 0x05, 0x19, 0x19, 0x05, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x07, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x06, 0x06, 0x04, 0x05, 0x12, 0x19, 0x19, 0x19, 0x13, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0x07, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x14, 0x14,
    0x14, 0x14, 0x0D, 0x04, 0x04, 0x05, 0x05, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x12, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x04, 0x07, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x14,
    0x14, 0x05, 0x12, 0x17, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x03, 0x07, 0x07, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19,
    0x14, 0x02, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x12, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x11, 0x01, 0x06, 0x06, 0x06, 0x06, 0x0E, 0x0E, 0x0E, 0x0E, 0x06, 0x06, 0x01, 0x0E, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19,
    0x19, 0x0D, 0x05, 0x19, 0x19, 0x19, 0x12, 0x05, 0x02, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x05, 0x02, 0x11, 0x0B, 0x0B, 0x05, 0x12, 0x19, 0x17, 0x04, 0x0E, 0x14, 0x14, 0x14, 0x19, 0x19,
    0x19, 0x14, 0x04, 0x11, 0x11, 0x02, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x05, 0x05, 0x02, 0x0E, 0x0E, 0x14, 0x14, 0x16,
    0x19, 0x19, 0x14, 0x0B, 0x02, 0x02, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0E, 0x0E, 0x0E, 0x14,
    0x14, 0x14, 0x16, 0x16, 0x14, 0x13, 0x0D, 0x04, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x06, 0x0E, 0x0E,
    0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x07,
    0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x04, 0x04, 0x07, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x02, 0x0B, 0x0B, 0x0B, 0x0B, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static GUI_CONST_STORAGE unsigned char acDolphin_02[] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x0D, 0x0B, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x14, 0x14, 0x14, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x0D, 0x05, 0x02, 0x05, 0x05, 0x05, 0x12, 0x05, 0x05, 0x04, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x16, 0x14, 0x13, 0x0D, 0x0D, 0x0D, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x0B, 0x02, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x04, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x14, 0x14, 0x0B, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x0B, 0x0B, 0x04, 0x14, 0x14, 0x14, 0x14, 0x14, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x16, 0x14, 0x05, 0x00,
    0x00, 0x02, 0x04, 0x0D, 0x14, 0x14, 0x14, 0x16, 0x16, 0x16, 0x16, 0x16, 0x14, 0x14, 0x14, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x0D, 0x0D, 0x0D, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x14, 0x11,
    0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x16, 0x14, 0x14, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x16, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x0B, 0x05, 0x0B, 0x0B, 0x02, 0x17, 0x05, 0x02, 0x05, 0x14, 0x14, 0x16, 0x19, 0x19, 0x14, 0x0B,
    0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x16, 0x14, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x06, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x02, 0x05, 0x19, 0x05, 0x05, 0x05, 0x05, 0x19, 0x19, 0x19, 0x13, 0x0D, 0x14, 0x14, 0x19, 0x19, 0x19, 0x14,
    0x0B, 0x04, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x14, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0E, 0x0E, 0x0E, 0x07, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x05, 0x03, 0x12, 0x1A, 0x02, 0x17, 0x19, 0x19, 0x17, 0x0D, 0x14, 0x14, 0x19, 0x19, 0x19, 0x14,
    0x14, 0x0B, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x14, 0x13, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x01, 0x0E, 0x0E, 0x07, 0x06, 0x0E, 0x14, 0x14, 0x14, 0x19, 0x14, 0x0B, 0x11, 0x02, 0x1A, 0x1A, 0x05, 0x19, 0x19, 0x19, 0x12, 0x14, 0x14, 0x14, 0x16, 0x19, 0x19, 0x19,
    0x14, 0x14, 0x04, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x19, 0x13, 0x04, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x0E, 0x02, 0x06, 0x0E, 0x04, 0x0E, 0x0E, 0x14, 0x14, 0x16, 0x19, 0x14, 0x0B, 0x12, 0x1A, 0x12, 0x12, 0x19, 0x19, 0x0B, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x19, 0x18, 0x19,
    0x19, 0x14, 0x14, 0x02, 0x04, 0x14, 0x14, 0x19, 0x13, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0E, 0x0E, 0x0B, 0x02, 0x11, 0x07, 0x0E, 0x14, 0x14, 0x14, 0x19, 0x19, 0x14, 0x04, 0x12, 0x05, 0x19, 0x19, 0x05, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19,
    0x19, 0x14, 0x14, 0x14, 0x04, 0x04, 0x14, 0x14, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x0E, 0x14, 0x14, 0x0B, 0x06, 0x0E, 0x14, 0x14, 0x14, 0x19, 0x19, 0x14, 0x0D, 0x02, 0x19, 0x17, 0x02, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19,
    0x19, 0x19, 0x14, 0x14, 0x14, 0x0B, 0x04, 0x14, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0E, 0x14, 0x14, 0x14, 0x06, 0x0E, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x14, 0x04, 0x02, 0x02, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19,
    0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x0B, 0x0B, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x0E, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x14, 0x14, 0x19, 0x19, 0x19, 0x14, 0x13, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19,
    0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x0B, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0E, 0x0E, 0x14, 0x14, 0x0E, 0x0E, 0x14, 0x14, 0x19, 0x19, 0x19, 0x16, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x0B, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0E, 0x0E, 0x14, 0x15, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x16, 0x14, 0x14, 0x14, 0x0B, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x13, 0x0B, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x14, 0x0B, 0x0B, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0B, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x14, 0x19, 0x19, 0x19, 0x13, 0x0D, 0x05, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x04, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x16, 0x14, 0x14, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x14, 0x0D, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0x06, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x16, 0x14, 0x13, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x05, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x02, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x05, 0x12, 0x12, 0x05, 0x02, 0x02, 0x02, 0x02, 0x02, 0x05, 0x0B, 0x0B, 0x0C, 0x0B, 0x04,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x04, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0B, 0x02, 0x05, 0x12, 0x11, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x14, 0x14, 0x02, 0x00, 0x00, 0x00,
    0x04, 0x0B, 0x0B, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x17, 0x04, 0x08, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0D, 0x04, 0x04, 0x0B, 0x04, 0x0D, 0x0D, 0x14, 0x19, 0x19, 0x19, 0x14, 0x0D, 0x02, 0x02, 0x0D,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x0B,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x19, 0x13, 0x04, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x13, 0x0D, 0x0D, 0x0B, 0x14, 0x19, 0x19, 0x16, 0x14, 0x14, 0x14, 0x14,
    0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x04,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x19, 0x12, 0x09, 0x07, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x16, 0x16, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x19, 0x19, 0x19, 0x19,
    0x19, 0x19, 0x16, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x19, 0x19, 0x14, 0x14, 0x14, 0x06, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x19, 0x02, 0x04, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x06, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x17, 0x12, 0x07, 0x0E, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x06, 0x05, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x04, 0x0E, 0x0E, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x02, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x01, 0x0E, 0x0E, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0E, 0x0E, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x14, 0x0E,
    0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x10, 0x10, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x10, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x06, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E,
    0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x06, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0E, 0x0E, 0x14, 0x19, 0x19, 0x19, 0x19, 0x0D, 0x05,
    0x02, 0x04, 0x06, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x07, 0x04, 0x06, 0x06, 0x04, 0x02, 0x11, 0x11, 0x02, 0x00, 0x00, 0x05, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x06, 0x06, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0E, 0x0E, 0x14, 0x14, 0x19, 0x19, 0x14, 0x05, 0x19,
    0x19, 0x17, 0x12, 0x02, 0x02, 0x05, 0x0B, 0x04, 0x01, 0x06, 0x07, 0x07, 0x07, 0x07, 0x07, 0x06, 0x01, 0x01, 0x0B, 0x0B, 0x05, 0x02, 0x05, 0x12, 0x12, 0x12, 0x17, 0x12, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0E, 0x14, 0x14, 0x19, 0x19, 0x14, 0x05, 0x19,
    0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x19, 0x19, 0x19, 0x19, 0x19, 0x17, 0x05, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0D, 0x0E, 0x14, 0x19, 0x19, 0x0F, 0x11, 0x02,
    0x05, 0x17, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x12, 0x05, 0x05, 0x02, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0E, 0x14, 0x14, 0x19, 0x14, 0x05, 0x17,
    0x12, 0x05, 0x02, 0x02, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x12, 0x05, 0x05, 0x05, 0x05, 0x02, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0A, 0x0E, 0x14, 0x19, 0x14, 0x05, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0E, 0x0E, 0x14, 0x14, 0x04, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x07, 0x0E, 0x14, 0x14, 0x0B, 0x12,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0E, 0x0E, 0x14, 0x14, 0x05,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x07, 0x0E, 0x0E, 0x05,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x04, 0x07, 0x05,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static GUI_CONST_STORAGE unsigned char acDolphin_03[] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x05, 0x04, 0x13, 0x14, 0x14, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x12, 0x05, 0x13, 0x19, 0x19, 0x16, 0x0D, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x02, 0x0B, 0x14, 0x16, 0x19, 0x19, 0x19, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0D,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0B, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0D, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0D, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x0B, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x12, 0x0B, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x0B, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x02, 0x0B, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x05, 0x0B, 0x02, 0x11, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x13, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x04, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x02, 0x04, 0x0B, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x0B, 0x02, 0x0B,
    0x0B, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x16, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x13, 0x0B, 0x04, 0x0B, 0x13, 0x14, 0x14, 0x14, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x04, 0x04, 0x13, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x16, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x0B, 0x02, 0x04, 0x0D, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x02, 0x12, 0x19, 0x19, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x16,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x02, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x11, 0x05, 0x19, 0x19, 0x19, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19,
    0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x05, 0x12, 0x02, 0x02, 0x12, 0x19, 0x19, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19,
    0x19, 0x19, 0x19, 0x16, 0x14, 0x14, 0x14, 0x14, 0x13, 0x02, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x05, 0x19, 0x05, 0x12, 0x17, 0x05, 0x19, 0x19, 0x05, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19,
    0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x04, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x05, 0x14, 0x19, 0x19, 0x14, 0x14, 0x14, 0x0D, 0x05, 0x19, 0x19, 0x05, 0x12, 0x1A, 0x12, 0x17, 0x19, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19,
    0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x13, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0B, 0x14, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0B, 0x02, 0x05, 0x05, 0x02, 0x05, 0x12, 0x12, 0x17, 0x05, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19,
    0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x04, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x02, 0x0B, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x0B, 0x02, 0x05, 0x02, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x05, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x14, 0x0B, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x0B, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x10, 0x14, 0x14, 0x14, 0x14, 0x16, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x16, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x04, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x12, 0x06, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x04, 0x04, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0x04, 0x06, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x07, 0x04, 0x02, 0x02, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0x11, 0x11, 0x11, 0x11, 0x01, 0x11, 0x11, 0x0B, 0x0B, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x07, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x15, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x19, 0x19, 0x16, 0x14, 0x14, 0x0D, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x07, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x10, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x16, 0x14, 0x14, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x04, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x19, 0x16, 0x14, 0x14, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x04, 0x06, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x14, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0x01, 0x06, 0x06, 0x04, 0x06, 0x06, 0x06, 0x04, 0x06, 0x06, 0x06, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x14, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x05, 0x05, 0x11, 0x02, 0x05, 0x05, 0x05, 0x05, 0x03, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x19, 0x19, 0x14, 0x14, 0x0E, 0x0E,
    0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x16, 0x13, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0x06, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x19, 0x19, 0x14, 0x04, 0x04, 0x07,
    0x07, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x14, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x19, 0x14, 0x02, 0x12, 0x17,
    0x05, 0x0B, 0x05, 0x06, 0x06, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x14, 0x14, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x19, 0x19, 0x02, 0x17, 0x19,
    0x19, 0x19, 0x19, 0x19, 0x19, 0x0B, 0x06, 0x06, 0x07, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x01, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x19, 0x13, 0x02, 0x19,
    0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x17, 0x05, 0x04, 0x06, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x04, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x16, 0x04, 0x11,
    0x02, 0x05, 0x05, 0x05, 0x05, 0x17, 0x19, 0x19, 0x19, 0x19, 0x19, 0x12, 0x0B, 0x04, 0x0A, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x06, 0x0E, 0x14, 0x14, 0x14, 0x16, 0x14, 0x02,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x05, 0x12, 0x17, 0x19, 0x19, 0x19, 0x17, 0x05, 0x04, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0x14, 0x0E, 0x14, 0x14, 0x14, 0x14,
    0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x05, 0x05, 0x19, 0x19, 0x19, 0x19, 0x17, 0x0B, 0x07, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x06, 0x0E, 0x14, 0x14, 0x14,
    0x0B, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x02, 0x02, 0x17, 0x19, 0x19, 0x05, 0x04, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x19, 0x14, 0x14, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0x06, 0x13, 0x14,
    0x14, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x02, 0x02, 0x17, 0x12, 0x04, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05,
    0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0x12, 0x04, 0x07, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0x02, 0x07, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x11, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x06, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x04, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x13, 0x11, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0E, 0x04, 0x07, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x13, 0x0D, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x06, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x10, 0x14, 0x14, 0x14, 0x0D, 0x02, 0x05, 0x12, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x06, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x05, 0x05, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x06, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x0D, 0x02,
    0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14,
    0x0D, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14,
    0x19, 0x14, 0x0B, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x06, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E,
    0x0E, 0x0E, 0x14, 0x14, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0A, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E,
    0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x0B, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x07, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x06, 0x05, 0x05, 0x02, 0x03, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E,
    0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x0B, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x07, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x07, 0x06, 0x04, 0x05, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x06, 0x06, 0x07, 0x0E, 0x0E, 0x0E, 0x0E,
    0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x16, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x04, 0x0E, 0x0E, 0x0E, 0x06, 0x06, 0x02, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x05, 0x02, 0x02, 0x06, 0x06, 0x0E,
    0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x13, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x02,
    0x06, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x05, 0x04, 0x06, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x0B, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x05, 0x02, 0x06, 0x0E, 0x0E, 0x14, 0x14, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0x04, 0x0E, 0x0E, 0x14, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0E, 0x13, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static GUI_CONST_STORAGE unsigned char acDolphin_04[] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0D, 0x12, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x14, 0x14, 0x12, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x14, 0x14, 0x14, 0x12, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x16, 0x19, 0x19, 0x14, 0x02, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x19, 0x19, 0x19, 0x19, 0x19, 0x05, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x16, 0x19, 0x19, 0x19, 0x19, 0x19, 0x0D, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x19, 0x14, 0x14, 0x14, 0x19, 0x19, 0x14, 0x02, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x0B, 0x05, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x14, 0x0B, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x14, 0x14, 0x05,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x14, 0x13, 0x12,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x02, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x0B, 0x04, 0x04, 0x05, 0x05,
    0x02, 0x04, 0x0B, 0x0B, 0x0B, 0x05, 0x05, 0x05, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x0B, 0x02, 0x04, 0x04, 0x0D, 0x0D, 0x13, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x0B, 0x05, 0x02, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x0D, 0x0B, 0x02, 0x04, 0x04, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x19,
    0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x13, 0x05, 0x02, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x11, 0x0B, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19,
    0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x16, 0x14, 0x14, 0x0D, 0x0B, 0x02, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x04, 0x0B, 0x0D, 0x14, 0x14, 0x14, 0x16, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19,
    0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x05, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x04, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0B, 0x14, 0x14, 0x14, 0x16, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x0B, 0x05, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x13, 0x14, 0x14, 0x16, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x15, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x04, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x13, 0x14, 0x16, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x16, 0x16, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x0B, 0x05, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x05, 0x19, 0x17, 0x02, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x12, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x19, 0x19, 0x19, 0x19, 0x02, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x12, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x17, 0x19, 0x19, 0x19, 0x19, 0x05, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x0B, 0x12, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x02, 0x12, 0x19, 0x19, 0x19, 0x19, 0x19, 0x02, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x06, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x04, 0x12,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x05, 0x05, 0x05, 0x12, 0x19, 0x19, 0x19, 0x02, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x07, 0x07, 0x04, 0x06, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x04, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x06, 0x04, 0x06, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x13,
    0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x14, 0x14, 0x14, 0x14, 0x05, 0x12, 0x12, 0x1A, 0x05, 0x17, 0x19, 0x13, 0x02, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x04, 0x04, 0x05, 0x12, 0x05, 0x05, 0x05, 0x05, 0x00, 0x00, 0x00, 0x02, 0x04, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x19,
    0x14, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x14, 0x14, 0x14, 0x14, 0x05, 0x12, 0x12, 0x1A, 0x17, 0x02, 0x02, 0x04, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x07, 0x04, 0x05, 0x17, 0x12, 0x05, 0x02, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x06, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14,
    0x19, 0x19, 0x0D, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x14, 0x14, 0x14, 0x14, 0x12, 0x12, 0x01, 0x11, 0x02, 0x13, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14,
    0x0E, 0x0E, 0x0E, 0x0E, 0x06, 0x02, 0x12, 0x19, 0x12, 0x02, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14,
    0x14, 0x14, 0x19, 0x14, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x12, 0x13, 0x02, 0x0D, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x0D,
    0x0E, 0x0E, 0x06, 0x05, 0x17, 0x19, 0x12, 0x05, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E,
    0x14, 0x14, 0x14, 0x14, 0x19, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x14, 0x14, 0x14, 0x14, 0x05, 0x04, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x02,
    0x11, 0x12, 0x19, 0x19, 0x12, 0x02, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E,
    0x0E, 0x14, 0x14, 0x14, 0x16, 0x14, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x04, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19,
    0x0D, 0x05, 0x02, 0x05, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x07, 0x01, 0x06, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E,
    0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x14, 0x14, 0x0B, 0x0B, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19,
    0x19, 0x14, 0x14, 0x0D, 0x05, 0x05, 0x02, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x07, 0x02, 0x00, 0x12, 0x06, 0x06, 0x07, 0x0E, 0x0E, 0x0E, 0x0E,
    0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x16, 0x16, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x19, 0x19, 0x19, 0x16, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x07, 0x02, 0x07, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x19, 0x19, 0x19, 0x16, 0x14, 0x14, 0x14, 0x14, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x0E, 0x0E, 0x07, 0x04, 0x04, 0x04, 0x06, 0x02, 0x02, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x02, 0x06, 0x0E, 0x0E,
    0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x13, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0D, 0x04, 0x01, 0x01, 0x0B, 0x0D, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x04, 0x12, 0x12, 0x05, 0x04, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x16, 0x19, 0x19, 0x16, 0x14, 0x14, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x02, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x02, 0x06,
    0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x02, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x07, 0x04, 0x12, 0x05, 0x00, 0x00, 0x00, 0x04, 0x07, 0x0E, 0x0E, 0x0E, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x04, 0x06, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x19, 0x19, 0x19, 0x16, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x06, 0x06, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x04, 0x05, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x04, 0x06, 0x0E, 0x0E, 0x0E,
    0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0D, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x05, 0x01, 0x07, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x04, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x07, 0x04, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x04, 0x02, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0x06,
    0x04, 0x04, 0x06, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x02, 0x06, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x04, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x07, 0x04, 0x0E, 0x0E, 0x0E, 0x0E, 0x04, 0x02, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x07, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0D, 0x12, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x07, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x06, 0x04, 0x0E, 0x07, 0x07, 0x04, 0x11, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x0E, 0x0E, 0x0E, 0x12, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x05, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x04, 0x02, 0x05, 0x0B, 0x0B, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x07, 0x0E, 0x0E, 0x02, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x06, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x07, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x04, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0x04, 0x04, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static GUI_CONST_STORAGE unsigned char acDolphin_10[] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x14, 0x0B, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x14, 0x16, 0x14, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x14, 0x19, 0x19, 0x19, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x02, 0x02, 0x02, 0x02, 0x0B, 0x0B, 0x0B, 0x05, 0x13, 0x04, 0x0B,
    0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x14, 0x19, 0x19, 0x16, 0x19, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x02, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x16, 0x16, 0x16, 0x16, 0x14, 0x14,
    0x14, 0x14, 0x0D, 0x04, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x14, 0x19, 0x19, 0x14, 0x19, 0x19, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x05, 0x13, 0x14, 0x14, 0x16, 0x16, 0x16, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19,
    0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x14, 0x16, 0x19, 0x14, 0x14, 0x16, 0x14, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0B, 0x14, 0x14, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16,
    0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x0D, 0x05, 0x02, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x14, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x14, 0x14, 0x16, 0x16, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x13, 0x04, 0x05, 0x00, 0x00, 0x00, 0x0B, 0x14, 0x16, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x04, 0x05, 0x00, 0x02, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x13, 0x02, 0x04, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x0B, 0x05, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x07, 0x06, 0x07, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x13, 0x04, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x07, 0x06, 0x06, 0x05, 0x06, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x0B, 0x04, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0B, 0x00, 0x00, 0x04, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x14, 0x19, 0x19, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0B, 0x00, 0x00, 0x00, 0x0B, 0x0E, 0x0E, 0x0E, 0x0E, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x0B, 0x0D, 0x14, 0x14, 0x14, 0x0B, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x13, 0x16, 0x19, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x07, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0E, 0x0E, 0x0E, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x04, 0x0B, 0x0B, 0x0B, 0x05, 0x02, 0x02, 0x02, 0x05, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x19, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x06, 0x04, 0x05, 0x05, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0E, 0x0E, 0x0E,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x16, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x0B, 0x05, 0x12, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x19, 0x19, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x07, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0E, 0x0E,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x16, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0B, 0x12, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0F, 0x19, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x0E,
    0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x04,
    0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0F, 0x19, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x07, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x07,
    0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x14, 0x14,
    0x0B, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x13, 0x19, 0x14, 0x0E, 0x0E, 0x0E, 0x0D, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04,
    0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x0B, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x14, 0x16, 0x14, 0x0E, 0x0E, 0x0D, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x05, 0x05, 0x04, 0x0D, 0x14, 0x14,
    0x14, 0x14, 0x13, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x14, 0x16, 0x0E, 0x0E, 0x0E, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x06, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x19, 0x19, 0x17, 0x02, 0x0D, 0x14,
    0x14, 0x14, 0x14, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x14, 0x14, 0x0E, 0x0E, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x05, 0x06, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x15, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x12, 0x19, 0x19, 0x19, 0x19, 0x05, 0x13,
    0x14, 0x14, 0x14, 0x14, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x14, 0x14, 0x0E, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x02, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x15, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x12, 0x19, 0x19, 0x19, 0x17, 0x12, 0x04,
    0x14, 0x14, 0x14, 0x14, 0x0D, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x14, 0x14, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x02, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x05, 0x19, 0x19, 0x17, 0x02, 0x19, 0x17,
    0x0D, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0D, 0x0D, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x06, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x05, 0x19, 0x17, 0x02, 0x05, 0x05, 0x19,
    0x05, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x05, 0x12, 0x12, 0x05, 0x12, 0x02, 0x02, 0x0B, 0x04, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x05, 0x19, 0x05, 0x12, 0x02, 0x0B, 0x12,
    0x12, 0x05, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x0B, 0x0B, 0x0B, 0x0B, 0x14, 0x14, 0x14, 0x0E, 0x04,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x02, 0x19, 0x05, 0x17, 0x17, 0x01, 0x04,
    0x19, 0x02, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x10, 0x06,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x05, 0x12, 0x05, 0x12, 0x12, 0x05, 0x02,
    0x19, 0x05, 0x13, 0x14, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0B,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x05, 0x04, 0x04, 0x04, 0x0B, 0x02,
    0x02, 0x02, 0x0B, 0x14, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x12,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x06, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x16, 0x16, 0x16, 0x16, 0x14, 0x14,
    0x14, 0x0B, 0x14, 0x14, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x04, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x16, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x05, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x06, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x16, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x04, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x02, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x04, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x06, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x01, 0x0E, 0x0B, 0x02, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0B, 0x14, 0x14, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x06, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x05, 0x0E, 0x14, 0x14, 0x14, 0x0B, 0x0B, 0x02, 0x02, 0x02, 0x0B, 0x14, 0x14, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E,
    0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x12, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x16, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E,
    0x0E, 0x04, 0x01, 0x07, 0x0E, 0x0E, 0x0E, 0x0E, 0x07, 0x04, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x06, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x06,
    0x02, 0x0D, 0x0B, 0x06, 0x02, 0x01, 0x01, 0x02, 0x04, 0x07, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x12, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0D,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0D, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x06, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x07, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0B, 0x0D, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x04, 0x05, 0x06, 0x06, 0x07, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E,
    0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x07, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x05, 0x04, 0x07, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x07, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x02, 0x06, 0x07, 0x07, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E,
    0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x07, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0x01, 0x01, 0x06, 0x06, 0x06, 0x01, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x01, 0x06, 0x06, 0x06, 0x06, 0x06,
    0x06, 0x06, 0x06, 0x06, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static GUI_CONST_STORAGE unsigned char acDolphin_11[] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0x02, 0x02, 0x02, 0x05, 0x05, 0x02, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x0D, 0x0D, 0x04, 0x0B, 0x0B, 0x02, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x05, 0x0B, 0x04, 0x04, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D,
    0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x05, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x04, 0x12, 0x12, 0x05, 0x0B, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x16, 0x14, 0x14, 0x14,
    0x14, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x14, 0x14, 0x14, 0x0B, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x14, 0x14, 0x19, 0x19, 0x19, 0x14, 0x0D, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D,
    0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x13, 0x14, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0B, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x16, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x02,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x13, 0x14, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x13, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x16, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x02, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x14, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x05, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x04, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x06, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x05, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x14, 0x16, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x05, 0x12, 0x00, 0x12, 0x02, 0x02, 0x0D, 0x16, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x0B, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x04, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x05, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x04, 0x02, 0x04, 0x14, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x06, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x02, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x04, 0x04, 0x0D, 0x14, 0x19, 0x18, 0x19, 0x14, 0x14, 0x0B, 0x0B, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x02,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x06, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x0B, 0x0B, 0x04, 0x0B, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x0B, 0x04, 0x0B, 0x14, 0x14, 0x16, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0B, 0x12, 0x19, 0x05, 0x02, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x04, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x0B, 0x02, 0x05, 0x05, 0x12,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x04, 0x14, 0x14, 0x0D, 0x0B, 0x04, 0x0B, 0x13, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x16, 0x14, 0x14, 0x02, 0x19, 0x19, 0x19, 0x17, 0x05, 0x05, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x13, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0B, 0x14, 0x14, 0x04, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x07, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x0D,
    0x0D, 0x0B, 0x04, 0x05, 0x05, 0x05, 0x02, 0x02, 0x02, 0x02, 0x11, 0x04, 0x04, 0x0B, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x05, 0x19, 0x19, 0x19, 0x19, 0x12, 0x12, 0x05, 0x0B, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x0D, 0x04, 0x05, 0x02, 0x02, 0x0B, 0x13, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0B, 0x0D, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x13, 0x13, 0x13, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x04, 0x19, 0x19, 0x19, 0x17, 0x02, 0x12, 0x12, 0x05, 0x0B, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x0B, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x05, 0x19, 0x19, 0x05, 0x17, 0x12, 0x05, 0x13, 0x17, 0x04, 0x14, 0x14,
    0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x05, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19,
    0x19, 0x18, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x02, 0x19, 0x19, 0x05, 0x1A, 0x1A, 0x05, 0x02, 0x17, 0x12, 0x04, 0x14,
    0x16, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19,
    0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x12, 0x19, 0x05, 0x12, 0x02, 0x05, 0x02, 0x02, 0x02, 0x04, 0x14,
    0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x04, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x06, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x04, 0x05, 0x02, 0x0B, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x05, 0x0B, 0x14, 0x14, 0x14, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x07, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x14, 0x14, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x15, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E,
    0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x04,
    0x07, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x06, 0x0E, 0x0E, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x04, 0x04,
    0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x06, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x07, 0x0E, 0x0E,
    0x10, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x04, 0x04,
    0x02, 0x06, 0x06, 0x02, 0x01, 0x06, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x05, 0x06,
    0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x13, 0x14,
    0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x17, 0x17,
    0x12, 0x04, 0x07, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x05,
    0x19, 0x19, 0x05, 0x05, 0x02, 0x06, 0x07, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x0E, 0x0E, 0x0E, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x02, 0x13, 0x19, 0x19, 0x19, 0x12, 0x05, 0x04, 0x06, 0x06, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E,
    0x0E, 0x0E, 0x07, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x05, 0x12, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x05, 0x05, 0x04, 0x04, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E,
    0x07, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x12, 0x12, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x17, 0x12, 0x05, 0x14, 0x14, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x07, 0x04,
    0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x12, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x02, 0x14, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x07, 0x07, 0x03, 0x04, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x02, 0x05, 0x12, 0x19, 0x19, 0x19, 0x05, 0x0D, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x0E, 0x01, 0x06, 0x06, 0x0E, 0x0E, 0x0E, 0x0E, 0x06, 0x06, 0x06, 0x06, 0x01, 0x11, 0x02, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x02, 0x11, 0x11, 0x04, 0x14, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x0E, 0x04, 0x17, 0x19, 0x12, 0x05, 0x0B, 0x0B, 0x11, 0x02, 0x05, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x02, 0x02, 0x0B, 0x14, 0x19, 0x19, 0x16, 0x14, 0x14, 0x0E, 0x0E, 0x02, 0x05, 0x05, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x04, 0x0D, 0x13, 0x14, 0x16, 0x16, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x0B, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x07, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x07, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0B, 0x0B, 0x0B, 0x0B, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static GUI_CONST_STORAGE unsigned char acDolphin_12[] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x05, 0x0B, 0x0D, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x05, 0x02, 0x14, 0x14, 0x14, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
    0x02, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x04, 0x05, 0x05, 0x12, 0x05, 0x05, 0x05, 0x02, 0x05, 0x0D,
    0x16, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0B, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x0D, 0x0D, 0x0D, 0x13, 0x14, 0x16, 0x19,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x05, 0x02, 0x14, 0x14, 0x14, 0x14, 0x14, 0x04, 0x0B, 0x0B, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x14, 0x14, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x05, 0x14, 0x14, 0x14, 0x16, 0x16, 0x16, 0x16, 0x16, 0x14, 0x14, 0x14, 0x0D, 0x04, 0x02, 0x00, 0x00, 0x05, 0x14, 0x16, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x0E, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x05, 0x14, 0x14, 0x16, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x11, 0x14, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x0D, 0x0D, 0x0D, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x0E, 0x0E, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x0B, 0x14, 0x16, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x0B, 0x14, 0x19, 0x19, 0x16, 0x14, 0x14, 0x05, 0x02, 0x05, 0x17, 0x02, 0x0B, 0x0B, 0x05, 0x0B, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x14, 0x14,
    0x14, 0x14, 0x0E, 0x0E, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x0B, 0x14, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x04, 0x0B, 0x14, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0D, 0x13, 0x19, 0x19, 0x19, 0x05, 0x05, 0x05, 0x05, 0x19, 0x05, 0x02, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E,
    0x0E, 0x0E, 0x0E, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x05, 0x13, 0x14, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x0B, 0x14, 0x14, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0D, 0x17, 0x19, 0x19, 0x17, 0x02, 0x1A, 0x12, 0x03, 0x05, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x07,
    0x0E, 0x0E, 0x0E, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x12, 0x04, 0x13, 0x19, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x04, 0x14, 0x14, 0x19, 0x19, 0x19, 0x16, 0x14, 0x14, 0x14, 0x12, 0x19, 0x19, 0x19, 0x05, 0x1A, 0x1A, 0x02, 0x11, 0x0B, 0x14, 0x19, 0x14, 0x14, 0x14, 0x0E, 0x06, 0x07,
    0x0E, 0x0E, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x13, 0x19, 0x14, 0x14, 0x04, 0x02, 0x14, 0x14, 0x19, 0x19, 0x18, 0x19, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x0B, 0x19, 0x19, 0x12, 0x12, 0x1A, 0x12, 0x0B, 0x14, 0x19, 0x16, 0x14, 0x14, 0x0E, 0x0E, 0x04, 0x0E,
    0x06, 0x02, 0x0E, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x14, 0x14, 0x04, 0x04, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x05, 0x19, 0x19, 0x05, 0x12, 0x04, 0x14, 0x19, 0x19, 0x14, 0x14, 0x14, 0x0E, 0x07, 0x11, 0x02,
    0x0B, 0x0E, 0x0E, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x14, 0x04, 0x0B, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x02, 0x17, 0x19, 0x02, 0x0D, 0x14, 0x19, 0x19, 0x14, 0x14, 0x14, 0x0E, 0x06, 0x0B, 0x14,
    0x14, 0x0E, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0B, 0x0B, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x02, 0x02, 0x04, 0x14, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x0E, 0x06, 0x14, 0x14,
    0x14, 0x0E, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0B, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x13, 0x14, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0E, 0x0E, 0x14, 0x14, 0x14,
    0x0E, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0B, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0E, 0x0E, 0x14, 0x14, 0x0E,
    0x0E, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x05, 0x0B, 0x14, 0x14, 0x14, 0x16, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x15, 0x14, 0x0E, 0x0E,
    0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x05, 0x0B, 0x13, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x07,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x0B, 0x0B, 0x14, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
    0x04, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x16, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0D, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x05, 0x0D, 0x13, 0x19, 0x19, 0x19, 0x14, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0B,
    0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x06, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x0D, 0x14, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x14, 0x14,
    0x16, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x04, 0x01, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x04, 0x0B, 0x0C, 0x0B, 0x0B, 0x05, 0x02, 0x02, 0x02, 0x02, 0x02, 0x05, 0x12, 0x12, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x05, 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x13, 0x14, 0x16, 0x19,
    0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x06, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x0B, 0x0B, 0x04, 0x00, 0x00, 0x00, 0x02, 0x14, 0x14, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x11, 0x12, 0x05, 0x02, 0x0B, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19,
    0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x04, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0B, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x02, 0x02, 0x0D, 0x14, 0x19, 0x19, 0x19, 0x14, 0x0D, 0x0D, 0x04, 0x0B, 0x04, 0x04, 0x0D, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x08, 0x04, 0x17, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x04, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x16, 0x19, 0x19, 0x14, 0x0B, 0x0D, 0x0D, 0x13, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x04, 0x13, 0x19, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x06, 0x14, 0x14, 0x14, 0x19, 0x19, 0x16, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x16, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x16, 0x16, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x07, 0x09, 0x12, 0x19, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x06, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x04, 0x02, 0x19, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x05, 0x06, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x0E, 0x07, 0x12, 0x17, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x02, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0E, 0x0E, 0x04, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0E, 0x0E, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x06, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x06, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x10, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x10, 0x10, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0E, 0x0E, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x05, 0x00, 0x00, 0x02, 0x11, 0x11, 0x02, 0x04, 0x06, 0x06, 0x04, 0x07, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E,
    0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x06, 0x04, 0x02, 0x05, 0x0D, 0x19, 0x19, 0x19, 0x19, 0x14, 0x0E, 0x0E, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0x12, 0x17, 0x12, 0x12, 0x12, 0x05, 0x02, 0x05, 0x0B, 0x0B, 0x01, 0x01,
    0x06, 0x07, 0x07, 0x07, 0x07, 0x07, 0x06, 0x01, 0x04, 0x0B, 0x05, 0x02, 0x02, 0x12, 0x17, 0x19, 0x19, 0x05, 0x14, 0x19, 0x19, 0x14, 0x14, 0x0E, 0x0E, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0x05, 0x17, 0x19, 0x19, 0x19, 0x19, 0x19, 0x17, 0x17,
    0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x05, 0x14, 0x19, 0x19, 0x14, 0x14, 0x0E, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x02, 0x05, 0x05, 0x12, 0x19, 0x19, 0x19,
    0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x17, 0x05, 0x02, 0x11, 0x0F, 0x19, 0x19, 0x14, 0x0E, 0x0D, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x02, 0x05,
    0x05, 0x05, 0x05, 0x12, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x02, 0x02, 0x05, 0x12, 0x17, 0x05, 0x14, 0x19, 0x14, 0x14, 0x0E, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x14, 0x19, 0x14, 0x0E, 0x0A, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x14, 0x14, 0x0E, 0x0E, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0B, 0x14, 0x14, 0x0E, 0x07, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x14, 0x14, 0x0E, 0x0E, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0E, 0x0E, 0x07, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x07, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static GUI_CONST_STORAGE unsigned char acDolphin_13[] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x14, 0x14, 0x13, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0D, 0x16, 0x19, 0x19, 0x13, 0x05, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x19, 0x19, 0x19, 0x16, 0x14, 0x0B, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0B, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0B, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x12, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x13, 0x16, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x11, 0x02, 0x0B, 0x05, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x0B, 0x02, 0x12, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x04, 0x02, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x04, 0x05, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x0B, 0x0B, 0x02, 0x0B, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x05, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x14, 0x14, 0x14, 0x13, 0x0B, 0x04, 0x0B, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x05,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0D, 0x04, 0x02, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x13, 0x04, 0x04, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x02, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x19, 0x19, 0x12, 0x02, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x19, 0x19, 0x19, 0x05, 0x11, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x13, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x02, 0x13, 0x14, 0x14, 0x14, 0x14, 0x16, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x19, 0x19, 0x12, 0x02, 0x02, 0x12, 0x05, 0x0D, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x12, 0x04, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x05, 0x19, 0x19, 0x05, 0x17, 0x12, 0x05, 0x19, 0x05, 0x0D, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x0B, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x05, 0x13, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x19, 0x17, 0x12, 0x1A, 0x12, 0x05, 0x19, 0x19, 0x05, 0x0D, 0x14, 0x14,
    0x14, 0x19, 0x19, 0x14, 0x05, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x12, 0x04, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x05, 0x17, 0x12, 0x12, 0x05, 0x02, 0x05, 0x05, 0x02, 0x0B, 0x14, 0x14,
    0x19, 0x19, 0x19, 0x19, 0x14, 0x0B, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x05, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x02, 0x05, 0x02, 0x0B, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19,
    0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0B, 0x02, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x0B, 0x14, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x16, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x05, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0D, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x0B, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x16, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x16, 0x14, 0x14, 0x14, 0x14, 0x10, 0x0E, 0x0E, 0x0E, 0x0E,
    0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E,
    0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x04, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x04, 0x04,
    0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x06, 0x12, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x14, 0x14, 0x14, 0x19,
    0x19, 0x19, 0x19, 0x16, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x02, 0x02, 0x04,
    0x07, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x06, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19,
    0x19, 0x16, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14,
    0x0B, 0x0B, 0x11, 0x11, 0x01, 0x11, 0x11, 0x11, 0x11, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0D, 0x14, 0x14, 0x16, 0x19, 0x19, 0x16,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x15, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x0E, 0x0E, 0x07, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x14, 0x14, 0x16, 0x19, 0x19, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x10, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x0E, 0x0E, 0x07, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x14, 0x14, 0x16, 0x19, 0x16, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E,
    0x0E, 0x0E, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x14, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E,
    0x06, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x14, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x06, 0x06, 0x06, 0x04, 0x06, 0x06, 0x06, 0x04, 0x06, 0x06, 0x01, 0x02,
    0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x13, 0x16, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x19, 0x19, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x03, 0x05, 0x05, 0x05, 0x05, 0x02, 0x11, 0x05, 0x05, 0x02, 0x02, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x14, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x07, 0x07, 0x04, 0x04, 0x14, 0x19, 0x19, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x06, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x14, 0x16, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x06, 0x06, 0x05, 0x0B, 0x05, 0x17, 0x12, 0x02, 0x14, 0x19, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x07, 0x06, 0x06, 0x0B, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x17, 0x02, 0x19, 0x19, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E,
    0x0E, 0x0E, 0x0E, 0x0E, 0x06, 0x04, 0x05, 0x17, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x02, 0x13, 0x19, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E,
    0x0E, 0x0A, 0x04, 0x0B, 0x12, 0x19, 0x19, 0x19, 0x19, 0x19, 0x17, 0x05, 0x05, 0x05, 0x05, 0x02, 0x11, 0x04, 0x16, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E,
    0x04, 0x05, 0x17, 0x19, 0x19, 0x19, 0x17, 0x12, 0x05, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x16, 0x14, 0x14, 0x14, 0x0E, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x07, 0x0B,
    0x17, 0x19, 0x19, 0x19, 0x19, 0x05, 0x05, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x14, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x14, 0x19, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x04, 0x05, 0x19,
    0x19, 0x17, 0x02, 0x02, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0B, 0x14, 0x14, 0x14, 0x0E, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x04, 0x12, 0x17, 0x02,
    0x02, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x14, 0x13, 0x06, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x07, 0x04, 0x12, 0x02, 0x05, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x07, 0x02, 0x02, 0x05, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x11, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x04, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x11, 0x13, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0D, 0x13, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x07, 0x04, 0x0E, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x05, 0x02, 0x0D, 0x14, 0x14, 0x14, 0x10, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x06, 0x05, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0x0D, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x06, 0x02, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x04, 0x0D, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x02, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0B, 0x14, 0x19, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x02,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x06,
    0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0B, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0A, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E,
    0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0B, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x03, 0x02, 0x05, 0x05, 0x06, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E,
    0x07, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x16, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x07, 0x06, 0x06, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x05, 0x04, 0x06, 0x07, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E,
    0x07, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x13, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x06, 0x06, 0x02, 0x02, 0x05, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x02, 0x06, 0x06, 0x0E, 0x0E, 0x0E,
    0x04, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x06, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x02, 0x02, 0x02,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0B, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x06, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x14, 0x0E, 0x0E, 0x06, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x0E, 0x0E, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x13, 0x0E, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static GUI_CONST_STORAGE unsigned char acDolphin_14[] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0D, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x14, 0x14, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x14, 0x14, 0x14, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x19, 0x19, 0x16, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x19, 0x19, 0x19, 0x19, 0x19, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x19, 0x19, 0x19, 0x19, 0x19, 0x16, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x19, 0x19, 0x14, 0x14, 0x14, 0x19, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0B, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x14, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x14, 0x14, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x13, 0x14, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x05, 0x05, 0x05, 0x0B, 0x0B, 0x0B, 0x04, 0x02, 0x05, 0x05, 0x04, 0x04, 0x0B, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x12, 0x02, 0x05, 0x0B, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x0D, 0x0D, 0x04, 0x04, 0x02, 0x0B, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12,
    0x02, 0x05, 0x13, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x16, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x04, 0x04, 0x02, 0x0B, 0x0D, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x02, 0x0B, 0x0D,
    0x14, 0x14, 0x16, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x0B, 0x11, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x05, 0x14, 0x14, 0x14, 0x19,
    0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x16, 0x14, 0x14, 0x14, 0x0D, 0x0B, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x04, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19,
    0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x05, 0x05, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x05, 0x0B, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19,
    0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x16, 0x14, 0x14, 0x14, 0x0B, 0x12, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x16, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x15, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x16, 0x14, 0x14, 0x13, 0x0B,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14,
    0x04, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x16,
    0x14, 0x13, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x0B, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x16, 0x16, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x05, 0x0B, 0x13, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x02, 0x17, 0x19, 0x05, 0x0D, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x02, 0x19, 0x19, 0x19, 0x19, 0x0B, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0B, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E,
    0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x05, 0x19, 0x19, 0x19, 0x19, 0x17, 0x0B,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x04, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x06, 0x0E, 0x0E,
    0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x02, 0x19, 0x19, 0x19, 0x19, 0x19, 0x12, 0x02,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x13, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x06, 0x04, 0x06, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x04, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x06, 0x04, 0x07, 0x07, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x02, 0x19, 0x19, 0x19, 0x12, 0x05, 0x05, 0x05,
    0x0B, 0x14, 0x14, 0x14, 0x14, 0x14, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x14, 0x19, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x04, 0x02, 0x00, 0x00, 0x00, 0x05,
    0x05, 0x05, 0x05, 0x12, 0x05, 0x04, 0x04, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0D, 0x02, 0x13, 0x19, 0x17, 0x05, 0x1A, 0x12, 0x12,
    0x05, 0x14, 0x14, 0x14, 0x14, 0x14, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0D, 0x19, 0x19, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x06, 0x05, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x12, 0x02, 0x05, 0x12, 0x17, 0x05, 0x04, 0x07, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0B, 0x04, 0x02, 0x02, 0x17, 0x1A, 0x12, 0x12,
    0x05, 0x14, 0x14, 0x14, 0x14, 0x14, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x19, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x04, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x02, 0x12, 0x19, 0x12, 0x02, 0x06, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x13, 0x02, 0x11, 0x01, 0x12,
    0x12, 0x14, 0x14, 0x14, 0x14, 0x14, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x19, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x04, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x05, 0x12, 0x19, 0x17, 0x05, 0x06, 0x0E, 0x0E, 0x0D, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x0D, 0x02, 0x13,
    0x12, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x16, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x02, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x02, 0x12, 0x19, 0x19, 0x12, 0x11, 0x02, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x04,
    0x05, 0x14, 0x14, 0x14, 0x14, 0x14, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x06, 0x01, 0x07, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x06, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x05, 0x02, 0x05, 0x0D, 0x19, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x04, 0x0D, 0x14, 0x14, 0x14, 0x14, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x16, 0x16, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x07, 0x06, 0x06, 0x12, 0x00, 0x02, 0x07, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x05,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x02, 0x05, 0x05, 0x0D, 0x14, 0x14, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14,
    0x14, 0x0B, 0x0B, 0x14, 0x14, 0x14, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x06, 0x02, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x02, 0x02, 0x06, 0x04, 0x04, 0x04, 0x07, 0x0E, 0x0E, 0x0B,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x14, 0x14, 0x14, 0x14, 0x16, 0x19, 0x19, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x07, 0x02, 0x07, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14,
    0x14, 0x14, 0x16, 0x19, 0x19, 0x19, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x06, 0x02, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x02, 0x12,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x14, 0x14, 0x16, 0x19, 0x19, 0x16, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x04, 0x05, 0x12, 0x12, 0x04, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x0D, 0x0B, 0x01, 0x01, 0x04, 0x0D,
    0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x13, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x06, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x07, 0x04, 0x00, 0x00, 0x00, 0x05, 0x12, 0x04, 0x07, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x02, 0x0E, 0x0E, 0x0E,
    0x14, 0x14, 0x19, 0x19, 0x19, 0x19, 0x19, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x07, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x0D, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x06, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x05, 0x04, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x06, 0x06, 0x0E, 0x0E,
    0x0E, 0x14, 0x14, 0x14, 0x16, 0x19, 0x19, 0x19, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x04, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x06, 0x06, 0x04, 0x04, 0x06, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0x02, 0x04, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x04, 0x07, 0x0E,
    0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x12, 0x0D, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x07, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0x02, 0x04, 0x0E, 0x0E, 0x0E, 0x0E, 0x04, 0x07,
    0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x12, 0x0E, 0x0E, 0x0E, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x11, 0x04, 0x07, 0x07, 0x0E, 0x04,
    0x06, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x07, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x02, 0x0E, 0x0E, 0x07, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0B, 0x0B,
    0x05, 0x02, 0x04, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x05, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x04, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x05, 0x06, 0x07, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x06, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x06, 0x04, 0x04, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

/*********************************************************************
*
*       Dolphin bitmap structures
*/
GUI_CONST_STORAGE GUI_BITMAP bmDolphin_00 =
{
    100,           // XSize
    66,            // YSize
    100,           // BytesPerLine
    8,             // BitsPerPixel
    acDolphin_00,  // Pointer to picture data (indices)
    &_PalDolphin   // Pointer to palette
};

GUI_CONST_STORAGE GUI_BITMAP bmDolphin_01 =
{
    100,           // XSize
    66,            // YSize
    100,           // BytesPerLine
    8,             // BitsPerPixel
    acDolphin_01,  // Pointer to picture data (indices)
    &_PalDolphin   // Pointer to palette
};

GUI_CONST_STORAGE GUI_BITMAP bmDolphin_02 =
{
    100,           // XSize
    66,            // YSize
    100,           // BytesPerLine
    8,             // BitsPerPixel
    acDolphin_02,  // Pointer to picture data (indices)
    &_PalDolphin   // Pointer to palette
};

GUI_CONST_STORAGE GUI_BITMAP bmDolphin_03 =
{
    100,           // XSize
    66,            // YSize
    100,           // BytesPerLine
    8,             // BitsPerPixel
    acDolphin_03,  // Pointer to picture data (indices)
    &_PalDolphin   // Pointer to palette
};

GUI_CONST_STORAGE GUI_BITMAP bmDolphin_04 =
{
    100,           // XSize
    66,            // YSize
    100,           // BytesPerLine
    8,             // BitsPerPixel
    acDolphin_04,  // Pointer to picture data (indices)
    &_PalDolphin   // Pointer to palette
};

GUI_CONST_STORAGE GUI_BITMAP bmDolphin_10 =
{
    100,           // XSize
    66,            // YSize
    100,           // BytesPerLine
    8,             // BitsPerPixel
    acDolphin_10,  // Pointer to picture data (indices)
    &_PalDolphin   // Pointer to palette
};

GUI_CONST_STORAGE GUI_BITMAP bmDolphin_11 =
{
    100,           // XSize
    66,            // YSize
    100,           // BytesPerLine
    8,             // BitsPerPixel
    acDolphin_11,  // Pointer to picture data (indices)
    &_PalDolphin   // Pointer to palette
};

GUI_CONST_STORAGE GUI_BITMAP bmDolphin_12 =
{
    100,           // XSize
    66,            // YSize
    100,           // BytesPerLine
    8,             // BitsPerPixel
    acDolphin_12,  // Pointer to picture data (indices)
    &_PalDolphin   // Pointer to palette
};

GUI_CONST_STORAGE GUI_BITMAP bmDolphin_13 =
{
    100,           // XSize
    66,            // YSize
    100,           // BytesPerLine
    8,             // BitsPerPixel
    acDolphin_13,  // Pointer to picture data (indices)
    &_PalDolphin   // Pointer to palette
};

GUI_CONST_STORAGE GUI_BITMAP bmDolphin_14 =
{
    100,           // XSize
    66,            // YSize
    100,           // BytesPerLine
    8,             // BitsPerPixel
    acDolphin_14,  // Pointer to picture data (indices)
    &_PalDolphin   // Pointer to palette
};

static GUI_CONST_STORAGE GUI_COLOR _Colorsnuvoton_qrcode[] = {
#if (GUI_USE_ARGB == 0)
  0x000000, 0xFEFEFE, 0x000000, 0x0D1CE6,
  0xA5591E, 0x888888, 0xF8F8F8, 0x060606,
  0x1A1A1A, 0xE4E4E4, 0x353535, 0xAAAAAA,
  0xBABABA, 0xC9C9C9, 0x282828, 0xEEEEEE,
  0x444444, 0xD6D6D6, 0x101010, 0x767676,
  0xA05011, 0x656565, 0x999999, 0x0413E5,
  0x545454, 0xF5F5F5, 0xF1F1F1, 0x0D0D0D,
  0xA25416, 0xA4561A, 0x151515, 0x090909,
  0x212121, 0xCDCDCD, 0xDDDDDD, 0xBDBDBD,
  0xD9D9D9, 0xE9E9E9, 0x717171, 0xB1B1B1,
  0x313131, 0xE1E1E1, 0x2533E8, 0xA1A1A1,
  0x252525, 0x2D2D2D, 0x4D4D4D, 0x626262,
  0x858585, 0xC5C5C5, 0x414141, 0xA15214,
  0xA35518, 0xADADAD, 0x1D1D1D, 0x525252,
  0x8D8D8D, 0xD7B59C, 0xEBEDFC, 0xF0F1FD,
  0x959595, 0x3D3D3D, 0x818181, 0x1524E7,
  0x4451EB, 0x797979, 0xD0D0D0, 0x595959,
  0xB67949, 0x9D9D9D, 0xC1C1C1, 0x494949,
  0x696969, 0x5D5D5D, 0x2936E9, 0x393939,
  0x2D3BE9, 0xDDC0AA, 0xA5A5A5, 0xB2B6F7,
  0xB2703E, 0x7D7D7D, 0x1D2CE8, 0x919191,
  0xB5B5B5, 0x000CE4, 0xA85E25, 0xD5B195,
  0x6D6D6D, 0x0816E6, 0x3343EA, 0x7C8AF1,
  0x202DE8, 0xABB6F6, 0xFDFCFB, 0xF2E8E1,
  0xA04F10, 0x1524E8, 0xECDDD1, 0xF1E5DD,
  0xAA622A, 0xE4CEBD, 0xD5DAFA, 0xFCFAF8,
  0xA65A20, 0xD0A889, 0xEEE1D6, 0xC69670,
  0xB2B9F7, 0xC1CAF8, 0x303CEA, 0x3C4AEB,
  0xCCA07E, 0xD9B9A0, 0xF9FAFE, 0x9D4A09,
  0xC99C78, 0xAC642E, 0xAD6832, 0xAF6A35,
  0xC39068, 0x4C5AED, 0xE0C5B1, 0xB9BDF7,
  0xCBD3F9, 0xA5571C, 0xA96026, 0xAB642C,
  0xB57645, 0xB87C4D, 0xC4926B, 0x5462ED,
  0x5D6BEE, 0xD7B59A, 0xDBBCA5, 0x818CF2,
  0xE6D1C1, 0xE9D6C8, 0xE4EAFC, 0xEDF1FD,
  0xA75C22, 0xBE875C, 0xC28D65, 0xC79872,
  0xCEA585, 0xD8B69C, 0xDCBDA6, 0xE1C9B5,
  0x9DA9F5, 0xA1ADF5, 0xB8BDF8, 0xBBC3F8,
  0xF0E3D9, 0xD9DDFB, 0xDCE2FB, 0x9E4C0D,
  0xAB632C, 0x616DEE, 0x6974F0, 0x6B79F0,
  0x7C85F1, 0xD0A788, 0xDEC2AC, 0xDFC4AF,
  0xE3CBB8, 0xE8D5C6, 0xEAD8CA, 0xF7F0EA,
  0xF8F1ED, 0xE1E4FC, 0xFAF6F4, 0xB06D39,
  0xB67847, 0xBE865B, 0xBE885E, 0xC08C62,
  0xC6956F, 0xC89974, 0x1829E7, 0x3A46EB,
  0x707CF0, 0xCDA383, 0xE4CDBA, 0x8D98F3,
  0xA5B1F6, 0xEFE2D8, 0xF0E4DA, 0xF4EBE4,
  0xFBF8F5, 0xFCF9F7, 0xA04E0F, 0xA85D23,
  0xB16F3C, 0xB47442, 0x0006E4, 0x414EEB,
  0x6573EF, 0xD4AF93, 0x8A95F3, 0x96A1F4,
  0xF4EAE2, 0xF7F1EC, 0xF9F5F2, 0xF6F9FE,
  0xFAFCFE, 0x9A4502, 0xA5581B, 0xB37341,
  0xB47341, 0xB37441, 0xC08A60, 0xCB9F7D,
  0xCBA07E, 0x101FE6, 0x2738E9, 0x4956ED,
  0x7683F1, 0xCFA788, 0xD3AE91, 0xD9B89E,
  0xDDBFA8, 0xE3CCBA, 0x8592F3, 0x919CF4,
  0xE7D4C4, 0xEBDACD, 0xECDCCF, 0xF5EDE7,
  0xF6EFE9, 0x9B4604, 0x9E4C0B, 0xAC632C,
  0xAD6630, 0xB06C37, 0xBA7F51, 0xBC8356,
  0x1827E7, 0x1728E8, 0x1F30E9, 0x505EED,
  0x5D66EE, 0x5668EE, 0x5F71EF, 0x6775F0,
  0xD1AB8D, 0xDFC4B0, 0xE1C7B4, 0x99A4F5,
  0xAFB8F7, 0xB4BFF8, 0xB7C0F7, 0xECDBCE,
  0xEEDFD4, 0xC1C6F9, 0xC8CEFA, 0xD0D7FA
#else
  0xFF000000, 0xFFFEFEFE, 0xFF000000, 0xFFE61C0D,
  0xFF1E59A5, 0xFF888888, 0xFFF8F8F8, 0xFF060606,
  0xFF1A1A1A, 0xFFE4E4E4, 0xFF353535, 0xFFAAAAAA,
  0xFFBABABA, 0xFFC9C9C9, 0xFF282828, 0xFFEEEEEE,
  0xFF444444, 0xFFD6D6D6, 0xFF101010, 0xFF767676,
  0xFF1150A0, 0xFF656565, 0xFF999999, 0xFFE51304,
  0xFF545454, 0xFFF5F5F5, 0xFFF1F1F1, 0xFF0D0D0D,
  0xFF1654A2, 0xFF1A56A4, 0xFF151515, 0xFF090909,
  0xFF212121, 0xFFCDCDCD, 0xFFDDDDDD, 0xFFBDBDBD,
  0xFFD9D9D9, 0xFFE9E9E9, 0xFF717171, 0xFFB1B1B1,
  0xFF313131, 0xFFE1E1E1, 0xFFE83325, 0xFFA1A1A1,
  0xFF252525, 0xFF2D2D2D, 0xFF4D4D4D, 0xFF626262,
  0xFF858585, 0xFFC5C5C5, 0xFF414141, 0xFF1452A1,
  0xFF1855A3, 0xFFADADAD, 0xFF1D1D1D, 0xFF525252,
  0xFF8D8D8D, 0xFF9CB5D7, 0xFFFCEDEB, 0xFFFDF1F0,
  0xFF959595, 0xFF3D3D3D, 0xFF818181, 0xFFE72415,
  0xFFEB5144, 0xFF797979, 0xFFD0D0D0, 0xFF595959,
  0xFF4979B6, 0xFF9D9D9D, 0xFFC1C1C1, 0xFF494949,
  0xFF696969, 0xFF5D5D5D, 0xFFE93629, 0xFF393939,
  0xFFE93B2D, 0xFFAAC0DD, 0xFFA5A5A5, 0xFFF7B6B2,
  0xFF3E70B2, 0xFF7D7D7D, 0xFFE82C1D, 0xFF919191,
  0xFFB5B5B5, 0xFFE40C00, 0xFF255EA8, 0xFF95B1D5,
  0xFF6D6D6D, 0xFFE61608, 0xFFEA4333, 0xFFF18A7C,
  0xFFE82D20, 0xFFF6B6AB, 0xFFFBFCFD, 0xFFE1E8F2,
  0xFF104FA0, 0xFFE82415, 0xFFD1DDEC, 0xFFDDE5F1,
  0xFF2A62AA, 0xFFBDCEE4, 0xFFFADAD5, 0xFFF8FAFC,
  0xFF205AA6, 0xFF89A8D0, 0xFFD6E1EE, 0xFF7096C6,
  0xFFF7B9B2, 0xFFF8CAC1, 0xFFEA3C30, 0xFFEB4A3C,
  0xFF7EA0CC, 0xFFA0B9D9, 0xFFFEFAF9, 0xFF094A9D,
  0xFF789CC9, 0xFF2E64AC, 0xFF3268AD, 0xFF356AAF,
  0xFF6890C3, 0xFFED5A4C, 0xFFB1C5E0, 0xFFF7BDB9,
  0xFFF9D3CB, 0xFF1C57A5, 0xFF2660A9, 0xFF2C64AB,
  0xFF4576B5, 0xFF4D7CB8, 0xFF6B92C4, 0xFFED6254,
  0xFFEE6B5D, 0xFF9AB5D7, 0xFFA5BCDB, 0xFFF28C81,
  0xFFC1D1E6, 0xFFC8D6E9, 0xFFFCEAE4, 0xFFFDF1ED,
  0xFF225CA7, 0xFF5C87BE, 0xFF658DC2, 0xFF7298C7,
  0xFF85A5CE, 0xFF9CB6D8, 0xFFA6BDDC, 0xFFB5C9E1,
  0xFFF5A99D, 0xFFF5ADA1, 0xFFF8BDB8, 0xFFF8C3BB,
  0xFFD9E3F0, 0xFFFBDDD9, 0xFFFBE2DC, 0xFF0D4C9E,
  0xFF2C63AB, 0xFFEE6D61, 0xFFF07469, 0xFFF0796B,
  0xFFF1857C, 0xFF88A7D0, 0xFFACC2DE, 0xFFAFC4DF,
  0xFFB8CBE3, 0xFFC6D5E8, 0xFFCAD8EA, 0xFFEAF0F7,
  0xFFEDF1F8, 0xFFFCE4E1, 0xFFF4F6FA, 0xFF396DB0,
  0xFF4778B6, 0xFF5B86BE, 0xFF5E88BE, 0xFF628CC0,
  0xFF6F95C6, 0xFF7499C8, 0xFFE72918, 0xFFEB463A,
  0xFFF07C70, 0xFF83A3CD, 0xFFBACDE4, 0xFFF3988D,
  0xFFF6B1A5, 0xFFD8E2EF, 0xFFDAE4F0, 0xFFE4EBF4,
  0xFFF5F8FB, 0xFFF7F9FC, 0xFF0F4EA0, 0xFF235DA8,
  0xFF3C6FB1, 0xFF4274B4, 0xFFE40600, 0xFFEB4E41,
  0xFFEF7365, 0xFF93AFD4, 0xFFF3958A, 0xFFF4A196,
  0xFFE2EAF4, 0xFFECF1F7, 0xFFF2F5F9, 0xFFFEF9F6,
  0xFFFEFCFA, 0xFF02459A, 0xFF1B58A5, 0xFF4173B3,
  0xFF4173B4, 0xFF4174B3, 0xFF608AC0, 0xFF7D9FCB,
  0xFF7EA0CB, 0xFFE61F10, 0xFFE93827, 0xFFED5649,
  0xFFF18376, 0xFF88A7CF, 0xFF91AED3, 0xFF9EB8D9,
  0xFFA8BFDD, 0xFFBACCE3, 0xFFF39285, 0xFFF49C91,
  0xFFC4D4E7, 0xFFCDDAEB, 0xFFCFDCEC, 0xFFE7EDF5,
  0xFFE9EFF6, 0xFF04469B, 0xFF0B4C9E, 0xFF2C63AC,
  0xFF3066AD, 0xFF376CB0, 0xFF517FBA, 0xFF5683BC,
  0xFFE72718, 0xFFE82817, 0xFFE9301F, 0xFFED5E50,
  0xFFEE665D, 0xFFEE6856, 0xFFEF715F, 0xFFF07567,
  0xFF8DABD1, 0xFFB0C4DF, 0xFFB4C7E1, 0xFFF5A499,
  0xFFF7B8AF, 0xFFF8BFB4, 0xFFF7C0B7, 0xFFCEDBEC,
  0xFFD4DFEE, 0xFFF9C6C1, 0xFFFACEC8, 0xFFFAD7D0
#endif
};
static GUI_CONST_STORAGE GUI_LOGPALETTE _Palnuvoton_qrcode = {
  256,  // Number of entries
  0,    // No transparency
  &_Colorsnuvoton_qrcode[0]
};
static GUI_CONST_STORAGE unsigned char _acnuvoton_qrcode[] = {
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xFC, 0x57, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x85, 0x57, 0x91, 0x7A, 0xFC, 0xBC, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x27, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x23, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x54, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x38, 0x09, 0x01, 0x01, 0x01, 0x01, 0x24, 0x05, 
        0x05, 0x27, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x31, 0x01, 0x01, 0x01, 0x01, 0x19, 0x16, 0x05, 0x3C, 0x1A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x09, 0x38, 0x05, 0x2B, 0x5E, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5E, 0x2B, 0x05, 0x38, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xBA, 0x57, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 
        0x39, 0x39, 0x39, 0x57, 0x39, 0xA3, 0x62, 0xAA, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x57, 0xCD, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x60, 0x14, 0x1C, 0x68, 0xC0, 0x74, 0xA6, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x22, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0x01, 0x01, 0x01, 0x5E, 0x0A, 0x00, 
        0x00, 0x00, 0x46, 0x01, 0x01, 0x01, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x09, 0x01, 0x01, 0x01, 0x30, 0x00, 0x00, 0x00, 0x26, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x37, 0x00, 0x00, 0x00, 0x4E, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x4E, 0x00, 0x00, 0x00, 0x37, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x92, 0xE5, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 
        0x14, 0x14, 0x14, 0x60, 0x14, 0x1C, 0x68, 0xAB, 0xB1, 0xA5, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x39, 0x14, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x04, 0x04, 0x34, 0x14, 0x7D, 0xAF, 0x6A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x01, 0x01, 0x01, 0x06, 0x1E, 0x00, 
        0x00, 0x00, 0x4E, 0x01, 0x01, 0x01, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x01, 0x01, 0x01, 0x49, 0x00, 0x00, 0x00, 0x2E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2D, 0x00, 0x00, 0x00, 0x3E, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x30, 0x00, 0x00, 0x00, 0x2D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x4D, 0x14, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 
        0x68, 0x68, 0x68, 0x68, 0x68, 0x04, 0x04, 0x1D, 0x14, 0x1D, 0xAD, 0xE2, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x39, 0x14, 0x68, 0x68, 0x04, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1D, 0x04, 0x68, 0x68, 0x04, 0x14, 0x56, 0x91, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x67, 0x08, 0x00, 
        0x00, 0x00, 0x27, 0x01, 0x01, 0x01, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x01, 0x01, 0x01, 0x48, 0x00, 0x00, 0x00, 0x43, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x4B, 0x00, 0x00, 0x00, 0x38, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3E, 0x00, 0x00, 0x00, 0x4B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x4D, 0x14, 0x68, 0x68, 0x04, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 
        0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1D, 0x04, 0x68, 0x68, 0x04, 0x33, 0x68, 0xC5, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x39, 0x14, 0x68, 0x04, 0x7E, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x81, 0xAC, 0x76, 0x1D, 0x33, 0x1D, 0x68, 0x68, 0x1D, 0x33, 0x70, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x0B, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x0A, 0x0A, 0x13, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x19, 0x58, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x2B, 0x0A, 
        0x0A, 0x2F, 0x1A, 0x01, 0x01, 0x01, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x01, 0x01, 0x01, 0x11, 0x47, 0x0A, 0x10, 0x21, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x54, 0x3D, 0x0A, 0x18, 0x09, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x19, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x27, 0x08, 0x20, 0x0A, 0x3D, 0x54, 0x01, 0x01, 0x01, 0x01, 0x06, 0x0D, 0x0D, 0x29, 0x01, 0x01, 0x01, 0x01, 0x4D, 0x14, 0x68, 0x04, 0x56, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 
        0x44, 0x44, 0x44, 0x81, 0xAC, 0x77, 0x1D, 0x33, 0x1D, 0x68, 0x68, 0x1D, 0x14, 0x8F, 0x5E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x39, 0x14, 0x68, 0x1C, 0x44, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xE4, 0xE0, 0x74, 0x64, 0x33, 0x04, 0x68, 0x04, 0x60, 0x70, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x0B, 0x00, 0x00, 0x00, 0x1F, 0x23, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x22, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x67, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4B, 0x1A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x43, 0x00, 0x00, 0x1E, 0x11, 0x01, 0x01, 0x01, 0x4D, 0x14, 0x68, 0x34, 0x50, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0xA7, 0x89, 0x70, 0xE8, 0x33, 0x04, 0x68, 0x04, 0x60, 0x8F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x39, 0x14, 0x68, 0x1C, 0x44, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x63, 0x82, 0x1C, 0x04, 0x68, 0x04, 0x33, 0x71, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x0B, 0x00, 0x00, 0x00, 0x36, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x0F, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x1E, 0x00, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x4D, 0x14, 0x68, 0x34, 0x50, 0x5E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xC8, 0x8F, 0x1C, 0x7D, 0x68, 0x04, 0x14, 0x57, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x39, 0x14, 0x68, 0x1C, 0x44, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x57, 0x1D, 0x04, 0x68, 0x1D, 0x7E, 0x63, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x0B, 0x00, 0x00, 0x00, 0x08, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x19, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x1E, 0x00, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x4D, 0x14, 0x68, 0x34, 0x50, 0x5E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x71, 0x7D, 0x7D, 0x68, 0x1D, 0x68, 0x62, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x39, 0x14, 0x68, 0x1C, 0x44, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xC5, 0x33, 0x04, 0x68, 0x14, 0x78, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x22, 0x2D, 0x07, 0x07, 0x00, 0x4E, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x1B, 0x38, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x22, 0x2C, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x47, 0x67, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x22, 0x06, 0x67, 0x01, 0x01, 0x01, 0x01, 0x01, 0x26, 0x1F, 0x07, 0x2D, 0x22, 0x01, 0x01, 0x01, 0x4D, 0x14, 0x68, 0x34, 0x50, 0x5E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x71, 0x1C, 0x04, 0x68, 0x33, 0x8D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x39, 0x14, 0x68, 0x1C, 0x44, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x67, 0x86, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x8E, 0x33, 0x68, 0x04, 0x68, 0xFC, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x19, 0x09, 0x29, 0x26, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x24, 0x01, 0x01, 0x01, 0x0F, 0x2E, 0x08, 0x08, 0x51, 0x01, 0x01, 0x01, 0x01, 0x10, 0x00, 0x00, 0x00, 0x2C, 0x31, 0x09, 0x25, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x36, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x2D, 0x0D, 0x1A, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x5E, 0x3C, 0x20, 0x08, 0x3D, 0x29, 0x01, 0x01, 0x01, 0x25, 0x10, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x19, 0x01, 0x01, 0x01, 0x42, 0x28, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x08, 0x20, 0x2B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x09, 0x09, 0x19, 0x01, 0x01, 0x01, 0x01, 0x4D, 0x14, 0x68, 0x34, 0x50, 0x5E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x86, 0x67, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x8F, 0x33, 0x68, 0x04, 0x1D, 0x89, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x39, 0x14, 0x68, 0x1C, 0x44, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xDD, 0x1C, 0x89, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x63, 0x7E, 0x7D, 0x68, 0x14, 0xB5, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x23, 0x00, 0x00, 0x00, 0x1B, 0x1A, 0x01, 0x01, 0x01, 0x10, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x1E, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2C, 0x00, 0x00, 0x00, 0x16, 0x01, 0x01, 0x01, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x13, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x4D, 0x14, 0x68, 0x34, 0x50, 0x5E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x89, 0x1C, 0xB6, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xE3, 0x75, 0x1D, 0x68, 0x14, 0xB1, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x39, 0x14, 0x68, 0x1C, 0x44, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5E, 0xEA, 0x73, 0xAE, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x6B, 0x33, 0x68, 0x1C, 0x80, 0x5E, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x01, 0x01, 0x01, 0x54, 0x00, 0x00, 0x00, 0x1F, 0x0F, 0x01, 0x01, 0x01, 0x10, 0x00, 0x00, 0x00, 0x41, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x1E, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x20, 0x00, 0x00, 0x00, 0x3C, 0x01, 0x01, 0x01, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x13, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x4D, 0x14, 0x68, 0x34, 0x50, 0x5E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x8D, 0x73, 0xEA, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x70, 0x33, 0x68, 0x1D, 0xAB, 0xAA, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x39, 0x14, 0x68, 0x1C, 0x44, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xA2, 0x1C, 0x04, 0x1D, 0xB6, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x65, 0x1C, 0x04, 0x7D, 0x56, 0x63, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x1A, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x01, 0x01, 0x01, 0x11, 0x1B, 0x00, 0x00, 0x4B, 0x06, 0x01, 0x01, 0x01, 0x10, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x10, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x18, 0x00, 0x00, 0x00, 0x23, 0x01, 0x01, 0x01, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x29, 0x01, 0x01, 0x01, 0x13, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x25, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x4D, 0x14, 0x68, 0x34, 0x50, 0x5E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0xDD, 0x1D, 0x04, 0x1C, 0xA3, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x89, 0x1D, 0x04, 0x04, 0x68, 0x62, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x39, 0x14, 0x68, 0x1C, 0x44, 0x01, 0x01, 0x01, 0x01, 0x6A, 0x7A, 0x90, 0xAE, 0x64, 0x7D, 0x68, 0x1D, 0x75, 0xD2, 0x69, 0xF6, 0x98, 0x01, 0x01, 0x01, 0xBB, 0x7F, 0x1D, 0x04, 0x1D, 0x65, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x29, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x46, 0x01, 0x01, 0x01, 0x01, 0x01, 0x42, 0x0B, 0x0B, 0x09, 0x01, 0x01, 0x01, 0x01, 0x10, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x01, 0x5E, 0x3C, 0x18, 0x18, 0x4E, 0x25, 0x35, 
        0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0C, 0x1A, 0x41, 0x18, 0x43, 0x46, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x35, 0x0B, 0x31, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x18, 0x0B, 0x0B, 0x11, 0x01, 0x01, 0x01, 0x01, 0x13, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x45, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x2B, 0x28, 0x0E, 0x18, 0x18, 0x4E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x4D, 0x14, 0x68, 0x34, 0x50, 0x5E, 0x01, 0x01, 0x01, 0x98, 0xF6, 0xA1, 
        0xD2, 0x75, 0x1D, 0x68, 0x7D, 0x64, 0xAE, 0x90, 0x7A, 0x6A, 0x01, 0x01, 0x01, 0xA8, 0x77, 0x1D, 0x04, 0x1C, 0xA3, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x39, 0x14, 0x68, 0x1C, 0x44, 0x01, 0x01, 0x01, 0x01, 0x39, 0xE6, 0x14, 0x33, 0x7D, 0x68, 0x68, 0x68, 0x1D, 0x33, 0x14, 0x9B, 0xDC, 0x01, 0x01, 0x01, 0x67, 0x50, 0x34, 0x68, 0x14, 0x4D, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x10, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x01, 0x11, 0x00, 0x00, 0x00, 0x1F, 0x0F, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x4E, 0x00, 0x00, 0x00, 0x28, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x00, 0x00, 0x00, 0x1E, 0x19, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x13, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x35, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x23, 0x00, 0x00, 0x00, 0x1F, 0x25, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x4D, 0x14, 0x68, 0x34, 0x50, 0x5E, 0x01, 0x01, 0x01, 0xDC, 0x9B, 0x14, 
        0x33, 0x1D, 0x68, 0x68, 0x68, 0x7D, 0x33, 0x14, 0xE6, 0x39, 0x01, 0x01, 0x01, 0x01, 0xAC, 0x1C, 0x68, 0x14, 0x39, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x57, 0x60, 0x68, 0x1C, 0x81, 0x01, 0x01, 0x01, 0x01, 0x01, 0x90, 0x14, 0x04, 0x68, 0x68, 0x68, 0x68, 0x68, 0x04, 0x33, 0xDA, 0x01, 0x01, 0x01, 0x01, 0x01, 0xD1, 0x34, 0x68, 0x60, 0x86, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x32, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x29, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x16, 0x00, 0x00, 0x00, 0x2C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x00, 0x00, 0x00, 0x08, 0x67, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x13, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x42, 0x00, 0x00, 0x00, 0x07, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x92, 0x60, 0x68, 0x34, 0xCF, 0x01, 0x01, 0x01, 0x01, 0x01, 0xDA, 0x33, 
        0x04, 0x68, 0x68, 0x68, 0x68, 0x68, 0x04, 0x14, 0x90, 0x01, 0x01, 0x01, 0x01, 0x01, 0x81, 0x1C, 0x68, 0x60, 0x57, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x91, 0x14, 0x68, 0x1C, 0xAC, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x6B, 0x34, 0x68, 0x68, 0x68, 0x68, 0x04, 0x34, 0xD3, 0x01, 0x01, 0x01, 0x01, 0x01, 0x67, 0xC0, 0x34, 0x68, 0x33, 0x4D, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x18, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x11, 0x00, 0x00, 0x00, 0x12, 0x0F, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x16, 0x00, 0x00, 0x00, 0x0E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0C, 0x00, 0x00, 0x00, 0x0E, 0x5E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x13, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0C, 0x00, 0x00, 0x00, 0x07, 0x11, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x4D, 0x33, 0x68, 0x34, 0xC0, 0x67, 0x01, 0x01, 0x01, 0x01, 0x01, 0xD3, 
        0x34, 0x04, 0x68, 0x68, 0x68, 0x68, 0x34, 0x6B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xAC, 0x1C, 0x68, 0x14, 0x91, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x7A, 0x1C, 0x04, 0x1D, 0x76, 0xC9, 0x01, 0x01, 0x01, 0x01, 0x01, 0xA8, 0x75, 0x1D, 0x68, 0x68, 0x68, 0x1D, 0x77, 0xBD, 0x01, 0x01, 0x01, 0x01, 0x01, 0xC8, 0x9C, 0x1D, 0x04, 0x1D, 0x65, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x31, 0x16, 0x16, 0x22, 0x01, 0x01, 0x01, 0x01, 0x22, 0x26, 0x15, 0x51, 0x0F, 0x01, 0x01, 0x01, 0x01, 0x2B, 0x15, 0x15, 0x27, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x16, 0x00, 0x00, 0x00, 0x0E, 0x01, 0x01, 0x01, 0x01, 0x25, 0x45, 0x16, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x67, 0x53, 0x15, 0x15, 0x31, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x13, 0x00, 0x00, 0x00, 0x00, 
        0x4B, 0x15, 0x15, 0x20, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x27, 0x16, 0x53, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x4B, 0x3C, 0x16, 0x23, 0x01, 0x01, 0x01, 0x01, 0x65, 0x1D, 0x04, 0x1D, 0x9C, 0xC8, 0x01, 0x01, 0x01, 0x01, 0x01, 0xBD, 
        0x77, 0x1D, 0x68, 0x68, 0x68, 0x1D, 0x75, 0xA8, 0x01, 0x01, 0x01, 0x01, 0x01, 0xC9, 0x76, 0x1D, 0x04, 0x1C, 0x7A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xFC, 0x68, 0x04, 0x04, 0x1D, 0xA5, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5F, 0x64, 0xCE, 0x04, 0x7D, 0x68, 0x1D, 0x76, 0xA7, 0x01, 0x01, 0x01, 0x01, 0x01, 0xA4, 0x1C, 0x04, 0x7D, 0x7E, 0x5F, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x11, 0x07, 0x00, 0x00, 0x28, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x16, 0x00, 0x00, 0x00, 0x0E, 0x01, 0x01, 0x01, 0x01, 0x2E, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x13, 0x00, 0x00, 0x00, 0x2D, 
        0x19, 0x01, 0x01, 0x21, 0x07, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x01, 0x01, 0x01, 0x5F, 0x7E, 0x7D, 0x04, 0x1C, 0xA4, 0x01, 0x01, 0x01, 0x01, 0x01, 0xA7, 
        0x76, 0x1D, 0x68, 0x7D, 0x04, 0xCE, 0x64, 0x5F, 0x01, 0x01, 0x01, 0x01, 0x01, 0xA5, 0x1D, 0x04, 0x04, 0x68, 0xFC, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xBC, 0xC0, 0x34, 0x68, 0x33, 0x74, 0x01, 0x01, 0x01, 0x01, 0x01, 0xA6, 0x04, 0x33, 0x1C, 0x9C, 0x1C, 0x33, 0x56, 0x6A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x82, 0x33, 0x68, 0x1C, 0xAC, 0x5E, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0C, 0x00, 0x00, 0x00, 0x1B, 0x1A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x16, 0x00, 0x00, 0x00, 0x0E, 0x01, 0x01, 0x01, 0x01, 0x2C, 0x00, 0x00, 0x00, 0x3C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x13, 0x00, 0x00, 0x00, 0x47, 
        0x01, 0x01, 0x01, 0x19, 0x12, 0x00, 0x00, 0x00, 0x23, 0x01, 0x01, 0x01, 0x3E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x5E, 0xAC, 0x1C, 0x68, 0x33, 0x82, 0x01, 0x01, 0x01, 0x01, 0x01, 0x6A, 
        0x56, 0x33, 0x1C, 0x9C, 0x1C, 0x33, 0x68, 0xA6, 0x01, 0x01, 0x01, 0x01, 0x01, 0x74, 0x33, 0x68, 0x34, 0xC0, 0xBC, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x74, 0x14, 0x68, 0x1D, 0x64, 0xC8, 0x01, 0x01, 0x01, 0x01, 0xA3, 0x73, 0xC1, 0xDC, 0xBB, 0x71, 0x50, 0xE6, 0x65, 0x01, 0x01, 0x01, 0x01, 0xB9, 0xBF, 0x7D, 0x68, 0x14, 0xD9, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0C, 0x00, 0x00, 0x00, 0x1B, 0x1A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x45, 0x00, 0x00, 0x00, 0x20, 0x01, 0x01, 0x01, 0x01, 0x2C, 0x00, 0x00, 0x00, 0x16, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x13, 0x00, 0x00, 0x00, 0x10, 
        0x01, 0x01, 0x01, 0x0F, 0x12, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x01, 0xD9, 0x14, 0x68, 0x7D, 0xBF, 0xB9, 0x01, 0x01, 0x01, 0x01, 0x65, 
        0x9B, 0x50, 0x71, 0xBB, 0xDC, 0xC1, 0x73, 0xF5, 0x01, 0x01, 0x01, 0x01, 0xC8, 0x64, 0x1D, 0x68, 0x14, 0x74, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xE1, 0x7D, 0x04, 0x68, 0x33, 0x78, 0x01, 0x01, 0x01, 0x01, 0xA4, 0x39, 0x67, 0x01, 0x01, 0x01, 0xAA, 0x57, 0x88, 0x01, 0x01, 0x01, 0x01, 0xAE, 0x33, 0x68, 0x7D, 0x8C, 0xB9, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x22, 0x11, 0x09, 0x01, 0x01, 0x01, 0x01, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x26, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5E, 0x24, 
        0x11, 0x11, 0x11, 0x11, 0x11, 0x29, 0x25, 0x2E, 0x0E, 0x2C, 0x07, 0x05, 0x11, 0x11, 0x05, 0x07, 0x00, 0x00, 0x00, 0x16, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x1A, 0x01, 0x01, 0x01, 0x01, 0x13, 0x00, 0x00, 0x00, 0x10, 
        0x01, 0x01, 0x01, 0x0F, 0x12, 0x00, 0x00, 0x00, 0x10, 0x0D, 0x11, 0x09, 0x09, 0x10, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x07, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x01, 0xB9, 0x8C, 0x7D, 0x68, 0x33, 0x8D, 0x01, 0x01, 0x01, 0x01, 0x88, 
        0x57, 0xAA, 0x01, 0x01, 0x01, 0x67, 0x39, 0xA4, 0x01, 0x01, 0x01, 0x01, 0x78, 0x33, 0x68, 0x04, 0x7D, 0xE1, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xAF, 0x14, 0x68, 0x04, 0x33, 0x57, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x69, 0x33, 0x04, 0x68, 0x14, 0x6B, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3E, 0x07, 0x00, 0x1E, 0x31, 0x01, 0x01, 0x01, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x15, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x27, 0x01, 0x01, 0x5E, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x01, 0x01, 0x01, 0x24, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x25, 0x01, 0x01, 0x01, 0x13, 0x00, 0x00, 0x00, 0x10, 
        0x01, 0x01, 0x01, 0x0F, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x23, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x27, 0x07, 0x00, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x6B, 0x14, 0x68, 0x04, 0x33, 0x69, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x57, 0x33, 0x04, 0x68, 0x14, 0xAF, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xB9, 0x56, 0x1D, 0x68, 0x7D, 0x34, 0xC5, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x69, 0x1C, 0x04, 0x68, 0x34, 0x9C, 0x5F, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x28, 0x00, 0x00, 0x00, 0x30, 0x01, 0x01, 0x01, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x1E, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2F, 0x01, 0x01, 0x01, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x01, 0x01, 0x01, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x13, 0x00, 0x00, 0x00, 0x10, 
        0x01, 0x01, 0x01, 0x0F, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5F, 0x9C, 0x34, 0x68, 0x04, 0x1C, 0x69, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xC5, 0x34, 0x7D, 0x68, 0x1D, 0x56, 0xB9, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xDB, 0x33, 0x04, 0x68, 0x7D, 0x1C, 0x8E, 0x98, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x62, 0x8D, 0x33, 0x04, 0x68, 0x7D, 0x1C, 0xA2, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x08, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x01, 0x01, 0x01, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x13, 0x00, 0x00, 0x00, 0x10, 
        0x01, 0x01, 0x01, 0x0F, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x08, 0x00, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xA2, 0x1C, 0x7D, 0x68, 0x04, 0x33, 0x8D, 0x62, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x98, 0x8E, 0x1C, 0x7D, 0x68, 0x04, 0x33, 0xDB, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xD4, 0x60, 0x04, 0x68, 0x04, 0x33, 0x7E, 0x6B, 0xB6, 0xC8, 0x67, 0x01, 0x67, 0x5F, 0xA4, 0x82, 0xBF, 0x33, 0x04, 0x68, 0x7D, 0x14, 0x69, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x27, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x11, 0x01, 0x01, 0x01, 0x29, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x13, 0x00, 0x00, 0x00, 0x10, 
        0x01, 0x01, 0x01, 0x0F, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x25, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x08, 0x00, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x69, 0x14, 0x7D, 0x68, 0x04, 0x33, 0xBF, 0x82, 
        0xA4, 0x5F, 0x67, 0x01, 0x67, 0xC8, 0xB6, 0x6B, 0x7E, 0x33, 0x04, 0x68, 0x04, 0x60, 0xD4, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x70, 0x33, 0x1D, 0x68, 0x68, 0x7D, 0x33, 0x1C, 0x7F, 0x50, 0xD0, 0xC0, 0x9C, 0x1C, 0x33, 0x7D, 0x68, 0x68, 0x1D, 0x1C, 0x69, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x0F, 0x18, 0x0E, 0x0E, 0x3C, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x26, 0x11, 0x11, 0x2B, 0x1B, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x01, 0x19, 0x15, 0x0E, 0x0E, 0x07, 0x15, 0x11, 
        0x11, 0x0B, 0x12, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x11, 0x00, 0x00, 0x00, 0x00, 0x43, 0x42, 0x11, 0x25, 0x42, 0x4B, 0x0E, 0x0A, 0x0D, 0x0F, 0x11, 0x11, 0x15, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x13, 0x00, 0x00, 0x00, 0x10, 
        0x01, 0x01, 0x01, 0x0F, 0x12, 0x00, 0x00, 0x00, 0x10, 0x0D, 0x11, 0x23, 0x20, 0x08, 0x0E, 0x28, 0x35, 0x01, 0x01, 0x01, 0x06, 0x08, 0x00, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x69, 0x1C, 0x1D, 0x68, 0x68, 0x7D, 0x33, 
        0x1C, 0x9C, 0xC0, 0xD0, 0x50, 0x7F, 0x1C, 0x33, 0x7D, 0x68, 0x68, 0x1D, 0x33, 0x70, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x71, 0x7E, 0x14, 0x04, 0x68, 0x68, 0x04, 0x1D, 0x34, 0x34, 0x34, 0x7D, 0x68, 0x68, 0x68, 0x7D, 0x14, 0x7F, 0x4D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x35, 0x00, 0x00, 0x00, 0x08, 0x06, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x0C, 0x00, 0x00, 0x00, 0x1B, 0x1A, 0x01, 0x01, 0x01, 0x32, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x01, 0x21, 0x00, 0x00, 0x00, 0x00, 0x09, 0x01, 
        0x01, 0x01, 0x37, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x11, 0x00, 0x00, 0x00, 0x00, 0x11, 0x01, 0x01, 0x01, 0x15, 0x00, 0x00, 0x00, 0x18, 0x01, 0x01, 0x01, 0x09, 0x07, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x13, 0x00, 0x00, 0x00, 0x10, 
        0x01, 0x01, 0x01, 0x0F, 0x12, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x30, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x06, 0x08, 0x00, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x4D, 0x7F, 0x14, 0x7D, 0x68, 0x68, 
        0x68, 0x7D, 0x34, 0x34, 0x34, 0x1D, 0x04, 0x68, 0x68, 0x04, 0x14, 0x7E, 0x71, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xBA, 0x78, 0x68, 0x14, 0x1C, 0x7D, 0x04, 0x68, 0x68, 0x68, 0x04, 0x7D, 0x1C, 0x14, 0x8C, 0xB0, 0x5F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x4E, 0x00, 0x00, 0x00, 0x1E, 0x06, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x0C, 0x00, 0x00, 0x00, 0x1B, 0x1A, 0x01, 0x01, 0x01, 0x10, 0x00, 0x00, 0x00, 0x41, 0x01, 0x01, 0x01, 0x21, 0x00, 0x00, 0x00, 0x00, 0x09, 0x01, 
        0x01, 0x01, 0x18, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x11, 0x00, 0x00, 0x00, 0x00, 0x22, 0x01, 0x01, 0x01, 0x49, 0x00, 0x00, 0x00, 0x2E, 0x01, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x13, 0x00, 0x00, 0x00, 0x10, 
        0x01, 0x01, 0x01, 0x0F, 0x12, 0x00, 0x00, 0x00, 0x23, 0x01, 0x01, 0x01, 0x30, 0x00, 0x00, 0x00, 0x2D, 0x01, 0x01, 0x01, 0x01, 0x36, 0x00, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5F, 0xB0, 0x8C, 0x14, 0x1C, 
        0x7D, 0x04, 0x68, 0x68, 0x68, 0x04, 0x7D, 0x1C, 0x14, 0x68, 0x78, 0xBA, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x62, 0xB5, 0x80, 0x56, 0x1D, 0x14, 0x60, 0x33, 0x1D, 0x7E, 0xAC, 0xA1, 0x6A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x31, 0x00, 0x00, 0x00, 0x3D, 0x5E, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x11, 0x07, 0x00, 0x00, 0x28, 0x06, 0x01, 0x01, 0x01, 0x10, 0x00, 0x00, 0x00, 0x18, 0x01, 0x01, 0x01, 0x2B, 0x00, 0x00, 0x00, 0x20, 0x1A, 0x01, 
        0x01, 0x01, 0x18, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x11, 0x00, 0x00, 0x00, 0x00, 0x27, 0x01, 0x01, 0x01, 0x38, 0x00, 0x00, 0x00, 0x41, 0x01, 0x01, 0x01, 0x1A, 0x20, 0x00, 0x00, 0x1B, 0x22, 0x01, 0x01, 0x01, 0x13, 0x00, 0x00, 0x00, 0x10, 
        0x01, 0x01, 0x01, 0x0F, 0x12, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x0B, 0x00, 0x00, 0x00, 0x43, 0x01, 0x01, 0x01, 0x22, 0x1B, 0x00, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x6A, 0xA1, 0xAC, 
        0x7E, 0x1D, 0x33, 0x60, 0x14, 0x1D, 0x56, 0x80, 0xB5, 0x62, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5E, 0x63, 0x65, 0x4D, 0x86, 0xA2, 0x65, 0x63, 0x5E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x23, 0x16, 0x16, 0x29, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x31, 0x16, 0x16, 0x22, 0x01, 0x01, 0x01, 0x01, 0x10, 0x00, 0x00, 0x00, 0x00, 0x2E, 0x15, 0x49, 0x1E, 0x43, 0x16, 0x16, 0x11, 0x01, 0x01, 
        0x01, 0x01, 0x18, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x11, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x2F, 0x15, 0x05, 0x1A, 0x0B, 0x16, 0x4E, 0x19, 0x01, 0x01, 0x01, 0x01, 0x11, 0x16, 0x16, 0x0D, 0x01, 0x01, 0x01, 0x01, 0x13, 0x00, 0x00, 0x00, 0x10, 
        0x01, 0x01, 0x01, 0x0F, 0x12, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x27, 0x16, 0x2B, 0x25, 0x2B, 0x15, 0x15, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5E, 
        0x63, 0x65, 0xA2, 0x86, 0x4D, 0x65, 0x63, 0x5E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x18, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x35, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x13, 0x00, 0x00, 0x00, 0x10, 
        0x01, 0x01, 0x01, 0x0F, 0x12, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x30, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x18, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x41, 0x00, 0x00, 0x00, 0x10, 
        0x01, 0x01, 0x01, 0x1A, 0x12, 0x00, 0x00, 0x00, 0x23, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x35, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x00, 0x00, 0x00, 0x3C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x47, 0x00, 0x00, 0x00, 0x43, 0x01, 0x01, 0x01, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x48, 0x00, 0x00, 0x00, 0x4B, 
        0x01, 0x01, 0x01, 0x25, 0x1B, 0x00, 0x00, 0x00, 0x35, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x11, 0x0B, 0x0B, 0x29, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x35, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 
        0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x48, 0x1B, 0x2E, 0x18, 0x26, 0x1A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x11, 0x49, 0x18, 0x32, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x25, 0x35, 
        0x0B, 0x41, 0x07, 0x00, 0x00, 0x00, 0x1F, 0x30, 0x0B, 0x4E, 0x4B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x01, 0x01, 0x01, 0x01, 0x0D, 0x0B, 0x35, 0x25, 0x01, 0x01, 0x01, 0x01, 0x19, 0x27, 0x0B, 0x05, 0x1B, 0x00, 0x00, 0x00, 0x07, 
        0x26, 0x0B, 0x0B, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x45, 0x0B, 0x23, 0x01, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x16, 0x0B, 0x0C, 0x5E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x29, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x46, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x29, 0x1E, 0x00, 0x00, 0x0E, 0x1A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x43, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x10, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x01, 0x01, 0x01, 0x0D, 0x1F, 0x00, 0x00, 0x10, 0x01, 0x01, 0x01, 0x01, 0x2F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2B, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x53, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1A, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x29, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x38, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x06, 0x1E, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x01, 0x01, 0x01, 0x0B, 0x00, 0x00, 0x00, 0x1E, 0x06, 0x01, 0x01, 0x01, 0x2D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x28, 0x01, 0x01, 0x01, 0x06, 0x08, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x01, 0x01, 0x01, 0x0B, 0x00, 0x00, 0x00, 0x08, 0x01, 0x01, 0x01, 0x01, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x19, 0x43, 0x08, 0x08, 0x26, 0x5E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1A, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x5E, 0x3C, 0x20, 0x08, 0x1B, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x1F, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x19, 0x01, 0x01, 0x01, 0x01, 0x24, 0x0A, 0x08, 0x20, 0x2B, 0x01, 0x01, 0x01, 0x06, 0x08, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1B, 0x0A, 0x42, 0x09, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00, 0x38, 0x09, 0x09, 0x06, 0x4E, 0x20, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1E, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x28, 0x42, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x2D, 0x31, 0x01, 0x01, 0x01, 0x01, 0x5E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x1A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5E, 0x26, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x24, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x11, 0x2C, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x47, 0x67, 0x06, 0x06, 0x24, 0x0E, 0x00, 0x00, 0x00, 
        0x20, 0x42, 0x06, 0x19, 0x38, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x23, 0x08, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x0A, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x67, 0x01, 0x01, 0x01, 0x01, 0x06, 0x08, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x27, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x24, 0x20, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x3D, 0x19, 0x67, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0F, 0x2F, 
        0x00, 0x00, 0x00, 0x00, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x38, 0x19, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x19, 0x47, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 
        0x2C, 0x11, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x01, 0x01, 0x01, 0x15, 0x00, 0x00, 0x00, 
        0x18, 0x01, 0x01, 0x01, 0x25, 0x07, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x08, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x23, 
        0x00, 0x00, 0x00, 0x12, 0x19, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x07, 0x25, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x16, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x01, 0x01, 0x01, 0x2F, 0x00, 0x00, 0x00, 
        0x2E, 0x01, 0x01, 0x01, 0x09, 0x07, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x36, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x23, 
        0x00, 0x00, 0x00, 0x12, 0x1A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x3C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x06, 0x01, 0x01, 0x01, 0x4E, 0x07, 0x00, 0x00, 
        0x3C, 0x01, 0x01, 0x01, 0x09, 0x07, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x27, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x22, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x23, 0x1F, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2B, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0C, 
        0x00, 0x00, 0x00, 0x12, 0x0F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x0E, 0x00, 0x00, 0x3D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x12, 0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x13, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0E, 0x12, 0x2B, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0F, 0x35, 0x4B, 0x0A, 0x43, 0x0F, 0x11, 0x0D, 0x42, 
        0x01, 0x01, 0x01, 0x01, 0x09, 0x07, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x01, 0x24, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x13, 0x0A, 0x0A, 0x1B, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0A, 0x0A, 0x3E, 0x5E, 0x01, 0x01, 0x01, 0x01, 0x11, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x31, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x0A, 0x18, 0x09, 0x01, 0x01, 0x01, 0x0C, 
        0x00, 0x00, 0x00, 0x12, 0x0F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x09, 0x18, 0x0A, 0x3D, 0x0C, 0x25, 0x0D, 0x0D, 0x1A, 0x2B, 0x0A, 0x0A, 0x2F, 0x1A, 0x01, 0x01, 0x01, 0x25, 0x43, 0x0A, 0x28, 0x07, 0x00, 0x00, 0x00, 0x00, 0x37, 0x31, 0x0D, 
        0x22, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x00, 0x00, 0x00, 0x2B, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x09, 0x07, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x29, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x01, 0x01, 0x01, 0x0C, 
        0x00, 0x00, 0x00, 0x12, 0x0F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x38, 0x00, 0x00, 0x00, 0x4B, 0x01, 0x01, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x27, 0x01, 0x01, 0x01, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x20, 0x00, 0x00, 0x00, 0x3C, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x25, 0x07, 0x00, 0x00, 0x00, 0x42, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x01, 0x01, 0x01, 0x46, 
        0x00, 0x00, 0x00, 0x12, 0x19, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x30, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x5E, 0x08, 0x00, 0x00, 0x00, 0x35, 0x01, 0x01, 0x01, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x47, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x10, 0x00, 0x00, 0x00, 0x27, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x22, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4E, 0x01, 0x01, 0x01, 0x16, 
        0x00, 0x00, 0x00, 0x1F, 0x11, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x20, 0x19, 0x01, 0x01, 0x29, 0x12, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x3C, 0x13, 0x58, 0x08, 0x00, 0x00, 0x00, 0x00, 0x2D, 0x30, 0x05, 0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x13, 0x41, 0x11, 0x01, 0x01, 0x01, 0x01, 0x22, 0x38, 0x05, 0x0B, 0x01, 0x01, 0x01, 0x01, 
        0x5E, 0x2B, 0x13, 0x13, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x08, 0x58, 0x13, 0x3C, 0x06, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x38, 0x19, 0x01, 0x01, 0x01, 0x01, 0x23, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x05, 0x05, 0x31, 0x11, 0x41, 0x13, 0x16, 0x5E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0D, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x2B, 0x1A, 0x38, 0x13, 0x48, 0x1E, 
        0x00, 0x00, 0x00, 0x00, 0x2D, 0x13, 0x13, 0x0B, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x32, 0x13, 0x13, 0x28, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x15, 0x13, 0x2F, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x01, 0x01, 
        0x01, 0x0F, 0x05, 0x13, 0x30, 0x25, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x01, 0x01, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x19, 0x01, 0x01, 0x01, 0x3D, 0x00, 0x00, 0x00, 0x35, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x38, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x01, 0x01, 
        0x01, 0x51, 0x00, 0x00, 0x00, 0x58, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x25, 0x01, 0x01, 0x01, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x4E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2D, 0x01, 0x01, 0x01, 0x01, 0x2C, 0x00, 0x00, 0x00, 0x16, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x26, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x01, 0x01, 
        0x01, 0x49, 0x00, 0x00, 0x00, 0x2E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x25, 0x01, 0x01, 0x01, 0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x51, 0x01, 0x01, 0x01, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x01, 0x01, 0x01, 0x01, 0x20, 0x00, 0x00, 0x00, 0x16, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3E, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x01, 0x01, 
        0x01, 0x58, 0x00, 0x00, 0x00, 0x49, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x36, 0x10, 0x10, 0x16, 0x01, 0x01, 0x01, 0x01, 0x11, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x47, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x19, 0x23, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x31, 
        0x1A, 0x26, 0x10, 0x32, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x2B, 0x0C, 0x46, 0x19, 0x41, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x49, 0x25, 0x42, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x25, 0x01, 0x01, 
        0x01, 0x01, 0x18, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x10, 0x32, 0x1B, 0x58, 0x0C, 0x0C, 0x58, 0x00, 0x00, 0x00, 0x00, 0x16, 0x01, 0x01, 0x01, 0x01, 0x11, 0x0C, 0x23, 0x1A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x09, 0x49, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x25, 0x2F, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4B, 0x10, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x01, 0x01, 
        0x01, 0x22, 0x43, 0x10, 0x18, 0x11, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x08, 0x22, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x38, 0x01, 0x01, 0x01, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x51, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0C, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x19, 0x01, 
        0x01, 0x01, 0x18, 0x00, 0x00, 0x00, 0x4B, 0x19, 0x01, 0x01, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x01, 0x01, 0x01, 0x42, 0x12, 0x00, 0x00, 0x2E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x0C, 0x07, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0D, 0x1F, 0x00, 0x00, 0x00, 0x26, 0x01, 0x01, 0x01, 0x2F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x2E, 0x01, 0x01, 0x01, 0x25, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x01, 
        0x01, 0x01, 0x18, 0x00, 0x00, 0x00, 0x48, 0x01, 0x01, 0x01, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x01, 0x01, 0x01, 0x0B, 0x00, 0x00, 0x00, 0x1E, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x19, 0x12, 0x00, 0x00, 0x00, 0x23, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x27, 0x01, 0x01, 0x01, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x37, 0x01, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x25, 0x01, 
        0x01, 0x01, 0x18, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x01, 0x01, 0x01, 0x35, 0x00, 0x00, 0x00, 0x1E, 0x5E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x0F, 0x12, 0x00, 0x00, 0x00, 0x23, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x1E, 0x00, 0x00, 0x00, 0x35, 0x01, 0x01, 0x01, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x1B, 0x27, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x5E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x67, 0x0F, 0x1A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x1E, 0x12, 0x12, 0x12, 0x12, 0x12, 0x36, 
        0x27, 0x01, 0x01, 0x01, 0x67, 0x2F, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x12, 0x08, 0x2B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x0F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x0F, 
        0x0F, 0x31, 0x08, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x22, 0x0F, 0x29, 0x47, 0x00, 0x12, 0x12, 0x51, 0x01, 0x0F, 0x0F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x19, 0x0F, 0x1A, 0x01, 
        0x01, 0x01, 0x01, 0x0F, 0x12, 0x00, 0x00, 0x00, 0x43, 0x09, 0x0F, 0x19, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x51, 0x12, 0x12, 0x00, 0x47, 0x29, 0x0F, 0x22, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x00, 0x26, 0x25, 0x0F, 
        0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x4B, 0x09, 0x01, 0x01, 0x01, 0x22, 0x28, 0x12, 0x1E, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1A, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x19, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x0F, 0x27, 0x1B, 0x00, 0x00, 0x00, 0x0A, 0x11, 0x0F, 0x1A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x26, 0x12, 0x12, 0x32, 0x25, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 
        0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x12, 0x1B, 0x1E, 0x31, 0x0F, 0x0F, 0x01, 0x2F, 0x12, 0x12, 0x2E, 0x1A, 0x01, 0x01, 0x01, 0x0D, 0x2C, 0x12, 0x08, 0x2B, 
        0x01, 0x01, 0x01, 0x0F, 0x12, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x12, 0x2C, 0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x0F, 0x31, 0x1E, 0x1B, 0x12, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x4E, 0x0F, 0x0F, 0x4E, 0x00, 0x12, 0x12, 
        0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0E, 0x42, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x16, 0x00, 0x00, 0x00, 0x20, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1A, 0x1F, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x01, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x13, 0x00, 0x00, 0x00, 0x32, 
        0x01, 0x01, 0x01, 0x0F, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2C, 0x01, 0x01, 0x01, 0x01, 0x2C, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x01, 0x01, 0x01, 0x45, 0x00, 0x00, 0x00, 0x0E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x30, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x19, 0x12, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2F, 0x01, 0x01, 0x01, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x01, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x41, 0x00, 0x00, 0x00, 0x10, 
        0x01, 0x01, 0x01, 0x0F, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x01, 0x01, 0x01, 0x2F, 0x00, 0x00, 0x00, 0x12, 0x11, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x22, 0x1E, 0x00, 0x00, 0x07, 0x54, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0C, 0x00, 0x00, 0x00, 0x1E, 0x24, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x01, 0x01, 0x01, 0x19, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x01, 0x01, 0x01, 0x19, 0x0A, 0x00, 0x00, 0x36, 0x0F, 0x01, 0x01, 0x67, 0x47, 0x00, 0x00, 0x00, 0x10, 
        0x01, 0x01, 0x01, 0x06, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x2D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0x01, 0x01, 0x01, 0x11, 0x12, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x54, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4B, 0x10, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x48, 0x1A, 0x01, 0x01, 0x01, 
        0x19, 0x26, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x36, 0x4B, 0x27, 0x0C, 0x42, 0x01, 0x01, 0x01, 0x01, 0x06, 0x41, 0x10, 0x10, 0x12, 0x43, 0x0C, 0x0C, 0x22, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x07, 0x13, 0x0C, 0x0C, 0x2F, 0x00, 0x00, 
        0x00, 0x00, 0x0E, 0x0B, 0x0C, 0x0D, 0x1A, 0x48, 0x10, 0x47, 0x0C, 0x09, 0x0C, 0x0C, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x01, 0x01, 0x01, 0x01, 0x25, 0x0C, 0x0C, 0x29, 0x31, 0x2E, 0x10, 0x28, 0x00, 0x00, 0x00, 0x00, 0x10, 
        0x01, 0x01, 0x01, 0x01, 0x0F, 0x0C, 0x0C, 0x3E, 0x07, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x35, 0x10, 0x10, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x53, 0x0C, 0x23, 0x1A, 0x38, 0x10, 0x10, 0x08, 0x00, 0x00, 0x00, 
        0x00, 0x20, 0x4E, 0x0C, 0x0B, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x2F, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x42, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2B, 0x01, 0x01, 0x01, 
        0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x31, 0x00, 0x00, 0x00, 0x1F, 0x25, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x2D, 0x01, 0x01, 0x01, 0x06, 0x1E, 0x00, 
        0x00, 0x00, 0x2B, 0x01, 0x01, 0x01, 0x2B, 0x00, 0x00, 0x00, 0x2D, 0x01, 0x01, 0x01, 0x01, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3D, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x67, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0x01, 0x01, 0x01, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x53, 0x01, 0x01, 0x01, 0x2B, 0x00, 0x00, 0x00, 0x1E, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x01, 0x01, 0x01, 
        0x4E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x23, 0x00, 0x00, 0x00, 0x1B, 0x1A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x38, 0x00, 0x00, 0x00, 0x28, 0x01, 0x01, 0x01, 0x67, 0x08, 0x00, 
        0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x3C, 0x00, 0x00, 0x00, 0x20, 0x01, 0x01, 0x01, 0x01, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x32, 0x00, 0x00, 0x00, 0x26, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x2B, 0x01, 0x01, 0x01, 0x27, 0x00, 0x00, 0x00, 0x36, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x35, 0x01, 0x01, 0x01, 
        0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2B, 0x00, 0x00, 0x00, 0x20, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x58, 0x00, 0x00, 0x00, 0x2E, 0x01, 0x01, 0x01, 0x5E, 0x2D, 0x00, 
        0x00, 0x00, 0x23, 0x01, 0x01, 0x01, 0x35, 0x00, 0x00, 0x00, 0x3D, 0x01, 0x01, 0x01, 0x01, 0x3D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2D, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x43, 0x00, 0x00, 0x00, 0x38, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x3E, 0x01, 0x01, 0x01, 0x53, 0x00, 0x00, 0x00, 0x12, 0x25, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x32, 0x13, 0x13, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x13, 0x26, 0x36, 0x00, 0x00, 0x00, 0x00, 0x36, 0x26, 0x13, 0x16, 0x5E, 0x01, 0x01, 0x01, 
        0x5E, 0x2B, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x27, 0x09, 0x38, 0x05, 0x05, 0x05, 0x05, 0x05, 0x51, 0x08, 0x10, 0x13, 0x13, 0x0D, 0x11, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x26, 0x1B, 0x43, 0x13, 0x51, 0x22, 0x01, 0x01, 0x01, 0x01, 0x42, 0x41, 
        0x13, 0x2B, 0x5E, 0x01, 0x01, 0x01, 0x5E, 0x16, 0x13, 0x41, 0x11, 0x01, 0x01, 0x01, 0x01, 0x11, 0x41, 0x13, 0x13, 0x13, 0x13, 0x13, 0x30, 0x25, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x22, 0x51, 0x13, 0x13, 0x13, 0x13, 0x13, 0x48, 0x1E, 
        0x18, 0x05, 0x05, 0x42, 0x01, 0x01, 0x01, 0x01, 0x09, 0x3E, 0x13, 0x38, 0x19, 0x01, 0x01, 0x01, 0x01, 0x23, 0x05, 0x05, 0x21, 0x42, 0x41, 0x13, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x11, 0x00, 0x00, 0x00, 0x00, 0x36, 0x26, 0x13, 
        0x18, 0x12, 0x13, 0x05, 0x41, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x3D, 0x05, 0x05, 0x23, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x20, 0x19, 0x01, 0x01, 0x29, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x47, 0x01, 0x01, 0x01, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x5E, 0x01, 0x01, 0x01, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x16, 
        0x00, 0x00, 0x00, 0x0E, 0x19, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x22, 0x07, 0x00, 0x00, 0x08, 0x06, 0x01, 0x01, 0x01, 0x3D, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x11, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 
        0x01, 0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x22, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x5E, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x01, 0x01, 0x01, 0x22, 0x00, 0x00, 0x00, 0x00, 0x22, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x01, 0x01, 0x01, 0x0F, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x23, 
        0x00, 0x00, 0x00, 0x1F, 0x0F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x09, 0x01, 0x01, 0x01, 0x43, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x11, 0x00, 0x00, 0x00, 0x00, 0x22, 0x01, 0x01, 
        0x01, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x06, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x22, 0x00, 0x00, 0x00, 0x00, 0x22, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x47, 0x01, 0x01, 0x01, 0x1A, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 
        0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x46, 
        0x00, 0x00, 0x00, 0x12, 0x1A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x07, 0x09, 0x01, 0x01, 0x01, 0x18, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x11, 0x00, 0x00, 0x00, 0x00, 0x11, 0x01, 0x01, 
        0x01, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x06, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x5E, 0x3E, 0x0A, 0x0A, 0x3E, 0x19, 0x21, 0x0D, 0x22, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x1A, 0x0D, 0x0D, 0x30, 0x07, 0x00, 0x00, 0x00, 0x00, 0x2C, 0x0A, 0x32, 0x46, 0x01, 0x01, 0x01, 0x01, 0x3C, 0x0A, 0x0A, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x01, 0xA9, 0xF0, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 
        0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x9E, 0x3A, 0x01, 0x01, 0x01, 0x19, 
        0x58, 0x0A, 0x0A, 0x3C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x42, 0x0D, 0x24, 0x01, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x07, 0x09, 0x01, 0x01, 0x01, 0x18, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x11, 0x00, 0x00, 0x00, 0x00, 0x11, 0x01, 0x01, 
        0x01, 0x11, 0x47, 0x0A, 0x2D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x0A, 0x0A, 0x13, 0x19, 0x21, 0x0D, 0x22, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x06, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x48, 0x00, 0x00, 0x12, 0x0D, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x19, 0x3D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2E, 0x19, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x22, 0x20, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0xCC, 0x83, 0x55, 0x59, 0x59, 0x59, 0x59, 0x59, 
        0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x55, 0x9E, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x30, 0x00, 0x00, 0x1F, 0x27, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x07, 0x09, 0x01, 0x01, 0x01, 0x18, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x11, 0x00, 0x00, 0x00, 0x00, 0x11, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x5E, 0x48, 0x00, 0x00, 0x00, 0x1F, 0x23, 0x01, 0x01, 0x01, 0x13, 0x00, 0x00, 0x1B, 0x23, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x06, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x20, 0x00, 0x00, 0x00, 0x3C, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x10, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x3A, 0x52, 0x59, 0xD5, 0xD5, 0x03, 0x03, 0x03, 
        0xD5, 0xD5, 0x03, 0x03, 0xD5, 0xD5, 0x03, 0x59, 0x17, 0x17, 0x59, 0xD5, 0xB2, 0xEE, 0x2A, 0x2A, 0xEE, 0xB2, 0xD5, 0x17, 0x17, 0x17, 0x59, 0x03, 0x03, 0xD5, 0xD5, 0x03, 0x03, 0x03, 0xD5, 0xD5, 0xD5, 0xD5, 0x03, 0x59, 0x4C, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3D, 0x00, 0x00, 0x00, 0x26, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x07, 0x09, 0x01, 0x01, 0x01, 0x18, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x24, 0x00, 0x00, 0x00, 0x00, 0x24, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x27, 0x00, 0x00, 0x00, 0x08, 0x01, 0x01, 0x01, 0x01, 0x28, 0x00, 0x00, 0x00, 0x30, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x06, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x00, 0x00, 0x00, 0x16, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x25, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x10, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x3A, 0x5C, 0x59, 0xD5, 0x03, 0x03, 0xD5, 0xD5, 
        0xD5, 0x03, 0xD5, 0x03, 0x59, 0x17, 0x03, 0x6E, 0x84, 0xB7, 0xF8, 0xFE, 0x9A, 0x8A, 0x3A, 0x3A, 0x8A, 0x99, 0xFE, 0x5D, 0xDE, 0x83, 0xD6, 0x59, 0x17, 0x03, 0xD5, 0xD5, 0x03, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0x03, 0x59, 0x4C, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x32, 0x00, 0x00, 0x00, 0x41, 0x01, 0x01, 0x01, 0x42, 0x00, 0x00, 0x00, 0x07, 0x25, 0x01, 0x01, 0x01, 0x18, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x22, 0x00, 0x00, 0x00, 0x00, 0x22, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x00, 0x00, 0x00, 0x1E, 0x06, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x26, 0x1F, 0x07, 0x07, 0x07, 0x07, 0x07, 0x1E, 0x0C, 0x01, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x27, 0x07, 0x07, 0x07, 0x2C, 0x22, 0x01, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x19, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x10, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x3A, 0x5C, 0x59, 0xD5, 0x03, 0xD5, 0xD5, 0xD5, 
        0xD5, 0xD5, 0x03, 0x17, 0xEE, 0xB4, 0xFD, 0x3B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x8B, 0x97, 0x9F, 0x52, 0x17, 0x03, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0x59, 0x6E, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x16, 0x12, 0x07, 0x00, 0x2D, 0x22, 0x06, 0x1A, 0x26, 0x00, 0x00, 0x00, 0x00, 0x38, 0x19, 0x06, 0x42, 0x20, 0x00, 0x00, 0x00, 0x0E, 0x24, 0x06, 0x19, 0x3E, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x19, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x5E, 0x09, 0x2D, 0x07, 0x1F, 0x26, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x25, 0x09, 0x3D, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x15, 0x22, 0x09, 0x1A, 0x0D, 0x2D, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x10, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x3A, 0x5C, 0x59, 0xD5, 0x03, 0x03, 0x03, 0xD5, 
        0xD5, 0x17, 0xB2, 0x87, 0x8A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x9A, 0xB4, 0xD5, 0x59, 0xD5, 0xD5, 0x03, 0x03, 0xD5, 0xD5, 0x59, 0x6E, 0x01, 0x01, 0x01, 0x0F, 
        0x2E, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x2E, 0x1A, 0x25, 0x09, 0x0D, 0x0E, 0x1B, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x0E, 0x23, 0x19, 0x09, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x01, 0x01, 0x01, 0x15, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x10, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x3A, 0x5C, 0x59, 0xD5, 0xD5, 0xD5, 0x03, 0xD5, 
        0x17, 0x6F, 0xFF, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xFA, 0xD6, 0x17, 0xD5, 0xD5, 0x03, 0xD5, 0xD5, 0x59, 0x6E, 0x01, 0x01, 0x01, 0x23, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x01, 0x01, 0x01, 0x48, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3D, 0x00, 0x00, 0x00, 0x26, 0x01, 0x01, 0x3A, 0x5C, 0x59, 0xD5, 0x03, 0xD5, 0xD5, 0x17, 
        0x40, 0x3A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x99, 0x5A, 0x59, 0xD5, 0xD5, 0xD5, 0x03, 0x59, 0x6E, 0x01, 0x01, 0x01, 0x0C, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0x01, 0x01, 0x01, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x5E, 0x32, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x26, 0x00, 0x00, 0x00, 0x2B, 0x01, 0x01, 0x3A, 0x5C, 0x59, 0xD5, 0xD5, 0xD5, 0x59, 0xD6, 
        0xA9, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3B, 0xCB, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x66, 0x52, 0x59, 0xD5, 0xD5, 0xD5, 0x59, 0x6E, 0x01, 0x01, 0x01, 0x0C, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x22, 0x01, 0x01, 0x01, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x19, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x25, 0x36, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x22, 0x2F, 0x18, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x37, 0x18, 0x0A, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x2B, 0x0B, 0x46, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x19, 0x27, 0x0B, 0x23, 0x01, 0x01, 0x01, 0x3A, 0x5C, 0x59, 0x03, 0x03, 0x03, 0x59, 0xB8, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x72, 0xF8, 0xC4, 0xC3, 0x6E, 0x5A, 0x40, 0x9F, 0xFA, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xDF, 0x17, 0x03, 0x03, 0xD5, 0x59, 0x6E, 0x01, 0x01, 0x01, 0x0C, 
        0x00, 0x00, 0x00, 0x00, 0x2E, 0x0B, 0x0B, 0x42, 0x11, 0x49, 0x18, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x16, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x4E, 0x4B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3A, 0x5C, 0x03, 0x03, 0x03, 0x59, 0xB3, 0x72, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x9A, 0x40, 0x17, 0x17, 0x17, 0x59, 0x59, 0x17, 0x17, 0x17, 0x83, 0x3A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x8B, 0xD6, 0x59, 0xD5, 0xD5, 0x59, 0x6E, 0x01, 0x01, 0x01, 0x0C, 
        0x00, 0x00, 0x00, 0x1B, 0x25, 0x01, 0x01, 0x01, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x30, 0x00, 0x00, 0x00, 0x28, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3A, 0x5C, 0x59, 0xD5, 0xD5, 0x17, 0xA0, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3A, 0xB3, 0x55, 0x03, 0xD5, 0xD5, 0x03, 0xD5, 0x03, 0xD5, 0x03, 0x55, 0x79, 0xCB, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x9D, 0x17, 0x03, 0x03, 0x59, 0x6E, 0x01, 0x01, 0x01, 0x0C, 
        0x00, 0x00, 0x00, 0x1B, 0x1A, 0x01, 0x01, 0x01, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x16, 0x00, 0x00, 0x00, 0x10, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3A, 0x5C, 0x59, 0xD5, 0x03, 0x59, 0xB8, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x87, 0x55, 0x03, 0xD5, 0xD5, 0xD5, 0xD5, 0x03, 0xD5, 0xD5, 0xD5, 0x03, 0x55, 0xF7, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xB7, 0x17, 0xD5, 0xD5, 0x59, 0x6E, 0x01, 0x01, 0x01, 0x0D, 
        0x00, 0x00, 0x00, 0x08, 0x5E, 0x01, 0x01, 0x01, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x09, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x19, 0x30, 0x15, 0x58, 0x11, 0x0D, 0x16, 0x16, 0x11, 0x01, 0x01, 0x01, 0x01, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2D, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 
        0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x0A, 0x0E, 0x53, 0x16, 0x27, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x22, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x35, 0x5E, 0x01, 0x01, 0x3A, 0x5C, 0x59, 0x03, 0x03, 0x03, 0x7B, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xCB, 0x5A, 0x59, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0x17, 0x40, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x95, 0x17, 0xD5, 0xD5, 0x59, 0x6E, 0x01, 0x01, 0x01, 0x5E, 
        0x16, 0x15, 0x15, 0x23, 0x22, 0x16, 0x16, 0x2F, 0x12, 0x43, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x08, 0x05, 0x16, 0x16, 0x16, 0x16, 0x16, 0x45, 0x25, 0x0B, 0x15, 0x15, 0x2D, 0x00, 0x00, 0x00, 
        0x00, 0x07, 0x18, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x09, 0x1B, 0x00, 0x00, 0x20, 0x1A, 0x01, 0x01, 0x01, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x08, 0x00, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x01, 0x01, 0x3A, 0x5C, 0x59, 0xD5, 0x03, 0x59, 0x7B, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x99, 0x3F, 0x03, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0x03, 0xD5, 0x59, 0xEE, 0x3A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5D, 0x17, 0xD5, 0xD5, 0x59, 0x6E, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x28, 0x00, 0x00, 0x00, 0x53, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x24, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2E, 0x01, 0x01, 0x01, 0x09, 0x1E, 0x00, 0x00, 
        0x00, 0x26, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x20, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x09, 0x01, 0x01, 0x01, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x30, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x01, 0x01, 0x3A, 0x5C, 0x59, 0xD5, 0x03, 0x03, 0x7B, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xFE, 0x03, 0x03, 0x03, 0xD5, 0xD5, 0x03, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0x03, 0xED, 0x99, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5D, 0x17, 0xD5, 0xD5, 0x59, 0x6E, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x1A, 0x1B, 0x00, 0x00, 0x00, 0x46, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x00, 0x00, 
        0x00, 0x45, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x21, 0x00, 0x00, 0x00, 0x00, 0x09, 0x01, 0x01, 0x01, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1A, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x01, 0x01, 0x3A, 0x5C, 0x59, 0xD5, 0x03, 0x03, 0x7B, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x6D, 0x03, 0x03, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0x03, 0x3F, 0x66, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5D, 0x17, 0xD5, 0x03, 0x59, 0x6E, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x1A, 0x1B, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x67, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2C, 0x01, 0x01, 0x01, 0x01, 0x2C, 0x00, 0x00, 
        0x00, 0x45, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x19, 0x15, 0x0E, 0x0E, 0x07, 0x15, 0x11, 0x11, 0x0B, 0x1B, 0x20, 0x0E, 0x36, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x24, 0x11, 0x25, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x32, 0x11, 0x01, 0x01, 0x3A, 0x5C, 0x59, 0xD5, 0x03, 0x59, 0x7B, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x6D, 0x03, 0x03, 0x03, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0x03, 0xEC, 0x66, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5D, 0x17, 0xD5, 0xD5, 0x59, 0x6E, 0x01, 0x01, 0x01, 0x01, 
        0x0F, 0x11, 0x11, 0x26, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x09, 0x11, 0x22, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3C, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x2D, 0x2B, 0x01, 0x01, 0x01, 0x01, 0x2B, 0x2D, 0x0E, 
        0x2E, 0x09, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x11, 0x24, 0x5E, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x27, 0x00, 0x00, 0x00, 0x00, 0x49, 0x19, 0x01, 0x1A, 0x37, 0x00, 0x00, 0x00, 0x0E, 0x01, 0x01, 0x01, 0x01, 0x26, 0x00, 0x00, 0x08, 0x42, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3A, 0x5C, 0x59, 0xD5, 0x03, 0x59, 0x7B, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x6D, 0x03, 0x03, 0x03, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0x03, 0xD5, 0x03, 0x3F, 0x66, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5D, 0x17, 0xD5, 0xD5, 0x59, 0x6E, 0x01, 0x01, 0x01, 0x29, 
        0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x31, 0x1E, 0x00, 0x07, 0x3E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x24, 0x20, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x27, 0x01, 0x01, 0x01, 0x45, 0x00, 0x00, 0x00, 0x0E, 0x01, 0x01, 0x01, 0x01, 0x20, 0x00, 0x00, 0x00, 0x16, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3A, 0x5C, 0x03, 0xD5, 0x03, 0x03, 0x7B, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x6D, 0x03, 0x03, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0x03, 0x3F, 0x66, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5D, 0x17, 0xD5, 0xD5, 0x59, 0x6E, 0x01, 0x01, 0x01, 0x0C, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x30, 0x00, 0x00, 0x00, 0x28, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x00, 0x00, 0x00, 0x1E, 0x06, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x27, 0x01, 0x01, 0x01, 0x2B, 0x00, 0x00, 0x00, 0x20, 0x01, 0x01, 0x01, 0x01, 0x20, 0x00, 0x00, 0x00, 0x16, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x38, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3A, 0x5C, 0x59, 0x03, 0x03, 0x03, 0x7B, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x6D, 0x03, 0x03, 0x03, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0x03, 0x03, 0x3F, 0x66, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5D, 0x17, 0x03, 0xD5, 0x59, 0x6E, 0x01, 0x01, 0x01, 0x0C, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x30, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x00, 0x00, 0x00, 0x08, 0x06, 0x01, 0x01, 0x01, 0x28, 0x00, 0x00, 0x00, 0x30, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x27, 0x07, 0x00, 0x00, 0x00, 0x49, 0x19, 0x01, 0x1A, 0x2E, 0x00, 0x00, 0x00, 0x26, 0x01, 0x01, 0x01, 0x01, 0x26, 0x00, 0x00, 0x08, 0x42, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x10, 0x0F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3A, 0x5C, 0x03, 0xD5, 0x03, 0x03, 0x7B, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x6D, 0x03, 0x03, 0xD5, 0xD5, 0xD5, 0xD5, 0x03, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0x03, 0x3F, 0x66, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5D, 0x17, 0xD5, 0xD5, 0x59, 0x6E, 0x01, 0x01, 0x01, 0x0C, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x29, 0x01, 0x01, 0x01, 0x31, 0x1E, 0x00, 0x00, 0x1B, 0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x00, 0x00, 0x00, 0x08, 0x06, 0x01, 0x01, 0x01, 0x3E, 0x07, 0x00, 0x1E, 0x31, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x22, 0x10, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x0E, 0x36, 0x1E, 0x27, 0x11, 0x24, 0x06, 0x26, 0x0E, 0x0E, 0x26, 0x06, 0x24, 0x11, 0x25, 0x01, 0x01, 0x01, 0x01, 
        0x0F, 0x18, 0x0E, 0x0E, 0x3C, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x32, 0x11, 0x01, 0x01, 0x3A, 0x5C, 0x59, 0xD5, 0x03, 0x03, 0x7B, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x6D, 0x03, 0x03, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0x03, 0xD5, 0x03, 0xEC, 0x66, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5D, 0x17, 0x03, 0xD5, 0x59, 0x6E, 0x01, 0x01, 0x01, 0x0C, 
        0x00, 0x00, 0x00, 0x00, 0x26, 0x11, 0x11, 0x0F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x09, 0x11, 0x21, 0x2E, 0x1B, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x18, 0x0F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x26, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 
        0x2E, 0x09, 0x01, 0x01, 0x01, 0x0B, 0x00, 0x00, 0x00, 0x08, 0x06, 0x01, 0x01, 0x01, 0x01, 0x22, 0x11, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2F, 0x01, 0x01, 0x01, 0x22, 0x00, 0x00, 0x00, 0x00, 0x22, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x35, 0x00, 0x00, 0x00, 0x08, 0x06, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x01, 0x01, 0x3A, 0x5C, 0x59, 0x03, 0x03, 0x03, 0x7B, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x6D, 0x03, 0x03, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0x03, 0xEC, 0x66, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5D, 0x17, 0x03, 0xD5, 0x59, 0x6E, 0x01, 0x01, 0x01, 0x0C, 
        0x00, 0x00, 0x00, 0x1B, 0x1A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x35, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x45, 0x01, 0x01, 0x01, 0x0B, 0x00, 0x00, 0x00, 0x08, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x01, 0x01, 0x01, 0x11, 0x00, 0x00, 0x00, 0x00, 0x22, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x4E, 0x00, 0x00, 0x00, 0x1E, 0x06, 0x01, 0x01, 0x01, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x3A, 0x5C, 0x59, 0xD5, 0x03, 0x03, 0x7B, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x6D, 0x03, 0x03, 0xD5, 0xD5, 0xD5, 0x03, 0xD5, 0xD5, 0x03, 0xD5, 0xD5, 0xD5, 0x03, 0xEC, 0x66, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5D, 0x17, 0x03, 0x03, 0x59, 0x6E, 0x01, 0x01, 0x01, 0x0C, 
        0x00, 0x00, 0x00, 0x12, 0x1A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x45, 0x01, 0x01, 0x01, 0x0B, 0x00, 0x00, 0x00, 0x1E, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x01, 0x01, 0x01, 0x0F, 0x1E, 0x00, 0x00, 0x00, 0x27, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x31, 0x00, 0x00, 0x00, 0x3D, 0x01, 0x01, 0x01, 0x01, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x3A, 0x5C, 0x03, 0xD5, 0x03, 0x03, 0x7B, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x6D, 0x03, 0x03, 0xD5, 0xD5, 0x03, 0x03, 0x03, 0xD5, 0x03, 0xD5, 0xD5, 0xD5, 0x03, 0x3F, 0x66, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5D, 0x17, 0x03, 0xD5, 0x59, 0x6E, 0x01, 0x01, 0x01, 0x0C, 
        0x00, 0x00, 0x00, 0x12, 0x0F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x22, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x26, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x3D, 0x5E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x43, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x48, 0x07, 0x00, 0x00, 0x00, 0x00, 0x10, 0x15, 0x48, 0x21, 0x42, 0x16, 0x16, 0x37, 0x1E, 0x2F, 0x15, 0x05, 0x06, 0x01, 0x01, 0x01, 
        0x01, 0x23, 0x16, 0x16, 0x29, 0x54, 0x15, 0x15, 0x2B, 0x25, 0x2B, 0x16, 0x16, 0x16, 0x16, 0x16, 0x38, 0x20, 0x00, 0x00, 0x00, 0x00, 0x32, 0x16, 0x16, 0x2F, 0x00, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x3A, 0x5C, 0x03, 0xD5, 0x03, 0x03, 0xFD, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x7C, 0x03, 0x03, 0xD5, 0x03, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0x03, 0xEC, 0xA9, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xF9, 0x17, 0x03, 0xD5, 0x59, 0x6E, 0x01, 0x01, 0x01, 0x0C, 
        0x00, 0x00, 0x00, 0x12, 0x0F, 0x01, 0x01, 0x01, 0x22, 0x26, 0x15, 0x51, 0x0F, 0x01, 0x01, 0x01, 0x01, 0x0D, 0x16, 0x16, 0x47, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x06, 0x05, 0x15, 0x2F, 0x1E, 0x37, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 
        0x26, 0x1B, 0x18, 0x15, 0x13, 0x09, 0x23, 0x16, 0x16, 0x29, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x0E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x06, 0x08, 0x00, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x1A, 0x12, 0x00, 0x00, 0x00, 0x24, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x00, 0x00, 0x00, 0x1F, 0x29, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x3A, 0x5C, 0x59, 0x03, 0x03, 0x03, 0x84, 0x5B, 
        0x5B, 0x5B, 0x5B, 0x5B, 0x5B, 0x5B, 0x5B, 0xF2, 0x03, 0x03, 0xD5, 0x03, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0x03, 0xD5, 0x9F, 0x5B, 0x5B, 0x5B, 0x5B, 0x5B, 0x5B, 0x5B, 0x87, 0xF1, 0x59, 0xD5, 0xD5, 0x59, 0x6E, 0x01, 0x01, 0x01, 0x0C, 
        0x00, 0x00, 0x00, 0x12, 0x0F, 0x01, 0x01, 0x01, 0x18, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x1E, 0x00, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x0B, 0x00, 0x00, 0x00, 0x08, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x37, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x30, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2C, 0x01, 0x01, 0x01, 0x01, 0x2D, 0x00, 0x00, 0x00, 0x3C, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x29, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x23, 0x00, 0x00, 0x00, 0x1B, 0x1A, 0x01, 0x01, 0x01, 0x10, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x3A, 0x52, 0x59, 0x03, 0x03, 0x03, 0x17, 0x17, 
        0x17, 0x55, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x55, 0x17, 0x17, 0x03, 0x03, 0x03, 0x59, 0x4C, 0x01, 0x01, 0x01, 0x0C, 
        0x00, 0x00, 0x00, 0x12, 0x1A, 0x01, 0x01, 0x01, 0x10, 0x00, 0x00, 0x00, 0x26, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5E, 0x08, 0x00, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x3C, 0x00, 0x00, 0x00, 0x0E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x48, 0x00, 0x00, 0x00, 0x37, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3C, 0x00, 0x00, 0x00, 0x32, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x01, 0x01, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x4E, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x25, 0x1F, 0x00, 0x00, 0x00, 0x23, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x31, 0x00, 0x00, 0x00, 0x1E, 0x19, 0x01, 0x01, 0x01, 0x10, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x3A, 0x2A, 0xD5, 0x61, 0x3F, 0x3F, 0x3F, 0x61, 
        0x3F, 0x3F, 0x61, 0x3F, 0x3F, 0x61, 0x3F, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x3F, 0x3F, 0x61, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x61, 0x61, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD5, 0x5A, 0x01, 0x01, 0x01, 0x31, 
        0x00, 0x00, 0x00, 0x07, 0x25, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x30, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5E, 0x20, 0x00, 0x00, 0x00, 0x54, 0x01, 0x01, 0x01, 0x4E, 0x00, 0x00, 0x00, 0x28, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x43, 0x00, 0x00, 0x00, 0x18, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1A, 0x26, 0x18, 0x49, 0x21, 0x01, 0x01, 0x01, 0x01, 0x25, 0x35, 0x0B, 0x0D, 0x22, 0x2F, 0x18, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0x0B, 0x0B, 0x49, 0x12, 0x37, 0x18, 0x41, 0x19, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x4E, 0x18, 0x18, 0x0E, 0x28, 0x2B, 0x0B, 0x46, 0x01, 0x01, 0x01, 0x01, 0x06, 0x05, 0x18, 0x18, 0x27, 0x01, 0x01, 0x01, 0x01, 0x10, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x72, 0x96, 0x4F, 0x4F, 0x6C, 0x4F, 0x4F, 0x6C, 
        0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x6C, 0x6C, 0x6C, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x6C, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x6C, 0x6C, 0x4F, 0x4F, 0x4F, 0x97, 0x01, 0x01, 0x01, 0x06, 
        0x05, 0x18, 0x18, 0x1E, 0x2E, 0x0B, 0x0B, 0x26, 0x1B, 0x47, 0x18, 0x58, 0x25, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0C, 0x18, 0x18, 0x3E, 0x06, 0x01, 0x01, 0x01, 0x19, 0x41, 0x18, 0x43, 0x31, 0x22, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 
        0x30, 0x1F, 0x00, 0x00, 0x00, 0x18, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x10, 0x00, 0x00, 0x1F, 0x42, 0x01, 0x01, 0x01, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x25, 0x1E, 0x00, 0x00, 0x00, 0x27, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x10, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x8B, 0x5A, 0xEE, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x5C, 0x40, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x31, 0x00, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1A, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x1E, 0x00, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x4B, 0x00, 0x00, 0x00, 0x3E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x10, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x3A, 0xB2, 0x59, 0x59, 0x59, 0x59, 0x59, 0x03, 
        0x59, 0x59, 0x03, 0x03, 0x03, 0x03, 0x59, 0x59, 0x59, 0x59, 0x03, 0x03, 0x03, 0x17, 0x55, 0x59, 0x59, 0x55, 0x55, 0x59, 0x59, 0x55, 0x17, 0x59, 0x03, 0x59, 0x03, 0x03, 0x59, 0x59, 0x03, 0x59, 0x03, 0x59, 0x03, 0x17, 0x4C, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x19, 0x12, 0x00, 0x00, 0x00, 0x46, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x28, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x32, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x3A, 0x5C, 0x03, 0xD5, 0xD5, 0xD5, 0x03, 0xD5, 
        0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0x03, 0xD5, 0xD5, 0xD5, 0x03, 0x03, 0x9D, 0xDE, 0xEE, 0x03, 0xB4, 0x87, 0xB2, 0x3F, 0x5B, 0x84, 0x87, 0xFF, 0x4C, 0x59, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0x03, 0xD5, 0xD5, 0x59, 0x6E, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x19, 0x1B, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x09, 0x09, 0x38, 0x00, 0x00, 0x00, 0x00, 0x10, 0x11, 0x09, 0x42, 0x0A, 0x1B, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x22, 0x09, 0x1A, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x19, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x2B, 0x1F, 0x08, 0x08, 0x0A, 0x24, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x09, 0x09, 0x35, 0x1B, 0x1E, 0x08, 0x28, 0x42, 0x01, 0x01, 0x3A, 0x5C, 0x03, 0xD5, 0xD5, 0xD5, 0xD5, 0x59, 
        0x17, 0x17, 0x03, 0xD5, 0x59, 0x59, 0x59, 0x17, 0x03, 0x59, 0x17, 0x59, 0x17, 0xC7, 0x01, 0xD7, 0xB2, 0xCB, 0x01, 0x6F, 0x4C, 0x01, 0xC7, 0xB4, 0xFE, 0x4C, 0x17, 0x59, 0x59, 0x17, 0x59, 0x03, 0x03, 0xD5, 0xD5, 0x59, 0x6E, 0x01, 0x01, 0x01, 0x01, 
        0x19, 0x09, 0x29, 0x3E, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x19, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1A, 0x09, 0x22, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x0E, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x1A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x3D, 0x07, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x20, 0x24, 0x06, 0x19, 0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x2C, 0x11, 0x01, 0x01, 0x01, 
        0x22, 0x2D, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x00, 0x58, 0x1A, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5E, 0x2F, 0x07, 0x07, 0x00, 0x2F, 0x0F, 0x06, 0x01, 0x01, 0x01, 0x01, 0x3A, 0x5C, 0x03, 0xD5, 0xD5, 0xD5, 0x59, 0x4C, 
        0x9E, 0x79, 0x03, 0x03, 0x79, 0xD7, 0x5A, 0x84, 0x52, 0xD6, 0x9D, 0x6F, 0x55, 0x83, 0x01, 0x9F, 0x5A, 0xCC, 0x01, 0x84, 0xEF, 0x01, 0x83, 0x5A, 0x9D, 0x61, 0xD7, 0x79, 0x6E, 0x9D, 0x5A, 0x59, 0x03, 0xD5, 0xD5, 0x59, 0x6E, 0x01, 0x01, 0x01, 0x09, 
        0x0A, 0x07, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x3D, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x2D, 0x22, 0x01, 0x01, 0x01, 0x11, 0x2C, 0x07, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x51, 0x19, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x5E, 0x01, 0x01, 0x01, 0x01, 0x06, 0x18, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x36, 0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x01, 0x01, 0x01, 
        0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1A, 0x1F, 0x00, 0x00, 0x00, 0x23, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3A, 0x5C, 0x59, 0xD5, 0xD5, 0x17, 0x79, 0x8A, 
        0xFF, 0x8B, 0xC7, 0x17, 0xF9, 0xCB, 0x8A, 0x01, 0x7C, 0x66, 0x01, 0x3B, 0x5A, 0x2A, 0xCC, 0xDF, 0xF3, 0x9A, 0xA9, 0xB7, 0x87, 0x72, 0x52, 0x94, 0x01, 0x2A, 0x5D, 0xCB, 0xA9, 0x01, 0x3A, 0x5A, 0x59, 0xD5, 0xD5, 0x59, 0x6E, 0x01, 0x01, 0x01, 0x0C, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x01, 0x01, 0x01, 
        0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x19, 0x12, 0x00, 0x00, 0x00, 0x23, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3A, 0x5C, 0x03, 0x03, 0x03, 0x03, 0xFF, 0xA9, 
        0x40, 0xB8, 0x01, 0xD6, 0xB8, 0xCC, 0x40, 0x94, 0x01, 0xF3, 0x84, 0x01, 0x87, 0x17, 0x66, 0x97, 0x95, 0xF8, 0xB8, 0xFD, 0xF9, 0x7C, 0x17, 0x94, 0x01, 0x2A, 0x95, 0x01, 0x83, 0x9F, 0x01, 0xD8, 0x17, 0xD5, 0xD5, 0x59, 0x6E, 0x01, 0x01, 0x01, 0x0C, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x01, 0x01, 0x01, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x42, 0x01, 0x01, 0x01, 
        0x22, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x25, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x27, 0x07, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3A, 0x5C, 0x59, 0xD5, 0x03, 0x52, 0x3B, 0x3B, 
        0x99, 0x99, 0xA9, 0x5A, 0x5D, 0x8B, 0x59, 0xA0, 0x01, 0x4C, 0x2A, 0x01, 0xC6, 0xC2, 0x94, 0x3A, 0x99, 0xB4, 0xD8, 0x3A, 0x8A, 0xDF, 0xC2, 0x94, 0x01, 0x2A, 0xB8, 0x72, 0x3F, 0xB3, 0x01, 0x87, 0x17, 0x03, 0x03, 0x59, 0x6E, 0x01, 0x01, 0x01, 0x0C, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x5E, 0x01, 0x06, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x19, 0x3D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x09, 0x18, 0x0A, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0x31, 0x0D, 0x16, 0x1B, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x11, 0x00, 0x00, 0x00, 0x00, 0x37, 0x31, 0x0D, 0x22, 0x24, 0x47, 0x0A, 0x10, 
        0x42, 0x29, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x25, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x19, 0x58, 0x0A, 0x0A, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3A, 0x5C, 0x59, 0xD5, 0x03, 0x03, 0x7C, 0x8B, 
        0xF2, 0x79, 0xEF, 0x59, 0x6C, 0x3B, 0xD5, 0xA0, 0x01, 0x5A, 0x4A, 0x01, 0xB7, 0xC2, 0xC4, 0x01, 0x01, 0xC3, 0x79, 0x01, 0x01, 0x83, 0xC2, 0x95, 0x01, 0x2A, 0xB8, 0xCC, 0x52, 0xC3, 0x01, 0x87, 0x17, 0x03, 0x03, 0x59, 0x6E, 0x01, 0x01, 0x01, 0x0C, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x43, 0x31, 0x0D, 0x16, 0x1B, 0x2D, 0x0A, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x28, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x10, 0x21, 0x01, 0x01, 0x01, 0x01, 0x1A, 0x0D, 0x0D, 0x30, 0x07, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x29, 0x01, 0x01, 0x01, 0x2E, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x11, 0x00, 0x00, 0x00, 0x00, 0x11, 0x01, 0x01, 0x01, 0x48, 0x00, 0x00, 0x00, 
        0x43, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3A, 0x52, 0x59, 0xD5, 0xD5, 0x59, 0x6F, 0xFF, 
        0x8B, 0x8A, 0x5D, 0x17, 0x5D, 0x3A, 0xD5, 0xA0, 0xCC, 0x5A, 0x4A, 0xCC, 0xDE, 0x55, 0x5A, 0xCB, 0x3A, 0xEE, 0xD6, 0xCB, 0x3A, 0xD6, 0x55, 0x94, 0x72, 0x2A, 0x95, 0x3B, 0x52, 0xC3, 0xCC, 0x5B, 0x17, 0xD5, 0xD5, 0x59, 0x4C, 0x01, 0x01, 0x01, 0x0C, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x07, 0x29, 0x01, 0x01, 0x01, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x28, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x25, 0x01, 0x01, 0x01, 0x43, 0x00, 0x00, 0x00, 0x2F, 0x01, 0x01, 0x01, 0x11, 0x00, 0x00, 0x00, 0x00, 0x11, 0x01, 0x01, 0x01, 0x15, 0x00, 0x00, 0x00, 
        0x18, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3B, 0x5C, 0x59, 0xD5, 0xD5, 0xD5, 0x59, 0x3F, 
        0xB3, 0xB3, 0x52, 0x03, 0x4C, 0xB3, 0xD5, 0x2A, 0x6F, 0x61, 0x61, 0x6F, 0x2A, 0x03, 0xD5, 0xB3, 0x5A, 0x03, 0xD5, 0xB3, 0x5A, 0xD5, 0x03, 0x4C, 0x6F, 0x3F, 0x4C, 0x6F, 0xD5, 0xEC, 0x6F, 0x2A, 0x03, 0xD5, 0xD5, 0x17, 0x6E, 0x01, 0x01, 0x01, 0x0C, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x1F, 0x25, 0x01, 0x01, 0x01, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x2E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x28, 0x00, 0x00, 0x00, 0x30, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x4E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x4B, 0x00, 0x00, 0x00, 0x30, 0x01, 0x01, 0x01, 0x09, 0x12, 0x00, 0x00, 0x12, 0x0F, 0x01, 0x01, 0x01, 0x47, 0x00, 0x00, 0x00, 
        0x3D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x9E, 0x55, 0x17, 0x17, 0x59, 0x17, 0x17, 
        0x55, 0x55, 0x17, 0x59, 0x55, 0x55, 0x17, 0x17, 0x55, 0x17, 0x17, 0x55, 0x17, 0x59, 0x17, 0x55, 0x55, 0x17, 0x17, 0x55, 0x55, 0x17, 0x59, 0x17, 0x55, 0x17, 0x55, 0x55, 0x17, 0x17, 0x55, 0x17, 0x59, 0x59, 0x17, 0x55, 0x87, 0x01, 0x01, 0x01, 0x0C, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x29, 0x07, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x3D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x37, 0x00, 0x00, 0x00, 0x4E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5E, 0x2B, 0x05, 0x3E, 0x20, 0x00, 0x00, 0x00, 0x00, 0x2C, 0x13, 0x13, 0x2E, 0x1E, 0x41, 0x05, 0x16, 0x19, 0x01, 0x01, 0x01, 0x01, 0x31, 0x05, 0x05, 0x31, 0x11, 0x41, 0x13, 0x18, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x2E, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x27, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x54, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x54, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3B, 0xA0, 0x40, 0x40, 0x40, 0x40, 0x40, 
        0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0xC6, 0x72, 0x01, 0x01, 0x01, 0x0C, 
        0x00, 0x00, 0x00, 0x00, 0x0A, 0x05, 0x05, 0x54, 0x09, 0x3E, 0x13, 0x13, 0x13, 0x13, 0x13, 0x51, 0x22, 0x23, 0x05, 0x05, 0x3D, 0x20, 0x13, 0x13, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x07, 0x2F, 0x05, 0x3E, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x2C, 0x3E, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x3C, 0x1A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x09, 0x38, 0x05, 0x2B, 0x5E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x53, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0C, 
        0x00, 0x00, 0x00, 0x1F, 0x22, 0x01, 0x01, 0x01, 0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2E, 0x01, 0x01, 0x01, 0x25, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2E, 0x01, 0x01, 0x01, 0x46, 0x00, 0x00, 0x00, 0x00, 0x46, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x35, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x23, 
        0x00, 0x00, 0x00, 0x12, 0x19, 0x01, 0x01, 0x01, 0x3D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x01, 0x01, 0x01, 0x01, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x24, 0x00, 0x00, 0x00, 0x00, 0x22, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x27, 
        0x00, 0x00, 0x00, 0x12, 0x0F, 0x01, 0x01, 0x01, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2D, 0x01, 0x01, 0x01, 0x06, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0x01, 0x01, 0x01, 0x22, 0x00, 0x00, 0x00, 0x00, 0x42, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x67, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x26, 0x1A, 0x31, 0x0C, 0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0C, 0x47, 0x10, 0x0E, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x2C, 0x10, 0x32, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x3D, 0x27, 0x0C, 0x42, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x11, 0x01, 0x01, 0x01, 0x01, 0x01, 0x11, 0x0C, 0x23, 0x19, 0x01, 0x01, 0x01, 0x01, 0x19, 0x23, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x31, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0D, 0x0C, 0x35, 0x28, 
        0x00, 0x00, 0x00, 0x12, 0x0F, 0x01, 0x01, 0x01, 0x0D, 0x2E, 0x10, 0x28, 0x00, 0x00, 0x00, 0x00, 0x07, 0x41, 0x0C, 0x0C, 0x2F, 0x1B, 0x32, 0x10, 0x10, 0x10, 0x10, 0x10, 0x43, 0x22, 0x01, 0x01, 0x01, 0x5E, 0x38, 0x10, 0x10, 0x08, 0x10, 0x54, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x23, 0x1A, 0x01, 0x01, 0x01, 0x01, 0x06, 0x23, 0x0C, 0x42, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x38, 0x00, 0x00, 0x00, 0x16, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x19, 0x4B, 0x00, 0x00, 0x00, 
        0x2D, 0x0F, 0x01, 0x01, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x54, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x12, 0x42, 0x01, 0x01, 0x01, 0x31, 0x1F, 0x00, 0x00, 0x49, 0x01, 0x01, 0x01, 0x01, 0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x12, 0x0F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5E, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x35, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x11, 0x1F, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2E, 0x01, 0x01, 0x01, 0x01, 0x58, 0x00, 0x00, 0x07, 0x54, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2E, 0x00, 0x00, 0x00, 0x2F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x48, 0x00, 0x00, 0x00, 
        0x43, 0x01, 0x01, 0x01, 0x25, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x3C, 0x00, 0x00, 0x00, 0x20, 0x01, 0x01, 0x01, 0x01, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x26, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x12, 0x1A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x25, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x06, 0x01, 0x01, 0x01, 0x2D, 0x00, 0x00, 0x00, 0x30, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x18, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x15, 0x00, 0x00, 0x00, 
        0x18, 0x01, 0x01, 0x01, 0x09, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x16, 0x00, 0x00, 0x00, 0x20, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x41, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x1B, 0x19, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x20, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x01, 0x01, 0x01, 0x01, 0x28, 0x00, 0x00, 0x00, 0x30, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x0F, 0x31, 0x08, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1A, 0x0F, 0x21, 0x20, 0x00, 0x00, 0x00, 
        0x18, 0x01, 0x01, 0x01, 0x09, 0x07, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x12, 0x0E, 0x24, 0x19, 0x0F, 0x1A, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x12, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x22, 0x28, 0x12, 0x1E, 0x05, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x12, 0x36, 0x27, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x11, 0x2D, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x12, 0x12, 0x00, 0x38, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x19, 0x24, 0x0E, 0x12, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x07, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x1E, 0x12, 
        0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x16, 0x0F, 0x0F, 0x01, 0x16, 0x1E, 0x12, 0x0E, 0x42, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x51, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x1E, 0x12, 0x07, 0x00, 0x00, 0x00, 0x00, 
        0x18, 0x01, 0x01, 0x01, 0x09, 0x07, 0x00, 0x00, 0x00, 0x15, 0x09, 0x0F, 0x06, 0x21, 0x2C, 0x12, 0x08, 0x2B, 0x01, 0x01, 0x01, 0x0F, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2D, 0x42, 0x0F, 0x09, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x01, 0x67, 0x0F, 0x1A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x00, 0x00, 0x00, 0x32, 0x22, 0x0F, 0x19, 0x01, 0x01, 0x01, 0x01, 0x67, 0x2F, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x07, 0x00, 0x00, 0x00, 0x00, 0x1E, 
        0x0C, 0x0F, 0x0F, 0x38, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x2C, 0x21, 0x06, 0x0F, 0x09, 0x15, 0x00, 0x00, 0x00, 0x07, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1A, 0x0F, 
        0x21, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x2E, 0x19, 0x1A, 0x0F, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x18, 0x01, 0x01, 0x01, 0x09, 0x07, 0x00, 0x00, 0x00, 0x21, 0x01, 0x01, 0x01, 0x13, 0x00, 0x00, 0x00, 0x32, 0x01, 0x01, 0x01, 0x0F, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x01, 0x01, 0x01, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x00, 0x00, 0x00, 0x16, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 
        0x01, 0x01, 0x01, 0x19, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x01, 0x21, 0x00, 0x00, 0x00, 0x07, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x2E, 0x01, 0x01, 0x01, 0x09, 0x07, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x13, 0x00, 0x00, 0x00, 0x10, 0x01, 0x01, 0x01, 0x19, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x27, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x20, 0x00, 0x00, 0x00, 0x16, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 
        0x01, 0x01, 0x01, 0x0F, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x01, 0x01, 0x01, 0x42, 0x00, 0x00, 0x00, 0x07, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4B, 0x19, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x05, 0x01, 0x01, 0x01, 0x09, 0x07, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x13, 0x00, 0x00, 0x00, 0x20, 0x25, 0x01, 0x01, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x26, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x49, 0x00, 0x00, 0x1F, 0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x19, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 
        0x01, 0x01, 0x01, 0x06, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x47, 0x67, 0x01, 0x01, 0x53, 0x00, 0x00, 0x00, 0x07, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x19, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x0F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x25, 0x2F, 0x10, 0x2E, 0x46, 0x01, 0x01, 0x01, 0x01, 0x1A, 0x23, 0x0C, 0x05, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x10, 0x47, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x19, 0x23, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x31, 
        0x01, 0x01, 0x01, 0x01, 0x09, 0x07, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x13, 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x10, 0x12, 0x43, 0x0C, 0x0C, 0x3E, 0x07, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x4B, 0x10, 0x43, 0x22, 0x01, 0x01, 0x01, 0x5E, 0x38, 0x10, 0x10, 0x38, 0x1A, 0x23, 0x0C, 0x11, 0x29, 0x43, 0x10, 0x18, 0x11, 0x01, 0x01, 0x01, 0x01, 0x25, 0x0C, 0x0C, 0x13, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 
        0x01, 0x01, 0x01, 0x01, 0x0F, 0x0C, 0x0C, 0x3E, 0x07, 0x00, 0x00, 0x00, 0x00, 0x28, 0x10, 0x3D, 0x07, 0x00, 0x00, 0x00, 0x07, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1A, 0x48, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x0E, 0x36, 0x4E, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x29, 0x31, 0x2E, 0x10, 0x2F, 0x25, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x53, 0x00, 0x00, 0x00, 0x3D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x09, 0x07, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x25, 0x01, 0x01, 0x01, 0x3D, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0x01, 0x01, 0x01, 0x22, 0x00, 0x00, 0x00, 0x00, 0x29, 0x01, 0x01, 0x01, 0x58, 0x00, 0x00, 0x00, 0x49, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x38, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3D, 0x00, 0x00, 0x00, 0x53, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x30, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x25, 0x07, 0x00, 0x00, 0x00, 0x21, 0x01, 0x01, 0x01, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x1A, 0x01, 0x01, 0x01, 0x10, 0x00, 0x00, 0x00, 0x41, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0x01, 0x01, 0x01, 0x11, 0x00, 0x00, 0x00, 0x00, 0x11, 0x01, 0x01, 0x01, 0x15, 0x00, 0x00, 0x00, 0x2E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x4B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x16, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x30, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x2C, 0x5E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x42, 0x00, 0x00, 0x00, 0x00, 0x27, 0x01, 0x01, 0x01, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0F, 0x01, 0x01, 0x01, 0x10, 0x00, 0x00, 0x00, 0x49, 0x01, 0x01, 0x01, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x51, 0x01, 0x01, 0x01, 0x09, 0x1F, 0x00, 0x00, 0x1F, 0x25, 0x01, 0x01, 0x01, 0x2E, 0x00, 0x00, 0x00, 0x58, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5E, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x35, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x2E, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x13, 0x41, 0x11, 0x01, 0x01, 0x01, 0x01, 0x22, 0x38, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x30, 0x2D, 0x00, 0x00, 0x00, 0x00, 0x20, 0x3E, 0x05, 0x2B, 0x1A, 0x38, 0x13, 0x48, 0x12, 0x00, 0x00, 0x00, 0x12, 0x0F, 0x01, 0x01, 0x01, 0x10, 0x00, 0x00, 0x00, 0x07, 0x48, 0x05, 0x38, 0x09, 0x27, 0x13, 0x13, 0x28, 0x00, 0x00, 
        0x00, 0x00, 0x1B, 0x15, 0x13, 0x05, 0x0F, 0x01, 0x01, 0x01, 0x01, 0x0C, 0x13, 0x13, 0x0C, 0x22, 0x38, 0x05, 0x2F, 0x1B, 0x2F, 0x13, 0x30, 0x25, 0x01, 0x01, 0x01, 0x01, 0x0D, 0x05, 0x05, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x18, 0x05, 0x05, 0x42, 0x01, 0x01, 0x01, 0x01, 0x09, 0x3E, 0x13, 0x13, 0x13, 0x13, 0x13, 0x58, 0x08, 0x00, 0x00, 0x00, 0x07, 0x09, 0x01, 0x01, 0x01, 0x1A, 0x3C, 0x05, 0x13, 0x12, 0x18, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 
        0x16, 0x5E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x47, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4E, 0x01, 0x01, 0x01, 0x16, 0x00, 0x00, 0x00, 0x12, 0x0F, 0x01, 0x01, 0x01, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x01, 0x01, 0x01, 0x29, 0x12, 0x00, 
        0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x10, 0x00, 0x00, 0x00, 0x41, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x0E, 0x19, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x00, 0x00, 0x00, 0x07, 0x09, 0x01, 0x01, 0x01, 0x26, 0x00, 0x00, 0x00, 0x47, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x01, 0x01, 0x01, 0x46, 0x00, 0x00, 0x00, 0x12, 0x0F, 0x01, 0x01, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2D, 0x01, 0x01, 0x01, 0x5E, 0x08, 0x00, 
        0x00, 0x00, 0x35, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2C, 0x00, 0x00, 0x00, 0x45, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x1F, 0x0F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x42, 0x00, 0x00, 0x00, 0x07, 0x09, 0x01, 0x01, 0x01, 0x2E, 0x00, 0x00, 0x00, 0x48, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x30, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x0C, 0x00, 0x00, 0x00, 0x12, 0x0F, 0x01, 0x01, 0x01, 0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4B, 0x01, 0x01, 0x01, 0x67, 0x08, 0x00, 
        0x00, 0x00, 0x27, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x20, 0x00, 0x00, 0x00, 0x16, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x12, 0x1A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x31, 0x00, 0x00, 0x00, 0x07, 0x25, 0x01, 0x01, 0x01, 0x43, 0x00, 0x00, 0x00, 0x49, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2D, 0x00, 0x00, 0x00, 0x38, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x0A, 0x0A, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x2B, 0x0D, 0x21, 0x67, 0x01, 0x01, 0x01, 0x01, 0x35, 0x4B, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x2D, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x0C, 0x00, 0x00, 0x00, 0x12, 0x0F, 0x01, 0x01, 0x01, 0x46, 0x32, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x3D, 0x54, 0x01, 0x01, 0x01, 0x01, 0x2B, 0x0A, 
        0x0A, 0x2F, 0x1A, 0x42, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x51, 0x07, 0x00, 0x00, 0x00, 0x16, 0x01, 0x01, 0x01, 0x01, 0x29, 0x0D, 0x31, 0x43, 0x1B, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x1E, 0x0A, 0x0A, 0x3C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x22, 0x0D, 0x46, 0x10, 0x1E, 0x0A, 0x0A, 0x38, 0x19, 0x0D, 0x0D, 0x29, 0x42, 0x10, 0x0A, 0x0E, 0x12, 0x2B, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0F, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x11, 0x0D, 0x42, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1A, 0x0D, 0x0D, 0x30, 0x1F, 0x28, 0x0A, 0x18, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x1E, 0x11, 0x01, 0x01, 0x23, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5E, 
        0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x0C, 0x00, 0x00, 0x00, 0x12, 0x0F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x01, 0x01, 0x01, 0x11, 0x1E, 0x00, 0x00, 0x00, 0x23, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1A, 0x32, 0x00, 0x00, 0x00, 0x20, 
        0x22, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x23, 0x1B, 0x00, 0x00, 0x12, 0x11, 0x01, 0x01, 0x01, 0x43, 0x00, 0x00, 0x1E, 0x22, 0x01, 0x01, 0x06, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x0F, 0x01, 0x01, 
        0x01, 0x2B, 0x07, 0x00, 0x00, 0x3C, 0x01, 0x01, 0x01, 0x19, 0x3D, 0x00, 0x00, 0x00, 0x30, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x0C, 0x00, 0x00, 0x00, 0x12, 0x1A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x01, 0x01, 0x01, 0x0B, 0x00, 0x00, 0x00, 0x36, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x41, 0x00, 0x00, 0x00, 0x10, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x30, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x06, 0x1E, 0x00, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x01, 0x01, 
        0x01, 0x2F, 0x00, 0x00, 0x00, 0x2E, 0x01, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x42, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x06, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x0C, 0x00, 0x00, 0x00, 0x12, 0x19, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x01, 0x01, 0x01, 0x0B, 0x00, 0x00, 0x00, 0x08, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x41, 0x00, 0x00, 0x00, 0x10, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x35, 0x01, 0x01, 0x01, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x01, 0x01, 
        0x01, 0x15, 0x00, 0x00, 0x00, 0x2E, 0x01, 0x01, 0x01, 0x25, 0x07, 0x00, 0x00, 0x00, 0x42, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x06, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x5E, 
        0x09, 0x2D, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x16, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 
        0x06, 0x42, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x2C, 0x11, 0x01, 0x01, 0x01, 0x0B, 0x00, 0x00, 0x00, 0x07, 0x4E, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x22, 0x28, 0x00, 0x00, 0x00, 0x1E, 
        0x0D, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5E, 0x06, 0x09, 0x3D, 0x00, 0x00, 0x00, 0x12, 0x23, 0x06, 0x06, 0x4E, 0x07, 0x00, 0x00, 0x00, 0x18, 0x25, 0x06, 0x25, 0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x19, 0x06, 
        0x24, 0x20, 0x00, 0x07, 0x12, 0x0B, 0x01, 0x06, 0x19, 0x38, 0x00, 0x00, 0x00, 0x00, 0x26, 0x1A, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x06, 0x08, 0x00, 0x00, 0x00, 0x10, 0x11, 0x09, 0x42, 0x4B, 0x00, 0x00, 0x00, 0x0E, 0x01, 0x01, 0x01, 0x01, 0x3C, 0x20, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0E, 
        0x23, 0x19, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x2B, 0x1B, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x2E, 0x0F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x36, 
        0x08, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x36, 0x23, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x1A, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x1F, 0x08, 0x08, 0x51, 0x01, 0x01, 0x01, 0x01, 0x35, 0x2C, 0x08, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x08, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 
        0x1B, 0x0A, 0x42, 0x09, 0x25, 0x0F, 0x10, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x0A, 0x24, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x06, 0x08, 0x00, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x16, 0x00, 0x00, 0x00, 0x0E, 0x01, 0x01, 0x01, 0x01, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x37, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x1E, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x1B, 0x1A, 0x01, 0x01, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x16, 0x01, 0x01, 0x01, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x30, 0x00, 0x00, 0x00, 0x28, 0x01, 0x01, 0x01, 0x06, 0x1E, 0x00, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x16, 0x00, 0x00, 0x00, 0x20, 0x01, 0x01, 0x01, 0x01, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x2E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x38, 0x01, 0x01, 0x01, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x1E, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x12, 0x0F, 0x01, 0x01, 0x01, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x2B, 0x01, 0x01, 0x01, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x27, 0x00, 0x00, 0x00, 0x2F, 0x01, 0x01, 0x01, 0x01, 0x10, 0x00, 0x00, 0x1F, 0x0D, 0x01, 0x01, 0x01, 0x23, 0x00, 0x00, 0x00, 0x18, 0x01, 0x01, 0x01, 0x01, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x30, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x43, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x10, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x12, 0x0F, 0x01, 0x01, 0x01, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x48, 0x01, 0x01, 0x01, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x46, 0x0B, 0x27, 0x19, 0x01, 0x01, 0x01, 0x01, 0x25, 0x35, 0x0B, 0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x31, 0x0B, 0x35, 0x0F, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x35, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x54, 
        0x1A, 0x3E, 0x18, 0x18, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x32, 0x18, 0x2E, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x1A, 0x26, 0x18, 0x49, 0x21, 0x01, 0x01, 0x01, 0x01, 0x25, 0x35, 
        0x0B, 0x41, 0x07, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x09, 0x48, 0x18, 0x47, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x2B, 0x0B, 0x05, 0x1B, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x12, 0x0F, 0x01, 0x01, 0x01, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x16, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x49, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x10, 0x18, 0x47, 0x1B, 0x41, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x46, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x0C, 0x00, 0x00, 0x00, 0x20, 0x5E, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x3C, 0x00, 0x00, 0x00, 0x32, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x47, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x01, 0x01, 0x01, 0x48, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x12, 0x0F, 0x01, 0x01, 0x01, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x20, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x0B, 0x00, 0x00, 0x00, 0x08, 0x06, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x28, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x43, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x01, 0x01, 0x01, 0x13, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x12, 0x1A, 0x01, 0x01, 0x01, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x35, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x0B, 0x00, 0x00, 0x00, 0x08, 0x06, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x13, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x10, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x1F, 0x09, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xBA, 0x92, 0x4D, 0x4D, 0x4D, 0x4D, 0x4D, 0x4D, 0x4D, 0x4D, 0x4D, 0x4D, 0x4D, 0x4D, 0x4D, 0x92, 0xA2, 0x65, 0x63, 0x5E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x0B, 0x00, 0x00, 0x00, 0x08, 0x06, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x2E, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x20, 0x00, 0x00, 0x00, 0x00, 0x20, 0x38, 0x16, 0x3E, 0x1B, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x29, 0x16, 
        0x16, 0x48, 0x07, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x15, 0x00, 0x00, 0x00, 0x00, 0x32, 0x15, 0x2F, 0x08, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x0F, 0x51, 0x15, 0x43, 0x1B, 
        0x00, 0x00, 0x00, 0x00, 0x32, 0x16, 0x16, 0x2F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x47, 0x15, 0x49, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x01, 0x0C, 0x16, 0x45, 0x25, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x57, 0xE5, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x33, 0x14, 0x60, 0x33, 0x1D, 0x7E, 0xAC, 0xA1, 0x6A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x0B, 0x00, 0x00, 0x00, 0x08, 0x06, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x2F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x21, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x5E, 0x3D, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x15, 0x00, 0x00, 0x00, 0x0A, 0x5E, 0x01, 0x01, 0x23, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x53, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x01, 0x01, 0x01, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x0C, 0x00, 0x00, 0x00, 0x2E, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x39, 0x14, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x04, 0x7D, 0x1C, 0x14, 0x8C, 0xB0, 0x5F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x0B, 0x00, 0x00, 0x00, 0x08, 0x06, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x38, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x19, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x06, 0x1E, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x15, 0x00, 0x00, 0x00, 0x18, 0x01, 0x01, 0x01, 0x25, 0x07, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x46, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x51, 0x01, 0x01, 0x01, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x3C, 0x00, 0x00, 0x00, 0x20, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x39, 0x14, 0x68, 0x68, 0x04, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x7D, 0x68, 0x68, 0x68, 0x7D, 0x14, 0x7F, 0x4D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x35, 0x00, 0x00, 0x00, 0x08, 0x06, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x06, 0x08, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2F, 0x00, 0x00, 0x00, 0x18, 0x01, 0x01, 0x01, 0x25, 0x00, 0x00, 0x00, 0x00, 0x21, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0C, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x45, 0x00, 0x00, 0x00, 0x2C, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x39, 0x14, 0x68, 0x04, 0x56, 0xCF, 0xCF, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0xCF, 0xCF, 0xC0, 0x9C, 0x1C, 0x33, 0x7D, 0x68, 0x68, 0x1D, 0x1C, 0x69, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x0F, 0x18, 0x0E, 0x0E, 0x3C, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x06, 0x08, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x01, 0x19, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x27, 0x1E, 0x36, 0x0E, 0x0A, 0x0D, 0x0F, 0x11, 0x24, 0x06, 0x51, 0x0E, 0x0E, 0x15, 0x19, 0x01, 0x01, 0x01, 0x01, 0x09, 0x11, 0x0D, 0x10, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x0C, 0x11, 0x21, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x09, 0x2E, 0x0E, 0x2D, 0x2B, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x01, 0x01, 0x01, 0x01, 0x06, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x39, 0x14, 0x68, 0x1C, 0x44, 0x5E, 0x5E, 0x5E, 0x5E, 0x5E, 0x5E, 0x5E, 0x5E, 0x5E, 0x5E, 0x01, 0x67, 0x5F, 0xA4, 0x82, 0xBF, 0x33, 0x04, 0x68, 0x7D, 0x14, 0x69, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x06, 0x08, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x1A, 0x3D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2E, 0x1A, 0x01, 0x01, 0x29, 0x20, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0C, 0x12, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x01, 0x01, 0x01, 0x06, 0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x31, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x39, 0x14, 0x68, 0x1C, 0x44, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x62, 0x8D, 0x33, 0x04, 0x68, 0x7D, 0x1C, 0xA2, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x06, 0x08, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x01, 0x01, 0x01, 0x0B, 0x00, 0x00, 0x00, 0x1E, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x26, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x35, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x01, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x39, 0x14, 0x68, 0x1C, 0x44, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x69, 0x1C, 0x04, 0x68, 0x34, 0x9C, 0x5F, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x28, 0x00, 0x00, 0x00, 0x30, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x06, 0x1E, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x01, 0x01, 0x01, 0x0B, 0x00, 0x00, 0x00, 0x08, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x41, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x2E, 0x01, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x39, 0x14, 0x68, 0x1C, 0x44, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x69, 0x33, 0x04, 0x68, 0x14, 0x6B, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3E, 0x07, 0x00, 0x1E, 0x31, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x15, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x09, 0x01, 0x01, 0x06, 0x3D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x42, 0x01, 0x01, 0x01, 0x24, 0x20, 0x00, 0x00, 0x00, 0x27, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x25, 0x4B, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0x19, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x23, 0x1B, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x1F, 0x45, 0x01, 0x01, 0x01, 0x06, 0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x31, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x39, 0x14, 0x68, 0x1C, 0x44, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5E, 0x7A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x8D, 0x33, 0x68, 0x7D, 0x8C, 0x98, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x5E, 0x51, 0x0E, 0x0E, 0x15, 0x19, 0x22, 0x11, 0x09, 0x01, 0x01, 0x01, 0x01, 0x1A, 0x49, 0x0E, 0x0E, 0x05, 0x06, 0x11, 0x11, 0x2B, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x5E, 0x24, 
        0x11, 0x11, 0x11, 0x11, 0x11, 0x46, 0x2D, 0x1E, 0x0E, 0x2D, 0x2B, 0x19, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x25, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x11, 0x11, 0x15, 0x07, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x08, 0x00, 0x00, 0x00, 0x00, 0x1B, 
        0x2B, 0x11, 0x11, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x0C, 0x11, 0x21, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x1F, 0x00, 0x00, 0x00, 
        0x00, 0x28, 0x46, 0x11, 0x22, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x39, 0x14, 0x68, 0x1C, 0x44, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x88, 0x7D, 0xFB, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xB9, 0xBF, 0x7D, 0x68, 0x14, 0xA1, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x25, 0x00, 0x00, 0x00, 0x00, 0x21, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x23, 0x00, 0x00, 0x00, 0x1B, 0x19, 0x01, 0x01, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x16, 0x00, 0x00, 0x00, 0x2C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 
        0x01, 0x01, 0x01, 0x1A, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x16, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x39, 0x14, 0x68, 0x1C, 0x44, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xEB, 0x73, 0x8E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x82, 0x33, 0x68, 0x1C, 0xAC, 0x5E, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x09, 0x07, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0C, 0x00, 0x00, 0x00, 0x12, 0x19, 0x01, 0x01, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x16, 0x00, 0x00, 0x00, 0x20, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x25, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x47, 
        0x01, 0x01, 0x01, 0x19, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x01, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x2B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x39, 0x14, 0x68, 0x1C, 0x44, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x93, 0x1C, 0x7D, 0x7D, 0xE0, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xA4, 0x1C, 0x04, 0x7D, 0x7E, 0x5F, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x09, 0x07, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0C, 0x00, 0x00, 0x00, 0x07, 0x21, 0x01, 0x01, 0x01, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0F, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x23, 0x00, 0x00, 0x00, 0x2E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2D, 
        0x19, 0x01, 0x01, 0x21, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x01, 0x01, 0x01, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x26, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x39, 0x14, 0x68, 0x1C, 0x44, 0x01, 0x01, 0x01, 0x01, 0x5F, 0x88, 0xC5, 0x82, 0xE8, 0x1D, 0x68, 0x1D, 0x77, 0xB0, 0x57, 0x88, 0x5F, 0x01, 0x01, 0x01, 0xC8, 0x9C, 0x1D, 0x04, 0x1D, 0x65, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x09, 0x07, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x20, 0x15, 0x15, 0x16, 0x0F, 0x2B, 0x16, 0x16, 0x16, 0x16, 0x16, 0x53, 0x2C, 0x0A, 0x15, 0x15, 0x27, 0x01, 0x01, 
        0x01, 0x01, 0x09, 0x13, 0x15, 0x41, 0x25, 0x0C, 0x16, 0x45, 0x25, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x67, 0x53, 0x15, 0x2F, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x4B, 0x15, 0x15, 0x20, 0x00, 0x00, 0x00, 0x00, 0x20, 0x38, 0x16, 0x35, 0x1A, 0x30, 0x15, 0x49, 0x12, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x3C, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x3C, 0x28, 0x00, 0x00, 0x00, 0x00, 0x28, 0x3C, 0x16, 
        0x26, 0x1B, 0x18, 0x15, 0x13, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x39, 0x14, 0x68, 0x1C, 0x44, 0x01, 0x01, 0x01, 0x01, 0x57, 0x9B, 0x14, 0x33, 0x1D, 0x68, 0x68, 0x68, 0x1D, 0x14, 0x14, 0xBE, 0x86, 0x01, 0x01, 0x01, 0x67, 0xC0, 0x34, 0x68, 0x33, 0x4D, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x09, 0x07, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x54, 0x00, 0x00, 0x00, 0x12, 0x0F, 0x01, 
        0x01, 0x01, 0x15, 0x00, 0x00, 0x00, 0x41, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x11, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x01, 
        0x01, 0x37, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x57, 0x60, 0x68, 0x1C, 0x81, 0x01, 0x01, 0x01, 0x01, 0x01, 0x74, 0x14, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x04, 0x14, 0x90, 0x01, 0x01, 0x01, 0x01, 0x01, 0xD1, 0x34, 0x68, 0x60, 0x86, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x09, 0x07, 0x00, 0x00, 0x00, 0x21, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x21, 0x00, 0x00, 0x00, 0x07, 0x09, 0x01, 
        0x01, 0x01, 0x2E, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x4E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x25, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x22, 0x00, 0x00, 0x00, 0x00, 0x22, 0x01, 0x01, 
        0x01, 0x48, 0x00, 0x00, 0x00, 0x2E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x39, 0x14, 0x68, 0x1C, 0xAC, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5E, 0x8E, 0x34, 0x68, 0x68, 0x68, 0x68, 0x68, 0x34, 0x8F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x67, 0x50, 0x34, 0x68, 0x14, 0x4D, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x09, 0x07, 0x00, 0x00, 0x00, 0x23, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x35, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x07, 0x22, 0x01, 
        0x01, 0x01, 0x2F, 0x00, 0x00, 0x00, 0x18, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x35, 0x01, 0x01, 0x01, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x21, 0x00, 0x00, 0x00, 0x00, 0x21, 0x01, 0x01, 
        0x01, 0x18, 0x00, 0x00, 0x00, 0x2F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xA3, 0x1C, 0x04, 0x1D, 0x77, 0xA8, 0x01, 0x01, 0x01, 0x01, 0x01, 0xA7, 0xE7, 0x1D, 0x68, 0x68, 0x68, 0x1D, 0x77, 0xBC, 0x01, 0x01, 0x01, 0x01, 0x01, 0xBB, 0x7F, 0x1D, 0x04, 0x1D, 0x65, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x09, 0x07, 0x00, 0x00, 0x00, 0x28, 0x2B, 0x0B, 0x46, 0x01, 0x01, 0x01, 0x01, 0x06, 0x05, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x2D, 0x0E, 0x45, 0x0B, 0x23, 0x01, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x10, 0x4E, 
        0x0B, 0x0D, 0x22, 0x2F, 0x18, 0x10, 0x1B, 0x30, 0x0B, 0x35, 0x0F, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x35, 0x0B, 0x31, 0x01, 0x01, 0x01, 0x01, 0x06, 0x3E, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x45, 0x0B, 0x38, 0x12, 0x3D, 0x18, 0x2E, 0x1B, 0x00, 0x00, 0x00, 0x07, 0x09, 0x01, 0x01, 0x01, 0x67, 0x54, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x4E, 0x4B, 0x00, 0x00, 0x00, 0x00, 0x4B, 0x4E, 0x0B, 
        0x30, 0x1B, 0x10, 0x18, 0x2F, 0x22, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x62, 0x68, 0x04, 0x04, 0x1D, 0x89, 0x01, 0x01, 0x01, 0x01, 0x01, 0xC8, 0x9C, 0x1D, 0x68, 0x04, 0x68, 0x1D, 0x76, 0xA8, 0x01, 0x01, 0x01, 0x01, 0x01, 0x65, 0x1C, 0x04, 0x7D, 0x56, 0x63, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x09, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x20, 0x00, 0x00, 0x00, 0x2B, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x1F, 0x42, 0x01, 0x01, 0x01, 0x48, 0x00, 0x00, 0x00, 0x18, 0x01, 0x01, 0x01, 0x01, 0x18, 0x00, 0x00, 0x00, 0x23, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x25, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x47, 0x01, 0x01, 0x01, 0x16, 0x00, 0x00, 0x00, 0x07, 0x09, 0x01, 0x01, 0x01, 0x3E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x48, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xAA, 0xAB, 0x1D, 0x68, 0x33, 0x70, 0x01, 0x01, 0x01, 0x01, 0x01, 0xA6, 0x68, 0x1C, 0x1C, 0x56, 0x33, 0x1C, 0x56, 0x6A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x6B, 0x33, 0x68, 0x1C, 0xC1, 0x5E, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x09, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x47, 0x00, 0x00, 0x00, 0x26, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x2B, 0x00, 0x00, 0x00, 0x20, 0x01, 0x01, 0x01, 0x01, 0x20, 0x00, 0x00, 0x00, 0x16, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x4B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x01, 0x01, 0x01, 0x42, 0x00, 0x00, 0x00, 0x07, 0x09, 0x01, 0x01, 0x01, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x2B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xB1, 0x14, 0x68, 0x1D, 0x75, 0xE3, 0x01, 0x01, 0x01, 0x01, 0x7A, 0x73, 0xE9, 0x85, 0x98, 0xC5, 0x76, 0xE6, 0x88, 0x01, 0x01, 0x01, 0x01, 0x63, 0x7E, 0x7D, 0x68, 0x14, 0xB5, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x32, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x01, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x16, 0x00, 0x00, 0x00, 0x0E, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x00, 0x00, 0x00, 0x16, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x07, 0x09, 0x01, 0x01, 0x01, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x16, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x89, 0x1D, 0x04, 0x68, 0x33, 0x8F, 0x01, 0x01, 0x01, 0x01, 0xF6, 0xF4, 0xCA, 0x01, 0x01, 0x01, 0xC9, 0xD9, 0x65, 0x01, 0x01, 0x01, 0x01, 0x8E, 0x33, 0x68, 0x04, 0x68, 0xFC, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x19, 0x09, 0x29, 0x26, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x22, 0x0F, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x35, 0x1B, 0x1E, 0x08, 0x28, 0x11, 0x1A, 0x09, 0x09, 0x19, 0x43, 0x08, 0x08, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x16, 0x00, 0x00, 0x00, 0x0E, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x00, 0x00, 0x00, 0x4B, 0x42, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x2B, 0x1F, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1E, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x28, 0x42, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x07, 0x09, 0x01, 0x01, 0x01, 0x0C, 0x0E, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x4B, 0x42, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x09, 0x09, 0x1A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x8D, 0x33, 0x68, 0x04, 0x1C, 0x71, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xC5, 0x1C, 0x04, 0x68, 0x14, 0x78, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x22, 0x2D, 0x07, 0x07, 0x00, 0x4E, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x31, 0x08, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x00, 0x2F, 0x0F, 0x06, 0x01, 0x42, 0x36, 0x07, 0x1B, 0x38, 0x01, 0x06, 0x06, 0x4E, 0x07, 0x00, 
        0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x16, 0x00, 0x00, 0x00, 0x0E, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x00, 0x58, 0x1A, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0F, 0x2F, 
        0x00, 0x00, 0x00, 0x00, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x07, 0x09, 0x01, 0x01, 0x01, 0x01, 0x5E, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x27, 0x1F, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x07, 0x07, 0x07, 0x07, 0x07, 0x1F, 0x26, 0x01, 0x01, 0x01, 0x01, 0x38, 0x1B, 0x07, 0x36, 0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x62, 0x68, 0x1D, 0x68, 0x7D, 0x7D, 0x71, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x57, 0x1D, 0x7D, 0x68, 0x1D, 0x7E, 0x63, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x0B, 0x00, 0x00, 0x00, 0x08, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x01, 0x01, 0x01, 0x30, 0x00, 0x00, 0x00, 0x28, 0x01, 0x01, 0x01, 0x01, 0x08, 0x00, 
        0x00, 0x00, 0x0B, 0x01, 0x01, 0x01, 0x16, 0x00, 0x00, 0x00, 0x0E, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x23, 
        0x00, 0x00, 0x00, 0x12, 0x19, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x07, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x06, 0x01, 0x01, 0x01, 0x28, 0x00, 0x00, 0x00, 0x30, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x57, 0x14, 0x04, 0x68, 0x7D, 0x1C, 0x8F, 0xC8, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x63, 0x82, 0x1C, 0x04, 0x68, 0x04, 0x33, 0x71, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x0B, 0x00, 0x00, 0x00, 0x36, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x01, 0x01, 0x01, 0x38, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x06, 0x08, 0x00, 
        0x00, 0x00, 0x27, 0x01, 0x01, 0x01, 0x2B, 0x00, 0x00, 0x00, 0x20, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0C, 
        0x00, 0x00, 0x00, 0x1F, 0x0F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x42, 0x00, 0x00, 0x00, 0x07, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x06, 0x01, 0x01, 0x01, 0x28, 0x00, 0x00, 0x00, 0x30, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x8F, 0x60, 0x04, 0x68, 0x04, 0x33, 0x75, 0x70, 0x89, 0xA7, 0x01, 0x01, 0x01, 0xE4, 0xE0, 0x74, 0x64, 0x33, 0x04, 0x68, 0x04, 0x60, 0x70, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x11, 0x1E, 0x00, 0x00, 0x00, 0x23, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x54, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x09, 0x01, 0x01, 0x19, 0x2E, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x06, 0x08, 0x00, 
        0x00, 0x00, 0x48, 0x5E, 0x01, 0x06, 0x43, 0x00, 0x00, 0x00, 0x15, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x09, 
        0x20, 0x00, 0x00, 0x2E, 0x67, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x30, 0x00, 0x00, 0x00, 0x07, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0D, 0x12, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x06, 0x01, 0x01, 0x01, 0x13, 0x00, 0x00, 0x1B, 0x23, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5E, 0x8F, 0x14, 0x1D, 0x68, 0x68, 0x1D, 0x33, 0x1D, 0x77, 0xAC, 0x81, 0xAC, 0x76, 0x1D, 0x33, 0x1D, 0x68, 0x68, 0x1D, 0x33, 0x70, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x29, 0x0D, 0x31, 0x43, 0x1B, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x18, 0x25, 0x24, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x09, 0x31, 0x32, 0x0A, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x06, 0x08, 0x00, 
        0x00, 0x00, 0x00, 0x2D, 0x0A, 0x0E, 0x12, 0x2B, 0x0D, 0x21, 0x67, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x00, 0x00, 0x00, 0x0E, 0x54, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x30, 0x1F, 0x28, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x32, 0x31, 
        0x09, 0x0D, 0x0D, 0x19, 0x01, 0x01, 0x01, 0x01, 0x46, 0x32, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x28, 0x00, 0x00, 0x00, 0x00, 0x07, 0x09, 0x01, 0x01, 0x01, 0x21, 0x10, 0x0A, 0x47, 0x11, 0x01, 0x01, 0x01, 0x5E, 0x3E, 0x0A, 0x0A, 0x12, 0x00, 0x00, 0x00, 
        0x00, 0x0E, 0x54, 0x0D, 0x0C, 0x28, 0x00, 0x00, 0x00, 0x08, 0x06, 0x01, 0x01, 0x01, 0x5E, 0x21, 0x0D, 0x22, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xC5, 0x68, 0x33, 0x04, 0x68, 0x68, 0x04, 0x1D, 0x1C, 0x1C, 0x1C, 0x1D, 0x04, 0x68, 0x68, 0x04, 0x14, 0x56, 0x91, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x01, 0x01, 0x06, 0x08, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x00, 0x00, 0x00, 0x3C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x47, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x09, 0x01, 0x01, 0x01, 0x43, 0x00, 0x00, 0x00, 0x48, 0x01, 0x01, 0x01, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x3C, 0x01, 0x01, 0x01, 0x4E, 0x00, 0x00, 0x00, 0x08, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xE2, 0xAD, 0x1D, 0x14, 0x1D, 0x04, 0x04, 0x68, 0x68, 0x68, 0x04, 0x04, 0x34, 0x14, 0x7D, 0xAF, 0x6A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x01, 0x01, 0x01, 0x06, 0x1E, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x20, 0x00, 0x00, 0x00, 0x16, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3D, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x01, 0x01, 0x01, 0x2E, 0x00, 0x00, 0x00, 0x49, 0x01, 0x01, 0x01, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x16, 0x01, 0x01, 0x01, 0x0B, 0x00, 0x00, 0x00, 0x1E, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xA5, 0xB1, 0xAB, 0x68, 0x1C, 0x14, 0xBE, 0x14, 0x1C, 0x68, 0xC0, 0x74, 0xA6, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x0F, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0x01, 0x01, 0x01, 0x5E, 0x0A, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x10, 0x00, 0x00, 0x00, 0x27, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2F, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0F, 0x01, 0x01, 0x01, 0x26, 0x00, 0x00, 0x00, 0x30, 0x01, 0x01, 0x01, 0x09, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x27, 0x01, 0x01, 0x01, 0x46, 0x00, 0x00, 0x00, 0x0A, 0x5E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xAA, 0x62, 0xA3, 0x39, 0x57, 0x91, 0x7A, 0xFC, 0xBC, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x0D, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x2B, 0x5E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x25, 0x53, 0x05, 0x05, 0x05, 0x05, 0x05, 0x38, 0x09, 0x01, 0x01, 0x01, 0x01, 0x24, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x16, 0x19, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x22, 0x38, 0x05, 0x0B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x09, 0x38, 0x05, 0x05, 0x05, 0x05, 0x05, 0x53, 0x25, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x25, 0x53, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0D, 0x01, 0x01, 0x01, 0x01, 0x1A, 0x3C, 0x05, 0x16, 0x19, 0x01, 0x01, 0x01, 0x01, 0x31, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x0B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x27, 0x05, 0x05, 0x24, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01
};
GUI_CONST_STORAGE GUI_BITMAP bmnuvoton_qrcode = {
  192, // xSize
  192, // ySize
  192, // BytesPerLine
  8, // BitsPerPixel
  _acnuvoton_qrcode,  // Pointer to picture data (indices)
  &_Palnuvoton_qrcode   // Pointer to palette
};
static GUI_CONST_STORAGE GUI_COLOR _Colorsnuvoton_logo_140x70[] = {
#if (GUI_USE_ARGB == 0)
  0xFFFFFF, 0xFEFEFE, 0x121520, 0x171A25,
  0x151823, 0x191C27, 0x585A61, 0x929399,
  0x161924, 0x0E1DE6, 0x54565D, 0x8E8F95,
  0x0212E6, 0x0616E6, 0x0A1AE6, 0xFCFCFE,
  0x0008E4, 0x000AE4, 0x0414E6, 0xD8DAFB,
  0x101EE7, 0x0010E6, 0x000EE5, 0x0C1AE6,
  0x303DEA, 0x000CE5, 0x000EE6, 0x0818E6,
  0xF4F4FE, 0xF8F8FE, 0xFAFAFE, 0x0004E4,
  0x404CEC, 0x6D76F0, 0xF6F6FE, 0x0006E4,
  0x4954EC, 0x9EA4F5, 0xC4C8F8, 0x202EE8,
  0x727AF1, 0xAAB0F6, 0x0000E4, 0x0002E4,
  0x0413E6, 0x0816E6, 0x3542EA, 0x3642EA,
  0x424EEC, 0x5C66EE, 0xBDC1F8, 0xD6D8FB,
  0xDCDEFB, 0xEDEEFD, 0xF1F2FE, 0x0000E2,
  0x0010E5, 0x0210E6, 0x0A19E6, 0x1120E7,
  0x1A29E8, 0x2E3CEA, 0x3E4AEC, 0x4550EC,
  0x4C57ED, 0x4D58ED, 0x5A65EF, 0x5E69EF,
  0x6670F0, 0x7880F2, 0x848CF2, 0x868EF3,
  0x9AA0F4, 0xB9BEF8, 0xC2C6F8, 0xD3D6FB,
  0xDADCFB, 0xE6E8FC, 0xF2F2FE, 0xF7F8FE,
  0x10131E, 0x11141F, 0x0614E6, 0x1524E8,
  0x1826E8, 0x2030E8, 0x2230E9, 0x2936EA,
  0x3A46EB, 0x4651EC, 0x4853EC, 0x4A54EC,
  0x838BF2, 0x9298F4, 0x959CF4, 0x9CA2F5,
  0xA3A8F6, 0xACB2F6, 0xB0B4F7, 0xC0C4F8,
  0xC6CAF9, 0xCACEFA, 0xCDD0F9, 0xE0E2FC,
  0xE4E6FC, 0xF0F0FD, 0xF5F6FE, 0xF9FAFE,
  0x1423E7, 0x1221E8, 0x1E2DE8, 0x2532E9,
  0x2B38EA, 0x2D3AEA, 0x3845EB, 0x4652EC,
  0x4F5AEE, 0x616BEF, 0x626CEF, 0x6A72F0,
  0x6F78F0, 0x767FF1, 0x7A83F2, 0x949BF4,
  0xACB1F6, 0xAFB4F7, 0xB5BAF7, 0xB6BBF8,
  0xC8CBF9, 0xD5D7FB, 0xD7DAFB, 0xDEE0FC,
  0xDFE2FC, 0xE9EAFC, 0xEEF0FD, 0x363842,
  0x55575E, 0x595B62, 0x0212E5, 0x0516E6,
  0x1625E7, 0x1423E8, 0x2634E9, 0x3240EA,
  0x424DEC, 0x4E58ED, 0x5863EF, 0x656EEF,
  0x6B75F0, 0x747DF1, 0x757EF1, 0x7A83F1,
  0x7E86F2, 0x8890F3, 0x8D94F3, 0x8C93F4,
  0x9097F4, 0x9BA2F4, 0xA1A6F5, 0xA1A7F6,
  0xA2A7F6, 0xA5ABF6, 0xA7ADF7, 0xA9AEF6,
  0xB1B6F7, 0xB3B8F7, 0xB2B7F8, 0xB8BDF8,
  0xBABEF8, 0xC9CCF9, 0xD0D3FA, 0xD2D5FB,
  0xD5D8FB, 0xD8D9FB, 0xE2E4FC, 0xEAEBFD,
  0xECEDFD, 0xEEEFFD, 0x262933, 0x56585E,
  0x0209E5, 0x000BE6, 0x020FE6, 0x040CE5,
  0x0210E5, 0x0112E5, 0x0810E5, 0x0B1CE7,
  0x1827E7, 0x1823E8, 0x2232E9, 0x2735EA,
  0x2933E9, 0x3441EB, 0x3641EA, 0x3C47EB,
  0x3D48EB, 0x3E49EB, 0x424DEB, 0x404BEC,
  0x444FEC, 0x4B56ED, 0x505AED, 0x545EED,
  0x5761EE, 0x5E67EE, 0x666FEF, 0x6771EF,
  0x6872EF, 0x656DF0, 0x646EF0, 0x666FF0,
  0x717AF1, 0x737CF1, 0x767FF2, 0x7981F1,
  0x7B84F2, 0x7E85F2, 0x909197, 0x919298,
  0x93949A, 0x94959B, 0x8088F3, 0x8289F3,
  0x818BF3, 0x888FF3, 0x8B92F3, 0x8C93F3,
  0x99A0F5, 0xA2A8F5, 0xA4AAF5, 0xA4A9F6,
  0xA6ACF5, 0xA8ACF6, 0xAAAFF7, 0xAFB3F7,
  0xB2B7F7, 0xC0C3F9, 0xC2C5F9, 0xC4C7F9,
  0xC6C9F9, 0xCACCF9, 0xCBCFF9, 0xCCCFFA,
  0xD1D5FB, 0xDEDFFB, 0xDADDFC, 0xDCDDFC,
  0xDEDFFC, 0xE0E2FB, 0xE8E9FD, 0xEBECFD,
  0xEDEEFE, 0xF1F2FD, 0xF2F2FD, 0xF5F5FD
#else
  0xFFFFFFFF, 0xFFFEFEFE, 0xFF201512, 0xFF251A17,
  0xFF231815, 0xFF271C19, 0xFF615A58, 0xFF999392,
  0xFF241916, 0xFFE61D0E, 0xFF5D5654, 0xFF958F8E,
  0xFFE61202, 0xFFE61606, 0xFFE61A0A, 0xFFFEFCFC,
  0xFFE40800, 0xFFE40A00, 0xFFE61404, 0xFFFBDAD8,
  0xFFE71E10, 0xFFE61000, 0xFFE50E00, 0xFFE61A0C,
  0xFFEA3D30, 0xFFE50C00, 0xFFE60E00, 0xFFE61808,
  0xFFFEF4F4, 0xFFFEF8F8, 0xFFFEFAFA, 0xFFE40400,
  0xFFEC4C40, 0xFFF0766D, 0xFFFEF6F6, 0xFFE40600,
  0xFFEC5449, 0xFFF5A49E, 0xFFF8C8C4, 0xFFE82E20,
  0xFFF17A72, 0xFFF6B0AA, 0xFFE40000, 0xFFE40200,
  0xFFE61304, 0xFFE61608, 0xFFEA4235, 0xFFEA4236,
  0xFFEC4E42, 0xFFEE665C, 0xFFF8C1BD, 0xFFFBD8D6,
  0xFFFBDEDC, 0xFFFDEEED, 0xFFFEF2F1, 0xFFE20000,
  0xFFE51000, 0xFFE61002, 0xFFE6190A, 0xFFE72011,
  0xFFE8291A, 0xFFEA3C2E, 0xFFEC4A3E, 0xFFEC5045,
  0xFFED574C, 0xFFED584D, 0xFFEF655A, 0xFFEF695E,
  0xFFF07066, 0xFFF28078, 0xFFF28C84, 0xFFF38E86,
  0xFFF4A09A, 0xFFF8BEB9, 0xFFF8C6C2, 0xFFFBD6D3,
  0xFFFBDCDA, 0xFFFCE8E6, 0xFFFEF2F2, 0xFFFEF8F7,
  0xFF1E1310, 0xFF1F1411, 0xFFE61406, 0xFFE82415,
  0xFFE82618, 0xFFE83020, 0xFFE93022, 0xFFEA3629,
  0xFFEB463A, 0xFFEC5146, 0xFFEC5348, 0xFFEC544A,
  0xFFF28B83, 0xFFF49892, 0xFFF49C95, 0xFFF5A29C,
  0xFFF6A8A3, 0xFFF6B2AC, 0xFFF7B4B0, 0xFFF8C4C0,
  0xFFF9CAC6, 0xFFFACECA, 0xFFF9D0CD, 0xFFFCE2E0,
  0xFFFCE6E4, 0xFFFDF0F0, 0xFFFEF6F5, 0xFFFEFAF9,
  0xFFE72314, 0xFFE82112, 0xFFE82D1E, 0xFFE93225,
  0xFFEA382B, 0xFFEA3A2D, 0xFFEB4538, 0xFFEC5246,
  0xFFEE5A4F, 0xFFEF6B61, 0xFFEF6C62, 0xFFF0726A,
  0xFFF0786F, 0xFFF17F76, 0xFFF2837A, 0xFFF49B94,
  0xFFF6B1AC, 0xFFF7B4AF, 0xFFF7BAB5, 0xFFF8BBB6,
  0xFFF9CBC8, 0xFFFBD7D5, 0xFFFBDAD7, 0xFFFCE0DE,
  0xFFFCE2DF, 0xFFFCEAE9, 0xFFFDF0EE, 0xFF423836,
  0xFF5E5755, 0xFF625B59, 0xFFE51202, 0xFFE61605,
  0xFFE72516, 0xFFE82314, 0xFFE93426, 0xFFEA4032,
  0xFFEC4D42, 0xFFED584E, 0xFFEF6358, 0xFFEF6E65,
  0xFFF0756B, 0xFFF17D74, 0xFFF17E75, 0xFFF1837A,
  0xFFF2867E, 0xFFF39088, 0xFFF3948D, 0xFFF4938C,
  0xFFF49790, 0xFFF4A29B, 0xFFF5A6A1, 0xFFF6A7A1,
  0xFFF6A7A2, 0xFFF6ABA5, 0xFFF7ADA7, 0xFFF6AEA9,
  0xFFF7B6B1, 0xFFF7B8B3, 0xFFF8B7B2, 0xFFF8BDB8,
  0xFFF8BEBA, 0xFFF9CCC9, 0xFFFAD3D0, 0xFFFBD5D2,
  0xFFFBD8D5, 0xFFFBD9D8, 0xFFFCE4E2, 0xFFFDEBEA,
  0xFFFDEDEC, 0xFFFDEFEE, 0xFF332926, 0xFF5E5856,
  0xFFE50902, 0xFFE60B00, 0xFFE60F02, 0xFFE50C04,
  0xFFE51002, 0xFFE51201, 0xFFE51008, 0xFFE71C0B,
  0xFFE72718, 0xFFE82318, 0xFFE93222, 0xFFEA3527,
  0xFFE93329, 0xFFEB4134, 0xFFEA4136, 0xFFEB473C,
  0xFFEB483D, 0xFFEB493E, 0xFFEB4D42, 0xFFEC4B40,
  0xFFEC4F44, 0xFFED564B, 0xFFED5A50, 0xFFED5E54,
  0xFFEE6157, 0xFFEE675E, 0xFFEF6F66, 0xFFEF7167,
  0xFFEF7268, 0xFFF06D65, 0xFFF06E64, 0xFFF06F66,
  0xFFF17A71, 0xFFF17C73, 0xFFF27F76, 0xFFF18179,
  0xFFF2847B, 0xFFF2857E, 0xFF979190, 0xFF989291,
  0xFF9A9493, 0xFF9B9594, 0xFFF38880, 0xFFF38982,
  0xFFF38B81, 0xFFF38F88, 0xFFF3928B, 0xFFF3938C,
  0xFFF5A099, 0xFFF5A8A2, 0xFFF5AAA4, 0xFFF6A9A4,
  0xFFF5ACA6, 0xFFF6ACA8, 0xFFF7AFAA, 0xFFF7B3AF,
  0xFFF7B7B2, 0xFFF9C3C0, 0xFFF9C5C2, 0xFFF9C7C4,
  0xFFF9C9C6, 0xFFF9CCCA, 0xFFF9CFCB, 0xFFFACFCC,
  0xFFFBD5D1, 0xFFFBDFDE, 0xFFFCDDDA, 0xFFFCDDDC,
  0xFFFCDFDE, 0xFFFBE2E0, 0xFFFDE9E8, 0xFFFDECEB,
  0xFFFEEEED, 0xFFFDF2F1, 0xFFFDF2F2, 0xFFFDF5F5
#endif
};
static GUI_CONST_STORAGE GUI_LOGPALETTE _Palnuvoton_logo_140x70 = {
  256,  // Number of entries
  1,    // Has transparency
  &_Colorsnuvoton_logo_140x70[0]
};
static GUI_CONST_STORAGE unsigned char _acnuvoton_logo_140x70[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x51, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x51, 0x00, 0x00,
  0x00, 0x50, 0x04, 0x04, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x08, 0x04, 0x50, 0x00,
  0x00, 0x04, 0x04, 0xB2, 0x89, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x89, 0x87, 0x08, 0x04, 0x00,
  0x00, 0x04, 0x08, 0xB3, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xDB, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0xFC, 0xF8, 0x13, 
        0x33, 0x4A, 0x64, 0x13, 0x13, 0x34, 0x35, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x84, 0x29, 0x5C, 0xD2, 0x74, 0x24, 
        0x59, 0x8E, 0x3D, 0x73, 0x24, 0x40, 0x93, 0x47, 0x9E, 0xFA, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0xF5, 0xA8, 0xA6, 0x5F, 0x5F, 0x49, 0x26, 0x4D, 0x01, 0x01, 0x01, 0x01, 0x35, 0xAB, 0xAC, 0x4B, 0x84, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0xAF, 0xF4, 0xAC, 0x4B, 0x4D, 0x1C, 0x65, 0x33, 0xAB, 0x68, 0x01, 0x01, 0x01, 0x01, 0x01, 0x6B, 0x67, 0x4B, 0x4B, 0x82, 0x69, 0x01, 0x01, 0xFE, 0xF2, 0x49, 0xEA, 0x9D, 0x29, 0xA7, 0xAA, 0x22, 0x01, 0x01, 0xE0, 0x2A, 0x2A, 0x2A, 0x2B, 0x10, 
        0x0C, 0x1B, 0x0D, 0x16, 0x23, 0x1F, 0x2A, 0x2A, 0x37, 0x62, 0x01, 0x01, 0xFB, 0x64, 0x49, 0xA1, 0x5F, 0x7D, 0x49, 0x13, 0x1E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x82, 0x49, 0xA4, 0x48, 0x60, 0xA6, 0x64, 0x86, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xAD, 0xD9, 0x91, 0x56, 0xBC, 0x19, 0xB7, 0x55, 0x71, 0x31, 0xE8, 0xFD, 0x01, 0x1E, 0x61, 0x2F, 0x3F, 0xC5, 0xD5, 0x01, 0x01, 0x01, 0x01, 
        0x6B, 0xE5, 0xC2, 0x3F, 0x58, 0x99, 0x68, 0x40, 0xC7, 0xC3, 0x95, 0x4E, 0x01, 0x01, 0x01, 0x01, 0xEF, 0xC9, 0x90, 0x2F, 0x7A, 0x4F, 0x22, 0x7F, 0x78, 0x2F, 0x55, 0x09, 0x10, 0x09, 0x27, 0xC3, 0x98, 0xF0, 0x01, 0x9F, 0x24, 0x31, 0x42, 0x43, 0x5A, 
        0x3C, 0x17, 0x0E, 0x56, 0x74, 0xCD, 0x42, 0x42, 0x3F, 0x66, 0x6A, 0x25, 0xCD, 0x18, 0x55, 0x1B, 0x11, 0x6C, 0x27, 0x3F, 0x9B, 0xF7, 0x01, 0x01, 0x01, 0x01, 0x01, 0x63, 0x5C, 0x73, 0x55, 0x8C, 0xB4, 0x52, 0x54, 0x8F, 0x75, 0xA1, 0x4F, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x80, 0x90, 0x1F, 0xB9, 0x0D, 0x10, 0x10, 0x11, 0x16, 0x0D, 0x1A, 0x09, 0x7A, 0x0F, 0x1E, 0x9C, 0x2A, 0x2C, 0x11, 0x90, 0x01, 0x01, 0x01, 0x01, 
        0x4F, 0xDF, 0x2A, 0x2C, 0x1F, 0x92, 0x01, 0xD0, 0x2A, 0x15, 0x3B, 0x5E, 0x01, 0x01, 0x01, 0xB0, 0x76, 0x1F, 0x19, 0x17, 0x25, 0x01, 0x9A, 0x8C, 0x19, 0x2C, 0xB6, 0x10, 0x10, 0x11, 0x39, 0xB9, 0x16, 0x56, 0x25, 0x22, 0x6A, 0x36, 0x36, 0x01, 0x49, 
        0x8F, 0x0D, 0x2C, 0x24, 0xAA, 0x6B, 0x36, 0x36, 0x4F, 0x84, 0xD4, 0x17, 0x19, 0x12, 0x16, 0x10, 0x11, 0x19, 0x2C, 0x38, 0x1A, 0x20, 0xF0, 0x01, 0x01, 0x01, 0x63, 0x71, 0x19, 0x0C, 0x0C, 0x10, 0x10, 0x10, 0x0C, 0x12, 0x19, 0x14, 0xE2, 0x22, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x69, 0x59, 0xB5, 0x14, 0x09, 0x6C, 0x94, 0x46, 0xD7, 0x2E, 0x15, 0x14, 0x1B, 0x6D, 0x9E, 0x01, 0x5E, 0x16, 0x14, 0x8B, 0x5B, 0x01, 0x01, 0x01, 0x01, 
        0x4F, 0xE1, 0x19, 0x14, 0x0C, 0x31, 0x01, 0x80, 0x56, 0x8B, 0x2C, 0x90, 0x83, 0x01, 0x01, 0xE7, 0x14, 0x3A, 0x2C, 0xCE, 0x01, 0x7D, 0x0E, 0x2C, 0x14, 0x09, 0x8F, 0x28, 0x46, 0x21, 0x18, 0x0E, 0x09, 0x15, 0x54, 0x62, 0x01, 0x01, 0x01, 0x01, 0x64, 
        0x2F, 0x0D, 0x0C, 0xCA, 0xF5, 0x01, 0x01, 0x01, 0x01, 0x79, 0x2C, 0x1B, 0x14, 0x09, 0x20, 0x97, 0x7A, 0xCD, 0x3C, 0x17, 0x09, 0x10, 0x18, 0x81, 0x01, 0x6A, 0xC3, 0x0D, 0x09, 0x0E, 0x27, 0x94, 0x5C, 0xD7, 0x18, 0x14, 0x14, 0x1B, 0x8B, 0x7F, 0x0F, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xF6, 0x2C, 0x14, 0x09, 0x54, 0x98, 0x01, 0x01, 0x0F, 0x32, 0x3D, 0x3A, 0x14, 0x3A, 0x40, 0x01, 0x5E, 0x16, 0x14, 0x8B, 0x5B, 0x01, 0x01, 0x01, 0x01, 
        0x4F, 0x99, 0x19, 0x14, 0x0C, 0x31, 0x01, 0x01, 0x9C, 0x15, 0xBB, 0x09, 0x97, 0x01, 0x82, 0x20, 0x16, 0x2C, 0x71, 0xF0, 0x01, 0x21, 0x23, 0x14, 0x2C, 0x72, 0xA8, 0x01, 0x01, 0x0F, 0xF1, 0x5B, 0x12, 0x14, 0x23, 0xCD, 0x35, 0x01, 0x01, 0x01, 0x26, 
        0x2E, 0x0D, 0x0C, 0x41, 0x34, 0x01, 0x01, 0x01, 0x6A, 0x30, 0x15, 0x14, 0x15, 0x74, 0x66, 0x01, 0x01, 0x4E, 0xE9, 0x6F, 0x3A, 0x3B, 0x2A, 0x5D, 0x01, 0xEC, 0x27, 0x0E, 0x09, 0x0D, 0x48, 0x1D, 0x01, 0x01, 0x65, 0x6E, 0xBB, 0x14, 0x0C, 0x45, 0x6A, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x7F, 0x1A, 0x14, 0x17, 0x70, 0xFF, 0x01, 0x01, 0x01, 0x1C, 0x46, 0x0C, 0x14, 0x0D, 0x3E, 0x01, 0x5E, 0x16, 0x14, 0x8B, 0x5B, 0x01, 0x01, 0x01, 0x01, 
        0x22, 0x47, 0x19, 0x14, 0x15, 0x92, 0x01, 0x01, 0x34, 0x59, 0x16, 0x12, 0x70, 0x32, 0x5F, 0x16, 0x0E, 0x09, 0x5C, 0x01, 0x13, 0x5A, 0x0C, 0x09, 0x12, 0xE1, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5F, 0x6D, 0x0E, 0x12, 0x72, 0x65, 0x01, 0x01, 0x01, 0x26, 
        0x2E, 0x0D, 0x0C, 0x41, 0x34, 0x01, 0x01, 0x01, 0xA4, 0x57, 0x1B, 0x17, 0x17, 0x7F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x75, 0x09, 0x09, 0x0C, 0xD1, 0x0F, 0xDE, 0x54, 0x09, 0x3A, 0x18, 0xAE, 0x01, 0x01, 0x01, 0x01, 0x40, 0x14, 0x14, 0x0D, 0x78, 0x1C, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0xA3, 0x0C, 0x14, 0x0E, 0x18, 0x01, 0x01, 0x01, 0x01, 0x6B, 0x9D, 0x16, 0x14, 0x1B, 0x30, 0x01, 0x5D, 0x16, 0x14, 0x0D, 0x3F, 0x01, 0x01, 0x01, 0x01, 
        0xAF, 0x77, 0x16, 0x09, 0x12, 0x76, 0x01, 0x01, 0x01, 0x61, 0x14, 0x3A, 0x09, 0x8F, 0x72, 0x0D, 0x8A, 0x5A, 0x67, 0x01, 0xAD, 0x24, 0x0C, 0x09, 0x2C, 0x47, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5E, 0xBB, 0x17, 0x2C, 0xC7, 0xAA, 0x01, 0x01, 0x01, 0x26, 
        0x2E, 0x0D, 0x0C, 0x41, 0x34, 0x01, 0x01, 0x01, 0x7C, 0x8E, 0x1B, 0x17, 0x1B, 0xEE, 0x01, 0x01, 0x01, 0x01, 0x01, 0x43, 0x17, 0x09, 0x15, 0x94, 0x01, 0xD6, 0x8D, 0x09, 0x12, 0x43, 0xB0, 0x01, 0x01, 0x01, 0x01, 0x21, 0x8D, 0x09, 0x0D, 0x28, 0x1C, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x7C, 0x0C, 0x14, 0x0E, 0x18, 0x01, 0x01, 0x01, 0x01, 0x6B, 0x25, 0x16, 0x14, 0x1B, 0x30, 0x01, 0x25, 0x1F, 0x14, 0x0E, 0x56, 0xE6, 0x01, 0x01, 0x01, 
        0x61, 0x3C, 0x0E, 0x17, 0x53, 0xE1, 0x01, 0x01, 0x01, 0x36, 0x28, 0x11, 0x09, 0x0D, 0x0D, 0x3A, 0x54, 0x5F, 0x01, 0x01, 0x0F, 0x21, 0x1F, 0x14, 0x12, 0xC1, 0x4A, 0x01, 0x01, 0x0F, 0x26, 0xC6, 0x38, 0x3B, 0x1F, 0x28, 0x0F, 0x01, 0x01, 0x01, 0x26, 
        0x2E, 0x0D, 0x0C, 0x41, 0x34, 0x01, 0x01, 0x01, 0x85, 0xC4, 0x0C, 0x14, 0x1A, 0xCC, 0xF9, 0x01, 0x01, 0x1D, 0x29, 0x6F, 0x1B, 0x14, 0x10, 0xEB, 0x01, 0x79, 0x53, 0x09, 0x2C, 0x77, 0xB1, 0x01, 0x01, 0x01, 0x01, 0xCF, 0x6C, 0x09, 0x0D, 0x28, 0x1C, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x7C, 0x0C, 0x14, 0x0E, 0x18, 0x01, 0x01, 0x01, 0x01, 0x6B, 0x25, 0x16, 0x14, 0x1B, 0x20, 0x01, 0xF3, 0x3C, 0x0C, 0x14, 0x09, 0x57, 0xD5, 0x47, 0x78, 
        0x18, 0x0C, 0x3B, 0x16, 0xC0, 0x65, 0x01, 0x01, 0x01, 0x01, 0x4A, 0x27, 0x0D, 0x14, 0x14, 0x38, 0x42, 0x6B, 0x01, 0x01, 0x01, 0x7C, 0xBB, 0x2C, 0x14, 0x17, 0x58, 0x79, 0xD8, 0xCF, 0x3D, 0x0E, 0x14, 0x2C, 0x09, 0x61, 0x01, 0x01, 0x01, 0x01, 0x26, 
        0x2E, 0x0D, 0x0C, 0x41, 0x34, 0x01, 0x01, 0x01, 0x01, 0x96, 0x8B, 0x3A, 0x14, 0x0E, 0x24, 0x45, 0xD7, 0x76, 0x3C, 0x0E, 0x14, 0x15, 0x27, 0x13, 0x01, 0x96, 0x53, 0x09, 0x2C, 0x44, 0xB1, 0x01, 0x01, 0x01, 0x01, 0xCF, 0x6C, 0x09, 0x0D, 0x28, 0x1C, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0xA2, 0x1F, 0x0C, 0x1A, 0x6F, 0x01, 0x01, 0x01, 0x01, 0x6B, 0xE4, 0x2A, 0x0C, 0x19, 0x2F, 0x01, 0x6B, 0xA3, 0x6E, 0x1F, 0x8B, 0x2C, 0x16, 0x0C, 0x11, 
        0xB8, 0x0D, 0x10, 0x27, 0x29, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xE1, 0x1F, 0x0C, 0x10, 0x57, 0xED, 0x01, 0x01, 0x01, 0x01, 0x1C, 0x5D, 0xBD, 0x23, 0x12, 0x0C, 0x19, 0x19, 0x1A, 0x2C, 0x12, 0x10, 0x14, 0x9A, 0x6A, 0x01, 0x01, 0x01, 0x01, 0xEE, 
        0x70, 0x10, 0x1F, 0xC8, 0x4C, 0x01, 0x01, 0x01, 0x01, 0x4D, 0x94, 0x2D, 0x16, 0x8B, 0x38, 0x19, 0x19, 0x15, 0x8B, 0x2C, 0x1F, 0xC0, 0x29, 0x6B, 0x01, 0x21, 0x1B, 0x15, 0x10, 0x43, 0x35, 0x01, 0x01, 0x01, 0x01, 0x43, 0x0D, 0x0C, 0x11, 0x77, 0x1C, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x63, 0xC7, 0x24, 0x59, 0x75, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x7E, 0xC3, 0x24, 0xC8, 0x21, 0x01, 0x01, 0x4F, 0x32, 0x78, 0x18, 0x8D, 0x10, 0x2B, 0xBA, 
        0xBE, 0x2F, 0x78, 0x32, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x13, 0x93, 0x90, 0x20, 0x7B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1C, 0xA5, 0xD3, 0x18, 0xBB, 0x10, 0x1F, 0x10, 0xBB, 0x18, 0x44, 0x7D, 0x69, 0x01, 0x01, 0x01, 0x01, 0x01, 0x4B, 
        0x44, 0x30, 0xC7, 0x45, 0x68, 0x01, 0x01, 0x01, 0x01, 0x01, 0x4D, 0x60, 0xCB, 0xBF, 0x0D, 0x10, 0x1F, 0x10, 0x6D, 0x90, 0x95, 0x4A, 0x6B, 0x01, 0x01, 0x5E, 0x91, 0x5A, 0x20, 0x9B, 0x4E, 0x01, 0x01, 0x01, 0x01, 0xE3, 0x40, 0x5A, 0x30, 0x7B, 0x4F, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x36, 0x82, 0x13, 0x13, 0x83, 0x01, 0x01, 0x01, 0x01, 0x01, 0x69, 0x33, 0x13, 0x13, 0x67, 0x01, 0x01, 0x01, 0x01, 0x6A, 0x80, 0x7E, 0x60, 0x25, 0xA2, 
        0x63, 0x66, 0x4E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x35, 0x81, 0x13, 0x35, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x69, 0xA9, 0x62, 0xA0, 0x25, 0xA0, 0x62, 0xA9, 0x69, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x22, 
        0x84, 0x13, 0x82, 0xAE, 0x6B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x67, 0x4A, 0x7C, 0x9F, 0x25, 0x60, 0xA5, 0x81, 0x6B, 0x01, 0x01, 0x01, 0x01, 0x85, 0x4C, 0x13, 0x82, 0x4D, 0x0F, 0x01, 0x01, 0x01, 0x01, 0x4D, 0x4C, 0x13, 0x13, 0x85, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B, 0x03, 0x04, 0x00,
  0x00, 0x04, 0x08, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01